// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
namespace ccc { 
struct  AA0  {
  virtual void  abc(); // _ZN3ccc3AA03abcEv
  virtual void  efg(); // _ZN3ccc3AA03efgEv
  virtual void  pqr(); // _ZN3ccc3AA03pqrEv
  ~AA0(); // tgen
  AA0(); // tgen
};
//SIG(1 _ZN3ccc3AA0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA0 ::abc(){vfunc_called(this, "_ZN3ccc3AA03abcEv");}
void  ccc::AA0 ::efg(){vfunc_called(this, "_ZN3ccc3AA03efgEv");}
void  ccc::AA0 ::pqr(){vfunc_called(this, "_ZN3ccc3AA03pqrEv");}
ccc::AA0 ::~AA0(){ note_dtor("_ZN3ccc3AA0E", this);} // tgen
ccc::AA0 ::AA0(){ note_ctor("_ZN3ccc3AA0E", this);} // tgen
}
static void Test__ZN3ccc3AA0E()
{
  extern Class_Descriptor cd__ZN3ccc3AA0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA0E, buf);
    ::ccc::AA0 *dp, &lv = *(dp=new (buf) ::ccc::AA0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA0E)");
    test_class_info(&lv, &cd__ZN3ccc3AA0E);
    dp->::ccc::AA0::~AA0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA0E(Test__ZN3ccc3AA0E, "_ZN3ccc3AA0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA0C1Ev();
extern void _ZN3ccc3AA0D1Ev();
Name_Map name_map__ZN3ccc3AA0E[] = {
  NSPAIR(_ZN3ccc3AA0C1Ev),
  NSPAIR(_ZN3ccc3AA0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
Class_Descriptor cd__ZN3ccc3AA0E = {  "_ZN3ccc3AA0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB0  {
  virtual void  abc(); // _ZN3ccc3BB03abcEv
  virtual void  efg(); // _ZN3ccc3BB03efgEv
  virtual void  pqr(); // _ZN3ccc3BB03pqrEv
  ~BB0(); // tgen
  BB0(); // tgen
};
//SIG(-1 _ZN3ccc3BB0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB0 ::abc(){vfunc_called(this, "_ZN3ccc3BB03abcEv");}
void  ccc::BB0 ::efg(){vfunc_called(this, "_ZN3ccc3BB03efgEv");}
void  ccc::BB0 ::pqr(){vfunc_called(this, "_ZN3ccc3BB03pqrEv");}
ccc::BB0 ::~BB0(){ note_dtor("_ZN3ccc3BB0E", this);} // tgen
ccc::BB0 ::BB0(){ note_ctor("_ZN3ccc3BB0E", this);} // tgen
}
static void Test__ZN3ccc3BB0E()
{
  extern Class_Descriptor cd__ZN3ccc3BB0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB0E, buf);
    ::ccc::BB0 *dp, &lv = *(dp=new (buf) ::ccc::BB0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB0E)");
    test_class_info(&lv, &cd__ZN3ccc3BB0E);
    dp->::ccc::BB0::~BB0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB0E(Test__ZN3ccc3BB0E, "_ZN3ccc3BB0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB0C1Ev();
extern void _ZN3ccc3BB0D1Ev();
Name_Map name_map__ZN3ccc3BB0E[] = {
  NSPAIR(_ZN3ccc3BB0C1Ev),
  NSPAIR(_ZN3ccc3BB0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern void _ZN3ccc3BB03abcEv();
extern void _ZN3ccc3BB03efgEv();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
Class_Descriptor cd__ZN3ccc3BB0E = {  "_ZN3ccc3BB0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA1  {
  virtual void  abc(); // _ZN3ccc3AA13abcEv
  virtual void  pqr(); // _ZN3ccc3AA13pqrEv
  virtual void  efg(); // _ZN3ccc3AA13efgEv
  ~AA1(); // tgen
  AA1(); // tgen
};
//SIG(1 _ZN3ccc3AA1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA1 ::abc(){vfunc_called(this, "_ZN3ccc3AA13abcEv");}
void  ccc::AA1 ::pqr(){vfunc_called(this, "_ZN3ccc3AA13pqrEv");}
void  ccc::AA1 ::efg(){vfunc_called(this, "_ZN3ccc3AA13efgEv");}
ccc::AA1 ::~AA1(){ note_dtor("_ZN3ccc3AA1E", this);} // tgen
ccc::AA1 ::AA1(){ note_ctor("_ZN3ccc3AA1E", this);} // tgen
}
static void Test__ZN3ccc3AA1E()
{
  extern Class_Descriptor cd__ZN3ccc3AA1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA1E, buf);
    ::ccc::AA1 *dp, &lv = *(dp=new (buf) ::ccc::AA1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA1E)");
    test_class_info(&lv, &cd__ZN3ccc3AA1E);
    dp->::ccc::AA1::~AA1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA1E(Test__ZN3ccc3AA1E, "_ZN3ccc3AA1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA1C1Ev();
extern void _ZN3ccc3AA1D1Ev();
Name_Map name_map__ZN3ccc3AA1E[] = {
  NSPAIR(_ZN3ccc3AA1C1Ev),
  NSPAIR(_ZN3ccc3AA1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
Class_Descriptor cd__ZN3ccc3AA1E = {  "_ZN3ccc3AA1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB1  {
  virtual void  abc(); // _ZN3ccc3BB13abcEv
  virtual void  pqr(); // _ZN3ccc3BB13pqrEv
  virtual void  efg(); // _ZN3ccc3BB13efgEv
  ~BB1(); // tgen
  BB1(); // tgen
};
//SIG(-1 _ZN3ccc3BB1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB1 ::abc(){vfunc_called(this, "_ZN3ccc3BB13abcEv");}
void  ccc::BB1 ::pqr(){vfunc_called(this, "_ZN3ccc3BB13pqrEv");}
void  ccc::BB1 ::efg(){vfunc_called(this, "_ZN3ccc3BB13efgEv");}
ccc::BB1 ::~BB1(){ note_dtor("_ZN3ccc3BB1E", this);} // tgen
ccc::BB1 ::BB1(){ note_ctor("_ZN3ccc3BB1E", this);} // tgen
}
static void Test__ZN3ccc3BB1E()
{
  extern Class_Descriptor cd__ZN3ccc3BB1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB1E, buf);
    ::ccc::BB1 *dp, &lv = *(dp=new (buf) ::ccc::BB1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB1E)");
    test_class_info(&lv, &cd__ZN3ccc3BB1E);
    dp->::ccc::BB1::~BB1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB1E(Test__ZN3ccc3BB1E, "_ZN3ccc3BB1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB1C1Ev();
extern void _ZN3ccc3BB1D1Ev();
Name_Map name_map__ZN3ccc3BB1E[] = {
  NSPAIR(_ZN3ccc3BB1C1Ev),
  NSPAIR(_ZN3ccc3BB1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern void _ZN3ccc3BB13abcEv();
extern void _ZN3ccc3BB13pqrEv();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
Class_Descriptor cd__ZN3ccc3BB1E = {  "_ZN3ccc3BB1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA2  {
  virtual void  efg(); // _ZN3ccc3AA23efgEv
  virtual void  abc(); // _ZN3ccc3AA23abcEv
  virtual void  pqr(); // _ZN3ccc3AA23pqrEv
  ~AA2(); // tgen
  AA2(); // tgen
};
//SIG(1 _ZN3ccc3AA2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA2 ::efg(){vfunc_called(this, "_ZN3ccc3AA23efgEv");}
void  ccc::AA2 ::abc(){vfunc_called(this, "_ZN3ccc3AA23abcEv");}
void  ccc::AA2 ::pqr(){vfunc_called(this, "_ZN3ccc3AA23pqrEv");}
ccc::AA2 ::~AA2(){ note_dtor("_ZN3ccc3AA2E", this);} // tgen
ccc::AA2 ::AA2(){ note_ctor("_ZN3ccc3AA2E", this);} // tgen
}
static void Test__ZN3ccc3AA2E()
{
  extern Class_Descriptor cd__ZN3ccc3AA2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA2E, buf);
    ::ccc::AA2 *dp, &lv = *(dp=new (buf) ::ccc::AA2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA2E)");
    test_class_info(&lv, &cd__ZN3ccc3AA2E);
    dp->::ccc::AA2::~AA2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA2E(Test__ZN3ccc3AA2E, "_ZN3ccc3AA2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA2C1Ev();
extern void _ZN3ccc3AA2D1Ev();
Name_Map name_map__ZN3ccc3AA2E[] = {
  NSPAIR(_ZN3ccc3AA2C1Ev),
  NSPAIR(_ZN3ccc3AA2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
Class_Descriptor cd__ZN3ccc3AA2E = {  "_ZN3ccc3AA2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB2  {
  virtual void  efg(); // _ZN3ccc3BB23efgEv
  virtual void  abc(); // _ZN3ccc3BB23abcEv
  virtual void  pqr(); // _ZN3ccc3BB23pqrEv
  ~BB2(); // tgen
  BB2(); // tgen
};
//SIG(-1 _ZN3ccc3BB2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB2 ::efg(){vfunc_called(this, "_ZN3ccc3BB23efgEv");}
void  ccc::BB2 ::abc(){vfunc_called(this, "_ZN3ccc3BB23abcEv");}
void  ccc::BB2 ::pqr(){vfunc_called(this, "_ZN3ccc3BB23pqrEv");}
ccc::BB2 ::~BB2(){ note_dtor("_ZN3ccc3BB2E", this);} // tgen
ccc::BB2 ::BB2(){ note_ctor("_ZN3ccc3BB2E", this);} // tgen
}
static void Test__ZN3ccc3BB2E()
{
  extern Class_Descriptor cd__ZN3ccc3BB2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB2E, buf);
    ::ccc::BB2 *dp, &lv = *(dp=new (buf) ::ccc::BB2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB2E)");
    test_class_info(&lv, &cd__ZN3ccc3BB2E);
    dp->::ccc::BB2::~BB2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB2E(Test__ZN3ccc3BB2E, "_ZN3ccc3BB2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB2C1Ev();
extern void _ZN3ccc3BB2D1Ev();
Name_Map name_map__ZN3ccc3BB2E[] = {
  NSPAIR(_ZN3ccc3BB2C1Ev),
  NSPAIR(_ZN3ccc3BB2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern void _ZN3ccc3BB23efgEv();
extern void _ZN3ccc3BB23abcEv();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
Class_Descriptor cd__ZN3ccc3BB2E = {  "_ZN3ccc3BB2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA3  {
  virtual void  efg(); // _ZN3ccc3AA33efgEv
  virtual void  pqr(); // _ZN3ccc3AA33pqrEv
  virtual void  abc(); // _ZN3ccc3AA33abcEv
  ~AA3(); // tgen
  AA3(); // tgen
};
//SIG(1 _ZN3ccc3AA3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA3 ::efg(){vfunc_called(this, "_ZN3ccc3AA33efgEv");}
void  ccc::AA3 ::pqr(){vfunc_called(this, "_ZN3ccc3AA33pqrEv");}
void  ccc::AA3 ::abc(){vfunc_called(this, "_ZN3ccc3AA33abcEv");}
ccc::AA3 ::~AA3(){ note_dtor("_ZN3ccc3AA3E", this);} // tgen
ccc::AA3 ::AA3(){ note_ctor("_ZN3ccc3AA3E", this);} // tgen
}
static void Test__ZN3ccc3AA3E()
{
  extern Class_Descriptor cd__ZN3ccc3AA3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA3E, buf);
    ::ccc::AA3 *dp, &lv = *(dp=new (buf) ::ccc::AA3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA3E)");
    test_class_info(&lv, &cd__ZN3ccc3AA3E);
    dp->::ccc::AA3::~AA3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA3E(Test__ZN3ccc3AA3E, "_ZN3ccc3AA3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA3C1Ev();
extern void _ZN3ccc3AA3D1Ev();
Name_Map name_map__ZN3ccc3AA3E[] = {
  NSPAIR(_ZN3ccc3AA3C1Ev),
  NSPAIR(_ZN3ccc3AA3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
Class_Descriptor cd__ZN3ccc3AA3E = {  "_ZN3ccc3AA3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB3  {
  virtual void  efg(); // _ZN3ccc3BB33efgEv
  virtual void  pqr(); // _ZN3ccc3BB33pqrEv
  virtual void  abc(); // _ZN3ccc3BB33abcEv
  ~BB3(); // tgen
  BB3(); // tgen
};
//SIG(-1 _ZN3ccc3BB3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB3 ::efg(){vfunc_called(this, "_ZN3ccc3BB33efgEv");}
void  ccc::BB3 ::pqr(){vfunc_called(this, "_ZN3ccc3BB33pqrEv");}
void  ccc::BB3 ::abc(){vfunc_called(this, "_ZN3ccc3BB33abcEv");}
ccc::BB3 ::~BB3(){ note_dtor("_ZN3ccc3BB3E", this);} // tgen
ccc::BB3 ::BB3(){ note_ctor("_ZN3ccc3BB3E", this);} // tgen
}
static void Test__ZN3ccc3BB3E()
{
  extern Class_Descriptor cd__ZN3ccc3BB3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB3E, buf);
    ::ccc::BB3 *dp, &lv = *(dp=new (buf) ::ccc::BB3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB3E)");
    test_class_info(&lv, &cd__ZN3ccc3BB3E);
    dp->::ccc::BB3::~BB3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB3E(Test__ZN3ccc3BB3E, "_ZN3ccc3BB3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB3C1Ev();
extern void _ZN3ccc3BB3D1Ev();
Name_Map name_map__ZN3ccc3BB3E[] = {
  NSPAIR(_ZN3ccc3BB3C1Ev),
  NSPAIR(_ZN3ccc3BB3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
Class_Descriptor cd__ZN3ccc3BB3E = {  "_ZN3ccc3BB3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA4  {
  virtual void  pqr(); // _ZN3ccc3AA43pqrEv
  virtual void  abc(); // _ZN3ccc3AA43abcEv
  virtual void  efg(); // _ZN3ccc3AA43efgEv
  ~AA4(); // tgen
  AA4(); // tgen
};
//SIG(1 _ZN3ccc3AA4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA4 ::pqr(){vfunc_called(this, "_ZN3ccc3AA43pqrEv");}
void  ccc::AA4 ::abc(){vfunc_called(this, "_ZN3ccc3AA43abcEv");}
void  ccc::AA4 ::efg(){vfunc_called(this, "_ZN3ccc3AA43efgEv");}
ccc::AA4 ::~AA4(){ note_dtor("_ZN3ccc3AA4E", this);} // tgen
ccc::AA4 ::AA4(){ note_ctor("_ZN3ccc3AA4E", this);} // tgen
}
static void Test__ZN3ccc3AA4E()
{
  extern Class_Descriptor cd__ZN3ccc3AA4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA4E, buf);
    ::ccc::AA4 *dp, &lv = *(dp=new (buf) ::ccc::AA4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA4E)");
    test_class_info(&lv, &cd__ZN3ccc3AA4E);
    dp->::ccc::AA4::~AA4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA4E(Test__ZN3ccc3AA4E, "_ZN3ccc3AA4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA4C1Ev();
extern void _ZN3ccc3AA4D1Ev();
Name_Map name_map__ZN3ccc3AA4E[] = {
  NSPAIR(_ZN3ccc3AA4C1Ev),
  NSPAIR(_ZN3ccc3AA4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
Class_Descriptor cd__ZN3ccc3AA4E = {  "_ZN3ccc3AA4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB4  {
  virtual void  pqr(); // _ZN3ccc3BB43pqrEv
  virtual void  abc(); // _ZN3ccc3BB43abcEv
  virtual void  efg(); // _ZN3ccc3BB43efgEv
  ~BB4(); // tgen
  BB4(); // tgen
};
//SIG(-1 _ZN3ccc3BB4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB4 ::pqr(){vfunc_called(this, "_ZN3ccc3BB43pqrEv");}
void  ccc::BB4 ::abc(){vfunc_called(this, "_ZN3ccc3BB43abcEv");}
void  ccc::BB4 ::efg(){vfunc_called(this, "_ZN3ccc3BB43efgEv");}
ccc::BB4 ::~BB4(){ note_dtor("_ZN3ccc3BB4E", this);} // tgen
ccc::BB4 ::BB4(){ note_ctor("_ZN3ccc3BB4E", this);} // tgen
}
static void Test__ZN3ccc3BB4E()
{
  extern Class_Descriptor cd__ZN3ccc3BB4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB4E, buf);
    ::ccc::BB4 *dp, &lv = *(dp=new (buf) ::ccc::BB4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB4E)");
    test_class_info(&lv, &cd__ZN3ccc3BB4E);
    dp->::ccc::BB4::~BB4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB4E(Test__ZN3ccc3BB4E, "_ZN3ccc3BB4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB4C1Ev();
extern void _ZN3ccc3BB4D1Ev();
Name_Map name_map__ZN3ccc3BB4E[] = {
  NSPAIR(_ZN3ccc3BB4C1Ev),
  NSPAIR(_ZN3ccc3BB4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
Class_Descriptor cd__ZN3ccc3BB4E = {  "_ZN3ccc3BB4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA5  {
  virtual void  pqr(); // _ZN3ccc3AA53pqrEv
  virtual void  efg(); // _ZN3ccc3AA53efgEv
  virtual void  abc(); // _ZN3ccc3AA53abcEv
  ~AA5(); // tgen
  AA5(); // tgen
};
//SIG(-1 _ZN3ccc3AA5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA5 ::pqr(){vfunc_called(this, "_ZN3ccc3AA53pqrEv");}
void  ccc::AA5 ::efg(){vfunc_called(this, "_ZN3ccc3AA53efgEv");}
void  ccc::AA5 ::abc(){vfunc_called(this, "_ZN3ccc3AA53abcEv");}
ccc::AA5 ::~AA5(){ note_dtor("_ZN3ccc3AA5E", this);} // tgen
ccc::AA5 ::AA5(){ note_ctor("_ZN3ccc3AA5E", this);} // tgen
}
static void Test__ZN3ccc3AA5E()
{
  extern Class_Descriptor cd__ZN3ccc3AA5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA5E, buf);
    ::ccc::AA5 *dp, &lv = *(dp=new (buf) ::ccc::AA5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA5E)");
    test_class_info(&lv, &cd__ZN3ccc3AA5E);
    dp->::ccc::AA5::~AA5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA5E(Test__ZN3ccc3AA5E, "_ZN3ccc3AA5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA5C1Ev();
extern void _ZN3ccc3AA5D1Ev();
Name_Map name_map__ZN3ccc3AA5E[] = {
  NSPAIR(_ZN3ccc3AA5C1Ev),
  NSPAIR(_ZN3ccc3AA5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
Class_Descriptor cd__ZN3ccc3AA5E = {  "_ZN3ccc3AA5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB5  {
  virtual void  pqr(); // _ZN3ccc3BB53pqrEv
  virtual void  efg(); // _ZN3ccc3BB53efgEv
  virtual void  abc(); // _ZN3ccc3BB53abcEv
  ~BB5(); // tgen
  BB5(); // tgen
};
//SIG(-1 _ZN3ccc3BB5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB5 ::pqr(){vfunc_called(this, "_ZN3ccc3BB53pqrEv");}
void  ccc::BB5 ::efg(){vfunc_called(this, "_ZN3ccc3BB53efgEv");}
void  ccc::BB5 ::abc(){vfunc_called(this, "_ZN3ccc3BB53abcEv");}
ccc::BB5 ::~BB5(){ note_dtor("_ZN3ccc3BB5E", this);} // tgen
ccc::BB5 ::BB5(){ note_ctor("_ZN3ccc3BB5E", this);} // tgen
}
static void Test__ZN3ccc3BB5E()
{
  extern Class_Descriptor cd__ZN3ccc3BB5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB5E, buf);
    ::ccc::BB5 *dp, &lv = *(dp=new (buf) ::ccc::BB5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB5E)");
    test_class_info(&lv, &cd__ZN3ccc3BB5E);
    dp->::ccc::BB5::~BB5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB5E(Test__ZN3ccc3BB5E, "_ZN3ccc3BB5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB5C1Ev();
extern void _ZN3ccc3BB5D1Ev();
Name_Map name_map__ZN3ccc3BB5E[] = {
  NSPAIR(_ZN3ccc3BB5C1Ev),
  NSPAIR(_ZN3ccc3BB5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
Class_Descriptor cd__ZN3ccc3BB5E = {  "_ZN3ccc3BB5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA6  {
  virtual void  abc(); // _ZN3ccc3AA63abcEv
  virtual void  efg(); // _ZN3ccc3AA63efgEv
  ~AA6(); // tgen
  AA6(); // tgen
};
//SIG(-1 _ZN3ccc3AA6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA6 ::abc(){vfunc_called(this, "_ZN3ccc3AA63abcEv");}
void  ccc::AA6 ::efg(){vfunc_called(this, "_ZN3ccc3AA63efgEv");}
ccc::AA6 ::~AA6(){ note_dtor("_ZN3ccc3AA6E", this);} // tgen
ccc::AA6 ::AA6(){ note_ctor("_ZN3ccc3AA6E", this);} // tgen
}
static void Test__ZN3ccc3AA6E()
{
  extern Class_Descriptor cd__ZN3ccc3AA6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA6E, buf);
    ::ccc::AA6 *dp, &lv = *(dp=new (buf) ::ccc::AA6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA6E)");
    test_class_info(&lv, &cd__ZN3ccc3AA6E);
    dp->::ccc::AA6::~AA6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA6E(Test__ZN3ccc3AA6E, "_ZN3ccc3AA6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA6C1Ev();
extern void _ZN3ccc3AA6D1Ev();
Name_Map name_map__ZN3ccc3AA6E[] = {
  NSPAIR(_ZN3ccc3AA6C1Ev),
  NSPAIR(_ZN3ccc3AA6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc3AA63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
Class_Descriptor cd__ZN3ccc3AA6E = {  "_ZN3ccc3AA6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB6  {
  virtual void  abc(); // _ZN3ccc3BB63abcEv
  virtual void  efg(); // _ZN3ccc3BB63efgEv
  ~BB6(); // tgen
  BB6(); // tgen
};
//SIG(-1 _ZN3ccc3BB6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB6 ::abc(){vfunc_called(this, "_ZN3ccc3BB63abcEv");}
void  ccc::BB6 ::efg(){vfunc_called(this, "_ZN3ccc3BB63efgEv");}
ccc::BB6 ::~BB6(){ note_dtor("_ZN3ccc3BB6E", this);} // tgen
ccc::BB6 ::BB6(){ note_ctor("_ZN3ccc3BB6E", this);} // tgen
}
static void Test__ZN3ccc3BB6E()
{
  extern Class_Descriptor cd__ZN3ccc3BB6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB6E, buf);
    ::ccc::BB6 *dp, &lv = *(dp=new (buf) ::ccc::BB6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB6E)");
    test_class_info(&lv, &cd__ZN3ccc3BB6E);
    dp->::ccc::BB6::~BB6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB6E(Test__ZN3ccc3BB6E, "_ZN3ccc3BB6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB6C1Ev();
extern void _ZN3ccc3BB6D1Ev();
Name_Map name_map__ZN3ccc3BB6E[] = {
  NSPAIR(_ZN3ccc3BB6C1Ev),
  NSPAIR(_ZN3ccc3BB6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
Class_Descriptor cd__ZN3ccc3BB6E = {  "_ZN3ccc3BB6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA7  {
  virtual void  abc(); // _ZN3ccc3AA73abcEv
  virtual void  pqr(); // _ZN3ccc3AA73pqrEv
  ~AA7(); // tgen
  AA7(); // tgen
};
//SIG(-1 _ZN3ccc3AA7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA7 ::abc(){vfunc_called(this, "_ZN3ccc3AA73abcEv");}
void  ccc::AA7 ::pqr(){vfunc_called(this, "_ZN3ccc3AA73pqrEv");}
ccc::AA7 ::~AA7(){ note_dtor("_ZN3ccc3AA7E", this);} // tgen
ccc::AA7 ::AA7(){ note_ctor("_ZN3ccc3AA7E", this);} // tgen
}
static void Test__ZN3ccc3AA7E()
{
  extern Class_Descriptor cd__ZN3ccc3AA7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA7E, buf);
    ::ccc::AA7 *dp, &lv = *(dp=new (buf) ::ccc::AA7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA7E)");
    test_class_info(&lv, &cd__ZN3ccc3AA7E);
    dp->::ccc::AA7::~AA7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA7E(Test__ZN3ccc3AA7E, "_ZN3ccc3AA7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA7C1Ev();
extern void _ZN3ccc3AA7D1Ev();
Name_Map name_map__ZN3ccc3AA7E[] = {
  NSPAIR(_ZN3ccc3AA7C1Ev),
  NSPAIR(_ZN3ccc3AA7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc3AA73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
Class_Descriptor cd__ZN3ccc3AA7E = {  "_ZN3ccc3AA7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB7  {
  virtual void  abc(); // _ZN3ccc3BB73abcEv
  virtual void  pqr(); // _ZN3ccc3BB73pqrEv
  ~BB7(); // tgen
  BB7(); // tgen
};
//SIG(-1 _ZN3ccc3BB7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB7 ::abc(){vfunc_called(this, "_ZN3ccc3BB73abcEv");}
void  ccc::BB7 ::pqr(){vfunc_called(this, "_ZN3ccc3BB73pqrEv");}
ccc::BB7 ::~BB7(){ note_dtor("_ZN3ccc3BB7E", this);} // tgen
ccc::BB7 ::BB7(){ note_ctor("_ZN3ccc3BB7E", this);} // tgen
}
static void Test__ZN3ccc3BB7E()
{
  extern Class_Descriptor cd__ZN3ccc3BB7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB7E, buf);
    ::ccc::BB7 *dp, &lv = *(dp=new (buf) ::ccc::BB7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB7E)");
    test_class_info(&lv, &cd__ZN3ccc3BB7E);
    dp->::ccc::BB7::~BB7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB7E(Test__ZN3ccc3BB7E, "_ZN3ccc3BB7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB7C1Ev();
extern void _ZN3ccc3BB7D1Ev();
Name_Map name_map__ZN3ccc3BB7E[] = {
  NSPAIR(_ZN3ccc3BB7C1Ev),
  NSPAIR(_ZN3ccc3BB7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
Class_Descriptor cd__ZN3ccc3BB7E = {  "_ZN3ccc3BB7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA8  {
  virtual void  efg(); // _ZN3ccc3AA83efgEv
  virtual void  abc(); // _ZN3ccc3AA83abcEv
  ~AA8(); // tgen
  AA8(); // tgen
};
//SIG(-1 _ZN3ccc3AA8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA8 ::efg(){vfunc_called(this, "_ZN3ccc3AA83efgEv");}
void  ccc::AA8 ::abc(){vfunc_called(this, "_ZN3ccc3AA83abcEv");}
ccc::AA8 ::~AA8(){ note_dtor("_ZN3ccc3AA8E", this);} // tgen
ccc::AA8 ::AA8(){ note_ctor("_ZN3ccc3AA8E", this);} // tgen
}
static void Test__ZN3ccc3AA8E()
{
  extern Class_Descriptor cd__ZN3ccc3AA8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA8E, buf);
    ::ccc::AA8 *dp, &lv = *(dp=new (buf) ::ccc::AA8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA8E)");
    test_class_info(&lv, &cd__ZN3ccc3AA8E);
    dp->::ccc::AA8::~AA8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA8E(Test__ZN3ccc3AA8E, "_ZN3ccc3AA8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA8C1Ev();
extern void _ZN3ccc3AA8D1Ev();
Name_Map name_map__ZN3ccc3AA8E[] = {
  NSPAIR(_ZN3ccc3AA8C1Ev),
  NSPAIR(_ZN3ccc3AA8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc3AA83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
Class_Descriptor cd__ZN3ccc3AA8E = {  "_ZN3ccc3AA8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB8  {
  virtual void  efg(); // _ZN3ccc3BB83efgEv
  virtual void  abc(); // _ZN3ccc3BB83abcEv
  ~BB8(); // tgen
  BB8(); // tgen
};
//SIG(-1 _ZN3ccc3BB8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB8 ::efg(){vfunc_called(this, "_ZN3ccc3BB83efgEv");}
void  ccc::BB8 ::abc(){vfunc_called(this, "_ZN3ccc3BB83abcEv");}
ccc::BB8 ::~BB8(){ note_dtor("_ZN3ccc3BB8E", this);} // tgen
ccc::BB8 ::BB8(){ note_ctor("_ZN3ccc3BB8E", this);} // tgen
}
static void Test__ZN3ccc3BB8E()
{
  extern Class_Descriptor cd__ZN3ccc3BB8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB8E, buf);
    ::ccc::BB8 *dp, &lv = *(dp=new (buf) ::ccc::BB8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB8E)");
    test_class_info(&lv, &cd__ZN3ccc3BB8E);
    dp->::ccc::BB8::~BB8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB8E(Test__ZN3ccc3BB8E, "_ZN3ccc3BB8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB8C1Ev();
extern void _ZN3ccc3BB8D1Ev();
Name_Map name_map__ZN3ccc3BB8E[] = {
  NSPAIR(_ZN3ccc3BB8C1Ev),
  NSPAIR(_ZN3ccc3BB8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
Class_Descriptor cd__ZN3ccc3BB8E = {  "_ZN3ccc3BB8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA9  {
  virtual void  efg(); // _ZN3ccc3AA93efgEv
  virtual void  pqr(); // _ZN3ccc3AA93pqrEv
  ~AA9(); // tgen
  AA9(); // tgen
};
//SIG(-1 _ZN3ccc3AA9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA9 ::efg(){vfunc_called(this, "_ZN3ccc3AA93efgEv");}
void  ccc::AA9 ::pqr(){vfunc_called(this, "_ZN3ccc3AA93pqrEv");}
ccc::AA9 ::~AA9(){ note_dtor("_ZN3ccc3AA9E", this);} // tgen
ccc::AA9 ::AA9(){ note_ctor("_ZN3ccc3AA9E", this);} // tgen
}
static void Test__ZN3ccc3AA9E()
{
  extern Class_Descriptor cd__ZN3ccc3AA9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA9E, buf);
    ::ccc::AA9 *dp, &lv = *(dp=new (buf) ::ccc::AA9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA9E)");
    test_class_info(&lv, &cd__ZN3ccc3AA9E);
    dp->::ccc::AA9::~AA9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA9E(Test__ZN3ccc3AA9E, "_ZN3ccc3AA9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA9C1Ev();
extern void _ZN3ccc3AA9D1Ev();
Name_Map name_map__ZN3ccc3AA9E[] = {
  NSPAIR(_ZN3ccc3AA9C1Ev),
  NSPAIR(_ZN3ccc3AA9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc3AA93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
Class_Descriptor cd__ZN3ccc3AA9E = {  "_ZN3ccc3AA9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB9  {
  virtual void  efg(); // _ZN3ccc3BB93efgEv
  virtual void  pqr(); // _ZN3ccc3BB93pqrEv
  ~BB9(); // tgen
  BB9(); // tgen
};
//SIG(-1 _ZN3ccc3BB9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB9 ::efg(){vfunc_called(this, "_ZN3ccc3BB93efgEv");}
void  ccc::BB9 ::pqr(){vfunc_called(this, "_ZN3ccc3BB93pqrEv");}
ccc::BB9 ::~BB9(){ note_dtor("_ZN3ccc3BB9E", this);} // tgen
ccc::BB9 ::BB9(){ note_ctor("_ZN3ccc3BB9E", this);} // tgen
}
static void Test__ZN3ccc3BB9E()
{
  extern Class_Descriptor cd__ZN3ccc3BB9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB9E, buf);
    ::ccc::BB9 *dp, &lv = *(dp=new (buf) ::ccc::BB9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB9E)");
    test_class_info(&lv, &cd__ZN3ccc3BB9E);
    dp->::ccc::BB9::~BB9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB9E(Test__ZN3ccc3BB9E, "_ZN3ccc3BB9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB9C1Ev();
extern void _ZN3ccc3BB9D1Ev();
Name_Map name_map__ZN3ccc3BB9E[] = {
  NSPAIR(_ZN3ccc3BB9C1Ev),
  NSPAIR(_ZN3ccc3BB9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
Class_Descriptor cd__ZN3ccc3BB9E = {  "_ZN3ccc3BB9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA10  {
  virtual void  pqr(); // _ZN3ccc4AA103pqrEv
  virtual void  abc(); // _ZN3ccc4AA103abcEv
  ~AA10(); // tgen
  AA10(); // tgen
};
//SIG(-1 _ZN3ccc4AA10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA10 ::pqr(){vfunc_called(this, "_ZN3ccc4AA103pqrEv");}
void  ccc::AA10 ::abc(){vfunc_called(this, "_ZN3ccc4AA103abcEv");}
ccc::AA10 ::~AA10(){ note_dtor("_ZN3ccc4AA10E", this);} // tgen
ccc::AA10 ::AA10(){ note_ctor("_ZN3ccc4AA10E", this);} // tgen
}
static void Test__ZN3ccc4AA10E()
{
  extern Class_Descriptor cd__ZN3ccc4AA10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA10E, buf);
    ::ccc::AA10 *dp, &lv = *(dp=new (buf) ::ccc::AA10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA10E)");
    test_class_info(&lv, &cd__ZN3ccc4AA10E);
    dp->::ccc::AA10::~AA10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA10E(Test__ZN3ccc4AA10E, "_ZN3ccc4AA10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA10C1Ev();
extern void _ZN3ccc4AA10D1Ev();
Name_Map name_map__ZN3ccc4AA10E[] = {
  NSPAIR(_ZN3ccc4AA10C1Ev),
  NSPAIR(_ZN3ccc4AA10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
Class_Descriptor cd__ZN3ccc4AA10E = {  "_ZN3ccc4AA10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB10  {
  virtual void  pqr(); // _ZN3ccc4BB103pqrEv
  virtual void  abc(); // _ZN3ccc4BB103abcEv
  ~BB10(); // tgen
  BB10(); // tgen
};
//SIG(-1 _ZN3ccc4BB10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB10 ::pqr(){vfunc_called(this, "_ZN3ccc4BB103pqrEv");}
void  ccc::BB10 ::abc(){vfunc_called(this, "_ZN3ccc4BB103abcEv");}
ccc::BB10 ::~BB10(){ note_dtor("_ZN3ccc4BB10E", this);} // tgen
ccc::BB10 ::BB10(){ note_ctor("_ZN3ccc4BB10E", this);} // tgen
}
static void Test__ZN3ccc4BB10E()
{
  extern Class_Descriptor cd__ZN3ccc4BB10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB10E, buf);
    ::ccc::BB10 *dp, &lv = *(dp=new (buf) ::ccc::BB10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB10E)");
    test_class_info(&lv, &cd__ZN3ccc4BB10E);
    dp->::ccc::BB10::~BB10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB10E(Test__ZN3ccc4BB10E, "_ZN3ccc4BB10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB10C1Ev();
extern void _ZN3ccc4BB10D1Ev();
Name_Map name_map__ZN3ccc4BB10E[] = {
  NSPAIR(_ZN3ccc4BB10C1Ev),
  NSPAIR(_ZN3ccc4BB10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
Class_Descriptor cd__ZN3ccc4BB10E = {  "_ZN3ccc4BB10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA11  {
  virtual void  pqr(); // _ZN3ccc4AA113pqrEv
  virtual void  efg(); // _ZN3ccc4AA113efgEv
  ~AA11(); // tgen
  AA11(); // tgen
};
//SIG(1 _ZN3ccc4AA11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA11 ::pqr(){vfunc_called(this, "_ZN3ccc4AA113pqrEv");}
void  ccc::AA11 ::efg(){vfunc_called(this, "_ZN3ccc4AA113efgEv");}
ccc::AA11 ::~AA11(){ note_dtor("_ZN3ccc4AA11E", this);} // tgen
ccc::AA11 ::AA11(){ note_ctor("_ZN3ccc4AA11E", this);} // tgen
}
static void Test__ZN3ccc4AA11E()
{
  extern Class_Descriptor cd__ZN3ccc4AA11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA11E, buf);
    ::ccc::AA11 *dp, &lv = *(dp=new (buf) ::ccc::AA11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA11E)");
    test_class_info(&lv, &cd__ZN3ccc4AA11E);
    dp->::ccc::AA11::~AA11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA11E(Test__ZN3ccc4AA11E, "_ZN3ccc4AA11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA11C1Ev();
extern void _ZN3ccc4AA11D1Ev();
Name_Map name_map__ZN3ccc4AA11E[] = {
  NSPAIR(_ZN3ccc4AA11C1Ev),
  NSPAIR(_ZN3ccc4AA11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc4AA113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
Class_Descriptor cd__ZN3ccc4AA11E = {  "_ZN3ccc4AA11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB11  {
  virtual void  pqr(); // _ZN3ccc4BB113pqrEv
  virtual void  efg(); // _ZN3ccc4BB113efgEv
  ~BB11(); // tgen
  BB11(); // tgen
};
//SIG(-1 _ZN3ccc4BB11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB11 ::pqr(){vfunc_called(this, "_ZN3ccc4BB113pqrEv");}
void  ccc::BB11 ::efg(){vfunc_called(this, "_ZN3ccc4BB113efgEv");}
ccc::BB11 ::~BB11(){ note_dtor("_ZN3ccc4BB11E", this);} // tgen
ccc::BB11 ::BB11(){ note_ctor("_ZN3ccc4BB11E", this);} // tgen
}
static void Test__ZN3ccc4BB11E()
{
  extern Class_Descriptor cd__ZN3ccc4BB11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB11E, buf);
    ::ccc::BB11 *dp, &lv = *(dp=new (buf) ::ccc::BB11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB11E)");
    test_class_info(&lv, &cd__ZN3ccc4BB11E);
    dp->::ccc::BB11::~BB11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB11E(Test__ZN3ccc4BB11E, "_ZN3ccc4BB11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB11C1Ev();
extern void _ZN3ccc4BB11D1Ev();
Name_Map name_map__ZN3ccc4BB11E[] = {
  NSPAIR(_ZN3ccc4BB11C1Ev),
  NSPAIR(_ZN3ccc4BB11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
Class_Descriptor cd__ZN3ccc4BB11E = {  "_ZN3ccc4BB11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA12  {
  virtual void  abc(); // _ZN3ccc4AA123abcEv
  ~AA12(); // tgen
  AA12(); // tgen
};
//SIG(1 _ZN3ccc4AA12E) C1{ v1}
}
namespace ccc { 
void  ccc::AA12 ::abc(){vfunc_called(this, "_ZN3ccc4AA123abcEv");}
ccc::AA12 ::~AA12(){ note_dtor("_ZN3ccc4AA12E", this);} // tgen
ccc::AA12 ::AA12(){ note_ctor("_ZN3ccc4AA12E", this);} // tgen
}
static void Test__ZN3ccc4AA12E()
{
  extern Class_Descriptor cd__ZN3ccc4AA12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA12E, buf);
    ::ccc::AA12 *dp, &lv = *(dp=new (buf) ::ccc::AA12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA12E)");
    test_class_info(&lv, &cd__ZN3ccc4AA12E);
    dp->::ccc::AA12::~AA12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA12E(Test__ZN3ccc4AA12E, "_ZN3ccc4AA12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA12C1Ev();
extern void _ZN3ccc4AA12D1Ev();
Name_Map name_map__ZN3ccc4AA12E[] = {
  NSPAIR(_ZN3ccc4AA12C1Ev),
  NSPAIR(_ZN3ccc4AA12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern void _ZN3ccc4AA123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
Class_Descriptor cd__ZN3ccc4AA12E = {  "_ZN3ccc4AA12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB12  {
  virtual void  abc(); // _ZN3ccc4BB123abcEv
  ~BB12(); // tgen
  BB12(); // tgen
};
//SIG(-1 _ZN3ccc4BB12E) C1{ v1}
}
namespace ccc { 
void  ccc::BB12 ::abc(){vfunc_called(this, "_ZN3ccc4BB123abcEv");}
ccc::BB12 ::~BB12(){ note_dtor("_ZN3ccc4BB12E", this);} // tgen
ccc::BB12 ::BB12(){ note_ctor("_ZN3ccc4BB12E", this);} // tgen
}
static void Test__ZN3ccc4BB12E()
{
  extern Class_Descriptor cd__ZN3ccc4BB12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB12E, buf);
    ::ccc::BB12 *dp, &lv = *(dp=new (buf) ::ccc::BB12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB12E)");
    test_class_info(&lv, &cd__ZN3ccc4BB12E);
    dp->::ccc::BB12::~BB12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB12E(Test__ZN3ccc4BB12E, "_ZN3ccc4BB12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB12C1Ev();
extern void _ZN3ccc4BB12D1Ev();
Name_Map name_map__ZN3ccc4BB12E[] = {
  NSPAIR(_ZN3ccc4BB12C1Ev),
  NSPAIR(_ZN3ccc4BB12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
Class_Descriptor cd__ZN3ccc4BB12E = {  "_ZN3ccc4BB12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA13  {
  virtual void  efg(); // _ZN3ccc4AA133efgEv
  ~AA13(); // tgen
  AA13(); // tgen
};
//SIG(1 _ZN3ccc4AA13E) C1{ v1}
}
namespace ccc { 
void  ccc::AA13 ::efg(){vfunc_called(this, "_ZN3ccc4AA133efgEv");}
ccc::AA13 ::~AA13(){ note_dtor("_ZN3ccc4AA13E", this);} // tgen
ccc::AA13 ::AA13(){ note_ctor("_ZN3ccc4AA13E", this);} // tgen
}
static void Test__ZN3ccc4AA13E()
{
  extern Class_Descriptor cd__ZN3ccc4AA13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA13E, buf);
    ::ccc::AA13 *dp, &lv = *(dp=new (buf) ::ccc::AA13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA13E)");
    test_class_info(&lv, &cd__ZN3ccc4AA13E);
    dp->::ccc::AA13::~AA13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA13E(Test__ZN3ccc4AA13E, "_ZN3ccc4AA13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA13C1Ev();
extern void _ZN3ccc4AA13D1Ev();
Name_Map name_map__ZN3ccc4AA13E[] = {
  NSPAIR(_ZN3ccc4AA13C1Ev),
  NSPAIR(_ZN3ccc4AA13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern void _ZN3ccc4AA133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
Class_Descriptor cd__ZN3ccc4AA13E = {  "_ZN3ccc4AA13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB13  {
  virtual void  efg(); // _ZN3ccc4BB133efgEv
  ~BB13(); // tgen
  BB13(); // tgen
};
//SIG(-1 _ZN3ccc4BB13E) C1{ v1}
}
namespace ccc { 
void  ccc::BB13 ::efg(){vfunc_called(this, "_ZN3ccc4BB133efgEv");}
ccc::BB13 ::~BB13(){ note_dtor("_ZN3ccc4BB13E", this);} // tgen
ccc::BB13 ::BB13(){ note_ctor("_ZN3ccc4BB13E", this);} // tgen
}
static void Test__ZN3ccc4BB13E()
{
  extern Class_Descriptor cd__ZN3ccc4BB13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB13E, buf);
    ::ccc::BB13 *dp, &lv = *(dp=new (buf) ::ccc::BB13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB13E)");
    test_class_info(&lv, &cd__ZN3ccc4BB13E);
    dp->::ccc::BB13::~BB13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB13E(Test__ZN3ccc4BB13E, "_ZN3ccc4BB13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB13C1Ev();
extern void _ZN3ccc4BB13D1Ev();
Name_Map name_map__ZN3ccc4BB13E[] = {
  NSPAIR(_ZN3ccc4BB13C1Ev),
  NSPAIR(_ZN3ccc4BB13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
Class_Descriptor cd__ZN3ccc4BB13E = {  "_ZN3ccc4BB13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA14  {
  virtual void  pqr(); // _ZN3ccc4AA143pqrEv
  ~AA14(); // tgen
  AA14(); // tgen
};
//SIG(1 _ZN3ccc4AA14E) C1{ v1}
}
namespace ccc { 
void  ccc::AA14 ::pqr(){vfunc_called(this, "_ZN3ccc4AA143pqrEv");}
ccc::AA14 ::~AA14(){ note_dtor("_ZN3ccc4AA14E", this);} // tgen
ccc::AA14 ::AA14(){ note_ctor("_ZN3ccc4AA14E", this);} // tgen
}
static void Test__ZN3ccc4AA14E()
{
  extern Class_Descriptor cd__ZN3ccc4AA14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA14E, buf);
    ::ccc::AA14 *dp, &lv = *(dp=new (buf) ::ccc::AA14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA14E)");
    test_class_info(&lv, &cd__ZN3ccc4AA14E);
    dp->::ccc::AA14::~AA14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA14E(Test__ZN3ccc4AA14E, "_ZN3ccc4AA14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA14C1Ev();
extern void _ZN3ccc4AA14D1Ev();
Name_Map name_map__ZN3ccc4AA14E[] = {
  NSPAIR(_ZN3ccc4AA14C1Ev),
  NSPAIR(_ZN3ccc4AA14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern void _ZN3ccc4AA143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
Class_Descriptor cd__ZN3ccc4AA14E = {  "_ZN3ccc4AA14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB14  {
  virtual void  pqr(); // _ZN3ccc4BB143pqrEv
  ~BB14(); // tgen
  BB14(); // tgen
};
//SIG(-1 _ZN3ccc4BB14E) C1{ v1}
}
namespace ccc { 
void  ccc::BB14 ::pqr(){vfunc_called(this, "_ZN3ccc4BB143pqrEv");}
ccc::BB14 ::~BB14(){ note_dtor("_ZN3ccc4BB14E", this);} // tgen
ccc::BB14 ::BB14(){ note_ctor("_ZN3ccc4BB14E", this);} // tgen
}
static void Test__ZN3ccc4BB14E()
{
  extern Class_Descriptor cd__ZN3ccc4BB14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB14E, buf);
    ::ccc::BB14 *dp, &lv = *(dp=new (buf) ::ccc::BB14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB14E)");
    test_class_info(&lv, &cd__ZN3ccc4BB14E);
    dp->::ccc::BB14::~BB14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB14E(Test__ZN3ccc4BB14E, "_ZN3ccc4BB14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB14C1Ev();
extern void _ZN3ccc4BB14D1Ev();
Name_Map name_map__ZN3ccc4BB14E[] = {
  NSPAIR(_ZN3ccc4BB14C1Ev),
  NSPAIR(_ZN3ccc4BB14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern void _ZN3ccc4BB143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
Class_Descriptor cd__ZN3ccc4BB14E = {  "_ZN3ccc4BB14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA15  {
};
//SIG(1 _ZN3ccc4AA15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4AA15E()
{
  {
    init_simple_test("_ZN3ccc4AA15E");
    ::ccc::AA15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4AA15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4AA15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4AA15E(Test__ZN3ccc4AA15E, "_ZN3ccc4AA15E", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB15  {
};
//SIG(-1 _ZN3ccc4BB15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4BB15E()
{
  {
    init_simple_test("_ZN3ccc4BB15E");
    ::ccc::BB15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4BB15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4BB15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4BB15E(Test__ZN3ccc4BB15E, "_ZN3ccc4BB15E", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTIN3ccc4BB15E[];
VTBL_ENTRY *P__ZTIN3ccc4BB15E = _ZTIN3ccc4BB15E; 
Class_Descriptor cd__ZN3ccc4BB15E = {  "_ZN3ccc4BB15E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTIN3ccc4BB15E),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y2  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC5x3y23efgEv
  virtual void  abc(); // _ZN3ccc7CC5x3y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x3y23pqrEv
  ~CC5x3y2(); // tgen
  CC5x3y2(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y2E) C1{ VBC2{ v3 v1 v2} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x3y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x3y23efgEv");}
void  ccc::CC5x3y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x3y23abcEv");}
void  ccc::CC5x3y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x3y23pqrEv");}
ccc::CC5x3y2 ::~CC5x3y2(){ note_dtor("_ZN3ccc7CC5x3y2E", this);} // tgen
ccc::CC5x3y2 ::CC5x3y2(){ note_ctor("_ZN3ccc7CC5x3y2E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y2E, buf);
    ::ccc::CC5x3y2 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y2E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y2E);
    dp->::ccc::CC5x3y2::~CC5x3y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y2E(Test__ZN3ccc7CC5x3y2E, "_ZN3ccc7CC5x3y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y2C1Ev();
extern void _ZN3ccc7CC5x3y2D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y2E[] = {
  NSPAIR(_ZN3ccc7CC5x3y2C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y2E[];
extern void _ZN3ccc7CC5x3y23efgEv();
extern void _ZN3ccc7CC5x3y23pqrEv();
extern void _ZN3ccc7CC5x3y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x3y23pqrEv,_ZTv0_n12_N3ccc7CC5x3y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y23pqrEv,_ZThn4_N3ccc7CC5x3y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x3y23efgEv,_ZTv0_n16_N3ccc7CC5x3y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y23efgEv,_ZThn4_N3ccc7CC5x3y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x3y23abcEv,_ZTv0_n20_N3ccc7CC5x3y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y23abcEv,_ZThn4_N3ccc7CC5x3y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x3y23pqrEv,_ZTv0_n12_N3ccc7CC5x3y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x3y23efgEv,_ZTv0_n16_N3ccc7CC5x3y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x3y23abcEv,_ZTv0_n20_N3ccc7CC5x3y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y2E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y2E[] = {
  {&(_ZTVN3ccc7CC5x3y2E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y2E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y2E[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x3y23abcEv,_ZTv0_n20_N3ccc7CC5x3y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y23abcEv,_ZThn4_N3ccc7CC5x3y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x3y23efgEv,_ZTv0_n16_N3ccc7CC5x3y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y23efgEv,_ZThn4_N3ccc7CC5x3y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x3y23pqrEv,_ZTv0_n12_N3ccc7CC5x3y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y23pqrEv,_ZThn4_N3ccc7CC5x3y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y2E = {  "_ZN3ccc7CC5x3y2E", // class name
  bases__ZN3ccc7CC5x3y2E, 2,
  &(vtc__ZN3ccc7CC5x3y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y2E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y2  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7DD5x3y23efgEv
  virtual void  abc(); // _ZN3ccc7DD5x3y23abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x3y23pqrEv
  ~DD5x3y2(); // tgen
  DD5x3y2(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y2E) C1{ VBC2{ v3 v1 v2} VBC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x3y2 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x3y23efgEv");}
void  ccc::DD5x3y2 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x3y23abcEv");}
void  ccc::DD5x3y2 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x3y23pqrEv");}
ccc::DD5x3y2 ::~DD5x3y2(){ note_dtor("_ZN3ccc7DD5x3y2E", this);} // tgen
ccc::DD5x3y2 ::DD5x3y2(){ note_ctor("_ZN3ccc7DD5x3y2E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y2E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y2E, buf);
    ::ccc::DD5x3y2 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y2E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y2E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y2E);
    dp->::ccc::DD5x3y2::~DD5x3y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y2E(Test__ZN3ccc7DD5x3y2E, "_ZN3ccc7DD5x3y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y2C1Ev();
extern void _ZN3ccc7DD5x3y2D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y2E[] = {
  NSPAIR(_ZN3ccc7DD5x3y2C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y2E[];
extern void _ZN3ccc7DD5x3y23pqrEv();
extern void _ZN3ccc7DD5x3y23efgEv();
extern void _ZN3ccc7DD5x3y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x3y23efgEv,_ZTv0_n12_N3ccc7DD5x3y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y23efgEv,_ZThn4_N3ccc7DD5x3y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x3y23pqrEv,_ZTv0_n16_N3ccc7DD5x3y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y23pqrEv,_ZThn4_N3ccc7DD5x3y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x3y23abcEv,_ZTv0_n20_N3ccc7DD5x3y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y23abcEv,_ZThn4_N3ccc7DD5x3y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x3y23efgEv,_ZTv0_n12_N3ccc7DD5x3y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x3y23pqrEv,_ZTv0_n16_N3ccc7DD5x3y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x3y23abcEv,_ZTv0_n20_N3ccc7DD5x3y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y2E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y2E[] = {
  {&(_ZTVN3ccc7DD5x3y2E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y2E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y2E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y2E[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x3y23abcEv,_ZTv0_n20_N3ccc7DD5x3y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y23abcEv,_ZThn4_N3ccc7DD5x3y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x3y23pqrEv,_ZTv0_n16_N3ccc7DD5x3y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y23pqrEv,_ZThn4_N3ccc7DD5x3y23pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x3y23efgEv,_ZTv0_n12_N3ccc7DD5x3y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y23efgEv,_ZThn4_N3ccc7DD5x3y23efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y2E = {  "_ZN3ccc7DD5x3y2E", // class name
  bases__ZN3ccc7DD5x3y2E, 2,
  &(vtc__ZN3ccc7DD5x3y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y2E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y3  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC5x3y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x3y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x3y33abcEv
  ~CC5x3y3(); // tgen
  CC5x3y3(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y3E) C1{ VBC2{ v2 v1 v3} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x3y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x3y33efgEv");}
void  ccc::CC5x3y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x3y33pqrEv");}
void  ccc::CC5x3y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x3y33abcEv");}
ccc::CC5x3y3 ::~CC5x3y3(){ note_dtor("_ZN3ccc7CC5x3y3E", this);} // tgen
ccc::CC5x3y3 ::CC5x3y3(){ note_ctor("_ZN3ccc7CC5x3y3E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y3E, buf);
    ::ccc::CC5x3y3 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y3E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y3E);
    dp->::ccc::CC5x3y3::~CC5x3y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y3E(Test__ZN3ccc7CC5x3y3E, "_ZN3ccc7CC5x3y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y3C1Ev();
extern void _ZN3ccc7CC5x3y3D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y3E[] = {
  NSPAIR(_ZN3ccc7CC5x3y3C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y3E[];
extern void _ZN3ccc7CC5x3y33efgEv();
extern void _ZN3ccc7CC5x3y33pqrEv();
extern void _ZN3ccc7CC5x3y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x3y33pqrEv,_ZTv0_n12_N3ccc7CC5x3y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y33pqrEv,_ZThn4_N3ccc7CC5x3y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x3y33efgEv,_ZTv0_n16_N3ccc7CC5x3y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y33efgEv,_ZThn4_N3ccc7CC5x3y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x3y33abcEv,_ZTv0_n20_N3ccc7CC5x3y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y33abcEv,_ZThn4_N3ccc7CC5x3y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x3y33pqrEv,_ZTv0_n12_N3ccc7CC5x3y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x3y33efgEv,_ZTv0_n16_N3ccc7CC5x3y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x3y33abcEv,_ZTv0_n20_N3ccc7CC5x3y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y3E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y3E[] = {
  {&(_ZTVN3ccc7CC5x3y3E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y3E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y3E[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x3y33abcEv,_ZTv0_n20_N3ccc7CC5x3y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y33abcEv,_ZThn4_N3ccc7CC5x3y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x3y33efgEv,_ZTv0_n16_N3ccc7CC5x3y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y33efgEv,_ZThn4_N3ccc7CC5x3y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x3y33pqrEv,_ZTv0_n12_N3ccc7CC5x3y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y33pqrEv,_ZThn4_N3ccc7CC5x3y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y3E = {  "_ZN3ccc7CC5x3y3E", // class name
  bases__ZN3ccc7CC5x3y3E, 2,
  &(vtc__ZN3ccc7CC5x3y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y3E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y3  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7DD5x3y33efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x3y33pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x3y33abcEv
  ~DD5x3y3(); // tgen
  DD5x3y3(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y3E) C1{ VBC2{ v2 v1 v3} VBC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x3y3 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x3y33efgEv");}
void  ccc::DD5x3y3 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x3y33pqrEv");}
void  ccc::DD5x3y3 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x3y33abcEv");}
ccc::DD5x3y3 ::~DD5x3y3(){ note_dtor("_ZN3ccc7DD5x3y3E", this);} // tgen
ccc::DD5x3y3 ::DD5x3y3(){ note_ctor("_ZN3ccc7DD5x3y3E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y3E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y3E, buf);
    ::ccc::DD5x3y3 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y3E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y3E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y3E);
    dp->::ccc::DD5x3y3::~DD5x3y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y3E(Test__ZN3ccc7DD5x3y3E, "_ZN3ccc7DD5x3y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y3C1Ev();
extern void _ZN3ccc7DD5x3y3D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y3E[] = {
  NSPAIR(_ZN3ccc7DD5x3y3C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y3E[];
extern void _ZN3ccc7DD5x3y33pqrEv();
extern void _ZN3ccc7DD5x3y33efgEv();
extern void _ZN3ccc7DD5x3y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x3y33efgEv,_ZTv0_n12_N3ccc7DD5x3y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y33efgEv,_ZThn4_N3ccc7DD5x3y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x3y33pqrEv,_ZTv0_n16_N3ccc7DD5x3y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y33pqrEv,_ZThn4_N3ccc7DD5x3y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x3y33abcEv,_ZTv0_n20_N3ccc7DD5x3y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y33abcEv,_ZThn4_N3ccc7DD5x3y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x3y33efgEv,_ZTv0_n12_N3ccc7DD5x3y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x3y33pqrEv,_ZTv0_n16_N3ccc7DD5x3y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x3y33abcEv,_ZTv0_n20_N3ccc7DD5x3y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y3E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y3E[] = {
  {&(_ZTVN3ccc7DD5x3y3E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y3E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y3E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y3E[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x3y33abcEv,_ZTv0_n20_N3ccc7DD5x3y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y33abcEv,_ZThn4_N3ccc7DD5x3y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x3y33pqrEv,_ZTv0_n16_N3ccc7DD5x3y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y33pqrEv,_ZThn4_N3ccc7DD5x3y33pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x3y33efgEv,_ZTv0_n12_N3ccc7DD5x3y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y33efgEv,_ZThn4_N3ccc7DD5x3y33efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y3E = {  "_ZN3ccc7DD5x3y3E", // class name
  bases__ZN3ccc7DD5x3y3E, 2,
  &(vtc__ZN3ccc7DD5x3y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y3E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y4  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc7CC5x3y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x3y43abcEv
  virtual void  efg(); // _ZN3ccc7CC5x3y43efgEv
  ~CC5x3y4(); // tgen
  CC5x3y4(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y4E) C1{ VBC2{ v1 v3 v2} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x3y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x3y43pqrEv");}
void  ccc::CC5x3y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x3y43abcEv");}
void  ccc::CC5x3y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x3y43efgEv");}
ccc::CC5x3y4 ::~CC5x3y4(){ note_dtor("_ZN3ccc7CC5x3y4E", this);} // tgen
ccc::CC5x3y4 ::CC5x3y4(){ note_ctor("_ZN3ccc7CC5x3y4E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y4E, buf);
    ::ccc::CC5x3y4 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y4E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y4E);
    dp->::ccc::CC5x3y4::~CC5x3y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y4E(Test__ZN3ccc7CC5x3y4E, "_ZN3ccc7CC5x3y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y4C1Ev();
extern void _ZN3ccc7CC5x3y4D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y4E[] = {
  NSPAIR(_ZN3ccc7CC5x3y4C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y4E[];
extern void _ZN3ccc7CC5x3y43efgEv();
extern void _ZN3ccc7CC5x3y43pqrEv();
extern void _ZN3ccc7CC5x3y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x3y43pqrEv,_ZTv0_n12_N3ccc7CC5x3y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y43pqrEv,_ZThn4_N3ccc7CC5x3y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x3y43efgEv,_ZTv0_n16_N3ccc7CC5x3y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y43efgEv,_ZThn4_N3ccc7CC5x3y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x3y43abcEv,_ZTv0_n20_N3ccc7CC5x3y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y43abcEv,_ZThn4_N3ccc7CC5x3y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x3y43pqrEv,_ZTv0_n12_N3ccc7CC5x3y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x3y43efgEv,_ZTv0_n16_N3ccc7CC5x3y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x3y43abcEv,_ZTv0_n20_N3ccc7CC5x3y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y4E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y4E[] = {
  {&(_ZTVN3ccc7CC5x3y4E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y4E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y4E[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x3y43abcEv,_ZTv0_n20_N3ccc7CC5x3y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y43abcEv,_ZThn4_N3ccc7CC5x3y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x3y43efgEv,_ZTv0_n16_N3ccc7CC5x3y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y43efgEv,_ZThn4_N3ccc7CC5x3y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x3y43pqrEv,_ZTv0_n12_N3ccc7CC5x3y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y43pqrEv,_ZThn4_N3ccc7CC5x3y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y4E = {  "_ZN3ccc7CC5x3y4E", // class name
  bases__ZN3ccc7CC5x3y4E, 2,
  &(vtc__ZN3ccc7CC5x3y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y4E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y4  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc7DD5x3y43pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x3y43abcEv
  virtual void  efg(); // _ZN3ccc7DD5x3y43efgEv
  ~DD5x3y4(); // tgen
  DD5x3y4(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y4E) C1{ VBC2{ v1 v3 v2} VBC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x3y4 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x3y43pqrEv");}
void  ccc::DD5x3y4 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x3y43abcEv");}
void  ccc::DD5x3y4 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x3y43efgEv");}
ccc::DD5x3y4 ::~DD5x3y4(){ note_dtor("_ZN3ccc7DD5x3y4E", this);} // tgen
ccc::DD5x3y4 ::DD5x3y4(){ note_ctor("_ZN3ccc7DD5x3y4E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y4E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y4E, buf);
    ::ccc::DD5x3y4 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y4E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y4E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y4E);
    dp->::ccc::DD5x3y4::~DD5x3y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y4E(Test__ZN3ccc7DD5x3y4E, "_ZN3ccc7DD5x3y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y4C1Ev();
extern void _ZN3ccc7DD5x3y4D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y4E[] = {
  NSPAIR(_ZN3ccc7DD5x3y4C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y4E[];
extern void _ZN3ccc7DD5x3y43pqrEv();
extern void _ZN3ccc7DD5x3y43efgEv();
extern void _ZN3ccc7DD5x3y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x3y43efgEv,_ZTv0_n12_N3ccc7DD5x3y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y43efgEv,_ZThn4_N3ccc7DD5x3y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x3y43pqrEv,_ZTv0_n16_N3ccc7DD5x3y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y43pqrEv,_ZThn4_N3ccc7DD5x3y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x3y43abcEv,_ZTv0_n20_N3ccc7DD5x3y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y43abcEv,_ZThn4_N3ccc7DD5x3y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x3y43efgEv,_ZTv0_n12_N3ccc7DD5x3y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x3y43pqrEv,_ZTv0_n16_N3ccc7DD5x3y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x3y43abcEv,_ZTv0_n20_N3ccc7DD5x3y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y4E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y4E[] = {
  {&(_ZTVN3ccc7DD5x3y4E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y4E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y4E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y4E[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x3y43abcEv,_ZTv0_n20_N3ccc7DD5x3y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y43abcEv,_ZThn4_N3ccc7DD5x3y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x3y43pqrEv,_ZTv0_n16_N3ccc7DD5x3y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y43pqrEv,_ZThn4_N3ccc7DD5x3y43pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x3y43efgEv,_ZTv0_n12_N3ccc7DD5x3y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y43efgEv,_ZThn4_N3ccc7DD5x3y43efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y4E = {  "_ZN3ccc7DD5x3y4E", // class name
  bases__ZN3ccc7DD5x3y4E, 2,
  &(vtc__ZN3ccc7DD5x3y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y4E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y5  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc7CC5x3y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x3y53efgEv
  virtual void  abc(); // _ZN3ccc7CC5x3y53abcEv
  ~CC5x3y5(); // tgen
  CC5x3y5(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y5E) C1{ VBC2{ v1 v2 v3} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x3y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x3y53pqrEv");}
void  ccc::CC5x3y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x3y53efgEv");}
void  ccc::CC5x3y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x3y53abcEv");}
ccc::CC5x3y5 ::~CC5x3y5(){ note_dtor("_ZN3ccc7CC5x3y5E", this);} // tgen
ccc::CC5x3y5 ::CC5x3y5(){ note_ctor("_ZN3ccc7CC5x3y5E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y5E, buf);
    ::ccc::CC5x3y5 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y5E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y5E);
    dp->::ccc::CC5x3y5::~CC5x3y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y5E(Test__ZN3ccc7CC5x3y5E, "_ZN3ccc7CC5x3y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y5C1Ev();
extern void _ZN3ccc7CC5x3y5D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y5E[] = {
  NSPAIR(_ZN3ccc7CC5x3y5C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y5E[];
extern void _ZN3ccc7CC5x3y53efgEv();
extern void _ZN3ccc7CC5x3y53pqrEv();
extern void _ZN3ccc7CC5x3y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x3y53pqrEv,_ZTv0_n12_N3ccc7CC5x3y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y53pqrEv,_ZThn4_N3ccc7CC5x3y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x3y53efgEv,_ZTv0_n16_N3ccc7CC5x3y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y53efgEv,_ZThn4_N3ccc7CC5x3y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x3y53abcEv,_ZTv0_n20_N3ccc7CC5x3y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y53abcEv,_ZThn4_N3ccc7CC5x3y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x3y53pqrEv,_ZTv0_n12_N3ccc7CC5x3y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x3y53efgEv,_ZTv0_n16_N3ccc7CC5x3y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x3y53abcEv,_ZTv0_n20_N3ccc7CC5x3y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y5E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y5E[] = {
  {&(_ZTVN3ccc7CC5x3y5E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y5E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y5E[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x3y53abcEv,_ZTv0_n20_N3ccc7CC5x3y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y53abcEv,_ZThn4_N3ccc7CC5x3y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x3y53efgEv,_ZTv0_n16_N3ccc7CC5x3y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y53efgEv,_ZThn4_N3ccc7CC5x3y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x3y53pqrEv,_ZTv0_n12_N3ccc7CC5x3y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y53pqrEv,_ZThn4_N3ccc7CC5x3y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y5E = {  "_ZN3ccc7CC5x3y5E", // class name
  bases__ZN3ccc7CC5x3y5E, 2,
  &(vtc__ZN3ccc7CC5x3y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y5E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y5  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc7DD5x3y53pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x3y53efgEv
  virtual void  abc(); // _ZN3ccc7DD5x3y53abcEv
  ~DD5x3y5(); // tgen
  DD5x3y5(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y5E) C1{ VBC2{ v1 v2 v3} VBC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x3y5 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x3y53pqrEv");}
void  ccc::DD5x3y5 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x3y53efgEv");}
void  ccc::DD5x3y5 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x3y53abcEv");}
ccc::DD5x3y5 ::~DD5x3y5(){ note_dtor("_ZN3ccc7DD5x3y5E", this);} // tgen
ccc::DD5x3y5 ::DD5x3y5(){ note_ctor("_ZN3ccc7DD5x3y5E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y5E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y5E, buf);
    ::ccc::DD5x3y5 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y5E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y5E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y5E);
    dp->::ccc::DD5x3y5::~DD5x3y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y5E(Test__ZN3ccc7DD5x3y5E, "_ZN3ccc7DD5x3y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y5C1Ev();
extern void _ZN3ccc7DD5x3y5D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y5E[] = {
  NSPAIR(_ZN3ccc7DD5x3y5C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y5E[];
extern void _ZN3ccc7DD5x3y53pqrEv();
extern void _ZN3ccc7DD5x3y53efgEv();
extern void _ZN3ccc7DD5x3y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x3y53efgEv,_ZTv0_n12_N3ccc7DD5x3y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y53efgEv,_ZThn4_N3ccc7DD5x3y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x3y53pqrEv,_ZTv0_n16_N3ccc7DD5x3y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y53pqrEv,_ZThn4_N3ccc7DD5x3y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x3y53abcEv,_ZTv0_n20_N3ccc7DD5x3y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y53abcEv,_ZThn4_N3ccc7DD5x3y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x3y53efgEv,_ZTv0_n12_N3ccc7DD5x3y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x3y53pqrEv,_ZTv0_n16_N3ccc7DD5x3y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x3y53abcEv,_ZTv0_n20_N3ccc7DD5x3y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y5E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y5E[] = {
  {&(_ZTVN3ccc7DD5x3y5E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y5E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y5E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y5E[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x3y53abcEv,_ZTv0_n20_N3ccc7DD5x3y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y53abcEv,_ZThn4_N3ccc7DD5x3y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x3y53pqrEv,_ZTv0_n16_N3ccc7DD5x3y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y53pqrEv,_ZThn4_N3ccc7DD5x3y53pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x3y53efgEv,_ZTv0_n12_N3ccc7DD5x3y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y53efgEv,_ZThn4_N3ccc7DD5x3y53efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y5E = {  "_ZN3ccc7DD5x3y5E", // class name
  bases__ZN3ccc7DD5x3y5E, 2,
  &(vtc__ZN3ccc7DD5x3y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y5E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y6  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7CC5x3y63abcEv
  virtual void  efg(); // _ZN3ccc7CC5x3y63efgEv
  ~CC5x3y6(); // tgen
  CC5x3y6(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y6E) C1{ VBC2{ v3 v2 v1} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x3y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x3y63abcEv");}
void  ccc::CC5x3y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x3y63efgEv");}
ccc::CC5x3y6 ::~CC5x3y6(){ note_dtor("_ZN3ccc7CC5x3y6E", this);} // tgen
ccc::CC5x3y6 ::CC5x3y6(){ note_ctor("_ZN3ccc7CC5x3y6E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y6E, buf);
    ::ccc::CC5x3y6 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y6E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y6E);
    dp->::ccc::CC5x3y6::~CC5x3y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y6E(Test__ZN3ccc7CC5x3y6E, "_ZN3ccc7CC5x3y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y6C1Ev();
extern void _ZN3ccc7CC5x3y6D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y6E[] = {
  NSPAIR(_ZN3ccc7CC5x3y6C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y6E[];
extern void _ZN3ccc7CC5x3y63efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc7CC5x3y63abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x3y63efgEv,_ZTv0_n16_N3ccc7CC5x3y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y63efgEv,_ZThn4_N3ccc7CC5x3y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x3y63abcEv,_ZTv0_n20_N3ccc7CC5x3y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y63abcEv,_ZThn4_N3ccc7CC5x3y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y63abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x3y63efgEv,_ZTv0_n16_N3ccc7CC5x3y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x3y63abcEv,_ZTv0_n20_N3ccc7CC5x3y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y6E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y6E[] = {
  {&(_ZTVN3ccc7CC5x3y6E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y6E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y6E[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x3y63abcEv,_ZTv0_n20_N3ccc7CC5x3y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y63abcEv,_ZThn4_N3ccc7CC5x3y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x3y63efgEv,_ZTv0_n16_N3ccc7CC5x3y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y63efgEv,_ZThn4_N3ccc7CC5x3y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y6E = {  "_ZN3ccc7CC5x3y6E", // class name
  bases__ZN3ccc7CC5x3y6E, 2,
  &(vtc__ZN3ccc7CC5x3y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y6E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y6  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7DD5x3y63abcEv
  virtual void  efg(); // _ZN3ccc7DD5x3y63efgEv
  ~DD5x3y6(); // tgen
  DD5x3y6(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y6E) C1{ VBC2{ v3 v2 v1} VBC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x3y6 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x3y63abcEv");}
void  ccc::DD5x3y6 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x3y63efgEv");}
ccc::DD5x3y6 ::~DD5x3y6(){ note_dtor("_ZN3ccc7DD5x3y6E", this);} // tgen
ccc::DD5x3y6 ::DD5x3y6(){ note_ctor("_ZN3ccc7DD5x3y6E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y6E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y6E, buf);
    ::ccc::DD5x3y6 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y6E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y6E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y6E);
    dp->::ccc::DD5x3y6::~DD5x3y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y6E(Test__ZN3ccc7DD5x3y6E, "_ZN3ccc7DD5x3y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y6C1Ev();
extern void _ZN3ccc7DD5x3y6D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y6E[] = {
  NSPAIR(_ZN3ccc7DD5x3y6C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y6E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x3y63efgEv();
extern void _ZN3ccc7DD5x3y63abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x3y63efgEv,_ZTv0_n12_N3ccc7DD5x3y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y63efgEv,_ZThn4_N3ccc7DD5x3y63efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB33pqrEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x3y63abcEv,_ZTv0_n20_N3ccc7DD5x3y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y63abcEv,_ZThn4_N3ccc7DD5x3y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y63abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x3y63efgEv,_ZTv0_n12_N3ccc7DD5x3y63efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x3y63abcEv,_ZTv0_n20_N3ccc7DD5x3y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y6E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y6E[] = {
  {&(_ZTVN3ccc7DD5x3y6E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y6E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y6E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y6E[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x3y63abcEv,_ZTv0_n20_N3ccc7DD5x3y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y63abcEv,_ZThn4_N3ccc7DD5x3y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x3y63efgEv,_ZTv0_n12_N3ccc7DD5x3y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y63efgEv,_ZThn4_N3ccc7DD5x3y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y6E = {  "_ZN3ccc7DD5x3y6E", // class name
  bases__ZN3ccc7DD5x3y6E, 2,
  &(vtc__ZN3ccc7DD5x3y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y6E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y7  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7CC5x3y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x3y73pqrEv
  ~CC5x3y7(); // tgen
  CC5x3y7(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y7E) C1{ VBC2{ v2 v3 v1} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x3y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x3y73abcEv");}
void  ccc::CC5x3y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x3y73pqrEv");}
ccc::CC5x3y7 ::~CC5x3y7(){ note_dtor("_ZN3ccc7CC5x3y7E", this);} // tgen
ccc::CC5x3y7 ::CC5x3y7(){ note_ctor("_ZN3ccc7CC5x3y7E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y7E, buf);
    ::ccc::CC5x3y7 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y7E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y7E);
    dp->::ccc::CC5x3y7::~CC5x3y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y7E(Test__ZN3ccc7CC5x3y7E, "_ZN3ccc7CC5x3y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y7C1Ev();
extern void _ZN3ccc7CC5x3y7D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y7E[] = {
  NSPAIR(_ZN3ccc7CC5x3y7C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y7E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc7CC5x3y73pqrEv();
extern void _ZN3ccc7CC5x3y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x3y73pqrEv,_ZTv0_n12_N3ccc7CC5x3y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y73pqrEv,_ZThn4_N3ccc7CC5x3y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x3y73abcEv,_ZTv0_n20_N3ccc7CC5x3y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y73abcEv,_ZThn4_N3ccc7CC5x3y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y73abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x3y73pqrEv,_ZTv0_n12_N3ccc7CC5x3y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x3y73abcEv,_ZTv0_n20_N3ccc7CC5x3y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y7E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y7E[] = {
  {&(_ZTVN3ccc7CC5x3y7E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y7E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y7E[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x3y73abcEv,_ZTv0_n20_N3ccc7CC5x3y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y73abcEv,_ZThn4_N3ccc7CC5x3y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x3y73pqrEv,_ZTv0_n12_N3ccc7CC5x3y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y73pqrEv,_ZThn4_N3ccc7CC5x3y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y7E = {  "_ZN3ccc7CC5x3y7E", // class name
  bases__ZN3ccc7CC5x3y7E, 2,
  &(vtc__ZN3ccc7CC5x3y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y7E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y7  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7DD5x3y73abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x3y73pqrEv
  ~DD5x3y7(); // tgen
  DD5x3y7(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y7E) C1{ VBC2{ v2 v3 v1} VBC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x3y7 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x3y73abcEv");}
void  ccc::DD5x3y7 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x3y73pqrEv");}
ccc::DD5x3y7 ::~DD5x3y7(){ note_dtor("_ZN3ccc7DD5x3y7E", this);} // tgen
ccc::DD5x3y7 ::DD5x3y7(){ note_ctor("_ZN3ccc7DD5x3y7E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y7E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y7E, buf);
    ::ccc::DD5x3y7 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y7E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y7E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y7E);
    dp->::ccc::DD5x3y7::~DD5x3y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y7E(Test__ZN3ccc7DD5x3y7E, "_ZN3ccc7DD5x3y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y7C1Ev();
extern void _ZN3ccc7DD5x3y7D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y7E[] = {
  NSPAIR(_ZN3ccc7DD5x3y7C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y7E[];
extern void _ZN3ccc7DD5x3y73pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc7DD5x3y73abcEv();
extern void _ZN3ccc3BB33efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x3y73pqrEv,_ZTv0_n16_N3ccc7DD5x3y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y73pqrEv,_ZThn4_N3ccc7DD5x3y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x3y73abcEv,_ZTv0_n20_N3ccc7DD5x3y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y73abcEv,_ZThn4_N3ccc7DD5x3y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y73abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x3y73pqrEv,_ZTv0_n16_N3ccc7DD5x3y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x3y73abcEv,_ZTv0_n20_N3ccc7DD5x3y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y7E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y7E[] = {
  {&(_ZTVN3ccc7DD5x3y7E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y7E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y7E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y7E[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x3y73abcEv,_ZTv0_n20_N3ccc7DD5x3y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y73abcEv,_ZThn4_N3ccc7DD5x3y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x3y73pqrEv,_ZTv0_n16_N3ccc7DD5x3y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y73pqrEv,_ZThn4_N3ccc7DD5x3y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y7E = {  "_ZN3ccc7DD5x3y7E", // class name
  bases__ZN3ccc7DD5x3y7E, 2,
  &(vtc__ZN3ccc7DD5x3y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y7E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y8  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC5x3y83efgEv
  virtual void  abc(); // _ZN3ccc7CC5x3y83abcEv
  ~CC5x3y8(); // tgen
  CC5x3y8(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y8E) C1{ VBC2{ v3 v1 v2} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x3y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x3y83efgEv");}
void  ccc::CC5x3y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x3y83abcEv");}
ccc::CC5x3y8 ::~CC5x3y8(){ note_dtor("_ZN3ccc7CC5x3y8E", this);} // tgen
ccc::CC5x3y8 ::CC5x3y8(){ note_ctor("_ZN3ccc7CC5x3y8E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y8E, buf);
    ::ccc::CC5x3y8 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y8E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y8E);
    dp->::ccc::CC5x3y8::~CC5x3y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y8E(Test__ZN3ccc7CC5x3y8E, "_ZN3ccc7CC5x3y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y8C1Ev();
extern void _ZN3ccc7CC5x3y8D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y8E[] = {
  NSPAIR(_ZN3ccc7CC5x3y8C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y8E[];
extern void _ZN3ccc7CC5x3y83efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc7CC5x3y83abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x3y83efgEv,_ZTv0_n16_N3ccc7CC5x3y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y83efgEv,_ZThn4_N3ccc7CC5x3y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x3y83abcEv,_ZTv0_n20_N3ccc7CC5x3y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y83abcEv,_ZThn4_N3ccc7CC5x3y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y83abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x3y83efgEv,_ZTv0_n16_N3ccc7CC5x3y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x3y83abcEv,_ZTv0_n20_N3ccc7CC5x3y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y8E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y8E[] = {
  {&(_ZTVN3ccc7CC5x3y8E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y8E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y8E[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x3y83abcEv,_ZTv0_n20_N3ccc7CC5x3y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y83abcEv,_ZThn4_N3ccc7CC5x3y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x3y83efgEv,_ZTv0_n16_N3ccc7CC5x3y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y83efgEv,_ZThn4_N3ccc7CC5x3y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y8E = {  "_ZN3ccc7CC5x3y8E", // class name
  bases__ZN3ccc7CC5x3y8E, 2,
  &(vtc__ZN3ccc7CC5x3y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y8E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y8  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7DD5x3y83efgEv
  virtual void  abc(); // _ZN3ccc7DD5x3y83abcEv
  ~DD5x3y8(); // tgen
  DD5x3y8(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y8E) C1{ VBC2{ v3 v1 v2} VBC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x3y8 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x3y83efgEv");}
void  ccc::DD5x3y8 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x3y83abcEv");}
ccc::DD5x3y8 ::~DD5x3y8(){ note_dtor("_ZN3ccc7DD5x3y8E", this);} // tgen
ccc::DD5x3y8 ::DD5x3y8(){ note_ctor("_ZN3ccc7DD5x3y8E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y8E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y8E, buf);
    ::ccc::DD5x3y8 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y8E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y8E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y8E);
    dp->::ccc::DD5x3y8::~DD5x3y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y8E(Test__ZN3ccc7DD5x3y8E, "_ZN3ccc7DD5x3y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y8C1Ev();
extern void _ZN3ccc7DD5x3y8D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y8E[] = {
  NSPAIR(_ZN3ccc7DD5x3y8C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y8E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x3y83efgEv();
extern void _ZN3ccc7DD5x3y83abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x3y83efgEv,_ZTv0_n12_N3ccc7DD5x3y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y83efgEv,_ZThn4_N3ccc7DD5x3y83efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB33pqrEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x3y83abcEv,_ZTv0_n20_N3ccc7DD5x3y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y83abcEv,_ZThn4_N3ccc7DD5x3y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y83abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x3y83efgEv,_ZTv0_n12_N3ccc7DD5x3y83efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x3y83abcEv,_ZTv0_n20_N3ccc7DD5x3y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y8E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y8E[] = {
  {&(_ZTVN3ccc7DD5x3y8E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y8E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y8E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y8E[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x3y83abcEv,_ZTv0_n20_N3ccc7DD5x3y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y83abcEv,_ZThn4_N3ccc7DD5x3y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x3y83efgEv,_ZTv0_n12_N3ccc7DD5x3y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y83efgEv,_ZThn4_N3ccc7DD5x3y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y8E = {  "_ZN3ccc7DD5x3y8E", // class name
  bases__ZN3ccc7DD5x3y8E, 2,
  &(vtc__ZN3ccc7DD5x3y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y8E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y9  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC5x3y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x3y93pqrEv
  ~CC5x3y9(); // tgen
  CC5x3y9(); // tgen
};
//SIG(1 _ZN3ccc7CC5x3y9E) C1{ VBC2{ v2 v1 v3} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x3y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x3y93efgEv");}
void  ccc::CC5x3y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x3y93pqrEv");}
ccc::CC5x3y9 ::~CC5x3y9(){ note_dtor("_ZN3ccc7CC5x3y9E", this);} // tgen
ccc::CC5x3y9 ::CC5x3y9(){ note_ctor("_ZN3ccc7CC5x3y9E", this);} // tgen
}
static void Test__ZN3ccc7CC5x3y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x3y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x3y9E, buf);
    ::ccc::CC5x3y9 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x3y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x3y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x3y9E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc7CC5x3y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x3y9E);
    dp->::ccc::CC5x3y9::~CC5x3y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x3y9E(Test__ZN3ccc7CC5x3y9E, "_ZN3ccc7CC5x3y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x3y9C1Ev();
extern void _ZN3ccc7CC5x3y9D1Ev();
Name_Map name_map__ZN3ccc7CC5x3y9E[] = {
  NSPAIR(_ZN3ccc7CC5x3y9C1Ev),
  NSPAIR(_ZN3ccc7CC5x3y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC5x3y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y9E[];
extern void _ZN3ccc7CC5x3y93efgEv();
extern void _ZN3ccc7CC5x3y93pqrEv();
extern void _ZN3ccc3BB33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x3y93pqrEv,_ZTv0_n12_N3ccc7CC5x3y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y93pqrEv,_ZThn4_N3ccc7CC5x3y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x3y93efgEv,_ZTv0_n16_N3ccc7CC5x3y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x3y93efgEv,_ZThn4_N3ccc7CC5x3y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC5x3y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x3y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x3y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x3y93pqrEv,_ZTv0_n12_N3ccc7CC5x3y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x3y93efgEv,_ZTv0_n16_N3ccc7CC5x3y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x3y9E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x3y9E[] = {
  {&(_ZTVN3ccc7CC5x3y9E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x3y9E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x3y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x3y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x3y9E[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x3y93efgEv,_ZTv0_n16_N3ccc7CC5x3y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y93efgEv,_ZThn4_N3ccc7CC5x3y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x3y93pqrEv,_ZTv0_n12_N3ccc7CC5x3y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x3y93pqrEv,_ZThn4_N3ccc7CC5x3y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x3y9E = {  "_ZN3ccc7CC5x3y9E", // class name
  bases__ZN3ccc7CC5x3y9E, 2,
  &(vtc__ZN3ccc7CC5x3y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x3y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x3y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x3y9E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x3y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y9  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7DD5x3y93efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x3y93pqrEv
  ~DD5x3y9(); // tgen
  DD5x3y9(); // tgen
};
//SIG(1 _ZN3ccc7DD5x3y9E) C1{ VBC2{ v2 v1 v3} VBC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x3y9 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x3y93efgEv");}
void  ccc::DD5x3y9 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x3y93pqrEv");}
ccc::DD5x3y9 ::~DD5x3y9(){ note_dtor("_ZN3ccc7DD5x3y9E", this);} // tgen
ccc::DD5x3y9 ::DD5x3y9(){ note_ctor("_ZN3ccc7DD5x3y9E", this);} // tgen
}
static void Test__ZN3ccc7DD5x3y9E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x3y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x3y9E, buf);
    ::ccc::DD5x3y9 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x3y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x3y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x3y9E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7DD5x3y9E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x3y9E);
    dp->::ccc::DD5x3y9::~DD5x3y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x3y9E(Test__ZN3ccc7DD5x3y9E, "_ZN3ccc7DD5x3y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x3y9C1Ev();
extern void _ZN3ccc7DD5x3y9D1Ev();
Name_Map name_map__ZN3ccc7DD5x3y9E[] = {
  NSPAIR(_ZN3ccc7DD5x3y9C1Ev),
  NSPAIR(_ZN3ccc7DD5x3y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7DD5x3y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y9E[];
extern void _ZN3ccc7DD5x3y93pqrEv();
extern void _ZN3ccc7DD5x3y93efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x3y93efgEv,_ZTv0_n12_N3ccc7DD5x3y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y93efgEv,_ZThn4_N3ccc7DD5x3y93efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x3y93pqrEv,_ZTv0_n16_N3ccc7DD5x3y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x3y93pqrEv,_ZThn4_N3ccc7DD5x3y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7DD5x3y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x3y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x3y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x3y93efgEv,_ZTv0_n12_N3ccc7DD5x3y93efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x3y93pqrEv,_ZTv0_n16_N3ccc7DD5x3y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x3y9E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x3y9E[] = {
  {&(_ZTVN3ccc7DD5x3y9E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y9E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x3y9E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x3y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x3y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x3y9E[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x3y93pqrEv,_ZTv0_n16_N3ccc7DD5x3y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y93pqrEv,_ZThn4_N3ccc7DD5x3y93pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x3y93efgEv,_ZTv0_n12_N3ccc7DD5x3y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x3y93efgEv,_ZThn4_N3ccc7DD5x3y93efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x3y9E = {  "_ZN3ccc7DD5x3y9E", // class name
  bases__ZN3ccc7DD5x3y9E, 2,
  &(vtc__ZN3ccc7DD5x3y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x3y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x3y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x3y9E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x3y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y10  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8CC5x3y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC5x3y103abcEv
  ~CC5x3y10(); // tgen
  CC5x3y10(); // tgen
};
//SIG(1 _ZN3ccc8CC5x3y10E) C1{ VBC2{ v1 v3 v2} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x3y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x3y103pqrEv");}
void  ccc::CC5x3y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x3y103abcEv");}
ccc::CC5x3y10 ::~CC5x3y10(){ note_dtor("_ZN3ccc8CC5x3y10E", this);} // tgen
ccc::CC5x3y10 ::CC5x3y10(){ note_ctor("_ZN3ccc8CC5x3y10E", this);} // tgen
}
static void Test__ZN3ccc8CC5x3y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x3y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x3y10E, buf);
    ::ccc::CC5x3y10 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x3y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x3y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x3y10E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc8CC5x3y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x3y10E);
    dp->::ccc::CC5x3y10::~CC5x3y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x3y10E(Test__ZN3ccc8CC5x3y10E, "_ZN3ccc8CC5x3y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x3y10C1Ev();
extern void _ZN3ccc8CC5x3y10D1Ev();
Name_Map name_map__ZN3ccc8CC5x3y10E[] = {
  NSPAIR(_ZN3ccc8CC5x3y10C1Ev),
  NSPAIR(_ZN3ccc8CC5x3y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC5x3y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y10E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc8CC5x3y103pqrEv();
extern void _ZN3ccc8CC5x3y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x3y103pqrEv,_ZTv0_n12_N3ccc8CC5x3y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x3y103pqrEv,_ZThn4_N3ccc8CC5x3y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x3y103abcEv,_ZTv0_n20_N3ccc8CC5x3y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x3y103abcEv,_ZThn4_N3ccc8CC5x3y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x3y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x3y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x3y103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x3y103pqrEv,_ZTv0_n12_N3ccc8CC5x3y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x3y103abcEv,_ZTv0_n20_N3ccc8CC5x3y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x3y10E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x3y10E[] = {
  {&(_ZTVN3ccc8CC5x3y10E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x3y10E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x3y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x3y10E[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x3y103abcEv,_ZTv0_n20_N3ccc8CC5x3y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x3y103abcEv,_ZThn4_N3ccc8CC5x3y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x3y103pqrEv,_ZTv0_n12_N3ccc8CC5x3y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x3y103pqrEv,_ZThn4_N3ccc8CC5x3y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x3y10E = {  "_ZN3ccc8CC5x3y10E", // class name
  bases__ZN3ccc8CC5x3y10E, 2,
  &(vtc__ZN3ccc8CC5x3y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x3y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x3y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x3y10E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x3y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y10  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8DD5x3y103pqrEv
  virtual void  abc(); // _ZN3ccc8DD5x3y103abcEv
  ~DD5x3y10(); // tgen
  DD5x3y10(); // tgen
};
//SIG(1 _ZN3ccc8DD5x3y10E) C1{ VBC2{ v1 v3 v2} VBC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x3y10 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x3y103pqrEv");}
void  ccc::DD5x3y10 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x3y103abcEv");}
ccc::DD5x3y10 ::~DD5x3y10(){ note_dtor("_ZN3ccc8DD5x3y10E", this);} // tgen
ccc::DD5x3y10 ::DD5x3y10(){ note_ctor("_ZN3ccc8DD5x3y10E", this);} // tgen
}
static void Test__ZN3ccc8DD5x3y10E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x3y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x3y10E, buf);
    ::ccc::DD5x3y10 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x3y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x3y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x3y10E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8DD5x3y10E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x3y10E);
    dp->::ccc::DD5x3y10::~DD5x3y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x3y10E(Test__ZN3ccc8DD5x3y10E, "_ZN3ccc8DD5x3y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x3y10C1Ev();
extern void _ZN3ccc8DD5x3y10D1Ev();
Name_Map name_map__ZN3ccc8DD5x3y10E[] = {
  NSPAIR(_ZN3ccc8DD5x3y10C1Ev),
  NSPAIR(_ZN3ccc8DD5x3y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8DD5x3y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y10E[];
extern void _ZN3ccc8DD5x3y103pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x3y103abcEv();
extern void _ZN3ccc3BB33efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x3y103pqrEv,_ZTv0_n16_N3ccc8DD5x3y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x3y103pqrEv,_ZThn4_N3ccc8DD5x3y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc8DD5x3y103abcEv,_ZTv0_n20_N3ccc8DD5x3y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x3y103abcEv,_ZThn4_N3ccc8DD5x3y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x3y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x3y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x3y103abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x3y103pqrEv,_ZTv0_n16_N3ccc8DD5x3y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8DD5x3y103abcEv,_ZTv0_n20_N3ccc8DD5x3y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x3y10E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x3y10E[] = {
  {&(_ZTVN3ccc8DD5x3y10E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y10E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y10E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x3y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x3y10E[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8DD5x3y103abcEv,_ZTv0_n20_N3ccc8DD5x3y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x3y103abcEv,_ZThn4_N3ccc8DD5x3y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x3y103pqrEv,_ZTv0_n16_N3ccc8DD5x3y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x3y103pqrEv,_ZThn4_N3ccc8DD5x3y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x3y10E = {  "_ZN3ccc8DD5x3y10E", // class name
  bases__ZN3ccc8DD5x3y10E, 2,
  &(vtc__ZN3ccc8DD5x3y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x3y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x3y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x3y10E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x3y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y11  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8CC5x3y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC5x3y113efgEv
  ~CC5x3y11(); // tgen
  CC5x3y11(); // tgen
};
//SIG(1 _ZN3ccc8CC5x3y11E) C1{ VBC2{ v1 v2 v3} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x3y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x3y113pqrEv");}
void  ccc::CC5x3y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x3y113efgEv");}
ccc::CC5x3y11 ::~CC5x3y11(){ note_dtor("_ZN3ccc8CC5x3y11E", this);} // tgen
ccc::CC5x3y11 ::CC5x3y11(){ note_ctor("_ZN3ccc8CC5x3y11E", this);} // tgen
}
static void Test__ZN3ccc8CC5x3y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x3y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x3y11E, buf);
    ::ccc::CC5x3y11 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x3y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x3y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x3y11E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc8CC5x3y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x3y11E);
    dp->::ccc::CC5x3y11::~CC5x3y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x3y11E(Test__ZN3ccc8CC5x3y11E, "_ZN3ccc8CC5x3y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x3y11C1Ev();
extern void _ZN3ccc8CC5x3y11D1Ev();
Name_Map name_map__ZN3ccc8CC5x3y11E[] = {
  NSPAIR(_ZN3ccc8CC5x3y11C1Ev),
  NSPAIR(_ZN3ccc8CC5x3y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC5x3y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y11E[];
extern void _ZN3ccc8CC5x3y113efgEv();
extern void _ZN3ccc8CC5x3y113pqrEv();
extern void _ZN3ccc3BB33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x3y113pqrEv,_ZTv0_n12_N3ccc8CC5x3y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x3y113pqrEv,_ZThn4_N3ccc8CC5x3y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x3y113efgEv,_ZTv0_n16_N3ccc8CC5x3y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x3y113efgEv,_ZThn4_N3ccc8CC5x3y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x3y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x3y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x3y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x3y113pqrEv,_ZTv0_n12_N3ccc8CC5x3y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x3y113efgEv,_ZTv0_n16_N3ccc8CC5x3y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x3y11E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x3y11E[] = {
  {&(_ZTVN3ccc8CC5x3y11E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x3y11E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x3y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x3y11E[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x3y113efgEv,_ZTv0_n16_N3ccc8CC5x3y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x3y113efgEv,_ZThn4_N3ccc8CC5x3y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x3y113pqrEv,_ZTv0_n12_N3ccc8CC5x3y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x3y113pqrEv,_ZThn4_N3ccc8CC5x3y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x3y11E = {  "_ZN3ccc8CC5x3y11E", // class name
  bases__ZN3ccc8CC5x3y11E, 2,
  &(vtc__ZN3ccc8CC5x3y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x3y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x3y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x3y11E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x3y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y11  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8DD5x3y113pqrEv
  virtual void  efg(); // _ZN3ccc8DD5x3y113efgEv
  ~DD5x3y11(); // tgen
  DD5x3y11(); // tgen
};
//SIG(1 _ZN3ccc8DD5x3y11E) C1{ VBC2{ v1 v2 v3} VBC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x3y11 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x3y113pqrEv");}
void  ccc::DD5x3y11 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x3y113efgEv");}
ccc::DD5x3y11 ::~DD5x3y11(){ note_dtor("_ZN3ccc8DD5x3y11E", this);} // tgen
ccc::DD5x3y11 ::DD5x3y11(){ note_ctor("_ZN3ccc8DD5x3y11E", this);} // tgen
}
static void Test__ZN3ccc8DD5x3y11E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x3y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x3y11E, buf);
    ::ccc::DD5x3y11 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x3y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x3y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x3y11E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8DD5x3y11E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x3y11E);
    dp->::ccc::DD5x3y11::~DD5x3y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x3y11E(Test__ZN3ccc8DD5x3y11E, "_ZN3ccc8DD5x3y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x3y11C1Ev();
extern void _ZN3ccc8DD5x3y11D1Ev();
Name_Map name_map__ZN3ccc8DD5x3y11E[] = {
  NSPAIR(_ZN3ccc8DD5x3y11C1Ev),
  NSPAIR(_ZN3ccc8DD5x3y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8DD5x3y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y11E[];
extern void _ZN3ccc8DD5x3y113pqrEv();
extern void _ZN3ccc8DD5x3y113efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x3y113efgEv,_ZTv0_n12_N3ccc8DD5x3y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x3y113efgEv,_ZThn4_N3ccc8DD5x3y113efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x3y113pqrEv,_ZTv0_n16_N3ccc8DD5x3y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x3y113pqrEv,_ZThn4_N3ccc8DD5x3y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x3y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x3y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x3y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x3y113efgEv,_ZTv0_n12_N3ccc8DD5x3y113efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x3y113pqrEv,_ZTv0_n16_N3ccc8DD5x3y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x3y11E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x3y11E[] = {
  {&(_ZTVN3ccc8DD5x3y11E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y11E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y11E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x3y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x3y11E[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x3y113pqrEv,_ZTv0_n16_N3ccc8DD5x3y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x3y113pqrEv,_ZThn4_N3ccc8DD5x3y113pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x3y113efgEv,_ZTv0_n12_N3ccc8DD5x3y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x3y113efgEv,_ZThn4_N3ccc8DD5x3y113efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x3y11E = {  "_ZN3ccc8DD5x3y11E", // class name
  bases__ZN3ccc8DD5x3y11E, 2,
  &(vtc__ZN3ccc8DD5x3y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x3y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x3y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x3y11E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x3y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y12  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc8CC5x3y123abcEv
  ~CC5x3y12(); // tgen
  CC5x3y12(); // tgen
};
//SIG(1 _ZN3ccc8CC5x3y12E) C1{ VBC2{ v2 v3 v1} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC5x3y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x3y123abcEv");}
ccc::CC5x3y12 ::~CC5x3y12(){ note_dtor("_ZN3ccc8CC5x3y12E", this);} // tgen
ccc::CC5x3y12 ::CC5x3y12(){ note_ctor("_ZN3ccc8CC5x3y12E", this);} // tgen
}
static void Test__ZN3ccc8CC5x3y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x3y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x3y12E, buf);
    ::ccc::CC5x3y12 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x3y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x3y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x3y12E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc8CC5x3y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x3y12E);
    dp->::ccc::CC5x3y12::~CC5x3y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x3y12E(Test__ZN3ccc8CC5x3y12E, "_ZN3ccc8CC5x3y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x3y12C1Ev();
extern void _ZN3ccc8CC5x3y12D1Ev();
Name_Map name_map__ZN3ccc8CC5x3y12E[] = {
  NSPAIR(_ZN3ccc8CC5x3y12C1Ev),
  NSPAIR(_ZN3ccc8CC5x3y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC5x3y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y12E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc8CC5x3y123abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x3y123abcEv,_ZTv0_n20_N3ccc8CC5x3y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x3y123abcEv,_ZThn4_N3ccc8CC5x3y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x3y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x3y123abcEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x3y123abcEv,_ZTv0_n20_N3ccc8CC5x3y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x3y12E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x3y12E[] = {
  {&(_ZTVN3ccc8CC5x3y12E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x3y12E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x3y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x3y12E[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x3y123abcEv,_ZTv0_n20_N3ccc8CC5x3y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x3y123abcEv,_ZThn4_N3ccc8CC5x3y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x3y12E = {  "_ZN3ccc8CC5x3y12E", // class name
  bases__ZN3ccc8CC5x3y12E, 2,
  &(vtc__ZN3ccc8CC5x3y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x3y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x3y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x3y12E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x3y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y12  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc8DD5x3y123abcEv
  ~DD5x3y12(); // tgen
  DD5x3y12(); // tgen
};
//SIG(1 _ZN3ccc8DD5x3y12E) C1{ VBC2{ v2 v3 v1} VBC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::DD5x3y12 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x3y123abcEv");}
ccc::DD5x3y12 ::~DD5x3y12(){ note_dtor("_ZN3ccc8DD5x3y12E", this);} // tgen
ccc::DD5x3y12 ::DD5x3y12(){ note_ctor("_ZN3ccc8DD5x3y12E", this);} // tgen
}
static void Test__ZN3ccc8DD5x3y12E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x3y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x3y12E, buf);
    ::ccc::DD5x3y12 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x3y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x3y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x3y12E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8DD5x3y12E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x3y12E);
    dp->::ccc::DD5x3y12::~DD5x3y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x3y12E(Test__ZN3ccc8DD5x3y12E, "_ZN3ccc8DD5x3y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x3y12C1Ev();
extern void _ZN3ccc8DD5x3y12D1Ev();
Name_Map name_map__ZN3ccc8DD5x3y12E[] = {
  NSPAIR(_ZN3ccc8DD5x3y12C1Ev),
  NSPAIR(_ZN3ccc8DD5x3y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8DD5x3y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y12E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x3y123abcEv();
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8DD5x3y123abcEv,_ZTv0_n20_N3ccc8DD5x3y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x3y123abcEv,_ZThn4_N3ccc8DD5x3y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x3y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x3y123abcEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8DD5x3y123abcEv,_ZTv0_n20_N3ccc8DD5x3y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x3y12E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x3y12E[] = {
  {&(_ZTVN3ccc8DD5x3y12E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y12E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y12E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x3y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x3y12E[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8DD5x3y123abcEv,_ZTv0_n20_N3ccc8DD5x3y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x3y123abcEv,_ZThn4_N3ccc8DD5x3y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x3y12E = {  "_ZN3ccc8DD5x3y12E", // class name
  bases__ZN3ccc8DD5x3y12E, 2,
  &(vtc__ZN3ccc8DD5x3y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x3y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x3y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x3y12E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x3y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y13  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc8CC5x3y133efgEv
  ~CC5x3y13(); // tgen
  CC5x3y13(); // tgen
};
//SIG(1 _ZN3ccc8CC5x3y13E) C1{ VBC2{ v2 v1 v3} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC5x3y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x3y133efgEv");}
ccc::CC5x3y13 ::~CC5x3y13(){ note_dtor("_ZN3ccc8CC5x3y13E", this);} // tgen
ccc::CC5x3y13 ::CC5x3y13(){ note_ctor("_ZN3ccc8CC5x3y13E", this);} // tgen
}
static void Test__ZN3ccc8CC5x3y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x3y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x3y13E, buf);
    ::ccc::CC5x3y13 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x3y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x3y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x3y13E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc8CC5x3y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x3y13E);
    dp->::ccc::CC5x3y13::~CC5x3y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x3y13E(Test__ZN3ccc8CC5x3y13E, "_ZN3ccc8CC5x3y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x3y13C1Ev();
extern void _ZN3ccc8CC5x3y13D1Ev();
Name_Map name_map__ZN3ccc8CC5x3y13E[] = {
  NSPAIR(_ZN3ccc8CC5x3y13C1Ev),
  NSPAIR(_ZN3ccc8CC5x3y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC5x3y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y13E[];
extern void _ZN3ccc8CC5x3y133efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x3y133efgEv,_ZTv0_n16_N3ccc8CC5x3y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x3y133efgEv,_ZThn4_N3ccc8CC5x3y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x3y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x3y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x3y133efgEv,_ZTv0_n16_N3ccc8CC5x3y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x3y13E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x3y13E[] = {
  {&(_ZTVN3ccc8CC5x3y13E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x3y13E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x3y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x3y13E[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x3y133efgEv,_ZTv0_n16_N3ccc8CC5x3y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x3y133efgEv,_ZThn4_N3ccc8CC5x3y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x3y13E = {  "_ZN3ccc8CC5x3y13E", // class name
  bases__ZN3ccc8CC5x3y13E, 2,
  &(vtc__ZN3ccc8CC5x3y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x3y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x3y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x3y13E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x3y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y13  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc8DD5x3y133efgEv
  ~DD5x3y13(); // tgen
  DD5x3y13(); // tgen
};
//SIG(1 _ZN3ccc8DD5x3y13E) C1{ VBC2{ v2 v1 v3} VBC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::DD5x3y13 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x3y133efgEv");}
ccc::DD5x3y13 ::~DD5x3y13(){ note_dtor("_ZN3ccc8DD5x3y13E", this);} // tgen
ccc::DD5x3y13 ::DD5x3y13(){ note_ctor("_ZN3ccc8DD5x3y13E", this);} // tgen
}
static void Test__ZN3ccc8DD5x3y13E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x3y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x3y13E, buf);
    ::ccc::DD5x3y13 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x3y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x3y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x3y13E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8DD5x3y13E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x3y13E);
    dp->::ccc::DD5x3y13::~DD5x3y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x3y13E(Test__ZN3ccc8DD5x3y13E, "_ZN3ccc8DD5x3y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x3y13C1Ev();
extern void _ZN3ccc8DD5x3y13D1Ev();
Name_Map name_map__ZN3ccc8DD5x3y13E[] = {
  NSPAIR(_ZN3ccc8DD5x3y13C1Ev),
  NSPAIR(_ZN3ccc8DD5x3y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8DD5x3y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y13E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc8DD5x3y133efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x3y133efgEv,_ZTv0_n12_N3ccc8DD5x3y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x3y133efgEv,_ZThn4_N3ccc8DD5x3y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x3y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x3y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x3y133efgEv,_ZTv0_n12_N3ccc8DD5x3y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x3y13E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x3y13E[] = {
  {&(_ZTVN3ccc8DD5x3y13E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y13E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y13E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x3y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x3y13E[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x3y133efgEv,_ZTv0_n12_N3ccc8DD5x3y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x3y133efgEv,_ZThn4_N3ccc8DD5x3y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x3y13E = {  "_ZN3ccc8DD5x3y13E", // class name
  bases__ZN3ccc8DD5x3y13E, 2,
  &(vtc__ZN3ccc8DD5x3y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x3y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x3y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x3y13E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x3y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y14  : virtual ::ccc::AA5 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8CC5x3y143pqrEv
  ~CC5x3y14(); // tgen
  CC5x3y14(); // tgen
};
//SIG(1 _ZN3ccc8CC5x3y14E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC5x3y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x3y143pqrEv");}
ccc::CC5x3y14 ::~CC5x3y14(){ note_dtor("_ZN3ccc8CC5x3y14E", this);} // tgen
ccc::CC5x3y14 ::CC5x3y14(){ note_ctor("_ZN3ccc8CC5x3y14E", this);} // tgen
}
static void Test__ZN3ccc8CC5x3y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x3y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x3y14E, buf);
    ::ccc::CC5x3y14 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x3y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x3y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x3y14E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc8CC5x3y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x3y14E);
    dp->::ccc::CC5x3y14::~CC5x3y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x3y14E(Test__ZN3ccc8CC5x3y14E, "_ZN3ccc8CC5x3y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x3y14C1Ev();
extern void _ZN3ccc8CC5x3y14D1Ev();
Name_Map name_map__ZN3ccc8CC5x3y14E[] = {
  NSPAIR(_ZN3ccc8CC5x3y14C1Ev),
  NSPAIR(_ZN3ccc8CC5x3y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC5x3y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y14E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc8CC5x3y143pqrEv();
extern void _ZN3ccc3BB33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x3y143pqrEv,_ZTv0_n12_N3ccc8CC5x3y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x3y143pqrEv,_ZThn4_N3ccc8CC5x3y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x3y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x3y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x3y143pqrEv,_ZTv0_n12_N3ccc8CC5x3y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x3y14E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x3y14E[] = {
  {&(_ZTVN3ccc8CC5x3y14E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x3y14E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x3y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x3y14E[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x3y143pqrEv,_ZTv0_n12_N3ccc8CC5x3y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x3y143pqrEv,_ZThn4_N3ccc8CC5x3y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x3y14E = {  "_ZN3ccc8CC5x3y14E", // class name
  bases__ZN3ccc8CC5x3y14E, 2,
  &(vtc__ZN3ccc8CC5x3y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x3y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x3y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x3y14E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x3y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y14  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8DD5x3y143pqrEv
  ~DD5x3y14(); // tgen
  DD5x3y14(); // tgen
};
//SIG(1 _ZN3ccc8DD5x3y14E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::DD5x3y14 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x3y143pqrEv");}
ccc::DD5x3y14 ::~DD5x3y14(){ note_dtor("_ZN3ccc8DD5x3y14E", this);} // tgen
ccc::DD5x3y14 ::DD5x3y14(){ note_ctor("_ZN3ccc8DD5x3y14E", this);} // tgen
}
static void Test__ZN3ccc8DD5x3y14E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x3y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x3y14E, buf);
    ::ccc::DD5x3y14 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x3y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x3y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x3y14E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8DD5x3y14E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x3y14E);
    dp->::ccc::DD5x3y14::~DD5x3y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x3y14E(Test__ZN3ccc8DD5x3y14E, "_ZN3ccc8DD5x3y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x3y14C1Ev();
extern void _ZN3ccc8DD5x3y14D1Ev();
Name_Map name_map__ZN3ccc8DD5x3y14E[] = {
  NSPAIR(_ZN3ccc8DD5x3y14C1Ev),
  NSPAIR(_ZN3ccc8DD5x3y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8DD5x3y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y14E[];
extern void _ZN3ccc8DD5x3y143pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB33efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x3y143pqrEv,_ZTv0_n16_N3ccc8DD5x3y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x3y143pqrEv,_ZThn4_N3ccc8DD5x3y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x3y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x3y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x3y143pqrEv,_ZTv0_n16_N3ccc8DD5x3y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x3y14E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x3y14E[] = {
  {&(_ZTVN3ccc8DD5x3y14E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y14E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y14E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x3y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x3y14E[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x3y143pqrEv,_ZTv0_n16_N3ccc8DD5x3y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x3y143pqrEv,_ZThn4_N3ccc8DD5x3y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x3y14E = {  "_ZN3ccc8DD5x3y14E", // class name
  bases__ZN3ccc8DD5x3y14E, 2,
  &(vtc__ZN3ccc8DD5x3y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x3y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x3y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x3y14E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x3y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x3y15  : virtual ::ccc::AA5 , ::ccc::BB3 {
  ~CC5x3y15(); // tgen
  CC5x3y15(); // tgen
};
//SIG(1 _ZN3ccc8CC5x3y15E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC5x3y15 ::~CC5x3y15(){ note_dtor("_ZN3ccc8CC5x3y15E", this);} // tgen
ccc::CC5x3y15 ::CC5x3y15(){ note_ctor("_ZN3ccc8CC5x3y15E", this);} // tgen
}
static void Test__ZN3ccc8CC5x3y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x3y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x3y15E, buf);
    ::ccc::CC5x3y15 *dp, &lv = *(dp=new (buf) ::ccc::CC5x3y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x3y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x3y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x3y15E");
    check_base_class_offset(lv, (::ccc::BB3*), 0, "_ZN3ccc8CC5x3y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x3y15E);
    dp->::ccc::CC5x3y15::~CC5x3y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x3y15E(Test__ZN3ccc8CC5x3y15E, "_ZN3ccc8CC5x3y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x3y15C1Ev();
extern void _ZN3ccc8CC5x3y15D1Ev();
Name_Map name_map__ZN3ccc8CC5x3y15E[] = {
  NSPAIR(_ZN3ccc8CC5x3y15C1Ev),
  NSPAIR(_ZN3ccc8CC5x3y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC5x3y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y15E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x3y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x3y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x3y15E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x3y15E[] = {
  {&(_ZTVN3ccc8CC5x3y15E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x3y15E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x3y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x3y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x3y15E[];
Class_Descriptor cd__ZN3ccc8CC5x3y15E = {  "_ZN3ccc8CC5x3y15E", // class name
  bases__ZN3ccc8CC5x3y15E, 2,
  &(vtc__ZN3ccc8CC5x3y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x3y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x3y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x3y15E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x3y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x3y15  : virtual ::ccc::AA5 , virtual ::ccc::BB3 {
  ~DD5x3y15(); // tgen
  DD5x3y15(); // tgen
};
//SIG(1 _ZN3ccc8DD5x3y15E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::DD5x3y15 ::~DD5x3y15(){ note_dtor("_ZN3ccc8DD5x3y15E", this);} // tgen
ccc::DD5x3y15 ::DD5x3y15(){ note_ctor("_ZN3ccc8DD5x3y15E", this);} // tgen
}
static void Test__ZN3ccc8DD5x3y15E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x3y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x3y15E, buf);
    ::ccc::DD5x3y15 *dp, &lv = *(dp=new (buf) ::ccc::DD5x3y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x3y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x3y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x3y15E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8DD5x3y15E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x3y15E);
    dp->::ccc::DD5x3y15::~DD5x3y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x3y15E(Test__ZN3ccc8DD5x3y15E, "_ZN3ccc8DD5x3y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x3y15C1Ev();
extern void _ZN3ccc8DD5x3y15D1Ev();
Name_Map name_map__ZN3ccc8DD5x3y15E[] = {
  NSPAIR(_ZN3ccc8DD5x3y15C1Ev),
  NSPAIR(_ZN3ccc8DD5x3y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8DD5x3y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y15E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x3y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x3y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x3y15E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x3y15E[] = {
  {&(_ZTVN3ccc8DD5x3y15E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y15E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x3y15E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x3y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x3y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x3y15E[];
Class_Descriptor cd__ZN3ccc8DD5x3y15E = {  "_ZN3ccc8DD5x3y15E", // class name
  bases__ZN3ccc8DD5x3y15E, 2,
  &(vtc__ZN3ccc8DD5x3y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x3y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x3y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x3y15E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x3y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y0  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC5x4y03abcEv
  virtual void  efg(); // _ZN3ccc7CC5x4y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x4y03pqrEv
  ~CC5x4y0(); // tgen
  CC5x4y0(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y0E) C1{ VBC2{ v3 v2 v1} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x4y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y03abcEv");}
void  ccc::CC5x4y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y03efgEv");}
void  ccc::CC5x4y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y03pqrEv");}
ccc::CC5x4y0 ::~CC5x4y0(){ note_dtor("_ZN3ccc7CC5x4y0E", this);} // tgen
ccc::CC5x4y0 ::CC5x4y0(){ note_ctor("_ZN3ccc7CC5x4y0E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y0E, buf);
    ::ccc::CC5x4y0 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y0E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y0E);
    dp->::ccc::CC5x4y0::~CC5x4y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y0E(Test__ZN3ccc7CC5x4y0E, "_ZN3ccc7CC5x4y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y0C1Ev();
extern void _ZN3ccc7CC5x4y0D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y0E[] = {
  NSPAIR(_ZN3ccc7CC5x4y0C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y0E[];
extern void _ZN3ccc7CC5x4y03pqrEv();
extern void _ZN3ccc7CC5x4y03abcEv();
extern void _ZN3ccc7CC5x4y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y03pqrEv,_ZTv0_n12_N3ccc7CC5x4y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y03pqrEv,_ZThn4_N3ccc7CC5x4y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y03efgEv,_ZTv0_n16_N3ccc7CC5x4y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y03efgEv,_ZThn4_N3ccc7CC5x4y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y03abcEv,_ZTv0_n20_N3ccc7CC5x4y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y03abcEv,_ZThn4_N3ccc7CC5x4y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y03pqrEv,_ZTv0_n12_N3ccc7CC5x4y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y03efgEv,_ZTv0_n16_N3ccc7CC5x4y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y03abcEv,_ZTv0_n20_N3ccc7CC5x4y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y0E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y0E[] = {
  {&(_ZTVN3ccc7CC5x4y0E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y0E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y0E[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y03abcEv,_ZTv0_n20_N3ccc7CC5x4y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y03abcEv,_ZThn4_N3ccc7CC5x4y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y03efgEv,_ZTv0_n16_N3ccc7CC5x4y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y03efgEv,_ZThn4_N3ccc7CC5x4y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y03pqrEv,_ZTv0_n12_N3ccc7CC5x4y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y03pqrEv,_ZThn4_N3ccc7CC5x4y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y0E = {  "_ZN3ccc7CC5x4y0E", // class name
  bases__ZN3ccc7CC5x4y0E, 2,
  &(vtc__ZN3ccc7CC5x4y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y0E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y0  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7DD5x4y03abcEv
  virtual void  efg(); // _ZN3ccc7DD5x4y03efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x4y03pqrEv
  ~DD5x4y0(); // tgen
  DD5x4y0(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y0E) C1{ VBC2{ v3 v2 v1} VBC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x4y0 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y03abcEv");}
void  ccc::DD5x4y0 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y03efgEv");}
void  ccc::DD5x4y0 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y03pqrEv");}
ccc::DD5x4y0 ::~DD5x4y0(){ note_dtor("_ZN3ccc7DD5x4y0E", this);} // tgen
ccc::DD5x4y0 ::DD5x4y0(){ note_ctor("_ZN3ccc7DD5x4y0E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y0E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y0E, buf);
    ::ccc::DD5x4y0 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y0E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y0E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y0E);
    dp->::ccc::DD5x4y0::~DD5x4y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y0E(Test__ZN3ccc7DD5x4y0E, "_ZN3ccc7DD5x4y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y0C1Ev();
extern void _ZN3ccc7DD5x4y0D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y0E[] = {
  NSPAIR(_ZN3ccc7DD5x4y0C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y0E[];
extern void _ZN3ccc7DD5x4y03pqrEv();
extern void _ZN3ccc7DD5x4y03efgEv();
extern void _ZN3ccc7DD5x4y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y03pqrEv,_ZTv0_n12_N3ccc7DD5x4y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y03pqrEv,_ZThn4_N3ccc7DD5x4y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y03abcEv,_ZTv0_n16_N3ccc7DD5x4y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y03abcEv,_ZThn4_N3ccc7DD5x4y03abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y03efgEv,_ZTv0_n20_N3ccc7DD5x4y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y03efgEv,_ZThn4_N3ccc7DD5x4y03efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y03pqrEv,_ZTv0_n12_N3ccc7DD5x4y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y03abcEv,_ZTv0_n16_N3ccc7DD5x4y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y03efgEv,_ZTv0_n20_N3ccc7DD5x4y03efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y0E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y0E[] = {
  {&(_ZTVN3ccc7DD5x4y0E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y0E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y0E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y0E[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y03efgEv,_ZTv0_n20_N3ccc7DD5x4y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y03efgEv,_ZThn4_N3ccc7DD5x4y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y03abcEv,_ZTv0_n16_N3ccc7DD5x4y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y03abcEv,_ZThn4_N3ccc7DD5x4y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y03pqrEv,_ZTv0_n12_N3ccc7DD5x4y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y03pqrEv,_ZThn4_N3ccc7DD5x4y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y0E = {  "_ZN3ccc7DD5x4y0E", // class name
  bases__ZN3ccc7DD5x4y0E, 2,
  &(vtc__ZN3ccc7DD5x4y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y0E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y1  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC5x4y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x4y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x4y13efgEv
  ~CC5x4y1(); // tgen
  CC5x4y1(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y1E) C1{ VBC2{ v2 v3 v1} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x4y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y13abcEv");}
void  ccc::CC5x4y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y13pqrEv");}
void  ccc::CC5x4y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y13efgEv");}
ccc::CC5x4y1 ::~CC5x4y1(){ note_dtor("_ZN3ccc7CC5x4y1E", this);} // tgen
ccc::CC5x4y1 ::CC5x4y1(){ note_ctor("_ZN3ccc7CC5x4y1E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y1E, buf);
    ::ccc::CC5x4y1 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y1E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y1E);
    dp->::ccc::CC5x4y1::~CC5x4y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y1E(Test__ZN3ccc7CC5x4y1E, "_ZN3ccc7CC5x4y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y1C1Ev();
extern void _ZN3ccc7CC5x4y1D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y1E[] = {
  NSPAIR(_ZN3ccc7CC5x4y1C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y1E[];
extern void _ZN3ccc7CC5x4y13pqrEv();
extern void _ZN3ccc7CC5x4y13abcEv();
extern void _ZN3ccc7CC5x4y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y13pqrEv,_ZTv0_n12_N3ccc7CC5x4y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y13pqrEv,_ZThn4_N3ccc7CC5x4y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y13efgEv,_ZTv0_n16_N3ccc7CC5x4y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y13efgEv,_ZThn4_N3ccc7CC5x4y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y13abcEv,_ZTv0_n20_N3ccc7CC5x4y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y13abcEv,_ZThn4_N3ccc7CC5x4y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y13pqrEv,_ZTv0_n12_N3ccc7CC5x4y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y13efgEv,_ZTv0_n16_N3ccc7CC5x4y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y13abcEv,_ZTv0_n20_N3ccc7CC5x4y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y1E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y1E[] = {
  {&(_ZTVN3ccc7CC5x4y1E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y1E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y1E[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y13abcEv,_ZTv0_n20_N3ccc7CC5x4y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y13abcEv,_ZThn4_N3ccc7CC5x4y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y13efgEv,_ZTv0_n16_N3ccc7CC5x4y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y13efgEv,_ZThn4_N3ccc7CC5x4y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y13pqrEv,_ZTv0_n12_N3ccc7CC5x4y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y13pqrEv,_ZThn4_N3ccc7CC5x4y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y1E = {  "_ZN3ccc7CC5x4y1E", // class name
  bases__ZN3ccc7CC5x4y1E, 2,
  &(vtc__ZN3ccc7CC5x4y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y1E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y1  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7DD5x4y13abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x4y13pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x4y13efgEv
  ~DD5x4y1(); // tgen
  DD5x4y1(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y1E) C1{ VBC2{ v2 v3 v1} VBC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x4y1 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y13abcEv");}
void  ccc::DD5x4y1 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y13pqrEv");}
void  ccc::DD5x4y1 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y13efgEv");}
ccc::DD5x4y1 ::~DD5x4y1(){ note_dtor("_ZN3ccc7DD5x4y1E", this);} // tgen
ccc::DD5x4y1 ::DD5x4y1(){ note_ctor("_ZN3ccc7DD5x4y1E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y1E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y1E, buf);
    ::ccc::DD5x4y1 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y1E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y1E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y1E);
    dp->::ccc::DD5x4y1::~DD5x4y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y1E(Test__ZN3ccc7DD5x4y1E, "_ZN3ccc7DD5x4y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y1C1Ev();
extern void _ZN3ccc7DD5x4y1D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y1E[] = {
  NSPAIR(_ZN3ccc7DD5x4y1C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y1E[];
extern void _ZN3ccc7DD5x4y13pqrEv();
extern void _ZN3ccc7DD5x4y13efgEv();
extern void _ZN3ccc7DD5x4y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y13pqrEv,_ZTv0_n12_N3ccc7DD5x4y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y13pqrEv,_ZThn4_N3ccc7DD5x4y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y13abcEv,_ZTv0_n16_N3ccc7DD5x4y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y13abcEv,_ZThn4_N3ccc7DD5x4y13abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y13efgEv,_ZTv0_n20_N3ccc7DD5x4y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y13efgEv,_ZThn4_N3ccc7DD5x4y13efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y13pqrEv,_ZTv0_n12_N3ccc7DD5x4y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y13abcEv,_ZTv0_n16_N3ccc7DD5x4y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y13efgEv,_ZTv0_n20_N3ccc7DD5x4y13efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y1E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y1E[] = {
  {&(_ZTVN3ccc7DD5x4y1E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y1E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y1E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y1E[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y13efgEv,_ZTv0_n20_N3ccc7DD5x4y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y13efgEv,_ZThn4_N3ccc7DD5x4y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y13abcEv,_ZTv0_n16_N3ccc7DD5x4y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y13abcEv,_ZThn4_N3ccc7DD5x4y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y13pqrEv,_ZTv0_n12_N3ccc7DD5x4y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y13pqrEv,_ZThn4_N3ccc7DD5x4y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y1E = {  "_ZN3ccc7DD5x4y1E", // class name
  bases__ZN3ccc7DD5x4y1E, 2,
  &(vtc__ZN3ccc7DD5x4y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y1E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y2  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC5x4y23efgEv
  virtual void  abc(); // _ZN3ccc7CC5x4y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x4y23pqrEv
  ~CC5x4y2(); // tgen
  CC5x4y2(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y2E) C1{ VBC2{ v3 v1 v2} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x4y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y23efgEv");}
void  ccc::CC5x4y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y23abcEv");}
void  ccc::CC5x4y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y23pqrEv");}
ccc::CC5x4y2 ::~CC5x4y2(){ note_dtor("_ZN3ccc7CC5x4y2E", this);} // tgen
ccc::CC5x4y2 ::CC5x4y2(){ note_ctor("_ZN3ccc7CC5x4y2E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y2E, buf);
    ::ccc::CC5x4y2 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y2E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y2E);
    dp->::ccc::CC5x4y2::~CC5x4y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y2E(Test__ZN3ccc7CC5x4y2E, "_ZN3ccc7CC5x4y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y2C1Ev();
extern void _ZN3ccc7CC5x4y2D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y2E[] = {
  NSPAIR(_ZN3ccc7CC5x4y2C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y2E[];
extern void _ZN3ccc7CC5x4y23pqrEv();
extern void _ZN3ccc7CC5x4y23abcEv();
extern void _ZN3ccc7CC5x4y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y23pqrEv,_ZTv0_n12_N3ccc7CC5x4y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y23pqrEv,_ZThn4_N3ccc7CC5x4y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y23efgEv,_ZTv0_n16_N3ccc7CC5x4y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y23efgEv,_ZThn4_N3ccc7CC5x4y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y23abcEv,_ZTv0_n20_N3ccc7CC5x4y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y23abcEv,_ZThn4_N3ccc7CC5x4y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y23pqrEv,_ZTv0_n12_N3ccc7CC5x4y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y23efgEv,_ZTv0_n16_N3ccc7CC5x4y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y23abcEv,_ZTv0_n20_N3ccc7CC5x4y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y2E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y2E[] = {
  {&(_ZTVN3ccc7CC5x4y2E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y2E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y2E[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y23abcEv,_ZTv0_n20_N3ccc7CC5x4y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y23abcEv,_ZThn4_N3ccc7CC5x4y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y23efgEv,_ZTv0_n16_N3ccc7CC5x4y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y23efgEv,_ZThn4_N3ccc7CC5x4y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y23pqrEv,_ZTv0_n12_N3ccc7CC5x4y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y23pqrEv,_ZThn4_N3ccc7CC5x4y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y2E = {  "_ZN3ccc7CC5x4y2E", // class name
  bases__ZN3ccc7CC5x4y2E, 2,
  &(vtc__ZN3ccc7CC5x4y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y2E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y2  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7DD5x4y23efgEv
  virtual void  abc(); // _ZN3ccc7DD5x4y23abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x4y23pqrEv
  ~DD5x4y2(); // tgen
  DD5x4y2(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y2E) C1{ VBC2{ v3 v1 v2} VBC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x4y2 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y23efgEv");}
void  ccc::DD5x4y2 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y23abcEv");}
void  ccc::DD5x4y2 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y23pqrEv");}
ccc::DD5x4y2 ::~DD5x4y2(){ note_dtor("_ZN3ccc7DD5x4y2E", this);} // tgen
ccc::DD5x4y2 ::DD5x4y2(){ note_ctor("_ZN3ccc7DD5x4y2E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y2E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y2E, buf);
    ::ccc::DD5x4y2 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y2E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y2E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y2E);
    dp->::ccc::DD5x4y2::~DD5x4y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y2E(Test__ZN3ccc7DD5x4y2E, "_ZN3ccc7DD5x4y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y2C1Ev();
extern void _ZN3ccc7DD5x4y2D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y2E[] = {
  NSPAIR(_ZN3ccc7DD5x4y2C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y2E[];
extern void _ZN3ccc7DD5x4y23pqrEv();
extern void _ZN3ccc7DD5x4y23efgEv();
extern void _ZN3ccc7DD5x4y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y23pqrEv,_ZTv0_n12_N3ccc7DD5x4y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y23pqrEv,_ZThn4_N3ccc7DD5x4y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y23abcEv,_ZTv0_n16_N3ccc7DD5x4y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y23abcEv,_ZThn4_N3ccc7DD5x4y23abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y23efgEv,_ZTv0_n20_N3ccc7DD5x4y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y23efgEv,_ZThn4_N3ccc7DD5x4y23efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y23pqrEv,_ZTv0_n12_N3ccc7DD5x4y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y23abcEv,_ZTv0_n16_N3ccc7DD5x4y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y23efgEv,_ZTv0_n20_N3ccc7DD5x4y23efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y2E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y2E[] = {
  {&(_ZTVN3ccc7DD5x4y2E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y2E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y2E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y2E[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y23efgEv,_ZTv0_n20_N3ccc7DD5x4y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y23efgEv,_ZThn4_N3ccc7DD5x4y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y23abcEv,_ZTv0_n16_N3ccc7DD5x4y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y23abcEv,_ZThn4_N3ccc7DD5x4y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y23pqrEv,_ZTv0_n12_N3ccc7DD5x4y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y23pqrEv,_ZThn4_N3ccc7DD5x4y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y2E = {  "_ZN3ccc7DD5x4y2E", // class name
  bases__ZN3ccc7DD5x4y2E, 2,
  &(vtc__ZN3ccc7DD5x4y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y2E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y3  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC5x4y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x4y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x4y33abcEv
  ~CC5x4y3(); // tgen
  CC5x4y3(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y3E) C1{ VBC2{ v2 v1 v3} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x4y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y33efgEv");}
void  ccc::CC5x4y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y33pqrEv");}
void  ccc::CC5x4y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y33abcEv");}
ccc::CC5x4y3 ::~CC5x4y3(){ note_dtor("_ZN3ccc7CC5x4y3E", this);} // tgen
ccc::CC5x4y3 ::CC5x4y3(){ note_ctor("_ZN3ccc7CC5x4y3E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y3E, buf);
    ::ccc::CC5x4y3 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y3E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y3E);
    dp->::ccc::CC5x4y3::~CC5x4y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y3E(Test__ZN3ccc7CC5x4y3E, "_ZN3ccc7CC5x4y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y3C1Ev();
extern void _ZN3ccc7CC5x4y3D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y3E[] = {
  NSPAIR(_ZN3ccc7CC5x4y3C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y3E[];
extern void _ZN3ccc7CC5x4y33pqrEv();
extern void _ZN3ccc7CC5x4y33abcEv();
extern void _ZN3ccc7CC5x4y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y33pqrEv,_ZTv0_n12_N3ccc7CC5x4y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y33pqrEv,_ZThn4_N3ccc7CC5x4y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y33efgEv,_ZTv0_n16_N3ccc7CC5x4y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y33efgEv,_ZThn4_N3ccc7CC5x4y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y33abcEv,_ZTv0_n20_N3ccc7CC5x4y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y33abcEv,_ZThn4_N3ccc7CC5x4y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y33pqrEv,_ZTv0_n12_N3ccc7CC5x4y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y33efgEv,_ZTv0_n16_N3ccc7CC5x4y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y33abcEv,_ZTv0_n20_N3ccc7CC5x4y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y3E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y3E[] = {
  {&(_ZTVN3ccc7CC5x4y3E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y3E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y3E[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y33abcEv,_ZTv0_n20_N3ccc7CC5x4y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y33abcEv,_ZThn4_N3ccc7CC5x4y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y33efgEv,_ZTv0_n16_N3ccc7CC5x4y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y33efgEv,_ZThn4_N3ccc7CC5x4y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y33pqrEv,_ZTv0_n12_N3ccc7CC5x4y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y33pqrEv,_ZThn4_N3ccc7CC5x4y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y3E = {  "_ZN3ccc7CC5x4y3E", // class name
  bases__ZN3ccc7CC5x4y3E, 2,
  &(vtc__ZN3ccc7CC5x4y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y3E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y3  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7DD5x4y33efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x4y33pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x4y33abcEv
  ~DD5x4y3(); // tgen
  DD5x4y3(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y3E) C1{ VBC2{ v2 v1 v3} VBC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x4y3 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y33efgEv");}
void  ccc::DD5x4y3 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y33pqrEv");}
void  ccc::DD5x4y3 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y33abcEv");}
ccc::DD5x4y3 ::~DD5x4y3(){ note_dtor("_ZN3ccc7DD5x4y3E", this);} // tgen
ccc::DD5x4y3 ::DD5x4y3(){ note_ctor("_ZN3ccc7DD5x4y3E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y3E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y3E, buf);
    ::ccc::DD5x4y3 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y3E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y3E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y3E);
    dp->::ccc::DD5x4y3::~DD5x4y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y3E(Test__ZN3ccc7DD5x4y3E, "_ZN3ccc7DD5x4y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y3C1Ev();
extern void _ZN3ccc7DD5x4y3D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y3E[] = {
  NSPAIR(_ZN3ccc7DD5x4y3C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y3E[];
extern void _ZN3ccc7DD5x4y33pqrEv();
extern void _ZN3ccc7DD5x4y33efgEv();
extern void _ZN3ccc7DD5x4y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y33pqrEv,_ZTv0_n12_N3ccc7DD5x4y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y33pqrEv,_ZThn4_N3ccc7DD5x4y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y33abcEv,_ZTv0_n16_N3ccc7DD5x4y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y33abcEv,_ZThn4_N3ccc7DD5x4y33abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y33efgEv,_ZTv0_n20_N3ccc7DD5x4y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y33efgEv,_ZThn4_N3ccc7DD5x4y33efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y33pqrEv,_ZTv0_n12_N3ccc7DD5x4y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y33abcEv,_ZTv0_n16_N3ccc7DD5x4y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y33efgEv,_ZTv0_n20_N3ccc7DD5x4y33efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y3E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y3E[] = {
  {&(_ZTVN3ccc7DD5x4y3E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y3E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y3E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y3E[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y33efgEv,_ZTv0_n20_N3ccc7DD5x4y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y33efgEv,_ZThn4_N3ccc7DD5x4y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y33abcEv,_ZTv0_n16_N3ccc7DD5x4y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y33abcEv,_ZThn4_N3ccc7DD5x4y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y33pqrEv,_ZTv0_n12_N3ccc7DD5x4y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y33pqrEv,_ZThn4_N3ccc7DD5x4y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y3E = {  "_ZN3ccc7DD5x4y3E", // class name
  bases__ZN3ccc7DD5x4y3E, 2,
  &(vtc__ZN3ccc7DD5x4y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y3E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y4  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc7CC5x4y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x4y43abcEv
  virtual void  efg(); // _ZN3ccc7CC5x4y43efgEv
  ~CC5x4y4(); // tgen
  CC5x4y4(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y4E) C1{ VBC2{ v1 v3 v2} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x4y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y43pqrEv");}
void  ccc::CC5x4y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y43abcEv");}
void  ccc::CC5x4y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y43efgEv");}
ccc::CC5x4y4 ::~CC5x4y4(){ note_dtor("_ZN3ccc7CC5x4y4E", this);} // tgen
ccc::CC5x4y4 ::CC5x4y4(){ note_ctor("_ZN3ccc7CC5x4y4E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y4E, buf);
    ::ccc::CC5x4y4 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y4E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y4E);
    dp->::ccc::CC5x4y4::~CC5x4y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y4E(Test__ZN3ccc7CC5x4y4E, "_ZN3ccc7CC5x4y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y4C1Ev();
extern void _ZN3ccc7CC5x4y4D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y4E[] = {
  NSPAIR(_ZN3ccc7CC5x4y4C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y4E[];
extern void _ZN3ccc7CC5x4y43pqrEv();
extern void _ZN3ccc7CC5x4y43abcEv();
extern void _ZN3ccc7CC5x4y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y43pqrEv,_ZTv0_n12_N3ccc7CC5x4y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y43pqrEv,_ZThn4_N3ccc7CC5x4y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y43efgEv,_ZTv0_n16_N3ccc7CC5x4y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y43efgEv,_ZThn4_N3ccc7CC5x4y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y43abcEv,_ZTv0_n20_N3ccc7CC5x4y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y43abcEv,_ZThn4_N3ccc7CC5x4y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y43pqrEv,_ZTv0_n12_N3ccc7CC5x4y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y43efgEv,_ZTv0_n16_N3ccc7CC5x4y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y43abcEv,_ZTv0_n20_N3ccc7CC5x4y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y4E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y4E[] = {
  {&(_ZTVN3ccc7CC5x4y4E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y4E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y4E[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y43abcEv,_ZTv0_n20_N3ccc7CC5x4y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y43abcEv,_ZThn4_N3ccc7CC5x4y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y43efgEv,_ZTv0_n16_N3ccc7CC5x4y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y43efgEv,_ZThn4_N3ccc7CC5x4y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y43pqrEv,_ZTv0_n12_N3ccc7CC5x4y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y43pqrEv,_ZThn4_N3ccc7CC5x4y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y4E = {  "_ZN3ccc7CC5x4y4E", // class name
  bases__ZN3ccc7CC5x4y4E, 2,
  &(vtc__ZN3ccc7CC5x4y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y4E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y4  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc7DD5x4y43pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x4y43abcEv
  virtual void  efg(); // _ZN3ccc7DD5x4y43efgEv
  ~DD5x4y4(); // tgen
  DD5x4y4(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y4E) C1{ VBC2{ v1 v3 v2} VBC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x4y4 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y43pqrEv");}
void  ccc::DD5x4y4 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y43abcEv");}
void  ccc::DD5x4y4 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y43efgEv");}
ccc::DD5x4y4 ::~DD5x4y4(){ note_dtor("_ZN3ccc7DD5x4y4E", this);} // tgen
ccc::DD5x4y4 ::DD5x4y4(){ note_ctor("_ZN3ccc7DD5x4y4E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y4E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y4E, buf);
    ::ccc::DD5x4y4 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y4E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y4E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y4E);
    dp->::ccc::DD5x4y4::~DD5x4y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y4E(Test__ZN3ccc7DD5x4y4E, "_ZN3ccc7DD5x4y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y4C1Ev();
extern void _ZN3ccc7DD5x4y4D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y4E[] = {
  NSPAIR(_ZN3ccc7DD5x4y4C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y4E[];
extern void _ZN3ccc7DD5x4y43pqrEv();
extern void _ZN3ccc7DD5x4y43efgEv();
extern void _ZN3ccc7DD5x4y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y43pqrEv,_ZTv0_n12_N3ccc7DD5x4y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y43pqrEv,_ZThn4_N3ccc7DD5x4y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y43abcEv,_ZTv0_n16_N3ccc7DD5x4y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y43abcEv,_ZThn4_N3ccc7DD5x4y43abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y43efgEv,_ZTv0_n20_N3ccc7DD5x4y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y43efgEv,_ZThn4_N3ccc7DD5x4y43efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y43pqrEv,_ZTv0_n12_N3ccc7DD5x4y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y43abcEv,_ZTv0_n16_N3ccc7DD5x4y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y43efgEv,_ZTv0_n20_N3ccc7DD5x4y43efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y4E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y4E[] = {
  {&(_ZTVN3ccc7DD5x4y4E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y4E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y4E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y4E[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y43efgEv,_ZTv0_n20_N3ccc7DD5x4y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y43efgEv,_ZThn4_N3ccc7DD5x4y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y43abcEv,_ZTv0_n16_N3ccc7DD5x4y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y43abcEv,_ZThn4_N3ccc7DD5x4y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y43pqrEv,_ZTv0_n12_N3ccc7DD5x4y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y43pqrEv,_ZThn4_N3ccc7DD5x4y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y4E = {  "_ZN3ccc7DD5x4y4E", // class name
  bases__ZN3ccc7DD5x4y4E, 2,
  &(vtc__ZN3ccc7DD5x4y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y4E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y5  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc7CC5x4y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x4y53efgEv
  virtual void  abc(); // _ZN3ccc7CC5x4y53abcEv
  ~CC5x4y5(); // tgen
  CC5x4y5(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y5E) C1{ VBC2{ v1 v2 v3} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x4y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y53pqrEv");}
void  ccc::CC5x4y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y53efgEv");}
void  ccc::CC5x4y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y53abcEv");}
ccc::CC5x4y5 ::~CC5x4y5(){ note_dtor("_ZN3ccc7CC5x4y5E", this);} // tgen
ccc::CC5x4y5 ::CC5x4y5(){ note_ctor("_ZN3ccc7CC5x4y5E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y5E, buf);
    ::ccc::CC5x4y5 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y5E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y5E);
    dp->::ccc::CC5x4y5::~CC5x4y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y5E(Test__ZN3ccc7CC5x4y5E, "_ZN3ccc7CC5x4y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y5C1Ev();
extern void _ZN3ccc7CC5x4y5D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y5E[] = {
  NSPAIR(_ZN3ccc7CC5x4y5C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y5E[];
extern void _ZN3ccc7CC5x4y53pqrEv();
extern void _ZN3ccc7CC5x4y53abcEv();
extern void _ZN3ccc7CC5x4y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y53pqrEv,_ZTv0_n12_N3ccc7CC5x4y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y53pqrEv,_ZThn4_N3ccc7CC5x4y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y53efgEv,_ZTv0_n16_N3ccc7CC5x4y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y53efgEv,_ZThn4_N3ccc7CC5x4y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y53abcEv,_ZTv0_n20_N3ccc7CC5x4y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y53abcEv,_ZThn4_N3ccc7CC5x4y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y53pqrEv,_ZTv0_n12_N3ccc7CC5x4y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y53efgEv,_ZTv0_n16_N3ccc7CC5x4y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y53abcEv,_ZTv0_n20_N3ccc7CC5x4y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y5E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y5E[] = {
  {&(_ZTVN3ccc7CC5x4y5E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y5E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y5E[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y53abcEv,_ZTv0_n20_N3ccc7CC5x4y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y53abcEv,_ZThn4_N3ccc7CC5x4y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y53efgEv,_ZTv0_n16_N3ccc7CC5x4y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y53efgEv,_ZThn4_N3ccc7CC5x4y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y53pqrEv,_ZTv0_n12_N3ccc7CC5x4y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y53pqrEv,_ZThn4_N3ccc7CC5x4y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y5E = {  "_ZN3ccc7CC5x4y5E", // class name
  bases__ZN3ccc7CC5x4y5E, 2,
  &(vtc__ZN3ccc7CC5x4y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y5E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y5  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc7DD5x4y53pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x4y53efgEv
  virtual void  abc(); // _ZN3ccc7DD5x4y53abcEv
  ~DD5x4y5(); // tgen
  DD5x4y5(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y5E) C1{ VBC2{ v1 v2 v3} VBC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x4y5 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y53pqrEv");}
void  ccc::DD5x4y5 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y53efgEv");}
void  ccc::DD5x4y5 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y53abcEv");}
ccc::DD5x4y5 ::~DD5x4y5(){ note_dtor("_ZN3ccc7DD5x4y5E", this);} // tgen
ccc::DD5x4y5 ::DD5x4y5(){ note_ctor("_ZN3ccc7DD5x4y5E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y5E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y5E, buf);
    ::ccc::DD5x4y5 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y5E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y5E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y5E);
    dp->::ccc::DD5x4y5::~DD5x4y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y5E(Test__ZN3ccc7DD5x4y5E, "_ZN3ccc7DD5x4y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y5C1Ev();
extern void _ZN3ccc7DD5x4y5D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y5E[] = {
  NSPAIR(_ZN3ccc7DD5x4y5C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y5E[];
extern void _ZN3ccc7DD5x4y53pqrEv();
extern void _ZN3ccc7DD5x4y53efgEv();
extern void _ZN3ccc7DD5x4y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y53pqrEv,_ZTv0_n12_N3ccc7DD5x4y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y53pqrEv,_ZThn4_N3ccc7DD5x4y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y53abcEv,_ZTv0_n16_N3ccc7DD5x4y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y53abcEv,_ZThn4_N3ccc7DD5x4y53abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y53efgEv,_ZTv0_n20_N3ccc7DD5x4y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y53efgEv,_ZThn4_N3ccc7DD5x4y53efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y53pqrEv,_ZTv0_n12_N3ccc7DD5x4y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y53abcEv,_ZTv0_n16_N3ccc7DD5x4y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y53efgEv,_ZTv0_n20_N3ccc7DD5x4y53efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y5E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y5E[] = {
  {&(_ZTVN3ccc7DD5x4y5E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y5E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y5E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y5E[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y53efgEv,_ZTv0_n20_N3ccc7DD5x4y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y53efgEv,_ZThn4_N3ccc7DD5x4y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y53abcEv,_ZTv0_n16_N3ccc7DD5x4y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y53abcEv,_ZThn4_N3ccc7DD5x4y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y53pqrEv,_ZTv0_n12_N3ccc7DD5x4y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y53pqrEv,_ZThn4_N3ccc7DD5x4y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y5E = {  "_ZN3ccc7DD5x4y5E", // class name
  bases__ZN3ccc7DD5x4y5E, 2,
  &(vtc__ZN3ccc7DD5x4y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y5E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y6  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC5x4y63abcEv
  virtual void  efg(); // _ZN3ccc7CC5x4y63efgEv
  ~CC5x4y6(); // tgen
  CC5x4y6(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y6E) C1{ VBC2{ v3 v2 v1} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x4y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y63abcEv");}
void  ccc::CC5x4y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y63efgEv");}
ccc::CC5x4y6 ::~CC5x4y6(){ note_dtor("_ZN3ccc7CC5x4y6E", this);} // tgen
ccc::CC5x4y6 ::CC5x4y6(){ note_ctor("_ZN3ccc7CC5x4y6E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y6E, buf);
    ::ccc::CC5x4y6 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y6E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y6E);
    dp->::ccc::CC5x4y6::~CC5x4y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y6E(Test__ZN3ccc7CC5x4y6E, "_ZN3ccc7CC5x4y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y6C1Ev();
extern void _ZN3ccc7CC5x4y6D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y6E[] = {
  NSPAIR(_ZN3ccc7CC5x4y6C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y6E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc7CC5x4y63abcEv();
extern void _ZN3ccc7CC5x4y63efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y63efgEv,_ZTv0_n16_N3ccc7CC5x4y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y63efgEv,_ZThn4_N3ccc7CC5x4y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y63abcEv,_ZTv0_n20_N3ccc7CC5x4y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y63abcEv,_ZThn4_N3ccc7CC5x4y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y63efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y63efgEv,_ZTv0_n16_N3ccc7CC5x4y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y63abcEv,_ZTv0_n20_N3ccc7CC5x4y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y6E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y6E[] = {
  {&(_ZTVN3ccc7CC5x4y6E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y6E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y6E[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y63abcEv,_ZTv0_n20_N3ccc7CC5x4y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y63abcEv,_ZThn4_N3ccc7CC5x4y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y63efgEv,_ZTv0_n16_N3ccc7CC5x4y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y63efgEv,_ZThn4_N3ccc7CC5x4y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y6E = {  "_ZN3ccc7CC5x4y6E", // class name
  bases__ZN3ccc7CC5x4y6E, 2,
  &(vtc__ZN3ccc7CC5x4y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y6E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y6  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7DD5x4y63abcEv
  virtual void  efg(); // _ZN3ccc7DD5x4y63efgEv
  ~DD5x4y6(); // tgen
  DD5x4y6(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y6E) C1{ VBC2{ v3 v2 v1} VBC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x4y6 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y63abcEv");}
void  ccc::DD5x4y6 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y63efgEv");}
ccc::DD5x4y6 ::~DD5x4y6(){ note_dtor("_ZN3ccc7DD5x4y6E", this);} // tgen
ccc::DD5x4y6 ::DD5x4y6(){ note_ctor("_ZN3ccc7DD5x4y6E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y6E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y6E, buf);
    ::ccc::DD5x4y6 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y6E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y6E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y6E);
    dp->::ccc::DD5x4y6::~DD5x4y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y6E(Test__ZN3ccc7DD5x4y6E, "_ZN3ccc7DD5x4y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y6C1Ev();
extern void _ZN3ccc7DD5x4y6D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y6E[] = {
  NSPAIR(_ZN3ccc7DD5x4y6C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y6E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x4y63efgEv();
extern void _ZN3ccc7DD5x4y63abcEv();
extern void _ZN3ccc3BB43pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y63abcEv,_ZTv0_n16_N3ccc7DD5x4y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y63abcEv,_ZThn4_N3ccc7DD5x4y63abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y63efgEv,_ZTv0_n20_N3ccc7DD5x4y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y63efgEv,_ZThn4_N3ccc7DD5x4y63efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y63abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y63abcEv,_ZTv0_n16_N3ccc7DD5x4y63abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y63efgEv,_ZTv0_n20_N3ccc7DD5x4y63efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y6E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y6E[] = {
  {&(_ZTVN3ccc7DD5x4y6E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y6E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y6E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y6E[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y63efgEv,_ZTv0_n20_N3ccc7DD5x4y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y63efgEv,_ZThn4_N3ccc7DD5x4y63efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y63abcEv,_ZTv0_n16_N3ccc7DD5x4y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y63abcEv,_ZThn4_N3ccc7DD5x4y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y6E = {  "_ZN3ccc7DD5x4y6E", // class name
  bases__ZN3ccc7DD5x4y6E, 2,
  &(vtc__ZN3ccc7DD5x4y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y6E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y7  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC5x4y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x4y73pqrEv
  ~CC5x4y7(); // tgen
  CC5x4y7(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y7E) C1{ VBC2{ v2 v3 v1} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x4y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y73abcEv");}
void  ccc::CC5x4y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y73pqrEv");}
ccc::CC5x4y7 ::~CC5x4y7(){ note_dtor("_ZN3ccc7CC5x4y7E", this);} // tgen
ccc::CC5x4y7 ::CC5x4y7(){ note_ctor("_ZN3ccc7CC5x4y7E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y7E, buf);
    ::ccc::CC5x4y7 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y7E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y7E);
    dp->::ccc::CC5x4y7::~CC5x4y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y7E(Test__ZN3ccc7CC5x4y7E, "_ZN3ccc7CC5x4y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y7C1Ev();
extern void _ZN3ccc7CC5x4y7D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y7E[] = {
  NSPAIR(_ZN3ccc7CC5x4y7C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y7E[];
extern void _ZN3ccc7CC5x4y73pqrEv();
extern void _ZN3ccc7CC5x4y73abcEv();
extern void _ZN3ccc3BB43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y73pqrEv,_ZTv0_n12_N3ccc7CC5x4y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y73pqrEv,_ZThn4_N3ccc7CC5x4y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y73abcEv,_ZTv0_n20_N3ccc7CC5x4y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y73abcEv,_ZThn4_N3ccc7CC5x4y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y73pqrEv,_ZTv0_n12_N3ccc7CC5x4y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y73abcEv,_ZTv0_n20_N3ccc7CC5x4y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y7E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y7E[] = {
  {&(_ZTVN3ccc7CC5x4y7E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y7E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y7E[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y73abcEv,_ZTv0_n20_N3ccc7CC5x4y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y73abcEv,_ZThn4_N3ccc7CC5x4y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y73pqrEv,_ZTv0_n12_N3ccc7CC5x4y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y73pqrEv,_ZThn4_N3ccc7CC5x4y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y7E = {  "_ZN3ccc7CC5x4y7E", // class name
  bases__ZN3ccc7CC5x4y7E, 2,
  &(vtc__ZN3ccc7CC5x4y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y7E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y7  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7DD5x4y73abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x4y73pqrEv
  ~DD5x4y7(); // tgen
  DD5x4y7(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y7E) C1{ VBC2{ v2 v3 v1} VBC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x4y7 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y73abcEv");}
void  ccc::DD5x4y7 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y73pqrEv");}
ccc::DD5x4y7 ::~DD5x4y7(){ note_dtor("_ZN3ccc7DD5x4y7E", this);} // tgen
ccc::DD5x4y7 ::DD5x4y7(){ note_ctor("_ZN3ccc7DD5x4y7E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y7E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y7E, buf);
    ::ccc::DD5x4y7 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y7E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y7E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y7E);
    dp->::ccc::DD5x4y7::~DD5x4y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y7E(Test__ZN3ccc7DD5x4y7E, "_ZN3ccc7DD5x4y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y7C1Ev();
extern void _ZN3ccc7DD5x4y7D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y7E[] = {
  NSPAIR(_ZN3ccc7DD5x4y7C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y7E[];
extern void _ZN3ccc7DD5x4y73pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc7DD5x4y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y73pqrEv,_ZTv0_n12_N3ccc7DD5x4y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y73pqrEv,_ZThn4_N3ccc7DD5x4y73pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y73abcEv,_ZTv0_n16_N3ccc7DD5x4y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y73abcEv,_ZThn4_N3ccc7DD5x4y73abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y73abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y73pqrEv,_ZTv0_n12_N3ccc7DD5x4y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y73abcEv,_ZTv0_n16_N3ccc7DD5x4y73abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y7E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y7E[] = {
  {&(_ZTVN3ccc7DD5x4y7E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y7E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y7E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y7E[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y73abcEv,_ZTv0_n16_N3ccc7DD5x4y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y73abcEv,_ZThn4_N3ccc7DD5x4y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y73pqrEv,_ZTv0_n12_N3ccc7DD5x4y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y73pqrEv,_ZThn4_N3ccc7DD5x4y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y7E = {  "_ZN3ccc7DD5x4y7E", // class name
  bases__ZN3ccc7DD5x4y7E, 2,
  &(vtc__ZN3ccc7DD5x4y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y7E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y8  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC5x4y83efgEv
  virtual void  abc(); // _ZN3ccc7CC5x4y83abcEv
  ~CC5x4y8(); // tgen
  CC5x4y8(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y8E) C1{ VBC2{ v3 v1 v2} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x4y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y83efgEv");}
void  ccc::CC5x4y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x4y83abcEv");}
ccc::CC5x4y8 ::~CC5x4y8(){ note_dtor("_ZN3ccc7CC5x4y8E", this);} // tgen
ccc::CC5x4y8 ::CC5x4y8(){ note_ctor("_ZN3ccc7CC5x4y8E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y8E, buf);
    ::ccc::CC5x4y8 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y8E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y8E);
    dp->::ccc::CC5x4y8::~CC5x4y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y8E(Test__ZN3ccc7CC5x4y8E, "_ZN3ccc7CC5x4y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y8C1Ev();
extern void _ZN3ccc7CC5x4y8D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y8E[] = {
  NSPAIR(_ZN3ccc7CC5x4y8C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y8E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc7CC5x4y83abcEv();
extern void _ZN3ccc7CC5x4y83efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y83efgEv,_ZTv0_n16_N3ccc7CC5x4y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y83efgEv,_ZThn4_N3ccc7CC5x4y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x4y83abcEv,_ZTv0_n20_N3ccc7CC5x4y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y83abcEv,_ZThn4_N3ccc7CC5x4y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y83efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y83efgEv,_ZTv0_n16_N3ccc7CC5x4y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x4y83abcEv,_ZTv0_n20_N3ccc7CC5x4y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y8E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y8E[] = {
  {&(_ZTVN3ccc7CC5x4y8E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y8E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y8E[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x4y83abcEv,_ZTv0_n20_N3ccc7CC5x4y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y83abcEv,_ZThn4_N3ccc7CC5x4y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y83efgEv,_ZTv0_n16_N3ccc7CC5x4y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y83efgEv,_ZThn4_N3ccc7CC5x4y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y8E = {  "_ZN3ccc7CC5x4y8E", // class name
  bases__ZN3ccc7CC5x4y8E, 2,
  &(vtc__ZN3ccc7CC5x4y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y8E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y8  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7DD5x4y83efgEv
  virtual void  abc(); // _ZN3ccc7DD5x4y83abcEv
  ~DD5x4y8(); // tgen
  DD5x4y8(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y8E) C1{ VBC2{ v3 v1 v2} VBC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x4y8 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y83efgEv");}
void  ccc::DD5x4y8 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x4y83abcEv");}
ccc::DD5x4y8 ::~DD5x4y8(){ note_dtor("_ZN3ccc7DD5x4y8E", this);} // tgen
ccc::DD5x4y8 ::DD5x4y8(){ note_ctor("_ZN3ccc7DD5x4y8E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y8E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y8E, buf);
    ::ccc::DD5x4y8 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y8E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y8E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y8E);
    dp->::ccc::DD5x4y8::~DD5x4y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y8E(Test__ZN3ccc7DD5x4y8E, "_ZN3ccc7DD5x4y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y8C1Ev();
extern void _ZN3ccc7DD5x4y8D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y8E[] = {
  NSPAIR(_ZN3ccc7DD5x4y8C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y8E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x4y83efgEv();
extern void _ZN3ccc7DD5x4y83abcEv();
extern void _ZN3ccc3BB43pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x4y83abcEv,_ZTv0_n16_N3ccc7DD5x4y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y83abcEv,_ZThn4_N3ccc7DD5x4y83abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y83efgEv,_ZTv0_n20_N3ccc7DD5x4y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y83efgEv,_ZThn4_N3ccc7DD5x4y83efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y83abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x4y83abcEv,_ZTv0_n16_N3ccc7DD5x4y83abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y83efgEv,_ZTv0_n20_N3ccc7DD5x4y83efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y8E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y8E[] = {
  {&(_ZTVN3ccc7DD5x4y8E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y8E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y8E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y8E[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y83efgEv,_ZTv0_n20_N3ccc7DD5x4y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y83efgEv,_ZThn4_N3ccc7DD5x4y83efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x4y83abcEv,_ZTv0_n16_N3ccc7DD5x4y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y83abcEv,_ZThn4_N3ccc7DD5x4y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y8E = {  "_ZN3ccc7DD5x4y8E", // class name
  bases__ZN3ccc7DD5x4y8E, 2,
  &(vtc__ZN3ccc7DD5x4y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y8E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y9  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC5x4y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x4y93pqrEv
  ~CC5x4y9(); // tgen
  CC5x4y9(); // tgen
};
//SIG(1 _ZN3ccc7CC5x4y9E) C1{ VBC2{ v2 v1 v3} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x4y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x4y93efgEv");}
void  ccc::CC5x4y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x4y93pqrEv");}
ccc::CC5x4y9 ::~CC5x4y9(){ note_dtor("_ZN3ccc7CC5x4y9E", this);} // tgen
ccc::CC5x4y9 ::CC5x4y9(){ note_ctor("_ZN3ccc7CC5x4y9E", this);} // tgen
}
static void Test__ZN3ccc7CC5x4y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x4y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x4y9E, buf);
    ::ccc::CC5x4y9 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x4y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x4y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x4y9E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc7CC5x4y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x4y9E);
    dp->::ccc::CC5x4y9::~CC5x4y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x4y9E(Test__ZN3ccc7CC5x4y9E, "_ZN3ccc7CC5x4y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x4y9C1Ev();
extern void _ZN3ccc7CC5x4y9D1Ev();
Name_Map name_map__ZN3ccc7CC5x4y9E[] = {
  NSPAIR(_ZN3ccc7CC5x4y9C1Ev),
  NSPAIR(_ZN3ccc7CC5x4y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC5x4y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y9E[];
extern void _ZN3ccc7CC5x4y93pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc7CC5x4y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x4y93pqrEv,_ZTv0_n12_N3ccc7CC5x4y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y93pqrEv,_ZThn4_N3ccc7CC5x4y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x4y93efgEv,_ZTv0_n16_N3ccc7CC5x4y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x4y93efgEv,_ZThn4_N3ccc7CC5x4y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC5x4y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x4y93efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x4y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x4y93pqrEv,_ZTv0_n12_N3ccc7CC5x4y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x4y93efgEv,_ZTv0_n16_N3ccc7CC5x4y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x4y9E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x4y9E[] = {
  {&(_ZTVN3ccc7CC5x4y9E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x4y9E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x4y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x4y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x4y9E[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x4y93efgEv,_ZTv0_n16_N3ccc7CC5x4y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y93efgEv,_ZThn4_N3ccc7CC5x4y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x4y93pqrEv,_ZTv0_n12_N3ccc7CC5x4y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x4y93pqrEv,_ZThn4_N3ccc7CC5x4y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x4y9E = {  "_ZN3ccc7CC5x4y9E", // class name
  bases__ZN3ccc7CC5x4y9E, 2,
  &(vtc__ZN3ccc7CC5x4y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x4y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x4y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x4y9E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x4y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y9  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7DD5x4y93efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x4y93pqrEv
  ~DD5x4y9(); // tgen
  DD5x4y9(); // tgen
};
//SIG(1 _ZN3ccc7DD5x4y9E) C1{ VBC2{ v2 v1 v3} VBC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x4y9 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x4y93efgEv");}
void  ccc::DD5x4y9 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x4y93pqrEv");}
ccc::DD5x4y9 ::~DD5x4y9(){ note_dtor("_ZN3ccc7DD5x4y9E", this);} // tgen
ccc::DD5x4y9 ::DD5x4y9(){ note_ctor("_ZN3ccc7DD5x4y9E", this);} // tgen
}
static void Test__ZN3ccc7DD5x4y9E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x4y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x4y9E, buf);
    ::ccc::DD5x4y9 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x4y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x4y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x4y9E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7DD5x4y9E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x4y9E);
    dp->::ccc::DD5x4y9::~DD5x4y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x4y9E(Test__ZN3ccc7DD5x4y9E, "_ZN3ccc7DD5x4y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x4y9C1Ev();
extern void _ZN3ccc7DD5x4y9D1Ev();
Name_Map name_map__ZN3ccc7DD5x4y9E[] = {
  NSPAIR(_ZN3ccc7DD5x4y9C1Ev),
  NSPAIR(_ZN3ccc7DD5x4y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7DD5x4y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y9E[];
extern void _ZN3ccc7DD5x4y93pqrEv();
extern void _ZN3ccc7DD5x4y93efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x4y93pqrEv,_ZTv0_n12_N3ccc7DD5x4y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y93pqrEv,_ZThn4_N3ccc7DD5x4y93pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB43abcEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x4y93efgEv,_ZTv0_n20_N3ccc7DD5x4y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x4y93efgEv,_ZThn4_N3ccc7DD5x4y93efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x4y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x4y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x4y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x4y93pqrEv,_ZTv0_n12_N3ccc7DD5x4y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x4y93efgEv,_ZTv0_n20_N3ccc7DD5x4y93efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x4y9E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x4y9E[] = {
  {&(_ZTVN3ccc7DD5x4y9E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y9E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x4y9E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x4y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x4y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x4y9E[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x4y93efgEv,_ZTv0_n20_N3ccc7DD5x4y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y93efgEv,_ZThn4_N3ccc7DD5x4y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x4y93pqrEv,_ZTv0_n12_N3ccc7DD5x4y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x4y93pqrEv,_ZThn4_N3ccc7DD5x4y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x4y9E = {  "_ZN3ccc7DD5x4y9E", // class name
  bases__ZN3ccc7DD5x4y9E, 2,
  &(vtc__ZN3ccc7DD5x4y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x4y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x4y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x4y9E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x4y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y10  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8CC5x4y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC5x4y103abcEv
  ~CC5x4y10(); // tgen
  CC5x4y10(); // tgen
};
//SIG(1 _ZN3ccc8CC5x4y10E) C1{ VBC2{ v1 v3 v2} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x4y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x4y103pqrEv");}
void  ccc::CC5x4y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x4y103abcEv");}
ccc::CC5x4y10 ::~CC5x4y10(){ note_dtor("_ZN3ccc8CC5x4y10E", this);} // tgen
ccc::CC5x4y10 ::CC5x4y10(){ note_ctor("_ZN3ccc8CC5x4y10E", this);} // tgen
}
static void Test__ZN3ccc8CC5x4y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x4y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x4y10E, buf);
    ::ccc::CC5x4y10 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x4y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x4y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x4y10E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc8CC5x4y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x4y10E);
    dp->::ccc::CC5x4y10::~CC5x4y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x4y10E(Test__ZN3ccc8CC5x4y10E, "_ZN3ccc8CC5x4y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x4y10C1Ev();
extern void _ZN3ccc8CC5x4y10D1Ev();
Name_Map name_map__ZN3ccc8CC5x4y10E[] = {
  NSPAIR(_ZN3ccc8CC5x4y10C1Ev),
  NSPAIR(_ZN3ccc8CC5x4y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC5x4y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y10E[];
extern void _ZN3ccc8CC5x4y103pqrEv();
extern void _ZN3ccc8CC5x4y103abcEv();
extern void _ZN3ccc3BB43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x4y103pqrEv,_ZTv0_n12_N3ccc8CC5x4y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x4y103pqrEv,_ZThn4_N3ccc8CC5x4y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x4y103abcEv,_ZTv0_n20_N3ccc8CC5x4y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x4y103abcEv,_ZThn4_N3ccc8CC5x4y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x4y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x4y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x4y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x4y103pqrEv,_ZTv0_n12_N3ccc8CC5x4y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x4y103abcEv,_ZTv0_n20_N3ccc8CC5x4y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x4y10E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x4y10E[] = {
  {&(_ZTVN3ccc8CC5x4y10E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x4y10E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x4y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x4y10E[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x4y103abcEv,_ZTv0_n20_N3ccc8CC5x4y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x4y103abcEv,_ZThn4_N3ccc8CC5x4y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x4y103pqrEv,_ZTv0_n12_N3ccc8CC5x4y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x4y103pqrEv,_ZThn4_N3ccc8CC5x4y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x4y10E = {  "_ZN3ccc8CC5x4y10E", // class name
  bases__ZN3ccc8CC5x4y10E, 2,
  &(vtc__ZN3ccc8CC5x4y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x4y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x4y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x4y10E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x4y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y10  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8DD5x4y103pqrEv
  virtual void  abc(); // _ZN3ccc8DD5x4y103abcEv
  ~DD5x4y10(); // tgen
  DD5x4y10(); // tgen
};
//SIG(1 _ZN3ccc8DD5x4y10E) C1{ VBC2{ v1 v3 v2} VBC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x4y10 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x4y103pqrEv");}
void  ccc::DD5x4y10 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x4y103abcEv");}
ccc::DD5x4y10 ::~DD5x4y10(){ note_dtor("_ZN3ccc8DD5x4y10E", this);} // tgen
ccc::DD5x4y10 ::DD5x4y10(){ note_ctor("_ZN3ccc8DD5x4y10E", this);} // tgen
}
static void Test__ZN3ccc8DD5x4y10E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x4y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x4y10E, buf);
    ::ccc::DD5x4y10 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x4y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x4y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x4y10E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8DD5x4y10E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x4y10E);
    dp->::ccc::DD5x4y10::~DD5x4y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x4y10E(Test__ZN3ccc8DD5x4y10E, "_ZN3ccc8DD5x4y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x4y10C1Ev();
extern void _ZN3ccc8DD5x4y10D1Ev();
Name_Map name_map__ZN3ccc8DD5x4y10E[] = {
  NSPAIR(_ZN3ccc8DD5x4y10C1Ev),
  NSPAIR(_ZN3ccc8DD5x4y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8DD5x4y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y10E[];
extern void _ZN3ccc8DD5x4y103pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x4y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x4y103pqrEv,_ZTv0_n12_N3ccc8DD5x4y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x4y103pqrEv,_ZThn4_N3ccc8DD5x4y103pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x4y103abcEv,_ZTv0_n16_N3ccc8DD5x4y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x4y103abcEv,_ZThn4_N3ccc8DD5x4y103abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x4y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x4y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x4y103abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x4y103pqrEv,_ZTv0_n12_N3ccc8DD5x4y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x4y103abcEv,_ZTv0_n16_N3ccc8DD5x4y103abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x4y10E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x4y10E[] = {
  {&(_ZTVN3ccc8DD5x4y10E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y10E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y10E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x4y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x4y10E[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x4y103abcEv,_ZTv0_n16_N3ccc8DD5x4y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x4y103abcEv,_ZThn4_N3ccc8DD5x4y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x4y103pqrEv,_ZTv0_n12_N3ccc8DD5x4y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x4y103pqrEv,_ZThn4_N3ccc8DD5x4y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x4y10E = {  "_ZN3ccc8DD5x4y10E", // class name
  bases__ZN3ccc8DD5x4y10E, 2,
  &(vtc__ZN3ccc8DD5x4y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x4y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x4y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x4y10E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x4y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y11  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8CC5x4y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC5x4y113efgEv
  ~CC5x4y11(); // tgen
  CC5x4y11(); // tgen
};
//SIG(1 _ZN3ccc8CC5x4y11E) C1{ VBC2{ v1 v2 v3} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x4y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x4y113pqrEv");}
void  ccc::CC5x4y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x4y113efgEv");}
ccc::CC5x4y11 ::~CC5x4y11(){ note_dtor("_ZN3ccc8CC5x4y11E", this);} // tgen
ccc::CC5x4y11 ::CC5x4y11(){ note_ctor("_ZN3ccc8CC5x4y11E", this);} // tgen
}
static void Test__ZN3ccc8CC5x4y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x4y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x4y11E, buf);
    ::ccc::CC5x4y11 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x4y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x4y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x4y11E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc8CC5x4y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x4y11E);
    dp->::ccc::CC5x4y11::~CC5x4y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x4y11E(Test__ZN3ccc8CC5x4y11E, "_ZN3ccc8CC5x4y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x4y11C1Ev();
extern void _ZN3ccc8CC5x4y11D1Ev();
Name_Map name_map__ZN3ccc8CC5x4y11E[] = {
  NSPAIR(_ZN3ccc8CC5x4y11C1Ev),
  NSPAIR(_ZN3ccc8CC5x4y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC5x4y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y11E[];
extern void _ZN3ccc8CC5x4y113pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc8CC5x4y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x4y113pqrEv,_ZTv0_n12_N3ccc8CC5x4y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x4y113pqrEv,_ZThn4_N3ccc8CC5x4y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x4y113efgEv,_ZTv0_n16_N3ccc8CC5x4y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x4y113efgEv,_ZThn4_N3ccc8CC5x4y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x4y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x4y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x4y113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x4y113pqrEv,_ZTv0_n12_N3ccc8CC5x4y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x4y113efgEv,_ZTv0_n16_N3ccc8CC5x4y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x4y11E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x4y11E[] = {
  {&(_ZTVN3ccc8CC5x4y11E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x4y11E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x4y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x4y11E[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x4y113efgEv,_ZTv0_n16_N3ccc8CC5x4y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x4y113efgEv,_ZThn4_N3ccc8CC5x4y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x4y113pqrEv,_ZTv0_n12_N3ccc8CC5x4y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x4y113pqrEv,_ZThn4_N3ccc8CC5x4y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x4y11E = {  "_ZN3ccc8CC5x4y11E", // class name
  bases__ZN3ccc8CC5x4y11E, 2,
  &(vtc__ZN3ccc8CC5x4y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x4y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x4y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x4y11E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x4y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y11  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8DD5x4y113pqrEv
  virtual void  efg(); // _ZN3ccc8DD5x4y113efgEv
  ~DD5x4y11(); // tgen
  DD5x4y11(); // tgen
};
//SIG(1 _ZN3ccc8DD5x4y11E) C1{ VBC2{ v1 v2 v3} VBC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x4y11 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x4y113pqrEv");}
void  ccc::DD5x4y11 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x4y113efgEv");}
ccc::DD5x4y11 ::~DD5x4y11(){ note_dtor("_ZN3ccc8DD5x4y11E", this);} // tgen
ccc::DD5x4y11 ::DD5x4y11(){ note_ctor("_ZN3ccc8DD5x4y11E", this);} // tgen
}
static void Test__ZN3ccc8DD5x4y11E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x4y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x4y11E, buf);
    ::ccc::DD5x4y11 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x4y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x4y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x4y11E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8DD5x4y11E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x4y11E);
    dp->::ccc::DD5x4y11::~DD5x4y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x4y11E(Test__ZN3ccc8DD5x4y11E, "_ZN3ccc8DD5x4y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x4y11C1Ev();
extern void _ZN3ccc8DD5x4y11D1Ev();
Name_Map name_map__ZN3ccc8DD5x4y11E[] = {
  NSPAIR(_ZN3ccc8DD5x4y11C1Ev),
  NSPAIR(_ZN3ccc8DD5x4y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8DD5x4y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y11E[];
extern void _ZN3ccc8DD5x4y113pqrEv();
extern void _ZN3ccc8DD5x4y113efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x4y113pqrEv,_ZTv0_n12_N3ccc8DD5x4y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x4y113pqrEv,_ZThn4_N3ccc8DD5x4y113pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB43abcEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8DD5x4y113efgEv,_ZTv0_n20_N3ccc8DD5x4y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x4y113efgEv,_ZThn4_N3ccc8DD5x4y113efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x4y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x4y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x4y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x4y113pqrEv,_ZTv0_n12_N3ccc8DD5x4y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8DD5x4y113efgEv,_ZTv0_n20_N3ccc8DD5x4y113efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x4y11E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x4y11E[] = {
  {&(_ZTVN3ccc8DD5x4y11E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y11E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y11E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x4y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x4y11E[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8DD5x4y113efgEv,_ZTv0_n20_N3ccc8DD5x4y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x4y113efgEv,_ZThn4_N3ccc8DD5x4y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x4y113pqrEv,_ZTv0_n12_N3ccc8DD5x4y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x4y113pqrEv,_ZThn4_N3ccc8DD5x4y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x4y11E = {  "_ZN3ccc8DD5x4y11E", // class name
  bases__ZN3ccc8DD5x4y11E, 2,
  &(vtc__ZN3ccc8DD5x4y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x4y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x4y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x4y11E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x4y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y12  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc8CC5x4y123abcEv
  ~CC5x4y12(); // tgen
  CC5x4y12(); // tgen
};
//SIG(1 _ZN3ccc8CC5x4y12E) C1{ VBC2{ v2 v3 v1} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC5x4y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x4y123abcEv");}
ccc::CC5x4y12 ::~CC5x4y12(){ note_dtor("_ZN3ccc8CC5x4y12E", this);} // tgen
ccc::CC5x4y12 ::CC5x4y12(){ note_ctor("_ZN3ccc8CC5x4y12E", this);} // tgen
}
static void Test__ZN3ccc8CC5x4y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x4y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x4y12E, buf);
    ::ccc::CC5x4y12 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x4y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x4y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x4y12E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc8CC5x4y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x4y12E);
    dp->::ccc::CC5x4y12::~CC5x4y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x4y12E(Test__ZN3ccc8CC5x4y12E, "_ZN3ccc8CC5x4y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x4y12C1Ev();
extern void _ZN3ccc8CC5x4y12D1Ev();
Name_Map name_map__ZN3ccc8CC5x4y12E[] = {
  NSPAIR(_ZN3ccc8CC5x4y12C1Ev),
  NSPAIR(_ZN3ccc8CC5x4y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC5x4y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y12E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc8CC5x4y123abcEv();
extern void _ZN3ccc3BB43efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x4y123abcEv,_ZTv0_n20_N3ccc8CC5x4y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x4y123abcEv,_ZThn4_N3ccc8CC5x4y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x4y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x4y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x4y123abcEv,_ZTv0_n20_N3ccc8CC5x4y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x4y12E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x4y12E[] = {
  {&(_ZTVN3ccc8CC5x4y12E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x4y12E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x4y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x4y12E[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x4y123abcEv,_ZTv0_n20_N3ccc8CC5x4y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x4y123abcEv,_ZThn4_N3ccc8CC5x4y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x4y12E = {  "_ZN3ccc8CC5x4y12E", // class name
  bases__ZN3ccc8CC5x4y12E, 2,
  &(vtc__ZN3ccc8CC5x4y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x4y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x4y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x4y12E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x4y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y12  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc8DD5x4y123abcEv
  ~DD5x4y12(); // tgen
  DD5x4y12(); // tgen
};
//SIG(1 _ZN3ccc8DD5x4y12E) C1{ VBC2{ v2 v3 v1} VBC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::DD5x4y12 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x4y123abcEv");}
ccc::DD5x4y12 ::~DD5x4y12(){ note_dtor("_ZN3ccc8DD5x4y12E", this);} // tgen
ccc::DD5x4y12 ::DD5x4y12(){ note_ctor("_ZN3ccc8DD5x4y12E", this);} // tgen
}
static void Test__ZN3ccc8DD5x4y12E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x4y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x4y12E, buf);
    ::ccc::DD5x4y12 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x4y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x4y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x4y12E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8DD5x4y12E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x4y12E);
    dp->::ccc::DD5x4y12::~DD5x4y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x4y12E(Test__ZN3ccc8DD5x4y12E, "_ZN3ccc8DD5x4y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x4y12C1Ev();
extern void _ZN3ccc8DD5x4y12D1Ev();
Name_Map name_map__ZN3ccc8DD5x4y12E[] = {
  NSPAIR(_ZN3ccc8DD5x4y12C1Ev),
  NSPAIR(_ZN3ccc8DD5x4y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8DD5x4y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y12E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x4y123abcEv();
extern void _ZN3ccc3BB43pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x4y123abcEv,_ZTv0_n16_N3ccc8DD5x4y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x4y123abcEv,_ZThn4_N3ccc8DD5x4y123abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x4y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x4y123abcEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x4y123abcEv,_ZTv0_n16_N3ccc8DD5x4y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x4y12E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x4y12E[] = {
  {&(_ZTVN3ccc8DD5x4y12E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y12E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y12E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x4y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x4y12E[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x4y123abcEv,_ZTv0_n16_N3ccc8DD5x4y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x4y123abcEv,_ZThn4_N3ccc8DD5x4y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x4y12E = {  "_ZN3ccc8DD5x4y12E", // class name
  bases__ZN3ccc8DD5x4y12E, 2,
  &(vtc__ZN3ccc8DD5x4y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x4y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x4y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x4y12E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x4y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y13  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc8CC5x4y133efgEv
  ~CC5x4y13(); // tgen
  CC5x4y13(); // tgen
};
//SIG(1 _ZN3ccc8CC5x4y13E) C1{ VBC2{ v2 v1 v3} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC5x4y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x4y133efgEv");}
ccc::CC5x4y13 ::~CC5x4y13(){ note_dtor("_ZN3ccc8CC5x4y13E", this);} // tgen
ccc::CC5x4y13 ::CC5x4y13(){ note_ctor("_ZN3ccc8CC5x4y13E", this);} // tgen
}
static void Test__ZN3ccc8CC5x4y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x4y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x4y13E, buf);
    ::ccc::CC5x4y13 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x4y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x4y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x4y13E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc8CC5x4y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x4y13E);
    dp->::ccc::CC5x4y13::~CC5x4y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x4y13E(Test__ZN3ccc8CC5x4y13E, "_ZN3ccc8CC5x4y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x4y13C1Ev();
extern void _ZN3ccc8CC5x4y13D1Ev();
Name_Map name_map__ZN3ccc8CC5x4y13E[] = {
  NSPAIR(_ZN3ccc8CC5x4y13C1Ev),
  NSPAIR(_ZN3ccc8CC5x4y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC5x4y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y13E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc8CC5x4y133efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x4y133efgEv,_ZTv0_n16_N3ccc8CC5x4y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x4y133efgEv,_ZThn4_N3ccc8CC5x4y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x4y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x4y133efgEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x4y133efgEv,_ZTv0_n16_N3ccc8CC5x4y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x4y13E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x4y13E[] = {
  {&(_ZTVN3ccc8CC5x4y13E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x4y13E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x4y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x4y13E[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x4y133efgEv,_ZTv0_n16_N3ccc8CC5x4y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x4y133efgEv,_ZThn4_N3ccc8CC5x4y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x4y13E = {  "_ZN3ccc8CC5x4y13E", // class name
  bases__ZN3ccc8CC5x4y13E, 2,
  &(vtc__ZN3ccc8CC5x4y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x4y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x4y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x4y13E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x4y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y13  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc8DD5x4y133efgEv
  ~DD5x4y13(); // tgen
  DD5x4y13(); // tgen
};
//SIG(1 _ZN3ccc8DD5x4y13E) C1{ VBC2{ v2 v1 v3} VBC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::DD5x4y13 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x4y133efgEv");}
ccc::DD5x4y13 ::~DD5x4y13(){ note_dtor("_ZN3ccc8DD5x4y13E", this);} // tgen
ccc::DD5x4y13 ::DD5x4y13(){ note_ctor("_ZN3ccc8DD5x4y13E", this);} // tgen
}
static void Test__ZN3ccc8DD5x4y13E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x4y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x4y13E, buf);
    ::ccc::DD5x4y13 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x4y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x4y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x4y13E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8DD5x4y13E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x4y13E);
    dp->::ccc::DD5x4y13::~DD5x4y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x4y13E(Test__ZN3ccc8DD5x4y13E, "_ZN3ccc8DD5x4y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x4y13C1Ev();
extern void _ZN3ccc8DD5x4y13D1Ev();
Name_Map name_map__ZN3ccc8DD5x4y13E[] = {
  NSPAIR(_ZN3ccc8DD5x4y13C1Ev),
  NSPAIR(_ZN3ccc8DD5x4y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8DD5x4y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y13E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc8DD5x4y133efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8DD5x4y133efgEv,_ZTv0_n20_N3ccc8DD5x4y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x4y133efgEv,_ZThn4_N3ccc8DD5x4y133efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x4y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x4y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8DD5x4y133efgEv,_ZTv0_n20_N3ccc8DD5x4y133efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x4y13E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x4y13E[] = {
  {&(_ZTVN3ccc8DD5x4y13E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y13E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y13E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x4y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x4y13E[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8DD5x4y133efgEv,_ZTv0_n20_N3ccc8DD5x4y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x4y133efgEv,_ZThn4_N3ccc8DD5x4y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x4y13E = {  "_ZN3ccc8DD5x4y13E", // class name
  bases__ZN3ccc8DD5x4y13E, 2,
  &(vtc__ZN3ccc8DD5x4y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x4y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x4y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x4y13E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x4y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y14  : virtual ::ccc::AA5 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8CC5x4y143pqrEv
  ~CC5x4y14(); // tgen
  CC5x4y14(); // tgen
};
//SIG(1 _ZN3ccc8CC5x4y14E) C1{ VBC2{ v1 v2 v3} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC5x4y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x4y143pqrEv");}
ccc::CC5x4y14 ::~CC5x4y14(){ note_dtor("_ZN3ccc8CC5x4y14E", this);} // tgen
ccc::CC5x4y14 ::CC5x4y14(){ note_ctor("_ZN3ccc8CC5x4y14E", this);} // tgen
}
static void Test__ZN3ccc8CC5x4y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x4y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x4y14E, buf);
    ::ccc::CC5x4y14 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x4y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x4y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x4y14E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc8CC5x4y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x4y14E);
    dp->::ccc::CC5x4y14::~CC5x4y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x4y14E(Test__ZN3ccc8CC5x4y14E, "_ZN3ccc8CC5x4y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x4y14C1Ev();
extern void _ZN3ccc8CC5x4y14D1Ev();
Name_Map name_map__ZN3ccc8CC5x4y14E[] = {
  NSPAIR(_ZN3ccc8CC5x4y14C1Ev),
  NSPAIR(_ZN3ccc8CC5x4y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC5x4y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y14E[];
extern void _ZN3ccc8CC5x4y143pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x4y143pqrEv,_ZTv0_n12_N3ccc8CC5x4y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x4y143pqrEv,_ZThn4_N3ccc8CC5x4y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x4y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x4y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x4y143pqrEv,_ZTv0_n12_N3ccc8CC5x4y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x4y14E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x4y14E[] = {
  {&(_ZTVN3ccc8CC5x4y14E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x4y14E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x4y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x4y14E[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x4y143pqrEv,_ZTv0_n12_N3ccc8CC5x4y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x4y143pqrEv,_ZThn4_N3ccc8CC5x4y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x4y14E = {  "_ZN3ccc8CC5x4y14E", // class name
  bases__ZN3ccc8CC5x4y14E, 2,
  &(vtc__ZN3ccc8CC5x4y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x4y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x4y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x4y14E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x4y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y14  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8DD5x4y143pqrEv
  ~DD5x4y14(); // tgen
  DD5x4y14(); // tgen
};
//SIG(1 _ZN3ccc8DD5x4y14E) C1{ VBC2{ v1 v2 v3} VBC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::DD5x4y14 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x4y143pqrEv");}
ccc::DD5x4y14 ::~DD5x4y14(){ note_dtor("_ZN3ccc8DD5x4y14E", this);} // tgen
ccc::DD5x4y14 ::DD5x4y14(){ note_ctor("_ZN3ccc8DD5x4y14E", this);} // tgen
}
static void Test__ZN3ccc8DD5x4y14E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x4y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x4y14E, buf);
    ::ccc::DD5x4y14 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x4y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x4y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x4y14E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8DD5x4y14E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x4y14E);
    dp->::ccc::DD5x4y14::~DD5x4y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x4y14E(Test__ZN3ccc8DD5x4y14E, "_ZN3ccc8DD5x4y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x4y14C1Ev();
extern void _ZN3ccc8DD5x4y14D1Ev();
Name_Map name_map__ZN3ccc8DD5x4y14E[] = {
  NSPAIR(_ZN3ccc8DD5x4y14C1Ev),
  NSPAIR(_ZN3ccc8DD5x4y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8DD5x4y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y14E[];
extern void _ZN3ccc8DD5x4y143pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x4y143pqrEv,_ZTv0_n12_N3ccc8DD5x4y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x4y143pqrEv,_ZThn4_N3ccc8DD5x4y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x4y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x4y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x4y143pqrEv,_ZTv0_n12_N3ccc8DD5x4y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x4y14E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x4y14E[] = {
  {&(_ZTVN3ccc8DD5x4y14E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y14E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y14E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x4y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x4y14E[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x4y143pqrEv,_ZTv0_n12_N3ccc8DD5x4y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x4y143pqrEv,_ZThn4_N3ccc8DD5x4y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x4y14E = {  "_ZN3ccc8DD5x4y14E", // class name
  bases__ZN3ccc8DD5x4y14E, 2,
  &(vtc__ZN3ccc8DD5x4y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x4y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x4y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x4y14E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x4y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x4y15  : virtual ::ccc::AA5 , ::ccc::BB4 {
  ~CC5x4y15(); // tgen
  CC5x4y15(); // tgen
};
//SIG(1 _ZN3ccc8CC5x4y15E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC5x4y15 ::~CC5x4y15(){ note_dtor("_ZN3ccc8CC5x4y15E", this);} // tgen
ccc::CC5x4y15 ::CC5x4y15(){ note_ctor("_ZN3ccc8CC5x4y15E", this);} // tgen
}
static void Test__ZN3ccc8CC5x4y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x4y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x4y15E, buf);
    ::ccc::CC5x4y15 *dp, &lv = *(dp=new (buf) ::ccc::CC5x4y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x4y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x4y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x4y15E");
    check_base_class_offset(lv, (::ccc::BB4*), 0, "_ZN3ccc8CC5x4y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x4y15E);
    dp->::ccc::CC5x4y15::~CC5x4y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x4y15E(Test__ZN3ccc8CC5x4y15E, "_ZN3ccc8CC5x4y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x4y15C1Ev();
extern void _ZN3ccc8CC5x4y15D1Ev();
Name_Map name_map__ZN3ccc8CC5x4y15E[] = {
  NSPAIR(_ZN3ccc8CC5x4y15C1Ev),
  NSPAIR(_ZN3ccc8CC5x4y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC5x4y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y15E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x4y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x4y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x4y15E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x4y15E[] = {
  {&(_ZTVN3ccc8CC5x4y15E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x4y15E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x4y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x4y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x4y15E[];
Class_Descriptor cd__ZN3ccc8CC5x4y15E = {  "_ZN3ccc8CC5x4y15E", // class name
  bases__ZN3ccc8CC5x4y15E, 2,
  &(vtc__ZN3ccc8CC5x4y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x4y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x4y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x4y15E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x4y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x4y15  : virtual ::ccc::AA5 , virtual ::ccc::BB4 {
  ~DD5x4y15(); // tgen
  DD5x4y15(); // tgen
};
//SIG(1 _ZN3ccc8DD5x4y15E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::DD5x4y15 ::~DD5x4y15(){ note_dtor("_ZN3ccc8DD5x4y15E", this);} // tgen
ccc::DD5x4y15 ::DD5x4y15(){ note_ctor("_ZN3ccc8DD5x4y15E", this);} // tgen
}
static void Test__ZN3ccc8DD5x4y15E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x4y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x4y15E, buf);
    ::ccc::DD5x4y15 *dp, &lv = *(dp=new (buf) ::ccc::DD5x4y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x4y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x4y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x4y15E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8DD5x4y15E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x4y15E);
    dp->::ccc::DD5x4y15::~DD5x4y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x4y15E(Test__ZN3ccc8DD5x4y15E, "_ZN3ccc8DD5x4y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x4y15C1Ev();
extern void _ZN3ccc8DD5x4y15D1Ev();
Name_Map name_map__ZN3ccc8DD5x4y15E[] = {
  NSPAIR(_ZN3ccc8DD5x4y15C1Ev),
  NSPAIR(_ZN3ccc8DD5x4y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8DD5x4y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y15E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x4y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x4y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x4y15E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x4y15E[] = {
  {&(_ZTVN3ccc8DD5x4y15E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y15E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x4y15E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x4y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x4y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x4y15E[];
Class_Descriptor cd__ZN3ccc8DD5x4y15E = {  "_ZN3ccc8DD5x4y15E", // class name
  bases__ZN3ccc8DD5x4y15E, 2,
  &(vtc__ZN3ccc8DD5x4y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x4y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x4y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x4y15E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x4y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y0  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC5x5y03abcEv
  virtual void  efg(); // _ZN3ccc7CC5x5y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x5y03pqrEv
  ~CC5x5y0(); // tgen
  CC5x5y0(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y0E) C1{ VBC2{ v3 v2 v1} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x5y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y03abcEv");}
void  ccc::CC5x5y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y03efgEv");}
void  ccc::CC5x5y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y03pqrEv");}
ccc::CC5x5y0 ::~CC5x5y0(){ note_dtor("_ZN3ccc7CC5x5y0E", this);} // tgen
ccc::CC5x5y0 ::CC5x5y0(){ note_ctor("_ZN3ccc7CC5x5y0E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y0E, buf);
    ::ccc::CC5x5y0 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y0E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y0E);
    dp->::ccc::CC5x5y0::~CC5x5y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y0E(Test__ZN3ccc7CC5x5y0E, "_ZN3ccc7CC5x5y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y0C1Ev();
extern void _ZN3ccc7CC5x5y0D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y0E[] = {
  NSPAIR(_ZN3ccc7CC5x5y0C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y0E[];
extern void _ZN3ccc7CC5x5y03pqrEv();
extern void _ZN3ccc7CC5x5y03efgEv();
extern void _ZN3ccc7CC5x5y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y03pqrEv,_ZTv0_n12_N3ccc7CC5x5y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y03pqrEv,_ZThn4_N3ccc7CC5x5y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y03efgEv,_ZTv0_n16_N3ccc7CC5x5y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y03efgEv,_ZThn4_N3ccc7CC5x5y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y03abcEv,_ZTv0_n20_N3ccc7CC5x5y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y03abcEv,_ZThn4_N3ccc7CC5x5y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y03pqrEv,_ZTv0_n12_N3ccc7CC5x5y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y03efgEv,_ZTv0_n16_N3ccc7CC5x5y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y03abcEv,_ZTv0_n20_N3ccc7CC5x5y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y0E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y0E[] = {
  {&(_ZTVN3ccc7CC5x5y0E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y0E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y0E[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y03abcEv,_ZTv0_n20_N3ccc7CC5x5y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y03abcEv,_ZThn4_N3ccc7CC5x5y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y03efgEv,_ZTv0_n16_N3ccc7CC5x5y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y03efgEv,_ZThn4_N3ccc7CC5x5y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y03pqrEv,_ZTv0_n12_N3ccc7CC5x5y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y03pqrEv,_ZThn4_N3ccc7CC5x5y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y0E = {  "_ZN3ccc7CC5x5y0E", // class name
  bases__ZN3ccc7CC5x5y0E, 2,
  &(vtc__ZN3ccc7CC5x5y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y0E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y0  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7DD5x5y03abcEv
  virtual void  efg(); // _ZN3ccc7DD5x5y03efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x5y03pqrEv
  ~DD5x5y0(); // tgen
  DD5x5y0(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y0E) C1{ VBC2{ v3 v2 v1} VBC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x5y0 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y03abcEv");}
void  ccc::DD5x5y0 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y03efgEv");}
void  ccc::DD5x5y0 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y03pqrEv");}
ccc::DD5x5y0 ::~DD5x5y0(){ note_dtor("_ZN3ccc7DD5x5y0E", this);} // tgen
ccc::DD5x5y0 ::DD5x5y0(){ note_ctor("_ZN3ccc7DD5x5y0E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y0E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y0E, buf);
    ::ccc::DD5x5y0 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y0E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y0E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y0E);
    dp->::ccc::DD5x5y0::~DD5x5y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y0E(Test__ZN3ccc7DD5x5y0E, "_ZN3ccc7DD5x5y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y0C1Ev();
extern void _ZN3ccc7DD5x5y0D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y0E[] = {
  NSPAIR(_ZN3ccc7DD5x5y0C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y0E[];
extern void _ZN3ccc7DD5x5y03pqrEv();
extern void _ZN3ccc7DD5x5y03efgEv();
extern void _ZN3ccc7DD5x5y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y03pqrEv,_ZTv0_n12_N3ccc7DD5x5y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y03pqrEv,_ZThn4_N3ccc7DD5x5y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y03efgEv,_ZTv0_n16_N3ccc7DD5x5y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y03efgEv,_ZThn4_N3ccc7DD5x5y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y03abcEv,_ZTv0_n20_N3ccc7DD5x5y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y03abcEv,_ZThn4_N3ccc7DD5x5y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y03pqrEv,_ZTv0_n12_N3ccc7DD5x5y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y03efgEv,_ZTv0_n16_N3ccc7DD5x5y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y03abcEv,_ZTv0_n20_N3ccc7DD5x5y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y0E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y0E[] = {
  {&(_ZTVN3ccc7DD5x5y0E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y0E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y0E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y0E[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y03abcEv,_ZTv0_n20_N3ccc7DD5x5y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y03abcEv,_ZThn4_N3ccc7DD5x5y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y03efgEv,_ZTv0_n16_N3ccc7DD5x5y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y03efgEv,_ZThn4_N3ccc7DD5x5y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y03pqrEv,_ZTv0_n12_N3ccc7DD5x5y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y03pqrEv,_ZThn4_N3ccc7DD5x5y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y0E = {  "_ZN3ccc7DD5x5y0E", // class name
  bases__ZN3ccc7DD5x5y0E, 2,
  &(vtc__ZN3ccc7DD5x5y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y0E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y1  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC5x5y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x5y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x5y13efgEv
  ~CC5x5y1(); // tgen
  CC5x5y1(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y1E) C1{ VBC2{ v2 v3 v1} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x5y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y13abcEv");}
void  ccc::CC5x5y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y13pqrEv");}
void  ccc::CC5x5y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y13efgEv");}
ccc::CC5x5y1 ::~CC5x5y1(){ note_dtor("_ZN3ccc7CC5x5y1E", this);} // tgen
ccc::CC5x5y1 ::CC5x5y1(){ note_ctor("_ZN3ccc7CC5x5y1E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y1E, buf);
    ::ccc::CC5x5y1 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y1E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y1E);
    dp->::ccc::CC5x5y1::~CC5x5y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y1E(Test__ZN3ccc7CC5x5y1E, "_ZN3ccc7CC5x5y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y1C1Ev();
extern void _ZN3ccc7CC5x5y1D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y1E[] = {
  NSPAIR(_ZN3ccc7CC5x5y1C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y1E[];
extern void _ZN3ccc7CC5x5y13pqrEv();
extern void _ZN3ccc7CC5x5y13efgEv();
extern void _ZN3ccc7CC5x5y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y13pqrEv,_ZTv0_n12_N3ccc7CC5x5y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y13pqrEv,_ZThn4_N3ccc7CC5x5y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y13efgEv,_ZTv0_n16_N3ccc7CC5x5y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y13efgEv,_ZThn4_N3ccc7CC5x5y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y13abcEv,_ZTv0_n20_N3ccc7CC5x5y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y13abcEv,_ZThn4_N3ccc7CC5x5y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y13pqrEv,_ZTv0_n12_N3ccc7CC5x5y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y13efgEv,_ZTv0_n16_N3ccc7CC5x5y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y13abcEv,_ZTv0_n20_N3ccc7CC5x5y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y1E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y1E[] = {
  {&(_ZTVN3ccc7CC5x5y1E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y1E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y1E[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y13abcEv,_ZTv0_n20_N3ccc7CC5x5y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y13abcEv,_ZThn4_N3ccc7CC5x5y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y13efgEv,_ZTv0_n16_N3ccc7CC5x5y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y13efgEv,_ZThn4_N3ccc7CC5x5y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y13pqrEv,_ZTv0_n12_N3ccc7CC5x5y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y13pqrEv,_ZThn4_N3ccc7CC5x5y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y1E = {  "_ZN3ccc7CC5x5y1E", // class name
  bases__ZN3ccc7CC5x5y1E, 2,
  &(vtc__ZN3ccc7CC5x5y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y1E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y1  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7DD5x5y13abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x5y13pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x5y13efgEv
  ~DD5x5y1(); // tgen
  DD5x5y1(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y1E) C1{ VBC2{ v2 v3 v1} VBC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x5y1 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y13abcEv");}
void  ccc::DD5x5y1 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y13pqrEv");}
void  ccc::DD5x5y1 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y13efgEv");}
ccc::DD5x5y1 ::~DD5x5y1(){ note_dtor("_ZN3ccc7DD5x5y1E", this);} // tgen
ccc::DD5x5y1 ::DD5x5y1(){ note_ctor("_ZN3ccc7DD5x5y1E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y1E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y1E, buf);
    ::ccc::DD5x5y1 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y1E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y1E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y1E);
    dp->::ccc::DD5x5y1::~DD5x5y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y1E(Test__ZN3ccc7DD5x5y1E, "_ZN3ccc7DD5x5y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y1C1Ev();
extern void _ZN3ccc7DD5x5y1D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y1E[] = {
  NSPAIR(_ZN3ccc7DD5x5y1C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y1E[];
extern void _ZN3ccc7DD5x5y13pqrEv();
extern void _ZN3ccc7DD5x5y13efgEv();
extern void _ZN3ccc7DD5x5y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y13pqrEv,_ZTv0_n12_N3ccc7DD5x5y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y13pqrEv,_ZThn4_N3ccc7DD5x5y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y13efgEv,_ZTv0_n16_N3ccc7DD5x5y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y13efgEv,_ZThn4_N3ccc7DD5x5y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y13abcEv,_ZTv0_n20_N3ccc7DD5x5y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y13abcEv,_ZThn4_N3ccc7DD5x5y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y13pqrEv,_ZTv0_n12_N3ccc7DD5x5y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y13efgEv,_ZTv0_n16_N3ccc7DD5x5y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y13abcEv,_ZTv0_n20_N3ccc7DD5x5y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y1E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y1E[] = {
  {&(_ZTVN3ccc7DD5x5y1E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y1E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y1E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y1E[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y13abcEv,_ZTv0_n20_N3ccc7DD5x5y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y13abcEv,_ZThn4_N3ccc7DD5x5y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y13efgEv,_ZTv0_n16_N3ccc7DD5x5y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y13efgEv,_ZThn4_N3ccc7DD5x5y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y13pqrEv,_ZTv0_n12_N3ccc7DD5x5y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y13pqrEv,_ZThn4_N3ccc7DD5x5y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y1E = {  "_ZN3ccc7DD5x5y1E", // class name
  bases__ZN3ccc7DD5x5y1E, 2,
  &(vtc__ZN3ccc7DD5x5y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y1E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y2  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC5x5y23efgEv
  virtual void  abc(); // _ZN3ccc7CC5x5y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x5y23pqrEv
  ~CC5x5y2(); // tgen
  CC5x5y2(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y2E) C1{ VBC2{ v3 v1 v2} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x5y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y23efgEv");}
void  ccc::CC5x5y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y23abcEv");}
void  ccc::CC5x5y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y23pqrEv");}
ccc::CC5x5y2 ::~CC5x5y2(){ note_dtor("_ZN3ccc7CC5x5y2E", this);} // tgen
ccc::CC5x5y2 ::CC5x5y2(){ note_ctor("_ZN3ccc7CC5x5y2E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y2E, buf);
    ::ccc::CC5x5y2 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y2E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y2E);
    dp->::ccc::CC5x5y2::~CC5x5y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y2E(Test__ZN3ccc7CC5x5y2E, "_ZN3ccc7CC5x5y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y2C1Ev();
extern void _ZN3ccc7CC5x5y2D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y2E[] = {
  NSPAIR(_ZN3ccc7CC5x5y2C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y2E[];
extern void _ZN3ccc7CC5x5y23pqrEv();
extern void _ZN3ccc7CC5x5y23efgEv();
extern void _ZN3ccc7CC5x5y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y23pqrEv,_ZTv0_n12_N3ccc7CC5x5y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y23pqrEv,_ZThn4_N3ccc7CC5x5y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y23efgEv,_ZTv0_n16_N3ccc7CC5x5y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y23efgEv,_ZThn4_N3ccc7CC5x5y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y23abcEv,_ZTv0_n20_N3ccc7CC5x5y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y23abcEv,_ZThn4_N3ccc7CC5x5y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y23pqrEv,_ZTv0_n12_N3ccc7CC5x5y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y23efgEv,_ZTv0_n16_N3ccc7CC5x5y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y23abcEv,_ZTv0_n20_N3ccc7CC5x5y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y2E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y2E[] = {
  {&(_ZTVN3ccc7CC5x5y2E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y2E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y2E[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y23abcEv,_ZTv0_n20_N3ccc7CC5x5y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y23abcEv,_ZThn4_N3ccc7CC5x5y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y23efgEv,_ZTv0_n16_N3ccc7CC5x5y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y23efgEv,_ZThn4_N3ccc7CC5x5y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y23pqrEv,_ZTv0_n12_N3ccc7CC5x5y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y23pqrEv,_ZThn4_N3ccc7CC5x5y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y2E = {  "_ZN3ccc7CC5x5y2E", // class name
  bases__ZN3ccc7CC5x5y2E, 2,
  &(vtc__ZN3ccc7CC5x5y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y2E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y2  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7DD5x5y23efgEv
  virtual void  abc(); // _ZN3ccc7DD5x5y23abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x5y23pqrEv
  ~DD5x5y2(); // tgen
  DD5x5y2(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y2E) C1{ VBC2{ v3 v1 v2} VBC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x5y2 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y23efgEv");}
void  ccc::DD5x5y2 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y23abcEv");}
void  ccc::DD5x5y2 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y23pqrEv");}
ccc::DD5x5y2 ::~DD5x5y2(){ note_dtor("_ZN3ccc7DD5x5y2E", this);} // tgen
ccc::DD5x5y2 ::DD5x5y2(){ note_ctor("_ZN3ccc7DD5x5y2E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y2E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y2E, buf);
    ::ccc::DD5x5y2 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y2E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y2E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y2E);
    dp->::ccc::DD5x5y2::~DD5x5y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y2E(Test__ZN3ccc7DD5x5y2E, "_ZN3ccc7DD5x5y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y2C1Ev();
extern void _ZN3ccc7DD5x5y2D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y2E[] = {
  NSPAIR(_ZN3ccc7DD5x5y2C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y2E[];
extern void _ZN3ccc7DD5x5y23pqrEv();
extern void _ZN3ccc7DD5x5y23efgEv();
extern void _ZN3ccc7DD5x5y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y23pqrEv,_ZTv0_n12_N3ccc7DD5x5y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y23pqrEv,_ZThn4_N3ccc7DD5x5y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y23efgEv,_ZTv0_n16_N3ccc7DD5x5y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y23efgEv,_ZThn4_N3ccc7DD5x5y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y23abcEv,_ZTv0_n20_N3ccc7DD5x5y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y23abcEv,_ZThn4_N3ccc7DD5x5y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y23pqrEv,_ZTv0_n12_N3ccc7DD5x5y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y23efgEv,_ZTv0_n16_N3ccc7DD5x5y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y23abcEv,_ZTv0_n20_N3ccc7DD5x5y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y2E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y2E[] = {
  {&(_ZTVN3ccc7DD5x5y2E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y2E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y2E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y2E[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y23abcEv,_ZTv0_n20_N3ccc7DD5x5y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y23abcEv,_ZThn4_N3ccc7DD5x5y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y23efgEv,_ZTv0_n16_N3ccc7DD5x5y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y23efgEv,_ZThn4_N3ccc7DD5x5y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y23pqrEv,_ZTv0_n12_N3ccc7DD5x5y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y23pqrEv,_ZThn4_N3ccc7DD5x5y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y2E = {  "_ZN3ccc7DD5x5y2E", // class name
  bases__ZN3ccc7DD5x5y2E, 2,
  &(vtc__ZN3ccc7DD5x5y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y2E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y3  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC5x5y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x5y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x5y33abcEv
  ~CC5x5y3(); // tgen
  CC5x5y3(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y3E) C1{ VBC2{ v2 v1 v3} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x5y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y33efgEv");}
void  ccc::CC5x5y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y33pqrEv");}
void  ccc::CC5x5y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y33abcEv");}
ccc::CC5x5y3 ::~CC5x5y3(){ note_dtor("_ZN3ccc7CC5x5y3E", this);} // tgen
ccc::CC5x5y3 ::CC5x5y3(){ note_ctor("_ZN3ccc7CC5x5y3E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y3E, buf);
    ::ccc::CC5x5y3 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y3E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y3E);
    dp->::ccc::CC5x5y3::~CC5x5y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y3E(Test__ZN3ccc7CC5x5y3E, "_ZN3ccc7CC5x5y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y3C1Ev();
extern void _ZN3ccc7CC5x5y3D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y3E[] = {
  NSPAIR(_ZN3ccc7CC5x5y3C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y3E[];
extern void _ZN3ccc7CC5x5y33pqrEv();
extern void _ZN3ccc7CC5x5y33efgEv();
extern void _ZN3ccc7CC5x5y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y33pqrEv,_ZTv0_n12_N3ccc7CC5x5y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y33pqrEv,_ZThn4_N3ccc7CC5x5y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y33efgEv,_ZTv0_n16_N3ccc7CC5x5y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y33efgEv,_ZThn4_N3ccc7CC5x5y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y33abcEv,_ZTv0_n20_N3ccc7CC5x5y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y33abcEv,_ZThn4_N3ccc7CC5x5y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y33pqrEv,_ZTv0_n12_N3ccc7CC5x5y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y33efgEv,_ZTv0_n16_N3ccc7CC5x5y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y33abcEv,_ZTv0_n20_N3ccc7CC5x5y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y3E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y3E[] = {
  {&(_ZTVN3ccc7CC5x5y3E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y3E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y3E[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y33abcEv,_ZTv0_n20_N3ccc7CC5x5y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y33abcEv,_ZThn4_N3ccc7CC5x5y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y33efgEv,_ZTv0_n16_N3ccc7CC5x5y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y33efgEv,_ZThn4_N3ccc7CC5x5y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y33pqrEv,_ZTv0_n12_N3ccc7CC5x5y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y33pqrEv,_ZThn4_N3ccc7CC5x5y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y3E = {  "_ZN3ccc7CC5x5y3E", // class name
  bases__ZN3ccc7CC5x5y3E, 2,
  &(vtc__ZN3ccc7CC5x5y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y3E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y3  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7DD5x5y33efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x5y33pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x5y33abcEv
  ~DD5x5y3(); // tgen
  DD5x5y3(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y3E) C1{ VBC2{ v2 v1 v3} VBC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x5y3 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y33efgEv");}
void  ccc::DD5x5y3 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y33pqrEv");}
void  ccc::DD5x5y3 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y33abcEv");}
ccc::DD5x5y3 ::~DD5x5y3(){ note_dtor("_ZN3ccc7DD5x5y3E", this);} // tgen
ccc::DD5x5y3 ::DD5x5y3(){ note_ctor("_ZN3ccc7DD5x5y3E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y3E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y3E, buf);
    ::ccc::DD5x5y3 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y3E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y3E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y3E);
    dp->::ccc::DD5x5y3::~DD5x5y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y3E(Test__ZN3ccc7DD5x5y3E, "_ZN3ccc7DD5x5y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y3C1Ev();
extern void _ZN3ccc7DD5x5y3D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y3E[] = {
  NSPAIR(_ZN3ccc7DD5x5y3C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y3E[];
extern void _ZN3ccc7DD5x5y33pqrEv();
extern void _ZN3ccc7DD5x5y33efgEv();
extern void _ZN3ccc7DD5x5y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y33pqrEv,_ZTv0_n12_N3ccc7DD5x5y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y33pqrEv,_ZThn4_N3ccc7DD5x5y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y33efgEv,_ZTv0_n16_N3ccc7DD5x5y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y33efgEv,_ZThn4_N3ccc7DD5x5y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y33abcEv,_ZTv0_n20_N3ccc7DD5x5y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y33abcEv,_ZThn4_N3ccc7DD5x5y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y33pqrEv,_ZTv0_n12_N3ccc7DD5x5y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y33efgEv,_ZTv0_n16_N3ccc7DD5x5y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y33abcEv,_ZTv0_n20_N3ccc7DD5x5y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y3E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y3E[] = {
  {&(_ZTVN3ccc7DD5x5y3E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y3E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y3E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y3E[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y33abcEv,_ZTv0_n20_N3ccc7DD5x5y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y33abcEv,_ZThn4_N3ccc7DD5x5y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y33efgEv,_ZTv0_n16_N3ccc7DD5x5y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y33efgEv,_ZThn4_N3ccc7DD5x5y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y33pqrEv,_ZTv0_n12_N3ccc7DD5x5y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y33pqrEv,_ZThn4_N3ccc7DD5x5y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y3E = {  "_ZN3ccc7DD5x5y3E", // class name
  bases__ZN3ccc7DD5x5y3E, 2,
  &(vtc__ZN3ccc7DD5x5y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y3E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y4  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc7CC5x5y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x5y43abcEv
  virtual void  efg(); // _ZN3ccc7CC5x5y43efgEv
  ~CC5x5y4(); // tgen
  CC5x5y4(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y4E) C1{ VBC2{ v1 v3 v2} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x5y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y43pqrEv");}
void  ccc::CC5x5y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y43abcEv");}
void  ccc::CC5x5y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y43efgEv");}
ccc::CC5x5y4 ::~CC5x5y4(){ note_dtor("_ZN3ccc7CC5x5y4E", this);} // tgen
ccc::CC5x5y4 ::CC5x5y4(){ note_ctor("_ZN3ccc7CC5x5y4E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y4E, buf);
    ::ccc::CC5x5y4 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y4E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y4E);
    dp->::ccc::CC5x5y4::~CC5x5y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y4E(Test__ZN3ccc7CC5x5y4E, "_ZN3ccc7CC5x5y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y4C1Ev();
extern void _ZN3ccc7CC5x5y4D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y4E[] = {
  NSPAIR(_ZN3ccc7CC5x5y4C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y4E[];
extern void _ZN3ccc7CC5x5y43pqrEv();
extern void _ZN3ccc7CC5x5y43efgEv();
extern void _ZN3ccc7CC5x5y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y43pqrEv,_ZTv0_n12_N3ccc7CC5x5y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y43pqrEv,_ZThn4_N3ccc7CC5x5y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y43efgEv,_ZTv0_n16_N3ccc7CC5x5y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y43efgEv,_ZThn4_N3ccc7CC5x5y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y43abcEv,_ZTv0_n20_N3ccc7CC5x5y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y43abcEv,_ZThn4_N3ccc7CC5x5y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y43pqrEv,_ZTv0_n12_N3ccc7CC5x5y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y43efgEv,_ZTv0_n16_N3ccc7CC5x5y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y43abcEv,_ZTv0_n20_N3ccc7CC5x5y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y4E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y4E[] = {
  {&(_ZTVN3ccc7CC5x5y4E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y4E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y4E[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y43abcEv,_ZTv0_n20_N3ccc7CC5x5y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y43abcEv,_ZThn4_N3ccc7CC5x5y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y43efgEv,_ZTv0_n16_N3ccc7CC5x5y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y43efgEv,_ZThn4_N3ccc7CC5x5y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y43pqrEv,_ZTv0_n12_N3ccc7CC5x5y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y43pqrEv,_ZThn4_N3ccc7CC5x5y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y4E = {  "_ZN3ccc7CC5x5y4E", // class name
  bases__ZN3ccc7CC5x5y4E, 2,
  &(vtc__ZN3ccc7CC5x5y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y4E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y4  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc7DD5x5y43pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x5y43abcEv
  virtual void  efg(); // _ZN3ccc7DD5x5y43efgEv
  ~DD5x5y4(); // tgen
  DD5x5y4(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y4E) C1{ VBC2{ v1 v3 v2} VBC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x5y4 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y43pqrEv");}
void  ccc::DD5x5y4 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y43abcEv");}
void  ccc::DD5x5y4 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y43efgEv");}
ccc::DD5x5y4 ::~DD5x5y4(){ note_dtor("_ZN3ccc7DD5x5y4E", this);} // tgen
ccc::DD5x5y4 ::DD5x5y4(){ note_ctor("_ZN3ccc7DD5x5y4E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y4E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y4E, buf);
    ::ccc::DD5x5y4 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y4E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y4E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y4E);
    dp->::ccc::DD5x5y4::~DD5x5y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y4E(Test__ZN3ccc7DD5x5y4E, "_ZN3ccc7DD5x5y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y4C1Ev();
extern void _ZN3ccc7DD5x5y4D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y4E[] = {
  NSPAIR(_ZN3ccc7DD5x5y4C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y4E[];
extern void _ZN3ccc7DD5x5y43pqrEv();
extern void _ZN3ccc7DD5x5y43efgEv();
extern void _ZN3ccc7DD5x5y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y43pqrEv,_ZTv0_n12_N3ccc7DD5x5y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y43pqrEv,_ZThn4_N3ccc7DD5x5y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y43efgEv,_ZTv0_n16_N3ccc7DD5x5y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y43efgEv,_ZThn4_N3ccc7DD5x5y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y43abcEv,_ZTv0_n20_N3ccc7DD5x5y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y43abcEv,_ZThn4_N3ccc7DD5x5y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y43pqrEv,_ZTv0_n12_N3ccc7DD5x5y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y43efgEv,_ZTv0_n16_N3ccc7DD5x5y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y43abcEv,_ZTv0_n20_N3ccc7DD5x5y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y4E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y4E[] = {
  {&(_ZTVN3ccc7DD5x5y4E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y4E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y4E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y4E[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y43abcEv,_ZTv0_n20_N3ccc7DD5x5y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y43abcEv,_ZThn4_N3ccc7DD5x5y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y43efgEv,_ZTv0_n16_N3ccc7DD5x5y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y43efgEv,_ZThn4_N3ccc7DD5x5y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y43pqrEv,_ZTv0_n12_N3ccc7DD5x5y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y43pqrEv,_ZThn4_N3ccc7DD5x5y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y4E = {  "_ZN3ccc7DD5x5y4E", // class name
  bases__ZN3ccc7DD5x5y4E, 2,
  &(vtc__ZN3ccc7DD5x5y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y4E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y5  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc7CC5x5y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x5y53efgEv
  virtual void  abc(); // _ZN3ccc7CC5x5y53abcEv
  ~CC5x5y5(); // tgen
  CC5x5y5(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y5E) C1{ VBC2{ v1 v2 v3} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x5y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y53pqrEv");}
void  ccc::CC5x5y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y53efgEv");}
void  ccc::CC5x5y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y53abcEv");}
ccc::CC5x5y5 ::~CC5x5y5(){ note_dtor("_ZN3ccc7CC5x5y5E", this);} // tgen
ccc::CC5x5y5 ::CC5x5y5(){ note_ctor("_ZN3ccc7CC5x5y5E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y5E, buf);
    ::ccc::CC5x5y5 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y5E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y5E);
    dp->::ccc::CC5x5y5::~CC5x5y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y5E(Test__ZN3ccc7CC5x5y5E, "_ZN3ccc7CC5x5y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y5C1Ev();
extern void _ZN3ccc7CC5x5y5D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y5E[] = {
  NSPAIR(_ZN3ccc7CC5x5y5C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y5E[];
extern void _ZN3ccc7CC5x5y53pqrEv();
extern void _ZN3ccc7CC5x5y53efgEv();
extern void _ZN3ccc7CC5x5y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y53pqrEv,_ZTv0_n12_N3ccc7CC5x5y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y53pqrEv,_ZThn4_N3ccc7CC5x5y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y53efgEv,_ZTv0_n16_N3ccc7CC5x5y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y53efgEv,_ZThn4_N3ccc7CC5x5y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y53abcEv,_ZTv0_n20_N3ccc7CC5x5y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y53abcEv,_ZThn4_N3ccc7CC5x5y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y53pqrEv,_ZTv0_n12_N3ccc7CC5x5y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y53efgEv,_ZTv0_n16_N3ccc7CC5x5y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y53abcEv,_ZTv0_n20_N3ccc7CC5x5y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y5E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y5E[] = {
  {&(_ZTVN3ccc7CC5x5y5E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y5E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y5E[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y53abcEv,_ZTv0_n20_N3ccc7CC5x5y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y53abcEv,_ZThn4_N3ccc7CC5x5y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y53efgEv,_ZTv0_n16_N3ccc7CC5x5y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y53efgEv,_ZThn4_N3ccc7CC5x5y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y53pqrEv,_ZTv0_n12_N3ccc7CC5x5y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y53pqrEv,_ZThn4_N3ccc7CC5x5y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y5E = {  "_ZN3ccc7CC5x5y5E", // class name
  bases__ZN3ccc7CC5x5y5E, 2,
  &(vtc__ZN3ccc7CC5x5y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y5E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y5  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc7DD5x5y53pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x5y53efgEv
  virtual void  abc(); // _ZN3ccc7DD5x5y53abcEv
  ~DD5x5y5(); // tgen
  DD5x5y5(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y5E) C1{ VBC2{ v1 v2 v3} VBC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x5y5 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y53pqrEv");}
void  ccc::DD5x5y5 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y53efgEv");}
void  ccc::DD5x5y5 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y53abcEv");}
ccc::DD5x5y5 ::~DD5x5y5(){ note_dtor("_ZN3ccc7DD5x5y5E", this);} // tgen
ccc::DD5x5y5 ::DD5x5y5(){ note_ctor("_ZN3ccc7DD5x5y5E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y5E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y5E, buf);
    ::ccc::DD5x5y5 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y5E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y5E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y5E);
    dp->::ccc::DD5x5y5::~DD5x5y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y5E(Test__ZN3ccc7DD5x5y5E, "_ZN3ccc7DD5x5y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y5C1Ev();
extern void _ZN3ccc7DD5x5y5D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y5E[] = {
  NSPAIR(_ZN3ccc7DD5x5y5C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y5E[];
extern void _ZN3ccc7DD5x5y53pqrEv();
extern void _ZN3ccc7DD5x5y53efgEv();
extern void _ZN3ccc7DD5x5y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y53pqrEv,_ZTv0_n12_N3ccc7DD5x5y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y53pqrEv,_ZThn4_N3ccc7DD5x5y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y53efgEv,_ZTv0_n16_N3ccc7DD5x5y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y53efgEv,_ZThn4_N3ccc7DD5x5y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y53abcEv,_ZTv0_n20_N3ccc7DD5x5y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y53abcEv,_ZThn4_N3ccc7DD5x5y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y53pqrEv,_ZTv0_n12_N3ccc7DD5x5y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y53efgEv,_ZTv0_n16_N3ccc7DD5x5y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y53abcEv,_ZTv0_n20_N3ccc7DD5x5y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y5E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y5E[] = {
  {&(_ZTVN3ccc7DD5x5y5E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y5E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y5E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y5E[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y53abcEv,_ZTv0_n20_N3ccc7DD5x5y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y53abcEv,_ZThn4_N3ccc7DD5x5y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y53efgEv,_ZTv0_n16_N3ccc7DD5x5y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y53efgEv,_ZThn4_N3ccc7DD5x5y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y53pqrEv,_ZTv0_n12_N3ccc7DD5x5y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y53pqrEv,_ZThn4_N3ccc7DD5x5y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y5E = {  "_ZN3ccc7DD5x5y5E", // class name
  bases__ZN3ccc7DD5x5y5E, 2,
  &(vtc__ZN3ccc7DD5x5y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y5E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y6  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC5x5y63abcEv
  virtual void  efg(); // _ZN3ccc7CC5x5y63efgEv
  ~CC5x5y6(); // tgen
  CC5x5y6(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y6E) C1{ VBC2{ v3 v2 v1} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x5y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y63abcEv");}
void  ccc::CC5x5y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y63efgEv");}
ccc::CC5x5y6 ::~CC5x5y6(){ note_dtor("_ZN3ccc7CC5x5y6E", this);} // tgen
ccc::CC5x5y6 ::CC5x5y6(){ note_ctor("_ZN3ccc7CC5x5y6E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y6E, buf);
    ::ccc::CC5x5y6 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y6E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y6E);
    dp->::ccc::CC5x5y6::~CC5x5y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y6E(Test__ZN3ccc7CC5x5y6E, "_ZN3ccc7CC5x5y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y6C1Ev();
extern void _ZN3ccc7CC5x5y6D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y6E[] = {
  NSPAIR(_ZN3ccc7CC5x5y6C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y6E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc7CC5x5y63efgEv();
extern void _ZN3ccc7CC5x5y63abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y63efgEv,_ZTv0_n16_N3ccc7CC5x5y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y63efgEv,_ZThn4_N3ccc7CC5x5y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y63abcEv,_ZTv0_n20_N3ccc7CC5x5y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y63abcEv,_ZThn4_N3ccc7CC5x5y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y63abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y63efgEv,_ZTv0_n16_N3ccc7CC5x5y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y63abcEv,_ZTv0_n20_N3ccc7CC5x5y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y6E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y6E[] = {
  {&(_ZTVN3ccc7CC5x5y6E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y6E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y6E[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y63abcEv,_ZTv0_n20_N3ccc7CC5x5y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y63abcEv,_ZThn4_N3ccc7CC5x5y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y63efgEv,_ZTv0_n16_N3ccc7CC5x5y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y63efgEv,_ZThn4_N3ccc7CC5x5y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y6E = {  "_ZN3ccc7CC5x5y6E", // class name
  bases__ZN3ccc7CC5x5y6E, 2,
  &(vtc__ZN3ccc7CC5x5y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y6E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y6  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7DD5x5y63abcEv
  virtual void  efg(); // _ZN3ccc7DD5x5y63efgEv
  ~DD5x5y6(); // tgen
  DD5x5y6(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y6E) C1{ VBC2{ v3 v2 v1} VBC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x5y6 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y63abcEv");}
void  ccc::DD5x5y6 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y63efgEv");}
ccc::DD5x5y6 ::~DD5x5y6(){ note_dtor("_ZN3ccc7DD5x5y6E", this);} // tgen
ccc::DD5x5y6 ::DD5x5y6(){ note_ctor("_ZN3ccc7DD5x5y6E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y6E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y6E, buf);
    ::ccc::DD5x5y6 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y6E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y6E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y6E);
    dp->::ccc::DD5x5y6::~DD5x5y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y6E(Test__ZN3ccc7DD5x5y6E, "_ZN3ccc7DD5x5y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y6C1Ev();
extern void _ZN3ccc7DD5x5y6D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y6E[] = {
  NSPAIR(_ZN3ccc7DD5x5y6C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y6E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x5y63efgEv();
extern void _ZN3ccc7DD5x5y63abcEv();
extern void _ZN3ccc3BB53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y63efgEv,_ZTv0_n16_N3ccc7DD5x5y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y63efgEv,_ZThn4_N3ccc7DD5x5y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y63abcEv,_ZTv0_n20_N3ccc7DD5x5y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y63abcEv,_ZThn4_N3ccc7DD5x5y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y63abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y63efgEv,_ZTv0_n16_N3ccc7DD5x5y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y63abcEv,_ZTv0_n20_N3ccc7DD5x5y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y6E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y6E[] = {
  {&(_ZTVN3ccc7DD5x5y6E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y6E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y6E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y6E[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y63abcEv,_ZTv0_n20_N3ccc7DD5x5y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y63abcEv,_ZThn4_N3ccc7DD5x5y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y63efgEv,_ZTv0_n16_N3ccc7DD5x5y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y63efgEv,_ZThn4_N3ccc7DD5x5y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y6E = {  "_ZN3ccc7DD5x5y6E", // class name
  bases__ZN3ccc7DD5x5y6E, 2,
  &(vtc__ZN3ccc7DD5x5y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y6E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y7  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC5x5y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x5y73pqrEv
  ~CC5x5y7(); // tgen
  CC5x5y7(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y7E) C1{ VBC2{ v2 v3 v1} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x5y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y73abcEv");}
void  ccc::CC5x5y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y73pqrEv");}
ccc::CC5x5y7 ::~CC5x5y7(){ note_dtor("_ZN3ccc7CC5x5y7E", this);} // tgen
ccc::CC5x5y7 ::CC5x5y7(){ note_ctor("_ZN3ccc7CC5x5y7E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y7E, buf);
    ::ccc::CC5x5y7 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y7E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y7E);
    dp->::ccc::CC5x5y7::~CC5x5y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y7E(Test__ZN3ccc7CC5x5y7E, "_ZN3ccc7CC5x5y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y7C1Ev();
extern void _ZN3ccc7CC5x5y7D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y7E[] = {
  NSPAIR(_ZN3ccc7CC5x5y7C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y7E[];
extern void _ZN3ccc7CC5x5y73pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc7CC5x5y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y73pqrEv,_ZTv0_n12_N3ccc7CC5x5y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y73pqrEv,_ZThn4_N3ccc7CC5x5y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y73abcEv,_ZTv0_n20_N3ccc7CC5x5y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y73abcEv,_ZThn4_N3ccc7CC5x5y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y73abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y73pqrEv,_ZTv0_n12_N3ccc7CC5x5y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y73abcEv,_ZTv0_n20_N3ccc7CC5x5y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y7E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y7E[] = {
  {&(_ZTVN3ccc7CC5x5y7E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y7E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y7E[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y73abcEv,_ZTv0_n20_N3ccc7CC5x5y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y73abcEv,_ZThn4_N3ccc7CC5x5y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y73pqrEv,_ZTv0_n12_N3ccc7CC5x5y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y73pqrEv,_ZThn4_N3ccc7CC5x5y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y7E = {  "_ZN3ccc7CC5x5y7E", // class name
  bases__ZN3ccc7CC5x5y7E, 2,
  &(vtc__ZN3ccc7CC5x5y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y7E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y7  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7DD5x5y73abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x5y73pqrEv
  ~DD5x5y7(); // tgen
  DD5x5y7(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y7E) C1{ VBC2{ v2 v3 v1} VBC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x5y7 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y73abcEv");}
void  ccc::DD5x5y7 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y73pqrEv");}
ccc::DD5x5y7 ::~DD5x5y7(){ note_dtor("_ZN3ccc7DD5x5y7E", this);} // tgen
ccc::DD5x5y7 ::DD5x5y7(){ note_ctor("_ZN3ccc7DD5x5y7E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y7E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y7E, buf);
    ::ccc::DD5x5y7 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y7E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y7E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y7E);
    dp->::ccc::DD5x5y7::~DD5x5y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y7E(Test__ZN3ccc7DD5x5y7E, "_ZN3ccc7DD5x5y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y7C1Ev();
extern void _ZN3ccc7DD5x5y7D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y7E[] = {
  NSPAIR(_ZN3ccc7DD5x5y7C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y7E[];
extern void _ZN3ccc7DD5x5y73pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc7DD5x5y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y73pqrEv,_ZTv0_n12_N3ccc7DD5x5y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y73pqrEv,_ZThn4_N3ccc7DD5x5y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y73abcEv,_ZTv0_n20_N3ccc7DD5x5y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y73abcEv,_ZThn4_N3ccc7DD5x5y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y73abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y73pqrEv,_ZTv0_n12_N3ccc7DD5x5y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y73abcEv,_ZTv0_n20_N3ccc7DD5x5y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y7E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y7E[] = {
  {&(_ZTVN3ccc7DD5x5y7E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y7E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y7E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y7E[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y73abcEv,_ZTv0_n20_N3ccc7DD5x5y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y73abcEv,_ZThn4_N3ccc7DD5x5y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y73pqrEv,_ZTv0_n12_N3ccc7DD5x5y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y73pqrEv,_ZThn4_N3ccc7DD5x5y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y7E = {  "_ZN3ccc7DD5x5y7E", // class name
  bases__ZN3ccc7DD5x5y7E, 2,
  &(vtc__ZN3ccc7DD5x5y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y7E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y8  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC5x5y83efgEv
  virtual void  abc(); // _ZN3ccc7CC5x5y83abcEv
  ~CC5x5y8(); // tgen
  CC5x5y8(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y8E) C1{ VBC2{ v3 v1 v2} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x5y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y83efgEv");}
void  ccc::CC5x5y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x5y83abcEv");}
ccc::CC5x5y8 ::~CC5x5y8(){ note_dtor("_ZN3ccc7CC5x5y8E", this);} // tgen
ccc::CC5x5y8 ::CC5x5y8(){ note_ctor("_ZN3ccc7CC5x5y8E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y8E, buf);
    ::ccc::CC5x5y8 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y8E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y8E);
    dp->::ccc::CC5x5y8::~CC5x5y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y8E(Test__ZN3ccc7CC5x5y8E, "_ZN3ccc7CC5x5y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y8C1Ev();
extern void _ZN3ccc7CC5x5y8D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y8E[] = {
  NSPAIR(_ZN3ccc7CC5x5y8C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y8E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc7CC5x5y83efgEv();
extern void _ZN3ccc7CC5x5y83abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y83efgEv,_ZTv0_n16_N3ccc7CC5x5y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y83efgEv,_ZThn4_N3ccc7CC5x5y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x5y83abcEv,_ZTv0_n20_N3ccc7CC5x5y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y83abcEv,_ZThn4_N3ccc7CC5x5y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y83abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y83efgEv,_ZTv0_n16_N3ccc7CC5x5y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x5y83abcEv,_ZTv0_n20_N3ccc7CC5x5y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y8E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y8E[] = {
  {&(_ZTVN3ccc7CC5x5y8E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y8E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y8E[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x5y83abcEv,_ZTv0_n20_N3ccc7CC5x5y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y83abcEv,_ZThn4_N3ccc7CC5x5y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y83efgEv,_ZTv0_n16_N3ccc7CC5x5y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y83efgEv,_ZThn4_N3ccc7CC5x5y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y8E = {  "_ZN3ccc7CC5x5y8E", // class name
  bases__ZN3ccc7CC5x5y8E, 2,
  &(vtc__ZN3ccc7CC5x5y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y8E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y8  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7DD5x5y83efgEv
  virtual void  abc(); // _ZN3ccc7DD5x5y83abcEv
  ~DD5x5y8(); // tgen
  DD5x5y8(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y8E) C1{ VBC2{ v3 v1 v2} VBC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x5y8 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y83efgEv");}
void  ccc::DD5x5y8 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x5y83abcEv");}
ccc::DD5x5y8 ::~DD5x5y8(){ note_dtor("_ZN3ccc7DD5x5y8E", this);} // tgen
ccc::DD5x5y8 ::DD5x5y8(){ note_ctor("_ZN3ccc7DD5x5y8E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y8E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y8E, buf);
    ::ccc::DD5x5y8 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y8E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y8E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y8E);
    dp->::ccc::DD5x5y8::~DD5x5y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y8E(Test__ZN3ccc7DD5x5y8E, "_ZN3ccc7DD5x5y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y8C1Ev();
extern void _ZN3ccc7DD5x5y8D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y8E[] = {
  NSPAIR(_ZN3ccc7DD5x5y8C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y8E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x5y83efgEv();
extern void _ZN3ccc7DD5x5y83abcEv();
extern void _ZN3ccc3BB53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y83efgEv,_ZTv0_n16_N3ccc7DD5x5y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y83efgEv,_ZThn4_N3ccc7DD5x5y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7DD5x5y83abcEv,_ZTv0_n20_N3ccc7DD5x5y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y83abcEv,_ZThn4_N3ccc7DD5x5y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y83abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y83efgEv,_ZTv0_n16_N3ccc7DD5x5y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7DD5x5y83abcEv,_ZTv0_n20_N3ccc7DD5x5y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y8E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y8E[] = {
  {&(_ZTVN3ccc7DD5x5y8E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y8E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y8E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y8E[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7DD5x5y83abcEv,_ZTv0_n20_N3ccc7DD5x5y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y83abcEv,_ZThn4_N3ccc7DD5x5y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y83efgEv,_ZTv0_n16_N3ccc7DD5x5y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y83efgEv,_ZThn4_N3ccc7DD5x5y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y8E = {  "_ZN3ccc7DD5x5y8E", // class name
  bases__ZN3ccc7DD5x5y8E, 2,
  &(vtc__ZN3ccc7DD5x5y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y8E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y9  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC5x5y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x5y93pqrEv
  ~CC5x5y9(); // tgen
  CC5x5y9(); // tgen
};
//SIG(1 _ZN3ccc7CC5x5y9E) C1{ VBC2{ v2 v1 v3} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x5y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x5y93efgEv");}
void  ccc::CC5x5y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x5y93pqrEv");}
ccc::CC5x5y9 ::~CC5x5y9(){ note_dtor("_ZN3ccc7CC5x5y9E", this);} // tgen
ccc::CC5x5y9 ::CC5x5y9(){ note_ctor("_ZN3ccc7CC5x5y9E", this);} // tgen
}
static void Test__ZN3ccc7CC5x5y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x5y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x5y9E, buf);
    ::ccc::CC5x5y9 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x5y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x5y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x5y9E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc7CC5x5y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x5y9E);
    dp->::ccc::CC5x5y9::~CC5x5y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x5y9E(Test__ZN3ccc7CC5x5y9E, "_ZN3ccc7CC5x5y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x5y9C1Ev();
extern void _ZN3ccc7CC5x5y9D1Ev();
Name_Map name_map__ZN3ccc7CC5x5y9E[] = {
  NSPAIR(_ZN3ccc7CC5x5y9C1Ev),
  NSPAIR(_ZN3ccc7CC5x5y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC5x5y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y9E[];
extern void _ZN3ccc7CC5x5y93pqrEv();
extern void _ZN3ccc7CC5x5y93efgEv();
extern void _ZN3ccc3BB53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x5y93pqrEv,_ZTv0_n12_N3ccc7CC5x5y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y93pqrEv,_ZThn4_N3ccc7CC5x5y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x5y93efgEv,_ZTv0_n16_N3ccc7CC5x5y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x5y93efgEv,_ZThn4_N3ccc7CC5x5y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC5x5y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x5y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x5y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x5y93pqrEv,_ZTv0_n12_N3ccc7CC5x5y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x5y93efgEv,_ZTv0_n16_N3ccc7CC5x5y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x5y9E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x5y9E[] = {
  {&(_ZTVN3ccc7CC5x5y9E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x5y9E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x5y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x5y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x5y9E[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x5y93efgEv,_ZTv0_n16_N3ccc7CC5x5y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y93efgEv,_ZThn4_N3ccc7CC5x5y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x5y93pqrEv,_ZTv0_n12_N3ccc7CC5x5y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x5y93pqrEv,_ZThn4_N3ccc7CC5x5y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x5y9E = {  "_ZN3ccc7CC5x5y9E", // class name
  bases__ZN3ccc7CC5x5y9E, 2,
  &(vtc__ZN3ccc7CC5x5y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x5y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x5y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x5y9E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x5y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y9  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7DD5x5y93efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x5y93pqrEv
  ~DD5x5y9(); // tgen
  DD5x5y9(); // tgen
};
//SIG(1 _ZN3ccc7DD5x5y9E) C1{ VBC2{ v2 v1 v3} VBC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x5y9 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x5y93efgEv");}
void  ccc::DD5x5y9 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x5y93pqrEv");}
ccc::DD5x5y9 ::~DD5x5y9(){ note_dtor("_ZN3ccc7DD5x5y9E", this);} // tgen
ccc::DD5x5y9 ::DD5x5y9(){ note_ctor("_ZN3ccc7DD5x5y9E", this);} // tgen
}
static void Test__ZN3ccc7DD5x5y9E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x5y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x5y9E, buf);
    ::ccc::DD5x5y9 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x5y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x5y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x5y9E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7DD5x5y9E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x5y9E);
    dp->::ccc::DD5x5y9::~DD5x5y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x5y9E(Test__ZN3ccc7DD5x5y9E, "_ZN3ccc7DD5x5y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x5y9C1Ev();
extern void _ZN3ccc7DD5x5y9D1Ev();
Name_Map name_map__ZN3ccc7DD5x5y9E[] = {
  NSPAIR(_ZN3ccc7DD5x5y9C1Ev),
  NSPAIR(_ZN3ccc7DD5x5y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7DD5x5y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y9E[];
extern void _ZN3ccc7DD5x5y93pqrEv();
extern void _ZN3ccc7DD5x5y93efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x5y93pqrEv,_ZTv0_n12_N3ccc7DD5x5y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y93pqrEv,_ZThn4_N3ccc7DD5x5y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x5y93efgEv,_ZTv0_n16_N3ccc7DD5x5y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x5y93efgEv,_ZThn4_N3ccc7DD5x5y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7DD5x5y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x5y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x5y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x5y93pqrEv,_ZTv0_n12_N3ccc7DD5x5y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x5y93efgEv,_ZTv0_n16_N3ccc7DD5x5y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x5y9E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x5y9E[] = {
  {&(_ZTVN3ccc7DD5x5y9E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y9E[7]),  7,18},
  {&(_ZTVN3ccc7DD5x5y9E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x5y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x5y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x5y9E[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x5y93efgEv,_ZTv0_n16_N3ccc7DD5x5y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y93efgEv,_ZThn4_N3ccc7DD5x5y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x5y93pqrEv,_ZTv0_n12_N3ccc7DD5x5y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x5y93pqrEv,_ZThn4_N3ccc7DD5x5y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x5y9E = {  "_ZN3ccc7DD5x5y9E", // class name
  bases__ZN3ccc7DD5x5y9E, 2,
  &(vtc__ZN3ccc7DD5x5y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x5y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x5y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x5y9E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x5y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y10  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8CC5x5y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC5x5y103abcEv
  ~CC5x5y10(); // tgen
  CC5x5y10(); // tgen
};
//SIG(1 _ZN3ccc8CC5x5y10E) C1{ VBC2{ v1 v3 v2} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x5y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x5y103pqrEv");}
void  ccc::CC5x5y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x5y103abcEv");}
ccc::CC5x5y10 ::~CC5x5y10(){ note_dtor("_ZN3ccc8CC5x5y10E", this);} // tgen
ccc::CC5x5y10 ::CC5x5y10(){ note_ctor("_ZN3ccc8CC5x5y10E", this);} // tgen
}
static void Test__ZN3ccc8CC5x5y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x5y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x5y10E, buf);
    ::ccc::CC5x5y10 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x5y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x5y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x5y10E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc8CC5x5y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x5y10E);
    dp->::ccc::CC5x5y10::~CC5x5y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x5y10E(Test__ZN3ccc8CC5x5y10E, "_ZN3ccc8CC5x5y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x5y10C1Ev();
extern void _ZN3ccc8CC5x5y10D1Ev();
Name_Map name_map__ZN3ccc8CC5x5y10E[] = {
  NSPAIR(_ZN3ccc8CC5x5y10C1Ev),
  NSPAIR(_ZN3ccc8CC5x5y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC5x5y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y10E[];
extern void _ZN3ccc8CC5x5y103pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc8CC5x5y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x5y103pqrEv,_ZTv0_n12_N3ccc8CC5x5y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x5y103pqrEv,_ZThn4_N3ccc8CC5x5y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x5y103abcEv,_ZTv0_n20_N3ccc8CC5x5y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x5y103abcEv,_ZThn4_N3ccc8CC5x5y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x5y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x5y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x5y103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x5y103pqrEv,_ZTv0_n12_N3ccc8CC5x5y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x5y103abcEv,_ZTv0_n20_N3ccc8CC5x5y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x5y10E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x5y10E[] = {
  {&(_ZTVN3ccc8CC5x5y10E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x5y10E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x5y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x5y10E[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x5y103abcEv,_ZTv0_n20_N3ccc8CC5x5y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x5y103abcEv,_ZThn4_N3ccc8CC5x5y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x5y103pqrEv,_ZTv0_n12_N3ccc8CC5x5y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x5y103pqrEv,_ZThn4_N3ccc8CC5x5y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x5y10E = {  "_ZN3ccc8CC5x5y10E", // class name
  bases__ZN3ccc8CC5x5y10E, 2,
  &(vtc__ZN3ccc8CC5x5y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x5y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x5y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x5y10E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x5y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y10  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8DD5x5y103pqrEv
  virtual void  abc(); // _ZN3ccc8DD5x5y103abcEv
  ~DD5x5y10(); // tgen
  DD5x5y10(); // tgen
};
//SIG(1 _ZN3ccc8DD5x5y10E) C1{ VBC2{ v1 v3 v2} VBC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x5y10 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x5y103pqrEv");}
void  ccc::DD5x5y10 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x5y103abcEv");}
ccc::DD5x5y10 ::~DD5x5y10(){ note_dtor("_ZN3ccc8DD5x5y10E", this);} // tgen
ccc::DD5x5y10 ::DD5x5y10(){ note_ctor("_ZN3ccc8DD5x5y10E", this);} // tgen
}
static void Test__ZN3ccc8DD5x5y10E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x5y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x5y10E, buf);
    ::ccc::DD5x5y10 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x5y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x5y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x5y10E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8DD5x5y10E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x5y10E);
    dp->::ccc::DD5x5y10::~DD5x5y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x5y10E(Test__ZN3ccc8DD5x5y10E, "_ZN3ccc8DD5x5y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x5y10C1Ev();
extern void _ZN3ccc8DD5x5y10D1Ev();
Name_Map name_map__ZN3ccc8DD5x5y10E[] = {
  NSPAIR(_ZN3ccc8DD5x5y10C1Ev),
  NSPAIR(_ZN3ccc8DD5x5y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8DD5x5y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y10E[];
extern void _ZN3ccc8DD5x5y103pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x5y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x5y103pqrEv,_ZTv0_n12_N3ccc8DD5x5y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x5y103pqrEv,_ZThn4_N3ccc8DD5x5y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8DD5x5y103abcEv,_ZTv0_n20_N3ccc8DD5x5y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x5y103abcEv,_ZThn4_N3ccc8DD5x5y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x5y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x5y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x5y103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x5y103pqrEv,_ZTv0_n12_N3ccc8DD5x5y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8DD5x5y103abcEv,_ZTv0_n20_N3ccc8DD5x5y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x5y10E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x5y10E[] = {
  {&(_ZTVN3ccc8DD5x5y10E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y10E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y10E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x5y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x5y10E[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8DD5x5y103abcEv,_ZTv0_n20_N3ccc8DD5x5y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x5y103abcEv,_ZThn4_N3ccc8DD5x5y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x5y103pqrEv,_ZTv0_n12_N3ccc8DD5x5y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x5y103pqrEv,_ZThn4_N3ccc8DD5x5y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x5y10E = {  "_ZN3ccc8DD5x5y10E", // class name
  bases__ZN3ccc8DD5x5y10E, 2,
  &(vtc__ZN3ccc8DD5x5y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x5y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x5y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x5y10E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x5y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y11  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8CC5x5y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC5x5y113efgEv
  ~CC5x5y11(); // tgen
  CC5x5y11(); // tgen
};
//SIG(1 _ZN3ccc8CC5x5y11E) C1{ VBC2{ v1 v2 v3} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x5y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x5y113pqrEv");}
void  ccc::CC5x5y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x5y113efgEv");}
ccc::CC5x5y11 ::~CC5x5y11(){ note_dtor("_ZN3ccc8CC5x5y11E", this);} // tgen
ccc::CC5x5y11 ::CC5x5y11(){ note_ctor("_ZN3ccc8CC5x5y11E", this);} // tgen
}
static void Test__ZN3ccc8CC5x5y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x5y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x5y11E, buf);
    ::ccc::CC5x5y11 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x5y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x5y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x5y11E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc8CC5x5y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x5y11E);
    dp->::ccc::CC5x5y11::~CC5x5y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x5y11E(Test__ZN3ccc8CC5x5y11E, "_ZN3ccc8CC5x5y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x5y11C1Ev();
extern void _ZN3ccc8CC5x5y11D1Ev();
Name_Map name_map__ZN3ccc8CC5x5y11E[] = {
  NSPAIR(_ZN3ccc8CC5x5y11C1Ev),
  NSPAIR(_ZN3ccc8CC5x5y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC5x5y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y11E[];
extern void _ZN3ccc8CC5x5y113pqrEv();
extern void _ZN3ccc8CC5x5y113efgEv();
extern void _ZN3ccc3BB53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x5y113pqrEv,_ZTv0_n12_N3ccc8CC5x5y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x5y113pqrEv,_ZThn4_N3ccc8CC5x5y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x5y113efgEv,_ZTv0_n16_N3ccc8CC5x5y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x5y113efgEv,_ZThn4_N3ccc8CC5x5y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x5y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x5y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x5y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x5y113pqrEv,_ZTv0_n12_N3ccc8CC5x5y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x5y113efgEv,_ZTv0_n16_N3ccc8CC5x5y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x5y11E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x5y11E[] = {
  {&(_ZTVN3ccc8CC5x5y11E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x5y11E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x5y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x5y11E[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x5y113efgEv,_ZTv0_n16_N3ccc8CC5x5y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x5y113efgEv,_ZThn4_N3ccc8CC5x5y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x5y113pqrEv,_ZTv0_n12_N3ccc8CC5x5y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x5y113pqrEv,_ZThn4_N3ccc8CC5x5y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x5y11E = {  "_ZN3ccc8CC5x5y11E", // class name
  bases__ZN3ccc8CC5x5y11E, 2,
  &(vtc__ZN3ccc8CC5x5y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x5y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x5y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x5y11E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x5y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y11  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8DD5x5y113pqrEv
  virtual void  efg(); // _ZN3ccc8DD5x5y113efgEv
  ~DD5x5y11(); // tgen
  DD5x5y11(); // tgen
};
//SIG(1 _ZN3ccc8DD5x5y11E) C1{ VBC2{ v1 v2 v3} VBC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x5y11 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x5y113pqrEv");}
void  ccc::DD5x5y11 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x5y113efgEv");}
ccc::DD5x5y11 ::~DD5x5y11(){ note_dtor("_ZN3ccc8DD5x5y11E", this);} // tgen
ccc::DD5x5y11 ::DD5x5y11(){ note_ctor("_ZN3ccc8DD5x5y11E", this);} // tgen
}
static void Test__ZN3ccc8DD5x5y11E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x5y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x5y11E, buf);
    ::ccc::DD5x5y11 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x5y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x5y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x5y11E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8DD5x5y11E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x5y11E);
    dp->::ccc::DD5x5y11::~DD5x5y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x5y11E(Test__ZN3ccc8DD5x5y11E, "_ZN3ccc8DD5x5y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x5y11C1Ev();
extern void _ZN3ccc8DD5x5y11D1Ev();
Name_Map name_map__ZN3ccc8DD5x5y11E[] = {
  NSPAIR(_ZN3ccc8DD5x5y11C1Ev),
  NSPAIR(_ZN3ccc8DD5x5y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8DD5x5y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y11E[];
extern void _ZN3ccc8DD5x5y113pqrEv();
extern void _ZN3ccc8DD5x5y113efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x5y113pqrEv,_ZTv0_n12_N3ccc8DD5x5y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x5y113pqrEv,_ZThn4_N3ccc8DD5x5y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x5y113efgEv,_ZTv0_n16_N3ccc8DD5x5y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x5y113efgEv,_ZThn4_N3ccc8DD5x5y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x5y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x5y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x5y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x5y113pqrEv,_ZTv0_n12_N3ccc8DD5x5y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x5y113efgEv,_ZTv0_n16_N3ccc8DD5x5y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x5y11E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x5y11E[] = {
  {&(_ZTVN3ccc8DD5x5y11E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y11E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y11E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x5y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x5y11E[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x5y113efgEv,_ZTv0_n16_N3ccc8DD5x5y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x5y113efgEv,_ZThn4_N3ccc8DD5x5y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x5y113pqrEv,_ZTv0_n12_N3ccc8DD5x5y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x5y113pqrEv,_ZThn4_N3ccc8DD5x5y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x5y11E = {  "_ZN3ccc8DD5x5y11E", // class name
  bases__ZN3ccc8DD5x5y11E, 2,
  &(vtc__ZN3ccc8DD5x5y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x5y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x5y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x5y11E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x5y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y12  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc8CC5x5y123abcEv
  ~CC5x5y12(); // tgen
  CC5x5y12(); // tgen
};
//SIG(1 _ZN3ccc8CC5x5y12E) C1{ VBC2{ v2 v3 v1} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC5x5y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x5y123abcEv");}
ccc::CC5x5y12 ::~CC5x5y12(){ note_dtor("_ZN3ccc8CC5x5y12E", this);} // tgen
ccc::CC5x5y12 ::CC5x5y12(){ note_ctor("_ZN3ccc8CC5x5y12E", this);} // tgen
}
static void Test__ZN3ccc8CC5x5y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x5y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x5y12E, buf);
    ::ccc::CC5x5y12 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x5y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x5y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x5y12E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc8CC5x5y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x5y12E);
    dp->::ccc::CC5x5y12::~CC5x5y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x5y12E(Test__ZN3ccc8CC5x5y12E, "_ZN3ccc8CC5x5y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x5y12C1Ev();
extern void _ZN3ccc8CC5x5y12D1Ev();
Name_Map name_map__ZN3ccc8CC5x5y12E[] = {
  NSPAIR(_ZN3ccc8CC5x5y12C1Ev),
  NSPAIR(_ZN3ccc8CC5x5y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC5x5y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y12E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc8CC5x5y123abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x5y123abcEv,_ZTv0_n20_N3ccc8CC5x5y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x5y123abcEv,_ZThn4_N3ccc8CC5x5y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x5y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x5y123abcEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x5y123abcEv,_ZTv0_n20_N3ccc8CC5x5y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x5y12E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x5y12E[] = {
  {&(_ZTVN3ccc8CC5x5y12E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x5y12E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x5y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x5y12E[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x5y123abcEv,_ZTv0_n20_N3ccc8CC5x5y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x5y123abcEv,_ZThn4_N3ccc8CC5x5y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x5y12E = {  "_ZN3ccc8CC5x5y12E", // class name
  bases__ZN3ccc8CC5x5y12E, 2,
  &(vtc__ZN3ccc8CC5x5y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x5y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x5y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x5y12E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x5y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y12  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc8DD5x5y123abcEv
  ~DD5x5y12(); // tgen
  DD5x5y12(); // tgen
};
//SIG(1 _ZN3ccc8DD5x5y12E) C1{ VBC2{ v2 v3 v1} VBC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::DD5x5y12 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x5y123abcEv");}
ccc::DD5x5y12 ::~DD5x5y12(){ note_dtor("_ZN3ccc8DD5x5y12E", this);} // tgen
ccc::DD5x5y12 ::DD5x5y12(){ note_ctor("_ZN3ccc8DD5x5y12E", this);} // tgen
}
static void Test__ZN3ccc8DD5x5y12E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x5y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x5y12E, buf);
    ::ccc::DD5x5y12 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x5y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x5y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x5y12E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8DD5x5y12E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x5y12E);
    dp->::ccc::DD5x5y12::~DD5x5y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x5y12E(Test__ZN3ccc8DD5x5y12E, "_ZN3ccc8DD5x5y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x5y12C1Ev();
extern void _ZN3ccc8DD5x5y12D1Ev();
Name_Map name_map__ZN3ccc8DD5x5y12E[] = {
  NSPAIR(_ZN3ccc8DD5x5y12C1Ev),
  NSPAIR(_ZN3ccc8DD5x5y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8DD5x5y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y12E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x5y123abcEv();
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8DD5x5y123abcEv,_ZTv0_n20_N3ccc8DD5x5y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x5y123abcEv,_ZThn4_N3ccc8DD5x5y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x5y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x5y123abcEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8DD5x5y123abcEv,_ZTv0_n20_N3ccc8DD5x5y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x5y12E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x5y12E[] = {
  {&(_ZTVN3ccc8DD5x5y12E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y12E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y12E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x5y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x5y12E[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8DD5x5y123abcEv,_ZTv0_n20_N3ccc8DD5x5y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x5y123abcEv,_ZThn4_N3ccc8DD5x5y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x5y12E = {  "_ZN3ccc8DD5x5y12E", // class name
  bases__ZN3ccc8DD5x5y12E, 2,
  &(vtc__ZN3ccc8DD5x5y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x5y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x5y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x5y12E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x5y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y13  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc8CC5x5y133efgEv
  ~CC5x5y13(); // tgen
  CC5x5y13(); // tgen
};
//SIG(1 _ZN3ccc8CC5x5y13E) C1{ VBC2{ v2 v1 v3} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC5x5y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x5y133efgEv");}
ccc::CC5x5y13 ::~CC5x5y13(){ note_dtor("_ZN3ccc8CC5x5y13E", this);} // tgen
ccc::CC5x5y13 ::CC5x5y13(){ note_ctor("_ZN3ccc8CC5x5y13E", this);} // tgen
}
static void Test__ZN3ccc8CC5x5y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x5y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x5y13E, buf);
    ::ccc::CC5x5y13 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x5y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x5y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x5y13E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc8CC5x5y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x5y13E);
    dp->::ccc::CC5x5y13::~CC5x5y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x5y13E(Test__ZN3ccc8CC5x5y13E, "_ZN3ccc8CC5x5y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x5y13C1Ev();
extern void _ZN3ccc8CC5x5y13D1Ev();
Name_Map name_map__ZN3ccc8CC5x5y13E[] = {
  NSPAIR(_ZN3ccc8CC5x5y13C1Ev),
  NSPAIR(_ZN3ccc8CC5x5y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC5x5y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y13E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc8CC5x5y133efgEv();
extern void _ZN3ccc3BB53abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x5y133efgEv,_ZTv0_n16_N3ccc8CC5x5y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x5y133efgEv,_ZThn4_N3ccc8CC5x5y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x5y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x5y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x5y133efgEv,_ZTv0_n16_N3ccc8CC5x5y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x5y13E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x5y13E[] = {
  {&(_ZTVN3ccc8CC5x5y13E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x5y13E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x5y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x5y13E[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x5y133efgEv,_ZTv0_n16_N3ccc8CC5x5y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x5y133efgEv,_ZThn4_N3ccc8CC5x5y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x5y13E = {  "_ZN3ccc8CC5x5y13E", // class name
  bases__ZN3ccc8CC5x5y13E, 2,
  &(vtc__ZN3ccc8CC5x5y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x5y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x5y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x5y13E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x5y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y13  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc8DD5x5y133efgEv
  ~DD5x5y13(); // tgen
  DD5x5y13(); // tgen
};
//SIG(1 _ZN3ccc8DD5x5y13E) C1{ VBC2{ v2 v1 v3} VBC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::DD5x5y13 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x5y133efgEv");}
ccc::DD5x5y13 ::~DD5x5y13(){ note_dtor("_ZN3ccc8DD5x5y13E", this);} // tgen
ccc::DD5x5y13 ::DD5x5y13(){ note_ctor("_ZN3ccc8DD5x5y13E", this);} // tgen
}
static void Test__ZN3ccc8DD5x5y13E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x5y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x5y13E, buf);
    ::ccc::DD5x5y13 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x5y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x5y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x5y13E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8DD5x5y13E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x5y13E);
    dp->::ccc::DD5x5y13::~DD5x5y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x5y13E(Test__ZN3ccc8DD5x5y13E, "_ZN3ccc8DD5x5y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x5y13C1Ev();
extern void _ZN3ccc8DD5x5y13D1Ev();
Name_Map name_map__ZN3ccc8DD5x5y13E[] = {
  NSPAIR(_ZN3ccc8DD5x5y13C1Ev),
  NSPAIR(_ZN3ccc8DD5x5y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8DD5x5y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y13E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc8DD5x5y133efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x5y133efgEv,_ZTv0_n16_N3ccc8DD5x5y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x5y133efgEv,_ZThn4_N3ccc8DD5x5y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x5y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x5y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x5y133efgEv,_ZTv0_n16_N3ccc8DD5x5y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x5y13E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x5y13E[] = {
  {&(_ZTVN3ccc8DD5x5y13E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y13E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y13E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x5y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x5y13E[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x5y133efgEv,_ZTv0_n16_N3ccc8DD5x5y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x5y133efgEv,_ZThn4_N3ccc8DD5x5y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x5y13E = {  "_ZN3ccc8DD5x5y13E", // class name
  bases__ZN3ccc8DD5x5y13E, 2,
  &(vtc__ZN3ccc8DD5x5y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x5y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x5y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x5y13E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x5y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y14  : virtual ::ccc::AA5 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8CC5x5y143pqrEv
  ~CC5x5y14(); // tgen
  CC5x5y14(); // tgen
};
//SIG(1 _ZN3ccc8CC5x5y14E) C1{ VBC2{ v1 v2 v3} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC5x5y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x5y143pqrEv");}
ccc::CC5x5y14 ::~CC5x5y14(){ note_dtor("_ZN3ccc8CC5x5y14E", this);} // tgen
ccc::CC5x5y14 ::CC5x5y14(){ note_ctor("_ZN3ccc8CC5x5y14E", this);} // tgen
}
static void Test__ZN3ccc8CC5x5y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x5y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x5y14E, buf);
    ::ccc::CC5x5y14 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x5y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x5y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x5y14E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc8CC5x5y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x5y14E);
    dp->::ccc::CC5x5y14::~CC5x5y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x5y14E(Test__ZN3ccc8CC5x5y14E, "_ZN3ccc8CC5x5y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x5y14C1Ev();
extern void _ZN3ccc8CC5x5y14D1Ev();
Name_Map name_map__ZN3ccc8CC5x5y14E[] = {
  NSPAIR(_ZN3ccc8CC5x5y14C1Ev),
  NSPAIR(_ZN3ccc8CC5x5y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC5x5y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y14E[];
extern void _ZN3ccc8CC5x5y143pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x5y143pqrEv,_ZTv0_n12_N3ccc8CC5x5y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x5y143pqrEv,_ZThn4_N3ccc8CC5x5y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x5y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x5y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x5y143pqrEv,_ZTv0_n12_N3ccc8CC5x5y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x5y14E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x5y14E[] = {
  {&(_ZTVN3ccc8CC5x5y14E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x5y14E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x5y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x5y14E[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x5y143pqrEv,_ZTv0_n12_N3ccc8CC5x5y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x5y143pqrEv,_ZThn4_N3ccc8CC5x5y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x5y14E = {  "_ZN3ccc8CC5x5y14E", // class name
  bases__ZN3ccc8CC5x5y14E, 2,
  &(vtc__ZN3ccc8CC5x5y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x5y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x5y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x5y14E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x5y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y14  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8DD5x5y143pqrEv
  ~DD5x5y14(); // tgen
  DD5x5y14(); // tgen
};
//SIG(1 _ZN3ccc8DD5x5y14E) C1{ VBC2{ v1 v2 v3} VBC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::DD5x5y14 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x5y143pqrEv");}
ccc::DD5x5y14 ::~DD5x5y14(){ note_dtor("_ZN3ccc8DD5x5y14E", this);} // tgen
ccc::DD5x5y14 ::DD5x5y14(){ note_ctor("_ZN3ccc8DD5x5y14E", this);} // tgen
}
static void Test__ZN3ccc8DD5x5y14E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x5y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x5y14E, buf);
    ::ccc::DD5x5y14 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x5y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x5y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x5y14E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8DD5x5y14E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x5y14E);
    dp->::ccc::DD5x5y14::~DD5x5y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x5y14E(Test__ZN3ccc8DD5x5y14E, "_ZN3ccc8DD5x5y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x5y14C1Ev();
extern void _ZN3ccc8DD5x5y14D1Ev();
Name_Map name_map__ZN3ccc8DD5x5y14E[] = {
  NSPAIR(_ZN3ccc8DD5x5y14C1Ev),
  NSPAIR(_ZN3ccc8DD5x5y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8DD5x5y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y14E[];
extern void _ZN3ccc8DD5x5y143pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x5y143pqrEv,_ZTv0_n12_N3ccc8DD5x5y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x5y143pqrEv,_ZThn4_N3ccc8DD5x5y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x5y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x5y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x5y143pqrEv,_ZTv0_n12_N3ccc8DD5x5y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x5y14E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x5y14E[] = {
  {&(_ZTVN3ccc8DD5x5y14E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y14E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y14E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x5y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x5y14E[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x5y143pqrEv,_ZTv0_n12_N3ccc8DD5x5y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x5y143pqrEv,_ZThn4_N3ccc8DD5x5y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x5y14E = {  "_ZN3ccc8DD5x5y14E", // class name
  bases__ZN3ccc8DD5x5y14E, 2,
  &(vtc__ZN3ccc8DD5x5y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x5y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x5y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x5y14E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x5y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x5y15  : virtual ::ccc::AA5 , ::ccc::BB5 {
  ~CC5x5y15(); // tgen
  CC5x5y15(); // tgen
};
//SIG(1 _ZN3ccc8CC5x5y15E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC5x5y15 ::~CC5x5y15(){ note_dtor("_ZN3ccc8CC5x5y15E", this);} // tgen
ccc::CC5x5y15 ::CC5x5y15(){ note_ctor("_ZN3ccc8CC5x5y15E", this);} // tgen
}
static void Test__ZN3ccc8CC5x5y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x5y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x5y15E, buf);
    ::ccc::CC5x5y15 *dp, &lv = *(dp=new (buf) ::ccc::CC5x5y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x5y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x5y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x5y15E");
    check_base_class_offset(lv, (::ccc::BB5*), 0, "_ZN3ccc8CC5x5y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x5y15E);
    dp->::ccc::CC5x5y15::~CC5x5y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x5y15E(Test__ZN3ccc8CC5x5y15E, "_ZN3ccc8CC5x5y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x5y15C1Ev();
extern void _ZN3ccc8CC5x5y15D1Ev();
Name_Map name_map__ZN3ccc8CC5x5y15E[] = {
  NSPAIR(_ZN3ccc8CC5x5y15C1Ev),
  NSPAIR(_ZN3ccc8CC5x5y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC5x5y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y15E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x5y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x5y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x5y15E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x5y15E[] = {
  {&(_ZTVN3ccc8CC5x5y15E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x5y15E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x5y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x5y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x5y15E[];
Class_Descriptor cd__ZN3ccc8CC5x5y15E = {  "_ZN3ccc8CC5x5y15E", // class name
  bases__ZN3ccc8CC5x5y15E, 2,
  &(vtc__ZN3ccc8CC5x5y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x5y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x5y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x5y15E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x5y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x5y15  : virtual ::ccc::AA5 , virtual ::ccc::BB5 {
  ~DD5x5y15(); // tgen
  DD5x5y15(); // tgen
};
//SIG(1 _ZN3ccc8DD5x5y15E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::DD5x5y15 ::~DD5x5y15(){ note_dtor("_ZN3ccc8DD5x5y15E", this);} // tgen
ccc::DD5x5y15 ::DD5x5y15(){ note_ctor("_ZN3ccc8DD5x5y15E", this);} // tgen
}
static void Test__ZN3ccc8DD5x5y15E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x5y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x5y15E, buf);
    ::ccc::DD5x5y15 *dp, &lv = *(dp=new (buf) ::ccc::DD5x5y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x5y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x5y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x5y15E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8DD5x5y15E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x5y15E);
    dp->::ccc::DD5x5y15::~DD5x5y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x5y15E(Test__ZN3ccc8DD5x5y15E, "_ZN3ccc8DD5x5y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x5y15C1Ev();
extern void _ZN3ccc8DD5x5y15D1Ev();
Name_Map name_map__ZN3ccc8DD5x5y15E[] = {
  NSPAIR(_ZN3ccc8DD5x5y15C1Ev),
  NSPAIR(_ZN3ccc8DD5x5y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8DD5x5y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y15E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x5y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x5y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x5y15E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x5y15E[] = {
  {&(_ZTVN3ccc8DD5x5y15E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y15E[7]),  7,18},
  {&(_ZTVN3ccc8DD5x5y15E[15]),  15,18},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x5y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x5y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x5y15E[];
Class_Descriptor cd__ZN3ccc8DD5x5y15E = {  "_ZN3ccc8DD5x5y15E", // class name
  bases__ZN3ccc8DD5x5y15E, 2,
  &(vtc__ZN3ccc8DD5x5y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x5y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x5y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x5y15E),18, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x5y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y0  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC5x6y03abcEv
  virtual void  efg(); // _ZN3ccc7CC5x6y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x6y03pqrEv
  ~CC5x6y0(); // tgen
  CC5x6y0(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y0E) C1{ VBC2{ v3 v2 v1} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x6y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y03abcEv");}
void  ccc::CC5x6y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y03efgEv");}
void  ccc::CC5x6y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y03pqrEv");}
ccc::CC5x6y0 ::~CC5x6y0(){ note_dtor("_ZN3ccc7CC5x6y0E", this);} // tgen
ccc::CC5x6y0 ::CC5x6y0(){ note_ctor("_ZN3ccc7CC5x6y0E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y0E, buf);
    ::ccc::CC5x6y0 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y0E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y0E);
    dp->::ccc::CC5x6y0::~CC5x6y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y0E(Test__ZN3ccc7CC5x6y0E, "_ZN3ccc7CC5x6y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y0C1Ev();
extern void _ZN3ccc7CC5x6y0D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y0E[] = {
  NSPAIR(_ZN3ccc7CC5x6y0C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y0E[];
extern void _ZN3ccc7CC5x6y03abcEv();
extern void _ZN3ccc7CC5x6y03efgEv();
extern void _ZN3ccc7CC5x6y03pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y03pqrEv,_ZTv0_n12_N3ccc7CC5x6y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y03pqrEv,_ZThn4_N3ccc7CC5x6y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y03efgEv,_ZTv0_n16_N3ccc7CC5x6y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y03efgEv,_ZThn4_N3ccc7CC5x6y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y03abcEv,_ZTv0_n20_N3ccc7CC5x6y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y03abcEv,_ZThn4_N3ccc7CC5x6y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y03pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y03pqrEv,_ZTv0_n12_N3ccc7CC5x6y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y03efgEv,_ZTv0_n16_N3ccc7CC5x6y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y03abcEv,_ZTv0_n20_N3ccc7CC5x6y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y0E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y0E[] = {
  {&(_ZTVN3ccc7CC5x6y0E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y0E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y0E[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y03abcEv,_ZTv0_n20_N3ccc7CC5x6y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y03abcEv,_ZThn4_N3ccc7CC5x6y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y03efgEv,_ZTv0_n16_N3ccc7CC5x6y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y03efgEv,_ZThn4_N3ccc7CC5x6y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y03pqrEv,_ZTv0_n12_N3ccc7CC5x6y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y03pqrEv,_ZThn4_N3ccc7CC5x6y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y0E = {  "_ZN3ccc7CC5x6y0E", // class name
  bases__ZN3ccc7CC5x6y0E, 2,
  &(vtc__ZN3ccc7CC5x6y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y0E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y0  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7DD5x6y03abcEv
  virtual void  efg(); // _ZN3ccc7DD5x6y03efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x6y03pqrEv
  ~DD5x6y0(); // tgen
  DD5x6y0(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y0E) C1{ VBC2{ v3 v2 v1} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x6y0 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y03abcEv");}
void  ccc::DD5x6y0 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y03efgEv");}
void  ccc::DD5x6y0 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y03pqrEv");}
ccc::DD5x6y0 ::~DD5x6y0(){ note_dtor("_ZN3ccc7DD5x6y0E", this);} // tgen
ccc::DD5x6y0 ::DD5x6y0(){ note_ctor("_ZN3ccc7DD5x6y0E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y0E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y0E, buf);
    ::ccc::DD5x6y0 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y0E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y0E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y0E);
    dp->::ccc::DD5x6y0::~DD5x6y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y0E(Test__ZN3ccc7DD5x6y0E, "_ZN3ccc7DD5x6y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y0C1Ev();
extern void _ZN3ccc7DD5x6y0D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y0E[] = {
  NSPAIR(_ZN3ccc7DD5x6y0C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y0E[];
extern void _ZN3ccc7DD5x6y03pqrEv();
extern void _ZN3ccc7DD5x6y03efgEv();
extern void _ZN3ccc7DD5x6y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y03abcEv,_ZTv0_n12_N3ccc7DD5x6y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y03abcEv,_ZThn4_N3ccc7DD5x6y03abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y03efgEv,_ZTv0_n16_N3ccc7DD5x6y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y03efgEv,_ZThn4_N3ccc7DD5x6y03efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y03abcEv,_ZTv0_n12_N3ccc7DD5x6y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y03efgEv,_ZTv0_n16_N3ccc7DD5x6y03efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y0E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y0E[] = {
  {&(_ZTVN3ccc7DD5x6y0E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y0E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y0E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y0E[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y03efgEv,_ZTv0_n16_N3ccc7DD5x6y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y03efgEv,_ZThn4_N3ccc7DD5x6y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y03abcEv,_ZTv0_n12_N3ccc7DD5x6y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y03abcEv,_ZThn4_N3ccc7DD5x6y03abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y0E = {  "_ZN3ccc7DD5x6y0E", // class name
  bases__ZN3ccc7DD5x6y0E, 2,
  &(vtc__ZN3ccc7DD5x6y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y0E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y1  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC5x6y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x6y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x6y13efgEv
  ~CC5x6y1(); // tgen
  CC5x6y1(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y1E) C1{ VBC2{ v2 v3 v1} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x6y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y13abcEv");}
void  ccc::CC5x6y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y13pqrEv");}
void  ccc::CC5x6y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y13efgEv");}
ccc::CC5x6y1 ::~CC5x6y1(){ note_dtor("_ZN3ccc7CC5x6y1E", this);} // tgen
ccc::CC5x6y1 ::CC5x6y1(){ note_ctor("_ZN3ccc7CC5x6y1E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y1E, buf);
    ::ccc::CC5x6y1 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y1E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y1E);
    dp->::ccc::CC5x6y1::~CC5x6y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y1E(Test__ZN3ccc7CC5x6y1E, "_ZN3ccc7CC5x6y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y1C1Ev();
extern void _ZN3ccc7CC5x6y1D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y1E[] = {
  NSPAIR(_ZN3ccc7CC5x6y1C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y1E[];
extern void _ZN3ccc7CC5x6y13abcEv();
extern void _ZN3ccc7CC5x6y13efgEv();
extern void _ZN3ccc7CC5x6y13pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y13pqrEv,_ZTv0_n12_N3ccc7CC5x6y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y13pqrEv,_ZThn4_N3ccc7CC5x6y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y13efgEv,_ZTv0_n16_N3ccc7CC5x6y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y13efgEv,_ZThn4_N3ccc7CC5x6y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y13abcEv,_ZTv0_n20_N3ccc7CC5x6y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y13abcEv,_ZThn4_N3ccc7CC5x6y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y13pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y13pqrEv,_ZTv0_n12_N3ccc7CC5x6y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y13efgEv,_ZTv0_n16_N3ccc7CC5x6y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y13abcEv,_ZTv0_n20_N3ccc7CC5x6y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y1E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y1E[] = {
  {&(_ZTVN3ccc7CC5x6y1E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y1E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y1E[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y13abcEv,_ZTv0_n20_N3ccc7CC5x6y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y13abcEv,_ZThn4_N3ccc7CC5x6y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y13efgEv,_ZTv0_n16_N3ccc7CC5x6y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y13efgEv,_ZThn4_N3ccc7CC5x6y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y13pqrEv,_ZTv0_n12_N3ccc7CC5x6y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y13pqrEv,_ZThn4_N3ccc7CC5x6y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y1E = {  "_ZN3ccc7CC5x6y1E", // class name
  bases__ZN3ccc7CC5x6y1E, 2,
  &(vtc__ZN3ccc7CC5x6y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y1E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y1  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7DD5x6y13abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x6y13pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x6y13efgEv
  ~DD5x6y1(); // tgen
  DD5x6y1(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y1E) C1{ VBC2{ v2 v3 v1} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x6y1 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y13abcEv");}
void  ccc::DD5x6y1 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y13pqrEv");}
void  ccc::DD5x6y1 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y13efgEv");}
ccc::DD5x6y1 ::~DD5x6y1(){ note_dtor("_ZN3ccc7DD5x6y1E", this);} // tgen
ccc::DD5x6y1 ::DD5x6y1(){ note_ctor("_ZN3ccc7DD5x6y1E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y1E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y1E, buf);
    ::ccc::DD5x6y1 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y1E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y1E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y1E);
    dp->::ccc::DD5x6y1::~DD5x6y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y1E(Test__ZN3ccc7DD5x6y1E, "_ZN3ccc7DD5x6y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y1C1Ev();
extern void _ZN3ccc7DD5x6y1D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y1E[] = {
  NSPAIR(_ZN3ccc7DD5x6y1C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y1E[];
extern void _ZN3ccc7DD5x6y13pqrEv();
extern void _ZN3ccc7DD5x6y13efgEv();
extern void _ZN3ccc7DD5x6y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y13abcEv,_ZTv0_n12_N3ccc7DD5x6y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y13abcEv,_ZThn4_N3ccc7DD5x6y13abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y13efgEv,_ZTv0_n16_N3ccc7DD5x6y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y13efgEv,_ZThn4_N3ccc7DD5x6y13efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y13abcEv,_ZTv0_n12_N3ccc7DD5x6y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y13efgEv,_ZTv0_n16_N3ccc7DD5x6y13efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y1E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y1E[] = {
  {&(_ZTVN3ccc7DD5x6y1E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y1E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y1E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y1E[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y13efgEv,_ZTv0_n16_N3ccc7DD5x6y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y13efgEv,_ZThn4_N3ccc7DD5x6y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y13abcEv,_ZTv0_n12_N3ccc7DD5x6y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y13abcEv,_ZThn4_N3ccc7DD5x6y13abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y1E = {  "_ZN3ccc7DD5x6y1E", // class name
  bases__ZN3ccc7DD5x6y1E, 2,
  &(vtc__ZN3ccc7DD5x6y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y1E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y2  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC5x6y23efgEv
  virtual void  abc(); // _ZN3ccc7CC5x6y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x6y23pqrEv
  ~CC5x6y2(); // tgen
  CC5x6y2(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y2E) C1{ VBC2{ v3 v1 v2} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x6y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y23efgEv");}
void  ccc::CC5x6y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y23abcEv");}
void  ccc::CC5x6y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y23pqrEv");}
ccc::CC5x6y2 ::~CC5x6y2(){ note_dtor("_ZN3ccc7CC5x6y2E", this);} // tgen
ccc::CC5x6y2 ::CC5x6y2(){ note_ctor("_ZN3ccc7CC5x6y2E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y2E, buf);
    ::ccc::CC5x6y2 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y2E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y2E);
    dp->::ccc::CC5x6y2::~CC5x6y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y2E(Test__ZN3ccc7CC5x6y2E, "_ZN3ccc7CC5x6y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y2C1Ev();
extern void _ZN3ccc7CC5x6y2D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y2E[] = {
  NSPAIR(_ZN3ccc7CC5x6y2C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y2E[];
extern void _ZN3ccc7CC5x6y23abcEv();
extern void _ZN3ccc7CC5x6y23efgEv();
extern void _ZN3ccc7CC5x6y23pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y23pqrEv,_ZTv0_n12_N3ccc7CC5x6y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y23pqrEv,_ZThn4_N3ccc7CC5x6y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y23efgEv,_ZTv0_n16_N3ccc7CC5x6y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y23efgEv,_ZThn4_N3ccc7CC5x6y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y23abcEv,_ZTv0_n20_N3ccc7CC5x6y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y23abcEv,_ZThn4_N3ccc7CC5x6y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y23pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y23pqrEv,_ZTv0_n12_N3ccc7CC5x6y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y23efgEv,_ZTv0_n16_N3ccc7CC5x6y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y23abcEv,_ZTv0_n20_N3ccc7CC5x6y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y2E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y2E[] = {
  {&(_ZTVN3ccc7CC5x6y2E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y2E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y2E[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y23abcEv,_ZTv0_n20_N3ccc7CC5x6y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y23abcEv,_ZThn4_N3ccc7CC5x6y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y23efgEv,_ZTv0_n16_N3ccc7CC5x6y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y23efgEv,_ZThn4_N3ccc7CC5x6y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y23pqrEv,_ZTv0_n12_N3ccc7CC5x6y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y23pqrEv,_ZThn4_N3ccc7CC5x6y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y2E = {  "_ZN3ccc7CC5x6y2E", // class name
  bases__ZN3ccc7CC5x6y2E, 2,
  &(vtc__ZN3ccc7CC5x6y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y2E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y2  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7DD5x6y23efgEv
  virtual void  abc(); // _ZN3ccc7DD5x6y23abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x6y23pqrEv
  ~DD5x6y2(); // tgen
  DD5x6y2(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y2E) C1{ VBC2{ v3 v1 v2} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x6y2 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y23efgEv");}
void  ccc::DD5x6y2 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y23abcEv");}
void  ccc::DD5x6y2 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y23pqrEv");}
ccc::DD5x6y2 ::~DD5x6y2(){ note_dtor("_ZN3ccc7DD5x6y2E", this);} // tgen
ccc::DD5x6y2 ::DD5x6y2(){ note_ctor("_ZN3ccc7DD5x6y2E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y2E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y2E, buf);
    ::ccc::DD5x6y2 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y2E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y2E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y2E);
    dp->::ccc::DD5x6y2::~DD5x6y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y2E(Test__ZN3ccc7DD5x6y2E, "_ZN3ccc7DD5x6y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y2C1Ev();
extern void _ZN3ccc7DD5x6y2D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y2E[] = {
  NSPAIR(_ZN3ccc7DD5x6y2C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y2E[];
extern void _ZN3ccc7DD5x6y23pqrEv();
extern void _ZN3ccc7DD5x6y23efgEv();
extern void _ZN3ccc7DD5x6y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y23abcEv,_ZTv0_n12_N3ccc7DD5x6y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y23abcEv,_ZThn4_N3ccc7DD5x6y23abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y23efgEv,_ZTv0_n16_N3ccc7DD5x6y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y23efgEv,_ZThn4_N3ccc7DD5x6y23efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y23abcEv,_ZTv0_n12_N3ccc7DD5x6y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y23efgEv,_ZTv0_n16_N3ccc7DD5x6y23efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y2E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y2E[] = {
  {&(_ZTVN3ccc7DD5x6y2E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y2E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y2E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y2E[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y23efgEv,_ZTv0_n16_N3ccc7DD5x6y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y23efgEv,_ZThn4_N3ccc7DD5x6y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y23abcEv,_ZTv0_n12_N3ccc7DD5x6y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y23abcEv,_ZThn4_N3ccc7DD5x6y23abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y2E = {  "_ZN3ccc7DD5x6y2E", // class name
  bases__ZN3ccc7DD5x6y2E, 2,
  &(vtc__ZN3ccc7DD5x6y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y2E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y3  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC5x6y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x6y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x6y33abcEv
  ~CC5x6y3(); // tgen
  CC5x6y3(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y3E) C1{ VBC2{ v2 v1 v3} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x6y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y33efgEv");}
void  ccc::CC5x6y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y33pqrEv");}
void  ccc::CC5x6y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y33abcEv");}
ccc::CC5x6y3 ::~CC5x6y3(){ note_dtor("_ZN3ccc7CC5x6y3E", this);} // tgen
ccc::CC5x6y3 ::CC5x6y3(){ note_ctor("_ZN3ccc7CC5x6y3E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y3E, buf);
    ::ccc::CC5x6y3 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y3E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y3E);
    dp->::ccc::CC5x6y3::~CC5x6y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y3E(Test__ZN3ccc7CC5x6y3E, "_ZN3ccc7CC5x6y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y3C1Ev();
extern void _ZN3ccc7CC5x6y3D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y3E[] = {
  NSPAIR(_ZN3ccc7CC5x6y3C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y3E[];
extern void _ZN3ccc7CC5x6y33abcEv();
extern void _ZN3ccc7CC5x6y33efgEv();
extern void _ZN3ccc7CC5x6y33pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y33pqrEv,_ZTv0_n12_N3ccc7CC5x6y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y33pqrEv,_ZThn4_N3ccc7CC5x6y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y33efgEv,_ZTv0_n16_N3ccc7CC5x6y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y33efgEv,_ZThn4_N3ccc7CC5x6y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y33abcEv,_ZTv0_n20_N3ccc7CC5x6y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y33abcEv,_ZThn4_N3ccc7CC5x6y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y33pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y33pqrEv,_ZTv0_n12_N3ccc7CC5x6y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y33efgEv,_ZTv0_n16_N3ccc7CC5x6y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y33abcEv,_ZTv0_n20_N3ccc7CC5x6y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y3E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y3E[] = {
  {&(_ZTVN3ccc7CC5x6y3E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y3E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y3E[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y33abcEv,_ZTv0_n20_N3ccc7CC5x6y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y33abcEv,_ZThn4_N3ccc7CC5x6y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y33efgEv,_ZTv0_n16_N3ccc7CC5x6y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y33efgEv,_ZThn4_N3ccc7CC5x6y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y33pqrEv,_ZTv0_n12_N3ccc7CC5x6y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y33pqrEv,_ZThn4_N3ccc7CC5x6y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y3E = {  "_ZN3ccc7CC5x6y3E", // class name
  bases__ZN3ccc7CC5x6y3E, 2,
  &(vtc__ZN3ccc7CC5x6y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y3E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y3  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7DD5x6y33efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x6y33pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x6y33abcEv
  ~DD5x6y3(); // tgen
  DD5x6y3(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y3E) C1{ VBC2{ v2 v1 v3} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x6y3 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y33efgEv");}
void  ccc::DD5x6y3 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y33pqrEv");}
void  ccc::DD5x6y3 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y33abcEv");}
ccc::DD5x6y3 ::~DD5x6y3(){ note_dtor("_ZN3ccc7DD5x6y3E", this);} // tgen
ccc::DD5x6y3 ::DD5x6y3(){ note_ctor("_ZN3ccc7DD5x6y3E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y3E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y3E, buf);
    ::ccc::DD5x6y3 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y3E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y3E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y3E);
    dp->::ccc::DD5x6y3::~DD5x6y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y3E(Test__ZN3ccc7DD5x6y3E, "_ZN3ccc7DD5x6y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y3C1Ev();
extern void _ZN3ccc7DD5x6y3D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y3E[] = {
  NSPAIR(_ZN3ccc7DD5x6y3C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y3E[];
extern void _ZN3ccc7DD5x6y33pqrEv();
extern void _ZN3ccc7DD5x6y33efgEv();
extern void _ZN3ccc7DD5x6y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y33abcEv,_ZTv0_n12_N3ccc7DD5x6y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y33abcEv,_ZThn4_N3ccc7DD5x6y33abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y33efgEv,_ZTv0_n16_N3ccc7DD5x6y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y33efgEv,_ZThn4_N3ccc7DD5x6y33efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y33abcEv,_ZTv0_n12_N3ccc7DD5x6y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y33efgEv,_ZTv0_n16_N3ccc7DD5x6y33efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y3E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y3E[] = {
  {&(_ZTVN3ccc7DD5x6y3E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y3E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y3E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y3E[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y33efgEv,_ZTv0_n16_N3ccc7DD5x6y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y33efgEv,_ZThn4_N3ccc7DD5x6y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y33abcEv,_ZTv0_n12_N3ccc7DD5x6y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y33abcEv,_ZThn4_N3ccc7DD5x6y33abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y3E = {  "_ZN3ccc7DD5x6y3E", // class name
  bases__ZN3ccc7DD5x6y3E, 2,
  &(vtc__ZN3ccc7DD5x6y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y3E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y4  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc7CC5x6y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x6y43abcEv
  virtual void  efg(); // _ZN3ccc7CC5x6y43efgEv
  ~CC5x6y4(); // tgen
  CC5x6y4(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y4E) C1{ VBC2{ v1 v3 v2} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x6y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y43pqrEv");}
void  ccc::CC5x6y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y43abcEv");}
void  ccc::CC5x6y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y43efgEv");}
ccc::CC5x6y4 ::~CC5x6y4(){ note_dtor("_ZN3ccc7CC5x6y4E", this);} // tgen
ccc::CC5x6y4 ::CC5x6y4(){ note_ctor("_ZN3ccc7CC5x6y4E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y4E, buf);
    ::ccc::CC5x6y4 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y4E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y4E);
    dp->::ccc::CC5x6y4::~CC5x6y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y4E(Test__ZN3ccc7CC5x6y4E, "_ZN3ccc7CC5x6y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y4C1Ev();
extern void _ZN3ccc7CC5x6y4D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y4E[] = {
  NSPAIR(_ZN3ccc7CC5x6y4C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y4E[];
extern void _ZN3ccc7CC5x6y43abcEv();
extern void _ZN3ccc7CC5x6y43efgEv();
extern void _ZN3ccc7CC5x6y43pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y43pqrEv,_ZTv0_n12_N3ccc7CC5x6y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y43pqrEv,_ZThn4_N3ccc7CC5x6y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y43efgEv,_ZTv0_n16_N3ccc7CC5x6y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y43efgEv,_ZThn4_N3ccc7CC5x6y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y43abcEv,_ZTv0_n20_N3ccc7CC5x6y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y43abcEv,_ZThn4_N3ccc7CC5x6y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y43pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y43pqrEv,_ZTv0_n12_N3ccc7CC5x6y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y43efgEv,_ZTv0_n16_N3ccc7CC5x6y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y43abcEv,_ZTv0_n20_N3ccc7CC5x6y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y4E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y4E[] = {
  {&(_ZTVN3ccc7CC5x6y4E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y4E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y4E[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y43abcEv,_ZTv0_n20_N3ccc7CC5x6y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y43abcEv,_ZThn4_N3ccc7CC5x6y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y43efgEv,_ZTv0_n16_N3ccc7CC5x6y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y43efgEv,_ZThn4_N3ccc7CC5x6y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y43pqrEv,_ZTv0_n12_N3ccc7CC5x6y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y43pqrEv,_ZThn4_N3ccc7CC5x6y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y4E = {  "_ZN3ccc7CC5x6y4E", // class name
  bases__ZN3ccc7CC5x6y4E, 2,
  &(vtc__ZN3ccc7CC5x6y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y4E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y4  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc7DD5x6y43pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x6y43abcEv
  virtual void  efg(); // _ZN3ccc7DD5x6y43efgEv
  ~DD5x6y4(); // tgen
  DD5x6y4(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y4E) C1{ VBC2{ v1 v3 v2} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x6y4 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y43pqrEv");}
void  ccc::DD5x6y4 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y43abcEv");}
void  ccc::DD5x6y4 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y43efgEv");}
ccc::DD5x6y4 ::~DD5x6y4(){ note_dtor("_ZN3ccc7DD5x6y4E", this);} // tgen
ccc::DD5x6y4 ::DD5x6y4(){ note_ctor("_ZN3ccc7DD5x6y4E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y4E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y4E, buf);
    ::ccc::DD5x6y4 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y4E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y4E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y4E);
    dp->::ccc::DD5x6y4::~DD5x6y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y4E(Test__ZN3ccc7DD5x6y4E, "_ZN3ccc7DD5x6y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y4C1Ev();
extern void _ZN3ccc7DD5x6y4D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y4E[] = {
  NSPAIR(_ZN3ccc7DD5x6y4C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y4E[];
extern void _ZN3ccc7DD5x6y43pqrEv();
extern void _ZN3ccc7DD5x6y43efgEv();
extern void _ZN3ccc7DD5x6y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y43abcEv,_ZTv0_n12_N3ccc7DD5x6y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y43abcEv,_ZThn4_N3ccc7DD5x6y43abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y43efgEv,_ZTv0_n16_N3ccc7DD5x6y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y43efgEv,_ZThn4_N3ccc7DD5x6y43efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y43abcEv,_ZTv0_n12_N3ccc7DD5x6y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y43efgEv,_ZTv0_n16_N3ccc7DD5x6y43efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y4E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y4E[] = {
  {&(_ZTVN3ccc7DD5x6y4E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y4E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y4E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y4E[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y43efgEv,_ZTv0_n16_N3ccc7DD5x6y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y43efgEv,_ZThn4_N3ccc7DD5x6y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y43abcEv,_ZTv0_n12_N3ccc7DD5x6y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y43abcEv,_ZThn4_N3ccc7DD5x6y43abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y4E = {  "_ZN3ccc7DD5x6y4E", // class name
  bases__ZN3ccc7DD5x6y4E, 2,
  &(vtc__ZN3ccc7DD5x6y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y4E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y5  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc7CC5x6y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x6y53efgEv
  virtual void  abc(); // _ZN3ccc7CC5x6y53abcEv
  ~CC5x6y5(); // tgen
  CC5x6y5(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y5E) C1{ VBC2{ v1 v2 v3} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x6y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y53pqrEv");}
void  ccc::CC5x6y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y53efgEv");}
void  ccc::CC5x6y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y53abcEv");}
ccc::CC5x6y5 ::~CC5x6y5(){ note_dtor("_ZN3ccc7CC5x6y5E", this);} // tgen
ccc::CC5x6y5 ::CC5x6y5(){ note_ctor("_ZN3ccc7CC5x6y5E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y5E, buf);
    ::ccc::CC5x6y5 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y5E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y5E);
    dp->::ccc::CC5x6y5::~CC5x6y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y5E(Test__ZN3ccc7CC5x6y5E, "_ZN3ccc7CC5x6y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y5C1Ev();
extern void _ZN3ccc7CC5x6y5D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y5E[] = {
  NSPAIR(_ZN3ccc7CC5x6y5C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y5E[];
extern void _ZN3ccc7CC5x6y53abcEv();
extern void _ZN3ccc7CC5x6y53efgEv();
extern void _ZN3ccc7CC5x6y53pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y53pqrEv,_ZTv0_n12_N3ccc7CC5x6y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y53pqrEv,_ZThn4_N3ccc7CC5x6y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y53efgEv,_ZTv0_n16_N3ccc7CC5x6y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y53efgEv,_ZThn4_N3ccc7CC5x6y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y53abcEv,_ZTv0_n20_N3ccc7CC5x6y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y53abcEv,_ZThn4_N3ccc7CC5x6y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y53pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y53pqrEv,_ZTv0_n12_N3ccc7CC5x6y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y53efgEv,_ZTv0_n16_N3ccc7CC5x6y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y53abcEv,_ZTv0_n20_N3ccc7CC5x6y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y5E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y5E[] = {
  {&(_ZTVN3ccc7CC5x6y5E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y5E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y5E[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y53abcEv,_ZTv0_n20_N3ccc7CC5x6y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y53abcEv,_ZThn4_N3ccc7CC5x6y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y53efgEv,_ZTv0_n16_N3ccc7CC5x6y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y53efgEv,_ZThn4_N3ccc7CC5x6y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y53pqrEv,_ZTv0_n12_N3ccc7CC5x6y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y53pqrEv,_ZThn4_N3ccc7CC5x6y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y5E = {  "_ZN3ccc7CC5x6y5E", // class name
  bases__ZN3ccc7CC5x6y5E, 2,
  &(vtc__ZN3ccc7CC5x6y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y5E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y5  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc7DD5x6y53pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x6y53efgEv
  virtual void  abc(); // _ZN3ccc7DD5x6y53abcEv
  ~DD5x6y5(); // tgen
  DD5x6y5(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y5E) C1{ VBC2{ v1 v2 v3} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x6y5 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y53pqrEv");}
void  ccc::DD5x6y5 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y53efgEv");}
void  ccc::DD5x6y5 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y53abcEv");}
ccc::DD5x6y5 ::~DD5x6y5(){ note_dtor("_ZN3ccc7DD5x6y5E", this);} // tgen
ccc::DD5x6y5 ::DD5x6y5(){ note_ctor("_ZN3ccc7DD5x6y5E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y5E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y5E, buf);
    ::ccc::DD5x6y5 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y5E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y5E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y5E);
    dp->::ccc::DD5x6y5::~DD5x6y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y5E(Test__ZN3ccc7DD5x6y5E, "_ZN3ccc7DD5x6y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y5C1Ev();
extern void _ZN3ccc7DD5x6y5D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y5E[] = {
  NSPAIR(_ZN3ccc7DD5x6y5C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y5E[];
extern void _ZN3ccc7DD5x6y53pqrEv();
extern void _ZN3ccc7DD5x6y53efgEv();
extern void _ZN3ccc7DD5x6y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y53abcEv,_ZTv0_n12_N3ccc7DD5x6y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y53abcEv,_ZThn4_N3ccc7DD5x6y53abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y53efgEv,_ZTv0_n16_N3ccc7DD5x6y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y53efgEv,_ZThn4_N3ccc7DD5x6y53efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y53abcEv,_ZTv0_n12_N3ccc7DD5x6y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y53efgEv,_ZTv0_n16_N3ccc7DD5x6y53efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y5E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y5E[] = {
  {&(_ZTVN3ccc7DD5x6y5E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y5E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y5E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y5E[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y53efgEv,_ZTv0_n16_N3ccc7DD5x6y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y53efgEv,_ZThn4_N3ccc7DD5x6y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y53abcEv,_ZTv0_n12_N3ccc7DD5x6y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y53abcEv,_ZThn4_N3ccc7DD5x6y53abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y5E = {  "_ZN3ccc7DD5x6y5E", // class name
  bases__ZN3ccc7DD5x6y5E, 2,
  &(vtc__ZN3ccc7DD5x6y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y5E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y6  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC5x6y63abcEv
  virtual void  efg(); // _ZN3ccc7CC5x6y63efgEv
  ~CC5x6y6(); // tgen
  CC5x6y6(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y6E) C1{ VBC2{ v3 v2 v1} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x6y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y63abcEv");}
void  ccc::CC5x6y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y63efgEv");}
ccc::CC5x6y6 ::~CC5x6y6(){ note_dtor("_ZN3ccc7CC5x6y6E", this);} // tgen
ccc::CC5x6y6 ::CC5x6y6(){ note_ctor("_ZN3ccc7CC5x6y6E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y6E, buf);
    ::ccc::CC5x6y6 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y6E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y6E);
    dp->::ccc::CC5x6y6::~CC5x6y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y6E(Test__ZN3ccc7CC5x6y6E, "_ZN3ccc7CC5x6y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y6C1Ev();
extern void _ZN3ccc7CC5x6y6D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y6E[] = {
  NSPAIR(_ZN3ccc7CC5x6y6C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y6E[];
extern void _ZN3ccc7CC5x6y63abcEv();
extern void _ZN3ccc7CC5x6y63efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y63efgEv,_ZTv0_n16_N3ccc7CC5x6y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y63efgEv,_ZThn4_N3ccc7CC5x6y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y63abcEv,_ZTv0_n20_N3ccc7CC5x6y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y63abcEv,_ZThn4_N3ccc7CC5x6y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y63efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y63efgEv,_ZTv0_n16_N3ccc7CC5x6y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y63abcEv,_ZTv0_n20_N3ccc7CC5x6y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y6E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y6E[] = {
  {&(_ZTVN3ccc7CC5x6y6E[3]),  3,13},
  {&(_ZTVN3ccc7CC5x6y6E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y6E[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y63abcEv,_ZTv0_n20_N3ccc7CC5x6y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y63abcEv,_ZThn4_N3ccc7CC5x6y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y63efgEv,_ZTv0_n16_N3ccc7CC5x6y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y63efgEv,_ZThn4_N3ccc7CC5x6y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y6E = {  "_ZN3ccc7CC5x6y6E", // class name
  bases__ZN3ccc7CC5x6y6E, 2,
  &(vtc__ZN3ccc7CC5x6y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y6E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y6  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7DD5x6y63abcEv
  virtual void  efg(); // _ZN3ccc7DD5x6y63efgEv
  ~DD5x6y6(); // tgen
  DD5x6y6(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y6E) C1{ VBC2{ v3 v2 v1} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x6y6 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y63abcEv");}
void  ccc::DD5x6y6 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y63efgEv");}
ccc::DD5x6y6 ::~DD5x6y6(){ note_dtor("_ZN3ccc7DD5x6y6E", this);} // tgen
ccc::DD5x6y6 ::DD5x6y6(){ note_ctor("_ZN3ccc7DD5x6y6E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y6E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y6E, buf);
    ::ccc::DD5x6y6 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y6E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y6E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y6E);
    dp->::ccc::DD5x6y6::~DD5x6y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y6E(Test__ZN3ccc7DD5x6y6E, "_ZN3ccc7DD5x6y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y6C1Ev();
extern void _ZN3ccc7DD5x6y6D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y6E[] = {
  NSPAIR(_ZN3ccc7DD5x6y6C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y6E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x6y63efgEv();
extern void _ZN3ccc7DD5x6y63abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y63abcEv,_ZTv0_n12_N3ccc7DD5x6y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y63abcEv,_ZThn4_N3ccc7DD5x6y63abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y63efgEv,_ZTv0_n16_N3ccc7DD5x6y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y63efgEv,_ZThn4_N3ccc7DD5x6y63efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y63abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y63abcEv,_ZTv0_n12_N3ccc7DD5x6y63abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y63efgEv,_ZTv0_n16_N3ccc7DD5x6y63efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y6E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y6E[] = {
  {&(_ZTVN3ccc7DD5x6y6E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y6E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y6E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y6E[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y63efgEv,_ZTv0_n16_N3ccc7DD5x6y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y63efgEv,_ZThn4_N3ccc7DD5x6y63efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y63abcEv,_ZTv0_n12_N3ccc7DD5x6y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y63abcEv,_ZThn4_N3ccc7DD5x6y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y6E = {  "_ZN3ccc7DD5x6y6E", // class name
  bases__ZN3ccc7DD5x6y6E, 2,
  &(vtc__ZN3ccc7DD5x6y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y6E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y7  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC5x6y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x6y73pqrEv
  ~CC5x6y7(); // tgen
  CC5x6y7(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y7E) C1{ VBC2{ v2 v3 v1} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x6y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y73abcEv");}
void  ccc::CC5x6y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y73pqrEv");}
ccc::CC5x6y7 ::~CC5x6y7(){ note_dtor("_ZN3ccc7CC5x6y7E", this);} // tgen
ccc::CC5x6y7 ::CC5x6y7(){ note_ctor("_ZN3ccc7CC5x6y7E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y7E, buf);
    ::ccc::CC5x6y7 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y7E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y7E);
    dp->::ccc::CC5x6y7::~CC5x6y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y7E(Test__ZN3ccc7CC5x6y7E, "_ZN3ccc7CC5x6y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y7C1Ev();
extern void _ZN3ccc7CC5x6y7D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y7E[] = {
  NSPAIR(_ZN3ccc7CC5x6y7C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y7E[];
extern void _ZN3ccc7CC5x6y73abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc7CC5x6y73pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y73pqrEv,_ZTv0_n12_N3ccc7CC5x6y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y73pqrEv,_ZThn4_N3ccc7CC5x6y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y73abcEv,_ZTv0_n20_N3ccc7CC5x6y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y73abcEv,_ZThn4_N3ccc7CC5x6y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y73pqrEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y73pqrEv,_ZTv0_n12_N3ccc7CC5x6y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y73abcEv,_ZTv0_n20_N3ccc7CC5x6y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y7E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y7E[] = {
  {&(_ZTVN3ccc7CC5x6y7E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y7E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y7E[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y73abcEv,_ZTv0_n20_N3ccc7CC5x6y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y73abcEv,_ZThn4_N3ccc7CC5x6y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y73pqrEv,_ZTv0_n12_N3ccc7CC5x6y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y73pqrEv,_ZThn4_N3ccc7CC5x6y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y7E = {  "_ZN3ccc7CC5x6y7E", // class name
  bases__ZN3ccc7CC5x6y7E, 2,
  &(vtc__ZN3ccc7CC5x6y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y7E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y7  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7DD5x6y73abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x6y73pqrEv
  ~DD5x6y7(); // tgen
  DD5x6y7(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y7E) C1{ VBC2{ v2 v3 v1} VBC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x6y7 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y73abcEv");}
void  ccc::DD5x6y7 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y73pqrEv");}
ccc::DD5x6y7 ::~DD5x6y7(){ note_dtor("_ZN3ccc7DD5x6y7E", this);} // tgen
ccc::DD5x6y7 ::DD5x6y7(){ note_ctor("_ZN3ccc7DD5x6y7E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y7E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y7E, buf);
    ::ccc::DD5x6y7 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y7E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y7E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y7E);
    dp->::ccc::DD5x6y7::~DD5x6y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y7E(Test__ZN3ccc7DD5x6y7E, "_ZN3ccc7DD5x6y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y7C1Ev();
extern void _ZN3ccc7DD5x6y7D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y7E[] = {
  NSPAIR(_ZN3ccc7DD5x6y7C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y7E[];
extern void _ZN3ccc7DD5x6y73pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc7DD5x6y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y73abcEv,_ZTv0_n12_N3ccc7DD5x6y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y73abcEv,_ZThn4_N3ccc7DD5x6y73abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y73abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y73abcEv,_ZTv0_n12_N3ccc7DD5x6y73abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y7E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y7E[] = {
  {&(_ZTVN3ccc7DD5x6y7E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y7E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y7E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y7E[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y73abcEv,_ZTv0_n12_N3ccc7DD5x6y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y73abcEv,_ZThn4_N3ccc7DD5x6y73abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y7E = {  "_ZN3ccc7DD5x6y7E", // class name
  bases__ZN3ccc7DD5x6y7E, 2,
  &(vtc__ZN3ccc7DD5x6y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y7E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y8  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC5x6y83efgEv
  virtual void  abc(); // _ZN3ccc7CC5x6y83abcEv
  ~CC5x6y8(); // tgen
  CC5x6y8(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y8E) C1{ VBC2{ v3 v1 v2} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x6y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y83efgEv");}
void  ccc::CC5x6y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x6y83abcEv");}
ccc::CC5x6y8 ::~CC5x6y8(){ note_dtor("_ZN3ccc7CC5x6y8E", this);} // tgen
ccc::CC5x6y8 ::CC5x6y8(){ note_ctor("_ZN3ccc7CC5x6y8E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y8E, buf);
    ::ccc::CC5x6y8 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y8E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y8E);
    dp->::ccc::CC5x6y8::~CC5x6y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y8E(Test__ZN3ccc7CC5x6y8E, "_ZN3ccc7CC5x6y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y8C1Ev();
extern void _ZN3ccc7CC5x6y8D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y8E[] = {
  NSPAIR(_ZN3ccc7CC5x6y8C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y8E[];
extern void _ZN3ccc7CC5x6y83abcEv();
extern void _ZN3ccc7CC5x6y83efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y83efgEv,_ZTv0_n16_N3ccc7CC5x6y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y83efgEv,_ZThn4_N3ccc7CC5x6y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x6y83abcEv,_ZTv0_n20_N3ccc7CC5x6y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y83abcEv,_ZThn4_N3ccc7CC5x6y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y83efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y83efgEv,_ZTv0_n16_N3ccc7CC5x6y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x6y83abcEv,_ZTv0_n20_N3ccc7CC5x6y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y8E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y8E[] = {
  {&(_ZTVN3ccc7CC5x6y8E[3]),  3,13},
  {&(_ZTVN3ccc7CC5x6y8E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y8E[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x6y83abcEv,_ZTv0_n20_N3ccc7CC5x6y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y83abcEv,_ZThn4_N3ccc7CC5x6y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y83efgEv,_ZTv0_n16_N3ccc7CC5x6y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y83efgEv,_ZThn4_N3ccc7CC5x6y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y8E = {  "_ZN3ccc7CC5x6y8E", // class name
  bases__ZN3ccc7CC5x6y8E, 2,
  &(vtc__ZN3ccc7CC5x6y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y8E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y8  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7DD5x6y83efgEv
  virtual void  abc(); // _ZN3ccc7DD5x6y83abcEv
  ~DD5x6y8(); // tgen
  DD5x6y8(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y8E) C1{ VBC2{ v3 v1 v2} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x6y8 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y83efgEv");}
void  ccc::DD5x6y8 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x6y83abcEv");}
ccc::DD5x6y8 ::~DD5x6y8(){ note_dtor("_ZN3ccc7DD5x6y8E", this);} // tgen
ccc::DD5x6y8 ::DD5x6y8(){ note_ctor("_ZN3ccc7DD5x6y8E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y8E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y8E, buf);
    ::ccc::DD5x6y8 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y8E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y8E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y8E);
    dp->::ccc::DD5x6y8::~DD5x6y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y8E(Test__ZN3ccc7DD5x6y8E, "_ZN3ccc7DD5x6y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y8C1Ev();
extern void _ZN3ccc7DD5x6y8D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y8E[] = {
  NSPAIR(_ZN3ccc7DD5x6y8C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y8E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x6y83efgEv();
extern void _ZN3ccc7DD5x6y83abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x6y83abcEv,_ZTv0_n12_N3ccc7DD5x6y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y83abcEv,_ZThn4_N3ccc7DD5x6y83abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y83efgEv,_ZTv0_n16_N3ccc7DD5x6y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y83efgEv,_ZThn4_N3ccc7DD5x6y83efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y83abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x6y83abcEv,_ZTv0_n12_N3ccc7DD5x6y83abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y83efgEv,_ZTv0_n16_N3ccc7DD5x6y83efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y8E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y8E[] = {
  {&(_ZTVN3ccc7DD5x6y8E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y8E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y8E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y8E[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y83efgEv,_ZTv0_n16_N3ccc7DD5x6y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y83efgEv,_ZThn4_N3ccc7DD5x6y83efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x6y83abcEv,_ZTv0_n12_N3ccc7DD5x6y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y83abcEv,_ZThn4_N3ccc7DD5x6y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y8E = {  "_ZN3ccc7DD5x6y8E", // class name
  bases__ZN3ccc7DD5x6y8E, 2,
  &(vtc__ZN3ccc7DD5x6y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y8E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y9  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC5x6y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x6y93pqrEv
  ~CC5x6y9(); // tgen
  CC5x6y9(); // tgen
};
//SIG(1 _ZN3ccc7CC5x6y9E) C1{ VBC2{ v2 v1 v3} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x6y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x6y93efgEv");}
void  ccc::CC5x6y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x6y93pqrEv");}
ccc::CC5x6y9 ::~CC5x6y9(){ note_dtor("_ZN3ccc7CC5x6y9E", this);} // tgen
ccc::CC5x6y9 ::CC5x6y9(){ note_ctor("_ZN3ccc7CC5x6y9E", this);} // tgen
}
static void Test__ZN3ccc7CC5x6y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x6y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x6y9E, buf);
    ::ccc::CC5x6y9 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x6y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x6y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x6y9E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc7CC5x6y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x6y9E);
    dp->::ccc::CC5x6y9::~CC5x6y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x6y9E(Test__ZN3ccc7CC5x6y9E, "_ZN3ccc7CC5x6y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x6y9C1Ev();
extern void _ZN3ccc7CC5x6y9D1Ev();
Name_Map name_map__ZN3ccc7CC5x6y9E[] = {
  NSPAIR(_ZN3ccc7CC5x6y9C1Ev),
  NSPAIR(_ZN3ccc7CC5x6y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC5x6y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y9E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc7CC5x6y93efgEv();
extern void _ZN3ccc7CC5x6y93pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x6y93pqrEv,_ZTv0_n12_N3ccc7CC5x6y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y93pqrEv,_ZThn4_N3ccc7CC5x6y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x6y93efgEv,_ZTv0_n16_N3ccc7CC5x6y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x6y93efgEv,_ZThn4_N3ccc7CC5x6y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC5x6y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x6y93pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x6y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x6y93pqrEv,_ZTv0_n12_N3ccc7CC5x6y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x6y93efgEv,_ZTv0_n16_N3ccc7CC5x6y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x6y9E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x6y9E[] = {
  {&(_ZTVN3ccc7CC5x6y9E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x6y9E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x6y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x6y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x6y9E[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x6y93efgEv,_ZTv0_n16_N3ccc7CC5x6y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y93efgEv,_ZThn4_N3ccc7CC5x6y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x6y93pqrEv,_ZTv0_n12_N3ccc7CC5x6y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x6y93pqrEv,_ZThn4_N3ccc7CC5x6y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x6y9E = {  "_ZN3ccc7CC5x6y9E", // class name
  bases__ZN3ccc7CC5x6y9E, 2,
  &(vtc__ZN3ccc7CC5x6y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x6y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x6y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x6y9E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x6y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y9  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7DD5x6y93efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x6y93pqrEv
  ~DD5x6y9(); // tgen
  DD5x6y9(); // tgen
};
//SIG(1 _ZN3ccc7DD5x6y9E) C1{ VBC2{ v2 v1 v3} VBC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x6y9 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x6y93efgEv");}
void  ccc::DD5x6y9 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x6y93pqrEv");}
ccc::DD5x6y9 ::~DD5x6y9(){ note_dtor("_ZN3ccc7DD5x6y9E", this);} // tgen
ccc::DD5x6y9 ::DD5x6y9(){ note_ctor("_ZN3ccc7DD5x6y9E", this);} // tgen
}
static void Test__ZN3ccc7DD5x6y9E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x6y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x6y9E, buf);
    ::ccc::DD5x6y9 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x6y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x6y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x6y9E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7DD5x6y9E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x6y9E);
    dp->::ccc::DD5x6y9::~DD5x6y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x6y9E(Test__ZN3ccc7DD5x6y9E, "_ZN3ccc7DD5x6y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x6y9C1Ev();
extern void _ZN3ccc7DD5x6y9D1Ev();
Name_Map name_map__ZN3ccc7DD5x6y9E[] = {
  NSPAIR(_ZN3ccc7DD5x6y9C1Ev),
  NSPAIR(_ZN3ccc7DD5x6y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7DD5x6y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y9E[];
extern void _ZN3ccc7DD5x6y93pqrEv();
extern void _ZN3ccc7DD5x6y93efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x6y93efgEv,_ZTv0_n16_N3ccc7DD5x6y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x6y93efgEv,_ZThn4_N3ccc7DD5x6y93efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x6y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x6y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x6y93efgEv,_ZTv0_n16_N3ccc7DD5x6y93efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x6y9E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x6y9E[] = {
  {&(_ZTVN3ccc7DD5x6y9E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y9E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x6y9E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x6y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x6y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x6y9E[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x6y93efgEv,_ZTv0_n16_N3ccc7DD5x6y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x6y93efgEv,_ZThn4_N3ccc7DD5x6y93efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x6y9E = {  "_ZN3ccc7DD5x6y9E", // class name
  bases__ZN3ccc7DD5x6y9E, 2,
  &(vtc__ZN3ccc7DD5x6y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x6y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x6y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x6y9E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x6y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y10  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC5x6y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC5x6y103abcEv
  ~CC5x6y10(); // tgen
  CC5x6y10(); // tgen
};
//SIG(1 _ZN3ccc8CC5x6y10E) C1{ VBC2{ v1 v3 v2} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x6y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x6y103pqrEv");}
void  ccc::CC5x6y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x6y103abcEv");}
ccc::CC5x6y10 ::~CC5x6y10(){ note_dtor("_ZN3ccc8CC5x6y10E", this);} // tgen
ccc::CC5x6y10 ::CC5x6y10(){ note_ctor("_ZN3ccc8CC5x6y10E", this);} // tgen
}
static void Test__ZN3ccc8CC5x6y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x6y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x6y10E, buf);
    ::ccc::CC5x6y10 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x6y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x6y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x6y10E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC5x6y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x6y10E);
    dp->::ccc::CC5x6y10::~CC5x6y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x6y10E(Test__ZN3ccc8CC5x6y10E, "_ZN3ccc8CC5x6y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x6y10C1Ev();
extern void _ZN3ccc8CC5x6y10D1Ev();
Name_Map name_map__ZN3ccc8CC5x6y10E[] = {
  NSPAIR(_ZN3ccc8CC5x6y10C1Ev),
  NSPAIR(_ZN3ccc8CC5x6y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC5x6y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y10E[];
extern void _ZN3ccc8CC5x6y103abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc8CC5x6y103pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x6y103pqrEv,_ZTv0_n12_N3ccc8CC5x6y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x6y103pqrEv,_ZThn4_N3ccc8CC5x6y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x6y103abcEv,_ZTv0_n20_N3ccc8CC5x6y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x6y103abcEv,_ZThn4_N3ccc8CC5x6y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x6y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x6y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x6y103pqrEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x6y103pqrEv,_ZTv0_n12_N3ccc8CC5x6y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x6y103abcEv,_ZTv0_n20_N3ccc8CC5x6y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x6y10E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x6y10E[] = {
  {&(_ZTVN3ccc8CC5x6y10E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x6y10E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x6y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x6y10E[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x6y103abcEv,_ZTv0_n20_N3ccc8CC5x6y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x6y103abcEv,_ZThn4_N3ccc8CC5x6y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x6y103pqrEv,_ZTv0_n12_N3ccc8CC5x6y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x6y103pqrEv,_ZThn4_N3ccc8CC5x6y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x6y10E = {  "_ZN3ccc8CC5x6y10E", // class name
  bases__ZN3ccc8CC5x6y10E, 2,
  &(vtc__ZN3ccc8CC5x6y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x6y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x6y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x6y10E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x6y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y10  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8DD5x6y103pqrEv
  virtual void  abc(); // _ZN3ccc8DD5x6y103abcEv
  ~DD5x6y10(); // tgen
  DD5x6y10(); // tgen
};
//SIG(1 _ZN3ccc8DD5x6y10E) C1{ VBC2{ v1 v3 v2} VBC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x6y10 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x6y103pqrEv");}
void  ccc::DD5x6y10 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x6y103abcEv");}
ccc::DD5x6y10 ::~DD5x6y10(){ note_dtor("_ZN3ccc8DD5x6y10E", this);} // tgen
ccc::DD5x6y10 ::DD5x6y10(){ note_ctor("_ZN3ccc8DD5x6y10E", this);} // tgen
}
static void Test__ZN3ccc8DD5x6y10E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x6y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x6y10E, buf);
    ::ccc::DD5x6y10 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x6y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x6y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x6y10E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD5x6y10E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x6y10E);
    dp->::ccc::DD5x6y10::~DD5x6y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x6y10E(Test__ZN3ccc8DD5x6y10E, "_ZN3ccc8DD5x6y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x6y10C1Ev();
extern void _ZN3ccc8DD5x6y10D1Ev();
Name_Map name_map__ZN3ccc8DD5x6y10E[] = {
  NSPAIR(_ZN3ccc8DD5x6y10C1Ev),
  NSPAIR(_ZN3ccc8DD5x6y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD5x6y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y10E[];
extern void _ZN3ccc8DD5x6y103pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x6y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x6y103abcEv,_ZTv0_n12_N3ccc8DD5x6y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x6y103abcEv,_ZThn4_N3ccc8DD5x6y103abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x6y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x6y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x6y103abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x6y103abcEv,_ZTv0_n12_N3ccc8DD5x6y103abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x6y10E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x6y10E[] = {
  {&(_ZTVN3ccc8DD5x6y10E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y10E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y10E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x6y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x6y10E[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x6y103abcEv,_ZTv0_n12_N3ccc8DD5x6y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x6y103abcEv,_ZThn4_N3ccc8DD5x6y103abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x6y10E = {  "_ZN3ccc8DD5x6y10E", // class name
  bases__ZN3ccc8DD5x6y10E, 2,
  &(vtc__ZN3ccc8DD5x6y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x6y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x6y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x6y10E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x6y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names108,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y11  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC5x6y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC5x6y113efgEv
  ~CC5x6y11(); // tgen
  CC5x6y11(); // tgen
};
//SIG(1 _ZN3ccc8CC5x6y11E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x6y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x6y113pqrEv");}
void  ccc::CC5x6y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x6y113efgEv");}
ccc::CC5x6y11 ::~CC5x6y11(){ note_dtor("_ZN3ccc8CC5x6y11E", this);} // tgen
ccc::CC5x6y11 ::CC5x6y11(){ note_ctor("_ZN3ccc8CC5x6y11E", this);} // tgen
}
static void Test__ZN3ccc8CC5x6y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x6y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x6y11E, buf);
    ::ccc::CC5x6y11 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x6y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x6y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x6y11E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC5x6y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x6y11E);
    dp->::ccc::CC5x6y11::~CC5x6y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x6y11E(Test__ZN3ccc8CC5x6y11E, "_ZN3ccc8CC5x6y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x6y11C1Ev();
extern void _ZN3ccc8CC5x6y11D1Ev();
Name_Map name_map__ZN3ccc8CC5x6y11E[] = {
  NSPAIR(_ZN3ccc8CC5x6y11C1Ev),
  NSPAIR(_ZN3ccc8CC5x6y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC5x6y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y11E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc8CC5x6y113efgEv();
extern void _ZN3ccc8CC5x6y113pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x6y113pqrEv,_ZTv0_n12_N3ccc8CC5x6y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x6y113pqrEv,_ZThn4_N3ccc8CC5x6y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x6y113efgEv,_ZTv0_n16_N3ccc8CC5x6y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x6y113efgEv,_ZThn4_N3ccc8CC5x6y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x6y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x6y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x6y113pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x6y113pqrEv,_ZTv0_n12_N3ccc8CC5x6y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x6y113efgEv,_ZTv0_n16_N3ccc8CC5x6y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x6y11E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x6y11E[] = {
  {&(_ZTVN3ccc8CC5x6y11E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x6y11E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x6y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x6y11E[];
static VTBL_ENTRY alt_thunk_names109[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x6y113efgEv,_ZTv0_n16_N3ccc8CC5x6y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x6y113efgEv,_ZThn4_N3ccc8CC5x6y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x6y113pqrEv,_ZTv0_n12_N3ccc8CC5x6y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x6y113pqrEv,_ZThn4_N3ccc8CC5x6y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x6y11E = {  "_ZN3ccc8CC5x6y11E", // class name
  bases__ZN3ccc8CC5x6y11E, 2,
  &(vtc__ZN3ccc8CC5x6y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x6y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x6y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x6y11E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x6y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names109,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y11  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8DD5x6y113pqrEv
  virtual void  efg(); // _ZN3ccc8DD5x6y113efgEv
  ~DD5x6y11(); // tgen
  DD5x6y11(); // tgen
};
//SIG(1 _ZN3ccc8DD5x6y11E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x6y11 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x6y113pqrEv");}
void  ccc::DD5x6y11 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x6y113efgEv");}
ccc::DD5x6y11 ::~DD5x6y11(){ note_dtor("_ZN3ccc8DD5x6y11E", this);} // tgen
ccc::DD5x6y11 ::DD5x6y11(){ note_ctor("_ZN3ccc8DD5x6y11E", this);} // tgen
}
static void Test__ZN3ccc8DD5x6y11E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x6y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x6y11E, buf);
    ::ccc::DD5x6y11 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x6y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x6y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x6y11E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD5x6y11E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x6y11E);
    dp->::ccc::DD5x6y11::~DD5x6y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x6y11E(Test__ZN3ccc8DD5x6y11E, "_ZN3ccc8DD5x6y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x6y11C1Ev();
extern void _ZN3ccc8DD5x6y11D1Ev();
Name_Map name_map__ZN3ccc8DD5x6y11E[] = {
  NSPAIR(_ZN3ccc8DD5x6y11C1Ev),
  NSPAIR(_ZN3ccc8DD5x6y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD5x6y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y11E[];
extern void _ZN3ccc8DD5x6y113pqrEv();
extern void _ZN3ccc8DD5x6y113efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x6y113efgEv,_ZTv0_n16_N3ccc8DD5x6y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x6y113efgEv,_ZThn4_N3ccc8DD5x6y113efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x6y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x6y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x6y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x6y113efgEv,_ZTv0_n16_N3ccc8DD5x6y113efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x6y11E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x6y11E[] = {
  {&(_ZTVN3ccc8DD5x6y11E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y11E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y11E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x6y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x6y11E[];
static VTBL_ENTRY alt_thunk_names110[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x6y113efgEv,_ZTv0_n16_N3ccc8DD5x6y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x6y113efgEv,_ZThn4_N3ccc8DD5x6y113efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x6y11E = {  "_ZN3ccc8DD5x6y11E", // class name
  bases__ZN3ccc8DD5x6y11E, 2,
  &(vtc__ZN3ccc8DD5x6y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x6y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x6y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x6y11E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x6y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names110,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y12  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc8CC5x6y123abcEv
  ~CC5x6y12(); // tgen
  CC5x6y12(); // tgen
};
//SIG(1 _ZN3ccc8CC5x6y12E) C1{ VBC2{ v2 v3 v1} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC5x6y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x6y123abcEv");}
ccc::CC5x6y12 ::~CC5x6y12(){ note_dtor("_ZN3ccc8CC5x6y12E", this);} // tgen
ccc::CC5x6y12 ::CC5x6y12(){ note_ctor("_ZN3ccc8CC5x6y12E", this);} // tgen
}
static void Test__ZN3ccc8CC5x6y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x6y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x6y12E, buf);
    ::ccc::CC5x6y12 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x6y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x6y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x6y12E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC5x6y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x6y12E);
    dp->::ccc::CC5x6y12::~CC5x6y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x6y12E(Test__ZN3ccc8CC5x6y12E, "_ZN3ccc8CC5x6y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x6y12C1Ev();
extern void _ZN3ccc8CC5x6y12D1Ev();
Name_Map name_map__ZN3ccc8CC5x6y12E[] = {
  NSPAIR(_ZN3ccc8CC5x6y12C1Ev),
  NSPAIR(_ZN3ccc8CC5x6y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC5x6y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y12E[];
extern void _ZN3ccc8CC5x6y123abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x6y123abcEv,_ZTv0_n20_N3ccc8CC5x6y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x6y123abcEv,_ZThn4_N3ccc8CC5x6y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x6y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x6y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x6y123abcEv,_ZTv0_n20_N3ccc8CC5x6y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x6y12E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x6y12E[] = {
  {&(_ZTVN3ccc8CC5x6y12E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x6y12E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x6y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x6y12E[];
static VTBL_ENTRY alt_thunk_names111[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x6y123abcEv,_ZTv0_n20_N3ccc8CC5x6y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x6y123abcEv,_ZThn4_N3ccc8CC5x6y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x6y12E = {  "_ZN3ccc8CC5x6y12E", // class name
  bases__ZN3ccc8CC5x6y12E, 2,
  &(vtc__ZN3ccc8CC5x6y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x6y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x6y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x6y12E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x6y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names111,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y12  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc8DD5x6y123abcEv
  ~DD5x6y12(); // tgen
  DD5x6y12(); // tgen
};
//SIG(1 _ZN3ccc8DD5x6y12E) C1{ VBC2{ v2 v3 v1} VBC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::DD5x6y12 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x6y123abcEv");}
ccc::DD5x6y12 ::~DD5x6y12(){ note_dtor("_ZN3ccc8DD5x6y12E", this);} // tgen
ccc::DD5x6y12 ::DD5x6y12(){ note_ctor("_ZN3ccc8DD5x6y12E", this);} // tgen
}
static void Test__ZN3ccc8DD5x6y12E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x6y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x6y12E, buf);
    ::ccc::DD5x6y12 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x6y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x6y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x6y12E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD5x6y12E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x6y12E);
    dp->::ccc::DD5x6y12::~DD5x6y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x6y12E(Test__ZN3ccc8DD5x6y12E, "_ZN3ccc8DD5x6y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x6y12C1Ev();
extern void _ZN3ccc8DD5x6y12D1Ev();
Name_Map name_map__ZN3ccc8DD5x6y12E[] = {
  NSPAIR(_ZN3ccc8DD5x6y12C1Ev),
  NSPAIR(_ZN3ccc8DD5x6y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD5x6y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y12E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x6y123abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x6y123abcEv,_ZTv0_n12_N3ccc8DD5x6y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x6y123abcEv,_ZThn4_N3ccc8DD5x6y123abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x6y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x6y123abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x6y123abcEv,_ZTv0_n12_N3ccc8DD5x6y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x6y12E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x6y12E[] = {
  {&(_ZTVN3ccc8DD5x6y12E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y12E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y12E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x6y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x6y12E[];
static VTBL_ENTRY alt_thunk_names112[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x6y123abcEv,_ZTv0_n12_N3ccc8DD5x6y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x6y123abcEv,_ZThn4_N3ccc8DD5x6y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x6y12E = {  "_ZN3ccc8DD5x6y12E", // class name
  bases__ZN3ccc8DD5x6y12E, 2,
  &(vtc__ZN3ccc8DD5x6y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x6y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x6y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x6y12E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x6y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names112,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y13  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc8CC5x6y133efgEv
  ~CC5x6y13(); // tgen
  CC5x6y13(); // tgen
};
//SIG(1 _ZN3ccc8CC5x6y13E) C1{ VBC2{ v2 v1 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC5x6y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x6y133efgEv");}
ccc::CC5x6y13 ::~CC5x6y13(){ note_dtor("_ZN3ccc8CC5x6y13E", this);} // tgen
ccc::CC5x6y13 ::CC5x6y13(){ note_ctor("_ZN3ccc8CC5x6y13E", this);} // tgen
}
static void Test__ZN3ccc8CC5x6y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x6y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x6y13E, buf);
    ::ccc::CC5x6y13 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x6y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x6y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x6y13E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC5x6y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x6y13E);
    dp->::ccc::CC5x6y13::~CC5x6y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x6y13E(Test__ZN3ccc8CC5x6y13E, "_ZN3ccc8CC5x6y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x6y13C1Ev();
extern void _ZN3ccc8CC5x6y13D1Ev();
Name_Map name_map__ZN3ccc8CC5x6y13E[] = {
  NSPAIR(_ZN3ccc8CC5x6y13C1Ev),
  NSPAIR(_ZN3ccc8CC5x6y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC5x6y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y13E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc8CC5x6y133efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x6y133efgEv,_ZTv0_n16_N3ccc8CC5x6y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x6y133efgEv,_ZThn4_N3ccc8CC5x6y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x6y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x6y133efgEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x6y133efgEv,_ZTv0_n16_N3ccc8CC5x6y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x6y13E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x6y13E[] = {
  {&(_ZTVN3ccc8CC5x6y13E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x6y13E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x6y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x6y13E[];
static VTBL_ENTRY alt_thunk_names113[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x6y133efgEv,_ZTv0_n16_N3ccc8CC5x6y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x6y133efgEv,_ZThn4_N3ccc8CC5x6y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x6y13E = {  "_ZN3ccc8CC5x6y13E", // class name
  bases__ZN3ccc8CC5x6y13E, 2,
  &(vtc__ZN3ccc8CC5x6y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x6y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x6y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x6y13E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x6y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names113,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y13  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc8DD5x6y133efgEv
  ~DD5x6y13(); // tgen
  DD5x6y13(); // tgen
};
//SIG(1 _ZN3ccc8DD5x6y13E) C1{ VBC2{ v2 v1 v3} VBC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::DD5x6y13 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x6y133efgEv");}
ccc::DD5x6y13 ::~DD5x6y13(){ note_dtor("_ZN3ccc8DD5x6y13E", this);} // tgen
ccc::DD5x6y13 ::DD5x6y13(){ note_ctor("_ZN3ccc8DD5x6y13E", this);} // tgen
}
static void Test__ZN3ccc8DD5x6y13E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x6y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x6y13E, buf);
    ::ccc::DD5x6y13 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x6y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x6y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x6y13E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD5x6y13E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x6y13E);
    dp->::ccc::DD5x6y13::~DD5x6y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x6y13E(Test__ZN3ccc8DD5x6y13E, "_ZN3ccc8DD5x6y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x6y13C1Ev();
extern void _ZN3ccc8DD5x6y13D1Ev();
Name_Map name_map__ZN3ccc8DD5x6y13E[] = {
  NSPAIR(_ZN3ccc8DD5x6y13C1Ev),
  NSPAIR(_ZN3ccc8DD5x6y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD5x6y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y13E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc8DD5x6y133efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x6y133efgEv,_ZTv0_n16_N3ccc8DD5x6y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x6y133efgEv,_ZThn4_N3ccc8DD5x6y133efgEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x6y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x6y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x6y133efgEv,_ZTv0_n16_N3ccc8DD5x6y133efgEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x6y13E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x6y13E[] = {
  {&(_ZTVN3ccc8DD5x6y13E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y13E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y13E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x6y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x6y13E[];
static VTBL_ENTRY alt_thunk_names114[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x6y133efgEv,_ZTv0_n16_N3ccc8DD5x6y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x6y133efgEv,_ZThn4_N3ccc8DD5x6y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x6y13E = {  "_ZN3ccc8DD5x6y13E", // class name
  bases__ZN3ccc8DD5x6y13E, 2,
  &(vtc__ZN3ccc8DD5x6y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x6y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x6y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x6y13E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x6y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names114,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y14  : virtual ::ccc::AA5 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC5x6y143pqrEv
  ~CC5x6y14(); // tgen
  CC5x6y14(); // tgen
};
//SIG(1 _ZN3ccc8CC5x6y14E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC5x6y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x6y143pqrEv");}
ccc::CC5x6y14 ::~CC5x6y14(){ note_dtor("_ZN3ccc8CC5x6y14E", this);} // tgen
ccc::CC5x6y14 ::CC5x6y14(){ note_ctor("_ZN3ccc8CC5x6y14E", this);} // tgen
}
static void Test__ZN3ccc8CC5x6y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x6y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x6y14E, buf);
    ::ccc::CC5x6y14 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x6y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x6y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x6y14E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC5x6y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x6y14E);
    dp->::ccc::CC5x6y14::~CC5x6y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x6y14E(Test__ZN3ccc8CC5x6y14E, "_ZN3ccc8CC5x6y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x6y14C1Ev();
extern void _ZN3ccc8CC5x6y14D1Ev();
Name_Map name_map__ZN3ccc8CC5x6y14E[] = {
  NSPAIR(_ZN3ccc8CC5x6y14C1Ev),
  NSPAIR(_ZN3ccc8CC5x6y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC5x6y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y14E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc8CC5x6y143pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x6y143pqrEv,_ZTv0_n12_N3ccc8CC5x6y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x6y143pqrEv,_ZThn4_N3ccc8CC5x6y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x6y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x6y143pqrEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x6y143pqrEv,_ZTv0_n12_N3ccc8CC5x6y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x6y14E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x6y14E[] = {
  {&(_ZTVN3ccc8CC5x6y14E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x6y14E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x6y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x6y14E[];
static VTBL_ENTRY alt_thunk_names115[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x6y143pqrEv,_ZTv0_n12_N3ccc8CC5x6y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x6y143pqrEv,_ZThn4_N3ccc8CC5x6y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x6y14E = {  "_ZN3ccc8CC5x6y14E", // class name
  bases__ZN3ccc8CC5x6y14E, 2,
  &(vtc__ZN3ccc8CC5x6y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x6y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x6y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x6y14E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x6y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names115,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y14  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8DD5x6y143pqrEv
  ~DD5x6y14(); // tgen
  DD5x6y14(); // tgen
};
//SIG(1 _ZN3ccc8DD5x6y14E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::DD5x6y14 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x6y143pqrEv");}
ccc::DD5x6y14 ::~DD5x6y14(){ note_dtor("_ZN3ccc8DD5x6y14E", this);} // tgen
ccc::DD5x6y14 ::DD5x6y14(){ note_ctor("_ZN3ccc8DD5x6y14E", this);} // tgen
}
static void Test__ZN3ccc8DD5x6y14E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x6y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x6y14E, buf);
    ::ccc::DD5x6y14 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x6y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x6y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x6y14E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD5x6y14E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x6y14E);
    dp->::ccc::DD5x6y14::~DD5x6y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x6y14E(Test__ZN3ccc8DD5x6y14E, "_ZN3ccc8DD5x6y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x6y14C1Ev();
extern void _ZN3ccc8DD5x6y14D1Ev();
Name_Map name_map__ZN3ccc8DD5x6y14E[] = {
  NSPAIR(_ZN3ccc8DD5x6y14C1Ev),
  NSPAIR(_ZN3ccc8DD5x6y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD5x6y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y14E[];
extern void _ZN3ccc8DD5x6y143pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x6y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x6y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x6y14E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x6y14E[] = {
  {&(_ZTVN3ccc8DD5x6y14E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y14E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y14E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x6y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x6y14E[];
Class_Descriptor cd__ZN3ccc8DD5x6y14E = {  "_ZN3ccc8DD5x6y14E", // class name
  bases__ZN3ccc8DD5x6y14E, 2,
  &(vtc__ZN3ccc8DD5x6y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x6y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x6y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x6y14E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x6y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x6y15  : virtual ::ccc::AA5 , ::ccc::BB6 {
  ~CC5x6y15(); // tgen
  CC5x6y15(); // tgen
};
//SIG(1 _ZN3ccc8CC5x6y15E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC5x6y15 ::~CC5x6y15(){ note_dtor("_ZN3ccc8CC5x6y15E", this);} // tgen
ccc::CC5x6y15 ::CC5x6y15(){ note_ctor("_ZN3ccc8CC5x6y15E", this);} // tgen
}
static void Test__ZN3ccc8CC5x6y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x6y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x6y15E, buf);
    ::ccc::CC5x6y15 *dp, &lv = *(dp=new (buf) ::ccc::CC5x6y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x6y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x6y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x6y15E");
    check_base_class_offset(lv, (::ccc::BB6*), 0, "_ZN3ccc8CC5x6y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x6y15E);
    dp->::ccc::CC5x6y15::~CC5x6y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x6y15E(Test__ZN3ccc8CC5x6y15E, "_ZN3ccc8CC5x6y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x6y15C1Ev();
extern void _ZN3ccc8CC5x6y15D1Ev();
Name_Map name_map__ZN3ccc8CC5x6y15E[] = {
  NSPAIR(_ZN3ccc8CC5x6y15C1Ev),
  NSPAIR(_ZN3ccc8CC5x6y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC5x6y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y15E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x6y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x6y15E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x6y15E[] = {
  {&(_ZTVN3ccc8CC5x6y15E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x6y15E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x6y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x6y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x6y15E[];
Class_Descriptor cd__ZN3ccc8CC5x6y15E = {  "_ZN3ccc8CC5x6y15E", // class name
  bases__ZN3ccc8CC5x6y15E, 2,
  &(vtc__ZN3ccc8CC5x6y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x6y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x6y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x6y15E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x6y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x6y15  : virtual ::ccc::AA5 , virtual ::ccc::BB6 {
  ~DD5x6y15(); // tgen
  DD5x6y15(); // tgen
};
//SIG(1 _ZN3ccc8DD5x6y15E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v5}}
}
namespace ccc { 
ccc::DD5x6y15 ::~DD5x6y15(){ note_dtor("_ZN3ccc8DD5x6y15E", this);} // tgen
ccc::DD5x6y15 ::DD5x6y15(){ note_ctor("_ZN3ccc8DD5x6y15E", this);} // tgen
}
static void Test__ZN3ccc8DD5x6y15E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x6y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x6y15E, buf);
    ::ccc::DD5x6y15 *dp, &lv = *(dp=new (buf) ::ccc::DD5x6y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x6y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x6y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x6y15E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8DD5x6y15E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x6y15E);
    dp->::ccc::DD5x6y15::~DD5x6y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x6y15E(Test__ZN3ccc8DD5x6y15E, "_ZN3ccc8DD5x6y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x6y15C1Ev();
extern void _ZN3ccc8DD5x6y15D1Ev();
Name_Map name_map__ZN3ccc8DD5x6y15E[] = {
  NSPAIR(_ZN3ccc8DD5x6y15C1Ev),
  NSPAIR(_ZN3ccc8DD5x6y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8DD5x6y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y15E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x6y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x6y15E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x6y15E[] = {
  {&(_ZTVN3ccc8DD5x6y15E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y15E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x6y15E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x6y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x6y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x6y15E[];
Class_Descriptor cd__ZN3ccc8DD5x6y15E = {  "_ZN3ccc8DD5x6y15E", // class name
  bases__ZN3ccc8DD5x6y15E, 2,
  &(vtc__ZN3ccc8DD5x6y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x6y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x6y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x6y15E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x6y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y0  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC5x7y03abcEv
  virtual void  efg(); // _ZN3ccc7CC5x7y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x7y03pqrEv
  ~CC5x7y0(); // tgen
  CC5x7y0(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y0E) C1{ VBC2{ v3 v2 v1} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x7y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y03abcEv");}
void  ccc::CC5x7y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y03efgEv");}
void  ccc::CC5x7y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y03pqrEv");}
ccc::CC5x7y0 ::~CC5x7y0(){ note_dtor("_ZN3ccc7CC5x7y0E", this);} // tgen
ccc::CC5x7y0 ::CC5x7y0(){ note_ctor("_ZN3ccc7CC5x7y0E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y0E, buf);
    ::ccc::CC5x7y0 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y0E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y0E);
    dp->::ccc::CC5x7y0::~CC5x7y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y0E(Test__ZN3ccc7CC5x7y0E, "_ZN3ccc7CC5x7y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y0C1Ev();
extern void _ZN3ccc7CC5x7y0D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y0E[] = {
  NSPAIR(_ZN3ccc7CC5x7y0C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y0E[];
extern void _ZN3ccc7CC5x7y03abcEv();
extern void _ZN3ccc7CC5x7y03pqrEv();
extern void _ZN3ccc7CC5x7y03efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y03pqrEv,_ZTv0_n12_N3ccc7CC5x7y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y03pqrEv,_ZThn4_N3ccc7CC5x7y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y03efgEv,_ZTv0_n16_N3ccc7CC5x7y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y03efgEv,_ZThn4_N3ccc7CC5x7y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y03abcEv,_ZTv0_n20_N3ccc7CC5x7y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y03abcEv,_ZThn4_N3ccc7CC5x7y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y03efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y03pqrEv,_ZTv0_n12_N3ccc7CC5x7y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y03efgEv,_ZTv0_n16_N3ccc7CC5x7y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y03abcEv,_ZTv0_n20_N3ccc7CC5x7y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y0E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y0E[] = {
  {&(_ZTVN3ccc7CC5x7y0E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y0E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y0E[];
static VTBL_ENTRY alt_thunk_names116[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y03abcEv,_ZTv0_n20_N3ccc7CC5x7y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y03abcEv,_ZThn4_N3ccc7CC5x7y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y03efgEv,_ZTv0_n16_N3ccc7CC5x7y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y03efgEv,_ZThn4_N3ccc7CC5x7y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y03pqrEv,_ZTv0_n12_N3ccc7CC5x7y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y03pqrEv,_ZThn4_N3ccc7CC5x7y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y0E = {  "_ZN3ccc7CC5x7y0E", // class name
  bases__ZN3ccc7CC5x7y0E, 2,
  &(vtc__ZN3ccc7CC5x7y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y0E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names116,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y0  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7DD5x7y03abcEv
  virtual void  efg(); // _ZN3ccc7DD5x7y03efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x7y03pqrEv
  ~DD5x7y0(); // tgen
  DD5x7y0(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y0E) C1{ VBC2{ v3 v2 v1} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x7y0 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y03abcEv");}
void  ccc::DD5x7y0 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y03efgEv");}
void  ccc::DD5x7y0 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y03pqrEv");}
ccc::DD5x7y0 ::~DD5x7y0(){ note_dtor("_ZN3ccc7DD5x7y0E", this);} // tgen
ccc::DD5x7y0 ::DD5x7y0(){ note_ctor("_ZN3ccc7DD5x7y0E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y0E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y0E, buf);
    ::ccc::DD5x7y0 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y0E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y0E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y0E);
    dp->::ccc::DD5x7y0::~DD5x7y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y0E(Test__ZN3ccc7DD5x7y0E, "_ZN3ccc7DD5x7y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y0C1Ev();
extern void _ZN3ccc7DD5x7y0D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y0E[] = {
  NSPAIR(_ZN3ccc7DD5x7y0C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y0E[];
extern void _ZN3ccc7DD5x7y03pqrEv();
extern void _ZN3ccc7DD5x7y03efgEv();
extern void _ZN3ccc7DD5x7y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y03abcEv,_ZTv0_n12_N3ccc7DD5x7y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y03abcEv,_ZThn4_N3ccc7DD5x7y03abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y03pqrEv,_ZTv0_n16_N3ccc7DD5x7y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y03pqrEv,_ZThn4_N3ccc7DD5x7y03pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y03abcEv,_ZTv0_n12_N3ccc7DD5x7y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y03pqrEv,_ZTv0_n16_N3ccc7DD5x7y03pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y0E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y0E[] = {
  {&(_ZTVN3ccc7DD5x7y0E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y0E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y0E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y0E[];
static VTBL_ENTRY alt_thunk_names117[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y03pqrEv,_ZTv0_n16_N3ccc7DD5x7y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y03pqrEv,_ZThn4_N3ccc7DD5x7y03pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y03abcEv,_ZTv0_n12_N3ccc7DD5x7y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y03abcEv,_ZThn4_N3ccc7DD5x7y03abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y0E = {  "_ZN3ccc7DD5x7y0E", // class name
  bases__ZN3ccc7DD5x7y0E, 2,
  &(vtc__ZN3ccc7DD5x7y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y0E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names117,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y1  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC5x7y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x7y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x7y13efgEv
  ~CC5x7y1(); // tgen
  CC5x7y1(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y1E) C1{ VBC2{ v2 v3 v1} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x7y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y13abcEv");}
void  ccc::CC5x7y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y13pqrEv");}
void  ccc::CC5x7y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y13efgEv");}
ccc::CC5x7y1 ::~CC5x7y1(){ note_dtor("_ZN3ccc7CC5x7y1E", this);} // tgen
ccc::CC5x7y1 ::CC5x7y1(){ note_ctor("_ZN3ccc7CC5x7y1E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y1E, buf);
    ::ccc::CC5x7y1 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y1E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y1E);
    dp->::ccc::CC5x7y1::~CC5x7y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y1E(Test__ZN3ccc7CC5x7y1E, "_ZN3ccc7CC5x7y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y1C1Ev();
extern void _ZN3ccc7CC5x7y1D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y1E[] = {
  NSPAIR(_ZN3ccc7CC5x7y1C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y1E[];
extern void _ZN3ccc7CC5x7y13abcEv();
extern void _ZN3ccc7CC5x7y13pqrEv();
extern void _ZN3ccc7CC5x7y13efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y13pqrEv,_ZTv0_n12_N3ccc7CC5x7y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y13pqrEv,_ZThn4_N3ccc7CC5x7y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y13efgEv,_ZTv0_n16_N3ccc7CC5x7y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y13efgEv,_ZThn4_N3ccc7CC5x7y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y13abcEv,_ZTv0_n20_N3ccc7CC5x7y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y13abcEv,_ZThn4_N3ccc7CC5x7y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y13efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y13pqrEv,_ZTv0_n12_N3ccc7CC5x7y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y13efgEv,_ZTv0_n16_N3ccc7CC5x7y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y13abcEv,_ZTv0_n20_N3ccc7CC5x7y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y1E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y1E[] = {
  {&(_ZTVN3ccc7CC5x7y1E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y1E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y1E[];
static VTBL_ENTRY alt_thunk_names118[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y13abcEv,_ZTv0_n20_N3ccc7CC5x7y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y13abcEv,_ZThn4_N3ccc7CC5x7y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y13efgEv,_ZTv0_n16_N3ccc7CC5x7y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y13efgEv,_ZThn4_N3ccc7CC5x7y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y13pqrEv,_ZTv0_n12_N3ccc7CC5x7y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y13pqrEv,_ZThn4_N3ccc7CC5x7y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y1E = {  "_ZN3ccc7CC5x7y1E", // class name
  bases__ZN3ccc7CC5x7y1E, 2,
  &(vtc__ZN3ccc7CC5x7y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y1E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names118,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y1  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7DD5x7y13abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x7y13pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x7y13efgEv
  ~DD5x7y1(); // tgen
  DD5x7y1(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y1E) C1{ VBC2{ v2 v3 v1} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x7y1 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y13abcEv");}
void  ccc::DD5x7y1 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y13pqrEv");}
void  ccc::DD5x7y1 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y13efgEv");}
ccc::DD5x7y1 ::~DD5x7y1(){ note_dtor("_ZN3ccc7DD5x7y1E", this);} // tgen
ccc::DD5x7y1 ::DD5x7y1(){ note_ctor("_ZN3ccc7DD5x7y1E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y1E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y1E, buf);
    ::ccc::DD5x7y1 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y1E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y1E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y1E);
    dp->::ccc::DD5x7y1::~DD5x7y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y1E(Test__ZN3ccc7DD5x7y1E, "_ZN3ccc7DD5x7y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y1C1Ev();
extern void _ZN3ccc7DD5x7y1D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y1E[] = {
  NSPAIR(_ZN3ccc7DD5x7y1C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y1E[];
extern void _ZN3ccc7DD5x7y13pqrEv();
extern void _ZN3ccc7DD5x7y13efgEv();
extern void _ZN3ccc7DD5x7y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y13abcEv,_ZTv0_n12_N3ccc7DD5x7y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y13abcEv,_ZThn4_N3ccc7DD5x7y13abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y13pqrEv,_ZTv0_n16_N3ccc7DD5x7y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y13pqrEv,_ZThn4_N3ccc7DD5x7y13pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y13abcEv,_ZTv0_n12_N3ccc7DD5x7y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y13pqrEv,_ZTv0_n16_N3ccc7DD5x7y13pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y1E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y1E[] = {
  {&(_ZTVN3ccc7DD5x7y1E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y1E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y1E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y1E[];
static VTBL_ENTRY alt_thunk_names119[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y13pqrEv,_ZTv0_n16_N3ccc7DD5x7y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y13pqrEv,_ZThn4_N3ccc7DD5x7y13pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y13abcEv,_ZTv0_n12_N3ccc7DD5x7y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y13abcEv,_ZThn4_N3ccc7DD5x7y13abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y1E = {  "_ZN3ccc7DD5x7y1E", // class name
  bases__ZN3ccc7DD5x7y1E, 2,
  &(vtc__ZN3ccc7DD5x7y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y1E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names119,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y2  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC5x7y23efgEv
  virtual void  abc(); // _ZN3ccc7CC5x7y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x7y23pqrEv
  ~CC5x7y2(); // tgen
  CC5x7y2(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y2E) C1{ VBC2{ v3 v1 v2} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x7y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y23efgEv");}
void  ccc::CC5x7y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y23abcEv");}
void  ccc::CC5x7y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y23pqrEv");}
ccc::CC5x7y2 ::~CC5x7y2(){ note_dtor("_ZN3ccc7CC5x7y2E", this);} // tgen
ccc::CC5x7y2 ::CC5x7y2(){ note_ctor("_ZN3ccc7CC5x7y2E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y2E, buf);
    ::ccc::CC5x7y2 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y2E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y2E);
    dp->::ccc::CC5x7y2::~CC5x7y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y2E(Test__ZN3ccc7CC5x7y2E, "_ZN3ccc7CC5x7y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y2C1Ev();
extern void _ZN3ccc7CC5x7y2D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y2E[] = {
  NSPAIR(_ZN3ccc7CC5x7y2C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y2E[];
extern void _ZN3ccc7CC5x7y23abcEv();
extern void _ZN3ccc7CC5x7y23pqrEv();
extern void _ZN3ccc7CC5x7y23efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y23pqrEv,_ZTv0_n12_N3ccc7CC5x7y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y23pqrEv,_ZThn4_N3ccc7CC5x7y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y23efgEv,_ZTv0_n16_N3ccc7CC5x7y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y23efgEv,_ZThn4_N3ccc7CC5x7y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y23abcEv,_ZTv0_n20_N3ccc7CC5x7y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y23abcEv,_ZThn4_N3ccc7CC5x7y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y23efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y23pqrEv,_ZTv0_n12_N3ccc7CC5x7y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y23efgEv,_ZTv0_n16_N3ccc7CC5x7y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y23abcEv,_ZTv0_n20_N3ccc7CC5x7y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y2E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y2E[] = {
  {&(_ZTVN3ccc7CC5x7y2E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y2E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y2E[];
static VTBL_ENTRY alt_thunk_names120[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y23abcEv,_ZTv0_n20_N3ccc7CC5x7y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y23abcEv,_ZThn4_N3ccc7CC5x7y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y23efgEv,_ZTv0_n16_N3ccc7CC5x7y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y23efgEv,_ZThn4_N3ccc7CC5x7y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y23pqrEv,_ZTv0_n12_N3ccc7CC5x7y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y23pqrEv,_ZThn4_N3ccc7CC5x7y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y2E = {  "_ZN3ccc7CC5x7y2E", // class name
  bases__ZN3ccc7CC5x7y2E, 2,
  &(vtc__ZN3ccc7CC5x7y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y2E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names120,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y2  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7DD5x7y23efgEv
  virtual void  abc(); // _ZN3ccc7DD5x7y23abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x7y23pqrEv
  ~DD5x7y2(); // tgen
  DD5x7y2(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y2E) C1{ VBC2{ v3 v1 v2} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x7y2 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y23efgEv");}
void  ccc::DD5x7y2 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y23abcEv");}
void  ccc::DD5x7y2 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y23pqrEv");}
ccc::DD5x7y2 ::~DD5x7y2(){ note_dtor("_ZN3ccc7DD5x7y2E", this);} // tgen
ccc::DD5x7y2 ::DD5x7y2(){ note_ctor("_ZN3ccc7DD5x7y2E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y2E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y2E, buf);
    ::ccc::DD5x7y2 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y2E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y2E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y2E);
    dp->::ccc::DD5x7y2::~DD5x7y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y2E(Test__ZN3ccc7DD5x7y2E, "_ZN3ccc7DD5x7y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y2C1Ev();
extern void _ZN3ccc7DD5x7y2D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y2E[] = {
  NSPAIR(_ZN3ccc7DD5x7y2C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y2E[];
extern void _ZN3ccc7DD5x7y23pqrEv();
extern void _ZN3ccc7DD5x7y23efgEv();
extern void _ZN3ccc7DD5x7y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y23abcEv,_ZTv0_n12_N3ccc7DD5x7y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y23abcEv,_ZThn4_N3ccc7DD5x7y23abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y23pqrEv,_ZTv0_n16_N3ccc7DD5x7y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y23pqrEv,_ZThn4_N3ccc7DD5x7y23pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y23abcEv,_ZTv0_n12_N3ccc7DD5x7y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y23pqrEv,_ZTv0_n16_N3ccc7DD5x7y23pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y2E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y2E[] = {
  {&(_ZTVN3ccc7DD5x7y2E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y2E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y2E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y2E[];
static VTBL_ENTRY alt_thunk_names121[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y23pqrEv,_ZTv0_n16_N3ccc7DD5x7y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y23pqrEv,_ZThn4_N3ccc7DD5x7y23pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y23abcEv,_ZTv0_n12_N3ccc7DD5x7y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y23abcEv,_ZThn4_N3ccc7DD5x7y23abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y2E = {  "_ZN3ccc7DD5x7y2E", // class name
  bases__ZN3ccc7DD5x7y2E, 2,
  &(vtc__ZN3ccc7DD5x7y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y2E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names121,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y3  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC5x7y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x7y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x7y33abcEv
  ~CC5x7y3(); // tgen
  CC5x7y3(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y3E) C1{ VBC2{ v2 v1 v3} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x7y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y33efgEv");}
void  ccc::CC5x7y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y33pqrEv");}
void  ccc::CC5x7y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y33abcEv");}
ccc::CC5x7y3 ::~CC5x7y3(){ note_dtor("_ZN3ccc7CC5x7y3E", this);} // tgen
ccc::CC5x7y3 ::CC5x7y3(){ note_ctor("_ZN3ccc7CC5x7y3E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y3E, buf);
    ::ccc::CC5x7y3 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y3E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y3E);
    dp->::ccc::CC5x7y3::~CC5x7y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y3E(Test__ZN3ccc7CC5x7y3E, "_ZN3ccc7CC5x7y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y3C1Ev();
extern void _ZN3ccc7CC5x7y3D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y3E[] = {
  NSPAIR(_ZN3ccc7CC5x7y3C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y3E[];
extern void _ZN3ccc7CC5x7y33abcEv();
extern void _ZN3ccc7CC5x7y33pqrEv();
extern void _ZN3ccc7CC5x7y33efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y33pqrEv,_ZTv0_n12_N3ccc7CC5x7y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y33pqrEv,_ZThn4_N3ccc7CC5x7y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y33efgEv,_ZTv0_n16_N3ccc7CC5x7y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y33efgEv,_ZThn4_N3ccc7CC5x7y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y33abcEv,_ZTv0_n20_N3ccc7CC5x7y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y33abcEv,_ZThn4_N3ccc7CC5x7y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y33efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y33pqrEv,_ZTv0_n12_N3ccc7CC5x7y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y33efgEv,_ZTv0_n16_N3ccc7CC5x7y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y33abcEv,_ZTv0_n20_N3ccc7CC5x7y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y3E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y3E[] = {
  {&(_ZTVN3ccc7CC5x7y3E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y3E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y3E[];
static VTBL_ENTRY alt_thunk_names122[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y33abcEv,_ZTv0_n20_N3ccc7CC5x7y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y33abcEv,_ZThn4_N3ccc7CC5x7y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y33efgEv,_ZTv0_n16_N3ccc7CC5x7y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y33efgEv,_ZThn4_N3ccc7CC5x7y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y33pqrEv,_ZTv0_n12_N3ccc7CC5x7y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y33pqrEv,_ZThn4_N3ccc7CC5x7y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y3E = {  "_ZN3ccc7CC5x7y3E", // class name
  bases__ZN3ccc7CC5x7y3E, 2,
  &(vtc__ZN3ccc7CC5x7y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y3E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names122,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y3  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7DD5x7y33efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x7y33pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x7y33abcEv
  ~DD5x7y3(); // tgen
  DD5x7y3(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y3E) C1{ VBC2{ v2 v1 v3} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x7y3 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y33efgEv");}
void  ccc::DD5x7y3 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y33pqrEv");}
void  ccc::DD5x7y3 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y33abcEv");}
ccc::DD5x7y3 ::~DD5x7y3(){ note_dtor("_ZN3ccc7DD5x7y3E", this);} // tgen
ccc::DD5x7y3 ::DD5x7y3(){ note_ctor("_ZN3ccc7DD5x7y3E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y3E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y3E, buf);
    ::ccc::DD5x7y3 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y3E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y3E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y3E);
    dp->::ccc::DD5x7y3::~DD5x7y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y3E(Test__ZN3ccc7DD5x7y3E, "_ZN3ccc7DD5x7y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y3C1Ev();
extern void _ZN3ccc7DD5x7y3D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y3E[] = {
  NSPAIR(_ZN3ccc7DD5x7y3C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y3E[];
extern void _ZN3ccc7DD5x7y33pqrEv();
extern void _ZN3ccc7DD5x7y33efgEv();
extern void _ZN3ccc7DD5x7y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y33abcEv,_ZTv0_n12_N3ccc7DD5x7y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y33abcEv,_ZThn4_N3ccc7DD5x7y33abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y33pqrEv,_ZTv0_n16_N3ccc7DD5x7y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y33pqrEv,_ZThn4_N3ccc7DD5x7y33pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y33abcEv,_ZTv0_n12_N3ccc7DD5x7y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y33pqrEv,_ZTv0_n16_N3ccc7DD5x7y33pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y3E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y3E[] = {
  {&(_ZTVN3ccc7DD5x7y3E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y3E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y3E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y3E[];
static VTBL_ENTRY alt_thunk_names123[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y33pqrEv,_ZTv0_n16_N3ccc7DD5x7y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y33pqrEv,_ZThn4_N3ccc7DD5x7y33pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y33abcEv,_ZTv0_n12_N3ccc7DD5x7y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y33abcEv,_ZThn4_N3ccc7DD5x7y33abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y3E = {  "_ZN3ccc7DD5x7y3E", // class name
  bases__ZN3ccc7DD5x7y3E, 2,
  &(vtc__ZN3ccc7DD5x7y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y3E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names123,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y4  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc7CC5x7y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x7y43abcEv
  virtual void  efg(); // _ZN3ccc7CC5x7y43efgEv
  ~CC5x7y4(); // tgen
  CC5x7y4(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y4E) C1{ VBC2{ v1 v3 v2} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x7y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y43pqrEv");}
void  ccc::CC5x7y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y43abcEv");}
void  ccc::CC5x7y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y43efgEv");}
ccc::CC5x7y4 ::~CC5x7y4(){ note_dtor("_ZN3ccc7CC5x7y4E", this);} // tgen
ccc::CC5x7y4 ::CC5x7y4(){ note_ctor("_ZN3ccc7CC5x7y4E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y4E, buf);
    ::ccc::CC5x7y4 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y4E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y4E);
    dp->::ccc::CC5x7y4::~CC5x7y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y4E(Test__ZN3ccc7CC5x7y4E, "_ZN3ccc7CC5x7y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y4C1Ev();
extern void _ZN3ccc7CC5x7y4D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y4E[] = {
  NSPAIR(_ZN3ccc7CC5x7y4C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y4E[];
extern void _ZN3ccc7CC5x7y43abcEv();
extern void _ZN3ccc7CC5x7y43pqrEv();
extern void _ZN3ccc7CC5x7y43efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y43pqrEv,_ZTv0_n12_N3ccc7CC5x7y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y43pqrEv,_ZThn4_N3ccc7CC5x7y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y43efgEv,_ZTv0_n16_N3ccc7CC5x7y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y43efgEv,_ZThn4_N3ccc7CC5x7y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y43abcEv,_ZTv0_n20_N3ccc7CC5x7y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y43abcEv,_ZThn4_N3ccc7CC5x7y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y43efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y43pqrEv,_ZTv0_n12_N3ccc7CC5x7y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y43efgEv,_ZTv0_n16_N3ccc7CC5x7y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y43abcEv,_ZTv0_n20_N3ccc7CC5x7y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y4E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y4E[] = {
  {&(_ZTVN3ccc7CC5x7y4E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y4E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y4E[];
static VTBL_ENTRY alt_thunk_names124[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y43abcEv,_ZTv0_n20_N3ccc7CC5x7y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y43abcEv,_ZThn4_N3ccc7CC5x7y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y43efgEv,_ZTv0_n16_N3ccc7CC5x7y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y43efgEv,_ZThn4_N3ccc7CC5x7y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y43pqrEv,_ZTv0_n12_N3ccc7CC5x7y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y43pqrEv,_ZThn4_N3ccc7CC5x7y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y4E = {  "_ZN3ccc7CC5x7y4E", // class name
  bases__ZN3ccc7CC5x7y4E, 2,
  &(vtc__ZN3ccc7CC5x7y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y4E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names124,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y4  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc7DD5x7y43pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x7y43abcEv
  virtual void  efg(); // _ZN3ccc7DD5x7y43efgEv
  ~DD5x7y4(); // tgen
  DD5x7y4(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y4E) C1{ VBC2{ v1 v3 v2} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x7y4 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y43pqrEv");}
void  ccc::DD5x7y4 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y43abcEv");}
void  ccc::DD5x7y4 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y43efgEv");}
ccc::DD5x7y4 ::~DD5x7y4(){ note_dtor("_ZN3ccc7DD5x7y4E", this);} // tgen
ccc::DD5x7y4 ::DD5x7y4(){ note_ctor("_ZN3ccc7DD5x7y4E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y4E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y4E, buf);
    ::ccc::DD5x7y4 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y4E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y4E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y4E);
    dp->::ccc::DD5x7y4::~DD5x7y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y4E(Test__ZN3ccc7DD5x7y4E, "_ZN3ccc7DD5x7y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y4C1Ev();
extern void _ZN3ccc7DD5x7y4D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y4E[] = {
  NSPAIR(_ZN3ccc7DD5x7y4C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y4E[];
extern void _ZN3ccc7DD5x7y43pqrEv();
extern void _ZN3ccc7DD5x7y43efgEv();
extern void _ZN3ccc7DD5x7y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y43abcEv,_ZTv0_n12_N3ccc7DD5x7y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y43abcEv,_ZThn4_N3ccc7DD5x7y43abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y43pqrEv,_ZTv0_n16_N3ccc7DD5x7y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y43pqrEv,_ZThn4_N3ccc7DD5x7y43pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y43abcEv,_ZTv0_n12_N3ccc7DD5x7y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y43pqrEv,_ZTv0_n16_N3ccc7DD5x7y43pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y4E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y4E[] = {
  {&(_ZTVN3ccc7DD5x7y4E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y4E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y4E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y4E[];
static VTBL_ENTRY alt_thunk_names125[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y43pqrEv,_ZTv0_n16_N3ccc7DD5x7y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y43pqrEv,_ZThn4_N3ccc7DD5x7y43pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y43abcEv,_ZTv0_n12_N3ccc7DD5x7y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y43abcEv,_ZThn4_N3ccc7DD5x7y43abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y4E = {  "_ZN3ccc7DD5x7y4E", // class name
  bases__ZN3ccc7DD5x7y4E, 2,
  &(vtc__ZN3ccc7DD5x7y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y4E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names125,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y5  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc7CC5x7y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x7y53efgEv
  virtual void  abc(); // _ZN3ccc7CC5x7y53abcEv
  ~CC5x7y5(); // tgen
  CC5x7y5(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y5E) C1{ VBC2{ v1 v2 v3} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x7y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y53pqrEv");}
void  ccc::CC5x7y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y53efgEv");}
void  ccc::CC5x7y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y53abcEv");}
ccc::CC5x7y5 ::~CC5x7y5(){ note_dtor("_ZN3ccc7CC5x7y5E", this);} // tgen
ccc::CC5x7y5 ::CC5x7y5(){ note_ctor("_ZN3ccc7CC5x7y5E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y5E, buf);
    ::ccc::CC5x7y5 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y5E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y5E);
    dp->::ccc::CC5x7y5::~CC5x7y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y5E(Test__ZN3ccc7CC5x7y5E, "_ZN3ccc7CC5x7y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y5C1Ev();
extern void _ZN3ccc7CC5x7y5D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y5E[] = {
  NSPAIR(_ZN3ccc7CC5x7y5C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y5E[];
extern void _ZN3ccc7CC5x7y53abcEv();
extern void _ZN3ccc7CC5x7y53pqrEv();
extern void _ZN3ccc7CC5x7y53efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y53pqrEv,_ZTv0_n12_N3ccc7CC5x7y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y53pqrEv,_ZThn4_N3ccc7CC5x7y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y53efgEv,_ZTv0_n16_N3ccc7CC5x7y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y53efgEv,_ZThn4_N3ccc7CC5x7y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y53abcEv,_ZTv0_n20_N3ccc7CC5x7y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y53abcEv,_ZThn4_N3ccc7CC5x7y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y53efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y53pqrEv,_ZTv0_n12_N3ccc7CC5x7y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y53efgEv,_ZTv0_n16_N3ccc7CC5x7y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y53abcEv,_ZTv0_n20_N3ccc7CC5x7y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y5E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y5E[] = {
  {&(_ZTVN3ccc7CC5x7y5E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y5E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y5E[];
static VTBL_ENTRY alt_thunk_names126[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y53abcEv,_ZTv0_n20_N3ccc7CC5x7y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y53abcEv,_ZThn4_N3ccc7CC5x7y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y53efgEv,_ZTv0_n16_N3ccc7CC5x7y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y53efgEv,_ZThn4_N3ccc7CC5x7y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y53pqrEv,_ZTv0_n12_N3ccc7CC5x7y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y53pqrEv,_ZThn4_N3ccc7CC5x7y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y5E = {  "_ZN3ccc7CC5x7y5E", // class name
  bases__ZN3ccc7CC5x7y5E, 2,
  &(vtc__ZN3ccc7CC5x7y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y5E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names126,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y5  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc7DD5x7y53pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x7y53efgEv
  virtual void  abc(); // _ZN3ccc7DD5x7y53abcEv
  ~DD5x7y5(); // tgen
  DD5x7y5(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y5E) C1{ VBC2{ v1 v2 v3} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x7y5 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y53pqrEv");}
void  ccc::DD5x7y5 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y53efgEv");}
void  ccc::DD5x7y5 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y53abcEv");}
ccc::DD5x7y5 ::~DD5x7y5(){ note_dtor("_ZN3ccc7DD5x7y5E", this);} // tgen
ccc::DD5x7y5 ::DD5x7y5(){ note_ctor("_ZN3ccc7DD5x7y5E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y5E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y5E, buf);
    ::ccc::DD5x7y5 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y5E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y5E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y5E);
    dp->::ccc::DD5x7y5::~DD5x7y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y5E(Test__ZN3ccc7DD5x7y5E, "_ZN3ccc7DD5x7y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y5C1Ev();
extern void _ZN3ccc7DD5x7y5D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y5E[] = {
  NSPAIR(_ZN3ccc7DD5x7y5C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y5E[];
extern void _ZN3ccc7DD5x7y53pqrEv();
extern void _ZN3ccc7DD5x7y53efgEv();
extern void _ZN3ccc7DD5x7y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y53abcEv,_ZTv0_n12_N3ccc7DD5x7y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y53abcEv,_ZThn4_N3ccc7DD5x7y53abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y53pqrEv,_ZTv0_n16_N3ccc7DD5x7y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y53pqrEv,_ZThn4_N3ccc7DD5x7y53pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y53abcEv,_ZTv0_n12_N3ccc7DD5x7y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y53pqrEv,_ZTv0_n16_N3ccc7DD5x7y53pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y5E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y5E[] = {
  {&(_ZTVN3ccc7DD5x7y5E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y5E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y5E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y5E[];
static VTBL_ENTRY alt_thunk_names127[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y53pqrEv,_ZTv0_n16_N3ccc7DD5x7y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y53pqrEv,_ZThn4_N3ccc7DD5x7y53pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y53abcEv,_ZTv0_n12_N3ccc7DD5x7y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y53abcEv,_ZThn4_N3ccc7DD5x7y53abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y5E = {  "_ZN3ccc7DD5x7y5E", // class name
  bases__ZN3ccc7DD5x7y5E, 2,
  &(vtc__ZN3ccc7DD5x7y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y5E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names127,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y6  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC5x7y63abcEv
  virtual void  efg(); // _ZN3ccc7CC5x7y63efgEv
  ~CC5x7y6(); // tgen
  CC5x7y6(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y6E) C1{ VBC2{ v3 v2 v1} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x7y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y63abcEv");}
void  ccc::CC5x7y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y63efgEv");}
ccc::CC5x7y6 ::~CC5x7y6(){ note_dtor("_ZN3ccc7CC5x7y6E", this);} // tgen
ccc::CC5x7y6 ::CC5x7y6(){ note_ctor("_ZN3ccc7CC5x7y6E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y6E, buf);
    ::ccc::CC5x7y6 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y6E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y6E);
    dp->::ccc::CC5x7y6::~CC5x7y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y6E(Test__ZN3ccc7CC5x7y6E, "_ZN3ccc7CC5x7y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y6C1Ev();
extern void _ZN3ccc7CC5x7y6D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y6E[] = {
  NSPAIR(_ZN3ccc7CC5x7y6C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y6E[];
extern void _ZN3ccc7CC5x7y63abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc7CC5x7y63efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y63efgEv,_ZTv0_n16_N3ccc7CC5x7y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y63efgEv,_ZThn4_N3ccc7CC5x7y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y63abcEv,_ZTv0_n20_N3ccc7CC5x7y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y63abcEv,_ZThn4_N3ccc7CC5x7y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y63efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y63efgEv,_ZTv0_n16_N3ccc7CC5x7y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y63abcEv,_ZTv0_n20_N3ccc7CC5x7y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y6E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y6E[] = {
  {&(_ZTVN3ccc7CC5x7y6E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y6E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y6E[];
static VTBL_ENTRY alt_thunk_names128[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y63abcEv,_ZTv0_n20_N3ccc7CC5x7y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y63abcEv,_ZThn4_N3ccc7CC5x7y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y63efgEv,_ZTv0_n16_N3ccc7CC5x7y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y63efgEv,_ZThn4_N3ccc7CC5x7y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y6E = {  "_ZN3ccc7CC5x7y6E", // class name
  bases__ZN3ccc7CC5x7y6E, 2,
  &(vtc__ZN3ccc7CC5x7y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y6E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names128,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y6  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7DD5x7y63abcEv
  virtual void  efg(); // _ZN3ccc7DD5x7y63efgEv
  ~DD5x7y6(); // tgen
  DD5x7y6(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y6E) C1{ VBC2{ v3 v2 v1} VBC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x7y6 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y63abcEv");}
void  ccc::DD5x7y6 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y63efgEv");}
ccc::DD5x7y6 ::~DD5x7y6(){ note_dtor("_ZN3ccc7DD5x7y6E", this);} // tgen
ccc::DD5x7y6 ::DD5x7y6(){ note_ctor("_ZN3ccc7DD5x7y6E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y6E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y6E, buf);
    ::ccc::DD5x7y6 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y6E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y6E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y6E);
    dp->::ccc::DD5x7y6::~DD5x7y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y6E(Test__ZN3ccc7DD5x7y6E, "_ZN3ccc7DD5x7y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y6C1Ev();
extern void _ZN3ccc7DD5x7y6D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y6E[] = {
  NSPAIR(_ZN3ccc7DD5x7y6C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y6E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x7y63efgEv();
extern void _ZN3ccc7DD5x7y63abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y63abcEv,_ZTv0_n12_N3ccc7DD5x7y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y63abcEv,_ZThn4_N3ccc7DD5x7y63abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y63abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y63abcEv,_ZTv0_n12_N3ccc7DD5x7y63abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y6E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y6E[] = {
  {&(_ZTVN3ccc7DD5x7y6E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y6E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y6E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y6E[];
static VTBL_ENTRY alt_thunk_names129[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y63abcEv,_ZTv0_n12_N3ccc7DD5x7y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y63abcEv,_ZThn4_N3ccc7DD5x7y63abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y6E = {  "_ZN3ccc7DD5x7y6E", // class name
  bases__ZN3ccc7DD5x7y6E, 2,
  &(vtc__ZN3ccc7DD5x7y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y6E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names129,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y7  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC5x7y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x7y73pqrEv
  ~CC5x7y7(); // tgen
  CC5x7y7(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y7E) C1{ VBC2{ v2 v3 v1} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x7y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y73abcEv");}
void  ccc::CC5x7y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y73pqrEv");}
ccc::CC5x7y7 ::~CC5x7y7(){ note_dtor("_ZN3ccc7CC5x7y7E", this);} // tgen
ccc::CC5x7y7 ::CC5x7y7(){ note_ctor("_ZN3ccc7CC5x7y7E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y7E, buf);
    ::ccc::CC5x7y7 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y7E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y7E);
    dp->::ccc::CC5x7y7::~CC5x7y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y7E(Test__ZN3ccc7CC5x7y7E, "_ZN3ccc7CC5x7y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y7C1Ev();
extern void _ZN3ccc7CC5x7y7D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y7E[] = {
  NSPAIR(_ZN3ccc7CC5x7y7C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y7E[];
extern void _ZN3ccc7CC5x7y73abcEv();
extern void _ZN3ccc7CC5x7y73pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y73pqrEv,_ZTv0_n12_N3ccc7CC5x7y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y73pqrEv,_ZThn4_N3ccc7CC5x7y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y73abcEv,_ZTv0_n20_N3ccc7CC5x7y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y73abcEv,_ZThn4_N3ccc7CC5x7y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y73pqrEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y73pqrEv,_ZTv0_n12_N3ccc7CC5x7y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y73abcEv,_ZTv0_n20_N3ccc7CC5x7y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y7E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y7E[] = {
  {&(_ZTVN3ccc7CC5x7y7E[3]),  3,13},
  {&(_ZTVN3ccc7CC5x7y7E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y7E[];
static VTBL_ENTRY alt_thunk_names130[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y73abcEv,_ZTv0_n20_N3ccc7CC5x7y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y73abcEv,_ZThn4_N3ccc7CC5x7y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y73pqrEv,_ZTv0_n12_N3ccc7CC5x7y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y73pqrEv,_ZThn4_N3ccc7CC5x7y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y7E = {  "_ZN3ccc7CC5x7y7E", // class name
  bases__ZN3ccc7CC5x7y7E, 2,
  &(vtc__ZN3ccc7CC5x7y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y7E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names130,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y7  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7DD5x7y73abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x7y73pqrEv
  ~DD5x7y7(); // tgen
  DD5x7y7(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y7E) C1{ VBC2{ v2 v3 v1} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x7y7 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y73abcEv");}
void  ccc::DD5x7y7 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y73pqrEv");}
ccc::DD5x7y7 ::~DD5x7y7(){ note_dtor("_ZN3ccc7DD5x7y7E", this);} // tgen
ccc::DD5x7y7 ::DD5x7y7(){ note_ctor("_ZN3ccc7DD5x7y7E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y7E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y7E, buf);
    ::ccc::DD5x7y7 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y7E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y7E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y7E);
    dp->::ccc::DD5x7y7::~DD5x7y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y7E(Test__ZN3ccc7DD5x7y7E, "_ZN3ccc7DD5x7y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y7C1Ev();
extern void _ZN3ccc7DD5x7y7D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y7E[] = {
  NSPAIR(_ZN3ccc7DD5x7y7C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y7E[];
extern void _ZN3ccc7DD5x7y73pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc7DD5x7y73abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y73abcEv,_ZTv0_n12_N3ccc7DD5x7y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y73abcEv,_ZThn4_N3ccc7DD5x7y73abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y73pqrEv,_ZTv0_n16_N3ccc7DD5x7y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y73pqrEv,_ZThn4_N3ccc7DD5x7y73pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y73abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y73abcEv,_ZTv0_n12_N3ccc7DD5x7y73abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y73pqrEv,_ZTv0_n16_N3ccc7DD5x7y73pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y7E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y7E[] = {
  {&(_ZTVN3ccc7DD5x7y7E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y7E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y7E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y7E[];
static VTBL_ENTRY alt_thunk_names131[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y73pqrEv,_ZTv0_n16_N3ccc7DD5x7y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y73pqrEv,_ZThn4_N3ccc7DD5x7y73pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y73abcEv,_ZTv0_n12_N3ccc7DD5x7y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y73abcEv,_ZThn4_N3ccc7DD5x7y73abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y7E = {  "_ZN3ccc7DD5x7y7E", // class name
  bases__ZN3ccc7DD5x7y7E, 2,
  &(vtc__ZN3ccc7DD5x7y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y7E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names131,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y8  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC5x7y83efgEv
  virtual void  abc(); // _ZN3ccc7CC5x7y83abcEv
  ~CC5x7y8(); // tgen
  CC5x7y8(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y8E) C1{ VBC2{ v3 v1 v2} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x7y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y83efgEv");}
void  ccc::CC5x7y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x7y83abcEv");}
ccc::CC5x7y8 ::~CC5x7y8(){ note_dtor("_ZN3ccc7CC5x7y8E", this);} // tgen
ccc::CC5x7y8 ::CC5x7y8(){ note_ctor("_ZN3ccc7CC5x7y8E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y8E, buf);
    ::ccc::CC5x7y8 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y8E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y8E);
    dp->::ccc::CC5x7y8::~CC5x7y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y8E(Test__ZN3ccc7CC5x7y8E, "_ZN3ccc7CC5x7y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y8C1Ev();
extern void _ZN3ccc7CC5x7y8D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y8E[] = {
  NSPAIR(_ZN3ccc7CC5x7y8C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y8E[];
extern void _ZN3ccc7CC5x7y83abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc7CC5x7y83efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y83efgEv,_ZTv0_n16_N3ccc7CC5x7y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y83efgEv,_ZThn4_N3ccc7CC5x7y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x7y83abcEv,_ZTv0_n20_N3ccc7CC5x7y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y83abcEv,_ZThn4_N3ccc7CC5x7y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y83efgEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y83efgEv,_ZTv0_n16_N3ccc7CC5x7y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x7y83abcEv,_ZTv0_n20_N3ccc7CC5x7y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y8E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y8E[] = {
  {&(_ZTVN3ccc7CC5x7y8E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y8E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y8E[];
static VTBL_ENTRY alt_thunk_names132[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x7y83abcEv,_ZTv0_n20_N3ccc7CC5x7y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y83abcEv,_ZThn4_N3ccc7CC5x7y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y83efgEv,_ZTv0_n16_N3ccc7CC5x7y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y83efgEv,_ZThn4_N3ccc7CC5x7y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y8E = {  "_ZN3ccc7CC5x7y8E", // class name
  bases__ZN3ccc7CC5x7y8E, 2,
  &(vtc__ZN3ccc7CC5x7y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y8E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names132,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y8  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7DD5x7y83efgEv
  virtual void  abc(); // _ZN3ccc7DD5x7y83abcEv
  ~DD5x7y8(); // tgen
  DD5x7y8(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y8E) C1{ VBC2{ v3 v1 v2} VBC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x7y8 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y83efgEv");}
void  ccc::DD5x7y8 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x7y83abcEv");}
ccc::DD5x7y8 ::~DD5x7y8(){ note_dtor("_ZN3ccc7DD5x7y8E", this);} // tgen
ccc::DD5x7y8 ::DD5x7y8(){ note_ctor("_ZN3ccc7DD5x7y8E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y8E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y8E, buf);
    ::ccc::DD5x7y8 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y8E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y8E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y8E);
    dp->::ccc::DD5x7y8::~DD5x7y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y8E(Test__ZN3ccc7DD5x7y8E, "_ZN3ccc7DD5x7y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y8C1Ev();
extern void _ZN3ccc7DD5x7y8D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y8E[] = {
  NSPAIR(_ZN3ccc7DD5x7y8C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y8E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x7y83efgEv();
extern void _ZN3ccc7DD5x7y83abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x7y83abcEv,_ZTv0_n12_N3ccc7DD5x7y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y83abcEv,_ZThn4_N3ccc7DD5x7y83abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y83abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x7y83abcEv,_ZTv0_n12_N3ccc7DD5x7y83abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y8E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y8E[] = {
  {&(_ZTVN3ccc7DD5x7y8E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y8E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y8E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y8E[];
static VTBL_ENTRY alt_thunk_names133[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x7y83abcEv,_ZTv0_n12_N3ccc7DD5x7y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y83abcEv,_ZThn4_N3ccc7DD5x7y83abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y8E = {  "_ZN3ccc7DD5x7y8E", // class name
  bases__ZN3ccc7DD5x7y8E, 2,
  &(vtc__ZN3ccc7DD5x7y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y8E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names133,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y9  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC5x7y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x7y93pqrEv
  ~CC5x7y9(); // tgen
  CC5x7y9(); // tgen
};
//SIG(1 _ZN3ccc7CC5x7y9E) C1{ VBC2{ v2 v1 v3} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x7y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x7y93efgEv");}
void  ccc::CC5x7y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x7y93pqrEv");}
ccc::CC5x7y9 ::~CC5x7y9(){ note_dtor("_ZN3ccc7CC5x7y9E", this);} // tgen
ccc::CC5x7y9 ::CC5x7y9(){ note_ctor("_ZN3ccc7CC5x7y9E", this);} // tgen
}
static void Test__ZN3ccc7CC5x7y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x7y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x7y9E, buf);
    ::ccc::CC5x7y9 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x7y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x7y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x7y9E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc7CC5x7y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x7y9E);
    dp->::ccc::CC5x7y9::~CC5x7y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x7y9E(Test__ZN3ccc7CC5x7y9E, "_ZN3ccc7CC5x7y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x7y9C1Ev();
extern void _ZN3ccc7CC5x7y9D1Ev();
Name_Map name_map__ZN3ccc7CC5x7y9E[] = {
  NSPAIR(_ZN3ccc7CC5x7y9C1Ev),
  NSPAIR(_ZN3ccc7CC5x7y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC5x7y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y9E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc7CC5x7y93pqrEv();
extern void _ZN3ccc7CC5x7y93efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x7y93pqrEv,_ZTv0_n12_N3ccc7CC5x7y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y93pqrEv,_ZThn4_N3ccc7CC5x7y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x7y93efgEv,_ZTv0_n16_N3ccc7CC5x7y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x7y93efgEv,_ZThn4_N3ccc7CC5x7y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC5x7y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x7y93efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x7y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x7y93pqrEv,_ZTv0_n12_N3ccc7CC5x7y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x7y93efgEv,_ZTv0_n16_N3ccc7CC5x7y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x7y9E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x7y9E[] = {
  {&(_ZTVN3ccc7CC5x7y9E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x7y9E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x7y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x7y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x7y9E[];
static VTBL_ENTRY alt_thunk_names134[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x7y93efgEv,_ZTv0_n16_N3ccc7CC5x7y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y93efgEv,_ZThn4_N3ccc7CC5x7y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x7y93pqrEv,_ZTv0_n12_N3ccc7CC5x7y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x7y93pqrEv,_ZThn4_N3ccc7CC5x7y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x7y9E = {  "_ZN3ccc7CC5x7y9E", // class name
  bases__ZN3ccc7CC5x7y9E, 2,
  &(vtc__ZN3ccc7CC5x7y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x7y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x7y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x7y9E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x7y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names134,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y9  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7DD5x7y93efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x7y93pqrEv
  ~DD5x7y9(); // tgen
  DD5x7y9(); // tgen
};
//SIG(1 _ZN3ccc7DD5x7y9E) C1{ VBC2{ v2 v1 v3} VBC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x7y9 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x7y93efgEv");}
void  ccc::DD5x7y9 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x7y93pqrEv");}
ccc::DD5x7y9 ::~DD5x7y9(){ note_dtor("_ZN3ccc7DD5x7y9E", this);} // tgen
ccc::DD5x7y9 ::DD5x7y9(){ note_ctor("_ZN3ccc7DD5x7y9E", this);} // tgen
}
static void Test__ZN3ccc7DD5x7y9E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x7y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x7y9E, buf);
    ::ccc::DD5x7y9 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x7y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x7y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x7y9E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7DD5x7y9E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x7y9E);
    dp->::ccc::DD5x7y9::~DD5x7y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x7y9E(Test__ZN3ccc7DD5x7y9E, "_ZN3ccc7DD5x7y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x7y9C1Ev();
extern void _ZN3ccc7DD5x7y9D1Ev();
Name_Map name_map__ZN3ccc7DD5x7y9E[] = {
  NSPAIR(_ZN3ccc7DD5x7y9C1Ev),
  NSPAIR(_ZN3ccc7DD5x7y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7DD5x7y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y9E[];
extern void _ZN3ccc7DD5x7y93pqrEv();
extern void _ZN3ccc7DD5x7y93efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x7y93pqrEv,_ZTv0_n16_N3ccc7DD5x7y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x7y93pqrEv,_ZThn4_N3ccc7DD5x7y93pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x7y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x7y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x7y93pqrEv,_ZTv0_n16_N3ccc7DD5x7y93pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x7y9E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x7y9E[] = {
  {&(_ZTVN3ccc7DD5x7y9E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y9E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x7y9E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x7y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x7y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x7y9E[];
static VTBL_ENTRY alt_thunk_names135[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x7y93pqrEv,_ZTv0_n16_N3ccc7DD5x7y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x7y93pqrEv,_ZThn4_N3ccc7DD5x7y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x7y9E = {  "_ZN3ccc7DD5x7y9E", // class name
  bases__ZN3ccc7DD5x7y9E, 2,
  &(vtc__ZN3ccc7DD5x7y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x7y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x7y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x7y9E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x7y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names135,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y10  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC5x7y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC5x7y103abcEv
  ~CC5x7y10(); // tgen
  CC5x7y10(); // tgen
};
//SIG(1 _ZN3ccc8CC5x7y10E) C1{ VBC2{ v1 v3 v2} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x7y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x7y103pqrEv");}
void  ccc::CC5x7y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x7y103abcEv");}
ccc::CC5x7y10 ::~CC5x7y10(){ note_dtor("_ZN3ccc8CC5x7y10E", this);} // tgen
ccc::CC5x7y10 ::CC5x7y10(){ note_ctor("_ZN3ccc8CC5x7y10E", this);} // tgen
}
static void Test__ZN3ccc8CC5x7y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x7y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x7y10E, buf);
    ::ccc::CC5x7y10 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x7y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x7y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x7y10E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC5x7y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x7y10E);
    dp->::ccc::CC5x7y10::~CC5x7y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x7y10E(Test__ZN3ccc8CC5x7y10E, "_ZN3ccc8CC5x7y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x7y10C1Ev();
extern void _ZN3ccc8CC5x7y10D1Ev();
Name_Map name_map__ZN3ccc8CC5x7y10E[] = {
  NSPAIR(_ZN3ccc8CC5x7y10C1Ev),
  NSPAIR(_ZN3ccc8CC5x7y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC5x7y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y10E[];
extern void _ZN3ccc8CC5x7y103abcEv();
extern void _ZN3ccc8CC5x7y103pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x7y103pqrEv,_ZTv0_n12_N3ccc8CC5x7y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x7y103pqrEv,_ZThn4_N3ccc8CC5x7y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x7y103abcEv,_ZTv0_n20_N3ccc8CC5x7y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x7y103abcEv,_ZThn4_N3ccc8CC5x7y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x7y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x7y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x7y103pqrEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x7y103pqrEv,_ZTv0_n12_N3ccc8CC5x7y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x7y103abcEv,_ZTv0_n20_N3ccc8CC5x7y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x7y10E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x7y10E[] = {
  {&(_ZTVN3ccc8CC5x7y10E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x7y10E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x7y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x7y10E[];
static VTBL_ENTRY alt_thunk_names136[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x7y103abcEv,_ZTv0_n20_N3ccc8CC5x7y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x7y103abcEv,_ZThn4_N3ccc8CC5x7y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x7y103pqrEv,_ZTv0_n12_N3ccc8CC5x7y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x7y103pqrEv,_ZThn4_N3ccc8CC5x7y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x7y10E = {  "_ZN3ccc8CC5x7y10E", // class name
  bases__ZN3ccc8CC5x7y10E, 2,
  &(vtc__ZN3ccc8CC5x7y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x7y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x7y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x7y10E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x7y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names136,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y10  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8DD5x7y103pqrEv
  virtual void  abc(); // _ZN3ccc8DD5x7y103abcEv
  ~DD5x7y10(); // tgen
  DD5x7y10(); // tgen
};
//SIG(1 _ZN3ccc8DD5x7y10E) C1{ VBC2{ v1 v3 v2} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x7y10 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x7y103pqrEv");}
void  ccc::DD5x7y10 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x7y103abcEv");}
ccc::DD5x7y10 ::~DD5x7y10(){ note_dtor("_ZN3ccc8DD5x7y10E", this);} // tgen
ccc::DD5x7y10 ::DD5x7y10(){ note_ctor("_ZN3ccc8DD5x7y10E", this);} // tgen
}
static void Test__ZN3ccc8DD5x7y10E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x7y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x7y10E, buf);
    ::ccc::DD5x7y10 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x7y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x7y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x7y10E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD5x7y10E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x7y10E);
    dp->::ccc::DD5x7y10::~DD5x7y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x7y10E(Test__ZN3ccc8DD5x7y10E, "_ZN3ccc8DD5x7y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x7y10C1Ev();
extern void _ZN3ccc8DD5x7y10D1Ev();
Name_Map name_map__ZN3ccc8DD5x7y10E[] = {
  NSPAIR(_ZN3ccc8DD5x7y10C1Ev),
  NSPAIR(_ZN3ccc8DD5x7y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD5x7y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y10E[];
extern void _ZN3ccc8DD5x7y103pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x7y103abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x7y103abcEv,_ZTv0_n12_N3ccc8DD5x7y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x7y103abcEv,_ZThn4_N3ccc8DD5x7y103abcEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x7y103pqrEv,_ZTv0_n16_N3ccc8DD5x7y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x7y103pqrEv,_ZThn4_N3ccc8DD5x7y103pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x7y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x7y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x7y103abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x7y103abcEv,_ZTv0_n12_N3ccc8DD5x7y103abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x7y103pqrEv,_ZTv0_n16_N3ccc8DD5x7y103pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x7y10E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x7y10E[] = {
  {&(_ZTVN3ccc8DD5x7y10E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y10E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y10E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x7y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x7y10E[];
static VTBL_ENTRY alt_thunk_names137[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x7y103pqrEv,_ZTv0_n16_N3ccc8DD5x7y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x7y103pqrEv,_ZThn4_N3ccc8DD5x7y103pqrEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x7y103abcEv,_ZTv0_n12_N3ccc8DD5x7y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x7y103abcEv,_ZThn4_N3ccc8DD5x7y103abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x7y10E = {  "_ZN3ccc8DD5x7y10E", // class name
  bases__ZN3ccc8DD5x7y10E, 2,
  &(vtc__ZN3ccc8DD5x7y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x7y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x7y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x7y10E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x7y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names137,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y11  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC5x7y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC5x7y113efgEv
  ~CC5x7y11(); // tgen
  CC5x7y11(); // tgen
};
//SIG(1 _ZN3ccc8CC5x7y11E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x7y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x7y113pqrEv");}
void  ccc::CC5x7y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x7y113efgEv");}
ccc::CC5x7y11 ::~CC5x7y11(){ note_dtor("_ZN3ccc8CC5x7y11E", this);} // tgen
ccc::CC5x7y11 ::CC5x7y11(){ note_ctor("_ZN3ccc8CC5x7y11E", this);} // tgen
}
static void Test__ZN3ccc8CC5x7y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x7y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x7y11E, buf);
    ::ccc::CC5x7y11 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x7y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x7y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x7y11E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC5x7y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x7y11E);
    dp->::ccc::CC5x7y11::~CC5x7y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x7y11E(Test__ZN3ccc8CC5x7y11E, "_ZN3ccc8CC5x7y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x7y11C1Ev();
extern void _ZN3ccc8CC5x7y11D1Ev();
Name_Map name_map__ZN3ccc8CC5x7y11E[] = {
  NSPAIR(_ZN3ccc8CC5x7y11C1Ev),
  NSPAIR(_ZN3ccc8CC5x7y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC5x7y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y11E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc8CC5x7y113pqrEv();
extern void _ZN3ccc8CC5x7y113efgEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x7y113pqrEv,_ZTv0_n12_N3ccc8CC5x7y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x7y113pqrEv,_ZThn4_N3ccc8CC5x7y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x7y113efgEv,_ZTv0_n16_N3ccc8CC5x7y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x7y113efgEv,_ZThn4_N3ccc8CC5x7y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x7y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x7y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x7y113efgEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x7y113pqrEv,_ZTv0_n12_N3ccc8CC5x7y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x7y113efgEv,_ZTv0_n16_N3ccc8CC5x7y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x7y11E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x7y11E[] = {
  {&(_ZTVN3ccc8CC5x7y11E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x7y11E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x7y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x7y11E[];
static VTBL_ENTRY alt_thunk_names138[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x7y113efgEv,_ZTv0_n16_N3ccc8CC5x7y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x7y113efgEv,_ZThn4_N3ccc8CC5x7y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x7y113pqrEv,_ZTv0_n12_N3ccc8CC5x7y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x7y113pqrEv,_ZThn4_N3ccc8CC5x7y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x7y11E = {  "_ZN3ccc8CC5x7y11E", // class name
  bases__ZN3ccc8CC5x7y11E, 2,
  &(vtc__ZN3ccc8CC5x7y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x7y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x7y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x7y11E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x7y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names138,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y11  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8DD5x7y113pqrEv
  virtual void  efg(); // _ZN3ccc8DD5x7y113efgEv
  ~DD5x7y11(); // tgen
  DD5x7y11(); // tgen
};
//SIG(1 _ZN3ccc8DD5x7y11E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x7y11 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x7y113pqrEv");}
void  ccc::DD5x7y11 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x7y113efgEv");}
ccc::DD5x7y11 ::~DD5x7y11(){ note_dtor("_ZN3ccc8DD5x7y11E", this);} // tgen
ccc::DD5x7y11 ::DD5x7y11(){ note_ctor("_ZN3ccc8DD5x7y11E", this);} // tgen
}
static void Test__ZN3ccc8DD5x7y11E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x7y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x7y11E, buf);
    ::ccc::DD5x7y11 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x7y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x7y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x7y11E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD5x7y11E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x7y11E);
    dp->::ccc::DD5x7y11::~DD5x7y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x7y11E(Test__ZN3ccc8DD5x7y11E, "_ZN3ccc8DD5x7y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x7y11C1Ev();
extern void _ZN3ccc8DD5x7y11D1Ev();
Name_Map name_map__ZN3ccc8DD5x7y11E[] = {
  NSPAIR(_ZN3ccc8DD5x7y11C1Ev),
  NSPAIR(_ZN3ccc8DD5x7y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD5x7y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y11E[];
extern void _ZN3ccc8DD5x7y113pqrEv();
extern void _ZN3ccc8DD5x7y113efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x7y113pqrEv,_ZTv0_n16_N3ccc8DD5x7y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x7y113pqrEv,_ZThn4_N3ccc8DD5x7y113pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x7y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x7y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x7y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x7y113pqrEv,_ZTv0_n16_N3ccc8DD5x7y113pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x7y11E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x7y11E[] = {
  {&(_ZTVN3ccc8DD5x7y11E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y11E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y11E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x7y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x7y11E[];
static VTBL_ENTRY alt_thunk_names139[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x7y113pqrEv,_ZTv0_n16_N3ccc8DD5x7y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x7y113pqrEv,_ZThn4_N3ccc8DD5x7y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x7y11E = {  "_ZN3ccc8DD5x7y11E", // class name
  bases__ZN3ccc8DD5x7y11E, 2,
  &(vtc__ZN3ccc8DD5x7y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x7y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x7y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x7y11E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x7y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names139,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y12  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8CC5x7y123abcEv
  ~CC5x7y12(); // tgen
  CC5x7y12(); // tgen
};
//SIG(1 _ZN3ccc8CC5x7y12E) C1{ VBC2{ v2 v3 v1} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC5x7y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x7y123abcEv");}
ccc::CC5x7y12 ::~CC5x7y12(){ note_dtor("_ZN3ccc8CC5x7y12E", this);} // tgen
ccc::CC5x7y12 ::CC5x7y12(){ note_ctor("_ZN3ccc8CC5x7y12E", this);} // tgen
}
static void Test__ZN3ccc8CC5x7y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x7y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x7y12E, buf);
    ::ccc::CC5x7y12 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x7y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x7y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x7y12E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC5x7y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x7y12E);
    dp->::ccc::CC5x7y12::~CC5x7y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x7y12E(Test__ZN3ccc8CC5x7y12E, "_ZN3ccc8CC5x7y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x7y12C1Ev();
extern void _ZN3ccc8CC5x7y12D1Ev();
Name_Map name_map__ZN3ccc8CC5x7y12E[] = {
  NSPAIR(_ZN3ccc8CC5x7y12C1Ev),
  NSPAIR(_ZN3ccc8CC5x7y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC5x7y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y12E[];
extern void _ZN3ccc8CC5x7y123abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x7y123abcEv,_ZTv0_n20_N3ccc8CC5x7y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x7y123abcEv,_ZThn4_N3ccc8CC5x7y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x7y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x7y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x7y123abcEv,_ZTv0_n20_N3ccc8CC5x7y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x7y12E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x7y12E[] = {
  {&(_ZTVN3ccc8CC5x7y12E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x7y12E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x7y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x7y12E[];
static VTBL_ENTRY alt_thunk_names140[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x7y123abcEv,_ZTv0_n20_N3ccc8CC5x7y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x7y123abcEv,_ZThn4_N3ccc8CC5x7y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x7y12E = {  "_ZN3ccc8CC5x7y12E", // class name
  bases__ZN3ccc8CC5x7y12E, 2,
  &(vtc__ZN3ccc8CC5x7y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x7y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x7y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x7y12E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x7y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names140,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y12  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8DD5x7y123abcEv
  ~DD5x7y12(); // tgen
  DD5x7y12(); // tgen
};
//SIG(1 _ZN3ccc8DD5x7y12E) C1{ VBC2{ v2 v3 v1} VBC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::DD5x7y12 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x7y123abcEv");}
ccc::DD5x7y12 ::~DD5x7y12(){ note_dtor("_ZN3ccc8DD5x7y12E", this);} // tgen
ccc::DD5x7y12 ::DD5x7y12(){ note_ctor("_ZN3ccc8DD5x7y12E", this);} // tgen
}
static void Test__ZN3ccc8DD5x7y12E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x7y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x7y12E, buf);
    ::ccc::DD5x7y12 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x7y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x7y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x7y12E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD5x7y12E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x7y12E);
    dp->::ccc::DD5x7y12::~DD5x7y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x7y12E(Test__ZN3ccc8DD5x7y12E, "_ZN3ccc8DD5x7y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x7y12C1Ev();
extern void _ZN3ccc8DD5x7y12D1Ev();
Name_Map name_map__ZN3ccc8DD5x7y12E[] = {
  NSPAIR(_ZN3ccc8DD5x7y12C1Ev),
  NSPAIR(_ZN3ccc8DD5x7y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD5x7y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y12E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x7y123abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x7y123abcEv,_ZTv0_n12_N3ccc8DD5x7y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x7y123abcEv,_ZThn4_N3ccc8DD5x7y123abcEv)() __attribute__((weak));
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x7y12E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x7y123abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x7y123abcEv,_ZTv0_n12_N3ccc8DD5x7y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x7y12E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x7y12E[] = {
  {&(_ZTVN3ccc8DD5x7y12E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y12E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y12E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x7y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x7y12E[];
static VTBL_ENTRY alt_thunk_names141[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x7y123abcEv,_ZTv0_n12_N3ccc8DD5x7y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x7y123abcEv,_ZThn4_N3ccc8DD5x7y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x7y12E = {  "_ZN3ccc8DD5x7y12E", // class name
  bases__ZN3ccc8DD5x7y12E, 2,
  &(vtc__ZN3ccc8DD5x7y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x7y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x7y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x7y12E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x7y12E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names141,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y13  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8CC5x7y133efgEv
  ~CC5x7y13(); // tgen
  CC5x7y13(); // tgen
};
//SIG(1 _ZN3ccc8CC5x7y13E) C1{ VBC2{ v2 v1 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC5x7y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x7y133efgEv");}
ccc::CC5x7y13 ::~CC5x7y13(){ note_dtor("_ZN3ccc8CC5x7y13E", this);} // tgen
ccc::CC5x7y13 ::CC5x7y13(){ note_ctor("_ZN3ccc8CC5x7y13E", this);} // tgen
}
static void Test__ZN3ccc8CC5x7y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x7y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x7y13E, buf);
    ::ccc::CC5x7y13 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x7y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x7y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x7y13E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC5x7y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x7y13E);
    dp->::ccc::CC5x7y13::~CC5x7y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x7y13E(Test__ZN3ccc8CC5x7y13E, "_ZN3ccc8CC5x7y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x7y13C1Ev();
extern void _ZN3ccc8CC5x7y13D1Ev();
Name_Map name_map__ZN3ccc8CC5x7y13E[] = {
  NSPAIR(_ZN3ccc8CC5x7y13C1Ev),
  NSPAIR(_ZN3ccc8CC5x7y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC5x7y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y13E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc8CC5x7y133efgEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x7y133efgEv,_ZTv0_n16_N3ccc8CC5x7y133efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x7y133efgEv,_ZThn4_N3ccc8CC5x7y133efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x7y13E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x7y133efgEv,
  0,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x7y133efgEv,_ZTv0_n16_N3ccc8CC5x7y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x7y13E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x7y13E[] = {
  {&(_ZTVN3ccc8CC5x7y13E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x7y13E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x7y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x7y13E[];
static VTBL_ENTRY alt_thunk_names142[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x7y133efgEv,_ZTv0_n16_N3ccc8CC5x7y133efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x7y133efgEv,_ZThn4_N3ccc8CC5x7y133efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x7y13E = {  "_ZN3ccc8CC5x7y13E", // class name
  bases__ZN3ccc8CC5x7y13E, 2,
  &(vtc__ZN3ccc8CC5x7y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x7y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x7y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x7y13E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x7y13E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names142,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y13  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8DD5x7y133efgEv
  ~DD5x7y13(); // tgen
  DD5x7y13(); // tgen
};
//SIG(1 _ZN3ccc8DD5x7y13E) C1{ VBC2{ v2 v1 v3} VBC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::DD5x7y13 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x7y133efgEv");}
ccc::DD5x7y13 ::~DD5x7y13(){ note_dtor("_ZN3ccc8DD5x7y13E", this);} // tgen
ccc::DD5x7y13 ::DD5x7y13(){ note_ctor("_ZN3ccc8DD5x7y13E", this);} // tgen
}
static void Test__ZN3ccc8DD5x7y13E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x7y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x7y13E, buf);
    ::ccc::DD5x7y13 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x7y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x7y13E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x7y13E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD5x7y13E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x7y13E);
    dp->::ccc::DD5x7y13::~DD5x7y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x7y13E(Test__ZN3ccc8DD5x7y13E, "_ZN3ccc8DD5x7y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x7y13C1Ev();
extern void _ZN3ccc8DD5x7y13D1Ev();
Name_Map name_map__ZN3ccc8DD5x7y13E[] = {
  NSPAIR(_ZN3ccc8DD5x7y13C1Ev),
  NSPAIR(_ZN3ccc8DD5x7y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD5x7y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y13E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc8DD5x7y133efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x7y13E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x7y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x7y13E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x7y13E[] = {
  {&(_ZTVN3ccc8DD5x7y13E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y13E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y13E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x7y13E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x7y13E[];
Class_Descriptor cd__ZN3ccc8DD5x7y13E = {  "_ZN3ccc8DD5x7y13E", // class name
  bases__ZN3ccc8DD5x7y13E, 2,
  &(vtc__ZN3ccc8DD5x7y13E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x7y13E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x7y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x7y13E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x7y13E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y14  : virtual ::ccc::AA5 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC5x7y143pqrEv
  ~CC5x7y14(); // tgen
  CC5x7y14(); // tgen
};
//SIG(1 _ZN3ccc8CC5x7y14E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC5x7y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x7y143pqrEv");}
ccc::CC5x7y14 ::~CC5x7y14(){ note_dtor("_ZN3ccc8CC5x7y14E", this);} // tgen
ccc::CC5x7y14 ::CC5x7y14(){ note_ctor("_ZN3ccc8CC5x7y14E", this);} // tgen
}
static void Test__ZN3ccc8CC5x7y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x7y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x7y14E, buf);
    ::ccc::CC5x7y14 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x7y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x7y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x7y14E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC5x7y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x7y14E);
    dp->::ccc::CC5x7y14::~CC5x7y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x7y14E(Test__ZN3ccc8CC5x7y14E, "_ZN3ccc8CC5x7y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x7y14C1Ev();
extern void _ZN3ccc8CC5x7y14D1Ev();
Name_Map name_map__ZN3ccc8CC5x7y14E[] = {
  NSPAIR(_ZN3ccc8CC5x7y14C1Ev),
  NSPAIR(_ZN3ccc8CC5x7y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC5x7y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y14E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc8CC5x7y143pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x7y143pqrEv,_ZTv0_n12_N3ccc8CC5x7y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x7y143pqrEv,_ZThn4_N3ccc8CC5x7y143pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x7y14E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x7y143pqrEv,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x7y143pqrEv,_ZTv0_n12_N3ccc8CC5x7y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x7y14E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x7y14E[] = {
  {&(_ZTVN3ccc8CC5x7y14E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x7y14E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x7y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x7y14E[];
static VTBL_ENTRY alt_thunk_names143[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x7y143pqrEv,_ZTv0_n12_N3ccc8CC5x7y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x7y143pqrEv,_ZThn4_N3ccc8CC5x7y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x7y14E = {  "_ZN3ccc8CC5x7y14E", // class name
  bases__ZN3ccc8CC5x7y14E, 2,
  &(vtc__ZN3ccc8CC5x7y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x7y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x7y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x7y14E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x7y14E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names143,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y14  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8DD5x7y143pqrEv
  ~DD5x7y14(); // tgen
  DD5x7y14(); // tgen
};
//SIG(1 _ZN3ccc8DD5x7y14E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::DD5x7y14 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x7y143pqrEv");}
ccc::DD5x7y14 ::~DD5x7y14(){ note_dtor("_ZN3ccc8DD5x7y14E", this);} // tgen
ccc::DD5x7y14 ::DD5x7y14(){ note_ctor("_ZN3ccc8DD5x7y14E", this);} // tgen
}
static void Test__ZN3ccc8DD5x7y14E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x7y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x7y14E, buf);
    ::ccc::DD5x7y14 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x7y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x7y14E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x7y14E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD5x7y14E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x7y14E);
    dp->::ccc::DD5x7y14::~DD5x7y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x7y14E(Test__ZN3ccc8DD5x7y14E, "_ZN3ccc8DD5x7y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x7y14C1Ev();
extern void _ZN3ccc8DD5x7y14D1Ev();
Name_Map name_map__ZN3ccc8DD5x7y14E[] = {
  NSPAIR(_ZN3ccc8DD5x7y14C1Ev),
  NSPAIR(_ZN3ccc8DD5x7y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD5x7y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y14E[];
extern void _ZN3ccc8DD5x7y143pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x7y143pqrEv,_ZTv0_n16_N3ccc8DD5x7y143pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x7y143pqrEv,_ZThn4_N3ccc8DD5x7y143pqrEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x7y14E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x7y143pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x7y143pqrEv,_ZTv0_n16_N3ccc8DD5x7y143pqrEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x7y14E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x7y14E[] = {
  {&(_ZTVN3ccc8DD5x7y14E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y14E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y14E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x7y14E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x7y14E[];
static VTBL_ENTRY alt_thunk_names144[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x7y143pqrEv,_ZTv0_n16_N3ccc8DD5x7y143pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x7y143pqrEv,_ZThn4_N3ccc8DD5x7y143pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x7y14E = {  "_ZN3ccc8DD5x7y14E", // class name
  bases__ZN3ccc8DD5x7y14E, 2,
  &(vtc__ZN3ccc8DD5x7y14E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x7y14E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x7y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x7y14E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x7y14E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names144,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x7y15  : virtual ::ccc::AA5 , ::ccc::BB7 {
  ~CC5x7y15(); // tgen
  CC5x7y15(); // tgen
};
//SIG(1 _ZN3ccc8CC5x7y15E) C1{ VBC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC5x7y15 ::~CC5x7y15(){ note_dtor("_ZN3ccc8CC5x7y15E", this);} // tgen
ccc::CC5x7y15 ::CC5x7y15(){ note_ctor("_ZN3ccc8CC5x7y15E", this);} // tgen
}
static void Test__ZN3ccc8CC5x7y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x7y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x7y15E, buf);
    ::ccc::CC5x7y15 *dp, &lv = *(dp=new (buf) ::ccc::CC5x7y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x7y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x7y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x7y15E");
    check_base_class_offset(lv, (::ccc::BB7*), 0, "_ZN3ccc8CC5x7y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x7y15E);
    dp->::ccc::CC5x7y15::~CC5x7y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x7y15E(Test__ZN3ccc8CC5x7y15E, "_ZN3ccc8CC5x7y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x7y15C1Ev();
extern void _ZN3ccc8CC5x7y15D1Ev();
Name_Map name_map__ZN3ccc8CC5x7y15E[] = {
  NSPAIR(_ZN3ccc8CC5x7y15C1Ev),
  NSPAIR(_ZN3ccc8CC5x7y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC5x7y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y15E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x7y15E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x7y15E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x7y15E[] = {
  {&(_ZTVN3ccc8CC5x7y15E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x7y15E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x7y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x7y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x7y15E[];
Class_Descriptor cd__ZN3ccc8CC5x7y15E = {  "_ZN3ccc8CC5x7y15E", // class name
  bases__ZN3ccc8CC5x7y15E, 2,
  &(vtc__ZN3ccc8CC5x7y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x7y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x7y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x7y15E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x7y15E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x7y15  : virtual ::ccc::AA5 , virtual ::ccc::BB7 {
  ~DD5x7y15(); // tgen
  DD5x7y15(); // tgen
};
//SIG(1 _ZN3ccc8DD5x7y15E) C1{ VBC2{ v1 v2 v3} VBC3{ v4 v5}}
}
namespace ccc { 
ccc::DD5x7y15 ::~DD5x7y15(){ note_dtor("_ZN3ccc8DD5x7y15E", this);} // tgen
ccc::DD5x7y15 ::DD5x7y15(){ note_ctor("_ZN3ccc8DD5x7y15E", this);} // tgen
}
static void Test__ZN3ccc8DD5x7y15E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x7y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x7y15E, buf);
    ::ccc::DD5x7y15 *dp, &lv = *(dp=new (buf) ::ccc::DD5x7y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x7y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x7y15E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x7y15E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8DD5x7y15E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x7y15E);
    dp->::ccc::DD5x7y15::~DD5x7y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x7y15E(Test__ZN3ccc8DD5x7y15E, "_ZN3ccc8DD5x7y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x7y15C1Ev();
extern void _ZN3ccc8DD5x7y15D1Ev();
Name_Map name_map__ZN3ccc8DD5x7y15E[] = {
  NSPAIR(_ZN3ccc8DD5x7y15C1Ev),
  NSPAIR(_ZN3ccc8DD5x7y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8DD5x7y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y15E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x7y15E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x7y15E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x7y15E[] = {
  {&(_ZTVN3ccc8DD5x7y15E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y15E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x7y15E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x7y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x7y15E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x7y15E[];
Class_Descriptor cd__ZN3ccc8DD5x7y15E = {  "_ZN3ccc8DD5x7y15E", // class name
  bases__ZN3ccc8DD5x7y15E, 2,
  &(vtc__ZN3ccc8DD5x7y15E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x7y15E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x7y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x7y15E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x7y15E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y0  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC5x8y03abcEv
  virtual void  efg(); // _ZN3ccc7CC5x8y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x8y03pqrEv
  ~CC5x8y0(); // tgen
  CC5x8y0(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y0E) C1{ VBC2{ v3 v2 v1} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x8y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y03abcEv");}
void  ccc::CC5x8y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y03efgEv");}
void  ccc::CC5x8y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y03pqrEv");}
ccc::CC5x8y0 ::~CC5x8y0(){ note_dtor("_ZN3ccc7CC5x8y0E", this);} // tgen
ccc::CC5x8y0 ::CC5x8y0(){ note_ctor("_ZN3ccc7CC5x8y0E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y0E, buf);
    ::ccc::CC5x8y0 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y0E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y0E);
    dp->::ccc::CC5x8y0::~CC5x8y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y0E(Test__ZN3ccc7CC5x8y0E, "_ZN3ccc7CC5x8y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y0C1Ev();
extern void _ZN3ccc7CC5x8y0D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y0E[] = {
  NSPAIR(_ZN3ccc7CC5x8y0C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y0E[];
extern void _ZN3ccc7CC5x8y03efgEv();
extern void _ZN3ccc7CC5x8y03abcEv();
extern void _ZN3ccc7CC5x8y03pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y03pqrEv,_ZTv0_n12_N3ccc7CC5x8y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y03pqrEv,_ZThn4_N3ccc7CC5x8y03pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y03efgEv,_ZTv0_n16_N3ccc7CC5x8y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y03efgEv,_ZThn4_N3ccc7CC5x8y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y03abcEv,_ZTv0_n20_N3ccc7CC5x8y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y03abcEv,_ZThn4_N3ccc7CC5x8y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y0E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y03pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y03pqrEv,_ZTv0_n12_N3ccc7CC5x8y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y03efgEv,_ZTv0_n16_N3ccc7CC5x8y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y03abcEv,_ZTv0_n20_N3ccc7CC5x8y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y0E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y0E[] = {
  {&(_ZTVN3ccc7CC5x8y0E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y0E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y0E[];
static VTBL_ENTRY alt_thunk_names145[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y03abcEv,_ZTv0_n20_N3ccc7CC5x8y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y03abcEv,_ZThn4_N3ccc7CC5x8y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y03efgEv,_ZTv0_n16_N3ccc7CC5x8y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y03efgEv,_ZThn4_N3ccc7CC5x8y03efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y03pqrEv,_ZTv0_n12_N3ccc7CC5x8y03pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y03pqrEv,_ZThn4_N3ccc7CC5x8y03pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y0E = {  "_ZN3ccc7CC5x8y0E", // class name
  bases__ZN3ccc7CC5x8y0E, 2,
  &(vtc__ZN3ccc7CC5x8y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y0E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y0E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names145,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y0  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7DD5x8y03abcEv
  virtual void  efg(); // _ZN3ccc7DD5x8y03efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x8y03pqrEv
  ~DD5x8y0(); // tgen
  DD5x8y0(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y0E) C1{ VBC2{ v3 v2 v1} VBC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x8y0 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y03abcEv");}
void  ccc::DD5x8y0 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y03efgEv");}
void  ccc::DD5x8y0 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y03pqrEv");}
ccc::DD5x8y0 ::~DD5x8y0(){ note_dtor("_ZN3ccc7DD5x8y0E", this);} // tgen
ccc::DD5x8y0 ::DD5x8y0(){ note_ctor("_ZN3ccc7DD5x8y0E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y0E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y0E, buf);
    ::ccc::DD5x8y0 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y0E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y0E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y0E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y0E);
    dp->::ccc::DD5x8y0::~DD5x8y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y0E(Test__ZN3ccc7DD5x8y0E, "_ZN3ccc7DD5x8y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y0C1Ev();
extern void _ZN3ccc7DD5x8y0D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y0E[] = {
  NSPAIR(_ZN3ccc7DD5x8y0C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y0E[];
extern void _ZN3ccc7DD5x8y03pqrEv();
extern void _ZN3ccc7DD5x8y03efgEv();
extern void _ZN3ccc7DD5x8y03abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y03efgEv,_ZTv0_n12_N3ccc7DD5x8y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y03efgEv,_ZThn4_N3ccc7DD5x8y03efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y03abcEv,_ZTv0_n16_N3ccc7DD5x8y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y03abcEv,_ZThn4_N3ccc7DD5x8y03abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y0E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y03pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y03abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y03efgEv,_ZTv0_n12_N3ccc7DD5x8y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y03abcEv,_ZTv0_n16_N3ccc7DD5x8y03abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y0E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y0E[] = {
  {&(_ZTVN3ccc7DD5x8y0E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y0E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y0E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y0E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y0E[];
static VTBL_ENTRY alt_thunk_names146[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y03abcEv,_ZTv0_n16_N3ccc7DD5x8y03abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y03abcEv,_ZThn4_N3ccc7DD5x8y03abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y03efgEv,_ZTv0_n12_N3ccc7DD5x8y03efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y03efgEv,_ZThn4_N3ccc7DD5x8y03efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y0E = {  "_ZN3ccc7DD5x8y0E", // class name
  bases__ZN3ccc7DD5x8y0E, 2,
  &(vtc__ZN3ccc7DD5x8y0E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y0E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y0E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y0E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names146,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y1  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC5x8y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x8y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x8y13efgEv
  ~CC5x8y1(); // tgen
  CC5x8y1(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y1E) C1{ VBC2{ v2 v3 v1} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x8y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y13abcEv");}
void  ccc::CC5x8y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y13pqrEv");}
void  ccc::CC5x8y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y13efgEv");}
ccc::CC5x8y1 ::~CC5x8y1(){ note_dtor("_ZN3ccc7CC5x8y1E", this);} // tgen
ccc::CC5x8y1 ::CC5x8y1(){ note_ctor("_ZN3ccc7CC5x8y1E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y1E, buf);
    ::ccc::CC5x8y1 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y1E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y1E);
    dp->::ccc::CC5x8y1::~CC5x8y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y1E(Test__ZN3ccc7CC5x8y1E, "_ZN3ccc7CC5x8y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y1C1Ev();
extern void _ZN3ccc7CC5x8y1D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y1E[] = {
  NSPAIR(_ZN3ccc7CC5x8y1C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y1E[];
extern void _ZN3ccc7CC5x8y13efgEv();
extern void _ZN3ccc7CC5x8y13abcEv();
extern void _ZN3ccc7CC5x8y13pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y13pqrEv,_ZTv0_n12_N3ccc7CC5x8y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y13pqrEv,_ZThn4_N3ccc7CC5x8y13pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y13efgEv,_ZTv0_n16_N3ccc7CC5x8y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y13efgEv,_ZThn4_N3ccc7CC5x8y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y13abcEv,_ZTv0_n20_N3ccc7CC5x8y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y13abcEv,_ZThn4_N3ccc7CC5x8y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y1E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y13pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y13pqrEv,_ZTv0_n12_N3ccc7CC5x8y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y13efgEv,_ZTv0_n16_N3ccc7CC5x8y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y13abcEv,_ZTv0_n20_N3ccc7CC5x8y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y1E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y1E[] = {
  {&(_ZTVN3ccc7CC5x8y1E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y1E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y1E[];
static VTBL_ENTRY alt_thunk_names147[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y13abcEv,_ZTv0_n20_N3ccc7CC5x8y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y13abcEv,_ZThn4_N3ccc7CC5x8y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y13efgEv,_ZTv0_n16_N3ccc7CC5x8y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y13efgEv,_ZThn4_N3ccc7CC5x8y13efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y13pqrEv,_ZTv0_n12_N3ccc7CC5x8y13pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y13pqrEv,_ZThn4_N3ccc7CC5x8y13pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y1E = {  "_ZN3ccc7CC5x8y1E", // class name
  bases__ZN3ccc7CC5x8y1E, 2,
  &(vtc__ZN3ccc7CC5x8y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y1E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y1E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names147,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y1  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7DD5x8y13abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x8y13pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x8y13efgEv
  ~DD5x8y1(); // tgen
  DD5x8y1(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y1E) C1{ VBC2{ v2 v3 v1} VBC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x8y1 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y13abcEv");}
void  ccc::DD5x8y1 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y13pqrEv");}
void  ccc::DD5x8y1 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y13efgEv");}
ccc::DD5x8y1 ::~DD5x8y1(){ note_dtor("_ZN3ccc7DD5x8y1E", this);} // tgen
ccc::DD5x8y1 ::DD5x8y1(){ note_ctor("_ZN3ccc7DD5x8y1E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y1E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y1E, buf);
    ::ccc::DD5x8y1 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y1E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y1E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y1E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y1E);
    dp->::ccc::DD5x8y1::~DD5x8y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y1E(Test__ZN3ccc7DD5x8y1E, "_ZN3ccc7DD5x8y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y1C1Ev();
extern void _ZN3ccc7DD5x8y1D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y1E[] = {
  NSPAIR(_ZN3ccc7DD5x8y1C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y1E[];
extern void _ZN3ccc7DD5x8y13pqrEv();
extern void _ZN3ccc7DD5x8y13efgEv();
extern void _ZN3ccc7DD5x8y13abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y13efgEv,_ZTv0_n12_N3ccc7DD5x8y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y13efgEv,_ZThn4_N3ccc7DD5x8y13efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y13abcEv,_ZTv0_n16_N3ccc7DD5x8y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y13abcEv,_ZThn4_N3ccc7DD5x8y13abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y1E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y13abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y13efgEv,_ZTv0_n12_N3ccc7DD5x8y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y13abcEv,_ZTv0_n16_N3ccc7DD5x8y13abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y1E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y1E[] = {
  {&(_ZTVN3ccc7DD5x8y1E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y1E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y1E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y1E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y1E[];
static VTBL_ENTRY alt_thunk_names148[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y13abcEv,_ZTv0_n16_N3ccc7DD5x8y13abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y13abcEv,_ZThn4_N3ccc7DD5x8y13abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y13efgEv,_ZTv0_n12_N3ccc7DD5x8y13efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y13efgEv,_ZThn4_N3ccc7DD5x8y13efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y1E = {  "_ZN3ccc7DD5x8y1E", // class name
  bases__ZN3ccc7DD5x8y1E, 2,
  &(vtc__ZN3ccc7DD5x8y1E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y1E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y1E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y1E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names148,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y2  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC5x8y23efgEv
  virtual void  abc(); // _ZN3ccc7CC5x8y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x8y23pqrEv
  ~CC5x8y2(); // tgen
  CC5x8y2(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y2E) C1{ VBC2{ v3 v1 v2} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x8y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y23efgEv");}
void  ccc::CC5x8y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y23abcEv");}
void  ccc::CC5x8y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y23pqrEv");}
ccc::CC5x8y2 ::~CC5x8y2(){ note_dtor("_ZN3ccc7CC5x8y2E", this);} // tgen
ccc::CC5x8y2 ::CC5x8y2(){ note_ctor("_ZN3ccc7CC5x8y2E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y2E, buf);
    ::ccc::CC5x8y2 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y2E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y2E);
    dp->::ccc::CC5x8y2::~CC5x8y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y2E(Test__ZN3ccc7CC5x8y2E, "_ZN3ccc7CC5x8y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y2C1Ev();
extern void _ZN3ccc7CC5x8y2D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y2E[] = {
  NSPAIR(_ZN3ccc7CC5x8y2C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y2E[];
extern void _ZN3ccc7CC5x8y23efgEv();
extern void _ZN3ccc7CC5x8y23abcEv();
extern void _ZN3ccc7CC5x8y23pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y23pqrEv,_ZTv0_n12_N3ccc7CC5x8y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y23pqrEv,_ZThn4_N3ccc7CC5x8y23pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y23efgEv,_ZTv0_n16_N3ccc7CC5x8y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y23efgEv,_ZThn4_N3ccc7CC5x8y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y23abcEv,_ZTv0_n20_N3ccc7CC5x8y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y23abcEv,_ZThn4_N3ccc7CC5x8y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y2E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y23pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y23pqrEv,_ZTv0_n12_N3ccc7CC5x8y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y23efgEv,_ZTv0_n16_N3ccc7CC5x8y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y23abcEv,_ZTv0_n20_N3ccc7CC5x8y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y2E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y2E[] = {
  {&(_ZTVN3ccc7CC5x8y2E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y2E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y2E[];
static VTBL_ENTRY alt_thunk_names149[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y23abcEv,_ZTv0_n20_N3ccc7CC5x8y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y23abcEv,_ZThn4_N3ccc7CC5x8y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y23efgEv,_ZTv0_n16_N3ccc7CC5x8y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y23efgEv,_ZThn4_N3ccc7CC5x8y23efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y23pqrEv,_ZTv0_n12_N3ccc7CC5x8y23pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y23pqrEv,_ZThn4_N3ccc7CC5x8y23pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y2E = {  "_ZN3ccc7CC5x8y2E", // class name
  bases__ZN3ccc7CC5x8y2E, 2,
  &(vtc__ZN3ccc7CC5x8y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y2E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y2E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names149,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y2  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7DD5x8y23efgEv
  virtual void  abc(); // _ZN3ccc7DD5x8y23abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x8y23pqrEv
  ~DD5x8y2(); // tgen
  DD5x8y2(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y2E) C1{ VBC2{ v3 v1 v2} VBC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x8y2 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y23efgEv");}
void  ccc::DD5x8y2 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y23abcEv");}
void  ccc::DD5x8y2 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y23pqrEv");}
ccc::DD5x8y2 ::~DD5x8y2(){ note_dtor("_ZN3ccc7DD5x8y2E", this);} // tgen
ccc::DD5x8y2 ::DD5x8y2(){ note_ctor("_ZN3ccc7DD5x8y2E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y2E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y2E, buf);
    ::ccc::DD5x8y2 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y2E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y2E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y2E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y2E);
    dp->::ccc::DD5x8y2::~DD5x8y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y2E(Test__ZN3ccc7DD5x8y2E, "_ZN3ccc7DD5x8y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y2C1Ev();
extern void _ZN3ccc7DD5x8y2D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y2E[] = {
  NSPAIR(_ZN3ccc7DD5x8y2C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y2E[];
extern void _ZN3ccc7DD5x8y23pqrEv();
extern void _ZN3ccc7DD5x8y23efgEv();
extern void _ZN3ccc7DD5x8y23abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y23efgEv,_ZTv0_n12_N3ccc7DD5x8y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y23efgEv,_ZThn4_N3ccc7DD5x8y23efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y23abcEv,_ZTv0_n16_N3ccc7DD5x8y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y23abcEv,_ZThn4_N3ccc7DD5x8y23abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y2E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y23pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y23abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y23efgEv,_ZTv0_n12_N3ccc7DD5x8y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y23abcEv,_ZTv0_n16_N3ccc7DD5x8y23abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y2E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y2E[] = {
  {&(_ZTVN3ccc7DD5x8y2E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y2E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y2E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y2E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y2E[];
static VTBL_ENTRY alt_thunk_names150[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y23abcEv,_ZTv0_n16_N3ccc7DD5x8y23abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y23abcEv,_ZThn4_N3ccc7DD5x8y23abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y23efgEv,_ZTv0_n12_N3ccc7DD5x8y23efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y23efgEv,_ZThn4_N3ccc7DD5x8y23efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y2E = {  "_ZN3ccc7DD5x8y2E", // class name
  bases__ZN3ccc7DD5x8y2E, 2,
  &(vtc__ZN3ccc7DD5x8y2E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y2E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y2E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y2E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names150,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y3  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC5x8y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x8y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x8y33abcEv
  ~CC5x8y3(); // tgen
  CC5x8y3(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y3E) C1{ VBC2{ v2 v1 v3} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x8y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y33efgEv");}
void  ccc::CC5x8y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y33pqrEv");}
void  ccc::CC5x8y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y33abcEv");}
ccc::CC5x8y3 ::~CC5x8y3(){ note_dtor("_ZN3ccc7CC5x8y3E", this);} // tgen
ccc::CC5x8y3 ::CC5x8y3(){ note_ctor("_ZN3ccc7CC5x8y3E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y3E, buf);
    ::ccc::CC5x8y3 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y3E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y3E);
    dp->::ccc::CC5x8y3::~CC5x8y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y3E(Test__ZN3ccc7CC5x8y3E, "_ZN3ccc7CC5x8y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y3C1Ev();
extern void _ZN3ccc7CC5x8y3D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y3E[] = {
  NSPAIR(_ZN3ccc7CC5x8y3C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y3E[];
extern void _ZN3ccc7CC5x8y33efgEv();
extern void _ZN3ccc7CC5x8y33abcEv();
extern void _ZN3ccc7CC5x8y33pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y33pqrEv,_ZTv0_n12_N3ccc7CC5x8y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y33pqrEv,_ZThn4_N3ccc7CC5x8y33pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y33efgEv,_ZTv0_n16_N3ccc7CC5x8y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y33efgEv,_ZThn4_N3ccc7CC5x8y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y33abcEv,_ZTv0_n20_N3ccc7CC5x8y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y33abcEv,_ZThn4_N3ccc7CC5x8y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y3E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y33pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y33pqrEv,_ZTv0_n12_N3ccc7CC5x8y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y33efgEv,_ZTv0_n16_N3ccc7CC5x8y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y33abcEv,_ZTv0_n20_N3ccc7CC5x8y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y3E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y3E[] = {
  {&(_ZTVN3ccc7CC5x8y3E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y3E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y3E[];
static VTBL_ENTRY alt_thunk_names151[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y33abcEv,_ZTv0_n20_N3ccc7CC5x8y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y33abcEv,_ZThn4_N3ccc7CC5x8y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y33efgEv,_ZTv0_n16_N3ccc7CC5x8y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y33efgEv,_ZThn4_N3ccc7CC5x8y33efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y33pqrEv,_ZTv0_n12_N3ccc7CC5x8y33pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y33pqrEv,_ZThn4_N3ccc7CC5x8y33pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y3E = {  "_ZN3ccc7CC5x8y3E", // class name
  bases__ZN3ccc7CC5x8y3E, 2,
  &(vtc__ZN3ccc7CC5x8y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y3E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y3E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names151,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y3  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7DD5x8y33efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x8y33pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x8y33abcEv
  ~DD5x8y3(); // tgen
  DD5x8y3(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y3E) C1{ VBC2{ v2 v1 v3} VBC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x8y3 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y33efgEv");}
void  ccc::DD5x8y3 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y33pqrEv");}
void  ccc::DD5x8y3 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y33abcEv");}
ccc::DD5x8y3 ::~DD5x8y3(){ note_dtor("_ZN3ccc7DD5x8y3E", this);} // tgen
ccc::DD5x8y3 ::DD5x8y3(){ note_ctor("_ZN3ccc7DD5x8y3E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y3E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y3E, buf);
    ::ccc::DD5x8y3 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y3E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y3E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y3E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y3E);
    dp->::ccc::DD5x8y3::~DD5x8y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y3E(Test__ZN3ccc7DD5x8y3E, "_ZN3ccc7DD5x8y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y3C1Ev();
extern void _ZN3ccc7DD5x8y3D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y3E[] = {
  NSPAIR(_ZN3ccc7DD5x8y3C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y3E[];
extern void _ZN3ccc7DD5x8y33pqrEv();
extern void _ZN3ccc7DD5x8y33efgEv();
extern void _ZN3ccc7DD5x8y33abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y33efgEv,_ZTv0_n12_N3ccc7DD5x8y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y33efgEv,_ZThn4_N3ccc7DD5x8y33efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y33abcEv,_ZTv0_n16_N3ccc7DD5x8y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y33abcEv,_ZThn4_N3ccc7DD5x8y33abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y3E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y33abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y33efgEv,_ZTv0_n12_N3ccc7DD5x8y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y33abcEv,_ZTv0_n16_N3ccc7DD5x8y33abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y3E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y3E[] = {
  {&(_ZTVN3ccc7DD5x8y3E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y3E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y3E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y3E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y3E[];
static VTBL_ENTRY alt_thunk_names152[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y33abcEv,_ZTv0_n16_N3ccc7DD5x8y33abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y33abcEv,_ZThn4_N3ccc7DD5x8y33abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y33efgEv,_ZTv0_n12_N3ccc7DD5x8y33efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y33efgEv,_ZThn4_N3ccc7DD5x8y33efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y3E = {  "_ZN3ccc7DD5x8y3E", // class name
  bases__ZN3ccc7DD5x8y3E, 2,
  &(vtc__ZN3ccc7DD5x8y3E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y3E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y3E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y3E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names152,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y4  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc7CC5x8y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC5x8y43abcEv
  virtual void  efg(); // _ZN3ccc7CC5x8y43efgEv
  ~CC5x8y4(); // tgen
  CC5x8y4(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y4E) C1{ VBC2{ v1 v3 v2} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x8y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y43pqrEv");}
void  ccc::CC5x8y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y43abcEv");}
void  ccc::CC5x8y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y43efgEv");}
ccc::CC5x8y4 ::~CC5x8y4(){ note_dtor("_ZN3ccc7CC5x8y4E", this);} // tgen
ccc::CC5x8y4 ::CC5x8y4(){ note_ctor("_ZN3ccc7CC5x8y4E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y4E, buf);
    ::ccc::CC5x8y4 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y4E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y4E);
    dp->::ccc::CC5x8y4::~CC5x8y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y4E(Test__ZN3ccc7CC5x8y4E, "_ZN3ccc7CC5x8y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y4C1Ev();
extern void _ZN3ccc7CC5x8y4D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y4E[] = {
  NSPAIR(_ZN3ccc7CC5x8y4C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y4E[];
extern void _ZN3ccc7CC5x8y43efgEv();
extern void _ZN3ccc7CC5x8y43abcEv();
extern void _ZN3ccc7CC5x8y43pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y43pqrEv,_ZTv0_n12_N3ccc7CC5x8y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y43pqrEv,_ZThn4_N3ccc7CC5x8y43pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y43efgEv,_ZTv0_n16_N3ccc7CC5x8y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y43efgEv,_ZThn4_N3ccc7CC5x8y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y43abcEv,_ZTv0_n20_N3ccc7CC5x8y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y43abcEv,_ZThn4_N3ccc7CC5x8y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y4E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y43pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y43pqrEv,_ZTv0_n12_N3ccc7CC5x8y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y43efgEv,_ZTv0_n16_N3ccc7CC5x8y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y43abcEv,_ZTv0_n20_N3ccc7CC5x8y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y4E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y4E[] = {
  {&(_ZTVN3ccc7CC5x8y4E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y4E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y4E[];
static VTBL_ENTRY alt_thunk_names153[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y43abcEv,_ZTv0_n20_N3ccc7CC5x8y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y43abcEv,_ZThn4_N3ccc7CC5x8y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y43efgEv,_ZTv0_n16_N3ccc7CC5x8y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y43efgEv,_ZThn4_N3ccc7CC5x8y43efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y43pqrEv,_ZTv0_n12_N3ccc7CC5x8y43pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y43pqrEv,_ZThn4_N3ccc7CC5x8y43pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y4E = {  "_ZN3ccc7CC5x8y4E", // class name
  bases__ZN3ccc7CC5x8y4E, 2,
  &(vtc__ZN3ccc7CC5x8y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y4E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y4E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names153,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y4  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc7DD5x8y43pqrEv
  virtual void  abc(); // _ZN3ccc7DD5x8y43abcEv
  virtual void  efg(); // _ZN3ccc7DD5x8y43efgEv
  ~DD5x8y4(); // tgen
  DD5x8y4(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y4E) C1{ VBC2{ v1 v3 v2} VBC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x8y4 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y43pqrEv");}
void  ccc::DD5x8y4 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y43abcEv");}
void  ccc::DD5x8y4 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y43efgEv");}
ccc::DD5x8y4 ::~DD5x8y4(){ note_dtor("_ZN3ccc7DD5x8y4E", this);} // tgen
ccc::DD5x8y4 ::DD5x8y4(){ note_ctor("_ZN3ccc7DD5x8y4E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y4E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y4E, buf);
    ::ccc::DD5x8y4 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y4E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y4E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y4E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y4E);
    dp->::ccc::DD5x8y4::~DD5x8y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y4E(Test__ZN3ccc7DD5x8y4E, "_ZN3ccc7DD5x8y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y4C1Ev();
extern void _ZN3ccc7DD5x8y4D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y4E[] = {
  NSPAIR(_ZN3ccc7DD5x8y4C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y4E[];
extern void _ZN3ccc7DD5x8y43pqrEv();
extern void _ZN3ccc7DD5x8y43efgEv();
extern void _ZN3ccc7DD5x8y43abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y43efgEv,_ZTv0_n12_N3ccc7DD5x8y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y43efgEv,_ZThn4_N3ccc7DD5x8y43efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y43abcEv,_ZTv0_n16_N3ccc7DD5x8y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y43abcEv,_ZThn4_N3ccc7DD5x8y43abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y4E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y43abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y43efgEv,_ZTv0_n12_N3ccc7DD5x8y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y43abcEv,_ZTv0_n16_N3ccc7DD5x8y43abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y4E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y4E[] = {
  {&(_ZTVN3ccc7DD5x8y4E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y4E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y4E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y4E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y4E[];
static VTBL_ENTRY alt_thunk_names154[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y43abcEv,_ZTv0_n16_N3ccc7DD5x8y43abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y43abcEv,_ZThn4_N3ccc7DD5x8y43abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y43efgEv,_ZTv0_n12_N3ccc7DD5x8y43efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y43efgEv,_ZThn4_N3ccc7DD5x8y43efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y4E = {  "_ZN3ccc7DD5x8y4E", // class name
  bases__ZN3ccc7DD5x8y4E, 2,
  &(vtc__ZN3ccc7DD5x8y4E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y4E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y4E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y4E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names154,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y5  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc7CC5x8y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC5x8y53efgEv
  virtual void  abc(); // _ZN3ccc7CC5x8y53abcEv
  ~CC5x8y5(); // tgen
  CC5x8y5(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y5E) C1{ VBC2{ v1 v2 v3} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC5x8y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y53pqrEv");}
void  ccc::CC5x8y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y53efgEv");}
void  ccc::CC5x8y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y53abcEv");}
ccc::CC5x8y5 ::~CC5x8y5(){ note_dtor("_ZN3ccc7CC5x8y5E", this);} // tgen
ccc::CC5x8y5 ::CC5x8y5(){ note_ctor("_ZN3ccc7CC5x8y5E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y5E, buf);
    ::ccc::CC5x8y5 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y5E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y5E);
    dp->::ccc::CC5x8y5::~CC5x8y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y5E(Test__ZN3ccc7CC5x8y5E, "_ZN3ccc7CC5x8y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y5C1Ev();
extern void _ZN3ccc7CC5x8y5D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y5E[] = {
  NSPAIR(_ZN3ccc7CC5x8y5C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y5E[];
extern void _ZN3ccc7CC5x8y53efgEv();
extern void _ZN3ccc7CC5x8y53abcEv();
extern void _ZN3ccc7CC5x8y53pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y53pqrEv,_ZTv0_n12_N3ccc7CC5x8y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y53pqrEv,_ZThn4_N3ccc7CC5x8y53pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y53efgEv,_ZTv0_n16_N3ccc7CC5x8y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y53efgEv,_ZThn4_N3ccc7CC5x8y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y53abcEv,_ZTv0_n20_N3ccc7CC5x8y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y53abcEv,_ZThn4_N3ccc7CC5x8y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y5E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y53pqrEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y53pqrEv,_ZTv0_n12_N3ccc7CC5x8y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y53efgEv,_ZTv0_n16_N3ccc7CC5x8y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y53abcEv,_ZTv0_n20_N3ccc7CC5x8y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y5E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y5E[] = {
  {&(_ZTVN3ccc7CC5x8y5E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y5E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y5E[];
static VTBL_ENTRY alt_thunk_names155[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y53abcEv,_ZTv0_n20_N3ccc7CC5x8y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y53abcEv,_ZThn4_N3ccc7CC5x8y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y53efgEv,_ZTv0_n16_N3ccc7CC5x8y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y53efgEv,_ZThn4_N3ccc7CC5x8y53efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y53pqrEv,_ZTv0_n12_N3ccc7CC5x8y53pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y53pqrEv,_ZThn4_N3ccc7CC5x8y53pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y5E = {  "_ZN3ccc7CC5x8y5E", // class name
  bases__ZN3ccc7CC5x8y5E, 2,
  &(vtc__ZN3ccc7CC5x8y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y5E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y5E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names155,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y5  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc7DD5x8y53pqrEv
  virtual void  efg(); // _ZN3ccc7DD5x8y53efgEv
  virtual void  abc(); // _ZN3ccc7DD5x8y53abcEv
  ~DD5x8y5(); // tgen
  DD5x8y5(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y5E) C1{ VBC2{ v1 v2 v3} VBC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::DD5x8y5 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y53pqrEv");}
void  ccc::DD5x8y5 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y53efgEv");}
void  ccc::DD5x8y5 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y53abcEv");}
ccc::DD5x8y5 ::~DD5x8y5(){ note_dtor("_ZN3ccc7DD5x8y5E", this);} // tgen
ccc::DD5x8y5 ::DD5x8y5(){ note_ctor("_ZN3ccc7DD5x8y5E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y5E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y5E, buf);
    ::ccc::DD5x8y5 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y5E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y5E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y5E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y5E);
    dp->::ccc::DD5x8y5::~DD5x8y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y5E(Test__ZN3ccc7DD5x8y5E, "_ZN3ccc7DD5x8y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y5C1Ev();
extern void _ZN3ccc7DD5x8y5D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y5E[] = {
  NSPAIR(_ZN3ccc7DD5x8y5C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y5E[];
extern void _ZN3ccc7DD5x8y53pqrEv();
extern void _ZN3ccc7DD5x8y53efgEv();
extern void _ZN3ccc7DD5x8y53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y53efgEv,_ZTv0_n12_N3ccc7DD5x8y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y53efgEv,_ZThn4_N3ccc7DD5x8y53efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y53abcEv,_ZTv0_n16_N3ccc7DD5x8y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y53abcEv,_ZThn4_N3ccc7DD5x8y53abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y5E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y53abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y53efgEv,_ZTv0_n12_N3ccc7DD5x8y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y53abcEv,_ZTv0_n16_N3ccc7DD5x8y53abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y5E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y5E[] = {
  {&(_ZTVN3ccc7DD5x8y5E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y5E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y5E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y5E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y5E[];
static VTBL_ENTRY alt_thunk_names156[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y53abcEv,_ZTv0_n16_N3ccc7DD5x8y53abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y53abcEv,_ZThn4_N3ccc7DD5x8y53abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y53efgEv,_ZTv0_n12_N3ccc7DD5x8y53efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y53efgEv,_ZThn4_N3ccc7DD5x8y53efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y5E = {  "_ZN3ccc7DD5x8y5E", // class name
  bases__ZN3ccc7DD5x8y5E, 2,
  &(vtc__ZN3ccc7DD5x8y5E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y5E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y5E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y5E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names156,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y6  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC5x8y63abcEv
  virtual void  efg(); // _ZN3ccc7CC5x8y63efgEv
  ~CC5x8y6(); // tgen
  CC5x8y6(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y6E) C1{ VBC2{ v3 v2 v1} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x8y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y63abcEv");}
void  ccc::CC5x8y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y63efgEv");}
ccc::CC5x8y6 ::~CC5x8y6(){ note_dtor("_ZN3ccc7CC5x8y6E", this);} // tgen
ccc::CC5x8y6 ::CC5x8y6(){ note_ctor("_ZN3ccc7CC5x8y6E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y6E, buf);
    ::ccc::CC5x8y6 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y6E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y6E);
    dp->::ccc::CC5x8y6::~CC5x8y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y6E(Test__ZN3ccc7CC5x8y6E, "_ZN3ccc7CC5x8y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y6C1Ev();
extern void _ZN3ccc7CC5x8y6D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y6E[] = {
  NSPAIR(_ZN3ccc7CC5x8y6C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y6E[];
extern void _ZN3ccc7CC5x8y63efgEv();
extern void _ZN3ccc7CC5x8y63abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y63efgEv,_ZTv0_n16_N3ccc7CC5x8y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y63efgEv,_ZThn4_N3ccc7CC5x8y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y63abcEv,_ZTv0_n20_N3ccc7CC5x8y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y63abcEv,_ZThn4_N3ccc7CC5x8y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y6E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y63abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y63efgEv,_ZTv0_n16_N3ccc7CC5x8y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y63abcEv,_ZTv0_n20_N3ccc7CC5x8y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y6E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y6E[] = {
  {&(_ZTVN3ccc7CC5x8y6E[3]),  3,13},
  {&(_ZTVN3ccc7CC5x8y6E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y6E[];
static VTBL_ENTRY alt_thunk_names157[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y63abcEv,_ZTv0_n20_N3ccc7CC5x8y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y63abcEv,_ZThn4_N3ccc7CC5x8y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y63efgEv,_ZTv0_n16_N3ccc7CC5x8y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y63efgEv,_ZThn4_N3ccc7CC5x8y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y6E = {  "_ZN3ccc7CC5x8y6E", // class name
  bases__ZN3ccc7CC5x8y6E, 2,
  &(vtc__ZN3ccc7CC5x8y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y6E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y6E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names157,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y6  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7DD5x8y63abcEv
  virtual void  efg(); // _ZN3ccc7DD5x8y63efgEv
  ~DD5x8y6(); // tgen
  DD5x8y6(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y6E) C1{ VBC2{ v3 v2 v1} VBC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x8y6 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y63abcEv");}
void  ccc::DD5x8y6 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y63efgEv");}
ccc::DD5x8y6 ::~DD5x8y6(){ note_dtor("_ZN3ccc7DD5x8y6E", this);} // tgen
ccc::DD5x8y6 ::DD5x8y6(){ note_ctor("_ZN3ccc7DD5x8y6E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y6E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y6E, buf);
    ::ccc::DD5x8y6 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y6E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y6E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y6E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y6E);
    dp->::ccc::DD5x8y6::~DD5x8y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y6E(Test__ZN3ccc7DD5x8y6E, "_ZN3ccc7DD5x8y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y6C1Ev();
extern void _ZN3ccc7DD5x8y6D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y6E[] = {
  NSPAIR(_ZN3ccc7DD5x8y6C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y6E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x8y63efgEv();
extern void _ZN3ccc7DD5x8y63abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y63efgEv,_ZTv0_n12_N3ccc7DD5x8y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y63efgEv,_ZThn4_N3ccc7DD5x8y63efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y63abcEv,_ZTv0_n16_N3ccc7DD5x8y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y63abcEv,_ZThn4_N3ccc7DD5x8y63abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y6E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y63abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y63efgEv,_ZTv0_n12_N3ccc7DD5x8y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y63abcEv,_ZTv0_n16_N3ccc7DD5x8y63abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y6E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y6E[] = {
  {&(_ZTVN3ccc7DD5x8y6E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y6E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y6E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y6E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y6E[];
static VTBL_ENTRY alt_thunk_names158[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y63abcEv,_ZTv0_n16_N3ccc7DD5x8y63abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y63abcEv,_ZThn4_N3ccc7DD5x8y63abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y63efgEv,_ZTv0_n12_N3ccc7DD5x8y63efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y63efgEv,_ZThn4_N3ccc7DD5x8y63efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y6E = {  "_ZN3ccc7DD5x8y6E", // class name
  bases__ZN3ccc7DD5x8y6E, 2,
  &(vtc__ZN3ccc7DD5x8y6E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y6E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y6E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y6E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names158,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y7  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC5x8y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC5x8y73pqrEv
  ~CC5x8y7(); // tgen
  CC5x8y7(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y7E) C1{ VBC2{ v2 v3 v1} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC5x8y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y73abcEv");}
void  ccc::CC5x8y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y73pqrEv");}
ccc::CC5x8y7 ::~CC5x8y7(){ note_dtor("_ZN3ccc7CC5x8y7E", this);} // tgen
ccc::CC5x8y7 ::CC5x8y7(){ note_ctor("_ZN3ccc7CC5x8y7E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y7E, buf);
    ::ccc::CC5x8y7 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y7E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y7E);
    dp->::ccc::CC5x8y7::~CC5x8y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y7E(Test__ZN3ccc7CC5x8y7E, "_ZN3ccc7CC5x8y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y7C1Ev();
extern void _ZN3ccc7CC5x8y7D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y7E[] = {
  NSPAIR(_ZN3ccc7CC5x8y7C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y7E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc7CC5x8y73abcEv();
extern void _ZN3ccc7CC5x8y73pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y73pqrEv,_ZTv0_n12_N3ccc7CC5x8y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y73pqrEv,_ZThn4_N3ccc7CC5x8y73pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y73abcEv,_ZTv0_n20_N3ccc7CC5x8y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y73abcEv,_ZThn4_N3ccc7CC5x8y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y7E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y73pqrEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y73pqrEv,_ZTv0_n12_N3ccc7CC5x8y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y73abcEv,_ZTv0_n20_N3ccc7CC5x8y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y7E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y7E[] = {
  {&(_ZTVN3ccc7CC5x8y7E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y7E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y7E[];
static VTBL_ENTRY alt_thunk_names159[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y73abcEv,_ZTv0_n20_N3ccc7CC5x8y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y73abcEv,_ZThn4_N3ccc7CC5x8y73abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y73pqrEv,_ZTv0_n12_N3ccc7CC5x8y73pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y73pqrEv,_ZThn4_N3ccc7CC5x8y73pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y7E = {  "_ZN3ccc7CC5x8y7E", // class name
  bases__ZN3ccc7CC5x8y7E, 2,
  &(vtc__ZN3ccc7CC5x8y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y7E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y7E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names159,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y7  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7DD5x8y73abcEv
  virtual void  pqr(); // _ZN3ccc7DD5x8y73pqrEv
  ~DD5x8y7(); // tgen
  DD5x8y7(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y7E) C1{ VBC2{ v2 v3 v1} VBC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::DD5x8y7 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y73abcEv");}
void  ccc::DD5x8y7 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y73pqrEv");}
ccc::DD5x8y7 ::~DD5x8y7(){ note_dtor("_ZN3ccc7DD5x8y7E", this);} // tgen
ccc::DD5x8y7 ::DD5x8y7(){ note_ctor("_ZN3ccc7DD5x8y7E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y7E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y7E, buf);
    ::ccc::DD5x8y7 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y7E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y7E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y7E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y7E);
    dp->::ccc::DD5x8y7::~DD5x8y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y7E(Test__ZN3ccc7DD5x8y7E, "_ZN3ccc7DD5x8y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y7C1Ev();
extern void _ZN3ccc7DD5x8y7D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y7E[] = {
  NSPAIR(_ZN3ccc7DD5x8y7C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y7E[];
extern void _ZN3ccc7DD5x8y73pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc7DD5x8y73abcEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y73abcEv,_ZTv0_n16_N3ccc7DD5x8y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y73abcEv,_ZThn4_N3ccc7DD5x8y73abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y7E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y73pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y73abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y73abcEv,_ZTv0_n16_N3ccc7DD5x8y73abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y7E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y7E[] = {
  {&(_ZTVN3ccc7DD5x8y7E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y7E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y7E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y7E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y7E[];
static VTBL_ENTRY alt_thunk_names160[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y73abcEv,_ZTv0_n16_N3ccc7DD5x8y73abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y73abcEv,_ZThn4_N3ccc7DD5x8y73abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y7E = {  "_ZN3ccc7DD5x8y7E", // class name
  bases__ZN3ccc7DD5x8y7E, 2,
  &(vtc__ZN3ccc7DD5x8y7E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y7E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y7E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y7E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names160,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y8  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC5x8y83efgEv
  virtual void  abc(); // _ZN3ccc7CC5x8y83abcEv
  ~CC5x8y8(); // tgen
  CC5x8y8(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y8E) C1{ VBC2{ v3 v1 v2} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x8y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y83efgEv");}
void  ccc::CC5x8y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC5x8y83abcEv");}
ccc::CC5x8y8 ::~CC5x8y8(){ note_dtor("_ZN3ccc7CC5x8y8E", this);} // tgen
ccc::CC5x8y8 ::CC5x8y8(){ note_ctor("_ZN3ccc7CC5x8y8E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y8E, buf);
    ::ccc::CC5x8y8 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y8E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y8E);
    dp->::ccc::CC5x8y8::~CC5x8y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y8E(Test__ZN3ccc7CC5x8y8E, "_ZN3ccc7CC5x8y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y8C1Ev();
extern void _ZN3ccc7CC5x8y8D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y8E[] = {
  NSPAIR(_ZN3ccc7CC5x8y8C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y8E[];
extern void _ZN3ccc7CC5x8y83efgEv();
extern void _ZN3ccc7CC5x8y83abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y83efgEv,_ZTv0_n16_N3ccc7CC5x8y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y83efgEv,_ZThn4_N3ccc7CC5x8y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N3ccc7CC5x8y83abcEv,_ZTv0_n20_N3ccc7CC5x8y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y83abcEv,_ZThn4_N3ccc7CC5x8y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y8E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y83abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y83efgEv,_ZTv0_n16_N3ccc7CC5x8y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc7CC5x8y83abcEv,_ZTv0_n20_N3ccc7CC5x8y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y8E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y8E[] = {
  {&(_ZTVN3ccc7CC5x8y8E[3]),  3,13},
  {&(_ZTVN3ccc7CC5x8y8E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y8E[];
static VTBL_ENTRY alt_thunk_names161[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc7CC5x8y83abcEv,_ZTv0_n20_N3ccc7CC5x8y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y83abcEv,_ZThn4_N3ccc7CC5x8y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y83efgEv,_ZTv0_n16_N3ccc7CC5x8y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y83efgEv,_ZThn4_N3ccc7CC5x8y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y8E = {  "_ZN3ccc7CC5x8y8E", // class name
  bases__ZN3ccc7CC5x8y8E, 2,
  &(vtc__ZN3ccc7CC5x8y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y8E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y8E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names161,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y8  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7DD5x8y83efgEv
  virtual void  abc(); // _ZN3ccc7DD5x8y83abcEv
  ~DD5x8y8(); // tgen
  DD5x8y8(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y8E) C1{ VBC2{ v3 v1 v2} VBC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x8y8 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y83efgEv");}
void  ccc::DD5x8y8 ::abc(){vfunc_called(this, "_ZN3ccc7DD5x8y83abcEv");}
ccc::DD5x8y8 ::~DD5x8y8(){ note_dtor("_ZN3ccc7DD5x8y8E", this);} // tgen
ccc::DD5x8y8 ::DD5x8y8(){ note_ctor("_ZN3ccc7DD5x8y8E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y8E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y8E, buf);
    ::ccc::DD5x8y8 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y8E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y8E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y8E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y8E);
    dp->::ccc::DD5x8y8::~DD5x8y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y8E(Test__ZN3ccc7DD5x8y8E, "_ZN3ccc7DD5x8y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y8C1Ev();
extern void _ZN3ccc7DD5x8y8D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y8E[] = {
  NSPAIR(_ZN3ccc7DD5x8y8C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y8E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc7DD5x8y83efgEv();
extern void _ZN3ccc7DD5x8y83abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y83efgEv,_ZTv0_n12_N3ccc7DD5x8y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y83efgEv,_ZThn4_N3ccc7DD5x8y83efgEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7DD5x8y83abcEv,_ZTv0_n16_N3ccc7DD5x8y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y83abcEv,_ZThn4_N3ccc7DD5x8y83abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y8E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y83abcEv,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y83efgEv,_ZTv0_n12_N3ccc7DD5x8y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7DD5x8y83abcEv,_ZTv0_n16_N3ccc7DD5x8y83abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y8E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y8E[] = {
  {&(_ZTVN3ccc7DD5x8y8E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y8E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y8E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y8E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y8E[];
static VTBL_ENTRY alt_thunk_names162[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7DD5x8y83abcEv,_ZTv0_n16_N3ccc7DD5x8y83abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y83abcEv,_ZThn4_N3ccc7DD5x8y83abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y83efgEv,_ZTv0_n12_N3ccc7DD5x8y83efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y83efgEv,_ZThn4_N3ccc7DD5x8y83efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y8E = {  "_ZN3ccc7DD5x8y8E", // class name
  bases__ZN3ccc7DD5x8y8E, 2,
  &(vtc__ZN3ccc7DD5x8y8E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y8E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y8E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y8E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names162,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y9  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC5x8y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC5x8y93pqrEv
  ~CC5x8y9(); // tgen
  CC5x8y9(); // tgen
};
//SIG(1 _ZN3ccc7CC5x8y9E) C1{ VBC2{ v2 v1 v3} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x8y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC5x8y93efgEv");}
void  ccc::CC5x8y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC5x8y93pqrEv");}
ccc::CC5x8y9 ::~CC5x8y9(){ note_dtor("_ZN3ccc7CC5x8y9E", this);} // tgen
ccc::CC5x8y9 ::CC5x8y9(){ note_ctor("_ZN3ccc7CC5x8y9E", this);} // tgen
}
static void Test__ZN3ccc7CC5x8y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC5x8y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC5x8y9E, buf);
    ::ccc::CC5x8y9 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC5x8y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC5x8y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc7CC5x8y9E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc7CC5x8y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC5x8y9E);
    dp->::ccc::CC5x8y9::~CC5x8y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC5x8y9E(Test__ZN3ccc7CC5x8y9E, "_ZN3ccc7CC5x8y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC5x8y9C1Ev();
extern void _ZN3ccc7CC5x8y9D1Ev();
Name_Map name_map__ZN3ccc7CC5x8y9E[] = {
  NSPAIR(_ZN3ccc7CC5x8y9C1Ev),
  NSPAIR(_ZN3ccc7CC5x8y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC5x8y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y9E[];
extern void _ZN3ccc7CC5x8y93efgEv();
extern void _ZN3ccc3BB83abcEv();
extern void _ZN3ccc7CC5x8y93pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7CC5x8y93pqrEv,_ZTv0_n12_N3ccc7CC5x8y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y93pqrEv,_ZThn4_N3ccc7CC5x8y93pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc7CC5x8y93efgEv,_ZTv0_n16_N3ccc7CC5x8y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC5x8y93efgEv,_ZThn4_N3ccc7CC5x8y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC5x8y9E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC5x8y93pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC5x8y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7CC5x8y93pqrEv,_ZTv0_n12_N3ccc7CC5x8y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc7CC5x8y93efgEv,_ZTv0_n16_N3ccc7CC5x8y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7CC5x8y9E[];
static  VTT_ENTRY vtt__ZN3ccc7CC5x8y9E[] = {
  {&(_ZTVN3ccc7CC5x8y9E[3]),  3,14},
  {&(_ZTVN3ccc7CC5x8y9E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc7CC5x8y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC5x8y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7CC5x8y9E[];
static VTBL_ENTRY alt_thunk_names163[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc7CC5x8y93efgEv,_ZTv0_n16_N3ccc7CC5x8y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y93efgEv,_ZThn4_N3ccc7CC5x8y93efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7CC5x8y93pqrEv,_ZTv0_n12_N3ccc7CC5x8y93pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7CC5x8y93pqrEv,_ZThn4_N3ccc7CC5x8y93pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7CC5x8y9E = {  "_ZN3ccc7CC5x8y9E", // class name
  bases__ZN3ccc7CC5x8y9E, 2,
  &(vtc__ZN3ccc7CC5x8y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7CC5x8y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC5x8y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC5x8y9E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7CC5x8y9E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names163,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y9  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7DD5x8y93efgEv
  virtual void  pqr(); // _ZN3ccc7DD5x8y93pqrEv
  ~DD5x8y9(); // tgen
  DD5x8y9(); // tgen
};
//SIG(1 _ZN3ccc7DD5x8y9E) C1{ VBC2{ v2 v1 v3} VBC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x8y9 ::efg(){vfunc_called(this, "_ZN3ccc7DD5x8y93efgEv");}
void  ccc::DD5x8y9 ::pqr(){vfunc_called(this, "_ZN3ccc7DD5x8y93pqrEv");}
ccc::DD5x8y9 ::~DD5x8y9(){ note_dtor("_ZN3ccc7DD5x8y9E", this);} // tgen
ccc::DD5x8y9 ::DD5x8y9(){ note_ctor("_ZN3ccc7DD5x8y9E", this);} // tgen
}
static void Test__ZN3ccc7DD5x8y9E()
{
  extern Class_Descriptor cd__ZN3ccc7DD5x8y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7DD5x8y9E, buf);
    ::ccc::DD5x8y9 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7DD5x8y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7DD5x8y9E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc7DD5x8y9E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7DD5x8y9E");
    test_class_info(&lv, &cd__ZN3ccc7DD5x8y9E);
    dp->::ccc::DD5x8y9::~DD5x8y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7DD5x8y9E(Test__ZN3ccc7DD5x8y9E, "_ZN3ccc7DD5x8y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7DD5x8y9C1Ev();
extern void _ZN3ccc7DD5x8y9D1Ev();
Name_Map name_map__ZN3ccc7DD5x8y9E[] = {
  NSPAIR(_ZN3ccc7DD5x8y9C1Ev),
  NSPAIR(_ZN3ccc7DD5x8y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7DD5x8y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y9E[];
extern void _ZN3ccc7DD5x8y93pqrEv();
extern void _ZN3ccc7DD5x8y93efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc7DD5x8y93efgEv,_ZTv0_n12_N3ccc7DD5x8y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7DD5x8y93efgEv,_ZThn4_N3ccc7DD5x8y93efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7DD5x8y9E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y93pqrEv,
  (VTBL_ENTRY)&_ZN3ccc7DD5x8y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7DD5x8y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc7DD5x8y93efgEv,_ZTv0_n12_N3ccc7DD5x8y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc7DD5x8y9E[];
static  VTT_ENTRY vtt__ZN3ccc7DD5x8y9E[] = {
  {&(_ZTVN3ccc7DD5x8y9E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y9E[7]),  7,16},
  {&(_ZTVN3ccc7DD5x8y9E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc7DD5x8y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7DD5x8y9E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc7DD5x8y9E[];
static VTBL_ENTRY alt_thunk_names164[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc7DD5x8y93efgEv,_ZTv0_n12_N3ccc7DD5x8y93efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc7DD5x8y93efgEv,_ZThn4_N3ccc7DD5x8y93efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc7DD5x8y9E = {  "_ZN3ccc7DD5x8y9E", // class name
  bases__ZN3ccc7DD5x8y9E, 2,
  &(vtc__ZN3ccc7DD5x8y9E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc7DD5x8y9E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7DD5x8y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7DD5x8y9E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc7DD5x8y9E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names164,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y10  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8CC5x8y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC5x8y103abcEv
  ~CC5x8y10(); // tgen
  CC5x8y10(); // tgen
};
//SIG(1 _ZN3ccc8CC5x8y10E) C1{ VBC2{ v1 v3 v2} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC5x8y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x8y103pqrEv");}
void  ccc::CC5x8y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x8y103abcEv");}
ccc::CC5x8y10 ::~CC5x8y10(){ note_dtor("_ZN3ccc8CC5x8y10E", this);} // tgen
ccc::CC5x8y10 ::CC5x8y10(){ note_ctor("_ZN3ccc8CC5x8y10E", this);} // tgen
}
static void Test__ZN3ccc8CC5x8y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x8y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x8y10E, buf);
    ::ccc::CC5x8y10 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x8y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x8y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x8y10E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC5x8y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x8y10E);
    dp->::ccc::CC5x8y10::~CC5x8y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x8y10E(Test__ZN3ccc8CC5x8y10E, "_ZN3ccc8CC5x8y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x8y10C1Ev();
extern void _ZN3ccc8CC5x8y10D1Ev();
Name_Map name_map__ZN3ccc8CC5x8y10E[] = {
  NSPAIR(_ZN3ccc8CC5x8y10C1Ev),
  NSPAIR(_ZN3ccc8CC5x8y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC5x8y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x8y10E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc8CC5x8y103abcEv();
extern void _ZN3ccc8CC5x8y103pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x8y103pqrEv,_ZTv0_n12_N3ccc8CC5x8y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x8y103pqrEv,_ZThn4_N3ccc8CC5x8y103pqrEv)() __attribute__((weak));
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x8y103abcEv,_ZTv0_n20_N3ccc8CC5x8y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x8y103abcEv,_ZThn4_N3ccc8CC5x8y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x8y10E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x8y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x8y103pqrEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x8y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x8y103pqrEv,_ZTv0_n12_N3ccc8CC5x8y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x8y103abcEv,_ZTv0_n20_N3ccc8CC5x8y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x8y10E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x8y10E[] = {
  {&(_ZTVN3ccc8CC5x8y10E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x8y10E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x8y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x8y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x8y10E[];
static VTBL_ENTRY alt_thunk_names165[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x8y103abcEv,_ZTv0_n20_N3ccc8CC5x8y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x8y103abcEv,_ZThn4_N3ccc8CC5x8y103abcEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x8y103pqrEv,_ZTv0_n12_N3ccc8CC5x8y103pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x8y103pqrEv,_ZThn4_N3ccc8CC5x8y103pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x8y10E = {  "_ZN3ccc8CC5x8y10E", // class name
  bases__ZN3ccc8CC5x8y10E, 2,
  &(vtc__ZN3ccc8CC5x8y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x8y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x8y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x8y10E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x8y10E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names165,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y10  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8DD5x8y103pqrEv
  virtual void  abc(); // _ZN3ccc8DD5x8y103abcEv
  ~DD5x8y10(); // tgen
  DD5x8y10(); // tgen
};
//SIG(1 _ZN3ccc8DD5x8y10E) C1{ VBC2{ v1 v3 v2} VBC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::DD5x8y10 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x8y103pqrEv");}
void  ccc::DD5x8y10 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x8y103abcEv");}
ccc::DD5x8y10 ::~DD5x8y10(){ note_dtor("_ZN3ccc8DD5x8y10E", this);} // tgen
ccc::DD5x8y10 ::DD5x8y10(){ note_ctor("_ZN3ccc8DD5x8y10E", this);} // tgen
}
static void Test__ZN3ccc8DD5x8y10E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x8y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x8y10E, buf);
    ::ccc::DD5x8y10 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x8y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x8y10E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x8y10E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD5x8y10E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x8y10E);
    dp->::ccc::DD5x8y10::~DD5x8y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x8y10E(Test__ZN3ccc8DD5x8y10E, "_ZN3ccc8DD5x8y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x8y10C1Ev();
extern void _ZN3ccc8DD5x8y10D1Ev();
Name_Map name_map__ZN3ccc8DD5x8y10E[] = {
  NSPAIR(_ZN3ccc8DD5x8y10C1Ev),
  NSPAIR(_ZN3ccc8DD5x8y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD5x8y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x8y10E[];
extern void _ZN3ccc8DD5x8y103pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc8DD5x8y103abcEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZTv0_n32_N3ccc8DD5x8y103abcEv,_ZTv0_n16_N3ccc8DD5x8y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x8y103abcEv,_ZThn4_N3ccc8DD5x8y103abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8DD5x8y10E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x8y103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x8y103abcEv,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8DD5x8y103abcEv,_ZTv0_n16_N3ccc8DD5x8y103abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x8y10E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x8y10E[] = {
  {&(_ZTVN3ccc8DD5x8y10E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x8y10E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x8y10E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x8y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x8y10E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x8y10E[];
static VTBL_ENTRY alt_thunk_names166[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8DD5x8y103abcEv,_ZTv0_n16_N3ccc8DD5x8y103abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x8y103abcEv,_ZThn4_N3ccc8DD5x8y103abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x8y10E = {  "_ZN3ccc8DD5x8y10E", // class name
  bases__ZN3ccc8DD5x8y10E, 2,
  &(vtc__ZN3ccc8DD5x8y10E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x8y10E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x8y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x8y10E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x8y10E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names166,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y11  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8CC5x8y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC5x8y113efgEv
  ~CC5x8y11(); // tgen
  CC5x8y11(); // tgen
};
//SIG(1 _ZN3ccc8CC5x8y11E) C1{ VBC2{ v1 v2 v3} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC5x8y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC5x8y113pqrEv");}
void  ccc::CC5x8y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC5x8y113efgEv");}
ccc::CC5x8y11 ::~CC5x8y11(){ note_dtor("_ZN3ccc8CC5x8y11E", this);} // tgen
ccc::CC5x8y11 ::CC5x8y11(){ note_ctor("_ZN3ccc8CC5x8y11E", this);} // tgen
}
static void Test__ZN3ccc8CC5x8y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x8y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x8y11E, buf);
    ::ccc::CC5x8y11 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x8y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x8y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x8y11E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC5x8y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x8y11E);
    dp->::ccc::CC5x8y11::~CC5x8y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x8y11E(Test__ZN3ccc8CC5x8y11E, "_ZN3ccc8CC5x8y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x8y11C1Ev();
extern void _ZN3ccc8CC5x8y11D1Ev();
Name_Map name_map__ZN3ccc8CC5x8y11E[] = {
  NSPAIR(_ZN3ccc8CC5x8y11C1Ev),
  NSPAIR(_ZN3ccc8CC5x8y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC5x8y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x8y11E[];
extern void _ZN3ccc8CC5x8y113efgEv();
extern void _ZN3ccc3BB83abcEv();
extern void _ZN3ccc8CC5x8y113pqrEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8CC5x8y113pqrEv,_ZTv0_n12_N3ccc8CC5x8y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x8y113pqrEv,_ZThn4_N3ccc8CC5x8y113pqrEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3ccc8CC5x8y113efgEv,_ZTv0_n16_N3ccc8CC5x8y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x8y113efgEv,_ZThn4_N3ccc8CC5x8y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC5x8y11E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x8y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC5x8y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x8y113pqrEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x8y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8CC5x8y113pqrEv,_ZTv0_n12_N3ccc8CC5x8y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3ccc8CC5x8y113efgEv,_ZTv0_n16_N3ccc8CC5x8y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x8y11E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x8y11E[] = {
  {&(_ZTVN3ccc8CC5x8y11E[3]),  3,14},
  {&(_ZTVN3ccc8CC5x8y11E[11]),  11,14},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x8y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x8y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x8y11E[];
static VTBL_ENTRY alt_thunk_names167[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3ccc8CC5x8y113efgEv,_ZTv0_n16_N3ccc8CC5x8y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x8y113efgEv,_ZThn4_N3ccc8CC5x8y113efgEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8CC5x8y113pqrEv,_ZTv0_n12_N3ccc8CC5x8y113pqrEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x8y113pqrEv,_ZThn4_N3ccc8CC5x8y113pqrEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x8y11E = {  "_ZN3ccc8CC5x8y11E", // class name
  bases__ZN3ccc8CC5x8y11E, 2,
  &(vtc__ZN3ccc8CC5x8y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x8y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x8y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x8y11E),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x8y11E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names167,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y11  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8DD5x8y113pqrEv
  virtual void  efg(); // _ZN3ccc8DD5x8y113efgEv
  ~DD5x8y11(); // tgen
  DD5x8y11(); // tgen
};
//SIG(1 _ZN3ccc8DD5x8y11E) C1{ VBC2{ v1 v2 v3} VBC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::DD5x8y11 ::pqr(){vfunc_called(this, "_ZN3ccc8DD5x8y113pqrEv");}
void  ccc::DD5x8y11 ::efg(){vfunc_called(this, "_ZN3ccc8DD5x8y113efgEv");}
ccc::DD5x8y11 ::~DD5x8y11(){ note_dtor("_ZN3ccc8DD5x8y11E", this);} // tgen
ccc::DD5x8y11 ::DD5x8y11(){ note_ctor("_ZN3ccc8DD5x8y11E", this);} // tgen
}
static void Test__ZN3ccc8DD5x8y11E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x8y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x8y11E, buf);
    ::ccc::DD5x8y11 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x8y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x8y11E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x8y11E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD5x8y11E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x8y11E);
    dp->::ccc::DD5x8y11::~DD5x8y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x8y11E(Test__ZN3ccc8DD5x8y11E, "_ZN3ccc8DD5x8y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x8y11C1Ev();
extern void _ZN3ccc8DD5x8y11D1Ev();
Name_Map name_map__ZN3ccc8DD5x8y11E[] = {
  NSPAIR(_ZN3ccc8DD5x8y11C1Ev),
  NSPAIR(_ZN3ccc8DD5x8y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD5x8y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8DD5x8y11E[];
extern void _ZN3ccc8DD5x8y113pqrEv();
extern void _ZN3ccc8DD5x8y113efgEv();
extern void _ZN3ccc3AA53abcEv();
extern void ABISELECT(_ZTv0_n24_N3ccc8DD5x8y113efgEv,_ZTv0_n12_N3ccc8DD5x8y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8DD5x8y113efgEv,_ZThn4_N3ccc8DD5x8y113efgEv)() __attribute__((weak));
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8DD5x8y11E[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x8y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc8DD5x8y113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc8DD5x8y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8DD5x8y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ccc8DD5x8y113efgEv,_ZTv0_n12_N3ccc8DD5x8y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTVN3ccc8DD5x8y11E[];
static  VTT_ENTRY vtt__ZN3ccc8DD5x8y11E[] = {
  {&(_ZTVN3ccc8DD5x8y11E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x8y11E[7]),  7,16},
  {&(_ZTVN3ccc8DD5x8y11E[14]),  14,16},
};
extern VTBL_ENTRY _ZTIN3ccc8DD5x8y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8DD5x8y11E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8DD5x8y11E[];
static VTBL_ENTRY alt_thunk_names168[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ccc8DD5x8y113efgEv,_ZTv0_n12_N3ccc8DD5x8y113efgEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8DD5x8y113efgEv,_ZThn4_N3ccc8DD5x8y113efgEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8DD5x8y11E = {  "_ZN3ccc8DD5x8y11E", // class name
  bases__ZN3ccc8DD5x8y11E, 2,
  &(vtc__ZN3ccc8DD5x8y11E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8DD5x8y11E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8DD5x8y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8DD5x8y11E),16, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8DD5x8y11E),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names168,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC5x8y12  : virtual ::ccc::AA5 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8CC5x8y123abcEv
  ~CC5x8y12(); // tgen
  CC5x8y12(); // tgen
};
//SIG(1 _ZN3ccc8CC5x8y12E) C1{ VBC2{ v2 v3 v1} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC5x8y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC5x8y123abcEv");}
ccc::CC5x8y12 ::~CC5x8y12(){ note_dtor("_ZN3ccc8CC5x8y12E", this);} // tgen
ccc::CC5x8y12 ::CC5x8y12(){ note_ctor("_ZN3ccc8CC5x8y12E", this);} // tgen
}
static void Test__ZN3ccc8CC5x8y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC5x8y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC5x8y12E, buf);
    ::ccc::CC5x8y12 *dp, &lv = *(dp=new (buf) ::ccc::CC5x8y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC5x8y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC5x8y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), ABISELECT(8,4), "_ZN3ccc8CC5x8y12E");
    check_base_class_offset(lv, (::ccc::BB8*), 0, "_ZN3ccc8CC5x8y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC5x8y12E);
    dp->::ccc::CC5x8y12::~CC5x8y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC5x8y12E(Test__ZN3ccc8CC5x8y12E, "_ZN3ccc8CC5x8y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC5x8y12C1Ev();
extern void _ZN3ccc8CC5x8y12D1Ev();
Name_Map name_map__ZN3ccc8CC5x8y12E[] = {
  NSPAIR(_ZN3ccc8CC5x8y12C1Ev),
  NSPAIR(_ZN3ccc8CC5x8y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC5x8y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC5x8y12E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc8CC5x8y123abcEv();
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void ABISELECT(_ZTv0_n40_N3ccc8CC5x8y123abcEv,_ZTv0_n20_N3ccc8CC5x8y123abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC5x8y123abcEv,_ZThn4_N3ccc8CC5x8y123abcEv)() __attribute__((weak));
static  VTBL_ENTRY vtc__ZN3ccc8CC5x8y12E[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC5x8y123abcEv,
  ABISELECT(-8,-4),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC5x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N3ccc8CC5x8y123abcEv,_ZTv0_n20_N3ccc8CC5x8y123abcEv),
};
extern VTBL_ENTRY _ZTVN3ccc8CC5x8y12E[];
static  VTT_ENTRY vtt__ZN3ccc8CC5x8y12E[] = {
  {&(_ZTVN3ccc8CC5x8y12E[3]),  3,13},
  {&(_ZTVN3ccc8CC5x8y12E[10]),  10,13},
};
extern VTBL_ENTRY _ZTIN3ccc8CC5x8y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC5x8y12E[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTTN3ccc8CC5x8y12E[];
static VTBL_ENTRY alt_thunk_names169[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N3ccc8CC5x8y123abcEv,_ZTv0_n20_N3ccc8CC5x8y123abcEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N3ccc8CC5x8y123abcEv,_ZThn4_N3ccc8CC5x8y123abcEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd__ZN3ccc8CC5x8y12E = {  "_ZN3ccc8CC5x8y12E", // class name
  bases__ZN3ccc8CC5x8y12E, 2,
  &(vtc__ZN3ccc8CC5x8y12E[0]), // expected_vtbl_contents
  &(vtt__ZN3ccc8CC5x8y12E[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC5x8y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC5x8y12E),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTTN3ccc8CC5x8y12E),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names169,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  DD5x8y12  : virtual ::ccc::AA5 , virtual ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8DD5x8y123abcEv
  ~DD5x8y12(); // tgen
  DD5x8y12(); // tgen
};
//SIG(1 _ZN3ccc8DD5x8y12E) C1{ VBC2{ v2 v3 v1} VBC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::DD5x8y12 ::abc(){vfunc_called(this, "_ZN3ccc8DD5x8y123abcEv");}
ccc::DD5x8y12 ::~DD5x8y12(){ note_dtor("_ZN3ccc8DD5x8y12E", this);} // tgen
ccc::DD5x8y12 ::DD5x8y12(){ note_ctor("_ZN3ccc8DD5x8y12E", this);} // tgen
}
static void Test__ZN3ccc8DD5x8y12E()
{
  extern Class_Descriptor cd__ZN3ccc8DD5x8y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8DD5x8y12E, buf);
    ::ccc::DD5x8y12 *dp, &lv = *(dp=new (buf) ::ccc::DD5x8y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8DD5x8y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8DD5x8y12E)");
    check_base_class_offset(lv, (::ccc::AA5*), 0, "_ZN3ccc8DD5x8y12E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8DD5x8y12E");
    test_class_info(&lv, &cd__ZN3ccc8DD5x8y12E);
    dp->::ccc::DD5x8y12::~DD5x8y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8DD5x8y12E(Test__ZN3ccc8DD5x8y12E, "_ZN3ccc8DD5x8y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8DD5x8y12C1Ev();
extern void _ZN3ccc8DD5x8y12D1Ev();
Name_Map name_map__ZN3ccc8DD5x8y12E[] = {
  NSPAIR(_ZN3ccc8DD5x8y12C1Ev),
  NSPAIR(_ZN3ccc8DD5x8y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA5E;
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8DD5x8y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA5E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd__ZN3ccc3BB8E,   