// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  AA1  {
  int pa;
  virtual void  foo(); // _ZN3AA13fooEv
  ~AA1(); // tgen
  AA1(); // tgen
};
//SIG(-1 AA1) C1{ v1 Fi}


void  AA1 ::foo(){vfunc_called(this, "_ZN3AA13fooEv");}
AA1 ::~AA1(){ note_dtor("AA1", this);} // tgen
AA1 ::AA1(){ note_ctor("AA1", this);} // tgen

static void Test_AA1()
{
  extern Class_Descriptor cd_AA1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_AA1, buf);
    AA1 *dp, &lv = *(dp=new (buf) AA1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(AA1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(AA1)");
    check_field_offset(lv, pa, ABISELECT(8,4), "AA1.pa");
    test_class_info(&lv, &cd_AA1);
    dp->~AA1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vAA1(Test_AA1, "AA1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3AA1C1Ev();
extern void _ZN3AA1D1Ev();
Name_Map name_map_AA1[] = {
  NSPAIR(_ZN3AA1C1Ev),
  NSPAIR(_ZN3AA1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3AA1[];
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY vtc_AA1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3AA1[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
Class_Descriptor cd_AA1 = {  "AA1", // class name
  0,0,//no base classes
  &(vtc_AA1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3AA1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3AA1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BB1  {
  int pb;
  virtual void  foo(); // _ZN3BB13fooEv
  ~BB1(); // tgen
  BB1(); // tgen
};
//SIG(-1 BB1) C1{ v1 Fi}


void  BB1 ::foo(){vfunc_called(this, "_ZN3BB13fooEv");}
BB1 ::~BB1(){ note_dtor("BB1", this);} // tgen
BB1 ::BB1(){ note_ctor("BB1", this);} // tgen

static void Test_BB1()
{
  extern Class_Descriptor cd_BB1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_BB1, buf);
    BB1 *dp, &lv = *(dp=new (buf) BB1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BB1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BB1)");
    check_field_offset(lv, pb, ABISELECT(8,4), "BB1.pb");
    test_class_info(&lv, &cd_BB1);
    dp->~BB1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vBB1(Test_BB1, "BB1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3BB1C1Ev();
extern void _ZN3BB1D1Ev();
Name_Map name_map_BB1[] = {
  NSPAIR(_ZN3BB1C1Ev),
  NSPAIR(_ZN3BB1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3BB1[];
extern void _ZN3BB13fooEv();
static  VTBL_ENTRY vtc_BB1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3BB1[0]),
  (VTBL_ENTRY)&_ZN3BB13fooEv,
};
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
Class_Descriptor cd_BB1 = {  "BB1", // class name
  0,0,//no base classes
  &(vtc_BB1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3BB1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3BB1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  CC1  {
  int pc;
  virtual void  foo(); // _ZN3CC13fooEv
  ~CC1(); // tgen
  CC1(); // tgen
};
//SIG(1 CC1) C1{ v1 Fi}


void  CC1 ::foo(){vfunc_called(this, "_ZN3CC13fooEv");}
CC1 ::~CC1(){ note_dtor("CC1", this);} // tgen
CC1 ::CC1(){ note_ctor("CC1", this);} // tgen

static void Test_CC1()
{
  extern Class_Descriptor cd_CC1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_CC1, buf);
    CC1 *dp, &lv = *(dp=new (buf) CC1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(CC1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(CC1)");
    check_field_offset(lv, pc, ABISELECT(8,4), "CC1.pc");
    test_class_info(&lv, &cd_CC1);
    dp->~CC1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vCC1(Test_CC1, "CC1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3CC1C1Ev();
extern void _ZN3CC1D1Ev();
Name_Map name_map_CC1[] = {
  NSPAIR(_ZN3CC1C1Ev),
  NSPAIR(_ZN3CC1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3CC1[];
extern void _ZN3CC13fooEv();
static  VTBL_ENTRY vtc_CC1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3CC1[0]),
  (VTBL_ENTRY)&_ZN3CC13fooEv,
};
extern VTBL_ENTRY _ZTI3CC1[];
extern  VTBL_ENTRY _ZTV3CC1[];
Class_Descriptor cd_CC1 = {  "CC1", // class name
  0,0,//no base classes
  &(vtc_CC1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3CC1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3CC1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  DD1  {
  int pd;
  virtual void  foo(); // _ZN3DD13fooEv
  ~DD1(); // tgen
  DD1(); // tgen
};
//SIG(1 DD1) C1{ v1 Fi}


void  DD1 ::foo(){vfunc_called(this, "_ZN3DD13fooEv");}
DD1 ::~DD1(){ note_dtor("DD1", this);} // tgen
DD1 ::DD1(){ note_ctor("DD1", this);} // tgen

static void Test_DD1()
{
  extern Class_Descriptor cd_DD1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_DD1, buf);
    DD1 *dp, &lv = *(dp=new (buf) DD1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(DD1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(DD1)");
    check_field_offset(lv, pd, ABISELECT(8,4), "DD1.pd");
    test_class_info(&lv, &cd_DD1);
    dp->~DD1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vDD1(Test_DD1, "DD1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3DD1C1Ev();
extern void _ZN3DD1D1Ev();
Name_Map name_map_DD1[] = {
  NSPAIR(_ZN3DD1C1Ev),
  NSPAIR(_ZN3DD1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3DD1[];
extern void _ZN3DD13fooEv();
static  VTBL_ENTRY vtc_DD1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3DD1[0]),
  (VTBL_ENTRY)&_ZN3DD13fooEv,
};
extern VTBL_ENTRY _ZTI3DD1[];
extern  VTBL_ENTRY _ZTV3DD1[];
Class_Descriptor cd_DD1 = {  "DD1", // class name
  0,0,//no base classes
  &(vtc_DD1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3DD1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3DD1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  AA2  {
  int pa;
  virtual void  bar(); // _ZN3AA23barEv
  ~AA2(); // tgen
  AA2(); // tgen
};
//SIG(-1 AA2) C1{ v1 Fi}


void  AA2 ::bar(){vfunc_called(this, "_ZN3AA23barEv");}
AA2 ::~AA2(){ note_dtor("AA2", this);} // tgen
AA2 ::AA2(){ note_ctor("AA2", this);} // tgen

static void Test_AA2()
{
  extern Class_Descriptor cd_AA2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_AA2, buf);
    AA2 *dp, &lv = *(dp=new (buf) AA2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(AA2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(AA2)");
    check_field_offset(lv, pa, ABISELECT(8,4), "AA2.pa");
    test_class_info(&lv, &cd_AA2);
    dp->~AA2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vAA2(Test_AA2, "AA2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3AA2C1Ev();
extern void _ZN3AA2D1Ev();
Name_Map name_map_AA2[] = {
  NSPAIR(_ZN3AA2C1Ev),
  NSPAIR(_ZN3AA2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3AA2[];
extern void _ZN3AA23barEv();
static  VTBL_ENTRY vtc_AA2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3AA2[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
Class_Descriptor cd_AA2 = {  "AA2", // class name
  0,0,//no base classes
  &(vtc_AA2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3AA2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3AA2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BB2  {
  int pb;
  virtual void  bar(); // _ZN3BB23barEv
  ~BB2(); // tgen
  BB2(); // tgen
};
//SIG(-1 BB2) C1{ v1 Fi}


void  BB2 ::bar(){vfunc_called(this, "_ZN3BB23barEv");}
BB2 ::~BB2(){ note_dtor("BB2", this);} // tgen
BB2 ::BB2(){ note_ctor("BB2", this);} // tgen

static void Test_BB2()
{
  extern Class_Descriptor cd_BB2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_BB2, buf);
    BB2 *dp, &lv = *(dp=new (buf) BB2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BB2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BB2)");
    check_field_offset(lv, pb, ABISELECT(8,4), "BB2.pb");
    test_class_info(&lv, &cd_BB2);
    dp->~BB2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vBB2(Test_BB2, "BB2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3BB2C1Ev();
extern void _ZN3BB2D1Ev();
Name_Map name_map_BB2[] = {
  NSPAIR(_ZN3BB2C1Ev),
  NSPAIR(_ZN3BB2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3BB2[];
extern void _ZN3BB23barEv();
static  VTBL_ENTRY vtc_BB2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3BB2[0]),
  (VTBL_ENTRY)&_ZN3BB23barEv,
};
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
Class_Descriptor cd_BB2 = {  "BB2", // class name
  0,0,//no base classes
  &(vtc_BB2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3BB2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3BB2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  CC2  {
  int pc;
  virtual void  bar(); // _ZN3CC23barEv
  ~CC2(); // tgen
  CC2(); // tgen
};
//SIG(1 CC2) C1{ v1 Fi}


void  CC2 ::bar(){vfunc_called(this, "_ZN3CC23barEv");}
CC2 ::~CC2(){ note_dtor("CC2", this);} // tgen
CC2 ::CC2(){ note_ctor("CC2", this);} // tgen

static void Test_CC2()
{
  extern Class_Descriptor cd_CC2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_CC2, buf);
    CC2 *dp, &lv = *(dp=new (buf) CC2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(CC2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(CC2)");
    check_field_offset(lv, pc, ABISELECT(8,4), "CC2.pc");
    test_class_info(&lv, &cd_CC2);
    dp->~CC2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vCC2(Test_CC2, "CC2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3CC2C1Ev();
extern void _ZN3CC2D1Ev();
Name_Map name_map_CC2[] = {
  NSPAIR(_ZN3CC2C1Ev),
  NSPAIR(_ZN3CC2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3CC2[];
extern void _ZN3CC23barEv();
static  VTBL_ENTRY vtc_CC2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3CC2[0]),
  (VTBL_ENTRY)&_ZN3CC23barEv,
};
extern VTBL_ENTRY _ZTI3CC2[];
extern  VTBL_ENTRY _ZTV3CC2[];
Class_Descriptor cd_CC2 = {  "CC2", // class name
  0,0,//no base classes
  &(vtc_CC2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3CC2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3CC2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  DD2  {
  int pd;
  virtual void  bar(); // _ZN3DD23barEv
  ~DD2(); // tgen
  DD2(); // tgen
};
//SIG(1 DD2) C1{ v1 Fi}


void  DD2 ::bar(){vfunc_called(this, "_ZN3DD23barEv");}
DD2 ::~DD2(){ note_dtor("DD2", this);} // tgen
DD2 ::DD2(){ note_ctor("DD2", this);} // tgen

static void Test_DD2()
{
  extern Class_Descriptor cd_DD2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_DD2, buf);
    DD2 *dp, &lv = *(dp=new (buf) DD2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(DD2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(DD2)");
    check_field_offset(lv, pd, ABISELECT(8,4), "DD2.pd");
    test_class_info(&lv, &cd_DD2);
    dp->~DD2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vDD2(Test_DD2, "DD2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3DD2C1Ev();
extern void _ZN3DD2D1Ev();
Name_Map name_map_DD2[] = {
  NSPAIR(_ZN3DD2C1Ev),
  NSPAIR(_ZN3DD2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3DD2[];
extern void _ZN3DD23barEv();
static  VTBL_ENTRY vtc_DD2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3DD2[0]),
  (VTBL_ENTRY)&_ZN3DD23barEv,
};
extern VTBL_ENTRY _ZTI3DD2[];
extern  VTBL_ENTRY _ZTV3DD2[];
Class_Descriptor cd_DD2 = {  "DD2", // class name
  0,0,//no base classes
  &(vtc_DD2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3DD2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3DD2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  AA3  {
  int pa;
  virtual void  foo(); // _ZN3AA33fooEv
  virtual void  bar(); // _ZN3AA33barEv
  ~AA3(); // tgen
  AA3(); // tgen
};
//SIG(-1 AA3) C1{ v1 v2 Fi}


void  AA3 ::foo(){vfunc_called(this, "_ZN3AA33fooEv");}
void  AA3 ::bar(){vfunc_called(this, "_ZN3AA33barEv");}
AA3 ::~AA3(){ note_dtor("AA3", this);} // tgen
AA3 ::AA3(){ note_ctor("AA3", this);} // tgen

static void Test_AA3()
{
  extern Class_Descriptor cd_AA3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_AA3, buf);
    AA3 *dp, &lv = *(dp=new (buf) AA3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(AA3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(AA3)");
    check_field_offset(lv, pa, ABISELECT(8,4), "AA3.pa");
    test_class_info(&lv, &cd_AA3);
    dp->~AA3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vAA3(Test_AA3, "AA3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3AA3C1Ev();
extern void _ZN3AA3D1Ev();
Name_Map name_map_AA3[] = {
  NSPAIR(_ZN3AA3C1Ev),
  NSPAIR(_ZN3AA3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3AA3[];
extern void _ZN3AA33fooEv();
extern void _ZN3AA33barEv();
static  VTBL_ENTRY vtc_AA3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3AA3[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
Class_Descriptor cd_AA3 = {  "AA3", // class name
  0,0,//no base classes
  &(vtc_AA3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3AA3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3AA3),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  BB3  {
  int pb;
  virtual void  foo(); // _ZN3BB33fooEv
  virtual void  bar(); // _ZN3BB33barEv
  ~BB3(); // tgen
  BB3(); // tgen
};
//SIG(-1 BB3) C1{ v1 v2 Fi}


void  BB3 ::foo(){vfunc_called(this, "_ZN3BB33fooEv");}
void  BB3 ::bar(){vfunc_called(this, "_ZN3BB33barEv");}
BB3 ::~BB3(){ note_dtor("BB3", this);} // tgen
BB3 ::BB3(){ note_ctor("BB3", this);} // tgen

static void Test_BB3()
{
  extern Class_Descriptor cd_BB3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_BB3, buf);
    BB3 *dp, &lv = *(dp=new (buf) BB3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(BB3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(BB3)");
    check_field_offset(lv, pb, ABISELECT(8,4), "BB3.pb");
    test_class_info(&lv, &cd_BB3);
    dp->~BB3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vBB3(Test_BB3, "BB3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3BB3C1Ev();
extern void _ZN3BB3D1Ev();
Name_Map name_map_BB3[] = {
  NSPAIR(_ZN3BB3C1Ev),
  NSPAIR(_ZN3BB3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3BB3[];
extern void _ZN3BB33fooEv();
extern void _ZN3BB33barEv();
static  VTBL_ENTRY vtc_BB3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3BB3[0]),
  (VTBL_ENTRY)&_ZN3BB33fooEv,
  (VTBL_ENTRY)&_ZN3BB33barEv,
};
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
Class_Descriptor cd_BB3 = {  "BB3", // class name
  0,0,//no base classes
  &(vtc_BB3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3BB3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3BB3),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  CC3  {
  int pc;
  virtual void  foo(); // _ZN3CC33fooEv
  virtual void  bar(); // _ZN3CC33barEv
  ~CC3(); // tgen
  CC3(); // tgen
};
//SIG(1 CC3) C1{ v1 v2 Fi}


void  CC3 ::foo(){vfunc_called(this, "_ZN3CC33fooEv");}
void  CC3 ::bar(){vfunc_called(this, "_ZN3CC33barEv");}
CC3 ::~CC3(){ note_dtor("CC3", this);} // tgen
CC3 ::CC3(){ note_ctor("CC3", this);} // tgen

static void Test_CC3()
{
  extern Class_Descriptor cd_CC3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_CC3, buf);
    CC3 *dp, &lv = *(dp=new (buf) CC3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(CC3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(CC3)");
    check_field_offset(lv, pc, ABISELECT(8,4), "CC3.pc");
    test_class_info(&lv, &cd_CC3);
    dp->~CC3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vCC3(Test_CC3, "CC3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3CC3C1Ev();
extern void _ZN3CC3D1Ev();
Name_Map name_map_CC3[] = {
  NSPAIR(_ZN3CC3C1Ev),
  NSPAIR(_ZN3CC3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3CC3[];
extern void _ZN3CC33fooEv();
extern void _ZN3CC33barEv();
static  VTBL_ENTRY vtc_CC3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3CC3[0]),
  (VTBL_ENTRY)&_ZN3CC33fooEv,
  (VTBL_ENTRY)&_ZN3CC33barEv,
};
extern VTBL_ENTRY _ZTI3CC3[];
extern  VTBL_ENTRY _ZTV3CC3[];
Class_Descriptor cd_CC3 = {  "CC3", // class name
  0,0,//no base classes
  &(vtc_CC3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3CC3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3CC3),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  DD3  {
  int pd;
  virtual void  foo(); // _ZN3DD33fooEv
  virtual void  bar(); // _ZN3DD33barEv
  ~DD3(); // tgen
  DD3(); // tgen
};
//SIG(1 DD3) C1{ v1 v2 Fi}


void  DD3 ::foo(){vfunc_called(this, "_ZN3DD33fooEv");}
void  DD3 ::bar(){vfunc_called(this, "_ZN3DD33barEv");}
DD3 ::~DD3(){ note_dtor("DD3", this);} // tgen
DD3 ::DD3(){ note_ctor("DD3", this);} // tgen

static void Test_DD3()
{
  extern Class_Descriptor cd_DD3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_DD3, buf);
    DD3 *dp, &lv = *(dp=new (buf) DD3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(DD3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(DD3)");
    check_field_offset(lv, pd, ABISELECT(8,4), "DD3.pd");
    test_class_info(&lv, &cd_DD3);
    dp->~DD3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vDD3(Test_DD3, "DD3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3DD3C1Ev();
extern void _ZN3DD3D1Ev();
Name_Map name_map_DD3[] = {
  NSPAIR(_ZN3DD3C1Ev),
  NSPAIR(_ZN3DD3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3DD3[];
extern void _ZN3DD33fooEv();
extern void _ZN3DD33barEv();
static  VTBL_ENTRY vtc_DD3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3DD3[0]),
  (VTBL_ENTRY)&_ZN3DD33fooEv,
  (VTBL_ENTRY)&_ZN3DD33barEv,
};
extern VTBL_ENTRY _ZTI3DD3[];
extern  VTBL_ENTRY _ZTV3DD3[];
Class_Descriptor cd_DD3 = {  "DD3", // class name
  0,0,//no base classes
  &(vtc_DD3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3DD3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3DD3),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E11  : virtual AA1 {
  int pe;
  virtual void  foo(); // _ZN3E113fooEv
  ~E11(); // tgen
  E11(); // tgen
};
//SIG(-1 E11) C1{ VBC2{ v1 Fi} v1 Fi}


void  E11 ::foo(){vfunc_called(this, "_ZN3E113fooEv");}
E11 ::~E11(){ note_dtor("E11", this);} // tgen
E11 ::E11(){ note_ctor("E11", this);} // tgen

static void Test_E11()
{
  extern Class_Descriptor cd_E11;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E11, buf);
    E11 *dp, &lv = *(dp=new (buf) E11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E11)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "E11");
    check_field_offset(lv, pe, ABISELECT(8,4), "E11.pe");
    test_class_info(&lv, &cd_E11);
    dp->~E11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE11(Test_E11, "E11", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E11C1Ev();
extern void _ZN3E11D1Ev();
Name_Map name_map_E11[] = {
  NSPAIR(_ZN3E11C1Ev),
  NSPAIR(_ZN3E11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
static Base_Class bases_E11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E11[];
extern void _ZN3E113fooEv();
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E11[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern VTBL_ENTRY _ZTV3E11[];
static  VTT_ENTRY vtt_E11[] = {
  {&(_ZTV3E11[3]),  3,8},
  {&(_ZTV3E11[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E11 = {  "E11", // class name
  bases_E11, 1,
  &(vtc_E11[0]), // expected_vtbl_contents
  &(vtt_E11[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E11),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E11),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E11),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F11  : virtual AA1 {
  int pf;
  virtual void  foo(); // _ZN3F113fooEv
  ~F11(); // tgen
  F11(); // tgen
};
//SIG(-1 F11) C1{ VBC2{ v1 Fi} v1 Fi}


void  F11 ::foo(){vfunc_called(this, "_ZN3F113fooEv");}
F11 ::~F11(){ note_dtor("F11", this);} // tgen
F11 ::F11(){ note_ctor("F11", this);} // tgen

static void Test_F11()
{
  extern Class_Descriptor cd_F11;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F11, buf);
    F11 *dp, &lv = *(dp=new (buf) F11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F11)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "F11");
    check_field_offset(lv, pf, ABISELECT(8,4), "F11.pf");
    test_class_info(&lv, &cd_F11);
    dp->~F11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF11(Test_F11, "F11", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F11C1Ev();
extern void _ZN3F11D1Ev();
Name_Map name_map_F11[] = {
  NSPAIR(_ZN3F11C1Ev),
  NSPAIR(_ZN3F11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
static Base_Class bases_F11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F11[];
extern void _ZN3F113fooEv();
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_F11[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
extern VTBL_ENTRY _ZTV3F11[];
static  VTT_ENTRY vtt_F11[] = {
  {&(_ZTV3F11[3]),  3,8},
  {&(_ZTV3F11[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_F11 = {  "F11", // class name
  bases_F11, 1,
  &(vtc_F11[0]), // expected_vtbl_contents
  &(vtt_F11[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F11),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F11),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F11),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E12  : virtual AA1 {
  int pe;
  virtual void  bar(); // _ZN3E123barEv
  ~E12(); // tgen
  E12(); // tgen
};
//SIG(-1 E12) C1{ VBC2{ v2 Fi} v1 Fi}


void  E12 ::bar(){vfunc_called(this, "_ZN3E123barEv");}
E12 ::~E12(){ note_dtor("E12", this);} // tgen
E12 ::E12(){ note_ctor("E12", this);} // tgen

static void Test_E12()
{
  extern Class_Descriptor cd_E12;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E12, buf);
    E12 *dp, &lv = *(dp=new (buf) E12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E12)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "E12");
    check_field_offset(lv, pe, ABISELECT(8,4), "E12.pe");
    test_class_info(&lv, &cd_E12);
    dp->~E12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE12(Test_E12, "E12", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E12C1Ev();
extern void _ZN3E12D1Ev();
Name_Map name_map_E12[] = {
  NSPAIR(_ZN3E12C1Ev),
  NSPAIR(_ZN3E12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
static Base_Class bases_E12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E12[];
extern void _ZN3E123barEv();
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY vtc_E12[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern VTBL_ENTRY _ZTV3E12[];
static  VTT_ENTRY vtt_E12[] = {
  {&(_ZTV3E12[3]),  3,8},
  {&(_ZTV3E12[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
Class_Descriptor cd_E12 = {  "E12", // class name
  bases_E12, 1,
  &(vtc_E12[0]), // expected_vtbl_contents
  &(vtt_E12[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E12),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E12),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F12  : virtual AA1 {
  int pf;
  virtual void  bar(); // _ZN3F123barEv
  ~F12(); // tgen
  F12(); // tgen
};
//SIG(-1 F12) C1{ VBC2{ v2 Fi} v1 Fi}


void  F12 ::bar(){vfunc_called(this, "_ZN3F123barEv");}
F12 ::~F12(){ note_dtor("F12", this);} // tgen
F12 ::F12(){ note_ctor("F12", this);} // tgen

static void Test_F12()
{
  extern Class_Descriptor cd_F12;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F12, buf);
    F12 *dp, &lv = *(dp=new (buf) F12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F12)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "F12");
    check_field_offset(lv, pf, ABISELECT(8,4), "F12.pf");
    test_class_info(&lv, &cd_F12);
    dp->~F12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF12(Test_F12, "F12", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F12C1Ev();
extern void _ZN3F12D1Ev();
Name_Map name_map_F12[] = {
  NSPAIR(_ZN3F12C1Ev),
  NSPAIR(_ZN3F12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
static Base_Class bases_F12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F12[];
extern void _ZN3F123barEv();
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY vtc_F12[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern VTBL_ENTRY _ZTV3F12[];
static  VTT_ENTRY vtt_F12[] = {
  {&(_ZTV3F12[3]),  3,8},
  {&(_ZTV3F12[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
Class_Descriptor cd_F12 = {  "F12", // class name
  bases_F12, 1,
  &(vtc_F12[0]), // expected_vtbl_contents
  &(vtt_F12[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F12),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F12),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E13  : virtual AA1 {
  int pe;
  virtual void  foo(); // _ZN3E133fooEv
  virtual void  bar(); // _ZN3E133barEv
  ~E13(); // tgen
  E13(); // tgen
};
//SIG(-1 E13) C1{ VBC2{ v1 Fi} v1 v2 Fi}


void  E13 ::foo(){vfunc_called(this, "_ZN3E133fooEv");}
void  E13 ::bar(){vfunc_called(this, "_ZN3E133barEv");}
E13 ::~E13(){ note_dtor("E13", this);} // tgen
E13 ::E13(){ note_ctor("E13", this);} // tgen

static void Test_E13()
{
  extern Class_Descriptor cd_E13;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E13, buf);
    E13 *dp, &lv = *(dp=new (buf) E13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E13)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "E13");
    check_field_offset(lv, pe, ABISELECT(8,4), "E13.pe");
    test_class_info(&lv, &cd_E13);
    dp->~E13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE13(Test_E13, "E13", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E13C1Ev();
extern void _ZN3E13D1Ev();
Name_Map name_map_E13[] = {
  NSPAIR(_ZN3E13C1Ev),
  NSPAIR(_ZN3E13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
static Base_Class bases_E13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E13[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E13[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern VTBL_ENTRY _ZTV3E13[];
static  VTT_ENTRY vtt_E13[] = {
  {&(_ZTV3E13[3]),  3,9},
  {&(_ZTV3E13[8]),  8,9},
};
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E13 = {  "E13", // class name
  bases_E13, 1,
  &(vtc_E13[0]), // expected_vtbl_contents
  &(vtt_E13[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E13),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E13),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F13  : virtual AA1 {
  int pf;
  virtual void  foo(); // _ZN3F133fooEv
  virtual void  bar(); // _ZN3F133barEv
  ~F13(); // tgen
  F13(); // tgen
};
//SIG(-1 F13) C1{ VBC2{ v1 Fi} v1 v2 Fi}


void  F13 ::foo(){vfunc_called(this, "_ZN3F133fooEv");}
void  F13 ::bar(){vfunc_called(this, "_ZN3F133barEv");}
F13 ::~F13(){ note_dtor("F13", this);} // tgen
F13 ::F13(){ note_ctor("F13", this);} // tgen

static void Test_F13()
{
  extern Class_Descriptor cd_F13;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F13, buf);
    F13 *dp, &lv = *(dp=new (buf) F13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F13)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "F13");
    check_field_offset(lv, pf, ABISELECT(8,4), "F13.pf");
    test_class_info(&lv, &cd_F13);
    dp->~F13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF13(Test_F13, "F13", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F13C1Ev();
extern void _ZN3F13D1Ev();
Name_Map name_map_F13[] = {
  NSPAIR(_ZN3F13C1Ev),
  NSPAIR(_ZN3F13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
static Base_Class bases_F13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F13[];
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
extern void ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_F13[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
extern VTBL_ENTRY _ZTV3F13[];
static  VTT_ENTRY vtt_F13[] = {
  {&(_ZTV3F13[3]),  3,9},
  {&(_ZTV3F13[8]),  8,9},
};
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_F13 = {  "F13", // class name
  bases_F13, 1,
  &(vtc_F13[0]), // expected_vtbl_contents
  &(vtt_F13[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F13),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F13),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E21  : virtual AA2 {
  int pe;
  virtual void  foo(); // _ZN3E213fooEv
  ~E21(); // tgen
  E21(); // tgen
};
//SIG(-1 E21) C1{ VBC2{ v2 Fi} v1 Fi}


void  E21 ::foo(){vfunc_called(this, "_ZN3E213fooEv");}
E21 ::~E21(){ note_dtor("E21", this);} // tgen
E21 ::E21(){ note_ctor("E21", this);} // tgen

static void Test_E21()
{
  extern Class_Descriptor cd_E21;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E21, buf);
    E21 *dp, &lv = *(dp=new (buf) E21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E21)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "E21");
    check_field_offset(lv, pe, ABISELECT(8,4), "E21.pe");
    test_class_info(&lv, &cd_E21);
    dp->~E21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE21(Test_E21, "E21", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E21C1Ev();
extern void _ZN3E21D1Ev();
Name_Map name_map_E21[] = {
  NSPAIR(_ZN3E21C1Ev),
  NSPAIR(_ZN3E21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
static Base_Class bases_E21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E21[];
extern void _ZN3E213fooEv();
extern void _ZN3AA23barEv();
static  VTBL_ENTRY vtc_E21[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern VTBL_ENTRY _ZTV3E21[];
static  VTT_ENTRY vtt_E21[] = {
  {&(_ZTV3E21[3]),  3,8},
  {&(_ZTV3E21[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
Class_Descriptor cd_E21 = {  "E21", // class name
  bases_E21, 1,
  &(vtc_E21[0]), // expected_vtbl_contents
  &(vtt_E21[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E21),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E21),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E21),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F21  : virtual AA2 {
  int pf;
  virtual void  foo(); // _ZN3F213fooEv
  ~F21(); // tgen
  F21(); // tgen
};
//SIG(-1 F21) C1{ VBC2{ v2 Fi} v1 Fi}


void  F21 ::foo(){vfunc_called(this, "_ZN3F213fooEv");}
F21 ::~F21(){ note_dtor("F21", this);} // tgen
F21 ::F21(){ note_ctor("F21", this);} // tgen

static void Test_F21()
{
  extern Class_Descriptor cd_F21;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F21, buf);
    F21 *dp, &lv = *(dp=new (buf) F21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F21)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "F21");
    check_field_offset(lv, pf, ABISELECT(8,4), "F21.pf");
    test_class_info(&lv, &cd_F21);
    dp->~F21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF21(Test_F21, "F21", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F21C1Ev();
extern void _ZN3F21D1Ev();
Name_Map name_map_F21[] = {
  NSPAIR(_ZN3F21C1Ev),
  NSPAIR(_ZN3F21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
static Base_Class bases_F21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F21[];
extern void _ZN3F213fooEv();
extern void _ZN3AA23barEv();
static  VTBL_ENTRY vtc_F21[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern VTBL_ENTRY _ZTV3F21[];
static  VTT_ENTRY vtt_F21[] = {
  {&(_ZTV3F21[3]),  3,8},
  {&(_ZTV3F21[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
Class_Descriptor cd_F21 = {  "F21", // class name
  bases_F21, 1,
  &(vtc_F21[0]), // expected_vtbl_contents
  &(vtt_F21[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F21),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F21),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F21),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E22  : virtual AA2 {
  int pe;
  virtual void  bar(); // _ZN3E223barEv
  ~E22(); // tgen
  E22(); // tgen
};
//SIG(-1 E22) C1{ VBC2{ v1 Fi} v1 Fi}


void  E22 ::bar(){vfunc_called(this, "_ZN3E223barEv");}
E22 ::~E22(){ note_dtor("E22", this);} // tgen
E22 ::E22(){ note_ctor("E22", this);} // tgen

static void Test_E22()
{
  extern Class_Descriptor cd_E22;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E22, buf);
    E22 *dp, &lv = *(dp=new (buf) E22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E22)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "E22");
    check_field_offset(lv, pe, ABISELECT(8,4), "E22.pe");
    test_class_info(&lv, &cd_E22);
    dp->~E22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE22(Test_E22, "E22", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E22C1Ev();
extern void _ZN3E22D1Ev();
Name_Map name_map_E22[] = {
  NSPAIR(_ZN3E22C1Ev),
  NSPAIR(_ZN3E22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
static Base_Class bases_E22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E22[];
extern void _ZN3E223barEv();
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E22[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern VTBL_ENTRY _ZTV3E22[];
static  VTT_ENTRY vtt_E22[] = {
  {&(_ZTV3E22[3]),  3,8},
  {&(_ZTV3E22[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E22 = {  "E22", // class name
  bases_E22, 1,
  &(vtc_E22[0]), // expected_vtbl_contents
  &(vtt_E22[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E22),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E22),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E22),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F22  : virtual AA2 {
  int pf;
  virtual void  bar(); // _ZN3F223barEv
  ~F22(); // tgen
  F22(); // tgen
};
//SIG(-1 F22) C1{ VBC2{ v1 Fi} v1 Fi}


void  F22 ::bar(){vfunc_called(this, "_ZN3F223barEv");}
F22 ::~F22(){ note_dtor("F22", this);} // tgen
F22 ::F22(){ note_ctor("F22", this);} // tgen

static void Test_F22()
{
  extern Class_Descriptor cd_F22;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F22, buf);
    F22 *dp, &lv = *(dp=new (buf) F22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F22)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "F22");
    check_field_offset(lv, pf, ABISELECT(8,4), "F22.pf");
    test_class_info(&lv, &cd_F22);
    dp->~F22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF22(Test_F22, "F22", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F22C1Ev();
extern void _ZN3F22D1Ev();
Name_Map name_map_F22[] = {
  NSPAIR(_ZN3F22C1Ev),
  NSPAIR(_ZN3F22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
static Base_Class bases_F22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F22[];
extern void _ZN3F223barEv();
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_F22[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
extern VTBL_ENTRY _ZTV3F22[];
static  VTT_ENTRY vtt_F22[] = {
  {&(_ZTV3F22[3]),  3,8},
  {&(_ZTV3F22[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_F22 = {  "F22", // class name
  bases_F22, 1,
  &(vtc_F22[0]), // expected_vtbl_contents
  &(vtt_F22[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F22),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F22),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F22),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E23  : virtual AA2 {
  int pe;
  virtual void  foo(); // _ZN3E233fooEv
  virtual void  bar(); // _ZN3E233barEv
  ~E23(); // tgen
  E23(); // tgen
};
//SIG(-1 E23) C1{ VBC2{ v2 Fi} v1 v2 Fi}


void  E23 ::foo(){vfunc_called(this, "_ZN3E233fooEv");}
void  E23 ::bar(){vfunc_called(this, "_ZN3E233barEv");}
E23 ::~E23(){ note_dtor("E23", this);} // tgen
E23 ::E23(){ note_ctor("E23", this);} // tgen

static void Test_E23()
{
  extern Class_Descriptor cd_E23;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E23, buf);
    E23 *dp, &lv = *(dp=new (buf) E23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E23)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "E23");
    check_field_offset(lv, pe, ABISELECT(8,4), "E23.pe");
    test_class_info(&lv, &cd_E23);
    dp->~E23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE23(Test_E23, "E23", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E23C1Ev();
extern void _ZN3E23D1Ev();
Name_Map name_map_E23[] = {
  NSPAIR(_ZN3E23C1Ev),
  NSPAIR(_ZN3E23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
static Base_Class bases_E23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E23[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E23[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern VTBL_ENTRY _ZTV3E23[];
static  VTT_ENTRY vtt_E23[] = {
  {&(_ZTV3E23[3]),  3,9},
  {&(_ZTV3E23[8]),  8,9},
};
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E23 = {  "E23", // class name
  bases_E23, 1,
  &(vtc_E23[0]), // expected_vtbl_contents
  &(vtt_E23[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E23),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E23),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E23),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F23  : virtual AA2 {
  int pf;
  virtual void  foo(); // _ZN3F233fooEv
  virtual void  bar(); // _ZN3F233barEv
  ~F23(); // tgen
  F23(); // tgen
};
//SIG(-1 F23) C1{ VBC2{ v2 Fi} v1 v2 Fi}


void  F23 ::foo(){vfunc_called(this, "_ZN3F233fooEv");}
void  F23 ::bar(){vfunc_called(this, "_ZN3F233barEv");}
F23 ::~F23(){ note_dtor("F23", this);} // tgen
F23 ::F23(){ note_ctor("F23", this);} // tgen

static void Test_F23()
{
  extern Class_Descriptor cd_F23;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F23, buf);
    F23 *dp, &lv = *(dp=new (buf) F23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F23)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "F23");
    check_field_offset(lv, pf, ABISELECT(8,4), "F23.pf");
    test_class_info(&lv, &cd_F23);
    dp->~F23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF23(Test_F23, "F23", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F23C1Ev();
extern void _ZN3F23D1Ev();
Name_Map name_map_F23[] = {
  NSPAIR(_ZN3F23C1Ev),
  NSPAIR(_ZN3F23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
static Base_Class bases_F23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F23[];
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
extern void ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_F23[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
extern VTBL_ENTRY _ZTV3F23[];
static  VTT_ENTRY vtt_F23[] = {
  {&(_ZTV3F23[3]),  3,9},
  {&(_ZTV3F23[8]),  8,9},
};
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_F23 = {  "F23", // class name
  bases_F23, 1,
  &(vtc_F23[0]), // expected_vtbl_contents
  &(vtt_F23[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F23),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F23),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F23),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E31  : virtual AA3 {
  int pe;
  virtual void  foo(); // _ZN3E313fooEv
  ~E31(); // tgen
  E31(); // tgen
};
//SIG(-1 E31) C1{ VBC2{ v1 v2 Fi} v1 Fi}


void  E31 ::foo(){vfunc_called(this, "_ZN3E313fooEv");}
E31 ::~E31(){ note_dtor("E31", this);} // tgen
E31 ::E31(){ note_ctor("E31", this);} // tgen

static void Test_E31()
{
  extern Class_Descriptor cd_E31;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E31, buf);
    E31 *dp, &lv = *(dp=new (buf) E31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E31)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "E31");
    check_field_offset(lv, pe, ABISELECT(8,4), "E31.pe");
    test_class_info(&lv, &cd_E31);
    dp->~E31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE31(Test_E31, "E31", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E31C1Ev();
extern void _ZN3E31D1Ev();
Name_Map name_map_E31[] = {
  NSPAIR(_ZN3E31C1Ev),
  NSPAIR(_ZN3E31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
static Base_Class bases_E31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E31[];
extern void _ZN3E313fooEv();
extern void ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv)();
extern void ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY vtc_E31[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&_ZN3E313fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern VTBL_ENTRY _ZTV3E31[];
static  VTT_ENTRY vtt_E31[] = {
  {&(_ZTV3E31[3]),  3,10},
  {&(_ZTV3E31[8]),  8,10},
};
extern VTBL_ENTRY _ZTI3E31[];
extern  VTBL_ENTRY _ZTV3E31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E31[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E31 = {  "E31", // class name
  bases_E31, 1,
  &(vtc_E31[0]), // expected_vtbl_contents
  &(vtt_E31[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E31),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E31),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E31),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F31  : virtual AA3 {
  int pf;
  virtual void  foo(); // _ZN3F313fooEv
  ~F31(); // tgen
  F31(); // tgen
};
//SIG(-1 F31) C1{ VBC2{ v1 v2 Fi} v1 Fi}


void  F31 ::foo(){vfunc_called(this, "_ZN3F313fooEv");}
F31 ::~F31(){ note_dtor("F31", this);} // tgen
F31 ::F31(){ note_ctor("F31", this);} // tgen

static void Test_F31()
{
  extern Class_Descriptor cd_F31;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F31, buf);
    F31 *dp, &lv = *(dp=new (buf) F31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F31)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "F31");
    check_field_offset(lv, pf, ABISELECT(8,4), "F31.pf");
    test_class_info(&lv, &cd_F31);
    dp->~F31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF31(Test_F31, "F31", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F31C1Ev();
extern void _ZN3F31D1Ev();
Name_Map name_map_F31[] = {
  NSPAIR(_ZN3F31C1Ev),
  NSPAIR(_ZN3F31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
static Base_Class bases_F31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F31[];
extern void _ZN3F313fooEv();
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY vtc_F31[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern VTBL_ENTRY _ZTV3F31[];
static  VTT_ENTRY vtt_F31[] = {
  {&(_ZTV3F31[3]),  3,10},
  {&(_ZTV3F31[8]),  8,10},
};
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_F31 = {  "F31", // class name
  bases_F31, 1,
  &(vtc_F31[0]), // expected_vtbl_contents
  &(vtt_F31[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F31),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F31),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F31),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E32  : virtual AA3 {
  int pe;
  virtual void  bar(); // _ZN3E323barEv
  ~E32(); // tgen
  E32(); // tgen
};
//SIG(-1 E32) C1{ VBC2{ v2 v1 Fi} v1 Fi}


void  E32 ::bar(){vfunc_called(this, "_ZN3E323barEv");}
E32 ::~E32(){ note_dtor("E32", this);} // tgen
E32 ::E32(){ note_ctor("E32", this);} // tgen

static void Test_E32()
{
  extern Class_Descriptor cd_E32;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E32, buf);
    E32 *dp, &lv = *(dp=new (buf) E32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E32)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "E32");
    check_field_offset(lv, pe, ABISELECT(8,4), "E32.pe");
    test_class_info(&lv, &cd_E32);
    dp->~E32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE32(Test_E32, "E32", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E32C1Ev();
extern void _ZN3E32D1Ev();
Name_Map name_map_E32[] = {
  NSPAIR(_ZN3E32C1Ev),
  NSPAIR(_ZN3E32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
static Base_Class bases_E32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E32[];
extern void _ZN3E323barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3E323barEv,_ZTv0_n16_N3E323barEv)();
extern void ABISELECT(_ZThn16_N3E323barEv,_ZThn8_N3E323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E32[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E32[0]),
  (VTBL_ENTRY)&_ZN3E323barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3E323barEv,_ZTv0_n16_N3E323barEv),
};
extern VTBL_ENTRY _ZTV3E32[];
static  VTT_ENTRY vtt_E32[] = {
  {&(_ZTV3E32[3]),  3,10},
  {&(_ZTV3E32[8]),  8,10},
};
extern VTBL_ENTRY _ZTI3E32[];
extern  VTBL_ENTRY _ZTV3E32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E32[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3E323barEv,_ZTv0_n16_N3E323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E323barEv,_ZThn8_N3E323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E32 = {  "E32", // class name
  bases_E32, 1,
  &(vtc_E32[0]), // expected_vtbl_contents
  &(vtt_E32[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E32),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E32),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E32),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F32  : virtual AA3 {
  int pf;
  virtual void  bar(); // _ZN3F323barEv
  ~F32(); // tgen
  F32(); // tgen
};
//SIG(-1 F32) C1{ VBC2{ v2 v1 Fi} v1 Fi}


void  F32 ::bar(){vfunc_called(this, "_ZN3F323barEv");}
F32 ::~F32(){ note_dtor("F32", this);} // tgen
F32 ::F32(){ note_ctor("F32", this);} // tgen

static void Test_F32()
{
  extern Class_Descriptor cd_F32;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F32, buf);
    F32 *dp, &lv = *(dp=new (buf) F32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F32)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "F32");
    check_field_offset(lv, pf, ABISELECT(8,4), "F32.pf");
    test_class_info(&lv, &cd_F32);
    dp->~F32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF32(Test_F32, "F32", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F32C1Ev();
extern void _ZN3F32D1Ev();
Name_Map name_map_F32[] = {
  NSPAIR(_ZN3F32C1Ev),
  NSPAIR(_ZN3F32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
static Base_Class bases_F32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F32[];
extern void _ZN3F323barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_F32[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
extern VTBL_ENTRY _ZTV3F32[];
static  VTT_ENTRY vtt_F32[] = {
  {&(_ZTV3F32[3]),  3,10},
  {&(_ZTV3F32[8]),  8,10},
};
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_F32 = {  "F32", // class name
  bases_F32, 1,
  &(vtc_F32[0]), // expected_vtbl_contents
  &(vtt_F32[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F32),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F32),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F32),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  E33  : virtual AA3 {
  int pe;
  virtual void  foo(); // _ZN3E333fooEv
  virtual void  bar(); // _ZN3E333barEv
  ~E33(); // tgen
  E33(); // tgen
};
//SIG(-1 E33) C1{ VBC2{ v1 v2 Fi} v1 v2 Fi}


void  E33 ::foo(){vfunc_called(this, "_ZN3E333fooEv");}
void  E33 ::bar(){vfunc_called(this, "_ZN3E333barEv");}
E33 ::~E33(){ note_dtor("E33", this);} // tgen
E33 ::E33(){ note_ctor("E33", this);} // tgen

static void Test_E33()
{
  extern Class_Descriptor cd_E33;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_E33, buf);
    E33 *dp, &lv = *(dp=new (buf) E33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(E33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(E33)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "E33");
    check_field_offset(lv, pe, ABISELECT(8,4), "E33.pe");
    test_class_info(&lv, &cd_E33);
    dp->~E33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vE33(Test_E33, "E33", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3E33C1Ev();
extern void _ZN3E33D1Ev();
Name_Map name_map_E33[] = {
  NSPAIR(_ZN3E33C1Ev),
  NSPAIR(_ZN3E33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
static Base_Class bases_E33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3E33[];
extern void _ZN3E333fooEv();
extern void _ZN3E333barEv();
extern void ABISELECT(_ZTv0_n24_N3E333fooEv,_ZTv0_n12_N3E333fooEv)();
extern void ABISELECT(_ZThn16_N3E333fooEv,_ZThn8_N3E333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3E333barEv,_ZTv0_n16_N3E333barEv)();
extern void ABISELECT(_ZThn16_N3E333barEv,_ZThn8_N3E333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_E33[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E33[0]),
  (VTBL_ENTRY)&_ZN3E333fooEv,
  (VTBL_ENTRY)&_ZN3E333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E333fooEv,_ZTv0_n12_N3E333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3E333barEv,_ZTv0_n16_N3E333barEv),
};
extern VTBL_ENTRY _ZTV3E33[];
static  VTT_ENTRY vtt_E33[] = {
  {&(_ZTV3E33[3]),  3,11},
  {&(_ZTV3E33[9]),  9,11},
};
extern VTBL_ENTRY _ZTI3E33[];
extern  VTBL_ENTRY _ZTV3E33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E33[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3E333barEv,_ZTv0_n16_N3E333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E333barEv,_ZThn8_N3E333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E333fooEv,_ZTv0_n12_N3E333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E333fooEv,_ZThn8_N3E333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_E33 = {  "E33", // class name
  bases_E33, 1,
  &(vtc_E33[0]), // expected_vtbl_contents
  &(vtt_E33[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3E33),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3E33),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3E33),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  F33  : virtual AA3 {
  int pf;
  virtual void  foo(); // _ZN3F333fooEv
  virtual void  bar(); // _ZN3F333barEv
  ~F33(); // tgen
  F33(); // tgen
};
//SIG(-1 F33) C1{ VBC2{ v1 v2 Fi} v1 v2 Fi}


void  F33 ::foo(){vfunc_called(this, "_ZN3F333fooEv");}
void  F33 ::bar(){vfunc_called(this, "_ZN3F333barEv");}
F33 ::~F33(){ note_dtor("F33", this);} // tgen
F33 ::F33(){ note_ctor("F33", this);} // tgen

static void Test_F33()
{
  extern Class_Descriptor cd_F33;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_F33, buf);
    F33 *dp, &lv = *(dp=new (buf) F33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(F33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(F33)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "F33");
    check_field_offset(lv, pf, ABISELECT(8,4), "F33.pf");
    test_class_info(&lv, &cd_F33);
    dp->~F33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vF33(Test_F33, "F33", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN3F33C1Ev();
extern void _ZN3F33D1Ev();
Name_Map name_map_F33[] = {
  NSPAIR(_ZN3F33C1Ev),
  NSPAIR(_ZN3F33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
static Base_Class bases_F33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3F33[];
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_F33[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
extern VTBL_ENTRY _ZTV3F33[];
static  VTT_ENTRY vtt_F33[] = {
  {&(_ZTV3F33[3]),  3,11},
  {&(_ZTV3F33[9]),  9,11},
};
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_F33 = {  "F33", // class name
  bases_F33, 1,
  &(vtc_F33[0]), // expected_vtbl_contents
  &(vtt_F33[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI3F33),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3F33),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3F33),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE111  : virtual AA1 , virtual BB1 {
  int pe;
  virtual void  foo(); // _ZN5EE1113fooEv
  ~EE111(); // tgen
  EE111(); // tgen
};
//SIG(-1 EE111) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  EE111 ::foo(){vfunc_called(this, "_ZN5EE1113fooEv");}
EE111 ::~EE111(){ note_dtor("EE111", this);} // tgen
EE111 ::EE111(){ note_ctor("EE111", this);} // tgen

static void Test_EE111()
{
  extern Class_Descriptor cd_EE111;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE111, buf);
    EE111 *dp, &lv = *(dp=new (buf) EE111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE111)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE111");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE111");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE111.pe");
    test_class_info(&lv, &cd_EE111);
    dp->~EE111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE111(Test_EE111, "EE111", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE111C1Ev();
extern void _ZN5EE111D1Ev();
Name_Map name_map_EE111[] = {
  NSPAIR(_ZN5EE111C1Ev),
  NSPAIR(_ZN5EE111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE111[];
extern void _ZN5EE1113fooEv();
extern void ABISELECT(_ZTv0_n24_N5EE1113fooEv,_ZTv0_n12_N5EE1113fooEv)();
extern void ABISELECT(_ZThn16_N5EE1113fooEv,_ZThn8_N5EE1113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE1113fooEv,_ZTv0_n12_N5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N5EE1113fooEv,_ZThn16_N5EE1113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE111[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE111[0]),
  (VTBL_ENTRY)&_ZN5EE1113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1113fooEv,_ZTv0_n12_N5EE1113fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1113fooEv,_ZTv0_n12_N5EE1113fooEv),
};
extern VTBL_ENTRY _ZTV5EE111[];
static  VTT_ENTRY vtt_EE111[] = {
  {&(_ZTV5EE111[4]),  4,13},
  {&(_ZTV5EE111[8]),  8,13},
  {&(_ZTV5EE111[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE111[];
extern  VTBL_ENTRY _ZTV5EE111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE111[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1113fooEv,_ZTv0_n12_N5EE1113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1113fooEv,_ZThn16_N5EE1113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE1113fooEv,_ZThn8_N5EE1113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE111 = {  "EE111", // class name
  bases_EE111, 2,
  &(vtc_EE111[0]), // expected_vtbl_contents
  &(vtt_EE111[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE111),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE111),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF111  : virtual AA1 , virtual BB1 {
  int pf;
  virtual void  foo(); // _ZN5FF1113fooEv
  ~FF111(); // tgen
  FF111(); // tgen
};
//SIG(-1 FF111) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  FF111 ::foo(){vfunc_called(this, "_ZN5FF1113fooEv");}
FF111 ::~FF111(){ note_dtor("FF111", this);} // tgen
FF111 ::FF111(){ note_ctor("FF111", this);} // tgen

static void Test_FF111()
{
  extern Class_Descriptor cd_FF111;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF111, buf);
    FF111 *dp, &lv = *(dp=new (buf) FF111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF111)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF111");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF111");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF111.pf");
    test_class_info(&lv, &cd_FF111);
    dp->~FF111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF111(Test_FF111, "FF111", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF111C1Ev();
extern void _ZN5FF111D1Ev();
Name_Map name_map_FF111[] = {
  NSPAIR(_ZN5FF111C1Ev),
  NSPAIR(_ZN5FF111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF111[];
extern void _ZN5FF1113fooEv();
extern void ABISELECT(_ZTv0_n24_N5FF1113fooEv,_ZTv0_n12_N5FF1113fooEv)();
extern void ABISELECT(_ZThn16_N5FF1113fooEv,_ZThn8_N5FF1113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF1113fooEv,_ZTv0_n12_N5FF1113fooEv)();
extern void ABISELECT(_ZThn32_N5FF1113fooEv,_ZThn16_N5FF1113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF111[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF111[0]),
  (VTBL_ENTRY)&_ZN5FF1113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1113fooEv,_ZTv0_n12_N5FF1113fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1113fooEv,_ZTv0_n12_N5FF1113fooEv),
};
extern VTBL_ENTRY _ZTV5FF111[];
static  VTT_ENTRY vtt_FF111[] = {
  {&(_ZTV5FF111[4]),  4,13},
  {&(_ZTV5FF111[8]),  8,13},
  {&(_ZTV5FF111[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF111[];
extern  VTBL_ENTRY _ZTV5FF111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF111[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1113fooEv,_ZTv0_n12_N5FF1113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1113fooEv,_ZThn16_N5FF1113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF1113fooEv,_ZThn8_N5FF1113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF111 = {  "FF111", // class name
  bases_FF111, 2,
  &(vtc_FF111[0]), // expected_vtbl_contents
  &(vtt_FF111[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF111),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF111),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE112  : virtual AA1 , virtual BB1 {
  int pe;
  virtual void  bar(); // _ZN5EE1123barEv
  ~EE112(); // tgen
  EE112(); // tgen
};
//SIG(-1 EE112) C1{ VBC2{ v2 Fi} VBC3{ v3 Fi} v1 Fi}


void  EE112 ::bar(){vfunc_called(this, "_ZN5EE1123barEv");}
EE112 ::~EE112(){ note_dtor("EE112", this);} // tgen
EE112 ::EE112(){ note_ctor("EE112", this);} // tgen

static void Test_EE112()
{
  extern Class_Descriptor cd_EE112;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE112, buf);
    EE112 *dp, &lv = *(dp=new (buf) EE112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE112)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE112");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE112");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE112.pe");
    test_class_info(&lv, &cd_EE112);
    dp->~EE112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE112(Test_EE112, "EE112", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE112C1Ev();
extern void _ZN5EE112D1Ev();
Name_Map name_map_EE112[] = {
  NSPAIR(_ZN5EE112C1Ev),
  NSPAIR(_ZN5EE112D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE112[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE112[];
extern void _ZN5EE1123barEv();
extern void _ZN3AA13fooEv();
extern void _ZN3BB13fooEv();
static  VTBL_ENTRY vtc_EE112[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE112[0]),
  (VTBL_ENTRY)&_ZN5EE1123barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE112[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE112[0]),
  (VTBL_ENTRY)&_ZN3BB13fooEv,
};
extern VTBL_ENTRY _ZTV5EE112[];
static  VTT_ENTRY vtt_EE112[] = {
  {&(_ZTV5EE112[4]),  4,13},
  {&(_ZTV5EE112[8]),  8,13},
  {&(_ZTV5EE112[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE112[];
extern  VTBL_ENTRY _ZTV5EE112[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE112[];
Class_Descriptor cd_EE112 = {  "EE112", // class name
  bases_EE112, 2,
  &(vtc_EE112[0]), // expected_vtbl_contents
  &(vtt_EE112[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE112),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE112),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE112),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF112  : virtual AA1 , virtual BB1 {
  int pf;
  virtual void  bar(); // _ZN5FF1123barEv
  ~FF112(); // tgen
  FF112(); // tgen
};
//SIG(-1 FF112) C1{ VBC2{ v2 Fi} VBC3{ v3 Fi} v1 Fi}


void  FF112 ::bar(){vfunc_called(this, "_ZN5FF1123barEv");}
FF112 ::~FF112(){ note_dtor("FF112", this);} // tgen
FF112 ::FF112(){ note_ctor("FF112", this);} // tgen

static void Test_FF112()
{
  extern Class_Descriptor cd_FF112;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF112, buf);
    FF112 *dp, &lv = *(dp=new (buf) FF112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF112)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF112");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF112");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF112.pf");
    test_class_info(&lv, &cd_FF112);
    dp->~FF112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF112(Test_FF112, "FF112", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF112C1Ev();
extern void _ZN5FF112D1Ev();
Name_Map name_map_FF112[] = {
  NSPAIR(_ZN5FF112C1Ev),
  NSPAIR(_ZN5FF112D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF112[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF112[];
extern void _ZN5FF1123barEv();
extern void _ZN3AA13fooEv();
extern void _ZN3BB13fooEv();
static  VTBL_ENTRY vtc_FF112[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF112[0]),
  (VTBL_ENTRY)&_ZN5FF1123barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF112[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF112[0]),
  (VTBL_ENTRY)&_ZN3BB13fooEv,
};
extern VTBL_ENTRY _ZTV5FF112[];
static  VTT_ENTRY vtt_FF112[] = {
  {&(_ZTV5FF112[4]),  4,13},
  {&(_ZTV5FF112[8]),  8,13},
  {&(_ZTV5FF112[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF112[];
extern  VTBL_ENTRY _ZTV5FF112[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF112[];
Class_Descriptor cd_FF112 = {  "FF112", // class name
  bases_FF112, 2,
  &(vtc_FF112[0]), // expected_vtbl_contents
  &(vtt_FF112[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF112),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF112),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF112),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE113  : virtual AA1 , virtual BB1 {
  int pe;
  virtual void  foo(); // _ZN5EE1133fooEv
  virtual void  bar(); // _ZN5EE1133barEv
  ~EE113(); // tgen
  EE113(); // tgen
};
//SIG(-1 EE113) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 v2 Fi}


void  EE113 ::foo(){vfunc_called(this, "_ZN5EE1133fooEv");}
void  EE113 ::bar(){vfunc_called(this, "_ZN5EE1133barEv");}
EE113 ::~EE113(){ note_dtor("EE113", this);} // tgen
EE113 ::EE113(){ note_ctor("EE113", this);} // tgen

static void Test_EE113()
{
  extern Class_Descriptor cd_EE113;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE113, buf);
    EE113 *dp, &lv = *(dp=new (buf) EE113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE113)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE113");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE113");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE113.pe");
    test_class_info(&lv, &cd_EE113);
    dp->~EE113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE113(Test_EE113, "EE113", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE113C1Ev();
extern void _ZN5EE113D1Ev();
Name_Map name_map_EE113[] = {
  NSPAIR(_ZN5EE113C1Ev),
  NSPAIR(_ZN5EE113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE113[];
extern void _ZN5EE1133fooEv();
extern void _ZN5EE1133barEv();
extern void ABISELECT(_ZTv0_n24_N5EE1133fooEv,_ZTv0_n12_N5EE1133fooEv)();
extern void ABISELECT(_ZThn16_N5EE1133fooEv,_ZThn8_N5EE1133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE1133fooEv,_ZTv0_n12_N5EE1133fooEv)();
extern void ABISELECT(_ZThn32_N5EE1133fooEv,_ZThn16_N5EE1133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE113[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE113[0]),
  (VTBL_ENTRY)&_ZN5EE1133fooEv,
  (VTBL_ENTRY)&_ZN5EE1133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1133fooEv,_ZTv0_n12_N5EE1133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1133fooEv,_ZTv0_n12_N5EE1133fooEv),
};
extern VTBL_ENTRY _ZTV5EE113[];
static  VTT_ENTRY vtt_EE113[] = {
  {&(_ZTV5EE113[4]),  4,14},
  {&(_ZTV5EE113[9]),  9,14},
  {&(_ZTV5EE113[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5EE113[];
extern  VTBL_ENTRY _ZTV5EE113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE113[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1133fooEv,_ZTv0_n12_N5EE1133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1133fooEv,_ZThn16_N5EE1133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE1133fooEv,_ZThn8_N5EE1133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE113 = {  "EE113", // class name
  bases_EE113, 2,
  &(vtc_EE113[0]), // expected_vtbl_contents
  &(vtt_EE113[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE113),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE113),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF113  : virtual AA1 , virtual BB1 {
  int pf;
  virtual void  foo(); // _ZN5FF1133fooEv
  virtual void  bar(); // _ZN5FF1133barEv
  ~FF113(); // tgen
  FF113(); // tgen
};
//SIG(-1 FF113) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 v2 Fi}


void  FF113 ::foo(){vfunc_called(this, "_ZN5FF1133fooEv");}
void  FF113 ::bar(){vfunc_called(this, "_ZN5FF1133barEv");}
FF113 ::~FF113(){ note_dtor("FF113", this);} // tgen
FF113 ::FF113(){ note_ctor("FF113", this);} // tgen

static void Test_FF113()
{
  extern Class_Descriptor cd_FF113;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF113, buf);
    FF113 *dp, &lv = *(dp=new (buf) FF113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF113)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF113");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF113");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF113.pf");
    test_class_info(&lv, &cd_FF113);
    dp->~FF113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF113(Test_FF113, "FF113", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF113C1Ev();
extern void _ZN5FF113D1Ev();
Name_Map name_map_FF113[] = {
  NSPAIR(_ZN5FF113C1Ev),
  NSPAIR(_ZN5FF113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF113[];
extern void _ZN5FF1133fooEv();
extern void _ZN5FF1133barEv();
extern void ABISELECT(_ZTv0_n24_N5FF1133fooEv,_ZTv0_n12_N5FF1133fooEv)();
extern void ABISELECT(_ZThn16_N5FF1133fooEv,_ZThn8_N5FF1133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF1133fooEv,_ZTv0_n12_N5FF1133fooEv)();
extern void ABISELECT(_ZThn32_N5FF1133fooEv,_ZThn16_N5FF1133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF113[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF113[0]),
  (VTBL_ENTRY)&_ZN5FF1133fooEv,
  (VTBL_ENTRY)&_ZN5FF1133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1133fooEv,_ZTv0_n12_N5FF1133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1133fooEv,_ZTv0_n12_N5FF1133fooEv),
};
extern VTBL_ENTRY _ZTV5FF113[];
static  VTT_ENTRY vtt_FF113[] = {
  {&(_ZTV5FF113[4]),  4,14},
  {&(_ZTV5FF113[9]),  9,14},
  {&(_ZTV5FF113[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5FF113[];
extern  VTBL_ENTRY _ZTV5FF113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF113[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1133fooEv,_ZTv0_n12_N5FF1133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1133fooEv,_ZThn16_N5FF1133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF1133fooEv,_ZThn8_N5FF1133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF113 = {  "FF113", // class name
  bases_FF113, 2,
  &(vtc_FF113[0]), // expected_vtbl_contents
  &(vtt_FF113[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF113),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF113),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE121  : virtual AA1 , virtual BB2 {
  int pe;
  virtual void  foo(); // _ZN5EE1213fooEv
  ~EE121(); // tgen
  EE121(); // tgen
};
//SIG(-1 EE121) C1{ VBC2{ v1 Fi} VBC3{ v2 Fi} v1 Fi}


void  EE121 ::foo(){vfunc_called(this, "_ZN5EE1213fooEv");}
EE121 ::~EE121(){ note_dtor("EE121", this);} // tgen
EE121 ::EE121(){ note_ctor("EE121", this);} // tgen

static void Test_EE121()
{
  extern Class_Descriptor cd_EE121;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE121, buf);
    EE121 *dp, &lv = *(dp=new (buf) EE121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE121)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE121");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE121");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE121.pe");
    test_class_info(&lv, &cd_EE121);
    dp->~EE121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE121(Test_EE121, "EE121", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE121C1Ev();
extern void _ZN5EE121D1Ev();
Name_Map name_map_EE121[] = {
  NSPAIR(_ZN5EE121C1Ev),
  NSPAIR(_ZN5EE121D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE121[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE121[];
extern void _ZN5EE1213fooEv();
extern void ABISELECT(_ZTv0_n24_N5EE1213fooEv,_ZTv0_n12_N5EE1213fooEv)();
extern void ABISELECT(_ZThn16_N5EE1213fooEv,_ZThn8_N5EE1213fooEv)() __attribute__((weak));
extern void _ZN3BB23barEv();
static  VTBL_ENTRY vtc_EE121[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE121[0]),
  (VTBL_ENTRY)&_ZN5EE1213fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE121[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1213fooEv,_ZTv0_n12_N5EE1213fooEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE121[0]),
  (VTBL_ENTRY)&_ZN3BB23barEv,
};
extern VTBL_ENTRY _ZTV5EE121[];
static  VTT_ENTRY vtt_EE121[] = {
  {&(_ZTV5EE121[4]),  4,13},
  {&(_ZTV5EE121[8]),  8,13},
  {&(_ZTV5EE121[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE121[];
extern  VTBL_ENTRY _ZTV5EE121[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE121[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1213fooEv,_ZTv0_n12_N5EE1213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE1213fooEv,_ZThn8_N5EE1213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE121 = {  "EE121", // class name
  bases_EE121, 2,
  &(vtc_EE121[0]), // expected_vtbl_contents
  &(vtt_EE121[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE121),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE121),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE121),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF121  : virtual AA1 , virtual BB2 {
  int pf;
  virtual void  foo(); // _ZN5FF1213fooEv
  ~FF121(); // tgen
  FF121(); // tgen
};
//SIG(-1 FF121) C1{ VBC2{ v1 Fi} VBC3{ v2 Fi} v1 Fi}


void  FF121 ::foo(){vfunc_called(this, "_ZN5FF1213fooEv");}
FF121 ::~FF121(){ note_dtor("FF121", this);} // tgen
FF121 ::FF121(){ note_ctor("FF121", this);} // tgen

static void Test_FF121()
{
  extern Class_Descriptor cd_FF121;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF121, buf);
    FF121 *dp, &lv = *(dp=new (buf) FF121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF121)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF121");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF121");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF121.pf");
    test_class_info(&lv, &cd_FF121);
    dp->~FF121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF121(Test_FF121, "FF121", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF121C1Ev();
extern void _ZN5FF121D1Ev();
Name_Map name_map_FF121[] = {
  NSPAIR(_ZN5FF121C1Ev),
  NSPAIR(_ZN5FF121D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF121[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF121[];
extern void _ZN5FF1213fooEv();
extern void ABISELECT(_ZTv0_n24_N5FF1213fooEv,_ZTv0_n12_N5FF1213fooEv)();
extern void ABISELECT(_ZThn16_N5FF1213fooEv,_ZThn8_N5FF1213fooEv)() __attribute__((weak));
extern void _ZN3BB23barEv();
static  VTBL_ENTRY vtc_FF121[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF121[0]),
  (VTBL_ENTRY)&_ZN5FF1213fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF121[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1213fooEv,_ZTv0_n12_N5FF1213fooEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF121[0]),
  (VTBL_ENTRY)&_ZN3BB23barEv,
};
extern VTBL_ENTRY _ZTV5FF121[];
static  VTT_ENTRY vtt_FF121[] = {
  {&(_ZTV5FF121[4]),  4,13},
  {&(_ZTV5FF121[8]),  8,13},
  {&(_ZTV5FF121[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF121[];
extern  VTBL_ENTRY _ZTV5FF121[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF121[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1213fooEv,_ZTv0_n12_N5FF1213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF1213fooEv,_ZThn8_N5FF1213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF121 = {  "FF121", // class name
  bases_FF121, 2,
  &(vtc_FF121[0]), // expected_vtbl_contents
  &(vtt_FF121[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF121),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF121),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF121),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE122  : virtual AA1 , virtual BB2 {
  int pe;
  virtual void  bar(); // _ZN5EE1223barEv
  ~EE122(); // tgen
  EE122(); // tgen
};
//SIG(-1 EE122) C1{ VBC2{ v2 Fi} VBC3{ v1 Fi} v1 Fi}


void  EE122 ::bar(){vfunc_called(this, "_ZN5EE1223barEv");}
EE122 ::~EE122(){ note_dtor("EE122", this);} // tgen
EE122 ::EE122(){ note_ctor("EE122", this);} // tgen

static void Test_EE122()
{
  extern Class_Descriptor cd_EE122;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE122, buf);
    EE122 *dp, &lv = *(dp=new (buf) EE122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE122)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE122");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE122");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE122.pe");
    test_class_info(&lv, &cd_EE122);
    dp->~EE122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE122(Test_EE122, "EE122", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE122C1Ev();
extern void _ZN5EE122D1Ev();
Name_Map name_map_EE122[] = {
  NSPAIR(_ZN5EE122C1Ev),
  NSPAIR(_ZN5EE122D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE122[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE122[];
extern void _ZN5EE1223barEv();
extern void _ZN3AA13fooEv();
extern void ABISELECT(_ZTv0_n24_N5EE1223barEv,_ZTv0_n12_N5EE1223barEv)();
extern void ABISELECT(_ZThn32_N5EE1223barEv,_ZThn16_N5EE1223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE122[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE122[0]),
  (VTBL_ENTRY)&_ZN5EE1223barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE122[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE122[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1223barEv,_ZTv0_n12_N5EE1223barEv),
};
extern VTBL_ENTRY _ZTV5EE122[];
static  VTT_ENTRY vtt_EE122[] = {
  {&(_ZTV5EE122[4]),  4,13},
  {&(_ZTV5EE122[8]),  8,13},
  {&(_ZTV5EE122[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE122[];
extern  VTBL_ENTRY _ZTV5EE122[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE122[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1223barEv,_ZTv0_n12_N5EE1223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1223barEv,_ZThn16_N5EE1223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE122 = {  "EE122", // class name
  bases_EE122, 2,
  &(vtc_EE122[0]), // expected_vtbl_contents
  &(vtt_EE122[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE122),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE122),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE122),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF122  : virtual AA1 , virtual BB2 {
  int pf;
  virtual void  bar(); // _ZN5FF1223barEv
  ~FF122(); // tgen
  FF122(); // tgen
};
//SIG(-1 FF122) C1{ VBC2{ v2 Fi} VBC3{ v1 Fi} v1 Fi}


void  FF122 ::bar(){vfunc_called(this, "_ZN5FF1223barEv");}
FF122 ::~FF122(){ note_dtor("FF122", this);} // tgen
FF122 ::FF122(){ note_ctor("FF122", this);} // tgen

static void Test_FF122()
{
  extern Class_Descriptor cd_FF122;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF122, buf);
    FF122 *dp, &lv = *(dp=new (buf) FF122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF122)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF122");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF122");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF122.pf");
    test_class_info(&lv, &cd_FF122);
    dp->~FF122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF122(Test_FF122, "FF122", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF122C1Ev();
extern void _ZN5FF122D1Ev();
Name_Map name_map_FF122[] = {
  NSPAIR(_ZN5FF122C1Ev),
  NSPAIR(_ZN5FF122D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF122[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF122[];
extern void _ZN5FF1223barEv();
extern void _ZN3AA13fooEv();
extern void ABISELECT(_ZTv0_n24_N5FF1223barEv,_ZTv0_n12_N5FF1223barEv)();
extern void ABISELECT(_ZThn32_N5FF1223barEv,_ZThn16_N5FF1223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF122[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF122[0]),
  (VTBL_ENTRY)&_ZN5FF1223barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF122[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF122[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1223barEv,_ZTv0_n12_N5FF1223barEv),
};
extern VTBL_ENTRY _ZTV5FF122[];
static  VTT_ENTRY vtt_FF122[] = {
  {&(_ZTV5FF122[4]),  4,13},
  {&(_ZTV5FF122[8]),  8,13},
  {&(_ZTV5FF122[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF122[];
extern  VTBL_ENTRY _ZTV5FF122[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF122[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1223barEv,_ZTv0_n12_N5FF1223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1223barEv,_ZThn16_N5FF1223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF122 = {  "FF122", // class name
  bases_FF122, 2,
  &(vtc_FF122[0]), // expected_vtbl_contents
  &(vtt_FF122[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF122),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF122),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF122),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE123  : virtual AA1 , virtual BB2 {
  int pe;
  virtual void  foo(); // _ZN5EE1233fooEv
  virtual void  bar(); // _ZN5EE1233barEv
  ~EE123(); // tgen
  EE123(); // tgen
};
//SIG(-1 EE123) C1{ VBC2{ v1 Fi} VBC3{ v2 Fi} v1 v2 Fi}


void  EE123 ::foo(){vfunc_called(this, "_ZN5EE1233fooEv");}
void  EE123 ::bar(){vfunc_called(this, "_ZN5EE1233barEv");}
EE123 ::~EE123(){ note_dtor("EE123", this);} // tgen
EE123 ::EE123(){ note_ctor("EE123", this);} // tgen

static void Test_EE123()
{
  extern Class_Descriptor cd_EE123;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE123, buf);
    EE123 *dp, &lv = *(dp=new (buf) EE123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE123)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE123");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE123");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE123.pe");
    test_class_info(&lv, &cd_EE123);
    dp->~EE123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE123(Test_EE123, "EE123", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE123C1Ev();
extern void _ZN5EE123D1Ev();
Name_Map name_map_EE123[] = {
  NSPAIR(_ZN5EE123C1Ev),
  NSPAIR(_ZN5EE123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE123[];
extern void _ZN5EE1233fooEv();
extern void _ZN5EE1233barEv();
extern void ABISELECT(_ZTv0_n24_N5EE1233fooEv,_ZTv0_n12_N5EE1233fooEv)();
extern void ABISELECT(_ZThn16_N5EE1233fooEv,_ZThn8_N5EE1233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE1233barEv,_ZTv0_n12_N5EE1233barEv)();
extern void ABISELECT(_ZThn32_N5EE1233barEv,_ZThn16_N5EE1233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE123[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE123[0]),
  (VTBL_ENTRY)&_ZN5EE1233fooEv,
  (VTBL_ENTRY)&_ZN5EE1233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1233fooEv,_ZTv0_n12_N5EE1233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1233barEv,_ZTv0_n12_N5EE1233barEv),
};
extern VTBL_ENTRY _ZTV5EE123[];
static  VTT_ENTRY vtt_EE123[] = {
  {&(_ZTV5EE123[4]),  4,14},
  {&(_ZTV5EE123[9]),  9,14},
  {&(_ZTV5EE123[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5EE123[];
extern  VTBL_ENTRY _ZTV5EE123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE123[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1233barEv,_ZTv0_n12_N5EE1233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1233barEv,_ZThn16_N5EE1233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1233fooEv,_ZTv0_n12_N5EE1233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE1233fooEv,_ZThn8_N5EE1233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE123 = {  "EE123", // class name
  bases_EE123, 2,
  &(vtc_EE123[0]), // expected_vtbl_contents
  &(vtt_EE123[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE123),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE123),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF123  : virtual AA1 , virtual BB2 {
  int pf;
  virtual void  foo(); // _ZN5FF1233fooEv
  virtual void  bar(); // _ZN5FF1233barEv
  ~FF123(); // tgen
  FF123(); // tgen
};
//SIG(-1 FF123) C1{ VBC2{ v1 Fi} VBC3{ v2 Fi} v1 v2 Fi}


void  FF123 ::foo(){vfunc_called(this, "_ZN5FF1233fooEv");}
void  FF123 ::bar(){vfunc_called(this, "_ZN5FF1233barEv");}
FF123 ::~FF123(){ note_dtor("FF123", this);} // tgen
FF123 ::FF123(){ note_ctor("FF123", this);} // tgen

static void Test_FF123()
{
  extern Class_Descriptor cd_FF123;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF123, buf);
    FF123 *dp, &lv = *(dp=new (buf) FF123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF123)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF123");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF123");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF123.pf");
    test_class_info(&lv, &cd_FF123);
    dp->~FF123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF123(Test_FF123, "FF123", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF123C1Ev();
extern void _ZN5FF123D1Ev();
Name_Map name_map_FF123[] = {
  NSPAIR(_ZN5FF123C1Ev),
  NSPAIR(_ZN5FF123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF123[];
extern void _ZN5FF1233fooEv();
extern void _ZN5FF1233barEv();
extern void ABISELECT(_ZTv0_n24_N5FF1233fooEv,_ZTv0_n12_N5FF1233fooEv)();
extern void ABISELECT(_ZThn16_N5FF1233fooEv,_ZThn8_N5FF1233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF1233barEv,_ZTv0_n12_N5FF1233barEv)();
extern void ABISELECT(_ZThn32_N5FF1233barEv,_ZThn16_N5FF1233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF123[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF123[0]),
  (VTBL_ENTRY)&_ZN5FF1233fooEv,
  (VTBL_ENTRY)&_ZN5FF1233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1233fooEv,_ZTv0_n12_N5FF1233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1233barEv,_ZTv0_n12_N5FF1233barEv),
};
extern VTBL_ENTRY _ZTV5FF123[];
static  VTT_ENTRY vtt_FF123[] = {
  {&(_ZTV5FF123[4]),  4,14},
  {&(_ZTV5FF123[9]),  9,14},
  {&(_ZTV5FF123[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5FF123[];
extern  VTBL_ENTRY _ZTV5FF123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF123[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1233barEv,_ZTv0_n12_N5FF1233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1233barEv,_ZThn16_N5FF1233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1233fooEv,_ZTv0_n12_N5FF1233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF1233fooEv,_ZThn8_N5FF1233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF123 = {  "FF123", // class name
  bases_FF123, 2,
  &(vtc_FF123[0]), // expected_vtbl_contents
  &(vtt_FF123[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF123),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF123),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE131  : virtual AA1 , virtual BB3 {
  int pe;
  virtual void  foo(); // _ZN5EE1313fooEv
  ~EE131(); // tgen
  EE131(); // tgen
};
//SIG(-1 EE131) C1{ VBC2{ v1 Fi} VBC3{ v1 v2 Fi} v1 Fi}


void  EE131 ::foo(){vfunc_called(this, "_ZN5EE1313fooEv");}
EE131 ::~EE131(){ note_dtor("EE131", this);} // tgen
EE131 ::EE131(){ note_ctor("EE131", this);} // tgen

static void Test_EE131()
{
  extern Class_Descriptor cd_EE131;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE131, buf);
    EE131 *dp, &lv = *(dp=new (buf) EE131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE131)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE131");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE131");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE131.pe");
    test_class_info(&lv, &cd_EE131);
    dp->~EE131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE131(Test_EE131, "EE131", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE131C1Ev();
extern void _ZN5EE131D1Ev();
Name_Map name_map_EE131[] = {
  NSPAIR(_ZN5EE131C1Ev),
  NSPAIR(_ZN5EE131D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE131[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE131[];
extern void _ZN5EE1313fooEv();
extern void ABISELECT(_ZTv0_n24_N5EE1313fooEv,_ZTv0_n12_N5EE1313fooEv)();
extern void ABISELECT(_ZThn16_N5EE1313fooEv,_ZThn8_N5EE1313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE1313fooEv,_ZTv0_n12_N5EE1313fooEv)();
extern void ABISELECT(_ZThn32_N5EE1313fooEv,_ZThn16_N5EE1313fooEv)() __attribute__((weak));
extern void _ZN3BB33barEv();
static  VTBL_ENTRY vtc_EE131[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE131[0]),
  (VTBL_ENTRY)&_ZN5EE1313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE131[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1313fooEv,_ZTv0_n12_N5EE1313fooEv),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE131[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1313fooEv,_ZTv0_n12_N5EE1313fooEv),
  (VTBL_ENTRY)&_ZN3BB33barEv,
};
extern VTBL_ENTRY _ZTV5EE131[];
static  VTT_ENTRY vtt_EE131[] = {
  {&(_ZTV5EE131[4]),  4,15},
  {&(_ZTV5EE131[8]),  8,15},
  {&(_ZTV5EE131[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5EE131[];
extern  VTBL_ENTRY _ZTV5EE131[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE131[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1313fooEv,_ZTv0_n12_N5EE1313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1313fooEv,_ZThn16_N5EE1313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE1313fooEv,_ZThn8_N5EE1313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE131 = {  "EE131", // class name
  bases_EE131, 2,
  &(vtc_EE131[0]), // expected_vtbl_contents
  &(vtt_EE131[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE131),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE131),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE131),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF131  : virtual AA1 , virtual BB3 {
  int pf;
  virtual void  foo(); // _ZN5FF1313fooEv
  ~FF131(); // tgen
  FF131(); // tgen
};
//SIG(-1 FF131) C1{ VBC2{ v1 Fi} VBC3{ v1 v2 Fi} v1 Fi}


void  FF131 ::foo(){vfunc_called(this, "_ZN5FF1313fooEv");}
FF131 ::~FF131(){ note_dtor("FF131", this);} // tgen
FF131 ::FF131(){ note_ctor("FF131", this);} // tgen

static void Test_FF131()
{
  extern Class_Descriptor cd_FF131;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF131, buf);
    FF131 *dp, &lv = *(dp=new (buf) FF131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF131)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF131");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF131");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF131.pf");
    test_class_info(&lv, &cd_FF131);
    dp->~FF131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF131(Test_FF131, "FF131", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF131C1Ev();
extern void _ZN5FF131D1Ev();
Name_Map name_map_FF131[] = {
  NSPAIR(_ZN5FF131C1Ev),
  NSPAIR(_ZN5FF131D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF131[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF131[];
extern void _ZN5FF1313fooEv();
extern void ABISELECT(_ZTv0_n24_N5FF1313fooEv,_ZTv0_n12_N5FF1313fooEv)();
extern void ABISELECT(_ZThn16_N5FF1313fooEv,_ZThn8_N5FF1313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF1313fooEv,_ZTv0_n12_N5FF1313fooEv)();
extern void ABISELECT(_ZThn32_N5FF1313fooEv,_ZThn16_N5FF1313fooEv)() __attribute__((weak));
extern void _ZN3BB33barEv();
static  VTBL_ENTRY vtc_FF131[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF131[0]),
  (VTBL_ENTRY)&_ZN5FF1313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF131[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1313fooEv,_ZTv0_n12_N5FF1313fooEv),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF131[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1313fooEv,_ZTv0_n12_N5FF1313fooEv),
  (VTBL_ENTRY)&_ZN3BB33barEv,
};
extern VTBL_ENTRY _ZTV5FF131[];
static  VTT_ENTRY vtt_FF131[] = {
  {&(_ZTV5FF131[4]),  4,15},
  {&(_ZTV5FF131[8]),  8,15},
  {&(_ZTV5FF131[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5FF131[];
extern  VTBL_ENTRY _ZTV5FF131[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF131[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1313fooEv,_ZTv0_n12_N5FF1313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1313fooEv,_ZThn16_N5FF1313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF1313fooEv,_ZThn8_N5FF1313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF131 = {  "FF131", // class name
  bases_FF131, 2,
  &(vtc_FF131[0]), // expected_vtbl_contents
  &(vtt_FF131[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF131),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF131),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF131),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE132  : virtual AA1 , virtual BB3 {
  int pe;
  virtual void  bar(); // _ZN5EE1323barEv
  ~EE132(); // tgen
  EE132(); // tgen
};
//SIG(-1 EE132) C1{ VBC2{ v2 Fi} VBC3{ v3 v1 Fi} v1 Fi}


void  EE132 ::bar(){vfunc_called(this, "_ZN5EE1323barEv");}
EE132 ::~EE132(){ note_dtor("EE132", this);} // tgen
EE132 ::EE132(){ note_ctor("EE132", this);} // tgen

static void Test_EE132()
{
  extern Class_Descriptor cd_EE132;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE132, buf);
    EE132 *dp, &lv = *(dp=new (buf) EE132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE132)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE132");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE132");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE132.pe");
    test_class_info(&lv, &cd_EE132);
    dp->~EE132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE132(Test_EE132, "EE132", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE132C1Ev();
extern void _ZN5EE132D1Ev();
Name_Map name_map_EE132[] = {
  NSPAIR(_ZN5EE132C1Ev),
  NSPAIR(_ZN5EE132D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE132[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE132[];
extern void _ZN5EE1323barEv();
extern void _ZN3AA13fooEv();
extern void _ZN3BB33fooEv();
extern void ABISELECT(_ZTv0_n32_N5EE1323barEv,_ZTv0_n16_N5EE1323barEv)();
extern void ABISELECT(_ZThn32_N5EE1323barEv,_ZThn16_N5EE1323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE132[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE132[0]),
  (VTBL_ENTRY)&_ZN5EE1323barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE132[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE132[0]),
  (VTBL_ENTRY)&_ZN3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE1323barEv,_ZTv0_n16_N5EE1323barEv),
};
extern VTBL_ENTRY _ZTV5EE132[];
static  VTT_ENTRY vtt_EE132[] = {
  {&(_ZTV5EE132[4]),  4,15},
  {&(_ZTV5EE132[8]),  8,15},
  {&(_ZTV5EE132[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5EE132[];
extern  VTBL_ENTRY _ZTV5EE132[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE132[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE1323barEv,_ZTv0_n16_N5EE1323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1323barEv,_ZThn16_N5EE1323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE132 = {  "EE132", // class name
  bases_EE132, 2,
  &(vtc_EE132[0]), // expected_vtbl_contents
  &(vtt_EE132[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE132),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE132),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE132),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF132  : virtual AA1 , virtual BB3 {
  int pf;
  virtual void  bar(); // _ZN5FF1323barEv
  ~FF132(); // tgen
  FF132(); // tgen
};
//SIG(-1 FF132) C1{ VBC2{ v2 Fi} VBC3{ v3 v1 Fi} v1 Fi}


void  FF132 ::bar(){vfunc_called(this, "_ZN5FF1323barEv");}
FF132 ::~FF132(){ note_dtor("FF132", this);} // tgen
FF132 ::FF132(){ note_ctor("FF132", this);} // tgen

static void Test_FF132()
{
  extern Class_Descriptor cd_FF132;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF132, buf);
    FF132 *dp, &lv = *(dp=new (buf) FF132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF132)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF132");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF132");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF132.pf");
    test_class_info(&lv, &cd_FF132);
    dp->~FF132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF132(Test_FF132, "FF132", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF132C1Ev();
extern void _ZN5FF132D1Ev();
Name_Map name_map_FF132[] = {
  NSPAIR(_ZN5FF132C1Ev),
  NSPAIR(_ZN5FF132D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF132[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF132[];
extern void _ZN5FF1323barEv();
extern void _ZN3AA13fooEv();
extern void _ZN3BB33fooEv();
extern void ABISELECT(_ZTv0_n32_N5FF1323barEv,_ZTv0_n16_N5FF1323barEv)();
extern void ABISELECT(_ZThn32_N5FF1323barEv,_ZThn16_N5FF1323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF132[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF132[0]),
  (VTBL_ENTRY)&_ZN5FF1323barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF132[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF132[0]),
  (VTBL_ENTRY)&_ZN3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF1323barEv,_ZTv0_n16_N5FF1323barEv),
};
extern VTBL_ENTRY _ZTV5FF132[];
static  VTT_ENTRY vtt_FF132[] = {
  {&(_ZTV5FF132[4]),  4,15},
  {&(_ZTV5FF132[8]),  8,15},
  {&(_ZTV5FF132[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5FF132[];
extern  VTBL_ENTRY _ZTV5FF132[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF132[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF1323barEv,_ZTv0_n16_N5FF1323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1323barEv,_ZThn16_N5FF1323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF132 = {  "FF132", // class name
  bases_FF132, 2,
  &(vtc_FF132[0]), // expected_vtbl_contents
  &(vtt_FF132[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF132),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF132),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF132),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE133  : virtual AA1 , virtual BB3 {
  int pe;
  virtual void  foo(); // _ZN5EE1333fooEv
  virtual void  bar(); // _ZN5EE1333barEv
  ~EE133(); // tgen
  EE133(); // tgen
};
//SIG(-1 EE133) C1{ VBC2{ v1 Fi} VBC3{ v1 v2 Fi} v1 v2 Fi}


void  EE133 ::foo(){vfunc_called(this, "_ZN5EE1333fooEv");}
void  EE133 ::bar(){vfunc_called(this, "_ZN5EE1333barEv");}
EE133 ::~EE133(){ note_dtor("EE133", this);} // tgen
EE133 ::EE133(){ note_ctor("EE133", this);} // tgen

static void Test_EE133()
{
  extern Class_Descriptor cd_EE133;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE133, buf);
    EE133 *dp, &lv = *(dp=new (buf) EE133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE133)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "EE133");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE133");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE133.pe");
    test_class_info(&lv, &cd_EE133);
    dp->~EE133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE133(Test_EE133, "EE133", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE133C1Ev();
extern void _ZN5EE133D1Ev();
Name_Map name_map_EE133[] = {
  NSPAIR(_ZN5EE133C1Ev),
  NSPAIR(_ZN5EE133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE133[];
extern void _ZN5EE1333fooEv();
extern void _ZN5EE1333barEv();
extern void ABISELECT(_ZTv0_n24_N5EE1333fooEv,_ZTv0_n12_N5EE1333fooEv)();
extern void ABISELECT(_ZThn16_N5EE1333fooEv,_ZThn8_N5EE1333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE1333fooEv,_ZTv0_n12_N5EE1333fooEv)();
extern void ABISELECT(_ZThn32_N5EE1333fooEv,_ZThn16_N5EE1333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5EE1333barEv,_ZTv0_n16_N5EE1333barEv)();
extern void ABISELECT(_ZThn32_N5EE1333barEv,_ZThn16_N5EE1333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE133[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE133[0]),
  (VTBL_ENTRY)&_ZN5EE1333fooEv,
  (VTBL_ENTRY)&_ZN5EE1333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1333fooEv,_ZTv0_n12_N5EE1333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE1333fooEv,_ZTv0_n12_N5EE1333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE1333barEv,_ZTv0_n16_N5EE1333barEv),
};
extern VTBL_ENTRY _ZTV5EE133[];
static  VTT_ENTRY vtt_EE133[] = {
  {&(_ZTV5EE133[4]),  4,16},
  {&(_ZTV5EE133[9]),  9,16},
  {&(_ZTV5EE133[14]),  14,16},
};
extern VTBL_ENTRY _ZTI5EE133[];
extern  VTBL_ENTRY _ZTV5EE133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE133[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE1333barEv,_ZTv0_n16_N5EE1333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1333barEv,_ZThn16_N5EE1333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE1333fooEv,_ZTv0_n12_N5EE1333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE1333fooEv,_ZThn16_N5EE1333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE1333fooEv,_ZThn8_N5EE1333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE133 = {  "EE133", // class name
  bases_EE133, 2,
  &(vtc_EE133[0]), // expected_vtbl_contents
  &(vtt_EE133[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE133),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE133),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF133  : virtual AA1 , virtual BB3 {
  int pf;
  virtual void  foo(); // _ZN5FF1333fooEv
  virtual void  bar(); // _ZN5FF1333barEv
  ~FF133(); // tgen
  FF133(); // tgen
};
//SIG(-1 FF133) C1{ VBC2{ v1 Fi} VBC3{ v1 v2 Fi} v1 v2 Fi}


void  FF133 ::foo(){vfunc_called(this, "_ZN5FF1333fooEv");}
void  FF133 ::bar(){vfunc_called(this, "_ZN5FF1333barEv");}
FF133 ::~FF133(){ note_dtor("FF133", this);} // tgen
FF133 ::FF133(){ note_ctor("FF133", this);} // tgen

static void Test_FF133()
{
  extern Class_Descriptor cd_FF133;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF133, buf);
    FF133 *dp, &lv = *(dp=new (buf) FF133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF133)");
    check_base_class_offset(lv, (AA1*), ABISELECT(16,8), "FF133");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF133");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF133.pf");
    test_class_info(&lv, &cd_FF133);
    dp->~FF133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF133(Test_FF133, "FF133", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF133C1Ev();
extern void _ZN5FF133D1Ev();
Name_Map name_map_FF133[] = {
  NSPAIR(_ZN5FF133C1Ev),
  NSPAIR(_ZN5FF133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF133[];
extern void _ZN5FF1333fooEv();
extern void _ZN5FF1333barEv();
extern void ABISELECT(_ZTv0_n24_N5FF1333fooEv,_ZTv0_n12_N5FF1333fooEv)();
extern void ABISELECT(_ZThn16_N5FF1333fooEv,_ZThn8_N5FF1333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF1333fooEv,_ZTv0_n12_N5FF1333fooEv)();
extern void ABISELECT(_ZThn32_N5FF1333fooEv,_ZThn16_N5FF1333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5FF1333barEv,_ZTv0_n16_N5FF1333barEv)();
extern void ABISELECT(_ZThn32_N5FF1333barEv,_ZThn16_N5FF1333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF133[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF133[0]),
  (VTBL_ENTRY)&_ZN5FF1333fooEv,
  (VTBL_ENTRY)&_ZN5FF1333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1333fooEv,_ZTv0_n12_N5FF1333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF1333fooEv,_ZTv0_n12_N5FF1333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF1333barEv,_ZTv0_n16_N5FF1333barEv),
};
extern VTBL_ENTRY _ZTV5FF133[];
static  VTT_ENTRY vtt_FF133[] = {
  {&(_ZTV5FF133[4]),  4,16},
  {&(_ZTV5FF133[9]),  9,16},
  {&(_ZTV5FF133[14]),  14,16},
};
extern VTBL_ENTRY _ZTI5FF133[];
extern  VTBL_ENTRY _ZTV5FF133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF133[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF1333barEv,_ZTv0_n16_N5FF1333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1333barEv,_ZThn16_N5FF1333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF1333fooEv,_ZTv0_n12_N5FF1333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF1333fooEv,_ZThn16_N5FF1333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF1333fooEv,_ZThn8_N5FF1333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF133 = {  "FF133", // class name
  bases_FF133, 2,
  &(vtc_FF133[0]), // expected_vtbl_contents
  &(vtt_FF133[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF133),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF133),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE211  : virtual AA2 , virtual BB1 {
  int pe;
  virtual void  foo(); // _ZN5EE2113fooEv
  ~EE211(); // tgen
  EE211(); // tgen
};
//SIG(-1 EE211) C1{ VBC2{ v2 Fi} VBC3{ v1 Fi} v1 Fi}


void  EE211 ::foo(){vfunc_called(this, "_ZN5EE2113fooEv");}
EE211 ::~EE211(){ note_dtor("EE211", this);} // tgen
EE211 ::EE211(){ note_ctor("EE211", this);} // tgen

static void Test_EE211()
{
  extern Class_Descriptor cd_EE211;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE211, buf);
    EE211 *dp, &lv = *(dp=new (buf) EE211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE211)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE211");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE211");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE211.pe");
    test_class_info(&lv, &cd_EE211);
    dp->~EE211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE211(Test_EE211, "EE211", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE211C1Ev();
extern void _ZN5EE211D1Ev();
Name_Map name_map_EE211[] = {
  NSPAIR(_ZN5EE211C1Ev),
  NSPAIR(_ZN5EE211D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE211[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE211[];
extern void _ZN5EE2113fooEv();
extern void _ZN3AA23barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2113fooEv,_ZTv0_n12_N5EE2113fooEv)();
extern void ABISELECT(_ZThn32_N5EE2113fooEv,_ZThn16_N5EE2113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE211[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE211[0]),
  (VTBL_ENTRY)&_ZN5EE2113fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE211[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE211[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2113fooEv,_ZTv0_n12_N5EE2113fooEv),
};
extern VTBL_ENTRY _ZTV5EE211[];
static  VTT_ENTRY vtt_EE211[] = {
  {&(_ZTV5EE211[4]),  4,13},
  {&(_ZTV5EE211[8]),  8,13},
  {&(_ZTV5EE211[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE211[];
extern  VTBL_ENTRY _ZTV5EE211[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE211[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2113fooEv,_ZTv0_n12_N5EE2113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2113fooEv,_ZThn16_N5EE2113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE211 = {  "EE211", // class name
  bases_EE211, 2,
  &(vtc_EE211[0]), // expected_vtbl_contents
  &(vtt_EE211[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE211),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE211),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE211),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF211  : virtual AA2 , virtual BB1 {
  int pf;
  virtual void  foo(); // _ZN5FF2113fooEv
  ~FF211(); // tgen
  FF211(); // tgen
};
//SIG(-1 FF211) C1{ VBC2{ v2 Fi} VBC3{ v1 Fi} v1 Fi}


void  FF211 ::foo(){vfunc_called(this, "_ZN5FF2113fooEv");}
FF211 ::~FF211(){ note_dtor("FF211", this);} // tgen
FF211 ::FF211(){ note_ctor("FF211", this);} // tgen

static void Test_FF211()
{
  extern Class_Descriptor cd_FF211;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF211, buf);
    FF211 *dp, &lv = *(dp=new (buf) FF211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF211)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF211");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF211");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF211.pf");
    test_class_info(&lv, &cd_FF211);
    dp->~FF211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF211(Test_FF211, "FF211", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF211C1Ev();
extern void _ZN5FF211D1Ev();
Name_Map name_map_FF211[] = {
  NSPAIR(_ZN5FF211C1Ev),
  NSPAIR(_ZN5FF211D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF211[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF211[];
extern void _ZN5FF2113fooEv();
extern void _ZN3AA23barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2113fooEv,_ZTv0_n12_N5FF2113fooEv)();
extern void ABISELECT(_ZThn32_N5FF2113fooEv,_ZThn16_N5FF2113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF211[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF211[0]),
  (VTBL_ENTRY)&_ZN5FF2113fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF211[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF211[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2113fooEv,_ZTv0_n12_N5FF2113fooEv),
};
extern VTBL_ENTRY _ZTV5FF211[];
static  VTT_ENTRY vtt_FF211[] = {
  {&(_ZTV5FF211[4]),  4,13},
  {&(_ZTV5FF211[8]),  8,13},
  {&(_ZTV5FF211[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF211[];
extern  VTBL_ENTRY _ZTV5FF211[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF211[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2113fooEv,_ZTv0_n12_N5FF2113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2113fooEv,_ZThn16_N5FF2113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF211 = {  "FF211", // class name
  bases_FF211, 2,
  &(vtc_FF211[0]), // expected_vtbl_contents
  &(vtt_FF211[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF211),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF211),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF211),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE212  : virtual AA2 , virtual BB1 {
  int pe;
  virtual void  bar(); // _ZN5EE2123barEv
  ~EE212(); // tgen
  EE212(); // tgen
};
//SIG(-1 EE212) C1{ VBC2{ v1 Fi} VBC3{ v2 Fi} v1 Fi}


void  EE212 ::bar(){vfunc_called(this, "_ZN5EE2123barEv");}
EE212 ::~EE212(){ note_dtor("EE212", this);} // tgen
EE212 ::EE212(){ note_ctor("EE212", this);} // tgen

static void Test_EE212()
{
  extern Class_Descriptor cd_EE212;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE212, buf);
    EE212 *dp, &lv = *(dp=new (buf) EE212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE212)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE212");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE212");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE212.pe");
    test_class_info(&lv, &cd_EE212);
    dp->~EE212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE212(Test_EE212, "EE212", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE212C1Ev();
extern void _ZN5EE212D1Ev();
Name_Map name_map_EE212[] = {
  NSPAIR(_ZN5EE212C1Ev),
  NSPAIR(_ZN5EE212D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE212[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE212[];
extern void _ZN5EE2123barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2123barEv,_ZTv0_n12_N5EE2123barEv)();
extern void ABISELECT(_ZThn16_N5EE2123barEv,_ZThn8_N5EE2123barEv)() __attribute__((weak));
extern void _ZN3BB13fooEv();
static  VTBL_ENTRY vtc_EE212[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE212[0]),
  (VTBL_ENTRY)&_ZN5EE2123barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE212[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2123barEv,_ZTv0_n12_N5EE2123barEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE212[0]),
  (VTBL_ENTRY)&_ZN3BB13fooEv,
};
extern VTBL_ENTRY _ZTV5EE212[];
static  VTT_ENTRY vtt_EE212[] = {
  {&(_ZTV5EE212[4]),  4,13},
  {&(_ZTV5EE212[8]),  8,13},
  {&(_ZTV5EE212[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE212[];
extern  VTBL_ENTRY _ZTV5EE212[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE212[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2123barEv,_ZTv0_n12_N5EE2123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE2123barEv,_ZThn8_N5EE2123barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE212 = {  "EE212", // class name
  bases_EE212, 2,
  &(vtc_EE212[0]), // expected_vtbl_contents
  &(vtt_EE212[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE212),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE212),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE212),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF212  : virtual AA2 , virtual BB1 {
  int pf;
  virtual void  bar(); // _ZN5FF2123barEv
  ~FF212(); // tgen
  FF212(); // tgen
};
//SIG(-1 FF212) C1{ VBC2{ v1 Fi} VBC3{ v2 Fi} v1 Fi}


void  FF212 ::bar(){vfunc_called(this, "_ZN5FF2123barEv");}
FF212 ::~FF212(){ note_dtor("FF212", this);} // tgen
FF212 ::FF212(){ note_ctor("FF212", this);} // tgen

static void Test_FF212()
{
  extern Class_Descriptor cd_FF212;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF212, buf);
    FF212 *dp, &lv = *(dp=new (buf) FF212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF212)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF212");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF212");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF212.pf");
    test_class_info(&lv, &cd_FF212);
    dp->~FF212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF212(Test_FF212, "FF212", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF212C1Ev();
extern void _ZN5FF212D1Ev();
Name_Map name_map_FF212[] = {
  NSPAIR(_ZN5FF212C1Ev),
  NSPAIR(_ZN5FF212D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF212[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF212[];
extern void _ZN5FF2123barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2123barEv,_ZTv0_n12_N5FF2123barEv)();
extern void ABISELECT(_ZThn16_N5FF2123barEv,_ZThn8_N5FF2123barEv)() __attribute__((weak));
extern void _ZN3BB13fooEv();
static  VTBL_ENTRY vtc_FF212[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF212[0]),
  (VTBL_ENTRY)&_ZN5FF2123barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF212[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2123barEv,_ZTv0_n12_N5FF2123barEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF212[0]),
  (VTBL_ENTRY)&_ZN3BB13fooEv,
};
extern VTBL_ENTRY _ZTV5FF212[];
static  VTT_ENTRY vtt_FF212[] = {
  {&(_ZTV5FF212[4]),  4,13},
  {&(_ZTV5FF212[8]),  8,13},
  {&(_ZTV5FF212[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF212[];
extern  VTBL_ENTRY _ZTV5FF212[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF212[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2123barEv,_ZTv0_n12_N5FF2123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF2123barEv,_ZThn8_N5FF2123barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF212 = {  "FF212", // class name
  bases_FF212, 2,
  &(vtc_FF212[0]), // expected_vtbl_contents
  &(vtt_FF212[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF212),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF212),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF212),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE213  : virtual AA2 , virtual BB1 {
  int pe;
  virtual void  foo(); // _ZN5EE2133fooEv
  virtual void  bar(); // _ZN5EE2133barEv
  ~EE213(); // tgen
  EE213(); // tgen
};
//SIG(-1 EE213) C1{ VBC2{ v2 Fi} VBC3{ v1 Fi} v1 v2 Fi}


void  EE213 ::foo(){vfunc_called(this, "_ZN5EE2133fooEv");}
void  EE213 ::bar(){vfunc_called(this, "_ZN5EE2133barEv");}
EE213 ::~EE213(){ note_dtor("EE213", this);} // tgen
EE213 ::EE213(){ note_ctor("EE213", this);} // tgen

static void Test_EE213()
{
  extern Class_Descriptor cd_EE213;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE213, buf);
    EE213 *dp, &lv = *(dp=new (buf) EE213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE213)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE213");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE213");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE213.pe");
    test_class_info(&lv, &cd_EE213);
    dp->~EE213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE213(Test_EE213, "EE213", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE213C1Ev();
extern void _ZN5EE213D1Ev();
Name_Map name_map_EE213[] = {
  NSPAIR(_ZN5EE213C1Ev),
  NSPAIR(_ZN5EE213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE213[];
extern void _ZN5EE2133fooEv();
extern void _ZN5EE2133barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2133barEv,_ZTv0_n12_N5EE2133barEv)();
extern void ABISELECT(_ZThn16_N5EE2133barEv,_ZThn8_N5EE2133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE2133fooEv,_ZTv0_n12_N5EE2133fooEv)();
extern void ABISELECT(_ZThn32_N5EE2133fooEv,_ZThn16_N5EE2133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE213[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE213[0]),
  (VTBL_ENTRY)&_ZN5EE2133fooEv,
  (VTBL_ENTRY)&_ZN5EE2133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2133barEv,_ZTv0_n12_N5EE2133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2133fooEv,_ZTv0_n12_N5EE2133fooEv),
};
extern VTBL_ENTRY _ZTV5EE213[];
static  VTT_ENTRY vtt_EE213[] = {
  {&(_ZTV5EE213[4]),  4,14},
  {&(_ZTV5EE213[9]),  9,14},
  {&(_ZTV5EE213[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5EE213[];
extern  VTBL_ENTRY _ZTV5EE213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE213[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2133fooEv,_ZTv0_n12_N5EE2133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2133fooEv,_ZThn16_N5EE2133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2133barEv,_ZTv0_n12_N5EE2133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE2133barEv,_ZThn8_N5EE2133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE213 = {  "EE213", // class name
  bases_EE213, 2,
  &(vtc_EE213[0]), // expected_vtbl_contents
  &(vtt_EE213[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE213),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE213),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF213  : virtual AA2 , virtual BB1 {
  int pf;
  virtual void  foo(); // _ZN5FF2133fooEv
  virtual void  bar(); // _ZN5FF2133barEv
  ~FF213(); // tgen
  FF213(); // tgen
};
//SIG(-1 FF213) C1{ VBC2{ v2 Fi} VBC3{ v1 Fi} v1 v2 Fi}


void  FF213 ::foo(){vfunc_called(this, "_ZN5FF2133fooEv");}
void  FF213 ::bar(){vfunc_called(this, "_ZN5FF2133barEv");}
FF213 ::~FF213(){ note_dtor("FF213", this);} // tgen
FF213 ::FF213(){ note_ctor("FF213", this);} // tgen

static void Test_FF213()
{
  extern Class_Descriptor cd_FF213;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF213, buf);
    FF213 *dp, &lv = *(dp=new (buf) FF213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF213)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF213");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF213");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF213.pf");
    test_class_info(&lv, &cd_FF213);
    dp->~FF213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF213(Test_FF213, "FF213", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF213C1Ev();
extern void _ZN5FF213D1Ev();
Name_Map name_map_FF213[] = {
  NSPAIR(_ZN5FF213C1Ev),
  NSPAIR(_ZN5FF213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF213[];
extern void _ZN5FF2133fooEv();
extern void _ZN5FF2133barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2133barEv,_ZTv0_n12_N5FF2133barEv)();
extern void ABISELECT(_ZThn16_N5FF2133barEv,_ZThn8_N5FF2133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF2133fooEv,_ZTv0_n12_N5FF2133fooEv)();
extern void ABISELECT(_ZThn32_N5FF2133fooEv,_ZThn16_N5FF2133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF213[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF213[0]),
  (VTBL_ENTRY)&_ZN5FF2133fooEv,
  (VTBL_ENTRY)&_ZN5FF2133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2133barEv,_ZTv0_n12_N5FF2133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2133fooEv,_ZTv0_n12_N5FF2133fooEv),
};
extern VTBL_ENTRY _ZTV5FF213[];
static  VTT_ENTRY vtt_FF213[] = {
  {&(_ZTV5FF213[4]),  4,14},
  {&(_ZTV5FF213[9]),  9,14},
  {&(_ZTV5FF213[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5FF213[];
extern  VTBL_ENTRY _ZTV5FF213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF213[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2133fooEv,_ZTv0_n12_N5FF2133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2133fooEv,_ZThn16_N5FF2133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2133barEv,_ZTv0_n12_N5FF2133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF2133barEv,_ZThn8_N5FF2133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF213 = {  "FF213", // class name
  bases_FF213, 2,
  &(vtc_FF213[0]), // expected_vtbl_contents
  &(vtt_FF213[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF213),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF213),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE221  : virtual AA2 , virtual BB2 {
  int pe;
  virtual void  foo(); // _ZN5EE2213fooEv
  ~EE221(); // tgen
  EE221(); // tgen
};
//SIG(-1 EE221) C1{ VBC2{ v2 Fi} VBC3{ v3 Fi} v1 Fi}


void  EE221 ::foo(){vfunc_called(this, "_ZN5EE2213fooEv");}
EE221 ::~EE221(){ note_dtor("EE221", this);} // tgen
EE221 ::EE221(){ note_ctor("EE221", this);} // tgen

static void Test_EE221()
{
  extern Class_Descriptor cd_EE221;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE221, buf);
    EE221 *dp, &lv = *(dp=new (buf) EE221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE221)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE221");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE221");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE221.pe");
    test_class_info(&lv, &cd_EE221);
    dp->~EE221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE221(Test_EE221, "EE221", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE221C1Ev();
extern void _ZN5EE221D1Ev();
Name_Map name_map_EE221[] = {
  NSPAIR(_ZN5EE221C1Ev),
  NSPAIR(_ZN5EE221D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE221[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE221[];
extern void _ZN5EE2213fooEv();
extern void _ZN3AA23barEv();
extern void _ZN3BB23barEv();
static  VTBL_ENTRY vtc_EE221[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE221[0]),
  (VTBL_ENTRY)&_ZN5EE2213fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE221[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE221[0]),
  (VTBL_ENTRY)&_ZN3BB23barEv,
};
extern VTBL_ENTRY _ZTV5EE221[];
static  VTT_ENTRY vtt_EE221[] = {
  {&(_ZTV5EE221[4]),  4,13},
  {&(_ZTV5EE221[8]),  8,13},
  {&(_ZTV5EE221[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE221[];
extern  VTBL_ENTRY _ZTV5EE221[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE221[];
Class_Descriptor cd_EE221 = {  "EE221", // class name
  bases_EE221, 2,
  &(vtc_EE221[0]), // expected_vtbl_contents
  &(vtt_EE221[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE221),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE221),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE221),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF221  : virtual AA2 , virtual BB2 {
  int pf;
  virtual void  foo(); // _ZN5FF2213fooEv
  ~FF221(); // tgen
  FF221(); // tgen
};
//SIG(-1 FF221) C1{ VBC2{ v2 Fi} VBC3{ v3 Fi} v1 Fi}


void  FF221 ::foo(){vfunc_called(this, "_ZN5FF2213fooEv");}
FF221 ::~FF221(){ note_dtor("FF221", this);} // tgen
FF221 ::FF221(){ note_ctor("FF221", this);} // tgen

static void Test_FF221()
{
  extern Class_Descriptor cd_FF221;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF221, buf);
    FF221 *dp, &lv = *(dp=new (buf) FF221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF221)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF221");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF221");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF221.pf");
    test_class_info(&lv, &cd_FF221);
    dp->~FF221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF221(Test_FF221, "FF221", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF221C1Ev();
extern void _ZN5FF221D1Ev();
Name_Map name_map_FF221[] = {
  NSPAIR(_ZN5FF221C1Ev),
  NSPAIR(_ZN5FF221D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF221[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF221[];
extern void _ZN5FF2213fooEv();
extern void _ZN3AA23barEv();
extern void _ZN3BB23barEv();
static  VTBL_ENTRY vtc_FF221[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF221[0]),
  (VTBL_ENTRY)&_ZN5FF2213fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF221[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF221[0]),
  (VTBL_ENTRY)&_ZN3BB23barEv,
};
extern VTBL_ENTRY _ZTV5FF221[];
static  VTT_ENTRY vtt_FF221[] = {
  {&(_ZTV5FF221[4]),  4,13},
  {&(_ZTV5FF221[8]),  8,13},
  {&(_ZTV5FF221[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF221[];
extern  VTBL_ENTRY _ZTV5FF221[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF221[];
Class_Descriptor cd_FF221 = {  "FF221", // class name
  bases_FF221, 2,
  &(vtc_FF221[0]), // expected_vtbl_contents
  &(vtt_FF221[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF221),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF221),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF221),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE222  : virtual AA2 , virtual BB2 {
  int pe;
  virtual void  bar(); // _ZN5EE2223barEv
  ~EE222(); // tgen
  EE222(); // tgen
};
//SIG(-1 EE222) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  EE222 ::bar(){vfunc_called(this, "_ZN5EE2223barEv");}
EE222 ::~EE222(){ note_dtor("EE222", this);} // tgen
EE222 ::EE222(){ note_ctor("EE222", this);} // tgen

static void Test_EE222()
{
  extern Class_Descriptor cd_EE222;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE222, buf);
    EE222 *dp, &lv = *(dp=new (buf) EE222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE222)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE222");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE222");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE222.pe");
    test_class_info(&lv, &cd_EE222);
    dp->~EE222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE222(Test_EE222, "EE222", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE222C1Ev();
extern void _ZN5EE222D1Ev();
Name_Map name_map_EE222[] = {
  NSPAIR(_ZN5EE222C1Ev),
  NSPAIR(_ZN5EE222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE222[];
extern void _ZN5EE2223barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2223barEv,_ZTv0_n12_N5EE2223barEv)();
extern void ABISELECT(_ZThn16_N5EE2223barEv,_ZThn8_N5EE2223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE2223barEv,_ZTv0_n12_N5EE2223barEv)();
extern void ABISELECT(_ZThn32_N5EE2223barEv,_ZThn16_N5EE2223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE222[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE222[0]),
  (VTBL_ENTRY)&_ZN5EE2223barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2223barEv,_ZTv0_n12_N5EE2223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2223barEv,_ZTv0_n12_N5EE2223barEv),
};
extern VTBL_ENTRY _ZTV5EE222[];
static  VTT_ENTRY vtt_EE222[] = {
  {&(_ZTV5EE222[4]),  4,13},
  {&(_ZTV5EE222[8]),  8,13},
  {&(_ZTV5EE222[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5EE222[];
extern  VTBL_ENTRY _ZTV5EE222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE222[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2223barEv,_ZTv0_n12_N5EE2223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2223barEv,_ZThn16_N5EE2223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE2223barEv,_ZThn8_N5EE2223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE222 = {  "EE222", // class name
  bases_EE222, 2,
  &(vtc_EE222[0]), // expected_vtbl_contents
  &(vtt_EE222[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE222),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE222),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF222  : virtual AA2 , virtual BB2 {
  int pf;
  virtual void  bar(); // _ZN5FF2223barEv
  ~FF222(); // tgen
  FF222(); // tgen
};
//SIG(-1 FF222) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  FF222 ::bar(){vfunc_called(this, "_ZN5FF2223barEv");}
FF222 ::~FF222(){ note_dtor("FF222", this);} // tgen
FF222 ::FF222(){ note_ctor("FF222", this);} // tgen

static void Test_FF222()
{
  extern Class_Descriptor cd_FF222;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF222, buf);
    FF222 *dp, &lv = *(dp=new (buf) FF222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF222)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF222");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF222");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF222.pf");
    test_class_info(&lv, &cd_FF222);
    dp->~FF222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF222(Test_FF222, "FF222", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF222C1Ev();
extern void _ZN5FF222D1Ev();
Name_Map name_map_FF222[] = {
  NSPAIR(_ZN5FF222C1Ev),
  NSPAIR(_ZN5FF222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF222[];
extern void _ZN5FF2223barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2223barEv,_ZTv0_n12_N5FF2223barEv)();
extern void ABISELECT(_ZThn16_N5FF2223barEv,_ZThn8_N5FF2223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF2223barEv,_ZTv0_n12_N5FF2223barEv)();
extern void ABISELECT(_ZThn32_N5FF2223barEv,_ZThn16_N5FF2223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF222[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF222[0]),
  (VTBL_ENTRY)&_ZN5FF2223barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2223barEv,_ZTv0_n12_N5FF2223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2223barEv,_ZTv0_n12_N5FF2223barEv),
};
extern VTBL_ENTRY _ZTV5FF222[];
static  VTT_ENTRY vtt_FF222[] = {
  {&(_ZTV5FF222[4]),  4,13},
  {&(_ZTV5FF222[8]),  8,13},
  {&(_ZTV5FF222[12]),  12,13},
};
extern VTBL_ENTRY _ZTI5FF222[];
extern  VTBL_ENTRY _ZTV5FF222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF222[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2223barEv,_ZTv0_n12_N5FF2223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2223barEv,_ZThn16_N5FF2223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF2223barEv,_ZThn8_N5FF2223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF222 = {  "FF222", // class name
  bases_FF222, 2,
  &(vtc_FF222[0]), // expected_vtbl_contents
  &(vtt_FF222[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF222),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF222),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE223  : virtual AA2 , virtual BB2 {
  int pe;
  virtual void  foo(); // _ZN5EE2233fooEv
  virtual void  bar(); // _ZN5EE2233barEv
  ~EE223(); // tgen
  EE223(); // tgen
};
//SIG(-1 EE223) C1{ VBC2{ v2 Fi} VBC3{ v2 Fi} v1 v2 Fi}


void  EE223 ::foo(){vfunc_called(this, "_ZN5EE2233fooEv");}
void  EE223 ::bar(){vfunc_called(this, "_ZN5EE2233barEv");}
EE223 ::~EE223(){ note_dtor("EE223", this);} // tgen
EE223 ::EE223(){ note_ctor("EE223", this);} // tgen

static void Test_EE223()
{
  extern Class_Descriptor cd_EE223;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE223, buf);
    EE223 *dp, &lv = *(dp=new (buf) EE223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE223)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE223");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE223");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE223.pe");
    test_class_info(&lv, &cd_EE223);
    dp->~EE223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE223(Test_EE223, "EE223", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE223C1Ev();
extern void _ZN5EE223D1Ev();
Name_Map name_map_EE223[] = {
  NSPAIR(_ZN5EE223C1Ev),
  NSPAIR(_ZN5EE223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE223[];
extern void _ZN5EE2233fooEv();
extern void _ZN5EE2233barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2233barEv,_ZTv0_n12_N5EE2233barEv)();
extern void ABISELECT(_ZThn16_N5EE2233barEv,_ZThn8_N5EE2233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE2233barEv,_ZTv0_n12_N5EE2233barEv)();
extern void ABISELECT(_ZThn32_N5EE2233barEv,_ZThn16_N5EE2233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE223[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE223[0]),
  (VTBL_ENTRY)&_ZN5EE2233fooEv,
  (VTBL_ENTRY)&_ZN5EE2233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2233barEv,_ZTv0_n12_N5EE2233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2233barEv,_ZTv0_n12_N5EE2233barEv),
};
extern VTBL_ENTRY _ZTV5EE223[];
static  VTT_ENTRY vtt_EE223[] = {
  {&(_ZTV5EE223[4]),  4,14},
  {&(_ZTV5EE223[9]),  9,14},
  {&(_ZTV5EE223[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5EE223[];
extern  VTBL_ENTRY _ZTV5EE223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE223[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2233barEv,_ZTv0_n12_N5EE2233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2233barEv,_ZThn16_N5EE2233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE2233barEv,_ZThn8_N5EE2233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE223 = {  "EE223", // class name
  bases_EE223, 2,
  &(vtc_EE223[0]), // expected_vtbl_contents
  &(vtt_EE223[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE223),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE223),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF223  : virtual AA2 , virtual BB2 {
  int pf;
  virtual void  foo(); // _ZN5FF2233fooEv
  virtual void  bar(); // _ZN5FF2233barEv
  ~FF223(); // tgen
  FF223(); // tgen
};
//SIG(-1 FF223) C1{ VBC2{ v2 Fi} VBC3{ v2 Fi} v1 v2 Fi}


void  FF223 ::foo(){vfunc_called(this, "_ZN5FF2233fooEv");}
void  FF223 ::bar(){vfunc_called(this, "_ZN5FF2233barEv");}
FF223 ::~FF223(){ note_dtor("FF223", this);} // tgen
FF223 ::FF223(){ note_ctor("FF223", this);} // tgen

static void Test_FF223()
{
  extern Class_Descriptor cd_FF223;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF223, buf);
    FF223 *dp, &lv = *(dp=new (buf) FF223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF223)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF223");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF223");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF223.pf");
    test_class_info(&lv, &cd_FF223);
    dp->~FF223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF223(Test_FF223, "FF223", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF223C1Ev();
extern void _ZN5FF223D1Ev();
Name_Map name_map_FF223[] = {
  NSPAIR(_ZN5FF223C1Ev),
  NSPAIR(_ZN5FF223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF223[];
extern void _ZN5FF2233fooEv();
extern void _ZN5FF2233barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2233barEv,_ZTv0_n12_N5FF2233barEv)();
extern void ABISELECT(_ZThn16_N5FF2233barEv,_ZThn8_N5FF2233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF2233barEv,_ZTv0_n12_N5FF2233barEv)();
extern void ABISELECT(_ZThn32_N5FF2233barEv,_ZThn16_N5FF2233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF223[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF223[0]),
  (VTBL_ENTRY)&_ZN5FF2233fooEv,
  (VTBL_ENTRY)&_ZN5FF2233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2233barEv,_ZTv0_n12_N5FF2233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2233barEv,_ZTv0_n12_N5FF2233barEv),
};
extern VTBL_ENTRY _ZTV5FF223[];
static  VTT_ENTRY vtt_FF223[] = {
  {&(_ZTV5FF223[4]),  4,14},
  {&(_ZTV5FF223[9]),  9,14},
  {&(_ZTV5FF223[13]),  13,14},
};
extern VTBL_ENTRY _ZTI5FF223[];
extern  VTBL_ENTRY _ZTV5FF223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF223[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2233barEv,_ZTv0_n12_N5FF2233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2233barEv,_ZThn16_N5FF2233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF2233barEv,_ZThn8_N5FF2233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF223 = {  "FF223", // class name
  bases_FF223, 2,
  &(vtc_FF223[0]), // expected_vtbl_contents
  &(vtt_FF223[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF223),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF223),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE231  : virtual AA2 , virtual BB3 {
  int pe;
  virtual void  foo(); // _ZN5EE2313fooEv
  ~EE231(); // tgen
  EE231(); // tgen
};
//SIG(-1 EE231) C1{ VBC2{ v2 Fi} VBC3{ v1 v3 Fi} v1 Fi}


void  EE231 ::foo(){vfunc_called(this, "_ZN5EE2313fooEv");}
EE231 ::~EE231(){ note_dtor("EE231", this);} // tgen
EE231 ::EE231(){ note_ctor("EE231", this);} // tgen

static void Test_EE231()
{
  extern Class_Descriptor cd_EE231;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE231, buf);
    EE231 *dp, &lv = *(dp=new (buf) EE231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE231)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE231");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE231");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE231.pe");
    test_class_info(&lv, &cd_EE231);
    dp->~EE231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE231(Test_EE231, "EE231", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE231C1Ev();
extern void _ZN5EE231D1Ev();
Name_Map name_map_EE231[] = {
  NSPAIR(_ZN5EE231C1Ev),
  NSPAIR(_ZN5EE231D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE231[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE231[];
extern void _ZN5EE2313fooEv();
extern void _ZN3AA23barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2313fooEv,_ZTv0_n12_N5EE2313fooEv)();
extern void ABISELECT(_ZThn32_N5EE2313fooEv,_ZThn16_N5EE2313fooEv)() __attribute__((weak));
extern void _ZN3BB33barEv();
static  VTBL_ENTRY vtc_EE231[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE231[0]),
  (VTBL_ENTRY)&_ZN5EE2313fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE231[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE231[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2313fooEv,_ZTv0_n12_N5EE2313fooEv),
  (VTBL_ENTRY)&_ZN3BB33barEv,
};
extern VTBL_ENTRY _ZTV5EE231[];
static  VTT_ENTRY vtt_EE231[] = {
  {&(_ZTV5EE231[4]),  4,15},
  {&(_ZTV5EE231[8]),  8,15},
  {&(_ZTV5EE231[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5EE231[];
extern  VTBL_ENTRY _ZTV5EE231[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE231[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2313fooEv,_ZTv0_n12_N5EE2313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2313fooEv,_ZThn16_N5EE2313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE231 = {  "EE231", // class name
  bases_EE231, 2,
  &(vtc_EE231[0]), // expected_vtbl_contents
  &(vtt_EE231[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE231),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE231),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE231),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF231  : virtual AA2 , virtual BB3 {
  int pf;
  virtual void  foo(); // _ZN5FF2313fooEv
  ~FF231(); // tgen
  FF231(); // tgen
};
//SIG(-1 FF231) C1{ VBC2{ v2 Fi} VBC3{ v1 v3 Fi} v1 Fi}


void  FF231 ::foo(){vfunc_called(this, "_ZN5FF2313fooEv");}
FF231 ::~FF231(){ note_dtor("FF231", this);} // tgen
FF231 ::FF231(){ note_ctor("FF231", this);} // tgen

static void Test_FF231()
{
  extern Class_Descriptor cd_FF231;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF231, buf);
    FF231 *dp, &lv = *(dp=new (buf) FF231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF231)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF231");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF231");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF231.pf");
    test_class_info(&lv, &cd_FF231);
    dp->~FF231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF231(Test_FF231, "FF231", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF231C1Ev();
extern void _ZN5FF231D1Ev();
Name_Map name_map_FF231[] = {
  NSPAIR(_ZN5FF231C1Ev),
  NSPAIR(_ZN5FF231D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF231[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF231[];
extern void _ZN5FF2313fooEv();
extern void _ZN3AA23barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2313fooEv,_ZTv0_n12_N5FF2313fooEv)();
extern void ABISELECT(_ZThn32_N5FF2313fooEv,_ZThn16_N5FF2313fooEv)() __attribute__((weak));
extern void _ZN3BB33barEv();
static  VTBL_ENTRY vtc_FF231[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF231[0]),
  (VTBL_ENTRY)&_ZN5FF2313fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF231[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF231[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2313fooEv,_ZTv0_n12_N5FF2313fooEv),
  (VTBL_ENTRY)&_ZN3BB33barEv,
};
extern VTBL_ENTRY _ZTV5FF231[];
static  VTT_ENTRY vtt_FF231[] = {
  {&(_ZTV5FF231[4]),  4,15},
  {&(_ZTV5FF231[8]),  8,15},
  {&(_ZTV5FF231[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5FF231[];
extern  VTBL_ENTRY _ZTV5FF231[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF231[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2313fooEv,_ZTv0_n12_N5FF2313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2313fooEv,_ZThn16_N5FF2313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF231 = {  "FF231", // class name
  bases_FF231, 2,
  &(vtc_FF231[0]), // expected_vtbl_contents
  &(vtt_FF231[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF231),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF231),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF231),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE232  : virtual AA2 , virtual BB3 {
  int pe;
  virtual void  bar(); // _ZN5EE2323barEv
  ~EE232(); // tgen
  EE232(); // tgen
};
//SIG(-1 EE232) C1{ VBC2{ v1 Fi} VBC3{ v2 v1 Fi} v1 Fi}


void  EE232 ::bar(){vfunc_called(this, "_ZN5EE2323barEv");}
EE232 ::~EE232(){ note_dtor("EE232", this);} // tgen
EE232 ::EE232(){ note_ctor("EE232", this);} // tgen

static void Test_EE232()
{
  extern Class_Descriptor cd_EE232;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE232, buf);
    EE232 *dp, &lv = *(dp=new (buf) EE232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE232)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE232");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE232");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE232.pe");
    test_class_info(&lv, &cd_EE232);
    dp->~EE232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE232(Test_EE232, "EE232", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE232C1Ev();
extern void _ZN5EE232D1Ev();
Name_Map name_map_EE232[] = {
  NSPAIR(_ZN5EE232C1Ev),
  NSPAIR(_ZN5EE232D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE232[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE232[];
extern void _ZN5EE2323barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2323barEv,_ZTv0_n12_N5EE2323barEv)();
extern void ABISELECT(_ZThn16_N5EE2323barEv,_ZThn8_N5EE2323barEv)() __attribute__((weak));
extern void _ZN3BB33fooEv();
extern void ABISELECT(_ZTv0_n32_N5EE2323barEv,_ZTv0_n16_N5EE2323barEv)();
extern void ABISELECT(_ZThn32_N5EE2323barEv,_ZThn16_N5EE2323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE232[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE232[0]),
  (VTBL_ENTRY)&_ZN5EE2323barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE232[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2323barEv,_ZTv0_n12_N5EE2323barEv),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE232[0]),
  (VTBL_ENTRY)&_ZN3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE2323barEv,_ZTv0_n16_N5EE2323barEv),
};
extern VTBL_ENTRY _ZTV5EE232[];
static  VTT_ENTRY vtt_EE232[] = {
  {&(_ZTV5EE232[4]),  4,15},
  {&(_ZTV5EE232[8]),  8,15},
  {&(_ZTV5EE232[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5EE232[];
extern  VTBL_ENTRY _ZTV5EE232[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE232[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE2323barEv,_ZTv0_n16_N5EE2323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2323barEv,_ZThn16_N5EE2323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2323barEv,_ZTv0_n12_N5EE2323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE2323barEv,_ZThn8_N5EE2323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE232 = {  "EE232", // class name
  bases_EE232, 2,
  &(vtc_EE232[0]), // expected_vtbl_contents
  &(vtt_EE232[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE232),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE232),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE232),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF232  : virtual AA2 , virtual BB3 {
  int pf;
  virtual void  bar(); // _ZN5FF2323barEv
  ~FF232(); // tgen
  FF232(); // tgen
};
//SIG(-1 FF232) C1{ VBC2{ v1 Fi} VBC3{ v2 v1 Fi} v1 Fi}


void  FF232 ::bar(){vfunc_called(this, "_ZN5FF2323barEv");}
FF232 ::~FF232(){ note_dtor("FF232", this);} // tgen
FF232 ::FF232(){ note_ctor("FF232", this);} // tgen

static void Test_FF232()
{
  extern Class_Descriptor cd_FF232;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF232, buf);
    FF232 *dp, &lv = *(dp=new (buf) FF232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF232)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF232");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF232");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF232.pf");
    test_class_info(&lv, &cd_FF232);
    dp->~FF232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF232(Test_FF232, "FF232", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF232C1Ev();
extern void _ZN5FF232D1Ev();
Name_Map name_map_FF232[] = {
  NSPAIR(_ZN5FF232C1Ev),
  NSPAIR(_ZN5FF232D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF232[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF232[];
extern void _ZN5FF2323barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2323barEv,_ZTv0_n12_N5FF2323barEv)();
extern void ABISELECT(_ZThn16_N5FF2323barEv,_ZThn8_N5FF2323barEv)() __attribute__((weak));
extern void _ZN3BB33fooEv();
extern void ABISELECT(_ZTv0_n32_N5FF2323barEv,_ZTv0_n16_N5FF2323barEv)();
extern void ABISELECT(_ZThn32_N5FF2323barEv,_ZThn16_N5FF2323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF232[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF232[0]),
  (VTBL_ENTRY)&_ZN5FF2323barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF232[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2323barEv,_ZTv0_n12_N5FF2323barEv),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF232[0]),
  (VTBL_ENTRY)&_ZN3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF2323barEv,_ZTv0_n16_N5FF2323barEv),
};
extern VTBL_ENTRY _ZTV5FF232[];
static  VTT_ENTRY vtt_FF232[] = {
  {&(_ZTV5FF232[4]),  4,15},
  {&(_ZTV5FF232[8]),  8,15},
  {&(_ZTV5FF232[13]),  13,15},
};
extern VTBL_ENTRY _ZTI5FF232[];
extern  VTBL_ENTRY _ZTV5FF232[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF232[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF2323barEv,_ZTv0_n16_N5FF2323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2323barEv,_ZThn16_N5FF2323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2323barEv,_ZTv0_n12_N5FF2323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF2323barEv,_ZThn8_N5FF2323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF232 = {  "FF232", // class name
  bases_FF232, 2,
  &(vtc_FF232[0]), // expected_vtbl_contents
  &(vtt_FF232[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF232),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF232),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF232),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE233  : virtual AA2 , virtual BB3 {
  int pe;
  virtual void  foo(); // _ZN5EE2333fooEv
  virtual void  bar(); // _ZN5EE2333barEv
  ~EE233(); // tgen
  EE233(); // tgen
};
//SIG(-1 EE233) C1{ VBC2{ v2 Fi} VBC3{ v1 v2 Fi} v1 v2 Fi}


void  EE233 ::foo(){vfunc_called(this, "_ZN5EE2333fooEv");}
void  EE233 ::bar(){vfunc_called(this, "_ZN5EE2333barEv");}
EE233 ::~EE233(){ note_dtor("EE233", this);} // tgen
EE233 ::EE233(){ note_ctor("EE233", this);} // tgen

static void Test_EE233()
{
  extern Class_Descriptor cd_EE233;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE233, buf);
    EE233 *dp, &lv = *(dp=new (buf) EE233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE233)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "EE233");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE233");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE233.pe");
    test_class_info(&lv, &cd_EE233);
    dp->~EE233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE233(Test_EE233, "EE233", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE233C1Ev();
extern void _ZN5EE233D1Ev();
Name_Map name_map_EE233[] = {
  NSPAIR(_ZN5EE233C1Ev),
  NSPAIR(_ZN5EE233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE233[];
extern void _ZN5EE2333fooEv();
extern void _ZN5EE2333barEv();
extern void ABISELECT(_ZTv0_n24_N5EE2333barEv,_ZTv0_n12_N5EE2333barEv)();
extern void ABISELECT(_ZThn16_N5EE2333barEv,_ZThn8_N5EE2333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE2333fooEv,_ZTv0_n12_N5EE2333fooEv)();
extern void ABISELECT(_ZThn32_N5EE2333fooEv,_ZThn16_N5EE2333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5EE2333barEv,_ZTv0_n16_N5EE2333barEv)();
extern void ABISELECT(_ZThn32_N5EE2333barEv,_ZThn16_N5EE2333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE233[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE233[0]),
  (VTBL_ENTRY)&_ZN5EE2333fooEv,
  (VTBL_ENTRY)&_ZN5EE2333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2333barEv,_ZTv0_n12_N5EE2333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE2333fooEv,_ZTv0_n12_N5EE2333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE2333barEv,_ZTv0_n16_N5EE2333barEv),
};
extern VTBL_ENTRY _ZTV5EE233[];
static  VTT_ENTRY vtt_EE233[] = {
  {&(_ZTV5EE233[4]),  4,16},
  {&(_ZTV5EE233[9]),  9,16},
  {&(_ZTV5EE233[14]),  14,16},
};
extern VTBL_ENTRY _ZTI5EE233[];
extern  VTBL_ENTRY _ZTV5EE233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE233[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE2333barEv,_ZTv0_n16_N5EE2333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2333barEv,_ZThn16_N5EE2333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2333fooEv,_ZTv0_n12_N5EE2333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE2333fooEv,_ZThn16_N5EE2333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE2333barEv,_ZTv0_n12_N5EE2333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE2333barEv,_ZThn8_N5EE2333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE233 = {  "EE233", // class name
  bases_EE233, 2,
  &(vtc_EE233[0]), // expected_vtbl_contents
  &(vtt_EE233[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE233),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE233),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF233  : virtual AA2 , virtual BB3 {
  int pf;
  virtual void  foo(); // _ZN5FF2333fooEv
  virtual void  bar(); // _ZN5FF2333barEv
  ~FF233(); // tgen
  FF233(); // tgen
};
//SIG(-1 FF233) C1{ VBC2{ v2 Fi} VBC3{ v1 v2 Fi} v1 v2 Fi}


void  FF233 ::foo(){vfunc_called(this, "_ZN5FF2333fooEv");}
void  FF233 ::bar(){vfunc_called(this, "_ZN5FF2333barEv");}
FF233 ::~FF233(){ note_dtor("FF233", this);} // tgen
FF233 ::FF233(){ note_ctor("FF233", this);} // tgen

static void Test_FF233()
{
  extern Class_Descriptor cd_FF233;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF233, buf);
    FF233 *dp, &lv = *(dp=new (buf) FF233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF233)");
    check_base_class_offset(lv, (AA2*), ABISELECT(16,8), "FF233");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF233");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF233.pf");
    test_class_info(&lv, &cd_FF233);
    dp->~FF233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF233(Test_FF233, "FF233", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF233C1Ev();
extern void _ZN5FF233D1Ev();
Name_Map name_map_FF233[] = {
  NSPAIR(_ZN5FF233C1Ev),
  NSPAIR(_ZN5FF233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF233[];
extern void _ZN5FF2333fooEv();
extern void _ZN5FF2333barEv();
extern void ABISELECT(_ZTv0_n24_N5FF2333barEv,_ZTv0_n12_N5FF2333barEv)();
extern void ABISELECT(_ZThn16_N5FF2333barEv,_ZThn8_N5FF2333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF2333fooEv,_ZTv0_n12_N5FF2333fooEv)();
extern void ABISELECT(_ZThn32_N5FF2333fooEv,_ZThn16_N5FF2333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5FF2333barEv,_ZTv0_n16_N5FF2333barEv)();
extern void ABISELECT(_ZThn32_N5FF2333barEv,_ZThn16_N5FF2333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF233[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF233[0]),
  (VTBL_ENTRY)&_ZN5FF2333fooEv,
  (VTBL_ENTRY)&_ZN5FF2333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2333barEv,_ZTv0_n12_N5FF2333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF2333fooEv,_ZTv0_n12_N5FF2333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF2333barEv,_ZTv0_n16_N5FF2333barEv),
};
extern VTBL_ENTRY _ZTV5FF233[];
static  VTT_ENTRY vtt_FF233[] = {
  {&(_ZTV5FF233[4]),  4,16},
  {&(_ZTV5FF233[9]),  9,16},
  {&(_ZTV5FF233[14]),  14,16},
};
extern VTBL_ENTRY _ZTI5FF233[];
extern  VTBL_ENTRY _ZTV5FF233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF233[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF2333barEv,_ZTv0_n16_N5FF2333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2333barEv,_ZThn16_N5FF2333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2333fooEv,_ZTv0_n12_N5FF2333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF2333fooEv,_ZThn16_N5FF2333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF2333barEv,_ZTv0_n12_N5FF2333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF2333barEv,_ZThn8_N5FF2333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF233 = {  "FF233", // class name
  bases_FF233, 2,
  &(vtc_FF233[0]), // expected_vtbl_contents
  &(vtt_FF233[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF233),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF233),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE311  : virtual AA3 , virtual BB1 {
  int pe;
  virtual void  foo(); // _ZN5EE3113fooEv
  ~EE311(); // tgen
  EE311(); // tgen
};
//SIG(-1 EE311) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 Fi} v1 Fi}


void  EE311 ::foo(){vfunc_called(this, "_ZN5EE3113fooEv");}
EE311 ::~EE311(){ note_dtor("EE311", this);} // tgen
EE311 ::EE311(){ note_ctor("EE311", this);} // tgen

static void Test_EE311()
{
  extern Class_Descriptor cd_EE311;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE311, buf);
    EE311 *dp, &lv = *(dp=new (buf) EE311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE311)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE311)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE311");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE311");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE311.pe");
    test_class_info(&lv, &cd_EE311);
    dp->~EE311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE311(Test_EE311, "EE311", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE311C1Ev();
extern void _ZN5EE311D1Ev();
Name_Map name_map_EE311[] = {
  NSPAIR(_ZN5EE311C1Ev),
  NSPAIR(_ZN5EE311D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE311[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE311[];
extern void _ZN5EE3113fooEv();
extern void ABISELECT(_ZTv0_n24_N5EE3113fooEv,_ZTv0_n12_N5EE3113fooEv)();
extern void ABISELECT(_ZThn16_N5EE3113fooEv,_ZThn8_N5EE3113fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
extern void ABISELECT(_ZTv0_n24_N5EE3113fooEv,_ZTv0_n12_N5EE3113fooEv)();
extern void ABISELECT(_ZThn32_N5EE3113fooEv,_ZThn16_N5EE3113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE311[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE311[0]),
  (VTBL_ENTRY)&_ZN5EE3113fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3113fooEv,_ZTv0_n12_N5EE3113fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3113fooEv,_ZTv0_n12_N5EE3113fooEv),
};
extern VTBL_ENTRY _ZTV5EE311[];
static  VTT_ENTRY vtt_EE311[] = {
  {&(_ZTV5EE311[4]),  4,15},
  {&(_ZTV5EE311[9]),  9,15},
  {&(_ZTV5EE311[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5EE311[];
extern  VTBL_ENTRY _ZTV5EE311[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE311[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3113fooEv,_ZTv0_n12_N5EE3113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3113fooEv,_ZThn16_N5EE3113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3113fooEv,_ZThn8_N5EE3113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE311 = {  "EE311", // class name
  bases_EE311, 2,
  &(vtc_EE311[0]), // expected_vtbl_contents
  &(vtt_EE311[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE311),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE311),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE311),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF311  : virtual AA3 , virtual BB1 {
  int pf;
  virtual void  foo(); // _ZN5FF3113fooEv
  ~FF311(); // tgen
  FF311(); // tgen
};
//SIG(-1 FF311) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 Fi} v1 Fi}


void  FF311 ::foo(){vfunc_called(this, "_ZN5FF3113fooEv");}
FF311 ::~FF311(){ note_dtor("FF311", this);} // tgen
FF311 ::FF311(){ note_ctor("FF311", this);} // tgen

static void Test_FF311()
{
  extern Class_Descriptor cd_FF311;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF311, buf);
    FF311 *dp, &lv = *(dp=new (buf) FF311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF311)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF311)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF311");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF311");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF311.pf");
    test_class_info(&lv, &cd_FF311);
    dp->~FF311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF311(Test_FF311, "FF311", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF311C1Ev();
extern void _ZN5FF311D1Ev();
Name_Map name_map_FF311[] = {
  NSPAIR(_ZN5FF311C1Ev),
  NSPAIR(_ZN5FF311D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF311[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF311[];
extern void _ZN5FF3113fooEv();
extern void ABISELECT(_ZTv0_n24_N5FF3113fooEv,_ZTv0_n12_N5FF3113fooEv)();
extern void ABISELECT(_ZThn16_N5FF3113fooEv,_ZThn8_N5FF3113fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
extern void ABISELECT(_ZTv0_n24_N5FF3113fooEv,_ZTv0_n12_N5FF3113fooEv)();
extern void ABISELECT(_ZThn32_N5FF3113fooEv,_ZThn16_N5FF3113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF311[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF311[0]),
  (VTBL_ENTRY)&_ZN5FF3113fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3113fooEv,_ZTv0_n12_N5FF3113fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3113fooEv,_ZTv0_n12_N5FF3113fooEv),
};
extern VTBL_ENTRY _ZTV5FF311[];
static  VTT_ENTRY vtt_FF311[] = {
  {&(_ZTV5FF311[4]),  4,15},
  {&(_ZTV5FF311[9]),  9,15},
  {&(_ZTV5FF311[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5FF311[];
extern  VTBL_ENTRY _ZTV5FF311[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF311[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3113fooEv,_ZTv0_n12_N5FF3113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3113fooEv,_ZThn16_N5FF3113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3113fooEv,_ZThn8_N5FF3113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF311 = {  "FF311", // class name
  bases_FF311, 2,
  &(vtc_FF311[0]), // expected_vtbl_contents
  &(vtt_FF311[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF311),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF311),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF311),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE312  : virtual AA3 , virtual BB1 {
  int pe;
  virtual void  bar(); // _ZN5EE3123barEv
  ~EE312(); // tgen
  EE312(); // tgen
};
//SIG(-1 EE312) C1{ VBC2{ v2 v1 Fi} VBC3{ v3 Fi} v1 Fi}


void  EE312 ::bar(){vfunc_called(this, "_ZN5EE3123barEv");}
EE312 ::~EE312(){ note_dtor("EE312", this);} // tgen
EE312 ::EE312(){ note_ctor("EE312", this);} // tgen

static void Test_EE312()
{
  extern Class_Descriptor cd_EE312;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE312, buf);
    EE312 *dp, &lv = *(dp=new (buf) EE312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE312)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE312)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE312");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE312");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE312.pe");
    test_class_info(&lv, &cd_EE312);
    dp->~EE312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE312(Test_EE312, "EE312", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE312C1Ev();
extern void _ZN5EE312D1Ev();
Name_Map name_map_EE312[] = {
  NSPAIR(_ZN5EE312C1Ev),
  NSPAIR(_ZN5EE312D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE312[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE312[];
extern void _ZN5EE3123barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N5EE3123barEv,_ZTv0_n16_N5EE3123barEv)();
extern void ABISELECT(_ZThn16_N5EE3123barEv,_ZThn8_N5EE3123barEv)() __attribute__((weak));
extern void _ZN3BB13fooEv();
static  VTBL_ENTRY vtc_EE312[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE312[0]),
  (VTBL_ENTRY)&_ZN5EE3123barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE312[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3123barEv,_ZTv0_n16_N5EE3123barEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE312[0]),
  (VTBL_ENTRY)&_ZN3BB13fooEv,
};
extern VTBL_ENTRY _ZTV5EE312[];
static  VTT_ENTRY vtt_EE312[] = {
  {&(_ZTV5EE312[4]),  4,15},
  {&(_ZTV5EE312[9]),  9,15},
  {&(_ZTV5EE312[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5EE312[];
extern  VTBL_ENTRY _ZTV5EE312[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE312[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE3123barEv,_ZTv0_n16_N5EE3123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3123barEv,_ZThn8_N5EE3123barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE312 = {  "EE312", // class name
  bases_EE312, 2,
  &(vtc_EE312[0]), // expected_vtbl_contents
  &(vtt_EE312[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE312),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE312),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE312),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF312  : virtual AA3 , virtual BB1 {
  int pf;
  virtual void  bar(); // _ZN5FF3123barEv
  ~FF312(); // tgen
  FF312(); // tgen
};
//SIG(-1 FF312) C1{ VBC2{ v2 v1 Fi} VBC3{ v3 Fi} v1 Fi}


void  FF312 ::bar(){vfunc_called(this, "_ZN5FF3123barEv");}
FF312 ::~FF312(){ note_dtor("FF312", this);} // tgen
FF312 ::FF312(){ note_ctor("FF312", this);} // tgen

static void Test_FF312()
{
  extern Class_Descriptor cd_FF312;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF312, buf);
    FF312 *dp, &lv = *(dp=new (buf) FF312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF312)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF312)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF312");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF312");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF312.pf");
    test_class_info(&lv, &cd_FF312);
    dp->~FF312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF312(Test_FF312, "FF312", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF312C1Ev();
extern void _ZN5FF312D1Ev();
Name_Map name_map_FF312[] = {
  NSPAIR(_ZN5FF312C1Ev),
  NSPAIR(_ZN5FF312D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF312[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF312[];
extern void _ZN5FF3123barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N5FF3123barEv,_ZTv0_n16_N5FF3123barEv)();
extern void ABISELECT(_ZThn16_N5FF3123barEv,_ZThn8_N5FF3123barEv)() __attribute__((weak));
extern void _ZN3BB13fooEv();
static  VTBL_ENTRY vtc_FF312[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF312[0]),
  (VTBL_ENTRY)&_ZN5FF3123barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF312[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3123barEv,_ZTv0_n16_N5FF3123barEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF312[0]),
  (VTBL_ENTRY)&_ZN3BB13fooEv,
};
extern VTBL_ENTRY _ZTV5FF312[];
static  VTT_ENTRY vtt_FF312[] = {
  {&(_ZTV5FF312[4]),  4,15},
  {&(_ZTV5FF312[9]),  9,15},
  {&(_ZTV5FF312[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5FF312[];
extern  VTBL_ENTRY _ZTV5FF312[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF312[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF3123barEv,_ZTv0_n16_N5FF3123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3123barEv,_ZThn8_N5FF3123barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF312 = {  "FF312", // class name
  bases_FF312, 2,
  &(vtc_FF312[0]), // expected_vtbl_contents
  &(vtt_FF312[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF312),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF312),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF312),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE313  : virtual AA3 , virtual BB1 {
  int pe;
  virtual void  foo(); // _ZN5EE3133fooEv
  virtual void  bar(); // _ZN5EE3133barEv
  ~EE313(); // tgen
  EE313(); // tgen
};
//SIG(-1 EE313) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 Fi} v1 v2 Fi}


void  EE313 ::foo(){vfunc_called(this, "_ZN5EE3133fooEv");}
void  EE313 ::bar(){vfunc_called(this, "_ZN5EE3133barEv");}
EE313 ::~EE313(){ note_dtor("EE313", this);} // tgen
EE313 ::EE313(){ note_ctor("EE313", this);} // tgen

static void Test_EE313()
{
  extern Class_Descriptor cd_EE313;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE313, buf);
    EE313 *dp, &lv = *(dp=new (buf) EE313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE313)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE313");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "EE313");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE313.pe");
    test_class_info(&lv, &cd_EE313);
    dp->~EE313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE313(Test_EE313, "EE313", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE313C1Ev();
extern void _ZN5EE313D1Ev();
Name_Map name_map_EE313[] = {
  NSPAIR(_ZN5EE313C1Ev),
  NSPAIR(_ZN5EE313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_EE313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE313[];
extern void _ZN5EE3133fooEv();
extern void _ZN5EE3133barEv();
extern void ABISELECT(_ZTv0_n24_N5EE3133fooEv,_ZTv0_n12_N5EE3133fooEv)();
extern void ABISELECT(_ZThn16_N5EE3133fooEv,_ZThn8_N5EE3133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5EE3133barEv,_ZTv0_n16_N5EE3133barEv)();
extern void ABISELECT(_ZThn16_N5EE3133barEv,_ZThn8_N5EE3133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE3133fooEv,_ZTv0_n12_N5EE3133fooEv)();
extern void ABISELECT(_ZThn32_N5EE3133fooEv,_ZThn16_N5EE3133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE313[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE313[0]),
  (VTBL_ENTRY)&_ZN5EE3133fooEv,
  (VTBL_ENTRY)&_ZN5EE3133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3133fooEv,_ZTv0_n12_N5EE3133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3133barEv,_ZTv0_n16_N5EE3133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3133fooEv,_ZTv0_n12_N5EE3133fooEv),
};
extern VTBL_ENTRY _ZTV5EE313[];
static  VTT_ENTRY vtt_EE313[] = {
  {&(_ZTV5EE313[4]),  4,16},
  {&(_ZTV5EE313[10]),  10,16},
  {&(_ZTV5EE313[15]),  15,16},
};
extern VTBL_ENTRY _ZTI5EE313[];
extern  VTBL_ENTRY _ZTV5EE313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE313[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE3133barEv,_ZTv0_n16_N5EE3133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3133barEv,_ZThn8_N5EE3133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3133fooEv,_ZTv0_n12_N5EE3133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3133fooEv,_ZThn16_N5EE3133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3133fooEv,_ZThn8_N5EE3133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE313 = {  "EE313", // class name
  bases_EE313, 2,
  &(vtc_EE313[0]), // expected_vtbl_contents
  &(vtt_EE313[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE313),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE313),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF313  : virtual AA3 , virtual BB1 {
  int pf;
  virtual void  foo(); // _ZN5FF3133fooEv
  virtual void  bar(); // _ZN5FF3133barEv
  ~FF313(); // tgen
  FF313(); // tgen
};
//SIG(-1 FF313) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 Fi} v1 v2 Fi}


void  FF313 ::foo(){vfunc_called(this, "_ZN5FF3133fooEv");}
void  FF313 ::bar(){vfunc_called(this, "_ZN5FF3133barEv");}
FF313 ::~FF313(){ note_dtor("FF313", this);} // tgen
FF313 ::FF313(){ note_ctor("FF313", this);} // tgen

static void Test_FF313()
{
  extern Class_Descriptor cd_FF313;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF313, buf);
    FF313 *dp, &lv = *(dp=new (buf) FF313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF313)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF313");
    check_base_class_offset(lv, (BB1*), ABISELECT(32,16), "FF313");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF313.pf");
    test_class_info(&lv, &cd_FF313);
    dp->~FF313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF313(Test_FF313, "FF313", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF313C1Ev();
extern void _ZN5FF313D1Ev();
Name_Map name_map_FF313[] = {
  NSPAIR(_ZN5FF313C1Ev),
  NSPAIR(_ZN5FF313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB1;
extern VTBL_ENTRY _ZTI3BB1[];
extern  VTBL_ENTRY _ZTV3BB1[];
static Base_Class bases_FF313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF313[];
extern void _ZN5FF3133fooEv();
extern void _ZN5FF3133barEv();
extern void ABISELECT(_ZTv0_n24_N5FF3133fooEv,_ZTv0_n12_N5FF3133fooEv)();
extern void ABISELECT(_ZThn16_N5FF3133fooEv,_ZThn8_N5FF3133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5FF3133barEv,_ZTv0_n16_N5FF3133barEv)();
extern void ABISELECT(_ZThn16_N5FF3133barEv,_ZThn8_N5FF3133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF3133fooEv,_ZTv0_n12_N5FF3133fooEv)();
extern void ABISELECT(_ZThn32_N5FF3133fooEv,_ZThn16_N5FF3133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF313[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF313[0]),
  (VTBL_ENTRY)&_ZN5FF3133fooEv,
  (VTBL_ENTRY)&_ZN5FF3133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3133fooEv,_ZTv0_n12_N5FF3133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3133barEv,_ZTv0_n16_N5FF3133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3133fooEv,_ZTv0_n12_N5FF3133fooEv),
};
extern VTBL_ENTRY _ZTV5FF313[];
static  VTT_ENTRY vtt_FF313[] = {
  {&(_ZTV5FF313[4]),  4,16},
  {&(_ZTV5FF313[10]),  10,16},
  {&(_ZTV5FF313[15]),  15,16},
};
extern VTBL_ENTRY _ZTI5FF313[];
extern  VTBL_ENTRY _ZTV5FF313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF313[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF3133barEv,_ZTv0_n16_N5FF3133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3133barEv,_ZThn8_N5FF3133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3133fooEv,_ZTv0_n12_N5FF3133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3133fooEv,_ZThn16_N5FF3133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3133fooEv,_ZThn8_N5FF3133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF313 = {  "FF313", // class name
  bases_FF313, 2,
  &(vtc_FF313[0]), // expected_vtbl_contents
  &(vtt_FF313[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF313),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF313),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE321  : virtual AA3 , virtual BB2 {
  int pe;
  virtual void  foo(); // _ZN5EE3213fooEv
  ~EE321(); // tgen
  EE321(); // tgen
};
//SIG(-1 EE321) C1{ VBC2{ v1 v2 Fi} VBC3{ v3 Fi} v1 Fi}


void  EE321 ::foo(){vfunc_called(this, "_ZN5EE3213fooEv");}
EE321 ::~EE321(){ note_dtor("EE321", this);} // tgen
EE321 ::EE321(){ note_ctor("EE321", this);} // tgen

static void Test_EE321()
{
  extern Class_Descriptor cd_EE321;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE321, buf);
    EE321 *dp, &lv = *(dp=new (buf) EE321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE321)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE321)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE321");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE321");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE321.pe");
    test_class_info(&lv, &cd_EE321);
    dp->~EE321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE321(Test_EE321, "EE321", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE321C1Ev();
extern void _ZN5EE321D1Ev();
Name_Map name_map_EE321[] = {
  NSPAIR(_ZN5EE321C1Ev),
  NSPAIR(_ZN5EE321D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE321[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE321[];
extern void _ZN5EE3213fooEv();
extern void ABISELECT(_ZTv0_n24_N5EE3213fooEv,_ZTv0_n12_N5EE3213fooEv)();
extern void ABISELECT(_ZThn16_N5EE3213fooEv,_ZThn8_N5EE3213fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
extern void _ZN3BB23barEv();
static  VTBL_ENTRY vtc_EE321[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE321[0]),
  (VTBL_ENTRY)&_ZN5EE3213fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE321[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3213fooEv,_ZTv0_n12_N5EE3213fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE321[0]),
  (VTBL_ENTRY)&_ZN3BB23barEv,
};
extern VTBL_ENTRY _ZTV5EE321[];
static  VTT_ENTRY vtt_EE321[] = {
  {&(_ZTV5EE321[4]),  4,15},
  {&(_ZTV5EE321[9]),  9,15},
  {&(_ZTV5EE321[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5EE321[];
extern  VTBL_ENTRY _ZTV5EE321[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE321[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3213fooEv,_ZTv0_n12_N5EE3213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3213fooEv,_ZThn8_N5EE3213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE321 = {  "EE321", // class name
  bases_EE321, 2,
  &(vtc_EE321[0]), // expected_vtbl_contents
  &(vtt_EE321[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE321),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE321),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE321),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF321  : virtual AA3 , virtual BB2 {
  int pf;
  virtual void  foo(); // _ZN5FF3213fooEv
  ~FF321(); // tgen
  FF321(); // tgen
};
//SIG(-1 FF321) C1{ VBC2{ v1 v2 Fi} VBC3{ v3 Fi} v1 Fi}


void  FF321 ::foo(){vfunc_called(this, "_ZN5FF3213fooEv");}
FF321 ::~FF321(){ note_dtor("FF321", this);} // tgen
FF321 ::FF321(){ note_ctor("FF321", this);} // tgen

static void Test_FF321()
{
  extern Class_Descriptor cd_FF321;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF321, buf);
    FF321 *dp, &lv = *(dp=new (buf) FF321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF321)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF321)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF321");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF321");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF321.pf");
    test_class_info(&lv, &cd_FF321);
    dp->~FF321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF321(Test_FF321, "FF321", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF321C1Ev();
extern void _ZN5FF321D1Ev();
Name_Map name_map_FF321[] = {
  NSPAIR(_ZN5FF321C1Ev),
  NSPAIR(_ZN5FF321D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF321[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF321[];
extern void _ZN5FF3213fooEv();
extern void ABISELECT(_ZTv0_n24_N5FF3213fooEv,_ZTv0_n12_N5FF3213fooEv)();
extern void ABISELECT(_ZThn16_N5FF3213fooEv,_ZThn8_N5FF3213fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
extern void _ZN3BB23barEv();
static  VTBL_ENTRY vtc_FF321[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF321[0]),
  (VTBL_ENTRY)&_ZN5FF3213fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF321[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3213fooEv,_ZTv0_n12_N5FF3213fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF321[0]),
  (VTBL_ENTRY)&_ZN3BB23barEv,
};
extern VTBL_ENTRY _ZTV5FF321[];
static  VTT_ENTRY vtt_FF321[] = {
  {&(_ZTV5FF321[4]),  4,15},
  {&(_ZTV5FF321[9]),  9,15},
  {&(_ZTV5FF321[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5FF321[];
extern  VTBL_ENTRY _ZTV5FF321[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF321[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3213fooEv,_ZTv0_n12_N5FF3213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3213fooEv,_ZThn8_N5FF3213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF321 = {  "FF321", // class name
  bases_FF321, 2,
  &(vtc_FF321[0]), // expected_vtbl_contents
  &(vtt_FF321[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF321),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF321),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF321),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE322  : virtual AA3 , virtual BB2 {
  int pe;
  virtual void  bar(); // _ZN5EE3223barEv
  ~EE322(); // tgen
  EE322(); // tgen
};
//SIG(-1 EE322) C1{ VBC2{ v2 v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  EE322 ::bar(){vfunc_called(this, "_ZN5EE3223barEv");}
EE322 ::~EE322(){ note_dtor("EE322", this);} // tgen
EE322 ::EE322(){ note_ctor("EE322", this);} // tgen

static void Test_EE322()
{
  extern Class_Descriptor cd_EE322;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE322, buf);
    EE322 *dp, &lv = *(dp=new (buf) EE322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE322)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE322)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE322");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE322");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE322.pe");
    test_class_info(&lv, &cd_EE322);
    dp->~EE322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE322(Test_EE322, "EE322", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE322C1Ev();
extern void _ZN5EE322D1Ev();
Name_Map name_map_EE322[] = {
  NSPAIR(_ZN5EE322C1Ev),
  NSPAIR(_ZN5EE322D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE322[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE322[];
extern void _ZN5EE3223barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N5EE3223barEv,_ZTv0_n16_N5EE3223barEv)();
extern void ABISELECT(_ZThn16_N5EE3223barEv,_ZThn8_N5EE3223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE3223barEv,_ZTv0_n12_N5EE3223barEv)();
extern void ABISELECT(_ZThn32_N5EE3223barEv,_ZThn16_N5EE3223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE322[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE322[0]),
  (VTBL_ENTRY)&_ZN5EE3223barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE322[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3223barEv,_ZTv0_n16_N5EE3223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE322[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3223barEv,_ZTv0_n12_N5EE3223barEv),
};
extern VTBL_ENTRY _ZTV5EE322[];
static  VTT_ENTRY vtt_EE322[] = {
  {&(_ZTV5EE322[4]),  4,15},
  {&(_ZTV5EE322[9]),  9,15},
  {&(_ZTV5EE322[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5EE322[];
extern  VTBL_ENTRY _ZTV5EE322[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE322[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3223barEv,_ZTv0_n12_N5EE3223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3223barEv,_ZThn16_N5EE3223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE3223barEv,_ZTv0_n16_N5EE3223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3223barEv,_ZThn8_N5EE3223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE322 = {  "EE322", // class name
  bases_EE322, 2,
  &(vtc_EE322[0]), // expected_vtbl_contents
  &(vtt_EE322[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE322),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE322),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE322),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF322  : virtual AA3 , virtual BB2 {
  int pf;
  virtual void  bar(); // _ZN5FF3223barEv
  ~FF322(); // tgen
  FF322(); // tgen
};
//SIG(-1 FF322) C1{ VBC2{ v2 v1 Fi} VBC3{ v1 Fi} v1 Fi}


void  FF322 ::bar(){vfunc_called(this, "_ZN5FF3223barEv");}
FF322 ::~FF322(){ note_dtor("FF322", this);} // tgen
FF322 ::FF322(){ note_ctor("FF322", this);} // tgen

static void Test_FF322()
{
  extern Class_Descriptor cd_FF322;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF322, buf);
    FF322 *dp, &lv = *(dp=new (buf) FF322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF322)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF322)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF322");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF322");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF322.pf");
    test_class_info(&lv, &cd_FF322);
    dp->~FF322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF322(Test_FF322, "FF322", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF322C1Ev();
extern void _ZN5FF322D1Ev();
Name_Map name_map_FF322[] = {
  NSPAIR(_ZN5FF322C1Ev),
  NSPAIR(_ZN5FF322D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF322[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF322[];
extern void _ZN5FF3223barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N5FF3223barEv,_ZTv0_n16_N5FF3223barEv)();
extern void ABISELECT(_ZThn16_N5FF3223barEv,_ZThn8_N5FF3223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF3223barEv,_ZTv0_n12_N5FF3223barEv)();
extern void ABISELECT(_ZThn32_N5FF3223barEv,_ZThn16_N5FF3223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF322[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF322[0]),
  (VTBL_ENTRY)&_ZN5FF3223barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF322[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3223barEv,_ZTv0_n16_N5FF3223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF322[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3223barEv,_ZTv0_n12_N5FF3223barEv),
};
extern VTBL_ENTRY _ZTV5FF322[];
static  VTT_ENTRY vtt_FF322[] = {
  {&(_ZTV5FF322[4]),  4,15},
  {&(_ZTV5FF322[9]),  9,15},
  {&(_ZTV5FF322[14]),  14,15},
};
extern VTBL_ENTRY _ZTI5FF322[];
extern  VTBL_ENTRY _ZTV5FF322[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF322[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3223barEv,_ZTv0_n12_N5FF3223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3223barEv,_ZThn16_N5FF3223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF3223barEv,_ZTv0_n16_N5FF3223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3223barEv,_ZThn8_N5FF3223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF322 = {  "FF322", // class name
  bases_FF322, 2,
  &(vtc_FF322[0]), // expected_vtbl_contents
  &(vtt_FF322[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF322),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF322),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF322),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE323  : virtual AA3 , virtual BB2 {
  int pe;
  virtual void  foo(); // _ZN5EE3233fooEv
  virtual void  bar(); // _ZN5EE3233barEv
  ~EE323(); // tgen
  EE323(); // tgen
};
//SIG(-1 EE323) C1{ VBC2{ v1 v2 Fi} VBC3{ v2 Fi} v1 v2 Fi}


void  EE323 ::foo(){vfunc_called(this, "_ZN5EE3233fooEv");}
void  EE323 ::bar(){vfunc_called(this, "_ZN5EE3233barEv");}
EE323 ::~EE323(){ note_dtor("EE323", this);} // tgen
EE323 ::EE323(){ note_ctor("EE323", this);} // tgen

static void Test_EE323()
{
  extern Class_Descriptor cd_EE323;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE323, buf);
    EE323 *dp, &lv = *(dp=new (buf) EE323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE323)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE323");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "EE323");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE323.pe");
    test_class_info(&lv, &cd_EE323);
    dp->~EE323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE323(Test_EE323, "EE323", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE323C1Ev();
extern void _ZN5EE323D1Ev();
Name_Map name_map_EE323[] = {
  NSPAIR(_ZN5EE323C1Ev),
  NSPAIR(_ZN5EE323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_EE323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE323[];
extern void _ZN5EE3233fooEv();
extern void _ZN5EE3233barEv();
extern void ABISELECT(_ZTv0_n24_N5EE3233fooEv,_ZTv0_n12_N5EE3233fooEv)();
extern void ABISELECT(_ZThn16_N5EE3233fooEv,_ZThn8_N5EE3233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5EE3233barEv,_ZTv0_n16_N5EE3233barEv)();
extern void ABISELECT(_ZThn16_N5EE3233barEv,_ZThn8_N5EE3233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE3233barEv,_ZTv0_n12_N5EE3233barEv)();
extern void ABISELECT(_ZThn32_N5EE3233barEv,_ZThn16_N5EE3233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE323[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE323[0]),
  (VTBL_ENTRY)&_ZN5EE3233fooEv,
  (VTBL_ENTRY)&_ZN5EE3233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3233fooEv,_ZTv0_n12_N5EE3233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3233barEv,_ZTv0_n16_N5EE3233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3233barEv,_ZTv0_n12_N5EE3233barEv),
};
extern VTBL_ENTRY _ZTV5EE323[];
static  VTT_ENTRY vtt_EE323[] = {
  {&(_ZTV5EE323[4]),  4,16},
  {&(_ZTV5EE323[10]),  10,16},
  {&(_ZTV5EE323[15]),  15,16},
};
extern VTBL_ENTRY _ZTI5EE323[];
extern  VTBL_ENTRY _ZTV5EE323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE323[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3233barEv,_ZTv0_n12_N5EE3233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3233barEv,_ZThn16_N5EE3233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE3233barEv,_ZTv0_n16_N5EE3233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3233barEv,_ZThn8_N5EE3233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3233fooEv,_ZTv0_n12_N5EE3233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3233fooEv,_ZThn8_N5EE3233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE323 = {  "EE323", // class name
  bases_EE323, 2,
  &(vtc_EE323[0]), // expected_vtbl_contents
  &(vtt_EE323[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE323),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE323),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF323  : virtual AA3 , virtual BB2 {
  int pf;
  virtual void  foo(); // _ZN5FF3233fooEv
  virtual void  bar(); // _ZN5FF3233barEv
  ~FF323(); // tgen
  FF323(); // tgen
};
//SIG(-1 FF323) C1{ VBC2{ v1 v2 Fi} VBC3{ v2 Fi} v1 v2 Fi}


void  FF323 ::foo(){vfunc_called(this, "_ZN5FF3233fooEv");}
void  FF323 ::bar(){vfunc_called(this, "_ZN5FF3233barEv");}
FF323 ::~FF323(){ note_dtor("FF323", this);} // tgen
FF323 ::FF323(){ note_ctor("FF323", this);} // tgen

static void Test_FF323()
{
  extern Class_Descriptor cd_FF323;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF323, buf);
    FF323 *dp, &lv = *(dp=new (buf) FF323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF323)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF323");
    check_base_class_offset(lv, (BB2*), ABISELECT(32,16), "FF323");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF323.pf");
    test_class_info(&lv, &cd_FF323);
    dp->~FF323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF323(Test_FF323, "FF323", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF323C1Ev();
extern void _ZN5FF323D1Ev();
Name_Map name_map_FF323[] = {
  NSPAIR(_ZN5FF323C1Ev),
  NSPAIR(_ZN5FF323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB2;
extern VTBL_ENTRY _ZTI3BB2[];
extern  VTBL_ENTRY _ZTV3BB2[];
static Base_Class bases_FF323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF323[];
extern void _ZN5FF3233fooEv();
extern void _ZN5FF3233barEv();
extern void ABISELECT(_ZTv0_n24_N5FF3233fooEv,_ZTv0_n12_N5FF3233fooEv)();
extern void ABISELECT(_ZThn16_N5FF3233fooEv,_ZThn8_N5FF3233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5FF3233barEv,_ZTv0_n16_N5FF3233barEv)();
extern void ABISELECT(_ZThn16_N5FF3233barEv,_ZThn8_N5FF3233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF3233barEv,_ZTv0_n12_N5FF3233barEv)();
extern void ABISELECT(_ZThn32_N5FF3233barEv,_ZThn16_N5FF3233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF323[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF323[0]),
  (VTBL_ENTRY)&_ZN5FF3233fooEv,
  (VTBL_ENTRY)&_ZN5FF3233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3233fooEv,_ZTv0_n12_N5FF3233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3233barEv,_ZTv0_n16_N5FF3233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3233barEv,_ZTv0_n12_N5FF3233barEv),
};
extern VTBL_ENTRY _ZTV5FF323[];
static  VTT_ENTRY vtt_FF323[] = {
  {&(_ZTV5FF323[4]),  4,16},
  {&(_ZTV5FF323[10]),  10,16},
  {&(_ZTV5FF323[15]),  15,16},
};
extern VTBL_ENTRY _ZTI5FF323[];
extern  VTBL_ENTRY _ZTV5FF323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF323[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3233barEv,_ZTv0_n12_N5FF3233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3233barEv,_ZThn16_N5FF3233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF3233barEv,_ZTv0_n16_N5FF3233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3233barEv,_ZThn8_N5FF3233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3233fooEv,_ZTv0_n12_N5FF3233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3233fooEv,_ZThn8_N5FF3233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF323 = {  "FF323", // class name
  bases_FF323, 2,
  &(vtc_FF323[0]), // expected_vtbl_contents
  &(vtt_FF323[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF323),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF323),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE331  : virtual AA3 , virtual BB3 {
  int pe;
  virtual void  foo(); // _ZN5EE3313fooEv
  ~EE331(); // tgen
  EE331(); // tgen
};
//SIG(-1 EE331) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 v3 Fi} v1 Fi}


void  EE331 ::foo(){vfunc_called(this, "_ZN5EE3313fooEv");}
EE331 ::~EE331(){ note_dtor("EE331", this);} // tgen
EE331 ::EE331(){ note_ctor("EE331", this);} // tgen

static void Test_EE331()
{
  extern Class_Descriptor cd_EE331;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE331, buf);
    EE331 *dp, &lv = *(dp=new (buf) EE331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE331)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE331)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE331");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE331");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE331.pe");
    test_class_info(&lv, &cd_EE331);
    dp->~EE331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE331(Test_EE331, "EE331", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE331C1Ev();
extern void _ZN5EE331D1Ev();
Name_Map name_map_EE331[] = {
  NSPAIR(_ZN5EE331C1Ev),
  NSPAIR(_ZN5EE331D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE331[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE331[];
extern void _ZN5EE3313fooEv();
extern void ABISELECT(_ZTv0_n24_N5EE3313fooEv,_ZTv0_n12_N5EE3313fooEv)();
extern void ABISELECT(_ZThn16_N5EE3313fooEv,_ZThn8_N5EE3313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
extern void ABISELECT(_ZTv0_n24_N5EE3313fooEv,_ZTv0_n12_N5EE3313fooEv)();
extern void ABISELECT(_ZThn32_N5EE3313fooEv,_ZThn16_N5EE3313fooEv)() __attribute__((weak));
extern void _ZN3BB33barEv();
static  VTBL_ENTRY vtc_EE331[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE331[0]),
  (VTBL_ENTRY)&_ZN5EE3313fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3313fooEv,_ZTv0_n12_N5EE3313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3313fooEv,_ZTv0_n12_N5EE3313fooEv),
  (VTBL_ENTRY)&_ZN3BB33barEv,
};
extern VTBL_ENTRY _ZTV5EE331[];
static  VTT_ENTRY vtt_EE331[] = {
  {&(_ZTV5EE331[4]),  4,17},
  {&(_ZTV5EE331[9]),  9,17},
  {&(_ZTV5EE331[15]),  15,17},
};
extern VTBL_ENTRY _ZTI5EE331[];
extern  VTBL_ENTRY _ZTV5EE331[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE331[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3313fooEv,_ZTv0_n12_N5EE3313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3313fooEv,_ZThn16_N5EE3313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3313fooEv,_ZThn8_N5EE3313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE331 = {  "EE331", // class name
  bases_EE331, 2,
  &(vtc_EE331[0]), // expected_vtbl_contents
  &(vtt_EE331[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE331),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE331),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE331),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF331  : virtual AA3 , virtual BB3 {
  int pf;
  virtual void  foo(); // _ZN5FF3313fooEv
  ~FF331(); // tgen
  FF331(); // tgen
};
//SIG(-1 FF331) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 v3 Fi} v1 Fi}


void  FF331 ::foo(){vfunc_called(this, "_ZN5FF3313fooEv");}
FF331 ::~FF331(){ note_dtor("FF331", this);} // tgen
FF331 ::FF331(){ note_ctor("FF331", this);} // tgen

static void Test_FF331()
{
  extern Class_Descriptor cd_FF331;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF331, buf);
    FF331 *dp, &lv = *(dp=new (buf) FF331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF331)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF331)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF331");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF331");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF331.pf");
    test_class_info(&lv, &cd_FF331);
    dp->~FF331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF331(Test_FF331, "FF331", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF331C1Ev();
extern void _ZN5FF331D1Ev();
Name_Map name_map_FF331[] = {
  NSPAIR(_ZN5FF331C1Ev),
  NSPAIR(_ZN5FF331D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF331[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF331[];
extern void _ZN5FF3313fooEv();
extern void ABISELECT(_ZTv0_n24_N5FF3313fooEv,_ZTv0_n12_N5FF3313fooEv)();
extern void ABISELECT(_ZThn16_N5FF3313fooEv,_ZThn8_N5FF3313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
extern void ABISELECT(_ZTv0_n24_N5FF3313fooEv,_ZTv0_n12_N5FF3313fooEv)();
extern void ABISELECT(_ZThn32_N5FF3313fooEv,_ZThn16_N5FF3313fooEv)() __attribute__((weak));
extern void _ZN3BB33barEv();
static  VTBL_ENTRY vtc_FF331[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF331[0]),
  (VTBL_ENTRY)&_ZN5FF3313fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3313fooEv,_ZTv0_n12_N5FF3313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3313fooEv,_ZTv0_n12_N5FF3313fooEv),
  (VTBL_ENTRY)&_ZN3BB33barEv,
};
extern VTBL_ENTRY _ZTV5FF331[];
static  VTT_ENTRY vtt_FF331[] = {
  {&(_ZTV5FF331[4]),  4,17},
  {&(_ZTV5FF331[9]),  9,17},
  {&(_ZTV5FF331[15]),  15,17},
};
extern VTBL_ENTRY _ZTI5FF331[];
extern  VTBL_ENTRY _ZTV5FF331[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF331[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3313fooEv,_ZTv0_n12_N5FF3313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3313fooEv,_ZThn16_N5FF3313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3313fooEv,_ZThn8_N5FF3313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF331 = {  "FF331", // class name
  bases_FF331, 2,
  &(vtc_FF331[0]), // expected_vtbl_contents
  &(vtt_FF331[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF331),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF331),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF331),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE332  : virtual AA3 , virtual BB3 {
  int pe;
  virtual void  bar(); // _ZN5EE3323barEv
  ~EE332(); // tgen
  EE332(); // tgen
};
//SIG(-1 EE332) C1{ VBC2{ v2 v1 Fi} VBC3{ v3 v1 Fi} v1 Fi}


void  EE332 ::bar(){vfunc_called(this, "_ZN5EE3323barEv");}
EE332 ::~EE332(){ note_dtor("EE332", this);} // tgen
EE332 ::EE332(){ note_ctor("EE332", this);} // tgen

static void Test_EE332()
{
  extern Class_Descriptor cd_EE332;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE332, buf);
    EE332 *dp, &lv = *(dp=new (buf) EE332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE332)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE332)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE332");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE332");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE332.pe");
    test_class_info(&lv, &cd_EE332);
    dp->~EE332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE332(Test_EE332, "EE332", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE332C1Ev();
extern void _ZN5EE332D1Ev();
Name_Map name_map_EE332[] = {
  NSPAIR(_ZN5EE332C1Ev),
  NSPAIR(_ZN5EE332D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE332[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE332[];
extern void _ZN5EE3323barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N5EE3323barEv,_ZTv0_n16_N5EE3323barEv)();
extern void ABISELECT(_ZThn16_N5EE3323barEv,_ZThn8_N5EE3323barEv)() __attribute__((weak));
extern void _ZN3BB33fooEv();
extern void ABISELECT(_ZTv0_n32_N5EE3323barEv,_ZTv0_n16_N5EE3323barEv)();
extern void ABISELECT(_ZThn32_N5EE3323barEv,_ZThn16_N5EE3323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE332[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE332[0]),
  (VTBL_ENTRY)&_ZN5EE3323barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE332[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3323barEv,_ZTv0_n16_N5EE3323barEv),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE332[0]),
  (VTBL_ENTRY)&_ZN3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3323barEv,_ZTv0_n16_N5EE3323barEv),
};
extern VTBL_ENTRY _ZTV5EE332[];
static  VTT_ENTRY vtt_EE332[] = {
  {&(_ZTV5EE332[4]),  4,17},
  {&(_ZTV5EE332[9]),  9,17},
  {&(_ZTV5EE332[15]),  15,17},
};
extern VTBL_ENTRY _ZTI5EE332[];
extern  VTBL_ENTRY _ZTV5EE332[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE332[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE3323barEv,_ZTv0_n16_N5EE3323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3323barEv,_ZThn16_N5EE3323barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3323barEv,_ZThn8_N5EE3323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE332 = {  "EE332", // class name
  bases_EE332, 2,
  &(vtc_EE332[0]), // expected_vtbl_contents
  &(vtt_EE332[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE332),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE332),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE332),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF332  : virtual AA3 , virtual BB3 {
  int pf;
  virtual void  bar(); // _ZN5FF3323barEv
  ~FF332(); // tgen
  FF332(); // tgen
};
//SIG(-1 FF332) C1{ VBC2{ v2 v1 Fi} VBC3{ v3 v1 Fi} v1 Fi}


void  FF332 ::bar(){vfunc_called(this, "_ZN5FF3323barEv");}
FF332 ::~FF332(){ note_dtor("FF332", this);} // tgen
FF332 ::FF332(){ note_ctor("FF332", this);} // tgen

static void Test_FF332()
{
  extern Class_Descriptor cd_FF332;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF332, buf);
    FF332 *dp, &lv = *(dp=new (buf) FF332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF332)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF332)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF332");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF332");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF332.pf");
    test_class_info(&lv, &cd_FF332);
    dp->~FF332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF332(Test_FF332, "FF332", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF332C1Ev();
extern void _ZN5FF332D1Ev();
Name_Map name_map_FF332[] = {
  NSPAIR(_ZN5FF332C1Ev),
  NSPAIR(_ZN5FF332D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF332[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF332[];
extern void _ZN5FF3323barEv();
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N5FF3323barEv,_ZTv0_n16_N5FF3323barEv)();
extern void ABISELECT(_ZThn16_N5FF3323barEv,_ZThn8_N5FF3323barEv)() __attribute__((weak));
extern void _ZN3BB33fooEv();
extern void ABISELECT(_ZTv0_n32_N5FF3323barEv,_ZTv0_n16_N5FF3323barEv)();
extern void ABISELECT(_ZThn32_N5FF3323barEv,_ZThn16_N5FF3323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF332[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF332[0]),
  (VTBL_ENTRY)&_ZN5FF3323barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF332[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3323barEv,_ZTv0_n16_N5FF3323barEv),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF332[0]),
  (VTBL_ENTRY)&_ZN3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3323barEv,_ZTv0_n16_N5FF3323barEv),
};
extern VTBL_ENTRY _ZTV5FF332[];
static  VTT_ENTRY vtt_FF332[] = {
  {&(_ZTV5FF332[4]),  4,17},
  {&(_ZTV5FF332[9]),  9,17},
  {&(_ZTV5FF332[15]),  15,17},
};
extern VTBL_ENTRY _ZTI5FF332[];
extern  VTBL_ENTRY _ZTV5FF332[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF332[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF3323barEv,_ZTv0_n16_N5FF3323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3323barEv,_ZThn16_N5FF3323barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3323barEv,_ZThn8_N5FF3323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF332 = {  "FF332", // class name
  bases_FF332, 2,
  &(vtc_FF332[0]), // expected_vtbl_contents
  &(vtt_FF332[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF332),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF332),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF332),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  EE333  : virtual AA3 , virtual BB3 {
  int pe;
  virtual void  foo(); // _ZN5EE3333fooEv
  virtual void  bar(); // _ZN5EE3333barEv
  ~EE333(); // tgen
  EE333(); // tgen
};
//SIG(-1 EE333) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 v2 Fi} v1 v2 Fi}


void  EE333 ::foo(){vfunc_called(this, "_ZN5EE3333fooEv");}
void  EE333 ::bar(){vfunc_called(this, "_ZN5EE3333barEv");}
EE333 ::~EE333(){ note_dtor("EE333", this);} // tgen
EE333 ::EE333(){ note_ctor("EE333", this);} // tgen

static void Test_EE333()
{
  extern Class_Descriptor cd_EE333;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_EE333, buf);
    EE333 *dp, &lv = *(dp=new (buf) EE333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(EE333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(EE333)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "EE333");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "EE333");
    check_field_offset(lv, pe, ABISELECT(8,4), "EE333.pe");
    test_class_info(&lv, &cd_EE333);
    dp->~EE333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vEE333(Test_EE333, "EE333", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5EE333C1Ev();
extern void _ZN5EE333D1Ev();
Name_Map name_map_EE333[] = {
  NSPAIR(_ZN5EE333C1Ev),
  NSPAIR(_ZN5EE333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_EE333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5EE333[];
extern void _ZN5EE3333fooEv();
extern void _ZN5EE3333barEv();
extern void ABISELECT(_ZTv0_n24_N5EE3333fooEv,_ZTv0_n12_N5EE3333fooEv)();
extern void ABISELECT(_ZThn16_N5EE3333fooEv,_ZThn8_N5EE3333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5EE3333barEv,_ZTv0_n16_N5EE3333barEv)();
extern void ABISELECT(_ZThn16_N5EE3333barEv,_ZThn8_N5EE3333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5EE3333fooEv,_ZTv0_n12_N5EE3333fooEv)();
extern void ABISELECT(_ZThn32_N5EE3333fooEv,_ZThn16_N5EE3333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5EE3333barEv,_ZTv0_n16_N5EE3333barEv)();
extern void ABISELECT(_ZThn32_N5EE3333barEv,_ZThn16_N5EE3333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_EE333[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5EE333[0]),
  (VTBL_ENTRY)&_ZN5EE3333fooEv,
  (VTBL_ENTRY)&_ZN5EE3333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5EE333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3333fooEv,_ZTv0_n12_N5EE3333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3333barEv,_ZTv0_n16_N5EE3333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5EE333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5EE3333fooEv,_ZTv0_n12_N5EE3333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5EE3333barEv,_ZTv0_n16_N5EE3333barEv),
};
extern VTBL_ENTRY _ZTV5EE333[];
static  VTT_ENTRY vtt_EE333[] = {
  {&(_ZTV5EE333[4]),  4,18},
  {&(_ZTV5EE333[10]),  10,18},
  {&(_ZTV5EE333[16]),  16,18},
};
extern VTBL_ENTRY _ZTI5EE333[];
extern  VTBL_ENTRY _ZTV5EE333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5EE333[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5EE3333barEv,_ZTv0_n16_N5EE3333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3333barEv,_ZThn16_N5EE3333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3333barEv,_ZThn8_N5EE3333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5EE3333fooEv,_ZTv0_n12_N5EE3333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5EE3333fooEv,_ZThn16_N5EE3333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5EE3333fooEv,_ZThn8_N5EE3333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_EE333 = {  "EE333", // class name
  bases_EE333, 2,
  &(vtc_EE333[0]), // expected_vtbl_contents
  &(vtt_EE333[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5EE333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5EE333),18, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5EE333),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  FF333  : virtual AA3 , virtual BB3 {
  int pf;
  virtual void  foo(); // _ZN5FF3333fooEv
  virtual void  bar(); // _ZN5FF3333barEv
  ~FF333(); // tgen
  FF333(); // tgen
};
//SIG(-1 FF333) C1{ VBC2{ v1 v2 Fi} VBC3{ v1 v2 Fi} v1 v2 Fi}


void  FF333 ::foo(){vfunc_called(this, "_ZN5FF3333fooEv");}
void  FF333 ::bar(){vfunc_called(this, "_ZN5FF3333barEv");}
FF333 ::~FF333(){ note_dtor("FF333", this);} // tgen
FF333 ::FF333(){ note_ctor("FF333", this);} // tgen

static void Test_FF333()
{
  extern Class_Descriptor cd_FF333;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_FF333, buf);
    FF333 *dp, &lv = *(dp=new (buf) FF333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(FF333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(FF333)");
    check_base_class_offset(lv, (AA3*), ABISELECT(16,8), "FF333");
    check_base_class_offset(lv, (BB3*), ABISELECT(32,16), "FF333");
    check_field_offset(lv, pf, ABISELECT(8,4), "FF333.pf");
    test_class_info(&lv, &cd_FF333);
    dp->~FF333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vFF333(Test_FF333, "FF333", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN5FF333C1Ev();
extern void _ZN5FF333D1Ev();
Name_Map name_map_FF333[] = {
  NSPAIR(_ZN5FF333C1Ev),
  NSPAIR(_ZN5FF333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_BB3;
extern VTBL_ENTRY _ZTI3BB3[];
extern  VTBL_ENTRY _ZTV3BB3[];
static Base_Class bases_FF333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_BB3,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5FF333[];
extern void _ZN5FF3333fooEv();
extern void _ZN5FF3333barEv();
extern void ABISELECT(_ZTv0_n24_N5FF3333fooEv,_ZTv0_n12_N5FF3333fooEv)();
extern void ABISELECT(_ZThn16_N5FF3333fooEv,_ZThn8_N5FF3333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5FF3333barEv,_ZTv0_n16_N5FF3333barEv)();
extern void ABISELECT(_ZThn16_N5FF3333barEv,_ZThn8_N5FF3333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N5FF3333fooEv,_ZTv0_n12_N5FF3333fooEv)();
extern void ABISELECT(_ZThn32_N5FF3333fooEv,_ZThn16_N5FF3333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N5FF3333barEv,_ZTv0_n16_N5FF3333barEv)();
extern void ABISELECT(_ZThn32_N5FF3333barEv,_ZThn16_N5FF3333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_FF333[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5FF333[0]),
  (VTBL_ENTRY)&_ZN5FF3333fooEv,
  (VTBL_ENTRY)&_ZN5FF3333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5FF333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3333fooEv,_ZTv0_n12_N5FF3333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3333barEv,_ZTv0_n16_N5FF3333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI5FF333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N5FF3333fooEv,_ZTv0_n12_N5FF3333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N5FF3333barEv,_ZTv0_n16_N5FF3333barEv),
};
extern VTBL_ENTRY _ZTV5FF333[];
static  VTT_ENTRY vtt_FF333[] = {
  {&(_ZTV5FF333[4]),  4,18},
  {&(_ZTV5FF333[10]),  10,18},
  {&(_ZTV5FF333[16]),  16,18},
};
extern VTBL_ENTRY _ZTI5FF333[];
extern  VTBL_ENTRY _ZTV5FF333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5FF333[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N5FF3333barEv,_ZTv0_n16_N5FF3333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3333barEv,_ZThn16_N5FF3333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3333barEv,_ZThn8_N5FF3333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N5FF3333fooEv,_ZTv0_n12_N5FF3333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N5FF3333fooEv,_ZThn16_N5FF3333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N5FF3333fooEv,_ZThn8_N5FF3333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_FF333 = {  "FF333", // class name
  bases_FF333, 2,
  &(vtc_FF333[0]), // expected_vtbl_contents
  &(vtt_FF333[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI5FF333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5FF333),18, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5FF333),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11111  : virtual E11 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G111113fooEv
  ~G11111(); // tgen
  G11111(); // tgen
};
//SIG(1 G11111) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v1 Fi} v1 Fi}


void  G11111 ::foo(){vfunc_called(this, "_ZN6G111113fooEv");}
G11111 ::~G11111(){ note_dtor("G11111", this);} // tgen
G11111 ::G11111(){ note_ctor("G11111", this);} // tgen

static void Test_G11111()
{
  extern Class_Descriptor cd_G11111;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G11111, buf);
    G11111 *dp, &lv = *(dp=new (buf) G11111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G11111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11111)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11111");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(32,16), "G11111");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11111");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G11111");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11111.pg");
    test_class_info(&lv, &cd_G11111);
    dp->~G11111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11111(Test_G11111, "G11111", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G11111C1Ev();
extern void _ZN6G11111D1Ev();
Name_Map name_map_G11111[] = {
  NSPAIR(_ZN6G11111C1Ev),
  NSPAIR(_ZN6G11111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G11111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11111[];
extern void _ZN6G111113fooEv();
extern void ABISELECT(_ZTv0_n32_N6G111113fooEv,_ZTv0_n16_N6G111113fooEv)();
extern void ABISELECT(_ZThn16_N6G111113fooEv,_ZThn8_N6G111113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G111113fooEv,_ZTv0_n12_N6G111113fooEv)();
extern void ABISELECT(_ZThn32_N6G111113fooEv,_ZThn16_N6G111113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G111113fooEv,_ZTv0_n16_N6G111113fooEv)();
extern void ABISELECT(_ZThn48_N6G111113fooEv,_ZThn24_N6G111113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11111[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11111[0]),
  (VTBL_ENTRY)&_ZN6G111113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111113fooEv,_ZTv0_n16_N6G111113fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G111113fooEv,_ZTv0_n12_N6G111113fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111113fooEv,_ZTv0_n16_N6G111113fooEv),
};
extern VTBL_ENTRY _ZTV6G11111[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G11111[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G11111[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G11111[] = {
  {&(_ZTV6G11111[5]),  5,20},
  {&(_ZTV6G11111[10]),  10,20},
  {&(_ZTV6G11111[14]),  14,20},
  {&(_ZTV6G11111[19]),  19,20},
  {&(_tg__ZTV3E11__6G11111[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11111[3]),  3,4},
  {&(_tg__ZTV3F11__6G11111[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G11111[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11111[];
extern  VTBL_ENTRY _ZTV6G11111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11111[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G111113fooEv,_ZTv0_n12_N6G111113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G111113fooEv,_ZThn16_N6G111113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G111113fooEv,_ZTv0_n16_N6G111113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G111113fooEv,_ZThn24_N6G111113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G111113fooEv,_ZThn8_N6G111113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11111 = {  "G11111", // class name
  bases_G11111, 3,
  &(vtc_G11111[0]), // expected_vtbl_contents
  &(vtt_G11111[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G11111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11111),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11111),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11113  : virtual E11 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G111133fooEv
  virtual void  bar(); // _ZN6G111133barEv
  ~G11113(); // tgen
  G11113(); // tgen
};
//SIG(1 G11113) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v1 Fi} v1 v2 Fi}


void  G11113 ::foo(){vfunc_called(this, "_ZN6G111133fooEv");}
void  G11113 ::bar(){vfunc_called(this, "_ZN6G111133barEv");}
G11113 ::~G11113(){ note_dtor("G11113", this);} // tgen
G11113 ::G11113(){ note_ctor("G11113", this);} // tgen

static void Test_G11113()
{
  extern Class_Descriptor cd_G11113;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G11113, buf);
    G11113 *dp, &lv = *(dp=new (buf) G11113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G11113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11113)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11113");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(32,16), "G11113");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11113");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G11113");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11113.pg");
    test_class_info(&lv, &cd_G11113);
    dp->~G11113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11113(Test_G11113, "G11113", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G11113C1Ev();
extern void _ZN6G11113D1Ev();
Name_Map name_map_G11113[] = {
  NSPAIR(_ZN6G11113C1Ev),
  NSPAIR(_ZN6G11113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G11113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11113[];
extern void _ZN6G111133fooEv();
extern void _ZN6G111133barEv();
extern void ABISELECT(_ZTv0_n32_N6G111133fooEv,_ZTv0_n16_N6G111133fooEv)();
extern void ABISELECT(_ZThn16_N6G111133fooEv,_ZThn8_N6G111133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G111133fooEv,_ZTv0_n12_N6G111133fooEv)();
extern void ABISELECT(_ZThn32_N6G111133fooEv,_ZThn16_N6G111133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G111133fooEv,_ZTv0_n16_N6G111133fooEv)();
extern void ABISELECT(_ZThn48_N6G111133fooEv,_ZThn24_N6G111133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11113[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11113[0]),
  (VTBL_ENTRY)&_ZN6G111133fooEv,
  (VTBL_ENTRY)&_ZN6G111133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111133fooEv,_ZTv0_n16_N6G111133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G111133fooEv,_ZTv0_n12_N6G111133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111133fooEv,_ZTv0_n16_N6G111133fooEv),
};
extern VTBL_ENTRY _ZTV6G11113[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G11113[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G11113[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G11113[] = {
  {&(_ZTV6G11113[5]),  5,21},
  {&(_ZTV6G11113[11]),  11,21},
  {&(_ZTV6G11113[15]),  15,21},
  {&(_ZTV6G11113[20]),  20,21},
  {&(_tg__ZTV3E11__6G11113[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11113[3]),  3,4},
  {&(_tg__ZTV3F11__6G11113[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G11113[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11113[];
extern  VTBL_ENTRY _ZTV6G11113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11113[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G111133fooEv,_ZTv0_n12_N6G111133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G111133fooEv,_ZThn16_N6G111133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G111133fooEv,_ZTv0_n16_N6G111133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G111133fooEv,_ZThn24_N6G111133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G111133fooEv,_ZThn8_N6G111133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11113 = {  "G11113", // class name
  bases_G11113, 3,
  &(vtc_G11113[0]), // expected_vtbl_contents
  &(vtt_G11113[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G11113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11113),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11113),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11121  : virtual E11 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G111213fooEv
  ~G11121(); // tgen
  G11121(); // tgen
};
//SIG(1 G11121) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v2 Fi} v1 Fi}


void  G11121 ::foo(){vfunc_called(this, "_ZN6G111213fooEv");}
G11121 ::~G11121(){ note_dtor("G11121", this);} // tgen
G11121 ::G11121(){ note_ctor("G11121", this);} // tgen

static void Test_G11121()
{
  extern Class_Descriptor cd_G11121;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G11121, buf);
    G11121 *dp, &lv = *(dp=new (buf) G11121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G11121)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11121)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11121");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(32,16), "G11121");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11121");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G11121");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11121.pg");
    test_class_info(&lv, &cd_G11121);
    dp->~G11121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11121(Test_G11121, "G11121", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G11121C1Ev();
extern void _ZN6G11121D1Ev();
Name_Map name_map_G11121[] = {
  NSPAIR(_ZN6G11121C1Ev),
  NSPAIR(_ZN6G11121D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G11121[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11121[];
extern void _ZN6G111213fooEv();
extern void ABISELECT(_ZTv0_n32_N6G111213fooEv,_ZTv0_n16_N6G111213fooEv)();
extern void ABISELECT(_ZThn16_N6G111213fooEv,_ZThn8_N6G111213fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G111213fooEv,_ZTv0_n12_N6G111213fooEv)();
extern void ABISELECT(_ZThn32_N6G111213fooEv,_ZThn16_N6G111213fooEv)() __attribute__((weak));
extern void _ZN3F123barEv();
static  VTBL_ENTRY vtc_G11121[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11121[0]),
  (VTBL_ENTRY)&_ZN6G111213fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11121[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111213fooEv,_ZTv0_n16_N6G111213fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11121[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G111213fooEv,_ZTv0_n12_N6G111213fooEv),
  0,
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11121[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern VTBL_ENTRY _ZTV6G11121[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11121[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11121[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G11121[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G11121[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G11121[] = {
  {&(_ZTV6G11121[5]),  5,20},
  {&(_ZTV6G11121[10]),  10,20},
  {&(_ZTV6G11121[14]),  14,20},
  {&(_ZTV6G11121[19]),  19,20},
  {&(_tg__ZTV3E11__6G11121[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11121[3]),  3,4},
  {&(_tg__ZTV3F12__6G11121[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G11121[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11121[];
extern  VTBL_ENTRY _ZTV6G11121[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11121[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G111213fooEv,_ZTv0_n12_N6G111213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G111213fooEv,_ZThn16_N6G111213fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G111213fooEv,_ZTv0_n16_N6G111213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G111213fooEv,_ZThn8_N6G111213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11121 = {  "G11121", // class name
  bases_G11121, 3,
  &(vtc_G11121[0]), // expected_vtbl_contents
  &(vtt_G11121[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G11121),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11121),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11121),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11123  : virtual E11 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G111233fooEv
  virtual void  bar(); // _ZN6G111233barEv
  ~G11123(); // tgen
  G11123(); // tgen
};
//SIG(1 G11123) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v2 Fi} v1 v2 Fi}


void  G11123 ::foo(){vfunc_called(this, "_ZN6G111233fooEv");}
void  G11123 ::bar(){vfunc_called(this, "_ZN6G111233barEv");}
G11123 ::~G11123(){ note_dtor("G11123", this);} // tgen
G11123 ::G11123(){ note_ctor("G11123", this);} // tgen

static void Test_G11123()
{
  extern Class_Descriptor cd_G11123;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G11123, buf);
    G11123 *dp, &lv = *(dp=new (buf) G11123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G11123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11123)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11123");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(32,16), "G11123");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11123");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G11123");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11123.pg");
    test_class_info(&lv, &cd_G11123);
    dp->~G11123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11123(Test_G11123, "G11123", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G11123C1Ev();
extern void _ZN6G11123D1Ev();
Name_Map name_map_G11123[] = {
  NSPAIR(_ZN6G11123C1Ev),
  NSPAIR(_ZN6G11123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G11123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11123[];
extern void _ZN6G111233fooEv();
extern void _ZN6G111233barEv();
extern void ABISELECT(_ZTv0_n32_N6G111233fooEv,_ZTv0_n16_N6G111233fooEv)();
extern void ABISELECT(_ZThn16_N6G111233fooEv,_ZThn8_N6G111233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G111233fooEv,_ZTv0_n12_N6G111233fooEv)();
extern void ABISELECT(_ZThn32_N6G111233fooEv,_ZThn16_N6G111233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G111233barEv,_ZTv0_n16_N6G111233barEv)();
extern void ABISELECT(_ZThn48_N6G111233barEv,_ZThn24_N6G111233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11123[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11123[0]),
  (VTBL_ENTRY)&_ZN6G111233fooEv,
  (VTBL_ENTRY)&_ZN6G111233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111233fooEv,_ZTv0_n16_N6G111233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G111233fooEv,_ZTv0_n12_N6G111233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111233barEv,_ZTv0_n16_N6G111233barEv),
};
extern VTBL_ENTRY _ZTV6G11123[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11123[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G11123[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G11123[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G11123[] = {
  {&(_ZTV6G11123[5]),  5,21},
  {&(_ZTV6G11123[11]),  11,21},
  {&(_ZTV6G11123[15]),  15,21},
  {&(_ZTV6G11123[20]),  20,21},
  {&(_tg__ZTV3E11__6G11123[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11123[3]),  3,4},
  {&(_tg__ZTV3F12__6G11123[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G11123[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11123[];
extern  VTBL_ENTRY _ZTV6G11123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11123[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G111233barEv,_ZTv0_n16_N6G111233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G111233barEv,_ZThn24_N6G111233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G111233fooEv,_ZTv0_n12_N6G111233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G111233fooEv,_ZThn16_N6G111233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G111233fooEv,_ZTv0_n16_N6G111233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G111233fooEv,_ZThn8_N6G111233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11123 = {  "G11123", // class name
  bases_G11123, 3,
  &(vtc_G11123[0]), // expected_vtbl_contents
  &(vtt_G11123[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G11123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11123),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11123),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11131  : virtual E11 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G111313fooEv
  ~G11131(); // tgen
  G11131(); // tgen
};
//SIG(1 G11131) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v1 v2 Fi} v1 Fi}


void  G11131 ::foo(){vfunc_called(this, "_ZN6G111313fooEv");}
G11131 ::~G11131(){ note_dtor("G11131", this);} // tgen
G11131 ::G11131(){ note_ctor("G11131", this);} // tgen

static void Test_G11131()
{
  extern Class_Descriptor cd_G11131;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G11131, buf);
    G11131 *dp, &lv = *(dp=new (buf) G11131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G11131)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11131)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11131");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(32,16), "G11131");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11131");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G11131");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11131.pg");
    test_class_info(&lv, &cd_G11131);
    dp->~G11131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11131(Test_G11131, "G11131", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G11131C1Ev();
extern void _ZN6G11131D1Ev();
Name_Map name_map_G11131[] = {
  NSPAIR(_ZN6G11131C1Ev),
  NSPAIR(_ZN6G11131D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G11131[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11131[];
extern void _ZN6G111313fooEv();
extern void ABISELECT(_ZTv0_n32_N6G111313fooEv,_ZTv0_n16_N6G111313fooEv)();
extern void ABISELECT(_ZThn16_N6G111313fooEv,_ZThn8_N6G111313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G111313fooEv,_ZTv0_n12_N6G111313fooEv)();
extern void ABISELECT(_ZThn32_N6G111313fooEv,_ZThn16_N6G111313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G111313fooEv,_ZTv0_n16_N6G111313fooEv)();
extern void ABISELECT(_ZThn48_N6G111313fooEv,_ZThn24_N6G111313fooEv)() __attribute__((weak));
extern void _ZN3F133barEv();
static  VTBL_ENTRY vtc_G11131[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11131[0]),
  (VTBL_ENTRY)&_ZN6G111313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11131[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111313fooEv,_ZTv0_n16_N6G111313fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11131[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G111313fooEv,_ZTv0_n12_N6G111313fooEv),
  0,
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11131[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111313fooEv,_ZTv0_n16_N6G111313fooEv),
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern VTBL_ENTRY _ZTV6G11131[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11131[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11131[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G11131[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G11131[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G11131[] = {
  {&(_ZTV6G11131[5]),  5,22},
  {&(_ZTV6G11131[10]),  10,22},
  {&(_ZTV6G11131[14]),  14,22},
  {&(_ZTV6G11131[20]),  20,22},
  {&(_tg__ZTV3E11__6G11131[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11131[3]),  3,4},
  {&(_tg__ZTV3F13__6G11131[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G11131[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11131[];
extern  VTBL_ENTRY _ZTV6G11131[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11131[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G111313fooEv,_ZTv0_n12_N6G111313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G111313fooEv,_ZThn16_N6G111313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G111313fooEv,_ZTv0_n16_N6G111313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G111313fooEv,_ZThn24_N6G111313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G111313fooEv,_ZThn8_N6G111313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11131 = {  "G11131", // class name
  bases_G11131, 3,
  &(vtc_G11131[0]), // expected_vtbl_contents
  &(vtt_G11131[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G11131),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11131),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11131),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11133  : virtual E11 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G111333fooEv
  virtual void  bar(); // _ZN6G111333barEv
  ~G11133(); // tgen
  G11133(); // tgen
};
//SIG(1 G11133) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v1 v2 Fi} v1 v2 Fi}


void  G11133 ::foo(){vfunc_called(this, "_ZN6G111333fooEv");}
void  G11133 ::bar(){vfunc_called(this, "_ZN6G111333barEv");}
G11133 ::~G11133(){ note_dtor("G11133", this);} // tgen
G11133 ::G11133(){ note_ctor("G11133", this);} // tgen

static void Test_G11133()
{
  extern Class_Descriptor cd_G11133;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G11133, buf);
    G11133 *dp, &lv = *(dp=new (buf) G11133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G11133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11133)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11133");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(32,16), "G11133");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11133");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G11133");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11133.pg");
    test_class_info(&lv, &cd_G11133);
    dp->~G11133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11133(Test_G11133, "G11133", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G11133C1Ev();
extern void _ZN6G11133D1Ev();
Name_Map name_map_G11133[] = {
  NSPAIR(_ZN6G11133C1Ev),
  NSPAIR(_ZN6G11133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G11133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11133[];
extern void _ZN6G111333fooEv();
extern void _ZN6G111333barEv();
extern void ABISELECT(_ZTv0_n32_N6G111333fooEv,_ZTv0_n16_N6G111333fooEv)();
extern void ABISELECT(_ZThn16_N6G111333fooEv,_ZThn8_N6G111333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G111333fooEv,_ZTv0_n12_N6G111333fooEv)();
extern void ABISELECT(_ZThn32_N6G111333fooEv,_ZThn16_N6G111333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G111333fooEv,_ZTv0_n16_N6G111333fooEv)();
extern void ABISELECT(_ZThn48_N6G111333fooEv,_ZThn24_N6G111333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G111333barEv,_ZTv0_n20_N6G111333barEv)();
extern void ABISELECT(_ZThn48_N6G111333barEv,_ZThn24_N6G111333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11133[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11133[0]),
  (VTBL_ENTRY)&_ZN6G111333fooEv,
  (VTBL_ENTRY)&_ZN6G111333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111333fooEv,_ZTv0_n16_N6G111333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G111333fooEv,_ZTv0_n12_N6G111333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G111333fooEv,_ZTv0_n16_N6G111333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G111333barEv,_ZTv0_n20_N6G111333barEv),
};
extern VTBL_ENTRY _ZTV6G11133[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G11133[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G11133[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G11133[] = {
  {&(_ZTV6G11133[5]),  5,23},
  {&(_ZTV6G11133[11]),  11,23},
  {&(_ZTV6G11133[15]),  15,23},
  {&(_ZTV6G11133[21]),  21,23},
  {&(_tg__ZTV3E11__6G11133[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11133[3]),  3,4},
  {&(_tg__ZTV3F13__6G11133[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G11133[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11133[];
extern  VTBL_ENTRY _ZTV6G11133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11133[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G111333barEv,_ZTv0_n20_N6G111333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G111333barEv,_ZThn24_N6G111333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G111333fooEv,_ZTv0_n12_N6G111333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G111333fooEv,_ZThn16_N6G111333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G111333fooEv,_ZTv0_n16_N6G111333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G111333fooEv,_ZThn24_N6G111333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G111333fooEv,_ZThn8_N6G111333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11133 = {  "G11133", // class name
  bases_G11133, 3,
  &(vtc_G11133[0]), // expected_vtbl_contents
  &(vtt_G11133[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G11133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11133),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11133),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11211  : virtual E11 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G112113fooEv
  ~G11211(); // tgen
  G11211(); // tgen
};
//SIG(1 G11211) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v1 Fi} v1 Fi}


void  G11211 ::foo(){vfunc_called(this, "_ZN6G112113fooEv");}
G11211 ::~G11211(){ note_dtor("G11211", this);} // tgen
G11211 ::G11211(){ note_ctor("G11211", this);} // tgen

static void Test_G11211()
{
  extern Class_Descriptor cd_G11211;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11211, buf);
    G11211 *dp, &lv = *(dp=new (buf) G11211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11211)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11211)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11211");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11211");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(64,32), "G11211");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G11211");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11211.pg");
    test_class_info(&lv, &cd_G11211);
    dp->~G11211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11211(Test_G11211, "G11211", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11211C1Ev();
extern void _ZN6G11211D1Ev();
Name_Map name_map_G11211[] = {
  NSPAIR(_ZN6G11211C1Ev),
  NSPAIR(_ZN6G11211D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G11211[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11211[];
extern void _ZN6G112113fooEv();
extern void ABISELECT(_ZTv0_n32_N6G112113fooEv,_ZTv0_n16_N6G112113fooEv)();
extern void ABISELECT(_ZThn16_N6G112113fooEv,_ZThn8_N6G112113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112113fooEv,_ZTv0_n12_N6G112113fooEv)();
extern void ABISELECT(_ZThn32_N6G112113fooEv,_ZThn16_N6G112113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G112113fooEv,_ZTv0_n16_N6G112113fooEv)();
extern void ABISELECT(_ZThn48_N6G112113fooEv,_ZThn24_N6G112113fooEv)() __attribute__((weak));
extern void _ZN3AA23barEv();
static  VTBL_ENTRY vtc_G11211[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11211[0]),
  (VTBL_ENTRY)&_ZN6G112113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11211[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112113fooEv,_ZTv0_n16_N6G112113fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11211[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112113fooEv,_ZTv0_n12_N6G112113fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11211[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112113fooEv,_ZTv0_n16_N6G112113fooEv),
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11211[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern VTBL_ENTRY _ZTV6G11211[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11211[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11211[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G11211[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G11211[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G11211[] = {
  {&(_ZTV6G11211[6]),  6,25},
  {&(_ZTV6G11211[11]),  11,25},
  {&(_ZTV6G11211[15]),  15,25},
  {&(_ZTV6G11211[20]),  20,25},
  {&(_ZTV6G11211[24]),  24,25},
  {&(_tg__ZTV3E11__6G11211[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11211[3]),  3,4},
  {&(_tg__ZTV3F21__6G11211[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G11211[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11211[];
extern  VTBL_ENTRY _ZTV6G11211[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11211[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112113fooEv,_ZTv0_n12_N6G112113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G112113fooEv,_ZThn16_N6G112113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112113fooEv,_ZTv0_n16_N6G112113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G112113fooEv,_ZThn24_N6G112113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G112113fooEv,_ZThn8_N6G112113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11211 = {  "G11211", // class name
  bases_G11211, 4,
  &(vtc_G11211[0]), // expected_vtbl_contents
  &(vtt_G11211[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11211),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11211),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11211),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11213  : virtual E11 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G112133fooEv
  virtual void  bar(); // _ZN6G112133barEv
  ~G11213(); // tgen
  G11213(); // tgen
};
//SIG(1 G11213) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v1 Fi} v1 v2 Fi}


void  G11213 ::foo(){vfunc_called(this, "_ZN6G112133fooEv");}
void  G11213 ::bar(){vfunc_called(this, "_ZN6G112133barEv");}
G11213 ::~G11213(){ note_dtor("G11213", this);} // tgen
G11213 ::G11213(){ note_ctor("G11213", this);} // tgen

static void Test_G11213()
{
  extern Class_Descriptor cd_G11213;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11213, buf);
    G11213 *dp, &lv = *(dp=new (buf) G11213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11213)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11213");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11213");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(64,32), "G11213");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G11213");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11213.pg");
    test_class_info(&lv, &cd_G11213);
    dp->~G11213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11213(Test_G11213, "G11213", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11213C1Ev();
extern void _ZN6G11213D1Ev();
Name_Map name_map_G11213[] = {
  NSPAIR(_ZN6G11213C1Ev),
  NSPAIR(_ZN6G11213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G11213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11213[];
extern void _ZN6G112133fooEv();
extern void _ZN6G112133barEv();
extern void ABISELECT(_ZTv0_n32_N6G112133fooEv,_ZTv0_n16_N6G112133fooEv)();
extern void ABISELECT(_ZThn16_N6G112133fooEv,_ZThn8_N6G112133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112133fooEv,_ZTv0_n12_N6G112133fooEv)();
extern void ABISELECT(_ZThn32_N6G112133fooEv,_ZThn16_N6G112133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G112133fooEv,_ZTv0_n16_N6G112133fooEv)();
extern void ABISELECT(_ZThn48_N6G112133fooEv,_ZThn24_N6G112133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112133barEv,_ZTv0_n12_N6G112133barEv)();
extern void ABISELECT(_ZThn64_N6G112133barEv,_ZThn32_N6G112133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11213[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11213[0]),
  (VTBL_ENTRY)&_ZN6G112133fooEv,
  (VTBL_ENTRY)&_ZN6G112133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112133fooEv,_ZTv0_n16_N6G112133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112133fooEv,_ZTv0_n12_N6G112133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112133fooEv,_ZTv0_n16_N6G112133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112133barEv,_ZTv0_n12_N6G112133barEv),
};
extern VTBL_ENTRY _ZTV6G11213[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11213[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G11213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G11213[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G11213[] = {
  {&(_ZTV6G11213[6]),  6,26},
  {&(_ZTV6G11213[12]),  12,26},
  {&(_ZTV6G11213[16]),  16,26},
  {&(_ZTV6G11213[21]),  21,26},
  {&(_ZTV6G11213[25]),  25,26},
  {&(_tg__ZTV3E11__6G11213[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11213[3]),  3,4},
  {&(_tg__ZTV3F21__6G11213[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G11213[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11213[];
extern  VTBL_ENTRY _ZTV6G11213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11213[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112133barEv,_ZTv0_n12_N6G112133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G112133barEv,_ZThn32_N6G112133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112133fooEv,_ZTv0_n12_N6G112133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G112133fooEv,_ZThn16_N6G112133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112133fooEv,_ZTv0_n16_N6G112133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G112133fooEv,_ZThn24_N6G112133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G112133fooEv,_ZThn8_N6G112133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11213 = {  "G11213", // class name
  bases_G11213, 4,
  &(vtc_G11213[0]), // expected_vtbl_contents
  &(vtt_G11213[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11213),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11213),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11221  : virtual E11 , virtual F22 {
  int pg;
  virtual void  foo(); // _ZN6G112213fooEv
  ~G11221(); // tgen
  G11221(); // tgen
};
//SIG(1 G11221) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v2 Fi} v1 Fi}


void  G11221 ::foo(){vfunc_called(this, "_ZN6G112213fooEv");}
G11221 ::~G11221(){ note_dtor("G11221", this);} // tgen
G11221 ::G11221(){ note_ctor("G11221", this);} // tgen

static void Test_G11221()
{
  extern Class_Descriptor cd_G11221;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11221, buf);
    G11221 *dp, &lv = *(dp=new (buf) G11221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11221)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11221)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11221");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11221");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(64,32), "G11221");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G11221");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11221.pg");
    test_class_info(&lv, &cd_G11221);
    dp->~G11221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11221(Test_G11221, "G11221", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11221C1Ev();
extern void _ZN6G11221D1Ev();
Name_Map name_map_G11221[] = {
  NSPAIR(_ZN6G11221C1Ev),
  NSPAIR(_ZN6G11221D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G11221[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11221[];
extern void _ZN6G112213fooEv();
extern void ABISELECT(_ZTv0_n32_N6G112213fooEv,_ZTv0_n16_N6G112213fooEv)();
extern void ABISELECT(_ZThn16_N6G112213fooEv,_ZThn8_N6G112213fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112213fooEv,_ZTv0_n12_N6G112213fooEv)();
extern void ABISELECT(_ZThn32_N6G112213fooEv,_ZThn16_N6G112213fooEv)() __attribute__((weak));
extern void _ZN3F223barEv();
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11221[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11221[0]),
  (VTBL_ENTRY)&_ZN6G112213fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11221[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112213fooEv,_ZTv0_n16_N6G112213fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11221[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112213fooEv,_ZTv0_n12_N6G112213fooEv),
  0,
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11221[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11221[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
extern VTBL_ENTRY _ZTV6G11221[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11221[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11221[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G11221[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G11221[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G11221[] = {
  {&(_ZTV6G11221[6]),  6,25},
  {&(_ZTV6G11221[11]),  11,25},
  {&(_ZTV6G11221[15]),  15,25},
  {&(_ZTV6G11221[20]),  20,25},
  {&(_ZTV6G11221[24]),  24,25},
  {&(_tg__ZTV3E11__6G11221[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11221[3]),  3,4},
  {&(_tg__ZTV3F22__6G11221[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G11221[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11221[];
extern  VTBL_ENTRY _ZTV6G11221[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11221[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112213fooEv,_ZTv0_n12_N6G112213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G112213fooEv,_ZThn16_N6G112213fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112213fooEv,_ZTv0_n16_N6G112213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G112213fooEv,_ZThn8_N6G112213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11221 = {  "G11221", // class name
  bases_G11221, 4,
  &(vtc_G11221[0]), // expected_vtbl_contents
  &(vtt_G11221[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11221),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11221),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11221),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11222  : virtual E11 , virtual F22 {
  int pg;
  virtual void  bar(); // _ZN6G112223barEv
  ~G11222(); // tgen
  G11222(); // tgen
};
//SIG(1 G11222) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 Fi}


void  G11222 ::bar(){vfunc_called(this, "_ZN6G112223barEv");}
G11222 ::~G11222(){ note_dtor("G11222", this);} // tgen
G11222 ::G11222(){ note_ctor("G11222", this);} // tgen

static void Test_G11222()
{
  extern Class_Descriptor cd_G11222;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11222, buf);
    G11222 *dp, &lv = *(dp=new (buf) G11222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11222)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11222");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11222");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(64,32), "G11222");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G11222");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11222.pg");
    test_class_info(&lv, &cd_G11222);
    dp->~G11222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11222(Test_G11222, "G11222", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11222C1Ev();
extern void _ZN6G11222D1Ev();
Name_Map name_map_G11222[] = {
  NSPAIR(_ZN6G11222C1Ev),
  NSPAIR(_ZN6G11222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G11222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11222[];
extern void _ZN6G112223barEv();
extern void _ZN3E113fooEv();
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G112223barEv,_ZTv0_n16_N6G112223barEv)();
extern void ABISELECT(_ZThn48_N6G112223barEv,_ZThn24_N6G112223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112223barEv,_ZTv0_n12_N6G112223barEv)();
extern void ABISELECT(_ZThn64_N6G112223barEv,_ZThn32_N6G112223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11222[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11222[0]),
  (VTBL_ENTRY)&_ZN6G112223barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11222[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112223barEv,_ZTv0_n16_N6G112223barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112223barEv,_ZTv0_n12_N6G112223barEv),
};
extern VTBL_ENTRY _ZTV6G11222[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11222[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G11222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G11222[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G11222[] = {
  {&(_ZTV6G11222[6]),  6,25},
  {&(_ZTV6G11222[11]),  11,25},
  {&(_ZTV6G11222[15]),  15,25},
  {&(_ZTV6G11222[20]),  20,25},
  {&(_ZTV6G11222[24]),  24,25},
  {&(_tg__ZTV3E11__6G11222[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11222[3]),  3,4},
  {&(_tg__ZTV3F22__6G11222[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G11222[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11222[];
extern  VTBL_ENTRY _ZTV6G11222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11222[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112223barEv,_ZTv0_n12_N6G112223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G112223barEv,_ZThn32_N6G112223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112223barEv,_ZTv0_n16_N6G112223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G112223barEv,_ZThn24_N6G112223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11222 = {  "G11222", // class name
  bases_G11222, 4,
  &(vtc_G11222[0]), // expected_vtbl_contents
  &(vtt_G11222[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11222),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11222),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11223  : virtual E11 , virtual F22 {
  int pg;
  virtual void  foo(); // _ZN6G112233fooEv
  virtual void  bar(); // _ZN6G112233barEv
  ~G11223(); // tgen
  G11223(); // tgen
};
//SIG(1 G11223) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v2 Fi} v1 v2 Fi}


void  G11223 ::foo(){vfunc_called(this, "_ZN6G112233fooEv");}
void  G11223 ::bar(){vfunc_called(this, "_ZN6G112233barEv");}
G11223 ::~G11223(){ note_dtor("G11223", this);} // tgen
G11223 ::G11223(){ note_ctor("G11223", this);} // tgen

static void Test_G11223()
{
  extern Class_Descriptor cd_G11223;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11223, buf);
    G11223 *dp, &lv = *(dp=new (buf) G11223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11223)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11223");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11223");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(64,32), "G11223");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G11223");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11223.pg");
    test_class_info(&lv, &cd_G11223);
    dp->~G11223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11223(Test_G11223, "G11223", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11223C1Ev();
extern void _ZN6G11223D1Ev();
Name_Map name_map_G11223[] = {
  NSPAIR(_ZN6G11223C1Ev),
  NSPAIR(_ZN6G11223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G11223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11223[];
extern void _ZN6G112233fooEv();
extern void _ZN6G112233barEv();
extern void ABISELECT(_ZTv0_n32_N6G112233fooEv,_ZTv0_n16_N6G112233fooEv)();
extern void ABISELECT(_ZThn16_N6G112233fooEv,_ZThn8_N6G112233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112233fooEv,_ZTv0_n12_N6G112233fooEv)();
extern void ABISELECT(_ZThn32_N6G112233fooEv,_ZThn16_N6G112233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G112233barEv,_ZTv0_n16_N6G112233barEv)();
extern void ABISELECT(_ZThn48_N6G112233barEv,_ZThn24_N6G112233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112233barEv,_ZTv0_n12_N6G112233barEv)();
extern void ABISELECT(_ZThn64_N6G112233barEv,_ZThn32_N6G112233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11223[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11223[0]),
  (VTBL_ENTRY)&_ZN6G112233fooEv,
  (VTBL_ENTRY)&_ZN6G112233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112233fooEv,_ZTv0_n16_N6G112233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112233fooEv,_ZTv0_n12_N6G112233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112233barEv,_ZTv0_n16_N6G112233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112233barEv,_ZTv0_n12_N6G112233barEv),
};
extern VTBL_ENTRY _ZTV6G11223[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11223[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G11223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G11223[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G11223[] = {
  {&(_ZTV6G11223[6]),  6,26},
  {&(_ZTV6G11223[12]),  12,26},
  {&(_ZTV6G11223[16]),  16,26},
  {&(_ZTV6G11223[21]),  21,26},
  {&(_ZTV6G11223[25]),  25,26},
  {&(_tg__ZTV3E11__6G11223[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11223[3]),  3,4},
  {&(_tg__ZTV3F22__6G11223[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G11223[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11223[];
extern  VTBL_ENTRY _ZTV6G11223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11223[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112233barEv,_ZTv0_n12_N6G112233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G112233barEv,_ZThn32_N6G112233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112233barEv,_ZTv0_n16_N6G112233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G112233barEv,_ZThn24_N6G112233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112233fooEv,_ZTv0_n12_N6G112233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G112233fooEv,_ZThn16_N6G112233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112233fooEv,_ZTv0_n16_N6G112233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G112233fooEv,_ZThn8_N6G112233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11223 = {  "G11223", // class name
  bases_G11223, 4,
  &(vtc_G11223[0]), // expected_vtbl_contents
  &(vtt_G11223[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11223),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11223),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11231  : virtual E11 , virtual F23 {
  int pg;
  virtual void  foo(); // _ZN6G112313fooEv
  ~G11231(); // tgen
  G11231(); // tgen
};
//SIG(1 G11231) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v1 v2 Fi} v1 Fi}


void  G11231 ::foo(){vfunc_called(this, "_ZN6G112313fooEv");}
G11231 ::~G11231(){ note_dtor("G11231", this);} // tgen
G11231 ::G11231(){ note_ctor("G11231", this);} // tgen

static void Test_G11231()
{
  extern Class_Descriptor cd_G11231;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11231, buf);
    G11231 *dp, &lv = *(dp=new (buf) G11231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11231)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11231)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11231");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11231");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(64,32), "G11231");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G11231");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11231.pg");
    test_class_info(&lv, &cd_G11231);
    dp->~G11231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11231(Test_G11231, "G11231", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11231C1Ev();
extern void _ZN6G11231D1Ev();
Name_Map name_map_G11231[] = {
  NSPAIR(_ZN6G11231C1Ev),
  NSPAIR(_ZN6G11231D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G11231[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11231[];
extern void _ZN6G112313fooEv();
extern void ABISELECT(_ZTv0_n32_N6G112313fooEv,_ZTv0_n16_N6G112313fooEv)();
extern void ABISELECT(_ZThn16_N6G112313fooEv,_ZThn8_N6G112313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112313fooEv,_ZTv0_n12_N6G112313fooEv)();
extern void ABISELECT(_ZThn32_N6G112313fooEv,_ZThn16_N6G112313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G112313fooEv,_ZTv0_n16_N6G112313fooEv)();
extern void ABISELECT(_ZThn48_N6G112313fooEv,_ZThn24_N6G112313fooEv)() __attribute__((weak));
extern void _ZN3F233barEv();
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
extern void ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11231[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11231[0]),
  (VTBL_ENTRY)&_ZN6G112313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11231[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112313fooEv,_ZTv0_n16_N6G112313fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11231[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112313fooEv,_ZTv0_n12_N6G112313fooEv),
  0,
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11231[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112313fooEv,_ZTv0_n16_N6G112313fooEv),
  (VTBL_ENTRY)&_ZN3F233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11231[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
extern VTBL_ENTRY _ZTV6G11231[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11231[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11231[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G11231[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
extern void ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G11231[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G11231[] = {
  {&(_ZTV6G11231[6]),  6,27},
  {&(_ZTV6G11231[11]),  11,27},
  {&(_ZTV6G11231[15]),  15,27},
  {&(_ZTV6G11231[21]),  21,27},
  {&(_ZTV6G11231[26]),  26,27},
  {&(_tg__ZTV3E11__6G11231[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11231[3]),  3,4},
  {&(_tg__ZTV3F23__6G11231[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G11231[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11231[];
extern  VTBL_ENTRY _ZTV6G11231[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11231[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112313fooEv,_ZTv0_n12_N6G112313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G112313fooEv,_ZThn16_N6G112313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112313fooEv,_ZTv0_n16_N6G112313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G112313fooEv,_ZThn24_N6G112313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G112313fooEv,_ZThn8_N6G112313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11231 = {  "G11231", // class name
  bases_G11231, 4,
  &(vtc_G11231[0]), // expected_vtbl_contents
  &(vtt_G11231[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11231),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11231),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11231),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11233  : virtual E11 , virtual F23 {
  int pg;
  virtual void  foo(); // _ZN6G112333fooEv
  virtual void  bar(); // _ZN6G112333barEv
  ~G11233(); // tgen
  G11233(); // tgen
};
//SIG(1 G11233) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G11233 ::foo(){vfunc_called(this, "_ZN6G112333fooEv");}
void  G11233 ::bar(){vfunc_called(this, "_ZN6G112333barEv");}
G11233 ::~G11233(){ note_dtor("G11233", this);} // tgen
G11233 ::G11233(){ note_ctor("G11233", this);} // tgen

static void Test_G11233()
{
  extern Class_Descriptor cd_G11233;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11233, buf);
    G11233 *dp, &lv = *(dp=new (buf) G11233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11233)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11233");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11233");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(64,32), "G11233");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G11233");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11233.pg");
    test_class_info(&lv, &cd_G11233);
    dp->~G11233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11233(Test_G11233, "G11233", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11233C1Ev();
extern void _ZN6G11233D1Ev();
Name_Map name_map_G11233[] = {
  NSPAIR(_ZN6G11233C1Ev),
  NSPAIR(_ZN6G11233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G11233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11233[];
extern void _ZN6G112333fooEv();
extern void _ZN6G112333barEv();
extern void ABISELECT(_ZTv0_n32_N6G112333fooEv,_ZTv0_n16_N6G112333fooEv)();
extern void ABISELECT(_ZThn16_N6G112333fooEv,_ZThn8_N6G112333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112333fooEv,_ZTv0_n12_N6G112333fooEv)();
extern void ABISELECT(_ZThn32_N6G112333fooEv,_ZThn16_N6G112333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G112333fooEv,_ZTv0_n16_N6G112333fooEv)();
extern void ABISELECT(_ZThn48_N6G112333fooEv,_ZThn24_N6G112333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G112333barEv,_ZTv0_n20_N6G112333barEv)();
extern void ABISELECT(_ZThn48_N6G112333barEv,_ZThn24_N6G112333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G112333barEv,_ZTv0_n12_N6G112333barEv)();
extern void ABISELECT(_ZThn64_N6G112333barEv,_ZThn32_N6G112333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11233[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11233[0]),
  (VTBL_ENTRY)&_ZN6G112333fooEv,
  (VTBL_ENTRY)&_ZN6G112333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112333fooEv,_ZTv0_n16_N6G112333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112333fooEv,_ZTv0_n12_N6G112333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G112333fooEv,_ZTv0_n16_N6G112333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G112333barEv,_ZTv0_n20_N6G112333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G112333barEv,_ZTv0_n12_N6G112333barEv),
};
extern VTBL_ENTRY _ZTV6G11233[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11233[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G11233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
extern void ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G11233[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G11233[] = {
  {&(_ZTV6G11233[6]),  6,28},
  {&(_ZTV6G11233[12]),  12,28},
  {&(_ZTV6G11233[16]),  16,28},
  {&(_ZTV6G11233[22]),  22,28},
  {&(_ZTV6G11233[27]),  27,28},
  {&(_tg__ZTV3E11__6G11233[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11233[3]),  3,4},
  {&(_tg__ZTV3F23__6G11233[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G11233[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G11233[];
extern  VTBL_ENTRY _ZTV6G11233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11233[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112333barEv,_ZTv0_n12_N6G112333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G112333barEv,_ZThn32_N6G112333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G112333barEv,_ZTv0_n20_N6G112333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G112333barEv,_ZThn24_N6G112333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G112333fooEv,_ZTv0_n12_N6G112333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G112333fooEv,_ZThn16_N6G112333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G112333fooEv,_ZTv0_n16_N6G112333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G112333fooEv,_ZThn24_N6G112333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G112333fooEv,_ZThn8_N6G112333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11233 = {  "G11233", // class name
  bases_G11233, 4,
  &(vtc_G11233[0]), // expected_vtbl_contents
  &(vtt_G11233[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11233),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11233),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11311  : virtual E11 , virtual F31 {
  int pg;
  virtual void  foo(); // _ZN6G113113fooEv
  ~G11311(); // tgen
  G11311(); // tgen
};
//SIG(1 G11311) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 Fi} v1 Fi}


void  G11311 ::foo(){vfunc_called(this, "_ZN6G113113fooEv");}
G11311 ::~G11311(){ note_dtor("G11311", this);} // tgen
G11311 ::G11311(){ note_ctor("G11311", this);} // tgen

static void Test_G11311()
{
  extern Class_Descriptor cd_G11311;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11311, buf);
    G11311 *dp, &lv = *(dp=new (buf) G11311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11311)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11311)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11311");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11311");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G11311");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G11311");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11311.pg");
    test_class_info(&lv, &cd_G11311);
    dp->~G11311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11311(Test_G11311, "G11311", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11311C1Ev();
extern void _ZN6G11311D1Ev();
Name_Map name_map_G11311[] = {
  NSPAIR(_ZN6G11311C1Ev),
  NSPAIR(_ZN6G11311D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G11311[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11311[];
extern void _ZN6G113113fooEv();
extern void ABISELECT(_ZTv0_n32_N6G113113fooEv,_ZTv0_n16_N6G113113fooEv)();
extern void ABISELECT(_ZThn16_N6G113113fooEv,_ZThn8_N6G113113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113113fooEv,_ZTv0_n12_N6G113113fooEv)();
extern void ABISELECT(_ZThn32_N6G113113fooEv,_ZThn16_N6G113113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113113fooEv,_ZTv0_n16_N6G113113fooEv)();
extern void ABISELECT(_ZThn48_N6G113113fooEv,_ZThn24_N6G113113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113113fooEv,_ZTv0_n12_N6G113113fooEv)();
extern void ABISELECT(_ZThn64_N6G113113fooEv,_ZThn32_N6G113113fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY vtc_G11311[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11311[0]),
  (VTBL_ENTRY)&_ZN6G113113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113113fooEv,_ZTv0_n16_N6G113113fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113113fooEv,_ZTv0_n12_N6G113113fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113113fooEv,_ZTv0_n16_N6G113113fooEv),
  0,
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11311[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113113fooEv,_ZTv0_n12_N6G113113fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern VTBL_ENTRY _ZTV6G11311[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11311[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11311[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G11311[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G11311[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G11311[] = {
  {&(_ZTV6G11311[6]),  6,27},
  {&(_ZTV6G11311[11]),  11,27},
  {&(_ZTV6G11311[15]),  15,27},
  {&(_ZTV6G11311[20]),  20,27},
  {&(_ZTV6G11311[25]),  25,27},
  {&(_tg__ZTV3E11__6G11311[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11311[3]),  3,4},
  {&(_tg__ZTV3F31__6G11311[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G11311[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G11311[];
extern  VTBL_ENTRY _ZTV6G11311[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11311[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G113113fooEv,_ZTv0_n12_N6G113113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113113fooEv,_ZThn32_N6G113113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G113113fooEv,_ZThn16_N6G113113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113113fooEv,_ZTv0_n16_N6G113113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G113113fooEv,_ZThn24_N6G113113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G113113fooEv,_ZThn8_N6G113113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11311 = {  "G11311", // class name
  bases_G11311, 4,
  &(vtc_G11311[0]), // expected_vtbl_contents
  &(vtt_G11311[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11311),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11311),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11311),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11313  : virtual E11 , virtual F31 {
  int pg;
  virtual void  foo(); // _ZN6G113133fooEv
  virtual void  bar(); // _ZN6G113133barEv
  ~G11313(); // tgen
  G11313(); // tgen
};
//SIG(1 G11313) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 Fi} v1 v2 Fi}


void  G11313 ::foo(){vfunc_called(this, "_ZN6G113133fooEv");}
void  G11313 ::bar(){vfunc_called(this, "_ZN6G113133barEv");}
G11313 ::~G11313(){ note_dtor("G11313", this);} // tgen
G11313 ::G11313(){ note_ctor("G11313", this);} // tgen

static void Test_G11313()
{
  extern Class_Descriptor cd_G11313;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11313, buf);
    G11313 *dp, &lv = *(dp=new (buf) G11313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11313)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11313");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11313");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G11313");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G11313");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11313.pg");
    test_class_info(&lv, &cd_G11313);
    dp->~G11313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11313(Test_G11313, "G11313", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11313C1Ev();
extern void _ZN6G11313D1Ev();
Name_Map name_map_G11313[] = {
  NSPAIR(_ZN6G11313C1Ev),
  NSPAIR(_ZN6G11313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G11313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11313[];
extern void _ZN6G113133fooEv();
extern void _ZN6G113133barEv();
extern void ABISELECT(_ZTv0_n32_N6G113133fooEv,_ZTv0_n16_N6G113133fooEv)();
extern void ABISELECT(_ZThn16_N6G113133fooEv,_ZThn8_N6G113133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113133fooEv,_ZTv0_n12_N6G113133fooEv)();
extern void ABISELECT(_ZThn32_N6G113133fooEv,_ZThn16_N6G113133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113133fooEv,_ZTv0_n16_N6G113133fooEv)();
extern void ABISELECT(_ZThn48_N6G113133fooEv,_ZThn24_N6G113133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113133fooEv,_ZTv0_n12_N6G113133fooEv)();
extern void ABISELECT(_ZThn64_N6G113133fooEv,_ZThn32_N6G113133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113133barEv,_ZTv0_n16_N6G113133barEv)();
extern void ABISELECT(_ZThn64_N6G113133barEv,_ZThn32_N6G113133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11313[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11313[0]),
  (VTBL_ENTRY)&_ZN6G113133fooEv,
  (VTBL_ENTRY)&_ZN6G113133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113133fooEv,_ZTv0_n16_N6G113133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113133fooEv,_ZTv0_n12_N6G113133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113133fooEv,_ZTv0_n16_N6G113133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113133fooEv,_ZTv0_n12_N6G113133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113133barEv,_ZTv0_n16_N6G113133barEv),
};
extern VTBL_ENTRY _ZTV6G11313[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11313[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G11313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G11313[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G11313[] = {
  {&(_ZTV6G11313[6]),  6,28},
  {&(_ZTV6G11313[12]),  12,28},
  {&(_ZTV6G11313[16]),  16,28},
  {&(_ZTV6G11313[21]),  21,28},
  {&(_ZTV6G11313[26]),  26,28},
  {&(_tg__ZTV3E11__6G11313[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11313[3]),  3,4},
  {&(_tg__ZTV3F31__6G11313[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G11313[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G11313[];
extern  VTBL_ENTRY _ZTV6G11313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11313[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113133barEv,_ZTv0_n16_N6G113133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113133barEv,_ZThn32_N6G113133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G113133fooEv,_ZTv0_n12_N6G113133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113133fooEv,_ZThn32_N6G113133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G113133fooEv,_ZThn16_N6G113133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113133fooEv,_ZTv0_n16_N6G113133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G113133fooEv,_ZThn24_N6G113133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G113133fooEv,_ZThn8_N6G113133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11313 = {  "G11313", // class name
  bases_G11313, 4,
  &(vtc_G11313[0]), // expected_vtbl_contents
  &(vtt_G11313[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11313),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11313),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11321  : virtual E11 , virtual F32 {
  int pg;
  virtual void  foo(); // _ZN6G113213fooEv
  ~G11321(); // tgen
  G11321(); // tgen
};
//SIG(1 G11321) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v2 Fi} v1 Fi}


void  G11321 ::foo(){vfunc_called(this, "_ZN6G113213fooEv");}
G11321 ::~G11321(){ note_dtor("G11321", this);} // tgen
G11321 ::G11321(){ note_ctor("G11321", this);} // tgen

static void Test_G11321()
{
  extern Class_Descriptor cd_G11321;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11321, buf);
    G11321 *dp, &lv = *(dp=new (buf) G11321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11321)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11321)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11321");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11321");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G11321");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G11321");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11321.pg");
    test_class_info(&lv, &cd_G11321);
    dp->~G11321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11321(Test_G11321, "G11321", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11321C1Ev();
extern void _ZN6G11321D1Ev();
Name_Map name_map_G11321[] = {
  NSPAIR(_ZN6G11321C1Ev),
  NSPAIR(_ZN6G11321D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G11321[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11321[];
extern void _ZN6G113213fooEv();
extern void ABISELECT(_ZTv0_n32_N6G113213fooEv,_ZTv0_n16_N6G113213fooEv)();
extern void ABISELECT(_ZThn16_N6G113213fooEv,_ZThn8_N6G113213fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113213fooEv,_ZTv0_n12_N6G113213fooEv)();
extern void ABISELECT(_ZThn32_N6G113213fooEv,_ZThn16_N6G113213fooEv)() __attribute__((weak));
extern void _ZN3F323barEv();
extern void ABISELECT(_ZTv0_n24_N6G113213fooEv,_ZTv0_n12_N6G113213fooEv)();
extern void ABISELECT(_ZThn64_N6G113213fooEv,_ZThn32_N6G113213fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11321[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11321[0]),
  (VTBL_ENTRY)&_ZN6G113213fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11321[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113213fooEv,_ZTv0_n16_N6G113213fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11321[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113213fooEv,_ZTv0_n12_N6G113213fooEv),
  0,
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11321[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11321[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113213fooEv,_ZTv0_n12_N6G113213fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
extern VTBL_ENTRY _ZTV6G11321[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11321[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11321[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G11321[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G11321[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G11321[] = {
  {&(_ZTV6G11321[6]),  6,27},
  {&(_ZTV6G11321[11]),  11,27},
  {&(_ZTV6G11321[15]),  15,27},
  {&(_ZTV6G11321[20]),  20,27},
  {&(_ZTV6G11321[25]),  25,27},
  {&(_tg__ZTV3E11__6G11321[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11321[3]),  3,4},
  {&(_tg__ZTV3F32__6G11321[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G11321[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G11321[];
extern  VTBL_ENTRY _ZTV6G11321[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11321[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G113213fooEv,_ZTv0_n12_N6G113213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113213fooEv,_ZThn32_N6G113213fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G113213fooEv,_ZThn16_N6G113213fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113213fooEv,_ZTv0_n16_N6G113213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G113213fooEv,_ZThn8_N6G113213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11321 = {  "G11321", // class name
  bases_G11321, 4,
  &(vtc_G11321[0]), // expected_vtbl_contents
  &(vtt_G11321[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11321),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11321),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11321),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11323  : virtual E11 , virtual F32 {
  int pg;
  virtual void  foo(); // _ZN6G113233fooEv
  virtual void  bar(); // _ZN6G113233barEv
  ~G11323(); // tgen
  G11323(); // tgen
};
//SIG(1 G11323) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v2 Fi} v1 v2 Fi}


void  G11323 ::foo(){vfunc_called(this, "_ZN6G113233fooEv");}
void  G11323 ::bar(){vfunc_called(this, "_ZN6G113233barEv");}
G11323 ::~G11323(){ note_dtor("G11323", this);} // tgen
G11323 ::G11323(){ note_ctor("G11323", this);} // tgen

static void Test_G11323()
{
  extern Class_Descriptor cd_G11323;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11323, buf);
    G11323 *dp, &lv = *(dp=new (buf) G11323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11323)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11323");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11323");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G11323");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G11323");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11323.pg");
    test_class_info(&lv, &cd_G11323);
    dp->~G11323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11323(Test_G11323, "G11323", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11323C1Ev();
extern void _ZN6G11323D1Ev();
Name_Map name_map_G11323[] = {
  NSPAIR(_ZN6G11323C1Ev),
  NSPAIR(_ZN6G11323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G11323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11323[];
extern void _ZN6G113233fooEv();
extern void _ZN6G113233barEv();
extern void ABISELECT(_ZTv0_n32_N6G113233fooEv,_ZTv0_n16_N6G113233fooEv)();
extern void ABISELECT(_ZThn16_N6G113233fooEv,_ZThn8_N6G113233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113233fooEv,_ZTv0_n12_N6G113233fooEv)();
extern void ABISELECT(_ZThn32_N6G113233fooEv,_ZThn16_N6G113233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113233barEv,_ZTv0_n16_N6G113233barEv)();
extern void ABISELECT(_ZThn48_N6G113233barEv,_ZThn24_N6G113233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113233fooEv,_ZTv0_n12_N6G113233fooEv)();
extern void ABISELECT(_ZThn64_N6G113233fooEv,_ZThn32_N6G113233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113233barEv,_ZTv0_n16_N6G113233barEv)();
extern void ABISELECT(_ZThn64_N6G113233barEv,_ZThn32_N6G113233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11323[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11323[0]),
  (VTBL_ENTRY)&_ZN6G113233fooEv,
  (VTBL_ENTRY)&_ZN6G113233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113233fooEv,_ZTv0_n16_N6G113233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113233fooEv,_ZTv0_n12_N6G113233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113233barEv,_ZTv0_n16_N6G113233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113233fooEv,_ZTv0_n12_N6G113233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113233barEv,_ZTv0_n16_N6G113233barEv),
};
extern VTBL_ENTRY _ZTV6G11323[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11323[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G11323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G11323[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G11323[] = {
  {&(_ZTV6G11323[6]),  6,28},
  {&(_ZTV6G11323[12]),  12,28},
  {&(_ZTV6G11323[16]),  16,28},
  {&(_ZTV6G11323[21]),  21,28},
  {&(_ZTV6G11323[26]),  26,28},
  {&(_tg__ZTV3E11__6G11323[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11323[3]),  3,4},
  {&(_tg__ZTV3F32__6G11323[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G11323[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G11323[];
extern  VTBL_ENTRY _ZTV6G11323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11323[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113233barEv,_ZTv0_n16_N6G113233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113233barEv,_ZThn32_N6G113233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G113233barEv,_ZThn24_N6G113233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G113233fooEv,_ZTv0_n12_N6G113233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113233fooEv,_ZThn32_N6G113233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G113233fooEv,_ZThn16_N6G113233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113233fooEv,_ZTv0_n16_N6G113233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G113233fooEv,_ZThn8_N6G113233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11323 = {  "G11323", // class name
  bases_G11323, 4,
  &(vtc_G11323[0]), // expected_vtbl_contents
  &(vtt_G11323[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11323),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11323),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11331  : virtual E11 , virtual F33 {
  int pg;
  virtual void  foo(); // _ZN6G113313fooEv
  ~G11331(); // tgen
  G11331(); // tgen
};
//SIG(1 G11331) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 v2 Fi} v1 Fi}


void  G11331 ::foo(){vfunc_called(this, "_ZN6G113313fooEv");}
G11331 ::~G11331(){ note_dtor("G11331", this);} // tgen
G11331 ::G11331(){ note_ctor("G11331", this);} // tgen

static void Test_G11331()
{
  extern Class_Descriptor cd_G11331;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11331, buf);
    G11331 *dp, &lv = *(dp=new (buf) G11331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11331)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11331)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11331");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11331");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G11331");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G11331");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11331.pg");
    test_class_info(&lv, &cd_G11331);
    dp->~G11331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11331(Test_G11331, "G11331", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11331C1Ev();
extern void _ZN6G11331D1Ev();
Name_Map name_map_G11331[] = {
  NSPAIR(_ZN6G11331C1Ev),
  NSPAIR(_ZN6G11331D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G11331[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11331[];
extern void _ZN6G113313fooEv();
extern void ABISELECT(_ZTv0_n32_N6G113313fooEv,_ZTv0_n16_N6G113313fooEv)();
extern void ABISELECT(_ZThn16_N6G113313fooEv,_ZThn8_N6G113313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113313fooEv,_ZTv0_n12_N6G113313fooEv)();
extern void ABISELECT(_ZThn32_N6G113313fooEv,_ZThn16_N6G113313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113313fooEv,_ZTv0_n16_N6G113313fooEv)();
extern void ABISELECT(_ZThn48_N6G113313fooEv,_ZThn24_N6G113313fooEv)() __attribute__((weak));
extern void _ZN3F333barEv();
extern void ABISELECT(_ZTv0_n24_N6G113313fooEv,_ZTv0_n12_N6G113313fooEv)();
extern void ABISELECT(_ZThn64_N6G113313fooEv,_ZThn32_N6G113313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11331[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11331[0]),
  (VTBL_ENTRY)&_ZN6G113313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113313fooEv,_ZTv0_n16_N6G113313fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113313fooEv,_ZTv0_n12_N6G113313fooEv),
  0,
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113313fooEv,_ZTv0_n16_N6G113313fooEv),
  (VTBL_ENTRY)&_ZN3F333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11331[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113313fooEv,_ZTv0_n12_N6G113313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
extern VTBL_ENTRY _ZTV6G11331[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11331[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11331[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G11331[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G11331[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G11331[] = {
  {&(_ZTV6G11331[6]),  6,29},
  {&(_ZTV6G11331[11]),  11,29},
  {&(_ZTV6G11331[15]),  15,29},
  {&(_ZTV6G11331[21]),  21,29},
  {&(_ZTV6G11331[27]),  27,29},
  {&(_tg__ZTV3E11__6G11331[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11331[3]),  3,4},
  {&(_tg__ZTV3F33__6G11331[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G11331[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G11331[];
extern  VTBL_ENTRY _ZTV6G11331[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11331[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G113313fooEv,_ZTv0_n12_N6G113313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113313fooEv,_ZThn32_N6G113313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G113313fooEv,_ZThn16_N6G113313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113313fooEv,_ZTv0_n16_N6G113313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G113313fooEv,_ZThn24_N6G113313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G113313fooEv,_ZThn8_N6G113313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11331 = {  "G11331", // class name
  bases_G11331, 4,
  &(vtc_G11331[0]), // expected_vtbl_contents
  &(vtt_G11331[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11331),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11331),29, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11331),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G11333  : virtual E11 , virtual F33 {
  int pg;
  virtual void  foo(); // _ZN6G113333fooEv
  virtual void  bar(); // _ZN6G113333barEv
  ~G11333(); // tgen
  G11333(); // tgen
};
//SIG(1 G11333) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G11333 ::foo(){vfunc_called(this, "_ZN6G113333fooEv");}
void  G11333 ::bar(){vfunc_called(this, "_ZN6G113333barEv");}
G11333 ::~G11333(){ note_dtor("G11333", this);} // tgen
G11333 ::G11333(){ note_ctor("G11333", this);} // tgen

static void Test_G11333()
{
  extern Class_Descriptor cd_G11333;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G11333, buf);
    G11333 *dp, &lv = *(dp=new (buf) G11333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G11333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G11333)");
    check_base_class_offset(lv, (AA1*)(E11*), ABISELECT(32,16), "G11333");
    check_base_class_offset(lv, (E11*), ABISELECT(16,8), "G11333");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G11333");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G11333");
    check_field_offset(lv, pg, ABISELECT(8,4), "G11333.pg");
    test_class_info(&lv, &cd_G11333);
    dp->~G11333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG11333(Test_G11333, "G11333", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G11333C1Ev();
extern void _ZN6G11333D1Ev();
Name_Map name_map_G11333[] = {
  NSPAIR(_ZN6G11333C1Ev),
  NSPAIR(_ZN6G11333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E11;
extern VTBL_ENTRY _ZTI3E11[];
extern  VTBL_ENTRY _ZTV3E11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E11[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G11333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E11,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G11333[];
extern void _ZN6G113333fooEv();
extern void _ZN6G113333barEv();
extern void ABISELECT(_ZTv0_n32_N6G113333fooEv,_ZTv0_n16_N6G113333fooEv)();
extern void ABISELECT(_ZThn16_N6G113333fooEv,_ZThn8_N6G113333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113333fooEv,_ZTv0_n12_N6G113333fooEv)();
extern void ABISELECT(_ZThn32_N6G113333fooEv,_ZThn16_N6G113333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113333fooEv,_ZTv0_n16_N6G113333fooEv)();
extern void ABISELECT(_ZThn48_N6G113333fooEv,_ZThn24_N6G113333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G113333barEv,_ZTv0_n20_N6G113333barEv)();
extern void ABISELECT(_ZThn48_N6G113333barEv,_ZThn24_N6G113333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G113333fooEv,_ZTv0_n12_N6G113333fooEv)();
extern void ABISELECT(_ZThn64_N6G113333fooEv,_ZThn32_N6G113333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G113333barEv,_ZTv0_n16_N6G113333barEv)();
extern void ABISELECT(_ZThn64_N6G113333barEv,_ZThn32_N6G113333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G11333[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G11333[0]),
  (VTBL_ENTRY)&_ZN6G113333fooEv,
  (VTBL_ENTRY)&_ZN6G113333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G11333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113333fooEv,_ZTv0_n16_N6G113333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G11333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113333fooEv,_ZTv0_n12_N6G113333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G11333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113333fooEv,_ZTv0_n16_N6G113333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G113333barEv,_ZTv0_n20_N6G113333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G11333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G113333fooEv,_ZTv0_n12_N6G113333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G113333barEv,_ZTv0_n16_N6G113333barEv),
};
extern VTBL_ENTRY _ZTV6G11333[];
extern void _ZN3E113fooEv();
static  VTBL_ENTRY _tg__ZTV3E11__6G11333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&_ZN3E113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv)();
extern void ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E11__6G11333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv),
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G11333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G11333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G11333[] = {
  {&(_ZTV6G11333[6]),  6,30},
  {&(_ZTV6G11333[12]),  12,30},
  {&(_ZTV6G11333[16]),  16,30},
  {&(_ZTV6G11333[22]),  22,30},
  {&(_ZTV6G11333[28]),  28,30},
  {&(_tg__ZTV3E11__6G11333[3]),  3,4},
  {&(_tg__ZTV3AA1__3E11__6G11333[3]),  3,4},
  {&(_tg__ZTV3F33__6G11333[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G11333[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G11333[];
extern  VTBL_ENTRY _ZTV6G11333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G11333[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E113fooEv,_ZTv0_n12_N3E113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E113fooEv,_ZThn8_N3E113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113333barEv,_ZTv0_n16_N6G113333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113333barEv,_ZThn32_N6G113333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G113333barEv,_ZTv0_n20_N6G113333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G113333barEv,_ZThn24_N6G113333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G113333fooEv,_ZTv0_n12_N6G113333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G113333fooEv,_ZThn32_N6G113333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G113333fooEv,_ZThn16_N6G113333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G113333fooEv,_ZTv0_n16_N6G113333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G113333fooEv,_ZThn24_N6G113333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G113333fooEv,_ZThn8_N6G113333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G11333 = {  "G11333", // class name
  bases_G11333, 4,
  &(vtc_G11333[0]), // expected_vtbl_contents
  &(vtt_G11333[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G11333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G11333),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G11333),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12111  : virtual E12 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G121113fooEv
  ~G12111(); // tgen
  G12111(); // tgen
};
//SIG(1 G12111) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC3 v1 Fi} v1 Fi}


void  G12111 ::foo(){vfunc_called(this, "_ZN6G121113fooEv");}
G12111 ::~G12111(){ note_dtor("G12111", this);} // tgen
G12111 ::G12111(){ note_ctor("G12111", this);} // tgen

static void Test_G12111()
{
  extern Class_Descriptor cd_G12111;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G12111, buf);
    G12111 *dp, &lv = *(dp=new (buf) G12111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G12111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12111)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12111");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(32,16), "G12111");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12111");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G12111");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12111.pg");
    test_class_info(&lv, &cd_G12111);
    dp->~G12111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12111(Test_G12111, "G12111", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G12111C1Ev();
extern void _ZN6G12111D1Ev();
Name_Map name_map_G12111[] = {
  NSPAIR(_ZN6G12111C1Ev),
  NSPAIR(_ZN6G12111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G12111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12111[];
extern void _ZN6G121113fooEv();
extern void _ZN3E123barEv();
extern void ABISELECT(_ZTv0_n24_N6G121113fooEv,_ZTv0_n12_N6G121113fooEv)();
extern void ABISELECT(_ZThn32_N6G121113fooEv,_ZThn16_N6G121113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G121113fooEv,_ZTv0_n16_N6G121113fooEv)();
extern void ABISELECT(_ZThn48_N6G121113fooEv,_ZThn24_N6G121113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12111[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12111[0]),
  (VTBL_ENTRY)&_ZN6G121113fooEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12111[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G121113fooEv,_ZTv0_n12_N6G121113fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G121113fooEv,_ZTv0_n16_N6G121113fooEv),
};
extern VTBL_ENTRY _ZTV6G12111[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12111[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G12111[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G12111[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G12111[] = {
  {&(_ZTV6G12111[5]),  5,20},
  {&(_ZTV6G12111[10]),  10,20},
  {&(_ZTV6G12111[14]),  14,20},
  {&(_ZTV6G12111[19]),  19,20},
  {&(_tg__ZTV3E12__6G12111[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12111[3]),  3,4},
  {&(_tg__ZTV3F11__6G12111[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G12111[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12111[];
extern  VTBL_ENTRY _ZTV6G12111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12111[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G121113fooEv,_ZTv0_n16_N6G121113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G121113fooEv,_ZThn24_N6G121113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G121113fooEv,_ZTv0_n12_N6G121113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G121113fooEv,_ZThn16_N6G121113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12111 = {  "G12111", // class name
  bases_G12111, 3,
  &(vtc_G12111[0]), // expected_vtbl_contents
  &(vtt_G12111[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G12111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12111),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12111),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12113  : virtual E12 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G121133fooEv
  virtual void  bar(); // _ZN6G121133barEv
  ~G12113(); // tgen
  G12113(); // tgen
};
//SIG(1 G12113) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC3 v1 Fi} v1 v2 Fi}


void  G12113 ::foo(){vfunc_called(this, "_ZN6G121133fooEv");}
void  G12113 ::bar(){vfunc_called(this, "_ZN6G121133barEv");}
G12113 ::~G12113(){ note_dtor("G12113", this);} // tgen
G12113 ::G12113(){ note_ctor("G12113", this);} // tgen

static void Test_G12113()
{
  extern Class_Descriptor cd_G12113;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G12113, buf);
    G12113 *dp, &lv = *(dp=new (buf) G12113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G12113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12113)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12113");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(32,16), "G12113");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12113");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G12113");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12113.pg");
    test_class_info(&lv, &cd_G12113);
    dp->~G12113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12113(Test_G12113, "G12113", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G12113C1Ev();
extern void _ZN6G12113D1Ev();
Name_Map name_map_G12113[] = {
  NSPAIR(_ZN6G12113C1Ev),
  NSPAIR(_ZN6G12113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G12113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12113[];
extern void _ZN6G121133fooEv();
extern void _ZN6G121133barEv();
extern void ABISELECT(_ZTv0_n32_N6G121133barEv,_ZTv0_n16_N6G121133barEv)();
extern void ABISELECT(_ZThn16_N6G121133barEv,_ZThn8_N6G121133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G121133fooEv,_ZTv0_n12_N6G121133fooEv)();
extern void ABISELECT(_ZThn32_N6G121133fooEv,_ZThn16_N6G121133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G121133fooEv,_ZTv0_n16_N6G121133fooEv)();
extern void ABISELECT(_ZThn48_N6G121133fooEv,_ZThn24_N6G121133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12113[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12113[0]),
  (VTBL_ENTRY)&_ZN6G121133fooEv,
  (VTBL_ENTRY)&_ZN6G121133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G121133barEv,_ZTv0_n16_N6G121133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G121133fooEv,_ZTv0_n12_N6G121133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G121133fooEv,_ZTv0_n16_N6G121133fooEv),
};
extern VTBL_ENTRY _ZTV6G12113[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12113[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G12113[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G12113[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G12113[] = {
  {&(_ZTV6G12113[5]),  5,21},
  {&(_ZTV6G12113[11]),  11,21},
  {&(_ZTV6G12113[15]),  15,21},
  {&(_ZTV6G12113[20]),  20,21},
  {&(_tg__ZTV3E12__6G12113[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12113[3]),  3,4},
  {&(_tg__ZTV3F11__6G12113[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G12113[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12113[];
extern  VTBL_ENTRY _ZTV6G12113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12113[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G121133fooEv,_ZTv0_n16_N6G121133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G121133fooEv,_ZThn24_N6G121133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G121133fooEv,_ZTv0_n12_N6G121133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G121133fooEv,_ZThn16_N6G121133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G121133barEv,_ZTv0_n16_N6G121133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G121133barEv,_ZThn8_N6G121133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12113 = {  "G12113", // class name
  bases_G12113, 3,
  &(vtc_G12113[0]), // expected_vtbl_contents
  &(vtt_G12113[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G12113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12113),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12113),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12123  : virtual E12 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G121233fooEv
  virtual void  bar(); // _ZN6G121233barEv
  ~G12123(); // tgen
  G12123(); // tgen
};
//SIG(1 G12123) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC3 v2 Fi} v1 v2 Fi}


void  G12123 ::foo(){vfunc_called(this, "_ZN6G121233fooEv");}
void  G12123 ::bar(){vfunc_called(this, "_ZN6G121233barEv");}
G12123 ::~G12123(){ note_dtor("G12123", this);} // tgen
G12123 ::G12123(){ note_ctor("G12123", this);} // tgen

static void Test_G12123()
{
  extern Class_Descriptor cd_G12123;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G12123, buf);
    G12123 *dp, &lv = *(dp=new (buf) G12123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G12123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12123)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12123");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(32,16), "G12123");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12123");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G12123");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12123.pg");
    test_class_info(&lv, &cd_G12123);
    dp->~G12123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12123(Test_G12123, "G12123", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G12123C1Ev();
extern void _ZN6G12123D1Ev();
Name_Map name_map_G12123[] = {
  NSPAIR(_ZN6G12123C1Ev),
  NSPAIR(_ZN6G12123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G12123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12123[];
extern void _ZN6G121233fooEv();
extern void _ZN6G121233barEv();
extern void ABISELECT(_ZTv0_n32_N6G121233barEv,_ZTv0_n16_N6G121233barEv)();
extern void ABISELECT(_ZThn16_N6G121233barEv,_ZThn8_N6G121233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G121233fooEv,_ZTv0_n12_N6G121233fooEv)();
extern void ABISELECT(_ZThn32_N6G121233fooEv,_ZThn16_N6G121233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G121233barEv,_ZTv0_n16_N6G121233barEv)();
extern void ABISELECT(_ZThn48_N6G121233barEv,_ZThn24_N6G121233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12123[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12123[0]),
  (VTBL_ENTRY)&_ZN6G121233fooEv,
  (VTBL_ENTRY)&_ZN6G121233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G121233barEv,_ZTv0_n16_N6G121233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G121233fooEv,_ZTv0_n12_N6G121233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G121233barEv,_ZTv0_n16_N6G121233barEv),
};
extern VTBL_ENTRY _ZTV6G12123[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12123[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G12123[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G12123[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G12123[] = {
  {&(_ZTV6G12123[5]),  5,21},
  {&(_ZTV6G12123[11]),  11,21},
  {&(_ZTV6G12123[15]),  15,21},
  {&(_ZTV6G12123[20]),  20,21},
  {&(_tg__ZTV3E12__6G12123[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12123[3]),  3,4},
  {&(_tg__ZTV3F12__6G12123[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G12123[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12123[];
extern  VTBL_ENTRY _ZTV6G12123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12123[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G121233fooEv,_ZTv0_n12_N6G121233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G121233fooEv,_ZThn16_N6G121233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G121233barEv,_ZTv0_n16_N6G121233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G121233barEv,_ZThn24_N6G121233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G121233barEv,_ZThn8_N6G121233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12123 = {  "G12123", // class name
  bases_G12123, 3,
  &(vtc_G12123[0]), // expected_vtbl_contents
  &(vtt_G12123[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G12123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12123),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12123),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12133  : virtual E12 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G121333fooEv
  virtual void  bar(); // _ZN6G121333barEv
  ~G12133(); // tgen
  G12133(); // tgen
};
//SIG(1 G12133) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC3 v1 v2 Fi} v1 v2 Fi}


void  G12133 ::foo(){vfunc_called(this, "_ZN6G121333fooEv");}
void  G12133 ::bar(){vfunc_called(this, "_ZN6G121333barEv");}
G12133 ::~G12133(){ note_dtor("G12133", this);} // tgen
G12133 ::G12133(){ note_ctor("G12133", this);} // tgen

static void Test_G12133()
{
  extern Class_Descriptor cd_G12133;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G12133, buf);
    G12133 *dp, &lv = *(dp=new (buf) G12133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G12133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12133)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12133");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(32,16), "G12133");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12133");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G12133");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12133.pg");
    test_class_info(&lv, &cd_G12133);
    dp->~G12133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12133(Test_G12133, "G12133", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G12133C1Ev();
extern void _ZN6G12133D1Ev();
Name_Map name_map_G12133[] = {
  NSPAIR(_ZN6G12133C1Ev),
  NSPAIR(_ZN6G12133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G12133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12133[];
extern void _ZN6G121333fooEv();
extern void _ZN6G121333barEv();
extern void ABISELECT(_ZTv0_n32_N6G121333barEv,_ZTv0_n16_N6G121333barEv)();
extern void ABISELECT(_ZThn16_N6G121333barEv,_ZThn8_N6G121333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G121333fooEv,_ZTv0_n12_N6G121333fooEv)();
extern void ABISELECT(_ZThn32_N6G121333fooEv,_ZThn16_N6G121333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G121333fooEv,_ZTv0_n16_N6G121333fooEv)();
extern void ABISELECT(_ZThn48_N6G121333fooEv,_ZThn24_N6G121333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G121333barEv,_ZTv0_n20_N6G121333barEv)();
extern void ABISELECT(_ZThn48_N6G121333barEv,_ZThn24_N6G121333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12133[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12133[0]),
  (VTBL_ENTRY)&_ZN6G121333fooEv,
  (VTBL_ENTRY)&_ZN6G121333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G121333barEv,_ZTv0_n16_N6G121333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G121333fooEv,_ZTv0_n12_N6G121333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G121333fooEv,_ZTv0_n16_N6G121333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G121333barEv,_ZTv0_n20_N6G121333barEv),
};
extern VTBL_ENTRY _ZTV6G12133[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12133[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G12133[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G12133[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G12133[] = {
  {&(_ZTV6G12133[5]),  5,23},
  {&(_ZTV6G12133[11]),  11,23},
  {&(_ZTV6G12133[15]),  15,23},
  {&(_ZTV6G12133[21]),  21,23},
  {&(_tg__ZTV3E12__6G12133[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12133[3]),  3,4},
  {&(_tg__ZTV3F13__6G12133[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G12133[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12133[];
extern  VTBL_ENTRY _ZTV6G12133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12133[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G121333barEv,_ZTv0_n20_N6G121333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G121333barEv,_ZThn24_N6G121333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G121333fooEv,_ZTv0_n16_N6G121333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G121333fooEv,_ZThn24_N6G121333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G121333fooEv,_ZTv0_n12_N6G121333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G121333fooEv,_ZThn16_N6G121333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G121333barEv,_ZTv0_n16_N6G121333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G121333barEv,_ZThn8_N6G121333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12133 = {  "G12133", // class name
  bases_G12133, 3,
  &(vtc_G12133[0]), // expected_vtbl_contents
  &(vtt_G12133[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G12133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12133),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12133),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12213  : virtual E12 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G122133fooEv
  virtual void  bar(); // _ZN6G122133barEv
  ~G12213(); // tgen
  G12213(); // tgen
};
//SIG(1 G12213) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC5{ v2 Fi} v1 Fi} v1 v2 Fi}


void  G12213 ::foo(){vfunc_called(this, "_ZN6G122133fooEv");}
void  G12213 ::bar(){vfunc_called(this, "_ZN6G122133barEv");}
G12213 ::~G12213(){ note_dtor("G12213", this);} // tgen
G12213 ::G12213(){ note_ctor("G12213", this);} // tgen

static void Test_G12213()
{
  extern Class_Descriptor cd_G12213;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G12213, buf);
    G12213 *dp, &lv = *(dp=new (buf) G12213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G12213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12213)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12213");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12213");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(64,32), "G12213");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G12213");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12213.pg");
    test_class_info(&lv, &cd_G12213);
    dp->~G12213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12213(Test_G12213, "G12213", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G12213C1Ev();
extern void _ZN6G12213D1Ev();
Name_Map name_map_G12213[] = {
  NSPAIR(_ZN6G12213C1Ev),
  NSPAIR(_ZN6G12213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G12213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12213[];
extern void _ZN6G122133fooEv();
extern void _ZN6G122133barEv();
extern void ABISELECT(_ZTv0_n32_N6G122133barEv,_ZTv0_n16_N6G122133barEv)();
extern void ABISELECT(_ZThn16_N6G122133barEv,_ZThn8_N6G122133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G122133fooEv,_ZTv0_n12_N6G122133fooEv)();
extern void ABISELECT(_ZThn32_N6G122133fooEv,_ZThn16_N6G122133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G122133fooEv,_ZTv0_n16_N6G122133fooEv)();
extern void ABISELECT(_ZThn48_N6G122133fooEv,_ZThn24_N6G122133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G122133barEv,_ZTv0_n12_N6G122133barEv)();
extern void ABISELECT(_ZThn64_N6G122133barEv,_ZThn32_N6G122133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12213[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12213[0]),
  (VTBL_ENTRY)&_ZN6G122133fooEv,
  (VTBL_ENTRY)&_ZN6G122133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122133barEv,_ZTv0_n16_N6G122133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G122133fooEv,_ZTv0_n12_N6G122133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122133fooEv,_ZTv0_n16_N6G122133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G12213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G122133barEv,_ZTv0_n12_N6G122133barEv),
};
extern VTBL_ENTRY _ZTV6G12213[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12213[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G12213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G12213[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G12213[] = {
  {&(_ZTV6G12213[6]),  6,26},
  {&(_ZTV6G12213[12]),  12,26},
  {&(_ZTV6G12213[16]),  16,26},
  {&(_ZTV6G12213[21]),  21,26},
  {&(_ZTV6G12213[25]),  25,26},
  {&(_tg__ZTV3E12__6G12213[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12213[3]),  3,4},
  {&(_tg__ZTV3F21__6G12213[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G12213[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12213[];
extern  VTBL_ENTRY _ZTV6G12213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12213[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G122133barEv,_ZTv0_n12_N6G122133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G122133barEv,_ZThn32_N6G122133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G122133fooEv,_ZTv0_n16_N6G122133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G122133fooEv,_ZThn24_N6G122133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G122133fooEv,_ZTv0_n12_N6G122133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G122133fooEv,_ZThn16_N6G122133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G122133barEv,_ZTv0_n16_N6G122133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G122133barEv,_ZThn8_N6G122133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12213 = {  "G12213", // class name
  bases_G12213, 4,
  &(vtc_G12213[0]), // expected_vtbl_contents
  &(vtt_G12213[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G12213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12213),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12213),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12222  : virtual E12 , virtual F22 {
  int pg;
  virtual void  bar(); // _ZN6G122223barEv
  ~G12222(); // tgen
  G12222(); // tgen
};
//SIG(1 G12222) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 Fi}


void  G12222 ::bar(){vfunc_called(this, "_ZN6G122223barEv");}
G12222 ::~G12222(){ note_dtor("G12222", this);} // tgen
G12222 ::G12222(){ note_ctor("G12222", this);} // tgen

static void Test_G12222()
{
  extern Class_Descriptor cd_G12222;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G12222, buf);
    G12222 *dp, &lv = *(dp=new (buf) G12222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G12222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12222)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12222");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12222");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(64,32), "G12222");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G12222");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12222.pg");
    test_class_info(&lv, &cd_G12222);
    dp->~G12222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12222(Test_G12222, "G12222", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G12222C1Ev();
extern void _ZN6G12222D1Ev();
Name_Map name_map_G12222[] = {
  NSPAIR(_ZN6G12222C1Ev),
  NSPAIR(_ZN6G12222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G12222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12222[];
extern void _ZN6G122223barEv();
extern void ABISELECT(_ZTv0_n32_N6G122223barEv,_ZTv0_n16_N6G122223barEv)();
extern void ABISELECT(_ZThn16_N6G122223barEv,_ZThn8_N6G122223barEv)() __attribute__((weak));
extern void _ZN3AA13fooEv();
extern void ABISELECT(_ZTv0_n32_N6G122223barEv,_ZTv0_n16_N6G122223barEv)();
extern void ABISELECT(_ZThn48_N6G122223barEv,_ZThn24_N6G122223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G122223barEv,_ZTv0_n12_N6G122223barEv)();
extern void ABISELECT(_ZThn64_N6G122223barEv,_ZThn32_N6G122223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12222[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12222[0]),
  (VTBL_ENTRY)&_ZN6G122223barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122223barEv,_ZTv0_n16_N6G122223barEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12222[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122223barEv,_ZTv0_n16_N6G122223barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G12222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G122223barEv,_ZTv0_n12_N6G122223barEv),
};
extern VTBL_ENTRY _ZTV6G12222[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12222[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G12222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G12222[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G12222[] = {
  {&(_ZTV6G12222[6]),  6,25},
  {&(_ZTV6G12222[11]),  11,25},
  {&(_ZTV6G12222[15]),  15,25},
  {&(_ZTV6G12222[20]),  20,25},
  {&(_ZTV6G12222[24]),  24,25},
  {&(_tg__ZTV3E12__6G12222[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12222[3]),  3,4},
  {&(_tg__ZTV3F22__6G12222[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G12222[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12222[];
extern  VTBL_ENTRY _ZTV6G12222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12222[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G122223barEv,_ZTv0_n12_N6G122223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G122223barEv,_ZThn32_N6G122223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G122223barEv,_ZTv0_n16_N6G122223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G122223barEv,_ZThn24_N6G122223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G122223barEv,_ZThn8_N6G122223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12222 = {  "G12222", // class name
  bases_G12222, 4,
  &(vtc_G12222[0]), // expected_vtbl_contents
  &(vtt_G12222[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G12222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12222),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12222),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12223  : virtual E12 , virtual F22 {
  int pg;
  virtual void  foo(); // _ZN6G122233fooEv
  virtual void  bar(); // _ZN6G122233barEv
  ~G12223(); // tgen
  G12223(); // tgen
};
//SIG(1 G12223) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC5{ v2 Fi} v2 Fi} v1 v2 Fi}


void  G12223 ::foo(){vfunc_called(this, "_ZN6G122233fooEv");}
void  G12223 ::bar(){vfunc_called(this, "_ZN6G122233barEv");}
G12223 ::~G12223(){ note_dtor("G12223", this);} // tgen
G12223 ::G12223(){ note_ctor("G12223", this);} // tgen

static void Test_G12223()
{
  extern Class_Descriptor cd_G12223;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G12223, buf);
    G12223 *dp, &lv = *(dp=new (buf) G12223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G12223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12223)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12223");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12223");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(64,32), "G12223");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G12223");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12223.pg");
    test_class_info(&lv, &cd_G12223);
    dp->~G12223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12223(Test_G12223, "G12223", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G12223C1Ev();
extern void _ZN6G12223D1Ev();
Name_Map name_map_G12223[] = {
  NSPAIR(_ZN6G12223C1Ev),
  NSPAIR(_ZN6G12223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G12223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12223[];
extern void _ZN6G122233fooEv();
extern void _ZN6G122233barEv();
extern void ABISELECT(_ZTv0_n32_N6G122233barEv,_ZTv0_n16_N6G122233barEv)();
extern void ABISELECT(_ZThn16_N6G122233barEv,_ZThn8_N6G122233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G122233fooEv,_ZTv0_n12_N6G122233fooEv)();
extern void ABISELECT(_ZThn32_N6G122233fooEv,_ZThn16_N6G122233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G122233barEv,_ZTv0_n16_N6G122233barEv)();
extern void ABISELECT(_ZThn48_N6G122233barEv,_ZThn24_N6G122233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G122233barEv,_ZTv0_n12_N6G122233barEv)();
extern void ABISELECT(_ZThn64_N6G122233barEv,_ZThn32_N6G122233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12223[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12223[0]),
  (VTBL_ENTRY)&_ZN6G122233fooEv,
  (VTBL_ENTRY)&_ZN6G122233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122233barEv,_ZTv0_n16_N6G122233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G122233fooEv,_ZTv0_n12_N6G122233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122233barEv,_ZTv0_n16_N6G122233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G12223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G122233barEv,_ZTv0_n12_N6G122233barEv),
};
extern VTBL_ENTRY _ZTV6G12223[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12223[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G12223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G12223[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G12223[] = {
  {&(_ZTV6G12223[6]),  6,26},
  {&(_ZTV6G12223[12]),  12,26},
  {&(_ZTV6G12223[16]),  16,26},
  {&(_ZTV6G12223[21]),  21,26},
  {&(_ZTV6G12223[25]),  25,26},
  {&(_tg__ZTV3E12__6G12223[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12223[3]),  3,4},
  {&(_tg__ZTV3F22__6G12223[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G12223[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12223[];
extern  VTBL_ENTRY _ZTV6G12223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12223[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G122233barEv,_ZTv0_n12_N6G122233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G122233barEv,_ZThn32_N6G122233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G122233fooEv,_ZTv0_n12_N6G122233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G122233fooEv,_ZThn16_N6G122233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G122233barEv,_ZTv0_n16_N6G122233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G122233barEv,_ZThn24_N6G122233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G122233barEv,_ZThn8_N6G122233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12223 = {  "G12223", // class name
  bases_G12223, 4,
  &(vtc_G12223[0]), // expected_vtbl_contents
  &(vtt_G12223[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G12223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12223),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12223),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12233  : virtual E12 , virtual F23 {
  int pg;
  virtual void  foo(); // _ZN6G122333fooEv
  virtual void  bar(); // _ZN6G122333barEv
  ~G12233(); // tgen
  G12233(); // tgen
};
//SIG(1 G12233) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC5{ v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G12233 ::foo(){vfunc_called(this, "_ZN6G122333fooEv");}
void  G12233 ::bar(){vfunc_called(this, "_ZN6G122333barEv");}
G12233 ::~G12233(){ note_dtor("G12233", this);} // tgen
G12233 ::G12233(){ note_ctor("G12233", this);} // tgen

static void Test_G12233()
{
  extern Class_Descriptor cd_G12233;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G12233, buf);
    G12233 *dp, &lv = *(dp=new (buf) G12233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G12233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12233)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12233");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12233");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(64,32), "G12233");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G12233");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12233.pg");
    test_class_info(&lv, &cd_G12233);
    dp->~G12233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12233(Test_G12233, "G12233", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G12233C1Ev();
extern void _ZN6G12233D1Ev();
Name_Map name_map_G12233[] = {
  NSPAIR(_ZN6G12233C1Ev),
  NSPAIR(_ZN6G12233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G12233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12233[];
extern void _ZN6G122333fooEv();
extern void _ZN6G122333barEv();
extern void ABISELECT(_ZTv0_n32_N6G122333barEv,_ZTv0_n16_N6G122333barEv)();
extern void ABISELECT(_ZThn16_N6G122333barEv,_ZThn8_N6G122333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G122333fooEv,_ZTv0_n12_N6G122333fooEv)();
extern void ABISELECT(_ZThn32_N6G122333fooEv,_ZThn16_N6G122333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G122333fooEv,_ZTv0_n16_N6G122333fooEv)();
extern void ABISELECT(_ZThn48_N6G122333fooEv,_ZThn24_N6G122333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G122333barEv,_ZTv0_n20_N6G122333barEv)();
extern void ABISELECT(_ZThn48_N6G122333barEv,_ZThn24_N6G122333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G122333barEv,_ZTv0_n12_N6G122333barEv)();
extern void ABISELECT(_ZThn64_N6G122333barEv,_ZThn32_N6G122333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12233[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12233[0]),
  (VTBL_ENTRY)&_ZN6G122333fooEv,
  (VTBL_ENTRY)&_ZN6G122333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122333barEv,_ZTv0_n16_N6G122333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G122333fooEv,_ZTv0_n12_N6G122333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G122333fooEv,_ZTv0_n16_N6G122333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G122333barEv,_ZTv0_n20_N6G122333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G12233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G122333barEv,_ZTv0_n12_N6G122333barEv),
};
extern VTBL_ENTRY _ZTV6G12233[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12233[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G12233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
extern void ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G12233[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G12233[] = {
  {&(_ZTV6G12233[6]),  6,28},
  {&(_ZTV6G12233[12]),  12,28},
  {&(_ZTV6G12233[16]),  16,28},
  {&(_ZTV6G12233[22]),  22,28},
  {&(_ZTV6G12233[27]),  27,28},
  {&(_tg__ZTV3E12__6G12233[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12233[3]),  3,4},
  {&(_tg__ZTV3F23__6G12233[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G12233[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G12233[];
extern  VTBL_ENTRY _ZTV6G12233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12233[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G122333barEv,_ZTv0_n12_N6G122333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G122333barEv,_ZThn32_N6G122333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G122333barEv,_ZTv0_n20_N6G122333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G122333barEv,_ZThn24_N6G122333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G122333fooEv,_ZTv0_n16_N6G122333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G122333fooEv,_ZThn24_N6G122333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G122333fooEv,_ZTv0_n12_N6G122333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G122333fooEv,_ZThn16_N6G122333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G122333barEv,_ZTv0_n16_N6G122333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G122333barEv,_ZThn8_N6G122333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12233 = {  "G12233", // class name
  bases_G12233, 4,
  &(vtc_G12233[0]), // expected_vtbl_contents
  &(vtt_G12233[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G12233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12233),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12233),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12313  : virtual E12 , virtual F31 {
  int pg;
  virtual void  foo(); // _ZN6G123133fooEv
  virtual void  bar(); // _ZN6G123133barEv
  ~G12313(); // tgen
  G12313(); // tgen
};
//SIG(1 G12313) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 Fi} v1 v2 Fi}


void  G12313 ::foo(){vfunc_called(this, "_ZN6G123133fooEv");}
void  G12313 ::bar(){vfunc_called(this, "_ZN6G123133barEv");}
G12313 ::~G12313(){ note_dtor("G12313", this);} // tgen
G12313 ::G12313(){ note_ctor("G12313", this);} // tgen

static void Test_G12313()
{
  extern Class_Descriptor cd_G12313;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G12313, buf);
    G12313 *dp, &lv = *(dp=new (buf) G12313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G12313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12313)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12313");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12313");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G12313");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G12313");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12313.pg");
    test_class_info(&lv, &cd_G12313);
    dp->~G12313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12313(Test_G12313, "G12313", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G12313C1Ev();
extern void _ZN6G12313D1Ev();
Name_Map name_map_G12313[] = {
  NSPAIR(_ZN6G12313C1Ev),
  NSPAIR(_ZN6G12313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G12313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12313[];
extern void _ZN6G123133fooEv();
extern void _ZN6G123133barEv();
extern void ABISELECT(_ZTv0_n32_N6G123133barEv,_ZTv0_n16_N6G123133barEv)();
extern void ABISELECT(_ZThn16_N6G123133barEv,_ZThn8_N6G123133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G123133fooEv,_ZTv0_n12_N6G123133fooEv)();
extern void ABISELECT(_ZThn32_N6G123133fooEv,_ZThn16_N6G123133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G123133fooEv,_ZTv0_n16_N6G123133fooEv)();
extern void ABISELECT(_ZThn48_N6G123133fooEv,_ZThn24_N6G123133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G123133fooEv,_ZTv0_n12_N6G123133fooEv)();
extern void ABISELECT(_ZThn64_N6G123133fooEv,_ZThn32_N6G123133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G123133barEv,_ZTv0_n16_N6G123133barEv)();
extern void ABISELECT(_ZThn64_N6G123133barEv,_ZThn32_N6G123133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12313[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12313[0]),
  (VTBL_ENTRY)&_ZN6G123133fooEv,
  (VTBL_ENTRY)&_ZN6G123133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123133barEv,_ZTv0_n16_N6G123133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G123133fooEv,_ZTv0_n12_N6G123133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123133fooEv,_ZTv0_n16_N6G123133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G12313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G123133fooEv,_ZTv0_n12_N6G123133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123133barEv,_ZTv0_n16_N6G123133barEv),
};
extern VTBL_ENTRY _ZTV6G12313[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12313[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G12313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G12313[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G12313[] = {
  {&(_ZTV6G12313[6]),  6,28},
  {&(_ZTV6G12313[12]),  12,28},
  {&(_ZTV6G12313[16]),  16,28},
  {&(_ZTV6G12313[21]),  21,28},
  {&(_ZTV6G12313[26]),  26,28},
  {&(_tg__ZTV3E12__6G12313[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12313[3]),  3,4},
  {&(_tg__ZTV3F31__6G12313[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G12313[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G12313[];
extern  VTBL_ENTRY _ZTV6G12313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12313[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G123133fooEv,_ZTv0_n16_N6G123133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G123133fooEv,_ZThn24_N6G123133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G123133fooEv,_ZTv0_n12_N6G123133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G123133fooEv,_ZThn32_N6G123133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G123133fooEv,_ZThn16_N6G123133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G123133barEv,_ZTv0_n16_N6G123133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G123133barEv,_ZThn32_N6G123133barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G123133barEv,_ZThn8_N6G123133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12313 = {  "G12313", // class name
  bases_G12313, 4,
  &(vtc_G12313[0]), // expected_vtbl_contents
  &(vtt_G12313[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G12313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12313),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12313),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12323  : virtual E12 , virtual F32 {
  int pg;
  virtual void  foo(); // _ZN6G123233fooEv
  virtual void  bar(); // _ZN6G123233barEv
  ~G12323(); // tgen
  G12323(); // tgen
};
//SIG(1 G12323) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v2 Fi} v1 v2 Fi}


void  G12323 ::foo(){vfunc_called(this, "_ZN6G123233fooEv");}
void  G12323 ::bar(){vfunc_called(this, "_ZN6G123233barEv");}
G12323 ::~G12323(){ note_dtor("G12323", this);} // tgen
G12323 ::G12323(){ note_ctor("G12323", this);} // tgen

static void Test_G12323()
{
  extern Class_Descriptor cd_G12323;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G12323, buf);
    G12323 *dp, &lv = *(dp=new (buf) G12323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G12323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12323)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12323");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12323");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G12323");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G12323");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12323.pg");
    test_class_info(&lv, &cd_G12323);
    dp->~G12323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12323(Test_G12323, "G12323", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G12323C1Ev();
extern void _ZN6G12323D1Ev();
Name_Map name_map_G12323[] = {
  NSPAIR(_ZN6G12323C1Ev),
  NSPAIR(_ZN6G12323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G12323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12323[];
extern void _ZN6G123233fooEv();
extern void _ZN6G123233barEv();
extern void ABISELECT(_ZTv0_n32_N6G123233barEv,_ZTv0_n16_N6G123233barEv)();
extern void ABISELECT(_ZThn16_N6G123233barEv,_ZThn8_N6G123233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G123233fooEv,_ZTv0_n12_N6G123233fooEv)();
extern void ABISELECT(_ZThn32_N6G123233fooEv,_ZThn16_N6G123233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G123233barEv,_ZTv0_n16_N6G123233barEv)();
extern void ABISELECT(_ZThn48_N6G123233barEv,_ZThn24_N6G123233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G123233fooEv,_ZTv0_n12_N6G123233fooEv)();
extern void ABISELECT(_ZThn64_N6G123233fooEv,_ZThn32_N6G123233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G123233barEv,_ZTv0_n16_N6G123233barEv)();
extern void ABISELECT(_ZThn64_N6G123233barEv,_ZThn32_N6G123233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12323[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12323[0]),
  (VTBL_ENTRY)&_ZN6G123233fooEv,
  (VTBL_ENTRY)&_ZN6G123233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123233barEv,_ZTv0_n16_N6G123233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G123233fooEv,_ZTv0_n12_N6G123233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123233barEv,_ZTv0_n16_N6G123233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G12323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G123233fooEv,_ZTv0_n12_N6G123233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123233barEv,_ZTv0_n16_N6G123233barEv),
};
extern VTBL_ENTRY _ZTV6G12323[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12323[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G12323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G12323[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G12323[] = {
  {&(_ZTV6G12323[6]),  6,28},
  {&(_ZTV6G12323[12]),  12,28},
  {&(_ZTV6G12323[16]),  16,28},
  {&(_ZTV6G12323[21]),  21,28},
  {&(_ZTV6G12323[26]),  26,28},
  {&(_tg__ZTV3E12__6G12323[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12323[3]),  3,4},
  {&(_tg__ZTV3F32__6G12323[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G12323[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G12323[];
extern  VTBL_ENTRY _ZTV6G12323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12323[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G123233fooEv,_ZTv0_n12_N6G123233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G123233fooEv,_ZThn32_N6G123233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G123233fooEv,_ZThn16_N6G123233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G123233barEv,_ZTv0_n16_N6G123233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G123233barEv,_ZThn32_N6G123233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G123233barEv,_ZThn24_N6G123233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G123233barEv,_ZThn8_N6G123233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12323 = {  "G12323", // class name
  bases_G12323, 4,
  &(vtc_G12323[0]), // expected_vtbl_contents
  &(vtt_G12323[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G12323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12323),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12323),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G12333  : virtual E12 , virtual F33 {
  int pg;
  virtual void  foo(); // _ZN6G123333fooEv
  virtual void  bar(); // _ZN6G123333barEv
  ~G12333(); // tgen
  G12333(); // tgen
};
//SIG(1 G12333) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G12333 ::foo(){vfunc_called(this, "_ZN6G123333fooEv");}
void  G12333 ::bar(){vfunc_called(this, "_ZN6G123333barEv");}
G12333 ::~G12333(){ note_dtor("G12333", this);} // tgen
G12333 ::G12333(){ note_ctor("G12333", this);} // tgen

static void Test_G12333()
{
  extern Class_Descriptor cd_G12333;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G12333, buf);
    G12333 *dp, &lv = *(dp=new (buf) G12333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G12333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G12333)");
    check_base_class_offset(lv, (AA1*)(E12*), ABISELECT(32,16), "G12333");
    check_base_class_offset(lv, (E12*), ABISELECT(16,8), "G12333");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G12333");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G12333");
    check_field_offset(lv, pg, ABISELECT(8,4), "G12333.pg");
    test_class_info(&lv, &cd_G12333);
    dp->~G12333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG12333(Test_G12333, "G12333", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G12333C1Ev();
extern void _ZN6G12333D1Ev();
Name_Map name_map_G12333[] = {
  NSPAIR(_ZN6G12333C1Ev),
  NSPAIR(_ZN6G12333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E12;
extern VTBL_ENTRY _ZTI3E12[];
extern  VTBL_ENTRY _ZTV3E12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E12[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G12333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E12,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G12333[];
extern void _ZN6G123333fooEv();
extern void _ZN6G123333barEv();
extern void ABISELECT(_ZTv0_n32_N6G123333barEv,_ZTv0_n16_N6G123333barEv)();
extern void ABISELECT(_ZThn16_N6G123333barEv,_ZThn8_N6G123333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G123333fooEv,_ZTv0_n12_N6G123333fooEv)();
extern void ABISELECT(_ZThn32_N6G123333fooEv,_ZThn16_N6G123333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G123333fooEv,_ZTv0_n16_N6G123333fooEv)();
extern void ABISELECT(_ZThn48_N6G123333fooEv,_ZThn24_N6G123333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G123333barEv,_ZTv0_n20_N6G123333barEv)();
extern void ABISELECT(_ZThn48_N6G123333barEv,_ZThn24_N6G123333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G123333fooEv,_ZTv0_n12_N6G123333fooEv)();
extern void ABISELECT(_ZThn64_N6G123333fooEv,_ZThn32_N6G123333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G123333barEv,_ZTv0_n16_N6G123333barEv)();
extern void ABISELECT(_ZThn64_N6G123333barEv,_ZThn32_N6G123333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G12333[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G12333[0]),
  (VTBL_ENTRY)&_ZN6G123333fooEv,
  (VTBL_ENTRY)&_ZN6G123333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G12333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123333barEv,_ZTv0_n16_N6G123333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G12333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G123333fooEv,_ZTv0_n12_N6G123333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G12333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123333fooEv,_ZTv0_n16_N6G123333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G123333barEv,_ZTv0_n20_N6G123333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G12333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G123333fooEv,_ZTv0_n12_N6G123333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G123333barEv,_ZTv0_n16_N6G123333barEv),
};
extern VTBL_ENTRY _ZTV6G12333[];
extern void _ZN3E123barEv();
static  VTBL_ENTRY _tg__ZTV3E12__6G12333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3E123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3E12__6G12333[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G12333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G12333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G12333[] = {
  {&(_ZTV6G12333[6]),  6,30},
  {&(_ZTV6G12333[12]),  12,30},
  {&(_ZTV6G12333[16]),  16,30},
  {&(_ZTV6G12333[22]),  22,30},
  {&(_ZTV6G12333[28]),  28,30},
  {&(_tg__ZTV3E12__6G12333[3]),  3,4},
  {&(_tg__ZTV3AA1__3E12__6G12333[3]),  3,4},
  {&(_tg__ZTV3F33__6G12333[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G12333[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G12333[];
extern  VTBL_ENTRY _ZTV6G12333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G12333[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G123333barEv,_ZTv0_n20_N6G123333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G123333barEv,_ZThn24_N6G123333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G123333fooEv,_ZTv0_n16_N6G123333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G123333fooEv,_ZThn24_N6G123333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G123333fooEv,_ZTv0_n12_N6G123333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G123333fooEv,_ZThn32_N6G123333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G123333fooEv,_ZThn16_N6G123333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G123333barEv,_ZTv0_n16_N6G123333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G123333barEv,_ZThn32_N6G123333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G123333barEv,_ZThn8_N6G123333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G12333 = {  "G12333", // class name
  bases_G12333, 4,
  &(vtc_G12333[0]), // expected_vtbl_contents
  &(vtt_G12333[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G12333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G12333),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G12333),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13111  : virtual E13 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G131113fooEv
  ~G13111(); // tgen
  G13111(); // tgen
};
//SIG(1 G13111) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC3 v1 Fi} v1 Fi}


void  G13111 ::foo(){vfunc_called(this, "_ZN6G131113fooEv");}
G13111 ::~G13111(){ note_dtor("G13111", this);} // tgen
G13111 ::G13111(){ note_ctor("G13111", this);} // tgen

static void Test_G13111()
{
  extern Class_Descriptor cd_G13111;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G13111, buf);
    G13111 *dp, &lv = *(dp=new (buf) G13111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G13111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13111)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13111");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(32,16), "G13111");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13111");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G13111");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13111.pg");
    test_class_info(&lv, &cd_G13111);
    dp->~G13111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13111(Test_G13111, "G13111", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G13111C1Ev();
extern void _ZN6G13111D1Ev();
Name_Map name_map_G13111[] = {
  NSPAIR(_ZN6G13111C1Ev),
  NSPAIR(_ZN6G13111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G13111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13111[];
extern void _ZN6G131113fooEv();
extern void ABISELECT(_ZTv0_n32_N6G131113fooEv,_ZTv0_n16_N6G131113fooEv)();
extern void ABISELECT(_ZThn16_N6G131113fooEv,_ZThn8_N6G131113fooEv)() __attribute__((weak));
extern void _ZN3E133barEv();
extern void ABISELECT(_ZTv0_n24_N6G131113fooEv,_ZTv0_n12_N6G131113fooEv)();
extern void ABISELECT(_ZThn32_N6G131113fooEv,_ZThn16_N6G131113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G131113fooEv,_ZTv0_n16_N6G131113fooEv)();
extern void ABISELECT(_ZThn48_N6G131113fooEv,_ZThn24_N6G131113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13111[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13111[0]),
  (VTBL_ENTRY)&_ZN6G131113fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131113fooEv,_ZTv0_n16_N6G131113fooEv),
  (VTBL_ENTRY)&_ZN3E133barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G131113fooEv,_ZTv0_n12_N6G131113fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131113fooEv,_ZTv0_n16_N6G131113fooEv),
};
extern VTBL_ENTRY _ZTV6G13111[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G13111[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G13111[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G13111[] = {
  {&(_ZTV6G13111[5]),  5,22},
  {&(_ZTV6G13111[11]),  11,22},
  {&(_ZTV6G13111[16]),  16,22},
  {&(_ZTV6G13111[21]),  21,22},
  {&(_tg__ZTV3E13__6G13111[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13111[3]),  3,4},
  {&(_tg__ZTV3F11__6G13111[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G13111[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13111[];
extern  VTBL_ENTRY _ZTV6G13111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13111[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G131113fooEv,_ZTv0_n12_N6G131113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G131113fooEv,_ZThn16_N6G131113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G131113fooEv,_ZTv0_n16_N6G131113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G131113fooEv,_ZThn24_N6G131113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G131113fooEv,_ZThn8_N6G131113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13111 = {  "G13111", // class name
  bases_G13111, 3,
  &(vtc_G13111[0]), // expected_vtbl_contents
  &(vtt_G13111[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G13111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13111),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13111),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13113  : virtual E13 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G131133fooEv
  virtual void  bar(); // _ZN6G131133barEv
  ~G13113(); // tgen
  G13113(); // tgen
};
//SIG(1 G13113) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC3 v1 Fi} v1 v2 Fi}


void  G13113 ::foo(){vfunc_called(this, "_ZN6G131133fooEv");}
void  G13113 ::bar(){vfunc_called(this, "_ZN6G131133barEv");}
G13113 ::~G13113(){ note_dtor("G13113", this);} // tgen
G13113 ::G13113(){ note_ctor("G13113", this);} // tgen

static void Test_G13113()
{
  extern Class_Descriptor cd_G13113;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G13113, buf);
    G13113 *dp, &lv = *(dp=new (buf) G13113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G13113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13113)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13113");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(32,16), "G13113");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13113");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G13113");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13113.pg");
    test_class_info(&lv, &cd_G13113);
    dp->~G13113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13113(Test_G13113, "G13113", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G13113C1Ev();
extern void _ZN6G13113D1Ev();
Name_Map name_map_G13113[] = {
  NSPAIR(_ZN6G13113C1Ev),
  NSPAIR(_ZN6G13113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G13113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13113[];
extern void _ZN6G131133fooEv();
extern void _ZN6G131133barEv();
extern void ABISELECT(_ZTv0_n32_N6G131133fooEv,_ZTv0_n16_N6G131133fooEv)();
extern void ABISELECT(_ZThn16_N6G131133fooEv,_ZThn8_N6G131133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G131133barEv,_ZTv0_n20_N6G131133barEv)();
extern void ABISELECT(_ZThn16_N6G131133barEv,_ZThn8_N6G131133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G131133fooEv,_ZTv0_n12_N6G131133fooEv)();
extern void ABISELECT(_ZThn32_N6G131133fooEv,_ZThn16_N6G131133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G131133fooEv,_ZTv0_n16_N6G131133fooEv)();
extern void ABISELECT(_ZThn48_N6G131133fooEv,_ZThn24_N6G131133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13113[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13113[0]),
  (VTBL_ENTRY)&_ZN6G131133fooEv,
  (VTBL_ENTRY)&_ZN6G131133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131133fooEv,_ZTv0_n16_N6G131133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G131133barEv,_ZTv0_n20_N6G131133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G131133fooEv,_ZTv0_n12_N6G131133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131133fooEv,_ZTv0_n16_N6G131133fooEv),
};
extern VTBL_ENTRY _ZTV6G13113[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G13113[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G13113[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G13113[] = {
  {&(_ZTV6G13113[5]),  5,23},
  {&(_ZTV6G13113[12]),  12,23},
  {&(_ZTV6G13113[17]),  17,23},
  {&(_ZTV6G13113[22]),  22,23},
  {&(_tg__ZTV3E13__6G13113[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13113[3]),  3,4},
  {&(_tg__ZTV3F11__6G13113[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G13113[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13113[];
extern  VTBL_ENTRY _ZTV6G13113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13113[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G131133fooEv,_ZTv0_n12_N6G131133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G131133fooEv,_ZThn16_N6G131133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G131133barEv,_ZTv0_n20_N6G131133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G131133barEv,_ZThn8_N6G131133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G131133fooEv,_ZTv0_n16_N6G131133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G131133fooEv,_ZThn24_N6G131133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G131133fooEv,_ZThn8_N6G131133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13113 = {  "G13113", // class name
  bases_G13113, 3,
  &(vtc_G13113[0]), // expected_vtbl_contents
  &(vtt_G13113[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G13113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13113),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13113),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13123  : virtual E13 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G131233fooEv
  virtual void  bar(); // _ZN6G131233barEv
  ~G13123(); // tgen
  G13123(); // tgen
};
//SIG(1 G13123) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC3 v2 Fi} v1 v2 Fi}


void  G13123 ::foo(){vfunc_called(this, "_ZN6G131233fooEv");}
void  G13123 ::bar(){vfunc_called(this, "_ZN6G131233barEv");}
G13123 ::~G13123(){ note_dtor("G13123", this);} // tgen
G13123 ::G13123(){ note_ctor("G13123", this);} // tgen

static void Test_G13123()
{
  extern Class_Descriptor cd_G13123;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G13123, buf);
    G13123 *dp, &lv = *(dp=new (buf) G13123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G13123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13123)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13123");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(32,16), "G13123");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13123");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G13123");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13123.pg");
    test_class_info(&lv, &cd_G13123);
    dp->~G13123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13123(Test_G13123, "G13123", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G13123C1Ev();
extern void _ZN6G13123D1Ev();
Name_Map name_map_G13123[] = {
  NSPAIR(_ZN6G13123C1Ev),
  NSPAIR(_ZN6G13123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G13123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13123[];
extern void _ZN6G131233fooEv();
extern void _ZN6G131233barEv();
extern void ABISELECT(_ZTv0_n32_N6G131233fooEv,_ZTv0_n16_N6G131233fooEv)();
extern void ABISELECT(_ZThn16_N6G131233fooEv,_ZThn8_N6G131233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G131233barEv,_ZTv0_n20_N6G131233barEv)();
extern void ABISELECT(_ZThn16_N6G131233barEv,_ZThn8_N6G131233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G131233fooEv,_ZTv0_n12_N6G131233fooEv)();
extern void ABISELECT(_ZThn32_N6G131233fooEv,_ZThn16_N6G131233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G131233barEv,_ZTv0_n16_N6G131233barEv)();
extern void ABISELECT(_ZThn48_N6G131233barEv,_ZThn24_N6G131233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13123[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13123[0]),
  (VTBL_ENTRY)&_ZN6G131233fooEv,
  (VTBL_ENTRY)&_ZN6G131233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131233fooEv,_ZTv0_n16_N6G131233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G131233barEv,_ZTv0_n20_N6G131233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G131233fooEv,_ZTv0_n12_N6G131233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131233barEv,_ZTv0_n16_N6G131233barEv),
};
extern VTBL_ENTRY _ZTV6G13123[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13123[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G13123[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G13123[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G13123[] = {
  {&(_ZTV6G13123[5]),  5,23},
  {&(_ZTV6G13123[12]),  12,23},
  {&(_ZTV6G13123[17]),  17,23},
  {&(_ZTV6G13123[22]),  22,23},
  {&(_tg__ZTV3E13__6G13123[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13123[3]),  3,4},
  {&(_tg__ZTV3F12__6G13123[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G13123[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13123[];
extern  VTBL_ENTRY _ZTV6G13123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13123[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G131233barEv,_ZTv0_n16_N6G131233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G131233barEv,_ZThn24_N6G131233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G131233fooEv,_ZTv0_n12_N6G131233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G131233fooEv,_ZThn16_N6G131233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G131233barEv,_ZTv0_n20_N6G131233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G131233barEv,_ZThn8_N6G131233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G131233fooEv,_ZTv0_n16_N6G131233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G131233fooEv,_ZThn8_N6G131233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13123 = {  "G13123", // class name
  bases_G13123, 3,
  &(vtc_G13123[0]), // expected_vtbl_contents
  &(vtt_G13123[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G13123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13123),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13123),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13133  : virtual E13 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G131333fooEv
  virtual void  bar(); // _ZN6G131333barEv
  ~G13133(); // tgen
  G13133(); // tgen
};
//SIG(1 G13133) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC3 v1 v2 Fi} v1 v2 Fi}


void  G13133 ::foo(){vfunc_called(this, "_ZN6G131333fooEv");}
void  G13133 ::bar(){vfunc_called(this, "_ZN6G131333barEv");}
G13133 ::~G13133(){ note_dtor("G13133", this);} // tgen
G13133 ::G13133(){ note_ctor("G13133", this);} // tgen

static void Test_G13133()
{
  extern Class_Descriptor cd_G13133;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G13133, buf);
    G13133 *dp, &lv = *(dp=new (buf) G13133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G13133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13133)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13133");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(32,16), "G13133");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13133");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G13133");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13133.pg");
    test_class_info(&lv, &cd_G13133);
    dp->~G13133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13133(Test_G13133, "G13133", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G13133C1Ev();
extern void _ZN6G13133D1Ev();
Name_Map name_map_G13133[] = {
  NSPAIR(_ZN6G13133C1Ev),
  NSPAIR(_ZN6G13133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G13133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13133[];
extern void _ZN6G131333fooEv();
extern void _ZN6G131333barEv();
extern void ABISELECT(_ZTv0_n32_N6G131333fooEv,_ZTv0_n16_N6G131333fooEv)();
extern void ABISELECT(_ZThn16_N6G131333fooEv,_ZThn8_N6G131333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G131333barEv,_ZTv0_n20_N6G131333barEv)();
extern void ABISELECT(_ZThn16_N6G131333barEv,_ZThn8_N6G131333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G131333fooEv,_ZTv0_n12_N6G131333fooEv)();
extern void ABISELECT(_ZThn32_N6G131333fooEv,_ZThn16_N6G131333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G131333fooEv,_ZTv0_n16_N6G131333fooEv)();
extern void ABISELECT(_ZThn48_N6G131333fooEv,_ZThn24_N6G131333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G131333barEv,_ZTv0_n20_N6G131333barEv)();
extern void ABISELECT(_ZThn48_N6G131333barEv,_ZThn24_N6G131333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13133[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13133[0]),
  (VTBL_ENTRY)&_ZN6G131333fooEv,
  (VTBL_ENTRY)&_ZN6G131333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131333fooEv,_ZTv0_n16_N6G131333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G131333barEv,_ZTv0_n20_N6G131333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G131333fooEv,_ZTv0_n12_N6G131333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G131333fooEv,_ZTv0_n16_N6G131333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G131333barEv,_ZTv0_n20_N6G131333barEv),
};
extern VTBL_ENTRY _ZTV6G13133[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G13133[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G13133[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G13133[] = {
  {&(_ZTV6G13133[5]),  5,25},
  {&(_ZTV6G13133[12]),  12,25},
  {&(_ZTV6G13133[17]),  17,25},
  {&(_ZTV6G13133[23]),  23,25},
  {&(_tg__ZTV3E13__6G13133[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13133[3]),  3,4},
  {&(_tg__ZTV3F13__6G13133[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G13133[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13133[];
extern  VTBL_ENTRY _ZTV6G13133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13133[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G131333fooEv,_ZTv0_n12_N6G131333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G131333fooEv,_ZThn16_N6G131333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G131333barEv,_ZTv0_n20_N6G131333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G131333barEv,_ZThn24_N6G131333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G131333barEv,_ZThn8_N6G131333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G131333fooEv,_ZTv0_n16_N6G131333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G131333fooEv,_ZThn24_N6G131333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G131333fooEv,_ZThn8_N6G131333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13133 = {  "G13133", // class name
  bases_G13133, 3,
  &(vtc_G13133[0]), // expected_vtbl_contents
  &(vtt_G13133[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G13133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13133),25, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13133),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13213  : virtual E13 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G132133fooEv
  virtual void  bar(); // _ZN6G132133barEv
  ~G13213(); // tgen
  G13213(); // tgen
};
//SIG(1 G13213) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC5{ v2 Fi} v1 Fi} v1 v2 Fi}


void  G13213 ::foo(){vfunc_called(this, "_ZN6G132133fooEv");}
void  G13213 ::bar(){vfunc_called(this, "_ZN6G132133barEv");}
G13213 ::~G13213(){ note_dtor("G13213", this);} // tgen
G13213 ::G13213(){ note_ctor("G13213", this);} // tgen

static void Test_G13213()
{
  extern Class_Descriptor cd_G13213;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G13213, buf);
    G13213 *dp, &lv = *(dp=new (buf) G13213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G13213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13213)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13213");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13213");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(64,32), "G13213");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G13213");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13213.pg");
    test_class_info(&lv, &cd_G13213);
    dp->~G13213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13213(Test_G13213, "G13213", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G13213C1Ev();
extern void _ZN6G13213D1Ev();
Name_Map name_map_G13213[] = {
  NSPAIR(_ZN6G13213C1Ev),
  NSPAIR(_ZN6G13213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G13213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13213[];
extern void _ZN6G132133fooEv();
extern void _ZN6G132133barEv();
extern void ABISELECT(_ZTv0_n32_N6G132133fooEv,_ZTv0_n16_N6G132133fooEv)();
extern void ABISELECT(_ZThn16_N6G132133fooEv,_ZThn8_N6G132133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G132133barEv,_ZTv0_n20_N6G132133barEv)();
extern void ABISELECT(_ZThn16_N6G132133barEv,_ZThn8_N6G132133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G132133fooEv,_ZTv0_n12_N6G132133fooEv)();
extern void ABISELECT(_ZThn32_N6G132133fooEv,_ZThn16_N6G132133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G132133fooEv,_ZTv0_n16_N6G132133fooEv)();
extern void ABISELECT(_ZThn48_N6G132133fooEv,_ZThn24_N6G132133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G132133barEv,_ZTv0_n12_N6G132133barEv)();
extern void ABISELECT(_ZThn64_N6G132133barEv,_ZThn32_N6G132133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13213[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13213[0]),
  (VTBL_ENTRY)&_ZN6G132133fooEv,
  (VTBL_ENTRY)&_ZN6G132133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G132133fooEv,_ZTv0_n16_N6G132133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G132133barEv,_ZTv0_n20_N6G132133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G132133fooEv,_ZTv0_n12_N6G132133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G132133fooEv,_ZTv0_n16_N6G132133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G13213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G132133barEv,_ZTv0_n12_N6G132133barEv),
};
extern VTBL_ENTRY _ZTV6G13213[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13213[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G13213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G13213[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G13213[] = {
  {&(_ZTV6G13213[6]),  6,28},
  {&(_ZTV6G13213[13]),  13,28},
  {&(_ZTV6G13213[18]),  18,28},
  {&(_ZTV6G13213[23]),  23,28},
  {&(_ZTV6G13213[27]),  27,28},
  {&(_tg__ZTV3E13__6G13213[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13213[3]),  3,4},
  {&(_tg__ZTV3F21__6G13213[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G13213[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13213[];
extern  VTBL_ENTRY _ZTV6G13213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13213[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G132133barEv,_ZTv0_n12_N6G132133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G132133barEv,_ZThn32_N6G132133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G132133fooEv,_ZTv0_n12_N6G132133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G132133fooEv,_ZThn16_N6G132133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G132133barEv,_ZTv0_n20_N6G132133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G132133barEv,_ZThn8_N6G132133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G132133fooEv,_ZTv0_n16_N6G132133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G132133fooEv,_ZThn24_N6G132133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G132133fooEv,_ZThn8_N6G132133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13213 = {  "G13213", // class name
  bases_G13213, 4,
  &(vtc_G13213[0]), // expected_vtbl_contents
  &(vtt_G13213[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G13213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13213),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13213),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13222  : virtual E13 , virtual F22 {
  int pg;
  virtual void  bar(); // _ZN6G132223barEv
  ~G13222(); // tgen
  G13222(); // tgen
};
//SIG(1 G13222) C1{ VBC2{ VBC3{ v2 Fi} v2 v1 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 Fi}


void  G13222 ::bar(){vfunc_called(this, "_ZN6G132223barEv");}
G13222 ::~G13222(){ note_dtor("G13222", this);} // tgen
G13222 ::G13222(){ note_ctor("G13222", this);} // tgen

static void Test_G13222()
{
  extern Class_Descriptor cd_G13222;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G13222, buf);
    G13222 *dp, &lv = *(dp=new (buf) G13222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G13222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13222)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13222");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13222");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(64,32), "G13222");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G13222");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13222.pg");
    test_class_info(&lv, &cd_G13222);
    dp->~G13222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13222(Test_G13222, "G13222", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G13222C1Ev();
extern void _ZN6G13222D1Ev();
Name_Map name_map_G13222[] = {
  NSPAIR(_ZN6G13222C1Ev),
  NSPAIR(_ZN6G13222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G13222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13222[];
extern void _ZN6G132223barEv();
extern void _ZN3E133fooEv();
extern void ABISELECT(_ZTv0_n40_N6G132223barEv,_ZTv0_n20_N6G132223barEv)();
extern void ABISELECT(_ZThn16_N6G132223barEv,_ZThn8_N6G132223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G132223barEv,_ZTv0_n16_N6G132223barEv)();
extern void ABISELECT(_ZThn48_N6G132223barEv,_ZThn24_N6G132223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G132223barEv,_ZTv0_n12_N6G132223barEv)();
extern void ABISELECT(_ZThn64_N6G132223barEv,_ZThn32_N6G132223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13222[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13222[0]),
  (VTBL_ENTRY)&_ZN6G132223barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13222[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G132223barEv,_ZTv0_n20_N6G132223barEv),
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G132223barEv,_ZTv0_n16_N6G132223barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G13222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G132223barEv,_ZTv0_n12_N6G132223barEv),
};
extern VTBL_ENTRY _ZTV6G13222[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13222[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G13222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G13222[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G13222[] = {
  {&(_ZTV6G13222[6]),  6,27},
  {&(_ZTV6G13222[12]),  12,27},
  {&(_ZTV6G13222[17]),  17,27},
  {&(_ZTV6G13222[22]),  22,27},
  {&(_ZTV6G13222[26]),  26,27},
  {&(_tg__ZTV3E13__6G13222[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13222[3]),  3,4},
  {&(_tg__ZTV3F22__6G13222[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G13222[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13222[];
extern  VTBL_ENTRY _ZTV6G13222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13222[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G132223barEv,_ZTv0_n12_N6G132223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G132223barEv,_ZThn32_N6G132223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G132223barEv,_ZTv0_n16_N6G132223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G132223barEv,_ZThn24_N6G132223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G132223barEv,_ZTv0_n20_N6G132223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G132223barEv,_ZThn8_N6G132223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13222 = {  "G13222", // class name
  bases_G13222, 4,
  &(vtc_G13222[0]), // expected_vtbl_contents
  &(vtt_G13222[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G13222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13222),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13222),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13223  : virtual E13 , virtual F22 {
  int pg;
  virtual void  foo(); // _ZN6G132233fooEv
  virtual void  bar(); // _ZN6G132233barEv
  ~G13223(); // tgen
  G13223(); // tgen
};
//SIG(1 G13223) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC5{ v2 Fi} v2 Fi} v1 v2 Fi}


void  G13223 ::foo(){vfunc_called(this, "_ZN6G132233fooEv");}
void  G13223 ::bar(){vfunc_called(this, "_ZN6G132233barEv");}
G13223 ::~G13223(){ note_dtor("G13223", this);} // tgen
G13223 ::G13223(){ note_ctor("G13223", this);} // tgen

static void Test_G13223()
{
  extern Class_Descriptor cd_G13223;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G13223, buf);
    G13223 *dp, &lv = *(dp=new (buf) G13223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G13223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13223)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13223");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13223");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(64,32), "G13223");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G13223");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13223.pg");
    test_class_info(&lv, &cd_G13223);
    dp->~G13223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13223(Test_G13223, "G13223", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G13223C1Ev();
extern void _ZN6G13223D1Ev();
Name_Map name_map_G13223[] = {
  NSPAIR(_ZN6G13223C1Ev),
  NSPAIR(_ZN6G13223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G13223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13223[];
extern void _ZN6G132233fooEv();
extern void _ZN6G132233barEv();
extern void ABISELECT(_ZTv0_n32_N6G132233fooEv,_ZTv0_n16_N6G132233fooEv)();
extern void ABISELECT(_ZThn16_N6G132233fooEv,_ZThn8_N6G132233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G132233barEv,_ZTv0_n20_N6G132233barEv)();
extern void ABISELECT(_ZThn16_N6G132233barEv,_ZThn8_N6G132233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G132233fooEv,_ZTv0_n12_N6G132233fooEv)();
extern void ABISELECT(_ZThn32_N6G132233fooEv,_ZThn16_N6G132233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G132233barEv,_ZTv0_n16_N6G132233barEv)();
extern void ABISELECT(_ZThn48_N6G132233barEv,_ZThn24_N6G132233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G132233barEv,_ZTv0_n12_N6G132233barEv)();
extern void ABISELECT(_ZThn64_N6G132233barEv,_ZThn32_N6G132233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13223[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13223[0]),
  (VTBL_ENTRY)&_ZN6G132233fooEv,
  (VTBL_ENTRY)&_ZN6G132233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G132233fooEv,_ZTv0_n16_N6G132233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G132233barEv,_ZTv0_n20_N6G132233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G132233fooEv,_ZTv0_n12_N6G132233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G132233barEv,_ZTv0_n16_N6G132233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G13223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G132233barEv,_ZTv0_n12_N6G132233barEv),
};
extern VTBL_ENTRY _ZTV6G13223[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13223[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G13223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
extern void ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G13223[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G13223[] = {
  {&(_ZTV6G13223[6]),  6,28},
  {&(_ZTV6G13223[13]),  13,28},
  {&(_ZTV6G13223[18]),  18,28},
  {&(_ZTV6G13223[23]),  23,28},
  {&(_ZTV6G13223[27]),  27,28},
  {&(_tg__ZTV3E13__6G13223[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13223[3]),  3,4},
  {&(_tg__ZTV3F22__6G13223[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G13223[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13223[];
extern  VTBL_ENTRY _ZTV6G13223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13223[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F223barEv,_ZThn8_N3F223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G132233barEv,_ZTv0_n12_N6G132233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G132233barEv,_ZThn32_N6G132233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G132233barEv,_ZTv0_n16_N6G132233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G132233barEv,_ZThn24_N6G132233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G132233fooEv,_ZTv0_n12_N6G132233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G132233fooEv,_ZThn16_N6G132233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G132233barEv,_ZTv0_n20_N6G132233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G132233barEv,_ZThn8_N6G132233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G132233fooEv,_ZTv0_n16_N6G132233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G132233fooEv,_ZThn8_N6G132233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13223 = {  "G13223", // class name
  bases_G13223, 4,
  &(vtc_G13223[0]), // expected_vtbl_contents
  &(vtt_G13223[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G13223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13223),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13223),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13233  : virtual E13 , virtual F23 {
  int pg;
  virtual void  foo(); // _ZN6G132333fooEv
  virtual void  bar(); // _ZN6G132333barEv
  ~G13233(); // tgen
  G13233(); // tgen
};
//SIG(1 G13233) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC5{ v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G13233 ::foo(){vfunc_called(this, "_ZN6G132333fooEv");}
void  G13233 ::bar(){vfunc_called(this, "_ZN6G132333barEv");}
G13233 ::~G13233(){ note_dtor("G13233", this);} // tgen
G13233 ::G13233(){ note_ctor("G13233", this);} // tgen

static void Test_G13233()
{
  extern Class_Descriptor cd_G13233;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G13233, buf);
    G13233 *dp, &lv = *(dp=new (buf) G13233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G13233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13233)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13233");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13233");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(64,32), "G13233");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G13233");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13233.pg");
    test_class_info(&lv, &cd_G13233);
    dp->~G13233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13233(Test_G13233, "G13233", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G13233C1Ev();
extern void _ZN6G13233D1Ev();
Name_Map name_map_G13233[] = {
  NSPAIR(_ZN6G13233C1Ev),
  NSPAIR(_ZN6G13233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G13233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13233[];
extern void _ZN6G132333fooEv();
extern void _ZN6G132333barEv();
extern void ABISELECT(_ZTv0_n32_N6G132333fooEv,_ZTv0_n16_N6G132333fooEv)();
extern void ABISELECT(_ZThn16_N6G132333fooEv,_ZThn8_N6G132333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G132333barEv,_ZTv0_n20_N6G132333barEv)();
extern void ABISELECT(_ZThn16_N6G132333barEv,_ZThn8_N6G132333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G132333fooEv,_ZTv0_n12_N6G132333fooEv)();
extern void ABISELECT(_ZThn32_N6G132333fooEv,_ZThn16_N6G132333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G132333fooEv,_ZTv0_n16_N6G132333fooEv)();
extern void ABISELECT(_ZThn48_N6G132333fooEv,_ZThn24_N6G132333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G132333barEv,_ZTv0_n20_N6G132333barEv)();
extern void ABISELECT(_ZThn48_N6G132333barEv,_ZThn24_N6G132333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G132333barEv,_ZTv0_n12_N6G132333barEv)();
extern void ABISELECT(_ZThn64_N6G132333barEv,_ZThn32_N6G132333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13233[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13233[0]),
  (VTBL_ENTRY)&_ZN6G132333fooEv,
  (VTBL_ENTRY)&_ZN6G132333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G132333fooEv,_ZTv0_n16_N6G132333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G132333barEv,_ZTv0_n20_N6G132333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G132333fooEv,_ZTv0_n12_N6G132333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G132333fooEv,_ZTv0_n16_N6G132333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G132333barEv,_ZTv0_n20_N6G132333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G13233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G132333barEv,_ZTv0_n12_N6G132333barEv),
};
extern VTBL_ENTRY _ZTV6G13233[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13233[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G13233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
extern void ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G13233[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G13233[] = {
  {&(_ZTV6G13233[6]),  6,30},
  {&(_ZTV6G13233[13]),  13,30},
  {&(_ZTV6G13233[18]),  18,30},
  {&(_ZTV6G13233[24]),  24,30},
  {&(_ZTV6G13233[29]),  29,30},
  {&(_tg__ZTV3E13__6G13233[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13233[3]),  3,4},
  {&(_tg__ZTV3F23__6G13233[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G13233[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G13233[];
extern  VTBL_ENTRY _ZTV6G13233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13233[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F233barEv,_ZThn8_N3F233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G132333barEv,_ZTv0_n12_N6G132333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G132333barEv,_ZThn32_N6G132333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G132333fooEv,_ZTv0_n12_N6G132333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G132333fooEv,_ZThn16_N6G132333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G132333barEv,_ZTv0_n20_N6G132333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G132333barEv,_ZThn24_N6G132333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G132333barEv,_ZThn8_N6G132333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G132333fooEv,_ZTv0_n16_N6G132333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G132333fooEv,_ZThn24_N6G132333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G132333fooEv,_ZThn8_N6G132333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13233 = {  "G13233", // class name
  bases_G13233, 4,
  &(vtc_G13233[0]), // expected_vtbl_contents
  &(vtt_G13233[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G13233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13233),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13233),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13313  : virtual E13 , virtual F31 {
  int pg;
  virtual void  foo(); // _ZN6G133133fooEv
  virtual void  bar(); // _ZN6G133133barEv
  ~G13313(); // tgen
  G13313(); // tgen
};
//SIG(1 G13313) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 Fi} v1 v2 Fi}


void  G13313 ::foo(){vfunc_called(this, "_ZN6G133133fooEv");}
void  G13313 ::bar(){vfunc_called(this, "_ZN6G133133barEv");}
G13313 ::~G13313(){ note_dtor("G13313", this);} // tgen
G13313 ::G13313(){ note_ctor("G13313", this);} // tgen

static void Test_G13313()
{
  extern Class_Descriptor cd_G13313;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G13313, buf);
    G13313 *dp, &lv = *(dp=new (buf) G13313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G13313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13313)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13313");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13313");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G13313");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G13313");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13313.pg");
    test_class_info(&lv, &cd_G13313);
    dp->~G13313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13313(Test_G13313, "G13313", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G13313C1Ev();
extern void _ZN6G13313D1Ev();
Name_Map name_map_G13313[] = {
  NSPAIR(_ZN6G13313C1Ev),
  NSPAIR(_ZN6G13313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G13313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13313[];
extern void _ZN6G133133fooEv();
extern void _ZN6G133133barEv();
extern void ABISELECT(_ZTv0_n32_N6G133133fooEv,_ZTv0_n16_N6G133133fooEv)();
extern void ABISELECT(_ZThn16_N6G133133fooEv,_ZThn8_N6G133133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G133133barEv,_ZTv0_n20_N6G133133barEv)();
extern void ABISELECT(_ZThn16_N6G133133barEv,_ZThn8_N6G133133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G133133fooEv,_ZTv0_n12_N6G133133fooEv)();
extern void ABISELECT(_ZThn32_N6G133133fooEv,_ZThn16_N6G133133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G133133fooEv,_ZTv0_n16_N6G133133fooEv)();
extern void ABISELECT(_ZThn48_N6G133133fooEv,_ZThn24_N6G133133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G133133fooEv,_ZTv0_n12_N6G133133fooEv)();
extern void ABISELECT(_ZThn64_N6G133133fooEv,_ZThn32_N6G133133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G133133barEv,_ZTv0_n16_N6G133133barEv)();
extern void ABISELECT(_ZThn64_N6G133133barEv,_ZThn32_N6G133133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13313[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13313[0]),
  (VTBL_ENTRY)&_ZN6G133133fooEv,
  (VTBL_ENTRY)&_ZN6G133133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133133fooEv,_ZTv0_n16_N6G133133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G133133barEv,_ZTv0_n20_N6G133133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G133133fooEv,_ZTv0_n12_N6G133133fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133133fooEv,_ZTv0_n16_N6G133133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G13313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G133133fooEv,_ZTv0_n12_N6G133133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133133barEv,_ZTv0_n16_N6G133133barEv),
};
extern VTBL_ENTRY _ZTV6G13313[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13313[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G13313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G13313[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G13313[] = {
  {&(_ZTV6G13313[6]),  6,30},
  {&(_ZTV6G13313[13]),  13,30},
  {&(_ZTV6G13313[18]),  18,30},
  {&(_ZTV6G13313[23]),  23,30},
  {&(_ZTV6G13313[28]),  28,30},
  {&(_tg__ZTV3E13__6G13313[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13313[3]),  3,4},
  {&(_tg__ZTV3F31__6G13313[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G13313[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G13313[];
extern  VTBL_ENTRY _ZTV6G13313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13313[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G133133barEv,_ZTv0_n16_N6G133133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G133133barEv,_ZThn32_N6G133133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G133133fooEv,_ZTv0_n12_N6G133133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G133133fooEv,_ZThn32_N6G133133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G133133fooEv,_ZThn16_N6G133133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G133133barEv,_ZTv0_n20_N6G133133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G133133barEv,_ZThn8_N6G133133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G133133fooEv,_ZTv0_n16_N6G133133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G133133fooEv,_ZThn24_N6G133133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G133133fooEv,_ZThn8_N6G133133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13313 = {  "G13313", // class name
  bases_G13313, 4,
  &(vtc_G13313[0]), // expected_vtbl_contents
  &(vtt_G13313[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G13313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13313),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13313),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13323  : virtual E13 , virtual F32 {
  int pg;
  virtual void  foo(); // _ZN6G133233fooEv
  virtual void  bar(); // _ZN6G133233barEv
  ~G13323(); // tgen
  G13323(); // tgen
};
//SIG(1 G13323) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v2 Fi} v1 v2 Fi}


void  G13323 ::foo(){vfunc_called(this, "_ZN6G133233fooEv");}
void  G13323 ::bar(){vfunc_called(this, "_ZN6G133233barEv");}
G13323 ::~G13323(){ note_dtor("G13323", this);} // tgen
G13323 ::G13323(){ note_ctor("G13323", this);} // tgen

static void Test_G13323()
{
  extern Class_Descriptor cd_G13323;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G13323, buf);
    G13323 *dp, &lv = *(dp=new (buf) G13323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G13323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13323)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13323");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13323");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G13323");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G13323");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13323.pg");
    test_class_info(&lv, &cd_G13323);
    dp->~G13323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13323(Test_G13323, "G13323", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G13323C1Ev();
extern void _ZN6G13323D1Ev();
Name_Map name_map_G13323[] = {
  NSPAIR(_ZN6G13323C1Ev),
  NSPAIR(_ZN6G13323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G13323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13323[];
extern void _ZN6G133233fooEv();
extern void _ZN6G133233barEv();
extern void ABISELECT(_ZTv0_n32_N6G133233fooEv,_ZTv0_n16_N6G133233fooEv)();
extern void ABISELECT(_ZThn16_N6G133233fooEv,_ZThn8_N6G133233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G133233barEv,_ZTv0_n20_N6G133233barEv)();
extern void ABISELECT(_ZThn16_N6G133233barEv,_ZThn8_N6G133233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G133233fooEv,_ZTv0_n12_N6G133233fooEv)();
extern void ABISELECT(_ZThn32_N6G133233fooEv,_ZThn16_N6G133233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G133233barEv,_ZTv0_n16_N6G133233barEv)();
extern void ABISELECT(_ZThn48_N6G133233barEv,_ZThn24_N6G133233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G133233fooEv,_ZTv0_n12_N6G133233fooEv)();
extern void ABISELECT(_ZThn64_N6G133233fooEv,_ZThn32_N6G133233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G133233barEv,_ZTv0_n16_N6G133233barEv)();
extern void ABISELECT(_ZThn64_N6G133233barEv,_ZThn32_N6G133233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13323[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13323[0]),
  (VTBL_ENTRY)&_ZN6G133233fooEv,
  (VTBL_ENTRY)&_ZN6G133233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133233fooEv,_ZTv0_n16_N6G133233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G133233barEv,_ZTv0_n20_N6G133233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G133233fooEv,_ZTv0_n12_N6G133233fooEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133233barEv,_ZTv0_n16_N6G133233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G13323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G133233fooEv,_ZTv0_n12_N6G133233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133233barEv,_ZTv0_n16_N6G133233barEv),
};
extern VTBL_ENTRY _ZTV6G13323[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13323[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G13323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G13323[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G13323[] = {
  {&(_ZTV6G13323[6]),  6,30},
  {&(_ZTV6G13323[13]),  13,30},
  {&(_ZTV6G13323[18]),  18,30},
  {&(_ZTV6G13323[23]),  23,30},
  {&(_ZTV6G13323[28]),  28,30},
  {&(_tg__ZTV3E13__6G13323[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13323[3]),  3,4},
  {&(_tg__ZTV3F32__6G13323[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G13323[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G13323[];
extern  VTBL_ENTRY _ZTV6G13323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13323[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G133233barEv,_ZTv0_n16_N6G133233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G133233barEv,_ZThn32_N6G133233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G133233barEv,_ZThn24_N6G133233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G133233fooEv,_ZTv0_n12_N6G133233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G133233fooEv,_ZThn32_N6G133233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G133233fooEv,_ZThn16_N6G133233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G133233barEv,_ZTv0_n20_N6G133233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G133233barEv,_ZThn8_N6G133233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G133233fooEv,_ZTv0_n16_N6G133233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G133233fooEv,_ZThn8_N6G133233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13323 = {  "G13323", // class name
  bases_G13323, 4,
  &(vtc_G13323[0]), // expected_vtbl_contents
  &(vtt_G13323[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G13323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13323),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13323),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G13333  : virtual E13 , virtual F33 {
  int pg;
  virtual void  foo(); // _ZN6G133333fooEv
  virtual void  bar(); // _ZN6G133333barEv
  ~G13333(); // tgen
  G13333(); // tgen
};
//SIG(1 G13333) C1{ VBC2{ VBC3{ v1 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G13333 ::foo(){vfunc_called(this, "_ZN6G133333fooEv");}
void  G13333 ::bar(){vfunc_called(this, "_ZN6G133333barEv");}
G13333 ::~G13333(){ note_dtor("G13333", this);} // tgen
G13333 ::G13333(){ note_ctor("G13333", this);} // tgen

static void Test_G13333()
{
  extern Class_Descriptor cd_G13333;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G13333, buf);
    G13333 *dp, &lv = *(dp=new (buf) G13333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G13333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G13333)");
    check_base_class_offset(lv, (AA1*)(E13*), ABISELECT(32,16), "G13333");
    check_base_class_offset(lv, (E13*), ABISELECT(16,8), "G13333");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G13333");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G13333");
    check_field_offset(lv, pg, ABISELECT(8,4), "G13333.pg");
    test_class_info(&lv, &cd_G13333);
    dp->~G13333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG13333(Test_G13333, "G13333", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G13333C1Ev();
extern void _ZN6G13333D1Ev();
Name_Map name_map_G13333[] = {
  NSPAIR(_ZN6G13333C1Ev),
  NSPAIR(_ZN6G13333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_E13;
extern VTBL_ENTRY _ZTI3E13[];
extern  VTBL_ENTRY _ZTV3E13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E13[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G13333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA1,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E13,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G13333[];
extern void _ZN6G133333fooEv();
extern void _ZN6G133333barEv();
extern void ABISELECT(_ZTv0_n32_N6G133333fooEv,_ZTv0_n16_N6G133333fooEv)();
extern void ABISELECT(_ZThn16_N6G133333fooEv,_ZThn8_N6G133333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G133333barEv,_ZTv0_n20_N6G133333barEv)();
extern void ABISELECT(_ZThn16_N6G133333barEv,_ZThn8_N6G133333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G133333fooEv,_ZTv0_n12_N6G133333fooEv)();
extern void ABISELECT(_ZThn32_N6G133333fooEv,_ZThn16_N6G133333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G133333fooEv,_ZTv0_n16_N6G133333fooEv)();
extern void ABISELECT(_ZThn48_N6G133333fooEv,_ZThn24_N6G133333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G133333barEv,_ZTv0_n20_N6G133333barEv)();
extern void ABISELECT(_ZThn48_N6G133333barEv,_ZThn24_N6G133333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G133333fooEv,_ZTv0_n12_N6G133333fooEv)();
extern void ABISELECT(_ZThn64_N6G133333fooEv,_ZThn32_N6G133333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G133333barEv,_ZTv0_n16_N6G133333barEv)();
extern void ABISELECT(_ZThn64_N6G133333barEv,_ZThn32_N6G133333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G13333[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G13333[0]),
  (VTBL_ENTRY)&_ZN6G133333fooEv,
  (VTBL_ENTRY)&_ZN6G133333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G13333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133333fooEv,_ZTv0_n16_N6G133333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G133333barEv,_ZTv0_n20_N6G133333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G13333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G133333fooEv,_ZTv0_n12_N6G133333fooEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G13333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133333fooEv,_ZTv0_n16_N6G133333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G133333barEv,_ZTv0_n20_N6G133333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G13333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G133333fooEv,_ZTv0_n12_N6G133333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G133333barEv,_ZTv0_n16_N6G133333barEv),
};
extern VTBL_ENTRY _ZTV6G13333[];
extern void _ZN3E133fooEv();
extern void _ZN3E133barEv();
static  VTBL_ENTRY _tg__ZTV3E13__6G13333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&_ZN3E133fooEv,
  (VTBL_ENTRY)&_ZN3E133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv)();
extern void ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3E13__6G13333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv),
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G13333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G13333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G13333[] = {
  {&(_ZTV6G13333[6]),  6,32},
  {&(_ZTV6G13333[13]),  13,32},
  {&(_ZTV6G13333[18]),  18,32},
  {&(_ZTV6G13333[24]),  24,32},
  {&(_ZTV6G13333[30]),  30,32},
  {&(_tg__ZTV3E13__6G13333[3]),  3,5},
  {&(_tg__ZTV3AA1__3E13__6G13333[3]),  3,4},
  {&(_tg__ZTV3F33__6G13333[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G13333[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G13333[];
extern  VTBL_ENTRY _ZTV6G13333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G13333[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E133fooEv,_ZTv0_n12_N3E133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E133fooEv,_ZThn8_N3E133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G133333barEv,_ZTv0_n16_N6G133333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G133333barEv,_ZThn32_N6G133333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G133333fooEv,_ZTv0_n12_N6G133333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G133333fooEv,_ZThn32_N6G133333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G133333fooEv,_ZThn16_N6G133333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G133333barEv,_ZTv0_n20_N6G133333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G133333barEv,_ZThn24_N6G133333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G133333barEv,_ZThn8_N6G133333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G133333fooEv,_ZTv0_n16_N6G133333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G133333fooEv,_ZThn24_N6G133333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G133333fooEv,_ZThn8_N6G133333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G13333 = {  "G13333", // class name
  bases_G13333, 4,
  &(vtc_G13333[0]), // expected_vtbl_contents
  &(vtt_G13333[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G13333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G13333),32, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G13333),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21111  : virtual E21 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G211113fooEv
  ~G21111(); // tgen
  G21111(); // tgen
};
//SIG(1 G21111) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 Fi}


void  G21111 ::foo(){vfunc_called(this, "_ZN6G211113fooEv");}
G21111 ::~G21111(){ note_dtor("G21111", this);} // tgen
G21111 ::G21111(){ note_ctor("G21111", this);} // tgen

static void Test_G21111()
{
  extern Class_Descriptor cd_G21111;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G21111, buf);
    G21111 *dp, &lv = *(dp=new (buf) G21111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G21111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21111)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21111");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21111");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G21111");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G21111");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21111.pg");
    test_class_info(&lv, &cd_G21111);
    dp->~G21111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21111(Test_G21111, "G21111", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G21111C1Ev();
extern void _ZN6G21111D1Ev();
Name_Map name_map_G21111[] = {
  NSPAIR(_ZN6G21111C1Ev),
  NSPAIR(_ZN6G21111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G21111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21111[];
extern void _ZN6G211113fooEv();
extern void ABISELECT(_ZTv0_n32_N6G211113fooEv,_ZTv0_n16_N6G211113fooEv)();
extern void ABISELECT(_ZThn16_N6G211113fooEv,_ZThn8_N6G211113fooEv)() __attribute__((weak));
extern void _ZN3AA23barEv();
extern void ABISELECT(_ZTv0_n32_N6G211113fooEv,_ZTv0_n16_N6G211113fooEv)();
extern void ABISELECT(_ZThn48_N6G211113fooEv,_ZThn24_N6G211113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G211113fooEv,_ZTv0_n12_N6G211113fooEv)();
extern void ABISELECT(_ZThn64_N6G211113fooEv,_ZThn32_N6G211113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21111[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21111[0]),
  (VTBL_ENTRY)&_ZN6G211113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211113fooEv,_ZTv0_n16_N6G211113fooEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21111[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211113fooEv,_ZTv0_n16_N6G211113fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G21111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G211113fooEv,_ZTv0_n12_N6G211113fooEv),
};
extern VTBL_ENTRY _ZTV6G21111[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21111[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G21111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G21111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G21111[] = {
  {&(_ZTV6G21111[6]),  6,25},
  {&(_ZTV6G21111[11]),  11,25},
  {&(_ZTV6G21111[15]),  15,25},
  {&(_ZTV6G21111[20]),  20,25},
  {&(_ZTV6G21111[24]),  24,25},
  {&(_tg__ZTV3E21__6G21111[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21111[3]),  3,4},
  {&(_tg__ZTV3F11__6G21111[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G21111[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21111[];
extern  VTBL_ENTRY _ZTV6G21111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21111[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G211113fooEv,_ZTv0_n12_N6G211113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G211113fooEv,_ZThn32_N6G211113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G211113fooEv,_ZTv0_n16_N6G211113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G211113fooEv,_ZThn24_N6G211113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G211113fooEv,_ZThn8_N6G211113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21111 = {  "G21111", // class name
  bases_G21111, 4,
  &(vtc_G21111[0]), // expected_vtbl_contents
  &(vtt_G21111[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G21111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21111),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21111),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21113  : virtual E21 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G211133fooEv
  virtual void  bar(); // _ZN6G211133barEv
  ~G21113(); // tgen
  G21113(); // tgen
};
//SIG(1 G21113) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 v2 Fi}


void  G21113 ::foo(){vfunc_called(this, "_ZN6G211133fooEv");}
void  G21113 ::bar(){vfunc_called(this, "_ZN6G211133barEv");}
G21113 ::~G21113(){ note_dtor("G21113", this);} // tgen
G21113 ::G21113(){ note_ctor("G21113", this);} // tgen

static void Test_G21113()
{
  extern Class_Descriptor cd_G21113;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G21113, buf);
    G21113 *dp, &lv = *(dp=new (buf) G21113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G21113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21113)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21113");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21113");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G21113");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G21113");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21113.pg");
    test_class_info(&lv, &cd_G21113);
    dp->~G21113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21113(Test_G21113, "G21113", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G21113C1Ev();
extern void _ZN6G21113D1Ev();
Name_Map name_map_G21113[] = {
  NSPAIR(_ZN6G21113C1Ev),
  NSPAIR(_ZN6G21113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G21113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21113[];
extern void _ZN6G211133fooEv();
extern void _ZN6G211133barEv();
extern void ABISELECT(_ZTv0_n32_N6G211133fooEv,_ZTv0_n16_N6G211133fooEv)();
extern void ABISELECT(_ZThn16_N6G211133fooEv,_ZThn8_N6G211133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G211133barEv,_ZTv0_n12_N6G211133barEv)();
extern void ABISELECT(_ZThn32_N6G211133barEv,_ZThn16_N6G211133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G211133fooEv,_ZTv0_n16_N6G211133fooEv)();
extern void ABISELECT(_ZThn48_N6G211133fooEv,_ZThn24_N6G211133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G211133fooEv,_ZTv0_n12_N6G211133fooEv)();
extern void ABISELECT(_ZThn64_N6G211133fooEv,_ZThn32_N6G211133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21113[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21113[0]),
  (VTBL_ENTRY)&_ZN6G211133fooEv,
  (VTBL_ENTRY)&_ZN6G211133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211133fooEv,_ZTv0_n16_N6G211133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G211133barEv,_ZTv0_n12_N6G211133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211133fooEv,_ZTv0_n16_N6G211133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G21113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G211133fooEv,_ZTv0_n12_N6G211133fooEv),
};
extern VTBL_ENTRY _ZTV6G21113[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21113[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G21113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G21113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G21113[] = {
  {&(_ZTV6G21113[6]),  6,26},
  {&(_ZTV6G21113[12]),  12,26},
  {&(_ZTV6G21113[16]),  16,26},
  {&(_ZTV6G21113[21]),  21,26},
  {&(_ZTV6G21113[25]),  25,26},
  {&(_tg__ZTV3E21__6G21113[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21113[3]),  3,4},
  {&(_tg__ZTV3F11__6G21113[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G21113[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21113[];
extern  VTBL_ENTRY _ZTV6G21113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21113[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G211133fooEv,_ZTv0_n12_N6G211133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G211133fooEv,_ZThn32_N6G211133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G211133barEv,_ZTv0_n12_N6G211133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G211133barEv,_ZThn16_N6G211133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G211133fooEv,_ZTv0_n16_N6G211133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G211133fooEv,_ZThn24_N6G211133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G211133fooEv,_ZThn8_N6G211133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21113 = {  "G21113", // class name
  bases_G21113, 4,
  &(vtc_G21113[0]), // expected_vtbl_contents
  &(vtt_G21113[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G21113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21113),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21113),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21123  : virtual E21 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G211233fooEv
  virtual void  bar(); // _ZN6G211233barEv
  ~G21123(); // tgen
  G21123(); // tgen
};
//SIG(1 G21123) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v2 Fi} v1 v2 Fi}


void  G21123 ::foo(){vfunc_called(this, "_ZN6G211233fooEv");}
void  G21123 ::bar(){vfunc_called(this, "_ZN6G211233barEv");}
G21123 ::~G21123(){ note_dtor("G21123", this);} // tgen
G21123 ::G21123(){ note_ctor("G21123", this);} // tgen

static void Test_G21123()
{
  extern Class_Descriptor cd_G21123;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G21123, buf);
    G21123 *dp, &lv = *(dp=new (buf) G21123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G21123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21123)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21123");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21123");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(64,32), "G21123");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G21123");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21123.pg");
    test_class_info(&lv, &cd_G21123);
    dp->~G21123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21123(Test_G21123, "G21123", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G21123C1Ev();
extern void _ZN6G21123D1Ev();
Name_Map name_map_G21123[] = {
  NSPAIR(_ZN6G21123C1Ev),
  NSPAIR(_ZN6G21123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G21123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21123[];
extern void _ZN6G211233fooEv();
extern void _ZN6G211233barEv();
extern void ABISELECT(_ZTv0_n32_N6G211233fooEv,_ZTv0_n16_N6G211233fooEv)();
extern void ABISELECT(_ZThn16_N6G211233fooEv,_ZThn8_N6G211233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G211233barEv,_ZTv0_n12_N6G211233barEv)();
extern void ABISELECT(_ZThn32_N6G211233barEv,_ZThn16_N6G211233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G211233barEv,_ZTv0_n16_N6G211233barEv)();
extern void ABISELECT(_ZThn48_N6G211233barEv,_ZThn24_N6G211233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G211233fooEv,_ZTv0_n12_N6G211233fooEv)();
extern void ABISELECT(_ZThn64_N6G211233fooEv,_ZThn32_N6G211233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21123[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21123[0]),
  (VTBL_ENTRY)&_ZN6G211233fooEv,
  (VTBL_ENTRY)&_ZN6G211233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211233fooEv,_ZTv0_n16_N6G211233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G211233barEv,_ZTv0_n12_N6G211233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211233barEv,_ZTv0_n16_N6G211233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G21123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G211233fooEv,_ZTv0_n12_N6G211233fooEv),
};
extern VTBL_ENTRY _ZTV6G21123[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21123[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G21123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G21123[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G21123[] = {
  {&(_ZTV6G21123[6]),  6,26},
  {&(_ZTV6G21123[12]),  12,26},
  {&(_ZTV6G21123[16]),  16,26},
  {&(_ZTV6G21123[21]),  21,26},
  {&(_ZTV6G21123[25]),  25,26},
  {&(_tg__ZTV3E21__6G21123[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21123[3]),  3,4},
  {&(_tg__ZTV3F12__6G21123[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G21123[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21123[];
extern  VTBL_ENTRY _ZTV6G21123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21123[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G211233fooEv,_ZTv0_n12_N6G211233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G211233fooEv,_ZThn32_N6G211233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G211233barEv,_ZTv0_n16_N6G211233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G211233barEv,_ZThn24_N6G211233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G211233barEv,_ZTv0_n12_N6G211233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G211233barEv,_ZThn16_N6G211233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G211233fooEv,_ZTv0_n16_N6G211233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G211233fooEv,_ZThn8_N6G211233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21123 = {  "G21123", // class name
  bases_G21123, 4,
  &(vtc_G21123[0]), // expected_vtbl_contents
  &(vtt_G21123[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G21123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21123),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21123),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names108,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21133  : virtual E21 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G211333fooEv
  virtual void  bar(); // _ZN6G211333barEv
  ~G21133(); // tgen
  G21133(); // tgen
};
//SIG(1 G21133) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v1 v2 Fi} v1 v2 Fi}


void  G21133 ::foo(){vfunc_called(this, "_ZN6G211333fooEv");}
void  G21133 ::bar(){vfunc_called(this, "_ZN6G211333barEv");}
G21133 ::~G21133(){ note_dtor("G21133", this);} // tgen
G21133 ::G21133(){ note_ctor("G21133", this);} // tgen

static void Test_G21133()
{
  extern Class_Descriptor cd_G21133;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G21133, buf);
    G21133 *dp, &lv = *(dp=new (buf) G21133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G21133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21133)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21133");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21133");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(64,32), "G21133");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G21133");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21133.pg");
    test_class_info(&lv, &cd_G21133);
    dp->~G21133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21133(Test_G21133, "G21133", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G21133C1Ev();
extern void _ZN6G21133D1Ev();
Name_Map name_map_G21133[] = {
  NSPAIR(_ZN6G21133C1Ev),
  NSPAIR(_ZN6G21133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G21133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21133[];
extern void _ZN6G211333fooEv();
extern void _ZN6G211333barEv();
extern void ABISELECT(_ZTv0_n32_N6G211333fooEv,_ZTv0_n16_N6G211333fooEv)();
extern void ABISELECT(_ZThn16_N6G211333fooEv,_ZThn8_N6G211333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G211333barEv,_ZTv0_n12_N6G211333barEv)();
extern void ABISELECT(_ZThn32_N6G211333barEv,_ZThn16_N6G211333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G211333fooEv,_ZTv0_n16_N6G211333fooEv)();
extern void ABISELECT(_ZThn48_N6G211333fooEv,_ZThn24_N6G211333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G211333barEv,_ZTv0_n20_N6G211333barEv)();
extern void ABISELECT(_ZThn48_N6G211333barEv,_ZThn24_N6G211333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G211333fooEv,_ZTv0_n12_N6G211333fooEv)();
extern void ABISELECT(_ZThn64_N6G211333fooEv,_ZThn32_N6G211333fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21133[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21133[0]),
  (VTBL_ENTRY)&_ZN6G211333fooEv,
  (VTBL_ENTRY)&_ZN6G211333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211333fooEv,_ZTv0_n16_N6G211333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G211333barEv,_ZTv0_n12_N6G211333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G211333fooEv,_ZTv0_n16_N6G211333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G211333barEv,_ZTv0_n20_N6G211333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G21133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G211333fooEv,_ZTv0_n12_N6G211333fooEv),
};
extern VTBL_ENTRY _ZTV6G21133[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21133[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G21133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
extern void ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G21133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G21133[] = {
  {&(_ZTV6G21133[6]),  6,28},
  {&(_ZTV6G21133[12]),  12,28},
  {&(_ZTV6G21133[16]),  16,28},
  {&(_ZTV6G21133[22]),  22,28},
  {&(_ZTV6G21133[27]),  27,28},
  {&(_tg__ZTV3E21__6G21133[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21133[3]),  3,4},
  {&(_tg__ZTV3F13__6G21133[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G21133[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21133[];
extern  VTBL_ENTRY _ZTV6G21133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21133[];
static VTBL_ENTRY alt_thunk_names109[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G211333fooEv,_ZTv0_n12_N6G211333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G211333fooEv,_ZThn32_N6G211333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G211333barEv,_ZTv0_n20_N6G211333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G211333barEv,_ZThn24_N6G211333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G211333barEv,_ZTv0_n12_N6G211333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G211333barEv,_ZThn16_N6G211333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G211333fooEv,_ZTv0_n16_N6G211333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G211333fooEv,_ZThn24_N6G211333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G211333fooEv,_ZThn8_N6G211333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21133 = {  "G21133", // class name
  bases_G21133, 4,
  &(vtc_G21133[0]), // expected_vtbl_contents
  &(vtt_G21133[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G21133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21133),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21133),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names109,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21213  : virtual E21 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G212133fooEv
  virtual void  bar(); // _ZN6G212133barEv
  ~G21213(); // tgen
  G21213(); // tgen
};
//SIG(1 G21213) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC3 v1 Fi} v1 v2 Fi}


void  G21213 ::foo(){vfunc_called(this, "_ZN6G212133fooEv");}
void  G21213 ::bar(){vfunc_called(this, "_ZN6G212133barEv");}
G21213 ::~G21213(){ note_dtor("G21213", this);} // tgen
G21213 ::G21213(){ note_ctor("G21213", this);} // tgen

static void Test_G21213()
{
  extern Class_Descriptor cd_G21213;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G21213, buf);
    G21213 *dp, &lv = *(dp=new (buf) G21213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G21213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21213)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21213");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(32,16), "G21213");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21213");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G21213");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21213.pg");
    test_class_info(&lv, &cd_G21213);
    dp->~G21213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21213(Test_G21213, "G21213", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G21213C1Ev();
extern void _ZN6G21213D1Ev();
Name_Map name_map_G21213[] = {
  NSPAIR(_ZN6G21213C1Ev),
  NSPAIR(_ZN6G21213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G21213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21213[];
extern void _ZN6G212133fooEv();
extern void _ZN6G212133barEv();
extern void ABISELECT(_ZTv0_n32_N6G212133fooEv,_ZTv0_n16_N6G212133fooEv)();
extern void ABISELECT(_ZThn16_N6G212133fooEv,_ZThn8_N6G212133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G212133barEv,_ZTv0_n12_N6G212133barEv)();
extern void ABISELECT(_ZThn32_N6G212133barEv,_ZThn16_N6G212133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G212133fooEv,_ZTv0_n16_N6G212133fooEv)();
extern void ABISELECT(_ZThn48_N6G212133fooEv,_ZThn24_N6G212133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21213[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21213[0]),
  (VTBL_ENTRY)&_ZN6G212133fooEv,
  (VTBL_ENTRY)&_ZN6G212133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G212133fooEv,_ZTv0_n16_N6G212133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G212133barEv,_ZTv0_n12_N6G212133barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G212133fooEv,_ZTv0_n16_N6G212133fooEv),
};
extern VTBL_ENTRY _ZTV6G21213[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21213[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G21213[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G21213[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G21213[] = {
  {&(_ZTV6G21213[5]),  5,21},
  {&(_ZTV6G21213[11]),  11,21},
  {&(_ZTV6G21213[15]),  15,21},
  {&(_ZTV6G21213[20]),  20,21},
  {&(_tg__ZTV3E21__6G21213[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21213[3]),  3,4},
  {&(_tg__ZTV3F21__6G21213[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G21213[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21213[];
extern  VTBL_ENTRY _ZTV6G21213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21213[];
static VTBL_ENTRY alt_thunk_names110[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G212133barEv,_ZTv0_n12_N6G212133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G212133barEv,_ZThn16_N6G212133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G212133fooEv,_ZTv0_n16_N6G212133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G212133fooEv,_ZThn24_N6G212133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G212133fooEv,_ZThn8_N6G212133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21213 = {  "G21213", // class name
  bases_G21213, 3,
  &(vtc_G21213[0]), // expected_vtbl_contents
  &(vtt_G21213[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G21213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21213),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21213),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names110,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21222  : virtual E21 , virtual F22 {
  int pg;
  virtual void  bar(); // _ZN6G212223barEv
  ~G21222(); // tgen
  G21222(); // tgen
};
//SIG(1 G21222) C1{ VBC2{ VBC3{ v1 Fi} v2 Fi} VBC4{ VBC3 v1 Fi} v1 Fi}


void  G21222 ::bar(){vfunc_called(this, "_ZN6G212223barEv");}
G21222 ::~G21222(){ note_dtor("G21222", this);} // tgen
G21222 ::G21222(){ note_ctor("G21222", this);} // tgen

static void Test_G21222()
{
  extern Class_Descriptor cd_G21222;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G21222, buf);
    G21222 *dp, &lv = *(dp=new (buf) G21222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G21222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21222)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21222");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(32,16), "G21222");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21222");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G21222");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21222.pg");
    test_class_info(&lv, &cd_G21222);
    dp->~G21222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21222(Test_G21222, "G21222", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G21222C1Ev();
extern void _ZN6G21222D1Ev();
Name_Map name_map_G21222[] = {
  NSPAIR(_ZN6G21222C1Ev),
  NSPAIR(_ZN6G21222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G21222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21222[];
extern void _ZN6G212223barEv();
extern void _ZN3E213fooEv();
extern void ABISELECT(_ZTv0_n24_N6G212223barEv,_ZTv0_n12_N6G212223barEv)();
extern void ABISELECT(_ZThn32_N6G212223barEv,_ZThn16_N6G212223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G212223barEv,_ZTv0_n16_N6G212223barEv)();
extern void ABISELECT(_ZThn48_N6G212223barEv,_ZThn24_N6G212223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21222[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21222[0]),
  (VTBL_ENTRY)&_ZN6G212223barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21222[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G212223barEv,_ZTv0_n12_N6G212223barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G212223barEv,_ZTv0_n16_N6G212223barEv),
};
extern VTBL_ENTRY _ZTV6G21222[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21222[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G21222[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G21222[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G21222[] = {
  {&(_ZTV6G21222[5]),  5,20},
  {&(_ZTV6G21222[10]),  10,20},
  {&(_ZTV6G21222[14]),  14,20},
  {&(_ZTV6G21222[19]),  19,20},
  {&(_tg__ZTV3E21__6G21222[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21222[3]),  3,4},
  {&(_tg__ZTV3F22__6G21222[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G21222[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21222[];
extern  VTBL_ENTRY _ZTV6G21222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21222[];
static VTBL_ENTRY alt_thunk_names111[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G212223barEv,_ZTv0_n16_N6G212223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G212223barEv,_ZThn24_N6G212223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G212223barEv,_ZTv0_n12_N6G212223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G212223barEv,_ZThn16_N6G212223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21222 = {  "G21222", // class name
  bases_G21222, 3,
  &(vtc_G21222[0]), // expected_vtbl_contents
  &(vtt_G21222[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G21222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21222),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21222),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names111,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21223  : virtual E21 , virtual F22 {
  int pg;
  virtual void  foo(); // _ZN6G212233fooEv
  virtual void  bar(); // _ZN6G212233barEv
  ~G21223(); // tgen
  G21223(); // tgen
};
//SIG(1 G21223) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC3 v2 Fi} v1 v2 Fi}


void  G21223 ::foo(){vfunc_called(this, "_ZN6G212233fooEv");}
void  G21223 ::bar(){vfunc_called(this, "_ZN6G212233barEv");}
G21223 ::~G21223(){ note_dtor("G21223", this);} // tgen
G21223 ::G21223(){ note_ctor("G21223", this);} // tgen

static void Test_G21223()
{
  extern Class_Descriptor cd_G21223;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G21223, buf);
    G21223 *dp, &lv = *(dp=new (buf) G21223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G21223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21223)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21223");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(32,16), "G21223");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21223");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G21223");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21223.pg");
    test_class_info(&lv, &cd_G21223);
    dp->~G21223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21223(Test_G21223, "G21223", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G21223C1Ev();
extern void _ZN6G21223D1Ev();
Name_Map name_map_G21223[] = {
  NSPAIR(_ZN6G21223C1Ev),
  NSPAIR(_ZN6G21223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G21223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21223[];
extern void _ZN6G212233fooEv();
extern void _ZN6G212233barEv();
extern void ABISELECT(_ZTv0_n32_N6G212233fooEv,_ZTv0_n16_N6G212233fooEv)();
extern void ABISELECT(_ZThn16_N6G212233fooEv,_ZThn8_N6G212233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G212233barEv,_ZTv0_n12_N6G212233barEv)();
extern void ABISELECT(_ZThn32_N6G212233barEv,_ZThn16_N6G212233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G212233barEv,_ZTv0_n16_N6G212233barEv)();
extern void ABISELECT(_ZThn48_N6G212233barEv,_ZThn24_N6G212233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21223[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21223[0]),
  (VTBL_ENTRY)&_ZN6G212233fooEv,
  (VTBL_ENTRY)&_ZN6G212233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G212233fooEv,_ZTv0_n16_N6G212233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G212233barEv,_ZTv0_n12_N6G212233barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G212233barEv,_ZTv0_n16_N6G212233barEv),
};
extern VTBL_ENTRY _ZTV6G21223[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21223[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G21223[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G21223[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G21223[] = {
  {&(_ZTV6G21223[5]),  5,21},
  {&(_ZTV6G21223[11]),  11,21},
  {&(_ZTV6G21223[15]),  15,21},
  {&(_ZTV6G21223[20]),  20,21},
  {&(_tg__ZTV3E21__6G21223[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21223[3]),  3,4},
  {&(_tg__ZTV3F22__6G21223[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G21223[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21223[];
extern  VTBL_ENTRY _ZTV6G21223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21223[];
static VTBL_ENTRY alt_thunk_names112[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G212233barEv,_ZTv0_n16_N6G212233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G212233barEv,_ZThn24_N6G212233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G212233barEv,_ZTv0_n12_N6G212233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G212233barEv,_ZThn16_N6G212233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G212233fooEv,_ZTv0_n16_N6G212233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G212233fooEv,_ZThn8_N6G212233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21223 = {  "G21223", // class name
  bases_G21223, 3,
  &(vtc_G21223[0]), // expected_vtbl_contents
  &(vtt_G21223[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G21223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21223),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21223),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names112,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21233  : virtual E21 , virtual F23 {
  int pg;
  virtual void  foo(); // _ZN6G212333fooEv
  virtual void  bar(); // _ZN6G212333barEv
  ~G21233(); // tgen
  G21233(); // tgen
};
//SIG(1 G21233) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC3 v1 v2 Fi} v1 v2 Fi}


void  G21233 ::foo(){vfunc_called(this, "_ZN6G212333fooEv");}
void  G21233 ::bar(){vfunc_called(this, "_ZN6G212333barEv");}
G21233 ::~G21233(){ note_dtor("G21233", this);} // tgen
G21233 ::G21233(){ note_ctor("G21233", this);} // tgen

static void Test_G21233()
{
  extern Class_Descriptor cd_G21233;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G21233, buf);
    G21233 *dp, &lv = *(dp=new (buf) G21233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G21233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21233)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21233");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(32,16), "G21233");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21233");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G21233");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21233.pg");
    test_class_info(&lv, &cd_G21233);
    dp->~G21233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21233(Test_G21233, "G21233", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G21233C1Ev();
extern void _ZN6G21233D1Ev();
Name_Map name_map_G21233[] = {
  NSPAIR(_ZN6G21233C1Ev),
  NSPAIR(_ZN6G21233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G21233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21233[];
extern void _ZN6G212333fooEv();
extern void _ZN6G212333barEv();
extern void ABISELECT(_ZTv0_n32_N6G212333fooEv,_ZTv0_n16_N6G212333fooEv)();
extern void ABISELECT(_ZThn16_N6G212333fooEv,_ZThn8_N6G212333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G212333barEv,_ZTv0_n12_N6G212333barEv)();
extern void ABISELECT(_ZThn32_N6G212333barEv,_ZThn16_N6G212333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G212333fooEv,_ZTv0_n16_N6G212333fooEv)();
extern void ABISELECT(_ZThn48_N6G212333fooEv,_ZThn24_N6G212333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G212333barEv,_ZTv0_n20_N6G212333barEv)();
extern void ABISELECT(_ZThn48_N6G212333barEv,_ZThn24_N6G212333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21233[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21233[0]),
  (VTBL_ENTRY)&_ZN6G212333fooEv,
  (VTBL_ENTRY)&_ZN6G212333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G212333fooEv,_ZTv0_n16_N6G212333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G212333barEv,_ZTv0_n12_N6G212333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G212333fooEv,_ZTv0_n16_N6G212333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G212333barEv,_ZTv0_n20_N6G212333barEv),
};
extern VTBL_ENTRY _ZTV6G21233[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21233[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G21233[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G21233[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G21233[] = {
  {&(_ZTV6G21233[5]),  5,23},
  {&(_ZTV6G21233[11]),  11,23},
  {&(_ZTV6G21233[15]),  15,23},
  {&(_ZTV6G21233[21]),  21,23},
  {&(_tg__ZTV3E21__6G21233[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21233[3]),  3,4},
  {&(_tg__ZTV3F23__6G21233[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G21233[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G21233[];
extern  VTBL_ENTRY _ZTV6G21233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21233[];
static VTBL_ENTRY alt_thunk_names113[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G212333barEv,_ZTv0_n20_N6G212333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G212333barEv,_ZThn24_N6G212333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G212333barEv,_ZTv0_n12_N6G212333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G212333barEv,_ZThn16_N6G212333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G212333fooEv,_ZTv0_n16_N6G212333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G212333fooEv,_ZThn24_N6G212333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G212333fooEv,_ZThn8_N6G212333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21233 = {  "G21233", // class name
  bases_G21233, 3,
  &(vtc_G21233[0]), // expected_vtbl_contents
  &(vtt_G21233[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G21233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21233),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21233),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names113,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21313  : virtual E21 , virtual F31 {
  int pg;
  virtual void  foo(); // _ZN6G213133fooEv
  virtual void  bar(); // _ZN6G213133barEv
  ~G21313(); // tgen
  G21313(); // tgen
};
//SIG(1 G21313) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 Fi} v1 v2 Fi}


void  G21313 ::foo(){vfunc_called(this, "_ZN6G213133fooEv");}
void  G21313 ::bar(){vfunc_called(this, "_ZN6G213133barEv");}
G21313 ::~G21313(){ note_dtor("G21313", this);} // tgen
G21313 ::G21313(){ note_ctor("G21313", this);} // tgen

static void Test_G21313()
{
  extern Class_Descriptor cd_G21313;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G21313, buf);
    G21313 *dp, &lv = *(dp=new (buf) G21313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G21313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21313)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21313");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21313");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G21313");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G21313");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21313.pg");
    test_class_info(&lv, &cd_G21313);
    dp->~G21313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21313(Test_G21313, "G21313", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G21313C1Ev();
extern void _ZN6G21313D1Ev();
Name_Map name_map_G21313[] = {
  NSPAIR(_ZN6G21313C1Ev),
  NSPAIR(_ZN6G21313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G21313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21313[];
extern void _ZN6G213133fooEv();
extern void _ZN6G213133barEv();
extern void ABISELECT(_ZTv0_n32_N6G213133fooEv,_ZTv0_n16_N6G213133fooEv)();
extern void ABISELECT(_ZThn16_N6G213133fooEv,_ZThn8_N6G213133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G213133barEv,_ZTv0_n12_N6G213133barEv)();
extern void ABISELECT(_ZThn32_N6G213133barEv,_ZThn16_N6G213133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G213133fooEv,_ZTv0_n16_N6G213133fooEv)();
extern void ABISELECT(_ZThn48_N6G213133fooEv,_ZThn24_N6G213133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G213133fooEv,_ZTv0_n12_N6G213133fooEv)();
extern void ABISELECT(_ZThn64_N6G213133fooEv,_ZThn32_N6G213133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G213133barEv,_ZTv0_n16_N6G213133barEv)();
extern void ABISELECT(_ZThn64_N6G213133barEv,_ZThn32_N6G213133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21313[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21313[0]),
  (VTBL_ENTRY)&_ZN6G213133fooEv,
  (VTBL_ENTRY)&_ZN6G213133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213133fooEv,_ZTv0_n16_N6G213133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G213133barEv,_ZTv0_n12_N6G213133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213133fooEv,_ZTv0_n16_N6G213133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G21313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G213133fooEv,_ZTv0_n12_N6G213133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213133barEv,_ZTv0_n16_N6G213133barEv),
};
extern VTBL_ENTRY _ZTV6G21313[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21313[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G21313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G21313[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G21313[] = {
  {&(_ZTV6G21313[6]),  6,28},
  {&(_ZTV6G21313[12]),  12,28},
  {&(_ZTV6G21313[16]),  16,28},
  {&(_ZTV6G21313[21]),  21,28},
  {&(_ZTV6G21313[26]),  26,28},
  {&(_tg__ZTV3E21__6G21313[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21313[3]),  3,4},
  {&(_tg__ZTV3F31__6G21313[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G21313[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G21313[];
extern  VTBL_ENTRY _ZTV6G21313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21313[];
static VTBL_ENTRY alt_thunk_names114[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G213133barEv,_ZTv0_n16_N6G213133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G213133barEv,_ZThn32_N6G213133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G213133fooEv,_ZTv0_n12_N6G213133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G213133fooEv,_ZThn32_N6G213133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G213133barEv,_ZTv0_n12_N6G213133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G213133barEv,_ZThn16_N6G213133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G213133fooEv,_ZTv0_n16_N6G213133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G213133fooEv,_ZThn24_N6G213133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G213133fooEv,_ZThn8_N6G213133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21313 = {  "G21313", // class name
  bases_G21313, 4,
  &(vtc_G21313[0]), // expected_vtbl_contents
  &(vtt_G21313[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G21313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21313),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21313),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names114,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21323  : virtual E21 , virtual F32 {
  int pg;
  virtual void  foo(); // _ZN6G213233fooEv
  virtual void  bar(); // _ZN6G213233barEv
  ~G21323(); // tgen
  G21323(); // tgen
};
//SIG(1 G21323) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v2 Fi} v1 v2 Fi}


void  G21323 ::foo(){vfunc_called(this, "_ZN6G213233fooEv");}
void  G21323 ::bar(){vfunc_called(this, "_ZN6G213233barEv");}
G21323 ::~G21323(){ note_dtor("G21323", this);} // tgen
G21323 ::G21323(){ note_ctor("G21323", this);} // tgen

static void Test_G21323()
{
  extern Class_Descriptor cd_G21323;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G21323, buf);
    G21323 *dp, &lv = *(dp=new (buf) G21323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G21323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21323)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21323");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21323");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G21323");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G21323");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21323.pg");
    test_class_info(&lv, &cd_G21323);
    dp->~G21323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21323(Test_G21323, "G21323", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G21323C1Ev();
extern void _ZN6G21323D1Ev();
Name_Map name_map_G21323[] = {
  NSPAIR(_ZN6G21323C1Ev),
  NSPAIR(_ZN6G21323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G21323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21323[];
extern void _ZN6G213233fooEv();
extern void _ZN6G213233barEv();
extern void ABISELECT(_ZTv0_n32_N6G213233fooEv,_ZTv0_n16_N6G213233fooEv)();
extern void ABISELECT(_ZThn16_N6G213233fooEv,_ZThn8_N6G213233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G213233barEv,_ZTv0_n12_N6G213233barEv)();
extern void ABISELECT(_ZThn32_N6G213233barEv,_ZThn16_N6G213233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G213233barEv,_ZTv0_n16_N6G213233barEv)();
extern void ABISELECT(_ZThn48_N6G213233barEv,_ZThn24_N6G213233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G213233fooEv,_ZTv0_n12_N6G213233fooEv)();
extern void ABISELECT(_ZThn64_N6G213233fooEv,_ZThn32_N6G213233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G213233barEv,_ZTv0_n16_N6G213233barEv)();
extern void ABISELECT(_ZThn64_N6G213233barEv,_ZThn32_N6G213233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21323[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21323[0]),
  (VTBL_ENTRY)&_ZN6G213233fooEv,
  (VTBL_ENTRY)&_ZN6G213233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213233fooEv,_ZTv0_n16_N6G213233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G213233barEv,_ZTv0_n12_N6G213233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213233barEv,_ZTv0_n16_N6G213233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G21323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G213233fooEv,_ZTv0_n12_N6G213233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213233barEv,_ZTv0_n16_N6G213233barEv),
};
extern VTBL_ENTRY _ZTV6G21323[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21323[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G21323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G21323[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G21323[] = {
  {&(_ZTV6G21323[6]),  6,28},
  {&(_ZTV6G21323[12]),  12,28},
  {&(_ZTV6G21323[16]),  16,28},
  {&(_ZTV6G21323[21]),  21,28},
  {&(_ZTV6G21323[26]),  26,28},
  {&(_tg__ZTV3E21__6G21323[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21323[3]),  3,4},
  {&(_tg__ZTV3F32__6G21323[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G21323[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G21323[];
extern  VTBL_ENTRY _ZTV6G21323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21323[];
static VTBL_ENTRY alt_thunk_names115[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G213233fooEv,_ZTv0_n12_N6G213233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G213233fooEv,_ZThn32_N6G213233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G213233barEv,_ZTv0_n16_N6G213233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G213233barEv,_ZThn32_N6G213233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G213233barEv,_ZThn24_N6G213233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G213233barEv,_ZTv0_n12_N6G213233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G213233barEv,_ZThn16_N6G213233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G213233fooEv,_ZTv0_n16_N6G213233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G213233fooEv,_ZThn8_N6G213233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21323 = {  "G21323", // class name
  bases_G21323, 4,
  &(vtc_G21323[0]), // expected_vtbl_contents
  &(vtt_G21323[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G21323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21323),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21323),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names115,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G21333  : virtual E21 , virtual F33 {
  int pg;
  virtual void  foo(); // _ZN6G213333fooEv
  virtual void  bar(); // _ZN6G213333barEv
  ~G21333(); // tgen
  G21333(); // tgen
};
//SIG(1 G21333) C1{ VBC2{ VBC3{ v2 Fi} v1 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G21333 ::foo(){vfunc_called(this, "_ZN6G213333fooEv");}
void  G21333 ::bar(){vfunc_called(this, "_ZN6G213333barEv");}
G21333 ::~G21333(){ note_dtor("G21333", this);} // tgen
G21333 ::G21333(){ note_ctor("G21333", this);} // tgen

static void Test_G21333()
{
  extern Class_Descriptor cd_G21333;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G21333, buf);
    G21333 *dp, &lv = *(dp=new (buf) G21333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G21333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G21333)");
    check_base_class_offset(lv, (AA2*)(E21*), ABISELECT(32,16), "G21333");
    check_base_class_offset(lv, (E21*), ABISELECT(16,8), "G21333");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G21333");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G21333");
    check_field_offset(lv, pg, ABISELECT(8,4), "G21333.pg");
    test_class_info(&lv, &cd_G21333);
    dp->~G21333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG21333(Test_G21333, "G21333", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G21333C1Ev();
extern void _ZN6G21333D1Ev();
Name_Map name_map_G21333[] = {
  NSPAIR(_ZN6G21333C1Ev),
  NSPAIR(_ZN6G21333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E21;
extern VTBL_ENTRY _ZTI3E21[];
extern  VTBL_ENTRY _ZTV3E21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E21[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G21333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E21,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G21333[];
extern void _ZN6G213333fooEv();
extern void _ZN6G213333barEv();
extern void ABISELECT(_ZTv0_n32_N6G213333fooEv,_ZTv0_n16_N6G213333fooEv)();
extern void ABISELECT(_ZThn16_N6G213333fooEv,_ZThn8_N6G213333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G213333barEv,_ZTv0_n12_N6G213333barEv)();
extern void ABISELECT(_ZThn32_N6G213333barEv,_ZThn16_N6G213333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G213333fooEv,_ZTv0_n16_N6G213333fooEv)();
extern void ABISELECT(_ZThn48_N6G213333fooEv,_ZThn24_N6G213333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G213333barEv,_ZTv0_n20_N6G213333barEv)();
extern void ABISELECT(_ZThn48_N6G213333barEv,_ZThn24_N6G213333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G213333fooEv,_ZTv0_n12_N6G213333fooEv)();
extern void ABISELECT(_ZThn64_N6G213333fooEv,_ZThn32_N6G213333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G213333barEv,_ZTv0_n16_N6G213333barEv)();
extern void ABISELECT(_ZThn64_N6G213333barEv,_ZThn32_N6G213333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G21333[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G21333[0]),
  (VTBL_ENTRY)&_ZN6G213333fooEv,
  (VTBL_ENTRY)&_ZN6G213333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G21333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213333fooEv,_ZTv0_n16_N6G213333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G21333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G213333barEv,_ZTv0_n12_N6G213333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G21333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213333fooEv,_ZTv0_n16_N6G213333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G213333barEv,_ZTv0_n20_N6G213333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G21333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G213333fooEv,_ZTv0_n12_N6G213333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G213333barEv,_ZTv0_n16_N6G213333barEv),
};
extern VTBL_ENTRY _ZTV6G21333[];
extern void _ZN3E213fooEv();
static  VTBL_ENTRY _tg__ZTV3E21__6G21333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3E213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3E21__6G21333[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G21333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G21333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G21333[] = {
  {&(_ZTV6G21333[6]),  6,30},
  {&(_ZTV6G21333[12]),  12,30},
  {&(_ZTV6G21333[16]),  16,30},
  {&(_ZTV6G21333[22]),  22,30},
  {&(_ZTV6G21333[28]),  28,30},
  {&(_tg__ZTV3E21__6G21333[3]),  3,4},
  {&(_tg__ZTV3AA2__3E21__6G21333[3]),  3,4},
  {&(_tg__ZTV3F33__6G21333[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G21333[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G21333[];
extern  VTBL_ENTRY _ZTV6G21333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G21333[];
static VTBL_ENTRY alt_thunk_names116[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G213333barEv,_ZTv0_n16_N6G213333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G213333barEv,_ZThn32_N6G213333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G213333fooEv,_ZTv0_n12_N6G213333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G213333fooEv,_ZThn32_N6G213333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G213333barEv,_ZTv0_n20_N6G213333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G213333barEv,_ZThn24_N6G213333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G213333barEv,_ZTv0_n12_N6G213333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G213333barEv,_ZThn16_N6G213333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G213333fooEv,_ZTv0_n16_N6G213333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G213333fooEv,_ZThn24_N6G213333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G213333fooEv,_ZThn8_N6G213333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G21333 = {  "G21333", // class name
  bases_G21333, 4,
  &(vtc_G21333[0]), // expected_vtbl_contents
  &(vtt_G21333[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G21333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G21333),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G21333),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names116,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22111  : virtual E22 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G221113fooEv
  ~G22111(); // tgen
  G22111(); // tgen
};
//SIG(1 G22111) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 Fi}


void  G22111 ::foo(){vfunc_called(this, "_ZN6G221113fooEv");}
G22111 ::~G22111(){ note_dtor("G22111", this);} // tgen
G22111 ::G22111(){ note_ctor("G22111", this);} // tgen

static void Test_G22111()
{
  extern Class_Descriptor cd_G22111;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22111, buf);
    G22111 *dp, &lv = *(dp=new (buf) G22111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22111)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22111");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22111");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G22111");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G22111");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22111.pg");
    test_class_info(&lv, &cd_G22111);
    dp->~G22111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22111(Test_G22111, "G22111", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22111C1Ev();
extern void _ZN6G22111D1Ev();
Name_Map name_map_G22111[] = {
  NSPAIR(_ZN6G22111C1Ev),
  NSPAIR(_ZN6G22111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G22111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22111[];
extern void _ZN6G221113fooEv();
extern void _ZN3E223barEv();
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G221113fooEv,_ZTv0_n16_N6G221113fooEv)();
extern void ABISELECT(_ZThn48_N6G221113fooEv,_ZThn24_N6G221113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221113fooEv,_ZTv0_n12_N6G221113fooEv)();
extern void ABISELECT(_ZThn64_N6G221113fooEv,_ZThn32_N6G221113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22111[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22111[0]),
  (VTBL_ENTRY)&_ZN6G221113fooEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22111[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221113fooEv,_ZTv0_n16_N6G221113fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221113fooEv,_ZTv0_n12_N6G221113fooEv),
};
extern VTBL_ENTRY _ZTV6G22111[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G22111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G22111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G22111[] = {
  {&(_ZTV6G22111[6]),  6,25},
  {&(_ZTV6G22111[11]),  11,25},
  {&(_ZTV6G22111[15]),  15,25},
  {&(_ZTV6G22111[20]),  20,25},
  {&(_ZTV6G22111[24]),  24,25},
  {&(_tg__ZTV3E22__6G22111[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22111[3]),  3,4},
  {&(_tg__ZTV3F11__6G22111[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G22111[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22111[];
extern  VTBL_ENTRY _ZTV6G22111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22111[];
static VTBL_ENTRY alt_thunk_names117[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221113fooEv,_ZTv0_n12_N6G221113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G221113fooEv,_ZThn32_N6G221113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221113fooEv,_ZTv0_n16_N6G221113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G221113fooEv,_ZThn24_N6G221113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22111 = {  "G22111", // class name
  bases_G22111, 4,
  &(vtc_G22111[0]), // expected_vtbl_contents
  &(vtt_G22111[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22111),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22111),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names117,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22112  : virtual E22 , virtual F11 {
  int pg;
  virtual void  bar(); // _ZN6G221123barEv
  ~G22112(); // tgen
  G22112(); // tgen
};
//SIG(1 G22112) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v2 Fi} v1 Fi}


void  G22112 ::bar(){vfunc_called(this, "_ZN6G221123barEv");}
G22112 ::~G22112(){ note_dtor("G22112", this);} // tgen
G22112 ::G22112(){ note_ctor("G22112", this);} // tgen

static void Test_G22112()
{
  extern Class_Descriptor cd_G22112;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22112, buf);
    G22112 *dp, &lv = *(dp=new (buf) G22112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22112)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22112");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22112");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G22112");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G22112");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22112.pg");
    test_class_info(&lv, &cd_G22112);
    dp->~G22112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22112(Test_G22112, "G22112", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22112C1Ev();
extern void _ZN6G22112D1Ev();
Name_Map name_map_G22112[] = {
  NSPAIR(_ZN6G22112C1Ev),
  NSPAIR(_ZN6G22112D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G22112[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22112[];
extern void _ZN6G221123barEv();
extern void ABISELECT(_ZTv0_n32_N6G221123barEv,_ZTv0_n16_N6G221123barEv)();
extern void ABISELECT(_ZThn16_N6G221123barEv,_ZThn8_N6G221123barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221123barEv,_ZTv0_n12_N6G221123barEv)();
extern void ABISELECT(_ZThn32_N6G221123barEv,_ZThn16_N6G221123barEv)() __attribute__((weak));
extern void _ZN3F113fooEv();
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22112[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22112[0]),
  (VTBL_ENTRY)&_ZN6G221123barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22112[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221123barEv,_ZTv0_n16_N6G221123barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22112[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221123barEv,_ZTv0_n12_N6G221123barEv),
  0,
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22112[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22112[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
extern VTBL_ENTRY _ZTV6G22112[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22112[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22112[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G22112[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G22112[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G22112[] = {
  {&(_ZTV6G22112[6]),  6,25},
  {&(_ZTV6G22112[11]),  11,25},
  {&(_ZTV6G22112[15]),  15,25},
  {&(_ZTV6G22112[20]),  20,25},
  {&(_ZTV6G22112[24]),  24,25},
  {&(_tg__ZTV3E22__6G22112[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22112[3]),  3,4},
  {&(_tg__ZTV3F11__6G22112[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G22112[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22112[];
extern  VTBL_ENTRY _ZTV6G22112[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22112[];
static VTBL_ENTRY alt_thunk_names118[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221123barEv,_ZTv0_n12_N6G221123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G221123barEv,_ZThn16_N6G221123barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221123barEv,_ZTv0_n16_N6G221123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G221123barEv,_ZThn8_N6G221123barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22112 = {  "G22112", // class name
  bases_G22112, 4,
  &(vtc_G22112[0]), // expected_vtbl_contents
  &(vtt_G22112[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22112),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22112),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22112),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names118,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22113  : virtual E22 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G221133fooEv
  virtual void  bar(); // _ZN6G221133barEv
  ~G22113(); // tgen
  G22113(); // tgen
};
//SIG(1 G22113) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 v2 Fi}


void  G22113 ::foo(){vfunc_called(this, "_ZN6G221133fooEv");}
void  G22113 ::bar(){vfunc_called(this, "_ZN6G221133barEv");}
G22113 ::~G22113(){ note_dtor("G22113", this);} // tgen
G22113 ::G22113(){ note_ctor("G22113", this);} // tgen

static void Test_G22113()
{
  extern Class_Descriptor cd_G22113;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22113, buf);
    G22113 *dp, &lv = *(dp=new (buf) G22113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22113)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22113");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22113");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G22113");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G22113");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22113.pg");
    test_class_info(&lv, &cd_G22113);
    dp->~G22113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22113(Test_G22113, "G22113", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22113C1Ev();
extern void _ZN6G22113D1Ev();
Name_Map name_map_G22113[] = {
  NSPAIR(_ZN6G22113C1Ev),
  NSPAIR(_ZN6G22113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G22113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22113[];
extern void _ZN6G221133fooEv();
extern void _ZN6G221133barEv();
extern void ABISELECT(_ZTv0_n32_N6G221133barEv,_ZTv0_n16_N6G221133barEv)();
extern void ABISELECT(_ZThn16_N6G221133barEv,_ZThn8_N6G221133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221133barEv,_ZTv0_n12_N6G221133barEv)();
extern void ABISELECT(_ZThn32_N6G221133barEv,_ZThn16_N6G221133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G221133fooEv,_ZTv0_n16_N6G221133fooEv)();
extern void ABISELECT(_ZThn48_N6G221133fooEv,_ZThn24_N6G221133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221133fooEv,_ZTv0_n12_N6G221133fooEv)();
extern void ABISELECT(_ZThn64_N6G221133fooEv,_ZThn32_N6G221133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22113[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22113[0]),
  (VTBL_ENTRY)&_ZN6G221133fooEv,
  (VTBL_ENTRY)&_ZN6G221133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221133barEv,_ZTv0_n16_N6G221133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221133barEv,_ZTv0_n12_N6G221133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221133fooEv,_ZTv0_n16_N6G221133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221133fooEv,_ZTv0_n12_N6G221133fooEv),
};
extern VTBL_ENTRY _ZTV6G22113[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G22113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G22113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G22113[] = {
  {&(_ZTV6G22113[6]),  6,26},
  {&(_ZTV6G22113[12]),  12,26},
  {&(_ZTV6G22113[16]),  16,26},
  {&(_ZTV6G22113[21]),  21,26},
  {&(_ZTV6G22113[25]),  25,26},
  {&(_tg__ZTV3E22__6G22113[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22113[3]),  3,4},
  {&(_tg__ZTV3F11__6G22113[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G22113[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22113[];
extern  VTBL_ENTRY _ZTV6G22113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22113[];
static VTBL_ENTRY alt_thunk_names119[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221133fooEv,_ZTv0_n12_N6G221133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G221133fooEv,_ZThn32_N6G221133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221133fooEv,_ZTv0_n16_N6G221133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G221133fooEv,_ZThn24_N6G221133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221133barEv,_ZTv0_n12_N6G221133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G221133barEv,_ZThn16_N6G221133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221133barEv,_ZTv0_n16_N6G221133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G221133barEv,_ZThn8_N6G221133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22113 = {  "G22113", // class name
  bases_G22113, 4,
  &(vtc_G22113[0]), // expected_vtbl_contents
  &(vtt_G22113[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22113),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22113),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names119,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22122  : virtual E22 , virtual F12 {
  int pg;
  virtual void  bar(); // _ZN6G221223barEv
  ~G22122(); // tgen
  G22122(); // tgen
};
//SIG(1 G22122) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v1 Fi} v1 Fi}


void  G22122 ::bar(){vfunc_called(this, "_ZN6G221223barEv");}
G22122 ::~G22122(){ note_dtor("G22122", this);} // tgen
G22122 ::G22122(){ note_ctor("G22122", this);} // tgen

static void Test_G22122()
{
  extern Class_Descriptor cd_G22122;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22122, buf);
    G22122 *dp, &lv = *(dp=new (buf) G22122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22122)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22122");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22122");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(64,32), "G22122");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G22122");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22122.pg");
    test_class_info(&lv, &cd_G22122);
    dp->~G22122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22122(Test_G22122, "G22122", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22122C1Ev();
extern void _ZN6G22122D1Ev();
Name_Map name_map_G22122[] = {
  NSPAIR(_ZN6G22122C1Ev),
  NSPAIR(_ZN6G22122D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G22122[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22122[];
extern void _ZN6G221223barEv();
extern void ABISELECT(_ZTv0_n32_N6G221223barEv,_ZTv0_n16_N6G221223barEv)();
extern void ABISELECT(_ZThn16_N6G221223barEv,_ZThn8_N6G221223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221223barEv,_ZTv0_n12_N6G221223barEv)();
extern void ABISELECT(_ZThn32_N6G221223barEv,_ZThn16_N6G221223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G221223barEv,_ZTv0_n16_N6G221223barEv)();
extern void ABISELECT(_ZThn48_N6G221223barEv,_ZThn24_N6G221223barEv)() __attribute__((weak));
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY vtc_G22122[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22122[0]),
  (VTBL_ENTRY)&_ZN6G221223barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22122[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221223barEv,_ZTv0_n16_N6G221223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22122[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221223barEv,_ZTv0_n12_N6G221223barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22122[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221223barEv,_ZTv0_n16_N6G221223barEv),
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22122[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
extern VTBL_ENTRY _ZTV6G22122[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22122[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22122[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G22122[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G22122[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G22122[] = {
  {&(_ZTV6G22122[6]),  6,25},
  {&(_ZTV6G22122[11]),  11,25},
  {&(_ZTV6G22122[15]),  15,25},
  {&(_ZTV6G22122[20]),  20,25},
  {&(_ZTV6G22122[24]),  24,25},
  {&(_tg__ZTV3E22__6G22122[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22122[3]),  3,4},
  {&(_tg__ZTV3F12__6G22122[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G22122[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22122[];
extern  VTBL_ENTRY _ZTV6G22122[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22122[];
static VTBL_ENTRY alt_thunk_names120[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221223barEv,_ZTv0_n12_N6G221223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G221223barEv,_ZThn16_N6G221223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221223barEv,_ZTv0_n16_N6G221223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G221223barEv,_ZThn24_N6G221223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G221223barEv,_ZThn8_N6G221223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22122 = {  "G22122", // class name
  bases_G22122, 4,
  &(vtc_G22122[0]), // expected_vtbl_contents
  &(vtt_G22122[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22122),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22122),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22122),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names120,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22123  : virtual E22 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G221233fooEv
  virtual void  bar(); // _ZN6G221233barEv
  ~G22123(); // tgen
  G22123(); // tgen
};
//SIG(1 G22123) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 Fi} v2 Fi} v1 v2 Fi}


void  G22123 ::foo(){vfunc_called(this, "_ZN6G221233fooEv");}
void  G22123 ::bar(){vfunc_called(this, "_ZN6G221233barEv");}
G22123 ::~G22123(){ note_dtor("G22123", this);} // tgen
G22123 ::G22123(){ note_ctor("G22123", this);} // tgen

static void Test_G22123()
{
  extern Class_Descriptor cd_G22123;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22123, buf);
    G22123 *dp, &lv = *(dp=new (buf) G22123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22123)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22123");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22123");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(64,32), "G22123");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G22123");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22123.pg");
    test_class_info(&lv, &cd_G22123);
    dp->~G22123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22123(Test_G22123, "G22123", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22123C1Ev();
extern void _ZN6G22123D1Ev();
Name_Map name_map_G22123[] = {
  NSPAIR(_ZN6G22123C1Ev),
  NSPAIR(_ZN6G22123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G22123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22123[];
extern void _ZN6G221233fooEv();
extern void _ZN6G221233barEv();
extern void ABISELECT(_ZTv0_n32_N6G221233barEv,_ZTv0_n16_N6G221233barEv)();
extern void ABISELECT(_ZThn16_N6G221233barEv,_ZThn8_N6G221233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221233barEv,_ZTv0_n12_N6G221233barEv)();
extern void ABISELECT(_ZThn32_N6G221233barEv,_ZThn16_N6G221233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G221233barEv,_ZTv0_n16_N6G221233barEv)();
extern void ABISELECT(_ZThn48_N6G221233barEv,_ZThn24_N6G221233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221233fooEv,_ZTv0_n12_N6G221233fooEv)();
extern void ABISELECT(_ZThn64_N6G221233fooEv,_ZThn32_N6G221233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22123[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22123[0]),
  (VTBL_ENTRY)&_ZN6G221233fooEv,
  (VTBL_ENTRY)&_ZN6G221233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221233barEv,_ZTv0_n16_N6G221233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221233barEv,_ZTv0_n12_N6G221233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221233barEv,_ZTv0_n16_N6G221233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221233fooEv,_ZTv0_n12_N6G221233fooEv),
};
extern VTBL_ENTRY _ZTV6G22123[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22123[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G22123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G22123[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G22123[] = {
  {&(_ZTV6G22123[6]),  6,26},
  {&(_ZTV6G22123[12]),  12,26},
  {&(_ZTV6G22123[16]),  16,26},
  {&(_ZTV6G22123[21]),  21,26},
  {&(_ZTV6G22123[25]),  25,26},
  {&(_tg__ZTV3E22__6G22123[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22123[3]),  3,4},
  {&(_tg__ZTV3F12__6G22123[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G22123[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22123[];
extern  VTBL_ENTRY _ZTV6G22123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22123[];
static VTBL_ENTRY alt_thunk_names121[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221233fooEv,_ZTv0_n12_N6G221233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G221233fooEv,_ZThn32_N6G221233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221233barEv,_ZTv0_n12_N6G221233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G221233barEv,_ZThn16_N6G221233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221233barEv,_ZTv0_n16_N6G221233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G221233barEv,_ZThn24_N6G221233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G221233barEv,_ZThn8_N6G221233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22123 = {  "G22123", // class name
  bases_G22123, 4,
  &(vtc_G22123[0]), // expected_vtbl_contents
  &(vtt_G22123[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22123),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22123),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names121,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22132  : virtual E22 , virtual F13 {
  int pg;
  virtual void  bar(); // _ZN6G221323barEv
  ~G22132(); // tgen
  G22132(); // tgen
};
//SIG(1 G22132) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v2 v1 Fi} v1 Fi}


void  G22132 ::bar(){vfunc_called(this, "_ZN6G221323barEv");}
G22132 ::~G22132(){ note_dtor("G22132", this);} // tgen
G22132 ::G22132(){ note_ctor("G22132", this);} // tgen

static void Test_G22132()
{
  extern Class_Descriptor cd_G22132;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22132, buf);
    G22132 *dp, &lv = *(dp=new (buf) G22132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22132)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22132)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22132");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22132");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(64,32), "G22132");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G22132");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22132.pg");
    test_class_info(&lv, &cd_G22132);
    dp->~G22132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22132(Test_G22132, "G22132", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22132C1Ev();
extern void _ZN6G22132D1Ev();
Name_Map name_map_G22132[] = {
  NSPAIR(_ZN6G22132C1Ev),
  NSPAIR(_ZN6G22132D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G22132[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22132[];
extern void _ZN6G221323barEv();
extern void ABISELECT(_ZTv0_n32_N6G221323barEv,_ZTv0_n16_N6G221323barEv)();
extern void ABISELECT(_ZThn16_N6G221323barEv,_ZThn8_N6G221323barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221323barEv,_ZTv0_n12_N6G221323barEv)();
extern void ABISELECT(_ZThn32_N6G221323barEv,_ZThn16_N6G221323barEv)() __attribute__((weak));
extern void _ZN3F133fooEv();
extern void ABISELECT(_ZTv0_n40_N6G221323barEv,_ZTv0_n20_N6G221323barEv)();
extern void ABISELECT(_ZThn48_N6G221323barEv,_ZThn24_N6G221323barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
extern void ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22132[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22132[0]),
  (VTBL_ENTRY)&_ZN6G221323barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22132[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221323barEv,_ZTv0_n16_N6G221323barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22132[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221323barEv,_ZTv0_n12_N6G221323barEv),
  ABISELECT(-48,-24),
  0,
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22132[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G221323barEv,_ZTv0_n20_N6G221323barEv),
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22132[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
extern VTBL_ENTRY _ZTV6G22132[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22132[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22132[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G22132[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
extern void ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G22132[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G22132[] = {
  {&(_ZTV6G22132[6]),  6,27},
  {&(_ZTV6G22132[11]),  11,27},
  {&(_ZTV6G22132[15]),  15,27},
  {&(_ZTV6G22132[21]),  21,27},
  {&(_ZTV6G22132[26]),  26,27},
  {&(_tg__ZTV3E22__6G22132[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22132[3]),  3,4},
  {&(_tg__ZTV3F13__6G22132[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G22132[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22132[];
extern  VTBL_ENTRY _ZTV6G22132[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22132[];
static VTBL_ENTRY alt_thunk_names122[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G221323barEv,_ZTv0_n20_N6G221323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G221323barEv,_ZThn24_N6G221323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221323barEv,_ZTv0_n12_N6G221323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G221323barEv,_ZThn16_N6G221323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221323barEv,_ZTv0_n16_N6G221323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G221323barEv,_ZThn8_N6G221323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22132 = {  "G22132", // class name
  bases_G22132, 4,
  &(vtc_G22132[0]), // expected_vtbl_contents
  &(vtt_G22132[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22132),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22132),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22132),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names122,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22133  : virtual E22 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G221333fooEv
  virtual void  bar(); // _ZN6G221333barEv
  ~G22133(); // tgen
  G22133(); // tgen
};
//SIG(1 G22133) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 Fi} v1 v2 Fi} v1 v2 Fi}


void  G22133 ::foo(){vfunc_called(this, "_ZN6G221333fooEv");}
void  G22133 ::bar(){vfunc_called(this, "_ZN6G221333barEv");}
G22133 ::~G22133(){ note_dtor("G22133", this);} // tgen
G22133 ::G22133(){ note_ctor("G22133", this);} // tgen

static void Test_G22133()
{
  extern Class_Descriptor cd_G22133;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22133, buf);
    G22133 *dp, &lv = *(dp=new (buf) G22133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22133)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22133");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22133");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(64,32), "G22133");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G22133");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22133.pg");
    test_class_info(&lv, &cd_G22133);
    dp->~G22133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22133(Test_G22133, "G22133", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22133C1Ev();
extern void _ZN6G22133D1Ev();
Name_Map name_map_G22133[] = {
  NSPAIR(_ZN6G22133C1Ev),
  NSPAIR(_ZN6G22133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G22133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22133[];
extern void _ZN6G221333fooEv();
extern void _ZN6G221333barEv();
extern void ABISELECT(_ZTv0_n32_N6G221333barEv,_ZTv0_n16_N6G221333barEv)();
extern void ABISELECT(_ZThn16_N6G221333barEv,_ZThn8_N6G221333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221333barEv,_ZTv0_n12_N6G221333barEv)();
extern void ABISELECT(_ZThn32_N6G221333barEv,_ZThn16_N6G221333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G221333fooEv,_ZTv0_n16_N6G221333fooEv)();
extern void ABISELECT(_ZThn48_N6G221333fooEv,_ZThn24_N6G221333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G221333barEv,_ZTv0_n20_N6G221333barEv)();
extern void ABISELECT(_ZThn48_N6G221333barEv,_ZThn24_N6G221333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G221333fooEv,_ZTv0_n12_N6G221333fooEv)();
extern void ABISELECT(_ZThn64_N6G221333fooEv,_ZThn32_N6G221333fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22133[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22133[0]),
  (VTBL_ENTRY)&_ZN6G221333fooEv,
  (VTBL_ENTRY)&_ZN6G221333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221333barEv,_ZTv0_n16_N6G221333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221333barEv,_ZTv0_n12_N6G221333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G221333fooEv,_ZTv0_n16_N6G221333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G221333barEv,_ZTv0_n20_N6G221333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G221333fooEv,_ZTv0_n12_N6G221333fooEv),
};
extern VTBL_ENTRY _ZTV6G22133[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G22133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
extern void ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G22133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G22133[] = {
  {&(_ZTV6G22133[6]),  6,28},
  {&(_ZTV6G22133[12]),  12,28},
  {&(_ZTV6G22133[16]),  16,28},
  {&(_ZTV6G22133[22]),  22,28},
  {&(_ZTV6G22133[27]),  27,28},
  {&(_tg__ZTV3E22__6G22133[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22133[3]),  3,4},
  {&(_tg__ZTV3F13__6G22133[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G22133[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22133[];
extern  VTBL_ENTRY _ZTV6G22133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22133[];
static VTBL_ENTRY alt_thunk_names123[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221333fooEv,_ZTv0_n12_N6G221333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G221333fooEv,_ZThn32_N6G221333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G221333barEv,_ZTv0_n20_N6G221333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G221333barEv,_ZThn24_N6G221333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221333fooEv,_ZTv0_n16_N6G221333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G221333fooEv,_ZThn24_N6G221333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G221333barEv,_ZTv0_n12_N6G221333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G221333barEv,_ZThn16_N6G221333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G221333barEv,_ZTv0_n16_N6G221333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G221333barEv,_ZThn8_N6G221333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22133 = {  "G22133", // class name
  bases_G22133, 4,
  &(vtc_G22133[0]), // expected_vtbl_contents
  &(vtt_G22133[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22133),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22133),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names123,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22212  : virtual E22 , virtual F21 {
  int pg;
  virtual void  bar(); // _ZN6G222123barEv
  ~G22212(); // tgen
  G22212(); // tgen
};
//SIG(1 G22212) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v2 Fi} v1 Fi}


void  G22212 ::bar(){vfunc_called(this, "_ZN6G222123barEv");}
G22212 ::~G22212(){ note_dtor("G22212", this);} // tgen
G22212 ::G22212(){ note_ctor("G22212", this);} // tgen

static void Test_G22212()
{
  extern Class_Descriptor cd_G22212;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G22212, buf);
    G22212 *dp, &lv = *(dp=new (buf) G22212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G22212)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22212)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22212");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(32,16), "G22212");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22212");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G22212");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22212.pg");
    test_class_info(&lv, &cd_G22212);
    dp->~G22212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22212(Test_G22212, "G22212", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G22212C1Ev();
extern void _ZN6G22212D1Ev();
Name_Map name_map_G22212[] = {
  NSPAIR(_ZN6G22212C1Ev),
  NSPAIR(_ZN6G22212D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G22212[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22212[];
extern void _ZN6G222123barEv();
extern void ABISELECT(_ZTv0_n32_N6G222123barEv,_ZTv0_n16_N6G222123barEv)();
extern void ABISELECT(_ZThn16_N6G222123barEv,_ZThn8_N6G222123barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G222123barEv,_ZTv0_n12_N6G222123barEv)();
extern void ABISELECT(_ZThn32_N6G222123barEv,_ZThn16_N6G222123barEv)() __attribute__((weak));
extern void _ZN3F213fooEv();
static  VTBL_ENTRY vtc_G22212[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22212[0]),
  (VTBL_ENTRY)&_ZN6G222123barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22212[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222123barEv,_ZTv0_n16_N6G222123barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22212[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G222123barEv,_ZTv0_n12_N6G222123barEv),
  0,
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22212[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern VTBL_ENTRY _ZTV6G22212[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22212[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22212[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G22212[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G22212[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G22212[] = {
  {&(_ZTV6G22212[5]),  5,20},
  {&(_ZTV6G22212[10]),  10,20},
  {&(_ZTV6G22212[14]),  14,20},
  {&(_ZTV6G22212[19]),  19,20},
  {&(_tg__ZTV3E22__6G22212[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22212[3]),  3,4},
  {&(_tg__ZTV3F21__6G22212[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G22212[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22212[];
extern  VTBL_ENTRY _ZTV6G22212[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22212[];
static VTBL_ENTRY alt_thunk_names124[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G222123barEv,_ZTv0_n12_N6G222123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G222123barEv,_ZThn16_N6G222123barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222123barEv,_ZTv0_n16_N6G222123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G222123barEv,_ZThn8_N6G222123barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22212 = {  "G22212", // class name
  bases_G22212, 3,
  &(vtc_G22212[0]), // expected_vtbl_contents
  &(vtt_G22212[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G22212),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22212),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22212),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names124,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22213  : virtual E22 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G222133fooEv
  virtual void  bar(); // _ZN6G222133barEv
  ~G22213(); // tgen
  G22213(); // tgen
};
//SIG(1 G22213) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC3 v1 Fi} v1 v2 Fi}


void  G22213 ::foo(){vfunc_called(this, "_ZN6G222133fooEv");}
void  G22213 ::bar(){vfunc_called(this, "_ZN6G222133barEv");}
G22213 ::~G22213(){ note_dtor("G22213", this);} // tgen
G22213 ::G22213(){ note_ctor("G22213", this);} // tgen

static void Test_G22213()
{
  extern Class_Descriptor cd_G22213;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G22213, buf);
    G22213 *dp, &lv = *(dp=new (buf) G22213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G22213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22213)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22213");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(32,16), "G22213");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22213");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G22213");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22213.pg");
    test_class_info(&lv, &cd_G22213);
    dp->~G22213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22213(Test_G22213, "G22213", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G22213C1Ev();
extern void _ZN6G22213D1Ev();
Name_Map name_map_G22213[] = {
  NSPAIR(_ZN6G22213C1Ev),
  NSPAIR(_ZN6G22213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G22213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22213[];
extern void _ZN6G222133fooEv();
extern void _ZN6G222133barEv();
extern void ABISELECT(_ZTv0_n32_N6G222133barEv,_ZTv0_n16_N6G222133barEv)();
extern void ABISELECT(_ZThn16_N6G222133barEv,_ZThn8_N6G222133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G222133barEv,_ZTv0_n12_N6G222133barEv)();
extern void ABISELECT(_ZThn32_N6G222133barEv,_ZThn16_N6G222133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G222133fooEv,_ZTv0_n16_N6G222133fooEv)();
extern void ABISELECT(_ZThn48_N6G222133fooEv,_ZThn24_N6G222133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22213[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22213[0]),
  (VTBL_ENTRY)&_ZN6G222133fooEv,
  (VTBL_ENTRY)&_ZN6G222133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222133barEv,_ZTv0_n16_N6G222133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G222133barEv,_ZTv0_n12_N6G222133barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222133fooEv,_ZTv0_n16_N6G222133fooEv),
};
extern VTBL_ENTRY _ZTV6G22213[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22213[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G22213[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G22213[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G22213[] = {
  {&(_ZTV6G22213[5]),  5,21},
  {&(_ZTV6G22213[11]),  11,21},
  {&(_ZTV6G22213[15]),  15,21},
  {&(_ZTV6G22213[20]),  20,21},
  {&(_tg__ZTV3E22__6G22213[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22213[3]),  3,4},
  {&(_tg__ZTV3F21__6G22213[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G22213[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22213[];
extern  VTBL_ENTRY _ZTV6G22213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22213[];
static VTBL_ENTRY alt_thunk_names125[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222133fooEv,_ZTv0_n16_N6G222133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G222133fooEv,_ZThn24_N6G222133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G222133barEv,_ZTv0_n12_N6G222133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G222133barEv,_ZThn16_N6G222133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222133barEv,_ZTv0_n16_N6G222133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G222133barEv,_ZThn8_N6G222133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22213 = {  "G22213", // class name
  bases_G22213, 3,
  &(vtc_G22213[0]), // expected_vtbl_contents
  &(vtt_G22213[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G22213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22213),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22213),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names125,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22222  : virtual E22 , virtual F22 {
  int pg;
  virtual void  bar(); // _ZN6G222223barEv
  ~G22222(); // tgen
  G22222(); // tgen
};
//SIG(1 G22222) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v1 Fi} v1 Fi}


void  G22222 ::bar(){vfunc_called(this, "_ZN6G222223barEv");}
G22222 ::~G22222(){ note_dtor("G22222", this);} // tgen
G22222 ::G22222(){ note_ctor("G22222", this);} // tgen

static void Test_G22222()
{
  extern Class_Descriptor cd_G22222;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G22222, buf);
    G22222 *dp, &lv = *(dp=new (buf) G22222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G22222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22222)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22222");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(32,16), "G22222");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22222");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G22222");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22222.pg");
    test_class_info(&lv, &cd_G22222);
    dp->~G22222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22222(Test_G22222, "G22222", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G22222C1Ev();
extern void _ZN6G22222D1Ev();
Name_Map name_map_G22222[] = {
  NSPAIR(_ZN6G22222C1Ev),
  NSPAIR(_ZN6G22222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G22222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22222[];
extern void _ZN6G222223barEv();
extern void ABISELECT(_ZTv0_n32_N6G222223barEv,_ZTv0_n16_N6G222223barEv)();
extern void ABISELECT(_ZThn16_N6G222223barEv,_ZThn8_N6G222223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G222223barEv,_ZTv0_n12_N6G222223barEv)();
extern void ABISELECT(_ZThn32_N6G222223barEv,_ZThn16_N6G222223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G222223barEv,_ZTv0_n16_N6G222223barEv)();
extern void ABISELECT(_ZThn48_N6G222223barEv,_ZThn24_N6G222223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22222[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22222[0]),
  (VTBL_ENTRY)&_ZN6G222223barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222223barEv,_ZTv0_n16_N6G222223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G222223barEv,_ZTv0_n12_N6G222223barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222223barEv,_ZTv0_n16_N6G222223barEv),
};
extern VTBL_ENTRY _ZTV6G22222[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22222[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G22222[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G22222[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G22222[] = {
  {&(_ZTV6G22222[5]),  5,20},
  {&(_ZTV6G22222[10]),  10,20},
  {&(_ZTV6G22222[14]),  14,20},
  {&(_ZTV6G22222[19]),  19,20},
  {&(_tg__ZTV3E22__6G22222[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22222[3]),  3,4},
  {&(_tg__ZTV3F22__6G22222[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G22222[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22222[];
extern  VTBL_ENTRY _ZTV6G22222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22222[];
static VTBL_ENTRY alt_thunk_names126[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G222223barEv,_ZTv0_n12_N6G222223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G222223barEv,_ZThn16_N6G222223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222223barEv,_ZTv0_n16_N6G222223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G222223barEv,_ZThn24_N6G222223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G222223barEv,_ZThn8_N6G222223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22222 = {  "G22222", // class name
  bases_G22222, 3,
  &(vtc_G22222[0]), // expected_vtbl_contents
  &(vtt_G22222[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G22222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22222),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22222),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names126,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22223  : virtual E22 , virtual F22 {
  int pg;
  virtual void  foo(); // _ZN6G222233fooEv
  virtual void  bar(); // _ZN6G222233barEv
  ~G22223(); // tgen
  G22223(); // tgen
};
//SIG(1 G22223) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC3 v2 Fi} v1 v2 Fi}


void  G22223 ::foo(){vfunc_called(this, "_ZN6G222233fooEv");}
void  G22223 ::bar(){vfunc_called(this, "_ZN6G222233barEv");}
G22223 ::~G22223(){ note_dtor("G22223", this);} // tgen
G22223 ::G22223(){ note_ctor("G22223", this);} // tgen

static void Test_G22223()
{
  extern Class_Descriptor cd_G22223;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G22223, buf);
    G22223 *dp, &lv = *(dp=new (buf) G22223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G22223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22223)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22223");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(32,16), "G22223");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22223");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G22223");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22223.pg");
    test_class_info(&lv, &cd_G22223);
    dp->~G22223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22223(Test_G22223, "G22223", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G22223C1Ev();
extern void _ZN6G22223D1Ev();
Name_Map name_map_G22223[] = {
  NSPAIR(_ZN6G22223C1Ev),
  NSPAIR(_ZN6G22223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G22223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22223[];
extern void _ZN6G222233fooEv();
extern void _ZN6G222233barEv();
extern void ABISELECT(_ZTv0_n32_N6G222233barEv,_ZTv0_n16_N6G222233barEv)();
extern void ABISELECT(_ZThn16_N6G222233barEv,_ZThn8_N6G222233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G222233barEv,_ZTv0_n12_N6G222233barEv)();
extern void ABISELECT(_ZThn32_N6G222233barEv,_ZThn16_N6G222233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G222233barEv,_ZTv0_n16_N6G222233barEv)();
extern void ABISELECT(_ZThn48_N6G222233barEv,_ZThn24_N6G222233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22223[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22223[0]),
  (VTBL_ENTRY)&_ZN6G222233fooEv,
  (VTBL_ENTRY)&_ZN6G222233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222233barEv,_ZTv0_n16_N6G222233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G222233barEv,_ZTv0_n12_N6G222233barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222233barEv,_ZTv0_n16_N6G222233barEv),
};
extern VTBL_ENTRY _ZTV6G22223[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22223[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G22223[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G22223[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G22223[] = {
  {&(_ZTV6G22223[5]),  5,21},
  {&(_ZTV6G22223[11]),  11,21},
  {&(_ZTV6G22223[15]),  15,21},
  {&(_ZTV6G22223[20]),  20,21},
  {&(_tg__ZTV3E22__6G22223[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22223[3]),  3,4},
  {&(_tg__ZTV3F22__6G22223[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G22223[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22223[];
extern  VTBL_ENTRY _ZTV6G22223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22223[];
static VTBL_ENTRY alt_thunk_names127[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G222233barEv,_ZTv0_n12_N6G222233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G222233barEv,_ZThn16_N6G222233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222233barEv,_ZTv0_n16_N6G222233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G222233barEv,_ZThn24_N6G222233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G222233barEv,_ZThn8_N6G222233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22223 = {  "G22223", // class name
  bases_G22223, 3,
  &(vtc_G22223[0]), // expected_vtbl_contents
  &(vtt_G22223[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G22223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22223),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22223),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names127,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22232  : virtual E22 , virtual F23 {
  int pg;
  virtual void  bar(); // _ZN6G222323barEv
  ~G22232(); // tgen
  G22232(); // tgen
};
//SIG(1 G22232) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC3 v2 v1 Fi} v1 Fi}


void  G22232 ::bar(){vfunc_called(this, "_ZN6G222323barEv");}
G22232 ::~G22232(){ note_dtor("G22232", this);} // tgen
G22232 ::G22232(){ note_ctor("G22232", this);} // tgen

static void Test_G22232()
{
  extern Class_Descriptor cd_G22232;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G22232, buf);
    G22232 *dp, &lv = *(dp=new (buf) G22232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G22232)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22232)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22232");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(32,16), "G22232");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22232");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G22232");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22232.pg");
    test_class_info(&lv, &cd_G22232);
    dp->~G22232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22232(Test_G22232, "G22232", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G22232C1Ev();
extern void _ZN6G22232D1Ev();
Name_Map name_map_G22232[] = {
  NSPAIR(_ZN6G22232C1Ev),
  NSPAIR(_ZN6G22232D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G22232[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22232[];
extern void _ZN6G222323barEv();
extern void ABISELECT(_ZTv0_n32_N6G222323barEv,_ZTv0_n16_N6G222323barEv)();
extern void ABISELECT(_ZThn16_N6G222323barEv,_ZThn8_N6G222323barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G222323barEv,_ZTv0_n12_N6G222323barEv)();
extern void ABISELECT(_ZThn32_N6G222323barEv,_ZThn16_N6G222323barEv)() __attribute__((weak));
extern void _ZN3F233fooEv();
extern void ABISELECT(_ZTv0_n40_N6G222323barEv,_ZTv0_n20_N6G222323barEv)();
extern void ABISELECT(_ZThn48_N6G222323barEv,_ZThn24_N6G222323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22232[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22232[0]),
  (VTBL_ENTRY)&_ZN6G222323barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22232[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222323barEv,_ZTv0_n16_N6G222323barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22232[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G222323barEv,_ZTv0_n12_N6G222323barEv),
  ABISELECT(-48,-24),
  0,
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22232[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G222323barEv,_ZTv0_n20_N6G222323barEv),
};
extern VTBL_ENTRY _ZTV6G22232[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22232[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22232[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G22232[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G22232[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G22232[] = {
  {&(_ZTV6G22232[5]),  5,22},
  {&(_ZTV6G22232[10]),  10,22},
  {&(_ZTV6G22232[14]),  14,22},
  {&(_ZTV6G22232[20]),  20,22},
  {&(_tg__ZTV3E22__6G22232[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22232[3]),  3,4},
  {&(_tg__ZTV3F23__6G22232[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G22232[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22232[];
extern  VTBL_ENTRY _ZTV6G22232[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22232[];
static VTBL_ENTRY alt_thunk_names128[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G222323barEv,_ZTv0_n20_N6G222323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G222323barEv,_ZThn24_N6G222323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G222323barEv,_ZTv0_n12_N6G222323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G222323barEv,_ZThn16_N6G222323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222323barEv,_ZTv0_n16_N6G222323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G222323barEv,_ZThn8_N6G222323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22232 = {  "G22232", // class name
  bases_G22232, 3,
  &(vtc_G22232[0]), // expected_vtbl_contents
  &(vtt_G22232[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G22232),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22232),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22232),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names128,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22233  : virtual E22 , virtual F23 {
  int pg;
  virtual void  foo(); // _ZN6G222333fooEv
  virtual void  bar(); // _ZN6G222333barEv
  ~G22233(); // tgen
  G22233(); // tgen
};
//SIG(1 G22233) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC3 v1 v2 Fi} v1 v2 Fi}


void  G22233 ::foo(){vfunc_called(this, "_ZN6G222333fooEv");}
void  G22233 ::bar(){vfunc_called(this, "_ZN6G222333barEv");}
G22233 ::~G22233(){ note_dtor("G22233", this);} // tgen
G22233 ::G22233(){ note_ctor("G22233", this);} // tgen

static void Test_G22233()
{
  extern Class_Descriptor cd_G22233;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G22233, buf);
    G22233 *dp, &lv = *(dp=new (buf) G22233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G22233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22233)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22233");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(32,16), "G22233");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22233");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G22233");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22233.pg");
    test_class_info(&lv, &cd_G22233);
    dp->~G22233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22233(Test_G22233, "G22233", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G22233C1Ev();
extern void _ZN6G22233D1Ev();
Name_Map name_map_G22233[] = {
  NSPAIR(_ZN6G22233C1Ev),
  NSPAIR(_ZN6G22233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G22233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22233[];
extern void _ZN6G222333fooEv();
extern void _ZN6G222333barEv();
extern void ABISELECT(_ZTv0_n32_N6G222333barEv,_ZTv0_n16_N6G222333barEv)();
extern void ABISELECT(_ZThn16_N6G222333barEv,_ZThn8_N6G222333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G222333barEv,_ZTv0_n12_N6G222333barEv)();
extern void ABISELECT(_ZThn32_N6G222333barEv,_ZThn16_N6G222333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G222333fooEv,_ZTv0_n16_N6G222333fooEv)();
extern void ABISELECT(_ZThn48_N6G222333fooEv,_ZThn24_N6G222333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G222333barEv,_ZTv0_n20_N6G222333barEv)();
extern void ABISELECT(_ZThn48_N6G222333barEv,_ZThn24_N6G222333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22233[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22233[0]),
  (VTBL_ENTRY)&_ZN6G222333fooEv,
  (VTBL_ENTRY)&_ZN6G222333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222333barEv,_ZTv0_n16_N6G222333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G222333barEv,_ZTv0_n12_N6G222333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G222333fooEv,_ZTv0_n16_N6G222333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G222333barEv,_ZTv0_n20_N6G222333barEv),
};
extern VTBL_ENTRY _ZTV6G22233[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22233[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G22233[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G22233[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G22233[] = {
  {&(_ZTV6G22233[5]),  5,23},
  {&(_ZTV6G22233[11]),  11,23},
  {&(_ZTV6G22233[15]),  15,23},
  {&(_ZTV6G22233[21]),  21,23},
  {&(_tg__ZTV3E22__6G22233[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22233[3]),  3,4},
  {&(_tg__ZTV3F23__6G22233[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G22233[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G22233[];
extern  VTBL_ENTRY _ZTV6G22233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22233[];
static VTBL_ENTRY alt_thunk_names129[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G222333barEv,_ZTv0_n20_N6G222333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G222333barEv,_ZThn24_N6G222333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222333fooEv,_ZTv0_n16_N6G222333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G222333fooEv,_ZThn24_N6G222333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G222333barEv,_ZTv0_n12_N6G222333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G222333barEv,_ZThn16_N6G222333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G222333barEv,_ZTv0_n16_N6G222333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G222333barEv,_ZThn8_N6G222333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22233 = {  "G22233", // class name
  bases_G22233, 3,
  &(vtc_G22233[0]), // expected_vtbl_contents
  &(vtt_G22233[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G22233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22233),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22233),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names129,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22312  : virtual E22 , virtual F31 {
  int pg;
  virtual void  bar(); // _ZN6G223123barEv
  ~G22312(); // tgen
  G22312(); // tgen
};
//SIG(1 G22312) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 v1 Fi} v2 Fi} v1 Fi}


void  G22312 ::bar(){vfunc_called(this, "_ZN6G223123barEv");}
G22312 ::~G22312(){ note_dtor("G22312", this);} // tgen
G22312 ::G22312(){ note_ctor("G22312", this);} // tgen

static void Test_G22312()
{
  extern Class_Descriptor cd_G22312;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22312, buf);
    G22312 *dp, &lv = *(dp=new (buf) G22312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22312)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22312)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22312");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22312");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G22312");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G22312");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22312.pg");
    test_class_info(&lv, &cd_G22312);
    dp->~G22312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22312(Test_G22312, "G22312", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22312C1Ev();
extern void _ZN6G22312D1Ev();
Name_Map name_map_G22312[] = {
  NSPAIR(_ZN6G22312C1Ev),
  NSPAIR(_ZN6G22312D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G22312[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22312[];
extern void _ZN6G223123barEv();
extern void ABISELECT(_ZTv0_n32_N6G223123barEv,_ZTv0_n16_N6G223123barEv)();
extern void ABISELECT(_ZThn16_N6G223123barEv,_ZThn8_N6G223123barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223123barEv,_ZTv0_n12_N6G223123barEv)();
extern void ABISELECT(_ZThn32_N6G223123barEv,_ZThn16_N6G223123barEv)() __attribute__((weak));
extern void _ZN3F313fooEv();
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223123barEv,_ZTv0_n16_N6G223123barEv)();
extern void ABISELECT(_ZThn64_N6G223123barEv,_ZThn32_N6G223123barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22312[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22312[0]),
  (VTBL_ENTRY)&_ZN6G223123barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22312[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223123barEv,_ZTv0_n16_N6G223123barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22312[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223123barEv,_ZTv0_n12_N6G223123barEv),
  0,
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22312[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
  ABISELECT(-64,-32),
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22312[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223123barEv,_ZTv0_n16_N6G223123barEv),
};
extern VTBL_ENTRY _ZTV6G22312[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22312[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22312[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G22312[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G22312[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G22312[] = {
  {&(_ZTV6G22312[6]),  6,27},
  {&(_ZTV6G22312[11]),  11,27},
  {&(_ZTV6G22312[15]),  15,27},
  {&(_ZTV6G22312[20]),  20,27},
  {&(_ZTV6G22312[25]),  25,27},
  {&(_tg__ZTV3E22__6G22312[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22312[3]),  3,4},
  {&(_tg__ZTV3F31__6G22312[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G22312[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G22312[];
extern  VTBL_ENTRY _ZTV6G22312[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22312[];
static VTBL_ENTRY alt_thunk_names130[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223123barEv,_ZTv0_n12_N6G223123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G223123barEv,_ZThn16_N6G223123barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223123barEv,_ZTv0_n16_N6G223123barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223123barEv,_ZThn32_N6G223123barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G223123barEv,_ZThn8_N6G223123barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22312 = {  "G22312", // class name
  bases_G22312, 4,
  &(vtc_G22312[0]), // expected_vtbl_contents
  &(vtt_G22312[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22312),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22312),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22312),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names130,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22313  : virtual E22 , virtual F31 {
  int pg;
  virtual void  foo(); // _ZN6G223133fooEv
  virtual void  bar(); // _ZN6G223133barEv
  ~G22313(); // tgen
  G22313(); // tgen
};
//SIG(1 G22313) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 Fi} v1 v2 Fi}


void  G22313 ::foo(){vfunc_called(this, "_ZN6G223133fooEv");}
void  G22313 ::bar(){vfunc_called(this, "_ZN6G223133barEv");}
G22313 ::~G22313(){ note_dtor("G22313", this);} // tgen
G22313 ::G22313(){ note_ctor("G22313", this);} // tgen

static void Test_G22313()
{
  extern Class_Descriptor cd_G22313;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22313, buf);
    G22313 *dp, &lv = *(dp=new (buf) G22313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22313)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22313");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22313");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G22313");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G22313");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22313.pg");
    test_class_info(&lv, &cd_G22313);
    dp->~G22313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22313(Test_G22313, "G22313", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22313C1Ev();
extern void _ZN6G22313D1Ev();
Name_Map name_map_G22313[] = {
  NSPAIR(_ZN6G22313C1Ev),
  NSPAIR(_ZN6G22313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G22313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22313[];
extern void _ZN6G223133fooEv();
extern void _ZN6G223133barEv();
extern void ABISELECT(_ZTv0_n32_N6G223133barEv,_ZTv0_n16_N6G223133barEv)();
extern void ABISELECT(_ZThn16_N6G223133barEv,_ZThn8_N6G223133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223133barEv,_ZTv0_n12_N6G223133barEv)();
extern void ABISELECT(_ZThn32_N6G223133barEv,_ZThn16_N6G223133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223133fooEv,_ZTv0_n16_N6G223133fooEv)();
extern void ABISELECT(_ZThn48_N6G223133fooEv,_ZThn24_N6G223133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223133fooEv,_ZTv0_n12_N6G223133fooEv)();
extern void ABISELECT(_ZThn64_N6G223133fooEv,_ZThn32_N6G223133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223133barEv,_ZTv0_n16_N6G223133barEv)();
extern void ABISELECT(_ZThn64_N6G223133barEv,_ZThn32_N6G223133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22313[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22313[0]),
  (VTBL_ENTRY)&_ZN6G223133fooEv,
  (VTBL_ENTRY)&_ZN6G223133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223133barEv,_ZTv0_n16_N6G223133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223133barEv,_ZTv0_n12_N6G223133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223133fooEv,_ZTv0_n16_N6G223133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223133fooEv,_ZTv0_n12_N6G223133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223133barEv,_ZTv0_n16_N6G223133barEv),
};
extern VTBL_ENTRY _ZTV6G22313[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22313[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G22313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G22313[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G22313[] = {
  {&(_ZTV6G22313[6]),  6,28},
  {&(_ZTV6G22313[12]),  12,28},
  {&(_ZTV6G22313[16]),  16,28},
  {&(_ZTV6G22313[21]),  21,28},
  {&(_ZTV6G22313[26]),  26,28},
  {&(_tg__ZTV3E22__6G22313[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22313[3]),  3,4},
  {&(_tg__ZTV3F31__6G22313[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G22313[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G22313[];
extern  VTBL_ENTRY _ZTV6G22313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22313[];
static VTBL_ENTRY alt_thunk_names131[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223133fooEv,_ZTv0_n12_N6G223133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223133fooEv,_ZThn32_N6G223133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223133fooEv,_ZTv0_n16_N6G223133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G223133fooEv,_ZThn24_N6G223133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223133barEv,_ZTv0_n12_N6G223133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G223133barEv,_ZThn16_N6G223133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223133barEv,_ZTv0_n16_N6G223133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223133barEv,_ZThn32_N6G223133barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G223133barEv,_ZThn8_N6G223133barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22313 = {  "G22313", // class name
  bases_G22313, 4,
  &(vtc_G22313[0]), // expected_vtbl_contents
  &(vtt_G22313[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22313),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22313),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names131,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22322  : virtual E22 , virtual F32 {
  int pg;
  virtual void  bar(); // _ZN6G223223barEv
  ~G22322(); // tgen
  G22322(); // tgen
};
//SIG(1 G22322) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 v1 Fi} v1 Fi} v1 Fi}


void  G22322 ::bar(){vfunc_called(this, "_ZN6G223223barEv");}
G22322 ::~G22322(){ note_dtor("G22322", this);} // tgen
G22322 ::G22322(){ note_ctor("G22322", this);} // tgen

static void Test_G22322()
{
  extern Class_Descriptor cd_G22322;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22322, buf);
    G22322 *dp, &lv = *(dp=new (buf) G22322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22322)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22322)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22322");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22322");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G22322");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G22322");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22322.pg");
    test_class_info(&lv, &cd_G22322);
    dp->~G22322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22322(Test_G22322, "G22322", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22322C1Ev();
extern void _ZN6G22322D1Ev();
Name_Map name_map_G22322[] = {
  NSPAIR(_ZN6G22322C1Ev),
  NSPAIR(_ZN6G22322D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G22322[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22322[];
extern void _ZN6G223223barEv();
extern void ABISELECT(_ZTv0_n32_N6G223223barEv,_ZTv0_n16_N6G223223barEv)();
extern void ABISELECT(_ZThn16_N6G223223barEv,_ZThn8_N6G223223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223223barEv,_ZTv0_n12_N6G223223barEv)();
extern void ABISELECT(_ZThn32_N6G223223barEv,_ZThn16_N6G223223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223223barEv,_ZTv0_n16_N6G223223barEv)();
extern void ABISELECT(_ZThn48_N6G223223barEv,_ZThn24_N6G223223barEv)() __attribute__((weak));
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N6G223223barEv,_ZTv0_n16_N6G223223barEv)();
extern void ABISELECT(_ZThn64_N6G223223barEv,_ZThn32_N6G223223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22322[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22322[0]),
  (VTBL_ENTRY)&_ZN6G223223barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22322[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223223barEv,_ZTv0_n16_N6G223223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22322[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223223barEv,_ZTv0_n12_N6G223223barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22322[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223223barEv,_ZTv0_n16_N6G223223barEv),
  ABISELECT(-64,-32),
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22322[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223223barEv,_ZTv0_n16_N6G223223barEv),
};
extern VTBL_ENTRY _ZTV6G22322[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22322[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22322[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G22322[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G22322[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G22322[] = {
  {&(_ZTV6G22322[6]),  6,27},
  {&(_ZTV6G22322[11]),  11,27},
  {&(_ZTV6G22322[15]),  15,27},
  {&(_ZTV6G22322[20]),  20,27},
  {&(_ZTV6G22322[25]),  25,27},
  {&(_tg__ZTV3E22__6G22322[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22322[3]),  3,4},
  {&(_tg__ZTV3F32__6G22322[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G22322[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G22322[];
extern  VTBL_ENTRY _ZTV6G22322[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22322[];
static VTBL_ENTRY alt_thunk_names132[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223223barEv,_ZTv0_n12_N6G223223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G223223barEv,_ZThn16_N6G223223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223223barEv,_ZTv0_n16_N6G223223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223223barEv,_ZThn32_N6G223223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G223223barEv,_ZThn24_N6G223223barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G223223barEv,_ZThn8_N6G223223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22322 = {  "G22322", // class name
  bases_G22322, 4,
  &(vtc_G22322[0]), // expected_vtbl_contents
  &(vtt_G22322[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22322),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22322),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22322),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names132,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22323  : virtual E22 , virtual F32 {
  int pg;
  virtual void  foo(); // _ZN6G223233fooEv
  virtual void  bar(); // _ZN6G223233barEv
  ~G22323(); // tgen
  G22323(); // tgen
};
//SIG(1 G22323) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v2 Fi} v1 v2 Fi}


void  G22323 ::foo(){vfunc_called(this, "_ZN6G223233fooEv");}
void  G22323 ::bar(){vfunc_called(this, "_ZN6G223233barEv");}
G22323 ::~G22323(){ note_dtor("G22323", this);} // tgen
G22323 ::G22323(){ note_ctor("G22323", this);} // tgen

static void Test_G22323()
{
  extern Class_Descriptor cd_G22323;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22323, buf);
    G22323 *dp, &lv = *(dp=new (buf) G22323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22323)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22323");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22323");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G22323");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G22323");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22323.pg");
    test_class_info(&lv, &cd_G22323);
    dp->~G22323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22323(Test_G22323, "G22323", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22323C1Ev();
extern void _ZN6G22323D1Ev();
Name_Map name_map_G22323[] = {
  NSPAIR(_ZN6G22323C1Ev),
  NSPAIR(_ZN6G22323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G22323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22323[];
extern void _ZN6G223233fooEv();
extern void _ZN6G223233barEv();
extern void ABISELECT(_ZTv0_n32_N6G223233barEv,_ZTv0_n16_N6G223233barEv)();
extern void ABISELECT(_ZThn16_N6G223233barEv,_ZThn8_N6G223233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223233barEv,_ZTv0_n12_N6G223233barEv)();
extern void ABISELECT(_ZThn32_N6G223233barEv,_ZThn16_N6G223233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223233barEv,_ZTv0_n16_N6G223233barEv)();
extern void ABISELECT(_ZThn48_N6G223233barEv,_ZThn24_N6G223233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223233fooEv,_ZTv0_n12_N6G223233fooEv)();
extern void ABISELECT(_ZThn64_N6G223233fooEv,_ZThn32_N6G223233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223233barEv,_ZTv0_n16_N6G223233barEv)();
extern void ABISELECT(_ZThn64_N6G223233barEv,_ZThn32_N6G223233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22323[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22323[0]),
  (VTBL_ENTRY)&_ZN6G223233fooEv,
  (VTBL_ENTRY)&_ZN6G223233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223233barEv,_ZTv0_n16_N6G223233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223233barEv,_ZTv0_n12_N6G223233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223233barEv,_ZTv0_n16_N6G223233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223233fooEv,_ZTv0_n12_N6G223233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223233barEv,_ZTv0_n16_N6G223233barEv),
};
extern VTBL_ENTRY _ZTV6G22323[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22323[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G22323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G22323[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G22323[] = {
  {&(_ZTV6G22323[6]),  6,28},
  {&(_ZTV6G22323[12]),  12,28},
  {&(_ZTV6G22323[16]),  16,28},
  {&(_ZTV6G22323[21]),  21,28},
  {&(_ZTV6G22323[26]),  26,28},
  {&(_tg__ZTV3E22__6G22323[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22323[3]),  3,4},
  {&(_tg__ZTV3F32__6G22323[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G22323[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G22323[];
extern  VTBL_ENTRY _ZTV6G22323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22323[];
static VTBL_ENTRY alt_thunk_names133[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223233fooEv,_ZTv0_n12_N6G223233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223233fooEv,_ZThn32_N6G223233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223233barEv,_ZTv0_n12_N6G223233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G223233barEv,_ZThn16_N6G223233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223233barEv,_ZTv0_n16_N6G223233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223233barEv,_ZThn32_N6G223233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G223233barEv,_ZThn24_N6G223233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G223233barEv,_ZThn8_N6G223233barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22323 = {  "G22323", // class name
  bases_G22323, 4,
  &(vtc_G22323[0]), // expected_vtbl_contents
  &(vtt_G22323[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22323),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22323),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names133,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22332  : virtual E22 , virtual F33 {
  int pg;
  virtual void  bar(); // _ZN6G223323barEv
  ~G22332(); // tgen
  G22332(); // tgen
};
//SIG(1 G22332) C1{ VBC2{ VBC3{ v1 Fi} v1 Fi} VBC4{ VBC5{ v2 v1 Fi} v2 v1 Fi} v1 Fi}


void  G22332 ::bar(){vfunc_called(this, "_ZN6G223323barEv");}
G22332 ::~G22332(){ note_dtor("G22332", this);} // tgen
G22332 ::G22332(){ note_ctor("G22332", this);} // tgen

static void Test_G22332()
{
  extern Class_Descriptor cd_G22332;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22332, buf);
    G22332 *dp, &lv = *(dp=new (buf) G22332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22332)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22332)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22332");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22332");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G22332");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G22332");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22332.pg");
    test_class_info(&lv, &cd_G22332);
    dp->~G22332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22332(Test_G22332, "G22332", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22332C1Ev();
extern void _ZN6G22332D1Ev();
Name_Map name_map_G22332[] = {
  NSPAIR(_ZN6G22332C1Ev),
  NSPAIR(_ZN6G22332D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G22332[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22332[];
extern void _ZN6G223323barEv();
extern void ABISELECT(_ZTv0_n32_N6G223323barEv,_ZTv0_n16_N6G223323barEv)();
extern void ABISELECT(_ZThn16_N6G223323barEv,_ZThn8_N6G223323barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223323barEv,_ZTv0_n12_N6G223323barEv)();
extern void ABISELECT(_ZThn32_N6G223323barEv,_ZThn16_N6G223323barEv)() __attribute__((weak));
extern void _ZN3F333fooEv();
extern void ABISELECT(_ZTv0_n40_N6G223323barEv,_ZTv0_n20_N6G223323barEv)();
extern void ABISELECT(_ZThn48_N6G223323barEv,_ZThn24_N6G223323barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223323barEv,_ZTv0_n16_N6G223323barEv)();
extern void ABISELECT(_ZThn64_N6G223323barEv,_ZThn32_N6G223323barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22332[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22332[0]),
  (VTBL_ENTRY)&_ZN6G223323barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22332[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223323barEv,_ZTv0_n16_N6G223323barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22332[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223323barEv,_ZTv0_n12_N6G223323barEv),
  ABISELECT(-48,-24),
  0,
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22332[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G223323barEv,_ZTv0_n20_N6G223323barEv),
  ABISELECT(-64,-32),
  ABISELECT(-16,-8),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22332[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223323barEv,_ZTv0_n16_N6G223323barEv),
};
extern VTBL_ENTRY _ZTV6G22332[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22332[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22332[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G22332[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G22332[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G22332[] = {
  {&(_ZTV6G22332[6]),  6,29},
  {&(_ZTV6G22332[11]),  11,29},
  {&(_ZTV6G22332[15]),  15,29},
  {&(_ZTV6G22332[21]),  21,29},
  {&(_ZTV6G22332[27]),  27,29},
  {&(_tg__ZTV3E22__6G22332[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22332[3]),  3,4},
  {&(_tg__ZTV3F33__6G22332[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G22332[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G22332[];
extern  VTBL_ENTRY _ZTV6G22332[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22332[];
static VTBL_ENTRY alt_thunk_names134[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G223323barEv,_ZTv0_n20_N6G223323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G223323barEv,_ZThn24_N6G223323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223323barEv,_ZTv0_n12_N6G223323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G223323barEv,_ZThn16_N6G223323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223323barEv,_ZTv0_n16_N6G223323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223323barEv,_ZThn32_N6G223323barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G223323barEv,_ZThn8_N6G223323barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22332 = {  "G22332", // class name
  bases_G22332, 4,
  &(vtc_G22332[0]), // expected_vtbl_contents
  &(vtt_G22332[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22332),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22332),29, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22332),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names134,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G22333  : virtual E22 , virtual F33 {
  int pg;
  virtual void  foo(); // _ZN6G223333fooEv
  virtual void  bar(); // _ZN6G223333barEv
  ~G22333(); // tgen
  G22333(); // tgen
};
//SIG(1 G22333) C1{ VBC2{ VBC3{ v2 Fi} v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G22333 ::foo(){vfunc_called(this, "_ZN6G223333fooEv");}
void  G22333 ::bar(){vfunc_called(this, "_ZN6G223333barEv");}
G22333 ::~G22333(){ note_dtor("G22333", this);} // tgen
G22333 ::G22333(){ note_ctor("G22333", this);} // tgen

static void Test_G22333()
{
  extern Class_Descriptor cd_G22333;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G22333, buf);
    G22333 *dp, &lv = *(dp=new (buf) G22333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G22333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G22333)");
    check_base_class_offset(lv, (AA2*)(E22*), ABISELECT(32,16), "G22333");
    check_base_class_offset(lv, (E22*), ABISELECT(16,8), "G22333");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G22333");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G22333");
    check_field_offset(lv, pg, ABISELECT(8,4), "G22333.pg");
    test_class_info(&lv, &cd_G22333);
    dp->~G22333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG22333(Test_G22333, "G22333", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G22333C1Ev();
extern void _ZN6G22333D1Ev();
Name_Map name_map_G22333[] = {
  NSPAIR(_ZN6G22333C1Ev),
  NSPAIR(_ZN6G22333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E22;
extern VTBL_ENTRY _ZTI3E22[];
extern  VTBL_ENTRY _ZTV3E22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E22[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G22333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E22,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G22333[];
extern void _ZN6G223333fooEv();
extern void _ZN6G223333barEv();
extern void ABISELECT(_ZTv0_n32_N6G223333barEv,_ZTv0_n16_N6G223333barEv)();
extern void ABISELECT(_ZThn16_N6G223333barEv,_ZThn8_N6G223333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223333barEv,_ZTv0_n12_N6G223333barEv)();
extern void ABISELECT(_ZThn32_N6G223333barEv,_ZThn16_N6G223333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223333fooEv,_ZTv0_n16_N6G223333fooEv)();
extern void ABISELECT(_ZThn48_N6G223333fooEv,_ZThn24_N6G223333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G223333barEv,_ZTv0_n20_N6G223333barEv)();
extern void ABISELECT(_ZThn48_N6G223333barEv,_ZThn24_N6G223333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G223333fooEv,_ZTv0_n12_N6G223333fooEv)();
extern void ABISELECT(_ZThn64_N6G223333fooEv,_ZThn32_N6G223333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G223333barEv,_ZTv0_n16_N6G223333barEv)();
extern void ABISELECT(_ZThn64_N6G223333barEv,_ZThn32_N6G223333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G22333[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G22333[0]),
  (VTBL_ENTRY)&_ZN6G223333fooEv,
  (VTBL_ENTRY)&_ZN6G223333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G22333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223333barEv,_ZTv0_n16_N6G223333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G22333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223333barEv,_ZTv0_n12_N6G223333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G22333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223333fooEv,_ZTv0_n16_N6G223333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G223333barEv,_ZTv0_n20_N6G223333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G22333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G223333fooEv,_ZTv0_n12_N6G223333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G223333barEv,_ZTv0_n16_N6G223333barEv),
};
extern VTBL_ENTRY _ZTV6G22333[];
extern void _ZN3E223barEv();
static  VTBL_ENTRY _tg__ZTV3E22__6G22333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&_ZN3E223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv)();
extern void ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E22__6G22333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv),
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G22333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G22333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G22333[] = {
  {&(_ZTV6G22333[6]),  6,30},
  {&(_ZTV6G22333[12]),  12,30},
  {&(_ZTV6G22333[16]),  16,30},
  {&(_ZTV6G22333[22]),  22,30},
  {&(_ZTV6G22333[28]),  28,30},
  {&(_tg__ZTV3E22__6G22333[3]),  3,4},
  {&(_tg__ZTV3AA2__3E22__6G22333[3]),  3,4},
  {&(_tg__ZTV3F33__6G22333[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G22333[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G22333[];
extern  VTBL_ENTRY _ZTV6G22333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G22333[];
static VTBL_ENTRY alt_thunk_names135[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E223barEv,_ZTv0_n12_N3E223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E223barEv,_ZThn8_N3E223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223333fooEv,_ZTv0_n12_N6G223333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223333fooEv,_ZThn32_N6G223333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G223333barEv,_ZTv0_n20_N6G223333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G223333barEv,_ZThn24_N6G223333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223333fooEv,_ZTv0_n16_N6G223333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G223333fooEv,_ZThn24_N6G223333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G223333barEv,_ZTv0_n12_N6G223333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G223333barEv,_ZThn16_N6G223333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G223333barEv,_ZTv0_n16_N6G223333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G223333barEv,_ZThn32_N6G223333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G223333barEv,_ZThn8_N6G223333barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G22333 = {  "G22333", // class name
  bases_G22333, 4,
  &(vtc_G22333[0]), // expected_vtbl_contents
  &(vtt_G22333[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G22333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G22333),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G22333),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names135,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23111  : virtual E23 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G231113fooEv
  ~G23111(); // tgen
  G23111(); // tgen
};
//SIG(1 G23111) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 Fi}


void  G23111 ::foo(){vfunc_called(this, "_ZN6G231113fooEv");}
G23111 ::~G23111(){ note_dtor("G23111", this);} // tgen
G23111 ::G23111(){ note_ctor("G23111", this);} // tgen

static void Test_G23111()
{
  extern Class_Descriptor cd_G23111;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G23111, buf);
    G23111 *dp, &lv = *(dp=new (buf) G23111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G23111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23111)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23111");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23111");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G23111");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G23111");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23111.pg");
    test_class_info(&lv, &cd_G23111);
    dp->~G23111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23111(Test_G23111, "G23111", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G23111C1Ev();
extern void _ZN6G23111D1Ev();
Name_Map name_map_G23111[] = {
  NSPAIR(_ZN6G23111C1Ev),
  NSPAIR(_ZN6G23111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G23111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23111[];
extern void _ZN6G231113fooEv();
extern void ABISELECT(_ZTv0_n32_N6G231113fooEv,_ZTv0_n16_N6G231113fooEv)();
extern void ABISELECT(_ZThn16_N6G231113fooEv,_ZThn8_N6G231113fooEv)() __attribute__((weak));
extern void _ZN3E233barEv();
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G231113fooEv,_ZTv0_n16_N6G231113fooEv)();
extern void ABISELECT(_ZThn48_N6G231113fooEv,_ZThn24_N6G231113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G231113fooEv,_ZTv0_n12_N6G231113fooEv)();
extern void ABISELECT(_ZThn64_N6G231113fooEv,_ZThn32_N6G231113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23111[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23111[0]),
  (VTBL_ENTRY)&_ZN6G231113fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231113fooEv,_ZTv0_n16_N6G231113fooEv),
  (VTBL_ENTRY)&_ZN3E233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231113fooEv,_ZTv0_n16_N6G231113fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G23111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G231113fooEv,_ZTv0_n12_N6G231113fooEv),
};
extern VTBL_ENTRY _ZTV6G23111[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G23111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G23111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G23111[] = {
  {&(_ZTV6G23111[6]),  6,27},
  {&(_ZTV6G23111[12]),  12,27},
  {&(_ZTV6G23111[17]),  17,27},
  {&(_ZTV6G23111[22]),  22,27},
  {&(_ZTV6G23111[26]),  26,27},
  {&(_tg__ZTV3E23__6G23111[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23111[3]),  3,4},
  {&(_tg__ZTV3F11__6G23111[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G23111[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23111[];
extern  VTBL_ENTRY _ZTV6G23111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23111[];
static VTBL_ENTRY alt_thunk_names136[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G231113fooEv,_ZTv0_n12_N6G231113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G231113fooEv,_ZThn32_N6G231113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G231113fooEv,_ZTv0_n16_N6G231113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G231113fooEv,_ZThn24_N6G231113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G231113fooEv,_ZThn8_N6G231113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23111 = {  "G23111", // class name
  bases_G23111, 4,
  &(vtc_G23111[0]), // expected_vtbl_contents
  &(vtt_G23111[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G23111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23111),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23111),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names136,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23113  : virtual E23 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G231133fooEv
  virtual void  bar(); // _ZN6G231133barEv
  ~G23113(); // tgen
  G23113(); // tgen
};
//SIG(1 G23113) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 v2 Fi}


void  G23113 ::foo(){vfunc_called(this, "_ZN6G231133fooEv");}
void  G23113 ::bar(){vfunc_called(this, "_ZN6G231133barEv");}
G23113 ::~G23113(){ note_dtor("G23113", this);} // tgen
G23113 ::G23113(){ note_ctor("G23113", this);} // tgen

static void Test_G23113()
{
  extern Class_Descriptor cd_G23113;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G23113, buf);
    G23113 *dp, &lv = *(dp=new (buf) G23113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G23113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23113)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23113");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23113");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G23113");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G23113");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23113.pg");
    test_class_info(&lv, &cd_G23113);
    dp->~G23113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23113(Test_G23113, "G23113", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G23113C1Ev();
extern void _ZN6G23113D1Ev();
Name_Map name_map_G23113[] = {
  NSPAIR(_ZN6G23113C1Ev),
  NSPAIR(_ZN6G23113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G23113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23113[];
extern void _ZN6G231133fooEv();
extern void _ZN6G231133barEv();
extern void ABISELECT(_ZTv0_n32_N6G231133fooEv,_ZTv0_n16_N6G231133fooEv)();
extern void ABISELECT(_ZThn16_N6G231133fooEv,_ZThn8_N6G231133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G231133barEv,_ZTv0_n20_N6G231133barEv)();
extern void ABISELECT(_ZThn16_N6G231133barEv,_ZThn8_N6G231133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G231133barEv,_ZTv0_n12_N6G231133barEv)();
extern void ABISELECT(_ZThn32_N6G231133barEv,_ZThn16_N6G231133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G231133fooEv,_ZTv0_n16_N6G231133fooEv)();
extern void ABISELECT(_ZThn48_N6G231133fooEv,_ZThn24_N6G231133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G231133fooEv,_ZTv0_n12_N6G231133fooEv)();
extern void ABISELECT(_ZThn64_N6G231133fooEv,_ZThn32_N6G231133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23113[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23113[0]),
  (VTBL_ENTRY)&_ZN6G231133fooEv,
  (VTBL_ENTRY)&_ZN6G231133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231133fooEv,_ZTv0_n16_N6G231133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G231133barEv,_ZTv0_n20_N6G231133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G231133barEv,_ZTv0_n12_N6G231133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231133fooEv,_ZTv0_n16_N6G231133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G23113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G231133fooEv,_ZTv0_n12_N6G231133fooEv),
};
extern VTBL_ENTRY _ZTV6G23113[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G23113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G23113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G23113[] = {
  {&(_ZTV6G23113[6]),  6,28},
  {&(_ZTV6G23113[13]),  13,28},
  {&(_ZTV6G23113[18]),  18,28},
  {&(_ZTV6G23113[23]),  23,28},
  {&(_ZTV6G23113[27]),  27,28},
  {&(_tg__ZTV3E23__6G23113[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23113[3]),  3,4},
  {&(_tg__ZTV3F11__6G23113[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G23113[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23113[];
extern  VTBL_ENTRY _ZTV6G23113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23113[];
static VTBL_ENTRY alt_thunk_names137[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G231133fooEv,_ZTv0_n12_N6G231133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G231133fooEv,_ZThn32_N6G231133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G231133barEv,_ZTv0_n12_N6G231133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G231133barEv,_ZThn16_N6G231133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G231133barEv,_ZTv0_n20_N6G231133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G231133barEv,_ZThn8_N6G231133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G231133fooEv,_ZTv0_n16_N6G231133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G231133fooEv,_ZThn24_N6G231133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G231133fooEv,_ZThn8_N6G231133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23113 = {  "G23113", // class name
  bases_G23113, 4,
  &(vtc_G23113[0]), // expected_vtbl_contents
  &(vtt_G23113[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G23113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23113),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23113),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names137,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23123  : virtual E23 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G231233fooEv
  virtual void  bar(); // _ZN6G231233barEv
  ~G23123(); // tgen
  G23123(); // tgen
};
//SIG(1 G23123) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 Fi} v2 Fi} v1 v2 Fi}


void  G23123 ::foo(){vfunc_called(this, "_ZN6G231233fooEv");}
void  G23123 ::bar(){vfunc_called(this, "_ZN6G231233barEv");}
G23123 ::~G23123(){ note_dtor("G23123", this);} // tgen
G23123 ::G23123(){ note_ctor("G23123", this);} // tgen

static void Test_G23123()
{
  extern Class_Descriptor cd_G23123;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G23123, buf);
    G23123 *dp, &lv = *(dp=new (buf) G23123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G23123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23123)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23123");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23123");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(64,32), "G23123");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G23123");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23123.pg");
    test_class_info(&lv, &cd_G23123);
    dp->~G23123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23123(Test_G23123, "G23123", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G23123C1Ev();
extern void _ZN6G23123D1Ev();
Name_Map name_map_G23123[] = {
  NSPAIR(_ZN6G23123C1Ev),
  NSPAIR(_ZN6G23123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G23123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23123[];
extern void _ZN6G231233fooEv();
extern void _ZN6G231233barEv();
extern void ABISELECT(_ZTv0_n32_N6G231233fooEv,_ZTv0_n16_N6G231233fooEv)();
extern void ABISELECT(_ZThn16_N6G231233fooEv,_ZThn8_N6G231233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G231233barEv,_ZTv0_n20_N6G231233barEv)();
extern void ABISELECT(_ZThn16_N6G231233barEv,_ZThn8_N6G231233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G231233barEv,_ZTv0_n12_N6G231233barEv)();
extern void ABISELECT(_ZThn32_N6G231233barEv,_ZThn16_N6G231233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G231233barEv,_ZTv0_n16_N6G231233barEv)();
extern void ABISELECT(_ZThn48_N6G231233barEv,_ZThn24_N6G231233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G231233fooEv,_ZTv0_n12_N6G231233fooEv)();
extern void ABISELECT(_ZThn64_N6G231233fooEv,_ZThn32_N6G231233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23123[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23123[0]),
  (VTBL_ENTRY)&_ZN6G231233fooEv,
  (VTBL_ENTRY)&_ZN6G231233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231233fooEv,_ZTv0_n16_N6G231233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G231233barEv,_ZTv0_n20_N6G231233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G231233barEv,_ZTv0_n12_N6G231233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231233barEv,_ZTv0_n16_N6G231233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G23123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G231233fooEv,_ZTv0_n12_N6G231233fooEv),
};
extern VTBL_ENTRY _ZTV6G23123[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23123[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G23123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G23123[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G23123[] = {
  {&(_ZTV6G23123[6]),  6,28},
  {&(_ZTV6G23123[13]),  13,28},
  {&(_ZTV6G23123[18]),  18,28},
  {&(_ZTV6G23123[23]),  23,28},
  {&(_ZTV6G23123[27]),  27,28},
  {&(_tg__ZTV3E23__6G23123[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23123[3]),  3,4},
  {&(_tg__ZTV3F12__6G23123[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G23123[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23123[];
extern  VTBL_ENTRY _ZTV6G23123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23123[];
static VTBL_ENTRY alt_thunk_names138[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G231233fooEv,_ZTv0_n12_N6G231233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G231233fooEv,_ZThn32_N6G231233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G231233barEv,_ZTv0_n16_N6G231233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G231233barEv,_ZThn24_N6G231233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G231233barEv,_ZTv0_n12_N6G231233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G231233barEv,_ZThn16_N6G231233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G231233barEv,_ZTv0_n20_N6G231233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G231233barEv,_ZThn8_N6G231233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G231233fooEv,_ZTv0_n16_N6G231233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G231233fooEv,_ZThn8_N6G231233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23123 = {  "G23123", // class name
  bases_G23123, 4,
  &(vtc_G23123[0]), // expected_vtbl_contents
  &(vtt_G23123[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G23123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23123),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23123),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names138,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23133  : virtual E23 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G231333fooEv
  virtual void  bar(); // _ZN6G231333barEv
  ~G23133(); // tgen
  G23133(); // tgen
};
//SIG(1 G23133) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 Fi} v1 v2 Fi} v1 v2 Fi}


void  G23133 ::foo(){vfunc_called(this, "_ZN6G231333fooEv");}
void  G23133 ::bar(){vfunc_called(this, "_ZN6G231333barEv");}
G23133 ::~G23133(){ note_dtor("G23133", this);} // tgen
G23133 ::G23133(){ note_ctor("G23133", this);} // tgen

static void Test_G23133()
{
  extern Class_Descriptor cd_G23133;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G23133, buf);
    G23133 *dp, &lv = *(dp=new (buf) G23133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G23133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23133)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23133");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23133");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(64,32), "G23133");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G23133");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23133.pg");
    test_class_info(&lv, &cd_G23133);
    dp->~G23133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23133(Test_G23133, "G23133", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G23133C1Ev();
extern void _ZN6G23133D1Ev();
Name_Map name_map_G23133[] = {
  NSPAIR(_ZN6G23133C1Ev),
  NSPAIR(_ZN6G23133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G23133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23133[];
extern void _ZN6G231333fooEv();
extern void _ZN6G231333barEv();
extern void ABISELECT(_ZTv0_n32_N6G231333fooEv,_ZTv0_n16_N6G231333fooEv)();
extern void ABISELECT(_ZThn16_N6G231333fooEv,_ZThn8_N6G231333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G231333barEv,_ZTv0_n20_N6G231333barEv)();
extern void ABISELECT(_ZThn16_N6G231333barEv,_ZThn8_N6G231333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G231333barEv,_ZTv0_n12_N6G231333barEv)();
extern void ABISELECT(_ZThn32_N6G231333barEv,_ZThn16_N6G231333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G231333fooEv,_ZTv0_n16_N6G231333fooEv)();
extern void ABISELECT(_ZThn48_N6G231333fooEv,_ZThn24_N6G231333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G231333barEv,_ZTv0_n20_N6G231333barEv)();
extern void ABISELECT(_ZThn48_N6G231333barEv,_ZThn24_N6G231333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G231333fooEv,_ZTv0_n12_N6G231333fooEv)();
extern void ABISELECT(_ZThn64_N6G231333fooEv,_ZThn32_N6G231333fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23133[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23133[0]),
  (VTBL_ENTRY)&_ZN6G231333fooEv,
  (VTBL_ENTRY)&_ZN6G231333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231333fooEv,_ZTv0_n16_N6G231333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G231333barEv,_ZTv0_n20_N6G231333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G231333barEv,_ZTv0_n12_N6G231333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G231333fooEv,_ZTv0_n16_N6G231333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G231333barEv,_ZTv0_n20_N6G231333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G23133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G231333fooEv,_ZTv0_n12_N6G231333fooEv),
};
extern VTBL_ENTRY _ZTV6G23133[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G23133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
extern void ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G23133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G23133[] = {
  {&(_ZTV6G23133[6]),  6,30},
  {&(_ZTV6G23133[13]),  13,30},
  {&(_ZTV6G23133[18]),  18,30},
  {&(_ZTV6G23133[24]),  24,30},
  {&(_ZTV6G23133[29]),  29,30},
  {&(_tg__ZTV3E23__6G23133[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23133[3]),  3,4},
  {&(_tg__ZTV3F13__6G23133[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G23133[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23133[];
extern  VTBL_ENTRY _ZTV6G23133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23133[];
static VTBL_ENTRY alt_thunk_names139[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G231333fooEv,_ZTv0_n12_N6G231333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G231333fooEv,_ZThn32_N6G231333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G231333barEv,_ZTv0_n12_N6G231333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G231333barEv,_ZThn16_N6G231333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G231333barEv,_ZTv0_n20_N6G231333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G231333barEv,_ZThn24_N6G231333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G231333barEv,_ZThn8_N6G231333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G231333fooEv,_ZTv0_n16_N6G231333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G231333fooEv,_ZThn24_N6G231333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G231333fooEv,_ZThn8_N6G231333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23133 = {  "G23133", // class name
  bases_G23133, 4,
  &(vtc_G23133[0]), // expected_vtbl_contents
  &(vtt_G23133[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G23133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23133),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23133),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names139,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23213  : virtual E23 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G232133fooEv
  virtual void  bar(); // _ZN6G232133barEv
  ~G23213(); // tgen
  G23213(); // tgen
};
//SIG(1 G23213) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC3 v1 Fi} v1 v2 Fi}


void  G23213 ::foo(){vfunc_called(this, "_ZN6G232133fooEv");}
void  G23213 ::bar(){vfunc_called(this, "_ZN6G232133barEv");}
G23213 ::~G23213(){ note_dtor("G23213", this);} // tgen
G23213 ::G23213(){ note_ctor("G23213", this);} // tgen

static void Test_G23213()
{
  extern Class_Descriptor cd_G23213;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G23213, buf);
    G23213 *dp, &lv = *(dp=new (buf) G23213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G23213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23213)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23213");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(32,16), "G23213");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23213");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G23213");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23213.pg");
    test_class_info(&lv, &cd_G23213);
    dp->~G23213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23213(Test_G23213, "G23213", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G23213C1Ev();
extern void _ZN6G23213D1Ev();
Name_Map name_map_G23213[] = {
  NSPAIR(_ZN6G23213C1Ev),
  NSPAIR(_ZN6G23213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G23213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23213[];
extern void _ZN6G232133fooEv();
extern void _ZN6G232133barEv();
extern void ABISELECT(_ZTv0_n32_N6G232133fooEv,_ZTv0_n16_N6G232133fooEv)();
extern void ABISELECT(_ZThn16_N6G232133fooEv,_ZThn8_N6G232133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G232133barEv,_ZTv0_n20_N6G232133barEv)();
extern void ABISELECT(_ZThn16_N6G232133barEv,_ZThn8_N6G232133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G232133barEv,_ZTv0_n12_N6G232133barEv)();
extern void ABISELECT(_ZThn32_N6G232133barEv,_ZThn16_N6G232133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G232133fooEv,_ZTv0_n16_N6G232133fooEv)();
extern void ABISELECT(_ZThn48_N6G232133fooEv,_ZThn24_N6G232133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23213[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23213[0]),
  (VTBL_ENTRY)&_ZN6G232133fooEv,
  (VTBL_ENTRY)&_ZN6G232133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G232133fooEv,_ZTv0_n16_N6G232133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G232133barEv,_ZTv0_n20_N6G232133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G232133barEv,_ZTv0_n12_N6G232133barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G232133fooEv,_ZTv0_n16_N6G232133fooEv),
};
extern VTBL_ENTRY _ZTV6G23213[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23213[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F213fooEv();
static  VTBL_ENTRY _tg__ZTV3F21__6G23213[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3F213fooEv,
};
extern void _ZN3AA23barEv();
static  VTBL_ENTRY _tg__ZTV3AA2__3F21__6G23213[] = {
  0,
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F21[0]),
  (VTBL_ENTRY)&_ZN3AA23barEv,
};
static  VTT_ENTRY vtt_G23213[] = {
  {&(_ZTV6G23213[5]),  5,23},
  {&(_ZTV6G23213[12]),  12,23},
  {&(_ZTV6G23213[17]),  17,23},
  {&(_ZTV6G23213[22]),  22,23},
  {&(_tg__ZTV3E23__6G23213[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23213[3]),  3,4},
  {&(_tg__ZTV3F21__6G23213[3]),  3,4},
  {&(_tg__ZTV3AA2__3F21__6G23213[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23213[];
extern  VTBL_ENTRY _ZTV6G23213[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23213[];
static VTBL_ENTRY alt_thunk_names140[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G232133barEv,_ZTv0_n12_N6G232133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G232133barEv,_ZThn16_N6G232133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G232133barEv,_ZTv0_n20_N6G232133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G232133barEv,_ZThn8_N6G232133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G232133fooEv,_ZTv0_n16_N6G232133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G232133fooEv,_ZThn24_N6G232133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G232133fooEv,_ZThn8_N6G232133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23213 = {  "G23213", // class name
  bases_G23213, 3,
  &(vtc_G23213[0]), // expected_vtbl_contents
  &(vtt_G23213[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G23213),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23213),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23213),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names140,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23222  : virtual E23 , virtual F22 {
  int pg;
  virtual void  bar(); // _ZN6G232223barEv
  ~G23222(); // tgen
  G23222(); // tgen
};
//SIG(1 G23222) C1{ VBC2{ VBC3{ v1 Fi} v2 v1 Fi} VBC4{ VBC3 v1 Fi} v1 Fi}


void  G23222 ::bar(){vfunc_called(this, "_ZN6G232223barEv");}
G23222 ::~G23222(){ note_dtor("G23222", this);} // tgen
G23222 ::G23222(){ note_ctor("G23222", this);} // tgen

static void Test_G23222()
{
  extern Class_Descriptor cd_G23222;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G23222, buf);
    G23222 *dp, &lv = *(dp=new (buf) G23222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G23222)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23222)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23222");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(32,16), "G23222");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23222");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G23222");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23222.pg");
    test_class_info(&lv, &cd_G23222);
    dp->~G23222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23222(Test_G23222, "G23222", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G23222C1Ev();
extern void _ZN6G23222D1Ev();
Name_Map name_map_G23222[] = {
  NSPAIR(_ZN6G23222C1Ev),
  NSPAIR(_ZN6G23222D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G23222[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23222[];
extern void _ZN6G232223barEv();
extern void _ZN3E233fooEv();
extern void ABISELECT(_ZTv0_n40_N6G232223barEv,_ZTv0_n20_N6G232223barEv)();
extern void ABISELECT(_ZThn16_N6G232223barEv,_ZThn8_N6G232223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G232223barEv,_ZTv0_n12_N6G232223barEv)();
extern void ABISELECT(_ZThn32_N6G232223barEv,_ZThn16_N6G232223barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G232223barEv,_ZTv0_n16_N6G232223barEv)();
extern void ABISELECT(_ZThn48_N6G232223barEv,_ZThn24_N6G232223barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23222[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23222[0]),
  (VTBL_ENTRY)&_ZN6G232223barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23222[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G232223barEv,_ZTv0_n20_N6G232223barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G232223barEv,_ZTv0_n12_N6G232223barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23222[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G232223barEv,_ZTv0_n16_N6G232223barEv),
};
extern VTBL_ENTRY _ZTV6G23222[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23222[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23222[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G23222[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G23222[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G23222[] = {
  {&(_ZTV6G23222[5]),  5,22},
  {&(_ZTV6G23222[11]),  11,22},
  {&(_ZTV6G23222[16]),  16,22},
  {&(_ZTV6G23222[21]),  21,22},
  {&(_tg__ZTV3E23__6G23222[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23222[3]),  3,4},
  {&(_tg__ZTV3F22__6G23222[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G23222[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23222[];
extern  VTBL_ENTRY _ZTV6G23222[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23222[];
static VTBL_ENTRY alt_thunk_names141[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G232223barEv,_ZTv0_n16_N6G232223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G232223barEv,_ZThn24_N6G232223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G232223barEv,_ZTv0_n12_N6G232223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G232223barEv,_ZThn16_N6G232223barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G232223barEv,_ZTv0_n20_N6G232223barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G232223barEv,_ZThn8_N6G232223barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23222 = {  "G23222", // class name
  bases_G23222, 3,
  &(vtc_G23222[0]), // expected_vtbl_contents
  &(vtt_G23222[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G23222),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23222),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23222),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names141,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23223  : virtual E23 , virtual F22 {
  int pg;
  virtual void  foo(); // _ZN6G232233fooEv
  virtual void  bar(); // _ZN6G232233barEv
  ~G23223(); // tgen
  G23223(); // tgen
};
//SIG(1 G23223) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC3 v2 Fi} v1 v2 Fi}


void  G23223 ::foo(){vfunc_called(this, "_ZN6G232233fooEv");}
void  G23223 ::bar(){vfunc_called(this, "_ZN6G232233barEv");}
G23223 ::~G23223(){ note_dtor("G23223", this);} // tgen
G23223 ::G23223(){ note_ctor("G23223", this);} // tgen

static void Test_G23223()
{
  extern Class_Descriptor cd_G23223;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G23223, buf);
    G23223 *dp, &lv = *(dp=new (buf) G23223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G23223)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23223)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23223");
    check_base_class_offset(lv, (AA2*)(F22*), ABISELECT(32,16), "G23223");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23223");
    check_base_class_offset(lv, (F22*), ABISELECT(48,24), "G23223");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23223.pg");
    test_class_info(&lv, &cd_G23223);
    dp->~G23223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23223(Test_G23223, "G23223", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G23223C1Ev();
extern void _ZN6G23223D1Ev();
Name_Map name_map_G23223[] = {
  NSPAIR(_ZN6G23223C1Ev),
  NSPAIR(_ZN6G23223D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_F22;
extern VTBL_ENTRY _ZTI3F22[];
extern  VTBL_ENTRY _ZTV3F22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F22[];
static Base_Class bases_G23223[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F22,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23223[];
extern void _ZN6G232233fooEv();
extern void _ZN6G232233barEv();
extern void ABISELECT(_ZTv0_n32_N6G232233fooEv,_ZTv0_n16_N6G232233fooEv)();
extern void ABISELECT(_ZThn16_N6G232233fooEv,_ZThn8_N6G232233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G232233barEv,_ZTv0_n20_N6G232233barEv)();
extern void ABISELECT(_ZThn16_N6G232233barEv,_ZThn8_N6G232233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G232233barEv,_ZTv0_n12_N6G232233barEv)();
extern void ABISELECT(_ZThn32_N6G232233barEv,_ZThn16_N6G232233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G232233barEv,_ZTv0_n16_N6G232233barEv)();
extern void ABISELECT(_ZThn48_N6G232233barEv,_ZThn24_N6G232233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23223[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23223[0]),
  (VTBL_ENTRY)&_ZN6G232233fooEv,
  (VTBL_ENTRY)&_ZN6G232233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G232233fooEv,_ZTv0_n16_N6G232233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G232233barEv,_ZTv0_n20_N6G232233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G232233barEv,_ZTv0_n12_N6G232233barEv),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23223[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G232233barEv,_ZTv0_n16_N6G232233barEv),
};
extern VTBL_ENTRY _ZTV6G23223[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23223[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23223[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F223barEv();
static  VTBL_ENTRY _tg__ZTV3F22__6G23223[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&_ZN3F223barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F22__6G23223[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F223barEv,_ZTv0_n12_N3F223barEv),
};
static  VTT_ENTRY vtt_G23223[] = {
  {&(_ZTV6G23223[5]),  5,23},
  {&(_ZTV6G23223[12]),  12,23},
  {&(_ZTV6G23223[17]),  17,23},
  {&(_ZTV6G23223[22]),  22,23},
  {&(_tg__ZTV3E23__6G23223[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23223[3]),  3,4},
  {&(_tg__ZTV3F22__6G23223[3]),  3,4},
  {&(_tg__ZTV3AA2__3F22__6G23223[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23223[];
extern  VTBL_ENTRY _ZTV6G23223[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23223[];
static VTBL_ENTRY alt_thunk_names142[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G232233barEv,_ZTv0_n16_N6G232233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G232233barEv,_ZThn24_N6G232233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G232233barEv,_ZTv0_n12_N6G232233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G232233barEv,_ZThn16_N6G232233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G232233barEv,_ZTv0_n20_N6G232233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G232233barEv,_ZThn8_N6G232233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G232233fooEv,_ZTv0_n16_N6G232233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G232233fooEv,_ZThn8_N6G232233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23223 = {  "G23223", // class name
  bases_G23223, 3,
  &(vtc_G23223[0]), // expected_vtbl_contents
  &(vtt_G23223[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G23223),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23223),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23223),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names142,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23233  : virtual E23 , virtual F23 {
  int pg;
  virtual void  foo(); // _ZN6G232333fooEv
  virtual void  bar(); // _ZN6G232333barEv
  ~G23233(); // tgen
  G23233(); // tgen
};
//SIG(1 G23233) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC3 v1 v2 Fi} v1 v2 Fi}


void  G23233 ::foo(){vfunc_called(this, "_ZN6G232333fooEv");}
void  G23233 ::bar(){vfunc_called(this, "_ZN6G232333barEv");}
G23233 ::~G23233(){ note_dtor("G23233", this);} // tgen
G23233 ::G23233(){ note_ctor("G23233", this);} // tgen

static void Test_G23233()
{
  extern Class_Descriptor cd_G23233;
  void *lvp;
  {
    ABISELECT(double,int) buf[9];
    init_test(&cd_G23233, buf);
    G23233 *dp, &lv = *(dp=new (buf) G23233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(G23233)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23233)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23233");
    check_base_class_offset(lv, (AA2*)(F23*), ABISELECT(32,16), "G23233");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23233");
    check_base_class_offset(lv, (F23*), ABISELECT(48,24), "G23233");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23233.pg");
    test_class_info(&lv, &cd_G23233);
    dp->~G23233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23233(Test_G23233, "G23233", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN6G23233C1Ev();
extern void _ZN6G23233D1Ev();
Name_Map name_map_G23233[] = {
  NSPAIR(_ZN6G23233C1Ev),
  NSPAIR(_ZN6G23233D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_F23;
extern VTBL_ENTRY _ZTI3F23[];
extern  VTBL_ENTRY _ZTV3F23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F23[];
static Base_Class bases_G23233[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_F23,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23233[];
extern void _ZN6G232333fooEv();
extern void _ZN6G232333barEv();
extern void ABISELECT(_ZTv0_n32_N6G232333fooEv,_ZTv0_n16_N6G232333fooEv)();
extern void ABISELECT(_ZThn16_N6G232333fooEv,_ZThn8_N6G232333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G232333barEv,_ZTv0_n20_N6G232333barEv)();
extern void ABISELECT(_ZThn16_N6G232333barEv,_ZThn8_N6G232333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G232333barEv,_ZTv0_n12_N6G232333barEv)();
extern void ABISELECT(_ZThn32_N6G232333barEv,_ZThn16_N6G232333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G232333fooEv,_ZTv0_n16_N6G232333fooEv)();
extern void ABISELECT(_ZThn48_N6G232333fooEv,_ZThn24_N6G232333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G232333barEv,_ZTv0_n20_N6G232333barEv)();
extern void ABISELECT(_ZThn48_N6G232333barEv,_ZThn24_N6G232333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23233[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23233[0]),
  (VTBL_ENTRY)&_ZN6G232333fooEv,
  (VTBL_ENTRY)&_ZN6G232333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G232333fooEv,_ZTv0_n16_N6G232333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G232333barEv,_ZTv0_n20_N6G232333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G232333barEv,_ZTv0_n12_N6G232333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-16,-8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23233[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G232333fooEv,_ZTv0_n16_N6G232333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G232333barEv,_ZTv0_n20_N6G232333barEv),
};
extern VTBL_ENTRY _ZTV6G23233[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23233[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23233[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F233fooEv();
extern void _ZN3F233barEv();
static  VTBL_ENTRY _tg__ZTV3F23__6G23233[] = {
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&_ZN3F233fooEv,
  (VTBL_ENTRY)&_ZN3F233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv)();
static  VTBL_ENTRY _tg__ZTV3AA2__3F23__6G23233[] = {
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI3F23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F233barEv,_ZTv0_n12_N3F233barEv),
};
static  VTT_ENTRY vtt_G23233[] = {
  {&(_ZTV6G23233[5]),  5,25},
  {&(_ZTV6G23233[12]),  12,25},
  {&(_ZTV6G23233[17]),  17,25},
  {&(_ZTV6G23233[23]),  23,25},
  {&(_tg__ZTV3E23__6G23233[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23233[3]),  3,4},
  {&(_tg__ZTV3F23__6G23233[3]),  3,5},
  {&(_tg__ZTV3AA2__3F23__6G23233[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G23233[];
extern  VTBL_ENTRY _ZTV6G23233[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23233[];
static VTBL_ENTRY alt_thunk_names143[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G232333barEv,_ZTv0_n12_N6G232333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G232333barEv,_ZThn16_N6G232333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G232333barEv,_ZTv0_n20_N6G232333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G232333barEv,_ZThn24_N6G232333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G232333barEv,_ZThn8_N6G232333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G232333fooEv,_ZTv0_n16_N6G232333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G232333fooEv,_ZThn24_N6G232333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G232333fooEv,_ZThn8_N6G232333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23233 = {  "G23233", // class name
  bases_G23233, 3,
  &(vtc_G23233[0]), // expected_vtbl_contents
  &(vtt_G23233[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI6G23233),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23233),25, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23233),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names143,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23313  : virtual E23 , virtual F31 {
  int pg;
  virtual void  foo(); // _ZN6G233133fooEv
  virtual void  bar(); // _ZN6G233133barEv
  ~G23313(); // tgen
  G23313(); // tgen
};
//SIG(1 G23313) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 Fi} v1 v2 Fi}


void  G23313 ::foo(){vfunc_called(this, "_ZN6G233133fooEv");}
void  G23313 ::bar(){vfunc_called(this, "_ZN6G233133barEv");}
G23313 ::~G23313(){ note_dtor("G23313", this);} // tgen
G23313 ::G23313(){ note_ctor("G23313", this);} // tgen

static void Test_G23313()
{
  extern Class_Descriptor cd_G23313;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G23313, buf);
    G23313 *dp, &lv = *(dp=new (buf) G23313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G23313)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23313)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23313");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23313");
    check_base_class_offset(lv, (AA3*)(F31*), ABISELECT(64,32), "G23313");
    check_base_class_offset(lv, (F31*), ABISELECT(48,24), "G23313");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23313.pg");
    test_class_info(&lv, &cd_G23313);
    dp->~G23313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23313(Test_G23313, "G23313", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G23313C1Ev();
extern void _ZN6G23313D1Ev();
Name_Map name_map_G23313[] = {
  NSPAIR(_ZN6G23313C1Ev),
  NSPAIR(_ZN6G23313D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F31;
extern VTBL_ENTRY _ZTI3F31[];
extern  VTBL_ENTRY _ZTV3F31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F31[];
static Base_Class bases_G23313[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F31,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23313[];
extern void _ZN6G233133fooEv();
extern void _ZN6G233133barEv();
extern void ABISELECT(_ZTv0_n32_N6G233133fooEv,_ZTv0_n16_N6G233133fooEv)();
extern void ABISELECT(_ZThn16_N6G233133fooEv,_ZThn8_N6G233133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G233133barEv,_ZTv0_n20_N6G233133barEv)();
extern void ABISELECT(_ZThn16_N6G233133barEv,_ZThn8_N6G233133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G233133barEv,_ZTv0_n12_N6G233133barEv)();
extern void ABISELECT(_ZThn32_N6G233133barEv,_ZThn16_N6G233133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G233133fooEv,_ZTv0_n16_N6G233133fooEv)();
extern void ABISELECT(_ZThn48_N6G233133fooEv,_ZThn24_N6G233133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G233133fooEv,_ZTv0_n12_N6G233133fooEv)();
extern void ABISELECT(_ZThn64_N6G233133fooEv,_ZThn32_N6G233133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G233133barEv,_ZTv0_n16_N6G233133barEv)();
extern void ABISELECT(_ZThn64_N6G233133barEv,_ZThn32_N6G233133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23313[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23313[0]),
  (VTBL_ENTRY)&_ZN6G233133fooEv,
  (VTBL_ENTRY)&_ZN6G233133barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233133fooEv,_ZTv0_n16_N6G233133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G233133barEv,_ZTv0_n20_N6G233133barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G233133barEv,_ZTv0_n12_N6G233133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233133fooEv,_ZTv0_n16_N6G233133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G23313[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G233133fooEv,_ZTv0_n12_N6G233133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233133barEv,_ZTv0_n16_N6G233133barEv),
};
extern VTBL_ENTRY _ZTV6G23313[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23313[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F313fooEv();
static  VTBL_ENTRY _tg__ZTV3F31__6G23313[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&_ZN3F313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv)();
extern void ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3F31__6G23313[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
static  VTT_ENTRY vtt_G23313[] = {
  {&(_ZTV6G23313[6]),  6,30},
  {&(_ZTV6G23313[13]),  13,30},
  {&(_ZTV6G23313[18]),  18,30},
  {&(_ZTV6G23313[23]),  23,30},
  {&(_ZTV6G23313[28]),  28,30},
  {&(_tg__ZTV3E23__6G23313[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23313[3]),  3,4},
  {&(_tg__ZTV3F31__6G23313[3]),  3,4},
  {&(_tg__ZTV3AA3__3F31__6G23313[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G23313[];
extern  VTBL_ENTRY _ZTV6G23313[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23313[];
static VTBL_ENTRY alt_thunk_names144[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F313fooEv,_ZTv0_n12_N3F313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F313fooEv,_ZThn8_N3F313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G233133barEv,_ZTv0_n16_N6G233133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G233133barEv,_ZThn32_N6G233133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G233133fooEv,_ZTv0_n12_N6G233133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G233133fooEv,_ZThn32_N6G233133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G233133barEv,_ZTv0_n12_N6G233133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G233133barEv,_ZThn16_N6G233133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G233133barEv,_ZTv0_n20_N6G233133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G233133barEv,_ZThn8_N6G233133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G233133fooEv,_ZTv0_n16_N6G233133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G233133fooEv,_ZThn24_N6G233133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G233133fooEv,_ZThn8_N6G233133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23313 = {  "G23313", // class name
  bases_G23313, 4,
  &(vtc_G23313[0]), // expected_vtbl_contents
  &(vtt_G23313[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G23313),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23313),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23313),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names144,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23323  : virtual E23 , virtual F32 {
  int pg;
  virtual void  foo(); // _ZN6G233233fooEv
  virtual void  bar(); // _ZN6G233233barEv
  ~G23323(); // tgen
  G23323(); // tgen
};
//SIG(1 G23323) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v2 Fi} v1 v2 Fi}


void  G23323 ::foo(){vfunc_called(this, "_ZN6G233233fooEv");}
void  G23323 ::bar(){vfunc_called(this, "_ZN6G233233barEv");}
G23323 ::~G23323(){ note_dtor("G23323", this);} // tgen
G23323 ::G23323(){ note_ctor("G23323", this);} // tgen

static void Test_G23323()
{
  extern Class_Descriptor cd_G23323;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G23323, buf);
    G23323 *dp, &lv = *(dp=new (buf) G23323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G23323)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23323)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23323");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23323");
    check_base_class_offset(lv, (AA3*)(F32*), ABISELECT(64,32), "G23323");
    check_base_class_offset(lv, (F32*), ABISELECT(48,24), "G23323");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23323.pg");
    test_class_info(&lv, &cd_G23323);
    dp->~G23323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23323(Test_G23323, "G23323", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G23323C1Ev();
extern void _ZN6G23323D1Ev();
Name_Map name_map_G23323[] = {
  NSPAIR(_ZN6G23323C1Ev),
  NSPAIR(_ZN6G23323D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F32;
extern VTBL_ENTRY _ZTI3F32[];
extern  VTBL_ENTRY _ZTV3F32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F32[];
static Base_Class bases_G23323[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F32,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23323[];
extern void _ZN6G233233fooEv();
extern void _ZN6G233233barEv();
extern void ABISELECT(_ZTv0_n32_N6G233233fooEv,_ZTv0_n16_N6G233233fooEv)();
extern void ABISELECT(_ZThn16_N6G233233fooEv,_ZThn8_N6G233233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G233233barEv,_ZTv0_n20_N6G233233barEv)();
extern void ABISELECT(_ZThn16_N6G233233barEv,_ZThn8_N6G233233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G233233barEv,_ZTv0_n12_N6G233233barEv)();
extern void ABISELECT(_ZThn32_N6G233233barEv,_ZThn16_N6G233233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G233233barEv,_ZTv0_n16_N6G233233barEv)();
extern void ABISELECT(_ZThn48_N6G233233barEv,_ZThn24_N6G233233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G233233fooEv,_ZTv0_n12_N6G233233fooEv)();
extern void ABISELECT(_ZThn64_N6G233233fooEv,_ZThn32_N6G233233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G233233barEv,_ZTv0_n16_N6G233233barEv)();
extern void ABISELECT(_ZThn64_N6G233233barEv,_ZThn32_N6G233233barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23323[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23323[0]),
  (VTBL_ENTRY)&_ZN6G233233fooEv,
  (VTBL_ENTRY)&_ZN6G233233barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233233fooEv,_ZTv0_n16_N6G233233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G233233barEv,_ZTv0_n20_N6G233233barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G233233barEv,_ZTv0_n12_N6G233233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233233barEv,_ZTv0_n16_N6G233233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G23323[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G233233fooEv,_ZTv0_n12_N6G233233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233233barEv,_ZTv0_n16_N6G233233barEv),
};
extern VTBL_ENTRY _ZTV6G23323[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23323[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F323barEv();
static  VTBL_ENTRY _tg__ZTV3F32__6G23323[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3F323barEv,
};
extern void _ZN3AA33fooEv();
extern void ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv)();
extern void ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F32__6G23323[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F32[0]),
  (VTBL_ENTRY)&_ZN3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv),
};
static  VTT_ENTRY vtt_G23323[] = {
  {&(_ZTV6G23323[6]),  6,30},
  {&(_ZTV6G23323[13]),  13,30},
  {&(_ZTV6G23323[18]),  18,30},
  {&(_ZTV6G23323[23]),  23,30},
  {&(_ZTV6G23323[28]),  28,30},
  {&(_tg__ZTV3E23__6G23323[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23323[3]),  3,4},
  {&(_tg__ZTV3F32__6G23323[3]),  3,4},
  {&(_tg__ZTV3AA3__3F32__6G23323[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G23323[];
extern  VTBL_ENTRY _ZTV6G23323[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23323[];
static VTBL_ENTRY alt_thunk_names145[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F323barEv,_ZTv0_n16_N3F323barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F323barEv,_ZThn8_N3F323barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G233233fooEv,_ZTv0_n12_N6G233233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G233233fooEv,_ZThn32_N6G233233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G233233barEv,_ZTv0_n16_N6G233233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G233233barEv,_ZThn32_N6G233233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G233233barEv,_ZThn24_N6G233233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G233233barEv,_ZTv0_n12_N6G233233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G233233barEv,_ZThn16_N6G233233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G233233barEv,_ZTv0_n20_N6G233233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G233233barEv,_ZThn8_N6G233233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G233233fooEv,_ZTv0_n16_N6G233233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G233233fooEv,_ZThn8_N6G233233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23323 = {  "G23323", // class name
  bases_G23323, 4,
  &(vtc_G23323[0]), // expected_vtbl_contents
  &(vtt_G23323[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G23323),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23323),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23323),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names145,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G23333  : virtual E23 , virtual F33 {
  int pg;
  virtual void  foo(); // _ZN6G233333fooEv
  virtual void  bar(); // _ZN6G233333barEv
  ~G23333(); // tgen
  G23333(); // tgen
};
//SIG(1 G23333) C1{ VBC2{ VBC3{ v2 Fi} v1 v2 Fi} VBC4{ VBC5{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}


void  G23333 ::foo(){vfunc_called(this, "_ZN6G233333fooEv");}
void  G23333 ::bar(){vfunc_called(this, "_ZN6G233333barEv");}
G23333 ::~G23333(){ note_dtor("G23333", this);} // tgen
G23333 ::G23333(){ note_ctor("G23333", this);} // tgen

static void Test_G23333()
{
  extern Class_Descriptor cd_G23333;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G23333, buf);
    G23333 *dp, &lv = *(dp=new (buf) G23333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G23333)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G23333)");
    check_base_class_offset(lv, (AA2*)(E23*), ABISELECT(32,16), "G23333");
    check_base_class_offset(lv, (E23*), ABISELECT(16,8), "G23333");
    check_base_class_offset(lv, (AA3*)(F33*), ABISELECT(64,32), "G23333");
    check_base_class_offset(lv, (F33*), ABISELECT(48,24), "G23333");
    check_field_offset(lv, pg, ABISELECT(8,4), "G23333.pg");
    test_class_info(&lv, &cd_G23333);
    dp->~G23333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG23333(Test_G23333, "G23333", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G23333C1Ev();
extern void _ZN6G23333D1Ev();
Name_Map name_map_G23333[] = {
  NSPAIR(_ZN6G23333C1Ev),
  NSPAIR(_ZN6G23333D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_E23;
extern VTBL_ENTRY _ZTI3E23[];
extern  VTBL_ENTRY _ZTV3E23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E23[];
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_F33;
extern VTBL_ENTRY _ZTI3F33[];
extern  VTBL_ENTRY _ZTV3F33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F33[];
static Base_Class bases_G23333[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA2,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E23,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA3,    ABISELECT(64,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F33,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G23333[];
extern void _ZN6G233333fooEv();
extern void _ZN6G233333barEv();
extern void ABISELECT(_ZTv0_n32_N6G233333fooEv,_ZTv0_n16_N6G233333fooEv)();
extern void ABISELECT(_ZThn16_N6G233333fooEv,_ZThn8_N6G233333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G233333barEv,_ZTv0_n20_N6G233333barEv)();
extern void ABISELECT(_ZThn16_N6G233333barEv,_ZThn8_N6G233333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G233333barEv,_ZTv0_n12_N6G233333barEv)();
extern void ABISELECT(_ZThn32_N6G233333barEv,_ZThn16_N6G233333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G233333fooEv,_ZTv0_n16_N6G233333fooEv)();
extern void ABISELECT(_ZThn48_N6G233333fooEv,_ZThn24_N6G233333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G233333barEv,_ZTv0_n20_N6G233333barEv)();
extern void ABISELECT(_ZThn48_N6G233333barEv,_ZThn24_N6G233333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G233333fooEv,_ZTv0_n12_N6G233333fooEv)();
extern void ABISELECT(_ZThn64_N6G233333fooEv,_ZThn32_N6G233333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G233333barEv,_ZTv0_n16_N6G233333barEv)();
extern void ABISELECT(_ZThn64_N6G233333barEv,_ZThn32_N6G233333barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G23333[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G23333[0]),
  (VTBL_ENTRY)&_ZN6G233333fooEv,
  (VTBL_ENTRY)&_ZN6G233333barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G23333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233333fooEv,_ZTv0_n16_N6G233333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G233333barEv,_ZTv0_n20_N6G233333barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G23333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G233333barEv,_ZTv0_n12_N6G233333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G23333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233333fooEv,_ZTv0_n16_N6G233333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G233333barEv,_ZTv0_n20_N6G233333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G23333[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G233333fooEv,_ZTv0_n12_N6G233333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G233333barEv,_ZTv0_n16_N6G233333barEv),
};
extern VTBL_ENTRY _ZTV6G23333[];
extern void _ZN3E233fooEv();
extern void _ZN3E233barEv();
static  VTBL_ENTRY _tg__ZTV3E23__6G23333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&_ZN3E233fooEv,
  (VTBL_ENTRY)&_ZN3E233barEv,
};
extern void ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv)();
extern void ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA2__3E23__6G23333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv),
};
extern void _ZN3F333fooEv();
extern void _ZN3F333barEv();
static  VTBL_ENTRY _tg__ZTV3F33__6G23333[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&_ZN3F333fooEv,
  (VTBL_ENTRY)&_ZN3F333barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv)();
extern void ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv)();
extern void ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA3__3F33__6G23333[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv),
};
static  VTT_ENTRY vtt_G23333[] = {
  {&(_ZTV6G23333[6]),  6,32},
  {&(_ZTV6G23333[13]),  13,32},
  {&(_ZTV6G23333[18]),  18,32},
  {&(_ZTV6G23333[24]),  24,32},
  {&(_ZTV6G23333[30]),  30,32},
  {&(_tg__ZTV3E23__6G23333[3]),  3,5},
  {&(_tg__ZTV3AA2__3E23__6G23333[3]),  3,4},
  {&(_tg__ZTV3F33__6G23333[3]),  3,5},
  {&(_tg__ZTV3AA3__3F33__6G23333[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6G23333[];
extern  VTBL_ENTRY _ZTV6G23333[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G23333[];
static VTBL_ENTRY alt_thunk_names146[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N3F333barEv,_ZTv0_n16_N3F333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333barEv,_ZThn8_N3F333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F333fooEv,_ZTv0_n12_N3F333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F333fooEv,_ZThn8_N3F333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E233barEv,_ZTv0_n12_N3E233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E233barEv,_ZThn8_N3E233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G233333barEv,_ZTv0_n16_N6G233333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G233333barEv,_ZThn32_N6G233333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G233333fooEv,_ZTv0_n12_N6G233333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G233333fooEv,_ZThn32_N6G233333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G233333barEv,_ZTv0_n12_N6G233333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G233333barEv,_ZThn16_N6G233333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G233333barEv,_ZTv0_n20_N6G233333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G233333barEv,_ZThn24_N6G233333barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G233333barEv,_ZThn8_N6G233333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G233333fooEv,_ZTv0_n16_N6G233333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G233333fooEv,_ZThn24_N6G233333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G233333fooEv,_ZThn8_N6G233333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G23333 = {  "G23333", // class name
  bases_G23333, 4,
  &(vtc_G23333[0]), // expected_vtbl_contents
  &(vtt_G23333[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G23333),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G23333),32, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G23333),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names146,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G31111  : virtual E31 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G311113fooEv
  ~G31111(); // tgen
  G31111(); // tgen
};
//SIG(1 G31111) C1{ VBC2{ VBC3{ v1 v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 Fi}


void  G31111 ::foo(){vfunc_called(this, "_ZN6G311113fooEv");}
G31111 ::~G31111(){ note_dtor("G31111", this);} // tgen
G31111 ::G31111(){ note_ctor("G31111", this);} // tgen

static void Test_G31111()
{
  extern Class_Descriptor cd_G31111;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G31111, buf);
    G31111 *dp, &lv = *(dp=new (buf) G31111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G31111)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G31111)");
    check_base_class_offset(lv, (AA3*)(E31*), ABISELECT(32,16), "G31111");
    check_base_class_offset(lv, (E31*), ABISELECT(16,8), "G31111");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G31111");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G31111");
    check_field_offset(lv, pg, ABISELECT(8,4), "G31111.pg");
    test_class_info(&lv, &cd_G31111);
    dp->~G31111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG31111(Test_G31111, "G31111", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G31111C1Ev();
extern void _ZN6G31111D1Ev();
Name_Map name_map_G31111[] = {
  NSPAIR(_ZN6G31111C1Ev),
  NSPAIR(_ZN6G31111D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_E31;
extern VTBL_ENTRY _ZTI3E31[];
extern  VTBL_ENTRY _ZTV3E31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E31[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G31111[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E31,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G31111[];
extern void _ZN6G311113fooEv();
extern void ABISELECT(_ZTv0_n32_N6G311113fooEv,_ZTv0_n16_N6G311113fooEv)();
extern void ABISELECT(_ZThn16_N6G311113fooEv,_ZThn8_N6G311113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311113fooEv,_ZTv0_n12_N6G311113fooEv)();
extern void ABISELECT(_ZThn32_N6G311113fooEv,_ZThn16_N6G311113fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
extern void ABISELECT(_ZTv0_n32_N6G311113fooEv,_ZTv0_n16_N6G311113fooEv)();
extern void ABISELECT(_ZThn48_N6G311113fooEv,_ZThn24_N6G311113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311113fooEv,_ZTv0_n12_N6G311113fooEv)();
extern void ABISELECT(_ZThn64_N6G311113fooEv,_ZThn32_N6G311113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G31111[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G31111[0]),
  (VTBL_ENTRY)&_ZN6G311113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G31111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311113fooEv,_ZTv0_n16_N6G311113fooEv),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G31111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311113fooEv,_ZTv0_n12_N6G311113fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G31111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311113fooEv,_ZTv0_n16_N6G311113fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G31111[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311113fooEv,_ZTv0_n12_N6G311113fooEv),
};
extern VTBL_ENTRY _ZTV6G31111[];
extern void _ZN3E313fooEv();
static  VTBL_ENTRY _tg__ZTV3E31__6G31111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&_ZN3E313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv)();
extern void ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3E31__6G31111[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G31111[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G31111[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G31111[] = {
  {&(_ZTV6G31111[6]),  6,27},
  {&(_ZTV6G31111[11]),  11,27},
  {&(_ZTV6G31111[16]),  16,27},
  {&(_ZTV6G31111[22]),  22,27},
  {&(_ZTV6G31111[26]),  26,27},
  {&(_tg__ZTV3E31__6G31111[3]),  3,4},
  {&(_tg__ZTV3AA3__3E31__6G31111[4]),  4,6},
  {&(_tg__ZTV3F11__6G31111[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G31111[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G31111[];
extern  VTBL_ENTRY _ZTV6G31111[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G31111[];
static VTBL_ENTRY alt_thunk_names147[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G311113fooEv,_ZTv0_n12_N6G311113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G311113fooEv,_ZThn32_N6G311113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G311113fooEv,_ZThn16_N6G311113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G311113fooEv,_ZTv0_n16_N6G311113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G311113fooEv,_ZThn24_N6G311113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G311113fooEv,_ZThn8_N6G311113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G31111 = {  "G31111", // class name
  bases_G31111, 4,
  &(vtc_G31111[0]), // expected_vtbl_contents
  &(vtt_G31111[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G31111),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G31111),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G31111),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names147,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G31113  : virtual E31 , virtual F11 {
  int pg;
  virtual void  foo(); // _ZN6G311133fooEv
  virtual void  bar(); // _ZN6G311133barEv
  ~G31113(); // tgen
  G31113(); // tgen
};
//SIG(1 G31113) C1{ VBC2{ VBC3{ v1 v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v1 Fi} v1 v2 Fi}


void  G31113 ::foo(){vfunc_called(this, "_ZN6G311133fooEv");}
void  G31113 ::bar(){vfunc_called(this, "_ZN6G311133barEv");}
G31113 ::~G31113(){ note_dtor("G31113", this);} // tgen
G31113 ::G31113(){ note_ctor("G31113", this);} // tgen

static void Test_G31113()
{
  extern Class_Descriptor cd_G31113;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G31113, buf);
    G31113 *dp, &lv = *(dp=new (buf) G31113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G31113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G31113)");
    check_base_class_offset(lv, (AA3*)(E31*), ABISELECT(32,16), "G31113");
    check_base_class_offset(lv, (E31*), ABISELECT(16,8), "G31113");
    check_base_class_offset(lv, (AA1*)(F11*), ABISELECT(64,32), "G31113");
    check_base_class_offset(lv, (F11*), ABISELECT(48,24), "G31113");
    check_field_offset(lv, pg, ABISELECT(8,4), "G31113.pg");
    test_class_info(&lv, &cd_G31113);
    dp->~G31113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG31113(Test_G31113, "G31113", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G31113C1Ev();
extern void _ZN6G31113D1Ev();
Name_Map name_map_G31113[] = {
  NSPAIR(_ZN6G31113C1Ev),
  NSPAIR(_ZN6G31113D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_E31;
extern VTBL_ENTRY _ZTI3E31[];
extern  VTBL_ENTRY _ZTV3E31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E31[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F11;
extern VTBL_ENTRY _ZTI3F11[];
extern  VTBL_ENTRY _ZTV3F11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F11[];
static Base_Class bases_G31113[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E31,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F11,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G31113[];
extern void _ZN6G311133fooEv();
extern void _ZN6G311133barEv();
extern void ABISELECT(_ZTv0_n32_N6G311133fooEv,_ZTv0_n16_N6G311133fooEv)();
extern void ABISELECT(_ZThn16_N6G311133fooEv,_ZThn8_N6G311133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311133fooEv,_ZTv0_n12_N6G311133fooEv)();
extern void ABISELECT(_ZThn32_N6G311133fooEv,_ZThn16_N6G311133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G311133barEv,_ZTv0_n16_N6G311133barEv)();
extern void ABISELECT(_ZThn32_N6G311133barEv,_ZThn16_N6G311133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G311133fooEv,_ZTv0_n16_N6G311133fooEv)();
extern void ABISELECT(_ZThn48_N6G311133fooEv,_ZThn24_N6G311133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311133fooEv,_ZTv0_n12_N6G311133fooEv)();
extern void ABISELECT(_ZThn64_N6G311133fooEv,_ZThn32_N6G311133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G31113[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G31113[0]),
  (VTBL_ENTRY)&_ZN6G311133fooEv,
  (VTBL_ENTRY)&_ZN6G311133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G31113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311133fooEv,_ZTv0_n16_N6G311133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G31113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311133fooEv,_ZTv0_n12_N6G311133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311133barEv,_ZTv0_n16_N6G311133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G31113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311133fooEv,_ZTv0_n16_N6G311133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G31113[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311133fooEv,_ZTv0_n12_N6G311133fooEv),
};
extern VTBL_ENTRY _ZTV6G31113[];
extern void _ZN3E313fooEv();
static  VTBL_ENTRY _tg__ZTV3E31__6G31113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&_ZN3E313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv)();
extern void ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3E31__6G31113[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern void _ZN3F113fooEv();
static  VTBL_ENTRY _tg__ZTV3F11__6G31113[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&_ZN3F113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv)();
extern void ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F11__6G31113[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv),
};
static  VTT_ENTRY vtt_G31113[] = {
  {&(_ZTV6G31113[6]),  6,28},
  {&(_ZTV6G31113[12]),  12,28},
  {&(_ZTV6G31113[17]),  17,28},
  {&(_ZTV6G31113[23]),  23,28},
  {&(_ZTV6G31113[27]),  27,28},
  {&(_tg__ZTV3E31__6G31113[3]),  3,4},
  {&(_tg__ZTV3AA3__3E31__6G31113[4]),  4,6},
  {&(_tg__ZTV3F11__6G31113[3]),  3,4},
  {&(_tg__ZTV3AA1__3F11__6G31113[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G31113[];
extern  VTBL_ENTRY _ZTV6G31113[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G31113[];
static VTBL_ENTRY alt_thunk_names148[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F113fooEv,_ZTv0_n12_N3F113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F113fooEv,_ZThn8_N3F113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G311133barEv,_ZTv0_n16_N6G311133barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G311133barEv,_ZThn16_N6G311133barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G311133fooEv,_ZTv0_n12_N6G311133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G311133fooEv,_ZThn32_N6G311133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G311133fooEv,_ZThn16_N6G311133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G311133fooEv,_ZTv0_n16_N6G311133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G311133fooEv,_ZThn24_N6G311133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G311133fooEv,_ZThn8_N6G311133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G31113 = {  "G31113", // class name
  bases_G31113, 4,
  &(vtc_G31113[0]), // expected_vtbl_contents
  &(vtt_G31113[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G31113),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G31113),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G31113),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names148,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G31123  : virtual E31 , virtual F12 {
  int pg;
  virtual void  foo(); // _ZN6G311233fooEv
  virtual void  bar(); // _ZN6G311233barEv
  ~G31123(); // tgen
  G31123(); // tgen
};
//SIG(1 G31123) C1{ VBC2{ VBC3{ v1 v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v2 Fi} v1 v2 Fi}


void  G31123 ::foo(){vfunc_called(this, "_ZN6G311233fooEv");}
void  G31123 ::bar(){vfunc_called(this, "_ZN6G311233barEv");}
G31123 ::~G31123(){ note_dtor("G31123", this);} // tgen
G31123 ::G31123(){ note_ctor("G31123", this);} // tgen

static void Test_G31123()
{
  extern Class_Descriptor cd_G31123;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G31123, buf);
    G31123 *dp, &lv = *(dp=new (buf) G31123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G31123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G31123)");
    check_base_class_offset(lv, (AA3*)(E31*), ABISELECT(32,16), "G31123");
    check_base_class_offset(lv, (E31*), ABISELECT(16,8), "G31123");
    check_base_class_offset(lv, (AA1*)(F12*), ABISELECT(64,32), "G31123");
    check_base_class_offset(lv, (F12*), ABISELECT(48,24), "G31123");
    check_field_offset(lv, pg, ABISELECT(8,4), "G31123.pg");
    test_class_info(&lv, &cd_G31123);
    dp->~G31123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG31123(Test_G31123, "G31123", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G31123C1Ev();
extern void _ZN6G31123D1Ev();
Name_Map name_map_G31123[] = {
  NSPAIR(_ZN6G31123C1Ev),
  NSPAIR(_ZN6G31123D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_E31;
extern VTBL_ENTRY _ZTI3E31[];
extern  VTBL_ENTRY _ZTV3E31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E31[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F12;
extern VTBL_ENTRY _ZTI3F12[];
extern  VTBL_ENTRY _ZTV3F12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F12[];
static Base_Class bases_G31123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E31,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F12,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G31123[];
extern void _ZN6G311233fooEv();
extern void _ZN6G311233barEv();
extern void ABISELECT(_ZTv0_n32_N6G311233fooEv,_ZTv0_n16_N6G311233fooEv)();
extern void ABISELECT(_ZThn16_N6G311233fooEv,_ZThn8_N6G311233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311233fooEv,_ZTv0_n12_N6G311233fooEv)();
extern void ABISELECT(_ZThn32_N6G311233fooEv,_ZThn16_N6G311233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G311233barEv,_ZTv0_n16_N6G311233barEv)();
extern void ABISELECT(_ZThn32_N6G311233barEv,_ZThn16_N6G311233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G311233barEv,_ZTv0_n16_N6G311233barEv)();
extern void ABISELECT(_ZThn48_N6G311233barEv,_ZThn24_N6G311233barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311233fooEv,_ZTv0_n12_N6G311233fooEv)();
extern void ABISELECT(_ZThn64_N6G311233fooEv,_ZThn32_N6G311233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G31123[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G31123[0]),
  (VTBL_ENTRY)&_ZN6G311233fooEv,
  (VTBL_ENTRY)&_ZN6G311233barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G31123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311233fooEv,_ZTv0_n16_N6G311233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G31123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311233fooEv,_ZTv0_n12_N6G311233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311233barEv,_ZTv0_n16_N6G311233barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G31123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311233barEv,_ZTv0_n16_N6G311233barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G31123[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311233fooEv,_ZTv0_n12_N6G311233fooEv),
};
extern VTBL_ENTRY _ZTV6G31123[];
extern void _ZN3E313fooEv();
static  VTBL_ENTRY _tg__ZTV3E31__6G31123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&_ZN3E313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv)();
extern void ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3E31__6G31123[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern void _ZN3F123barEv();
static  VTBL_ENTRY _tg__ZTV3F12__6G31123[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3F123barEv,
};
extern void _ZN3AA13fooEv();
static  VTBL_ENTRY _tg__ZTV3AA1__3F12__6G31123[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F12[0]),
  (VTBL_ENTRY)&_ZN3AA13fooEv,
};
static  VTT_ENTRY vtt_G31123[] = {
  {&(_ZTV6G31123[6]),  6,28},
  {&(_ZTV6G31123[12]),  12,28},
  {&(_ZTV6G31123[17]),  17,28},
  {&(_ZTV6G31123[23]),  23,28},
  {&(_ZTV6G31123[27]),  27,28},
  {&(_tg__ZTV3E31__6G31123[3]),  3,4},
  {&(_tg__ZTV3AA3__3E31__6G31123[4]),  4,6},
  {&(_tg__ZTV3F12__6G31123[3]),  3,4},
  {&(_tg__ZTV3AA1__3F12__6G31123[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G31123[];
extern  VTBL_ENTRY _ZTV6G31123[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G31123[];
static VTBL_ENTRY alt_thunk_names149[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G311233barEv,_ZTv0_n16_N6G311233barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G311233barEv,_ZThn24_N6G311233barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G311233barEv,_ZThn16_N6G311233barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G311233fooEv,_ZTv0_n12_N6G311233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G311233fooEv,_ZThn32_N6G311233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G311233fooEv,_ZThn16_N6G311233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G311233fooEv,_ZTv0_n16_N6G311233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G311233fooEv,_ZThn8_N6G311233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G31123 = {  "G31123", // class name
  bases_G31123, 4,
  &(vtc_G31123[0]), // expected_vtbl_contents
  &(vtt_G31123[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G31123),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G31123),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G31123),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names149,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G31133  : virtual E31 , virtual F13 {
  int pg;
  virtual void  foo(); // _ZN6G311333fooEv
  virtual void  bar(); // _ZN6G311333barEv
  ~G31133(); // tgen
  G31133(); // tgen
};
//SIG(1 G31133) C1{ VBC2{ VBC3{ v1 v2 Fi} v1 Fi} VBC4{ VBC5{ v1 Fi} v1 v2 Fi} v1 v2 Fi}


void  G31133 ::foo(){vfunc_called(this, "_ZN6G311333fooEv");}
void  G31133 ::bar(){vfunc_called(this, "_ZN6G311333barEv");}
G31133 ::~G31133(){ note_dtor("G31133", this);} // tgen
G31133 ::G31133(){ note_ctor("G31133", this);} // tgen

static void Test_G31133()
{
  extern Class_Descriptor cd_G31133;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G31133, buf);
    G31133 *dp, &lv = *(dp=new (buf) G31133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G31133)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G31133)");
    check_base_class_offset(lv, (AA3*)(E31*), ABISELECT(32,16), "G31133");
    check_base_class_offset(lv, (E31*), ABISELECT(16,8), "G31133");
    check_base_class_offset(lv, (AA1*)(F13*), ABISELECT(64,32), "G31133");
    check_base_class_offset(lv, (F13*), ABISELECT(48,24), "G31133");
    check_field_offset(lv, pg, ABISELECT(8,4), "G31133.pg");
    test_class_info(&lv, &cd_G31133);
    dp->~G31133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG31133(Test_G31133, "G31133", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G31133C1Ev();
extern void _ZN6G31133D1Ev();
Name_Map name_map_G31133[] = {
  NSPAIR(_ZN6G31133C1Ev),
  NSPAIR(_ZN6G31133D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_E31;
extern VTBL_ENTRY _ZTI3E31[];
extern  VTBL_ENTRY _ZTV3E31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E31[];
extern Class_Descriptor cd_AA1;
extern VTBL_ENTRY _ZTI3AA1[];
extern  VTBL_ENTRY _ZTV3AA1[];
extern Class_Descriptor cd_F13;
extern VTBL_ENTRY _ZTI3F13[];
extern  VTBL_ENTRY _ZTV3F13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F13[];
static Base_Class bases_G31133[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E31,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA1,    ABISELECT(64,32), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F13,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G31133[];
extern void _ZN6G311333fooEv();
extern void _ZN6G311333barEv();
extern void ABISELECT(_ZTv0_n32_N6G311333fooEv,_ZTv0_n16_N6G311333fooEv)();
extern void ABISELECT(_ZThn16_N6G311333fooEv,_ZThn8_N6G311333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311333fooEv,_ZTv0_n12_N6G311333fooEv)();
extern void ABISELECT(_ZThn32_N6G311333fooEv,_ZThn16_N6G311333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G311333barEv,_ZTv0_n16_N6G311333barEv)();
extern void ABISELECT(_ZThn32_N6G311333barEv,_ZThn16_N6G311333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G311333fooEv,_ZTv0_n16_N6G311333fooEv)();
extern void ABISELECT(_ZThn48_N6G311333fooEv,_ZThn24_N6G311333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6G311333barEv,_ZTv0_n20_N6G311333barEv)();
extern void ABISELECT(_ZThn48_N6G311333barEv,_ZThn24_N6G311333barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G311333fooEv,_ZTv0_n12_N6G311333fooEv)();
extern void ABISELECT(_ZThn64_N6G311333fooEv,_ZThn32_N6G311333fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G31133[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G31133[0]),
  (VTBL_ENTRY)&_ZN6G311333fooEv,
  (VTBL_ENTRY)&_ZN6G311333barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G31133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311333fooEv,_ZTv0_n16_N6G311333fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G31133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311333fooEv,_ZTv0_n12_N6G311333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311333barEv,_ZTv0_n16_N6G311333barEv),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G31133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G311333fooEv,_ZTv0_n16_N6G311333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6G311333barEv,_ZTv0_n20_N6G311333barEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G31133[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G311333fooEv,_ZTv0_n12_N6G311333fooEv),
};
extern VTBL_ENTRY _ZTV6G31133[];
extern void _ZN3E313fooEv();
static  VTBL_ENTRY _tg__ZTV3E31__6G31133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&_ZN3E313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv)();
extern void ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv)() __attribute__((weak));
extern void _ZN3AA33barEv();
static  VTBL_ENTRY _tg__ZTV3AA3__3E31__6G31133[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv),
  (VTBL_ENTRY)&_ZN3AA33barEv,
};
extern void _ZN3F133fooEv();
extern void _ZN3F133barEv();
static  VTBL_ENTRY _tg__ZTV3F13__6G31133[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&_ZN3F133fooEv,
  (VTBL_ENTRY)&_ZN3F133barEv,
};
extern void ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv)();
extern void ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3AA1__3F13__6G31133[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3F13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv),
};
static  VTT_ENTRY vtt_G31133[] = {
  {&(_ZTV6G31133[6]),  6,30},
  {&(_ZTV6G31133[12]),  12,30},
  {&(_ZTV6G31133[17]),  17,30},
  {&(_ZTV6G31133[24]),  24,30},
  {&(_ZTV6G31133[29]),  29,30},
  {&(_tg__ZTV3E31__6G31133[3]),  3,4},
  {&(_tg__ZTV3AA3__3E31__6G31133[4]),  4,6},
  {&(_tg__ZTV3F13__6G31133[3]),  3,5},
  {&(_tg__ZTV3AA1__3F13__6G31133[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6G31133[];
extern  VTBL_ENTRY _ZTV6G31133[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6G31133[];
static VTBL_ENTRY alt_thunk_names150[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3F133fooEv,_ZTv0_n12_N3F133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3F133fooEv,_ZThn8_N3F133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3E313fooEv,_ZThn8_N3E313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6G311333barEv,_ZTv0_n20_N6G311333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G311333barEv,_ZThn24_N6G311333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G311333barEv,_ZTv0_n16_N6G311333barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G311333barEv,_ZThn16_N6G311333barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6G311333fooEv,_ZTv0_n12_N6G311333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N6G311333fooEv,_ZThn32_N6G311333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6G311333fooEv,_ZThn16_N6G311333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6G311333fooEv,_ZTv0_n16_N6G311333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N6G311333fooEv,_ZThn24_N6G311333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6G311333fooEv,_ZThn8_N6G311333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_G31133 = {  "G31133", // class name
  bases_G31133, 4,
  &(vtc_G31133[0]), // expected_vtbl_contents
  &(vtt_G31133[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI6G31133),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6G31133),30, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6G31133),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names150,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  G31213  : virtual E31 , virtual F21 {
  int pg;
  virtual void  foo(); // _ZN6G312133fooEv
  virtual void  bar(); // _ZN6G312133barEv
  ~G31213(); // tgen
  G31213(); // tgen
};
//SIG(1 G31213) C1{ VBC2{ VBC3{ v1 v2 Fi} v1 Fi} VBC4{ VBC5{ v2 Fi} v1 Fi} v1 v2 Fi}


void  G31213 ::foo(){vfunc_called(this, "_ZN6G312133fooEv");}
void  G31213 ::bar(){vfunc_called(this, "_ZN6G312133barEv");}
G31213 ::~G31213(){ note_dtor("G31213", this);} // tgen
G31213 ::G31213(){ note_ctor("G31213", this);} // tgen

static void Test_G31213()
{
  extern Class_Descriptor cd_G31213;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_G31213, buf);
    G31213 *dp, &lv = *(dp=new (buf) G31213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(G31213)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(G31213)");
    check_base_class_offset(lv, (AA3*)(E31*), ABISELECT(32,16), "G31213");
    check_base_class_offset(lv, (E31*), ABISELECT(16,8), "G31213");
    check_base_class_offset(lv, (AA2*)(F21*), ABISELECT(64,32), "G31213");
    check_base_class_offset(lv, (F21*), ABISELECT(48,24), "G31213");
    check_field_offset(lv, pg, ABISELECT(8,4), "G31213.pg");
    test_class_info(&lv, &cd_G31213);
    dp->~G31213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vG31213(Test_G31213, "G31213", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN6G31213C1Ev();
extern void _ZN6G31213D1Ev();
Name_Map name_map_G31213[] = {
  NSPAIR(_ZN6G31213C1Ev),
  NSPAIR(_ZN6G31213D1Ev),
  {0,0}
};
extern Class_Descriptor cd_AA3;
extern VTBL_ENTRY _ZTI3AA3[];
extern  VTBL_ENTRY _ZTV3AA3[];
extern Class_Descriptor cd_E31;
extern VTBL_ENTRY _ZTI3E31[];
extern  VTBL_ENTRY _ZTV3E31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3E31[];
extern Class_Descriptor cd_AA2;
extern VTBL_ENTRY _ZTI3AA2[];
extern  VTBL_ENTRY _ZTV3AA2[];
extern Class_Descriptor cd_F21;
extern VTBL_ENTRY _ZTI3F21[];
extern  VTBL_ENTRY _ZTV3F21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3F21[];
static Base_Class bases_G31213[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_AA3,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_E31,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_AA2,    ABISELECT(64,32), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_F21,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6G31213[];
extern void _ZN6G312133fooEv();
extern void _ZN6G312133barEv();
extern void ABISELECT(_ZTv0_n32_N6G312133fooEv,_ZTv0_n16_N6G312133fooEv)();
extern void ABISELECT(_ZThn16_N6G312133fooEv,_ZThn8_N6G312133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G312133fooEv,_ZTv0_n12_N6G312133fooEv)();
extern void ABISELECT(_ZThn32_N6G312133fooEv,_ZThn16_N6G312133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G312133barEv,_ZTv0_n16_N6G312133barEv)();
extern void ABISELECT(_ZThn32_N6G312133barEv,_ZThn16_N6G312133barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6G312133fooEv,_ZTv0_n16_N6G312133fooEv)();
extern void ABISELECT(_ZThn48_N6G312133fooEv,_ZThn24_N6G312133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6G312133barEv,_ZTv0_n12_N6G312133barEv)();
extern void ABISELECT(_ZThn64_N6G312133barEv,_ZThn32_N6G312133barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_G31213[] = {
  ABISELECT(64,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6G31213[0]),
  (VTBL_ENTRY)&_ZN6G312133fooEv,
  (VTBL_ENTRY)&_ZN6G312133barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6G31213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G312133fooEv,_ZTv0_n16_N6G312133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6G31213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G312133fooEv,_ZTv0_n12_N6G312133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G312133barEv,_ZTv0_n16_N6G312133barEv),
  ABISELECT(-48,-24),
  ABISELECT(16,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI6G31213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6G312133fooEv,_ZTv0_n16_N6G312133fooEv),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI6G31213[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6G312133barEv,_ZTv0_n12_N6G312133barEv),
};
extern VTBL_ENTRY _ZTV6G31213[];
extern void _ZN3E313fooEv();
static  VTBL_ENTRY _tg__ZTV3E31__6G31213[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3E31[0]),
  (VTBL_ENTRY)&_ZN3E313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3E313fooEv,_ZTv0_n12_N3E313fooEv)();