// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb70  : virtual aa0 {
  int b;
  virtual void  bar(); // _ZN4bb703barEv
  virtual void  foo(); // _ZN4bb703fooEv
  ~bb70(); // tgen
  bb70(); // tgen
};
//SIG(-1 bb70) C1{ VBC2{ Fi} v1 v2 Fi}


void  bb70 ::bar(){vfunc_called(this, "_ZN4bb703barEv");}
void  bb70 ::foo(){vfunc_called(this, "_ZN4bb703fooEv");}
bb70 ::~bb70(){ note_dtor("bb70", this);} // tgen
bb70 ::bb70(){ note_ctor("bb70", this);} // tgen

static void Test_bb70()
{
  extern Class_Descriptor cd_bb70;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_bb70, buf);
    bb70 *dp, &lv = *(dp=new (buf) bb70());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(bb70)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb70)");
    check_base_class_offset(lv, (aa0*), ABISELECT(12,8), "bb70");
    check_field_offset(lv, b, ABISELECT(8,4), "bb70.b");
    test_class_info(&lv, &cd_bb70);
    dp->~bb70();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb70(Test_bb70, "bb70", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN4bb70C1Ev();
extern void _ZN4bb70D1Ev();
Name_Map name_map_bb70[] = {
  NSPAIR(_ZN4bb70C1Ev),
  NSPAIR(_ZN4bb70D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb70[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4bb70[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_bb70[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV4bb70[];
static  VTT_ENTRY vtt_bb70[] = {
  {&(_ZTV4bb70[3]),  3,5},
};
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
Class_Descriptor cd_bb70 = {  "bb70", // class name
  bases_bb70, 1,
  &(vtc_bb70[0]), // expected_vtbl_contents
  &(vtt_bb70[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI4bb70),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4bb70),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4bb70),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc070  : bb70 {
  int c;
  ~cc070(); // tgen
  cc070(); // tgen
};
//SIG(-1 cc070) C1{ BC2{ VBC3{ Fi} v1 v2 Fi} Fi}


cc070 ::~cc070(){ note_dtor("cc070", this);} // tgen
cc070 ::cc070(){ note_ctor("cc070", this);} // tgen

static void Test_cc070()
{
  extern Class_Descriptor cd_cc070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc070, buf);
    cc070 *dp, &lv = *(dp=new (buf) cc070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc070)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(16,12), "cc070");
    check_base_class_offset(lv, (bb70*), 0, "cc070");
    check_field_offset(lv, c, ABISELECT(12,8), "cc070.c");
    test_class_info(&lv, &cd_cc070);
    dp->~cc070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc070(Test_cc070, "cc070", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc070C1Ev();
extern void _ZN5cc070D1Ev();
Name_Map name_map_cc070[] = {
  NSPAIR(_ZN5cc070C1Ev),
  NSPAIR(_ZN5cc070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
static Base_Class bases_cc070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_cc070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV5cc070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_cc070[] = {
  {&(_ZTV5cc070[3]),  3,5},
  {&(_tg__ZTV4bb70__5cc070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
Class_Descriptor cd_cc070 = {  "cc070", // class name
  bases_cc070, 2,
  &(vtc_cc070[0]), // expected_vtbl_contents
  &(vtt_cc070[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc070),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0070  : cc070 {
  int d;
  ~dd0070(); // tgen
  dd0070(); // tgen
};
//SIG(-1 dd0070) C1{ BC2{ BC3{ VBC4{ Fi} v1 v2 Fi} Fi} Fi}


dd0070 ::~dd0070(){ note_dtor("dd0070", this);} // tgen
dd0070 ::dd0070(){ note_ctor("dd0070", this);} // tgen

static void Test_dd0070()
{
  extern Class_Descriptor cd_dd0070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0070, buf);
    dd0070 *dp, &lv = *(dp=new (buf) dd0070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(20,16), "dd0070");
    check_base_class_offset(lv, (bb70*)(cc070*), 0, "dd0070");
    check_base_class_offset(lv, (cc070*), 0, "dd0070");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0070.d");
    test_class_info(&lv, &cd_dd0070);
    dp->~dd0070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0070(Test_dd0070, "dd0070", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0070C1Ev();
extern void _ZN6dd0070D1Ev();
Name_Map name_map_dd0070[] = {
  NSPAIR(_ZN6dd0070C1Ev),
  NSPAIR(_ZN6dd0070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd0070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd0070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd0070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd0070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd0070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd0070[] = {
  {&(_ZTV6dd0070[3]),  3,5},
  {&(_tg__ZTV5cc070__6dd0070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd0070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
Class_Descriptor cd_dd0070 = {  "dd0070", // class name
  bases_dd0070, 3,
  &(vtc_dd0070[0]), // expected_vtbl_contents
  &(vtt_dd0070[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0070),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00070  : dd0070 {
  int e;
  ~ee00070(); // tgen
  ee00070(); // tgen
};
//SIG(1 ee00070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee00070 ::~ee00070(){ note_dtor("ee00070", this);} // tgen
ee00070 ::ee00070(){ note_ctor("ee00070", this);} // tgen

static void Test_ee00070()
{
  extern Class_Descriptor cd_ee00070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00070, buf);
    ee00070 *dp, &lv = *(dp=new (buf) ee00070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(24,20), "ee00070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), 0, "ee00070");
    check_base_class_offset(lv, (cc070*)(dd0070*), 0, "ee00070");
    check_base_class_offset(lv, (dd0070*), 0, "ee00070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00070.e");
    test_class_info(&lv, &cd_ee00070);
    dp->~ee00070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00070(Test_ee00070, "ee00070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00070C1Ev();
extern void _ZN7ee00070D1Ev();
Name_Map name_map_ee00070[] = {
  NSPAIR(_ZN7ee00070C1Ev),
  NSPAIR(_ZN7ee00070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee00070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee00070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee00070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee00070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee00070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee00070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee00070[] = {
  {&(_ZTV7ee00070[3]),  3,5},
  {&(_tg__ZTV6dd0070__7ee00070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee00070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee00070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee00070[];
extern  VTBL_ENTRY _ZTV7ee00070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00070[];
Class_Descriptor cd_ee00070 = {  "ee00070", // class name
  bases_ee00070, 4,
  &(vtc_ee00070[0]), // expected_vtbl_contents
  &(vtt_ee00070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10070  : virtual dd0070 {
  int e;
  ~ee10070(); // tgen
  ee10070(); // tgen
};
//SIG(1 ee10070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee10070 ::~ee10070(){ note_dtor("ee10070", this);} // tgen
ee10070 ::ee10070(){ note_ctor("ee10070", this);} // tgen

static void Test_ee10070()
{
  extern Class_Descriptor cd_ee10070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10070, buf);
    ee10070 *dp, &lv = *(dp=new (buf) ee10070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(36,24), "ee10070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), ABISELECT(16,8), "ee10070");
    check_base_class_offset(lv, (cc070*)(dd0070*), ABISELECT(16,8), "ee10070");
    check_base_class_offset(lv, (dd0070*), ABISELECT(16,8), "ee10070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10070.e");
    test_class_info(&lv, &cd_ee10070);
    dp->~ee10070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10070(Test_ee10070, "ee10070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10070C1Ev();
extern void _ZN7ee10070D1Ev();
Name_Map name_map_ee10070[] = {
  NSPAIR(_ZN7ee10070C1Ev),
  NSPAIR(_ZN7ee10070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee10070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee10070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10070[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee10070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee10070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee10070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee10070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee10070[] = {
  {&(_ZTV7ee10070[4]),  4,11},
  {&(_ZTV7ee10070[9]),  9,11},
  {&(_tg__ZTV6dd0070__7ee10070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee10070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee10070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee10070[];
extern  VTBL_ENTRY _ZTV7ee10070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10070[];
Class_Descriptor cd_ee10070 = {  "ee10070", // class name
  bases_ee10070, 4,
  &(vtc_ee10070[0]), // expected_vtbl_contents
  &(vtt_ee10070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10070),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20070  : dd0070 {
  int e;
  virtual void  foo(); // _ZN7ee200703fooEv
  ~ee20070(); // tgen
  ee20070(); // tgen
};
//SIG(1 ee20070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee20070 ::foo(){vfunc_called(this, "_ZN7ee200703fooEv");}
ee20070 ::~ee20070(){ note_dtor("ee20070", this);} // tgen
ee20070 ::ee20070(){ note_ctor("ee20070", this);} // tgen

static void Test_ee20070()
{
  extern Class_Descriptor cd_ee20070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20070, buf);
    ee20070 *dp, &lv = *(dp=new (buf) ee20070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(24,20), "ee20070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), 0, "ee20070");
    check_base_class_offset(lv, (cc070*)(dd0070*), 0, "ee20070");
    check_base_class_offset(lv, (dd0070*), 0, "ee20070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20070.e");
    test_class_info(&lv, &cd_ee20070);
    dp->~ee20070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20070(Test_ee20070, "ee20070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20070C1Ev();
extern void _ZN7ee20070D1Ev();
Name_Map name_map_ee20070[] = {
  NSPAIR(_ZN7ee20070C1Ev),
  NSPAIR(_ZN7ee20070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee20070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20070[];
extern void _ZN4bb703barEv();
extern void _ZN7ee200703fooEv();
static  VTBL_ENTRY vtc_ee20070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN7ee200703fooEv,
};
extern VTBL_ENTRY _ZTV7ee20070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee20070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee20070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee20070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee20070[] = {
  {&(_ZTV7ee20070[3]),  3,5},
  {&(_tg__ZTV6dd0070__7ee20070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee20070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee20070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee20070[];
extern  VTBL_ENTRY _ZTV7ee20070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20070[];
Class_Descriptor cd_ee20070 = {  "ee20070", // class name
  bases_ee20070, 4,
  &(vtc_ee20070[0]), // expected_vtbl_contents
  &(vtt_ee20070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30070  : virtual dd0070 {
  int e;
  virtual void  foo(); // _ZN7ee300703fooEv
  ~ee30070(); // tgen
  ee30070(); // tgen
};
//SIG(1 ee30070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee30070 ::foo(){vfunc_called(this, "_ZN7ee300703fooEv");}
ee30070 ::~ee30070(){ note_dtor("ee30070", this);} // tgen
ee30070 ::ee30070(){ note_ctor("ee30070", this);} // tgen

static void Test_ee30070()
{
  extern Class_Descriptor cd_ee30070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30070, buf);
    ee30070 *dp, &lv = *(dp=new (buf) ee30070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(36,24), "ee30070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), ABISELECT(16,8), "ee30070");
    check_base_class_offset(lv, (cc070*)(dd0070*), ABISELECT(16,8), "ee30070");
    check_base_class_offset(lv, (dd0070*), ABISELECT(16,8), "ee30070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30070.e");
    test_class_info(&lv, &cd_ee30070);
    dp->~ee30070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30070(Test_ee30070, "ee30070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30070C1Ev();
extern void _ZN7ee30070D1Ev();
Name_Map name_map_ee30070[] = {
  NSPAIR(_ZN7ee30070C1Ev),
  NSPAIR(_ZN7ee30070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee30070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30070[];
extern void _ZN7ee300703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee300703fooEv,_ZTv0_n20_N7ee300703fooEv)();
extern void ABISELECT(_ZThn16_N7ee300703fooEv,_ZThn8_N7ee300703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30070[0]),
  (VTBL_ENTRY)&_ZN7ee300703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee300703fooEv,_ZTv0_n20_N7ee300703fooEv),
};
extern VTBL_ENTRY _ZTV7ee30070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee30070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee30070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee30070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee30070[] = {
  {&(_ZTV7ee30070[4]),  4,12},
  {&(_ZTV7ee30070[10]),  10,12},
  {&(_tg__ZTV6dd0070__7ee30070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee30070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee30070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee30070[];
extern  VTBL_ENTRY _ZTV7ee30070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30070[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee300703fooEv,_ZTv0_n20_N7ee300703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee300703fooEv,_ZThn8_N7ee300703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30070 = {  "ee30070", // class name
  bases_ee30070, 4,
  &(vtc_ee30070[0]), // expected_vtbl_contents
  &(vtt_ee30070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40070  : dd0070 {
  int e;
  virtual void  bar(); // _ZN7ee400703barEv
  ~ee40070(); // tgen
  ee40070(); // tgen
};
//SIG(1 ee40070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee40070 ::bar(){vfunc_called(this, "_ZN7ee400703barEv");}
ee40070 ::~ee40070(){ note_dtor("ee40070", this);} // tgen
ee40070 ::ee40070(){ note_ctor("ee40070", this);} // tgen

static void Test_ee40070()
{
  extern Class_Descriptor cd_ee40070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40070, buf);
    ee40070 *dp, &lv = *(dp=new (buf) ee40070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(24,20), "ee40070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), 0, "ee40070");
    check_base_class_offset(lv, (cc070*)(dd0070*), 0, "ee40070");
    check_base_class_offset(lv, (dd0070*), 0, "ee40070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee40070.e");
    test_class_info(&lv, &cd_ee40070);
    dp->~ee40070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40070(Test_ee40070, "ee40070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40070C1Ev();
extern void _ZN7ee40070D1Ev();
Name_Map name_map_ee40070[] = {
  NSPAIR(_ZN7ee40070C1Ev),
  NSPAIR(_ZN7ee40070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee40070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40070[];
extern void _ZN7ee400703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee40070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40070[0]),
  (VTBL_ENTRY)&_ZN7ee400703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee40070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee40070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee40070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee40070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee40070[] = {
  {&(_ZTV7ee40070[3]),  3,5},
  {&(_tg__ZTV6dd0070__7ee40070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee40070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee40070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee40070[];
extern  VTBL_ENTRY _ZTV7ee40070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40070[];
Class_Descriptor cd_ee40070 = {  "ee40070", // class name
  bases_ee40070, 4,
  &(vtc_ee40070[0]), // expected_vtbl_contents
  &(vtt_ee40070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50070  : virtual dd0070 {
  int e;
  virtual void  bar(); // _ZN7ee500703barEv
  ~ee50070(); // tgen
  ee50070(); // tgen
};
//SIG(1 ee50070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee50070 ::bar(){vfunc_called(this, "_ZN7ee500703barEv");}
ee50070 ::~ee50070(){ note_dtor("ee50070", this);} // tgen
ee50070 ::ee50070(){ note_ctor("ee50070", this);} // tgen

static void Test_ee50070()
{
  extern Class_Descriptor cd_ee50070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50070, buf);
    ee50070 *dp, &lv = *(dp=new (buf) ee50070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(36,24), "ee50070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), ABISELECT(16,8), "ee50070");
    check_base_class_offset(lv, (cc070*)(dd0070*), ABISELECT(16,8), "ee50070");
    check_base_class_offset(lv, (dd0070*), ABISELECT(16,8), "ee50070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50070.e");
    test_class_info(&lv, &cd_ee50070);
    dp->~ee50070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50070(Test_ee50070, "ee50070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50070C1Ev();
extern void _ZN7ee50070D1Ev();
Name_Map name_map_ee50070[] = {
  NSPAIR(_ZN7ee50070C1Ev),
  NSPAIR(_ZN7ee50070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee50070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50070[];
extern void _ZN7ee500703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee500703barEv,_ZTv0_n16_N7ee500703barEv)();
extern void ABISELECT(_ZThn16_N7ee500703barEv,_ZThn8_N7ee500703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee50070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50070[0]),
  (VTBL_ENTRY)&_ZN7ee500703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee500703barEv,_ZTv0_n16_N7ee500703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee50070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee50070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee50070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee50070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee50070[] = {
  {&(_ZTV7ee50070[4]),  4,12},
  {&(_ZTV7ee50070[10]),  10,12},
  {&(_tg__ZTV6dd0070__7ee50070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee50070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee50070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee50070[];
extern  VTBL_ENTRY _ZTV7ee50070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50070[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee500703barEv,_ZTv0_n16_N7ee500703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee500703barEv,_ZThn8_N7ee500703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50070 = {  "ee50070", // class name
  bases_ee50070, 4,
  &(vtc_ee50070[0]), // expected_vtbl_contents
  &(vtt_ee50070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60070  : dd0070 {
  int e;
  virtual void  foo(); // _ZN7ee600703fooEv
  virtual void  bar(); // _ZN7ee600703barEv
  ~ee60070(); // tgen
  ee60070(); // tgen
};
//SIG(1 ee60070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60070 ::foo(){vfunc_called(this, "_ZN7ee600703fooEv");}
void  ee60070 ::bar(){vfunc_called(this, "_ZN7ee600703barEv");}
ee60070 ::~ee60070(){ note_dtor("ee60070", this);} // tgen
ee60070 ::ee60070(){ note_ctor("ee60070", this);} // tgen

static void Test_ee60070()
{
  extern Class_Descriptor cd_ee60070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60070, buf);
    ee60070 *dp, &lv = *(dp=new (buf) ee60070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(24,20), "ee60070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), 0, "ee60070");
    check_base_class_offset(lv, (cc070*)(dd0070*), 0, "ee60070");
    check_base_class_offset(lv, (dd0070*), 0, "ee60070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee60070.e");
    test_class_info(&lv, &cd_ee60070);
    dp->~ee60070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60070(Test_ee60070, "ee60070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60070C1Ev();
extern void _ZN7ee60070D1Ev();
Name_Map name_map_ee60070[] = {
  NSPAIR(_ZN7ee60070C1Ev),
  NSPAIR(_ZN7ee60070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee60070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60070[];
extern void _ZN7ee600703barEv();
extern void _ZN7ee600703fooEv();
static  VTBL_ENTRY vtc_ee60070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60070[0]),
  (VTBL_ENTRY)&_ZN7ee600703barEv,
  (VTBL_ENTRY)&_ZN7ee600703fooEv,
};
extern VTBL_ENTRY _ZTV7ee60070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee60070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee60070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee60070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee60070[] = {
  {&(_ZTV7ee60070[3]),  3,5},
  {&(_tg__ZTV6dd0070__7ee60070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee60070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee60070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee60070[];
extern  VTBL_ENTRY _ZTV7ee60070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60070[];
Class_Descriptor cd_ee60070 = {  "ee60070", // class name
  bases_ee60070, 4,
  &(vtc_ee60070[0]), // expected_vtbl_contents
  &(vtt_ee60070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70070  : virtual dd0070 {
  int e;
  virtual void  foo(); // _ZN7ee700703fooEv
  virtual void  bar(); // _ZN7ee700703barEv
  ~ee70070(); // tgen
  ee70070(); // tgen
};
//SIG(1 ee70070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70070 ::foo(){vfunc_called(this, "_ZN7ee700703fooEv");}
void  ee70070 ::bar(){vfunc_called(this, "_ZN7ee700703barEv");}
ee70070 ::~ee70070(){ note_dtor("ee70070", this);} // tgen
ee70070 ::ee70070(){ note_ctor("ee70070", this);} // tgen

static void Test_ee70070()
{
  extern Class_Descriptor cd_ee70070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70070, buf);
    ee70070 *dp, &lv = *(dp=new (buf) ee70070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd0070*), ABISELECT(36,24), "ee70070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd0070*), ABISELECT(16,8), "ee70070");
    check_base_class_offset(lv, (cc070*)(dd0070*), ABISELECT(16,8), "ee70070");
    check_base_class_offset(lv, (dd0070*), ABISELECT(16,8), "ee70070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70070.e");
    test_class_info(&lv, &cd_ee70070);
    dp->~ee70070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70070(Test_ee70070, "ee70070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70070C1Ev();
extern void _ZN7ee70070D1Ev();
Name_Map name_map_ee70070[] = {
  NSPAIR(_ZN7ee70070C1Ev),
  NSPAIR(_ZN7ee70070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd0070;
extern VTBL_ENTRY _ZTI6dd0070[];
extern  VTBL_ENTRY _ZTV6dd0070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0070[];
static Base_Class bases_ee70070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70070[];
extern void _ZN7ee700703fooEv();
extern void _ZN7ee700703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee700703barEv,_ZTv0_n16_N7ee700703barEv)();
extern void ABISELECT(_ZThn16_N7ee700703barEv,_ZThn8_N7ee700703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee700703fooEv,_ZTv0_n20_N7ee700703fooEv)();
extern void ABISELECT(_ZThn16_N7ee700703fooEv,_ZThn8_N7ee700703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70070[0]),
  (VTBL_ENTRY)&_ZN7ee700703fooEv,
  (VTBL_ENTRY)&_ZN7ee700703barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee700703barEv,_ZTv0_n16_N7ee700703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee700703fooEv,_ZTv0_n20_N7ee700703fooEv),
};
extern VTBL_ENTRY _ZTV7ee70070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0070__7ee70070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd0070__7ee70070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd0070__7ee70070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee70070[] = {
  {&(_ZTV7ee70070[4]),  4,13},
  {&(_ZTV7ee70070[11]),  11,13},
  {&(_tg__ZTV6dd0070__7ee70070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd0070__7ee70070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd0070__7ee70070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee70070[];
extern  VTBL_ENTRY _ZTV7ee70070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70070[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee700703fooEv,_ZTv0_n20_N7ee700703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700703fooEv,_ZThn8_N7ee700703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee700703barEv,_ZTv0_n16_N7ee700703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700703barEv,_ZThn8_N7ee700703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70070 = {  "ee70070", // class name
  bases_ee70070, 4,
  &(vtc_ee70070[0]), // expected_vtbl_contents
  &(vtt_ee70070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1070  : virtual cc070 {
  int d;
  ~dd1070(); // tgen
  dd1070(); // tgen
};
//SIG(-1 dd1070) C1{ VBC2{ BC3{ VBC4{ Fi} v1 v2 Fi} Fi} Fi}


dd1070 ::~dd1070(){ note_dtor("dd1070", this);} // tgen
dd1070 ::dd1070(){ note_ctor("dd1070", this);} // tgen

static void Test_dd1070()
{
  extern Class_Descriptor cd_dd1070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1070, buf);
    dd1070 *dp, &lv = *(dp=new (buf) dd1070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,20), "dd1070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,8), "dd1070");
    check_base_class_offset(lv, (cc070*), ABISELECT(16,8), "dd1070");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1070.d");
    test_class_info(&lv, &cd_dd1070);
    dp->~dd1070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1070(Test_dd1070, "dd1070", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1070C1Ev();
extern void _ZN6dd1070D1Ev();
Name_Map name_map_dd1070[] = {
  NSPAIR(_ZN6dd1070C1Ev),
  NSPAIR(_ZN6dd1070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd1070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd1070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd1070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd1070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd1070[] = {
  {&(_ZTV6dd1070[4]),  4,11},
  {&(_ZTV6dd1070[9]),  9,11},
  {&(_tg__ZTV5cc070__6dd1070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd1070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
Class_Descriptor cd_dd1070 = {  "dd1070", // class name
  bases_dd1070, 3,
  &(vtc_dd1070[0]), // expected_vtbl_contents
  &(vtt_dd1070[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1070),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1070),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01070  : dd1070 {
  int e;
  ~ee01070(); // tgen
  ee01070(); // tgen
};
//SIG(1 ee01070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee01070 ::~ee01070(){ note_dtor("ee01070", this);} // tgen
ee01070 ::ee01070(){ note_ctor("ee01070", this);} // tgen

static void Test_ee01070()
{
  extern Class_Descriptor cd_ee01070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01070, buf);
    ee01070 *dp, &lv = *(dp=new (buf) ee01070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee01070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee01070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(16,12), "ee01070");
    check_base_class_offset(lv, (dd1070*), 0, "ee01070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01070.e");
    test_class_info(&lv, &cd_ee01070);
    dp->~ee01070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01070(Test_ee01070, "ee01070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01070C1Ev();
extern void _ZN7ee01070D1Ev();
Name_Map name_map_ee01070[] = {
  NSPAIR(_ZN7ee01070C1Ev),
  NSPAIR(_ZN7ee01070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee01070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee01070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01070[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee01070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee01070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee01070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee01070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee01070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee01070[] = {
  {&(_ZTV7ee01070[4]),  4,11},
  {&(_tg__ZTV6dd1070__7ee01070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee01070[5]),  5,7},
  {&(_ZTV7ee01070[9]),  9,11},
  {&(_tg__ZTV5cc070__7ee01070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee01070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee01070[];
extern  VTBL_ENTRY _ZTV7ee01070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01070[];
Class_Descriptor cd_ee01070 = {  "ee01070", // class name
  bases_ee01070, 4,
  &(vtc_ee01070[0]), // expected_vtbl_contents
  &(vtt_ee01070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01070),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11070  : virtual dd1070 {
  int e;
  ~ee11070(); // tgen
  ee11070(); // tgen
};
//SIG(1 ee11070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee11070 ::~ee11070(){ note_dtor("ee11070", this);} // tgen
ee11070 ::ee11070(){ note_ctor("ee11070", this);} // tgen

static void Test_ee11070()
{
  extern Class_Descriptor cd_ee11070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11070, buf);
    ee11070 *dp, &lv = *(dp=new (buf) ee11070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee11070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee11070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(32,16), "ee11070");
    check_base_class_offset(lv, (dd1070*), ABISELECT(16,8), "ee11070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11070.e");
    test_class_info(&lv, &cd_ee11070);
    dp->~ee11070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11070(Test_ee11070, "ee11070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11070C1Ev();
extern void _ZN7ee11070D1Ev();
Name_Map name_map_ee11070[] = {
  NSPAIR(_ZN7ee11070C1Ev),
  NSPAIR(_ZN7ee11070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee11070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee11070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11070[0]),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11070[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee11070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee11070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee11070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee11070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee11070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee11070[] = {
  {&(_ZTV7ee11070[5]),  5,16},
  {&(_ZTV7ee11070[9]),  9,16},
  {&(_ZTV7ee11070[14]),  14,16},
  {&(_tg__ZTV6dd1070__7ee11070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee11070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee11070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee11070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee11070[];
extern  VTBL_ENTRY _ZTV7ee11070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11070[];
Class_Descriptor cd_ee11070 = {  "ee11070", // class name
  bases_ee11070, 4,
  &(vtc_ee11070[0]), // expected_vtbl_contents
  &(vtt_ee11070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11070),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21070  : dd1070 {
  int e;
  virtual void  foo(); // _ZN7ee210703fooEv
  ~ee21070(); // tgen
  ee21070(); // tgen
};
//SIG(1 ee21070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee21070 ::foo(){vfunc_called(this, "_ZN7ee210703fooEv");}
ee21070 ::~ee21070(){ note_dtor("ee21070", this);} // tgen
ee21070 ::ee21070(){ note_ctor("ee21070", this);} // tgen

static void Test_ee21070()
{
  extern Class_Descriptor cd_ee21070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21070, buf);
    ee21070 *dp, &lv = *(dp=new (buf) ee21070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee21070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee21070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(16,12), "ee21070");
    check_base_class_offset(lv, (dd1070*), 0, "ee21070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21070.e");
    test_class_info(&lv, &cd_ee21070);
    dp->~ee21070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21070(Test_ee21070, "ee21070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21070C1Ev();
extern void _ZN7ee21070D1Ev();
Name_Map name_map_ee21070[] = {
  NSPAIR(_ZN7ee21070C1Ev),
  NSPAIR(_ZN7ee21070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee21070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21070[];
extern void _ZN7ee210703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee210703fooEv,_ZTv0_n20_N7ee210703fooEv)();
extern void ABISELECT(_ZThn16_N7ee210703fooEv,_ZThn12_N7ee210703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21070[0]),
  (VTBL_ENTRY)&_ZN7ee210703fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee210703fooEv,_ZTv0_n20_N7ee210703fooEv),
};
extern VTBL_ENTRY _ZTV7ee21070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee21070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee21070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee21070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee21070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee21070[] = {
  {&(_ZTV7ee21070[4]),  4,12},
  {&(_tg__ZTV6dd1070__7ee21070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee21070[5]),  5,7},
  {&(_ZTV7ee21070[10]),  10,12},
  {&(_tg__ZTV5cc070__7ee21070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee21070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee21070[];
extern  VTBL_ENTRY _ZTV7ee21070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21070[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee210703fooEv,_ZTv0_n20_N7ee210703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee210703fooEv,_ZThn12_N7ee210703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21070 = {  "ee21070", // class name
  bases_ee21070, 4,
  &(vtc_ee21070[0]), // expected_vtbl_contents
  &(vtt_ee21070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31070  : virtual dd1070 {
  int e;
  virtual void  foo(); // _ZN7ee310703fooEv
  ~ee31070(); // tgen
  ee31070(); // tgen
};
//SIG(1 ee31070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee31070 ::foo(){vfunc_called(this, "_ZN7ee310703fooEv");}
ee31070 ::~ee31070(){ note_dtor("ee31070", this);} // tgen
ee31070 ::ee31070(){ note_ctor("ee31070", this);} // tgen

static void Test_ee31070()
{
  extern Class_Descriptor cd_ee31070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31070, buf);
    ee31070 *dp, &lv = *(dp=new (buf) ee31070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee31070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee31070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(32,16), "ee31070");
    check_base_class_offset(lv, (dd1070*), ABISELECT(16,8), "ee31070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31070.e");
    test_class_info(&lv, &cd_ee31070);
    dp->~ee31070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31070(Test_ee31070, "ee31070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31070C1Ev();
extern void _ZN7ee31070D1Ev();
Name_Map name_map_ee31070[] = {
  NSPAIR(_ZN7ee31070C1Ev),
  NSPAIR(_ZN7ee31070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee31070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31070[];
extern void _ZN7ee310703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee310703fooEv,_ZTv0_n20_N7ee310703fooEv)();
extern void ABISELECT(_ZThn32_N7ee310703fooEv,_ZThn16_N7ee310703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31070[0]),
  (VTBL_ENTRY)&_ZN7ee310703fooEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31070[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee310703fooEv,_ZTv0_n20_N7ee310703fooEv),
};
extern VTBL_ENTRY _ZTV7ee31070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee31070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee31070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee31070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee31070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee31070[] = {
  {&(_ZTV7ee31070[5]),  5,17},
  {&(_ZTV7ee31070[10]),  10,17},
  {&(_ZTV7ee31070[15]),  15,17},
  {&(_tg__ZTV6dd1070__7ee31070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee31070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee31070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee31070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee31070[];
extern  VTBL_ENTRY _ZTV7ee31070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31070[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee310703fooEv,_ZTv0_n20_N7ee310703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee310703fooEv,_ZThn16_N7ee310703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31070 = {  "ee31070", // class name
  bases_ee31070, 4,
  &(vtc_ee31070[0]), // expected_vtbl_contents
  &(vtt_ee31070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31070),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41070  : dd1070 {
  int e;
  virtual void  bar(); // _ZN7ee410703barEv
  ~ee41070(); // tgen
  ee41070(); // tgen
};
//SIG(1 ee41070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee41070 ::bar(){vfunc_called(this, "_ZN7ee410703barEv");}
ee41070 ::~ee41070(){ note_dtor("ee41070", this);} // tgen
ee41070 ::ee41070(){ note_ctor("ee41070", this);} // tgen

static void Test_ee41070()
{
  extern Class_Descriptor cd_ee41070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41070, buf);
    ee41070 *dp, &lv = *(dp=new (buf) ee41070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee41070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee41070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(16,12), "ee41070");
    check_base_class_offset(lv, (dd1070*), 0, "ee41070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41070.e");
    test_class_info(&lv, &cd_ee41070);
    dp->~ee41070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41070(Test_ee41070, "ee41070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41070C1Ev();
extern void _ZN7ee41070D1Ev();
Name_Map name_map_ee41070[] = {
  NSPAIR(_ZN7ee41070C1Ev),
  NSPAIR(_ZN7ee41070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee41070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41070[];
extern void _ZN7ee410703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee410703barEv,_ZTv0_n16_N7ee410703barEv)();
extern void ABISELECT(_ZThn16_N7ee410703barEv,_ZThn12_N7ee410703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee41070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41070[0]),
  (VTBL_ENTRY)&_ZN7ee410703barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee410703barEv,_ZTv0_n16_N7ee410703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee41070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee41070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee41070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee41070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee41070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee41070[] = {
  {&(_ZTV7ee41070[4]),  4,12},
  {&(_tg__ZTV6dd1070__7ee41070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee41070[5]),  5,7},
  {&(_ZTV7ee41070[10]),  10,12},
  {&(_tg__ZTV5cc070__7ee41070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee41070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee41070[];
extern  VTBL_ENTRY _ZTV7ee41070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41070[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee410703barEv,_ZTv0_n16_N7ee410703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee410703barEv,_ZThn12_N7ee410703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41070 = {  "ee41070", // class name
  bases_ee41070, 4,
  &(vtc_ee41070[0]), // expected_vtbl_contents
  &(vtt_ee41070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51070  : virtual dd1070 {
  int e;
  virtual void  bar(); // _ZN7ee510703barEv
  ~ee51070(); // tgen
  ee51070(); // tgen
};
//SIG(1 ee51070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee51070 ::bar(){vfunc_called(this, "_ZN7ee510703barEv");}
ee51070 ::~ee51070(){ note_dtor("ee51070", this);} // tgen
ee51070 ::ee51070(){ note_ctor("ee51070", this);} // tgen

static void Test_ee51070()
{
  extern Class_Descriptor cd_ee51070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51070, buf);
    ee51070 *dp, &lv = *(dp=new (buf) ee51070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee51070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee51070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(32,16), "ee51070");
    check_base_class_offset(lv, (dd1070*), ABISELECT(16,8), "ee51070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51070.e");
    test_class_info(&lv, &cd_ee51070);
    dp->~ee51070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51070(Test_ee51070, "ee51070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51070C1Ev();
extern void _ZN7ee51070D1Ev();
Name_Map name_map_ee51070[] = {
  NSPAIR(_ZN7ee51070C1Ev),
  NSPAIR(_ZN7ee51070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee51070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51070[];
extern void _ZN7ee510703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee510703barEv,_ZTv0_n16_N7ee510703barEv)();
extern void ABISELECT(_ZThn32_N7ee510703barEv,_ZThn16_N7ee510703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee51070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51070[0]),
  (VTBL_ENTRY)&_ZN7ee510703barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51070[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee510703barEv,_ZTv0_n16_N7ee510703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee51070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee51070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee51070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee51070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee51070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee51070[] = {
  {&(_ZTV7ee51070[5]),  5,17},
  {&(_ZTV7ee51070[10]),  10,17},
  {&(_ZTV7ee51070[15]),  15,17},
  {&(_tg__ZTV6dd1070__7ee51070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee51070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee51070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee51070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee51070[];
extern  VTBL_ENTRY _ZTV7ee51070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51070[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee510703barEv,_ZTv0_n16_N7ee510703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee510703barEv,_ZThn16_N7ee510703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51070 = {  "ee51070", // class name
  bases_ee51070, 4,
  &(vtc_ee51070[0]), // expected_vtbl_contents
  &(vtt_ee51070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51070),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61070  : dd1070 {
  int e;
  virtual void  foo(); // _ZN7ee610703fooEv
  virtual void  bar(); // _ZN7ee610703barEv
  ~ee61070(); // tgen
  ee61070(); // tgen
};
//SIG(1 ee61070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61070 ::foo(){vfunc_called(this, "_ZN7ee610703fooEv");}
void  ee61070 ::bar(){vfunc_called(this, "_ZN7ee610703barEv");}
ee61070 ::~ee61070(){ note_dtor("ee61070", this);} // tgen
ee61070 ::ee61070(){ note_ctor("ee61070", this);} // tgen

static void Test_ee61070()
{
  extern Class_Descriptor cd_ee61070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61070, buf);
    ee61070 *dp, &lv = *(dp=new (buf) ee61070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee61070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee61070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(16,12), "ee61070");
    check_base_class_offset(lv, (dd1070*), 0, "ee61070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61070.e");
    test_class_info(&lv, &cd_ee61070);
    dp->~ee61070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61070(Test_ee61070, "ee61070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61070C1Ev();
extern void _ZN7ee61070D1Ev();
Name_Map name_map_ee61070[] = {
  NSPAIR(_ZN7ee61070C1Ev),
  NSPAIR(_ZN7ee61070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee61070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61070[];
extern void _ZN7ee610703fooEv();
extern void _ZN7ee610703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee610703barEv,_ZTv0_n16_N7ee610703barEv)();
extern void ABISELECT(_ZThn16_N7ee610703barEv,_ZThn12_N7ee610703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee610703fooEv,_ZTv0_n20_N7ee610703fooEv)();
extern void ABISELECT(_ZThn16_N7ee610703fooEv,_ZThn12_N7ee610703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61070[0]),
  (VTBL_ENTRY)&_ZN7ee610703fooEv,
  (VTBL_ENTRY)&_ZN7ee610703barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee610703barEv,_ZTv0_n16_N7ee610703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee610703fooEv,_ZTv0_n20_N7ee610703fooEv),
};
extern VTBL_ENTRY _ZTV7ee61070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee61070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee61070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee61070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee61070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee61070[] = {
  {&(_ZTV7ee61070[4]),  4,13},
  {&(_tg__ZTV6dd1070__7ee61070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee61070[5]),  5,7},
  {&(_ZTV7ee61070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee61070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee61070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee61070[];
extern  VTBL_ENTRY _ZTV7ee61070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61070[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee610703fooEv,_ZTv0_n20_N7ee610703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610703fooEv,_ZThn12_N7ee610703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee610703barEv,_ZTv0_n16_N7ee610703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610703barEv,_ZThn12_N7ee610703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61070 = {  "ee61070", // class name
  bases_ee61070, 4,
  &(vtc_ee61070[0]), // expected_vtbl_contents
  &(vtt_ee61070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71070  : virtual dd1070 {
  int e;
  virtual void  foo(); // _ZN7ee710703fooEv
  virtual void  bar(); // _ZN7ee710703barEv
  ~ee71070(); // tgen
  ee71070(); // tgen
};
//SIG(1 ee71070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71070 ::foo(){vfunc_called(this, "_ZN7ee710703fooEv");}
void  ee71070 ::bar(){vfunc_called(this, "_ZN7ee710703barEv");}
ee71070 ::~ee71070(){ note_dtor("ee71070", this);} // tgen
ee71070 ::ee71070(){ note_ctor("ee71070", this);} // tgen

static void Test_ee71070()
{
  extern Class_Descriptor cd_ee71070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71070, buf);
    ee71070 *dp, &lv = *(dp=new (buf) ee71070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee71070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee71070");
    check_base_class_offset(lv, (cc070*)(dd1070*), ABISELECT(32,16), "ee71070");
    check_base_class_offset(lv, (dd1070*), ABISELECT(16,8), "ee71070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71070.e");
    test_class_info(&lv, &cd_ee71070);
    dp->~ee71070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71070(Test_ee71070, "ee71070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71070C1Ev();
extern void _ZN7ee71070D1Ev();
Name_Map name_map_ee71070[] = {
  NSPAIR(_ZN7ee71070C1Ev),
  NSPAIR(_ZN7ee71070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd1070;
extern VTBL_ENTRY _ZTI6dd1070[];
extern  VTBL_ENTRY _ZTV6dd1070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1070[];
static Base_Class bases_ee71070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1070,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71070[];
extern void _ZN7ee710703fooEv();
extern void _ZN7ee710703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee710703barEv,_ZTv0_n16_N7ee710703barEv)();
extern void ABISELECT(_ZThn32_N7ee710703barEv,_ZThn16_N7ee710703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee710703fooEv,_ZTv0_n20_N7ee710703fooEv)();
extern void ABISELECT(_ZThn32_N7ee710703fooEv,_ZThn16_N7ee710703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71070[0]),
  (VTBL_ENTRY)&_ZN7ee710703fooEv,
  (VTBL_ENTRY)&_ZN7ee710703barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71070[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee710703barEv,_ZTv0_n16_N7ee710703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee710703fooEv,_ZTv0_n20_N7ee710703fooEv),
};
extern VTBL_ENTRY _ZTV7ee71070[];
static  VTBL_ENTRY _tg__ZTV6dd1070__7ee71070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd1070__7ee71070[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee71070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee71070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee71070[] = {
  {&(_ZTV7ee71070[5]),  5,18},
  {&(_ZTV7ee71070[11]),  11,18},
  {&(_ZTV7ee71070[16]),  16,18},
  {&(_tg__ZTV6dd1070__7ee71070[4]),  4,4},
  {&(_tg__ZTV5cc070__6dd1070__7ee71070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee71070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee71070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee71070[];
extern  VTBL_ENTRY _ZTV7ee71070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71070[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee710703fooEv,_ZTv0_n20_N7ee710703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710703fooEv,_ZThn16_N7ee710703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee710703barEv,_ZTv0_n16_N7ee710703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710703barEv,_ZThn16_N7ee710703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71070 = {  "ee71070", // class name
  bases_ee71070, 4,
  &(vtc_ee71070[0]), // expected_vtbl_contents
  &(vtt_ee71070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71070),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2070  : cc070 {
  int d;
  virtual void  foo(); // _ZN6dd20703fooEv
  ~dd2070(); // tgen
  dd2070(); // tgen
};
//SIG(-1 dd2070) C1{ BC2{ BC3{ VBC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd2070 ::foo(){vfunc_called(this, "_ZN6dd20703fooEv");}
dd2070 ::~dd2070(){ note_dtor("dd2070", this);} // tgen
dd2070 ::dd2070(){ note_ctor("dd2070", this);} // tgen

static void Test_dd2070()
{
  extern Class_Descriptor cd_dd2070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2070, buf);
    dd2070 *dp, &lv = *(dp=new (buf) dd2070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(20,16), "dd2070");
    check_base_class_offset(lv, (bb70*)(cc070*), 0, "dd2070");
    check_base_class_offset(lv, (cc070*), 0, "dd2070");
    check_field_offset(lv, d, ABISELECT(16,12), "dd2070.d");
    test_class_info(&lv, &cd_dd2070);
    dp->~dd2070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2070(Test_dd2070, "dd2070", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2070C1Ev();
extern void _ZN6dd2070D1Ev();
Name_Map name_map_dd2070[] = {
  NSPAIR(_ZN6dd2070C1Ev),
  NSPAIR(_ZN6dd2070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd2070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY vtc_dd2070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern VTBL_ENTRY _ZTV6dd2070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd2070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd2070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd2070[] = {
  {&(_ZTV6dd2070[3]),  3,5},
  {&(_tg__ZTV5cc070__6dd2070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd2070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
Class_Descriptor cd_dd2070 = {  "dd2070", // class name
  bases_dd2070, 3,
  &(vtc_dd2070[0]), // expected_vtbl_contents
  &(vtt_dd2070[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2070),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02070  : dd2070 {
  int e;
  ~ee02070(); // tgen
  ee02070(); // tgen
};
//SIG(1 ee02070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee02070 ::~ee02070(){ note_dtor("ee02070", this);} // tgen
ee02070 ::ee02070(){ note_ctor("ee02070", this);} // tgen

static void Test_ee02070()
{
  extern Class_Descriptor cd_ee02070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02070, buf);
    ee02070 *dp, &lv = *(dp=new (buf) ee02070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(24,20), "ee02070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), 0, "ee02070");
    check_base_class_offset(lv, (cc070*)(dd2070*), 0, "ee02070");
    check_base_class_offset(lv, (dd2070*), 0, "ee02070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee02070.e");
    test_class_info(&lv, &cd_ee02070);
    dp->~ee02070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02070(Test_ee02070, "ee02070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02070C1Ev();
extern void _ZN7ee02070D1Ev();
Name_Map name_map_ee02070[] = {
  NSPAIR(_ZN7ee02070C1Ev),
  NSPAIR(_ZN7ee02070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee02070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY vtc_ee02070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern VTBL_ENTRY _ZTV7ee02070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee02070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee02070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee02070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee02070[] = {
  {&(_ZTV7ee02070[3]),  3,5},
  {&(_tg__ZTV6dd2070__7ee02070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee02070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee02070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee02070[];
extern  VTBL_ENTRY _ZTV7ee02070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02070[];
Class_Descriptor cd_ee02070 = {  "ee02070", // class name
  bases_ee02070, 4,
  &(vtc_ee02070[0]), // expected_vtbl_contents
  &(vtt_ee02070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12070  : virtual dd2070 {
  int e;
  ~ee12070(); // tgen
  ee12070(); // tgen
};
//SIG(1 ee12070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee12070 ::~ee12070(){ note_dtor("ee12070", this);} // tgen
ee12070 ::ee12070(){ note_ctor("ee12070", this);} // tgen

static void Test_ee12070()
{
  extern Class_Descriptor cd_ee12070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12070, buf);
    ee12070 *dp, &lv = *(dp=new (buf) ee12070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(36,24), "ee12070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), ABISELECT(16,8), "ee12070");
    check_base_class_offset(lv, (cc070*)(dd2070*), ABISELECT(16,8), "ee12070");
    check_base_class_offset(lv, (dd2070*), ABISELECT(16,8), "ee12070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12070.e");
    test_class_info(&lv, &cd_ee12070);
    dp->~ee12070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12070(Test_ee12070, "ee12070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12070C1Ev();
extern void _ZN7ee12070D1Ev();
Name_Map name_map_ee12070[] = {
  NSPAIR(_ZN7ee12070C1Ev),
  NSPAIR(_ZN7ee12070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee12070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY vtc_ee12070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12070[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern VTBL_ENTRY _ZTV7ee12070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee12070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee12070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee12070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee12070[] = {
  {&(_ZTV7ee12070[4]),  4,11},
  {&(_ZTV7ee12070[9]),  9,11},
  {&(_tg__ZTV6dd2070__7ee12070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee12070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee12070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee12070[];
extern  VTBL_ENTRY _ZTV7ee12070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12070[];
Class_Descriptor cd_ee12070 = {  "ee12070", // class name
  bases_ee12070, 4,
  &(vtc_ee12070[0]), // expected_vtbl_contents
  &(vtt_ee12070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12070),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22070  : dd2070 {
  int e;
  virtual void  foo(); // _ZN7ee220703fooEv
  ~ee22070(); // tgen
  ee22070(); // tgen
};
//SIG(1 ee22070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22070 ::foo(){vfunc_called(this, "_ZN7ee220703fooEv");}
ee22070 ::~ee22070(){ note_dtor("ee22070", this);} // tgen
ee22070 ::ee22070(){ note_ctor("ee22070", this);} // tgen

static void Test_ee22070()
{
  extern Class_Descriptor cd_ee22070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22070, buf);
    ee22070 *dp, &lv = *(dp=new (buf) ee22070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(24,20), "ee22070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), 0, "ee22070");
    check_base_class_offset(lv, (cc070*)(dd2070*), 0, "ee22070");
    check_base_class_offset(lv, (dd2070*), 0, "ee22070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee22070.e");
    test_class_info(&lv, &cd_ee22070);
    dp->~ee22070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22070(Test_ee22070, "ee22070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22070C1Ev();
extern void _ZN7ee22070D1Ev();
Name_Map name_map_ee22070[] = {
  NSPAIR(_ZN7ee22070C1Ev),
  NSPAIR(_ZN7ee22070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee22070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22070[];
extern void _ZN4bb703barEv();
extern void _ZN7ee220703fooEv();
static  VTBL_ENTRY vtc_ee22070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN7ee220703fooEv,
};
extern VTBL_ENTRY _ZTV7ee22070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee22070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee22070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee22070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee22070[] = {
  {&(_ZTV7ee22070[3]),  3,5},
  {&(_tg__ZTV6dd2070__7ee22070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee22070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee22070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee22070[];
extern  VTBL_ENTRY _ZTV7ee22070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22070[];
Class_Descriptor cd_ee22070 = {  "ee22070", // class name
  bases_ee22070, 4,
  &(vtc_ee22070[0]), // expected_vtbl_contents
  &(vtt_ee22070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32070  : virtual dd2070 {
  int e;
  virtual void  foo(); // _ZN7ee320703fooEv
  ~ee32070(); // tgen
  ee32070(); // tgen
};
//SIG(1 ee32070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32070 ::foo(){vfunc_called(this, "_ZN7ee320703fooEv");}
ee32070 ::~ee32070(){ note_dtor("ee32070", this);} // tgen
ee32070 ::ee32070(){ note_ctor("ee32070", this);} // tgen

static void Test_ee32070()
{
  extern Class_Descriptor cd_ee32070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32070, buf);
    ee32070 *dp, &lv = *(dp=new (buf) ee32070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(36,24), "ee32070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), ABISELECT(16,8), "ee32070");
    check_base_class_offset(lv, (cc070*)(dd2070*), ABISELECT(16,8), "ee32070");
    check_base_class_offset(lv, (dd2070*), ABISELECT(16,8), "ee32070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32070.e");
    test_class_info(&lv, &cd_ee32070);
    dp->~ee32070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32070(Test_ee32070, "ee32070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32070C1Ev();
extern void _ZN7ee32070D1Ev();
Name_Map name_map_ee32070[] = {
  NSPAIR(_ZN7ee32070C1Ev),
  NSPAIR(_ZN7ee32070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee32070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32070[];
extern void _ZN7ee320703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee320703fooEv,_ZTv0_n20_N7ee320703fooEv)();
extern void ABISELECT(_ZThn16_N7ee320703fooEv,_ZThn8_N7ee320703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32070[0]),
  (VTBL_ENTRY)&_ZN7ee320703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee320703fooEv,_ZTv0_n20_N7ee320703fooEv),
};
extern VTBL_ENTRY _ZTV7ee32070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee32070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee32070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee32070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee32070[] = {
  {&(_ZTV7ee32070[4]),  4,12},
  {&(_ZTV7ee32070[10]),  10,12},
  {&(_tg__ZTV6dd2070__7ee32070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee32070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee32070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee32070[];
extern  VTBL_ENTRY _ZTV7ee32070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32070[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee320703fooEv,_ZTv0_n20_N7ee320703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320703fooEv,_ZThn8_N7ee320703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32070 = {  "ee32070", // class name
  bases_ee32070, 4,
  &(vtc_ee32070[0]), // expected_vtbl_contents
  &(vtt_ee32070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42070  : dd2070 {
  int e;
  virtual void  bar(); // _ZN7ee420703barEv
  ~ee42070(); // tgen
  ee42070(); // tgen
};
//SIG(1 ee42070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42070 ::bar(){vfunc_called(this, "_ZN7ee420703barEv");}
ee42070 ::~ee42070(){ note_dtor("ee42070", this);} // tgen
ee42070 ::ee42070(){ note_ctor("ee42070", this);} // tgen

static void Test_ee42070()
{
  extern Class_Descriptor cd_ee42070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42070, buf);
    ee42070 *dp, &lv = *(dp=new (buf) ee42070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(24,20), "ee42070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), 0, "ee42070");
    check_base_class_offset(lv, (cc070*)(dd2070*), 0, "ee42070");
    check_base_class_offset(lv, (dd2070*), 0, "ee42070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee42070.e");
    test_class_info(&lv, &cd_ee42070);
    dp->~ee42070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42070(Test_ee42070, "ee42070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42070C1Ev();
extern void _ZN7ee42070D1Ev();
Name_Map name_map_ee42070[] = {
  NSPAIR(_ZN7ee42070C1Ev),
  NSPAIR(_ZN7ee42070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee42070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42070[];
extern void _ZN7ee420703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY vtc_ee42070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42070[0]),
  (VTBL_ENTRY)&_ZN7ee420703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern VTBL_ENTRY _ZTV7ee42070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee42070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee42070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee42070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee42070[] = {
  {&(_ZTV7ee42070[3]),  3,5},
  {&(_tg__ZTV6dd2070__7ee42070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee42070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee42070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee42070[];
extern  VTBL_ENTRY _ZTV7ee42070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42070[];
Class_Descriptor cd_ee42070 = {  "ee42070", // class name
  bases_ee42070, 4,
  &(vtc_ee42070[0]), // expected_vtbl_contents
  &(vtt_ee42070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52070  : virtual dd2070 {
  int e;
  virtual void  bar(); // _ZN7ee520703barEv
  ~ee52070(); // tgen
  ee52070(); // tgen
};
//SIG(1 ee52070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52070 ::bar(){vfunc_called(this, "_ZN7ee520703barEv");}
ee52070 ::~ee52070(){ note_dtor("ee52070", this);} // tgen
ee52070 ::ee52070(){ note_ctor("ee52070", this);} // tgen

static void Test_ee52070()
{
  extern Class_Descriptor cd_ee52070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52070, buf);
    ee52070 *dp, &lv = *(dp=new (buf) ee52070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(36,24), "ee52070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), ABISELECT(16,8), "ee52070");
    check_base_class_offset(lv, (cc070*)(dd2070*), ABISELECT(16,8), "ee52070");
    check_base_class_offset(lv, (dd2070*), ABISELECT(16,8), "ee52070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52070.e");
    test_class_info(&lv, &cd_ee52070);
    dp->~ee52070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52070(Test_ee52070, "ee52070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52070C1Ev();
extern void _ZN7ee52070D1Ev();
Name_Map name_map_ee52070[] = {
  NSPAIR(_ZN7ee52070C1Ev),
  NSPAIR(_ZN7ee52070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee52070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52070[];
extern void _ZN7ee520703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee520703barEv,_ZTv0_n16_N7ee520703barEv)();
extern void ABISELECT(_ZThn16_N7ee520703barEv,_ZThn8_N7ee520703barEv)() __attribute__((weak));
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY vtc_ee52070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52070[0]),
  (VTBL_ENTRY)&_ZN7ee520703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee520703barEv,_ZTv0_n16_N7ee520703barEv),
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern VTBL_ENTRY _ZTV7ee52070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee52070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee52070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee52070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee52070[] = {
  {&(_ZTV7ee52070[4]),  4,12},
  {&(_ZTV7ee52070[10]),  10,12},
  {&(_tg__ZTV6dd2070__7ee52070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee52070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee52070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee52070[];
extern  VTBL_ENTRY _ZTV7ee52070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52070[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee520703barEv,_ZTv0_n16_N7ee520703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee520703barEv,_ZThn8_N7ee520703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52070 = {  "ee52070", // class name
  bases_ee52070, 4,
  &(vtc_ee52070[0]), // expected_vtbl_contents
  &(vtt_ee52070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62070  : dd2070 {
  int e;
  virtual void  foo(); // _ZN7ee620703fooEv
  virtual void  bar(); // _ZN7ee620703barEv
  ~ee62070(); // tgen
  ee62070(); // tgen
};
//SIG(1 ee62070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62070 ::foo(){vfunc_called(this, "_ZN7ee620703fooEv");}
void  ee62070 ::bar(){vfunc_called(this, "_ZN7ee620703barEv");}
ee62070 ::~ee62070(){ note_dtor("ee62070", this);} // tgen
ee62070 ::ee62070(){ note_ctor("ee62070", this);} // tgen

static void Test_ee62070()
{
  extern Class_Descriptor cd_ee62070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62070, buf);
    ee62070 *dp, &lv = *(dp=new (buf) ee62070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(24,20), "ee62070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), 0, "ee62070");
    check_base_class_offset(lv, (cc070*)(dd2070*), 0, "ee62070");
    check_base_class_offset(lv, (dd2070*), 0, "ee62070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee62070.e");
    test_class_info(&lv, &cd_ee62070);
    dp->~ee62070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62070(Test_ee62070, "ee62070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62070C1Ev();
extern void _ZN7ee62070D1Ev();
Name_Map name_map_ee62070[] = {
  NSPAIR(_ZN7ee62070C1Ev),
  NSPAIR(_ZN7ee62070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee62070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62070[];
extern void _ZN7ee620703barEv();
extern void _ZN7ee620703fooEv();
static  VTBL_ENTRY vtc_ee62070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62070[0]),
  (VTBL_ENTRY)&_ZN7ee620703barEv,
  (VTBL_ENTRY)&_ZN7ee620703fooEv,
};
extern VTBL_ENTRY _ZTV7ee62070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee62070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee62070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee62070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee62070[] = {
  {&(_ZTV7ee62070[3]),  3,5},
  {&(_tg__ZTV6dd2070__7ee62070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee62070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee62070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee62070[];
extern  VTBL_ENTRY _ZTV7ee62070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62070[];
Class_Descriptor cd_ee62070 = {  "ee62070", // class name
  bases_ee62070, 4,
  &(vtc_ee62070[0]), // expected_vtbl_contents
  &(vtt_ee62070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72070  : virtual dd2070 {
  int e;
  virtual void  foo(); // _ZN7ee720703fooEv
  virtual void  bar(); // _ZN7ee720703barEv
  ~ee72070(); // tgen
  ee72070(); // tgen
};
//SIG(1 ee72070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72070 ::foo(){vfunc_called(this, "_ZN7ee720703fooEv");}
void  ee72070 ::bar(){vfunc_called(this, "_ZN7ee720703barEv");}
ee72070 ::~ee72070(){ note_dtor("ee72070", this);} // tgen
ee72070 ::ee72070(){ note_ctor("ee72070", this);} // tgen

static void Test_ee72070()
{
  extern Class_Descriptor cd_ee72070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72070, buf);
    ee72070 *dp, &lv = *(dp=new (buf) ee72070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd2070*), ABISELECT(36,24), "ee72070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd2070*), ABISELECT(16,8), "ee72070");
    check_base_class_offset(lv, (cc070*)(dd2070*), ABISELECT(16,8), "ee72070");
    check_base_class_offset(lv, (dd2070*), ABISELECT(16,8), "ee72070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72070.e");
    test_class_info(&lv, &cd_ee72070);
    dp->~ee72070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72070(Test_ee72070, "ee72070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72070C1Ev();
extern void _ZN7ee72070D1Ev();
Name_Map name_map_ee72070[] = {
  NSPAIR(_ZN7ee72070C1Ev),
  NSPAIR(_ZN7ee72070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd2070;
extern VTBL_ENTRY _ZTI6dd2070[];
extern  VTBL_ENTRY _ZTV6dd2070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2070[];
static Base_Class bases_ee72070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72070[];
extern void _ZN7ee720703fooEv();
extern void _ZN7ee720703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee720703barEv,_ZTv0_n16_N7ee720703barEv)();
extern void ABISELECT(_ZThn16_N7ee720703barEv,_ZThn8_N7ee720703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee720703fooEv,_ZTv0_n20_N7ee720703fooEv)();
extern void ABISELECT(_ZThn16_N7ee720703fooEv,_ZThn8_N7ee720703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72070[0]),
  (VTBL_ENTRY)&_ZN7ee720703fooEv,
  (VTBL_ENTRY)&_ZN7ee720703barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee720703barEv,_ZTv0_n16_N7ee720703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee720703fooEv,_ZTv0_n20_N7ee720703fooEv),
};
extern VTBL_ENTRY _ZTV7ee72070[];
extern void _ZN4bb703barEv();
extern void _ZN6dd20703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2070__7ee72070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN6dd20703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd2070__7ee72070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd2070__7ee72070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee72070[] = {
  {&(_ZTV7ee72070[4]),  4,13},
  {&(_ZTV7ee72070[11]),  11,13},
  {&(_tg__ZTV6dd2070__7ee72070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd2070__7ee72070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd2070__7ee72070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee72070[];
extern  VTBL_ENTRY _ZTV7ee72070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72070[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee720703fooEv,_ZTv0_n20_N7ee720703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720703fooEv,_ZThn8_N7ee720703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee720703barEv,_ZTv0_n16_N7ee720703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720703barEv,_ZThn8_N7ee720703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72070 = {  "ee72070", // class name
  bases_ee72070, 4,
  &(vtc_ee72070[0]), // expected_vtbl_contents
  &(vtt_ee72070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3070  : virtual cc070 {
  int d;
  virtual void  foo(); // _ZN6dd30703fooEv
  ~dd3070(); // tgen
  dd3070(); // tgen
};
//SIG(-1 dd3070) C1{ VBC2{ BC3{ VBC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd3070 ::foo(){vfunc_called(this, "_ZN6dd30703fooEv");}
dd3070 ::~dd3070(){ note_dtor("dd3070", this);} // tgen
dd3070 ::dd3070(){ note_ctor("dd3070", this);} // tgen

static void Test_dd3070()
{
  extern Class_Descriptor cd_dd3070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3070, buf);
    dd3070 *dp, &lv = *(dp=new (buf) dd3070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,20), "dd3070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,8), "dd3070");
    check_base_class_offset(lv, (cc070*), ABISELECT(16,8), "dd3070");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3070.d");
    test_class_info(&lv, &cd_dd3070);
    dp->~dd3070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3070(Test_dd3070, "dd3070", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3070C1Ev();
extern void _ZN6dd3070D1Ev();
Name_Map name_map_dd3070[] = {
  NSPAIR(_ZN6dd3070C1Ev),
  NSPAIR(_ZN6dd3070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd3070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3070[];
extern void _ZN6dd30703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern VTBL_ENTRY _ZTV6dd3070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd3070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd3070[] = {
  {&(_ZTV6dd3070[4]),  4,12},
  {&(_ZTV6dd3070[10]),  10,12},
  {&(_tg__ZTV5cc070__6dd3070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd3070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3070 = {  "dd3070", // class name
  bases_dd3070, 3,
  &(vtc_dd3070[0]), // expected_vtbl_contents
  &(vtt_dd3070[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3070),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03070  : dd3070 {
  int e;
  ~ee03070(); // tgen
  ee03070(); // tgen
};
//SIG(1 ee03070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee03070 ::~ee03070(){ note_dtor("ee03070", this);} // tgen
ee03070 ::ee03070(){ note_ctor("ee03070", this);} // tgen

static void Test_ee03070()
{
  extern Class_Descriptor cd_ee03070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03070, buf);
    ee03070 *dp, &lv = *(dp=new (buf) ee03070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee03070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee03070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(16,12), "ee03070");
    check_base_class_offset(lv, (dd3070*), 0, "ee03070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03070.e");
    test_class_info(&lv, &cd_ee03070);
    dp->~ee03070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03070(Test_ee03070, "ee03070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03070C1Ev();
extern void _ZN7ee03070D1Ev();
Name_Map name_map_ee03070[] = {
  NSPAIR(_ZN7ee03070C1Ev),
  NSPAIR(_ZN7ee03070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee03070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03070[];
extern void _ZN6dd30703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern VTBL_ENTRY _ZTV7ee03070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee03070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee03070[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee03070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee03070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee03070[] = {
  {&(_ZTV7ee03070[4]),  4,12},
  {&(_tg__ZTV6dd3070__7ee03070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee03070[5]),  5,7},
  {&(_ZTV7ee03070[10]),  10,12},
  {&(_tg__ZTV5cc070__7ee03070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee03070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee03070[];
extern  VTBL_ENTRY _ZTV7ee03070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03070[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03070 = {  "ee03070", // class name
  bases_ee03070, 4,
  &(vtc_ee03070[0]), // expected_vtbl_contents
  &(vtt_ee03070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13070  : virtual dd3070 {
  int e;
  ~ee13070(); // tgen
  ee13070(); // tgen
};
//SIG(1 ee13070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee13070 ::~ee13070(){ note_dtor("ee13070", this);} // tgen
ee13070 ::ee13070(){ note_ctor("ee13070", this);} // tgen

static void Test_ee13070()
{
  extern Class_Descriptor cd_ee13070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13070, buf);
    ee13070 *dp, &lv = *(dp=new (buf) ee13070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee13070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee13070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(32,16), "ee13070");
    check_base_class_offset(lv, (dd3070*), ABISELECT(16,8), "ee13070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13070.e");
    test_class_info(&lv, &cd_ee13070);
    dp->~ee13070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13070(Test_ee13070, "ee13070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13070C1Ev();
extern void _ZN7ee13070D1Ev();
Name_Map name_map_ee13070[] = {
  NSPAIR(_ZN7ee13070C1Ev),
  NSPAIR(_ZN7ee13070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee13070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13070[];
extern void _ZN6dd30703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13070[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern VTBL_ENTRY _ZTV7ee13070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee13070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee13070[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee13070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee13070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee13070[] = {
  {&(_ZTV7ee13070[5]),  5,18},
  {&(_ZTV7ee13070[10]),  10,18},
  {&(_ZTV7ee13070[16]),  16,18},
  {&(_tg__ZTV6dd3070__7ee13070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee13070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee13070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee13070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee13070[];
extern  VTBL_ENTRY _ZTV7ee13070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13070[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13070 = {  "ee13070", // class name
  bases_ee13070, 4,
  &(vtc_ee13070[0]), // expected_vtbl_contents
  &(vtt_ee13070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13070),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23070  : dd3070 {
  int e;
  virtual void  foo(); // _ZN7ee230703fooEv
  ~ee23070(); // tgen
  ee23070(); // tgen
};
//SIG(1 ee23070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23070 ::foo(){vfunc_called(this, "_ZN7ee230703fooEv");}
ee23070 ::~ee23070(){ note_dtor("ee23070", this);} // tgen
ee23070 ::ee23070(){ note_ctor("ee23070", this);} // tgen

static void Test_ee23070()
{
  extern Class_Descriptor cd_ee23070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23070, buf);
    ee23070 *dp, &lv = *(dp=new (buf) ee23070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee23070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee23070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(16,12), "ee23070");
    check_base_class_offset(lv, (dd3070*), 0, "ee23070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23070.e");
    test_class_info(&lv, &cd_ee23070);
    dp->~ee23070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23070(Test_ee23070, "ee23070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23070C1Ev();
extern void _ZN7ee23070D1Ev();
Name_Map name_map_ee23070[] = {
  NSPAIR(_ZN7ee23070C1Ev),
  NSPAIR(_ZN7ee23070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee23070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23070[];
extern void _ZN7ee230703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee230703fooEv,_ZTv0_n20_N7ee230703fooEv)();
extern void ABISELECT(_ZThn16_N7ee230703fooEv,_ZThn12_N7ee230703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23070[0]),
  (VTBL_ENTRY)&_ZN7ee230703fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee230703fooEv,_ZTv0_n20_N7ee230703fooEv),
};
extern VTBL_ENTRY _ZTV7ee23070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee23070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee23070[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee23070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee23070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee23070[] = {
  {&(_ZTV7ee23070[4]),  4,12},
  {&(_tg__ZTV6dd3070__7ee23070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee23070[5]),  5,7},
  {&(_ZTV7ee23070[10]),  10,12},
  {&(_tg__ZTV5cc070__7ee23070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee23070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee23070[];
extern  VTBL_ENTRY _ZTV7ee23070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23070[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee230703fooEv,_ZTv0_n20_N7ee230703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee230703fooEv,_ZThn12_N7ee230703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23070 = {  "ee23070", // class name
  bases_ee23070, 4,
  &(vtc_ee23070[0]), // expected_vtbl_contents
  &(vtt_ee23070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33070  : virtual dd3070 {
  int e;
  virtual void  foo(); // _ZN7ee330703fooEv
  ~ee33070(); // tgen
  ee33070(); // tgen
};
//SIG(1 ee33070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33070 ::foo(){vfunc_called(this, "_ZN7ee330703fooEv");}
ee33070 ::~ee33070(){ note_dtor("ee33070", this);} // tgen
ee33070 ::ee33070(){ note_ctor("ee33070", this);} // tgen

static void Test_ee33070()
{
  extern Class_Descriptor cd_ee33070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33070, buf);
    ee33070 *dp, &lv = *(dp=new (buf) ee33070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee33070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee33070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(32,16), "ee33070");
    check_base_class_offset(lv, (dd3070*), ABISELECT(16,8), "ee33070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33070.e");
    test_class_info(&lv, &cd_ee33070);
    dp->~ee33070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33070(Test_ee33070, "ee33070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33070C1Ev();
extern void _ZN7ee33070D1Ev();
Name_Map name_map_ee33070[] = {
  NSPAIR(_ZN7ee33070C1Ev),
  NSPAIR(_ZN7ee33070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee33070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33070[];
extern void _ZN7ee330703fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee330703fooEv,_ZTv0_n20_N7ee330703fooEv)();
extern void ABISELECT(_ZThn16_N7ee330703fooEv,_ZThn8_N7ee330703fooEv)() __attribute__((weak));
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee330703fooEv,_ZTv0_n20_N7ee330703fooEv)();
extern void ABISELECT(_ZThn32_N7ee330703fooEv,_ZThn16_N7ee330703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33070[0]),
  (VTBL_ENTRY)&_ZN7ee330703fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee330703fooEv,_ZTv0_n20_N7ee330703fooEv),
  ABISELECT(-32,-16),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee330703fooEv,_ZTv0_n20_N7ee330703fooEv),
};
extern VTBL_ENTRY _ZTV7ee33070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee33070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee33070[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee33070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee33070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee33070[] = {
  {&(_ZTV7ee33070[5]),  5,19},
  {&(_ZTV7ee33070[11]),  11,19},
  {&(_ZTV7ee33070[17]),  17,19},
  {&(_tg__ZTV6dd3070__7ee33070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee33070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee33070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee33070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee33070[];
extern  VTBL_ENTRY _ZTV7ee33070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33070[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee330703fooEv,_ZTv0_n20_N7ee330703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee330703fooEv,_ZThn16_N7ee330703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330703fooEv,_ZThn8_N7ee330703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33070 = {  "ee33070", // class name
  bases_ee33070, 4,
  &(vtc_ee33070[0]), // expected_vtbl_contents
  &(vtt_ee33070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33070),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43070  : dd3070 {
  int e;
  virtual void  bar(); // _ZN7ee430703barEv
  ~ee43070(); // tgen
  ee43070(); // tgen
};
//SIG(1 ee43070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43070 ::bar(){vfunc_called(this, "_ZN7ee430703barEv");}
ee43070 ::~ee43070(){ note_dtor("ee43070", this);} // tgen
ee43070 ::ee43070(){ note_ctor("ee43070", this);} // tgen

static void Test_ee43070()
{
  extern Class_Descriptor cd_ee43070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43070, buf);
    ee43070 *dp, &lv = *(dp=new (buf) ee43070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee43070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee43070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(16,12), "ee43070");
    check_base_class_offset(lv, (dd3070*), 0, "ee43070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43070.e");
    test_class_info(&lv, &cd_ee43070);
    dp->~ee43070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43070(Test_ee43070, "ee43070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43070C1Ev();
extern void _ZN7ee43070D1Ev();
Name_Map name_map_ee43070[] = {
  NSPAIR(_ZN7ee43070C1Ev),
  NSPAIR(_ZN7ee43070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee43070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43070[];
extern void _ZN6dd30703fooEv();
extern void _ZN7ee430703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee430703barEv,_ZTv0_n16_N7ee430703barEv)();
extern void ABISELECT(_ZThn16_N7ee430703barEv,_ZThn12_N7ee430703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
  (VTBL_ENTRY)&_ZN7ee430703barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee430703barEv,_ZTv0_n16_N7ee430703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern VTBL_ENTRY _ZTV7ee43070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee43070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee43070[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee43070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee43070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee43070[] = {
  {&(_ZTV7ee43070[4]),  4,13},
  {&(_tg__ZTV6dd3070__7ee43070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee43070[5]),  5,7},
  {&(_ZTV7ee43070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee43070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee43070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee43070[];
extern  VTBL_ENTRY _ZTV7ee43070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43070[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee430703barEv,_ZTv0_n16_N7ee430703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee430703barEv,_ZThn12_N7ee430703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43070 = {  "ee43070", // class name
  bases_ee43070, 4,
  &(vtc_ee43070[0]), // expected_vtbl_contents
  &(vtt_ee43070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53070  : virtual dd3070 {
  int e;
  virtual void  bar(); // _ZN7ee530703barEv
  ~ee53070(); // tgen
  ee53070(); // tgen
};
//SIG(1 ee53070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53070 ::bar(){vfunc_called(this, "_ZN7ee530703barEv");}
ee53070 ::~ee53070(){ note_dtor("ee53070", this);} // tgen
ee53070 ::ee53070(){ note_ctor("ee53070", this);} // tgen

static void Test_ee53070()
{
  extern Class_Descriptor cd_ee53070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53070, buf);
    ee53070 *dp, &lv = *(dp=new (buf) ee53070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee53070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee53070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(32,16), "ee53070");
    check_base_class_offset(lv, (dd3070*), ABISELECT(16,8), "ee53070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53070.e");
    test_class_info(&lv, &cd_ee53070);
    dp->~ee53070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53070(Test_ee53070, "ee53070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53070C1Ev();
extern void _ZN7ee53070D1Ev();
Name_Map name_map_ee53070[] = {
  NSPAIR(_ZN7ee53070C1Ev),
  NSPAIR(_ZN7ee53070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee53070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53070[];
extern void _ZN7ee530703barEv();
extern void _ZN6dd30703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee530703barEv,_ZTv0_n16_N7ee530703barEv)();
extern void ABISELECT(_ZThn32_N7ee530703barEv,_ZThn16_N7ee530703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53070[0]),
  (VTBL_ENTRY)&_ZN7ee530703barEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee530703barEv,_ZTv0_n16_N7ee530703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern VTBL_ENTRY _ZTV7ee53070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee53070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee53070[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee53070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee53070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee53070[] = {
  {&(_ZTV7ee53070[5]),  5,19},
  {&(_ZTV7ee53070[11]),  11,19},
  {&(_ZTV7ee53070[17]),  17,19},
  {&(_tg__ZTV6dd3070__7ee53070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee53070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee53070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee53070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee53070[];
extern  VTBL_ENTRY _ZTV7ee53070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53070[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee530703barEv,_ZTv0_n16_N7ee530703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee530703barEv,_ZThn16_N7ee530703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53070 = {  "ee53070", // class name
  bases_ee53070, 4,
  &(vtc_ee53070[0]), // expected_vtbl_contents
  &(vtt_ee53070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53070),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63070  : dd3070 {
  int e;
  virtual void  foo(); // _ZN7ee630703fooEv
  virtual void  bar(); // _ZN7ee630703barEv
  ~ee63070(); // tgen
  ee63070(); // tgen
};
//SIG(1 ee63070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63070 ::foo(){vfunc_called(this, "_ZN7ee630703fooEv");}
void  ee63070 ::bar(){vfunc_called(this, "_ZN7ee630703barEv");}
ee63070 ::~ee63070(){ note_dtor("ee63070", this);} // tgen
ee63070 ::ee63070(){ note_ctor("ee63070", this);} // tgen

static void Test_ee63070()
{
  extern Class_Descriptor cd_ee63070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63070, buf);
    ee63070 *dp, &lv = *(dp=new (buf) ee63070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee63070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee63070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(16,12), "ee63070");
    check_base_class_offset(lv, (dd3070*), 0, "ee63070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63070.e");
    test_class_info(&lv, &cd_ee63070);
    dp->~ee63070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63070(Test_ee63070, "ee63070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63070C1Ev();
extern void _ZN7ee63070D1Ev();
Name_Map name_map_ee63070[] = {
  NSPAIR(_ZN7ee63070C1Ev),
  NSPAIR(_ZN7ee63070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee63070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63070[];
extern void _ZN7ee630703fooEv();
extern void _ZN7ee630703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee630703barEv,_ZTv0_n16_N7ee630703barEv)();
extern void ABISELECT(_ZThn16_N7ee630703barEv,_ZThn12_N7ee630703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee630703fooEv,_ZTv0_n20_N7ee630703fooEv)();
extern void ABISELECT(_ZThn16_N7ee630703fooEv,_ZThn12_N7ee630703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63070[0]),
  (VTBL_ENTRY)&_ZN7ee630703fooEv,
  (VTBL_ENTRY)&_ZN7ee630703barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee630703barEv,_ZTv0_n16_N7ee630703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee630703fooEv,_ZTv0_n20_N7ee630703fooEv),
};
extern VTBL_ENTRY _ZTV7ee63070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee63070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee63070[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee63070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee63070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee63070[] = {
  {&(_ZTV7ee63070[4]),  4,13},
  {&(_tg__ZTV6dd3070__7ee63070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee63070[5]),  5,7},
  {&(_ZTV7ee63070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee63070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee63070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee63070[];
extern  VTBL_ENTRY _ZTV7ee63070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63070[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn12_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee630703fooEv,_ZTv0_n20_N7ee630703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630703fooEv,_ZThn12_N7ee630703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee630703barEv,_ZTv0_n16_N7ee630703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630703barEv,_ZThn12_N7ee630703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63070 = {  "ee63070", // class name
  bases_ee63070, 4,
  &(vtc_ee63070[0]), // expected_vtbl_contents
  &(vtt_ee63070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73070  : virtual dd3070 {
  int e;
  virtual void  foo(); // _ZN7ee730703fooEv
  virtual void  bar(); // _ZN7ee730703barEv
  ~ee73070(); // tgen
  ee73070(); // tgen
};
//SIG(1 ee73070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73070 ::foo(){vfunc_called(this, "_ZN7ee730703fooEv");}
void  ee73070 ::bar(){vfunc_called(this, "_ZN7ee730703barEv");}
ee73070 ::~ee73070(){ note_dtor("ee73070", this);} // tgen
ee73070 ::ee73070(){ note_ctor("ee73070", this);} // tgen

static void Test_ee73070()
{
  extern Class_Descriptor cd_ee73070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73070, buf);
    ee73070 *dp, &lv = *(dp=new (buf) ee73070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee73070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee73070");
    check_base_class_offset(lv, (cc070*)(dd3070*), ABISELECT(32,16), "ee73070");
    check_base_class_offset(lv, (dd3070*), ABISELECT(16,8), "ee73070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73070.e");
    test_class_info(&lv, &cd_ee73070);
    dp->~ee73070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73070(Test_ee73070, "ee73070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73070C1Ev();
extern void _ZN7ee73070D1Ev();
Name_Map name_map_ee73070[] = {
  NSPAIR(_ZN7ee73070C1Ev),
  NSPAIR(_ZN7ee73070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd3070;
extern VTBL_ENTRY _ZTI6dd3070[];
extern  VTBL_ENTRY _ZTV6dd3070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3070[];
static Base_Class bases_ee73070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3070,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73070[];
extern void _ZN7ee730703fooEv();
extern void _ZN7ee730703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee730703fooEv,_ZTv0_n20_N7ee730703fooEv)();
extern void ABISELECT(_ZThn16_N7ee730703fooEv,_ZThn8_N7ee730703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee730703barEv,_ZTv0_n16_N7ee730703barEv)();
extern void ABISELECT(_ZThn32_N7ee730703barEv,_ZThn16_N7ee730703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee730703fooEv,_ZTv0_n20_N7ee730703fooEv)();
extern void ABISELECT(_ZThn32_N7ee730703fooEv,_ZThn16_N7ee730703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73070[0]),
  (VTBL_ENTRY)&_ZN7ee730703fooEv,
  (VTBL_ENTRY)&_ZN7ee730703barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee730703fooEv,_ZTv0_n20_N7ee730703fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730703barEv,_ZTv0_n16_N7ee730703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee730703fooEv,_ZTv0_n20_N7ee730703fooEv),
};
extern VTBL_ENTRY _ZTV7ee73070[];
extern void _ZN6dd30703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3070__7ee73070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN6dd30703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv)();
extern void ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd3070__7ee73070[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee73070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee73070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee73070[] = {
  {&(_ZTV7ee73070[5]),  5,20},
  {&(_ZTV7ee73070[12]),  12,20},
  {&(_ZTV7ee73070[18]),  18,20},
  {&(_tg__ZTV6dd3070__7ee73070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd3070__7ee73070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee73070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee73070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee73070[];
extern  VTBL_ENTRY _ZTV7ee73070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73070[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd30703fooEv,_ZTv0_n20_N6dd30703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30703fooEv,_ZThn8_N6dd30703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee730703barEv,_ZTv0_n16_N7ee730703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730703barEv,_ZThn16_N7ee730703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee730703fooEv,_ZTv0_n20_N7ee730703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730703fooEv,_ZThn16_N7ee730703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730703fooEv,_ZThn8_N7ee730703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73070 = {  "ee73070", // class name
  bases_ee73070, 4,
  &(vtc_ee73070[0]), // expected_vtbl_contents
  &(vtt_ee73070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73070),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4070  : cc070 {
  int d;
  virtual void  bar(); // _ZN6dd40703barEv
  ~dd4070(); // tgen
  dd4070(); // tgen
};
//SIG(-1 dd4070) C1{ BC2{ BC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd4070 ::bar(){vfunc_called(this, "_ZN6dd40703barEv");}
dd4070 ::~dd4070(){ note_dtor("dd4070", this);} // tgen
dd4070 ::dd4070(){ note_ctor("dd4070", this);} // tgen

static void Test_dd4070()
{
  extern Class_Descriptor cd_dd4070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4070, buf);
    dd4070 *dp, &lv = *(dp=new (buf) dd4070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(20,16), "dd4070");
    check_base_class_offset(lv, (bb70*)(cc070*), 0, "dd4070");
    check_base_class_offset(lv, (cc070*), 0, "dd4070");
    check_field_offset(lv, d, ABISELECT(16,12), "dd4070.d");
    test_class_info(&lv, &cd_dd4070);
    dp->~dd4070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4070(Test_dd4070, "dd4070", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4070C1Ev();
extern void _ZN6dd4070D1Ev();
Name_Map name_map_dd4070[] = {
  NSPAIR(_ZN6dd4070C1Ev),
  NSPAIR(_ZN6dd4070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd4070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd4070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd4070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd4070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd4070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd4070[] = {
  {&(_ZTV6dd4070[3]),  3,5},
  {&(_tg__ZTV5cc070__6dd4070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd4070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
Class_Descriptor cd_dd4070 = {  "dd4070", // class name
  bases_dd4070, 3,
  &(vtc_dd4070[0]), // expected_vtbl_contents
  &(vtt_dd4070[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4070),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04070  : dd4070 {
  int e;
  ~ee04070(); // tgen
  ee04070(); // tgen
};
//SIG(1 ee04070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee04070 ::~ee04070(){ note_dtor("ee04070", this);} // tgen
ee04070 ::ee04070(){ note_ctor("ee04070", this);} // tgen

static void Test_ee04070()
{
  extern Class_Descriptor cd_ee04070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04070, buf);
    ee04070 *dp, &lv = *(dp=new (buf) ee04070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(24,20), "ee04070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), 0, "ee04070");
    check_base_class_offset(lv, (cc070*)(dd4070*), 0, "ee04070");
    check_base_class_offset(lv, (dd4070*), 0, "ee04070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee04070.e");
    test_class_info(&lv, &cd_ee04070);
    dp->~ee04070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04070(Test_ee04070, "ee04070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04070C1Ev();
extern void _ZN7ee04070D1Ev();
Name_Map name_map_ee04070[] = {
  NSPAIR(_ZN7ee04070C1Ev),
  NSPAIR(_ZN7ee04070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee04070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee04070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee04070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee04070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee04070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee04070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee04070[] = {
  {&(_ZTV7ee04070[3]),  3,5},
  {&(_tg__ZTV6dd4070__7ee04070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee04070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee04070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee04070[];
extern  VTBL_ENTRY _ZTV7ee04070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04070[];
Class_Descriptor cd_ee04070 = {  "ee04070", // class name
  bases_ee04070, 4,
  &(vtc_ee04070[0]), // expected_vtbl_contents
  &(vtt_ee04070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14070  : virtual dd4070 {
  int e;
  ~ee14070(); // tgen
  ee14070(); // tgen
};
//SIG(1 ee14070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee14070 ::~ee14070(){ note_dtor("ee14070", this);} // tgen
ee14070 ::ee14070(){ note_ctor("ee14070", this);} // tgen

static void Test_ee14070()
{
  extern Class_Descriptor cd_ee14070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14070, buf);
    ee14070 *dp, &lv = *(dp=new (buf) ee14070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(36,24), "ee14070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), ABISELECT(16,8), "ee14070");
    check_base_class_offset(lv, (cc070*)(dd4070*), ABISELECT(16,8), "ee14070");
    check_base_class_offset(lv, (dd4070*), ABISELECT(16,8), "ee14070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14070.e");
    test_class_info(&lv, &cd_ee14070);
    dp->~ee14070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14070(Test_ee14070, "ee14070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14070C1Ev();
extern void _ZN7ee14070D1Ev();
Name_Map name_map_ee14070[] = {
  NSPAIR(_ZN7ee14070C1Ev),
  NSPAIR(_ZN7ee14070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee14070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee14070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14070[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee14070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee14070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee14070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee14070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee14070[] = {
  {&(_ZTV7ee14070[4]),  4,11},
  {&(_ZTV7ee14070[9]),  9,11},
  {&(_tg__ZTV6dd4070__7ee14070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee14070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee14070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee14070[];
extern  VTBL_ENTRY _ZTV7ee14070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14070[];
Class_Descriptor cd_ee14070 = {  "ee14070", // class name
  bases_ee14070, 4,
  &(vtc_ee14070[0]), // expected_vtbl_contents
  &(vtt_ee14070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14070),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24070  : dd4070 {
  int e;
  virtual void  foo(); // _ZN7ee240703fooEv
  ~ee24070(); // tgen
  ee24070(); // tgen
};
//SIG(1 ee24070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24070 ::foo(){vfunc_called(this, "_ZN7ee240703fooEv");}
ee24070 ::~ee24070(){ note_dtor("ee24070", this);} // tgen
ee24070 ::ee24070(){ note_ctor("ee24070", this);} // tgen

static void Test_ee24070()
{
  extern Class_Descriptor cd_ee24070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24070, buf);
    ee24070 *dp, &lv = *(dp=new (buf) ee24070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(24,20), "ee24070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), 0, "ee24070");
    check_base_class_offset(lv, (cc070*)(dd4070*), 0, "ee24070");
    check_base_class_offset(lv, (dd4070*), 0, "ee24070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee24070.e");
    test_class_info(&lv, &cd_ee24070);
    dp->~ee24070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24070(Test_ee24070, "ee24070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24070C1Ev();
extern void _ZN7ee24070D1Ev();
Name_Map name_map_ee24070[] = {
  NSPAIR(_ZN7ee24070C1Ev),
  NSPAIR(_ZN7ee24070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee24070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24070[];
extern void _ZN6dd40703barEv();
extern void _ZN7ee240703fooEv();
static  VTBL_ENTRY vtc_ee24070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN7ee240703fooEv,
};
extern VTBL_ENTRY _ZTV7ee24070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee24070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee24070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee24070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee24070[] = {
  {&(_ZTV7ee24070[3]),  3,5},
  {&(_tg__ZTV6dd4070__7ee24070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee24070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee24070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee24070[];
extern  VTBL_ENTRY _ZTV7ee24070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24070[];
Class_Descriptor cd_ee24070 = {  "ee24070", // class name
  bases_ee24070, 4,
  &(vtc_ee24070[0]), // expected_vtbl_contents
  &(vtt_ee24070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34070  : virtual dd4070 {
  int e;
  virtual void  foo(); // _ZN7ee340703fooEv
  ~ee34070(); // tgen
  ee34070(); // tgen
};
//SIG(1 ee34070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34070 ::foo(){vfunc_called(this, "_ZN7ee340703fooEv");}
ee34070 ::~ee34070(){ note_dtor("ee34070", this);} // tgen
ee34070 ::ee34070(){ note_ctor("ee34070", this);} // tgen

static void Test_ee34070()
{
  extern Class_Descriptor cd_ee34070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34070, buf);
    ee34070 *dp, &lv = *(dp=new (buf) ee34070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(36,24), "ee34070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), ABISELECT(16,8), "ee34070");
    check_base_class_offset(lv, (cc070*)(dd4070*), ABISELECT(16,8), "ee34070");
    check_base_class_offset(lv, (dd4070*), ABISELECT(16,8), "ee34070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34070.e");
    test_class_info(&lv, &cd_ee34070);
    dp->~ee34070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34070(Test_ee34070, "ee34070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34070C1Ev();
extern void _ZN7ee34070D1Ev();
Name_Map name_map_ee34070[] = {
  NSPAIR(_ZN7ee34070C1Ev),
  NSPAIR(_ZN7ee34070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee34070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34070[];
extern void _ZN7ee340703fooEv();
extern void _ZN6dd40703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee340703fooEv,_ZTv0_n20_N7ee340703fooEv)();
extern void ABISELECT(_ZThn16_N7ee340703fooEv,_ZThn8_N7ee340703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34070[0]),
  (VTBL_ENTRY)&_ZN7ee340703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee340703fooEv,_ZTv0_n20_N7ee340703fooEv),
};
extern VTBL_ENTRY _ZTV7ee34070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee34070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee34070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee34070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee34070[] = {
  {&(_ZTV7ee34070[4]),  4,12},
  {&(_ZTV7ee34070[10]),  10,12},
  {&(_tg__ZTV6dd4070__7ee34070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee34070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee34070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee34070[];
extern  VTBL_ENTRY _ZTV7ee34070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34070[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee340703fooEv,_ZTv0_n20_N7ee340703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee340703fooEv,_ZThn8_N7ee340703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34070 = {  "ee34070", // class name
  bases_ee34070, 4,
  &(vtc_ee34070[0]), // expected_vtbl_contents
  &(vtt_ee34070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44070  : dd4070 {
  int e;
  virtual void  bar(); // _ZN7ee440703barEv
  ~ee44070(); // tgen
  ee44070(); // tgen
};
//SIG(1 ee44070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44070 ::bar(){vfunc_called(this, "_ZN7ee440703barEv");}
ee44070 ::~ee44070(){ note_dtor("ee44070", this);} // tgen
ee44070 ::ee44070(){ note_ctor("ee44070", this);} // tgen

static void Test_ee44070()
{
  extern Class_Descriptor cd_ee44070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44070, buf);
    ee44070 *dp, &lv = *(dp=new (buf) ee44070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(24,20), "ee44070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), 0, "ee44070");
    check_base_class_offset(lv, (cc070*)(dd4070*), 0, "ee44070");
    check_base_class_offset(lv, (dd4070*), 0, "ee44070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee44070.e");
    test_class_info(&lv, &cd_ee44070);
    dp->~ee44070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44070(Test_ee44070, "ee44070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44070C1Ev();
extern void _ZN7ee44070D1Ev();
Name_Map name_map_ee44070[] = {
  NSPAIR(_ZN7ee44070C1Ev),
  NSPAIR(_ZN7ee44070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee44070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44070[];
extern void _ZN7ee440703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee44070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44070[0]),
  (VTBL_ENTRY)&_ZN7ee440703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee44070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee44070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee44070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee44070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee44070[] = {
  {&(_ZTV7ee44070[3]),  3,5},
  {&(_tg__ZTV6dd4070__7ee44070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee44070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee44070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee44070[];
extern  VTBL_ENTRY _ZTV7ee44070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44070[];
Class_Descriptor cd_ee44070 = {  "ee44070", // class name
  bases_ee44070, 4,
  &(vtc_ee44070[0]), // expected_vtbl_contents
  &(vtt_ee44070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54070  : virtual dd4070 {
  int e;
  virtual void  bar(); // _ZN7ee540703barEv
  ~ee54070(); // tgen
  ee54070(); // tgen
};
//SIG(1 ee54070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54070 ::bar(){vfunc_called(this, "_ZN7ee540703barEv");}
ee54070 ::~ee54070(){ note_dtor("ee54070", this);} // tgen
ee54070 ::ee54070(){ note_ctor("ee54070", this);} // tgen

static void Test_ee54070()
{
  extern Class_Descriptor cd_ee54070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54070, buf);
    ee54070 *dp, &lv = *(dp=new (buf) ee54070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(36,24), "ee54070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), ABISELECT(16,8), "ee54070");
    check_base_class_offset(lv, (cc070*)(dd4070*), ABISELECT(16,8), "ee54070");
    check_base_class_offset(lv, (dd4070*), ABISELECT(16,8), "ee54070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54070.e");
    test_class_info(&lv, &cd_ee54070);
    dp->~ee54070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54070(Test_ee54070, "ee54070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54070C1Ev();
extern void _ZN7ee54070D1Ev();
Name_Map name_map_ee54070[] = {
  NSPAIR(_ZN7ee54070C1Ev),
  NSPAIR(_ZN7ee54070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee54070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54070[];
extern void _ZN7ee540703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee540703barEv,_ZTv0_n16_N7ee540703barEv)();
extern void ABISELECT(_ZThn16_N7ee540703barEv,_ZThn8_N7ee540703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee54070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54070[0]),
  (VTBL_ENTRY)&_ZN7ee540703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee540703barEv,_ZTv0_n16_N7ee540703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee54070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee54070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee54070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee54070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee54070[] = {
  {&(_ZTV7ee54070[4]),  4,12},
  {&(_ZTV7ee54070[10]),  10,12},
  {&(_tg__ZTV6dd4070__7ee54070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee54070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee54070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee54070[];
extern  VTBL_ENTRY _ZTV7ee54070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54070[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee540703barEv,_ZTv0_n16_N7ee540703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540703barEv,_ZThn8_N7ee540703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54070 = {  "ee54070", // class name
  bases_ee54070, 4,
  &(vtc_ee54070[0]), // expected_vtbl_contents
  &(vtt_ee54070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64070  : dd4070 {
  int e;
  virtual void  foo(); // _ZN7ee640703fooEv
  virtual void  bar(); // _ZN7ee640703barEv
  ~ee64070(); // tgen
  ee64070(); // tgen
};
//SIG(1 ee64070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64070 ::foo(){vfunc_called(this, "_ZN7ee640703fooEv");}
void  ee64070 ::bar(){vfunc_called(this, "_ZN7ee640703barEv");}
ee64070 ::~ee64070(){ note_dtor("ee64070", this);} // tgen
ee64070 ::ee64070(){ note_ctor("ee64070", this);} // tgen

static void Test_ee64070()
{
  extern Class_Descriptor cd_ee64070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64070, buf);
    ee64070 *dp, &lv = *(dp=new (buf) ee64070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(24,20), "ee64070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), 0, "ee64070");
    check_base_class_offset(lv, (cc070*)(dd4070*), 0, "ee64070");
    check_base_class_offset(lv, (dd4070*), 0, "ee64070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee64070.e");
    test_class_info(&lv, &cd_ee64070);
    dp->~ee64070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64070(Test_ee64070, "ee64070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64070C1Ev();
extern void _ZN7ee64070D1Ev();
Name_Map name_map_ee64070[] = {
  NSPAIR(_ZN7ee64070C1Ev),
  NSPAIR(_ZN7ee64070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee64070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64070[];
extern void _ZN7ee640703barEv();
extern void _ZN7ee640703fooEv();
static  VTBL_ENTRY vtc_ee64070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64070[0]),
  (VTBL_ENTRY)&_ZN7ee640703barEv,
  (VTBL_ENTRY)&_ZN7ee640703fooEv,
};
extern VTBL_ENTRY _ZTV7ee64070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee64070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee64070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee64070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee64070[] = {
  {&(_ZTV7ee64070[3]),  3,5},
  {&(_tg__ZTV6dd4070__7ee64070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee64070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee64070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee64070[];
extern  VTBL_ENTRY _ZTV7ee64070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64070[];
Class_Descriptor cd_ee64070 = {  "ee64070", // class name
  bases_ee64070, 4,
  &(vtc_ee64070[0]), // expected_vtbl_contents
  &(vtt_ee64070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74070  : virtual dd4070 {
  int e;
  virtual void  foo(); // _ZN7ee740703fooEv
  virtual void  bar(); // _ZN7ee740703barEv
  ~ee74070(); // tgen
  ee74070(); // tgen
};
//SIG(1 ee74070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74070 ::foo(){vfunc_called(this, "_ZN7ee740703fooEv");}
void  ee74070 ::bar(){vfunc_called(this, "_ZN7ee740703barEv");}
ee74070 ::~ee74070(){ note_dtor("ee74070", this);} // tgen
ee74070 ::ee74070(){ note_ctor("ee74070", this);} // tgen

static void Test_ee74070()
{
  extern Class_Descriptor cd_ee74070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74070, buf);
    ee74070 *dp, &lv = *(dp=new (buf) ee74070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd4070*), ABISELECT(36,24), "ee74070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd4070*), ABISELECT(16,8), "ee74070");
    check_base_class_offset(lv, (cc070*)(dd4070*), ABISELECT(16,8), "ee74070");
    check_base_class_offset(lv, (dd4070*), ABISELECT(16,8), "ee74070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74070.e");
    test_class_info(&lv, &cd_ee74070);
    dp->~ee74070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74070(Test_ee74070, "ee74070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74070C1Ev();
extern void _ZN7ee74070D1Ev();
Name_Map name_map_ee74070[] = {
  NSPAIR(_ZN7ee74070C1Ev),
  NSPAIR(_ZN7ee74070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd4070;
extern VTBL_ENTRY _ZTI6dd4070[];
extern  VTBL_ENTRY _ZTV6dd4070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4070[];
static Base_Class bases_ee74070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74070[];
extern void _ZN7ee740703fooEv();
extern void _ZN7ee740703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee740703barEv,_ZTv0_n16_N7ee740703barEv)();
extern void ABISELECT(_ZThn16_N7ee740703barEv,_ZThn8_N7ee740703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee740703fooEv,_ZTv0_n20_N7ee740703fooEv)();
extern void ABISELECT(_ZThn16_N7ee740703fooEv,_ZThn8_N7ee740703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74070[0]),
  (VTBL_ENTRY)&_ZN7ee740703fooEv,
  (VTBL_ENTRY)&_ZN7ee740703barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee740703barEv,_ZTv0_n16_N7ee740703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee740703fooEv,_ZTv0_n20_N7ee740703fooEv),
};
extern VTBL_ENTRY _ZTV7ee74070[];
extern void _ZN6dd40703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd4070__7ee74070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4070[0]),
  (VTBL_ENTRY)&_ZN6dd40703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd4070__7ee74070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd4070__7ee74070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee74070[] = {
  {&(_ZTV7ee74070[4]),  4,13},
  {&(_ZTV7ee74070[11]),  11,13},
  {&(_tg__ZTV6dd4070__7ee74070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd4070__7ee74070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd4070__7ee74070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee74070[];
extern  VTBL_ENTRY _ZTV7ee74070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74070[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee740703fooEv,_ZTv0_n20_N7ee740703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740703fooEv,_ZThn8_N7ee740703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee740703barEv,_ZTv0_n16_N7ee740703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740703barEv,_ZThn8_N7ee740703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74070 = {  "ee74070", // class name
  bases_ee74070, 4,
  &(vtc_ee74070[0]), // expected_vtbl_contents
  &(vtt_ee74070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5070  : virtual cc070 {
  int d;
  virtual void  bar(); // _ZN6dd50703barEv
  ~dd5070(); // tgen
  dd5070(); // tgen
};
//SIG(-1 dd5070) C1{ VBC2{ BC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd5070 ::bar(){vfunc_called(this, "_ZN6dd50703barEv");}
dd5070 ::~dd5070(){ note_dtor("dd5070", this);} // tgen
dd5070 ::dd5070(){ note_ctor("dd5070", this);} // tgen

static void Test_dd5070()
{
  extern Class_Descriptor cd_dd5070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5070, buf);
    dd5070 *dp, &lv = *(dp=new (buf) dd5070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,20), "dd5070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,8), "dd5070");
    check_base_class_offset(lv, (cc070*), ABISELECT(16,8), "dd5070");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5070.d");
    test_class_info(&lv, &cd_dd5070);
    dp->~dd5070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5070(Test_dd5070, "dd5070", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5070C1Ev();
extern void _ZN6dd5070D1Ev();
Name_Map name_map_dd5070[] = {
  NSPAIR(_ZN6dd5070C1Ev),
  NSPAIR(_ZN6dd5070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd5070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5070[];
extern void _ZN6dd50703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd5070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd5070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd5070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd5070[] = {
  {&(_ZTV6dd5070[4]),  4,12},
  {&(_ZTV6dd5070[10]),  10,12},
  {&(_tg__ZTV5cc070__6dd5070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd5070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5070 = {  "dd5070", // class name
  bases_dd5070, 3,
  &(vtc_dd5070[0]), // expected_vtbl_contents
  &(vtt_dd5070[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5070),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05070  : dd5070 {
  int e;
  ~ee05070(); // tgen
  ee05070(); // tgen
};
//SIG(1 ee05070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee05070 ::~ee05070(){ note_dtor("ee05070", this);} // tgen
ee05070 ::ee05070(){ note_ctor("ee05070", this);} // tgen

static void Test_ee05070()
{
  extern Class_Descriptor cd_ee05070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05070, buf);
    ee05070 *dp, &lv = *(dp=new (buf) ee05070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee05070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee05070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(16,12), "ee05070");
    check_base_class_offset(lv, (dd5070*), 0, "ee05070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05070.e");
    test_class_info(&lv, &cd_ee05070);
    dp->~ee05070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05070(Test_ee05070, "ee05070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05070C1Ev();
extern void _ZN7ee05070D1Ev();
Name_Map name_map_ee05070[] = {
  NSPAIR(_ZN7ee05070C1Ev),
  NSPAIR(_ZN7ee05070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee05070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05070[];
extern void _ZN6dd50703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee05070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee05070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee05070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee05070[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee05070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee05070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee05070[] = {
  {&(_ZTV7ee05070[4]),  4,12},
  {&(_tg__ZTV6dd5070__7ee05070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee05070[5]),  5,7},
  {&(_ZTV7ee05070[10]),  10,12},
  {&(_tg__ZTV5cc070__7ee05070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee05070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee05070[];
extern  VTBL_ENTRY _ZTV7ee05070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05070[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05070 = {  "ee05070", // class name
  bases_ee05070, 4,
  &(vtc_ee05070[0]), // expected_vtbl_contents
  &(vtt_ee05070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15070  : virtual dd5070 {
  int e;
  ~ee15070(); // tgen
  ee15070(); // tgen
};
//SIG(1 ee15070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee15070 ::~ee15070(){ note_dtor("ee15070", this);} // tgen
ee15070 ::ee15070(){ note_ctor("ee15070", this);} // tgen

static void Test_ee15070()
{
  extern Class_Descriptor cd_ee15070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15070, buf);
    ee15070 *dp, &lv = *(dp=new (buf) ee15070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee15070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee15070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(32,16), "ee15070");
    check_base_class_offset(lv, (dd5070*), ABISELECT(16,8), "ee15070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15070.e");
    test_class_info(&lv, &cd_ee15070);
    dp->~ee15070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15070(Test_ee15070, "ee15070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15070C1Ev();
extern void _ZN7ee15070D1Ev();
Name_Map name_map_ee15070[] = {
  NSPAIR(_ZN7ee15070C1Ev),
  NSPAIR(_ZN7ee15070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee15070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15070[];
extern void _ZN6dd50703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee15070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15070[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee15070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee15070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee15070[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee15070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee15070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee15070[] = {
  {&(_ZTV7ee15070[5]),  5,18},
  {&(_ZTV7ee15070[10]),  10,18},
  {&(_ZTV7ee15070[16]),  16,18},
  {&(_tg__ZTV6dd5070__7ee15070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee15070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee15070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee15070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee15070[];
extern  VTBL_ENTRY _ZTV7ee15070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15070[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15070 = {  "ee15070", // class name
  bases_ee15070, 4,
  &(vtc_ee15070[0]), // expected_vtbl_contents
  &(vtt_ee15070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15070),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25070  : dd5070 {
  int e;
  virtual void  foo(); // _ZN7ee250703fooEv
  ~ee25070(); // tgen
  ee25070(); // tgen
};
//SIG(1 ee25070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25070 ::foo(){vfunc_called(this, "_ZN7ee250703fooEv");}
ee25070 ::~ee25070(){ note_dtor("ee25070", this);} // tgen
ee25070 ::ee25070(){ note_ctor("ee25070", this);} // tgen

static void Test_ee25070()
{
  extern Class_Descriptor cd_ee25070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25070, buf);
    ee25070 *dp, &lv = *(dp=new (buf) ee25070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee25070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee25070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(16,12), "ee25070");
    check_base_class_offset(lv, (dd5070*), 0, "ee25070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25070.e");
    test_class_info(&lv, &cd_ee25070);
    dp->~ee25070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25070(Test_ee25070, "ee25070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25070C1Ev();
extern void _ZN7ee25070D1Ev();
Name_Map name_map_ee25070[] = {
  NSPAIR(_ZN7ee25070C1Ev),
  NSPAIR(_ZN7ee25070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee25070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25070[];
extern void _ZN6dd50703barEv();
extern void _ZN7ee250703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee250703fooEv,_ZTv0_n20_N7ee250703fooEv)();
extern void ABISELECT(_ZThn16_N7ee250703fooEv,_ZThn12_N7ee250703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
  (VTBL_ENTRY)&_ZN7ee250703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee250703fooEv,_ZTv0_n20_N7ee250703fooEv),
};
extern VTBL_ENTRY _ZTV7ee25070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee25070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee25070[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee25070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee25070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee25070[] = {
  {&(_ZTV7ee25070[4]),  4,13},
  {&(_tg__ZTV6dd5070__7ee25070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee25070[5]),  5,7},
  {&(_ZTV7ee25070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee25070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee25070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee25070[];
extern  VTBL_ENTRY _ZTV7ee25070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25070[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee250703fooEv,_ZTv0_n20_N7ee250703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee250703fooEv,_ZThn12_N7ee250703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25070 = {  "ee25070", // class name
  bases_ee25070, 4,
  &(vtc_ee25070[0]), // expected_vtbl_contents
  &(vtt_ee25070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35070  : virtual dd5070 {
  int e;
  virtual void  foo(); // _ZN7ee350703fooEv
  ~ee35070(); // tgen
  ee35070(); // tgen
};
//SIG(1 ee35070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35070 ::foo(){vfunc_called(this, "_ZN7ee350703fooEv");}
ee35070 ::~ee35070(){ note_dtor("ee35070", this);} // tgen
ee35070 ::ee35070(){ note_ctor("ee35070", this);} // tgen

static void Test_ee35070()
{
  extern Class_Descriptor cd_ee35070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35070, buf);
    ee35070 *dp, &lv = *(dp=new (buf) ee35070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee35070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee35070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(32,16), "ee35070");
    check_base_class_offset(lv, (dd5070*), ABISELECT(16,8), "ee35070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35070.e");
    test_class_info(&lv, &cd_ee35070);
    dp->~ee35070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35070(Test_ee35070, "ee35070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35070C1Ev();
extern void _ZN7ee35070D1Ev();
Name_Map name_map_ee35070[] = {
  NSPAIR(_ZN7ee35070C1Ev),
  NSPAIR(_ZN7ee35070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee35070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35070[];
extern void _ZN7ee350703fooEv();
extern void _ZN6dd50703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee350703fooEv,_ZTv0_n20_N7ee350703fooEv)();
extern void ABISELECT(_ZThn32_N7ee350703fooEv,_ZThn16_N7ee350703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35070[0]),
  (VTBL_ENTRY)&_ZN7ee350703fooEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
  ABISELECT(-32,-16),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee350703fooEv,_ZTv0_n20_N7ee350703fooEv),
};
extern VTBL_ENTRY _ZTV7ee35070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee35070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee35070[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee35070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee35070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee35070[] = {
  {&(_ZTV7ee35070[5]),  5,19},
  {&(_ZTV7ee35070[11]),  11,19},
  {&(_ZTV7ee35070[17]),  17,19},
  {&(_tg__ZTV6dd5070__7ee35070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee35070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee35070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee35070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee35070[];
extern  VTBL_ENTRY _ZTV7ee35070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35070[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee350703fooEv,_ZTv0_n20_N7ee350703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee350703fooEv,_ZThn16_N7ee350703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35070 = {  "ee35070", // class name
  bases_ee35070, 4,
  &(vtc_ee35070[0]), // expected_vtbl_contents
  &(vtt_ee35070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35070),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45070  : dd5070 {
  int e;
  virtual void  bar(); // _ZN7ee450703barEv
  ~ee45070(); // tgen
  ee45070(); // tgen
};
//SIG(1 ee45070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45070 ::bar(){vfunc_called(this, "_ZN7ee450703barEv");}
ee45070 ::~ee45070(){ note_dtor("ee45070", this);} // tgen
ee45070 ::ee45070(){ note_ctor("ee45070", this);} // tgen

static void Test_ee45070()
{
  extern Class_Descriptor cd_ee45070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45070, buf);
    ee45070 *dp, &lv = *(dp=new (buf) ee45070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee45070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee45070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(16,12), "ee45070");
    check_base_class_offset(lv, (dd5070*), 0, "ee45070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45070.e");
    test_class_info(&lv, &cd_ee45070);
    dp->~ee45070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45070(Test_ee45070, "ee45070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45070C1Ev();
extern void _ZN7ee45070D1Ev();
Name_Map name_map_ee45070[] = {
  NSPAIR(_ZN7ee45070C1Ev),
  NSPAIR(_ZN7ee45070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee45070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45070[];
extern void _ZN7ee450703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee450703barEv,_ZTv0_n16_N7ee450703barEv)();
extern void ABISELECT(_ZThn16_N7ee450703barEv,_ZThn12_N7ee450703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee45070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45070[0]),
  (VTBL_ENTRY)&_ZN7ee450703barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee450703barEv,_ZTv0_n16_N7ee450703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee45070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee45070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee45070[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee45070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee45070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee45070[] = {
  {&(_ZTV7ee45070[4]),  4,12},
  {&(_tg__ZTV6dd5070__7ee45070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee45070[5]),  5,7},
  {&(_ZTV7ee45070[10]),  10,12},
  {&(_tg__ZTV5cc070__7ee45070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee45070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee45070[];
extern  VTBL_ENTRY _ZTV7ee45070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45070[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee450703barEv,_ZTv0_n16_N7ee450703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee450703barEv,_ZThn12_N7ee450703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45070 = {  "ee45070", // class name
  bases_ee45070, 4,
  &(vtc_ee45070[0]), // expected_vtbl_contents
  &(vtt_ee45070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55070  : virtual dd5070 {
  int e;
  virtual void  bar(); // _ZN7ee550703barEv
  ~ee55070(); // tgen
  ee55070(); // tgen
};
//SIG(1 ee55070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55070 ::bar(){vfunc_called(this, "_ZN7ee550703barEv");}
ee55070 ::~ee55070(){ note_dtor("ee55070", this);} // tgen
ee55070 ::ee55070(){ note_ctor("ee55070", this);} // tgen

static void Test_ee55070()
{
  extern Class_Descriptor cd_ee55070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55070, buf);
    ee55070 *dp, &lv = *(dp=new (buf) ee55070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee55070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee55070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(32,16), "ee55070");
    check_base_class_offset(lv, (dd5070*), ABISELECT(16,8), "ee55070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55070.e");
    test_class_info(&lv, &cd_ee55070);
    dp->~ee55070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55070(Test_ee55070, "ee55070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55070C1Ev();
extern void _ZN7ee55070D1Ev();
Name_Map name_map_ee55070[] = {
  NSPAIR(_ZN7ee55070C1Ev),
  NSPAIR(_ZN7ee55070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee55070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55070[];
extern void _ZN7ee550703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee550703barEv,_ZTv0_n20_N7ee550703barEv)();
extern void ABISELECT(_ZThn16_N7ee550703barEv,_ZThn8_N7ee550703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee550703barEv,_ZTv0_n16_N7ee550703barEv)();
extern void ABISELECT(_ZThn32_N7ee550703barEv,_ZThn16_N7ee550703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee55070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55070[0]),
  (VTBL_ENTRY)&_ZN7ee550703barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee550703barEv,_ZTv0_n20_N7ee550703barEv),
  0,
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee550703barEv,_ZTv0_n16_N7ee550703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee55070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee55070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee55070[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee55070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee55070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee55070[] = {
  {&(_ZTV7ee55070[5]),  5,19},
  {&(_ZTV7ee55070[11]),  11,19},
  {&(_ZTV7ee55070[17]),  17,19},
  {&(_tg__ZTV6dd5070__7ee55070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee55070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee55070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee55070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee55070[];
extern  VTBL_ENTRY _ZTV7ee55070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55070[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee550703barEv,_ZTv0_n16_N7ee550703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee550703barEv,_ZThn16_N7ee550703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee550703barEv,_ZTv0_n20_N7ee550703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550703barEv,_ZThn8_N7ee550703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55070 = {  "ee55070", // class name
  bases_ee55070, 4,
  &(vtc_ee55070[0]), // expected_vtbl_contents
  &(vtt_ee55070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55070),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65070  : dd5070 {
  int e;
  virtual void  foo(); // _ZN7ee650703fooEv
  virtual void  bar(); // _ZN7ee650703barEv
  ~ee65070(); // tgen
  ee65070(); // tgen
};
//SIG(1 ee65070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65070 ::foo(){vfunc_called(this, "_ZN7ee650703fooEv");}
void  ee65070 ::bar(){vfunc_called(this, "_ZN7ee650703barEv");}
ee65070 ::~ee65070(){ note_dtor("ee65070", this);} // tgen
ee65070 ::ee65070(){ note_ctor("ee65070", this);} // tgen

static void Test_ee65070()
{
  extern Class_Descriptor cd_ee65070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65070, buf);
    ee65070 *dp, &lv = *(dp=new (buf) ee65070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee65070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee65070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(16,12), "ee65070");
    check_base_class_offset(lv, (dd5070*), 0, "ee65070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65070.e");
    test_class_info(&lv, &cd_ee65070);
    dp->~ee65070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65070(Test_ee65070, "ee65070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65070C1Ev();
extern void _ZN7ee65070D1Ev();
Name_Map name_map_ee65070[] = {
  NSPAIR(_ZN7ee65070C1Ev),
  NSPAIR(_ZN7ee65070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee65070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65070[];
extern void _ZN7ee650703barEv();
extern void _ZN7ee650703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee650703barEv,_ZTv0_n16_N7ee650703barEv)();
extern void ABISELECT(_ZThn16_N7ee650703barEv,_ZThn12_N7ee650703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee650703fooEv,_ZTv0_n20_N7ee650703fooEv)();
extern void ABISELECT(_ZThn16_N7ee650703fooEv,_ZThn12_N7ee650703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65070[0]),
  (VTBL_ENTRY)&_ZN7ee650703barEv,
  (VTBL_ENTRY)&_ZN7ee650703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee650703barEv,_ZTv0_n16_N7ee650703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee650703fooEv,_ZTv0_n20_N7ee650703fooEv),
};
extern VTBL_ENTRY _ZTV7ee65070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee65070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee65070[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee65070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee65070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee65070[] = {
  {&(_ZTV7ee65070[4]),  4,13},
  {&(_tg__ZTV6dd5070__7ee65070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee65070[5]),  5,7},
  {&(_ZTV7ee65070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee65070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee65070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee65070[];
extern  VTBL_ENTRY _ZTV7ee65070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65070[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn12_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee650703fooEv,_ZTv0_n20_N7ee650703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650703fooEv,_ZThn12_N7ee650703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee650703barEv,_ZTv0_n16_N7ee650703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650703barEv,_ZThn12_N7ee650703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65070 = {  "ee65070", // class name
  bases_ee65070, 4,
  &(vtc_ee65070[0]), // expected_vtbl_contents
  &(vtt_ee65070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75070  : virtual dd5070 {
  int e;
  virtual void  foo(); // _ZN7ee750703fooEv
  virtual void  bar(); // _ZN7ee750703barEv
  ~ee75070(); // tgen
  ee75070(); // tgen
};
//SIG(1 ee75070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75070 ::foo(){vfunc_called(this, "_ZN7ee750703fooEv");}
void  ee75070 ::bar(){vfunc_called(this, "_ZN7ee750703barEv");}
ee75070 ::~ee75070(){ note_dtor("ee75070", this);} // tgen
ee75070 ::ee75070(){ note_ctor("ee75070", this);} // tgen

static void Test_ee75070()
{
  extern Class_Descriptor cd_ee75070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75070, buf);
    ee75070 *dp, &lv = *(dp=new (buf) ee75070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee75070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee75070");
    check_base_class_offset(lv, (cc070*)(dd5070*), ABISELECT(32,16), "ee75070");
    check_base_class_offset(lv, (dd5070*), ABISELECT(16,8), "ee75070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75070.e");
    test_class_info(&lv, &cd_ee75070);
    dp->~ee75070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75070(Test_ee75070, "ee75070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75070C1Ev();
extern void _ZN7ee75070D1Ev();
Name_Map name_map_ee75070[] = {
  NSPAIR(_ZN7ee75070C1Ev),
  NSPAIR(_ZN7ee75070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd5070;
extern VTBL_ENTRY _ZTI6dd5070[];
extern  VTBL_ENTRY _ZTV6dd5070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5070[];
static Base_Class bases_ee75070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5070,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75070[];
extern void _ZN7ee750703fooEv();
extern void _ZN7ee750703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee750703barEv,_ZTv0_n20_N7ee750703barEv)();
extern void ABISELECT(_ZThn16_N7ee750703barEv,_ZThn8_N7ee750703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee750703barEv,_ZTv0_n16_N7ee750703barEv)();
extern void ABISELECT(_ZThn32_N7ee750703barEv,_ZThn16_N7ee750703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee750703fooEv,_ZTv0_n20_N7ee750703fooEv)();
extern void ABISELECT(_ZThn32_N7ee750703fooEv,_ZThn16_N7ee750703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75070[0]),
  (VTBL_ENTRY)&_ZN7ee750703fooEv,
  (VTBL_ENTRY)&_ZN7ee750703barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee750703barEv,_ZTv0_n20_N7ee750703barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750703barEv,_ZTv0_n16_N7ee750703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee750703fooEv,_ZTv0_n20_N7ee750703fooEv),
};
extern VTBL_ENTRY _ZTV7ee75070[];
extern void _ZN6dd50703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5070__7ee75070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&_ZN6dd50703barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv)();
extern void ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd5070__7ee75070[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee75070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee75070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee75070[] = {
  {&(_ZTV7ee75070[5]),  5,20},
  {&(_ZTV7ee75070[12]),  12,20},
  {&(_ZTV7ee75070[18]),  18,20},
  {&(_tg__ZTV6dd5070__7ee75070[4]),  4,5},
  {&(_tg__ZTV5cc070__6dd5070__7ee75070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee75070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee75070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee75070[];
extern  VTBL_ENTRY _ZTV7ee75070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75070[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50703barEv,_ZTv0_n16_N6dd50703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50703barEv,_ZThn8_N6dd50703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee750703fooEv,_ZTv0_n20_N7ee750703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750703fooEv,_ZThn16_N7ee750703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750703barEv,_ZTv0_n16_N7ee750703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750703barEv,_ZThn16_N7ee750703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee750703barEv,_ZTv0_n20_N7ee750703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750703barEv,_ZThn8_N7ee750703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75070 = {  "ee75070", // class name
  bases_ee75070, 4,
  &(vtc_ee75070[0]), // expected_vtbl_contents
  &(vtt_ee75070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75070),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6070  : cc070 {
  int d;
  virtual void  bar(); // _ZN6dd60703barEv
  virtual void  foo(); // _ZN6dd60703fooEv
  ~dd6070(); // tgen
  dd6070(); // tgen
};
//SIG(-1 dd6070) C1{ BC2{ BC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd6070 ::bar(){vfunc_called(this, "_ZN6dd60703barEv");}
void  dd6070 ::foo(){vfunc_called(this, "_ZN6dd60703fooEv");}
dd6070 ::~dd6070(){ note_dtor("dd6070", this);} // tgen
dd6070 ::dd6070(){ note_ctor("dd6070", this);} // tgen

static void Test_dd6070()
{
  extern Class_Descriptor cd_dd6070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6070, buf);
    dd6070 *dp, &lv = *(dp=new (buf) dd6070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(20,16), "dd6070");
    check_base_class_offset(lv, (bb70*)(cc070*), 0, "dd6070");
    check_base_class_offset(lv, (cc070*), 0, "dd6070");
    check_field_offset(lv, d, ABISELECT(16,12), "dd6070.d");
    test_class_info(&lv, &cd_dd6070);
    dp->~dd6070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6070(Test_dd6070, "dd6070", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6070C1Ev();
extern void _ZN6dd6070D1Ev();
Name_Map name_map_dd6070[] = {
  NSPAIR(_ZN6dd6070C1Ev),
  NSPAIR(_ZN6dd6070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd6070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY vtc_dd6070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern VTBL_ENTRY _ZTV6dd6070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd6070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd6070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd6070[] = {
  {&(_ZTV6dd6070[3]),  3,5},
  {&(_tg__ZTV5cc070__6dd6070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd6070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
Class_Descriptor cd_dd6070 = {  "dd6070", // class name
  bases_dd6070, 3,
  &(vtc_dd6070[0]), // expected_vtbl_contents
  &(vtt_dd6070[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6070),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06070  : dd6070 {
  int e;
  ~ee06070(); // tgen
  ee06070(); // tgen
};
//SIG(1 ee06070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee06070 ::~ee06070(){ note_dtor("ee06070", this);} // tgen
ee06070 ::ee06070(){ note_ctor("ee06070", this);} // tgen

static void Test_ee06070()
{
  extern Class_Descriptor cd_ee06070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06070, buf);
    ee06070 *dp, &lv = *(dp=new (buf) ee06070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(24,20), "ee06070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), 0, "ee06070");
    check_base_class_offset(lv, (cc070*)(dd6070*), 0, "ee06070");
    check_base_class_offset(lv, (dd6070*), 0, "ee06070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee06070.e");
    test_class_info(&lv, &cd_ee06070);
    dp->~ee06070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06070(Test_ee06070, "ee06070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06070C1Ev();
extern void _ZN7ee06070D1Ev();
Name_Map name_map_ee06070[] = {
  NSPAIR(_ZN7ee06070C1Ev),
  NSPAIR(_ZN7ee06070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee06070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY vtc_ee06070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern VTBL_ENTRY _ZTV7ee06070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee06070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee06070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee06070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee06070[] = {
  {&(_ZTV7ee06070[3]),  3,5},
  {&(_tg__ZTV6dd6070__7ee06070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee06070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee06070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee06070[];
extern  VTBL_ENTRY _ZTV7ee06070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06070[];
Class_Descriptor cd_ee06070 = {  "ee06070", // class name
  bases_ee06070, 4,
  &(vtc_ee06070[0]), // expected_vtbl_contents
  &(vtt_ee06070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16070  : virtual dd6070 {
  int e;
  ~ee16070(); // tgen
  ee16070(); // tgen
};
//SIG(1 ee16070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee16070 ::~ee16070(){ note_dtor("ee16070", this);} // tgen
ee16070 ::ee16070(){ note_ctor("ee16070", this);} // tgen

static void Test_ee16070()
{
  extern Class_Descriptor cd_ee16070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16070, buf);
    ee16070 *dp, &lv = *(dp=new (buf) ee16070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(36,24), "ee16070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), ABISELECT(16,8), "ee16070");
    check_base_class_offset(lv, (cc070*)(dd6070*), ABISELECT(16,8), "ee16070");
    check_base_class_offset(lv, (dd6070*), ABISELECT(16,8), "ee16070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16070.e");
    test_class_info(&lv, &cd_ee16070);
    dp->~ee16070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16070(Test_ee16070, "ee16070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16070C1Ev();
extern void _ZN7ee16070D1Ev();
Name_Map name_map_ee16070[] = {
  NSPAIR(_ZN7ee16070C1Ev),
  NSPAIR(_ZN7ee16070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee16070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY vtc_ee16070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16070[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern VTBL_ENTRY _ZTV7ee16070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee16070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee16070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee16070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee16070[] = {
  {&(_ZTV7ee16070[4]),  4,11},
  {&(_ZTV7ee16070[9]),  9,11},
  {&(_tg__ZTV6dd6070__7ee16070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee16070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee16070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee16070[];
extern  VTBL_ENTRY _ZTV7ee16070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16070[];
Class_Descriptor cd_ee16070 = {  "ee16070", // class name
  bases_ee16070, 4,
  &(vtc_ee16070[0]), // expected_vtbl_contents
  &(vtt_ee16070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16070),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26070  : dd6070 {
  int e;
  virtual void  foo(); // _ZN7ee260703fooEv
  ~ee26070(); // tgen
  ee26070(); // tgen
};
//SIG(1 ee26070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26070 ::foo(){vfunc_called(this, "_ZN7ee260703fooEv");}
ee26070 ::~ee26070(){ note_dtor("ee26070", this);} // tgen
ee26070 ::ee26070(){ note_ctor("ee26070", this);} // tgen

static void Test_ee26070()
{
  extern Class_Descriptor cd_ee26070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26070, buf);
    ee26070 *dp, &lv = *(dp=new (buf) ee26070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(24,20), "ee26070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), 0, "ee26070");
    check_base_class_offset(lv, (cc070*)(dd6070*), 0, "ee26070");
    check_base_class_offset(lv, (dd6070*), 0, "ee26070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee26070.e");
    test_class_info(&lv, &cd_ee26070);
    dp->~ee26070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26070(Test_ee26070, "ee26070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26070C1Ev();
extern void _ZN7ee26070D1Ev();
Name_Map name_map_ee26070[] = {
  NSPAIR(_ZN7ee26070C1Ev),
  NSPAIR(_ZN7ee26070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee26070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26070[];
extern void _ZN6dd60703barEv();
extern void _ZN7ee260703fooEv();
static  VTBL_ENTRY vtc_ee26070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN7ee260703fooEv,
};
extern VTBL_ENTRY _ZTV7ee26070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee26070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee26070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee26070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee26070[] = {
  {&(_ZTV7ee26070[3]),  3,5},
  {&(_tg__ZTV6dd6070__7ee26070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee26070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee26070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee26070[];
extern  VTBL_ENTRY _ZTV7ee26070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26070[];
Class_Descriptor cd_ee26070 = {  "ee26070", // class name
  bases_ee26070, 4,
  &(vtc_ee26070[0]), // expected_vtbl_contents
  &(vtt_ee26070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36070  : virtual dd6070 {
  int e;
  virtual void  foo(); // _ZN7ee360703fooEv
  ~ee36070(); // tgen
  ee36070(); // tgen
};
//SIG(1 ee36070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36070 ::foo(){vfunc_called(this, "_ZN7ee360703fooEv");}
ee36070 ::~ee36070(){ note_dtor("ee36070", this);} // tgen
ee36070 ::ee36070(){ note_ctor("ee36070", this);} // tgen

static void Test_ee36070()
{
  extern Class_Descriptor cd_ee36070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36070, buf);
    ee36070 *dp, &lv = *(dp=new (buf) ee36070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(36,24), "ee36070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), ABISELECT(16,8), "ee36070");
    check_base_class_offset(lv, (cc070*)(dd6070*), ABISELECT(16,8), "ee36070");
    check_base_class_offset(lv, (dd6070*), ABISELECT(16,8), "ee36070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36070.e");
    test_class_info(&lv, &cd_ee36070);
    dp->~ee36070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36070(Test_ee36070, "ee36070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36070C1Ev();
extern void _ZN7ee36070D1Ev();
Name_Map name_map_ee36070[] = {
  NSPAIR(_ZN7ee36070C1Ev),
  NSPAIR(_ZN7ee36070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee36070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36070[];
extern void _ZN7ee360703fooEv();
extern void _ZN6dd60703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee360703fooEv,_ZTv0_n20_N7ee360703fooEv)();
extern void ABISELECT(_ZThn16_N7ee360703fooEv,_ZThn8_N7ee360703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36070[0]),
  (VTBL_ENTRY)&_ZN7ee360703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee360703fooEv,_ZTv0_n20_N7ee360703fooEv),
};
extern VTBL_ENTRY _ZTV7ee36070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee36070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee36070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee36070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee36070[] = {
  {&(_ZTV7ee36070[4]),  4,12},
  {&(_ZTV7ee36070[10]),  10,12},
  {&(_tg__ZTV6dd6070__7ee36070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee36070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee36070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee36070[];
extern  VTBL_ENTRY _ZTV7ee36070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36070[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee360703fooEv,_ZTv0_n20_N7ee360703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360703fooEv,_ZThn8_N7ee360703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36070 = {  "ee36070", // class name
  bases_ee36070, 4,
  &(vtc_ee36070[0]), // expected_vtbl_contents
  &(vtt_ee36070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46070  : dd6070 {
  int e;
  virtual void  bar(); // _ZN7ee460703barEv
  ~ee46070(); // tgen
  ee46070(); // tgen
};
//SIG(1 ee46070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46070 ::bar(){vfunc_called(this, "_ZN7ee460703barEv");}
ee46070 ::~ee46070(){ note_dtor("ee46070", this);} // tgen
ee46070 ::ee46070(){ note_ctor("ee46070", this);} // tgen

static void Test_ee46070()
{
  extern Class_Descriptor cd_ee46070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46070, buf);
    ee46070 *dp, &lv = *(dp=new (buf) ee46070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(24,20), "ee46070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), 0, "ee46070");
    check_base_class_offset(lv, (cc070*)(dd6070*), 0, "ee46070");
    check_base_class_offset(lv, (dd6070*), 0, "ee46070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee46070.e");
    test_class_info(&lv, &cd_ee46070);
    dp->~ee46070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46070(Test_ee46070, "ee46070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46070C1Ev();
extern void _ZN7ee46070D1Ev();
Name_Map name_map_ee46070[] = {
  NSPAIR(_ZN7ee46070C1Ev),
  NSPAIR(_ZN7ee46070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee46070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46070[];
extern void _ZN7ee460703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY vtc_ee46070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46070[0]),
  (VTBL_ENTRY)&_ZN7ee460703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern VTBL_ENTRY _ZTV7ee46070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee46070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee46070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee46070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee46070[] = {
  {&(_ZTV7ee46070[3]),  3,5},
  {&(_tg__ZTV6dd6070__7ee46070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee46070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee46070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee46070[];
extern  VTBL_ENTRY _ZTV7ee46070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46070[];
Class_Descriptor cd_ee46070 = {  "ee46070", // class name
  bases_ee46070, 4,
  &(vtc_ee46070[0]), // expected_vtbl_contents
  &(vtt_ee46070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56070  : virtual dd6070 {
  int e;
  virtual void  bar(); // _ZN7ee560703barEv
  ~ee56070(); // tgen
  ee56070(); // tgen
};
//SIG(1 ee56070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56070 ::bar(){vfunc_called(this, "_ZN7ee560703barEv");}
ee56070 ::~ee56070(){ note_dtor("ee56070", this);} // tgen
ee56070 ::ee56070(){ note_ctor("ee56070", this);} // tgen

static void Test_ee56070()
{
  extern Class_Descriptor cd_ee56070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56070, buf);
    ee56070 *dp, &lv = *(dp=new (buf) ee56070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(36,24), "ee56070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), ABISELECT(16,8), "ee56070");
    check_base_class_offset(lv, (cc070*)(dd6070*), ABISELECT(16,8), "ee56070");
    check_base_class_offset(lv, (dd6070*), ABISELECT(16,8), "ee56070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56070.e");
    test_class_info(&lv, &cd_ee56070);
    dp->~ee56070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56070(Test_ee56070, "ee56070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56070C1Ev();
extern void _ZN7ee56070D1Ev();
Name_Map name_map_ee56070[] = {
  NSPAIR(_ZN7ee56070C1Ev),
  NSPAIR(_ZN7ee56070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee56070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56070[];
extern void _ZN7ee560703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee560703barEv,_ZTv0_n16_N7ee560703barEv)();
extern void ABISELECT(_ZThn16_N7ee560703barEv,_ZThn8_N7ee560703barEv)() __attribute__((weak));
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY vtc_ee56070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56070[0]),
  (VTBL_ENTRY)&_ZN7ee560703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee560703barEv,_ZTv0_n16_N7ee560703barEv),
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern VTBL_ENTRY _ZTV7ee56070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee56070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee56070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee56070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee56070[] = {
  {&(_ZTV7ee56070[4]),  4,12},
  {&(_ZTV7ee56070[10]),  10,12},
  {&(_tg__ZTV6dd6070__7ee56070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee56070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee56070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee56070[];
extern  VTBL_ENTRY _ZTV7ee56070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56070[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee560703barEv,_ZTv0_n16_N7ee560703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560703barEv,_ZThn8_N7ee560703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56070 = {  "ee56070", // class name
  bases_ee56070, 4,
  &(vtc_ee56070[0]), // expected_vtbl_contents
  &(vtt_ee56070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56070),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66070  : dd6070 {
  int e;
  virtual void  foo(); // _ZN7ee660703fooEv
  virtual void  bar(); // _ZN7ee660703barEv
  ~ee66070(); // tgen
  ee66070(); // tgen
};
//SIG(1 ee66070) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66070 ::foo(){vfunc_called(this, "_ZN7ee660703fooEv");}
void  ee66070 ::bar(){vfunc_called(this, "_ZN7ee660703barEv");}
ee66070 ::~ee66070(){ note_dtor("ee66070", this);} // tgen
ee66070 ::ee66070(){ note_ctor("ee66070", this);} // tgen

static void Test_ee66070()
{
  extern Class_Descriptor cd_ee66070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66070, buf);
    ee66070 *dp, &lv = *(dp=new (buf) ee66070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(24,20), "ee66070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), 0, "ee66070");
    check_base_class_offset(lv, (cc070*)(dd6070*), 0, "ee66070");
    check_base_class_offset(lv, (dd6070*), 0, "ee66070");
    check_field_offset(lv, e, ABISELECT(20,16), "ee66070.e");
    test_class_info(&lv, &cd_ee66070);
    dp->~ee66070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66070(Test_ee66070, "ee66070", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66070C1Ev();
extern void _ZN7ee66070D1Ev();
Name_Map name_map_ee66070[] = {
  NSPAIR(_ZN7ee66070C1Ev),
  NSPAIR(_ZN7ee66070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee66070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66070[];
extern void _ZN7ee660703barEv();
extern void _ZN7ee660703fooEv();
static  VTBL_ENTRY vtc_ee66070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66070[0]),
  (VTBL_ENTRY)&_ZN7ee660703barEv,
  (VTBL_ENTRY)&_ZN7ee660703fooEv,
};
extern VTBL_ENTRY _ZTV7ee66070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee66070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee66070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee66070[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee66070[] = {
  {&(_ZTV7ee66070[3]),  3,5},
  {&(_tg__ZTV6dd6070__7ee66070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee66070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee66070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee66070[];
extern  VTBL_ENTRY _ZTV7ee66070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66070[];
Class_Descriptor cd_ee66070 = {  "ee66070", // class name
  bases_ee66070, 4,
  &(vtc_ee66070[0]), // expected_vtbl_contents
  &(vtt_ee66070[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66070),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66070),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76070  : virtual dd6070 {
  int e;
  virtual void  foo(); // _ZN7ee760703fooEv
  virtual void  bar(); // _ZN7ee760703barEv
  ~ee76070(); // tgen
  ee76070(); // tgen
};
//SIG(1 ee76070) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76070 ::foo(){vfunc_called(this, "_ZN7ee760703fooEv");}
void  ee76070 ::bar(){vfunc_called(this, "_ZN7ee760703barEv");}
ee76070 ::~ee76070(){ note_dtor("ee76070", this);} // tgen
ee76070 ::ee76070(){ note_ctor("ee76070", this);} // tgen

static void Test_ee76070()
{
  extern Class_Descriptor cd_ee76070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76070, buf);
    ee76070 *dp, &lv = *(dp=new (buf) ee76070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*)(dd6070*), ABISELECT(36,24), "ee76070");
    check_base_class_offset(lv, (bb70*)(cc070*)(dd6070*), ABISELECT(16,8), "ee76070");
    check_base_class_offset(lv, (cc070*)(dd6070*), ABISELECT(16,8), "ee76070");
    check_base_class_offset(lv, (dd6070*), ABISELECT(16,8), "ee76070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76070.e");
    test_class_info(&lv, &cd_ee76070);
    dp->~ee76070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76070(Test_ee76070, "ee76070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76070C1Ev();
extern void _ZN7ee76070D1Ev();
Name_Map name_map_ee76070[] = {
  NSPAIR(_ZN7ee76070C1Ev),
  NSPAIR(_ZN7ee76070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd6070;
extern VTBL_ENTRY _ZTI6dd6070[];
extern  VTBL_ENTRY _ZTV6dd6070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6070[];
static Base_Class bases_ee76070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76070[];
extern void _ZN7ee760703fooEv();
extern void _ZN7ee760703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee760703barEv,_ZTv0_n16_N7ee760703barEv)();
extern void ABISELECT(_ZThn16_N7ee760703barEv,_ZThn8_N7ee760703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee760703fooEv,_ZTv0_n20_N7ee760703fooEv)();
extern void ABISELECT(_ZThn16_N7ee760703fooEv,_ZThn8_N7ee760703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76070[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76070[0]),
  (VTBL_ENTRY)&_ZN7ee760703fooEv,
  (VTBL_ENTRY)&_ZN7ee760703barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760703barEv,_ZTv0_n16_N7ee760703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee760703fooEv,_ZTv0_n20_N7ee760703fooEv),
};
extern VTBL_ENTRY _ZTV7ee76070[];
extern void _ZN6dd60703barEv();
extern void _ZN6dd60703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6070__7ee76070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6070[0]),
  (VTBL_ENTRY)&_ZN6dd60703barEv,
  (VTBL_ENTRY)&_ZN6dd60703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0706dd6070__7ee76070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc0706dd6070__7ee76070[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee76070[] = {
  {&(_ZTV7ee76070[4]),  4,13},
  {&(_ZTV7ee76070[11]),  11,13},
  {&(_tg__ZTV6dd6070__7ee76070[3]),  3,5},
  {&(_tg__ZTV5cc0706dd6070__7ee76070[3]),  3,5},
  {&(_tg__ZTV4bb705cc0706dd6070__7ee76070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee76070[];
extern  VTBL_ENTRY _ZTV7ee76070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76070[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee760703fooEv,_ZTv0_n20_N7ee760703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760703fooEv,_ZThn8_N7ee760703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760703barEv,_ZTv0_n16_N7ee760703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760703barEv,_ZThn8_N7ee760703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76070 = {  "ee76070", // class name
  bases_ee76070, 4,
  &(vtc_ee76070[0]), // expected_vtbl_contents
  &(vtt_ee76070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76070),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7070  : virtual cc070 {
  int d;
  virtual void  bar(); // _ZN6dd70703barEv
  virtual void  foo(); // _ZN6dd70703fooEv
  ~dd7070(); // tgen
  dd7070(); // tgen
};
//SIG(-1 dd7070) C1{ VBC2{ BC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd7070 ::bar(){vfunc_called(this, "_ZN6dd70703barEv");}
void  dd7070 ::foo(){vfunc_called(this, "_ZN6dd70703fooEv");}
dd7070 ::~dd7070(){ note_dtor("dd7070", this);} // tgen
dd7070 ::dd7070(){ note_ctor("dd7070", this);} // tgen

static void Test_dd7070()
{
  extern Class_Descriptor cd_dd7070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7070, buf);
    dd7070 *dp, &lv = *(dp=new (buf) dd7070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,20), "dd7070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,8), "dd7070");
    check_base_class_offset(lv, (cc070*), ABISELECT(16,8), "dd7070");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7070.d");
    test_class_info(&lv, &cd_dd7070);
    dp->~dd7070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7070(Test_dd7070, "dd7070", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7070C1Ev();
extern void _ZN6dd7070D1Ev();
Name_Map name_map_dd7070[] = {
  NSPAIR(_ZN6dd7070C1Ev),
  NSPAIR(_ZN6dd7070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
static Base_Class bases_dd7070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern VTBL_ENTRY _ZTV6dd7070[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__6dd7070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd7070[] = {
  {&(_ZTV6dd7070[4]),  4,13},
  {&(_ZTV6dd7070[11]),  11,13},
  {&(_tg__ZTV5cc070__6dd7070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__6dd7070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7070 = {  "dd7070", // class name
  bases_dd7070, 3,
  &(vtc_dd7070[0]), // expected_vtbl_contents
  &(vtt_dd7070[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7070),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07070  : dd7070 {
  int e;
  ~ee07070(); // tgen
  ee07070(); // tgen
};
//SIG(1 ee07070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee07070 ::~ee07070(){ note_dtor("ee07070", this);} // tgen
ee07070 ::ee07070(){ note_ctor("ee07070", this);} // tgen

static void Test_ee07070()
{
  extern Class_Descriptor cd_ee07070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07070, buf);
    ee07070 *dp, &lv = *(dp=new (buf) ee07070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee07070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee07070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(16,12), "ee07070");
    check_base_class_offset(lv, (dd7070*), 0, "ee07070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07070.e");
    test_class_info(&lv, &cd_ee07070);
    dp->~ee07070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07070(Test_ee07070, "ee07070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07070C1Ev();
extern void _ZN7ee07070D1Ev();
Name_Map name_map_ee07070[] = {
  NSPAIR(_ZN7ee07070C1Ev),
  NSPAIR(_ZN7ee07070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee07070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern VTBL_ENTRY _ZTV7ee07070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee07070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee07070[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee07070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee07070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee07070[] = {
  {&(_ZTV7ee07070[4]),  4,13},
  {&(_tg__ZTV6dd7070__7ee07070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee07070[5]),  5,7},
  {&(_ZTV7ee07070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee07070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee07070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee07070[];
extern  VTBL_ENTRY _ZTV7ee07070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07070[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07070 = {  "ee07070", // class name
  bases_ee07070, 4,
  &(vtc_ee07070[0]), // expected_vtbl_contents
  &(vtt_ee07070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17070  : virtual dd7070 {
  int e;
  ~ee17070(); // tgen
  ee17070(); // tgen
};
//SIG(1 ee17070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee17070 ::~ee17070(){ note_dtor("ee17070", this);} // tgen
ee17070 ::ee17070(){ note_ctor("ee17070", this);} // tgen

static void Test_ee17070()
{
  extern Class_Descriptor cd_ee17070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17070, buf);
    ee17070 *dp, &lv = *(dp=new (buf) ee17070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee17070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee17070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(32,16), "ee17070");
    check_base_class_offset(lv, (dd7070*), ABISELECT(16,8), "ee17070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17070.e");
    test_class_info(&lv, &cd_ee17070);
    dp->~ee17070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17070(Test_ee17070, "ee17070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17070C1Ev();
extern void _ZN7ee17070D1Ev();
Name_Map name_map_ee17070[] = {
  NSPAIR(_ZN7ee17070C1Ev),
  NSPAIR(_ZN7ee17070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee17070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17070[0]),
  0,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern VTBL_ENTRY _ZTV7ee17070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee17070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee17070[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee17070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee17070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee17070[] = {
  {&(_ZTV7ee17070[5]),  5,20},
  {&(_ZTV7ee17070[11]),  11,20},
  {&(_ZTV7ee17070[18]),  18,20},
  {&(_tg__ZTV6dd7070__7ee17070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee17070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee17070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee17070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee17070[];
extern  VTBL_ENTRY _ZTV7ee17070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17070[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17070 = {  "ee17070", // class name
  bases_ee17070, 4,
  &(vtc_ee17070[0]), // expected_vtbl_contents
  &(vtt_ee17070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17070),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27070  : dd7070 {
  int e;
  virtual void  foo(); // _ZN7ee270703fooEv
  ~ee27070(); // tgen
  ee27070(); // tgen
};
//SIG(1 ee27070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27070 ::foo(){vfunc_called(this, "_ZN7ee270703fooEv");}
ee27070 ::~ee27070(){ note_dtor("ee27070", this);} // tgen
ee27070 ::ee27070(){ note_ctor("ee27070", this);} // tgen

static void Test_ee27070()
{
  extern Class_Descriptor cd_ee27070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27070, buf);
    ee27070 *dp, &lv = *(dp=new (buf) ee27070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee27070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee27070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(16,12), "ee27070");
    check_base_class_offset(lv, (dd7070*), 0, "ee27070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27070.e");
    test_class_info(&lv, &cd_ee27070);
    dp->~ee27070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27070(Test_ee27070, "ee27070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27070C1Ev();
extern void _ZN7ee27070D1Ev();
Name_Map name_map_ee27070[] = {
  NSPAIR(_ZN7ee27070C1Ev),
  NSPAIR(_ZN7ee27070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee27070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27070[];
extern void _ZN6dd70703barEv();
extern void _ZN7ee270703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee270703fooEv,_ZTv0_n20_N7ee270703fooEv)();
extern void ABISELECT(_ZThn16_N7ee270703fooEv,_ZThn12_N7ee270703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN7ee270703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee270703fooEv,_ZTv0_n20_N7ee270703fooEv),
};
extern VTBL_ENTRY _ZTV7ee27070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee27070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee27070[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee27070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee27070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee27070[] = {
  {&(_ZTV7ee27070[4]),  4,13},
  {&(_tg__ZTV6dd7070__7ee27070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee27070[5]),  5,7},
  {&(_ZTV7ee27070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee27070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee27070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee27070[];
extern  VTBL_ENTRY _ZTV7ee27070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27070[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee270703fooEv,_ZTv0_n20_N7ee270703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee270703fooEv,_ZThn12_N7ee270703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27070 = {  "ee27070", // class name
  bases_ee27070, 4,
  &(vtc_ee27070[0]), // expected_vtbl_contents
  &(vtt_ee27070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37070  : virtual dd7070 {
  int e;
  virtual void  foo(); // _ZN7ee370703fooEv
  ~ee37070(); // tgen
  ee37070(); // tgen
};
//SIG(1 ee37070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37070 ::foo(){vfunc_called(this, "_ZN7ee370703fooEv");}
ee37070 ::~ee37070(){ note_dtor("ee37070", this);} // tgen
ee37070 ::ee37070(){ note_ctor("ee37070", this);} // tgen

static void Test_ee37070()
{
  extern Class_Descriptor cd_ee37070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37070, buf);
    ee37070 *dp, &lv = *(dp=new (buf) ee37070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee37070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee37070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(32,16), "ee37070");
    check_base_class_offset(lv, (dd7070*), ABISELECT(16,8), "ee37070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37070.e");
    test_class_info(&lv, &cd_ee37070);
    dp->~ee37070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37070(Test_ee37070, "ee37070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37070C1Ev();
extern void _ZN7ee37070D1Ev();
Name_Map name_map_ee37070[] = {
  NSPAIR(_ZN7ee37070C1Ev),
  NSPAIR(_ZN7ee37070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee37070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37070[];
extern void _ZN7ee370703fooEv();
extern void _ZN6dd70703barEv();
extern void ABISELECT(_ZTv0_n48_N7ee370703fooEv,_ZTv0_n24_N7ee370703fooEv)();
extern void ABISELECT(_ZThn16_N7ee370703fooEv,_ZThn8_N7ee370703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee370703fooEv,_ZTv0_n20_N7ee370703fooEv)();
extern void ABISELECT(_ZThn32_N7ee370703fooEv,_ZThn16_N7ee370703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37070[0]),
  (VTBL_ENTRY)&_ZN7ee370703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee370703fooEv,_ZTv0_n24_N7ee370703fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee370703fooEv,_ZTv0_n20_N7ee370703fooEv),
};
extern VTBL_ENTRY _ZTV7ee37070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee37070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee37070[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee37070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee37070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee37070[] = {
  {&(_ZTV7ee37070[5]),  5,21},
  {&(_ZTV7ee37070[12]),  12,21},
  {&(_ZTV7ee37070[19]),  19,21},
  {&(_tg__ZTV6dd7070__7ee37070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee37070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee37070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee37070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee37070[];
extern  VTBL_ENTRY _ZTV7ee37070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37070[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee370703fooEv,_ZTv0_n20_N7ee370703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee370703fooEv,_ZThn16_N7ee370703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee370703fooEv,_ZTv0_n24_N7ee370703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370703fooEv,_ZThn8_N7ee370703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37070 = {  "ee37070", // class name
  bases_ee37070, 4,
  &(vtc_ee37070[0]), // expected_vtbl_contents
  &(vtt_ee37070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37070),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47070  : dd7070 {
  int e;
  virtual void  bar(); // _ZN7ee470703barEv
  ~ee47070(); // tgen
  ee47070(); // tgen
};
//SIG(1 ee47070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47070 ::bar(){vfunc_called(this, "_ZN7ee470703barEv");}
ee47070 ::~ee47070(){ note_dtor("ee47070", this);} // tgen
ee47070 ::ee47070(){ note_ctor("ee47070", this);} // tgen

static void Test_ee47070()
{
  extern Class_Descriptor cd_ee47070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47070, buf);
    ee47070 *dp, &lv = *(dp=new (buf) ee47070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee47070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee47070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(16,12), "ee47070");
    check_base_class_offset(lv, (dd7070*), 0, "ee47070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47070.e");
    test_class_info(&lv, &cd_ee47070);
    dp->~ee47070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47070(Test_ee47070, "ee47070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47070C1Ev();
extern void _ZN7ee47070D1Ev();
Name_Map name_map_ee47070[] = {
  NSPAIR(_ZN7ee47070C1Ev),
  NSPAIR(_ZN7ee47070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee47070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47070[];
extern void _ZN7ee470703barEv();
extern void _ZN6dd70703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee470703barEv,_ZTv0_n16_N7ee470703barEv)();
extern void ABISELECT(_ZThn16_N7ee470703barEv,_ZThn12_N7ee470703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47070[0]),
  (VTBL_ENTRY)&_ZN7ee470703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee470703barEv,_ZTv0_n16_N7ee470703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern VTBL_ENTRY _ZTV7ee47070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee47070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee47070[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee47070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee47070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee47070[] = {
  {&(_ZTV7ee47070[4]),  4,13},
  {&(_tg__ZTV6dd7070__7ee47070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee47070[5]),  5,7},
  {&(_ZTV7ee47070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee47070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee47070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee47070[];
extern  VTBL_ENTRY _ZTV7ee47070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47070[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee470703barEv,_ZTv0_n16_N7ee470703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee470703barEv,_ZThn12_N7ee470703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47070 = {  "ee47070", // class name
  bases_ee47070, 4,
  &(vtc_ee47070[0]), // expected_vtbl_contents
  &(vtt_ee47070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57070  : virtual dd7070 {
  int e;
  virtual void  bar(); // _ZN7ee570703barEv
  ~ee57070(); // tgen
  ee57070(); // tgen
};
//SIG(1 ee57070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57070 ::bar(){vfunc_called(this, "_ZN7ee570703barEv");}
ee57070 ::~ee57070(){ note_dtor("ee57070", this);} // tgen
ee57070 ::ee57070(){ note_ctor("ee57070", this);} // tgen

static void Test_ee57070()
{
  extern Class_Descriptor cd_ee57070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57070, buf);
    ee57070 *dp, &lv = *(dp=new (buf) ee57070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee57070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee57070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(32,16), "ee57070");
    check_base_class_offset(lv, (dd7070*), ABISELECT(16,8), "ee57070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57070.e");
    test_class_info(&lv, &cd_ee57070);
    dp->~ee57070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57070(Test_ee57070, "ee57070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57070C1Ev();
extern void _ZN7ee57070D1Ev();
Name_Map name_map_ee57070[] = {
  NSPAIR(_ZN7ee57070C1Ev),
  NSPAIR(_ZN7ee57070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee57070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57070[];
extern void _ZN7ee570703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee570703barEv,_ZTv0_n20_N7ee570703barEv)();
extern void ABISELECT(_ZThn16_N7ee570703barEv,_ZThn8_N7ee570703barEv)() __attribute__((weak));
extern void _ZN6dd70703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee570703barEv,_ZTv0_n16_N7ee570703barEv)();
extern void ABISELECT(_ZThn32_N7ee570703barEv,_ZThn16_N7ee570703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57070[0]),
  (VTBL_ENTRY)&_ZN7ee570703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee570703barEv,_ZTv0_n20_N7ee570703barEv),
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee570703barEv,_ZTv0_n16_N7ee570703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern VTBL_ENTRY _ZTV7ee57070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee57070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee57070[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee57070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee57070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee57070[] = {
  {&(_ZTV7ee57070[5]),  5,21},
  {&(_ZTV7ee57070[12]),  12,21},
  {&(_ZTV7ee57070[19]),  19,21},
  {&(_tg__ZTV6dd7070__7ee57070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee57070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee57070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee57070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee57070[];
extern  VTBL_ENTRY _ZTV7ee57070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57070[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee570703barEv,_ZTv0_n16_N7ee570703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee570703barEv,_ZThn16_N7ee570703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee570703barEv,_ZTv0_n20_N7ee570703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570703barEv,_ZThn8_N7ee570703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57070 = {  "ee57070", // class name
  bases_ee57070, 4,
  &(vtc_ee57070[0]), // expected_vtbl_contents
  &(vtt_ee57070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57070),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67070  : dd7070 {
  int e;
  virtual void  foo(); // _ZN7ee670703fooEv
  virtual void  bar(); // _ZN7ee670703barEv
  ~ee67070(); // tgen
  ee67070(); // tgen
};
//SIG(1 ee67070) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67070 ::foo(){vfunc_called(this, "_ZN7ee670703fooEv");}
void  ee67070 ::bar(){vfunc_called(this, "_ZN7ee670703barEv");}
ee67070 ::~ee67070(){ note_dtor("ee67070", this);} // tgen
ee67070 ::ee67070(){ note_ctor("ee67070", this);} // tgen

static void Test_ee67070()
{
  extern Class_Descriptor cd_ee67070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67070, buf);
    ee67070 *dp, &lv = *(dp=new (buf) ee67070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(32,24), "ee67070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(16,12), "ee67070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(16,12), "ee67070");
    check_base_class_offset(lv, (dd7070*), 0, "ee67070");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67070.e");
    test_class_info(&lv, &cd_ee67070);
    dp->~ee67070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67070(Test_ee67070, "ee67070", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67070C1Ev();
extern void _ZN7ee67070D1Ev();
Name_Map name_map_ee67070[] = {
  NSPAIR(_ZN7ee67070C1Ev),
  NSPAIR(_ZN7ee67070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee67070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67070[];
extern void _ZN7ee670703barEv();
extern void _ZN7ee670703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee670703barEv,_ZTv0_n16_N7ee670703barEv)();
extern void ABISELECT(_ZThn16_N7ee670703barEv,_ZThn12_N7ee670703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee670703fooEv,_ZTv0_n20_N7ee670703fooEv)();
extern void ABISELECT(_ZThn16_N7ee670703fooEv,_ZThn12_N7ee670703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67070[0]),
  (VTBL_ENTRY)&_ZN7ee670703barEv,
  (VTBL_ENTRY)&_ZN7ee670703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee670703barEv,_ZTv0_n16_N7ee670703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee670703fooEv,_ZTv0_n20_N7ee670703fooEv),
};
extern VTBL_ENTRY _ZTV7ee67070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee67070[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee67070[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee67070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee67070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee67070[] = {
  {&(_ZTV7ee67070[4]),  4,13},
  {&(_tg__ZTV6dd7070__7ee67070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee67070[5]),  5,7},
  {&(_ZTV7ee67070[11]),  11,13},
  {&(_tg__ZTV5cc070__7ee67070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee67070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee67070[];
extern  VTBL_ENTRY _ZTV7ee67070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67070[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn12_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn12_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee670703fooEv,_ZTv0_n20_N7ee670703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670703fooEv,_ZThn12_N7ee670703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee670703barEv,_ZTv0_n16_N7ee670703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670703barEv,_ZThn12_N7ee670703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67070 = {  "ee67070", // class name
  bases_ee67070, 4,
  &(vtc_ee67070[0]), // expected_vtbl_contents
  &(vtt_ee67070[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67070),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67070),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67070),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77070  : virtual dd7070 {
  int e;
  virtual void  foo(); // _ZN7ee770703fooEv
  virtual void  bar(); // _ZN7ee770703barEv
  ~ee77070(); // tgen
  ee77070(); // tgen
};
//SIG(1 ee77070) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77070 ::foo(){vfunc_called(this, "_ZN7ee770703fooEv");}
void  ee77070 ::bar(){vfunc_called(this, "_ZN7ee770703barEv");}
ee77070 ::~ee77070(){ note_dtor("ee77070", this);} // tgen
ee77070 ::ee77070(){ note_ctor("ee77070", this);} // tgen

static void Test_ee77070()
{
  extern Class_Descriptor cd_ee77070;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77070, buf);
    ee77070 *dp, &lv = *(dp=new (buf) ee77070());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77070)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77070)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc070*), ABISELECT(48,28), "ee77070");
    check_base_class_offset(lv, (bb70*)(cc070*), ABISELECT(32,16), "ee77070");
    check_base_class_offset(lv, (cc070*)(dd7070*), ABISELECT(32,16), "ee77070");
    check_base_class_offset(lv, (dd7070*), ABISELECT(16,8), "ee77070");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77070.e");
    test_class_info(&lv, &cd_ee77070);
    dp->~ee77070();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77070(Test_ee77070, "ee77070", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77070C1Ev();
extern void _ZN7ee77070D1Ev();
Name_Map name_map_ee77070[] = {
  NSPAIR(_ZN7ee77070C1Ev),
  NSPAIR(_ZN7ee77070D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc070;
extern VTBL_ENTRY _ZTI5cc070[];
extern  VTBL_ENTRY _ZTV5cc070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc070[];
extern Class_Descriptor cd_dd7070;
extern VTBL_ENTRY _ZTI6dd7070[];
extern  VTBL_ENTRY _ZTV6dd7070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7070[];
static Base_Class bases_ee77070[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc070,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7070,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77070[];
extern void _ZN7ee770703fooEv();
extern void _ZN7ee770703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee770703barEv,_ZTv0_n20_N7ee770703barEv)();
extern void ABISELECT(_ZThn16_N7ee770703barEv,_ZThn8_N7ee770703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee770703fooEv,_ZTv0_n24_N7ee770703fooEv)();
extern void ABISELECT(_ZThn16_N7ee770703fooEv,_ZThn8_N7ee770703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee770703barEv,_ZTv0_n16_N7ee770703barEv)();
extern void ABISELECT(_ZThn32_N7ee770703barEv,_ZThn16_N7ee770703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee770703fooEv,_ZTv0_n20_N7ee770703fooEv)();
extern void ABISELECT(_ZThn32_N7ee770703fooEv,_ZThn16_N7ee770703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77070[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77070[0]),
  (VTBL_ENTRY)&_ZN7ee770703fooEv,
  (VTBL_ENTRY)&_ZN7ee770703barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770703barEv,_ZTv0_n20_N7ee770703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee770703fooEv,_ZTv0_n24_N7ee770703fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770703barEv,_ZTv0_n16_N7ee770703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770703fooEv,_ZTv0_n20_N7ee770703fooEv),
};
extern VTBL_ENTRY _ZTV7ee77070[];
extern void _ZN6dd70703barEv();
extern void _ZN6dd70703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7070__7ee77070[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&_ZN6dd70703barEv,
  (VTBL_ENTRY)&_ZN6dd70703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv)();
extern void ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv)();
extern void ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc070__6dd7070__7ee77070[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7070[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc070__7ee77070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc070[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc070__7ee77070[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee77070[] = {
  {&(_ZTV7ee77070[5]),  5,22},
  {&(_ZTV7ee77070[13]),  13,22},
  {&(_ZTV7ee77070[20]),  20,22},
  {&(_tg__ZTV6dd7070__7ee77070[4]),  4,6},
  {&(_tg__ZTV5cc070__6dd7070__7ee77070[5]),  5,7},
  {&(_tg__ZTV5cc070__7ee77070[3]),  3,5},
  {&(_tg__ZTV4bb705cc070__7ee77070[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee77070[];
extern  VTBL_ENTRY _ZTV7ee77070[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77070[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd70703fooEv,_ZTv0_n20_N6dd70703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703fooEv,_ZThn8_N6dd70703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70703barEv,_ZTv0_n16_N6dd70703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70703barEv,_ZThn8_N6dd70703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770703fooEv,_ZTv0_n20_N7ee770703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770703fooEv,_ZThn16_N7ee770703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770703barEv,_ZTv0_n16_N7ee770703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770703barEv,_ZThn16_N7ee770703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee770703fooEv,_ZTv0_n24_N7ee770703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770703fooEv,_ZThn8_N7ee770703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770703barEv,_ZTv0_n20_N7ee770703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770703barEv,_ZThn8_N7ee770703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77070 = {  "ee77070", // class name
  bases_ee77070, 4,
  &(vtc_ee77070[0]), // expected_vtbl_contents
  &(vtt_ee77070[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77070),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77070),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77070),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc170  : virtual bb70 {
  int c;
  ~cc170(); // tgen
  cc170(); // tgen
};
//SIG(-1 cc170) C1{ VBC2{ VBC3{ Fi} v1 v2 Fi} Fi}


cc170 ::~cc170(){ note_dtor("cc170", this);} // tgen
cc170 ::cc170(){ note_ctor("cc170", this);} // tgen

static void Test_cc170()
{
  extern Class_Descriptor cd_cc170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_cc170, buf);
    cc170 *dp, &lv = *(dp=new (buf) cc170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(cc170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(28,16), "cc170");
    check_base_class_offset(lv, (bb70*), ABISELECT(16,8), "cc170");
    check_field_offset(lv, c, ABISELECT(8,4), "cc170.c");
    test_class_info(&lv, &cd_cc170);
    dp->~cc170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc170(Test_cc170, "cc170", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN5cc170C1Ev();
extern void _ZN5cc170D1Ev();
Name_Map name_map_cc170[] = {
  NSPAIR(_ZN5cc170C1Ev),
  NSPAIR(_ZN5cc170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
static Base_Class bases_cc170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_cc170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV5cc170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_cc170[] = {
  {&(_ZTV5cc170[4]),  4,11},
  {&(_ZTV5cc170[9]),  9,11},
  {&(_tg__ZTV4bb70__5cc170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
Class_Descriptor cd_cc170 = {  "cc170", // class name
  bases_cc170, 2,
  &(vtc_cc170[0]), // expected_vtbl_contents
  &(vtt_cc170[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI5cc170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc170),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc170),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0170  : cc170 {
  int d;
  ~dd0170(); // tgen
  dd0170(); // tgen
};
//SIG(-1 dd0170) C1{ BC2{ VBC3{ VBC4{ Fi} v1 v2 Fi} Fi} Fi}


dd0170 ::~dd0170(){ note_dtor("dd0170", this);} // tgen
dd0170 ::dd0170(){ note_ctor("dd0170", this);} // tgen

static void Test_dd0170()
{
  extern Class_Descriptor cd_dd0170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd0170, buf);
    dd0170 *dp, &lv = *(dp=new (buf) dd0170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd0170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(28,20), "dd0170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(16,12), "dd0170");
    check_base_class_offset(lv, (cc170*), 0, "dd0170");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0170.d");
    test_class_info(&lv, &cd_dd0170);
    dp->~dd0170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0170(Test_dd0170, "dd0170", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd0170C1Ev();
extern void _ZN6dd0170D1Ev();
Name_Map name_map_dd0170[] = {
  NSPAIR(_ZN6dd0170C1Ev),
  NSPAIR(_ZN6dd0170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd0170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd0170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd0170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd0170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd0170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd0170[] = {
  {&(_ZTV6dd0170[4]),  4,11},
  {&(_tg__ZTV5cc170__6dd0170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd0170[5]),  5,7},
  {&(_ZTV6dd0170[9]),  9,11},
  {&(_tg__ZTV4bb70__6dd0170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
Class_Descriptor cd_dd0170 = {  "dd0170", // class name
  bases_dd0170, 3,
  &(vtc_dd0170[0]), // expected_vtbl_contents
  &(vtt_dd0170[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd0170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0170),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0170),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00170  : dd0170 {
  int e;
  ~ee00170(); // tgen
  ee00170(); // tgen
};
//SIG(1 ee00170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee00170 ::~ee00170(){ note_dtor("ee00170", this);} // tgen
ee00170 ::ee00170(){ note_ctor("ee00170", this);} // tgen

static void Test_ee00170()
{
  extern Class_Descriptor cd_ee00170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee00170, buf);
    ee00170 *dp, &lv = *(dp=new (buf) ee00170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee00170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee00170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(24,16), "ee00170");
    check_base_class_offset(lv, (cc170*)(dd0170*), 0, "ee00170");
    check_base_class_offset(lv, (dd0170*), 0, "ee00170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00170.e");
    test_class_info(&lv, &cd_ee00170);
    dp->~ee00170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00170(Test_ee00170, "ee00170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee00170C1Ev();
extern void _ZN7ee00170D1Ev();
Name_Map name_map_ee00170[] = {
  NSPAIR(_ZN7ee00170C1Ev),
  NSPAIR(_ZN7ee00170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee00170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee00170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00170[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee00170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee00170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee00170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee00170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee00170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee00170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee00170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee00170[] = {
  {&(_ZTV7ee00170[4]),  4,11},
  {&(_tg__ZTV6dd0170__7ee00170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee00170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee00170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee00170[5]),  5,7},
  {&(_ZTV7ee00170[9]),  9,11},
  {&(_tg__ZTV4bb70__7ee00170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee00170[];
extern  VTBL_ENTRY _ZTV7ee00170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00170[];
Class_Descriptor cd_ee00170 = {  "ee00170", // class name
  bases_ee00170, 4,
  &(vtc_ee00170[0]), // expected_vtbl_contents
  &(vtt_ee00170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee00170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00170),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10170  : virtual dd0170 {
  int e;
  ~ee10170(); // tgen
  ee10170(); // tgen
};
//SIG(1 ee10170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee10170 ::~ee10170(){ note_dtor("ee10170", this);} // tgen
ee10170 ::ee10170(){ note_ctor("ee10170", this);} // tgen

static void Test_ee10170()
{
  extern Class_Descriptor cd_ee10170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee10170, buf);
    ee10170 *dp, &lv = *(dp=new (buf) ee10170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee10170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee10170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(32,20), "ee10170");
    check_base_class_offset(lv, (cc170*)(dd0170*), ABISELECT(16,8), "ee10170");
    check_base_class_offset(lv, (dd0170*), ABISELECT(16,8), "ee10170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10170.e");
    test_class_info(&lv, &cd_ee10170);
    dp->~ee10170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10170(Test_ee10170, "ee10170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee10170C1Ev();
extern void _ZN7ee10170D1Ev();
Name_Map name_map_ee10170[] = {
  NSPAIR(_ZN7ee10170C1Ev),
  NSPAIR(_ZN7ee10170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee10170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee10170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10170[0]),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10170[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee10170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee10170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee10170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee10170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee10170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee10170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee10170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee10170[] = {
  {&(_ZTV7ee10170[5]),  5,16},
  {&(_ZTV7ee10170[9]),  9,16},
  {&(_ZTV7ee10170[14]),  14,16},
  {&(_tg__ZTV6dd0170__7ee10170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee10170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee10170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee10170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee10170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee10170[];
extern  VTBL_ENTRY _ZTV7ee10170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10170[];
Class_Descriptor cd_ee10170 = {  "ee10170", // class name
  bases_ee10170, 4,
  &(vtc_ee10170[0]), // expected_vtbl_contents
  &(vtt_ee10170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee10170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10170),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20170  : dd0170 {
  int e;
  virtual void  foo(); // _ZN7ee201703fooEv
  ~ee20170(); // tgen
  ee20170(); // tgen
};
//SIG(1 ee20170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee20170 ::foo(){vfunc_called(this, "_ZN7ee201703fooEv");}
ee20170 ::~ee20170(){ note_dtor("ee20170", this);} // tgen
ee20170 ::ee20170(){ note_ctor("ee20170", this);} // tgen

static void Test_ee20170()
{
  extern Class_Descriptor cd_ee20170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee20170, buf);
    ee20170 *dp, &lv = *(dp=new (buf) ee20170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee20170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee20170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(24,16), "ee20170");
    check_base_class_offset(lv, (cc170*)(dd0170*), 0, "ee20170");
    check_base_class_offset(lv, (dd0170*), 0, "ee20170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20170.e");
    test_class_info(&lv, &cd_ee20170);
    dp->~ee20170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20170(Test_ee20170, "ee20170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee20170C1Ev();
extern void _ZN7ee20170D1Ev();
Name_Map name_map_ee20170[] = {
  NSPAIR(_ZN7ee20170C1Ev),
  NSPAIR(_ZN7ee20170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee20170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20170[];
extern void _ZN7ee201703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee201703fooEv,_ZTv0_n20_N7ee201703fooEv)();
extern void ABISELECT(_ZThn24_N7ee201703fooEv,_ZThn16_N7ee201703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee20170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20170[0]),
  (VTBL_ENTRY)&_ZN7ee201703fooEv,
  ABISELECT(-24,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee20170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee201703fooEv,_ZTv0_n20_N7ee201703fooEv),
};
extern VTBL_ENTRY _ZTV7ee20170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee20170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee20170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee20170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee20170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee20170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee20170[] = {
  {&(_ZTV7ee20170[4]),  4,12},
  {&(_tg__ZTV6dd0170__7ee20170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee20170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee20170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee20170[5]),  5,7},
  {&(_ZTV7ee20170[10]),  10,12},
  {&(_tg__ZTV4bb70__7ee20170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee20170[];
extern  VTBL_ENTRY _ZTV7ee20170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20170[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee201703fooEv,_ZTv0_n20_N7ee201703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee201703fooEv,_ZThn16_N7ee201703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee20170 = {  "ee20170", // class name
  bases_ee20170, 4,
  &(vtc_ee20170[0]), // expected_vtbl_contents
  &(vtt_ee20170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee20170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30170  : virtual dd0170 {
  int e;
  virtual void  foo(); // _ZN7ee301703fooEv
  ~ee30170(); // tgen
  ee30170(); // tgen
};
//SIG(1 ee30170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee30170 ::foo(){vfunc_called(this, "_ZN7ee301703fooEv");}
ee30170 ::~ee30170(){ note_dtor("ee30170", this);} // tgen
ee30170 ::ee30170(){ note_ctor("ee30170", this);} // tgen

static void Test_ee30170()
{
  extern Class_Descriptor cd_ee30170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee30170, buf);
    ee30170 *dp, &lv = *(dp=new (buf) ee30170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee30170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee30170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(32,20), "ee30170");
    check_base_class_offset(lv, (cc170*)(dd0170*), ABISELECT(16,8), "ee30170");
    check_base_class_offset(lv, (dd0170*), ABISELECT(16,8), "ee30170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30170.e");
    test_class_info(&lv, &cd_ee30170);
    dp->~ee30170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30170(Test_ee30170, "ee30170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee30170C1Ev();
extern void _ZN7ee30170D1Ev();
Name_Map name_map_ee30170[] = {
  NSPAIR(_ZN7ee30170C1Ev),
  NSPAIR(_ZN7ee30170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee30170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30170[];
extern void _ZN7ee301703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee301703fooEv,_ZTv0_n20_N7ee301703fooEv)();
extern void ABISELECT(_ZThn32_N7ee301703fooEv,_ZThn20_N7ee301703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30170[0]),
  (VTBL_ENTRY)&_ZN7ee301703fooEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30170[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee30170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee301703fooEv,_ZTv0_n20_N7ee301703fooEv),
};
extern VTBL_ENTRY _ZTV7ee30170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee30170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee30170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee30170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee30170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee30170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee30170[] = {
  {&(_ZTV7ee30170[5]),  5,17},
  {&(_ZTV7ee30170[10]),  10,17},
  {&(_ZTV7ee30170[15]),  15,17},
  {&(_tg__ZTV6dd0170__7ee30170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee30170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee30170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee30170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee30170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee30170[];
extern  VTBL_ENTRY _ZTV7ee30170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30170[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee301703fooEv,_ZTv0_n20_N7ee301703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee301703fooEv,_ZThn20_N7ee301703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30170 = {  "ee30170", // class name
  bases_ee30170, 4,
  &(vtc_ee30170[0]), // expected_vtbl_contents
  &(vtt_ee30170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee30170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40170  : dd0170 {
  int e;
  virtual void  bar(); // _ZN7ee401703barEv
  ~ee40170(); // tgen
  ee40170(); // tgen
};
//SIG(1 ee40170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee40170 ::bar(){vfunc_called(this, "_ZN7ee401703barEv");}
ee40170 ::~ee40170(){ note_dtor("ee40170", this);} // tgen
ee40170 ::ee40170(){ note_ctor("ee40170", this);} // tgen

static void Test_ee40170()
{
  extern Class_Descriptor cd_ee40170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee40170, buf);
    ee40170 *dp, &lv = *(dp=new (buf) ee40170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee40170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee40170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(24,16), "ee40170");
    check_base_class_offset(lv, (cc170*)(dd0170*), 0, "ee40170");
    check_base_class_offset(lv, (dd0170*), 0, "ee40170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40170.e");
    test_class_info(&lv, &cd_ee40170);
    dp->~ee40170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40170(Test_ee40170, "ee40170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee40170C1Ev();
extern void _ZN7ee40170D1Ev();
Name_Map name_map_ee40170[] = {
  NSPAIR(_ZN7ee40170C1Ev),
  NSPAIR(_ZN7ee40170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee40170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40170[];
extern void _ZN7ee401703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee401703barEv,_ZTv0_n16_N7ee401703barEv)();
extern void ABISELECT(_ZThn24_N7ee401703barEv,_ZThn16_N7ee401703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee40170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40170[0]),
  (VTBL_ENTRY)&_ZN7ee401703barEv,
  0,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee40170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee401703barEv,_ZTv0_n16_N7ee401703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee40170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee40170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee40170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee40170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee40170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee40170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee40170[] = {
  {&(_ZTV7ee40170[4]),  4,12},
  {&(_tg__ZTV6dd0170__7ee40170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee40170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee40170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee40170[5]),  5,7},
  {&(_ZTV7ee40170[10]),  10,12},
  {&(_tg__ZTV4bb70__7ee40170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee40170[];
extern  VTBL_ENTRY _ZTV7ee40170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40170[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee401703barEv,_ZTv0_n16_N7ee401703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee401703barEv,_ZThn16_N7ee401703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee40170 = {  "ee40170", // class name
  bases_ee40170, 4,
  &(vtc_ee40170[0]), // expected_vtbl_contents
  &(vtt_ee40170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee40170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50170  : virtual dd0170 {
  int e;
  virtual void  bar(); // _ZN7ee501703barEv
  ~ee50170(); // tgen
  ee50170(); // tgen
};
//SIG(1 ee50170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee50170 ::bar(){vfunc_called(this, "_ZN7ee501703barEv");}
ee50170 ::~ee50170(){ note_dtor("ee50170", this);} // tgen
ee50170 ::ee50170(){ note_ctor("ee50170", this);} // tgen

static void Test_ee50170()
{
  extern Class_Descriptor cd_ee50170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee50170, buf);
    ee50170 *dp, &lv = *(dp=new (buf) ee50170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee50170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee50170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(32,20), "ee50170");
    check_base_class_offset(lv, (cc170*)(dd0170*), ABISELECT(16,8), "ee50170");
    check_base_class_offset(lv, (dd0170*), ABISELECT(16,8), "ee50170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50170.e");
    test_class_info(&lv, &cd_ee50170);
    dp->~ee50170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50170(Test_ee50170, "ee50170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee50170C1Ev();
extern void _ZN7ee50170D1Ev();
Name_Map name_map_ee50170[] = {
  NSPAIR(_ZN7ee50170C1Ev),
  NSPAIR(_ZN7ee50170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee50170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50170[];
extern void _ZN7ee501703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee501703barEv,_ZTv0_n16_N7ee501703barEv)();
extern void ABISELECT(_ZThn32_N7ee501703barEv,_ZThn20_N7ee501703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee50170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50170[0]),
  (VTBL_ENTRY)&_ZN7ee501703barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50170[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee50170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee501703barEv,_ZTv0_n16_N7ee501703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee50170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee50170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee50170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee50170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee50170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee50170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee50170[] = {
  {&(_ZTV7ee50170[5]),  5,17},
  {&(_ZTV7ee50170[10]),  10,17},
  {&(_ZTV7ee50170[15]),  15,17},
  {&(_tg__ZTV6dd0170__7ee50170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee50170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee50170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee50170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee50170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee50170[];
extern  VTBL_ENTRY _ZTV7ee50170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50170[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee501703barEv,_ZTv0_n16_N7ee501703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee501703barEv,_ZThn20_N7ee501703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50170 = {  "ee50170", // class name
  bases_ee50170, 4,
  &(vtc_ee50170[0]), // expected_vtbl_contents
  &(vtt_ee50170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee50170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60170  : dd0170 {
  int e;
  virtual void  foo(); // _ZN7ee601703fooEv
  virtual void  bar(); // _ZN7ee601703barEv
  ~ee60170(); // tgen
  ee60170(); // tgen
};
//SIG(1 ee60170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60170 ::foo(){vfunc_called(this, "_ZN7ee601703fooEv");}
void  ee60170 ::bar(){vfunc_called(this, "_ZN7ee601703barEv");}
ee60170 ::~ee60170(){ note_dtor("ee60170", this);} // tgen
ee60170 ::ee60170(){ note_ctor("ee60170", this);} // tgen

static void Test_ee60170()
{
  extern Class_Descriptor cd_ee60170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee60170, buf);
    ee60170 *dp, &lv = *(dp=new (buf) ee60170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee60170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee60170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(24,16), "ee60170");
    check_base_class_offset(lv, (cc170*)(dd0170*), 0, "ee60170");
    check_base_class_offset(lv, (dd0170*), 0, "ee60170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60170.e");
    test_class_info(&lv, &cd_ee60170);
    dp->~ee60170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60170(Test_ee60170, "ee60170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee60170C1Ev();
extern void _ZN7ee60170D1Ev();
Name_Map name_map_ee60170[] = {
  NSPAIR(_ZN7ee60170C1Ev),
  NSPAIR(_ZN7ee60170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee60170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60170[];
extern void _ZN7ee601703fooEv();
extern void _ZN7ee601703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee601703barEv,_ZTv0_n16_N7ee601703barEv)();
extern void ABISELECT(_ZThn24_N7ee601703barEv,_ZThn16_N7ee601703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee601703fooEv,_ZTv0_n20_N7ee601703fooEv)();
extern void ABISELECT(_ZThn24_N7ee601703fooEv,_ZThn16_N7ee601703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee60170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60170[0]),
  (VTBL_ENTRY)&_ZN7ee601703fooEv,
  (VTBL_ENTRY)&_ZN7ee601703barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee60170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee601703barEv,_ZTv0_n16_N7ee601703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee601703fooEv,_ZTv0_n20_N7ee601703fooEv),
};
extern VTBL_ENTRY _ZTV7ee60170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee60170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee60170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee60170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee60170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee60170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee60170[] = {
  {&(_ZTV7ee60170[4]),  4,13},
  {&(_tg__ZTV6dd0170__7ee60170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee60170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee60170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee60170[5]),  5,7},
  {&(_ZTV7ee60170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee60170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee60170[];
extern  VTBL_ENTRY _ZTV7ee60170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60170[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee601703fooEv,_ZTv0_n20_N7ee601703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601703fooEv,_ZThn16_N7ee601703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee601703barEv,_ZTv0_n16_N7ee601703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601703barEv,_ZThn16_N7ee601703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee60170 = {  "ee60170", // class name
  bases_ee60170, 4,
  &(vtc_ee60170[0]), // expected_vtbl_contents
  &(vtt_ee60170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee60170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70170  : virtual dd0170 {
  int e;
  virtual void  foo(); // _ZN7ee701703fooEv
  virtual void  bar(); // _ZN7ee701703barEv
  ~ee70170(); // tgen
  ee70170(); // tgen
};
//SIG(1 ee70170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70170 ::foo(){vfunc_called(this, "_ZN7ee701703fooEv");}
void  ee70170 ::bar(){vfunc_called(this, "_ZN7ee701703barEv");}
ee70170 ::~ee70170(){ note_dtor("ee70170", this);} // tgen
ee70170 ::ee70170(){ note_ctor("ee70170", this);} // tgen

static void Test_ee70170()
{
  extern Class_Descriptor cd_ee70170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee70170, buf);
    ee70170 *dp, &lv = *(dp=new (buf) ee70170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee70170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee70170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd0170*), ABISELECT(32,20), "ee70170");
    check_base_class_offset(lv, (cc170*)(dd0170*), ABISELECT(16,8), "ee70170");
    check_base_class_offset(lv, (dd0170*), ABISELECT(16,8), "ee70170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70170.e");
    test_class_info(&lv, &cd_ee70170);
    dp->~ee70170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70170(Test_ee70170, "ee70170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee70170C1Ev();
extern void _ZN7ee70170D1Ev();
Name_Map name_map_ee70170[] = {
  NSPAIR(_ZN7ee70170C1Ev),
  NSPAIR(_ZN7ee70170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd0170;
extern VTBL_ENTRY _ZTI6dd0170[];
extern  VTBL_ENTRY _ZTV6dd0170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0170[];
static Base_Class bases_ee70170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70170[];
extern void _ZN7ee701703fooEv();
extern void _ZN7ee701703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee701703barEv,_ZTv0_n16_N7ee701703barEv)();
extern void ABISELECT(_ZThn32_N7ee701703barEv,_ZThn20_N7ee701703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee701703fooEv,_ZTv0_n20_N7ee701703fooEv)();
extern void ABISELECT(_ZThn32_N7ee701703fooEv,_ZThn20_N7ee701703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70170[0]),
  (VTBL_ENTRY)&_ZN7ee701703fooEv,
  (VTBL_ENTRY)&_ZN7ee701703barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee70170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee701703barEv,_ZTv0_n16_N7ee701703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee701703fooEv,_ZTv0_n20_N7ee701703fooEv),
};
extern VTBL_ENTRY _ZTV7ee70170[];
static  VTBL_ENTRY _tg__ZTV6dd0170__7ee70170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd0170__7ee70170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd0170__7ee70170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd0170__7ee70170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee70170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee70170[] = {
  {&(_ZTV7ee70170[5]),  5,18},
  {&(_ZTV7ee70170[11]),  11,18},
  {&(_ZTV7ee70170[16]),  16,18},
  {&(_tg__ZTV6dd0170__7ee70170[4]),  4,4},
  {&(_tg__ZTV5cc1706dd0170__7ee70170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd0170__7ee70170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd0170__7ee70170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee70170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee70170[];
extern  VTBL_ENTRY _ZTV7ee70170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70170[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee701703fooEv,_ZTv0_n20_N7ee701703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701703fooEv,_ZThn20_N7ee701703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee701703barEv,_ZTv0_n16_N7ee701703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701703barEv,_ZThn20_N7ee701703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70170 = {  "ee70170", // class name
  bases_ee70170, 4,
  &(vtc_ee70170[0]), // expected_vtbl_contents
  &(vtt_ee70170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee70170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1170  : virtual cc170 {
  int d;
  ~dd1170(); // tgen
  dd1170(); // tgen
};
//SIG(-1 dd1170) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 v2 Fi} Fi} Fi}


dd1170 ::~dd1170(){ note_dtor("dd1170", this);} // tgen
dd1170 ::dd1170(){ note_ctor("dd1170", this);} // tgen

static void Test_dd1170()
{
  extern Class_Descriptor cd_dd1170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd1170, buf);
    dd1170 *dp, &lv = *(dp=new (buf) dd1170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd1170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,24), "dd1170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,16), "dd1170");
    check_base_class_offset(lv, (cc170*), ABISELECT(16,8), "dd1170");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1170.d");
    test_class_info(&lv, &cd_dd1170);
    dp->~dd1170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1170(Test_dd1170, "dd1170", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd1170C1Ev();
extern void _ZN6dd1170D1Ev();
Name_Map name_map_dd1170[] = {
  NSPAIR(_ZN6dd1170C1Ev),
  NSPAIR(_ZN6dd1170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd1170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd1170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd1170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd1170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd1170[] = {
  {&(_ZTV6dd1170[5]),  5,16},
  {&(_ZTV6dd1170[9]),  9,16},
  {&(_ZTV6dd1170[14]),  14,16},
  {&(_tg__ZTV5cc170__6dd1170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd1170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd1170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
Class_Descriptor cd_dd1170 = {  "dd1170", // class name
  bases_dd1170, 3,
  &(vtc_dd1170[0]), // expected_vtbl_contents
  &(vtt_dd1170[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd1170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1170),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1170),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01170  : dd1170 {
  int e;
  ~ee01170(); // tgen
  ee01170(); // tgen
};
//SIG(1 ee01170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee01170 ::~ee01170(){ note_dtor("ee01170", this);} // tgen
ee01170 ::ee01170(){ note_ctor("ee01170", this);} // tgen

static void Test_ee01170()
{
  extern Class_Descriptor cd_ee01170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee01170, buf);
    ee01170 *dp, &lv = *(dp=new (buf) ee01170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee01170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee01170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee01170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(16,12), "ee01170");
    check_base_class_offset(lv, (dd1170*), 0, "ee01170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01170.e");
    test_class_info(&lv, &cd_ee01170);
    dp->~ee01170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01170(Test_ee01170, "ee01170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee01170C1Ev();
extern void _ZN7ee01170D1Ev();
Name_Map name_map_ee01170[] = {
  NSPAIR(_ZN7ee01170C1Ev),
  NSPAIR(_ZN7ee01170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee01170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee01170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01170[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01170[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee01170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee01170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee01170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee01170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee01170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee01170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee01170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee01170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee01170[] = {
  {&(_ZTV7ee01170[5]),  5,16},
  {&(_tg__ZTV6dd1170__7ee01170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee01170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee01170[5]),  5,7},
  {&(_ZTV7ee01170[9]),  9,16},
  {&(_ZTV7ee01170[14]),  14,16},
  {&(_tg__ZTV5cc170__7ee01170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee01170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee01170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee01170[];
extern  VTBL_ENTRY _ZTV7ee01170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01170[];
Class_Descriptor cd_ee01170 = {  "ee01170", // class name
  bases_ee01170, 4,
  &(vtc_ee01170[0]), // expected_vtbl_contents
  &(vtt_ee01170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee01170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01170),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11170  : virtual dd1170 {
  int e;
  ~ee11170(); // tgen
  ee11170(); // tgen
};
//SIG(1 ee11170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee11170 ::~ee11170(){ note_dtor("ee11170", this);} // tgen
ee11170 ::ee11170(){ note_ctor("ee11170", this);} // tgen

static void Test_ee11170()
{
  extern Class_Descriptor cd_ee11170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee11170, buf);
    ee11170 *dp, &lv = *(dp=new (buf) ee11170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee11170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee11170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee11170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(32,16), "ee11170");
    check_base_class_offset(lv, (dd1170*), ABISELECT(16,8), "ee11170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11170.e");
    test_class_info(&lv, &cd_ee11170);
    dp->~ee11170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11170(Test_ee11170, "ee11170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee11170C1Ev();
extern void _ZN7ee11170D1Ev();
Name_Map name_map_ee11170[] = {
  NSPAIR(_ZN7ee11170C1Ev),
  NSPAIR(_ZN7ee11170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee11170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11170[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee11170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11170[0]),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11170[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11170[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee11170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee11170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee11170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee11170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee11170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee11170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee11170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee11170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee11170[] = {
  {&(_ZTV7ee11170[6]),  6,22},
  {&(_ZTV7ee11170[11]),  11,22},
  {&(_ZTV7ee11170[15]),  15,22},
  {&(_ZTV7ee11170[20]),  20,22},
  {&(_tg__ZTV6dd1170__7ee11170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee11170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee11170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee11170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee11170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee11170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee11170[];
extern  VTBL_ENTRY _ZTV7ee11170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11170[];
Class_Descriptor cd_ee11170 = {  "ee11170", // class name
  bases_ee11170, 4,
  &(vtc_ee11170[0]), // expected_vtbl_contents
  &(vtt_ee11170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee11170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11170),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21170  : dd1170 {
  int e;
  virtual void  foo(); // _ZN7ee211703fooEv
  ~ee21170(); // tgen
  ee21170(); // tgen
};
//SIG(1 ee21170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee21170 ::foo(){vfunc_called(this, "_ZN7ee211703fooEv");}
ee21170 ::~ee21170(){ note_dtor("ee21170", this);} // tgen
ee21170 ::ee21170(){ note_ctor("ee21170", this);} // tgen

static void Test_ee21170()
{
  extern Class_Descriptor cd_ee21170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee21170, buf);
    ee21170 *dp, &lv = *(dp=new (buf) ee21170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee21170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee21170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee21170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(16,12), "ee21170");
    check_base_class_offset(lv, (dd1170*), 0, "ee21170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21170.e");
    test_class_info(&lv, &cd_ee21170);
    dp->~ee21170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21170(Test_ee21170, "ee21170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee21170C1Ev();
extern void _ZN7ee21170D1Ev();
Name_Map name_map_ee21170[] = {
  NSPAIR(_ZN7ee21170C1Ev),
  NSPAIR(_ZN7ee21170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee21170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21170[];
extern void _ZN7ee211703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee211703fooEv,_ZTv0_n20_N7ee211703fooEv)();
extern void ABISELECT(_ZThn32_N7ee211703fooEv,_ZThn20_N7ee211703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21170[0]),
  (VTBL_ENTRY)&_ZN7ee211703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21170[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee21170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee211703fooEv,_ZTv0_n20_N7ee211703fooEv),
};
extern VTBL_ENTRY _ZTV7ee21170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee21170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee21170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee21170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee21170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee21170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee21170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee21170[] = {
  {&(_ZTV7ee21170[5]),  5,17},
  {&(_tg__ZTV6dd1170__7ee21170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee21170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee21170[5]),  5,7},
  {&(_ZTV7ee21170[10]),  10,17},
  {&(_ZTV7ee21170[15]),  15,17},
  {&(_tg__ZTV5cc170__7ee21170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee21170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee21170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee21170[];
extern  VTBL_ENTRY _ZTV7ee21170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21170[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee211703fooEv,_ZTv0_n20_N7ee211703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee211703fooEv,_ZThn20_N7ee211703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21170 = {  "ee21170", // class name
  bases_ee21170, 4,
  &(vtc_ee21170[0]), // expected_vtbl_contents
  &(vtt_ee21170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee21170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31170  : virtual dd1170 {
  int e;
  virtual void  foo(); // _ZN7ee311703fooEv
  ~ee31170(); // tgen
  ee31170(); // tgen
};
//SIG(1 ee31170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee31170 ::foo(){vfunc_called(this, "_ZN7ee311703fooEv");}
ee31170 ::~ee31170(){ note_dtor("ee31170", this);} // tgen
ee31170 ::ee31170(){ note_ctor("ee31170", this);} // tgen

static void Test_ee31170()
{
  extern Class_Descriptor cd_ee31170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee31170, buf);
    ee31170 *dp, &lv = *(dp=new (buf) ee31170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee31170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee31170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee31170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(32,16), "ee31170");
    check_base_class_offset(lv, (dd1170*), ABISELECT(16,8), "ee31170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31170.e");
    test_class_info(&lv, &cd_ee31170);
    dp->~ee31170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31170(Test_ee31170, "ee31170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee31170C1Ev();
extern void _ZN7ee31170D1Ev();
Name_Map name_map_ee31170[] = {
  NSPAIR(_ZN7ee31170C1Ev),
  NSPAIR(_ZN7ee31170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee31170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31170[];
extern void _ZN7ee311703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee311703fooEv,_ZTv0_n20_N7ee311703fooEv)();
extern void ABISELECT(_ZThn48_N7ee311703fooEv,_ZThn24_N7ee311703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31170[0]),
  (VTBL_ENTRY)&_ZN7ee311703fooEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31170[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31170[0]),
  ABISELECT(-48,-24),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee31170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee311703fooEv,_ZTv0_n20_N7ee311703fooEv),
};
extern VTBL_ENTRY _ZTV7ee31170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee31170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee31170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee31170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee31170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee31170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee31170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee31170[] = {
  {&(_ZTV7ee31170[6]),  6,23},
  {&(_ZTV7ee31170[12]),  12,23},
  {&(_ZTV7ee31170[16]),  16,23},
  {&(_ZTV7ee31170[21]),  21,23},
  {&(_tg__ZTV6dd1170__7ee31170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee31170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee31170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee31170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee31170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee31170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee31170[];
extern  VTBL_ENTRY _ZTV7ee31170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31170[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee311703fooEv,_ZTv0_n20_N7ee311703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee311703fooEv,_ZThn24_N7ee311703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31170 = {  "ee31170", // class name
  bases_ee31170, 4,
  &(vtc_ee31170[0]), // expected_vtbl_contents
  &(vtt_ee31170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee31170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31170),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41170  : dd1170 {
  int e;
  virtual void  bar(); // _ZN7ee411703barEv
  ~ee41170(); // tgen
  ee41170(); // tgen
};
//SIG(1 ee41170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee41170 ::bar(){vfunc_called(this, "_ZN7ee411703barEv");}
ee41170 ::~ee41170(){ note_dtor("ee41170", this);} // tgen
ee41170 ::ee41170(){ note_ctor("ee41170", this);} // tgen

static void Test_ee41170()
{
  extern Class_Descriptor cd_ee41170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee41170, buf);
    ee41170 *dp, &lv = *(dp=new (buf) ee41170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee41170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee41170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee41170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(16,12), "ee41170");
    check_base_class_offset(lv, (dd1170*), 0, "ee41170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41170.e");
    test_class_info(&lv, &cd_ee41170);
    dp->~ee41170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41170(Test_ee41170, "ee41170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee41170C1Ev();
extern void _ZN7ee41170D1Ev();
Name_Map name_map_ee41170[] = {
  NSPAIR(_ZN7ee41170C1Ev),
  NSPAIR(_ZN7ee41170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee41170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41170[];
extern void _ZN7ee411703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee411703barEv,_ZTv0_n16_N7ee411703barEv)();
extern void ABISELECT(_ZThn32_N7ee411703barEv,_ZThn20_N7ee411703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee41170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41170[0]),
  (VTBL_ENTRY)&_ZN7ee411703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41170[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee41170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee411703barEv,_ZTv0_n16_N7ee411703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee41170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee41170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee41170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee41170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee41170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee41170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee41170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee41170[] = {
  {&(_ZTV7ee41170[5]),  5,17},
  {&(_tg__ZTV6dd1170__7ee41170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee41170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee41170[5]),  5,7},
  {&(_ZTV7ee41170[10]),  10,17},
  {&(_ZTV7ee41170[15]),  15,17},
  {&(_tg__ZTV5cc170__7ee41170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee41170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee41170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee41170[];
extern  VTBL_ENTRY _ZTV7ee41170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41170[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee411703barEv,_ZTv0_n16_N7ee411703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee411703barEv,_ZThn20_N7ee411703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41170 = {  "ee41170", // class name
  bases_ee41170, 4,
  &(vtc_ee41170[0]), // expected_vtbl_contents
  &(vtt_ee41170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee41170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51170  : virtual dd1170 {
  int e;
  virtual void  bar(); // _ZN7ee511703barEv
  ~ee51170(); // tgen
  ee51170(); // tgen
};
//SIG(1 ee51170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee51170 ::bar(){vfunc_called(this, "_ZN7ee511703barEv");}
ee51170 ::~ee51170(){ note_dtor("ee51170", this);} // tgen
ee51170 ::ee51170(){ note_ctor("ee51170", this);} // tgen

static void Test_ee51170()
{
  extern Class_Descriptor cd_ee51170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee51170, buf);
    ee51170 *dp, &lv = *(dp=new (buf) ee51170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee51170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee51170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee51170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(32,16), "ee51170");
    check_base_class_offset(lv, (dd1170*), ABISELECT(16,8), "ee51170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51170.e");
    test_class_info(&lv, &cd_ee51170);
    dp->~ee51170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51170(Test_ee51170, "ee51170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee51170C1Ev();
extern void _ZN7ee51170D1Ev();
Name_Map name_map_ee51170[] = {
  NSPAIR(_ZN7ee51170C1Ev),
  NSPAIR(_ZN7ee51170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee51170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51170[];
extern void _ZN7ee511703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee511703barEv,_ZTv0_n16_N7ee511703barEv)();
extern void ABISELECT(_ZThn48_N7ee511703barEv,_ZThn24_N7ee511703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee51170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51170[0]),
  (VTBL_ENTRY)&_ZN7ee511703barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51170[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51170[0]),
  0,
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee51170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee511703barEv,_ZTv0_n16_N7ee511703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee51170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee51170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee51170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee51170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee51170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee51170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee51170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee51170[] = {
  {&(_ZTV7ee51170[6]),  6,23},
  {&(_ZTV7ee51170[12]),  12,23},
  {&(_ZTV7ee51170[16]),  16,23},
  {&(_ZTV7ee51170[21]),  21,23},
  {&(_tg__ZTV6dd1170__7ee51170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee51170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee51170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee51170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee51170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee51170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee51170[];
extern  VTBL_ENTRY _ZTV7ee51170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51170[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee511703barEv,_ZTv0_n16_N7ee511703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee511703barEv,_ZThn24_N7ee511703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51170 = {  "ee51170", // class name
  bases_ee51170, 4,
  &(vtc_ee51170[0]), // expected_vtbl_contents
  &(vtt_ee51170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee51170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51170),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61170  : dd1170 {
  int e;
  virtual void  foo(); // _ZN7ee611703fooEv
  virtual void  bar(); // _ZN7ee611703barEv
  ~ee61170(); // tgen
  ee61170(); // tgen
};
//SIG(1 ee61170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61170 ::foo(){vfunc_called(this, "_ZN7ee611703fooEv");}
void  ee61170 ::bar(){vfunc_called(this, "_ZN7ee611703barEv");}
ee61170 ::~ee61170(){ note_dtor("ee61170", this);} // tgen
ee61170 ::ee61170(){ note_ctor("ee61170", this);} // tgen

static void Test_ee61170()
{
  extern Class_Descriptor cd_ee61170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee61170, buf);
    ee61170 *dp, &lv = *(dp=new (buf) ee61170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee61170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee61170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee61170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(16,12), "ee61170");
    check_base_class_offset(lv, (dd1170*), 0, "ee61170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61170.e");
    test_class_info(&lv, &cd_ee61170);
    dp->~ee61170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61170(Test_ee61170, "ee61170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee61170C1Ev();
extern void _ZN7ee61170D1Ev();
Name_Map name_map_ee61170[] = {
  NSPAIR(_ZN7ee61170C1Ev),
  NSPAIR(_ZN7ee61170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee61170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61170[];
extern void _ZN7ee611703fooEv();
extern void _ZN7ee611703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee611703barEv,_ZTv0_n16_N7ee611703barEv)();
extern void ABISELECT(_ZThn32_N7ee611703barEv,_ZThn20_N7ee611703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee611703fooEv,_ZTv0_n20_N7ee611703fooEv)();
extern void ABISELECT(_ZThn32_N7ee611703fooEv,_ZThn20_N7ee611703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61170[0]),
  (VTBL_ENTRY)&_ZN7ee611703fooEv,
  (VTBL_ENTRY)&_ZN7ee611703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee61170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee611703barEv,_ZTv0_n16_N7ee611703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee611703fooEv,_ZTv0_n20_N7ee611703fooEv),
};
extern VTBL_ENTRY _ZTV7ee61170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee61170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee61170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee61170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee61170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee61170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee61170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee61170[] = {
  {&(_ZTV7ee61170[5]),  5,18},
  {&(_tg__ZTV6dd1170__7ee61170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee61170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee61170[5]),  5,7},
  {&(_ZTV7ee61170[11]),  11,18},
  {&(_ZTV7ee61170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee61170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee61170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee61170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee61170[];
extern  VTBL_ENTRY _ZTV7ee61170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61170[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee611703fooEv,_ZTv0_n20_N7ee611703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611703fooEv,_ZThn20_N7ee611703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee611703barEv,_ZTv0_n16_N7ee611703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611703barEv,_ZThn20_N7ee611703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61170 = {  "ee61170", // class name
  bases_ee61170, 4,
  &(vtc_ee61170[0]), // expected_vtbl_contents
  &(vtt_ee61170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee61170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71170  : virtual dd1170 {
  int e;
  virtual void  foo(); // _ZN7ee711703fooEv
  virtual void  bar(); // _ZN7ee711703barEv
  ~ee71170(); // tgen
  ee71170(); // tgen
};
//SIG(1 ee71170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71170 ::foo(){vfunc_called(this, "_ZN7ee711703fooEv");}
void  ee71170 ::bar(){vfunc_called(this, "_ZN7ee711703barEv");}
ee71170 ::~ee71170(){ note_dtor("ee71170", this);} // tgen
ee71170 ::ee71170(){ note_ctor("ee71170", this);} // tgen

static void Test_ee71170()
{
  extern Class_Descriptor cd_ee71170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee71170, buf);
    ee71170 *dp, &lv = *(dp=new (buf) ee71170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee71170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee71170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee71170");
    check_base_class_offset(lv, (cc170*)(dd1170*), ABISELECT(32,16), "ee71170");
    check_base_class_offset(lv, (dd1170*), ABISELECT(16,8), "ee71170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71170.e");
    test_class_info(&lv, &cd_ee71170);
    dp->~ee71170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71170(Test_ee71170, "ee71170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee71170C1Ev();
extern void _ZN7ee71170D1Ev();
Name_Map name_map_ee71170[] = {
  NSPAIR(_ZN7ee71170C1Ev),
  NSPAIR(_ZN7ee71170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd1170;
extern VTBL_ENTRY _ZTI6dd1170[];
extern  VTBL_ENTRY _ZTV6dd1170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1170[];
static Base_Class bases_ee71170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1170,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71170[];
extern void _ZN7ee711703fooEv();
extern void _ZN7ee711703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee711703barEv,_ZTv0_n16_N7ee711703barEv)();
extern void ABISELECT(_ZThn48_N7ee711703barEv,_ZThn24_N7ee711703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee711703fooEv,_ZTv0_n20_N7ee711703fooEv)();
extern void ABISELECT(_ZThn48_N7ee711703fooEv,_ZThn24_N7ee711703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71170[0]),
  (VTBL_ENTRY)&_ZN7ee711703fooEv,
  (VTBL_ENTRY)&_ZN7ee711703barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71170[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71170[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee71170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee711703barEv,_ZTv0_n16_N7ee711703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee711703fooEv,_ZTv0_n20_N7ee711703fooEv),
};
extern VTBL_ENTRY _ZTV7ee71170[];
static  VTBL_ENTRY _tg__ZTV6dd1170__7ee71170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd1170__7ee71170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd1170__7ee71170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee71170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee71170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee71170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee71170[] = {
  {&(_ZTV7ee71170[6]),  6,24},
  {&(_ZTV7ee71170[13]),  13,24},
  {&(_ZTV7ee71170[17]),  17,24},
  {&(_ZTV7ee71170[22]),  22,24},
  {&(_tg__ZTV6dd1170__7ee71170[5]),  5,5},
  {&(_tg__ZTV5cc170__6dd1170__7ee71170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd1170__7ee71170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee71170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee71170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee71170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee71170[];
extern  VTBL_ENTRY _ZTV7ee71170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71170[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee711703fooEv,_ZTv0_n20_N7ee711703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711703fooEv,_ZThn24_N7ee711703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee711703barEv,_ZTv0_n16_N7ee711703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711703barEv,_ZThn24_N7ee711703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71170 = {  "ee71170", // class name
  bases_ee71170, 4,
  &(vtc_ee71170[0]), // expected_vtbl_contents
  &(vtt_ee71170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee71170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71170),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2170  : cc170 {
  int d;
  virtual void  foo(); // _ZN6dd21703fooEv
  ~dd2170(); // tgen
  dd2170(); // tgen
};
//SIG(-1 dd2170) C1{ BC2{ VBC3{ VBC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd2170 ::foo(){vfunc_called(this, "_ZN6dd21703fooEv");}
dd2170 ::~dd2170(){ note_dtor("dd2170", this);} // tgen
dd2170 ::dd2170(){ note_ctor("dd2170", this);} // tgen

static void Test_dd2170()
{
  extern Class_Descriptor cd_dd2170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd2170, buf);
    dd2170 *dp, &lv = *(dp=new (buf) dd2170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd2170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(28,20), "dd2170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(16,12), "dd2170");
    check_base_class_offset(lv, (cc170*), 0, "dd2170");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2170.d");
    test_class_info(&lv, &cd_dd2170);
    dp->~dd2170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2170(Test_dd2170, "dd2170", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd2170C1Ev();
extern void _ZN6dd2170D1Ev();
Name_Map name_map_dd2170[] = {
  NSPAIR(_ZN6dd2170C1Ev),
  NSPAIR(_ZN6dd2170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd2170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2170[];
extern void _ZN6dd21703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd2170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern VTBL_ENTRY _ZTV6dd2170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd2170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd2170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd2170[] = {
  {&(_ZTV6dd2170[4]),  4,12},
  {&(_tg__ZTV5cc170__6dd2170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd2170[5]),  5,7},
  {&(_ZTV6dd2170[10]),  10,12},
  {&(_tg__ZTV4bb70__6dd2170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd2170 = {  "dd2170", // class name
  bases_dd2170, 3,
  &(vtc_dd2170[0]), // expected_vtbl_contents
  &(vtt_dd2170[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd2170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2170),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02170  : dd2170 {
  int e;
  ~ee02170(); // tgen
  ee02170(); // tgen
};
//SIG(1 ee02170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee02170 ::~ee02170(){ note_dtor("ee02170", this);} // tgen
ee02170 ::ee02170(){ note_ctor("ee02170", this);} // tgen

static void Test_ee02170()
{
  extern Class_Descriptor cd_ee02170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee02170, buf);
    ee02170 *dp, &lv = *(dp=new (buf) ee02170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee02170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee02170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(24,16), "ee02170");
    check_base_class_offset(lv, (cc170*)(dd2170*), 0, "ee02170");
    check_base_class_offset(lv, (dd2170*), 0, "ee02170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02170.e");
    test_class_info(&lv, &cd_ee02170);
    dp->~ee02170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02170(Test_ee02170, "ee02170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee02170C1Ev();
extern void _ZN7ee02170D1Ev();
Name_Map name_map_ee02170[] = {
  NSPAIR(_ZN7ee02170C1Ev),
  NSPAIR(_ZN7ee02170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee02170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02170[];
extern void _ZN6dd21703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee02170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
  ABISELECT(-24,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee02170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern VTBL_ENTRY _ZTV7ee02170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee02170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee02170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee02170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee02170[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee02170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee02170[] = {
  {&(_ZTV7ee02170[4]),  4,12},
  {&(_tg__ZTV6dd2170__7ee02170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee02170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee02170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee02170[5]),  5,7},
  {&(_ZTV7ee02170[10]),  10,12},
  {&(_tg__ZTV4bb70__7ee02170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee02170[];
extern  VTBL_ENTRY _ZTV7ee02170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02170[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee02170 = {  "ee02170", // class name
  bases_ee02170, 4,
  &(vtc_ee02170[0]), // expected_vtbl_contents
  &(vtt_ee02170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee02170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12170  : virtual dd2170 {
  int e;
  ~ee12170(); // tgen
  ee12170(); // tgen
};
//SIG(1 ee12170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee12170 ::~ee12170(){ note_dtor("ee12170", this);} // tgen
ee12170 ::ee12170(){ note_ctor("ee12170", this);} // tgen

static void Test_ee12170()
{
  extern Class_Descriptor cd_ee12170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee12170, buf);
    ee12170 *dp, &lv = *(dp=new (buf) ee12170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee12170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee12170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(32,20), "ee12170");
    check_base_class_offset(lv, (cc170*)(dd2170*), ABISELECT(16,8), "ee12170");
    check_base_class_offset(lv, (dd2170*), ABISELECT(16,8), "ee12170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12170.e");
    test_class_info(&lv, &cd_ee12170);
    dp->~ee12170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12170(Test_ee12170, "ee12170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee12170C1Ev();
extern void _ZN7ee12170D1Ev();
Name_Map name_map_ee12170[] = {
  NSPAIR(_ZN7ee12170C1Ev),
  NSPAIR(_ZN7ee12170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee12170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12170[];
extern void _ZN6dd21703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee12170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12170[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee12170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern VTBL_ENTRY _ZTV7ee12170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee12170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee12170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee12170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee12170[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee12170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee12170[] = {
  {&(_ZTV7ee12170[5]),  5,18},
  {&(_ZTV7ee12170[10]),  10,18},
  {&(_ZTV7ee12170[16]),  16,18},
  {&(_tg__ZTV6dd2170__7ee12170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee12170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee12170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee12170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee12170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee12170[];
extern  VTBL_ENTRY _ZTV7ee12170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12170[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee12170 = {  "ee12170", // class name
  bases_ee12170, 4,
  &(vtc_ee12170[0]), // expected_vtbl_contents
  &(vtt_ee12170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee12170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22170  : dd2170 {
  int e;
  virtual void  foo(); // _ZN7ee221703fooEv
  ~ee22170(); // tgen
  ee22170(); // tgen
};
//SIG(1 ee22170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22170 ::foo(){vfunc_called(this, "_ZN7ee221703fooEv");}
ee22170 ::~ee22170(){ note_dtor("ee22170", this);} // tgen
ee22170 ::ee22170(){ note_ctor("ee22170", this);} // tgen

static void Test_ee22170()
{
  extern Class_Descriptor cd_ee22170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee22170, buf);
    ee22170 *dp, &lv = *(dp=new (buf) ee22170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee22170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee22170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(24,16), "ee22170");
    check_base_class_offset(lv, (cc170*)(dd2170*), 0, "ee22170");
    check_base_class_offset(lv, (dd2170*), 0, "ee22170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22170.e");
    test_class_info(&lv, &cd_ee22170);
    dp->~ee22170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22170(Test_ee22170, "ee22170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee22170C1Ev();
extern void _ZN7ee22170D1Ev();
Name_Map name_map_ee22170[] = {
  NSPAIR(_ZN7ee22170C1Ev),
  NSPAIR(_ZN7ee22170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee22170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22170[];
extern void _ZN7ee221703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee221703fooEv,_ZTv0_n20_N7ee221703fooEv)();
extern void ABISELECT(_ZThn24_N7ee221703fooEv,_ZThn16_N7ee221703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee22170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22170[0]),
  (VTBL_ENTRY)&_ZN7ee221703fooEv,
  ABISELECT(-24,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee22170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee221703fooEv,_ZTv0_n20_N7ee221703fooEv),
};
extern VTBL_ENTRY _ZTV7ee22170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee22170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee22170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee22170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee22170[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee22170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee22170[] = {
  {&(_ZTV7ee22170[4]),  4,12},
  {&(_tg__ZTV6dd2170__7ee22170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee22170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee22170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee22170[5]),  5,7},
  {&(_ZTV7ee22170[10]),  10,12},
  {&(_tg__ZTV4bb70__7ee22170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee22170[];
extern  VTBL_ENTRY _ZTV7ee22170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22170[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee221703fooEv,_ZTv0_n20_N7ee221703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee221703fooEv,_ZThn16_N7ee221703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee22170 = {  "ee22170", // class name
  bases_ee22170, 4,
  &(vtc_ee22170[0]), // expected_vtbl_contents
  &(vtt_ee22170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee22170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32170  : virtual dd2170 {
  int e;
  virtual void  foo(); // _ZN7ee321703fooEv
  ~ee32170(); // tgen
  ee32170(); // tgen
};
//SIG(1 ee32170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32170 ::foo(){vfunc_called(this, "_ZN7ee321703fooEv");}
ee32170 ::~ee32170(){ note_dtor("ee32170", this);} // tgen
ee32170 ::ee32170(){ note_ctor("ee32170", this);} // tgen

static void Test_ee32170()
{
  extern Class_Descriptor cd_ee32170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee32170, buf);
    ee32170 *dp, &lv = *(dp=new (buf) ee32170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee32170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee32170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(32,20), "ee32170");
    check_base_class_offset(lv, (cc170*)(dd2170*), ABISELECT(16,8), "ee32170");
    check_base_class_offset(lv, (dd2170*), ABISELECT(16,8), "ee32170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32170.e");
    test_class_info(&lv, &cd_ee32170);
    dp->~ee32170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32170(Test_ee32170, "ee32170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee32170C1Ev();
extern void _ZN7ee32170D1Ev();
Name_Map name_map_ee32170[] = {
  NSPAIR(_ZN7ee32170C1Ev),
  NSPAIR(_ZN7ee32170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee32170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32170[];
extern void _ZN7ee321703fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee321703fooEv,_ZTv0_n20_N7ee321703fooEv)();
extern void ABISELECT(_ZThn16_N7ee321703fooEv,_ZThn8_N7ee321703fooEv)() __attribute__((weak));
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee321703fooEv,_ZTv0_n20_N7ee321703fooEv)();
extern void ABISELECT(_ZThn32_N7ee321703fooEv,_ZThn20_N7ee321703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32170[0]),
  (VTBL_ENTRY)&_ZN7ee321703fooEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee321703fooEv,_ZTv0_n20_N7ee321703fooEv),
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee32170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee321703fooEv,_ZTv0_n20_N7ee321703fooEv),
};
extern VTBL_ENTRY _ZTV7ee32170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee32170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee32170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee32170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee32170[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee32170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee32170[] = {
  {&(_ZTV7ee32170[5]),  5,19},
  {&(_ZTV7ee32170[11]),  11,19},
  {&(_ZTV7ee32170[17]),  17,19},
  {&(_tg__ZTV6dd2170__7ee32170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee32170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee32170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee32170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee32170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee32170[];
extern  VTBL_ENTRY _ZTV7ee32170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32170[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee321703fooEv,_ZTv0_n20_N7ee321703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee321703fooEv,_ZThn20_N7ee321703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321703fooEv,_ZThn8_N7ee321703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32170 = {  "ee32170", // class name
  bases_ee32170, 4,
  &(vtc_ee32170[0]), // expected_vtbl_contents
  &(vtt_ee32170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee32170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32170),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42170  : dd2170 {
  int e;
  virtual void  bar(); // _ZN7ee421703barEv
  ~ee42170(); // tgen
  ee42170(); // tgen
};
//SIG(1 ee42170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42170 ::bar(){vfunc_called(this, "_ZN7ee421703barEv");}
ee42170 ::~ee42170(){ note_dtor("ee42170", this);} // tgen
ee42170 ::ee42170(){ note_ctor("ee42170", this);} // tgen

static void Test_ee42170()
{
  extern Class_Descriptor cd_ee42170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee42170, buf);
    ee42170 *dp, &lv = *(dp=new (buf) ee42170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee42170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee42170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(24,16), "ee42170");
    check_base_class_offset(lv, (cc170*)(dd2170*), 0, "ee42170");
    check_base_class_offset(lv, (dd2170*), 0, "ee42170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42170.e");
    test_class_info(&lv, &cd_ee42170);
    dp->~ee42170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42170(Test_ee42170, "ee42170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee42170C1Ev();
extern void _ZN7ee42170D1Ev();
Name_Map name_map_ee42170[] = {
  NSPAIR(_ZN7ee42170C1Ev),
  NSPAIR(_ZN7ee42170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee42170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42170[];
extern void _ZN6dd21703fooEv();
extern void _ZN7ee421703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee421703barEv,_ZTv0_n16_N7ee421703barEv)();
extern void ABISELECT(_ZThn24_N7ee421703barEv,_ZThn16_N7ee421703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee42170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
  (VTBL_ENTRY)&_ZN7ee421703barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee42170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee421703barEv,_ZTv0_n16_N7ee421703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern VTBL_ENTRY _ZTV7ee42170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee42170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee42170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee42170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee42170[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee42170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee42170[] = {
  {&(_ZTV7ee42170[4]),  4,13},
  {&(_tg__ZTV6dd2170__7ee42170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee42170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee42170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee42170[5]),  5,7},
  {&(_ZTV7ee42170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee42170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee42170[];
extern  VTBL_ENTRY _ZTV7ee42170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42170[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee421703barEv,_ZTv0_n16_N7ee421703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee421703barEv,_ZThn16_N7ee421703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee42170 = {  "ee42170", // class name
  bases_ee42170, 4,
  &(vtc_ee42170[0]), // expected_vtbl_contents
  &(vtt_ee42170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee42170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52170  : virtual dd2170 {
  int e;
  virtual void  bar(); // _ZN7ee521703barEv
  ~ee52170(); // tgen
  ee52170(); // tgen
};
//SIG(1 ee52170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52170 ::bar(){vfunc_called(this, "_ZN7ee521703barEv");}
ee52170 ::~ee52170(){ note_dtor("ee52170", this);} // tgen
ee52170 ::ee52170(){ note_ctor("ee52170", this);} // tgen

static void Test_ee52170()
{
  extern Class_Descriptor cd_ee52170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee52170, buf);
    ee52170 *dp, &lv = *(dp=new (buf) ee52170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee52170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee52170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(32,20), "ee52170");
    check_base_class_offset(lv, (cc170*)(dd2170*), ABISELECT(16,8), "ee52170");
    check_base_class_offset(lv, (dd2170*), ABISELECT(16,8), "ee52170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52170.e");
    test_class_info(&lv, &cd_ee52170);
    dp->~ee52170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52170(Test_ee52170, "ee52170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee52170C1Ev();
extern void _ZN7ee52170D1Ev();
Name_Map name_map_ee52170[] = {
  NSPAIR(_ZN7ee52170C1Ev),
  NSPAIR(_ZN7ee52170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee52170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52170[];
extern void _ZN7ee521703barEv();
extern void _ZN6dd21703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee521703barEv,_ZTv0_n16_N7ee521703barEv)();
extern void ABISELECT(_ZThn32_N7ee521703barEv,_ZThn20_N7ee521703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee52170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52170[0]),
  (VTBL_ENTRY)&_ZN7ee521703barEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee52170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee521703barEv,_ZTv0_n16_N7ee521703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern VTBL_ENTRY _ZTV7ee52170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee52170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee52170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee52170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee52170[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee52170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee52170[] = {
  {&(_ZTV7ee52170[5]),  5,19},
  {&(_ZTV7ee52170[11]),  11,19},
  {&(_ZTV7ee52170[17]),  17,19},
  {&(_tg__ZTV6dd2170__7ee52170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee52170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee52170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee52170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee52170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee52170[];
extern  VTBL_ENTRY _ZTV7ee52170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52170[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee521703barEv,_ZTv0_n16_N7ee521703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee521703barEv,_ZThn20_N7ee521703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52170 = {  "ee52170", // class name
  bases_ee52170, 4,
  &(vtc_ee52170[0]), // expected_vtbl_contents
  &(vtt_ee52170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee52170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52170),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62170  : dd2170 {
  int e;
  virtual void  foo(); // _ZN7ee621703fooEv
  virtual void  bar(); // _ZN7ee621703barEv
  ~ee62170(); // tgen
  ee62170(); // tgen
};
//SIG(1 ee62170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62170 ::foo(){vfunc_called(this, "_ZN7ee621703fooEv");}
void  ee62170 ::bar(){vfunc_called(this, "_ZN7ee621703barEv");}
ee62170 ::~ee62170(){ note_dtor("ee62170", this);} // tgen
ee62170 ::ee62170(){ note_ctor("ee62170", this);} // tgen

static void Test_ee62170()
{
  extern Class_Descriptor cd_ee62170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee62170, buf);
    ee62170 *dp, &lv = *(dp=new (buf) ee62170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee62170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee62170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(24,16), "ee62170");
    check_base_class_offset(lv, (cc170*)(dd2170*), 0, "ee62170");
    check_base_class_offset(lv, (dd2170*), 0, "ee62170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62170.e");
    test_class_info(&lv, &cd_ee62170);
    dp->~ee62170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62170(Test_ee62170, "ee62170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee62170C1Ev();
extern void _ZN7ee62170D1Ev();
Name_Map name_map_ee62170[] = {
  NSPAIR(_ZN7ee62170C1Ev),
  NSPAIR(_ZN7ee62170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee62170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62170[];
extern void _ZN7ee621703fooEv();
extern void _ZN7ee621703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee621703barEv,_ZTv0_n16_N7ee621703barEv)();
extern void ABISELECT(_ZThn24_N7ee621703barEv,_ZThn16_N7ee621703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee621703fooEv,_ZTv0_n20_N7ee621703fooEv)();
extern void ABISELECT(_ZThn24_N7ee621703fooEv,_ZThn16_N7ee621703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee62170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62170[0]),
  (VTBL_ENTRY)&_ZN7ee621703fooEv,
  (VTBL_ENTRY)&_ZN7ee621703barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee62170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee621703barEv,_ZTv0_n16_N7ee621703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee621703fooEv,_ZTv0_n20_N7ee621703fooEv),
};
extern VTBL_ENTRY _ZTV7ee62170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee62170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee62170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee62170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee62170[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee62170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee62170[] = {
  {&(_ZTV7ee62170[4]),  4,13},
  {&(_tg__ZTV6dd2170__7ee62170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee62170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee62170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee62170[5]),  5,7},
  {&(_ZTV7ee62170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee62170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee62170[];
extern  VTBL_ENTRY _ZTV7ee62170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62170[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21703fooEv,_ZThn16_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee621703fooEv,_ZTv0_n20_N7ee621703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621703fooEv,_ZThn16_N7ee621703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee621703barEv,_ZTv0_n16_N7ee621703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621703barEv,_ZThn16_N7ee621703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee62170 = {  "ee62170", // class name
  bases_ee62170, 4,
  &(vtc_ee62170[0]), // expected_vtbl_contents
  &(vtt_ee62170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee62170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72170  : virtual dd2170 {
  int e;
  virtual void  foo(); // _ZN7ee721703fooEv
  virtual void  bar(); // _ZN7ee721703barEv
  ~ee72170(); // tgen
  ee72170(); // tgen
};
//SIG(1 ee72170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72170 ::foo(){vfunc_called(this, "_ZN7ee721703fooEv");}
void  ee72170 ::bar(){vfunc_called(this, "_ZN7ee721703barEv");}
ee72170 ::~ee72170(){ note_dtor("ee72170", this);} // tgen
ee72170 ::ee72170(){ note_ctor("ee72170", this);} // tgen

static void Test_ee72170()
{
  extern Class_Descriptor cd_ee72170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee72170, buf);
    ee72170 *dp, &lv = *(dp=new (buf) ee72170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee72170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee72170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd2170*), ABISELECT(32,20), "ee72170");
    check_base_class_offset(lv, (cc170*)(dd2170*), ABISELECT(16,8), "ee72170");
    check_base_class_offset(lv, (dd2170*), ABISELECT(16,8), "ee72170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72170.e");
    test_class_info(&lv, &cd_ee72170);
    dp->~ee72170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72170(Test_ee72170, "ee72170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee72170C1Ev();
extern void _ZN7ee72170D1Ev();
Name_Map name_map_ee72170[] = {
  NSPAIR(_ZN7ee72170C1Ev),
  NSPAIR(_ZN7ee72170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd2170;
extern VTBL_ENTRY _ZTI6dd2170[];
extern  VTBL_ENTRY _ZTV6dd2170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2170[];
static Base_Class bases_ee72170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72170[];
extern void _ZN7ee721703fooEv();
extern void _ZN7ee721703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee721703fooEv,_ZTv0_n20_N7ee721703fooEv)();
extern void ABISELECT(_ZThn16_N7ee721703fooEv,_ZThn8_N7ee721703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee721703barEv,_ZTv0_n16_N7ee721703barEv)();
extern void ABISELECT(_ZThn32_N7ee721703barEv,_ZThn20_N7ee721703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee721703fooEv,_ZTv0_n20_N7ee721703fooEv)();
extern void ABISELECT(_ZThn32_N7ee721703fooEv,_ZThn20_N7ee721703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72170[0]),
  (VTBL_ENTRY)&_ZN7ee721703fooEv,
  (VTBL_ENTRY)&_ZN7ee721703barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee721703fooEv,_ZTv0_n20_N7ee721703fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee72170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721703barEv,_ZTv0_n16_N7ee721703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee721703fooEv,_ZTv0_n20_N7ee721703fooEv),
};
extern VTBL_ENTRY _ZTV7ee72170[];
extern void _ZN6dd21703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2170__7ee72170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN6dd21703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd2170__7ee72170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd2170__7ee72170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv)();
extern void ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd2170__7ee72170[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee72170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee72170[] = {
  {&(_ZTV7ee72170[5]),  5,20},
  {&(_ZTV7ee72170[12]),  12,20},
  {&(_ZTV7ee72170[18]),  18,20},
  {&(_tg__ZTV6dd2170__7ee72170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd2170__7ee72170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd2170__7ee72170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd2170__7ee72170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee72170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee72170[];
extern  VTBL_ENTRY _ZTV7ee72170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72170[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd21703fooEv,_ZTv0_n20_N6dd21703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21703fooEv,_ZThn12_N6dd21703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee721703barEv,_ZTv0_n16_N7ee721703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721703barEv,_ZThn20_N7ee721703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee721703fooEv,_ZTv0_n20_N7ee721703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721703fooEv,_ZThn20_N7ee721703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721703fooEv,_ZThn8_N7ee721703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72170 = {  "ee72170", // class name
  bases_ee72170, 4,
  &(vtc_ee72170[0]), // expected_vtbl_contents
  &(vtt_ee72170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee72170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72170),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3170  : virtual cc170 {
  int d;
  virtual void  foo(); // _ZN6dd31703fooEv
  ~dd3170(); // tgen
  dd3170(); // tgen
};
//SIG(-1 dd3170) C1{ VBC2{ VBC3{ VBC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd3170 ::foo(){vfunc_called(this, "_ZN6dd31703fooEv");}
dd3170 ::~dd3170(){ note_dtor("dd3170", this);} // tgen
dd3170 ::dd3170(){ note_ctor("dd3170", this);} // tgen

static void Test_dd3170()
{
  extern Class_Descriptor cd_dd3170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd3170, buf);
    dd3170 *dp, &lv = *(dp=new (buf) dd3170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd3170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,24), "dd3170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,16), "dd3170");
    check_base_class_offset(lv, (cc170*), ABISELECT(16,8), "dd3170");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3170.d");
    test_class_info(&lv, &cd_dd3170);
    dp->~dd3170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3170(Test_dd3170, "dd3170", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd3170C1Ev();
extern void _ZN6dd3170D1Ev();
Name_Map name_map_dd3170[] = {
  NSPAIR(_ZN6dd3170C1Ev),
  NSPAIR(_ZN6dd3170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd3170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3170[];
extern void _ZN6dd31703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
extern VTBL_ENTRY _ZTV6dd3170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd3170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd3170[] = {
  {&(_ZTV6dd3170[5]),  5,17},
  {&(_ZTV6dd3170[10]),  10,17},
  {&(_ZTV6dd3170[15]),  15,17},
  {&(_tg__ZTV5cc170__6dd3170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd3170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd3170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3170 = {  "dd3170", // class name
  bases_dd3170, 3,
  &(vtc_dd3170[0]), // expected_vtbl_contents
  &(vtt_dd3170[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd3170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3170),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03170  : dd3170 {
  int e;
  ~ee03170(); // tgen
  ee03170(); // tgen
};
//SIG(1 ee03170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee03170 ::~ee03170(){ note_dtor("ee03170", this);} // tgen
ee03170 ::ee03170(){ note_ctor("ee03170", this);} // tgen

static void Test_ee03170()
{
  extern Class_Descriptor cd_ee03170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee03170, buf);
    ee03170 *dp, &lv = *(dp=new (buf) ee03170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee03170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee03170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee03170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(16,12), "ee03170");
    check_base_class_offset(lv, (dd3170*), 0, "ee03170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03170.e");
    test_class_info(&lv, &cd_ee03170);
    dp->~ee03170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03170(Test_ee03170, "ee03170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee03170C1Ev();
extern void _ZN7ee03170D1Ev();
Name_Map name_map_ee03170[] = {
  NSPAIR(_ZN7ee03170C1Ev),
  NSPAIR(_ZN7ee03170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee03170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03170[];
extern void _ZN6dd31703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03170[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee03170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
extern VTBL_ENTRY _ZTV7ee03170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee03170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee03170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee03170[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee03170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee03170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee03170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee03170[] = {
  {&(_ZTV7ee03170[5]),  5,17},
  {&(_tg__ZTV6dd3170__7ee03170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee03170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee03170[5]),  5,7},
  {&(_ZTV7ee03170[10]),  10,17},
  {&(_ZTV7ee03170[15]),  15,17},
  {&(_tg__ZTV5cc170__7ee03170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee03170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee03170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee03170[];
extern  VTBL_ENTRY _ZTV7ee03170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03170[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03170 = {  "ee03170", // class name
  bases_ee03170, 4,
  &(vtc_ee03170[0]), // expected_vtbl_contents
  &(vtt_ee03170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee03170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13170  : virtual dd3170 {
  int e;
  ~ee13170(); // tgen
  ee13170(); // tgen
};
//SIG(1 ee13170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee13170 ::~ee13170(){ note_dtor("ee13170", this);} // tgen
ee13170 ::ee13170(){ note_ctor("ee13170", this);} // tgen

static void Test_ee13170()
{
  extern Class_Descriptor cd_ee13170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee13170, buf);
    ee13170 *dp, &lv = *(dp=new (buf) ee13170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee13170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee13170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee13170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(32,16), "ee13170");
    check_base_class_offset(lv, (dd3170*), ABISELECT(16,8), "ee13170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13170.e");
    test_class_info(&lv, &cd_ee13170);
    dp->~ee13170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13170(Test_ee13170, "ee13170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee13170C1Ev();
extern void _ZN7ee13170D1Ev();
Name_Map name_map_ee13170[] = {
  NSPAIR(_ZN7ee13170C1Ev),
  NSPAIR(_ZN7ee13170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee13170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13170[];
extern void _ZN6dd31703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13170[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13170[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee13170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
extern VTBL_ENTRY _ZTV7ee13170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee13170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee13170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee13170[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee13170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee13170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee13170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee13170[] = {
  {&(_ZTV7ee13170[6]),  6,24},
  {&(_ZTV7ee13170[12]),  12,24},
  {&(_ZTV7ee13170[17]),  17,24},
  {&(_ZTV7ee13170[22]),  22,24},
  {&(_tg__ZTV6dd3170__7ee13170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee13170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee13170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee13170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee13170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee13170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee13170[];
extern  VTBL_ENTRY _ZTV7ee13170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13170[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13170 = {  "ee13170", // class name
  bases_ee13170, 4,
  &(vtc_ee13170[0]), // expected_vtbl_contents
  &(vtt_ee13170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee13170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13170),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23170  : dd3170 {
  int e;
  virtual void  foo(); // _ZN7ee231703fooEv
  ~ee23170(); // tgen
  ee23170(); // tgen
};
//SIG(1 ee23170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23170 ::foo(){vfunc_called(this, "_ZN7ee231703fooEv");}
ee23170 ::~ee23170(){ note_dtor("ee23170", this);} // tgen
ee23170 ::ee23170(){ note_ctor("ee23170", this);} // tgen

static void Test_ee23170()
{
  extern Class_Descriptor cd_ee23170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee23170, buf);
    ee23170 *dp, &lv = *(dp=new (buf) ee23170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee23170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee23170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee23170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(16,12), "ee23170");
    check_base_class_offset(lv, (dd3170*), 0, "ee23170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23170.e");
    test_class_info(&lv, &cd_ee23170);
    dp->~ee23170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23170(Test_ee23170, "ee23170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee23170C1Ev();
extern void _ZN7ee23170D1Ev();
Name_Map name_map_ee23170[] = {
  NSPAIR(_ZN7ee23170C1Ev),
  NSPAIR(_ZN7ee23170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee23170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23170[];
extern void _ZN7ee231703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee231703fooEv,_ZTv0_n20_N7ee231703fooEv)();
extern void ABISELECT(_ZThn32_N7ee231703fooEv,_ZThn20_N7ee231703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23170[0]),
  (VTBL_ENTRY)&_ZN7ee231703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23170[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee23170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee231703fooEv,_ZTv0_n20_N7ee231703fooEv),
};
extern VTBL_ENTRY _ZTV7ee23170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee23170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee23170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee23170[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee23170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee23170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee23170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee23170[] = {
  {&(_ZTV7ee23170[5]),  5,17},
  {&(_tg__ZTV6dd3170__7ee23170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee23170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee23170[5]),  5,7},
  {&(_ZTV7ee23170[10]),  10,17},
  {&(_ZTV7ee23170[15]),  15,17},
  {&(_tg__ZTV5cc170__7ee23170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee23170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee23170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee23170[];
extern  VTBL_ENTRY _ZTV7ee23170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23170[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee231703fooEv,_ZTv0_n20_N7ee231703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee231703fooEv,_ZThn20_N7ee231703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23170 = {  "ee23170", // class name
  bases_ee23170, 4,
  &(vtc_ee23170[0]), // expected_vtbl_contents
  &(vtt_ee23170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee23170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33170  : virtual dd3170 {
  int e;
  virtual void  foo(); // _ZN7ee331703fooEv
  ~ee33170(); // tgen
  ee33170(); // tgen
};
//SIG(1 ee33170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33170 ::foo(){vfunc_called(this, "_ZN7ee331703fooEv");}
ee33170 ::~ee33170(){ note_dtor("ee33170", this);} // tgen
ee33170 ::ee33170(){ note_ctor("ee33170", this);} // tgen

static void Test_ee33170()
{
  extern Class_Descriptor cd_ee33170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee33170, buf);
    ee33170 *dp, &lv = *(dp=new (buf) ee33170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee33170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee33170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee33170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(32,16), "ee33170");
    check_base_class_offset(lv, (dd3170*), ABISELECT(16,8), "ee33170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33170.e");
    test_class_info(&lv, &cd_ee33170);
    dp->~ee33170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33170(Test_ee33170, "ee33170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee33170C1Ev();
extern void _ZN7ee33170D1Ev();
Name_Map name_map_ee33170[] = {
  NSPAIR(_ZN7ee33170C1Ev),
  NSPAIR(_ZN7ee33170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee33170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33170[];
extern void _ZN7ee331703fooEv();
extern void ABISELECT(_ZTv0_n48_N7ee331703fooEv,_ZTv0_n24_N7ee331703fooEv)();
extern void ABISELECT(_ZThn16_N7ee331703fooEv,_ZThn8_N7ee331703fooEv)() __attribute__((weak));
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee331703fooEv,_ZTv0_n20_N7ee331703fooEv)();
extern void ABISELECT(_ZThn48_N7ee331703fooEv,_ZThn24_N7ee331703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33170[0]),
  (VTBL_ENTRY)&_ZN7ee331703fooEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee331703fooEv,_ZTv0_n24_N7ee331703fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33170[0]),
  ABISELECT(-48,-24),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee33170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee331703fooEv,_ZTv0_n20_N7ee331703fooEv),
};
extern VTBL_ENTRY _ZTV7ee33170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee33170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee33170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee33170[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee33170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee33170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee33170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee33170[] = {
  {&(_ZTV7ee33170[6]),  6,25},
  {&(_ZTV7ee33170[13]),  13,25},
  {&(_ZTV7ee33170[18]),  18,25},
  {&(_ZTV7ee33170[23]),  23,25},
  {&(_tg__ZTV6dd3170__7ee33170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee33170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee33170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee33170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee33170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee33170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee33170[];
extern  VTBL_ENTRY _ZTV7ee33170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33170[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee331703fooEv,_ZTv0_n20_N7ee331703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee331703fooEv,_ZThn24_N7ee331703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee331703fooEv,_ZTv0_n24_N7ee331703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331703fooEv,_ZThn8_N7ee331703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33170 = {  "ee33170", // class name
  bases_ee33170, 4,
  &(vtc_ee33170[0]), // expected_vtbl_contents
  &(vtt_ee33170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee33170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33170),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43170  : dd3170 {
  int e;
  virtual void  bar(); // _ZN7ee431703barEv
  ~ee43170(); // tgen
  ee43170(); // tgen
};
//SIG(1 ee43170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43170 ::bar(){vfunc_called(this, "_ZN7ee431703barEv");}
ee43170 ::~ee43170(){ note_dtor("ee43170", this);} // tgen
ee43170 ::ee43170(){ note_ctor("ee43170", this);} // tgen

static void Test_ee43170()
{
  extern Class_Descriptor cd_ee43170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee43170, buf);
    ee43170 *dp, &lv = *(dp=new (buf) ee43170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee43170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee43170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee43170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(16,12), "ee43170");
    check_base_class_offset(lv, (dd3170*), 0, "ee43170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43170.e");
    test_class_info(&lv, &cd_ee43170);
    dp->~ee43170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43170(Test_ee43170, "ee43170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee43170C1Ev();
extern void _ZN7ee43170D1Ev();
Name_Map name_map_ee43170[] = {
  NSPAIR(_ZN7ee43170C1Ev),
  NSPAIR(_ZN7ee43170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee43170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43170[];
extern void _ZN6dd31703fooEv();
extern void _ZN7ee431703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee431703barEv,_ZTv0_n16_N7ee431703barEv)();
extern void ABISELECT(_ZThn32_N7ee431703barEv,_ZThn20_N7ee431703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
  (VTBL_ENTRY)&_ZN7ee431703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee43170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee431703barEv,_ZTv0_n16_N7ee431703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
extern VTBL_ENTRY _ZTV7ee43170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee43170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee43170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee43170[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee43170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee43170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee43170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee43170[] = {
  {&(_ZTV7ee43170[5]),  5,18},
  {&(_tg__ZTV6dd3170__7ee43170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee43170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee43170[5]),  5,7},
  {&(_ZTV7ee43170[11]),  11,18},
  {&(_ZTV7ee43170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee43170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee43170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee43170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee43170[];
extern  VTBL_ENTRY _ZTV7ee43170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43170[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee431703barEv,_ZTv0_n16_N7ee431703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee431703barEv,_ZThn20_N7ee431703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43170 = {  "ee43170", // class name
  bases_ee43170, 4,
  &(vtc_ee43170[0]), // expected_vtbl_contents
  &(vtt_ee43170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee43170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53170  : virtual dd3170 {
  int e;
  virtual void  bar(); // _ZN7ee531703barEv
  ~ee53170(); // tgen
  ee53170(); // tgen
};
//SIG(1 ee53170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53170 ::bar(){vfunc_called(this, "_ZN7ee531703barEv");}
ee53170 ::~ee53170(){ note_dtor("ee53170", this);} // tgen
ee53170 ::ee53170(){ note_ctor("ee53170", this);} // tgen

static void Test_ee53170()
{
  extern Class_Descriptor cd_ee53170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee53170, buf);
    ee53170 *dp, &lv = *(dp=new (buf) ee53170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee53170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee53170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee53170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(32,16), "ee53170");
    check_base_class_offset(lv, (dd3170*), ABISELECT(16,8), "ee53170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53170.e");
    test_class_info(&lv, &cd_ee53170);
    dp->~ee53170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53170(Test_ee53170, "ee53170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee53170C1Ev();
extern void _ZN7ee53170D1Ev();
Name_Map name_map_ee53170[] = {
  NSPAIR(_ZN7ee53170C1Ev),
  NSPAIR(_ZN7ee53170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee53170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53170[];
extern void _ZN7ee531703barEv();
extern void _ZN6dd31703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee531703barEv,_ZTv0_n16_N7ee531703barEv)();
extern void ABISELECT(_ZThn48_N7ee531703barEv,_ZThn24_N7ee531703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53170[0]),
  (VTBL_ENTRY)&_ZN7ee531703barEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53170[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee53170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee531703barEv,_ZTv0_n16_N7ee531703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
extern VTBL_ENTRY _ZTV7ee53170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee53170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee53170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee53170[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee53170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee53170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee53170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee53170[] = {
  {&(_ZTV7ee53170[6]),  6,25},
  {&(_ZTV7ee53170[13]),  13,25},
  {&(_ZTV7ee53170[18]),  18,25},
  {&(_ZTV7ee53170[23]),  23,25},
  {&(_tg__ZTV6dd3170__7ee53170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee53170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee53170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee53170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee53170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee53170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee53170[];
extern  VTBL_ENTRY _ZTV7ee53170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53170[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee531703barEv,_ZTv0_n16_N7ee531703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee531703barEv,_ZThn24_N7ee531703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53170 = {  "ee53170", // class name
  bases_ee53170, 4,
  &(vtc_ee53170[0]), // expected_vtbl_contents
  &(vtt_ee53170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee53170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53170),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63170  : dd3170 {
  int e;
  virtual void  foo(); // _ZN7ee631703fooEv
  virtual void  bar(); // _ZN7ee631703barEv
  ~ee63170(); // tgen
  ee63170(); // tgen
};
//SIG(1 ee63170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63170 ::foo(){vfunc_called(this, "_ZN7ee631703fooEv");}
void  ee63170 ::bar(){vfunc_called(this, "_ZN7ee631703barEv");}
ee63170 ::~ee63170(){ note_dtor("ee63170", this);} // tgen
ee63170 ::ee63170(){ note_ctor("ee63170", this);} // tgen

static void Test_ee63170()
{
  extern Class_Descriptor cd_ee63170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee63170, buf);
    ee63170 *dp, &lv = *(dp=new (buf) ee63170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee63170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee63170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee63170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(16,12), "ee63170");
    check_base_class_offset(lv, (dd3170*), 0, "ee63170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63170.e");
    test_class_info(&lv, &cd_ee63170);
    dp->~ee63170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63170(Test_ee63170, "ee63170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee63170C1Ev();
extern void _ZN7ee63170D1Ev();
Name_Map name_map_ee63170[] = {
  NSPAIR(_ZN7ee63170C1Ev),
  NSPAIR(_ZN7ee63170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee63170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63170[];
extern void _ZN7ee631703fooEv();
extern void _ZN7ee631703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee631703barEv,_ZTv0_n16_N7ee631703barEv)();
extern void ABISELECT(_ZThn32_N7ee631703barEv,_ZThn20_N7ee631703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee631703fooEv,_ZTv0_n20_N7ee631703fooEv)();
extern void ABISELECT(_ZThn32_N7ee631703fooEv,_ZThn20_N7ee631703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63170[0]),
  (VTBL_ENTRY)&_ZN7ee631703fooEv,
  (VTBL_ENTRY)&_ZN7ee631703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee63170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee631703barEv,_ZTv0_n16_N7ee631703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee631703fooEv,_ZTv0_n20_N7ee631703fooEv),
};
extern VTBL_ENTRY _ZTV7ee63170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee63170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee63170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee63170[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee63170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee63170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee63170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee63170[] = {
  {&(_ZTV7ee63170[5]),  5,18},
  {&(_tg__ZTV6dd3170__7ee63170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee63170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee63170[5]),  5,7},
  {&(_ZTV7ee63170[11]),  11,18},
  {&(_ZTV7ee63170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee63170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee63170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee63170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee63170[];
extern  VTBL_ENTRY _ZTV7ee63170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63170[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn20_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee631703fooEv,_ZTv0_n20_N7ee631703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631703fooEv,_ZThn20_N7ee631703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee631703barEv,_ZTv0_n16_N7ee631703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631703barEv,_ZThn20_N7ee631703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63170 = {  "ee63170", // class name
  bases_ee63170, 4,
  &(vtc_ee63170[0]), // expected_vtbl_contents
  &(vtt_ee63170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee63170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73170  : virtual dd3170 {
  int e;
  virtual void  foo(); // _ZN7ee731703fooEv
  virtual void  bar(); // _ZN7ee731703barEv
  ~ee73170(); // tgen
  ee73170(); // tgen
};
//SIG(1 ee73170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73170 ::foo(){vfunc_called(this, "_ZN7ee731703fooEv");}
void  ee73170 ::bar(){vfunc_called(this, "_ZN7ee731703barEv");}
ee73170 ::~ee73170(){ note_dtor("ee73170", this);} // tgen
ee73170 ::ee73170(){ note_ctor("ee73170", this);} // tgen

static void Test_ee73170()
{
  extern Class_Descriptor cd_ee73170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee73170, buf);
    ee73170 *dp, &lv = *(dp=new (buf) ee73170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee73170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee73170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee73170");
    check_base_class_offset(lv, (cc170*)(dd3170*), ABISELECT(32,16), "ee73170");
    check_base_class_offset(lv, (dd3170*), ABISELECT(16,8), "ee73170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73170.e");
    test_class_info(&lv, &cd_ee73170);
    dp->~ee73170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73170(Test_ee73170, "ee73170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee73170C1Ev();
extern void _ZN7ee73170D1Ev();
Name_Map name_map_ee73170[] = {
  NSPAIR(_ZN7ee73170C1Ev),
  NSPAIR(_ZN7ee73170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd3170;
extern VTBL_ENTRY _ZTI6dd3170[];
extern  VTBL_ENTRY _ZTV6dd3170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3170[];
static Base_Class bases_ee73170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3170,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73170[];
extern void _ZN7ee731703fooEv();
extern void _ZN7ee731703barEv();
extern void ABISELECT(_ZTv0_n48_N7ee731703fooEv,_ZTv0_n24_N7ee731703fooEv)();
extern void ABISELECT(_ZThn16_N7ee731703fooEv,_ZThn8_N7ee731703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee731703barEv,_ZTv0_n16_N7ee731703barEv)();
extern void ABISELECT(_ZThn48_N7ee731703barEv,_ZThn24_N7ee731703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee731703fooEv,_ZTv0_n20_N7ee731703fooEv)();
extern void ABISELECT(_ZThn48_N7ee731703fooEv,_ZThn24_N7ee731703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73170[0]),
  (VTBL_ENTRY)&_ZN7ee731703fooEv,
  (VTBL_ENTRY)&_ZN7ee731703barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee731703fooEv,_ZTv0_n24_N7ee731703fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73170[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee73170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee731703barEv,_ZTv0_n16_N7ee731703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee731703fooEv,_ZTv0_n20_N7ee731703fooEv),
};
extern VTBL_ENTRY _ZTV7ee73170[];
extern void _ZN6dd31703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3170__7ee73170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN6dd31703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd3170__7ee73170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
};
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv)();
extern void ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd3170__7ee73170[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee73170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee73170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee73170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee73170[] = {
  {&(_ZTV7ee73170[6]),  6,26},
  {&(_ZTV7ee73170[14]),  14,26},
  {&(_ZTV7ee73170[19]),  19,26},
  {&(_ZTV7ee73170[24]),  24,26},
  {&(_tg__ZTV6dd3170__7ee73170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd3170__7ee73170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd3170__7ee73170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee73170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee73170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee73170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee73170[];
extern  VTBL_ENTRY _ZTV7ee73170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73170[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd31703fooEv,_ZTv0_n20_N6dd31703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31703fooEv,_ZThn16_N6dd31703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee731703fooEv,_ZTv0_n20_N7ee731703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731703fooEv,_ZThn24_N7ee731703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee731703barEv,_ZTv0_n16_N7ee731703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731703barEv,_ZThn24_N7ee731703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee731703fooEv,_ZTv0_n24_N7ee731703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731703fooEv,_ZThn8_N7ee731703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73170 = {  "ee73170", // class name
  bases_ee73170, 4,
  &(vtc_ee73170[0]), // expected_vtbl_contents
  &(vtt_ee73170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee73170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73170),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4170  : cc170 {
  int d;
  virtual void  bar(); // _ZN6dd41703barEv
  ~dd4170(); // tgen
  dd4170(); // tgen
};
//SIG(-1 dd4170) C1{ BC2{ VBC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd4170 ::bar(){vfunc_called(this, "_ZN6dd41703barEv");}
dd4170 ::~dd4170(){ note_dtor("dd4170", this);} // tgen
dd4170 ::dd4170(){ note_ctor("dd4170", this);} // tgen

static void Test_dd4170()
{
  extern Class_Descriptor cd_dd4170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd4170, buf);
    dd4170 *dp, &lv = *(dp=new (buf) dd4170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd4170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(28,20), "dd4170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(16,12), "dd4170");
    check_base_class_offset(lv, (cc170*), 0, "dd4170");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4170.d");
    test_class_info(&lv, &cd_dd4170);
    dp->~dd4170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4170(Test_dd4170, "dd4170", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd4170C1Ev();
extern void _ZN6dd4170D1Ev();
Name_Map name_map_dd4170[] = {
  NSPAIR(_ZN6dd4170C1Ev),
  NSPAIR(_ZN6dd4170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd4170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4170[];
extern void _ZN6dd41703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd4170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd4170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd4170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd4170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd4170[] = {
  {&(_ZTV6dd4170[4]),  4,12},
  {&(_tg__ZTV5cc170__6dd4170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd4170[5]),  5,7},
  {&(_ZTV6dd4170[10]),  10,12},
  {&(_tg__ZTV4bb70__6dd4170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd4170 = {  "dd4170", // class name
  bases_dd4170, 3,
  &(vtc_dd4170[0]), // expected_vtbl_contents
  &(vtt_dd4170[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd4170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4170),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04170  : dd4170 {
  int e;
  ~ee04170(); // tgen
  ee04170(); // tgen
};
//SIG(1 ee04170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee04170 ::~ee04170(){ note_dtor("ee04170", this);} // tgen
ee04170 ::ee04170(){ note_ctor("ee04170", this);} // tgen

static void Test_ee04170()
{
  extern Class_Descriptor cd_ee04170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee04170, buf);
    ee04170 *dp, &lv = *(dp=new (buf) ee04170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee04170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee04170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(24,16), "ee04170");
    check_base_class_offset(lv, (cc170*)(dd4170*), 0, "ee04170");
    check_base_class_offset(lv, (dd4170*), 0, "ee04170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04170.e");
    test_class_info(&lv, &cd_ee04170);
    dp->~ee04170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04170(Test_ee04170, "ee04170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee04170C1Ev();
extern void _ZN7ee04170D1Ev();
Name_Map name_map_ee04170[] = {
  NSPAIR(_ZN7ee04170C1Ev),
  NSPAIR(_ZN7ee04170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee04170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04170[];
extern void _ZN6dd41703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee04170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
  0,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee04170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee04170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee04170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee04170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee04170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee04170[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee04170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee04170[] = {
  {&(_ZTV7ee04170[4]),  4,12},
  {&(_tg__ZTV6dd4170__7ee04170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee04170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee04170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee04170[5]),  5,7},
  {&(_ZTV7ee04170[10]),  10,12},
  {&(_tg__ZTV4bb70__7ee04170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee04170[];
extern  VTBL_ENTRY _ZTV7ee04170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04170[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee04170 = {  "ee04170", // class name
  bases_ee04170, 4,
  &(vtc_ee04170[0]), // expected_vtbl_contents
  &(vtt_ee04170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee04170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14170  : virtual dd4170 {
  int e;
  ~ee14170(); // tgen
  ee14170(); // tgen
};
//SIG(1 ee14170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee14170 ::~ee14170(){ note_dtor("ee14170", this);} // tgen
ee14170 ::ee14170(){ note_ctor("ee14170", this);} // tgen

static void Test_ee14170()
{
  extern Class_Descriptor cd_ee14170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee14170, buf);
    ee14170 *dp, &lv = *(dp=new (buf) ee14170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee14170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee14170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(32,20), "ee14170");
    check_base_class_offset(lv, (cc170*)(dd4170*), ABISELECT(16,8), "ee14170");
    check_base_class_offset(lv, (dd4170*), ABISELECT(16,8), "ee14170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14170.e");
    test_class_info(&lv, &cd_ee14170);
    dp->~ee14170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14170(Test_ee14170, "ee14170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee14170C1Ev();
extern void _ZN7ee14170D1Ev();
Name_Map name_map_ee14170[] = {
  NSPAIR(_ZN7ee14170C1Ev),
  NSPAIR(_ZN7ee14170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee14170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14170[];
extern void _ZN6dd41703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee14170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14170[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee14170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee14170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee14170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee14170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee14170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee14170[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee14170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee14170[] = {
  {&(_ZTV7ee14170[5]),  5,18},
  {&(_ZTV7ee14170[10]),  10,18},
  {&(_ZTV7ee14170[16]),  16,18},
  {&(_tg__ZTV6dd4170__7ee14170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee14170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee14170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee14170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee14170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee14170[];
extern  VTBL_ENTRY _ZTV7ee14170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14170[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee14170 = {  "ee14170", // class name
  bases_ee14170, 4,
  &(vtc_ee14170[0]), // expected_vtbl_contents
  &(vtt_ee14170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee14170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24170  : dd4170 {
  int e;
  virtual void  foo(); // _ZN7ee241703fooEv
  ~ee24170(); // tgen
  ee24170(); // tgen
};
//SIG(1 ee24170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24170 ::foo(){vfunc_called(this, "_ZN7ee241703fooEv");}
ee24170 ::~ee24170(){ note_dtor("ee24170", this);} // tgen
ee24170 ::ee24170(){ note_ctor("ee24170", this);} // tgen

static void Test_ee24170()
{
  extern Class_Descriptor cd_ee24170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee24170, buf);
    ee24170 *dp, &lv = *(dp=new (buf) ee24170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee24170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee24170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(24,16), "ee24170");
    check_base_class_offset(lv, (cc170*)(dd4170*), 0, "ee24170");
    check_base_class_offset(lv, (dd4170*), 0, "ee24170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24170.e");
    test_class_info(&lv, &cd_ee24170);
    dp->~ee24170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24170(Test_ee24170, "ee24170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee24170C1Ev();
extern void _ZN7ee24170D1Ev();
Name_Map name_map_ee24170[] = {
  NSPAIR(_ZN7ee24170C1Ev),
  NSPAIR(_ZN7ee24170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee24170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24170[];
extern void _ZN6dd41703barEv();
extern void _ZN7ee241703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee241703fooEv,_ZTv0_n20_N7ee241703fooEv)();
extern void ABISELECT(_ZThn24_N7ee241703fooEv,_ZThn16_N7ee241703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee24170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
  (VTBL_ENTRY)&_ZN7ee241703fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee24170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee241703fooEv,_ZTv0_n20_N7ee241703fooEv),
};
extern VTBL_ENTRY _ZTV7ee24170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee24170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee24170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee24170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee24170[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee24170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee24170[] = {
  {&(_ZTV7ee24170[4]),  4,13},
  {&(_tg__ZTV6dd4170__7ee24170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee24170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee24170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee24170[5]),  5,7},
  {&(_ZTV7ee24170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee24170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee24170[];
extern  VTBL_ENTRY _ZTV7ee24170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24170[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee241703fooEv,_ZTv0_n20_N7ee241703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee241703fooEv,_ZThn16_N7ee241703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee24170 = {  "ee24170", // class name
  bases_ee24170, 4,
  &(vtc_ee24170[0]), // expected_vtbl_contents
  &(vtt_ee24170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee24170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34170  : virtual dd4170 {
  int e;
  virtual void  foo(); // _ZN7ee341703fooEv
  ~ee34170(); // tgen
  ee34170(); // tgen
};
//SIG(1 ee34170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34170 ::foo(){vfunc_called(this, "_ZN7ee341703fooEv");}
ee34170 ::~ee34170(){ note_dtor("ee34170", this);} // tgen
ee34170 ::ee34170(){ note_ctor("ee34170", this);} // tgen

static void Test_ee34170()
{
  extern Class_Descriptor cd_ee34170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee34170, buf);
    ee34170 *dp, &lv = *(dp=new (buf) ee34170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee34170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee34170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(32,20), "ee34170");
    check_base_class_offset(lv, (cc170*)(dd4170*), ABISELECT(16,8), "ee34170");
    check_base_class_offset(lv, (dd4170*), ABISELECT(16,8), "ee34170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34170.e");
    test_class_info(&lv, &cd_ee34170);
    dp->~ee34170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34170(Test_ee34170, "ee34170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee34170C1Ev();
extern void _ZN7ee34170D1Ev();
Name_Map name_map_ee34170[] = {
  NSPAIR(_ZN7ee34170C1Ev),
  NSPAIR(_ZN7ee34170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee34170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34170[];
extern void _ZN7ee341703fooEv();
extern void _ZN6dd41703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee341703fooEv,_ZTv0_n20_N7ee341703fooEv)();
extern void ABISELECT(_ZThn32_N7ee341703fooEv,_ZThn20_N7ee341703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34170[0]),
  (VTBL_ENTRY)&_ZN7ee341703fooEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
  ABISELECT(-32,-20),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee34170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee341703fooEv,_ZTv0_n20_N7ee341703fooEv),
};
extern VTBL_ENTRY _ZTV7ee34170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee34170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee34170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee34170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee34170[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee34170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee34170[] = {
  {&(_ZTV7ee34170[5]),  5,19},
  {&(_ZTV7ee34170[11]),  11,19},
  {&(_ZTV7ee34170[17]),  17,19},
  {&(_tg__ZTV6dd4170__7ee34170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee34170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee34170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee34170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee34170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee34170[];
extern  VTBL_ENTRY _ZTV7ee34170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34170[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee341703fooEv,_ZTv0_n20_N7ee341703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee341703fooEv,_ZThn20_N7ee341703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34170 = {  "ee34170", // class name
  bases_ee34170, 4,
  &(vtc_ee34170[0]), // expected_vtbl_contents
  &(vtt_ee34170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee34170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34170),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44170  : dd4170 {
  int e;
  virtual void  bar(); // _ZN7ee441703barEv
  ~ee44170(); // tgen
  ee44170(); // tgen
};
//SIG(1 ee44170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44170 ::bar(){vfunc_called(this, "_ZN7ee441703barEv");}
ee44170 ::~ee44170(){ note_dtor("ee44170", this);} // tgen
ee44170 ::ee44170(){ note_ctor("ee44170", this);} // tgen

static void Test_ee44170()
{
  extern Class_Descriptor cd_ee44170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee44170, buf);
    ee44170 *dp, &lv = *(dp=new (buf) ee44170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee44170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee44170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(24,16), "ee44170");
    check_base_class_offset(lv, (cc170*)(dd4170*), 0, "ee44170");
    check_base_class_offset(lv, (dd4170*), 0, "ee44170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44170.e");
    test_class_info(&lv, &cd_ee44170);
    dp->~ee44170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44170(Test_ee44170, "ee44170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee44170C1Ev();
extern void _ZN7ee44170D1Ev();
Name_Map name_map_ee44170[] = {
  NSPAIR(_ZN7ee44170C1Ev),
  NSPAIR(_ZN7ee44170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee44170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44170[];
extern void _ZN7ee441703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee441703barEv,_ZTv0_n16_N7ee441703barEv)();
extern void ABISELECT(_ZThn24_N7ee441703barEv,_ZThn16_N7ee441703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee44170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44170[0]),
  (VTBL_ENTRY)&_ZN7ee441703barEv,
  0,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee44170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee441703barEv,_ZTv0_n16_N7ee441703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee44170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee44170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee44170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee44170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee44170[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee44170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee44170[] = {
  {&(_ZTV7ee44170[4]),  4,12},
  {&(_tg__ZTV6dd4170__7ee44170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee44170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee44170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee44170[5]),  5,7},
  {&(_ZTV7ee44170[10]),  10,12},
  {&(_tg__ZTV4bb70__7ee44170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee44170[];
extern  VTBL_ENTRY _ZTV7ee44170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44170[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee441703barEv,_ZTv0_n16_N7ee441703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee441703barEv,_ZThn16_N7ee441703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee44170 = {  "ee44170", // class name
  bases_ee44170, 4,
  &(vtc_ee44170[0]), // expected_vtbl_contents
  &(vtt_ee44170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee44170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44170),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54170  : virtual dd4170 {
  int e;
  virtual void  bar(); // _ZN7ee541703barEv
  ~ee54170(); // tgen
  ee54170(); // tgen
};
//SIG(1 ee54170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54170 ::bar(){vfunc_called(this, "_ZN7ee541703barEv");}
ee54170 ::~ee54170(){ note_dtor("ee54170", this);} // tgen
ee54170 ::ee54170(){ note_ctor("ee54170", this);} // tgen

static void Test_ee54170()
{
  extern Class_Descriptor cd_ee54170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee54170, buf);
    ee54170 *dp, &lv = *(dp=new (buf) ee54170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee54170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee54170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(32,20), "ee54170");
    check_base_class_offset(lv, (cc170*)(dd4170*), ABISELECT(16,8), "ee54170");
    check_base_class_offset(lv, (dd4170*), ABISELECT(16,8), "ee54170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54170.e");
    test_class_info(&lv, &cd_ee54170);
    dp->~ee54170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54170(Test_ee54170, "ee54170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee54170C1Ev();
extern void _ZN7ee54170D1Ev();
Name_Map name_map_ee54170[] = {
  NSPAIR(_ZN7ee54170C1Ev),
  NSPAIR(_ZN7ee54170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee54170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54170[];
extern void _ZN7ee541703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee541703barEv,_ZTv0_n20_N7ee541703barEv)();
extern void ABISELECT(_ZThn16_N7ee541703barEv,_ZThn8_N7ee541703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee541703barEv,_ZTv0_n16_N7ee541703barEv)();
extern void ABISELECT(_ZThn32_N7ee541703barEv,_ZThn20_N7ee541703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee54170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54170[0]),
  (VTBL_ENTRY)&_ZN7ee541703barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee541703barEv,_ZTv0_n20_N7ee541703barEv),
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee54170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee541703barEv,_ZTv0_n16_N7ee541703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee54170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee54170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee54170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee54170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee54170[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee54170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee54170[] = {
  {&(_ZTV7ee54170[5]),  5,19},
  {&(_ZTV7ee54170[11]),  11,19},
  {&(_ZTV7ee54170[17]),  17,19},
  {&(_tg__ZTV6dd4170__7ee54170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee54170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee54170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee54170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee54170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee54170[];
extern  VTBL_ENTRY _ZTV7ee54170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54170[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee541703barEv,_ZTv0_n16_N7ee541703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee541703barEv,_ZThn20_N7ee541703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee541703barEv,_ZTv0_n20_N7ee541703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541703barEv,_ZThn8_N7ee541703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54170 = {  "ee54170", // class name
  bases_ee54170, 4,
  &(vtc_ee54170[0]), // expected_vtbl_contents
  &(vtt_ee54170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee54170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54170),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64170  : dd4170 {
  int e;
  virtual void  foo(); // _ZN7ee641703fooEv
  virtual void  bar(); // _ZN7ee641703barEv
  ~ee64170(); // tgen
  ee64170(); // tgen
};
//SIG(1 ee64170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64170 ::foo(){vfunc_called(this, "_ZN7ee641703fooEv");}
void  ee64170 ::bar(){vfunc_called(this, "_ZN7ee641703barEv");}
ee64170 ::~ee64170(){ note_dtor("ee64170", this);} // tgen
ee64170 ::ee64170(){ note_ctor("ee64170", this);} // tgen

static void Test_ee64170()
{
  extern Class_Descriptor cd_ee64170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee64170, buf);
    ee64170 *dp, &lv = *(dp=new (buf) ee64170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee64170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee64170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(24,16), "ee64170");
    check_base_class_offset(lv, (cc170*)(dd4170*), 0, "ee64170");
    check_base_class_offset(lv, (dd4170*), 0, "ee64170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64170.e");
    test_class_info(&lv, &cd_ee64170);
    dp->~ee64170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64170(Test_ee64170, "ee64170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee64170C1Ev();
extern void _ZN7ee64170D1Ev();
Name_Map name_map_ee64170[] = {
  NSPAIR(_ZN7ee64170C1Ev),
  NSPAIR(_ZN7ee64170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee64170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64170[];
extern void _ZN7ee641703barEv();
extern void _ZN7ee641703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee641703barEv,_ZTv0_n16_N7ee641703barEv)();
extern void ABISELECT(_ZThn24_N7ee641703barEv,_ZThn16_N7ee641703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee641703fooEv,_ZTv0_n20_N7ee641703fooEv)();
extern void ABISELECT(_ZThn24_N7ee641703fooEv,_ZThn16_N7ee641703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee64170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64170[0]),
  (VTBL_ENTRY)&_ZN7ee641703barEv,
  (VTBL_ENTRY)&_ZN7ee641703fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee64170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee641703barEv,_ZTv0_n16_N7ee641703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee641703fooEv,_ZTv0_n20_N7ee641703fooEv),
};
extern VTBL_ENTRY _ZTV7ee64170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee64170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee64170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee64170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee64170[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee64170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee64170[] = {
  {&(_ZTV7ee64170[4]),  4,13},
  {&(_tg__ZTV6dd4170__7ee64170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee64170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee64170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee64170[5]),  5,7},
  {&(_ZTV7ee64170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee64170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee64170[];
extern  VTBL_ENTRY _ZTV7ee64170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64170[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41703barEv,_ZThn16_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee641703fooEv,_ZTv0_n20_N7ee641703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641703fooEv,_ZThn16_N7ee641703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee641703barEv,_ZTv0_n16_N7ee641703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641703barEv,_ZThn16_N7ee641703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee64170 = {  "ee64170", // class name
  bases_ee64170, 4,
  &(vtc_ee64170[0]), // expected_vtbl_contents
  &(vtt_ee64170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee64170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74170  : virtual dd4170 {
  int e;
  virtual void  foo(); // _ZN7ee741703fooEv
  virtual void  bar(); // _ZN7ee741703barEv
  ~ee74170(); // tgen
  ee74170(); // tgen
};
//SIG(1 ee74170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74170 ::foo(){vfunc_called(this, "_ZN7ee741703fooEv");}
void  ee74170 ::bar(){vfunc_called(this, "_ZN7ee741703barEv");}
ee74170 ::~ee74170(){ note_dtor("ee74170", this);} // tgen
ee74170 ::ee74170(){ note_ctor("ee74170", this);} // tgen

static void Test_ee74170()
{
  extern Class_Descriptor cd_ee74170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee74170, buf);
    ee74170 *dp, &lv = *(dp=new (buf) ee74170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee74170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee74170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd4170*), ABISELECT(32,20), "ee74170");
    check_base_class_offset(lv, (cc170*)(dd4170*), ABISELECT(16,8), "ee74170");
    check_base_class_offset(lv, (dd4170*), ABISELECT(16,8), "ee74170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74170.e");
    test_class_info(&lv, &cd_ee74170);
    dp->~ee74170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74170(Test_ee74170, "ee74170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee74170C1Ev();
extern void _ZN7ee74170D1Ev();
Name_Map name_map_ee74170[] = {
  NSPAIR(_ZN7ee74170C1Ev),
  NSPAIR(_ZN7ee74170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd4170;
extern VTBL_ENTRY _ZTI6dd4170[];
extern  VTBL_ENTRY _ZTV6dd4170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4170[];
static Base_Class bases_ee74170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74170[];
extern void _ZN7ee741703fooEv();
extern void _ZN7ee741703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee741703barEv,_ZTv0_n20_N7ee741703barEv)();
extern void ABISELECT(_ZThn16_N7ee741703barEv,_ZThn8_N7ee741703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee741703barEv,_ZTv0_n16_N7ee741703barEv)();
extern void ABISELECT(_ZThn32_N7ee741703barEv,_ZThn20_N7ee741703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee741703fooEv,_ZTv0_n20_N7ee741703fooEv)();
extern void ABISELECT(_ZThn32_N7ee741703fooEv,_ZThn20_N7ee741703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74170[0]),
  (VTBL_ENTRY)&_ZN7ee741703fooEv,
  (VTBL_ENTRY)&_ZN7ee741703barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee741703barEv,_ZTv0_n20_N7ee741703barEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee74170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741703barEv,_ZTv0_n16_N7ee741703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee741703fooEv,_ZTv0_n20_N7ee741703fooEv),
};
extern VTBL_ENTRY _ZTV7ee74170[];
extern void _ZN6dd41703barEv();
static  VTBL_ENTRY _tg__ZTV6dd4170__7ee74170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&_ZN6dd41703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd4170__7ee74170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd4170__7ee74170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv)();
extern void ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd4170__7ee74170[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee74170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee74170[] = {
  {&(_ZTV7ee74170[5]),  5,20},
  {&(_ZTV7ee74170[12]),  12,20},
  {&(_ZTV7ee74170[18]),  18,20},
  {&(_tg__ZTV6dd4170__7ee74170[4]),  4,5},
  {&(_tg__ZTV5cc1706dd4170__7ee74170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd4170__7ee74170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd4170__7ee74170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee74170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee74170[];
extern  VTBL_ENTRY _ZTV7ee74170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74170[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41703barEv,_ZTv0_n16_N6dd41703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41703barEv,_ZThn12_N6dd41703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee741703fooEv,_ZTv0_n20_N7ee741703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741703fooEv,_ZThn20_N7ee741703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741703barEv,_ZTv0_n16_N7ee741703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741703barEv,_ZThn20_N7ee741703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee741703barEv,_ZTv0_n20_N7ee741703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741703barEv,_ZThn8_N7ee741703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74170 = {  "ee74170", // class name
  bases_ee74170, 4,
  &(vtc_ee74170[0]), // expected_vtbl_contents
  &(vtt_ee74170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee74170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74170),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5170  : virtual cc170 {
  int d;
  virtual void  bar(); // _ZN6dd51703barEv
  ~dd5170(); // tgen
  dd5170(); // tgen
};
//SIG(-1 dd5170) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd5170 ::bar(){vfunc_called(this, "_ZN6dd51703barEv");}
dd5170 ::~dd5170(){ note_dtor("dd5170", this);} // tgen
dd5170 ::dd5170(){ note_ctor("dd5170", this);} // tgen

static void Test_dd5170()
{
  extern Class_Descriptor cd_dd5170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd5170, buf);
    dd5170 *dp, &lv = *(dp=new (buf) dd5170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd5170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,24), "dd5170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,16), "dd5170");
    check_base_class_offset(lv, (cc170*), ABISELECT(16,8), "dd5170");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5170.d");
    test_class_info(&lv, &cd_dd5170);
    dp->~dd5170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5170(Test_dd5170, "dd5170", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd5170C1Ev();
extern void _ZN6dd5170D1Ev();
Name_Map name_map_dd5170[] = {
  NSPAIR(_ZN6dd5170C1Ev),
  NSPAIR(_ZN6dd5170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd5170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5170[];
extern void _ZN6dd51703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_dd5170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV6dd5170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd5170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd5170[] = {
  {&(_ZTV6dd5170[5]),  5,17},
  {&(_ZTV6dd5170[10]),  10,17},
  {&(_ZTV6dd5170[15]),  15,17},
  {&(_tg__ZTV5cc170__6dd5170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd5170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd5170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5170 = {  "dd5170", // class name
  bases_dd5170, 3,
  &(vtc_dd5170[0]), // expected_vtbl_contents
  &(vtt_dd5170[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd5170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5170),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05170  : dd5170 {
  int e;
  ~ee05170(); // tgen
  ee05170(); // tgen
};
//SIG(1 ee05170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee05170 ::~ee05170(){ note_dtor("ee05170", this);} // tgen
ee05170 ::ee05170(){ note_ctor("ee05170", this);} // tgen

static void Test_ee05170()
{
  extern Class_Descriptor cd_ee05170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee05170, buf);
    ee05170 *dp, &lv = *(dp=new (buf) ee05170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee05170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee05170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee05170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(16,12), "ee05170");
    check_base_class_offset(lv, (dd5170*), 0, "ee05170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05170.e");
    test_class_info(&lv, &cd_ee05170);
    dp->~ee05170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05170(Test_ee05170, "ee05170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee05170C1Ev();
extern void _ZN7ee05170D1Ev();
Name_Map name_map_ee05170[] = {
  NSPAIR(_ZN7ee05170C1Ev),
  NSPAIR(_ZN7ee05170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee05170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05170[];
extern void _ZN6dd51703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee05170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05170[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee05170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee05170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee05170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee05170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee05170[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee05170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee05170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee05170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee05170[] = {
  {&(_ZTV7ee05170[5]),  5,17},
  {&(_tg__ZTV6dd5170__7ee05170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee05170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee05170[5]),  5,7},
  {&(_ZTV7ee05170[10]),  10,17},
  {&(_ZTV7ee05170[15]),  15,17},
  {&(_tg__ZTV5cc170__7ee05170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee05170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee05170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee05170[];
extern  VTBL_ENTRY _ZTV7ee05170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05170[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05170 = {  "ee05170", // class name
  bases_ee05170, 4,
  &(vtc_ee05170[0]), // expected_vtbl_contents
  &(vtt_ee05170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee05170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15170  : virtual dd5170 {
  int e;
  ~ee15170(); // tgen
  ee15170(); // tgen
};
//SIG(1 ee15170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee15170 ::~ee15170(){ note_dtor("ee15170", this);} // tgen
ee15170 ::ee15170(){ note_ctor("ee15170", this);} // tgen

static void Test_ee15170()
{
  extern Class_Descriptor cd_ee15170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee15170, buf);
    ee15170 *dp, &lv = *(dp=new (buf) ee15170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee15170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee15170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee15170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(32,16), "ee15170");
    check_base_class_offset(lv, (dd5170*), ABISELECT(16,8), "ee15170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15170.e");
    test_class_info(&lv, &cd_ee15170);
    dp->~ee15170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15170(Test_ee15170, "ee15170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee15170C1Ev();
extern void _ZN7ee15170D1Ev();
Name_Map name_map_ee15170[] = {
  NSPAIR(_ZN7ee15170C1Ev),
  NSPAIR(_ZN7ee15170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee15170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15170[];
extern void _ZN6dd51703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee15170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15170[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15170[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee15170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee15170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee15170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee15170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee15170[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee15170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee15170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee15170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee15170[] = {
  {&(_ZTV7ee15170[6]),  6,24},
  {&(_ZTV7ee15170[12]),  12,24},
  {&(_ZTV7ee15170[17]),  17,24},
  {&(_ZTV7ee15170[22]),  22,24},
  {&(_tg__ZTV6dd5170__7ee15170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee15170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee15170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee15170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee15170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee15170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee15170[];
extern  VTBL_ENTRY _ZTV7ee15170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15170[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15170 = {  "ee15170", // class name
  bases_ee15170, 4,
  &(vtc_ee15170[0]), // expected_vtbl_contents
  &(vtt_ee15170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee15170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15170),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25170  : dd5170 {
  int e;
  virtual void  foo(); // _ZN7ee251703fooEv
  ~ee25170(); // tgen
  ee25170(); // tgen
};
//SIG(1 ee25170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25170 ::foo(){vfunc_called(this, "_ZN7ee251703fooEv");}
ee25170 ::~ee25170(){ note_dtor("ee25170", this);} // tgen
ee25170 ::ee25170(){ note_ctor("ee25170", this);} // tgen

static void Test_ee25170()
{
  extern Class_Descriptor cd_ee25170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee25170, buf);
    ee25170 *dp, &lv = *(dp=new (buf) ee25170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee25170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee25170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee25170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(16,12), "ee25170");
    check_base_class_offset(lv, (dd5170*), 0, "ee25170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25170.e");
    test_class_info(&lv, &cd_ee25170);
    dp->~ee25170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25170(Test_ee25170, "ee25170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee25170C1Ev();
extern void _ZN7ee25170D1Ev();
Name_Map name_map_ee25170[] = {
  NSPAIR(_ZN7ee25170C1Ev),
  NSPAIR(_ZN7ee25170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee25170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25170[];
extern void _ZN6dd51703barEv();
extern void _ZN7ee251703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee251703fooEv,_ZTv0_n20_N7ee251703fooEv)();
extern void ABISELECT(_ZThn32_N7ee251703fooEv,_ZThn20_N7ee251703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
  (VTBL_ENTRY)&_ZN7ee251703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee25170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee251703fooEv,_ZTv0_n20_N7ee251703fooEv),
};
extern VTBL_ENTRY _ZTV7ee25170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee25170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee25170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee25170[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee25170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee25170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee25170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee25170[] = {
  {&(_ZTV7ee25170[5]),  5,18},
  {&(_tg__ZTV6dd5170__7ee25170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee25170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee25170[5]),  5,7},
  {&(_ZTV7ee25170[11]),  11,18},
  {&(_ZTV7ee25170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee25170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee25170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee25170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee25170[];
extern  VTBL_ENTRY _ZTV7ee25170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25170[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee251703fooEv,_ZTv0_n20_N7ee251703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee251703fooEv,_ZThn20_N7ee251703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25170 = {  "ee25170", // class name
  bases_ee25170, 4,
  &(vtc_ee25170[0]), // expected_vtbl_contents
  &(vtt_ee25170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee25170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35170  : virtual dd5170 {
  int e;
  virtual void  foo(); // _ZN7ee351703fooEv
  ~ee35170(); // tgen
  ee35170(); // tgen
};
//SIG(1 ee35170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35170 ::foo(){vfunc_called(this, "_ZN7ee351703fooEv");}
ee35170 ::~ee35170(){ note_dtor("ee35170", this);} // tgen
ee35170 ::ee35170(){ note_ctor("ee35170", this);} // tgen

static void Test_ee35170()
{
  extern Class_Descriptor cd_ee35170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee35170, buf);
    ee35170 *dp, &lv = *(dp=new (buf) ee35170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee35170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee35170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee35170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(32,16), "ee35170");
    check_base_class_offset(lv, (dd5170*), ABISELECT(16,8), "ee35170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35170.e");
    test_class_info(&lv, &cd_ee35170);
    dp->~ee35170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35170(Test_ee35170, "ee35170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee35170C1Ev();
extern void _ZN7ee35170D1Ev();
Name_Map name_map_ee35170[] = {
  NSPAIR(_ZN7ee35170C1Ev),
  NSPAIR(_ZN7ee35170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee35170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35170[];
extern void _ZN7ee351703fooEv();
extern void _ZN6dd51703barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee351703fooEv,_ZTv0_n20_N7ee351703fooEv)();
extern void ABISELECT(_ZThn48_N7ee351703fooEv,_ZThn24_N7ee351703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35170[0]),
  (VTBL_ENTRY)&_ZN7ee351703fooEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35170[0]),
  ABISELECT(-48,-24),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee35170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee351703fooEv,_ZTv0_n20_N7ee351703fooEv),
};
extern VTBL_ENTRY _ZTV7ee35170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee35170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee35170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee35170[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee35170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee35170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee35170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee35170[] = {
  {&(_ZTV7ee35170[6]),  6,25},
  {&(_ZTV7ee35170[13]),  13,25},
  {&(_ZTV7ee35170[18]),  18,25},
  {&(_ZTV7ee35170[23]),  23,25},
  {&(_tg__ZTV6dd5170__7ee35170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee35170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee35170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee35170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee35170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee35170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee35170[];
extern  VTBL_ENTRY _ZTV7ee35170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35170[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee351703fooEv,_ZTv0_n20_N7ee351703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee351703fooEv,_ZThn24_N7ee351703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35170 = {  "ee35170", // class name
  bases_ee35170, 4,
  &(vtc_ee35170[0]), // expected_vtbl_contents
  &(vtt_ee35170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee35170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35170),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45170  : dd5170 {
  int e;
  virtual void  bar(); // _ZN7ee451703barEv
  ~ee45170(); // tgen
  ee45170(); // tgen
};
//SIG(1 ee45170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45170 ::bar(){vfunc_called(this, "_ZN7ee451703barEv");}
ee45170 ::~ee45170(){ note_dtor("ee45170", this);} // tgen
ee45170 ::ee45170(){ note_ctor("ee45170", this);} // tgen

static void Test_ee45170()
{
  extern Class_Descriptor cd_ee45170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee45170, buf);
    ee45170 *dp, &lv = *(dp=new (buf) ee45170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee45170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee45170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee45170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(16,12), "ee45170");
    check_base_class_offset(lv, (dd5170*), 0, "ee45170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45170.e");
    test_class_info(&lv, &cd_ee45170);
    dp->~ee45170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45170(Test_ee45170, "ee45170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee45170C1Ev();
extern void _ZN7ee45170D1Ev();
Name_Map name_map_ee45170[] = {
  NSPAIR(_ZN7ee45170C1Ev),
  NSPAIR(_ZN7ee45170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee45170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45170[];
extern void _ZN7ee451703barEv();
extern void ABISELECT(_ZTv0_n32_N7ee451703barEv,_ZTv0_n16_N7ee451703barEv)();
extern void ABISELECT(_ZThn32_N7ee451703barEv,_ZThn20_N7ee451703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee45170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45170[0]),
  (VTBL_ENTRY)&_ZN7ee451703barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45170[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee45170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee451703barEv,_ZTv0_n16_N7ee451703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee45170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee45170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee45170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee45170[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee45170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee45170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee45170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee45170[] = {
  {&(_ZTV7ee45170[5]),  5,17},
  {&(_tg__ZTV6dd5170__7ee45170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee45170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee45170[5]),  5,7},
  {&(_ZTV7ee45170[10]),  10,17},
  {&(_ZTV7ee45170[15]),  15,17},
  {&(_tg__ZTV5cc170__7ee45170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee45170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee45170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee45170[];
extern  VTBL_ENTRY _ZTV7ee45170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45170[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee451703barEv,_ZTv0_n16_N7ee451703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee451703barEv,_ZThn20_N7ee451703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45170 = {  "ee45170", // class name
  bases_ee45170, 4,
  &(vtc_ee45170[0]), // expected_vtbl_contents
  &(vtt_ee45170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee45170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45170),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55170  : virtual dd5170 {
  int e;
  virtual void  bar(); // _ZN7ee551703barEv
  ~ee55170(); // tgen
  ee55170(); // tgen
};
//SIG(1 ee55170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55170 ::bar(){vfunc_called(this, "_ZN7ee551703barEv");}
ee55170 ::~ee55170(){ note_dtor("ee55170", this);} // tgen
ee55170 ::ee55170(){ note_ctor("ee55170", this);} // tgen

static void Test_ee55170()
{
  extern Class_Descriptor cd_ee55170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee55170, buf);
    ee55170 *dp, &lv = *(dp=new (buf) ee55170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee55170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee55170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee55170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(32,16), "ee55170");
    check_base_class_offset(lv, (dd5170*), ABISELECT(16,8), "ee55170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55170.e");
    test_class_info(&lv, &cd_ee55170);
    dp->~ee55170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55170(Test_ee55170, "ee55170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee55170C1Ev();
extern void _ZN7ee55170D1Ev();
Name_Map name_map_ee55170[] = {
  NSPAIR(_ZN7ee55170C1Ev),
  NSPAIR(_ZN7ee55170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee55170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55170[];
extern void _ZN7ee551703barEv();
extern void ABISELECT(_ZTv0_n48_N7ee551703barEv,_ZTv0_n24_N7ee551703barEv)();
extern void ABISELECT(_ZThn16_N7ee551703barEv,_ZThn8_N7ee551703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee551703barEv,_ZTv0_n16_N7ee551703barEv)();
extern void ABISELECT(_ZThn48_N7ee551703barEv,_ZThn24_N7ee551703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY vtc_ee55170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55170[0]),
  (VTBL_ENTRY)&_ZN7ee551703barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee551703barEv,_ZTv0_n24_N7ee551703barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55170[0]),
  0,
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee55170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee551703barEv,_ZTv0_n16_N7ee551703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern VTBL_ENTRY _ZTV7ee55170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee55170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee55170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee55170[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee55170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee55170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee55170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee55170[] = {
  {&(_ZTV7ee55170[6]),  6,25},
  {&(_ZTV7ee55170[13]),  13,25},
  {&(_ZTV7ee55170[18]),  18,25},
  {&(_ZTV7ee55170[23]),  23,25},
  {&(_tg__ZTV6dd5170__7ee55170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee55170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee55170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee55170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee55170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee55170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee55170[];
extern  VTBL_ENTRY _ZTV7ee55170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55170[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee551703barEv,_ZTv0_n16_N7ee551703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee551703barEv,_ZThn24_N7ee551703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee551703barEv,_ZTv0_n24_N7ee551703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551703barEv,_ZThn8_N7ee551703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55170 = {  "ee55170", // class name
  bases_ee55170, 4,
  &(vtc_ee55170[0]), // expected_vtbl_contents
  &(vtt_ee55170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee55170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55170),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65170  : dd5170 {
  int e;
  virtual void  foo(); // _ZN7ee651703fooEv
  virtual void  bar(); // _ZN7ee651703barEv
  ~ee65170(); // tgen
  ee65170(); // tgen
};
//SIG(1 ee65170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65170 ::foo(){vfunc_called(this, "_ZN7ee651703fooEv");}
void  ee65170 ::bar(){vfunc_called(this, "_ZN7ee651703barEv");}
ee65170 ::~ee65170(){ note_dtor("ee65170", this);} // tgen
ee65170 ::ee65170(){ note_ctor("ee65170", this);} // tgen

static void Test_ee65170()
{
  extern Class_Descriptor cd_ee65170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee65170, buf);
    ee65170 *dp, &lv = *(dp=new (buf) ee65170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee65170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee65170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee65170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(16,12), "ee65170");
    check_base_class_offset(lv, (dd5170*), 0, "ee65170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65170.e");
    test_class_info(&lv, &cd_ee65170);
    dp->~ee65170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65170(Test_ee65170, "ee65170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee65170C1Ev();
extern void _ZN7ee65170D1Ev();
Name_Map name_map_ee65170[] = {
  NSPAIR(_ZN7ee65170C1Ev),
  NSPAIR(_ZN7ee65170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee65170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65170[];
extern void _ZN7ee651703barEv();
extern void _ZN7ee651703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee651703barEv,_ZTv0_n16_N7ee651703barEv)();
extern void ABISELECT(_ZThn32_N7ee651703barEv,_ZThn20_N7ee651703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee651703fooEv,_ZTv0_n20_N7ee651703fooEv)();
extern void ABISELECT(_ZThn32_N7ee651703fooEv,_ZThn20_N7ee651703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65170[0]),
  (VTBL_ENTRY)&_ZN7ee651703barEv,
  (VTBL_ENTRY)&_ZN7ee651703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee65170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee651703barEv,_ZTv0_n16_N7ee651703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee651703fooEv,_ZTv0_n20_N7ee651703fooEv),
};
extern VTBL_ENTRY _ZTV7ee65170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee65170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee65170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee65170[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee65170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee65170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee65170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee65170[] = {
  {&(_ZTV7ee65170[5]),  5,18},
  {&(_tg__ZTV6dd5170__7ee65170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee65170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee65170[5]),  5,7},
  {&(_ZTV7ee65170[11]),  11,18},
  {&(_ZTV7ee65170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee65170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee65170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee65170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee65170[];
extern  VTBL_ENTRY _ZTV7ee65170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65170[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn20_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee651703fooEv,_ZTv0_n20_N7ee651703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651703fooEv,_ZThn20_N7ee651703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee651703barEv,_ZTv0_n16_N7ee651703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651703barEv,_ZThn20_N7ee651703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65170 = {  "ee65170", // class name
  bases_ee65170, 4,
  &(vtc_ee65170[0]), // expected_vtbl_contents
  &(vtt_ee65170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee65170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75170  : virtual dd5170 {
  int e;
  virtual void  foo(); // _ZN7ee751703fooEv
  virtual void  bar(); // _ZN7ee751703barEv
  ~ee75170(); // tgen
  ee75170(); // tgen
};
//SIG(1 ee75170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75170 ::foo(){vfunc_called(this, "_ZN7ee751703fooEv");}
void  ee75170 ::bar(){vfunc_called(this, "_ZN7ee751703barEv");}
ee75170 ::~ee75170(){ note_dtor("ee75170", this);} // tgen
ee75170 ::ee75170(){ note_ctor("ee75170", this);} // tgen

static void Test_ee75170()
{
  extern Class_Descriptor cd_ee75170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee75170, buf);
    ee75170 *dp, &lv = *(dp=new (buf) ee75170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee75170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee75170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee75170");
    check_base_class_offset(lv, (cc170*)(dd5170*), ABISELECT(32,16), "ee75170");
    check_base_class_offset(lv, (dd5170*), ABISELECT(16,8), "ee75170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75170.e");
    test_class_info(&lv, &cd_ee75170);
    dp->~ee75170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75170(Test_ee75170, "ee75170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee75170C1Ev();
extern void _ZN7ee75170D1Ev();
Name_Map name_map_ee75170[] = {
  NSPAIR(_ZN7ee75170C1Ev),
  NSPAIR(_ZN7ee75170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd5170;
extern VTBL_ENTRY _ZTI6dd5170[];
extern  VTBL_ENTRY _ZTV6dd5170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5170[];
static Base_Class bases_ee75170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5170,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75170[];
extern void _ZN7ee751703fooEv();
extern void _ZN7ee751703barEv();
extern void ABISELECT(_ZTv0_n48_N7ee751703barEv,_ZTv0_n24_N7ee751703barEv)();
extern void ABISELECT(_ZThn16_N7ee751703barEv,_ZThn8_N7ee751703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee751703barEv,_ZTv0_n16_N7ee751703barEv)();
extern void ABISELECT(_ZThn48_N7ee751703barEv,_ZThn24_N7ee751703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee751703fooEv,_ZTv0_n20_N7ee751703fooEv)();
extern void ABISELECT(_ZThn48_N7ee751703fooEv,_ZThn24_N7ee751703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75170[0]),
  (VTBL_ENTRY)&_ZN7ee751703fooEv,
  (VTBL_ENTRY)&_ZN7ee751703barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee751703barEv,_ZTv0_n24_N7ee751703barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75170[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee75170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee751703barEv,_ZTv0_n16_N7ee751703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee751703fooEv,_ZTv0_n20_N7ee751703fooEv),
};
extern VTBL_ENTRY _ZTV7ee75170[];
extern void _ZN6dd51703barEv();
static  VTBL_ENTRY _tg__ZTV6dd5170__7ee75170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&_ZN6dd51703barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd5170__7ee75170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv)();
extern void ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv)() __attribute__((weak));
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd5170__7ee75170[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv),
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee75170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee75170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee75170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee75170[] = {
  {&(_ZTV7ee75170[6]),  6,26},
  {&(_ZTV7ee75170[14]),  14,26},
  {&(_ZTV7ee75170[19]),  19,26},
  {&(_ZTV7ee75170[24]),  24,26},
  {&(_tg__ZTV6dd5170__7ee75170[5]),  5,6},
  {&(_tg__ZTV5cc170__6dd5170__7ee75170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd5170__7ee75170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee75170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee75170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee75170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee75170[];
extern  VTBL_ENTRY _ZTV7ee75170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75170[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51703barEv,_ZTv0_n16_N6dd51703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51703barEv,_ZThn16_N6dd51703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee751703fooEv,_ZTv0_n20_N7ee751703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751703fooEv,_ZThn24_N7ee751703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee751703barEv,_ZTv0_n16_N7ee751703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751703barEv,_ZThn24_N7ee751703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee751703barEv,_ZTv0_n24_N7ee751703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751703barEv,_ZThn8_N7ee751703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75170 = {  "ee75170", // class name
  bases_ee75170, 4,
  &(vtc_ee75170[0]), // expected_vtbl_contents
  &(vtt_ee75170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee75170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75170),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6170  : cc170 {
  int d;
  virtual void  bar(); // _ZN6dd61703barEv
  virtual void  foo(); // _ZN6dd61703fooEv
  ~dd6170(); // tgen
  dd6170(); // tgen
};
//SIG(-1 dd6170) C1{ BC2{ VBC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd6170 ::bar(){vfunc_called(this, "_ZN6dd61703barEv");}
void  dd6170 ::foo(){vfunc_called(this, "_ZN6dd61703fooEv");}
dd6170 ::~dd6170(){ note_dtor("dd6170", this);} // tgen
dd6170 ::dd6170(){ note_ctor("dd6170", this);} // tgen

static void Test_dd6170()
{
  extern Class_Descriptor cd_dd6170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd6170, buf);
    dd6170 *dp, &lv = *(dp=new (buf) dd6170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd6170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(28,20), "dd6170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(16,12), "dd6170");
    check_base_class_offset(lv, (cc170*), 0, "dd6170");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6170.d");
    test_class_info(&lv, &cd_dd6170);
    dp->~dd6170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6170(Test_dd6170, "dd6170", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd6170C1Ev();
extern void _ZN6dd6170D1Ev();
Name_Map name_map_dd6170[] = {
  NSPAIR(_ZN6dd6170C1Ev),
  NSPAIR(_ZN6dd6170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd6170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd6170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern VTBL_ENTRY _ZTV6dd6170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd6170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd6170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd6170[] = {
  {&(_ZTV6dd6170[4]),  4,13},
  {&(_tg__ZTV5cc170__6dd6170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd6170[5]),  5,7},
  {&(_ZTV6dd6170[11]),  11,13},
  {&(_tg__ZTV4bb70__6dd6170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd6170 = {  "dd6170", // class name
  bases_dd6170, 3,
  &(vtc_dd6170[0]), // expected_vtbl_contents
  &(vtt_dd6170[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd6170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6170),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06170  : dd6170 {
  int e;
  ~ee06170(); // tgen
  ee06170(); // tgen
};
//SIG(1 ee06170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee06170 ::~ee06170(){ note_dtor("ee06170", this);} // tgen
ee06170 ::ee06170(){ note_ctor("ee06170", this);} // tgen

static void Test_ee06170()
{
  extern Class_Descriptor cd_ee06170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee06170, buf);
    ee06170 *dp, &lv = *(dp=new (buf) ee06170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee06170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee06170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(24,16), "ee06170");
    check_base_class_offset(lv, (cc170*)(dd6170*), 0, "ee06170");
    check_base_class_offset(lv, (dd6170*), 0, "ee06170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06170.e");
    test_class_info(&lv, &cd_ee06170);
    dp->~ee06170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06170(Test_ee06170, "ee06170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee06170C1Ev();
extern void _ZN7ee06170D1Ev();
Name_Map name_map_ee06170[] = {
  NSPAIR(_ZN7ee06170C1Ev),
  NSPAIR(_ZN7ee06170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee06170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee06170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee06170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern VTBL_ENTRY _ZTV7ee06170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee06170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee06170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee06170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee06170[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee06170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee06170[] = {
  {&(_ZTV7ee06170[4]),  4,13},
  {&(_tg__ZTV6dd6170__7ee06170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee06170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee06170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee06170[5]),  5,7},
  {&(_ZTV7ee06170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee06170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee06170[];
extern  VTBL_ENTRY _ZTV7ee06170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06170[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee06170 = {  "ee06170", // class name
  bases_ee06170, 4,
  &(vtc_ee06170[0]), // expected_vtbl_contents
  &(vtt_ee06170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee06170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16170  : virtual dd6170 {
  int e;
  ~ee16170(); // tgen
  ee16170(); // tgen
};
//SIG(1 ee16170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee16170 ::~ee16170(){ note_dtor("ee16170", this);} // tgen
ee16170 ::ee16170(){ note_ctor("ee16170", this);} // tgen

static void Test_ee16170()
{
  extern Class_Descriptor cd_ee16170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee16170, buf);
    ee16170 *dp, &lv = *(dp=new (buf) ee16170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee16170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee16170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(32,20), "ee16170");
    check_base_class_offset(lv, (cc170*)(dd6170*), ABISELECT(16,8), "ee16170");
    check_base_class_offset(lv, (dd6170*), ABISELECT(16,8), "ee16170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16170.e");
    test_class_info(&lv, &cd_ee16170);
    dp->~ee16170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16170(Test_ee16170, "ee16170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee16170C1Ev();
extern void _ZN7ee16170D1Ev();
Name_Map name_map_ee16170[] = {
  NSPAIR(_ZN7ee16170C1Ev),
  NSPAIR(_ZN7ee16170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee16170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee16170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16170[0]),
  0,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee16170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern VTBL_ENTRY _ZTV7ee16170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee16170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee16170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee16170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee16170[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee16170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee16170[] = {
  {&(_ZTV7ee16170[5]),  5,20},
  {&(_ZTV7ee16170[11]),  11,20},
  {&(_ZTV7ee16170[18]),  18,20},
  {&(_tg__ZTV6dd6170__7ee16170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee16170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee16170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee16170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee16170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee16170[];
extern  VTBL_ENTRY _ZTV7ee16170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16170[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee16170 = {  "ee16170", // class name
  bases_ee16170, 4,
  &(vtc_ee16170[0]), // expected_vtbl_contents
  &(vtt_ee16170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee16170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16170),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26170  : dd6170 {
  int e;
  virtual void  foo(); // _ZN7ee261703fooEv
  ~ee26170(); // tgen
  ee26170(); // tgen
};
//SIG(1 ee26170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26170 ::foo(){vfunc_called(this, "_ZN7ee261703fooEv");}
ee26170 ::~ee26170(){ note_dtor("ee26170", this);} // tgen
ee26170 ::ee26170(){ note_ctor("ee26170", this);} // tgen

static void Test_ee26170()
{
  extern Class_Descriptor cd_ee26170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee26170, buf);
    ee26170 *dp, &lv = *(dp=new (buf) ee26170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee26170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee26170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(24,16), "ee26170");
    check_base_class_offset(lv, (cc170*)(dd6170*), 0, "ee26170");
    check_base_class_offset(lv, (dd6170*), 0, "ee26170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26170.e");
    test_class_info(&lv, &cd_ee26170);
    dp->~ee26170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26170(Test_ee26170, "ee26170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee26170C1Ev();
extern void _ZN7ee26170D1Ev();
Name_Map name_map_ee26170[] = {
  NSPAIR(_ZN7ee26170C1Ev),
  NSPAIR(_ZN7ee26170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee26170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26170[];
extern void _ZN6dd61703barEv();
extern void _ZN7ee261703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee261703fooEv,_ZTv0_n20_N7ee261703fooEv)();
extern void ABISELECT(_ZThn24_N7ee261703fooEv,_ZThn16_N7ee261703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee26170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN7ee261703fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee26170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee261703fooEv,_ZTv0_n20_N7ee261703fooEv),
};
extern VTBL_ENTRY _ZTV7ee26170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee26170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee26170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee26170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee26170[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee26170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee26170[] = {
  {&(_ZTV7ee26170[4]),  4,13},
  {&(_tg__ZTV6dd6170__7ee26170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee26170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee26170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee26170[5]),  5,7},
  {&(_ZTV7ee26170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee26170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee26170[];
extern  VTBL_ENTRY _ZTV7ee26170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26170[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee261703fooEv,_ZTv0_n20_N7ee261703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee261703fooEv,_ZThn16_N7ee261703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee26170 = {  "ee26170", // class name
  bases_ee26170, 4,
  &(vtc_ee26170[0]), // expected_vtbl_contents
  &(vtt_ee26170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee26170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36170  : virtual dd6170 {
  int e;
  virtual void  foo(); // _ZN7ee361703fooEv
  ~ee36170(); // tgen
  ee36170(); // tgen
};
//SIG(1 ee36170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36170 ::foo(){vfunc_called(this, "_ZN7ee361703fooEv");}
ee36170 ::~ee36170(){ note_dtor("ee36170", this);} // tgen
ee36170 ::ee36170(){ note_ctor("ee36170", this);} // tgen

static void Test_ee36170()
{
  extern Class_Descriptor cd_ee36170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee36170, buf);
    ee36170 *dp, &lv = *(dp=new (buf) ee36170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee36170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee36170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(32,20), "ee36170");
    check_base_class_offset(lv, (cc170*)(dd6170*), ABISELECT(16,8), "ee36170");
    check_base_class_offset(lv, (dd6170*), ABISELECT(16,8), "ee36170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36170.e");
    test_class_info(&lv, &cd_ee36170);
    dp->~ee36170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36170(Test_ee36170, "ee36170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee36170C1Ev();
extern void _ZN7ee36170D1Ev();
Name_Map name_map_ee36170[] = {
  NSPAIR(_ZN7ee36170C1Ev),
  NSPAIR(_ZN7ee36170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee36170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36170[];
extern void _ZN7ee361703fooEv();
extern void _ZN6dd61703barEv();
extern void ABISELECT(_ZTv0_n48_N7ee361703fooEv,_ZTv0_n24_N7ee361703fooEv)();
extern void ABISELECT(_ZThn16_N7ee361703fooEv,_ZThn8_N7ee361703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee361703fooEv,_ZTv0_n20_N7ee361703fooEv)();
extern void ABISELECT(_ZThn32_N7ee361703fooEv,_ZThn20_N7ee361703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36170[0]),
  (VTBL_ENTRY)&_ZN7ee361703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee361703fooEv,_ZTv0_n24_N7ee361703fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee36170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee361703fooEv,_ZTv0_n20_N7ee361703fooEv),
};
extern VTBL_ENTRY _ZTV7ee36170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee36170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee36170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee36170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee36170[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee36170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee36170[] = {
  {&(_ZTV7ee36170[5]),  5,21},
  {&(_ZTV7ee36170[12]),  12,21},
  {&(_ZTV7ee36170[19]),  19,21},
  {&(_tg__ZTV6dd6170__7ee36170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee36170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee36170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee36170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee36170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee36170[];
extern  VTBL_ENTRY _ZTV7ee36170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36170[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee361703fooEv,_ZTv0_n20_N7ee361703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee361703fooEv,_ZThn20_N7ee361703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee361703fooEv,_ZTv0_n24_N7ee361703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361703fooEv,_ZThn8_N7ee361703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36170 = {  "ee36170", // class name
  bases_ee36170, 4,
  &(vtc_ee36170[0]), // expected_vtbl_contents
  &(vtt_ee36170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee36170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36170),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46170  : dd6170 {
  int e;
  virtual void  bar(); // _ZN7ee461703barEv
  ~ee46170(); // tgen
  ee46170(); // tgen
};
//SIG(1 ee46170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46170 ::bar(){vfunc_called(this, "_ZN7ee461703barEv");}
ee46170 ::~ee46170(){ note_dtor("ee46170", this);} // tgen
ee46170 ::ee46170(){ note_ctor("ee46170", this);} // tgen

static void Test_ee46170()
{
  extern Class_Descriptor cd_ee46170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee46170, buf);
    ee46170 *dp, &lv = *(dp=new (buf) ee46170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee46170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee46170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(24,16), "ee46170");
    check_base_class_offset(lv, (cc170*)(dd6170*), 0, "ee46170");
    check_base_class_offset(lv, (dd6170*), 0, "ee46170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46170.e");
    test_class_info(&lv, &cd_ee46170);
    dp->~ee46170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46170(Test_ee46170, "ee46170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee46170C1Ev();
extern void _ZN7ee46170D1Ev();
Name_Map name_map_ee46170[] = {
  NSPAIR(_ZN7ee46170C1Ev),
  NSPAIR(_ZN7ee46170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee46170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46170[];
extern void _ZN7ee461703barEv();
extern void _ZN6dd61703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee461703barEv,_ZTv0_n16_N7ee461703barEv)();
extern void ABISELECT(_ZThn24_N7ee461703barEv,_ZThn16_N7ee461703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee46170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46170[0]),
  (VTBL_ENTRY)&_ZN7ee461703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee46170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee461703barEv,_ZTv0_n16_N7ee461703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern VTBL_ENTRY _ZTV7ee46170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee46170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee46170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee46170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee46170[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee46170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee46170[] = {
  {&(_ZTV7ee46170[4]),  4,13},
  {&(_tg__ZTV6dd6170__7ee46170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee46170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee46170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee46170[5]),  5,7},
  {&(_ZTV7ee46170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee46170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee46170[];
extern  VTBL_ENTRY _ZTV7ee46170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46170[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee461703barEv,_ZTv0_n16_N7ee461703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee461703barEv,_ZThn16_N7ee461703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee46170 = {  "ee46170", // class name
  bases_ee46170, 4,
  &(vtc_ee46170[0]), // expected_vtbl_contents
  &(vtt_ee46170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee46170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56170  : virtual dd6170 {
  int e;
  virtual void  bar(); // _ZN7ee561703barEv
  ~ee56170(); // tgen
  ee56170(); // tgen
};
//SIG(1 ee56170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56170 ::bar(){vfunc_called(this, "_ZN7ee561703barEv");}
ee56170 ::~ee56170(){ note_dtor("ee56170", this);} // tgen
ee56170 ::ee56170(){ note_ctor("ee56170", this);} // tgen

static void Test_ee56170()
{
  extern Class_Descriptor cd_ee56170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee56170, buf);
    ee56170 *dp, &lv = *(dp=new (buf) ee56170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee56170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee56170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(32,20), "ee56170");
    check_base_class_offset(lv, (cc170*)(dd6170*), ABISELECT(16,8), "ee56170");
    check_base_class_offset(lv, (dd6170*), ABISELECT(16,8), "ee56170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56170.e");
    test_class_info(&lv, &cd_ee56170);
    dp->~ee56170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56170(Test_ee56170, "ee56170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee56170C1Ev();
extern void _ZN7ee56170D1Ev();
Name_Map name_map_ee56170[] = {
  NSPAIR(_ZN7ee56170C1Ev),
  NSPAIR(_ZN7ee56170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee56170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56170[];
extern void _ZN7ee561703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee561703barEv,_ZTv0_n20_N7ee561703barEv)();
extern void ABISELECT(_ZThn16_N7ee561703barEv,_ZThn8_N7ee561703barEv)() __attribute__((weak));
extern void _ZN6dd61703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee561703barEv,_ZTv0_n16_N7ee561703barEv)();
extern void ABISELECT(_ZThn32_N7ee561703barEv,_ZThn20_N7ee561703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56170[0]),
  (VTBL_ENTRY)&_ZN7ee561703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee561703barEv,_ZTv0_n20_N7ee561703barEv),
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee56170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee561703barEv,_ZTv0_n16_N7ee561703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern VTBL_ENTRY _ZTV7ee56170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee56170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee56170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee56170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee56170[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee56170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee56170[] = {
  {&(_ZTV7ee56170[5]),  5,21},
  {&(_ZTV7ee56170[12]),  12,21},
  {&(_ZTV7ee56170[19]),  19,21},
  {&(_tg__ZTV6dd6170__7ee56170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee56170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee56170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee56170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee56170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee56170[];
extern  VTBL_ENTRY _ZTV7ee56170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56170[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee561703barEv,_ZTv0_n16_N7ee561703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee561703barEv,_ZThn20_N7ee561703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee561703barEv,_ZTv0_n20_N7ee561703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561703barEv,_ZThn8_N7ee561703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56170 = {  "ee56170", // class name
  bases_ee56170, 4,
  &(vtc_ee56170[0]), // expected_vtbl_contents
  &(vtt_ee56170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee56170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56170),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66170  : dd6170 {
  int e;
  virtual void  foo(); // _ZN7ee661703fooEv
  virtual void  bar(); // _ZN7ee661703barEv
  ~ee66170(); // tgen
  ee66170(); // tgen
};
//SIG(1 ee66170) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66170 ::foo(){vfunc_called(this, "_ZN7ee661703fooEv");}
void  ee66170 ::bar(){vfunc_called(this, "_ZN7ee661703barEv");}
ee66170 ::~ee66170(){ note_dtor("ee66170", this);} // tgen
ee66170 ::ee66170(){ note_ctor("ee66170", this);} // tgen

static void Test_ee66170()
{
  extern Class_Descriptor cd_ee66170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee66170, buf);
    ee66170 *dp, &lv = *(dp=new (buf) ee66170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee66170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(36,24), "ee66170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(24,16), "ee66170");
    check_base_class_offset(lv, (cc170*)(dd6170*), 0, "ee66170");
    check_base_class_offset(lv, (dd6170*), 0, "ee66170");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66170.e");
    test_class_info(&lv, &cd_ee66170);
    dp->~ee66170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66170(Test_ee66170, "ee66170", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee66170C1Ev();
extern void _ZN7ee66170D1Ev();
Name_Map name_map_ee66170[] = {
  NSPAIR(_ZN7ee66170C1Ev),
  NSPAIR(_ZN7ee66170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee66170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66170[];
extern void _ZN7ee661703barEv();
extern void _ZN7ee661703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee661703barEv,_ZTv0_n16_N7ee661703barEv)();
extern void ABISELECT(_ZThn24_N7ee661703barEv,_ZThn16_N7ee661703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee661703fooEv,_ZTv0_n20_N7ee661703fooEv)();
extern void ABISELECT(_ZThn24_N7ee661703fooEv,_ZThn16_N7ee661703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee66170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66170[0]),
  (VTBL_ENTRY)&_ZN7ee661703barEv,
  (VTBL_ENTRY)&_ZN7ee661703fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee66170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee661703barEv,_ZTv0_n16_N7ee661703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee661703fooEv,_ZTv0_n20_N7ee661703fooEv),
};
extern VTBL_ENTRY _ZTV7ee66170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee66170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee66170[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee66170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee66170[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee66170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee66170[] = {
  {&(_ZTV7ee66170[4]),  4,13},
  {&(_tg__ZTV6dd6170__7ee66170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee66170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee66170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee66170[5]),  5,7},
  {&(_ZTV7ee66170[11]),  11,13},
  {&(_tg__ZTV4bb70__7ee66170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee66170[];
extern  VTBL_ENTRY _ZTV7ee66170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66170[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703fooEv,_ZThn16_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61703barEv,_ZThn16_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee661703fooEv,_ZTv0_n20_N7ee661703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661703fooEv,_ZThn16_N7ee661703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee661703barEv,_ZTv0_n16_N7ee661703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661703barEv,_ZThn16_N7ee661703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee66170 = {  "ee66170", // class name
  bases_ee66170, 4,
  &(vtc_ee66170[0]), // expected_vtbl_contents
  &(vtt_ee66170[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee66170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66170),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66170),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76170  : virtual dd6170 {
  int e;
  virtual void  foo(); // _ZN7ee761703fooEv
  virtual void  bar(); // _ZN7ee761703barEv
  ~ee76170(); // tgen
  ee76170(); // tgen
};
//SIG(1 ee76170) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76170 ::foo(){vfunc_called(this, "_ZN7ee761703fooEv");}
void  ee76170 ::bar(){vfunc_called(this, "_ZN7ee761703barEv");}
ee76170 ::~ee76170(){ note_dtor("ee76170", this);} // tgen
ee76170 ::ee76170(){ note_ctor("ee76170", this);} // tgen

static void Test_ee76170()
{
  extern Class_Descriptor cd_ee76170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee76170, buf);
    ee76170 *dp, &lv = *(dp=new (buf) ee76170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee76170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee76170");
    check_base_class_offset(lv, (bb70*)(cc170*)(dd6170*), ABISELECT(32,20), "ee76170");
    check_base_class_offset(lv, (cc170*)(dd6170*), ABISELECT(16,8), "ee76170");
    check_base_class_offset(lv, (dd6170*), ABISELECT(16,8), "ee76170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76170.e");
    test_class_info(&lv, &cd_ee76170);
    dp->~ee76170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76170(Test_ee76170, "ee76170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee76170C1Ev();
extern void _ZN7ee76170D1Ev();
Name_Map name_map_ee76170[] = {
  NSPAIR(_ZN7ee76170C1Ev),
  NSPAIR(_ZN7ee76170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd6170;
extern VTBL_ENTRY _ZTI6dd6170[];
extern  VTBL_ENTRY _ZTV6dd6170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6170[];
static Base_Class bases_ee76170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76170[];
extern void _ZN7ee761703fooEv();
extern void _ZN7ee761703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee761703barEv,_ZTv0_n20_N7ee761703barEv)();
extern void ABISELECT(_ZThn16_N7ee761703barEv,_ZThn8_N7ee761703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee761703fooEv,_ZTv0_n24_N7ee761703fooEv)();
extern void ABISELECT(_ZThn16_N7ee761703fooEv,_ZThn8_N7ee761703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee761703barEv,_ZTv0_n16_N7ee761703barEv)();
extern void ABISELECT(_ZThn32_N7ee761703barEv,_ZThn20_N7ee761703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee761703fooEv,_ZTv0_n20_N7ee761703fooEv)();
extern void ABISELECT(_ZThn32_N7ee761703fooEv,_ZThn20_N7ee761703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76170[0]),
  (VTBL_ENTRY)&_ZN7ee761703fooEv,
  (VTBL_ENTRY)&_ZN7ee761703barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761703barEv,_ZTv0_n20_N7ee761703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee761703fooEv,_ZTv0_n24_N7ee761703fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee76170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761703barEv,_ZTv0_n16_N7ee761703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761703fooEv,_ZTv0_n20_N7ee761703fooEv),
};
extern VTBL_ENTRY _ZTV7ee76170[];
extern void _ZN6dd61703barEv();
extern void _ZN6dd61703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6170__7ee76170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&_ZN6dd61703barEv,
  (VTBL_ENTRY)&_ZN6dd61703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1706dd6170__7ee76170[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc1706dd6170__7ee76170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv)();
extern void ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv)();
extern void ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd6170__7ee76170[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee76170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee76170[] = {
  {&(_ZTV7ee76170[5]),  5,22},
  {&(_ZTV7ee76170[13]),  13,22},
  {&(_ZTV7ee76170[20]),  20,22},
  {&(_tg__ZTV6dd6170__7ee76170[4]),  4,6},
  {&(_tg__ZTV5cc1706dd6170__7ee76170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc1706dd6170__7ee76170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd6170__7ee76170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee76170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee76170[];
extern  VTBL_ENTRY _ZTV7ee76170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76170[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd61703fooEv,_ZTv0_n20_N6dd61703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703fooEv,_ZThn12_N6dd61703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61703barEv,_ZTv0_n16_N6dd61703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61703barEv,_ZThn12_N6dd61703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761703fooEv,_ZTv0_n20_N7ee761703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761703fooEv,_ZThn20_N7ee761703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761703barEv,_ZTv0_n16_N7ee761703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761703barEv,_ZThn20_N7ee761703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee761703fooEv,_ZTv0_n24_N7ee761703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761703fooEv,_ZThn8_N7ee761703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761703barEv,_ZTv0_n20_N7ee761703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761703barEv,_ZThn8_N7ee761703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76170 = {  "ee76170", // class name
  bases_ee76170, 4,
  &(vtc_ee76170[0]), // expected_vtbl_contents
  &(vtt_ee76170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee76170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76170),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76170),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7170  : virtual cc170 {
  int d;
  virtual void  bar(); // _ZN6dd71703barEv
  virtual void  foo(); // _ZN6dd71703fooEv
  ~dd7170(); // tgen
  dd7170(); // tgen
};
//SIG(-1 dd7170) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd7170 ::bar(){vfunc_called(this, "_ZN6dd71703barEv");}
void  dd7170 ::foo(){vfunc_called(this, "_ZN6dd71703fooEv");}
dd7170 ::~dd7170(){ note_dtor("dd7170", this);} // tgen
dd7170 ::dd7170(){ note_ctor("dd7170", this);} // tgen

static void Test_dd7170()
{
  extern Class_Descriptor cd_dd7170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd7170, buf);
    dd7170 *dp, &lv = *(dp=new (buf) dd7170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd7170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,24), "dd7170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,16), "dd7170");
    check_base_class_offset(lv, (cc170*), ABISELECT(16,8), "dd7170");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7170.d");
    test_class_info(&lv, &cd_dd7170);
    dp->~dd7170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7170(Test_dd7170, "dd7170", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd7170C1Ev();
extern void _ZN6dd7170D1Ev();
Name_Map name_map_dd7170[] = {
  NSPAIR(_ZN6dd7170C1Ev),
  NSPAIR(_ZN6dd7170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
static Base_Class bases_dd7170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
extern VTBL_ENTRY _ZTV6dd7170[];
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__6dd7170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd7170[] = {
  {&(_ZTV6dd7170[5]),  5,18},
  {&(_ZTV6dd7170[11]),  11,18},
  {&(_ZTV6dd7170[16]),  16,18},
  {&(_tg__ZTV5cc170__6dd7170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__6dd7170[5]),  5,7},
  {&(_tg__ZTV4bb70__6dd7170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7170 = {  "dd7170", // class name
  bases_dd7170, 3,
  &(vtc_dd7170[0]), // expected_vtbl_contents
  &(vtt_dd7170[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd7170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7170),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07170  : dd7170 {
  int e;
  ~ee07170(); // tgen
  ee07170(); // tgen
};
//SIG(1 ee07170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee07170 ::~ee07170(){ note_dtor("ee07170", this);} // tgen
ee07170 ::ee07170(){ note_ctor("ee07170", this);} // tgen

static void Test_ee07170()
{
  extern Class_Descriptor cd_ee07170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee07170, buf);
    ee07170 *dp, &lv = *(dp=new (buf) ee07170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee07170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee07170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee07170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(16,12), "ee07170");
    check_base_class_offset(lv, (dd7170*), 0, "ee07170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07170.e");
    test_class_info(&lv, &cd_ee07170);
    dp->~ee07170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07170(Test_ee07170, "ee07170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee07170C1Ev();
extern void _ZN7ee07170D1Ev();
Name_Map name_map_ee07170[] = {
  NSPAIR(_ZN7ee07170C1Ev),
  NSPAIR(_ZN7ee07170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee07170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee07170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
extern VTBL_ENTRY _ZTV7ee07170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee07170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee07170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee07170[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee07170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee07170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee07170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee07170[] = {
  {&(_ZTV7ee07170[5]),  5,18},
  {&(_tg__ZTV6dd7170__7ee07170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee07170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee07170[5]),  5,7},
  {&(_ZTV7ee07170[11]),  11,18},
  {&(_ZTV7ee07170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee07170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee07170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee07170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee07170[];
extern  VTBL_ENTRY _ZTV7ee07170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07170[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07170 = {  "ee07170", // class name
  bases_ee07170, 4,
  &(vtc_ee07170[0]), // expected_vtbl_contents
  &(vtt_ee07170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee07170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17170  : virtual dd7170 {
  int e;
  ~ee17170(); // tgen
  ee17170(); // tgen
};
//SIG(1 ee17170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee17170 ::~ee17170(){ note_dtor("ee17170", this);} // tgen
ee17170 ::ee17170(){ note_ctor("ee17170", this);} // tgen

static void Test_ee17170()
{
  extern Class_Descriptor cd_ee17170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee17170, buf);
    ee17170 *dp, &lv = *(dp=new (buf) ee17170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee17170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee17170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee17170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(32,16), "ee17170");
    check_base_class_offset(lv, (dd7170*), ABISELECT(16,8), "ee17170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17170.e");
    test_class_info(&lv, &cd_ee17170);
    dp->~ee17170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17170(Test_ee17170, "ee17170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee17170C1Ev();
extern void _ZN7ee17170D1Ev();
Name_Map name_map_ee17170[] = {
  NSPAIR(_ZN7ee17170C1Ev),
  NSPAIR(_ZN7ee17170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee17170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17170[0]),
  0,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17170[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee17170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
extern VTBL_ENTRY _ZTV7ee17170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee17170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee17170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee17170[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee17170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee17170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee17170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee17170[] = {
  {&(_ZTV7ee17170[6]),  6,26},
  {&(_ZTV7ee17170[13]),  13,26},
  {&(_ZTV7ee17170[19]),  19,26},
  {&(_ZTV7ee17170[24]),  24,26},
  {&(_tg__ZTV6dd7170__7ee17170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee17170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee17170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee17170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee17170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee17170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee17170[];
extern  VTBL_ENTRY _ZTV7ee17170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17170[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17170 = {  "ee17170", // class name
  bases_ee17170, 4,
  &(vtc_ee17170[0]), // expected_vtbl_contents
  &(vtt_ee17170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee17170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17170),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27170  : dd7170 {
  int e;
  virtual void  foo(); // _ZN7ee271703fooEv
  ~ee27170(); // tgen
  ee27170(); // tgen
};
//SIG(1 ee27170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27170 ::foo(){vfunc_called(this, "_ZN7ee271703fooEv");}
ee27170 ::~ee27170(){ note_dtor("ee27170", this);} // tgen
ee27170 ::ee27170(){ note_ctor("ee27170", this);} // tgen

static void Test_ee27170()
{
  extern Class_Descriptor cd_ee27170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee27170, buf);
    ee27170 *dp, &lv = *(dp=new (buf) ee27170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee27170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee27170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee27170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(16,12), "ee27170");
    check_base_class_offset(lv, (dd7170*), 0, "ee27170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27170.e");
    test_class_info(&lv, &cd_ee27170);
    dp->~ee27170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27170(Test_ee27170, "ee27170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee27170C1Ev();
extern void _ZN7ee27170D1Ev();
Name_Map name_map_ee27170[] = {
  NSPAIR(_ZN7ee27170C1Ev),
  NSPAIR(_ZN7ee27170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee27170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27170[];
extern void _ZN6dd71703barEv();
extern void _ZN7ee271703fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee271703fooEv,_ZTv0_n20_N7ee271703fooEv)();
extern void ABISELECT(_ZThn32_N7ee271703fooEv,_ZThn20_N7ee271703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN7ee271703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee27170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee271703fooEv,_ZTv0_n20_N7ee271703fooEv),
};
extern VTBL_ENTRY _ZTV7ee27170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee27170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee27170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee27170[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee27170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee27170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee27170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee27170[] = {
  {&(_ZTV7ee27170[5]),  5,18},
  {&(_tg__ZTV6dd7170__7ee27170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee27170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee27170[5]),  5,7},
  {&(_ZTV7ee27170[11]),  11,18},
  {&(_ZTV7ee27170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee27170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee27170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee27170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee27170[];
extern  VTBL_ENTRY _ZTV7ee27170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27170[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee271703fooEv,_ZTv0_n20_N7ee271703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee271703fooEv,_ZThn20_N7ee271703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27170 = {  "ee27170", // class name
  bases_ee27170, 4,
  &(vtc_ee27170[0]), // expected_vtbl_contents
  &(vtt_ee27170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee27170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37170  : virtual dd7170 {
  int e;
  virtual void  foo(); // _ZN7ee371703fooEv
  ~ee37170(); // tgen
  ee37170(); // tgen
};
//SIG(1 ee37170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37170 ::foo(){vfunc_called(this, "_ZN7ee371703fooEv");}
ee37170 ::~ee37170(){ note_dtor("ee37170", this);} // tgen
ee37170 ::ee37170(){ note_ctor("ee37170", this);} // tgen

static void Test_ee37170()
{
  extern Class_Descriptor cd_ee37170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee37170, buf);
    ee37170 *dp, &lv = *(dp=new (buf) ee37170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee37170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee37170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee37170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(32,16), "ee37170");
    check_base_class_offset(lv, (dd7170*), ABISELECT(16,8), "ee37170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37170.e");
    test_class_info(&lv, &cd_ee37170);
    dp->~ee37170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37170(Test_ee37170, "ee37170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee37170C1Ev();
extern void _ZN7ee37170D1Ev();
Name_Map name_map_ee37170[] = {
  NSPAIR(_ZN7ee37170C1Ev),
  NSPAIR(_ZN7ee37170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee37170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37170[];
extern void _ZN7ee371703fooEv();
extern void _ZN6dd71703barEv();
extern void ABISELECT(_ZTv0_n56_N7ee371703fooEv,_ZTv0_n28_N7ee371703fooEv)();
extern void ABISELECT(_ZThn16_N7ee371703fooEv,_ZThn8_N7ee371703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee371703fooEv,_ZTv0_n20_N7ee371703fooEv)();
extern void ABISELECT(_ZThn48_N7ee371703fooEv,_ZThn24_N7ee371703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37170[0]),
  (VTBL_ENTRY)&_ZN7ee371703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee371703fooEv,_ZTv0_n28_N7ee371703fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37170[0]),
  ABISELECT(-48,-24),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee37170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee371703fooEv,_ZTv0_n20_N7ee371703fooEv),
};
extern VTBL_ENTRY _ZTV7ee37170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee37170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee37170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee37170[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee37170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee37170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee37170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee37170[] = {
  {&(_ZTV7ee37170[6]),  6,27},
  {&(_ZTV7ee37170[14]),  14,27},
  {&(_ZTV7ee37170[20]),  20,27},
  {&(_ZTV7ee37170[25]),  25,27},
  {&(_tg__ZTV6dd7170__7ee37170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee37170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee37170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee37170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee37170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee37170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee37170[];
extern  VTBL_ENTRY _ZTV7ee37170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37170[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee371703fooEv,_ZTv0_n20_N7ee371703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee371703fooEv,_ZThn24_N7ee371703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee371703fooEv,_ZTv0_n28_N7ee371703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371703fooEv,_ZThn8_N7ee371703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37170 = {  "ee37170", // class name
  bases_ee37170, 4,
  &(vtc_ee37170[0]), // expected_vtbl_contents
  &(vtt_ee37170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee37170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37170),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47170  : dd7170 {
  int e;
  virtual void  bar(); // _ZN7ee471703barEv
  ~ee47170(); // tgen
  ee47170(); // tgen
};
//SIG(1 ee47170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47170 ::bar(){vfunc_called(this, "_ZN7ee471703barEv");}
ee47170 ::~ee47170(){ note_dtor("ee47170", this);} // tgen
ee47170 ::ee47170(){ note_ctor("ee47170", this);} // tgen

static void Test_ee47170()
{
  extern Class_Descriptor cd_ee47170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee47170, buf);
    ee47170 *dp, &lv = *(dp=new (buf) ee47170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee47170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee47170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee47170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(16,12), "ee47170");
    check_base_class_offset(lv, (dd7170*), 0, "ee47170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47170.e");
    test_class_info(&lv, &cd_ee47170);
    dp->~ee47170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47170(Test_ee47170, "ee47170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee47170C1Ev();
extern void _ZN7ee47170D1Ev();
Name_Map name_map_ee47170[] = {
  NSPAIR(_ZN7ee47170C1Ev),
  NSPAIR(_ZN7ee47170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee47170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47170[];
extern void _ZN7ee471703barEv();
extern void _ZN6dd71703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee471703barEv,_ZTv0_n16_N7ee471703barEv)();
extern void ABISELECT(_ZThn32_N7ee471703barEv,_ZThn20_N7ee471703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47170[0]),
  (VTBL_ENTRY)&_ZN7ee471703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee47170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee471703barEv,_ZTv0_n16_N7ee471703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
extern VTBL_ENTRY _ZTV7ee47170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee47170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee47170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee47170[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee47170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee47170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee47170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee47170[] = {
  {&(_ZTV7ee47170[5]),  5,18},
  {&(_tg__ZTV6dd7170__7ee47170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee47170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee47170[5]),  5,7},
  {&(_ZTV7ee47170[11]),  11,18},
  {&(_ZTV7ee47170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee47170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee47170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee47170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee47170[];
extern  VTBL_ENTRY _ZTV7ee47170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47170[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee471703barEv,_ZTv0_n16_N7ee471703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee471703barEv,_ZThn20_N7ee471703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47170 = {  "ee47170", // class name
  bases_ee47170, 4,
  &(vtc_ee47170[0]), // expected_vtbl_contents
  &(vtt_ee47170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee47170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names108,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57170  : virtual dd7170 {
  int e;
  virtual void  bar(); // _ZN7ee571703barEv
  ~ee57170(); // tgen
  ee57170(); // tgen
};
//SIG(1 ee57170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57170 ::bar(){vfunc_called(this, "_ZN7ee571703barEv");}
ee57170 ::~ee57170(){ note_dtor("ee57170", this);} // tgen
ee57170 ::ee57170(){ note_ctor("ee57170", this);} // tgen

static void Test_ee57170()
{
  extern Class_Descriptor cd_ee57170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee57170, buf);
    ee57170 *dp, &lv = *(dp=new (buf) ee57170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee57170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee57170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee57170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(32,16), "ee57170");
    check_base_class_offset(lv, (dd7170*), ABISELECT(16,8), "ee57170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57170.e");
    test_class_info(&lv, &cd_ee57170);
    dp->~ee57170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57170(Test_ee57170, "ee57170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee57170C1Ev();
extern void _ZN7ee57170D1Ev();
Name_Map name_map_ee57170[] = {
  NSPAIR(_ZN7ee57170C1Ev),
  NSPAIR(_ZN7ee57170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee57170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57170[];
extern void _ZN7ee571703barEv();
extern void ABISELECT(_ZTv0_n48_N7ee571703barEv,_ZTv0_n24_N7ee571703barEv)();
extern void ABISELECT(_ZThn16_N7ee571703barEv,_ZThn8_N7ee571703barEv)() __attribute__((weak));
extern void _ZN6dd71703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee571703barEv,_ZTv0_n16_N7ee571703barEv)();
extern void ABISELECT(_ZThn48_N7ee571703barEv,_ZThn24_N7ee571703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57170[0]),
  (VTBL_ENTRY)&_ZN7ee571703barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee571703barEv,_ZTv0_n24_N7ee571703barEv),
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57170[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee57170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee571703barEv,_ZTv0_n16_N7ee571703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
extern VTBL_ENTRY _ZTV7ee57170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee57170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee57170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee57170[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee57170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee57170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee57170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee57170[] = {
  {&(_ZTV7ee57170[6]),  6,27},
  {&(_ZTV7ee57170[14]),  14,27},
  {&(_ZTV7ee57170[20]),  20,27},
  {&(_ZTV7ee57170[25]),  25,27},
  {&(_tg__ZTV6dd7170__7ee57170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee57170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee57170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee57170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee57170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee57170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee57170[];
extern  VTBL_ENTRY _ZTV7ee57170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57170[];
static VTBL_ENTRY alt_thunk_names109[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee571703barEv,_ZTv0_n16_N7ee571703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee571703barEv,_ZThn24_N7ee571703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee571703barEv,_ZTv0_n24_N7ee571703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571703barEv,_ZThn8_N7ee571703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57170 = {  "ee57170", // class name
  bases_ee57170, 4,
  &(vtc_ee57170[0]), // expected_vtbl_contents
  &(vtt_ee57170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee57170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57170),27, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names109,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67170  : dd7170 {
  int e;
  virtual void  foo(); // _ZN7ee671703fooEv
  virtual void  bar(); // _ZN7ee671703barEv
  ~ee67170(); // tgen
  ee67170(); // tgen
};
//SIG(1 ee67170) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67170 ::foo(){vfunc_called(this, "_ZN7ee671703fooEv");}
void  ee67170 ::bar(){vfunc_called(this, "_ZN7ee671703barEv");}
ee67170 ::~ee67170(){ note_dtor("ee67170", this);} // tgen
ee67170 ::ee67170(){ note_ctor("ee67170", this);} // tgen

static void Test_ee67170()
{
  extern Class_Descriptor cd_ee67170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee67170, buf);
    ee67170 *dp, &lv = *(dp=new (buf) ee67170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee67170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(44,28), "ee67170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(32,20), "ee67170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(16,12), "ee67170");
    check_base_class_offset(lv, (dd7170*), 0, "ee67170");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67170.e");
    test_class_info(&lv, &cd_ee67170);
    dp->~ee67170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67170(Test_ee67170, "ee67170", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee67170C1Ev();
extern void _ZN7ee67170D1Ev();
Name_Map name_map_ee67170[] = {
  NSPAIR(_ZN7ee67170C1Ev),
  NSPAIR(_ZN7ee67170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee67170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67170[];
extern void _ZN7ee671703barEv();
extern void _ZN7ee671703fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee671703barEv,_ZTv0_n16_N7ee671703barEv)();
extern void ABISELECT(_ZThn32_N7ee671703barEv,_ZThn20_N7ee671703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee671703fooEv,_ZTv0_n20_N7ee671703fooEv)();
extern void ABISELECT(_ZThn32_N7ee671703fooEv,_ZThn20_N7ee671703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67170[0]),
  (VTBL_ENTRY)&_ZN7ee671703barEv,
  (VTBL_ENTRY)&_ZN7ee671703fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67170[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee67170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee671703barEv,_ZTv0_n16_N7ee671703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee671703fooEv,_ZTv0_n20_N7ee671703fooEv),
};
extern VTBL_ENTRY _ZTV7ee67170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee67170[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee67170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee67170[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee67170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee67170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee67170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee67170[] = {
  {&(_ZTV7ee67170[5]),  5,18},
  {&(_tg__ZTV6dd7170__7ee67170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee67170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee67170[5]),  5,7},
  {&(_ZTV7ee67170[11]),  11,18},
  {&(_ZTV7ee67170[16]),  16,18},
  {&(_tg__ZTV5cc170__7ee67170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee67170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee67170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee67170[];
extern  VTBL_ENTRY _ZTV7ee67170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67170[];
static VTBL_ENTRY alt_thunk_names110[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn20_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn20_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee671703fooEv,_ZTv0_n20_N7ee671703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671703fooEv,_ZThn20_N7ee671703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee671703barEv,_ZTv0_n16_N7ee671703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671703barEv,_ZThn20_N7ee671703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67170 = {  "ee67170", // class name
  bases_ee67170, 4,
  &(vtc_ee67170[0]), // expected_vtbl_contents
  &(vtt_ee67170[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee67170),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67170),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67170),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names110,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77170  : virtual dd7170 {
  int e;
  virtual void  foo(); // _ZN7ee771703fooEv
  virtual void  bar(); // _ZN7ee771703barEv
  ~ee77170(); // tgen
  ee77170(); // tgen
};
//SIG(1 ee77170) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77170 ::foo(){vfunc_called(this, "_ZN7ee771703fooEv");}
void  ee77170 ::bar(){vfunc_called(this, "_ZN7ee771703barEv");}
ee77170 ::~ee77170(){ note_dtor("ee77170", this);} // tgen
ee77170 ::ee77170(){ note_ctor("ee77170", this);} // tgen

static void Test_ee77170()
{
  extern Class_Descriptor cd_ee77170;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee77170, buf);
    ee77170 *dp, &lv = *(dp=new (buf) ee77170());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee77170)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77170)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(60,32), "ee77170");
    check_base_class_offset(lv, (bb70*)(cc170*), ABISELECT(48,24), "ee77170");
    check_base_class_offset(lv, (cc170*)(dd7170*), ABISELECT(32,16), "ee77170");
    check_base_class_offset(lv, (dd7170*), ABISELECT(16,8), "ee77170");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77170.e");
    test_class_info(&lv, &cd_ee77170);
    dp->~ee77170();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77170(Test_ee77170, "ee77170", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee77170C1Ev();
extern void _ZN7ee77170D1Ev();
Name_Map name_map_ee77170[] = {
  NSPAIR(_ZN7ee77170C1Ev),
  NSPAIR(_ZN7ee77170D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc170;
extern VTBL_ENTRY _ZTI5cc170[];
extern  VTBL_ENTRY _ZTV5cc170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc170[];
extern Class_Descriptor cd_dd7170;
extern VTBL_ENTRY _ZTI6dd7170[];
extern  VTBL_ENTRY _ZTV6dd7170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7170[];
static Base_Class bases_ee77170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(48,24), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc170,    ABISELECT(32,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7170,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77170[];
extern void _ZN7ee771703fooEv();
extern void _ZN7ee771703barEv();
extern void ABISELECT(_ZTv0_n48_N7ee771703barEv,_ZTv0_n24_N7ee771703barEv)();
extern void ABISELECT(_ZThn16_N7ee771703barEv,_ZThn8_N7ee771703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7ee771703fooEv,_ZTv0_n28_N7ee771703fooEv)();
extern void ABISELECT(_ZThn16_N7ee771703fooEv,_ZThn8_N7ee771703fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee771703barEv,_ZTv0_n16_N7ee771703barEv)();
extern void ABISELECT(_ZThn48_N7ee771703barEv,_ZThn24_N7ee771703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee771703fooEv,_ZTv0_n20_N7ee771703fooEv)();
extern void ABISELECT(_ZThn48_N7ee771703fooEv,_ZThn24_N7ee771703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77170[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77170[0]),
  (VTBL_ENTRY)&_ZN7ee771703fooEv,
  (VTBL_ENTRY)&_ZN7ee771703barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771703barEv,_ZTv0_n24_N7ee771703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee771703fooEv,_ZTv0_n28_N7ee771703fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77170[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee77170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee771703barEv,_ZTv0_n16_N7ee771703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee771703fooEv,_ZTv0_n20_N7ee771703fooEv),
};
extern VTBL_ENTRY _ZTV7ee77170[];
extern void _ZN6dd71703barEv();
extern void _ZN6dd71703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7170__7ee77170[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&_ZN6dd71703barEv,
  (VTBL_ENTRY)&_ZN6dd71703fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc170__6dd7170__7ee77170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv)();
extern void ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv)();
extern void ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb70__6dd7170__7ee77170[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7170[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc170__7ee77170[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc170__7ee77170[] = {
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc170[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__7ee77170[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee77170[] = {
  {&(_ZTV7ee77170[6]),  6,28},
  {&(_ZTV7ee77170[15]),  15,28},
  {&(_ZTV7ee77170[21]),  21,28},
  {&(_ZTV7ee77170[26]),  26,28},
  {&(_tg__ZTV6dd7170__7ee77170[5]),  5,7},
  {&(_tg__ZTV5cc170__6dd7170__7ee77170[4]),  4,4},
  {&(_tg__ZTV4bb70__6dd7170__7ee77170[5]),  5,7},
  {&(_tg__ZTV5cc170__7ee77170[4]),  4,4},
  {&(_tg__ZTV4bb70__5cc170__7ee77170[5]),  5,7},
  {&(_tg__ZTV4bb70__7ee77170[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee77170[];
extern  VTBL_ENTRY _ZTV7ee77170[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77170[];
static VTBL_ENTRY alt_thunk_names111[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6dd71703fooEv,_ZTv0_n20_N6dd71703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703fooEv,_ZThn16_N6dd71703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71703barEv,_ZTv0_n16_N6dd71703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71703barEv,_ZThn16_N6dd71703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee771703fooEv,_ZTv0_n20_N7ee771703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771703fooEv,_ZThn24_N7ee771703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee771703barEv,_ZTv0_n16_N7ee771703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771703barEv,_ZThn24_N7ee771703barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee771703fooEv,_ZTv0_n28_N7ee771703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771703fooEv,_ZThn8_N7ee771703fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771703barEv,_ZTv0_n24_N7ee771703barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771703barEv,_ZThn8_N7ee771703barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77170 = {  "ee77170", // class name
  bases_ee77170, 4,
  &(vtc_ee77170[0]), // expected_vtbl_contents
  &(vtt_ee77170[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee77170),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77170),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77170),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names111,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc270  : bb70 {
  int c;
  virtual void  foo(); // _ZN5cc2703fooEv
  ~cc270(); // tgen
  cc270(); // tgen
};
//SIG(-1 cc270) C1{ BC2{ VBC3{ Fi} v2 v1 Fi} v1 Fi}


void  cc270 ::foo(){vfunc_called(this, "_ZN5cc2703fooEv");}
cc270 ::~cc270(){ note_dtor("cc270", this);} // tgen
cc270 ::cc270(){ note_ctor("cc270", this);} // tgen

static void Test_cc270()
{
  extern Class_Descriptor cd_cc270;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc270, buf);
    cc270 *dp, &lv = *(dp=new (buf) cc270());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc270)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc270)");
    check_base_class_offset(lv, (aa0*)(bb70*), ABISELECT(16,12), "cc270");
    check_base_class_offset(lv, (bb70*), 0, "cc270");
    check_field_offset(lv, c, ABISELECT(12,8), "cc270.c");
    test_class_info(&lv, &cd_cc270);
    dp->~cc270();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc270(Test_cc270, "cc270", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc270C1Ev();
extern void _ZN5cc270D1Ev();
Name_Map name_map_cc270[] = {
  NSPAIR(_ZN5cc270C1Ev),
  NSPAIR(_ZN5cc270D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
static Base_Class bases_cc270[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY vtc_cc270[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern VTBL_ENTRY _ZTV5cc270[];
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb70__5cc270[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_cc270[] = {
  {&(_ZTV5cc270[3]),  3,5},
  {&(_tg__ZTV4bb70__5cc270[3]),  3,5},
};
extern VTBL_ENTRY _ZTI5cc270[];
extern  VTBL_ENTRY _ZTV5cc270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc270[];
Class_Descriptor cd_cc270 = {  "cc270", // class name
  bases_cc270, 2,
  &(vtc_cc270[0]), // expected_vtbl_contents
  &(vtt_cc270[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc270),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc270),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc270),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0270  : cc270 {
  int d;
  ~dd0270(); // tgen
  dd0270(); // tgen
};
//SIG(-1 dd0270) C1{ BC2{ BC3{ VBC4{ Fi} v2 v1 Fi} v1 Fi} Fi}


dd0270 ::~dd0270(){ note_dtor("dd0270", this);} // tgen
dd0270 ::dd0270(){ note_ctor("dd0270", this);} // tgen

static void Test_dd0270()
{
  extern Class_Descriptor cd_dd0270;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0270, buf);
    dd0270 *dp, &lv = *(dp=new (buf) dd0270());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0270)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0270)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc270*), ABISELECT(20,16), "dd0270");
    check_base_class_offset(lv, (bb70*)(cc270*), 0, "dd0270");
    check_base_class_offset(lv, (cc270*), 0, "dd0270");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0270.d");
    test_class_info(&lv, &cd_dd0270);
    dp->~dd0270();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0270(Test_dd0270, "dd0270", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0270C1Ev();
extern void _ZN6dd0270D1Ev();
Name_Map name_map_dd0270[] = {
  NSPAIR(_ZN6dd0270C1Ev),
  NSPAIR(_ZN6dd0270D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc270;
extern VTBL_ENTRY _ZTI5cc270[];
extern  VTBL_ENTRY _ZTV5cc270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc270[];
static Base_Class bases_dd0270[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc270,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY vtc_dd0270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern VTBL_ENTRY _ZTV6dd0270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc270__6dd0270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc270__6dd0270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_dd0270[] = {
  {&(_ZTV6dd0270[3]),  3,5},
  {&(_tg__ZTV5cc270__6dd0270[3]),  3,5},
  {&(_tg__ZTV4bb705cc270__6dd0270[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd0270[];
extern  VTBL_ENTRY _ZTV6dd0270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0270[];
Class_Descriptor cd_dd0270 = {  "dd0270", // class name
  bases_dd0270, 3,
  &(vtc_dd0270[0]), // expected_vtbl_contents
  &(vtt_dd0270[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0270),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0270),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0270),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00270  : dd0270 {
  int e;
  ~ee00270(); // tgen
  ee00270(); // tgen
};
//SIG(1 ee00270) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} v1 Fi} Fi} Fi}


ee00270 ::~ee00270(){ note_dtor("ee00270", this);} // tgen
ee00270 ::ee00270(){ note_ctor("ee00270", this);} // tgen

static void Test_ee00270()
{
  extern Class_Descriptor cd_ee00270;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00270, buf);
    ee00270 *dp, &lv = *(dp=new (buf) ee00270());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00270)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00270)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc270*)(dd0270*), ABISELECT(24,20), "ee00270");
    check_base_class_offset(lv, (bb70*)(cc270*)(dd0270*), 0, "ee00270");
    check_base_class_offset(lv, (cc270*)(dd0270*), 0, "ee00270");
    check_base_class_offset(lv, (dd0270*), 0, "ee00270");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00270.e");
    test_class_info(&lv, &cd_ee00270);
    dp->~ee00270();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00270(Test_ee00270, "ee00270", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00270C1Ev();
extern void _ZN7ee00270D1Ev();
Name_Map name_map_ee00270[] = {
  NSPAIR(_ZN7ee00270C1Ev),
  NSPAIR(_ZN7ee00270D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc270;
extern VTBL_ENTRY _ZTI5cc270[];
extern  VTBL_ENTRY _ZTV5cc270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc270[];
extern Class_Descriptor cd_dd0270;
extern VTBL_ENTRY _ZTI6dd0270[];
extern  VTBL_ENTRY _ZTV6dd0270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0270[];
static Base_Class bases_ee00270[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc270,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0270,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY vtc_ee00270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern VTBL_ENTRY _ZTV7ee00270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0270__7ee00270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2706dd0270__7ee00270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc2706dd0270__7ee00270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee00270[] = {
  {&(_ZTV7ee00270[3]),  3,5},
  {&(_tg__ZTV6dd0270__7ee00270[3]),  3,5},
  {&(_tg__ZTV5cc2706dd0270__7ee00270[3]),  3,5},
  {&(_tg__ZTV4bb705cc2706dd0270__7ee00270[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee00270[];
extern  VTBL_ENTRY _ZTV7ee00270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00270[];
Class_Descriptor cd_ee00270 = {  "ee00270", // class name
  bases_ee00270, 4,
  &(vtc_ee00270[0]), // expected_vtbl_contents
  &(vtt_ee00270[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00270),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00270),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00270),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10270  : virtual dd0270 {
  int e;
  ~ee10270(); // tgen
  ee10270(); // tgen
};
//SIG(1 ee10270) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} v1 Fi} Fi} Fi}


ee10270 ::~ee10270(){ note_dtor("ee10270", this);} // tgen
ee10270 ::ee10270(){ note_ctor("ee10270", this);} // tgen

static void Test_ee10270()
{
  extern Class_Descriptor cd_ee10270;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10270, buf);
    ee10270 *dp, &lv = *(dp=new (buf) ee10270());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10270)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10270)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc270*)(dd0270*), ABISELECT(36,24), "ee10270");
    check_base_class_offset(lv, (bb70*)(cc270*)(dd0270*), ABISELECT(16,8), "ee10270");
    check_base_class_offset(lv, (cc270*)(dd0270*), ABISELECT(16,8), "ee10270");
    check_base_class_offset(lv, (dd0270*), ABISELECT(16,8), "ee10270");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10270.e");
    test_class_info(&lv, &cd_ee10270);
    dp->~ee10270();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10270(Test_ee10270, "ee10270", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10270C1Ev();
extern void _ZN7ee10270D1Ev();
Name_Map name_map_ee10270[] = {
  NSPAIR(_ZN7ee10270C1Ev),
  NSPAIR(_ZN7ee10270D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc270;
extern VTBL_ENTRY _ZTI5cc270[];
extern  VTBL_ENTRY _ZTV5cc270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc270[];
extern Class_Descriptor cd_dd0270;
extern VTBL_ENTRY _ZTI6dd0270[];
extern  VTBL_ENTRY _ZTV6dd0270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0270[];
static Base_Class bases_ee10270[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc270,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0270,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY vtc_ee10270[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10270[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern VTBL_ENTRY _ZTV7ee10270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0270__7ee10270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2706dd0270__7ee10270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc2706dd0270__7ee10270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee10270[] = {
  {&(_ZTV7ee10270[4]),  4,11},
  {&(_ZTV7ee10270[9]),  9,11},
  {&(_tg__ZTV6dd0270__7ee10270[3]),  3,5},
  {&(_tg__ZTV5cc2706dd0270__7ee10270[3]),  3,5},
  {&(_tg__ZTV4bb705cc2706dd0270__7ee10270[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee10270[];
extern  VTBL_ENTRY _ZTV7ee10270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10270[];
Class_Descriptor cd_ee10270 = {  "ee10270", // class name
  bases_ee10270, 4,
  &(vtc_ee10270[0]), // expected_vtbl_contents
  &(vtt_ee10270[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10270),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10270),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10270),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20270  : dd0270 {
  int e;
  virtual void  foo(); // _ZN7ee202703fooEv
  ~ee20270(); // tgen
  ee20270(); // tgen
};
//SIG(1 ee20270) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee20270 ::foo(){vfunc_called(this, "_ZN7ee202703fooEv");}
ee20270 ::~ee20270(){ note_dtor("ee20270", this);} // tgen
ee20270 ::ee20270(){ note_ctor("ee20270", this);} // tgen

static void Test_ee20270()
{
  extern Class_Descriptor cd_ee20270;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20270, buf);
    ee20270 *dp, &lv = *(dp=new (buf) ee20270());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20270)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20270)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc270*)(dd0270*), ABISELECT(24,20), "ee20270");
    check_base_class_offset(lv, (bb70*)(cc270*)(dd0270*), 0, "ee20270");
    check_base_class_offset(lv, (cc270*)(dd0270*), 0, "ee20270");
    check_base_class_offset(lv, (dd0270*), 0, "ee20270");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20270.e");
    test_class_info(&lv, &cd_ee20270);
    dp->~ee20270();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20270(Test_ee20270, "ee20270", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20270C1Ev();
extern void _ZN7ee20270D1Ev();
Name_Map name_map_ee20270[] = {
  NSPAIR(_ZN7ee20270C1Ev),
  NSPAIR(_ZN7ee20270D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc270;
extern VTBL_ENTRY _ZTI5cc270[];
extern  VTBL_ENTRY _ZTV5cc270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc270[];
extern Class_Descriptor cd_dd0270;
extern VTBL_ENTRY _ZTI6dd0270[];
extern  VTBL_ENTRY _ZTV6dd0270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0270[];
static Base_Class bases_ee20270[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc270,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0270,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20270[];
extern void _ZN4bb703barEv();
extern void _ZN7ee202703fooEv();
static  VTBL_ENTRY vtc_ee20270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN7ee202703fooEv,
};
extern VTBL_ENTRY _ZTV7ee20270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0270__7ee20270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2706dd0270__7ee20270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc2706dd0270__7ee20270[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee20270[] = {
  {&(_ZTV7ee20270[3]),  3,5},
  {&(_tg__ZTV6dd0270__7ee20270[3]),  3,5},
  {&(_tg__ZTV5cc2706dd0270__7ee20270[3]),  3,5},
  {&(_tg__ZTV4bb705cc2706dd0270__7ee20270[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee20270[];
extern  VTBL_ENTRY _ZTV7ee20270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20270[];
Class_Descriptor cd_ee20270 = {  "ee20270", // class name
  bases_ee20270, 4,
  &(vtc_ee20270[0]), // expected_vtbl_contents
  &(vtt_ee20270[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20270),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20270),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20270),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30270  : virtual dd0270 {
  int e;
  virtual void  foo(); // _ZN7ee302703fooEv
  ~ee30270(); // tgen
  ee30270(); // tgen
};
//SIG(1 ee30270) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee30270 ::foo(){vfunc_called(this, "_ZN7ee302703fooEv");}
ee30270 ::~ee30270(){ note_dtor("ee30270", this);} // tgen
ee30270 ::ee30270(){ note_ctor("ee30270", this);} // tgen

static void Test_ee30270()
{
  extern Class_Descriptor cd_ee30270;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30270, buf);
    ee30270 *dp, &lv = *(dp=new (buf) ee30270());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30270)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30270)");
    check_base_class_offset(lv, (aa0*)(bb70*)(cc270*)(dd0270*), ABISELECT(36,24), "ee30270");
    check_base_class_offset(lv, (bb70*)(cc270*)(dd0270*), ABISELECT(16,8), "ee30270");
    check_base_class_offset(lv, (cc270*)(dd0270*), ABISELECT(16,8), "ee30270");
    check_base_class_offset(lv, (dd0270*), ABISELECT(16,8), "ee30270");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30270.e");
    test_class_info(&lv, &cd_ee30270);
    dp->~ee30270();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30270(Test_ee30270, "ee30270", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30270C1Ev();
extern void _ZN7ee30270D1Ev();
Name_Map name_map_ee30270[] = {
  NSPAIR(_ZN7ee30270C1Ev),
  NSPAIR(_ZN7ee30270D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb70;
extern VTBL_ENTRY _ZTI4bb70[];
extern  VTBL_ENTRY _ZTV4bb70[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb70[];
extern Class_Descriptor cd_cc270;
extern VTBL_ENTRY _ZTI5cc270[];
extern  VTBL_ENTRY _ZTV5cc270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc270[];
extern Class_Descriptor cd_dd0270;
extern VTBL_ENTRY _ZTI6dd0270[];
extern  VTBL_ENTRY _ZTV6dd0270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0270[];
static Base_Class bases_ee30270[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb70,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc270,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0270,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30270[];
extern void _ZN7ee302703fooEv();
extern void _ZN4bb703barEv();
extern void ABISELECT(_ZTv0_n40_N7ee302703fooEv,_ZTv0_n20_N7ee302703fooEv)();
extern void ABISELECT(_ZThn16_N7ee302703fooEv,_ZThn8_N7ee302703fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30270[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30270[0]),
  (VTBL_ENTRY)&_ZN7ee302703fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee302703fooEv,_ZTv0_n20_N7ee302703fooEv),
};
extern VTBL_ENTRY _ZTV7ee30270[];
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0270__7ee30270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN5cc2703fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2706dd0270__7ee30270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc270[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN5cc2703fooEv,
};
extern void _ZN4bb703barEv();
extern void _ZN4bb703fooEv();
static  VTBL_ENTRY _tg__ZTV4bb705cc2706dd0270__7ee30270[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb70[0]),
  (VTBL_ENTRY)&_ZN4bb703barEv,
  (VTBL_ENTRY)&_ZN4bb703fooEv,
};
static  VTT_ENTRY vtt_ee30270[] = {
  {&(_ZTV7ee30270[4]),  4,12},
  {&(_ZTV7ee30270[10]),  10,12},
  {&(_tg__ZTV6dd0270__7ee30270[3]),  3,5},
  {&(_tg__ZTV5cc2706dd0270__7ee30270[3]),  3,5},
  {&(_tg__ZTV4bb705cc2706dd0270__7ee30270[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee30270[];
extern  VTBL_ENTRY _ZTV7ee30270[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30270[];
static VTBL_ENTRY alt_thunk_names112[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee302703fooEv,_ZTv0_n20_N7ee302703fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302703fooEv,_ZThn8_N7ee302703fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descrip