// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb60  : aa0 {
  int b;
  virtual void  bar(); // _ZN4bb603barEv
  virtual void  foo(); // _ZN4bb603fooEv
  ~bb60(); // tgen
  bb60(); // tgen
};
//SIG(-1 bb60) C1{ BC2{ Fi} v1 v2 Fi}


void  bb60 ::bar(){vfunc_called(this, "_ZN4bb603barEv");}
void  bb60 ::foo(){vfunc_called(this, "_ZN4bb603fooEv");}
bb60 ::~bb60(){ note_dtor("bb60", this);} // tgen
bb60 ::bb60(){ note_ctor("bb60", this);} // tgen

static void Test_bb60()
{
  extern Class_Descriptor cd_bb60;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_bb60, buf);
    bb60 *dp, &lv = *(dp=new (buf) bb60());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(bb60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb60)");
    check_base_class_offset(lv, (aa0*), ABISELECT(8,4), "bb60");
    check_field_offset(lv, b, ABISELECT(12,8), "bb60.b");
    test_class_info(&lv, &cd_bb60);
    dp->~bb60();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb60(Test_bb60, "bb60", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN4bb60C1Ev();
extern void _ZN4bb60D1Ev();
Name_Map name_map_bb60[] = {
  NSPAIR(_ZN4bb60C1Ev),
  NSPAIR(_ZN4bb60D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4bb60[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_bb60[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb60[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
Class_Descriptor cd_bb60 = {  "bb60", // class name
  bases_bb60, 1,
  &(vtc_bb60[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI4bb60),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4bb60),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc060  : bb60 {
  int c;
  ~cc060(); // tgen
  cc060(); // tgen
};
//SIG(-1 cc060) C1{ BC2{ BC3{ Fi} v1 v2 Fi} Fi}


cc060 ::~cc060(){ note_dtor("cc060", this);} // tgen
cc060 ::cc060(){ note_ctor("cc060", this);} // tgen

static void Test_cc060()
{
  extern Class_Descriptor cd_cc060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc060, buf);
    cc060 *dp, &lv = *(dp=new (buf) cc060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc060)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(8,4), "cc060");
    check_base_class_offset(lv, (bb60*), 0, "cc060");
    check_field_offset(lv, c, ABISELECT(16,12), "cc060.c");
    test_class_info(&lv, &cd_cc060);
    dp->~cc060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc060(Test_cc060, "cc060", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc060C1Ev();
extern void _ZN5cc060D1Ev();
Name_Map name_map_cc060[] = {
  NSPAIR(_ZN5cc060C1Ev),
  NSPAIR(_ZN5cc060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
static Base_Class bases_cc060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc060[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_cc060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5cc060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
Class_Descriptor cd_cc060 = {  "cc060", // class name
  bases_cc060, 2,
  &(vtc_cc060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0060  : cc060 {
  int d;
  ~dd0060(); // tgen
  dd0060(); // tgen
};
//SIG(-1 dd0060) C1{ BC2{ BC3{ BC4{ Fi} v1 v2 Fi} Fi} Fi}


dd0060 ::~dd0060(){ note_dtor("dd0060", this);} // tgen
dd0060 ::dd0060(){ note_ctor("dd0060", this);} // tgen

static void Test_dd0060()
{
  extern Class_Descriptor cd_dd0060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0060, buf);
    dd0060 *dp, &lv = *(dp=new (buf) dd0060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(8,4), "dd0060");
    check_base_class_offset(lv, (bb60*)(cc060*), 0, "dd0060");
    check_base_class_offset(lv, (cc060*), 0, "dd0060");
    check_field_offset(lv, d, ABISELECT(20,16), "dd0060.d");
    test_class_info(&lv, &cd_dd0060);
    dp->~dd0060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0060(Test_dd0060, "dd0060", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0060C1Ev();
extern void _ZN6dd0060D1Ev();
Name_Map name_map_dd0060[] = {
  NSPAIR(_ZN6dd0060C1Ev),
  NSPAIR(_ZN6dd0060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd0060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0060[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd0060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd0060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
Class_Descriptor cd_dd0060 = {  "dd0060", // class name
  bases_dd0060, 3,
  &(vtc_dd0060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00060  : dd0060 {
  int e;
  ~ee00060(); // tgen
  ee00060(); // tgen
};
//SIG(1 ee00060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee00060 ::~ee00060(){ note_dtor("ee00060", this);} // tgen
ee00060 ::ee00060(){ note_ctor("ee00060", this);} // tgen

static void Test_ee00060()
{
  extern Class_Descriptor cd_ee00060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00060, buf);
    ee00060 *dp, &lv = *(dp=new (buf) ee00060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(8,4), "ee00060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), 0, "ee00060");
    check_base_class_offset(lv, (cc060*)(dd0060*), 0, "ee00060");
    check_base_class_offset(lv, (dd0060*), 0, "ee00060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee00060.e");
    test_class_info(&lv, &cd_ee00060);
    dp->~ee00060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00060(Test_ee00060, "ee00060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00060C1Ev();
extern void _ZN7ee00060D1Ev();
Name_Map name_map_ee00060[] = {
  NSPAIR(_ZN7ee00060C1Ev),
  NSPAIR(_ZN7ee00060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee00060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00060[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee00060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee00060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI7ee00060[];
extern  VTBL_ENTRY _ZTV7ee00060[];
Class_Descriptor cd_ee00060 = {  "ee00060", // class name
  bases_ee00060, 4,
  &(vtc_ee00060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10060  : virtual dd0060 {
  int e;
  ~ee10060(); // tgen
  ee10060(); // tgen
};
//SIG(1 ee10060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee10060 ::~ee10060(){ note_dtor("ee10060", this);} // tgen
ee10060 ::ee10060(){ note_ctor("ee10060", this);} // tgen

static void Test_ee10060()
{
  extern Class_Descriptor cd_ee10060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10060, buf);
    ee10060 *dp, &lv = *(dp=new (buf) ee10060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(24,12), "ee10060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), ABISELECT(16,8), "ee10060");
    check_base_class_offset(lv, (cc060*)(dd0060*), ABISELECT(16,8), "ee10060");
    check_base_class_offset(lv, (dd0060*), ABISELECT(16,8), "ee10060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10060.e");
    test_class_info(&lv, &cd_ee10060);
    dp->~ee10060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10060(Test_ee10060, "ee10060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10060C1Ev();
extern void _ZN7ee10060D1Ev();
Name_Map name_map_ee10060[] = {
  NSPAIR(_ZN7ee10060C1Ev),
  NSPAIR(_ZN7ee10060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee10060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10060[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee10060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10060[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee10060[];
static  VTT_ENTRY vtt_ee10060[] = {
  {&(_ZTV7ee10060[3]),  3,9},
  {&(_ZTV7ee10060[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee10060[];
extern  VTBL_ENTRY _ZTV7ee10060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10060[];
Class_Descriptor cd_ee10060 = {  "ee10060", // class name
  bases_ee10060, 4,
  &(vtc_ee10060[0]), // expected_vtbl_contents
  &(vtt_ee10060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10060),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20060  : dd0060 {
  int e;
  virtual void  foo(); // _ZN7ee200603fooEv
  ~ee20060(); // tgen
  ee20060(); // tgen
};
//SIG(1 ee20060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee20060 ::foo(){vfunc_called(this, "_ZN7ee200603fooEv");}
ee20060 ::~ee20060(){ note_dtor("ee20060", this);} // tgen
ee20060 ::ee20060(){ note_ctor("ee20060", this);} // tgen

static void Test_ee20060()
{
  extern Class_Descriptor cd_ee20060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20060, buf);
    ee20060 *dp, &lv = *(dp=new (buf) ee20060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(8,4), "ee20060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), 0, "ee20060");
    check_base_class_offset(lv, (cc060*)(dd0060*), 0, "ee20060");
    check_base_class_offset(lv, (dd0060*), 0, "ee20060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20060.e");
    test_class_info(&lv, &cd_ee20060);
    dp->~ee20060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20060(Test_ee20060, "ee20060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20060C1Ev();
extern void _ZN7ee20060D1Ev();
Name_Map name_map_ee20060[] = {
  NSPAIR(_ZN7ee20060C1Ev),
  NSPAIR(_ZN7ee20060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee20060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20060[];
extern void _ZN4bb603barEv();
extern void _ZN7ee200603fooEv();
static  VTBL_ENTRY vtc_ee20060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN7ee200603fooEv,
};
extern VTBL_ENTRY _ZTI7ee20060[];
extern  VTBL_ENTRY _ZTV7ee20060[];
Class_Descriptor cd_ee20060 = {  "ee20060", // class name
  bases_ee20060, 4,
  &(vtc_ee20060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30060  : virtual dd0060 {
  int e;
  virtual void  foo(); // _ZN7ee300603fooEv
  ~ee30060(); // tgen
  ee30060(); // tgen
};
//SIG(1 ee30060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee30060 ::foo(){vfunc_called(this, "_ZN7ee300603fooEv");}
ee30060 ::~ee30060(){ note_dtor("ee30060", this);} // tgen
ee30060 ::ee30060(){ note_ctor("ee30060", this);} // tgen

static void Test_ee30060()
{
  extern Class_Descriptor cd_ee30060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30060, buf);
    ee30060 *dp, &lv = *(dp=new (buf) ee30060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(24,12), "ee30060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), ABISELECT(16,8), "ee30060");
    check_base_class_offset(lv, (cc060*)(dd0060*), ABISELECT(16,8), "ee30060");
    check_base_class_offset(lv, (dd0060*), ABISELECT(16,8), "ee30060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30060.e");
    test_class_info(&lv, &cd_ee30060);
    dp->~ee30060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30060(Test_ee30060, "ee30060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30060C1Ev();
extern void _ZN7ee30060D1Ev();
Name_Map name_map_ee30060[] = {
  NSPAIR(_ZN7ee30060C1Ev),
  NSPAIR(_ZN7ee30060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee30060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30060[];
extern void _ZN7ee300603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee300603fooEv,_ZTv0_n16_N7ee300603fooEv)();
extern void ABISELECT(_ZThn16_N7ee300603fooEv,_ZThn8_N7ee300603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30060[0]),
  (VTBL_ENTRY)&_ZN7ee300603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee300603fooEv,_ZTv0_n16_N7ee300603fooEv),
};
extern VTBL_ENTRY _ZTV7ee30060[];
static  VTT_ENTRY vtt_ee30060[] = {
  {&(_ZTV7ee30060[3]),  3,10},
  {&(_ZTV7ee30060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee30060[];
extern  VTBL_ENTRY _ZTV7ee30060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30060[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee300603fooEv,_ZTv0_n16_N7ee300603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee300603fooEv,_ZThn8_N7ee300603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30060 = {  "ee30060", // class name
  bases_ee30060, 4,
  &(vtc_ee30060[0]), // expected_vtbl_contents
  &(vtt_ee30060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40060  : dd0060 {
  int e;
  virtual void  bar(); // _ZN7ee400603barEv
  ~ee40060(); // tgen
  ee40060(); // tgen
};
//SIG(1 ee40060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee40060 ::bar(){vfunc_called(this, "_ZN7ee400603barEv");}
ee40060 ::~ee40060(){ note_dtor("ee40060", this);} // tgen
ee40060 ::ee40060(){ note_ctor("ee40060", this);} // tgen

static void Test_ee40060()
{
  extern Class_Descriptor cd_ee40060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40060, buf);
    ee40060 *dp, &lv = *(dp=new (buf) ee40060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(8,4), "ee40060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), 0, "ee40060");
    check_base_class_offset(lv, (cc060*)(dd0060*), 0, "ee40060");
    check_base_class_offset(lv, (dd0060*), 0, "ee40060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40060.e");
    test_class_info(&lv, &cd_ee40060);
    dp->~ee40060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40060(Test_ee40060, "ee40060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40060C1Ev();
extern void _ZN7ee40060D1Ev();
Name_Map name_map_ee40060[] = {
  NSPAIR(_ZN7ee40060C1Ev),
  NSPAIR(_ZN7ee40060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee40060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40060[];
extern void _ZN7ee400603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee40060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40060[0]),
  (VTBL_ENTRY)&_ZN7ee400603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI7ee40060[];
extern  VTBL_ENTRY _ZTV7ee40060[];
Class_Descriptor cd_ee40060 = {  "ee40060", // class name
  bases_ee40060, 4,
  &(vtc_ee40060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50060  : virtual dd0060 {
  int e;
  virtual void  bar(); // _ZN7ee500603barEv
  ~ee50060(); // tgen
  ee50060(); // tgen
};
//SIG(1 ee50060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee50060 ::bar(){vfunc_called(this, "_ZN7ee500603barEv");}
ee50060 ::~ee50060(){ note_dtor("ee50060", this);} // tgen
ee50060 ::ee50060(){ note_ctor("ee50060", this);} // tgen

static void Test_ee50060()
{
  extern Class_Descriptor cd_ee50060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50060, buf);
    ee50060 *dp, &lv = *(dp=new (buf) ee50060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(24,12), "ee50060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), ABISELECT(16,8), "ee50060");
    check_base_class_offset(lv, (cc060*)(dd0060*), ABISELECT(16,8), "ee50060");
    check_base_class_offset(lv, (dd0060*), ABISELECT(16,8), "ee50060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50060.e");
    test_class_info(&lv, &cd_ee50060);
    dp->~ee50060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50060(Test_ee50060, "ee50060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50060C1Ev();
extern void _ZN7ee50060D1Ev();
Name_Map name_map_ee50060[] = {
  NSPAIR(_ZN7ee50060C1Ev),
  NSPAIR(_ZN7ee50060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee50060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50060[];
extern void _ZN7ee500603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee500603barEv,_ZTv0_n12_N7ee500603barEv)();
extern void ABISELECT(_ZThn16_N7ee500603barEv,_ZThn8_N7ee500603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee50060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50060[0]),
  (VTBL_ENTRY)&_ZN7ee500603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee500603barEv,_ZTv0_n12_N7ee500603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee50060[];
static  VTT_ENTRY vtt_ee50060[] = {
  {&(_ZTV7ee50060[3]),  3,10},
  {&(_ZTV7ee50060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee50060[];
extern  VTBL_ENTRY _ZTV7ee50060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50060[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee500603barEv,_ZTv0_n12_N7ee500603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee500603barEv,_ZThn8_N7ee500603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50060 = {  "ee50060", // class name
  bases_ee50060, 4,
  &(vtc_ee50060[0]), // expected_vtbl_contents
  &(vtt_ee50060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60060  : dd0060 {
  int e;
  virtual void  foo(); // _ZN7ee600603fooEv
  virtual void  bar(); // _ZN7ee600603barEv
  ~ee60060(); // tgen
  ee60060(); // tgen
};
//SIG(1 ee60060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60060 ::foo(){vfunc_called(this, "_ZN7ee600603fooEv");}
void  ee60060 ::bar(){vfunc_called(this, "_ZN7ee600603barEv");}
ee60060 ::~ee60060(){ note_dtor("ee60060", this);} // tgen
ee60060 ::ee60060(){ note_ctor("ee60060", this);} // tgen

static void Test_ee60060()
{
  extern Class_Descriptor cd_ee60060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60060, buf);
    ee60060 *dp, &lv = *(dp=new (buf) ee60060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(8,4), "ee60060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), 0, "ee60060");
    check_base_class_offset(lv, (cc060*)(dd0060*), 0, "ee60060");
    check_base_class_offset(lv, (dd0060*), 0, "ee60060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60060.e");
    test_class_info(&lv, &cd_ee60060);
    dp->~ee60060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60060(Test_ee60060, "ee60060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60060C1Ev();
extern void _ZN7ee60060D1Ev();
Name_Map name_map_ee60060[] = {
  NSPAIR(_ZN7ee60060C1Ev),
  NSPAIR(_ZN7ee60060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee60060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60060[];
extern void _ZN7ee600603barEv();
extern void _ZN7ee600603fooEv();
static  VTBL_ENTRY vtc_ee60060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60060[0]),
  (VTBL_ENTRY)&_ZN7ee600603barEv,
  (VTBL_ENTRY)&_ZN7ee600603fooEv,
};
extern VTBL_ENTRY _ZTI7ee60060[];
extern  VTBL_ENTRY _ZTV7ee60060[];
Class_Descriptor cd_ee60060 = {  "ee60060", // class name
  bases_ee60060, 4,
  &(vtc_ee60060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70060  : virtual dd0060 {
  int e;
  virtual void  foo(); // _ZN7ee700603fooEv
  virtual void  bar(); // _ZN7ee700603barEv
  ~ee70060(); // tgen
  ee70060(); // tgen
};
//SIG(1 ee70060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70060 ::foo(){vfunc_called(this, "_ZN7ee700603fooEv");}
void  ee70060 ::bar(){vfunc_called(this, "_ZN7ee700603barEv");}
ee70060 ::~ee70060(){ note_dtor("ee70060", this);} // tgen
ee70060 ::ee70060(){ note_ctor("ee70060", this);} // tgen

static void Test_ee70060()
{
  extern Class_Descriptor cd_ee70060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70060, buf);
    ee70060 *dp, &lv = *(dp=new (buf) ee70060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd0060*), ABISELECT(24,12), "ee70060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd0060*), ABISELECT(16,8), "ee70060");
    check_base_class_offset(lv, (cc060*)(dd0060*), ABISELECT(16,8), "ee70060");
    check_base_class_offset(lv, (dd0060*), ABISELECT(16,8), "ee70060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70060.e");
    test_class_info(&lv, &cd_ee70060);
    dp->~ee70060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70060(Test_ee70060, "ee70060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70060C1Ev();
extern void _ZN7ee70060D1Ev();
Name_Map name_map_ee70060[] = {
  NSPAIR(_ZN7ee70060C1Ev),
  NSPAIR(_ZN7ee70060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd0060;
extern VTBL_ENTRY _ZTI6dd0060[];
extern  VTBL_ENTRY _ZTV6dd0060[];
static Base_Class bases_ee70060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70060[];
extern void _ZN7ee700603fooEv();
extern void _ZN7ee700603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee700603barEv,_ZTv0_n12_N7ee700603barEv)();
extern void ABISELECT(_ZThn16_N7ee700603barEv,_ZThn8_N7ee700603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee700603fooEv,_ZTv0_n16_N7ee700603fooEv)();
extern void ABISELECT(_ZThn16_N7ee700603fooEv,_ZThn8_N7ee700603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70060[0]),
  (VTBL_ENTRY)&_ZN7ee700603fooEv,
  (VTBL_ENTRY)&_ZN7ee700603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee700603barEv,_ZTv0_n12_N7ee700603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee700603fooEv,_ZTv0_n16_N7ee700603fooEv),
};
extern VTBL_ENTRY _ZTV7ee70060[];
static  VTT_ENTRY vtt_ee70060[] = {
  {&(_ZTV7ee70060[3]),  3,11},
  {&(_ZTV7ee70060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee70060[];
extern  VTBL_ENTRY _ZTV7ee70060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70060[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee700603fooEv,_ZTv0_n16_N7ee700603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700603fooEv,_ZThn8_N7ee700603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee700603barEv,_ZTv0_n12_N7ee700603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700603barEv,_ZThn8_N7ee700603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70060 = {  "ee70060", // class name
  bases_ee70060, 4,
  &(vtc_ee70060[0]), // expected_vtbl_contents
  &(vtt_ee70060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1060  : virtual cc060 {
  int d;
  ~dd1060(); // tgen
  dd1060(); // tgen
};
//SIG(-1 dd1060) C1{ VBC2{ BC3{ BC4{ Fi} v1 v2 Fi} Fi} Fi}


dd1060 ::~dd1060(){ note_dtor("dd1060", this);} // tgen
dd1060 ::dd1060(){ note_ctor("dd1060", this);} // tgen

static void Test_dd1060()
{
  extern Class_Descriptor cd_dd1060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1060, buf);
    dd1060 *dp, &lv = *(dp=new (buf) dd1060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,12), "dd1060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,8), "dd1060");
    check_base_class_offset(lv, (cc060*), ABISELECT(16,8), "dd1060");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1060.d");
    test_class_info(&lv, &cd_dd1060);
    dp->~dd1060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1060(Test_dd1060, "dd1060", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1060C1Ev();
extern void _ZN6dd1060D1Ev();
Name_Map name_map_dd1060[] = {
  NSPAIR(_ZN6dd1060C1Ev),
  NSPAIR(_ZN6dd1060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd1060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1060[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd1060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV6dd1060[];
static  VTT_ENTRY vtt_dd1060[] = {
  {&(_ZTV6dd1060[3]),  3,9},
  {&(_ZTV6dd1060[7]),  7,9},
};
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
Class_Descriptor cd_dd1060 = {  "dd1060", // class name
  bases_dd1060, 3,
  &(vtc_dd1060[0]), // expected_vtbl_contents
  &(vtt_dd1060[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1060),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1060),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01060  : dd1060 {
  int e;
  ~ee01060(); // tgen
  ee01060(); // tgen
};
//SIG(1 ee01060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee01060 ::~ee01060(){ note_dtor("ee01060", this);} // tgen
ee01060 ::ee01060(){ note_ctor("ee01060", this);} // tgen

static void Test_ee01060()
{
  extern Class_Descriptor cd_ee01060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01060, buf);
    ee01060 *dp, &lv = *(dp=new (buf) ee01060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee01060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee01060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(16,12), "ee01060");
    check_base_class_offset(lv, (dd1060*), 0, "ee01060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01060.e");
    test_class_info(&lv, &cd_ee01060);
    dp->~ee01060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01060(Test_ee01060, "ee01060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01060C1Ev();
extern void _ZN7ee01060D1Ev();
Name_Map name_map_ee01060[] = {
  NSPAIR(_ZN7ee01060C1Ev),
  NSPAIR(_ZN7ee01060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee01060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01060[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee01060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01060[0]),
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee01060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee01060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee01060[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee01060[] = {
  {&(_ZTV7ee01060[3]),  3,9},
  {&(_tg__ZTV6dd1060__7ee01060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee01060[4]),  4,6},
  {&(_ZTV7ee01060[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee01060[];
extern  VTBL_ENTRY _ZTV7ee01060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01060[];
Class_Descriptor cd_ee01060 = {  "ee01060", // class name
  bases_ee01060, 4,
  &(vtc_ee01060[0]), // expected_vtbl_contents
  &(vtt_ee01060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01060),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11060  : virtual dd1060 {
  int e;
  ~ee11060(); // tgen
  ee11060(); // tgen
};
//SIG(1 ee11060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee11060 ::~ee11060(){ note_dtor("ee11060", this);} // tgen
ee11060 ::ee11060(){ note_ctor("ee11060", this);} // tgen

static void Test_ee11060()
{
  extern Class_Descriptor cd_ee11060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11060, buf);
    ee11060 *dp, &lv = *(dp=new (buf) ee11060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee11060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee11060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(32,16), "ee11060");
    check_base_class_offset(lv, (dd1060*), ABISELECT(16,8), "ee11060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11060.e");
    test_class_info(&lv, &cd_ee11060);
    dp->~ee11060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11060(Test_ee11060, "ee11060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11060C1Ev();
extern void _ZN7ee11060D1Ev();
Name_Map name_map_ee11060[] = {
  NSPAIR(_ZN7ee11060C1Ev),
  NSPAIR(_ZN7ee11060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee11060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11060[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee11060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11060[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11060[0]),
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee11060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee11060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee11060[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee11060[] = {
  {&(_ZTV7ee11060[4]),  4,13},
  {&(_ZTV7ee11060[7]),  7,13},
  {&(_ZTV7ee11060[11]),  11,13},
  {&(_tg__ZTV6dd1060__7ee11060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee11060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee11060[];
extern  VTBL_ENTRY _ZTV7ee11060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11060[];
Class_Descriptor cd_ee11060 = {  "ee11060", // class name
  bases_ee11060, 4,
  &(vtc_ee11060[0]), // expected_vtbl_contents
  &(vtt_ee11060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11060),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21060  : dd1060 {
  int e;
  virtual void  foo(); // _ZN7ee210603fooEv
  ~ee21060(); // tgen
  ee21060(); // tgen
};
//SIG(1 ee21060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee21060 ::foo(){vfunc_called(this, "_ZN7ee210603fooEv");}
ee21060 ::~ee21060(){ note_dtor("ee21060", this);} // tgen
ee21060 ::ee21060(){ note_ctor("ee21060", this);} // tgen

static void Test_ee21060()
{
  extern Class_Descriptor cd_ee21060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21060, buf);
    ee21060 *dp, &lv = *(dp=new (buf) ee21060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee21060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee21060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(16,12), "ee21060");
    check_base_class_offset(lv, (dd1060*), 0, "ee21060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21060.e");
    test_class_info(&lv, &cd_ee21060);
    dp->~ee21060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21060(Test_ee21060, "ee21060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21060C1Ev();
extern void _ZN7ee21060D1Ev();
Name_Map name_map_ee21060[] = {
  NSPAIR(_ZN7ee21060C1Ev),
  NSPAIR(_ZN7ee21060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee21060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21060[];
extern void _ZN7ee210603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee210603fooEv,_ZTv0_n16_N7ee210603fooEv)();
extern void ABISELECT(_ZThn16_N7ee210603fooEv,_ZThn12_N7ee210603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21060[0]),
  (VTBL_ENTRY)&_ZN7ee210603fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee210603fooEv,_ZTv0_n16_N7ee210603fooEv),
};
extern VTBL_ENTRY _ZTV7ee21060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee21060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee21060[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee21060[] = {
  {&(_ZTV7ee21060[3]),  3,10},
  {&(_tg__ZTV6dd1060__7ee21060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee21060[4]),  4,6},
  {&(_ZTV7ee21060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee21060[];
extern  VTBL_ENTRY _ZTV7ee21060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21060[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee210603fooEv,_ZTv0_n16_N7ee210603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee210603fooEv,_ZThn12_N7ee210603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21060 = {  "ee21060", // class name
  bases_ee21060, 4,
  &(vtc_ee21060[0]), // expected_vtbl_contents
  &(vtt_ee21060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31060  : virtual dd1060 {
  int e;
  virtual void  foo(); // _ZN7ee310603fooEv
  ~ee31060(); // tgen
  ee31060(); // tgen
};
//SIG(1 ee31060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee31060 ::foo(){vfunc_called(this, "_ZN7ee310603fooEv");}
ee31060 ::~ee31060(){ note_dtor("ee31060", this);} // tgen
ee31060 ::ee31060(){ note_ctor("ee31060", this);} // tgen

static void Test_ee31060()
{
  extern Class_Descriptor cd_ee31060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31060, buf);
    ee31060 *dp, &lv = *(dp=new (buf) ee31060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee31060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee31060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(32,16), "ee31060");
    check_base_class_offset(lv, (dd1060*), ABISELECT(16,8), "ee31060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31060.e");
    test_class_info(&lv, &cd_ee31060);
    dp->~ee31060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31060(Test_ee31060, "ee31060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31060C1Ev();
extern void _ZN7ee31060D1Ev();
Name_Map name_map_ee31060[] = {
  NSPAIR(_ZN7ee31060C1Ev),
  NSPAIR(_ZN7ee31060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee31060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31060[];
extern void _ZN7ee310603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee310603fooEv,_ZTv0_n16_N7ee310603fooEv)();
extern void ABISELECT(_ZThn32_N7ee310603fooEv,_ZThn16_N7ee310603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31060[0]),
  (VTBL_ENTRY)&_ZN7ee310603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31060[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee310603fooEv,_ZTv0_n16_N7ee310603fooEv),
};
extern VTBL_ENTRY _ZTV7ee31060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee31060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee31060[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee31060[] = {
  {&(_ZTV7ee31060[4]),  4,14},
  {&(_ZTV7ee31060[8]),  8,14},
  {&(_ZTV7ee31060[12]),  12,14},
  {&(_tg__ZTV6dd1060__7ee31060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee31060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee31060[];
extern  VTBL_ENTRY _ZTV7ee31060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31060[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee310603fooEv,_ZTv0_n16_N7ee310603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee310603fooEv,_ZThn16_N7ee310603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31060 = {  "ee31060", // class name
  bases_ee31060, 4,
  &(vtc_ee31060[0]), // expected_vtbl_contents
  &(vtt_ee31060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31060),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41060  : dd1060 {
  int e;
  virtual void  bar(); // _ZN7ee410603barEv
  ~ee41060(); // tgen
  ee41060(); // tgen
};
//SIG(1 ee41060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee41060 ::bar(){vfunc_called(this, "_ZN7ee410603barEv");}
ee41060 ::~ee41060(){ note_dtor("ee41060", this);} // tgen
ee41060 ::ee41060(){ note_ctor("ee41060", this);} // tgen

static void Test_ee41060()
{
  extern Class_Descriptor cd_ee41060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41060, buf);
    ee41060 *dp, &lv = *(dp=new (buf) ee41060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee41060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee41060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(16,12), "ee41060");
    check_base_class_offset(lv, (dd1060*), 0, "ee41060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41060.e");
    test_class_info(&lv, &cd_ee41060);
    dp->~ee41060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41060(Test_ee41060, "ee41060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41060C1Ev();
extern void _ZN7ee41060D1Ev();
Name_Map name_map_ee41060[] = {
  NSPAIR(_ZN7ee41060C1Ev),
  NSPAIR(_ZN7ee41060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee41060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41060[];
extern void _ZN7ee410603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee410603barEv,_ZTv0_n12_N7ee410603barEv)();
extern void ABISELECT(_ZThn16_N7ee410603barEv,_ZThn12_N7ee410603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee41060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41060[0]),
  (VTBL_ENTRY)&_ZN7ee410603barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee410603barEv,_ZTv0_n12_N7ee410603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee41060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee41060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee41060[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee41060[] = {
  {&(_ZTV7ee41060[3]),  3,10},
  {&(_tg__ZTV6dd1060__7ee41060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee41060[4]),  4,6},
  {&(_ZTV7ee41060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee41060[];
extern  VTBL_ENTRY _ZTV7ee41060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41060[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee410603barEv,_ZTv0_n12_N7ee410603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee410603barEv,_ZThn12_N7ee410603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41060 = {  "ee41060", // class name
  bases_ee41060, 4,
  &(vtc_ee41060[0]), // expected_vtbl_contents
  &(vtt_ee41060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51060  : virtual dd1060 {
  int e;
  virtual void  bar(); // _ZN7ee510603barEv
  ~ee51060(); // tgen
  ee51060(); // tgen
};
//SIG(1 ee51060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee51060 ::bar(){vfunc_called(this, "_ZN7ee510603barEv");}
ee51060 ::~ee51060(){ note_dtor("ee51060", this);} // tgen
ee51060 ::ee51060(){ note_ctor("ee51060", this);} // tgen

static void Test_ee51060()
{
  extern Class_Descriptor cd_ee51060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51060, buf);
    ee51060 *dp, &lv = *(dp=new (buf) ee51060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee51060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee51060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(32,16), "ee51060");
    check_base_class_offset(lv, (dd1060*), ABISELECT(16,8), "ee51060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51060.e");
    test_class_info(&lv, &cd_ee51060);
    dp->~ee51060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51060(Test_ee51060, "ee51060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51060C1Ev();
extern void _ZN7ee51060D1Ev();
Name_Map name_map_ee51060[] = {
  NSPAIR(_ZN7ee51060C1Ev),
  NSPAIR(_ZN7ee51060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee51060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51060[];
extern void _ZN7ee510603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee510603barEv,_ZTv0_n12_N7ee510603barEv)();
extern void ABISELECT(_ZThn32_N7ee510603barEv,_ZThn16_N7ee510603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee51060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51060[0]),
  (VTBL_ENTRY)&_ZN7ee510603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51060[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee510603barEv,_ZTv0_n12_N7ee510603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee51060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee51060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee51060[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee51060[] = {
  {&(_ZTV7ee51060[4]),  4,14},
  {&(_ZTV7ee51060[8]),  8,14},
  {&(_ZTV7ee51060[12]),  12,14},
  {&(_tg__ZTV6dd1060__7ee51060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee51060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee51060[];
extern  VTBL_ENTRY _ZTV7ee51060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51060[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee510603barEv,_ZTv0_n12_N7ee510603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee510603barEv,_ZThn16_N7ee510603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51060 = {  "ee51060", // class name
  bases_ee51060, 4,
  &(vtc_ee51060[0]), // expected_vtbl_contents
  &(vtt_ee51060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51060),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61060  : dd1060 {
  int e;
  virtual void  foo(); // _ZN7ee610603fooEv
  virtual void  bar(); // _ZN7ee610603barEv
  ~ee61060(); // tgen
  ee61060(); // tgen
};
//SIG(1 ee61060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61060 ::foo(){vfunc_called(this, "_ZN7ee610603fooEv");}
void  ee61060 ::bar(){vfunc_called(this, "_ZN7ee610603barEv");}
ee61060 ::~ee61060(){ note_dtor("ee61060", this);} // tgen
ee61060 ::ee61060(){ note_ctor("ee61060", this);} // tgen

static void Test_ee61060()
{
  extern Class_Descriptor cd_ee61060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61060, buf);
    ee61060 *dp, &lv = *(dp=new (buf) ee61060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee61060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee61060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(16,12), "ee61060");
    check_base_class_offset(lv, (dd1060*), 0, "ee61060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61060.e");
    test_class_info(&lv, &cd_ee61060);
    dp->~ee61060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61060(Test_ee61060, "ee61060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61060C1Ev();
extern void _ZN7ee61060D1Ev();
Name_Map name_map_ee61060[] = {
  NSPAIR(_ZN7ee61060C1Ev),
  NSPAIR(_ZN7ee61060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee61060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61060[];
extern void _ZN7ee610603fooEv();
extern void _ZN7ee610603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee610603barEv,_ZTv0_n12_N7ee610603barEv)();
extern void ABISELECT(_ZThn16_N7ee610603barEv,_ZThn12_N7ee610603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee610603fooEv,_ZTv0_n16_N7ee610603fooEv)();
extern void ABISELECT(_ZThn16_N7ee610603fooEv,_ZThn12_N7ee610603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61060[0]),
  (VTBL_ENTRY)&_ZN7ee610603fooEv,
  (VTBL_ENTRY)&_ZN7ee610603barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee610603barEv,_ZTv0_n12_N7ee610603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee610603fooEv,_ZTv0_n16_N7ee610603fooEv),
};
extern VTBL_ENTRY _ZTV7ee61060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee61060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee61060[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee61060[] = {
  {&(_ZTV7ee61060[3]),  3,11},
  {&(_tg__ZTV6dd1060__7ee61060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee61060[4]),  4,6},
  {&(_ZTV7ee61060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee61060[];
extern  VTBL_ENTRY _ZTV7ee61060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61060[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee610603fooEv,_ZTv0_n16_N7ee610603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610603fooEv,_ZThn12_N7ee610603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee610603barEv,_ZTv0_n12_N7ee610603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610603barEv,_ZThn12_N7ee610603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61060 = {  "ee61060", // class name
  bases_ee61060, 4,
  &(vtc_ee61060[0]), // expected_vtbl_contents
  &(vtt_ee61060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71060  : virtual dd1060 {
  int e;
  virtual void  foo(); // _ZN7ee710603fooEv
  virtual void  bar(); // _ZN7ee710603barEv
  ~ee71060(); // tgen
  ee71060(); // tgen
};
//SIG(1 ee71060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71060 ::foo(){vfunc_called(this, "_ZN7ee710603fooEv");}
void  ee71060 ::bar(){vfunc_called(this, "_ZN7ee710603barEv");}
ee71060 ::~ee71060(){ note_dtor("ee71060", this);} // tgen
ee71060 ::ee71060(){ note_ctor("ee71060", this);} // tgen

static void Test_ee71060()
{
  extern Class_Descriptor cd_ee71060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71060, buf);
    ee71060 *dp, &lv = *(dp=new (buf) ee71060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee71060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee71060");
    check_base_class_offset(lv, (cc060*)(dd1060*), ABISELECT(32,16), "ee71060");
    check_base_class_offset(lv, (dd1060*), ABISELECT(16,8), "ee71060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71060.e");
    test_class_info(&lv, &cd_ee71060);
    dp->~ee71060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71060(Test_ee71060, "ee71060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71060C1Ev();
extern void _ZN7ee71060D1Ev();
Name_Map name_map_ee71060[] = {
  NSPAIR(_ZN7ee71060C1Ev),
  NSPAIR(_ZN7ee71060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd1060;
extern VTBL_ENTRY _ZTI6dd1060[];
extern  VTBL_ENTRY _ZTV6dd1060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1060[];
static Base_Class bases_ee71060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1060,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71060[];
extern void _ZN7ee710603fooEv();
extern void _ZN7ee710603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee710603barEv,_ZTv0_n12_N7ee710603barEv)();
extern void ABISELECT(_ZThn32_N7ee710603barEv,_ZThn16_N7ee710603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee710603fooEv,_ZTv0_n16_N7ee710603fooEv)();
extern void ABISELECT(_ZThn32_N7ee710603fooEv,_ZThn16_N7ee710603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71060[0]),
  (VTBL_ENTRY)&_ZN7ee710603fooEv,
  (VTBL_ENTRY)&_ZN7ee710603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71060[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee710603barEv,_ZTv0_n12_N7ee710603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee710603fooEv,_ZTv0_n16_N7ee710603fooEv),
};
extern VTBL_ENTRY _ZTV7ee71060[];
static  VTBL_ENTRY _tg__ZTV6dd1060__7ee71060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd1060__7ee71060[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee71060[] = {
  {&(_ZTV7ee71060[4]),  4,15},
  {&(_ZTV7ee71060[9]),  9,15},
  {&(_ZTV7ee71060[13]),  13,15},
  {&(_tg__ZTV6dd1060__7ee71060[3]),  3,3},
  {&(_tg__ZTV4bb605cc060__6dd1060__7ee71060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee71060[];
extern  VTBL_ENTRY _ZTV7ee71060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71060[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee710603fooEv,_ZTv0_n16_N7ee710603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710603fooEv,_ZThn16_N7ee710603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee710603barEv,_ZTv0_n12_N7ee710603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710603barEv,_ZThn16_N7ee710603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71060 = {  "ee71060", // class name
  bases_ee71060, 4,
  &(vtc_ee71060[0]), // expected_vtbl_contents
  &(vtt_ee71060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71060),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2060  : cc060 {
  int d;
  virtual void  foo(); // _ZN6dd20603fooEv
  ~dd2060(); // tgen
  dd2060(); // tgen
};
//SIG(-1 dd2060) C1{ BC2{ BC3{ BC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd2060 ::foo(){vfunc_called(this, "_ZN6dd20603fooEv");}
dd2060 ::~dd2060(){ note_dtor("dd2060", this);} // tgen
dd2060 ::dd2060(){ note_ctor("dd2060", this);} // tgen

static void Test_dd2060()
{
  extern Class_Descriptor cd_dd2060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2060, buf);
    dd2060 *dp, &lv = *(dp=new (buf) dd2060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(8,4), "dd2060");
    check_base_class_offset(lv, (bb60*)(cc060*), 0, "dd2060");
    check_base_class_offset(lv, (cc060*), 0, "dd2060");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2060.d");
    test_class_info(&lv, &cd_dd2060);
    dp->~dd2060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2060(Test_dd2060, "dd2060", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2060C1Ev();
extern void _ZN6dd2060D1Ev();
Name_Map name_map_dd2060[] = {
  NSPAIR(_ZN6dd2060C1Ev),
  NSPAIR(_ZN6dd2060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd2060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2060[];
extern void _ZN4bb603barEv();
extern void _ZN6dd20603fooEv();
static  VTBL_ENTRY vtc_dd2060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN6dd20603fooEv,
};
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
Class_Descriptor cd_dd2060 = {  "dd2060", // class name
  bases_dd2060, 3,
  &(vtc_dd2060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02060  : dd2060 {
  int e;
  ~ee02060(); // tgen
  ee02060(); // tgen
};
//SIG(1 ee02060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee02060 ::~ee02060(){ note_dtor("ee02060", this);} // tgen
ee02060 ::ee02060(){ note_ctor("ee02060", this);} // tgen

static void Test_ee02060()
{
  extern Class_Descriptor cd_ee02060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02060, buf);
    ee02060 *dp, &lv = *(dp=new (buf) ee02060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(8,4), "ee02060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), 0, "ee02060");
    check_base_class_offset(lv, (cc060*)(dd2060*), 0, "ee02060");
    check_base_class_offset(lv, (dd2060*), 0, "ee02060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02060.e");
    test_class_info(&lv, &cd_ee02060);
    dp->~ee02060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02060(Test_ee02060, "ee02060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02060C1Ev();
extern void _ZN7ee02060D1Ev();
Name_Map name_map_ee02060[] = {
  NSPAIR(_ZN7ee02060C1Ev),
  NSPAIR(_ZN7ee02060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee02060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02060[];
extern void _ZN4bb603barEv();
extern void _ZN6dd20603fooEv();
static  VTBL_ENTRY vtc_ee02060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN6dd20603fooEv,
};
extern VTBL_ENTRY _ZTI7ee02060[];
extern  VTBL_ENTRY _ZTV7ee02060[];
Class_Descriptor cd_ee02060 = {  "ee02060", // class name
  bases_ee02060, 4,
  &(vtc_ee02060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12060  : virtual dd2060 {
  int e;
  ~ee12060(); // tgen
  ee12060(); // tgen
};
//SIG(1 ee12060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee12060 ::~ee12060(){ note_dtor("ee12060", this);} // tgen
ee12060 ::ee12060(){ note_ctor("ee12060", this);} // tgen

static void Test_ee12060()
{
  extern Class_Descriptor cd_ee12060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12060, buf);
    ee12060 *dp, &lv = *(dp=new (buf) ee12060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(24,12), "ee12060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), ABISELECT(16,8), "ee12060");
    check_base_class_offset(lv, (cc060*)(dd2060*), ABISELECT(16,8), "ee12060");
    check_base_class_offset(lv, (dd2060*), ABISELECT(16,8), "ee12060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12060.e");
    test_class_info(&lv, &cd_ee12060);
    dp->~ee12060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12060(Test_ee12060, "ee12060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12060C1Ev();
extern void _ZN7ee12060D1Ev();
Name_Map name_map_ee12060[] = {
  NSPAIR(_ZN7ee12060C1Ev),
  NSPAIR(_ZN7ee12060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee12060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12060[];
extern void _ZN4bb603barEv();
extern void _ZN6dd20603fooEv();
static  VTBL_ENTRY vtc_ee12060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12060[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN6dd20603fooEv,
};
extern VTBL_ENTRY _ZTV7ee12060[];
static  VTT_ENTRY vtt_ee12060[] = {
  {&(_ZTV7ee12060[3]),  3,9},
  {&(_ZTV7ee12060[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee12060[];
extern  VTBL_ENTRY _ZTV7ee12060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12060[];
Class_Descriptor cd_ee12060 = {  "ee12060", // class name
  bases_ee12060, 4,
  &(vtc_ee12060[0]), // expected_vtbl_contents
  &(vtt_ee12060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12060),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22060  : dd2060 {
  int e;
  virtual void  foo(); // _ZN7ee220603fooEv
  ~ee22060(); // tgen
  ee22060(); // tgen
};
//SIG(1 ee22060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22060 ::foo(){vfunc_called(this, "_ZN7ee220603fooEv");}
ee22060 ::~ee22060(){ note_dtor("ee22060", this);} // tgen
ee22060 ::ee22060(){ note_ctor("ee22060", this);} // tgen

static void Test_ee22060()
{
  extern Class_Descriptor cd_ee22060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22060, buf);
    ee22060 *dp, &lv = *(dp=new (buf) ee22060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(8,4), "ee22060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), 0, "ee22060");
    check_base_class_offset(lv, (cc060*)(dd2060*), 0, "ee22060");
    check_base_class_offset(lv, (dd2060*), 0, "ee22060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22060.e");
    test_class_info(&lv, &cd_ee22060);
    dp->~ee22060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22060(Test_ee22060, "ee22060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22060C1Ev();
extern void _ZN7ee22060D1Ev();
Name_Map name_map_ee22060[] = {
  NSPAIR(_ZN7ee22060C1Ev),
  NSPAIR(_ZN7ee22060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee22060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22060[];
extern void _ZN4bb603barEv();
extern void _ZN7ee220603fooEv();
static  VTBL_ENTRY vtc_ee22060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN7ee220603fooEv,
};
extern VTBL_ENTRY _ZTI7ee22060[];
extern  VTBL_ENTRY _ZTV7ee22060[];
Class_Descriptor cd_ee22060 = {  "ee22060", // class name
  bases_ee22060, 4,
  &(vtc_ee22060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32060  : virtual dd2060 {
  int e;
  virtual void  foo(); // _ZN7ee320603fooEv
  ~ee32060(); // tgen
  ee32060(); // tgen
};
//SIG(1 ee32060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32060 ::foo(){vfunc_called(this, "_ZN7ee320603fooEv");}
ee32060 ::~ee32060(){ note_dtor("ee32060", this);} // tgen
ee32060 ::ee32060(){ note_ctor("ee32060", this);} // tgen

static void Test_ee32060()
{
  extern Class_Descriptor cd_ee32060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32060, buf);
    ee32060 *dp, &lv = *(dp=new (buf) ee32060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(24,12), "ee32060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), ABISELECT(16,8), "ee32060");
    check_base_class_offset(lv, (cc060*)(dd2060*), ABISELECT(16,8), "ee32060");
    check_base_class_offset(lv, (dd2060*), ABISELECT(16,8), "ee32060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32060.e");
    test_class_info(&lv, &cd_ee32060);
    dp->~ee32060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32060(Test_ee32060, "ee32060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32060C1Ev();
extern void _ZN7ee32060D1Ev();
Name_Map name_map_ee32060[] = {
  NSPAIR(_ZN7ee32060C1Ev),
  NSPAIR(_ZN7ee32060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee32060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32060[];
extern void _ZN7ee320603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee320603fooEv,_ZTv0_n16_N7ee320603fooEv)();
extern void ABISELECT(_ZThn16_N7ee320603fooEv,_ZThn8_N7ee320603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32060[0]),
  (VTBL_ENTRY)&_ZN7ee320603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee320603fooEv,_ZTv0_n16_N7ee320603fooEv),
};
extern VTBL_ENTRY _ZTV7ee32060[];
static  VTT_ENTRY vtt_ee32060[] = {
  {&(_ZTV7ee32060[3]),  3,10},
  {&(_ZTV7ee32060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee32060[];
extern  VTBL_ENTRY _ZTV7ee32060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32060[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee320603fooEv,_ZTv0_n16_N7ee320603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320603fooEv,_ZThn8_N7ee320603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32060 = {  "ee32060", // class name
  bases_ee32060, 4,
  &(vtc_ee32060[0]), // expected_vtbl_contents
  &(vtt_ee32060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42060  : dd2060 {
  int e;
  virtual void  bar(); // _ZN7ee420603barEv
  ~ee42060(); // tgen
  ee42060(); // tgen
};
//SIG(1 ee42060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42060 ::bar(){vfunc_called(this, "_ZN7ee420603barEv");}
ee42060 ::~ee42060(){ note_dtor("ee42060", this);} // tgen
ee42060 ::ee42060(){ note_ctor("ee42060", this);} // tgen

static void Test_ee42060()
{
  extern Class_Descriptor cd_ee42060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42060, buf);
    ee42060 *dp, &lv = *(dp=new (buf) ee42060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(8,4), "ee42060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), 0, "ee42060");
    check_base_class_offset(lv, (cc060*)(dd2060*), 0, "ee42060");
    check_base_class_offset(lv, (dd2060*), 0, "ee42060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42060.e");
    test_class_info(&lv, &cd_ee42060);
    dp->~ee42060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42060(Test_ee42060, "ee42060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42060C1Ev();
extern void _ZN7ee42060D1Ev();
Name_Map name_map_ee42060[] = {
  NSPAIR(_ZN7ee42060C1Ev),
  NSPAIR(_ZN7ee42060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee42060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42060[];
extern void _ZN7ee420603barEv();
extern void _ZN6dd20603fooEv();
static  VTBL_ENTRY vtc_ee42060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42060[0]),
  (VTBL_ENTRY)&_ZN7ee420603barEv,
  (VTBL_ENTRY)&_ZN6dd20603fooEv,
};
extern VTBL_ENTRY _ZTI7ee42060[];
extern  VTBL_ENTRY _ZTV7ee42060[];
Class_Descriptor cd_ee42060 = {  "ee42060", // class name
  bases_ee42060, 4,
  &(vtc_ee42060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52060  : virtual dd2060 {
  int e;
  virtual void  bar(); // _ZN7ee520603barEv
  ~ee52060(); // tgen
  ee52060(); // tgen
};
//SIG(1 ee52060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52060 ::bar(){vfunc_called(this, "_ZN7ee520603barEv");}
ee52060 ::~ee52060(){ note_dtor("ee52060", this);} // tgen
ee52060 ::ee52060(){ note_ctor("ee52060", this);} // tgen

static void Test_ee52060()
{
  extern Class_Descriptor cd_ee52060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52060, buf);
    ee52060 *dp, &lv = *(dp=new (buf) ee52060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(24,12), "ee52060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), ABISELECT(16,8), "ee52060");
    check_base_class_offset(lv, (cc060*)(dd2060*), ABISELECT(16,8), "ee52060");
    check_base_class_offset(lv, (dd2060*), ABISELECT(16,8), "ee52060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52060.e");
    test_class_info(&lv, &cd_ee52060);
    dp->~ee52060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52060(Test_ee52060, "ee52060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52060C1Ev();
extern void _ZN7ee52060D1Ev();
Name_Map name_map_ee52060[] = {
  NSPAIR(_ZN7ee52060C1Ev),
  NSPAIR(_ZN7ee52060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee52060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52060[];
extern void _ZN7ee520603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee520603barEv,_ZTv0_n12_N7ee520603barEv)();
extern void ABISELECT(_ZThn16_N7ee520603barEv,_ZThn8_N7ee520603barEv)() __attribute__((weak));
extern void _ZN6dd20603fooEv();
static  VTBL_ENTRY vtc_ee52060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52060[0]),
  (VTBL_ENTRY)&_ZN7ee520603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee520603barEv,_ZTv0_n12_N7ee520603barEv),
  (VTBL_ENTRY)&_ZN6dd20603fooEv,
};
extern VTBL_ENTRY _ZTV7ee52060[];
static  VTT_ENTRY vtt_ee52060[] = {
  {&(_ZTV7ee52060[3]),  3,10},
  {&(_ZTV7ee52060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee52060[];
extern  VTBL_ENTRY _ZTV7ee52060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52060[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee520603barEv,_ZTv0_n12_N7ee520603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee520603barEv,_ZThn8_N7ee520603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52060 = {  "ee52060", // class name
  bases_ee52060, 4,
  &(vtc_ee52060[0]), // expected_vtbl_contents
  &(vtt_ee52060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62060  : dd2060 {
  int e;
  virtual void  foo(); // _ZN7ee620603fooEv
  virtual void  bar(); // _ZN7ee620603barEv
  ~ee62060(); // tgen
  ee62060(); // tgen
};
//SIG(1 ee62060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62060 ::foo(){vfunc_called(this, "_ZN7ee620603fooEv");}
void  ee62060 ::bar(){vfunc_called(this, "_ZN7ee620603barEv");}
ee62060 ::~ee62060(){ note_dtor("ee62060", this);} // tgen
ee62060 ::ee62060(){ note_ctor("ee62060", this);} // tgen

static void Test_ee62060()
{
  extern Class_Descriptor cd_ee62060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62060, buf);
    ee62060 *dp, &lv = *(dp=new (buf) ee62060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(8,4), "ee62060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), 0, "ee62060");
    check_base_class_offset(lv, (cc060*)(dd2060*), 0, "ee62060");
    check_base_class_offset(lv, (dd2060*), 0, "ee62060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62060.e");
    test_class_info(&lv, &cd_ee62060);
    dp->~ee62060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62060(Test_ee62060, "ee62060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62060C1Ev();
extern void _ZN7ee62060D1Ev();
Name_Map name_map_ee62060[] = {
  NSPAIR(_ZN7ee62060C1Ev),
  NSPAIR(_ZN7ee62060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee62060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62060[];
extern void _ZN7ee620603barEv();
extern void _ZN7ee620603fooEv();
static  VTBL_ENTRY vtc_ee62060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62060[0]),
  (VTBL_ENTRY)&_ZN7ee620603barEv,
  (VTBL_ENTRY)&_ZN7ee620603fooEv,
};
extern VTBL_ENTRY _ZTI7ee62060[];
extern  VTBL_ENTRY _ZTV7ee62060[];
Class_Descriptor cd_ee62060 = {  "ee62060", // class name
  bases_ee62060, 4,
  &(vtc_ee62060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72060  : virtual dd2060 {
  int e;
  virtual void  foo(); // _ZN7ee720603fooEv
  virtual void  bar(); // _ZN7ee720603barEv
  ~ee72060(); // tgen
  ee72060(); // tgen
};
//SIG(1 ee72060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72060 ::foo(){vfunc_called(this, "_ZN7ee720603fooEv");}
void  ee72060 ::bar(){vfunc_called(this, "_ZN7ee720603barEv");}
ee72060 ::~ee72060(){ note_dtor("ee72060", this);} // tgen
ee72060 ::ee72060(){ note_ctor("ee72060", this);} // tgen

static void Test_ee72060()
{
  extern Class_Descriptor cd_ee72060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72060, buf);
    ee72060 *dp, &lv = *(dp=new (buf) ee72060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd2060*), ABISELECT(24,12), "ee72060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd2060*), ABISELECT(16,8), "ee72060");
    check_base_class_offset(lv, (cc060*)(dd2060*), ABISELECT(16,8), "ee72060");
    check_base_class_offset(lv, (dd2060*), ABISELECT(16,8), "ee72060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72060.e");
    test_class_info(&lv, &cd_ee72060);
    dp->~ee72060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72060(Test_ee72060, "ee72060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72060C1Ev();
extern void _ZN7ee72060D1Ev();
Name_Map name_map_ee72060[] = {
  NSPAIR(_ZN7ee72060C1Ev),
  NSPAIR(_ZN7ee72060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd2060;
extern VTBL_ENTRY _ZTI6dd2060[];
extern  VTBL_ENTRY _ZTV6dd2060[];
static Base_Class bases_ee72060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72060[];
extern void _ZN7ee720603fooEv();
extern void _ZN7ee720603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee720603barEv,_ZTv0_n12_N7ee720603barEv)();
extern void ABISELECT(_ZThn16_N7ee720603barEv,_ZThn8_N7ee720603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee720603fooEv,_ZTv0_n16_N7ee720603fooEv)();
extern void ABISELECT(_ZThn16_N7ee720603fooEv,_ZThn8_N7ee720603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72060[0]),
  (VTBL_ENTRY)&_ZN7ee720603fooEv,
  (VTBL_ENTRY)&_ZN7ee720603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee720603barEv,_ZTv0_n12_N7ee720603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee720603fooEv,_ZTv0_n16_N7ee720603fooEv),
};
extern VTBL_ENTRY _ZTV7ee72060[];
static  VTT_ENTRY vtt_ee72060[] = {
  {&(_ZTV7ee72060[3]),  3,11},
  {&(_ZTV7ee72060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee72060[];
extern  VTBL_ENTRY _ZTV7ee72060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72060[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee720603fooEv,_ZTv0_n16_N7ee720603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720603fooEv,_ZThn8_N7ee720603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee720603barEv,_ZTv0_n12_N7ee720603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720603barEv,_ZThn8_N7ee720603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72060 = {  "ee72060", // class name
  bases_ee72060, 4,
  &(vtc_ee72060[0]), // expected_vtbl_contents
  &(vtt_ee72060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3060  : virtual cc060 {
  int d;
  virtual void  foo(); // _ZN6dd30603fooEv
  ~dd3060(); // tgen
  dd3060(); // tgen
};
//SIG(-1 dd3060) C1{ VBC2{ BC3{ BC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd3060 ::foo(){vfunc_called(this, "_ZN6dd30603fooEv");}
dd3060 ::~dd3060(){ note_dtor("dd3060", this);} // tgen
dd3060 ::dd3060(){ note_ctor("dd3060", this);} // tgen

static void Test_dd3060()
{
  extern Class_Descriptor cd_dd3060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3060, buf);
    dd3060 *dp, &lv = *(dp=new (buf) dd3060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,12), "dd3060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,8), "dd3060");
    check_base_class_offset(lv, (cc060*), ABISELECT(16,8), "dd3060");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3060.d");
    test_class_info(&lv, &cd_dd3060);
    dp->~dd3060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3060(Test_dd3060, "dd3060", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3060C1Ev();
extern void _ZN6dd3060D1Ev();
Name_Map name_map_dd3060[] = {
  NSPAIR(_ZN6dd3060C1Ev),
  NSPAIR(_ZN6dd3060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd3060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3060[];
extern void _ZN6dd30603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
extern VTBL_ENTRY _ZTV6dd3060[];
static  VTT_ENTRY vtt_dd3060[] = {
  {&(_ZTV6dd3060[3]),  3,10},
  {&(_ZTV6dd3060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3060 = {  "dd3060", // class name
  bases_dd3060, 3,
  &(vtc_dd3060[0]), // expected_vtbl_contents
  &(vtt_dd3060[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3060),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03060  : dd3060 {
  int e;
  ~ee03060(); // tgen
  ee03060(); // tgen
};
//SIG(1 ee03060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee03060 ::~ee03060(){ note_dtor("ee03060", this);} // tgen
ee03060 ::ee03060(){ note_ctor("ee03060", this);} // tgen

static void Test_ee03060()
{
  extern Class_Descriptor cd_ee03060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03060, buf);
    ee03060 *dp, &lv = *(dp=new (buf) ee03060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee03060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee03060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(16,12), "ee03060");
    check_base_class_offset(lv, (dd3060*), 0, "ee03060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03060.e");
    test_class_info(&lv, &cd_ee03060);
    dp->~ee03060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03060(Test_ee03060, "ee03060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03060C1Ev();
extern void _ZN7ee03060D1Ev();
Name_Map name_map_ee03060[] = {
  NSPAIR(_ZN7ee03060C1Ev),
  NSPAIR(_ZN7ee03060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee03060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03060[];
extern void _ZN6dd30603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
extern VTBL_ENTRY _ZTV7ee03060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee03060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee03060[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee03060[] = {
  {&(_ZTV7ee03060[3]),  3,10},
  {&(_tg__ZTV6dd3060__7ee03060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee03060[4]),  4,6},
  {&(_ZTV7ee03060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee03060[];
extern  VTBL_ENTRY _ZTV7ee03060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03060[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03060 = {  "ee03060", // class name
  bases_ee03060, 4,
  &(vtc_ee03060[0]), // expected_vtbl_contents
  &(vtt_ee03060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13060  : virtual dd3060 {
  int e;
  ~ee13060(); // tgen
  ee13060(); // tgen
};
//SIG(1 ee13060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee13060 ::~ee13060(){ note_dtor("ee13060", this);} // tgen
ee13060 ::ee13060(){ note_ctor("ee13060", this);} // tgen

static void Test_ee13060()
{
  extern Class_Descriptor cd_ee13060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13060, buf);
    ee13060 *dp, &lv = *(dp=new (buf) ee13060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee13060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee13060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(32,16), "ee13060");
    check_base_class_offset(lv, (dd3060*), ABISELECT(16,8), "ee13060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13060.e");
    test_class_info(&lv, &cd_ee13060);
    dp->~ee13060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13060(Test_ee13060, "ee13060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13060C1Ev();
extern void _ZN7ee13060D1Ev();
Name_Map name_map_ee13060[] = {
  NSPAIR(_ZN7ee13060C1Ev),
  NSPAIR(_ZN7ee13060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee13060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13060[];
extern void _ZN6dd30603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13060[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
extern VTBL_ENTRY _ZTV7ee13060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee13060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee13060[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee13060[] = {
  {&(_ZTV7ee13060[4]),  4,15},
  {&(_ZTV7ee13060[8]),  8,15},
  {&(_ZTV7ee13060[13]),  13,15},
  {&(_tg__ZTV6dd3060__7ee13060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee13060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee13060[];
extern  VTBL_ENTRY _ZTV7ee13060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13060[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13060 = {  "ee13060", // class name
  bases_ee13060, 4,
  &(vtc_ee13060[0]), // expected_vtbl_contents
  &(vtt_ee13060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13060),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23060  : dd3060 {
  int e;
  virtual void  foo(); // _ZN7ee230603fooEv
  ~ee23060(); // tgen
  ee23060(); // tgen
};
//SIG(1 ee23060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23060 ::foo(){vfunc_called(this, "_ZN7ee230603fooEv");}
ee23060 ::~ee23060(){ note_dtor("ee23060", this);} // tgen
ee23060 ::ee23060(){ note_ctor("ee23060", this);} // tgen

static void Test_ee23060()
{
  extern Class_Descriptor cd_ee23060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23060, buf);
    ee23060 *dp, &lv = *(dp=new (buf) ee23060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee23060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee23060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(16,12), "ee23060");
    check_base_class_offset(lv, (dd3060*), 0, "ee23060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23060.e");
    test_class_info(&lv, &cd_ee23060);
    dp->~ee23060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23060(Test_ee23060, "ee23060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23060C1Ev();
extern void _ZN7ee23060D1Ev();
Name_Map name_map_ee23060[] = {
  NSPAIR(_ZN7ee23060C1Ev),
  NSPAIR(_ZN7ee23060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee23060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23060[];
extern void _ZN7ee230603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee230603fooEv,_ZTv0_n16_N7ee230603fooEv)();
extern void ABISELECT(_ZThn16_N7ee230603fooEv,_ZThn12_N7ee230603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23060[0]),
  (VTBL_ENTRY)&_ZN7ee230603fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee230603fooEv,_ZTv0_n16_N7ee230603fooEv),
};
extern VTBL_ENTRY _ZTV7ee23060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee23060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee23060[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee23060[] = {
  {&(_ZTV7ee23060[3]),  3,10},
  {&(_tg__ZTV6dd3060__7ee23060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee23060[4]),  4,6},
  {&(_ZTV7ee23060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee23060[];
extern  VTBL_ENTRY _ZTV7ee23060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23060[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee230603fooEv,_ZTv0_n16_N7ee230603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee230603fooEv,_ZThn12_N7ee230603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23060 = {  "ee23060", // class name
  bases_ee23060, 4,
  &(vtc_ee23060[0]), // expected_vtbl_contents
  &(vtt_ee23060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33060  : virtual dd3060 {
  int e;
  virtual void  foo(); // _ZN7ee330603fooEv
  ~ee33060(); // tgen
  ee33060(); // tgen
};
//SIG(1 ee33060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33060 ::foo(){vfunc_called(this, "_ZN7ee330603fooEv");}
ee33060 ::~ee33060(){ note_dtor("ee33060", this);} // tgen
ee33060 ::ee33060(){ note_ctor("ee33060", this);} // tgen

static void Test_ee33060()
{
  extern Class_Descriptor cd_ee33060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33060, buf);
    ee33060 *dp, &lv = *(dp=new (buf) ee33060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee33060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee33060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(32,16), "ee33060");
    check_base_class_offset(lv, (dd3060*), ABISELECT(16,8), "ee33060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33060.e");
    test_class_info(&lv, &cd_ee33060);
    dp->~ee33060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33060(Test_ee33060, "ee33060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33060C1Ev();
extern void _ZN7ee33060D1Ev();
Name_Map name_map_ee33060[] = {
  NSPAIR(_ZN7ee33060C1Ev),
  NSPAIR(_ZN7ee33060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee33060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33060[];
extern void _ZN7ee330603fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee330603fooEv,_ZTv0_n16_N7ee330603fooEv)();
extern void ABISELECT(_ZThn16_N7ee330603fooEv,_ZThn8_N7ee330603fooEv)() __attribute__((weak));
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee330603fooEv,_ZTv0_n16_N7ee330603fooEv)();
extern void ABISELECT(_ZThn32_N7ee330603fooEv,_ZThn16_N7ee330603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33060[0]),
  (VTBL_ENTRY)&_ZN7ee330603fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee330603fooEv,_ZTv0_n16_N7ee330603fooEv),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee330603fooEv,_ZTv0_n16_N7ee330603fooEv),
};
extern VTBL_ENTRY _ZTV7ee33060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee33060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee33060[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee33060[] = {
  {&(_ZTV7ee33060[4]),  4,16},
  {&(_ZTV7ee33060[9]),  9,16},
  {&(_ZTV7ee33060[14]),  14,16},
  {&(_tg__ZTV6dd3060__7ee33060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee33060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee33060[];
extern  VTBL_ENTRY _ZTV7ee33060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33060[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee330603fooEv,_ZTv0_n16_N7ee330603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee330603fooEv,_ZThn16_N7ee330603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330603fooEv,_ZThn8_N7ee330603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33060 = {  "ee33060", // class name
  bases_ee33060, 4,
  &(vtc_ee33060[0]), // expected_vtbl_contents
  &(vtt_ee33060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33060),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43060  : dd3060 {
  int e;
  virtual void  bar(); // _ZN7ee430603barEv
  ~ee43060(); // tgen
  ee43060(); // tgen
};
//SIG(1 ee43060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43060 ::bar(){vfunc_called(this, "_ZN7ee430603barEv");}
ee43060 ::~ee43060(){ note_dtor("ee43060", this);} // tgen
ee43060 ::ee43060(){ note_ctor("ee43060", this);} // tgen

static void Test_ee43060()
{
  extern Class_Descriptor cd_ee43060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43060, buf);
    ee43060 *dp, &lv = *(dp=new (buf) ee43060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee43060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee43060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(16,12), "ee43060");
    check_base_class_offset(lv, (dd3060*), 0, "ee43060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43060.e");
    test_class_info(&lv, &cd_ee43060);
    dp->~ee43060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43060(Test_ee43060, "ee43060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43060C1Ev();
extern void _ZN7ee43060D1Ev();
Name_Map name_map_ee43060[] = {
  NSPAIR(_ZN7ee43060C1Ev),
  NSPAIR(_ZN7ee43060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee43060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43060[];
extern void _ZN6dd30603fooEv();
extern void _ZN7ee430603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee430603barEv,_ZTv0_n12_N7ee430603barEv)();
extern void ABISELECT(_ZThn16_N7ee430603barEv,_ZThn12_N7ee430603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
  (VTBL_ENTRY)&_ZN7ee430603barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee430603barEv,_ZTv0_n12_N7ee430603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
extern VTBL_ENTRY _ZTV7ee43060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee43060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee43060[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee43060[] = {
  {&(_ZTV7ee43060[3]),  3,11},
  {&(_tg__ZTV6dd3060__7ee43060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee43060[4]),  4,6},
  {&(_ZTV7ee43060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee43060[];
extern  VTBL_ENTRY _ZTV7ee43060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43060[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee430603barEv,_ZTv0_n12_N7ee430603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee430603barEv,_ZThn12_N7ee430603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43060 = {  "ee43060", // class name
  bases_ee43060, 4,
  &(vtc_ee43060[0]), // expected_vtbl_contents
  &(vtt_ee43060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53060  : virtual dd3060 {
  int e;
  virtual void  bar(); // _ZN7ee530603barEv
  ~ee53060(); // tgen
  ee53060(); // tgen
};
//SIG(1 ee53060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53060 ::bar(){vfunc_called(this, "_ZN7ee530603barEv");}
ee53060 ::~ee53060(){ note_dtor("ee53060", this);} // tgen
ee53060 ::ee53060(){ note_ctor("ee53060", this);} // tgen

static void Test_ee53060()
{
  extern Class_Descriptor cd_ee53060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53060, buf);
    ee53060 *dp, &lv = *(dp=new (buf) ee53060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee53060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee53060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(32,16), "ee53060");
    check_base_class_offset(lv, (dd3060*), ABISELECT(16,8), "ee53060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53060.e");
    test_class_info(&lv, &cd_ee53060);
    dp->~ee53060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53060(Test_ee53060, "ee53060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53060C1Ev();
extern void _ZN7ee53060D1Ev();
Name_Map name_map_ee53060[] = {
  NSPAIR(_ZN7ee53060C1Ev),
  NSPAIR(_ZN7ee53060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee53060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53060[];
extern void _ZN7ee530603barEv();
extern void _ZN6dd30603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee530603barEv,_ZTv0_n12_N7ee530603barEv)();
extern void ABISELECT(_ZThn32_N7ee530603barEv,_ZThn16_N7ee530603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53060[0]),
  (VTBL_ENTRY)&_ZN7ee530603barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee530603barEv,_ZTv0_n12_N7ee530603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
extern VTBL_ENTRY _ZTV7ee53060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee53060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee53060[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee53060[] = {
  {&(_ZTV7ee53060[4]),  4,16},
  {&(_ZTV7ee53060[9]),  9,16},
  {&(_ZTV7ee53060[14]),  14,16},
  {&(_tg__ZTV6dd3060__7ee53060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee53060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee53060[];
extern  VTBL_ENTRY _ZTV7ee53060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53060[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee530603barEv,_ZTv0_n12_N7ee530603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee530603barEv,_ZThn16_N7ee530603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53060 = {  "ee53060", // class name
  bases_ee53060, 4,
  &(vtc_ee53060[0]), // expected_vtbl_contents
  &(vtt_ee53060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53060),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63060  : dd3060 {
  int e;
  virtual void  foo(); // _ZN7ee630603fooEv
  virtual void  bar(); // _ZN7ee630603barEv
  ~ee63060(); // tgen
  ee63060(); // tgen
};
//SIG(1 ee63060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63060 ::foo(){vfunc_called(this, "_ZN7ee630603fooEv");}
void  ee63060 ::bar(){vfunc_called(this, "_ZN7ee630603barEv");}
ee63060 ::~ee63060(){ note_dtor("ee63060", this);} // tgen
ee63060 ::ee63060(){ note_ctor("ee63060", this);} // tgen

static void Test_ee63060()
{
  extern Class_Descriptor cd_ee63060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63060, buf);
    ee63060 *dp, &lv = *(dp=new (buf) ee63060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee63060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee63060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(16,12), "ee63060");
    check_base_class_offset(lv, (dd3060*), 0, "ee63060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63060.e");
    test_class_info(&lv, &cd_ee63060);
    dp->~ee63060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63060(Test_ee63060, "ee63060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63060C1Ev();
extern void _ZN7ee63060D1Ev();
Name_Map name_map_ee63060[] = {
  NSPAIR(_ZN7ee63060C1Ev),
  NSPAIR(_ZN7ee63060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee63060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63060[];
extern void _ZN7ee630603fooEv();
extern void _ZN7ee630603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee630603barEv,_ZTv0_n12_N7ee630603barEv)();
extern void ABISELECT(_ZThn16_N7ee630603barEv,_ZThn12_N7ee630603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee630603fooEv,_ZTv0_n16_N7ee630603fooEv)();
extern void ABISELECT(_ZThn16_N7ee630603fooEv,_ZThn12_N7ee630603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63060[0]),
  (VTBL_ENTRY)&_ZN7ee630603fooEv,
  (VTBL_ENTRY)&_ZN7ee630603barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee630603barEv,_ZTv0_n12_N7ee630603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee630603fooEv,_ZTv0_n16_N7ee630603fooEv),
};
extern VTBL_ENTRY _ZTV7ee63060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee63060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee63060[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee63060[] = {
  {&(_ZTV7ee63060[3]),  3,11},
  {&(_tg__ZTV6dd3060__7ee63060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee63060[4]),  4,6},
  {&(_ZTV7ee63060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee63060[];
extern  VTBL_ENTRY _ZTV7ee63060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63060[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn12_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee630603fooEv,_ZTv0_n16_N7ee630603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630603fooEv,_ZThn12_N7ee630603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee630603barEv,_ZTv0_n12_N7ee630603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630603barEv,_ZThn12_N7ee630603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63060 = {  "ee63060", // class name
  bases_ee63060, 4,
  &(vtc_ee63060[0]), // expected_vtbl_contents
  &(vtt_ee63060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73060  : virtual dd3060 {
  int e;
  virtual void  foo(); // _ZN7ee730603fooEv
  virtual void  bar(); // _ZN7ee730603barEv
  ~ee73060(); // tgen
  ee73060(); // tgen
};
//SIG(1 ee73060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73060 ::foo(){vfunc_called(this, "_ZN7ee730603fooEv");}
void  ee73060 ::bar(){vfunc_called(this, "_ZN7ee730603barEv");}
ee73060 ::~ee73060(){ note_dtor("ee73060", this);} // tgen
ee73060 ::ee73060(){ note_ctor("ee73060", this);} // tgen

static void Test_ee73060()
{
  extern Class_Descriptor cd_ee73060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73060, buf);
    ee73060 *dp, &lv = *(dp=new (buf) ee73060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee73060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee73060");
    check_base_class_offset(lv, (cc060*)(dd3060*), ABISELECT(32,16), "ee73060");
    check_base_class_offset(lv, (dd3060*), ABISELECT(16,8), "ee73060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73060.e");
    test_class_info(&lv, &cd_ee73060);
    dp->~ee73060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73060(Test_ee73060, "ee73060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73060C1Ev();
extern void _ZN7ee73060D1Ev();
Name_Map name_map_ee73060[] = {
  NSPAIR(_ZN7ee73060C1Ev),
  NSPAIR(_ZN7ee73060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd3060;
extern VTBL_ENTRY _ZTI6dd3060[];
extern  VTBL_ENTRY _ZTV6dd3060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3060[];
static Base_Class bases_ee73060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3060,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73060[];
extern void _ZN7ee730603fooEv();
extern void _ZN7ee730603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee730603fooEv,_ZTv0_n16_N7ee730603fooEv)();
extern void ABISELECT(_ZThn16_N7ee730603fooEv,_ZThn8_N7ee730603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee730603barEv,_ZTv0_n12_N7ee730603barEv)();
extern void ABISELECT(_ZThn32_N7ee730603barEv,_ZThn16_N7ee730603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee730603fooEv,_ZTv0_n16_N7ee730603fooEv)();
extern void ABISELECT(_ZThn32_N7ee730603fooEv,_ZThn16_N7ee730603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73060[0]),
  (VTBL_ENTRY)&_ZN7ee730603fooEv,
  (VTBL_ENTRY)&_ZN7ee730603barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730603fooEv,_ZTv0_n16_N7ee730603fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee730603barEv,_ZTv0_n12_N7ee730603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730603fooEv,_ZTv0_n16_N7ee730603fooEv),
};
extern VTBL_ENTRY _ZTV7ee73060[];
extern void _ZN6dd30603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3060__7ee73060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN6dd30603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv)();
extern void ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd3060__7ee73060[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3060[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv),
};
static  VTT_ENTRY vtt_ee73060[] = {
  {&(_ZTV7ee73060[4]),  4,17},
  {&(_ZTV7ee73060[10]),  10,17},
  {&(_ZTV7ee73060[15]),  15,17},
  {&(_tg__ZTV6dd3060__7ee73060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd3060__7ee73060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee73060[];
extern  VTBL_ENTRY _ZTV7ee73060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73060[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30603fooEv,_ZTv0_n16_N6dd30603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30603fooEv,_ZThn8_N6dd30603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee730603barEv,_ZTv0_n12_N7ee730603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730603barEv,_ZThn16_N7ee730603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee730603fooEv,_ZTv0_n16_N7ee730603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730603fooEv,_ZThn16_N7ee730603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730603fooEv,_ZThn8_N7ee730603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73060 = {  "ee73060", // class name
  bases_ee73060, 4,
  &(vtc_ee73060[0]), // expected_vtbl_contents
  &(vtt_ee73060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73060),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4060  : cc060 {
  int d;
  virtual void  bar(); // _ZN6dd40603barEv
  ~dd4060(); // tgen
  dd4060(); // tgen
};
//SIG(-1 dd4060) C1{ BC2{ BC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd4060 ::bar(){vfunc_called(this, "_ZN6dd40603barEv");}
dd4060 ::~dd4060(){ note_dtor("dd4060", this);} // tgen
dd4060 ::dd4060(){ note_ctor("dd4060", this);} // tgen

static void Test_dd4060()
{
  extern Class_Descriptor cd_dd4060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4060, buf);
    dd4060 *dp, &lv = *(dp=new (buf) dd4060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(8,4), "dd4060");
    check_base_class_offset(lv, (bb60*)(cc060*), 0, "dd4060");
    check_base_class_offset(lv, (cc060*), 0, "dd4060");
    check_field_offset(lv, d, ABISELECT(20,16), "dd4060.d");
    test_class_info(&lv, &cd_dd4060);
    dp->~dd4060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4060(Test_dd4060, "dd4060", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4060C1Ev();
extern void _ZN6dd4060D1Ev();
Name_Map name_map_dd4060[] = {
  NSPAIR(_ZN6dd4060C1Ev),
  NSPAIR(_ZN6dd4060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd4060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4060[];
extern void _ZN6dd40603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd4060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd4060[0]),
  (VTBL_ENTRY)&_ZN6dd40603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
Class_Descriptor cd_dd4060 = {  "dd4060", // class name
  bases_dd4060, 3,
  &(vtc_dd4060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04060  : dd4060 {
  int e;
  ~ee04060(); // tgen
  ee04060(); // tgen
};
//SIG(1 ee04060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee04060 ::~ee04060(){ note_dtor("ee04060", this);} // tgen
ee04060 ::ee04060(){ note_ctor("ee04060", this);} // tgen

static void Test_ee04060()
{
  extern Class_Descriptor cd_ee04060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04060, buf);
    ee04060 *dp, &lv = *(dp=new (buf) ee04060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(8,4), "ee04060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), 0, "ee04060");
    check_base_class_offset(lv, (cc060*)(dd4060*), 0, "ee04060");
    check_base_class_offset(lv, (dd4060*), 0, "ee04060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee04060.e");
    test_class_info(&lv, &cd_ee04060);
    dp->~ee04060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04060(Test_ee04060, "ee04060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04060C1Ev();
extern void _ZN7ee04060D1Ev();
Name_Map name_map_ee04060[] = {
  NSPAIR(_ZN7ee04060C1Ev),
  NSPAIR(_ZN7ee04060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee04060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04060[];
extern void _ZN6dd40603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee04060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee04060[0]),
  (VTBL_ENTRY)&_ZN6dd40603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI7ee04060[];
extern  VTBL_ENTRY _ZTV7ee04060[];
Class_Descriptor cd_ee04060 = {  "ee04060", // class name
  bases_ee04060, 4,
  &(vtc_ee04060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14060  : virtual dd4060 {
  int e;
  ~ee14060(); // tgen
  ee14060(); // tgen
};
//SIG(1 ee14060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee14060 ::~ee14060(){ note_dtor("ee14060", this);} // tgen
ee14060 ::ee14060(){ note_ctor("ee14060", this);} // tgen

static void Test_ee14060()
{
  extern Class_Descriptor cd_ee14060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14060, buf);
    ee14060 *dp, &lv = *(dp=new (buf) ee14060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(24,12), "ee14060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), ABISELECT(16,8), "ee14060");
    check_base_class_offset(lv, (cc060*)(dd4060*), ABISELECT(16,8), "ee14060");
    check_base_class_offset(lv, (dd4060*), ABISELECT(16,8), "ee14060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14060.e");
    test_class_info(&lv, &cd_ee14060);
    dp->~ee14060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14060(Test_ee14060, "ee14060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14060C1Ev();
extern void _ZN7ee14060D1Ev();
Name_Map name_map_ee14060[] = {
  NSPAIR(_ZN7ee14060C1Ev),
  NSPAIR(_ZN7ee14060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee14060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14060[];
extern void _ZN6dd40603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee14060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14060[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14060[0]),
  (VTBL_ENTRY)&_ZN6dd40603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee14060[];
static  VTT_ENTRY vtt_ee14060[] = {
  {&(_ZTV7ee14060[3]),  3,9},
  {&(_ZTV7ee14060[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee14060[];
extern  VTBL_ENTRY _ZTV7ee14060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14060[];
Class_Descriptor cd_ee14060 = {  "ee14060", // class name
  bases_ee14060, 4,
  &(vtc_ee14060[0]), // expected_vtbl_contents
  &(vtt_ee14060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14060),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24060  : dd4060 {
  int e;
  virtual void  foo(); // _ZN7ee240603fooEv
  ~ee24060(); // tgen
  ee24060(); // tgen
};
//SIG(1 ee24060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24060 ::foo(){vfunc_called(this, "_ZN7ee240603fooEv");}
ee24060 ::~ee24060(){ note_dtor("ee24060", this);} // tgen
ee24060 ::ee24060(){ note_ctor("ee24060", this);} // tgen

static void Test_ee24060()
{
  extern Class_Descriptor cd_ee24060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24060, buf);
    ee24060 *dp, &lv = *(dp=new (buf) ee24060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(8,4), "ee24060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), 0, "ee24060");
    check_base_class_offset(lv, (cc060*)(dd4060*), 0, "ee24060");
    check_base_class_offset(lv, (dd4060*), 0, "ee24060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee24060.e");
    test_class_info(&lv, &cd_ee24060);
    dp->~ee24060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24060(Test_ee24060, "ee24060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24060C1Ev();
extern void _ZN7ee24060D1Ev();
Name_Map name_map_ee24060[] = {
  NSPAIR(_ZN7ee24060C1Ev),
  NSPAIR(_ZN7ee24060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee24060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24060[];
extern void _ZN6dd40603barEv();
extern void _ZN7ee240603fooEv();
static  VTBL_ENTRY vtc_ee24060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee24060[0]),
  (VTBL_ENTRY)&_ZN6dd40603barEv,
  (VTBL_ENTRY)&_ZN7ee240603fooEv,
};
extern VTBL_ENTRY _ZTI7ee24060[];
extern  VTBL_ENTRY _ZTV7ee24060[];
Class_Descriptor cd_ee24060 = {  "ee24060", // class name
  bases_ee24060, 4,
  &(vtc_ee24060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34060  : virtual dd4060 {
  int e;
  virtual void  foo(); // _ZN7ee340603fooEv
  ~ee34060(); // tgen
  ee34060(); // tgen
};
//SIG(1 ee34060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34060 ::foo(){vfunc_called(this, "_ZN7ee340603fooEv");}
ee34060 ::~ee34060(){ note_dtor("ee34060", this);} // tgen
ee34060 ::ee34060(){ note_ctor("ee34060", this);} // tgen

static void Test_ee34060()
{
  extern Class_Descriptor cd_ee34060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34060, buf);
    ee34060 *dp, &lv = *(dp=new (buf) ee34060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(24,12), "ee34060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), ABISELECT(16,8), "ee34060");
    check_base_class_offset(lv, (cc060*)(dd4060*), ABISELECT(16,8), "ee34060");
    check_base_class_offset(lv, (dd4060*), ABISELECT(16,8), "ee34060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34060.e");
    test_class_info(&lv, &cd_ee34060);
    dp->~ee34060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34060(Test_ee34060, "ee34060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34060C1Ev();
extern void _ZN7ee34060D1Ev();
Name_Map name_map_ee34060[] = {
  NSPAIR(_ZN7ee34060C1Ev),
  NSPAIR(_ZN7ee34060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee34060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34060[];
extern void _ZN7ee340603fooEv();
extern void _ZN6dd40603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee340603fooEv,_ZTv0_n16_N7ee340603fooEv)();
extern void ABISELECT(_ZThn16_N7ee340603fooEv,_ZThn8_N7ee340603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34060[0]),
  (VTBL_ENTRY)&_ZN7ee340603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34060[0]),
  (VTBL_ENTRY)&_ZN6dd40603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee340603fooEv,_ZTv0_n16_N7ee340603fooEv),
};
extern VTBL_ENTRY _ZTV7ee34060[];
static  VTT_ENTRY vtt_ee34060[] = {
  {&(_ZTV7ee34060[3]),  3,10},
  {&(_ZTV7ee34060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee34060[];
extern  VTBL_ENTRY _ZTV7ee34060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34060[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee340603fooEv,_ZTv0_n16_N7ee340603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee340603fooEv,_ZThn8_N7ee340603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34060 = {  "ee34060", // class name
  bases_ee34060, 4,
  &(vtc_ee34060[0]), // expected_vtbl_contents
  &(vtt_ee34060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44060  : dd4060 {
  int e;
  virtual void  bar(); // _ZN7ee440603barEv
  ~ee44060(); // tgen
  ee44060(); // tgen
};
//SIG(1 ee44060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44060 ::bar(){vfunc_called(this, "_ZN7ee440603barEv");}
ee44060 ::~ee44060(){ note_dtor("ee44060", this);} // tgen
ee44060 ::ee44060(){ note_ctor("ee44060", this);} // tgen

static void Test_ee44060()
{
  extern Class_Descriptor cd_ee44060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44060, buf);
    ee44060 *dp, &lv = *(dp=new (buf) ee44060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(8,4), "ee44060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), 0, "ee44060");
    check_base_class_offset(lv, (cc060*)(dd4060*), 0, "ee44060");
    check_base_class_offset(lv, (dd4060*), 0, "ee44060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee44060.e");
    test_class_info(&lv, &cd_ee44060);
    dp->~ee44060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44060(Test_ee44060, "ee44060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44060C1Ev();
extern void _ZN7ee44060D1Ev();
Name_Map name_map_ee44060[] = {
  NSPAIR(_ZN7ee44060C1Ev),
  NSPAIR(_ZN7ee44060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee44060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44060[];
extern void _ZN7ee440603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee44060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee44060[0]),
  (VTBL_ENTRY)&_ZN7ee440603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTI7ee44060[];
extern  VTBL_ENTRY _ZTV7ee44060[];
Class_Descriptor cd_ee44060 = {  "ee44060", // class name
  bases_ee44060, 4,
  &(vtc_ee44060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54060  : virtual dd4060 {
  int e;
  virtual void  bar(); // _ZN7ee540603barEv
  ~ee54060(); // tgen
  ee54060(); // tgen
};
//SIG(1 ee54060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54060 ::bar(){vfunc_called(this, "_ZN7ee540603barEv");}
ee54060 ::~ee54060(){ note_dtor("ee54060", this);} // tgen
ee54060 ::ee54060(){ note_ctor("ee54060", this);} // tgen

static void Test_ee54060()
{
  extern Class_Descriptor cd_ee54060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54060, buf);
    ee54060 *dp, &lv = *(dp=new (buf) ee54060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(24,12), "ee54060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), ABISELECT(16,8), "ee54060");
    check_base_class_offset(lv, (cc060*)(dd4060*), ABISELECT(16,8), "ee54060");
    check_base_class_offset(lv, (dd4060*), ABISELECT(16,8), "ee54060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54060.e");
    test_class_info(&lv, &cd_ee54060);
    dp->~ee54060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54060(Test_ee54060, "ee54060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54060C1Ev();
extern void _ZN7ee54060D1Ev();
Name_Map name_map_ee54060[] = {
  NSPAIR(_ZN7ee54060C1Ev),
  NSPAIR(_ZN7ee54060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee54060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54060[];
extern void _ZN7ee540603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee540603barEv,_ZTv0_n12_N7ee540603barEv)();
extern void ABISELECT(_ZThn16_N7ee540603barEv,_ZThn8_N7ee540603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee54060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54060[0]),
  (VTBL_ENTRY)&_ZN7ee540603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee540603barEv,_ZTv0_n12_N7ee540603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee54060[];
static  VTT_ENTRY vtt_ee54060[] = {
  {&(_ZTV7ee54060[3]),  3,10},
  {&(_ZTV7ee54060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee54060[];
extern  VTBL_ENTRY _ZTV7ee54060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54060[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee540603barEv,_ZTv0_n12_N7ee540603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540603barEv,_ZThn8_N7ee540603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54060 = {  "ee54060", // class name
  bases_ee54060, 4,
  &(vtc_ee54060[0]), // expected_vtbl_contents
  &(vtt_ee54060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64060  : dd4060 {
  int e;
  virtual void  foo(); // _ZN7ee640603fooEv
  virtual void  bar(); // _ZN7ee640603barEv
  ~ee64060(); // tgen
  ee64060(); // tgen
};
//SIG(1 ee64060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64060 ::foo(){vfunc_called(this, "_ZN7ee640603fooEv");}
void  ee64060 ::bar(){vfunc_called(this, "_ZN7ee640603barEv");}
ee64060 ::~ee64060(){ note_dtor("ee64060", this);} // tgen
ee64060 ::ee64060(){ note_ctor("ee64060", this);} // tgen

static void Test_ee64060()
{
  extern Class_Descriptor cd_ee64060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64060, buf);
    ee64060 *dp, &lv = *(dp=new (buf) ee64060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(8,4), "ee64060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), 0, "ee64060");
    check_base_class_offset(lv, (cc060*)(dd4060*), 0, "ee64060");
    check_base_class_offset(lv, (dd4060*), 0, "ee64060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee64060.e");
    test_class_info(&lv, &cd_ee64060);
    dp->~ee64060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64060(Test_ee64060, "ee64060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64060C1Ev();
extern void _ZN7ee64060D1Ev();
Name_Map name_map_ee64060[] = {
  NSPAIR(_ZN7ee64060C1Ev),
  NSPAIR(_ZN7ee64060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee64060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64060[];
extern void _ZN7ee640603barEv();
extern void _ZN7ee640603fooEv();
static  VTBL_ENTRY vtc_ee64060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee64060[0]),
  (VTBL_ENTRY)&_ZN7ee640603barEv,
  (VTBL_ENTRY)&_ZN7ee640603fooEv,
};
extern VTBL_ENTRY _ZTI7ee64060[];
extern  VTBL_ENTRY _ZTV7ee64060[];
Class_Descriptor cd_ee64060 = {  "ee64060", // class name
  bases_ee64060, 4,
  &(vtc_ee64060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74060  : virtual dd4060 {
  int e;
  virtual void  foo(); // _ZN7ee740603fooEv
  virtual void  bar(); // _ZN7ee740603barEv
  ~ee74060(); // tgen
  ee74060(); // tgen
};
//SIG(1 ee74060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74060 ::foo(){vfunc_called(this, "_ZN7ee740603fooEv");}
void  ee74060 ::bar(){vfunc_called(this, "_ZN7ee740603barEv");}
ee74060 ::~ee74060(){ note_dtor("ee74060", this);} // tgen
ee74060 ::ee74060(){ note_ctor("ee74060", this);} // tgen

static void Test_ee74060()
{
  extern Class_Descriptor cd_ee74060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74060, buf);
    ee74060 *dp, &lv = *(dp=new (buf) ee74060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd4060*), ABISELECT(24,12), "ee74060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd4060*), ABISELECT(16,8), "ee74060");
    check_base_class_offset(lv, (cc060*)(dd4060*), ABISELECT(16,8), "ee74060");
    check_base_class_offset(lv, (dd4060*), ABISELECT(16,8), "ee74060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74060.e");
    test_class_info(&lv, &cd_ee74060);
    dp->~ee74060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74060(Test_ee74060, "ee74060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74060C1Ev();
extern void _ZN7ee74060D1Ev();
Name_Map name_map_ee74060[] = {
  NSPAIR(_ZN7ee74060C1Ev),
  NSPAIR(_ZN7ee74060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd4060;
extern VTBL_ENTRY _ZTI6dd4060[];
extern  VTBL_ENTRY _ZTV6dd4060[];
static Base_Class bases_ee74060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74060[];
extern void _ZN7ee740603fooEv();
extern void _ZN7ee740603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee740603barEv,_ZTv0_n12_N7ee740603barEv)();
extern void ABISELECT(_ZThn16_N7ee740603barEv,_ZThn8_N7ee740603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee740603fooEv,_ZTv0_n16_N7ee740603fooEv)();
extern void ABISELECT(_ZThn16_N7ee740603fooEv,_ZThn8_N7ee740603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74060[0]),
  (VTBL_ENTRY)&_ZN7ee740603fooEv,
  (VTBL_ENTRY)&_ZN7ee740603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee740603barEv,_ZTv0_n12_N7ee740603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee740603fooEv,_ZTv0_n16_N7ee740603fooEv),
};
extern VTBL_ENTRY _ZTV7ee74060[];
static  VTT_ENTRY vtt_ee74060[] = {
  {&(_ZTV7ee74060[3]),  3,11},
  {&(_ZTV7ee74060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee74060[];
extern  VTBL_ENTRY _ZTV7ee74060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74060[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee740603fooEv,_ZTv0_n16_N7ee740603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740603fooEv,_ZThn8_N7ee740603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee740603barEv,_ZTv0_n12_N7ee740603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740603barEv,_ZThn8_N7ee740603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74060 = {  "ee74060", // class name
  bases_ee74060, 4,
  &(vtc_ee74060[0]), // expected_vtbl_contents
  &(vtt_ee74060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5060  : virtual cc060 {
  int d;
  virtual void  bar(); // _ZN6dd50603barEv
  ~dd5060(); // tgen
  dd5060(); // tgen
};
//SIG(-1 dd5060) C1{ VBC2{ BC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd5060 ::bar(){vfunc_called(this, "_ZN6dd50603barEv");}
dd5060 ::~dd5060(){ note_dtor("dd5060", this);} // tgen
dd5060 ::dd5060(){ note_ctor("dd5060", this);} // tgen

static void Test_dd5060()
{
  extern Class_Descriptor cd_dd5060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5060, buf);
    dd5060 *dp, &lv = *(dp=new (buf) dd5060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,12), "dd5060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,8), "dd5060");
    check_base_class_offset(lv, (cc060*), ABISELECT(16,8), "dd5060");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5060.d");
    test_class_info(&lv, &cd_dd5060);
    dp->~dd5060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5060(Test_dd5060, "dd5060", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5060C1Ev();
extern void _ZN6dd5060D1Ev();
Name_Map name_map_dd5060[] = {
  NSPAIR(_ZN6dd5060C1Ev),
  NSPAIR(_ZN6dd5060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd5060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5060[];
extern void _ZN6dd50603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd5060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV6dd5060[];
static  VTT_ENTRY vtt_dd5060[] = {
  {&(_ZTV6dd5060[3]),  3,10},
  {&(_ZTV6dd5060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5060 = {  "dd5060", // class name
  bases_dd5060, 3,
  &(vtc_dd5060[0]), // expected_vtbl_contents
  &(vtt_dd5060[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5060),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05060  : dd5060 {
  int e;
  ~ee05060(); // tgen
  ee05060(); // tgen
};
//SIG(1 ee05060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee05060 ::~ee05060(){ note_dtor("ee05060", this);} // tgen
ee05060 ::ee05060(){ note_ctor("ee05060", this);} // tgen

static void Test_ee05060()
{
  extern Class_Descriptor cd_ee05060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05060, buf);
    ee05060 *dp, &lv = *(dp=new (buf) ee05060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee05060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee05060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(16,12), "ee05060");
    check_base_class_offset(lv, (dd5060*), 0, "ee05060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05060.e");
    test_class_info(&lv, &cd_ee05060);
    dp->~ee05060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05060(Test_ee05060, "ee05060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05060C1Ev();
extern void _ZN7ee05060D1Ev();
Name_Map name_map_ee05060[] = {
  NSPAIR(_ZN7ee05060C1Ev),
  NSPAIR(_ZN7ee05060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee05060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05060[];
extern void _ZN6dd50603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee05060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee05060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee05060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee05060[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee05060[] = {
  {&(_ZTV7ee05060[3]),  3,10},
  {&(_tg__ZTV6dd5060__7ee05060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee05060[4]),  4,6},
  {&(_ZTV7ee05060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee05060[];
extern  VTBL_ENTRY _ZTV7ee05060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05060[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05060 = {  "ee05060", // class name
  bases_ee05060, 4,
  &(vtc_ee05060[0]), // expected_vtbl_contents
  &(vtt_ee05060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15060  : virtual dd5060 {
  int e;
  ~ee15060(); // tgen
  ee15060(); // tgen
};
//SIG(1 ee15060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee15060 ::~ee15060(){ note_dtor("ee15060", this);} // tgen
ee15060 ::ee15060(){ note_ctor("ee15060", this);} // tgen

static void Test_ee15060()
{
  extern Class_Descriptor cd_ee15060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15060, buf);
    ee15060 *dp, &lv = *(dp=new (buf) ee15060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee15060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee15060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(32,16), "ee15060");
    check_base_class_offset(lv, (dd5060*), ABISELECT(16,8), "ee15060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15060.e");
    test_class_info(&lv, &cd_ee15060);
    dp->~ee15060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15060(Test_ee15060, "ee15060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15060C1Ev();
extern void _ZN7ee15060D1Ev();
Name_Map name_map_ee15060[] = {
  NSPAIR(_ZN7ee15060C1Ev),
  NSPAIR(_ZN7ee15060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee15060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15060[];
extern void _ZN6dd50603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee15060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15060[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee15060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee15060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee15060[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee15060[] = {
  {&(_ZTV7ee15060[4]),  4,15},
  {&(_ZTV7ee15060[8]),  8,15},
  {&(_ZTV7ee15060[13]),  13,15},
  {&(_tg__ZTV6dd5060__7ee15060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee15060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee15060[];
extern  VTBL_ENTRY _ZTV7ee15060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15060[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15060 = {  "ee15060", // class name
  bases_ee15060, 4,
  &(vtc_ee15060[0]), // expected_vtbl_contents
  &(vtt_ee15060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15060),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25060  : dd5060 {
  int e;
  virtual void  foo(); // _ZN7ee250603fooEv
  ~ee25060(); // tgen
  ee25060(); // tgen
};
//SIG(1 ee25060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25060 ::foo(){vfunc_called(this, "_ZN7ee250603fooEv");}
ee25060 ::~ee25060(){ note_dtor("ee25060", this);} // tgen
ee25060 ::ee25060(){ note_ctor("ee25060", this);} // tgen

static void Test_ee25060()
{
  extern Class_Descriptor cd_ee25060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25060, buf);
    ee25060 *dp, &lv = *(dp=new (buf) ee25060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee25060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee25060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(16,12), "ee25060");
    check_base_class_offset(lv, (dd5060*), 0, "ee25060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25060.e");
    test_class_info(&lv, &cd_ee25060);
    dp->~ee25060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25060(Test_ee25060, "ee25060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25060C1Ev();
extern void _ZN7ee25060D1Ev();
Name_Map name_map_ee25060[] = {
  NSPAIR(_ZN7ee25060C1Ev),
  NSPAIR(_ZN7ee25060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee25060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25060[];
extern void _ZN6dd50603barEv();
extern void _ZN7ee250603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee250603fooEv,_ZTv0_n16_N7ee250603fooEv)();
extern void ABISELECT(_ZThn16_N7ee250603fooEv,_ZThn12_N7ee250603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
  (VTBL_ENTRY)&_ZN7ee250603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee250603fooEv,_ZTv0_n16_N7ee250603fooEv),
};
extern VTBL_ENTRY _ZTV7ee25060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee25060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee25060[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee25060[] = {
  {&(_ZTV7ee25060[3]),  3,11},
  {&(_tg__ZTV6dd5060__7ee25060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee25060[4]),  4,6},
  {&(_ZTV7ee25060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee25060[];
extern  VTBL_ENTRY _ZTV7ee25060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25060[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee250603fooEv,_ZTv0_n16_N7ee250603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee250603fooEv,_ZThn12_N7ee250603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25060 = {  "ee25060", // class name
  bases_ee25060, 4,
  &(vtc_ee25060[0]), // expected_vtbl_contents
  &(vtt_ee25060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35060  : virtual dd5060 {
  int e;
  virtual void  foo(); // _ZN7ee350603fooEv
  ~ee35060(); // tgen
  ee35060(); // tgen
};
//SIG(1 ee35060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35060 ::foo(){vfunc_called(this, "_ZN7ee350603fooEv");}
ee35060 ::~ee35060(){ note_dtor("ee35060", this);} // tgen
ee35060 ::ee35060(){ note_ctor("ee35060", this);} // tgen

static void Test_ee35060()
{
  extern Class_Descriptor cd_ee35060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35060, buf);
    ee35060 *dp, &lv = *(dp=new (buf) ee35060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee35060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee35060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(32,16), "ee35060");
    check_base_class_offset(lv, (dd5060*), ABISELECT(16,8), "ee35060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35060.e");
    test_class_info(&lv, &cd_ee35060);
    dp->~ee35060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35060(Test_ee35060, "ee35060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35060C1Ev();
extern void _ZN7ee35060D1Ev();
Name_Map name_map_ee35060[] = {
  NSPAIR(_ZN7ee35060C1Ev),
  NSPAIR(_ZN7ee35060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee35060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35060[];
extern void _ZN7ee350603fooEv();
extern void _ZN6dd50603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee350603fooEv,_ZTv0_n16_N7ee350603fooEv)();
extern void ABISELECT(_ZThn32_N7ee350603fooEv,_ZThn16_N7ee350603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35060[0]),
  (VTBL_ENTRY)&_ZN7ee350603fooEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
  ABISELECT(-32,-16),
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee350603fooEv,_ZTv0_n16_N7ee350603fooEv),
};
extern VTBL_ENTRY _ZTV7ee35060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee35060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee35060[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee35060[] = {
  {&(_ZTV7ee35060[4]),  4,16},
  {&(_ZTV7ee35060[9]),  9,16},
  {&(_ZTV7ee35060[14]),  14,16},
  {&(_tg__ZTV6dd5060__7ee35060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee35060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee35060[];
extern  VTBL_ENTRY _ZTV7ee35060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35060[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee350603fooEv,_ZTv0_n16_N7ee350603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee350603fooEv,_ZThn16_N7ee350603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35060 = {  "ee35060", // class name
  bases_ee35060, 4,
  &(vtc_ee35060[0]), // expected_vtbl_contents
  &(vtt_ee35060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35060),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45060  : dd5060 {
  int e;
  virtual void  bar(); // _ZN7ee450603barEv
  ~ee45060(); // tgen
  ee45060(); // tgen
};
//SIG(1 ee45060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45060 ::bar(){vfunc_called(this, "_ZN7ee450603barEv");}
ee45060 ::~ee45060(){ note_dtor("ee45060", this);} // tgen
ee45060 ::ee45060(){ note_ctor("ee45060", this);} // tgen

static void Test_ee45060()
{
  extern Class_Descriptor cd_ee45060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45060, buf);
    ee45060 *dp, &lv = *(dp=new (buf) ee45060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee45060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee45060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(16,12), "ee45060");
    check_base_class_offset(lv, (dd5060*), 0, "ee45060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45060.e");
    test_class_info(&lv, &cd_ee45060);
    dp->~ee45060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45060(Test_ee45060, "ee45060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45060C1Ev();
extern void _ZN7ee45060D1Ev();
Name_Map name_map_ee45060[] = {
  NSPAIR(_ZN7ee45060C1Ev),
  NSPAIR(_ZN7ee45060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee45060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45060[];
extern void _ZN7ee450603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee450603barEv,_ZTv0_n12_N7ee450603barEv)();
extern void ABISELECT(_ZThn16_N7ee450603barEv,_ZThn12_N7ee450603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee45060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45060[0]),
  (VTBL_ENTRY)&_ZN7ee450603barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee450603barEv,_ZTv0_n12_N7ee450603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee45060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee45060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee45060[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee45060[] = {
  {&(_ZTV7ee45060[3]),  3,10},
  {&(_tg__ZTV6dd5060__7ee45060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee45060[4]),  4,6},
  {&(_ZTV7ee45060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee45060[];
extern  VTBL_ENTRY _ZTV7ee45060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45060[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee450603barEv,_ZTv0_n12_N7ee450603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee450603barEv,_ZThn12_N7ee450603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45060 = {  "ee45060", // class name
  bases_ee45060, 4,
  &(vtc_ee45060[0]), // expected_vtbl_contents
  &(vtt_ee45060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55060  : virtual dd5060 {
  int e;
  virtual void  bar(); // _ZN7ee550603barEv
  ~ee55060(); // tgen
  ee55060(); // tgen
};
//SIG(1 ee55060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55060 ::bar(){vfunc_called(this, "_ZN7ee550603barEv");}
ee55060 ::~ee55060(){ note_dtor("ee55060", this);} // tgen
ee55060 ::ee55060(){ note_ctor("ee55060", this);} // tgen

static void Test_ee55060()
{
  extern Class_Descriptor cd_ee55060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55060, buf);
    ee55060 *dp, &lv = *(dp=new (buf) ee55060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee55060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee55060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(32,16), "ee55060");
    check_base_class_offset(lv, (dd5060*), ABISELECT(16,8), "ee55060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55060.e");
    test_class_info(&lv, &cd_ee55060);
    dp->~ee55060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55060(Test_ee55060, "ee55060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55060C1Ev();
extern void _ZN7ee55060D1Ev();
Name_Map name_map_ee55060[] = {
  NSPAIR(_ZN7ee55060C1Ev),
  NSPAIR(_ZN7ee55060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee55060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55060[];
extern void _ZN7ee550603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee550603barEv,_ZTv0_n16_N7ee550603barEv)();
extern void ABISELECT(_ZThn16_N7ee550603barEv,_ZThn8_N7ee550603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee550603barEv,_ZTv0_n12_N7ee550603barEv)();
extern void ABISELECT(_ZThn32_N7ee550603barEv,_ZThn16_N7ee550603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee55060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55060[0]),
  (VTBL_ENTRY)&_ZN7ee550603barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee550603barEv,_ZTv0_n16_N7ee550603barEv),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee550603barEv,_ZTv0_n12_N7ee550603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee55060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee55060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee55060[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee55060[] = {
  {&(_ZTV7ee55060[4]),  4,16},
  {&(_ZTV7ee55060[9]),  9,16},
  {&(_ZTV7ee55060[14]),  14,16},
  {&(_tg__ZTV6dd5060__7ee55060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee55060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee55060[];
extern  VTBL_ENTRY _ZTV7ee55060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55060[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee550603barEv,_ZTv0_n12_N7ee550603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee550603barEv,_ZThn16_N7ee550603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee550603barEv,_ZTv0_n16_N7ee550603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550603barEv,_ZThn8_N7ee550603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55060 = {  "ee55060", // class name
  bases_ee55060, 4,
  &(vtc_ee55060[0]), // expected_vtbl_contents
  &(vtt_ee55060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55060),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65060  : dd5060 {
  int e;
  virtual void  foo(); // _ZN7ee650603fooEv
  virtual void  bar(); // _ZN7ee650603barEv
  ~ee65060(); // tgen
  ee65060(); // tgen
};
//SIG(1 ee65060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65060 ::foo(){vfunc_called(this, "_ZN7ee650603fooEv");}
void  ee65060 ::bar(){vfunc_called(this, "_ZN7ee650603barEv");}
ee65060 ::~ee65060(){ note_dtor("ee65060", this);} // tgen
ee65060 ::ee65060(){ note_ctor("ee65060", this);} // tgen

static void Test_ee65060()
{
  extern Class_Descriptor cd_ee65060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65060, buf);
    ee65060 *dp, &lv = *(dp=new (buf) ee65060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee65060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee65060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(16,12), "ee65060");
    check_base_class_offset(lv, (dd5060*), 0, "ee65060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65060.e");
    test_class_info(&lv, &cd_ee65060);
    dp->~ee65060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65060(Test_ee65060, "ee65060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65060C1Ev();
extern void _ZN7ee65060D1Ev();
Name_Map name_map_ee65060[] = {
  NSPAIR(_ZN7ee65060C1Ev),
  NSPAIR(_ZN7ee65060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee65060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65060[];
extern void _ZN7ee650603barEv();
extern void _ZN7ee650603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee650603barEv,_ZTv0_n12_N7ee650603barEv)();
extern void ABISELECT(_ZThn16_N7ee650603barEv,_ZThn12_N7ee650603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee650603fooEv,_ZTv0_n16_N7ee650603fooEv)();
extern void ABISELECT(_ZThn16_N7ee650603fooEv,_ZThn12_N7ee650603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65060[0]),
  (VTBL_ENTRY)&_ZN7ee650603barEv,
  (VTBL_ENTRY)&_ZN7ee650603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee650603barEv,_ZTv0_n12_N7ee650603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee650603fooEv,_ZTv0_n16_N7ee650603fooEv),
};
extern VTBL_ENTRY _ZTV7ee65060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee65060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee65060[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee65060[] = {
  {&(_ZTV7ee65060[3]),  3,11},
  {&(_tg__ZTV6dd5060__7ee65060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee65060[4]),  4,6},
  {&(_ZTV7ee65060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee65060[];
extern  VTBL_ENTRY _ZTV7ee65060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65060[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn12_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee650603fooEv,_ZTv0_n16_N7ee650603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650603fooEv,_ZThn12_N7ee650603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee650603barEv,_ZTv0_n12_N7ee650603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650603barEv,_ZThn12_N7ee650603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65060 = {  "ee65060", // class name
  bases_ee65060, 4,
  &(vtc_ee65060[0]), // expected_vtbl_contents
  &(vtt_ee65060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75060  : virtual dd5060 {
  int e;
  virtual void  foo(); // _ZN7ee750603fooEv
  virtual void  bar(); // _ZN7ee750603barEv
  ~ee75060(); // tgen
  ee75060(); // tgen
};
//SIG(1 ee75060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75060 ::foo(){vfunc_called(this, "_ZN7ee750603fooEv");}
void  ee75060 ::bar(){vfunc_called(this, "_ZN7ee750603barEv");}
ee75060 ::~ee75060(){ note_dtor("ee75060", this);} // tgen
ee75060 ::ee75060(){ note_ctor("ee75060", this);} // tgen

static void Test_ee75060()
{
  extern Class_Descriptor cd_ee75060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75060, buf);
    ee75060 *dp, &lv = *(dp=new (buf) ee75060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee75060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee75060");
    check_base_class_offset(lv, (cc060*)(dd5060*), ABISELECT(32,16), "ee75060");
    check_base_class_offset(lv, (dd5060*), ABISELECT(16,8), "ee75060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75060.e");
    test_class_info(&lv, &cd_ee75060);
    dp->~ee75060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75060(Test_ee75060, "ee75060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75060C1Ev();
extern void _ZN7ee75060D1Ev();
Name_Map name_map_ee75060[] = {
  NSPAIR(_ZN7ee75060C1Ev),
  NSPAIR(_ZN7ee75060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd5060;
extern VTBL_ENTRY _ZTI6dd5060[];
extern  VTBL_ENTRY _ZTV6dd5060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5060[];
static Base_Class bases_ee75060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5060,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75060[];
extern void _ZN7ee750603fooEv();
extern void _ZN7ee750603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee750603barEv,_ZTv0_n16_N7ee750603barEv)();
extern void ABISELECT(_ZThn16_N7ee750603barEv,_ZThn8_N7ee750603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee750603barEv,_ZTv0_n12_N7ee750603barEv)();
extern void ABISELECT(_ZThn32_N7ee750603barEv,_ZThn16_N7ee750603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee750603fooEv,_ZTv0_n16_N7ee750603fooEv)();
extern void ABISELECT(_ZThn32_N7ee750603fooEv,_ZThn16_N7ee750603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75060[0]),
  (VTBL_ENTRY)&_ZN7ee750603fooEv,
  (VTBL_ENTRY)&_ZN7ee750603barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750603barEv,_ZTv0_n16_N7ee750603barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee750603barEv,_ZTv0_n12_N7ee750603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750603fooEv,_ZTv0_n16_N7ee750603fooEv),
};
extern VTBL_ENTRY _ZTV7ee75060[];
extern void _ZN6dd50603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5060__7ee75060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&_ZN6dd50603barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv)();
extern void ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd5060__7ee75060[] = {
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee75060[] = {
  {&(_ZTV7ee75060[4]),  4,17},
  {&(_ZTV7ee75060[10]),  10,17},
  {&(_ZTV7ee75060[15]),  15,17},
  {&(_tg__ZTV6dd5060__7ee75060[3]),  3,4},
  {&(_tg__ZTV4bb605cc060__6dd5060__7ee75060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee75060[];
extern  VTBL_ENTRY _ZTV7ee75060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75060[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50603barEv,_ZTv0_n12_N6dd50603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50603barEv,_ZThn8_N6dd50603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750603fooEv,_ZTv0_n16_N7ee750603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750603fooEv,_ZThn16_N7ee750603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee750603barEv,_ZTv0_n12_N7ee750603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750603barEv,_ZThn16_N7ee750603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750603barEv,_ZTv0_n16_N7ee750603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750603barEv,_ZThn8_N7ee750603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75060 = {  "ee75060", // class name
  bases_ee75060, 4,
  &(vtc_ee75060[0]), // expected_vtbl_contents
  &(vtt_ee75060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75060),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6060  : cc060 {
  int d;
  virtual void  bar(); // _ZN6dd60603barEv
  virtual void  foo(); // _ZN6dd60603fooEv
  ~dd6060(); // tgen
  dd6060(); // tgen
};
//SIG(-1 dd6060) C1{ BC2{ BC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd6060 ::bar(){vfunc_called(this, "_ZN6dd60603barEv");}
void  dd6060 ::foo(){vfunc_called(this, "_ZN6dd60603fooEv");}
dd6060 ::~dd6060(){ note_dtor("dd6060", this);} // tgen
dd6060 ::dd6060(){ note_ctor("dd6060", this);} // tgen

static void Test_dd6060()
{
  extern Class_Descriptor cd_dd6060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6060, buf);
    dd6060 *dp, &lv = *(dp=new (buf) dd6060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(8,4), "dd6060");
    check_base_class_offset(lv, (bb60*)(cc060*), 0, "dd6060");
    check_base_class_offset(lv, (cc060*), 0, "dd6060");
    check_field_offset(lv, d, ABISELECT(20,16), "dd6060.d");
    test_class_info(&lv, &cd_dd6060);
    dp->~dd6060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6060(Test_dd6060, "dd6060", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6060C1Ev();
extern void _ZN6dd6060D1Ev();
Name_Map name_map_dd6060[] = {
  NSPAIR(_ZN6dd6060C1Ev),
  NSPAIR(_ZN6dd6060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd6060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6060[];
extern void _ZN6dd60603barEv();
extern void _ZN6dd60603fooEv();
static  VTBL_ENTRY vtc_dd6060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd6060[0]),
  (VTBL_ENTRY)&_ZN6dd60603barEv,
  (VTBL_ENTRY)&_ZN6dd60603fooEv,
};
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
Class_Descriptor cd_dd6060 = {  "dd6060", // class name
  bases_dd6060, 3,
  &(vtc_dd6060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06060  : dd6060 {
  int e;
  ~ee06060(); // tgen
  ee06060(); // tgen
};
//SIG(1 ee06060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee06060 ::~ee06060(){ note_dtor("ee06060", this);} // tgen
ee06060 ::ee06060(){ note_ctor("ee06060", this);} // tgen

static void Test_ee06060()
{
  extern Class_Descriptor cd_ee06060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06060, buf);
    ee06060 *dp, &lv = *(dp=new (buf) ee06060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(8,4), "ee06060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), 0, "ee06060");
    check_base_class_offset(lv, (cc060*)(dd6060*), 0, "ee06060");
    check_base_class_offset(lv, (dd6060*), 0, "ee06060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee06060.e");
    test_class_info(&lv, &cd_ee06060);
    dp->~ee06060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06060(Test_ee06060, "ee06060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06060C1Ev();
extern void _ZN7ee06060D1Ev();
Name_Map name_map_ee06060[] = {
  NSPAIR(_ZN7ee06060C1Ev),
  NSPAIR(_ZN7ee06060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee06060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06060[];
extern void _ZN6dd60603barEv();
extern void _ZN6dd60603fooEv();
static  VTBL_ENTRY vtc_ee06060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee06060[0]),
  (VTBL_ENTRY)&_ZN6dd60603barEv,
  (VTBL_ENTRY)&_ZN6dd60603fooEv,
};
extern VTBL_ENTRY _ZTI7ee06060[];
extern  VTBL_ENTRY _ZTV7ee06060[];
Class_Descriptor cd_ee06060 = {  "ee06060", // class name
  bases_ee06060, 4,
  &(vtc_ee06060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16060  : virtual dd6060 {
  int e;
  ~ee16060(); // tgen
  ee16060(); // tgen
};
//SIG(1 ee16060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee16060 ::~ee16060(){ note_dtor("ee16060", this);} // tgen
ee16060 ::ee16060(){ note_ctor("ee16060", this);} // tgen

static void Test_ee16060()
{
  extern Class_Descriptor cd_ee16060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16060, buf);
    ee16060 *dp, &lv = *(dp=new (buf) ee16060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(24,12), "ee16060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), ABISELECT(16,8), "ee16060");
    check_base_class_offset(lv, (cc060*)(dd6060*), ABISELECT(16,8), "ee16060");
    check_base_class_offset(lv, (dd6060*), ABISELECT(16,8), "ee16060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16060.e");
    test_class_info(&lv, &cd_ee16060);
    dp->~ee16060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16060(Test_ee16060, "ee16060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16060C1Ev();
extern void _ZN7ee16060D1Ev();
Name_Map name_map_ee16060[] = {
  NSPAIR(_ZN7ee16060C1Ev),
  NSPAIR(_ZN7ee16060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee16060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16060[];
extern void _ZN6dd60603barEv();
extern void _ZN6dd60603fooEv();
static  VTBL_ENTRY vtc_ee16060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16060[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16060[0]),
  (VTBL_ENTRY)&_ZN6dd60603barEv,
  (VTBL_ENTRY)&_ZN6dd60603fooEv,
};
extern VTBL_ENTRY _ZTV7ee16060[];
static  VTT_ENTRY vtt_ee16060[] = {
  {&(_ZTV7ee16060[3]),  3,9},
  {&(_ZTV7ee16060[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee16060[];
extern  VTBL_ENTRY _ZTV7ee16060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16060[];
Class_Descriptor cd_ee16060 = {  "ee16060", // class name
  bases_ee16060, 4,
  &(vtc_ee16060[0]), // expected_vtbl_contents
  &(vtt_ee16060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16060),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26060  : dd6060 {
  int e;
  virtual void  foo(); // _ZN7ee260603fooEv
  ~ee26060(); // tgen
  ee26060(); // tgen
};
//SIG(1 ee26060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26060 ::foo(){vfunc_called(this, "_ZN7ee260603fooEv");}
ee26060 ::~ee26060(){ note_dtor("ee26060", this);} // tgen
ee26060 ::ee26060(){ note_ctor("ee26060", this);} // tgen

static void Test_ee26060()
{
  extern Class_Descriptor cd_ee26060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26060, buf);
    ee26060 *dp, &lv = *(dp=new (buf) ee26060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(8,4), "ee26060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), 0, "ee26060");
    check_base_class_offset(lv, (cc060*)(dd6060*), 0, "ee26060");
    check_base_class_offset(lv, (dd6060*), 0, "ee26060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee26060.e");
    test_class_info(&lv, &cd_ee26060);
    dp->~ee26060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26060(Test_ee26060, "ee26060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26060C1Ev();
extern void _ZN7ee26060D1Ev();
Name_Map name_map_ee26060[] = {
  NSPAIR(_ZN7ee26060C1Ev),
  NSPAIR(_ZN7ee26060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee26060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26060[];
extern void _ZN6dd60603barEv();
extern void _ZN7ee260603fooEv();
static  VTBL_ENTRY vtc_ee26060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee26060[0]),
  (VTBL_ENTRY)&_ZN6dd60603barEv,
  (VTBL_ENTRY)&_ZN7ee260603fooEv,
};
extern VTBL_ENTRY _ZTI7ee26060[];
extern  VTBL_ENTRY _ZTV7ee26060[];
Class_Descriptor cd_ee26060 = {  "ee26060", // class name
  bases_ee26060, 4,
  &(vtc_ee26060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36060  : virtual dd6060 {
  int e;
  virtual void  foo(); // _ZN7ee360603fooEv
  ~ee36060(); // tgen
  ee36060(); // tgen
};
//SIG(1 ee36060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36060 ::foo(){vfunc_called(this, "_ZN7ee360603fooEv");}
ee36060 ::~ee36060(){ note_dtor("ee36060", this);} // tgen
ee36060 ::ee36060(){ note_ctor("ee36060", this);} // tgen

static void Test_ee36060()
{
  extern Class_Descriptor cd_ee36060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36060, buf);
    ee36060 *dp, &lv = *(dp=new (buf) ee36060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(24,12), "ee36060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), ABISELECT(16,8), "ee36060");
    check_base_class_offset(lv, (cc060*)(dd6060*), ABISELECT(16,8), "ee36060");
    check_base_class_offset(lv, (dd6060*), ABISELECT(16,8), "ee36060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36060.e");
    test_class_info(&lv, &cd_ee36060);
    dp->~ee36060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36060(Test_ee36060, "ee36060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36060C1Ev();
extern void _ZN7ee36060D1Ev();
Name_Map name_map_ee36060[] = {
  NSPAIR(_ZN7ee36060C1Ev),
  NSPAIR(_ZN7ee36060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee36060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36060[];
extern void _ZN7ee360603fooEv();
extern void _ZN6dd60603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee360603fooEv,_ZTv0_n16_N7ee360603fooEv)();
extern void ABISELECT(_ZThn16_N7ee360603fooEv,_ZThn8_N7ee360603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36060[0]),
  (VTBL_ENTRY)&_ZN7ee360603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36060[0]),
  (VTBL_ENTRY)&_ZN6dd60603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee360603fooEv,_ZTv0_n16_N7ee360603fooEv),
};
extern VTBL_ENTRY _ZTV7ee36060[];
static  VTT_ENTRY vtt_ee36060[] = {
  {&(_ZTV7ee36060[3]),  3,10},
  {&(_ZTV7ee36060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee36060[];
extern  VTBL_ENTRY _ZTV7ee36060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36060[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee360603fooEv,_ZTv0_n16_N7ee360603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360603fooEv,_ZThn8_N7ee360603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36060 = {  "ee36060", // class name
  bases_ee36060, 4,
  &(vtc_ee36060[0]), // expected_vtbl_contents
  &(vtt_ee36060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46060  : dd6060 {
  int e;
  virtual void  bar(); // _ZN7ee460603barEv
  ~ee46060(); // tgen
  ee46060(); // tgen
};
//SIG(1 ee46060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46060 ::bar(){vfunc_called(this, "_ZN7ee460603barEv");}
ee46060 ::~ee46060(){ note_dtor("ee46060", this);} // tgen
ee46060 ::ee46060(){ note_ctor("ee46060", this);} // tgen

static void Test_ee46060()
{
  extern Class_Descriptor cd_ee46060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46060, buf);
    ee46060 *dp, &lv = *(dp=new (buf) ee46060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(8,4), "ee46060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), 0, "ee46060");
    check_base_class_offset(lv, (cc060*)(dd6060*), 0, "ee46060");
    check_base_class_offset(lv, (dd6060*), 0, "ee46060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee46060.e");
    test_class_info(&lv, &cd_ee46060);
    dp->~ee46060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46060(Test_ee46060, "ee46060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46060C1Ev();
extern void _ZN7ee46060D1Ev();
Name_Map name_map_ee46060[] = {
  NSPAIR(_ZN7ee46060C1Ev),
  NSPAIR(_ZN7ee46060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee46060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46060[];
extern void _ZN7ee460603barEv();
extern void _ZN6dd60603fooEv();
static  VTBL_ENTRY vtc_ee46060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee46060[0]),
  (VTBL_ENTRY)&_ZN7ee460603barEv,
  (VTBL_ENTRY)&_ZN6dd60603fooEv,
};
extern VTBL_ENTRY _ZTI7ee46060[];
extern  VTBL_ENTRY _ZTV7ee46060[];
Class_Descriptor cd_ee46060 = {  "ee46060", // class name
  bases_ee46060, 4,
  &(vtc_ee46060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56060  : virtual dd6060 {
  int e;
  virtual void  bar(); // _ZN7ee560603barEv
  ~ee56060(); // tgen
  ee56060(); // tgen
};
//SIG(1 ee56060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56060 ::bar(){vfunc_called(this, "_ZN7ee560603barEv");}
ee56060 ::~ee56060(){ note_dtor("ee56060", this);} // tgen
ee56060 ::ee56060(){ note_ctor("ee56060", this);} // tgen

static void Test_ee56060()
{
  extern Class_Descriptor cd_ee56060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56060, buf);
    ee56060 *dp, &lv = *(dp=new (buf) ee56060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(24,12), "ee56060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), ABISELECT(16,8), "ee56060");
    check_base_class_offset(lv, (cc060*)(dd6060*), ABISELECT(16,8), "ee56060");
    check_base_class_offset(lv, (dd6060*), ABISELECT(16,8), "ee56060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56060.e");
    test_class_info(&lv, &cd_ee56060);
    dp->~ee56060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56060(Test_ee56060, "ee56060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56060C1Ev();
extern void _ZN7ee56060D1Ev();
Name_Map name_map_ee56060[] = {
  NSPAIR(_ZN7ee56060C1Ev),
  NSPAIR(_ZN7ee56060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee56060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56060[];
extern void _ZN7ee560603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee560603barEv,_ZTv0_n12_N7ee560603barEv)();
extern void ABISELECT(_ZThn16_N7ee560603barEv,_ZThn8_N7ee560603barEv)() __attribute__((weak));
extern void _ZN6dd60603fooEv();
static  VTBL_ENTRY vtc_ee56060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56060[0]),
  (VTBL_ENTRY)&_ZN7ee560603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee560603barEv,_ZTv0_n12_N7ee560603barEv),
  (VTBL_ENTRY)&_ZN6dd60603fooEv,
};
extern VTBL_ENTRY _ZTV7ee56060[];
static  VTT_ENTRY vtt_ee56060[] = {
  {&(_ZTV7ee56060[3]),  3,10},
  {&(_ZTV7ee56060[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee56060[];
extern  VTBL_ENTRY _ZTV7ee56060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56060[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee560603barEv,_ZTv0_n12_N7ee560603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560603barEv,_ZThn8_N7ee560603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56060 = {  "ee56060", // class name
  bases_ee56060, 4,
  &(vtc_ee56060[0]), // expected_vtbl_contents
  &(vtt_ee56060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56060),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66060  : dd6060 {
  int e;
  virtual void  foo(); // _ZN7ee660603fooEv
  virtual void  bar(); // _ZN7ee660603barEv
  ~ee66060(); // tgen
  ee66060(); // tgen
};
//SIG(1 ee66060) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66060 ::foo(){vfunc_called(this, "_ZN7ee660603fooEv");}
void  ee66060 ::bar(){vfunc_called(this, "_ZN7ee660603barEv");}
ee66060 ::~ee66060(){ note_dtor("ee66060", this);} // tgen
ee66060 ::ee66060(){ note_ctor("ee66060", this);} // tgen

static void Test_ee66060()
{
  extern Class_Descriptor cd_ee66060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66060, buf);
    ee66060 *dp, &lv = *(dp=new (buf) ee66060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(8,4), "ee66060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), 0, "ee66060");
    check_base_class_offset(lv, (cc060*)(dd6060*), 0, "ee66060");
    check_base_class_offset(lv, (dd6060*), 0, "ee66060");
    check_field_offset(lv, e, ABISELECT(24,20), "ee66060.e");
    test_class_info(&lv, &cd_ee66060);
    dp->~ee66060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66060(Test_ee66060, "ee66060", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66060C1Ev();
extern void _ZN7ee66060D1Ev();
Name_Map name_map_ee66060[] = {
  NSPAIR(_ZN7ee66060C1Ev),
  NSPAIR(_ZN7ee66060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee66060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66060[];
extern void _ZN7ee660603barEv();
extern void _ZN7ee660603fooEv();
static  VTBL_ENTRY vtc_ee66060[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee66060[0]),
  (VTBL_ENTRY)&_ZN7ee660603barEv,
  (VTBL_ENTRY)&_ZN7ee660603fooEv,
};
extern VTBL_ENTRY _ZTI7ee66060[];
extern  VTBL_ENTRY _ZTV7ee66060[];
Class_Descriptor cd_ee66060 = {  "ee66060", // class name
  bases_ee66060, 4,
  &(vtc_ee66060[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66060),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76060  : virtual dd6060 {
  int e;
  virtual void  foo(); // _ZN7ee760603fooEv
  virtual void  bar(); // _ZN7ee760603barEv
  ~ee76060(); // tgen
  ee76060(); // tgen
};
//SIG(1 ee76060) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76060 ::foo(){vfunc_called(this, "_ZN7ee760603fooEv");}
void  ee76060 ::bar(){vfunc_called(this, "_ZN7ee760603barEv");}
ee76060 ::~ee76060(){ note_dtor("ee76060", this);} // tgen
ee76060 ::ee76060(){ note_ctor("ee76060", this);} // tgen

static void Test_ee76060()
{
  extern Class_Descriptor cd_ee76060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76060, buf);
    ee76060 *dp, &lv = *(dp=new (buf) ee76060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*)(dd6060*), ABISELECT(24,12), "ee76060");
    check_base_class_offset(lv, (bb60*)(cc060*)(dd6060*), ABISELECT(16,8), "ee76060");
    check_base_class_offset(lv, (cc060*)(dd6060*), ABISELECT(16,8), "ee76060");
    check_base_class_offset(lv, (dd6060*), ABISELECT(16,8), "ee76060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76060.e");
    test_class_info(&lv, &cd_ee76060);
    dp->~ee76060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76060(Test_ee76060, "ee76060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76060C1Ev();
extern void _ZN7ee76060D1Ev();
Name_Map name_map_ee76060[] = {
  NSPAIR(_ZN7ee76060C1Ev),
  NSPAIR(_ZN7ee76060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd6060;
extern VTBL_ENTRY _ZTI6dd6060[];
extern  VTBL_ENTRY _ZTV6dd6060[];
static Base_Class bases_ee76060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76060[];
extern void _ZN7ee760603fooEv();
extern void _ZN7ee760603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee760603barEv,_ZTv0_n12_N7ee760603barEv)();
extern void ABISELECT(_ZThn16_N7ee760603barEv,_ZThn8_N7ee760603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee760603fooEv,_ZTv0_n16_N7ee760603fooEv)();
extern void ABISELECT(_ZThn16_N7ee760603fooEv,_ZThn8_N7ee760603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76060[0]),
  (VTBL_ENTRY)&_ZN7ee760603fooEv,
  (VTBL_ENTRY)&_ZN7ee760603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee760603barEv,_ZTv0_n12_N7ee760603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760603fooEv,_ZTv0_n16_N7ee760603fooEv),
};
extern VTBL_ENTRY _ZTV7ee76060[];
static  VTT_ENTRY vtt_ee76060[] = {
  {&(_ZTV7ee76060[3]),  3,11},
  {&(_ZTV7ee76060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee76060[];
extern  VTBL_ENTRY _ZTV7ee76060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76060[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760603fooEv,_ZTv0_n16_N7ee760603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760603fooEv,_ZThn8_N7ee760603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee760603barEv,_ZTv0_n12_N7ee760603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760603barEv,_ZThn8_N7ee760603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76060 = {  "ee76060", // class name
  bases_ee76060, 4,
  &(vtc_ee76060[0]), // expected_vtbl_contents
  &(vtt_ee76060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76060),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7060  : virtual cc060 {
  int d;
  virtual void  bar(); // _ZN6dd70603barEv
  virtual void  foo(); // _ZN6dd70603fooEv
  ~dd7060(); // tgen
  dd7060(); // tgen
};
//SIG(-1 dd7060) C1{ VBC2{ BC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd7060 ::bar(){vfunc_called(this, "_ZN6dd70603barEv");}
void  dd7060 ::foo(){vfunc_called(this, "_ZN6dd70603fooEv");}
dd7060 ::~dd7060(){ note_dtor("dd7060", this);} // tgen
dd7060 ::dd7060(){ note_ctor("dd7060", this);} // tgen

static void Test_dd7060()
{
  extern Class_Descriptor cd_dd7060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7060, buf);
    dd7060 *dp, &lv = *(dp=new (buf) dd7060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,12), "dd7060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,8), "dd7060");
    check_base_class_offset(lv, (cc060*), ABISELECT(16,8), "dd7060");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7060.d");
    test_class_info(&lv, &cd_dd7060);
    dp->~dd7060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7060(Test_dd7060, "dd7060", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7060C1Ev();
extern void _ZN6dd7060D1Ev();
Name_Map name_map_dd7060[] = {
  NSPAIR(_ZN6dd7060C1Ev),
  NSPAIR(_ZN6dd7060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
static Base_Class bases_dd7060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
extern VTBL_ENTRY _ZTV6dd7060[];
static  VTT_ENTRY vtt_dd7060[] = {
  {&(_ZTV6dd7060[3]),  3,11},
  {&(_ZTV6dd7060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7060 = {  "dd7060", // class name
  bases_dd7060, 3,
  &(vtc_dd7060[0]), // expected_vtbl_contents
  &(vtt_dd7060[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7060),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07060  : dd7060 {
  int e;
  ~ee07060(); // tgen
  ee07060(); // tgen
};
//SIG(1 ee07060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee07060 ::~ee07060(){ note_dtor("ee07060", this);} // tgen
ee07060 ::ee07060(){ note_ctor("ee07060", this);} // tgen

static void Test_ee07060()
{
  extern Class_Descriptor cd_ee07060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07060, buf);
    ee07060 *dp, &lv = *(dp=new (buf) ee07060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee07060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee07060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(16,12), "ee07060");
    check_base_class_offset(lv, (dd7060*), 0, "ee07060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07060.e");
    test_class_info(&lv, &cd_ee07060);
    dp->~ee07060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07060(Test_ee07060, "ee07060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07060C1Ev();
extern void _ZN7ee07060D1Ev();
Name_Map name_map_ee07060[] = {
  NSPAIR(_ZN7ee07060C1Ev),
  NSPAIR(_ZN7ee07060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee07060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
extern VTBL_ENTRY _ZTV7ee07060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee07060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee07060[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee07060[] = {
  {&(_ZTV7ee07060[3]),  3,11},
  {&(_tg__ZTV6dd7060__7ee07060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee07060[4]),  4,6},
  {&(_ZTV7ee07060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee07060[];
extern  VTBL_ENTRY _ZTV7ee07060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07060[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07060 = {  "ee07060", // class name
  bases_ee07060, 4,
  &(vtc_ee07060[0]), // expected_vtbl_contents
  &(vtt_ee07060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17060  : virtual dd7060 {
  int e;
  ~ee17060(); // tgen
  ee17060(); // tgen
};
//SIG(1 ee17060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee17060 ::~ee17060(){ note_dtor("ee17060", this);} // tgen
ee17060 ::ee17060(){ note_ctor("ee17060", this);} // tgen

static void Test_ee17060()
{
  extern Class_Descriptor cd_ee17060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17060, buf);
    ee17060 *dp, &lv = *(dp=new (buf) ee17060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee17060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee17060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(32,16), "ee17060");
    check_base_class_offset(lv, (dd7060*), ABISELECT(16,8), "ee17060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17060.e");
    test_class_info(&lv, &cd_ee17060);
    dp->~ee17060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17060(Test_ee17060, "ee17060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17060C1Ev();
extern void _ZN7ee17060D1Ev();
Name_Map name_map_ee17060[] = {
  NSPAIR(_ZN7ee17060C1Ev),
  NSPAIR(_ZN7ee17060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee17060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17060[0]),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
extern VTBL_ENTRY _ZTV7ee17060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee17060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee17060[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee17060[] = {
  {&(_ZTV7ee17060[4]),  4,17},
  {&(_ZTV7ee17060[9]),  9,17},
  {&(_ZTV7ee17060[15]),  15,17},
  {&(_tg__ZTV6dd7060__7ee17060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee17060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee17060[];
extern  VTBL_ENTRY _ZTV7ee17060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17060[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17060 = {  "ee17060", // class name
  bases_ee17060, 4,
  &(vtc_ee17060[0]), // expected_vtbl_contents
  &(vtt_ee17060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17060),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27060  : dd7060 {
  int e;
  virtual void  foo(); // _ZN7ee270603fooEv
  ~ee27060(); // tgen
  ee27060(); // tgen
};
//SIG(1 ee27060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27060 ::foo(){vfunc_called(this, "_ZN7ee270603fooEv");}
ee27060 ::~ee27060(){ note_dtor("ee27060", this);} // tgen
ee27060 ::ee27060(){ note_ctor("ee27060", this);} // tgen

static void Test_ee27060()
{
  extern Class_Descriptor cd_ee27060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27060, buf);
    ee27060 *dp, &lv = *(dp=new (buf) ee27060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee27060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee27060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(16,12), "ee27060");
    check_base_class_offset(lv, (dd7060*), 0, "ee27060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27060.e");
    test_class_info(&lv, &cd_ee27060);
    dp->~ee27060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27060(Test_ee27060, "ee27060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27060C1Ev();
extern void _ZN7ee27060D1Ev();
Name_Map name_map_ee27060[] = {
  NSPAIR(_ZN7ee27060C1Ev),
  NSPAIR(_ZN7ee27060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee27060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27060[];
extern void _ZN6dd70603barEv();
extern void _ZN7ee270603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee270603fooEv,_ZTv0_n16_N7ee270603fooEv)();
extern void ABISELECT(_ZThn16_N7ee270603fooEv,_ZThn12_N7ee270603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN7ee270603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee270603fooEv,_ZTv0_n16_N7ee270603fooEv),
};
extern VTBL_ENTRY _ZTV7ee27060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee27060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee27060[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee27060[] = {
  {&(_ZTV7ee27060[3]),  3,11},
  {&(_tg__ZTV6dd7060__7ee27060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee27060[4]),  4,6},
  {&(_ZTV7ee27060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee27060[];
extern  VTBL_ENTRY _ZTV7ee27060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27060[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee270603fooEv,_ZTv0_n16_N7ee270603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee270603fooEv,_ZThn12_N7ee270603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27060 = {  "ee27060", // class name
  bases_ee27060, 4,
  &(vtc_ee27060[0]), // expected_vtbl_contents
  &(vtt_ee27060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37060  : virtual dd7060 {
  int e;
  virtual void  foo(); // _ZN7ee370603fooEv
  ~ee37060(); // tgen
  ee37060(); // tgen
};
//SIG(1 ee37060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37060 ::foo(){vfunc_called(this, "_ZN7ee370603fooEv");}
ee37060 ::~ee37060(){ note_dtor("ee37060", this);} // tgen
ee37060 ::ee37060(){ note_ctor("ee37060", this);} // tgen

static void Test_ee37060()
{
  extern Class_Descriptor cd_ee37060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37060, buf);
    ee37060 *dp, &lv = *(dp=new (buf) ee37060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee37060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee37060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(32,16), "ee37060");
    check_base_class_offset(lv, (dd7060*), ABISELECT(16,8), "ee37060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37060.e");
    test_class_info(&lv, &cd_ee37060);
    dp->~ee37060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37060(Test_ee37060, "ee37060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37060C1Ev();
extern void _ZN7ee37060D1Ev();
Name_Map name_map_ee37060[] = {
  NSPAIR(_ZN7ee37060C1Ev),
  NSPAIR(_ZN7ee37060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee37060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37060[];
extern void _ZN7ee370603fooEv();
extern void _ZN6dd70603barEv();
extern void ABISELECT(_ZTv0_n40_N7ee370603fooEv,_ZTv0_n20_N7ee370603fooEv)();
extern void ABISELECT(_ZThn16_N7ee370603fooEv,_ZThn8_N7ee370603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee370603fooEv,_ZTv0_n16_N7ee370603fooEv)();
extern void ABISELECT(_ZThn32_N7ee370603fooEv,_ZThn16_N7ee370603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37060[0]),
  (VTBL_ENTRY)&_ZN7ee370603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee370603fooEv,_ZTv0_n20_N7ee370603fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee370603fooEv,_ZTv0_n16_N7ee370603fooEv),
};
extern VTBL_ENTRY _ZTV7ee37060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee37060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee37060[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee37060[] = {
  {&(_ZTV7ee37060[4]),  4,18},
  {&(_ZTV7ee37060[10]),  10,18},
  {&(_ZTV7ee37060[16]),  16,18},
  {&(_tg__ZTV6dd7060__7ee37060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee37060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee37060[];
extern  VTBL_ENTRY _ZTV7ee37060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37060[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee370603fooEv,_ZTv0_n16_N7ee370603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee370603fooEv,_ZThn16_N7ee370603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee370603fooEv,_ZTv0_n20_N7ee370603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370603fooEv,_ZThn8_N7ee370603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37060 = {  "ee37060", // class name
  bases_ee37060, 4,
  &(vtc_ee37060[0]), // expected_vtbl_contents
  &(vtt_ee37060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37060),18, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47060  : dd7060 {
  int e;
  virtual void  bar(); // _ZN7ee470603barEv
  ~ee47060(); // tgen
  ee47060(); // tgen
};
//SIG(1 ee47060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47060 ::bar(){vfunc_called(this, "_ZN7ee470603barEv");}
ee47060 ::~ee47060(){ note_dtor("ee47060", this);} // tgen
ee47060 ::ee47060(){ note_ctor("ee47060", this);} // tgen

static void Test_ee47060()
{
  extern Class_Descriptor cd_ee47060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47060, buf);
    ee47060 *dp, &lv = *(dp=new (buf) ee47060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee47060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee47060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(16,12), "ee47060");
    check_base_class_offset(lv, (dd7060*), 0, "ee47060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47060.e");
    test_class_info(&lv, &cd_ee47060);
    dp->~ee47060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47060(Test_ee47060, "ee47060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47060C1Ev();
extern void _ZN7ee47060D1Ev();
Name_Map name_map_ee47060[] = {
  NSPAIR(_ZN7ee47060C1Ev),
  NSPAIR(_ZN7ee47060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee47060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47060[];
extern void _ZN7ee470603barEv();
extern void _ZN6dd70603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee470603barEv,_ZTv0_n12_N7ee470603barEv)();
extern void ABISELECT(_ZThn16_N7ee470603barEv,_ZThn12_N7ee470603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47060[0]),
  (VTBL_ENTRY)&_ZN7ee470603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee470603barEv,_ZTv0_n12_N7ee470603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
extern VTBL_ENTRY _ZTV7ee47060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee47060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee47060[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee47060[] = {
  {&(_ZTV7ee47060[3]),  3,11},
  {&(_tg__ZTV6dd7060__7ee47060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee47060[4]),  4,6},
  {&(_ZTV7ee47060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee47060[];
extern  VTBL_ENTRY _ZTV7ee47060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47060[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee470603barEv,_ZTv0_n12_N7ee470603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee470603barEv,_ZThn12_N7ee470603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47060 = {  "ee47060", // class name
  bases_ee47060, 4,
  &(vtc_ee47060[0]), // expected_vtbl_contents
  &(vtt_ee47060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57060  : virtual dd7060 {
  int e;
  virtual void  bar(); // _ZN7ee570603barEv
  ~ee57060(); // tgen
  ee57060(); // tgen
};
//SIG(1 ee57060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57060 ::bar(){vfunc_called(this, "_ZN7ee570603barEv");}
ee57060 ::~ee57060(){ note_dtor("ee57060", this);} // tgen
ee57060 ::ee57060(){ note_ctor("ee57060", this);} // tgen

static void Test_ee57060()
{
  extern Class_Descriptor cd_ee57060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57060, buf);
    ee57060 *dp, &lv = *(dp=new (buf) ee57060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee57060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee57060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(32,16), "ee57060");
    check_base_class_offset(lv, (dd7060*), ABISELECT(16,8), "ee57060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57060.e");
    test_class_info(&lv, &cd_ee57060);
    dp->~ee57060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57060(Test_ee57060, "ee57060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57060C1Ev();
extern void _ZN7ee57060D1Ev();
Name_Map name_map_ee57060[] = {
  NSPAIR(_ZN7ee57060C1Ev),
  NSPAIR(_ZN7ee57060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee57060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57060[];
extern void _ZN7ee570603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee570603barEv,_ZTv0_n16_N7ee570603barEv)();
extern void ABISELECT(_ZThn16_N7ee570603barEv,_ZThn8_N7ee570603barEv)() __attribute__((weak));
extern void _ZN6dd70603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee570603barEv,_ZTv0_n12_N7ee570603barEv)();
extern void ABISELECT(_ZThn32_N7ee570603barEv,_ZThn16_N7ee570603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57060[0]),
  (VTBL_ENTRY)&_ZN7ee570603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee570603barEv,_ZTv0_n16_N7ee570603barEv),
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee570603barEv,_ZTv0_n12_N7ee570603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
extern VTBL_ENTRY _ZTV7ee57060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee57060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee57060[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee57060[] = {
  {&(_ZTV7ee57060[4]),  4,18},
  {&(_ZTV7ee57060[10]),  10,18},
  {&(_ZTV7ee57060[16]),  16,18},
  {&(_tg__ZTV6dd7060__7ee57060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee57060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee57060[];
extern  VTBL_ENTRY _ZTV7ee57060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57060[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee570603barEv,_ZTv0_n12_N7ee570603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee570603barEv,_ZThn16_N7ee570603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee570603barEv,_ZTv0_n16_N7ee570603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570603barEv,_ZThn8_N7ee570603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57060 = {  "ee57060", // class name
  bases_ee57060, 4,
  &(vtc_ee57060[0]), // expected_vtbl_contents
  &(vtt_ee57060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57060),18, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67060  : dd7060 {
  int e;
  virtual void  foo(); // _ZN7ee670603fooEv
  virtual void  bar(); // _ZN7ee670603barEv
  ~ee67060(); // tgen
  ee67060(); // tgen
};
//SIG(1 ee67060) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67060 ::foo(){vfunc_called(this, "_ZN7ee670603fooEv");}
void  ee67060 ::bar(){vfunc_called(this, "_ZN7ee670603barEv");}
ee67060 ::~ee67060(){ note_dtor("ee67060", this);} // tgen
ee67060 ::ee67060(){ note_ctor("ee67060", this);} // tgen

static void Test_ee67060()
{
  extern Class_Descriptor cd_ee67060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67060, buf);
    ee67060 *dp, &lv = *(dp=new (buf) ee67060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(24,16), "ee67060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(16,12), "ee67060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(16,12), "ee67060");
    check_base_class_offset(lv, (dd7060*), 0, "ee67060");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67060.e");
    test_class_info(&lv, &cd_ee67060);
    dp->~ee67060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67060(Test_ee67060, "ee67060", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67060C1Ev();
extern void _ZN7ee67060D1Ev();
Name_Map name_map_ee67060[] = {
  NSPAIR(_ZN7ee67060C1Ev),
  NSPAIR(_ZN7ee67060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee67060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67060[];
extern void _ZN7ee670603barEv();
extern void _ZN7ee670603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee670603barEv,_ZTv0_n12_N7ee670603barEv)();
extern void ABISELECT(_ZThn16_N7ee670603barEv,_ZThn12_N7ee670603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee670603fooEv,_ZTv0_n16_N7ee670603fooEv)();
extern void ABISELECT(_ZThn16_N7ee670603fooEv,_ZThn12_N7ee670603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67060[0]),
  (VTBL_ENTRY)&_ZN7ee670603barEv,
  (VTBL_ENTRY)&_ZN7ee670603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee670603barEv,_ZTv0_n12_N7ee670603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee670603fooEv,_ZTv0_n16_N7ee670603fooEv),
};
extern VTBL_ENTRY _ZTV7ee67060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee67060[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee67060[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee67060[] = {
  {&(_ZTV7ee67060[3]),  3,11},
  {&(_tg__ZTV6dd7060__7ee67060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee67060[4]),  4,6},
  {&(_ZTV7ee67060[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee67060[];
extern  VTBL_ENTRY _ZTV7ee67060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67060[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn12_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn12_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee670603fooEv,_ZTv0_n16_N7ee670603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670603fooEv,_ZThn12_N7ee670603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee670603barEv,_ZTv0_n12_N7ee670603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670603barEv,_ZThn12_N7ee670603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67060 = {  "ee67060", // class name
  bases_ee67060, 4,
  &(vtc_ee67060[0]), // expected_vtbl_contents
  &(vtt_ee67060[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67060),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67060),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67060),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77060  : virtual dd7060 {
  int e;
  virtual void  foo(); // _ZN7ee770603fooEv
  virtual void  bar(); // _ZN7ee770603barEv
  ~ee77060(); // tgen
  ee77060(); // tgen
};
//SIG(1 ee77060) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77060 ::foo(){vfunc_called(this, "_ZN7ee770603fooEv");}
void  ee77060 ::bar(){vfunc_called(this, "_ZN7ee770603barEv");}
ee77060 ::~ee77060(){ note_dtor("ee77060", this);} // tgen
ee77060 ::ee77060(){ note_ctor("ee77060", this);} // tgen

static void Test_ee77060()
{
  extern Class_Descriptor cd_ee77060;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77060, buf);
    ee77060 *dp, &lv = *(dp=new (buf) ee77060());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77060)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77060)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc060*), ABISELECT(40,20), "ee77060");
    check_base_class_offset(lv, (bb60*)(cc060*), ABISELECT(32,16), "ee77060");
    check_base_class_offset(lv, (cc060*)(dd7060*), ABISELECT(32,16), "ee77060");
    check_base_class_offset(lv, (dd7060*), ABISELECT(16,8), "ee77060");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77060.e");
    test_class_info(&lv, &cd_ee77060);
    dp->~ee77060();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77060(Test_ee77060, "ee77060", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77060C1Ev();
extern void _ZN7ee77060D1Ev();
Name_Map name_map_ee77060[] = {
  NSPAIR(_ZN7ee77060C1Ev),
  NSPAIR(_ZN7ee77060D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc060;
extern VTBL_ENTRY _ZTI5cc060[];
extern  VTBL_ENTRY _ZTV5cc060[];
extern Class_Descriptor cd_dd7060;
extern VTBL_ENTRY _ZTI6dd7060[];
extern  VTBL_ENTRY _ZTV6dd7060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7060[];
static Base_Class bases_ee77060[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc060,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7060,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77060[];
extern void _ZN7ee770603fooEv();
extern void _ZN7ee770603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee770603barEv,_ZTv0_n16_N7ee770603barEv)();
extern void ABISELECT(_ZThn16_N7ee770603barEv,_ZThn8_N7ee770603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee770603fooEv,_ZTv0_n20_N7ee770603fooEv)();
extern void ABISELECT(_ZThn16_N7ee770603fooEv,_ZThn8_N7ee770603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee770603barEv,_ZTv0_n12_N7ee770603barEv)();
extern void ABISELECT(_ZThn32_N7ee770603barEv,_ZThn16_N7ee770603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee770603fooEv,_ZTv0_n16_N7ee770603fooEv)();
extern void ABISELECT(_ZThn32_N7ee770603fooEv,_ZThn16_N7ee770603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77060[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77060[0]),
  (VTBL_ENTRY)&_ZN7ee770603fooEv,
  (VTBL_ENTRY)&_ZN7ee770603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770603barEv,_ZTv0_n16_N7ee770603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770603fooEv,_ZTv0_n20_N7ee770603fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee770603barEv,_ZTv0_n12_N7ee770603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770603fooEv,_ZTv0_n16_N7ee770603fooEv),
};
extern VTBL_ENTRY _ZTV7ee77060[];
extern void _ZN6dd70603barEv();
extern void _ZN6dd70603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7060__7ee77060[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&_ZN6dd70603barEv,
  (VTBL_ENTRY)&_ZN6dd70603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv)();
extern void ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv)();
extern void ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb605cc060__6dd7060__7ee77060[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7060[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv),
};
static  VTT_ENTRY vtt_ee77060[] = {
  {&(_ZTV7ee77060[4]),  4,19},
  {&(_ZTV7ee77060[11]),  11,19},
  {&(_ZTV7ee77060[17]),  17,19},
  {&(_tg__ZTV6dd7060__7ee77060[3]),  3,5},
  {&(_tg__ZTV4bb605cc060__6dd7060__7ee77060[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee77060[];
extern  VTBL_ENTRY _ZTV7ee77060[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77060[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70603fooEv,_ZTv0_n16_N6dd70603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603fooEv,_ZThn8_N6dd70603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70603barEv,_ZTv0_n12_N6dd70603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70603barEv,_ZThn8_N6dd70603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770603fooEv,_ZTv0_n16_N7ee770603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770603fooEv,_ZThn16_N7ee770603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee770603barEv,_ZTv0_n12_N7ee770603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770603barEv,_ZThn16_N7ee770603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770603fooEv,_ZTv0_n20_N7ee770603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770603fooEv,_ZThn8_N7ee770603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770603barEv,_ZTv0_n16_N7ee770603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770603barEv,_ZThn8_N7ee770603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77060 = {  "ee77060", // class name
  bases_ee77060, 4,
  &(vtc_ee77060[0]), // expected_vtbl_contents
  &(vtt_ee77060[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77060),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77060),19, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77060),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc160  : virtual bb60 {
  int c;
  ~cc160(); // tgen
  cc160(); // tgen
};
//SIG(-1 cc160) C1{ VBC2{ BC3{ Fi} v1 v2 Fi} Fi}


cc160 ::~cc160(){ note_dtor("cc160", this);} // tgen
cc160 ::cc160(){ note_ctor("cc160", this);} // tgen

static void Test_cc160()
{
  extern Class_Descriptor cd_cc160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_cc160, buf);
    cc160 *dp, &lv = *(dp=new (buf) cc160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(cc160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(24,12), "cc160");
    check_base_class_offset(lv, (bb60*), ABISELECT(16,8), "cc160");
    check_field_offset(lv, c, ABISELECT(8,4), "cc160.c");
    test_class_info(&lv, &cd_cc160);
    dp->~cc160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc160(Test_cc160, "cc160", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN5cc160C1Ev();
extern void _ZN5cc160D1Ev();
Name_Map name_map_cc160[] = {
  NSPAIR(_ZN5cc160C1Ev),
  NSPAIR(_ZN5cc160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
static Base_Class bases_cc160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc160[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_cc160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV5cc160[];
static  VTT_ENTRY vtt_cc160[] = {
  {&(_ZTV5cc160[3]),  3,9},
  {&(_ZTV5cc160[7]),  7,9},
};
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
Class_Descriptor cd_cc160 = {  "cc160", // class name
  bases_cc160, 2,
  &(vtc_cc160[0]), // expected_vtbl_contents
  &(vtt_cc160[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI5cc160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc160),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc160),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0160  : cc160 {
  int d;
  ~dd0160(); // tgen
  dd0160(); // tgen
};
//SIG(-1 dd0160) C1{ BC2{ VBC3{ BC4{ Fi} v1 v2 Fi} Fi} Fi}


dd0160 ::~dd0160(){ note_dtor("dd0160", this);} // tgen
dd0160 ::dd0160(){ note_ctor("dd0160", this);} // tgen

static void Test_dd0160()
{
  extern Class_Descriptor cd_dd0160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd0160, buf);
    dd0160 *dp, &lv = *(dp=new (buf) dd0160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd0160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(24,16), "dd0160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(16,12), "dd0160");
    check_base_class_offset(lv, (cc160*), 0, "dd0160");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0160.d");
    test_class_info(&lv, &cd_dd0160);
    dp->~dd0160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0160(Test_dd0160, "dd0160", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd0160C1Ev();
extern void _ZN6dd0160D1Ev();
Name_Map name_map_dd0160[] = {
  NSPAIR(_ZN6dd0160C1Ev),
  NSPAIR(_ZN6dd0160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd0160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0160[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd0160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV6dd0160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd0160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd0160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd0160[] = {
  {&(_ZTV6dd0160[3]),  3,9},
  {&(_tg__ZTV5cc160__6dd0160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd0160[4]),  4,6},
  {&(_ZTV6dd0160[7]),  7,9},
};
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
Class_Descriptor cd_dd0160 = {  "dd0160", // class name
  bases_dd0160, 3,
  &(vtc_dd0160[0]), // expected_vtbl_contents
  &(vtt_dd0160[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd0160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0160),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0160),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00160  : dd0160 {
  int e;
  ~ee00160(); // tgen
  ee00160(); // tgen
};
//SIG(1 ee00160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee00160 ::~ee00160(){ note_dtor("ee00160", this);} // tgen
ee00160 ::ee00160(){ note_ctor("ee00160", this);} // tgen

static void Test_ee00160()
{
  extern Class_Descriptor cd_ee00160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee00160, buf);
    ee00160 *dp, &lv = *(dp=new (buf) ee00160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee00160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee00160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(24,16), "ee00160");
    check_base_class_offset(lv, (cc160*)(dd0160*), 0, "ee00160");
    check_base_class_offset(lv, (dd0160*), 0, "ee00160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00160.e");
    test_class_info(&lv, &cd_ee00160);
    dp->~ee00160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00160(Test_ee00160, "ee00160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee00160C1Ev();
extern void _ZN7ee00160D1Ev();
Name_Map name_map_ee00160[] = {
  NSPAIR(_ZN7ee00160C1Ev),
  NSPAIR(_ZN7ee00160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee00160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00160[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee00160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00160[0]),
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee00160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee00160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee00160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee00160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee00160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee00160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee00160[] = {
  {&(_ZTV7ee00160[3]),  3,9},
  {&(_tg__ZTV6dd0160__7ee00160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee00160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee00160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee00160[4]),  4,6},
  {&(_ZTV7ee00160[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee00160[];
extern  VTBL_ENTRY _ZTV7ee00160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00160[];
Class_Descriptor cd_ee00160 = {  "ee00160", // class name
  bases_ee00160, 4,
  &(vtc_ee00160[0]), // expected_vtbl_contents
  &(vtt_ee00160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee00160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00160),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10160  : virtual dd0160 {
  int e;
  ~ee10160(); // tgen
  ee10160(); // tgen
};
//SIG(1 ee10160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee10160 ::~ee10160(){ note_dtor("ee10160", this);} // tgen
ee10160 ::ee10160(){ note_ctor("ee10160", this);} // tgen

static void Test_ee10160()
{
  extern Class_Descriptor cd_ee10160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee10160, buf);
    ee10160 *dp, &lv = *(dp=new (buf) ee10160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee10160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee10160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(32,20), "ee10160");
    check_base_class_offset(lv, (cc160*)(dd0160*), ABISELECT(16,8), "ee10160");
    check_base_class_offset(lv, (dd0160*), ABISELECT(16,8), "ee10160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10160.e");
    test_class_info(&lv, &cd_ee10160);
    dp->~ee10160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10160(Test_ee10160, "ee10160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee10160C1Ev();
extern void _ZN7ee10160D1Ev();
Name_Map name_map_ee10160[] = {
  NSPAIR(_ZN7ee10160C1Ev),
  NSPAIR(_ZN7ee10160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee10160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10160[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee10160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10160[0]),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10160[0]),
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee10160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee10160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee10160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee10160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee10160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee10160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee10160[] = {
  {&(_ZTV7ee10160[4]),  4,13},
  {&(_ZTV7ee10160[7]),  7,13},
  {&(_ZTV7ee10160[11]),  11,13},
  {&(_tg__ZTV6dd0160__7ee10160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee10160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee10160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee10160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee10160[];
extern  VTBL_ENTRY _ZTV7ee10160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10160[];
Class_Descriptor cd_ee10160 = {  "ee10160", // class name
  bases_ee10160, 4,
  &(vtc_ee10160[0]), // expected_vtbl_contents
  &(vtt_ee10160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee10160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10160),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20160  : dd0160 {
  int e;
  virtual void  foo(); // _ZN7ee201603fooEv
  ~ee20160(); // tgen
  ee20160(); // tgen
};
//SIG(1 ee20160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee20160 ::foo(){vfunc_called(this, "_ZN7ee201603fooEv");}
ee20160 ::~ee20160(){ note_dtor("ee20160", this);} // tgen
ee20160 ::ee20160(){ note_ctor("ee20160", this);} // tgen

static void Test_ee20160()
{
  extern Class_Descriptor cd_ee20160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee20160, buf);
    ee20160 *dp, &lv = *(dp=new (buf) ee20160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee20160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee20160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(24,16), "ee20160");
    check_base_class_offset(lv, (cc160*)(dd0160*), 0, "ee20160");
    check_base_class_offset(lv, (dd0160*), 0, "ee20160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20160.e");
    test_class_info(&lv, &cd_ee20160);
    dp->~ee20160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20160(Test_ee20160, "ee20160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee20160C1Ev();
extern void _ZN7ee20160D1Ev();
Name_Map name_map_ee20160[] = {
  NSPAIR(_ZN7ee20160C1Ev),
  NSPAIR(_ZN7ee20160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee20160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20160[];
extern void _ZN7ee201603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee201603fooEv,_ZTv0_n16_N7ee201603fooEv)();
extern void ABISELECT(_ZThn24_N7ee201603fooEv,_ZThn16_N7ee201603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee20160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20160[0]),
  (VTBL_ENTRY)&_ZN7ee201603fooEv,
  ABISELECT(-24,-16),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee20160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee201603fooEv,_ZTv0_n16_N7ee201603fooEv),
};
extern VTBL_ENTRY _ZTV7ee20160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee20160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee20160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee20160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee20160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee20160[] = {
  {&(_ZTV7ee20160[3]),  3,10},
  {&(_tg__ZTV6dd0160__7ee20160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee20160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee20160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee20160[4]),  4,6},
  {&(_ZTV7ee20160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee20160[];
extern  VTBL_ENTRY _ZTV7ee20160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20160[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee201603fooEv,_ZTv0_n16_N7ee201603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee201603fooEv,_ZThn16_N7ee201603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee20160 = {  "ee20160", // class name
  bases_ee20160, 4,
  &(vtc_ee20160[0]), // expected_vtbl_contents
  &(vtt_ee20160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee20160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30160  : virtual dd0160 {
  int e;
  virtual void  foo(); // _ZN7ee301603fooEv
  ~ee30160(); // tgen
  ee30160(); // tgen
};
//SIG(1 ee30160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee30160 ::foo(){vfunc_called(this, "_ZN7ee301603fooEv");}
ee30160 ::~ee30160(){ note_dtor("ee30160", this);} // tgen
ee30160 ::ee30160(){ note_ctor("ee30160", this);} // tgen

static void Test_ee30160()
{
  extern Class_Descriptor cd_ee30160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee30160, buf);
    ee30160 *dp, &lv = *(dp=new (buf) ee30160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee30160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee30160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(32,20), "ee30160");
    check_base_class_offset(lv, (cc160*)(dd0160*), ABISELECT(16,8), "ee30160");
    check_base_class_offset(lv, (dd0160*), ABISELECT(16,8), "ee30160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30160.e");
    test_class_info(&lv, &cd_ee30160);
    dp->~ee30160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30160(Test_ee30160, "ee30160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee30160C1Ev();
extern void _ZN7ee30160D1Ev();
Name_Map name_map_ee30160[] = {
  NSPAIR(_ZN7ee30160C1Ev),
  NSPAIR(_ZN7ee30160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee30160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30160[];
extern void _ZN7ee301603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee301603fooEv,_ZTv0_n16_N7ee301603fooEv)();
extern void ABISELECT(_ZThn32_N7ee301603fooEv,_ZThn20_N7ee301603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30160[0]),
  (VTBL_ENTRY)&_ZN7ee301603fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30160[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee30160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee301603fooEv,_ZTv0_n16_N7ee301603fooEv),
};
extern VTBL_ENTRY _ZTV7ee30160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee30160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee30160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee30160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee30160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee30160[] = {
  {&(_ZTV7ee30160[4]),  4,14},
  {&(_ZTV7ee30160[8]),  8,14},
  {&(_ZTV7ee30160[12]),  12,14},
  {&(_tg__ZTV6dd0160__7ee30160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee30160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee30160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee30160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee30160[];
extern  VTBL_ENTRY _ZTV7ee30160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30160[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee301603fooEv,_ZTv0_n16_N7ee301603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee301603fooEv,_ZThn20_N7ee301603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30160 = {  "ee30160", // class name
  bases_ee30160, 4,
  &(vtc_ee30160[0]), // expected_vtbl_contents
  &(vtt_ee30160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee30160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40160  : dd0160 {
  int e;
  virtual void  bar(); // _ZN7ee401603barEv
  ~ee40160(); // tgen
  ee40160(); // tgen
};
//SIG(1 ee40160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee40160 ::bar(){vfunc_called(this, "_ZN7ee401603barEv");}
ee40160 ::~ee40160(){ note_dtor("ee40160", this);} // tgen
ee40160 ::ee40160(){ note_ctor("ee40160", this);} // tgen

static void Test_ee40160()
{
  extern Class_Descriptor cd_ee40160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee40160, buf);
    ee40160 *dp, &lv = *(dp=new (buf) ee40160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee40160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee40160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(24,16), "ee40160");
    check_base_class_offset(lv, (cc160*)(dd0160*), 0, "ee40160");
    check_base_class_offset(lv, (dd0160*), 0, "ee40160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40160.e");
    test_class_info(&lv, &cd_ee40160);
    dp->~ee40160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40160(Test_ee40160, "ee40160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee40160C1Ev();
extern void _ZN7ee40160D1Ev();
Name_Map name_map_ee40160[] = {
  NSPAIR(_ZN7ee40160C1Ev),
  NSPAIR(_ZN7ee40160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee40160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40160[];
extern void _ZN7ee401603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee401603barEv,_ZTv0_n12_N7ee401603barEv)();
extern void ABISELECT(_ZThn24_N7ee401603barEv,_ZThn16_N7ee401603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee40160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40160[0]),
  (VTBL_ENTRY)&_ZN7ee401603barEv,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee40160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee401603barEv,_ZTv0_n12_N7ee401603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee40160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee40160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee40160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee40160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee40160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee40160[] = {
  {&(_ZTV7ee40160[3]),  3,10},
  {&(_tg__ZTV6dd0160__7ee40160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee40160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee40160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee40160[4]),  4,6},
  {&(_ZTV7ee40160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee40160[];
extern  VTBL_ENTRY _ZTV7ee40160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40160[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee401603barEv,_ZTv0_n12_N7ee401603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee401603barEv,_ZThn16_N7ee401603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee40160 = {  "ee40160", // class name
  bases_ee40160, 4,
  &(vtc_ee40160[0]), // expected_vtbl_contents
  &(vtt_ee40160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee40160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50160  : virtual dd0160 {
  int e;
  virtual void  bar(); // _ZN7ee501603barEv
  ~ee50160(); // tgen
  ee50160(); // tgen
};
//SIG(1 ee50160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee50160 ::bar(){vfunc_called(this, "_ZN7ee501603barEv");}
ee50160 ::~ee50160(){ note_dtor("ee50160", this);} // tgen
ee50160 ::ee50160(){ note_ctor("ee50160", this);} // tgen

static void Test_ee50160()
{
  extern Class_Descriptor cd_ee50160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee50160, buf);
    ee50160 *dp, &lv = *(dp=new (buf) ee50160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee50160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee50160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(32,20), "ee50160");
    check_base_class_offset(lv, (cc160*)(dd0160*), ABISELECT(16,8), "ee50160");
    check_base_class_offset(lv, (dd0160*), ABISELECT(16,8), "ee50160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50160.e");
    test_class_info(&lv, &cd_ee50160);
    dp->~ee50160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50160(Test_ee50160, "ee50160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee50160C1Ev();
extern void _ZN7ee50160D1Ev();
Name_Map name_map_ee50160[] = {
  NSPAIR(_ZN7ee50160C1Ev),
  NSPAIR(_ZN7ee50160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee50160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50160[];
extern void _ZN7ee501603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee501603barEv,_ZTv0_n12_N7ee501603barEv)();
extern void ABISELECT(_ZThn32_N7ee501603barEv,_ZThn20_N7ee501603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee50160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50160[0]),
  (VTBL_ENTRY)&_ZN7ee501603barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50160[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee50160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee501603barEv,_ZTv0_n12_N7ee501603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee50160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee50160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee50160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee50160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee50160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee50160[] = {
  {&(_ZTV7ee50160[4]),  4,14},
  {&(_ZTV7ee50160[8]),  8,14},
  {&(_ZTV7ee50160[12]),  12,14},
  {&(_tg__ZTV6dd0160__7ee50160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee50160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee50160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee50160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee50160[];
extern  VTBL_ENTRY _ZTV7ee50160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50160[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee501603barEv,_ZTv0_n12_N7ee501603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee501603barEv,_ZThn20_N7ee501603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50160 = {  "ee50160", // class name
  bases_ee50160, 4,
  &(vtc_ee50160[0]), // expected_vtbl_contents
  &(vtt_ee50160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee50160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60160  : dd0160 {
  int e;
  virtual void  foo(); // _ZN7ee601603fooEv
  virtual void  bar(); // _ZN7ee601603barEv
  ~ee60160(); // tgen
  ee60160(); // tgen
};
//SIG(1 ee60160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60160 ::foo(){vfunc_called(this, "_ZN7ee601603fooEv");}
void  ee60160 ::bar(){vfunc_called(this, "_ZN7ee601603barEv");}
ee60160 ::~ee60160(){ note_dtor("ee60160", this);} // tgen
ee60160 ::ee60160(){ note_ctor("ee60160", this);} // tgen

static void Test_ee60160()
{
  extern Class_Descriptor cd_ee60160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee60160, buf);
    ee60160 *dp, &lv = *(dp=new (buf) ee60160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee60160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee60160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(24,16), "ee60160");
    check_base_class_offset(lv, (cc160*)(dd0160*), 0, "ee60160");
    check_base_class_offset(lv, (dd0160*), 0, "ee60160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60160.e");
    test_class_info(&lv, &cd_ee60160);
    dp->~ee60160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60160(Test_ee60160, "ee60160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee60160C1Ev();
extern void _ZN7ee60160D1Ev();
Name_Map name_map_ee60160[] = {
  NSPAIR(_ZN7ee60160C1Ev),
  NSPAIR(_ZN7ee60160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee60160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60160[];
extern void _ZN7ee601603fooEv();
extern void _ZN7ee601603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee601603barEv,_ZTv0_n12_N7ee601603barEv)();
extern void ABISELECT(_ZThn24_N7ee601603barEv,_ZThn16_N7ee601603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee601603fooEv,_ZTv0_n16_N7ee601603fooEv)();
extern void ABISELECT(_ZThn24_N7ee601603fooEv,_ZThn16_N7ee601603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee60160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60160[0]),
  (VTBL_ENTRY)&_ZN7ee601603fooEv,
  (VTBL_ENTRY)&_ZN7ee601603barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee60160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee601603barEv,_ZTv0_n12_N7ee601603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee601603fooEv,_ZTv0_n16_N7ee601603fooEv),
};
extern VTBL_ENTRY _ZTV7ee60160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee60160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee60160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee60160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee60160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee60160[] = {
  {&(_ZTV7ee60160[3]),  3,11},
  {&(_tg__ZTV6dd0160__7ee60160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee60160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee60160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee60160[4]),  4,6},
  {&(_ZTV7ee60160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee60160[];
extern  VTBL_ENTRY _ZTV7ee60160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60160[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee601603fooEv,_ZTv0_n16_N7ee601603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601603fooEv,_ZThn16_N7ee601603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee601603barEv,_ZTv0_n12_N7ee601603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601603barEv,_ZThn16_N7ee601603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee60160 = {  "ee60160", // class name
  bases_ee60160, 4,
  &(vtc_ee60160[0]), // expected_vtbl_contents
  &(vtt_ee60160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee60160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70160  : virtual dd0160 {
  int e;
  virtual void  foo(); // _ZN7ee701603fooEv
  virtual void  bar(); // _ZN7ee701603barEv
  ~ee70160(); // tgen
  ee70160(); // tgen
};
//SIG(1 ee70160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70160 ::foo(){vfunc_called(this, "_ZN7ee701603fooEv");}
void  ee70160 ::bar(){vfunc_called(this, "_ZN7ee701603barEv");}
ee70160 ::~ee70160(){ note_dtor("ee70160", this);} // tgen
ee70160 ::ee70160(){ note_ctor("ee70160", this);} // tgen

static void Test_ee70160()
{
  extern Class_Descriptor cd_ee70160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee70160, buf);
    ee70160 *dp, &lv = *(dp=new (buf) ee70160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee70160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee70160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd0160*), ABISELECT(32,20), "ee70160");
    check_base_class_offset(lv, (cc160*)(dd0160*), ABISELECT(16,8), "ee70160");
    check_base_class_offset(lv, (dd0160*), ABISELECT(16,8), "ee70160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70160.e");
    test_class_info(&lv, &cd_ee70160);
    dp->~ee70160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70160(Test_ee70160, "ee70160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee70160C1Ev();
extern void _ZN7ee70160D1Ev();
Name_Map name_map_ee70160[] = {
  NSPAIR(_ZN7ee70160C1Ev),
  NSPAIR(_ZN7ee70160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd0160;
extern VTBL_ENTRY _ZTI6dd0160[];
extern  VTBL_ENTRY _ZTV6dd0160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0160[];
static Base_Class bases_ee70160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70160[];
extern void _ZN7ee701603fooEv();
extern void _ZN7ee701603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee701603barEv,_ZTv0_n12_N7ee701603barEv)();
extern void ABISELECT(_ZThn32_N7ee701603barEv,_ZThn20_N7ee701603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee701603fooEv,_ZTv0_n16_N7ee701603fooEv)();
extern void ABISELECT(_ZThn32_N7ee701603fooEv,_ZThn20_N7ee701603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70160[0]),
  (VTBL_ENTRY)&_ZN7ee701603fooEv,
  (VTBL_ENTRY)&_ZN7ee701603barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee70160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee701603barEv,_ZTv0_n12_N7ee701603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee701603fooEv,_ZTv0_n16_N7ee701603fooEv),
};
extern VTBL_ENTRY _ZTV7ee70160[];
static  VTBL_ENTRY _tg__ZTV6dd0160__7ee70160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd0160__7ee70160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd0160__7ee70160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd0160__7ee70160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee70160[] = {
  {&(_ZTV7ee70160[4]),  4,15},
  {&(_ZTV7ee70160[9]),  9,15},
  {&(_ZTV7ee70160[13]),  13,15},
  {&(_tg__ZTV6dd0160__7ee70160[3]),  3,3},
  {&(_tg__ZTV5cc1606dd0160__7ee70160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd0160__7ee70160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd0160__7ee70160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee70160[];
extern  VTBL_ENTRY _ZTV7ee70160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70160[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee701603fooEv,_ZTv0_n16_N7ee701603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701603fooEv,_ZThn20_N7ee701603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee701603barEv,_ZTv0_n12_N7ee701603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701603barEv,_ZThn20_N7ee701603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70160 = {  "ee70160", // class name
  bases_ee70160, 4,
  &(vtc_ee70160[0]), // expected_vtbl_contents
  &(vtt_ee70160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee70160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1160  : virtual cc160 {
  int d;
  ~dd1160(); // tgen
  dd1160(); // tgen
};
//SIG(-1 dd1160) C1{ VBC2{ VBC3{ BC4{ Fi} v1 v2 Fi} Fi} Fi}


dd1160 ::~dd1160(){ note_dtor("dd1160", this);} // tgen
dd1160 ::dd1160(){ note_ctor("dd1160", this);} // tgen

static void Test_dd1160()
{
  extern Class_Descriptor cd_dd1160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd1160, buf);
    dd1160 *dp, &lv = *(dp=new (buf) dd1160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd1160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,20), "dd1160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,16), "dd1160");
    check_base_class_offset(lv, (cc160*), ABISELECT(16,8), "dd1160");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1160.d");
    test_class_info(&lv, &cd_dd1160);
    dp->~dd1160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1160(Test_dd1160, "dd1160", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd1160C1Ev();
extern void _ZN6dd1160D1Ev();
Name_Map name_map_dd1160[] = {
  NSPAIR(_ZN6dd1160C1Ev),
  NSPAIR(_ZN6dd1160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd1160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1160[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd1160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV6dd1160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd1160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd1160[] = {
  {&(_ZTV6dd1160[4]),  4,13},
  {&(_ZTV6dd1160[7]),  7,13},
  {&(_ZTV6dd1160[11]),  11,13},
  {&(_tg__ZTV5cc160__6dd1160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd1160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
Class_Descriptor cd_dd1160 = {  "dd1160", // class name
  bases_dd1160, 3,
  &(vtc_dd1160[0]), // expected_vtbl_contents
  &(vtt_dd1160[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd1160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1160),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1160),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01160  : dd1160 {
  int e;
  ~ee01160(); // tgen
  ee01160(); // tgen
};
//SIG(1 ee01160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee01160 ::~ee01160(){ note_dtor("ee01160", this);} // tgen
ee01160 ::ee01160(){ note_ctor("ee01160", this);} // tgen

static void Test_ee01160()
{
  extern Class_Descriptor cd_ee01160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee01160, buf);
    ee01160 *dp, &lv = *(dp=new (buf) ee01160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee01160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee01160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee01160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(16,12), "ee01160");
    check_base_class_offset(lv, (dd1160*), 0, "ee01160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01160.e");
    test_class_info(&lv, &cd_ee01160);
    dp->~ee01160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01160(Test_ee01160, "ee01160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee01160C1Ev();
extern void _ZN7ee01160D1Ev();
Name_Map name_map_ee01160[] = {
  NSPAIR(_ZN7ee01160C1Ev),
  NSPAIR(_ZN7ee01160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee01160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01160[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee01160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01160[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01160[0]),
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee01160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee01160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee01160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee01160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee01160[] = {
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee01160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee01160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee01160[] = {
  {&(_ZTV7ee01160[4]),  4,13},
  {&(_tg__ZTV6dd1160__7ee01160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee01160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee01160[4]),  4,6},
  {&(_ZTV7ee01160[7]),  7,13},
  {&(_ZTV7ee01160[11]),  11,13},
  {&(_tg__ZTV5cc160__7ee01160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee01160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee01160[];
extern  VTBL_ENTRY _ZTV7ee01160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01160[];
Class_Descriptor cd_ee01160 = {  "ee01160", // class name
  bases_ee01160, 4,
  &(vtc_ee01160[0]), // expected_vtbl_contents
  &(vtt_ee01160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee01160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01160),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11160  : virtual dd1160 {
  int e;
  ~ee11160(); // tgen
  ee11160(); // tgen
};
//SIG(1 ee11160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} Fi}


ee11160 ::~ee11160(){ note_dtor("ee11160", this);} // tgen
ee11160 ::ee11160(){ note_ctor("ee11160", this);} // tgen

static void Test_ee11160()
{
  extern Class_Descriptor cd_ee11160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee11160, buf);
    ee11160 *dp, &lv = *(dp=new (buf) ee11160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee11160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee11160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee11160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(32,16), "ee11160");
    check_base_class_offset(lv, (dd1160*), ABISELECT(16,8), "ee11160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11160.e");
    test_class_info(&lv, &cd_ee11160);
    dp->~ee11160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11160(Test_ee11160, "ee11160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee11160C1Ev();
extern void _ZN7ee11160D1Ev();
Name_Map name_map_ee11160[] = {
  NSPAIR(_ZN7ee11160C1Ev),
  NSPAIR(_ZN7ee11160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee11160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11160[];
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee11160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11160[0]),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11160[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11160[0]),
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee11160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee11160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee11160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee11160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee11160[] = {
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee11160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee11160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee11160[] = {
  {&(_ZTV7ee11160[5]),  5,18},
  {&(_ZTV7ee11160[9]),  9,18},
  {&(_ZTV7ee11160[12]),  12,18},
  {&(_ZTV7ee11160[16]),  16,18},
  {&(_tg__ZTV6dd1160__7ee11160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee11160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee11160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee11160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee11160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee11160[];
extern  VTBL_ENTRY _ZTV7ee11160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11160[];
Class_Descriptor cd_ee11160 = {  "ee11160", // class name
  bases_ee11160, 4,
  &(vtc_ee11160[0]), // expected_vtbl_contents
  &(vtt_ee11160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee11160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11160),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21160  : dd1160 {
  int e;
  virtual void  foo(); // _ZN7ee211603fooEv
  ~ee21160(); // tgen
  ee21160(); // tgen
};
//SIG(1 ee21160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee21160 ::foo(){vfunc_called(this, "_ZN7ee211603fooEv");}
ee21160 ::~ee21160(){ note_dtor("ee21160", this);} // tgen
ee21160 ::ee21160(){ note_ctor("ee21160", this);} // tgen

static void Test_ee21160()
{
  extern Class_Descriptor cd_ee21160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee21160, buf);
    ee21160 *dp, &lv = *(dp=new (buf) ee21160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee21160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee21160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee21160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(16,12), "ee21160");
    check_base_class_offset(lv, (dd1160*), 0, "ee21160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21160.e");
    test_class_info(&lv, &cd_ee21160);
    dp->~ee21160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21160(Test_ee21160, "ee21160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee21160C1Ev();
extern void _ZN7ee21160D1Ev();
Name_Map name_map_ee21160[] = {
  NSPAIR(_ZN7ee21160C1Ev),
  NSPAIR(_ZN7ee21160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee21160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21160[];
extern void _ZN7ee211603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee211603fooEv,_ZTv0_n16_N7ee211603fooEv)();
extern void ABISELECT(_ZThn32_N7ee211603fooEv,_ZThn20_N7ee211603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21160[0]),
  (VTBL_ENTRY)&_ZN7ee211603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21160[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee21160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee211603fooEv,_ZTv0_n16_N7ee211603fooEv),
};
extern VTBL_ENTRY _ZTV7ee21160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee21160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee21160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee21160[] = {
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee21160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee21160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee21160[] = {
  {&(_ZTV7ee21160[4]),  4,14},
  {&(_tg__ZTV6dd1160__7ee21160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee21160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee21160[4]),  4,6},
  {&(_ZTV7ee21160[8]),  8,14},
  {&(_ZTV7ee21160[12]),  12,14},
  {&(_tg__ZTV5cc160__7ee21160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee21160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee21160[];
extern  VTBL_ENTRY _ZTV7ee21160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21160[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee211603fooEv,_ZTv0_n16_N7ee211603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee211603fooEv,_ZThn20_N7ee211603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21160 = {  "ee21160", // class name
  bases_ee21160, 4,
  &(vtc_ee21160[0]), // expected_vtbl_contents
  &(vtt_ee21160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee21160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31160  : virtual dd1160 {
  int e;
  virtual void  foo(); // _ZN7ee311603fooEv
  ~ee31160(); // tgen
  ee31160(); // tgen
};
//SIG(1 ee31160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 Fi}


void  ee31160 ::foo(){vfunc_called(this, "_ZN7ee311603fooEv");}
ee31160 ::~ee31160(){ note_dtor("ee31160", this);} // tgen
ee31160 ::ee31160(){ note_ctor("ee31160", this);} // tgen

static void Test_ee31160()
{
  extern Class_Descriptor cd_ee31160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee31160, buf);
    ee31160 *dp, &lv = *(dp=new (buf) ee31160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee31160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee31160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee31160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(32,16), "ee31160");
    check_base_class_offset(lv, (dd1160*), ABISELECT(16,8), "ee31160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31160.e");
    test_class_info(&lv, &cd_ee31160);
    dp->~ee31160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31160(Test_ee31160, "ee31160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee31160C1Ev();
extern void _ZN7ee31160D1Ev();
Name_Map name_map_ee31160[] = {
  NSPAIR(_ZN7ee31160C1Ev),
  NSPAIR(_ZN7ee31160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee31160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31160[];
extern void _ZN7ee311603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee311603fooEv,_ZTv0_n16_N7ee311603fooEv)();
extern void ABISELECT(_ZThn48_N7ee311603fooEv,_ZThn24_N7ee311603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31160[0]),
  (VTBL_ENTRY)&_ZN7ee311603fooEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31160[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31160[0]),
  ABISELECT(-48,-24),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee31160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee311603fooEv,_ZTv0_n16_N7ee311603fooEv),
};
extern VTBL_ENTRY _ZTV7ee31160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee31160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee31160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee31160[] = {
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee31160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee31160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee31160[] = {
  {&(_ZTV7ee31160[5]),  5,19},
  {&(_ZTV7ee31160[10]),  10,19},
  {&(_ZTV7ee31160[13]),  13,19},
  {&(_ZTV7ee31160[17]),  17,19},
  {&(_tg__ZTV6dd1160__7ee31160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee31160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee31160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee31160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee31160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee31160[];
extern  VTBL_ENTRY _ZTV7ee31160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31160[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee311603fooEv,_ZTv0_n16_N7ee311603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee311603fooEv,_ZThn24_N7ee311603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31160 = {  "ee31160", // class name
  bases_ee31160, 4,
  &(vtc_ee31160[0]), // expected_vtbl_contents
  &(vtt_ee31160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee31160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31160),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41160  : dd1160 {
  int e;
  virtual void  bar(); // _ZN7ee411603barEv
  ~ee41160(); // tgen
  ee41160(); // tgen
};
//SIG(1 ee41160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee41160 ::bar(){vfunc_called(this, "_ZN7ee411603barEv");}
ee41160 ::~ee41160(){ note_dtor("ee41160", this);} // tgen
ee41160 ::ee41160(){ note_ctor("ee41160", this);} // tgen

static void Test_ee41160()
{
  extern Class_Descriptor cd_ee41160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee41160, buf);
    ee41160 *dp, &lv = *(dp=new (buf) ee41160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee41160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee41160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee41160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(16,12), "ee41160");
    check_base_class_offset(lv, (dd1160*), 0, "ee41160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41160.e");
    test_class_info(&lv, &cd_ee41160);
    dp->~ee41160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41160(Test_ee41160, "ee41160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee41160C1Ev();
extern void _ZN7ee41160D1Ev();
Name_Map name_map_ee41160[] = {
  NSPAIR(_ZN7ee41160C1Ev),
  NSPAIR(_ZN7ee41160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee41160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41160[];
extern void _ZN7ee411603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee411603barEv,_ZTv0_n12_N7ee411603barEv)();
extern void ABISELECT(_ZThn32_N7ee411603barEv,_ZThn20_N7ee411603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee41160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41160[0]),
  (VTBL_ENTRY)&_ZN7ee411603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41160[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee41160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee411603barEv,_ZTv0_n12_N7ee411603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee41160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee41160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee41160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee41160[] = {
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee41160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee41160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee41160[] = {
  {&(_ZTV7ee41160[4]),  4,14},
  {&(_tg__ZTV6dd1160__7ee41160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee41160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee41160[4]),  4,6},
  {&(_ZTV7ee41160[8]),  8,14},
  {&(_ZTV7ee41160[12]),  12,14},
  {&(_tg__ZTV5cc160__7ee41160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee41160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee41160[];
extern  VTBL_ENTRY _ZTV7ee41160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41160[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee411603barEv,_ZTv0_n12_N7ee411603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee411603barEv,_ZThn20_N7ee411603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41160 = {  "ee41160", // class name
  bases_ee41160, 4,
  &(vtc_ee41160[0]), // expected_vtbl_contents
  &(vtt_ee41160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee41160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51160  : virtual dd1160 {
  int e;
  virtual void  bar(); // _ZN7ee511603barEv
  ~ee51160(); // tgen
  ee51160(); // tgen
};
//SIG(1 ee51160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} Fi} v1 Fi}


void  ee51160 ::bar(){vfunc_called(this, "_ZN7ee511603barEv");}
ee51160 ::~ee51160(){ note_dtor("ee51160", this);} // tgen
ee51160 ::ee51160(){ note_ctor("ee51160", this);} // tgen

static void Test_ee51160()
{
  extern Class_Descriptor cd_ee51160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee51160, buf);
    ee51160 *dp, &lv = *(dp=new (buf) ee51160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee51160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee51160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee51160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(32,16), "ee51160");
    check_base_class_offset(lv, (dd1160*), ABISELECT(16,8), "ee51160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51160.e");
    test_class_info(&lv, &cd_ee51160);
    dp->~ee51160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51160(Test_ee51160, "ee51160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee51160C1Ev();
extern void _ZN7ee51160D1Ev();
Name_Map name_map_ee51160[] = {
  NSPAIR(_ZN7ee51160C1Ev),
  NSPAIR(_ZN7ee51160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee51160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51160[];
extern void _ZN7ee511603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee511603barEv,_ZTv0_n12_N7ee511603barEv)();
extern void ABISELECT(_ZThn48_N7ee511603barEv,_ZThn24_N7ee511603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee51160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51160[0]),
  (VTBL_ENTRY)&_ZN7ee511603barEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51160[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51160[0]),
  0,
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee51160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee511603barEv,_ZTv0_n12_N7ee511603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee51160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee51160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee51160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee51160[] = {
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee51160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee51160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee51160[] = {
  {&(_ZTV7ee51160[5]),  5,19},
  {&(_ZTV7ee51160[10]),  10,19},
  {&(_ZTV7ee51160[13]),  13,19},
  {&(_ZTV7ee51160[17]),  17,19},
  {&(_tg__ZTV6dd1160__7ee51160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee51160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee51160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee51160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee51160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee51160[];
extern  VTBL_ENTRY _ZTV7ee51160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51160[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee511603barEv,_ZTv0_n12_N7ee511603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee511603barEv,_ZThn24_N7ee511603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51160 = {  "ee51160", // class name
  bases_ee51160, 4,
  &(vtc_ee51160[0]), // expected_vtbl_contents
  &(vtt_ee51160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee51160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51160),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61160  : dd1160 {
  int e;
  virtual void  foo(); // _ZN7ee611603fooEv
  virtual void  bar(); // _ZN7ee611603barEv
  ~ee61160(); // tgen
  ee61160(); // tgen
};
//SIG(1 ee61160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61160 ::foo(){vfunc_called(this, "_ZN7ee611603fooEv");}
void  ee61160 ::bar(){vfunc_called(this, "_ZN7ee611603barEv");}
ee61160 ::~ee61160(){ note_dtor("ee61160", this);} // tgen
ee61160 ::ee61160(){ note_ctor("ee61160", this);} // tgen

static void Test_ee61160()
{
  extern Class_Descriptor cd_ee61160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee61160, buf);
    ee61160 *dp, &lv = *(dp=new (buf) ee61160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee61160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee61160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee61160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(16,12), "ee61160");
    check_base_class_offset(lv, (dd1160*), 0, "ee61160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61160.e");
    test_class_info(&lv, &cd_ee61160);
    dp->~ee61160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61160(Test_ee61160, "ee61160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee61160C1Ev();
extern void _ZN7ee61160D1Ev();
Name_Map name_map_ee61160[] = {
  NSPAIR(_ZN7ee61160C1Ev),
  NSPAIR(_ZN7ee61160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee61160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61160[];
extern void _ZN7ee611603fooEv();
extern void _ZN7ee611603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee611603barEv,_ZTv0_n12_N7ee611603barEv)();
extern void ABISELECT(_ZThn32_N7ee611603barEv,_ZThn20_N7ee611603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee611603fooEv,_ZTv0_n16_N7ee611603fooEv)();
extern void ABISELECT(_ZThn32_N7ee611603fooEv,_ZThn20_N7ee611603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61160[0]),
  (VTBL_ENTRY)&_ZN7ee611603fooEv,
  (VTBL_ENTRY)&_ZN7ee611603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee61160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee611603barEv,_ZTv0_n12_N7ee611603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee611603fooEv,_ZTv0_n16_N7ee611603fooEv),
};
extern VTBL_ENTRY _ZTV7ee61160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee61160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee61160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee61160[] = {
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee61160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee61160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee61160[] = {
  {&(_ZTV7ee61160[4]),  4,15},
  {&(_tg__ZTV6dd1160__7ee61160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee61160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee61160[4]),  4,6},
  {&(_ZTV7ee61160[9]),  9,15},
  {&(_ZTV7ee61160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee61160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee61160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee61160[];
extern  VTBL_ENTRY _ZTV7ee61160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61160[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee611603fooEv,_ZTv0_n16_N7ee611603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611603fooEv,_ZThn20_N7ee611603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee611603barEv,_ZTv0_n12_N7ee611603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611603barEv,_ZThn20_N7ee611603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61160 = {  "ee61160", // class name
  bases_ee61160, 4,
  &(vtc_ee61160[0]), // expected_vtbl_contents
  &(vtt_ee61160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee61160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71160  : virtual dd1160 {
  int e;
  virtual void  foo(); // _ZN7ee711603fooEv
  virtual void  bar(); // _ZN7ee711603barEv
  ~ee71160(); // tgen
  ee71160(); // tgen
};
//SIG(1 ee71160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71160 ::foo(){vfunc_called(this, "_ZN7ee711603fooEv");}
void  ee71160 ::bar(){vfunc_called(this, "_ZN7ee711603barEv");}
ee71160 ::~ee71160(){ note_dtor("ee71160", this);} // tgen
ee71160 ::ee71160(){ note_ctor("ee71160", this);} // tgen

static void Test_ee71160()
{
  extern Class_Descriptor cd_ee71160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee71160, buf);
    ee71160 *dp, &lv = *(dp=new (buf) ee71160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee71160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee71160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee71160");
    check_base_class_offset(lv, (cc160*)(dd1160*), ABISELECT(32,16), "ee71160");
    check_base_class_offset(lv, (dd1160*), ABISELECT(16,8), "ee71160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71160.e");
    test_class_info(&lv, &cd_ee71160);
    dp->~ee71160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71160(Test_ee71160, "ee71160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee71160C1Ev();
extern void _ZN7ee71160D1Ev();
Name_Map name_map_ee71160[] = {
  NSPAIR(_ZN7ee71160C1Ev),
  NSPAIR(_ZN7ee71160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd1160;
extern VTBL_ENTRY _ZTI6dd1160[];
extern  VTBL_ENTRY _ZTV6dd1160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1160[];
static Base_Class bases_ee71160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1160,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71160[];
extern void _ZN7ee711603fooEv();
extern void _ZN7ee711603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee711603barEv,_ZTv0_n12_N7ee711603barEv)();
extern void ABISELECT(_ZThn48_N7ee711603barEv,_ZThn24_N7ee711603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee711603fooEv,_ZTv0_n16_N7ee711603fooEv)();
extern void ABISELECT(_ZThn48_N7ee711603fooEv,_ZThn24_N7ee711603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71160[0]),
  (VTBL_ENTRY)&_ZN7ee711603fooEv,
  (VTBL_ENTRY)&_ZN7ee711603barEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71160[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71160[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee71160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee711603barEv,_ZTv0_n12_N7ee711603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee711603fooEv,_ZTv0_n16_N7ee711603fooEv),
};
extern VTBL_ENTRY _ZTV7ee71160[];
static  VTBL_ENTRY _tg__ZTV6dd1160__7ee71160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd1160__7ee71160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd1160__7ee71160[] = {
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee71160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee71160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee71160[] = {
  {&(_ZTV7ee71160[5]),  5,20},
  {&(_ZTV7ee71160[11]),  11,20},
  {&(_ZTV7ee71160[14]),  14,20},
  {&(_ZTV7ee71160[18]),  18,20},
  {&(_tg__ZTV6dd1160__7ee71160[4]),  4,4},
  {&(_tg__ZTV5cc160__6dd1160__7ee71160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd1160__7ee71160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee71160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee71160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee71160[];
extern  VTBL_ENTRY _ZTV7ee71160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71160[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee711603fooEv,_ZTv0_n16_N7ee711603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711603fooEv,_ZThn24_N7ee711603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee711603barEv,_ZTv0_n12_N7ee711603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711603barEv,_ZThn24_N7ee711603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71160 = {  "ee71160", // class name
  bases_ee71160, 4,
  &(vtc_ee71160[0]), // expected_vtbl_contents
  &(vtt_ee71160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee71160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71160),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2160  : cc160 {
  int d;
  virtual void  foo(); // _ZN6dd21603fooEv
  ~dd2160(); // tgen
  dd2160(); // tgen
};
//SIG(-1 dd2160) C1{ BC2{ VBC3{ BC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd2160 ::foo(){vfunc_called(this, "_ZN6dd21603fooEv");}
dd2160 ::~dd2160(){ note_dtor("dd2160", this);} // tgen
dd2160 ::dd2160(){ note_ctor("dd2160", this);} // tgen

static void Test_dd2160()
{
  extern Class_Descriptor cd_dd2160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd2160, buf);
    dd2160 *dp, &lv = *(dp=new (buf) dd2160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd2160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(24,16), "dd2160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(16,12), "dd2160");
    check_base_class_offset(lv, (cc160*), 0, "dd2160");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2160.d");
    test_class_info(&lv, &cd_dd2160);
    dp->~dd2160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2160(Test_dd2160, "dd2160", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd2160C1Ev();
extern void _ZN6dd2160D1Ev();
Name_Map name_map_dd2160[] = {
  NSPAIR(_ZN6dd2160C1Ev),
  NSPAIR(_ZN6dd2160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd2160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2160[];
extern void _ZN6dd21603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd2160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
extern VTBL_ENTRY _ZTV6dd2160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd2160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd2160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd2160[] = {
  {&(_ZTV6dd2160[3]),  3,10},
  {&(_tg__ZTV5cc160__6dd2160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd2160[4]),  4,6},
  {&(_ZTV6dd2160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd2160 = {  "dd2160", // class name
  bases_dd2160, 3,
  &(vtc_dd2160[0]), // expected_vtbl_contents
  &(vtt_dd2160[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd2160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2160),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02160  : dd2160 {
  int e;
  ~ee02160(); // tgen
  ee02160(); // tgen
};
//SIG(1 ee02160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee02160 ::~ee02160(){ note_dtor("ee02160", this);} // tgen
ee02160 ::ee02160(){ note_ctor("ee02160", this);} // tgen

static void Test_ee02160()
{
  extern Class_Descriptor cd_ee02160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee02160, buf);
    ee02160 *dp, &lv = *(dp=new (buf) ee02160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee02160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee02160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(24,16), "ee02160");
    check_base_class_offset(lv, (cc160*)(dd2160*), 0, "ee02160");
    check_base_class_offset(lv, (dd2160*), 0, "ee02160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02160.e");
    test_class_info(&lv, &cd_ee02160);
    dp->~ee02160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02160(Test_ee02160, "ee02160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee02160C1Ev();
extern void _ZN7ee02160D1Ev();
Name_Map name_map_ee02160[] = {
  NSPAIR(_ZN7ee02160C1Ev),
  NSPAIR(_ZN7ee02160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee02160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02160[];
extern void _ZN6dd21603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee02160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
  ABISELECT(-24,-16),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee02160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
extern VTBL_ENTRY _ZTV7ee02160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee02160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee02160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee02160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee02160[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee02160[] = {
  {&(_ZTV7ee02160[3]),  3,10},
  {&(_tg__ZTV6dd2160__7ee02160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee02160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee02160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee02160[4]),  4,6},
  {&(_ZTV7ee02160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee02160[];
extern  VTBL_ENTRY _ZTV7ee02160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02160[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee02160 = {  "ee02160", // class name
  bases_ee02160, 4,
  &(vtc_ee02160[0]), // expected_vtbl_contents
  &(vtt_ee02160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee02160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12160  : virtual dd2160 {
  int e;
  ~ee12160(); // tgen
  ee12160(); // tgen
};
//SIG(1 ee12160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee12160 ::~ee12160(){ note_dtor("ee12160", this);} // tgen
ee12160 ::ee12160(){ note_ctor("ee12160", this);} // tgen

static void Test_ee12160()
{
  extern Class_Descriptor cd_ee12160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee12160, buf);
    ee12160 *dp, &lv = *(dp=new (buf) ee12160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee12160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee12160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(32,20), "ee12160");
    check_base_class_offset(lv, (cc160*)(dd2160*), ABISELECT(16,8), "ee12160");
    check_base_class_offset(lv, (dd2160*), ABISELECT(16,8), "ee12160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12160.e");
    test_class_info(&lv, &cd_ee12160);
    dp->~ee12160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12160(Test_ee12160, "ee12160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee12160C1Ev();
extern void _ZN7ee12160D1Ev();
Name_Map name_map_ee12160[] = {
  NSPAIR(_ZN7ee12160C1Ev),
  NSPAIR(_ZN7ee12160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee12160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12160[];
extern void _ZN6dd21603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee12160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12160[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee12160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
extern VTBL_ENTRY _ZTV7ee12160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee12160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee12160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee12160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee12160[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee12160[] = {
  {&(_ZTV7ee12160[4]),  4,15},
  {&(_ZTV7ee12160[8]),  8,15},
  {&(_ZTV7ee12160[13]),  13,15},
  {&(_tg__ZTV6dd2160__7ee12160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee12160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee12160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee12160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee12160[];
extern  VTBL_ENTRY _ZTV7ee12160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12160[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee12160 = {  "ee12160", // class name
  bases_ee12160, 4,
  &(vtc_ee12160[0]), // expected_vtbl_contents
  &(vtt_ee12160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee12160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22160  : dd2160 {
  int e;
  virtual void  foo(); // _ZN7ee221603fooEv
  ~ee22160(); // tgen
  ee22160(); // tgen
};
//SIG(1 ee22160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22160 ::foo(){vfunc_called(this, "_ZN7ee221603fooEv");}
ee22160 ::~ee22160(){ note_dtor("ee22160", this);} // tgen
ee22160 ::ee22160(){ note_ctor("ee22160", this);} // tgen

static void Test_ee22160()
{
  extern Class_Descriptor cd_ee22160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee22160, buf);
    ee22160 *dp, &lv = *(dp=new (buf) ee22160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee22160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee22160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(24,16), "ee22160");
    check_base_class_offset(lv, (cc160*)(dd2160*), 0, "ee22160");
    check_base_class_offset(lv, (dd2160*), 0, "ee22160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22160.e");
    test_class_info(&lv, &cd_ee22160);
    dp->~ee22160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22160(Test_ee22160, "ee22160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee22160C1Ev();
extern void _ZN7ee22160D1Ev();
Name_Map name_map_ee22160[] = {
  NSPAIR(_ZN7ee22160C1Ev),
  NSPAIR(_ZN7ee22160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee22160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22160[];
extern void _ZN7ee221603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee221603fooEv,_ZTv0_n16_N7ee221603fooEv)();
extern void ABISELECT(_ZThn24_N7ee221603fooEv,_ZThn16_N7ee221603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee22160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22160[0]),
  (VTBL_ENTRY)&_ZN7ee221603fooEv,
  ABISELECT(-24,-16),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee22160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee221603fooEv,_ZTv0_n16_N7ee221603fooEv),
};
extern VTBL_ENTRY _ZTV7ee22160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee22160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee22160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee22160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee22160[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee22160[] = {
  {&(_ZTV7ee22160[3]),  3,10},
  {&(_tg__ZTV6dd2160__7ee22160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee22160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee22160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee22160[4]),  4,6},
  {&(_ZTV7ee22160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee22160[];
extern  VTBL_ENTRY _ZTV7ee22160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22160[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee221603fooEv,_ZTv0_n16_N7ee221603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee221603fooEv,_ZThn16_N7ee221603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee22160 = {  "ee22160", // class name
  bases_ee22160, 4,
  &(vtc_ee22160[0]), // expected_vtbl_contents
  &(vtt_ee22160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee22160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32160  : virtual dd2160 {
  int e;
  virtual void  foo(); // _ZN7ee321603fooEv
  ~ee32160(); // tgen
  ee32160(); // tgen
};
//SIG(1 ee32160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32160 ::foo(){vfunc_called(this, "_ZN7ee321603fooEv");}
ee32160 ::~ee32160(){ note_dtor("ee32160", this);} // tgen
ee32160 ::ee32160(){ note_ctor("ee32160", this);} // tgen

static void Test_ee32160()
{
  extern Class_Descriptor cd_ee32160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee32160, buf);
    ee32160 *dp, &lv = *(dp=new (buf) ee32160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee32160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee32160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(32,20), "ee32160");
    check_base_class_offset(lv, (cc160*)(dd2160*), ABISELECT(16,8), "ee32160");
    check_base_class_offset(lv, (dd2160*), ABISELECT(16,8), "ee32160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32160.e");
    test_class_info(&lv, &cd_ee32160);
    dp->~ee32160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32160(Test_ee32160, "ee32160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee32160C1Ev();
extern void _ZN7ee32160D1Ev();
Name_Map name_map_ee32160[] = {
  NSPAIR(_ZN7ee32160C1Ev),
  NSPAIR(_ZN7ee32160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee32160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32160[];
extern void _ZN7ee321603fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee321603fooEv,_ZTv0_n16_N7ee321603fooEv)();
extern void ABISELECT(_ZThn16_N7ee321603fooEv,_ZThn8_N7ee321603fooEv)() __attribute__((weak));
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee321603fooEv,_ZTv0_n16_N7ee321603fooEv)();
extern void ABISELECT(_ZThn32_N7ee321603fooEv,_ZThn20_N7ee321603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32160[0]),
  (VTBL_ENTRY)&_ZN7ee321603fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee321603fooEv,_ZTv0_n16_N7ee321603fooEv),
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee32160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee321603fooEv,_ZTv0_n16_N7ee321603fooEv),
};
extern VTBL_ENTRY _ZTV7ee32160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee32160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee32160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee32160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee32160[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee32160[] = {
  {&(_ZTV7ee32160[4]),  4,16},
  {&(_ZTV7ee32160[9]),  9,16},
  {&(_ZTV7ee32160[14]),  14,16},
  {&(_tg__ZTV6dd2160__7ee32160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee32160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee32160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee32160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee32160[];
extern  VTBL_ENTRY _ZTV7ee32160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32160[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee321603fooEv,_ZTv0_n16_N7ee321603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee321603fooEv,_ZThn20_N7ee321603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321603fooEv,_ZThn8_N7ee321603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32160 = {  "ee32160", // class name
  bases_ee32160, 4,
  &(vtc_ee32160[0]), // expected_vtbl_contents
  &(vtt_ee32160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee32160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32160),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42160  : dd2160 {
  int e;
  virtual void  bar(); // _ZN7ee421603barEv
  ~ee42160(); // tgen
  ee42160(); // tgen
};
//SIG(1 ee42160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42160 ::bar(){vfunc_called(this, "_ZN7ee421603barEv");}
ee42160 ::~ee42160(){ note_dtor("ee42160", this);} // tgen
ee42160 ::ee42160(){ note_ctor("ee42160", this);} // tgen

static void Test_ee42160()
{
  extern Class_Descriptor cd_ee42160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee42160, buf);
    ee42160 *dp, &lv = *(dp=new (buf) ee42160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee42160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee42160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(24,16), "ee42160");
    check_base_class_offset(lv, (cc160*)(dd2160*), 0, "ee42160");
    check_base_class_offset(lv, (dd2160*), 0, "ee42160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42160.e");
    test_class_info(&lv, &cd_ee42160);
    dp->~ee42160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42160(Test_ee42160, "ee42160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee42160C1Ev();
extern void _ZN7ee42160D1Ev();
Name_Map name_map_ee42160[] = {
  NSPAIR(_ZN7ee42160C1Ev),
  NSPAIR(_ZN7ee42160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee42160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42160[];
extern void _ZN6dd21603fooEv();
extern void _ZN7ee421603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee421603barEv,_ZTv0_n12_N7ee421603barEv)();
extern void ABISELECT(_ZThn24_N7ee421603barEv,_ZThn16_N7ee421603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee42160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
  (VTBL_ENTRY)&_ZN7ee421603barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee42160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee421603barEv,_ZTv0_n12_N7ee421603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
extern VTBL_ENTRY _ZTV7ee42160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee42160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee42160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee42160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee42160[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee42160[] = {
  {&(_ZTV7ee42160[3]),  3,11},
  {&(_tg__ZTV6dd2160__7ee42160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee42160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee42160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee42160[4]),  4,6},
  {&(_ZTV7ee42160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee42160[];
extern  VTBL_ENTRY _ZTV7ee42160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42160[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee421603barEv,_ZTv0_n12_N7ee421603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee421603barEv,_ZThn16_N7ee421603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee42160 = {  "ee42160", // class name
  bases_ee42160, 4,
  &(vtc_ee42160[0]), // expected_vtbl_contents
  &(vtt_ee42160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee42160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52160  : virtual dd2160 {
  int e;
  virtual void  bar(); // _ZN7ee521603barEv
  ~ee52160(); // tgen
  ee52160(); // tgen
};
//SIG(1 ee52160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52160 ::bar(){vfunc_called(this, "_ZN7ee521603barEv");}
ee52160 ::~ee52160(){ note_dtor("ee52160", this);} // tgen
ee52160 ::ee52160(){ note_ctor("ee52160", this);} // tgen

static void Test_ee52160()
{
  extern Class_Descriptor cd_ee52160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee52160, buf);
    ee52160 *dp, &lv = *(dp=new (buf) ee52160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee52160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee52160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(32,20), "ee52160");
    check_base_class_offset(lv, (cc160*)(dd2160*), ABISELECT(16,8), "ee52160");
    check_base_class_offset(lv, (dd2160*), ABISELECT(16,8), "ee52160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52160.e");
    test_class_info(&lv, &cd_ee52160);
    dp->~ee52160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52160(Test_ee52160, "ee52160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee52160C1Ev();
extern void _ZN7ee52160D1Ev();
Name_Map name_map_ee52160[] = {
  NSPAIR(_ZN7ee52160C1Ev),
  NSPAIR(_ZN7ee52160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee52160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52160[];
extern void _ZN7ee521603barEv();
extern void _ZN6dd21603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee521603barEv,_ZTv0_n12_N7ee521603barEv)();
extern void ABISELECT(_ZThn32_N7ee521603barEv,_ZThn20_N7ee521603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee52160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52160[0]),
  (VTBL_ENTRY)&_ZN7ee521603barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee52160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee521603barEv,_ZTv0_n12_N7ee521603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
extern VTBL_ENTRY _ZTV7ee52160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee52160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee52160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee52160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee52160[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee52160[] = {
  {&(_ZTV7ee52160[4]),  4,16},
  {&(_ZTV7ee52160[9]),  9,16},
  {&(_ZTV7ee52160[14]),  14,16},
  {&(_tg__ZTV6dd2160__7ee52160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee52160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee52160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee52160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee52160[];
extern  VTBL_ENTRY _ZTV7ee52160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52160[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee521603barEv,_ZTv0_n12_N7ee521603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee521603barEv,_ZThn20_N7ee521603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52160 = {  "ee52160", // class name
  bases_ee52160, 4,
  &(vtc_ee52160[0]), // expected_vtbl_contents
  &(vtt_ee52160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee52160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52160),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62160  : dd2160 {
  int e;
  virtual void  foo(); // _ZN7ee621603fooEv
  virtual void  bar(); // _ZN7ee621603barEv
  ~ee62160(); // tgen
  ee62160(); // tgen
};
//SIG(1 ee62160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62160 ::foo(){vfunc_called(this, "_ZN7ee621603fooEv");}
void  ee62160 ::bar(){vfunc_called(this, "_ZN7ee621603barEv");}
ee62160 ::~ee62160(){ note_dtor("ee62160", this);} // tgen
ee62160 ::ee62160(){ note_ctor("ee62160", this);} // tgen

static void Test_ee62160()
{
  extern Class_Descriptor cd_ee62160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee62160, buf);
    ee62160 *dp, &lv = *(dp=new (buf) ee62160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee62160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee62160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(24,16), "ee62160");
    check_base_class_offset(lv, (cc160*)(dd2160*), 0, "ee62160");
    check_base_class_offset(lv, (dd2160*), 0, "ee62160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62160.e");
    test_class_info(&lv, &cd_ee62160);
    dp->~ee62160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62160(Test_ee62160, "ee62160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee62160C1Ev();
extern void _ZN7ee62160D1Ev();
Name_Map name_map_ee62160[] = {
  NSPAIR(_ZN7ee62160C1Ev),
  NSPAIR(_ZN7ee62160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee62160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62160[];
extern void _ZN7ee621603fooEv();
extern void _ZN7ee621603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee621603barEv,_ZTv0_n12_N7ee621603barEv)();
extern void ABISELECT(_ZThn24_N7ee621603barEv,_ZThn16_N7ee621603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee621603fooEv,_ZTv0_n16_N7ee621603fooEv)();
extern void ABISELECT(_ZThn24_N7ee621603fooEv,_ZThn16_N7ee621603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee62160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62160[0]),
  (VTBL_ENTRY)&_ZN7ee621603fooEv,
  (VTBL_ENTRY)&_ZN7ee621603barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee62160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee621603barEv,_ZTv0_n12_N7ee621603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee621603fooEv,_ZTv0_n16_N7ee621603fooEv),
};
extern VTBL_ENTRY _ZTV7ee62160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee62160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee62160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee62160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee62160[] = {
  ABISELECT(-24,-16),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee62160[] = {
  {&(_ZTV7ee62160[3]),  3,11},
  {&(_tg__ZTV6dd2160__7ee62160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee62160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee62160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee62160[4]),  4,6},
  {&(_ZTV7ee62160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee62160[];
extern  VTBL_ENTRY _ZTV7ee62160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62160[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21603fooEv,_ZThn16_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee621603fooEv,_ZTv0_n16_N7ee621603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621603fooEv,_ZThn16_N7ee621603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee621603barEv,_ZTv0_n12_N7ee621603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621603barEv,_ZThn16_N7ee621603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee62160 = {  "ee62160", // class name
  bases_ee62160, 4,
  &(vtc_ee62160[0]), // expected_vtbl_contents
  &(vtt_ee62160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee62160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72160  : virtual dd2160 {
  int e;
  virtual void  foo(); // _ZN7ee721603fooEv
  virtual void  bar(); // _ZN7ee721603barEv
  ~ee72160(); // tgen
  ee72160(); // tgen
};
//SIG(1 ee72160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72160 ::foo(){vfunc_called(this, "_ZN7ee721603fooEv");}
void  ee72160 ::bar(){vfunc_called(this, "_ZN7ee721603barEv");}
ee72160 ::~ee72160(){ note_dtor("ee72160", this);} // tgen
ee72160 ::ee72160(){ note_ctor("ee72160", this);} // tgen

static void Test_ee72160()
{
  extern Class_Descriptor cd_ee72160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee72160, buf);
    ee72160 *dp, &lv = *(dp=new (buf) ee72160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee72160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee72160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd2160*), ABISELECT(32,20), "ee72160");
    check_base_class_offset(lv, (cc160*)(dd2160*), ABISELECT(16,8), "ee72160");
    check_base_class_offset(lv, (dd2160*), ABISELECT(16,8), "ee72160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72160.e");
    test_class_info(&lv, &cd_ee72160);
    dp->~ee72160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72160(Test_ee72160, "ee72160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee72160C1Ev();
extern void _ZN7ee72160D1Ev();
Name_Map name_map_ee72160[] = {
  NSPAIR(_ZN7ee72160C1Ev),
  NSPAIR(_ZN7ee72160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd2160;
extern VTBL_ENTRY _ZTI6dd2160[];
extern  VTBL_ENTRY _ZTV6dd2160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2160[];
static Base_Class bases_ee72160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72160[];
extern void _ZN7ee721603fooEv();
extern void _ZN7ee721603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee721603fooEv,_ZTv0_n16_N7ee721603fooEv)();
extern void ABISELECT(_ZThn16_N7ee721603fooEv,_ZThn8_N7ee721603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee721603barEv,_ZTv0_n12_N7ee721603barEv)();
extern void ABISELECT(_ZThn32_N7ee721603barEv,_ZThn20_N7ee721603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee721603fooEv,_ZTv0_n16_N7ee721603fooEv)();
extern void ABISELECT(_ZThn32_N7ee721603fooEv,_ZThn20_N7ee721603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72160[0]),
  (VTBL_ENTRY)&_ZN7ee721603fooEv,
  (VTBL_ENTRY)&_ZN7ee721603barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721603fooEv,_ZTv0_n16_N7ee721603fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee72160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee721603barEv,_ZTv0_n12_N7ee721603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721603fooEv,_ZTv0_n16_N7ee721603fooEv),
};
extern VTBL_ENTRY _ZTV7ee72160[];
extern void _ZN6dd21603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2160__7ee72160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN6dd21603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd2160__7ee72160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd2160__7ee72160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv)();
extern void ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd2160__7ee72160[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv),
};
static  VTT_ENTRY vtt_ee72160[] = {
  {&(_ZTV7ee72160[4]),  4,17},
  {&(_ZTV7ee72160[10]),  10,17},
  {&(_ZTV7ee72160[15]),  15,17},
  {&(_tg__ZTV6dd2160__7ee72160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd2160__7ee72160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd2160__7ee72160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd2160__7ee72160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee72160[];
extern  VTBL_ENTRY _ZTV7ee72160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72160[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21603fooEv,_ZTv0_n16_N6dd21603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21603fooEv,_ZThn12_N6dd21603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee721603barEv,_ZTv0_n12_N7ee721603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721603barEv,_ZThn20_N7ee721603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee721603fooEv,_ZTv0_n16_N7ee721603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721603fooEv,_ZThn20_N7ee721603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721603fooEv,_ZThn8_N7ee721603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72160 = {  "ee72160", // class name
  bases_ee72160, 4,
  &(vtc_ee72160[0]), // expected_vtbl_contents
  &(vtt_ee72160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee72160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72160),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3160  : virtual cc160 {
  int d;
  virtual void  foo(); // _ZN6dd31603fooEv
  ~dd3160(); // tgen
  dd3160(); // tgen
};
//SIG(-1 dd3160) C1{ VBC2{ VBC3{ BC4{ Fi} v2 v1 Fi} Fi} v1 Fi}


void  dd3160 ::foo(){vfunc_called(this, "_ZN6dd31603fooEv");}
dd3160 ::~dd3160(){ note_dtor("dd3160", this);} // tgen
dd3160 ::dd3160(){ note_ctor("dd3160", this);} // tgen

static void Test_dd3160()
{
  extern Class_Descriptor cd_dd3160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd3160, buf);
    dd3160 *dp, &lv = *(dp=new (buf) dd3160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd3160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,20), "dd3160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,16), "dd3160");
    check_base_class_offset(lv, (cc160*), ABISELECT(16,8), "dd3160");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3160.d");
    test_class_info(&lv, &cd_dd3160);
    dp->~dd3160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3160(Test_dd3160, "dd3160", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd3160C1Ev();
extern void _ZN6dd3160D1Ev();
Name_Map name_map_dd3160[] = {
  NSPAIR(_ZN6dd3160C1Ev),
  NSPAIR(_ZN6dd3160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd3160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3160[];
extern void _ZN6dd31603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
extern VTBL_ENTRY _ZTV6dd3160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd3160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd3160[] = {
  {&(_ZTV6dd3160[4]),  4,14},
  {&(_ZTV6dd3160[8]),  8,14},
  {&(_ZTV6dd3160[12]),  12,14},
  {&(_tg__ZTV5cc160__6dd3160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd3160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3160 = {  "dd3160", // class name
  bases_dd3160, 3,
  &(vtc_dd3160[0]), // expected_vtbl_contents
  &(vtt_dd3160[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd3160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3160),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03160  : dd3160 {
  int e;
  ~ee03160(); // tgen
  ee03160(); // tgen
};
//SIG(1 ee03160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee03160 ::~ee03160(){ note_dtor("ee03160", this);} // tgen
ee03160 ::ee03160(){ note_ctor("ee03160", this);} // tgen

static void Test_ee03160()
{
  extern Class_Descriptor cd_ee03160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee03160, buf);
    ee03160 *dp, &lv = *(dp=new (buf) ee03160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee03160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee03160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee03160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(16,12), "ee03160");
    check_base_class_offset(lv, (dd3160*), 0, "ee03160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03160.e");
    test_class_info(&lv, &cd_ee03160);
    dp->~ee03160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03160(Test_ee03160, "ee03160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee03160C1Ev();
extern void _ZN7ee03160D1Ev();
Name_Map name_map_ee03160[] = {
  NSPAIR(_ZN7ee03160C1Ev),
  NSPAIR(_ZN7ee03160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee03160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03160[];
extern void _ZN6dd31603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03160[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee03160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
extern VTBL_ENTRY _ZTV7ee03160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee03160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee03160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee03160[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee03160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee03160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee03160[] = {
  {&(_ZTV7ee03160[4]),  4,14},
  {&(_tg__ZTV6dd3160__7ee03160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee03160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee03160[4]),  4,6},
  {&(_ZTV7ee03160[8]),  8,14},
  {&(_ZTV7ee03160[12]),  12,14},
  {&(_tg__ZTV5cc160__7ee03160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee03160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee03160[];
extern  VTBL_ENTRY _ZTV7ee03160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03160[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03160 = {  "ee03160", // class name
  bases_ee03160, 4,
  &(vtc_ee03160[0]), // expected_vtbl_contents
  &(vtt_ee03160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee03160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13160  : virtual dd3160 {
  int e;
  ~ee13160(); // tgen
  ee13160(); // tgen
};
//SIG(1 ee13160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} Fi}


ee13160 ::~ee13160(){ note_dtor("ee13160", this);} // tgen
ee13160 ::ee13160(){ note_ctor("ee13160", this);} // tgen

static void Test_ee13160()
{
  extern Class_Descriptor cd_ee13160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee13160, buf);
    ee13160 *dp, &lv = *(dp=new (buf) ee13160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee13160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee13160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee13160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(32,16), "ee13160");
    check_base_class_offset(lv, (dd3160*), ABISELECT(16,8), "ee13160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13160.e");
    test_class_info(&lv, &cd_ee13160);
    dp->~ee13160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13160(Test_ee13160, "ee13160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee13160C1Ev();
extern void _ZN7ee13160D1Ev();
Name_Map name_map_ee13160[] = {
  NSPAIR(_ZN7ee13160C1Ev),
  NSPAIR(_ZN7ee13160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee13160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13160[];
extern void _ZN6dd31603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13160[0]),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13160[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee13160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
extern VTBL_ENTRY _ZTV7ee13160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee13160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee13160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee13160[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee13160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee13160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee13160[] = {
  {&(_ZTV7ee13160[5]),  5,20},
  {&(_ZTV7ee13160[10]),  10,20},
  {&(_ZTV7ee13160[14]),  14,20},
  {&(_ZTV7ee13160[18]),  18,20},
  {&(_tg__ZTV6dd3160__7ee13160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee13160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee13160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee13160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee13160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee13160[];
extern  VTBL_ENTRY _ZTV7ee13160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13160[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13160 = {  "ee13160", // class name
  bases_ee13160, 4,
  &(vtc_ee13160[0]), // expected_vtbl_contents
  &(vtt_ee13160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee13160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13160),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23160  : dd3160 {
  int e;
  virtual void  foo(); // _ZN7ee231603fooEv
  ~ee23160(); // tgen
  ee23160(); // tgen
};
//SIG(1 ee23160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23160 ::foo(){vfunc_called(this, "_ZN7ee231603fooEv");}
ee23160 ::~ee23160(){ note_dtor("ee23160", this);} // tgen
ee23160 ::ee23160(){ note_ctor("ee23160", this);} // tgen

static void Test_ee23160()
{
  extern Class_Descriptor cd_ee23160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee23160, buf);
    ee23160 *dp, &lv = *(dp=new (buf) ee23160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee23160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee23160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee23160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(16,12), "ee23160");
    check_base_class_offset(lv, (dd3160*), 0, "ee23160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23160.e");
    test_class_info(&lv, &cd_ee23160);
    dp->~ee23160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23160(Test_ee23160, "ee23160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee23160C1Ev();
extern void _ZN7ee23160D1Ev();
Name_Map name_map_ee23160[] = {
  NSPAIR(_ZN7ee23160C1Ev),
  NSPAIR(_ZN7ee23160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee23160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23160[];
extern void _ZN7ee231603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee231603fooEv,_ZTv0_n16_N7ee231603fooEv)();
extern void ABISELECT(_ZThn32_N7ee231603fooEv,_ZThn20_N7ee231603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23160[0]),
  (VTBL_ENTRY)&_ZN7ee231603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23160[0]),
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee23160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee231603fooEv,_ZTv0_n16_N7ee231603fooEv),
};
extern VTBL_ENTRY _ZTV7ee23160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee23160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee23160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee23160[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee23160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee23160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee23160[] = {
  {&(_ZTV7ee23160[4]),  4,14},
  {&(_tg__ZTV6dd3160__7ee23160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee23160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee23160[4]),  4,6},
  {&(_ZTV7ee23160[8]),  8,14},
  {&(_ZTV7ee23160[12]),  12,14},
  {&(_tg__ZTV5cc160__7ee23160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee23160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee23160[];
extern  VTBL_ENTRY _ZTV7ee23160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23160[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee231603fooEv,_ZTv0_n16_N7ee231603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee231603fooEv,_ZThn20_N7ee231603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23160 = {  "ee23160", // class name
  bases_ee23160, 4,
  &(vtc_ee23160[0]), // expected_vtbl_contents
  &(vtt_ee23160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee23160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33160  : virtual dd3160 {
  int e;
  virtual void  foo(); // _ZN7ee331603fooEv
  ~ee33160(); // tgen
  ee33160(); // tgen
};
//SIG(1 ee33160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33160 ::foo(){vfunc_called(this, "_ZN7ee331603fooEv");}
ee33160 ::~ee33160(){ note_dtor("ee33160", this);} // tgen
ee33160 ::ee33160(){ note_ctor("ee33160", this);} // tgen

static void Test_ee33160()
{
  extern Class_Descriptor cd_ee33160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee33160, buf);
    ee33160 *dp, &lv = *(dp=new (buf) ee33160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee33160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee33160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee33160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(32,16), "ee33160");
    check_base_class_offset(lv, (dd3160*), ABISELECT(16,8), "ee33160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33160.e");
    test_class_info(&lv, &cd_ee33160);
    dp->~ee33160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33160(Test_ee33160, "ee33160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee33160C1Ev();
extern void _ZN7ee33160D1Ev();
Name_Map name_map_ee33160[] = {
  NSPAIR(_ZN7ee33160C1Ev),
  NSPAIR(_ZN7ee33160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee33160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33160[];
extern void _ZN7ee331603fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee331603fooEv,_ZTv0_n20_N7ee331603fooEv)();
extern void ABISELECT(_ZThn16_N7ee331603fooEv,_ZThn8_N7ee331603fooEv)() __attribute__((weak));
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee331603fooEv,_ZTv0_n16_N7ee331603fooEv)();
extern void ABISELECT(_ZThn48_N7ee331603fooEv,_ZThn24_N7ee331603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33160[0]),
  (VTBL_ENTRY)&_ZN7ee331603fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee331603fooEv,_ZTv0_n20_N7ee331603fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33160[0]),
  ABISELECT(-48,-24),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee33160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee331603fooEv,_ZTv0_n16_N7ee331603fooEv),
};
extern VTBL_ENTRY _ZTV7ee33160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee33160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee33160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee33160[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee33160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee33160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee33160[] = {
  {&(_ZTV7ee33160[5]),  5,21},
  {&(_ZTV7ee33160[11]),  11,21},
  {&(_ZTV7ee33160[15]),  15,21},
  {&(_ZTV7ee33160[19]),  19,21},
  {&(_tg__ZTV6dd3160__7ee33160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee33160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee33160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee33160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee33160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee33160[];
extern  VTBL_ENTRY _ZTV7ee33160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33160[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee331603fooEv,_ZTv0_n16_N7ee331603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee331603fooEv,_ZThn24_N7ee331603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee331603fooEv,_ZTv0_n20_N7ee331603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331603fooEv,_ZThn8_N7ee331603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33160 = {  "ee33160", // class name
  bases_ee33160, 4,
  &(vtc_ee33160[0]), // expected_vtbl_contents
  &(vtt_ee33160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee33160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33160),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43160  : dd3160 {
  int e;
  virtual void  bar(); // _ZN7ee431603barEv
  ~ee43160(); // tgen
  ee43160(); // tgen
};
//SIG(1 ee43160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43160 ::bar(){vfunc_called(this, "_ZN7ee431603barEv");}
ee43160 ::~ee43160(){ note_dtor("ee43160", this);} // tgen
ee43160 ::ee43160(){ note_ctor("ee43160", this);} // tgen

static void Test_ee43160()
{
  extern Class_Descriptor cd_ee43160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee43160, buf);
    ee43160 *dp, &lv = *(dp=new (buf) ee43160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee43160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee43160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee43160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(16,12), "ee43160");
    check_base_class_offset(lv, (dd3160*), 0, "ee43160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43160.e");
    test_class_info(&lv, &cd_ee43160);
    dp->~ee43160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43160(Test_ee43160, "ee43160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee43160C1Ev();
extern void _ZN7ee43160D1Ev();
Name_Map name_map_ee43160[] = {
  NSPAIR(_ZN7ee43160C1Ev),
  NSPAIR(_ZN7ee43160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee43160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43160[];
extern void _ZN6dd31603fooEv();
extern void _ZN7ee431603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee431603barEv,_ZTv0_n12_N7ee431603barEv)();
extern void ABISELECT(_ZThn32_N7ee431603barEv,_ZThn20_N7ee431603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
  (VTBL_ENTRY)&_ZN7ee431603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee43160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee431603barEv,_ZTv0_n12_N7ee431603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
extern VTBL_ENTRY _ZTV7ee43160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee43160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee43160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee43160[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee43160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee43160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee43160[] = {
  {&(_ZTV7ee43160[4]),  4,15},
  {&(_tg__ZTV6dd3160__7ee43160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee43160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee43160[4]),  4,6},
  {&(_ZTV7ee43160[9]),  9,15},
  {&(_ZTV7ee43160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee43160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee43160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee43160[];
extern  VTBL_ENTRY _ZTV7ee43160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43160[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee431603barEv,_ZTv0_n12_N7ee431603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee431603barEv,_ZThn20_N7ee431603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43160 = {  "ee43160", // class name
  bases_ee43160, 4,
  &(vtc_ee43160[0]), // expected_vtbl_contents
  &(vtt_ee43160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee43160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53160  : virtual dd3160 {
  int e;
  virtual void  bar(); // _ZN7ee531603barEv
  ~ee53160(); // tgen
  ee53160(); // tgen
};
//SIG(1 ee53160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53160 ::bar(){vfunc_called(this, "_ZN7ee531603barEv");}
ee53160 ::~ee53160(){ note_dtor("ee53160", this);} // tgen
ee53160 ::ee53160(){ note_ctor("ee53160", this);} // tgen

static void Test_ee53160()
{
  extern Class_Descriptor cd_ee53160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee53160, buf);
    ee53160 *dp, &lv = *(dp=new (buf) ee53160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee53160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee53160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee53160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(32,16), "ee53160");
    check_base_class_offset(lv, (dd3160*), ABISELECT(16,8), "ee53160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53160.e");
    test_class_info(&lv, &cd_ee53160);
    dp->~ee53160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53160(Test_ee53160, "ee53160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee53160C1Ev();
extern void _ZN7ee53160D1Ev();
Name_Map name_map_ee53160[] = {
  NSPAIR(_ZN7ee53160C1Ev),
  NSPAIR(_ZN7ee53160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee53160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53160[];
extern void _ZN7ee531603barEv();
extern void _ZN6dd31603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee531603barEv,_ZTv0_n12_N7ee531603barEv)();
extern void ABISELECT(_ZThn48_N7ee531603barEv,_ZThn24_N7ee531603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53160[0]),
  (VTBL_ENTRY)&_ZN7ee531603barEv,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53160[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee53160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee531603barEv,_ZTv0_n12_N7ee531603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
extern VTBL_ENTRY _ZTV7ee53160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee53160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee53160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee53160[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee53160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee53160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee53160[] = {
  {&(_ZTV7ee53160[5]),  5,21},
  {&(_ZTV7ee53160[11]),  11,21},
  {&(_ZTV7ee53160[15]),  15,21},
  {&(_ZTV7ee53160[19]),  19,21},
  {&(_tg__ZTV6dd3160__7ee53160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee53160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee53160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee53160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee53160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee53160[];
extern  VTBL_ENTRY _ZTV7ee53160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53160[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee531603barEv,_ZTv0_n12_N7ee531603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee531603barEv,_ZThn24_N7ee531603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53160 = {  "ee53160", // class name
  bases_ee53160, 4,
  &(vtc_ee53160[0]), // expected_vtbl_contents
  &(vtt_ee53160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee53160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53160),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63160  : dd3160 {
  int e;
  virtual void  foo(); // _ZN7ee631603fooEv
  virtual void  bar(); // _ZN7ee631603barEv
  ~ee63160(); // tgen
  ee63160(); // tgen
};
//SIG(1 ee63160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63160 ::foo(){vfunc_called(this, "_ZN7ee631603fooEv");}
void  ee63160 ::bar(){vfunc_called(this, "_ZN7ee631603barEv");}
ee63160 ::~ee63160(){ note_dtor("ee63160", this);} // tgen
ee63160 ::ee63160(){ note_ctor("ee63160", this);} // tgen

static void Test_ee63160()
{
  extern Class_Descriptor cd_ee63160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee63160, buf);
    ee63160 *dp, &lv = *(dp=new (buf) ee63160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee63160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee63160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee63160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(16,12), "ee63160");
    check_base_class_offset(lv, (dd3160*), 0, "ee63160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63160.e");
    test_class_info(&lv, &cd_ee63160);
    dp->~ee63160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63160(Test_ee63160, "ee63160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee63160C1Ev();
extern void _ZN7ee63160D1Ev();
Name_Map name_map_ee63160[] = {
  NSPAIR(_ZN7ee63160C1Ev),
  NSPAIR(_ZN7ee63160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee63160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63160[];
extern void _ZN7ee631603fooEv();
extern void _ZN7ee631603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee631603barEv,_ZTv0_n12_N7ee631603barEv)();
extern void ABISELECT(_ZThn32_N7ee631603barEv,_ZThn20_N7ee631603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee631603fooEv,_ZTv0_n16_N7ee631603fooEv)();
extern void ABISELECT(_ZThn32_N7ee631603fooEv,_ZThn20_N7ee631603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63160[0]),
  (VTBL_ENTRY)&_ZN7ee631603fooEv,
  (VTBL_ENTRY)&_ZN7ee631603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee63160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee631603barEv,_ZTv0_n12_N7ee631603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee631603fooEv,_ZTv0_n16_N7ee631603fooEv),
};
extern VTBL_ENTRY _ZTV7ee63160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee63160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee63160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee63160[] = {
  ABISELECT(-32,-20),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee63160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee63160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee63160[] = {
  {&(_ZTV7ee63160[4]),  4,15},
  {&(_tg__ZTV6dd3160__7ee63160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee63160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee63160[4]),  4,6},
  {&(_ZTV7ee63160[9]),  9,15},
  {&(_ZTV7ee63160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee63160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee63160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee63160[];
extern  VTBL_ENTRY _ZTV7ee63160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63160[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn20_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee631603fooEv,_ZTv0_n16_N7ee631603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631603fooEv,_ZThn20_N7ee631603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee631603barEv,_ZTv0_n12_N7ee631603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631603barEv,_ZThn20_N7ee631603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63160 = {  "ee63160", // class name
  bases_ee63160, 4,
  &(vtc_ee63160[0]), // expected_vtbl_contents
  &(vtt_ee63160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee63160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73160  : virtual dd3160 {
  int e;
  virtual void  foo(); // _ZN7ee731603fooEv
  virtual void  bar(); // _ZN7ee731603barEv
  ~ee73160(); // tgen
  ee73160(); // tgen
};
//SIG(1 ee73160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73160 ::foo(){vfunc_called(this, "_ZN7ee731603fooEv");}
void  ee73160 ::bar(){vfunc_called(this, "_ZN7ee731603barEv");}
ee73160 ::~ee73160(){ note_dtor("ee73160", this);} // tgen
ee73160 ::ee73160(){ note_ctor("ee73160", this);} // tgen

static void Test_ee73160()
{
  extern Class_Descriptor cd_ee73160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee73160, buf);
    ee73160 *dp, &lv = *(dp=new (buf) ee73160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee73160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee73160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee73160");
    check_base_class_offset(lv, (cc160*)(dd3160*), ABISELECT(32,16), "ee73160");
    check_base_class_offset(lv, (dd3160*), ABISELECT(16,8), "ee73160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73160.e");
    test_class_info(&lv, &cd_ee73160);
    dp->~ee73160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73160(Test_ee73160, "ee73160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee73160C1Ev();
extern void _ZN7ee73160D1Ev();
Name_Map name_map_ee73160[] = {
  NSPAIR(_ZN7ee73160C1Ev),
  NSPAIR(_ZN7ee73160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd3160;
extern VTBL_ENTRY _ZTI6dd3160[];
extern  VTBL_ENTRY _ZTV6dd3160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3160[];
static Base_Class bases_ee73160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3160,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73160[];
extern void _ZN7ee731603fooEv();
extern void _ZN7ee731603barEv();
extern void ABISELECT(_ZTv0_n40_N7ee731603fooEv,_ZTv0_n20_N7ee731603fooEv)();
extern void ABISELECT(_ZThn16_N7ee731603fooEv,_ZThn8_N7ee731603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee731603barEv,_ZTv0_n12_N7ee731603barEv)();
extern void ABISELECT(_ZThn48_N7ee731603barEv,_ZThn24_N7ee731603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee731603fooEv,_ZTv0_n16_N7ee731603fooEv)();
extern void ABISELECT(_ZThn48_N7ee731603fooEv,_ZThn24_N7ee731603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73160[0]),
  (VTBL_ENTRY)&_ZN7ee731603fooEv,
  (VTBL_ENTRY)&_ZN7ee731603barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee731603fooEv,_ZTv0_n20_N7ee731603fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73160[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee73160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee731603barEv,_ZTv0_n12_N7ee731603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee731603fooEv,_ZTv0_n16_N7ee731603fooEv),
};
extern VTBL_ENTRY _ZTV7ee73160[];
extern void _ZN6dd31603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3160__7ee73160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN6dd31603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd3160__7ee73160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
};
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv)();
extern void ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd3160__7ee73160[] = {
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee73160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee73160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee73160[] = {
  {&(_ZTV7ee73160[5]),  5,22},
  {&(_ZTV7ee73160[12]),  12,22},
  {&(_ZTV7ee73160[16]),  16,22},
  {&(_ZTV7ee73160[20]),  20,22},
  {&(_tg__ZTV6dd3160__7ee73160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd3160__7ee73160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd3160__7ee73160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee73160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee73160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee73160[];
extern  VTBL_ENTRY _ZTV7ee73160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73160[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31603fooEv,_ZTv0_n16_N6dd31603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31603fooEv,_ZThn16_N6dd31603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee731603fooEv,_ZTv0_n16_N7ee731603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731603fooEv,_ZThn24_N7ee731603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee731603barEv,_ZTv0_n12_N7ee731603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731603barEv,_ZThn24_N7ee731603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee731603fooEv,_ZTv0_n20_N7ee731603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731603fooEv,_ZThn8_N7ee731603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73160 = {  "ee73160", // class name
  bases_ee73160, 4,
  &(vtc_ee73160[0]), // expected_vtbl_contents
  &(vtt_ee73160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee73160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73160),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4160  : cc160 {
  int d;
  virtual void  bar(); // _ZN6dd41603barEv
  ~dd4160(); // tgen
  dd4160(); // tgen
};
//SIG(-1 dd4160) C1{ BC2{ VBC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd4160 ::bar(){vfunc_called(this, "_ZN6dd41603barEv");}
dd4160 ::~dd4160(){ note_dtor("dd4160", this);} // tgen
dd4160 ::dd4160(){ note_ctor("dd4160", this);} // tgen

static void Test_dd4160()
{
  extern Class_Descriptor cd_dd4160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd4160, buf);
    dd4160 *dp, &lv = *(dp=new (buf) dd4160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd4160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(24,16), "dd4160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(16,12), "dd4160");
    check_base_class_offset(lv, (cc160*), 0, "dd4160");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4160.d");
    test_class_info(&lv, &cd_dd4160);
    dp->~dd4160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4160(Test_dd4160, "dd4160", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd4160C1Ev();
extern void _ZN6dd4160D1Ev();
Name_Map name_map_dd4160[] = {
  NSPAIR(_ZN6dd4160C1Ev),
  NSPAIR(_ZN6dd4160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd4160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4160[];
extern void _ZN6dd41603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd4160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV6dd4160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd4160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd4160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd4160[] = {
  {&(_ZTV6dd4160[3]),  3,10},
  {&(_tg__ZTV5cc160__6dd4160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd4160[4]),  4,6},
  {&(_ZTV6dd4160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd4160 = {  "dd4160", // class name
  bases_dd4160, 3,
  &(vtc_dd4160[0]), // expected_vtbl_contents
  &(vtt_dd4160[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd4160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4160),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04160  : dd4160 {
  int e;
  ~ee04160(); // tgen
  ee04160(); // tgen
};
//SIG(1 ee04160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee04160 ::~ee04160(){ note_dtor("ee04160", this);} // tgen
ee04160 ::ee04160(){ note_ctor("ee04160", this);} // tgen

static void Test_ee04160()
{
  extern Class_Descriptor cd_ee04160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee04160, buf);
    ee04160 *dp, &lv = *(dp=new (buf) ee04160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee04160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee04160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(24,16), "ee04160");
    check_base_class_offset(lv, (cc160*)(dd4160*), 0, "ee04160");
    check_base_class_offset(lv, (dd4160*), 0, "ee04160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04160.e");
    test_class_info(&lv, &cd_ee04160);
    dp->~ee04160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04160(Test_ee04160, "ee04160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee04160C1Ev();
extern void _ZN7ee04160D1Ev();
Name_Map name_map_ee04160[] = {
  NSPAIR(_ZN7ee04160C1Ev),
  NSPAIR(_ZN7ee04160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee04160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04160[];
extern void _ZN6dd41603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee04160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee04160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee04160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee04160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee04160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee04160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee04160[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee04160[] = {
  {&(_ZTV7ee04160[3]),  3,10},
  {&(_tg__ZTV6dd4160__7ee04160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee04160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee04160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee04160[4]),  4,6},
  {&(_ZTV7ee04160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee04160[];
extern  VTBL_ENTRY _ZTV7ee04160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04160[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee04160 = {  "ee04160", // class name
  bases_ee04160, 4,
  &(vtc_ee04160[0]), // expected_vtbl_contents
  &(vtt_ee04160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee04160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14160  : virtual dd4160 {
  int e;
  ~ee14160(); // tgen
  ee14160(); // tgen
};
//SIG(1 ee14160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee14160 ::~ee14160(){ note_dtor("ee14160", this);} // tgen
ee14160 ::ee14160(){ note_ctor("ee14160", this);} // tgen

static void Test_ee14160()
{
  extern Class_Descriptor cd_ee14160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee14160, buf);
    ee14160 *dp, &lv = *(dp=new (buf) ee14160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee14160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee14160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(32,20), "ee14160");
    check_base_class_offset(lv, (cc160*)(dd4160*), ABISELECT(16,8), "ee14160");
    check_base_class_offset(lv, (dd4160*), ABISELECT(16,8), "ee14160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14160.e");
    test_class_info(&lv, &cd_ee14160);
    dp->~ee14160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14160(Test_ee14160, "ee14160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee14160C1Ev();
extern void _ZN7ee14160D1Ev();
Name_Map name_map_ee14160[] = {
  NSPAIR(_ZN7ee14160C1Ev),
  NSPAIR(_ZN7ee14160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee14160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14160[];
extern void _ZN6dd41603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee14160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14160[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee14160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee14160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee14160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee14160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee14160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee14160[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee14160[] = {
  {&(_ZTV7ee14160[4]),  4,15},
  {&(_ZTV7ee14160[8]),  8,15},
  {&(_ZTV7ee14160[13]),  13,15},
  {&(_tg__ZTV6dd4160__7ee14160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee14160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee14160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee14160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee14160[];
extern  VTBL_ENTRY _ZTV7ee14160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14160[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee14160 = {  "ee14160", // class name
  bases_ee14160, 4,
  &(vtc_ee14160[0]), // expected_vtbl_contents
  &(vtt_ee14160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee14160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24160  : dd4160 {
  int e;
  virtual void  foo(); // _ZN7ee241603fooEv
  ~ee24160(); // tgen
  ee24160(); // tgen
};
//SIG(1 ee24160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24160 ::foo(){vfunc_called(this, "_ZN7ee241603fooEv");}
ee24160 ::~ee24160(){ note_dtor("ee24160", this);} // tgen
ee24160 ::ee24160(){ note_ctor("ee24160", this);} // tgen

static void Test_ee24160()
{
  extern Class_Descriptor cd_ee24160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee24160, buf);
    ee24160 *dp, &lv = *(dp=new (buf) ee24160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee24160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee24160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(24,16), "ee24160");
    check_base_class_offset(lv, (cc160*)(dd4160*), 0, "ee24160");
    check_base_class_offset(lv, (dd4160*), 0, "ee24160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24160.e");
    test_class_info(&lv, &cd_ee24160);
    dp->~ee24160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24160(Test_ee24160, "ee24160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee24160C1Ev();
extern void _ZN7ee24160D1Ev();
Name_Map name_map_ee24160[] = {
  NSPAIR(_ZN7ee24160C1Ev),
  NSPAIR(_ZN7ee24160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee24160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24160[];
extern void _ZN6dd41603barEv();
extern void _ZN7ee241603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee241603fooEv,_ZTv0_n16_N7ee241603fooEv)();
extern void ABISELECT(_ZThn24_N7ee241603fooEv,_ZThn16_N7ee241603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee24160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
  (VTBL_ENTRY)&_ZN7ee241603fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee24160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee241603fooEv,_ZTv0_n16_N7ee241603fooEv),
};
extern VTBL_ENTRY _ZTV7ee24160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee24160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee24160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee24160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee24160[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee24160[] = {
  {&(_ZTV7ee24160[3]),  3,11},
  {&(_tg__ZTV6dd4160__7ee24160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee24160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee24160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee24160[4]),  4,6},
  {&(_ZTV7ee24160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee24160[];
extern  VTBL_ENTRY _ZTV7ee24160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24160[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee241603fooEv,_ZTv0_n16_N7ee241603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee241603fooEv,_ZThn16_N7ee241603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee24160 = {  "ee24160", // class name
  bases_ee24160, 4,
  &(vtc_ee24160[0]), // expected_vtbl_contents
  &(vtt_ee24160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee24160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34160  : virtual dd4160 {
  int e;
  virtual void  foo(); // _ZN7ee341603fooEv
  ~ee34160(); // tgen
  ee34160(); // tgen
};
//SIG(1 ee34160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34160 ::foo(){vfunc_called(this, "_ZN7ee341603fooEv");}
ee34160 ::~ee34160(){ note_dtor("ee34160", this);} // tgen
ee34160 ::ee34160(){ note_ctor("ee34160", this);} // tgen

static void Test_ee34160()
{
  extern Class_Descriptor cd_ee34160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee34160, buf);
    ee34160 *dp, &lv = *(dp=new (buf) ee34160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee34160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee34160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(32,20), "ee34160");
    check_base_class_offset(lv, (cc160*)(dd4160*), ABISELECT(16,8), "ee34160");
    check_base_class_offset(lv, (dd4160*), ABISELECT(16,8), "ee34160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34160.e");
    test_class_info(&lv, &cd_ee34160);
    dp->~ee34160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34160(Test_ee34160, "ee34160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee34160C1Ev();
extern void _ZN7ee34160D1Ev();
Name_Map name_map_ee34160[] = {
  NSPAIR(_ZN7ee34160C1Ev),
  NSPAIR(_ZN7ee34160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee34160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34160[];
extern void _ZN7ee341603fooEv();
extern void _ZN6dd41603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee341603fooEv,_ZTv0_n16_N7ee341603fooEv)();
extern void ABISELECT(_ZThn32_N7ee341603fooEv,_ZThn20_N7ee341603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34160[0]),
  (VTBL_ENTRY)&_ZN7ee341603fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
  ABISELECT(-32,-20),
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee34160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee341603fooEv,_ZTv0_n16_N7ee341603fooEv),
};
extern VTBL_ENTRY _ZTV7ee34160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee34160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee34160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee34160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee34160[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee34160[] = {
  {&(_ZTV7ee34160[4]),  4,16},
  {&(_ZTV7ee34160[9]),  9,16},
  {&(_ZTV7ee34160[14]),  14,16},
  {&(_tg__ZTV6dd4160__7ee34160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee34160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee34160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee34160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee34160[];
extern  VTBL_ENTRY _ZTV7ee34160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34160[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee341603fooEv,_ZTv0_n16_N7ee341603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee341603fooEv,_ZThn20_N7ee341603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34160 = {  "ee34160", // class name
  bases_ee34160, 4,
  &(vtc_ee34160[0]), // expected_vtbl_contents
  &(vtt_ee34160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee34160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34160),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44160  : dd4160 {
  int e;
  virtual void  bar(); // _ZN7ee441603barEv
  ~ee44160(); // tgen
  ee44160(); // tgen
};
//SIG(1 ee44160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44160 ::bar(){vfunc_called(this, "_ZN7ee441603barEv");}
ee44160 ::~ee44160(){ note_dtor("ee44160", this);} // tgen
ee44160 ::ee44160(){ note_ctor("ee44160", this);} // tgen

static void Test_ee44160()
{
  extern Class_Descriptor cd_ee44160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee44160, buf);
    ee44160 *dp, &lv = *(dp=new (buf) ee44160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee44160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee44160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(24,16), "ee44160");
    check_base_class_offset(lv, (cc160*)(dd4160*), 0, "ee44160");
    check_base_class_offset(lv, (dd4160*), 0, "ee44160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44160.e");
    test_class_info(&lv, &cd_ee44160);
    dp->~ee44160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44160(Test_ee44160, "ee44160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee44160C1Ev();
extern void _ZN7ee44160D1Ev();
Name_Map name_map_ee44160[] = {
  NSPAIR(_ZN7ee44160C1Ev),
  NSPAIR(_ZN7ee44160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee44160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44160[];
extern void _ZN7ee441603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee441603barEv,_ZTv0_n12_N7ee441603barEv)();
extern void ABISELECT(_ZThn24_N7ee441603barEv,_ZThn16_N7ee441603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee44160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44160[0]),
  (VTBL_ENTRY)&_ZN7ee441603barEv,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee44160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee441603barEv,_ZTv0_n12_N7ee441603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee44160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee44160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee44160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee44160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee44160[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee44160[] = {
  {&(_ZTV7ee44160[3]),  3,10},
  {&(_tg__ZTV6dd4160__7ee44160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee44160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee44160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee44160[4]),  4,6},
  {&(_ZTV7ee44160[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee44160[];
extern  VTBL_ENTRY _ZTV7ee44160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44160[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee441603barEv,_ZTv0_n12_N7ee441603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee441603barEv,_ZThn16_N7ee441603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee44160 = {  "ee44160", // class name
  bases_ee44160, 4,
  &(vtc_ee44160[0]), // expected_vtbl_contents
  &(vtt_ee44160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee44160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44160),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54160  : virtual dd4160 {
  int e;
  virtual void  bar(); // _ZN7ee541603barEv
  ~ee54160(); // tgen
  ee54160(); // tgen
};
//SIG(1 ee54160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54160 ::bar(){vfunc_called(this, "_ZN7ee541603barEv");}
ee54160 ::~ee54160(){ note_dtor("ee54160", this);} // tgen
ee54160 ::ee54160(){ note_ctor("ee54160", this);} // tgen

static void Test_ee54160()
{
  extern Class_Descriptor cd_ee54160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee54160, buf);
    ee54160 *dp, &lv = *(dp=new (buf) ee54160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee54160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee54160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(32,20), "ee54160");
    check_base_class_offset(lv, (cc160*)(dd4160*), ABISELECT(16,8), "ee54160");
    check_base_class_offset(lv, (dd4160*), ABISELECT(16,8), "ee54160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54160.e");
    test_class_info(&lv, &cd_ee54160);
    dp->~ee54160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54160(Test_ee54160, "ee54160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee54160C1Ev();
extern void _ZN7ee54160D1Ev();
Name_Map name_map_ee54160[] = {
  NSPAIR(_ZN7ee54160C1Ev),
  NSPAIR(_ZN7ee54160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee54160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54160[];
extern void _ZN7ee541603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee541603barEv,_ZTv0_n16_N7ee541603barEv)();
extern void ABISELECT(_ZThn16_N7ee541603barEv,_ZThn8_N7ee541603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee541603barEv,_ZTv0_n12_N7ee541603barEv)();
extern void ABISELECT(_ZThn32_N7ee541603barEv,_ZThn20_N7ee541603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee54160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54160[0]),
  (VTBL_ENTRY)&_ZN7ee541603barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee541603barEv,_ZTv0_n16_N7ee541603barEv),
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee54160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee541603barEv,_ZTv0_n12_N7ee541603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee54160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee54160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee54160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee54160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee54160[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee54160[] = {
  {&(_ZTV7ee54160[4]),  4,16},
  {&(_ZTV7ee54160[9]),  9,16},
  {&(_ZTV7ee54160[14]),  14,16},
  {&(_tg__ZTV6dd4160__7ee54160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee54160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee54160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee54160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee54160[];
extern  VTBL_ENTRY _ZTV7ee54160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54160[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee541603barEv,_ZTv0_n12_N7ee541603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee541603barEv,_ZThn20_N7ee541603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee541603barEv,_ZTv0_n16_N7ee541603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541603barEv,_ZThn8_N7ee541603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54160 = {  "ee54160", // class name
  bases_ee54160, 4,
  &(vtc_ee54160[0]), // expected_vtbl_contents
  &(vtt_ee54160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee54160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54160),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64160  : dd4160 {
  int e;
  virtual void  foo(); // _ZN7ee641603fooEv
  virtual void  bar(); // _ZN7ee641603barEv
  ~ee64160(); // tgen
  ee64160(); // tgen
};
//SIG(1 ee64160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64160 ::foo(){vfunc_called(this, "_ZN7ee641603fooEv");}
void  ee64160 ::bar(){vfunc_called(this, "_ZN7ee641603barEv");}
ee64160 ::~ee64160(){ note_dtor("ee64160", this);} // tgen
ee64160 ::ee64160(){ note_ctor("ee64160", this);} // tgen

static void Test_ee64160()
{
  extern Class_Descriptor cd_ee64160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee64160, buf);
    ee64160 *dp, &lv = *(dp=new (buf) ee64160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee64160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee64160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(24,16), "ee64160");
    check_base_class_offset(lv, (cc160*)(dd4160*), 0, "ee64160");
    check_base_class_offset(lv, (dd4160*), 0, "ee64160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64160.e");
    test_class_info(&lv, &cd_ee64160);
    dp->~ee64160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64160(Test_ee64160, "ee64160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee64160C1Ev();
extern void _ZN7ee64160D1Ev();
Name_Map name_map_ee64160[] = {
  NSPAIR(_ZN7ee64160C1Ev),
  NSPAIR(_ZN7ee64160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee64160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64160[];
extern void _ZN7ee641603barEv();
extern void _ZN7ee641603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee641603barEv,_ZTv0_n12_N7ee641603barEv)();
extern void ABISELECT(_ZThn24_N7ee641603barEv,_ZThn16_N7ee641603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee641603fooEv,_ZTv0_n16_N7ee641603fooEv)();
extern void ABISELECT(_ZThn24_N7ee641603fooEv,_ZThn16_N7ee641603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee64160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64160[0]),
  (VTBL_ENTRY)&_ZN7ee641603barEv,
  (VTBL_ENTRY)&_ZN7ee641603fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee64160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee641603barEv,_ZTv0_n12_N7ee641603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee641603fooEv,_ZTv0_n16_N7ee641603fooEv),
};
extern VTBL_ENTRY _ZTV7ee64160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee64160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee64160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee64160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee64160[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee64160[] = {
  {&(_ZTV7ee64160[3]),  3,11},
  {&(_tg__ZTV6dd4160__7ee64160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee64160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee64160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee64160[4]),  4,6},
  {&(_ZTV7ee64160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee64160[];
extern  VTBL_ENTRY _ZTV7ee64160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64160[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41603barEv,_ZThn16_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee641603fooEv,_ZTv0_n16_N7ee641603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641603fooEv,_ZThn16_N7ee641603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee641603barEv,_ZTv0_n12_N7ee641603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641603barEv,_ZThn16_N7ee641603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee64160 = {  "ee64160", // class name
  bases_ee64160, 4,
  &(vtc_ee64160[0]), // expected_vtbl_contents
  &(vtt_ee64160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee64160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74160  : virtual dd4160 {
  int e;
  virtual void  foo(); // _ZN7ee741603fooEv
  virtual void  bar(); // _ZN7ee741603barEv
  ~ee74160(); // tgen
  ee74160(); // tgen
};
//SIG(1 ee74160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74160 ::foo(){vfunc_called(this, "_ZN7ee741603fooEv");}
void  ee74160 ::bar(){vfunc_called(this, "_ZN7ee741603barEv");}
ee74160 ::~ee74160(){ note_dtor("ee74160", this);} // tgen
ee74160 ::ee74160(){ note_ctor("ee74160", this);} // tgen

static void Test_ee74160()
{
  extern Class_Descriptor cd_ee74160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee74160, buf);
    ee74160 *dp, &lv = *(dp=new (buf) ee74160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee74160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee74160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd4160*), ABISELECT(32,20), "ee74160");
    check_base_class_offset(lv, (cc160*)(dd4160*), ABISELECT(16,8), "ee74160");
    check_base_class_offset(lv, (dd4160*), ABISELECT(16,8), "ee74160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74160.e");
    test_class_info(&lv, &cd_ee74160);
    dp->~ee74160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74160(Test_ee74160, "ee74160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee74160C1Ev();
extern void _ZN7ee74160D1Ev();
Name_Map name_map_ee74160[] = {
  NSPAIR(_ZN7ee74160C1Ev),
  NSPAIR(_ZN7ee74160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd4160;
extern VTBL_ENTRY _ZTI6dd4160[];
extern  VTBL_ENTRY _ZTV6dd4160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4160[];
static Base_Class bases_ee74160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74160[];
extern void _ZN7ee741603fooEv();
extern void _ZN7ee741603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee741603barEv,_ZTv0_n16_N7ee741603barEv)();
extern void ABISELECT(_ZThn16_N7ee741603barEv,_ZThn8_N7ee741603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee741603barEv,_ZTv0_n12_N7ee741603barEv)();
extern void ABISELECT(_ZThn32_N7ee741603barEv,_ZThn20_N7ee741603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee741603fooEv,_ZTv0_n16_N7ee741603fooEv)();
extern void ABISELECT(_ZThn32_N7ee741603fooEv,_ZThn20_N7ee741603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74160[0]),
  (VTBL_ENTRY)&_ZN7ee741603fooEv,
  (VTBL_ENTRY)&_ZN7ee741603barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741603barEv,_ZTv0_n16_N7ee741603barEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee74160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee741603barEv,_ZTv0_n12_N7ee741603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741603fooEv,_ZTv0_n16_N7ee741603fooEv),
};
extern VTBL_ENTRY _ZTV7ee74160[];
extern void _ZN6dd41603barEv();
static  VTBL_ENTRY _tg__ZTV6dd4160__7ee74160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&_ZN6dd41603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd4160__7ee74160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd4160__7ee74160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv)();
extern void ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd4160__7ee74160[] = {
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee74160[] = {
  {&(_ZTV7ee74160[4]),  4,17},
  {&(_ZTV7ee74160[10]),  10,17},
  {&(_ZTV7ee74160[15]),  15,17},
  {&(_tg__ZTV6dd4160__7ee74160[3]),  3,4},
  {&(_tg__ZTV5cc1606dd4160__7ee74160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd4160__7ee74160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd4160__7ee74160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee74160[];
extern  VTBL_ENTRY _ZTV7ee74160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74160[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41603barEv,_ZTv0_n12_N6dd41603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41603barEv,_ZThn12_N6dd41603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741603fooEv,_ZTv0_n16_N7ee741603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741603fooEv,_ZThn20_N7ee741603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee741603barEv,_ZTv0_n12_N7ee741603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741603barEv,_ZThn20_N7ee741603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741603barEv,_ZTv0_n16_N7ee741603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741603barEv,_ZThn8_N7ee741603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74160 = {  "ee74160", // class name
  bases_ee74160, 4,
  &(vtc_ee74160[0]), // expected_vtbl_contents
  &(vtt_ee74160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee74160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74160),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5160  : virtual cc160 {
  int d;
  virtual void  bar(); // _ZN6dd51603barEv
  ~dd5160(); // tgen
  dd5160(); // tgen
};
//SIG(-1 dd5160) C1{ VBC2{ VBC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 Fi}


void  dd5160 ::bar(){vfunc_called(this, "_ZN6dd51603barEv");}
dd5160 ::~dd5160(){ note_dtor("dd5160", this);} // tgen
dd5160 ::dd5160(){ note_ctor("dd5160", this);} // tgen

static void Test_dd5160()
{
  extern Class_Descriptor cd_dd5160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd5160, buf);
    dd5160 *dp, &lv = *(dp=new (buf) dd5160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd5160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,20), "dd5160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,16), "dd5160");
    check_base_class_offset(lv, (cc160*), ABISELECT(16,8), "dd5160");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5160.d");
    test_class_info(&lv, &cd_dd5160);
    dp->~dd5160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5160(Test_dd5160, "dd5160", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd5160C1Ev();
extern void _ZN6dd5160D1Ev();
Name_Map name_map_dd5160[] = {
  NSPAIR(_ZN6dd5160C1Ev),
  NSPAIR(_ZN6dd5160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd5160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5160[];
extern void _ZN6dd51603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_dd5160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV6dd5160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd5160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd5160[] = {
  {&(_ZTV6dd5160[4]),  4,14},
  {&(_ZTV6dd5160[8]),  8,14},
  {&(_ZTV6dd5160[12]),  12,14},
  {&(_tg__ZTV5cc160__6dd5160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd5160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5160 = {  "dd5160", // class name
  bases_dd5160, 3,
  &(vtc_dd5160[0]), // expected_vtbl_contents
  &(vtt_dd5160[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd5160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5160),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05160  : dd5160 {
  int e;
  ~ee05160(); // tgen
  ee05160(); // tgen
};
//SIG(1 ee05160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee05160 ::~ee05160(){ note_dtor("ee05160", this);} // tgen
ee05160 ::ee05160(){ note_ctor("ee05160", this);} // tgen

static void Test_ee05160()
{
  extern Class_Descriptor cd_ee05160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee05160, buf);
    ee05160 *dp, &lv = *(dp=new (buf) ee05160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee05160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee05160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee05160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(16,12), "ee05160");
    check_base_class_offset(lv, (dd5160*), 0, "ee05160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05160.e");
    test_class_info(&lv, &cd_ee05160);
    dp->~ee05160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05160(Test_ee05160, "ee05160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee05160C1Ev();
extern void _ZN7ee05160D1Ev();
Name_Map name_map_ee05160[] = {
  NSPAIR(_ZN7ee05160C1Ev),
  NSPAIR(_ZN7ee05160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee05160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05160[];
extern void _ZN6dd51603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee05160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05160[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee05160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee05160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee05160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee05160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee05160[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee05160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee05160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee05160[] = {
  {&(_ZTV7ee05160[4]),  4,14},
  {&(_tg__ZTV6dd5160__7ee05160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee05160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee05160[4]),  4,6},
  {&(_ZTV7ee05160[8]),  8,14},
  {&(_ZTV7ee05160[12]),  12,14},
  {&(_tg__ZTV5cc160__7ee05160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee05160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee05160[];
extern  VTBL_ENTRY _ZTV7ee05160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05160[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05160 = {  "ee05160", // class name
  bases_ee05160, 4,
  &(vtc_ee05160[0]), // expected_vtbl_contents
  &(vtt_ee05160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee05160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15160  : virtual dd5160 {
  int e;
  ~ee15160(); // tgen
  ee15160(); // tgen
};
//SIG(1 ee15160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} Fi}


ee15160 ::~ee15160(){ note_dtor("ee15160", this);} // tgen
ee15160 ::ee15160(){ note_ctor("ee15160", this);} // tgen

static void Test_ee15160()
{
  extern Class_Descriptor cd_ee15160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee15160, buf);
    ee15160 *dp, &lv = *(dp=new (buf) ee15160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee15160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee15160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee15160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(32,16), "ee15160");
    check_base_class_offset(lv, (dd5160*), ABISELECT(16,8), "ee15160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15160.e");
    test_class_info(&lv, &cd_ee15160);
    dp->~ee15160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15160(Test_ee15160, "ee15160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee15160C1Ev();
extern void _ZN7ee15160D1Ev();
Name_Map name_map_ee15160[] = {
  NSPAIR(_ZN7ee15160C1Ev),
  NSPAIR(_ZN7ee15160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee15160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15160[];
extern void _ZN6dd51603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee15160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15160[0]),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15160[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee15160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee15160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee15160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee15160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee15160[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee15160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee15160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee15160[] = {
  {&(_ZTV7ee15160[5]),  5,20},
  {&(_ZTV7ee15160[10]),  10,20},
  {&(_ZTV7ee15160[14]),  14,20},
  {&(_ZTV7ee15160[18]),  18,20},
  {&(_tg__ZTV6dd5160__7ee15160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee15160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee15160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee15160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee15160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee15160[];
extern  VTBL_ENTRY _ZTV7ee15160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15160[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15160 = {  "ee15160", // class name
  bases_ee15160, 4,
  &(vtc_ee15160[0]), // expected_vtbl_contents
  &(vtt_ee15160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee15160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15160),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25160  : dd5160 {
  int e;
  virtual void  foo(); // _ZN7ee251603fooEv
  ~ee25160(); // tgen
  ee25160(); // tgen
};
//SIG(1 ee25160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25160 ::foo(){vfunc_called(this, "_ZN7ee251603fooEv");}
ee25160 ::~ee25160(){ note_dtor("ee25160", this);} // tgen
ee25160 ::ee25160(){ note_ctor("ee25160", this);} // tgen

static void Test_ee25160()
{
  extern Class_Descriptor cd_ee25160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee25160, buf);
    ee25160 *dp, &lv = *(dp=new (buf) ee25160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee25160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee25160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee25160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(16,12), "ee25160");
    check_base_class_offset(lv, (dd5160*), 0, "ee25160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25160.e");
    test_class_info(&lv, &cd_ee25160);
    dp->~ee25160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25160(Test_ee25160, "ee25160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee25160C1Ev();
extern void _ZN7ee25160D1Ev();
Name_Map name_map_ee25160[] = {
  NSPAIR(_ZN7ee25160C1Ev),
  NSPAIR(_ZN7ee25160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee25160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25160[];
extern void _ZN6dd51603barEv();
extern void _ZN7ee251603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee251603fooEv,_ZTv0_n16_N7ee251603fooEv)();
extern void ABISELECT(_ZThn32_N7ee251603fooEv,_ZThn20_N7ee251603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
  (VTBL_ENTRY)&_ZN7ee251603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee25160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee251603fooEv,_ZTv0_n16_N7ee251603fooEv),
};
extern VTBL_ENTRY _ZTV7ee25160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee25160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee25160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee25160[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee25160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee25160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee25160[] = {
  {&(_ZTV7ee25160[4]),  4,15},
  {&(_tg__ZTV6dd5160__7ee25160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee25160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee25160[4]),  4,6},
  {&(_ZTV7ee25160[9]),  9,15},
  {&(_ZTV7ee25160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee25160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee25160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee25160[];
extern  VTBL_ENTRY _ZTV7ee25160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25160[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee251603fooEv,_ZTv0_n16_N7ee251603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee251603fooEv,_ZThn20_N7ee251603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25160 = {  "ee25160", // class name
  bases_ee25160, 4,
  &(vtc_ee25160[0]), // expected_vtbl_contents
  &(vtt_ee25160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee25160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35160  : virtual dd5160 {
  int e;
  virtual void  foo(); // _ZN7ee351603fooEv
  ~ee35160(); // tgen
  ee35160(); // tgen
};
//SIG(1 ee35160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35160 ::foo(){vfunc_called(this, "_ZN7ee351603fooEv");}
ee35160 ::~ee35160(){ note_dtor("ee35160", this);} // tgen
ee35160 ::ee35160(){ note_ctor("ee35160", this);} // tgen

static void Test_ee35160()
{
  extern Class_Descriptor cd_ee35160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee35160, buf);
    ee35160 *dp, &lv = *(dp=new (buf) ee35160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee35160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee35160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee35160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(32,16), "ee35160");
    check_base_class_offset(lv, (dd5160*), ABISELECT(16,8), "ee35160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35160.e");
    test_class_info(&lv, &cd_ee35160);
    dp->~ee35160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35160(Test_ee35160, "ee35160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee35160C1Ev();
extern void _ZN7ee35160D1Ev();
Name_Map name_map_ee35160[] = {
  NSPAIR(_ZN7ee35160C1Ev),
  NSPAIR(_ZN7ee35160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee35160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35160[];
extern void _ZN7ee351603fooEv();
extern void _ZN6dd51603barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee351603fooEv,_ZTv0_n16_N7ee351603fooEv)();
extern void ABISELECT(_ZThn48_N7ee351603fooEv,_ZThn24_N7ee351603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35160[0]),
  (VTBL_ENTRY)&_ZN7ee351603fooEv,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35160[0]),
  ABISELECT(-48,-24),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee35160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee351603fooEv,_ZTv0_n16_N7ee351603fooEv),
};
extern VTBL_ENTRY _ZTV7ee35160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee35160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee35160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee35160[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee35160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee35160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee35160[] = {
  {&(_ZTV7ee35160[5]),  5,21},
  {&(_ZTV7ee35160[11]),  11,21},
  {&(_ZTV7ee35160[15]),  15,21},
  {&(_ZTV7ee35160[19]),  19,21},
  {&(_tg__ZTV6dd5160__7ee35160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee35160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee35160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee35160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee35160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee35160[];
extern  VTBL_ENTRY _ZTV7ee35160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35160[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee351603fooEv,_ZTv0_n16_N7ee351603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee351603fooEv,_ZThn24_N7ee351603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35160 = {  "ee35160", // class name
  bases_ee35160, 4,
  &(vtc_ee35160[0]), // expected_vtbl_contents
  &(vtt_ee35160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee35160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35160),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45160  : dd5160 {
  int e;
  virtual void  bar(); // _ZN7ee451603barEv
  ~ee45160(); // tgen
  ee45160(); // tgen
};
//SIG(1 ee45160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45160 ::bar(){vfunc_called(this, "_ZN7ee451603barEv");}
ee45160 ::~ee45160(){ note_dtor("ee45160", this);} // tgen
ee45160 ::ee45160(){ note_ctor("ee45160", this);} // tgen

static void Test_ee45160()
{
  extern Class_Descriptor cd_ee45160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee45160, buf);
    ee45160 *dp, &lv = *(dp=new (buf) ee45160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee45160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee45160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee45160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(16,12), "ee45160");
    check_base_class_offset(lv, (dd5160*), 0, "ee45160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45160.e");
    test_class_info(&lv, &cd_ee45160);
    dp->~ee45160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45160(Test_ee45160, "ee45160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee45160C1Ev();
extern void _ZN7ee45160D1Ev();
Name_Map name_map_ee45160[] = {
  NSPAIR(_ZN7ee45160C1Ev),
  NSPAIR(_ZN7ee45160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee45160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45160[];
extern void _ZN7ee451603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee451603barEv,_ZTv0_n12_N7ee451603barEv)();
extern void ABISELECT(_ZThn32_N7ee451603barEv,_ZThn20_N7ee451603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee45160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45160[0]),
  (VTBL_ENTRY)&_ZN7ee451603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45160[0]),
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee45160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee451603barEv,_ZTv0_n12_N7ee451603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee45160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee45160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee45160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee45160[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee45160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee45160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee45160[] = {
  {&(_ZTV7ee45160[4]),  4,14},
  {&(_tg__ZTV6dd5160__7ee45160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee45160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee45160[4]),  4,6},
  {&(_ZTV7ee45160[8]),  8,14},
  {&(_ZTV7ee45160[12]),  12,14},
  {&(_tg__ZTV5cc160__7ee45160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee45160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee45160[];
extern  VTBL_ENTRY _ZTV7ee45160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45160[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee451603barEv,_ZTv0_n12_N7ee451603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee451603barEv,_ZThn20_N7ee451603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45160 = {  "ee45160", // class name
  bases_ee45160, 4,
  &(vtc_ee45160[0]), // expected_vtbl_contents
  &(vtt_ee45160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee45160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45160),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55160  : virtual dd5160 {
  int e;
  virtual void  bar(); // _ZN7ee551603barEv
  ~ee55160(); // tgen
  ee55160(); // tgen
};
//SIG(1 ee55160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55160 ::bar(){vfunc_called(this, "_ZN7ee551603barEv");}
ee55160 ::~ee55160(){ note_dtor("ee55160", this);} // tgen
ee55160 ::ee55160(){ note_ctor("ee55160", this);} // tgen

static void Test_ee55160()
{
  extern Class_Descriptor cd_ee55160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee55160, buf);
    ee55160 *dp, &lv = *(dp=new (buf) ee55160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee55160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee55160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee55160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(32,16), "ee55160");
    check_base_class_offset(lv, (dd5160*), ABISELECT(16,8), "ee55160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55160.e");
    test_class_info(&lv, &cd_ee55160);
    dp->~ee55160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55160(Test_ee55160, "ee55160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee55160C1Ev();
extern void _ZN7ee55160D1Ev();
Name_Map name_map_ee55160[] = {
  NSPAIR(_ZN7ee55160C1Ev),
  NSPAIR(_ZN7ee55160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee55160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55160[];
extern void _ZN7ee551603barEv();
extern void ABISELECT(_ZTv0_n40_N7ee551603barEv,_ZTv0_n20_N7ee551603barEv)();
extern void ABISELECT(_ZThn16_N7ee551603barEv,_ZThn8_N7ee551603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee551603barEv,_ZTv0_n12_N7ee551603barEv)();
extern void ABISELECT(_ZThn48_N7ee551603barEv,_ZThn24_N7ee551603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY vtc_ee55160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55160[0]),
  (VTBL_ENTRY)&_ZN7ee551603barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee551603barEv,_ZTv0_n20_N7ee551603barEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55160[0]),
  0,
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee55160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee551603barEv,_ZTv0_n12_N7ee551603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern VTBL_ENTRY _ZTV7ee55160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee55160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee55160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee55160[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee55160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee55160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee55160[] = {
  {&(_ZTV7ee55160[5]),  5,21},
  {&(_ZTV7ee55160[11]),  11,21},
  {&(_ZTV7ee55160[15]),  15,21},
  {&(_ZTV7ee55160[19]),  19,21},
  {&(_tg__ZTV6dd5160__7ee55160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee55160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee55160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee55160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee55160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee55160[];
extern  VTBL_ENTRY _ZTV7ee55160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55160[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee551603barEv,_ZTv0_n12_N7ee551603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee551603barEv,_ZThn24_N7ee551603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee551603barEv,_ZTv0_n20_N7ee551603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551603barEv,_ZThn8_N7ee551603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55160 = {  "ee55160", // class name
  bases_ee55160, 4,
  &(vtc_ee55160[0]), // expected_vtbl_contents
  &(vtt_ee55160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee55160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55160),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65160  : dd5160 {
  int e;
  virtual void  foo(); // _ZN7ee651603fooEv
  virtual void  bar(); // _ZN7ee651603barEv
  ~ee65160(); // tgen
  ee65160(); // tgen
};
//SIG(1 ee65160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65160 ::foo(){vfunc_called(this, "_ZN7ee651603fooEv");}
void  ee65160 ::bar(){vfunc_called(this, "_ZN7ee651603barEv");}
ee65160 ::~ee65160(){ note_dtor("ee65160", this);} // tgen
ee65160 ::ee65160(){ note_ctor("ee65160", this);} // tgen

static void Test_ee65160()
{
  extern Class_Descriptor cd_ee65160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee65160, buf);
    ee65160 *dp, &lv = *(dp=new (buf) ee65160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee65160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee65160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee65160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(16,12), "ee65160");
    check_base_class_offset(lv, (dd5160*), 0, "ee65160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65160.e");
    test_class_info(&lv, &cd_ee65160);
    dp->~ee65160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65160(Test_ee65160, "ee65160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee65160C1Ev();
extern void _ZN7ee65160D1Ev();
Name_Map name_map_ee65160[] = {
  NSPAIR(_ZN7ee65160C1Ev),
  NSPAIR(_ZN7ee65160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee65160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65160[];
extern void _ZN7ee651603barEv();
extern void _ZN7ee651603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee651603barEv,_ZTv0_n12_N7ee651603barEv)();
extern void ABISELECT(_ZThn32_N7ee651603barEv,_ZThn20_N7ee651603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee651603fooEv,_ZTv0_n16_N7ee651603fooEv)();
extern void ABISELECT(_ZThn32_N7ee651603fooEv,_ZThn20_N7ee651603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65160[0]),
  (VTBL_ENTRY)&_ZN7ee651603barEv,
  (VTBL_ENTRY)&_ZN7ee651603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee65160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee651603barEv,_ZTv0_n12_N7ee651603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee651603fooEv,_ZTv0_n16_N7ee651603fooEv),
};
extern VTBL_ENTRY _ZTV7ee65160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee65160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee65160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee65160[] = {
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee65160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee65160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee65160[] = {
  {&(_ZTV7ee65160[4]),  4,15},
  {&(_tg__ZTV6dd5160__7ee65160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee65160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee65160[4]),  4,6},
  {&(_ZTV7ee65160[9]),  9,15},
  {&(_ZTV7ee65160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee65160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee65160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee65160[];
extern  VTBL_ENTRY _ZTV7ee65160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65160[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn20_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee651603fooEv,_ZTv0_n16_N7ee651603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651603fooEv,_ZThn20_N7ee651603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee651603barEv,_ZTv0_n12_N7ee651603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651603barEv,_ZThn20_N7ee651603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65160 = {  "ee65160", // class name
  bases_ee65160, 4,
  &(vtc_ee65160[0]), // expected_vtbl_contents
  &(vtt_ee65160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee65160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75160  : virtual dd5160 {
  int e;
  virtual void  foo(); // _ZN7ee751603fooEv
  virtual void  bar(); // _ZN7ee751603barEv
  ~ee75160(); // tgen
  ee75160(); // tgen
};
//SIG(1 ee75160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75160 ::foo(){vfunc_called(this, "_ZN7ee751603fooEv");}
void  ee75160 ::bar(){vfunc_called(this, "_ZN7ee751603barEv");}
ee75160 ::~ee75160(){ note_dtor("ee75160", this);} // tgen
ee75160 ::ee75160(){ note_ctor("ee75160", this);} // tgen

static void Test_ee75160()
{
  extern Class_Descriptor cd_ee75160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee75160, buf);
    ee75160 *dp, &lv = *(dp=new (buf) ee75160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee75160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee75160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee75160");
    check_base_class_offset(lv, (cc160*)(dd5160*), ABISELECT(32,16), "ee75160");
    check_base_class_offset(lv, (dd5160*), ABISELECT(16,8), "ee75160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75160.e");
    test_class_info(&lv, &cd_ee75160);
    dp->~ee75160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75160(Test_ee75160, "ee75160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee75160C1Ev();
extern void _ZN7ee75160D1Ev();
Name_Map name_map_ee75160[] = {
  NSPAIR(_ZN7ee75160C1Ev),
  NSPAIR(_ZN7ee75160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd5160;
extern VTBL_ENTRY _ZTI6dd5160[];
extern  VTBL_ENTRY _ZTV6dd5160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5160[];
static Base_Class bases_ee75160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5160,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75160[];
extern void _ZN7ee751603fooEv();
extern void _ZN7ee751603barEv();
extern void ABISELECT(_ZTv0_n40_N7ee751603barEv,_ZTv0_n20_N7ee751603barEv)();
extern void ABISELECT(_ZThn16_N7ee751603barEv,_ZThn8_N7ee751603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee751603barEv,_ZTv0_n12_N7ee751603barEv)();
extern void ABISELECT(_ZThn48_N7ee751603barEv,_ZThn24_N7ee751603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee751603fooEv,_ZTv0_n16_N7ee751603fooEv)();
extern void ABISELECT(_ZThn48_N7ee751603fooEv,_ZThn24_N7ee751603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75160[0]),
  (VTBL_ENTRY)&_ZN7ee751603fooEv,
  (VTBL_ENTRY)&_ZN7ee751603barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee751603barEv,_ZTv0_n20_N7ee751603barEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75160[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee75160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee751603barEv,_ZTv0_n12_N7ee751603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee751603fooEv,_ZTv0_n16_N7ee751603fooEv),
};
extern VTBL_ENTRY _ZTV7ee75160[];
extern void _ZN6dd51603barEv();
static  VTBL_ENTRY _tg__ZTV6dd5160__7ee75160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&_ZN6dd51603barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd5160__7ee75160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv)();
extern void ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv)() __attribute__((weak));
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__6dd5160__7ee75160[] = {
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv),
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee75160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee75160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee75160[] = {
  {&(_ZTV7ee75160[5]),  5,22},
  {&(_ZTV7ee75160[12]),  12,22},
  {&(_ZTV7ee75160[16]),  16,22},
  {&(_ZTV7ee75160[20]),  20,22},
  {&(_tg__ZTV6dd5160__7ee75160[4]),  4,5},
  {&(_tg__ZTV5cc160__6dd5160__7ee75160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd5160__7ee75160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee75160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee75160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee75160[];
extern  VTBL_ENTRY _ZTV7ee75160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75160[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51603barEv,_ZTv0_n12_N6dd51603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51603barEv,_ZThn16_N6dd51603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee751603fooEv,_ZTv0_n16_N7ee751603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751603fooEv,_ZThn24_N7ee751603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee751603barEv,_ZTv0_n12_N7ee751603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751603barEv,_ZThn24_N7ee751603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee751603barEv,_ZTv0_n20_N7ee751603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751603barEv,_ZThn8_N7ee751603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75160 = {  "ee75160", // class name
  bases_ee75160, 4,
  &(vtc_ee75160[0]), // expected_vtbl_contents
  &(vtt_ee75160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee75160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75160),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6160  : cc160 {
  int d;
  virtual void  bar(); // _ZN6dd61603barEv
  virtual void  foo(); // _ZN6dd61603fooEv
  ~dd6160(); // tgen
  dd6160(); // tgen
};
//SIG(-1 dd6160) C1{ BC2{ VBC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd6160 ::bar(){vfunc_called(this, "_ZN6dd61603barEv");}
void  dd6160 ::foo(){vfunc_called(this, "_ZN6dd61603fooEv");}
dd6160 ::~dd6160(){ note_dtor("dd6160", this);} // tgen
dd6160 ::dd6160(){ note_ctor("dd6160", this);} // tgen

static void Test_dd6160()
{
  extern Class_Descriptor cd_dd6160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd6160, buf);
    dd6160 *dp, &lv = *(dp=new (buf) dd6160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd6160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(24,16), "dd6160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(16,12), "dd6160");
    check_base_class_offset(lv, (cc160*), 0, "dd6160");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6160.d");
    test_class_info(&lv, &cd_dd6160);
    dp->~dd6160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6160(Test_dd6160, "dd6160", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd6160C1Ev();
extern void _ZN6dd6160D1Ev();
Name_Map name_map_dd6160[] = {
  NSPAIR(_ZN6dd6160C1Ev),
  NSPAIR(_ZN6dd6160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd6160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd6160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
extern VTBL_ENTRY _ZTV6dd6160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd6160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd6160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd6160[] = {
  {&(_ZTV6dd6160[3]),  3,11},
  {&(_tg__ZTV5cc160__6dd6160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd6160[4]),  4,6},
  {&(_ZTV6dd6160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd6160 = {  "dd6160", // class name
  bases_dd6160, 3,
  &(vtc_dd6160[0]), // expected_vtbl_contents
  &(vtt_dd6160[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd6160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6160),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06160  : dd6160 {
  int e;
  ~ee06160(); // tgen
  ee06160(); // tgen
};
//SIG(1 ee06160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee06160 ::~ee06160(){ note_dtor("ee06160", this);} // tgen
ee06160 ::ee06160(){ note_ctor("ee06160", this);} // tgen

static void Test_ee06160()
{
  extern Class_Descriptor cd_ee06160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee06160, buf);
    ee06160 *dp, &lv = *(dp=new (buf) ee06160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee06160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee06160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(24,16), "ee06160");
    check_base_class_offset(lv, (cc160*)(dd6160*), 0, "ee06160");
    check_base_class_offset(lv, (dd6160*), 0, "ee06160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06160.e");
    test_class_info(&lv, &cd_ee06160);
    dp->~ee06160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06160(Test_ee06160, "ee06160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee06160C1Ev();
extern void _ZN7ee06160D1Ev();
Name_Map name_map_ee06160[] = {
  NSPAIR(_ZN7ee06160C1Ev),
  NSPAIR(_ZN7ee06160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee06160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee06160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee06160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
extern VTBL_ENTRY _ZTV7ee06160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee06160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee06160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee06160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee06160[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee06160[] = {
  {&(_ZTV7ee06160[3]),  3,11},
  {&(_tg__ZTV6dd6160__7ee06160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee06160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee06160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee06160[4]),  4,6},
  {&(_ZTV7ee06160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee06160[];
extern  VTBL_ENTRY _ZTV7ee06160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06160[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee06160 = {  "ee06160", // class name
  bases_ee06160, 4,
  &(vtc_ee06160[0]), // expected_vtbl_contents
  &(vtt_ee06160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee06160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16160  : virtual dd6160 {
  int e;
  ~ee16160(); // tgen
  ee16160(); // tgen
};
//SIG(1 ee16160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee16160 ::~ee16160(){ note_dtor("ee16160", this);} // tgen
ee16160 ::ee16160(){ note_ctor("ee16160", this);} // tgen

static void Test_ee16160()
{
  extern Class_Descriptor cd_ee16160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee16160, buf);
    ee16160 *dp, &lv = *(dp=new (buf) ee16160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee16160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee16160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(32,20), "ee16160");
    check_base_class_offset(lv, (cc160*)(dd6160*), ABISELECT(16,8), "ee16160");
    check_base_class_offset(lv, (dd6160*), ABISELECT(16,8), "ee16160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16160.e");
    test_class_info(&lv, &cd_ee16160);
    dp->~ee16160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16160(Test_ee16160, "ee16160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee16160C1Ev();
extern void _ZN7ee16160D1Ev();
Name_Map name_map_ee16160[] = {
  NSPAIR(_ZN7ee16160C1Ev),
  NSPAIR(_ZN7ee16160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee16160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee16160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16160[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee16160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
extern VTBL_ENTRY _ZTV7ee16160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee16160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee16160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee16160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee16160[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee16160[] = {
  {&(_ZTV7ee16160[4]),  4,17},
  {&(_ZTV7ee16160[9]),  9,17},
  {&(_ZTV7ee16160[15]),  15,17},
  {&(_tg__ZTV6dd6160__7ee16160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee16160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee16160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee16160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee16160[];
extern  VTBL_ENTRY _ZTV7ee16160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16160[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee16160 = {  "ee16160", // class name
  bases_ee16160, 4,
  &(vtc_ee16160[0]), // expected_vtbl_contents
  &(vtt_ee16160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee16160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16160),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26160  : dd6160 {
  int e;
  virtual void  foo(); // _ZN7ee261603fooEv
  ~ee26160(); // tgen
  ee26160(); // tgen
};
//SIG(1 ee26160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26160 ::foo(){vfunc_called(this, "_ZN7ee261603fooEv");}
ee26160 ::~ee26160(){ note_dtor("ee26160", this);} // tgen
ee26160 ::ee26160(){ note_ctor("ee26160", this);} // tgen

static void Test_ee26160()
{
  extern Class_Descriptor cd_ee26160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee26160, buf);
    ee26160 *dp, &lv = *(dp=new (buf) ee26160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee26160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee26160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(24,16), "ee26160");
    check_base_class_offset(lv, (cc160*)(dd6160*), 0, "ee26160");
    check_base_class_offset(lv, (dd6160*), 0, "ee26160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26160.e");
    test_class_info(&lv, &cd_ee26160);
    dp->~ee26160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26160(Test_ee26160, "ee26160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee26160C1Ev();
extern void _ZN7ee26160D1Ev();
Name_Map name_map_ee26160[] = {
  NSPAIR(_ZN7ee26160C1Ev),
  NSPAIR(_ZN7ee26160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee26160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26160[];
extern void _ZN6dd61603barEv();
extern void _ZN7ee261603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee261603fooEv,_ZTv0_n16_N7ee261603fooEv)();
extern void ABISELECT(_ZThn24_N7ee261603fooEv,_ZThn16_N7ee261603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee26160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN7ee261603fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee26160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee261603fooEv,_ZTv0_n16_N7ee261603fooEv),
};
extern VTBL_ENTRY _ZTV7ee26160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee26160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee26160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee26160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee26160[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee26160[] = {
  {&(_ZTV7ee26160[3]),  3,11},
  {&(_tg__ZTV6dd6160__7ee26160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee26160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee26160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee26160[4]),  4,6},
  {&(_ZTV7ee26160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee26160[];
extern  VTBL_ENTRY _ZTV7ee26160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26160[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee261603fooEv,_ZTv0_n16_N7ee261603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee261603fooEv,_ZThn16_N7ee261603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee26160 = {  "ee26160", // class name
  bases_ee26160, 4,
  &(vtc_ee26160[0]), // expected_vtbl_contents
  &(vtt_ee26160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee26160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36160  : virtual dd6160 {
  int e;
  virtual void  foo(); // _ZN7ee361603fooEv
  ~ee36160(); // tgen
  ee36160(); // tgen
};
//SIG(1 ee36160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36160 ::foo(){vfunc_called(this, "_ZN7ee361603fooEv");}
ee36160 ::~ee36160(){ note_dtor("ee36160", this);} // tgen
ee36160 ::ee36160(){ note_ctor("ee36160", this);} // tgen

static void Test_ee36160()
{
  extern Class_Descriptor cd_ee36160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee36160, buf);
    ee36160 *dp, &lv = *(dp=new (buf) ee36160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee36160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee36160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(32,20), "ee36160");
    check_base_class_offset(lv, (cc160*)(dd6160*), ABISELECT(16,8), "ee36160");
    check_base_class_offset(lv, (dd6160*), ABISELECT(16,8), "ee36160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36160.e");
    test_class_info(&lv, &cd_ee36160);
    dp->~ee36160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36160(Test_ee36160, "ee36160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee36160C1Ev();
extern void _ZN7ee36160D1Ev();
Name_Map name_map_ee36160[] = {
  NSPAIR(_ZN7ee36160C1Ev),
  NSPAIR(_ZN7ee36160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee36160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36160[];
extern void _ZN7ee361603fooEv();
extern void _ZN6dd61603barEv();
extern void ABISELECT(_ZTv0_n40_N7ee361603fooEv,_ZTv0_n20_N7ee361603fooEv)();
extern void ABISELECT(_ZThn16_N7ee361603fooEv,_ZThn8_N7ee361603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee361603fooEv,_ZTv0_n16_N7ee361603fooEv)();
extern void ABISELECT(_ZThn32_N7ee361603fooEv,_ZThn20_N7ee361603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36160[0]),
  (VTBL_ENTRY)&_ZN7ee361603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee361603fooEv,_ZTv0_n20_N7ee361603fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee36160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee361603fooEv,_ZTv0_n16_N7ee361603fooEv),
};
extern VTBL_ENTRY _ZTV7ee36160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee36160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee36160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee36160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee36160[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee36160[] = {
  {&(_ZTV7ee36160[4]),  4,18},
  {&(_ZTV7ee36160[10]),  10,18},
  {&(_ZTV7ee36160[16]),  16,18},
  {&(_tg__ZTV6dd6160__7ee36160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee36160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee36160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee36160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee36160[];
extern  VTBL_ENTRY _ZTV7ee36160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36160[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee361603fooEv,_ZTv0_n16_N7ee361603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee361603fooEv,_ZThn20_N7ee361603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee361603fooEv,_ZTv0_n20_N7ee361603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361603fooEv,_ZThn8_N7ee361603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36160 = {  "ee36160", // class name
  bases_ee36160, 4,
  &(vtc_ee36160[0]), // expected_vtbl_contents
  &(vtt_ee36160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee36160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36160),18, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46160  : dd6160 {
  int e;
  virtual void  bar(); // _ZN7ee461603barEv
  ~ee46160(); // tgen
  ee46160(); // tgen
};
//SIG(1 ee46160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46160 ::bar(){vfunc_called(this, "_ZN7ee461603barEv");}
ee46160 ::~ee46160(){ note_dtor("ee46160", this);} // tgen
ee46160 ::ee46160(){ note_ctor("ee46160", this);} // tgen

static void Test_ee46160()
{
  extern Class_Descriptor cd_ee46160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee46160, buf);
    ee46160 *dp, &lv = *(dp=new (buf) ee46160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee46160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee46160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(24,16), "ee46160");
    check_base_class_offset(lv, (cc160*)(dd6160*), 0, "ee46160");
    check_base_class_offset(lv, (dd6160*), 0, "ee46160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46160.e");
    test_class_info(&lv, &cd_ee46160);
    dp->~ee46160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46160(Test_ee46160, "ee46160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee46160C1Ev();
extern void _ZN7ee46160D1Ev();
Name_Map name_map_ee46160[] = {
  NSPAIR(_ZN7ee46160C1Ev),
  NSPAIR(_ZN7ee46160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee46160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46160[];
extern void _ZN7ee461603barEv();
extern void _ZN6dd61603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee461603barEv,_ZTv0_n12_N7ee461603barEv)();
extern void ABISELECT(_ZThn24_N7ee461603barEv,_ZThn16_N7ee461603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee46160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46160[0]),
  (VTBL_ENTRY)&_ZN7ee461603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee46160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee461603barEv,_ZTv0_n12_N7ee461603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
extern VTBL_ENTRY _ZTV7ee46160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee46160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee46160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee46160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee46160[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee46160[] = {
  {&(_ZTV7ee46160[3]),  3,11},
  {&(_tg__ZTV6dd6160__7ee46160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee46160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee46160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee46160[4]),  4,6},
  {&(_ZTV7ee46160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee46160[];
extern  VTBL_ENTRY _ZTV7ee46160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46160[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee461603barEv,_ZTv0_n12_N7ee461603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee461603barEv,_ZThn16_N7ee461603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee46160 = {  "ee46160", // class name
  bases_ee46160, 4,
  &(vtc_ee46160[0]), // expected_vtbl_contents
  &(vtt_ee46160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee46160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56160  : virtual dd6160 {
  int e;
  virtual void  bar(); // _ZN7ee561603barEv
  ~ee56160(); // tgen
  ee56160(); // tgen
};
//SIG(1 ee56160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56160 ::bar(){vfunc_called(this, "_ZN7ee561603barEv");}
ee56160 ::~ee56160(){ note_dtor("ee56160", this);} // tgen
ee56160 ::ee56160(){ note_ctor("ee56160", this);} // tgen

static void Test_ee56160()
{
  extern Class_Descriptor cd_ee56160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee56160, buf);
    ee56160 *dp, &lv = *(dp=new (buf) ee56160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee56160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee56160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(32,20), "ee56160");
    check_base_class_offset(lv, (cc160*)(dd6160*), ABISELECT(16,8), "ee56160");
    check_base_class_offset(lv, (dd6160*), ABISELECT(16,8), "ee56160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56160.e");
    test_class_info(&lv, &cd_ee56160);
    dp->~ee56160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56160(Test_ee56160, "ee56160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee56160C1Ev();
extern void _ZN7ee56160D1Ev();
Name_Map name_map_ee56160[] = {
  NSPAIR(_ZN7ee56160C1Ev),
  NSPAIR(_ZN7ee56160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee56160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56160[];
extern void _ZN7ee561603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee561603barEv,_ZTv0_n16_N7ee561603barEv)();
extern void ABISELECT(_ZThn16_N7ee561603barEv,_ZThn8_N7ee561603barEv)() __attribute__((weak));
extern void _ZN6dd61603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee561603barEv,_ZTv0_n12_N7ee561603barEv)();
extern void ABISELECT(_ZThn32_N7ee561603barEv,_ZThn20_N7ee561603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56160[0]),
  (VTBL_ENTRY)&_ZN7ee561603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee561603barEv,_ZTv0_n16_N7ee561603barEv),
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee56160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee561603barEv,_ZTv0_n12_N7ee561603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
extern VTBL_ENTRY _ZTV7ee56160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee56160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee56160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee56160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee56160[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee56160[] = {
  {&(_ZTV7ee56160[4]),  4,18},
  {&(_ZTV7ee56160[10]),  10,18},
  {&(_ZTV7ee56160[16]),  16,18},
  {&(_tg__ZTV6dd6160__7ee56160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee56160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee56160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee56160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee56160[];
extern  VTBL_ENTRY _ZTV7ee56160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56160[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee561603barEv,_ZTv0_n12_N7ee561603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee561603barEv,_ZThn20_N7ee561603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee561603barEv,_ZTv0_n16_N7ee561603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561603barEv,_ZThn8_N7ee561603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56160 = {  "ee56160", // class name
  bases_ee56160, 4,
  &(vtc_ee56160[0]), // expected_vtbl_contents
  &(vtt_ee56160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee56160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56160),18, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66160  : dd6160 {
  int e;
  virtual void  foo(); // _ZN7ee661603fooEv
  virtual void  bar(); // _ZN7ee661603barEv
  ~ee66160(); // tgen
  ee66160(); // tgen
};
//SIG(1 ee66160) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66160 ::foo(){vfunc_called(this, "_ZN7ee661603fooEv");}
void  ee66160 ::bar(){vfunc_called(this, "_ZN7ee661603barEv");}
ee66160 ::~ee66160(){ note_dtor("ee66160", this);} // tgen
ee66160 ::ee66160(){ note_ctor("ee66160", this);} // tgen

static void Test_ee66160()
{
  extern Class_Descriptor cd_ee66160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee66160, buf);
    ee66160 *dp, &lv = *(dp=new (buf) ee66160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee66160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(32,20), "ee66160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(24,16), "ee66160");
    check_base_class_offset(lv, (cc160*)(dd6160*), 0, "ee66160");
    check_base_class_offset(lv, (dd6160*), 0, "ee66160");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66160.e");
    test_class_info(&lv, &cd_ee66160);
    dp->~ee66160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66160(Test_ee66160, "ee66160", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee66160C1Ev();
extern void _ZN7ee66160D1Ev();
Name_Map name_map_ee66160[] = {
  NSPAIR(_ZN7ee66160C1Ev),
  NSPAIR(_ZN7ee66160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee66160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66160[];
extern void _ZN7ee661603barEv();
extern void _ZN7ee661603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee661603barEv,_ZTv0_n12_N7ee661603barEv)();
extern void ABISELECT(_ZThn24_N7ee661603barEv,_ZThn16_N7ee661603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee661603fooEv,_ZTv0_n16_N7ee661603fooEv)();
extern void ABISELECT(_ZThn24_N7ee661603fooEv,_ZThn16_N7ee661603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee66160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66160[0]),
  (VTBL_ENTRY)&_ZN7ee661603barEv,
  (VTBL_ENTRY)&_ZN7ee661603fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee66160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee661603barEv,_ZTv0_n12_N7ee661603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee661603fooEv,_ZTv0_n16_N7ee661603fooEv),
};
extern VTBL_ENTRY _ZTV7ee66160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee66160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee66160[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee66160[] = {
  0,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee66160[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee66160[] = {
  {&(_ZTV7ee66160[3]),  3,11},
  {&(_tg__ZTV6dd6160__7ee66160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee66160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee66160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee66160[4]),  4,6},
  {&(_ZTV7ee66160[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee66160[];
extern  VTBL_ENTRY _ZTV7ee66160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66160[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603fooEv,_ZThn16_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61603barEv,_ZThn16_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee661603fooEv,_ZTv0_n16_N7ee661603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661603fooEv,_ZThn16_N7ee661603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee661603barEv,_ZTv0_n12_N7ee661603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661603barEv,_ZThn16_N7ee661603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee66160 = {  "ee66160", // class name
  bases_ee66160, 4,
  &(vtc_ee66160[0]), // expected_vtbl_contents
  &(vtt_ee66160[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee66160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66160),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66160),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76160  : virtual dd6160 {
  int e;
  virtual void  foo(); // _ZN7ee761603fooEv
  virtual void  bar(); // _ZN7ee761603barEv
  ~ee76160(); // tgen
  ee76160(); // tgen
};
//SIG(1 ee76160) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76160 ::foo(){vfunc_called(this, "_ZN7ee761603fooEv");}
void  ee76160 ::bar(){vfunc_called(this, "_ZN7ee761603barEv");}
ee76160 ::~ee76160(){ note_dtor("ee76160", this);} // tgen
ee76160 ::ee76160(){ note_ctor("ee76160", this);} // tgen

static void Test_ee76160()
{
  extern Class_Descriptor cd_ee76160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee76160, buf);
    ee76160 *dp, &lv = *(dp=new (buf) ee76160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee76160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee76160");
    check_base_class_offset(lv, (bb60*)(cc160*)(dd6160*), ABISELECT(32,20), "ee76160");
    check_base_class_offset(lv, (cc160*)(dd6160*), ABISELECT(16,8), "ee76160");
    check_base_class_offset(lv, (dd6160*), ABISELECT(16,8), "ee76160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76160.e");
    test_class_info(&lv, &cd_ee76160);
    dp->~ee76160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76160(Test_ee76160, "ee76160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee76160C1Ev();
extern void _ZN7ee76160D1Ev();
Name_Map name_map_ee76160[] = {
  NSPAIR(_ZN7ee76160C1Ev),
  NSPAIR(_ZN7ee76160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd6160;
extern VTBL_ENTRY _ZTI6dd6160[];
extern  VTBL_ENTRY _ZTV6dd6160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6160[];
static Base_Class bases_ee76160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76160[];
extern void _ZN7ee761603fooEv();
extern void _ZN7ee761603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee761603barEv,_ZTv0_n16_N7ee761603barEv)();
extern void ABISELECT(_ZThn16_N7ee761603barEv,_ZThn8_N7ee761603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee761603fooEv,_ZTv0_n20_N7ee761603fooEv)();
extern void ABISELECT(_ZThn16_N7ee761603fooEv,_ZThn8_N7ee761603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee761603barEv,_ZTv0_n12_N7ee761603barEv)();
extern void ABISELECT(_ZThn32_N7ee761603barEv,_ZThn20_N7ee761603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee761603fooEv,_ZTv0_n16_N7ee761603fooEv)();
extern void ABISELECT(_ZThn32_N7ee761603fooEv,_ZThn20_N7ee761603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76160[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76160[0]),
  (VTBL_ENTRY)&_ZN7ee761603fooEv,
  (VTBL_ENTRY)&_ZN7ee761603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761603barEv,_ZTv0_n16_N7ee761603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761603fooEv,_ZTv0_n20_N7ee761603fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee76160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee761603barEv,_ZTv0_n12_N7ee761603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761603fooEv,_ZTv0_n16_N7ee761603fooEv),
};
extern VTBL_ENTRY _ZTV7ee76160[];
extern void _ZN6dd61603barEv();
extern void _ZN6dd61603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6160__7ee76160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&_ZN6dd61603barEv,
  (VTBL_ENTRY)&_ZN6dd61603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1606dd6160__7ee76160[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc1606dd6160__7ee76160[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv)();
extern void ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv)();
extern void ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd6160__7ee76160[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv),
};
static  VTT_ENTRY vtt_ee76160[] = {
  {&(_ZTV7ee76160[4]),  4,19},
  {&(_ZTV7ee76160[11]),  11,19},
  {&(_ZTV7ee76160[17]),  17,19},
  {&(_tg__ZTV6dd6160__7ee76160[3]),  3,5},
  {&(_tg__ZTV5cc1606dd6160__7ee76160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc1606dd6160__7ee76160[4]),  4,6},
  {&(_tg__ZTV4bb60__6dd6160__7ee76160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee76160[];
extern  VTBL_ENTRY _ZTV7ee76160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76160[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61603fooEv,_ZTv0_n16_N6dd61603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603fooEv,_ZThn12_N6dd61603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61603barEv,_ZTv0_n12_N6dd61603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61603barEv,_ZThn12_N6dd61603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761603fooEv,_ZTv0_n16_N7ee761603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761603fooEv,_ZThn20_N7ee761603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee761603barEv,_ZTv0_n12_N7ee761603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761603barEv,_ZThn20_N7ee761603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761603fooEv,_ZTv0_n20_N7ee761603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761603fooEv,_ZThn8_N7ee761603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761603barEv,_ZTv0_n16_N7ee761603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761603barEv,_ZThn8_N7ee761603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76160 = {  "ee76160", // class name
  bases_ee76160, 4,
  &(vtc_ee76160[0]), // expected_vtbl_contents
  &(vtt_ee76160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee76160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76160),19, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76160),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7160  : virtual cc160 {
  int d;
  virtual void  bar(); // _ZN6dd71603barEv
  virtual void  foo(); // _ZN6dd71603fooEv
  ~dd7160(); // tgen
  dd7160(); // tgen
};
//SIG(-1 dd7160) C1{ VBC2{ VBC3{ BC4{ Fi} v1 v2 Fi} Fi} v1 v2 Fi}


void  dd7160 ::bar(){vfunc_called(this, "_ZN6dd71603barEv");}
void  dd7160 ::foo(){vfunc_called(this, "_ZN6dd71603fooEv");}
dd7160 ::~dd7160(){ note_dtor("dd7160", this);} // tgen
dd7160 ::dd7160(){ note_ctor("dd7160", this);} // tgen

static void Test_dd7160()
{
  extern Class_Descriptor cd_dd7160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd7160, buf);
    dd7160 *dp, &lv = *(dp=new (buf) dd7160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd7160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,20), "dd7160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,16), "dd7160");
    check_base_class_offset(lv, (cc160*), ABISELECT(16,8), "dd7160");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7160.d");
    test_class_info(&lv, &cd_dd7160);
    dp->~dd7160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7160(Test_dd7160, "dd7160", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd7160C1Ev();
extern void _ZN6dd7160D1Ev();
Name_Map name_map_dd7160[] = {
  NSPAIR(_ZN6dd7160C1Ev),
  NSPAIR(_ZN6dd7160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
static Base_Class bases_dd7160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
extern VTBL_ENTRY _ZTV6dd7160[];
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__6dd7160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_dd7160[] = {
  {&(_ZTV6dd7160[4]),  4,15},
  {&(_ZTV6dd7160[9]),  9,15},
  {&(_ZTV6dd7160[13]),  13,15},
  {&(_tg__ZTV5cc160__6dd7160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__6dd7160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7160 = {  "dd7160", // class name
  bases_dd7160, 3,
  &(vtc_dd7160[0]), // expected_vtbl_contents
  &(vtt_dd7160[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd7160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7160),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07160  : dd7160 {
  int e;
  ~ee07160(); // tgen
  ee07160(); // tgen
};
//SIG(1 ee07160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee07160 ::~ee07160(){ note_dtor("ee07160", this);} // tgen
ee07160 ::ee07160(){ note_ctor("ee07160", this);} // tgen

static void Test_ee07160()
{
  extern Class_Descriptor cd_ee07160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee07160, buf);
    ee07160 *dp, &lv = *(dp=new (buf) ee07160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee07160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee07160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee07160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(16,12), "ee07160");
    check_base_class_offset(lv, (dd7160*), 0, "ee07160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07160.e");
    test_class_info(&lv, &cd_ee07160);
    dp->~ee07160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07160(Test_ee07160, "ee07160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee07160C1Ev();
extern void _ZN7ee07160D1Ev();
Name_Map name_map_ee07160[] = {
  NSPAIR(_ZN7ee07160C1Ev),
  NSPAIR(_ZN7ee07160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee07160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee07160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
extern VTBL_ENTRY _ZTV7ee07160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee07160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee07160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee07160[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee07160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee07160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee07160[] = {
  {&(_ZTV7ee07160[4]),  4,15},
  {&(_tg__ZTV6dd7160__7ee07160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee07160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee07160[4]),  4,6},
  {&(_ZTV7ee07160[9]),  9,15},
  {&(_ZTV7ee07160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee07160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee07160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee07160[];
extern  VTBL_ENTRY _ZTV7ee07160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07160[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07160 = {  "ee07160", // class name
  bases_ee07160, 4,
  &(vtc_ee07160[0]), // expected_vtbl_contents
  &(vtt_ee07160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee07160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17160  : virtual dd7160 {
  int e;
  ~ee17160(); // tgen
  ee17160(); // tgen
};
//SIG(1 ee17160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} Fi}


ee17160 ::~ee17160(){ note_dtor("ee17160", this);} // tgen
ee17160 ::ee17160(){ note_ctor("ee17160", this);} // tgen

static void Test_ee17160()
{
  extern Class_Descriptor cd_ee17160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee17160, buf);
    ee17160 *dp, &lv = *(dp=new (buf) ee17160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee17160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee17160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee17160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(32,16), "ee17160");
    check_base_class_offset(lv, (dd7160*), ABISELECT(16,8), "ee17160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17160.e");
    test_class_info(&lv, &cd_ee17160);
    dp->~ee17160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17160(Test_ee17160, "ee17160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee17160C1Ev();
extern void _ZN7ee17160D1Ev();
Name_Map name_map_ee17160[] = {
  NSPAIR(_ZN7ee17160C1Ev),
  NSPAIR(_ZN7ee17160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee17160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17160[0]),
  0,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17160[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee17160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
extern VTBL_ENTRY _ZTV7ee17160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee17160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee17160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee17160[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee17160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee17160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee17160[] = {
  {&(_ZTV7ee17160[5]),  5,22},
  {&(_ZTV7ee17160[11]),  11,22},
  {&(_ZTV7ee17160[16]),  16,22},
  {&(_ZTV7ee17160[20]),  20,22},
  {&(_tg__ZTV6dd7160__7ee17160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee17160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee17160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee17160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee17160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee17160[];
extern  VTBL_ENTRY _ZTV7ee17160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17160[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17160 = {  "ee17160", // class name
  bases_ee17160, 4,
  &(vtc_ee17160[0]), // expected_vtbl_contents
  &(vtt_ee17160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee17160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17160),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27160  : dd7160 {
  int e;
  virtual void  foo(); // _ZN7ee271603fooEv
  ~ee27160(); // tgen
  ee27160(); // tgen
};
//SIG(1 ee27160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27160 ::foo(){vfunc_called(this, "_ZN7ee271603fooEv");}
ee27160 ::~ee27160(){ note_dtor("ee27160", this);} // tgen
ee27160 ::ee27160(){ note_ctor("ee27160", this);} // tgen

static void Test_ee27160()
{
  extern Class_Descriptor cd_ee27160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee27160, buf);
    ee27160 *dp, &lv = *(dp=new (buf) ee27160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee27160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee27160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee27160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(16,12), "ee27160");
    check_base_class_offset(lv, (dd7160*), 0, "ee27160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27160.e");
    test_class_info(&lv, &cd_ee27160);
    dp->~ee27160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27160(Test_ee27160, "ee27160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee27160C1Ev();
extern void _ZN7ee27160D1Ev();
Name_Map name_map_ee27160[] = {
  NSPAIR(_ZN7ee27160C1Ev),
  NSPAIR(_ZN7ee27160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee27160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27160[];
extern void _ZN6dd71603barEv();
extern void _ZN7ee271603fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee271603fooEv,_ZTv0_n16_N7ee271603fooEv)();
extern void ABISELECT(_ZThn32_N7ee271603fooEv,_ZThn20_N7ee271603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN7ee271603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee27160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee271603fooEv,_ZTv0_n16_N7ee271603fooEv),
};
extern VTBL_ENTRY _ZTV7ee27160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee27160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee27160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee27160[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee27160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee27160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee27160[] = {
  {&(_ZTV7ee27160[4]),  4,15},
  {&(_tg__ZTV6dd7160__7ee27160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee27160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee27160[4]),  4,6},
  {&(_ZTV7ee27160[9]),  9,15},
  {&(_ZTV7ee27160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee27160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee27160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee27160[];
extern  VTBL_ENTRY _ZTV7ee27160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27160[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee271603fooEv,_ZTv0_n16_N7ee271603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee271603fooEv,_ZThn20_N7ee271603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27160 = {  "ee27160", // class name
  bases_ee27160, 4,
  &(vtc_ee27160[0]), // expected_vtbl_contents
  &(vtt_ee27160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee27160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37160  : virtual dd7160 {
  int e;
  virtual void  foo(); // _ZN7ee371603fooEv
  ~ee37160(); // tgen
  ee37160(); // tgen
};
//SIG(1 ee37160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37160 ::foo(){vfunc_called(this, "_ZN7ee371603fooEv");}
ee37160 ::~ee37160(){ note_dtor("ee37160", this);} // tgen
ee37160 ::ee37160(){ note_ctor("ee37160", this);} // tgen

static void Test_ee37160()
{
  extern Class_Descriptor cd_ee37160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee37160, buf);
    ee37160 *dp, &lv = *(dp=new (buf) ee37160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee37160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee37160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee37160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(32,16), "ee37160");
    check_base_class_offset(lv, (dd7160*), ABISELECT(16,8), "ee37160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37160.e");
    test_class_info(&lv, &cd_ee37160);
    dp->~ee37160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37160(Test_ee37160, "ee37160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee37160C1Ev();
extern void _ZN7ee37160D1Ev();
Name_Map name_map_ee37160[] = {
  NSPAIR(_ZN7ee37160C1Ev),
  NSPAIR(_ZN7ee37160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee37160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37160[];
extern void _ZN7ee371603fooEv();
extern void _ZN6dd71603barEv();
extern void ABISELECT(_ZTv0_n48_N7ee371603fooEv,_ZTv0_n24_N7ee371603fooEv)();
extern void ABISELECT(_ZThn16_N7ee371603fooEv,_ZThn8_N7ee371603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee371603fooEv,_ZTv0_n16_N7ee371603fooEv)();
extern void ABISELECT(_ZThn48_N7ee371603fooEv,_ZThn24_N7ee371603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37160[0]),
  (VTBL_ENTRY)&_ZN7ee371603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee371603fooEv,_ZTv0_n24_N7ee371603fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37160[0]),
  ABISELECT(-48,-24),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee37160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee371603fooEv,_ZTv0_n16_N7ee371603fooEv),
};
extern VTBL_ENTRY _ZTV7ee37160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee37160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee37160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee37160[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee37160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee37160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee37160[] = {
  {&(_ZTV7ee37160[5]),  5,23},
  {&(_ZTV7ee37160[12]),  12,23},
  {&(_ZTV7ee37160[17]),  17,23},
  {&(_ZTV7ee37160[21]),  21,23},
  {&(_tg__ZTV6dd7160__7ee37160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee37160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee37160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee37160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee37160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee37160[];
extern  VTBL_ENTRY _ZTV7ee37160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37160[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee371603fooEv,_ZTv0_n16_N7ee371603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee371603fooEv,_ZThn24_N7ee371603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee371603fooEv,_ZTv0_n24_N7ee371603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371603fooEv,_ZThn8_N7ee371603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37160 = {  "ee37160", // class name
  bases_ee37160, 4,
  &(vtc_ee37160[0]), // expected_vtbl_contents
  &(vtt_ee37160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee37160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37160),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47160  : dd7160 {
  int e;
  virtual void  bar(); // _ZN7ee471603barEv
  ~ee47160(); // tgen
  ee47160(); // tgen
};
//SIG(1 ee47160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47160 ::bar(){vfunc_called(this, "_ZN7ee471603barEv");}
ee47160 ::~ee47160(){ note_dtor("ee47160", this);} // tgen
ee47160 ::ee47160(){ note_ctor("ee47160", this);} // tgen

static void Test_ee47160()
{
  extern Class_Descriptor cd_ee47160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee47160, buf);
    ee47160 *dp, &lv = *(dp=new (buf) ee47160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee47160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee47160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee47160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(16,12), "ee47160");
    check_base_class_offset(lv, (dd7160*), 0, "ee47160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47160.e");
    test_class_info(&lv, &cd_ee47160);
    dp->~ee47160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47160(Test_ee47160, "ee47160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee47160C1Ev();
extern void _ZN7ee47160D1Ev();
Name_Map name_map_ee47160[] = {
  NSPAIR(_ZN7ee47160C1Ev),
  NSPAIR(_ZN7ee47160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee47160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47160[];
extern void _ZN7ee471603barEv();
extern void _ZN6dd71603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee471603barEv,_ZTv0_n12_N7ee471603barEv)();
extern void ABISELECT(_ZThn32_N7ee471603barEv,_ZThn20_N7ee471603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47160[0]),
  (VTBL_ENTRY)&_ZN7ee471603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee47160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee471603barEv,_ZTv0_n12_N7ee471603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
extern VTBL_ENTRY _ZTV7ee47160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee47160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee47160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee47160[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee47160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee47160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee47160[] = {
  {&(_ZTV7ee47160[4]),  4,15},
  {&(_tg__ZTV6dd7160__7ee47160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee47160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee47160[4]),  4,6},
  {&(_ZTV7ee47160[9]),  9,15},
  {&(_ZTV7ee47160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee47160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee47160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee47160[];
extern  VTBL_ENTRY _ZTV7ee47160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47160[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee471603barEv,_ZTv0_n12_N7ee471603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee471603barEv,_ZThn20_N7ee471603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47160 = {  "ee47160", // class name
  bases_ee47160, 4,
  &(vtc_ee47160[0]), // expected_vtbl_contents
  &(vtt_ee47160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee47160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names108,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57160  : virtual dd7160 {
  int e;
  virtual void  bar(); // _ZN7ee571603barEv
  ~ee57160(); // tgen
  ee57160(); // tgen
};
//SIG(1 ee57160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57160 ::bar(){vfunc_called(this, "_ZN7ee571603barEv");}
ee57160 ::~ee57160(){ note_dtor("ee57160", this);} // tgen
ee57160 ::ee57160(){ note_ctor("ee57160", this);} // tgen

static void Test_ee57160()
{
  extern Class_Descriptor cd_ee57160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee57160, buf);
    ee57160 *dp, &lv = *(dp=new (buf) ee57160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee57160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee57160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee57160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(32,16), "ee57160");
    check_base_class_offset(lv, (dd7160*), ABISELECT(16,8), "ee57160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57160.e");
    test_class_info(&lv, &cd_ee57160);
    dp->~ee57160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57160(Test_ee57160, "ee57160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee57160C1Ev();
extern void _ZN7ee57160D1Ev();
Name_Map name_map_ee57160[] = {
  NSPAIR(_ZN7ee57160C1Ev),
  NSPAIR(_ZN7ee57160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee57160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57160[];
extern void _ZN7ee571603barEv();
extern void ABISELECT(_ZTv0_n40_N7ee571603barEv,_ZTv0_n20_N7ee571603barEv)();
extern void ABISELECT(_ZThn16_N7ee571603barEv,_ZThn8_N7ee571603barEv)() __attribute__((weak));
extern void _ZN6dd71603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee571603barEv,_ZTv0_n12_N7ee571603barEv)();
extern void ABISELECT(_ZThn48_N7ee571603barEv,_ZThn24_N7ee571603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57160[0]),
  (VTBL_ENTRY)&_ZN7ee571603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee571603barEv,_ZTv0_n20_N7ee571603barEv),
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57160[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee57160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee571603barEv,_ZTv0_n12_N7ee571603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
extern VTBL_ENTRY _ZTV7ee57160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee57160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee57160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee57160[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee57160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee57160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee57160[] = {
  {&(_ZTV7ee57160[5]),  5,23},
  {&(_ZTV7ee57160[12]),  12,23},
  {&(_ZTV7ee57160[17]),  17,23},
  {&(_ZTV7ee57160[21]),  21,23},
  {&(_tg__ZTV6dd7160__7ee57160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee57160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee57160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee57160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee57160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee57160[];
extern  VTBL_ENTRY _ZTV7ee57160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57160[];
static VTBL_ENTRY alt_thunk_names109[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee571603barEv,_ZTv0_n12_N7ee571603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee571603barEv,_ZThn24_N7ee571603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee571603barEv,_ZTv0_n20_N7ee571603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571603barEv,_ZThn8_N7ee571603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57160 = {  "ee57160", // class name
  bases_ee57160, 4,
  &(vtc_ee57160[0]), // expected_vtbl_contents
  &(vtt_ee57160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee57160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57160),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names109,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67160  : dd7160 {
  int e;
  virtual void  foo(); // _ZN7ee671603fooEv
  virtual void  bar(); // _ZN7ee671603barEv
  ~ee67160(); // tgen
  ee67160(); // tgen
};
//SIG(1 ee67160) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67160 ::foo(){vfunc_called(this, "_ZN7ee671603fooEv");}
void  ee67160 ::bar(){vfunc_called(this, "_ZN7ee671603barEv");}
ee67160 ::~ee67160(){ note_dtor("ee67160", this);} // tgen
ee67160 ::ee67160(){ note_ctor("ee67160", this);} // tgen

static void Test_ee67160()
{
  extern Class_Descriptor cd_ee67160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee67160, buf);
    ee67160 *dp, &lv = *(dp=new (buf) ee67160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee67160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(40,24), "ee67160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(32,20), "ee67160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(16,12), "ee67160");
    check_base_class_offset(lv, (dd7160*), 0, "ee67160");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67160.e");
    test_class_info(&lv, &cd_ee67160);
    dp->~ee67160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67160(Test_ee67160, "ee67160", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee67160C1Ev();
extern void _ZN7ee67160D1Ev();
Name_Map name_map_ee67160[] = {
  NSPAIR(_ZN7ee67160C1Ev),
  NSPAIR(_ZN7ee67160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee67160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67160[];
extern void _ZN7ee671603barEv();
extern void _ZN7ee671603fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee671603barEv,_ZTv0_n12_N7ee671603barEv)();
extern void ABISELECT(_ZThn32_N7ee671603barEv,_ZThn20_N7ee671603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee671603fooEv,_ZTv0_n16_N7ee671603fooEv)();
extern void ABISELECT(_ZThn32_N7ee671603fooEv,_ZThn20_N7ee671603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67160[0]),
  (VTBL_ENTRY)&_ZN7ee671603barEv,
  (VTBL_ENTRY)&_ZN7ee671603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67160[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee67160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee671603barEv,_ZTv0_n12_N7ee671603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee671603fooEv,_ZTv0_n16_N7ee671603fooEv),
};
extern VTBL_ENTRY _ZTV7ee67160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee67160[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee67160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee67160[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee67160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee67160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee67160[] = {
  {&(_ZTV7ee67160[4]),  4,15},
  {&(_tg__ZTV6dd7160__7ee67160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee67160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee67160[4]),  4,6},
  {&(_ZTV7ee67160[9]),  9,15},
  {&(_ZTV7ee67160[13]),  13,15},
  {&(_tg__ZTV5cc160__7ee67160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee67160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee67160[];
extern  VTBL_ENTRY _ZTV7ee67160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67160[];
static VTBL_ENTRY alt_thunk_names110[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn20_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn20_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee671603fooEv,_ZTv0_n16_N7ee671603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671603fooEv,_ZThn20_N7ee671603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee671603barEv,_ZTv0_n12_N7ee671603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671603barEv,_ZThn20_N7ee671603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67160 = {  "ee67160", // class name
  bases_ee67160, 4,
  &(vtc_ee67160[0]), // expected_vtbl_contents
  &(vtt_ee67160[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee67160),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67160),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67160),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names110,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77160  : virtual dd7160 {
  int e;
  virtual void  foo(); // _ZN7ee771603fooEv
  virtual void  bar(); // _ZN7ee771603barEv
  ~ee77160(); // tgen
  ee77160(); // tgen
};
//SIG(1 ee77160) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77160 ::foo(){vfunc_called(this, "_ZN7ee771603fooEv");}
void  ee77160 ::bar(){vfunc_called(this, "_ZN7ee771603barEv");}
ee77160 ::~ee77160(){ note_dtor("ee77160", this);} // tgen
ee77160 ::ee77160(){ note_ctor("ee77160", this);} // tgen

static void Test_ee77160()
{
  extern Class_Descriptor cd_ee77160;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee77160, buf);
    ee77160 *dp, &lv = *(dp=new (buf) ee77160());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee77160)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77160)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(56,28), "ee77160");
    check_base_class_offset(lv, (bb60*)(cc160*), ABISELECT(48,24), "ee77160");
    check_base_class_offset(lv, (cc160*)(dd7160*), ABISELECT(32,16), "ee77160");
    check_base_class_offset(lv, (dd7160*), ABISELECT(16,8), "ee77160");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77160.e");
    test_class_info(&lv, &cd_ee77160);
    dp->~ee77160();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77160(Test_ee77160, "ee77160", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee77160C1Ev();
extern void _ZN7ee77160D1Ev();
Name_Map name_map_ee77160[] = {
  NSPAIR(_ZN7ee77160C1Ev),
  NSPAIR(_ZN7ee77160D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc160;
extern VTBL_ENTRY _ZTI5cc160[];
extern  VTBL_ENTRY _ZTV5cc160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc160[];
extern Class_Descriptor cd_dd7160;
extern VTBL_ENTRY _ZTI6dd7160[];
extern  VTBL_ENTRY _ZTV6dd7160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7160[];
static Base_Class bases_ee77160[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc160,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7160,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77160[];
extern void _ZN7ee771603fooEv();
extern void _ZN7ee771603barEv();
extern void ABISELECT(_ZTv0_n40_N7ee771603barEv,_ZTv0_n20_N7ee771603barEv)();
extern void ABISELECT(_ZThn16_N7ee771603barEv,_ZThn8_N7ee771603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee771603fooEv,_ZTv0_n24_N7ee771603fooEv)();
extern void ABISELECT(_ZThn16_N7ee771603fooEv,_ZThn8_N7ee771603fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee771603barEv,_ZTv0_n12_N7ee771603barEv)();
extern void ABISELECT(_ZThn48_N7ee771603barEv,_ZThn24_N7ee771603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee771603fooEv,_ZTv0_n16_N7ee771603fooEv)();
extern void ABISELECT(_ZThn48_N7ee771603fooEv,_ZThn24_N7ee771603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77160[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77160[0]),
  (VTBL_ENTRY)&_ZN7ee771603fooEv,
  (VTBL_ENTRY)&_ZN7ee771603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee771603barEv,_ZTv0_n20_N7ee771603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771603fooEv,_ZTv0_n24_N7ee771603fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77160[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee77160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee771603barEv,_ZTv0_n12_N7ee771603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee771603fooEv,_ZTv0_n16_N7ee771603fooEv),
};
extern VTBL_ENTRY _ZTV7ee77160[];
extern void _ZN6dd71603barEv();
extern void _ZN6dd71603fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7160__7ee77160[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&_ZN6dd71603barEv,
  (VTBL_ENTRY)&_ZN6dd71603fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc160__6dd7160__7ee77160[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv)();
extern void ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv)();
extern void ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb60__6dd7160__7ee77160[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7160[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc160__7ee77160[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN4bb603fooEv();
static  VTBL_ENTRY _tg__ZTV4bb60__5cc160__7ee77160[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc160[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN4bb603fooEv,
};
static  VTT_ENTRY vtt_ee77160[] = {
  {&(_ZTV7ee77160[5]),  5,24},
  {&(_ZTV7ee77160[13]),  13,24},
  {&(_ZTV7ee77160[18]),  18,24},
  {&(_ZTV7ee77160[22]),  22,24},
  {&(_tg__ZTV6dd7160__7ee77160[4]),  4,6},
  {&(_tg__ZTV5cc160__6dd7160__7ee77160[3]),  3,3},
  {&(_tg__ZTV4bb60__6dd7160__7ee77160[4]),  4,6},
  {&(_tg__ZTV5cc160__7ee77160[3]),  3,3},
  {&(_tg__ZTV4bb60__5cc160__7ee77160[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee77160[];
extern  VTBL_ENTRY _ZTV7ee77160[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77160[];
static VTBL_ENTRY alt_thunk_names111[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71603fooEv,_ZTv0_n16_N6dd71603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603fooEv,_ZThn16_N6dd71603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71603barEv,_ZTv0_n12_N6dd71603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71603barEv,_ZThn16_N6dd71603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee771603fooEv,_ZTv0_n16_N7ee771603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771603fooEv,_ZThn24_N7ee771603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee771603barEv,_ZTv0_n12_N7ee771603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771603barEv,_ZThn24_N7ee771603barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771603fooEv,_ZTv0_n24_N7ee771603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771603fooEv,_ZThn8_N7ee771603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee771603barEv,_ZTv0_n20_N7ee771603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771603barEv,_ZThn8_N7ee771603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77160 = {  "ee77160", // class name
  bases_ee77160, 4,
  &(vtc_ee77160[0]), // expected_vtbl_contents
  &(vtt_ee77160[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee77160),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77160),24, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77160),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names111,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc260  : bb60 {
  int c;
  virtual void  foo(); // _ZN5cc2603fooEv
  ~cc260(); // tgen
  cc260(); // tgen
};
//SIG(-1 cc260) C1{ BC2{ BC3{ Fi} v2 v1 Fi} v1 Fi}


void  cc260 ::foo(){vfunc_called(this, "_ZN5cc2603fooEv");}
cc260 ::~cc260(){ note_dtor("cc260", this);} // tgen
cc260 ::cc260(){ note_ctor("cc260", this);} // tgen

static void Test_cc260()
{
  extern Class_Descriptor cd_cc260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc260, buf);
    cc260 *dp, &lv = *(dp=new (buf) cc260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc260)");
    check_base_class_offset(lv, (aa0*)(bb60*), ABISELECT(8,4), "cc260");
    check_base_class_offset(lv, (bb60*), 0, "cc260");
    check_field_offset(lv, c, ABISELECT(16,12), "cc260.c");
    test_class_info(&lv, &cd_cc260);
    dp->~cc260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc260(Test_cc260, "cc260", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc260C1Ev();
extern void _ZN5cc260D1Ev();
Name_Map name_map_cc260[] = {
  NSPAIR(_ZN5cc260C1Ev),
  NSPAIR(_ZN5cc260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
static Base_Class bases_cc260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc260[];
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_cc260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5cc260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
Class_Descriptor cd_cc260 = {  "cc260", // class name
  bases_cc260, 2,
  &(vtc_cc260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0260  : cc260 {
  int d;
  ~dd0260(); // tgen
  dd0260(); // tgen
};
//SIG(-1 dd0260) C1{ BC2{ BC3{ BC4{ Fi} v2 v1 Fi} v1 Fi} Fi}


dd0260 ::~dd0260(){ note_dtor("dd0260", this);} // tgen
dd0260 ::dd0260(){ note_ctor("dd0260", this);} // tgen

static void Test_dd0260()
{
  extern Class_Descriptor cd_dd0260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0260, buf);
    dd0260 *dp, &lv = *(dp=new (buf) dd0260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(8,4), "dd0260");
    check_base_class_offset(lv, (bb60*)(cc260*), 0, "dd0260");
    check_base_class_offset(lv, (cc260*), 0, "dd0260");
    check_field_offset(lv, d, ABISELECT(20,16), "dd0260.d");
    test_class_info(&lv, &cd_dd0260);
    dp->~dd0260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0260(Test_dd0260, "dd0260", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0260C1Ev();
extern void _ZN6dd0260D1Ev();
Name_Map name_map_dd0260[] = {
  NSPAIR(_ZN6dd0260C1Ev),
  NSPAIR(_ZN6dd0260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
static Base_Class bases_dd0260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0260[];
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_dd0260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd0260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
Class_Descriptor cd_dd0260 = {  "dd0260", // class name
  bases_dd0260, 3,
  &(vtc_dd0260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00260  : dd0260 {
  int e;
  ~ee00260(); // tgen
  ee00260(); // tgen
};
//SIG(1 ee00260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} Fi}


ee00260 ::~ee00260(){ note_dtor("ee00260", this);} // tgen
ee00260 ::ee00260(){ note_ctor("ee00260", this);} // tgen

static void Test_ee00260()
{
  extern Class_Descriptor cd_ee00260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00260, buf);
    ee00260 *dp, &lv = *(dp=new (buf) ee00260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(8,4), "ee00260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), 0, "ee00260");
    check_base_class_offset(lv, (cc260*)(dd0260*), 0, "ee00260");
    check_base_class_offset(lv, (dd0260*), 0, "ee00260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee00260.e");
    test_class_info(&lv, &cd_ee00260);
    dp->~ee00260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00260(Test_ee00260, "ee00260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00260C1Ev();
extern void _ZN7ee00260D1Ev();
Name_Map name_map_ee00260[] = {
  NSPAIR(_ZN7ee00260C1Ev),
  NSPAIR(_ZN7ee00260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee00260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00260[];
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee00260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee00260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTI7ee00260[];
extern  VTBL_ENTRY _ZTV7ee00260[];
Class_Descriptor cd_ee00260 = {  "ee00260", // class name
  bases_ee00260, 4,
  &(vtc_ee00260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10260  : virtual dd0260 {
  int e;
  ~ee10260(); // tgen
  ee10260(); // tgen
};
//SIG(1 ee10260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} Fi}


ee10260 ::~ee10260(){ note_dtor("ee10260", this);} // tgen
ee10260 ::ee10260(){ note_ctor("ee10260", this);} // tgen

static void Test_ee10260()
{
  extern Class_Descriptor cd_ee10260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10260, buf);
    ee10260 *dp, &lv = *(dp=new (buf) ee10260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(24,12), "ee10260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), ABISELECT(16,8), "ee10260");
    check_base_class_offset(lv, (cc260*)(dd0260*), ABISELECT(16,8), "ee10260");
    check_base_class_offset(lv, (dd0260*), ABISELECT(16,8), "ee10260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10260.e");
    test_class_info(&lv, &cd_ee10260);
    dp->~ee10260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10260(Test_ee10260, "ee10260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10260C1Ev();
extern void _ZN7ee10260D1Ev();
Name_Map name_map_ee10260[] = {
  NSPAIR(_ZN7ee10260C1Ev),
  NSPAIR(_ZN7ee10260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee10260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10260[];
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee10260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10260[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTV7ee10260[];
static  VTT_ENTRY vtt_ee10260[] = {
  {&(_ZTV7ee10260[3]),  3,9},
  {&(_ZTV7ee10260[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee10260[];
extern  VTBL_ENTRY _ZTV7ee10260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10260[];
Class_Descriptor cd_ee10260 = {  "ee10260", // class name
  bases_ee10260, 4,
  &(vtc_ee10260[0]), // expected_vtbl_contents
  &(vtt_ee10260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10260),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20260  : dd0260 {
  int e;
  virtual void  foo(); // _ZN7ee202603fooEv
  ~ee20260(); // tgen
  ee20260(); // tgen
};
//SIG(1 ee20260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee20260 ::foo(){vfunc_called(this, "_ZN7ee202603fooEv");}
ee20260 ::~ee20260(){ note_dtor("ee20260", this);} // tgen
ee20260 ::ee20260(){ note_ctor("ee20260", this);} // tgen

static void Test_ee20260()
{
  extern Class_Descriptor cd_ee20260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20260, buf);
    ee20260 *dp, &lv = *(dp=new (buf) ee20260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(8,4), "ee20260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), 0, "ee20260");
    check_base_class_offset(lv, (cc260*)(dd0260*), 0, "ee20260");
    check_base_class_offset(lv, (dd0260*), 0, "ee20260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20260.e");
    test_class_info(&lv, &cd_ee20260);
    dp->~ee20260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20260(Test_ee20260, "ee20260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20260C1Ev();
extern void _ZN7ee20260D1Ev();
Name_Map name_map_ee20260[] = {
  NSPAIR(_ZN7ee20260C1Ev),
  NSPAIR(_ZN7ee20260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee20260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20260[];
extern void _ZN4bb603barEv();
extern void _ZN7ee202603fooEv();
static  VTBL_ENTRY vtc_ee20260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN7ee202603fooEv,
};
extern VTBL_ENTRY _ZTI7ee20260[];
extern  VTBL_ENTRY _ZTV7ee20260[];
Class_Descriptor cd_ee20260 = {  "ee20260", // class name
  bases_ee20260, 4,
  &(vtc_ee20260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30260  : virtual dd0260 {
  int e;
  virtual void  foo(); // _ZN7ee302603fooEv
  ~ee30260(); // tgen
  ee30260(); // tgen
};
//SIG(1 ee30260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee30260 ::foo(){vfunc_called(this, "_ZN7ee302603fooEv");}
ee30260 ::~ee30260(){ note_dtor("ee30260", this);} // tgen
ee30260 ::ee30260(){ note_ctor("ee30260", this);} // tgen

static void Test_ee30260()
{
  extern Class_Descriptor cd_ee30260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30260, buf);
    ee30260 *dp, &lv = *(dp=new (buf) ee30260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(24,12), "ee30260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), ABISELECT(16,8), "ee30260");
    check_base_class_offset(lv, (cc260*)(dd0260*), ABISELECT(16,8), "ee30260");
    check_base_class_offset(lv, (dd0260*), ABISELECT(16,8), "ee30260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30260.e");
    test_class_info(&lv, &cd_ee30260);
    dp->~ee30260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30260(Test_ee30260, "ee30260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30260C1Ev();
extern void _ZN7ee30260D1Ev();
Name_Map name_map_ee30260[] = {
  NSPAIR(_ZN7ee30260C1Ev),
  NSPAIR(_ZN7ee30260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee30260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30260[];
extern void _ZN7ee302603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee302603fooEv,_ZTv0_n16_N7ee302603fooEv)();
extern void ABISELECT(_ZThn16_N7ee302603fooEv,_ZThn8_N7ee302603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30260[0]),
  (VTBL_ENTRY)&_ZN7ee302603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee302603fooEv,_ZTv0_n16_N7ee302603fooEv),
};
extern VTBL_ENTRY _ZTV7ee30260[];
static  VTT_ENTRY vtt_ee30260[] = {
  {&(_ZTV7ee30260[3]),  3,10},
  {&(_ZTV7ee30260[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee30260[];
extern  VTBL_ENTRY _ZTV7ee30260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30260[];
static VTBL_ENTRY alt_thunk_names112[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee302603fooEv,_ZTv0_n16_N7ee302603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302603fooEv,_ZThn8_N7ee302603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30260 = {  "ee30260", // class name
  bases_ee30260, 4,
  &(vtc_ee30260[0]), // expected_vtbl_contents
  &(vtt_ee30260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30260),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names112,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40260  : dd0260 {
  int e;
  virtual void  bar(); // _ZN7ee402603barEv
  ~ee40260(); // tgen
  ee40260(); // tgen
};
//SIG(1 ee40260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee40260 ::bar(){vfunc_called(this, "_ZN7ee402603barEv");}
ee40260 ::~ee40260(){ note_dtor("ee40260", this);} // tgen
ee40260 ::ee40260(){ note_ctor("ee40260", this);} // tgen

static void Test_ee40260()
{
  extern Class_Descriptor cd_ee40260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40260, buf);
    ee40260 *dp, &lv = *(dp=new (buf) ee40260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(8,4), "ee40260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), 0, "ee40260");
    check_base_class_offset(lv, (cc260*)(dd0260*), 0, "ee40260");
    check_base_class_offset(lv, (dd0260*), 0, "ee40260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40260.e");
    test_class_info(&lv, &cd_ee40260);
    dp->~ee40260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40260(Test_ee40260, "ee40260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40260C1Ev();
extern void _ZN7ee40260D1Ev();
Name_Map name_map_ee40260[] = {
  NSPAIR(_ZN7ee40260C1Ev),
  NSPAIR(_ZN7ee40260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee40260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40260[];
extern void _ZN7ee402603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee40260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40260[0]),
  (VTBL_ENTRY)&_ZN7ee402603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTI7ee40260[];
extern  VTBL_ENTRY _ZTV7ee40260[];
Class_Descriptor cd_ee40260 = {  "ee40260", // class name
  bases_ee40260, 4,
  &(vtc_ee40260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50260  : virtual dd0260 {
  int e;
  virtual void  bar(); // _ZN7ee502603barEv
  ~ee50260(); // tgen
  ee50260(); // tgen
};
//SIG(1 ee50260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee50260 ::bar(){vfunc_called(this, "_ZN7ee502603barEv");}
ee50260 ::~ee50260(){ note_dtor("ee50260", this);} // tgen
ee50260 ::ee50260(){ note_ctor("ee50260", this);} // tgen

static void Test_ee50260()
{
  extern Class_Descriptor cd_ee50260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50260, buf);
    ee50260 *dp, &lv = *(dp=new (buf) ee50260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(24,12), "ee50260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), ABISELECT(16,8), "ee50260");
    check_base_class_offset(lv, (cc260*)(dd0260*), ABISELECT(16,8), "ee50260");
    check_base_class_offset(lv, (dd0260*), ABISELECT(16,8), "ee50260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50260.e");
    test_class_info(&lv, &cd_ee50260);
    dp->~ee50260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50260(Test_ee50260, "ee50260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50260C1Ev();
extern void _ZN7ee50260D1Ev();
Name_Map name_map_ee50260[] = {
  NSPAIR(_ZN7ee50260C1Ev),
  NSPAIR(_ZN7ee50260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee50260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50260[];
extern void _ZN7ee502603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee502603barEv,_ZTv0_n12_N7ee502603barEv)();
extern void ABISELECT(_ZThn16_N7ee502603barEv,_ZThn8_N7ee502603barEv)() __attribute__((weak));
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee50260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50260[0]),
  (VTBL_ENTRY)&_ZN7ee502603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee502603barEv,_ZTv0_n12_N7ee502603barEv),
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTV7ee50260[];
static  VTT_ENTRY vtt_ee50260[] = {
  {&(_ZTV7ee50260[3]),  3,10},
  {&(_ZTV7ee50260[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee50260[];
extern  VTBL_ENTRY _ZTV7ee50260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50260[];
static VTBL_ENTRY alt_thunk_names113[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee502603barEv,_ZTv0_n12_N7ee502603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee502603barEv,_ZThn8_N7ee502603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50260 = {  "ee50260", // class name
  bases_ee50260, 4,
  &(vtc_ee50260[0]), // expected_vtbl_contents
  &(vtt_ee50260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50260),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names113,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60260  : dd0260 {
  int e;
  virtual void  foo(); // _ZN7ee602603fooEv
  virtual void  bar(); // _ZN7ee602603barEv
  ~ee60260(); // tgen
  ee60260(); // tgen
};
//SIG(1 ee60260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee60260 ::foo(){vfunc_called(this, "_ZN7ee602603fooEv");}
void  ee60260 ::bar(){vfunc_called(this, "_ZN7ee602603barEv");}
ee60260 ::~ee60260(){ note_dtor("ee60260", this);} // tgen
ee60260 ::ee60260(){ note_ctor("ee60260", this);} // tgen

static void Test_ee60260()
{
  extern Class_Descriptor cd_ee60260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60260, buf);
    ee60260 *dp, &lv = *(dp=new (buf) ee60260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(8,4), "ee60260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), 0, "ee60260");
    check_base_class_offset(lv, (cc260*)(dd0260*), 0, "ee60260");
    check_base_class_offset(lv, (dd0260*), 0, "ee60260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60260.e");
    test_class_info(&lv, &cd_ee60260);
    dp->~ee60260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60260(Test_ee60260, "ee60260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60260C1Ev();
extern void _ZN7ee60260D1Ev();
Name_Map name_map_ee60260[] = {
  NSPAIR(_ZN7ee60260C1Ev),
  NSPAIR(_ZN7ee60260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee60260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60260[];
extern void _ZN7ee602603barEv();
extern void _ZN7ee602603fooEv();
static  VTBL_ENTRY vtc_ee60260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60260[0]),
  (VTBL_ENTRY)&_ZN7ee602603barEv,
  (VTBL_ENTRY)&_ZN7ee602603fooEv,
};
extern VTBL_ENTRY _ZTI7ee60260[];
extern  VTBL_ENTRY _ZTV7ee60260[];
Class_Descriptor cd_ee60260 = {  "ee60260", // class name
  bases_ee60260, 4,
  &(vtc_ee60260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70260  : virtual dd0260 {
  int e;
  virtual void  foo(); // _ZN7ee702603fooEv
  virtual void  bar(); // _ZN7ee702603barEv
  ~ee70260(); // tgen
  ee70260(); // tgen
};
//SIG(1 ee70260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee70260 ::foo(){vfunc_called(this, "_ZN7ee702603fooEv");}
void  ee70260 ::bar(){vfunc_called(this, "_ZN7ee702603barEv");}
ee70260 ::~ee70260(){ note_dtor("ee70260", this);} // tgen
ee70260 ::ee70260(){ note_ctor("ee70260", this);} // tgen

static void Test_ee70260()
{
  extern Class_Descriptor cd_ee70260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70260, buf);
    ee70260 *dp, &lv = *(dp=new (buf) ee70260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd0260*), ABISELECT(24,12), "ee70260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd0260*), ABISELECT(16,8), "ee70260");
    check_base_class_offset(lv, (cc260*)(dd0260*), ABISELECT(16,8), "ee70260");
    check_base_class_offset(lv, (dd0260*), ABISELECT(16,8), "ee70260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70260.e");
    test_class_info(&lv, &cd_ee70260);
    dp->~ee70260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70260(Test_ee70260, "ee70260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70260C1Ev();
extern void _ZN7ee70260D1Ev();
Name_Map name_map_ee70260[] = {
  NSPAIR(_ZN7ee70260C1Ev),
  NSPAIR(_ZN7ee70260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd0260;
extern VTBL_ENTRY _ZTI6dd0260[];
extern  VTBL_ENTRY _ZTV6dd0260[];
static Base_Class bases_ee70260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70260[];
extern void _ZN7ee702603fooEv();
extern void _ZN7ee702603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee702603barEv,_ZTv0_n12_N7ee702603barEv)();
extern void ABISELECT(_ZThn16_N7ee702603barEv,_ZThn8_N7ee702603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee702603fooEv,_ZTv0_n16_N7ee702603fooEv)();
extern void ABISELECT(_ZThn16_N7ee702603fooEv,_ZThn8_N7ee702603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70260[0]),
  (VTBL_ENTRY)&_ZN7ee702603fooEv,
  (VTBL_ENTRY)&_ZN7ee702603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee702603barEv,_ZTv0_n12_N7ee702603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee702603fooEv,_ZTv0_n16_N7ee702603fooEv),
};
extern VTBL_ENTRY _ZTV7ee70260[];
static  VTT_ENTRY vtt_ee70260[] = {
  {&(_ZTV7ee70260[3]),  3,11},
  {&(_ZTV7ee70260[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee70260[];
extern  VTBL_ENTRY _ZTV7ee70260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70260[];
static VTBL_ENTRY alt_thunk_names114[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee702603fooEv,_ZTv0_n16_N7ee702603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702603fooEv,_ZThn8_N7ee702603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee702603barEv,_ZTv0_n12_N7ee702603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702603barEv,_ZThn8_N7ee702603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70260 = {  "ee70260", // class name
  bases_ee70260, 4,
  &(vtc_ee70260[0]), // expected_vtbl_contents
  &(vtt_ee70260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70260),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names114,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1260  : virtual cc260 {
  int d;
  ~dd1260(); // tgen
  dd1260(); // tgen
};
//SIG(-1 dd1260) C1{ VBC2{ BC3{ BC4{ Fi} v2 v1 Fi} v1 Fi} Fi}


dd1260 ::~dd1260(){ note_dtor("dd1260", this);} // tgen
dd1260 ::dd1260(){ note_ctor("dd1260", this);} // tgen

static void Test_dd1260()
{
  extern Class_Descriptor cd_dd1260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1260, buf);
    dd1260 *dp, &lv = *(dp=new (buf) dd1260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(24,12), "dd1260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(16,8), "dd1260");
    check_base_class_offset(lv, (cc260*), ABISELECT(16,8), "dd1260");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1260.d");
    test_class_info(&lv, &cd_dd1260);
    dp->~dd1260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1260(Test_dd1260, "dd1260", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1260C1Ev();
extern void _ZN6dd1260D1Ev();
Name_Map name_map_dd1260[] = {
  NSPAIR(_ZN6dd1260C1Ev),
  NSPAIR(_ZN6dd1260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
static Base_Class bases_dd1260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1260[];
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_dd1260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTV6dd1260[];
static  VTT_ENTRY vtt_dd1260[] = {
  {&(_ZTV6dd1260[3]),  3,9},
  {&(_ZTV6dd1260[7]),  7,9},
};
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
Class_Descriptor cd_dd1260 = {  "dd1260", // class name
  bases_dd1260, 3,
  &(vtc_dd1260[0]), // expected_vtbl_contents
  &(vtt_dd1260[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1260),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1260),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01260  : dd1260 {
  int e;
  ~ee01260(); // tgen
  ee01260(); // tgen
};
//SIG(1 ee01260) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} Fi}


ee01260 ::~ee01260(){ note_dtor("ee01260", this);} // tgen
ee01260 ::ee01260(){ note_ctor("ee01260", this);} // tgen

static void Test_ee01260()
{
  extern Class_Descriptor cd_ee01260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01260, buf);
    ee01260 *dp, &lv = *(dp=new (buf) ee01260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(24,16), "ee01260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(16,12), "ee01260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(16,12), "ee01260");
    check_base_class_offset(lv, (dd1260*), 0, "ee01260");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01260.e");
    test_class_info(&lv, &cd_ee01260);
    dp->~ee01260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01260(Test_ee01260, "ee01260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01260C1Ev();
extern void _ZN7ee01260D1Ev();
Name_Map name_map_ee01260[] = {
  NSPAIR(_ZN7ee01260C1Ev),
  NSPAIR(_ZN7ee01260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee01260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01260[];
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee01260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01260[0]),
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTV7ee01260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee01260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee01260[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee01260[] = {
  {&(_ZTV7ee01260[3]),  3,9},
  {&(_tg__ZTV6dd1260__7ee01260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee01260[4]),  4,6},
  {&(_ZTV7ee01260[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee01260[];
extern  VTBL_ENTRY _ZTV7ee01260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01260[];
Class_Descriptor cd_ee01260 = {  "ee01260", // class name
  bases_ee01260, 4,
  &(vtc_ee01260[0]), // expected_vtbl_contents
  &(vtt_ee01260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01260),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01260),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11260  : virtual dd1260 {
  int e;
  ~ee11260(); // tgen
  ee11260(); // tgen
};
//SIG(1 ee11260) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} Fi}


ee11260 ::~ee11260(){ note_dtor("ee11260", this);} // tgen
ee11260 ::ee11260(){ note_ctor("ee11260", this);} // tgen

static void Test_ee11260()
{
  extern Class_Descriptor cd_ee11260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11260, buf);
    ee11260 *dp, &lv = *(dp=new (buf) ee11260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(40,20), "ee11260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(32,16), "ee11260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(32,16), "ee11260");
    check_base_class_offset(lv, (dd1260*), ABISELECT(16,8), "ee11260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11260.e");
    test_class_info(&lv, &cd_ee11260);
    dp->~ee11260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11260(Test_ee11260, "ee11260", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11260C1Ev();
extern void _ZN7ee11260D1Ev();
Name_Map name_map_ee11260[] = {
  NSPAIR(_ZN7ee11260C1Ev),
  NSPAIR(_ZN7ee11260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee11260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11260[];
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee11260[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11260[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11260[0]),
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTV7ee11260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee11260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee11260[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee11260[] = {
  {&(_ZTV7ee11260[4]),  4,13},
  {&(_ZTV7ee11260[7]),  7,13},
  {&(_ZTV7ee11260[11]),  11,13},
  {&(_tg__ZTV6dd1260__7ee11260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee11260[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee11260[];
extern  VTBL_ENTRY _ZTV7ee11260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11260[];
Class_Descriptor cd_ee11260 = {  "ee11260", // class name
  bases_ee11260, 4,
  &(vtc_ee11260[0]), // expected_vtbl_contents
  &(vtt_ee11260[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11260),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11260),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21260  : dd1260 {
  int e;
  virtual void  foo(); // _ZN7ee212603fooEv
  ~ee21260(); // tgen
  ee21260(); // tgen
};
//SIG(1 ee21260) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee21260 ::foo(){vfunc_called(this, "_ZN7ee212603fooEv");}
ee21260 ::~ee21260(){ note_dtor("ee21260", this);} // tgen
ee21260 ::ee21260(){ note_ctor("ee21260", this);} // tgen

static void Test_ee21260()
{
  extern Class_Descriptor cd_ee21260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21260, buf);
    ee21260 *dp, &lv = *(dp=new (buf) ee21260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(24,16), "ee21260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(16,12), "ee21260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(16,12), "ee21260");
    check_base_class_offset(lv, (dd1260*), 0, "ee21260");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21260.e");
    test_class_info(&lv, &cd_ee21260);
    dp->~ee21260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21260(Test_ee21260, "ee21260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21260C1Ev();
extern void _ZN7ee21260D1Ev();
Name_Map name_map_ee21260[] = {
  NSPAIR(_ZN7ee21260C1Ev),
  NSPAIR(_ZN7ee21260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee21260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21260[];
extern void _ZN7ee212603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee212603fooEv,_ZTv0_n16_N7ee212603fooEv)();
extern void ABISELECT(_ZThn16_N7ee212603fooEv,_ZThn12_N7ee212603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21260[0]),
  (VTBL_ENTRY)&_ZN7ee212603fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee212603fooEv,_ZTv0_n16_N7ee212603fooEv),
};
extern VTBL_ENTRY _ZTV7ee21260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee21260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee21260[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee21260[] = {
  {&(_ZTV7ee21260[3]),  3,10},
  {&(_tg__ZTV6dd1260__7ee21260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee21260[4]),  4,6},
  {&(_ZTV7ee21260[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee21260[];
extern  VTBL_ENTRY _ZTV7ee21260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21260[];
static VTBL_ENTRY alt_thunk_names115[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee212603fooEv,_ZTv0_n16_N7ee212603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee212603fooEv,_ZThn12_N7ee212603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21260 = {  "ee21260", // class name
  bases_ee21260, 4,
  &(vtc_ee21260[0]), // expected_vtbl_contents
  &(vtt_ee21260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21260),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21260),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names115,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31260  : virtual dd1260 {
  int e;
  virtual void  foo(); // _ZN7ee312603fooEv
  ~ee31260(); // tgen
  ee31260(); // tgen
};
//SIG(1 ee31260) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee31260 ::foo(){vfunc_called(this, "_ZN7ee312603fooEv");}
ee31260 ::~ee31260(){ note_dtor("ee31260", this);} // tgen
ee31260 ::ee31260(){ note_ctor("ee31260", this);} // tgen

static void Test_ee31260()
{
  extern Class_Descriptor cd_ee31260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31260, buf);
    ee31260 *dp, &lv = *(dp=new (buf) ee31260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(40,20), "ee31260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(32,16), "ee31260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(32,16), "ee31260");
    check_base_class_offset(lv, (dd1260*), ABISELECT(16,8), "ee31260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31260.e");
    test_class_info(&lv, &cd_ee31260);
    dp->~ee31260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31260(Test_ee31260, "ee31260", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31260C1Ev();
extern void _ZN7ee31260D1Ev();
Name_Map name_map_ee31260[] = {
  NSPAIR(_ZN7ee31260C1Ev),
  NSPAIR(_ZN7ee31260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee31260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31260[];
extern void _ZN7ee312603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee312603fooEv,_ZTv0_n16_N7ee312603fooEv)();
extern void ABISELECT(_ZThn32_N7ee312603fooEv,_ZThn16_N7ee312603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31260[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31260[0]),
  (VTBL_ENTRY)&_ZN7ee312603fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31260[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee312603fooEv,_ZTv0_n16_N7ee312603fooEv),
};
extern VTBL_ENTRY _ZTV7ee31260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee31260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee31260[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee31260[] = {
  {&(_ZTV7ee31260[4]),  4,14},
  {&(_ZTV7ee31260[8]),  8,14},
  {&(_ZTV7ee31260[12]),  12,14},
  {&(_tg__ZTV6dd1260__7ee31260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee31260[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee31260[];
extern  VTBL_ENTRY _ZTV7ee31260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31260[];
static VTBL_ENTRY alt_thunk_names116[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee312603fooEv,_ZTv0_n16_N7ee312603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee312603fooEv,_ZThn16_N7ee312603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31260 = {  "ee31260", // class name
  bases_ee31260, 4,
  &(vtc_ee31260[0]), // expected_vtbl_contents
  &(vtt_ee31260[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31260),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31260),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names116,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41260  : dd1260 {
  int e;
  virtual void  bar(); // _ZN7ee412603barEv
  ~ee41260(); // tgen
  ee41260(); // tgen
};
//SIG(1 ee41260) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee41260 ::bar(){vfunc_called(this, "_ZN7ee412603barEv");}
ee41260 ::~ee41260(){ note_dtor("ee41260", this);} // tgen
ee41260 ::ee41260(){ note_ctor("ee41260", this);} // tgen

static void Test_ee41260()
{
  extern Class_Descriptor cd_ee41260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41260, buf);
    ee41260 *dp, &lv = *(dp=new (buf) ee41260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(24,16), "ee41260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(16,12), "ee41260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(16,12), "ee41260");
    check_base_class_offset(lv, (dd1260*), 0, "ee41260");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41260.e");
    test_class_info(&lv, &cd_ee41260);
    dp->~ee41260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41260(Test_ee41260, "ee41260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41260C1Ev();
extern void _ZN7ee41260D1Ev();
Name_Map name_map_ee41260[] = {
  NSPAIR(_ZN7ee41260C1Ev),
  NSPAIR(_ZN7ee41260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee41260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41260[];
extern void _ZN7ee412603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee412603barEv,_ZTv0_n12_N7ee412603barEv)();
extern void ABISELECT(_ZThn16_N7ee412603barEv,_ZThn12_N7ee412603barEv)() __attribute__((weak));
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee41260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41260[0]),
  (VTBL_ENTRY)&_ZN7ee412603barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee412603barEv,_ZTv0_n12_N7ee412603barEv),
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTV7ee41260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee41260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee41260[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee41260[] = {
  {&(_ZTV7ee41260[3]),  3,10},
  {&(_tg__ZTV6dd1260__7ee41260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee41260[4]),  4,6},
  {&(_ZTV7ee41260[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee41260[];
extern  VTBL_ENTRY _ZTV7ee41260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41260[];
static VTBL_ENTRY alt_thunk_names117[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee412603barEv,_ZTv0_n12_N7ee412603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee412603barEv,_ZThn12_N7ee412603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41260 = {  "ee41260", // class name
  bases_ee41260, 4,
  &(vtc_ee41260[0]), // expected_vtbl_contents
  &(vtt_ee41260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41260),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41260),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names117,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51260  : virtual dd1260 {
  int e;
  virtual void  bar(); // _ZN7ee512603barEv
  ~ee51260(); // tgen
  ee51260(); // tgen
};
//SIG(1 ee51260) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee51260 ::bar(){vfunc_called(this, "_ZN7ee512603barEv");}
ee51260 ::~ee51260(){ note_dtor("ee51260", this);} // tgen
ee51260 ::ee51260(){ note_ctor("ee51260", this);} // tgen

static void Test_ee51260()
{
  extern Class_Descriptor cd_ee51260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51260, buf);
    ee51260 *dp, &lv = *(dp=new (buf) ee51260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(40,20), "ee51260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(32,16), "ee51260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(32,16), "ee51260");
    check_base_class_offset(lv, (dd1260*), ABISELECT(16,8), "ee51260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51260.e");
    test_class_info(&lv, &cd_ee51260);
    dp->~ee51260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51260(Test_ee51260, "ee51260", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51260C1Ev();
extern void _ZN7ee51260D1Ev();
Name_Map name_map_ee51260[] = {
  NSPAIR(_ZN7ee51260C1Ev),
  NSPAIR(_ZN7ee51260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee51260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51260[];
extern void _ZN7ee512603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee512603barEv,_ZTv0_n12_N7ee512603barEv)();
extern void ABISELECT(_ZThn32_N7ee512603barEv,_ZThn16_N7ee512603barEv)() __attribute__((weak));
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY vtc_ee51260[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51260[0]),
  (VTBL_ENTRY)&_ZN7ee512603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51260[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee512603barEv,_ZTv0_n12_N7ee512603barEv),
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
extern VTBL_ENTRY _ZTV7ee51260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee51260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee51260[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee51260[] = {
  {&(_ZTV7ee51260[4]),  4,14},
  {&(_ZTV7ee51260[8]),  8,14},
  {&(_ZTV7ee51260[12]),  12,14},
  {&(_tg__ZTV6dd1260__7ee51260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee51260[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee51260[];
extern  VTBL_ENTRY _ZTV7ee51260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51260[];
static VTBL_ENTRY alt_thunk_names118[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee512603barEv,_ZTv0_n12_N7ee512603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee512603barEv,_ZThn16_N7ee512603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51260 = {  "ee51260", // class name
  bases_ee51260, 4,
  &(vtc_ee51260[0]), // expected_vtbl_contents
  &(vtt_ee51260[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51260),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51260),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names118,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61260  : dd1260 {
  int e;
  virtual void  foo(); // _ZN7ee612603fooEv
  virtual void  bar(); // _ZN7ee612603barEv
  ~ee61260(); // tgen
  ee61260(); // tgen
};
//SIG(1 ee61260) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee61260 ::foo(){vfunc_called(this, "_ZN7ee612603fooEv");}
void  ee61260 ::bar(){vfunc_called(this, "_ZN7ee612603barEv");}
ee61260 ::~ee61260(){ note_dtor("ee61260", this);} // tgen
ee61260 ::ee61260(){ note_ctor("ee61260", this);} // tgen

static void Test_ee61260()
{
  extern Class_Descriptor cd_ee61260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61260, buf);
    ee61260 *dp, &lv = *(dp=new (buf) ee61260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(24,16), "ee61260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(16,12), "ee61260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(16,12), "ee61260");
    check_base_class_offset(lv, (dd1260*), 0, "ee61260");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61260.e");
    test_class_info(&lv, &cd_ee61260);
    dp->~ee61260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61260(Test_ee61260, "ee61260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61260C1Ev();
extern void _ZN7ee61260D1Ev();
Name_Map name_map_ee61260[] = {
  NSPAIR(_ZN7ee61260C1Ev),
  NSPAIR(_ZN7ee61260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee61260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61260[];
extern void _ZN7ee612603fooEv();
extern void _ZN7ee612603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee612603barEv,_ZTv0_n12_N7ee612603barEv)();
extern void ABISELECT(_ZThn16_N7ee612603barEv,_ZThn12_N7ee612603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee612603fooEv,_ZTv0_n16_N7ee612603fooEv)();
extern void ABISELECT(_ZThn16_N7ee612603fooEv,_ZThn12_N7ee612603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61260[0]),
  (VTBL_ENTRY)&_ZN7ee612603fooEv,
  (VTBL_ENTRY)&_ZN7ee612603barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee612603barEv,_ZTv0_n12_N7ee612603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee612603fooEv,_ZTv0_n16_N7ee612603fooEv),
};
extern VTBL_ENTRY _ZTV7ee61260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee61260[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee61260[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee61260[] = {
  {&(_ZTV7ee61260[3]),  3,11},
  {&(_tg__ZTV6dd1260__7ee61260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee61260[4]),  4,6},
  {&(_ZTV7ee61260[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee61260[];
extern  VTBL_ENTRY _ZTV7ee61260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61260[];
static VTBL_ENTRY alt_thunk_names119[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee612603fooEv,_ZTv0_n16_N7ee612603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612603fooEv,_ZThn12_N7ee612603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee612603barEv,_ZTv0_n12_N7ee612603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612603barEv,_ZThn12_N7ee612603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61260 = {  "ee61260", // class name
  bases_ee61260, 4,
  &(vtc_ee61260[0]), // expected_vtbl_contents
  &(vtt_ee61260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61260),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61260),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names119,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71260  : virtual dd1260 {
  int e;
  virtual void  foo(); // _ZN7ee712603fooEv
  virtual void  bar(); // _ZN7ee712603barEv
  ~ee71260(); // tgen
  ee71260(); // tgen
};
//SIG(1 ee71260) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee71260 ::foo(){vfunc_called(this, "_ZN7ee712603fooEv");}
void  ee71260 ::bar(){vfunc_called(this, "_ZN7ee712603barEv");}
ee71260 ::~ee71260(){ note_dtor("ee71260", this);} // tgen
ee71260 ::ee71260(){ note_ctor("ee71260", this);} // tgen

static void Test_ee71260()
{
  extern Class_Descriptor cd_ee71260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71260, buf);
    ee71260 *dp, &lv = *(dp=new (buf) ee71260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(40,20), "ee71260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(32,16), "ee71260");
    check_base_class_offset(lv, (cc260*)(dd1260*), ABISELECT(32,16), "ee71260");
    check_base_class_offset(lv, (dd1260*), ABISELECT(16,8), "ee71260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71260.e");
    test_class_info(&lv, &cd_ee71260);
    dp->~ee71260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71260(Test_ee71260, "ee71260", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71260C1Ev();
extern void _ZN7ee71260D1Ev();
Name_Map name_map_ee71260[] = {
  NSPAIR(_ZN7ee71260C1Ev),
  NSPAIR(_ZN7ee71260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd1260;
extern VTBL_ENTRY _ZTI6dd1260[];
extern  VTBL_ENTRY _ZTV6dd1260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1260[];
static Base_Class bases_ee71260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1260,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71260[];
extern void _ZN7ee712603fooEv();
extern void _ZN7ee712603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee712603barEv,_ZTv0_n12_N7ee712603barEv)();
extern void ABISELECT(_ZThn32_N7ee712603barEv,_ZThn16_N7ee712603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee712603fooEv,_ZTv0_n16_N7ee712603fooEv)();
extern void ABISELECT(_ZThn32_N7ee712603fooEv,_ZThn16_N7ee712603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71260[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71260[0]),
  (VTBL_ENTRY)&_ZN7ee712603fooEv,
  (VTBL_ENTRY)&_ZN7ee712603barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71260[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee712603barEv,_ZTv0_n12_N7ee712603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee712603fooEv,_ZTv0_n16_N7ee712603fooEv),
};
extern VTBL_ENTRY _ZTV7ee71260[];
static  VTBL_ENTRY _tg__ZTV6dd1260__7ee71260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
};
extern void _ZN4bb603barEv();
extern void _ZN5cc2603fooEv();
static  VTBL_ENTRY _tg__ZTV5cc260__6dd1260__7ee71260[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN5cc2603fooEv,
};
static  VTT_ENTRY vtt_ee71260[] = {
  {&(_ZTV7ee71260[4]),  4,15},
  {&(_ZTV7ee71260[9]),  9,15},
  {&(_ZTV7ee71260[13]),  13,15},
  {&(_tg__ZTV6dd1260__7ee71260[3]),  3,3},
  {&(_tg__ZTV5cc260__6dd1260__7ee71260[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee71260[];
extern  VTBL_ENTRY _ZTV7ee71260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71260[];
static VTBL_ENTRY alt_thunk_names120[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee712603fooEv,_ZTv0_n16_N7ee712603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712603fooEv,_ZThn16_N7ee712603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee712603barEv,_ZTv0_n12_N7ee712603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712603barEv,_ZThn16_N7ee712603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71260 = {  "ee71260", // class name
  bases_ee71260, 4,
  &(vtc_ee71260[0]), // expected_vtbl_contents
  &(vtt_ee71260[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71260),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71260),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names120,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2260  : cc260 {
  int d;
  virtual void  foo(); // _ZN6dd22603fooEv
  ~dd2260(); // tgen
  dd2260(); // tgen
};
//SIG(-1 dd2260) C1{ BC2{ BC3{ BC4{ Fi} v2 v1 Fi} v1 Fi} v1 Fi}


void  dd2260 ::foo(){vfunc_called(this, "_ZN6dd22603fooEv");}
dd2260 ::~dd2260(){ note_dtor("dd2260", this);} // tgen
dd2260 ::dd2260(){ note_ctor("dd2260", this);} // tgen

static void Test_dd2260()
{
  extern Class_Descriptor cd_dd2260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2260, buf);
    dd2260 *dp, &lv = *(dp=new (buf) dd2260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(8,4), "dd2260");
    check_base_class_offset(lv, (bb60*)(cc260*), 0, "dd2260");
    check_base_class_offset(lv, (cc260*), 0, "dd2260");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2260.d");
    test_class_info(&lv, &cd_dd2260);
    dp->~dd2260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2260(Test_dd2260, "dd2260", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2260C1Ev();
extern void _ZN6dd2260D1Ev();
Name_Map name_map_dd2260[] = {
  NSPAIR(_ZN6dd2260C1Ev),
  NSPAIR(_ZN6dd2260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
static Base_Class bases_dd2260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2260[];
extern void _ZN4bb603barEv();
extern void _ZN6dd22603fooEv();
static  VTBL_ENTRY vtc_dd2260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN6dd22603fooEv,
};
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
Class_Descriptor cd_dd2260 = {  "dd2260", // class name
  bases_dd2260, 3,
  &(vtc_dd2260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02260  : dd2260 {
  int e;
  ~ee02260(); // tgen
  ee02260(); // tgen
};
//SIG(1 ee02260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} v1 Fi} Fi}


ee02260 ::~ee02260(){ note_dtor("ee02260", this);} // tgen
ee02260 ::ee02260(){ note_ctor("ee02260", this);} // tgen

static void Test_ee02260()
{
  extern Class_Descriptor cd_ee02260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02260, buf);
    ee02260 *dp, &lv = *(dp=new (buf) ee02260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(8,4), "ee02260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), 0, "ee02260");
    check_base_class_offset(lv, (cc260*)(dd2260*), 0, "ee02260");
    check_base_class_offset(lv, (dd2260*), 0, "ee02260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02260.e");
    test_class_info(&lv, &cd_ee02260);
    dp->~ee02260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02260(Test_ee02260, "ee02260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02260C1Ev();
extern void _ZN7ee02260D1Ev();
Name_Map name_map_ee02260[] = {
  NSPAIR(_ZN7ee02260C1Ev),
  NSPAIR(_ZN7ee02260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee02260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02260[];
extern void _ZN4bb603barEv();
extern void _ZN6dd22603fooEv();
static  VTBL_ENTRY vtc_ee02260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN6dd22603fooEv,
};
extern VTBL_ENTRY _ZTI7ee02260[];
extern  VTBL_ENTRY _ZTV7ee02260[];
Class_Descriptor cd_ee02260 = {  "ee02260", // class name
  bases_ee02260, 4,
  &(vtc_ee02260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12260  : virtual dd2260 {
  int e;
  ~ee12260(); // tgen
  ee12260(); // tgen
};
//SIG(1 ee12260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} v1 Fi} Fi}


ee12260 ::~ee12260(){ note_dtor("ee12260", this);} // tgen
ee12260 ::ee12260(){ note_ctor("ee12260", this);} // tgen

static void Test_ee12260()
{
  extern Class_Descriptor cd_ee12260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12260, buf);
    ee12260 *dp, &lv = *(dp=new (buf) ee12260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(24,12), "ee12260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), ABISELECT(16,8), "ee12260");
    check_base_class_offset(lv, (cc260*)(dd2260*), ABISELECT(16,8), "ee12260");
    check_base_class_offset(lv, (dd2260*), ABISELECT(16,8), "ee12260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12260.e");
    test_class_info(&lv, &cd_ee12260);
    dp->~ee12260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12260(Test_ee12260, "ee12260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12260C1Ev();
extern void _ZN7ee12260D1Ev();
Name_Map name_map_ee12260[] = {
  NSPAIR(_ZN7ee12260C1Ev),
  NSPAIR(_ZN7ee12260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee12260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12260[];
extern void _ZN4bb603barEv();
extern void _ZN6dd22603fooEv();
static  VTBL_ENTRY vtc_ee12260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12260[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN6dd22603fooEv,
};
extern VTBL_ENTRY _ZTV7ee12260[];
static  VTT_ENTRY vtt_ee12260[] = {
  {&(_ZTV7ee12260[3]),  3,9},
  {&(_ZTV7ee12260[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee12260[];
extern  VTBL_ENTRY _ZTV7ee12260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12260[];
Class_Descriptor cd_ee12260 = {  "ee12260", // class name
  bases_ee12260, 4,
  &(vtc_ee12260[0]), // expected_vtbl_contents
  &(vtt_ee12260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12260),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22260  : dd2260 {
  int e;
  virtual void  foo(); // _ZN7ee222603fooEv
  ~ee22260(); // tgen
  ee22260(); // tgen
};
//SIG(1 ee22260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee22260 ::foo(){vfunc_called(this, "_ZN7ee222603fooEv");}
ee22260 ::~ee22260(){ note_dtor("ee22260", this);} // tgen
ee22260 ::ee22260(){ note_ctor("ee22260", this);} // tgen

static void Test_ee22260()
{
  extern Class_Descriptor cd_ee22260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22260, buf);
    ee22260 *dp, &lv = *(dp=new (buf) ee22260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(8,4), "ee22260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), 0, "ee22260");
    check_base_class_offset(lv, (cc260*)(dd2260*), 0, "ee22260");
    check_base_class_offset(lv, (dd2260*), 0, "ee22260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22260.e");
    test_class_info(&lv, &cd_ee22260);
    dp->~ee22260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22260(Test_ee22260, "ee22260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22260C1Ev();
extern void _ZN7ee22260D1Ev();
Name_Map name_map_ee22260[] = {
  NSPAIR(_ZN7ee22260C1Ev),
  NSPAIR(_ZN7ee22260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee22260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22260[];
extern void _ZN4bb603barEv();
extern void _ZN7ee222603fooEv();
static  VTBL_ENTRY vtc_ee22260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&_ZN7ee222603fooEv,
};
extern VTBL_ENTRY _ZTI7ee22260[];
extern  VTBL_ENTRY _ZTV7ee22260[];
Class_Descriptor cd_ee22260 = {  "ee22260", // class name
  bases_ee22260, 4,
  &(vtc_ee22260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32260  : virtual dd2260 {
  int e;
  virtual void  foo(); // _ZN7ee322603fooEv
  ~ee32260(); // tgen
  ee32260(); // tgen
};
//SIG(1 ee32260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee32260 ::foo(){vfunc_called(this, "_ZN7ee322603fooEv");}
ee32260 ::~ee32260(){ note_dtor("ee32260", this);} // tgen
ee32260 ::ee32260(){ note_ctor("ee32260", this);} // tgen

static void Test_ee32260()
{
  extern Class_Descriptor cd_ee32260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32260, buf);
    ee32260 *dp, &lv = *(dp=new (buf) ee32260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(24,12), "ee32260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), ABISELECT(16,8), "ee32260");
    check_base_class_offset(lv, (cc260*)(dd2260*), ABISELECT(16,8), "ee32260");
    check_base_class_offset(lv, (dd2260*), ABISELECT(16,8), "ee32260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32260.e");
    test_class_info(&lv, &cd_ee32260);
    dp->~ee32260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32260(Test_ee32260, "ee32260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32260C1Ev();
extern void _ZN7ee32260D1Ev();
Name_Map name_map_ee32260[] = {
  NSPAIR(_ZN7ee32260C1Ev),
  NSPAIR(_ZN7ee32260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee32260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32260[];
extern void _ZN7ee322603fooEv();
extern void _ZN4bb603barEv();
extern void ABISELECT(_ZTv0_n32_N7ee322603fooEv,_ZTv0_n16_N7ee322603fooEv)();
extern void ABISELECT(_ZThn16_N7ee322603fooEv,_ZThn8_N7ee322603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32260[0]),
  (VTBL_ENTRY)&_ZN7ee322603fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32260[0]),
  (VTBL_ENTRY)&_ZN4bb603barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee322603fooEv,_ZTv0_n16_N7ee322603fooEv),
};
extern VTBL_ENTRY _ZTV7ee32260[];
static  VTT_ENTRY vtt_ee32260[] = {
  {&(_ZTV7ee32260[3]),  3,10},
  {&(_ZTV7ee32260[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee32260[];
extern  VTBL_ENTRY _ZTV7ee32260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32260[];
static VTBL_ENTRY alt_thunk_names121[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee322603fooEv,_ZTv0_n16_N7ee322603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee322603fooEv,_ZThn8_N7ee322603fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32260 = {  "ee32260", // class name
  bases_ee32260, 4,
  &(vtc_ee32260[0]), // expected_vtbl_contents
  &(vtt_ee32260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32260),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names121,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42260  : dd2260 {
  int e;
  virtual void  bar(); // _ZN7ee422603barEv
  ~ee42260(); // tgen
  ee42260(); // tgen
};
//SIG(1 ee42260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee42260 ::bar(){vfunc_called(this, "_ZN7ee422603barEv");}
ee42260 ::~ee42260(){ note_dtor("ee42260", this);} // tgen
ee42260 ::ee42260(){ note_ctor("ee42260", this);} // tgen

static void Test_ee42260()
{
  extern Class_Descriptor cd_ee42260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42260, buf);
    ee42260 *dp, &lv = *(dp=new (buf) ee42260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(8,4), "ee42260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), 0, "ee42260");
    check_base_class_offset(lv, (cc260*)(dd2260*), 0, "ee42260");
    check_base_class_offset(lv, (dd2260*), 0, "ee42260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42260.e");
    test_class_info(&lv, &cd_ee42260);
    dp->~ee42260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42260(Test_ee42260, "ee42260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42260C1Ev();
extern void _ZN7ee42260D1Ev();
Name_Map name_map_ee42260[] = {
  NSPAIR(_ZN7ee42260C1Ev),
  NSPAIR(_ZN7ee42260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee42260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42260[];
extern void _ZN7ee422603barEv();
extern void _ZN6dd22603fooEv();
static  VTBL_ENTRY vtc_ee42260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42260[0]),
  (VTBL_ENTRY)&_ZN7ee422603barEv,
  (VTBL_ENTRY)&_ZN6dd22603fooEv,
};
extern VTBL_ENTRY _ZTI7ee42260[];
extern  VTBL_ENTRY _ZTV7ee42260[];
Class_Descriptor cd_ee42260 = {  "ee42260", // class name
  bases_ee42260, 4,
  &(vtc_ee42260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52260  : virtual dd2260 {
  int e;
  virtual void  bar(); // _ZN7ee522603barEv
  ~ee52260(); // tgen
  ee52260(); // tgen
};
//SIG(1 ee52260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 v2 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee52260 ::bar(){vfunc_called(this, "_ZN7ee522603barEv");}
ee52260 ::~ee52260(){ note_dtor("ee52260", this);} // tgen
ee52260 ::ee52260(){ note_ctor("ee52260", this);} // tgen

static void Test_ee52260()
{
  extern Class_Descriptor cd_ee52260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52260, buf);
    ee52260 *dp, &lv = *(dp=new (buf) ee52260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(24,12), "ee52260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), ABISELECT(16,8), "ee52260");
    check_base_class_offset(lv, (cc260*)(dd2260*), ABISELECT(16,8), "ee52260");
    check_base_class_offset(lv, (dd2260*), ABISELECT(16,8), "ee52260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52260.e");
    test_class_info(&lv, &cd_ee52260);
    dp->~ee52260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52260(Test_ee52260, "ee52260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52260C1Ev();
extern void _ZN7ee52260D1Ev();
Name_Map name_map_ee52260[] = {
  NSPAIR(_ZN7ee52260C1Ev),
  NSPAIR(_ZN7ee52260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee52260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52260[];
extern void _ZN7ee522603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee522603barEv,_ZTv0_n12_N7ee522603barEv)();
extern void ABISELECT(_ZThn16_N7ee522603barEv,_ZThn8_N7ee522603barEv)() __attribute__((weak));
extern void _ZN6dd22603fooEv();
static  VTBL_ENTRY vtc_ee52260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52260[0]),
  (VTBL_ENTRY)&_ZN7ee522603barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee522603barEv,_ZTv0_n12_N7ee522603barEv),
  (VTBL_ENTRY)&_ZN6dd22603fooEv,
};
extern VTBL_ENTRY _ZTV7ee52260[];
static  VTT_ENTRY vtt_ee52260[] = {
  {&(_ZTV7ee52260[3]),  3,10},
  {&(_ZTV7ee52260[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee52260[];
extern  VTBL_ENTRY _ZTV7ee52260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52260[];
static VTBL_ENTRY alt_thunk_names122[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee522603barEv,_ZTv0_n12_N7ee522603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee522603barEv,_ZThn8_N7ee522603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52260 = {  "ee52260", // class name
  bases_ee52260, 4,
  &(vtc_ee52260[0]), // expected_vtbl_contents
  &(vtt_ee52260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52260),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names122,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62260  : dd2260 {
  int e;
  virtual void  foo(); // _ZN7ee622603fooEv
  virtual void  bar(); // _ZN7ee622603barEv
  ~ee62260(); // tgen
  ee62260(); // tgen
};
//SIG(1 ee62260) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee62260 ::foo(){vfunc_called(this, "_ZN7ee622603fooEv");}
void  ee62260 ::bar(){vfunc_called(this, "_ZN7ee622603barEv");}
ee62260 ::~ee62260(){ note_dtor("ee62260", this);} // tgen
ee62260 ::ee62260(){ note_ctor("ee62260", this);} // tgen

static void Test_ee62260()
{
  extern Class_Descriptor cd_ee62260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62260, buf);
    ee62260 *dp, &lv = *(dp=new (buf) ee62260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(8,4), "ee62260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), 0, "ee62260");
    check_base_class_offset(lv, (cc260*)(dd2260*), 0, "ee62260");
    check_base_class_offset(lv, (dd2260*), 0, "ee62260");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62260.e");
    test_class_info(&lv, &cd_ee62260);
    dp->~ee62260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62260(Test_ee62260, "ee62260", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62260C1Ev();
extern void _ZN7ee62260D1Ev();
Name_Map name_map_ee62260[] = {
  NSPAIR(_ZN7ee62260C1Ev),
  NSPAIR(_ZN7ee62260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee62260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62260[];
extern void _ZN7ee622603barEv();
extern void _ZN7ee622603fooEv();
static  VTBL_ENTRY vtc_ee62260[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62260[0]),
  (VTBL_ENTRY)&_ZN7ee622603barEv,
  (VTBL_ENTRY)&_ZN7ee622603fooEv,
};
extern VTBL_ENTRY _ZTI7ee62260[];
extern  VTBL_ENTRY _ZTV7ee62260[];
Class_Descriptor cd_ee62260 = {  "ee62260", // class name
  bases_ee62260, 4,
  &(vtc_ee62260[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62260),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62260),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72260  : virtual dd2260 {
  int e;
  virtual void  foo(); // _ZN7ee722603fooEv
  virtual void  bar(); // _ZN7ee722603barEv
  ~ee72260(); // tgen
  ee72260(); // tgen
};
//SIG(1 ee72260) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 v1 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee72260 ::foo(){vfunc_called(this, "_ZN7ee722603fooEv");}
void  ee72260 ::bar(){vfunc_called(this, "_ZN7ee722603barEv");}
ee72260 ::~ee72260(){ note_dtor("ee72260", this);} // tgen
ee72260 ::ee72260(){ note_ctor("ee72260", this);} // tgen

static void Test_ee72260()
{
  extern Class_Descriptor cd_ee72260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72260, buf);
    ee72260 *dp, &lv = *(dp=new (buf) ee72260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*)(dd2260*), ABISELECT(24,12), "ee72260");
    check_base_class_offset(lv, (bb60*)(cc260*)(dd2260*), ABISELECT(16,8), "ee72260");
    check_base_class_offset(lv, (cc260*)(dd2260*), ABISELECT(16,8), "ee72260");
    check_base_class_offset(lv, (dd2260*), ABISELECT(16,8), "ee72260");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72260.e");
    test_class_info(&lv, &cd_ee72260);
    dp->~ee72260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72260(Test_ee72260, "ee72260", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72260C1Ev();
extern void _ZN7ee72260D1Ev();
Name_Map name_map_ee72260[] = {
  NSPAIR(_ZN7ee72260C1Ev),
  NSPAIR(_ZN7ee72260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
extern Class_Descriptor cd_dd2260;
extern VTBL_ENTRY _ZTI6dd2260[];
extern  VTBL_ENTRY _ZTV6dd2260[];
static Base_Class bases_ee72260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2260,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72260[];
extern void _ZN7ee722603fooEv();
extern void _ZN7ee722603barEv();
extern void ABISELECT(_ZTv0_n24_N7ee722603barEv,_ZTv0_n12_N7ee722603barEv)();
extern void ABISELECT(_ZThn16_N7ee722603barEv,_ZThn8_N7ee722603barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee722603fooEv,_ZTv0_n16_N7ee722603fooEv)();
extern void ABISELECT(_ZThn16_N7ee722603fooEv,_ZThn8_N7ee722603fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72260[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72260[0]),
  (VTBL_ENTRY)&_ZN7ee722603fooEv,
  (VTBL_ENTRY)&_ZN7ee722603barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72260[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee722603barEv,_ZTv0_n12_N7ee722603barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee722603fooEv,_ZTv0_n16_N7ee722603fooEv),
};
extern VTBL_ENTRY _ZTV7ee72260[];
static  VTT_ENTRY vtt_ee72260[] = {
  {&(_ZTV7ee72260[3]),  3,11},
  {&(_ZTV7ee72260[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee72260[];
extern  VTBL_ENTRY _ZTV7ee72260[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72260[];
static VTBL_ENTRY alt_thunk_names123[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee722603fooEv,_ZTv0_n16_N7ee722603fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee722603fooEv,_ZThn8_N7ee722603fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee722603barEv,_ZTv0_n12_N7ee722603barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee722603barEv,_ZThn8_N7ee722603barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72260 = {  "ee72260", // class name
  bases_ee72260, 4,
  &(vtc_ee72260[0]), // expected_vtbl_contents
  &(vtt_ee72260[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72260),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72260),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72260),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names123,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3260  : virtual cc260 {
  int d;
  virtual void  foo(); // _ZN6dd32603fooEv
  ~dd3260(); // tgen
  dd3260(); // tgen
};
//SIG(-1 dd3260) C1{ VBC2{ BC3{ BC4{ Fi} v2 v1 Fi} v1 Fi} v1 Fi}


void  dd3260 ::foo(){vfunc_called(this, "_ZN6dd32603fooEv");}
dd3260 ::~dd3260(){ note_dtor("dd3260", this);} // tgen
dd3260 ::dd3260(){ note_ctor("dd3260", this);} // tgen

static void Test_dd3260()
{
  extern Class_Descriptor cd_dd3260;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3260, buf);
    dd3260 *dp, &lv = *(dp=new (buf) dd3260());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3260)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3260)");
    check_base_class_offset(lv, (aa0*)(bb60*)(cc260*), ABISELECT(24,12), "dd3260");
    check_base_class_offset(lv, (bb60*)(cc260*), ABISELECT(16,8), "dd3260");
    check_base_class_offset(lv, (cc260*), ABISELECT(16,8), "dd3260");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3260.d");
    test_class_info(&lv, &cd_dd3260);
    dp->~dd3260();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3260(Test_dd3260, "dd3260", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3260C1Ev();
extern void _ZN6dd3260D1Ev();
Name_Map name_map_dd3260[] = {
  NSPAIR(_ZN6dd3260C1Ev),
  NSPAIR(_ZN6dd3260D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb60;
extern VTBL_ENTRY _ZTI4bb60[];
extern  VTBL_ENTRY _ZTV4bb60[];
extern Class_Descriptor cd_cc260;
extern VTBL_ENTRY _ZTI5cc260[];
extern  VTBL_ENTRY _ZTV5cc260[];
static Base_Class bases_dd3260[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb60,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc260,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_deri