// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb50  : virtual aa0 {
  int b;
  virtual void  bar(); // _ZN4bb503barEv
  ~bb50(); // tgen
  bb50(); // tgen
};
//SIG(-1 bb50) C1{ VBC2{ Fi} v1 Fi}


void  bb50 ::bar(){vfunc_called(this, "_ZN4bb503barEv");}
bb50 ::~bb50(){ note_dtor("bb50", this);} // tgen
bb50 ::bb50(){ note_ctor("bb50", this);} // tgen

static void Test_bb50()
{
  extern Class_Descriptor cd_bb50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_bb50, buf);
    bb50 *dp, &lv = *(dp=new (buf) bb50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(bb50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb50)");
    check_base_class_offset(lv, (aa0*), ABISELECT(12,8), "bb50");
    check_field_offset(lv, b, ABISELECT(8,4), "bb50.b");
    test_class_info(&lv, &cd_bb50);
    dp->~bb50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb50(Test_bb50, "bb50", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN4bb50C1Ev();
extern void _ZN4bb50D1Ev();
Name_Map name_map_bb50[] = {
  NSPAIR(_ZN4bb50C1Ev),
  NSPAIR(_ZN4bb50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4bb50[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_bb50[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV4bb50[];
static  VTT_ENTRY vtt_bb50[] = {
  {&(_ZTV4bb50[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
Class_Descriptor cd_bb50 = {  "bb50", // class name
  bases_bb50, 1,
  &(vtc_bb50[0]), // expected_vtbl_contents
  &(vtt_bb50[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI4bb50),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4bb50),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4bb50),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc050  : bb50 {
  int c;
  ~cc050(); // tgen
  cc050(); // tgen
};
//SIG(-1 cc050) C1{ BC2{ VBC3{ Fi} v1 Fi} Fi}


cc050 ::~cc050(){ note_dtor("cc050", this);} // tgen
cc050 ::cc050(){ note_ctor("cc050", this);} // tgen

static void Test_cc050()
{
  extern Class_Descriptor cd_cc050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc050, buf);
    cc050 *dp, &lv = *(dp=new (buf) cc050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc050)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(16,12), "cc050");
    check_base_class_offset(lv, (bb50*), 0, "cc050");
    check_field_offset(lv, c, ABISELECT(12,8), "cc050.c");
    test_class_info(&lv, &cd_cc050);
    dp->~cc050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc050(Test_cc050, "cc050", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc050C1Ev();
extern void _ZN5cc050D1Ev();
Name_Map name_map_cc050[] = {
  NSPAIR(_ZN5cc050C1Ev),
  NSPAIR(_ZN5cc050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
static Base_Class bases_cc050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_cc050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV5cc050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_cc050[] = {
  {&(_ZTV5cc050[3]),  3,4},
  {&(_tg__ZTV4bb50__5cc050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
Class_Descriptor cd_cc050 = {  "cc050", // class name
  bases_cc050, 2,
  &(vtc_cc050[0]), // expected_vtbl_contents
  &(vtt_cc050[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc050),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc050),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0050  : cc050 {
  int d;
  ~dd0050(); // tgen
  dd0050(); // tgen
};
//SIG(-1 dd0050) C1{ BC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd0050 ::~dd0050(){ note_dtor("dd0050", this);} // tgen
dd0050 ::dd0050(){ note_ctor("dd0050", this);} // tgen

static void Test_dd0050()
{
  extern Class_Descriptor cd_dd0050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0050, buf);
    dd0050 *dp, &lv = *(dp=new (buf) dd0050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(20,16), "dd0050");
    check_base_class_offset(lv, (bb50*)(cc050*), 0, "dd0050");
    check_base_class_offset(lv, (cc050*), 0, "dd0050");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0050.d");
    test_class_info(&lv, &cd_dd0050);
    dp->~dd0050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0050(Test_dd0050, "dd0050", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0050C1Ev();
extern void _ZN6dd0050D1Ev();
Name_Map name_map_dd0050[] = {
  NSPAIR(_ZN6dd0050C1Ev),
  NSPAIR(_ZN6dd0050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd0050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_dd0050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV6dd0050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd0050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd0050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd0050[] = {
  {&(_ZTV6dd0050[3]),  3,4},
  {&(_tg__ZTV5cc050__6dd0050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd0050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
Class_Descriptor cd_dd0050 = {  "dd0050", // class name
  bases_dd0050, 3,
  &(vtc_dd0050[0]), // expected_vtbl_contents
  &(vtt_dd0050[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0050),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0050),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00050  : dd0050 {
  int e;
  ~ee00050(); // tgen
  ee00050(); // tgen
};
//SIG(1 ee00050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00050 ::~ee00050(){ note_dtor("ee00050", this);} // tgen
ee00050 ::ee00050(){ note_ctor("ee00050", this);} // tgen

static void Test_ee00050()
{
  extern Class_Descriptor cd_ee00050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00050, buf);
    ee00050 *dp, &lv = *(dp=new (buf) ee00050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(24,20), "ee00050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), 0, "ee00050");
    check_base_class_offset(lv, (cc050*)(dd0050*), 0, "ee00050");
    check_base_class_offset(lv, (dd0050*), 0, "ee00050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00050.e");
    test_class_info(&lv, &cd_ee00050);
    dp->~ee00050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00050(Test_ee00050, "ee00050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00050C1Ev();
extern void _ZN7ee00050D1Ev();
Name_Map name_map_ee00050[] = {
  NSPAIR(_ZN7ee00050C1Ev),
  NSPAIR(_ZN7ee00050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee00050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee00050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee00050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee00050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee00050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee00050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee00050[] = {
  {&(_ZTV7ee00050[3]),  3,4},
  {&(_tg__ZTV6dd0050__7ee00050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee00050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee00050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee00050[];
extern  VTBL_ENTRY _ZTV7ee00050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00050[];
Class_Descriptor cd_ee00050 = {  "ee00050", // class name
  bases_ee00050, 4,
  &(vtc_ee00050[0]), // expected_vtbl_contents
  &(vtt_ee00050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00050),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10050  : virtual dd0050 {
  int e;
  ~ee10050(); // tgen
  ee10050(); // tgen
};
//SIG(1 ee10050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10050 ::~ee10050(){ note_dtor("ee10050", this);} // tgen
ee10050 ::ee10050(){ note_ctor("ee10050", this);} // tgen

static void Test_ee10050()
{
  extern Class_Descriptor cd_ee10050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10050, buf);
    ee10050 *dp, &lv = *(dp=new (buf) ee10050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(36,24), "ee10050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), ABISELECT(16,8), "ee10050");
    check_base_class_offset(lv, (cc050*)(dd0050*), ABISELECT(16,8), "ee10050");
    check_base_class_offset(lv, (dd0050*), ABISELECT(16,8), "ee10050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10050.e");
    test_class_info(&lv, &cd_ee10050);
    dp->~ee10050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10050(Test_ee10050, "ee10050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10050C1Ev();
extern void _ZN7ee10050D1Ev();
Name_Map name_map_ee10050[] = {
  NSPAIR(_ZN7ee10050C1Ev),
  NSPAIR(_ZN7ee10050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee10050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee10050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10050[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee10050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee10050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee10050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee10050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee10050[] = {
  {&(_ZTV7ee10050[4]),  4,9},
  {&(_ZTV7ee10050[8]),  8,9},
  {&(_tg__ZTV6dd0050__7ee10050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee10050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee10050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10050[];
extern  VTBL_ENTRY _ZTV7ee10050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10050[];
Class_Descriptor cd_ee10050 = {  "ee10050", // class name
  bases_ee10050, 4,
  &(vtc_ee10050[0]), // expected_vtbl_contents
  &(vtt_ee10050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10050),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20050  : dd0050 {
  int e;
  virtual void  foo(); // _ZN7ee200503fooEv
  ~ee20050(); // tgen
  ee20050(); // tgen
};
//SIG(1 ee20050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee20050 ::foo(){vfunc_called(this, "_ZN7ee200503fooEv");}
ee20050 ::~ee20050(){ note_dtor("ee20050", this);} // tgen
ee20050 ::ee20050(){ note_ctor("ee20050", this);} // tgen

static void Test_ee20050()
{
  extern Class_Descriptor cd_ee20050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20050, buf);
    ee20050 *dp, &lv = *(dp=new (buf) ee20050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(24,20), "ee20050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), 0, "ee20050");
    check_base_class_offset(lv, (cc050*)(dd0050*), 0, "ee20050");
    check_base_class_offset(lv, (dd0050*), 0, "ee20050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20050.e");
    test_class_info(&lv, &cd_ee20050);
    dp->~ee20050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20050(Test_ee20050, "ee20050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20050C1Ev();
extern void _ZN7ee20050D1Ev();
Name_Map name_map_ee20050[] = {
  NSPAIR(_ZN7ee20050C1Ev),
  NSPAIR(_ZN7ee20050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee20050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20050[];
extern void _ZN4bb503barEv();
extern void _ZN7ee200503fooEv();
static  VTBL_ENTRY vtc_ee20050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN7ee200503fooEv,
};
extern VTBL_ENTRY _ZTV7ee20050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee20050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee20050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee20050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee20050[] = {
  {&(_ZTV7ee20050[3]),  3,5},
  {&(_tg__ZTV6dd0050__7ee20050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee20050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee20050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee20050[];
extern  VTBL_ENTRY _ZTV7ee20050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20050[];
Class_Descriptor cd_ee20050 = {  "ee20050", // class name
  bases_ee20050, 4,
  &(vtc_ee20050[0]), // expected_vtbl_contents
  &(vtt_ee20050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30050  : virtual dd0050 {
  int e;
  virtual void  foo(); // _ZN7ee300503fooEv
  ~ee30050(); // tgen
  ee30050(); // tgen
};
//SIG(1 ee30050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee30050 ::foo(){vfunc_called(this, "_ZN7ee300503fooEv");}
ee30050 ::~ee30050(){ note_dtor("ee30050", this);} // tgen
ee30050 ::ee30050(){ note_ctor("ee30050", this);} // tgen

static void Test_ee30050()
{
  extern Class_Descriptor cd_ee30050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30050, buf);
    ee30050 *dp, &lv = *(dp=new (buf) ee30050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(36,24), "ee30050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), ABISELECT(16,8), "ee30050");
    check_base_class_offset(lv, (cc050*)(dd0050*), ABISELECT(16,8), "ee30050");
    check_base_class_offset(lv, (dd0050*), ABISELECT(16,8), "ee30050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30050.e");
    test_class_info(&lv, &cd_ee30050);
    dp->~ee30050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30050(Test_ee30050, "ee30050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30050C1Ev();
extern void _ZN7ee30050D1Ev();
Name_Map name_map_ee30050[] = {
  NSPAIR(_ZN7ee30050C1Ev),
  NSPAIR(_ZN7ee30050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee30050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30050[];
extern void _ZN7ee300503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee30050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30050[0]),
  (VTBL_ENTRY)&_ZN7ee300503fooEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee30050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee30050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee30050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee30050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee30050[] = {
  {&(_ZTV7ee30050[4]),  4,10},
  {&(_ZTV7ee30050[9]),  9,10},
  {&(_tg__ZTV6dd0050__7ee30050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee30050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee30050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30050[];
extern  VTBL_ENTRY _ZTV7ee30050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30050[];
Class_Descriptor cd_ee30050 = {  "ee30050", // class name
  bases_ee30050, 4,
  &(vtc_ee30050[0]), // expected_vtbl_contents
  &(vtt_ee30050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40050  : dd0050 {
  int e;
  virtual void  bar(); // _ZN7ee400503barEv
  ~ee40050(); // tgen
  ee40050(); // tgen
};
//SIG(1 ee40050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee40050 ::bar(){vfunc_called(this, "_ZN7ee400503barEv");}
ee40050 ::~ee40050(){ note_dtor("ee40050", this);} // tgen
ee40050 ::ee40050(){ note_ctor("ee40050", this);} // tgen

static void Test_ee40050()
{
  extern Class_Descriptor cd_ee40050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40050, buf);
    ee40050 *dp, &lv = *(dp=new (buf) ee40050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(24,20), "ee40050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), 0, "ee40050");
    check_base_class_offset(lv, (cc050*)(dd0050*), 0, "ee40050");
    check_base_class_offset(lv, (dd0050*), 0, "ee40050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee40050.e");
    test_class_info(&lv, &cd_ee40050);
    dp->~ee40050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40050(Test_ee40050, "ee40050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40050C1Ev();
extern void _ZN7ee40050D1Ev();
Name_Map name_map_ee40050[] = {
  NSPAIR(_ZN7ee40050C1Ev),
  NSPAIR(_ZN7ee40050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee40050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40050[];
extern void _ZN7ee400503barEv();
static  VTBL_ENTRY vtc_ee40050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40050[0]),
  (VTBL_ENTRY)&_ZN7ee400503barEv,
};
extern VTBL_ENTRY _ZTV7ee40050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee40050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee40050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee40050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee40050[] = {
  {&(_ZTV7ee40050[3]),  3,4},
  {&(_tg__ZTV6dd0050__7ee40050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee40050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee40050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee40050[];
extern  VTBL_ENTRY _ZTV7ee40050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40050[];
Class_Descriptor cd_ee40050 = {  "ee40050", // class name
  bases_ee40050, 4,
  &(vtc_ee40050[0]), // expected_vtbl_contents
  &(vtt_ee40050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40050),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50050  : virtual dd0050 {
  int e;
  virtual void  bar(); // _ZN7ee500503barEv
  ~ee50050(); // tgen
  ee50050(); // tgen
};
//SIG(1 ee50050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee50050 ::bar(){vfunc_called(this, "_ZN7ee500503barEv");}
ee50050 ::~ee50050(){ note_dtor("ee50050", this);} // tgen
ee50050 ::ee50050(){ note_ctor("ee50050", this);} // tgen

static void Test_ee50050()
{
  extern Class_Descriptor cd_ee50050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50050, buf);
    ee50050 *dp, &lv = *(dp=new (buf) ee50050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(36,24), "ee50050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), ABISELECT(16,8), "ee50050");
    check_base_class_offset(lv, (cc050*)(dd0050*), ABISELECT(16,8), "ee50050");
    check_base_class_offset(lv, (dd0050*), ABISELECT(16,8), "ee50050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50050.e");
    test_class_info(&lv, &cd_ee50050);
    dp->~ee50050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50050(Test_ee50050, "ee50050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50050C1Ev();
extern void _ZN7ee50050D1Ev();
Name_Map name_map_ee50050[] = {
  NSPAIR(_ZN7ee50050C1Ev),
  NSPAIR(_ZN7ee50050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee50050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50050[];
extern void _ZN7ee500503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee500503barEv,_ZTv0_n16_N7ee500503barEv)();
extern void ABISELECT(_ZThn16_N7ee500503barEv,_ZThn8_N7ee500503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee50050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50050[0]),
  (VTBL_ENTRY)&_ZN7ee500503barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee500503barEv,_ZTv0_n16_N7ee500503barEv),
};
extern VTBL_ENTRY _ZTV7ee50050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee50050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee50050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee50050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee50050[] = {
  {&(_ZTV7ee50050[4]),  4,10},
  {&(_ZTV7ee50050[9]),  9,10},
  {&(_tg__ZTV6dd0050__7ee50050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee50050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee50050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50050[];
extern  VTBL_ENTRY _ZTV7ee50050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50050[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee500503barEv,_ZTv0_n16_N7ee500503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee500503barEv,_ZThn8_N7ee500503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50050 = {  "ee50050", // class name
  bases_ee50050, 4,
  &(vtc_ee50050[0]), // expected_vtbl_contents
  &(vtt_ee50050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60050  : dd0050 {
  int e;
  virtual void  foo(); // _ZN7ee600503fooEv
  virtual void  bar(); // _ZN7ee600503barEv
  ~ee60050(); // tgen
  ee60050(); // tgen
};
//SIG(1 ee60050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee60050 ::foo(){vfunc_called(this, "_ZN7ee600503fooEv");}
void  ee60050 ::bar(){vfunc_called(this, "_ZN7ee600503barEv");}
ee60050 ::~ee60050(){ note_dtor("ee60050", this);} // tgen
ee60050 ::ee60050(){ note_ctor("ee60050", this);} // tgen

static void Test_ee60050()
{
  extern Class_Descriptor cd_ee60050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60050, buf);
    ee60050 *dp, &lv = *(dp=new (buf) ee60050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(24,20), "ee60050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), 0, "ee60050");
    check_base_class_offset(lv, (cc050*)(dd0050*), 0, "ee60050");
    check_base_class_offset(lv, (dd0050*), 0, "ee60050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee60050.e");
    test_class_info(&lv, &cd_ee60050);
    dp->~ee60050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60050(Test_ee60050, "ee60050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60050C1Ev();
extern void _ZN7ee60050D1Ev();
Name_Map name_map_ee60050[] = {
  NSPAIR(_ZN7ee60050C1Ev),
  NSPAIR(_ZN7ee60050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee60050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60050[];
extern void _ZN7ee600503barEv();
extern void _ZN7ee600503fooEv();
static  VTBL_ENTRY vtc_ee60050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60050[0]),
  (VTBL_ENTRY)&_ZN7ee600503barEv,
  (VTBL_ENTRY)&_ZN7ee600503fooEv,
};
extern VTBL_ENTRY _ZTV7ee60050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee60050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee60050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee60050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee60050[] = {
  {&(_ZTV7ee60050[3]),  3,5},
  {&(_tg__ZTV6dd0050__7ee60050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee60050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee60050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee60050[];
extern  VTBL_ENTRY _ZTV7ee60050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60050[];
Class_Descriptor cd_ee60050 = {  "ee60050", // class name
  bases_ee60050, 4,
  &(vtc_ee60050[0]), // expected_vtbl_contents
  &(vtt_ee60050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70050  : virtual dd0050 {
  int e;
  virtual void  foo(); // _ZN7ee700503fooEv
  virtual void  bar(); // _ZN7ee700503barEv
  ~ee70050(); // tgen
  ee70050(); // tgen
};
//SIG(1 ee70050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee70050 ::foo(){vfunc_called(this, "_ZN7ee700503fooEv");}
void  ee70050 ::bar(){vfunc_called(this, "_ZN7ee700503barEv");}
ee70050 ::~ee70050(){ note_dtor("ee70050", this);} // tgen
ee70050 ::ee70050(){ note_ctor("ee70050", this);} // tgen

static void Test_ee70050()
{
  extern Class_Descriptor cd_ee70050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70050, buf);
    ee70050 *dp, &lv = *(dp=new (buf) ee70050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd0050*), ABISELECT(36,24), "ee70050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd0050*), ABISELECT(16,8), "ee70050");
    check_base_class_offset(lv, (cc050*)(dd0050*), ABISELECT(16,8), "ee70050");
    check_base_class_offset(lv, (dd0050*), ABISELECT(16,8), "ee70050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70050.e");
    test_class_info(&lv, &cd_ee70050);
    dp->~ee70050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70050(Test_ee70050, "ee70050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70050C1Ev();
extern void _ZN7ee70050D1Ev();
Name_Map name_map_ee70050[] = {
  NSPAIR(_ZN7ee70050C1Ev),
  NSPAIR(_ZN7ee70050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd0050;
extern VTBL_ENTRY _ZTI6dd0050[];
extern  VTBL_ENTRY _ZTV6dd0050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0050[];
static Base_Class bases_ee70050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70050[];
extern void _ZN7ee700503fooEv();
extern void _ZN7ee700503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee700503barEv,_ZTv0_n16_N7ee700503barEv)();
extern void ABISELECT(_ZThn16_N7ee700503barEv,_ZThn8_N7ee700503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70050[0]),
  (VTBL_ENTRY)&_ZN7ee700503fooEv,
  (VTBL_ENTRY)&_ZN7ee700503barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee700503barEv,_ZTv0_n16_N7ee700503barEv),
};
extern VTBL_ENTRY _ZTV7ee70050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV6dd0050__7ee70050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd0050__7ee70050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd0050__7ee70050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee70050[] = {
  {&(_ZTV7ee70050[4]),  4,11},
  {&(_ZTV7ee70050[10]),  10,11},
  {&(_tg__ZTV6dd0050__7ee70050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd0050__7ee70050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd0050__7ee70050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70050[];
extern  VTBL_ENTRY _ZTV7ee70050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70050[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee700503barEv,_ZTv0_n16_N7ee700503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700503barEv,_ZThn8_N7ee700503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70050 = {  "ee70050", // class name
  bases_ee70050, 4,
  &(vtc_ee70050[0]), // expected_vtbl_contents
  &(vtt_ee70050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1050  : virtual cc050 {
  int d;
  ~dd1050(); // tgen
  dd1050(); // tgen
};
//SIG(-1 dd1050) C1{ VBC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd1050 ::~dd1050(){ note_dtor("dd1050", this);} // tgen
dd1050 ::dd1050(){ note_ctor("dd1050", this);} // tgen

static void Test_dd1050()
{
  extern Class_Descriptor cd_dd1050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1050, buf);
    dd1050 *dp, &lv = *(dp=new (buf) dd1050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,20), "dd1050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,8), "dd1050");
    check_base_class_offset(lv, (cc050*), ABISELECT(16,8), "dd1050");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1050.d");
    test_class_info(&lv, &cd_dd1050);
    dp->~dd1050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1050(Test_dd1050, "dd1050", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1050C1Ev();
extern void _ZN6dd1050D1Ev();
Name_Map name_map_dd1050[] = {
  NSPAIR(_ZN6dd1050C1Ev),
  NSPAIR(_ZN6dd1050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd1050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_dd1050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV6dd1050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd1050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd1050[] = {
  {&(_ZTV6dd1050[4]),  4,9},
  {&(_ZTV6dd1050[8]),  8,9},
  {&(_tg__ZTV5cc050__6dd1050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd1050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
Class_Descriptor cd_dd1050 = {  "dd1050", // class name
  bases_dd1050, 3,
  &(vtc_dd1050[0]), // expected_vtbl_contents
  &(vtt_dd1050[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1050),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1050),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01050  : dd1050 {
  int e;
  ~ee01050(); // tgen
  ee01050(); // tgen
};
//SIG(1 ee01050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01050 ::~ee01050(){ note_dtor("ee01050", this);} // tgen
ee01050 ::ee01050(){ note_ctor("ee01050", this);} // tgen

static void Test_ee01050()
{
  extern Class_Descriptor cd_ee01050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01050, buf);
    ee01050 *dp, &lv = *(dp=new (buf) ee01050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee01050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee01050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(16,12), "ee01050");
    check_base_class_offset(lv, (dd1050*), 0, "ee01050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01050.e");
    test_class_info(&lv, &cd_ee01050);
    dp->~ee01050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01050(Test_ee01050, "ee01050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01050C1Ev();
extern void _ZN7ee01050D1Ev();
Name_Map name_map_ee01050[] = {
  NSPAIR(_ZN7ee01050C1Ev),
  NSPAIR(_ZN7ee01050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee01050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee01050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01050[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee01050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee01050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee01050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee01050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee01050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee01050[] = {
  {&(_ZTV7ee01050[4]),  4,9},
  {&(_tg__ZTV6dd1050__7ee01050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee01050[4]),  4,5},
  {&(_ZTV7ee01050[8]),  8,9},
  {&(_tg__ZTV5cc050__7ee01050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee01050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01050[];
extern  VTBL_ENTRY _ZTV7ee01050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01050[];
Class_Descriptor cd_ee01050 = {  "ee01050", // class name
  bases_ee01050, 4,
  &(vtc_ee01050[0]), // expected_vtbl_contents
  &(vtt_ee01050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01050),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11050  : virtual dd1050 {
  int e;
  ~ee11050(); // tgen
  ee11050(); // tgen
};
//SIG(1 ee11050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11050 ::~ee11050(){ note_dtor("ee11050", this);} // tgen
ee11050 ::ee11050(){ note_ctor("ee11050", this);} // tgen

static void Test_ee11050()
{
  extern Class_Descriptor cd_ee11050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11050, buf);
    ee11050 *dp, &lv = *(dp=new (buf) ee11050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee11050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee11050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(32,16), "ee11050");
    check_base_class_offset(lv, (dd1050*), ABISELECT(16,8), "ee11050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11050.e");
    test_class_info(&lv, &cd_ee11050);
    dp->~ee11050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11050(Test_ee11050, "ee11050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11050C1Ev();
extern void _ZN7ee11050D1Ev();
Name_Map name_map_ee11050[] = {
  NSPAIR(_ZN7ee11050C1Ev),
  NSPAIR(_ZN7ee11050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee11050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee11050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11050[0]),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11050[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee11050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee11050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee11050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee11050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee11050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee11050[] = {
  {&(_ZTV7ee11050[5]),  5,14},
  {&(_ZTV7ee11050[9]),  9,14},
  {&(_ZTV7ee11050[13]),  13,14},
  {&(_tg__ZTV6dd1050__7ee11050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee11050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee11050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee11050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11050[];
extern  VTBL_ENTRY _ZTV7ee11050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11050[];
Class_Descriptor cd_ee11050 = {  "ee11050", // class name
  bases_ee11050, 4,
  &(vtc_ee11050[0]), // expected_vtbl_contents
  &(vtt_ee11050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11050),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21050  : dd1050 {
  int e;
  virtual void  foo(); // _ZN7ee210503fooEv
  ~ee21050(); // tgen
  ee21050(); // tgen
};
//SIG(1 ee21050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee21050 ::foo(){vfunc_called(this, "_ZN7ee210503fooEv");}
ee21050 ::~ee21050(){ note_dtor("ee21050", this);} // tgen
ee21050 ::ee21050(){ note_ctor("ee21050", this);} // tgen

static void Test_ee21050()
{
  extern Class_Descriptor cd_ee21050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21050, buf);
    ee21050 *dp, &lv = *(dp=new (buf) ee21050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee21050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee21050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(16,12), "ee21050");
    check_base_class_offset(lv, (dd1050*), 0, "ee21050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21050.e");
    test_class_info(&lv, &cd_ee21050);
    dp->~ee21050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21050(Test_ee21050, "ee21050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21050C1Ev();
extern void _ZN7ee21050D1Ev();
Name_Map name_map_ee21050[] = {
  NSPAIR(_ZN7ee21050C1Ev),
  NSPAIR(_ZN7ee21050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee21050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21050[];
extern void _ZN7ee210503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee21050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21050[0]),
  (VTBL_ENTRY)&_ZN7ee210503fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee21050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee21050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee21050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee21050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee21050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee21050[] = {
  {&(_ZTV7ee21050[4]),  4,10},
  {&(_tg__ZTV6dd1050__7ee21050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee21050[4]),  4,5},
  {&(_ZTV7ee21050[9]),  9,10},
  {&(_tg__ZTV5cc050__7ee21050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee21050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21050[];
extern  VTBL_ENTRY _ZTV7ee21050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21050[];
Class_Descriptor cd_ee21050 = {  "ee21050", // class name
  bases_ee21050, 4,
  &(vtc_ee21050[0]), // expected_vtbl_contents
  &(vtt_ee21050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31050  : virtual dd1050 {
  int e;
  virtual void  foo(); // _ZN7ee310503fooEv
  ~ee31050(); // tgen
  ee31050(); // tgen
};
//SIG(1 ee31050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee31050 ::foo(){vfunc_called(this, "_ZN7ee310503fooEv");}
ee31050 ::~ee31050(){ note_dtor("ee31050", this);} // tgen
ee31050 ::ee31050(){ note_ctor("ee31050", this);} // tgen

static void Test_ee31050()
{
  extern Class_Descriptor cd_ee31050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31050, buf);
    ee31050 *dp, &lv = *(dp=new (buf) ee31050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee31050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee31050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(32,16), "ee31050");
    check_base_class_offset(lv, (dd1050*), ABISELECT(16,8), "ee31050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31050.e");
    test_class_info(&lv, &cd_ee31050);
    dp->~ee31050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31050(Test_ee31050, "ee31050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31050C1Ev();
extern void _ZN7ee31050D1Ev();
Name_Map name_map_ee31050[] = {
  NSPAIR(_ZN7ee31050C1Ev),
  NSPAIR(_ZN7ee31050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee31050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31050[];
extern void _ZN7ee310503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee31050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31050[0]),
  (VTBL_ENTRY)&_ZN7ee310503fooEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31050[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee31050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee31050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee31050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee31050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee31050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee31050[] = {
  {&(_ZTV7ee31050[5]),  5,15},
  {&(_ZTV7ee31050[10]),  10,15},
  {&(_ZTV7ee31050[14]),  14,15},
  {&(_tg__ZTV6dd1050__7ee31050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee31050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee31050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee31050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31050[];
extern  VTBL_ENTRY _ZTV7ee31050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31050[];
Class_Descriptor cd_ee31050 = {  "ee31050", // class name
  bases_ee31050, 4,
  &(vtc_ee31050[0]), // expected_vtbl_contents
  &(vtt_ee31050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31050),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41050  : dd1050 {
  int e;
  virtual void  bar(); // _ZN7ee410503barEv
  ~ee41050(); // tgen
  ee41050(); // tgen
};
//SIG(1 ee41050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee41050 ::bar(){vfunc_called(this, "_ZN7ee410503barEv");}
ee41050 ::~ee41050(){ note_dtor("ee41050", this);} // tgen
ee41050 ::ee41050(){ note_ctor("ee41050", this);} // tgen

static void Test_ee41050()
{
  extern Class_Descriptor cd_ee41050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41050, buf);
    ee41050 *dp, &lv = *(dp=new (buf) ee41050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee41050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee41050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(16,12), "ee41050");
    check_base_class_offset(lv, (dd1050*), 0, "ee41050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41050.e");
    test_class_info(&lv, &cd_ee41050);
    dp->~ee41050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41050(Test_ee41050, "ee41050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41050C1Ev();
extern void _ZN7ee41050D1Ev();
Name_Map name_map_ee41050[] = {
  NSPAIR(_ZN7ee41050C1Ev),
  NSPAIR(_ZN7ee41050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee41050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41050[];
extern void _ZN7ee410503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee410503barEv,_ZTv0_n16_N7ee410503barEv)();
extern void ABISELECT(_ZThn16_N7ee410503barEv,_ZThn12_N7ee410503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee41050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41050[0]),
  (VTBL_ENTRY)&_ZN7ee410503barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee410503barEv,_ZTv0_n16_N7ee410503barEv),
};
extern VTBL_ENTRY _ZTV7ee41050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee41050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee41050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee41050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee41050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee41050[] = {
  {&(_ZTV7ee41050[4]),  4,10},
  {&(_tg__ZTV6dd1050__7ee41050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee41050[4]),  4,5},
  {&(_ZTV7ee41050[9]),  9,10},
  {&(_tg__ZTV5cc050__7ee41050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee41050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41050[];
extern  VTBL_ENTRY _ZTV7ee41050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41050[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee410503barEv,_ZTv0_n16_N7ee410503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee410503barEv,_ZThn12_N7ee410503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41050 = {  "ee41050", // class name
  bases_ee41050, 4,
  &(vtc_ee41050[0]), // expected_vtbl_contents
  &(vtt_ee41050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51050  : virtual dd1050 {
  int e;
  virtual void  bar(); // _ZN7ee510503barEv
  ~ee51050(); // tgen
  ee51050(); // tgen
};
//SIG(1 ee51050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee51050 ::bar(){vfunc_called(this, "_ZN7ee510503barEv");}
ee51050 ::~ee51050(){ note_dtor("ee51050", this);} // tgen
ee51050 ::ee51050(){ note_ctor("ee51050", this);} // tgen

static void Test_ee51050()
{
  extern Class_Descriptor cd_ee51050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51050, buf);
    ee51050 *dp, &lv = *(dp=new (buf) ee51050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee51050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee51050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(32,16), "ee51050");
    check_base_class_offset(lv, (dd1050*), ABISELECT(16,8), "ee51050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51050.e");
    test_class_info(&lv, &cd_ee51050);
    dp->~ee51050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51050(Test_ee51050, "ee51050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51050C1Ev();
extern void _ZN7ee51050D1Ev();
Name_Map name_map_ee51050[] = {
  NSPAIR(_ZN7ee51050C1Ev),
  NSPAIR(_ZN7ee51050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee51050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51050[];
extern void _ZN7ee510503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee510503barEv,_ZTv0_n16_N7ee510503barEv)();
extern void ABISELECT(_ZThn32_N7ee510503barEv,_ZThn16_N7ee510503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee51050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51050[0]),
  (VTBL_ENTRY)&_ZN7ee510503barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51050[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee510503barEv,_ZTv0_n16_N7ee510503barEv),
};
extern VTBL_ENTRY _ZTV7ee51050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee51050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee51050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee51050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee51050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee51050[] = {
  {&(_ZTV7ee51050[5]),  5,15},
  {&(_ZTV7ee51050[10]),  10,15},
  {&(_ZTV7ee51050[14]),  14,15},
  {&(_tg__ZTV6dd1050__7ee51050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee51050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee51050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee51050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51050[];
extern  VTBL_ENTRY _ZTV7ee51050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51050[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee510503barEv,_ZTv0_n16_N7ee510503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee510503barEv,_ZThn16_N7ee510503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51050 = {  "ee51050", // class name
  bases_ee51050, 4,
  &(vtc_ee51050[0]), // expected_vtbl_contents
  &(vtt_ee51050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51050),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61050  : dd1050 {
  int e;
  virtual void  foo(); // _ZN7ee610503fooEv
  virtual void  bar(); // _ZN7ee610503barEv
  ~ee61050(); // tgen
  ee61050(); // tgen
};
//SIG(1 ee61050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee61050 ::foo(){vfunc_called(this, "_ZN7ee610503fooEv");}
void  ee61050 ::bar(){vfunc_called(this, "_ZN7ee610503barEv");}
ee61050 ::~ee61050(){ note_dtor("ee61050", this);} // tgen
ee61050 ::ee61050(){ note_ctor("ee61050", this);} // tgen

static void Test_ee61050()
{
  extern Class_Descriptor cd_ee61050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61050, buf);
    ee61050 *dp, &lv = *(dp=new (buf) ee61050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee61050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee61050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(16,12), "ee61050");
    check_base_class_offset(lv, (dd1050*), 0, "ee61050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61050.e");
    test_class_info(&lv, &cd_ee61050);
    dp->~ee61050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61050(Test_ee61050, "ee61050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61050C1Ev();
extern void _ZN7ee61050D1Ev();
Name_Map name_map_ee61050[] = {
  NSPAIR(_ZN7ee61050C1Ev),
  NSPAIR(_ZN7ee61050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee61050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61050[];
extern void _ZN7ee610503fooEv();
extern void _ZN7ee610503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee610503barEv,_ZTv0_n16_N7ee610503barEv)();
extern void ABISELECT(_ZThn16_N7ee610503barEv,_ZThn12_N7ee610503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61050[0]),
  (VTBL_ENTRY)&_ZN7ee610503fooEv,
  (VTBL_ENTRY)&_ZN7ee610503barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee610503barEv,_ZTv0_n16_N7ee610503barEv),
};
extern VTBL_ENTRY _ZTV7ee61050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee61050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee61050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee61050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee61050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee61050[] = {
  {&(_ZTV7ee61050[4]),  4,11},
  {&(_tg__ZTV6dd1050__7ee61050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee61050[4]),  4,5},
  {&(_ZTV7ee61050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee61050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee61050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61050[];
extern  VTBL_ENTRY _ZTV7ee61050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61050[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee610503barEv,_ZTv0_n16_N7ee610503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610503barEv,_ZThn12_N7ee610503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61050 = {  "ee61050", // class name
  bases_ee61050, 4,
  &(vtc_ee61050[0]), // expected_vtbl_contents
  &(vtt_ee61050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71050  : virtual dd1050 {
  int e;
  virtual void  foo(); // _ZN7ee710503fooEv
  virtual void  bar(); // _ZN7ee710503barEv
  ~ee71050(); // tgen
  ee71050(); // tgen
};
//SIG(1 ee71050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee71050 ::foo(){vfunc_called(this, "_ZN7ee710503fooEv");}
void  ee71050 ::bar(){vfunc_called(this, "_ZN7ee710503barEv");}
ee71050 ::~ee71050(){ note_dtor("ee71050", this);} // tgen
ee71050 ::ee71050(){ note_ctor("ee71050", this);} // tgen

static void Test_ee71050()
{
  extern Class_Descriptor cd_ee71050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71050, buf);
    ee71050 *dp, &lv = *(dp=new (buf) ee71050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee71050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee71050");
    check_base_class_offset(lv, (cc050*)(dd1050*), ABISELECT(32,16), "ee71050");
    check_base_class_offset(lv, (dd1050*), ABISELECT(16,8), "ee71050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71050.e");
    test_class_info(&lv, &cd_ee71050);
    dp->~ee71050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71050(Test_ee71050, "ee71050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71050C1Ev();
extern void _ZN7ee71050D1Ev();
Name_Map name_map_ee71050[] = {
  NSPAIR(_ZN7ee71050C1Ev),
  NSPAIR(_ZN7ee71050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd1050;
extern VTBL_ENTRY _ZTI6dd1050[];
extern  VTBL_ENTRY _ZTV6dd1050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1050[];
static Base_Class bases_ee71050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1050,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71050[];
extern void _ZN7ee710503fooEv();
extern void _ZN7ee710503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee710503barEv,_ZTv0_n16_N7ee710503barEv)();
extern void ABISELECT(_ZThn32_N7ee710503barEv,_ZThn16_N7ee710503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71050[0]),
  (VTBL_ENTRY)&_ZN7ee710503fooEv,
  (VTBL_ENTRY)&_ZN7ee710503barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71050[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee710503barEv,_ZTv0_n16_N7ee710503barEv),
};
extern VTBL_ENTRY _ZTV7ee71050[];
static  VTBL_ENTRY _tg__ZTV6dd1050__7ee71050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd1050__7ee71050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee71050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee71050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee71050[] = {
  {&(_ZTV7ee71050[5]),  5,16},
  {&(_ZTV7ee71050[11]),  11,16},
  {&(_ZTV7ee71050[15]),  15,16},
  {&(_tg__ZTV6dd1050__7ee71050[4]),  4,4},
  {&(_tg__ZTV5cc050__6dd1050__7ee71050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee71050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee71050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71050[];
extern  VTBL_ENTRY _ZTV7ee71050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71050[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee710503barEv,_ZTv0_n16_N7ee710503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710503barEv,_ZThn16_N7ee710503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71050 = {  "ee71050", // class name
  bases_ee71050, 4,
  &(vtc_ee71050[0]), // expected_vtbl_contents
  &(vtt_ee71050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71050),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2050  : cc050 {
  int d;
  virtual void  foo(); // _ZN6dd20503fooEv
  ~dd2050(); // tgen
  dd2050(); // tgen
};
//SIG(-1 dd2050) C1{ BC2{ BC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd2050 ::foo(){vfunc_called(this, "_ZN6dd20503fooEv");}
dd2050 ::~dd2050(){ note_dtor("dd2050", this);} // tgen
dd2050 ::dd2050(){ note_ctor("dd2050", this);} // tgen

static void Test_dd2050()
{
  extern Class_Descriptor cd_dd2050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2050, buf);
    dd2050 *dp, &lv = *(dp=new (buf) dd2050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(20,16), "dd2050");
    check_base_class_offset(lv, (bb50*)(cc050*), 0, "dd2050");
    check_base_class_offset(lv, (cc050*), 0, "dd2050");
    check_field_offset(lv, d, ABISELECT(16,12), "dd2050.d");
    test_class_info(&lv, &cd_dd2050);
    dp->~dd2050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2050(Test_dd2050, "dd2050", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2050C1Ev();
extern void _ZN6dd2050D1Ev();
Name_Map name_map_dd2050[] = {
  NSPAIR(_ZN6dd2050C1Ev),
  NSPAIR(_ZN6dd2050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd2050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY vtc_dd2050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern VTBL_ENTRY _ZTV6dd2050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd2050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd2050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd2050[] = {
  {&(_ZTV6dd2050[3]),  3,5},
  {&(_tg__ZTV5cc050__6dd2050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd2050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
Class_Descriptor cd_dd2050 = {  "dd2050", // class name
  bases_dd2050, 3,
  &(vtc_dd2050[0]), // expected_vtbl_contents
  &(vtt_dd2050[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2050),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02050  : dd2050 {
  int e;
  ~ee02050(); // tgen
  ee02050(); // tgen
};
//SIG(1 ee02050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee02050 ::~ee02050(){ note_dtor("ee02050", this);} // tgen
ee02050 ::ee02050(){ note_ctor("ee02050", this);} // tgen

static void Test_ee02050()
{
  extern Class_Descriptor cd_ee02050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02050, buf);
    ee02050 *dp, &lv = *(dp=new (buf) ee02050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(24,20), "ee02050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), 0, "ee02050");
    check_base_class_offset(lv, (cc050*)(dd2050*), 0, "ee02050");
    check_base_class_offset(lv, (dd2050*), 0, "ee02050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee02050.e");
    test_class_info(&lv, &cd_ee02050);
    dp->~ee02050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02050(Test_ee02050, "ee02050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02050C1Ev();
extern void _ZN7ee02050D1Ev();
Name_Map name_map_ee02050[] = {
  NSPAIR(_ZN7ee02050C1Ev),
  NSPAIR(_ZN7ee02050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee02050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY vtc_ee02050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern VTBL_ENTRY _ZTV7ee02050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee02050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee02050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee02050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee02050[] = {
  {&(_ZTV7ee02050[3]),  3,5},
  {&(_tg__ZTV6dd2050__7ee02050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee02050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee02050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee02050[];
extern  VTBL_ENTRY _ZTV7ee02050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02050[];
Class_Descriptor cd_ee02050 = {  "ee02050", // class name
  bases_ee02050, 4,
  &(vtc_ee02050[0]), // expected_vtbl_contents
  &(vtt_ee02050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12050  : virtual dd2050 {
  int e;
  ~ee12050(); // tgen
  ee12050(); // tgen
};
//SIG(1 ee12050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee12050 ::~ee12050(){ note_dtor("ee12050", this);} // tgen
ee12050 ::ee12050(){ note_ctor("ee12050", this);} // tgen

static void Test_ee12050()
{
  extern Class_Descriptor cd_ee12050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12050, buf);
    ee12050 *dp, &lv = *(dp=new (buf) ee12050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(36,24), "ee12050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), ABISELECT(16,8), "ee12050");
    check_base_class_offset(lv, (cc050*)(dd2050*), ABISELECT(16,8), "ee12050");
    check_base_class_offset(lv, (dd2050*), ABISELECT(16,8), "ee12050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12050.e");
    test_class_info(&lv, &cd_ee12050);
    dp->~ee12050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12050(Test_ee12050, "ee12050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12050C1Ev();
extern void _ZN7ee12050D1Ev();
Name_Map name_map_ee12050[] = {
  NSPAIR(_ZN7ee12050C1Ev),
  NSPAIR(_ZN7ee12050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee12050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY vtc_ee12050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12050[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern VTBL_ENTRY _ZTV7ee12050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee12050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee12050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee12050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee12050[] = {
  {&(_ZTV7ee12050[4]),  4,11},
  {&(_ZTV7ee12050[9]),  9,11},
  {&(_tg__ZTV6dd2050__7ee12050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee12050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee12050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee12050[];
extern  VTBL_ENTRY _ZTV7ee12050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12050[];
Class_Descriptor cd_ee12050 = {  "ee12050", // class name
  bases_ee12050, 4,
  &(vtc_ee12050[0]), // expected_vtbl_contents
  &(vtt_ee12050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22050  : dd2050 {
  int e;
  virtual void  foo(); // _ZN7ee220503fooEv
  ~ee22050(); // tgen
  ee22050(); // tgen
};
//SIG(1 ee22050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee22050 ::foo(){vfunc_called(this, "_ZN7ee220503fooEv");}
ee22050 ::~ee22050(){ note_dtor("ee22050", this);} // tgen
ee22050 ::ee22050(){ note_ctor("ee22050", this);} // tgen

static void Test_ee22050()
{
  extern Class_Descriptor cd_ee22050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22050, buf);
    ee22050 *dp, &lv = *(dp=new (buf) ee22050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(24,20), "ee22050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), 0, "ee22050");
    check_base_class_offset(lv, (cc050*)(dd2050*), 0, "ee22050");
    check_base_class_offset(lv, (dd2050*), 0, "ee22050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee22050.e");
    test_class_info(&lv, &cd_ee22050);
    dp->~ee22050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22050(Test_ee22050, "ee22050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22050C1Ev();
extern void _ZN7ee22050D1Ev();
Name_Map name_map_ee22050[] = {
  NSPAIR(_ZN7ee22050C1Ev),
  NSPAIR(_ZN7ee22050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee22050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22050[];
extern void _ZN4bb503barEv();
extern void _ZN7ee220503fooEv();
static  VTBL_ENTRY vtc_ee22050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN7ee220503fooEv,
};
extern VTBL_ENTRY _ZTV7ee22050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee22050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee22050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee22050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee22050[] = {
  {&(_ZTV7ee22050[3]),  3,5},
  {&(_tg__ZTV6dd2050__7ee22050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee22050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee22050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee22050[];
extern  VTBL_ENTRY _ZTV7ee22050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22050[];
Class_Descriptor cd_ee22050 = {  "ee22050", // class name
  bases_ee22050, 4,
  &(vtc_ee22050[0]), // expected_vtbl_contents
  &(vtt_ee22050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32050  : virtual dd2050 {
  int e;
  virtual void  foo(); // _ZN7ee320503fooEv
  ~ee32050(); // tgen
  ee32050(); // tgen
};
//SIG(1 ee32050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee32050 ::foo(){vfunc_called(this, "_ZN7ee320503fooEv");}
ee32050 ::~ee32050(){ note_dtor("ee32050", this);} // tgen
ee32050 ::ee32050(){ note_ctor("ee32050", this);} // tgen

static void Test_ee32050()
{
  extern Class_Descriptor cd_ee32050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32050, buf);
    ee32050 *dp, &lv = *(dp=new (buf) ee32050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(36,24), "ee32050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), ABISELECT(16,8), "ee32050");
    check_base_class_offset(lv, (cc050*)(dd2050*), ABISELECT(16,8), "ee32050");
    check_base_class_offset(lv, (dd2050*), ABISELECT(16,8), "ee32050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32050.e");
    test_class_info(&lv, &cd_ee32050);
    dp->~ee32050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32050(Test_ee32050, "ee32050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32050C1Ev();
extern void _ZN7ee32050D1Ev();
Name_Map name_map_ee32050[] = {
  NSPAIR(_ZN7ee32050C1Ev),
  NSPAIR(_ZN7ee32050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee32050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32050[];
extern void _ZN7ee320503fooEv();
extern void _ZN4bb503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee320503fooEv,_ZTv0_n20_N7ee320503fooEv)();
extern void ABISELECT(_ZThn16_N7ee320503fooEv,_ZThn8_N7ee320503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32050[0]),
  (VTBL_ENTRY)&_ZN7ee320503fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee320503fooEv,_ZTv0_n20_N7ee320503fooEv),
};
extern VTBL_ENTRY _ZTV7ee32050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee32050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee32050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee32050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee32050[] = {
  {&(_ZTV7ee32050[4]),  4,12},
  {&(_ZTV7ee32050[10]),  10,12},
  {&(_tg__ZTV6dd2050__7ee32050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee32050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee32050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee32050[];
extern  VTBL_ENTRY _ZTV7ee32050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32050[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee320503fooEv,_ZTv0_n20_N7ee320503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320503fooEv,_ZThn8_N7ee320503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32050 = {  "ee32050", // class name
  bases_ee32050, 4,
  &(vtc_ee32050[0]), // expected_vtbl_contents
  &(vtt_ee32050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32050),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42050  : dd2050 {
  int e;
  virtual void  bar(); // _ZN7ee420503barEv
  ~ee42050(); // tgen
  ee42050(); // tgen
};
//SIG(1 ee42050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee42050 ::bar(){vfunc_called(this, "_ZN7ee420503barEv");}
ee42050 ::~ee42050(){ note_dtor("ee42050", this);} // tgen
ee42050 ::ee42050(){ note_ctor("ee42050", this);} // tgen

static void Test_ee42050()
{
  extern Class_Descriptor cd_ee42050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42050, buf);
    ee42050 *dp, &lv = *(dp=new (buf) ee42050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(24,20), "ee42050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), 0, "ee42050");
    check_base_class_offset(lv, (cc050*)(dd2050*), 0, "ee42050");
    check_base_class_offset(lv, (dd2050*), 0, "ee42050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee42050.e");
    test_class_info(&lv, &cd_ee42050);
    dp->~ee42050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42050(Test_ee42050, "ee42050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42050C1Ev();
extern void _ZN7ee42050D1Ev();
Name_Map name_map_ee42050[] = {
  NSPAIR(_ZN7ee42050C1Ev),
  NSPAIR(_ZN7ee42050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee42050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42050[];
extern void _ZN7ee420503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY vtc_ee42050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42050[0]),
  (VTBL_ENTRY)&_ZN7ee420503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern VTBL_ENTRY _ZTV7ee42050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee42050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee42050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee42050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee42050[] = {
  {&(_ZTV7ee42050[3]),  3,5},
  {&(_tg__ZTV6dd2050__7ee42050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee42050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee42050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee42050[];
extern  VTBL_ENTRY _ZTV7ee42050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42050[];
Class_Descriptor cd_ee42050 = {  "ee42050", // class name
  bases_ee42050, 4,
  &(vtc_ee42050[0]), // expected_vtbl_contents
  &(vtt_ee42050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52050  : virtual dd2050 {
  int e;
  virtual void  bar(); // _ZN7ee520503barEv
  ~ee52050(); // tgen
  ee52050(); // tgen
};
//SIG(1 ee52050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee52050 ::bar(){vfunc_called(this, "_ZN7ee520503barEv");}
ee52050 ::~ee52050(){ note_dtor("ee52050", this);} // tgen
ee52050 ::ee52050(){ note_ctor("ee52050", this);} // tgen

static void Test_ee52050()
{
  extern Class_Descriptor cd_ee52050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52050, buf);
    ee52050 *dp, &lv = *(dp=new (buf) ee52050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(36,24), "ee52050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), ABISELECT(16,8), "ee52050");
    check_base_class_offset(lv, (cc050*)(dd2050*), ABISELECT(16,8), "ee52050");
    check_base_class_offset(lv, (dd2050*), ABISELECT(16,8), "ee52050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52050.e");
    test_class_info(&lv, &cd_ee52050);
    dp->~ee52050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52050(Test_ee52050, "ee52050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52050C1Ev();
extern void _ZN7ee52050D1Ev();
Name_Map name_map_ee52050[] = {
  NSPAIR(_ZN7ee52050C1Ev),
  NSPAIR(_ZN7ee52050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee52050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52050[];
extern void _ZN7ee520503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee520503barEv,_ZTv0_n16_N7ee520503barEv)();
extern void ABISELECT(_ZThn16_N7ee520503barEv,_ZThn8_N7ee520503barEv)() __attribute__((weak));
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY vtc_ee52050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52050[0]),
  (VTBL_ENTRY)&_ZN7ee520503barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee520503barEv,_ZTv0_n16_N7ee520503barEv),
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern VTBL_ENTRY _ZTV7ee52050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee52050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee52050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee52050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee52050[] = {
  {&(_ZTV7ee52050[4]),  4,12},
  {&(_ZTV7ee52050[10]),  10,12},
  {&(_tg__ZTV6dd2050__7ee52050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee52050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee52050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee52050[];
extern  VTBL_ENTRY _ZTV7ee52050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52050[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee520503barEv,_ZTv0_n16_N7ee520503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee520503barEv,_ZThn8_N7ee520503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52050 = {  "ee52050", // class name
  bases_ee52050, 4,
  &(vtc_ee52050[0]), // expected_vtbl_contents
  &(vtt_ee52050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52050),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62050  : dd2050 {
  int e;
  virtual void  foo(); // _ZN7ee620503fooEv
  virtual void  bar(); // _ZN7ee620503barEv
  ~ee62050(); // tgen
  ee62050(); // tgen
};
//SIG(1 ee62050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62050 ::foo(){vfunc_called(this, "_ZN7ee620503fooEv");}
void  ee62050 ::bar(){vfunc_called(this, "_ZN7ee620503barEv");}
ee62050 ::~ee62050(){ note_dtor("ee62050", this);} // tgen
ee62050 ::ee62050(){ note_ctor("ee62050", this);} // tgen

static void Test_ee62050()
{
  extern Class_Descriptor cd_ee62050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62050, buf);
    ee62050 *dp, &lv = *(dp=new (buf) ee62050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(24,20), "ee62050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), 0, "ee62050");
    check_base_class_offset(lv, (cc050*)(dd2050*), 0, "ee62050");
    check_base_class_offset(lv, (dd2050*), 0, "ee62050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee62050.e");
    test_class_info(&lv, &cd_ee62050);
    dp->~ee62050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62050(Test_ee62050, "ee62050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62050C1Ev();
extern void _ZN7ee62050D1Ev();
Name_Map name_map_ee62050[] = {
  NSPAIR(_ZN7ee62050C1Ev),
  NSPAIR(_ZN7ee62050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee62050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62050[];
extern void _ZN7ee620503barEv();
extern void _ZN7ee620503fooEv();
static  VTBL_ENTRY vtc_ee62050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62050[0]),
  (VTBL_ENTRY)&_ZN7ee620503barEv,
  (VTBL_ENTRY)&_ZN7ee620503fooEv,
};
extern VTBL_ENTRY _ZTV7ee62050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee62050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee62050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee62050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee62050[] = {
  {&(_ZTV7ee62050[3]),  3,5},
  {&(_tg__ZTV6dd2050__7ee62050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee62050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee62050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee62050[];
extern  VTBL_ENTRY _ZTV7ee62050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62050[];
Class_Descriptor cd_ee62050 = {  "ee62050", // class name
  bases_ee62050, 4,
  &(vtc_ee62050[0]), // expected_vtbl_contents
  &(vtt_ee62050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72050  : virtual dd2050 {
  int e;
  virtual void  foo(); // _ZN7ee720503fooEv
  virtual void  bar(); // _ZN7ee720503barEv
  ~ee72050(); // tgen
  ee72050(); // tgen
};
//SIG(1 ee72050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72050 ::foo(){vfunc_called(this, "_ZN7ee720503fooEv");}
void  ee72050 ::bar(){vfunc_called(this, "_ZN7ee720503barEv");}
ee72050 ::~ee72050(){ note_dtor("ee72050", this);} // tgen
ee72050 ::ee72050(){ note_ctor("ee72050", this);} // tgen

static void Test_ee72050()
{
  extern Class_Descriptor cd_ee72050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72050, buf);
    ee72050 *dp, &lv = *(dp=new (buf) ee72050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd2050*), ABISELECT(36,24), "ee72050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd2050*), ABISELECT(16,8), "ee72050");
    check_base_class_offset(lv, (cc050*)(dd2050*), ABISELECT(16,8), "ee72050");
    check_base_class_offset(lv, (dd2050*), ABISELECT(16,8), "ee72050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72050.e");
    test_class_info(&lv, &cd_ee72050);
    dp->~ee72050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72050(Test_ee72050, "ee72050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72050C1Ev();
extern void _ZN7ee72050D1Ev();
Name_Map name_map_ee72050[] = {
  NSPAIR(_ZN7ee72050C1Ev),
  NSPAIR(_ZN7ee72050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd2050;
extern VTBL_ENTRY _ZTI6dd2050[];
extern  VTBL_ENTRY _ZTV6dd2050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2050[];
static Base_Class bases_ee72050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72050[];
extern void _ZN7ee720503fooEv();
extern void _ZN7ee720503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee720503barEv,_ZTv0_n16_N7ee720503barEv)();
extern void ABISELECT(_ZThn16_N7ee720503barEv,_ZThn8_N7ee720503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee720503fooEv,_ZTv0_n20_N7ee720503fooEv)();
extern void ABISELECT(_ZThn16_N7ee720503fooEv,_ZThn8_N7ee720503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72050[0]),
  (VTBL_ENTRY)&_ZN7ee720503fooEv,
  (VTBL_ENTRY)&_ZN7ee720503barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee720503barEv,_ZTv0_n16_N7ee720503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee720503fooEv,_ZTv0_n20_N7ee720503fooEv),
};
extern VTBL_ENTRY _ZTV7ee72050[];
extern void _ZN4bb503barEv();
extern void _ZN6dd20503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2050__7ee72050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd20503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd2050__7ee72050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd2050__7ee72050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee72050[] = {
  {&(_ZTV7ee72050[4]),  4,13},
  {&(_ZTV7ee72050[11]),  11,13},
  {&(_tg__ZTV6dd2050__7ee72050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd2050__7ee72050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd2050__7ee72050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee72050[];
extern  VTBL_ENTRY _ZTV7ee72050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72050[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee720503fooEv,_ZTv0_n20_N7ee720503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720503fooEv,_ZThn8_N7ee720503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee720503barEv,_ZTv0_n16_N7ee720503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720503barEv,_ZThn8_N7ee720503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72050 = {  "ee72050", // class name
  bases_ee72050, 4,
  &(vtc_ee72050[0]), // expected_vtbl_contents
  &(vtt_ee72050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72050),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3050  : virtual cc050 {
  int d;
  virtual void  foo(); // _ZN6dd30503fooEv
  ~dd3050(); // tgen
  dd3050(); // tgen
};
//SIG(-1 dd3050) C1{ VBC2{ BC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd3050 ::foo(){vfunc_called(this, "_ZN6dd30503fooEv");}
dd3050 ::~dd3050(){ note_dtor("dd3050", this);} // tgen
dd3050 ::dd3050(){ note_ctor("dd3050", this);} // tgen

static void Test_dd3050()
{
  extern Class_Descriptor cd_dd3050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3050, buf);
    dd3050 *dp, &lv = *(dp=new (buf) dd3050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,20), "dd3050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,8), "dd3050");
    check_base_class_offset(lv, (cc050*), ABISELECT(16,8), "dd3050");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3050.d");
    test_class_info(&lv, &cd_dd3050);
    dp->~dd3050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3050(Test_dd3050, "dd3050", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3050C1Ev();
extern void _ZN6dd3050D1Ev();
Name_Map name_map_dd3050[] = {
  NSPAIR(_ZN6dd3050C1Ev),
  NSPAIR(_ZN6dd3050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd3050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3050[];
extern void _ZN6dd30503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_dd3050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV6dd3050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd3050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd3050[] = {
  {&(_ZTV6dd3050[4]),  4,10},
  {&(_ZTV6dd3050[9]),  9,10},
  {&(_tg__ZTV5cc050__6dd3050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd3050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
Class_Descriptor cd_dd3050 = {  "dd3050", // class name
  bases_dd3050, 3,
  &(vtc_dd3050[0]), // expected_vtbl_contents
  &(vtt_dd3050[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3050),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03050  : dd3050 {
  int e;
  ~ee03050(); // tgen
  ee03050(); // tgen
};
//SIG(1 ee03050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee03050 ::~ee03050(){ note_dtor("ee03050", this);} // tgen
ee03050 ::ee03050(){ note_ctor("ee03050", this);} // tgen

static void Test_ee03050()
{
  extern Class_Descriptor cd_ee03050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03050, buf);
    ee03050 *dp, &lv = *(dp=new (buf) ee03050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee03050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee03050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(16,12), "ee03050");
    check_base_class_offset(lv, (dd3050*), 0, "ee03050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03050.e");
    test_class_info(&lv, &cd_ee03050);
    dp->~ee03050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03050(Test_ee03050, "ee03050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03050C1Ev();
extern void _ZN7ee03050D1Ev();
Name_Map name_map_ee03050[] = {
  NSPAIR(_ZN7ee03050C1Ev),
  NSPAIR(_ZN7ee03050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee03050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03050[];
extern void _ZN6dd30503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee03050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee03050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee03050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee03050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee03050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee03050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee03050[] = {
  {&(_ZTV7ee03050[4]),  4,10},
  {&(_tg__ZTV6dd3050__7ee03050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee03050[4]),  4,5},
  {&(_ZTV7ee03050[9]),  9,10},
  {&(_tg__ZTV5cc050__7ee03050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee03050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee03050[];
extern  VTBL_ENTRY _ZTV7ee03050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03050[];
Class_Descriptor cd_ee03050 = {  "ee03050", // class name
  bases_ee03050, 4,
  &(vtc_ee03050[0]), // expected_vtbl_contents
  &(vtt_ee03050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13050  : virtual dd3050 {
  int e;
  ~ee13050(); // tgen
  ee13050(); // tgen
};
//SIG(1 ee13050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee13050 ::~ee13050(){ note_dtor("ee13050", this);} // tgen
ee13050 ::ee13050(){ note_ctor("ee13050", this);} // tgen

static void Test_ee13050()
{
  extern Class_Descriptor cd_ee13050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13050, buf);
    ee13050 *dp, &lv = *(dp=new (buf) ee13050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee13050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee13050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(32,16), "ee13050");
    check_base_class_offset(lv, (dd3050*), ABISELECT(16,8), "ee13050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13050.e");
    test_class_info(&lv, &cd_ee13050);
    dp->~ee13050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13050(Test_ee13050, "ee13050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13050C1Ev();
extern void _ZN7ee13050D1Ev();
Name_Map name_map_ee13050[] = {
  NSPAIR(_ZN7ee13050C1Ev),
  NSPAIR(_ZN7ee13050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee13050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13050[];
extern void _ZN6dd30503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee13050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13050[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee13050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee13050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee13050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee13050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee13050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee13050[] = {
  {&(_ZTV7ee13050[5]),  5,16},
  {&(_ZTV7ee13050[10]),  10,16},
  {&(_ZTV7ee13050[15]),  15,16},
  {&(_tg__ZTV6dd3050__7ee13050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee13050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee13050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee13050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13050[];
extern  VTBL_ENTRY _ZTV7ee13050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13050[];
Class_Descriptor cd_ee13050 = {  "ee13050", // class name
  bases_ee13050, 4,
  &(vtc_ee13050[0]), // expected_vtbl_contents
  &(vtt_ee13050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13050),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23050  : dd3050 {
  int e;
  virtual void  foo(); // _ZN7ee230503fooEv
  ~ee23050(); // tgen
  ee23050(); // tgen
};
//SIG(1 ee23050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee23050 ::foo(){vfunc_called(this, "_ZN7ee230503fooEv");}
ee23050 ::~ee23050(){ note_dtor("ee23050", this);} // tgen
ee23050 ::ee23050(){ note_ctor("ee23050", this);} // tgen

static void Test_ee23050()
{
  extern Class_Descriptor cd_ee23050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23050, buf);
    ee23050 *dp, &lv = *(dp=new (buf) ee23050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee23050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee23050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(16,12), "ee23050");
    check_base_class_offset(lv, (dd3050*), 0, "ee23050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23050.e");
    test_class_info(&lv, &cd_ee23050);
    dp->~ee23050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23050(Test_ee23050, "ee23050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23050C1Ev();
extern void _ZN7ee23050D1Ev();
Name_Map name_map_ee23050[] = {
  NSPAIR(_ZN7ee23050C1Ev),
  NSPAIR(_ZN7ee23050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee23050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23050[];
extern void _ZN7ee230503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee23050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23050[0]),
  (VTBL_ENTRY)&_ZN7ee230503fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee23050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee23050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee23050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee23050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee23050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee23050[] = {
  {&(_ZTV7ee23050[4]),  4,10},
  {&(_tg__ZTV6dd3050__7ee23050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee23050[4]),  4,5},
  {&(_ZTV7ee23050[9]),  9,10},
  {&(_tg__ZTV5cc050__7ee23050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee23050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee23050[];
extern  VTBL_ENTRY _ZTV7ee23050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23050[];
Class_Descriptor cd_ee23050 = {  "ee23050", // class name
  bases_ee23050, 4,
  &(vtc_ee23050[0]), // expected_vtbl_contents
  &(vtt_ee23050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33050  : virtual dd3050 {
  int e;
  virtual void  foo(); // _ZN7ee330503fooEv
  ~ee33050(); // tgen
  ee33050(); // tgen
};
//SIG(1 ee33050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee33050 ::foo(){vfunc_called(this, "_ZN7ee330503fooEv");}
ee33050 ::~ee33050(){ note_dtor("ee33050", this);} // tgen
ee33050 ::ee33050(){ note_ctor("ee33050", this);} // tgen

static void Test_ee33050()
{
  extern Class_Descriptor cd_ee33050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33050, buf);
    ee33050 *dp, &lv = *(dp=new (buf) ee33050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee33050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee33050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(32,16), "ee33050");
    check_base_class_offset(lv, (dd3050*), ABISELECT(16,8), "ee33050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33050.e");
    test_class_info(&lv, &cd_ee33050);
    dp->~ee33050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33050(Test_ee33050, "ee33050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33050C1Ev();
extern void _ZN7ee33050D1Ev();
Name_Map name_map_ee33050[] = {
  NSPAIR(_ZN7ee33050C1Ev),
  NSPAIR(_ZN7ee33050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee33050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33050[];
extern void _ZN7ee330503fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee330503fooEv,_ZTv0_n20_N7ee330503fooEv)();
extern void ABISELECT(_ZThn16_N7ee330503fooEv,_ZThn8_N7ee330503fooEv)() __attribute__((weak));
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee33050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33050[0]),
  (VTBL_ENTRY)&_ZN7ee330503fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee330503fooEv,_ZTv0_n20_N7ee330503fooEv),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee33050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee33050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee33050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee33050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee33050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee33050[] = {
  {&(_ZTV7ee33050[5]),  5,17},
  {&(_ZTV7ee33050[11]),  11,17},
  {&(_ZTV7ee33050[16]),  16,17},
  {&(_tg__ZTV6dd3050__7ee33050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee33050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee33050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee33050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33050[];
extern  VTBL_ENTRY _ZTV7ee33050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33050[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee330503fooEv,_ZTv0_n20_N7ee330503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330503fooEv,_ZThn8_N7ee330503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33050 = {  "ee33050", // class name
  bases_ee33050, 4,
  &(vtc_ee33050[0]), // expected_vtbl_contents
  &(vtt_ee33050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33050),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43050  : dd3050 {
  int e;
  virtual void  bar(); // _ZN7ee430503barEv
  ~ee43050(); // tgen
  ee43050(); // tgen
};
//SIG(1 ee43050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee43050 ::bar(){vfunc_called(this, "_ZN7ee430503barEv");}
ee43050 ::~ee43050(){ note_dtor("ee43050", this);} // tgen
ee43050 ::ee43050(){ note_ctor("ee43050", this);} // tgen

static void Test_ee43050()
{
  extern Class_Descriptor cd_ee43050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43050, buf);
    ee43050 *dp, &lv = *(dp=new (buf) ee43050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee43050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee43050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(16,12), "ee43050");
    check_base_class_offset(lv, (dd3050*), 0, "ee43050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43050.e");
    test_class_info(&lv, &cd_ee43050);
    dp->~ee43050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43050(Test_ee43050, "ee43050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43050C1Ev();
extern void _ZN7ee43050D1Ev();
Name_Map name_map_ee43050[] = {
  NSPAIR(_ZN7ee43050C1Ev),
  NSPAIR(_ZN7ee43050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee43050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43050[];
extern void _ZN6dd30503fooEv();
extern void _ZN7ee430503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee430503barEv,_ZTv0_n16_N7ee430503barEv)();
extern void ABISELECT(_ZThn16_N7ee430503barEv,_ZThn12_N7ee430503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
  (VTBL_ENTRY)&_ZN7ee430503barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee430503barEv,_ZTv0_n16_N7ee430503barEv),
};
extern VTBL_ENTRY _ZTV7ee43050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee43050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee43050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee43050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee43050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee43050[] = {
  {&(_ZTV7ee43050[4]),  4,11},
  {&(_tg__ZTV6dd3050__7ee43050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee43050[4]),  4,5},
  {&(_ZTV7ee43050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee43050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee43050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee43050[];
extern  VTBL_ENTRY _ZTV7ee43050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43050[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee430503barEv,_ZTv0_n16_N7ee430503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee430503barEv,_ZThn12_N7ee430503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43050 = {  "ee43050", // class name
  bases_ee43050, 4,
  &(vtc_ee43050[0]), // expected_vtbl_contents
  &(vtt_ee43050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53050  : virtual dd3050 {
  int e;
  virtual void  bar(); // _ZN7ee530503barEv
  ~ee53050(); // tgen
  ee53050(); // tgen
};
//SIG(1 ee53050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee53050 ::bar(){vfunc_called(this, "_ZN7ee530503barEv");}
ee53050 ::~ee53050(){ note_dtor("ee53050", this);} // tgen
ee53050 ::ee53050(){ note_ctor("ee53050", this);} // tgen

static void Test_ee53050()
{
  extern Class_Descriptor cd_ee53050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53050, buf);
    ee53050 *dp, &lv = *(dp=new (buf) ee53050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee53050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee53050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(32,16), "ee53050");
    check_base_class_offset(lv, (dd3050*), ABISELECT(16,8), "ee53050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53050.e");
    test_class_info(&lv, &cd_ee53050);
    dp->~ee53050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53050(Test_ee53050, "ee53050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53050C1Ev();
extern void _ZN7ee53050D1Ev();
Name_Map name_map_ee53050[] = {
  NSPAIR(_ZN7ee53050C1Ev),
  NSPAIR(_ZN7ee53050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee53050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53050[];
extern void _ZN7ee530503barEv();
extern void _ZN6dd30503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee530503barEv,_ZTv0_n16_N7ee530503barEv)();
extern void ABISELECT(_ZThn32_N7ee530503barEv,_ZThn16_N7ee530503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53050[0]),
  (VTBL_ENTRY)&_ZN7ee530503barEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee530503barEv,_ZTv0_n16_N7ee530503barEv),
};
extern VTBL_ENTRY _ZTV7ee53050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee53050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee53050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee53050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee53050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee53050[] = {
  {&(_ZTV7ee53050[5]),  5,17},
  {&(_ZTV7ee53050[11]),  11,17},
  {&(_ZTV7ee53050[16]),  16,17},
  {&(_tg__ZTV6dd3050__7ee53050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee53050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee53050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee53050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53050[];
extern  VTBL_ENTRY _ZTV7ee53050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53050[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee530503barEv,_ZTv0_n16_N7ee530503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee530503barEv,_ZThn16_N7ee530503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53050 = {  "ee53050", // class name
  bases_ee53050, 4,
  &(vtc_ee53050[0]), // expected_vtbl_contents
  &(vtt_ee53050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53050),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63050  : dd3050 {
  int e;
  virtual void  foo(); // _ZN7ee630503fooEv
  virtual void  bar(); // _ZN7ee630503barEv
  ~ee63050(); // tgen
  ee63050(); // tgen
};
//SIG(1 ee63050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63050 ::foo(){vfunc_called(this, "_ZN7ee630503fooEv");}
void  ee63050 ::bar(){vfunc_called(this, "_ZN7ee630503barEv");}
ee63050 ::~ee63050(){ note_dtor("ee63050", this);} // tgen
ee63050 ::ee63050(){ note_ctor("ee63050", this);} // tgen

static void Test_ee63050()
{
  extern Class_Descriptor cd_ee63050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63050, buf);
    ee63050 *dp, &lv = *(dp=new (buf) ee63050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee63050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee63050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(16,12), "ee63050");
    check_base_class_offset(lv, (dd3050*), 0, "ee63050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63050.e");
    test_class_info(&lv, &cd_ee63050);
    dp->~ee63050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63050(Test_ee63050, "ee63050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63050C1Ev();
extern void _ZN7ee63050D1Ev();
Name_Map name_map_ee63050[] = {
  NSPAIR(_ZN7ee63050C1Ev),
  NSPAIR(_ZN7ee63050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee63050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63050[];
extern void _ZN7ee630503fooEv();
extern void _ZN7ee630503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee630503barEv,_ZTv0_n16_N7ee630503barEv)();
extern void ABISELECT(_ZThn16_N7ee630503barEv,_ZThn12_N7ee630503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63050[0]),
  (VTBL_ENTRY)&_ZN7ee630503fooEv,
  (VTBL_ENTRY)&_ZN7ee630503barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee630503barEv,_ZTv0_n16_N7ee630503barEv),
};
extern VTBL_ENTRY _ZTV7ee63050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee63050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee63050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee63050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee63050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee63050[] = {
  {&(_ZTV7ee63050[4]),  4,11},
  {&(_tg__ZTV6dd3050__7ee63050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee63050[4]),  4,5},
  {&(_ZTV7ee63050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee63050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee63050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee63050[];
extern  VTBL_ENTRY _ZTV7ee63050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63050[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee630503barEv,_ZTv0_n16_N7ee630503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630503barEv,_ZThn12_N7ee630503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63050 = {  "ee63050", // class name
  bases_ee63050, 4,
  &(vtc_ee63050[0]), // expected_vtbl_contents
  &(vtt_ee63050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73050  : virtual dd3050 {
  int e;
  virtual void  foo(); // _ZN7ee730503fooEv
  virtual void  bar(); // _ZN7ee730503barEv
  ~ee73050(); // tgen
  ee73050(); // tgen
};
//SIG(1 ee73050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73050 ::foo(){vfunc_called(this, "_ZN7ee730503fooEv");}
void  ee73050 ::bar(){vfunc_called(this, "_ZN7ee730503barEv");}
ee73050 ::~ee73050(){ note_dtor("ee73050", this);} // tgen
ee73050 ::ee73050(){ note_ctor("ee73050", this);} // tgen

static void Test_ee73050()
{
  extern Class_Descriptor cd_ee73050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73050, buf);
    ee73050 *dp, &lv = *(dp=new (buf) ee73050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee73050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee73050");
    check_base_class_offset(lv, (cc050*)(dd3050*), ABISELECT(32,16), "ee73050");
    check_base_class_offset(lv, (dd3050*), ABISELECT(16,8), "ee73050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73050.e");
    test_class_info(&lv, &cd_ee73050);
    dp->~ee73050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73050(Test_ee73050, "ee73050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73050C1Ev();
extern void _ZN7ee73050D1Ev();
Name_Map name_map_ee73050[] = {
  NSPAIR(_ZN7ee73050C1Ev),
  NSPAIR(_ZN7ee73050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd3050;
extern VTBL_ENTRY _ZTI6dd3050[];
extern  VTBL_ENTRY _ZTV6dd3050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3050[];
static Base_Class bases_ee73050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3050,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73050[];
extern void _ZN7ee730503fooEv();
extern void _ZN7ee730503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee730503fooEv,_ZTv0_n20_N7ee730503fooEv)();
extern void ABISELECT(_ZThn16_N7ee730503fooEv,_ZThn8_N7ee730503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee730503barEv,_ZTv0_n16_N7ee730503barEv)();
extern void ABISELECT(_ZThn32_N7ee730503barEv,_ZThn16_N7ee730503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73050[0]),
  (VTBL_ENTRY)&_ZN7ee730503fooEv,
  (VTBL_ENTRY)&_ZN7ee730503barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee730503fooEv,_ZTv0_n20_N7ee730503fooEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730503barEv,_ZTv0_n16_N7ee730503barEv),
};
extern VTBL_ENTRY _ZTV7ee73050[];
extern void _ZN6dd30503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3050__7ee73050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN6dd30503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd3050__7ee73050[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee73050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee73050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee73050[] = {
  {&(_ZTV7ee73050[5]),  5,18},
  {&(_ZTV7ee73050[12]),  12,18},
  {&(_ZTV7ee73050[17]),  17,18},
  {&(_tg__ZTV6dd3050__7ee73050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd3050__7ee73050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee73050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee73050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73050[];
extern  VTBL_ENTRY _ZTV7ee73050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73050[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee730503barEv,_ZTv0_n16_N7ee730503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730503barEv,_ZThn16_N7ee730503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee730503fooEv,_ZTv0_n20_N7ee730503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730503fooEv,_ZThn8_N7ee730503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73050 = {  "ee73050", // class name
  bases_ee73050, 4,
  &(vtc_ee73050[0]), // expected_vtbl_contents
  &(vtt_ee73050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73050),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4050  : cc050 {
  int d;
  virtual void  bar(); // _ZN6dd40503barEv
  ~dd4050(); // tgen
  dd4050(); // tgen
};
//SIG(-1 dd4050) C1{ BC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd4050 ::bar(){vfunc_called(this, "_ZN6dd40503barEv");}
dd4050 ::~dd4050(){ note_dtor("dd4050", this);} // tgen
dd4050 ::dd4050(){ note_ctor("dd4050", this);} // tgen

static void Test_dd4050()
{
  extern Class_Descriptor cd_dd4050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4050, buf);
    dd4050 *dp, &lv = *(dp=new (buf) dd4050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(20,16), "dd4050");
    check_base_class_offset(lv, (bb50*)(cc050*), 0, "dd4050");
    check_base_class_offset(lv, (cc050*), 0, "dd4050");
    check_field_offset(lv, d, ABISELECT(16,12), "dd4050.d");
    test_class_info(&lv, &cd_dd4050);
    dp->~dd4050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4050(Test_dd4050, "dd4050", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4050C1Ev();
extern void _ZN6dd4050D1Ev();
Name_Map name_map_dd4050[] = {
  NSPAIR(_ZN6dd4050C1Ev),
  NSPAIR(_ZN6dd4050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd4050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY vtc_dd4050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern VTBL_ENTRY _ZTV6dd4050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd4050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd4050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd4050[] = {
  {&(_ZTV6dd4050[3]),  3,4},
  {&(_tg__ZTV5cc050__6dd4050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd4050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
Class_Descriptor cd_dd4050 = {  "dd4050", // class name
  bases_dd4050, 3,
  &(vtc_dd4050[0]), // expected_vtbl_contents
  &(vtt_dd4050[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4050),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4050),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04050  : dd4050 {
  int e;
  ~ee04050(); // tgen
  ee04050(); // tgen
};
//SIG(1 ee04050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee04050 ::~ee04050(){ note_dtor("ee04050", this);} // tgen
ee04050 ::ee04050(){ note_ctor("ee04050", this);} // tgen

static void Test_ee04050()
{
  extern Class_Descriptor cd_ee04050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04050, buf);
    ee04050 *dp, &lv = *(dp=new (buf) ee04050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(24,20), "ee04050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), 0, "ee04050");
    check_base_class_offset(lv, (cc050*)(dd4050*), 0, "ee04050");
    check_base_class_offset(lv, (dd4050*), 0, "ee04050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee04050.e");
    test_class_info(&lv, &cd_ee04050);
    dp->~ee04050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04050(Test_ee04050, "ee04050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04050C1Ev();
extern void _ZN7ee04050D1Ev();
Name_Map name_map_ee04050[] = {
  NSPAIR(_ZN7ee04050C1Ev),
  NSPAIR(_ZN7ee04050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee04050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY vtc_ee04050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern VTBL_ENTRY _ZTV7ee04050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee04050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee04050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee04050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee04050[] = {
  {&(_ZTV7ee04050[3]),  3,4},
  {&(_tg__ZTV6dd4050__7ee04050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee04050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee04050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee04050[];
extern  VTBL_ENTRY _ZTV7ee04050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04050[];
Class_Descriptor cd_ee04050 = {  "ee04050", // class name
  bases_ee04050, 4,
  &(vtc_ee04050[0]), // expected_vtbl_contents
  &(vtt_ee04050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04050),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14050  : virtual dd4050 {
  int e;
  ~ee14050(); // tgen
  ee14050(); // tgen
};
//SIG(1 ee14050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee14050 ::~ee14050(){ note_dtor("ee14050", this);} // tgen
ee14050 ::ee14050(){ note_ctor("ee14050", this);} // tgen

static void Test_ee14050()
{
  extern Class_Descriptor cd_ee14050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14050, buf);
    ee14050 *dp, &lv = *(dp=new (buf) ee14050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(36,24), "ee14050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), ABISELECT(16,8), "ee14050");
    check_base_class_offset(lv, (cc050*)(dd4050*), ABISELECT(16,8), "ee14050");
    check_base_class_offset(lv, (dd4050*), ABISELECT(16,8), "ee14050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14050.e");
    test_class_info(&lv, &cd_ee14050);
    dp->~ee14050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14050(Test_ee14050, "ee14050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14050C1Ev();
extern void _ZN7ee14050D1Ev();
Name_Map name_map_ee14050[] = {
  NSPAIR(_ZN7ee14050C1Ev),
  NSPAIR(_ZN7ee14050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee14050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY vtc_ee14050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14050[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern VTBL_ENTRY _ZTV7ee14050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee14050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee14050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee14050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee14050[] = {
  {&(_ZTV7ee14050[4]),  4,9},
  {&(_ZTV7ee14050[8]),  8,9},
  {&(_tg__ZTV6dd4050__7ee14050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee14050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee14050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee14050[];
extern  VTBL_ENTRY _ZTV7ee14050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14050[];
Class_Descriptor cd_ee14050 = {  "ee14050", // class name
  bases_ee14050, 4,
  &(vtc_ee14050[0]), // expected_vtbl_contents
  &(vtt_ee14050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14050),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24050  : dd4050 {
  int e;
  virtual void  foo(); // _ZN7ee240503fooEv
  ~ee24050(); // tgen
  ee24050(); // tgen
};
//SIG(1 ee24050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee24050 ::foo(){vfunc_called(this, "_ZN7ee240503fooEv");}
ee24050 ::~ee24050(){ note_dtor("ee24050", this);} // tgen
ee24050 ::ee24050(){ note_ctor("ee24050", this);} // tgen

static void Test_ee24050()
{
  extern Class_Descriptor cd_ee24050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24050, buf);
    ee24050 *dp, &lv = *(dp=new (buf) ee24050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(24,20), "ee24050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), 0, "ee24050");
    check_base_class_offset(lv, (cc050*)(dd4050*), 0, "ee24050");
    check_base_class_offset(lv, (dd4050*), 0, "ee24050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee24050.e");
    test_class_info(&lv, &cd_ee24050);
    dp->~ee24050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24050(Test_ee24050, "ee24050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24050C1Ev();
extern void _ZN7ee24050D1Ev();
Name_Map name_map_ee24050[] = {
  NSPAIR(_ZN7ee24050C1Ev),
  NSPAIR(_ZN7ee24050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee24050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24050[];
extern void _ZN6dd40503barEv();
extern void _ZN7ee240503fooEv();
static  VTBL_ENTRY vtc_ee24050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
  (VTBL_ENTRY)&_ZN7ee240503fooEv,
};
extern VTBL_ENTRY _ZTV7ee24050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee24050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee24050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee24050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee24050[] = {
  {&(_ZTV7ee24050[3]),  3,5},
  {&(_tg__ZTV6dd4050__7ee24050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee24050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee24050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee24050[];
extern  VTBL_ENTRY _ZTV7ee24050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24050[];
Class_Descriptor cd_ee24050 = {  "ee24050", // class name
  bases_ee24050, 4,
  &(vtc_ee24050[0]), // expected_vtbl_contents
  &(vtt_ee24050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34050  : virtual dd4050 {
  int e;
  virtual void  foo(); // _ZN7ee340503fooEv
  ~ee34050(); // tgen
  ee34050(); // tgen
};
//SIG(1 ee34050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee34050 ::foo(){vfunc_called(this, "_ZN7ee340503fooEv");}
ee34050 ::~ee34050(){ note_dtor("ee34050", this);} // tgen
ee34050 ::ee34050(){ note_ctor("ee34050", this);} // tgen

static void Test_ee34050()
{
  extern Class_Descriptor cd_ee34050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34050, buf);
    ee34050 *dp, &lv = *(dp=new (buf) ee34050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(36,24), "ee34050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), ABISELECT(16,8), "ee34050");
    check_base_class_offset(lv, (cc050*)(dd4050*), ABISELECT(16,8), "ee34050");
    check_base_class_offset(lv, (dd4050*), ABISELECT(16,8), "ee34050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34050.e");
    test_class_info(&lv, &cd_ee34050);
    dp->~ee34050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34050(Test_ee34050, "ee34050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34050C1Ev();
extern void _ZN7ee34050D1Ev();
Name_Map name_map_ee34050[] = {
  NSPAIR(_ZN7ee34050C1Ev),
  NSPAIR(_ZN7ee34050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee34050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34050[];
extern void _ZN7ee340503fooEv();
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY vtc_ee34050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34050[0]),
  (VTBL_ENTRY)&_ZN7ee340503fooEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern VTBL_ENTRY _ZTV7ee34050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee34050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee34050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee34050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee34050[] = {
  {&(_ZTV7ee34050[4]),  4,10},
  {&(_ZTV7ee34050[9]),  9,10},
  {&(_tg__ZTV6dd4050__7ee34050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee34050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee34050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee34050[];
extern  VTBL_ENTRY _ZTV7ee34050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34050[];
Class_Descriptor cd_ee34050 = {  "ee34050", // class name
  bases_ee34050, 4,
  &(vtc_ee34050[0]), // expected_vtbl_contents
  &(vtt_ee34050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44050  : dd4050 {
  int e;
  virtual void  bar(); // _ZN7ee440503barEv
  ~ee44050(); // tgen
  ee44050(); // tgen
};
//SIG(1 ee44050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee44050 ::bar(){vfunc_called(this, "_ZN7ee440503barEv");}
ee44050 ::~ee44050(){ note_dtor("ee44050", this);} // tgen
ee44050 ::ee44050(){ note_ctor("ee44050", this);} // tgen

static void Test_ee44050()
{
  extern Class_Descriptor cd_ee44050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44050, buf);
    ee44050 *dp, &lv = *(dp=new (buf) ee44050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(24,20), "ee44050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), 0, "ee44050");
    check_base_class_offset(lv, (cc050*)(dd4050*), 0, "ee44050");
    check_base_class_offset(lv, (dd4050*), 0, "ee44050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee44050.e");
    test_class_info(&lv, &cd_ee44050);
    dp->~ee44050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44050(Test_ee44050, "ee44050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44050C1Ev();
extern void _ZN7ee44050D1Ev();
Name_Map name_map_ee44050[] = {
  NSPAIR(_ZN7ee44050C1Ev),
  NSPAIR(_ZN7ee44050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee44050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44050[];
extern void _ZN7ee440503barEv();
static  VTBL_ENTRY vtc_ee44050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44050[0]),
  (VTBL_ENTRY)&_ZN7ee440503barEv,
};
extern VTBL_ENTRY _ZTV7ee44050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee44050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee44050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee44050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee44050[] = {
  {&(_ZTV7ee44050[3]),  3,4},
  {&(_tg__ZTV6dd4050__7ee44050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee44050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee44050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee44050[];
extern  VTBL_ENTRY _ZTV7ee44050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44050[];
Class_Descriptor cd_ee44050 = {  "ee44050", // class name
  bases_ee44050, 4,
  &(vtc_ee44050[0]), // expected_vtbl_contents
  &(vtt_ee44050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44050),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54050  : virtual dd4050 {
  int e;
  virtual void  bar(); // _ZN7ee540503barEv
  ~ee54050(); // tgen
  ee54050(); // tgen
};
//SIG(1 ee54050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee54050 ::bar(){vfunc_called(this, "_ZN7ee540503barEv");}
ee54050 ::~ee54050(){ note_dtor("ee54050", this);} // tgen
ee54050 ::ee54050(){ note_ctor("ee54050", this);} // tgen

static void Test_ee54050()
{
  extern Class_Descriptor cd_ee54050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54050, buf);
    ee54050 *dp, &lv = *(dp=new (buf) ee54050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(36,24), "ee54050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), ABISELECT(16,8), "ee54050");
    check_base_class_offset(lv, (cc050*)(dd4050*), ABISELECT(16,8), "ee54050");
    check_base_class_offset(lv, (dd4050*), ABISELECT(16,8), "ee54050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54050.e");
    test_class_info(&lv, &cd_ee54050);
    dp->~ee54050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54050(Test_ee54050, "ee54050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54050C1Ev();
extern void _ZN7ee54050D1Ev();
Name_Map name_map_ee54050[] = {
  NSPAIR(_ZN7ee54050C1Ev),
  NSPAIR(_ZN7ee54050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee54050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54050[];
extern void _ZN7ee540503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee540503barEv,_ZTv0_n16_N7ee540503barEv)();
extern void ABISELECT(_ZThn16_N7ee540503barEv,_ZThn8_N7ee540503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54050[0]),
  (VTBL_ENTRY)&_ZN7ee540503barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee540503barEv,_ZTv0_n16_N7ee540503barEv),
};
extern VTBL_ENTRY _ZTV7ee54050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee54050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee54050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee54050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee54050[] = {
  {&(_ZTV7ee54050[4]),  4,10},
  {&(_ZTV7ee54050[9]),  9,10},
  {&(_tg__ZTV6dd4050__7ee54050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee54050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee54050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee54050[];
extern  VTBL_ENTRY _ZTV7ee54050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54050[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee540503barEv,_ZTv0_n16_N7ee540503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540503barEv,_ZThn8_N7ee540503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54050 = {  "ee54050", // class name
  bases_ee54050, 4,
  &(vtc_ee54050[0]), // expected_vtbl_contents
  &(vtt_ee54050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64050  : dd4050 {
  int e;
  virtual void  foo(); // _ZN7ee640503fooEv
  virtual void  bar(); // _ZN7ee640503barEv
  ~ee64050(); // tgen
  ee64050(); // tgen
};
//SIG(1 ee64050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64050 ::foo(){vfunc_called(this, "_ZN7ee640503fooEv");}
void  ee64050 ::bar(){vfunc_called(this, "_ZN7ee640503barEv");}
ee64050 ::~ee64050(){ note_dtor("ee64050", this);} // tgen
ee64050 ::ee64050(){ note_ctor("ee64050", this);} // tgen

static void Test_ee64050()
{
  extern Class_Descriptor cd_ee64050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64050, buf);
    ee64050 *dp, &lv = *(dp=new (buf) ee64050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(24,20), "ee64050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), 0, "ee64050");
    check_base_class_offset(lv, (cc050*)(dd4050*), 0, "ee64050");
    check_base_class_offset(lv, (dd4050*), 0, "ee64050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee64050.e");
    test_class_info(&lv, &cd_ee64050);
    dp->~ee64050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64050(Test_ee64050, "ee64050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64050C1Ev();
extern void _ZN7ee64050D1Ev();
Name_Map name_map_ee64050[] = {
  NSPAIR(_ZN7ee64050C1Ev),
  NSPAIR(_ZN7ee64050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee64050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64050[];
extern void _ZN7ee640503barEv();
extern void _ZN7ee640503fooEv();
static  VTBL_ENTRY vtc_ee64050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64050[0]),
  (VTBL_ENTRY)&_ZN7ee640503barEv,
  (VTBL_ENTRY)&_ZN7ee640503fooEv,
};
extern VTBL_ENTRY _ZTV7ee64050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee64050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee64050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee64050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee64050[] = {
  {&(_ZTV7ee64050[3]),  3,5},
  {&(_tg__ZTV6dd4050__7ee64050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee64050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee64050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee64050[];
extern  VTBL_ENTRY _ZTV7ee64050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64050[];
Class_Descriptor cd_ee64050 = {  "ee64050", // class name
  bases_ee64050, 4,
  &(vtc_ee64050[0]), // expected_vtbl_contents
  &(vtt_ee64050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74050  : virtual dd4050 {
  int e;
  virtual void  foo(); // _ZN7ee740503fooEv
  virtual void  bar(); // _ZN7ee740503barEv
  ~ee74050(); // tgen
  ee74050(); // tgen
};
//SIG(1 ee74050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74050 ::foo(){vfunc_called(this, "_ZN7ee740503fooEv");}
void  ee74050 ::bar(){vfunc_called(this, "_ZN7ee740503barEv");}
ee74050 ::~ee74050(){ note_dtor("ee74050", this);} // tgen
ee74050 ::ee74050(){ note_ctor("ee74050", this);} // tgen

static void Test_ee74050()
{
  extern Class_Descriptor cd_ee74050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74050, buf);
    ee74050 *dp, &lv = *(dp=new (buf) ee74050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd4050*), ABISELECT(36,24), "ee74050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd4050*), ABISELECT(16,8), "ee74050");
    check_base_class_offset(lv, (cc050*)(dd4050*), ABISELECT(16,8), "ee74050");
    check_base_class_offset(lv, (dd4050*), ABISELECT(16,8), "ee74050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74050.e");
    test_class_info(&lv, &cd_ee74050);
    dp->~ee74050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74050(Test_ee74050, "ee74050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74050C1Ev();
extern void _ZN7ee74050D1Ev();
Name_Map name_map_ee74050[] = {
  NSPAIR(_ZN7ee74050C1Ev),
  NSPAIR(_ZN7ee74050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd4050;
extern VTBL_ENTRY _ZTI6dd4050[];
extern  VTBL_ENTRY _ZTV6dd4050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4050[];
static Base_Class bases_ee74050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74050[];
extern void _ZN7ee740503fooEv();
extern void _ZN7ee740503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee740503barEv,_ZTv0_n16_N7ee740503barEv)();
extern void ABISELECT(_ZThn16_N7ee740503barEv,_ZThn8_N7ee740503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74050[0]),
  (VTBL_ENTRY)&_ZN7ee740503fooEv,
  (VTBL_ENTRY)&_ZN7ee740503barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee740503barEv,_ZTv0_n16_N7ee740503barEv),
};
extern VTBL_ENTRY _ZTV7ee74050[];
extern void _ZN6dd40503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4050__7ee74050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4050[0]),
  (VTBL_ENTRY)&_ZN6dd40503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd4050__7ee74050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd4050__7ee74050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee74050[] = {
  {&(_ZTV7ee74050[4]),  4,11},
  {&(_ZTV7ee74050[10]),  10,11},
  {&(_tg__ZTV6dd4050__7ee74050[3]),  3,4},
  {&(_tg__ZTV5cc0506dd4050__7ee74050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd4050__7ee74050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee74050[];
extern  VTBL_ENTRY _ZTV7ee74050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74050[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee740503barEv,_ZTv0_n16_N7ee740503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740503barEv,_ZThn8_N7ee740503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74050 = {  "ee74050", // class name
  bases_ee74050, 4,
  &(vtc_ee74050[0]), // expected_vtbl_contents
  &(vtt_ee74050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5050  : virtual cc050 {
  int d;
  virtual void  bar(); // _ZN6dd50503barEv
  ~dd5050(); // tgen
  dd5050(); // tgen
};
//SIG(-1 dd5050) C1{ VBC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd5050 ::bar(){vfunc_called(this, "_ZN6dd50503barEv");}
dd5050 ::~dd5050(){ note_dtor("dd5050", this);} // tgen
dd5050 ::dd5050(){ note_ctor("dd5050", this);} // tgen

static void Test_dd5050()
{
  extern Class_Descriptor cd_dd5050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5050, buf);
    dd5050 *dp, &lv = *(dp=new (buf) dd5050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,20), "dd5050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,8), "dd5050");
    check_base_class_offset(lv, (cc050*), ABISELECT(16,8), "dd5050");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5050.d");
    test_class_info(&lv, &cd_dd5050);
    dp->~dd5050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5050(Test_dd5050, "dd5050", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5050C1Ev();
extern void _ZN6dd5050D1Ev();
Name_Map name_map_dd5050[] = {
  NSPAIR(_ZN6dd5050C1Ev),
  NSPAIR(_ZN6dd5050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd5050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5050[];
extern void _ZN6dd50503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd5050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern VTBL_ENTRY _ZTV6dd5050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd5050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd5050[] = {
  {&(_ZTV6dd5050[4]),  4,10},
  {&(_ZTV6dd5050[9]),  9,10},
  {&(_tg__ZTV5cc050__6dd5050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd5050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5050 = {  "dd5050", // class name
  bases_dd5050, 3,
  &(vtc_dd5050[0]), // expected_vtbl_contents
  &(vtt_dd5050[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5050),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05050  : dd5050 {
  int e;
  ~ee05050(); // tgen
  ee05050(); // tgen
};
//SIG(1 ee05050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee05050 ::~ee05050(){ note_dtor("ee05050", this);} // tgen
ee05050 ::ee05050(){ note_ctor("ee05050", this);} // tgen

static void Test_ee05050()
{
  extern Class_Descriptor cd_ee05050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05050, buf);
    ee05050 *dp, &lv = *(dp=new (buf) ee05050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee05050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee05050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(16,12), "ee05050");
    check_base_class_offset(lv, (dd5050*), 0, "ee05050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05050.e");
    test_class_info(&lv, &cd_ee05050);
    dp->~ee05050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05050(Test_ee05050, "ee05050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05050C1Ev();
extern void _ZN7ee05050D1Ev();
Name_Map name_map_ee05050[] = {
  NSPAIR(_ZN7ee05050C1Ev),
  NSPAIR(_ZN7ee05050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee05050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05050[];
extern void _ZN6dd50503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee05050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern VTBL_ENTRY _ZTV7ee05050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee05050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee05050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee05050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee05050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee05050[] = {
  {&(_ZTV7ee05050[4]),  4,10},
  {&(_tg__ZTV6dd5050__7ee05050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee05050[4]),  4,5},
  {&(_ZTV7ee05050[9]),  9,10},
  {&(_tg__ZTV5cc050__7ee05050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee05050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee05050[];
extern  VTBL_ENTRY _ZTV7ee05050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05050[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05050 = {  "ee05050", // class name
  bases_ee05050, 4,
  &(vtc_ee05050[0]), // expected_vtbl_contents
  &(vtt_ee05050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15050  : virtual dd5050 {
  int e;
  ~ee15050(); // tgen
  ee15050(); // tgen
};
//SIG(1 ee15050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee15050 ::~ee15050(){ note_dtor("ee15050", this);} // tgen
ee15050 ::ee15050(){ note_ctor("ee15050", this);} // tgen

static void Test_ee15050()
{
  extern Class_Descriptor cd_ee15050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15050, buf);
    ee15050 *dp, &lv = *(dp=new (buf) ee15050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee15050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee15050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(32,16), "ee15050");
    check_base_class_offset(lv, (dd5050*), ABISELECT(16,8), "ee15050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15050.e");
    test_class_info(&lv, &cd_ee15050);
    dp->~ee15050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15050(Test_ee15050, "ee15050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15050C1Ev();
extern void _ZN7ee15050D1Ev();
Name_Map name_map_ee15050[] = {
  NSPAIR(_ZN7ee15050C1Ev),
  NSPAIR(_ZN7ee15050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee15050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15050[];
extern void _ZN6dd50503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee15050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15050[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern VTBL_ENTRY _ZTV7ee15050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee15050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee15050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee15050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee15050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee15050[] = {
  {&(_ZTV7ee15050[5]),  5,16},
  {&(_ZTV7ee15050[10]),  10,16},
  {&(_ZTV7ee15050[15]),  15,16},
  {&(_tg__ZTV6dd5050__7ee15050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee15050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee15050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee15050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15050[];
extern  VTBL_ENTRY _ZTV7ee15050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15050[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15050 = {  "ee15050", // class name
  bases_ee15050, 4,
  &(vtc_ee15050[0]), // expected_vtbl_contents
  &(vtt_ee15050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15050),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25050  : dd5050 {
  int e;
  virtual void  foo(); // _ZN7ee250503fooEv
  ~ee25050(); // tgen
  ee25050(); // tgen
};
//SIG(1 ee25050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee25050 ::foo(){vfunc_called(this, "_ZN7ee250503fooEv");}
ee25050 ::~ee25050(){ note_dtor("ee25050", this);} // tgen
ee25050 ::ee25050(){ note_ctor("ee25050", this);} // tgen

static void Test_ee25050()
{
  extern Class_Descriptor cd_ee25050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25050, buf);
    ee25050 *dp, &lv = *(dp=new (buf) ee25050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee25050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee25050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(16,12), "ee25050");
    check_base_class_offset(lv, (dd5050*), 0, "ee25050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25050.e");
    test_class_info(&lv, &cd_ee25050);
    dp->~ee25050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25050(Test_ee25050, "ee25050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25050C1Ev();
extern void _ZN7ee25050D1Ev();
Name_Map name_map_ee25050[] = {
  NSPAIR(_ZN7ee25050C1Ev),
  NSPAIR(_ZN7ee25050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee25050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25050[];
extern void _ZN6dd50503barEv();
extern void _ZN7ee250503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
  (VTBL_ENTRY)&_ZN7ee250503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern VTBL_ENTRY _ZTV7ee25050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee25050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee25050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee25050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee25050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee25050[] = {
  {&(_ZTV7ee25050[4]),  4,11},
  {&(_tg__ZTV6dd5050__7ee25050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee25050[4]),  4,5},
  {&(_ZTV7ee25050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee25050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee25050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee25050[];
extern  VTBL_ENTRY _ZTV7ee25050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25050[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25050 = {  "ee25050", // class name
  bases_ee25050, 4,
  &(vtc_ee25050[0]), // expected_vtbl_contents
  &(vtt_ee25050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35050  : virtual dd5050 {
  int e;
  virtual void  foo(); // _ZN7ee350503fooEv
  ~ee35050(); // tgen
  ee35050(); // tgen
};
//SIG(1 ee35050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee35050 ::foo(){vfunc_called(this, "_ZN7ee350503fooEv");}
ee35050 ::~ee35050(){ note_dtor("ee35050", this);} // tgen
ee35050 ::ee35050(){ note_ctor("ee35050", this);} // tgen

static void Test_ee35050()
{
  extern Class_Descriptor cd_ee35050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35050, buf);
    ee35050 *dp, &lv = *(dp=new (buf) ee35050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee35050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee35050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(32,16), "ee35050");
    check_base_class_offset(lv, (dd5050*), ABISELECT(16,8), "ee35050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35050.e");
    test_class_info(&lv, &cd_ee35050);
    dp->~ee35050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35050(Test_ee35050, "ee35050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35050C1Ev();
extern void _ZN7ee35050D1Ev();
Name_Map name_map_ee35050[] = {
  NSPAIR(_ZN7ee35050C1Ev),
  NSPAIR(_ZN7ee35050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee35050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35050[];
extern void _ZN7ee350503fooEv();
extern void _ZN6dd50503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35050[0]),
  (VTBL_ENTRY)&_ZN7ee350503fooEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern VTBL_ENTRY _ZTV7ee35050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee35050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee35050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee35050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee35050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee35050[] = {
  {&(_ZTV7ee35050[5]),  5,17},
  {&(_ZTV7ee35050[11]),  11,17},
  {&(_ZTV7ee35050[16]),  16,17},
  {&(_tg__ZTV6dd5050__7ee35050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee35050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee35050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee35050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35050[];
extern  VTBL_ENTRY _ZTV7ee35050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35050[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35050 = {  "ee35050", // class name
  bases_ee35050, 4,
  &(vtc_ee35050[0]), // expected_vtbl_contents
  &(vtt_ee35050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35050),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45050  : dd5050 {
  int e;
  virtual void  bar(); // _ZN7ee450503barEv
  ~ee45050(); // tgen
  ee45050(); // tgen
};
//SIG(1 ee45050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee45050 ::bar(){vfunc_called(this, "_ZN7ee450503barEv");}
ee45050 ::~ee45050(){ note_dtor("ee45050", this);} // tgen
ee45050 ::ee45050(){ note_ctor("ee45050", this);} // tgen

static void Test_ee45050()
{
  extern Class_Descriptor cd_ee45050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45050, buf);
    ee45050 *dp, &lv = *(dp=new (buf) ee45050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee45050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee45050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(16,12), "ee45050");
    check_base_class_offset(lv, (dd5050*), 0, "ee45050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45050.e");
    test_class_info(&lv, &cd_ee45050);
    dp->~ee45050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45050(Test_ee45050, "ee45050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45050C1Ev();
extern void _ZN7ee45050D1Ev();
Name_Map name_map_ee45050[] = {
  NSPAIR(_ZN7ee45050C1Ev),
  NSPAIR(_ZN7ee45050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee45050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45050[];
extern void _ZN7ee450503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee450503barEv,_ZTv0_n16_N7ee450503barEv)();
extern void ABISELECT(_ZThn16_N7ee450503barEv,_ZThn12_N7ee450503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee45050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45050[0]),
  (VTBL_ENTRY)&_ZN7ee450503barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee450503barEv,_ZTv0_n16_N7ee450503barEv),
};
extern VTBL_ENTRY _ZTV7ee45050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee45050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee45050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee45050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee45050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee45050[] = {
  {&(_ZTV7ee45050[4]),  4,10},
  {&(_tg__ZTV6dd5050__7ee45050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee45050[4]),  4,5},
  {&(_ZTV7ee45050[9]),  9,10},
  {&(_tg__ZTV5cc050__7ee45050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee45050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee45050[];
extern  VTBL_ENTRY _ZTV7ee45050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45050[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee450503barEv,_ZTv0_n16_N7ee450503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee450503barEv,_ZThn12_N7ee450503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45050 = {  "ee45050", // class name
  bases_ee45050, 4,
  &(vtc_ee45050[0]), // expected_vtbl_contents
  &(vtt_ee45050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45050),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55050  : virtual dd5050 {
  int e;
  virtual void  bar(); // _ZN7ee550503barEv
  ~ee55050(); // tgen
  ee55050(); // tgen
};
//SIG(1 ee55050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee55050 ::bar(){vfunc_called(this, "_ZN7ee550503barEv");}
ee55050 ::~ee55050(){ note_dtor("ee55050", this);} // tgen
ee55050 ::ee55050(){ note_ctor("ee55050", this);} // tgen

static void Test_ee55050()
{
  extern Class_Descriptor cd_ee55050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55050, buf);
    ee55050 *dp, &lv = *(dp=new (buf) ee55050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee55050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee55050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(32,16), "ee55050");
    check_base_class_offset(lv, (dd5050*), ABISELECT(16,8), "ee55050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55050.e");
    test_class_info(&lv, &cd_ee55050);
    dp->~ee55050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55050(Test_ee55050, "ee55050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55050C1Ev();
extern void _ZN7ee55050D1Ev();
Name_Map name_map_ee55050[] = {
  NSPAIR(_ZN7ee55050C1Ev),
  NSPAIR(_ZN7ee55050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee55050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55050[];
extern void _ZN7ee550503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee550503barEv,_ZTv0_n20_N7ee550503barEv)();
extern void ABISELECT(_ZThn16_N7ee550503barEv,_ZThn8_N7ee550503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee550503barEv,_ZTv0_n16_N7ee550503barEv)();
extern void ABISELECT(_ZThn32_N7ee550503barEv,_ZThn16_N7ee550503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55050[0]),
  (VTBL_ENTRY)&_ZN7ee550503barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee550503barEv,_ZTv0_n20_N7ee550503barEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee550503barEv,_ZTv0_n16_N7ee550503barEv),
};
extern VTBL_ENTRY _ZTV7ee55050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee55050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee55050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee55050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee55050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee55050[] = {
  {&(_ZTV7ee55050[5]),  5,17},
  {&(_ZTV7ee55050[11]),  11,17},
  {&(_ZTV7ee55050[16]),  16,17},
  {&(_tg__ZTV6dd5050__7ee55050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee55050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee55050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee55050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55050[];
extern  VTBL_ENTRY _ZTV7ee55050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55050[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee550503barEv,_ZTv0_n16_N7ee550503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee550503barEv,_ZThn16_N7ee550503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee550503barEv,_ZTv0_n20_N7ee550503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550503barEv,_ZThn8_N7ee550503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55050 = {  "ee55050", // class name
  bases_ee55050, 4,
  &(vtc_ee55050[0]), // expected_vtbl_contents
  &(vtt_ee55050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55050),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65050  : dd5050 {
  int e;
  virtual void  foo(); // _ZN7ee650503fooEv
  virtual void  bar(); // _ZN7ee650503barEv
  ~ee65050(); // tgen
  ee65050(); // tgen
};
//SIG(1 ee65050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65050 ::foo(){vfunc_called(this, "_ZN7ee650503fooEv");}
void  ee65050 ::bar(){vfunc_called(this, "_ZN7ee650503barEv");}
ee65050 ::~ee65050(){ note_dtor("ee65050", this);} // tgen
ee65050 ::ee65050(){ note_ctor("ee65050", this);} // tgen

static void Test_ee65050()
{
  extern Class_Descriptor cd_ee65050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65050, buf);
    ee65050 *dp, &lv = *(dp=new (buf) ee65050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee65050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee65050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(16,12), "ee65050");
    check_base_class_offset(lv, (dd5050*), 0, "ee65050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65050.e");
    test_class_info(&lv, &cd_ee65050);
    dp->~ee65050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65050(Test_ee65050, "ee65050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65050C1Ev();
extern void _ZN7ee65050D1Ev();
Name_Map name_map_ee65050[] = {
  NSPAIR(_ZN7ee65050C1Ev),
  NSPAIR(_ZN7ee65050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee65050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65050[];
extern void _ZN7ee650503barEv();
extern void _ZN7ee650503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee650503barEv,_ZTv0_n16_N7ee650503barEv)();
extern void ABISELECT(_ZThn16_N7ee650503barEv,_ZThn12_N7ee650503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65050[0]),
  (VTBL_ENTRY)&_ZN7ee650503barEv,
  (VTBL_ENTRY)&_ZN7ee650503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee650503barEv,_ZTv0_n16_N7ee650503barEv),
};
extern VTBL_ENTRY _ZTV7ee65050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee65050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee65050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee65050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee65050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee65050[] = {
  {&(_ZTV7ee65050[4]),  4,11},
  {&(_tg__ZTV6dd5050__7ee65050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee65050[4]),  4,5},
  {&(_ZTV7ee65050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee65050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee65050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee65050[];
extern  VTBL_ENTRY _ZTV7ee65050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65050[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn12_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee650503barEv,_ZTv0_n16_N7ee650503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650503barEv,_ZThn12_N7ee650503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65050 = {  "ee65050", // class name
  bases_ee65050, 4,
  &(vtc_ee65050[0]), // expected_vtbl_contents
  &(vtt_ee65050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75050  : virtual dd5050 {
  int e;
  virtual void  foo(); // _ZN7ee750503fooEv
  virtual void  bar(); // _ZN7ee750503barEv
  ~ee75050(); // tgen
  ee75050(); // tgen
};
//SIG(1 ee75050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75050 ::foo(){vfunc_called(this, "_ZN7ee750503fooEv");}
void  ee75050 ::bar(){vfunc_called(this, "_ZN7ee750503barEv");}
ee75050 ::~ee75050(){ note_dtor("ee75050", this);} // tgen
ee75050 ::ee75050(){ note_ctor("ee75050", this);} // tgen

static void Test_ee75050()
{
  extern Class_Descriptor cd_ee75050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75050, buf);
    ee75050 *dp, &lv = *(dp=new (buf) ee75050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee75050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee75050");
    check_base_class_offset(lv, (cc050*)(dd5050*), ABISELECT(32,16), "ee75050");
    check_base_class_offset(lv, (dd5050*), ABISELECT(16,8), "ee75050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75050.e");
    test_class_info(&lv, &cd_ee75050);
    dp->~ee75050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75050(Test_ee75050, "ee75050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75050C1Ev();
extern void _ZN7ee75050D1Ev();
Name_Map name_map_ee75050[] = {
  NSPAIR(_ZN7ee75050C1Ev),
  NSPAIR(_ZN7ee75050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd5050;
extern VTBL_ENTRY _ZTI6dd5050[];
extern  VTBL_ENTRY _ZTV6dd5050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5050[];
static Base_Class bases_ee75050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5050,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75050[];
extern void _ZN7ee750503fooEv();
extern void _ZN7ee750503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee750503barEv,_ZTv0_n20_N7ee750503barEv)();
extern void ABISELECT(_ZThn16_N7ee750503barEv,_ZThn8_N7ee750503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee750503barEv,_ZTv0_n16_N7ee750503barEv)();
extern void ABISELECT(_ZThn32_N7ee750503barEv,_ZThn16_N7ee750503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75050[0]),
  (VTBL_ENTRY)&_ZN7ee750503fooEv,
  (VTBL_ENTRY)&_ZN7ee750503barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee750503barEv,_ZTv0_n20_N7ee750503barEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750503barEv,_ZTv0_n16_N7ee750503barEv),
};
extern VTBL_ENTRY _ZTV7ee75050[];
extern void _ZN6dd50503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5050__7ee75050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&_ZN6dd50503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv)();
extern void ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd5050__7ee75050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee75050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee75050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee75050[] = {
  {&(_ZTV7ee75050[5]),  5,18},
  {&(_ZTV7ee75050[12]),  12,18},
  {&(_ZTV7ee75050[17]),  17,18},
  {&(_tg__ZTV6dd5050__7ee75050[4]),  4,5},
  {&(_tg__ZTV5cc050__6dd5050__7ee75050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee75050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee75050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75050[];
extern  VTBL_ENTRY _ZTV7ee75050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75050[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd50503barEv,_ZTv0_n16_N6dd50503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50503barEv,_ZThn8_N6dd50503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750503barEv,_ZTv0_n16_N7ee750503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750503barEv,_ZThn16_N7ee750503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee750503barEv,_ZTv0_n20_N7ee750503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750503barEv,_ZThn8_N7ee750503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75050 = {  "ee75050", // class name
  bases_ee75050, 4,
  &(vtc_ee75050[0]), // expected_vtbl_contents
  &(vtt_ee75050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75050),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6050  : cc050 {
  int d;
  virtual void  bar(); // _ZN6dd60503barEv
  virtual void  foo(); // _ZN6dd60503fooEv
  ~dd6050(); // tgen
  dd6050(); // tgen
};
//SIG(-1 dd6050) C1{ BC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd6050 ::bar(){vfunc_called(this, "_ZN6dd60503barEv");}
void  dd6050 ::foo(){vfunc_called(this, "_ZN6dd60503fooEv");}
dd6050 ::~dd6050(){ note_dtor("dd6050", this);} // tgen
dd6050 ::dd6050(){ note_ctor("dd6050", this);} // tgen

static void Test_dd6050()
{
  extern Class_Descriptor cd_dd6050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6050, buf);
    dd6050 *dp, &lv = *(dp=new (buf) dd6050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(20,16), "dd6050");
    check_base_class_offset(lv, (bb50*)(cc050*), 0, "dd6050");
    check_base_class_offset(lv, (cc050*), 0, "dd6050");
    check_field_offset(lv, d, ABISELECT(16,12), "dd6050.d");
    test_class_info(&lv, &cd_dd6050);
    dp->~dd6050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6050(Test_dd6050, "dd6050", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6050C1Ev();
extern void _ZN6dd6050D1Ev();
Name_Map name_map_dd6050[] = {
  NSPAIR(_ZN6dd6050C1Ev),
  NSPAIR(_ZN6dd6050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd6050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY vtc_dd6050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern VTBL_ENTRY _ZTV6dd6050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd6050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd6050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd6050[] = {
  {&(_ZTV6dd6050[3]),  3,5},
  {&(_tg__ZTV5cc050__6dd6050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd6050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
Class_Descriptor cd_dd6050 = {  "dd6050", // class name
  bases_dd6050, 3,
  &(vtc_dd6050[0]), // expected_vtbl_contents
  &(vtt_dd6050[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6050),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06050  : dd6050 {
  int e;
  ~ee06050(); // tgen
  ee06050(); // tgen
};
//SIG(1 ee06050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee06050 ::~ee06050(){ note_dtor("ee06050", this);} // tgen
ee06050 ::ee06050(){ note_ctor("ee06050", this);} // tgen

static void Test_ee06050()
{
  extern Class_Descriptor cd_ee06050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06050, buf);
    ee06050 *dp, &lv = *(dp=new (buf) ee06050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(24,20), "ee06050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), 0, "ee06050");
    check_base_class_offset(lv, (cc050*)(dd6050*), 0, "ee06050");
    check_base_class_offset(lv, (dd6050*), 0, "ee06050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee06050.e");
    test_class_info(&lv, &cd_ee06050);
    dp->~ee06050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06050(Test_ee06050, "ee06050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06050C1Ev();
extern void _ZN7ee06050D1Ev();
Name_Map name_map_ee06050[] = {
  NSPAIR(_ZN7ee06050C1Ev),
  NSPAIR(_ZN7ee06050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee06050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY vtc_ee06050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern VTBL_ENTRY _ZTV7ee06050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee06050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee06050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee06050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee06050[] = {
  {&(_ZTV7ee06050[3]),  3,5},
  {&(_tg__ZTV6dd6050__7ee06050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee06050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee06050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee06050[];
extern  VTBL_ENTRY _ZTV7ee06050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06050[];
Class_Descriptor cd_ee06050 = {  "ee06050", // class name
  bases_ee06050, 4,
  &(vtc_ee06050[0]), // expected_vtbl_contents
  &(vtt_ee06050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16050  : virtual dd6050 {
  int e;
  ~ee16050(); // tgen
  ee16050(); // tgen
};
//SIG(1 ee16050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee16050 ::~ee16050(){ note_dtor("ee16050", this);} // tgen
ee16050 ::ee16050(){ note_ctor("ee16050", this);} // tgen

static void Test_ee16050()
{
  extern Class_Descriptor cd_ee16050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16050, buf);
    ee16050 *dp, &lv = *(dp=new (buf) ee16050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(36,24), "ee16050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), ABISELECT(16,8), "ee16050");
    check_base_class_offset(lv, (cc050*)(dd6050*), ABISELECT(16,8), "ee16050");
    check_base_class_offset(lv, (dd6050*), ABISELECT(16,8), "ee16050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16050.e");
    test_class_info(&lv, &cd_ee16050);
    dp->~ee16050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16050(Test_ee16050, "ee16050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16050C1Ev();
extern void _ZN7ee16050D1Ev();
Name_Map name_map_ee16050[] = {
  NSPAIR(_ZN7ee16050C1Ev),
  NSPAIR(_ZN7ee16050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee16050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY vtc_ee16050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16050[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern VTBL_ENTRY _ZTV7ee16050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee16050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee16050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee16050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee16050[] = {
  {&(_ZTV7ee16050[4]),  4,11},
  {&(_ZTV7ee16050[9]),  9,11},
  {&(_tg__ZTV6dd6050__7ee16050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee16050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee16050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee16050[];
extern  VTBL_ENTRY _ZTV7ee16050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16050[];
Class_Descriptor cd_ee16050 = {  "ee16050", // class name
  bases_ee16050, 4,
  &(vtc_ee16050[0]), // expected_vtbl_contents
  &(vtt_ee16050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26050  : dd6050 {
  int e;
  virtual void  foo(); // _ZN7ee260503fooEv
  ~ee26050(); // tgen
  ee26050(); // tgen
};
//SIG(1 ee26050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26050 ::foo(){vfunc_called(this, "_ZN7ee260503fooEv");}
ee26050 ::~ee26050(){ note_dtor("ee26050", this);} // tgen
ee26050 ::ee26050(){ note_ctor("ee26050", this);} // tgen

static void Test_ee26050()
{
  extern Class_Descriptor cd_ee26050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26050, buf);
    ee26050 *dp, &lv = *(dp=new (buf) ee26050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(24,20), "ee26050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), 0, "ee26050");
    check_base_class_offset(lv, (cc050*)(dd6050*), 0, "ee26050");
    check_base_class_offset(lv, (dd6050*), 0, "ee26050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee26050.e");
    test_class_info(&lv, &cd_ee26050);
    dp->~ee26050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26050(Test_ee26050, "ee26050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26050C1Ev();
extern void _ZN7ee26050D1Ev();
Name_Map name_map_ee26050[] = {
  NSPAIR(_ZN7ee26050C1Ev),
  NSPAIR(_ZN7ee26050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee26050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26050[];
extern void _ZN6dd60503barEv();
extern void _ZN7ee260503fooEv();
static  VTBL_ENTRY vtc_ee26050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN7ee260503fooEv,
};
extern VTBL_ENTRY _ZTV7ee26050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee26050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee26050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee26050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee26050[] = {
  {&(_ZTV7ee26050[3]),  3,5},
  {&(_tg__ZTV6dd6050__7ee26050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee26050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee26050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee26050[];
extern  VTBL_ENTRY _ZTV7ee26050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26050[];
Class_Descriptor cd_ee26050 = {  "ee26050", // class name
  bases_ee26050, 4,
  &(vtc_ee26050[0]), // expected_vtbl_contents
  &(vtt_ee26050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36050  : virtual dd6050 {
  int e;
  virtual void  foo(); // _ZN7ee360503fooEv
  ~ee36050(); // tgen
  ee36050(); // tgen
};
//SIG(1 ee36050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36050 ::foo(){vfunc_called(this, "_ZN7ee360503fooEv");}
ee36050 ::~ee36050(){ note_dtor("ee36050", this);} // tgen
ee36050 ::ee36050(){ note_ctor("ee36050", this);} // tgen

static void Test_ee36050()
{
  extern Class_Descriptor cd_ee36050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36050, buf);
    ee36050 *dp, &lv = *(dp=new (buf) ee36050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(36,24), "ee36050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), ABISELECT(16,8), "ee36050");
    check_base_class_offset(lv, (cc050*)(dd6050*), ABISELECT(16,8), "ee36050");
    check_base_class_offset(lv, (dd6050*), ABISELECT(16,8), "ee36050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36050.e");
    test_class_info(&lv, &cd_ee36050);
    dp->~ee36050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36050(Test_ee36050, "ee36050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36050C1Ev();
extern void _ZN7ee36050D1Ev();
Name_Map name_map_ee36050[] = {
  NSPAIR(_ZN7ee36050C1Ev),
  NSPAIR(_ZN7ee36050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee36050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36050[];
extern void _ZN7ee360503fooEv();
extern void _ZN6dd60503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee360503fooEv,_ZTv0_n20_N7ee360503fooEv)();
extern void ABISELECT(_ZThn16_N7ee360503fooEv,_ZThn8_N7ee360503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36050[0]),
  (VTBL_ENTRY)&_ZN7ee360503fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee360503fooEv,_ZTv0_n20_N7ee360503fooEv),
};
extern VTBL_ENTRY _ZTV7ee36050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee36050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee36050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee36050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee36050[] = {
  {&(_ZTV7ee36050[4]),  4,12},
  {&(_ZTV7ee36050[10]),  10,12},
  {&(_tg__ZTV6dd6050__7ee36050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee36050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee36050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee36050[];
extern  VTBL_ENTRY _ZTV7ee36050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36050[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee360503fooEv,_ZTv0_n20_N7ee360503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360503fooEv,_ZThn8_N7ee360503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36050 = {  "ee36050", // class name
  bases_ee36050, 4,
  &(vtc_ee36050[0]), // expected_vtbl_contents
  &(vtt_ee36050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36050),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46050  : dd6050 {
  int e;
  virtual void  bar(); // _ZN7ee460503barEv
  ~ee46050(); // tgen
  ee46050(); // tgen
};
//SIG(1 ee46050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46050 ::bar(){vfunc_called(this, "_ZN7ee460503barEv");}
ee46050 ::~ee46050(){ note_dtor("ee46050", this);} // tgen
ee46050 ::ee46050(){ note_ctor("ee46050", this);} // tgen

static void Test_ee46050()
{
  extern Class_Descriptor cd_ee46050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46050, buf);
    ee46050 *dp, &lv = *(dp=new (buf) ee46050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(24,20), "ee46050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), 0, "ee46050");
    check_base_class_offset(lv, (cc050*)(dd6050*), 0, "ee46050");
    check_base_class_offset(lv, (dd6050*), 0, "ee46050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee46050.e");
    test_class_info(&lv, &cd_ee46050);
    dp->~ee46050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46050(Test_ee46050, "ee46050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46050C1Ev();
extern void _ZN7ee46050D1Ev();
Name_Map name_map_ee46050[] = {
  NSPAIR(_ZN7ee46050C1Ev),
  NSPAIR(_ZN7ee46050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee46050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46050[];
extern void _ZN7ee460503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY vtc_ee46050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46050[0]),
  (VTBL_ENTRY)&_ZN7ee460503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern VTBL_ENTRY _ZTV7ee46050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee46050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee46050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee46050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee46050[] = {
  {&(_ZTV7ee46050[3]),  3,5},
  {&(_tg__ZTV6dd6050__7ee46050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee46050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee46050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee46050[];
extern  VTBL_ENTRY _ZTV7ee46050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46050[];
Class_Descriptor cd_ee46050 = {  "ee46050", // class name
  bases_ee46050, 4,
  &(vtc_ee46050[0]), // expected_vtbl_contents
  &(vtt_ee46050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56050  : virtual dd6050 {
  int e;
  virtual void  bar(); // _ZN7ee560503barEv
  ~ee56050(); // tgen
  ee56050(); // tgen
};
//SIG(1 ee56050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56050 ::bar(){vfunc_called(this, "_ZN7ee560503barEv");}
ee56050 ::~ee56050(){ note_dtor("ee56050", this);} // tgen
ee56050 ::ee56050(){ note_ctor("ee56050", this);} // tgen

static void Test_ee56050()
{
  extern Class_Descriptor cd_ee56050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56050, buf);
    ee56050 *dp, &lv = *(dp=new (buf) ee56050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(36,24), "ee56050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), ABISELECT(16,8), "ee56050");
    check_base_class_offset(lv, (cc050*)(dd6050*), ABISELECT(16,8), "ee56050");
    check_base_class_offset(lv, (dd6050*), ABISELECT(16,8), "ee56050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56050.e");
    test_class_info(&lv, &cd_ee56050);
    dp->~ee56050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56050(Test_ee56050, "ee56050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56050C1Ev();
extern void _ZN7ee56050D1Ev();
Name_Map name_map_ee56050[] = {
  NSPAIR(_ZN7ee56050C1Ev),
  NSPAIR(_ZN7ee56050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee56050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56050[];
extern void _ZN7ee560503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee560503barEv,_ZTv0_n16_N7ee560503barEv)();
extern void ABISELECT(_ZThn16_N7ee560503barEv,_ZThn8_N7ee560503barEv)() __attribute__((weak));
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY vtc_ee56050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56050[0]),
  (VTBL_ENTRY)&_ZN7ee560503barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee560503barEv,_ZTv0_n16_N7ee560503barEv),
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern VTBL_ENTRY _ZTV7ee56050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee56050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee56050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee56050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee56050[] = {
  {&(_ZTV7ee56050[4]),  4,12},
  {&(_ZTV7ee56050[10]),  10,12},
  {&(_tg__ZTV6dd6050__7ee56050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee56050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee56050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee56050[];
extern  VTBL_ENTRY _ZTV7ee56050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56050[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee560503barEv,_ZTv0_n16_N7ee560503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560503barEv,_ZThn8_N7ee560503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56050 = {  "ee56050", // class name
  bases_ee56050, 4,
  &(vtc_ee56050[0]), // expected_vtbl_contents
  &(vtt_ee56050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56050),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66050  : dd6050 {
  int e;
  virtual void  foo(); // _ZN7ee660503fooEv
  virtual void  bar(); // _ZN7ee660503barEv
  ~ee66050(); // tgen
  ee66050(); // tgen
};
//SIG(1 ee66050) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66050 ::foo(){vfunc_called(this, "_ZN7ee660503fooEv");}
void  ee66050 ::bar(){vfunc_called(this, "_ZN7ee660503barEv");}
ee66050 ::~ee66050(){ note_dtor("ee66050", this);} // tgen
ee66050 ::ee66050(){ note_ctor("ee66050", this);} // tgen

static void Test_ee66050()
{
  extern Class_Descriptor cd_ee66050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66050, buf);
    ee66050 *dp, &lv = *(dp=new (buf) ee66050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(24,20), "ee66050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), 0, "ee66050");
    check_base_class_offset(lv, (cc050*)(dd6050*), 0, "ee66050");
    check_base_class_offset(lv, (dd6050*), 0, "ee66050");
    check_field_offset(lv, e, ABISELECT(20,16), "ee66050.e");
    test_class_info(&lv, &cd_ee66050);
    dp->~ee66050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66050(Test_ee66050, "ee66050", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66050C1Ev();
extern void _ZN7ee66050D1Ev();
Name_Map name_map_ee66050[] = {
  NSPAIR(_ZN7ee66050C1Ev),
  NSPAIR(_ZN7ee66050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee66050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66050[];
extern void _ZN7ee660503barEv();
extern void _ZN7ee660503fooEv();
static  VTBL_ENTRY vtc_ee66050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66050[0]),
  (VTBL_ENTRY)&_ZN7ee660503barEv,
  (VTBL_ENTRY)&_ZN7ee660503fooEv,
};
extern VTBL_ENTRY _ZTV7ee66050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee66050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee66050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee66050[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee66050[] = {
  {&(_ZTV7ee66050[3]),  3,5},
  {&(_tg__ZTV6dd6050__7ee66050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee66050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee66050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee66050[];
extern  VTBL_ENTRY _ZTV7ee66050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66050[];
Class_Descriptor cd_ee66050 = {  "ee66050", // class name
  bases_ee66050, 4,
  &(vtc_ee66050[0]), // expected_vtbl_contents
  &(vtt_ee66050[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66050),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66050),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76050  : virtual dd6050 {
  int e;
  virtual void  foo(); // _ZN7ee760503fooEv
  virtual void  bar(); // _ZN7ee760503barEv
  ~ee76050(); // tgen
  ee76050(); // tgen
};
//SIG(1 ee76050) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76050 ::foo(){vfunc_called(this, "_ZN7ee760503fooEv");}
void  ee76050 ::bar(){vfunc_called(this, "_ZN7ee760503barEv");}
ee76050 ::~ee76050(){ note_dtor("ee76050", this);} // tgen
ee76050 ::ee76050(){ note_ctor("ee76050", this);} // tgen

static void Test_ee76050()
{
  extern Class_Descriptor cd_ee76050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76050, buf);
    ee76050 *dp, &lv = *(dp=new (buf) ee76050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*)(dd6050*), ABISELECT(36,24), "ee76050");
    check_base_class_offset(lv, (bb50*)(cc050*)(dd6050*), ABISELECT(16,8), "ee76050");
    check_base_class_offset(lv, (cc050*)(dd6050*), ABISELECT(16,8), "ee76050");
    check_base_class_offset(lv, (dd6050*), ABISELECT(16,8), "ee76050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76050.e");
    test_class_info(&lv, &cd_ee76050);
    dp->~ee76050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76050(Test_ee76050, "ee76050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76050C1Ev();
extern void _ZN7ee76050D1Ev();
Name_Map name_map_ee76050[] = {
  NSPAIR(_ZN7ee76050C1Ev),
  NSPAIR(_ZN7ee76050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd6050;
extern VTBL_ENTRY _ZTI6dd6050[];
extern  VTBL_ENTRY _ZTV6dd6050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6050[];
static Base_Class bases_ee76050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76050[];
extern void _ZN7ee760503fooEv();
extern void _ZN7ee760503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee760503barEv,_ZTv0_n16_N7ee760503barEv)();
extern void ABISELECT(_ZThn16_N7ee760503barEv,_ZThn8_N7ee760503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee760503fooEv,_ZTv0_n20_N7ee760503fooEv)();
extern void ABISELECT(_ZThn16_N7ee760503fooEv,_ZThn8_N7ee760503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76050[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76050[0]),
  (VTBL_ENTRY)&_ZN7ee760503fooEv,
  (VTBL_ENTRY)&_ZN7ee760503barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760503barEv,_ZTv0_n16_N7ee760503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee760503fooEv,_ZTv0_n20_N7ee760503fooEv),
};
extern VTBL_ENTRY _ZTV7ee76050[];
extern void _ZN6dd60503barEv();
extern void _ZN6dd60503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6050__7ee76050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6050[0]),
  (VTBL_ENTRY)&_ZN6dd60503barEv,
  (VTBL_ENTRY)&_ZN6dd60503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc0506dd6050__7ee76050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc0506dd6050__7ee76050[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee76050[] = {
  {&(_ZTV7ee76050[4]),  4,13},
  {&(_ZTV7ee76050[11]),  11,13},
  {&(_tg__ZTV6dd6050__7ee76050[3]),  3,5},
  {&(_tg__ZTV5cc0506dd6050__7ee76050[3]),  3,4},
  {&(_tg__ZTV4bb505cc0506dd6050__7ee76050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee76050[];
extern  VTBL_ENTRY _ZTV7ee76050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76050[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee760503fooEv,_ZTv0_n20_N7ee760503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760503fooEv,_ZThn8_N7ee760503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760503barEv,_ZTv0_n16_N7ee760503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760503barEv,_ZThn8_N7ee760503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76050 = {  "ee76050", // class name
  bases_ee76050, 4,
  &(vtc_ee76050[0]), // expected_vtbl_contents
  &(vtt_ee76050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76050),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76050),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7050  : virtual cc050 {
  int d;
  virtual void  bar(); // _ZN6dd70503barEv
  virtual void  foo(); // _ZN6dd70503fooEv
  ~dd7050(); // tgen
  dd7050(); // tgen
};
//SIG(-1 dd7050) C1{ VBC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd7050 ::bar(){vfunc_called(this, "_ZN6dd70503barEv");}
void  dd7050 ::foo(){vfunc_called(this, "_ZN6dd70503fooEv");}
dd7050 ::~dd7050(){ note_dtor("dd7050", this);} // tgen
dd7050 ::dd7050(){ note_ctor("dd7050", this);} // tgen

static void Test_dd7050()
{
  extern Class_Descriptor cd_dd7050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7050, buf);
    dd7050 *dp, &lv = *(dp=new (buf) dd7050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,20), "dd7050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,8), "dd7050");
    check_base_class_offset(lv, (cc050*), ABISELECT(16,8), "dd7050");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7050.d");
    test_class_info(&lv, &cd_dd7050);
    dp->~dd7050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7050(Test_dd7050, "dd7050", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7050C1Ev();
extern void _ZN6dd7050D1Ev();
Name_Map name_map_dd7050[] = {
  NSPAIR(_ZN6dd7050C1Ev),
  NSPAIR(_ZN6dd7050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
static Base_Class bases_dd7050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern VTBL_ENTRY _ZTV6dd7050[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__6dd7050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd7050[] = {
  {&(_ZTV6dd7050[4]),  4,11},
  {&(_ZTV6dd7050[10]),  10,11},
  {&(_tg__ZTV5cc050__6dd7050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__6dd7050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7050 = {  "dd7050", // class name
  bases_dd7050, 3,
  &(vtc_dd7050[0]), // expected_vtbl_contents
  &(vtt_dd7050[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7050),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07050  : dd7050 {
  int e;
  ~ee07050(); // tgen
  ee07050(); // tgen
};
//SIG(1 ee07050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee07050 ::~ee07050(){ note_dtor("ee07050", this);} // tgen
ee07050 ::ee07050(){ note_ctor("ee07050", this);} // tgen

static void Test_ee07050()
{
  extern Class_Descriptor cd_ee07050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07050, buf);
    ee07050 *dp, &lv = *(dp=new (buf) ee07050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee07050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee07050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(16,12), "ee07050");
    check_base_class_offset(lv, (dd7050*), 0, "ee07050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07050.e");
    test_class_info(&lv, &cd_ee07050);
    dp->~ee07050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07050(Test_ee07050, "ee07050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07050C1Ev();
extern void _ZN7ee07050D1Ev();
Name_Map name_map_ee07050[] = {
  NSPAIR(_ZN7ee07050C1Ev),
  NSPAIR(_ZN7ee07050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee07050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern VTBL_ENTRY _ZTV7ee07050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee07050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee07050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee07050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee07050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee07050[] = {
  {&(_ZTV7ee07050[4]),  4,11},
  {&(_tg__ZTV6dd7050__7ee07050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee07050[4]),  4,5},
  {&(_ZTV7ee07050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee07050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee07050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee07050[];
extern  VTBL_ENTRY _ZTV7ee07050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07050[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07050 = {  "ee07050", // class name
  bases_ee07050, 4,
  &(vtc_ee07050[0]), // expected_vtbl_contents
  &(vtt_ee07050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17050  : virtual dd7050 {
  int e;
  ~ee17050(); // tgen
  ee17050(); // tgen
};
//SIG(1 ee17050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee17050 ::~ee17050(){ note_dtor("ee17050", this);} // tgen
ee17050 ::ee17050(){ note_ctor("ee17050", this);} // tgen

static void Test_ee17050()
{
  extern Class_Descriptor cd_ee17050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17050, buf);
    ee17050 *dp, &lv = *(dp=new (buf) ee17050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee17050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee17050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(32,16), "ee17050");
    check_base_class_offset(lv, (dd7050*), ABISELECT(16,8), "ee17050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17050.e");
    test_class_info(&lv, &cd_ee17050);
    dp->~ee17050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17050(Test_ee17050, "ee17050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17050C1Ev();
extern void _ZN7ee17050D1Ev();
Name_Map name_map_ee17050[] = {
  NSPAIR(_ZN7ee17050C1Ev),
  NSPAIR(_ZN7ee17050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee17050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17050[0]),
  0,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern VTBL_ENTRY _ZTV7ee17050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee17050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee17050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee17050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee17050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee17050[] = {
  {&(_ZTV7ee17050[5]),  5,18},
  {&(_ZTV7ee17050[11]),  11,18},
  {&(_ZTV7ee17050[17]),  17,18},
  {&(_tg__ZTV6dd7050__7ee17050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee17050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee17050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee17050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17050[];
extern  VTBL_ENTRY _ZTV7ee17050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17050[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17050 = {  "ee17050", // class name
  bases_ee17050, 4,
  &(vtc_ee17050[0]), // expected_vtbl_contents
  &(vtt_ee17050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17050),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27050  : dd7050 {
  int e;
  virtual void  foo(); // _ZN7ee270503fooEv
  ~ee27050(); // tgen
  ee27050(); // tgen
};
//SIG(1 ee27050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27050 ::foo(){vfunc_called(this, "_ZN7ee270503fooEv");}
ee27050 ::~ee27050(){ note_dtor("ee27050", this);} // tgen
ee27050 ::ee27050(){ note_ctor("ee27050", this);} // tgen

static void Test_ee27050()
{
  extern Class_Descriptor cd_ee27050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27050, buf);
    ee27050 *dp, &lv = *(dp=new (buf) ee27050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee27050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee27050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(16,12), "ee27050");
    check_base_class_offset(lv, (dd7050*), 0, "ee27050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27050.e");
    test_class_info(&lv, &cd_ee27050);
    dp->~ee27050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27050(Test_ee27050, "ee27050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27050C1Ev();
extern void _ZN7ee27050D1Ev();
Name_Map name_map_ee27050[] = {
  NSPAIR(_ZN7ee27050C1Ev),
  NSPAIR(_ZN7ee27050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee27050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27050[];
extern void _ZN6dd70503barEv();
extern void _ZN7ee270503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN7ee270503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern VTBL_ENTRY _ZTV7ee27050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee27050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee27050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee27050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee27050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee27050[] = {
  {&(_ZTV7ee27050[4]),  4,11},
  {&(_tg__ZTV6dd7050__7ee27050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee27050[4]),  4,5},
  {&(_ZTV7ee27050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee27050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee27050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee27050[];
extern  VTBL_ENTRY _ZTV7ee27050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27050[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27050 = {  "ee27050", // class name
  bases_ee27050, 4,
  &(vtc_ee27050[0]), // expected_vtbl_contents
  &(vtt_ee27050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37050  : virtual dd7050 {
  int e;
  virtual void  foo(); // _ZN7ee370503fooEv
  ~ee37050(); // tgen
  ee37050(); // tgen
};
//SIG(1 ee37050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37050 ::foo(){vfunc_called(this, "_ZN7ee370503fooEv");}
ee37050 ::~ee37050(){ note_dtor("ee37050", this);} // tgen
ee37050 ::ee37050(){ note_ctor("ee37050", this);} // tgen

static void Test_ee37050()
{
  extern Class_Descriptor cd_ee37050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37050, buf);
    ee37050 *dp, &lv = *(dp=new (buf) ee37050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee37050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee37050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(32,16), "ee37050");
    check_base_class_offset(lv, (dd7050*), ABISELECT(16,8), "ee37050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37050.e");
    test_class_info(&lv, &cd_ee37050);
    dp->~ee37050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37050(Test_ee37050, "ee37050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37050C1Ev();
extern void _ZN7ee37050D1Ev();
Name_Map name_map_ee37050[] = {
  NSPAIR(_ZN7ee37050C1Ev),
  NSPAIR(_ZN7ee37050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee37050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37050[];
extern void _ZN7ee370503fooEv();
extern void _ZN6dd70503barEv();
extern void ABISELECT(_ZTv0_n48_N7ee370503fooEv,_ZTv0_n24_N7ee370503fooEv)();
extern void ABISELECT(_ZThn16_N7ee370503fooEv,_ZThn8_N7ee370503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37050[0]),
  (VTBL_ENTRY)&_ZN7ee370503fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee370503fooEv,_ZTv0_n24_N7ee370503fooEv),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern VTBL_ENTRY _ZTV7ee37050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee37050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee37050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee37050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee37050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee37050[] = {
  {&(_ZTV7ee37050[5]),  5,19},
  {&(_ZTV7ee37050[12]),  12,19},
  {&(_ZTV7ee37050[18]),  18,19},
  {&(_tg__ZTV6dd7050__7ee37050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee37050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee37050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee37050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37050[];
extern  VTBL_ENTRY _ZTV7ee37050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37050[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee370503fooEv,_ZTv0_n24_N7ee370503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370503fooEv,_ZThn8_N7ee370503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37050 = {  "ee37050", // class name
  bases_ee37050, 4,
  &(vtc_ee37050[0]), // expected_vtbl_contents
  &(vtt_ee37050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37050),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47050  : dd7050 {
  int e;
  virtual void  bar(); // _ZN7ee470503barEv
  ~ee47050(); // tgen
  ee47050(); // tgen
};
//SIG(1 ee47050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47050 ::bar(){vfunc_called(this, "_ZN7ee470503barEv");}
ee47050 ::~ee47050(){ note_dtor("ee47050", this);} // tgen
ee47050 ::ee47050(){ note_ctor("ee47050", this);} // tgen

static void Test_ee47050()
{
  extern Class_Descriptor cd_ee47050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47050, buf);
    ee47050 *dp, &lv = *(dp=new (buf) ee47050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee47050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee47050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(16,12), "ee47050");
    check_base_class_offset(lv, (dd7050*), 0, "ee47050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47050.e");
    test_class_info(&lv, &cd_ee47050);
    dp->~ee47050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47050(Test_ee47050, "ee47050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47050C1Ev();
extern void _ZN7ee47050D1Ev();
Name_Map name_map_ee47050[] = {
  NSPAIR(_ZN7ee47050C1Ev),
  NSPAIR(_ZN7ee47050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee47050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47050[];
extern void _ZN7ee470503barEv();
extern void _ZN6dd70503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee470503barEv,_ZTv0_n16_N7ee470503barEv)();
extern void ABISELECT(_ZThn16_N7ee470503barEv,_ZThn12_N7ee470503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47050[0]),
  (VTBL_ENTRY)&_ZN7ee470503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee470503barEv,_ZTv0_n16_N7ee470503barEv),
};
extern VTBL_ENTRY _ZTV7ee47050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee47050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee47050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee47050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee47050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee47050[] = {
  {&(_ZTV7ee47050[4]),  4,11},
  {&(_tg__ZTV6dd7050__7ee47050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee47050[4]),  4,5},
  {&(_ZTV7ee47050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee47050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee47050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee47050[];
extern  VTBL_ENTRY _ZTV7ee47050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47050[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee470503barEv,_ZTv0_n16_N7ee470503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee470503barEv,_ZThn12_N7ee470503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47050 = {  "ee47050", // class name
  bases_ee47050, 4,
  &(vtc_ee47050[0]), // expected_vtbl_contents
  &(vtt_ee47050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57050  : virtual dd7050 {
  int e;
  virtual void  bar(); // _ZN7ee570503barEv
  ~ee57050(); // tgen
  ee57050(); // tgen
};
//SIG(1 ee57050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57050 ::bar(){vfunc_called(this, "_ZN7ee570503barEv");}
ee57050 ::~ee57050(){ note_dtor("ee57050", this);} // tgen
ee57050 ::ee57050(){ note_ctor("ee57050", this);} // tgen

static void Test_ee57050()
{
  extern Class_Descriptor cd_ee57050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57050, buf);
    ee57050 *dp, &lv = *(dp=new (buf) ee57050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee57050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee57050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(32,16), "ee57050");
    check_base_class_offset(lv, (dd7050*), ABISELECT(16,8), "ee57050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57050.e");
    test_class_info(&lv, &cd_ee57050);
    dp->~ee57050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57050(Test_ee57050, "ee57050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57050C1Ev();
extern void _ZN7ee57050D1Ev();
Name_Map name_map_ee57050[] = {
  NSPAIR(_ZN7ee57050C1Ev),
  NSPAIR(_ZN7ee57050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee57050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57050[];
extern void _ZN7ee570503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee570503barEv,_ZTv0_n20_N7ee570503barEv)();
extern void ABISELECT(_ZThn16_N7ee570503barEv,_ZThn8_N7ee570503barEv)() __attribute__((weak));
extern void _ZN6dd70503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee570503barEv,_ZTv0_n16_N7ee570503barEv)();
extern void ABISELECT(_ZThn32_N7ee570503barEv,_ZThn16_N7ee570503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57050[0]),
  (VTBL_ENTRY)&_ZN7ee570503barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee570503barEv,_ZTv0_n20_N7ee570503barEv),
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee570503barEv,_ZTv0_n16_N7ee570503barEv),
};
extern VTBL_ENTRY _ZTV7ee57050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee57050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee57050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee57050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee57050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee57050[] = {
  {&(_ZTV7ee57050[5]),  5,19},
  {&(_ZTV7ee57050[12]),  12,19},
  {&(_ZTV7ee57050[18]),  18,19},
  {&(_tg__ZTV6dd7050__7ee57050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee57050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee57050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee57050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57050[];
extern  VTBL_ENTRY _ZTV7ee57050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57050[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee570503barEv,_ZTv0_n16_N7ee570503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee570503barEv,_ZThn16_N7ee570503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee570503barEv,_ZTv0_n20_N7ee570503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570503barEv,_ZThn8_N7ee570503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57050 = {  "ee57050", // class name
  bases_ee57050, 4,
  &(vtc_ee57050[0]), // expected_vtbl_contents
  &(vtt_ee57050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57050),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67050  : dd7050 {
  int e;
  virtual void  foo(); // _ZN7ee670503fooEv
  virtual void  bar(); // _ZN7ee670503barEv
  ~ee67050(); // tgen
  ee67050(); // tgen
};
//SIG(1 ee67050) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67050 ::foo(){vfunc_called(this, "_ZN7ee670503fooEv");}
void  ee67050 ::bar(){vfunc_called(this, "_ZN7ee670503barEv");}
ee67050 ::~ee67050(){ note_dtor("ee67050", this);} // tgen
ee67050 ::ee67050(){ note_ctor("ee67050", this);} // tgen

static void Test_ee67050()
{
  extern Class_Descriptor cd_ee67050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67050, buf);
    ee67050 *dp, &lv = *(dp=new (buf) ee67050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(32,24), "ee67050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(16,12), "ee67050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(16,12), "ee67050");
    check_base_class_offset(lv, (dd7050*), 0, "ee67050");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67050.e");
    test_class_info(&lv, &cd_ee67050);
    dp->~ee67050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67050(Test_ee67050, "ee67050", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67050C1Ev();
extern void _ZN7ee67050D1Ev();
Name_Map name_map_ee67050[] = {
  NSPAIR(_ZN7ee67050C1Ev),
  NSPAIR(_ZN7ee67050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee67050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67050[];
extern void _ZN7ee670503barEv();
extern void _ZN7ee670503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee670503barEv,_ZTv0_n16_N7ee670503barEv)();
extern void ABISELECT(_ZThn16_N7ee670503barEv,_ZThn12_N7ee670503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67050[0]),
  (VTBL_ENTRY)&_ZN7ee670503barEv,
  (VTBL_ENTRY)&_ZN7ee670503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee670503barEv,_ZTv0_n16_N7ee670503barEv),
};
extern VTBL_ENTRY _ZTV7ee67050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee67050[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee67050[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee67050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee67050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee67050[] = {
  {&(_ZTV7ee67050[4]),  4,11},
  {&(_tg__ZTV6dd7050__7ee67050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee67050[4]),  4,5},
  {&(_ZTV7ee67050[10]),  10,11},
  {&(_tg__ZTV5cc050__7ee67050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee67050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee67050[];
extern  VTBL_ENTRY _ZTV7ee67050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67050[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn12_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee670503barEv,_ZTv0_n16_N7ee670503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670503barEv,_ZThn12_N7ee670503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67050 = {  "ee67050", // class name
  bases_ee67050, 4,
  &(vtc_ee67050[0]), // expected_vtbl_contents
  &(vtt_ee67050[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67050),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67050),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67050),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77050  : virtual dd7050 {
  int e;
  virtual void  foo(); // _ZN7ee770503fooEv
  virtual void  bar(); // _ZN7ee770503barEv
  ~ee77050(); // tgen
  ee77050(); // tgen
};
//SIG(1 ee77050) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77050 ::foo(){vfunc_called(this, "_ZN7ee770503fooEv");}
void  ee77050 ::bar(){vfunc_called(this, "_ZN7ee770503barEv");}
ee77050 ::~ee77050(){ note_dtor("ee77050", this);} // tgen
ee77050 ::ee77050(){ note_ctor("ee77050", this);} // tgen

static void Test_ee77050()
{
  extern Class_Descriptor cd_ee77050;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77050, buf);
    ee77050 *dp, &lv = *(dp=new (buf) ee77050());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77050)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77050)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc050*), ABISELECT(48,28), "ee77050");
    check_base_class_offset(lv, (bb50*)(cc050*), ABISELECT(32,16), "ee77050");
    check_base_class_offset(lv, (cc050*)(dd7050*), ABISELECT(32,16), "ee77050");
    check_base_class_offset(lv, (dd7050*), ABISELECT(16,8), "ee77050");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77050.e");
    test_class_info(&lv, &cd_ee77050);
    dp->~ee77050();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77050(Test_ee77050, "ee77050", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77050C1Ev();
extern void _ZN7ee77050D1Ev();
Name_Map name_map_ee77050[] = {
  NSPAIR(_ZN7ee77050C1Ev),
  NSPAIR(_ZN7ee77050D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc050;
extern VTBL_ENTRY _ZTI5cc050[];
extern  VTBL_ENTRY _ZTV5cc050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc050[];
extern Class_Descriptor cd_dd7050;
extern VTBL_ENTRY _ZTI6dd7050[];
extern  VTBL_ENTRY _ZTV6dd7050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7050[];
static Base_Class bases_ee77050[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc050,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7050,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77050[];
extern void _ZN7ee770503fooEv();
extern void _ZN7ee770503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee770503barEv,_ZTv0_n20_N7ee770503barEv)();
extern void ABISELECT(_ZThn16_N7ee770503barEv,_ZThn8_N7ee770503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee770503fooEv,_ZTv0_n24_N7ee770503fooEv)();
extern void ABISELECT(_ZThn16_N7ee770503fooEv,_ZThn8_N7ee770503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee770503barEv,_ZTv0_n16_N7ee770503barEv)();
extern void ABISELECT(_ZThn32_N7ee770503barEv,_ZThn16_N7ee770503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77050[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77050[0]),
  (VTBL_ENTRY)&_ZN7ee770503fooEv,
  (VTBL_ENTRY)&_ZN7ee770503barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770503barEv,_ZTv0_n20_N7ee770503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee770503fooEv,_ZTv0_n24_N7ee770503fooEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770503barEv,_ZTv0_n16_N7ee770503barEv),
};
extern VTBL_ENTRY _ZTV7ee77050[];
extern void _ZN6dd70503barEv();
extern void _ZN6dd70503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7050__7ee77050[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&_ZN6dd70503barEv,
  (VTBL_ENTRY)&_ZN6dd70503fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv)();
extern void ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc050__6dd7050__7ee77050[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7050[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV5cc050__7ee77050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc050[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc050__7ee77050[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee77050[] = {
  {&(_ZTV7ee77050[5]),  5,20},
  {&(_ZTV7ee77050[13]),  13,20},
  {&(_ZTV7ee77050[19]),  19,20},
  {&(_tg__ZTV6dd7050__7ee77050[4]),  4,6},
  {&(_tg__ZTV5cc050__6dd7050__7ee77050[4]),  4,5},
  {&(_tg__ZTV5cc050__7ee77050[3]),  3,4},
  {&(_tg__ZTV4bb505cc050__7ee77050[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77050[];
extern  VTBL_ENTRY _ZTV7ee77050[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77050[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70503barEv,_ZTv0_n16_N6dd70503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70503barEv,_ZThn8_N6dd70503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770503barEv,_ZTv0_n16_N7ee770503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770503barEv,_ZThn16_N7ee770503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee770503fooEv,_ZTv0_n24_N7ee770503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770503fooEv,_ZThn8_N7ee770503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770503barEv,_ZTv0_n20_N7ee770503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770503barEv,_ZThn8_N7ee770503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77050 = {  "ee77050", // class name
  bases_ee77050, 4,
  &(vtc_ee77050[0]), // expected_vtbl_contents
  &(vtt_ee77050[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77050),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77050),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77050),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc150  : virtual bb50 {
  int c;
  ~cc150(); // tgen
  cc150(); // tgen
};
//SIG(-1 cc150) C1{ VBC2{ VBC3{ Fi} v1 Fi} Fi}


cc150 ::~cc150(){ note_dtor("cc150", this);} // tgen
cc150 ::cc150(){ note_ctor("cc150", this);} // tgen

static void Test_cc150()
{
  extern Class_Descriptor cd_cc150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_cc150, buf);
    cc150 *dp, &lv = *(dp=new (buf) cc150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(cc150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(28,16), "cc150");
    check_base_class_offset(lv, (bb50*), ABISELECT(16,8), "cc150");
    check_field_offset(lv, c, ABISELECT(8,4), "cc150.c");
    test_class_info(&lv, &cd_cc150);
    dp->~cc150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc150(Test_cc150, "cc150", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN5cc150C1Ev();
extern void _ZN5cc150D1Ev();
Name_Map name_map_cc150[] = {
  NSPAIR(_ZN5cc150C1Ev),
  NSPAIR(_ZN5cc150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
static Base_Class bases_cc150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_cc150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV5cc150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_cc150[] = {
  {&(_ZTV5cc150[4]),  4,9},
  {&(_ZTV5cc150[8]),  8,9},
  {&(_tg__ZTV4bb50__5cc150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
Class_Descriptor cd_cc150 = {  "cc150", // class name
  bases_cc150, 2,
  &(vtc_cc150[0]), // expected_vtbl_contents
  &(vtt_cc150[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI5cc150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc150),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc150),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0150  : cc150 {
  int d;
  ~dd0150(); // tgen
  dd0150(); // tgen
};
//SIG(-1 dd0150) C1{ BC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd0150 ::~dd0150(){ note_dtor("dd0150", this);} // tgen
dd0150 ::dd0150(){ note_ctor("dd0150", this);} // tgen

static void Test_dd0150()
{
  extern Class_Descriptor cd_dd0150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd0150, buf);
    dd0150 *dp, &lv = *(dp=new (buf) dd0150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd0150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(28,20), "dd0150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(16,12), "dd0150");
    check_base_class_offset(lv, (cc150*), 0, "dd0150");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0150.d");
    test_class_info(&lv, &cd_dd0150);
    dp->~dd0150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0150(Test_dd0150, "dd0150", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd0150C1Ev();
extern void _ZN6dd0150D1Ev();
Name_Map name_map_dd0150[] = {
  NSPAIR(_ZN6dd0150C1Ev),
  NSPAIR(_ZN6dd0150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd0150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_dd0150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV6dd0150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd0150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd0150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd0150[] = {
  {&(_ZTV6dd0150[4]),  4,9},
  {&(_tg__ZTV5cc150__6dd0150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd0150[4]),  4,5},
  {&(_ZTV6dd0150[8]),  8,9},
  {&(_tg__ZTV4bb50__6dd0150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
Class_Descriptor cd_dd0150 = {  "dd0150", // class name
  bases_dd0150, 3,
  &(vtc_dd0150[0]), // expected_vtbl_contents
  &(vtt_dd0150[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd0150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0150),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0150),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00150  : dd0150 {
  int e;
  ~ee00150(); // tgen
  ee00150(); // tgen
};
//SIG(1 ee00150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00150 ::~ee00150(){ note_dtor("ee00150", this);} // tgen
ee00150 ::ee00150(){ note_ctor("ee00150", this);} // tgen

static void Test_ee00150()
{
  extern Class_Descriptor cd_ee00150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee00150, buf);
    ee00150 *dp, &lv = *(dp=new (buf) ee00150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee00150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee00150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(24,16), "ee00150");
    check_base_class_offset(lv, (cc150*)(dd0150*), 0, "ee00150");
    check_base_class_offset(lv, (dd0150*), 0, "ee00150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00150.e");
    test_class_info(&lv, &cd_ee00150);
    dp->~ee00150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00150(Test_ee00150, "ee00150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee00150C1Ev();
extern void _ZN7ee00150D1Ev();
Name_Map name_map_ee00150[] = {
  NSPAIR(_ZN7ee00150C1Ev),
  NSPAIR(_ZN7ee00150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee00150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee00150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee00150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee00150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee00150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee00150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee00150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee00150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee00150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee00150[] = {
  {&(_ZTV7ee00150[4]),  4,9},
  {&(_tg__ZTV6dd0150__7ee00150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee00150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee00150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee00150[4]),  4,5},
  {&(_ZTV7ee00150[8]),  8,9},
  {&(_tg__ZTV4bb50__7ee00150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee00150[];
extern  VTBL_ENTRY _ZTV7ee00150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00150[];
Class_Descriptor cd_ee00150 = {  "ee00150", // class name
  bases_ee00150, 4,
  &(vtc_ee00150[0]), // expected_vtbl_contents
  &(vtt_ee00150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee00150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00150),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10150  : virtual dd0150 {
  int e;
  ~ee10150(); // tgen
  ee10150(); // tgen
};
//SIG(1 ee10150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10150 ::~ee10150(){ note_dtor("ee10150", this);} // tgen
ee10150 ::ee10150(){ note_ctor("ee10150", this);} // tgen

static void Test_ee10150()
{
  extern Class_Descriptor cd_ee10150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee10150, buf);
    ee10150 *dp, &lv = *(dp=new (buf) ee10150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee10150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee10150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(32,20), "ee10150");
    check_base_class_offset(lv, (cc150*)(dd0150*), ABISELECT(16,8), "ee10150");
    check_base_class_offset(lv, (dd0150*), ABISELECT(16,8), "ee10150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10150.e");
    test_class_info(&lv, &cd_ee10150);
    dp->~ee10150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10150(Test_ee10150, "ee10150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee10150C1Ev();
extern void _ZN7ee10150D1Ev();
Name_Map name_map_ee10150[] = {
  NSPAIR(_ZN7ee10150C1Ev),
  NSPAIR(_ZN7ee10150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee10150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee10150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10150[0]),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee10150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee10150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee10150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee10150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee10150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee10150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee10150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee10150[] = {
  {&(_ZTV7ee10150[5]),  5,14},
  {&(_ZTV7ee10150[9]),  9,14},
  {&(_ZTV7ee10150[13]),  13,14},
  {&(_tg__ZTV6dd0150__7ee10150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee10150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee10150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee10150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee10150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10150[];
extern  VTBL_ENTRY _ZTV7ee10150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10150[];
Class_Descriptor cd_ee10150 = {  "ee10150", // class name
  bases_ee10150, 4,
  &(vtc_ee10150[0]), // expected_vtbl_contents
  &(vtt_ee10150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee10150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10150),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20150  : dd0150 {
  int e;
  virtual void  foo(); // _ZN7ee201503fooEv
  ~ee20150(); // tgen
  ee20150(); // tgen
};
//SIG(1 ee20150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee20150 ::foo(){vfunc_called(this, "_ZN7ee201503fooEv");}
ee20150 ::~ee20150(){ note_dtor("ee20150", this);} // tgen
ee20150 ::ee20150(){ note_ctor("ee20150", this);} // tgen

static void Test_ee20150()
{
  extern Class_Descriptor cd_ee20150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee20150, buf);
    ee20150 *dp, &lv = *(dp=new (buf) ee20150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee20150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee20150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(24,16), "ee20150");
    check_base_class_offset(lv, (cc150*)(dd0150*), 0, "ee20150");
    check_base_class_offset(lv, (dd0150*), 0, "ee20150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20150.e");
    test_class_info(&lv, &cd_ee20150);
    dp->~ee20150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20150(Test_ee20150, "ee20150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee20150C1Ev();
extern void _ZN7ee20150D1Ev();
Name_Map name_map_ee20150[] = {
  NSPAIR(_ZN7ee20150C1Ev),
  NSPAIR(_ZN7ee20150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee20150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20150[];
extern void _ZN7ee201503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee20150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20150[0]),
  (VTBL_ENTRY)&_ZN7ee201503fooEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee20150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee20150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee20150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee20150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee20150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee20150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee20150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee20150[] = {
  {&(_ZTV7ee20150[4]),  4,10},
  {&(_tg__ZTV6dd0150__7ee20150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee20150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee20150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee20150[4]),  4,5},
  {&(_ZTV7ee20150[9]),  9,10},
  {&(_tg__ZTV4bb50__7ee20150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee20150[];
extern  VTBL_ENTRY _ZTV7ee20150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20150[];
Class_Descriptor cd_ee20150 = {  "ee20150", // class name
  bases_ee20150, 4,
  &(vtc_ee20150[0]), // expected_vtbl_contents
  &(vtt_ee20150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee20150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30150  : virtual dd0150 {
  int e;
  virtual void  foo(); // _ZN7ee301503fooEv
  ~ee30150(); // tgen
  ee30150(); // tgen
};
//SIG(1 ee30150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee30150 ::foo(){vfunc_called(this, "_ZN7ee301503fooEv");}
ee30150 ::~ee30150(){ note_dtor("ee30150", this);} // tgen
ee30150 ::ee30150(){ note_ctor("ee30150", this);} // tgen

static void Test_ee30150()
{
  extern Class_Descriptor cd_ee30150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee30150, buf);
    ee30150 *dp, &lv = *(dp=new (buf) ee30150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee30150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee30150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(32,20), "ee30150");
    check_base_class_offset(lv, (cc150*)(dd0150*), ABISELECT(16,8), "ee30150");
    check_base_class_offset(lv, (dd0150*), ABISELECT(16,8), "ee30150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30150.e");
    test_class_info(&lv, &cd_ee30150);
    dp->~ee30150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30150(Test_ee30150, "ee30150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee30150C1Ev();
extern void _ZN7ee30150D1Ev();
Name_Map name_map_ee30150[] = {
  NSPAIR(_ZN7ee30150C1Ev),
  NSPAIR(_ZN7ee30150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee30150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30150[];
extern void _ZN7ee301503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee30150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30150[0]),
  (VTBL_ENTRY)&_ZN7ee301503fooEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee30150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee30150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee30150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee30150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee30150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee30150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee30150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee30150[] = {
  {&(_ZTV7ee30150[5]),  5,15},
  {&(_ZTV7ee30150[10]),  10,15},
  {&(_ZTV7ee30150[14]),  14,15},
  {&(_tg__ZTV6dd0150__7ee30150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee30150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee30150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee30150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee30150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30150[];
extern  VTBL_ENTRY _ZTV7ee30150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30150[];
Class_Descriptor cd_ee30150 = {  "ee30150", // class name
  bases_ee30150, 4,
  &(vtc_ee30150[0]), // expected_vtbl_contents
  &(vtt_ee30150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee30150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40150  : dd0150 {
  int e;
  virtual void  bar(); // _ZN7ee401503barEv
  ~ee40150(); // tgen
  ee40150(); // tgen
};
//SIG(1 ee40150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee40150 ::bar(){vfunc_called(this, "_ZN7ee401503barEv");}
ee40150 ::~ee40150(){ note_dtor("ee40150", this);} // tgen
ee40150 ::ee40150(){ note_ctor("ee40150", this);} // tgen

static void Test_ee40150()
{
  extern Class_Descriptor cd_ee40150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee40150, buf);
    ee40150 *dp, &lv = *(dp=new (buf) ee40150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee40150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee40150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(24,16), "ee40150");
    check_base_class_offset(lv, (cc150*)(dd0150*), 0, "ee40150");
    check_base_class_offset(lv, (dd0150*), 0, "ee40150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40150.e");
    test_class_info(&lv, &cd_ee40150);
    dp->~ee40150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40150(Test_ee40150, "ee40150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee40150C1Ev();
extern void _ZN7ee40150D1Ev();
Name_Map name_map_ee40150[] = {
  NSPAIR(_ZN7ee40150C1Ev),
  NSPAIR(_ZN7ee40150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee40150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40150[];
extern void _ZN7ee401503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee401503barEv,_ZTv0_n16_N7ee401503barEv)();
extern void ABISELECT(_ZThn24_N7ee401503barEv,_ZThn16_N7ee401503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee40150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40150[0]),
  (VTBL_ENTRY)&_ZN7ee401503barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee40150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee401503barEv,_ZTv0_n16_N7ee401503barEv),
};
extern VTBL_ENTRY _ZTV7ee40150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee40150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee40150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee40150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee40150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee40150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee40150[] = {
  {&(_ZTV7ee40150[4]),  4,10},
  {&(_tg__ZTV6dd0150__7ee40150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee40150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee40150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee40150[4]),  4,5},
  {&(_ZTV7ee40150[9]),  9,10},
  {&(_tg__ZTV4bb50__7ee40150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee40150[];
extern  VTBL_ENTRY _ZTV7ee40150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40150[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee401503barEv,_ZTv0_n16_N7ee401503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee401503barEv,_ZThn16_N7ee401503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee40150 = {  "ee40150", // class name
  bases_ee40150, 4,
  &(vtc_ee40150[0]), // expected_vtbl_contents
  &(vtt_ee40150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee40150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50150  : virtual dd0150 {
  int e;
  virtual void  bar(); // _ZN7ee501503barEv
  ~ee50150(); // tgen
  ee50150(); // tgen
};
//SIG(1 ee50150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee50150 ::bar(){vfunc_called(this, "_ZN7ee501503barEv");}
ee50150 ::~ee50150(){ note_dtor("ee50150", this);} // tgen
ee50150 ::ee50150(){ note_ctor("ee50150", this);} // tgen

static void Test_ee50150()
{
  extern Class_Descriptor cd_ee50150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee50150, buf);
    ee50150 *dp, &lv = *(dp=new (buf) ee50150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee50150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee50150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(32,20), "ee50150");
    check_base_class_offset(lv, (cc150*)(dd0150*), ABISELECT(16,8), "ee50150");
    check_base_class_offset(lv, (dd0150*), ABISELECT(16,8), "ee50150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50150.e");
    test_class_info(&lv, &cd_ee50150);
    dp->~ee50150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50150(Test_ee50150, "ee50150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee50150C1Ev();
extern void _ZN7ee50150D1Ev();
Name_Map name_map_ee50150[] = {
  NSPAIR(_ZN7ee50150C1Ev),
  NSPAIR(_ZN7ee50150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee50150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50150[];
extern void _ZN7ee501503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee501503barEv,_ZTv0_n16_N7ee501503barEv)();
extern void ABISELECT(_ZThn32_N7ee501503barEv,_ZThn20_N7ee501503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee50150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50150[0]),
  (VTBL_ENTRY)&_ZN7ee501503barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee50150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee501503barEv,_ZTv0_n16_N7ee501503barEv),
};
extern VTBL_ENTRY _ZTV7ee50150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee50150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee50150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee50150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee50150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee50150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee50150[] = {
  {&(_ZTV7ee50150[5]),  5,15},
  {&(_ZTV7ee50150[10]),  10,15},
  {&(_ZTV7ee50150[14]),  14,15},
  {&(_tg__ZTV6dd0150__7ee50150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee50150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee50150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee50150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee50150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50150[];
extern  VTBL_ENTRY _ZTV7ee50150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50150[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee501503barEv,_ZTv0_n16_N7ee501503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee501503barEv,_ZThn20_N7ee501503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50150 = {  "ee50150", // class name
  bases_ee50150, 4,
  &(vtc_ee50150[0]), // expected_vtbl_contents
  &(vtt_ee50150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee50150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60150  : dd0150 {
  int e;
  virtual void  foo(); // _ZN7ee601503fooEv
  virtual void  bar(); // _ZN7ee601503barEv
  ~ee60150(); // tgen
  ee60150(); // tgen
};
//SIG(1 ee60150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee60150 ::foo(){vfunc_called(this, "_ZN7ee601503fooEv");}
void  ee60150 ::bar(){vfunc_called(this, "_ZN7ee601503barEv");}
ee60150 ::~ee60150(){ note_dtor("ee60150", this);} // tgen
ee60150 ::ee60150(){ note_ctor("ee60150", this);} // tgen

static void Test_ee60150()
{
  extern Class_Descriptor cd_ee60150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee60150, buf);
    ee60150 *dp, &lv = *(dp=new (buf) ee60150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee60150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee60150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(24,16), "ee60150");
    check_base_class_offset(lv, (cc150*)(dd0150*), 0, "ee60150");
    check_base_class_offset(lv, (dd0150*), 0, "ee60150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60150.e");
    test_class_info(&lv, &cd_ee60150);
    dp->~ee60150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60150(Test_ee60150, "ee60150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee60150C1Ev();
extern void _ZN7ee60150D1Ev();
Name_Map name_map_ee60150[] = {
  NSPAIR(_ZN7ee60150C1Ev),
  NSPAIR(_ZN7ee60150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee60150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60150[];
extern void _ZN7ee601503fooEv();
extern void _ZN7ee601503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee601503barEv,_ZTv0_n16_N7ee601503barEv)();
extern void ABISELECT(_ZThn24_N7ee601503barEv,_ZThn16_N7ee601503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee60150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60150[0]),
  (VTBL_ENTRY)&_ZN7ee601503fooEv,
  (VTBL_ENTRY)&_ZN7ee601503barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee60150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee601503barEv,_ZTv0_n16_N7ee601503barEv),
};
extern VTBL_ENTRY _ZTV7ee60150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee60150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee60150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee60150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee60150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee60150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee60150[] = {
  {&(_ZTV7ee60150[4]),  4,11},
  {&(_tg__ZTV6dd0150__7ee60150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee60150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee60150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee60150[4]),  4,5},
  {&(_ZTV7ee60150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee60150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee60150[];
extern  VTBL_ENTRY _ZTV7ee60150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60150[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee601503barEv,_ZTv0_n16_N7ee601503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601503barEv,_ZThn16_N7ee601503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee60150 = {  "ee60150", // class name
  bases_ee60150, 4,
  &(vtc_ee60150[0]), // expected_vtbl_contents
  &(vtt_ee60150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee60150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70150  : virtual dd0150 {
  int e;
  virtual void  foo(); // _ZN7ee701503fooEv
  virtual void  bar(); // _ZN7ee701503barEv
  ~ee70150(); // tgen
  ee70150(); // tgen
};
//SIG(1 ee70150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee70150 ::foo(){vfunc_called(this, "_ZN7ee701503fooEv");}
void  ee70150 ::bar(){vfunc_called(this, "_ZN7ee701503barEv");}
ee70150 ::~ee70150(){ note_dtor("ee70150", this);} // tgen
ee70150 ::ee70150(){ note_ctor("ee70150", this);} // tgen

static void Test_ee70150()
{
  extern Class_Descriptor cd_ee70150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee70150, buf);
    ee70150 *dp, &lv = *(dp=new (buf) ee70150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee70150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee70150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd0150*), ABISELECT(32,20), "ee70150");
    check_base_class_offset(lv, (cc150*)(dd0150*), ABISELECT(16,8), "ee70150");
    check_base_class_offset(lv, (dd0150*), ABISELECT(16,8), "ee70150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70150.e");
    test_class_info(&lv, &cd_ee70150);
    dp->~ee70150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70150(Test_ee70150, "ee70150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee70150C1Ev();
extern void _ZN7ee70150D1Ev();
Name_Map name_map_ee70150[] = {
  NSPAIR(_ZN7ee70150C1Ev),
  NSPAIR(_ZN7ee70150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd0150;
extern VTBL_ENTRY _ZTI6dd0150[];
extern  VTBL_ENTRY _ZTV6dd0150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0150[];
static Base_Class bases_ee70150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70150[];
extern void _ZN7ee701503fooEv();
extern void _ZN7ee701503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee701503barEv,_ZTv0_n16_N7ee701503barEv)();
extern void ABISELECT(_ZThn32_N7ee701503barEv,_ZThn20_N7ee701503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70150[0]),
  (VTBL_ENTRY)&_ZN7ee701503fooEv,
  (VTBL_ENTRY)&_ZN7ee701503barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee70150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee701503barEv,_ZTv0_n16_N7ee701503barEv),
};
extern VTBL_ENTRY _ZTV7ee70150[];
static  VTBL_ENTRY _tg__ZTV6dd0150__7ee70150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd0150__7ee70150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd0150__7ee70150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd0150__7ee70150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee70150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee70150[] = {
  {&(_ZTV7ee70150[5]),  5,16},
  {&(_ZTV7ee70150[11]),  11,16},
  {&(_ZTV7ee70150[15]),  15,16},
  {&(_tg__ZTV6dd0150__7ee70150[4]),  4,4},
  {&(_tg__ZTV5cc1506dd0150__7ee70150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd0150__7ee70150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd0150__7ee70150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee70150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70150[];
extern  VTBL_ENTRY _ZTV7ee70150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70150[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee701503barEv,_ZTv0_n16_N7ee701503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701503barEv,_ZThn20_N7ee701503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70150 = {  "ee70150", // class name
  bases_ee70150, 4,
  &(vtc_ee70150[0]), // expected_vtbl_contents
  &(vtt_ee70150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee70150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1150  : virtual cc150 {
  int d;
  ~dd1150(); // tgen
  dd1150(); // tgen
};
//SIG(-1 dd1150) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd1150 ::~dd1150(){ note_dtor("dd1150", this);} // tgen
dd1150 ::dd1150(){ note_ctor("dd1150", this);} // tgen

static void Test_dd1150()
{
  extern Class_Descriptor cd_dd1150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd1150, buf);
    dd1150 *dp, &lv = *(dp=new (buf) dd1150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd1150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,24), "dd1150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,16), "dd1150");
    check_base_class_offset(lv, (cc150*), ABISELECT(16,8), "dd1150");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1150.d");
    test_class_info(&lv, &cd_dd1150);
    dp->~dd1150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1150(Test_dd1150, "dd1150", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd1150C1Ev();
extern void _ZN6dd1150D1Ev();
Name_Map name_map_dd1150[] = {
  NSPAIR(_ZN6dd1150C1Ev),
  NSPAIR(_ZN6dd1150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd1150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_dd1150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV6dd1150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd1150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd1150[] = {
  {&(_ZTV6dd1150[5]),  5,14},
  {&(_ZTV6dd1150[9]),  9,14},
  {&(_ZTV6dd1150[13]),  13,14},
  {&(_tg__ZTV5cc150__6dd1150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd1150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd1150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
Class_Descriptor cd_dd1150 = {  "dd1150", // class name
  bases_dd1150, 3,
  &(vtc_dd1150[0]), // expected_vtbl_contents
  &(vtt_dd1150[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd1150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1150),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1150),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01150  : dd1150 {
  int e;
  ~ee01150(); // tgen
  ee01150(); // tgen
};
//SIG(1 ee01150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01150 ::~ee01150(){ note_dtor("ee01150", this);} // tgen
ee01150 ::ee01150(){ note_ctor("ee01150", this);} // tgen

static void Test_ee01150()
{
  extern Class_Descriptor cd_ee01150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee01150, buf);
    ee01150 *dp, &lv = *(dp=new (buf) ee01150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee01150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee01150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee01150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(16,12), "ee01150");
    check_base_class_offset(lv, (dd1150*), 0, "ee01150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01150.e");
    test_class_info(&lv, &cd_ee01150);
    dp->~ee01150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01150(Test_ee01150, "ee01150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee01150C1Ev();
extern void _ZN7ee01150D1Ev();
Name_Map name_map_ee01150[] = {
  NSPAIR(_ZN7ee01150C1Ev),
  NSPAIR(_ZN7ee01150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee01150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee01150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01150[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee01150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee01150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee01150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee01150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee01150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee01150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee01150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee01150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee01150[] = {
  {&(_ZTV7ee01150[5]),  5,14},
  {&(_tg__ZTV6dd1150__7ee01150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee01150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee01150[4]),  4,5},
  {&(_ZTV7ee01150[9]),  9,14},
  {&(_ZTV7ee01150[13]),  13,14},
  {&(_tg__ZTV5cc150__7ee01150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee01150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee01150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01150[];
extern  VTBL_ENTRY _ZTV7ee01150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01150[];
Class_Descriptor cd_ee01150 = {  "ee01150", // class name
  bases_ee01150, 4,
  &(vtc_ee01150[0]), // expected_vtbl_contents
  &(vtt_ee01150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee01150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01150),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11150  : virtual dd1150 {
  int e;
  ~ee11150(); // tgen
  ee11150(); // tgen
};
//SIG(1 ee11150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11150 ::~ee11150(){ note_dtor("ee11150", this);} // tgen
ee11150 ::ee11150(){ note_ctor("ee11150", this);} // tgen

static void Test_ee11150()
{
  extern Class_Descriptor cd_ee11150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee11150, buf);
    ee11150 *dp, &lv = *(dp=new (buf) ee11150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee11150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee11150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee11150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(32,16), "ee11150");
    check_base_class_offset(lv, (dd1150*), ABISELECT(16,8), "ee11150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11150.e");
    test_class_info(&lv, &cd_ee11150);
    dp->~ee11150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11150(Test_ee11150, "ee11150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee11150C1Ev();
extern void _ZN7ee11150D1Ev();
Name_Map name_map_ee11150[] = {
  NSPAIR(_ZN7ee11150C1Ev),
  NSPAIR(_ZN7ee11150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee11150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11150[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee11150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11150[0]),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11150[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee11150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee11150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee11150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee11150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee11150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee11150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee11150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee11150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee11150[] = {
  {&(_ZTV7ee11150[6]),  6,20},
  {&(_ZTV7ee11150[11]),  11,20},
  {&(_ZTV7ee11150[15]),  15,20},
  {&(_ZTV7ee11150[19]),  19,20},
  {&(_tg__ZTV6dd1150__7ee11150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee11150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee11150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee11150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee11150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee11150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11150[];
extern  VTBL_ENTRY _ZTV7ee11150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11150[];
Class_Descriptor cd_ee11150 = {  "ee11150", // class name
  bases_ee11150, 4,
  &(vtc_ee11150[0]), // expected_vtbl_contents
  &(vtt_ee11150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee11150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11150),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21150  : dd1150 {
  int e;
  virtual void  foo(); // _ZN7ee211503fooEv
  ~ee21150(); // tgen
  ee21150(); // tgen
};
//SIG(1 ee21150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee21150 ::foo(){vfunc_called(this, "_ZN7ee211503fooEv");}
ee21150 ::~ee21150(){ note_dtor("ee21150", this);} // tgen
ee21150 ::ee21150(){ note_ctor("ee21150", this);} // tgen

static void Test_ee21150()
{
  extern Class_Descriptor cd_ee21150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee21150, buf);
    ee21150 *dp, &lv = *(dp=new (buf) ee21150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee21150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee21150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee21150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(16,12), "ee21150");
    check_base_class_offset(lv, (dd1150*), 0, "ee21150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21150.e");
    test_class_info(&lv, &cd_ee21150);
    dp->~ee21150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21150(Test_ee21150, "ee21150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee21150C1Ev();
extern void _ZN7ee21150D1Ev();
Name_Map name_map_ee21150[] = {
  NSPAIR(_ZN7ee21150C1Ev),
  NSPAIR(_ZN7ee21150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee21150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21150[];
extern void _ZN7ee211503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee21150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21150[0]),
  (VTBL_ENTRY)&_ZN7ee211503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee21150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee21150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee21150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee21150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee21150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee21150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee21150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee21150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee21150[] = {
  {&(_ZTV7ee21150[5]),  5,15},
  {&(_tg__ZTV6dd1150__7ee21150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee21150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee21150[4]),  4,5},
  {&(_ZTV7ee21150[10]),  10,15},
  {&(_ZTV7ee21150[14]),  14,15},
  {&(_tg__ZTV5cc150__7ee21150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee21150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee21150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21150[];
extern  VTBL_ENTRY _ZTV7ee21150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21150[];
Class_Descriptor cd_ee21150 = {  "ee21150", // class name
  bases_ee21150, 4,
  &(vtc_ee21150[0]), // expected_vtbl_contents
  &(vtt_ee21150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee21150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31150  : virtual dd1150 {
  int e;
  virtual void  foo(); // _ZN7ee311503fooEv
  ~ee31150(); // tgen
  ee31150(); // tgen
};
//SIG(1 ee31150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee31150 ::foo(){vfunc_called(this, "_ZN7ee311503fooEv");}
ee31150 ::~ee31150(){ note_dtor("ee31150", this);} // tgen
ee31150 ::ee31150(){ note_ctor("ee31150", this);} // tgen

static void Test_ee31150()
{
  extern Class_Descriptor cd_ee31150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee31150, buf);
    ee31150 *dp, &lv = *(dp=new (buf) ee31150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee31150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee31150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee31150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(32,16), "ee31150");
    check_base_class_offset(lv, (dd1150*), ABISELECT(16,8), "ee31150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31150.e");
    test_class_info(&lv, &cd_ee31150);
    dp->~ee31150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31150(Test_ee31150, "ee31150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee31150C1Ev();
extern void _ZN7ee31150D1Ev();
Name_Map name_map_ee31150[] = {
  NSPAIR(_ZN7ee31150C1Ev),
  NSPAIR(_ZN7ee31150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee31150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31150[];
extern void _ZN7ee311503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee31150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31150[0]),
  (VTBL_ENTRY)&_ZN7ee311503fooEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31150[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee31150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee31150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee31150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee31150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee31150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee31150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee31150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee31150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee31150[] = {
  {&(_ZTV7ee31150[6]),  6,21},
  {&(_ZTV7ee31150[12]),  12,21},
  {&(_ZTV7ee31150[16]),  16,21},
  {&(_ZTV7ee31150[20]),  20,21},
  {&(_tg__ZTV6dd1150__7ee31150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee31150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee31150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee31150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee31150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee31150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31150[];
extern  VTBL_ENTRY _ZTV7ee31150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31150[];
Class_Descriptor cd_ee31150 = {  "ee31150", // class name
  bases_ee31150, 4,
  &(vtc_ee31150[0]), // expected_vtbl_contents
  &(vtt_ee31150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee31150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31150),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41150  : dd1150 {
  int e;
  virtual void  bar(); // _ZN7ee411503barEv
  ~ee41150(); // tgen
  ee41150(); // tgen
};
//SIG(1 ee41150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee41150 ::bar(){vfunc_called(this, "_ZN7ee411503barEv");}
ee41150 ::~ee41150(){ note_dtor("ee41150", this);} // tgen
ee41150 ::ee41150(){ note_ctor("ee41150", this);} // tgen

static void Test_ee41150()
{
  extern Class_Descriptor cd_ee41150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee41150, buf);
    ee41150 *dp, &lv = *(dp=new (buf) ee41150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee41150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee41150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee41150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(16,12), "ee41150");
    check_base_class_offset(lv, (dd1150*), 0, "ee41150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41150.e");
    test_class_info(&lv, &cd_ee41150);
    dp->~ee41150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41150(Test_ee41150, "ee41150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee41150C1Ev();
extern void _ZN7ee41150D1Ev();
Name_Map name_map_ee41150[] = {
  NSPAIR(_ZN7ee41150C1Ev),
  NSPAIR(_ZN7ee41150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee41150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41150[];
extern void _ZN7ee411503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee411503barEv,_ZTv0_n16_N7ee411503barEv)();
extern void ABISELECT(_ZThn32_N7ee411503barEv,_ZThn20_N7ee411503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee41150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41150[0]),
  (VTBL_ENTRY)&_ZN7ee411503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee41150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee411503barEv,_ZTv0_n16_N7ee411503barEv),
};
extern VTBL_ENTRY _ZTV7ee41150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee41150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee41150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee41150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee41150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee41150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee41150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee41150[] = {
  {&(_ZTV7ee41150[5]),  5,15},
  {&(_tg__ZTV6dd1150__7ee41150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee41150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee41150[4]),  4,5},
  {&(_ZTV7ee41150[10]),  10,15},
  {&(_ZTV7ee41150[14]),  14,15},
  {&(_tg__ZTV5cc150__7ee41150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee41150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee41150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41150[];
extern  VTBL_ENTRY _ZTV7ee41150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41150[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee411503barEv,_ZTv0_n16_N7ee411503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee411503barEv,_ZThn20_N7ee411503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41150 = {  "ee41150", // class name
  bases_ee41150, 4,
  &(vtc_ee41150[0]), // expected_vtbl_contents
  &(vtt_ee41150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee41150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51150  : virtual dd1150 {
  int e;
  virtual void  bar(); // _ZN7ee511503barEv
  ~ee51150(); // tgen
  ee51150(); // tgen
};
//SIG(1 ee51150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee51150 ::bar(){vfunc_called(this, "_ZN7ee511503barEv");}
ee51150 ::~ee51150(){ note_dtor("ee51150", this);} // tgen
ee51150 ::ee51150(){ note_ctor("ee51150", this);} // tgen

static void Test_ee51150()
{
  extern Class_Descriptor cd_ee51150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee51150, buf);
    ee51150 *dp, &lv = *(dp=new (buf) ee51150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee51150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee51150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee51150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(32,16), "ee51150");
    check_base_class_offset(lv, (dd1150*), ABISELECT(16,8), "ee51150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51150.e");
    test_class_info(&lv, &cd_ee51150);
    dp->~ee51150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51150(Test_ee51150, "ee51150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee51150C1Ev();
extern void _ZN7ee51150D1Ev();
Name_Map name_map_ee51150[] = {
  NSPAIR(_ZN7ee51150C1Ev),
  NSPAIR(_ZN7ee51150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee51150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51150[];
extern void _ZN7ee511503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee511503barEv,_ZTv0_n16_N7ee511503barEv)();
extern void ABISELECT(_ZThn48_N7ee511503barEv,_ZThn24_N7ee511503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee51150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51150[0]),
  (VTBL_ENTRY)&_ZN7ee511503barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51150[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee51150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee511503barEv,_ZTv0_n16_N7ee511503barEv),
};
extern VTBL_ENTRY _ZTV7ee51150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee51150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee51150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee51150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee51150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee51150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee51150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee51150[] = {
  {&(_ZTV7ee51150[6]),  6,21},
  {&(_ZTV7ee51150[12]),  12,21},
  {&(_ZTV7ee51150[16]),  16,21},
  {&(_ZTV7ee51150[20]),  20,21},
  {&(_tg__ZTV6dd1150__7ee51150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee51150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee51150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee51150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee51150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee51150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51150[];
extern  VTBL_ENTRY _ZTV7ee51150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51150[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee511503barEv,_ZTv0_n16_N7ee511503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee511503barEv,_ZThn24_N7ee511503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51150 = {  "ee51150", // class name
  bases_ee51150, 4,
  &(vtc_ee51150[0]), // expected_vtbl_contents
  &(vtt_ee51150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee51150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51150),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61150  : dd1150 {
  int e;
  virtual void  foo(); // _ZN7ee611503fooEv
  virtual void  bar(); // _ZN7ee611503barEv
  ~ee61150(); // tgen
  ee61150(); // tgen
};
//SIG(1 ee61150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee61150 ::foo(){vfunc_called(this, "_ZN7ee611503fooEv");}
void  ee61150 ::bar(){vfunc_called(this, "_ZN7ee611503barEv");}
ee61150 ::~ee61150(){ note_dtor("ee61150", this);} // tgen
ee61150 ::ee61150(){ note_ctor("ee61150", this);} // tgen

static void Test_ee61150()
{
  extern Class_Descriptor cd_ee61150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee61150, buf);
    ee61150 *dp, &lv = *(dp=new (buf) ee61150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee61150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee61150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee61150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(16,12), "ee61150");
    check_base_class_offset(lv, (dd1150*), 0, "ee61150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61150.e");
    test_class_info(&lv, &cd_ee61150);
    dp->~ee61150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61150(Test_ee61150, "ee61150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee61150C1Ev();
extern void _ZN7ee61150D1Ev();
Name_Map name_map_ee61150[] = {
  NSPAIR(_ZN7ee61150C1Ev),
  NSPAIR(_ZN7ee61150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee61150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61150[];
extern void _ZN7ee611503fooEv();
extern void _ZN7ee611503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee611503barEv,_ZTv0_n16_N7ee611503barEv)();
extern void ABISELECT(_ZThn32_N7ee611503barEv,_ZThn20_N7ee611503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61150[0]),
  (VTBL_ENTRY)&_ZN7ee611503fooEv,
  (VTBL_ENTRY)&_ZN7ee611503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee61150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee611503barEv,_ZTv0_n16_N7ee611503barEv),
};
extern VTBL_ENTRY _ZTV7ee61150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee61150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee61150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee61150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee61150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee61150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee61150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee61150[] = {
  {&(_ZTV7ee61150[5]),  5,16},
  {&(_tg__ZTV6dd1150__7ee61150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee61150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee61150[4]),  4,5},
  {&(_ZTV7ee61150[11]),  11,16},
  {&(_ZTV7ee61150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee61150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee61150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee61150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61150[];
extern  VTBL_ENTRY _ZTV7ee61150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61150[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee611503barEv,_ZTv0_n16_N7ee611503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611503barEv,_ZThn20_N7ee611503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61150 = {  "ee61150", // class name
  bases_ee61150, 4,
  &(vtc_ee61150[0]), // expected_vtbl_contents
  &(vtt_ee61150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee61150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71150  : virtual dd1150 {
  int e;
  virtual void  foo(); // _ZN7ee711503fooEv
  virtual void  bar(); // _ZN7ee711503barEv
  ~ee71150(); // tgen
  ee71150(); // tgen
};
//SIG(1 ee71150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee71150 ::foo(){vfunc_called(this, "_ZN7ee711503fooEv");}
void  ee71150 ::bar(){vfunc_called(this, "_ZN7ee711503barEv");}
ee71150 ::~ee71150(){ note_dtor("ee71150", this);} // tgen
ee71150 ::ee71150(){ note_ctor("ee71150", this);} // tgen

static void Test_ee71150()
{
  extern Class_Descriptor cd_ee71150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee71150, buf);
    ee71150 *dp, &lv = *(dp=new (buf) ee71150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee71150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee71150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee71150");
    check_base_class_offset(lv, (cc150*)(dd1150*), ABISELECT(32,16), "ee71150");
    check_base_class_offset(lv, (dd1150*), ABISELECT(16,8), "ee71150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71150.e");
    test_class_info(&lv, &cd_ee71150);
    dp->~ee71150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71150(Test_ee71150, "ee71150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee71150C1Ev();
extern void _ZN7ee71150D1Ev();
Name_Map name_map_ee71150[] = {
  NSPAIR(_ZN7ee71150C1Ev),
  NSPAIR(_ZN7ee71150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd1150;
extern VTBL_ENTRY _ZTI6dd1150[];
extern  VTBL_ENTRY _ZTV6dd1150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1150[];
static Base_Class bases_ee71150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1150,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71150[];
extern void _ZN7ee711503fooEv();
extern void _ZN7ee711503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee711503barEv,_ZTv0_n16_N7ee711503barEv)();
extern void ABISELECT(_ZThn48_N7ee711503barEv,_ZThn24_N7ee711503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71150[0]),
  (VTBL_ENTRY)&_ZN7ee711503fooEv,
  (VTBL_ENTRY)&_ZN7ee711503barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71150[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee71150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee711503barEv,_ZTv0_n16_N7ee711503barEv),
};
extern VTBL_ENTRY _ZTV7ee71150[];
static  VTBL_ENTRY _tg__ZTV6dd1150__7ee71150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd1150__7ee71150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd1150__7ee71150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee71150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee71150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee71150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee71150[] = {
  {&(_ZTV7ee71150[6]),  6,22},
  {&(_ZTV7ee71150[13]),  13,22},
  {&(_ZTV7ee71150[17]),  17,22},
  {&(_ZTV7ee71150[21]),  21,22},
  {&(_tg__ZTV6dd1150__7ee71150[5]),  5,5},
  {&(_tg__ZTV5cc150__6dd1150__7ee71150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd1150__7ee71150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee71150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee71150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee71150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71150[];
extern  VTBL_ENTRY _ZTV7ee71150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71150[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee711503barEv,_ZTv0_n16_N7ee711503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711503barEv,_ZThn24_N7ee711503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71150 = {  "ee71150", // class name
  bases_ee71150, 4,
  &(vtc_ee71150[0]), // expected_vtbl_contents
  &(vtt_ee71150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee71150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71150),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2150  : cc150 {
  int d;
  virtual void  foo(); // _ZN6dd21503fooEv
  ~dd2150(); // tgen
  dd2150(); // tgen
};
//SIG(-1 dd2150) C1{ BC2{ VBC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd2150 ::foo(){vfunc_called(this, "_ZN6dd21503fooEv");}
dd2150 ::~dd2150(){ note_dtor("dd2150", this);} // tgen
dd2150 ::dd2150(){ note_ctor("dd2150", this);} // tgen

static void Test_dd2150()
{
  extern Class_Descriptor cd_dd2150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd2150, buf);
    dd2150 *dp, &lv = *(dp=new (buf) dd2150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd2150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(28,20), "dd2150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(16,12), "dd2150");
    check_base_class_offset(lv, (cc150*), 0, "dd2150");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2150.d");
    test_class_info(&lv, &cd_dd2150);
    dp->~dd2150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2150(Test_dd2150, "dd2150", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd2150C1Ev();
extern void _ZN6dd2150D1Ev();
Name_Map name_map_dd2150[] = {
  NSPAIR(_ZN6dd2150C1Ev),
  NSPAIR(_ZN6dd2150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd2150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2150[];
extern void _ZN6dd21503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_dd2150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV6dd2150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd2150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd2150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd2150[] = {
  {&(_ZTV6dd2150[4]),  4,10},
  {&(_tg__ZTV5cc150__6dd2150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd2150[4]),  4,5},
  {&(_ZTV6dd2150[9]),  9,10},
  {&(_tg__ZTV4bb50__6dd2150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
Class_Descriptor cd_dd2150 = {  "dd2150", // class name
  bases_dd2150, 3,
  &(vtc_dd2150[0]), // expected_vtbl_contents
  &(vtt_dd2150[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd2150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2150),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02150  : dd2150 {
  int e;
  ~ee02150(); // tgen
  ee02150(); // tgen
};
//SIG(1 ee02150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee02150 ::~ee02150(){ note_dtor("ee02150", this);} // tgen
ee02150 ::ee02150(){ note_ctor("ee02150", this);} // tgen

static void Test_ee02150()
{
  extern Class_Descriptor cd_ee02150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee02150, buf);
    ee02150 *dp, &lv = *(dp=new (buf) ee02150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee02150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee02150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(24,16), "ee02150");
    check_base_class_offset(lv, (cc150*)(dd2150*), 0, "ee02150");
    check_base_class_offset(lv, (dd2150*), 0, "ee02150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02150.e");
    test_class_info(&lv, &cd_ee02150);
    dp->~ee02150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02150(Test_ee02150, "ee02150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee02150C1Ev();
extern void _ZN7ee02150D1Ev();
Name_Map name_map_ee02150[] = {
  NSPAIR(_ZN7ee02150C1Ev),
  NSPAIR(_ZN7ee02150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee02150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02150[];
extern void _ZN6dd21503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee02150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee02150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee02150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee02150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee02150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee02150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee02150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee02150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee02150[] = {
  {&(_ZTV7ee02150[4]),  4,10},
  {&(_tg__ZTV6dd2150__7ee02150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee02150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee02150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee02150[4]),  4,5},
  {&(_ZTV7ee02150[9]),  9,10},
  {&(_tg__ZTV4bb50__7ee02150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee02150[];
extern  VTBL_ENTRY _ZTV7ee02150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02150[];
Class_Descriptor cd_ee02150 = {  "ee02150", // class name
  bases_ee02150, 4,
  &(vtc_ee02150[0]), // expected_vtbl_contents
  &(vtt_ee02150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee02150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12150  : virtual dd2150 {
  int e;
  ~ee12150(); // tgen
  ee12150(); // tgen
};
//SIG(1 ee12150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee12150 ::~ee12150(){ note_dtor("ee12150", this);} // tgen
ee12150 ::ee12150(){ note_ctor("ee12150", this);} // tgen

static void Test_ee12150()
{
  extern Class_Descriptor cd_ee12150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee12150, buf);
    ee12150 *dp, &lv = *(dp=new (buf) ee12150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee12150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee12150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(32,20), "ee12150");
    check_base_class_offset(lv, (cc150*)(dd2150*), ABISELECT(16,8), "ee12150");
    check_base_class_offset(lv, (dd2150*), ABISELECT(16,8), "ee12150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12150.e");
    test_class_info(&lv, &cd_ee12150);
    dp->~ee12150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12150(Test_ee12150, "ee12150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee12150C1Ev();
extern void _ZN7ee12150D1Ev();
Name_Map name_map_ee12150[] = {
  NSPAIR(_ZN7ee12150C1Ev),
  NSPAIR(_ZN7ee12150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee12150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12150[];
extern void _ZN6dd21503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee12150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12150[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee12150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee12150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee12150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee12150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee12150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee12150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee12150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee12150[] = {
  {&(_ZTV7ee12150[5]),  5,16},
  {&(_ZTV7ee12150[10]),  10,16},
  {&(_ZTV7ee12150[15]),  15,16},
  {&(_tg__ZTV6dd2150__7ee12150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee12150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee12150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee12150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee12150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee12150[];
extern  VTBL_ENTRY _ZTV7ee12150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12150[];
Class_Descriptor cd_ee12150 = {  "ee12150", // class name
  bases_ee12150, 4,
  &(vtc_ee12150[0]), // expected_vtbl_contents
  &(vtt_ee12150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee12150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22150  : dd2150 {
  int e;
  virtual void  foo(); // _ZN7ee221503fooEv
  ~ee22150(); // tgen
  ee22150(); // tgen
};
//SIG(1 ee22150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee22150 ::foo(){vfunc_called(this, "_ZN7ee221503fooEv");}
ee22150 ::~ee22150(){ note_dtor("ee22150", this);} // tgen
ee22150 ::ee22150(){ note_ctor("ee22150", this);} // tgen

static void Test_ee22150()
{
  extern Class_Descriptor cd_ee22150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee22150, buf);
    ee22150 *dp, &lv = *(dp=new (buf) ee22150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee22150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee22150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(24,16), "ee22150");
    check_base_class_offset(lv, (cc150*)(dd2150*), 0, "ee22150");
    check_base_class_offset(lv, (dd2150*), 0, "ee22150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22150.e");
    test_class_info(&lv, &cd_ee22150);
    dp->~ee22150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22150(Test_ee22150, "ee22150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee22150C1Ev();
extern void _ZN7ee22150D1Ev();
Name_Map name_map_ee22150[] = {
  NSPAIR(_ZN7ee22150C1Ev),
  NSPAIR(_ZN7ee22150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee22150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22150[];
extern void _ZN7ee221503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee22150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22150[0]),
  (VTBL_ENTRY)&_ZN7ee221503fooEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee22150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee22150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee22150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee22150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee22150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee22150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee22150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee22150[] = {
  {&(_ZTV7ee22150[4]),  4,10},
  {&(_tg__ZTV6dd2150__7ee22150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee22150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee22150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee22150[4]),  4,5},
  {&(_ZTV7ee22150[9]),  9,10},
  {&(_tg__ZTV4bb50__7ee22150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee22150[];
extern  VTBL_ENTRY _ZTV7ee22150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22150[];
Class_Descriptor cd_ee22150 = {  "ee22150", // class name
  bases_ee22150, 4,
  &(vtc_ee22150[0]), // expected_vtbl_contents
  &(vtt_ee22150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee22150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32150  : virtual dd2150 {
  int e;
  virtual void  foo(); // _ZN7ee321503fooEv
  ~ee32150(); // tgen
  ee32150(); // tgen
};
//SIG(1 ee32150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee32150 ::foo(){vfunc_called(this, "_ZN7ee321503fooEv");}
ee32150 ::~ee32150(){ note_dtor("ee32150", this);} // tgen
ee32150 ::ee32150(){ note_ctor("ee32150", this);} // tgen

static void Test_ee32150()
{
  extern Class_Descriptor cd_ee32150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee32150, buf);
    ee32150 *dp, &lv = *(dp=new (buf) ee32150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee32150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee32150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(32,20), "ee32150");
    check_base_class_offset(lv, (cc150*)(dd2150*), ABISELECT(16,8), "ee32150");
    check_base_class_offset(lv, (dd2150*), ABISELECT(16,8), "ee32150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32150.e");
    test_class_info(&lv, &cd_ee32150);
    dp->~ee32150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32150(Test_ee32150, "ee32150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee32150C1Ev();
extern void _ZN7ee32150D1Ev();
Name_Map name_map_ee32150[] = {
  NSPAIR(_ZN7ee32150C1Ev),
  NSPAIR(_ZN7ee32150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee32150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32150[];
extern void _ZN7ee321503fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee321503fooEv,_ZTv0_n20_N7ee321503fooEv)();
extern void ABISELECT(_ZThn16_N7ee321503fooEv,_ZThn8_N7ee321503fooEv)() __attribute__((weak));
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee32150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32150[0]),
  (VTBL_ENTRY)&_ZN7ee321503fooEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee321503fooEv,_ZTv0_n20_N7ee321503fooEv),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee32150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee32150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee32150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee32150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee32150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee32150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee32150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee32150[] = {
  {&(_ZTV7ee32150[5]),  5,17},
  {&(_ZTV7ee32150[11]),  11,17},
  {&(_ZTV7ee32150[16]),  16,17},
  {&(_tg__ZTV6dd2150__7ee32150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee32150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee32150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee32150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee32150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee32150[];
extern  VTBL_ENTRY _ZTV7ee32150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32150[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee321503fooEv,_ZTv0_n20_N7ee321503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321503fooEv,_ZThn8_N7ee321503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32150 = {  "ee32150", // class name
  bases_ee32150, 4,
  &(vtc_ee32150[0]), // expected_vtbl_contents
  &(vtt_ee32150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee32150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32150),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42150  : dd2150 {
  int e;
  virtual void  bar(); // _ZN7ee421503barEv
  ~ee42150(); // tgen
  ee42150(); // tgen
};
//SIG(1 ee42150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee42150 ::bar(){vfunc_called(this, "_ZN7ee421503barEv");}
ee42150 ::~ee42150(){ note_dtor("ee42150", this);} // tgen
ee42150 ::ee42150(){ note_ctor("ee42150", this);} // tgen

static void Test_ee42150()
{
  extern Class_Descriptor cd_ee42150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee42150, buf);
    ee42150 *dp, &lv = *(dp=new (buf) ee42150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee42150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee42150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(24,16), "ee42150");
    check_base_class_offset(lv, (cc150*)(dd2150*), 0, "ee42150");
    check_base_class_offset(lv, (dd2150*), 0, "ee42150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42150.e");
    test_class_info(&lv, &cd_ee42150);
    dp->~ee42150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42150(Test_ee42150, "ee42150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee42150C1Ev();
extern void _ZN7ee42150D1Ev();
Name_Map name_map_ee42150[] = {
  NSPAIR(_ZN7ee42150C1Ev),
  NSPAIR(_ZN7ee42150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee42150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42150[];
extern void _ZN6dd21503fooEv();
extern void _ZN7ee421503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee421503barEv,_ZTv0_n16_N7ee421503barEv)();
extern void ABISELECT(_ZThn24_N7ee421503barEv,_ZThn16_N7ee421503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee42150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
  (VTBL_ENTRY)&_ZN7ee421503barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee42150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee421503barEv,_ZTv0_n16_N7ee421503barEv),
};
extern VTBL_ENTRY _ZTV7ee42150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee42150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee42150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee42150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee42150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee42150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee42150[] = {
  {&(_ZTV7ee42150[4]),  4,11},
  {&(_tg__ZTV6dd2150__7ee42150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee42150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee42150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee42150[4]),  4,5},
  {&(_ZTV7ee42150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee42150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee42150[];
extern  VTBL_ENTRY _ZTV7ee42150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42150[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee421503barEv,_ZTv0_n16_N7ee421503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee421503barEv,_ZThn16_N7ee421503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee42150 = {  "ee42150", // class name
  bases_ee42150, 4,
  &(vtc_ee42150[0]), // expected_vtbl_contents
  &(vtt_ee42150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee42150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52150  : virtual dd2150 {
  int e;
  virtual void  bar(); // _ZN7ee521503barEv
  ~ee52150(); // tgen
  ee52150(); // tgen
};
//SIG(1 ee52150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee52150 ::bar(){vfunc_called(this, "_ZN7ee521503barEv");}
ee52150 ::~ee52150(){ note_dtor("ee52150", this);} // tgen
ee52150 ::ee52150(){ note_ctor("ee52150", this);} // tgen

static void Test_ee52150()
{
  extern Class_Descriptor cd_ee52150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee52150, buf);
    ee52150 *dp, &lv = *(dp=new (buf) ee52150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee52150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee52150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(32,20), "ee52150");
    check_base_class_offset(lv, (cc150*)(dd2150*), ABISELECT(16,8), "ee52150");
    check_base_class_offset(lv, (dd2150*), ABISELECT(16,8), "ee52150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52150.e");
    test_class_info(&lv, &cd_ee52150);
    dp->~ee52150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52150(Test_ee52150, "ee52150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee52150C1Ev();
extern void _ZN7ee52150D1Ev();
Name_Map name_map_ee52150[] = {
  NSPAIR(_ZN7ee52150C1Ev),
  NSPAIR(_ZN7ee52150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee52150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52150[];
extern void _ZN7ee521503barEv();
extern void _ZN6dd21503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee521503barEv,_ZTv0_n16_N7ee521503barEv)();
extern void ABISELECT(_ZThn32_N7ee521503barEv,_ZThn20_N7ee521503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee52150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52150[0]),
  (VTBL_ENTRY)&_ZN7ee521503barEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee52150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee521503barEv,_ZTv0_n16_N7ee521503barEv),
};
extern VTBL_ENTRY _ZTV7ee52150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee52150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee52150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee52150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee52150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee52150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee52150[] = {
  {&(_ZTV7ee52150[5]),  5,17},
  {&(_ZTV7ee52150[11]),  11,17},
  {&(_ZTV7ee52150[16]),  16,17},
  {&(_tg__ZTV6dd2150__7ee52150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee52150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee52150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee52150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee52150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee52150[];
extern  VTBL_ENTRY _ZTV7ee52150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52150[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee521503barEv,_ZTv0_n16_N7ee521503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee521503barEv,_ZThn20_N7ee521503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52150 = {  "ee52150", // class name
  bases_ee52150, 4,
  &(vtc_ee52150[0]), // expected_vtbl_contents
  &(vtt_ee52150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee52150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52150),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62150  : dd2150 {
  int e;
  virtual void  foo(); // _ZN7ee621503fooEv
  virtual void  bar(); // _ZN7ee621503barEv
  ~ee62150(); // tgen
  ee62150(); // tgen
};
//SIG(1 ee62150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62150 ::foo(){vfunc_called(this, "_ZN7ee621503fooEv");}
void  ee62150 ::bar(){vfunc_called(this, "_ZN7ee621503barEv");}
ee62150 ::~ee62150(){ note_dtor("ee62150", this);} // tgen
ee62150 ::ee62150(){ note_ctor("ee62150", this);} // tgen

static void Test_ee62150()
{
  extern Class_Descriptor cd_ee62150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee62150, buf);
    ee62150 *dp, &lv = *(dp=new (buf) ee62150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee62150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee62150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(24,16), "ee62150");
    check_base_class_offset(lv, (cc150*)(dd2150*), 0, "ee62150");
    check_base_class_offset(lv, (dd2150*), 0, "ee62150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62150.e");
    test_class_info(&lv, &cd_ee62150);
    dp->~ee62150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62150(Test_ee62150, "ee62150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee62150C1Ev();
extern void _ZN7ee62150D1Ev();
Name_Map name_map_ee62150[] = {
  NSPAIR(_ZN7ee62150C1Ev),
  NSPAIR(_ZN7ee62150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee62150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62150[];
extern void _ZN7ee621503fooEv();
extern void _ZN7ee621503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee621503barEv,_ZTv0_n16_N7ee621503barEv)();
extern void ABISELECT(_ZThn24_N7ee621503barEv,_ZThn16_N7ee621503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee62150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62150[0]),
  (VTBL_ENTRY)&_ZN7ee621503fooEv,
  (VTBL_ENTRY)&_ZN7ee621503barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee62150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee621503barEv,_ZTv0_n16_N7ee621503barEv),
};
extern VTBL_ENTRY _ZTV7ee62150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee62150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee62150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee62150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee62150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee62150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee62150[] = {
  {&(_ZTV7ee62150[4]),  4,11},
  {&(_tg__ZTV6dd2150__7ee62150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee62150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee62150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee62150[4]),  4,5},
  {&(_ZTV7ee62150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee62150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee62150[];
extern  VTBL_ENTRY _ZTV7ee62150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62150[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee621503barEv,_ZTv0_n16_N7ee621503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621503barEv,_ZThn16_N7ee621503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee62150 = {  "ee62150", // class name
  bases_ee62150, 4,
  &(vtc_ee62150[0]), // expected_vtbl_contents
  &(vtt_ee62150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee62150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72150  : virtual dd2150 {
  int e;
  virtual void  foo(); // _ZN7ee721503fooEv
  virtual void  bar(); // _ZN7ee721503barEv
  ~ee72150(); // tgen
  ee72150(); // tgen
};
//SIG(1 ee72150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72150 ::foo(){vfunc_called(this, "_ZN7ee721503fooEv");}
void  ee72150 ::bar(){vfunc_called(this, "_ZN7ee721503barEv");}
ee72150 ::~ee72150(){ note_dtor("ee72150", this);} // tgen
ee72150 ::ee72150(){ note_ctor("ee72150", this);} // tgen

static void Test_ee72150()
{
  extern Class_Descriptor cd_ee72150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee72150, buf);
    ee72150 *dp, &lv = *(dp=new (buf) ee72150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee72150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee72150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd2150*), ABISELECT(32,20), "ee72150");
    check_base_class_offset(lv, (cc150*)(dd2150*), ABISELECT(16,8), "ee72150");
    check_base_class_offset(lv, (dd2150*), ABISELECT(16,8), "ee72150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72150.e");
    test_class_info(&lv, &cd_ee72150);
    dp->~ee72150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72150(Test_ee72150, "ee72150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee72150C1Ev();
extern void _ZN7ee72150D1Ev();
Name_Map name_map_ee72150[] = {
  NSPAIR(_ZN7ee72150C1Ev),
  NSPAIR(_ZN7ee72150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd2150;
extern VTBL_ENTRY _ZTI6dd2150[];
extern  VTBL_ENTRY _ZTV6dd2150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2150[];
static Base_Class bases_ee72150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72150[];
extern void _ZN7ee721503fooEv();
extern void _ZN7ee721503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee721503fooEv,_ZTv0_n20_N7ee721503fooEv)();
extern void ABISELECT(_ZThn16_N7ee721503fooEv,_ZThn8_N7ee721503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee721503barEv,_ZTv0_n16_N7ee721503barEv)();
extern void ABISELECT(_ZThn32_N7ee721503barEv,_ZThn20_N7ee721503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72150[0]),
  (VTBL_ENTRY)&_ZN7ee721503fooEv,
  (VTBL_ENTRY)&_ZN7ee721503barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee721503fooEv,_ZTv0_n20_N7ee721503fooEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee72150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721503barEv,_ZTv0_n16_N7ee721503barEv),
};
extern VTBL_ENTRY _ZTV7ee72150[];
extern void _ZN6dd21503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2150__7ee72150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN6dd21503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd2150__7ee72150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd2150__7ee72150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd2150__7ee72150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee72150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee72150[] = {
  {&(_ZTV7ee72150[5]),  5,18},
  {&(_ZTV7ee72150[12]),  12,18},
  {&(_ZTV7ee72150[17]),  17,18},
  {&(_tg__ZTV6dd2150__7ee72150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd2150__7ee72150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd2150__7ee72150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd2150__7ee72150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee72150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee72150[];
extern  VTBL_ENTRY _ZTV7ee72150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72150[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee721503barEv,_ZTv0_n16_N7ee721503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721503barEv,_ZThn20_N7ee721503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee721503fooEv,_ZTv0_n20_N7ee721503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721503fooEv,_ZThn8_N7ee721503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72150 = {  "ee72150", // class name
  bases_ee72150, 4,
  &(vtc_ee72150[0]), // expected_vtbl_contents
  &(vtt_ee72150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee72150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72150),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3150  : virtual cc150 {
  int d;
  virtual void  foo(); // _ZN6dd31503fooEv
  ~dd3150(); // tgen
  dd3150(); // tgen
};
//SIG(-1 dd3150) C1{ VBC2{ VBC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd3150 ::foo(){vfunc_called(this, "_ZN6dd31503fooEv");}
dd3150 ::~dd3150(){ note_dtor("dd3150", this);} // tgen
dd3150 ::dd3150(){ note_ctor("dd3150", this);} // tgen

static void Test_dd3150()
{
  extern Class_Descriptor cd_dd3150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd3150, buf);
    dd3150 *dp, &lv = *(dp=new (buf) dd3150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd3150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,24), "dd3150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,16), "dd3150");
    check_base_class_offset(lv, (cc150*), ABISELECT(16,8), "dd3150");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3150.d");
    test_class_info(&lv, &cd_dd3150);
    dp->~dd3150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3150(Test_dd3150, "dd3150", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd3150C1Ev();
extern void _ZN6dd3150D1Ev();
Name_Map name_map_dd3150[] = {
  NSPAIR(_ZN6dd3150C1Ev),
  NSPAIR(_ZN6dd3150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd3150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3150[];
extern void _ZN6dd31503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_dd3150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV6dd3150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd3150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd3150[] = {
  {&(_ZTV6dd3150[5]),  5,15},
  {&(_ZTV6dd3150[10]),  10,15},
  {&(_ZTV6dd3150[14]),  14,15},
  {&(_tg__ZTV5cc150__6dd3150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd3150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd3150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
Class_Descriptor cd_dd3150 = {  "dd3150", // class name
  bases_dd3150, 3,
  &(vtc_dd3150[0]), // expected_vtbl_contents
  &(vtt_dd3150[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd3150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3150),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03150  : dd3150 {
  int e;
  ~ee03150(); // tgen
  ee03150(); // tgen
};
//SIG(1 ee03150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee03150 ::~ee03150(){ note_dtor("ee03150", this);} // tgen
ee03150 ::ee03150(){ note_ctor("ee03150", this);} // tgen

static void Test_ee03150()
{
  extern Class_Descriptor cd_ee03150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee03150, buf);
    ee03150 *dp, &lv = *(dp=new (buf) ee03150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee03150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee03150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee03150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(16,12), "ee03150");
    check_base_class_offset(lv, (dd3150*), 0, "ee03150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03150.e");
    test_class_info(&lv, &cd_ee03150);
    dp->~ee03150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03150(Test_ee03150, "ee03150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee03150C1Ev();
extern void _ZN7ee03150D1Ev();
Name_Map name_map_ee03150[] = {
  NSPAIR(_ZN7ee03150C1Ev),
  NSPAIR(_ZN7ee03150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee03150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03150[];
extern void _ZN6dd31503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee03150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee03150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee03150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee03150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee03150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee03150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee03150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee03150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee03150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee03150[] = {
  {&(_ZTV7ee03150[5]),  5,15},
  {&(_tg__ZTV6dd3150__7ee03150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee03150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee03150[4]),  4,5},
  {&(_ZTV7ee03150[10]),  10,15},
  {&(_ZTV7ee03150[14]),  14,15},
  {&(_tg__ZTV5cc150__7ee03150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee03150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee03150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee03150[];
extern  VTBL_ENTRY _ZTV7ee03150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03150[];
Class_Descriptor cd_ee03150 = {  "ee03150", // class name
  bases_ee03150, 4,
  &(vtc_ee03150[0]), // expected_vtbl_contents
  &(vtt_ee03150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee03150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13150  : virtual dd3150 {
  int e;
  ~ee13150(); // tgen
  ee13150(); // tgen
};
//SIG(1 ee13150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee13150 ::~ee13150(){ note_dtor("ee13150", this);} // tgen
ee13150 ::ee13150(){ note_ctor("ee13150", this);} // tgen

static void Test_ee13150()
{
  extern Class_Descriptor cd_ee13150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee13150, buf);
    ee13150 *dp, &lv = *(dp=new (buf) ee13150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee13150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee13150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee13150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(32,16), "ee13150");
    check_base_class_offset(lv, (dd3150*), ABISELECT(16,8), "ee13150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13150.e");
    test_class_info(&lv, &cd_ee13150);
    dp->~ee13150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13150(Test_ee13150, "ee13150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee13150C1Ev();
extern void _ZN7ee13150D1Ev();
Name_Map name_map_ee13150[] = {
  NSPAIR(_ZN7ee13150C1Ev),
  NSPAIR(_ZN7ee13150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee13150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13150[];
extern void _ZN6dd31503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee13150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13150[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee13150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee13150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee13150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee13150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee13150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee13150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee13150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee13150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee13150[] = {
  {&(_ZTV7ee13150[6]),  6,22},
  {&(_ZTV7ee13150[12]),  12,22},
  {&(_ZTV7ee13150[17]),  17,22},
  {&(_ZTV7ee13150[21]),  21,22},
  {&(_tg__ZTV6dd3150__7ee13150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee13150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee13150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee13150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee13150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee13150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13150[];
extern  VTBL_ENTRY _ZTV7ee13150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13150[];
Class_Descriptor cd_ee13150 = {  "ee13150", // class name
  bases_ee13150, 4,
  &(vtc_ee13150[0]), // expected_vtbl_contents
  &(vtt_ee13150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee13150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13150),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23150  : dd3150 {
  int e;
  virtual void  foo(); // _ZN7ee231503fooEv
  ~ee23150(); // tgen
  ee23150(); // tgen
};
//SIG(1 ee23150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee23150 ::foo(){vfunc_called(this, "_ZN7ee231503fooEv");}
ee23150 ::~ee23150(){ note_dtor("ee23150", this);} // tgen
ee23150 ::ee23150(){ note_ctor("ee23150", this);} // tgen

static void Test_ee23150()
{
  extern Class_Descriptor cd_ee23150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee23150, buf);
    ee23150 *dp, &lv = *(dp=new (buf) ee23150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee23150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee23150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee23150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(16,12), "ee23150");
    check_base_class_offset(lv, (dd3150*), 0, "ee23150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23150.e");
    test_class_info(&lv, &cd_ee23150);
    dp->~ee23150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23150(Test_ee23150, "ee23150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee23150C1Ev();
extern void _ZN7ee23150D1Ev();
Name_Map name_map_ee23150[] = {
  NSPAIR(_ZN7ee23150C1Ev),
  NSPAIR(_ZN7ee23150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee23150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23150[];
extern void _ZN7ee231503fooEv();
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee23150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23150[0]),
  (VTBL_ENTRY)&_ZN7ee231503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee23150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee23150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee23150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee23150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee23150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee23150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee23150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee23150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee23150[] = {
  {&(_ZTV7ee23150[5]),  5,15},
  {&(_tg__ZTV6dd3150__7ee23150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee23150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee23150[4]),  4,5},
  {&(_ZTV7ee23150[10]),  10,15},
  {&(_ZTV7ee23150[14]),  14,15},
  {&(_tg__ZTV5cc150__7ee23150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee23150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee23150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee23150[];
extern  VTBL_ENTRY _ZTV7ee23150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23150[];
Class_Descriptor cd_ee23150 = {  "ee23150", // class name
  bases_ee23150, 4,
  &(vtc_ee23150[0]), // expected_vtbl_contents
  &(vtt_ee23150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee23150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33150  : virtual dd3150 {
  int e;
  virtual void  foo(); // _ZN7ee331503fooEv
  ~ee33150(); // tgen
  ee33150(); // tgen
};
//SIG(1 ee33150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee33150 ::foo(){vfunc_called(this, "_ZN7ee331503fooEv");}
ee33150 ::~ee33150(){ note_dtor("ee33150", this);} // tgen
ee33150 ::ee33150(){ note_ctor("ee33150", this);} // tgen

static void Test_ee33150()
{
  extern Class_Descriptor cd_ee33150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee33150, buf);
    ee33150 *dp, &lv = *(dp=new (buf) ee33150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee33150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee33150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee33150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(32,16), "ee33150");
    check_base_class_offset(lv, (dd3150*), ABISELECT(16,8), "ee33150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33150.e");
    test_class_info(&lv, &cd_ee33150);
    dp->~ee33150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33150(Test_ee33150, "ee33150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee33150C1Ev();
extern void _ZN7ee33150D1Ev();
Name_Map name_map_ee33150[] = {
  NSPAIR(_ZN7ee33150C1Ev),
  NSPAIR(_ZN7ee33150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee33150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33150[];
extern void _ZN7ee331503fooEv();
extern void ABISELECT(_ZTv0_n48_N7ee331503fooEv,_ZTv0_n24_N7ee331503fooEv)();
extern void ABISELECT(_ZThn16_N7ee331503fooEv,_ZThn8_N7ee331503fooEv)() __attribute__((weak));
extern void _ZN4bb503barEv();
static  VTBL_ENTRY vtc_ee33150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33150[0]),
  (VTBL_ENTRY)&_ZN7ee331503fooEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee331503fooEv,_ZTv0_n24_N7ee331503fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33150[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee33150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern VTBL_ENTRY _ZTV7ee33150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee33150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee33150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee33150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee33150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee33150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee33150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee33150[] = {
  {&(_ZTV7ee33150[6]),  6,23},
  {&(_ZTV7ee33150[13]),  13,23},
  {&(_ZTV7ee33150[18]),  18,23},
  {&(_ZTV7ee33150[22]),  22,23},
  {&(_tg__ZTV6dd3150__7ee33150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee33150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee33150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee33150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee33150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee33150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33150[];
extern  VTBL_ENTRY _ZTV7ee33150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33150[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee331503fooEv,_ZTv0_n24_N7ee331503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331503fooEv,_ZThn8_N7ee331503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33150 = {  "ee33150", // class name
  bases_ee33150, 4,
  &(vtc_ee33150[0]), // expected_vtbl_contents
  &(vtt_ee33150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee33150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33150),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43150  : dd3150 {
  int e;
  virtual void  bar(); // _ZN7ee431503barEv
  ~ee43150(); // tgen
  ee43150(); // tgen
};
//SIG(1 ee43150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee43150 ::bar(){vfunc_called(this, "_ZN7ee431503barEv");}
ee43150 ::~ee43150(){ note_dtor("ee43150", this);} // tgen
ee43150 ::ee43150(){ note_ctor("ee43150", this);} // tgen

static void Test_ee43150()
{
  extern Class_Descriptor cd_ee43150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee43150, buf);
    ee43150 *dp, &lv = *(dp=new (buf) ee43150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee43150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee43150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee43150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(16,12), "ee43150");
    check_base_class_offset(lv, (dd3150*), 0, "ee43150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43150.e");
    test_class_info(&lv, &cd_ee43150);
    dp->~ee43150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43150(Test_ee43150, "ee43150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee43150C1Ev();
extern void _ZN7ee43150D1Ev();
Name_Map name_map_ee43150[] = {
  NSPAIR(_ZN7ee43150C1Ev),
  NSPAIR(_ZN7ee43150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee43150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43150[];
extern void _ZN6dd31503fooEv();
extern void _ZN7ee431503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee431503barEv,_ZTv0_n16_N7ee431503barEv)();
extern void ABISELECT(_ZThn32_N7ee431503barEv,_ZThn20_N7ee431503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
  (VTBL_ENTRY)&_ZN7ee431503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee43150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee431503barEv,_ZTv0_n16_N7ee431503barEv),
};
extern VTBL_ENTRY _ZTV7ee43150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee43150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee43150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee43150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee43150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee43150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee43150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee43150[] = {
  {&(_ZTV7ee43150[5]),  5,16},
  {&(_tg__ZTV6dd3150__7ee43150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee43150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee43150[4]),  4,5},
  {&(_ZTV7ee43150[11]),  11,16},
  {&(_ZTV7ee43150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee43150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee43150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee43150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee43150[];
extern  VTBL_ENTRY _ZTV7ee43150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43150[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee431503barEv,_ZTv0_n16_N7ee431503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee431503barEv,_ZThn20_N7ee431503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43150 = {  "ee43150", // class name
  bases_ee43150, 4,
  &(vtc_ee43150[0]), // expected_vtbl_contents
  &(vtt_ee43150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee43150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53150  : virtual dd3150 {
  int e;
  virtual void  bar(); // _ZN7ee531503barEv
  ~ee53150(); // tgen
  ee53150(); // tgen
};
//SIG(1 ee53150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee53150 ::bar(){vfunc_called(this, "_ZN7ee531503barEv");}
ee53150 ::~ee53150(){ note_dtor("ee53150", this);} // tgen
ee53150 ::ee53150(){ note_ctor("ee53150", this);} // tgen

static void Test_ee53150()
{
  extern Class_Descriptor cd_ee53150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee53150, buf);
    ee53150 *dp, &lv = *(dp=new (buf) ee53150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee53150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee53150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee53150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(32,16), "ee53150");
    check_base_class_offset(lv, (dd3150*), ABISELECT(16,8), "ee53150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53150.e");
    test_class_info(&lv, &cd_ee53150);
    dp->~ee53150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53150(Test_ee53150, "ee53150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee53150C1Ev();
extern void _ZN7ee53150D1Ev();
Name_Map name_map_ee53150[] = {
  NSPAIR(_ZN7ee53150C1Ev),
  NSPAIR(_ZN7ee53150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee53150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53150[];
extern void _ZN7ee531503barEv();
extern void _ZN6dd31503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee531503barEv,_ZTv0_n16_N7ee531503barEv)();
extern void ABISELECT(_ZThn48_N7ee531503barEv,_ZThn24_N7ee531503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53150[0]),
  (VTBL_ENTRY)&_ZN7ee531503barEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee53150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee531503barEv,_ZTv0_n16_N7ee531503barEv),
};
extern VTBL_ENTRY _ZTV7ee53150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee53150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee53150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee53150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee53150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee53150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee53150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee53150[] = {
  {&(_ZTV7ee53150[6]),  6,23},
  {&(_ZTV7ee53150[13]),  13,23},
  {&(_ZTV7ee53150[18]),  18,23},
  {&(_ZTV7ee53150[22]),  22,23},
  {&(_tg__ZTV6dd3150__7ee53150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee53150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee53150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee53150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee53150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee53150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53150[];
extern  VTBL_ENTRY _ZTV7ee53150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53150[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee531503barEv,_ZTv0_n16_N7ee531503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee531503barEv,_ZThn24_N7ee531503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53150 = {  "ee53150", // class name
  bases_ee53150, 4,
  &(vtc_ee53150[0]), // expected_vtbl_contents
  &(vtt_ee53150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee53150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53150),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63150  : dd3150 {
  int e;
  virtual void  foo(); // _ZN7ee631503fooEv
  virtual void  bar(); // _ZN7ee631503barEv
  ~ee63150(); // tgen
  ee63150(); // tgen
};
//SIG(1 ee63150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63150 ::foo(){vfunc_called(this, "_ZN7ee631503fooEv");}
void  ee63150 ::bar(){vfunc_called(this, "_ZN7ee631503barEv");}
ee63150 ::~ee63150(){ note_dtor("ee63150", this);} // tgen
ee63150 ::ee63150(){ note_ctor("ee63150", this);} // tgen

static void Test_ee63150()
{
  extern Class_Descriptor cd_ee63150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee63150, buf);
    ee63150 *dp, &lv = *(dp=new (buf) ee63150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee63150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee63150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee63150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(16,12), "ee63150");
    check_base_class_offset(lv, (dd3150*), 0, "ee63150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63150.e");
    test_class_info(&lv, &cd_ee63150);
    dp->~ee63150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63150(Test_ee63150, "ee63150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee63150C1Ev();
extern void _ZN7ee63150D1Ev();
Name_Map name_map_ee63150[] = {
  NSPAIR(_ZN7ee63150C1Ev),
  NSPAIR(_ZN7ee63150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee63150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63150[];
extern void _ZN7ee631503fooEv();
extern void _ZN7ee631503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee631503barEv,_ZTv0_n16_N7ee631503barEv)();
extern void ABISELECT(_ZThn32_N7ee631503barEv,_ZThn20_N7ee631503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63150[0]),
  (VTBL_ENTRY)&_ZN7ee631503fooEv,
  (VTBL_ENTRY)&_ZN7ee631503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee63150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee631503barEv,_ZTv0_n16_N7ee631503barEv),
};
extern VTBL_ENTRY _ZTV7ee63150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee63150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee63150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee63150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee63150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee63150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee63150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee63150[] = {
  {&(_ZTV7ee63150[5]),  5,16},
  {&(_tg__ZTV6dd3150__7ee63150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee63150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee63150[4]),  4,5},
  {&(_ZTV7ee63150[11]),  11,16},
  {&(_ZTV7ee63150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee63150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee63150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee63150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee63150[];
extern  VTBL_ENTRY _ZTV7ee63150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63150[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee631503barEv,_ZTv0_n16_N7ee631503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631503barEv,_ZThn20_N7ee631503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63150 = {  "ee63150", // class name
  bases_ee63150, 4,
  &(vtc_ee63150[0]), // expected_vtbl_contents
  &(vtt_ee63150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee63150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73150  : virtual dd3150 {
  int e;
  virtual void  foo(); // _ZN7ee731503fooEv
  virtual void  bar(); // _ZN7ee731503barEv
  ~ee73150(); // tgen
  ee73150(); // tgen
};
//SIG(1 ee73150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73150 ::foo(){vfunc_called(this, "_ZN7ee731503fooEv");}
void  ee73150 ::bar(){vfunc_called(this, "_ZN7ee731503barEv");}
ee73150 ::~ee73150(){ note_dtor("ee73150", this);} // tgen
ee73150 ::ee73150(){ note_ctor("ee73150", this);} // tgen

static void Test_ee73150()
{
  extern Class_Descriptor cd_ee73150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee73150, buf);
    ee73150 *dp, &lv = *(dp=new (buf) ee73150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee73150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee73150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee73150");
    check_base_class_offset(lv, (cc150*)(dd3150*), ABISELECT(32,16), "ee73150");
    check_base_class_offset(lv, (dd3150*), ABISELECT(16,8), "ee73150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73150.e");
    test_class_info(&lv, &cd_ee73150);
    dp->~ee73150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73150(Test_ee73150, "ee73150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee73150C1Ev();
extern void _ZN7ee73150D1Ev();
Name_Map name_map_ee73150[] = {
  NSPAIR(_ZN7ee73150C1Ev),
  NSPAIR(_ZN7ee73150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd3150;
extern VTBL_ENTRY _ZTI6dd3150[];
extern  VTBL_ENTRY _ZTV6dd3150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3150[];
static Base_Class bases_ee73150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3150,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73150[];
extern void _ZN7ee731503fooEv();
extern void _ZN7ee731503barEv();
extern void ABISELECT(_ZTv0_n48_N7ee731503fooEv,_ZTv0_n24_N7ee731503fooEv)();
extern void ABISELECT(_ZThn16_N7ee731503fooEv,_ZThn8_N7ee731503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee731503barEv,_ZTv0_n16_N7ee731503barEv)();
extern void ABISELECT(_ZThn48_N7ee731503barEv,_ZThn24_N7ee731503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73150[0]),
  (VTBL_ENTRY)&_ZN7ee731503fooEv,
  (VTBL_ENTRY)&_ZN7ee731503barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee731503fooEv,_ZTv0_n24_N7ee731503fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee73150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee731503barEv,_ZTv0_n16_N7ee731503barEv),
};
extern VTBL_ENTRY _ZTV7ee73150[];
extern void _ZN6dd31503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3150__7ee73150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN6dd31503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd3150__7ee73150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd3150__7ee73150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee73150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee73150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee73150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee73150[] = {
  {&(_ZTV7ee73150[6]),  6,24},
  {&(_ZTV7ee73150[14]),  14,24},
  {&(_ZTV7ee73150[19]),  19,24},
  {&(_ZTV7ee73150[23]),  23,24},
  {&(_tg__ZTV6dd3150__7ee73150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd3150__7ee73150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd3150__7ee73150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee73150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee73150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee73150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73150[];
extern  VTBL_ENTRY _ZTV7ee73150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73150[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee731503barEv,_ZTv0_n16_N7ee731503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731503barEv,_ZThn24_N7ee731503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee731503fooEv,_ZTv0_n24_N7ee731503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731503fooEv,_ZThn8_N7ee731503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73150 = {  "ee73150", // class name
  bases_ee73150, 4,
  &(vtc_ee73150[0]), // expected_vtbl_contents
  &(vtt_ee73150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee73150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73150),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4150  : cc150 {
  int d;
  virtual void  bar(); // _ZN6dd41503barEv
  ~dd4150(); // tgen
  dd4150(); // tgen
};
//SIG(-1 dd4150) C1{ BC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd4150 ::bar(){vfunc_called(this, "_ZN6dd41503barEv");}
dd4150 ::~dd4150(){ note_dtor("dd4150", this);} // tgen
dd4150 ::dd4150(){ note_ctor("dd4150", this);} // tgen

static void Test_dd4150()
{
  extern Class_Descriptor cd_dd4150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd4150, buf);
    dd4150 *dp, &lv = *(dp=new (buf) dd4150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd4150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(28,20), "dd4150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(16,12), "dd4150");
    check_base_class_offset(lv, (cc150*), 0, "dd4150");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4150.d");
    test_class_info(&lv, &cd_dd4150);
    dp->~dd4150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4150(Test_dd4150, "dd4150", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd4150C1Ev();
extern void _ZN6dd4150D1Ev();
Name_Map name_map_dd4150[] = {
  NSPAIR(_ZN6dd4150C1Ev),
  NSPAIR(_ZN6dd4150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd4150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4150[];
extern void _ZN6dd41503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd4150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern VTBL_ENTRY _ZTV6dd4150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd4150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd4150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd4150[] = {
  {&(_ZTV6dd4150[4]),  4,10},
  {&(_tg__ZTV5cc150__6dd4150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd4150[4]),  4,5},
  {&(_ZTV6dd4150[9]),  9,10},
  {&(_tg__ZTV4bb50__6dd4150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd4150 = {  "dd4150", // class name
  bases_dd4150, 3,
  &(vtc_dd4150[0]), // expected_vtbl_contents
  &(vtt_dd4150[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd4150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4150),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04150  : dd4150 {
  int e;
  ~ee04150(); // tgen
  ee04150(); // tgen
};
//SIG(1 ee04150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee04150 ::~ee04150(){ note_dtor("ee04150", this);} // tgen
ee04150 ::ee04150(){ note_ctor("ee04150", this);} // tgen

static void Test_ee04150()
{
  extern Class_Descriptor cd_ee04150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee04150, buf);
    ee04150 *dp, &lv = *(dp=new (buf) ee04150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee04150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee04150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(24,16), "ee04150");
    check_base_class_offset(lv, (cc150*)(dd4150*), 0, "ee04150");
    check_base_class_offset(lv, (dd4150*), 0, "ee04150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04150.e");
    test_class_info(&lv, &cd_ee04150);
    dp->~ee04150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04150(Test_ee04150, "ee04150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee04150C1Ev();
extern void _ZN7ee04150D1Ev();
Name_Map name_map_ee04150[] = {
  NSPAIR(_ZN7ee04150C1Ev),
  NSPAIR(_ZN7ee04150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee04150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04150[];
extern void _ZN6dd41503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee04150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee04150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern VTBL_ENTRY _ZTV7ee04150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee04150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee04150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee04150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee04150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee04150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee04150[] = {
  {&(_ZTV7ee04150[4]),  4,10},
  {&(_tg__ZTV6dd4150__7ee04150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee04150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee04150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee04150[4]),  4,5},
  {&(_ZTV7ee04150[9]),  9,10},
  {&(_tg__ZTV4bb50__7ee04150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee04150[];
extern  VTBL_ENTRY _ZTV7ee04150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04150[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee04150 = {  "ee04150", // class name
  bases_ee04150, 4,
  &(vtc_ee04150[0]), // expected_vtbl_contents
  &(vtt_ee04150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee04150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14150  : virtual dd4150 {
  int e;
  ~ee14150(); // tgen
  ee14150(); // tgen
};
//SIG(1 ee14150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee14150 ::~ee14150(){ note_dtor("ee14150", this);} // tgen
ee14150 ::ee14150(){ note_ctor("ee14150", this);} // tgen

static void Test_ee14150()
{
  extern Class_Descriptor cd_ee14150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee14150, buf);
    ee14150 *dp, &lv = *(dp=new (buf) ee14150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee14150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee14150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(32,20), "ee14150");
    check_base_class_offset(lv, (cc150*)(dd4150*), ABISELECT(16,8), "ee14150");
    check_base_class_offset(lv, (dd4150*), ABISELECT(16,8), "ee14150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14150.e");
    test_class_info(&lv, &cd_ee14150);
    dp->~ee14150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14150(Test_ee14150, "ee14150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee14150C1Ev();
extern void _ZN7ee14150D1Ev();
Name_Map name_map_ee14150[] = {
  NSPAIR(_ZN7ee14150C1Ev),
  NSPAIR(_ZN7ee14150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee14150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14150[];
extern void _ZN6dd41503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee14150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14150[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee14150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern VTBL_ENTRY _ZTV7ee14150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee14150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee14150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee14150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee14150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee14150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee14150[] = {
  {&(_ZTV7ee14150[5]),  5,16},
  {&(_ZTV7ee14150[10]),  10,16},
  {&(_ZTV7ee14150[15]),  15,16},
  {&(_tg__ZTV6dd4150__7ee14150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee14150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee14150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee14150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee14150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee14150[];
extern  VTBL_ENTRY _ZTV7ee14150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14150[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee14150 = {  "ee14150", // class name
  bases_ee14150, 4,
  &(vtc_ee14150[0]), // expected_vtbl_contents
  &(vtt_ee14150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee14150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24150  : dd4150 {
  int e;
  virtual void  foo(); // _ZN7ee241503fooEv
  ~ee24150(); // tgen
  ee24150(); // tgen
};
//SIG(1 ee24150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee24150 ::foo(){vfunc_called(this, "_ZN7ee241503fooEv");}
ee24150 ::~ee24150(){ note_dtor("ee24150", this);} // tgen
ee24150 ::ee24150(){ note_ctor("ee24150", this);} // tgen

static void Test_ee24150()
{
  extern Class_Descriptor cd_ee24150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee24150, buf);
    ee24150 *dp, &lv = *(dp=new (buf) ee24150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee24150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee24150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(24,16), "ee24150");
    check_base_class_offset(lv, (cc150*)(dd4150*), 0, "ee24150");
    check_base_class_offset(lv, (dd4150*), 0, "ee24150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24150.e");
    test_class_info(&lv, &cd_ee24150);
    dp->~ee24150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24150(Test_ee24150, "ee24150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee24150C1Ev();
extern void _ZN7ee24150D1Ev();
Name_Map name_map_ee24150[] = {
  NSPAIR(_ZN7ee24150C1Ev),
  NSPAIR(_ZN7ee24150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee24150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24150[];
extern void _ZN6dd41503barEv();
extern void _ZN7ee241503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee24150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
  (VTBL_ENTRY)&_ZN7ee241503fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee24150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern VTBL_ENTRY _ZTV7ee24150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee24150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee24150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee24150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee24150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee24150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee24150[] = {
  {&(_ZTV7ee24150[4]),  4,11},
  {&(_tg__ZTV6dd4150__7ee24150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee24150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee24150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee24150[4]),  4,5},
  {&(_ZTV7ee24150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee24150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee24150[];
extern  VTBL_ENTRY _ZTV7ee24150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24150[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee24150 = {  "ee24150", // class name
  bases_ee24150, 4,
  &(vtc_ee24150[0]), // expected_vtbl_contents
  &(vtt_ee24150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee24150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34150  : virtual dd4150 {
  int e;
  virtual void  foo(); // _ZN7ee341503fooEv
  ~ee34150(); // tgen
  ee34150(); // tgen
};
//SIG(1 ee34150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee34150 ::foo(){vfunc_called(this, "_ZN7ee341503fooEv");}
ee34150 ::~ee34150(){ note_dtor("ee34150", this);} // tgen
ee34150 ::ee34150(){ note_ctor("ee34150", this);} // tgen

static void Test_ee34150()
{
  extern Class_Descriptor cd_ee34150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee34150, buf);
    ee34150 *dp, &lv = *(dp=new (buf) ee34150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee34150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee34150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(32,20), "ee34150");
    check_base_class_offset(lv, (cc150*)(dd4150*), ABISELECT(16,8), "ee34150");
    check_base_class_offset(lv, (dd4150*), ABISELECT(16,8), "ee34150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34150.e");
    test_class_info(&lv, &cd_ee34150);
    dp->~ee34150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34150(Test_ee34150, "ee34150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee34150C1Ev();
extern void _ZN7ee34150D1Ev();
Name_Map name_map_ee34150[] = {
  NSPAIR(_ZN7ee34150C1Ev),
  NSPAIR(_ZN7ee34150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee34150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34150[];
extern void _ZN7ee341503fooEv();
extern void _ZN6dd41503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34150[0]),
  (VTBL_ENTRY)&_ZN7ee341503fooEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee34150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern VTBL_ENTRY _ZTV7ee34150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee34150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee34150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee34150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee34150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee34150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee34150[] = {
  {&(_ZTV7ee34150[5]),  5,17},
  {&(_ZTV7ee34150[11]),  11,17},
  {&(_ZTV7ee34150[16]),  16,17},
  {&(_tg__ZTV6dd4150__7ee34150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee34150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee34150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee34150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee34150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee34150[];
extern  VTBL_ENTRY _ZTV7ee34150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34150[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34150 = {  "ee34150", // class name
  bases_ee34150, 4,
  &(vtc_ee34150[0]), // expected_vtbl_contents
  &(vtt_ee34150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee34150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34150),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44150  : dd4150 {
  int e;
  virtual void  bar(); // _ZN7ee441503barEv
  ~ee44150(); // tgen
  ee44150(); // tgen
};
//SIG(1 ee44150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee44150 ::bar(){vfunc_called(this, "_ZN7ee441503barEv");}
ee44150 ::~ee44150(){ note_dtor("ee44150", this);} // tgen
ee44150 ::ee44150(){ note_ctor("ee44150", this);} // tgen

static void Test_ee44150()
{
  extern Class_Descriptor cd_ee44150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee44150, buf);
    ee44150 *dp, &lv = *(dp=new (buf) ee44150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee44150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee44150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(24,16), "ee44150");
    check_base_class_offset(lv, (cc150*)(dd4150*), 0, "ee44150");
    check_base_class_offset(lv, (dd4150*), 0, "ee44150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44150.e");
    test_class_info(&lv, &cd_ee44150);
    dp->~ee44150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44150(Test_ee44150, "ee44150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee44150C1Ev();
extern void _ZN7ee44150D1Ev();
Name_Map name_map_ee44150[] = {
  NSPAIR(_ZN7ee44150C1Ev),
  NSPAIR(_ZN7ee44150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee44150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44150[];
extern void _ZN7ee441503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee441503barEv,_ZTv0_n16_N7ee441503barEv)();
extern void ABISELECT(_ZThn24_N7ee441503barEv,_ZThn16_N7ee441503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee44150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44150[0]),
  (VTBL_ENTRY)&_ZN7ee441503barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee44150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee441503barEv,_ZTv0_n16_N7ee441503barEv),
};
extern VTBL_ENTRY _ZTV7ee44150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee44150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee44150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee44150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee44150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee44150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee44150[] = {
  {&(_ZTV7ee44150[4]),  4,10},
  {&(_tg__ZTV6dd4150__7ee44150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee44150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee44150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee44150[4]),  4,5},
  {&(_ZTV7ee44150[9]),  9,10},
  {&(_tg__ZTV4bb50__7ee44150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee44150[];
extern  VTBL_ENTRY _ZTV7ee44150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44150[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee441503barEv,_ZTv0_n16_N7ee441503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee441503barEv,_ZThn16_N7ee441503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee44150 = {  "ee44150", // class name
  bases_ee44150, 4,
  &(vtc_ee44150[0]), // expected_vtbl_contents
  &(vtt_ee44150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee44150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44150),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54150  : virtual dd4150 {
  int e;
  virtual void  bar(); // _ZN7ee541503barEv
  ~ee54150(); // tgen
  ee54150(); // tgen
};
//SIG(1 ee54150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee54150 ::bar(){vfunc_called(this, "_ZN7ee541503barEv");}
ee54150 ::~ee54150(){ note_dtor("ee54150", this);} // tgen
ee54150 ::ee54150(){ note_ctor("ee54150", this);} // tgen

static void Test_ee54150()
{
  extern Class_Descriptor cd_ee54150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee54150, buf);
    ee54150 *dp, &lv = *(dp=new (buf) ee54150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee54150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee54150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(32,20), "ee54150");
    check_base_class_offset(lv, (cc150*)(dd4150*), ABISELECT(16,8), "ee54150");
    check_base_class_offset(lv, (dd4150*), ABISELECT(16,8), "ee54150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54150.e");
    test_class_info(&lv, &cd_ee54150);
    dp->~ee54150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54150(Test_ee54150, "ee54150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee54150C1Ev();
extern void _ZN7ee54150D1Ev();
Name_Map name_map_ee54150[] = {
  NSPAIR(_ZN7ee54150C1Ev),
  NSPAIR(_ZN7ee54150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee54150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54150[];
extern void _ZN7ee541503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee541503barEv,_ZTv0_n20_N7ee541503barEv)();
extern void ABISELECT(_ZThn16_N7ee541503barEv,_ZThn8_N7ee541503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee541503barEv,_ZTv0_n16_N7ee541503barEv)();
extern void ABISELECT(_ZThn32_N7ee541503barEv,_ZThn20_N7ee541503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54150[0]),
  (VTBL_ENTRY)&_ZN7ee541503barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee541503barEv,_ZTv0_n20_N7ee541503barEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee54150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee541503barEv,_ZTv0_n16_N7ee541503barEv),
};
extern VTBL_ENTRY _ZTV7ee54150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee54150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee54150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee54150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee54150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee54150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee54150[] = {
  {&(_ZTV7ee54150[5]),  5,17},
  {&(_ZTV7ee54150[11]),  11,17},
  {&(_ZTV7ee54150[16]),  16,17},
  {&(_tg__ZTV6dd4150__7ee54150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee54150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee54150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee54150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee54150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee54150[];
extern  VTBL_ENTRY _ZTV7ee54150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54150[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee541503barEv,_ZTv0_n16_N7ee541503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee541503barEv,_ZThn20_N7ee541503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee541503barEv,_ZTv0_n20_N7ee541503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541503barEv,_ZThn8_N7ee541503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54150 = {  "ee54150", // class name
  bases_ee54150, 4,
  &(vtc_ee54150[0]), // expected_vtbl_contents
  &(vtt_ee54150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee54150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54150),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64150  : dd4150 {
  int e;
  virtual void  foo(); // _ZN7ee641503fooEv
  virtual void  bar(); // _ZN7ee641503barEv
  ~ee64150(); // tgen
  ee64150(); // tgen
};
//SIG(1 ee64150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64150 ::foo(){vfunc_called(this, "_ZN7ee641503fooEv");}
void  ee64150 ::bar(){vfunc_called(this, "_ZN7ee641503barEv");}
ee64150 ::~ee64150(){ note_dtor("ee64150", this);} // tgen
ee64150 ::ee64150(){ note_ctor("ee64150", this);} // tgen

static void Test_ee64150()
{
  extern Class_Descriptor cd_ee64150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee64150, buf);
    ee64150 *dp, &lv = *(dp=new (buf) ee64150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee64150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee64150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(24,16), "ee64150");
    check_base_class_offset(lv, (cc150*)(dd4150*), 0, "ee64150");
    check_base_class_offset(lv, (dd4150*), 0, "ee64150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64150.e");
    test_class_info(&lv, &cd_ee64150);
    dp->~ee64150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64150(Test_ee64150, "ee64150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee64150C1Ev();
extern void _ZN7ee64150D1Ev();
Name_Map name_map_ee64150[] = {
  NSPAIR(_ZN7ee64150C1Ev),
  NSPAIR(_ZN7ee64150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee64150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64150[];
extern void _ZN7ee641503barEv();
extern void _ZN7ee641503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee641503barEv,_ZTv0_n16_N7ee641503barEv)();
extern void ABISELECT(_ZThn24_N7ee641503barEv,_ZThn16_N7ee641503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee64150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64150[0]),
  (VTBL_ENTRY)&_ZN7ee641503barEv,
  (VTBL_ENTRY)&_ZN7ee641503fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee64150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee641503barEv,_ZTv0_n16_N7ee641503barEv),
};
extern VTBL_ENTRY _ZTV7ee64150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee64150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee64150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee64150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee64150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee64150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee64150[] = {
  {&(_ZTV7ee64150[4]),  4,11},
  {&(_tg__ZTV6dd4150__7ee64150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee64150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee64150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee64150[4]),  4,5},
  {&(_ZTV7ee64150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee64150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee64150[];
extern  VTBL_ENTRY _ZTV7ee64150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64150[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41503barEv,_ZThn16_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee641503barEv,_ZTv0_n16_N7ee641503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641503barEv,_ZThn16_N7ee641503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee64150 = {  "ee64150", // class name
  bases_ee64150, 4,
  &(vtc_ee64150[0]), // expected_vtbl_contents
  &(vtt_ee64150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee64150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74150  : virtual dd4150 {
  int e;
  virtual void  foo(); // _ZN7ee741503fooEv
  virtual void  bar(); // _ZN7ee741503barEv
  ~ee74150(); // tgen
  ee74150(); // tgen
};
//SIG(1 ee74150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74150 ::foo(){vfunc_called(this, "_ZN7ee741503fooEv");}
void  ee74150 ::bar(){vfunc_called(this, "_ZN7ee741503barEv");}
ee74150 ::~ee74150(){ note_dtor("ee74150", this);} // tgen
ee74150 ::ee74150(){ note_ctor("ee74150", this);} // tgen

static void Test_ee74150()
{
  extern Class_Descriptor cd_ee74150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee74150, buf);
    ee74150 *dp, &lv = *(dp=new (buf) ee74150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee74150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee74150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd4150*), ABISELECT(32,20), "ee74150");
    check_base_class_offset(lv, (cc150*)(dd4150*), ABISELECT(16,8), "ee74150");
    check_base_class_offset(lv, (dd4150*), ABISELECT(16,8), "ee74150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74150.e");
    test_class_info(&lv, &cd_ee74150);
    dp->~ee74150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74150(Test_ee74150, "ee74150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee74150C1Ev();
extern void _ZN7ee74150D1Ev();
Name_Map name_map_ee74150[] = {
  NSPAIR(_ZN7ee74150C1Ev),
  NSPAIR(_ZN7ee74150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd4150;
extern VTBL_ENTRY _ZTI6dd4150[];
extern  VTBL_ENTRY _ZTV6dd4150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4150[];
static Base_Class bases_ee74150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74150[];
extern void _ZN7ee741503fooEv();
extern void _ZN7ee741503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee741503barEv,_ZTv0_n20_N7ee741503barEv)();
extern void ABISELECT(_ZThn16_N7ee741503barEv,_ZThn8_N7ee741503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee741503barEv,_ZTv0_n16_N7ee741503barEv)();
extern void ABISELECT(_ZThn32_N7ee741503barEv,_ZThn20_N7ee741503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74150[0]),
  (VTBL_ENTRY)&_ZN7ee741503fooEv,
  (VTBL_ENTRY)&_ZN7ee741503barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee741503barEv,_ZTv0_n20_N7ee741503barEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee74150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741503barEv,_ZTv0_n16_N7ee741503barEv),
};
extern VTBL_ENTRY _ZTV7ee74150[];
extern void _ZN6dd41503barEv();
static  VTBL_ENTRY _tg__ZTV6dd4150__7ee74150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&_ZN6dd41503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd4150__7ee74150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd4150__7ee74150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv)();
extern void ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd4150__7ee74150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee74150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee74150[] = {
  {&(_ZTV7ee74150[5]),  5,18},
  {&(_ZTV7ee74150[12]),  12,18},
  {&(_ZTV7ee74150[17]),  17,18},
  {&(_tg__ZTV6dd4150__7ee74150[4]),  4,5},
  {&(_tg__ZTV5cc1506dd4150__7ee74150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd4150__7ee74150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd4150__7ee74150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee74150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee74150[];
extern  VTBL_ENTRY _ZTV7ee74150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74150[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd41503barEv,_ZTv0_n16_N6dd41503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41503barEv,_ZThn12_N6dd41503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741503barEv,_ZTv0_n16_N7ee741503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741503barEv,_ZThn20_N7ee741503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee741503barEv,_ZTv0_n20_N7ee741503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741503barEv,_ZThn8_N7ee741503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74150 = {  "ee74150", // class name
  bases_ee74150, 4,
  &(vtc_ee74150[0]), // expected_vtbl_contents
  &(vtt_ee74150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee74150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74150),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5150  : virtual cc150 {
  int d;
  virtual void  bar(); // _ZN6dd51503barEv
  ~dd5150(); // tgen
  dd5150(); // tgen
};
//SIG(-1 dd5150) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd5150 ::bar(){vfunc_called(this, "_ZN6dd51503barEv");}
dd5150 ::~dd5150(){ note_dtor("dd5150", this);} // tgen
dd5150 ::dd5150(){ note_ctor("dd5150", this);} // tgen

static void Test_dd5150()
{
  extern Class_Descriptor cd_dd5150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd5150, buf);
    dd5150 *dp, &lv = *(dp=new (buf) dd5150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd5150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,24), "dd5150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,16), "dd5150");
    check_base_class_offset(lv, (cc150*), ABISELECT(16,8), "dd5150");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5150.d");
    test_class_info(&lv, &cd_dd5150);
    dp->~dd5150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5150(Test_dd5150, "dd5150", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd5150C1Ev();
extern void _ZN6dd5150D1Ev();
Name_Map name_map_dd5150[] = {
  NSPAIR(_ZN6dd5150C1Ev),
  NSPAIR(_ZN6dd5150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd5150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5150[];
extern void _ZN6dd51503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd5150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
extern VTBL_ENTRY _ZTV6dd5150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd5150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd5150[] = {
  {&(_ZTV6dd5150[5]),  5,15},
  {&(_ZTV6dd5150[10]),  10,15},
  {&(_ZTV6dd5150[14]),  14,15},
  {&(_tg__ZTV5cc150__6dd5150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd5150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd5150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5150 = {  "dd5150", // class name
  bases_dd5150, 3,
  &(vtc_dd5150[0]), // expected_vtbl_contents
  &(vtt_dd5150[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd5150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5150),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05150  : dd5150 {
  int e;
  ~ee05150(); // tgen
  ee05150(); // tgen
};
//SIG(1 ee05150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee05150 ::~ee05150(){ note_dtor("ee05150", this);} // tgen
ee05150 ::ee05150(){ note_ctor("ee05150", this);} // tgen

static void Test_ee05150()
{
  extern Class_Descriptor cd_ee05150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee05150, buf);
    ee05150 *dp, &lv = *(dp=new (buf) ee05150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee05150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee05150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee05150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(16,12), "ee05150");
    check_base_class_offset(lv, (dd5150*), 0, "ee05150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05150.e");
    test_class_info(&lv, &cd_ee05150);
    dp->~ee05150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05150(Test_ee05150, "ee05150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee05150C1Ev();
extern void _ZN7ee05150D1Ev();
Name_Map name_map_ee05150[] = {
  NSPAIR(_ZN7ee05150C1Ev),
  NSPAIR(_ZN7ee05150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee05150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05150[];
extern void _ZN6dd51503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee05150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee05150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
extern VTBL_ENTRY _ZTV7ee05150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee05150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee05150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee05150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee05150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee05150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee05150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee05150[] = {
  {&(_ZTV7ee05150[5]),  5,15},
  {&(_tg__ZTV6dd5150__7ee05150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee05150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee05150[4]),  4,5},
  {&(_ZTV7ee05150[10]),  10,15},
  {&(_ZTV7ee05150[14]),  14,15},
  {&(_tg__ZTV5cc150__7ee05150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee05150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee05150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee05150[];
extern  VTBL_ENTRY _ZTV7ee05150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05150[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05150 = {  "ee05150", // class name
  bases_ee05150, 4,
  &(vtc_ee05150[0]), // expected_vtbl_contents
  &(vtt_ee05150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee05150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15150  : virtual dd5150 {
  int e;
  ~ee15150(); // tgen
  ee15150(); // tgen
};
//SIG(1 ee15150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee15150 ::~ee15150(){ note_dtor("ee15150", this);} // tgen
ee15150 ::ee15150(){ note_ctor("ee15150", this);} // tgen

static void Test_ee15150()
{
  extern Class_Descriptor cd_ee15150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee15150, buf);
    ee15150 *dp, &lv = *(dp=new (buf) ee15150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee15150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee15150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee15150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(32,16), "ee15150");
    check_base_class_offset(lv, (dd5150*), ABISELECT(16,8), "ee15150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15150.e");
    test_class_info(&lv, &cd_ee15150);
    dp->~ee15150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15150(Test_ee15150, "ee15150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee15150C1Ev();
extern void _ZN7ee15150D1Ev();
Name_Map name_map_ee15150[] = {
  NSPAIR(_ZN7ee15150C1Ev),
  NSPAIR(_ZN7ee15150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee15150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15150[];
extern void _ZN6dd51503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee15150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15150[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15150[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee15150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
extern VTBL_ENTRY _ZTV7ee15150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee15150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee15150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee15150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee15150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee15150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee15150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee15150[] = {
  {&(_ZTV7ee15150[6]),  6,22},
  {&(_ZTV7ee15150[12]),  12,22},
  {&(_ZTV7ee15150[17]),  17,22},
  {&(_ZTV7ee15150[21]),  21,22},
  {&(_tg__ZTV6dd5150__7ee15150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee15150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee15150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee15150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee15150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee15150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15150[];
extern  VTBL_ENTRY _ZTV7ee15150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15150[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15150 = {  "ee15150", // class name
  bases_ee15150, 4,
  &(vtc_ee15150[0]), // expected_vtbl_contents
  &(vtt_ee15150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee15150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15150),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25150  : dd5150 {
  int e;
  virtual void  foo(); // _ZN7ee251503fooEv
  ~ee25150(); // tgen
  ee25150(); // tgen
};
//SIG(1 ee25150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee25150 ::foo(){vfunc_called(this, "_ZN7ee251503fooEv");}
ee25150 ::~ee25150(){ note_dtor("ee25150", this);} // tgen
ee25150 ::ee25150(){ note_ctor("ee25150", this);} // tgen

static void Test_ee25150()
{
  extern Class_Descriptor cd_ee25150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee25150, buf);
    ee25150 *dp, &lv = *(dp=new (buf) ee25150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee25150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee25150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee25150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(16,12), "ee25150");
    check_base_class_offset(lv, (dd5150*), 0, "ee25150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25150.e");
    test_class_info(&lv, &cd_ee25150);
    dp->~ee25150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25150(Test_ee25150, "ee25150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee25150C1Ev();
extern void _ZN7ee25150D1Ev();
Name_Map name_map_ee25150[] = {
  NSPAIR(_ZN7ee25150C1Ev),
  NSPAIR(_ZN7ee25150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee25150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25150[];
extern void _ZN6dd51503barEv();
extern void _ZN7ee251503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
  (VTBL_ENTRY)&_ZN7ee251503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee25150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
extern VTBL_ENTRY _ZTV7ee25150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee25150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee25150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee25150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee25150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee25150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee25150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee25150[] = {
  {&(_ZTV7ee25150[5]),  5,16},
  {&(_tg__ZTV6dd5150__7ee25150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee25150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee25150[4]),  4,5},
  {&(_ZTV7ee25150[11]),  11,16},
  {&(_ZTV7ee25150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee25150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee25150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee25150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee25150[];
extern  VTBL_ENTRY _ZTV7ee25150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25150[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25150 = {  "ee25150", // class name
  bases_ee25150, 4,
  &(vtc_ee25150[0]), // expected_vtbl_contents
  &(vtt_ee25150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee25150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35150  : virtual dd5150 {
  int e;
  virtual void  foo(); // _ZN7ee351503fooEv
  ~ee35150(); // tgen
  ee35150(); // tgen
};
//SIG(1 ee35150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee35150 ::foo(){vfunc_called(this, "_ZN7ee351503fooEv");}
ee35150 ::~ee35150(){ note_dtor("ee35150", this);} // tgen
ee35150 ::ee35150(){ note_ctor("ee35150", this);} // tgen

static void Test_ee35150()
{
  extern Class_Descriptor cd_ee35150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee35150, buf);
    ee35150 *dp, &lv = *(dp=new (buf) ee35150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee35150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee35150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee35150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(32,16), "ee35150");
    check_base_class_offset(lv, (dd5150*), ABISELECT(16,8), "ee35150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35150.e");
    test_class_info(&lv, &cd_ee35150);
    dp->~ee35150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35150(Test_ee35150, "ee35150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee35150C1Ev();
extern void _ZN7ee35150D1Ev();
Name_Map name_map_ee35150[] = {
  NSPAIR(_ZN7ee35150C1Ev),
  NSPAIR(_ZN7ee35150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee35150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35150[];
extern void _ZN7ee351503fooEv();
extern void _ZN6dd51503barEv();
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35150[0]),
  (VTBL_ENTRY)&_ZN7ee351503fooEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35150[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee35150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
extern VTBL_ENTRY _ZTV7ee35150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee35150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee35150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee35150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee35150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee35150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee35150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee35150[] = {
  {&(_ZTV7ee35150[6]),  6,23},
  {&(_ZTV7ee35150[13]),  13,23},
  {&(_ZTV7ee35150[18]),  18,23},
  {&(_ZTV7ee35150[22]),  22,23},
  {&(_tg__ZTV6dd5150__7ee35150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee35150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee35150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee35150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee35150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee35150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35150[];
extern  VTBL_ENTRY _ZTV7ee35150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35150[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35150 = {  "ee35150", // class name
  bases_ee35150, 4,
  &(vtc_ee35150[0]), // expected_vtbl_contents
  &(vtt_ee35150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee35150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35150),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45150  : dd5150 {
  int e;
  virtual void  bar(); // _ZN7ee451503barEv
  ~ee45150(); // tgen
  ee45150(); // tgen
};
//SIG(1 ee45150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee45150 ::bar(){vfunc_called(this, "_ZN7ee451503barEv");}
ee45150 ::~ee45150(){ note_dtor("ee45150", this);} // tgen
ee45150 ::ee45150(){ note_ctor("ee45150", this);} // tgen

static void Test_ee45150()
{
  extern Class_Descriptor cd_ee45150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee45150, buf);
    ee45150 *dp, &lv = *(dp=new (buf) ee45150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee45150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee45150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee45150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(16,12), "ee45150");
    check_base_class_offset(lv, (dd5150*), 0, "ee45150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45150.e");
    test_class_info(&lv, &cd_ee45150);
    dp->~ee45150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45150(Test_ee45150, "ee45150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee45150C1Ev();
extern void _ZN7ee45150D1Ev();
Name_Map name_map_ee45150[] = {
  NSPAIR(_ZN7ee45150C1Ev),
  NSPAIR(_ZN7ee45150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee45150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45150[];
extern void _ZN7ee451503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee451503barEv,_ZTv0_n16_N7ee451503barEv)();
extern void ABISELECT(_ZThn32_N7ee451503barEv,_ZThn20_N7ee451503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee45150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45150[0]),
  (VTBL_ENTRY)&_ZN7ee451503barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee45150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee451503barEv,_ZTv0_n16_N7ee451503barEv),
};
extern VTBL_ENTRY _ZTV7ee45150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee45150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee45150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee45150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee45150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee45150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee45150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee45150[] = {
  {&(_ZTV7ee45150[5]),  5,15},
  {&(_tg__ZTV6dd5150__7ee45150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee45150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee45150[4]),  4,5},
  {&(_ZTV7ee45150[10]),  10,15},
  {&(_ZTV7ee45150[14]),  14,15},
  {&(_tg__ZTV5cc150__7ee45150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee45150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee45150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee45150[];
extern  VTBL_ENTRY _ZTV7ee45150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45150[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee451503barEv,_ZTv0_n16_N7ee451503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee451503barEv,_ZThn20_N7ee451503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45150 = {  "ee45150", // class name
  bases_ee45150, 4,
  &(vtc_ee45150[0]), // expected_vtbl_contents
  &(vtt_ee45150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee45150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45150),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55150  : virtual dd5150 {
  int e;
  virtual void  bar(); // _ZN7ee551503barEv
  ~ee55150(); // tgen
  ee55150(); // tgen
};
//SIG(1 ee55150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee55150 ::bar(){vfunc_called(this, "_ZN7ee551503barEv");}
ee55150 ::~ee55150(){ note_dtor("ee55150", this);} // tgen
ee55150 ::ee55150(){ note_ctor("ee55150", this);} // tgen

static void Test_ee55150()
{
  extern Class_Descriptor cd_ee55150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee55150, buf);
    ee55150 *dp, &lv = *(dp=new (buf) ee55150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee55150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee55150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee55150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(32,16), "ee55150");
    check_base_class_offset(lv, (dd5150*), ABISELECT(16,8), "ee55150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55150.e");
    test_class_info(&lv, &cd_ee55150);
    dp->~ee55150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55150(Test_ee55150, "ee55150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee55150C1Ev();
extern void _ZN7ee55150D1Ev();
Name_Map name_map_ee55150[] = {
  NSPAIR(_ZN7ee55150C1Ev),
  NSPAIR(_ZN7ee55150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee55150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55150[];
extern void _ZN7ee551503barEv();
extern void ABISELECT(_ZTv0_n48_N7ee551503barEv,_ZTv0_n24_N7ee551503barEv)();
extern void ABISELECT(_ZThn16_N7ee551503barEv,_ZThn8_N7ee551503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee551503barEv,_ZTv0_n16_N7ee551503barEv)();
extern void ABISELECT(_ZThn48_N7ee551503barEv,_ZThn24_N7ee551503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55150[0]),
  (VTBL_ENTRY)&_ZN7ee551503barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee551503barEv,_ZTv0_n24_N7ee551503barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee55150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee551503barEv,_ZTv0_n16_N7ee551503barEv),
};
extern VTBL_ENTRY _ZTV7ee55150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee55150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee55150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee55150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee55150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee55150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee55150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee55150[] = {
  {&(_ZTV7ee55150[6]),  6,23},
  {&(_ZTV7ee55150[13]),  13,23},
  {&(_ZTV7ee55150[18]),  18,23},
  {&(_ZTV7ee55150[22]),  22,23},
  {&(_tg__ZTV6dd5150__7ee55150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee55150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee55150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee55150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee55150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee55150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55150[];
extern  VTBL_ENTRY _ZTV7ee55150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55150[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee551503barEv,_ZTv0_n16_N7ee551503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee551503barEv,_ZThn24_N7ee551503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee551503barEv,_ZTv0_n24_N7ee551503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551503barEv,_ZThn8_N7ee551503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55150 = {  "ee55150", // class name
  bases_ee55150, 4,
  &(vtc_ee55150[0]), // expected_vtbl_contents
  &(vtt_ee55150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee55150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55150),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65150  : dd5150 {
  int e;
  virtual void  foo(); // _ZN7ee651503fooEv
  virtual void  bar(); // _ZN7ee651503barEv
  ~ee65150(); // tgen
  ee65150(); // tgen
};
//SIG(1 ee65150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65150 ::foo(){vfunc_called(this, "_ZN7ee651503fooEv");}
void  ee65150 ::bar(){vfunc_called(this, "_ZN7ee651503barEv");}
ee65150 ::~ee65150(){ note_dtor("ee65150", this);} // tgen
ee65150 ::ee65150(){ note_ctor("ee65150", this);} // tgen

static void Test_ee65150()
{
  extern Class_Descriptor cd_ee65150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee65150, buf);
    ee65150 *dp, &lv = *(dp=new (buf) ee65150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee65150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee65150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee65150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(16,12), "ee65150");
    check_base_class_offset(lv, (dd5150*), 0, "ee65150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65150.e");
    test_class_info(&lv, &cd_ee65150);
    dp->~ee65150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65150(Test_ee65150, "ee65150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee65150C1Ev();
extern void _ZN7ee65150D1Ev();
Name_Map name_map_ee65150[] = {
  NSPAIR(_ZN7ee65150C1Ev),
  NSPAIR(_ZN7ee65150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee65150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65150[];
extern void _ZN7ee651503barEv();
extern void _ZN7ee651503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee651503barEv,_ZTv0_n16_N7ee651503barEv)();
extern void ABISELECT(_ZThn32_N7ee651503barEv,_ZThn20_N7ee651503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65150[0]),
  (VTBL_ENTRY)&_ZN7ee651503barEv,
  (VTBL_ENTRY)&_ZN7ee651503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee65150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee651503barEv,_ZTv0_n16_N7ee651503barEv),
};
extern VTBL_ENTRY _ZTV7ee65150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee65150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee65150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee65150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee65150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee65150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee65150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee65150[] = {
  {&(_ZTV7ee65150[5]),  5,16},
  {&(_tg__ZTV6dd5150__7ee65150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee65150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee65150[4]),  4,5},
  {&(_ZTV7ee65150[11]),  11,16},
  {&(_ZTV7ee65150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee65150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee65150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee65150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee65150[];
extern  VTBL_ENTRY _ZTV7ee65150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65150[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn20_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee651503barEv,_ZTv0_n16_N7ee651503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651503barEv,_ZThn20_N7ee651503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65150 = {  "ee65150", // class name
  bases_ee65150, 4,
  &(vtc_ee65150[0]), // expected_vtbl_contents
  &(vtt_ee65150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee65150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75150  : virtual dd5150 {
  int e;
  virtual void  foo(); // _ZN7ee751503fooEv
  virtual void  bar(); // _ZN7ee751503barEv
  ~ee75150(); // tgen
  ee75150(); // tgen
};
//SIG(1 ee75150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75150 ::foo(){vfunc_called(this, "_ZN7ee751503fooEv");}
void  ee75150 ::bar(){vfunc_called(this, "_ZN7ee751503barEv");}
ee75150 ::~ee75150(){ note_dtor("ee75150", this);} // tgen
ee75150 ::ee75150(){ note_ctor("ee75150", this);} // tgen

static void Test_ee75150()
{
  extern Class_Descriptor cd_ee75150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee75150, buf);
    ee75150 *dp, &lv = *(dp=new (buf) ee75150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee75150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee75150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee75150");
    check_base_class_offset(lv, (cc150*)(dd5150*), ABISELECT(32,16), "ee75150");
    check_base_class_offset(lv, (dd5150*), ABISELECT(16,8), "ee75150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75150.e");
    test_class_info(&lv, &cd_ee75150);
    dp->~ee75150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75150(Test_ee75150, "ee75150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee75150C1Ev();
extern void _ZN7ee75150D1Ev();
Name_Map name_map_ee75150[] = {
  NSPAIR(_ZN7ee75150C1Ev),
  NSPAIR(_ZN7ee75150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd5150;
extern VTBL_ENTRY _ZTI6dd5150[];
extern  VTBL_ENTRY _ZTV6dd5150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5150[];
static Base_Class bases_ee75150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5150,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75150[];
extern void _ZN7ee751503fooEv();
extern void _ZN7ee751503barEv();
extern void ABISELECT(_ZTv0_n48_N7ee751503barEv,_ZTv0_n24_N7ee751503barEv)();
extern void ABISELECT(_ZThn16_N7ee751503barEv,_ZThn8_N7ee751503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee751503barEv,_ZTv0_n16_N7ee751503barEv)();
extern void ABISELECT(_ZThn48_N7ee751503barEv,_ZThn24_N7ee751503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75150[0]),
  (VTBL_ENTRY)&_ZN7ee751503fooEv,
  (VTBL_ENTRY)&_ZN7ee751503barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee751503barEv,_ZTv0_n24_N7ee751503barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee75150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee751503barEv,_ZTv0_n16_N7ee751503barEv),
};
extern VTBL_ENTRY _ZTV7ee75150[];
extern void _ZN6dd51503barEv();
static  VTBL_ENTRY _tg__ZTV6dd5150__7ee75150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&_ZN6dd51503barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd5150__7ee75150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv)();
extern void ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd5150__7ee75150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee75150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee75150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee75150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee75150[] = {
  {&(_ZTV7ee75150[6]),  6,24},
  {&(_ZTV7ee75150[14]),  14,24},
  {&(_ZTV7ee75150[19]),  19,24},
  {&(_ZTV7ee75150[23]),  23,24},
  {&(_tg__ZTV6dd5150__7ee75150[5]),  5,6},
  {&(_tg__ZTV5cc150__6dd5150__7ee75150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd5150__7ee75150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee75150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee75150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee75150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75150[];
extern  VTBL_ENTRY _ZTV7ee75150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75150[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd51503barEv,_ZTv0_n16_N6dd51503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51503barEv,_ZThn16_N6dd51503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee751503barEv,_ZTv0_n16_N7ee751503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751503barEv,_ZThn24_N7ee751503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee751503barEv,_ZTv0_n24_N7ee751503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751503barEv,_ZThn8_N7ee751503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75150 = {  "ee75150", // class name
  bases_ee75150, 4,
  &(vtc_ee75150[0]), // expected_vtbl_contents
  &(vtt_ee75150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee75150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75150),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6150  : cc150 {
  int d;
  virtual void  bar(); // _ZN6dd61503barEv
  virtual void  foo(); // _ZN6dd61503fooEv
  ~dd6150(); // tgen
  dd6150(); // tgen
};
//SIG(-1 dd6150) C1{ BC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd6150 ::bar(){vfunc_called(this, "_ZN6dd61503barEv");}
void  dd6150 ::foo(){vfunc_called(this, "_ZN6dd61503fooEv");}
dd6150 ::~dd6150(){ note_dtor("dd6150", this);} // tgen
dd6150 ::dd6150(){ note_ctor("dd6150", this);} // tgen

static void Test_dd6150()
{
  extern Class_Descriptor cd_dd6150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd6150, buf);
    dd6150 *dp, &lv = *(dp=new (buf) dd6150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd6150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(28,20), "dd6150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(16,12), "dd6150");
    check_base_class_offset(lv, (cc150*), 0, "dd6150");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6150.d");
    test_class_info(&lv, &cd_dd6150);
    dp->~dd6150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6150(Test_dd6150, "dd6150", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd6150C1Ev();
extern void _ZN6dd6150D1Ev();
Name_Map name_map_dd6150[] = {
  NSPAIR(_ZN6dd6150C1Ev),
  NSPAIR(_ZN6dd6150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd6150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd6150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern VTBL_ENTRY _ZTV6dd6150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd6150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd6150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd6150[] = {
  {&(_ZTV6dd6150[4]),  4,11},
  {&(_tg__ZTV5cc150__6dd6150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd6150[4]),  4,5},
  {&(_ZTV6dd6150[10]),  10,11},
  {&(_tg__ZTV4bb50__6dd6150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd6150 = {  "dd6150", // class name
  bases_dd6150, 3,
  &(vtc_dd6150[0]), // expected_vtbl_contents
  &(vtt_dd6150[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd6150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6150),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06150  : dd6150 {
  int e;
  ~ee06150(); // tgen
  ee06150(); // tgen
};
//SIG(1 ee06150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee06150 ::~ee06150(){ note_dtor("ee06150", this);} // tgen
ee06150 ::ee06150(){ note_ctor("ee06150", this);} // tgen

static void Test_ee06150()
{
  extern Class_Descriptor cd_ee06150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee06150, buf);
    ee06150 *dp, &lv = *(dp=new (buf) ee06150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee06150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee06150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(24,16), "ee06150");
    check_base_class_offset(lv, (cc150*)(dd6150*), 0, "ee06150");
    check_base_class_offset(lv, (dd6150*), 0, "ee06150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06150.e");
    test_class_info(&lv, &cd_ee06150);
    dp->~ee06150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06150(Test_ee06150, "ee06150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee06150C1Ev();
extern void _ZN7ee06150D1Ev();
Name_Map name_map_ee06150[] = {
  NSPAIR(_ZN7ee06150C1Ev),
  NSPAIR(_ZN7ee06150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee06150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee06150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee06150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern VTBL_ENTRY _ZTV7ee06150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee06150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee06150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee06150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee06150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee06150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee06150[] = {
  {&(_ZTV7ee06150[4]),  4,11},
  {&(_tg__ZTV6dd6150__7ee06150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee06150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee06150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee06150[4]),  4,5},
  {&(_ZTV7ee06150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee06150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee06150[];
extern  VTBL_ENTRY _ZTV7ee06150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06150[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee06150 = {  "ee06150", // class name
  bases_ee06150, 4,
  &(vtc_ee06150[0]), // expected_vtbl_contents
  &(vtt_ee06150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee06150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16150  : virtual dd6150 {
  int e;
  ~ee16150(); // tgen
  ee16150(); // tgen
};
//SIG(1 ee16150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee16150 ::~ee16150(){ note_dtor("ee16150", this);} // tgen
ee16150 ::ee16150(){ note_ctor("ee16150", this);} // tgen

static void Test_ee16150()
{
  extern Class_Descriptor cd_ee16150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee16150, buf);
    ee16150 *dp, &lv = *(dp=new (buf) ee16150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee16150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee16150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(32,20), "ee16150");
    check_base_class_offset(lv, (cc150*)(dd6150*), ABISELECT(16,8), "ee16150");
    check_base_class_offset(lv, (dd6150*), ABISELECT(16,8), "ee16150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16150.e");
    test_class_info(&lv, &cd_ee16150);
    dp->~ee16150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16150(Test_ee16150, "ee16150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee16150C1Ev();
extern void _ZN7ee16150D1Ev();
Name_Map name_map_ee16150[] = {
  NSPAIR(_ZN7ee16150C1Ev),
  NSPAIR(_ZN7ee16150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee16150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee16150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16150[0]),
  0,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee16150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern VTBL_ENTRY _ZTV7ee16150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee16150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee16150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee16150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee16150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee16150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee16150[] = {
  {&(_ZTV7ee16150[5]),  5,18},
  {&(_ZTV7ee16150[11]),  11,18},
  {&(_ZTV7ee16150[17]),  17,18},
  {&(_tg__ZTV6dd6150__7ee16150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee16150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee16150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee16150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee16150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee16150[];
extern  VTBL_ENTRY _ZTV7ee16150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16150[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee16150 = {  "ee16150", // class name
  bases_ee16150, 4,
  &(vtc_ee16150[0]), // expected_vtbl_contents
  &(vtt_ee16150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee16150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16150),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26150  : dd6150 {
  int e;
  virtual void  foo(); // _ZN7ee261503fooEv
  ~ee26150(); // tgen
  ee26150(); // tgen
};
//SIG(1 ee26150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26150 ::foo(){vfunc_called(this, "_ZN7ee261503fooEv");}
ee26150 ::~ee26150(){ note_dtor("ee26150", this);} // tgen
ee26150 ::ee26150(){ note_ctor("ee26150", this);} // tgen

static void Test_ee26150()
{
  extern Class_Descriptor cd_ee26150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee26150, buf);
    ee26150 *dp, &lv = *(dp=new (buf) ee26150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee26150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee26150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(24,16), "ee26150");
    check_base_class_offset(lv, (cc150*)(dd6150*), 0, "ee26150");
    check_base_class_offset(lv, (dd6150*), 0, "ee26150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26150.e");
    test_class_info(&lv, &cd_ee26150);
    dp->~ee26150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26150(Test_ee26150, "ee26150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee26150C1Ev();
extern void _ZN7ee26150D1Ev();
Name_Map name_map_ee26150[] = {
  NSPAIR(_ZN7ee26150C1Ev),
  NSPAIR(_ZN7ee26150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee26150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26150[];
extern void _ZN6dd61503barEv();
extern void _ZN7ee261503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee26150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN7ee261503fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee26150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern VTBL_ENTRY _ZTV7ee26150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee26150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee26150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee26150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee26150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee26150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee26150[] = {
  {&(_ZTV7ee26150[4]),  4,11},
  {&(_tg__ZTV6dd6150__7ee26150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee26150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee26150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee26150[4]),  4,5},
  {&(_ZTV7ee26150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee26150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee26150[];
extern  VTBL_ENTRY _ZTV7ee26150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26150[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee26150 = {  "ee26150", // class name
  bases_ee26150, 4,
  &(vtc_ee26150[0]), // expected_vtbl_contents
  &(vtt_ee26150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee26150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36150  : virtual dd6150 {
  int e;
  virtual void  foo(); // _ZN7ee361503fooEv
  ~ee36150(); // tgen
  ee36150(); // tgen
};
//SIG(1 ee36150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36150 ::foo(){vfunc_called(this, "_ZN7ee361503fooEv");}
ee36150 ::~ee36150(){ note_dtor("ee36150", this);} // tgen
ee36150 ::ee36150(){ note_ctor("ee36150", this);} // tgen

static void Test_ee36150()
{
  extern Class_Descriptor cd_ee36150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee36150, buf);
    ee36150 *dp, &lv = *(dp=new (buf) ee36150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee36150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee36150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(32,20), "ee36150");
    check_base_class_offset(lv, (cc150*)(dd6150*), ABISELECT(16,8), "ee36150");
    check_base_class_offset(lv, (dd6150*), ABISELECT(16,8), "ee36150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36150.e");
    test_class_info(&lv, &cd_ee36150);
    dp->~ee36150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36150(Test_ee36150, "ee36150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee36150C1Ev();
extern void _ZN7ee36150D1Ev();
Name_Map name_map_ee36150[] = {
  NSPAIR(_ZN7ee36150C1Ev),
  NSPAIR(_ZN7ee36150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee36150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36150[];
extern void _ZN7ee361503fooEv();
extern void _ZN6dd61503barEv();
extern void ABISELECT(_ZTv0_n48_N7ee361503fooEv,_ZTv0_n24_N7ee361503fooEv)();
extern void ABISELECT(_ZThn16_N7ee361503fooEv,_ZThn8_N7ee361503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36150[0]),
  (VTBL_ENTRY)&_ZN7ee361503fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee361503fooEv,_ZTv0_n24_N7ee361503fooEv),
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee36150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern VTBL_ENTRY _ZTV7ee36150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee36150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee36150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee36150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee36150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee36150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee36150[] = {
  {&(_ZTV7ee36150[5]),  5,19},
  {&(_ZTV7ee36150[12]),  12,19},
  {&(_ZTV7ee36150[18]),  18,19},
  {&(_tg__ZTV6dd6150__7ee36150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee36150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee36150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee36150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee36150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee36150[];
extern  VTBL_ENTRY _ZTV7ee36150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36150[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee361503fooEv,_ZTv0_n24_N7ee361503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361503fooEv,_ZThn8_N7ee361503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36150 = {  "ee36150", // class name
  bases_ee36150, 4,
  &(vtc_ee36150[0]), // expected_vtbl_contents
  &(vtt_ee36150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee36150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36150),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46150  : dd6150 {
  int e;
  virtual void  bar(); // _ZN7ee461503barEv
  ~ee46150(); // tgen
  ee46150(); // tgen
};
//SIG(1 ee46150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46150 ::bar(){vfunc_called(this, "_ZN7ee461503barEv");}
ee46150 ::~ee46150(){ note_dtor("ee46150", this);} // tgen
ee46150 ::ee46150(){ note_ctor("ee46150", this);} // tgen

static void Test_ee46150()
{
  extern Class_Descriptor cd_ee46150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee46150, buf);
    ee46150 *dp, &lv = *(dp=new (buf) ee46150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee46150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee46150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(24,16), "ee46150");
    check_base_class_offset(lv, (cc150*)(dd6150*), 0, "ee46150");
    check_base_class_offset(lv, (dd6150*), 0, "ee46150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46150.e");
    test_class_info(&lv, &cd_ee46150);
    dp->~ee46150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46150(Test_ee46150, "ee46150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee46150C1Ev();
extern void _ZN7ee46150D1Ev();
Name_Map name_map_ee46150[] = {
  NSPAIR(_ZN7ee46150C1Ev),
  NSPAIR(_ZN7ee46150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee46150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46150[];
extern void _ZN7ee461503barEv();
extern void _ZN6dd61503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee461503barEv,_ZTv0_n16_N7ee461503barEv)();
extern void ABISELECT(_ZThn24_N7ee461503barEv,_ZThn16_N7ee461503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee46150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46150[0]),
  (VTBL_ENTRY)&_ZN7ee461503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee46150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee461503barEv,_ZTv0_n16_N7ee461503barEv),
};
extern VTBL_ENTRY _ZTV7ee46150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee46150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee46150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee46150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee46150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee46150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee46150[] = {
  {&(_ZTV7ee46150[4]),  4,11},
  {&(_tg__ZTV6dd6150__7ee46150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee46150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee46150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee46150[4]),  4,5},
  {&(_ZTV7ee46150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee46150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee46150[];
extern  VTBL_ENTRY _ZTV7ee46150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46150[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee461503barEv,_ZTv0_n16_N7ee461503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee461503barEv,_ZThn16_N7ee461503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee46150 = {  "ee46150", // class name
  bases_ee46150, 4,
  &(vtc_ee46150[0]), // expected_vtbl_contents
  &(vtt_ee46150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee46150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56150  : virtual dd6150 {
  int e;
  virtual void  bar(); // _ZN7ee561503barEv
  ~ee56150(); // tgen
  ee56150(); // tgen
};
//SIG(1 ee56150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56150 ::bar(){vfunc_called(this, "_ZN7ee561503barEv");}
ee56150 ::~ee56150(){ note_dtor("ee56150", this);} // tgen
ee56150 ::ee56150(){ note_ctor("ee56150", this);} // tgen

static void Test_ee56150()
{
  extern Class_Descriptor cd_ee56150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee56150, buf);
    ee56150 *dp, &lv = *(dp=new (buf) ee56150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee56150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee56150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(32,20), "ee56150");
    check_base_class_offset(lv, (cc150*)(dd6150*), ABISELECT(16,8), "ee56150");
    check_base_class_offset(lv, (dd6150*), ABISELECT(16,8), "ee56150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56150.e");
    test_class_info(&lv, &cd_ee56150);
    dp->~ee56150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56150(Test_ee56150, "ee56150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee56150C1Ev();
extern void _ZN7ee56150D1Ev();
Name_Map name_map_ee56150[] = {
  NSPAIR(_ZN7ee56150C1Ev),
  NSPAIR(_ZN7ee56150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee56150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56150[];
extern void _ZN7ee561503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee561503barEv,_ZTv0_n20_N7ee561503barEv)();
extern void ABISELECT(_ZThn16_N7ee561503barEv,_ZThn8_N7ee561503barEv)() __attribute__((weak));
extern void _ZN6dd61503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee561503barEv,_ZTv0_n16_N7ee561503barEv)();
extern void ABISELECT(_ZThn32_N7ee561503barEv,_ZThn20_N7ee561503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56150[0]),
  (VTBL_ENTRY)&_ZN7ee561503barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee561503barEv,_ZTv0_n20_N7ee561503barEv),
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee56150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee561503barEv,_ZTv0_n16_N7ee561503barEv),
};
extern VTBL_ENTRY _ZTV7ee56150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee56150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee56150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee56150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee56150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee56150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee56150[] = {
  {&(_ZTV7ee56150[5]),  5,19},
  {&(_ZTV7ee56150[12]),  12,19},
  {&(_ZTV7ee56150[18]),  18,19},
  {&(_tg__ZTV6dd6150__7ee56150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee56150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee56150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee56150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee56150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee56150[];
extern  VTBL_ENTRY _ZTV7ee56150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56150[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee561503barEv,_ZTv0_n16_N7ee561503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee561503barEv,_ZThn20_N7ee561503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee561503barEv,_ZTv0_n20_N7ee561503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561503barEv,_ZThn8_N7ee561503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56150 = {  "ee56150", // class name
  bases_ee56150, 4,
  &(vtc_ee56150[0]), // expected_vtbl_contents
  &(vtt_ee56150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee56150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56150),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66150  : dd6150 {
  int e;
  virtual void  foo(); // _ZN7ee661503fooEv
  virtual void  bar(); // _ZN7ee661503barEv
  ~ee66150(); // tgen
  ee66150(); // tgen
};
//SIG(1 ee66150) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66150 ::foo(){vfunc_called(this, "_ZN7ee661503fooEv");}
void  ee66150 ::bar(){vfunc_called(this, "_ZN7ee661503barEv");}
ee66150 ::~ee66150(){ note_dtor("ee66150", this);} // tgen
ee66150 ::ee66150(){ note_ctor("ee66150", this);} // tgen

static void Test_ee66150()
{
  extern Class_Descriptor cd_ee66150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee66150, buf);
    ee66150 *dp, &lv = *(dp=new (buf) ee66150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee66150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(36,24), "ee66150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(24,16), "ee66150");
    check_base_class_offset(lv, (cc150*)(dd6150*), 0, "ee66150");
    check_base_class_offset(lv, (dd6150*), 0, "ee66150");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66150.e");
    test_class_info(&lv, &cd_ee66150);
    dp->~ee66150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66150(Test_ee66150, "ee66150", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee66150C1Ev();
extern void _ZN7ee66150D1Ev();
Name_Map name_map_ee66150[] = {
  NSPAIR(_ZN7ee66150C1Ev),
  NSPAIR(_ZN7ee66150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee66150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66150[];
extern void _ZN7ee661503barEv();
extern void _ZN7ee661503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee661503barEv,_ZTv0_n16_N7ee661503barEv)();
extern void ABISELECT(_ZThn24_N7ee661503barEv,_ZThn16_N7ee661503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee66150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66150[0]),
  (VTBL_ENTRY)&_ZN7ee661503barEv,
  (VTBL_ENTRY)&_ZN7ee661503fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee66150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee661503barEv,_ZTv0_n16_N7ee661503barEv),
};
extern VTBL_ENTRY _ZTV7ee66150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee66150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee66150[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee66150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee66150[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee66150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee66150[] = {
  {&(_ZTV7ee66150[4]),  4,11},
  {&(_tg__ZTV6dd6150__7ee66150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee66150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee66150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee66150[4]),  4,5},
  {&(_ZTV7ee66150[10]),  10,11},
  {&(_tg__ZTV4bb50__7ee66150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee66150[];
extern  VTBL_ENTRY _ZTV7ee66150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66150[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61503barEv,_ZThn16_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee661503barEv,_ZTv0_n16_N7ee661503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661503barEv,_ZThn16_N7ee661503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee66150 = {  "ee66150", // class name
  bases_ee66150, 4,
  &(vtc_ee66150[0]), // expected_vtbl_contents
  &(vtt_ee66150[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee66150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66150),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66150),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76150  : virtual dd6150 {
  int e;
  virtual void  foo(); // _ZN7ee761503fooEv
  virtual void  bar(); // _ZN7ee761503barEv
  ~ee76150(); // tgen
  ee76150(); // tgen
};
//SIG(1 ee76150) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76150 ::foo(){vfunc_called(this, "_ZN7ee761503fooEv");}
void  ee76150 ::bar(){vfunc_called(this, "_ZN7ee761503barEv");}
ee76150 ::~ee76150(){ note_dtor("ee76150", this);} // tgen
ee76150 ::ee76150(){ note_ctor("ee76150", this);} // tgen

static void Test_ee76150()
{
  extern Class_Descriptor cd_ee76150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee76150, buf);
    ee76150 *dp, &lv = *(dp=new (buf) ee76150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee76150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee76150");
    check_base_class_offset(lv, (bb50*)(cc150*)(dd6150*), ABISELECT(32,20), "ee76150");
    check_base_class_offset(lv, (cc150*)(dd6150*), ABISELECT(16,8), "ee76150");
    check_base_class_offset(lv, (dd6150*), ABISELECT(16,8), "ee76150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76150.e");
    test_class_info(&lv, &cd_ee76150);
    dp->~ee76150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76150(Test_ee76150, "ee76150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee76150C1Ev();
extern void _ZN7ee76150D1Ev();
Name_Map name_map_ee76150[] = {
  NSPAIR(_ZN7ee76150C1Ev),
  NSPAIR(_ZN7ee76150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd6150;
extern VTBL_ENTRY _ZTI6dd6150[];
extern  VTBL_ENTRY _ZTV6dd6150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6150[];
static Base_Class bases_ee76150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76150[];
extern void _ZN7ee761503fooEv();
extern void _ZN7ee761503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee761503barEv,_ZTv0_n20_N7ee761503barEv)();
extern void ABISELECT(_ZThn16_N7ee761503barEv,_ZThn8_N7ee761503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee761503fooEv,_ZTv0_n24_N7ee761503fooEv)();
extern void ABISELECT(_ZThn16_N7ee761503fooEv,_ZThn8_N7ee761503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee761503barEv,_ZTv0_n16_N7ee761503barEv)();
extern void ABISELECT(_ZThn32_N7ee761503barEv,_ZThn20_N7ee761503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76150[0]),
  (VTBL_ENTRY)&_ZN7ee761503fooEv,
  (VTBL_ENTRY)&_ZN7ee761503barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761503barEv,_ZTv0_n20_N7ee761503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee761503fooEv,_ZTv0_n24_N7ee761503fooEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee76150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761503barEv,_ZTv0_n16_N7ee761503barEv),
};
extern VTBL_ENTRY _ZTV7ee76150[];
extern void _ZN6dd61503barEv();
extern void _ZN6dd61503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6150__7ee76150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&_ZN6dd61503barEv,
  (VTBL_ENTRY)&_ZN6dd61503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1506dd6150__7ee76150[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc1506dd6150__7ee76150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv)();
extern void ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd6150__7ee76150[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee76150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee76150[] = {
  {&(_ZTV7ee76150[5]),  5,20},
  {&(_ZTV7ee76150[13]),  13,20},
  {&(_ZTV7ee76150[19]),  19,20},
  {&(_tg__ZTV6dd6150__7ee76150[4]),  4,6},
  {&(_tg__ZTV5cc1506dd6150__7ee76150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc1506dd6150__7ee76150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd6150__7ee76150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee76150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee76150[];
extern  VTBL_ENTRY _ZTV7ee76150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76150[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61503barEv,_ZTv0_n16_N6dd61503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61503barEv,_ZThn12_N6dd61503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761503barEv,_ZTv0_n16_N7ee761503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761503barEv,_ZThn20_N7ee761503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee761503fooEv,_ZTv0_n24_N7ee761503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761503fooEv,_ZThn8_N7ee761503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761503barEv,_ZTv0_n20_N7ee761503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761503barEv,_ZThn8_N7ee761503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76150 = {  "ee76150", // class name
  bases_ee76150, 4,
  &(vtc_ee76150[0]), // expected_vtbl_contents
  &(vtt_ee76150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee76150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76150),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76150),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7150  : virtual cc150 {
  int d;
  virtual void  bar(); // _ZN6dd71503barEv
  virtual void  foo(); // _ZN6dd71503fooEv
  ~dd7150(); // tgen
  dd7150(); // tgen
};
//SIG(-1 dd7150) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd7150 ::bar(){vfunc_called(this, "_ZN6dd71503barEv");}
void  dd7150 ::foo(){vfunc_called(this, "_ZN6dd71503fooEv");}
dd7150 ::~dd7150(){ note_dtor("dd7150", this);} // tgen
dd7150 ::dd7150(){ note_ctor("dd7150", this);} // tgen

static void Test_dd7150()
{
  extern Class_Descriptor cd_dd7150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd7150, buf);
    dd7150 *dp, &lv = *(dp=new (buf) dd7150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd7150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,24), "dd7150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,16), "dd7150");
    check_base_class_offset(lv, (cc150*), ABISELECT(16,8), "dd7150");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7150.d");
    test_class_info(&lv, &cd_dd7150);
    dp->~dd7150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7150(Test_dd7150, "dd7150", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd7150C1Ev();
extern void _ZN6dd7150D1Ev();
Name_Map name_map_dd7150[] = {
  NSPAIR(_ZN6dd7150C1Ev),
  NSPAIR(_ZN6dd7150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
static Base_Class bases_dd7150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
extern VTBL_ENTRY _ZTV6dd7150[];
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__6dd7150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd7150[] = {
  {&(_ZTV6dd7150[5]),  5,16},
  {&(_ZTV6dd7150[11]),  11,16},
  {&(_ZTV6dd7150[15]),  15,16},
  {&(_tg__ZTV5cc150__6dd7150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__6dd7150[4]),  4,5},
  {&(_tg__ZTV4bb50__6dd7150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7150 = {  "dd7150", // class name
  bases_dd7150, 3,
  &(vtc_dd7150[0]), // expected_vtbl_contents
  &(vtt_dd7150[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd7150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7150),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07150  : dd7150 {
  int e;
  ~ee07150(); // tgen
  ee07150(); // tgen
};
//SIG(1 ee07150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee07150 ::~ee07150(){ note_dtor("ee07150", this);} // tgen
ee07150 ::ee07150(){ note_ctor("ee07150", this);} // tgen

static void Test_ee07150()
{
  extern Class_Descriptor cd_ee07150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee07150, buf);
    ee07150 *dp, &lv = *(dp=new (buf) ee07150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee07150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee07150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee07150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(16,12), "ee07150");
    check_base_class_offset(lv, (dd7150*), 0, "ee07150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07150.e");
    test_class_info(&lv, &cd_ee07150);
    dp->~ee07150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07150(Test_ee07150, "ee07150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee07150C1Ev();
extern void _ZN7ee07150D1Ev();
Name_Map name_map_ee07150[] = {
  NSPAIR(_ZN7ee07150C1Ev),
  NSPAIR(_ZN7ee07150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee07150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee07150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
extern VTBL_ENTRY _ZTV7ee07150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee07150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee07150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee07150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee07150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee07150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee07150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee07150[] = {
  {&(_ZTV7ee07150[5]),  5,16},
  {&(_tg__ZTV6dd7150__7ee07150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee07150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee07150[4]),  4,5},
  {&(_ZTV7ee07150[11]),  11,16},
  {&(_ZTV7ee07150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee07150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee07150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee07150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee07150[];
extern  VTBL_ENTRY _ZTV7ee07150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07150[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07150 = {  "ee07150", // class name
  bases_ee07150, 4,
  &(vtc_ee07150[0]), // expected_vtbl_contents
  &(vtt_ee07150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee07150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17150  : virtual dd7150 {
  int e;
  ~ee17150(); // tgen
  ee17150(); // tgen
};
//SIG(1 ee17150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee17150 ::~ee17150(){ note_dtor("ee17150", this);} // tgen
ee17150 ::ee17150(){ note_ctor("ee17150", this);} // tgen

static void Test_ee17150()
{
  extern Class_Descriptor cd_ee17150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee17150, buf);
    ee17150 *dp, &lv = *(dp=new (buf) ee17150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee17150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee17150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee17150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(32,16), "ee17150");
    check_base_class_offset(lv, (dd7150*), ABISELECT(16,8), "ee17150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17150.e");
    test_class_info(&lv, &cd_ee17150);
    dp->~ee17150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17150(Test_ee17150, "ee17150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee17150C1Ev();
extern void _ZN7ee17150D1Ev();
Name_Map name_map_ee17150[] = {
  NSPAIR(_ZN7ee17150C1Ev),
  NSPAIR(_ZN7ee17150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee17150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17150[0]),
  0,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17150[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee17150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
extern VTBL_ENTRY _ZTV7ee17150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee17150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee17150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee17150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee17150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee17150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee17150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee17150[] = {
  {&(_ZTV7ee17150[6]),  6,24},
  {&(_ZTV7ee17150[13]),  13,24},
  {&(_ZTV7ee17150[19]),  19,24},
  {&(_ZTV7ee17150[23]),  23,24},
  {&(_tg__ZTV6dd7150__7ee17150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee17150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee17150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee17150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee17150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee17150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17150[];
extern  VTBL_ENTRY _ZTV7ee17150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17150[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17150 = {  "ee17150", // class name
  bases_ee17150, 4,
  &(vtc_ee17150[0]), // expected_vtbl_contents
  &(vtt_ee17150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee17150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17150),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27150  : dd7150 {
  int e;
  virtual void  foo(); // _ZN7ee271503fooEv
  ~ee27150(); // tgen
  ee27150(); // tgen
};
//SIG(1 ee27150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27150 ::foo(){vfunc_called(this, "_ZN7ee271503fooEv");}
ee27150 ::~ee27150(){ note_dtor("ee27150", this);} // tgen
ee27150 ::ee27150(){ note_ctor("ee27150", this);} // tgen

static void Test_ee27150()
{
  extern Class_Descriptor cd_ee27150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee27150, buf);
    ee27150 *dp, &lv = *(dp=new (buf) ee27150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee27150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee27150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee27150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(16,12), "ee27150");
    check_base_class_offset(lv, (dd7150*), 0, "ee27150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27150.e");
    test_class_info(&lv, &cd_ee27150);
    dp->~ee27150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27150(Test_ee27150, "ee27150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee27150C1Ev();
extern void _ZN7ee27150D1Ev();
Name_Map name_map_ee27150[] = {
  NSPAIR(_ZN7ee27150C1Ev),
  NSPAIR(_ZN7ee27150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee27150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27150[];
extern void _ZN6dd71503barEv();
extern void _ZN7ee271503fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN7ee271503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee27150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
extern VTBL_ENTRY _ZTV7ee27150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee27150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee27150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee27150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee27150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee27150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee27150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee27150[] = {
  {&(_ZTV7ee27150[5]),  5,16},
  {&(_tg__ZTV6dd7150__7ee27150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee27150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee27150[4]),  4,5},
  {&(_ZTV7ee27150[11]),  11,16},
  {&(_ZTV7ee27150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee27150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee27150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee27150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee27150[];
extern  VTBL_ENTRY _ZTV7ee27150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27150[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27150 = {  "ee27150", // class name
  bases_ee27150, 4,
  &(vtc_ee27150[0]), // expected_vtbl_contents
  &(vtt_ee27150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee27150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37150  : virtual dd7150 {
  int e;
  virtual void  foo(); // _ZN7ee371503fooEv
  ~ee37150(); // tgen
  ee37150(); // tgen
};
//SIG(1 ee37150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37150 ::foo(){vfunc_called(this, "_ZN7ee371503fooEv");}
ee37150 ::~ee37150(){ note_dtor("ee37150", this);} // tgen
ee37150 ::ee37150(){ note_ctor("ee37150", this);} // tgen

static void Test_ee37150()
{
  extern Class_Descriptor cd_ee37150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee37150, buf);
    ee37150 *dp, &lv = *(dp=new (buf) ee37150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee37150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee37150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee37150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(32,16), "ee37150");
    check_base_class_offset(lv, (dd7150*), ABISELECT(16,8), "ee37150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37150.e");
    test_class_info(&lv, &cd_ee37150);
    dp->~ee37150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37150(Test_ee37150, "ee37150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee37150C1Ev();
extern void _ZN7ee37150D1Ev();
Name_Map name_map_ee37150[] = {
  NSPAIR(_ZN7ee37150C1Ev),
  NSPAIR(_ZN7ee37150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee37150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37150[];
extern void _ZN7ee371503fooEv();
extern void _ZN6dd71503barEv();
extern void ABISELECT(_ZTv0_n56_N7ee371503fooEv,_ZTv0_n28_N7ee371503fooEv)();
extern void ABISELECT(_ZThn16_N7ee371503fooEv,_ZThn8_N7ee371503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37150[0]),
  (VTBL_ENTRY)&_ZN7ee371503fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee371503fooEv,_ZTv0_n28_N7ee371503fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37150[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee37150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
extern VTBL_ENTRY _ZTV7ee37150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee37150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee37150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee37150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee37150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee37150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee37150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee37150[] = {
  {&(_ZTV7ee37150[6]),  6,25},
  {&(_ZTV7ee37150[14]),  14,25},
  {&(_ZTV7ee37150[20]),  20,25},
  {&(_ZTV7ee37150[24]),  24,25},
  {&(_tg__ZTV6dd7150__7ee37150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee37150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee37150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee37150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee37150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee37150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37150[];
extern  VTBL_ENTRY _ZTV7ee37150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37150[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee371503fooEv,_ZTv0_n28_N7ee371503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371503fooEv,_ZThn8_N7ee371503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37150 = {  "ee37150", // class name
  bases_ee37150, 4,
  &(vtc_ee37150[0]), // expected_vtbl_contents
  &(vtt_ee37150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee37150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37150),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47150  : dd7150 {
  int e;
  virtual void  bar(); // _ZN7ee471503barEv
  ~ee47150(); // tgen
  ee47150(); // tgen
};
//SIG(1 ee47150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47150 ::bar(){vfunc_called(this, "_ZN7ee471503barEv");}
ee47150 ::~ee47150(){ note_dtor("ee47150", this);} // tgen
ee47150 ::ee47150(){ note_ctor("ee47150", this);} // tgen

static void Test_ee47150()
{
  extern Class_Descriptor cd_ee47150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee47150, buf);
    ee47150 *dp, &lv = *(dp=new (buf) ee47150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee47150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee47150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee47150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(16,12), "ee47150");
    check_base_class_offset(lv, (dd7150*), 0, "ee47150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47150.e");
    test_class_info(&lv, &cd_ee47150);
    dp->~ee47150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47150(Test_ee47150, "ee47150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee47150C1Ev();
extern void _ZN7ee47150D1Ev();
Name_Map name_map_ee47150[] = {
  NSPAIR(_ZN7ee47150C1Ev),
  NSPAIR(_ZN7ee47150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee47150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47150[];
extern void _ZN7ee471503barEv();
extern void _ZN6dd71503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee471503barEv,_ZTv0_n16_N7ee471503barEv)();
extern void ABISELECT(_ZThn32_N7ee471503barEv,_ZThn20_N7ee471503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47150[0]),
  (VTBL_ENTRY)&_ZN7ee471503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee47150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee471503barEv,_ZTv0_n16_N7ee471503barEv),
};
extern VTBL_ENTRY _ZTV7ee47150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee47150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee47150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee47150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee47150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee47150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee47150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee47150[] = {
  {&(_ZTV7ee47150[5]),  5,16},
  {&(_tg__ZTV6dd7150__7ee47150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee47150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee47150[4]),  4,5},
  {&(_ZTV7ee47150[11]),  11,16},
  {&(_ZTV7ee47150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee47150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee47150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee47150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee47150[];
extern  VTBL_ENTRY _ZTV7ee47150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47150[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee471503barEv,_ZTv0_n16_N7ee471503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee471503barEv,_ZThn20_N7ee471503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47150 = {  "ee47150", // class name
  bases_ee47150, 4,
  &(vtc_ee47150[0]), // expected_vtbl_contents
  &(vtt_ee47150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee47150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57150  : virtual dd7150 {
  int e;
  virtual void  bar(); // _ZN7ee571503barEv
  ~ee57150(); // tgen
  ee57150(); // tgen
};
//SIG(1 ee57150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57150 ::bar(){vfunc_called(this, "_ZN7ee571503barEv");}
ee57150 ::~ee57150(){ note_dtor("ee57150", this);} // tgen
ee57150 ::ee57150(){ note_ctor("ee57150", this);} // tgen

static void Test_ee57150()
{
  extern Class_Descriptor cd_ee57150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee57150, buf);
    ee57150 *dp, &lv = *(dp=new (buf) ee57150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee57150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee57150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee57150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(32,16), "ee57150");
    check_base_class_offset(lv, (dd7150*), ABISELECT(16,8), "ee57150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57150.e");
    test_class_info(&lv, &cd_ee57150);
    dp->~ee57150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57150(Test_ee57150, "ee57150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee57150C1Ev();
extern void _ZN7ee57150D1Ev();
Name_Map name_map_ee57150[] = {
  NSPAIR(_ZN7ee57150C1Ev),
  NSPAIR(_ZN7ee57150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee57150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57150[];
extern void _ZN7ee571503barEv();
extern void ABISELECT(_ZTv0_n48_N7ee571503barEv,_ZTv0_n24_N7ee571503barEv)();
extern void ABISELECT(_ZThn16_N7ee571503barEv,_ZThn8_N7ee571503barEv)() __attribute__((weak));
extern void _ZN6dd71503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee571503barEv,_ZTv0_n16_N7ee571503barEv)();
extern void ABISELECT(_ZThn48_N7ee571503barEv,_ZThn24_N7ee571503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57150[0]),
  (VTBL_ENTRY)&_ZN7ee571503barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee571503barEv,_ZTv0_n24_N7ee571503barEv),
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee57150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee571503barEv,_ZTv0_n16_N7ee571503barEv),
};
extern VTBL_ENTRY _ZTV7ee57150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee57150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee57150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee57150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee57150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee57150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee57150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee57150[] = {
  {&(_ZTV7ee57150[6]),  6,25},
  {&(_ZTV7ee57150[14]),  14,25},
  {&(_ZTV7ee57150[20]),  20,25},
  {&(_ZTV7ee57150[24]),  24,25},
  {&(_tg__ZTV6dd7150__7ee57150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee57150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee57150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee57150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee57150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee57150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57150[];
extern  VTBL_ENTRY _ZTV7ee57150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57150[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee571503barEv,_ZTv0_n16_N7ee571503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee571503barEv,_ZThn24_N7ee571503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee571503barEv,_ZTv0_n24_N7ee571503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571503barEv,_ZThn8_N7ee571503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57150 = {  "ee57150", // class name
  bases_ee57150, 4,
  &(vtc_ee57150[0]), // expected_vtbl_contents
  &(vtt_ee57150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee57150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57150),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67150  : dd7150 {
  int e;
  virtual void  foo(); // _ZN7ee671503fooEv
  virtual void  bar(); // _ZN7ee671503barEv
  ~ee67150(); // tgen
  ee67150(); // tgen
};
//SIG(1 ee67150) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67150 ::foo(){vfunc_called(this, "_ZN7ee671503fooEv");}
void  ee67150 ::bar(){vfunc_called(this, "_ZN7ee671503barEv");}
ee67150 ::~ee67150(){ note_dtor("ee67150", this);} // tgen
ee67150 ::ee67150(){ note_ctor("ee67150", this);} // tgen

static void Test_ee67150()
{
  extern Class_Descriptor cd_ee67150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee67150, buf);
    ee67150 *dp, &lv = *(dp=new (buf) ee67150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee67150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(44,28), "ee67150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(32,20), "ee67150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(16,12), "ee67150");
    check_base_class_offset(lv, (dd7150*), 0, "ee67150");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67150.e");
    test_class_info(&lv, &cd_ee67150);
    dp->~ee67150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67150(Test_ee67150, "ee67150", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee67150C1Ev();
extern void _ZN7ee67150D1Ev();
Name_Map name_map_ee67150[] = {
  NSPAIR(_ZN7ee67150C1Ev),
  NSPAIR(_ZN7ee67150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee67150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67150[];
extern void _ZN7ee671503barEv();
extern void _ZN7ee671503fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee671503barEv,_ZTv0_n16_N7ee671503barEv)();
extern void ABISELECT(_ZThn32_N7ee671503barEv,_ZThn20_N7ee671503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67150[0]),
  (VTBL_ENTRY)&_ZN7ee671503barEv,
  (VTBL_ENTRY)&_ZN7ee671503fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67150[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee67150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee671503barEv,_ZTv0_n16_N7ee671503barEv),
};
extern VTBL_ENTRY _ZTV7ee67150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee67150[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee67150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee67150[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee67150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee67150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee67150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee67150[] = {
  {&(_ZTV7ee67150[5]),  5,16},
  {&(_tg__ZTV6dd7150__7ee67150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee67150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee67150[4]),  4,5},
  {&(_ZTV7ee67150[11]),  11,16},
  {&(_ZTV7ee67150[15]),  15,16},
  {&(_tg__ZTV5cc150__7ee67150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee67150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee67150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee67150[];
extern  VTBL_ENTRY _ZTV7ee67150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67150[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn20_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee671503barEv,_ZTv0_n16_N7ee671503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671503barEv,_ZThn20_N7ee671503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67150 = {  "ee67150", // class name
  bases_ee67150, 4,
  &(vtc_ee67150[0]), // expected_vtbl_contents
  &(vtt_ee67150[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee67150),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67150),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67150),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77150  : virtual dd7150 {
  int e;
  virtual void  foo(); // _ZN7ee771503fooEv
  virtual void  bar(); // _ZN7ee771503barEv
  ~ee77150(); // tgen
  ee77150(); // tgen
};
//SIG(1 ee77150) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77150 ::foo(){vfunc_called(this, "_ZN7ee771503fooEv");}
void  ee77150 ::bar(){vfunc_called(this, "_ZN7ee771503barEv");}
ee77150 ::~ee77150(){ note_dtor("ee77150", this);} // tgen
ee77150 ::ee77150(){ note_ctor("ee77150", this);} // tgen

static void Test_ee77150()
{
  extern Class_Descriptor cd_ee77150;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee77150, buf);
    ee77150 *dp, &lv = *(dp=new (buf) ee77150());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee77150)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77150)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(60,32), "ee77150");
    check_base_class_offset(lv, (bb50*)(cc150*), ABISELECT(48,24), "ee77150");
    check_base_class_offset(lv, (cc150*)(dd7150*), ABISELECT(32,16), "ee77150");
    check_base_class_offset(lv, (dd7150*), ABISELECT(16,8), "ee77150");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77150.e");
    test_class_info(&lv, &cd_ee77150);
    dp->~ee77150();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77150(Test_ee77150, "ee77150", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee77150C1Ev();
extern void _ZN7ee77150D1Ev();
Name_Map name_map_ee77150[] = {
  NSPAIR(_ZN7ee77150C1Ev),
  NSPAIR(_ZN7ee77150D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc150;
extern VTBL_ENTRY _ZTI5cc150[];
extern  VTBL_ENTRY _ZTV5cc150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc150[];
extern Class_Descriptor cd_dd7150;
extern VTBL_ENTRY _ZTI6dd7150[];
extern  VTBL_ENTRY _ZTV6dd7150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7150[];
static Base_Class bases_ee77150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(48,24), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc150,    ABISELECT(32,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7150,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77150[];
extern void _ZN7ee771503fooEv();
extern void _ZN7ee771503barEv();
extern void ABISELECT(_ZTv0_n48_N7ee771503barEv,_ZTv0_n24_N7ee771503barEv)();
extern void ABISELECT(_ZThn16_N7ee771503barEv,_ZThn8_N7ee771503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7ee771503fooEv,_ZTv0_n28_N7ee771503fooEv)();
extern void ABISELECT(_ZThn16_N7ee771503fooEv,_ZThn8_N7ee771503fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee771503barEv,_ZTv0_n16_N7ee771503barEv)();
extern void ABISELECT(_ZThn48_N7ee771503barEv,_ZThn24_N7ee771503barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77150[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77150[0]),
  (VTBL_ENTRY)&_ZN7ee771503fooEv,
  (VTBL_ENTRY)&_ZN7ee771503barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771503barEv,_ZTv0_n24_N7ee771503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee771503fooEv,_ZTv0_n28_N7ee771503fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77150[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee77150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee771503barEv,_ZTv0_n16_N7ee771503barEv),
};
extern VTBL_ENTRY _ZTV7ee77150[];
extern void _ZN6dd71503barEv();
extern void _ZN6dd71503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7150__7ee77150[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&_ZN6dd71503barEv,
  (VTBL_ENTRY)&_ZN6dd71503fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc150__6dd7150__7ee77150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv)();
extern void ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb50__6dd7150__7ee77150[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7150[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc150__7ee77150[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc150__7ee77150[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc150[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__7ee77150[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee77150[] = {
  {&(_ZTV7ee77150[6]),  6,26},
  {&(_ZTV7ee77150[15]),  15,26},
  {&(_ZTV7ee77150[21]),  21,26},
  {&(_ZTV7ee77150[25]),  25,26},
  {&(_tg__ZTV6dd7150__7ee77150[5]),  5,7},
  {&(_tg__ZTV5cc150__6dd7150__7ee77150[4]),  4,4},
  {&(_tg__ZTV4bb50__6dd7150__7ee77150[4]),  4,5},
  {&(_tg__ZTV5cc150__7ee77150[4]),  4,4},
  {&(_tg__ZTV4bb50__5cc150__7ee77150[4]),  4,5},
  {&(_tg__ZTV4bb50__7ee77150[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77150[];
extern  VTBL_ENTRY _ZTV7ee77150[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77150[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71503barEv,_ZTv0_n16_N6dd71503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71503barEv,_ZThn16_N6dd71503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee771503barEv,_ZTv0_n16_N7ee771503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771503barEv,_ZThn24_N7ee771503barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee771503fooEv,_ZTv0_n28_N7ee771503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771503fooEv,_ZThn8_N7ee771503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771503barEv,_ZTv0_n24_N7ee771503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771503barEv,_ZThn8_N7ee771503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77150 = {  "ee77150", // class name
  bases_ee77150, 4,
  &(vtc_ee77150[0]), // expected_vtbl_contents
  &(vtt_ee77150[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee77150),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77150),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77150),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc250  : bb50 {
  int c;
  virtual void  foo(); // _ZN5cc2503fooEv
  ~cc250(); // tgen
  cc250(); // tgen
};
//SIG(-1 cc250) C1{ BC2{ VBC3{ Fi} v2 Fi} v1 Fi}


void  cc250 ::foo(){vfunc_called(this, "_ZN5cc2503fooEv");}
cc250 ::~cc250(){ note_dtor("cc250", this);} // tgen
cc250 ::cc250(){ note_ctor("cc250", this);} // tgen

static void Test_cc250()
{
  extern Class_Descriptor cd_cc250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc250, buf);
    cc250 *dp, &lv = *(dp=new (buf) cc250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc250)");
    check_base_class_offset(lv, (aa0*)(bb50*), ABISELECT(16,12), "cc250");
    check_base_class_offset(lv, (bb50*), 0, "cc250");
    check_field_offset(lv, c, ABISELECT(12,8), "cc250.c");
    test_class_info(&lv, &cd_cc250);
    dp->~cc250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc250(Test_cc250, "cc250", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc250C1Ev();
extern void _ZN5cc250D1Ev();
Name_Map name_map_cc250[] = {
  NSPAIR(_ZN5cc250C1Ev),
  NSPAIR(_ZN5cc250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
static Base_Class bases_cc250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_cc250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV5cc250[];
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb50__5cc250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_cc250[] = {
  {&(_ZTV5cc250[3]),  3,5},
  {&(_tg__ZTV4bb50__5cc250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
Class_Descriptor cd_cc250 = {  "cc250", // class name
  bases_cc250, 2,
  &(vtc_cc250[0]), // expected_vtbl_contents
  &(vtt_cc250[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc250),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc250),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0250  : cc250 {
  int d;
  ~dd0250(); // tgen
  dd0250(); // tgen
};
//SIG(-1 dd0250) C1{ BC2{ BC3{ VBC4{ Fi} v2 Fi} v1 Fi} Fi}


dd0250 ::~dd0250(){ note_dtor("dd0250", this);} // tgen
dd0250 ::dd0250(){ note_ctor("dd0250", this);} // tgen

static void Test_dd0250()
{
  extern Class_Descriptor cd_dd0250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0250, buf);
    dd0250 *dp, &lv = *(dp=new (buf) dd0250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(20,16), "dd0250");
    check_base_class_offset(lv, (bb50*)(cc250*), 0, "dd0250");
    check_base_class_offset(lv, (cc250*), 0, "dd0250");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0250.d");
    test_class_info(&lv, &cd_dd0250);
    dp->~dd0250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0250(Test_dd0250, "dd0250", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0250C1Ev();
extern void _ZN6dd0250D1Ev();
Name_Map name_map_dd0250[] = {
  NSPAIR(_ZN6dd0250C1Ev),
  NSPAIR(_ZN6dd0250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
static Base_Class bases_dd0250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_dd0250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV6dd0250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd0250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__6dd0250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd0250[] = {
  {&(_ZTV6dd0250[3]),  3,5},
  {&(_tg__ZTV5cc250__6dd0250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__6dd0250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
Class_Descriptor cd_dd0250 = {  "dd0250", // class name
  bases_dd0250, 3,
  &(vtc_dd0250[0]), // expected_vtbl_contents
  &(vtt_dd0250[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0250),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0250),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00250  : dd0250 {
  int e;
  ~ee00250(); // tgen
  ee00250(); // tgen
};
//SIG(1 ee00250) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee00250 ::~ee00250(){ note_dtor("ee00250", this);} // tgen
ee00250 ::ee00250(){ note_ctor("ee00250", this);} // tgen

static void Test_ee00250()
{
  extern Class_Descriptor cd_ee00250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00250, buf);
    ee00250 *dp, &lv = *(dp=new (buf) ee00250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(24,20), "ee00250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), 0, "ee00250");
    check_base_class_offset(lv, (cc250*)(dd0250*), 0, "ee00250");
    check_base_class_offset(lv, (dd0250*), 0, "ee00250");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00250.e");
    test_class_info(&lv, &cd_ee00250);
    dp->~ee00250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00250(Test_ee00250, "ee00250", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00250C1Ev();
extern void _ZN7ee00250D1Ev();
Name_Map name_map_ee00250[] = {
  NSPAIR(_ZN7ee00250C1Ev),
  NSPAIR(_ZN7ee00250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee00250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee00250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee00250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee00250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee00250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee00250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee00250[] = {
  {&(_ZTV7ee00250[3]),  3,5},
  {&(_tg__ZTV6dd0250__7ee00250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee00250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee00250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee00250[];
extern  VTBL_ENTRY _ZTV7ee00250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00250[];
Class_Descriptor cd_ee00250 = {  "ee00250", // class name
  bases_ee00250, 4,
  &(vtc_ee00250[0]), // expected_vtbl_contents
  &(vtt_ee00250[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00250),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00250),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10250  : virtual dd0250 {
  int e;
  ~ee10250(); // tgen
  ee10250(); // tgen
};
//SIG(1 ee10250) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee10250 ::~ee10250(){ note_dtor("ee10250", this);} // tgen
ee10250 ::ee10250(){ note_ctor("ee10250", this);} // tgen

static void Test_ee10250()
{
  extern Class_Descriptor cd_ee10250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10250, buf);
    ee10250 *dp, &lv = *(dp=new (buf) ee10250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(36,24), "ee10250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), ABISELECT(16,8), "ee10250");
    check_base_class_offset(lv, (cc250*)(dd0250*), ABISELECT(16,8), "ee10250");
    check_base_class_offset(lv, (dd0250*), ABISELECT(16,8), "ee10250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10250.e");
    test_class_info(&lv, &cd_ee10250);
    dp->~ee10250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10250(Test_ee10250, "ee10250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10250C1Ev();
extern void _ZN7ee10250D1Ev();
Name_Map name_map_ee10250[] = {
  NSPAIR(_ZN7ee10250C1Ev),
  NSPAIR(_ZN7ee10250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee10250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee10250[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10250[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee10250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee10250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee10250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee10250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee10250[] = {
  {&(_ZTV7ee10250[4]),  4,11},
  {&(_ZTV7ee10250[9]),  9,11},
  {&(_tg__ZTV6dd0250__7ee10250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee10250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee10250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10250[];
extern  VTBL_ENTRY _ZTV7ee10250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10250[];
Class_Descriptor cd_ee10250 = {  "ee10250", // class name
  bases_ee10250, 4,
  &(vtc_ee10250[0]), // expected_vtbl_contents
  &(vtt_ee10250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10250),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10250),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20250  : dd0250 {
  int e;
  virtual void  foo(); // _ZN7ee202503fooEv
  ~ee20250(); // tgen
  ee20250(); // tgen
};
//SIG(1 ee20250) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee20250 ::foo(){vfunc_called(this, "_ZN7ee202503fooEv");}
ee20250 ::~ee20250(){ note_dtor("ee20250", this);} // tgen
ee20250 ::ee20250(){ note_ctor("ee20250", this);} // tgen

static void Test_ee20250()
{
  extern Class_Descriptor cd_ee20250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20250, buf);
    ee20250 *dp, &lv = *(dp=new (buf) ee20250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(24,20), "ee20250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), 0, "ee20250");
    check_base_class_offset(lv, (cc250*)(dd0250*), 0, "ee20250");
    check_base_class_offset(lv, (dd0250*), 0, "ee20250");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20250.e");
    test_class_info(&lv, &cd_ee20250);
    dp->~ee20250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20250(Test_ee20250, "ee20250", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20250C1Ev();
extern void _ZN7ee20250D1Ev();
Name_Map name_map_ee20250[] = {
  NSPAIR(_ZN7ee20250C1Ev),
  NSPAIR(_ZN7ee20250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee20250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20250[];
extern void _ZN4bb503barEv();
extern void _ZN7ee202503fooEv();
static  VTBL_ENTRY vtc_ee20250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN7ee202503fooEv,
};
extern VTBL_ENTRY _ZTV7ee20250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee20250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee20250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee20250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee20250[] = {
  {&(_ZTV7ee20250[3]),  3,5},
  {&(_tg__ZTV6dd0250__7ee20250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee20250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee20250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee20250[];
extern  VTBL_ENTRY _ZTV7ee20250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20250[];
Class_Descriptor cd_ee20250 = {  "ee20250", // class name
  bases_ee20250, 4,
  &(vtc_ee20250[0]), // expected_vtbl_contents
  &(vtt_ee20250[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20250),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20250),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30250  : virtual dd0250 {
  int e;
  virtual void  foo(); // _ZN7ee302503fooEv
  ~ee30250(); // tgen
  ee30250(); // tgen
};
//SIG(1 ee30250) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee30250 ::foo(){vfunc_called(this, "_ZN7ee302503fooEv");}
ee30250 ::~ee30250(){ note_dtor("ee30250", this);} // tgen
ee30250 ::ee30250(){ note_ctor("ee30250", this);} // tgen

static void Test_ee30250()
{
  extern Class_Descriptor cd_ee30250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30250, buf);
    ee30250 *dp, &lv = *(dp=new (buf) ee30250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(36,24), "ee30250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), ABISELECT(16,8), "ee30250");
    check_base_class_offset(lv, (cc250*)(dd0250*), ABISELECT(16,8), "ee30250");
    check_base_class_offset(lv, (dd0250*), ABISELECT(16,8), "ee30250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30250.e");
    test_class_info(&lv, &cd_ee30250);
    dp->~ee30250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30250(Test_ee30250, "ee30250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30250C1Ev();
extern void _ZN7ee30250D1Ev();
Name_Map name_map_ee30250[] = {
  NSPAIR(_ZN7ee30250C1Ev),
  NSPAIR(_ZN7ee30250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee30250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30250[];
extern void _ZN7ee302503fooEv();
extern void _ZN4bb503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee302503fooEv,_ZTv0_n20_N7ee302503fooEv)();
extern void ABISELECT(_ZThn16_N7ee302503fooEv,_ZThn8_N7ee302503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30250[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30250[0]),
  (VTBL_ENTRY)&_ZN7ee302503fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee302503fooEv,_ZTv0_n20_N7ee302503fooEv),
};
extern VTBL_ENTRY _ZTV7ee30250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee30250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee30250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee30250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee30250[] = {
  {&(_ZTV7ee30250[4]),  4,12},
  {&(_ZTV7ee30250[10]),  10,12},
  {&(_tg__ZTV6dd0250__7ee30250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee30250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee30250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30250[];
extern  VTBL_ENTRY _ZTV7ee30250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30250[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee302503fooEv,_ZTv0_n20_N7ee302503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302503fooEv,_ZThn8_N7ee302503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30250 = {  "ee30250", // class name
  bases_ee30250, 4,
  &(vtc_ee30250[0]), // expected_vtbl_contents
  &(vtt_ee30250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30250),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30250),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40250  : dd0250 {
  int e;
  virtual void  bar(); // _ZN7ee402503barEv
  ~ee40250(); // tgen
  ee40250(); // tgen
};
//SIG(1 ee40250) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee40250 ::bar(){vfunc_called(this, "_ZN7ee402503barEv");}
ee40250 ::~ee40250(){ note_dtor("ee40250", this);} // tgen
ee40250 ::ee40250(){ note_ctor("ee40250", this);} // tgen

static void Test_ee40250()
{
  extern Class_Descriptor cd_ee40250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40250, buf);
    ee40250 *dp, &lv = *(dp=new (buf) ee40250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(24,20), "ee40250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), 0, "ee40250");
    check_base_class_offset(lv, (cc250*)(dd0250*), 0, "ee40250");
    check_base_class_offset(lv, (dd0250*), 0, "ee40250");
    check_field_offset(lv, e, ABISELECT(20,16), "ee40250.e");
    test_class_info(&lv, &cd_ee40250);
    dp->~ee40250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40250(Test_ee40250, "ee40250", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40250C1Ev();
extern void _ZN7ee40250D1Ev();
Name_Map name_map_ee40250[] = {
  NSPAIR(_ZN7ee40250C1Ev),
  NSPAIR(_ZN7ee40250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee40250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40250[];
extern void _ZN7ee402503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee40250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40250[0]),
  (VTBL_ENTRY)&_ZN7ee402503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee40250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee40250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee40250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee40250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee40250[] = {
  {&(_ZTV7ee40250[3]),  3,5},
  {&(_tg__ZTV6dd0250__7ee40250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee40250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee40250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee40250[];
extern  VTBL_ENTRY _ZTV7ee40250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40250[];
Class_Descriptor cd_ee40250 = {  "ee40250", // class name
  bases_ee40250, 4,
  &(vtc_ee40250[0]), // expected_vtbl_contents
  &(vtt_ee40250[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40250),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40250),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50250  : virtual dd0250 {
  int e;
  virtual void  bar(); // _ZN7ee502503barEv
  ~ee50250(); // tgen
  ee50250(); // tgen
};
//SIG(1 ee50250) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee50250 ::bar(){vfunc_called(this, "_ZN7ee502503barEv");}
ee50250 ::~ee50250(){ note_dtor("ee50250", this);} // tgen
ee50250 ::ee50250(){ note_ctor("ee50250", this);} // tgen

static void Test_ee50250()
{
  extern Class_Descriptor cd_ee50250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50250, buf);
    ee50250 *dp, &lv = *(dp=new (buf) ee50250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(36,24), "ee50250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), ABISELECT(16,8), "ee50250");
    check_base_class_offset(lv, (cc250*)(dd0250*), ABISELECT(16,8), "ee50250");
    check_base_class_offset(lv, (dd0250*), ABISELECT(16,8), "ee50250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50250.e");
    test_class_info(&lv, &cd_ee50250);
    dp->~ee50250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50250(Test_ee50250, "ee50250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50250C1Ev();
extern void _ZN7ee50250D1Ev();
Name_Map name_map_ee50250[] = {
  NSPAIR(_ZN7ee50250C1Ev),
  NSPAIR(_ZN7ee50250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee50250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50250[];
extern void _ZN7ee502503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee502503barEv,_ZTv0_n16_N7ee502503barEv)();
extern void ABISELECT(_ZThn16_N7ee502503barEv,_ZThn8_N7ee502503barEv)() __attribute__((weak));
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee50250[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50250[0]),
  (VTBL_ENTRY)&_ZN7ee502503barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50250[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee502503barEv,_ZTv0_n16_N7ee502503barEv),
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee50250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee50250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee50250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee50250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee50250[] = {
  {&(_ZTV7ee50250[4]),  4,12},
  {&(_ZTV7ee50250[10]),  10,12},
  {&(_tg__ZTV6dd0250__7ee50250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee50250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee50250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50250[];
extern  VTBL_ENTRY _ZTV7ee50250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50250[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee502503barEv,_ZTv0_n16_N7ee502503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee502503barEv,_ZThn8_N7ee502503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50250 = {  "ee50250", // class name
  bases_ee50250, 4,
  &(vtc_ee50250[0]), // expected_vtbl_contents
  &(vtt_ee50250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50250),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50250),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60250  : dd0250 {
  int e;
  virtual void  foo(); // _ZN7ee602503fooEv
  virtual void  bar(); // _ZN7ee602503barEv
  ~ee60250(); // tgen
  ee60250(); // tgen
};
//SIG(1 ee60250) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee60250 ::foo(){vfunc_called(this, "_ZN7ee602503fooEv");}
void  ee60250 ::bar(){vfunc_called(this, "_ZN7ee602503barEv");}
ee60250 ::~ee60250(){ note_dtor("ee60250", this);} // tgen
ee60250 ::ee60250(){ note_ctor("ee60250", this);} // tgen

static void Test_ee60250()
{
  extern Class_Descriptor cd_ee60250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60250, buf);
    ee60250 *dp, &lv = *(dp=new (buf) ee60250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(24,20), "ee60250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), 0, "ee60250");
    check_base_class_offset(lv, (cc250*)(dd0250*), 0, "ee60250");
    check_base_class_offset(lv, (dd0250*), 0, "ee60250");
    check_field_offset(lv, e, ABISELECT(20,16), "ee60250.e");
    test_class_info(&lv, &cd_ee60250);
    dp->~ee60250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60250(Test_ee60250, "ee60250", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60250C1Ev();
extern void _ZN7ee60250D1Ev();
Name_Map name_map_ee60250[] = {
  NSPAIR(_ZN7ee60250C1Ev),
  NSPAIR(_ZN7ee60250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee60250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60250[];
extern void _ZN7ee602503barEv();
extern void _ZN7ee602503fooEv();
static  VTBL_ENTRY vtc_ee60250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60250[0]),
  (VTBL_ENTRY)&_ZN7ee602503barEv,
  (VTBL_ENTRY)&_ZN7ee602503fooEv,
};
extern VTBL_ENTRY _ZTV7ee60250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee60250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee60250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee60250[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee60250[] = {
  {&(_ZTV7ee60250[3]),  3,5},
  {&(_tg__ZTV6dd0250__7ee60250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee60250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee60250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee60250[];
extern  VTBL_ENTRY _ZTV7ee60250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60250[];
Class_Descriptor cd_ee60250 = {  "ee60250", // class name
  bases_ee60250, 4,
  &(vtc_ee60250[0]), // expected_vtbl_contents
  &(vtt_ee60250[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60250),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60250),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70250  : virtual dd0250 {
  int e;
  virtual void  foo(); // _ZN7ee702503fooEv
  virtual void  bar(); // _ZN7ee702503barEv
  ~ee70250(); // tgen
  ee70250(); // tgen
};
//SIG(1 ee70250) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee70250 ::foo(){vfunc_called(this, "_ZN7ee702503fooEv");}
void  ee70250 ::bar(){vfunc_called(this, "_ZN7ee702503barEv");}
ee70250 ::~ee70250(){ note_dtor("ee70250", this);} // tgen
ee70250 ::ee70250(){ note_ctor("ee70250", this);} // tgen

static void Test_ee70250()
{
  extern Class_Descriptor cd_ee70250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70250, buf);
    ee70250 *dp, &lv = *(dp=new (buf) ee70250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd0250*), ABISELECT(36,24), "ee70250");
    check_base_class_offset(lv, (bb50*)(cc250*)(dd0250*), ABISELECT(16,8), "ee70250");
    check_base_class_offset(lv, (cc250*)(dd0250*), ABISELECT(16,8), "ee70250");
    check_base_class_offset(lv, (dd0250*), ABISELECT(16,8), "ee70250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70250.e");
    test_class_info(&lv, &cd_ee70250);
    dp->~ee70250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70250(Test_ee70250, "ee70250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70250C1Ev();
extern void _ZN7ee70250D1Ev();
Name_Map name_map_ee70250[] = {
  NSPAIR(_ZN7ee70250C1Ev),
  NSPAIR(_ZN7ee70250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd0250;
extern VTBL_ENTRY _ZTI6dd0250[];
extern  VTBL_ENTRY _ZTV6dd0250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0250[];
static Base_Class bases_ee70250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0250,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70250[];
extern void _ZN7ee702503fooEv();
extern void _ZN7ee702503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee702503barEv,_ZTv0_n16_N7ee702503barEv)();
extern void ABISELECT(_ZThn16_N7ee702503barEv,_ZThn8_N7ee702503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee702503fooEv,_ZTv0_n20_N7ee702503fooEv)();
extern void ABISELECT(_ZThn16_N7ee702503fooEv,_ZThn8_N7ee702503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70250[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70250[0]),
  (VTBL_ENTRY)&_ZN7ee702503fooEv,
  (VTBL_ENTRY)&_ZN7ee702503barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70250[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee702503barEv,_ZTv0_n16_N7ee702503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee702503fooEv,_ZTv0_n20_N7ee702503fooEv),
};
extern VTBL_ENTRY _ZTV7ee70250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0250__7ee70250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2506dd0250__7ee70250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc2506dd0250__7ee70250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee70250[] = {
  {&(_ZTV7ee70250[4]),  4,13},
  {&(_ZTV7ee70250[11]),  11,13},
  {&(_tg__ZTV6dd0250__7ee70250[3]),  3,5},
  {&(_tg__ZTV5cc2506dd0250__7ee70250[3]),  3,5},
  {&(_tg__ZTV4bb505cc2506dd0250__7ee70250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70250[];
extern  VTBL_ENTRY _ZTV7ee70250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70250[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee702503fooEv,_ZTv0_n20_N7ee702503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702503fooEv,_ZThn8_N7ee702503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee702503barEv,_ZTv0_n16_N7ee702503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702503barEv,_ZThn8_N7ee702503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70250 = {  "ee70250", // class name
  bases_ee70250, 4,
  &(vtc_ee70250[0]), // expected_vtbl_contents
  &(vtt_ee70250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70250),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70250),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1250  : virtual cc250 {
  int d;
  ~dd1250(); // tgen
  dd1250(); // tgen
};
//SIG(-1 dd1250) C1{ VBC2{ BC3{ VBC4{ Fi} v2 Fi} v1 Fi} Fi}


dd1250 ::~dd1250(){ note_dtor("dd1250", this);} // tgen
dd1250 ::dd1250(){ note_ctor("dd1250", this);} // tgen

static void Test_dd1250()
{
  extern Class_Descriptor cd_dd1250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1250, buf);
    dd1250 *dp, &lv = *(dp=new (buf) dd1250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(32,20), "dd1250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(16,8), "dd1250");
    check_base_class_offset(lv, (cc250*), ABISELECT(16,8), "dd1250");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1250.d");
    test_class_info(&lv, &cd_dd1250);
    dp->~dd1250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1250(Test_dd1250, "dd1250", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1250C1Ev();
extern void _ZN6dd1250D1Ev();
Name_Map name_map_dd1250[] = {
  NSPAIR(_ZN6dd1250C1Ev),
  NSPAIR(_ZN6dd1250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
static Base_Class bases_dd1250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_dd1250[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV6dd1250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__6dd1250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd1250[] = {
  {&(_ZTV6dd1250[4]),  4,11},
  {&(_ZTV6dd1250[9]),  9,11},
  {&(_tg__ZTV5cc250__6dd1250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__6dd1250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
Class_Descriptor cd_dd1250 = {  "dd1250", // class name
  bases_dd1250, 3,
  &(vtc_dd1250[0]), // expected_vtbl_contents
  &(vtt_dd1250[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1250),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1250),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01250  : dd1250 {
  int e;
  ~ee01250(); // tgen
  ee01250(); // tgen
};
//SIG(1 ee01250) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee01250 ::~ee01250(){ note_dtor("ee01250", this);} // tgen
ee01250 ::ee01250(){ note_ctor("ee01250", this);} // tgen

static void Test_ee01250()
{
  extern Class_Descriptor cd_ee01250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01250, buf);
    ee01250 *dp, &lv = *(dp=new (buf) ee01250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(32,24), "ee01250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(16,12), "ee01250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(16,12), "ee01250");
    check_base_class_offset(lv, (dd1250*), 0, "ee01250");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01250.e");
    test_class_info(&lv, &cd_ee01250);
    dp->~ee01250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01250(Test_ee01250, "ee01250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01250C1Ev();
extern void _ZN7ee01250D1Ev();
Name_Map name_map_ee01250[] = {
  NSPAIR(_ZN7ee01250C1Ev),
  NSPAIR(_ZN7ee01250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee01250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee01250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01250[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee01250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee01250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee01250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee01250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee01250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee01250[] = {
  {&(_ZTV7ee01250[4]),  4,11},
  {&(_tg__ZTV6dd1250__7ee01250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee01250[5]),  5,7},
  {&(_ZTV7ee01250[9]),  9,11},
  {&(_tg__ZTV5cc250__7ee01250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee01250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01250[];
extern  VTBL_ENTRY _ZTV7ee01250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01250[];
Class_Descriptor cd_ee01250 = {  "ee01250", // class name
  bases_ee01250, 4,
  &(vtc_ee01250[0]), // expected_vtbl_contents
  &(vtt_ee01250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01250),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01250),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11250  : virtual dd1250 {
  int e;
  ~ee11250(); // tgen
  ee11250(); // tgen
};
//SIG(1 ee11250) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee11250 ::~ee11250(){ note_dtor("ee11250", this);} // tgen
ee11250 ::ee11250(){ note_ctor("ee11250", this);} // tgen

static void Test_ee11250()
{
  extern Class_Descriptor cd_ee11250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11250, buf);
    ee11250 *dp, &lv = *(dp=new (buf) ee11250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(48,28), "ee11250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(32,16), "ee11250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(32,16), "ee11250");
    check_base_class_offset(lv, (dd1250*), ABISELECT(16,8), "ee11250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11250.e");
    test_class_info(&lv, &cd_ee11250);
    dp->~ee11250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11250(Test_ee11250, "ee11250", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11250C1Ev();
extern void _ZN7ee11250D1Ev();
Name_Map name_map_ee11250[] = {
  NSPAIR(_ZN7ee11250C1Ev),
  NSPAIR(_ZN7ee11250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee11250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee11250[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11250[0]),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11250[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee11250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee11250[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee11250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee11250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee11250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee11250[] = {
  {&(_ZTV7ee11250[5]),  5,16},
  {&(_ZTV7ee11250[9]),  9,16},
  {&(_ZTV7ee11250[14]),  14,16},
  {&(_tg__ZTV6dd1250__7ee11250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee11250[5]),  5,7},
  {&(_tg__ZTV5cc250__7ee11250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee11250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11250[];
extern  VTBL_ENTRY _ZTV7ee11250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11250[];
Class_Descriptor cd_ee11250 = {  "ee11250", // class name
  bases_ee11250, 4,
  &(vtc_ee11250[0]), // expected_vtbl_contents
  &(vtt_ee11250[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11250),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11250),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21250  : dd1250 {
  int e;
  virtual void  foo(); // _ZN7ee212503fooEv
  ~ee21250(); // tgen
  ee21250(); // tgen
};
//SIG(1 ee21250) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee21250 ::foo(){vfunc_called(this, "_ZN7ee212503fooEv");}
ee21250 ::~ee21250(){ note_dtor("ee21250", this);} // tgen
ee21250 ::ee21250(){ note_ctor("ee21250", this);} // tgen

static void Test_ee21250()
{
  extern Class_Descriptor cd_ee21250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21250, buf);
    ee21250 *dp, &lv = *(dp=new (buf) ee21250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(32,24), "ee21250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(16,12), "ee21250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(16,12), "ee21250");
    check_base_class_offset(lv, (dd1250*), 0, "ee21250");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21250.e");
    test_class_info(&lv, &cd_ee21250);
    dp->~ee21250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21250(Test_ee21250, "ee21250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21250C1Ev();
extern void _ZN7ee21250D1Ev();
Name_Map name_map_ee21250[] = {
  NSPAIR(_ZN7ee21250C1Ev),
  NSPAIR(_ZN7ee21250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee21250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21250[];
extern void _ZN7ee212503fooEv();
extern void _ZN4bb503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee212503fooEv,_ZTv0_n20_N7ee212503fooEv)();
extern void ABISELECT(_ZThn16_N7ee212503fooEv,_ZThn12_N7ee212503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21250[0]),
  (VTBL_ENTRY)&_ZN7ee212503fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee212503fooEv,_ZTv0_n20_N7ee212503fooEv),
};
extern VTBL_ENTRY _ZTV7ee21250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee21250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee21250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee21250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee21250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee21250[] = {
  {&(_ZTV7ee21250[4]),  4,12},
  {&(_tg__ZTV6dd1250__7ee21250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee21250[5]),  5,7},
  {&(_ZTV7ee21250[10]),  10,12},
  {&(_tg__ZTV5cc250__7ee21250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee21250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21250[];
extern  VTBL_ENTRY _ZTV7ee21250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21250[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee212503fooEv,_ZTv0_n20_N7ee212503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee212503fooEv,_ZThn12_N7ee212503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21250 = {  "ee21250", // class name
  bases_ee21250, 4,
  &(vtc_ee21250[0]), // expected_vtbl_contents
  &(vtt_ee21250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21250),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21250),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31250  : virtual dd1250 {
  int e;
  virtual void  foo(); // _ZN7ee312503fooEv
  ~ee31250(); // tgen
  ee31250(); // tgen
};
//SIG(1 ee31250) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee31250 ::foo(){vfunc_called(this, "_ZN7ee312503fooEv");}
ee31250 ::~ee31250(){ note_dtor("ee31250", this);} // tgen
ee31250 ::ee31250(){ note_ctor("ee31250", this);} // tgen

static void Test_ee31250()
{
  extern Class_Descriptor cd_ee31250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31250, buf);
    ee31250 *dp, &lv = *(dp=new (buf) ee31250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(48,28), "ee31250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(32,16), "ee31250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(32,16), "ee31250");
    check_base_class_offset(lv, (dd1250*), ABISELECT(16,8), "ee31250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31250.e");
    test_class_info(&lv, &cd_ee31250);
    dp->~ee31250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31250(Test_ee31250, "ee31250", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31250C1Ev();
extern void _ZN7ee31250D1Ev();
Name_Map name_map_ee31250[] = {
  NSPAIR(_ZN7ee31250C1Ev),
  NSPAIR(_ZN7ee31250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee31250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31250[];
extern void _ZN7ee312503fooEv();
extern void _ZN4bb503barEv();
extern void ABISELECT(_ZTv0_n40_N7ee312503fooEv,_ZTv0_n20_N7ee312503fooEv)();
extern void ABISELECT(_ZThn32_N7ee312503fooEv,_ZThn16_N7ee312503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31250[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31250[0]),
  (VTBL_ENTRY)&_ZN7ee312503fooEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31250[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee312503fooEv,_ZTv0_n20_N7ee312503fooEv),
};
extern VTBL_ENTRY _ZTV7ee31250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee31250[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee31250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee31250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee31250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee31250[] = {
  {&(_ZTV7ee31250[5]),  5,17},
  {&(_ZTV7ee31250[10]),  10,17},
  {&(_ZTV7ee31250[15]),  15,17},
  {&(_tg__ZTV6dd1250__7ee31250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee31250[5]),  5,7},
  {&(_tg__ZTV5cc250__7ee31250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee31250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31250[];
extern  VTBL_ENTRY _ZTV7ee31250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31250[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee312503fooEv,_ZTv0_n20_N7ee312503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee312503fooEv,_ZThn16_N7ee312503fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31250 = {  "ee31250", // class name
  bases_ee31250, 4,
  &(vtc_ee31250[0]), // expected_vtbl_contents
  &(vtt_ee31250[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31250),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31250),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41250  : dd1250 {
  int e;
  virtual void  bar(); // _ZN7ee412503barEv
  ~ee41250(); // tgen
  ee41250(); // tgen
};
//SIG(1 ee41250) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee41250 ::bar(){vfunc_called(this, "_ZN7ee412503barEv");}
ee41250 ::~ee41250(){ note_dtor("ee41250", this);} // tgen
ee41250 ::ee41250(){ note_ctor("ee41250", this);} // tgen

static void Test_ee41250()
{
  extern Class_Descriptor cd_ee41250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41250, buf);
    ee41250 *dp, &lv = *(dp=new (buf) ee41250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(32,24), "ee41250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(16,12), "ee41250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(16,12), "ee41250");
    check_base_class_offset(lv, (dd1250*), 0, "ee41250");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41250.e");
    test_class_info(&lv, &cd_ee41250);
    dp->~ee41250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41250(Test_ee41250, "ee41250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41250C1Ev();
extern void _ZN7ee41250D1Ev();
Name_Map name_map_ee41250[] = {
  NSPAIR(_ZN7ee41250C1Ev),
  NSPAIR(_ZN7ee41250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee41250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41250[];
extern void _ZN7ee412503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee412503barEv,_ZTv0_n16_N7ee412503barEv)();
extern void ABISELECT(_ZThn16_N7ee412503barEv,_ZThn12_N7ee412503barEv)() __attribute__((weak));
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee41250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41250[0]),
  (VTBL_ENTRY)&_ZN7ee412503barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41250[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee412503barEv,_ZTv0_n16_N7ee412503barEv),
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee41250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee41250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee41250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee41250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee41250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee41250[] = {
  {&(_ZTV7ee41250[4]),  4,12},
  {&(_tg__ZTV6dd1250__7ee41250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee41250[5]),  5,7},
  {&(_ZTV7ee41250[10]),  10,12},
  {&(_tg__ZTV5cc250__7ee41250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee41250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41250[];
extern  VTBL_ENTRY _ZTV7ee41250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41250[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee412503barEv,_ZTv0_n16_N7ee412503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee412503barEv,_ZThn12_N7ee412503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41250 = {  "ee41250", // class name
  bases_ee41250, 4,
  &(vtc_ee41250[0]), // expected_vtbl_contents
  &(vtt_ee41250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41250),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41250),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51250  : virtual dd1250 {
  int e;
  virtual void  bar(); // _ZN7ee512503barEv
  ~ee51250(); // tgen
  ee51250(); // tgen
};
//SIG(1 ee51250) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee51250 ::bar(){vfunc_called(this, "_ZN7ee512503barEv");}
ee51250 ::~ee51250(){ note_dtor("ee51250", this);} // tgen
ee51250 ::ee51250(){ note_ctor("ee51250", this);} // tgen

static void Test_ee51250()
{
  extern Class_Descriptor cd_ee51250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51250, buf);
    ee51250 *dp, &lv = *(dp=new (buf) ee51250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(48,28), "ee51250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(32,16), "ee51250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(32,16), "ee51250");
    check_base_class_offset(lv, (dd1250*), ABISELECT(16,8), "ee51250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51250.e");
    test_class_info(&lv, &cd_ee51250);
    dp->~ee51250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51250(Test_ee51250, "ee51250", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51250C1Ev();
extern void _ZN7ee51250D1Ev();
Name_Map name_map_ee51250[] = {
  NSPAIR(_ZN7ee51250C1Ev),
  NSPAIR(_ZN7ee51250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee51250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51250[];
extern void _ZN7ee512503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee512503barEv,_ZTv0_n16_N7ee512503barEv)();
extern void ABISELECT(_ZThn32_N7ee512503barEv,_ZThn16_N7ee512503barEv)() __attribute__((weak));
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY vtc_ee51250[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51250[0]),
  (VTBL_ENTRY)&_ZN7ee512503barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51250[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51250[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee512503barEv,_ZTv0_n16_N7ee512503barEv),
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern VTBL_ENTRY _ZTV7ee51250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee51250[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee51250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee51250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee51250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee51250[] = {
  {&(_ZTV7ee51250[5]),  5,17},
  {&(_ZTV7ee51250[10]),  10,17},
  {&(_ZTV7ee51250[15]),  15,17},
  {&(_tg__ZTV6dd1250__7ee51250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee51250[5]),  5,7},
  {&(_tg__ZTV5cc250__7ee51250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee51250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51250[];
extern  VTBL_ENTRY _ZTV7ee51250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51250[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee512503barEv,_ZTv0_n16_N7ee512503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee512503barEv,_ZThn16_N7ee512503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51250 = {  "ee51250", // class name
  bases_ee51250, 4,
  &(vtc_ee51250[0]), // expected_vtbl_contents
  &(vtt_ee51250[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51250),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51250),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61250  : dd1250 {
  int e;
  virtual void  foo(); // _ZN7ee612503fooEv
  virtual void  bar(); // _ZN7ee612503barEv
  ~ee61250(); // tgen
  ee61250(); // tgen
};
//SIG(1 ee61250) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee61250 ::foo(){vfunc_called(this, "_ZN7ee612503fooEv");}
void  ee61250 ::bar(){vfunc_called(this, "_ZN7ee612503barEv");}
ee61250 ::~ee61250(){ note_dtor("ee61250", this);} // tgen
ee61250 ::ee61250(){ note_ctor("ee61250", this);} // tgen

static void Test_ee61250()
{
  extern Class_Descriptor cd_ee61250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61250, buf);
    ee61250 *dp, &lv = *(dp=new (buf) ee61250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(32,24), "ee61250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(16,12), "ee61250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(16,12), "ee61250");
    check_base_class_offset(lv, (dd1250*), 0, "ee61250");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61250.e");
    test_class_info(&lv, &cd_ee61250);
    dp->~ee61250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61250(Test_ee61250, "ee61250", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61250C1Ev();
extern void _ZN7ee61250D1Ev();
Name_Map name_map_ee61250[] = {
  NSPAIR(_ZN7ee61250C1Ev),
  NSPAIR(_ZN7ee61250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee61250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61250[];
extern void _ZN7ee612503fooEv();
extern void _ZN7ee612503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee612503barEv,_ZTv0_n16_N7ee612503barEv)();
extern void ABISELECT(_ZThn16_N7ee612503barEv,_ZThn12_N7ee612503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee612503fooEv,_ZTv0_n20_N7ee612503fooEv)();
extern void ABISELECT(_ZThn16_N7ee612503fooEv,_ZThn12_N7ee612503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61250[0]),
  (VTBL_ENTRY)&_ZN7ee612503fooEv,
  (VTBL_ENTRY)&_ZN7ee612503barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61250[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee612503barEv,_ZTv0_n16_N7ee612503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee612503fooEv,_ZTv0_n20_N7ee612503fooEv),
};
extern VTBL_ENTRY _ZTV7ee61250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee61250[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee61250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee61250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee61250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee61250[] = {
  {&(_ZTV7ee61250[4]),  4,13},
  {&(_tg__ZTV6dd1250__7ee61250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee61250[5]),  5,7},
  {&(_ZTV7ee61250[11]),  11,13},
  {&(_tg__ZTV5cc250__7ee61250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee61250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61250[];
extern  VTBL_ENTRY _ZTV7ee61250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61250[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee612503fooEv,_ZTv0_n20_N7ee612503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612503fooEv,_ZThn12_N7ee612503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee612503barEv,_ZTv0_n16_N7ee612503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612503barEv,_ZThn12_N7ee612503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61250 = {  "ee61250", // class name
  bases_ee61250, 4,
  &(vtc_ee61250[0]), // expected_vtbl_contents
  &(vtt_ee61250[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61250),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61250),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71250  : virtual dd1250 {
  int e;
  virtual void  foo(); // _ZN7ee712503fooEv
  virtual void  bar(); // _ZN7ee712503barEv
  ~ee71250(); // tgen
  ee71250(); // tgen
};
//SIG(1 ee71250) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee71250 ::foo(){vfunc_called(this, "_ZN7ee712503fooEv");}
void  ee71250 ::bar(){vfunc_called(this, "_ZN7ee712503barEv");}
ee71250 ::~ee71250(){ note_dtor("ee71250", this);} // tgen
ee71250 ::ee71250(){ note_ctor("ee71250", this);} // tgen

static void Test_ee71250()
{
  extern Class_Descriptor cd_ee71250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71250, buf);
    ee71250 *dp, &lv = *(dp=new (buf) ee71250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(48,28), "ee71250");
    check_base_class_offset(lv, (bb50*)(cc250*), ABISELECT(32,16), "ee71250");
    check_base_class_offset(lv, (cc250*)(dd1250*), ABISELECT(32,16), "ee71250");
    check_base_class_offset(lv, (dd1250*), ABISELECT(16,8), "ee71250");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71250.e");
    test_class_info(&lv, &cd_ee71250);
    dp->~ee71250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71250(Test_ee71250, "ee71250", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71250C1Ev();
extern void _ZN7ee71250D1Ev();
Name_Map name_map_ee71250[] = {
  NSPAIR(_ZN7ee71250C1Ev),
  NSPAIR(_ZN7ee71250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
extern Class_Descriptor cd_dd1250;
extern VTBL_ENTRY _ZTI6dd1250[];
extern  VTBL_ENTRY _ZTV6dd1250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1250[];
static Base_Class bases_ee71250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1250,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71250[];
extern void _ZN7ee712503fooEv();
extern void _ZN7ee712503barEv();
extern void ABISELECT(_ZTv0_n32_N7ee712503barEv,_ZTv0_n16_N7ee712503barEv)();
extern void ABISELECT(_ZThn32_N7ee712503barEv,_ZThn16_N7ee712503barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee712503fooEv,_ZTv0_n20_N7ee712503fooEv)();
extern void ABISELECT(_ZThn32_N7ee712503fooEv,_ZThn16_N7ee712503fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71250[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71250[0]),
  (VTBL_ENTRY)&_ZN7ee712503fooEv,
  (VTBL_ENTRY)&_ZN7ee712503barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71250[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71250[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee712503barEv,_ZTv0_n16_N7ee712503barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee712503fooEv,_ZTv0_n20_N7ee712503fooEv),
};
extern VTBL_ENTRY _ZTV7ee71250[];
static  VTBL_ENTRY _tg__ZTV6dd1250__7ee71250[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd1250__7ee71250[] = {
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__7ee71250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__7ee71250[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_ee71250[] = {
  {&(_ZTV7ee71250[5]),  5,18},
  {&(_ZTV7ee71250[11]),  11,18},
  {&(_ZTV7ee71250[16]),  16,18},
  {&(_tg__ZTV6dd1250__7ee71250[4]),  4,4},
  {&(_tg__ZTV5cc250__6dd1250__7ee71250[5]),  5,7},
  {&(_tg__ZTV5cc250__7ee71250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__7ee71250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71250[];
extern  VTBL_ENTRY _ZTV7ee71250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71250[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee712503fooEv,_ZTv0_n20_N7ee712503fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712503fooEv,_ZThn16_N7ee712503fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee712503barEv,_ZTv0_n16_N7ee712503barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712503barEv,_ZThn16_N7ee712503barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71250 = {  "ee71250", // class name
  bases_ee71250, 4,
  &(vtc_ee71250[0]), // expected_vtbl_contents
  &(vtt_ee71250[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71250),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71250),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71250),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2250  : cc250 {
  int d;
  virtual void  foo(); // _ZN6dd22503fooEv
  ~dd2250(); // tgen
  dd2250(); // tgen
};
//SIG(-1 dd2250) C1{ BC2{ BC3{ VBC4{ Fi} v2 Fi} v1 Fi} v1 Fi}


void  dd2250 ::foo(){vfunc_called(this, "_ZN6dd22503fooEv");}
dd2250 ::~dd2250(){ note_dtor("dd2250", this);} // tgen
dd2250 ::dd2250(){ note_ctor("dd2250", this);} // tgen

static void Test_dd2250()
{
  extern Class_Descriptor cd_dd2250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2250, buf);
    dd2250 *dp, &lv = *(dp=new (buf) dd2250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*), ABISELECT(20,16), "dd2250");
    check_base_class_offset(lv, (bb50*)(cc250*), 0, "dd2250");
    check_base_class_offset(lv, (cc250*), 0, "dd2250");
    check_field_offset(lv, d, ABISELECT(16,12), "dd2250.d");
    test_class_info(&lv, &cd_dd2250);
    dp->~dd2250();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2250(Test_dd2250, "dd2250", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2250C1Ev();
extern void _ZN6dd2250D1Ev();
Name_Map name_map_dd2250[] = {
  NSPAIR(_ZN6dd2250C1Ev),
  NSPAIR(_ZN6dd2250D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb50;
extern VTBL_ENTRY _ZTI4bb50[];
extern  VTBL_ENTRY _ZTV4bb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb50[];
extern Class_Descriptor cd_cc250;
extern VTBL_ENTRY _ZTI5cc250[];
extern  VTBL_ENTRY _ZTV5cc250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc250[];
static Base_Class bases_dd2250[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc250,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2250[];
extern void _ZN4bb503barEv();
extern void _ZN6dd22503fooEv();
static  VTBL_ENTRY vtc_dd2250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN6dd22503fooEv,
};
extern VTBL_ENTRY _ZTV6dd2250[];
extern void _ZN4bb503barEv();
extern void _ZN5cc2503fooEv();
static  VTBL_ENTRY _tg__ZTV5cc250__6dd2250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc250[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
  (VTBL_ENTRY)&_ZN5cc2503fooEv,
};
extern void _ZN4bb503barEv();
static  VTBL_ENTRY _tg__ZTV4bb505cc250__6dd2250[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb50[0]),
  (VTBL_ENTRY)&_ZN4bb503barEv,
};
static  VTT_ENTRY vtt_dd2250[] = {
  {&(_ZTV6dd2250[3]),  3,5},
  {&(_tg__ZTV5cc250__6dd2250[3]),  3,5},
  {&(_tg__ZTV4bb505cc250__6dd2250[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd2250[];
extern  VTBL_ENTRY _ZTV6dd2250[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2250[];
Class_Descriptor cd_dd2250 = {  "dd2250", // class name
  bases_dd2250, 3,
  &(vtc_dd2250[0]), // expected_vtbl_contents
  &(vtt_dd2250[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2250),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2250),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2250),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02250  : dd2250 {
  int e;
  ~ee02250(); // tgen
  ee02250(); // tgen
};
//SIG(1 ee02250) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v1 Fi} v1 Fi} Fi}


ee02250 ::~ee02250(){ note_dtor("ee02250", this);} // tgen
ee02250 ::ee02250(){ note_ctor("ee02250", this);} // tgen

static void Test_ee02250()
{
  extern Class_Descriptor cd_ee02250;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02250, buf);
    ee02250 *dp, &lv = *(dp=new (buf) ee02250());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02250)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02250)");
    check_base_class_offset(lv, (aa0*)(bb50*)(cc250*)(dd2250*), ABISELECT(24,20), "ee02250");
  