// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb40  : aa0 {
  int b;
  virtual void  bar(); // _ZN4bb403barEv
  ~bb40(); // tgen
  bb40(); // tgen
};
//SIG(-1 bb40) C1{ BC2{ Fi} v1 Fi}


void  bb40 ::bar(){vfunc_called(this, "_ZN4bb403barEv");}
bb40 ::~bb40(){ note_dtor("bb40", this);} // tgen
bb40 ::bb40(){ note_ctor("bb40", this);} // tgen

static void Test_bb40()
{
  extern Class_Descriptor cd_bb40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_bb40, buf);
    bb40 *dp, &lv = *(dp=new (buf) bb40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(bb40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb40)");
    check_base_class_offset(lv, (aa0*), ABISELECT(8,4), "bb40");
    check_field_offset(lv, b, ABISELECT(12,8), "bb40.b");
    test_class_info(&lv, &cd_bb40);
    dp->~bb40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb40(Test_bb40, "bb40", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN4bb40C1Ev();
extern void _ZN4bb40D1Ev();
Name_Map name_map_bb40[] = {
  NSPAIR(_ZN4bb40C1Ev),
  NSPAIR(_ZN4bb40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4bb40[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_bb40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb40[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
Class_Descriptor cd_bb40 = {  "bb40", // class name
  bases_bb40, 1,
  &(vtc_bb40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI4bb40),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4bb40),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc040  : bb40 {
  int c;
  ~cc040(); // tgen
  cc040(); // tgen
};
//SIG(-1 cc040) C1{ BC2{ BC3{ Fi} v1 Fi} Fi}


cc040 ::~cc040(){ note_dtor("cc040", this);} // tgen
cc040 ::cc040(){ note_ctor("cc040", this);} // tgen

static void Test_cc040()
{
  extern Class_Descriptor cd_cc040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc040, buf);
    cc040 *dp, &lv = *(dp=new (buf) cc040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc040)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(8,4), "cc040");
    check_base_class_offset(lv, (bb40*), 0, "cc040");
    check_field_offset(lv, c, ABISELECT(16,12), "cc040.c");
    test_class_info(&lv, &cd_cc040);
    dp->~cc040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc040(Test_cc040, "cc040", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc040C1Ev();
extern void _ZN5cc040D1Ev();
Name_Map name_map_cc040[] = {
  NSPAIR(_ZN5cc040C1Ev),
  NSPAIR(_ZN5cc040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
static Base_Class bases_cc040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc040[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_cc040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5cc040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
Class_Descriptor cd_cc040 = {  "cc040", // class name
  bases_cc040, 2,
  &(vtc_cc040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc040),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0040  : cc040 {
  int d;
  ~dd0040(); // tgen
  dd0040(); // tgen
};
//SIG(-1 dd0040) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd0040 ::~dd0040(){ note_dtor("dd0040", this);} // tgen
dd0040 ::dd0040(){ note_ctor("dd0040", this);} // tgen

static void Test_dd0040()
{
  extern Class_Descriptor cd_dd0040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0040, buf);
    dd0040 *dp, &lv = *(dp=new (buf) dd0040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(8,4), "dd0040");
    check_base_class_offset(lv, (bb40*)(cc040*), 0, "dd0040");
    check_base_class_offset(lv, (cc040*), 0, "dd0040");
    check_field_offset(lv, d, ABISELECT(20,16), "dd0040.d");
    test_class_info(&lv, &cd_dd0040);
    dp->~dd0040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0040(Test_dd0040, "dd0040", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0040C1Ev();
extern void _ZN6dd0040D1Ev();
Name_Map name_map_dd0040[] = {
  NSPAIR(_ZN6dd0040C1Ev),
  NSPAIR(_ZN6dd0040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd0040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0040[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_dd0040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd0040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
Class_Descriptor cd_dd0040 = {  "dd0040", // class name
  bases_dd0040, 3,
  &(vtc_dd0040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0040),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00040  : dd0040 {
  int e;
  ~ee00040(); // tgen
  ee00040(); // tgen
};
//SIG(1 ee00040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00040 ::~ee00040(){ note_dtor("ee00040", this);} // tgen
ee00040 ::ee00040(){ note_ctor("ee00040", this);} // tgen

static void Test_ee00040()
{
  extern Class_Descriptor cd_ee00040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00040, buf);
    ee00040 *dp, &lv = *(dp=new (buf) ee00040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(8,4), "ee00040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), 0, "ee00040");
    check_base_class_offset(lv, (cc040*)(dd0040*), 0, "ee00040");
    check_base_class_offset(lv, (dd0040*), 0, "ee00040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee00040.e");
    test_class_info(&lv, &cd_ee00040);
    dp->~ee00040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00040(Test_ee00040, "ee00040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00040C1Ev();
extern void _ZN7ee00040D1Ev();
Name_Map name_map_ee00040[] = {
  NSPAIR(_ZN7ee00040C1Ev),
  NSPAIR(_ZN7ee00040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee00040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00040[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee00040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee00040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTI7ee00040[];
extern  VTBL_ENTRY _ZTV7ee00040[];
Class_Descriptor cd_ee00040 = {  "ee00040", // class name
  bases_ee00040, 4,
  &(vtc_ee00040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00040),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10040  : virtual dd0040 {
  int e;
  ~ee10040(); // tgen
  ee10040(); // tgen
};
//SIG(1 ee10040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10040 ::~ee10040(){ note_dtor("ee10040", this);} // tgen
ee10040 ::ee10040(){ note_ctor("ee10040", this);} // tgen

static void Test_ee10040()
{
  extern Class_Descriptor cd_ee10040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10040, buf);
    ee10040 *dp, &lv = *(dp=new (buf) ee10040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(24,12), "ee10040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), ABISELECT(16,8), "ee10040");
    check_base_class_offset(lv, (cc040*)(dd0040*), ABISELECT(16,8), "ee10040");
    check_base_class_offset(lv, (dd0040*), ABISELECT(16,8), "ee10040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10040.e");
    test_class_info(&lv, &cd_ee10040);
    dp->~ee10040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10040(Test_ee10040, "ee10040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10040C1Ev();
extern void _ZN7ee10040D1Ev();
Name_Map name_map_ee10040[] = {
  NSPAIR(_ZN7ee10040C1Ev),
  NSPAIR(_ZN7ee10040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee10040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10040[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee10040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10040[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee10040[];
static  VTT_ENTRY vtt_ee10040[] = {
  {&(_ZTV7ee10040[3]),  3,7},
  {&(_ZTV7ee10040[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee10040[];
extern  VTBL_ENTRY _ZTV7ee10040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10040[];
Class_Descriptor cd_ee10040 = {  "ee10040", // class name
  bases_ee10040, 4,
  &(vtc_ee10040[0]), // expected_vtbl_contents
  &(vtt_ee10040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10040),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20040  : dd0040 {
  int e;
  virtual void  foo(); // _ZN7ee200403fooEv
  ~ee20040(); // tgen
  ee20040(); // tgen
};
//SIG(1 ee20040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee20040 ::foo(){vfunc_called(this, "_ZN7ee200403fooEv");}
ee20040 ::~ee20040(){ note_dtor("ee20040", this);} // tgen
ee20040 ::ee20040(){ note_ctor("ee20040", this);} // tgen

static void Test_ee20040()
{
  extern Class_Descriptor cd_ee20040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20040, buf);
    ee20040 *dp, &lv = *(dp=new (buf) ee20040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(8,4), "ee20040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), 0, "ee20040");
    check_base_class_offset(lv, (cc040*)(dd0040*), 0, "ee20040");
    check_base_class_offset(lv, (dd0040*), 0, "ee20040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20040.e");
    test_class_info(&lv, &cd_ee20040);
    dp->~ee20040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20040(Test_ee20040, "ee20040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20040C1Ev();
extern void _ZN7ee20040D1Ev();
Name_Map name_map_ee20040[] = {
  NSPAIR(_ZN7ee20040C1Ev),
  NSPAIR(_ZN7ee20040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee20040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20040[];
extern void _ZN4bb403barEv();
extern void _ZN7ee200403fooEv();
static  VTBL_ENTRY vtc_ee20040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN7ee200403fooEv,
};
extern VTBL_ENTRY _ZTI7ee20040[];
extern  VTBL_ENTRY _ZTV7ee20040[];
Class_Descriptor cd_ee20040 = {  "ee20040", // class name
  bases_ee20040, 4,
  &(vtc_ee20040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30040  : virtual dd0040 {
  int e;
  virtual void  foo(); // _ZN7ee300403fooEv
  ~ee30040(); // tgen
  ee30040(); // tgen
};
//SIG(1 ee30040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee30040 ::foo(){vfunc_called(this, "_ZN7ee300403fooEv");}
ee30040 ::~ee30040(){ note_dtor("ee30040", this);} // tgen
ee30040 ::ee30040(){ note_ctor("ee30040", this);} // tgen

static void Test_ee30040()
{
  extern Class_Descriptor cd_ee30040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30040, buf);
    ee30040 *dp, &lv = *(dp=new (buf) ee30040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(24,12), "ee30040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), ABISELECT(16,8), "ee30040");
    check_base_class_offset(lv, (cc040*)(dd0040*), ABISELECT(16,8), "ee30040");
    check_base_class_offset(lv, (dd0040*), ABISELECT(16,8), "ee30040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30040.e");
    test_class_info(&lv, &cd_ee30040);
    dp->~ee30040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30040(Test_ee30040, "ee30040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30040C1Ev();
extern void _ZN7ee30040D1Ev();
Name_Map name_map_ee30040[] = {
  NSPAIR(_ZN7ee30040C1Ev),
  NSPAIR(_ZN7ee30040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee30040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30040[];
extern void _ZN7ee300403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee30040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30040[0]),
  (VTBL_ENTRY)&_ZN7ee300403fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee30040[];
static  VTT_ENTRY vtt_ee30040[] = {
  {&(_ZTV7ee30040[3]),  3,8},
  {&(_ZTV7ee30040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee30040[];
extern  VTBL_ENTRY _ZTV7ee30040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30040[];
Class_Descriptor cd_ee30040 = {  "ee30040", // class name
  bases_ee30040, 4,
  &(vtc_ee30040[0]), // expected_vtbl_contents
  &(vtt_ee30040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40040  : dd0040 {
  int e;
  virtual void  bar(); // _ZN7ee400403barEv
  ~ee40040(); // tgen
  ee40040(); // tgen
};
//SIG(1 ee40040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee40040 ::bar(){vfunc_called(this, "_ZN7ee400403barEv");}
ee40040 ::~ee40040(){ note_dtor("ee40040", this);} // tgen
ee40040 ::ee40040(){ note_ctor("ee40040", this);} // tgen

static void Test_ee40040()
{
  extern Class_Descriptor cd_ee40040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40040, buf);
    ee40040 *dp, &lv = *(dp=new (buf) ee40040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(8,4), "ee40040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), 0, "ee40040");
    check_base_class_offset(lv, (cc040*)(dd0040*), 0, "ee40040");
    check_base_class_offset(lv, (dd0040*), 0, "ee40040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40040.e");
    test_class_info(&lv, &cd_ee40040);
    dp->~ee40040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40040(Test_ee40040, "ee40040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40040C1Ev();
extern void _ZN7ee40040D1Ev();
Name_Map name_map_ee40040[] = {
  NSPAIR(_ZN7ee40040C1Ev),
  NSPAIR(_ZN7ee40040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee40040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40040[];
extern void _ZN7ee400403barEv();
static  VTBL_ENTRY vtc_ee40040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40040[0]),
  (VTBL_ENTRY)&_ZN7ee400403barEv,
};
extern VTBL_ENTRY _ZTI7ee40040[];
extern  VTBL_ENTRY _ZTV7ee40040[];
Class_Descriptor cd_ee40040 = {  "ee40040", // class name
  bases_ee40040, 4,
  &(vtc_ee40040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40040),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50040  : virtual dd0040 {
  int e;
  virtual void  bar(); // _ZN7ee500403barEv
  ~ee50040(); // tgen
  ee50040(); // tgen
};
//SIG(1 ee50040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee50040 ::bar(){vfunc_called(this, "_ZN7ee500403barEv");}
ee50040 ::~ee50040(){ note_dtor("ee50040", this);} // tgen
ee50040 ::ee50040(){ note_ctor("ee50040", this);} // tgen

static void Test_ee50040()
{
  extern Class_Descriptor cd_ee50040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50040, buf);
    ee50040 *dp, &lv = *(dp=new (buf) ee50040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(24,12), "ee50040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), ABISELECT(16,8), "ee50040");
    check_base_class_offset(lv, (cc040*)(dd0040*), ABISELECT(16,8), "ee50040");
    check_base_class_offset(lv, (dd0040*), ABISELECT(16,8), "ee50040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50040.e");
    test_class_info(&lv, &cd_ee50040);
    dp->~ee50040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50040(Test_ee50040, "ee50040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50040C1Ev();
extern void _ZN7ee50040D1Ev();
Name_Map name_map_ee50040[] = {
  NSPAIR(_ZN7ee50040C1Ev),
  NSPAIR(_ZN7ee50040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee50040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50040[];
extern void _ZN7ee500403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee500403barEv,_ZTv0_n12_N7ee500403barEv)();
extern void ABISELECT(_ZThn16_N7ee500403barEv,_ZThn8_N7ee500403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee50040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50040[0]),
  (VTBL_ENTRY)&_ZN7ee500403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee500403barEv,_ZTv0_n12_N7ee500403barEv),
};
extern VTBL_ENTRY _ZTV7ee50040[];
static  VTT_ENTRY vtt_ee50040[] = {
  {&(_ZTV7ee50040[3]),  3,8},
  {&(_ZTV7ee50040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee50040[];
extern  VTBL_ENTRY _ZTV7ee50040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50040[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee500403barEv,_ZTv0_n12_N7ee500403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee500403barEv,_ZThn8_N7ee500403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50040 = {  "ee50040", // class name
  bases_ee50040, 4,
  &(vtc_ee50040[0]), // expected_vtbl_contents
  &(vtt_ee50040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60040  : dd0040 {
  int e;
  virtual void  foo(); // _ZN7ee600403fooEv
  virtual void  bar(); // _ZN7ee600403barEv
  ~ee60040(); // tgen
  ee60040(); // tgen
};
//SIG(1 ee60040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee60040 ::foo(){vfunc_called(this, "_ZN7ee600403fooEv");}
void  ee60040 ::bar(){vfunc_called(this, "_ZN7ee600403barEv");}
ee60040 ::~ee60040(){ note_dtor("ee60040", this);} // tgen
ee60040 ::ee60040(){ note_ctor("ee60040", this);} // tgen

static void Test_ee60040()
{
  extern Class_Descriptor cd_ee60040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60040, buf);
    ee60040 *dp, &lv = *(dp=new (buf) ee60040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(8,4), "ee60040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), 0, "ee60040");
    check_base_class_offset(lv, (cc040*)(dd0040*), 0, "ee60040");
    check_base_class_offset(lv, (dd0040*), 0, "ee60040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60040.e");
    test_class_info(&lv, &cd_ee60040);
    dp->~ee60040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60040(Test_ee60040, "ee60040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60040C1Ev();
extern void _ZN7ee60040D1Ev();
Name_Map name_map_ee60040[] = {
  NSPAIR(_ZN7ee60040C1Ev),
  NSPAIR(_ZN7ee60040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee60040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60040[];
extern void _ZN7ee600403barEv();
extern void _ZN7ee600403fooEv();
static  VTBL_ENTRY vtc_ee60040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60040[0]),
  (VTBL_ENTRY)&_ZN7ee600403barEv,
  (VTBL_ENTRY)&_ZN7ee600403fooEv,
};
extern VTBL_ENTRY _ZTI7ee60040[];
extern  VTBL_ENTRY _ZTV7ee60040[];
Class_Descriptor cd_ee60040 = {  "ee60040", // class name
  bases_ee60040, 4,
  &(vtc_ee60040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70040  : virtual dd0040 {
  int e;
  virtual void  foo(); // _ZN7ee700403fooEv
  virtual void  bar(); // _ZN7ee700403barEv
  ~ee70040(); // tgen
  ee70040(); // tgen
};
//SIG(1 ee70040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee70040 ::foo(){vfunc_called(this, "_ZN7ee700403fooEv");}
void  ee70040 ::bar(){vfunc_called(this, "_ZN7ee700403barEv");}
ee70040 ::~ee70040(){ note_dtor("ee70040", this);} // tgen
ee70040 ::ee70040(){ note_ctor("ee70040", this);} // tgen

static void Test_ee70040()
{
  extern Class_Descriptor cd_ee70040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70040, buf);
    ee70040 *dp, &lv = *(dp=new (buf) ee70040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd0040*), ABISELECT(24,12), "ee70040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd0040*), ABISELECT(16,8), "ee70040");
    check_base_class_offset(lv, (cc040*)(dd0040*), ABISELECT(16,8), "ee70040");
    check_base_class_offset(lv, (dd0040*), ABISELECT(16,8), "ee70040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70040.e");
    test_class_info(&lv, &cd_ee70040);
    dp->~ee70040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70040(Test_ee70040, "ee70040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70040C1Ev();
extern void _ZN7ee70040D1Ev();
Name_Map name_map_ee70040[] = {
  NSPAIR(_ZN7ee70040C1Ev),
  NSPAIR(_ZN7ee70040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd0040;
extern VTBL_ENTRY _ZTI6dd0040[];
extern  VTBL_ENTRY _ZTV6dd0040[];
static Base_Class bases_ee70040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70040[];
extern void _ZN7ee700403fooEv();
extern void _ZN7ee700403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee700403barEv,_ZTv0_n12_N7ee700403barEv)();
extern void ABISELECT(_ZThn16_N7ee700403barEv,_ZThn8_N7ee700403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70040[0]),
  (VTBL_ENTRY)&_ZN7ee700403fooEv,
  (VTBL_ENTRY)&_ZN7ee700403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee700403barEv,_ZTv0_n12_N7ee700403barEv),
};
extern VTBL_ENTRY _ZTV7ee70040[];
static  VTT_ENTRY vtt_ee70040[] = {
  {&(_ZTV7ee70040[3]),  3,9},
  {&(_ZTV7ee70040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee70040[];
extern  VTBL_ENTRY _ZTV7ee70040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70040[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee700403barEv,_ZTv0_n12_N7ee700403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700403barEv,_ZThn8_N7ee700403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70040 = {  "ee70040", // class name
  bases_ee70040, 4,
  &(vtc_ee70040[0]), // expected_vtbl_contents
  &(vtt_ee70040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1040  : virtual cc040 {
  int d;
  ~dd1040(); // tgen
  dd1040(); // tgen
};
//SIG(-1 dd1040) C1{ VBC2{ BC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd1040 ::~dd1040(){ note_dtor("dd1040", this);} // tgen
dd1040 ::dd1040(){ note_ctor("dd1040", this);} // tgen

static void Test_dd1040()
{
  extern Class_Descriptor cd_dd1040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1040, buf);
    dd1040 *dp, &lv = *(dp=new (buf) dd1040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,12), "dd1040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,8), "dd1040");
    check_base_class_offset(lv, (cc040*), ABISELECT(16,8), "dd1040");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1040.d");
    test_class_info(&lv, &cd_dd1040);
    dp->~dd1040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1040(Test_dd1040, "dd1040", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1040C1Ev();
extern void _ZN6dd1040D1Ev();
Name_Map name_map_dd1040[] = {
  NSPAIR(_ZN6dd1040C1Ev),
  NSPAIR(_ZN6dd1040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd1040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1040[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_dd1040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV6dd1040[];
static  VTT_ENTRY vtt_dd1040[] = {
  {&(_ZTV6dd1040[3]),  3,7},
  {&(_ZTV6dd1040[6]),  6,7},
};
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
Class_Descriptor cd_dd1040 = {  "dd1040", // class name
  bases_dd1040, 3,
  &(vtc_dd1040[0]), // expected_vtbl_contents
  &(vtt_dd1040[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1040),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1040),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01040  : dd1040 {
  int e;
  ~ee01040(); // tgen
  ee01040(); // tgen
};
//SIG(1 ee01040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01040 ::~ee01040(){ note_dtor("ee01040", this);} // tgen
ee01040 ::ee01040(){ note_ctor("ee01040", this);} // tgen

static void Test_ee01040()
{
  extern Class_Descriptor cd_ee01040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01040, buf);
    ee01040 *dp, &lv = *(dp=new (buf) ee01040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee01040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee01040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(16,12), "ee01040");
    check_base_class_offset(lv, (dd1040*), 0, "ee01040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01040.e");
    test_class_info(&lv, &cd_ee01040);
    dp->~ee01040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01040(Test_ee01040, "ee01040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01040C1Ev();
extern void _ZN7ee01040D1Ev();
Name_Map name_map_ee01040[] = {
  NSPAIR(_ZN7ee01040C1Ev),
  NSPAIR(_ZN7ee01040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee01040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01040[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee01040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01040[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee01040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee01040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee01040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee01040[] = {
  {&(_ZTV7ee01040[3]),  3,7},
  {&(_tg__ZTV6dd1040__7ee01040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee01040[3]),  3,4},
  {&(_ZTV7ee01040[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee01040[];
extern  VTBL_ENTRY _ZTV7ee01040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01040[];
Class_Descriptor cd_ee01040 = {  "ee01040", // class name
  bases_ee01040, 4,
  &(vtc_ee01040[0]), // expected_vtbl_contents
  &(vtt_ee01040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01040),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11040  : virtual dd1040 {
  int e;
  ~ee11040(); // tgen
  ee11040(); // tgen
};
//SIG(1 ee11040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11040 ::~ee11040(){ note_dtor("ee11040", this);} // tgen
ee11040 ::ee11040(){ note_ctor("ee11040", this);} // tgen

static void Test_ee11040()
{
  extern Class_Descriptor cd_ee11040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11040, buf);
    ee11040 *dp, &lv = *(dp=new (buf) ee11040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee11040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee11040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(32,16), "ee11040");
    check_base_class_offset(lv, (dd1040*), ABISELECT(16,8), "ee11040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11040.e");
    test_class_info(&lv, &cd_ee11040);
    dp->~ee11040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11040(Test_ee11040, "ee11040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11040C1Ev();
extern void _ZN7ee11040D1Ev();
Name_Map name_map_ee11040[] = {
  NSPAIR(_ZN7ee11040C1Ev),
  NSPAIR(_ZN7ee11040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee11040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11040[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee11040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11040[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11040[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee11040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee11040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee11040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee11040[] = {
  {&(_ZTV7ee11040[4]),  4,11},
  {&(_ZTV7ee11040[7]),  7,11},
  {&(_ZTV7ee11040[10]),  10,11},
  {&(_tg__ZTV6dd1040__7ee11040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee11040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11040[];
extern  VTBL_ENTRY _ZTV7ee11040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11040[];
Class_Descriptor cd_ee11040 = {  "ee11040", // class name
  bases_ee11040, 4,
  &(vtc_ee11040[0]), // expected_vtbl_contents
  &(vtt_ee11040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11040),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21040  : dd1040 {
  int e;
  virtual void  foo(); // _ZN7ee210403fooEv
  ~ee21040(); // tgen
  ee21040(); // tgen
};
//SIG(1 ee21040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee21040 ::foo(){vfunc_called(this, "_ZN7ee210403fooEv");}
ee21040 ::~ee21040(){ note_dtor("ee21040", this);} // tgen
ee21040 ::ee21040(){ note_ctor("ee21040", this);} // tgen

static void Test_ee21040()
{
  extern Class_Descriptor cd_ee21040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21040, buf);
    ee21040 *dp, &lv = *(dp=new (buf) ee21040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee21040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee21040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(16,12), "ee21040");
    check_base_class_offset(lv, (dd1040*), 0, "ee21040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21040.e");
    test_class_info(&lv, &cd_ee21040);
    dp->~ee21040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21040(Test_ee21040, "ee21040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21040C1Ev();
extern void _ZN7ee21040D1Ev();
Name_Map name_map_ee21040[] = {
  NSPAIR(_ZN7ee21040C1Ev),
  NSPAIR(_ZN7ee21040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee21040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21040[];
extern void _ZN7ee210403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee21040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21040[0]),
  (VTBL_ENTRY)&_ZN7ee210403fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee21040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee21040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee21040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee21040[] = {
  {&(_ZTV7ee21040[3]),  3,8},
  {&(_tg__ZTV6dd1040__7ee21040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee21040[3]),  3,4},
  {&(_ZTV7ee21040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee21040[];
extern  VTBL_ENTRY _ZTV7ee21040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21040[];
Class_Descriptor cd_ee21040 = {  "ee21040", // class name
  bases_ee21040, 4,
  &(vtc_ee21040[0]), // expected_vtbl_contents
  &(vtt_ee21040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31040  : virtual dd1040 {
  int e;
  virtual void  foo(); // _ZN7ee310403fooEv
  ~ee31040(); // tgen
  ee31040(); // tgen
};
//SIG(1 ee31040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee31040 ::foo(){vfunc_called(this, "_ZN7ee310403fooEv");}
ee31040 ::~ee31040(){ note_dtor("ee31040", this);} // tgen
ee31040 ::ee31040(){ note_ctor("ee31040", this);} // tgen

static void Test_ee31040()
{
  extern Class_Descriptor cd_ee31040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31040, buf);
    ee31040 *dp, &lv = *(dp=new (buf) ee31040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee31040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee31040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(32,16), "ee31040");
    check_base_class_offset(lv, (dd1040*), ABISELECT(16,8), "ee31040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31040.e");
    test_class_info(&lv, &cd_ee31040);
    dp->~ee31040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31040(Test_ee31040, "ee31040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31040C1Ev();
extern void _ZN7ee31040D1Ev();
Name_Map name_map_ee31040[] = {
  NSPAIR(_ZN7ee31040C1Ev),
  NSPAIR(_ZN7ee31040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee31040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31040[];
extern void _ZN7ee310403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee31040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31040[0]),
  (VTBL_ENTRY)&_ZN7ee310403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31040[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee31040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee31040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee31040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee31040[] = {
  {&(_ZTV7ee31040[4]),  4,12},
  {&(_ZTV7ee31040[8]),  8,12},
  {&(_ZTV7ee31040[11]),  11,12},
  {&(_tg__ZTV6dd1040__7ee31040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee31040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31040[];
extern  VTBL_ENTRY _ZTV7ee31040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31040[];
Class_Descriptor cd_ee31040 = {  "ee31040", // class name
  bases_ee31040, 4,
  &(vtc_ee31040[0]), // expected_vtbl_contents
  &(vtt_ee31040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31040),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41040  : dd1040 {
  int e;
  virtual void  bar(); // _ZN7ee410403barEv
  ~ee41040(); // tgen
  ee41040(); // tgen
};
//SIG(1 ee41040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee41040 ::bar(){vfunc_called(this, "_ZN7ee410403barEv");}
ee41040 ::~ee41040(){ note_dtor("ee41040", this);} // tgen
ee41040 ::ee41040(){ note_ctor("ee41040", this);} // tgen

static void Test_ee41040()
{
  extern Class_Descriptor cd_ee41040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41040, buf);
    ee41040 *dp, &lv = *(dp=new (buf) ee41040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee41040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee41040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(16,12), "ee41040");
    check_base_class_offset(lv, (dd1040*), 0, "ee41040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41040.e");
    test_class_info(&lv, &cd_ee41040);
    dp->~ee41040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41040(Test_ee41040, "ee41040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41040C1Ev();
extern void _ZN7ee41040D1Ev();
Name_Map name_map_ee41040[] = {
  NSPAIR(_ZN7ee41040C1Ev),
  NSPAIR(_ZN7ee41040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee41040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41040[];
extern void _ZN7ee410403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee410403barEv,_ZTv0_n12_N7ee410403barEv)();
extern void ABISELECT(_ZThn16_N7ee410403barEv,_ZThn12_N7ee410403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee41040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41040[0]),
  (VTBL_ENTRY)&_ZN7ee410403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee410403barEv,_ZTv0_n12_N7ee410403barEv),
};
extern VTBL_ENTRY _ZTV7ee41040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee41040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee41040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee41040[] = {
  {&(_ZTV7ee41040[3]),  3,8},
  {&(_tg__ZTV6dd1040__7ee41040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee41040[3]),  3,4},
  {&(_ZTV7ee41040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee41040[];
extern  VTBL_ENTRY _ZTV7ee41040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41040[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee410403barEv,_ZTv0_n12_N7ee410403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee410403barEv,_ZThn12_N7ee410403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41040 = {  "ee41040", // class name
  bases_ee41040, 4,
  &(vtc_ee41040[0]), // expected_vtbl_contents
  &(vtt_ee41040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51040  : virtual dd1040 {
  int e;
  virtual void  bar(); // _ZN7ee510403barEv
  ~ee51040(); // tgen
  ee51040(); // tgen
};
//SIG(1 ee51040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee51040 ::bar(){vfunc_called(this, "_ZN7ee510403barEv");}
ee51040 ::~ee51040(){ note_dtor("ee51040", this);} // tgen
ee51040 ::ee51040(){ note_ctor("ee51040", this);} // tgen

static void Test_ee51040()
{
  extern Class_Descriptor cd_ee51040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51040, buf);
    ee51040 *dp, &lv = *(dp=new (buf) ee51040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee51040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee51040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(32,16), "ee51040");
    check_base_class_offset(lv, (dd1040*), ABISELECT(16,8), "ee51040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51040.e");
    test_class_info(&lv, &cd_ee51040);
    dp->~ee51040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51040(Test_ee51040, "ee51040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51040C1Ev();
extern void _ZN7ee51040D1Ev();
Name_Map name_map_ee51040[] = {
  NSPAIR(_ZN7ee51040C1Ev),
  NSPAIR(_ZN7ee51040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee51040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51040[];
extern void _ZN7ee510403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee510403barEv,_ZTv0_n12_N7ee510403barEv)();
extern void ABISELECT(_ZThn32_N7ee510403barEv,_ZThn16_N7ee510403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee51040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51040[0]),
  (VTBL_ENTRY)&_ZN7ee510403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51040[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee510403barEv,_ZTv0_n12_N7ee510403barEv),
};
extern VTBL_ENTRY _ZTV7ee51040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee51040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee51040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee51040[] = {
  {&(_ZTV7ee51040[4]),  4,12},
  {&(_ZTV7ee51040[8]),  8,12},
  {&(_ZTV7ee51040[11]),  11,12},
  {&(_tg__ZTV6dd1040__7ee51040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee51040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51040[];
extern  VTBL_ENTRY _ZTV7ee51040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51040[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee510403barEv,_ZTv0_n12_N7ee510403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee510403barEv,_ZThn16_N7ee510403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51040 = {  "ee51040", // class name
  bases_ee51040, 4,
  &(vtc_ee51040[0]), // expected_vtbl_contents
  &(vtt_ee51040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51040),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61040  : dd1040 {
  int e;
  virtual void  foo(); // _ZN7ee610403fooEv
  virtual void  bar(); // _ZN7ee610403barEv
  ~ee61040(); // tgen
  ee61040(); // tgen
};
//SIG(1 ee61040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee61040 ::foo(){vfunc_called(this, "_ZN7ee610403fooEv");}
void  ee61040 ::bar(){vfunc_called(this, "_ZN7ee610403barEv");}
ee61040 ::~ee61040(){ note_dtor("ee61040", this);} // tgen
ee61040 ::ee61040(){ note_ctor("ee61040", this);} // tgen

static void Test_ee61040()
{
  extern Class_Descriptor cd_ee61040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61040, buf);
    ee61040 *dp, &lv = *(dp=new (buf) ee61040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee61040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee61040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(16,12), "ee61040");
    check_base_class_offset(lv, (dd1040*), 0, "ee61040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61040.e");
    test_class_info(&lv, &cd_ee61040);
    dp->~ee61040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61040(Test_ee61040, "ee61040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61040C1Ev();
extern void _ZN7ee61040D1Ev();
Name_Map name_map_ee61040[] = {
  NSPAIR(_ZN7ee61040C1Ev),
  NSPAIR(_ZN7ee61040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee61040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61040[];
extern void _ZN7ee610403fooEv();
extern void _ZN7ee610403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee610403barEv,_ZTv0_n12_N7ee610403barEv)();
extern void ABISELECT(_ZThn16_N7ee610403barEv,_ZThn12_N7ee610403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61040[0]),
  (VTBL_ENTRY)&_ZN7ee610403fooEv,
  (VTBL_ENTRY)&_ZN7ee610403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee610403barEv,_ZTv0_n12_N7ee610403barEv),
};
extern VTBL_ENTRY _ZTV7ee61040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee61040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee61040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee61040[] = {
  {&(_ZTV7ee61040[3]),  3,9},
  {&(_tg__ZTV6dd1040__7ee61040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee61040[3]),  3,4},
  {&(_ZTV7ee61040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee61040[];
extern  VTBL_ENTRY _ZTV7ee61040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61040[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee610403barEv,_ZTv0_n12_N7ee610403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610403barEv,_ZThn12_N7ee610403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61040 = {  "ee61040", // class name
  bases_ee61040, 4,
  &(vtc_ee61040[0]), // expected_vtbl_contents
  &(vtt_ee61040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71040  : virtual dd1040 {
  int e;
  virtual void  foo(); // _ZN7ee710403fooEv
  virtual void  bar(); // _ZN7ee710403barEv
  ~ee71040(); // tgen
  ee71040(); // tgen
};
//SIG(1 ee71040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee71040 ::foo(){vfunc_called(this, "_ZN7ee710403fooEv");}
void  ee71040 ::bar(){vfunc_called(this, "_ZN7ee710403barEv");}
ee71040 ::~ee71040(){ note_dtor("ee71040", this);} // tgen
ee71040 ::ee71040(){ note_ctor("ee71040", this);} // tgen

static void Test_ee71040()
{
  extern Class_Descriptor cd_ee71040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71040, buf);
    ee71040 *dp, &lv = *(dp=new (buf) ee71040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee71040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee71040");
    check_base_class_offset(lv, (cc040*)(dd1040*), ABISELECT(32,16), "ee71040");
    check_base_class_offset(lv, (dd1040*), ABISELECT(16,8), "ee71040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71040.e");
    test_class_info(&lv, &cd_ee71040);
    dp->~ee71040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71040(Test_ee71040, "ee71040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71040C1Ev();
extern void _ZN7ee71040D1Ev();
Name_Map name_map_ee71040[] = {
  NSPAIR(_ZN7ee71040C1Ev),
  NSPAIR(_ZN7ee71040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd1040;
extern VTBL_ENTRY _ZTI6dd1040[];
extern  VTBL_ENTRY _ZTV6dd1040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1040[];
static Base_Class bases_ee71040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1040,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71040[];
extern void _ZN7ee710403fooEv();
extern void _ZN7ee710403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee710403barEv,_ZTv0_n12_N7ee710403barEv)();
extern void ABISELECT(_ZThn32_N7ee710403barEv,_ZThn16_N7ee710403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71040[0]),
  (VTBL_ENTRY)&_ZN7ee710403fooEv,
  (VTBL_ENTRY)&_ZN7ee710403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71040[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee710403barEv,_ZTv0_n12_N7ee710403barEv),
};
extern VTBL_ENTRY _ZTV7ee71040[];
static  VTBL_ENTRY _tg__ZTV6dd1040__7ee71040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd1040__7ee71040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee71040[] = {
  {&(_ZTV7ee71040[4]),  4,13},
  {&(_ZTV7ee71040[9]),  9,13},
  {&(_ZTV7ee71040[12]),  12,13},
  {&(_tg__ZTV6dd1040__7ee71040[3]),  3,3},
  {&(_tg__ZTV4bb405cc040__6dd1040__7ee71040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71040[];
extern  VTBL_ENTRY _ZTV7ee71040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71040[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee710403barEv,_ZTv0_n12_N7ee710403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710403barEv,_ZThn16_N7ee710403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71040 = {  "ee71040", // class name
  bases_ee71040, 4,
  &(vtc_ee71040[0]), // expected_vtbl_contents
  &(vtt_ee71040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71040),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2040  : cc040 {
  int d;
  virtual void  foo(); // _ZN6dd20403fooEv
  ~dd2040(); // tgen
  dd2040(); // tgen
};
//SIG(-1 dd2040) C1{ BC2{ BC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd2040 ::foo(){vfunc_called(this, "_ZN6dd20403fooEv");}
dd2040 ::~dd2040(){ note_dtor("dd2040", this);} // tgen
dd2040 ::dd2040(){ note_ctor("dd2040", this);} // tgen

static void Test_dd2040()
{
  extern Class_Descriptor cd_dd2040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2040, buf);
    dd2040 *dp, &lv = *(dp=new (buf) dd2040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(8,4), "dd2040");
    check_base_class_offset(lv, (bb40*)(cc040*), 0, "dd2040");
    check_base_class_offset(lv, (cc040*), 0, "dd2040");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2040.d");
    test_class_info(&lv, &cd_dd2040);
    dp->~dd2040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2040(Test_dd2040, "dd2040", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2040C1Ev();
extern void _ZN6dd2040D1Ev();
Name_Map name_map_dd2040[] = {
  NSPAIR(_ZN6dd2040C1Ev),
  NSPAIR(_ZN6dd2040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd2040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2040[];
extern void _ZN4bb403barEv();
extern void _ZN6dd20403fooEv();
static  VTBL_ENTRY vtc_dd2040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN6dd20403fooEv,
};
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
Class_Descriptor cd_dd2040 = {  "dd2040", // class name
  bases_dd2040, 3,
  &(vtc_dd2040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02040  : dd2040 {
  int e;
  ~ee02040(); // tgen
  ee02040(); // tgen
};
//SIG(1 ee02040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee02040 ::~ee02040(){ note_dtor("ee02040", this);} // tgen
ee02040 ::ee02040(){ note_ctor("ee02040", this);} // tgen

static void Test_ee02040()
{
  extern Class_Descriptor cd_ee02040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02040, buf);
    ee02040 *dp, &lv = *(dp=new (buf) ee02040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(8,4), "ee02040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), 0, "ee02040");
    check_base_class_offset(lv, (cc040*)(dd2040*), 0, "ee02040");
    check_base_class_offset(lv, (dd2040*), 0, "ee02040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02040.e");
    test_class_info(&lv, &cd_ee02040);
    dp->~ee02040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02040(Test_ee02040, "ee02040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02040C1Ev();
extern void _ZN7ee02040D1Ev();
Name_Map name_map_ee02040[] = {
  NSPAIR(_ZN7ee02040C1Ev),
  NSPAIR(_ZN7ee02040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee02040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02040[];
extern void _ZN4bb403barEv();
extern void _ZN6dd20403fooEv();
static  VTBL_ENTRY vtc_ee02040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN6dd20403fooEv,
};
extern VTBL_ENTRY _ZTI7ee02040[];
extern  VTBL_ENTRY _ZTV7ee02040[];
Class_Descriptor cd_ee02040 = {  "ee02040", // class name
  bases_ee02040, 4,
  &(vtc_ee02040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12040  : virtual dd2040 {
  int e;
  ~ee12040(); // tgen
  ee12040(); // tgen
};
//SIG(1 ee12040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee12040 ::~ee12040(){ note_dtor("ee12040", this);} // tgen
ee12040 ::ee12040(){ note_ctor("ee12040", this);} // tgen

static void Test_ee12040()
{
  extern Class_Descriptor cd_ee12040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12040, buf);
    ee12040 *dp, &lv = *(dp=new (buf) ee12040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(24,12), "ee12040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), ABISELECT(16,8), "ee12040");
    check_base_class_offset(lv, (cc040*)(dd2040*), ABISELECT(16,8), "ee12040");
    check_base_class_offset(lv, (dd2040*), ABISELECT(16,8), "ee12040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12040.e");
    test_class_info(&lv, &cd_ee12040);
    dp->~ee12040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12040(Test_ee12040, "ee12040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12040C1Ev();
extern void _ZN7ee12040D1Ev();
Name_Map name_map_ee12040[] = {
  NSPAIR(_ZN7ee12040C1Ev),
  NSPAIR(_ZN7ee12040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee12040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12040[];
extern void _ZN4bb403barEv();
extern void _ZN6dd20403fooEv();
static  VTBL_ENTRY vtc_ee12040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12040[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN6dd20403fooEv,
};
extern VTBL_ENTRY _ZTV7ee12040[];
static  VTT_ENTRY vtt_ee12040[] = {
  {&(_ZTV7ee12040[3]),  3,9},
  {&(_ZTV7ee12040[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee12040[];
extern  VTBL_ENTRY _ZTV7ee12040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12040[];
Class_Descriptor cd_ee12040 = {  "ee12040", // class name
  bases_ee12040, 4,
  &(vtc_ee12040[0]), // expected_vtbl_contents
  &(vtt_ee12040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22040  : dd2040 {
  int e;
  virtual void  foo(); // _ZN7ee220403fooEv
  ~ee22040(); // tgen
  ee22040(); // tgen
};
//SIG(1 ee22040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee22040 ::foo(){vfunc_called(this, "_ZN7ee220403fooEv");}
ee22040 ::~ee22040(){ note_dtor("ee22040", this);} // tgen
ee22040 ::ee22040(){ note_ctor("ee22040", this);} // tgen

static void Test_ee22040()
{
  extern Class_Descriptor cd_ee22040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22040, buf);
    ee22040 *dp, &lv = *(dp=new (buf) ee22040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(8,4), "ee22040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), 0, "ee22040");
    check_base_class_offset(lv, (cc040*)(dd2040*), 0, "ee22040");
    check_base_class_offset(lv, (dd2040*), 0, "ee22040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22040.e");
    test_class_info(&lv, &cd_ee22040);
    dp->~ee22040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22040(Test_ee22040, "ee22040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22040C1Ev();
extern void _ZN7ee22040D1Ev();
Name_Map name_map_ee22040[] = {
  NSPAIR(_ZN7ee22040C1Ev),
  NSPAIR(_ZN7ee22040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee22040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22040[];
extern void _ZN4bb403barEv();
extern void _ZN7ee220403fooEv();
static  VTBL_ENTRY vtc_ee22040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN7ee220403fooEv,
};
extern VTBL_ENTRY _ZTI7ee22040[];
extern  VTBL_ENTRY _ZTV7ee22040[];
Class_Descriptor cd_ee22040 = {  "ee22040", // class name
  bases_ee22040, 4,
  &(vtc_ee22040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32040  : virtual dd2040 {
  int e;
  virtual void  foo(); // _ZN7ee320403fooEv
  ~ee32040(); // tgen
  ee32040(); // tgen
};
//SIG(1 ee32040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee32040 ::foo(){vfunc_called(this, "_ZN7ee320403fooEv");}
ee32040 ::~ee32040(){ note_dtor("ee32040", this);} // tgen
ee32040 ::ee32040(){ note_ctor("ee32040", this);} // tgen

static void Test_ee32040()
{
  extern Class_Descriptor cd_ee32040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32040, buf);
    ee32040 *dp, &lv = *(dp=new (buf) ee32040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(24,12), "ee32040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), ABISELECT(16,8), "ee32040");
    check_base_class_offset(lv, (cc040*)(dd2040*), ABISELECT(16,8), "ee32040");
    check_base_class_offset(lv, (dd2040*), ABISELECT(16,8), "ee32040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32040.e");
    test_class_info(&lv, &cd_ee32040);
    dp->~ee32040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32040(Test_ee32040, "ee32040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32040C1Ev();
extern void _ZN7ee32040D1Ev();
Name_Map name_map_ee32040[] = {
  NSPAIR(_ZN7ee32040C1Ev),
  NSPAIR(_ZN7ee32040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee32040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32040[];
extern void _ZN7ee320403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee320403fooEv,_ZTv0_n16_N7ee320403fooEv)();
extern void ABISELECT(_ZThn16_N7ee320403fooEv,_ZThn8_N7ee320403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32040[0]),
  (VTBL_ENTRY)&_ZN7ee320403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee320403fooEv,_ZTv0_n16_N7ee320403fooEv),
};
extern VTBL_ENTRY _ZTV7ee32040[];
static  VTT_ENTRY vtt_ee32040[] = {
  {&(_ZTV7ee32040[3]),  3,10},
  {&(_ZTV7ee32040[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee32040[];
extern  VTBL_ENTRY _ZTV7ee32040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32040[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee320403fooEv,_ZTv0_n16_N7ee320403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320403fooEv,_ZThn8_N7ee320403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32040 = {  "ee32040", // class name
  bases_ee32040, 4,
  &(vtc_ee32040[0]), // expected_vtbl_contents
  &(vtt_ee32040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32040),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42040  : dd2040 {
  int e;
  virtual void  bar(); // _ZN7ee420403barEv
  ~ee42040(); // tgen
  ee42040(); // tgen
};
//SIG(1 ee42040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee42040 ::bar(){vfunc_called(this, "_ZN7ee420403barEv");}
ee42040 ::~ee42040(){ note_dtor("ee42040", this);} // tgen
ee42040 ::ee42040(){ note_ctor("ee42040", this);} // tgen

static void Test_ee42040()
{
  extern Class_Descriptor cd_ee42040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42040, buf);
    ee42040 *dp, &lv = *(dp=new (buf) ee42040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(8,4), "ee42040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), 0, "ee42040");
    check_base_class_offset(lv, (cc040*)(dd2040*), 0, "ee42040");
    check_base_class_offset(lv, (dd2040*), 0, "ee42040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42040.e");
    test_class_info(&lv, &cd_ee42040);
    dp->~ee42040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42040(Test_ee42040, "ee42040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42040C1Ev();
extern void _ZN7ee42040D1Ev();
Name_Map name_map_ee42040[] = {
  NSPAIR(_ZN7ee42040C1Ev),
  NSPAIR(_ZN7ee42040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee42040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42040[];
extern void _ZN7ee420403barEv();
extern void _ZN6dd20403fooEv();
static  VTBL_ENTRY vtc_ee42040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42040[0]),
  (VTBL_ENTRY)&_ZN7ee420403barEv,
  (VTBL_ENTRY)&_ZN6dd20403fooEv,
};
extern VTBL_ENTRY _ZTI7ee42040[];
extern  VTBL_ENTRY _ZTV7ee42040[];
Class_Descriptor cd_ee42040 = {  "ee42040", // class name
  bases_ee42040, 4,
  &(vtc_ee42040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52040  : virtual dd2040 {
  int e;
  virtual void  bar(); // _ZN7ee520403barEv
  ~ee52040(); // tgen
  ee52040(); // tgen
};
//SIG(1 ee52040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee52040 ::bar(){vfunc_called(this, "_ZN7ee520403barEv");}
ee52040 ::~ee52040(){ note_dtor("ee52040", this);} // tgen
ee52040 ::ee52040(){ note_ctor("ee52040", this);} // tgen

static void Test_ee52040()
{
  extern Class_Descriptor cd_ee52040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52040, buf);
    ee52040 *dp, &lv = *(dp=new (buf) ee52040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(24,12), "ee52040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), ABISELECT(16,8), "ee52040");
    check_base_class_offset(lv, (cc040*)(dd2040*), ABISELECT(16,8), "ee52040");
    check_base_class_offset(lv, (dd2040*), ABISELECT(16,8), "ee52040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52040.e");
    test_class_info(&lv, &cd_ee52040);
    dp->~ee52040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52040(Test_ee52040, "ee52040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52040C1Ev();
extern void _ZN7ee52040D1Ev();
Name_Map name_map_ee52040[] = {
  NSPAIR(_ZN7ee52040C1Ev),
  NSPAIR(_ZN7ee52040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee52040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52040[];
extern void _ZN7ee520403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee520403barEv,_ZTv0_n12_N7ee520403barEv)();
extern void ABISELECT(_ZThn16_N7ee520403barEv,_ZThn8_N7ee520403barEv)() __attribute__((weak));
extern void _ZN6dd20403fooEv();
static  VTBL_ENTRY vtc_ee52040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52040[0]),
  (VTBL_ENTRY)&_ZN7ee520403barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee520403barEv,_ZTv0_n12_N7ee520403barEv),
  (VTBL_ENTRY)&_ZN6dd20403fooEv,
};
extern VTBL_ENTRY _ZTV7ee52040[];
static  VTT_ENTRY vtt_ee52040[] = {
  {&(_ZTV7ee52040[3]),  3,10},
  {&(_ZTV7ee52040[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee52040[];
extern  VTBL_ENTRY _ZTV7ee52040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52040[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee520403barEv,_ZTv0_n12_N7ee520403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee520403barEv,_ZThn8_N7ee520403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52040 = {  "ee52040", // class name
  bases_ee52040, 4,
  &(vtc_ee52040[0]), // expected_vtbl_contents
  &(vtt_ee52040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52040),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62040  : dd2040 {
  int e;
  virtual void  foo(); // _ZN7ee620403fooEv
  virtual void  bar(); // _ZN7ee620403barEv
  ~ee62040(); // tgen
  ee62040(); // tgen
};
//SIG(1 ee62040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62040 ::foo(){vfunc_called(this, "_ZN7ee620403fooEv");}
void  ee62040 ::bar(){vfunc_called(this, "_ZN7ee620403barEv");}
ee62040 ::~ee62040(){ note_dtor("ee62040", this);} // tgen
ee62040 ::ee62040(){ note_ctor("ee62040", this);} // tgen

static void Test_ee62040()
{
  extern Class_Descriptor cd_ee62040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62040, buf);
    ee62040 *dp, &lv = *(dp=new (buf) ee62040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(8,4), "ee62040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), 0, "ee62040");
    check_base_class_offset(lv, (cc040*)(dd2040*), 0, "ee62040");
    check_base_class_offset(lv, (dd2040*), 0, "ee62040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62040.e");
    test_class_info(&lv, &cd_ee62040);
    dp->~ee62040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62040(Test_ee62040, "ee62040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62040C1Ev();
extern void _ZN7ee62040D1Ev();
Name_Map name_map_ee62040[] = {
  NSPAIR(_ZN7ee62040C1Ev),
  NSPAIR(_ZN7ee62040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee62040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62040[];
extern void _ZN7ee620403barEv();
extern void _ZN7ee620403fooEv();
static  VTBL_ENTRY vtc_ee62040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62040[0]),
  (VTBL_ENTRY)&_ZN7ee620403barEv,
  (VTBL_ENTRY)&_ZN7ee620403fooEv,
};
extern VTBL_ENTRY _ZTI7ee62040[];
extern  VTBL_ENTRY _ZTV7ee62040[];
Class_Descriptor cd_ee62040 = {  "ee62040", // class name
  bases_ee62040, 4,
  &(vtc_ee62040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72040  : virtual dd2040 {
  int e;
  virtual void  foo(); // _ZN7ee720403fooEv
  virtual void  bar(); // _ZN7ee720403barEv
  ~ee72040(); // tgen
  ee72040(); // tgen
};
//SIG(1 ee72040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72040 ::foo(){vfunc_called(this, "_ZN7ee720403fooEv");}
void  ee72040 ::bar(){vfunc_called(this, "_ZN7ee720403barEv");}
ee72040 ::~ee72040(){ note_dtor("ee72040", this);} // tgen
ee72040 ::ee72040(){ note_ctor("ee72040", this);} // tgen

static void Test_ee72040()
{
  extern Class_Descriptor cd_ee72040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72040, buf);
    ee72040 *dp, &lv = *(dp=new (buf) ee72040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd2040*), ABISELECT(24,12), "ee72040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd2040*), ABISELECT(16,8), "ee72040");
    check_base_class_offset(lv, (cc040*)(dd2040*), ABISELECT(16,8), "ee72040");
    check_base_class_offset(lv, (dd2040*), ABISELECT(16,8), "ee72040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72040.e");
    test_class_info(&lv, &cd_ee72040);
    dp->~ee72040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72040(Test_ee72040, "ee72040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72040C1Ev();
extern void _ZN7ee72040D1Ev();
Name_Map name_map_ee72040[] = {
  NSPAIR(_ZN7ee72040C1Ev),
  NSPAIR(_ZN7ee72040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd2040;
extern VTBL_ENTRY _ZTI6dd2040[];
extern  VTBL_ENTRY _ZTV6dd2040[];
static Base_Class bases_ee72040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72040[];
extern void _ZN7ee720403fooEv();
extern void _ZN7ee720403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee720403barEv,_ZTv0_n12_N7ee720403barEv)();
extern void ABISELECT(_ZThn16_N7ee720403barEv,_ZThn8_N7ee720403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee720403fooEv,_ZTv0_n16_N7ee720403fooEv)();
extern void ABISELECT(_ZThn16_N7ee720403fooEv,_ZThn8_N7ee720403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72040[0]),
  (VTBL_ENTRY)&_ZN7ee720403fooEv,
  (VTBL_ENTRY)&_ZN7ee720403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee720403barEv,_ZTv0_n12_N7ee720403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee720403fooEv,_ZTv0_n16_N7ee720403fooEv),
};
extern VTBL_ENTRY _ZTV7ee72040[];
static  VTT_ENTRY vtt_ee72040[] = {
  {&(_ZTV7ee72040[3]),  3,11},
  {&(_ZTV7ee72040[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee72040[];
extern  VTBL_ENTRY _ZTV7ee72040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72040[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee720403fooEv,_ZTv0_n16_N7ee720403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720403fooEv,_ZThn8_N7ee720403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee720403barEv,_ZTv0_n12_N7ee720403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720403barEv,_ZThn8_N7ee720403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72040 = {  "ee72040", // class name
  bases_ee72040, 4,
  &(vtc_ee72040[0]), // expected_vtbl_contents
  &(vtt_ee72040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72040),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3040  : virtual cc040 {
  int d;
  virtual void  foo(); // _ZN6dd30403fooEv
  ~dd3040(); // tgen
  dd3040(); // tgen
};
//SIG(-1 dd3040) C1{ VBC2{ BC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd3040 ::foo(){vfunc_called(this, "_ZN6dd30403fooEv");}
dd3040 ::~dd3040(){ note_dtor("dd3040", this);} // tgen
dd3040 ::dd3040(){ note_ctor("dd3040", this);} // tgen

static void Test_dd3040()
{
  extern Class_Descriptor cd_dd3040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3040, buf);
    dd3040 *dp, &lv = *(dp=new (buf) dd3040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,12), "dd3040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,8), "dd3040");
    check_base_class_offset(lv, (cc040*), ABISELECT(16,8), "dd3040");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3040.d");
    test_class_info(&lv, &cd_dd3040);
    dp->~dd3040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3040(Test_dd3040, "dd3040", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3040C1Ev();
extern void _ZN6dd3040D1Ev();
Name_Map name_map_dd3040[] = {
  NSPAIR(_ZN6dd3040C1Ev),
  NSPAIR(_ZN6dd3040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd3040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3040[];
extern void _ZN6dd30403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_dd3040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV6dd3040[];
static  VTT_ENTRY vtt_dd3040[] = {
  {&(_ZTV6dd3040[3]),  3,8},
  {&(_ZTV6dd3040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
Class_Descriptor cd_dd3040 = {  "dd3040", // class name
  bases_dd3040, 3,
  &(vtc_dd3040[0]), // expected_vtbl_contents
  &(vtt_dd3040[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3040),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03040  : dd3040 {
  int e;
  ~ee03040(); // tgen
  ee03040(); // tgen
};
//SIG(1 ee03040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee03040 ::~ee03040(){ note_dtor("ee03040", this);} // tgen
ee03040 ::ee03040(){ note_ctor("ee03040", this);} // tgen

static void Test_ee03040()
{
  extern Class_Descriptor cd_ee03040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03040, buf);
    ee03040 *dp, &lv = *(dp=new (buf) ee03040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee03040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee03040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(16,12), "ee03040");
    check_base_class_offset(lv, (dd3040*), 0, "ee03040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03040.e");
    test_class_info(&lv, &cd_ee03040);
    dp->~ee03040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03040(Test_ee03040, "ee03040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03040C1Ev();
extern void _ZN7ee03040D1Ev();
Name_Map name_map_ee03040[] = {
  NSPAIR(_ZN7ee03040C1Ev),
  NSPAIR(_ZN7ee03040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee03040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03040[];
extern void _ZN6dd30403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee03040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee03040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee03040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee03040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee03040[] = {
  {&(_ZTV7ee03040[3]),  3,8},
  {&(_tg__ZTV6dd3040__7ee03040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee03040[3]),  3,4},
  {&(_ZTV7ee03040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee03040[];
extern  VTBL_ENTRY _ZTV7ee03040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03040[];
Class_Descriptor cd_ee03040 = {  "ee03040", // class name
  bases_ee03040, 4,
  &(vtc_ee03040[0]), // expected_vtbl_contents
  &(vtt_ee03040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13040  : virtual dd3040 {
  int e;
  ~ee13040(); // tgen
  ee13040(); // tgen
};
//SIG(1 ee13040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee13040 ::~ee13040(){ note_dtor("ee13040", this);} // tgen
ee13040 ::ee13040(){ note_ctor("ee13040", this);} // tgen

static void Test_ee13040()
{
  extern Class_Descriptor cd_ee13040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13040, buf);
    ee13040 *dp, &lv = *(dp=new (buf) ee13040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee13040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee13040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(32,16), "ee13040");
    check_base_class_offset(lv, (dd3040*), ABISELECT(16,8), "ee13040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13040.e");
    test_class_info(&lv, &cd_ee13040);
    dp->~ee13040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13040(Test_ee13040, "ee13040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13040C1Ev();
extern void _ZN7ee13040D1Ev();
Name_Map name_map_ee13040[] = {
  NSPAIR(_ZN7ee13040C1Ev),
  NSPAIR(_ZN7ee13040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee13040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13040[];
extern void _ZN6dd30403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee13040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13040[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee13040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee13040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee13040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee13040[] = {
  {&(_ZTV7ee13040[4]),  4,13},
  {&(_ZTV7ee13040[8]),  8,13},
  {&(_ZTV7ee13040[12]),  12,13},
  {&(_tg__ZTV6dd3040__7ee13040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee13040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13040[];
extern  VTBL_ENTRY _ZTV7ee13040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13040[];
Class_Descriptor cd_ee13040 = {  "ee13040", // class name
  bases_ee13040, 4,
  &(vtc_ee13040[0]), // expected_vtbl_contents
  &(vtt_ee13040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13040),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23040  : dd3040 {
  int e;
  virtual void  foo(); // _ZN7ee230403fooEv
  ~ee23040(); // tgen
  ee23040(); // tgen
};
//SIG(1 ee23040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee23040 ::foo(){vfunc_called(this, "_ZN7ee230403fooEv");}
ee23040 ::~ee23040(){ note_dtor("ee23040", this);} // tgen
ee23040 ::ee23040(){ note_ctor("ee23040", this);} // tgen

static void Test_ee23040()
{
  extern Class_Descriptor cd_ee23040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23040, buf);
    ee23040 *dp, &lv = *(dp=new (buf) ee23040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee23040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee23040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(16,12), "ee23040");
    check_base_class_offset(lv, (dd3040*), 0, "ee23040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23040.e");
    test_class_info(&lv, &cd_ee23040);
    dp->~ee23040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23040(Test_ee23040, "ee23040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23040C1Ev();
extern void _ZN7ee23040D1Ev();
Name_Map name_map_ee23040[] = {
  NSPAIR(_ZN7ee23040C1Ev),
  NSPAIR(_ZN7ee23040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee23040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23040[];
extern void _ZN7ee230403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee23040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23040[0]),
  (VTBL_ENTRY)&_ZN7ee230403fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee23040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee23040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee23040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee23040[] = {
  {&(_ZTV7ee23040[3]),  3,8},
  {&(_tg__ZTV6dd3040__7ee23040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee23040[3]),  3,4},
  {&(_ZTV7ee23040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee23040[];
extern  VTBL_ENTRY _ZTV7ee23040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23040[];
Class_Descriptor cd_ee23040 = {  "ee23040", // class name
  bases_ee23040, 4,
  &(vtc_ee23040[0]), // expected_vtbl_contents
  &(vtt_ee23040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33040  : virtual dd3040 {
  int e;
  virtual void  foo(); // _ZN7ee330403fooEv
  ~ee33040(); // tgen
  ee33040(); // tgen
};
//SIG(1 ee33040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee33040 ::foo(){vfunc_called(this, "_ZN7ee330403fooEv");}
ee33040 ::~ee33040(){ note_dtor("ee33040", this);} // tgen
ee33040 ::ee33040(){ note_ctor("ee33040", this);} // tgen

static void Test_ee33040()
{
  extern Class_Descriptor cd_ee33040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33040, buf);
    ee33040 *dp, &lv = *(dp=new (buf) ee33040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee33040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee33040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(32,16), "ee33040");
    check_base_class_offset(lv, (dd3040*), ABISELECT(16,8), "ee33040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33040.e");
    test_class_info(&lv, &cd_ee33040);
    dp->~ee33040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33040(Test_ee33040, "ee33040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33040C1Ev();
extern void _ZN7ee33040D1Ev();
Name_Map name_map_ee33040[] = {
  NSPAIR(_ZN7ee33040C1Ev),
  NSPAIR(_ZN7ee33040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee33040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33040[];
extern void _ZN7ee330403fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee330403fooEv,_ZTv0_n16_N7ee330403fooEv)();
extern void ABISELECT(_ZThn16_N7ee330403fooEv,_ZThn8_N7ee330403fooEv)() __attribute__((weak));
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee33040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33040[0]),
  (VTBL_ENTRY)&_ZN7ee330403fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee330403fooEv,_ZTv0_n16_N7ee330403fooEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee33040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee33040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee33040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee33040[] = {
  {&(_ZTV7ee33040[4]),  4,14},
  {&(_ZTV7ee33040[9]),  9,14},
  {&(_ZTV7ee33040[13]),  13,14},
  {&(_tg__ZTV6dd3040__7ee33040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee33040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33040[];
extern  VTBL_ENTRY _ZTV7ee33040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33040[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee330403fooEv,_ZTv0_n16_N7ee330403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330403fooEv,_ZThn8_N7ee330403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33040 = {  "ee33040", // class name
  bases_ee33040, 4,
  &(vtc_ee33040[0]), // expected_vtbl_contents
  &(vtt_ee33040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33040),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43040  : dd3040 {
  int e;
  virtual void  bar(); // _ZN7ee430403barEv
  ~ee43040(); // tgen
  ee43040(); // tgen
};
//SIG(1 ee43040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee43040 ::bar(){vfunc_called(this, "_ZN7ee430403barEv");}
ee43040 ::~ee43040(){ note_dtor("ee43040", this);} // tgen
ee43040 ::ee43040(){ note_ctor("ee43040", this);} // tgen

static void Test_ee43040()
{
  extern Class_Descriptor cd_ee43040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43040, buf);
    ee43040 *dp, &lv = *(dp=new (buf) ee43040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee43040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee43040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(16,12), "ee43040");
    check_base_class_offset(lv, (dd3040*), 0, "ee43040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43040.e");
    test_class_info(&lv, &cd_ee43040);
    dp->~ee43040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43040(Test_ee43040, "ee43040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43040C1Ev();
extern void _ZN7ee43040D1Ev();
Name_Map name_map_ee43040[] = {
  NSPAIR(_ZN7ee43040C1Ev),
  NSPAIR(_ZN7ee43040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee43040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43040[];
extern void _ZN6dd30403fooEv();
extern void _ZN7ee430403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee430403barEv,_ZTv0_n12_N7ee430403barEv)();
extern void ABISELECT(_ZThn16_N7ee430403barEv,_ZThn12_N7ee430403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
  (VTBL_ENTRY)&_ZN7ee430403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee430403barEv,_ZTv0_n12_N7ee430403barEv),
};
extern VTBL_ENTRY _ZTV7ee43040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee43040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee43040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee43040[] = {
  {&(_ZTV7ee43040[3]),  3,9},
  {&(_tg__ZTV6dd3040__7ee43040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee43040[3]),  3,4},
  {&(_ZTV7ee43040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee43040[];
extern  VTBL_ENTRY _ZTV7ee43040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43040[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee430403barEv,_ZTv0_n12_N7ee430403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee430403barEv,_ZThn12_N7ee430403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43040 = {  "ee43040", // class name
  bases_ee43040, 4,
  &(vtc_ee43040[0]), // expected_vtbl_contents
  &(vtt_ee43040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53040  : virtual dd3040 {
  int e;
  virtual void  bar(); // _ZN7ee530403barEv
  ~ee53040(); // tgen
  ee53040(); // tgen
};
//SIG(1 ee53040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee53040 ::bar(){vfunc_called(this, "_ZN7ee530403barEv");}
ee53040 ::~ee53040(){ note_dtor("ee53040", this);} // tgen
ee53040 ::ee53040(){ note_ctor("ee53040", this);} // tgen

static void Test_ee53040()
{
  extern Class_Descriptor cd_ee53040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53040, buf);
    ee53040 *dp, &lv = *(dp=new (buf) ee53040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee53040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee53040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(32,16), "ee53040");
    check_base_class_offset(lv, (dd3040*), ABISELECT(16,8), "ee53040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53040.e");
    test_class_info(&lv, &cd_ee53040);
    dp->~ee53040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53040(Test_ee53040, "ee53040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53040C1Ev();
extern void _ZN7ee53040D1Ev();
Name_Map name_map_ee53040[] = {
  NSPAIR(_ZN7ee53040C1Ev),
  NSPAIR(_ZN7ee53040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee53040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53040[];
extern void _ZN7ee530403barEv();
extern void _ZN6dd30403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee530403barEv,_ZTv0_n12_N7ee530403barEv)();
extern void ABISELECT(_ZThn32_N7ee530403barEv,_ZThn16_N7ee530403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53040[0]),
  (VTBL_ENTRY)&_ZN7ee530403barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee530403barEv,_ZTv0_n12_N7ee530403barEv),
};
extern VTBL_ENTRY _ZTV7ee53040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee53040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee53040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee53040[] = {
  {&(_ZTV7ee53040[4]),  4,14},
  {&(_ZTV7ee53040[9]),  9,14},
  {&(_ZTV7ee53040[13]),  13,14},
  {&(_tg__ZTV6dd3040__7ee53040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee53040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53040[];
extern  VTBL_ENTRY _ZTV7ee53040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53040[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee530403barEv,_ZTv0_n12_N7ee530403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee530403barEv,_ZThn16_N7ee530403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53040 = {  "ee53040", // class name
  bases_ee53040, 4,
  &(vtc_ee53040[0]), // expected_vtbl_contents
  &(vtt_ee53040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53040),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63040  : dd3040 {
  int e;
  virtual void  foo(); // _ZN7ee630403fooEv
  virtual void  bar(); // _ZN7ee630403barEv
  ~ee63040(); // tgen
  ee63040(); // tgen
};
//SIG(1 ee63040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63040 ::foo(){vfunc_called(this, "_ZN7ee630403fooEv");}
void  ee63040 ::bar(){vfunc_called(this, "_ZN7ee630403barEv");}
ee63040 ::~ee63040(){ note_dtor("ee63040", this);} // tgen
ee63040 ::ee63040(){ note_ctor("ee63040", this);} // tgen

static void Test_ee63040()
{
  extern Class_Descriptor cd_ee63040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63040, buf);
    ee63040 *dp, &lv = *(dp=new (buf) ee63040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee63040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee63040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(16,12), "ee63040");
    check_base_class_offset(lv, (dd3040*), 0, "ee63040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63040.e");
    test_class_info(&lv, &cd_ee63040);
    dp->~ee63040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63040(Test_ee63040, "ee63040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63040C1Ev();
extern void _ZN7ee63040D1Ev();
Name_Map name_map_ee63040[] = {
  NSPAIR(_ZN7ee63040C1Ev),
  NSPAIR(_ZN7ee63040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee63040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63040[];
extern void _ZN7ee630403fooEv();
extern void _ZN7ee630403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee630403barEv,_ZTv0_n12_N7ee630403barEv)();
extern void ABISELECT(_ZThn16_N7ee630403barEv,_ZThn12_N7ee630403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63040[0]),
  (VTBL_ENTRY)&_ZN7ee630403fooEv,
  (VTBL_ENTRY)&_ZN7ee630403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee630403barEv,_ZTv0_n12_N7ee630403barEv),
};
extern VTBL_ENTRY _ZTV7ee63040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee63040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee63040[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee63040[] = {
  {&(_ZTV7ee63040[3]),  3,9},
  {&(_tg__ZTV6dd3040__7ee63040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee63040[3]),  3,4},
  {&(_ZTV7ee63040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee63040[];
extern  VTBL_ENTRY _ZTV7ee63040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63040[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee630403barEv,_ZTv0_n12_N7ee630403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630403barEv,_ZThn12_N7ee630403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63040 = {  "ee63040", // class name
  bases_ee63040, 4,
  &(vtc_ee63040[0]), // expected_vtbl_contents
  &(vtt_ee63040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73040  : virtual dd3040 {
  int e;
  virtual void  foo(); // _ZN7ee730403fooEv
  virtual void  bar(); // _ZN7ee730403barEv
  ~ee73040(); // tgen
  ee73040(); // tgen
};
//SIG(1 ee73040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73040 ::foo(){vfunc_called(this, "_ZN7ee730403fooEv");}
void  ee73040 ::bar(){vfunc_called(this, "_ZN7ee730403barEv");}
ee73040 ::~ee73040(){ note_dtor("ee73040", this);} // tgen
ee73040 ::ee73040(){ note_ctor("ee73040", this);} // tgen

static void Test_ee73040()
{
  extern Class_Descriptor cd_ee73040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73040, buf);
    ee73040 *dp, &lv = *(dp=new (buf) ee73040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee73040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee73040");
    check_base_class_offset(lv, (cc040*)(dd3040*), ABISELECT(32,16), "ee73040");
    check_base_class_offset(lv, (dd3040*), ABISELECT(16,8), "ee73040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73040.e");
    test_class_info(&lv, &cd_ee73040);
    dp->~ee73040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73040(Test_ee73040, "ee73040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73040C1Ev();
extern void _ZN7ee73040D1Ev();
Name_Map name_map_ee73040[] = {
  NSPAIR(_ZN7ee73040C1Ev),
  NSPAIR(_ZN7ee73040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd3040;
extern VTBL_ENTRY _ZTI6dd3040[];
extern  VTBL_ENTRY _ZTV6dd3040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3040[];
static Base_Class bases_ee73040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3040,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73040[];
extern void _ZN7ee730403fooEv();
extern void _ZN7ee730403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee730403fooEv,_ZTv0_n16_N7ee730403fooEv)();
extern void ABISELECT(_ZThn16_N7ee730403fooEv,_ZThn8_N7ee730403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee730403barEv,_ZTv0_n12_N7ee730403barEv)();
extern void ABISELECT(_ZThn32_N7ee730403barEv,_ZThn16_N7ee730403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73040[0]),
  (VTBL_ENTRY)&_ZN7ee730403fooEv,
  (VTBL_ENTRY)&_ZN7ee730403barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730403fooEv,_ZTv0_n16_N7ee730403fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee730403barEv,_ZTv0_n12_N7ee730403barEv),
};
extern VTBL_ENTRY _ZTV7ee73040[];
extern void _ZN6dd30403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3040__7ee73040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN6dd30403fooEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd3040__7ee73040[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3040[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee73040[] = {
  {&(_ZTV7ee73040[4]),  4,15},
  {&(_ZTV7ee73040[10]),  10,15},
  {&(_ZTV7ee73040[14]),  14,15},
  {&(_tg__ZTV6dd3040__7ee73040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd3040__7ee73040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73040[];
extern  VTBL_ENTRY _ZTV7ee73040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73040[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee730403barEv,_ZTv0_n12_N7ee730403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730403barEv,_ZThn16_N7ee730403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee730403fooEv,_ZTv0_n16_N7ee730403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730403fooEv,_ZThn8_N7ee730403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73040 = {  "ee73040", // class name
  bases_ee73040, 4,
  &(vtc_ee73040[0]), // expected_vtbl_contents
  &(vtt_ee73040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73040),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4040  : cc040 {
  int d;
  virtual void  bar(); // _ZN6dd40403barEv
  ~dd4040(); // tgen
  dd4040(); // tgen
};
//SIG(-1 dd4040) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd4040 ::bar(){vfunc_called(this, "_ZN6dd40403barEv");}
dd4040 ::~dd4040(){ note_dtor("dd4040", this);} // tgen
dd4040 ::dd4040(){ note_ctor("dd4040", this);} // tgen

static void Test_dd4040()
{
  extern Class_Descriptor cd_dd4040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4040, buf);
    dd4040 *dp, &lv = *(dp=new (buf) dd4040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(8,4), "dd4040");
    check_base_class_offset(lv, (bb40*)(cc040*), 0, "dd4040");
    check_base_class_offset(lv, (cc040*), 0, "dd4040");
    check_field_offset(lv, d, ABISELECT(20,16), "dd4040.d");
    test_class_info(&lv, &cd_dd4040);
    dp->~dd4040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4040(Test_dd4040, "dd4040", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4040C1Ev();
extern void _ZN6dd4040D1Ev();
Name_Map name_map_dd4040[] = {
  NSPAIR(_ZN6dd4040C1Ev),
  NSPAIR(_ZN6dd4040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd4040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4040[];
extern void _ZN6dd40403barEv();
static  VTBL_ENTRY vtc_dd4040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd4040[0]),
  (VTBL_ENTRY)&_ZN6dd40403barEv,
};
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
Class_Descriptor cd_dd4040 = {  "dd4040", // class name
  bases_dd4040, 3,
  &(vtc_dd4040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4040),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04040  : dd4040 {
  int e;
  ~ee04040(); // tgen
  ee04040(); // tgen
};
//SIG(1 ee04040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee04040 ::~ee04040(){ note_dtor("ee04040", this);} // tgen
ee04040 ::ee04040(){ note_ctor("ee04040", this);} // tgen

static void Test_ee04040()
{
  extern Class_Descriptor cd_ee04040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04040, buf);
    ee04040 *dp, &lv = *(dp=new (buf) ee04040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(8,4), "ee04040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), 0, "ee04040");
    check_base_class_offset(lv, (cc040*)(dd4040*), 0, "ee04040");
    check_base_class_offset(lv, (dd4040*), 0, "ee04040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee04040.e");
    test_class_info(&lv, &cd_ee04040);
    dp->~ee04040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04040(Test_ee04040, "ee04040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04040C1Ev();
extern void _ZN7ee04040D1Ev();
Name_Map name_map_ee04040[] = {
  NSPAIR(_ZN7ee04040C1Ev),
  NSPAIR(_ZN7ee04040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee04040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04040[];
extern void _ZN6dd40403barEv();
static  VTBL_ENTRY vtc_ee04040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee04040[0]),
  (VTBL_ENTRY)&_ZN6dd40403barEv,
};
extern VTBL_ENTRY _ZTI7ee04040[];
extern  VTBL_ENTRY _ZTV7ee04040[];
Class_Descriptor cd_ee04040 = {  "ee04040", // class name
  bases_ee04040, 4,
  &(vtc_ee04040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04040),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14040  : virtual dd4040 {
  int e;
  ~ee14040(); // tgen
  ee14040(); // tgen
};
//SIG(1 ee14040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee14040 ::~ee14040(){ note_dtor("ee14040", this);} // tgen
ee14040 ::ee14040(){ note_ctor("ee14040", this);} // tgen

static void Test_ee14040()
{
  extern Class_Descriptor cd_ee14040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14040, buf);
    ee14040 *dp, &lv = *(dp=new (buf) ee14040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(24,12), "ee14040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), ABISELECT(16,8), "ee14040");
    check_base_class_offset(lv, (cc040*)(dd4040*), ABISELECT(16,8), "ee14040");
    check_base_class_offset(lv, (dd4040*), ABISELECT(16,8), "ee14040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14040.e");
    test_class_info(&lv, &cd_ee14040);
    dp->~ee14040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14040(Test_ee14040, "ee14040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14040C1Ev();
extern void _ZN7ee14040D1Ev();
Name_Map name_map_ee14040[] = {
  NSPAIR(_ZN7ee14040C1Ev),
  NSPAIR(_ZN7ee14040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee14040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14040[];
extern void _ZN6dd40403barEv();
static  VTBL_ENTRY vtc_ee14040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14040[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14040[0]),
  (VTBL_ENTRY)&_ZN6dd40403barEv,
};
extern VTBL_ENTRY _ZTV7ee14040[];
static  VTT_ENTRY vtt_ee14040[] = {
  {&(_ZTV7ee14040[3]),  3,7},
  {&(_ZTV7ee14040[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee14040[];
extern  VTBL_ENTRY _ZTV7ee14040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14040[];
Class_Descriptor cd_ee14040 = {  "ee14040", // class name
  bases_ee14040, 4,
  &(vtc_ee14040[0]), // expected_vtbl_contents
  &(vtt_ee14040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14040),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24040  : dd4040 {
  int e;
  virtual void  foo(); // _ZN7ee240403fooEv
  ~ee24040(); // tgen
  ee24040(); // tgen
};
//SIG(1 ee24040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee24040 ::foo(){vfunc_called(this, "_ZN7ee240403fooEv");}
ee24040 ::~ee24040(){ note_dtor("ee24040", this);} // tgen
ee24040 ::ee24040(){ note_ctor("ee24040", this);} // tgen

static void Test_ee24040()
{
  extern Class_Descriptor cd_ee24040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24040, buf);
    ee24040 *dp, &lv = *(dp=new (buf) ee24040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(8,4), "ee24040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), 0, "ee24040");
    check_base_class_offset(lv, (cc040*)(dd4040*), 0, "ee24040");
    check_base_class_offset(lv, (dd4040*), 0, "ee24040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee24040.e");
    test_class_info(&lv, &cd_ee24040);
    dp->~ee24040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24040(Test_ee24040, "ee24040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24040C1Ev();
extern void _ZN7ee24040D1Ev();
Name_Map name_map_ee24040[] = {
  NSPAIR(_ZN7ee24040C1Ev),
  NSPAIR(_ZN7ee24040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee24040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24040[];
extern void _ZN6dd40403barEv();
extern void _ZN7ee240403fooEv();
static  VTBL_ENTRY vtc_ee24040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee24040[0]),
  (VTBL_ENTRY)&_ZN6dd40403barEv,
  (VTBL_ENTRY)&_ZN7ee240403fooEv,
};
extern VTBL_ENTRY _ZTI7ee24040[];
extern  VTBL_ENTRY _ZTV7ee24040[];
Class_Descriptor cd_ee24040 = {  "ee24040", // class name
  bases_ee24040, 4,
  &(vtc_ee24040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34040  : virtual dd4040 {
  int e;
  virtual void  foo(); // _ZN7ee340403fooEv
  ~ee34040(); // tgen
  ee34040(); // tgen
};
//SIG(1 ee34040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee34040 ::foo(){vfunc_called(this, "_ZN7ee340403fooEv");}
ee34040 ::~ee34040(){ note_dtor("ee34040", this);} // tgen
ee34040 ::ee34040(){ note_ctor("ee34040", this);} // tgen

static void Test_ee34040()
{
  extern Class_Descriptor cd_ee34040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34040, buf);
    ee34040 *dp, &lv = *(dp=new (buf) ee34040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(24,12), "ee34040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), ABISELECT(16,8), "ee34040");
    check_base_class_offset(lv, (cc040*)(dd4040*), ABISELECT(16,8), "ee34040");
    check_base_class_offset(lv, (dd4040*), ABISELECT(16,8), "ee34040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34040.e");
    test_class_info(&lv, &cd_ee34040);
    dp->~ee34040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34040(Test_ee34040, "ee34040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34040C1Ev();
extern void _ZN7ee34040D1Ev();
Name_Map name_map_ee34040[] = {
  NSPAIR(_ZN7ee34040C1Ev),
  NSPAIR(_ZN7ee34040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee34040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34040[];
extern void _ZN7ee340403fooEv();
extern void _ZN6dd40403barEv();
static  VTBL_ENTRY vtc_ee34040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34040[0]),
  (VTBL_ENTRY)&_ZN7ee340403fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34040[0]),
  (VTBL_ENTRY)&_ZN6dd40403barEv,
};
extern VTBL_ENTRY _ZTV7ee34040[];
static  VTT_ENTRY vtt_ee34040[] = {
  {&(_ZTV7ee34040[3]),  3,8},
  {&(_ZTV7ee34040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee34040[];
extern  VTBL_ENTRY _ZTV7ee34040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34040[];
Class_Descriptor cd_ee34040 = {  "ee34040", // class name
  bases_ee34040, 4,
  &(vtc_ee34040[0]), // expected_vtbl_contents
  &(vtt_ee34040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44040  : dd4040 {
  int e;
  virtual void  bar(); // _ZN7ee440403barEv
  ~ee44040(); // tgen
  ee44040(); // tgen
};
//SIG(1 ee44040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee44040 ::bar(){vfunc_called(this, "_ZN7ee440403barEv");}
ee44040 ::~ee44040(){ note_dtor("ee44040", this);} // tgen
ee44040 ::ee44040(){ note_ctor("ee44040", this);} // tgen

static void Test_ee44040()
{
  extern Class_Descriptor cd_ee44040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44040, buf);
    ee44040 *dp, &lv = *(dp=new (buf) ee44040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(8,4), "ee44040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), 0, "ee44040");
    check_base_class_offset(lv, (cc040*)(dd4040*), 0, "ee44040");
    check_base_class_offset(lv, (dd4040*), 0, "ee44040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee44040.e");
    test_class_info(&lv, &cd_ee44040);
    dp->~ee44040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44040(Test_ee44040, "ee44040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44040C1Ev();
extern void _ZN7ee44040D1Ev();
Name_Map name_map_ee44040[] = {
  NSPAIR(_ZN7ee44040C1Ev),
  NSPAIR(_ZN7ee44040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee44040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44040[];
extern void _ZN7ee440403barEv();
static  VTBL_ENTRY vtc_ee44040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee44040[0]),
  (VTBL_ENTRY)&_ZN7ee440403barEv,
};
extern VTBL_ENTRY _ZTI7ee44040[];
extern  VTBL_ENTRY _ZTV7ee44040[];
Class_Descriptor cd_ee44040 = {  "ee44040", // class name
  bases_ee44040, 4,
  &(vtc_ee44040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44040),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54040  : virtual dd4040 {
  int e;
  virtual void  bar(); // _ZN7ee540403barEv
  ~ee54040(); // tgen
  ee54040(); // tgen
};
//SIG(1 ee54040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee54040 ::bar(){vfunc_called(this, "_ZN7ee540403barEv");}
ee54040 ::~ee54040(){ note_dtor("ee54040", this);} // tgen
ee54040 ::ee54040(){ note_ctor("ee54040", this);} // tgen

static void Test_ee54040()
{
  extern Class_Descriptor cd_ee54040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54040, buf);
    ee54040 *dp, &lv = *(dp=new (buf) ee54040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(24,12), "ee54040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), ABISELECT(16,8), "ee54040");
    check_base_class_offset(lv, (cc040*)(dd4040*), ABISELECT(16,8), "ee54040");
    check_base_class_offset(lv, (dd4040*), ABISELECT(16,8), "ee54040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54040.e");
    test_class_info(&lv, &cd_ee54040);
    dp->~ee54040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54040(Test_ee54040, "ee54040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54040C1Ev();
extern void _ZN7ee54040D1Ev();
Name_Map name_map_ee54040[] = {
  NSPAIR(_ZN7ee54040C1Ev),
  NSPAIR(_ZN7ee54040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee54040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54040[];
extern void _ZN7ee540403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee540403barEv,_ZTv0_n12_N7ee540403barEv)();
extern void ABISELECT(_ZThn16_N7ee540403barEv,_ZThn8_N7ee540403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54040[0]),
  (VTBL_ENTRY)&_ZN7ee540403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee540403barEv,_ZTv0_n12_N7ee540403barEv),
};
extern VTBL_ENTRY _ZTV7ee54040[];
static  VTT_ENTRY vtt_ee54040[] = {
  {&(_ZTV7ee54040[3]),  3,8},
  {&(_ZTV7ee54040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee54040[];
extern  VTBL_ENTRY _ZTV7ee54040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54040[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee540403barEv,_ZTv0_n12_N7ee540403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540403barEv,_ZThn8_N7ee540403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54040 = {  "ee54040", // class name
  bases_ee54040, 4,
  &(vtc_ee54040[0]), // expected_vtbl_contents
  &(vtt_ee54040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64040  : dd4040 {
  int e;
  virtual void  foo(); // _ZN7ee640403fooEv
  virtual void  bar(); // _ZN7ee640403barEv
  ~ee64040(); // tgen
  ee64040(); // tgen
};
//SIG(1 ee64040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64040 ::foo(){vfunc_called(this, "_ZN7ee640403fooEv");}
void  ee64040 ::bar(){vfunc_called(this, "_ZN7ee640403barEv");}
ee64040 ::~ee64040(){ note_dtor("ee64040", this);} // tgen
ee64040 ::ee64040(){ note_ctor("ee64040", this);} // tgen

static void Test_ee64040()
{
  extern Class_Descriptor cd_ee64040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64040, buf);
    ee64040 *dp, &lv = *(dp=new (buf) ee64040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(8,4), "ee64040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), 0, "ee64040");
    check_base_class_offset(lv, (cc040*)(dd4040*), 0, "ee64040");
    check_base_class_offset(lv, (dd4040*), 0, "ee64040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee64040.e");
    test_class_info(&lv, &cd_ee64040);
    dp->~ee64040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64040(Test_ee64040, "ee64040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64040C1Ev();
extern void _ZN7ee64040D1Ev();
Name_Map name_map_ee64040[] = {
  NSPAIR(_ZN7ee64040C1Ev),
  NSPAIR(_ZN7ee64040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee64040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64040[];
extern void _ZN7ee640403barEv();
extern void _ZN7ee640403fooEv();
static  VTBL_ENTRY vtc_ee64040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee64040[0]),
  (VTBL_ENTRY)&_ZN7ee640403barEv,
  (VTBL_ENTRY)&_ZN7ee640403fooEv,
};
extern VTBL_ENTRY _ZTI7ee64040[];
extern  VTBL_ENTRY _ZTV7ee64040[];
Class_Descriptor cd_ee64040 = {  "ee64040", // class name
  bases_ee64040, 4,
  &(vtc_ee64040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74040  : virtual dd4040 {
  int e;
  virtual void  foo(); // _ZN7ee740403fooEv
  virtual void  bar(); // _ZN7ee740403barEv
  ~ee74040(); // tgen
  ee74040(); // tgen
};
//SIG(1 ee74040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74040 ::foo(){vfunc_called(this, "_ZN7ee740403fooEv");}
void  ee74040 ::bar(){vfunc_called(this, "_ZN7ee740403barEv");}
ee74040 ::~ee74040(){ note_dtor("ee74040", this);} // tgen
ee74040 ::ee74040(){ note_ctor("ee74040", this);} // tgen

static void Test_ee74040()
{
  extern Class_Descriptor cd_ee74040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74040, buf);
    ee74040 *dp, &lv = *(dp=new (buf) ee74040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd4040*), ABISELECT(24,12), "ee74040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd4040*), ABISELECT(16,8), "ee74040");
    check_base_class_offset(lv, (cc040*)(dd4040*), ABISELECT(16,8), "ee74040");
    check_base_class_offset(lv, (dd4040*), ABISELECT(16,8), "ee74040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74040.e");
    test_class_info(&lv, &cd_ee74040);
    dp->~ee74040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74040(Test_ee74040, "ee74040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74040C1Ev();
extern void _ZN7ee74040D1Ev();
Name_Map name_map_ee74040[] = {
  NSPAIR(_ZN7ee74040C1Ev),
  NSPAIR(_ZN7ee74040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd4040;
extern VTBL_ENTRY _ZTI6dd4040[];
extern  VTBL_ENTRY _ZTV6dd4040[];
static Base_Class bases_ee74040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74040[];
extern void _ZN7ee740403fooEv();
extern void _ZN7ee740403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee740403barEv,_ZTv0_n12_N7ee740403barEv)();
extern void ABISELECT(_ZThn16_N7ee740403barEv,_ZThn8_N7ee740403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74040[0]),
  (VTBL_ENTRY)&_ZN7ee740403fooEv,
  (VTBL_ENTRY)&_ZN7ee740403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee740403barEv,_ZTv0_n12_N7ee740403barEv),
};
extern VTBL_ENTRY _ZTV7ee74040[];
static  VTT_ENTRY vtt_ee74040[] = {
  {&(_ZTV7ee74040[3]),  3,9},
  {&(_ZTV7ee74040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee74040[];
extern  VTBL_ENTRY _ZTV7ee74040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74040[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee740403barEv,_ZTv0_n12_N7ee740403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740403barEv,_ZThn8_N7ee740403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74040 = {  "ee74040", // class name
  bases_ee74040, 4,
  &(vtc_ee74040[0]), // expected_vtbl_contents
  &(vtt_ee74040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5040  : virtual cc040 {
  int d;
  virtual void  bar(); // _ZN6dd50403barEv
  ~dd5040(); // tgen
  dd5040(); // tgen
};
//SIG(-1 dd5040) C1{ VBC2{ BC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd5040 ::bar(){vfunc_called(this, "_ZN6dd50403barEv");}
dd5040 ::~dd5040(){ note_dtor("dd5040", this);} // tgen
dd5040 ::dd5040(){ note_ctor("dd5040", this);} // tgen

static void Test_dd5040()
{
  extern Class_Descriptor cd_dd5040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5040, buf);
    dd5040 *dp, &lv = *(dp=new (buf) dd5040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,12), "dd5040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,8), "dd5040");
    check_base_class_offset(lv, (cc040*), ABISELECT(16,8), "dd5040");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5040.d");
    test_class_info(&lv, &cd_dd5040);
    dp->~dd5040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5040(Test_dd5040, "dd5040", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5040C1Ev();
extern void _ZN6dd5040D1Ev();
Name_Map name_map_dd5040[] = {
  NSPAIR(_ZN6dd5040C1Ev),
  NSPAIR(_ZN6dd5040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd5040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5040[];
extern void _ZN6dd50403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd5040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
extern VTBL_ENTRY _ZTV6dd5040[];
static  VTT_ENTRY vtt_dd5040[] = {
  {&(_ZTV6dd5040[3]),  3,8},
  {&(_ZTV6dd5040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5040 = {  "dd5040", // class name
  bases_dd5040, 3,
  &(vtc_dd5040[0]), // expected_vtbl_contents
  &(vtt_dd5040[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5040),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05040  : dd5040 {
  int e;
  ~ee05040(); // tgen
  ee05040(); // tgen
};
//SIG(1 ee05040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee05040 ::~ee05040(){ note_dtor("ee05040", this);} // tgen
ee05040 ::ee05040(){ note_ctor("ee05040", this);} // tgen

static void Test_ee05040()
{
  extern Class_Descriptor cd_ee05040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05040, buf);
    ee05040 *dp, &lv = *(dp=new (buf) ee05040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee05040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee05040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(16,12), "ee05040");
    check_base_class_offset(lv, (dd5040*), 0, "ee05040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05040.e");
    test_class_info(&lv, &cd_ee05040);
    dp->~ee05040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05040(Test_ee05040, "ee05040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05040C1Ev();
extern void _ZN7ee05040D1Ev();
Name_Map name_map_ee05040[] = {
  NSPAIR(_ZN7ee05040C1Ev),
  NSPAIR(_ZN7ee05040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee05040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05040[];
extern void _ZN6dd50403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee05040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
extern VTBL_ENTRY _ZTV7ee05040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee05040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee05040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee05040[] = {
  {&(_ZTV7ee05040[3]),  3,8},
  {&(_tg__ZTV6dd5040__7ee05040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee05040[3]),  3,4},
  {&(_ZTV7ee05040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee05040[];
extern  VTBL_ENTRY _ZTV7ee05040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05040[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05040 = {  "ee05040", // class name
  bases_ee05040, 4,
  &(vtc_ee05040[0]), // expected_vtbl_contents
  &(vtt_ee05040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15040  : virtual dd5040 {
  int e;
  ~ee15040(); // tgen
  ee15040(); // tgen
};
//SIG(1 ee15040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee15040 ::~ee15040(){ note_dtor("ee15040", this);} // tgen
ee15040 ::ee15040(){ note_ctor("ee15040", this);} // tgen

static void Test_ee15040()
{
  extern Class_Descriptor cd_ee15040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15040, buf);
    ee15040 *dp, &lv = *(dp=new (buf) ee15040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee15040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee15040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(32,16), "ee15040");
    check_base_class_offset(lv, (dd5040*), ABISELECT(16,8), "ee15040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15040.e");
    test_class_info(&lv, &cd_ee15040);
    dp->~ee15040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15040(Test_ee15040, "ee15040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15040C1Ev();
extern void _ZN7ee15040D1Ev();
Name_Map name_map_ee15040[] = {
  NSPAIR(_ZN7ee15040C1Ev),
  NSPAIR(_ZN7ee15040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee15040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15040[];
extern void _ZN6dd50403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee15040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15040[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
extern VTBL_ENTRY _ZTV7ee15040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee15040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee15040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee15040[] = {
  {&(_ZTV7ee15040[4]),  4,13},
  {&(_ZTV7ee15040[8]),  8,13},
  {&(_ZTV7ee15040[12]),  12,13},
  {&(_tg__ZTV6dd5040__7ee15040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee15040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15040[];
extern  VTBL_ENTRY _ZTV7ee15040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15040[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15040 = {  "ee15040", // class name
  bases_ee15040, 4,
  &(vtc_ee15040[0]), // expected_vtbl_contents
  &(vtt_ee15040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15040),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25040  : dd5040 {
  int e;
  virtual void  foo(); // _ZN7ee250403fooEv
  ~ee25040(); // tgen
  ee25040(); // tgen
};
//SIG(1 ee25040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee25040 ::foo(){vfunc_called(this, "_ZN7ee250403fooEv");}
ee25040 ::~ee25040(){ note_dtor("ee25040", this);} // tgen
ee25040 ::ee25040(){ note_ctor("ee25040", this);} // tgen

static void Test_ee25040()
{
  extern Class_Descriptor cd_ee25040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25040, buf);
    ee25040 *dp, &lv = *(dp=new (buf) ee25040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee25040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee25040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(16,12), "ee25040");
    check_base_class_offset(lv, (dd5040*), 0, "ee25040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25040.e");
    test_class_info(&lv, &cd_ee25040);
    dp->~ee25040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25040(Test_ee25040, "ee25040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25040C1Ev();
extern void _ZN7ee25040D1Ev();
Name_Map name_map_ee25040[] = {
  NSPAIR(_ZN7ee25040C1Ev),
  NSPAIR(_ZN7ee25040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee25040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25040[];
extern void _ZN6dd50403barEv();
extern void _ZN7ee250403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
  (VTBL_ENTRY)&_ZN7ee250403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
extern VTBL_ENTRY _ZTV7ee25040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee25040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee25040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee25040[] = {
  {&(_ZTV7ee25040[3]),  3,9},
  {&(_tg__ZTV6dd5040__7ee25040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee25040[3]),  3,4},
  {&(_ZTV7ee25040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee25040[];
extern  VTBL_ENTRY _ZTV7ee25040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25040[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25040 = {  "ee25040", // class name
  bases_ee25040, 4,
  &(vtc_ee25040[0]), // expected_vtbl_contents
  &(vtt_ee25040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35040  : virtual dd5040 {
  int e;
  virtual void  foo(); // _ZN7ee350403fooEv
  ~ee35040(); // tgen
  ee35040(); // tgen
};
//SIG(1 ee35040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee35040 ::foo(){vfunc_called(this, "_ZN7ee350403fooEv");}
ee35040 ::~ee35040(){ note_dtor("ee35040", this);} // tgen
ee35040 ::ee35040(){ note_ctor("ee35040", this);} // tgen

static void Test_ee35040()
{
  extern Class_Descriptor cd_ee35040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35040, buf);
    ee35040 *dp, &lv = *(dp=new (buf) ee35040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee35040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee35040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(32,16), "ee35040");
    check_base_class_offset(lv, (dd5040*), ABISELECT(16,8), "ee35040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35040.e");
    test_class_info(&lv, &cd_ee35040);
    dp->~ee35040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35040(Test_ee35040, "ee35040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35040C1Ev();
extern void _ZN7ee35040D1Ev();
Name_Map name_map_ee35040[] = {
  NSPAIR(_ZN7ee35040C1Ev),
  NSPAIR(_ZN7ee35040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee35040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35040[];
extern void _ZN7ee350403fooEv();
extern void _ZN6dd50403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35040[0]),
  (VTBL_ENTRY)&_ZN7ee350403fooEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
extern VTBL_ENTRY _ZTV7ee35040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee35040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee35040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee35040[] = {
  {&(_ZTV7ee35040[4]),  4,14},
  {&(_ZTV7ee35040[9]),  9,14},
  {&(_ZTV7ee35040[13]),  13,14},
  {&(_tg__ZTV6dd5040__7ee35040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee35040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35040[];
extern  VTBL_ENTRY _ZTV7ee35040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35040[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35040 = {  "ee35040", // class name
  bases_ee35040, 4,
  &(vtc_ee35040[0]), // expected_vtbl_contents
  &(vtt_ee35040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35040),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45040  : dd5040 {
  int e;
  virtual void  bar(); // _ZN7ee450403barEv
  ~ee45040(); // tgen
  ee45040(); // tgen
};
//SIG(1 ee45040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee45040 ::bar(){vfunc_called(this, "_ZN7ee450403barEv");}
ee45040 ::~ee45040(){ note_dtor("ee45040", this);} // tgen
ee45040 ::ee45040(){ note_ctor("ee45040", this);} // tgen

static void Test_ee45040()
{
  extern Class_Descriptor cd_ee45040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45040, buf);
    ee45040 *dp, &lv = *(dp=new (buf) ee45040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee45040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee45040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(16,12), "ee45040");
    check_base_class_offset(lv, (dd5040*), 0, "ee45040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45040.e");
    test_class_info(&lv, &cd_ee45040);
    dp->~ee45040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45040(Test_ee45040, "ee45040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45040C1Ev();
extern void _ZN7ee45040D1Ev();
Name_Map name_map_ee45040[] = {
  NSPAIR(_ZN7ee45040C1Ev),
  NSPAIR(_ZN7ee45040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee45040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45040[];
extern void _ZN7ee450403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee450403barEv,_ZTv0_n12_N7ee450403barEv)();
extern void ABISELECT(_ZThn16_N7ee450403barEv,_ZThn12_N7ee450403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee45040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45040[0]),
  (VTBL_ENTRY)&_ZN7ee450403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee450403barEv,_ZTv0_n12_N7ee450403barEv),
};
extern VTBL_ENTRY _ZTV7ee45040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee45040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee45040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee45040[] = {
  {&(_ZTV7ee45040[3]),  3,8},
  {&(_tg__ZTV6dd5040__7ee45040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee45040[3]),  3,4},
  {&(_ZTV7ee45040[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee45040[];
extern  VTBL_ENTRY _ZTV7ee45040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45040[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee450403barEv,_ZTv0_n12_N7ee450403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee450403barEv,_ZThn12_N7ee450403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45040 = {  "ee45040", // class name
  bases_ee45040, 4,
  &(vtc_ee45040[0]), // expected_vtbl_contents
  &(vtt_ee45040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45040),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55040  : virtual dd5040 {
  int e;
  virtual void  bar(); // _ZN7ee550403barEv
  ~ee55040(); // tgen
  ee55040(); // tgen
};
//SIG(1 ee55040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee55040 ::bar(){vfunc_called(this, "_ZN7ee550403barEv");}
ee55040 ::~ee55040(){ note_dtor("ee55040", this);} // tgen
ee55040 ::ee55040(){ note_ctor("ee55040", this);} // tgen

static void Test_ee55040()
{
  extern Class_Descriptor cd_ee55040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55040, buf);
    ee55040 *dp, &lv = *(dp=new (buf) ee55040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee55040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee55040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(32,16), "ee55040");
    check_base_class_offset(lv, (dd5040*), ABISELECT(16,8), "ee55040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55040.e");
    test_class_info(&lv, &cd_ee55040);
    dp->~ee55040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55040(Test_ee55040, "ee55040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55040C1Ev();
extern void _ZN7ee55040D1Ev();
Name_Map name_map_ee55040[] = {
  NSPAIR(_ZN7ee55040C1Ev),
  NSPAIR(_ZN7ee55040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee55040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55040[];
extern void _ZN7ee550403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee550403barEv,_ZTv0_n16_N7ee550403barEv)();
extern void ABISELECT(_ZThn16_N7ee550403barEv,_ZThn8_N7ee550403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee550403barEv,_ZTv0_n12_N7ee550403barEv)();
extern void ABISELECT(_ZThn32_N7ee550403barEv,_ZThn16_N7ee550403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55040[0]),
  (VTBL_ENTRY)&_ZN7ee550403barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee550403barEv,_ZTv0_n16_N7ee550403barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee550403barEv,_ZTv0_n12_N7ee550403barEv),
};
extern VTBL_ENTRY _ZTV7ee55040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee55040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee55040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee55040[] = {
  {&(_ZTV7ee55040[4]),  4,14},
  {&(_ZTV7ee55040[9]),  9,14},
  {&(_ZTV7ee55040[13]),  13,14},
  {&(_tg__ZTV6dd5040__7ee55040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee55040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55040[];
extern  VTBL_ENTRY _ZTV7ee55040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55040[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee550403barEv,_ZTv0_n12_N7ee550403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee550403barEv,_ZThn16_N7ee550403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee550403barEv,_ZTv0_n16_N7ee550403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550403barEv,_ZThn8_N7ee550403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55040 = {  "ee55040", // class name
  bases_ee55040, 4,
  &(vtc_ee55040[0]), // expected_vtbl_contents
  &(vtt_ee55040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55040),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65040  : dd5040 {
  int e;
  virtual void  foo(); // _ZN7ee650403fooEv
  virtual void  bar(); // _ZN7ee650403barEv
  ~ee65040(); // tgen
  ee65040(); // tgen
};
//SIG(1 ee65040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65040 ::foo(){vfunc_called(this, "_ZN7ee650403fooEv");}
void  ee65040 ::bar(){vfunc_called(this, "_ZN7ee650403barEv");}
ee65040 ::~ee65040(){ note_dtor("ee65040", this);} // tgen
ee65040 ::ee65040(){ note_ctor("ee65040", this);} // tgen

static void Test_ee65040()
{
  extern Class_Descriptor cd_ee65040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65040, buf);
    ee65040 *dp, &lv = *(dp=new (buf) ee65040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee65040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee65040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(16,12), "ee65040");
    check_base_class_offset(lv, (dd5040*), 0, "ee65040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65040.e");
    test_class_info(&lv, &cd_ee65040);
    dp->~ee65040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65040(Test_ee65040, "ee65040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65040C1Ev();
extern void _ZN7ee65040D1Ev();
Name_Map name_map_ee65040[] = {
  NSPAIR(_ZN7ee65040C1Ev),
  NSPAIR(_ZN7ee65040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee65040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65040[];
extern void _ZN7ee650403barEv();
extern void _ZN7ee650403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee650403barEv,_ZTv0_n12_N7ee650403barEv)();
extern void ABISELECT(_ZThn16_N7ee650403barEv,_ZThn12_N7ee650403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65040[0]),
  (VTBL_ENTRY)&_ZN7ee650403barEv,
  (VTBL_ENTRY)&_ZN7ee650403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee650403barEv,_ZTv0_n12_N7ee650403barEv),
};
extern VTBL_ENTRY _ZTV7ee65040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee65040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee65040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee65040[] = {
  {&(_ZTV7ee65040[3]),  3,9},
  {&(_tg__ZTV6dd5040__7ee65040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee65040[3]),  3,4},
  {&(_ZTV7ee65040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee65040[];
extern  VTBL_ENTRY _ZTV7ee65040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65040[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn12_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee650403barEv,_ZTv0_n12_N7ee650403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650403barEv,_ZThn12_N7ee650403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65040 = {  "ee65040", // class name
  bases_ee65040, 4,
  &(vtc_ee65040[0]), // expected_vtbl_contents
  &(vtt_ee65040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75040  : virtual dd5040 {
  int e;
  virtual void  foo(); // _ZN7ee750403fooEv
  virtual void  bar(); // _ZN7ee750403barEv
  ~ee75040(); // tgen
  ee75040(); // tgen
};
//SIG(1 ee75040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75040 ::foo(){vfunc_called(this, "_ZN7ee750403fooEv");}
void  ee75040 ::bar(){vfunc_called(this, "_ZN7ee750403barEv");}
ee75040 ::~ee75040(){ note_dtor("ee75040", this);} // tgen
ee75040 ::ee75040(){ note_ctor("ee75040", this);} // tgen

static void Test_ee75040()
{
  extern Class_Descriptor cd_ee75040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75040, buf);
    ee75040 *dp, &lv = *(dp=new (buf) ee75040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee75040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee75040");
    check_base_class_offset(lv, (cc040*)(dd5040*), ABISELECT(32,16), "ee75040");
    check_base_class_offset(lv, (dd5040*), ABISELECT(16,8), "ee75040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75040.e");
    test_class_info(&lv, &cd_ee75040);
    dp->~ee75040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75040(Test_ee75040, "ee75040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75040C1Ev();
extern void _ZN7ee75040D1Ev();
Name_Map name_map_ee75040[] = {
  NSPAIR(_ZN7ee75040C1Ev),
  NSPAIR(_ZN7ee75040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd5040;
extern VTBL_ENTRY _ZTI6dd5040[];
extern  VTBL_ENTRY _ZTV6dd5040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5040[];
static Base_Class bases_ee75040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5040,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75040[];
extern void _ZN7ee750403fooEv();
extern void _ZN7ee750403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee750403barEv,_ZTv0_n16_N7ee750403barEv)();
extern void ABISELECT(_ZThn16_N7ee750403barEv,_ZThn8_N7ee750403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee750403barEv,_ZTv0_n12_N7ee750403barEv)();
extern void ABISELECT(_ZThn32_N7ee750403barEv,_ZThn16_N7ee750403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75040[0]),
  (VTBL_ENTRY)&_ZN7ee750403fooEv,
  (VTBL_ENTRY)&_ZN7ee750403barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750403barEv,_ZTv0_n16_N7ee750403barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee750403barEv,_ZTv0_n12_N7ee750403barEv),
};
extern VTBL_ENTRY _ZTV7ee75040[];
extern void _ZN6dd50403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5040__7ee75040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&_ZN6dd50403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv)();
extern void ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd5040__7ee75040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv),
};
static  VTT_ENTRY vtt_ee75040[] = {
  {&(_ZTV7ee75040[4]),  4,15},
  {&(_ZTV7ee75040[10]),  10,15},
  {&(_ZTV7ee75040[14]),  14,15},
  {&(_tg__ZTV6dd5040__7ee75040[3]),  3,4},
  {&(_tg__ZTV4bb405cc040__6dd5040__7ee75040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75040[];
extern  VTBL_ENTRY _ZTV7ee75040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75040[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd50403barEv,_ZTv0_n12_N6dd50403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd50403barEv,_ZThn8_N6dd50403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee750403barEv,_ZTv0_n12_N7ee750403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750403barEv,_ZThn16_N7ee750403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750403barEv,_ZTv0_n16_N7ee750403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750403barEv,_ZThn8_N7ee750403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75040 = {  "ee75040", // class name
  bases_ee75040, 4,
  &(vtc_ee75040[0]), // expected_vtbl_contents
  &(vtt_ee75040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75040),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6040  : cc040 {
  int d;
  virtual void  bar(); // _ZN6dd60403barEv
  virtual void  foo(); // _ZN6dd60403fooEv
  ~dd6040(); // tgen
  dd6040(); // tgen
};
//SIG(-1 dd6040) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd6040 ::bar(){vfunc_called(this, "_ZN6dd60403barEv");}
void  dd6040 ::foo(){vfunc_called(this, "_ZN6dd60403fooEv");}
dd6040 ::~dd6040(){ note_dtor("dd6040", this);} // tgen
dd6040 ::dd6040(){ note_ctor("dd6040", this);} // tgen

static void Test_dd6040()
{
  extern Class_Descriptor cd_dd6040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6040, buf);
    dd6040 *dp, &lv = *(dp=new (buf) dd6040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(8,4), "dd6040");
    check_base_class_offset(lv, (bb40*)(cc040*), 0, "dd6040");
    check_base_class_offset(lv, (cc040*), 0, "dd6040");
    check_field_offset(lv, d, ABISELECT(20,16), "dd6040.d");
    test_class_info(&lv, &cd_dd6040);
    dp->~dd6040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6040(Test_dd6040, "dd6040", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6040C1Ev();
extern void _ZN6dd6040D1Ev();
Name_Map name_map_dd6040[] = {
  NSPAIR(_ZN6dd6040C1Ev),
  NSPAIR(_ZN6dd6040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd6040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6040[];
extern void _ZN6dd60403barEv();
extern void _ZN6dd60403fooEv();
static  VTBL_ENTRY vtc_dd6040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd6040[0]),
  (VTBL_ENTRY)&_ZN6dd60403barEv,
  (VTBL_ENTRY)&_ZN6dd60403fooEv,
};
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
Class_Descriptor cd_dd6040 = {  "dd6040", // class name
  bases_dd6040, 3,
  &(vtc_dd6040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06040  : dd6040 {
  int e;
  ~ee06040(); // tgen
  ee06040(); // tgen
};
//SIG(1 ee06040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee06040 ::~ee06040(){ note_dtor("ee06040", this);} // tgen
ee06040 ::ee06040(){ note_ctor("ee06040", this);} // tgen

static void Test_ee06040()
{
  extern Class_Descriptor cd_ee06040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06040, buf);
    ee06040 *dp, &lv = *(dp=new (buf) ee06040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(8,4), "ee06040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), 0, "ee06040");
    check_base_class_offset(lv, (cc040*)(dd6040*), 0, "ee06040");
    check_base_class_offset(lv, (dd6040*), 0, "ee06040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee06040.e");
    test_class_info(&lv, &cd_ee06040);
    dp->~ee06040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06040(Test_ee06040, "ee06040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06040C1Ev();
extern void _ZN7ee06040D1Ev();
Name_Map name_map_ee06040[] = {
  NSPAIR(_ZN7ee06040C1Ev),
  NSPAIR(_ZN7ee06040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee06040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06040[];
extern void _ZN6dd60403barEv();
extern void _ZN6dd60403fooEv();
static  VTBL_ENTRY vtc_ee06040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee06040[0]),
  (VTBL_ENTRY)&_ZN6dd60403barEv,
  (VTBL_ENTRY)&_ZN6dd60403fooEv,
};
extern VTBL_ENTRY _ZTI7ee06040[];
extern  VTBL_ENTRY _ZTV7ee06040[];
Class_Descriptor cd_ee06040 = {  "ee06040", // class name
  bases_ee06040, 4,
  &(vtc_ee06040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16040  : virtual dd6040 {
  int e;
  ~ee16040(); // tgen
  ee16040(); // tgen
};
//SIG(1 ee16040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee16040 ::~ee16040(){ note_dtor("ee16040", this);} // tgen
ee16040 ::ee16040(){ note_ctor("ee16040", this);} // tgen

static void Test_ee16040()
{
  extern Class_Descriptor cd_ee16040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16040, buf);
    ee16040 *dp, &lv = *(dp=new (buf) ee16040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(24,12), "ee16040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), ABISELECT(16,8), "ee16040");
    check_base_class_offset(lv, (cc040*)(dd6040*), ABISELECT(16,8), "ee16040");
    check_base_class_offset(lv, (dd6040*), ABISELECT(16,8), "ee16040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16040.e");
    test_class_info(&lv, &cd_ee16040);
    dp->~ee16040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16040(Test_ee16040, "ee16040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16040C1Ev();
extern void _ZN7ee16040D1Ev();
Name_Map name_map_ee16040[] = {
  NSPAIR(_ZN7ee16040C1Ev),
  NSPAIR(_ZN7ee16040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee16040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16040[];
extern void _ZN6dd60403barEv();
extern void _ZN6dd60403fooEv();
static  VTBL_ENTRY vtc_ee16040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16040[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16040[0]),
  (VTBL_ENTRY)&_ZN6dd60403barEv,
  (VTBL_ENTRY)&_ZN6dd60403fooEv,
};
extern VTBL_ENTRY _ZTV7ee16040[];
static  VTT_ENTRY vtt_ee16040[] = {
  {&(_ZTV7ee16040[3]),  3,9},
  {&(_ZTV7ee16040[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee16040[];
extern  VTBL_ENTRY _ZTV7ee16040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16040[];
Class_Descriptor cd_ee16040 = {  "ee16040", // class name
  bases_ee16040, 4,
  &(vtc_ee16040[0]), // expected_vtbl_contents
  &(vtt_ee16040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26040  : dd6040 {
  int e;
  virtual void  foo(); // _ZN7ee260403fooEv
  ~ee26040(); // tgen
  ee26040(); // tgen
};
//SIG(1 ee26040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26040 ::foo(){vfunc_called(this, "_ZN7ee260403fooEv");}
ee26040 ::~ee26040(){ note_dtor("ee26040", this);} // tgen
ee26040 ::ee26040(){ note_ctor("ee26040", this);} // tgen

static void Test_ee26040()
{
  extern Class_Descriptor cd_ee26040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26040, buf);
    ee26040 *dp, &lv = *(dp=new (buf) ee26040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(8,4), "ee26040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), 0, "ee26040");
    check_base_class_offset(lv, (cc040*)(dd6040*), 0, "ee26040");
    check_base_class_offset(lv, (dd6040*), 0, "ee26040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee26040.e");
    test_class_info(&lv, &cd_ee26040);
    dp->~ee26040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26040(Test_ee26040, "ee26040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26040C1Ev();
extern void _ZN7ee26040D1Ev();
Name_Map name_map_ee26040[] = {
  NSPAIR(_ZN7ee26040C1Ev),
  NSPAIR(_ZN7ee26040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee26040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26040[];
extern void _ZN6dd60403barEv();
extern void _ZN7ee260403fooEv();
static  VTBL_ENTRY vtc_ee26040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee26040[0]),
  (VTBL_ENTRY)&_ZN6dd60403barEv,
  (VTBL_ENTRY)&_ZN7ee260403fooEv,
};
extern VTBL_ENTRY _ZTI7ee26040[];
extern  VTBL_ENTRY _ZTV7ee26040[];
Class_Descriptor cd_ee26040 = {  "ee26040", // class name
  bases_ee26040, 4,
  &(vtc_ee26040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36040  : virtual dd6040 {
  int e;
  virtual void  foo(); // _ZN7ee360403fooEv
  ~ee36040(); // tgen
  ee36040(); // tgen
};
//SIG(1 ee36040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36040 ::foo(){vfunc_called(this, "_ZN7ee360403fooEv");}
ee36040 ::~ee36040(){ note_dtor("ee36040", this);} // tgen
ee36040 ::ee36040(){ note_ctor("ee36040", this);} // tgen

static void Test_ee36040()
{
  extern Class_Descriptor cd_ee36040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36040, buf);
    ee36040 *dp, &lv = *(dp=new (buf) ee36040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(24,12), "ee36040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), ABISELECT(16,8), "ee36040");
    check_base_class_offset(lv, (cc040*)(dd6040*), ABISELECT(16,8), "ee36040");
    check_base_class_offset(lv, (dd6040*), ABISELECT(16,8), "ee36040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36040.e");
    test_class_info(&lv, &cd_ee36040);
    dp->~ee36040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36040(Test_ee36040, "ee36040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36040C1Ev();
extern void _ZN7ee36040D1Ev();
Name_Map name_map_ee36040[] = {
  NSPAIR(_ZN7ee36040C1Ev),
  NSPAIR(_ZN7ee36040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee36040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36040[];
extern void _ZN7ee360403fooEv();
extern void _ZN6dd60403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee360403fooEv,_ZTv0_n16_N7ee360403fooEv)();
extern void ABISELECT(_ZThn16_N7ee360403fooEv,_ZThn8_N7ee360403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36040[0]),
  (VTBL_ENTRY)&_ZN7ee360403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36040[0]),
  (VTBL_ENTRY)&_ZN6dd60403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee360403fooEv,_ZTv0_n16_N7ee360403fooEv),
};
extern VTBL_ENTRY _ZTV7ee36040[];
static  VTT_ENTRY vtt_ee36040[] = {
  {&(_ZTV7ee36040[3]),  3,10},
  {&(_ZTV7ee36040[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee36040[];
extern  VTBL_ENTRY _ZTV7ee36040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36040[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee360403fooEv,_ZTv0_n16_N7ee360403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360403fooEv,_ZThn8_N7ee360403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36040 = {  "ee36040", // class name
  bases_ee36040, 4,
  &(vtc_ee36040[0]), // expected_vtbl_contents
  &(vtt_ee36040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36040),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46040  : dd6040 {
  int e;
  virtual void  bar(); // _ZN7ee460403barEv
  ~ee46040(); // tgen
  ee46040(); // tgen
};
//SIG(1 ee46040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46040 ::bar(){vfunc_called(this, "_ZN7ee460403barEv");}
ee46040 ::~ee46040(){ note_dtor("ee46040", this);} // tgen
ee46040 ::ee46040(){ note_ctor("ee46040", this);} // tgen

static void Test_ee46040()
{
  extern Class_Descriptor cd_ee46040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46040, buf);
    ee46040 *dp, &lv = *(dp=new (buf) ee46040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(8,4), "ee46040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), 0, "ee46040");
    check_base_class_offset(lv, (cc040*)(dd6040*), 0, "ee46040");
    check_base_class_offset(lv, (dd6040*), 0, "ee46040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee46040.e");
    test_class_info(&lv, &cd_ee46040);
    dp->~ee46040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46040(Test_ee46040, "ee46040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46040C1Ev();
extern void _ZN7ee46040D1Ev();
Name_Map name_map_ee46040[] = {
  NSPAIR(_ZN7ee46040C1Ev),
  NSPAIR(_ZN7ee46040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee46040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46040[];
extern void _ZN7ee460403barEv();
extern void _ZN6dd60403fooEv();
static  VTBL_ENTRY vtc_ee46040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee46040[0]),
  (VTBL_ENTRY)&_ZN7ee460403barEv,
  (VTBL_ENTRY)&_ZN6dd60403fooEv,
};
extern VTBL_ENTRY _ZTI7ee46040[];
extern  VTBL_ENTRY _ZTV7ee46040[];
Class_Descriptor cd_ee46040 = {  "ee46040", // class name
  bases_ee46040, 4,
  &(vtc_ee46040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56040  : virtual dd6040 {
  int e;
  virtual void  bar(); // _ZN7ee560403barEv
  ~ee56040(); // tgen
  ee56040(); // tgen
};
//SIG(1 ee56040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56040 ::bar(){vfunc_called(this, "_ZN7ee560403barEv");}
ee56040 ::~ee56040(){ note_dtor("ee56040", this);} // tgen
ee56040 ::ee56040(){ note_ctor("ee56040", this);} // tgen

static void Test_ee56040()
{
  extern Class_Descriptor cd_ee56040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56040, buf);
    ee56040 *dp, &lv = *(dp=new (buf) ee56040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(24,12), "ee56040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), ABISELECT(16,8), "ee56040");
    check_base_class_offset(lv, (cc040*)(dd6040*), ABISELECT(16,8), "ee56040");
    check_base_class_offset(lv, (dd6040*), ABISELECT(16,8), "ee56040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56040.e");
    test_class_info(&lv, &cd_ee56040);
    dp->~ee56040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56040(Test_ee56040, "ee56040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56040C1Ev();
extern void _ZN7ee56040D1Ev();
Name_Map name_map_ee56040[] = {
  NSPAIR(_ZN7ee56040C1Ev),
  NSPAIR(_ZN7ee56040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee56040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56040[];
extern void _ZN7ee560403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee560403barEv,_ZTv0_n12_N7ee560403barEv)();
extern void ABISELECT(_ZThn16_N7ee560403barEv,_ZThn8_N7ee560403barEv)() __attribute__((weak));
extern void _ZN6dd60403fooEv();
static  VTBL_ENTRY vtc_ee56040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56040[0]),
  (VTBL_ENTRY)&_ZN7ee560403barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee560403barEv,_ZTv0_n12_N7ee560403barEv),
  (VTBL_ENTRY)&_ZN6dd60403fooEv,
};
extern VTBL_ENTRY _ZTV7ee56040[];
static  VTT_ENTRY vtt_ee56040[] = {
  {&(_ZTV7ee56040[3]),  3,10},
  {&(_ZTV7ee56040[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee56040[];
extern  VTBL_ENTRY _ZTV7ee56040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56040[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee560403barEv,_ZTv0_n12_N7ee560403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560403barEv,_ZThn8_N7ee560403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56040 = {  "ee56040", // class name
  bases_ee56040, 4,
  &(vtc_ee56040[0]), // expected_vtbl_contents
  &(vtt_ee56040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56040),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66040  : dd6040 {
  int e;
  virtual void  foo(); // _ZN7ee660403fooEv
  virtual void  bar(); // _ZN7ee660403barEv
  ~ee66040(); // tgen
  ee66040(); // tgen
};
//SIG(1 ee66040) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66040 ::foo(){vfunc_called(this, "_ZN7ee660403fooEv");}
void  ee66040 ::bar(){vfunc_called(this, "_ZN7ee660403barEv");}
ee66040 ::~ee66040(){ note_dtor("ee66040", this);} // tgen
ee66040 ::ee66040(){ note_ctor("ee66040", this);} // tgen

static void Test_ee66040()
{
  extern Class_Descriptor cd_ee66040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66040, buf);
    ee66040 *dp, &lv = *(dp=new (buf) ee66040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(8,4), "ee66040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), 0, "ee66040");
    check_base_class_offset(lv, (cc040*)(dd6040*), 0, "ee66040");
    check_base_class_offset(lv, (dd6040*), 0, "ee66040");
    check_field_offset(lv, e, ABISELECT(24,20), "ee66040.e");
    test_class_info(&lv, &cd_ee66040);
    dp->~ee66040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66040(Test_ee66040, "ee66040", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66040C1Ev();
extern void _ZN7ee66040D1Ev();
Name_Map name_map_ee66040[] = {
  NSPAIR(_ZN7ee66040C1Ev),
  NSPAIR(_ZN7ee66040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee66040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66040[];
extern void _ZN7ee660403barEv();
extern void _ZN7ee660403fooEv();
static  VTBL_ENTRY vtc_ee66040[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee66040[0]),
  (VTBL_ENTRY)&_ZN7ee660403barEv,
  (VTBL_ENTRY)&_ZN7ee660403fooEv,
};
extern VTBL_ENTRY _ZTI7ee66040[];
extern  VTBL_ENTRY _ZTV7ee66040[];
Class_Descriptor cd_ee66040 = {  "ee66040", // class name
  bases_ee66040, 4,
  &(vtc_ee66040[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66040),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76040  : virtual dd6040 {
  int e;
  virtual void  foo(); // _ZN7ee760403fooEv
  virtual void  bar(); // _ZN7ee760403barEv
  ~ee76040(); // tgen
  ee76040(); // tgen
};
//SIG(1 ee76040) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76040 ::foo(){vfunc_called(this, "_ZN7ee760403fooEv");}
void  ee76040 ::bar(){vfunc_called(this, "_ZN7ee760403barEv");}
ee76040 ::~ee76040(){ note_dtor("ee76040", this);} // tgen
ee76040 ::ee76040(){ note_ctor("ee76040", this);} // tgen

static void Test_ee76040()
{
  extern Class_Descriptor cd_ee76040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76040, buf);
    ee76040 *dp, &lv = *(dp=new (buf) ee76040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*)(dd6040*), ABISELECT(24,12), "ee76040");
    check_base_class_offset(lv, (bb40*)(cc040*)(dd6040*), ABISELECT(16,8), "ee76040");
    check_base_class_offset(lv, (cc040*)(dd6040*), ABISELECT(16,8), "ee76040");
    check_base_class_offset(lv, (dd6040*), ABISELECT(16,8), "ee76040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76040.e");
    test_class_info(&lv, &cd_ee76040);
    dp->~ee76040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76040(Test_ee76040, "ee76040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76040C1Ev();
extern void _ZN7ee76040D1Ev();
Name_Map name_map_ee76040[] = {
  NSPAIR(_ZN7ee76040C1Ev),
  NSPAIR(_ZN7ee76040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd6040;
extern VTBL_ENTRY _ZTI6dd6040[];
extern  VTBL_ENTRY _ZTV6dd6040[];
static Base_Class bases_ee76040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76040[];
extern void _ZN7ee760403fooEv();
extern void _ZN7ee760403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee760403barEv,_ZTv0_n12_N7ee760403barEv)();
extern void ABISELECT(_ZThn16_N7ee760403barEv,_ZThn8_N7ee760403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee760403fooEv,_ZTv0_n16_N7ee760403fooEv)();
extern void ABISELECT(_ZThn16_N7ee760403fooEv,_ZThn8_N7ee760403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76040[0]),
  (VTBL_ENTRY)&_ZN7ee760403fooEv,
  (VTBL_ENTRY)&_ZN7ee760403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee760403barEv,_ZTv0_n12_N7ee760403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760403fooEv,_ZTv0_n16_N7ee760403fooEv),
};
extern VTBL_ENTRY _ZTV7ee76040[];
static  VTT_ENTRY vtt_ee76040[] = {
  {&(_ZTV7ee76040[3]),  3,11},
  {&(_ZTV7ee76040[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee76040[];
extern  VTBL_ENTRY _ZTV7ee76040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76040[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760403fooEv,_ZTv0_n16_N7ee760403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760403fooEv,_ZThn8_N7ee760403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee760403barEv,_ZTv0_n12_N7ee760403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760403barEv,_ZThn8_N7ee760403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76040 = {  "ee76040", // class name
  bases_ee76040, 4,
  &(vtc_ee76040[0]), // expected_vtbl_contents
  &(vtt_ee76040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76040),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76040),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7040  : virtual cc040 {
  int d;
  virtual void  bar(); // _ZN6dd70403barEv
  virtual void  foo(); // _ZN6dd70403fooEv
  ~dd7040(); // tgen
  dd7040(); // tgen
};
//SIG(-1 dd7040) C1{ VBC2{ BC3{ BC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd7040 ::bar(){vfunc_called(this, "_ZN6dd70403barEv");}
void  dd7040 ::foo(){vfunc_called(this, "_ZN6dd70403fooEv");}
dd7040 ::~dd7040(){ note_dtor("dd7040", this);} // tgen
dd7040 ::dd7040(){ note_ctor("dd7040", this);} // tgen

static void Test_dd7040()
{
  extern Class_Descriptor cd_dd7040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7040, buf);
    dd7040 *dp, &lv = *(dp=new (buf) dd7040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,12), "dd7040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,8), "dd7040");
    check_base_class_offset(lv, (cc040*), ABISELECT(16,8), "dd7040");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7040.d");
    test_class_info(&lv, &cd_dd7040);
    dp->~dd7040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7040(Test_dd7040, "dd7040", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7040C1Ev();
extern void _ZN6dd7040D1Ev();
Name_Map name_map_dd7040[] = {
  NSPAIR(_ZN6dd7040C1Ev),
  NSPAIR(_ZN6dd7040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
static Base_Class bases_dd7040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
extern VTBL_ENTRY _ZTV6dd7040[];
static  VTT_ENTRY vtt_dd7040[] = {
  {&(_ZTV6dd7040[3]),  3,9},
  {&(_ZTV6dd7040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7040 = {  "dd7040", // class name
  bases_dd7040, 3,
  &(vtc_dd7040[0]), // expected_vtbl_contents
  &(vtt_dd7040[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7040),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07040  : dd7040 {
  int e;
  ~ee07040(); // tgen
  ee07040(); // tgen
};
//SIG(1 ee07040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee07040 ::~ee07040(){ note_dtor("ee07040", this);} // tgen
ee07040 ::ee07040(){ note_ctor("ee07040", this);} // tgen

static void Test_ee07040()
{
  extern Class_Descriptor cd_ee07040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07040, buf);
    ee07040 *dp, &lv = *(dp=new (buf) ee07040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee07040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee07040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(16,12), "ee07040");
    check_base_class_offset(lv, (dd7040*), 0, "ee07040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07040.e");
    test_class_info(&lv, &cd_ee07040);
    dp->~ee07040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07040(Test_ee07040, "ee07040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07040C1Ev();
extern void _ZN7ee07040D1Ev();
Name_Map name_map_ee07040[] = {
  NSPAIR(_ZN7ee07040C1Ev),
  NSPAIR(_ZN7ee07040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee07040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
extern VTBL_ENTRY _ZTV7ee07040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee07040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee07040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee07040[] = {
  {&(_ZTV7ee07040[3]),  3,9},
  {&(_tg__ZTV6dd7040__7ee07040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee07040[3]),  3,4},
  {&(_ZTV7ee07040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee07040[];
extern  VTBL_ENTRY _ZTV7ee07040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07040[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07040 = {  "ee07040", // class name
  bases_ee07040, 4,
  &(vtc_ee07040[0]), // expected_vtbl_contents
  &(vtt_ee07040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17040  : virtual dd7040 {
  int e;
  ~ee17040(); // tgen
  ee17040(); // tgen
};
//SIG(1 ee17040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee17040 ::~ee17040(){ note_dtor("ee17040", this);} // tgen
ee17040 ::ee17040(){ note_ctor("ee17040", this);} // tgen

static void Test_ee17040()
{
  extern Class_Descriptor cd_ee17040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17040, buf);
    ee17040 *dp, &lv = *(dp=new (buf) ee17040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee17040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee17040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(32,16), "ee17040");
    check_base_class_offset(lv, (dd7040*), ABISELECT(16,8), "ee17040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17040.e");
    test_class_info(&lv, &cd_ee17040);
    dp->~ee17040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17040(Test_ee17040, "ee17040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17040C1Ev();
extern void _ZN7ee17040D1Ev();
Name_Map name_map_ee17040[] = {
  NSPAIR(_ZN7ee17040C1Ev),
  NSPAIR(_ZN7ee17040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee17040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17040[0]),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
extern VTBL_ENTRY _ZTV7ee17040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee17040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee17040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee17040[] = {
  {&(_ZTV7ee17040[4]),  4,15},
  {&(_ZTV7ee17040[9]),  9,15},
  {&(_ZTV7ee17040[14]),  14,15},
  {&(_tg__ZTV6dd7040__7ee17040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee17040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17040[];
extern  VTBL_ENTRY _ZTV7ee17040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17040[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17040 = {  "ee17040", // class name
  bases_ee17040, 4,
  &(vtc_ee17040[0]), // expected_vtbl_contents
  &(vtt_ee17040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17040),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27040  : dd7040 {
  int e;
  virtual void  foo(); // _ZN7ee270403fooEv
  ~ee27040(); // tgen
  ee27040(); // tgen
};
//SIG(1 ee27040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27040 ::foo(){vfunc_called(this, "_ZN7ee270403fooEv");}
ee27040 ::~ee27040(){ note_dtor("ee27040", this);} // tgen
ee27040 ::ee27040(){ note_ctor("ee27040", this);} // tgen

static void Test_ee27040()
{
  extern Class_Descriptor cd_ee27040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27040, buf);
    ee27040 *dp, &lv = *(dp=new (buf) ee27040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee27040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee27040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(16,12), "ee27040");
    check_base_class_offset(lv, (dd7040*), 0, "ee27040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27040.e");
    test_class_info(&lv, &cd_ee27040);
    dp->~ee27040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27040(Test_ee27040, "ee27040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27040C1Ev();
extern void _ZN7ee27040D1Ev();
Name_Map name_map_ee27040[] = {
  NSPAIR(_ZN7ee27040C1Ev),
  NSPAIR(_ZN7ee27040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee27040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27040[];
extern void _ZN6dd70403barEv();
extern void _ZN7ee270403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN7ee270403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
extern VTBL_ENTRY _ZTV7ee27040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee27040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee27040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee27040[] = {
  {&(_ZTV7ee27040[3]),  3,9},
  {&(_tg__ZTV6dd7040__7ee27040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee27040[3]),  3,4},
  {&(_ZTV7ee27040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee27040[];
extern  VTBL_ENTRY _ZTV7ee27040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27040[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27040 = {  "ee27040", // class name
  bases_ee27040, 4,
  &(vtc_ee27040[0]), // expected_vtbl_contents
  &(vtt_ee27040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37040  : virtual dd7040 {
  int e;
  virtual void  foo(); // _ZN7ee370403fooEv
  ~ee37040(); // tgen
  ee37040(); // tgen
};
//SIG(1 ee37040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37040 ::foo(){vfunc_called(this, "_ZN7ee370403fooEv");}
ee37040 ::~ee37040(){ note_dtor("ee37040", this);} // tgen
ee37040 ::ee37040(){ note_ctor("ee37040", this);} // tgen

static void Test_ee37040()
{
  extern Class_Descriptor cd_ee37040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37040, buf);
    ee37040 *dp, &lv = *(dp=new (buf) ee37040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee37040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee37040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(32,16), "ee37040");
    check_base_class_offset(lv, (dd7040*), ABISELECT(16,8), "ee37040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37040.e");
    test_class_info(&lv, &cd_ee37040);
    dp->~ee37040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37040(Test_ee37040, "ee37040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37040C1Ev();
extern void _ZN7ee37040D1Ev();
Name_Map name_map_ee37040[] = {
  NSPAIR(_ZN7ee37040C1Ev),
  NSPAIR(_ZN7ee37040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee37040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37040[];
extern void _ZN7ee370403fooEv();
extern void _ZN6dd70403barEv();
extern void ABISELECT(_ZTv0_n40_N7ee370403fooEv,_ZTv0_n20_N7ee370403fooEv)();
extern void ABISELECT(_ZThn16_N7ee370403fooEv,_ZThn8_N7ee370403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37040[0]),
  (VTBL_ENTRY)&_ZN7ee370403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee370403fooEv,_ZTv0_n20_N7ee370403fooEv),
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
extern VTBL_ENTRY _ZTV7ee37040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee37040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee37040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee37040[] = {
  {&(_ZTV7ee37040[4]),  4,16},
  {&(_ZTV7ee37040[10]),  10,16},
  {&(_ZTV7ee37040[15]),  15,16},
  {&(_tg__ZTV6dd7040__7ee37040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee37040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37040[];
extern  VTBL_ENTRY _ZTV7ee37040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37040[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee370403fooEv,_ZTv0_n20_N7ee370403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370403fooEv,_ZThn8_N7ee370403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37040 = {  "ee37040", // class name
  bases_ee37040, 4,
  &(vtc_ee37040[0]), // expected_vtbl_contents
  &(vtt_ee37040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37040),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47040  : dd7040 {
  int e;
  virtual void  bar(); // _ZN7ee470403barEv
  ~ee47040(); // tgen
  ee47040(); // tgen
};
//SIG(1 ee47040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47040 ::bar(){vfunc_called(this, "_ZN7ee470403barEv");}
ee47040 ::~ee47040(){ note_dtor("ee47040", this);} // tgen
ee47040 ::ee47040(){ note_ctor("ee47040", this);} // tgen

static void Test_ee47040()
{
  extern Class_Descriptor cd_ee47040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47040, buf);
    ee47040 *dp, &lv = *(dp=new (buf) ee47040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee47040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee47040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(16,12), "ee47040");
    check_base_class_offset(lv, (dd7040*), 0, "ee47040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47040.e");
    test_class_info(&lv, &cd_ee47040);
    dp->~ee47040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47040(Test_ee47040, "ee47040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47040C1Ev();
extern void _ZN7ee47040D1Ev();
Name_Map name_map_ee47040[] = {
  NSPAIR(_ZN7ee47040C1Ev),
  NSPAIR(_ZN7ee47040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee47040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47040[];
extern void _ZN7ee470403barEv();
extern void _ZN6dd70403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee470403barEv,_ZTv0_n12_N7ee470403barEv)();
extern void ABISELECT(_ZThn16_N7ee470403barEv,_ZThn12_N7ee470403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47040[0]),
  (VTBL_ENTRY)&_ZN7ee470403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee470403barEv,_ZTv0_n12_N7ee470403barEv),
};
extern VTBL_ENTRY _ZTV7ee47040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee47040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee47040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee47040[] = {
  {&(_ZTV7ee47040[3]),  3,9},
  {&(_tg__ZTV6dd7040__7ee47040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee47040[3]),  3,4},
  {&(_ZTV7ee47040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee47040[];
extern  VTBL_ENTRY _ZTV7ee47040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47040[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee470403barEv,_ZTv0_n12_N7ee470403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee470403barEv,_ZThn12_N7ee470403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47040 = {  "ee47040", // class name
  bases_ee47040, 4,
  &(vtc_ee47040[0]), // expected_vtbl_contents
  &(vtt_ee47040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57040  : virtual dd7040 {
  int e;
  virtual void  bar(); // _ZN7ee570403barEv
  ~ee57040(); // tgen
  ee57040(); // tgen
};
//SIG(1 ee57040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57040 ::bar(){vfunc_called(this, "_ZN7ee570403barEv");}
ee57040 ::~ee57040(){ note_dtor("ee57040", this);} // tgen
ee57040 ::ee57040(){ note_ctor("ee57040", this);} // tgen

static void Test_ee57040()
{
  extern Class_Descriptor cd_ee57040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57040, buf);
    ee57040 *dp, &lv = *(dp=new (buf) ee57040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee57040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee57040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(32,16), "ee57040");
    check_base_class_offset(lv, (dd7040*), ABISELECT(16,8), "ee57040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57040.e");
    test_class_info(&lv, &cd_ee57040);
    dp->~ee57040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57040(Test_ee57040, "ee57040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57040C1Ev();
extern void _ZN7ee57040D1Ev();
Name_Map name_map_ee57040[] = {
  NSPAIR(_ZN7ee57040C1Ev),
  NSPAIR(_ZN7ee57040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee57040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57040[];
extern void _ZN7ee570403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee570403barEv,_ZTv0_n16_N7ee570403barEv)();
extern void ABISELECT(_ZThn16_N7ee570403barEv,_ZThn8_N7ee570403barEv)() __attribute__((weak));
extern void _ZN6dd70403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee570403barEv,_ZTv0_n12_N7ee570403barEv)();
extern void ABISELECT(_ZThn32_N7ee570403barEv,_ZThn16_N7ee570403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57040[0]),
  (VTBL_ENTRY)&_ZN7ee570403barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee570403barEv,_ZTv0_n16_N7ee570403barEv),
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee570403barEv,_ZTv0_n12_N7ee570403barEv),
};
extern VTBL_ENTRY _ZTV7ee57040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee57040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee57040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee57040[] = {
  {&(_ZTV7ee57040[4]),  4,16},
  {&(_ZTV7ee57040[10]),  10,16},
  {&(_ZTV7ee57040[15]),  15,16},
  {&(_tg__ZTV6dd7040__7ee57040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee57040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57040[];
extern  VTBL_ENTRY _ZTV7ee57040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57040[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee570403barEv,_ZTv0_n12_N7ee570403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee570403barEv,_ZThn16_N7ee570403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee570403barEv,_ZTv0_n16_N7ee570403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570403barEv,_ZThn8_N7ee570403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57040 = {  "ee57040", // class name
  bases_ee57040, 4,
  &(vtc_ee57040[0]), // expected_vtbl_contents
  &(vtt_ee57040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57040),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67040  : dd7040 {
  int e;
  virtual void  foo(); // _ZN7ee670403fooEv
  virtual void  bar(); // _ZN7ee670403barEv
  ~ee67040(); // tgen
  ee67040(); // tgen
};
//SIG(1 ee67040) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67040 ::foo(){vfunc_called(this, "_ZN7ee670403fooEv");}
void  ee67040 ::bar(){vfunc_called(this, "_ZN7ee670403barEv");}
ee67040 ::~ee67040(){ note_dtor("ee67040", this);} // tgen
ee67040 ::ee67040(){ note_ctor("ee67040", this);} // tgen

static void Test_ee67040()
{
  extern Class_Descriptor cd_ee67040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67040, buf);
    ee67040 *dp, &lv = *(dp=new (buf) ee67040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(24,16), "ee67040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(16,12), "ee67040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(16,12), "ee67040");
    check_base_class_offset(lv, (dd7040*), 0, "ee67040");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67040.e");
    test_class_info(&lv, &cd_ee67040);
    dp->~ee67040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67040(Test_ee67040, "ee67040", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67040C1Ev();
extern void _ZN7ee67040D1Ev();
Name_Map name_map_ee67040[] = {
  NSPAIR(_ZN7ee67040C1Ev),
  NSPAIR(_ZN7ee67040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee67040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67040[];
extern void _ZN7ee670403barEv();
extern void _ZN7ee670403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee670403barEv,_ZTv0_n12_N7ee670403barEv)();
extern void ABISELECT(_ZThn16_N7ee670403barEv,_ZThn12_N7ee670403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67040[0]),
  (VTBL_ENTRY)&_ZN7ee670403barEv,
  (VTBL_ENTRY)&_ZN7ee670403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee670403barEv,_ZTv0_n12_N7ee670403barEv),
};
extern VTBL_ENTRY _ZTV7ee67040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee67040[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee67040[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee67040[] = {
  {&(_ZTV7ee67040[3]),  3,9},
  {&(_tg__ZTV6dd7040__7ee67040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee67040[3]),  3,4},
  {&(_ZTV7ee67040[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee67040[];
extern  VTBL_ENTRY _ZTV7ee67040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67040[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn12_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee670403barEv,_ZTv0_n12_N7ee670403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670403barEv,_ZThn12_N7ee670403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67040 = {  "ee67040", // class name
  bases_ee67040, 4,
  &(vtc_ee67040[0]), // expected_vtbl_contents
  &(vtt_ee67040[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67040),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67040),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67040),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77040  : virtual dd7040 {
  int e;
  virtual void  foo(); // _ZN7ee770403fooEv
  virtual void  bar(); // _ZN7ee770403barEv
  ~ee77040(); // tgen
  ee77040(); // tgen
};
//SIG(1 ee77040) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77040 ::foo(){vfunc_called(this, "_ZN7ee770403fooEv");}
void  ee77040 ::bar(){vfunc_called(this, "_ZN7ee770403barEv");}
ee77040 ::~ee77040(){ note_dtor("ee77040", this);} // tgen
ee77040 ::ee77040(){ note_ctor("ee77040", this);} // tgen

static void Test_ee77040()
{
  extern Class_Descriptor cd_ee77040;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77040, buf);
    ee77040 *dp, &lv = *(dp=new (buf) ee77040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77040)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77040)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc040*), ABISELECT(40,20), "ee77040");
    check_base_class_offset(lv, (bb40*)(cc040*), ABISELECT(32,16), "ee77040");
    check_base_class_offset(lv, (cc040*)(dd7040*), ABISELECT(32,16), "ee77040");
    check_base_class_offset(lv, (dd7040*), ABISELECT(16,8), "ee77040");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77040.e");
    test_class_info(&lv, &cd_ee77040);
    dp->~ee77040();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77040(Test_ee77040, "ee77040", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77040C1Ev();
extern void _ZN7ee77040D1Ev();
Name_Map name_map_ee77040[] = {
  NSPAIR(_ZN7ee77040C1Ev),
  NSPAIR(_ZN7ee77040D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc040;
extern VTBL_ENTRY _ZTI5cc040[];
extern  VTBL_ENTRY _ZTV5cc040[];
extern Class_Descriptor cd_dd7040;
extern VTBL_ENTRY _ZTI6dd7040[];
extern  VTBL_ENTRY _ZTV6dd7040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7040[];
static Base_Class bases_ee77040[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc040,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7040,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77040[];
extern void _ZN7ee770403fooEv();
extern void _ZN7ee770403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee770403barEv,_ZTv0_n16_N7ee770403barEv)();
extern void ABISELECT(_ZThn16_N7ee770403barEv,_ZThn8_N7ee770403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee770403fooEv,_ZTv0_n20_N7ee770403fooEv)();
extern void ABISELECT(_ZThn16_N7ee770403fooEv,_ZThn8_N7ee770403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee770403barEv,_ZTv0_n12_N7ee770403barEv)();
extern void ABISELECT(_ZThn32_N7ee770403barEv,_ZThn16_N7ee770403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77040[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77040[0]),
  (VTBL_ENTRY)&_ZN7ee770403fooEv,
  (VTBL_ENTRY)&_ZN7ee770403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770403barEv,_ZTv0_n16_N7ee770403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770403fooEv,_ZTv0_n20_N7ee770403fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee770403barEv,_ZTv0_n12_N7ee770403barEv),
};
extern VTBL_ENTRY _ZTV7ee77040[];
extern void _ZN6dd70403barEv();
extern void _ZN6dd70403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7040__7ee77040[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&_ZN6dd70403barEv,
  (VTBL_ENTRY)&_ZN6dd70403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv)();
extern void ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb405cc040__6dd7040__7ee77040[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7040[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv),
};
static  VTT_ENTRY vtt_ee77040[] = {
  {&(_ZTV7ee77040[4]),  4,17},
  {&(_ZTV7ee77040[11]),  11,17},
  {&(_ZTV7ee77040[16]),  16,17},
  {&(_tg__ZTV6dd7040__7ee77040[3]),  3,5},
  {&(_tg__ZTV4bb405cc040__6dd7040__7ee77040[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77040[];
extern  VTBL_ENTRY _ZTV7ee77040[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77040[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70403barEv,_ZTv0_n12_N6dd70403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70403barEv,_ZThn8_N6dd70403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee770403barEv,_ZTv0_n12_N7ee770403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770403barEv,_ZThn16_N7ee770403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770403fooEv,_ZTv0_n20_N7ee770403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770403fooEv,_ZThn8_N7ee770403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770403barEv,_ZTv0_n16_N7ee770403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770403barEv,_ZThn8_N7ee770403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77040 = {  "ee77040", // class name
  bases_ee77040, 4,
  &(vtc_ee77040[0]), // expected_vtbl_contents
  &(vtt_ee77040[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77040),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77040),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77040),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc140  : virtual bb40 {
  int c;
  ~cc140(); // tgen
  cc140(); // tgen
};
//SIG(-1 cc140) C1{ VBC2{ BC3{ Fi} v1 Fi} Fi}


cc140 ::~cc140(){ note_dtor("cc140", this);} // tgen
cc140 ::cc140(){ note_ctor("cc140", this);} // tgen

static void Test_cc140()
{
  extern Class_Descriptor cd_cc140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_cc140, buf);
    cc140 *dp, &lv = *(dp=new (buf) cc140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(cc140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(24,12), "cc140");
    check_base_class_offset(lv, (bb40*), ABISELECT(16,8), "cc140");
    check_field_offset(lv, c, ABISELECT(8,4), "cc140.c");
    test_class_info(&lv, &cd_cc140);
    dp->~cc140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc140(Test_cc140, "cc140", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN5cc140C1Ev();
extern void _ZN5cc140D1Ev();
Name_Map name_map_cc140[] = {
  NSPAIR(_ZN5cc140C1Ev),
  NSPAIR(_ZN5cc140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
static Base_Class bases_cc140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc140[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_cc140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV5cc140[];
static  VTT_ENTRY vtt_cc140[] = {
  {&(_ZTV5cc140[3]),  3,7},
  {&(_ZTV5cc140[6]),  6,7},
};
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
Class_Descriptor cd_cc140 = {  "cc140", // class name
  bases_cc140, 2,
  &(vtc_cc140[0]), // expected_vtbl_contents
  &(vtt_cc140[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI5cc140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc140),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc140),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0140  : cc140 {
  int d;
  ~dd0140(); // tgen
  dd0140(); // tgen
};
//SIG(-1 dd0140) C1{ BC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd0140 ::~dd0140(){ note_dtor("dd0140", this);} // tgen
dd0140 ::dd0140(){ note_ctor("dd0140", this);} // tgen

static void Test_dd0140()
{
  extern Class_Descriptor cd_dd0140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd0140, buf);
    dd0140 *dp, &lv = *(dp=new (buf) dd0140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd0140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(24,16), "dd0140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(16,12), "dd0140");
    check_base_class_offset(lv, (cc140*), 0, "dd0140");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0140.d");
    test_class_info(&lv, &cd_dd0140);
    dp->~dd0140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0140(Test_dd0140, "dd0140", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd0140C1Ev();
extern void _ZN6dd0140D1Ev();
Name_Map name_map_dd0140[] = {
  NSPAIR(_ZN6dd0140C1Ev),
  NSPAIR(_ZN6dd0140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd0140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0140[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_dd0140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV6dd0140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd0140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd0140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd0140[] = {
  {&(_ZTV6dd0140[3]),  3,7},
  {&(_tg__ZTV5cc140__6dd0140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd0140[3]),  3,4},
  {&(_ZTV6dd0140[6]),  6,7},
};
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
Class_Descriptor cd_dd0140 = {  "dd0140", // class name
  bases_dd0140, 3,
  &(vtc_dd0140[0]), // expected_vtbl_contents
  &(vtt_dd0140[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd0140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0140),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0140),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00140  : dd0140 {
  int e;
  ~ee00140(); // tgen
  ee00140(); // tgen
};
//SIG(1 ee00140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00140 ::~ee00140(){ note_dtor("ee00140", this);} // tgen
ee00140 ::ee00140(){ note_ctor("ee00140", this);} // tgen

static void Test_ee00140()
{
  extern Class_Descriptor cd_ee00140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee00140, buf);
    ee00140 *dp, &lv = *(dp=new (buf) ee00140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee00140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee00140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(24,16), "ee00140");
    check_base_class_offset(lv, (cc140*)(dd0140*), 0, "ee00140");
    check_base_class_offset(lv, (dd0140*), 0, "ee00140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00140.e");
    test_class_info(&lv, &cd_ee00140);
    dp->~ee00140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00140(Test_ee00140, "ee00140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee00140C1Ev();
extern void _ZN7ee00140D1Ev();
Name_Map name_map_ee00140[] = {
  NSPAIR(_ZN7ee00140C1Ev),
  NSPAIR(_ZN7ee00140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee00140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00140[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee00140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00140[0]),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee00140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee00140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee00140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee00140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee00140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee00140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee00140[] = {
  {&(_ZTV7ee00140[3]),  3,7},
  {&(_tg__ZTV6dd0140__7ee00140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee00140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee00140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee00140[3]),  3,4},
  {&(_ZTV7ee00140[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee00140[];
extern  VTBL_ENTRY _ZTV7ee00140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00140[];
Class_Descriptor cd_ee00140 = {  "ee00140", // class name
  bases_ee00140, 4,
  &(vtc_ee00140[0]), // expected_vtbl_contents
  &(vtt_ee00140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee00140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00140),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10140  : virtual dd0140 {
  int e;
  ~ee10140(); // tgen
  ee10140(); // tgen
};
//SIG(1 ee10140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10140 ::~ee10140(){ note_dtor("ee10140", this);} // tgen
ee10140 ::ee10140(){ note_ctor("ee10140", this);} // tgen

static void Test_ee10140()
{
  extern Class_Descriptor cd_ee10140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee10140, buf);
    ee10140 *dp, &lv = *(dp=new (buf) ee10140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee10140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee10140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(32,20), "ee10140");
    check_base_class_offset(lv, (cc140*)(dd0140*), ABISELECT(16,8), "ee10140");
    check_base_class_offset(lv, (dd0140*), ABISELECT(16,8), "ee10140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10140.e");
    test_class_info(&lv, &cd_ee10140);
    dp->~ee10140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10140(Test_ee10140, "ee10140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee10140C1Ev();
extern void _ZN7ee10140D1Ev();
Name_Map name_map_ee10140[] = {
  NSPAIR(_ZN7ee10140C1Ev),
  NSPAIR(_ZN7ee10140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee10140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10140[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee10140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10140[0]),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10140[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee10140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee10140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee10140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee10140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee10140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee10140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee10140[] = {
  {&(_ZTV7ee10140[4]),  4,11},
  {&(_ZTV7ee10140[7]),  7,11},
  {&(_ZTV7ee10140[10]),  10,11},
  {&(_tg__ZTV6dd0140__7ee10140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee10140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee10140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee10140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10140[];
extern  VTBL_ENTRY _ZTV7ee10140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10140[];
Class_Descriptor cd_ee10140 = {  "ee10140", // class name
  bases_ee10140, 4,
  &(vtc_ee10140[0]), // expected_vtbl_contents
  &(vtt_ee10140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee10140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10140),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20140  : dd0140 {
  int e;
  virtual void  foo(); // _ZN7ee201403fooEv
  ~ee20140(); // tgen
  ee20140(); // tgen
};
//SIG(1 ee20140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee20140 ::foo(){vfunc_called(this, "_ZN7ee201403fooEv");}
ee20140 ::~ee20140(){ note_dtor("ee20140", this);} // tgen
ee20140 ::ee20140(){ note_ctor("ee20140", this);} // tgen

static void Test_ee20140()
{
  extern Class_Descriptor cd_ee20140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee20140, buf);
    ee20140 *dp, &lv = *(dp=new (buf) ee20140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee20140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee20140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(24,16), "ee20140");
    check_base_class_offset(lv, (cc140*)(dd0140*), 0, "ee20140");
    check_base_class_offset(lv, (dd0140*), 0, "ee20140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20140.e");
    test_class_info(&lv, &cd_ee20140);
    dp->~ee20140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20140(Test_ee20140, "ee20140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee20140C1Ev();
extern void _ZN7ee20140D1Ev();
Name_Map name_map_ee20140[] = {
  NSPAIR(_ZN7ee20140C1Ev),
  NSPAIR(_ZN7ee20140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee20140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20140[];
extern void _ZN7ee201403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee20140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20140[0]),
  (VTBL_ENTRY)&_ZN7ee201403fooEv,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee20140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee20140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee20140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee20140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee20140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee20140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee20140[] = {
  {&(_ZTV7ee20140[3]),  3,8},
  {&(_tg__ZTV6dd0140__7ee20140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee20140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee20140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee20140[3]),  3,4},
  {&(_ZTV7ee20140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee20140[];
extern  VTBL_ENTRY _ZTV7ee20140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20140[];
Class_Descriptor cd_ee20140 = {  "ee20140", // class name
  bases_ee20140, 4,
  &(vtc_ee20140[0]), // expected_vtbl_contents
  &(vtt_ee20140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee20140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30140  : virtual dd0140 {
  int e;
  virtual void  foo(); // _ZN7ee301403fooEv
  ~ee30140(); // tgen
  ee30140(); // tgen
};
//SIG(1 ee30140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee30140 ::foo(){vfunc_called(this, "_ZN7ee301403fooEv");}
ee30140 ::~ee30140(){ note_dtor("ee30140", this);} // tgen
ee30140 ::ee30140(){ note_ctor("ee30140", this);} // tgen

static void Test_ee30140()
{
  extern Class_Descriptor cd_ee30140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee30140, buf);
    ee30140 *dp, &lv = *(dp=new (buf) ee30140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee30140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee30140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(32,20), "ee30140");
    check_base_class_offset(lv, (cc140*)(dd0140*), ABISELECT(16,8), "ee30140");
    check_base_class_offset(lv, (dd0140*), ABISELECT(16,8), "ee30140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30140.e");
    test_class_info(&lv, &cd_ee30140);
    dp->~ee30140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30140(Test_ee30140, "ee30140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee30140C1Ev();
extern void _ZN7ee30140D1Ev();
Name_Map name_map_ee30140[] = {
  NSPAIR(_ZN7ee30140C1Ev),
  NSPAIR(_ZN7ee30140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee30140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30140[];
extern void _ZN7ee301403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee30140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30140[0]),
  (VTBL_ENTRY)&_ZN7ee301403fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30140[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee30140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee30140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee30140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee30140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee30140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee30140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee30140[] = {
  {&(_ZTV7ee30140[4]),  4,12},
  {&(_ZTV7ee30140[8]),  8,12},
  {&(_ZTV7ee30140[11]),  11,12},
  {&(_tg__ZTV6dd0140__7ee30140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee30140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee30140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee30140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30140[];
extern  VTBL_ENTRY _ZTV7ee30140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30140[];
Class_Descriptor cd_ee30140 = {  "ee30140", // class name
  bases_ee30140, 4,
  &(vtc_ee30140[0]), // expected_vtbl_contents
  &(vtt_ee30140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee30140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40140  : dd0140 {
  int e;
  virtual void  bar(); // _ZN7ee401403barEv
  ~ee40140(); // tgen
  ee40140(); // tgen
};
//SIG(1 ee40140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee40140 ::bar(){vfunc_called(this, "_ZN7ee401403barEv");}
ee40140 ::~ee40140(){ note_dtor("ee40140", this);} // tgen
ee40140 ::ee40140(){ note_ctor("ee40140", this);} // tgen

static void Test_ee40140()
{
  extern Class_Descriptor cd_ee40140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee40140, buf);
    ee40140 *dp, &lv = *(dp=new (buf) ee40140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee40140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee40140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(24,16), "ee40140");
    check_base_class_offset(lv, (cc140*)(dd0140*), 0, "ee40140");
    check_base_class_offset(lv, (dd0140*), 0, "ee40140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40140.e");
    test_class_info(&lv, &cd_ee40140);
    dp->~ee40140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40140(Test_ee40140, "ee40140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee40140C1Ev();
extern void _ZN7ee40140D1Ev();
Name_Map name_map_ee40140[] = {
  NSPAIR(_ZN7ee40140C1Ev),
  NSPAIR(_ZN7ee40140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee40140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40140[];
extern void _ZN7ee401403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee401403barEv,_ZTv0_n12_N7ee401403barEv)();
extern void ABISELECT(_ZThn24_N7ee401403barEv,_ZThn16_N7ee401403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee40140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40140[0]),
  (VTBL_ENTRY)&_ZN7ee401403barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee40140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee401403barEv,_ZTv0_n12_N7ee401403barEv),
};
extern VTBL_ENTRY _ZTV7ee40140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee40140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee40140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee40140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee40140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee40140[] = {
  {&(_ZTV7ee40140[3]),  3,8},
  {&(_tg__ZTV6dd0140__7ee40140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee40140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee40140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee40140[3]),  3,4},
  {&(_ZTV7ee40140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee40140[];
extern  VTBL_ENTRY _ZTV7ee40140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40140[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee401403barEv,_ZTv0_n12_N7ee401403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee401403barEv,_ZThn16_N7ee401403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee40140 = {  "ee40140", // class name
  bases_ee40140, 4,
  &(vtc_ee40140[0]), // expected_vtbl_contents
  &(vtt_ee40140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee40140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50140  : virtual dd0140 {
  int e;
  virtual void  bar(); // _ZN7ee501403barEv
  ~ee50140(); // tgen
  ee50140(); // tgen
};
//SIG(1 ee50140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee50140 ::bar(){vfunc_called(this, "_ZN7ee501403barEv");}
ee50140 ::~ee50140(){ note_dtor("ee50140", this);} // tgen
ee50140 ::ee50140(){ note_ctor("ee50140", this);} // tgen

static void Test_ee50140()
{
  extern Class_Descriptor cd_ee50140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee50140, buf);
    ee50140 *dp, &lv = *(dp=new (buf) ee50140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee50140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee50140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(32,20), "ee50140");
    check_base_class_offset(lv, (cc140*)(dd0140*), ABISELECT(16,8), "ee50140");
    check_base_class_offset(lv, (dd0140*), ABISELECT(16,8), "ee50140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50140.e");
    test_class_info(&lv, &cd_ee50140);
    dp->~ee50140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50140(Test_ee50140, "ee50140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee50140C1Ev();
extern void _ZN7ee50140D1Ev();
Name_Map name_map_ee50140[] = {
  NSPAIR(_ZN7ee50140C1Ev),
  NSPAIR(_ZN7ee50140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee50140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50140[];
extern void _ZN7ee501403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee501403barEv,_ZTv0_n12_N7ee501403barEv)();
extern void ABISELECT(_ZThn32_N7ee501403barEv,_ZThn20_N7ee501403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee50140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50140[0]),
  (VTBL_ENTRY)&_ZN7ee501403barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee50140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee501403barEv,_ZTv0_n12_N7ee501403barEv),
};
extern VTBL_ENTRY _ZTV7ee50140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee50140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee50140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee50140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee50140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee50140[] = {
  {&(_ZTV7ee50140[4]),  4,12},
  {&(_ZTV7ee50140[8]),  8,12},
  {&(_ZTV7ee50140[11]),  11,12},
  {&(_tg__ZTV6dd0140__7ee50140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee50140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee50140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee50140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50140[];
extern  VTBL_ENTRY _ZTV7ee50140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50140[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee501403barEv,_ZTv0_n12_N7ee501403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee501403barEv,_ZThn20_N7ee501403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50140 = {  "ee50140", // class name
  bases_ee50140, 4,
  &(vtc_ee50140[0]), // expected_vtbl_contents
  &(vtt_ee50140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee50140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60140  : dd0140 {
  int e;
  virtual void  foo(); // _ZN7ee601403fooEv
  virtual void  bar(); // _ZN7ee601403barEv
  ~ee60140(); // tgen
  ee60140(); // tgen
};
//SIG(1 ee60140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee60140 ::foo(){vfunc_called(this, "_ZN7ee601403fooEv");}
void  ee60140 ::bar(){vfunc_called(this, "_ZN7ee601403barEv");}
ee60140 ::~ee60140(){ note_dtor("ee60140", this);} // tgen
ee60140 ::ee60140(){ note_ctor("ee60140", this);} // tgen

static void Test_ee60140()
{
  extern Class_Descriptor cd_ee60140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee60140, buf);
    ee60140 *dp, &lv = *(dp=new (buf) ee60140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee60140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee60140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(24,16), "ee60140");
    check_base_class_offset(lv, (cc140*)(dd0140*), 0, "ee60140");
    check_base_class_offset(lv, (dd0140*), 0, "ee60140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60140.e");
    test_class_info(&lv, &cd_ee60140);
    dp->~ee60140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60140(Test_ee60140, "ee60140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee60140C1Ev();
extern void _ZN7ee60140D1Ev();
Name_Map name_map_ee60140[] = {
  NSPAIR(_ZN7ee60140C1Ev),
  NSPAIR(_ZN7ee60140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee60140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60140[];
extern void _ZN7ee601403fooEv();
extern void _ZN7ee601403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee601403barEv,_ZTv0_n12_N7ee601403barEv)();
extern void ABISELECT(_ZThn24_N7ee601403barEv,_ZThn16_N7ee601403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee60140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60140[0]),
  (VTBL_ENTRY)&_ZN7ee601403fooEv,
  (VTBL_ENTRY)&_ZN7ee601403barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee60140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee601403barEv,_ZTv0_n12_N7ee601403barEv),
};
extern VTBL_ENTRY _ZTV7ee60140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee60140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee60140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee60140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee60140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee60140[] = {
  {&(_ZTV7ee60140[3]),  3,9},
  {&(_tg__ZTV6dd0140__7ee60140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee60140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee60140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee60140[3]),  3,4},
  {&(_ZTV7ee60140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee60140[];
extern  VTBL_ENTRY _ZTV7ee60140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60140[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee601403barEv,_ZTv0_n12_N7ee601403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601403barEv,_ZThn16_N7ee601403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee60140 = {  "ee60140", // class name
  bases_ee60140, 4,
  &(vtc_ee60140[0]), // expected_vtbl_contents
  &(vtt_ee60140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee60140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70140  : virtual dd0140 {
  int e;
  virtual void  foo(); // _ZN7ee701403fooEv
  virtual void  bar(); // _ZN7ee701403barEv
  ~ee70140(); // tgen
  ee70140(); // tgen
};
//SIG(1 ee70140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee70140 ::foo(){vfunc_called(this, "_ZN7ee701403fooEv");}
void  ee70140 ::bar(){vfunc_called(this, "_ZN7ee701403barEv");}
ee70140 ::~ee70140(){ note_dtor("ee70140", this);} // tgen
ee70140 ::ee70140(){ note_ctor("ee70140", this);} // tgen

static void Test_ee70140()
{
  extern Class_Descriptor cd_ee70140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee70140, buf);
    ee70140 *dp, &lv = *(dp=new (buf) ee70140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee70140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee70140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd0140*), ABISELECT(32,20), "ee70140");
    check_base_class_offset(lv, (cc140*)(dd0140*), ABISELECT(16,8), "ee70140");
    check_base_class_offset(lv, (dd0140*), ABISELECT(16,8), "ee70140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70140.e");
    test_class_info(&lv, &cd_ee70140);
    dp->~ee70140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70140(Test_ee70140, "ee70140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee70140C1Ev();
extern void _ZN7ee70140D1Ev();
Name_Map name_map_ee70140[] = {
  NSPAIR(_ZN7ee70140C1Ev),
  NSPAIR(_ZN7ee70140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd0140;
extern VTBL_ENTRY _ZTI6dd0140[];
extern  VTBL_ENTRY _ZTV6dd0140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0140[];
static Base_Class bases_ee70140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70140[];
extern void _ZN7ee701403fooEv();
extern void _ZN7ee701403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee701403barEv,_ZTv0_n12_N7ee701403barEv)();
extern void ABISELECT(_ZThn32_N7ee701403barEv,_ZThn20_N7ee701403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70140[0]),
  (VTBL_ENTRY)&_ZN7ee701403fooEv,
  (VTBL_ENTRY)&_ZN7ee701403barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee70140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee701403barEv,_ZTv0_n12_N7ee701403barEv),
};
extern VTBL_ENTRY _ZTV7ee70140[];
static  VTBL_ENTRY _tg__ZTV6dd0140__7ee70140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd0140__7ee70140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd0140__7ee70140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd0140__7ee70140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee70140[] = {
  {&(_ZTV7ee70140[4]),  4,13},
  {&(_ZTV7ee70140[9]),  9,13},
  {&(_ZTV7ee70140[12]),  12,13},
  {&(_tg__ZTV6dd0140__7ee70140[3]),  3,3},
  {&(_tg__ZTV5cc1406dd0140__7ee70140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd0140__7ee70140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd0140__7ee70140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70140[];
extern  VTBL_ENTRY _ZTV7ee70140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70140[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee701403barEv,_ZTv0_n12_N7ee701403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701403barEv,_ZThn20_N7ee701403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70140 = {  "ee70140", // class name
  bases_ee70140, 4,
  &(vtc_ee70140[0]), // expected_vtbl_contents
  &(vtt_ee70140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee70140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1140  : virtual cc140 {
  int d;
  ~dd1140(); // tgen
  dd1140(); // tgen
};
//SIG(-1 dd1140) C1{ VBC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd1140 ::~dd1140(){ note_dtor("dd1140", this);} // tgen
dd1140 ::dd1140(){ note_ctor("dd1140", this);} // tgen

static void Test_dd1140()
{
  extern Class_Descriptor cd_dd1140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd1140, buf);
    dd1140 *dp, &lv = *(dp=new (buf) dd1140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd1140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,20), "dd1140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,16), "dd1140");
    check_base_class_offset(lv, (cc140*), ABISELECT(16,8), "dd1140");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1140.d");
    test_class_info(&lv, &cd_dd1140);
    dp->~dd1140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1140(Test_dd1140, "dd1140", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd1140C1Ev();
extern void _ZN6dd1140D1Ev();
Name_Map name_map_dd1140[] = {
  NSPAIR(_ZN6dd1140C1Ev),
  NSPAIR(_ZN6dd1140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd1140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1140[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_dd1140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV6dd1140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd1140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd1140[] = {
  {&(_ZTV6dd1140[4]),  4,11},
  {&(_ZTV6dd1140[7]),  7,11},
  {&(_ZTV6dd1140[10]),  10,11},
  {&(_tg__ZTV5cc140__6dd1140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd1140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
Class_Descriptor cd_dd1140 = {  "dd1140", // class name
  bases_dd1140, 3,
  &(vtc_dd1140[0]), // expected_vtbl_contents
  &(vtt_dd1140[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd1140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1140),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1140),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01140  : dd1140 {
  int e;
  ~ee01140(); // tgen
  ee01140(); // tgen
};
//SIG(1 ee01140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01140 ::~ee01140(){ note_dtor("ee01140", this);} // tgen
ee01140 ::ee01140(){ note_ctor("ee01140", this);} // tgen

static void Test_ee01140()
{
  extern Class_Descriptor cd_ee01140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee01140, buf);
    ee01140 *dp, &lv = *(dp=new (buf) ee01140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee01140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee01140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee01140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(16,12), "ee01140");
    check_base_class_offset(lv, (dd1140*), 0, "ee01140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01140.e");
    test_class_info(&lv, &cd_ee01140);
    dp->~ee01140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01140(Test_ee01140, "ee01140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee01140C1Ev();
extern void _ZN7ee01140D1Ev();
Name_Map name_map_ee01140[] = {
  NSPAIR(_ZN7ee01140C1Ev),
  NSPAIR(_ZN7ee01140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee01140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01140[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee01140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01140[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01140[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee01140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee01140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee01140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee01140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee01140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee01140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee01140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee01140[] = {
  {&(_ZTV7ee01140[4]),  4,11},
  {&(_tg__ZTV6dd1140__7ee01140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee01140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee01140[3]),  3,4},
  {&(_ZTV7ee01140[7]),  7,11},
  {&(_ZTV7ee01140[10]),  10,11},
  {&(_tg__ZTV5cc140__7ee01140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee01140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01140[];
extern  VTBL_ENTRY _ZTV7ee01140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01140[];
Class_Descriptor cd_ee01140 = {  "ee01140", // class name
  bases_ee01140, 4,
  &(vtc_ee01140[0]), // expected_vtbl_contents
  &(vtt_ee01140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee01140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01140),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11140  : virtual dd1140 {
  int e;
  ~ee11140(); // tgen
  ee11140(); // tgen
};
//SIG(1 ee11140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11140 ::~ee11140(){ note_dtor("ee11140", this);} // tgen
ee11140 ::ee11140(){ note_ctor("ee11140", this);} // tgen

static void Test_ee11140()
{
  extern Class_Descriptor cd_ee11140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee11140, buf);
    ee11140 *dp, &lv = *(dp=new (buf) ee11140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee11140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee11140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee11140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(32,16), "ee11140");
    check_base_class_offset(lv, (dd1140*), ABISELECT(16,8), "ee11140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11140.e");
    test_class_info(&lv, &cd_ee11140);
    dp->~ee11140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11140(Test_ee11140, "ee11140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee11140C1Ev();
extern void _ZN7ee11140D1Ev();
Name_Map name_map_ee11140[] = {
  NSPAIR(_ZN7ee11140C1Ev),
  NSPAIR(_ZN7ee11140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee11140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11140[];
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee11140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11140[0]),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11140[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11140[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee11140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee11140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee11140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee11140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee11140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee11140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee11140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee11140[] = {
  {&(_ZTV7ee11140[5]),  5,16},
  {&(_ZTV7ee11140[9]),  9,16},
  {&(_ZTV7ee11140[12]),  12,16},
  {&(_ZTV7ee11140[15]),  15,16},
  {&(_tg__ZTV6dd1140__7ee11140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee11140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee11140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee11140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee11140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11140[];
extern  VTBL_ENTRY _ZTV7ee11140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11140[];
Class_Descriptor cd_ee11140 = {  "ee11140", // class name
  bases_ee11140, 4,
  &(vtc_ee11140[0]), // expected_vtbl_contents
  &(vtt_ee11140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee11140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11140),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21140  : dd1140 {
  int e;
  virtual void  foo(); // _ZN7ee211403fooEv
  ~ee21140(); // tgen
  ee21140(); // tgen
};
//SIG(1 ee21140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee21140 ::foo(){vfunc_called(this, "_ZN7ee211403fooEv");}
ee21140 ::~ee21140(){ note_dtor("ee21140", this);} // tgen
ee21140 ::ee21140(){ note_ctor("ee21140", this);} // tgen

static void Test_ee21140()
{
  extern Class_Descriptor cd_ee21140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee21140, buf);
    ee21140 *dp, &lv = *(dp=new (buf) ee21140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee21140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee21140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee21140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(16,12), "ee21140");
    check_base_class_offset(lv, (dd1140*), 0, "ee21140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21140.e");
    test_class_info(&lv, &cd_ee21140);
    dp->~ee21140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21140(Test_ee21140, "ee21140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee21140C1Ev();
extern void _ZN7ee21140D1Ev();
Name_Map name_map_ee21140[] = {
  NSPAIR(_ZN7ee21140C1Ev),
  NSPAIR(_ZN7ee21140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee21140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21140[];
extern void _ZN7ee211403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee21140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21140[0]),
  (VTBL_ENTRY)&_ZN7ee211403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21140[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee21140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee21140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee21140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee21140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee21140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee21140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee21140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee21140[] = {
  {&(_ZTV7ee21140[4]),  4,12},
  {&(_tg__ZTV6dd1140__7ee21140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee21140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee21140[3]),  3,4},
  {&(_ZTV7ee21140[8]),  8,12},
  {&(_ZTV7ee21140[11]),  11,12},
  {&(_tg__ZTV5cc140__7ee21140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee21140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21140[];
extern  VTBL_ENTRY _ZTV7ee21140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21140[];
Class_Descriptor cd_ee21140 = {  "ee21140", // class name
  bases_ee21140, 4,
  &(vtc_ee21140[0]), // expected_vtbl_contents
  &(vtt_ee21140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee21140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31140  : virtual dd1140 {
  int e;
  virtual void  foo(); // _ZN7ee311403fooEv
  ~ee31140(); // tgen
  ee31140(); // tgen
};
//SIG(1 ee31140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee31140 ::foo(){vfunc_called(this, "_ZN7ee311403fooEv");}
ee31140 ::~ee31140(){ note_dtor("ee31140", this);} // tgen
ee31140 ::ee31140(){ note_ctor("ee31140", this);} // tgen

static void Test_ee31140()
{
  extern Class_Descriptor cd_ee31140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee31140, buf);
    ee31140 *dp, &lv = *(dp=new (buf) ee31140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee31140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee31140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee31140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(32,16), "ee31140");
    check_base_class_offset(lv, (dd1140*), ABISELECT(16,8), "ee31140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31140.e");
    test_class_info(&lv, &cd_ee31140);
    dp->~ee31140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31140(Test_ee31140, "ee31140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee31140C1Ev();
extern void _ZN7ee31140D1Ev();
Name_Map name_map_ee31140[] = {
  NSPAIR(_ZN7ee31140C1Ev),
  NSPAIR(_ZN7ee31140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee31140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31140[];
extern void _ZN7ee311403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee31140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31140[0]),
  (VTBL_ENTRY)&_ZN7ee311403fooEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31140[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31140[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee31140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee31140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee31140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee31140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee31140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee31140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee31140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee31140[] = {
  {&(_ZTV7ee31140[5]),  5,17},
  {&(_ZTV7ee31140[10]),  10,17},
  {&(_ZTV7ee31140[13]),  13,17},
  {&(_ZTV7ee31140[16]),  16,17},
  {&(_tg__ZTV6dd1140__7ee31140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee31140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee31140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee31140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee31140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31140[];
extern  VTBL_ENTRY _ZTV7ee31140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31140[];
Class_Descriptor cd_ee31140 = {  "ee31140", // class name
  bases_ee31140, 4,
  &(vtc_ee31140[0]), // expected_vtbl_contents
  &(vtt_ee31140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee31140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31140),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41140  : dd1140 {
  int e;
  virtual void  bar(); // _ZN7ee411403barEv
  ~ee41140(); // tgen
  ee41140(); // tgen
};
//SIG(1 ee41140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee41140 ::bar(){vfunc_called(this, "_ZN7ee411403barEv");}
ee41140 ::~ee41140(){ note_dtor("ee41140", this);} // tgen
ee41140 ::ee41140(){ note_ctor("ee41140", this);} // tgen

static void Test_ee41140()
{
  extern Class_Descriptor cd_ee41140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee41140, buf);
    ee41140 *dp, &lv = *(dp=new (buf) ee41140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee41140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee41140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee41140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(16,12), "ee41140");
    check_base_class_offset(lv, (dd1140*), 0, "ee41140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41140.e");
    test_class_info(&lv, &cd_ee41140);
    dp->~ee41140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41140(Test_ee41140, "ee41140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee41140C1Ev();
extern void _ZN7ee41140D1Ev();
Name_Map name_map_ee41140[] = {
  NSPAIR(_ZN7ee41140C1Ev),
  NSPAIR(_ZN7ee41140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee41140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41140[];
extern void _ZN7ee411403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee411403barEv,_ZTv0_n12_N7ee411403barEv)();
extern void ABISELECT(_ZThn32_N7ee411403barEv,_ZThn20_N7ee411403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee41140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41140[0]),
  (VTBL_ENTRY)&_ZN7ee411403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee41140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee411403barEv,_ZTv0_n12_N7ee411403barEv),
};
extern VTBL_ENTRY _ZTV7ee41140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee41140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee41140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee41140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee41140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee41140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee41140[] = {
  {&(_ZTV7ee41140[4]),  4,12},
  {&(_tg__ZTV6dd1140__7ee41140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee41140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee41140[3]),  3,4},
  {&(_ZTV7ee41140[8]),  8,12},
  {&(_ZTV7ee41140[11]),  11,12},
  {&(_tg__ZTV5cc140__7ee41140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee41140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41140[];
extern  VTBL_ENTRY _ZTV7ee41140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41140[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee411403barEv,_ZTv0_n12_N7ee411403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee411403barEv,_ZThn20_N7ee411403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41140 = {  "ee41140", // class name
  bases_ee41140, 4,
  &(vtc_ee41140[0]), // expected_vtbl_contents
  &(vtt_ee41140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee41140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51140  : virtual dd1140 {
  int e;
  virtual void  bar(); // _ZN7ee511403barEv
  ~ee51140(); // tgen
  ee51140(); // tgen
};
//SIG(1 ee51140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee51140 ::bar(){vfunc_called(this, "_ZN7ee511403barEv");}
ee51140 ::~ee51140(){ note_dtor("ee51140", this);} // tgen
ee51140 ::ee51140(){ note_ctor("ee51140", this);} // tgen

static void Test_ee51140()
{
  extern Class_Descriptor cd_ee51140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee51140, buf);
    ee51140 *dp, &lv = *(dp=new (buf) ee51140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee51140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee51140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee51140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(32,16), "ee51140");
    check_base_class_offset(lv, (dd1140*), ABISELECT(16,8), "ee51140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51140.e");
    test_class_info(&lv, &cd_ee51140);
    dp->~ee51140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51140(Test_ee51140, "ee51140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee51140C1Ev();
extern void _ZN7ee51140D1Ev();
Name_Map name_map_ee51140[] = {
  NSPAIR(_ZN7ee51140C1Ev),
  NSPAIR(_ZN7ee51140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee51140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51140[];
extern void _ZN7ee511403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee511403barEv,_ZTv0_n12_N7ee511403barEv)();
extern void ABISELECT(_ZThn48_N7ee511403barEv,_ZThn24_N7ee511403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee51140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51140[0]),
  (VTBL_ENTRY)&_ZN7ee511403barEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51140[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee51140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee511403barEv,_ZTv0_n12_N7ee511403barEv),
};
extern VTBL_ENTRY _ZTV7ee51140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee51140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee51140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee51140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee51140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee51140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee51140[] = {
  {&(_ZTV7ee51140[5]),  5,17},
  {&(_ZTV7ee51140[10]),  10,17},
  {&(_ZTV7ee51140[13]),  13,17},
  {&(_ZTV7ee51140[16]),  16,17},
  {&(_tg__ZTV6dd1140__7ee51140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee51140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee51140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee51140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee51140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51140[];
extern  VTBL_ENTRY _ZTV7ee51140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51140[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee511403barEv,_ZTv0_n12_N7ee511403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee511403barEv,_ZThn24_N7ee511403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51140 = {  "ee51140", // class name
  bases_ee51140, 4,
  &(vtc_ee51140[0]), // expected_vtbl_contents
  &(vtt_ee51140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee51140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51140),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61140  : dd1140 {
  int e;
  virtual void  foo(); // _ZN7ee611403fooEv
  virtual void  bar(); // _ZN7ee611403barEv
  ~ee61140(); // tgen
  ee61140(); // tgen
};
//SIG(1 ee61140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee61140 ::foo(){vfunc_called(this, "_ZN7ee611403fooEv");}
void  ee61140 ::bar(){vfunc_called(this, "_ZN7ee611403barEv");}
ee61140 ::~ee61140(){ note_dtor("ee61140", this);} // tgen
ee61140 ::ee61140(){ note_ctor("ee61140", this);} // tgen

static void Test_ee61140()
{
  extern Class_Descriptor cd_ee61140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee61140, buf);
    ee61140 *dp, &lv = *(dp=new (buf) ee61140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee61140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee61140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee61140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(16,12), "ee61140");
    check_base_class_offset(lv, (dd1140*), 0, "ee61140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61140.e");
    test_class_info(&lv, &cd_ee61140);
    dp->~ee61140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61140(Test_ee61140, "ee61140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee61140C1Ev();
extern void _ZN7ee61140D1Ev();
Name_Map name_map_ee61140[] = {
  NSPAIR(_ZN7ee61140C1Ev),
  NSPAIR(_ZN7ee61140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee61140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61140[];
extern void _ZN7ee611403fooEv();
extern void _ZN7ee611403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee611403barEv,_ZTv0_n12_N7ee611403barEv)();
extern void ABISELECT(_ZThn32_N7ee611403barEv,_ZThn20_N7ee611403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61140[0]),
  (VTBL_ENTRY)&_ZN7ee611403fooEv,
  (VTBL_ENTRY)&_ZN7ee611403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee61140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee611403barEv,_ZTv0_n12_N7ee611403barEv),
};
extern VTBL_ENTRY _ZTV7ee61140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee61140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee61140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee61140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee61140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee61140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee61140[] = {
  {&(_ZTV7ee61140[4]),  4,13},
  {&(_tg__ZTV6dd1140__7ee61140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee61140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee61140[3]),  3,4},
  {&(_ZTV7ee61140[9]),  9,13},
  {&(_ZTV7ee61140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee61140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee61140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61140[];
extern  VTBL_ENTRY _ZTV7ee61140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61140[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee611403barEv,_ZTv0_n12_N7ee611403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611403barEv,_ZThn20_N7ee611403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61140 = {  "ee61140", // class name
  bases_ee61140, 4,
  &(vtc_ee61140[0]), // expected_vtbl_contents
  &(vtt_ee61140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee61140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71140  : virtual dd1140 {
  int e;
  virtual void  foo(); // _ZN7ee711403fooEv
  virtual void  bar(); // _ZN7ee711403barEv
  ~ee71140(); // tgen
  ee71140(); // tgen
};
//SIG(1 ee71140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 v2 Fi}


void  ee71140 ::foo(){vfunc_called(this, "_ZN7ee711403fooEv");}
void  ee71140 ::bar(){vfunc_called(this, "_ZN7ee711403barEv");}
ee71140 ::~ee71140(){ note_dtor("ee71140", this);} // tgen
ee71140 ::ee71140(){ note_ctor("ee71140", this);} // tgen

static void Test_ee71140()
{
  extern Class_Descriptor cd_ee71140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee71140, buf);
    ee71140 *dp, &lv = *(dp=new (buf) ee71140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee71140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee71140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee71140");
    check_base_class_offset(lv, (cc140*)(dd1140*), ABISELECT(32,16), "ee71140");
    check_base_class_offset(lv, (dd1140*), ABISELECT(16,8), "ee71140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71140.e");
    test_class_info(&lv, &cd_ee71140);
    dp->~ee71140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71140(Test_ee71140, "ee71140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee71140C1Ev();
extern void _ZN7ee71140D1Ev();
Name_Map name_map_ee71140[] = {
  NSPAIR(_ZN7ee71140C1Ev),
  NSPAIR(_ZN7ee71140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd1140;
extern VTBL_ENTRY _ZTI6dd1140[];
extern  VTBL_ENTRY _ZTV6dd1140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1140[];
static Base_Class bases_ee71140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1140,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71140[];
extern void _ZN7ee711403fooEv();
extern void _ZN7ee711403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee711403barEv,_ZTv0_n12_N7ee711403barEv)();
extern void ABISELECT(_ZThn48_N7ee711403barEv,_ZThn24_N7ee711403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71140[0]),
  (VTBL_ENTRY)&_ZN7ee711403fooEv,
  (VTBL_ENTRY)&_ZN7ee711403barEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71140[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee71140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee711403barEv,_ZTv0_n12_N7ee711403barEv),
};
extern VTBL_ENTRY _ZTV7ee71140[];
static  VTBL_ENTRY _tg__ZTV6dd1140__7ee71140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd1140__7ee71140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd1140__7ee71140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee71140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee71140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee71140[] = {
  {&(_ZTV7ee71140[5]),  5,18},
  {&(_ZTV7ee71140[11]),  11,18},
  {&(_ZTV7ee71140[14]),  14,18},
  {&(_ZTV7ee71140[17]),  17,18},
  {&(_tg__ZTV6dd1140__7ee71140[4]),  4,4},
  {&(_tg__ZTV5cc140__6dd1140__7ee71140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd1140__7ee71140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee71140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee71140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71140[];
extern  VTBL_ENTRY _ZTV7ee71140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71140[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee711403barEv,_ZTv0_n12_N7ee711403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711403barEv,_ZThn24_N7ee711403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71140 = {  "ee71140", // class name
  bases_ee71140, 4,
  &(vtc_ee71140[0]), // expected_vtbl_contents
  &(vtt_ee71140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee71140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71140),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2140  : cc140 {
  int d;
  virtual void  foo(); // _ZN6dd21403fooEv
  ~dd2140(); // tgen
  dd2140(); // tgen
};
//SIG(-1 dd2140) C1{ BC2{ VBC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd2140 ::foo(){vfunc_called(this, "_ZN6dd21403fooEv");}
dd2140 ::~dd2140(){ note_dtor("dd2140", this);} // tgen
dd2140 ::dd2140(){ note_ctor("dd2140", this);} // tgen

static void Test_dd2140()
{
  extern Class_Descriptor cd_dd2140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd2140, buf);
    dd2140 *dp, &lv = *(dp=new (buf) dd2140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd2140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(24,16), "dd2140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(16,12), "dd2140");
    check_base_class_offset(lv, (cc140*), 0, "dd2140");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2140.d");
    test_class_info(&lv, &cd_dd2140);
    dp->~dd2140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2140(Test_dd2140, "dd2140", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd2140C1Ev();
extern void _ZN6dd2140D1Ev();
Name_Map name_map_dd2140[] = {
  NSPAIR(_ZN6dd2140C1Ev),
  NSPAIR(_ZN6dd2140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd2140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2140[];
extern void _ZN6dd21403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_dd2140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV6dd2140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd2140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd2140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd2140[] = {
  {&(_ZTV6dd2140[3]),  3,8},
  {&(_tg__ZTV5cc140__6dd2140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd2140[3]),  3,4},
  {&(_ZTV6dd2140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
Class_Descriptor cd_dd2140 = {  "dd2140", // class name
  bases_dd2140, 3,
  &(vtc_dd2140[0]), // expected_vtbl_contents
  &(vtt_dd2140[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd2140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2140),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02140  : dd2140 {
  int e;
  ~ee02140(); // tgen
  ee02140(); // tgen
};
//SIG(1 ee02140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee02140 ::~ee02140(){ note_dtor("ee02140", this);} // tgen
ee02140 ::ee02140(){ note_ctor("ee02140", this);} // tgen

static void Test_ee02140()
{
  extern Class_Descriptor cd_ee02140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee02140, buf);
    ee02140 *dp, &lv = *(dp=new (buf) ee02140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee02140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee02140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(24,16), "ee02140");
    check_base_class_offset(lv, (cc140*)(dd2140*), 0, "ee02140");
    check_base_class_offset(lv, (dd2140*), 0, "ee02140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02140.e");
    test_class_info(&lv, &cd_ee02140);
    dp->~ee02140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02140(Test_ee02140, "ee02140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee02140C1Ev();
extern void _ZN7ee02140D1Ev();
Name_Map name_map_ee02140[] = {
  NSPAIR(_ZN7ee02140C1Ev),
  NSPAIR(_ZN7ee02140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee02140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02140[];
extern void _ZN6dd21403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee02140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee02140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee02140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee02140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee02140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee02140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee02140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee02140[] = {
  {&(_ZTV7ee02140[3]),  3,8},
  {&(_tg__ZTV6dd2140__7ee02140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee02140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee02140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee02140[3]),  3,4},
  {&(_ZTV7ee02140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee02140[];
extern  VTBL_ENTRY _ZTV7ee02140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02140[];
Class_Descriptor cd_ee02140 = {  "ee02140", // class name
  bases_ee02140, 4,
  &(vtc_ee02140[0]), // expected_vtbl_contents
  &(vtt_ee02140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee02140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12140  : virtual dd2140 {
  int e;
  ~ee12140(); // tgen
  ee12140(); // tgen
};
//SIG(1 ee12140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee12140 ::~ee12140(){ note_dtor("ee12140", this);} // tgen
ee12140 ::ee12140(){ note_ctor("ee12140", this);} // tgen

static void Test_ee12140()
{
  extern Class_Descriptor cd_ee12140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee12140, buf);
    ee12140 *dp, &lv = *(dp=new (buf) ee12140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee12140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee12140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(32,20), "ee12140");
    check_base_class_offset(lv, (cc140*)(dd2140*), ABISELECT(16,8), "ee12140");
    check_base_class_offset(lv, (dd2140*), ABISELECT(16,8), "ee12140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12140.e");
    test_class_info(&lv, &cd_ee12140);
    dp->~ee12140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12140(Test_ee12140, "ee12140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee12140C1Ev();
extern void _ZN7ee12140D1Ev();
Name_Map name_map_ee12140[] = {
  NSPAIR(_ZN7ee12140C1Ev),
  NSPAIR(_ZN7ee12140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee12140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12140[];
extern void _ZN6dd21403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee12140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12140[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee12140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee12140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee12140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee12140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee12140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee12140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee12140[] = {
  {&(_ZTV7ee12140[4]),  4,13},
  {&(_ZTV7ee12140[8]),  8,13},
  {&(_ZTV7ee12140[12]),  12,13},
  {&(_tg__ZTV6dd2140__7ee12140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee12140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee12140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee12140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee12140[];
extern  VTBL_ENTRY _ZTV7ee12140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12140[];
Class_Descriptor cd_ee12140 = {  "ee12140", // class name
  bases_ee12140, 4,
  &(vtc_ee12140[0]), // expected_vtbl_contents
  &(vtt_ee12140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee12140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22140  : dd2140 {
  int e;
  virtual void  foo(); // _ZN7ee221403fooEv
  ~ee22140(); // tgen
  ee22140(); // tgen
};
//SIG(1 ee22140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee22140 ::foo(){vfunc_called(this, "_ZN7ee221403fooEv");}
ee22140 ::~ee22140(){ note_dtor("ee22140", this);} // tgen
ee22140 ::ee22140(){ note_ctor("ee22140", this);} // tgen

static void Test_ee22140()
{
  extern Class_Descriptor cd_ee22140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee22140, buf);
    ee22140 *dp, &lv = *(dp=new (buf) ee22140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee22140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee22140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(24,16), "ee22140");
    check_base_class_offset(lv, (cc140*)(dd2140*), 0, "ee22140");
    check_base_class_offset(lv, (dd2140*), 0, "ee22140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22140.e");
    test_class_info(&lv, &cd_ee22140);
    dp->~ee22140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22140(Test_ee22140, "ee22140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee22140C1Ev();
extern void _ZN7ee22140D1Ev();
Name_Map name_map_ee22140[] = {
  NSPAIR(_ZN7ee22140C1Ev),
  NSPAIR(_ZN7ee22140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee22140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22140[];
extern void _ZN7ee221403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee22140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22140[0]),
  (VTBL_ENTRY)&_ZN7ee221403fooEv,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee22140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee22140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee22140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee22140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee22140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee22140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee22140[] = {
  {&(_ZTV7ee22140[3]),  3,8},
  {&(_tg__ZTV6dd2140__7ee22140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee22140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee22140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee22140[3]),  3,4},
  {&(_ZTV7ee22140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee22140[];
extern  VTBL_ENTRY _ZTV7ee22140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22140[];
Class_Descriptor cd_ee22140 = {  "ee22140", // class name
  bases_ee22140, 4,
  &(vtc_ee22140[0]), // expected_vtbl_contents
  &(vtt_ee22140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee22140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32140  : virtual dd2140 {
  int e;
  virtual void  foo(); // _ZN7ee321403fooEv
  ~ee32140(); // tgen
  ee32140(); // tgen
};
//SIG(1 ee32140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee32140 ::foo(){vfunc_called(this, "_ZN7ee321403fooEv");}
ee32140 ::~ee32140(){ note_dtor("ee32140", this);} // tgen
ee32140 ::ee32140(){ note_ctor("ee32140", this);} // tgen

static void Test_ee32140()
{
  extern Class_Descriptor cd_ee32140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee32140, buf);
    ee32140 *dp, &lv = *(dp=new (buf) ee32140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee32140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee32140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(32,20), "ee32140");
    check_base_class_offset(lv, (cc140*)(dd2140*), ABISELECT(16,8), "ee32140");
    check_base_class_offset(lv, (dd2140*), ABISELECT(16,8), "ee32140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32140.e");
    test_class_info(&lv, &cd_ee32140);
    dp->~ee32140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32140(Test_ee32140, "ee32140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee32140C1Ev();
extern void _ZN7ee32140D1Ev();
Name_Map name_map_ee32140[] = {
  NSPAIR(_ZN7ee32140C1Ev),
  NSPAIR(_ZN7ee32140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee32140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32140[];
extern void _ZN7ee321403fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee321403fooEv,_ZTv0_n16_N7ee321403fooEv)();
extern void ABISELECT(_ZThn16_N7ee321403fooEv,_ZThn8_N7ee321403fooEv)() __attribute__((weak));
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee32140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32140[0]),
  (VTBL_ENTRY)&_ZN7ee321403fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee321403fooEv,_ZTv0_n16_N7ee321403fooEv),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee32140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee32140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee32140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee32140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee32140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee32140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee32140[] = {
  {&(_ZTV7ee32140[4]),  4,14},
  {&(_ZTV7ee32140[9]),  9,14},
  {&(_ZTV7ee32140[13]),  13,14},
  {&(_tg__ZTV6dd2140__7ee32140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee32140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee32140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee32140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee32140[];
extern  VTBL_ENTRY _ZTV7ee32140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32140[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee321403fooEv,_ZTv0_n16_N7ee321403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321403fooEv,_ZThn8_N7ee321403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32140 = {  "ee32140", // class name
  bases_ee32140, 4,
  &(vtc_ee32140[0]), // expected_vtbl_contents
  &(vtt_ee32140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee32140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32140),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42140  : dd2140 {
  int e;
  virtual void  bar(); // _ZN7ee421403barEv
  ~ee42140(); // tgen
  ee42140(); // tgen
};
//SIG(1 ee42140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee42140 ::bar(){vfunc_called(this, "_ZN7ee421403barEv");}
ee42140 ::~ee42140(){ note_dtor("ee42140", this);} // tgen
ee42140 ::ee42140(){ note_ctor("ee42140", this);} // tgen

static void Test_ee42140()
{
  extern Class_Descriptor cd_ee42140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee42140, buf);
    ee42140 *dp, &lv = *(dp=new (buf) ee42140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee42140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee42140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(24,16), "ee42140");
    check_base_class_offset(lv, (cc140*)(dd2140*), 0, "ee42140");
    check_base_class_offset(lv, (dd2140*), 0, "ee42140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42140.e");
    test_class_info(&lv, &cd_ee42140);
    dp->~ee42140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42140(Test_ee42140, "ee42140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee42140C1Ev();
extern void _ZN7ee42140D1Ev();
Name_Map name_map_ee42140[] = {
  NSPAIR(_ZN7ee42140C1Ev),
  NSPAIR(_ZN7ee42140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee42140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42140[];
extern void _ZN6dd21403fooEv();
extern void _ZN7ee421403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee421403barEv,_ZTv0_n12_N7ee421403barEv)();
extern void ABISELECT(_ZThn24_N7ee421403barEv,_ZThn16_N7ee421403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee42140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
  (VTBL_ENTRY)&_ZN7ee421403barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee42140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee421403barEv,_ZTv0_n12_N7ee421403barEv),
};
extern VTBL_ENTRY _ZTV7ee42140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee42140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee42140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee42140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee42140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee42140[] = {
  {&(_ZTV7ee42140[3]),  3,9},
  {&(_tg__ZTV6dd2140__7ee42140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee42140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee42140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee42140[3]),  3,4},
  {&(_ZTV7ee42140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee42140[];
extern  VTBL_ENTRY _ZTV7ee42140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42140[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee421403barEv,_ZTv0_n12_N7ee421403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee421403barEv,_ZThn16_N7ee421403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee42140 = {  "ee42140", // class name
  bases_ee42140, 4,
  &(vtc_ee42140[0]), // expected_vtbl_contents
  &(vtt_ee42140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee42140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52140  : virtual dd2140 {
  int e;
  virtual void  bar(); // _ZN7ee521403barEv
  ~ee52140(); // tgen
  ee52140(); // tgen
};
//SIG(1 ee52140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee52140 ::bar(){vfunc_called(this, "_ZN7ee521403barEv");}
ee52140 ::~ee52140(){ note_dtor("ee52140", this);} // tgen
ee52140 ::ee52140(){ note_ctor("ee52140", this);} // tgen

static void Test_ee52140()
{
  extern Class_Descriptor cd_ee52140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee52140, buf);
    ee52140 *dp, &lv = *(dp=new (buf) ee52140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee52140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee52140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(32,20), "ee52140");
    check_base_class_offset(lv, (cc140*)(dd2140*), ABISELECT(16,8), "ee52140");
    check_base_class_offset(lv, (dd2140*), ABISELECT(16,8), "ee52140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52140.e");
    test_class_info(&lv, &cd_ee52140);
    dp->~ee52140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52140(Test_ee52140, "ee52140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee52140C1Ev();
extern void _ZN7ee52140D1Ev();
Name_Map name_map_ee52140[] = {
  NSPAIR(_ZN7ee52140C1Ev),
  NSPAIR(_ZN7ee52140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee52140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52140[];
extern void _ZN7ee521403barEv();
extern void _ZN6dd21403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee521403barEv,_ZTv0_n12_N7ee521403barEv)();
extern void ABISELECT(_ZThn32_N7ee521403barEv,_ZThn20_N7ee521403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee52140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52140[0]),
  (VTBL_ENTRY)&_ZN7ee521403barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee52140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee521403barEv,_ZTv0_n12_N7ee521403barEv),
};
extern VTBL_ENTRY _ZTV7ee52140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee52140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee52140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee52140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee52140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee52140[] = {
  {&(_ZTV7ee52140[4]),  4,14},
  {&(_ZTV7ee52140[9]),  9,14},
  {&(_ZTV7ee52140[13]),  13,14},
  {&(_tg__ZTV6dd2140__7ee52140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee52140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee52140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee52140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee52140[];
extern  VTBL_ENTRY _ZTV7ee52140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52140[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee521403barEv,_ZTv0_n12_N7ee521403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee521403barEv,_ZThn20_N7ee521403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52140 = {  "ee52140", // class name
  bases_ee52140, 4,
  &(vtc_ee52140[0]), // expected_vtbl_contents
  &(vtt_ee52140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee52140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52140),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62140  : dd2140 {
  int e;
  virtual void  foo(); // _ZN7ee621403fooEv
  virtual void  bar(); // _ZN7ee621403barEv
  ~ee62140(); // tgen
  ee62140(); // tgen
};
//SIG(1 ee62140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62140 ::foo(){vfunc_called(this, "_ZN7ee621403fooEv");}
void  ee62140 ::bar(){vfunc_called(this, "_ZN7ee621403barEv");}
ee62140 ::~ee62140(){ note_dtor("ee62140", this);} // tgen
ee62140 ::ee62140(){ note_ctor("ee62140", this);} // tgen

static void Test_ee62140()
{
  extern Class_Descriptor cd_ee62140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee62140, buf);
    ee62140 *dp, &lv = *(dp=new (buf) ee62140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee62140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee62140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(24,16), "ee62140");
    check_base_class_offset(lv, (cc140*)(dd2140*), 0, "ee62140");
    check_base_class_offset(lv, (dd2140*), 0, "ee62140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62140.e");
    test_class_info(&lv, &cd_ee62140);
    dp->~ee62140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62140(Test_ee62140, "ee62140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee62140C1Ev();
extern void _ZN7ee62140D1Ev();
Name_Map name_map_ee62140[] = {
  NSPAIR(_ZN7ee62140C1Ev),
  NSPAIR(_ZN7ee62140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee62140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62140[];
extern void _ZN7ee621403fooEv();
extern void _ZN7ee621403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee621403barEv,_ZTv0_n12_N7ee621403barEv)();
extern void ABISELECT(_ZThn24_N7ee621403barEv,_ZThn16_N7ee621403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee62140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62140[0]),
  (VTBL_ENTRY)&_ZN7ee621403fooEv,
  (VTBL_ENTRY)&_ZN7ee621403barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee62140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee621403barEv,_ZTv0_n12_N7ee621403barEv),
};
extern VTBL_ENTRY _ZTV7ee62140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee62140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee62140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee62140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee62140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee62140[] = {
  {&(_ZTV7ee62140[3]),  3,9},
  {&(_tg__ZTV6dd2140__7ee62140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee62140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee62140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee62140[3]),  3,4},
  {&(_ZTV7ee62140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee62140[];
extern  VTBL_ENTRY _ZTV7ee62140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62140[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee621403barEv,_ZTv0_n12_N7ee621403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621403barEv,_ZThn16_N7ee621403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee62140 = {  "ee62140", // class name
  bases_ee62140, 4,
  &(vtc_ee62140[0]), // expected_vtbl_contents
  &(vtt_ee62140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee62140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72140  : virtual dd2140 {
  int e;
  virtual void  foo(); // _ZN7ee721403fooEv
  virtual void  bar(); // _ZN7ee721403barEv
  ~ee72140(); // tgen
  ee72140(); // tgen
};
//SIG(1 ee72140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72140 ::foo(){vfunc_called(this, "_ZN7ee721403fooEv");}
void  ee72140 ::bar(){vfunc_called(this, "_ZN7ee721403barEv");}
ee72140 ::~ee72140(){ note_dtor("ee72140", this);} // tgen
ee72140 ::ee72140(){ note_ctor("ee72140", this);} // tgen

static void Test_ee72140()
{
  extern Class_Descriptor cd_ee72140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee72140, buf);
    ee72140 *dp, &lv = *(dp=new (buf) ee72140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee72140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee72140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd2140*), ABISELECT(32,20), "ee72140");
    check_base_class_offset(lv, (cc140*)(dd2140*), ABISELECT(16,8), "ee72140");
    check_base_class_offset(lv, (dd2140*), ABISELECT(16,8), "ee72140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72140.e");
    test_class_info(&lv, &cd_ee72140);
    dp->~ee72140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72140(Test_ee72140, "ee72140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee72140C1Ev();
extern void _ZN7ee72140D1Ev();
Name_Map name_map_ee72140[] = {
  NSPAIR(_ZN7ee72140C1Ev),
  NSPAIR(_ZN7ee72140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd2140;
extern VTBL_ENTRY _ZTI6dd2140[];
extern  VTBL_ENTRY _ZTV6dd2140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2140[];
static Base_Class bases_ee72140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72140[];
extern void _ZN7ee721403fooEv();
extern void _ZN7ee721403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee721403fooEv,_ZTv0_n16_N7ee721403fooEv)();
extern void ABISELECT(_ZThn16_N7ee721403fooEv,_ZThn8_N7ee721403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee721403barEv,_ZTv0_n12_N7ee721403barEv)();
extern void ABISELECT(_ZThn32_N7ee721403barEv,_ZThn20_N7ee721403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72140[0]),
  (VTBL_ENTRY)&_ZN7ee721403fooEv,
  (VTBL_ENTRY)&_ZN7ee721403barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721403fooEv,_ZTv0_n16_N7ee721403fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee72140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee721403barEv,_ZTv0_n12_N7ee721403barEv),
};
extern VTBL_ENTRY _ZTV7ee72140[];
extern void _ZN6dd21403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2140__7ee72140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN6dd21403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd2140__7ee72140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd2140__7ee72140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd2140__7ee72140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee72140[] = {
  {&(_ZTV7ee72140[4]),  4,15},
  {&(_ZTV7ee72140[10]),  10,15},
  {&(_ZTV7ee72140[14]),  14,15},
  {&(_tg__ZTV6dd2140__7ee72140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd2140__7ee72140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd2140__7ee72140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd2140__7ee72140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee72140[];
extern  VTBL_ENTRY _ZTV7ee72140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72140[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee721403barEv,_ZTv0_n12_N7ee721403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721403barEv,_ZThn20_N7ee721403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee721403fooEv,_ZTv0_n16_N7ee721403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721403fooEv,_ZThn8_N7ee721403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72140 = {  "ee72140", // class name
  bases_ee72140, 4,
  &(vtc_ee72140[0]), // expected_vtbl_contents
  &(vtt_ee72140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee72140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72140),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3140  : virtual cc140 {
  int d;
  virtual void  foo(); // _ZN6dd31403fooEv
  ~dd3140(); // tgen
  dd3140(); // tgen
};
//SIG(-1 dd3140) C1{ VBC2{ VBC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd3140 ::foo(){vfunc_called(this, "_ZN6dd31403fooEv");}
dd3140 ::~dd3140(){ note_dtor("dd3140", this);} // tgen
dd3140 ::dd3140(){ note_ctor("dd3140", this);} // tgen

static void Test_dd3140()
{
  extern Class_Descriptor cd_dd3140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd3140, buf);
    dd3140 *dp, &lv = *(dp=new (buf) dd3140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd3140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,20), "dd3140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,16), "dd3140");
    check_base_class_offset(lv, (cc140*), ABISELECT(16,8), "dd3140");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3140.d");
    test_class_info(&lv, &cd_dd3140);
    dp->~dd3140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3140(Test_dd3140, "dd3140", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd3140C1Ev();
extern void _ZN6dd3140D1Ev();
Name_Map name_map_dd3140[] = {
  NSPAIR(_ZN6dd3140C1Ev),
  NSPAIR(_ZN6dd3140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd3140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3140[];
extern void _ZN6dd31403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_dd3140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV6dd3140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd3140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd3140[] = {
  {&(_ZTV6dd3140[4]),  4,12},
  {&(_ZTV6dd3140[8]),  8,12},
  {&(_ZTV6dd3140[11]),  11,12},
  {&(_tg__ZTV5cc140__6dd3140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd3140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
Class_Descriptor cd_dd3140 = {  "dd3140", // class name
  bases_dd3140, 3,
  &(vtc_dd3140[0]), // expected_vtbl_contents
  &(vtt_dd3140[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd3140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3140),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03140  : dd3140 {
  int e;
  ~ee03140(); // tgen
  ee03140(); // tgen
};
//SIG(1 ee03140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee03140 ::~ee03140(){ note_dtor("ee03140", this);} // tgen
ee03140 ::ee03140(){ note_ctor("ee03140", this);} // tgen

static void Test_ee03140()
{
  extern Class_Descriptor cd_ee03140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee03140, buf);
    ee03140 *dp, &lv = *(dp=new (buf) ee03140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee03140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee03140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee03140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(16,12), "ee03140");
    check_base_class_offset(lv, (dd3140*), 0, "ee03140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03140.e");
    test_class_info(&lv, &cd_ee03140);
    dp->~ee03140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03140(Test_ee03140, "ee03140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee03140C1Ev();
extern void _ZN7ee03140D1Ev();
Name_Map name_map_ee03140[] = {
  NSPAIR(_ZN7ee03140C1Ev),
  NSPAIR(_ZN7ee03140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee03140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03140[];
extern void _ZN6dd31403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee03140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03140[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee03140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee03140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee03140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee03140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee03140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee03140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee03140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee03140[] = {
  {&(_ZTV7ee03140[4]),  4,12},
  {&(_tg__ZTV6dd3140__7ee03140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee03140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee03140[3]),  3,4},
  {&(_ZTV7ee03140[8]),  8,12},
  {&(_ZTV7ee03140[11]),  11,12},
  {&(_tg__ZTV5cc140__7ee03140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee03140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee03140[];
extern  VTBL_ENTRY _ZTV7ee03140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03140[];
Class_Descriptor cd_ee03140 = {  "ee03140", // class name
  bases_ee03140, 4,
  &(vtc_ee03140[0]), // expected_vtbl_contents
  &(vtt_ee03140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee03140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13140  : virtual dd3140 {
  int e;
  ~ee13140(); // tgen
  ee13140(); // tgen
};
//SIG(1 ee13140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee13140 ::~ee13140(){ note_dtor("ee13140", this);} // tgen
ee13140 ::ee13140(){ note_ctor("ee13140", this);} // tgen

static void Test_ee13140()
{
  extern Class_Descriptor cd_ee13140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee13140, buf);
    ee13140 *dp, &lv = *(dp=new (buf) ee13140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee13140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee13140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee13140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(32,16), "ee13140");
    check_base_class_offset(lv, (dd3140*), ABISELECT(16,8), "ee13140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13140.e");
    test_class_info(&lv, &cd_ee13140);
    dp->~ee13140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13140(Test_ee13140, "ee13140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee13140C1Ev();
extern void _ZN7ee13140D1Ev();
Name_Map name_map_ee13140[] = {
  NSPAIR(_ZN7ee13140C1Ev),
  NSPAIR(_ZN7ee13140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee13140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13140[];
extern void _ZN6dd31403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee13140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13140[0]),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13140[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee13140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee13140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee13140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee13140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee13140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee13140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee13140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee13140[] = {
  {&(_ZTV7ee13140[5]),  5,18},
  {&(_ZTV7ee13140[10]),  10,18},
  {&(_ZTV7ee13140[14]),  14,18},
  {&(_ZTV7ee13140[17]),  17,18},
  {&(_tg__ZTV6dd3140__7ee13140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee13140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee13140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee13140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee13140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13140[];
extern  VTBL_ENTRY _ZTV7ee13140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13140[];
Class_Descriptor cd_ee13140 = {  "ee13140", // class name
  bases_ee13140, 4,
  &(vtc_ee13140[0]), // expected_vtbl_contents
  &(vtt_ee13140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee13140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13140),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23140  : dd3140 {
  int e;
  virtual void  foo(); // _ZN7ee231403fooEv
  ~ee23140(); // tgen
  ee23140(); // tgen
};
//SIG(1 ee23140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee23140 ::foo(){vfunc_called(this, "_ZN7ee231403fooEv");}
ee23140 ::~ee23140(){ note_dtor("ee23140", this);} // tgen
ee23140 ::ee23140(){ note_ctor("ee23140", this);} // tgen

static void Test_ee23140()
{
  extern Class_Descriptor cd_ee23140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee23140, buf);
    ee23140 *dp, &lv = *(dp=new (buf) ee23140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee23140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee23140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee23140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(16,12), "ee23140");
    check_base_class_offset(lv, (dd3140*), 0, "ee23140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23140.e");
    test_class_info(&lv, &cd_ee23140);
    dp->~ee23140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23140(Test_ee23140, "ee23140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee23140C1Ev();
extern void _ZN7ee23140D1Ev();
Name_Map name_map_ee23140[] = {
  NSPAIR(_ZN7ee23140C1Ev),
  NSPAIR(_ZN7ee23140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee23140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23140[];
extern void _ZN7ee231403fooEv();
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee23140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23140[0]),
  (VTBL_ENTRY)&_ZN7ee231403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23140[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee23140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee23140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee23140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee23140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee23140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee23140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee23140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee23140[] = {
  {&(_ZTV7ee23140[4]),  4,12},
  {&(_tg__ZTV6dd3140__7ee23140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee23140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee23140[3]),  3,4},
  {&(_ZTV7ee23140[8]),  8,12},
  {&(_ZTV7ee23140[11]),  11,12},
  {&(_tg__ZTV5cc140__7ee23140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee23140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee23140[];
extern  VTBL_ENTRY _ZTV7ee23140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23140[];
Class_Descriptor cd_ee23140 = {  "ee23140", // class name
  bases_ee23140, 4,
  &(vtc_ee23140[0]), // expected_vtbl_contents
  &(vtt_ee23140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee23140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33140  : virtual dd3140 {
  int e;
  virtual void  foo(); // _ZN7ee331403fooEv
  ~ee33140(); // tgen
  ee33140(); // tgen
};
//SIG(1 ee33140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee33140 ::foo(){vfunc_called(this, "_ZN7ee331403fooEv");}
ee33140 ::~ee33140(){ note_dtor("ee33140", this);} // tgen
ee33140 ::ee33140(){ note_ctor("ee33140", this);} // tgen

static void Test_ee33140()
{
  extern Class_Descriptor cd_ee33140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee33140, buf);
    ee33140 *dp, &lv = *(dp=new (buf) ee33140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee33140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee33140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee33140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(32,16), "ee33140");
    check_base_class_offset(lv, (dd3140*), ABISELECT(16,8), "ee33140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33140.e");
    test_class_info(&lv, &cd_ee33140);
    dp->~ee33140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33140(Test_ee33140, "ee33140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee33140C1Ev();
extern void _ZN7ee33140D1Ev();
Name_Map name_map_ee33140[] = {
  NSPAIR(_ZN7ee33140C1Ev),
  NSPAIR(_ZN7ee33140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee33140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33140[];
extern void _ZN7ee331403fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee331403fooEv,_ZTv0_n20_N7ee331403fooEv)();
extern void ABISELECT(_ZThn16_N7ee331403fooEv,_ZThn8_N7ee331403fooEv)() __attribute__((weak));
extern void _ZN4bb403barEv();
static  VTBL_ENTRY vtc_ee33140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33140[0]),
  (VTBL_ENTRY)&_ZN7ee331403fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee331403fooEv,_ZTv0_n20_N7ee331403fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33140[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee33140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern VTBL_ENTRY _ZTV7ee33140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee33140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee33140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee33140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee33140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee33140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee33140[] = {
  {&(_ZTV7ee33140[5]),  5,19},
  {&(_ZTV7ee33140[11]),  11,19},
  {&(_ZTV7ee33140[15]),  15,19},
  {&(_ZTV7ee33140[18]),  18,19},
  {&(_tg__ZTV6dd3140__7ee33140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee33140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee33140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee33140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee33140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33140[];
extern  VTBL_ENTRY _ZTV7ee33140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33140[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee331403fooEv,_ZTv0_n20_N7ee331403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331403fooEv,_ZThn8_N7ee331403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33140 = {  "ee33140", // class name
  bases_ee33140, 4,
  &(vtc_ee33140[0]), // expected_vtbl_contents
  &(vtt_ee33140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee33140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33140),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43140  : dd3140 {
  int e;
  virtual void  bar(); // _ZN7ee431403barEv
  ~ee43140(); // tgen
  ee43140(); // tgen
};
//SIG(1 ee43140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee43140 ::bar(){vfunc_called(this, "_ZN7ee431403barEv");}
ee43140 ::~ee43140(){ note_dtor("ee43140", this);} // tgen
ee43140 ::ee43140(){ note_ctor("ee43140", this);} // tgen

static void Test_ee43140()
{
  extern Class_Descriptor cd_ee43140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee43140, buf);
    ee43140 *dp, &lv = *(dp=new (buf) ee43140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee43140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee43140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee43140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(16,12), "ee43140");
    check_base_class_offset(lv, (dd3140*), 0, "ee43140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43140.e");
    test_class_info(&lv, &cd_ee43140);
    dp->~ee43140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43140(Test_ee43140, "ee43140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee43140C1Ev();
extern void _ZN7ee43140D1Ev();
Name_Map name_map_ee43140[] = {
  NSPAIR(_ZN7ee43140C1Ev),
  NSPAIR(_ZN7ee43140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee43140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43140[];
extern void _ZN6dd31403fooEv();
extern void _ZN7ee431403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee431403barEv,_ZTv0_n12_N7ee431403barEv)();
extern void ABISELECT(_ZThn32_N7ee431403barEv,_ZThn20_N7ee431403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
  (VTBL_ENTRY)&_ZN7ee431403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee43140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee431403barEv,_ZTv0_n12_N7ee431403barEv),
};
extern VTBL_ENTRY _ZTV7ee43140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee43140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee43140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee43140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee43140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee43140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee43140[] = {
  {&(_ZTV7ee43140[4]),  4,13},
  {&(_tg__ZTV6dd3140__7ee43140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee43140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee43140[3]),  3,4},
  {&(_ZTV7ee43140[9]),  9,13},
  {&(_ZTV7ee43140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee43140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee43140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee43140[];
extern  VTBL_ENTRY _ZTV7ee43140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43140[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee431403barEv,_ZTv0_n12_N7ee431403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee431403barEv,_ZThn20_N7ee431403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43140 = {  "ee43140", // class name
  bases_ee43140, 4,
  &(vtc_ee43140[0]), // expected_vtbl_contents
  &(vtt_ee43140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee43140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53140  : virtual dd3140 {
  int e;
  virtual void  bar(); // _ZN7ee531403barEv
  ~ee53140(); // tgen
  ee53140(); // tgen
};
//SIG(1 ee53140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee53140 ::bar(){vfunc_called(this, "_ZN7ee531403barEv");}
ee53140 ::~ee53140(){ note_dtor("ee53140", this);} // tgen
ee53140 ::ee53140(){ note_ctor("ee53140", this);} // tgen

static void Test_ee53140()
{
  extern Class_Descriptor cd_ee53140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee53140, buf);
    ee53140 *dp, &lv = *(dp=new (buf) ee53140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee53140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee53140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee53140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(32,16), "ee53140");
    check_base_class_offset(lv, (dd3140*), ABISELECT(16,8), "ee53140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53140.e");
    test_class_info(&lv, &cd_ee53140);
    dp->~ee53140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53140(Test_ee53140, "ee53140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee53140C1Ev();
extern void _ZN7ee53140D1Ev();
Name_Map name_map_ee53140[] = {
  NSPAIR(_ZN7ee53140C1Ev),
  NSPAIR(_ZN7ee53140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee53140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53140[];
extern void _ZN7ee531403barEv();
extern void _ZN6dd31403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee531403barEv,_ZTv0_n12_N7ee531403barEv)();
extern void ABISELECT(_ZThn48_N7ee531403barEv,_ZThn24_N7ee531403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53140[0]),
  (VTBL_ENTRY)&_ZN7ee531403barEv,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee53140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee531403barEv,_ZTv0_n12_N7ee531403barEv),
};
extern VTBL_ENTRY _ZTV7ee53140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee53140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee53140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee53140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee53140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee53140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee53140[] = {
  {&(_ZTV7ee53140[5]),  5,19},
  {&(_ZTV7ee53140[11]),  11,19},
  {&(_ZTV7ee53140[15]),  15,19},
  {&(_ZTV7ee53140[18]),  18,19},
  {&(_tg__ZTV6dd3140__7ee53140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee53140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee53140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee53140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee53140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53140[];
extern  VTBL_ENTRY _ZTV7ee53140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53140[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee531403barEv,_ZTv0_n12_N7ee531403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee531403barEv,_ZThn24_N7ee531403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53140 = {  "ee53140", // class name
  bases_ee53140, 4,
  &(vtc_ee53140[0]), // expected_vtbl_contents
  &(vtt_ee53140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee53140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53140),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63140  : dd3140 {
  int e;
  virtual void  foo(); // _ZN7ee631403fooEv
  virtual void  bar(); // _ZN7ee631403barEv
  ~ee63140(); // tgen
  ee63140(); // tgen
};
//SIG(1 ee63140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63140 ::foo(){vfunc_called(this, "_ZN7ee631403fooEv");}
void  ee63140 ::bar(){vfunc_called(this, "_ZN7ee631403barEv");}
ee63140 ::~ee63140(){ note_dtor("ee63140", this);} // tgen
ee63140 ::ee63140(){ note_ctor("ee63140", this);} // tgen

static void Test_ee63140()
{
  extern Class_Descriptor cd_ee63140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee63140, buf);
    ee63140 *dp, &lv = *(dp=new (buf) ee63140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee63140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee63140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee63140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(16,12), "ee63140");
    check_base_class_offset(lv, (dd3140*), 0, "ee63140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63140.e");
    test_class_info(&lv, &cd_ee63140);
    dp->~ee63140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63140(Test_ee63140, "ee63140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee63140C1Ev();
extern void _ZN7ee63140D1Ev();
Name_Map name_map_ee63140[] = {
  NSPAIR(_ZN7ee63140C1Ev),
  NSPAIR(_ZN7ee63140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee63140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63140[];
extern void _ZN7ee631403fooEv();
extern void _ZN7ee631403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee631403barEv,_ZTv0_n12_N7ee631403barEv)();
extern void ABISELECT(_ZThn32_N7ee631403barEv,_ZThn20_N7ee631403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63140[0]),
  (VTBL_ENTRY)&_ZN7ee631403fooEv,
  (VTBL_ENTRY)&_ZN7ee631403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee63140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee631403barEv,_ZTv0_n12_N7ee631403barEv),
};
extern VTBL_ENTRY _ZTV7ee63140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee63140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee63140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee63140[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee63140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee63140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee63140[] = {
  {&(_ZTV7ee63140[4]),  4,13},
  {&(_tg__ZTV6dd3140__7ee63140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee63140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee63140[3]),  3,4},
  {&(_ZTV7ee63140[9]),  9,13},
  {&(_ZTV7ee63140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee63140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee63140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee63140[];
extern  VTBL_ENTRY _ZTV7ee63140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63140[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee631403barEv,_ZTv0_n12_N7ee631403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631403barEv,_ZThn20_N7ee631403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63140 = {  "ee63140", // class name
  bases_ee63140, 4,
  &(vtc_ee63140[0]), // expected_vtbl_contents
  &(vtt_ee63140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee63140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73140  : virtual dd3140 {
  int e;
  virtual void  foo(); // _ZN7ee731403fooEv
  virtual void  bar(); // _ZN7ee731403barEv
  ~ee73140(); // tgen
  ee73140(); // tgen
};
//SIG(1 ee73140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73140 ::foo(){vfunc_called(this, "_ZN7ee731403fooEv");}
void  ee73140 ::bar(){vfunc_called(this, "_ZN7ee731403barEv");}
ee73140 ::~ee73140(){ note_dtor("ee73140", this);} // tgen
ee73140 ::ee73140(){ note_ctor("ee73140", this);} // tgen

static void Test_ee73140()
{
  extern Class_Descriptor cd_ee73140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee73140, buf);
    ee73140 *dp, &lv = *(dp=new (buf) ee73140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee73140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee73140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee73140");
    check_base_class_offset(lv, (cc140*)(dd3140*), ABISELECT(32,16), "ee73140");
    check_base_class_offset(lv, (dd3140*), ABISELECT(16,8), "ee73140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73140.e");
    test_class_info(&lv, &cd_ee73140);
    dp->~ee73140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73140(Test_ee73140, "ee73140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee73140C1Ev();
extern void _ZN7ee73140D1Ev();
Name_Map name_map_ee73140[] = {
  NSPAIR(_ZN7ee73140C1Ev),
  NSPAIR(_ZN7ee73140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd3140;
extern VTBL_ENTRY _ZTI6dd3140[];
extern  VTBL_ENTRY _ZTV6dd3140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3140[];
static Base_Class bases_ee73140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3140,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73140[];
extern void _ZN7ee731403fooEv();
extern void _ZN7ee731403barEv();
extern void ABISELECT(_ZTv0_n40_N7ee731403fooEv,_ZTv0_n20_N7ee731403fooEv)();
extern void ABISELECT(_ZThn16_N7ee731403fooEv,_ZThn8_N7ee731403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee731403barEv,_ZTv0_n12_N7ee731403barEv)();
extern void ABISELECT(_ZThn48_N7ee731403barEv,_ZThn24_N7ee731403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73140[0]),
  (VTBL_ENTRY)&_ZN7ee731403fooEv,
  (VTBL_ENTRY)&_ZN7ee731403barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee731403fooEv,_ZTv0_n20_N7ee731403fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee73140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee731403barEv,_ZTv0_n12_N7ee731403barEv),
};
extern VTBL_ENTRY _ZTV7ee73140[];
extern void _ZN6dd31403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3140__7ee73140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN6dd31403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd3140__7ee73140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__6dd3140__7ee73140[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee73140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee73140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee73140[] = {
  {&(_ZTV7ee73140[5]),  5,20},
  {&(_ZTV7ee73140[12]),  12,20},
  {&(_ZTV7ee73140[16]),  16,20},
  {&(_ZTV7ee73140[19]),  19,20},
  {&(_tg__ZTV6dd3140__7ee73140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd3140__7ee73140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd3140__7ee73140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee73140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee73140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73140[];
extern  VTBL_ENTRY _ZTV7ee73140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73140[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee731403barEv,_ZTv0_n12_N7ee731403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731403barEv,_ZThn24_N7ee731403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee731403fooEv,_ZTv0_n20_N7ee731403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731403fooEv,_ZThn8_N7ee731403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73140 = {  "ee73140", // class name
  bases_ee73140, 4,
  &(vtc_ee73140[0]), // expected_vtbl_contents
  &(vtt_ee73140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee73140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73140),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4140  : cc140 {
  int d;
  virtual void  bar(); // _ZN6dd41403barEv
  ~dd4140(); // tgen
  dd4140(); // tgen
};
//SIG(-1 dd4140) C1{ BC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd4140 ::bar(){vfunc_called(this, "_ZN6dd41403barEv");}
dd4140 ::~dd4140(){ note_dtor("dd4140", this);} // tgen
dd4140 ::dd4140(){ note_ctor("dd4140", this);} // tgen

static void Test_dd4140()
{
  extern Class_Descriptor cd_dd4140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd4140, buf);
    dd4140 *dp, &lv = *(dp=new (buf) dd4140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd4140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(24,16), "dd4140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(16,12), "dd4140");
    check_base_class_offset(lv, (cc140*), 0, "dd4140");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4140.d");
    test_class_info(&lv, &cd_dd4140);
    dp->~dd4140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4140(Test_dd4140, "dd4140", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd4140C1Ev();
extern void _ZN6dd4140D1Ev();
Name_Map name_map_dd4140[] = {
  NSPAIR(_ZN6dd4140C1Ev),
  NSPAIR(_ZN6dd4140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd4140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4140[];
extern void _ZN6dd41403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd4140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
extern VTBL_ENTRY _ZTV6dd4140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd4140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd4140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd4140[] = {
  {&(_ZTV6dd4140[3]),  3,8},
  {&(_tg__ZTV5cc140__6dd4140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd4140[3]),  3,4},
  {&(_ZTV6dd4140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd4140 = {  "dd4140", // class name
  bases_dd4140, 3,
  &(vtc_dd4140[0]), // expected_vtbl_contents
  &(vtt_dd4140[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd4140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4140),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04140  : dd4140 {
  int e;
  ~ee04140(); // tgen
  ee04140(); // tgen
};
//SIG(1 ee04140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee04140 ::~ee04140(){ note_dtor("ee04140", this);} // tgen
ee04140 ::ee04140(){ note_ctor("ee04140", this);} // tgen

static void Test_ee04140()
{
  extern Class_Descriptor cd_ee04140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee04140, buf);
    ee04140 *dp, &lv = *(dp=new (buf) ee04140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee04140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee04140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(24,16), "ee04140");
    check_base_class_offset(lv, (cc140*)(dd4140*), 0, "ee04140");
    check_base_class_offset(lv, (dd4140*), 0, "ee04140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04140.e");
    test_class_info(&lv, &cd_ee04140);
    dp->~ee04140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04140(Test_ee04140, "ee04140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee04140C1Ev();
extern void _ZN7ee04140D1Ev();
Name_Map name_map_ee04140[] = {
  NSPAIR(_ZN7ee04140C1Ev),
  NSPAIR(_ZN7ee04140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee04140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04140[];
extern void _ZN6dd41403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee04140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee04140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
extern VTBL_ENTRY _ZTV7ee04140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee04140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee04140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee04140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee04140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee04140[] = {
  {&(_ZTV7ee04140[3]),  3,8},
  {&(_tg__ZTV6dd4140__7ee04140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee04140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee04140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee04140[3]),  3,4},
  {&(_ZTV7ee04140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee04140[];
extern  VTBL_ENTRY _ZTV7ee04140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04140[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee04140 = {  "ee04140", // class name
  bases_ee04140, 4,
  &(vtc_ee04140[0]), // expected_vtbl_contents
  &(vtt_ee04140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee04140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14140  : virtual dd4140 {
  int e;
  ~ee14140(); // tgen
  ee14140(); // tgen
};
//SIG(1 ee14140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee14140 ::~ee14140(){ note_dtor("ee14140", this);} // tgen
ee14140 ::ee14140(){ note_ctor("ee14140", this);} // tgen

static void Test_ee14140()
{
  extern Class_Descriptor cd_ee14140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee14140, buf);
    ee14140 *dp, &lv = *(dp=new (buf) ee14140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee14140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee14140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(32,20), "ee14140");
    check_base_class_offset(lv, (cc140*)(dd4140*), ABISELECT(16,8), "ee14140");
    check_base_class_offset(lv, (dd4140*), ABISELECT(16,8), "ee14140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14140.e");
    test_class_info(&lv, &cd_ee14140);
    dp->~ee14140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14140(Test_ee14140, "ee14140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee14140C1Ev();
extern void _ZN7ee14140D1Ev();
Name_Map name_map_ee14140[] = {
  NSPAIR(_ZN7ee14140C1Ev),
  NSPAIR(_ZN7ee14140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee14140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14140[];
extern void _ZN6dd41403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee14140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14140[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee14140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
extern VTBL_ENTRY _ZTV7ee14140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee14140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee14140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee14140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee14140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee14140[] = {
  {&(_ZTV7ee14140[4]),  4,13},
  {&(_ZTV7ee14140[8]),  8,13},
  {&(_ZTV7ee14140[12]),  12,13},
  {&(_tg__ZTV6dd4140__7ee14140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee14140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee14140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee14140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee14140[];
extern  VTBL_ENTRY _ZTV7ee14140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14140[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee14140 = {  "ee14140", // class name
  bases_ee14140, 4,
  &(vtc_ee14140[0]), // expected_vtbl_contents
  &(vtt_ee14140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee14140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24140  : dd4140 {
  int e;
  virtual void  foo(); // _ZN7ee241403fooEv
  ~ee24140(); // tgen
  ee24140(); // tgen
};
//SIG(1 ee24140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee24140 ::foo(){vfunc_called(this, "_ZN7ee241403fooEv");}
ee24140 ::~ee24140(){ note_dtor("ee24140", this);} // tgen
ee24140 ::ee24140(){ note_ctor("ee24140", this);} // tgen

static void Test_ee24140()
{
  extern Class_Descriptor cd_ee24140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee24140, buf);
    ee24140 *dp, &lv = *(dp=new (buf) ee24140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee24140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee24140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(24,16), "ee24140");
    check_base_class_offset(lv, (cc140*)(dd4140*), 0, "ee24140");
    check_base_class_offset(lv, (dd4140*), 0, "ee24140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24140.e");
    test_class_info(&lv, &cd_ee24140);
    dp->~ee24140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24140(Test_ee24140, "ee24140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee24140C1Ev();
extern void _ZN7ee24140D1Ev();
Name_Map name_map_ee24140[] = {
  NSPAIR(_ZN7ee24140C1Ev),
  NSPAIR(_ZN7ee24140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee24140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24140[];
extern void _ZN6dd41403barEv();
extern void _ZN7ee241403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee24140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
  (VTBL_ENTRY)&_ZN7ee241403fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee24140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
extern VTBL_ENTRY _ZTV7ee24140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee24140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee24140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee24140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee24140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee24140[] = {
  {&(_ZTV7ee24140[3]),  3,9},
  {&(_tg__ZTV6dd4140__7ee24140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee24140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee24140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee24140[3]),  3,4},
  {&(_ZTV7ee24140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee24140[];
extern  VTBL_ENTRY _ZTV7ee24140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24140[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee24140 = {  "ee24140", // class name
  bases_ee24140, 4,
  &(vtc_ee24140[0]), // expected_vtbl_contents
  &(vtt_ee24140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee24140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34140  : virtual dd4140 {
  int e;
  virtual void  foo(); // _ZN7ee341403fooEv
  ~ee34140(); // tgen
  ee34140(); // tgen
};
//SIG(1 ee34140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee34140 ::foo(){vfunc_called(this, "_ZN7ee341403fooEv");}
ee34140 ::~ee34140(){ note_dtor("ee34140", this);} // tgen
ee34140 ::ee34140(){ note_ctor("ee34140", this);} // tgen

static void Test_ee34140()
{
  extern Class_Descriptor cd_ee34140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee34140, buf);
    ee34140 *dp, &lv = *(dp=new (buf) ee34140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee34140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee34140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(32,20), "ee34140");
    check_base_class_offset(lv, (cc140*)(dd4140*), ABISELECT(16,8), "ee34140");
    check_base_class_offset(lv, (dd4140*), ABISELECT(16,8), "ee34140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34140.e");
    test_class_info(&lv, &cd_ee34140);
    dp->~ee34140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34140(Test_ee34140, "ee34140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee34140C1Ev();
extern void _ZN7ee34140D1Ev();
Name_Map name_map_ee34140[] = {
  NSPAIR(_ZN7ee34140C1Ev),
  NSPAIR(_ZN7ee34140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee34140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34140[];
extern void _ZN7ee341403fooEv();
extern void _ZN6dd41403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34140[0]),
  (VTBL_ENTRY)&_ZN7ee341403fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee34140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
extern VTBL_ENTRY _ZTV7ee34140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee34140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee34140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee34140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee34140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee34140[] = {
  {&(_ZTV7ee34140[4]),  4,14},
  {&(_ZTV7ee34140[9]),  9,14},
  {&(_ZTV7ee34140[13]),  13,14},
  {&(_tg__ZTV6dd4140__7ee34140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee34140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee34140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee34140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee34140[];
extern  VTBL_ENTRY _ZTV7ee34140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34140[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34140 = {  "ee34140", // class name
  bases_ee34140, 4,
  &(vtc_ee34140[0]), // expected_vtbl_contents
  &(vtt_ee34140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee34140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34140),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44140  : dd4140 {
  int e;
  virtual void  bar(); // _ZN7ee441403barEv
  ~ee44140(); // tgen
  ee44140(); // tgen
};
//SIG(1 ee44140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee44140 ::bar(){vfunc_called(this, "_ZN7ee441403barEv");}
ee44140 ::~ee44140(){ note_dtor("ee44140", this);} // tgen
ee44140 ::ee44140(){ note_ctor("ee44140", this);} // tgen

static void Test_ee44140()
{
  extern Class_Descriptor cd_ee44140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee44140, buf);
    ee44140 *dp, &lv = *(dp=new (buf) ee44140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee44140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee44140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(24,16), "ee44140");
    check_base_class_offset(lv, (cc140*)(dd4140*), 0, "ee44140");
    check_base_class_offset(lv, (dd4140*), 0, "ee44140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44140.e");
    test_class_info(&lv, &cd_ee44140);
    dp->~ee44140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44140(Test_ee44140, "ee44140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee44140C1Ev();
extern void _ZN7ee44140D1Ev();
Name_Map name_map_ee44140[] = {
  NSPAIR(_ZN7ee44140C1Ev),
  NSPAIR(_ZN7ee44140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee44140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44140[];
extern void _ZN7ee441403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee441403barEv,_ZTv0_n12_N7ee441403barEv)();
extern void ABISELECT(_ZThn24_N7ee441403barEv,_ZThn16_N7ee441403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee44140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44140[0]),
  (VTBL_ENTRY)&_ZN7ee441403barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee44140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee441403barEv,_ZTv0_n12_N7ee441403barEv),
};
extern VTBL_ENTRY _ZTV7ee44140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee44140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee44140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee44140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee44140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee44140[] = {
  {&(_ZTV7ee44140[3]),  3,8},
  {&(_tg__ZTV6dd4140__7ee44140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee44140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee44140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee44140[3]),  3,4},
  {&(_ZTV7ee44140[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee44140[];
extern  VTBL_ENTRY _ZTV7ee44140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44140[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee441403barEv,_ZTv0_n12_N7ee441403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee441403barEv,_ZThn16_N7ee441403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee44140 = {  "ee44140", // class name
  bases_ee44140, 4,
  &(vtc_ee44140[0]), // expected_vtbl_contents
  &(vtt_ee44140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee44140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44140),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54140  : virtual dd4140 {
  int e;
  virtual void  bar(); // _ZN7ee541403barEv
  ~ee54140(); // tgen
  ee54140(); // tgen
};
//SIG(1 ee54140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee54140 ::bar(){vfunc_called(this, "_ZN7ee541403barEv");}
ee54140 ::~ee54140(){ note_dtor("ee54140", this);} // tgen
ee54140 ::ee54140(){ note_ctor("ee54140", this);} // tgen

static void Test_ee54140()
{
  extern Class_Descriptor cd_ee54140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee54140, buf);
    ee54140 *dp, &lv = *(dp=new (buf) ee54140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee54140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee54140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(32,20), "ee54140");
    check_base_class_offset(lv, (cc140*)(dd4140*), ABISELECT(16,8), "ee54140");
    check_base_class_offset(lv, (dd4140*), ABISELECT(16,8), "ee54140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54140.e");
    test_class_info(&lv, &cd_ee54140);
    dp->~ee54140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54140(Test_ee54140, "ee54140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee54140C1Ev();
extern void _ZN7ee54140D1Ev();
Name_Map name_map_ee54140[] = {
  NSPAIR(_ZN7ee54140C1Ev),
  NSPAIR(_ZN7ee54140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee54140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54140[];
extern void _ZN7ee541403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee541403barEv,_ZTv0_n16_N7ee541403barEv)();
extern void ABISELECT(_ZThn16_N7ee541403barEv,_ZThn8_N7ee541403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee541403barEv,_ZTv0_n12_N7ee541403barEv)();
extern void ABISELECT(_ZThn32_N7ee541403barEv,_ZThn20_N7ee541403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54140[0]),
  (VTBL_ENTRY)&_ZN7ee541403barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee541403barEv,_ZTv0_n16_N7ee541403barEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee54140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee541403barEv,_ZTv0_n12_N7ee541403barEv),
};
extern VTBL_ENTRY _ZTV7ee54140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee54140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee54140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee54140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee54140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee54140[] = {
  {&(_ZTV7ee54140[4]),  4,14},
  {&(_ZTV7ee54140[9]),  9,14},
  {&(_ZTV7ee54140[13]),  13,14},
  {&(_tg__ZTV6dd4140__7ee54140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee54140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee54140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee54140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee54140[];
extern  VTBL_ENTRY _ZTV7ee54140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54140[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee541403barEv,_ZTv0_n12_N7ee541403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee541403barEv,_ZThn20_N7ee541403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee541403barEv,_ZTv0_n16_N7ee541403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541403barEv,_ZThn8_N7ee541403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54140 = {  "ee54140", // class name
  bases_ee54140, 4,
  &(vtc_ee54140[0]), // expected_vtbl_contents
  &(vtt_ee54140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee54140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54140),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64140  : dd4140 {
  int e;
  virtual void  foo(); // _ZN7ee641403fooEv
  virtual void  bar(); // _ZN7ee641403barEv
  ~ee64140(); // tgen
  ee64140(); // tgen
};
//SIG(1 ee64140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64140 ::foo(){vfunc_called(this, "_ZN7ee641403fooEv");}
void  ee64140 ::bar(){vfunc_called(this, "_ZN7ee641403barEv");}
ee64140 ::~ee64140(){ note_dtor("ee64140", this);} // tgen
ee64140 ::ee64140(){ note_ctor("ee64140", this);} // tgen

static void Test_ee64140()
{
  extern Class_Descriptor cd_ee64140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee64140, buf);
    ee64140 *dp, &lv = *(dp=new (buf) ee64140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee64140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee64140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(24,16), "ee64140");
    check_base_class_offset(lv, (cc140*)(dd4140*), 0, "ee64140");
    check_base_class_offset(lv, (dd4140*), 0, "ee64140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64140.e");
    test_class_info(&lv, &cd_ee64140);
    dp->~ee64140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64140(Test_ee64140, "ee64140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee64140C1Ev();
extern void _ZN7ee64140D1Ev();
Name_Map name_map_ee64140[] = {
  NSPAIR(_ZN7ee64140C1Ev),
  NSPAIR(_ZN7ee64140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee64140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64140[];
extern void _ZN7ee641403barEv();
extern void _ZN7ee641403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee641403barEv,_ZTv0_n12_N7ee641403barEv)();
extern void ABISELECT(_ZThn24_N7ee641403barEv,_ZThn16_N7ee641403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee64140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64140[0]),
  (VTBL_ENTRY)&_ZN7ee641403barEv,
  (VTBL_ENTRY)&_ZN7ee641403fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee64140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee641403barEv,_ZTv0_n12_N7ee641403barEv),
};
extern VTBL_ENTRY _ZTV7ee64140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee64140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee64140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee64140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee64140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee64140[] = {
  {&(_ZTV7ee64140[3]),  3,9},
  {&(_tg__ZTV6dd4140__7ee64140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee64140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee64140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee64140[3]),  3,4},
  {&(_ZTV7ee64140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee64140[];
extern  VTBL_ENTRY _ZTV7ee64140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64140[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd41403barEv,_ZThn16_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee641403barEv,_ZTv0_n12_N7ee641403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641403barEv,_ZThn16_N7ee641403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee64140 = {  "ee64140", // class name
  bases_ee64140, 4,
  &(vtc_ee64140[0]), // expected_vtbl_contents
  &(vtt_ee64140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee64140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74140  : virtual dd4140 {
  int e;
  virtual void  foo(); // _ZN7ee741403fooEv
  virtual void  bar(); // _ZN7ee741403barEv
  ~ee74140(); // tgen
  ee74140(); // tgen
};
//SIG(1 ee74140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74140 ::foo(){vfunc_called(this, "_ZN7ee741403fooEv");}
void  ee74140 ::bar(){vfunc_called(this, "_ZN7ee741403barEv");}
ee74140 ::~ee74140(){ note_dtor("ee74140", this);} // tgen
ee74140 ::ee74140(){ note_ctor("ee74140", this);} // tgen

static void Test_ee74140()
{
  extern Class_Descriptor cd_ee74140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee74140, buf);
    ee74140 *dp, &lv = *(dp=new (buf) ee74140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee74140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee74140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd4140*), ABISELECT(32,20), "ee74140");
    check_base_class_offset(lv, (cc140*)(dd4140*), ABISELECT(16,8), "ee74140");
    check_base_class_offset(lv, (dd4140*), ABISELECT(16,8), "ee74140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74140.e");
    test_class_info(&lv, &cd_ee74140);
    dp->~ee74140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74140(Test_ee74140, "ee74140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee74140C1Ev();
extern void _ZN7ee74140D1Ev();
Name_Map name_map_ee74140[] = {
  NSPAIR(_ZN7ee74140C1Ev),
  NSPAIR(_ZN7ee74140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd4140;
extern VTBL_ENTRY _ZTI6dd4140[];
extern  VTBL_ENTRY _ZTV6dd4140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4140[];
static Base_Class bases_ee74140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74140[];
extern void _ZN7ee741403fooEv();
extern void _ZN7ee741403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee741403barEv,_ZTv0_n16_N7ee741403barEv)();
extern void ABISELECT(_ZThn16_N7ee741403barEv,_ZThn8_N7ee741403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee741403barEv,_ZTv0_n12_N7ee741403barEv)();
extern void ABISELECT(_ZThn32_N7ee741403barEv,_ZThn20_N7ee741403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74140[0]),
  (VTBL_ENTRY)&_ZN7ee741403fooEv,
  (VTBL_ENTRY)&_ZN7ee741403barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741403barEv,_ZTv0_n16_N7ee741403barEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee74140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee741403barEv,_ZTv0_n12_N7ee741403barEv),
};
extern VTBL_ENTRY _ZTV7ee74140[];
extern void _ZN6dd41403barEv();
static  VTBL_ENTRY _tg__ZTV6dd4140__7ee74140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&_ZN6dd41403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd4140__7ee74140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd4140__7ee74140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv)();
extern void ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd4140__7ee74140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv),
};
static  VTT_ENTRY vtt_ee74140[] = {
  {&(_ZTV7ee74140[4]),  4,15},
  {&(_ZTV7ee74140[10]),  10,15},
  {&(_ZTV7ee74140[14]),  14,15},
  {&(_tg__ZTV6dd4140__7ee74140[3]),  3,4},
  {&(_tg__ZTV5cc1406dd4140__7ee74140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd4140__7ee74140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd4140__7ee74140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee74140[];
extern  VTBL_ENTRY _ZTV7ee74140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74140[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd41403barEv,_ZTv0_n12_N6dd41403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd41403barEv,_ZThn12_N6dd41403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee741403barEv,_ZTv0_n12_N7ee741403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741403barEv,_ZThn20_N7ee741403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741403barEv,_ZTv0_n16_N7ee741403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741403barEv,_ZThn8_N7ee741403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74140 = {  "ee74140", // class name
  bases_ee74140, 4,
  &(vtc_ee74140[0]), // expected_vtbl_contents
  &(vtt_ee74140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee74140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74140),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5140  : virtual cc140 {
  int d;
  virtual void  bar(); // _ZN6dd51403barEv
  ~dd5140(); // tgen
  dd5140(); // tgen
};
//SIG(-1 dd5140) C1{ VBC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd5140 ::bar(){vfunc_called(this, "_ZN6dd51403barEv");}
dd5140 ::~dd5140(){ note_dtor("dd5140", this);} // tgen
dd5140 ::dd5140(){ note_ctor("dd5140", this);} // tgen

static void Test_dd5140()
{
  extern Class_Descriptor cd_dd5140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd5140, buf);
    dd5140 *dp, &lv = *(dp=new (buf) dd5140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd5140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,20), "dd5140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,16), "dd5140");
    check_base_class_offset(lv, (cc140*), ABISELECT(16,8), "dd5140");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5140.d");
    test_class_info(&lv, &cd_dd5140);
    dp->~dd5140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5140(Test_dd5140, "dd5140", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd5140C1Ev();
extern void _ZN6dd5140D1Ev();
Name_Map name_map_dd5140[] = {
  NSPAIR(_ZN6dd5140C1Ev),
  NSPAIR(_ZN6dd5140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd5140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5140[];
extern void _ZN6dd51403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd5140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
extern VTBL_ENTRY _ZTV6dd5140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd5140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd5140[] = {
  {&(_ZTV6dd5140[4]),  4,12},
  {&(_ZTV6dd5140[8]),  8,12},
  {&(_ZTV6dd5140[11]),  11,12},
  {&(_tg__ZTV5cc140__6dd5140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd5140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd5140 = {  "dd5140", // class name
  bases_dd5140, 3,
  &(vtc_dd5140[0]), // expected_vtbl_contents
  &(vtt_dd5140[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd5140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5140),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05140  : dd5140 {
  int e;
  ~ee05140(); // tgen
  ee05140(); // tgen
};
//SIG(1 ee05140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee05140 ::~ee05140(){ note_dtor("ee05140", this);} // tgen
ee05140 ::ee05140(){ note_ctor("ee05140", this);} // tgen

static void Test_ee05140()
{
  extern Class_Descriptor cd_ee05140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee05140, buf);
    ee05140 *dp, &lv = *(dp=new (buf) ee05140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee05140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee05140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee05140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(16,12), "ee05140");
    check_base_class_offset(lv, (dd5140*), 0, "ee05140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05140.e");
    test_class_info(&lv, &cd_ee05140);
    dp->~ee05140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05140(Test_ee05140, "ee05140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee05140C1Ev();
extern void _ZN7ee05140D1Ev();
Name_Map name_map_ee05140[] = {
  NSPAIR(_ZN7ee05140C1Ev),
  NSPAIR(_ZN7ee05140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee05140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05140[];
extern void _ZN6dd51403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee05140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee05140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
extern VTBL_ENTRY _ZTV7ee05140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee05140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee05140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee05140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee05140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee05140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee05140[] = {
  {&(_ZTV7ee05140[4]),  4,12},
  {&(_tg__ZTV6dd5140__7ee05140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee05140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee05140[3]),  3,4},
  {&(_ZTV7ee05140[8]),  8,12},
  {&(_ZTV7ee05140[11]),  11,12},
  {&(_tg__ZTV5cc140__7ee05140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee05140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee05140[];
extern  VTBL_ENTRY _ZTV7ee05140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05140[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee05140 = {  "ee05140", // class name
  bases_ee05140, 4,
  &(vtc_ee05140[0]), // expected_vtbl_contents
  &(vtt_ee05140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee05140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15140  : virtual dd5140 {
  int e;
  ~ee15140(); // tgen
  ee15140(); // tgen
};
//SIG(1 ee15140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee15140 ::~ee15140(){ note_dtor("ee15140", this);} // tgen
ee15140 ::ee15140(){ note_ctor("ee15140", this);} // tgen

static void Test_ee15140()
{
  extern Class_Descriptor cd_ee15140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee15140, buf);
    ee15140 *dp, &lv = *(dp=new (buf) ee15140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee15140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee15140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee15140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(32,16), "ee15140");
    check_base_class_offset(lv, (dd5140*), ABISELECT(16,8), "ee15140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15140.e");
    test_class_info(&lv, &cd_ee15140);
    dp->~ee15140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15140(Test_ee15140, "ee15140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee15140C1Ev();
extern void _ZN7ee15140D1Ev();
Name_Map name_map_ee15140[] = {
  NSPAIR(_ZN7ee15140C1Ev),
  NSPAIR(_ZN7ee15140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee15140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15140[];
extern void _ZN6dd51403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee15140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15140[0]),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15140[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee15140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
extern VTBL_ENTRY _ZTV7ee15140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee15140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee15140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee15140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee15140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee15140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee15140[] = {
  {&(_ZTV7ee15140[5]),  5,18},
  {&(_ZTV7ee15140[10]),  10,18},
  {&(_ZTV7ee15140[14]),  14,18},
  {&(_ZTV7ee15140[17]),  17,18},
  {&(_tg__ZTV6dd5140__7ee15140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee15140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee15140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee15140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee15140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15140[];
extern  VTBL_ENTRY _ZTV7ee15140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15140[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15140 = {  "ee15140", // class name
  bases_ee15140, 4,
  &(vtc_ee15140[0]), // expected_vtbl_contents
  &(vtt_ee15140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee15140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15140),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25140  : dd5140 {
  int e;
  virtual void  foo(); // _ZN7ee251403fooEv
  ~ee25140(); // tgen
  ee25140(); // tgen
};
//SIG(1 ee25140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee25140 ::foo(){vfunc_called(this, "_ZN7ee251403fooEv");}
ee25140 ::~ee25140(){ note_dtor("ee25140", this);} // tgen
ee25140 ::ee25140(){ note_ctor("ee25140", this);} // tgen

static void Test_ee25140()
{
  extern Class_Descriptor cd_ee25140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee25140, buf);
    ee25140 *dp, &lv = *(dp=new (buf) ee25140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee25140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee25140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee25140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(16,12), "ee25140");
    check_base_class_offset(lv, (dd5140*), 0, "ee25140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25140.e");
    test_class_info(&lv, &cd_ee25140);
    dp->~ee25140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25140(Test_ee25140, "ee25140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee25140C1Ev();
extern void _ZN7ee25140D1Ev();
Name_Map name_map_ee25140[] = {
  NSPAIR(_ZN7ee25140C1Ev),
  NSPAIR(_ZN7ee25140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee25140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25140[];
extern void _ZN6dd51403barEv();
extern void _ZN7ee251403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
  (VTBL_ENTRY)&_ZN7ee251403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee25140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
extern VTBL_ENTRY _ZTV7ee25140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee25140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee25140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee25140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee25140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee25140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee25140[] = {
  {&(_ZTV7ee25140[4]),  4,13},
  {&(_tg__ZTV6dd5140__7ee25140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee25140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee25140[3]),  3,4},
  {&(_ZTV7ee25140[9]),  9,13},
  {&(_ZTV7ee25140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee25140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee25140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee25140[];
extern  VTBL_ENTRY _ZTV7ee25140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25140[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25140 = {  "ee25140", // class name
  bases_ee25140, 4,
  &(vtc_ee25140[0]), // expected_vtbl_contents
  &(vtt_ee25140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee25140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35140  : virtual dd5140 {
  int e;
  virtual void  foo(); // _ZN7ee351403fooEv
  ~ee35140(); // tgen
  ee35140(); // tgen
};
//SIG(1 ee35140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee35140 ::foo(){vfunc_called(this, "_ZN7ee351403fooEv");}
ee35140 ::~ee35140(){ note_dtor("ee35140", this);} // tgen
ee35140 ::ee35140(){ note_ctor("ee35140", this);} // tgen

static void Test_ee35140()
{
  extern Class_Descriptor cd_ee35140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee35140, buf);
    ee35140 *dp, &lv = *(dp=new (buf) ee35140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee35140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee35140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee35140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(32,16), "ee35140");
    check_base_class_offset(lv, (dd5140*), ABISELECT(16,8), "ee35140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35140.e");
    test_class_info(&lv, &cd_ee35140);
    dp->~ee35140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35140(Test_ee35140, "ee35140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee35140C1Ev();
extern void _ZN7ee35140D1Ev();
Name_Map name_map_ee35140[] = {
  NSPAIR(_ZN7ee35140C1Ev),
  NSPAIR(_ZN7ee35140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee35140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35140[];
extern void _ZN7ee351403fooEv();
extern void _ZN6dd51403barEv();
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35140[0]),
  (VTBL_ENTRY)&_ZN7ee351403fooEv,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35140[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee35140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
extern VTBL_ENTRY _ZTV7ee35140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee35140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee35140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee35140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee35140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee35140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee35140[] = {
  {&(_ZTV7ee35140[5]),  5,19},
  {&(_ZTV7ee35140[11]),  11,19},
  {&(_ZTV7ee35140[15]),  15,19},
  {&(_ZTV7ee35140[18]),  18,19},
  {&(_tg__ZTV6dd5140__7ee35140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee35140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee35140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee35140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee35140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35140[];
extern  VTBL_ENTRY _ZTV7ee35140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35140[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35140 = {  "ee35140", // class name
  bases_ee35140, 4,
  &(vtc_ee35140[0]), // expected_vtbl_contents
  &(vtt_ee35140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee35140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35140),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45140  : dd5140 {
  int e;
  virtual void  bar(); // _ZN7ee451403barEv
  ~ee45140(); // tgen
  ee45140(); // tgen
};
//SIG(1 ee45140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee45140 ::bar(){vfunc_called(this, "_ZN7ee451403barEv");}
ee45140 ::~ee45140(){ note_dtor("ee45140", this);} // tgen
ee45140 ::ee45140(){ note_ctor("ee45140", this);} // tgen

static void Test_ee45140()
{
  extern Class_Descriptor cd_ee45140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee45140, buf);
    ee45140 *dp, &lv = *(dp=new (buf) ee45140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee45140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee45140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee45140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(16,12), "ee45140");
    check_base_class_offset(lv, (dd5140*), 0, "ee45140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45140.e");
    test_class_info(&lv, &cd_ee45140);
    dp->~ee45140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45140(Test_ee45140, "ee45140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee45140C1Ev();
extern void _ZN7ee45140D1Ev();
Name_Map name_map_ee45140[] = {
  NSPAIR(_ZN7ee45140C1Ev),
  NSPAIR(_ZN7ee45140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee45140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45140[];
extern void _ZN7ee451403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee451403barEv,_ZTv0_n12_N7ee451403barEv)();
extern void ABISELECT(_ZThn32_N7ee451403barEv,_ZThn20_N7ee451403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee45140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45140[0]),
  (VTBL_ENTRY)&_ZN7ee451403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee45140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee451403barEv,_ZTv0_n12_N7ee451403barEv),
};
extern VTBL_ENTRY _ZTV7ee45140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee45140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee45140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee45140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee45140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee45140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee45140[] = {
  {&(_ZTV7ee45140[4]),  4,12},
  {&(_tg__ZTV6dd5140__7ee45140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee45140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee45140[3]),  3,4},
  {&(_ZTV7ee45140[8]),  8,12},
  {&(_ZTV7ee45140[11]),  11,12},
  {&(_tg__ZTV5cc140__7ee45140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee45140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee45140[];
extern  VTBL_ENTRY _ZTV7ee45140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45140[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee451403barEv,_ZTv0_n12_N7ee451403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee451403barEv,_ZThn20_N7ee451403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee45140 = {  "ee45140", // class name
  bases_ee45140, 4,
  &(vtc_ee45140[0]), // expected_vtbl_contents
  &(vtt_ee45140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee45140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45140),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55140  : virtual dd5140 {
  int e;
  virtual void  bar(); // _ZN7ee551403barEv
  ~ee55140(); // tgen
  ee55140(); // tgen
};
//SIG(1 ee55140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee55140 ::bar(){vfunc_called(this, "_ZN7ee551403barEv");}
ee55140 ::~ee55140(){ note_dtor("ee55140", this);} // tgen
ee55140 ::ee55140(){ note_ctor("ee55140", this);} // tgen

static void Test_ee55140()
{
  extern Class_Descriptor cd_ee55140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee55140, buf);
    ee55140 *dp, &lv = *(dp=new (buf) ee55140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee55140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee55140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee55140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(32,16), "ee55140");
    check_base_class_offset(lv, (dd5140*), ABISELECT(16,8), "ee55140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55140.e");
    test_class_info(&lv, &cd_ee55140);
    dp->~ee55140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55140(Test_ee55140, "ee55140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee55140C1Ev();
extern void _ZN7ee55140D1Ev();
Name_Map name_map_ee55140[] = {
  NSPAIR(_ZN7ee55140C1Ev),
  NSPAIR(_ZN7ee55140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee55140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55140[];
extern void _ZN7ee551403barEv();
extern void ABISELECT(_ZTv0_n40_N7ee551403barEv,_ZTv0_n20_N7ee551403barEv)();
extern void ABISELECT(_ZThn16_N7ee551403barEv,_ZThn8_N7ee551403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee551403barEv,_ZTv0_n12_N7ee551403barEv)();
extern void ABISELECT(_ZThn48_N7ee551403barEv,_ZThn24_N7ee551403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55140[0]),
  (VTBL_ENTRY)&_ZN7ee551403barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee551403barEv,_ZTv0_n20_N7ee551403barEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee55140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee551403barEv,_ZTv0_n12_N7ee551403barEv),
};
extern VTBL_ENTRY _ZTV7ee55140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee55140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee55140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee55140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee55140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee55140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee55140[] = {
  {&(_ZTV7ee55140[5]),  5,19},
  {&(_ZTV7ee55140[11]),  11,19},
  {&(_ZTV7ee55140[15]),  15,19},
  {&(_ZTV7ee55140[18]),  18,19},
  {&(_tg__ZTV6dd5140__7ee55140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee55140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee55140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee55140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee55140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55140[];
extern  VTBL_ENTRY _ZTV7ee55140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55140[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee551403barEv,_ZTv0_n12_N7ee551403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee551403barEv,_ZThn24_N7ee551403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee551403barEv,_ZTv0_n20_N7ee551403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551403barEv,_ZThn8_N7ee551403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55140 = {  "ee55140", // class name
  bases_ee55140, 4,
  &(vtc_ee55140[0]), // expected_vtbl_contents
  &(vtt_ee55140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee55140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55140),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65140  : dd5140 {
  int e;
  virtual void  foo(); // _ZN7ee651403fooEv
  virtual void  bar(); // _ZN7ee651403barEv
  ~ee65140(); // tgen
  ee65140(); // tgen
};
//SIG(1 ee65140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65140 ::foo(){vfunc_called(this, "_ZN7ee651403fooEv");}
void  ee65140 ::bar(){vfunc_called(this, "_ZN7ee651403barEv");}
ee65140 ::~ee65140(){ note_dtor("ee65140", this);} // tgen
ee65140 ::ee65140(){ note_ctor("ee65140", this);} // tgen

static void Test_ee65140()
{
  extern Class_Descriptor cd_ee65140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee65140, buf);
    ee65140 *dp, &lv = *(dp=new (buf) ee65140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee65140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee65140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee65140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(16,12), "ee65140");
    check_base_class_offset(lv, (dd5140*), 0, "ee65140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65140.e");
    test_class_info(&lv, &cd_ee65140);
    dp->~ee65140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65140(Test_ee65140, "ee65140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee65140C1Ev();
extern void _ZN7ee65140D1Ev();
Name_Map name_map_ee65140[] = {
  NSPAIR(_ZN7ee65140C1Ev),
  NSPAIR(_ZN7ee65140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee65140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65140[];
extern void _ZN7ee651403barEv();
extern void _ZN7ee651403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee651403barEv,_ZTv0_n12_N7ee651403barEv)();
extern void ABISELECT(_ZThn32_N7ee651403barEv,_ZThn20_N7ee651403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65140[0]),
  (VTBL_ENTRY)&_ZN7ee651403barEv,
  (VTBL_ENTRY)&_ZN7ee651403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee65140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee651403barEv,_ZTv0_n12_N7ee651403barEv),
};
extern VTBL_ENTRY _ZTV7ee65140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee65140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee65140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee65140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee65140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee65140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee65140[] = {
  {&(_ZTV7ee65140[4]),  4,13},
  {&(_tg__ZTV6dd5140__7ee65140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee65140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee65140[3]),  3,4},
  {&(_ZTV7ee65140[9]),  9,13},
  {&(_ZTV7ee65140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee65140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee65140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee65140[];
extern  VTBL_ENTRY _ZTV7ee65140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65140[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn20_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee651403barEv,_ZTv0_n12_N7ee651403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651403barEv,_ZThn20_N7ee651403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65140 = {  "ee65140", // class name
  bases_ee65140, 4,
  &(vtc_ee65140[0]), // expected_vtbl_contents
  &(vtt_ee65140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee65140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75140  : virtual dd5140 {
  int e;
  virtual void  foo(); // _ZN7ee751403fooEv
  virtual void  bar(); // _ZN7ee751403barEv
  ~ee75140(); // tgen
  ee75140(); // tgen
};
//SIG(1 ee75140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75140 ::foo(){vfunc_called(this, "_ZN7ee751403fooEv");}
void  ee75140 ::bar(){vfunc_called(this, "_ZN7ee751403barEv");}
ee75140 ::~ee75140(){ note_dtor("ee75140", this);} // tgen
ee75140 ::ee75140(){ note_ctor("ee75140", this);} // tgen

static void Test_ee75140()
{
  extern Class_Descriptor cd_ee75140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee75140, buf);
    ee75140 *dp, &lv = *(dp=new (buf) ee75140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee75140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee75140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee75140");
    check_base_class_offset(lv, (cc140*)(dd5140*), ABISELECT(32,16), "ee75140");
    check_base_class_offset(lv, (dd5140*), ABISELECT(16,8), "ee75140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75140.e");
    test_class_info(&lv, &cd_ee75140);
    dp->~ee75140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75140(Test_ee75140, "ee75140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee75140C1Ev();
extern void _ZN7ee75140D1Ev();
Name_Map name_map_ee75140[] = {
  NSPAIR(_ZN7ee75140C1Ev),
  NSPAIR(_ZN7ee75140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd5140;
extern VTBL_ENTRY _ZTI6dd5140[];
extern  VTBL_ENTRY _ZTV6dd5140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5140[];
static Base_Class bases_ee75140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5140,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75140[];
extern void _ZN7ee751403fooEv();
extern void _ZN7ee751403barEv();
extern void ABISELECT(_ZTv0_n40_N7ee751403barEv,_ZTv0_n20_N7ee751403barEv)();
extern void ABISELECT(_ZThn16_N7ee751403barEv,_ZThn8_N7ee751403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee751403barEv,_ZTv0_n12_N7ee751403barEv)();
extern void ABISELECT(_ZThn48_N7ee751403barEv,_ZThn24_N7ee751403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75140[0]),
  (VTBL_ENTRY)&_ZN7ee751403fooEv,
  (VTBL_ENTRY)&_ZN7ee751403barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee751403barEv,_ZTv0_n20_N7ee751403barEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee75140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee751403barEv,_ZTv0_n12_N7ee751403barEv),
};
extern VTBL_ENTRY _ZTV7ee75140[];
extern void _ZN6dd51403barEv();
static  VTBL_ENTRY _tg__ZTV6dd5140__7ee75140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&_ZN6dd51403barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd5140__7ee75140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv)();
extern void ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd5140__7ee75140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee75140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee75140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee75140[] = {
  {&(_ZTV7ee75140[5]),  5,20},
  {&(_ZTV7ee75140[12]),  12,20},
  {&(_ZTV7ee75140[16]),  16,20},
  {&(_ZTV7ee75140[19]),  19,20},
  {&(_tg__ZTV6dd5140__7ee75140[4]),  4,5},
  {&(_tg__ZTV5cc140__6dd5140__7ee75140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd5140__7ee75140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee75140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee75140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75140[];
extern  VTBL_ENTRY _ZTV7ee75140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75140[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd51403barEv,_ZTv0_n12_N6dd51403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd51403barEv,_ZThn16_N6dd51403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee751403barEv,_ZTv0_n12_N7ee751403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751403barEv,_ZThn24_N7ee751403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee751403barEv,_ZTv0_n20_N7ee751403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751403barEv,_ZThn8_N7ee751403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75140 = {  "ee75140", // class name
  bases_ee75140, 4,
  &(vtc_ee75140[0]), // expected_vtbl_contents
  &(vtt_ee75140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee75140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75140),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6140  : cc140 {
  int d;
  virtual void  bar(); // _ZN6dd61403barEv
  virtual void  foo(); // _ZN6dd61403fooEv
  ~dd6140(); // tgen
  dd6140(); // tgen
};
//SIG(-1 dd6140) C1{ BC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd6140 ::bar(){vfunc_called(this, "_ZN6dd61403barEv");}
void  dd6140 ::foo(){vfunc_called(this, "_ZN6dd61403fooEv");}
dd6140 ::~dd6140(){ note_dtor("dd6140", this);} // tgen
dd6140 ::dd6140(){ note_ctor("dd6140", this);} // tgen

static void Test_dd6140()
{
  extern Class_Descriptor cd_dd6140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd6140, buf);
    dd6140 *dp, &lv = *(dp=new (buf) dd6140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd6140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(24,16), "dd6140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(16,12), "dd6140");
    check_base_class_offset(lv, (cc140*), 0, "dd6140");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6140.d");
    test_class_info(&lv, &cd_dd6140);
    dp->~dd6140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6140(Test_dd6140, "dd6140", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd6140C1Ev();
extern void _ZN6dd6140D1Ev();
Name_Map name_map_dd6140[] = {
  NSPAIR(_ZN6dd6140C1Ev),
  NSPAIR(_ZN6dd6140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd6140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd6140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
extern VTBL_ENTRY _ZTV6dd6140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd6140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd6140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd6140[] = {
  {&(_ZTV6dd6140[3]),  3,9},
  {&(_tg__ZTV5cc140__6dd6140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd6140[3]),  3,4},
  {&(_ZTV6dd6140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd6140 = {  "dd6140", // class name
  bases_dd6140, 3,
  &(vtc_dd6140[0]), // expected_vtbl_contents
  &(vtt_dd6140[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd6140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6140),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06140  : dd6140 {
  int e;
  ~ee06140(); // tgen
  ee06140(); // tgen
};
//SIG(1 ee06140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee06140 ::~ee06140(){ note_dtor("ee06140", this);} // tgen
ee06140 ::ee06140(){ note_ctor("ee06140", this);} // tgen

static void Test_ee06140()
{
  extern Class_Descriptor cd_ee06140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee06140, buf);
    ee06140 *dp, &lv = *(dp=new (buf) ee06140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee06140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee06140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(24,16), "ee06140");
    check_base_class_offset(lv, (cc140*)(dd6140*), 0, "ee06140");
    check_base_class_offset(lv, (dd6140*), 0, "ee06140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06140.e");
    test_class_info(&lv, &cd_ee06140);
    dp->~ee06140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06140(Test_ee06140, "ee06140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee06140C1Ev();
extern void _ZN7ee06140D1Ev();
Name_Map name_map_ee06140[] = {
  NSPAIR(_ZN7ee06140C1Ev),
  NSPAIR(_ZN7ee06140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee06140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee06140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee06140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
extern VTBL_ENTRY _ZTV7ee06140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee06140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee06140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee06140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee06140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee06140[] = {
  {&(_ZTV7ee06140[3]),  3,9},
  {&(_tg__ZTV6dd6140__7ee06140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee06140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee06140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee06140[3]),  3,4},
  {&(_ZTV7ee06140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee06140[];
extern  VTBL_ENTRY _ZTV7ee06140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06140[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee06140 = {  "ee06140", // class name
  bases_ee06140, 4,
  &(vtc_ee06140[0]), // expected_vtbl_contents
  &(vtt_ee06140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee06140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16140  : virtual dd6140 {
  int e;
  ~ee16140(); // tgen
  ee16140(); // tgen
};
//SIG(1 ee16140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee16140 ::~ee16140(){ note_dtor("ee16140", this);} // tgen
ee16140 ::ee16140(){ note_ctor("ee16140", this);} // tgen

static void Test_ee16140()
{
  extern Class_Descriptor cd_ee16140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee16140, buf);
    ee16140 *dp, &lv = *(dp=new (buf) ee16140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee16140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee16140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(32,20), "ee16140");
    check_base_class_offset(lv, (cc140*)(dd6140*), ABISELECT(16,8), "ee16140");
    check_base_class_offset(lv, (dd6140*), ABISELECT(16,8), "ee16140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16140.e");
    test_class_info(&lv, &cd_ee16140);
    dp->~ee16140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16140(Test_ee16140, "ee16140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee16140C1Ev();
extern void _ZN7ee16140D1Ev();
Name_Map name_map_ee16140[] = {
  NSPAIR(_ZN7ee16140C1Ev),
  NSPAIR(_ZN7ee16140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee16140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee16140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16140[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee16140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
extern VTBL_ENTRY _ZTV7ee16140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee16140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee16140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee16140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee16140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee16140[] = {
  {&(_ZTV7ee16140[4]),  4,15},
  {&(_ZTV7ee16140[9]),  9,15},
  {&(_ZTV7ee16140[14]),  14,15},
  {&(_tg__ZTV6dd6140__7ee16140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee16140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee16140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee16140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee16140[];
extern  VTBL_ENTRY _ZTV7ee16140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16140[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee16140 = {  "ee16140", // class name
  bases_ee16140, 4,
  &(vtc_ee16140[0]), // expected_vtbl_contents
  &(vtt_ee16140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee16140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16140),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26140  : dd6140 {
  int e;
  virtual void  foo(); // _ZN7ee261403fooEv
  ~ee26140(); // tgen
  ee26140(); // tgen
};
//SIG(1 ee26140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26140 ::foo(){vfunc_called(this, "_ZN7ee261403fooEv");}
ee26140 ::~ee26140(){ note_dtor("ee26140", this);} // tgen
ee26140 ::ee26140(){ note_ctor("ee26140", this);} // tgen

static void Test_ee26140()
{
  extern Class_Descriptor cd_ee26140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee26140, buf);
    ee26140 *dp, &lv = *(dp=new (buf) ee26140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee26140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee26140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(24,16), "ee26140");
    check_base_class_offset(lv, (cc140*)(dd6140*), 0, "ee26140");
    check_base_class_offset(lv, (dd6140*), 0, "ee26140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26140.e");
    test_class_info(&lv, &cd_ee26140);
    dp->~ee26140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26140(Test_ee26140, "ee26140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee26140C1Ev();
extern void _ZN7ee26140D1Ev();
Name_Map name_map_ee26140[] = {
  NSPAIR(_ZN7ee26140C1Ev),
  NSPAIR(_ZN7ee26140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee26140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26140[];
extern void _ZN6dd61403barEv();
extern void _ZN7ee261403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee26140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN7ee261403fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee26140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
extern VTBL_ENTRY _ZTV7ee26140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee26140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee26140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee26140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee26140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee26140[] = {
  {&(_ZTV7ee26140[3]),  3,9},
  {&(_tg__ZTV6dd6140__7ee26140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee26140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee26140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee26140[3]),  3,4},
  {&(_ZTV7ee26140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee26140[];
extern  VTBL_ENTRY _ZTV7ee26140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26140[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee26140 = {  "ee26140", // class name
  bases_ee26140, 4,
  &(vtc_ee26140[0]), // expected_vtbl_contents
  &(vtt_ee26140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee26140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36140  : virtual dd6140 {
  int e;
  virtual void  foo(); // _ZN7ee361403fooEv
  ~ee36140(); // tgen
  ee36140(); // tgen
};
//SIG(1 ee36140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36140 ::foo(){vfunc_called(this, "_ZN7ee361403fooEv");}
ee36140 ::~ee36140(){ note_dtor("ee36140", this);} // tgen
ee36140 ::ee36140(){ note_ctor("ee36140", this);} // tgen

static void Test_ee36140()
{
  extern Class_Descriptor cd_ee36140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee36140, buf);
    ee36140 *dp, &lv = *(dp=new (buf) ee36140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee36140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee36140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(32,20), "ee36140");
    check_base_class_offset(lv, (cc140*)(dd6140*), ABISELECT(16,8), "ee36140");
    check_base_class_offset(lv, (dd6140*), ABISELECT(16,8), "ee36140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36140.e");
    test_class_info(&lv, &cd_ee36140);
    dp->~ee36140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36140(Test_ee36140, "ee36140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee36140C1Ev();
extern void _ZN7ee36140D1Ev();
Name_Map name_map_ee36140[] = {
  NSPAIR(_ZN7ee36140C1Ev),
  NSPAIR(_ZN7ee36140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee36140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36140[];
extern void _ZN7ee361403fooEv();
extern void _ZN6dd61403barEv();
extern void ABISELECT(_ZTv0_n40_N7ee361403fooEv,_ZTv0_n20_N7ee361403fooEv)();
extern void ABISELECT(_ZThn16_N7ee361403fooEv,_ZThn8_N7ee361403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36140[0]),
  (VTBL_ENTRY)&_ZN7ee361403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee361403fooEv,_ZTv0_n20_N7ee361403fooEv),
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee36140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
extern VTBL_ENTRY _ZTV7ee36140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee36140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee36140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee36140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee36140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee36140[] = {
  {&(_ZTV7ee36140[4]),  4,16},
  {&(_ZTV7ee36140[10]),  10,16},
  {&(_ZTV7ee36140[15]),  15,16},
  {&(_tg__ZTV6dd6140__7ee36140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee36140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee36140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee36140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee36140[];
extern  VTBL_ENTRY _ZTV7ee36140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36140[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee361403fooEv,_ZTv0_n20_N7ee361403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361403fooEv,_ZThn8_N7ee361403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36140 = {  "ee36140", // class name
  bases_ee36140, 4,
  &(vtc_ee36140[0]), // expected_vtbl_contents
  &(vtt_ee36140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee36140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36140),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46140  : dd6140 {
  int e;
  virtual void  bar(); // _ZN7ee461403barEv
  ~ee46140(); // tgen
  ee46140(); // tgen
};
//SIG(1 ee46140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46140 ::bar(){vfunc_called(this, "_ZN7ee461403barEv");}
ee46140 ::~ee46140(){ note_dtor("ee46140", this);} // tgen
ee46140 ::ee46140(){ note_ctor("ee46140", this);} // tgen

static void Test_ee46140()
{
  extern Class_Descriptor cd_ee46140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee46140, buf);
    ee46140 *dp, &lv = *(dp=new (buf) ee46140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee46140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee46140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(24,16), "ee46140");
    check_base_class_offset(lv, (cc140*)(dd6140*), 0, "ee46140");
    check_base_class_offset(lv, (dd6140*), 0, "ee46140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46140.e");
    test_class_info(&lv, &cd_ee46140);
    dp->~ee46140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46140(Test_ee46140, "ee46140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee46140C1Ev();
extern void _ZN7ee46140D1Ev();
Name_Map name_map_ee46140[] = {
  NSPAIR(_ZN7ee46140C1Ev),
  NSPAIR(_ZN7ee46140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee46140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46140[];
extern void _ZN7ee461403barEv();
extern void _ZN6dd61403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee461403barEv,_ZTv0_n12_N7ee461403barEv)();
extern void ABISELECT(_ZThn24_N7ee461403barEv,_ZThn16_N7ee461403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee46140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46140[0]),
  (VTBL_ENTRY)&_ZN7ee461403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee46140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee461403barEv,_ZTv0_n12_N7ee461403barEv),
};
extern VTBL_ENTRY _ZTV7ee46140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee46140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee46140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee46140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee46140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee46140[] = {
  {&(_ZTV7ee46140[3]),  3,9},
  {&(_tg__ZTV6dd6140__7ee46140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee46140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee46140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee46140[3]),  3,4},
  {&(_ZTV7ee46140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee46140[];
extern  VTBL_ENTRY _ZTV7ee46140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46140[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee461403barEv,_ZTv0_n12_N7ee461403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee461403barEv,_ZThn16_N7ee461403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee46140 = {  "ee46140", // class name
  bases_ee46140, 4,
  &(vtc_ee46140[0]), // expected_vtbl_contents
  &(vtt_ee46140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee46140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56140  : virtual dd6140 {
  int e;
  virtual void  bar(); // _ZN7ee561403barEv
  ~ee56140(); // tgen
  ee56140(); // tgen
};
//SIG(1 ee56140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56140 ::bar(){vfunc_called(this, "_ZN7ee561403barEv");}
ee56140 ::~ee56140(){ note_dtor("ee56140", this);} // tgen
ee56140 ::ee56140(){ note_ctor("ee56140", this);} // tgen

static void Test_ee56140()
{
  extern Class_Descriptor cd_ee56140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee56140, buf);
    ee56140 *dp, &lv = *(dp=new (buf) ee56140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee56140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee56140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(32,20), "ee56140");
    check_base_class_offset(lv, (cc140*)(dd6140*), ABISELECT(16,8), "ee56140");
    check_base_class_offset(lv, (dd6140*), ABISELECT(16,8), "ee56140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56140.e");
    test_class_info(&lv, &cd_ee56140);
    dp->~ee56140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56140(Test_ee56140, "ee56140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee56140C1Ev();
extern void _ZN7ee56140D1Ev();
Name_Map name_map_ee56140[] = {
  NSPAIR(_ZN7ee56140C1Ev),
  NSPAIR(_ZN7ee56140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee56140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56140[];
extern void _ZN7ee561403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee561403barEv,_ZTv0_n16_N7ee561403barEv)();
extern void ABISELECT(_ZThn16_N7ee561403barEv,_ZThn8_N7ee561403barEv)() __attribute__((weak));
extern void _ZN6dd61403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee561403barEv,_ZTv0_n12_N7ee561403barEv)();
extern void ABISELECT(_ZThn32_N7ee561403barEv,_ZThn20_N7ee561403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56140[0]),
  (VTBL_ENTRY)&_ZN7ee561403barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee561403barEv,_ZTv0_n16_N7ee561403barEv),
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee56140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee561403barEv,_ZTv0_n12_N7ee561403barEv),
};
extern VTBL_ENTRY _ZTV7ee56140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee56140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee56140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee56140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee56140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee56140[] = {
  {&(_ZTV7ee56140[4]),  4,16},
  {&(_ZTV7ee56140[10]),  10,16},
  {&(_ZTV7ee56140[15]),  15,16},
  {&(_tg__ZTV6dd6140__7ee56140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee56140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee56140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee56140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee56140[];
extern  VTBL_ENTRY _ZTV7ee56140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56140[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee561403barEv,_ZTv0_n12_N7ee561403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee561403barEv,_ZThn20_N7ee561403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee561403barEv,_ZTv0_n16_N7ee561403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561403barEv,_ZThn8_N7ee561403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56140 = {  "ee56140", // class name
  bases_ee56140, 4,
  &(vtc_ee56140[0]), // expected_vtbl_contents
  &(vtt_ee56140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee56140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56140),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66140  : dd6140 {
  int e;
  virtual void  foo(); // _ZN7ee661403fooEv
  virtual void  bar(); // _ZN7ee661403barEv
  ~ee66140(); // tgen
  ee66140(); // tgen
};
//SIG(1 ee66140) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66140 ::foo(){vfunc_called(this, "_ZN7ee661403fooEv");}
void  ee66140 ::bar(){vfunc_called(this, "_ZN7ee661403barEv");}
ee66140 ::~ee66140(){ note_dtor("ee66140", this);} // tgen
ee66140 ::ee66140(){ note_ctor("ee66140", this);} // tgen

static void Test_ee66140()
{
  extern Class_Descriptor cd_ee66140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee66140, buf);
    ee66140 *dp, &lv = *(dp=new (buf) ee66140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee66140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(32,20), "ee66140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(24,16), "ee66140");
    check_base_class_offset(lv, (cc140*)(dd6140*), 0, "ee66140");
    check_base_class_offset(lv, (dd6140*), 0, "ee66140");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66140.e");
    test_class_info(&lv, &cd_ee66140);
    dp->~ee66140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66140(Test_ee66140, "ee66140", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee66140C1Ev();
extern void _ZN7ee66140D1Ev();
Name_Map name_map_ee66140[] = {
  NSPAIR(_ZN7ee66140C1Ev),
  NSPAIR(_ZN7ee66140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee66140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66140[];
extern void _ZN7ee661403barEv();
extern void _ZN7ee661403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee661403barEv,_ZTv0_n12_N7ee661403barEv)();
extern void ABISELECT(_ZThn24_N7ee661403barEv,_ZThn16_N7ee661403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee66140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66140[0]),
  (VTBL_ENTRY)&_ZN7ee661403barEv,
  (VTBL_ENTRY)&_ZN7ee661403fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee66140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee661403barEv,_ZTv0_n12_N7ee661403barEv),
};
extern VTBL_ENTRY _ZTV7ee66140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee66140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee66140[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee66140[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee66140[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee66140[] = {
  {&(_ZTV7ee66140[3]),  3,9},
  {&(_tg__ZTV6dd6140__7ee66140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee66140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee66140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee66140[3]),  3,4},
  {&(_ZTV7ee66140[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee66140[];
extern  VTBL_ENTRY _ZTV7ee66140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66140[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61403barEv,_ZThn16_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee661403barEv,_ZTv0_n12_N7ee661403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661403barEv,_ZThn16_N7ee661403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee66140 = {  "ee66140", // class name
  bases_ee66140, 4,
  &(vtc_ee66140[0]), // expected_vtbl_contents
  &(vtt_ee66140[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee66140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66140),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66140),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76140  : virtual dd6140 {
  int e;
  virtual void  foo(); // _ZN7ee761403fooEv
  virtual void  bar(); // _ZN7ee761403barEv
  ~ee76140(); // tgen
  ee76140(); // tgen
};
//SIG(1 ee76140) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76140 ::foo(){vfunc_called(this, "_ZN7ee761403fooEv");}
void  ee76140 ::bar(){vfunc_called(this, "_ZN7ee761403barEv");}
ee76140 ::~ee76140(){ note_dtor("ee76140", this);} // tgen
ee76140 ::ee76140(){ note_ctor("ee76140", this);} // tgen

static void Test_ee76140()
{
  extern Class_Descriptor cd_ee76140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee76140, buf);
    ee76140 *dp, &lv = *(dp=new (buf) ee76140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee76140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee76140");
    check_base_class_offset(lv, (bb40*)(cc140*)(dd6140*), ABISELECT(32,20), "ee76140");
    check_base_class_offset(lv, (cc140*)(dd6140*), ABISELECT(16,8), "ee76140");
    check_base_class_offset(lv, (dd6140*), ABISELECT(16,8), "ee76140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76140.e");
    test_class_info(&lv, &cd_ee76140);
    dp->~ee76140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76140(Test_ee76140, "ee76140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee76140C1Ev();
extern void _ZN7ee76140D1Ev();
Name_Map name_map_ee76140[] = {
  NSPAIR(_ZN7ee76140C1Ev),
  NSPAIR(_ZN7ee76140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd6140;
extern VTBL_ENTRY _ZTI6dd6140[];
extern  VTBL_ENTRY _ZTV6dd6140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6140[];
static Base_Class bases_ee76140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76140[];
extern void _ZN7ee761403fooEv();
extern void _ZN7ee761403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee761403barEv,_ZTv0_n16_N7ee761403barEv)();
extern void ABISELECT(_ZThn16_N7ee761403barEv,_ZThn8_N7ee761403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee761403fooEv,_ZTv0_n20_N7ee761403fooEv)();
extern void ABISELECT(_ZThn16_N7ee761403fooEv,_ZThn8_N7ee761403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee761403barEv,_ZTv0_n12_N7ee761403barEv)();
extern void ABISELECT(_ZThn32_N7ee761403barEv,_ZThn20_N7ee761403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76140[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76140[0]),
  (VTBL_ENTRY)&_ZN7ee761403fooEv,
  (VTBL_ENTRY)&_ZN7ee761403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761403barEv,_ZTv0_n16_N7ee761403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761403fooEv,_ZTv0_n20_N7ee761403fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee76140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee761403barEv,_ZTv0_n12_N7ee761403barEv),
};
extern VTBL_ENTRY _ZTV7ee76140[];
extern void _ZN6dd61403barEv();
extern void _ZN6dd61403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6140__7ee76140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&_ZN6dd61403barEv,
  (VTBL_ENTRY)&_ZN6dd61403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1406dd6140__7ee76140[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc1406dd6140__7ee76140[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv)();
extern void ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd6140__7ee76140[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv),
};
static  VTT_ENTRY vtt_ee76140[] = {
  {&(_ZTV7ee76140[4]),  4,17},
  {&(_ZTV7ee76140[11]),  11,17},
  {&(_ZTV7ee76140[16]),  16,17},
  {&(_tg__ZTV6dd6140__7ee76140[3]),  3,5},
  {&(_tg__ZTV5cc1406dd6140__7ee76140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc1406dd6140__7ee76140[3]),  3,4},
  {&(_tg__ZTV4bb40__6dd6140__7ee76140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee76140[];
extern  VTBL_ENTRY _ZTV7ee76140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76140[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61403barEv,_ZTv0_n12_N6dd61403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61403barEv,_ZThn12_N6dd61403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee761403barEv,_ZTv0_n12_N7ee761403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761403barEv,_ZThn20_N7ee761403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761403fooEv,_ZTv0_n20_N7ee761403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761403fooEv,_ZThn8_N7ee761403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761403barEv,_ZTv0_n16_N7ee761403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761403barEv,_ZThn8_N7ee761403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76140 = {  "ee76140", // class name
  bases_ee76140, 4,
  &(vtc_ee76140[0]), // expected_vtbl_contents
  &(vtt_ee76140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee76140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76140),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76140),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7140  : virtual cc140 {
  int d;
  virtual void  bar(); // _ZN6dd71403barEv
  virtual void  foo(); // _ZN6dd71403fooEv
  ~dd7140(); // tgen
  dd7140(); // tgen
};
//SIG(-1 dd7140) C1{ VBC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} v1 v2 Fi}


void  dd7140 ::bar(){vfunc_called(this, "_ZN6dd71403barEv");}
void  dd7140 ::foo(){vfunc_called(this, "_ZN6dd71403fooEv");}
dd7140 ::~dd7140(){ note_dtor("dd7140", this);} // tgen
dd7140 ::dd7140(){ note_ctor("dd7140", this);} // tgen

static void Test_dd7140()
{
  extern Class_Descriptor cd_dd7140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd7140, buf);
    dd7140 *dp, &lv = *(dp=new (buf) dd7140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd7140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,20), "dd7140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,16), "dd7140");
    check_base_class_offset(lv, (cc140*), ABISELECT(16,8), "dd7140");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7140.d");
    test_class_info(&lv, &cd_dd7140);
    dp->~dd7140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7140(Test_dd7140, "dd7140", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd7140C1Ev();
extern void _ZN6dd7140D1Ev();
Name_Map name_map_dd7140[] = {
  NSPAIR(_ZN6dd7140C1Ev),
  NSPAIR(_ZN6dd7140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
static Base_Class bases_dd7140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
extern VTBL_ENTRY _ZTV6dd7140[];
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__6dd7140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_dd7140[] = {
  {&(_ZTV6dd7140[4]),  4,13},
  {&(_ZTV6dd7140[9]),  9,13},
  {&(_ZTV6dd7140[12]),  12,13},
  {&(_tg__ZTV5cc140__6dd7140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__6dd7140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7140 = {  "dd7140", // class name
  bases_dd7140, 3,
  &(vtc_dd7140[0]), // expected_vtbl_contents
  &(vtt_dd7140[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd7140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7140),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07140  : dd7140 {
  int e;
  ~ee07140(); // tgen
  ee07140(); // tgen
};
//SIG(1 ee07140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee07140 ::~ee07140(){ note_dtor("ee07140", this);} // tgen
ee07140 ::ee07140(){ note_ctor("ee07140", this);} // tgen

static void Test_ee07140()
{
  extern Class_Descriptor cd_ee07140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee07140, buf);
    ee07140 *dp, &lv = *(dp=new (buf) ee07140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee07140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee07140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee07140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(16,12), "ee07140");
    check_base_class_offset(lv, (dd7140*), 0, "ee07140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07140.e");
    test_class_info(&lv, &cd_ee07140);
    dp->~ee07140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07140(Test_ee07140, "ee07140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee07140C1Ev();
extern void _ZN7ee07140D1Ev();
Name_Map name_map_ee07140[] = {
  NSPAIR(_ZN7ee07140C1Ev),
  NSPAIR(_ZN7ee07140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee07140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee07140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
extern VTBL_ENTRY _ZTV7ee07140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee07140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee07140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee07140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee07140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee07140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee07140[] = {
  {&(_ZTV7ee07140[4]),  4,13},
  {&(_tg__ZTV6dd7140__7ee07140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee07140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee07140[3]),  3,4},
  {&(_ZTV7ee07140[9]),  9,13},
  {&(_ZTV7ee07140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee07140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee07140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee07140[];
extern  VTBL_ENTRY _ZTV7ee07140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07140[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07140 = {  "ee07140", // class name
  bases_ee07140, 4,
  &(vtc_ee07140[0]), // expected_vtbl_contents
  &(vtt_ee07140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee07140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17140  : virtual dd7140 {
  int e;
  ~ee17140(); // tgen
  ee17140(); // tgen
};
//SIG(1 ee17140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} Fi}


ee17140 ::~ee17140(){ note_dtor("ee17140", this);} // tgen
ee17140 ::ee17140(){ note_ctor("ee17140", this);} // tgen

static void Test_ee17140()
{
  extern Class_Descriptor cd_ee17140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee17140, buf);
    ee17140 *dp, &lv = *(dp=new (buf) ee17140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee17140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee17140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee17140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(32,16), "ee17140");
    check_base_class_offset(lv, (dd7140*), ABISELECT(16,8), "ee17140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17140.e");
    test_class_info(&lv, &cd_ee17140);
    dp->~ee17140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17140(Test_ee17140, "ee17140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee17140C1Ev();
extern void _ZN7ee17140D1Ev();
Name_Map name_map_ee17140[] = {
  NSPAIR(_ZN7ee17140C1Ev),
  NSPAIR(_ZN7ee17140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee17140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17140[0]),
  0,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17140[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee17140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
extern VTBL_ENTRY _ZTV7ee17140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee17140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee17140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee17140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee17140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee17140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee17140[] = {
  {&(_ZTV7ee17140[5]),  5,20},
  {&(_ZTV7ee17140[11]),  11,20},
  {&(_ZTV7ee17140[16]),  16,20},
  {&(_ZTV7ee17140[19]),  19,20},
  {&(_tg__ZTV6dd7140__7ee17140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee17140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee17140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee17140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee17140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17140[];
extern  VTBL_ENTRY _ZTV7ee17140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17140[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17140 = {  "ee17140", // class name
  bases_ee17140, 4,
  &(vtc_ee17140[0]), // expected_vtbl_contents
  &(vtt_ee17140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee17140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17140),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27140  : dd7140 {
  int e;
  virtual void  foo(); // _ZN7ee271403fooEv
  ~ee27140(); // tgen
  ee27140(); // tgen
};
//SIG(1 ee27140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27140 ::foo(){vfunc_called(this, "_ZN7ee271403fooEv");}
ee27140 ::~ee27140(){ note_dtor("ee27140", this);} // tgen
ee27140 ::ee27140(){ note_ctor("ee27140", this);} // tgen

static void Test_ee27140()
{
  extern Class_Descriptor cd_ee27140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee27140, buf);
    ee27140 *dp, &lv = *(dp=new (buf) ee27140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee27140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee27140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee27140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(16,12), "ee27140");
    check_base_class_offset(lv, (dd7140*), 0, "ee27140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27140.e");
    test_class_info(&lv, &cd_ee27140);
    dp->~ee27140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27140(Test_ee27140, "ee27140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee27140C1Ev();
extern void _ZN7ee27140D1Ev();
Name_Map name_map_ee27140[] = {
  NSPAIR(_ZN7ee27140C1Ev),
  NSPAIR(_ZN7ee27140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee27140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27140[];
extern void _ZN6dd71403barEv();
extern void _ZN7ee271403fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN7ee271403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee27140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
extern VTBL_ENTRY _ZTV7ee27140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee27140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee27140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee27140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee27140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee27140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee27140[] = {
  {&(_ZTV7ee27140[4]),  4,13},
  {&(_tg__ZTV6dd7140__7ee27140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee27140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee27140[3]),  3,4},
  {&(_ZTV7ee27140[9]),  9,13},
  {&(_ZTV7ee27140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee27140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee27140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee27140[];
extern  VTBL_ENTRY _ZTV7ee27140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27140[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27140 = {  "ee27140", // class name
  bases_ee27140, 4,
  &(vtc_ee27140[0]), // expected_vtbl_contents
  &(vtt_ee27140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee27140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37140  : virtual dd7140 {
  int e;
  virtual void  foo(); // _ZN7ee371403fooEv
  ~ee37140(); // tgen
  ee37140(); // tgen
};
//SIG(1 ee37140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37140 ::foo(){vfunc_called(this, "_ZN7ee371403fooEv");}
ee37140 ::~ee37140(){ note_dtor("ee37140", this);} // tgen
ee37140 ::ee37140(){ note_ctor("ee37140", this);} // tgen

static void Test_ee37140()
{
  extern Class_Descriptor cd_ee37140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee37140, buf);
    ee37140 *dp, &lv = *(dp=new (buf) ee37140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee37140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee37140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee37140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(32,16), "ee37140");
    check_base_class_offset(lv, (dd7140*), ABISELECT(16,8), "ee37140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37140.e");
    test_class_info(&lv, &cd_ee37140);
    dp->~ee37140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37140(Test_ee37140, "ee37140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee37140C1Ev();
extern void _ZN7ee37140D1Ev();
Name_Map name_map_ee37140[] = {
  NSPAIR(_ZN7ee37140C1Ev),
  NSPAIR(_ZN7ee37140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee37140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37140[];
extern void _ZN7ee371403fooEv();
extern void _ZN6dd71403barEv();
extern void ABISELECT(_ZTv0_n48_N7ee371403fooEv,_ZTv0_n24_N7ee371403fooEv)();
extern void ABISELECT(_ZThn16_N7ee371403fooEv,_ZThn8_N7ee371403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37140[0]),
  (VTBL_ENTRY)&_ZN7ee371403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee371403fooEv,_ZTv0_n24_N7ee371403fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37140[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee37140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
extern VTBL_ENTRY _ZTV7ee37140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee37140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee37140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee37140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee37140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee37140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee37140[] = {
  {&(_ZTV7ee37140[5]),  5,21},
  {&(_ZTV7ee37140[12]),  12,21},
  {&(_ZTV7ee37140[17]),  17,21},
  {&(_ZTV7ee37140[20]),  20,21},
  {&(_tg__ZTV6dd7140__7ee37140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee37140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee37140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee37140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee37140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37140[];
extern  VTBL_ENTRY _ZTV7ee37140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37140[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee371403fooEv,_ZTv0_n24_N7ee371403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371403fooEv,_ZThn8_N7ee371403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37140 = {  "ee37140", // class name
  bases_ee37140, 4,
  &(vtc_ee37140[0]), // expected_vtbl_contents
  &(vtt_ee37140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee37140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37140),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47140  : dd7140 {
  int e;
  virtual void  bar(); // _ZN7ee471403barEv
  ~ee47140(); // tgen
  ee47140(); // tgen
};
//SIG(1 ee47140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47140 ::bar(){vfunc_called(this, "_ZN7ee471403barEv");}
ee47140 ::~ee47140(){ note_dtor("ee47140", this);} // tgen
ee47140 ::ee47140(){ note_ctor("ee47140", this);} // tgen

static void Test_ee47140()
{
  extern Class_Descriptor cd_ee47140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee47140, buf);
    ee47140 *dp, &lv = *(dp=new (buf) ee47140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee47140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee47140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee47140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(16,12), "ee47140");
    check_base_class_offset(lv, (dd7140*), 0, "ee47140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47140.e");
    test_class_info(&lv, &cd_ee47140);
    dp->~ee47140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47140(Test_ee47140, "ee47140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee47140C1Ev();
extern void _ZN7ee47140D1Ev();
Name_Map name_map_ee47140[] = {
  NSPAIR(_ZN7ee47140C1Ev),
  NSPAIR(_ZN7ee47140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee47140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47140[];
extern void _ZN7ee471403barEv();
extern void _ZN6dd71403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee471403barEv,_ZTv0_n12_N7ee471403barEv)();
extern void ABISELECT(_ZThn32_N7ee471403barEv,_ZThn20_N7ee471403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47140[0]),
  (VTBL_ENTRY)&_ZN7ee471403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee47140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee471403barEv,_ZTv0_n12_N7ee471403barEv),
};
extern VTBL_ENTRY _ZTV7ee47140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee47140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee47140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee47140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee47140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee47140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee47140[] = {
  {&(_ZTV7ee47140[4]),  4,13},
  {&(_tg__ZTV6dd7140__7ee47140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee47140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee47140[3]),  3,4},
  {&(_ZTV7ee47140[9]),  9,13},
  {&(_ZTV7ee47140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee47140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee47140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee47140[];
extern  VTBL_ENTRY _ZTV7ee47140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47140[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee471403barEv,_ZTv0_n12_N7ee471403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee471403barEv,_ZThn20_N7ee471403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47140 = {  "ee47140", // class name
  bases_ee47140, 4,
  &(vtc_ee47140[0]), // expected_vtbl_contents
  &(vtt_ee47140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee47140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57140  : virtual dd7140 {
  int e;
  virtual void  bar(); // _ZN7ee571403barEv
  ~ee57140(); // tgen
  ee57140(); // tgen
};
//SIG(1 ee57140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57140 ::bar(){vfunc_called(this, "_ZN7ee571403barEv");}
ee57140 ::~ee57140(){ note_dtor("ee57140", this);} // tgen
ee57140 ::ee57140(){ note_ctor("ee57140", this);} // tgen

static void Test_ee57140()
{
  extern Class_Descriptor cd_ee57140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee57140, buf);
    ee57140 *dp, &lv = *(dp=new (buf) ee57140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee57140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee57140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee57140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(32,16), "ee57140");
    check_base_class_offset(lv, (dd7140*), ABISELECT(16,8), "ee57140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57140.e");
    test_class_info(&lv, &cd_ee57140);
    dp->~ee57140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57140(Test_ee57140, "ee57140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee57140C1Ev();
extern void _ZN7ee57140D1Ev();
Name_Map name_map_ee57140[] = {
  NSPAIR(_ZN7ee57140C1Ev),
  NSPAIR(_ZN7ee57140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee57140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57140[];
extern void _ZN7ee571403barEv();
extern void ABISELECT(_ZTv0_n40_N7ee571403barEv,_ZTv0_n20_N7ee571403barEv)();
extern void ABISELECT(_ZThn16_N7ee571403barEv,_ZThn8_N7ee571403barEv)() __attribute__((weak));
extern void _ZN6dd71403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee571403barEv,_ZTv0_n12_N7ee571403barEv)();
extern void ABISELECT(_ZThn48_N7ee571403barEv,_ZThn24_N7ee571403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57140[0]),
  (VTBL_ENTRY)&_ZN7ee571403barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee571403barEv,_ZTv0_n20_N7ee571403barEv),
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee57140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee571403barEv,_ZTv0_n12_N7ee571403barEv),
};
extern VTBL_ENTRY _ZTV7ee57140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee57140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee57140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee57140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee57140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee57140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee57140[] = {
  {&(_ZTV7ee57140[5]),  5,21},
  {&(_ZTV7ee57140[12]),  12,21},
  {&(_ZTV7ee57140[17]),  17,21},
  {&(_ZTV7ee57140[20]),  20,21},
  {&(_tg__ZTV6dd7140__7ee57140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee57140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee57140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee57140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee57140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57140[];
extern  VTBL_ENTRY _ZTV7ee57140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57140[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee571403barEv,_ZTv0_n12_N7ee571403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee571403barEv,_ZThn24_N7ee571403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee571403barEv,_ZTv0_n20_N7ee571403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571403barEv,_ZThn8_N7ee571403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57140 = {  "ee57140", // class name
  bases_ee57140, 4,
  &(vtc_ee57140[0]), // expected_vtbl_contents
  &(vtt_ee57140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee57140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57140),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67140  : dd7140 {
  int e;
  virtual void  foo(); // _ZN7ee671403fooEv
  virtual void  bar(); // _ZN7ee671403barEv
  ~ee67140(); // tgen
  ee67140(); // tgen
};
//SIG(1 ee67140) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67140 ::foo(){vfunc_called(this, "_ZN7ee671403fooEv");}
void  ee67140 ::bar(){vfunc_called(this, "_ZN7ee671403barEv");}
ee67140 ::~ee67140(){ note_dtor("ee67140", this);} // tgen
ee67140 ::ee67140(){ note_ctor("ee67140", this);} // tgen

static void Test_ee67140()
{
  extern Class_Descriptor cd_ee67140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee67140, buf);
    ee67140 *dp, &lv = *(dp=new (buf) ee67140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee67140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(40,24), "ee67140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(32,20), "ee67140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(16,12), "ee67140");
    check_base_class_offset(lv, (dd7140*), 0, "ee67140");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67140.e");
    test_class_info(&lv, &cd_ee67140);
    dp->~ee67140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67140(Test_ee67140, "ee67140", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee67140C1Ev();
extern void _ZN7ee67140D1Ev();
Name_Map name_map_ee67140[] = {
  NSPAIR(_ZN7ee67140C1Ev),
  NSPAIR(_ZN7ee67140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee67140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67140[];
extern void _ZN7ee671403barEv();
extern void _ZN7ee671403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee671403barEv,_ZTv0_n12_N7ee671403barEv)();
extern void ABISELECT(_ZThn32_N7ee671403barEv,_ZThn20_N7ee671403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67140[0]),
  (VTBL_ENTRY)&_ZN7ee671403barEv,
  (VTBL_ENTRY)&_ZN7ee671403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67140[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee67140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee671403barEv,_ZTv0_n12_N7ee671403barEv),
};
extern VTBL_ENTRY _ZTV7ee67140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee67140[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee67140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee67140[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee67140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee67140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee67140[] = {
  {&(_ZTV7ee67140[4]),  4,13},
  {&(_tg__ZTV6dd7140__7ee67140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee67140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee67140[3]),  3,4},
  {&(_ZTV7ee67140[9]),  9,13},
  {&(_ZTV7ee67140[12]),  12,13},
  {&(_tg__ZTV5cc140__7ee67140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee67140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee67140[];
extern  VTBL_ENTRY _ZTV7ee67140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67140[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn20_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee671403barEv,_ZTv0_n12_N7ee671403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671403barEv,_ZThn20_N7ee671403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67140 = {  "ee67140", // class name
  bases_ee67140, 4,
  &(vtc_ee67140[0]), // expected_vtbl_contents
  &(vtt_ee67140[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee67140),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67140),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67140),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77140  : virtual dd7140 {
  int e;
  virtual void  foo(); // _ZN7ee771403fooEv
  virtual void  bar(); // _ZN7ee771403barEv
  ~ee77140(); // tgen
  ee77140(); // tgen
};
//SIG(1 ee77140) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77140 ::foo(){vfunc_called(this, "_ZN7ee771403fooEv");}
void  ee77140 ::bar(){vfunc_called(this, "_ZN7ee771403barEv");}
ee77140 ::~ee77140(){ note_dtor("ee77140", this);} // tgen
ee77140 ::ee77140(){ note_ctor("ee77140", this);} // tgen

static void Test_ee77140()
{
  extern Class_Descriptor cd_ee77140;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee77140, buf);
    ee77140 *dp, &lv = *(dp=new (buf) ee77140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee77140)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77140)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(56,28), "ee77140");
    check_base_class_offset(lv, (bb40*)(cc140*), ABISELECT(48,24), "ee77140");
    check_base_class_offset(lv, (cc140*)(dd7140*), ABISELECT(32,16), "ee77140");
    check_base_class_offset(lv, (dd7140*), ABISELECT(16,8), "ee77140");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77140.e");
    test_class_info(&lv, &cd_ee77140);
    dp->~ee77140();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77140(Test_ee77140, "ee77140", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee77140C1Ev();
extern void _ZN7ee77140D1Ev();
Name_Map name_map_ee77140[] = {
  NSPAIR(_ZN7ee77140C1Ev),
  NSPAIR(_ZN7ee77140D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc140;
extern VTBL_ENTRY _ZTI5cc140[];
extern  VTBL_ENTRY _ZTV5cc140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc140[];
extern Class_Descriptor cd_dd7140;
extern VTBL_ENTRY _ZTI6dd7140[];
extern  VTBL_ENTRY _ZTV6dd7140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7140[];
static Base_Class bases_ee77140[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc140,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7140,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77140[];
extern void _ZN7ee771403fooEv();
extern void _ZN7ee771403barEv();
extern void ABISELECT(_ZTv0_n40_N7ee771403barEv,_ZTv0_n20_N7ee771403barEv)();
extern void ABISELECT(_ZThn16_N7ee771403barEv,_ZThn8_N7ee771403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee771403fooEv,_ZTv0_n24_N7ee771403fooEv)();
extern void ABISELECT(_ZThn16_N7ee771403fooEv,_ZThn8_N7ee771403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee771403barEv,_ZTv0_n12_N7ee771403barEv)();
extern void ABISELECT(_ZThn48_N7ee771403barEv,_ZThn24_N7ee771403barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77140[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77140[0]),
  (VTBL_ENTRY)&_ZN7ee771403fooEv,
  (VTBL_ENTRY)&_ZN7ee771403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee771403barEv,_ZTv0_n20_N7ee771403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771403fooEv,_ZTv0_n24_N7ee771403fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77140[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee77140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee771403barEv,_ZTv0_n12_N7ee771403barEv),
};
extern VTBL_ENTRY _ZTV7ee77140[];
extern void _ZN6dd71403barEv();
extern void _ZN6dd71403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7140__7ee77140[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&_ZN6dd71403barEv,
  (VTBL_ENTRY)&_ZN6dd71403fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc140__6dd7140__7ee77140[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv)();
extern void ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb40__6dd7140__7ee77140[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7140[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv),
};
static  VTBL_ENTRY _tg__ZTV5cc140__7ee77140[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
};
extern void _ZN4bb403barEv();
static  VTBL_ENTRY _tg__ZTV4bb40__5cc140__7ee77140[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc140[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
};
static  VTT_ENTRY vtt_ee77140[] = {
  {&(_ZTV7ee77140[5]),  5,22},
  {&(_ZTV7ee77140[13]),  13,22},
  {&(_ZTV7ee77140[18]),  18,22},
  {&(_ZTV7ee77140[21]),  21,22},
  {&(_tg__ZTV6dd7140__7ee77140[4]),  4,6},
  {&(_tg__ZTV5cc140__6dd7140__7ee77140[3]),  3,3},
  {&(_tg__ZTV4bb40__6dd7140__7ee77140[3]),  3,4},
  {&(_tg__ZTV5cc140__7ee77140[3]),  3,3},
  {&(_tg__ZTV4bb40__5cc140__7ee77140[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77140[];
extern  VTBL_ENTRY _ZTV7ee77140[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77140[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71403barEv,_ZTv0_n12_N6dd71403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71403barEv,_ZThn16_N6dd71403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee771403barEv,_ZTv0_n12_N7ee771403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771403barEv,_ZThn24_N7ee771403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771403fooEv,_ZTv0_n24_N7ee771403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771403fooEv,_ZThn8_N7ee771403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee771403barEv,_ZTv0_n20_N7ee771403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771403barEv,_ZThn8_N7ee771403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77140 = {  "ee77140", // class name
  bases_ee77140, 4,
  &(vtc_ee77140[0]), // expected_vtbl_contents
  &(vtt_ee77140[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee77140),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77140),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77140),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc240  : bb40 {
  int c;
  virtual void  foo(); // _ZN5cc2403fooEv
  ~cc240(); // tgen
  cc240(); // tgen
};
//SIG(-1 cc240) C1{ BC2{ BC3{ Fi} v2 Fi} v1 Fi}


void  cc240 ::foo(){vfunc_called(this, "_ZN5cc2403fooEv");}
cc240 ::~cc240(){ note_dtor("cc240", this);} // tgen
cc240 ::cc240(){ note_ctor("cc240", this);} // tgen

static void Test_cc240()
{
  extern Class_Descriptor cd_cc240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc240, buf);
    cc240 *dp, &lv = *(dp=new (buf) cc240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc240)");
    check_base_class_offset(lv, (aa0*)(bb40*), ABISELECT(8,4), "cc240");
    check_base_class_offset(lv, (bb40*), 0, "cc240");
    check_field_offset(lv, c, ABISELECT(16,12), "cc240.c");
    test_class_info(&lv, &cd_cc240);
    dp->~cc240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc240(Test_cc240, "cc240", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc240C1Ev();
extern void _ZN5cc240D1Ev();
Name_Map name_map_cc240[] = {
  NSPAIR(_ZN5cc240C1Ev),
  NSPAIR(_ZN5cc240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
static Base_Class bases_cc240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc240[];
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_cc240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5cc240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
Class_Descriptor cd_cc240 = {  "cc240", // class name
  bases_cc240, 2,
  &(vtc_cc240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0240  : cc240 {
  int d;
  ~dd0240(); // tgen
  dd0240(); // tgen
};
//SIG(-1 dd0240) C1{ BC2{ BC3{ BC4{ Fi} v2 Fi} v1 Fi} Fi}


dd0240 ::~dd0240(){ note_dtor("dd0240", this);} // tgen
dd0240 ::dd0240(){ note_ctor("dd0240", this);} // tgen

static void Test_dd0240()
{
  extern Class_Descriptor cd_dd0240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0240, buf);
    dd0240 *dp, &lv = *(dp=new (buf) dd0240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(8,4), "dd0240");
    check_base_class_offset(lv, (bb40*)(cc240*), 0, "dd0240");
    check_base_class_offset(lv, (cc240*), 0, "dd0240");
    check_field_offset(lv, d, ABISELECT(20,16), "dd0240.d");
    test_class_info(&lv, &cd_dd0240);
    dp->~dd0240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0240(Test_dd0240, "dd0240", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0240C1Ev();
extern void _ZN6dd0240D1Ev();
Name_Map name_map_dd0240[] = {
  NSPAIR(_ZN6dd0240C1Ev),
  NSPAIR(_ZN6dd0240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
static Base_Class bases_dd0240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0240[];
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_dd0240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd0240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
Class_Descriptor cd_dd0240 = {  "dd0240", // class name
  bases_dd0240, 3,
  &(vtc_dd0240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00240  : dd0240 {
  int e;
  ~ee00240(); // tgen
  ee00240(); // tgen
};
//SIG(1 ee00240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee00240 ::~ee00240(){ note_dtor("ee00240", this);} // tgen
ee00240 ::ee00240(){ note_ctor("ee00240", this);} // tgen

static void Test_ee00240()
{
  extern Class_Descriptor cd_ee00240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00240, buf);
    ee00240 *dp, &lv = *(dp=new (buf) ee00240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(8,4), "ee00240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), 0, "ee00240");
    check_base_class_offset(lv, (cc240*)(dd0240*), 0, "ee00240");
    check_base_class_offset(lv, (dd0240*), 0, "ee00240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee00240.e");
    test_class_info(&lv, &cd_ee00240);
    dp->~ee00240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00240(Test_ee00240, "ee00240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00240C1Ev();
extern void _ZN7ee00240D1Ev();
Name_Map name_map_ee00240[] = {
  NSPAIR(_ZN7ee00240C1Ev),
  NSPAIR(_ZN7ee00240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee00240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00240[];
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee00240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee00240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTI7ee00240[];
extern  VTBL_ENTRY _ZTV7ee00240[];
Class_Descriptor cd_ee00240 = {  "ee00240", // class name
  bases_ee00240, 4,
  &(vtc_ee00240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10240  : virtual dd0240 {
  int e;
  ~ee10240(); // tgen
  ee10240(); // tgen
};
//SIG(1 ee10240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee10240 ::~ee10240(){ note_dtor("ee10240", this);} // tgen
ee10240 ::ee10240(){ note_ctor("ee10240", this);} // tgen

static void Test_ee10240()
{
  extern Class_Descriptor cd_ee10240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10240, buf);
    ee10240 *dp, &lv = *(dp=new (buf) ee10240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(24,12), "ee10240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), ABISELECT(16,8), "ee10240");
    check_base_class_offset(lv, (cc240*)(dd0240*), ABISELECT(16,8), "ee10240");
    check_base_class_offset(lv, (dd0240*), ABISELECT(16,8), "ee10240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10240.e");
    test_class_info(&lv, &cd_ee10240);
    dp->~ee10240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10240(Test_ee10240, "ee10240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10240C1Ev();
extern void _ZN7ee10240D1Ev();
Name_Map name_map_ee10240[] = {
  NSPAIR(_ZN7ee10240C1Ev),
  NSPAIR(_ZN7ee10240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee10240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10240[];
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee10240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10240[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV7ee10240[];
static  VTT_ENTRY vtt_ee10240[] = {
  {&(_ZTV7ee10240[3]),  3,9},
  {&(_ZTV7ee10240[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee10240[];
extern  VTBL_ENTRY _ZTV7ee10240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10240[];
Class_Descriptor cd_ee10240 = {  "ee10240", // class name
  bases_ee10240, 4,
  &(vtc_ee10240[0]), // expected_vtbl_contents
  &(vtt_ee10240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10240),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20240  : dd0240 {
  int e;
  virtual void  foo(); // _ZN7ee202403fooEv
  ~ee20240(); // tgen
  ee20240(); // tgen
};
//SIG(1 ee20240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee20240 ::foo(){vfunc_called(this, "_ZN7ee202403fooEv");}
ee20240 ::~ee20240(){ note_dtor("ee20240", this);} // tgen
ee20240 ::ee20240(){ note_ctor("ee20240", this);} // tgen

static void Test_ee20240()
{
  extern Class_Descriptor cd_ee20240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20240, buf);
    ee20240 *dp, &lv = *(dp=new (buf) ee20240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(8,4), "ee20240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), 0, "ee20240");
    check_base_class_offset(lv, (cc240*)(dd0240*), 0, "ee20240");
    check_base_class_offset(lv, (dd0240*), 0, "ee20240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20240.e");
    test_class_info(&lv, &cd_ee20240);
    dp->~ee20240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20240(Test_ee20240, "ee20240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20240C1Ev();
extern void _ZN7ee20240D1Ev();
Name_Map name_map_ee20240[] = {
  NSPAIR(_ZN7ee20240C1Ev),
  NSPAIR(_ZN7ee20240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee20240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20240[];
extern void _ZN4bb403barEv();
extern void _ZN7ee202403fooEv();
static  VTBL_ENTRY vtc_ee20240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN7ee202403fooEv,
};
extern VTBL_ENTRY _ZTI7ee20240[];
extern  VTBL_ENTRY _ZTV7ee20240[];
Class_Descriptor cd_ee20240 = {  "ee20240", // class name
  bases_ee20240, 4,
  &(vtc_ee20240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30240  : virtual dd0240 {
  int e;
  virtual void  foo(); // _ZN7ee302403fooEv
  ~ee30240(); // tgen
  ee30240(); // tgen
};
//SIG(1 ee30240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee30240 ::foo(){vfunc_called(this, "_ZN7ee302403fooEv");}
ee30240 ::~ee30240(){ note_dtor("ee30240", this);} // tgen
ee30240 ::ee30240(){ note_ctor("ee30240", this);} // tgen

static void Test_ee30240()
{
  extern Class_Descriptor cd_ee30240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30240, buf);
    ee30240 *dp, &lv = *(dp=new (buf) ee30240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(24,12), "ee30240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), ABISELECT(16,8), "ee30240");
    check_base_class_offset(lv, (cc240*)(dd0240*), ABISELECT(16,8), "ee30240");
    check_base_class_offset(lv, (dd0240*), ABISELECT(16,8), "ee30240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30240.e");
    test_class_info(&lv, &cd_ee30240);
    dp->~ee30240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30240(Test_ee30240, "ee30240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30240C1Ev();
extern void _ZN7ee30240D1Ev();
Name_Map name_map_ee30240[] = {
  NSPAIR(_ZN7ee30240C1Ev),
  NSPAIR(_ZN7ee30240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee30240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30240[];
extern void _ZN7ee302403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee302403fooEv,_ZTv0_n16_N7ee302403fooEv)();
extern void ABISELECT(_ZThn16_N7ee302403fooEv,_ZThn8_N7ee302403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30240[0]),
  (VTBL_ENTRY)&_ZN7ee302403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee302403fooEv,_ZTv0_n16_N7ee302403fooEv),
};
extern VTBL_ENTRY _ZTV7ee30240[];
static  VTT_ENTRY vtt_ee30240[] = {
  {&(_ZTV7ee30240[3]),  3,10},
  {&(_ZTV7ee30240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee30240[];
extern  VTBL_ENTRY _ZTV7ee30240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30240[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee302403fooEv,_ZTv0_n16_N7ee302403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302403fooEv,_ZThn8_N7ee302403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30240 = {  "ee30240", // class name
  bases_ee30240, 4,
  &(vtc_ee30240[0]), // expected_vtbl_contents
  &(vtt_ee30240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40240  : dd0240 {
  int e;
  virtual void  bar(); // _ZN7ee402403barEv
  ~ee40240(); // tgen
  ee40240(); // tgen
};
//SIG(1 ee40240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee40240 ::bar(){vfunc_called(this, "_ZN7ee402403barEv");}
ee40240 ::~ee40240(){ note_dtor("ee40240", this);} // tgen
ee40240 ::ee40240(){ note_ctor("ee40240", this);} // tgen

static void Test_ee40240()
{
  extern Class_Descriptor cd_ee40240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40240, buf);
    ee40240 *dp, &lv = *(dp=new (buf) ee40240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(8,4), "ee40240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), 0, "ee40240");
    check_base_class_offset(lv, (cc240*)(dd0240*), 0, "ee40240");
    check_base_class_offset(lv, (dd0240*), 0, "ee40240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40240.e");
    test_class_info(&lv, &cd_ee40240);
    dp->~ee40240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40240(Test_ee40240, "ee40240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40240C1Ev();
extern void _ZN7ee40240D1Ev();
Name_Map name_map_ee40240[] = {
  NSPAIR(_ZN7ee40240C1Ev),
  NSPAIR(_ZN7ee40240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee40240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40240[];
extern void _ZN7ee402403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee40240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40240[0]),
  (VTBL_ENTRY)&_ZN7ee402403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTI7ee40240[];
extern  VTBL_ENTRY _ZTV7ee40240[];
Class_Descriptor cd_ee40240 = {  "ee40240", // class name
  bases_ee40240, 4,
  &(vtc_ee40240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50240  : virtual dd0240 {
  int e;
  virtual void  bar(); // _ZN7ee502403barEv
  ~ee50240(); // tgen
  ee50240(); // tgen
};
//SIG(1 ee50240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee50240 ::bar(){vfunc_called(this, "_ZN7ee502403barEv");}
ee50240 ::~ee50240(){ note_dtor("ee50240", this);} // tgen
ee50240 ::ee50240(){ note_ctor("ee50240", this);} // tgen

static void Test_ee50240()
{
  extern Class_Descriptor cd_ee50240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50240, buf);
    ee50240 *dp, &lv = *(dp=new (buf) ee50240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(24,12), "ee50240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), ABISELECT(16,8), "ee50240");
    check_base_class_offset(lv, (cc240*)(dd0240*), ABISELECT(16,8), "ee50240");
    check_base_class_offset(lv, (dd0240*), ABISELECT(16,8), "ee50240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50240.e");
    test_class_info(&lv, &cd_ee50240);
    dp->~ee50240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50240(Test_ee50240, "ee50240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50240C1Ev();
extern void _ZN7ee50240D1Ev();
Name_Map name_map_ee50240[] = {
  NSPAIR(_ZN7ee50240C1Ev),
  NSPAIR(_ZN7ee50240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee50240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50240[];
extern void _ZN7ee502403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee502403barEv,_ZTv0_n12_N7ee502403barEv)();
extern void ABISELECT(_ZThn16_N7ee502403barEv,_ZThn8_N7ee502403barEv)() __attribute__((weak));
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee50240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50240[0]),
  (VTBL_ENTRY)&_ZN7ee502403barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee502403barEv,_ZTv0_n12_N7ee502403barEv),
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV7ee50240[];
static  VTT_ENTRY vtt_ee50240[] = {
  {&(_ZTV7ee50240[3]),  3,10},
  {&(_ZTV7ee50240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee50240[];
extern  VTBL_ENTRY _ZTV7ee50240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50240[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee502403barEv,_ZTv0_n12_N7ee502403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee502403barEv,_ZThn8_N7ee502403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee50240 = {  "ee50240", // class name
  bases_ee50240, 4,
  &(vtc_ee50240[0]), // expected_vtbl_contents
  &(vtt_ee50240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60240  : dd0240 {
  int e;
  virtual void  foo(); // _ZN7ee602403fooEv
  virtual void  bar(); // _ZN7ee602403barEv
  ~ee60240(); // tgen
  ee60240(); // tgen
};
//SIG(1 ee60240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee60240 ::foo(){vfunc_called(this, "_ZN7ee602403fooEv");}
void  ee60240 ::bar(){vfunc_called(this, "_ZN7ee602403barEv");}
ee60240 ::~ee60240(){ note_dtor("ee60240", this);} // tgen
ee60240 ::ee60240(){ note_ctor("ee60240", this);} // tgen

static void Test_ee60240()
{
  extern Class_Descriptor cd_ee60240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60240, buf);
    ee60240 *dp, &lv = *(dp=new (buf) ee60240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(8,4), "ee60240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), 0, "ee60240");
    check_base_class_offset(lv, (cc240*)(dd0240*), 0, "ee60240");
    check_base_class_offset(lv, (dd0240*), 0, "ee60240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60240.e");
    test_class_info(&lv, &cd_ee60240);
    dp->~ee60240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60240(Test_ee60240, "ee60240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60240C1Ev();
extern void _ZN7ee60240D1Ev();
Name_Map name_map_ee60240[] = {
  NSPAIR(_ZN7ee60240C1Ev),
  NSPAIR(_ZN7ee60240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee60240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60240[];
extern void _ZN7ee602403barEv();
extern void _ZN7ee602403fooEv();
static  VTBL_ENTRY vtc_ee60240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60240[0]),
  (VTBL_ENTRY)&_ZN7ee602403barEv,
  (VTBL_ENTRY)&_ZN7ee602403fooEv,
};
extern VTBL_ENTRY _ZTI7ee60240[];
extern  VTBL_ENTRY _ZTV7ee60240[];
Class_Descriptor cd_ee60240 = {  "ee60240", // class name
  bases_ee60240, 4,
  &(vtc_ee60240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70240  : virtual dd0240 {
  int e;
  virtual void  foo(); // _ZN7ee702403fooEv
  virtual void  bar(); // _ZN7ee702403barEv
  ~ee70240(); // tgen
  ee70240(); // tgen
};
//SIG(1 ee70240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee70240 ::foo(){vfunc_called(this, "_ZN7ee702403fooEv");}
void  ee70240 ::bar(){vfunc_called(this, "_ZN7ee702403barEv");}
ee70240 ::~ee70240(){ note_dtor("ee70240", this);} // tgen
ee70240 ::ee70240(){ note_ctor("ee70240", this);} // tgen

static void Test_ee70240()
{
  extern Class_Descriptor cd_ee70240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70240, buf);
    ee70240 *dp, &lv = *(dp=new (buf) ee70240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd0240*), ABISELECT(24,12), "ee70240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd0240*), ABISELECT(16,8), "ee70240");
    check_base_class_offset(lv, (cc240*)(dd0240*), ABISELECT(16,8), "ee70240");
    check_base_class_offset(lv, (dd0240*), ABISELECT(16,8), "ee70240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70240.e");
    test_class_info(&lv, &cd_ee70240);
    dp->~ee70240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70240(Test_ee70240, "ee70240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70240C1Ev();
extern void _ZN7ee70240D1Ev();
Name_Map name_map_ee70240[] = {
  NSPAIR(_ZN7ee70240C1Ev),
  NSPAIR(_ZN7ee70240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd0240;
extern VTBL_ENTRY _ZTI6dd0240[];
extern  VTBL_ENTRY _ZTV6dd0240[];
static Base_Class bases_ee70240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70240[];
extern void _ZN7ee702403fooEv();
extern void _ZN7ee702403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee702403barEv,_ZTv0_n12_N7ee702403barEv)();
extern void ABISELECT(_ZThn16_N7ee702403barEv,_ZThn8_N7ee702403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee702403fooEv,_ZTv0_n16_N7ee702403fooEv)();
extern void ABISELECT(_ZThn16_N7ee702403fooEv,_ZThn8_N7ee702403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70240[0]),
  (VTBL_ENTRY)&_ZN7ee702403fooEv,
  (VTBL_ENTRY)&_ZN7ee702403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee702403barEv,_ZTv0_n12_N7ee702403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee702403fooEv,_ZTv0_n16_N7ee702403fooEv),
};
extern VTBL_ENTRY _ZTV7ee70240[];
static  VTT_ENTRY vtt_ee70240[] = {
  {&(_ZTV7ee70240[3]),  3,11},
  {&(_ZTV7ee70240[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee70240[];
extern  VTBL_ENTRY _ZTV7ee70240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70240[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee702403fooEv,_ZTv0_n16_N7ee702403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702403fooEv,_ZThn8_N7ee702403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee702403barEv,_ZTv0_n12_N7ee702403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702403barEv,_ZThn8_N7ee702403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70240 = {  "ee70240", // class name
  bases_ee70240, 4,
  &(vtc_ee70240[0]), // expected_vtbl_contents
  &(vtt_ee70240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70240),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1240  : virtual cc240 {
  int d;
  ~dd1240(); // tgen
  dd1240(); // tgen
};
//SIG(-1 dd1240) C1{ VBC2{ BC3{ BC4{ Fi} v2 Fi} v1 Fi} Fi}


dd1240 ::~dd1240(){ note_dtor("dd1240", this);} // tgen
dd1240 ::dd1240(){ note_ctor("dd1240", this);} // tgen

static void Test_dd1240()
{
  extern Class_Descriptor cd_dd1240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1240, buf);
    dd1240 *dp, &lv = *(dp=new (buf) dd1240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,12), "dd1240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,8), "dd1240");
    check_base_class_offset(lv, (cc240*), ABISELECT(16,8), "dd1240");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1240.d");
    test_class_info(&lv, &cd_dd1240);
    dp->~dd1240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1240(Test_dd1240, "dd1240", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1240C1Ev();
extern void _ZN6dd1240D1Ev();
Name_Map name_map_dd1240[] = {
  NSPAIR(_ZN6dd1240C1Ev),
  NSPAIR(_ZN6dd1240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
static Base_Class bases_dd1240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1240[];
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_dd1240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV6dd1240[];
static  VTT_ENTRY vtt_dd1240[] = {
  {&(_ZTV6dd1240[3]),  3,9},
  {&(_ZTV6dd1240[7]),  7,9},
};
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
Class_Descriptor cd_dd1240 = {  "dd1240", // class name
  bases_dd1240, 3,
  &(vtc_dd1240[0]), // expected_vtbl_contents
  &(vtt_dd1240[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1240),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1240),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01240  : dd1240 {
  int e;
  ~ee01240(); // tgen
  ee01240(); // tgen
};
//SIG(1 ee01240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee01240 ::~ee01240(){ note_dtor("ee01240", this);} // tgen
ee01240 ::ee01240(){ note_ctor("ee01240", this);} // tgen

static void Test_ee01240()
{
  extern Class_Descriptor cd_ee01240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01240, buf);
    ee01240 *dp, &lv = *(dp=new (buf) ee01240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee01240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee01240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(16,12), "ee01240");
    check_base_class_offset(lv, (dd1240*), 0, "ee01240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01240.e");
    test_class_info(&lv, &cd_ee01240);
    dp->~ee01240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01240(Test_ee01240, "ee01240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01240C1Ev();
extern void _ZN7ee01240D1Ev();
Name_Map name_map_ee01240[] = {
  NSPAIR(_ZN7ee01240C1Ev),
  NSPAIR(_ZN7ee01240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee01240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01240[];
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee01240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01240[0]),
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV7ee01240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee01240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee01240[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee01240[] = {
  {&(_ZTV7ee01240[3]),  3,9},
  {&(_tg__ZTV6dd1240__7ee01240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee01240[4]),  4,6},
  {&(_ZTV7ee01240[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee01240[];
extern  VTBL_ENTRY _ZTV7ee01240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01240[];
Class_Descriptor cd_ee01240 = {  "ee01240", // class name
  bases_ee01240, 4,
  &(vtc_ee01240[0]), // expected_vtbl_contents
  &(vtt_ee01240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01240),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11240  : virtual dd1240 {
  int e;
  ~ee11240(); // tgen
  ee11240(); // tgen
};
//SIG(1 ee11240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} Fi}


ee11240 ::~ee11240(){ note_dtor("ee11240", this);} // tgen
ee11240 ::ee11240(){ note_ctor("ee11240", this);} // tgen

static void Test_ee11240()
{
  extern Class_Descriptor cd_ee11240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11240, buf);
    ee11240 *dp, &lv = *(dp=new (buf) ee11240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee11240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee11240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(32,16), "ee11240");
    check_base_class_offset(lv, (dd1240*), ABISELECT(16,8), "ee11240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11240.e");
    test_class_info(&lv, &cd_ee11240);
    dp->~ee11240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11240(Test_ee11240, "ee11240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11240C1Ev();
extern void _ZN7ee11240D1Ev();
Name_Map name_map_ee11240[] = {
  NSPAIR(_ZN7ee11240C1Ev),
  NSPAIR(_ZN7ee11240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee11240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11240[];
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee11240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11240[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11240[0]),
  0,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV7ee11240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee11240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee11240[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee11240[] = {
  {&(_ZTV7ee11240[4]),  4,13},
  {&(_ZTV7ee11240[7]),  7,13},
  {&(_ZTV7ee11240[11]),  11,13},
  {&(_tg__ZTV6dd1240__7ee11240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee11240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee11240[];
extern  VTBL_ENTRY _ZTV7ee11240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11240[];
Class_Descriptor cd_ee11240 = {  "ee11240", // class name
  bases_ee11240, 4,
  &(vtc_ee11240[0]), // expected_vtbl_contents
  &(vtt_ee11240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11240),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21240  : dd1240 {
  int e;
  virtual void  foo(); // _ZN7ee212403fooEv
  ~ee21240(); // tgen
  ee21240(); // tgen
};
//SIG(1 ee21240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee21240 ::foo(){vfunc_called(this, "_ZN7ee212403fooEv");}
ee21240 ::~ee21240(){ note_dtor("ee21240", this);} // tgen
ee21240 ::ee21240(){ note_ctor("ee21240", this);} // tgen

static void Test_ee21240()
{
  extern Class_Descriptor cd_ee21240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21240, buf);
    ee21240 *dp, &lv = *(dp=new (buf) ee21240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee21240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee21240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(16,12), "ee21240");
    check_base_class_offset(lv, (dd1240*), 0, "ee21240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21240.e");
    test_class_info(&lv, &cd_ee21240);
    dp->~ee21240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21240(Test_ee21240, "ee21240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21240C1Ev();
extern void _ZN7ee21240D1Ev();
Name_Map name_map_ee21240[] = {
  NSPAIR(_ZN7ee21240C1Ev),
  NSPAIR(_ZN7ee21240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee21240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21240[];
extern void _ZN7ee212403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee212403fooEv,_ZTv0_n16_N7ee212403fooEv)();
extern void ABISELECT(_ZThn16_N7ee212403fooEv,_ZThn12_N7ee212403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21240[0]),
  (VTBL_ENTRY)&_ZN7ee212403fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee212403fooEv,_ZTv0_n16_N7ee212403fooEv),
};
extern VTBL_ENTRY _ZTV7ee21240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee21240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee21240[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee21240[] = {
  {&(_ZTV7ee21240[3]),  3,10},
  {&(_tg__ZTV6dd1240__7ee21240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee21240[4]),  4,6},
  {&(_ZTV7ee21240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee21240[];
extern  VTBL_ENTRY _ZTV7ee21240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21240[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee212403fooEv,_ZTv0_n16_N7ee212403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee212403fooEv,_ZThn12_N7ee212403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21240 = {  "ee21240", // class name
  bases_ee21240, 4,
  &(vtc_ee21240[0]), // expected_vtbl_contents
  &(vtt_ee21240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31240  : virtual dd1240 {
  int e;
  virtual void  foo(); // _ZN7ee312403fooEv
  ~ee31240(); // tgen
  ee31240(); // tgen
};
//SIG(1 ee31240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 Fi}


void  ee31240 ::foo(){vfunc_called(this, "_ZN7ee312403fooEv");}
ee31240 ::~ee31240(){ note_dtor("ee31240", this);} // tgen
ee31240 ::ee31240(){ note_ctor("ee31240", this);} // tgen

static void Test_ee31240()
{
  extern Class_Descriptor cd_ee31240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31240, buf);
    ee31240 *dp, &lv = *(dp=new (buf) ee31240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee31240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee31240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(32,16), "ee31240");
    check_base_class_offset(lv, (dd1240*), ABISELECT(16,8), "ee31240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31240.e");
    test_class_info(&lv, &cd_ee31240);
    dp->~ee31240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31240(Test_ee31240, "ee31240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31240C1Ev();
extern void _ZN7ee31240D1Ev();
Name_Map name_map_ee31240[] = {
  NSPAIR(_ZN7ee31240C1Ev),
  NSPAIR(_ZN7ee31240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee31240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31240[];
extern void _ZN7ee312403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee312403fooEv,_ZTv0_n16_N7ee312403fooEv)();
extern void ABISELECT(_ZThn32_N7ee312403fooEv,_ZThn16_N7ee312403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31240[0]),
  (VTBL_ENTRY)&_ZN7ee312403fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31240[0]),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee312403fooEv,_ZTv0_n16_N7ee312403fooEv),
};
extern VTBL_ENTRY _ZTV7ee31240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee31240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee31240[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee31240[] = {
  {&(_ZTV7ee31240[4]),  4,14},
  {&(_ZTV7ee31240[8]),  8,14},
  {&(_ZTV7ee31240[12]),  12,14},
  {&(_tg__ZTV6dd1240__7ee31240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee31240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee31240[];
extern  VTBL_ENTRY _ZTV7ee31240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31240[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee312403fooEv,_ZTv0_n16_N7ee312403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee312403fooEv,_ZThn16_N7ee312403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31240 = {  "ee31240", // class name
  bases_ee31240, 4,
  &(vtc_ee31240[0]), // expected_vtbl_contents
  &(vtt_ee31240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31240),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41240  : dd1240 {
  int e;
  virtual void  bar(); // _ZN7ee412403barEv
  ~ee41240(); // tgen
  ee41240(); // tgen
};
//SIG(1 ee41240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee41240 ::bar(){vfunc_called(this, "_ZN7ee412403barEv");}
ee41240 ::~ee41240(){ note_dtor("ee41240", this);} // tgen
ee41240 ::ee41240(){ note_ctor("ee41240", this);} // tgen

static void Test_ee41240()
{
  extern Class_Descriptor cd_ee41240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41240, buf);
    ee41240 *dp, &lv = *(dp=new (buf) ee41240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee41240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee41240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(16,12), "ee41240");
    check_base_class_offset(lv, (dd1240*), 0, "ee41240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41240.e");
    test_class_info(&lv, &cd_ee41240);
    dp->~ee41240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41240(Test_ee41240, "ee41240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41240C1Ev();
extern void _ZN7ee41240D1Ev();
Name_Map name_map_ee41240[] = {
  NSPAIR(_ZN7ee41240C1Ev),
  NSPAIR(_ZN7ee41240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee41240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41240[];
extern void _ZN7ee412403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee412403barEv,_ZTv0_n12_N7ee412403barEv)();
extern void ABISELECT(_ZThn16_N7ee412403barEv,_ZThn12_N7ee412403barEv)() __attribute__((weak));
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee41240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41240[0]),
  (VTBL_ENTRY)&_ZN7ee412403barEv,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee412403barEv,_ZTv0_n12_N7ee412403barEv),
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV7ee41240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee41240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee41240[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee41240[] = {
  {&(_ZTV7ee41240[3]),  3,10},
  {&(_tg__ZTV6dd1240__7ee41240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee41240[4]),  4,6},
  {&(_ZTV7ee41240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee41240[];
extern  VTBL_ENTRY _ZTV7ee41240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41240[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee412403barEv,_ZTv0_n12_N7ee412403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee412403barEv,_ZThn12_N7ee412403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41240 = {  "ee41240", // class name
  bases_ee41240, 4,
  &(vtc_ee41240[0]), // expected_vtbl_contents
  &(vtt_ee41240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51240  : virtual dd1240 {
  int e;
  virtual void  bar(); // _ZN7ee512403barEv
  ~ee51240(); // tgen
  ee51240(); // tgen
};
//SIG(1 ee51240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} Fi} v1 Fi}


void  ee51240 ::bar(){vfunc_called(this, "_ZN7ee512403barEv");}
ee51240 ::~ee51240(){ note_dtor("ee51240", this);} // tgen
ee51240 ::ee51240(){ note_ctor("ee51240", this);} // tgen

static void Test_ee51240()
{
  extern Class_Descriptor cd_ee51240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51240, buf);
    ee51240 *dp, &lv = *(dp=new (buf) ee51240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee51240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee51240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(32,16), "ee51240");
    check_base_class_offset(lv, (dd1240*), ABISELECT(16,8), "ee51240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51240.e");
    test_class_info(&lv, &cd_ee51240);
    dp->~ee51240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51240(Test_ee51240, "ee51240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51240C1Ev();
extern void _ZN7ee51240D1Ev();
Name_Map name_map_ee51240[] = {
  NSPAIR(_ZN7ee51240C1Ev),
  NSPAIR(_ZN7ee51240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee51240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51240[];
extern void _ZN7ee512403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee512403barEv,_ZTv0_n12_N7ee512403barEv)();
extern void ABISELECT(_ZThn32_N7ee512403barEv,_ZThn16_N7ee512403barEv)() __attribute__((weak));
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee51240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51240[0]),
  (VTBL_ENTRY)&_ZN7ee512403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51240[0]),
  0,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee512403barEv,_ZTv0_n12_N7ee512403barEv),
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV7ee51240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee51240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee51240[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee51240[] = {
  {&(_ZTV7ee51240[4]),  4,14},
  {&(_ZTV7ee51240[8]),  8,14},
  {&(_ZTV7ee51240[12]),  12,14},
  {&(_tg__ZTV6dd1240__7ee51240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee51240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee51240[];
extern  VTBL_ENTRY _ZTV7ee51240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51240[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee512403barEv,_ZTv0_n12_N7ee512403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee512403barEv,_ZThn16_N7ee512403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee51240 = {  "ee51240", // class name
  bases_ee51240, 4,
  &(vtc_ee51240[0]), // expected_vtbl_contents
  &(vtt_ee51240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51240),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61240  : dd1240 {
  int e;
  virtual void  foo(); // _ZN7ee612403fooEv
  virtual void  bar(); // _ZN7ee612403barEv
  ~ee61240(); // tgen
  ee61240(); // tgen
};
//SIG(1 ee61240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee61240 ::foo(){vfunc_called(this, "_ZN7ee612403fooEv");}
void  ee61240 ::bar(){vfunc_called(this, "_ZN7ee612403barEv");}
ee61240 ::~ee61240(){ note_dtor("ee61240", this);} // tgen
ee61240 ::ee61240(){ note_ctor("ee61240", this);} // tgen

static void Test_ee61240()
{
  extern Class_Descriptor cd_ee61240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61240, buf);
    ee61240 *dp, &lv = *(dp=new (buf) ee61240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee61240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee61240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(16,12), "ee61240");
    check_base_class_offset(lv, (dd1240*), 0, "ee61240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61240.e");
    test_class_info(&lv, &cd_ee61240);
    dp->~ee61240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61240(Test_ee61240, "ee61240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61240C1Ev();
extern void _ZN7ee61240D1Ev();
Name_Map name_map_ee61240[] = {
  NSPAIR(_ZN7ee61240C1Ev),
  NSPAIR(_ZN7ee61240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee61240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61240[];
extern void _ZN7ee612403fooEv();
extern void _ZN7ee612403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee612403barEv,_ZTv0_n12_N7ee612403barEv)();
extern void ABISELECT(_ZThn16_N7ee612403barEv,_ZThn12_N7ee612403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee612403fooEv,_ZTv0_n16_N7ee612403fooEv)();
extern void ABISELECT(_ZThn16_N7ee612403fooEv,_ZThn12_N7ee612403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61240[0]),
  (VTBL_ENTRY)&_ZN7ee612403fooEv,
  (VTBL_ENTRY)&_ZN7ee612403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee612403barEv,_ZTv0_n12_N7ee612403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee612403fooEv,_ZTv0_n16_N7ee612403fooEv),
};
extern VTBL_ENTRY _ZTV7ee61240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee61240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee61240[] = {
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee61240[] = {
  {&(_ZTV7ee61240[3]),  3,11},
  {&(_tg__ZTV6dd1240__7ee61240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee61240[4]),  4,6},
  {&(_ZTV7ee61240[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee61240[];
extern  VTBL_ENTRY _ZTV7ee61240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61240[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee612403fooEv,_ZTv0_n16_N7ee612403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612403fooEv,_ZThn12_N7ee612403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee612403barEv,_ZTv0_n12_N7ee612403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612403barEv,_ZThn12_N7ee612403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61240 = {  "ee61240", // class name
  bases_ee61240, 4,
  &(vtc_ee61240[0]), // expected_vtbl_contents
  &(vtt_ee61240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61240),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71240  : virtual dd1240 {
  int e;
  virtual void  foo(); // _ZN7ee712403fooEv
  virtual void  bar(); // _ZN7ee712403barEv
  ~ee71240(); // tgen
  ee71240(); // tgen
};
//SIG(1 ee71240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee71240 ::foo(){vfunc_called(this, "_ZN7ee712403fooEv");}
void  ee71240 ::bar(){vfunc_called(this, "_ZN7ee712403barEv");}
ee71240 ::~ee71240(){ note_dtor("ee71240", this);} // tgen
ee71240 ::ee71240(){ note_ctor("ee71240", this);} // tgen

static void Test_ee71240()
{
  extern Class_Descriptor cd_ee71240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71240, buf);
    ee71240 *dp, &lv = *(dp=new (buf) ee71240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee71240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee71240");
    check_base_class_offset(lv, (cc240*)(dd1240*), ABISELECT(32,16), "ee71240");
    check_base_class_offset(lv, (dd1240*), ABISELECT(16,8), "ee71240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71240.e");
    test_class_info(&lv, &cd_ee71240);
    dp->~ee71240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71240(Test_ee71240, "ee71240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71240C1Ev();
extern void _ZN7ee71240D1Ev();
Name_Map name_map_ee71240[] = {
  NSPAIR(_ZN7ee71240C1Ev),
  NSPAIR(_ZN7ee71240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd1240;
extern VTBL_ENTRY _ZTI6dd1240[];
extern  VTBL_ENTRY _ZTV6dd1240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1240[];
static Base_Class bases_ee71240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1240,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71240[];
extern void _ZN7ee712403fooEv();
extern void _ZN7ee712403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee712403barEv,_ZTv0_n12_N7ee712403barEv)();
extern void ABISELECT(_ZThn32_N7ee712403barEv,_ZThn16_N7ee712403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee712403fooEv,_ZTv0_n16_N7ee712403fooEv)();
extern void ABISELECT(_ZThn32_N7ee712403fooEv,_ZThn16_N7ee712403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71240[0]),
  (VTBL_ENTRY)&_ZN7ee712403fooEv,
  (VTBL_ENTRY)&_ZN7ee712403barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71240[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee712403barEv,_ZTv0_n12_N7ee712403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee712403fooEv,_ZTv0_n16_N7ee712403fooEv),
};
extern VTBL_ENTRY _ZTV7ee71240[];
static  VTBL_ENTRY _tg__ZTV6dd1240__7ee71240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
};
extern void _ZN4bb403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY _tg__ZTV5cc240__6dd1240__7ee71240[] = {
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
static  VTT_ENTRY vtt_ee71240[] = {
  {&(_ZTV7ee71240[4]),  4,15},
  {&(_ZTV7ee71240[9]),  9,15},
  {&(_ZTV7ee71240[13]),  13,15},
  {&(_tg__ZTV6dd1240__7ee71240[3]),  3,3},
  {&(_tg__ZTV5cc240__6dd1240__7ee71240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee71240[];
extern  VTBL_ENTRY _ZTV7ee71240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71240[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee712403fooEv,_ZTv0_n16_N7ee712403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712403fooEv,_ZThn16_N7ee712403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee712403barEv,_ZTv0_n12_N7ee712403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712403barEv,_ZThn16_N7ee712403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71240 = {  "ee71240", // class name
  bases_ee71240, 4,
  &(vtc_ee71240[0]), // expected_vtbl_contents
  &(vtt_ee71240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71240),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2240  : cc240 {
  int d;
  virtual void  foo(); // _ZN6dd22403fooEv
  ~dd2240(); // tgen
  dd2240(); // tgen
};
//SIG(-1 dd2240) C1{ BC2{ BC3{ BC4{ Fi} v2 Fi} v1 Fi} v1 Fi}


void  dd2240 ::foo(){vfunc_called(this, "_ZN6dd22403fooEv");}
dd2240 ::~dd2240(){ note_dtor("dd2240", this);} // tgen
dd2240 ::dd2240(){ note_ctor("dd2240", this);} // tgen

static void Test_dd2240()
{
  extern Class_Descriptor cd_dd2240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2240, buf);
    dd2240 *dp, &lv = *(dp=new (buf) dd2240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(8,4), "dd2240");
    check_base_class_offset(lv, (bb40*)(cc240*), 0, "dd2240");
    check_base_class_offset(lv, (cc240*), 0, "dd2240");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2240.d");
    test_class_info(&lv, &cd_dd2240);
    dp->~dd2240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2240(Test_dd2240, "dd2240", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2240C1Ev();
extern void _ZN6dd2240D1Ev();
Name_Map name_map_dd2240[] = {
  NSPAIR(_ZN6dd2240C1Ev),
  NSPAIR(_ZN6dd2240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
static Base_Class bases_dd2240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2240[];
extern void _ZN4bb403barEv();
extern void _ZN6dd22403fooEv();
static  VTBL_ENTRY vtc_dd2240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN6dd22403fooEv,
};
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
Class_Descriptor cd_dd2240 = {  "dd2240", // class name
  bases_dd2240, 3,
  &(vtc_dd2240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02240  : dd2240 {
  int e;
  ~ee02240(); // tgen
  ee02240(); // tgen
};
//SIG(1 ee02240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} Fi}


ee02240 ::~ee02240(){ note_dtor("ee02240", this);} // tgen
ee02240 ::ee02240(){ note_ctor("ee02240", this);} // tgen

static void Test_ee02240()
{
  extern Class_Descriptor cd_ee02240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02240, buf);
    ee02240 *dp, &lv = *(dp=new (buf) ee02240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(8,4), "ee02240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), 0, "ee02240");
    check_base_class_offset(lv, (cc240*)(dd2240*), 0, "ee02240");
    check_base_class_offset(lv, (dd2240*), 0, "ee02240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02240.e");
    test_class_info(&lv, &cd_ee02240);
    dp->~ee02240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02240(Test_ee02240, "ee02240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02240C1Ev();
extern void _ZN7ee02240D1Ev();
Name_Map name_map_ee02240[] = {
  NSPAIR(_ZN7ee02240C1Ev),
  NSPAIR(_ZN7ee02240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee02240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02240[];
extern void _ZN4bb403barEv();
extern void _ZN6dd22403fooEv();
static  VTBL_ENTRY vtc_ee02240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN6dd22403fooEv,
};
extern VTBL_ENTRY _ZTI7ee02240[];
extern  VTBL_ENTRY _ZTV7ee02240[];
Class_Descriptor cd_ee02240 = {  "ee02240", // class name
  bases_ee02240, 4,
  &(vtc_ee02240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12240  : virtual dd2240 {
  int e;
  ~ee12240(); // tgen
  ee12240(); // tgen
};
//SIG(1 ee12240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} Fi}


ee12240 ::~ee12240(){ note_dtor("ee12240", this);} // tgen
ee12240 ::ee12240(){ note_ctor("ee12240", this);} // tgen

static void Test_ee12240()
{
  extern Class_Descriptor cd_ee12240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12240, buf);
    ee12240 *dp, &lv = *(dp=new (buf) ee12240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(24,12), "ee12240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), ABISELECT(16,8), "ee12240");
    check_base_class_offset(lv, (cc240*)(dd2240*), ABISELECT(16,8), "ee12240");
    check_base_class_offset(lv, (dd2240*), ABISELECT(16,8), "ee12240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12240.e");
    test_class_info(&lv, &cd_ee12240);
    dp->~ee12240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12240(Test_ee12240, "ee12240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12240C1Ev();
extern void _ZN7ee12240D1Ev();
Name_Map name_map_ee12240[] = {
  NSPAIR(_ZN7ee12240C1Ev),
  NSPAIR(_ZN7ee12240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee12240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12240[];
extern void _ZN4bb403barEv();
extern void _ZN6dd22403fooEv();
static  VTBL_ENTRY vtc_ee12240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12240[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN6dd22403fooEv,
};
extern VTBL_ENTRY _ZTV7ee12240[];
static  VTT_ENTRY vtt_ee12240[] = {
  {&(_ZTV7ee12240[3]),  3,9},
  {&(_ZTV7ee12240[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee12240[];
extern  VTBL_ENTRY _ZTV7ee12240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12240[];
Class_Descriptor cd_ee12240 = {  "ee12240", // class name
  bases_ee12240, 4,
  &(vtc_ee12240[0]), // expected_vtbl_contents
  &(vtt_ee12240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12240),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22240  : dd2240 {
  int e;
  virtual void  foo(); // _ZN7ee222403fooEv
  ~ee22240(); // tgen
  ee22240(); // tgen
};
//SIG(1 ee22240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee22240 ::foo(){vfunc_called(this, "_ZN7ee222403fooEv");}
ee22240 ::~ee22240(){ note_dtor("ee22240", this);} // tgen
ee22240 ::ee22240(){ note_ctor("ee22240", this);} // tgen

static void Test_ee22240()
{
  extern Class_Descriptor cd_ee22240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22240, buf);
    ee22240 *dp, &lv = *(dp=new (buf) ee22240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(8,4), "ee22240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), 0, "ee22240");
    check_base_class_offset(lv, (cc240*)(dd2240*), 0, "ee22240");
    check_base_class_offset(lv, (dd2240*), 0, "ee22240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22240.e");
    test_class_info(&lv, &cd_ee22240);
    dp->~ee22240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22240(Test_ee22240, "ee22240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22240C1Ev();
extern void _ZN7ee22240D1Ev();
Name_Map name_map_ee22240[] = {
  NSPAIR(_ZN7ee22240C1Ev),
  NSPAIR(_ZN7ee22240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee22240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22240[];
extern void _ZN4bb403barEv();
extern void _ZN7ee222403fooEv();
static  VTBL_ENTRY vtc_ee22240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&_ZN7ee222403fooEv,
};
extern VTBL_ENTRY _ZTI7ee22240[];
extern  VTBL_ENTRY _ZTV7ee22240[];
Class_Descriptor cd_ee22240 = {  "ee22240", // class name
  bases_ee22240, 4,
  &(vtc_ee22240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32240  : virtual dd2240 {
  int e;
  virtual void  foo(); // _ZN7ee322403fooEv
  ~ee32240(); // tgen
  ee32240(); // tgen
};
//SIG(1 ee32240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee32240 ::foo(){vfunc_called(this, "_ZN7ee322403fooEv");}
ee32240 ::~ee32240(){ note_dtor("ee32240", this);} // tgen
ee32240 ::ee32240(){ note_ctor("ee32240", this);} // tgen

static void Test_ee32240()
{
  extern Class_Descriptor cd_ee32240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32240, buf);
    ee32240 *dp, &lv = *(dp=new (buf) ee32240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(24,12), "ee32240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), ABISELECT(16,8), "ee32240");
    check_base_class_offset(lv, (cc240*)(dd2240*), ABISELECT(16,8), "ee32240");
    check_base_class_offset(lv, (dd2240*), ABISELECT(16,8), "ee32240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32240.e");
    test_class_info(&lv, &cd_ee32240);
    dp->~ee32240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32240(Test_ee32240, "ee32240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32240C1Ev();
extern void _ZN7ee32240D1Ev();
Name_Map name_map_ee32240[] = {
  NSPAIR(_ZN7ee32240C1Ev),
  NSPAIR(_ZN7ee32240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee32240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32240[];
extern void _ZN7ee322403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee322403fooEv,_ZTv0_n16_N7ee322403fooEv)();
extern void ABISELECT(_ZThn16_N7ee322403fooEv,_ZThn8_N7ee322403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32240[0]),
  (VTBL_ENTRY)&_ZN7ee322403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee322403fooEv,_ZTv0_n16_N7ee322403fooEv),
};
extern VTBL_ENTRY _ZTV7ee32240[];
static  VTT_ENTRY vtt_ee32240[] = {
  {&(_ZTV7ee32240[3]),  3,10},
  {&(_ZTV7ee32240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee32240[];
extern  VTBL_ENTRY _ZTV7ee32240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32240[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee322403fooEv,_ZTv0_n16_N7ee322403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee322403fooEv,_ZThn8_N7ee322403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32240 = {  "ee32240", // class name
  bases_ee32240, 4,
  &(vtc_ee32240[0]), // expected_vtbl_contents
  &(vtt_ee32240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42240  : dd2240 {
  int e;
  virtual void  bar(); // _ZN7ee422403barEv
  ~ee42240(); // tgen
  ee42240(); // tgen
};
//SIG(1 ee42240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee42240 ::bar(){vfunc_called(this, "_ZN7ee422403barEv");}
ee42240 ::~ee42240(){ note_dtor("ee42240", this);} // tgen
ee42240 ::ee42240(){ note_ctor("ee42240", this);} // tgen

static void Test_ee42240()
{
  extern Class_Descriptor cd_ee42240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42240, buf);
    ee42240 *dp, &lv = *(dp=new (buf) ee42240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(8,4), "ee42240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), 0, "ee42240");
    check_base_class_offset(lv, (cc240*)(dd2240*), 0, "ee42240");
    check_base_class_offset(lv, (dd2240*), 0, "ee42240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42240.e");
    test_class_info(&lv, &cd_ee42240);
    dp->~ee42240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42240(Test_ee42240, "ee42240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42240C1Ev();
extern void _ZN7ee42240D1Ev();
Name_Map name_map_ee42240[] = {
  NSPAIR(_ZN7ee42240C1Ev),
  NSPAIR(_ZN7ee42240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee42240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42240[];
extern void _ZN7ee422403barEv();
extern void _ZN6dd22403fooEv();
static  VTBL_ENTRY vtc_ee42240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42240[0]),
  (VTBL_ENTRY)&_ZN7ee422403barEv,
  (VTBL_ENTRY)&_ZN6dd22403fooEv,
};
extern VTBL_ENTRY _ZTI7ee42240[];
extern  VTBL_ENTRY _ZTV7ee42240[];
Class_Descriptor cd_ee42240 = {  "ee42240", // class name
  bases_ee42240, 4,
  &(vtc_ee42240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52240  : virtual dd2240 {
  int e;
  virtual void  bar(); // _ZN7ee522403barEv
  ~ee52240(); // tgen
  ee52240(); // tgen
};
//SIG(1 ee52240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee52240 ::bar(){vfunc_called(this, "_ZN7ee522403barEv");}
ee52240 ::~ee52240(){ note_dtor("ee52240", this);} // tgen
ee52240 ::ee52240(){ note_ctor("ee52240", this);} // tgen

static void Test_ee52240()
{
  extern Class_Descriptor cd_ee52240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52240, buf);
    ee52240 *dp, &lv = *(dp=new (buf) ee52240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(24,12), "ee52240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), ABISELECT(16,8), "ee52240");
    check_base_class_offset(lv, (cc240*)(dd2240*), ABISELECT(16,8), "ee52240");
    check_base_class_offset(lv, (dd2240*), ABISELECT(16,8), "ee52240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52240.e");
    test_class_info(&lv, &cd_ee52240);
    dp->~ee52240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52240(Test_ee52240, "ee52240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52240C1Ev();
extern void _ZN7ee52240D1Ev();
Name_Map name_map_ee52240[] = {
  NSPAIR(_ZN7ee52240C1Ev),
  NSPAIR(_ZN7ee52240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee52240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52240[];
extern void _ZN7ee522403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee522403barEv,_ZTv0_n12_N7ee522403barEv)();
extern void ABISELECT(_ZThn16_N7ee522403barEv,_ZThn8_N7ee522403barEv)() __attribute__((weak));
extern void _ZN6dd22403fooEv();
static  VTBL_ENTRY vtc_ee52240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52240[0]),
  (VTBL_ENTRY)&_ZN7ee522403barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee522403barEv,_ZTv0_n12_N7ee522403barEv),
  (VTBL_ENTRY)&_ZN6dd22403fooEv,
};
extern VTBL_ENTRY _ZTV7ee52240[];
static  VTT_ENTRY vtt_ee52240[] = {
  {&(_ZTV7ee52240[3]),  3,10},
  {&(_ZTV7ee52240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee52240[];
extern  VTBL_ENTRY _ZTV7ee52240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52240[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee522403barEv,_ZTv0_n12_N7ee522403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee522403barEv,_ZThn8_N7ee522403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52240 = {  "ee52240", // class name
  bases_ee52240, 4,
  &(vtc_ee52240[0]), // expected_vtbl_contents
  &(vtt_ee52240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62240  : dd2240 {
  int e;
  virtual void  foo(); // _ZN7ee622403fooEv
  virtual void  bar(); // _ZN7ee622403barEv
  ~ee62240(); // tgen
  ee62240(); // tgen
};
//SIG(1 ee62240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee62240 ::foo(){vfunc_called(this, "_ZN7ee622403fooEv");}
void  ee62240 ::bar(){vfunc_called(this, "_ZN7ee622403barEv");}
ee62240 ::~ee62240(){ note_dtor("ee62240", this);} // tgen
ee62240 ::ee62240(){ note_ctor("ee62240", this);} // tgen

static void Test_ee62240()
{
  extern Class_Descriptor cd_ee62240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62240, buf);
    ee62240 *dp, &lv = *(dp=new (buf) ee62240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(8,4), "ee62240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), 0, "ee62240");
    check_base_class_offset(lv, (cc240*)(dd2240*), 0, "ee62240");
    check_base_class_offset(lv, (dd2240*), 0, "ee62240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62240.e");
    test_class_info(&lv, &cd_ee62240);
    dp->~ee62240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62240(Test_ee62240, "ee62240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62240C1Ev();
extern void _ZN7ee62240D1Ev();
Name_Map name_map_ee62240[] = {
  NSPAIR(_ZN7ee62240C1Ev),
  NSPAIR(_ZN7ee62240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee62240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62240[];
extern void _ZN7ee622403barEv();
extern void _ZN7ee622403fooEv();
static  VTBL_ENTRY vtc_ee62240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62240[0]),
  (VTBL_ENTRY)&_ZN7ee622403barEv,
  (VTBL_ENTRY)&_ZN7ee622403fooEv,
};
extern VTBL_ENTRY _ZTI7ee62240[];
extern  VTBL_ENTRY _ZTV7ee62240[];
Class_Descriptor cd_ee62240 = {  "ee62240", // class name
  bases_ee62240, 4,
  &(vtc_ee62240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72240  : virtual dd2240 {
  int e;
  virtual void  foo(); // _ZN7ee722403fooEv
  virtual void  bar(); // _ZN7ee722403barEv
  ~ee72240(); // tgen
  ee72240(); // tgen
};
//SIG(1 ee72240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee72240 ::foo(){vfunc_called(this, "_ZN7ee722403fooEv");}
void  ee72240 ::bar(){vfunc_called(this, "_ZN7ee722403barEv");}
ee72240 ::~ee72240(){ note_dtor("ee72240", this);} // tgen
ee72240 ::ee72240(){ note_ctor("ee72240", this);} // tgen

static void Test_ee72240()
{
  extern Class_Descriptor cd_ee72240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72240, buf);
    ee72240 *dp, &lv = *(dp=new (buf) ee72240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd2240*), ABISELECT(24,12), "ee72240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd2240*), ABISELECT(16,8), "ee72240");
    check_base_class_offset(lv, (cc240*)(dd2240*), ABISELECT(16,8), "ee72240");
    check_base_class_offset(lv, (dd2240*), ABISELECT(16,8), "ee72240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72240.e");
    test_class_info(&lv, &cd_ee72240);
    dp->~ee72240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72240(Test_ee72240, "ee72240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72240C1Ev();
extern void _ZN7ee72240D1Ev();
Name_Map name_map_ee72240[] = {
  NSPAIR(_ZN7ee72240C1Ev),
  NSPAIR(_ZN7ee72240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd2240;
extern VTBL_ENTRY _ZTI6dd2240[];
extern  VTBL_ENTRY _ZTV6dd2240[];
static Base_Class bases_ee72240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2240,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72240[];
extern void _ZN7ee722403fooEv();
extern void _ZN7ee722403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee722403barEv,_ZTv0_n12_N7ee722403barEv)();
extern void ABISELECT(_ZThn16_N7ee722403barEv,_ZThn8_N7ee722403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee722403fooEv,_ZTv0_n16_N7ee722403fooEv)();
extern void ABISELECT(_ZThn16_N7ee722403fooEv,_ZThn8_N7ee722403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72240[0]),
  (VTBL_ENTRY)&_ZN7ee722403fooEv,
  (VTBL_ENTRY)&_ZN7ee722403barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee722403barEv,_ZTv0_n12_N7ee722403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee722403fooEv,_ZTv0_n16_N7ee722403fooEv),
};
extern VTBL_ENTRY _ZTV7ee72240[];
static  VTT_ENTRY vtt_ee72240[] = {
  {&(_ZTV7ee72240[3]),  3,11},
  {&(_ZTV7ee72240[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee72240[];
extern  VTBL_ENTRY _ZTV7ee72240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72240[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee722403fooEv,_ZTv0_n16_N7ee722403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee722403fooEv,_ZThn8_N7ee722403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee722403barEv,_ZTv0_n12_N7ee722403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee722403barEv,_ZThn8_N7ee722403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72240 = {  "ee72240", // class name
  bases_ee72240, 4,
  &(vtc_ee72240[0]), // expected_vtbl_contents
  &(vtt_ee72240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72240),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3240  : virtual cc240 {
  int d;
  virtual void  foo(); // _ZN6dd32403fooEv
  ~dd3240(); // tgen
  dd3240(); // tgen
};
//SIG(-1 dd3240) C1{ VBC2{ BC3{ BC4{ Fi} v2 Fi} v1 Fi} v1 Fi}


void  dd3240 ::foo(){vfunc_called(this, "_ZN6dd32403fooEv");}
dd3240 ::~dd3240(){ note_dtor("dd3240", this);} // tgen
dd3240 ::dd3240(){ note_ctor("dd3240", this);} // tgen

static void Test_dd3240()
{
  extern Class_Descriptor cd_dd3240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3240, buf);
    dd3240 *dp, &lv = *(dp=new (buf) dd3240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,12), "dd3240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,8), "dd3240");
    check_base_class_offset(lv, (cc240*), ABISELECT(16,8), "dd3240");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3240.d");
    test_class_info(&lv, &cd_dd3240);
    dp->~dd3240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3240(Test_dd3240, "dd3240", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3240C1Ev();
extern void _ZN6dd3240D1Ev();
Name_Map name_map_dd3240[] = {
  NSPAIR(_ZN6dd3240C1Ev),
  NSPAIR(_ZN6dd3240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
static Base_Class bases_dd3240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3240[];
extern void _ZN6dd32403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
extern VTBL_ENTRY _ZTV6dd3240[];
static  VTT_ENTRY vtt_dd3240[] = {
  {&(_ZTV6dd3240[3]),  3,10},
  {&(_ZTV6dd3240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3240 = {  "dd3240", // class name
  bases_dd3240, 3,
  &(vtc_dd3240[0]), // expected_vtbl_contents
  &(vtt_dd3240[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3240),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03240  : dd3240 {
  int e;
  ~ee03240(); // tgen
  ee03240(); // tgen
};
//SIG(1 ee03240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} Fi}


ee03240 ::~ee03240(){ note_dtor("ee03240", this);} // tgen
ee03240 ::ee03240(){ note_ctor("ee03240", this);} // tgen

static void Test_ee03240()
{
  extern Class_Descriptor cd_ee03240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03240, buf);
    ee03240 *dp, &lv = *(dp=new (buf) ee03240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee03240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee03240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(16,12), "ee03240");
    check_base_class_offset(lv, (dd3240*), 0, "ee03240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03240.e");
    test_class_info(&lv, &cd_ee03240);
    dp->~ee03240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03240(Test_ee03240, "ee03240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03240C1Ev();
extern void _ZN7ee03240D1Ev();
Name_Map name_map_ee03240[] = {
  NSPAIR(_ZN7ee03240C1Ev),
  NSPAIR(_ZN7ee03240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee03240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03240[];
extern void _ZN6dd32403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
extern VTBL_ENTRY _ZTV7ee03240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee03240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee03240[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee03240[] = {
  {&(_ZTV7ee03240[3]),  3,10},
  {&(_tg__ZTV6dd3240__7ee03240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee03240[4]),  4,6},
  {&(_ZTV7ee03240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee03240[];
extern  VTBL_ENTRY _ZTV7ee03240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03240[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03240 = {  "ee03240", // class name
  bases_ee03240, 4,
  &(vtc_ee03240[0]), // expected_vtbl_contents
  &(vtt_ee03240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13240  : virtual dd3240 {
  int e;
  ~ee13240(); // tgen
  ee13240(); // tgen
};
//SIG(1 ee13240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} Fi}


ee13240 ::~ee13240(){ note_dtor("ee13240", this);} // tgen
ee13240 ::ee13240(){ note_ctor("ee13240", this);} // tgen

static void Test_ee13240()
{
  extern Class_Descriptor cd_ee13240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13240, buf);
    ee13240 *dp, &lv = *(dp=new (buf) ee13240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee13240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee13240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(32,16), "ee13240");
    check_base_class_offset(lv, (dd3240*), ABISELECT(16,8), "ee13240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13240.e");
    test_class_info(&lv, &cd_ee13240);
    dp->~ee13240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13240(Test_ee13240, "ee13240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13240C1Ev();
extern void _ZN7ee13240D1Ev();
Name_Map name_map_ee13240[] = {
  NSPAIR(_ZN7ee13240C1Ev),
  NSPAIR(_ZN7ee13240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee13240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13240[];
extern void _ZN6dd32403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13240[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
extern VTBL_ENTRY _ZTV7ee13240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee13240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee13240[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee13240[] = {
  {&(_ZTV7ee13240[4]),  4,15},
  {&(_ZTV7ee13240[8]),  8,15},
  {&(_ZTV7ee13240[13]),  13,15},
  {&(_tg__ZTV6dd3240__7ee13240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee13240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee13240[];
extern  VTBL_ENTRY _ZTV7ee13240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13240[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13240 = {  "ee13240", // class name
  bases_ee13240, 4,
  &(vtc_ee13240[0]), // expected_vtbl_contents
  &(vtt_ee13240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13240),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23240  : dd3240 {
  int e;
  virtual void  foo(); // _ZN7ee232403fooEv
  ~ee23240(); // tgen
  ee23240(); // tgen
};
//SIG(1 ee23240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee23240 ::foo(){vfunc_called(this, "_ZN7ee232403fooEv");}
ee23240 ::~ee23240(){ note_dtor("ee23240", this);} // tgen
ee23240 ::ee23240(){ note_ctor("ee23240", this);} // tgen

static void Test_ee23240()
{
  extern Class_Descriptor cd_ee23240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23240, buf);
    ee23240 *dp, &lv = *(dp=new (buf) ee23240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee23240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee23240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(16,12), "ee23240");
    check_base_class_offset(lv, (dd3240*), 0, "ee23240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23240.e");
    test_class_info(&lv, &cd_ee23240);
    dp->~ee23240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23240(Test_ee23240, "ee23240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23240C1Ev();
extern void _ZN7ee23240D1Ev();
Name_Map name_map_ee23240[] = {
  NSPAIR(_ZN7ee23240C1Ev),
  NSPAIR(_ZN7ee23240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee23240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23240[];
extern void _ZN7ee232403fooEv();
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee232403fooEv,_ZTv0_n16_N7ee232403fooEv)();
extern void ABISELECT(_ZThn16_N7ee232403fooEv,_ZThn12_N7ee232403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23240[0]),
  (VTBL_ENTRY)&_ZN7ee232403fooEv,
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee232403fooEv,_ZTv0_n16_N7ee232403fooEv),
};
extern VTBL_ENTRY _ZTV7ee23240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee23240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee23240[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee23240[] = {
  {&(_ZTV7ee23240[3]),  3,10},
  {&(_tg__ZTV6dd3240__7ee23240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee23240[4]),  4,6},
  {&(_ZTV7ee23240[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee23240[];
extern  VTBL_ENTRY _ZTV7ee23240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23240[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee232403fooEv,_ZTv0_n16_N7ee232403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee232403fooEv,_ZThn12_N7ee232403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23240 = {  "ee23240", // class name
  bases_ee23240, 4,
  &(vtc_ee23240[0]), // expected_vtbl_contents
  &(vtt_ee23240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23240),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33240  : virtual dd3240 {
  int e;
  virtual void  foo(); // _ZN7ee332403fooEv
  ~ee33240(); // tgen
  ee33240(); // tgen
};
//SIG(1 ee33240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee33240 ::foo(){vfunc_called(this, "_ZN7ee332403fooEv");}
ee33240 ::~ee33240(){ note_dtor("ee33240", this);} // tgen
ee33240 ::ee33240(){ note_ctor("ee33240", this);} // tgen

static void Test_ee33240()
{
  extern Class_Descriptor cd_ee33240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33240, buf);
    ee33240 *dp, &lv = *(dp=new (buf) ee33240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee33240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee33240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(32,16), "ee33240");
    check_base_class_offset(lv, (dd3240*), ABISELECT(16,8), "ee33240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33240.e");
    test_class_info(&lv, &cd_ee33240);
    dp->~ee33240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33240(Test_ee33240, "ee33240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33240C1Ev();
extern void _ZN7ee33240D1Ev();
Name_Map name_map_ee33240[] = {
  NSPAIR(_ZN7ee33240C1Ev),
  NSPAIR(_ZN7ee33240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee33240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33240[];
extern void _ZN7ee332403fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee332403fooEv,_ZTv0_n16_N7ee332403fooEv)();
extern void ABISELECT(_ZThn16_N7ee332403fooEv,_ZThn8_N7ee332403fooEv)() __attribute__((weak));
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee332403fooEv,_ZTv0_n16_N7ee332403fooEv)();
extern void ABISELECT(_ZThn32_N7ee332403fooEv,_ZThn16_N7ee332403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33240[0]),
  (VTBL_ENTRY)&_ZN7ee332403fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee332403fooEv,_ZTv0_n16_N7ee332403fooEv),
  ABISELECT(-32,-16),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee332403fooEv,_ZTv0_n16_N7ee332403fooEv),
};
extern VTBL_ENTRY _ZTV7ee33240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee33240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee33240[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee33240[] = {
  {&(_ZTV7ee33240[4]),  4,16},
  {&(_ZTV7ee33240[9]),  9,16},
  {&(_ZTV7ee33240[14]),  14,16},
  {&(_tg__ZTV6dd3240__7ee33240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee33240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee33240[];
extern  VTBL_ENTRY _ZTV7ee33240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33240[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee332403fooEv,_ZTv0_n16_N7ee332403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee332403fooEv,_ZThn16_N7ee332403fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee332403fooEv,_ZThn8_N7ee332403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33240 = {  "ee33240", // class name
  bases_ee33240, 4,
  &(vtc_ee33240[0]), // expected_vtbl_contents
  &(vtt_ee33240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33240),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names108,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43240  : dd3240 {
  int e;
  virtual void  bar(); // _ZN7ee432403barEv
  ~ee43240(); // tgen
  ee43240(); // tgen
};
//SIG(1 ee43240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee43240 ::bar(){vfunc_called(this, "_ZN7ee432403barEv");}
ee43240 ::~ee43240(){ note_dtor("ee43240", this);} // tgen
ee43240 ::ee43240(){ note_ctor("ee43240", this);} // tgen

static void Test_ee43240()
{
  extern Class_Descriptor cd_ee43240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43240, buf);
    ee43240 *dp, &lv = *(dp=new (buf) ee43240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee43240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee43240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(16,12), "ee43240");
    check_base_class_offset(lv, (dd3240*), 0, "ee43240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43240.e");
    test_class_info(&lv, &cd_ee43240);
    dp->~ee43240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43240(Test_ee43240, "ee43240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43240C1Ev();
extern void _ZN7ee43240D1Ev();
Name_Map name_map_ee43240[] = {
  NSPAIR(_ZN7ee43240C1Ev),
  NSPAIR(_ZN7ee43240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee43240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43240[];
extern void _ZN6dd32403fooEv();
extern void _ZN7ee432403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee432403barEv,_ZTv0_n12_N7ee432403barEv)();
extern void ABISELECT(_ZThn16_N7ee432403barEv,_ZThn12_N7ee432403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
  (VTBL_ENTRY)&_ZN7ee432403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee432403barEv,_ZTv0_n12_N7ee432403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
extern VTBL_ENTRY _ZTV7ee43240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee43240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee43240[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee43240[] = {
  {&(_ZTV7ee43240[3]),  3,11},
  {&(_tg__ZTV6dd3240__7ee43240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee43240[4]),  4,6},
  {&(_ZTV7ee43240[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee43240[];
extern  VTBL_ENTRY _ZTV7ee43240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43240[];
static VTBL_ENTRY alt_thunk_names109[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee432403barEv,_ZTv0_n12_N7ee432403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee432403barEv,_ZThn12_N7ee432403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43240 = {  "ee43240", // class name
  bases_ee43240, 4,
  &(vtc_ee43240[0]), // expected_vtbl_contents
  &(vtt_ee43240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43240),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names109,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53240  : virtual dd3240 {
  int e;
  virtual void  bar(); // _ZN7ee532403barEv
  ~ee53240(); // tgen
  ee53240(); // tgen
};
//SIG(1 ee53240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee53240 ::bar(){vfunc_called(this, "_ZN7ee532403barEv");}
ee53240 ::~ee53240(){ note_dtor("ee53240", this);} // tgen
ee53240 ::ee53240(){ note_ctor("ee53240", this);} // tgen

static void Test_ee53240()
{
  extern Class_Descriptor cd_ee53240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53240, buf);
    ee53240 *dp, &lv = *(dp=new (buf) ee53240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee53240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee53240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(32,16), "ee53240");
    check_base_class_offset(lv, (dd3240*), ABISELECT(16,8), "ee53240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53240.e");
    test_class_info(&lv, &cd_ee53240);
    dp->~ee53240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53240(Test_ee53240, "ee53240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53240C1Ev();
extern void _ZN7ee53240D1Ev();
Name_Map name_map_ee53240[] = {
  NSPAIR(_ZN7ee53240C1Ev),
  NSPAIR(_ZN7ee53240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee53240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53240[];
extern void _ZN7ee532403barEv();
extern void _ZN6dd32403fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee532403barEv,_ZTv0_n12_N7ee532403barEv)();
extern void ABISELECT(_ZThn32_N7ee532403barEv,_ZThn16_N7ee532403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53240[0]),
  (VTBL_ENTRY)&_ZN7ee532403barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee532403barEv,_ZTv0_n12_N7ee532403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
extern VTBL_ENTRY _ZTV7ee53240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee53240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee53240[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee53240[] = {
  {&(_ZTV7ee53240[4]),  4,16},
  {&(_ZTV7ee53240[9]),  9,16},
  {&(_ZTV7ee53240[14]),  14,16},
  {&(_tg__ZTV6dd3240__7ee53240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee53240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee53240[];
extern  VTBL_ENTRY _ZTV7ee53240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53240[];
static VTBL_ENTRY alt_thunk_names110[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee532403barEv,_ZTv0_n12_N7ee532403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee532403barEv,_ZThn16_N7ee532403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53240 = {  "ee53240", // class name
  bases_ee53240, 4,
  &(vtc_ee53240[0]), // expected_vtbl_contents
  &(vtt_ee53240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53240),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names110,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63240  : dd3240 {
  int e;
  virtual void  foo(); // _ZN7ee632403fooEv
  virtual void  bar(); // _ZN7ee632403barEv
  ~ee63240(); // tgen
  ee63240(); // tgen
};
//SIG(1 ee63240) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee63240 ::foo(){vfunc_called(this, "_ZN7ee632403fooEv");}
void  ee63240 ::bar(){vfunc_called(this, "_ZN7ee632403barEv");}
ee63240 ::~ee63240(){ note_dtor("ee63240", this);} // tgen
ee63240 ::ee63240(){ note_ctor("ee63240", this);} // tgen

static void Test_ee63240()
{
  extern Class_Descriptor cd_ee63240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63240, buf);
    ee63240 *dp, &lv = *(dp=new (buf) ee63240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(24,16), "ee63240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(16,12), "ee63240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(16,12), "ee63240");
    check_base_class_offset(lv, (dd3240*), 0, "ee63240");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63240.e");
    test_class_info(&lv, &cd_ee63240);
    dp->~ee63240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63240(Test_ee63240, "ee63240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63240C1Ev();
extern void _ZN7ee63240D1Ev();
Name_Map name_map_ee63240[] = {
  NSPAIR(_ZN7ee63240C1Ev),
  NSPAIR(_ZN7ee63240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee63240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63240[];
extern void _ZN7ee632403fooEv();
extern void _ZN7ee632403barEv();
extern void ABISELECT(_ZTv0_n24_N7ee632403barEv,_ZTv0_n12_N7ee632403barEv)();
extern void ABISELECT(_ZThn16_N7ee632403barEv,_ZThn12_N7ee632403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee632403fooEv,_ZTv0_n16_N7ee632403fooEv)();
extern void ABISELECT(_ZThn16_N7ee632403fooEv,_ZThn12_N7ee632403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63240[0]),
  (VTBL_ENTRY)&_ZN7ee632403fooEv,
  (VTBL_ENTRY)&_ZN7ee632403barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee632403barEv,_ZTv0_n12_N7ee632403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee632403fooEv,_ZTv0_n16_N7ee632403fooEv),
};
extern VTBL_ENTRY _ZTV7ee63240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee63240[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee63240[] = {
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee63240[] = {
  {&(_ZTV7ee63240[3]),  3,11},
  {&(_tg__ZTV6dd3240__7ee63240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee63240[4]),  4,6},
  {&(_ZTV7ee63240[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee63240[];
extern  VTBL_ENTRY _ZTV7ee63240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63240[];
static VTBL_ENTRY alt_thunk_names111[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn12_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee632403fooEv,_ZTv0_n16_N7ee632403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee632403fooEv,_ZThn12_N7ee632403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee632403barEv,_ZTv0_n12_N7ee632403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee632403barEv,_ZThn12_N7ee632403barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63240 = {  "ee63240", // class name
  bases_ee63240, 4,
  &(vtc_ee63240[0]), // expected_vtbl_contents
  &(vtt_ee63240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63240),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63240),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names111,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73240  : virtual dd3240 {
  int e;
  virtual void  foo(); // _ZN7ee732403fooEv
  virtual void  bar(); // _ZN7ee732403barEv
  ~ee73240(); // tgen
  ee73240(); // tgen
};
//SIG(1 ee73240) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee73240 ::foo(){vfunc_called(this, "_ZN7ee732403fooEv");}
void  ee73240 ::bar(){vfunc_called(this, "_ZN7ee732403barEv");}
ee73240 ::~ee73240(){ note_dtor("ee73240", this);} // tgen
ee73240 ::ee73240(){ note_ctor("ee73240", this);} // tgen

static void Test_ee73240()
{
  extern Class_Descriptor cd_ee73240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73240, buf);
    ee73240 *dp, &lv = *(dp=new (buf) ee73240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(40,20), "ee73240");
    check_base_class_offset(lv, (bb40*)(cc240*), ABISELECT(32,16), "ee73240");
    check_base_class_offset(lv, (cc240*)(dd3240*), ABISELECT(32,16), "ee73240");
    check_base_class_offset(lv, (dd3240*), ABISELECT(16,8), "ee73240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73240.e");
    test_class_info(&lv, &cd_ee73240);
    dp->~ee73240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73240(Test_ee73240, "ee73240", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73240C1Ev();
extern void _ZN7ee73240D1Ev();
Name_Map name_map_ee73240[] = {
  NSPAIR(_ZN7ee73240C1Ev),
  NSPAIR(_ZN7ee73240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd3240;
extern VTBL_ENTRY _ZTI6dd3240[];
extern  VTBL_ENTRY _ZTV6dd3240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3240[];
static Base_Class bases_ee73240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3240,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73240[];
extern void _ZN7ee732403fooEv();
extern void _ZN7ee732403barEv();
extern void ABISELECT(_ZTv0_n32_N7ee732403fooEv,_ZTv0_n16_N7ee732403fooEv)();
extern void ABISELECT(_ZThn16_N7ee732403fooEv,_ZThn8_N7ee732403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee732403barEv,_ZTv0_n12_N7ee732403barEv)();
extern void ABISELECT(_ZThn32_N7ee732403barEv,_ZThn16_N7ee732403barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee732403fooEv,_ZTv0_n16_N7ee732403fooEv)();
extern void ABISELECT(_ZThn32_N7ee732403fooEv,_ZThn16_N7ee732403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73240[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73240[0]),
  (VTBL_ENTRY)&_ZN7ee732403fooEv,
  (VTBL_ENTRY)&_ZN7ee732403barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee732403fooEv,_ZTv0_n16_N7ee732403fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73240[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee732403barEv,_ZTv0_n12_N7ee732403barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee732403fooEv,_ZTv0_n16_N7ee732403fooEv),
};
extern VTBL_ENTRY _ZTV7ee73240[];
extern void _ZN6dd32403fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3240__7ee73240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN6dd32403fooEv,
};
extern void _ZN4bb403barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv)();
extern void ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc240__6dd3240__7ee73240[] = {
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3240[0]),
  (VTBL_ENTRY)&_ZN4bb403barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv),
};
static  VTT_ENTRY vtt_ee73240[] = {
  {&(_ZTV7ee73240[4]),  4,17},
  {&(_ZTV7ee73240[10]),  10,17},
  {&(_ZTV7ee73240[15]),  15,17},
  {&(_tg__ZTV6dd3240__7ee73240[3]),  3,4},
  {&(_tg__ZTV5cc240__6dd3240__7ee73240[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7ee73240[];
extern  VTBL_ENTRY _ZTV7ee73240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73240[];
static VTBL_ENTRY alt_thunk_names112[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32403fooEv,_ZTv0_n16_N6dd32403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32403fooEv,_ZThn8_N6dd32403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee732403barEv,_ZTv0_n12_N7ee732403barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee732403barEv,_ZThn16_N7ee732403barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee732403fooEv,_ZTv0_n16_N7ee732403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee732403fooEv,_ZThn16_N7ee732403fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee732403fooEv,_ZThn8_N7ee732403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73240 = {  "ee73240", // class name
  bases_ee73240, 4,
  &(vtc_ee73240[0]), // expected_vtbl_contents
  &(vtt_ee73240[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73240),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73240),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names112,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4240  : cc240 {
  int d;
  virtual void  bar(); // _ZN6dd42403barEv
  ~dd4240(); // tgen
  dd4240(); // tgen
};
//SIG(-1 dd4240) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} v2 Fi} v1 Fi}


void  dd4240 ::bar(){vfunc_called(this, "_ZN6dd42403barEv");}
dd4240 ::~dd4240(){ note_dtor("dd4240", this);} // tgen
dd4240 ::dd4240(){ note_ctor("dd4240", this);} // tgen

static void Test_dd4240()
{
  extern Class_Descriptor cd_dd4240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4240, buf);
    dd4240 *dp, &lv = *(dp=new (buf) dd4240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*), ABISELECT(8,4), "dd4240");
    check_base_class_offset(lv, (bb40*)(cc240*), 0, "dd4240");
    check_base_class_offset(lv, (cc240*), 0, "dd4240");
    check_field_offset(lv, d, ABISELECT(20,16), "dd4240.d");
    test_class_info(&lv, &cd_dd4240);
    dp->~dd4240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4240(Test_dd4240, "dd4240", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4240C1Ev();
extern void _ZN6dd4240D1Ev();
Name_Map name_map_dd4240[] = {
  NSPAIR(_ZN6dd4240C1Ev),
  NSPAIR(_ZN6dd4240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
static Base_Class bases_dd4240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4240[];
extern void _ZN6dd42403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_dd4240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd4240[0]),
  (VTBL_ENTRY)&_ZN6dd42403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTI6dd4240[];
extern  VTBL_ENTRY _ZTV6dd4240[];
Class_Descriptor cd_dd4240 = {  "dd4240", // class name
  bases_dd4240, 3,
  &(vtc_dd4240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04240  : dd4240 {
  int e;
  ~ee04240(); // tgen
  ee04240(); // tgen
};
//SIG(1 ee04240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} v1 Fi} Fi}


ee04240 ::~ee04240(){ note_dtor("ee04240", this);} // tgen
ee04240 ::ee04240(){ note_ctor("ee04240", this);} // tgen

static void Test_ee04240()
{
  extern Class_Descriptor cd_ee04240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04240, buf);
    ee04240 *dp, &lv = *(dp=new (buf) ee04240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd4240*), ABISELECT(8,4), "ee04240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd4240*), 0, "ee04240");
    check_base_class_offset(lv, (cc240*)(dd4240*), 0, "ee04240");
    check_base_class_offset(lv, (dd4240*), 0, "ee04240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee04240.e");
    test_class_info(&lv, &cd_ee04240);
    dp->~ee04240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04240(Test_ee04240, "ee04240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04240C1Ev();
extern void _ZN7ee04240D1Ev();
Name_Map name_map_ee04240[] = {
  NSPAIR(_ZN7ee04240C1Ev),
  NSPAIR(_ZN7ee04240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd4240;
extern VTBL_ENTRY _ZTI6dd4240[];
extern  VTBL_ENTRY _ZTV6dd4240[];
static Base_Class bases_ee04240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4240,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04240[];
extern void _ZN6dd42403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee04240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee04240[0]),
  (VTBL_ENTRY)&_ZN6dd42403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTI7ee04240[];
extern  VTBL_ENTRY _ZTV7ee04240[];
Class_Descriptor cd_ee04240 = {  "ee04240", // class name
  bases_ee04240, 4,
  &(vtc_ee04240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14240  : virtual dd4240 {
  int e;
  ~ee14240(); // tgen
  ee14240(); // tgen
};
//SIG(1 ee14240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v2 Fi} v1 Fi} Fi}


ee14240 ::~ee14240(){ note_dtor("ee14240", this);} // tgen
ee14240 ::ee14240(){ note_ctor("ee14240", this);} // tgen

static void Test_ee14240()
{
  extern Class_Descriptor cd_ee14240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14240, buf);
    ee14240 *dp, &lv = *(dp=new (buf) ee14240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd4240*), ABISELECT(24,12), "ee14240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd4240*), ABISELECT(16,8), "ee14240");
    check_base_class_offset(lv, (cc240*)(dd4240*), ABISELECT(16,8), "ee14240");
    check_base_class_offset(lv, (dd4240*), ABISELECT(16,8), "ee14240");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14240.e");
    test_class_info(&lv, &cd_ee14240);
    dp->~ee14240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14240(Test_ee14240, "ee14240", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14240C1Ev();
extern void _ZN7ee14240D1Ev();
Name_Map name_map_ee14240[] = {
  NSPAIR(_ZN7ee14240C1Ev),
  NSPAIR(_ZN7ee14240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd4240;
extern VTBL_ENTRY _ZTI6dd4240[];
extern  VTBL_ENTRY _ZTV6dd4240[];
static Base_Class bases_ee14240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4240,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14240[];
extern void _ZN6dd42403barEv();
extern void _ZN5cc2403fooEv();
static  VTBL_ENTRY vtc_ee14240[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14240[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14240[0]),
  (VTBL_ENTRY)&_ZN6dd42403barEv,
  (VTBL_ENTRY)&_ZN5cc2403fooEv,
};
extern VTBL_ENTRY _ZTV7ee14240[];
static  VTT_ENTRY vtt_ee14240[] = {
  {&(_ZTV7ee14240[3]),  3,9},
  {&(_ZTV7ee14240[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee14240[];
extern  VTBL_ENTRY _ZTV7ee14240[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14240[];
Class_Descriptor cd_ee14240 = {  "ee14240", // class name
  bases_ee14240, 4,
  &(vtc_ee14240[0]), // expected_vtbl_contents
  &(vtt_ee14240[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14240),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14240),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14240),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24240  : dd4240 {
  int e;
  virtual void  foo(); // _ZN7ee242403fooEv
  ~ee24240(); // tgen
  ee24240(); // tgen
};
//SIG(1 ee24240) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee24240 ::foo(){vfunc_called(this, "_ZN7ee242403fooEv");}
ee24240 ::~ee24240(){ note_dtor("ee24240", this);} // tgen
ee24240 ::ee24240(){ note_ctor("ee24240", this);} // tgen

static void Test_ee24240()
{
  extern Class_Descriptor cd_ee24240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24240, buf);
    ee24240 *dp, &lv = *(dp=new (buf) ee24240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd4240*), ABISELECT(8,4), "ee24240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd4240*), 0, "ee24240");
    check_base_class_offset(lv, (cc240*)(dd4240*), 0, "ee24240");
    check_base_class_offset(lv, (dd4240*), 0, "ee24240");
    check_field_offset(lv, e, ABISELECT(24,20), "ee24240.e");
    test_class_info(&lv, &cd_ee24240);
    dp->~ee24240();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24240(Test_ee24240, "ee24240", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24240C1Ev();
extern void _ZN7ee24240D1Ev();
Name_Map name_map_ee24240[] = {
  NSPAIR(_ZN7ee24240C1Ev),
  NSPAIR(_ZN7ee24240D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_cc240;
extern VTBL_ENTRY _ZTI5cc240[];
extern  VTBL_ENTRY _ZTV5cc240[];
extern Class_Descriptor cd_dd4240;
extern VTBL_ENTRY _ZTI6dd4240[];
extern  VTBL_ENTRY _ZTV6dd4240[];
static Base_Class bases_ee24240[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4240,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24240[];
extern void _ZN6dd42403barEv();
extern void _ZN7ee242403fooEv();
static  VTBL_ENTRY vtc_ee24240[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee24240[0]),
  (VTBL_ENTRY)&_ZN6dd42403barEv,
  (VTBL_ENTRY)&_ZN7ee242403fooEv,
};
extern VTBL_ENTRY _ZTI7ee24240[];
extern  VTBL_ENTRY _ZTV7ee24240[];
Class_Descriptor cd_ee24240 = {  "ee24240", // class name
  bases_ee24240, 4,
  &(vtc_ee24240[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24240),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24240),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34240  : virtual dd4240 {
  int e;
  virtual void  foo(); // _ZN7ee342403fooEv
  ~ee34240(); // tgen
  ee34240(); // tgen
};
//SIG(1 ee34240) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee34240 ::foo(){vfunc_called(this, "_ZN7ee342403fooEv");}
ee34240 ::~ee34240(){ note_dtor("ee34240", this);} // tgen
ee34240 ::ee34240(){ note_ctor("ee34240", this);} // tgen

static void Test_ee34240()
{
  extern Class_Descriptor cd_ee34240;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34240, buf);
    ee34240 *dp, &lv = *(dp=new (buf) ee34240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34240)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34240)");
    check_base_class_offset(lv, (aa0*)(bb40*)(cc240*)(dd4240*), ABISELECT(24,12), "ee34240");
    check_base_class_offset(lv, (bb40*)(cc240*)(dd4240*), ABISELECT(16,8), "ee34240");
    check_base_class_offset(lv, (cc240*)(dd4240*), ABISELECT(16,8), "ee34240");
    check_base_class_offset(lv