// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb30  : virtual aa0 {
  int b;
  virtual void  foo(); // _ZN4bb303fooEv
  ~bb30(); // tgen
  bb30(); // tgen
};
//SIG(-1 bb30) C1{ VBC2{ Fi} v1 Fi}


void  bb30 ::foo(){vfunc_called(this, "_ZN4bb303fooEv");}
bb30 ::~bb30(){ note_dtor("bb30", this);} // tgen
bb30 ::bb30(){ note_ctor("bb30", this);} // tgen

static void Test_bb30()
{
  extern Class_Descriptor cd_bb30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_bb30, buf);
    bb30 *dp, &lv = *(dp=new (buf) bb30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(bb30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb30)");
    check_base_class_offset(lv, (aa0*), ABISELECT(12,8), "bb30");
    check_field_offset(lv, b, ABISELECT(8,4), "bb30.b");
    test_class_info(&lv, &cd_bb30);
    dp->~bb30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb30(Test_bb30, "bb30", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN4bb30C1Ev();
extern void _ZN4bb30D1Ev();
Name_Map name_map_bb30[] = {
  NSPAIR(_ZN4bb30C1Ev),
  NSPAIR(_ZN4bb30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4bb30[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_bb30[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV4bb30[];
static  VTT_ENTRY vtt_bb30[] = {
  {&(_ZTV4bb30[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
Class_Descriptor cd_bb30 = {  "bb30", // class name
  bases_bb30, 1,
  &(vtc_bb30[0]), // expected_vtbl_contents
  &(vtt_bb30[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI4bb30),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4bb30),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4bb30),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc030  : bb30 {
  int c;
  ~cc030(); // tgen
  cc030(); // tgen
};
//SIG(-1 cc030) C1{ BC2{ VBC3{ Fi} v1 Fi} Fi}


cc030 ::~cc030(){ note_dtor("cc030", this);} // tgen
cc030 ::cc030(){ note_ctor("cc030", this);} // tgen

static void Test_cc030()
{
  extern Class_Descriptor cd_cc030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc030, buf);
    cc030 *dp, &lv = *(dp=new (buf) cc030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc030)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(16,12), "cc030");
    check_base_class_offset(lv, (bb30*), 0, "cc030");
    check_field_offset(lv, c, ABISELECT(12,8), "cc030.c");
    test_class_info(&lv, &cd_cc030);
    dp->~cc030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc030(Test_cc030, "cc030", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc030C1Ev();
extern void _ZN5cc030D1Ev();
Name_Map name_map_cc030[] = {
  NSPAIR(_ZN5cc030C1Ev),
  NSPAIR(_ZN5cc030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
static Base_Class bases_cc030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_cc030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV5cc030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_cc030[] = {
  {&(_ZTV5cc030[3]),  3,4},
  {&(_tg__ZTV4bb30__5cc030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
Class_Descriptor cd_cc030 = {  "cc030", // class name
  bases_cc030, 2,
  &(vtc_cc030[0]), // expected_vtbl_contents
  &(vtt_cc030[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc030),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc030),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0030  : cc030 {
  int d;
  ~dd0030(); // tgen
  dd0030(); // tgen
};
//SIG(-1 dd0030) C1{ BC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd0030 ::~dd0030(){ note_dtor("dd0030", this);} // tgen
dd0030 ::dd0030(){ note_ctor("dd0030", this);} // tgen

static void Test_dd0030()
{
  extern Class_Descriptor cd_dd0030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0030, buf);
    dd0030 *dp, &lv = *(dp=new (buf) dd0030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(20,16), "dd0030");
    check_base_class_offset(lv, (bb30*)(cc030*), 0, "dd0030");
    check_base_class_offset(lv, (cc030*), 0, "dd0030");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0030.d");
    test_class_info(&lv, &cd_dd0030);
    dp->~dd0030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0030(Test_dd0030, "dd0030", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0030C1Ev();
extern void _ZN6dd0030D1Ev();
Name_Map name_map_dd0030[] = {
  NSPAIR(_ZN6dd0030C1Ev),
  NSPAIR(_ZN6dd0030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd0030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_dd0030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV6dd0030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd0030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd0030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd0030[] = {
  {&(_ZTV6dd0030[3]),  3,4},
  {&(_tg__ZTV5cc030__6dd0030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd0030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
Class_Descriptor cd_dd0030 = {  "dd0030", // class name
  bases_dd0030, 3,
  &(vtc_dd0030[0]), // expected_vtbl_contents
  &(vtt_dd0030[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0030),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0030),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00030  : dd0030 {
  int e;
  ~ee00030(); // tgen
  ee00030(); // tgen
};
//SIG(1 ee00030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00030 ::~ee00030(){ note_dtor("ee00030", this);} // tgen
ee00030 ::ee00030(){ note_ctor("ee00030", this);} // tgen

static void Test_ee00030()
{
  extern Class_Descriptor cd_ee00030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00030, buf);
    ee00030 *dp, &lv = *(dp=new (buf) ee00030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(24,20), "ee00030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), 0, "ee00030");
    check_base_class_offset(lv, (cc030*)(dd0030*), 0, "ee00030");
    check_base_class_offset(lv, (dd0030*), 0, "ee00030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00030.e");
    test_class_info(&lv, &cd_ee00030);
    dp->~ee00030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00030(Test_ee00030, "ee00030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00030C1Ev();
extern void _ZN7ee00030D1Ev();
Name_Map name_map_ee00030[] = {
  NSPAIR(_ZN7ee00030C1Ev),
  NSPAIR(_ZN7ee00030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee00030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee00030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee00030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee00030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee00030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee00030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee00030[] = {
  {&(_ZTV7ee00030[3]),  3,4},
  {&(_tg__ZTV6dd0030__7ee00030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee00030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee00030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee00030[];
extern  VTBL_ENTRY _ZTV7ee00030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00030[];
Class_Descriptor cd_ee00030 = {  "ee00030", // class name
  bases_ee00030, 4,
  &(vtc_ee00030[0]), // expected_vtbl_contents
  &(vtt_ee00030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00030),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10030  : virtual dd0030 {
  int e;
  ~ee10030(); // tgen
  ee10030(); // tgen
};
//SIG(1 ee10030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10030 ::~ee10030(){ note_dtor("ee10030", this);} // tgen
ee10030 ::ee10030(){ note_ctor("ee10030", this);} // tgen

static void Test_ee10030()
{
  extern Class_Descriptor cd_ee10030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10030, buf);
    ee10030 *dp, &lv = *(dp=new (buf) ee10030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(36,24), "ee10030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), ABISELECT(16,8), "ee10030");
    check_base_class_offset(lv, (cc030*)(dd0030*), ABISELECT(16,8), "ee10030");
    check_base_class_offset(lv, (dd0030*), ABISELECT(16,8), "ee10030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10030.e");
    test_class_info(&lv, &cd_ee10030);
    dp->~ee10030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10030(Test_ee10030, "ee10030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10030C1Ev();
extern void _ZN7ee10030D1Ev();
Name_Map name_map_ee10030[] = {
  NSPAIR(_ZN7ee10030C1Ev),
  NSPAIR(_ZN7ee10030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee10030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee10030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10030[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee10030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee10030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee10030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee10030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee10030[] = {
  {&(_ZTV7ee10030[4]),  4,9},
  {&(_ZTV7ee10030[8]),  8,9},
  {&(_tg__ZTV6dd0030__7ee10030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee10030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee10030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10030[];
extern  VTBL_ENTRY _ZTV7ee10030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10030[];
Class_Descriptor cd_ee10030 = {  "ee10030", // class name
  bases_ee10030, 4,
  &(vtc_ee10030[0]), // expected_vtbl_contents
  &(vtt_ee10030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10030),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20030  : dd0030 {
  int e;
  virtual void  foo(); // _ZN7ee200303fooEv
  ~ee20030(); // tgen
  ee20030(); // tgen
};
//SIG(1 ee20030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee20030 ::foo(){vfunc_called(this, "_ZN7ee200303fooEv");}
ee20030 ::~ee20030(){ note_dtor("ee20030", this);} // tgen
ee20030 ::ee20030(){ note_ctor("ee20030", this);} // tgen

static void Test_ee20030()
{
  extern Class_Descriptor cd_ee20030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20030, buf);
    ee20030 *dp, &lv = *(dp=new (buf) ee20030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(24,20), "ee20030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), 0, "ee20030");
    check_base_class_offset(lv, (cc030*)(dd0030*), 0, "ee20030");
    check_base_class_offset(lv, (dd0030*), 0, "ee20030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20030.e");
    test_class_info(&lv, &cd_ee20030);
    dp->~ee20030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20030(Test_ee20030, "ee20030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20030C1Ev();
extern void _ZN7ee20030D1Ev();
Name_Map name_map_ee20030[] = {
  NSPAIR(_ZN7ee20030C1Ev),
  NSPAIR(_ZN7ee20030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee20030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20030[];
extern void _ZN7ee200303fooEv();
static  VTBL_ENTRY vtc_ee20030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20030[0]),
  (VTBL_ENTRY)&_ZN7ee200303fooEv,
};
extern VTBL_ENTRY _ZTV7ee20030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee20030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee20030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee20030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee20030[] = {
  {&(_ZTV7ee20030[3]),  3,4},
  {&(_tg__ZTV6dd0030__7ee20030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee20030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee20030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee20030[];
extern  VTBL_ENTRY _ZTV7ee20030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20030[];
Class_Descriptor cd_ee20030 = {  "ee20030", // class name
  bases_ee20030, 4,
  &(vtc_ee20030[0]), // expected_vtbl_contents
  &(vtt_ee20030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20030),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30030  : virtual dd0030 {
  int e;
  virtual void  foo(); // _ZN7ee300303fooEv
  ~ee30030(); // tgen
  ee30030(); // tgen
};
//SIG(1 ee30030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee30030 ::foo(){vfunc_called(this, "_ZN7ee300303fooEv");}
ee30030 ::~ee30030(){ note_dtor("ee30030", this);} // tgen
ee30030 ::ee30030(){ note_ctor("ee30030", this);} // tgen

static void Test_ee30030()
{
  extern Class_Descriptor cd_ee30030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30030, buf);
    ee30030 *dp, &lv = *(dp=new (buf) ee30030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(36,24), "ee30030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), ABISELECT(16,8), "ee30030");
    check_base_class_offset(lv, (cc030*)(dd0030*), ABISELECT(16,8), "ee30030");
    check_base_class_offset(lv, (dd0030*), ABISELECT(16,8), "ee30030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30030.e");
    test_class_info(&lv, &cd_ee30030);
    dp->~ee30030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30030(Test_ee30030, "ee30030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30030C1Ev();
extern void _ZN7ee30030D1Ev();
Name_Map name_map_ee30030[] = {
  NSPAIR(_ZN7ee30030C1Ev),
  NSPAIR(_ZN7ee30030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee30030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30030[];
extern void _ZN7ee300303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee300303fooEv,_ZTv0_n16_N7ee300303fooEv)();
extern void ABISELECT(_ZThn16_N7ee300303fooEv,_ZThn8_N7ee300303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30030[0]),
  (VTBL_ENTRY)&_ZN7ee300303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee300303fooEv,_ZTv0_n16_N7ee300303fooEv),
};
extern VTBL_ENTRY _ZTV7ee30030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee30030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee30030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee30030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee30030[] = {
  {&(_ZTV7ee30030[4]),  4,10},
  {&(_ZTV7ee30030[9]),  9,10},
  {&(_tg__ZTV6dd0030__7ee30030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee30030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee30030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30030[];
extern  VTBL_ENTRY _ZTV7ee30030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30030[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee300303fooEv,_ZTv0_n16_N7ee300303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee300303fooEv,_ZThn8_N7ee300303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30030 = {  "ee30030", // class name
  bases_ee30030, 4,
  &(vtc_ee30030[0]), // expected_vtbl_contents
  &(vtt_ee30030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40030  : dd0030 {
  int e;
  virtual void  bar(); // _ZN7ee400303barEv
  ~ee40030(); // tgen
  ee40030(); // tgen
};
//SIG(1 ee40030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee40030 ::bar(){vfunc_called(this, "_ZN7ee400303barEv");}
ee40030 ::~ee40030(){ note_dtor("ee40030", this);} // tgen
ee40030 ::ee40030(){ note_ctor("ee40030", this);} // tgen

static void Test_ee40030()
{
  extern Class_Descriptor cd_ee40030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40030, buf);
    ee40030 *dp, &lv = *(dp=new (buf) ee40030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(24,20), "ee40030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), 0, "ee40030");
    check_base_class_offset(lv, (cc030*)(dd0030*), 0, "ee40030");
    check_base_class_offset(lv, (dd0030*), 0, "ee40030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee40030.e");
    test_class_info(&lv, &cd_ee40030);
    dp->~ee40030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40030(Test_ee40030, "ee40030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40030C1Ev();
extern void _ZN7ee40030D1Ev();
Name_Map name_map_ee40030[] = {
  NSPAIR(_ZN7ee40030C1Ev),
  NSPAIR(_ZN7ee40030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee40030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40030[];
extern void _ZN4bb303fooEv();
extern void _ZN7ee400303barEv();
static  VTBL_ENTRY vtc_ee40030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN7ee400303barEv,
};
extern VTBL_ENTRY _ZTV7ee40030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee40030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee40030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee40030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee40030[] = {
  {&(_ZTV7ee40030[3]),  3,5},
  {&(_tg__ZTV6dd0030__7ee40030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee40030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee40030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee40030[];
extern  VTBL_ENTRY _ZTV7ee40030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40030[];
Class_Descriptor cd_ee40030 = {  "ee40030", // class name
  bases_ee40030, 4,
  &(vtc_ee40030[0]), // expected_vtbl_contents
  &(vtt_ee40030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50030  : virtual dd0030 {
  int e;
  virtual void  bar(); // _ZN7ee500303barEv
  ~ee50030(); // tgen
  ee50030(); // tgen
};
//SIG(1 ee50030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee50030 ::bar(){vfunc_called(this, "_ZN7ee500303barEv");}
ee50030 ::~ee50030(){ note_dtor("ee50030", this);} // tgen
ee50030 ::ee50030(){ note_ctor("ee50030", this);} // tgen

static void Test_ee50030()
{
  extern Class_Descriptor cd_ee50030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50030, buf);
    ee50030 *dp, &lv = *(dp=new (buf) ee50030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(36,24), "ee50030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), ABISELECT(16,8), "ee50030");
    check_base_class_offset(lv, (cc030*)(dd0030*), ABISELECT(16,8), "ee50030");
    check_base_class_offset(lv, (dd0030*), ABISELECT(16,8), "ee50030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50030.e");
    test_class_info(&lv, &cd_ee50030);
    dp->~ee50030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50030(Test_ee50030, "ee50030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50030C1Ev();
extern void _ZN7ee50030D1Ev();
Name_Map name_map_ee50030[] = {
  NSPAIR(_ZN7ee50030C1Ev),
  NSPAIR(_ZN7ee50030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee50030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50030[];
extern void _ZN7ee500303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee50030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50030[0]),
  (VTBL_ENTRY)&_ZN7ee500303barEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee50030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee50030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee50030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee50030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee50030[] = {
  {&(_ZTV7ee50030[4]),  4,10},
  {&(_ZTV7ee50030[9]),  9,10},
  {&(_tg__ZTV6dd0030__7ee50030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee50030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee50030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50030[];
extern  VTBL_ENTRY _ZTV7ee50030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50030[];
Class_Descriptor cd_ee50030 = {  "ee50030", // class name
  bases_ee50030, 4,
  &(vtc_ee50030[0]), // expected_vtbl_contents
  &(vtt_ee50030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60030  : dd0030 {
  int e;
  virtual void  foo(); // _ZN7ee600303fooEv
  virtual void  bar(); // _ZN7ee600303barEv
  ~ee60030(); // tgen
  ee60030(); // tgen
};
//SIG(1 ee60030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60030 ::foo(){vfunc_called(this, "_ZN7ee600303fooEv");}
void  ee60030 ::bar(){vfunc_called(this, "_ZN7ee600303barEv");}
ee60030 ::~ee60030(){ note_dtor("ee60030", this);} // tgen
ee60030 ::ee60030(){ note_ctor("ee60030", this);} // tgen

static void Test_ee60030()
{
  extern Class_Descriptor cd_ee60030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60030, buf);
    ee60030 *dp, &lv = *(dp=new (buf) ee60030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(24,20), "ee60030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), 0, "ee60030");
    check_base_class_offset(lv, (cc030*)(dd0030*), 0, "ee60030");
    check_base_class_offset(lv, (dd0030*), 0, "ee60030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee60030.e");
    test_class_info(&lv, &cd_ee60030);
    dp->~ee60030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60030(Test_ee60030, "ee60030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60030C1Ev();
extern void _ZN7ee60030D1Ev();
Name_Map name_map_ee60030[] = {
  NSPAIR(_ZN7ee60030C1Ev),
  NSPAIR(_ZN7ee60030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee60030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60030[];
extern void _ZN7ee600303fooEv();
extern void _ZN7ee600303barEv();
static  VTBL_ENTRY vtc_ee60030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60030[0]),
  (VTBL_ENTRY)&_ZN7ee600303fooEv,
  (VTBL_ENTRY)&_ZN7ee600303barEv,
};
extern VTBL_ENTRY _ZTV7ee60030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee60030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee60030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee60030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee60030[] = {
  {&(_ZTV7ee60030[3]),  3,5},
  {&(_tg__ZTV6dd0030__7ee60030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee60030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee60030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee60030[];
extern  VTBL_ENTRY _ZTV7ee60030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60030[];
Class_Descriptor cd_ee60030 = {  "ee60030", // class name
  bases_ee60030, 4,
  &(vtc_ee60030[0]), // expected_vtbl_contents
  &(vtt_ee60030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70030  : virtual dd0030 {
  int e;
  virtual void  foo(); // _ZN7ee700303fooEv
  virtual void  bar(); // _ZN7ee700303barEv
  ~ee70030(); // tgen
  ee70030(); // tgen
};
//SIG(1 ee70030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70030 ::foo(){vfunc_called(this, "_ZN7ee700303fooEv");}
void  ee70030 ::bar(){vfunc_called(this, "_ZN7ee700303barEv");}
ee70030 ::~ee70030(){ note_dtor("ee70030", this);} // tgen
ee70030 ::ee70030(){ note_ctor("ee70030", this);} // tgen

static void Test_ee70030()
{
  extern Class_Descriptor cd_ee70030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70030, buf);
    ee70030 *dp, &lv = *(dp=new (buf) ee70030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd0030*), ABISELECT(36,24), "ee70030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd0030*), ABISELECT(16,8), "ee70030");
    check_base_class_offset(lv, (cc030*)(dd0030*), ABISELECT(16,8), "ee70030");
    check_base_class_offset(lv, (dd0030*), ABISELECT(16,8), "ee70030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70030.e");
    test_class_info(&lv, &cd_ee70030);
    dp->~ee70030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70030(Test_ee70030, "ee70030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70030C1Ev();
extern void _ZN7ee70030D1Ev();
Name_Map name_map_ee70030[] = {
  NSPAIR(_ZN7ee70030C1Ev),
  NSPAIR(_ZN7ee70030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd0030;
extern VTBL_ENTRY _ZTI6dd0030[];
extern  VTBL_ENTRY _ZTV6dd0030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0030[];
static Base_Class bases_ee70030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70030[];
extern void _ZN7ee700303fooEv();
extern void _ZN7ee700303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee700303fooEv,_ZTv0_n16_N7ee700303fooEv)();
extern void ABISELECT(_ZThn16_N7ee700303fooEv,_ZThn8_N7ee700303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70030[0]),
  (VTBL_ENTRY)&_ZN7ee700303fooEv,
  (VTBL_ENTRY)&_ZN7ee700303barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee700303fooEv,_ZTv0_n16_N7ee700303fooEv),
};
extern VTBL_ENTRY _ZTV7ee70030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0030__7ee70030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd0030__7ee70030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd0030__7ee70030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee70030[] = {
  {&(_ZTV7ee70030[4]),  4,11},
  {&(_ZTV7ee70030[10]),  10,11},
  {&(_tg__ZTV6dd0030__7ee70030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd0030__7ee70030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd0030__7ee70030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70030[];
extern  VTBL_ENTRY _ZTV7ee70030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70030[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee700303fooEv,_ZTv0_n16_N7ee700303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700303fooEv,_ZThn8_N7ee700303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70030 = {  "ee70030", // class name
  bases_ee70030, 4,
  &(vtc_ee70030[0]), // expected_vtbl_contents
  &(vtt_ee70030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1030  : virtual cc030 {
  int d;
  ~dd1030(); // tgen
  dd1030(); // tgen
};
//SIG(-1 dd1030) C1{ VBC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd1030 ::~dd1030(){ note_dtor("dd1030", this);} // tgen
dd1030 ::dd1030(){ note_ctor("dd1030", this);} // tgen

static void Test_dd1030()
{
  extern Class_Descriptor cd_dd1030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1030, buf);
    dd1030 *dp, &lv = *(dp=new (buf) dd1030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,20), "dd1030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,8), "dd1030");
    check_base_class_offset(lv, (cc030*), ABISELECT(16,8), "dd1030");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1030.d");
    test_class_info(&lv, &cd_dd1030);
    dp->~dd1030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1030(Test_dd1030, "dd1030", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1030C1Ev();
extern void _ZN6dd1030D1Ev();
Name_Map name_map_dd1030[] = {
  NSPAIR(_ZN6dd1030C1Ev),
  NSPAIR(_ZN6dd1030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd1030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_dd1030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV6dd1030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd1030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd1030[] = {
  {&(_ZTV6dd1030[4]),  4,9},
  {&(_ZTV6dd1030[8]),  8,9},
  {&(_tg__ZTV5cc030__6dd1030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd1030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
Class_Descriptor cd_dd1030 = {  "dd1030", // class name
  bases_dd1030, 3,
  &(vtc_dd1030[0]), // expected_vtbl_contents
  &(vtt_dd1030[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1030),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1030),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01030  : dd1030 {
  int e;
  ~ee01030(); // tgen
  ee01030(); // tgen
};
//SIG(1 ee01030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01030 ::~ee01030(){ note_dtor("ee01030", this);} // tgen
ee01030 ::ee01030(){ note_ctor("ee01030", this);} // tgen

static void Test_ee01030()
{
  extern Class_Descriptor cd_ee01030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01030, buf);
    ee01030 *dp, &lv = *(dp=new (buf) ee01030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee01030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee01030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(16,12), "ee01030");
    check_base_class_offset(lv, (dd1030*), 0, "ee01030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01030.e");
    test_class_info(&lv, &cd_ee01030);
    dp->~ee01030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01030(Test_ee01030, "ee01030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01030C1Ev();
extern void _ZN7ee01030D1Ev();
Name_Map name_map_ee01030[] = {
  NSPAIR(_ZN7ee01030C1Ev),
  NSPAIR(_ZN7ee01030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee01030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee01030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01030[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee01030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee01030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee01030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee01030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee01030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee01030[] = {
  {&(_ZTV7ee01030[4]),  4,9},
  {&(_tg__ZTV6dd1030__7ee01030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee01030[4]),  4,5},
  {&(_ZTV7ee01030[8]),  8,9},
  {&(_tg__ZTV5cc030__7ee01030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee01030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01030[];
extern  VTBL_ENTRY _ZTV7ee01030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01030[];
Class_Descriptor cd_ee01030 = {  "ee01030", // class name
  bases_ee01030, 4,
  &(vtc_ee01030[0]), // expected_vtbl_contents
  &(vtt_ee01030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01030),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11030  : virtual dd1030 {
  int e;
  ~ee11030(); // tgen
  ee11030(); // tgen
};
//SIG(1 ee11030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11030 ::~ee11030(){ note_dtor("ee11030", this);} // tgen
ee11030 ::ee11030(){ note_ctor("ee11030", this);} // tgen

static void Test_ee11030()
{
  extern Class_Descriptor cd_ee11030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11030, buf);
    ee11030 *dp, &lv = *(dp=new (buf) ee11030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee11030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee11030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(32,16), "ee11030");
    check_base_class_offset(lv, (dd1030*), ABISELECT(16,8), "ee11030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11030.e");
    test_class_info(&lv, &cd_ee11030);
    dp->~ee11030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11030(Test_ee11030, "ee11030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11030C1Ev();
extern void _ZN7ee11030D1Ev();
Name_Map name_map_ee11030[] = {
  NSPAIR(_ZN7ee11030C1Ev),
  NSPAIR(_ZN7ee11030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee11030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee11030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11030[0]),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11030[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee11030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee11030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee11030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee11030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee11030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee11030[] = {
  {&(_ZTV7ee11030[5]),  5,14},
  {&(_ZTV7ee11030[9]),  9,14},
  {&(_ZTV7ee11030[13]),  13,14},
  {&(_tg__ZTV6dd1030__7ee11030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee11030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee11030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee11030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11030[];
extern  VTBL_ENTRY _ZTV7ee11030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11030[];
Class_Descriptor cd_ee11030 = {  "ee11030", // class name
  bases_ee11030, 4,
  &(vtc_ee11030[0]), // expected_vtbl_contents
  &(vtt_ee11030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11030),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21030  : dd1030 {
  int e;
  virtual void  foo(); // _ZN7ee210303fooEv
  ~ee21030(); // tgen
  ee21030(); // tgen
};
//SIG(1 ee21030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee21030 ::foo(){vfunc_called(this, "_ZN7ee210303fooEv");}
ee21030 ::~ee21030(){ note_dtor("ee21030", this);} // tgen
ee21030 ::ee21030(){ note_ctor("ee21030", this);} // tgen

static void Test_ee21030()
{
  extern Class_Descriptor cd_ee21030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21030, buf);
    ee21030 *dp, &lv = *(dp=new (buf) ee21030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee21030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee21030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(16,12), "ee21030");
    check_base_class_offset(lv, (dd1030*), 0, "ee21030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21030.e");
    test_class_info(&lv, &cd_ee21030);
    dp->~ee21030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21030(Test_ee21030, "ee21030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21030C1Ev();
extern void _ZN7ee21030D1Ev();
Name_Map name_map_ee21030[] = {
  NSPAIR(_ZN7ee21030C1Ev),
  NSPAIR(_ZN7ee21030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee21030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21030[];
extern void _ZN7ee210303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee210303fooEv,_ZTv0_n16_N7ee210303fooEv)();
extern void ABISELECT(_ZThn16_N7ee210303fooEv,_ZThn12_N7ee210303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21030[0]),
  (VTBL_ENTRY)&_ZN7ee210303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee210303fooEv,_ZTv0_n16_N7ee210303fooEv),
};
extern VTBL_ENTRY _ZTV7ee21030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee21030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee21030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee21030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee21030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee21030[] = {
  {&(_ZTV7ee21030[4]),  4,10},
  {&(_tg__ZTV6dd1030__7ee21030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee21030[4]),  4,5},
  {&(_ZTV7ee21030[9]),  9,10},
  {&(_tg__ZTV5cc030__7ee21030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee21030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21030[];
extern  VTBL_ENTRY _ZTV7ee21030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21030[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee210303fooEv,_ZTv0_n16_N7ee210303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee210303fooEv,_ZThn12_N7ee210303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21030 = {  "ee21030", // class name
  bases_ee21030, 4,
  &(vtc_ee21030[0]), // expected_vtbl_contents
  &(vtt_ee21030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31030  : virtual dd1030 {
  int e;
  virtual void  foo(); // _ZN7ee310303fooEv
  ~ee31030(); // tgen
  ee31030(); // tgen
};
//SIG(1 ee31030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee31030 ::foo(){vfunc_called(this, "_ZN7ee310303fooEv");}
ee31030 ::~ee31030(){ note_dtor("ee31030", this);} // tgen
ee31030 ::ee31030(){ note_ctor("ee31030", this);} // tgen

static void Test_ee31030()
{
  extern Class_Descriptor cd_ee31030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31030, buf);
    ee31030 *dp, &lv = *(dp=new (buf) ee31030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee31030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee31030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(32,16), "ee31030");
    check_base_class_offset(lv, (dd1030*), ABISELECT(16,8), "ee31030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31030.e");
    test_class_info(&lv, &cd_ee31030);
    dp->~ee31030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31030(Test_ee31030, "ee31030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31030C1Ev();
extern void _ZN7ee31030D1Ev();
Name_Map name_map_ee31030[] = {
  NSPAIR(_ZN7ee31030C1Ev),
  NSPAIR(_ZN7ee31030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee31030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31030[];
extern void _ZN7ee310303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee310303fooEv,_ZTv0_n16_N7ee310303fooEv)();
extern void ABISELECT(_ZThn32_N7ee310303fooEv,_ZThn16_N7ee310303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31030[0]),
  (VTBL_ENTRY)&_ZN7ee310303fooEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31030[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee310303fooEv,_ZTv0_n16_N7ee310303fooEv),
};
extern VTBL_ENTRY _ZTV7ee31030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee31030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee31030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee31030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee31030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee31030[] = {
  {&(_ZTV7ee31030[5]),  5,15},
  {&(_ZTV7ee31030[10]),  10,15},
  {&(_ZTV7ee31030[14]),  14,15},
  {&(_tg__ZTV6dd1030__7ee31030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee31030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee31030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee31030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31030[];
extern  VTBL_ENTRY _ZTV7ee31030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31030[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee310303fooEv,_ZTv0_n16_N7ee310303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee310303fooEv,_ZThn16_N7ee310303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31030 = {  "ee31030", // class name
  bases_ee31030, 4,
  &(vtc_ee31030[0]), // expected_vtbl_contents
  &(vtt_ee31030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31030),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41030  : dd1030 {
  int e;
  virtual void  bar(); // _ZN7ee410303barEv
  ~ee41030(); // tgen
  ee41030(); // tgen
};
//SIG(1 ee41030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee41030 ::bar(){vfunc_called(this, "_ZN7ee410303barEv");}
ee41030 ::~ee41030(){ note_dtor("ee41030", this);} // tgen
ee41030 ::ee41030(){ note_ctor("ee41030", this);} // tgen

static void Test_ee41030()
{
  extern Class_Descriptor cd_ee41030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41030, buf);
    ee41030 *dp, &lv = *(dp=new (buf) ee41030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee41030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee41030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(16,12), "ee41030");
    check_base_class_offset(lv, (dd1030*), 0, "ee41030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41030.e");
    test_class_info(&lv, &cd_ee41030);
    dp->~ee41030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41030(Test_ee41030, "ee41030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41030C1Ev();
extern void _ZN7ee41030D1Ev();
Name_Map name_map_ee41030[] = {
  NSPAIR(_ZN7ee41030C1Ev),
  NSPAIR(_ZN7ee41030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee41030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41030[];
extern void _ZN7ee410303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee41030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41030[0]),
  (VTBL_ENTRY)&_ZN7ee410303barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee41030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee41030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee41030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee41030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee41030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee41030[] = {
  {&(_ZTV7ee41030[4]),  4,10},
  {&(_tg__ZTV6dd1030__7ee41030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee41030[4]),  4,5},
  {&(_ZTV7ee41030[9]),  9,10},
  {&(_tg__ZTV5cc030__7ee41030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee41030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41030[];
extern  VTBL_ENTRY _ZTV7ee41030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41030[];
Class_Descriptor cd_ee41030 = {  "ee41030", // class name
  bases_ee41030, 4,
  &(vtc_ee41030[0]), // expected_vtbl_contents
  &(vtt_ee41030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51030  : virtual dd1030 {
  int e;
  virtual void  bar(); // _ZN7ee510303barEv
  ~ee51030(); // tgen
  ee51030(); // tgen
};
//SIG(1 ee51030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee51030 ::bar(){vfunc_called(this, "_ZN7ee510303barEv");}
ee51030 ::~ee51030(){ note_dtor("ee51030", this);} // tgen
ee51030 ::ee51030(){ note_ctor("ee51030", this);} // tgen

static void Test_ee51030()
{
  extern Class_Descriptor cd_ee51030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51030, buf);
    ee51030 *dp, &lv = *(dp=new (buf) ee51030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee51030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee51030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(32,16), "ee51030");
    check_base_class_offset(lv, (dd1030*), ABISELECT(16,8), "ee51030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51030.e");
    test_class_info(&lv, &cd_ee51030);
    dp->~ee51030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51030(Test_ee51030, "ee51030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51030C1Ev();
extern void _ZN7ee51030D1Ev();
Name_Map name_map_ee51030[] = {
  NSPAIR(_ZN7ee51030C1Ev),
  NSPAIR(_ZN7ee51030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee51030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51030[];
extern void _ZN7ee510303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee51030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51030[0]),
  (VTBL_ENTRY)&_ZN7ee510303barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51030[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee51030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee51030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee51030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee51030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee51030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee51030[] = {
  {&(_ZTV7ee51030[5]),  5,15},
  {&(_ZTV7ee51030[10]),  10,15},
  {&(_ZTV7ee51030[14]),  14,15},
  {&(_tg__ZTV6dd1030__7ee51030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee51030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee51030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee51030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51030[];
extern  VTBL_ENTRY _ZTV7ee51030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51030[];
Class_Descriptor cd_ee51030 = {  "ee51030", // class name
  bases_ee51030, 4,
  &(vtc_ee51030[0]), // expected_vtbl_contents
  &(vtt_ee51030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51030),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61030  : dd1030 {
  int e;
  virtual void  foo(); // _ZN7ee610303fooEv
  virtual void  bar(); // _ZN7ee610303barEv
  ~ee61030(); // tgen
  ee61030(); // tgen
};
//SIG(1 ee61030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61030 ::foo(){vfunc_called(this, "_ZN7ee610303fooEv");}
void  ee61030 ::bar(){vfunc_called(this, "_ZN7ee610303barEv");}
ee61030 ::~ee61030(){ note_dtor("ee61030", this);} // tgen
ee61030 ::ee61030(){ note_ctor("ee61030", this);} // tgen

static void Test_ee61030()
{
  extern Class_Descriptor cd_ee61030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61030, buf);
    ee61030 *dp, &lv = *(dp=new (buf) ee61030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee61030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee61030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(16,12), "ee61030");
    check_base_class_offset(lv, (dd1030*), 0, "ee61030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61030.e");
    test_class_info(&lv, &cd_ee61030);
    dp->~ee61030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61030(Test_ee61030, "ee61030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61030C1Ev();
extern void _ZN7ee61030D1Ev();
Name_Map name_map_ee61030[] = {
  NSPAIR(_ZN7ee61030C1Ev),
  NSPAIR(_ZN7ee61030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee61030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61030[];
extern void _ZN7ee610303fooEv();
extern void _ZN7ee610303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee610303fooEv,_ZTv0_n16_N7ee610303fooEv)();
extern void ABISELECT(_ZThn16_N7ee610303fooEv,_ZThn12_N7ee610303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61030[0]),
  (VTBL_ENTRY)&_ZN7ee610303fooEv,
  (VTBL_ENTRY)&_ZN7ee610303barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee610303fooEv,_ZTv0_n16_N7ee610303fooEv),
};
extern VTBL_ENTRY _ZTV7ee61030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee61030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee61030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee61030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee61030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee61030[] = {
  {&(_ZTV7ee61030[4]),  4,11},
  {&(_tg__ZTV6dd1030__7ee61030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee61030[4]),  4,5},
  {&(_ZTV7ee61030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee61030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee61030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61030[];
extern  VTBL_ENTRY _ZTV7ee61030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61030[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee610303fooEv,_ZTv0_n16_N7ee610303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610303fooEv,_ZThn12_N7ee610303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61030 = {  "ee61030", // class name
  bases_ee61030, 4,
  &(vtc_ee61030[0]), // expected_vtbl_contents
  &(vtt_ee61030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71030  : virtual dd1030 {
  int e;
  virtual void  foo(); // _ZN7ee710303fooEv
  virtual void  bar(); // _ZN7ee710303barEv
  ~ee71030(); // tgen
  ee71030(); // tgen
};
//SIG(1 ee71030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71030 ::foo(){vfunc_called(this, "_ZN7ee710303fooEv");}
void  ee71030 ::bar(){vfunc_called(this, "_ZN7ee710303barEv");}
ee71030 ::~ee71030(){ note_dtor("ee71030", this);} // tgen
ee71030 ::ee71030(){ note_ctor("ee71030", this);} // tgen

static void Test_ee71030()
{
  extern Class_Descriptor cd_ee71030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71030, buf);
    ee71030 *dp, &lv = *(dp=new (buf) ee71030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee71030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee71030");
    check_base_class_offset(lv, (cc030*)(dd1030*), ABISELECT(32,16), "ee71030");
    check_base_class_offset(lv, (dd1030*), ABISELECT(16,8), "ee71030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71030.e");
    test_class_info(&lv, &cd_ee71030);
    dp->~ee71030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71030(Test_ee71030, "ee71030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71030C1Ev();
extern void _ZN7ee71030D1Ev();
Name_Map name_map_ee71030[] = {
  NSPAIR(_ZN7ee71030C1Ev),
  NSPAIR(_ZN7ee71030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd1030;
extern VTBL_ENTRY _ZTI6dd1030[];
extern  VTBL_ENTRY _ZTV6dd1030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1030[];
static Base_Class bases_ee71030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1030,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71030[];
extern void _ZN7ee710303fooEv();
extern void _ZN7ee710303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee710303fooEv,_ZTv0_n16_N7ee710303fooEv)();
extern void ABISELECT(_ZThn32_N7ee710303fooEv,_ZThn16_N7ee710303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71030[0]),
  (VTBL_ENTRY)&_ZN7ee710303fooEv,
  (VTBL_ENTRY)&_ZN7ee710303barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71030[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee710303fooEv,_ZTv0_n16_N7ee710303fooEv),
};
extern VTBL_ENTRY _ZTV7ee71030[];
static  VTBL_ENTRY _tg__ZTV6dd1030__7ee71030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd1030__7ee71030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee71030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee71030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee71030[] = {
  {&(_ZTV7ee71030[5]),  5,16},
  {&(_ZTV7ee71030[11]),  11,16},
  {&(_ZTV7ee71030[15]),  15,16},
  {&(_tg__ZTV6dd1030__7ee71030[4]),  4,4},
  {&(_tg__ZTV5cc030__6dd1030__7ee71030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee71030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee71030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71030[];
extern  VTBL_ENTRY _ZTV7ee71030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71030[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee710303fooEv,_ZTv0_n16_N7ee710303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710303fooEv,_ZThn16_N7ee710303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71030 = {  "ee71030", // class name
  bases_ee71030, 4,
  &(vtc_ee71030[0]), // expected_vtbl_contents
  &(vtt_ee71030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71030),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2030  : cc030 {
  int d;
  virtual void  foo(); // _ZN6dd20303fooEv
  ~dd2030(); // tgen
  dd2030(); // tgen
};
//SIG(-1 dd2030) C1{ BC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd2030 ::foo(){vfunc_called(this, "_ZN6dd20303fooEv");}
dd2030 ::~dd2030(){ note_dtor("dd2030", this);} // tgen
dd2030 ::dd2030(){ note_ctor("dd2030", this);} // tgen

static void Test_dd2030()
{
  extern Class_Descriptor cd_dd2030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2030, buf);
    dd2030 *dp, &lv = *(dp=new (buf) dd2030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(20,16), "dd2030");
    check_base_class_offset(lv, (bb30*)(cc030*), 0, "dd2030");
    check_base_class_offset(lv, (cc030*), 0, "dd2030");
    check_field_offset(lv, d, ABISELECT(16,12), "dd2030.d");
    test_class_info(&lv, &cd_dd2030);
    dp->~dd2030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2030(Test_dd2030, "dd2030", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2030C1Ev();
extern void _ZN6dd2030D1Ev();
Name_Map name_map_dd2030[] = {
  NSPAIR(_ZN6dd2030C1Ev),
  NSPAIR(_ZN6dd2030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd2030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY vtc_dd2030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern VTBL_ENTRY _ZTV6dd2030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd2030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd2030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd2030[] = {
  {&(_ZTV6dd2030[3]),  3,4},
  {&(_tg__ZTV5cc030__6dd2030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd2030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
Class_Descriptor cd_dd2030 = {  "dd2030", // class name
  bases_dd2030, 3,
  &(vtc_dd2030[0]), // expected_vtbl_contents
  &(vtt_dd2030[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2030),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2030),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02030  : dd2030 {
  int e;
  ~ee02030(); // tgen
  ee02030(); // tgen
};
//SIG(1 ee02030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee02030 ::~ee02030(){ note_dtor("ee02030", this);} // tgen
ee02030 ::ee02030(){ note_ctor("ee02030", this);} // tgen

static void Test_ee02030()
{
  extern Class_Descriptor cd_ee02030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02030, buf);
    ee02030 *dp, &lv = *(dp=new (buf) ee02030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(24,20), "ee02030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), 0, "ee02030");
    check_base_class_offset(lv, (cc030*)(dd2030*), 0, "ee02030");
    check_base_class_offset(lv, (dd2030*), 0, "ee02030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee02030.e");
    test_class_info(&lv, &cd_ee02030);
    dp->~ee02030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02030(Test_ee02030, "ee02030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02030C1Ev();
extern void _ZN7ee02030D1Ev();
Name_Map name_map_ee02030[] = {
  NSPAIR(_ZN7ee02030C1Ev),
  NSPAIR(_ZN7ee02030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee02030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY vtc_ee02030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern VTBL_ENTRY _ZTV7ee02030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee02030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee02030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee02030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee02030[] = {
  {&(_ZTV7ee02030[3]),  3,4},
  {&(_tg__ZTV6dd2030__7ee02030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee02030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee02030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee02030[];
extern  VTBL_ENTRY _ZTV7ee02030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02030[];
Class_Descriptor cd_ee02030 = {  "ee02030", // class name
  bases_ee02030, 4,
  &(vtc_ee02030[0]), // expected_vtbl_contents
  &(vtt_ee02030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02030),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12030  : virtual dd2030 {
  int e;
  ~ee12030(); // tgen
  ee12030(); // tgen
};
//SIG(1 ee12030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee12030 ::~ee12030(){ note_dtor("ee12030", this);} // tgen
ee12030 ::ee12030(){ note_ctor("ee12030", this);} // tgen

static void Test_ee12030()
{
  extern Class_Descriptor cd_ee12030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12030, buf);
    ee12030 *dp, &lv = *(dp=new (buf) ee12030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(36,24), "ee12030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), ABISELECT(16,8), "ee12030");
    check_base_class_offset(lv, (cc030*)(dd2030*), ABISELECT(16,8), "ee12030");
    check_base_class_offset(lv, (dd2030*), ABISELECT(16,8), "ee12030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12030.e");
    test_class_info(&lv, &cd_ee12030);
    dp->~ee12030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12030(Test_ee12030, "ee12030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12030C1Ev();
extern void _ZN7ee12030D1Ev();
Name_Map name_map_ee12030[] = {
  NSPAIR(_ZN7ee12030C1Ev),
  NSPAIR(_ZN7ee12030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee12030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY vtc_ee12030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12030[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern VTBL_ENTRY _ZTV7ee12030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee12030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee12030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee12030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee12030[] = {
  {&(_ZTV7ee12030[4]),  4,9},
  {&(_ZTV7ee12030[8]),  8,9},
  {&(_tg__ZTV6dd2030__7ee12030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee12030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee12030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee12030[];
extern  VTBL_ENTRY _ZTV7ee12030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12030[];
Class_Descriptor cd_ee12030 = {  "ee12030", // class name
  bases_ee12030, 4,
  &(vtc_ee12030[0]), // expected_vtbl_contents
  &(vtt_ee12030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12030),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22030  : dd2030 {
  int e;
  virtual void  foo(); // _ZN7ee220303fooEv
  ~ee22030(); // tgen
  ee22030(); // tgen
};
//SIG(1 ee22030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22030 ::foo(){vfunc_called(this, "_ZN7ee220303fooEv");}
ee22030 ::~ee22030(){ note_dtor("ee22030", this);} // tgen
ee22030 ::ee22030(){ note_ctor("ee22030", this);} // tgen

static void Test_ee22030()
{
  extern Class_Descriptor cd_ee22030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22030, buf);
    ee22030 *dp, &lv = *(dp=new (buf) ee22030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(24,20), "ee22030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), 0, "ee22030");
    check_base_class_offset(lv, (cc030*)(dd2030*), 0, "ee22030");
    check_base_class_offset(lv, (dd2030*), 0, "ee22030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee22030.e");
    test_class_info(&lv, &cd_ee22030);
    dp->~ee22030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22030(Test_ee22030, "ee22030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22030C1Ev();
extern void _ZN7ee22030D1Ev();
Name_Map name_map_ee22030[] = {
  NSPAIR(_ZN7ee22030C1Ev),
  NSPAIR(_ZN7ee22030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee22030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22030[];
extern void _ZN7ee220303fooEv();
static  VTBL_ENTRY vtc_ee22030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22030[0]),
  (VTBL_ENTRY)&_ZN7ee220303fooEv,
};
extern VTBL_ENTRY _ZTV7ee22030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee22030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee22030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee22030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee22030[] = {
  {&(_ZTV7ee22030[3]),  3,4},
  {&(_tg__ZTV6dd2030__7ee22030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee22030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee22030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee22030[];
extern  VTBL_ENTRY _ZTV7ee22030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22030[];
Class_Descriptor cd_ee22030 = {  "ee22030", // class name
  bases_ee22030, 4,
  &(vtc_ee22030[0]), // expected_vtbl_contents
  &(vtt_ee22030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22030),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32030  : virtual dd2030 {
  int e;
  virtual void  foo(); // _ZN7ee320303fooEv
  ~ee32030(); // tgen
  ee32030(); // tgen
};
//SIG(1 ee32030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32030 ::foo(){vfunc_called(this, "_ZN7ee320303fooEv");}
ee32030 ::~ee32030(){ note_dtor("ee32030", this);} // tgen
ee32030 ::ee32030(){ note_ctor("ee32030", this);} // tgen

static void Test_ee32030()
{
  extern Class_Descriptor cd_ee32030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32030, buf);
    ee32030 *dp, &lv = *(dp=new (buf) ee32030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(36,24), "ee32030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), ABISELECT(16,8), "ee32030");
    check_base_class_offset(lv, (cc030*)(dd2030*), ABISELECT(16,8), "ee32030");
    check_base_class_offset(lv, (dd2030*), ABISELECT(16,8), "ee32030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32030.e");
    test_class_info(&lv, &cd_ee32030);
    dp->~ee32030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32030(Test_ee32030, "ee32030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32030C1Ev();
extern void _ZN7ee32030D1Ev();
Name_Map name_map_ee32030[] = {
  NSPAIR(_ZN7ee32030C1Ev),
  NSPAIR(_ZN7ee32030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee32030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32030[];
extern void _ZN7ee320303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee320303fooEv,_ZTv0_n16_N7ee320303fooEv)();
extern void ABISELECT(_ZThn16_N7ee320303fooEv,_ZThn8_N7ee320303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32030[0]),
  (VTBL_ENTRY)&_ZN7ee320303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee320303fooEv,_ZTv0_n16_N7ee320303fooEv),
};
extern VTBL_ENTRY _ZTV7ee32030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee32030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee32030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee32030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee32030[] = {
  {&(_ZTV7ee32030[4]),  4,10},
  {&(_ZTV7ee32030[9]),  9,10},
  {&(_tg__ZTV6dd2030__7ee32030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee32030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee32030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee32030[];
extern  VTBL_ENTRY _ZTV7ee32030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32030[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee320303fooEv,_ZTv0_n16_N7ee320303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320303fooEv,_ZThn8_N7ee320303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32030 = {  "ee32030", // class name
  bases_ee32030, 4,
  &(vtc_ee32030[0]), // expected_vtbl_contents
  &(vtt_ee32030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42030  : dd2030 {
  int e;
  virtual void  bar(); // _ZN7ee420303barEv
  ~ee42030(); // tgen
  ee42030(); // tgen
};
//SIG(1 ee42030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42030 ::bar(){vfunc_called(this, "_ZN7ee420303barEv");}
ee42030 ::~ee42030(){ note_dtor("ee42030", this);} // tgen
ee42030 ::ee42030(){ note_ctor("ee42030", this);} // tgen

static void Test_ee42030()
{
  extern Class_Descriptor cd_ee42030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42030, buf);
    ee42030 *dp, &lv = *(dp=new (buf) ee42030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(24,20), "ee42030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), 0, "ee42030");
    check_base_class_offset(lv, (cc030*)(dd2030*), 0, "ee42030");
    check_base_class_offset(lv, (dd2030*), 0, "ee42030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee42030.e");
    test_class_info(&lv, &cd_ee42030);
    dp->~ee42030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42030(Test_ee42030, "ee42030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42030C1Ev();
extern void _ZN7ee42030D1Ev();
Name_Map name_map_ee42030[] = {
  NSPAIR(_ZN7ee42030C1Ev),
  NSPAIR(_ZN7ee42030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee42030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42030[];
extern void _ZN6dd20303fooEv();
extern void _ZN7ee420303barEv();
static  VTBL_ENTRY vtc_ee42030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
  (VTBL_ENTRY)&_ZN7ee420303barEv,
};
extern VTBL_ENTRY _ZTV7ee42030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee42030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee42030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee42030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee42030[] = {
  {&(_ZTV7ee42030[3]),  3,5},
  {&(_tg__ZTV6dd2030__7ee42030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee42030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee42030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee42030[];
extern  VTBL_ENTRY _ZTV7ee42030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42030[];
Class_Descriptor cd_ee42030 = {  "ee42030", // class name
  bases_ee42030, 4,
  &(vtc_ee42030[0]), // expected_vtbl_contents
  &(vtt_ee42030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52030  : virtual dd2030 {
  int e;
  virtual void  bar(); // _ZN7ee520303barEv
  ~ee52030(); // tgen
  ee52030(); // tgen
};
//SIG(1 ee52030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52030 ::bar(){vfunc_called(this, "_ZN7ee520303barEv");}
ee52030 ::~ee52030(){ note_dtor("ee52030", this);} // tgen
ee52030 ::ee52030(){ note_ctor("ee52030", this);} // tgen

static void Test_ee52030()
{
  extern Class_Descriptor cd_ee52030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52030, buf);
    ee52030 *dp, &lv = *(dp=new (buf) ee52030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(36,24), "ee52030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), ABISELECT(16,8), "ee52030");
    check_base_class_offset(lv, (cc030*)(dd2030*), ABISELECT(16,8), "ee52030");
    check_base_class_offset(lv, (dd2030*), ABISELECT(16,8), "ee52030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52030.e");
    test_class_info(&lv, &cd_ee52030);
    dp->~ee52030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52030(Test_ee52030, "ee52030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52030C1Ev();
extern void _ZN7ee52030D1Ev();
Name_Map name_map_ee52030[] = {
  NSPAIR(_ZN7ee52030C1Ev),
  NSPAIR(_ZN7ee52030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee52030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52030[];
extern void _ZN7ee520303barEv();
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY vtc_ee52030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52030[0]),
  (VTBL_ENTRY)&_ZN7ee520303barEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern VTBL_ENTRY _ZTV7ee52030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee52030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee52030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee52030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee52030[] = {
  {&(_ZTV7ee52030[4]),  4,10},
  {&(_ZTV7ee52030[9]),  9,10},
  {&(_tg__ZTV6dd2030__7ee52030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee52030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee52030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee52030[];
extern  VTBL_ENTRY _ZTV7ee52030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52030[];
Class_Descriptor cd_ee52030 = {  "ee52030", // class name
  bases_ee52030, 4,
  &(vtc_ee52030[0]), // expected_vtbl_contents
  &(vtt_ee52030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62030  : dd2030 {
  int e;
  virtual void  foo(); // _ZN7ee620303fooEv
  virtual void  bar(); // _ZN7ee620303barEv
  ~ee62030(); // tgen
  ee62030(); // tgen
};
//SIG(1 ee62030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62030 ::foo(){vfunc_called(this, "_ZN7ee620303fooEv");}
void  ee62030 ::bar(){vfunc_called(this, "_ZN7ee620303barEv");}
ee62030 ::~ee62030(){ note_dtor("ee62030", this);} // tgen
ee62030 ::ee62030(){ note_ctor("ee62030", this);} // tgen

static void Test_ee62030()
{
  extern Class_Descriptor cd_ee62030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62030, buf);
    ee62030 *dp, &lv = *(dp=new (buf) ee62030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(24,20), "ee62030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), 0, "ee62030");
    check_base_class_offset(lv, (cc030*)(dd2030*), 0, "ee62030");
    check_base_class_offset(lv, (dd2030*), 0, "ee62030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee62030.e");
    test_class_info(&lv, &cd_ee62030);
    dp->~ee62030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62030(Test_ee62030, "ee62030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62030C1Ev();
extern void _ZN7ee62030D1Ev();
Name_Map name_map_ee62030[] = {
  NSPAIR(_ZN7ee62030C1Ev),
  NSPAIR(_ZN7ee62030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee62030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62030[];
extern void _ZN7ee620303fooEv();
extern void _ZN7ee620303barEv();
static  VTBL_ENTRY vtc_ee62030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62030[0]),
  (VTBL_ENTRY)&_ZN7ee620303fooEv,
  (VTBL_ENTRY)&_ZN7ee620303barEv,
};
extern VTBL_ENTRY _ZTV7ee62030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee62030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee62030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee62030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee62030[] = {
  {&(_ZTV7ee62030[3]),  3,5},
  {&(_tg__ZTV6dd2030__7ee62030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee62030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee62030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee62030[];
extern  VTBL_ENTRY _ZTV7ee62030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62030[];
Class_Descriptor cd_ee62030 = {  "ee62030", // class name
  bases_ee62030, 4,
  &(vtc_ee62030[0]), // expected_vtbl_contents
  &(vtt_ee62030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72030  : virtual dd2030 {
  int e;
  virtual void  foo(); // _ZN7ee720303fooEv
  virtual void  bar(); // _ZN7ee720303barEv
  ~ee72030(); // tgen
  ee72030(); // tgen
};
//SIG(1 ee72030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72030 ::foo(){vfunc_called(this, "_ZN7ee720303fooEv");}
void  ee72030 ::bar(){vfunc_called(this, "_ZN7ee720303barEv");}
ee72030 ::~ee72030(){ note_dtor("ee72030", this);} // tgen
ee72030 ::ee72030(){ note_ctor("ee72030", this);} // tgen

static void Test_ee72030()
{
  extern Class_Descriptor cd_ee72030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72030, buf);
    ee72030 *dp, &lv = *(dp=new (buf) ee72030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd2030*), ABISELECT(36,24), "ee72030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd2030*), ABISELECT(16,8), "ee72030");
    check_base_class_offset(lv, (cc030*)(dd2030*), ABISELECT(16,8), "ee72030");
    check_base_class_offset(lv, (dd2030*), ABISELECT(16,8), "ee72030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72030.e");
    test_class_info(&lv, &cd_ee72030);
    dp->~ee72030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72030(Test_ee72030, "ee72030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72030C1Ev();
extern void _ZN7ee72030D1Ev();
Name_Map name_map_ee72030[] = {
  NSPAIR(_ZN7ee72030C1Ev),
  NSPAIR(_ZN7ee72030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd2030;
extern VTBL_ENTRY _ZTI6dd2030[];
extern  VTBL_ENTRY _ZTV6dd2030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2030[];
static Base_Class bases_ee72030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72030[];
extern void _ZN7ee720303fooEv();
extern void _ZN7ee720303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee720303fooEv,_ZTv0_n16_N7ee720303fooEv)();
extern void ABISELECT(_ZThn16_N7ee720303fooEv,_ZThn8_N7ee720303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72030[0]),
  (VTBL_ENTRY)&_ZN7ee720303fooEv,
  (VTBL_ENTRY)&_ZN7ee720303barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee720303fooEv,_ZTv0_n16_N7ee720303fooEv),
};
extern VTBL_ENTRY _ZTV7ee72030[];
extern void _ZN6dd20303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2030__7ee72030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2030[0]),
  (VTBL_ENTRY)&_ZN6dd20303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd2030__7ee72030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd2030__7ee72030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee72030[] = {
  {&(_ZTV7ee72030[4]),  4,11},
  {&(_ZTV7ee72030[10]),  10,11},
  {&(_tg__ZTV6dd2030__7ee72030[3]),  3,4},
  {&(_tg__ZTV5cc0306dd2030__7ee72030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd2030__7ee72030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee72030[];
extern  VTBL_ENTRY _ZTV7ee72030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72030[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee720303fooEv,_ZTv0_n16_N7ee720303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720303fooEv,_ZThn8_N7ee720303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72030 = {  "ee72030", // class name
  bases_ee72030, 4,
  &(vtc_ee72030[0]), // expected_vtbl_contents
  &(vtt_ee72030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3030  : virtual cc030 {
  int d;
  virtual void  foo(); // _ZN6dd30303fooEv
  ~dd3030(); // tgen
  dd3030(); // tgen
};
//SIG(-1 dd3030) C1{ VBC2{ BC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd3030 ::foo(){vfunc_called(this, "_ZN6dd30303fooEv");}
dd3030 ::~dd3030(){ note_dtor("dd3030", this);} // tgen
dd3030 ::dd3030(){ note_ctor("dd3030", this);} // tgen

static void Test_dd3030()
{
  extern Class_Descriptor cd_dd3030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3030, buf);
    dd3030 *dp, &lv = *(dp=new (buf) dd3030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,20), "dd3030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,8), "dd3030");
    check_base_class_offset(lv, (cc030*), ABISELECT(16,8), "dd3030");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3030.d");
    test_class_info(&lv, &cd_dd3030);
    dp->~dd3030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3030(Test_dd3030, "dd3030", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3030C1Ev();
extern void _ZN6dd3030D1Ev();
Name_Map name_map_dd3030[] = {
  NSPAIR(_ZN6dd3030C1Ev),
  NSPAIR(_ZN6dd3030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd3030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3030[];
extern void _ZN6dd30303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern VTBL_ENTRY _ZTV6dd3030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd3030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd3030[] = {
  {&(_ZTV6dd3030[4]),  4,10},
  {&(_ZTV6dd3030[9]),  9,10},
  {&(_tg__ZTV5cc030__6dd3030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd3030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3030 = {  "dd3030", // class name
  bases_dd3030, 3,
  &(vtc_dd3030[0]), // expected_vtbl_contents
  &(vtt_dd3030[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3030),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03030  : dd3030 {
  int e;
  ~ee03030(); // tgen
  ee03030(); // tgen
};
//SIG(1 ee03030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee03030 ::~ee03030(){ note_dtor("ee03030", this);} // tgen
ee03030 ::ee03030(){ note_ctor("ee03030", this);} // tgen

static void Test_ee03030()
{
  extern Class_Descriptor cd_ee03030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03030, buf);
    ee03030 *dp, &lv = *(dp=new (buf) ee03030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee03030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee03030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(16,12), "ee03030");
    check_base_class_offset(lv, (dd3030*), 0, "ee03030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03030.e");
    test_class_info(&lv, &cd_ee03030);
    dp->~ee03030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03030(Test_ee03030, "ee03030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03030C1Ev();
extern void _ZN7ee03030D1Ev();
Name_Map name_map_ee03030[] = {
  NSPAIR(_ZN7ee03030C1Ev),
  NSPAIR(_ZN7ee03030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee03030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03030[];
extern void _ZN6dd30303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern VTBL_ENTRY _ZTV7ee03030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee03030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee03030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee03030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee03030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee03030[] = {
  {&(_ZTV7ee03030[4]),  4,10},
  {&(_tg__ZTV6dd3030__7ee03030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee03030[4]),  4,5},
  {&(_ZTV7ee03030[9]),  9,10},
  {&(_tg__ZTV5cc030__7ee03030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee03030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee03030[];
extern  VTBL_ENTRY _ZTV7ee03030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03030[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03030 = {  "ee03030", // class name
  bases_ee03030, 4,
  &(vtc_ee03030[0]), // expected_vtbl_contents
  &(vtt_ee03030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13030  : virtual dd3030 {
  int e;
  ~ee13030(); // tgen
  ee13030(); // tgen
};
//SIG(1 ee13030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee13030 ::~ee13030(){ note_dtor("ee13030", this);} // tgen
ee13030 ::ee13030(){ note_ctor("ee13030", this);} // tgen

static void Test_ee13030()
{
  extern Class_Descriptor cd_ee13030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13030, buf);
    ee13030 *dp, &lv = *(dp=new (buf) ee13030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee13030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee13030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(32,16), "ee13030");
    check_base_class_offset(lv, (dd3030*), ABISELECT(16,8), "ee13030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13030.e");
    test_class_info(&lv, &cd_ee13030);
    dp->~ee13030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13030(Test_ee13030, "ee13030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13030C1Ev();
extern void _ZN7ee13030D1Ev();
Name_Map name_map_ee13030[] = {
  NSPAIR(_ZN7ee13030C1Ev),
  NSPAIR(_ZN7ee13030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee13030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13030[];
extern void _ZN6dd30303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13030[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern VTBL_ENTRY _ZTV7ee13030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee13030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee13030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee13030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee13030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee13030[] = {
  {&(_ZTV7ee13030[5]),  5,16},
  {&(_ZTV7ee13030[10]),  10,16},
  {&(_ZTV7ee13030[15]),  15,16},
  {&(_tg__ZTV6dd3030__7ee13030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee13030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee13030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee13030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13030[];
extern  VTBL_ENTRY _ZTV7ee13030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13030[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13030 = {  "ee13030", // class name
  bases_ee13030, 4,
  &(vtc_ee13030[0]), // expected_vtbl_contents
  &(vtt_ee13030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13030),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23030  : dd3030 {
  int e;
  virtual void  foo(); // _ZN7ee230303fooEv
  ~ee23030(); // tgen
  ee23030(); // tgen
};
//SIG(1 ee23030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23030 ::foo(){vfunc_called(this, "_ZN7ee230303fooEv");}
ee23030 ::~ee23030(){ note_dtor("ee23030", this);} // tgen
ee23030 ::ee23030(){ note_ctor("ee23030", this);} // tgen

static void Test_ee23030()
{
  extern Class_Descriptor cd_ee23030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23030, buf);
    ee23030 *dp, &lv = *(dp=new (buf) ee23030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee23030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee23030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(16,12), "ee23030");
    check_base_class_offset(lv, (dd3030*), 0, "ee23030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23030.e");
    test_class_info(&lv, &cd_ee23030);
    dp->~ee23030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23030(Test_ee23030, "ee23030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23030C1Ev();
extern void _ZN7ee23030D1Ev();
Name_Map name_map_ee23030[] = {
  NSPAIR(_ZN7ee23030C1Ev),
  NSPAIR(_ZN7ee23030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee23030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23030[];
extern void _ZN7ee230303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee230303fooEv,_ZTv0_n16_N7ee230303fooEv)();
extern void ABISELECT(_ZThn16_N7ee230303fooEv,_ZThn12_N7ee230303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23030[0]),
  (VTBL_ENTRY)&_ZN7ee230303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee230303fooEv,_ZTv0_n16_N7ee230303fooEv),
};
extern VTBL_ENTRY _ZTV7ee23030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee23030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee23030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee23030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee23030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee23030[] = {
  {&(_ZTV7ee23030[4]),  4,10},
  {&(_tg__ZTV6dd3030__7ee23030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee23030[4]),  4,5},
  {&(_ZTV7ee23030[9]),  9,10},
  {&(_tg__ZTV5cc030__7ee23030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee23030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee23030[];
extern  VTBL_ENTRY _ZTV7ee23030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23030[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee230303fooEv,_ZTv0_n16_N7ee230303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee230303fooEv,_ZThn12_N7ee230303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23030 = {  "ee23030", // class name
  bases_ee23030, 4,
  &(vtc_ee23030[0]), // expected_vtbl_contents
  &(vtt_ee23030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33030  : virtual dd3030 {
  int e;
  virtual void  foo(); // _ZN7ee330303fooEv
  ~ee33030(); // tgen
  ee33030(); // tgen
};
//SIG(1 ee33030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33030 ::foo(){vfunc_called(this, "_ZN7ee330303fooEv");}
ee33030 ::~ee33030(){ note_dtor("ee33030", this);} // tgen
ee33030 ::ee33030(){ note_ctor("ee33030", this);} // tgen

static void Test_ee33030()
{
  extern Class_Descriptor cd_ee33030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33030, buf);
    ee33030 *dp, &lv = *(dp=new (buf) ee33030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee33030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee33030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(32,16), "ee33030");
    check_base_class_offset(lv, (dd3030*), ABISELECT(16,8), "ee33030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33030.e");
    test_class_info(&lv, &cd_ee33030);
    dp->~ee33030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33030(Test_ee33030, "ee33030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33030C1Ev();
extern void _ZN7ee33030D1Ev();
Name_Map name_map_ee33030[] = {
  NSPAIR(_ZN7ee33030C1Ev),
  NSPAIR(_ZN7ee33030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee33030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33030[];
extern void _ZN7ee330303fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee330303fooEv,_ZTv0_n20_N7ee330303fooEv)();
extern void ABISELECT(_ZThn16_N7ee330303fooEv,_ZThn8_N7ee330303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee330303fooEv,_ZTv0_n16_N7ee330303fooEv)();
extern void ABISELECT(_ZThn32_N7ee330303fooEv,_ZThn16_N7ee330303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33030[0]),
  (VTBL_ENTRY)&_ZN7ee330303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee330303fooEv,_ZTv0_n20_N7ee330303fooEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee330303fooEv,_ZTv0_n16_N7ee330303fooEv),
};
extern VTBL_ENTRY _ZTV7ee33030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee33030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee33030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee33030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee33030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee33030[] = {
  {&(_ZTV7ee33030[5]),  5,17},
  {&(_ZTV7ee33030[11]),  11,17},
  {&(_ZTV7ee33030[16]),  16,17},
  {&(_tg__ZTV6dd3030__7ee33030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee33030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee33030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee33030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33030[];
extern  VTBL_ENTRY _ZTV7ee33030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33030[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee330303fooEv,_ZTv0_n16_N7ee330303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee330303fooEv,_ZThn16_N7ee330303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee330303fooEv,_ZTv0_n20_N7ee330303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330303fooEv,_ZThn8_N7ee330303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33030 = {  "ee33030", // class name
  bases_ee33030, 4,
  &(vtc_ee33030[0]), // expected_vtbl_contents
  &(vtt_ee33030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33030),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43030  : dd3030 {
  int e;
  virtual void  bar(); // _ZN7ee430303barEv
  ~ee43030(); // tgen
  ee43030(); // tgen
};
//SIG(1 ee43030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43030 ::bar(){vfunc_called(this, "_ZN7ee430303barEv");}
ee43030 ::~ee43030(){ note_dtor("ee43030", this);} // tgen
ee43030 ::ee43030(){ note_ctor("ee43030", this);} // tgen

static void Test_ee43030()
{
  extern Class_Descriptor cd_ee43030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43030, buf);
    ee43030 *dp, &lv = *(dp=new (buf) ee43030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee43030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee43030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(16,12), "ee43030");
    check_base_class_offset(lv, (dd3030*), 0, "ee43030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43030.e");
    test_class_info(&lv, &cd_ee43030);
    dp->~ee43030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43030(Test_ee43030, "ee43030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43030C1Ev();
extern void _ZN7ee43030D1Ev();
Name_Map name_map_ee43030[] = {
  NSPAIR(_ZN7ee43030C1Ev),
  NSPAIR(_ZN7ee43030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee43030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43030[];
extern void _ZN6dd30303fooEv();
extern void _ZN7ee430303barEv();
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
  (VTBL_ENTRY)&_ZN7ee430303barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern VTBL_ENTRY _ZTV7ee43030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee43030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee43030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee43030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee43030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee43030[] = {
  {&(_ZTV7ee43030[4]),  4,11},
  {&(_tg__ZTV6dd3030__7ee43030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee43030[4]),  4,5},
  {&(_ZTV7ee43030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee43030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee43030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee43030[];
extern  VTBL_ENTRY _ZTV7ee43030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43030[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43030 = {  "ee43030", // class name
  bases_ee43030, 4,
  &(vtc_ee43030[0]), // expected_vtbl_contents
  &(vtt_ee43030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53030  : virtual dd3030 {
  int e;
  virtual void  bar(); // _ZN7ee530303barEv
  ~ee53030(); // tgen
  ee53030(); // tgen
};
//SIG(1 ee53030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53030 ::bar(){vfunc_called(this, "_ZN7ee530303barEv");}
ee53030 ::~ee53030(){ note_dtor("ee53030", this);} // tgen
ee53030 ::ee53030(){ note_ctor("ee53030", this);} // tgen

static void Test_ee53030()
{
  extern Class_Descriptor cd_ee53030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53030, buf);
    ee53030 *dp, &lv = *(dp=new (buf) ee53030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee53030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee53030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(32,16), "ee53030");
    check_base_class_offset(lv, (dd3030*), ABISELECT(16,8), "ee53030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53030.e");
    test_class_info(&lv, &cd_ee53030);
    dp->~ee53030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53030(Test_ee53030, "ee53030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53030C1Ev();
extern void _ZN7ee53030D1Ev();
Name_Map name_map_ee53030[] = {
  NSPAIR(_ZN7ee53030C1Ev),
  NSPAIR(_ZN7ee53030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee53030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53030[];
extern void _ZN7ee530303barEv();
extern void _ZN6dd30303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53030[0]),
  (VTBL_ENTRY)&_ZN7ee530303barEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern VTBL_ENTRY _ZTV7ee53030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee53030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee53030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee53030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee53030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee53030[] = {
  {&(_ZTV7ee53030[5]),  5,17},
  {&(_ZTV7ee53030[11]),  11,17},
  {&(_ZTV7ee53030[16]),  16,17},
  {&(_tg__ZTV6dd3030__7ee53030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee53030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee53030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee53030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53030[];
extern  VTBL_ENTRY _ZTV7ee53030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53030[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53030 = {  "ee53030", // class name
  bases_ee53030, 4,
  &(vtc_ee53030[0]), // expected_vtbl_contents
  &(vtt_ee53030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53030),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63030  : dd3030 {
  int e;
  virtual void  foo(); // _ZN7ee630303fooEv
  virtual void  bar(); // _ZN7ee630303barEv
  ~ee63030(); // tgen
  ee63030(); // tgen
};
//SIG(1 ee63030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63030 ::foo(){vfunc_called(this, "_ZN7ee630303fooEv");}
void  ee63030 ::bar(){vfunc_called(this, "_ZN7ee630303barEv");}
ee63030 ::~ee63030(){ note_dtor("ee63030", this);} // tgen
ee63030 ::ee63030(){ note_ctor("ee63030", this);} // tgen

static void Test_ee63030()
{
  extern Class_Descriptor cd_ee63030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63030, buf);
    ee63030 *dp, &lv = *(dp=new (buf) ee63030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee63030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee63030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(16,12), "ee63030");
    check_base_class_offset(lv, (dd3030*), 0, "ee63030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63030.e");
    test_class_info(&lv, &cd_ee63030);
    dp->~ee63030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63030(Test_ee63030, "ee63030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63030C1Ev();
extern void _ZN7ee63030D1Ev();
Name_Map name_map_ee63030[] = {
  NSPAIR(_ZN7ee63030C1Ev),
  NSPAIR(_ZN7ee63030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee63030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63030[];
extern void _ZN7ee630303fooEv();
extern void _ZN7ee630303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee630303fooEv,_ZTv0_n16_N7ee630303fooEv)();
extern void ABISELECT(_ZThn16_N7ee630303fooEv,_ZThn12_N7ee630303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63030[0]),
  (VTBL_ENTRY)&_ZN7ee630303fooEv,
  (VTBL_ENTRY)&_ZN7ee630303barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee630303fooEv,_ZTv0_n16_N7ee630303fooEv),
};
extern VTBL_ENTRY _ZTV7ee63030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee63030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee63030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee63030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee63030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee63030[] = {
  {&(_ZTV7ee63030[4]),  4,11},
  {&(_tg__ZTV6dd3030__7ee63030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee63030[4]),  4,5},
  {&(_ZTV7ee63030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee63030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee63030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee63030[];
extern  VTBL_ENTRY _ZTV7ee63030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63030[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn12_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee630303fooEv,_ZTv0_n16_N7ee630303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630303fooEv,_ZThn12_N7ee630303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63030 = {  "ee63030", // class name
  bases_ee63030, 4,
  &(vtc_ee63030[0]), // expected_vtbl_contents
  &(vtt_ee63030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73030  : virtual dd3030 {
  int e;
  virtual void  foo(); // _ZN7ee730303fooEv
  virtual void  bar(); // _ZN7ee730303barEv
  ~ee73030(); // tgen
  ee73030(); // tgen
};
//SIG(1 ee73030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73030 ::foo(){vfunc_called(this, "_ZN7ee730303fooEv");}
void  ee73030 ::bar(){vfunc_called(this, "_ZN7ee730303barEv");}
ee73030 ::~ee73030(){ note_dtor("ee73030", this);} // tgen
ee73030 ::ee73030(){ note_ctor("ee73030", this);} // tgen

static void Test_ee73030()
{
  extern Class_Descriptor cd_ee73030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73030, buf);
    ee73030 *dp, &lv = *(dp=new (buf) ee73030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee73030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee73030");
    check_base_class_offset(lv, (cc030*)(dd3030*), ABISELECT(32,16), "ee73030");
    check_base_class_offset(lv, (dd3030*), ABISELECT(16,8), "ee73030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73030.e");
    test_class_info(&lv, &cd_ee73030);
    dp->~ee73030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73030(Test_ee73030, "ee73030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73030C1Ev();
extern void _ZN7ee73030D1Ev();
Name_Map name_map_ee73030[] = {
  NSPAIR(_ZN7ee73030C1Ev),
  NSPAIR(_ZN7ee73030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd3030;
extern VTBL_ENTRY _ZTI6dd3030[];
extern  VTBL_ENTRY _ZTV6dd3030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3030[];
static Base_Class bases_ee73030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3030,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73030[];
extern void _ZN7ee730303fooEv();
extern void _ZN7ee730303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee730303fooEv,_ZTv0_n20_N7ee730303fooEv)();
extern void ABISELECT(_ZThn16_N7ee730303fooEv,_ZThn8_N7ee730303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee730303fooEv,_ZTv0_n16_N7ee730303fooEv)();
extern void ABISELECT(_ZThn32_N7ee730303fooEv,_ZThn16_N7ee730303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73030[0]),
  (VTBL_ENTRY)&_ZN7ee730303fooEv,
  (VTBL_ENTRY)&_ZN7ee730303barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee730303fooEv,_ZTv0_n20_N7ee730303fooEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730303fooEv,_ZTv0_n16_N7ee730303fooEv),
};
extern VTBL_ENTRY _ZTV7ee73030[];
extern void _ZN6dd30303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3030__7ee73030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&_ZN6dd30303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv)();
extern void ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd3030__7ee73030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee73030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee73030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee73030[] = {
  {&(_ZTV7ee73030[5]),  5,18},
  {&(_ZTV7ee73030[12]),  12,18},
  {&(_ZTV7ee73030[17]),  17,18},
  {&(_tg__ZTV6dd3030__7ee73030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd3030__7ee73030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee73030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee73030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73030[];
extern  VTBL_ENTRY _ZTV7ee73030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73030[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd30303fooEv,_ZTv0_n16_N6dd30303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30303fooEv,_ZThn8_N6dd30303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee730303fooEv,_ZTv0_n16_N7ee730303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730303fooEv,_ZThn16_N7ee730303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee730303fooEv,_ZTv0_n20_N7ee730303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730303fooEv,_ZThn8_N7ee730303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73030 = {  "ee73030", // class name
  bases_ee73030, 4,
  &(vtc_ee73030[0]), // expected_vtbl_contents
  &(vtt_ee73030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73030),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4030  : cc030 {
  int d;
  virtual void  bar(); // _ZN6dd40303barEv
  ~dd4030(); // tgen
  dd4030(); // tgen
};
//SIG(-1 dd4030) C1{ BC2{ BC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd4030 ::bar(){vfunc_called(this, "_ZN6dd40303barEv");}
dd4030 ::~dd4030(){ note_dtor("dd4030", this);} // tgen
dd4030 ::dd4030(){ note_ctor("dd4030", this);} // tgen

static void Test_dd4030()
{
  extern Class_Descriptor cd_dd4030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4030, buf);
    dd4030 *dp, &lv = *(dp=new (buf) dd4030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(20,16), "dd4030");
    check_base_class_offset(lv, (bb30*)(cc030*), 0, "dd4030");
    check_base_class_offset(lv, (cc030*), 0, "dd4030");
    check_field_offset(lv, d, ABISELECT(16,12), "dd4030.d");
    test_class_info(&lv, &cd_dd4030);
    dp->~dd4030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4030(Test_dd4030, "dd4030", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4030C1Ev();
extern void _ZN6dd4030D1Ev();
Name_Map name_map_dd4030[] = {
  NSPAIR(_ZN6dd4030C1Ev),
  NSPAIR(_ZN6dd4030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd4030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY vtc_dd4030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern VTBL_ENTRY _ZTV6dd4030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd4030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd4030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd4030[] = {
  {&(_ZTV6dd4030[3]),  3,5},
  {&(_tg__ZTV5cc030__6dd4030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd4030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
Class_Descriptor cd_dd4030 = {  "dd4030", // class name
  bases_dd4030, 3,
  &(vtc_dd4030[0]), // expected_vtbl_contents
  &(vtt_dd4030[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4030),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04030  : dd4030 {
  int e;
  ~ee04030(); // tgen
  ee04030(); // tgen
};
//SIG(1 ee04030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee04030 ::~ee04030(){ note_dtor("ee04030", this);} // tgen
ee04030 ::ee04030(){ note_ctor("ee04030", this);} // tgen

static void Test_ee04030()
{
  extern Class_Descriptor cd_ee04030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04030, buf);
    ee04030 *dp, &lv = *(dp=new (buf) ee04030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(24,20), "ee04030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), 0, "ee04030");
    check_base_class_offset(lv, (cc030*)(dd4030*), 0, "ee04030");
    check_base_class_offset(lv, (dd4030*), 0, "ee04030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee04030.e");
    test_class_info(&lv, &cd_ee04030);
    dp->~ee04030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04030(Test_ee04030, "ee04030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04030C1Ev();
extern void _ZN7ee04030D1Ev();
Name_Map name_map_ee04030[] = {
  NSPAIR(_ZN7ee04030C1Ev),
  NSPAIR(_ZN7ee04030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee04030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY vtc_ee04030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern VTBL_ENTRY _ZTV7ee04030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee04030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee04030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee04030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee04030[] = {
  {&(_ZTV7ee04030[3]),  3,5},
  {&(_tg__ZTV6dd4030__7ee04030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee04030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee04030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee04030[];
extern  VTBL_ENTRY _ZTV7ee04030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04030[];
Class_Descriptor cd_ee04030 = {  "ee04030", // class name
  bases_ee04030, 4,
  &(vtc_ee04030[0]), // expected_vtbl_contents
  &(vtt_ee04030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14030  : virtual dd4030 {
  int e;
  ~ee14030(); // tgen
  ee14030(); // tgen
};
//SIG(1 ee14030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee14030 ::~ee14030(){ note_dtor("ee14030", this);} // tgen
ee14030 ::ee14030(){ note_ctor("ee14030", this);} // tgen

static void Test_ee14030()
{
  extern Class_Descriptor cd_ee14030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14030, buf);
    ee14030 *dp, &lv = *(dp=new (buf) ee14030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(36,24), "ee14030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), ABISELECT(16,8), "ee14030");
    check_base_class_offset(lv, (cc030*)(dd4030*), ABISELECT(16,8), "ee14030");
    check_base_class_offset(lv, (dd4030*), ABISELECT(16,8), "ee14030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14030.e");
    test_class_info(&lv, &cd_ee14030);
    dp->~ee14030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14030(Test_ee14030, "ee14030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14030C1Ev();
extern void _ZN7ee14030D1Ev();
Name_Map name_map_ee14030[] = {
  NSPAIR(_ZN7ee14030C1Ev),
  NSPAIR(_ZN7ee14030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee14030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY vtc_ee14030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14030[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern VTBL_ENTRY _ZTV7ee14030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee14030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee14030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee14030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee14030[] = {
  {&(_ZTV7ee14030[4]),  4,11},
  {&(_ZTV7ee14030[9]),  9,11},
  {&(_tg__ZTV6dd4030__7ee14030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee14030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee14030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee14030[];
extern  VTBL_ENTRY _ZTV7ee14030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14030[];
Class_Descriptor cd_ee14030 = {  "ee14030", // class name
  bases_ee14030, 4,
  &(vtc_ee14030[0]), // expected_vtbl_contents
  &(vtt_ee14030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24030  : dd4030 {
  int e;
  virtual void  foo(); // _ZN7ee240303fooEv
  ~ee24030(); // tgen
  ee24030(); // tgen
};
//SIG(1 ee24030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24030 ::foo(){vfunc_called(this, "_ZN7ee240303fooEv");}
ee24030 ::~ee24030(){ note_dtor("ee24030", this);} // tgen
ee24030 ::ee24030(){ note_ctor("ee24030", this);} // tgen

static void Test_ee24030()
{
  extern Class_Descriptor cd_ee24030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24030, buf);
    ee24030 *dp, &lv = *(dp=new (buf) ee24030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(24,20), "ee24030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), 0, "ee24030");
    check_base_class_offset(lv, (cc030*)(dd4030*), 0, "ee24030");
    check_base_class_offset(lv, (dd4030*), 0, "ee24030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee24030.e");
    test_class_info(&lv, &cd_ee24030);
    dp->~ee24030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24030(Test_ee24030, "ee24030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24030C1Ev();
extern void _ZN7ee24030D1Ev();
Name_Map name_map_ee24030[] = {
  NSPAIR(_ZN7ee24030C1Ev),
  NSPAIR(_ZN7ee24030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee24030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24030[];
extern void _ZN7ee240303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY vtc_ee24030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24030[0]),
  (VTBL_ENTRY)&_ZN7ee240303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern VTBL_ENTRY _ZTV7ee24030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee24030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee24030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee24030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee24030[] = {
  {&(_ZTV7ee24030[3]),  3,5},
  {&(_tg__ZTV6dd4030__7ee24030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee24030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee24030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee24030[];
extern  VTBL_ENTRY _ZTV7ee24030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24030[];
Class_Descriptor cd_ee24030 = {  "ee24030", // class name
  bases_ee24030, 4,
  &(vtc_ee24030[0]), // expected_vtbl_contents
  &(vtt_ee24030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34030  : virtual dd4030 {
  int e;
  virtual void  foo(); // _ZN7ee340303fooEv
  ~ee34030(); // tgen
  ee34030(); // tgen
};
//SIG(1 ee34030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34030 ::foo(){vfunc_called(this, "_ZN7ee340303fooEv");}
ee34030 ::~ee34030(){ note_dtor("ee34030", this);} // tgen
ee34030 ::ee34030(){ note_ctor("ee34030", this);} // tgen

static void Test_ee34030()
{
  extern Class_Descriptor cd_ee34030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34030, buf);
    ee34030 *dp, &lv = *(dp=new (buf) ee34030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(36,24), "ee34030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), ABISELECT(16,8), "ee34030");
    check_base_class_offset(lv, (cc030*)(dd4030*), ABISELECT(16,8), "ee34030");
    check_base_class_offset(lv, (dd4030*), ABISELECT(16,8), "ee34030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34030.e");
    test_class_info(&lv, &cd_ee34030);
    dp->~ee34030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34030(Test_ee34030, "ee34030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34030C1Ev();
extern void _ZN7ee34030D1Ev();
Name_Map name_map_ee34030[] = {
  NSPAIR(_ZN7ee34030C1Ev),
  NSPAIR(_ZN7ee34030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee34030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34030[];
extern void _ZN7ee340303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee340303fooEv,_ZTv0_n16_N7ee340303fooEv)();
extern void ABISELECT(_ZThn16_N7ee340303fooEv,_ZThn8_N7ee340303fooEv)() __attribute__((weak));
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY vtc_ee34030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34030[0]),
  (VTBL_ENTRY)&_ZN7ee340303fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee340303fooEv,_ZTv0_n16_N7ee340303fooEv),
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern VTBL_ENTRY _ZTV7ee34030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee34030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee34030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee34030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee34030[] = {
  {&(_ZTV7ee34030[4]),  4,12},
  {&(_ZTV7ee34030[10]),  10,12},
  {&(_tg__ZTV6dd4030__7ee34030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee34030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee34030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee34030[];
extern  VTBL_ENTRY _ZTV7ee34030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34030[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee340303fooEv,_ZTv0_n16_N7ee340303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee340303fooEv,_ZThn8_N7ee340303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34030 = {  "ee34030", // class name
  bases_ee34030, 4,
  &(vtc_ee34030[0]), // expected_vtbl_contents
  &(vtt_ee34030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34030),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44030  : dd4030 {
  int e;
  virtual void  bar(); // _ZN7ee440303barEv
  ~ee44030(); // tgen
  ee44030(); // tgen
};
//SIG(1 ee44030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44030 ::bar(){vfunc_called(this, "_ZN7ee440303barEv");}
ee44030 ::~ee44030(){ note_dtor("ee44030", this);} // tgen
ee44030 ::ee44030(){ note_ctor("ee44030", this);} // tgen

static void Test_ee44030()
{
  extern Class_Descriptor cd_ee44030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44030, buf);
    ee44030 *dp, &lv = *(dp=new (buf) ee44030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(24,20), "ee44030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), 0, "ee44030");
    check_base_class_offset(lv, (cc030*)(dd4030*), 0, "ee44030");
    check_base_class_offset(lv, (dd4030*), 0, "ee44030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee44030.e");
    test_class_info(&lv, &cd_ee44030);
    dp->~ee44030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44030(Test_ee44030, "ee44030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44030C1Ev();
extern void _ZN7ee44030D1Ev();
Name_Map name_map_ee44030[] = {
  NSPAIR(_ZN7ee44030C1Ev),
  NSPAIR(_ZN7ee44030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee44030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44030[];
extern void _ZN4bb303fooEv();
extern void _ZN7ee440303barEv();
static  VTBL_ENTRY vtc_ee44030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN7ee440303barEv,
};
extern VTBL_ENTRY _ZTV7ee44030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee44030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee44030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee44030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee44030[] = {
  {&(_ZTV7ee44030[3]),  3,5},
  {&(_tg__ZTV6dd4030__7ee44030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee44030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee44030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee44030[];
extern  VTBL_ENTRY _ZTV7ee44030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44030[];
Class_Descriptor cd_ee44030 = {  "ee44030", // class name
  bases_ee44030, 4,
  &(vtc_ee44030[0]), // expected_vtbl_contents
  &(vtt_ee44030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54030  : virtual dd4030 {
  int e;
  virtual void  bar(); // _ZN7ee540303barEv
  ~ee54030(); // tgen
  ee54030(); // tgen
};
//SIG(1 ee54030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54030 ::bar(){vfunc_called(this, "_ZN7ee540303barEv");}
ee54030 ::~ee54030(){ note_dtor("ee54030", this);} // tgen
ee54030 ::ee54030(){ note_ctor("ee54030", this);} // tgen

static void Test_ee54030()
{
  extern Class_Descriptor cd_ee54030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54030, buf);
    ee54030 *dp, &lv = *(dp=new (buf) ee54030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(36,24), "ee54030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), ABISELECT(16,8), "ee54030");
    check_base_class_offset(lv, (cc030*)(dd4030*), ABISELECT(16,8), "ee54030");
    check_base_class_offset(lv, (dd4030*), ABISELECT(16,8), "ee54030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54030.e");
    test_class_info(&lv, &cd_ee54030);
    dp->~ee54030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54030(Test_ee54030, "ee54030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54030C1Ev();
extern void _ZN7ee54030D1Ev();
Name_Map name_map_ee54030[] = {
  NSPAIR(_ZN7ee54030C1Ev),
  NSPAIR(_ZN7ee54030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee54030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54030[];
extern void _ZN7ee540303barEv();
extern void _ZN4bb303fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee540303barEv,_ZTv0_n20_N7ee540303barEv)();
extern void ABISELECT(_ZThn16_N7ee540303barEv,_ZThn8_N7ee540303barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54030[0]),
  (VTBL_ENTRY)&_ZN7ee540303barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee540303barEv,_ZTv0_n20_N7ee540303barEv),
};
extern VTBL_ENTRY _ZTV7ee54030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee54030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee54030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee54030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee54030[] = {
  {&(_ZTV7ee54030[4]),  4,12},
  {&(_ZTV7ee54030[10]),  10,12},
  {&(_tg__ZTV6dd4030__7ee54030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee54030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee54030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee54030[];
extern  VTBL_ENTRY _ZTV7ee54030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54030[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee540303barEv,_ZTv0_n20_N7ee540303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540303barEv,_ZThn8_N7ee540303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54030 = {  "ee54030", // class name
  bases_ee54030, 4,
  &(vtc_ee54030[0]), // expected_vtbl_contents
  &(vtt_ee54030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54030),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64030  : dd4030 {
  int e;
  virtual void  foo(); // _ZN7ee640303fooEv
  virtual void  bar(); // _ZN7ee640303barEv
  ~ee64030(); // tgen
  ee64030(); // tgen
};
//SIG(1 ee64030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64030 ::foo(){vfunc_called(this, "_ZN7ee640303fooEv");}
void  ee64030 ::bar(){vfunc_called(this, "_ZN7ee640303barEv");}
ee64030 ::~ee64030(){ note_dtor("ee64030", this);} // tgen
ee64030 ::ee64030(){ note_ctor("ee64030", this);} // tgen

static void Test_ee64030()
{
  extern Class_Descriptor cd_ee64030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64030, buf);
    ee64030 *dp, &lv = *(dp=new (buf) ee64030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(24,20), "ee64030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), 0, "ee64030");
    check_base_class_offset(lv, (cc030*)(dd4030*), 0, "ee64030");
    check_base_class_offset(lv, (dd4030*), 0, "ee64030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee64030.e");
    test_class_info(&lv, &cd_ee64030);
    dp->~ee64030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64030(Test_ee64030, "ee64030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64030C1Ev();
extern void _ZN7ee64030D1Ev();
Name_Map name_map_ee64030[] = {
  NSPAIR(_ZN7ee64030C1Ev),
  NSPAIR(_ZN7ee64030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee64030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64030[];
extern void _ZN7ee640303fooEv();
extern void _ZN7ee640303barEv();
static  VTBL_ENTRY vtc_ee64030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64030[0]),
  (VTBL_ENTRY)&_ZN7ee640303fooEv,
  (VTBL_ENTRY)&_ZN7ee640303barEv,
};
extern VTBL_ENTRY _ZTV7ee64030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee64030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee64030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee64030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee64030[] = {
  {&(_ZTV7ee64030[3]),  3,5},
  {&(_tg__ZTV6dd4030__7ee64030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee64030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee64030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee64030[];
extern  VTBL_ENTRY _ZTV7ee64030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64030[];
Class_Descriptor cd_ee64030 = {  "ee64030", // class name
  bases_ee64030, 4,
  &(vtc_ee64030[0]), // expected_vtbl_contents
  &(vtt_ee64030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74030  : virtual dd4030 {
  int e;
  virtual void  foo(); // _ZN7ee740303fooEv
  virtual void  bar(); // _ZN7ee740303barEv
  ~ee74030(); // tgen
  ee74030(); // tgen
};
//SIG(1 ee74030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74030 ::foo(){vfunc_called(this, "_ZN7ee740303fooEv");}
void  ee74030 ::bar(){vfunc_called(this, "_ZN7ee740303barEv");}
ee74030 ::~ee74030(){ note_dtor("ee74030", this);} // tgen
ee74030 ::ee74030(){ note_ctor("ee74030", this);} // tgen

static void Test_ee74030()
{
  extern Class_Descriptor cd_ee74030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74030, buf);
    ee74030 *dp, &lv = *(dp=new (buf) ee74030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd4030*), ABISELECT(36,24), "ee74030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd4030*), ABISELECT(16,8), "ee74030");
    check_base_class_offset(lv, (cc030*)(dd4030*), ABISELECT(16,8), "ee74030");
    check_base_class_offset(lv, (dd4030*), ABISELECT(16,8), "ee74030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74030.e");
    test_class_info(&lv, &cd_ee74030);
    dp->~ee74030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74030(Test_ee74030, "ee74030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74030C1Ev();
extern void _ZN7ee74030D1Ev();
Name_Map name_map_ee74030[] = {
  NSPAIR(_ZN7ee74030C1Ev),
  NSPAIR(_ZN7ee74030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd4030;
extern VTBL_ENTRY _ZTI6dd4030[];
extern  VTBL_ENTRY _ZTV6dd4030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4030[];
static Base_Class bases_ee74030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74030[];
extern void _ZN7ee740303fooEv();
extern void _ZN7ee740303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee740303fooEv,_ZTv0_n16_N7ee740303fooEv)();
extern void ABISELECT(_ZThn16_N7ee740303fooEv,_ZThn8_N7ee740303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee740303barEv,_ZTv0_n20_N7ee740303barEv)();
extern void ABISELECT(_ZThn16_N7ee740303barEv,_ZThn8_N7ee740303barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74030[0]),
  (VTBL_ENTRY)&_ZN7ee740303fooEv,
  (VTBL_ENTRY)&_ZN7ee740303barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee740303fooEv,_ZTv0_n16_N7ee740303fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee740303barEv,_ZTv0_n20_N7ee740303barEv),
};
extern VTBL_ENTRY _ZTV7ee74030[];
extern void _ZN4bb303fooEv();
extern void _ZN6dd40303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4030__7ee74030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
  (VTBL_ENTRY)&_ZN6dd40303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd4030__7ee74030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd4030__7ee74030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee74030[] = {
  {&(_ZTV7ee74030[4]),  4,13},
  {&(_ZTV7ee74030[11]),  11,13},
  {&(_tg__ZTV6dd4030__7ee74030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd4030__7ee74030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd4030__7ee74030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee74030[];
extern  VTBL_ENTRY _ZTV7ee74030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74030[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee740303barEv,_ZTv0_n20_N7ee740303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740303barEv,_ZThn8_N7ee740303barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee740303fooEv,_ZTv0_n16_N7ee740303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740303fooEv,_ZThn8_N7ee740303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74030 = {  "ee74030", // class name
  bases_ee74030, 4,
  &(vtc_ee74030[0]), // expected_vtbl_contents
  &(vtt_ee74030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74030),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5030  : virtual cc030 {
  int d;
  virtual void  bar(); // _ZN6dd50303barEv
  ~dd5030(); // tgen
  dd5030(); // tgen
};
//SIG(-1 dd5030) C1{ VBC2{ BC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd5030 ::bar(){vfunc_called(this, "_ZN6dd50303barEv");}
dd5030 ::~dd5030(){ note_dtor("dd5030", this);} // tgen
dd5030 ::dd5030(){ note_ctor("dd5030", this);} // tgen

static void Test_dd5030()
{
  extern Class_Descriptor cd_dd5030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5030, buf);
    dd5030 *dp, &lv = *(dp=new (buf) dd5030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,20), "dd5030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,8), "dd5030");
    check_base_class_offset(lv, (cc030*), ABISELECT(16,8), "dd5030");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5030.d");
    test_class_info(&lv, &cd_dd5030);
    dp->~dd5030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5030(Test_dd5030, "dd5030", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5030C1Ev();
extern void _ZN6dd5030D1Ev();
Name_Map name_map_dd5030[] = {
  NSPAIR(_ZN6dd5030C1Ev),
  NSPAIR(_ZN6dd5030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd5030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5030[];
extern void _ZN6dd50303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_dd5030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV6dd5030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd5030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd5030[] = {
  {&(_ZTV6dd5030[4]),  4,10},
  {&(_ZTV6dd5030[9]),  9,10},
  {&(_tg__ZTV5cc030__6dd5030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd5030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
Class_Descriptor cd_dd5030 = {  "dd5030", // class name
  bases_dd5030, 3,
  &(vtc_dd5030[0]), // expected_vtbl_contents
  &(vtt_dd5030[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5030),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05030  : dd5030 {
  int e;
  ~ee05030(); // tgen
  ee05030(); // tgen
};
//SIG(1 ee05030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee05030 ::~ee05030(){ note_dtor("ee05030", this);} // tgen
ee05030 ::ee05030(){ note_ctor("ee05030", this);} // tgen

static void Test_ee05030()
{
  extern Class_Descriptor cd_ee05030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05030, buf);
    ee05030 *dp, &lv = *(dp=new (buf) ee05030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee05030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee05030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(16,12), "ee05030");
    check_base_class_offset(lv, (dd5030*), 0, "ee05030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05030.e");
    test_class_info(&lv, &cd_ee05030);
    dp->~ee05030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05030(Test_ee05030, "ee05030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05030C1Ev();
extern void _ZN7ee05030D1Ev();
Name_Map name_map_ee05030[] = {
  NSPAIR(_ZN7ee05030C1Ev),
  NSPAIR(_ZN7ee05030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee05030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05030[];
extern void _ZN6dd50303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee05030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee05030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee05030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee05030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee05030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee05030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee05030[] = {
  {&(_ZTV7ee05030[4]),  4,10},
  {&(_tg__ZTV6dd5030__7ee05030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee05030[4]),  4,5},
  {&(_ZTV7ee05030[9]),  9,10},
  {&(_tg__ZTV5cc030__7ee05030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee05030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee05030[];
extern  VTBL_ENTRY _ZTV7ee05030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05030[];
Class_Descriptor cd_ee05030 = {  "ee05030", // class name
  bases_ee05030, 4,
  &(vtc_ee05030[0]), // expected_vtbl_contents
  &(vtt_ee05030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15030  : virtual dd5030 {
  int e;
  ~ee15030(); // tgen
  ee15030(); // tgen
};
//SIG(1 ee15030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee15030 ::~ee15030(){ note_dtor("ee15030", this);} // tgen
ee15030 ::ee15030(){ note_ctor("ee15030", this);} // tgen

static void Test_ee15030()
{
  extern Class_Descriptor cd_ee15030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15030, buf);
    ee15030 *dp, &lv = *(dp=new (buf) ee15030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee15030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee15030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(32,16), "ee15030");
    check_base_class_offset(lv, (dd5030*), ABISELECT(16,8), "ee15030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15030.e");
    test_class_info(&lv, &cd_ee15030);
    dp->~ee15030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15030(Test_ee15030, "ee15030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15030C1Ev();
extern void _ZN7ee15030D1Ev();
Name_Map name_map_ee15030[] = {
  NSPAIR(_ZN7ee15030C1Ev),
  NSPAIR(_ZN7ee15030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee15030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15030[];
extern void _ZN6dd50303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee15030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15030[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee15030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee15030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee15030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee15030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee15030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee15030[] = {
  {&(_ZTV7ee15030[5]),  5,16},
  {&(_ZTV7ee15030[10]),  10,16},
  {&(_ZTV7ee15030[15]),  15,16},
  {&(_tg__ZTV6dd5030__7ee15030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee15030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee15030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee15030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15030[];
extern  VTBL_ENTRY _ZTV7ee15030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15030[];
Class_Descriptor cd_ee15030 = {  "ee15030", // class name
  bases_ee15030, 4,
  &(vtc_ee15030[0]), // expected_vtbl_contents
  &(vtt_ee15030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15030),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25030  : dd5030 {
  int e;
  virtual void  foo(); // _ZN7ee250303fooEv
  ~ee25030(); // tgen
  ee25030(); // tgen
};
//SIG(1 ee25030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25030 ::foo(){vfunc_called(this, "_ZN7ee250303fooEv");}
ee25030 ::~ee25030(){ note_dtor("ee25030", this);} // tgen
ee25030 ::ee25030(){ note_ctor("ee25030", this);} // tgen

static void Test_ee25030()
{
  extern Class_Descriptor cd_ee25030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25030, buf);
    ee25030 *dp, &lv = *(dp=new (buf) ee25030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee25030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee25030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(16,12), "ee25030");
    check_base_class_offset(lv, (dd5030*), 0, "ee25030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25030.e");
    test_class_info(&lv, &cd_ee25030);
    dp->~ee25030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25030(Test_ee25030, "ee25030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25030C1Ev();
extern void _ZN7ee25030D1Ev();
Name_Map name_map_ee25030[] = {
  NSPAIR(_ZN7ee25030C1Ev),
  NSPAIR(_ZN7ee25030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee25030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25030[];
extern void _ZN6dd50303barEv();
extern void _ZN7ee250303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee250303fooEv,_ZTv0_n16_N7ee250303fooEv)();
extern void ABISELECT(_ZThn16_N7ee250303fooEv,_ZThn12_N7ee250303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
  (VTBL_ENTRY)&_ZN7ee250303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee250303fooEv,_ZTv0_n16_N7ee250303fooEv),
};
extern VTBL_ENTRY _ZTV7ee25030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee25030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee25030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee25030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee25030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee25030[] = {
  {&(_ZTV7ee25030[4]),  4,11},
  {&(_tg__ZTV6dd5030__7ee25030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee25030[4]),  4,5},
  {&(_ZTV7ee25030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee25030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee25030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee25030[];
extern  VTBL_ENTRY _ZTV7ee25030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25030[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee250303fooEv,_ZTv0_n16_N7ee250303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee250303fooEv,_ZThn12_N7ee250303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25030 = {  "ee25030", // class name
  bases_ee25030, 4,
  &(vtc_ee25030[0]), // expected_vtbl_contents
  &(vtt_ee25030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35030  : virtual dd5030 {
  int e;
  virtual void  foo(); // _ZN7ee350303fooEv
  ~ee35030(); // tgen
  ee35030(); // tgen
};
//SIG(1 ee35030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35030 ::foo(){vfunc_called(this, "_ZN7ee350303fooEv");}
ee35030 ::~ee35030(){ note_dtor("ee35030", this);} // tgen
ee35030 ::ee35030(){ note_ctor("ee35030", this);} // tgen

static void Test_ee35030()
{
  extern Class_Descriptor cd_ee35030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35030, buf);
    ee35030 *dp, &lv = *(dp=new (buf) ee35030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee35030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee35030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(32,16), "ee35030");
    check_base_class_offset(lv, (dd5030*), ABISELECT(16,8), "ee35030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35030.e");
    test_class_info(&lv, &cd_ee35030);
    dp->~ee35030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35030(Test_ee35030, "ee35030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35030C1Ev();
extern void _ZN7ee35030D1Ev();
Name_Map name_map_ee35030[] = {
  NSPAIR(_ZN7ee35030C1Ev),
  NSPAIR(_ZN7ee35030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee35030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35030[];
extern void _ZN7ee350303fooEv();
extern void _ZN6dd50303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee350303fooEv,_ZTv0_n16_N7ee350303fooEv)();
extern void ABISELECT(_ZThn32_N7ee350303fooEv,_ZThn16_N7ee350303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35030[0]),
  (VTBL_ENTRY)&_ZN7ee350303fooEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee350303fooEv,_ZTv0_n16_N7ee350303fooEv),
};
extern VTBL_ENTRY _ZTV7ee35030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee35030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee35030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee35030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee35030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee35030[] = {
  {&(_ZTV7ee35030[5]),  5,17},
  {&(_ZTV7ee35030[11]),  11,17},
  {&(_ZTV7ee35030[16]),  16,17},
  {&(_tg__ZTV6dd5030__7ee35030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee35030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee35030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee35030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35030[];
extern  VTBL_ENTRY _ZTV7ee35030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35030[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee350303fooEv,_ZTv0_n16_N7ee350303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee350303fooEv,_ZThn16_N7ee350303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35030 = {  "ee35030", // class name
  bases_ee35030, 4,
  &(vtc_ee35030[0]), // expected_vtbl_contents
  &(vtt_ee35030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35030),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45030  : dd5030 {
  int e;
  virtual void  bar(); // _ZN7ee450303barEv
  ~ee45030(); // tgen
  ee45030(); // tgen
};
//SIG(1 ee45030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45030 ::bar(){vfunc_called(this, "_ZN7ee450303barEv");}
ee45030 ::~ee45030(){ note_dtor("ee45030", this);} // tgen
ee45030 ::ee45030(){ note_ctor("ee45030", this);} // tgen

static void Test_ee45030()
{
  extern Class_Descriptor cd_ee45030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45030, buf);
    ee45030 *dp, &lv = *(dp=new (buf) ee45030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee45030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee45030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(16,12), "ee45030");
    check_base_class_offset(lv, (dd5030*), 0, "ee45030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45030.e");
    test_class_info(&lv, &cd_ee45030);
    dp->~ee45030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45030(Test_ee45030, "ee45030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45030C1Ev();
extern void _ZN7ee45030D1Ev();
Name_Map name_map_ee45030[] = {
  NSPAIR(_ZN7ee45030C1Ev),
  NSPAIR(_ZN7ee45030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee45030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45030[];
extern void _ZN7ee450303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee45030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45030[0]),
  (VTBL_ENTRY)&_ZN7ee450303barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee45030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee45030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee45030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee45030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee45030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee45030[] = {
  {&(_ZTV7ee45030[4]),  4,10},
  {&(_tg__ZTV6dd5030__7ee45030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee45030[4]),  4,5},
  {&(_ZTV7ee45030[9]),  9,10},
  {&(_tg__ZTV5cc030__7ee45030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee45030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee45030[];
extern  VTBL_ENTRY _ZTV7ee45030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45030[];
Class_Descriptor cd_ee45030 = {  "ee45030", // class name
  bases_ee45030, 4,
  &(vtc_ee45030[0]), // expected_vtbl_contents
  &(vtt_ee45030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45030),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55030  : virtual dd5030 {
  int e;
  virtual void  bar(); // _ZN7ee550303barEv
  ~ee55030(); // tgen
  ee55030(); // tgen
};
//SIG(1 ee55030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55030 ::bar(){vfunc_called(this, "_ZN7ee550303barEv");}
ee55030 ::~ee55030(){ note_dtor("ee55030", this);} // tgen
ee55030 ::ee55030(){ note_ctor("ee55030", this);} // tgen

static void Test_ee55030()
{
  extern Class_Descriptor cd_ee55030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55030, buf);
    ee55030 *dp, &lv = *(dp=new (buf) ee55030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee55030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee55030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(32,16), "ee55030");
    check_base_class_offset(lv, (dd5030*), ABISELECT(16,8), "ee55030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55030.e");
    test_class_info(&lv, &cd_ee55030);
    dp->~ee55030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55030(Test_ee55030, "ee55030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55030C1Ev();
extern void _ZN7ee55030D1Ev();
Name_Map name_map_ee55030[] = {
  NSPAIR(_ZN7ee55030C1Ev),
  NSPAIR(_ZN7ee55030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee55030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55030[];
extern void _ZN7ee550303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee550303barEv,_ZTv0_n20_N7ee550303barEv)();
extern void ABISELECT(_ZThn16_N7ee550303barEv,_ZThn8_N7ee550303barEv)() __attribute__((weak));
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee55030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55030[0]),
  (VTBL_ENTRY)&_ZN7ee550303barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee550303barEv,_ZTv0_n20_N7ee550303barEv),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee55030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee55030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee55030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee55030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee55030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee55030[] = {
  {&(_ZTV7ee55030[5]),  5,17},
  {&(_ZTV7ee55030[11]),  11,17},
  {&(_ZTV7ee55030[16]),  16,17},
  {&(_tg__ZTV6dd5030__7ee55030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee55030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee55030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee55030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55030[];
extern  VTBL_ENTRY _ZTV7ee55030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55030[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee550303barEv,_ZTv0_n20_N7ee550303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550303barEv,_ZThn8_N7ee550303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55030 = {  "ee55030", // class name
  bases_ee55030, 4,
  &(vtc_ee55030[0]), // expected_vtbl_contents
  &(vtt_ee55030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55030),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65030  : dd5030 {
  int e;
  virtual void  foo(); // _ZN7ee650303fooEv
  virtual void  bar(); // _ZN7ee650303barEv
  ~ee65030(); // tgen
  ee65030(); // tgen
};
//SIG(1 ee65030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65030 ::foo(){vfunc_called(this, "_ZN7ee650303fooEv");}
void  ee65030 ::bar(){vfunc_called(this, "_ZN7ee650303barEv");}
ee65030 ::~ee65030(){ note_dtor("ee65030", this);} // tgen
ee65030 ::ee65030(){ note_ctor("ee65030", this);} // tgen

static void Test_ee65030()
{
  extern Class_Descriptor cd_ee65030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65030, buf);
    ee65030 *dp, &lv = *(dp=new (buf) ee65030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee65030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee65030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(16,12), "ee65030");
    check_base_class_offset(lv, (dd5030*), 0, "ee65030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65030.e");
    test_class_info(&lv, &cd_ee65030);
    dp->~ee65030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65030(Test_ee65030, "ee65030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65030C1Ev();
extern void _ZN7ee65030D1Ev();
Name_Map name_map_ee65030[] = {
  NSPAIR(_ZN7ee65030C1Ev),
  NSPAIR(_ZN7ee65030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee65030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65030[];
extern void _ZN7ee650303barEv();
extern void _ZN7ee650303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee650303fooEv,_ZTv0_n16_N7ee650303fooEv)();
extern void ABISELECT(_ZThn16_N7ee650303fooEv,_ZThn12_N7ee650303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65030[0]),
  (VTBL_ENTRY)&_ZN7ee650303barEv,
  (VTBL_ENTRY)&_ZN7ee650303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee650303fooEv,_ZTv0_n16_N7ee650303fooEv),
};
extern VTBL_ENTRY _ZTV7ee65030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee65030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee65030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee65030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee65030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee65030[] = {
  {&(_ZTV7ee65030[4]),  4,11},
  {&(_tg__ZTV6dd5030__7ee65030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee65030[4]),  4,5},
  {&(_ZTV7ee65030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee65030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee65030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee65030[];
extern  VTBL_ENTRY _ZTV7ee65030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65030[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee650303fooEv,_ZTv0_n16_N7ee650303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650303fooEv,_ZThn12_N7ee650303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65030 = {  "ee65030", // class name
  bases_ee65030, 4,
  &(vtc_ee65030[0]), // expected_vtbl_contents
  &(vtt_ee65030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75030  : virtual dd5030 {
  int e;
  virtual void  foo(); // _ZN7ee750303fooEv
  virtual void  bar(); // _ZN7ee750303barEv
  ~ee75030(); // tgen
  ee75030(); // tgen
};
//SIG(1 ee75030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75030 ::foo(){vfunc_called(this, "_ZN7ee750303fooEv");}
void  ee75030 ::bar(){vfunc_called(this, "_ZN7ee750303barEv");}
ee75030 ::~ee75030(){ note_dtor("ee75030", this);} // tgen
ee75030 ::ee75030(){ note_ctor("ee75030", this);} // tgen

static void Test_ee75030()
{
  extern Class_Descriptor cd_ee75030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75030, buf);
    ee75030 *dp, &lv = *(dp=new (buf) ee75030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee75030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee75030");
    check_base_class_offset(lv, (cc030*)(dd5030*), ABISELECT(32,16), "ee75030");
    check_base_class_offset(lv, (dd5030*), ABISELECT(16,8), "ee75030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75030.e");
    test_class_info(&lv, &cd_ee75030);
    dp->~ee75030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75030(Test_ee75030, "ee75030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75030C1Ev();
extern void _ZN7ee75030D1Ev();
Name_Map name_map_ee75030[] = {
  NSPAIR(_ZN7ee75030C1Ev),
  NSPAIR(_ZN7ee75030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd5030;
extern VTBL_ENTRY _ZTI6dd5030[];
extern  VTBL_ENTRY _ZTV6dd5030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5030[];
static Base_Class bases_ee75030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5030,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75030[];
extern void _ZN7ee750303fooEv();
extern void _ZN7ee750303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee750303barEv,_ZTv0_n20_N7ee750303barEv)();
extern void ABISELECT(_ZThn16_N7ee750303barEv,_ZThn8_N7ee750303barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee750303fooEv,_ZTv0_n16_N7ee750303fooEv)();
extern void ABISELECT(_ZThn32_N7ee750303fooEv,_ZThn16_N7ee750303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75030[0]),
  (VTBL_ENTRY)&_ZN7ee750303fooEv,
  (VTBL_ENTRY)&_ZN7ee750303barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee750303barEv,_ZTv0_n20_N7ee750303barEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750303fooEv,_ZTv0_n16_N7ee750303fooEv),
};
extern VTBL_ENTRY _ZTV7ee75030[];
extern void _ZN6dd50303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5030__7ee75030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN6dd50303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd5030__7ee75030[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee75030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee75030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee75030[] = {
  {&(_ZTV7ee75030[5]),  5,18},
  {&(_ZTV7ee75030[12]),  12,18},
  {&(_ZTV7ee75030[17]),  17,18},
  {&(_tg__ZTV6dd5030__7ee75030[4]),  4,5},
  {&(_tg__ZTV5cc030__6dd5030__7ee75030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee75030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee75030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75030[];
extern  VTBL_ENTRY _ZTV7ee75030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75030[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750303fooEv,_ZTv0_n16_N7ee750303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750303fooEv,_ZThn16_N7ee750303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee750303barEv,_ZTv0_n20_N7ee750303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750303barEv,_ZThn8_N7ee750303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75030 = {  "ee75030", // class name
  bases_ee75030, 4,
  &(vtc_ee75030[0]), // expected_vtbl_contents
  &(vtt_ee75030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75030),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6030  : cc030 {
  int d;
  virtual void  bar(); // _ZN6dd60303barEv
  virtual void  foo(); // _ZN6dd60303fooEv
  ~dd6030(); // tgen
  dd6030(); // tgen
};
//SIG(-1 dd6030) C1{ BC2{ BC3{ VBC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd6030 ::bar(){vfunc_called(this, "_ZN6dd60303barEv");}
void  dd6030 ::foo(){vfunc_called(this, "_ZN6dd60303fooEv");}
dd6030 ::~dd6030(){ note_dtor("dd6030", this);} // tgen
dd6030 ::dd6030(){ note_ctor("dd6030", this);} // tgen

static void Test_dd6030()
{
  extern Class_Descriptor cd_dd6030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6030, buf);
    dd6030 *dp, &lv = *(dp=new (buf) dd6030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(20,16), "dd6030");
    check_base_class_offset(lv, (bb30*)(cc030*), 0, "dd6030");
    check_base_class_offset(lv, (cc030*), 0, "dd6030");
    check_field_offset(lv, d, ABISELECT(16,12), "dd6030.d");
    test_class_info(&lv, &cd_dd6030);
    dp->~dd6030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6030(Test_dd6030, "dd6030", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6030C1Ev();
extern void _ZN6dd6030D1Ev();
Name_Map name_map_dd6030[] = {
  NSPAIR(_ZN6dd6030C1Ev),
  NSPAIR(_ZN6dd6030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd6030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY vtc_dd6030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern VTBL_ENTRY _ZTV6dd6030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd6030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd6030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd6030[] = {
  {&(_ZTV6dd6030[3]),  3,5},
  {&(_tg__ZTV5cc030__6dd6030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd6030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
Class_Descriptor cd_dd6030 = {  "dd6030", // class name
  bases_dd6030, 3,
  &(vtc_dd6030[0]), // expected_vtbl_contents
  &(vtt_dd6030[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6030),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06030  : dd6030 {
  int e;
  ~ee06030(); // tgen
  ee06030(); // tgen
};
//SIG(1 ee06030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee06030 ::~ee06030(){ note_dtor("ee06030", this);} // tgen
ee06030 ::ee06030(){ note_ctor("ee06030", this);} // tgen

static void Test_ee06030()
{
  extern Class_Descriptor cd_ee06030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06030, buf);
    ee06030 *dp, &lv = *(dp=new (buf) ee06030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(24,20), "ee06030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), 0, "ee06030");
    check_base_class_offset(lv, (cc030*)(dd6030*), 0, "ee06030");
    check_base_class_offset(lv, (dd6030*), 0, "ee06030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee06030.e");
    test_class_info(&lv, &cd_ee06030);
    dp->~ee06030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06030(Test_ee06030, "ee06030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06030C1Ev();
extern void _ZN7ee06030D1Ev();
Name_Map name_map_ee06030[] = {
  NSPAIR(_ZN7ee06030C1Ev),
  NSPAIR(_ZN7ee06030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee06030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY vtc_ee06030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern VTBL_ENTRY _ZTV7ee06030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee06030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee06030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee06030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee06030[] = {
  {&(_ZTV7ee06030[3]),  3,5},
  {&(_tg__ZTV6dd6030__7ee06030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee06030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee06030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee06030[];
extern  VTBL_ENTRY _ZTV7ee06030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06030[];
Class_Descriptor cd_ee06030 = {  "ee06030", // class name
  bases_ee06030, 4,
  &(vtc_ee06030[0]), // expected_vtbl_contents
  &(vtt_ee06030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16030  : virtual dd6030 {
  int e;
  ~ee16030(); // tgen
  ee16030(); // tgen
};
//SIG(1 ee16030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee16030 ::~ee16030(){ note_dtor("ee16030", this);} // tgen
ee16030 ::ee16030(){ note_ctor("ee16030", this);} // tgen

static void Test_ee16030()
{
  extern Class_Descriptor cd_ee16030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16030, buf);
    ee16030 *dp, &lv = *(dp=new (buf) ee16030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(36,24), "ee16030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), ABISELECT(16,8), "ee16030");
    check_base_class_offset(lv, (cc030*)(dd6030*), ABISELECT(16,8), "ee16030");
    check_base_class_offset(lv, (dd6030*), ABISELECT(16,8), "ee16030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16030.e");
    test_class_info(&lv, &cd_ee16030);
    dp->~ee16030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16030(Test_ee16030, "ee16030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16030C1Ev();
extern void _ZN7ee16030D1Ev();
Name_Map name_map_ee16030[] = {
  NSPAIR(_ZN7ee16030C1Ev),
  NSPAIR(_ZN7ee16030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee16030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY vtc_ee16030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16030[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern VTBL_ENTRY _ZTV7ee16030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee16030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee16030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee16030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee16030[] = {
  {&(_ZTV7ee16030[4]),  4,11},
  {&(_ZTV7ee16030[9]),  9,11},
  {&(_tg__ZTV6dd6030__7ee16030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee16030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee16030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee16030[];
extern  VTBL_ENTRY _ZTV7ee16030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16030[];
Class_Descriptor cd_ee16030 = {  "ee16030", // class name
  bases_ee16030, 4,
  &(vtc_ee16030[0]), // expected_vtbl_contents
  &(vtt_ee16030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26030  : dd6030 {
  int e;
  virtual void  foo(); // _ZN7ee260303fooEv
  ~ee26030(); // tgen
  ee26030(); // tgen
};
//SIG(1 ee26030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26030 ::foo(){vfunc_called(this, "_ZN7ee260303fooEv");}
ee26030 ::~ee26030(){ note_dtor("ee26030", this);} // tgen
ee26030 ::ee26030(){ note_ctor("ee26030", this);} // tgen

static void Test_ee26030()
{
  extern Class_Descriptor cd_ee26030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26030, buf);
    ee26030 *dp, &lv = *(dp=new (buf) ee26030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(24,20), "ee26030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), 0, "ee26030");
    check_base_class_offset(lv, (cc030*)(dd6030*), 0, "ee26030");
    check_base_class_offset(lv, (dd6030*), 0, "ee26030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee26030.e");
    test_class_info(&lv, &cd_ee26030);
    dp->~ee26030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26030(Test_ee26030, "ee26030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26030C1Ev();
extern void _ZN7ee26030D1Ev();
Name_Map name_map_ee26030[] = {
  NSPAIR(_ZN7ee26030C1Ev),
  NSPAIR(_ZN7ee26030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee26030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26030[];
extern void _ZN7ee260303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY vtc_ee26030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26030[0]),
  (VTBL_ENTRY)&_ZN7ee260303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern VTBL_ENTRY _ZTV7ee26030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee26030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee26030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee26030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee26030[] = {
  {&(_ZTV7ee26030[3]),  3,5},
  {&(_tg__ZTV6dd6030__7ee26030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee26030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee26030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee26030[];
extern  VTBL_ENTRY _ZTV7ee26030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26030[];
Class_Descriptor cd_ee26030 = {  "ee26030", // class name
  bases_ee26030, 4,
  &(vtc_ee26030[0]), // expected_vtbl_contents
  &(vtt_ee26030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36030  : virtual dd6030 {
  int e;
  virtual void  foo(); // _ZN7ee360303fooEv
  ~ee36030(); // tgen
  ee36030(); // tgen
};
//SIG(1 ee36030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36030 ::foo(){vfunc_called(this, "_ZN7ee360303fooEv");}
ee36030 ::~ee36030(){ note_dtor("ee36030", this);} // tgen
ee36030 ::ee36030(){ note_ctor("ee36030", this);} // tgen

static void Test_ee36030()
{
  extern Class_Descriptor cd_ee36030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36030, buf);
    ee36030 *dp, &lv = *(dp=new (buf) ee36030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(36,24), "ee36030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), ABISELECT(16,8), "ee36030");
    check_base_class_offset(lv, (cc030*)(dd6030*), ABISELECT(16,8), "ee36030");
    check_base_class_offset(lv, (dd6030*), ABISELECT(16,8), "ee36030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36030.e");
    test_class_info(&lv, &cd_ee36030);
    dp->~ee36030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36030(Test_ee36030, "ee36030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36030C1Ev();
extern void _ZN7ee36030D1Ev();
Name_Map name_map_ee36030[] = {
  NSPAIR(_ZN7ee36030C1Ev),
  NSPAIR(_ZN7ee36030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee36030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36030[];
extern void _ZN7ee360303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee360303fooEv,_ZTv0_n16_N7ee360303fooEv)();
extern void ABISELECT(_ZThn16_N7ee360303fooEv,_ZThn8_N7ee360303fooEv)() __attribute__((weak));
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY vtc_ee36030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36030[0]),
  (VTBL_ENTRY)&_ZN7ee360303fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee360303fooEv,_ZTv0_n16_N7ee360303fooEv),
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern VTBL_ENTRY _ZTV7ee36030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee36030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee36030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee36030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee36030[] = {
  {&(_ZTV7ee36030[4]),  4,12},
  {&(_ZTV7ee36030[10]),  10,12},
  {&(_tg__ZTV6dd6030__7ee36030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee36030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee36030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee36030[];
extern  VTBL_ENTRY _ZTV7ee36030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36030[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee360303fooEv,_ZTv0_n16_N7ee360303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360303fooEv,_ZThn8_N7ee360303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36030 = {  "ee36030", // class name
  bases_ee36030, 4,
  &(vtc_ee36030[0]), // expected_vtbl_contents
  &(vtt_ee36030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36030),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46030  : dd6030 {
  int e;
  virtual void  bar(); // _ZN7ee460303barEv
  ~ee46030(); // tgen
  ee46030(); // tgen
};
//SIG(1 ee46030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46030 ::bar(){vfunc_called(this, "_ZN7ee460303barEv");}
ee46030 ::~ee46030(){ note_dtor("ee46030", this);} // tgen
ee46030 ::ee46030(){ note_ctor("ee46030", this);} // tgen

static void Test_ee46030()
{
  extern Class_Descriptor cd_ee46030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46030, buf);
    ee46030 *dp, &lv = *(dp=new (buf) ee46030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(24,20), "ee46030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), 0, "ee46030");
    check_base_class_offset(lv, (cc030*)(dd6030*), 0, "ee46030");
    check_base_class_offset(lv, (dd6030*), 0, "ee46030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee46030.e");
    test_class_info(&lv, &cd_ee46030);
    dp->~ee46030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46030(Test_ee46030, "ee46030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46030C1Ev();
extern void _ZN7ee46030D1Ev();
Name_Map name_map_ee46030[] = {
  NSPAIR(_ZN7ee46030C1Ev),
  NSPAIR(_ZN7ee46030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee46030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46030[];
extern void _ZN6dd60303fooEv();
extern void _ZN7ee460303barEv();
static  VTBL_ENTRY vtc_ee46030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN7ee460303barEv,
};
extern VTBL_ENTRY _ZTV7ee46030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee46030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee46030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee46030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee46030[] = {
  {&(_ZTV7ee46030[3]),  3,5},
  {&(_tg__ZTV6dd6030__7ee46030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee46030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee46030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee46030[];
extern  VTBL_ENTRY _ZTV7ee46030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46030[];
Class_Descriptor cd_ee46030 = {  "ee46030", // class name
  bases_ee46030, 4,
  &(vtc_ee46030[0]), // expected_vtbl_contents
  &(vtt_ee46030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56030  : virtual dd6030 {
  int e;
  virtual void  bar(); // _ZN7ee560303barEv
  ~ee56030(); // tgen
  ee56030(); // tgen
};
//SIG(1 ee56030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56030 ::bar(){vfunc_called(this, "_ZN7ee560303barEv");}
ee56030 ::~ee56030(){ note_dtor("ee56030", this);} // tgen
ee56030 ::ee56030(){ note_ctor("ee56030", this);} // tgen

static void Test_ee56030()
{
  extern Class_Descriptor cd_ee56030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56030, buf);
    ee56030 *dp, &lv = *(dp=new (buf) ee56030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(36,24), "ee56030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), ABISELECT(16,8), "ee56030");
    check_base_class_offset(lv, (cc030*)(dd6030*), ABISELECT(16,8), "ee56030");
    check_base_class_offset(lv, (dd6030*), ABISELECT(16,8), "ee56030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56030.e");
    test_class_info(&lv, &cd_ee56030);
    dp->~ee56030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56030(Test_ee56030, "ee56030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56030C1Ev();
extern void _ZN7ee56030D1Ev();
Name_Map name_map_ee56030[] = {
  NSPAIR(_ZN7ee56030C1Ev),
  NSPAIR(_ZN7ee56030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee56030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56030[];
extern void _ZN7ee560303barEv();
extern void _ZN6dd60303fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee560303barEv,_ZTv0_n20_N7ee560303barEv)();
extern void ABISELECT(_ZThn16_N7ee560303barEv,_ZThn8_N7ee560303barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56030[0]),
  (VTBL_ENTRY)&_ZN7ee560303barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee560303barEv,_ZTv0_n20_N7ee560303barEv),
};
extern VTBL_ENTRY _ZTV7ee56030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee56030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee56030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee56030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee56030[] = {
  {&(_ZTV7ee56030[4]),  4,12},
  {&(_ZTV7ee56030[10]),  10,12},
  {&(_tg__ZTV6dd6030__7ee56030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee56030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee56030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee56030[];
extern  VTBL_ENTRY _ZTV7ee56030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56030[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee560303barEv,_ZTv0_n20_N7ee560303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560303barEv,_ZThn8_N7ee560303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56030 = {  "ee56030", // class name
  bases_ee56030, 4,
  &(vtc_ee56030[0]), // expected_vtbl_contents
  &(vtt_ee56030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56030),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66030  : dd6030 {
  int e;
  virtual void  foo(); // _ZN7ee660303fooEv
  virtual void  bar(); // _ZN7ee660303barEv
  ~ee66030(); // tgen
  ee66030(); // tgen
};
//SIG(1 ee66030) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66030 ::foo(){vfunc_called(this, "_ZN7ee660303fooEv");}
void  ee66030 ::bar(){vfunc_called(this, "_ZN7ee660303barEv");}
ee66030 ::~ee66030(){ note_dtor("ee66030", this);} // tgen
ee66030 ::ee66030(){ note_ctor("ee66030", this);} // tgen

static void Test_ee66030()
{
  extern Class_Descriptor cd_ee66030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66030, buf);
    ee66030 *dp, &lv = *(dp=new (buf) ee66030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(24,20), "ee66030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), 0, "ee66030");
    check_base_class_offset(lv, (cc030*)(dd6030*), 0, "ee66030");
    check_base_class_offset(lv, (dd6030*), 0, "ee66030");
    check_field_offset(lv, e, ABISELECT(20,16), "ee66030.e");
    test_class_info(&lv, &cd_ee66030);
    dp->~ee66030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66030(Test_ee66030, "ee66030", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66030C1Ev();
extern void _ZN7ee66030D1Ev();
Name_Map name_map_ee66030[] = {
  NSPAIR(_ZN7ee66030C1Ev),
  NSPAIR(_ZN7ee66030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee66030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66030[];
extern void _ZN7ee660303fooEv();
extern void _ZN7ee660303barEv();
static  VTBL_ENTRY vtc_ee66030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66030[0]),
  (VTBL_ENTRY)&_ZN7ee660303fooEv,
  (VTBL_ENTRY)&_ZN7ee660303barEv,
};
extern VTBL_ENTRY _ZTV7ee66030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee66030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee66030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee66030[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee66030[] = {
  {&(_ZTV7ee66030[3]),  3,5},
  {&(_tg__ZTV6dd6030__7ee66030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee66030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee66030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee66030[];
extern  VTBL_ENTRY _ZTV7ee66030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66030[];
Class_Descriptor cd_ee66030 = {  "ee66030", // class name
  bases_ee66030, 4,
  &(vtc_ee66030[0]), // expected_vtbl_contents
  &(vtt_ee66030[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66030),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66030),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76030  : virtual dd6030 {
  int e;
  virtual void  foo(); // _ZN7ee760303fooEv
  virtual void  bar(); // _ZN7ee760303barEv
  ~ee76030(); // tgen
  ee76030(); // tgen
};
//SIG(1 ee76030) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76030 ::foo(){vfunc_called(this, "_ZN7ee760303fooEv");}
void  ee76030 ::bar(){vfunc_called(this, "_ZN7ee760303barEv");}
ee76030 ::~ee76030(){ note_dtor("ee76030", this);} // tgen
ee76030 ::ee76030(){ note_ctor("ee76030", this);} // tgen

static void Test_ee76030()
{
  extern Class_Descriptor cd_ee76030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76030, buf);
    ee76030 *dp, &lv = *(dp=new (buf) ee76030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*)(dd6030*), ABISELECT(36,24), "ee76030");
    check_base_class_offset(lv, (bb30*)(cc030*)(dd6030*), ABISELECT(16,8), "ee76030");
    check_base_class_offset(lv, (cc030*)(dd6030*), ABISELECT(16,8), "ee76030");
    check_base_class_offset(lv, (dd6030*), ABISELECT(16,8), "ee76030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76030.e");
    test_class_info(&lv, &cd_ee76030);
    dp->~ee76030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76030(Test_ee76030, "ee76030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76030C1Ev();
extern void _ZN7ee76030D1Ev();
Name_Map name_map_ee76030[] = {
  NSPAIR(_ZN7ee76030C1Ev),
  NSPAIR(_ZN7ee76030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd6030;
extern VTBL_ENTRY _ZTI6dd6030[];
extern  VTBL_ENTRY _ZTV6dd6030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6030[];
static Base_Class bases_ee76030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76030[];
extern void _ZN7ee760303fooEv();
extern void _ZN7ee760303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee760303fooEv,_ZTv0_n16_N7ee760303fooEv)();
extern void ABISELECT(_ZThn16_N7ee760303fooEv,_ZThn8_N7ee760303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee760303barEv,_ZTv0_n20_N7ee760303barEv)();
extern void ABISELECT(_ZThn16_N7ee760303barEv,_ZThn8_N7ee760303barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76030[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76030[0]),
  (VTBL_ENTRY)&_ZN7ee760303fooEv,
  (VTBL_ENTRY)&_ZN7ee760303barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760303fooEv,_ZTv0_n16_N7ee760303fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee760303barEv,_ZTv0_n20_N7ee760303barEv),
};
extern VTBL_ENTRY _ZTV7ee76030[];
extern void _ZN6dd60303fooEv();
extern void _ZN6dd60303barEv();
static  VTBL_ENTRY _tg__ZTV6dd6030__7ee76030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6030[0]),
  (VTBL_ENTRY)&_ZN6dd60303fooEv,
  (VTBL_ENTRY)&_ZN6dd60303barEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc0306dd6030__7ee76030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc0306dd6030__7ee76030[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee76030[] = {
  {&(_ZTV7ee76030[4]),  4,13},
  {&(_ZTV7ee76030[11]),  11,13},
  {&(_tg__ZTV6dd6030__7ee76030[3]),  3,5},
  {&(_tg__ZTV5cc0306dd6030__7ee76030[3]),  3,4},
  {&(_tg__ZTV4bb305cc0306dd6030__7ee76030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee76030[];
extern  VTBL_ENTRY _ZTV7ee76030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76030[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee760303barEv,_ZTv0_n20_N7ee760303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760303barEv,_ZThn8_N7ee760303barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760303fooEv,_ZTv0_n16_N7ee760303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760303fooEv,_ZThn8_N7ee760303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76030 = {  "ee76030", // class name
  bases_ee76030, 4,
  &(vtc_ee76030[0]), // expected_vtbl_contents
  &(vtt_ee76030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76030),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76030),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7030  : virtual cc030 {
  int d;
  virtual void  bar(); // _ZN6dd70303barEv
  virtual void  foo(); // _ZN6dd70303fooEv
  ~dd7030(); // tgen
  dd7030(); // tgen
};
//SIG(-1 dd7030) C1{ VBC2{ BC3{ VBC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd7030 ::bar(){vfunc_called(this, "_ZN6dd70303barEv");}
void  dd7030 ::foo(){vfunc_called(this, "_ZN6dd70303fooEv");}
dd7030 ::~dd7030(){ note_dtor("dd7030", this);} // tgen
dd7030 ::dd7030(){ note_ctor("dd7030", this);} // tgen

static void Test_dd7030()
{
  extern Class_Descriptor cd_dd7030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7030, buf);
    dd7030 *dp, &lv = *(dp=new (buf) dd7030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,20), "dd7030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,8), "dd7030");
    check_base_class_offset(lv, (cc030*), ABISELECT(16,8), "dd7030");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7030.d");
    test_class_info(&lv, &cd_dd7030);
    dp->~dd7030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7030(Test_dd7030, "dd7030", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7030C1Ev();
extern void _ZN6dd7030D1Ev();
Name_Map name_map_dd7030[] = {
  NSPAIR(_ZN6dd7030C1Ev),
  NSPAIR(_ZN6dd7030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
static Base_Class bases_dd7030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern VTBL_ENTRY _ZTV6dd7030[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__6dd7030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd7030[] = {
  {&(_ZTV6dd7030[4]),  4,11},
  {&(_ZTV6dd7030[10]),  10,11},
  {&(_tg__ZTV5cc030__6dd7030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__6dd7030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7030 = {  "dd7030", // class name
  bases_dd7030, 3,
  &(vtc_dd7030[0]), // expected_vtbl_contents
  &(vtt_dd7030[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7030),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07030  : dd7030 {
  int e;
  ~ee07030(); // tgen
  ee07030(); // tgen
};
//SIG(1 ee07030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee07030 ::~ee07030(){ note_dtor("ee07030", this);} // tgen
ee07030 ::ee07030(){ note_ctor("ee07030", this);} // tgen

static void Test_ee07030()
{
  extern Class_Descriptor cd_ee07030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07030, buf);
    ee07030 *dp, &lv = *(dp=new (buf) ee07030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee07030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee07030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(16,12), "ee07030");
    check_base_class_offset(lv, (dd7030*), 0, "ee07030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07030.e");
    test_class_info(&lv, &cd_ee07030);
    dp->~ee07030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07030(Test_ee07030, "ee07030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07030C1Ev();
extern void _ZN7ee07030D1Ev();
Name_Map name_map_ee07030[] = {
  NSPAIR(_ZN7ee07030C1Ev),
  NSPAIR(_ZN7ee07030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee07030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern VTBL_ENTRY _ZTV7ee07030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee07030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee07030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee07030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee07030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee07030[] = {
  {&(_ZTV7ee07030[4]),  4,11},
  {&(_tg__ZTV6dd7030__7ee07030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee07030[4]),  4,5},
  {&(_ZTV7ee07030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee07030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee07030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee07030[];
extern  VTBL_ENTRY _ZTV7ee07030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07030[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07030 = {  "ee07030", // class name
  bases_ee07030, 4,
  &(vtc_ee07030[0]), // expected_vtbl_contents
  &(vtt_ee07030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17030  : virtual dd7030 {
  int e;
  ~ee17030(); // tgen
  ee17030(); // tgen
};
//SIG(1 ee17030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee17030 ::~ee17030(){ note_dtor("ee17030", this);} // tgen
ee17030 ::ee17030(){ note_ctor("ee17030", this);} // tgen

static void Test_ee17030()
{
  extern Class_Descriptor cd_ee17030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17030, buf);
    ee17030 *dp, &lv = *(dp=new (buf) ee17030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee17030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee17030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(32,16), "ee17030");
    check_base_class_offset(lv, (dd7030*), ABISELECT(16,8), "ee17030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17030.e");
    test_class_info(&lv, &cd_ee17030);
    dp->~ee17030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17030(Test_ee17030, "ee17030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17030C1Ev();
extern void _ZN7ee17030D1Ev();
Name_Map name_map_ee17030[] = {
  NSPAIR(_ZN7ee17030C1Ev),
  NSPAIR(_ZN7ee17030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee17030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17030[0]),
  0,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern VTBL_ENTRY _ZTV7ee17030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee17030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee17030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee17030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee17030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee17030[] = {
  {&(_ZTV7ee17030[5]),  5,18},
  {&(_ZTV7ee17030[11]),  11,18},
  {&(_ZTV7ee17030[17]),  17,18},
  {&(_tg__ZTV6dd7030__7ee17030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee17030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee17030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee17030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17030[];
extern  VTBL_ENTRY _ZTV7ee17030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17030[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17030 = {  "ee17030", // class name
  bases_ee17030, 4,
  &(vtc_ee17030[0]), // expected_vtbl_contents
  &(vtt_ee17030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17030),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27030  : dd7030 {
  int e;
  virtual void  foo(); // _ZN7ee270303fooEv
  ~ee27030(); // tgen
  ee27030(); // tgen
};
//SIG(1 ee27030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27030 ::foo(){vfunc_called(this, "_ZN7ee270303fooEv");}
ee27030 ::~ee27030(){ note_dtor("ee27030", this);} // tgen
ee27030 ::ee27030(){ note_ctor("ee27030", this);} // tgen

static void Test_ee27030()
{
  extern Class_Descriptor cd_ee27030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27030, buf);
    ee27030 *dp, &lv = *(dp=new (buf) ee27030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee27030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee27030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(16,12), "ee27030");
    check_base_class_offset(lv, (dd7030*), 0, "ee27030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27030.e");
    test_class_info(&lv, &cd_ee27030);
    dp->~ee27030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27030(Test_ee27030, "ee27030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27030C1Ev();
extern void _ZN7ee27030D1Ev();
Name_Map name_map_ee27030[] = {
  NSPAIR(_ZN7ee27030C1Ev),
  NSPAIR(_ZN7ee27030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee27030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27030[];
extern void _ZN6dd70303barEv();
extern void _ZN7ee270303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee270303fooEv,_ZTv0_n16_N7ee270303fooEv)();
extern void ABISELECT(_ZThn16_N7ee270303fooEv,_ZThn12_N7ee270303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN7ee270303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee270303fooEv,_ZTv0_n16_N7ee270303fooEv),
};
extern VTBL_ENTRY _ZTV7ee27030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee27030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee27030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee27030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee27030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee27030[] = {
  {&(_ZTV7ee27030[4]),  4,11},
  {&(_tg__ZTV6dd7030__7ee27030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee27030[4]),  4,5},
  {&(_ZTV7ee27030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee27030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee27030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee27030[];
extern  VTBL_ENTRY _ZTV7ee27030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27030[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee270303fooEv,_ZTv0_n16_N7ee270303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee270303fooEv,_ZThn12_N7ee270303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27030 = {  "ee27030", // class name
  bases_ee27030, 4,
  &(vtc_ee27030[0]), // expected_vtbl_contents
  &(vtt_ee27030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37030  : virtual dd7030 {
  int e;
  virtual void  foo(); // _ZN7ee370303fooEv
  ~ee37030(); // tgen
  ee37030(); // tgen
};
//SIG(1 ee37030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37030 ::foo(){vfunc_called(this, "_ZN7ee370303fooEv");}
ee37030 ::~ee37030(){ note_dtor("ee37030", this);} // tgen
ee37030 ::ee37030(){ note_ctor("ee37030", this);} // tgen

static void Test_ee37030()
{
  extern Class_Descriptor cd_ee37030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37030, buf);
    ee37030 *dp, &lv = *(dp=new (buf) ee37030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee37030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee37030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(32,16), "ee37030");
    check_base_class_offset(lv, (dd7030*), ABISELECT(16,8), "ee37030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37030.e");
    test_class_info(&lv, &cd_ee37030);
    dp->~ee37030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37030(Test_ee37030, "ee37030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37030C1Ev();
extern void _ZN7ee37030D1Ev();
Name_Map name_map_ee37030[] = {
  NSPAIR(_ZN7ee37030C1Ev),
  NSPAIR(_ZN7ee37030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee37030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37030[];
extern void _ZN7ee370303fooEv();
extern void _ZN6dd70303barEv();
extern void ABISELECT(_ZTv0_n48_N7ee370303fooEv,_ZTv0_n24_N7ee370303fooEv)();
extern void ABISELECT(_ZThn16_N7ee370303fooEv,_ZThn8_N7ee370303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee370303fooEv,_ZTv0_n16_N7ee370303fooEv)();
extern void ABISELECT(_ZThn32_N7ee370303fooEv,_ZThn16_N7ee370303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37030[0]),
  (VTBL_ENTRY)&_ZN7ee370303fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee370303fooEv,_ZTv0_n24_N7ee370303fooEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee370303fooEv,_ZTv0_n16_N7ee370303fooEv),
};
extern VTBL_ENTRY _ZTV7ee37030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee37030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee37030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee37030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee37030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee37030[] = {
  {&(_ZTV7ee37030[5]),  5,19},
  {&(_ZTV7ee37030[12]),  12,19},
  {&(_ZTV7ee37030[18]),  18,19},
  {&(_tg__ZTV6dd7030__7ee37030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee37030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee37030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee37030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37030[];
extern  VTBL_ENTRY _ZTV7ee37030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37030[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee370303fooEv,_ZTv0_n16_N7ee370303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee370303fooEv,_ZThn16_N7ee370303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee370303fooEv,_ZTv0_n24_N7ee370303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370303fooEv,_ZThn8_N7ee370303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37030 = {  "ee37030", // class name
  bases_ee37030, 4,
  &(vtc_ee37030[0]), // expected_vtbl_contents
  &(vtt_ee37030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37030),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47030  : dd7030 {
  int e;
  virtual void  bar(); // _ZN7ee470303barEv
  ~ee47030(); // tgen
  ee47030(); // tgen
};
//SIG(1 ee47030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47030 ::bar(){vfunc_called(this, "_ZN7ee470303barEv");}
ee47030 ::~ee47030(){ note_dtor("ee47030", this);} // tgen
ee47030 ::ee47030(){ note_ctor("ee47030", this);} // tgen

static void Test_ee47030()
{
  extern Class_Descriptor cd_ee47030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47030, buf);
    ee47030 *dp, &lv = *(dp=new (buf) ee47030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee47030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee47030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(16,12), "ee47030");
    check_base_class_offset(lv, (dd7030*), 0, "ee47030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47030.e");
    test_class_info(&lv, &cd_ee47030);
    dp->~ee47030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47030(Test_ee47030, "ee47030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47030C1Ev();
extern void _ZN7ee47030D1Ev();
Name_Map name_map_ee47030[] = {
  NSPAIR(_ZN7ee47030C1Ev),
  NSPAIR(_ZN7ee47030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee47030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47030[];
extern void _ZN7ee470303barEv();
extern void _ZN6dd70303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47030[0]),
  (VTBL_ENTRY)&_ZN7ee470303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern VTBL_ENTRY _ZTV7ee47030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee47030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee47030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee47030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee47030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee47030[] = {
  {&(_ZTV7ee47030[4]),  4,11},
  {&(_tg__ZTV6dd7030__7ee47030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee47030[4]),  4,5},
  {&(_ZTV7ee47030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee47030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee47030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee47030[];
extern  VTBL_ENTRY _ZTV7ee47030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47030[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47030 = {  "ee47030", // class name
  bases_ee47030, 4,
  &(vtc_ee47030[0]), // expected_vtbl_contents
  &(vtt_ee47030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57030  : virtual dd7030 {
  int e;
  virtual void  bar(); // _ZN7ee570303barEv
  ~ee57030(); // tgen
  ee57030(); // tgen
};
//SIG(1 ee57030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57030 ::bar(){vfunc_called(this, "_ZN7ee570303barEv");}
ee57030 ::~ee57030(){ note_dtor("ee57030", this);} // tgen
ee57030 ::ee57030(){ note_ctor("ee57030", this);} // tgen

static void Test_ee57030()
{
  extern Class_Descriptor cd_ee57030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57030, buf);
    ee57030 *dp, &lv = *(dp=new (buf) ee57030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee57030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee57030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(32,16), "ee57030");
    check_base_class_offset(lv, (dd7030*), ABISELECT(16,8), "ee57030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57030.e");
    test_class_info(&lv, &cd_ee57030);
    dp->~ee57030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57030(Test_ee57030, "ee57030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57030C1Ev();
extern void _ZN7ee57030D1Ev();
Name_Map name_map_ee57030[] = {
  NSPAIR(_ZN7ee57030C1Ev),
  NSPAIR(_ZN7ee57030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee57030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57030[];
extern void _ZN7ee570303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee570303barEv,_ZTv0_n20_N7ee570303barEv)();
extern void ABISELECT(_ZThn16_N7ee570303barEv,_ZThn8_N7ee570303barEv)() __attribute__((weak));
extern void _ZN6dd70303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57030[0]),
  (VTBL_ENTRY)&_ZN7ee570303barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee570303barEv,_ZTv0_n20_N7ee570303barEv),
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern VTBL_ENTRY _ZTV7ee57030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee57030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee57030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee57030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee57030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee57030[] = {
  {&(_ZTV7ee57030[5]),  5,19},
  {&(_ZTV7ee57030[12]),  12,19},
  {&(_ZTV7ee57030[18]),  18,19},
  {&(_tg__ZTV6dd7030__7ee57030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee57030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee57030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee57030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57030[];
extern  VTBL_ENTRY _ZTV7ee57030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57030[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee570303barEv,_ZTv0_n20_N7ee570303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570303barEv,_ZThn8_N7ee570303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57030 = {  "ee57030", // class name
  bases_ee57030, 4,
  &(vtc_ee57030[0]), // expected_vtbl_contents
  &(vtt_ee57030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57030),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67030  : dd7030 {
  int e;
  virtual void  foo(); // _ZN7ee670303fooEv
  virtual void  bar(); // _ZN7ee670303barEv
  ~ee67030(); // tgen
  ee67030(); // tgen
};
//SIG(1 ee67030) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67030 ::foo(){vfunc_called(this, "_ZN7ee670303fooEv");}
void  ee67030 ::bar(){vfunc_called(this, "_ZN7ee670303barEv");}
ee67030 ::~ee67030(){ note_dtor("ee67030", this);} // tgen
ee67030 ::ee67030(){ note_ctor("ee67030", this);} // tgen

static void Test_ee67030()
{
  extern Class_Descriptor cd_ee67030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67030, buf);
    ee67030 *dp, &lv = *(dp=new (buf) ee67030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(32,24), "ee67030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(16,12), "ee67030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(16,12), "ee67030");
    check_base_class_offset(lv, (dd7030*), 0, "ee67030");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67030.e");
    test_class_info(&lv, &cd_ee67030);
    dp->~ee67030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67030(Test_ee67030, "ee67030", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67030C1Ev();
extern void _ZN7ee67030D1Ev();
Name_Map name_map_ee67030[] = {
  NSPAIR(_ZN7ee67030C1Ev),
  NSPAIR(_ZN7ee67030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee67030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67030[];
extern void _ZN7ee670303barEv();
extern void _ZN7ee670303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee670303fooEv,_ZTv0_n16_N7ee670303fooEv)();
extern void ABISELECT(_ZThn16_N7ee670303fooEv,_ZThn12_N7ee670303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67030[0]),
  (VTBL_ENTRY)&_ZN7ee670303barEv,
  (VTBL_ENTRY)&_ZN7ee670303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee670303fooEv,_ZTv0_n16_N7ee670303fooEv),
};
extern VTBL_ENTRY _ZTV7ee67030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee67030[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee67030[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee67030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee67030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee67030[] = {
  {&(_ZTV7ee67030[4]),  4,11},
  {&(_tg__ZTV6dd7030__7ee67030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee67030[4]),  4,5},
  {&(_ZTV7ee67030[10]),  10,11},
  {&(_tg__ZTV5cc030__7ee67030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee67030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee67030[];
extern  VTBL_ENTRY _ZTV7ee67030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67030[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn12_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee670303fooEv,_ZTv0_n16_N7ee670303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670303fooEv,_ZThn12_N7ee670303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67030 = {  "ee67030", // class name
  bases_ee67030, 4,
  &(vtc_ee67030[0]), // expected_vtbl_contents
  &(vtt_ee67030[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67030),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67030),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67030),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77030  : virtual dd7030 {
  int e;
  virtual void  foo(); // _ZN7ee770303fooEv
  virtual void  bar(); // _ZN7ee770303barEv
  ~ee77030(); // tgen
  ee77030(); // tgen
};
//SIG(1 ee77030) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77030 ::foo(){vfunc_called(this, "_ZN7ee770303fooEv");}
void  ee77030 ::bar(){vfunc_called(this, "_ZN7ee770303barEv");}
ee77030 ::~ee77030(){ note_dtor("ee77030", this);} // tgen
ee77030 ::ee77030(){ note_ctor("ee77030", this);} // tgen

static void Test_ee77030()
{
  extern Class_Descriptor cd_ee77030;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77030, buf);
    ee77030 *dp, &lv = *(dp=new (buf) ee77030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77030)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77030)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc030*), ABISELECT(48,28), "ee77030");
    check_base_class_offset(lv, (bb30*)(cc030*), ABISELECT(32,16), "ee77030");
    check_base_class_offset(lv, (cc030*)(dd7030*), ABISELECT(32,16), "ee77030");
    check_base_class_offset(lv, (dd7030*), ABISELECT(16,8), "ee77030");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77030.e");
    test_class_info(&lv, &cd_ee77030);
    dp->~ee77030();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77030(Test_ee77030, "ee77030", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77030C1Ev();
extern void _ZN7ee77030D1Ev();
Name_Map name_map_ee77030[] = {
  NSPAIR(_ZN7ee77030C1Ev),
  NSPAIR(_ZN7ee77030D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc030;
extern VTBL_ENTRY _ZTI5cc030[];
extern  VTBL_ENTRY _ZTV5cc030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc030[];
extern Class_Descriptor cd_dd7030;
extern VTBL_ENTRY _ZTI6dd7030[];
extern  VTBL_ENTRY _ZTV6dd7030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7030[];
static Base_Class bases_ee77030[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc030,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7030,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77030[];
extern void _ZN7ee770303fooEv();
extern void _ZN7ee770303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee770303barEv,_ZTv0_n20_N7ee770303barEv)();
extern void ABISELECT(_ZThn16_N7ee770303barEv,_ZThn8_N7ee770303barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee770303fooEv,_ZTv0_n24_N7ee770303fooEv)();
extern void ABISELECT(_ZThn16_N7ee770303fooEv,_ZThn8_N7ee770303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee770303fooEv,_ZTv0_n16_N7ee770303fooEv)();
extern void ABISELECT(_ZThn32_N7ee770303fooEv,_ZThn16_N7ee770303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77030[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77030[0]),
  (VTBL_ENTRY)&_ZN7ee770303fooEv,
  (VTBL_ENTRY)&_ZN7ee770303barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770303barEv,_ZTv0_n20_N7ee770303barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee770303fooEv,_ZTv0_n24_N7ee770303fooEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770303fooEv,_ZTv0_n16_N7ee770303fooEv),
};
extern VTBL_ENTRY _ZTV7ee77030[];
extern void _ZN6dd70303barEv();
extern void _ZN6dd70303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7030__7ee77030[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&_ZN6dd70303barEv,
  (VTBL_ENTRY)&_ZN6dd70303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv)();
extern void ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc030__6dd7030__7ee77030[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7030[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc030__7ee77030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc030[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc030__7ee77030[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee77030[] = {
  {&(_ZTV7ee77030[5]),  5,20},
  {&(_ZTV7ee77030[13]),  13,20},
  {&(_ZTV7ee77030[19]),  19,20},
  {&(_tg__ZTV6dd7030__7ee77030[4]),  4,6},
  {&(_tg__ZTV5cc030__6dd7030__7ee77030[4]),  4,5},
  {&(_tg__ZTV5cc030__7ee77030[3]),  3,4},
  {&(_tg__ZTV4bb305cc030__7ee77030[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77030[];
extern  VTBL_ENTRY _ZTV7ee77030[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77030[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd70303fooEv,_ZTv0_n16_N6dd70303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70303fooEv,_ZThn8_N6dd70303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770303fooEv,_ZTv0_n16_N7ee770303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770303fooEv,_ZThn16_N7ee770303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee770303fooEv,_ZTv0_n24_N7ee770303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770303fooEv,_ZThn8_N7ee770303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770303barEv,_ZTv0_n20_N7ee770303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770303barEv,_ZThn8_N7ee770303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77030 = {  "ee77030", // class name
  bases_ee77030, 4,
  &(vtc_ee77030[0]), // expected_vtbl_contents
  &(vtt_ee77030[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77030),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77030),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77030),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc130  : virtual bb30 {
  int c;
  ~cc130(); // tgen
  cc130(); // tgen
};
//SIG(-1 cc130) C1{ VBC2{ VBC3{ Fi} v1 Fi} Fi}


cc130 ::~cc130(){ note_dtor("cc130", this);} // tgen
cc130 ::cc130(){ note_ctor("cc130", this);} // tgen

static void Test_cc130()
{
  extern Class_Descriptor cd_cc130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_cc130, buf);
    cc130 *dp, &lv = *(dp=new (buf) cc130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(cc130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(28,16), "cc130");
    check_base_class_offset(lv, (bb30*), ABISELECT(16,8), "cc130");
    check_field_offset(lv, c, ABISELECT(8,4), "cc130.c");
    test_class_info(&lv, &cd_cc130);
    dp->~cc130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc130(Test_cc130, "cc130", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN5cc130C1Ev();
extern void _ZN5cc130D1Ev();
Name_Map name_map_cc130[] = {
  NSPAIR(_ZN5cc130C1Ev),
  NSPAIR(_ZN5cc130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
static Base_Class bases_cc130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_cc130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV5cc130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_cc130[] = {
  {&(_ZTV5cc130[4]),  4,9},
  {&(_ZTV5cc130[8]),  8,9},
  {&(_tg__ZTV4bb30__5cc130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
Class_Descriptor cd_cc130 = {  "cc130", // class name
  bases_cc130, 2,
  &(vtc_cc130[0]), // expected_vtbl_contents
  &(vtt_cc130[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI5cc130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc130),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc130),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0130  : cc130 {
  int d;
  ~dd0130(); // tgen
  dd0130(); // tgen
};
//SIG(-1 dd0130) C1{ BC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd0130 ::~dd0130(){ note_dtor("dd0130", this);} // tgen
dd0130 ::dd0130(){ note_ctor("dd0130", this);} // tgen

static void Test_dd0130()
{
  extern Class_Descriptor cd_dd0130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd0130, buf);
    dd0130 *dp, &lv = *(dp=new (buf) dd0130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd0130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(28,20), "dd0130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(16,12), "dd0130");
    check_base_class_offset(lv, (cc130*), 0, "dd0130");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0130.d");
    test_class_info(&lv, &cd_dd0130);
    dp->~dd0130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0130(Test_dd0130, "dd0130", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd0130C1Ev();
extern void _ZN6dd0130D1Ev();
Name_Map name_map_dd0130[] = {
  NSPAIR(_ZN6dd0130C1Ev),
  NSPAIR(_ZN6dd0130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd0130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_dd0130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV6dd0130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd0130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd0130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd0130[] = {
  {&(_ZTV6dd0130[4]),  4,9},
  {&(_tg__ZTV5cc130__6dd0130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd0130[4]),  4,5},
  {&(_ZTV6dd0130[8]),  8,9},
  {&(_tg__ZTV4bb30__6dd0130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
Class_Descriptor cd_dd0130 = {  "dd0130", // class name
  bases_dd0130, 3,
  &(vtc_dd0130[0]), // expected_vtbl_contents
  &(vtt_dd0130[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd0130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0130),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0130),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00130  : dd0130 {
  int e;
  ~ee00130(); // tgen
  ee00130(); // tgen
};
//SIG(1 ee00130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00130 ::~ee00130(){ note_dtor("ee00130", this);} // tgen
ee00130 ::ee00130(){ note_ctor("ee00130", this);} // tgen

static void Test_ee00130()
{
  extern Class_Descriptor cd_ee00130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee00130, buf);
    ee00130 *dp, &lv = *(dp=new (buf) ee00130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee00130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee00130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(24,16), "ee00130");
    check_base_class_offset(lv, (cc130*)(dd0130*), 0, "ee00130");
    check_base_class_offset(lv, (dd0130*), 0, "ee00130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00130.e");
    test_class_info(&lv, &cd_ee00130);
    dp->~ee00130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00130(Test_ee00130, "ee00130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee00130C1Ev();
extern void _ZN7ee00130D1Ev();
Name_Map name_map_ee00130[] = {
  NSPAIR(_ZN7ee00130C1Ev),
  NSPAIR(_ZN7ee00130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee00130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee00130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee00130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee00130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee00130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee00130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee00130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee00130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee00130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee00130[] = {
  {&(_ZTV7ee00130[4]),  4,9},
  {&(_tg__ZTV6dd0130__7ee00130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee00130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee00130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee00130[4]),  4,5},
  {&(_ZTV7ee00130[8]),  8,9},
  {&(_tg__ZTV4bb30__7ee00130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee00130[];
extern  VTBL_ENTRY _ZTV7ee00130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00130[];
Class_Descriptor cd_ee00130 = {  "ee00130", // class name
  bases_ee00130, 4,
  &(vtc_ee00130[0]), // expected_vtbl_contents
  &(vtt_ee00130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee00130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00130),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10130  : virtual dd0130 {
  int e;
  ~ee10130(); // tgen
  ee10130(); // tgen
};
//SIG(1 ee10130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10130 ::~ee10130(){ note_dtor("ee10130", this);} // tgen
ee10130 ::ee10130(){ note_ctor("ee10130", this);} // tgen

static void Test_ee10130()
{
  extern Class_Descriptor cd_ee10130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee10130, buf);
    ee10130 *dp, &lv = *(dp=new (buf) ee10130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee10130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee10130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(32,20), "ee10130");
    check_base_class_offset(lv, (cc130*)(dd0130*), ABISELECT(16,8), "ee10130");
    check_base_class_offset(lv, (dd0130*), ABISELECT(16,8), "ee10130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10130.e");
    test_class_info(&lv, &cd_ee10130);
    dp->~ee10130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10130(Test_ee10130, "ee10130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee10130C1Ev();
extern void _ZN7ee10130D1Ev();
Name_Map name_map_ee10130[] = {
  NSPAIR(_ZN7ee10130C1Ev),
  NSPAIR(_ZN7ee10130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee10130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee10130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10130[0]),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee10130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee10130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee10130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee10130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee10130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee10130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee10130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee10130[] = {
  {&(_ZTV7ee10130[5]),  5,14},
  {&(_ZTV7ee10130[9]),  9,14},
  {&(_ZTV7ee10130[13]),  13,14},
  {&(_tg__ZTV6dd0130__7ee10130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee10130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee10130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee10130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee10130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10130[];
extern  VTBL_ENTRY _ZTV7ee10130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10130[];
Class_Descriptor cd_ee10130 = {  "ee10130", // class name
  bases_ee10130, 4,
  &(vtc_ee10130[0]), // expected_vtbl_contents
  &(vtt_ee10130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee10130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10130),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20130  : dd0130 {
  int e;
  virtual void  foo(); // _ZN7ee201303fooEv
  ~ee20130(); // tgen
  ee20130(); // tgen
};
//SIG(1 ee20130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee20130 ::foo(){vfunc_called(this, "_ZN7ee201303fooEv");}
ee20130 ::~ee20130(){ note_dtor("ee20130", this);} // tgen
ee20130 ::ee20130(){ note_ctor("ee20130", this);} // tgen

static void Test_ee20130()
{
  extern Class_Descriptor cd_ee20130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee20130, buf);
    ee20130 *dp, &lv = *(dp=new (buf) ee20130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee20130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee20130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(24,16), "ee20130");
    check_base_class_offset(lv, (cc130*)(dd0130*), 0, "ee20130");
    check_base_class_offset(lv, (dd0130*), 0, "ee20130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20130.e");
    test_class_info(&lv, &cd_ee20130);
    dp->~ee20130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20130(Test_ee20130, "ee20130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee20130C1Ev();
extern void _ZN7ee20130D1Ev();
Name_Map name_map_ee20130[] = {
  NSPAIR(_ZN7ee20130C1Ev),
  NSPAIR(_ZN7ee20130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee20130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20130[];
extern void _ZN7ee201303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee201303fooEv,_ZTv0_n16_N7ee201303fooEv)();
extern void ABISELECT(_ZThn24_N7ee201303fooEv,_ZThn16_N7ee201303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee20130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20130[0]),
  (VTBL_ENTRY)&_ZN7ee201303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee20130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee201303fooEv,_ZTv0_n16_N7ee201303fooEv),
};
extern VTBL_ENTRY _ZTV7ee20130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee20130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee20130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee20130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee20130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee20130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee20130[] = {
  {&(_ZTV7ee20130[4]),  4,10},
  {&(_tg__ZTV6dd0130__7ee20130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee20130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee20130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee20130[4]),  4,5},
  {&(_ZTV7ee20130[9]),  9,10},
  {&(_tg__ZTV4bb30__7ee20130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee20130[];
extern  VTBL_ENTRY _ZTV7ee20130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20130[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee201303fooEv,_ZTv0_n16_N7ee201303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee201303fooEv,_ZThn16_N7ee201303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee20130 = {  "ee20130", // class name
  bases_ee20130, 4,
  &(vtc_ee20130[0]), // expected_vtbl_contents
  &(vtt_ee20130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee20130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30130  : virtual dd0130 {
  int e;
  virtual void  foo(); // _ZN7ee301303fooEv
  ~ee30130(); // tgen
  ee30130(); // tgen
};
//SIG(1 ee30130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee30130 ::foo(){vfunc_called(this, "_ZN7ee301303fooEv");}
ee30130 ::~ee30130(){ note_dtor("ee30130", this);} // tgen
ee30130 ::ee30130(){ note_ctor("ee30130", this);} // tgen

static void Test_ee30130()
{
  extern Class_Descriptor cd_ee30130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee30130, buf);
    ee30130 *dp, &lv = *(dp=new (buf) ee30130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee30130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee30130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(32,20), "ee30130");
    check_base_class_offset(lv, (cc130*)(dd0130*), ABISELECT(16,8), "ee30130");
    check_base_class_offset(lv, (dd0130*), ABISELECT(16,8), "ee30130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30130.e");
    test_class_info(&lv, &cd_ee30130);
    dp->~ee30130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30130(Test_ee30130, "ee30130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee30130C1Ev();
extern void _ZN7ee30130D1Ev();
Name_Map name_map_ee30130[] = {
  NSPAIR(_ZN7ee30130C1Ev),
  NSPAIR(_ZN7ee30130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee30130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30130[];
extern void _ZN7ee301303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee301303fooEv,_ZTv0_n16_N7ee301303fooEv)();
extern void ABISELECT(_ZThn32_N7ee301303fooEv,_ZThn20_N7ee301303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30130[0]),
  (VTBL_ENTRY)&_ZN7ee301303fooEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee30130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee301303fooEv,_ZTv0_n16_N7ee301303fooEv),
};
extern VTBL_ENTRY _ZTV7ee30130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee30130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee30130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee30130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee30130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee30130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee30130[] = {
  {&(_ZTV7ee30130[5]),  5,15},
  {&(_ZTV7ee30130[10]),  10,15},
  {&(_ZTV7ee30130[14]),  14,15},
  {&(_tg__ZTV6dd0130__7ee30130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee30130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee30130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee30130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee30130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30130[];
extern  VTBL_ENTRY _ZTV7ee30130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30130[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee301303fooEv,_ZTv0_n16_N7ee301303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee301303fooEv,_ZThn20_N7ee301303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30130 = {  "ee30130", // class name
  bases_ee30130, 4,
  &(vtc_ee30130[0]), // expected_vtbl_contents
  &(vtt_ee30130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee30130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40130  : dd0130 {
  int e;
  virtual void  bar(); // _ZN7ee401303barEv
  ~ee40130(); // tgen
  ee40130(); // tgen
};
//SIG(1 ee40130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee40130 ::bar(){vfunc_called(this, "_ZN7ee401303barEv");}
ee40130 ::~ee40130(){ note_dtor("ee40130", this);} // tgen
ee40130 ::ee40130(){ note_ctor("ee40130", this);} // tgen

static void Test_ee40130()
{
  extern Class_Descriptor cd_ee40130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee40130, buf);
    ee40130 *dp, &lv = *(dp=new (buf) ee40130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee40130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee40130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(24,16), "ee40130");
    check_base_class_offset(lv, (cc130*)(dd0130*), 0, "ee40130");
    check_base_class_offset(lv, (dd0130*), 0, "ee40130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40130.e");
    test_class_info(&lv, &cd_ee40130);
    dp->~ee40130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40130(Test_ee40130, "ee40130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee40130C1Ev();
extern void _ZN7ee40130D1Ev();
Name_Map name_map_ee40130[] = {
  NSPAIR(_ZN7ee40130C1Ev),
  NSPAIR(_ZN7ee40130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee40130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40130[];
extern void _ZN7ee401303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee40130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40130[0]),
  (VTBL_ENTRY)&_ZN7ee401303barEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee40130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee40130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee40130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee40130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee40130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee40130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee40130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee40130[] = {
  {&(_ZTV7ee40130[4]),  4,10},
  {&(_tg__ZTV6dd0130__7ee40130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee40130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee40130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee40130[4]),  4,5},
  {&(_ZTV7ee40130[9]),  9,10},
  {&(_tg__ZTV4bb30__7ee40130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee40130[];
extern  VTBL_ENTRY _ZTV7ee40130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40130[];
Class_Descriptor cd_ee40130 = {  "ee40130", // class name
  bases_ee40130, 4,
  &(vtc_ee40130[0]), // expected_vtbl_contents
  &(vtt_ee40130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee40130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50130  : virtual dd0130 {
  int e;
  virtual void  bar(); // _ZN7ee501303barEv
  ~ee50130(); // tgen
  ee50130(); // tgen
};
//SIG(1 ee50130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee50130 ::bar(){vfunc_called(this, "_ZN7ee501303barEv");}
ee50130 ::~ee50130(){ note_dtor("ee50130", this);} // tgen
ee50130 ::ee50130(){ note_ctor("ee50130", this);} // tgen

static void Test_ee50130()
{
  extern Class_Descriptor cd_ee50130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee50130, buf);
    ee50130 *dp, &lv = *(dp=new (buf) ee50130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee50130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee50130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(32,20), "ee50130");
    check_base_class_offset(lv, (cc130*)(dd0130*), ABISELECT(16,8), "ee50130");
    check_base_class_offset(lv, (dd0130*), ABISELECT(16,8), "ee50130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50130.e");
    test_class_info(&lv, &cd_ee50130);
    dp->~ee50130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50130(Test_ee50130, "ee50130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee50130C1Ev();
extern void _ZN7ee50130D1Ev();
Name_Map name_map_ee50130[] = {
  NSPAIR(_ZN7ee50130C1Ev),
  NSPAIR(_ZN7ee50130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee50130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50130[];
extern void _ZN7ee501303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee50130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50130[0]),
  (VTBL_ENTRY)&_ZN7ee501303barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee50130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee50130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee50130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee50130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee50130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee50130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee50130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee50130[] = {
  {&(_ZTV7ee50130[5]),  5,15},
  {&(_ZTV7ee50130[10]),  10,15},
  {&(_ZTV7ee50130[14]),  14,15},
  {&(_tg__ZTV6dd0130__7ee50130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee50130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee50130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee50130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee50130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50130[];
extern  VTBL_ENTRY _ZTV7ee50130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50130[];
Class_Descriptor cd_ee50130 = {  "ee50130", // class name
  bases_ee50130, 4,
  &(vtc_ee50130[0]), // expected_vtbl_contents
  &(vtt_ee50130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee50130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60130  : dd0130 {
  int e;
  virtual void  foo(); // _ZN7ee601303fooEv
  virtual void  bar(); // _ZN7ee601303barEv
  ~ee60130(); // tgen
  ee60130(); // tgen
};
//SIG(1 ee60130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60130 ::foo(){vfunc_called(this, "_ZN7ee601303fooEv");}
void  ee60130 ::bar(){vfunc_called(this, "_ZN7ee601303barEv");}
ee60130 ::~ee60130(){ note_dtor("ee60130", this);} // tgen
ee60130 ::ee60130(){ note_ctor("ee60130", this);} // tgen

static void Test_ee60130()
{
  extern Class_Descriptor cd_ee60130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee60130, buf);
    ee60130 *dp, &lv = *(dp=new (buf) ee60130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee60130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee60130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(24,16), "ee60130");
    check_base_class_offset(lv, (cc130*)(dd0130*), 0, "ee60130");
    check_base_class_offset(lv, (dd0130*), 0, "ee60130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60130.e");
    test_class_info(&lv, &cd_ee60130);
    dp->~ee60130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60130(Test_ee60130, "ee60130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee60130C1Ev();
extern void _ZN7ee60130D1Ev();
Name_Map name_map_ee60130[] = {
  NSPAIR(_ZN7ee60130C1Ev),
  NSPAIR(_ZN7ee60130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee60130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60130[];
extern void _ZN7ee601303fooEv();
extern void _ZN7ee601303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee601303fooEv,_ZTv0_n16_N7ee601303fooEv)();
extern void ABISELECT(_ZThn24_N7ee601303fooEv,_ZThn16_N7ee601303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee60130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60130[0]),
  (VTBL_ENTRY)&_ZN7ee601303fooEv,
  (VTBL_ENTRY)&_ZN7ee601303barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee60130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee601303fooEv,_ZTv0_n16_N7ee601303fooEv),
};
extern VTBL_ENTRY _ZTV7ee60130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee60130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee60130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee60130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee60130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee60130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee60130[] = {
  {&(_ZTV7ee60130[4]),  4,11},
  {&(_tg__ZTV6dd0130__7ee60130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee60130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee60130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee60130[4]),  4,5},
  {&(_ZTV7ee60130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee60130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee60130[];
extern  VTBL_ENTRY _ZTV7ee60130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60130[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee601303fooEv,_ZTv0_n16_N7ee601303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601303fooEv,_ZThn16_N7ee601303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee60130 = {  "ee60130", // class name
  bases_ee60130, 4,
  &(vtc_ee60130[0]), // expected_vtbl_contents
  &(vtt_ee60130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee60130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70130  : virtual dd0130 {
  int e;
  virtual void  foo(); // _ZN7ee701303fooEv
  virtual void  bar(); // _ZN7ee701303barEv
  ~ee70130(); // tgen
  ee70130(); // tgen
};
//SIG(1 ee70130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70130 ::foo(){vfunc_called(this, "_ZN7ee701303fooEv");}
void  ee70130 ::bar(){vfunc_called(this, "_ZN7ee701303barEv");}
ee70130 ::~ee70130(){ note_dtor("ee70130", this);} // tgen
ee70130 ::ee70130(){ note_ctor("ee70130", this);} // tgen

static void Test_ee70130()
{
  extern Class_Descriptor cd_ee70130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee70130, buf);
    ee70130 *dp, &lv = *(dp=new (buf) ee70130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee70130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee70130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd0130*), ABISELECT(32,20), "ee70130");
    check_base_class_offset(lv, (cc130*)(dd0130*), ABISELECT(16,8), "ee70130");
    check_base_class_offset(lv, (dd0130*), ABISELECT(16,8), "ee70130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70130.e");
    test_class_info(&lv, &cd_ee70130);
    dp->~ee70130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70130(Test_ee70130, "ee70130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee70130C1Ev();
extern void _ZN7ee70130D1Ev();
Name_Map name_map_ee70130[] = {
  NSPAIR(_ZN7ee70130C1Ev),
  NSPAIR(_ZN7ee70130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd0130;
extern VTBL_ENTRY _ZTI6dd0130[];
extern  VTBL_ENTRY _ZTV6dd0130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0130[];
static Base_Class bases_ee70130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70130[];
extern void _ZN7ee701303fooEv();
extern void _ZN7ee701303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee701303fooEv,_ZTv0_n16_N7ee701303fooEv)();
extern void ABISELECT(_ZThn32_N7ee701303fooEv,_ZThn20_N7ee701303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70130[0]),
  (VTBL_ENTRY)&_ZN7ee701303fooEv,
  (VTBL_ENTRY)&_ZN7ee701303barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee70130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee701303fooEv,_ZTv0_n16_N7ee701303fooEv),
};
extern VTBL_ENTRY _ZTV7ee70130[];
static  VTBL_ENTRY _tg__ZTV6dd0130__7ee70130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd0130__7ee70130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd0130__7ee70130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd0130__7ee70130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee70130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee70130[] = {
  {&(_ZTV7ee70130[5]),  5,16},
  {&(_ZTV7ee70130[11]),  11,16},
  {&(_ZTV7ee70130[15]),  15,16},
  {&(_tg__ZTV6dd0130__7ee70130[4]),  4,4},
  {&(_tg__ZTV5cc1306dd0130__7ee70130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd0130__7ee70130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd0130__7ee70130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee70130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70130[];
extern  VTBL_ENTRY _ZTV7ee70130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70130[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee701303fooEv,_ZTv0_n16_N7ee701303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701303fooEv,_ZThn20_N7ee701303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70130 = {  "ee70130", // class name
  bases_ee70130, 4,
  &(vtc_ee70130[0]), // expected_vtbl_contents
  &(vtt_ee70130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee70130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1130  : virtual cc130 {
  int d;
  ~dd1130(); // tgen
  dd1130(); // tgen
};
//SIG(-1 dd1130) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} Fi}


dd1130 ::~dd1130(){ note_dtor("dd1130", this);} // tgen
dd1130 ::dd1130(){ note_ctor("dd1130", this);} // tgen

static void Test_dd1130()
{
  extern Class_Descriptor cd_dd1130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd1130, buf);
    dd1130 *dp, &lv = *(dp=new (buf) dd1130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd1130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,24), "dd1130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,16), "dd1130");
    check_base_class_offset(lv, (cc130*), ABISELECT(16,8), "dd1130");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1130.d");
    test_class_info(&lv, &cd_dd1130);
    dp->~dd1130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1130(Test_dd1130, "dd1130", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd1130C1Ev();
extern void _ZN6dd1130D1Ev();
Name_Map name_map_dd1130[] = {
  NSPAIR(_ZN6dd1130C1Ev),
  NSPAIR(_ZN6dd1130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd1130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_dd1130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV6dd1130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd1130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd1130[] = {
  {&(_ZTV6dd1130[5]),  5,14},
  {&(_ZTV6dd1130[9]),  9,14},
  {&(_ZTV6dd1130[13]),  13,14},
  {&(_tg__ZTV5cc130__6dd1130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd1130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd1130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
Class_Descriptor cd_dd1130 = {  "dd1130", // class name
  bases_dd1130, 3,
  &(vtc_dd1130[0]), // expected_vtbl_contents
  &(vtt_dd1130[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd1130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1130),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1130),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01130  : dd1130 {
  int e;
  ~ee01130(); // tgen
  ee01130(); // tgen
};
//SIG(1 ee01130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01130 ::~ee01130(){ note_dtor("ee01130", this);} // tgen
ee01130 ::ee01130(){ note_ctor("ee01130", this);} // tgen

static void Test_ee01130()
{
  extern Class_Descriptor cd_ee01130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee01130, buf);
    ee01130 *dp, &lv = *(dp=new (buf) ee01130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee01130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee01130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee01130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(16,12), "ee01130");
    check_base_class_offset(lv, (dd1130*), 0, "ee01130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01130.e");
    test_class_info(&lv, &cd_ee01130);
    dp->~ee01130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01130(Test_ee01130, "ee01130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee01130C1Ev();
extern void _ZN7ee01130D1Ev();
Name_Map name_map_ee01130[] = {
  NSPAIR(_ZN7ee01130C1Ev),
  NSPAIR(_ZN7ee01130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee01130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee01130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01130[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee01130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee01130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee01130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee01130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee01130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee01130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee01130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee01130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee01130[] = {
  {&(_ZTV7ee01130[5]),  5,14},
  {&(_tg__ZTV6dd1130__7ee01130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee01130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee01130[4]),  4,5},
  {&(_ZTV7ee01130[9]),  9,14},
  {&(_ZTV7ee01130[13]),  13,14},
  {&(_tg__ZTV5cc130__7ee01130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee01130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee01130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01130[];
extern  VTBL_ENTRY _ZTV7ee01130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01130[];
Class_Descriptor cd_ee01130 = {  "ee01130", // class name
  bases_ee01130, 4,
  &(vtc_ee01130[0]), // expected_vtbl_contents
  &(vtt_ee01130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee01130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01130),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11130  : virtual dd1130 {
  int e;
  ~ee11130(); // tgen
  ee11130(); // tgen
};
//SIG(1 ee11130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11130 ::~ee11130(){ note_dtor("ee11130", this);} // tgen
ee11130 ::ee11130(){ note_ctor("ee11130", this);} // tgen

static void Test_ee11130()
{
  extern Class_Descriptor cd_ee11130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee11130, buf);
    ee11130 *dp, &lv = *(dp=new (buf) ee11130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee11130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee11130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee11130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(32,16), "ee11130");
    check_base_class_offset(lv, (dd1130*), ABISELECT(16,8), "ee11130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11130.e");
    test_class_info(&lv, &cd_ee11130);
    dp->~ee11130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11130(Test_ee11130, "ee11130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee11130C1Ev();
extern void _ZN7ee11130D1Ev();
Name_Map name_map_ee11130[] = {
  NSPAIR(_ZN7ee11130C1Ev),
  NSPAIR(_ZN7ee11130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee11130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11130[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee11130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11130[0]),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11130[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee11130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee11130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee11130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee11130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee11130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee11130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee11130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee11130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee11130[] = {
  {&(_ZTV7ee11130[6]),  6,20},
  {&(_ZTV7ee11130[11]),  11,20},
  {&(_ZTV7ee11130[15]),  15,20},
  {&(_ZTV7ee11130[19]),  19,20},
  {&(_tg__ZTV6dd1130__7ee11130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee11130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee11130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee11130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee11130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee11130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11130[];
extern  VTBL_ENTRY _ZTV7ee11130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11130[];
Class_Descriptor cd_ee11130 = {  "ee11130", // class name
  bases_ee11130, 4,
  &(vtc_ee11130[0]), // expected_vtbl_contents
  &(vtt_ee11130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee11130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11130),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21130  : dd1130 {
  int e;
  virtual void  foo(); // _ZN7ee211303fooEv
  ~ee21130(); // tgen
  ee21130(); // tgen
};
//SIG(1 ee21130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee21130 ::foo(){vfunc_called(this, "_ZN7ee211303fooEv");}
ee21130 ::~ee21130(){ note_dtor("ee21130", this);} // tgen
ee21130 ::ee21130(){ note_ctor("ee21130", this);} // tgen

static void Test_ee21130()
{
  extern Class_Descriptor cd_ee21130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee21130, buf);
    ee21130 *dp, &lv = *(dp=new (buf) ee21130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee21130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee21130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee21130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(16,12), "ee21130");
    check_base_class_offset(lv, (dd1130*), 0, "ee21130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21130.e");
    test_class_info(&lv, &cd_ee21130);
    dp->~ee21130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21130(Test_ee21130, "ee21130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee21130C1Ev();
extern void _ZN7ee21130D1Ev();
Name_Map name_map_ee21130[] = {
  NSPAIR(_ZN7ee21130C1Ev),
  NSPAIR(_ZN7ee21130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee21130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21130[];
extern void _ZN7ee211303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee211303fooEv,_ZTv0_n16_N7ee211303fooEv)();
extern void ABISELECT(_ZThn32_N7ee211303fooEv,_ZThn20_N7ee211303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21130[0]),
  (VTBL_ENTRY)&_ZN7ee211303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee21130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee211303fooEv,_ZTv0_n16_N7ee211303fooEv),
};
extern VTBL_ENTRY _ZTV7ee21130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee21130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee21130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee21130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee21130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee21130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee21130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee21130[] = {
  {&(_ZTV7ee21130[5]),  5,15},
  {&(_tg__ZTV6dd1130__7ee21130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee21130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee21130[4]),  4,5},
  {&(_ZTV7ee21130[10]),  10,15},
  {&(_ZTV7ee21130[14]),  14,15},
  {&(_tg__ZTV5cc130__7ee21130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee21130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee21130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21130[];
extern  VTBL_ENTRY _ZTV7ee21130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21130[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee211303fooEv,_ZTv0_n16_N7ee211303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee211303fooEv,_ZThn20_N7ee211303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21130 = {  "ee21130", // class name
  bases_ee21130, 4,
  &(vtc_ee21130[0]), // expected_vtbl_contents
  &(vtt_ee21130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee21130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31130  : virtual dd1130 {
  int e;
  virtual void  foo(); // _ZN7ee311303fooEv
  ~ee31130(); // tgen
  ee31130(); // tgen
};
//SIG(1 ee31130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee31130 ::foo(){vfunc_called(this, "_ZN7ee311303fooEv");}
ee31130 ::~ee31130(){ note_dtor("ee31130", this);} // tgen
ee31130 ::ee31130(){ note_ctor("ee31130", this);} // tgen

static void Test_ee31130()
{
  extern Class_Descriptor cd_ee31130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee31130, buf);
    ee31130 *dp, &lv = *(dp=new (buf) ee31130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee31130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee31130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee31130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(32,16), "ee31130");
    check_base_class_offset(lv, (dd1130*), ABISELECT(16,8), "ee31130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31130.e");
    test_class_info(&lv, &cd_ee31130);
    dp->~ee31130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31130(Test_ee31130, "ee31130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee31130C1Ev();
extern void _ZN7ee31130D1Ev();
Name_Map name_map_ee31130[] = {
  NSPAIR(_ZN7ee31130C1Ev),
  NSPAIR(_ZN7ee31130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee31130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31130[];
extern void _ZN7ee311303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee311303fooEv,_ZTv0_n16_N7ee311303fooEv)();
extern void ABISELECT(_ZThn48_N7ee311303fooEv,_ZThn24_N7ee311303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31130[0]),
  (VTBL_ENTRY)&_ZN7ee311303fooEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31130[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee31130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee311303fooEv,_ZTv0_n16_N7ee311303fooEv),
};
extern VTBL_ENTRY _ZTV7ee31130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee31130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee31130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee31130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee31130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee31130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee31130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee31130[] = {
  {&(_ZTV7ee31130[6]),  6,21},
  {&(_ZTV7ee31130[12]),  12,21},
  {&(_ZTV7ee31130[16]),  16,21},
  {&(_ZTV7ee31130[20]),  20,21},
  {&(_tg__ZTV6dd1130__7ee31130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee31130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee31130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee31130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee31130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee31130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31130[];
extern  VTBL_ENTRY _ZTV7ee31130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31130[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee311303fooEv,_ZTv0_n16_N7ee311303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee311303fooEv,_ZThn24_N7ee311303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31130 = {  "ee31130", // class name
  bases_ee31130, 4,
  &(vtc_ee31130[0]), // expected_vtbl_contents
  &(vtt_ee31130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee31130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31130),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41130  : dd1130 {
  int e;
  virtual void  bar(); // _ZN7ee411303barEv
  ~ee41130(); // tgen
  ee41130(); // tgen
};
//SIG(1 ee41130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee41130 ::bar(){vfunc_called(this, "_ZN7ee411303barEv");}
ee41130 ::~ee41130(){ note_dtor("ee41130", this);} // tgen
ee41130 ::ee41130(){ note_ctor("ee41130", this);} // tgen

static void Test_ee41130()
{
  extern Class_Descriptor cd_ee41130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee41130, buf);
    ee41130 *dp, &lv = *(dp=new (buf) ee41130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee41130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee41130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee41130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(16,12), "ee41130");
    check_base_class_offset(lv, (dd1130*), 0, "ee41130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41130.e");
    test_class_info(&lv, &cd_ee41130);
    dp->~ee41130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41130(Test_ee41130, "ee41130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee41130C1Ev();
extern void _ZN7ee41130D1Ev();
Name_Map name_map_ee41130[] = {
  NSPAIR(_ZN7ee41130C1Ev),
  NSPAIR(_ZN7ee41130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee41130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41130[];
extern void _ZN7ee411303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee41130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41130[0]),
  (VTBL_ENTRY)&_ZN7ee411303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee41130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee41130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee41130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee41130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee41130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee41130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee41130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee41130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee41130[] = {
  {&(_ZTV7ee41130[5]),  5,15},
  {&(_tg__ZTV6dd1130__7ee41130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee41130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee41130[4]),  4,5},
  {&(_ZTV7ee41130[10]),  10,15},
  {&(_ZTV7ee41130[14]),  14,15},
  {&(_tg__ZTV5cc130__7ee41130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee41130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee41130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41130[];
extern  VTBL_ENTRY _ZTV7ee41130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41130[];
Class_Descriptor cd_ee41130 = {  "ee41130", // class name
  bases_ee41130, 4,
  &(vtc_ee41130[0]), // expected_vtbl_contents
  &(vtt_ee41130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee41130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51130  : virtual dd1130 {
  int e;
  virtual void  bar(); // _ZN7ee511303barEv
  ~ee51130(); // tgen
  ee51130(); // tgen
};
//SIG(1 ee51130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee51130 ::bar(){vfunc_called(this, "_ZN7ee511303barEv");}
ee51130 ::~ee51130(){ note_dtor("ee51130", this);} // tgen
ee51130 ::ee51130(){ note_ctor("ee51130", this);} // tgen

static void Test_ee51130()
{
  extern Class_Descriptor cd_ee51130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee51130, buf);
    ee51130 *dp, &lv = *(dp=new (buf) ee51130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee51130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee51130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee51130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(32,16), "ee51130");
    check_base_class_offset(lv, (dd1130*), ABISELECT(16,8), "ee51130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51130.e");
    test_class_info(&lv, &cd_ee51130);
    dp->~ee51130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51130(Test_ee51130, "ee51130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee51130C1Ev();
extern void _ZN7ee51130D1Ev();
Name_Map name_map_ee51130[] = {
  NSPAIR(_ZN7ee51130C1Ev),
  NSPAIR(_ZN7ee51130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee51130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51130[];
extern void _ZN7ee511303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee51130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51130[0]),
  (VTBL_ENTRY)&_ZN7ee511303barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51130[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee51130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee51130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee51130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee51130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee51130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee51130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee51130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee51130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee51130[] = {
  {&(_ZTV7ee51130[6]),  6,21},
  {&(_ZTV7ee51130[12]),  12,21},
  {&(_ZTV7ee51130[16]),  16,21},
  {&(_ZTV7ee51130[20]),  20,21},
  {&(_tg__ZTV6dd1130__7ee51130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee51130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee51130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee51130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee51130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee51130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51130[];
extern  VTBL_ENTRY _ZTV7ee51130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51130[];
Class_Descriptor cd_ee51130 = {  "ee51130", // class name
  bases_ee51130, 4,
  &(vtc_ee51130[0]), // expected_vtbl_contents
  &(vtt_ee51130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee51130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51130),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61130  : dd1130 {
  int e;
  virtual void  foo(); // _ZN7ee611303fooEv
  virtual void  bar(); // _ZN7ee611303barEv
  ~ee61130(); // tgen
  ee61130(); // tgen
};
//SIG(1 ee61130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61130 ::foo(){vfunc_called(this, "_ZN7ee611303fooEv");}
void  ee61130 ::bar(){vfunc_called(this, "_ZN7ee611303barEv");}
ee61130 ::~ee61130(){ note_dtor("ee61130", this);} // tgen
ee61130 ::ee61130(){ note_ctor("ee61130", this);} // tgen

static void Test_ee61130()
{
  extern Class_Descriptor cd_ee61130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee61130, buf);
    ee61130 *dp, &lv = *(dp=new (buf) ee61130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee61130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee61130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee61130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(16,12), "ee61130");
    check_base_class_offset(lv, (dd1130*), 0, "ee61130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61130.e");
    test_class_info(&lv, &cd_ee61130);
    dp->~ee61130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61130(Test_ee61130, "ee61130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee61130C1Ev();
extern void _ZN7ee61130D1Ev();
Name_Map name_map_ee61130[] = {
  NSPAIR(_ZN7ee61130C1Ev),
  NSPAIR(_ZN7ee61130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee61130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61130[];
extern void _ZN7ee611303fooEv();
extern void _ZN7ee611303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee611303fooEv,_ZTv0_n16_N7ee611303fooEv)();
extern void ABISELECT(_ZThn32_N7ee611303fooEv,_ZThn20_N7ee611303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61130[0]),
  (VTBL_ENTRY)&_ZN7ee611303fooEv,
  (VTBL_ENTRY)&_ZN7ee611303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee61130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee611303fooEv,_ZTv0_n16_N7ee611303fooEv),
};
extern VTBL_ENTRY _ZTV7ee61130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee61130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee61130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee61130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee61130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee61130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee61130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee61130[] = {
  {&(_ZTV7ee61130[5]),  5,16},
  {&(_tg__ZTV6dd1130__7ee61130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee61130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee61130[4]),  4,5},
  {&(_ZTV7ee61130[11]),  11,16},
  {&(_ZTV7ee61130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee61130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee61130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee61130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61130[];
extern  VTBL_ENTRY _ZTV7ee61130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61130[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee611303fooEv,_ZTv0_n16_N7ee611303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611303fooEv,_ZThn20_N7ee611303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61130 = {  "ee61130", // class name
  bases_ee61130, 4,
  &(vtc_ee61130[0]), // expected_vtbl_contents
  &(vtt_ee61130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee61130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71130  : virtual dd1130 {
  int e;
  virtual void  foo(); // _ZN7ee711303fooEv
  virtual void  bar(); // _ZN7ee711303barEv
  ~ee71130(); // tgen
  ee71130(); // tgen
};
//SIG(1 ee71130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71130 ::foo(){vfunc_called(this, "_ZN7ee711303fooEv");}
void  ee71130 ::bar(){vfunc_called(this, "_ZN7ee711303barEv");}
ee71130 ::~ee71130(){ note_dtor("ee71130", this);} // tgen
ee71130 ::ee71130(){ note_ctor("ee71130", this);} // tgen

static void Test_ee71130()
{
  extern Class_Descriptor cd_ee71130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee71130, buf);
    ee71130 *dp, &lv = *(dp=new (buf) ee71130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee71130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee71130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee71130");
    check_base_class_offset(lv, (cc130*)(dd1130*), ABISELECT(32,16), "ee71130");
    check_base_class_offset(lv, (dd1130*), ABISELECT(16,8), "ee71130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71130.e");
    test_class_info(&lv, &cd_ee71130);
    dp->~ee71130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71130(Test_ee71130, "ee71130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee71130C1Ev();
extern void _ZN7ee71130D1Ev();
Name_Map name_map_ee71130[] = {
  NSPAIR(_ZN7ee71130C1Ev),
  NSPAIR(_ZN7ee71130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd1130;
extern VTBL_ENTRY _ZTI6dd1130[];
extern  VTBL_ENTRY _ZTV6dd1130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1130[];
static Base_Class bases_ee71130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1130,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71130[];
extern void _ZN7ee711303fooEv();
extern void _ZN7ee711303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee711303fooEv,_ZTv0_n16_N7ee711303fooEv)();
extern void ABISELECT(_ZThn48_N7ee711303fooEv,_ZThn24_N7ee711303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71130[0]),
  (VTBL_ENTRY)&_ZN7ee711303fooEv,
  (VTBL_ENTRY)&_ZN7ee711303barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71130[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee71130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee711303fooEv,_ZTv0_n16_N7ee711303fooEv),
};
extern VTBL_ENTRY _ZTV7ee71130[];
static  VTBL_ENTRY _tg__ZTV6dd1130__7ee71130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd1130__7ee71130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd1130__7ee71130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee71130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee71130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee71130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee71130[] = {
  {&(_ZTV7ee71130[6]),  6,22},
  {&(_ZTV7ee71130[13]),  13,22},
  {&(_ZTV7ee71130[17]),  17,22},
  {&(_ZTV7ee71130[21]),  21,22},
  {&(_tg__ZTV6dd1130__7ee71130[5]),  5,5},
  {&(_tg__ZTV5cc130__6dd1130__7ee71130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd1130__7ee71130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee71130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee71130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee71130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71130[];
extern  VTBL_ENTRY _ZTV7ee71130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71130[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee711303fooEv,_ZTv0_n16_N7ee711303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711303fooEv,_ZThn24_N7ee711303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71130 = {  "ee71130", // class name
  bases_ee71130, 4,
  &(vtc_ee71130[0]), // expected_vtbl_contents
  &(vtt_ee71130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee71130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71130),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2130  : cc130 {
  int d;
  virtual void  foo(); // _ZN6dd21303fooEv
  ~dd2130(); // tgen
  dd2130(); // tgen
};
//SIG(-1 dd2130) C1{ BC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd2130 ::foo(){vfunc_called(this, "_ZN6dd21303fooEv");}
dd2130 ::~dd2130(){ note_dtor("dd2130", this);} // tgen
dd2130 ::dd2130(){ note_ctor("dd2130", this);} // tgen

static void Test_dd2130()
{
  extern Class_Descriptor cd_dd2130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd2130, buf);
    dd2130 *dp, &lv = *(dp=new (buf) dd2130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd2130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(28,20), "dd2130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(16,12), "dd2130");
    check_base_class_offset(lv, (cc130*), 0, "dd2130");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2130.d");
    test_class_info(&lv, &cd_dd2130);
    dp->~dd2130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2130(Test_dd2130, "dd2130", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd2130C1Ev();
extern void _ZN6dd2130D1Ev();
Name_Map name_map_dd2130[] = {
  NSPAIR(_ZN6dd2130C1Ev),
  NSPAIR(_ZN6dd2130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd2130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2130[];
extern void _ZN6dd21303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd2130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern VTBL_ENTRY _ZTV6dd2130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd2130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd2130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd2130[] = {
  {&(_ZTV6dd2130[4]),  4,10},
  {&(_tg__ZTV5cc130__6dd2130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd2130[4]),  4,5},
  {&(_ZTV6dd2130[9]),  9,10},
  {&(_tg__ZTV4bb30__6dd2130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd2130 = {  "dd2130", // class name
  bases_dd2130, 3,
  &(vtc_dd2130[0]), // expected_vtbl_contents
  &(vtt_dd2130[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd2130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2130),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02130  : dd2130 {
  int e;
  ~ee02130(); // tgen
  ee02130(); // tgen
};
//SIG(1 ee02130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee02130 ::~ee02130(){ note_dtor("ee02130", this);} // tgen
ee02130 ::ee02130(){ note_ctor("ee02130", this);} // tgen

static void Test_ee02130()
{
  extern Class_Descriptor cd_ee02130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee02130, buf);
    ee02130 *dp, &lv = *(dp=new (buf) ee02130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee02130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee02130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(24,16), "ee02130");
    check_base_class_offset(lv, (cc130*)(dd2130*), 0, "ee02130");
    check_base_class_offset(lv, (dd2130*), 0, "ee02130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02130.e");
    test_class_info(&lv, &cd_ee02130);
    dp->~ee02130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02130(Test_ee02130, "ee02130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee02130C1Ev();
extern void _ZN7ee02130D1Ev();
Name_Map name_map_ee02130[] = {
  NSPAIR(_ZN7ee02130C1Ev),
  NSPAIR(_ZN7ee02130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee02130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02130[];
extern void _ZN6dd21303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee02130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee02130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern VTBL_ENTRY _ZTV7ee02130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee02130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee02130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee02130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee02130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee02130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee02130[] = {
  {&(_ZTV7ee02130[4]),  4,10},
  {&(_tg__ZTV6dd2130__7ee02130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee02130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee02130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee02130[4]),  4,5},
  {&(_ZTV7ee02130[9]),  9,10},
  {&(_tg__ZTV4bb30__7ee02130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee02130[];
extern  VTBL_ENTRY _ZTV7ee02130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02130[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee02130 = {  "ee02130", // class name
  bases_ee02130, 4,
  &(vtc_ee02130[0]), // expected_vtbl_contents
  &(vtt_ee02130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee02130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12130  : virtual dd2130 {
  int e;
  ~ee12130(); // tgen
  ee12130(); // tgen
};
//SIG(1 ee12130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee12130 ::~ee12130(){ note_dtor("ee12130", this);} // tgen
ee12130 ::ee12130(){ note_ctor("ee12130", this);} // tgen

static void Test_ee12130()
{
  extern Class_Descriptor cd_ee12130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee12130, buf);
    ee12130 *dp, &lv = *(dp=new (buf) ee12130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee12130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee12130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(32,20), "ee12130");
    check_base_class_offset(lv, (cc130*)(dd2130*), ABISELECT(16,8), "ee12130");
    check_base_class_offset(lv, (dd2130*), ABISELECT(16,8), "ee12130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12130.e");
    test_class_info(&lv, &cd_ee12130);
    dp->~ee12130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12130(Test_ee12130, "ee12130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee12130C1Ev();
extern void _ZN7ee12130D1Ev();
Name_Map name_map_ee12130[] = {
  NSPAIR(_ZN7ee12130C1Ev),
  NSPAIR(_ZN7ee12130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee12130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12130[];
extern void _ZN6dd21303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee12130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12130[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee12130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern VTBL_ENTRY _ZTV7ee12130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee12130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee12130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee12130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee12130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee12130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee12130[] = {
  {&(_ZTV7ee12130[5]),  5,16},
  {&(_ZTV7ee12130[10]),  10,16},
  {&(_ZTV7ee12130[15]),  15,16},
  {&(_tg__ZTV6dd2130__7ee12130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee12130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee12130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee12130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee12130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee12130[];
extern  VTBL_ENTRY _ZTV7ee12130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12130[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee12130 = {  "ee12130", // class name
  bases_ee12130, 4,
  &(vtc_ee12130[0]), // expected_vtbl_contents
  &(vtt_ee12130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee12130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22130  : dd2130 {
  int e;
  virtual void  foo(); // _ZN7ee221303fooEv
  ~ee22130(); // tgen
  ee22130(); // tgen
};
//SIG(1 ee22130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22130 ::foo(){vfunc_called(this, "_ZN7ee221303fooEv");}
ee22130 ::~ee22130(){ note_dtor("ee22130", this);} // tgen
ee22130 ::ee22130(){ note_ctor("ee22130", this);} // tgen

static void Test_ee22130()
{
  extern Class_Descriptor cd_ee22130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee22130, buf);
    ee22130 *dp, &lv = *(dp=new (buf) ee22130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee22130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee22130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(24,16), "ee22130");
    check_base_class_offset(lv, (cc130*)(dd2130*), 0, "ee22130");
    check_base_class_offset(lv, (dd2130*), 0, "ee22130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22130.e");
    test_class_info(&lv, &cd_ee22130);
    dp->~ee22130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22130(Test_ee22130, "ee22130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee22130C1Ev();
extern void _ZN7ee22130D1Ev();
Name_Map name_map_ee22130[] = {
  NSPAIR(_ZN7ee22130C1Ev),
  NSPAIR(_ZN7ee22130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee22130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22130[];
extern void _ZN7ee221303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee221303fooEv,_ZTv0_n16_N7ee221303fooEv)();
extern void ABISELECT(_ZThn24_N7ee221303fooEv,_ZThn16_N7ee221303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee22130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22130[0]),
  (VTBL_ENTRY)&_ZN7ee221303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee22130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee221303fooEv,_ZTv0_n16_N7ee221303fooEv),
};
extern VTBL_ENTRY _ZTV7ee22130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee22130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee22130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee22130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee22130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee22130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee22130[] = {
  {&(_ZTV7ee22130[4]),  4,10},
  {&(_tg__ZTV6dd2130__7ee22130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee22130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee22130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee22130[4]),  4,5},
  {&(_ZTV7ee22130[9]),  9,10},
  {&(_tg__ZTV4bb30__7ee22130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee22130[];
extern  VTBL_ENTRY _ZTV7ee22130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22130[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee221303fooEv,_ZTv0_n16_N7ee221303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee221303fooEv,_ZThn16_N7ee221303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee22130 = {  "ee22130", // class name
  bases_ee22130, 4,
  &(vtc_ee22130[0]), // expected_vtbl_contents
  &(vtt_ee22130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee22130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32130  : virtual dd2130 {
  int e;
  virtual void  foo(); // _ZN7ee321303fooEv
  ~ee32130(); // tgen
  ee32130(); // tgen
};
//SIG(1 ee32130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32130 ::foo(){vfunc_called(this, "_ZN7ee321303fooEv");}
ee32130 ::~ee32130(){ note_dtor("ee32130", this);} // tgen
ee32130 ::ee32130(){ note_ctor("ee32130", this);} // tgen

static void Test_ee32130()
{
  extern Class_Descriptor cd_ee32130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee32130, buf);
    ee32130 *dp, &lv = *(dp=new (buf) ee32130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee32130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee32130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(32,20), "ee32130");
    check_base_class_offset(lv, (cc130*)(dd2130*), ABISELECT(16,8), "ee32130");
    check_base_class_offset(lv, (dd2130*), ABISELECT(16,8), "ee32130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32130.e");
    test_class_info(&lv, &cd_ee32130);
    dp->~ee32130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32130(Test_ee32130, "ee32130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee32130C1Ev();
extern void _ZN7ee32130D1Ev();
Name_Map name_map_ee32130[] = {
  NSPAIR(_ZN7ee32130C1Ev),
  NSPAIR(_ZN7ee32130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee32130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32130[];
extern void _ZN7ee321303fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee321303fooEv,_ZTv0_n20_N7ee321303fooEv)();
extern void ABISELECT(_ZThn16_N7ee321303fooEv,_ZThn8_N7ee321303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee321303fooEv,_ZTv0_n16_N7ee321303fooEv)();
extern void ABISELECT(_ZThn32_N7ee321303fooEv,_ZThn20_N7ee321303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32130[0]),
  (VTBL_ENTRY)&_ZN7ee321303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee321303fooEv,_ZTv0_n20_N7ee321303fooEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee32130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee321303fooEv,_ZTv0_n16_N7ee321303fooEv),
};
extern VTBL_ENTRY _ZTV7ee32130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee32130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee32130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee32130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee32130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee32130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee32130[] = {
  {&(_ZTV7ee32130[5]),  5,17},
  {&(_ZTV7ee32130[11]),  11,17},
  {&(_ZTV7ee32130[16]),  16,17},
  {&(_tg__ZTV6dd2130__7ee32130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee32130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee32130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee32130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee32130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee32130[];
extern  VTBL_ENTRY _ZTV7ee32130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32130[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee321303fooEv,_ZTv0_n16_N7ee321303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee321303fooEv,_ZThn20_N7ee321303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee321303fooEv,_ZTv0_n20_N7ee321303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321303fooEv,_ZThn8_N7ee321303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32130 = {  "ee32130", // class name
  bases_ee32130, 4,
  &(vtc_ee32130[0]), // expected_vtbl_contents
  &(vtt_ee32130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee32130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32130),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42130  : dd2130 {
  int e;
  virtual void  bar(); // _ZN7ee421303barEv
  ~ee42130(); // tgen
  ee42130(); // tgen
};
//SIG(1 ee42130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42130 ::bar(){vfunc_called(this, "_ZN7ee421303barEv");}
ee42130 ::~ee42130(){ note_dtor("ee42130", this);} // tgen
ee42130 ::ee42130(){ note_ctor("ee42130", this);} // tgen

static void Test_ee42130()
{
  extern Class_Descriptor cd_ee42130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee42130, buf);
    ee42130 *dp, &lv = *(dp=new (buf) ee42130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee42130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee42130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(24,16), "ee42130");
    check_base_class_offset(lv, (cc130*)(dd2130*), 0, "ee42130");
    check_base_class_offset(lv, (dd2130*), 0, "ee42130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42130.e");
    test_class_info(&lv, &cd_ee42130);
    dp->~ee42130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42130(Test_ee42130, "ee42130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee42130C1Ev();
extern void _ZN7ee42130D1Ev();
Name_Map name_map_ee42130[] = {
  NSPAIR(_ZN7ee42130C1Ev),
  NSPAIR(_ZN7ee42130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee42130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42130[];
extern void _ZN6dd21303fooEv();
extern void _ZN7ee421303barEv();
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee42130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
  (VTBL_ENTRY)&_ZN7ee421303barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee42130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern VTBL_ENTRY _ZTV7ee42130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee42130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee42130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee42130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee42130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee42130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee42130[] = {
  {&(_ZTV7ee42130[4]),  4,11},
  {&(_tg__ZTV6dd2130__7ee42130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee42130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee42130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee42130[4]),  4,5},
  {&(_ZTV7ee42130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee42130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee42130[];
extern  VTBL_ENTRY _ZTV7ee42130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42130[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee42130 = {  "ee42130", // class name
  bases_ee42130, 4,
  &(vtc_ee42130[0]), // expected_vtbl_contents
  &(vtt_ee42130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee42130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52130  : virtual dd2130 {
  int e;
  virtual void  bar(); // _ZN7ee521303barEv
  ~ee52130(); // tgen
  ee52130(); // tgen
};
//SIG(1 ee52130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52130 ::bar(){vfunc_called(this, "_ZN7ee521303barEv");}
ee52130 ::~ee52130(){ note_dtor("ee52130", this);} // tgen
ee52130 ::ee52130(){ note_ctor("ee52130", this);} // tgen

static void Test_ee52130()
{
  extern Class_Descriptor cd_ee52130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee52130, buf);
    ee52130 *dp, &lv = *(dp=new (buf) ee52130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee52130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee52130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(32,20), "ee52130");
    check_base_class_offset(lv, (cc130*)(dd2130*), ABISELECT(16,8), "ee52130");
    check_base_class_offset(lv, (dd2130*), ABISELECT(16,8), "ee52130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52130.e");
    test_class_info(&lv, &cd_ee52130);
    dp->~ee52130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52130(Test_ee52130, "ee52130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee52130C1Ev();
extern void _ZN7ee52130D1Ev();
Name_Map name_map_ee52130[] = {
  NSPAIR(_ZN7ee52130C1Ev),
  NSPAIR(_ZN7ee52130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee52130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52130[];
extern void _ZN7ee521303barEv();
extern void _ZN6dd21303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee52130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52130[0]),
  (VTBL_ENTRY)&_ZN7ee521303barEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee52130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern VTBL_ENTRY _ZTV7ee52130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee52130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee52130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee52130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee52130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee52130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee52130[] = {
  {&(_ZTV7ee52130[5]),  5,17},
  {&(_ZTV7ee52130[11]),  11,17},
  {&(_ZTV7ee52130[16]),  16,17},
  {&(_tg__ZTV6dd2130__7ee52130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee52130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee52130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee52130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee52130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee52130[];
extern  VTBL_ENTRY _ZTV7ee52130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52130[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52130 = {  "ee52130", // class name
  bases_ee52130, 4,
  &(vtc_ee52130[0]), // expected_vtbl_contents
  &(vtt_ee52130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee52130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52130),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62130  : dd2130 {
  int e;
  virtual void  foo(); // _ZN7ee621303fooEv
  virtual void  bar(); // _ZN7ee621303barEv
  ~ee62130(); // tgen
  ee62130(); // tgen
};
//SIG(1 ee62130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62130 ::foo(){vfunc_called(this, "_ZN7ee621303fooEv");}
void  ee62130 ::bar(){vfunc_called(this, "_ZN7ee621303barEv");}
ee62130 ::~ee62130(){ note_dtor("ee62130", this);} // tgen
ee62130 ::ee62130(){ note_ctor("ee62130", this);} // tgen

static void Test_ee62130()
{
  extern Class_Descriptor cd_ee62130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee62130, buf);
    ee62130 *dp, &lv = *(dp=new (buf) ee62130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee62130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee62130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(24,16), "ee62130");
    check_base_class_offset(lv, (cc130*)(dd2130*), 0, "ee62130");
    check_base_class_offset(lv, (dd2130*), 0, "ee62130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62130.e");
    test_class_info(&lv, &cd_ee62130);
    dp->~ee62130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62130(Test_ee62130, "ee62130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee62130C1Ev();
extern void _ZN7ee62130D1Ev();
Name_Map name_map_ee62130[] = {
  NSPAIR(_ZN7ee62130C1Ev),
  NSPAIR(_ZN7ee62130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee62130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62130[];
extern void _ZN7ee621303fooEv();
extern void _ZN7ee621303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee621303fooEv,_ZTv0_n16_N7ee621303fooEv)();
extern void ABISELECT(_ZThn24_N7ee621303fooEv,_ZThn16_N7ee621303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee62130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62130[0]),
  (VTBL_ENTRY)&_ZN7ee621303fooEv,
  (VTBL_ENTRY)&_ZN7ee621303barEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee62130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee621303fooEv,_ZTv0_n16_N7ee621303fooEv),
};
extern VTBL_ENTRY _ZTV7ee62130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee62130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee62130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee62130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee62130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee62130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee62130[] = {
  {&(_ZTV7ee62130[4]),  4,11},
  {&(_tg__ZTV6dd2130__7ee62130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee62130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee62130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee62130[4]),  4,5},
  {&(_ZTV7ee62130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee62130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee62130[];
extern  VTBL_ENTRY _ZTV7ee62130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62130[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21303fooEv,_ZThn16_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee621303fooEv,_ZTv0_n16_N7ee621303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621303fooEv,_ZThn16_N7ee621303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee62130 = {  "ee62130", // class name
  bases_ee62130, 4,
  &(vtc_ee62130[0]), // expected_vtbl_contents
  &(vtt_ee62130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee62130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72130  : virtual dd2130 {
  int e;
  virtual void  foo(); // _ZN7ee721303fooEv
  virtual void  bar(); // _ZN7ee721303barEv
  ~ee72130(); // tgen
  ee72130(); // tgen
};
//SIG(1 ee72130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72130 ::foo(){vfunc_called(this, "_ZN7ee721303fooEv");}
void  ee72130 ::bar(){vfunc_called(this, "_ZN7ee721303barEv");}
ee72130 ::~ee72130(){ note_dtor("ee72130", this);} // tgen
ee72130 ::ee72130(){ note_ctor("ee72130", this);} // tgen

static void Test_ee72130()
{
  extern Class_Descriptor cd_ee72130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee72130, buf);
    ee72130 *dp, &lv = *(dp=new (buf) ee72130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee72130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee72130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd2130*), ABISELECT(32,20), "ee72130");
    check_base_class_offset(lv, (cc130*)(dd2130*), ABISELECT(16,8), "ee72130");
    check_base_class_offset(lv, (dd2130*), ABISELECT(16,8), "ee72130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72130.e");
    test_class_info(&lv, &cd_ee72130);
    dp->~ee72130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72130(Test_ee72130, "ee72130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee72130C1Ev();
extern void _ZN7ee72130D1Ev();
Name_Map name_map_ee72130[] = {
  NSPAIR(_ZN7ee72130C1Ev),
  NSPAIR(_ZN7ee72130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd2130;
extern VTBL_ENTRY _ZTI6dd2130[];
extern  VTBL_ENTRY _ZTV6dd2130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2130[];
static Base_Class bases_ee72130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72130[];
extern void _ZN7ee721303fooEv();
extern void _ZN7ee721303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee721303fooEv,_ZTv0_n20_N7ee721303fooEv)();
extern void ABISELECT(_ZThn16_N7ee721303fooEv,_ZThn8_N7ee721303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee721303fooEv,_ZTv0_n16_N7ee721303fooEv)();
extern void ABISELECT(_ZThn32_N7ee721303fooEv,_ZThn20_N7ee721303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72130[0]),
  (VTBL_ENTRY)&_ZN7ee721303fooEv,
  (VTBL_ENTRY)&_ZN7ee721303barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee721303fooEv,_ZTv0_n20_N7ee721303fooEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee72130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721303fooEv,_ZTv0_n16_N7ee721303fooEv),
};
extern VTBL_ENTRY _ZTV7ee72130[];
extern void _ZN6dd21303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2130__7ee72130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&_ZN6dd21303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd2130__7ee72130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd2130__7ee72130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv)();
extern void ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd2130__7ee72130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee72130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee72130[] = {
  {&(_ZTV7ee72130[5]),  5,18},
  {&(_ZTV7ee72130[12]),  12,18},
  {&(_ZTV7ee72130[17]),  17,18},
  {&(_tg__ZTV6dd2130__7ee72130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd2130__7ee72130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd2130__7ee72130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd2130__7ee72130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee72130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee72130[];
extern  VTBL_ENTRY _ZTV7ee72130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72130[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd21303fooEv,_ZTv0_n16_N6dd21303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21303fooEv,_ZThn12_N6dd21303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee721303fooEv,_ZTv0_n16_N7ee721303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721303fooEv,_ZThn20_N7ee721303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee721303fooEv,_ZTv0_n20_N7ee721303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721303fooEv,_ZThn8_N7ee721303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72130 = {  "ee72130", // class name
  bases_ee72130, 4,
  &(vtc_ee72130[0]), // expected_vtbl_contents
  &(vtt_ee72130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee72130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72130),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3130  : virtual cc130 {
  int d;
  virtual void  foo(); // _ZN6dd31303fooEv
  ~dd3130(); // tgen
  dd3130(); // tgen
};
//SIG(-1 dd3130) C1{ VBC2{ VBC3{ VBC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd3130 ::foo(){vfunc_called(this, "_ZN6dd31303fooEv");}
dd3130 ::~dd3130(){ note_dtor("dd3130", this);} // tgen
dd3130 ::dd3130(){ note_ctor("dd3130", this);} // tgen

static void Test_dd3130()
{
  extern Class_Descriptor cd_dd3130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd3130, buf);
    dd3130 *dp, &lv = *(dp=new (buf) dd3130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd3130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,24), "dd3130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,16), "dd3130");
    check_base_class_offset(lv, (cc130*), ABISELECT(16,8), "dd3130");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3130.d");
    test_class_info(&lv, &cd_dd3130);
    dp->~dd3130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3130(Test_dd3130, "dd3130", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd3130C1Ev();
extern void _ZN6dd3130D1Ev();
Name_Map name_map_dd3130[] = {
  NSPAIR(_ZN6dd3130C1Ev),
  NSPAIR(_ZN6dd3130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd3130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3130[];
extern void _ZN6dd31303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
extern VTBL_ENTRY _ZTV6dd3130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd3130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd3130[] = {
  {&(_ZTV6dd3130[5]),  5,15},
  {&(_ZTV6dd3130[10]),  10,15},
  {&(_ZTV6dd3130[14]),  14,15},
  {&(_tg__ZTV5cc130__6dd3130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd3130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd3130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3130 = {  "dd3130", // class name
  bases_dd3130, 3,
  &(vtc_dd3130[0]), // expected_vtbl_contents
  &(vtt_dd3130[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd3130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3130),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03130  : dd3130 {
  int e;
  ~ee03130(); // tgen
  ee03130(); // tgen
};
//SIG(1 ee03130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee03130 ::~ee03130(){ note_dtor("ee03130", this);} // tgen
ee03130 ::ee03130(){ note_ctor("ee03130", this);} // tgen

static void Test_ee03130()
{
  extern Class_Descriptor cd_ee03130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee03130, buf);
    ee03130 *dp, &lv = *(dp=new (buf) ee03130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee03130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee03130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee03130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(16,12), "ee03130");
    check_base_class_offset(lv, (dd3130*), 0, "ee03130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03130.e");
    test_class_info(&lv, &cd_ee03130);
    dp->~ee03130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03130(Test_ee03130, "ee03130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee03130C1Ev();
extern void _ZN7ee03130D1Ev();
Name_Map name_map_ee03130[] = {
  NSPAIR(_ZN7ee03130C1Ev),
  NSPAIR(_ZN7ee03130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee03130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03130[];
extern void _ZN6dd31303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee03130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
extern VTBL_ENTRY _ZTV7ee03130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee03130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee03130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee03130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee03130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee03130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee03130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee03130[] = {
  {&(_ZTV7ee03130[5]),  5,15},
  {&(_tg__ZTV6dd3130__7ee03130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee03130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee03130[4]),  4,5},
  {&(_ZTV7ee03130[10]),  10,15},
  {&(_ZTV7ee03130[14]),  14,15},
  {&(_tg__ZTV5cc130__7ee03130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee03130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee03130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee03130[];
extern  VTBL_ENTRY _ZTV7ee03130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03130[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03130 = {  "ee03130", // class name
  bases_ee03130, 4,
  &(vtc_ee03130[0]), // expected_vtbl_contents
  &(vtt_ee03130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee03130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13130  : virtual dd3130 {
  int e;
  ~ee13130(); // tgen
  ee13130(); // tgen
};
//SIG(1 ee13130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee13130 ::~ee13130(){ note_dtor("ee13130", this);} // tgen
ee13130 ::ee13130(){ note_ctor("ee13130", this);} // tgen

static void Test_ee13130()
{
  extern Class_Descriptor cd_ee13130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee13130, buf);
    ee13130 *dp, &lv = *(dp=new (buf) ee13130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee13130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee13130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee13130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(32,16), "ee13130");
    check_base_class_offset(lv, (dd3130*), ABISELECT(16,8), "ee13130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13130.e");
    test_class_info(&lv, &cd_ee13130);
    dp->~ee13130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13130(Test_ee13130, "ee13130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee13130C1Ev();
extern void _ZN7ee13130D1Ev();
Name_Map name_map_ee13130[] = {
  NSPAIR(_ZN7ee13130C1Ev),
  NSPAIR(_ZN7ee13130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee13130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13130[];
extern void _ZN6dd31303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13130[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13130[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee13130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
extern VTBL_ENTRY _ZTV7ee13130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee13130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee13130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee13130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee13130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee13130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee13130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee13130[] = {
  {&(_ZTV7ee13130[6]),  6,22},
  {&(_ZTV7ee13130[12]),  12,22},
  {&(_ZTV7ee13130[17]),  17,22},
  {&(_ZTV7ee13130[21]),  21,22},
  {&(_tg__ZTV6dd3130__7ee13130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee13130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee13130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee13130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee13130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee13130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13130[];
extern  VTBL_ENTRY _ZTV7ee13130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13130[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13130 = {  "ee13130", // class name
  bases_ee13130, 4,
  &(vtc_ee13130[0]), // expected_vtbl_contents
  &(vtt_ee13130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee13130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13130),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23130  : dd3130 {
  int e;
  virtual void  foo(); // _ZN7ee231303fooEv
  ~ee23130(); // tgen
  ee23130(); // tgen
};
//SIG(1 ee23130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23130 ::foo(){vfunc_called(this, "_ZN7ee231303fooEv");}
ee23130 ::~ee23130(){ note_dtor("ee23130", this);} // tgen
ee23130 ::ee23130(){ note_ctor("ee23130", this);} // tgen

static void Test_ee23130()
{
  extern Class_Descriptor cd_ee23130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee23130, buf);
    ee23130 *dp, &lv = *(dp=new (buf) ee23130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee23130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee23130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee23130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(16,12), "ee23130");
    check_base_class_offset(lv, (dd3130*), 0, "ee23130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23130.e");
    test_class_info(&lv, &cd_ee23130);
    dp->~ee23130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23130(Test_ee23130, "ee23130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee23130C1Ev();
extern void _ZN7ee23130D1Ev();
Name_Map name_map_ee23130[] = {
  NSPAIR(_ZN7ee23130C1Ev),
  NSPAIR(_ZN7ee23130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee23130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23130[];
extern void _ZN7ee231303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee231303fooEv,_ZTv0_n16_N7ee231303fooEv)();
extern void ABISELECT(_ZThn32_N7ee231303fooEv,_ZThn20_N7ee231303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23130[0]),
  (VTBL_ENTRY)&_ZN7ee231303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee23130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee231303fooEv,_ZTv0_n16_N7ee231303fooEv),
};
extern VTBL_ENTRY _ZTV7ee23130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee23130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee23130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee23130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee23130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee23130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee23130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee23130[] = {
  {&(_ZTV7ee23130[5]),  5,15},
  {&(_tg__ZTV6dd3130__7ee23130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee23130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee23130[4]),  4,5},
  {&(_ZTV7ee23130[10]),  10,15},
  {&(_ZTV7ee23130[14]),  14,15},
  {&(_tg__ZTV5cc130__7ee23130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee23130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee23130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee23130[];
extern  VTBL_ENTRY _ZTV7ee23130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23130[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee231303fooEv,_ZTv0_n16_N7ee231303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee231303fooEv,_ZThn20_N7ee231303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23130 = {  "ee23130", // class name
  bases_ee23130, 4,
  &(vtc_ee23130[0]), // expected_vtbl_contents
  &(vtt_ee23130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee23130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33130  : virtual dd3130 {
  int e;
  virtual void  foo(); // _ZN7ee331303fooEv
  ~ee33130(); // tgen
  ee33130(); // tgen
};
//SIG(1 ee33130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33130 ::foo(){vfunc_called(this, "_ZN7ee331303fooEv");}
ee33130 ::~ee33130(){ note_dtor("ee33130", this);} // tgen
ee33130 ::ee33130(){ note_ctor("ee33130", this);} // tgen

static void Test_ee33130()
{
  extern Class_Descriptor cd_ee33130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee33130, buf);
    ee33130 *dp, &lv = *(dp=new (buf) ee33130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee33130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee33130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee33130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(32,16), "ee33130");
    check_base_class_offset(lv, (dd3130*), ABISELECT(16,8), "ee33130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33130.e");
    test_class_info(&lv, &cd_ee33130);
    dp->~ee33130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33130(Test_ee33130, "ee33130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee33130C1Ev();
extern void _ZN7ee33130D1Ev();
Name_Map name_map_ee33130[] = {
  NSPAIR(_ZN7ee33130C1Ev),
  NSPAIR(_ZN7ee33130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee33130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33130[];
extern void _ZN7ee331303fooEv();
extern void ABISELECT(_ZTv0_n48_N7ee331303fooEv,_ZTv0_n24_N7ee331303fooEv)();
extern void ABISELECT(_ZThn16_N7ee331303fooEv,_ZThn8_N7ee331303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee331303fooEv,_ZTv0_n16_N7ee331303fooEv)();
extern void ABISELECT(_ZThn48_N7ee331303fooEv,_ZThn24_N7ee331303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33130[0]),
  (VTBL_ENTRY)&_ZN7ee331303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee331303fooEv,_ZTv0_n24_N7ee331303fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee33130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee331303fooEv,_ZTv0_n16_N7ee331303fooEv),
};
extern VTBL_ENTRY _ZTV7ee33130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee33130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee33130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee33130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee33130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee33130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee33130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee33130[] = {
  {&(_ZTV7ee33130[6]),  6,23},
  {&(_ZTV7ee33130[13]),  13,23},
  {&(_ZTV7ee33130[18]),  18,23},
  {&(_ZTV7ee33130[22]),  22,23},
  {&(_tg__ZTV6dd3130__7ee33130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee33130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee33130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee33130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee33130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee33130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33130[];
extern  VTBL_ENTRY _ZTV7ee33130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33130[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee331303fooEv,_ZTv0_n16_N7ee331303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee331303fooEv,_ZThn24_N7ee331303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee331303fooEv,_ZTv0_n24_N7ee331303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331303fooEv,_ZThn8_N7ee331303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33130 = {  "ee33130", // class name
  bases_ee33130, 4,
  &(vtc_ee33130[0]), // expected_vtbl_contents
  &(vtt_ee33130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee33130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33130),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43130  : dd3130 {
  int e;
  virtual void  bar(); // _ZN7ee431303barEv
  ~ee43130(); // tgen
  ee43130(); // tgen
};
//SIG(1 ee43130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43130 ::bar(){vfunc_called(this, "_ZN7ee431303barEv");}
ee43130 ::~ee43130(){ note_dtor("ee43130", this);} // tgen
ee43130 ::ee43130(){ note_ctor("ee43130", this);} // tgen

static void Test_ee43130()
{
  extern Class_Descriptor cd_ee43130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee43130, buf);
    ee43130 *dp, &lv = *(dp=new (buf) ee43130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee43130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee43130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee43130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(16,12), "ee43130");
    check_base_class_offset(lv, (dd3130*), 0, "ee43130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43130.e");
    test_class_info(&lv, &cd_ee43130);
    dp->~ee43130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43130(Test_ee43130, "ee43130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee43130C1Ev();
extern void _ZN7ee43130D1Ev();
Name_Map name_map_ee43130[] = {
  NSPAIR(_ZN7ee43130C1Ev),
  NSPAIR(_ZN7ee43130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee43130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43130[];
extern void _ZN6dd31303fooEv();
extern void _ZN7ee431303barEv();
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
  (VTBL_ENTRY)&_ZN7ee431303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee43130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
extern VTBL_ENTRY _ZTV7ee43130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee43130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee43130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee43130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee43130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee43130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee43130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee43130[] = {
  {&(_ZTV7ee43130[5]),  5,16},
  {&(_tg__ZTV6dd3130__7ee43130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee43130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee43130[4]),  4,5},
  {&(_ZTV7ee43130[11]),  11,16},
  {&(_ZTV7ee43130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee43130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee43130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee43130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee43130[];
extern  VTBL_ENTRY _ZTV7ee43130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43130[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43130 = {  "ee43130", // class name
  bases_ee43130, 4,
  &(vtc_ee43130[0]), // expected_vtbl_contents
  &(vtt_ee43130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee43130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53130  : virtual dd3130 {
  int e;
  virtual void  bar(); // _ZN7ee531303barEv
  ~ee53130(); // tgen
  ee53130(); // tgen
};
//SIG(1 ee53130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53130 ::bar(){vfunc_called(this, "_ZN7ee531303barEv");}
ee53130 ::~ee53130(){ note_dtor("ee53130", this);} // tgen
ee53130 ::ee53130(){ note_ctor("ee53130", this);} // tgen

static void Test_ee53130()
{
  extern Class_Descriptor cd_ee53130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee53130, buf);
    ee53130 *dp, &lv = *(dp=new (buf) ee53130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee53130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee53130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee53130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(32,16), "ee53130");
    check_base_class_offset(lv, (dd3130*), ABISELECT(16,8), "ee53130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53130.e");
    test_class_info(&lv, &cd_ee53130);
    dp->~ee53130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53130(Test_ee53130, "ee53130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee53130C1Ev();
extern void _ZN7ee53130D1Ev();
Name_Map name_map_ee53130[] = {
  NSPAIR(_ZN7ee53130C1Ev),
  NSPAIR(_ZN7ee53130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee53130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53130[];
extern void _ZN7ee531303barEv();
extern void _ZN6dd31303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53130[0]),
  (VTBL_ENTRY)&_ZN7ee531303barEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53130[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee53130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
extern VTBL_ENTRY _ZTV7ee53130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee53130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee53130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee53130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee53130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee53130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee53130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee53130[] = {
  {&(_ZTV7ee53130[6]),  6,23},
  {&(_ZTV7ee53130[13]),  13,23},
  {&(_ZTV7ee53130[18]),  18,23},
  {&(_ZTV7ee53130[22]),  22,23},
  {&(_tg__ZTV6dd3130__7ee53130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee53130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee53130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee53130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee53130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee53130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53130[];
extern  VTBL_ENTRY _ZTV7ee53130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53130[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53130 = {  "ee53130", // class name
  bases_ee53130, 4,
  &(vtc_ee53130[0]), // expected_vtbl_contents
  &(vtt_ee53130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee53130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53130),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63130  : dd3130 {
  int e;
  virtual void  foo(); // _ZN7ee631303fooEv
  virtual void  bar(); // _ZN7ee631303barEv
  ~ee63130(); // tgen
  ee63130(); // tgen
};
//SIG(1 ee63130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63130 ::foo(){vfunc_called(this, "_ZN7ee631303fooEv");}
void  ee63130 ::bar(){vfunc_called(this, "_ZN7ee631303barEv");}
ee63130 ::~ee63130(){ note_dtor("ee63130", this);} // tgen
ee63130 ::ee63130(){ note_ctor("ee63130", this);} // tgen

static void Test_ee63130()
{
  extern Class_Descriptor cd_ee63130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee63130, buf);
    ee63130 *dp, &lv = *(dp=new (buf) ee63130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee63130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee63130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee63130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(16,12), "ee63130");
    check_base_class_offset(lv, (dd3130*), 0, "ee63130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63130.e");
    test_class_info(&lv, &cd_ee63130);
    dp->~ee63130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63130(Test_ee63130, "ee63130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee63130C1Ev();
extern void _ZN7ee63130D1Ev();
Name_Map name_map_ee63130[] = {
  NSPAIR(_ZN7ee63130C1Ev),
  NSPAIR(_ZN7ee63130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee63130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63130[];
extern void _ZN7ee631303fooEv();
extern void _ZN7ee631303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee631303fooEv,_ZTv0_n16_N7ee631303fooEv)();
extern void ABISELECT(_ZThn32_N7ee631303fooEv,_ZThn20_N7ee631303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63130[0]),
  (VTBL_ENTRY)&_ZN7ee631303fooEv,
  (VTBL_ENTRY)&_ZN7ee631303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee63130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee631303fooEv,_ZTv0_n16_N7ee631303fooEv),
};
extern VTBL_ENTRY _ZTV7ee63130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee63130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee63130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee63130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee63130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee63130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee63130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee63130[] = {
  {&(_ZTV7ee63130[5]),  5,16},
  {&(_tg__ZTV6dd3130__7ee63130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee63130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee63130[4]),  4,5},
  {&(_ZTV7ee63130[11]),  11,16},
  {&(_ZTV7ee63130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee63130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee63130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee63130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee63130[];
extern  VTBL_ENTRY _ZTV7ee63130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63130[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn20_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee631303fooEv,_ZTv0_n16_N7ee631303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631303fooEv,_ZThn20_N7ee631303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63130 = {  "ee63130", // class name
  bases_ee63130, 4,
  &(vtc_ee63130[0]), // expected_vtbl_contents
  &(vtt_ee63130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee63130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73130  : virtual dd3130 {
  int e;
  virtual void  foo(); // _ZN7ee731303fooEv
  virtual void  bar(); // _ZN7ee731303barEv
  ~ee73130(); // tgen
  ee73130(); // tgen
};
//SIG(1 ee73130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73130 ::foo(){vfunc_called(this, "_ZN7ee731303fooEv");}
void  ee73130 ::bar(){vfunc_called(this, "_ZN7ee731303barEv");}
ee73130 ::~ee73130(){ note_dtor("ee73130", this);} // tgen
ee73130 ::ee73130(){ note_ctor("ee73130", this);} // tgen

static void Test_ee73130()
{
  extern Class_Descriptor cd_ee73130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee73130, buf);
    ee73130 *dp, &lv = *(dp=new (buf) ee73130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee73130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee73130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee73130");
    check_base_class_offset(lv, (cc130*)(dd3130*), ABISELECT(32,16), "ee73130");
    check_base_class_offset(lv, (dd3130*), ABISELECT(16,8), "ee73130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73130.e");
    test_class_info(&lv, &cd_ee73130);
    dp->~ee73130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73130(Test_ee73130, "ee73130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee73130C1Ev();
extern void _ZN7ee73130D1Ev();
Name_Map name_map_ee73130[] = {
  NSPAIR(_ZN7ee73130C1Ev),
  NSPAIR(_ZN7ee73130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd3130;
extern VTBL_ENTRY _ZTI6dd3130[];
extern  VTBL_ENTRY _ZTV6dd3130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3130[];
static Base_Class bases_ee73130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3130,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73130[];
extern void _ZN7ee731303fooEv();
extern void _ZN7ee731303barEv();
extern void ABISELECT(_ZTv0_n48_N7ee731303fooEv,_ZTv0_n24_N7ee731303fooEv)();
extern void ABISELECT(_ZThn16_N7ee731303fooEv,_ZThn8_N7ee731303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee731303fooEv,_ZTv0_n16_N7ee731303fooEv)();
extern void ABISELECT(_ZThn48_N7ee731303fooEv,_ZThn24_N7ee731303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73130[0]),
  (VTBL_ENTRY)&_ZN7ee731303fooEv,
  (VTBL_ENTRY)&_ZN7ee731303barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee731303fooEv,_ZTv0_n24_N7ee731303fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee73130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee731303fooEv,_ZTv0_n16_N7ee731303fooEv),
};
extern VTBL_ENTRY _ZTV7ee73130[];
extern void _ZN6dd31303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3130__7ee73130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&_ZN6dd31303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd3130__7ee73130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv)();
extern void ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd3130__7ee73130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee73130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee73130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee73130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee73130[] = {
  {&(_ZTV7ee73130[6]),  6,24},
  {&(_ZTV7ee73130[14]),  14,24},
  {&(_ZTV7ee73130[19]),  19,24},
  {&(_ZTV7ee73130[23]),  23,24},
  {&(_tg__ZTV6dd3130__7ee73130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd3130__7ee73130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd3130__7ee73130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee73130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee73130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee73130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73130[];
extern  VTBL_ENTRY _ZTV7ee73130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73130[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd31303fooEv,_ZTv0_n16_N6dd31303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31303fooEv,_ZThn16_N6dd31303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee731303fooEv,_ZTv0_n16_N7ee731303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731303fooEv,_ZThn24_N7ee731303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee731303fooEv,_ZTv0_n24_N7ee731303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731303fooEv,_ZThn8_N7ee731303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73130 = {  "ee73130", // class name
  bases_ee73130, 4,
  &(vtc_ee73130[0]), // expected_vtbl_contents
  &(vtt_ee73130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee73130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73130),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4130  : cc130 {
  int d;
  virtual void  bar(); // _ZN6dd41303barEv
  ~dd4130(); // tgen
  dd4130(); // tgen
};
//SIG(-1 dd4130) C1{ BC2{ VBC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd4130 ::bar(){vfunc_called(this, "_ZN6dd41303barEv");}
dd4130 ::~dd4130(){ note_dtor("dd4130", this);} // tgen
dd4130 ::dd4130(){ note_ctor("dd4130", this);} // tgen

static void Test_dd4130()
{
  extern Class_Descriptor cd_dd4130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd4130, buf);
    dd4130 *dp, &lv = *(dp=new (buf) dd4130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd4130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(28,20), "dd4130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(16,12), "dd4130");
    check_base_class_offset(lv, (cc130*), 0, "dd4130");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4130.d");
    test_class_info(&lv, &cd_dd4130);
    dp->~dd4130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4130(Test_dd4130, "dd4130", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd4130C1Ev();
extern void _ZN6dd4130D1Ev();
Name_Map name_map_dd4130[] = {
  NSPAIR(_ZN6dd4130C1Ev),
  NSPAIR(_ZN6dd4130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd4130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4130[];
extern void _ZN6dd41303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_dd4130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV6dd4130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd4130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd4130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd4130[] = {
  {&(_ZTV6dd4130[4]),  4,10},
  {&(_tg__ZTV5cc130__6dd4130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd4130[4]),  4,5},
  {&(_ZTV6dd4130[9]),  9,10},
  {&(_tg__ZTV4bb30__6dd4130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
Class_Descriptor cd_dd4130 = {  "dd4130", // class name
  bases_dd4130, 3,
  &(vtc_dd4130[0]), // expected_vtbl_contents
  &(vtt_dd4130[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd4130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4130),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04130  : dd4130 {
  int e;
  ~ee04130(); // tgen
  ee04130(); // tgen
};
//SIG(1 ee04130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee04130 ::~ee04130(){ note_dtor("ee04130", this);} // tgen
ee04130 ::ee04130(){ note_ctor("ee04130", this);} // tgen

static void Test_ee04130()
{
  extern Class_Descriptor cd_ee04130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee04130, buf);
    ee04130 *dp, &lv = *(dp=new (buf) ee04130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee04130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee04130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(24,16), "ee04130");
    check_base_class_offset(lv, (cc130*)(dd4130*), 0, "ee04130");
    check_base_class_offset(lv, (dd4130*), 0, "ee04130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04130.e");
    test_class_info(&lv, &cd_ee04130);
    dp->~ee04130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04130(Test_ee04130, "ee04130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee04130C1Ev();
extern void _ZN7ee04130D1Ev();
Name_Map name_map_ee04130[] = {
  NSPAIR(_ZN7ee04130C1Ev),
  NSPAIR(_ZN7ee04130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee04130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04130[];
extern void _ZN6dd41303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee04130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee04130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee04130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee04130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee04130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee04130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee04130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee04130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee04130[] = {
  {&(_ZTV7ee04130[4]),  4,10},
  {&(_tg__ZTV6dd4130__7ee04130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee04130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee04130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee04130[4]),  4,5},
  {&(_ZTV7ee04130[9]),  9,10},
  {&(_tg__ZTV4bb30__7ee04130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee04130[];
extern  VTBL_ENTRY _ZTV7ee04130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04130[];
Class_Descriptor cd_ee04130 = {  "ee04130", // class name
  bases_ee04130, 4,
  &(vtc_ee04130[0]), // expected_vtbl_contents
  &(vtt_ee04130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee04130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14130  : virtual dd4130 {
  int e;
  ~ee14130(); // tgen
  ee14130(); // tgen
};
//SIG(1 ee14130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee14130 ::~ee14130(){ note_dtor("ee14130", this);} // tgen
ee14130 ::ee14130(){ note_ctor("ee14130", this);} // tgen

static void Test_ee14130()
{
  extern Class_Descriptor cd_ee14130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee14130, buf);
    ee14130 *dp, &lv = *(dp=new (buf) ee14130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee14130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee14130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(32,20), "ee14130");
    check_base_class_offset(lv, (cc130*)(dd4130*), ABISELECT(16,8), "ee14130");
    check_base_class_offset(lv, (dd4130*), ABISELECT(16,8), "ee14130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14130.e");
    test_class_info(&lv, &cd_ee14130);
    dp->~ee14130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14130(Test_ee14130, "ee14130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee14130C1Ev();
extern void _ZN7ee14130D1Ev();
Name_Map name_map_ee14130[] = {
  NSPAIR(_ZN7ee14130C1Ev),
  NSPAIR(_ZN7ee14130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee14130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14130[];
extern void _ZN6dd41303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee14130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14130[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee14130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee14130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee14130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee14130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee14130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee14130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee14130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee14130[] = {
  {&(_ZTV7ee14130[5]),  5,16},
  {&(_ZTV7ee14130[10]),  10,16},
  {&(_ZTV7ee14130[15]),  15,16},
  {&(_tg__ZTV6dd4130__7ee14130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee14130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee14130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee14130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee14130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee14130[];
extern  VTBL_ENTRY _ZTV7ee14130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14130[];
Class_Descriptor cd_ee14130 = {  "ee14130", // class name
  bases_ee14130, 4,
  &(vtc_ee14130[0]), // expected_vtbl_contents
  &(vtt_ee14130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee14130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24130  : dd4130 {
  int e;
  virtual void  foo(); // _ZN7ee241303fooEv
  ~ee24130(); // tgen
  ee24130(); // tgen
};
//SIG(1 ee24130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24130 ::foo(){vfunc_called(this, "_ZN7ee241303fooEv");}
ee24130 ::~ee24130(){ note_dtor("ee24130", this);} // tgen
ee24130 ::ee24130(){ note_ctor("ee24130", this);} // tgen

static void Test_ee24130()
{
  extern Class_Descriptor cd_ee24130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee24130, buf);
    ee24130 *dp, &lv = *(dp=new (buf) ee24130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee24130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee24130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(24,16), "ee24130");
    check_base_class_offset(lv, (cc130*)(dd4130*), 0, "ee24130");
    check_base_class_offset(lv, (dd4130*), 0, "ee24130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24130.e");
    test_class_info(&lv, &cd_ee24130);
    dp->~ee24130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24130(Test_ee24130, "ee24130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee24130C1Ev();
extern void _ZN7ee24130D1Ev();
Name_Map name_map_ee24130[] = {
  NSPAIR(_ZN7ee24130C1Ev),
  NSPAIR(_ZN7ee24130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee24130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24130[];
extern void _ZN6dd41303barEv();
extern void _ZN7ee241303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee241303fooEv,_ZTv0_n16_N7ee241303fooEv)();
extern void ABISELECT(_ZThn24_N7ee241303fooEv,_ZThn16_N7ee241303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee24130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
  (VTBL_ENTRY)&_ZN7ee241303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee24130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee241303fooEv,_ZTv0_n16_N7ee241303fooEv),
};
extern VTBL_ENTRY _ZTV7ee24130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee24130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee24130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee24130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee24130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee24130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee24130[] = {
  {&(_ZTV7ee24130[4]),  4,11},
  {&(_tg__ZTV6dd4130__7ee24130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee24130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee24130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee24130[4]),  4,5},
  {&(_ZTV7ee24130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee24130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee24130[];
extern  VTBL_ENTRY _ZTV7ee24130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24130[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee241303fooEv,_ZTv0_n16_N7ee241303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee241303fooEv,_ZThn16_N7ee241303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee24130 = {  "ee24130", // class name
  bases_ee24130, 4,
  &(vtc_ee24130[0]), // expected_vtbl_contents
  &(vtt_ee24130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee24130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34130  : virtual dd4130 {
  int e;
  virtual void  foo(); // _ZN7ee341303fooEv
  ~ee34130(); // tgen
  ee34130(); // tgen
};
//SIG(1 ee34130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34130 ::foo(){vfunc_called(this, "_ZN7ee341303fooEv");}
ee34130 ::~ee34130(){ note_dtor("ee34130", this);} // tgen
ee34130 ::ee34130(){ note_ctor("ee34130", this);} // tgen

static void Test_ee34130()
{
  extern Class_Descriptor cd_ee34130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee34130, buf);
    ee34130 *dp, &lv = *(dp=new (buf) ee34130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee34130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee34130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(32,20), "ee34130");
    check_base_class_offset(lv, (cc130*)(dd4130*), ABISELECT(16,8), "ee34130");
    check_base_class_offset(lv, (dd4130*), ABISELECT(16,8), "ee34130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34130.e");
    test_class_info(&lv, &cd_ee34130);
    dp->~ee34130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34130(Test_ee34130, "ee34130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee34130C1Ev();
extern void _ZN7ee34130D1Ev();
Name_Map name_map_ee34130[] = {
  NSPAIR(_ZN7ee34130C1Ev),
  NSPAIR(_ZN7ee34130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee34130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34130[];
extern void _ZN7ee341303fooEv();
extern void _ZN6dd41303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee341303fooEv,_ZTv0_n16_N7ee341303fooEv)();
extern void ABISELECT(_ZThn32_N7ee341303fooEv,_ZThn20_N7ee341303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34130[0]),
  (VTBL_ENTRY)&_ZN7ee341303fooEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee34130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee341303fooEv,_ZTv0_n16_N7ee341303fooEv),
};
extern VTBL_ENTRY _ZTV7ee34130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee34130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee34130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee34130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee34130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee34130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee34130[] = {
  {&(_ZTV7ee34130[5]),  5,17},
  {&(_ZTV7ee34130[11]),  11,17},
  {&(_ZTV7ee34130[16]),  16,17},
  {&(_tg__ZTV6dd4130__7ee34130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee34130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee34130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee34130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee34130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee34130[];
extern  VTBL_ENTRY _ZTV7ee34130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34130[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee341303fooEv,_ZTv0_n16_N7ee341303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee341303fooEv,_ZThn20_N7ee341303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34130 = {  "ee34130", // class name
  bases_ee34130, 4,
  &(vtc_ee34130[0]), // expected_vtbl_contents
  &(vtt_ee34130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee34130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34130),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44130  : dd4130 {
  int e;
  virtual void  bar(); // _ZN7ee441303barEv
  ~ee44130(); // tgen
  ee44130(); // tgen
};
//SIG(1 ee44130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44130 ::bar(){vfunc_called(this, "_ZN7ee441303barEv");}
ee44130 ::~ee44130(){ note_dtor("ee44130", this);} // tgen
ee44130 ::ee44130(){ note_ctor("ee44130", this);} // tgen

static void Test_ee44130()
{
  extern Class_Descriptor cd_ee44130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee44130, buf);
    ee44130 *dp, &lv = *(dp=new (buf) ee44130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee44130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee44130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(24,16), "ee44130");
    check_base_class_offset(lv, (cc130*)(dd4130*), 0, "ee44130");
    check_base_class_offset(lv, (dd4130*), 0, "ee44130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44130.e");
    test_class_info(&lv, &cd_ee44130);
    dp->~ee44130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44130(Test_ee44130, "ee44130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee44130C1Ev();
extern void _ZN7ee44130D1Ev();
Name_Map name_map_ee44130[] = {
  NSPAIR(_ZN7ee44130C1Ev),
  NSPAIR(_ZN7ee44130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee44130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44130[];
extern void _ZN7ee441303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee44130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44130[0]),
  (VTBL_ENTRY)&_ZN7ee441303barEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee44130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee44130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee44130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee44130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee44130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee44130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee44130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee44130[] = {
  {&(_ZTV7ee44130[4]),  4,10},
  {&(_tg__ZTV6dd4130__7ee44130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee44130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee44130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee44130[4]),  4,5},
  {&(_ZTV7ee44130[9]),  9,10},
  {&(_tg__ZTV4bb30__7ee44130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee44130[];
extern  VTBL_ENTRY _ZTV7ee44130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44130[];
Class_Descriptor cd_ee44130 = {  "ee44130", // class name
  bases_ee44130, 4,
  &(vtc_ee44130[0]), // expected_vtbl_contents
  &(vtt_ee44130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee44130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44130),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54130  : virtual dd4130 {
  int e;
  virtual void  bar(); // _ZN7ee541303barEv
  ~ee54130(); // tgen
  ee54130(); // tgen
};
//SIG(1 ee54130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54130 ::bar(){vfunc_called(this, "_ZN7ee541303barEv");}
ee54130 ::~ee54130(){ note_dtor("ee54130", this);} // tgen
ee54130 ::ee54130(){ note_ctor("ee54130", this);} // tgen

static void Test_ee54130()
{
  extern Class_Descriptor cd_ee54130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee54130, buf);
    ee54130 *dp, &lv = *(dp=new (buf) ee54130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee54130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee54130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(32,20), "ee54130");
    check_base_class_offset(lv, (cc130*)(dd4130*), ABISELECT(16,8), "ee54130");
    check_base_class_offset(lv, (dd4130*), ABISELECT(16,8), "ee54130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54130.e");
    test_class_info(&lv, &cd_ee54130);
    dp->~ee54130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54130(Test_ee54130, "ee54130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee54130C1Ev();
extern void _ZN7ee54130D1Ev();
Name_Map name_map_ee54130[] = {
  NSPAIR(_ZN7ee54130C1Ev),
  NSPAIR(_ZN7ee54130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee54130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54130[];
extern void _ZN7ee541303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee541303barEv,_ZTv0_n20_N7ee541303barEv)();
extern void ABISELECT(_ZThn16_N7ee541303barEv,_ZThn8_N7ee541303barEv)() __attribute__((weak));
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee54130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54130[0]),
  (VTBL_ENTRY)&_ZN7ee541303barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee541303barEv,_ZTv0_n20_N7ee541303barEv),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee54130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee54130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee54130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee54130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee54130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee54130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee54130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee54130[] = {
  {&(_ZTV7ee54130[5]),  5,17},
  {&(_ZTV7ee54130[11]),  11,17},
  {&(_ZTV7ee54130[16]),  16,17},
  {&(_tg__ZTV6dd4130__7ee54130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee54130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee54130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee54130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee54130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee54130[];
extern  VTBL_ENTRY _ZTV7ee54130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54130[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee541303barEv,_ZTv0_n20_N7ee541303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541303barEv,_ZThn8_N7ee541303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54130 = {  "ee54130", // class name
  bases_ee54130, 4,
  &(vtc_ee54130[0]), // expected_vtbl_contents
  &(vtt_ee54130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee54130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54130),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64130  : dd4130 {
  int e;
  virtual void  foo(); // _ZN7ee641303fooEv
  virtual void  bar(); // _ZN7ee641303barEv
  ~ee64130(); // tgen
  ee64130(); // tgen
};
//SIG(1 ee64130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64130 ::foo(){vfunc_called(this, "_ZN7ee641303fooEv");}
void  ee64130 ::bar(){vfunc_called(this, "_ZN7ee641303barEv");}
ee64130 ::~ee64130(){ note_dtor("ee64130", this);} // tgen
ee64130 ::ee64130(){ note_ctor("ee64130", this);} // tgen

static void Test_ee64130()
{
  extern Class_Descriptor cd_ee64130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee64130, buf);
    ee64130 *dp, &lv = *(dp=new (buf) ee64130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee64130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee64130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(24,16), "ee64130");
    check_base_class_offset(lv, (cc130*)(dd4130*), 0, "ee64130");
    check_base_class_offset(lv, (dd4130*), 0, "ee64130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64130.e");
    test_class_info(&lv, &cd_ee64130);
    dp->~ee64130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64130(Test_ee64130, "ee64130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee64130C1Ev();
extern void _ZN7ee64130D1Ev();
Name_Map name_map_ee64130[] = {
  NSPAIR(_ZN7ee64130C1Ev),
  NSPAIR(_ZN7ee64130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee64130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64130[];
extern void _ZN7ee641303barEv();
extern void _ZN7ee641303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee641303fooEv,_ZTv0_n16_N7ee641303fooEv)();
extern void ABISELECT(_ZThn24_N7ee641303fooEv,_ZThn16_N7ee641303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee64130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64130[0]),
  (VTBL_ENTRY)&_ZN7ee641303barEv,
  (VTBL_ENTRY)&_ZN7ee641303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee64130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee641303fooEv,_ZTv0_n16_N7ee641303fooEv),
};
extern VTBL_ENTRY _ZTV7ee64130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee64130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee64130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee64130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee64130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee64130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee64130[] = {
  {&(_ZTV7ee64130[4]),  4,11},
  {&(_tg__ZTV6dd4130__7ee64130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee64130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee64130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee64130[4]),  4,5},
  {&(_ZTV7ee64130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee64130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee64130[];
extern  VTBL_ENTRY _ZTV7ee64130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64130[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee641303fooEv,_ZTv0_n16_N7ee641303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641303fooEv,_ZThn16_N7ee641303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee64130 = {  "ee64130", // class name
  bases_ee64130, 4,
  &(vtc_ee64130[0]), // expected_vtbl_contents
  &(vtt_ee64130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee64130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74130  : virtual dd4130 {
  int e;
  virtual void  foo(); // _ZN7ee741303fooEv
  virtual void  bar(); // _ZN7ee741303barEv
  ~ee74130(); // tgen
  ee74130(); // tgen
};
//SIG(1 ee74130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74130 ::foo(){vfunc_called(this, "_ZN7ee741303fooEv");}
void  ee74130 ::bar(){vfunc_called(this, "_ZN7ee741303barEv");}
ee74130 ::~ee74130(){ note_dtor("ee74130", this);} // tgen
ee74130 ::ee74130(){ note_ctor("ee74130", this);} // tgen

static void Test_ee74130()
{
  extern Class_Descriptor cd_ee74130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee74130, buf);
    ee74130 *dp, &lv = *(dp=new (buf) ee74130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee74130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee74130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd4130*), ABISELECT(32,20), "ee74130");
    check_base_class_offset(lv, (cc130*)(dd4130*), ABISELECT(16,8), "ee74130");
    check_base_class_offset(lv, (dd4130*), ABISELECT(16,8), "ee74130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74130.e");
    test_class_info(&lv, &cd_ee74130);
    dp->~ee74130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74130(Test_ee74130, "ee74130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee74130C1Ev();
extern void _ZN7ee74130D1Ev();
Name_Map name_map_ee74130[] = {
  NSPAIR(_ZN7ee74130C1Ev),
  NSPAIR(_ZN7ee74130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd4130;
extern VTBL_ENTRY _ZTI6dd4130[];
extern  VTBL_ENTRY _ZTV6dd4130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4130[];
static Base_Class bases_ee74130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74130[];
extern void _ZN7ee741303fooEv();
extern void _ZN7ee741303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee741303barEv,_ZTv0_n20_N7ee741303barEv)();
extern void ABISELECT(_ZThn16_N7ee741303barEv,_ZThn8_N7ee741303barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee741303fooEv,_ZTv0_n16_N7ee741303fooEv)();
extern void ABISELECT(_ZThn32_N7ee741303fooEv,_ZThn20_N7ee741303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74130[0]),
  (VTBL_ENTRY)&_ZN7ee741303fooEv,
  (VTBL_ENTRY)&_ZN7ee741303barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee741303barEv,_ZTv0_n20_N7ee741303barEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee74130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741303fooEv,_ZTv0_n16_N7ee741303fooEv),
};
extern VTBL_ENTRY _ZTV7ee74130[];
extern void _ZN6dd41303barEv();
static  VTBL_ENTRY _tg__ZTV6dd4130__7ee74130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN6dd41303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd4130__7ee74130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd4130__7ee74130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd4130__7ee74130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee74130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee74130[] = {
  {&(_ZTV7ee74130[5]),  5,18},
  {&(_ZTV7ee74130[12]),  12,18},
  {&(_ZTV7ee74130[17]),  17,18},
  {&(_tg__ZTV6dd4130__7ee74130[4]),  4,5},
  {&(_tg__ZTV5cc1306dd4130__7ee74130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd4130__7ee74130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd4130__7ee74130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee74130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee74130[];
extern  VTBL_ENTRY _ZTV7ee74130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74130[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741303fooEv,_ZTv0_n16_N7ee741303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741303fooEv,_ZThn20_N7ee741303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee741303barEv,_ZTv0_n20_N7ee741303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741303barEv,_ZThn8_N7ee741303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74130 = {  "ee74130", // class name
  bases_ee74130, 4,
  &(vtc_ee74130[0]), // expected_vtbl_contents
  &(vtt_ee74130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee74130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74130),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5130  : virtual cc130 {
  int d;
  virtual void  bar(); // _ZN6dd51303barEv
  ~dd5130(); // tgen
  dd5130(); // tgen
};
//SIG(-1 dd5130) C1{ VBC2{ VBC3{ VBC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd5130 ::bar(){vfunc_called(this, "_ZN6dd51303barEv");}
dd5130 ::~dd5130(){ note_dtor("dd5130", this);} // tgen
dd5130 ::dd5130(){ note_ctor("dd5130", this);} // tgen

static void Test_dd5130()
{
  extern Class_Descriptor cd_dd5130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd5130, buf);
    dd5130 *dp, &lv = *(dp=new (buf) dd5130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd5130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,24), "dd5130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,16), "dd5130");
    check_base_class_offset(lv, (cc130*), ABISELECT(16,8), "dd5130");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5130.d");
    test_class_info(&lv, &cd_dd5130);
    dp->~dd5130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5130(Test_dd5130, "dd5130", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd5130C1Ev();
extern void _ZN6dd5130D1Ev();
Name_Map name_map_dd5130[] = {
  NSPAIR(_ZN6dd5130C1Ev),
  NSPAIR(_ZN6dd5130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd5130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5130[];
extern void _ZN6dd51303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_dd5130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV6dd5130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd5130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd5130[] = {
  {&(_ZTV6dd5130[5]),  5,15},
  {&(_ZTV6dd5130[10]),  10,15},
  {&(_ZTV6dd5130[14]),  14,15},
  {&(_tg__ZTV5cc130__6dd5130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd5130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd5130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
Class_Descriptor cd_dd5130 = {  "dd5130", // class name
  bases_dd5130, 3,
  &(vtc_dd5130[0]), // expected_vtbl_contents
  &(vtt_dd5130[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd5130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5130),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05130  : dd5130 {
  int e;
  ~ee05130(); // tgen
  ee05130(); // tgen
};
//SIG(1 ee05130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee05130 ::~ee05130(){ note_dtor("ee05130", this);} // tgen
ee05130 ::ee05130(){ note_ctor("ee05130", this);} // tgen

static void Test_ee05130()
{
  extern Class_Descriptor cd_ee05130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee05130, buf);
    ee05130 *dp, &lv = *(dp=new (buf) ee05130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee05130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee05130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee05130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(16,12), "ee05130");
    check_base_class_offset(lv, (dd5130*), 0, "ee05130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05130.e");
    test_class_info(&lv, &cd_ee05130);
    dp->~ee05130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05130(Test_ee05130, "ee05130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee05130C1Ev();
extern void _ZN7ee05130D1Ev();
Name_Map name_map_ee05130[] = {
  NSPAIR(_ZN7ee05130C1Ev),
  NSPAIR(_ZN7ee05130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee05130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05130[];
extern void _ZN6dd51303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee05130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee05130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee05130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee05130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee05130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee05130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee05130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee05130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee05130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee05130[] = {
  {&(_ZTV7ee05130[5]),  5,15},
  {&(_tg__ZTV6dd5130__7ee05130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee05130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee05130[4]),  4,5},
  {&(_ZTV7ee05130[10]),  10,15},
  {&(_ZTV7ee05130[14]),  14,15},
  {&(_tg__ZTV5cc130__7ee05130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee05130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee05130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee05130[];
extern  VTBL_ENTRY _ZTV7ee05130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05130[];
Class_Descriptor cd_ee05130 = {  "ee05130", // class name
  bases_ee05130, 4,
  &(vtc_ee05130[0]), // expected_vtbl_contents
  &(vtt_ee05130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee05130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15130  : virtual dd5130 {
  int e;
  ~ee15130(); // tgen
  ee15130(); // tgen
};
//SIG(1 ee15130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee15130 ::~ee15130(){ note_dtor("ee15130", this);} // tgen
ee15130 ::ee15130(){ note_ctor("ee15130", this);} // tgen

static void Test_ee15130()
{
  extern Class_Descriptor cd_ee15130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee15130, buf);
    ee15130 *dp, &lv = *(dp=new (buf) ee15130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee15130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee15130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee15130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(32,16), "ee15130");
    check_base_class_offset(lv, (dd5130*), ABISELECT(16,8), "ee15130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15130.e");
    test_class_info(&lv, &cd_ee15130);
    dp->~ee15130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15130(Test_ee15130, "ee15130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee15130C1Ev();
extern void _ZN7ee15130D1Ev();
Name_Map name_map_ee15130[] = {
  NSPAIR(_ZN7ee15130C1Ev),
  NSPAIR(_ZN7ee15130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee15130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15130[];
extern void _ZN6dd51303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee15130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15130[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee15130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee15130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee15130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee15130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee15130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee15130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee15130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee15130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee15130[] = {
  {&(_ZTV7ee15130[6]),  6,22},
  {&(_ZTV7ee15130[12]),  12,22},
  {&(_ZTV7ee15130[17]),  17,22},
  {&(_ZTV7ee15130[21]),  21,22},
  {&(_tg__ZTV6dd5130__7ee15130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee15130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee15130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee15130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee15130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee15130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15130[];
extern  VTBL_ENTRY _ZTV7ee15130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15130[];
Class_Descriptor cd_ee15130 = {  "ee15130", // class name
  bases_ee15130, 4,
  &(vtc_ee15130[0]), // expected_vtbl_contents
  &(vtt_ee15130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee15130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15130),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25130  : dd5130 {
  int e;
  virtual void  foo(); // _ZN7ee251303fooEv
  ~ee25130(); // tgen
  ee25130(); // tgen
};
//SIG(1 ee25130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25130 ::foo(){vfunc_called(this, "_ZN7ee251303fooEv");}
ee25130 ::~ee25130(){ note_dtor("ee25130", this);} // tgen
ee25130 ::ee25130(){ note_ctor("ee25130", this);} // tgen

static void Test_ee25130()
{
  extern Class_Descriptor cd_ee25130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee25130, buf);
    ee25130 *dp, &lv = *(dp=new (buf) ee25130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee25130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee25130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee25130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(16,12), "ee25130");
    check_base_class_offset(lv, (dd5130*), 0, "ee25130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25130.e");
    test_class_info(&lv, &cd_ee25130);
    dp->~ee25130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25130(Test_ee25130, "ee25130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee25130C1Ev();
extern void _ZN7ee25130D1Ev();
Name_Map name_map_ee25130[] = {
  NSPAIR(_ZN7ee25130C1Ev),
  NSPAIR(_ZN7ee25130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee25130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25130[];
extern void _ZN6dd51303barEv();
extern void _ZN7ee251303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee251303fooEv,_ZTv0_n16_N7ee251303fooEv)();
extern void ABISELECT(_ZThn32_N7ee251303fooEv,_ZThn20_N7ee251303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
  (VTBL_ENTRY)&_ZN7ee251303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee25130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee251303fooEv,_ZTv0_n16_N7ee251303fooEv),
};
extern VTBL_ENTRY _ZTV7ee25130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee25130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee25130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee25130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee25130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee25130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee25130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee25130[] = {
  {&(_ZTV7ee25130[5]),  5,16},
  {&(_tg__ZTV6dd5130__7ee25130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee25130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee25130[4]),  4,5},
  {&(_ZTV7ee25130[11]),  11,16},
  {&(_ZTV7ee25130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee25130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee25130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee25130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee25130[];
extern  VTBL_ENTRY _ZTV7ee25130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25130[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee251303fooEv,_ZTv0_n16_N7ee251303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee251303fooEv,_ZThn20_N7ee251303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25130 = {  "ee25130", // class name
  bases_ee25130, 4,
  &(vtc_ee25130[0]), // expected_vtbl_contents
  &(vtt_ee25130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee25130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35130  : virtual dd5130 {
  int e;
  virtual void  foo(); // _ZN7ee351303fooEv
  ~ee35130(); // tgen
  ee35130(); // tgen
};
//SIG(1 ee35130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35130 ::foo(){vfunc_called(this, "_ZN7ee351303fooEv");}
ee35130 ::~ee35130(){ note_dtor("ee35130", this);} // tgen
ee35130 ::ee35130(){ note_ctor("ee35130", this);} // tgen

static void Test_ee35130()
{
  extern Class_Descriptor cd_ee35130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee35130, buf);
    ee35130 *dp, &lv = *(dp=new (buf) ee35130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee35130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee35130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee35130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(32,16), "ee35130");
    check_base_class_offset(lv, (dd5130*), ABISELECT(16,8), "ee35130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35130.e");
    test_class_info(&lv, &cd_ee35130);
    dp->~ee35130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35130(Test_ee35130, "ee35130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee35130C1Ev();
extern void _ZN7ee35130D1Ev();
Name_Map name_map_ee35130[] = {
  NSPAIR(_ZN7ee35130C1Ev),
  NSPAIR(_ZN7ee35130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee35130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35130[];
extern void _ZN7ee351303fooEv();
extern void _ZN6dd51303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee351303fooEv,_ZTv0_n16_N7ee351303fooEv)();
extern void ABISELECT(_ZThn48_N7ee351303fooEv,_ZThn24_N7ee351303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35130[0]),
  (VTBL_ENTRY)&_ZN7ee351303fooEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee35130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee351303fooEv,_ZTv0_n16_N7ee351303fooEv),
};
extern VTBL_ENTRY _ZTV7ee35130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee35130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee35130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee35130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee35130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee35130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee35130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee35130[] = {
  {&(_ZTV7ee35130[6]),  6,23},
  {&(_ZTV7ee35130[13]),  13,23},
  {&(_ZTV7ee35130[18]),  18,23},
  {&(_ZTV7ee35130[22]),  22,23},
  {&(_tg__ZTV6dd5130__7ee35130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee35130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee35130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee35130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee35130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee35130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35130[];
extern  VTBL_ENTRY _ZTV7ee35130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35130[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee351303fooEv,_ZTv0_n16_N7ee351303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee351303fooEv,_ZThn24_N7ee351303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35130 = {  "ee35130", // class name
  bases_ee35130, 4,
  &(vtc_ee35130[0]), // expected_vtbl_contents
  &(vtt_ee35130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee35130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35130),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45130  : dd5130 {
  int e;
  virtual void  bar(); // _ZN7ee451303barEv
  ~ee45130(); // tgen
  ee45130(); // tgen
};
//SIG(1 ee45130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45130 ::bar(){vfunc_called(this, "_ZN7ee451303barEv");}
ee45130 ::~ee45130(){ note_dtor("ee45130", this);} // tgen
ee45130 ::ee45130(){ note_ctor("ee45130", this);} // tgen

static void Test_ee45130()
{
  extern Class_Descriptor cd_ee45130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee45130, buf);
    ee45130 *dp, &lv = *(dp=new (buf) ee45130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee45130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee45130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee45130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(16,12), "ee45130");
    check_base_class_offset(lv, (dd5130*), 0, "ee45130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45130.e");
    test_class_info(&lv, &cd_ee45130);
    dp->~ee45130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45130(Test_ee45130, "ee45130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee45130C1Ev();
extern void _ZN7ee45130D1Ev();
Name_Map name_map_ee45130[] = {
  NSPAIR(_ZN7ee45130C1Ev),
  NSPAIR(_ZN7ee45130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee45130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45130[];
extern void _ZN7ee451303barEv();
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee45130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45130[0]),
  (VTBL_ENTRY)&_ZN7ee451303barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee45130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee45130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee45130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee45130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee45130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee45130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee45130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee45130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee45130[] = {
  {&(_ZTV7ee45130[5]),  5,15},
  {&(_tg__ZTV6dd5130__7ee45130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee45130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee45130[4]),  4,5},
  {&(_ZTV7ee45130[10]),  10,15},
  {&(_ZTV7ee45130[14]),  14,15},
  {&(_tg__ZTV5cc130__7ee45130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee45130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee45130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee45130[];
extern  VTBL_ENTRY _ZTV7ee45130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45130[];
Class_Descriptor cd_ee45130 = {  "ee45130", // class name
  bases_ee45130, 4,
  &(vtc_ee45130[0]), // expected_vtbl_contents
  &(vtt_ee45130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee45130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45130),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55130  : virtual dd5130 {
  int e;
  virtual void  bar(); // _ZN7ee551303barEv
  ~ee55130(); // tgen
  ee55130(); // tgen
};
//SIG(1 ee55130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55130 ::bar(){vfunc_called(this, "_ZN7ee551303barEv");}
ee55130 ::~ee55130(){ note_dtor("ee55130", this);} // tgen
ee55130 ::ee55130(){ note_ctor("ee55130", this);} // tgen

static void Test_ee55130()
{
  extern Class_Descriptor cd_ee55130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee55130, buf);
    ee55130 *dp, &lv = *(dp=new (buf) ee55130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee55130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee55130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee55130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(32,16), "ee55130");
    check_base_class_offset(lv, (dd5130*), ABISELECT(16,8), "ee55130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55130.e");
    test_class_info(&lv, &cd_ee55130);
    dp->~ee55130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55130(Test_ee55130, "ee55130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee55130C1Ev();
extern void _ZN7ee55130D1Ev();
Name_Map name_map_ee55130[] = {
  NSPAIR(_ZN7ee55130C1Ev),
  NSPAIR(_ZN7ee55130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee55130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55130[];
extern void _ZN7ee551303barEv();
extern void ABISELECT(_ZTv0_n48_N7ee551303barEv,_ZTv0_n24_N7ee551303barEv)();
extern void ABISELECT(_ZThn16_N7ee551303barEv,_ZThn8_N7ee551303barEv)() __attribute__((weak));
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_ee55130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55130[0]),
  (VTBL_ENTRY)&_ZN7ee551303barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee551303barEv,_ZTv0_n24_N7ee551303barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55130[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee55130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTV7ee55130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee55130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee55130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee55130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee55130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee55130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee55130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee55130[] = {
  {&(_ZTV7ee55130[6]),  6,23},
  {&(_ZTV7ee55130[13]),  13,23},
  {&(_ZTV7ee55130[18]),  18,23},
  {&(_ZTV7ee55130[22]),  22,23},
  {&(_tg__ZTV6dd5130__7ee55130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee55130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee55130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee55130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee55130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee55130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55130[];
extern  VTBL_ENTRY _ZTV7ee55130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55130[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee551303barEv,_ZTv0_n24_N7ee551303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551303barEv,_ZThn8_N7ee551303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55130 = {  "ee55130", // class name
  bases_ee55130, 4,
  &(vtc_ee55130[0]), // expected_vtbl_contents
  &(vtt_ee55130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee55130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55130),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65130  : dd5130 {
  int e;
  virtual void  foo(); // _ZN7ee651303fooEv
  virtual void  bar(); // _ZN7ee651303barEv
  ~ee65130(); // tgen
  ee65130(); // tgen
};
//SIG(1 ee65130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65130 ::foo(){vfunc_called(this, "_ZN7ee651303fooEv");}
void  ee65130 ::bar(){vfunc_called(this, "_ZN7ee651303barEv");}
ee65130 ::~ee65130(){ note_dtor("ee65130", this);} // tgen
ee65130 ::ee65130(){ note_ctor("ee65130", this);} // tgen

static void Test_ee65130()
{
  extern Class_Descriptor cd_ee65130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee65130, buf);
    ee65130 *dp, &lv = *(dp=new (buf) ee65130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee65130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee65130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee65130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(16,12), "ee65130");
    check_base_class_offset(lv, (dd5130*), 0, "ee65130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65130.e");
    test_class_info(&lv, &cd_ee65130);
    dp->~ee65130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65130(Test_ee65130, "ee65130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee65130C1Ev();
extern void _ZN7ee65130D1Ev();
Name_Map name_map_ee65130[] = {
  NSPAIR(_ZN7ee65130C1Ev),
  NSPAIR(_ZN7ee65130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee65130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65130[];
extern void _ZN7ee651303barEv();
extern void _ZN7ee651303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee651303fooEv,_ZTv0_n16_N7ee651303fooEv)();
extern void ABISELECT(_ZThn32_N7ee651303fooEv,_ZThn20_N7ee651303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65130[0]),
  (VTBL_ENTRY)&_ZN7ee651303barEv,
  (VTBL_ENTRY)&_ZN7ee651303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee65130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee651303fooEv,_ZTv0_n16_N7ee651303fooEv),
};
extern VTBL_ENTRY _ZTV7ee65130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee65130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee65130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee65130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee65130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee65130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee65130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee65130[] = {
  {&(_ZTV7ee65130[5]),  5,16},
  {&(_tg__ZTV6dd5130__7ee65130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee65130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee65130[4]),  4,5},
  {&(_ZTV7ee65130[11]),  11,16},
  {&(_ZTV7ee65130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee65130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee65130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee65130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee65130[];
extern  VTBL_ENTRY _ZTV7ee65130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65130[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee651303fooEv,_ZTv0_n16_N7ee651303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651303fooEv,_ZThn20_N7ee651303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65130 = {  "ee65130", // class name
  bases_ee65130, 4,
  &(vtc_ee65130[0]), // expected_vtbl_contents
  &(vtt_ee65130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee65130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75130  : virtual dd5130 {
  int e;
  virtual void  foo(); // _ZN7ee751303fooEv
  virtual void  bar(); // _ZN7ee751303barEv
  ~ee75130(); // tgen
  ee75130(); // tgen
};
//SIG(1 ee75130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75130 ::foo(){vfunc_called(this, "_ZN7ee751303fooEv");}
void  ee75130 ::bar(){vfunc_called(this, "_ZN7ee751303barEv");}
ee75130 ::~ee75130(){ note_dtor("ee75130", this);} // tgen
ee75130 ::ee75130(){ note_ctor("ee75130", this);} // tgen

static void Test_ee75130()
{
  extern Class_Descriptor cd_ee75130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee75130, buf);
    ee75130 *dp, &lv = *(dp=new (buf) ee75130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee75130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee75130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee75130");
    check_base_class_offset(lv, (cc130*)(dd5130*), ABISELECT(32,16), "ee75130");
    check_base_class_offset(lv, (dd5130*), ABISELECT(16,8), "ee75130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75130.e");
    test_class_info(&lv, &cd_ee75130);
    dp->~ee75130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75130(Test_ee75130, "ee75130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee75130C1Ev();
extern void _ZN7ee75130D1Ev();
Name_Map name_map_ee75130[] = {
  NSPAIR(_ZN7ee75130C1Ev),
  NSPAIR(_ZN7ee75130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd5130;
extern VTBL_ENTRY _ZTI6dd5130[];
extern  VTBL_ENTRY _ZTV6dd5130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5130[];
static Base_Class bases_ee75130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5130,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75130[];
extern void _ZN7ee751303fooEv();
extern void _ZN7ee751303barEv();
extern void ABISELECT(_ZTv0_n48_N7ee751303barEv,_ZTv0_n24_N7ee751303barEv)();
extern void ABISELECT(_ZThn16_N7ee751303barEv,_ZThn8_N7ee751303barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee751303fooEv,_ZTv0_n16_N7ee751303fooEv)();
extern void ABISELECT(_ZThn48_N7ee751303fooEv,_ZThn24_N7ee751303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75130[0]),
  (VTBL_ENTRY)&_ZN7ee751303fooEv,
  (VTBL_ENTRY)&_ZN7ee751303barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee751303barEv,_ZTv0_n24_N7ee751303barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee75130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee751303fooEv,_ZTv0_n16_N7ee751303fooEv),
};
extern VTBL_ENTRY _ZTV7ee75130[];
extern void _ZN6dd51303barEv();
static  VTBL_ENTRY _tg__ZTV6dd5130__7ee75130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN6dd51303barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd5130__7ee75130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd5130__7ee75130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee75130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee75130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee75130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee75130[] = {
  {&(_ZTV7ee75130[6]),  6,24},
  {&(_ZTV7ee75130[14]),  14,24},
  {&(_ZTV7ee75130[19]),  19,24},
  {&(_ZTV7ee75130[23]),  23,24},
  {&(_tg__ZTV6dd5130__7ee75130[5]),  5,6},
  {&(_tg__ZTV5cc130__6dd5130__7ee75130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd5130__7ee75130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee75130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee75130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee75130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75130[];
extern  VTBL_ENTRY _ZTV7ee75130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75130[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee751303fooEv,_ZTv0_n16_N7ee751303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751303fooEv,_ZThn24_N7ee751303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee751303barEv,_ZTv0_n24_N7ee751303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751303barEv,_ZThn8_N7ee751303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75130 = {  "ee75130", // class name
  bases_ee75130, 4,
  &(vtc_ee75130[0]), // expected_vtbl_contents
  &(vtt_ee75130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee75130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75130),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6130  : cc130 {
  int d;
  virtual void  bar(); // _ZN6dd61303barEv
  virtual void  foo(); // _ZN6dd61303fooEv
  ~dd6130(); // tgen
  dd6130(); // tgen
};
//SIG(-1 dd6130) C1{ BC2{ VBC3{ VBC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd6130 ::bar(){vfunc_called(this, "_ZN6dd61303barEv");}
void  dd6130 ::foo(){vfunc_called(this, "_ZN6dd61303fooEv");}
dd6130 ::~dd6130(){ note_dtor("dd6130", this);} // tgen
dd6130 ::dd6130(){ note_ctor("dd6130", this);} // tgen

static void Test_dd6130()
{
  extern Class_Descriptor cd_dd6130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd6130, buf);
    dd6130 *dp, &lv = *(dp=new (buf) dd6130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd6130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(28,20), "dd6130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(16,12), "dd6130");
    check_base_class_offset(lv, (cc130*), 0, "dd6130");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6130.d");
    test_class_info(&lv, &cd_dd6130);
    dp->~dd6130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6130(Test_dd6130, "dd6130", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd6130C1Ev();
extern void _ZN6dd6130D1Ev();
Name_Map name_map_dd6130[] = {
  NSPAIR(_ZN6dd6130C1Ev),
  NSPAIR(_ZN6dd6130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd6130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd6130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern VTBL_ENTRY _ZTV6dd6130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd6130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd6130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd6130[] = {
  {&(_ZTV6dd6130[4]),  4,11},
  {&(_tg__ZTV5cc130__6dd6130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd6130[4]),  4,5},
  {&(_ZTV6dd6130[10]),  10,11},
  {&(_tg__ZTV4bb30__6dd6130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd6130 = {  "dd6130", // class name
  bases_dd6130, 3,
  &(vtc_dd6130[0]), // expected_vtbl_contents
  &(vtt_dd6130[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd6130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6130),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06130  : dd6130 {
  int e;
  ~ee06130(); // tgen
  ee06130(); // tgen
};
//SIG(1 ee06130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee06130 ::~ee06130(){ note_dtor("ee06130", this);} // tgen
ee06130 ::ee06130(){ note_ctor("ee06130", this);} // tgen

static void Test_ee06130()
{
  extern Class_Descriptor cd_ee06130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee06130, buf);
    ee06130 *dp, &lv = *(dp=new (buf) ee06130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee06130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee06130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(24,16), "ee06130");
    check_base_class_offset(lv, (cc130*)(dd6130*), 0, "ee06130");
    check_base_class_offset(lv, (dd6130*), 0, "ee06130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06130.e");
    test_class_info(&lv, &cd_ee06130);
    dp->~ee06130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06130(Test_ee06130, "ee06130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee06130C1Ev();
extern void _ZN7ee06130D1Ev();
Name_Map name_map_ee06130[] = {
  NSPAIR(_ZN7ee06130C1Ev),
  NSPAIR(_ZN7ee06130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee06130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee06130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee06130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern VTBL_ENTRY _ZTV7ee06130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee06130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee06130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee06130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee06130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee06130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee06130[] = {
  {&(_ZTV7ee06130[4]),  4,11},
  {&(_tg__ZTV6dd6130__7ee06130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee06130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee06130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee06130[4]),  4,5},
  {&(_ZTV7ee06130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee06130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee06130[];
extern  VTBL_ENTRY _ZTV7ee06130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06130[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee06130 = {  "ee06130", // class name
  bases_ee06130, 4,
  &(vtc_ee06130[0]), // expected_vtbl_contents
  &(vtt_ee06130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee06130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16130  : virtual dd6130 {
  int e;
  ~ee16130(); // tgen
  ee16130(); // tgen
};
//SIG(1 ee16130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee16130 ::~ee16130(){ note_dtor("ee16130", this);} // tgen
ee16130 ::ee16130(){ note_ctor("ee16130", this);} // tgen

static void Test_ee16130()
{
  extern Class_Descriptor cd_ee16130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee16130, buf);
    ee16130 *dp, &lv = *(dp=new (buf) ee16130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee16130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee16130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(32,20), "ee16130");
    check_base_class_offset(lv, (cc130*)(dd6130*), ABISELECT(16,8), "ee16130");
    check_base_class_offset(lv, (dd6130*), ABISELECT(16,8), "ee16130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16130.e");
    test_class_info(&lv, &cd_ee16130);
    dp->~ee16130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16130(Test_ee16130, "ee16130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee16130C1Ev();
extern void _ZN7ee16130D1Ev();
Name_Map name_map_ee16130[] = {
  NSPAIR(_ZN7ee16130C1Ev),
  NSPAIR(_ZN7ee16130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee16130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee16130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16130[0]),
  0,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee16130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern VTBL_ENTRY _ZTV7ee16130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee16130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee16130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee16130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee16130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee16130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee16130[] = {
  {&(_ZTV7ee16130[5]),  5,18},
  {&(_ZTV7ee16130[11]),  11,18},
  {&(_ZTV7ee16130[17]),  17,18},
  {&(_tg__ZTV6dd6130__7ee16130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee16130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee16130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee16130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee16130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee16130[];
extern  VTBL_ENTRY _ZTV7ee16130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16130[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee16130 = {  "ee16130", // class name
  bases_ee16130, 4,
  &(vtc_ee16130[0]), // expected_vtbl_contents
  &(vtt_ee16130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee16130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16130),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26130  : dd6130 {
  int e;
  virtual void  foo(); // _ZN7ee261303fooEv
  ~ee26130(); // tgen
  ee26130(); // tgen
};
//SIG(1 ee26130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26130 ::foo(){vfunc_called(this, "_ZN7ee261303fooEv");}
ee26130 ::~ee26130(){ note_dtor("ee26130", this);} // tgen
ee26130 ::ee26130(){ note_ctor("ee26130", this);} // tgen

static void Test_ee26130()
{
  extern Class_Descriptor cd_ee26130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee26130, buf);
    ee26130 *dp, &lv = *(dp=new (buf) ee26130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee26130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee26130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(24,16), "ee26130");
    check_base_class_offset(lv, (cc130*)(dd6130*), 0, "ee26130");
    check_base_class_offset(lv, (dd6130*), 0, "ee26130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26130.e");
    test_class_info(&lv, &cd_ee26130);
    dp->~ee26130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26130(Test_ee26130, "ee26130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee26130C1Ev();
extern void _ZN7ee26130D1Ev();
Name_Map name_map_ee26130[] = {
  NSPAIR(_ZN7ee26130C1Ev),
  NSPAIR(_ZN7ee26130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee26130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26130[];
extern void _ZN6dd61303barEv();
extern void _ZN7ee261303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee261303fooEv,_ZTv0_n16_N7ee261303fooEv)();
extern void ABISELECT(_ZThn24_N7ee261303fooEv,_ZThn16_N7ee261303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee26130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN7ee261303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee26130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee261303fooEv,_ZTv0_n16_N7ee261303fooEv),
};
extern VTBL_ENTRY _ZTV7ee26130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee26130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee26130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee26130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee26130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee26130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee26130[] = {
  {&(_ZTV7ee26130[4]),  4,11},
  {&(_tg__ZTV6dd6130__7ee26130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee26130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee26130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee26130[4]),  4,5},
  {&(_ZTV7ee26130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee26130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee26130[];
extern  VTBL_ENTRY _ZTV7ee26130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26130[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee261303fooEv,_ZTv0_n16_N7ee261303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee261303fooEv,_ZThn16_N7ee261303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee26130 = {  "ee26130", // class name
  bases_ee26130, 4,
  &(vtc_ee26130[0]), // expected_vtbl_contents
  &(vtt_ee26130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee26130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36130  : virtual dd6130 {
  int e;
  virtual void  foo(); // _ZN7ee361303fooEv
  ~ee36130(); // tgen
  ee36130(); // tgen
};
//SIG(1 ee36130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36130 ::foo(){vfunc_called(this, "_ZN7ee361303fooEv");}
ee36130 ::~ee36130(){ note_dtor("ee36130", this);} // tgen
ee36130 ::ee36130(){ note_ctor("ee36130", this);} // tgen

static void Test_ee36130()
{
  extern Class_Descriptor cd_ee36130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee36130, buf);
    ee36130 *dp, &lv = *(dp=new (buf) ee36130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee36130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee36130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(32,20), "ee36130");
    check_base_class_offset(lv, (cc130*)(dd6130*), ABISELECT(16,8), "ee36130");
    check_base_class_offset(lv, (dd6130*), ABISELECT(16,8), "ee36130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36130.e");
    test_class_info(&lv, &cd_ee36130);
    dp->~ee36130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36130(Test_ee36130, "ee36130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee36130C1Ev();
extern void _ZN7ee36130D1Ev();
Name_Map name_map_ee36130[] = {
  NSPAIR(_ZN7ee36130C1Ev),
  NSPAIR(_ZN7ee36130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee36130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36130[];
extern void _ZN7ee361303fooEv();
extern void _ZN6dd61303barEv();
extern void ABISELECT(_ZTv0_n48_N7ee361303fooEv,_ZTv0_n24_N7ee361303fooEv)();
extern void ABISELECT(_ZThn16_N7ee361303fooEv,_ZThn8_N7ee361303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee361303fooEv,_ZTv0_n16_N7ee361303fooEv)();
extern void ABISELECT(_ZThn32_N7ee361303fooEv,_ZThn20_N7ee361303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36130[0]),
  (VTBL_ENTRY)&_ZN7ee361303fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee361303fooEv,_ZTv0_n24_N7ee361303fooEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee36130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee361303fooEv,_ZTv0_n16_N7ee361303fooEv),
};
extern VTBL_ENTRY _ZTV7ee36130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee36130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee36130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee36130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee36130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee36130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee36130[] = {
  {&(_ZTV7ee36130[5]),  5,19},
  {&(_ZTV7ee36130[12]),  12,19},
  {&(_ZTV7ee36130[18]),  18,19},
  {&(_tg__ZTV6dd6130__7ee36130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee36130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee36130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee36130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee36130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee36130[];
extern  VTBL_ENTRY _ZTV7ee36130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36130[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee361303fooEv,_ZTv0_n16_N7ee361303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee361303fooEv,_ZThn20_N7ee361303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee361303fooEv,_ZTv0_n24_N7ee361303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361303fooEv,_ZThn8_N7ee361303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36130 = {  "ee36130", // class name
  bases_ee36130, 4,
  &(vtc_ee36130[0]), // expected_vtbl_contents
  &(vtt_ee36130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee36130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36130),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46130  : dd6130 {
  int e;
  virtual void  bar(); // _ZN7ee461303barEv
  ~ee46130(); // tgen
  ee46130(); // tgen
};
//SIG(1 ee46130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46130 ::bar(){vfunc_called(this, "_ZN7ee461303barEv");}
ee46130 ::~ee46130(){ note_dtor("ee46130", this);} // tgen
ee46130 ::ee46130(){ note_ctor("ee46130", this);} // tgen

static void Test_ee46130()
{
  extern Class_Descriptor cd_ee46130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee46130, buf);
    ee46130 *dp, &lv = *(dp=new (buf) ee46130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee46130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee46130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(24,16), "ee46130");
    check_base_class_offset(lv, (cc130*)(dd6130*), 0, "ee46130");
    check_base_class_offset(lv, (dd6130*), 0, "ee46130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46130.e");
    test_class_info(&lv, &cd_ee46130);
    dp->~ee46130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46130(Test_ee46130, "ee46130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee46130C1Ev();
extern void _ZN7ee46130D1Ev();
Name_Map name_map_ee46130[] = {
  NSPAIR(_ZN7ee46130C1Ev),
  NSPAIR(_ZN7ee46130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee46130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46130[];
extern void _ZN7ee461303barEv();
extern void _ZN6dd61303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee46130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46130[0]),
  (VTBL_ENTRY)&_ZN7ee461303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee46130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern VTBL_ENTRY _ZTV7ee46130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee46130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee46130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee46130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee46130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee46130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee46130[] = {
  {&(_ZTV7ee46130[4]),  4,11},
  {&(_tg__ZTV6dd6130__7ee46130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee46130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee46130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee46130[4]),  4,5},
  {&(_ZTV7ee46130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee46130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee46130[];
extern  VTBL_ENTRY _ZTV7ee46130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46130[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee46130 = {  "ee46130", // class name
  bases_ee46130, 4,
  &(vtc_ee46130[0]), // expected_vtbl_contents
  &(vtt_ee46130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee46130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56130  : virtual dd6130 {
  int e;
  virtual void  bar(); // _ZN7ee561303barEv
  ~ee56130(); // tgen
  ee56130(); // tgen
};
//SIG(1 ee56130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56130 ::bar(){vfunc_called(this, "_ZN7ee561303barEv");}
ee56130 ::~ee56130(){ note_dtor("ee56130", this);} // tgen
ee56130 ::ee56130(){ note_ctor("ee56130", this);} // tgen

static void Test_ee56130()
{
  extern Class_Descriptor cd_ee56130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee56130, buf);
    ee56130 *dp, &lv = *(dp=new (buf) ee56130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee56130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee56130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(32,20), "ee56130");
    check_base_class_offset(lv, (cc130*)(dd6130*), ABISELECT(16,8), "ee56130");
    check_base_class_offset(lv, (dd6130*), ABISELECT(16,8), "ee56130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56130.e");
    test_class_info(&lv, &cd_ee56130);
    dp->~ee56130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56130(Test_ee56130, "ee56130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee56130C1Ev();
extern void _ZN7ee56130D1Ev();
Name_Map name_map_ee56130[] = {
  NSPAIR(_ZN7ee56130C1Ev),
  NSPAIR(_ZN7ee56130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee56130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56130[];
extern void _ZN7ee561303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee561303barEv,_ZTv0_n20_N7ee561303barEv)();
extern void ABISELECT(_ZThn16_N7ee561303barEv,_ZThn8_N7ee561303barEv)() __attribute__((weak));
extern void _ZN6dd61303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56130[0]),
  (VTBL_ENTRY)&_ZN7ee561303barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee561303barEv,_ZTv0_n20_N7ee561303barEv),
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee56130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern VTBL_ENTRY _ZTV7ee56130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee56130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee56130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee56130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee56130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee56130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee56130[] = {
  {&(_ZTV7ee56130[5]),  5,19},
  {&(_ZTV7ee56130[12]),  12,19},
  {&(_ZTV7ee56130[18]),  18,19},
  {&(_tg__ZTV6dd6130__7ee56130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee56130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee56130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee56130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee56130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee56130[];
extern  VTBL_ENTRY _ZTV7ee56130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56130[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee561303barEv,_ZTv0_n20_N7ee561303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561303barEv,_ZThn8_N7ee561303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56130 = {  "ee56130", // class name
  bases_ee56130, 4,
  &(vtc_ee56130[0]), // expected_vtbl_contents
  &(vtt_ee56130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee56130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56130),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66130  : dd6130 {
  int e;
  virtual void  foo(); // _ZN7ee661303fooEv
  virtual void  bar(); // _ZN7ee661303barEv
  ~ee66130(); // tgen
  ee66130(); // tgen
};
//SIG(1 ee66130) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66130 ::foo(){vfunc_called(this, "_ZN7ee661303fooEv");}
void  ee66130 ::bar(){vfunc_called(this, "_ZN7ee661303barEv");}
ee66130 ::~ee66130(){ note_dtor("ee66130", this);} // tgen
ee66130 ::ee66130(){ note_ctor("ee66130", this);} // tgen

static void Test_ee66130()
{
  extern Class_Descriptor cd_ee66130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee66130, buf);
    ee66130 *dp, &lv = *(dp=new (buf) ee66130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee66130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(36,24), "ee66130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(24,16), "ee66130");
    check_base_class_offset(lv, (cc130*)(dd6130*), 0, "ee66130");
    check_base_class_offset(lv, (dd6130*), 0, "ee66130");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66130.e");
    test_class_info(&lv, &cd_ee66130);
    dp->~ee66130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66130(Test_ee66130, "ee66130", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee66130C1Ev();
extern void _ZN7ee66130D1Ev();
Name_Map name_map_ee66130[] = {
  NSPAIR(_ZN7ee66130C1Ev),
  NSPAIR(_ZN7ee66130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee66130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66130[];
extern void _ZN7ee661303barEv();
extern void _ZN7ee661303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee661303fooEv,_ZTv0_n16_N7ee661303fooEv)();
extern void ABISELECT(_ZThn24_N7ee661303fooEv,_ZThn16_N7ee661303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee66130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66130[0]),
  (VTBL_ENTRY)&_ZN7ee661303barEv,
  (VTBL_ENTRY)&_ZN7ee661303fooEv,
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee66130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee661303fooEv,_ZTv0_n16_N7ee661303fooEv),
};
extern VTBL_ENTRY _ZTV7ee66130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee66130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee66130[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee66130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee66130[] = {
  ABISELECT(-24,-16),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee66130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee66130[] = {
  {&(_ZTV7ee66130[4]),  4,11},
  {&(_tg__ZTV6dd6130__7ee66130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee66130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee66130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee66130[4]),  4,5},
  {&(_ZTV7ee66130[10]),  10,11},
  {&(_tg__ZTV4bb30__7ee66130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee66130[];
extern  VTBL_ENTRY _ZTV7ee66130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66130[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61303fooEv,_ZThn16_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee661303fooEv,_ZTv0_n16_N7ee661303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661303fooEv,_ZThn16_N7ee661303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee66130 = {  "ee66130", // class name
  bases_ee66130, 4,
  &(vtc_ee66130[0]), // expected_vtbl_contents
  &(vtt_ee66130[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee66130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66130),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66130),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76130  : virtual dd6130 {
  int e;
  virtual void  foo(); // _ZN7ee761303fooEv
  virtual void  bar(); // _ZN7ee761303barEv
  ~ee76130(); // tgen
  ee76130(); // tgen
};
//SIG(1 ee76130) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76130 ::foo(){vfunc_called(this, "_ZN7ee761303fooEv");}
void  ee76130 ::bar(){vfunc_called(this, "_ZN7ee761303barEv");}
ee76130 ::~ee76130(){ note_dtor("ee76130", this);} // tgen
ee76130 ::ee76130(){ note_ctor("ee76130", this);} // tgen

static void Test_ee76130()
{
  extern Class_Descriptor cd_ee76130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee76130, buf);
    ee76130 *dp, &lv = *(dp=new (buf) ee76130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee76130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee76130");
    check_base_class_offset(lv, (bb30*)(cc130*)(dd6130*), ABISELECT(32,20), "ee76130");
    check_base_class_offset(lv, (cc130*)(dd6130*), ABISELECT(16,8), "ee76130");
    check_base_class_offset(lv, (dd6130*), ABISELECT(16,8), "ee76130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76130.e");
    test_class_info(&lv, &cd_ee76130);
    dp->~ee76130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76130(Test_ee76130, "ee76130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee76130C1Ev();
extern void _ZN7ee76130D1Ev();
Name_Map name_map_ee76130[] = {
  NSPAIR(_ZN7ee76130C1Ev),
  NSPAIR(_ZN7ee76130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd6130;
extern VTBL_ENTRY _ZTI6dd6130[];
extern  VTBL_ENTRY _ZTV6dd6130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6130[];
static Base_Class bases_ee76130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76130[];
extern void _ZN7ee761303fooEv();
extern void _ZN7ee761303barEv();
extern void ABISELECT(_ZTv0_n40_N7ee761303barEv,_ZTv0_n20_N7ee761303barEv)();
extern void ABISELECT(_ZThn16_N7ee761303barEv,_ZThn8_N7ee761303barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee761303fooEv,_ZTv0_n24_N7ee761303fooEv)();
extern void ABISELECT(_ZThn16_N7ee761303fooEv,_ZThn8_N7ee761303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee761303fooEv,_ZTv0_n16_N7ee761303fooEv)();
extern void ABISELECT(_ZThn32_N7ee761303fooEv,_ZThn20_N7ee761303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76130[0]),
  (VTBL_ENTRY)&_ZN7ee761303fooEv,
  (VTBL_ENTRY)&_ZN7ee761303barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761303barEv,_ZTv0_n20_N7ee761303barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee761303fooEv,_ZTv0_n24_N7ee761303fooEv),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee76130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761303fooEv,_ZTv0_n16_N7ee761303fooEv),
};
extern VTBL_ENTRY _ZTV7ee76130[];
extern void _ZN6dd61303barEv();
extern void _ZN6dd61303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6130__7ee76130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&_ZN6dd61303barEv,
  (VTBL_ENTRY)&_ZN6dd61303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1306dd6130__7ee76130[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc1306dd6130__7ee76130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv)();
extern void ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd6130__7ee76130[] = {
  ABISELECT(-16,-12),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee76130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee76130[] = {
  {&(_ZTV7ee76130[5]),  5,20},
  {&(_ZTV7ee76130[13]),  13,20},
  {&(_ZTV7ee76130[19]),  19,20},
  {&(_tg__ZTV6dd6130__7ee76130[4]),  4,6},
  {&(_tg__ZTV5cc1306dd6130__7ee76130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc1306dd6130__7ee76130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd6130__7ee76130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee76130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee76130[];
extern  VTBL_ENTRY _ZTV7ee76130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76130[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd61303fooEv,_ZTv0_n16_N6dd61303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61303fooEv,_ZThn12_N6dd61303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761303fooEv,_ZTv0_n16_N7ee761303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761303fooEv,_ZThn20_N7ee761303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee761303fooEv,_ZTv0_n24_N7ee761303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761303fooEv,_ZThn8_N7ee761303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761303barEv,_ZTv0_n20_N7ee761303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761303barEv,_ZThn8_N7ee761303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76130 = {  "ee76130", // class name
  bases_ee76130, 4,
  &(vtc_ee76130[0]), // expected_vtbl_contents
  &(vtt_ee76130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee76130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76130),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76130),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7130  : virtual cc130 {
  int d;
  virtual void  bar(); // _ZN6dd71303barEv
  virtual void  foo(); // _ZN6dd71303fooEv
  ~dd7130(); // tgen
  dd7130(); // tgen
};
//SIG(-1 dd7130) C1{ VBC2{ VBC3{ VBC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd7130 ::bar(){vfunc_called(this, "_ZN6dd71303barEv");}
void  dd7130 ::foo(){vfunc_called(this, "_ZN6dd71303fooEv");}
dd7130 ::~dd7130(){ note_dtor("dd7130", this);} // tgen
dd7130 ::dd7130(){ note_ctor("dd7130", this);} // tgen

static void Test_dd7130()
{
  extern Class_Descriptor cd_dd7130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd7130, buf);
    dd7130 *dp, &lv = *(dp=new (buf) dd7130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd7130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,24), "dd7130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,16), "dd7130");
    check_base_class_offset(lv, (cc130*), ABISELECT(16,8), "dd7130");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7130.d");
    test_class_info(&lv, &cd_dd7130);
    dp->~dd7130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7130(Test_dd7130, "dd7130", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd7130C1Ev();
extern void _ZN6dd7130D1Ev();
Name_Map name_map_dd7130[] = {
  NSPAIR(_ZN6dd7130C1Ev),
  NSPAIR(_ZN6dd7130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
static Base_Class bases_dd7130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
extern VTBL_ENTRY _ZTV6dd7130[];
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__6dd7130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd7130[] = {
  {&(_ZTV6dd7130[5]),  5,16},
  {&(_ZTV6dd7130[11]),  11,16},
  {&(_ZTV6dd7130[15]),  15,16},
  {&(_tg__ZTV5cc130__6dd7130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__6dd7130[4]),  4,5},
  {&(_tg__ZTV4bb30__6dd7130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7130 = {  "dd7130", // class name
  bases_dd7130, 3,
  &(vtc_dd7130[0]), // expected_vtbl_contents
  &(vtt_dd7130[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd7130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7130),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07130  : dd7130 {
  int e;
  ~ee07130(); // tgen
  ee07130(); // tgen
};
//SIG(1 ee07130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee07130 ::~ee07130(){ note_dtor("ee07130", this);} // tgen
ee07130 ::ee07130(){ note_ctor("ee07130", this);} // tgen

static void Test_ee07130()
{
  extern Class_Descriptor cd_ee07130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee07130, buf);
    ee07130 *dp, &lv = *(dp=new (buf) ee07130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee07130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee07130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee07130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(16,12), "ee07130");
    check_base_class_offset(lv, (dd7130*), 0, "ee07130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07130.e");
    test_class_info(&lv, &cd_ee07130);
    dp->~ee07130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07130(Test_ee07130, "ee07130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee07130C1Ev();
extern void _ZN7ee07130D1Ev();
Name_Map name_map_ee07130[] = {
  NSPAIR(_ZN7ee07130C1Ev),
  NSPAIR(_ZN7ee07130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee07130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee07130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
extern VTBL_ENTRY _ZTV7ee07130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee07130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee07130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee07130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee07130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee07130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee07130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee07130[] = {
  {&(_ZTV7ee07130[5]),  5,16},
  {&(_tg__ZTV6dd7130__7ee07130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee07130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee07130[4]),  4,5},
  {&(_ZTV7ee07130[11]),  11,16},
  {&(_ZTV7ee07130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee07130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee07130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee07130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee07130[];
extern  VTBL_ENTRY _ZTV7ee07130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07130[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07130 = {  "ee07130", // class name
  bases_ee07130, 4,
  &(vtc_ee07130[0]), // expected_vtbl_contents
  &(vtt_ee07130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee07130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17130  : virtual dd7130 {
  int e;
  ~ee17130(); // tgen
  ee17130(); // tgen
};
//SIG(1 ee17130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee17130 ::~ee17130(){ note_dtor("ee17130", this);} // tgen
ee17130 ::ee17130(){ note_ctor("ee17130", this);} // tgen

static void Test_ee17130()
{
  extern Class_Descriptor cd_ee17130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee17130, buf);
    ee17130 *dp, &lv = *(dp=new (buf) ee17130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee17130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee17130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee17130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(32,16), "ee17130");
    check_base_class_offset(lv, (dd7130*), ABISELECT(16,8), "ee17130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17130.e");
    test_class_info(&lv, &cd_ee17130);
    dp->~ee17130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17130(Test_ee17130, "ee17130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee17130C1Ev();
extern void _ZN7ee17130D1Ev();
Name_Map name_map_ee17130[] = {
  NSPAIR(_ZN7ee17130C1Ev),
  NSPAIR(_ZN7ee17130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee17130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17130[0]),
  0,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17130[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee17130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
extern VTBL_ENTRY _ZTV7ee17130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee17130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee17130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee17130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee17130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee17130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee17130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee17130[] = {
  {&(_ZTV7ee17130[6]),  6,24},
  {&(_ZTV7ee17130[13]),  13,24},
  {&(_ZTV7ee17130[19]),  19,24},
  {&(_ZTV7ee17130[23]),  23,24},
  {&(_tg__ZTV6dd7130__7ee17130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee17130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee17130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee17130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee17130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee17130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17130[];
extern  VTBL_ENTRY _ZTV7ee17130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17130[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17130 = {  "ee17130", // class name
  bases_ee17130, 4,
  &(vtc_ee17130[0]), // expected_vtbl_contents
  &(vtt_ee17130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee17130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17130),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27130  : dd7130 {
  int e;
  virtual void  foo(); // _ZN7ee271303fooEv
  ~ee27130(); // tgen
  ee27130(); // tgen
};
//SIG(1 ee27130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27130 ::foo(){vfunc_called(this, "_ZN7ee271303fooEv");}
ee27130 ::~ee27130(){ note_dtor("ee27130", this);} // tgen
ee27130 ::ee27130(){ note_ctor("ee27130", this);} // tgen

static void Test_ee27130()
{
  extern Class_Descriptor cd_ee27130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee27130, buf);
    ee27130 *dp, &lv = *(dp=new (buf) ee27130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee27130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee27130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee27130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(16,12), "ee27130");
    check_base_class_offset(lv, (dd7130*), 0, "ee27130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27130.e");
    test_class_info(&lv, &cd_ee27130);
    dp->~ee27130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27130(Test_ee27130, "ee27130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee27130C1Ev();
extern void _ZN7ee27130D1Ev();
Name_Map name_map_ee27130[] = {
  NSPAIR(_ZN7ee27130C1Ev),
  NSPAIR(_ZN7ee27130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee27130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27130[];
extern void _ZN6dd71303barEv();
extern void _ZN7ee271303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee271303fooEv,_ZTv0_n16_N7ee271303fooEv)();
extern void ABISELECT(_ZThn32_N7ee271303fooEv,_ZThn20_N7ee271303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN7ee271303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee27130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee271303fooEv,_ZTv0_n16_N7ee271303fooEv),
};
extern VTBL_ENTRY _ZTV7ee27130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee27130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee27130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee27130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee27130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee27130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee27130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee27130[] = {
  {&(_ZTV7ee27130[5]),  5,16},
  {&(_tg__ZTV6dd7130__7ee27130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee27130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee27130[4]),  4,5},
  {&(_ZTV7ee27130[11]),  11,16},
  {&(_ZTV7ee27130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee27130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee27130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee27130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee27130[];
extern  VTBL_ENTRY _ZTV7ee27130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27130[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee271303fooEv,_ZTv0_n16_N7ee271303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee271303fooEv,_ZThn20_N7ee271303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27130 = {  "ee27130", // class name
  bases_ee27130, 4,
  &(vtc_ee27130[0]), // expected_vtbl_contents
  &(vtt_ee27130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee27130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37130  : virtual dd7130 {
  int e;
  virtual void  foo(); // _ZN7ee371303fooEv
  ~ee37130(); // tgen
  ee37130(); // tgen
};
//SIG(1 ee37130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37130 ::foo(){vfunc_called(this, "_ZN7ee371303fooEv");}
ee37130 ::~ee37130(){ note_dtor("ee37130", this);} // tgen
ee37130 ::ee37130(){ note_ctor("ee37130", this);} // tgen

static void Test_ee37130()
{
  extern Class_Descriptor cd_ee37130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee37130, buf);
    ee37130 *dp, &lv = *(dp=new (buf) ee37130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee37130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee37130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee37130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(32,16), "ee37130");
    check_base_class_offset(lv, (dd7130*), ABISELECT(16,8), "ee37130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37130.e");
    test_class_info(&lv, &cd_ee37130);
    dp->~ee37130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37130(Test_ee37130, "ee37130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee37130C1Ev();
extern void _ZN7ee37130D1Ev();
Name_Map name_map_ee37130[] = {
  NSPAIR(_ZN7ee37130C1Ev),
  NSPAIR(_ZN7ee37130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee37130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37130[];
extern void _ZN7ee371303fooEv();
extern void _ZN6dd71303barEv();
extern void ABISELECT(_ZTv0_n56_N7ee371303fooEv,_ZTv0_n28_N7ee371303fooEv)();
extern void ABISELECT(_ZThn16_N7ee371303fooEv,_ZThn8_N7ee371303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee371303fooEv,_ZTv0_n16_N7ee371303fooEv)();
extern void ABISELECT(_ZThn48_N7ee371303fooEv,_ZThn24_N7ee371303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37130[0]),
  (VTBL_ENTRY)&_ZN7ee371303fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee371303fooEv,_ZTv0_n28_N7ee371303fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee37130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee371303fooEv,_ZTv0_n16_N7ee371303fooEv),
};
extern VTBL_ENTRY _ZTV7ee37130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee37130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee37130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee37130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee37130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee37130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee37130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee37130[] = {
  {&(_ZTV7ee37130[6]),  6,25},
  {&(_ZTV7ee37130[14]),  14,25},
  {&(_ZTV7ee37130[20]),  20,25},
  {&(_ZTV7ee37130[24]),  24,25},
  {&(_tg__ZTV6dd7130__7ee37130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee37130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee37130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee37130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee37130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee37130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37130[];
extern  VTBL_ENTRY _ZTV7ee37130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37130[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee371303fooEv,_ZTv0_n16_N7ee371303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee371303fooEv,_ZThn24_N7ee371303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee371303fooEv,_ZTv0_n28_N7ee371303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371303fooEv,_ZThn8_N7ee371303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37130 = {  "ee37130", // class name
  bases_ee37130, 4,
  &(vtc_ee37130[0]), // expected_vtbl_contents
  &(vtt_ee37130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee37130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37130),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47130  : dd7130 {
  int e;
  virtual void  bar(); // _ZN7ee471303barEv
  ~ee47130(); // tgen
  ee47130(); // tgen
};
//SIG(1 ee47130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47130 ::bar(){vfunc_called(this, "_ZN7ee471303barEv");}
ee47130 ::~ee47130(){ note_dtor("ee47130", this);} // tgen
ee47130 ::ee47130(){ note_ctor("ee47130", this);} // tgen

static void Test_ee47130()
{
  extern Class_Descriptor cd_ee47130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee47130, buf);
    ee47130 *dp, &lv = *(dp=new (buf) ee47130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee47130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee47130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee47130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(16,12), "ee47130");
    check_base_class_offset(lv, (dd7130*), 0, "ee47130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47130.e");
    test_class_info(&lv, &cd_ee47130);
    dp->~ee47130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47130(Test_ee47130, "ee47130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee47130C1Ev();
extern void _ZN7ee47130D1Ev();
Name_Map name_map_ee47130[] = {
  NSPAIR(_ZN7ee47130C1Ev),
  NSPAIR(_ZN7ee47130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee47130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47130[];
extern void _ZN7ee471303barEv();
extern void _ZN6dd71303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47130[0]),
  (VTBL_ENTRY)&_ZN7ee471303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee47130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
extern VTBL_ENTRY _ZTV7ee47130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee47130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee47130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee47130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee47130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee47130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee47130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee47130[] = {
  {&(_ZTV7ee47130[5]),  5,16},
  {&(_tg__ZTV6dd7130__7ee47130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee47130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee47130[4]),  4,5},
  {&(_ZTV7ee47130[11]),  11,16},
  {&(_ZTV7ee47130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee47130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee47130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee47130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee47130[];
extern  VTBL_ENTRY _ZTV7ee47130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47130[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47130 = {  "ee47130", // class name
  bases_ee47130, 4,
  &(vtc_ee47130[0]), // expected_vtbl_contents
  &(vtt_ee47130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee47130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57130  : virtual dd7130 {
  int e;
  virtual void  bar(); // _ZN7ee571303barEv
  ~ee57130(); // tgen
  ee57130(); // tgen
};
//SIG(1 ee57130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57130 ::bar(){vfunc_called(this, "_ZN7ee571303barEv");}
ee57130 ::~ee57130(){ note_dtor("ee57130", this);} // tgen
ee57130 ::ee57130(){ note_ctor("ee57130", this);} // tgen

static void Test_ee57130()
{
  extern Class_Descriptor cd_ee57130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee57130, buf);
    ee57130 *dp, &lv = *(dp=new (buf) ee57130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee57130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee57130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee57130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(32,16), "ee57130");
    check_base_class_offset(lv, (dd7130*), ABISELECT(16,8), "ee57130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57130.e");
    test_class_info(&lv, &cd_ee57130);
    dp->~ee57130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57130(Test_ee57130, "ee57130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee57130C1Ev();
extern void _ZN7ee57130D1Ev();
Name_Map name_map_ee57130[] = {
  NSPAIR(_ZN7ee57130C1Ev),
  NSPAIR(_ZN7ee57130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee57130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57130[];
extern void _ZN7ee571303barEv();
extern void ABISELECT(_ZTv0_n48_N7ee571303barEv,_ZTv0_n24_N7ee571303barEv)();
extern void ABISELECT(_ZThn16_N7ee571303barEv,_ZThn8_N7ee571303barEv)() __attribute__((weak));
extern void _ZN6dd71303fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57130[0]),
  (VTBL_ENTRY)&_ZN7ee571303barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee571303barEv,_ZTv0_n24_N7ee571303barEv),
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57130[0]),
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee57130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
extern VTBL_ENTRY _ZTV7ee57130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee57130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee57130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee57130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee57130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee57130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee57130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee57130[] = {
  {&(_ZTV7ee57130[6]),  6,25},
  {&(_ZTV7ee57130[14]),  14,25},
  {&(_ZTV7ee57130[20]),  20,25},
  {&(_ZTV7ee57130[24]),  24,25},
  {&(_tg__ZTV6dd7130__7ee57130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee57130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee57130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee57130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee57130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee57130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57130[];
extern  VTBL_ENTRY _ZTV7ee57130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57130[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee571303barEv,_ZTv0_n24_N7ee571303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571303barEv,_ZThn8_N7ee571303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57130 = {  "ee57130", // class name
  bases_ee57130, 4,
  &(vtc_ee57130[0]), // expected_vtbl_contents
  &(vtt_ee57130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee57130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57130),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67130  : dd7130 {
  int e;
  virtual void  foo(); // _ZN7ee671303fooEv
  virtual void  bar(); // _ZN7ee671303barEv
  ~ee67130(); // tgen
  ee67130(); // tgen
};
//SIG(1 ee67130) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67130 ::foo(){vfunc_called(this, "_ZN7ee671303fooEv");}
void  ee67130 ::bar(){vfunc_called(this, "_ZN7ee671303barEv");}
ee67130 ::~ee67130(){ note_dtor("ee67130", this);} // tgen
ee67130 ::ee67130(){ note_ctor("ee67130", this);} // tgen

static void Test_ee67130()
{
  extern Class_Descriptor cd_ee67130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee67130, buf);
    ee67130 *dp, &lv = *(dp=new (buf) ee67130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee67130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(44,28), "ee67130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(32,20), "ee67130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(16,12), "ee67130");
    check_base_class_offset(lv, (dd7130*), 0, "ee67130");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67130.e");
    test_class_info(&lv, &cd_ee67130);
    dp->~ee67130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67130(Test_ee67130, "ee67130", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee67130C1Ev();
extern void _ZN7ee67130D1Ev();
Name_Map name_map_ee67130[] = {
  NSPAIR(_ZN7ee67130C1Ev),
  NSPAIR(_ZN7ee67130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee67130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67130[];
extern void _ZN7ee671303barEv();
extern void _ZN7ee671303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee671303fooEv,_ZTv0_n16_N7ee671303fooEv)();
extern void ABISELECT(_ZThn32_N7ee671303fooEv,_ZThn20_N7ee671303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67130[0]),
  (VTBL_ENTRY)&_ZN7ee671303barEv,
  (VTBL_ENTRY)&_ZN7ee671303fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67130[0]),
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee67130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee671303fooEv,_ZTv0_n16_N7ee671303fooEv),
};
extern VTBL_ENTRY _ZTV7ee67130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee67130[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee67130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee67130[] = {
  ABISELECT(-32,-20),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee67130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee67130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee67130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee67130[] = {
  {&(_ZTV7ee67130[5]),  5,16},
  {&(_tg__ZTV6dd7130__7ee67130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee67130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee67130[4]),  4,5},
  {&(_ZTV7ee67130[11]),  11,16},
  {&(_ZTV7ee67130[15]),  15,16},
  {&(_tg__ZTV5cc130__7ee67130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee67130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee67130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee67130[];
extern  VTBL_ENTRY _ZTV7ee67130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67130[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn20_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee671303fooEv,_ZTv0_n16_N7ee671303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671303fooEv,_ZThn20_N7ee671303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67130 = {  "ee67130", // class name
  bases_ee67130, 4,
  &(vtc_ee67130[0]), // expected_vtbl_contents
  &(vtt_ee67130[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee67130),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67130),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67130),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77130  : virtual dd7130 {
  int e;
  virtual void  foo(); // _ZN7ee771303fooEv
  virtual void  bar(); // _ZN7ee771303barEv
  ~ee77130(); // tgen
  ee77130(); // tgen
};
//SIG(1 ee77130) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77130 ::foo(){vfunc_called(this, "_ZN7ee771303fooEv");}
void  ee77130 ::bar(){vfunc_called(this, "_ZN7ee771303barEv");}
ee77130 ::~ee77130(){ note_dtor("ee77130", this);} // tgen
ee77130 ::ee77130(){ note_ctor("ee77130", this);} // tgen

static void Test_ee77130()
{
  extern Class_Descriptor cd_ee77130;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee77130, buf);
    ee77130 *dp, &lv = *(dp=new (buf) ee77130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee77130)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77130)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(60,32), "ee77130");
    check_base_class_offset(lv, (bb30*)(cc130*), ABISELECT(48,24), "ee77130");
    check_base_class_offset(lv, (cc130*)(dd7130*), ABISELECT(32,16), "ee77130");
    check_base_class_offset(lv, (dd7130*), ABISELECT(16,8), "ee77130");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77130.e");
    test_class_info(&lv, &cd_ee77130);
    dp->~ee77130();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77130(Test_ee77130, "ee77130", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee77130C1Ev();
extern void _ZN7ee77130D1Ev();
Name_Map name_map_ee77130[] = {
  NSPAIR(_ZN7ee77130C1Ev),
  NSPAIR(_ZN7ee77130D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc130;
extern VTBL_ENTRY _ZTI5cc130[];
extern  VTBL_ENTRY _ZTV5cc130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc130[];
extern Class_Descriptor cd_dd7130;
extern VTBL_ENTRY _ZTI6dd7130[];
extern  VTBL_ENTRY _ZTV6dd7130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7130[];
static Base_Class bases_ee77130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(48,24), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc130,    ABISELECT(32,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7130,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77130[];
extern void _ZN7ee771303fooEv();
extern void _ZN7ee771303barEv();
extern void ABISELECT(_ZTv0_n48_N7ee771303barEv,_ZTv0_n24_N7ee771303barEv)();
extern void ABISELECT(_ZThn16_N7ee771303barEv,_ZThn8_N7ee771303barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7ee771303fooEv,_ZTv0_n28_N7ee771303fooEv)();
extern void ABISELECT(_ZThn16_N7ee771303fooEv,_ZThn8_N7ee771303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee771303fooEv,_ZTv0_n16_N7ee771303fooEv)();
extern void ABISELECT(_ZThn48_N7ee771303fooEv,_ZThn24_N7ee771303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77130[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77130[0]),
  (VTBL_ENTRY)&_ZN7ee771303fooEv,
  (VTBL_ENTRY)&_ZN7ee771303barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771303barEv,_ZTv0_n24_N7ee771303barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee771303fooEv,_ZTv0_n28_N7ee771303fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77130[0]),
  ABISELECT(-48,-24),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee77130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee771303fooEv,_ZTv0_n16_N7ee771303fooEv),
};
extern VTBL_ENTRY _ZTV7ee77130[];
extern void _ZN6dd71303barEv();
extern void _ZN6dd71303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7130__7ee77130[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&_ZN6dd71303barEv,
  (VTBL_ENTRY)&_ZN6dd71303fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc130__6dd7130__7ee77130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
};
extern void ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv)();
extern void ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__6dd7130__7ee77130[] = {
  ABISELECT(-32,-16),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7130[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc130__7ee77130[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc130__7ee77130[] = {
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc130[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__7ee77130[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee77130[] = {
  {&(_ZTV7ee77130[6]),  6,26},
  {&(_ZTV7ee77130[15]),  15,26},
  {&(_ZTV7ee77130[21]),  21,26},
  {&(_ZTV7ee77130[25]),  25,26},
  {&(_tg__ZTV6dd7130__7ee77130[5]),  5,7},
  {&(_tg__ZTV5cc130__6dd7130__7ee77130[4]),  4,4},
  {&(_tg__ZTV4bb30__6dd7130__7ee77130[4]),  4,5},
  {&(_tg__ZTV5cc130__7ee77130[4]),  4,4},
  {&(_tg__ZTV4bb30__5cc130__7ee77130[4]),  4,5},
  {&(_tg__ZTV4bb30__7ee77130[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77130[];
extern  VTBL_ENTRY _ZTV7ee77130[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77130[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd71303fooEv,_ZTv0_n16_N6dd71303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71303fooEv,_ZThn16_N6dd71303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee771303fooEv,_ZTv0_n16_N7ee771303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771303fooEv,_ZThn24_N7ee771303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee771303fooEv,_ZTv0_n28_N7ee771303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771303fooEv,_ZThn8_N7ee771303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771303barEv,_ZTv0_n24_N7ee771303barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771303barEv,_ZThn8_N7ee771303barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77130 = {  "ee77130", // class name
  bases_ee77130, 4,
  &(vtc_ee77130[0]), // expected_vtbl_contents
  &(vtt_ee77130[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee77130),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77130),26, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77130),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc230  : bb30 {
  int c;
  virtual void  foo(); // _ZN5cc2303fooEv
  ~cc230(); // tgen
  cc230(); // tgen
};
//SIG(-1 cc230) C1{ BC2{ VBC3{ Fi} v1 Fi} v1 Fi}


void  cc230 ::foo(){vfunc_called(this, "_ZN5cc2303fooEv");}
cc230 ::~cc230(){ note_dtor("cc230", this);} // tgen
cc230 ::cc230(){ note_ctor("cc230", this);} // tgen

static void Test_cc230()
{
  extern Class_Descriptor cd_cc230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc230, buf);
    cc230 *dp, &lv = *(dp=new (buf) cc230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc230)");
    check_base_class_offset(lv, (aa0*)(bb30*), ABISELECT(16,12), "cc230");
    check_base_class_offset(lv, (bb30*), 0, "cc230");
    check_field_offset(lv, c, ABISELECT(12,8), "cc230.c");
    test_class_info(&lv, &cd_cc230);
    dp->~cc230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc230(Test_cc230, "cc230", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc230C1Ev();
extern void _ZN5cc230D1Ev();
Name_Map name_map_cc230[] = {
  NSPAIR(_ZN5cc230C1Ev),
  NSPAIR(_ZN5cc230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
static Base_Class bases_cc230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_cc230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV5cc230[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb30__5cc230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_cc230[] = {
  {&(_ZTV5cc230[3]),  3,4},
  {&(_tg__ZTV4bb30__5cc230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
Class_Descriptor cd_cc230 = {  "cc230", // class name
  bases_cc230, 2,
  &(vtc_cc230[0]), // expected_vtbl_contents
  &(vtt_cc230[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc230),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc230),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0230  : cc230 {
  int d;
  ~dd0230(); // tgen
  dd0230(); // tgen
};
//SIG(-1 dd0230) C1{ BC2{ BC3{ VBC4{ Fi} v1 Fi} v1 Fi} Fi}


dd0230 ::~dd0230(){ note_dtor("dd0230", this);} // tgen
dd0230 ::dd0230(){ note_ctor("dd0230", this);} // tgen

static void Test_dd0230()
{
  extern Class_Descriptor cd_dd0230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0230, buf);
    dd0230 *dp, &lv = *(dp=new (buf) dd0230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(20,16), "dd0230");
    check_base_class_offset(lv, (bb30*)(cc230*), 0, "dd0230");
    check_base_class_offset(lv, (cc230*), 0, "dd0230");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0230.d");
    test_class_info(&lv, &cd_dd0230);
    dp->~dd0230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0230(Test_dd0230, "dd0230", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0230C1Ev();
extern void _ZN6dd0230D1Ev();
Name_Map name_map_dd0230[] = {
  NSPAIR(_ZN6dd0230C1Ev),
  NSPAIR(_ZN6dd0230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
static Base_Class bases_dd0230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_dd0230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV6dd0230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd0230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__6dd0230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd0230[] = {
  {&(_ZTV6dd0230[3]),  3,4},
  {&(_tg__ZTV5cc230__6dd0230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__6dd0230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
Class_Descriptor cd_dd0230 = {  "dd0230", // class name
  bases_dd0230, 3,
  &(vtc_dd0230[0]), // expected_vtbl_contents
  &(vtt_dd0230[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0230),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0230),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00230  : dd0230 {
  int e;
  ~ee00230(); // tgen
  ee00230(); // tgen
};
//SIG(1 ee00230) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee00230 ::~ee00230(){ note_dtor("ee00230", this);} // tgen
ee00230 ::ee00230(){ note_ctor("ee00230", this);} // tgen

static void Test_ee00230()
{
  extern Class_Descriptor cd_ee00230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00230, buf);
    ee00230 *dp, &lv = *(dp=new (buf) ee00230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(24,20), "ee00230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), 0, "ee00230");
    check_base_class_offset(lv, (cc230*)(dd0230*), 0, "ee00230");
    check_base_class_offset(lv, (dd0230*), 0, "ee00230");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00230.e");
    test_class_info(&lv, &cd_ee00230);
    dp->~ee00230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00230(Test_ee00230, "ee00230", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00230C1Ev();
extern void _ZN7ee00230D1Ev();
Name_Map name_map_ee00230[] = {
  NSPAIR(_ZN7ee00230C1Ev),
  NSPAIR(_ZN7ee00230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee00230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_ee00230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV7ee00230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee00230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee00230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee00230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee00230[] = {
  {&(_ZTV7ee00230[3]),  3,4},
  {&(_tg__ZTV6dd0230__7ee00230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee00230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee00230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee00230[];
extern  VTBL_ENTRY _ZTV7ee00230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00230[];
Class_Descriptor cd_ee00230 = {  "ee00230", // class name
  bases_ee00230, 4,
  &(vtc_ee00230[0]), // expected_vtbl_contents
  &(vtt_ee00230[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00230),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00230),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10230  : virtual dd0230 {
  int e;
  ~ee10230(); // tgen
  ee10230(); // tgen
};
//SIG(1 ee10230) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee10230 ::~ee10230(){ note_dtor("ee10230", this);} // tgen
ee10230 ::ee10230(){ note_ctor("ee10230", this);} // tgen

static void Test_ee10230()
{
  extern Class_Descriptor cd_ee10230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10230, buf);
    ee10230 *dp, &lv = *(dp=new (buf) ee10230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(36,24), "ee10230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), ABISELECT(16,8), "ee10230");
    check_base_class_offset(lv, (cc230*)(dd0230*), ABISELECT(16,8), "ee10230");
    check_base_class_offset(lv, (dd0230*), ABISELECT(16,8), "ee10230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10230.e");
    test_class_info(&lv, &cd_ee10230);
    dp->~ee10230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10230(Test_ee10230, "ee10230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10230C1Ev();
extern void _ZN7ee10230D1Ev();
Name_Map name_map_ee10230[] = {
  NSPAIR(_ZN7ee10230C1Ev),
  NSPAIR(_ZN7ee10230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee10230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_ee10230[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10230[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV7ee10230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee10230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee10230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee10230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee10230[] = {
  {&(_ZTV7ee10230[4]),  4,9},
  {&(_ZTV7ee10230[8]),  8,9},
  {&(_tg__ZTV6dd0230__7ee10230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee10230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee10230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10230[];
extern  VTBL_ENTRY _ZTV7ee10230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10230[];
Class_Descriptor cd_ee10230 = {  "ee10230", // class name
  bases_ee10230, 4,
  &(vtc_ee10230[0]), // expected_vtbl_contents
  &(vtt_ee10230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10230),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10230),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20230  : dd0230 {
  int e;
  virtual void  foo(); // _ZN7ee202303fooEv
  ~ee20230(); // tgen
  ee20230(); // tgen
};
//SIG(1 ee20230) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee20230 ::foo(){vfunc_called(this, "_ZN7ee202303fooEv");}
ee20230 ::~ee20230(){ note_dtor("ee20230", this);} // tgen
ee20230 ::ee20230(){ note_ctor("ee20230", this);} // tgen

static void Test_ee20230()
{
  extern Class_Descriptor cd_ee20230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20230, buf);
    ee20230 *dp, &lv = *(dp=new (buf) ee20230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(24,20), "ee20230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), 0, "ee20230");
    check_base_class_offset(lv, (cc230*)(dd0230*), 0, "ee20230");
    check_base_class_offset(lv, (dd0230*), 0, "ee20230");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20230.e");
    test_class_info(&lv, &cd_ee20230);
    dp->~ee20230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20230(Test_ee20230, "ee20230", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20230C1Ev();
extern void _ZN7ee20230D1Ev();
Name_Map name_map_ee20230[] = {
  NSPAIR(_ZN7ee20230C1Ev),
  NSPAIR(_ZN7ee20230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee20230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20230[];
extern void _ZN7ee202303fooEv();
static  VTBL_ENTRY vtc_ee20230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20230[0]),
  (VTBL_ENTRY)&_ZN7ee202303fooEv,
};
extern VTBL_ENTRY _ZTV7ee20230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee20230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee20230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee20230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee20230[] = {
  {&(_ZTV7ee20230[3]),  3,4},
  {&(_tg__ZTV6dd0230__7ee20230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee20230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee20230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee20230[];
extern  VTBL_ENTRY _ZTV7ee20230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20230[];
Class_Descriptor cd_ee20230 = {  "ee20230", // class name
  bases_ee20230, 4,
  &(vtc_ee20230[0]), // expected_vtbl_contents
  &(vtt_ee20230[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20230),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20230),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30230  : virtual dd0230 {
  int e;
  virtual void  foo(); // _ZN7ee302303fooEv
  ~ee30230(); // tgen
  ee30230(); // tgen
};
//SIG(1 ee30230) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee30230 ::foo(){vfunc_called(this, "_ZN7ee302303fooEv");}
ee30230 ::~ee30230(){ note_dtor("ee30230", this);} // tgen
ee30230 ::ee30230(){ note_ctor("ee30230", this);} // tgen

static void Test_ee30230()
{
  extern Class_Descriptor cd_ee30230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30230, buf);
    ee30230 *dp, &lv = *(dp=new (buf) ee30230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(36,24), "ee30230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), ABISELECT(16,8), "ee30230");
    check_base_class_offset(lv, (cc230*)(dd0230*), ABISELECT(16,8), "ee30230");
    check_base_class_offset(lv, (dd0230*), ABISELECT(16,8), "ee30230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30230.e");
    test_class_info(&lv, &cd_ee30230);
    dp->~ee30230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30230(Test_ee30230, "ee30230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30230C1Ev();
extern void _ZN7ee30230D1Ev();
Name_Map name_map_ee30230[] = {
  NSPAIR(_ZN7ee30230C1Ev),
  NSPAIR(_ZN7ee30230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee30230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30230[];
extern void _ZN7ee302303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee302303fooEv,_ZTv0_n16_N7ee302303fooEv)();
extern void ABISELECT(_ZThn16_N7ee302303fooEv,_ZThn8_N7ee302303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30230[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30230[0]),
  (VTBL_ENTRY)&_ZN7ee302303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30230[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee302303fooEv,_ZTv0_n16_N7ee302303fooEv),
};
extern VTBL_ENTRY _ZTV7ee30230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee30230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee30230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee30230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee30230[] = {
  {&(_ZTV7ee30230[4]),  4,10},
  {&(_ZTV7ee30230[9]),  9,10},
  {&(_tg__ZTV6dd0230__7ee30230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee30230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee30230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30230[];
extern  VTBL_ENTRY _ZTV7ee30230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30230[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee302303fooEv,_ZTv0_n16_N7ee302303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302303fooEv,_ZThn8_N7ee302303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30230 = {  "ee30230", // class name
  bases_ee30230, 4,
  &(vtc_ee30230[0]), // expected_vtbl_contents
  &(vtt_ee30230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30230),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30230),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40230  : dd0230 {
  int e;
  virtual void  bar(); // _ZN7ee402303barEv
  ~ee40230(); // tgen
  ee40230(); // tgen
};
//SIG(1 ee40230) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee40230 ::bar(){vfunc_called(this, "_ZN7ee402303barEv");}
ee40230 ::~ee40230(){ note_dtor("ee40230", this);} // tgen
ee40230 ::ee40230(){ note_ctor("ee40230", this);} // tgen

static void Test_ee40230()
{
  extern Class_Descriptor cd_ee40230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40230, buf);
    ee40230 *dp, &lv = *(dp=new (buf) ee40230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(24,20), "ee40230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), 0, "ee40230");
    check_base_class_offset(lv, (cc230*)(dd0230*), 0, "ee40230");
    check_base_class_offset(lv, (dd0230*), 0, "ee40230");
    check_field_offset(lv, e, ABISELECT(20,16), "ee40230.e");
    test_class_info(&lv, &cd_ee40230);
    dp->~ee40230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40230(Test_ee40230, "ee40230", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40230C1Ev();
extern void _ZN7ee40230D1Ev();
Name_Map name_map_ee40230[] = {
  NSPAIR(_ZN7ee40230C1Ev),
  NSPAIR(_ZN7ee40230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee40230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40230[];
extern void _ZN5cc2303fooEv();
extern void _ZN7ee402303barEv();
static  VTBL_ENTRY vtc_ee40230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
  (VTBL_ENTRY)&_ZN7ee402303barEv,
};
extern VTBL_ENTRY _ZTV7ee40230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee40230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee40230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee40230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee40230[] = {
  {&(_ZTV7ee40230[3]),  3,5},
  {&(_tg__ZTV6dd0230__7ee40230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee40230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee40230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee40230[];
extern  VTBL_ENTRY _ZTV7ee40230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40230[];
Class_Descriptor cd_ee40230 = {  "ee40230", // class name
  bases_ee40230, 4,
  &(vtc_ee40230[0]), // expected_vtbl_contents
  &(vtt_ee40230[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40230),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40230),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50230  : virtual dd0230 {
  int e;
  virtual void  bar(); // _ZN7ee502303barEv
  ~ee50230(); // tgen
  ee50230(); // tgen
};
//SIG(1 ee50230) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee50230 ::bar(){vfunc_called(this, "_ZN7ee502303barEv");}
ee50230 ::~ee50230(){ note_dtor("ee50230", this);} // tgen
ee50230 ::ee50230(){ note_ctor("ee50230", this);} // tgen

static void Test_ee50230()
{
  extern Class_Descriptor cd_ee50230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50230, buf);
    ee50230 *dp, &lv = *(dp=new (buf) ee50230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(36,24), "ee50230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), ABISELECT(16,8), "ee50230");
    check_base_class_offset(lv, (cc230*)(dd0230*), ABISELECT(16,8), "ee50230");
    check_base_class_offset(lv, (dd0230*), ABISELECT(16,8), "ee50230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50230.e");
    test_class_info(&lv, &cd_ee50230);
    dp->~ee50230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50230(Test_ee50230, "ee50230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50230C1Ev();
extern void _ZN7ee50230D1Ev();
Name_Map name_map_ee50230[] = {
  NSPAIR(_ZN7ee50230C1Ev),
  NSPAIR(_ZN7ee50230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee50230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50230[];
extern void _ZN7ee502303barEv();
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_ee50230[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50230[0]),
  (VTBL_ENTRY)&_ZN7ee502303barEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV7ee50230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee50230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee50230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee50230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee50230[] = {
  {&(_ZTV7ee50230[4]),  4,10},
  {&(_ZTV7ee50230[9]),  9,10},
  {&(_tg__ZTV6dd0230__7ee50230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee50230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee50230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50230[];
extern  VTBL_ENTRY _ZTV7ee50230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50230[];
Class_Descriptor cd_ee50230 = {  "ee50230", // class name
  bases_ee50230, 4,
  &(vtc_ee50230[0]), // expected_vtbl_contents
  &(vtt_ee50230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50230),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50230),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60230  : dd0230 {
  int e;
  virtual void  foo(); // _ZN7ee602303fooEv
  virtual void  bar(); // _ZN7ee602303barEv
  ~ee60230(); // tgen
  ee60230(); // tgen
};
//SIG(1 ee60230) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee60230 ::foo(){vfunc_called(this, "_ZN7ee602303fooEv");}
void  ee60230 ::bar(){vfunc_called(this, "_ZN7ee602303barEv");}
ee60230 ::~ee60230(){ note_dtor("ee60230", this);} // tgen
ee60230 ::ee60230(){ note_ctor("ee60230", this);} // tgen

static void Test_ee60230()
{
  extern Class_Descriptor cd_ee60230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60230, buf);
    ee60230 *dp, &lv = *(dp=new (buf) ee60230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(24,20), "ee60230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), 0, "ee60230");
    check_base_class_offset(lv, (cc230*)(dd0230*), 0, "ee60230");
    check_base_class_offset(lv, (dd0230*), 0, "ee60230");
    check_field_offset(lv, e, ABISELECT(20,16), "ee60230.e");
    test_class_info(&lv, &cd_ee60230);
    dp->~ee60230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60230(Test_ee60230, "ee60230", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60230C1Ev();
extern void _ZN7ee60230D1Ev();
Name_Map name_map_ee60230[] = {
  NSPAIR(_ZN7ee60230C1Ev),
  NSPAIR(_ZN7ee60230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee60230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60230[];
extern void _ZN7ee602303fooEv();
extern void _ZN7ee602303barEv();
static  VTBL_ENTRY vtc_ee60230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60230[0]),
  (VTBL_ENTRY)&_ZN7ee602303fooEv,
  (VTBL_ENTRY)&_ZN7ee602303barEv,
};
extern VTBL_ENTRY _ZTV7ee60230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee60230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee60230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee60230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee60230[] = {
  {&(_ZTV7ee60230[3]),  3,5},
  {&(_tg__ZTV6dd0230__7ee60230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee60230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee60230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee60230[];
extern  VTBL_ENTRY _ZTV7ee60230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60230[];
Class_Descriptor cd_ee60230 = {  "ee60230", // class name
  bases_ee60230, 4,
  &(vtc_ee60230[0]), // expected_vtbl_contents
  &(vtt_ee60230[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60230),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60230),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70230  : virtual dd0230 {
  int e;
  virtual void  foo(); // _ZN7ee702303fooEv
  virtual void  bar(); // _ZN7ee702303barEv
  ~ee70230(); // tgen
  ee70230(); // tgen
};
//SIG(1 ee70230) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee70230 ::foo(){vfunc_called(this, "_ZN7ee702303fooEv");}
void  ee70230 ::bar(){vfunc_called(this, "_ZN7ee702303barEv");}
ee70230 ::~ee70230(){ note_dtor("ee70230", this);} // tgen
ee70230 ::ee70230(){ note_ctor("ee70230", this);} // tgen

static void Test_ee70230()
{
  extern Class_Descriptor cd_ee70230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70230, buf);
    ee70230 *dp, &lv = *(dp=new (buf) ee70230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd0230*), ABISELECT(36,24), "ee70230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd0230*), ABISELECT(16,8), "ee70230");
    check_base_class_offset(lv, (cc230*)(dd0230*), ABISELECT(16,8), "ee70230");
    check_base_class_offset(lv, (dd0230*), ABISELECT(16,8), "ee70230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70230.e");
    test_class_info(&lv, &cd_ee70230);
    dp->~ee70230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70230(Test_ee70230, "ee70230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70230C1Ev();
extern void _ZN7ee70230D1Ev();
Name_Map name_map_ee70230[] = {
  NSPAIR(_ZN7ee70230C1Ev),
  NSPAIR(_ZN7ee70230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd0230;
extern VTBL_ENTRY _ZTI6dd0230[];
extern  VTBL_ENTRY _ZTV6dd0230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0230[];
static Base_Class bases_ee70230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0230,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70230[];
extern void _ZN7ee702303fooEv();
extern void _ZN7ee702303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee702303fooEv,_ZTv0_n16_N7ee702303fooEv)();
extern void ABISELECT(_ZThn16_N7ee702303fooEv,_ZThn8_N7ee702303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70230[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70230[0]),
  (VTBL_ENTRY)&_ZN7ee702303fooEv,
  (VTBL_ENTRY)&_ZN7ee702303barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70230[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee702303fooEv,_ZTv0_n16_N7ee702303fooEv),
};
extern VTBL_ENTRY _ZTV7ee70230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0230__7ee70230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd0230__7ee70230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd0230__7ee70230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee70230[] = {
  {&(_ZTV7ee70230[4]),  4,11},
  {&(_ZTV7ee70230[10]),  10,11},
  {&(_tg__ZTV6dd0230__7ee70230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd0230__7ee70230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd0230__7ee70230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70230[];
extern  VTBL_ENTRY _ZTV7ee70230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70230[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee702303fooEv,_ZTv0_n16_N7ee702303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702303fooEv,_ZThn8_N7ee702303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70230 = {  "ee70230", // class name
  bases_ee70230, 4,
  &(vtc_ee70230[0]), // expected_vtbl_contents
  &(vtt_ee70230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70230),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70230),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1230  : virtual cc230 {
  int d;
  ~dd1230(); // tgen
  dd1230(); // tgen
};
//SIG(-1 dd1230) C1{ VBC2{ BC3{ VBC4{ Fi} v1 Fi} v1 Fi} Fi}


dd1230 ::~dd1230(){ note_dtor("dd1230", this);} // tgen
dd1230 ::dd1230(){ note_ctor("dd1230", this);} // tgen

static void Test_dd1230()
{
  extern Class_Descriptor cd_dd1230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1230, buf);
    dd1230 *dp, &lv = *(dp=new (buf) dd1230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(32,20), "dd1230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(16,8), "dd1230");
    check_base_class_offset(lv, (cc230*), ABISELECT(16,8), "dd1230");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1230.d");
    test_class_info(&lv, &cd_dd1230);
    dp->~dd1230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1230(Test_dd1230, "dd1230", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1230C1Ev();
extern void _ZN6dd1230D1Ev();
Name_Map name_map_dd1230[] = {
  NSPAIR(_ZN6dd1230C1Ev),
  NSPAIR(_ZN6dd1230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
static Base_Class bases_dd1230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_dd1230[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV6dd1230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__6dd1230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd1230[] = {
  {&(_ZTV6dd1230[4]),  4,9},
  {&(_ZTV6dd1230[8]),  8,9},
  {&(_tg__ZTV5cc230__6dd1230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__6dd1230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
Class_Descriptor cd_dd1230 = {  "dd1230", // class name
  bases_dd1230, 3,
  &(vtc_dd1230[0]), // expected_vtbl_contents
  &(vtt_dd1230[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1230),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1230),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01230  : dd1230 {
  int e;
  ~ee01230(); // tgen
  ee01230(); // tgen
};
//SIG(1 ee01230) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee01230 ::~ee01230(){ note_dtor("ee01230", this);} // tgen
ee01230 ::ee01230(){ note_ctor("ee01230", this);} // tgen

static void Test_ee01230()
{
  extern Class_Descriptor cd_ee01230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01230, buf);
    ee01230 *dp, &lv = *(dp=new (buf) ee01230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(32,24), "ee01230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(16,12), "ee01230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(16,12), "ee01230");
    check_base_class_offset(lv, (dd1230*), 0, "ee01230");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01230.e");
    test_class_info(&lv, &cd_ee01230);
    dp->~ee01230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01230(Test_ee01230, "ee01230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01230C1Ev();
extern void _ZN7ee01230D1Ev();
Name_Map name_map_ee01230[] = {
  NSPAIR(_ZN7ee01230C1Ev),
  NSPAIR(_ZN7ee01230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee01230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_ee01230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01230[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV7ee01230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee01230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee01230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee01230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee01230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee01230[] = {
  {&(_ZTV7ee01230[4]),  4,9},
  {&(_tg__ZTV6dd1230__7ee01230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee01230[4]),  4,5},
  {&(_ZTV7ee01230[8]),  8,9},
  {&(_tg__ZTV5cc230__7ee01230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee01230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01230[];
extern  VTBL_ENTRY _ZTV7ee01230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01230[];
Class_Descriptor cd_ee01230 = {  "ee01230", // class name
  bases_ee01230, 4,
  &(vtc_ee01230[0]), // expected_vtbl_contents
  &(vtt_ee01230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01230),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01230),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11230  : virtual dd1230 {
  int e;
  ~ee11230(); // tgen
  ee11230(); // tgen
};
//SIG(1 ee11230) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee11230 ::~ee11230(){ note_dtor("ee11230", this);} // tgen
ee11230 ::ee11230(){ note_ctor("ee11230", this);} // tgen

static void Test_ee11230()
{
  extern Class_Descriptor cd_ee11230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11230, buf);
    ee11230 *dp, &lv = *(dp=new (buf) ee11230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(48,28), "ee11230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(32,16), "ee11230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(32,16), "ee11230");
    check_base_class_offset(lv, (dd1230*), ABISELECT(16,8), "ee11230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11230.e");
    test_class_info(&lv, &cd_ee11230);
    dp->~ee11230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11230(Test_ee11230, "ee11230", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11230C1Ev();
extern void _ZN7ee11230D1Ev();
Name_Map name_map_ee11230[] = {
  NSPAIR(_ZN7ee11230C1Ev),
  NSPAIR(_ZN7ee11230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee11230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_ee11230[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11230[0]),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11230[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV7ee11230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee11230[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee11230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee11230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee11230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee11230[] = {
  {&(_ZTV7ee11230[5]),  5,14},
  {&(_ZTV7ee11230[9]),  9,14},
  {&(_ZTV7ee11230[13]),  13,14},
  {&(_tg__ZTV6dd1230__7ee11230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee11230[4]),  4,5},
  {&(_tg__ZTV5cc230__7ee11230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee11230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11230[];
extern  VTBL_ENTRY _ZTV7ee11230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11230[];
Class_Descriptor cd_ee11230 = {  "ee11230", // class name
  bases_ee11230, 4,
  &(vtc_ee11230[0]), // expected_vtbl_contents
  &(vtt_ee11230[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11230),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11230),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21230  : dd1230 {
  int e;
  virtual void  foo(); // _ZN7ee212303fooEv
  ~ee21230(); // tgen
  ee21230(); // tgen
};
//SIG(1 ee21230) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee21230 ::foo(){vfunc_called(this, "_ZN7ee212303fooEv");}
ee21230 ::~ee21230(){ note_dtor("ee21230", this);} // tgen
ee21230 ::ee21230(){ note_ctor("ee21230", this);} // tgen

static void Test_ee21230()
{
  extern Class_Descriptor cd_ee21230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21230, buf);
    ee21230 *dp, &lv = *(dp=new (buf) ee21230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(32,24), "ee21230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(16,12), "ee21230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(16,12), "ee21230");
    check_base_class_offset(lv, (dd1230*), 0, "ee21230");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21230.e");
    test_class_info(&lv, &cd_ee21230);
    dp->~ee21230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21230(Test_ee21230, "ee21230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21230C1Ev();
extern void _ZN7ee21230D1Ev();
Name_Map name_map_ee21230[] = {
  NSPAIR(_ZN7ee21230C1Ev),
  NSPAIR(_ZN7ee21230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee21230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21230[];
extern void _ZN7ee212303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee212303fooEv,_ZTv0_n16_N7ee212303fooEv)();
extern void ABISELECT(_ZThn16_N7ee212303fooEv,_ZThn12_N7ee212303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21230[0]),
  (VTBL_ENTRY)&_ZN7ee212303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21230[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee212303fooEv,_ZTv0_n16_N7ee212303fooEv),
};
extern VTBL_ENTRY _ZTV7ee21230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee21230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee21230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee21230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee21230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee21230[] = {
  {&(_ZTV7ee21230[4]),  4,10},
  {&(_tg__ZTV6dd1230__7ee21230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee21230[4]),  4,5},
  {&(_ZTV7ee21230[9]),  9,10},
  {&(_tg__ZTV5cc230__7ee21230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee21230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21230[];
extern  VTBL_ENTRY _ZTV7ee21230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21230[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee212303fooEv,_ZTv0_n16_N7ee212303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee212303fooEv,_ZThn12_N7ee212303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21230 = {  "ee21230", // class name
  bases_ee21230, 4,
  &(vtc_ee21230[0]), // expected_vtbl_contents
  &(vtt_ee21230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21230),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21230),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31230  : virtual dd1230 {
  int e;
  virtual void  foo(); // _ZN7ee312303fooEv
  ~ee31230(); // tgen
  ee31230(); // tgen
};
//SIG(1 ee31230) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee31230 ::foo(){vfunc_called(this, "_ZN7ee312303fooEv");}
ee31230 ::~ee31230(){ note_dtor("ee31230", this);} // tgen
ee31230 ::ee31230(){ note_ctor("ee31230", this);} // tgen

static void Test_ee31230()
{
  extern Class_Descriptor cd_ee31230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31230, buf);
    ee31230 *dp, &lv = *(dp=new (buf) ee31230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(48,28), "ee31230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(32,16), "ee31230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(32,16), "ee31230");
    check_base_class_offset(lv, (dd1230*), ABISELECT(16,8), "ee31230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31230.e");
    test_class_info(&lv, &cd_ee31230);
    dp->~ee31230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31230(Test_ee31230, "ee31230", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31230C1Ev();
extern void _ZN7ee31230D1Ev();
Name_Map name_map_ee31230[] = {
  NSPAIR(_ZN7ee31230C1Ev),
  NSPAIR(_ZN7ee31230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee31230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31230[];
extern void _ZN7ee312303fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee312303fooEv,_ZTv0_n16_N7ee312303fooEv)();
extern void ABISELECT(_ZThn32_N7ee312303fooEv,_ZThn16_N7ee312303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31230[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31230[0]),
  (VTBL_ENTRY)&_ZN7ee312303fooEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31230[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31230[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee312303fooEv,_ZTv0_n16_N7ee312303fooEv),
};
extern VTBL_ENTRY _ZTV7ee31230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee31230[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee31230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee31230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee31230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee31230[] = {
  {&(_ZTV7ee31230[5]),  5,15},
  {&(_ZTV7ee31230[10]),  10,15},
  {&(_ZTV7ee31230[14]),  14,15},
  {&(_tg__ZTV6dd1230__7ee31230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee31230[4]),  4,5},
  {&(_tg__ZTV5cc230__7ee31230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee31230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31230[];
extern  VTBL_ENTRY _ZTV7ee31230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31230[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee312303fooEv,_ZTv0_n16_N7ee312303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee312303fooEv,_ZThn16_N7ee312303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31230 = {  "ee31230", // class name
  bases_ee31230, 4,
  &(vtc_ee31230[0]), // expected_vtbl_contents
  &(vtt_ee31230[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31230),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31230),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41230  : dd1230 {
  int e;
  virtual void  bar(); // _ZN7ee412303barEv
  ~ee41230(); // tgen
  ee41230(); // tgen
};
//SIG(1 ee41230) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee41230 ::bar(){vfunc_called(this, "_ZN7ee412303barEv");}
ee41230 ::~ee41230(){ note_dtor("ee41230", this);} // tgen
ee41230 ::ee41230(){ note_ctor("ee41230", this);} // tgen

static void Test_ee41230()
{
  extern Class_Descriptor cd_ee41230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41230, buf);
    ee41230 *dp, &lv = *(dp=new (buf) ee41230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(32,24), "ee41230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(16,12), "ee41230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(16,12), "ee41230");
    check_base_class_offset(lv, (dd1230*), 0, "ee41230");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41230.e");
    test_class_info(&lv, &cd_ee41230);
    dp->~ee41230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41230(Test_ee41230, "ee41230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41230C1Ev();
extern void _ZN7ee41230D1Ev();
Name_Map name_map_ee41230[] = {
  NSPAIR(_ZN7ee41230C1Ev),
  NSPAIR(_ZN7ee41230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee41230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41230[];
extern void _ZN7ee412303barEv();
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_ee41230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41230[0]),
  (VTBL_ENTRY)&_ZN7ee412303barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV7ee41230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee41230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee41230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee41230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee41230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee41230[] = {
  {&(_ZTV7ee41230[4]),  4,10},
  {&(_tg__ZTV6dd1230__7ee41230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee41230[4]),  4,5},
  {&(_ZTV7ee41230[9]),  9,10},
  {&(_tg__ZTV5cc230__7ee41230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee41230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41230[];
extern  VTBL_ENTRY _ZTV7ee41230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41230[];
Class_Descriptor cd_ee41230 = {  "ee41230", // class name
  bases_ee41230, 4,
  &(vtc_ee41230[0]), // expected_vtbl_contents
  &(vtt_ee41230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41230),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41230),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51230  : virtual dd1230 {
  int e;
  virtual void  bar(); // _ZN7ee512303barEv
  ~ee51230(); // tgen
  ee51230(); // tgen
};
//SIG(1 ee51230) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee51230 ::bar(){vfunc_called(this, "_ZN7ee512303barEv");}
ee51230 ::~ee51230(){ note_dtor("ee51230", this);} // tgen
ee51230 ::ee51230(){ note_ctor("ee51230", this);} // tgen

static void Test_ee51230()
{
  extern Class_Descriptor cd_ee51230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51230, buf);
    ee51230 *dp, &lv = *(dp=new (buf) ee51230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(48,28), "ee51230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(32,16), "ee51230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(32,16), "ee51230");
    check_base_class_offset(lv, (dd1230*), ABISELECT(16,8), "ee51230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51230.e");
    test_class_info(&lv, &cd_ee51230);
    dp->~ee51230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51230(Test_ee51230, "ee51230", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51230C1Ev();
extern void _ZN7ee51230D1Ev();
Name_Map name_map_ee51230[] = {
  NSPAIR(_ZN7ee51230C1Ev),
  NSPAIR(_ZN7ee51230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee51230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51230[];
extern void _ZN7ee512303barEv();
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY vtc_ee51230[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51230[0]),
  (VTBL_ENTRY)&_ZN7ee512303barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51230[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern VTBL_ENTRY _ZTV7ee51230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee51230[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee51230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee51230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee51230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee51230[] = {
  {&(_ZTV7ee51230[5]),  5,15},
  {&(_ZTV7ee51230[10]),  10,15},
  {&(_ZTV7ee51230[14]),  14,15},
  {&(_tg__ZTV6dd1230__7ee51230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee51230[4]),  4,5},
  {&(_tg__ZTV5cc230__7ee51230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee51230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51230[];
extern  VTBL_ENTRY _ZTV7ee51230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51230[];
Class_Descriptor cd_ee51230 = {  "ee51230", // class name
  bases_ee51230, 4,
  &(vtc_ee51230[0]), // expected_vtbl_contents
  &(vtt_ee51230[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51230),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51230),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61230  : dd1230 {
  int e;
  virtual void  foo(); // _ZN7ee612303fooEv
  virtual void  bar(); // _ZN7ee612303barEv
  ~ee61230(); // tgen
  ee61230(); // tgen
};
//SIG(1 ee61230) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee61230 ::foo(){vfunc_called(this, "_ZN7ee612303fooEv");}
void  ee61230 ::bar(){vfunc_called(this, "_ZN7ee612303barEv");}
ee61230 ::~ee61230(){ note_dtor("ee61230", this);} // tgen
ee61230 ::ee61230(){ note_ctor("ee61230", this);} // tgen

static void Test_ee61230()
{
  extern Class_Descriptor cd_ee61230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61230, buf);
    ee61230 *dp, &lv = *(dp=new (buf) ee61230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(32,24), "ee61230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(16,12), "ee61230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(16,12), "ee61230");
    check_base_class_offset(lv, (dd1230*), 0, "ee61230");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61230.e");
    test_class_info(&lv, &cd_ee61230);
    dp->~ee61230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61230(Test_ee61230, "ee61230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61230C1Ev();
extern void _ZN7ee61230D1Ev();
Name_Map name_map_ee61230[] = {
  NSPAIR(_ZN7ee61230C1Ev),
  NSPAIR(_ZN7ee61230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee61230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61230[];
extern void _ZN7ee612303fooEv();
extern void _ZN7ee612303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee612303fooEv,_ZTv0_n16_N7ee612303fooEv)();
extern void ABISELECT(_ZThn16_N7ee612303fooEv,_ZThn12_N7ee612303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61230[0]),
  (VTBL_ENTRY)&_ZN7ee612303fooEv,
  (VTBL_ENTRY)&_ZN7ee612303barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61230[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee612303fooEv,_ZTv0_n16_N7ee612303fooEv),
};
extern VTBL_ENTRY _ZTV7ee61230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee61230[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee61230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee61230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee61230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee61230[] = {
  {&(_ZTV7ee61230[4]),  4,11},
  {&(_tg__ZTV6dd1230__7ee61230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee61230[4]),  4,5},
  {&(_ZTV7ee61230[10]),  10,11},
  {&(_tg__ZTV5cc230__7ee61230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee61230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61230[];
extern  VTBL_ENTRY _ZTV7ee61230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61230[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee612303fooEv,_ZTv0_n16_N7ee612303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612303fooEv,_ZThn12_N7ee612303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61230 = {  "ee61230", // class name
  bases_ee61230, 4,
  &(vtc_ee61230[0]), // expected_vtbl_contents
  &(vtt_ee61230[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61230),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61230),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71230  : virtual dd1230 {
  int e;
  virtual void  foo(); // _ZN7ee712303fooEv
  virtual void  bar(); // _ZN7ee712303barEv
  ~ee71230(); // tgen
  ee71230(); // tgen
};
//SIG(1 ee71230) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee71230 ::foo(){vfunc_called(this, "_ZN7ee712303fooEv");}
void  ee71230 ::bar(){vfunc_called(this, "_ZN7ee712303barEv");}
ee71230 ::~ee71230(){ note_dtor("ee71230", this);} // tgen
ee71230 ::ee71230(){ note_ctor("ee71230", this);} // tgen

static void Test_ee71230()
{
  extern Class_Descriptor cd_ee71230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71230, buf);
    ee71230 *dp, &lv = *(dp=new (buf) ee71230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(48,28), "ee71230");
    check_base_class_offset(lv, (bb30*)(cc230*), ABISELECT(32,16), "ee71230");
    check_base_class_offset(lv, (cc230*)(dd1230*), ABISELECT(32,16), "ee71230");
    check_base_class_offset(lv, (dd1230*), ABISELECT(16,8), "ee71230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71230.e");
    test_class_info(&lv, &cd_ee71230);
    dp->~ee71230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71230(Test_ee71230, "ee71230", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71230C1Ev();
extern void _ZN7ee71230D1Ev();
Name_Map name_map_ee71230[] = {
  NSPAIR(_ZN7ee71230C1Ev),
  NSPAIR(_ZN7ee71230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd1230;
extern VTBL_ENTRY _ZTI6dd1230[];
extern  VTBL_ENTRY _ZTV6dd1230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1230[];
static Base_Class bases_ee71230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1230,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71230[];
extern void _ZN7ee712303fooEv();
extern void _ZN7ee712303barEv();
extern void ABISELECT(_ZTv0_n32_N7ee712303fooEv,_ZTv0_n16_N7ee712303fooEv)();
extern void ABISELECT(_ZThn32_N7ee712303fooEv,_ZThn16_N7ee712303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71230[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71230[0]),
  (VTBL_ENTRY)&_ZN7ee712303fooEv,
  (VTBL_ENTRY)&_ZN7ee712303barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71230[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71230[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee712303fooEv,_ZTv0_n16_N7ee712303fooEv),
};
extern VTBL_ENTRY _ZTV7ee71230[];
static  VTBL_ENTRY _tg__ZTV6dd1230__7ee71230[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd1230__7ee71230[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__7ee71230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__7ee71230[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee71230[] = {
  {&(_ZTV7ee71230[5]),  5,16},
  {&(_ZTV7ee71230[11]),  11,16},
  {&(_ZTV7ee71230[15]),  15,16},
  {&(_tg__ZTV6dd1230__7ee71230[4]),  4,4},
  {&(_tg__ZTV5cc230__6dd1230__7ee71230[4]),  4,5},
  {&(_tg__ZTV5cc230__7ee71230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__7ee71230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71230[];
extern  VTBL_ENTRY _ZTV7ee71230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71230[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee712303fooEv,_ZTv0_n16_N7ee712303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712303fooEv,_ZThn16_N7ee712303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71230 = {  "ee71230", // class name
  bases_ee71230, 4,
  &(vtc_ee71230[0]), // expected_vtbl_contents
  &(vtt_ee71230[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71230),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71230),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71230),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2230  : cc230 {
  int d;
  virtual void  foo(); // _ZN6dd22303fooEv
  ~dd2230(); // tgen
  dd2230(); // tgen
};
//SIG(-1 dd2230) C1{ BC2{ BC3{ VBC4{ Fi} v1 Fi} v1 Fi} v1 Fi}


void  dd2230 ::foo(){vfunc_called(this, "_ZN6dd22303fooEv");}
dd2230 ::~dd2230(){ note_dtor("dd2230", this);} // tgen
dd2230 ::dd2230(){ note_ctor("dd2230", this);} // tgen

static void Test_dd2230()
{
  extern Class_Descriptor cd_dd2230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2230, buf);
    dd2230 *dp, &lv = *(dp=new (buf) dd2230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*), ABISELECT(20,16), "dd2230");
    check_base_class_offset(lv, (bb30*)(cc230*), 0, "dd2230");
    check_base_class_offset(lv, (cc230*), 0, "dd2230");
    check_field_offset(lv, d, ABISELECT(16,12), "dd2230.d");
    test_class_info(&lv, &cd_dd2230);
    dp->~dd2230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2230(Test_dd2230, "dd2230", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2230C1Ev();
extern void _ZN6dd2230D1Ev();
Name_Map name_map_dd2230[] = {
  NSPAIR(_ZN6dd2230C1Ev),
  NSPAIR(_ZN6dd2230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
static Base_Class bases_dd2230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2230[];
extern void _ZN6dd22303fooEv();
static  VTBL_ENTRY vtc_dd2230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2230[0]),
  (VTBL_ENTRY)&_ZN6dd22303fooEv,
};
extern VTBL_ENTRY _ZTV6dd2230[];
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc230__6dd2230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc230__6dd2230[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_dd2230[] = {
  {&(_ZTV6dd2230[3]),  3,4},
  {&(_tg__ZTV5cc230__6dd2230[3]),  3,4},
  {&(_tg__ZTV4bb305cc230__6dd2230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd2230[];
extern  VTBL_ENTRY _ZTV6dd2230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2230[];
Class_Descriptor cd_dd2230 = {  "dd2230", // class name
  bases_dd2230, 3,
  &(vtc_dd2230[0]), // expected_vtbl_contents
  &(vtt_dd2230[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2230),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2230),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02230  : dd2230 {
  int e;
  ~ee02230(); // tgen
  ee02230(); // tgen
};
//SIG(1 ee02230) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} v1 Fi} Fi}


ee02230 ::~ee02230(){ note_dtor("ee02230", this);} // tgen
ee02230 ::ee02230(){ note_ctor("ee02230", this);} // tgen

static void Test_ee02230()
{
  extern Class_Descriptor cd_ee02230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02230, buf);
    ee02230 *dp, &lv = *(dp=new (buf) ee02230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd2230*), ABISELECT(24,20), "ee02230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd2230*), 0, "ee02230");
    check_base_class_offset(lv, (cc230*)(dd2230*), 0, "ee02230");
    check_base_class_offset(lv, (dd2230*), 0, "ee02230");
    check_field_offset(lv, e, ABISELECT(20,16), "ee02230.e");
    test_class_info(&lv, &cd_ee02230);
    dp->~ee02230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02230(Test_ee02230, "ee02230", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02230C1Ev();
extern void _ZN7ee02230D1Ev();
Name_Map name_map_ee02230[] = {
  NSPAIR(_ZN7ee02230C1Ev),
  NSPAIR(_ZN7ee02230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230[];
extern  VTBL_ENTRY _ZTV5cc230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc230[];
extern Class_Descriptor cd_dd2230;
extern VTBL_ENTRY _ZTI6dd2230[];
extern  VTBL_ENTRY _ZTV6dd2230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2230[];
static Base_Class bases_ee02230[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02230[];
extern void _ZN6dd22303fooEv();
static  VTBL_ENTRY vtc_ee02230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02230[0]),
  (VTBL_ENTRY)&_ZN6dd22303fooEv,
};
extern VTBL_ENTRY _ZTV7ee02230[];
extern void _ZN6dd22303fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2230__7ee02230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2230[0]),
  (VTBL_ENTRY)&_ZN6dd22303fooEv,
};
extern void _ZN5cc2303fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2306dd2230__7ee02230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc230[0]),
  (VTBL_ENTRY)&_ZN5cc2303fooEv,
};
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY _tg__ZTV4bb305cc2306dd2230__7ee02230[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
static  VTT_ENTRY vtt_ee02230[] = {
  {&(_ZTV7ee02230[3]),  3,4},
  {&(_tg__ZTV6dd2230__7ee02230[3]),  3,4},
  {&(_tg__ZTV5cc2306dd2230__7ee02230[3]),  3,4},
  {&(_tg__ZTV4bb305cc2306dd2230__7ee02230[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee02230[];
extern  VTBL_ENTRY _ZTV7ee02230[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02230[];
Class_Descriptor cd_ee02230 = {  "ee02230", // class name
  bases_ee02230, 4,
  &(vtc_ee02230[0]), // expected_vtbl_contents
  &(vtt_ee02230[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02230),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02230),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02230),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12230  : virtual dd2230 {
  int e;
  ~ee12230(); // tgen
  ee12230(); // tgen
};
//SIG(1 ee12230) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} v1 Fi} v1 Fi} v1 Fi} Fi}


ee12230 ::~ee12230(){ note_dtor("ee12230", this);} // tgen
ee12230 ::ee12230(){ note_ctor("ee12230", this);} // tgen

static void Test_ee12230()
{
  extern Class_Descriptor cd_ee12230;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12230, buf);
    ee12230 *dp, &lv = *(dp=new (buf) ee12230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12230)");
    check_base_class_offset(lv, (aa0*)(bb30*)(cc230*)(dd2230*), ABISELECT(36,24), "ee12230");
    check_base_class_offset(lv, (bb30*)(cc230*)(dd2230*), ABISELECT(16,8), "ee12230");
    check_base_class_offset(lv, (cc230*)(dd2230*), ABISELECT(16,8), "ee12230");
    check_base_class_offset(lv, (dd2230*), ABISELECT(16,8), "ee12230");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12230.e");
    test_class_info(&lv, &cd_ee12230);
    dp->~ee12230();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12230(Test_ee12230, "ee12230", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12230C1Ev();
extern void _ZN7ee12230D1Ev();
Name_Map name_map_ee12230[] = {
  NSPAIR(_ZN7ee12230C1Ev),
  NSPAIR(_ZN7ee12230D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb30[];
extern Class_Descriptor cd_cc230;
extern VTBL_ENTRY _ZTI5cc230