// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb20  : aa0 {
  int b;
  virtual void  foo(); // _ZN4bb203fooEv
  ~bb20(); // tgen
  bb20(); // tgen
};
//SIG(-1 bb20) C1{ BC2{ Fi} v1 Fi}


void  bb20 ::foo(){vfunc_called(this, "_ZN4bb203fooEv");}
bb20 ::~bb20(){ note_dtor("bb20", this);} // tgen
bb20 ::bb20(){ note_ctor("bb20", this);} // tgen

static void Test_bb20()
{
  extern Class_Descriptor cd_bb20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_bb20, buf);
    bb20 *dp, &lv = *(dp=new (buf) bb20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(bb20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb20)");
    check_base_class_offset(lv, (aa0*), ABISELECT(8,4), "bb20");
    check_field_offset(lv, b, ABISELECT(12,8), "bb20.b");
    test_class_info(&lv, &cd_bb20);
    dp->~bb20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb20(Test_bb20, "bb20", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN4bb20C1Ev();
extern void _ZN4bb20D1Ev();
Name_Map name_map_bb20[] = {
  NSPAIR(_ZN4bb20C1Ev),
  NSPAIR(_ZN4bb20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4bb20[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_bb20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb20[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
Class_Descriptor cd_bb20 = {  "bb20", // class name
  bases_bb20, 1,
  &(vtc_bb20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI4bb20),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4bb20),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc020  : bb20 {
  int c;
  ~cc020(); // tgen
  cc020(); // tgen
};
//SIG(-1 cc020) C1{ BC2{ BC3{ Fi} v1 Fi} Fi}


cc020 ::~cc020(){ note_dtor("cc020", this);} // tgen
cc020 ::cc020(){ note_ctor("cc020", this);} // tgen

static void Test_cc020()
{
  extern Class_Descriptor cd_cc020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc020, buf);
    cc020 *dp, &lv = *(dp=new (buf) cc020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc020)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(8,4), "cc020");
    check_base_class_offset(lv, (bb20*), 0, "cc020");
    check_field_offset(lv, c, ABISELECT(16,12), "cc020.c");
    test_class_info(&lv, &cd_cc020);
    dp->~cc020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc020(Test_cc020, "cc020", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc020C1Ev();
extern void _ZN5cc020D1Ev();
Name_Map name_map_cc020[] = {
  NSPAIR(_ZN5cc020C1Ev),
  NSPAIR(_ZN5cc020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
static Base_Class bases_cc020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc020[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_cc020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5cc020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
Class_Descriptor cd_cc020 = {  "cc020", // class name
  bases_cc020, 2,
  &(vtc_cc020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc020),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0020  : cc020 {
  int d;
  ~dd0020(); // tgen
  dd0020(); // tgen
};
//SIG(-1 dd0020) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd0020 ::~dd0020(){ note_dtor("dd0020", this);} // tgen
dd0020 ::dd0020(){ note_ctor("dd0020", this);} // tgen

static void Test_dd0020()
{
  extern Class_Descriptor cd_dd0020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0020, buf);
    dd0020 *dp, &lv = *(dp=new (buf) dd0020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(8,4), "dd0020");
    check_base_class_offset(lv, (bb20*)(cc020*), 0, "dd0020");
    check_base_class_offset(lv, (cc020*), 0, "dd0020");
    check_field_offset(lv, d, ABISELECT(20,16), "dd0020.d");
    test_class_info(&lv, &cd_dd0020);
    dp->~dd0020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0020(Test_dd0020, "dd0020", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0020C1Ev();
extern void _ZN6dd0020D1Ev();
Name_Map name_map_dd0020[] = {
  NSPAIR(_ZN6dd0020C1Ev),
  NSPAIR(_ZN6dd0020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd0020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0020[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_dd0020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd0020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
Class_Descriptor cd_dd0020 = {  "dd0020", // class name
  bases_dd0020, 3,
  &(vtc_dd0020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0020),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00020  : dd0020 {
  int e;
  ~ee00020(); // tgen
  ee00020(); // tgen
};
//SIG(1 ee00020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00020 ::~ee00020(){ note_dtor("ee00020", this);} // tgen
ee00020 ::ee00020(){ note_ctor("ee00020", this);} // tgen

static void Test_ee00020()
{
  extern Class_Descriptor cd_ee00020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00020, buf);
    ee00020 *dp, &lv = *(dp=new (buf) ee00020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(8,4), "ee00020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), 0, "ee00020");
    check_base_class_offset(lv, (cc020*)(dd0020*), 0, "ee00020");
    check_base_class_offset(lv, (dd0020*), 0, "ee00020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee00020.e");
    test_class_info(&lv, &cd_ee00020);
    dp->~ee00020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00020(Test_ee00020, "ee00020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00020C1Ev();
extern void _ZN7ee00020D1Ev();
Name_Map name_map_ee00020[] = {
  NSPAIR(_ZN7ee00020C1Ev),
  NSPAIR(_ZN7ee00020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee00020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00020[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee00020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee00020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTI7ee00020[];
extern  VTBL_ENTRY _ZTV7ee00020[];
Class_Descriptor cd_ee00020 = {  "ee00020", // class name
  bases_ee00020, 4,
  &(vtc_ee00020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00020),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10020  : virtual dd0020 {
  int e;
  ~ee10020(); // tgen
  ee10020(); // tgen
};
//SIG(1 ee10020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10020 ::~ee10020(){ note_dtor("ee10020", this);} // tgen
ee10020 ::ee10020(){ note_ctor("ee10020", this);} // tgen

static void Test_ee10020()
{
  extern Class_Descriptor cd_ee10020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10020, buf);
    ee10020 *dp, &lv = *(dp=new (buf) ee10020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(24,12), "ee10020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), ABISELECT(16,8), "ee10020");
    check_base_class_offset(lv, (cc020*)(dd0020*), ABISELECT(16,8), "ee10020");
    check_base_class_offset(lv, (dd0020*), ABISELECT(16,8), "ee10020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10020.e");
    test_class_info(&lv, &cd_ee10020);
    dp->~ee10020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10020(Test_ee10020, "ee10020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10020C1Ev();
extern void _ZN7ee10020D1Ev();
Name_Map name_map_ee10020[] = {
  NSPAIR(_ZN7ee10020C1Ev),
  NSPAIR(_ZN7ee10020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee10020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10020[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee10020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10020[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee10020[];
static  VTT_ENTRY vtt_ee10020[] = {
  {&(_ZTV7ee10020[3]),  3,7},
  {&(_ZTV7ee10020[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee10020[];
extern  VTBL_ENTRY _ZTV7ee10020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10020[];
Class_Descriptor cd_ee10020 = {  "ee10020", // class name
  bases_ee10020, 4,
  &(vtc_ee10020[0]), // expected_vtbl_contents
  &(vtt_ee10020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10020),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20020  : dd0020 {
  int e;
  virtual void  foo(); // _ZN7ee200203fooEv
  ~ee20020(); // tgen
  ee20020(); // tgen
};
//SIG(1 ee20020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee20020 ::foo(){vfunc_called(this, "_ZN7ee200203fooEv");}
ee20020 ::~ee20020(){ note_dtor("ee20020", this);} // tgen
ee20020 ::ee20020(){ note_ctor("ee20020", this);} // tgen

static void Test_ee20020()
{
  extern Class_Descriptor cd_ee20020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20020, buf);
    ee20020 *dp, &lv = *(dp=new (buf) ee20020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(8,4), "ee20020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), 0, "ee20020");
    check_base_class_offset(lv, (cc020*)(dd0020*), 0, "ee20020");
    check_base_class_offset(lv, (dd0020*), 0, "ee20020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20020.e");
    test_class_info(&lv, &cd_ee20020);
    dp->~ee20020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20020(Test_ee20020, "ee20020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20020C1Ev();
extern void _ZN7ee20020D1Ev();
Name_Map name_map_ee20020[] = {
  NSPAIR(_ZN7ee20020C1Ev),
  NSPAIR(_ZN7ee20020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee20020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20020[];
extern void _ZN7ee200203fooEv();
static  VTBL_ENTRY vtc_ee20020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20020[0]),
  (VTBL_ENTRY)&_ZN7ee200203fooEv,
};
extern VTBL_ENTRY _ZTI7ee20020[];
extern  VTBL_ENTRY _ZTV7ee20020[];
Class_Descriptor cd_ee20020 = {  "ee20020", // class name
  bases_ee20020, 4,
  &(vtc_ee20020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20020),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30020  : virtual dd0020 {
  int e;
  virtual void  foo(); // _ZN7ee300203fooEv
  ~ee30020(); // tgen
  ee30020(); // tgen
};
//SIG(1 ee30020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee30020 ::foo(){vfunc_called(this, "_ZN7ee300203fooEv");}
ee30020 ::~ee30020(){ note_dtor("ee30020", this);} // tgen
ee30020 ::ee30020(){ note_ctor("ee30020", this);} // tgen

static void Test_ee30020()
{
  extern Class_Descriptor cd_ee30020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30020, buf);
    ee30020 *dp, &lv = *(dp=new (buf) ee30020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(24,12), "ee30020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), ABISELECT(16,8), "ee30020");
    check_base_class_offset(lv, (cc020*)(dd0020*), ABISELECT(16,8), "ee30020");
    check_base_class_offset(lv, (dd0020*), ABISELECT(16,8), "ee30020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30020.e");
    test_class_info(&lv, &cd_ee30020);
    dp->~ee30020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30020(Test_ee30020, "ee30020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30020C1Ev();
extern void _ZN7ee30020D1Ev();
Name_Map name_map_ee30020[] = {
  NSPAIR(_ZN7ee30020C1Ev),
  NSPAIR(_ZN7ee30020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee30020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30020[];
extern void _ZN7ee300203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee300203fooEv,_ZTv0_n12_N7ee300203fooEv)();
extern void ABISELECT(_ZThn16_N7ee300203fooEv,_ZThn8_N7ee300203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30020[0]),
  (VTBL_ENTRY)&_ZN7ee300203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee300203fooEv,_ZTv0_n12_N7ee300203fooEv),
};
extern VTBL_ENTRY _ZTV7ee30020[];
static  VTT_ENTRY vtt_ee30020[] = {
  {&(_ZTV7ee30020[3]),  3,8},
  {&(_ZTV7ee30020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee30020[];
extern  VTBL_ENTRY _ZTV7ee30020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30020[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee300203fooEv,_ZTv0_n12_N7ee300203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee300203fooEv,_ZThn8_N7ee300203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30020 = {  "ee30020", // class name
  bases_ee30020, 4,
  &(vtc_ee30020[0]), // expected_vtbl_contents
  &(vtt_ee30020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40020  : dd0020 {
  int e;
  virtual void  bar(); // _ZN7ee400203barEv
  ~ee40020(); // tgen
  ee40020(); // tgen
};
//SIG(1 ee40020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee40020 ::bar(){vfunc_called(this, "_ZN7ee400203barEv");}
ee40020 ::~ee40020(){ note_dtor("ee40020", this);} // tgen
ee40020 ::ee40020(){ note_ctor("ee40020", this);} // tgen

static void Test_ee40020()
{
  extern Class_Descriptor cd_ee40020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40020, buf);
    ee40020 *dp, &lv = *(dp=new (buf) ee40020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(8,4), "ee40020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), 0, "ee40020");
    check_base_class_offset(lv, (cc020*)(dd0020*), 0, "ee40020");
    check_base_class_offset(lv, (dd0020*), 0, "ee40020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40020.e");
    test_class_info(&lv, &cd_ee40020);
    dp->~ee40020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40020(Test_ee40020, "ee40020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40020C1Ev();
extern void _ZN7ee40020D1Ev();
Name_Map name_map_ee40020[] = {
  NSPAIR(_ZN7ee40020C1Ev),
  NSPAIR(_ZN7ee40020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee40020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40020[];
extern void _ZN4bb203fooEv();
extern void _ZN7ee400203barEv();
static  VTBL_ENTRY vtc_ee40020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
  (VTBL_ENTRY)&_ZN7ee400203barEv,
};
extern VTBL_ENTRY _ZTI7ee40020[];
extern  VTBL_ENTRY _ZTV7ee40020[];
Class_Descriptor cd_ee40020 = {  "ee40020", // class name
  bases_ee40020, 4,
  &(vtc_ee40020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50020  : virtual dd0020 {
  int e;
  virtual void  bar(); // _ZN7ee500203barEv
  ~ee50020(); // tgen
  ee50020(); // tgen
};
//SIG(1 ee50020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee50020 ::bar(){vfunc_called(this, "_ZN7ee500203barEv");}
ee50020 ::~ee50020(){ note_dtor("ee50020", this);} // tgen
ee50020 ::ee50020(){ note_ctor("ee50020", this);} // tgen

static void Test_ee50020()
{
  extern Class_Descriptor cd_ee50020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50020, buf);
    ee50020 *dp, &lv = *(dp=new (buf) ee50020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(24,12), "ee50020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), ABISELECT(16,8), "ee50020");
    check_base_class_offset(lv, (cc020*)(dd0020*), ABISELECT(16,8), "ee50020");
    check_base_class_offset(lv, (dd0020*), ABISELECT(16,8), "ee50020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50020.e");
    test_class_info(&lv, &cd_ee50020);
    dp->~ee50020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50020(Test_ee50020, "ee50020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50020C1Ev();
extern void _ZN7ee50020D1Ev();
Name_Map name_map_ee50020[] = {
  NSPAIR(_ZN7ee50020C1Ev),
  NSPAIR(_ZN7ee50020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee50020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50020[];
extern void _ZN7ee500203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee50020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50020[0]),
  (VTBL_ENTRY)&_ZN7ee500203barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee50020[];
static  VTT_ENTRY vtt_ee50020[] = {
  {&(_ZTV7ee50020[3]),  3,8},
  {&(_ZTV7ee50020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee50020[];
extern  VTBL_ENTRY _ZTV7ee50020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50020[];
Class_Descriptor cd_ee50020 = {  "ee50020", // class name
  bases_ee50020, 4,
  &(vtc_ee50020[0]), // expected_vtbl_contents
  &(vtt_ee50020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60020  : dd0020 {
  int e;
  virtual void  foo(); // _ZN7ee600203fooEv
  virtual void  bar(); // _ZN7ee600203barEv
  ~ee60020(); // tgen
  ee60020(); // tgen
};
//SIG(1 ee60020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60020 ::foo(){vfunc_called(this, "_ZN7ee600203fooEv");}
void  ee60020 ::bar(){vfunc_called(this, "_ZN7ee600203barEv");}
ee60020 ::~ee60020(){ note_dtor("ee60020", this);} // tgen
ee60020 ::ee60020(){ note_ctor("ee60020", this);} // tgen

static void Test_ee60020()
{
  extern Class_Descriptor cd_ee60020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60020, buf);
    ee60020 *dp, &lv = *(dp=new (buf) ee60020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(8,4), "ee60020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), 0, "ee60020");
    check_base_class_offset(lv, (cc020*)(dd0020*), 0, "ee60020");
    check_base_class_offset(lv, (dd0020*), 0, "ee60020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60020.e");
    test_class_info(&lv, &cd_ee60020);
    dp->~ee60020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60020(Test_ee60020, "ee60020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60020C1Ev();
extern void _ZN7ee60020D1Ev();
Name_Map name_map_ee60020[] = {
  NSPAIR(_ZN7ee60020C1Ev),
  NSPAIR(_ZN7ee60020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee60020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60020[];
extern void _ZN7ee600203fooEv();
extern void _ZN7ee600203barEv();
static  VTBL_ENTRY vtc_ee60020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60020[0]),
  (VTBL_ENTRY)&_ZN7ee600203fooEv,
  (VTBL_ENTRY)&_ZN7ee600203barEv,
};
extern VTBL_ENTRY _ZTI7ee60020[];
extern  VTBL_ENTRY _ZTV7ee60020[];
Class_Descriptor cd_ee60020 = {  "ee60020", // class name
  bases_ee60020, 4,
  &(vtc_ee60020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70020  : virtual dd0020 {
  int e;
  virtual void  foo(); // _ZN7ee700203fooEv
  virtual void  bar(); // _ZN7ee700203barEv
  ~ee70020(); // tgen
  ee70020(); // tgen
};
//SIG(1 ee70020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70020 ::foo(){vfunc_called(this, "_ZN7ee700203fooEv");}
void  ee70020 ::bar(){vfunc_called(this, "_ZN7ee700203barEv");}
ee70020 ::~ee70020(){ note_dtor("ee70020", this);} // tgen
ee70020 ::ee70020(){ note_ctor("ee70020", this);} // tgen

static void Test_ee70020()
{
  extern Class_Descriptor cd_ee70020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70020, buf);
    ee70020 *dp, &lv = *(dp=new (buf) ee70020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd0020*), ABISELECT(24,12), "ee70020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd0020*), ABISELECT(16,8), "ee70020");
    check_base_class_offset(lv, (cc020*)(dd0020*), ABISELECT(16,8), "ee70020");
    check_base_class_offset(lv, (dd0020*), ABISELECT(16,8), "ee70020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70020.e");
    test_class_info(&lv, &cd_ee70020);
    dp->~ee70020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70020(Test_ee70020, "ee70020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70020C1Ev();
extern void _ZN7ee70020D1Ev();
Name_Map name_map_ee70020[] = {
  NSPAIR(_ZN7ee70020C1Ev),
  NSPAIR(_ZN7ee70020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd0020;
extern VTBL_ENTRY _ZTI6dd0020[];
extern  VTBL_ENTRY _ZTV6dd0020[];
static Base_Class bases_ee70020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70020[];
extern void _ZN7ee700203fooEv();
extern void _ZN7ee700203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee700203fooEv,_ZTv0_n12_N7ee700203fooEv)();
extern void ABISELECT(_ZThn16_N7ee700203fooEv,_ZThn8_N7ee700203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70020[0]),
  (VTBL_ENTRY)&_ZN7ee700203fooEv,
  (VTBL_ENTRY)&_ZN7ee700203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee700203fooEv,_ZTv0_n12_N7ee700203fooEv),
};
extern VTBL_ENTRY _ZTV7ee70020[];
static  VTT_ENTRY vtt_ee70020[] = {
  {&(_ZTV7ee70020[3]),  3,9},
  {&(_ZTV7ee70020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee70020[];
extern  VTBL_ENTRY _ZTV7ee70020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70020[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee700203fooEv,_ZTv0_n12_N7ee700203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee700203fooEv,_ZThn8_N7ee700203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70020 = {  "ee70020", // class name
  bases_ee70020, 4,
  &(vtc_ee70020[0]), // expected_vtbl_contents
  &(vtt_ee70020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1020  : virtual cc020 {
  int d;
  ~dd1020(); // tgen
  dd1020(); // tgen
};
//SIG(-1 dd1020) C1{ VBC2{ BC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd1020 ::~dd1020(){ note_dtor("dd1020", this);} // tgen
dd1020 ::dd1020(){ note_ctor("dd1020", this);} // tgen

static void Test_dd1020()
{
  extern Class_Descriptor cd_dd1020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1020, buf);
    dd1020 *dp, &lv = *(dp=new (buf) dd1020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,12), "dd1020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,8), "dd1020");
    check_base_class_offset(lv, (cc020*), ABISELECT(16,8), "dd1020");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1020.d");
    test_class_info(&lv, &cd_dd1020);
    dp->~dd1020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1020(Test_dd1020, "dd1020", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1020C1Ev();
extern void _ZN6dd1020D1Ev();
Name_Map name_map_dd1020[] = {
  NSPAIR(_ZN6dd1020C1Ev),
  NSPAIR(_ZN6dd1020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd1020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1020[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_dd1020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV6dd1020[];
static  VTT_ENTRY vtt_dd1020[] = {
  {&(_ZTV6dd1020[3]),  3,7},
  {&(_ZTV6dd1020[6]),  6,7},
};
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
Class_Descriptor cd_dd1020 = {  "dd1020", // class name
  bases_dd1020, 3,
  &(vtc_dd1020[0]), // expected_vtbl_contents
  &(vtt_dd1020[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1020),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1020),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01020  : dd1020 {
  int e;
  ~ee01020(); // tgen
  ee01020(); // tgen
};
//SIG(1 ee01020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01020 ::~ee01020(){ note_dtor("ee01020", this);} // tgen
ee01020 ::ee01020(){ note_ctor("ee01020", this);} // tgen

static void Test_ee01020()
{
  extern Class_Descriptor cd_ee01020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01020, buf);
    ee01020 *dp, &lv = *(dp=new (buf) ee01020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee01020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee01020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(16,12), "ee01020");
    check_base_class_offset(lv, (dd1020*), 0, "ee01020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01020.e");
    test_class_info(&lv, &cd_ee01020);
    dp->~ee01020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01020(Test_ee01020, "ee01020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01020C1Ev();
extern void _ZN7ee01020D1Ev();
Name_Map name_map_ee01020[] = {
  NSPAIR(_ZN7ee01020C1Ev),
  NSPAIR(_ZN7ee01020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee01020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01020[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee01020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01020[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee01020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee01020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee01020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee01020[] = {
  {&(_ZTV7ee01020[3]),  3,7},
  {&(_tg__ZTV6dd1020__7ee01020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee01020[3]),  3,4},
  {&(_ZTV7ee01020[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee01020[];
extern  VTBL_ENTRY _ZTV7ee01020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01020[];
Class_Descriptor cd_ee01020 = {  "ee01020", // class name
  bases_ee01020, 4,
  &(vtc_ee01020[0]), // expected_vtbl_contents
  &(vtt_ee01020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01020),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11020  : virtual dd1020 {
  int e;
  ~ee11020(); // tgen
  ee11020(); // tgen
};
//SIG(1 ee11020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11020 ::~ee11020(){ note_dtor("ee11020", this);} // tgen
ee11020 ::ee11020(){ note_ctor("ee11020", this);} // tgen

static void Test_ee11020()
{
  extern Class_Descriptor cd_ee11020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11020, buf);
    ee11020 *dp, &lv = *(dp=new (buf) ee11020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee11020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee11020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(32,16), "ee11020");
    check_base_class_offset(lv, (dd1020*), ABISELECT(16,8), "ee11020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11020.e");
    test_class_info(&lv, &cd_ee11020);
    dp->~ee11020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11020(Test_ee11020, "ee11020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11020C1Ev();
extern void _ZN7ee11020D1Ev();
Name_Map name_map_ee11020[] = {
  NSPAIR(_ZN7ee11020C1Ev),
  NSPAIR(_ZN7ee11020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee11020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11020[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee11020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11020[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11020[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee11020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee11020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee11020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee11020[] = {
  {&(_ZTV7ee11020[4]),  4,11},
  {&(_ZTV7ee11020[7]),  7,11},
  {&(_ZTV7ee11020[10]),  10,11},
  {&(_tg__ZTV6dd1020__7ee11020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee11020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11020[];
extern  VTBL_ENTRY _ZTV7ee11020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11020[];
Class_Descriptor cd_ee11020 = {  "ee11020", // class name
  bases_ee11020, 4,
  &(vtc_ee11020[0]), // expected_vtbl_contents
  &(vtt_ee11020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11020),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21020  : dd1020 {
  int e;
  virtual void  foo(); // _ZN7ee210203fooEv
  ~ee21020(); // tgen
  ee21020(); // tgen
};
//SIG(1 ee21020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee21020 ::foo(){vfunc_called(this, "_ZN7ee210203fooEv");}
ee21020 ::~ee21020(){ note_dtor("ee21020", this);} // tgen
ee21020 ::ee21020(){ note_ctor("ee21020", this);} // tgen

static void Test_ee21020()
{
  extern Class_Descriptor cd_ee21020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21020, buf);
    ee21020 *dp, &lv = *(dp=new (buf) ee21020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee21020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee21020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(16,12), "ee21020");
    check_base_class_offset(lv, (dd1020*), 0, "ee21020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21020.e");
    test_class_info(&lv, &cd_ee21020);
    dp->~ee21020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21020(Test_ee21020, "ee21020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21020C1Ev();
extern void _ZN7ee21020D1Ev();
Name_Map name_map_ee21020[] = {
  NSPAIR(_ZN7ee21020C1Ev),
  NSPAIR(_ZN7ee21020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee21020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21020[];
extern void _ZN7ee210203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee210203fooEv,_ZTv0_n12_N7ee210203fooEv)();
extern void ABISELECT(_ZThn16_N7ee210203fooEv,_ZThn12_N7ee210203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21020[0]),
  (VTBL_ENTRY)&_ZN7ee210203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee210203fooEv,_ZTv0_n12_N7ee210203fooEv),
};
extern VTBL_ENTRY _ZTV7ee21020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee21020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee21020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee21020[] = {
  {&(_ZTV7ee21020[3]),  3,8},
  {&(_tg__ZTV6dd1020__7ee21020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee21020[3]),  3,4},
  {&(_ZTV7ee21020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee21020[];
extern  VTBL_ENTRY _ZTV7ee21020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21020[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee210203fooEv,_ZTv0_n12_N7ee210203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee210203fooEv,_ZThn12_N7ee210203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21020 = {  "ee21020", // class name
  bases_ee21020, 4,
  &(vtc_ee21020[0]), // expected_vtbl_contents
  &(vtt_ee21020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31020  : virtual dd1020 {
  int e;
  virtual void  foo(); // _ZN7ee310203fooEv
  ~ee31020(); // tgen
  ee31020(); // tgen
};
//SIG(1 ee31020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee31020 ::foo(){vfunc_called(this, "_ZN7ee310203fooEv");}
ee31020 ::~ee31020(){ note_dtor("ee31020", this);} // tgen
ee31020 ::ee31020(){ note_ctor("ee31020", this);} // tgen

static void Test_ee31020()
{
  extern Class_Descriptor cd_ee31020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31020, buf);
    ee31020 *dp, &lv = *(dp=new (buf) ee31020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee31020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee31020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(32,16), "ee31020");
    check_base_class_offset(lv, (dd1020*), ABISELECT(16,8), "ee31020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31020.e");
    test_class_info(&lv, &cd_ee31020);
    dp->~ee31020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31020(Test_ee31020, "ee31020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31020C1Ev();
extern void _ZN7ee31020D1Ev();
Name_Map name_map_ee31020[] = {
  NSPAIR(_ZN7ee31020C1Ev),
  NSPAIR(_ZN7ee31020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee31020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31020[];
extern void _ZN7ee310203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee310203fooEv,_ZTv0_n12_N7ee310203fooEv)();
extern void ABISELECT(_ZThn32_N7ee310203fooEv,_ZThn16_N7ee310203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31020[0]),
  (VTBL_ENTRY)&_ZN7ee310203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31020[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee310203fooEv,_ZTv0_n12_N7ee310203fooEv),
};
extern VTBL_ENTRY _ZTV7ee31020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee31020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee31020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee31020[] = {
  {&(_ZTV7ee31020[4]),  4,12},
  {&(_ZTV7ee31020[8]),  8,12},
  {&(_ZTV7ee31020[11]),  11,12},
  {&(_tg__ZTV6dd1020__7ee31020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee31020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31020[];
extern  VTBL_ENTRY _ZTV7ee31020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31020[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee310203fooEv,_ZTv0_n12_N7ee310203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee310203fooEv,_ZThn16_N7ee310203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31020 = {  "ee31020", // class name
  bases_ee31020, 4,
  &(vtc_ee31020[0]), // expected_vtbl_contents
  &(vtt_ee31020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31020),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41020  : dd1020 {
  int e;
  virtual void  bar(); // _ZN7ee410203barEv
  ~ee41020(); // tgen
  ee41020(); // tgen
};
//SIG(1 ee41020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee41020 ::bar(){vfunc_called(this, "_ZN7ee410203barEv");}
ee41020 ::~ee41020(){ note_dtor("ee41020", this);} // tgen
ee41020 ::ee41020(){ note_ctor("ee41020", this);} // tgen

static void Test_ee41020()
{
  extern Class_Descriptor cd_ee41020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41020, buf);
    ee41020 *dp, &lv = *(dp=new (buf) ee41020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee41020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee41020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(16,12), "ee41020");
    check_base_class_offset(lv, (dd1020*), 0, "ee41020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41020.e");
    test_class_info(&lv, &cd_ee41020);
    dp->~ee41020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41020(Test_ee41020, "ee41020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41020C1Ev();
extern void _ZN7ee41020D1Ev();
Name_Map name_map_ee41020[] = {
  NSPAIR(_ZN7ee41020C1Ev),
  NSPAIR(_ZN7ee41020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee41020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41020[];
extern void _ZN7ee410203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee41020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41020[0]),
  (VTBL_ENTRY)&_ZN7ee410203barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee41020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee41020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee41020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee41020[] = {
  {&(_ZTV7ee41020[3]),  3,8},
  {&(_tg__ZTV6dd1020__7ee41020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee41020[3]),  3,4},
  {&(_ZTV7ee41020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee41020[];
extern  VTBL_ENTRY _ZTV7ee41020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41020[];
Class_Descriptor cd_ee41020 = {  "ee41020", // class name
  bases_ee41020, 4,
  &(vtc_ee41020[0]), // expected_vtbl_contents
  &(vtt_ee41020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51020  : virtual dd1020 {
  int e;
  virtual void  bar(); // _ZN7ee510203barEv
  ~ee51020(); // tgen
  ee51020(); // tgen
};
//SIG(1 ee51020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee51020 ::bar(){vfunc_called(this, "_ZN7ee510203barEv");}
ee51020 ::~ee51020(){ note_dtor("ee51020", this);} // tgen
ee51020 ::ee51020(){ note_ctor("ee51020", this);} // tgen

static void Test_ee51020()
{
  extern Class_Descriptor cd_ee51020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51020, buf);
    ee51020 *dp, &lv = *(dp=new (buf) ee51020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee51020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee51020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(32,16), "ee51020");
    check_base_class_offset(lv, (dd1020*), ABISELECT(16,8), "ee51020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51020.e");
    test_class_info(&lv, &cd_ee51020);
    dp->~ee51020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51020(Test_ee51020, "ee51020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51020C1Ev();
extern void _ZN7ee51020D1Ev();
Name_Map name_map_ee51020[] = {
  NSPAIR(_ZN7ee51020C1Ev),
  NSPAIR(_ZN7ee51020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee51020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51020[];
extern void _ZN7ee510203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee51020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51020[0]),
  (VTBL_ENTRY)&_ZN7ee510203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51020[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee51020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee51020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee51020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee51020[] = {
  {&(_ZTV7ee51020[4]),  4,12},
  {&(_ZTV7ee51020[8]),  8,12},
  {&(_ZTV7ee51020[11]),  11,12},
  {&(_tg__ZTV6dd1020__7ee51020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee51020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51020[];
extern  VTBL_ENTRY _ZTV7ee51020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51020[];
Class_Descriptor cd_ee51020 = {  "ee51020", // class name
  bases_ee51020, 4,
  &(vtc_ee51020[0]), // expected_vtbl_contents
  &(vtt_ee51020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51020),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61020  : dd1020 {
  int e;
  virtual void  foo(); // _ZN7ee610203fooEv
  virtual void  bar(); // _ZN7ee610203barEv
  ~ee61020(); // tgen
  ee61020(); // tgen
};
//SIG(1 ee61020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61020 ::foo(){vfunc_called(this, "_ZN7ee610203fooEv");}
void  ee61020 ::bar(){vfunc_called(this, "_ZN7ee610203barEv");}
ee61020 ::~ee61020(){ note_dtor("ee61020", this);} // tgen
ee61020 ::ee61020(){ note_ctor("ee61020", this);} // tgen

static void Test_ee61020()
{
  extern Class_Descriptor cd_ee61020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61020, buf);
    ee61020 *dp, &lv = *(dp=new (buf) ee61020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee61020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee61020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(16,12), "ee61020");
    check_base_class_offset(lv, (dd1020*), 0, "ee61020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61020.e");
    test_class_info(&lv, &cd_ee61020);
    dp->~ee61020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61020(Test_ee61020, "ee61020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61020C1Ev();
extern void _ZN7ee61020D1Ev();
Name_Map name_map_ee61020[] = {
  NSPAIR(_ZN7ee61020C1Ev),
  NSPAIR(_ZN7ee61020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee61020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61020[];
extern void _ZN7ee610203fooEv();
extern void _ZN7ee610203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee610203fooEv,_ZTv0_n12_N7ee610203fooEv)();
extern void ABISELECT(_ZThn16_N7ee610203fooEv,_ZThn12_N7ee610203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61020[0]),
  (VTBL_ENTRY)&_ZN7ee610203fooEv,
  (VTBL_ENTRY)&_ZN7ee610203barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee610203fooEv,_ZTv0_n12_N7ee610203fooEv),
};
extern VTBL_ENTRY _ZTV7ee61020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee61020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee61020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee61020[] = {
  {&(_ZTV7ee61020[3]),  3,9},
  {&(_tg__ZTV6dd1020__7ee61020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee61020[3]),  3,4},
  {&(_ZTV7ee61020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee61020[];
extern  VTBL_ENTRY _ZTV7ee61020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61020[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee610203fooEv,_ZTv0_n12_N7ee610203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee610203fooEv,_ZThn12_N7ee610203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61020 = {  "ee61020", // class name
  bases_ee61020, 4,
  &(vtc_ee61020[0]), // expected_vtbl_contents
  &(vtt_ee61020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71020  : virtual dd1020 {
  int e;
  virtual void  foo(); // _ZN7ee710203fooEv
  virtual void  bar(); // _ZN7ee710203barEv
  ~ee71020(); // tgen
  ee71020(); // tgen
};
//SIG(1 ee71020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71020 ::foo(){vfunc_called(this, "_ZN7ee710203fooEv");}
void  ee71020 ::bar(){vfunc_called(this, "_ZN7ee710203barEv");}
ee71020 ::~ee71020(){ note_dtor("ee71020", this);} // tgen
ee71020 ::ee71020(){ note_ctor("ee71020", this);} // tgen

static void Test_ee71020()
{
  extern Class_Descriptor cd_ee71020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71020, buf);
    ee71020 *dp, &lv = *(dp=new (buf) ee71020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee71020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee71020");
    check_base_class_offset(lv, (cc020*)(dd1020*), ABISELECT(32,16), "ee71020");
    check_base_class_offset(lv, (dd1020*), ABISELECT(16,8), "ee71020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71020.e");
    test_class_info(&lv, &cd_ee71020);
    dp->~ee71020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71020(Test_ee71020, "ee71020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71020C1Ev();
extern void _ZN7ee71020D1Ev();
Name_Map name_map_ee71020[] = {
  NSPAIR(_ZN7ee71020C1Ev),
  NSPAIR(_ZN7ee71020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd1020;
extern VTBL_ENTRY _ZTI6dd1020[];
extern  VTBL_ENTRY _ZTV6dd1020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1020[];
static Base_Class bases_ee71020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1020,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71020[];
extern void _ZN7ee710203fooEv();
extern void _ZN7ee710203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee710203fooEv,_ZTv0_n12_N7ee710203fooEv)();
extern void ABISELECT(_ZThn32_N7ee710203fooEv,_ZThn16_N7ee710203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71020[0]),
  (VTBL_ENTRY)&_ZN7ee710203fooEv,
  (VTBL_ENTRY)&_ZN7ee710203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71020[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee710203fooEv,_ZTv0_n12_N7ee710203fooEv),
};
extern VTBL_ENTRY _ZTV7ee71020[];
static  VTBL_ENTRY _tg__ZTV6dd1020__7ee71020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd1020__7ee71020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee71020[] = {
  {&(_ZTV7ee71020[4]),  4,13},
  {&(_ZTV7ee71020[9]),  9,13},
  {&(_ZTV7ee71020[12]),  12,13},
  {&(_tg__ZTV6dd1020__7ee71020[3]),  3,3},
  {&(_tg__ZTV4bb205cc020__6dd1020__7ee71020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71020[];
extern  VTBL_ENTRY _ZTV7ee71020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71020[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee710203fooEv,_ZTv0_n12_N7ee710203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee710203fooEv,_ZThn16_N7ee710203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71020 = {  "ee71020", // class name
  bases_ee71020, 4,
  &(vtc_ee71020[0]), // expected_vtbl_contents
  &(vtt_ee71020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71020),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2020  : cc020 {
  int d;
  virtual void  foo(); // _ZN6dd20203fooEv
  ~dd2020(); // tgen
  dd2020(); // tgen
};
//SIG(-1 dd2020) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd2020 ::foo(){vfunc_called(this, "_ZN6dd20203fooEv");}
dd2020 ::~dd2020(){ note_dtor("dd2020", this);} // tgen
dd2020 ::dd2020(){ note_ctor("dd2020", this);} // tgen

static void Test_dd2020()
{
  extern Class_Descriptor cd_dd2020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2020, buf);
    dd2020 *dp, &lv = *(dp=new (buf) dd2020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(8,4), "dd2020");
    check_base_class_offset(lv, (bb20*)(cc020*), 0, "dd2020");
    check_base_class_offset(lv, (cc020*), 0, "dd2020");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2020.d");
    test_class_info(&lv, &cd_dd2020);
    dp->~dd2020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2020(Test_dd2020, "dd2020", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2020C1Ev();
extern void _ZN6dd2020D1Ev();
Name_Map name_map_dd2020[] = {
  NSPAIR(_ZN6dd2020C1Ev),
  NSPAIR(_ZN6dd2020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd2020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2020[];
extern void _ZN6dd20203fooEv();
static  VTBL_ENTRY vtc_dd2020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2020[0]),
  (VTBL_ENTRY)&_ZN6dd20203fooEv,
};
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
Class_Descriptor cd_dd2020 = {  "dd2020", // class name
  bases_dd2020, 3,
  &(vtc_dd2020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2020),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02020  : dd2020 {
  int e;
  ~ee02020(); // tgen
  ee02020(); // tgen
};
//SIG(1 ee02020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee02020 ::~ee02020(){ note_dtor("ee02020", this);} // tgen
ee02020 ::ee02020(){ note_ctor("ee02020", this);} // tgen

static void Test_ee02020()
{
  extern Class_Descriptor cd_ee02020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02020, buf);
    ee02020 *dp, &lv = *(dp=new (buf) ee02020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(8,4), "ee02020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), 0, "ee02020");
    check_base_class_offset(lv, (cc020*)(dd2020*), 0, "ee02020");
    check_base_class_offset(lv, (dd2020*), 0, "ee02020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02020.e");
    test_class_info(&lv, &cd_ee02020);
    dp->~ee02020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02020(Test_ee02020, "ee02020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02020C1Ev();
extern void _ZN7ee02020D1Ev();
Name_Map name_map_ee02020[] = {
  NSPAIR(_ZN7ee02020C1Ev),
  NSPAIR(_ZN7ee02020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee02020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02020[];
extern void _ZN6dd20203fooEv();
static  VTBL_ENTRY vtc_ee02020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02020[0]),
  (VTBL_ENTRY)&_ZN6dd20203fooEv,
};
extern VTBL_ENTRY _ZTI7ee02020[];
extern  VTBL_ENTRY _ZTV7ee02020[];
Class_Descriptor cd_ee02020 = {  "ee02020", // class name
  bases_ee02020, 4,
  &(vtc_ee02020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02020),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12020  : virtual dd2020 {
  int e;
  ~ee12020(); // tgen
  ee12020(); // tgen
};
//SIG(1 ee12020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee12020 ::~ee12020(){ note_dtor("ee12020", this);} // tgen
ee12020 ::ee12020(){ note_ctor("ee12020", this);} // tgen

static void Test_ee12020()
{
  extern Class_Descriptor cd_ee12020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12020, buf);
    ee12020 *dp, &lv = *(dp=new (buf) ee12020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(24,12), "ee12020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), ABISELECT(16,8), "ee12020");
    check_base_class_offset(lv, (cc020*)(dd2020*), ABISELECT(16,8), "ee12020");
    check_base_class_offset(lv, (dd2020*), ABISELECT(16,8), "ee12020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12020.e");
    test_class_info(&lv, &cd_ee12020);
    dp->~ee12020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12020(Test_ee12020, "ee12020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12020C1Ev();
extern void _ZN7ee12020D1Ev();
Name_Map name_map_ee12020[] = {
  NSPAIR(_ZN7ee12020C1Ev),
  NSPAIR(_ZN7ee12020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee12020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12020[];
extern void _ZN6dd20203fooEv();
static  VTBL_ENTRY vtc_ee12020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12020[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12020[0]),
  (VTBL_ENTRY)&_ZN6dd20203fooEv,
};
extern VTBL_ENTRY _ZTV7ee12020[];
static  VTT_ENTRY vtt_ee12020[] = {
  {&(_ZTV7ee12020[3]),  3,7},
  {&(_ZTV7ee12020[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee12020[];
extern  VTBL_ENTRY _ZTV7ee12020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12020[];
Class_Descriptor cd_ee12020 = {  "ee12020", // class name
  bases_ee12020, 4,
  &(vtc_ee12020[0]), // expected_vtbl_contents
  &(vtt_ee12020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12020),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22020  : dd2020 {
  int e;
  virtual void  foo(); // _ZN7ee220203fooEv
  ~ee22020(); // tgen
  ee22020(); // tgen
};
//SIG(1 ee22020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22020 ::foo(){vfunc_called(this, "_ZN7ee220203fooEv");}
ee22020 ::~ee22020(){ note_dtor("ee22020", this);} // tgen
ee22020 ::ee22020(){ note_ctor("ee22020", this);} // tgen

static void Test_ee22020()
{
  extern Class_Descriptor cd_ee22020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22020, buf);
    ee22020 *dp, &lv = *(dp=new (buf) ee22020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(8,4), "ee22020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), 0, "ee22020");
    check_base_class_offset(lv, (cc020*)(dd2020*), 0, "ee22020");
    check_base_class_offset(lv, (dd2020*), 0, "ee22020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22020.e");
    test_class_info(&lv, &cd_ee22020);
    dp->~ee22020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22020(Test_ee22020, "ee22020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22020C1Ev();
extern void _ZN7ee22020D1Ev();
Name_Map name_map_ee22020[] = {
  NSPAIR(_ZN7ee22020C1Ev),
  NSPAIR(_ZN7ee22020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee22020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22020[];
extern void _ZN7ee220203fooEv();
static  VTBL_ENTRY vtc_ee22020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22020[0]),
  (VTBL_ENTRY)&_ZN7ee220203fooEv,
};
extern VTBL_ENTRY _ZTI7ee22020[];
extern  VTBL_ENTRY _ZTV7ee22020[];
Class_Descriptor cd_ee22020 = {  "ee22020", // class name
  bases_ee22020, 4,
  &(vtc_ee22020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22020),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32020  : virtual dd2020 {
  int e;
  virtual void  foo(); // _ZN7ee320203fooEv
  ~ee32020(); // tgen
  ee32020(); // tgen
};
//SIG(1 ee32020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32020 ::foo(){vfunc_called(this, "_ZN7ee320203fooEv");}
ee32020 ::~ee32020(){ note_dtor("ee32020", this);} // tgen
ee32020 ::ee32020(){ note_ctor("ee32020", this);} // tgen

static void Test_ee32020()
{
  extern Class_Descriptor cd_ee32020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32020, buf);
    ee32020 *dp, &lv = *(dp=new (buf) ee32020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(24,12), "ee32020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), ABISELECT(16,8), "ee32020");
    check_base_class_offset(lv, (cc020*)(dd2020*), ABISELECT(16,8), "ee32020");
    check_base_class_offset(lv, (dd2020*), ABISELECT(16,8), "ee32020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32020.e");
    test_class_info(&lv, &cd_ee32020);
    dp->~ee32020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32020(Test_ee32020, "ee32020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32020C1Ev();
extern void _ZN7ee32020D1Ev();
Name_Map name_map_ee32020[] = {
  NSPAIR(_ZN7ee32020C1Ev),
  NSPAIR(_ZN7ee32020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee32020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32020[];
extern void _ZN7ee320203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee320203fooEv,_ZTv0_n12_N7ee320203fooEv)();
extern void ABISELECT(_ZThn16_N7ee320203fooEv,_ZThn8_N7ee320203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32020[0]),
  (VTBL_ENTRY)&_ZN7ee320203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee320203fooEv,_ZTv0_n12_N7ee320203fooEv),
};
extern VTBL_ENTRY _ZTV7ee32020[];
static  VTT_ENTRY vtt_ee32020[] = {
  {&(_ZTV7ee32020[3]),  3,8},
  {&(_ZTV7ee32020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee32020[];
extern  VTBL_ENTRY _ZTV7ee32020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32020[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee320203fooEv,_ZTv0_n12_N7ee320203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320203fooEv,_ZThn8_N7ee320203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32020 = {  "ee32020", // class name
  bases_ee32020, 4,
  &(vtc_ee32020[0]), // expected_vtbl_contents
  &(vtt_ee32020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42020  : dd2020 {
  int e;
  virtual void  bar(); // _ZN7ee420203barEv
  ~ee42020(); // tgen
  ee42020(); // tgen
};
//SIG(1 ee42020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42020 ::bar(){vfunc_called(this, "_ZN7ee420203barEv");}
ee42020 ::~ee42020(){ note_dtor("ee42020", this);} // tgen
ee42020 ::ee42020(){ note_ctor("ee42020", this);} // tgen

static void Test_ee42020()
{
  extern Class_Descriptor cd_ee42020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42020, buf);
    ee42020 *dp, &lv = *(dp=new (buf) ee42020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(8,4), "ee42020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), 0, "ee42020");
    check_base_class_offset(lv, (cc020*)(dd2020*), 0, "ee42020");
    check_base_class_offset(lv, (dd2020*), 0, "ee42020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42020.e");
    test_class_info(&lv, &cd_ee42020);
    dp->~ee42020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42020(Test_ee42020, "ee42020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42020C1Ev();
extern void _ZN7ee42020D1Ev();
Name_Map name_map_ee42020[] = {
  NSPAIR(_ZN7ee42020C1Ev),
  NSPAIR(_ZN7ee42020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee42020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42020[];
extern void _ZN6dd20203fooEv();
extern void _ZN7ee420203barEv();
static  VTBL_ENTRY vtc_ee42020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42020[0]),
  (VTBL_ENTRY)&_ZN6dd20203fooEv,
  (VTBL_ENTRY)&_ZN7ee420203barEv,
};
extern VTBL_ENTRY _ZTI7ee42020[];
extern  VTBL_ENTRY _ZTV7ee42020[];
Class_Descriptor cd_ee42020 = {  "ee42020", // class name
  bases_ee42020, 4,
  &(vtc_ee42020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52020  : virtual dd2020 {
  int e;
  virtual void  bar(); // _ZN7ee520203barEv
  ~ee52020(); // tgen
  ee52020(); // tgen
};
//SIG(1 ee52020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52020 ::bar(){vfunc_called(this, "_ZN7ee520203barEv");}
ee52020 ::~ee52020(){ note_dtor("ee52020", this);} // tgen
ee52020 ::ee52020(){ note_ctor("ee52020", this);} // tgen

static void Test_ee52020()
{
  extern Class_Descriptor cd_ee52020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52020, buf);
    ee52020 *dp, &lv = *(dp=new (buf) ee52020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(24,12), "ee52020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), ABISELECT(16,8), "ee52020");
    check_base_class_offset(lv, (cc020*)(dd2020*), ABISELECT(16,8), "ee52020");
    check_base_class_offset(lv, (dd2020*), ABISELECT(16,8), "ee52020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52020.e");
    test_class_info(&lv, &cd_ee52020);
    dp->~ee52020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52020(Test_ee52020, "ee52020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52020C1Ev();
extern void _ZN7ee52020D1Ev();
Name_Map name_map_ee52020[] = {
  NSPAIR(_ZN7ee52020C1Ev),
  NSPAIR(_ZN7ee52020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee52020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52020[];
extern void _ZN7ee520203barEv();
extern void _ZN6dd20203fooEv();
static  VTBL_ENTRY vtc_ee52020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52020[0]),
  (VTBL_ENTRY)&_ZN7ee520203barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52020[0]),
  (VTBL_ENTRY)&_ZN6dd20203fooEv,
};
extern VTBL_ENTRY _ZTV7ee52020[];
static  VTT_ENTRY vtt_ee52020[] = {
  {&(_ZTV7ee52020[3]),  3,8},
  {&(_ZTV7ee52020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee52020[];
extern  VTBL_ENTRY _ZTV7ee52020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52020[];
Class_Descriptor cd_ee52020 = {  "ee52020", // class name
  bases_ee52020, 4,
  &(vtc_ee52020[0]), // expected_vtbl_contents
  &(vtt_ee52020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62020  : dd2020 {
  int e;
  virtual void  foo(); // _ZN7ee620203fooEv
  virtual void  bar(); // _ZN7ee620203barEv
  ~ee62020(); // tgen
  ee62020(); // tgen
};
//SIG(1 ee62020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62020 ::foo(){vfunc_called(this, "_ZN7ee620203fooEv");}
void  ee62020 ::bar(){vfunc_called(this, "_ZN7ee620203barEv");}
ee62020 ::~ee62020(){ note_dtor("ee62020", this);} // tgen
ee62020 ::ee62020(){ note_ctor("ee62020", this);} // tgen

static void Test_ee62020()
{
  extern Class_Descriptor cd_ee62020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62020, buf);
    ee62020 *dp, &lv = *(dp=new (buf) ee62020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(8,4), "ee62020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), 0, "ee62020");
    check_base_class_offset(lv, (cc020*)(dd2020*), 0, "ee62020");
    check_base_class_offset(lv, (dd2020*), 0, "ee62020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62020.e");
    test_class_info(&lv, &cd_ee62020);
    dp->~ee62020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62020(Test_ee62020, "ee62020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62020C1Ev();
extern void _ZN7ee62020D1Ev();
Name_Map name_map_ee62020[] = {
  NSPAIR(_ZN7ee62020C1Ev),
  NSPAIR(_ZN7ee62020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee62020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62020[];
extern void _ZN7ee620203fooEv();
extern void _ZN7ee620203barEv();
static  VTBL_ENTRY vtc_ee62020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62020[0]),
  (VTBL_ENTRY)&_ZN7ee620203fooEv,
  (VTBL_ENTRY)&_ZN7ee620203barEv,
};
extern VTBL_ENTRY _ZTI7ee62020[];
extern  VTBL_ENTRY _ZTV7ee62020[];
Class_Descriptor cd_ee62020 = {  "ee62020", // class name
  bases_ee62020, 4,
  &(vtc_ee62020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72020  : virtual dd2020 {
  int e;
  virtual void  foo(); // _ZN7ee720203fooEv
  virtual void  bar(); // _ZN7ee720203barEv
  ~ee72020(); // tgen
  ee72020(); // tgen
};
//SIG(1 ee72020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72020 ::foo(){vfunc_called(this, "_ZN7ee720203fooEv");}
void  ee72020 ::bar(){vfunc_called(this, "_ZN7ee720203barEv");}
ee72020 ::~ee72020(){ note_dtor("ee72020", this);} // tgen
ee72020 ::ee72020(){ note_ctor("ee72020", this);} // tgen

static void Test_ee72020()
{
  extern Class_Descriptor cd_ee72020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72020, buf);
    ee72020 *dp, &lv = *(dp=new (buf) ee72020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd2020*), ABISELECT(24,12), "ee72020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd2020*), ABISELECT(16,8), "ee72020");
    check_base_class_offset(lv, (cc020*)(dd2020*), ABISELECT(16,8), "ee72020");
    check_base_class_offset(lv, (dd2020*), ABISELECT(16,8), "ee72020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72020.e");
    test_class_info(&lv, &cd_ee72020);
    dp->~ee72020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72020(Test_ee72020, "ee72020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72020C1Ev();
extern void _ZN7ee72020D1Ev();
Name_Map name_map_ee72020[] = {
  NSPAIR(_ZN7ee72020C1Ev),
  NSPAIR(_ZN7ee72020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd2020;
extern VTBL_ENTRY _ZTI6dd2020[];
extern  VTBL_ENTRY _ZTV6dd2020[];
static Base_Class bases_ee72020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72020[];
extern void _ZN7ee720203fooEv();
extern void _ZN7ee720203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee720203fooEv,_ZTv0_n12_N7ee720203fooEv)();
extern void ABISELECT(_ZThn16_N7ee720203fooEv,_ZThn8_N7ee720203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72020[0]),
  (VTBL_ENTRY)&_ZN7ee720203fooEv,
  (VTBL_ENTRY)&_ZN7ee720203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee720203fooEv,_ZTv0_n12_N7ee720203fooEv),
};
extern VTBL_ENTRY _ZTV7ee72020[];
static  VTT_ENTRY vtt_ee72020[] = {
  {&(_ZTV7ee72020[3]),  3,9},
  {&(_ZTV7ee72020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee72020[];
extern  VTBL_ENTRY _ZTV7ee72020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72020[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee720203fooEv,_ZTv0_n12_N7ee720203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720203fooEv,_ZThn8_N7ee720203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72020 = {  "ee72020", // class name
  bases_ee72020, 4,
  &(vtc_ee72020[0]), // expected_vtbl_contents
  &(vtt_ee72020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3020  : virtual cc020 {
  int d;
  virtual void  foo(); // _ZN6dd30203fooEv
  ~dd3020(); // tgen
  dd3020(); // tgen
};
//SIG(-1 dd3020) C1{ VBC2{ BC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd3020 ::foo(){vfunc_called(this, "_ZN6dd30203fooEv");}
dd3020 ::~dd3020(){ note_dtor("dd3020", this);} // tgen
dd3020 ::dd3020(){ note_ctor("dd3020", this);} // tgen

static void Test_dd3020()
{
  extern Class_Descriptor cd_dd3020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3020, buf);
    dd3020 *dp, &lv = *(dp=new (buf) dd3020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,12), "dd3020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,8), "dd3020");
    check_base_class_offset(lv, (cc020*), ABISELECT(16,8), "dd3020");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3020.d");
    test_class_info(&lv, &cd_dd3020);
    dp->~dd3020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3020(Test_dd3020, "dd3020", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3020C1Ev();
extern void _ZN6dd3020D1Ev();
Name_Map name_map_dd3020[] = {
  NSPAIR(_ZN6dd3020C1Ev),
  NSPAIR(_ZN6dd3020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd3020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3020[];
extern void _ZN6dd30203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
extern VTBL_ENTRY _ZTV6dd3020[];
static  VTT_ENTRY vtt_dd3020[] = {
  {&(_ZTV6dd3020[3]),  3,8},
  {&(_ZTV6dd3020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3020 = {  "dd3020", // class name
  bases_dd3020, 3,
  &(vtc_dd3020[0]), // expected_vtbl_contents
  &(vtt_dd3020[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3020),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03020  : dd3020 {
  int e;
  ~ee03020(); // tgen
  ee03020(); // tgen
};
//SIG(1 ee03020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee03020 ::~ee03020(){ note_dtor("ee03020", this);} // tgen
ee03020 ::ee03020(){ note_ctor("ee03020", this);} // tgen

static void Test_ee03020()
{
  extern Class_Descriptor cd_ee03020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03020, buf);
    ee03020 *dp, &lv = *(dp=new (buf) ee03020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee03020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee03020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(16,12), "ee03020");
    check_base_class_offset(lv, (dd3020*), 0, "ee03020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03020.e");
    test_class_info(&lv, &cd_ee03020);
    dp->~ee03020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03020(Test_ee03020, "ee03020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03020C1Ev();
extern void _ZN7ee03020D1Ev();
Name_Map name_map_ee03020[] = {
  NSPAIR(_ZN7ee03020C1Ev),
  NSPAIR(_ZN7ee03020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee03020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03020[];
extern void _ZN6dd30203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
extern VTBL_ENTRY _ZTV7ee03020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee03020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee03020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee03020[] = {
  {&(_ZTV7ee03020[3]),  3,8},
  {&(_tg__ZTV6dd3020__7ee03020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee03020[3]),  3,4},
  {&(_ZTV7ee03020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee03020[];
extern  VTBL_ENTRY _ZTV7ee03020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03020[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03020 = {  "ee03020", // class name
  bases_ee03020, 4,
  &(vtc_ee03020[0]), // expected_vtbl_contents
  &(vtt_ee03020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13020  : virtual dd3020 {
  int e;
  ~ee13020(); // tgen
  ee13020(); // tgen
};
//SIG(1 ee13020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee13020 ::~ee13020(){ note_dtor("ee13020", this);} // tgen
ee13020 ::ee13020(){ note_ctor("ee13020", this);} // tgen

static void Test_ee13020()
{
  extern Class_Descriptor cd_ee13020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13020, buf);
    ee13020 *dp, &lv = *(dp=new (buf) ee13020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee13020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee13020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(32,16), "ee13020");
    check_base_class_offset(lv, (dd3020*), ABISELECT(16,8), "ee13020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13020.e");
    test_class_info(&lv, &cd_ee13020);
    dp->~ee13020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13020(Test_ee13020, "ee13020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13020C1Ev();
extern void _ZN7ee13020D1Ev();
Name_Map name_map_ee13020[] = {
  NSPAIR(_ZN7ee13020C1Ev),
  NSPAIR(_ZN7ee13020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee13020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13020[];
extern void _ZN6dd30203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13020[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
extern VTBL_ENTRY _ZTV7ee13020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee13020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee13020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee13020[] = {
  {&(_ZTV7ee13020[4]),  4,13},
  {&(_ZTV7ee13020[8]),  8,13},
  {&(_ZTV7ee13020[12]),  12,13},
  {&(_tg__ZTV6dd3020__7ee13020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee13020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13020[];
extern  VTBL_ENTRY _ZTV7ee13020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13020[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13020 = {  "ee13020", // class name
  bases_ee13020, 4,
  &(vtc_ee13020[0]), // expected_vtbl_contents
  &(vtt_ee13020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13020),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23020  : dd3020 {
  int e;
  virtual void  foo(); // _ZN7ee230203fooEv
  ~ee23020(); // tgen
  ee23020(); // tgen
};
//SIG(1 ee23020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23020 ::foo(){vfunc_called(this, "_ZN7ee230203fooEv");}
ee23020 ::~ee23020(){ note_dtor("ee23020", this);} // tgen
ee23020 ::ee23020(){ note_ctor("ee23020", this);} // tgen

static void Test_ee23020()
{
  extern Class_Descriptor cd_ee23020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23020, buf);
    ee23020 *dp, &lv = *(dp=new (buf) ee23020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee23020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee23020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(16,12), "ee23020");
    check_base_class_offset(lv, (dd3020*), 0, "ee23020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23020.e");
    test_class_info(&lv, &cd_ee23020);
    dp->~ee23020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23020(Test_ee23020, "ee23020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23020C1Ev();
extern void _ZN7ee23020D1Ev();
Name_Map name_map_ee23020[] = {
  NSPAIR(_ZN7ee23020C1Ev),
  NSPAIR(_ZN7ee23020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee23020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23020[];
extern void _ZN7ee230203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee230203fooEv,_ZTv0_n12_N7ee230203fooEv)();
extern void ABISELECT(_ZThn16_N7ee230203fooEv,_ZThn12_N7ee230203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23020[0]),
  (VTBL_ENTRY)&_ZN7ee230203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee230203fooEv,_ZTv0_n12_N7ee230203fooEv),
};
extern VTBL_ENTRY _ZTV7ee23020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee23020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee23020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee23020[] = {
  {&(_ZTV7ee23020[3]),  3,8},
  {&(_tg__ZTV6dd3020__7ee23020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee23020[3]),  3,4},
  {&(_ZTV7ee23020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee23020[];
extern  VTBL_ENTRY _ZTV7ee23020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23020[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee230203fooEv,_ZTv0_n12_N7ee230203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee230203fooEv,_ZThn12_N7ee230203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23020 = {  "ee23020", // class name
  bases_ee23020, 4,
  &(vtc_ee23020[0]), // expected_vtbl_contents
  &(vtt_ee23020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33020  : virtual dd3020 {
  int e;
  virtual void  foo(); // _ZN7ee330203fooEv
  ~ee33020(); // tgen
  ee33020(); // tgen
};
//SIG(1 ee33020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33020 ::foo(){vfunc_called(this, "_ZN7ee330203fooEv");}
ee33020 ::~ee33020(){ note_dtor("ee33020", this);} // tgen
ee33020 ::ee33020(){ note_ctor("ee33020", this);} // tgen

static void Test_ee33020()
{
  extern Class_Descriptor cd_ee33020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33020, buf);
    ee33020 *dp, &lv = *(dp=new (buf) ee33020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee33020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee33020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(32,16), "ee33020");
    check_base_class_offset(lv, (dd3020*), ABISELECT(16,8), "ee33020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33020.e");
    test_class_info(&lv, &cd_ee33020);
    dp->~ee33020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33020(Test_ee33020, "ee33020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33020C1Ev();
extern void _ZN7ee33020D1Ev();
Name_Map name_map_ee33020[] = {
  NSPAIR(_ZN7ee33020C1Ev),
  NSPAIR(_ZN7ee33020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee33020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33020[];
extern void _ZN7ee330203fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee330203fooEv,_ZTv0_n16_N7ee330203fooEv)();
extern void ABISELECT(_ZThn16_N7ee330203fooEv,_ZThn8_N7ee330203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee330203fooEv,_ZTv0_n12_N7ee330203fooEv)();
extern void ABISELECT(_ZThn32_N7ee330203fooEv,_ZThn16_N7ee330203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33020[0]),
  (VTBL_ENTRY)&_ZN7ee330203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee330203fooEv,_ZTv0_n16_N7ee330203fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee330203fooEv,_ZTv0_n12_N7ee330203fooEv),
};
extern VTBL_ENTRY _ZTV7ee33020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee33020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee33020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee33020[] = {
  {&(_ZTV7ee33020[4]),  4,14},
  {&(_ZTV7ee33020[9]),  9,14},
  {&(_ZTV7ee33020[13]),  13,14},
  {&(_tg__ZTV6dd3020__7ee33020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee33020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33020[];
extern  VTBL_ENTRY _ZTV7ee33020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33020[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee330203fooEv,_ZTv0_n12_N7ee330203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee330203fooEv,_ZThn16_N7ee330203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee330203fooEv,_ZTv0_n16_N7ee330203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330203fooEv,_ZThn8_N7ee330203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33020 = {  "ee33020", // class name
  bases_ee33020, 4,
  &(vtc_ee33020[0]), // expected_vtbl_contents
  &(vtt_ee33020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33020),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43020  : dd3020 {
  int e;
  virtual void  bar(); // _ZN7ee430203barEv
  ~ee43020(); // tgen
  ee43020(); // tgen
};
//SIG(1 ee43020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43020 ::bar(){vfunc_called(this, "_ZN7ee430203barEv");}
ee43020 ::~ee43020(){ note_dtor("ee43020", this);} // tgen
ee43020 ::ee43020(){ note_ctor("ee43020", this);} // tgen

static void Test_ee43020()
{
  extern Class_Descriptor cd_ee43020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43020, buf);
    ee43020 *dp, &lv = *(dp=new (buf) ee43020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee43020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee43020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(16,12), "ee43020");
    check_base_class_offset(lv, (dd3020*), 0, "ee43020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43020.e");
    test_class_info(&lv, &cd_ee43020);
    dp->~ee43020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43020(Test_ee43020, "ee43020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43020C1Ev();
extern void _ZN7ee43020D1Ev();
Name_Map name_map_ee43020[] = {
  NSPAIR(_ZN7ee43020C1Ev),
  NSPAIR(_ZN7ee43020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee43020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43020[];
extern void _ZN6dd30203fooEv();
extern void _ZN7ee430203barEv();
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
  (VTBL_ENTRY)&_ZN7ee430203barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
extern VTBL_ENTRY _ZTV7ee43020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee43020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee43020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee43020[] = {
  {&(_ZTV7ee43020[3]),  3,9},
  {&(_tg__ZTV6dd3020__7ee43020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee43020[3]),  3,4},
  {&(_ZTV7ee43020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee43020[];
extern  VTBL_ENTRY _ZTV7ee43020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43020[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43020 = {  "ee43020", // class name
  bases_ee43020, 4,
  &(vtc_ee43020[0]), // expected_vtbl_contents
  &(vtt_ee43020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53020  : virtual dd3020 {
  int e;
  virtual void  bar(); // _ZN7ee530203barEv
  ~ee53020(); // tgen
  ee53020(); // tgen
};
//SIG(1 ee53020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53020 ::bar(){vfunc_called(this, "_ZN7ee530203barEv");}
ee53020 ::~ee53020(){ note_dtor("ee53020", this);} // tgen
ee53020 ::ee53020(){ note_ctor("ee53020", this);} // tgen

static void Test_ee53020()
{
  extern Class_Descriptor cd_ee53020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53020, buf);
    ee53020 *dp, &lv = *(dp=new (buf) ee53020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee53020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee53020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(32,16), "ee53020");
    check_base_class_offset(lv, (dd3020*), ABISELECT(16,8), "ee53020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53020.e");
    test_class_info(&lv, &cd_ee53020);
    dp->~ee53020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53020(Test_ee53020, "ee53020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53020C1Ev();
extern void _ZN7ee53020D1Ev();
Name_Map name_map_ee53020[] = {
  NSPAIR(_ZN7ee53020C1Ev),
  NSPAIR(_ZN7ee53020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee53020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53020[];
extern void _ZN7ee530203barEv();
extern void _ZN6dd30203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53020[0]),
  (VTBL_ENTRY)&_ZN7ee530203barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
extern VTBL_ENTRY _ZTV7ee53020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee53020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee53020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee53020[] = {
  {&(_ZTV7ee53020[4]),  4,14},
  {&(_ZTV7ee53020[9]),  9,14},
  {&(_ZTV7ee53020[13]),  13,14},
  {&(_tg__ZTV6dd3020__7ee53020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee53020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53020[];
extern  VTBL_ENTRY _ZTV7ee53020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53020[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53020 = {  "ee53020", // class name
  bases_ee53020, 4,
  &(vtc_ee53020[0]), // expected_vtbl_contents
  &(vtt_ee53020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53020),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63020  : dd3020 {
  int e;
  virtual void  foo(); // _ZN7ee630203fooEv
  virtual void  bar(); // _ZN7ee630203barEv
  ~ee63020(); // tgen
  ee63020(); // tgen
};
//SIG(1 ee63020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63020 ::foo(){vfunc_called(this, "_ZN7ee630203fooEv");}
void  ee63020 ::bar(){vfunc_called(this, "_ZN7ee630203barEv");}
ee63020 ::~ee63020(){ note_dtor("ee63020", this);} // tgen
ee63020 ::ee63020(){ note_ctor("ee63020", this);} // tgen

static void Test_ee63020()
{
  extern Class_Descriptor cd_ee63020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63020, buf);
    ee63020 *dp, &lv = *(dp=new (buf) ee63020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee63020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee63020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(16,12), "ee63020");
    check_base_class_offset(lv, (dd3020*), 0, "ee63020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63020.e");
    test_class_info(&lv, &cd_ee63020);
    dp->~ee63020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63020(Test_ee63020, "ee63020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63020C1Ev();
extern void _ZN7ee63020D1Ev();
Name_Map name_map_ee63020[] = {
  NSPAIR(_ZN7ee63020C1Ev),
  NSPAIR(_ZN7ee63020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee63020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63020[];
extern void _ZN7ee630203fooEv();
extern void _ZN7ee630203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee630203fooEv,_ZTv0_n12_N7ee630203fooEv)();
extern void ABISELECT(_ZThn16_N7ee630203fooEv,_ZThn12_N7ee630203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63020[0]),
  (VTBL_ENTRY)&_ZN7ee630203fooEv,
  (VTBL_ENTRY)&_ZN7ee630203barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee630203fooEv,_ZTv0_n12_N7ee630203fooEv),
};
extern VTBL_ENTRY _ZTV7ee63020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee63020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee63020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee63020[] = {
  {&(_ZTV7ee63020[3]),  3,9},
  {&(_tg__ZTV6dd3020__7ee63020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee63020[3]),  3,4},
  {&(_ZTV7ee63020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee63020[];
extern  VTBL_ENTRY _ZTV7ee63020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63020[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn12_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee630203fooEv,_ZTv0_n12_N7ee630203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee630203fooEv,_ZThn12_N7ee630203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63020 = {  "ee63020", // class name
  bases_ee63020, 4,
  &(vtc_ee63020[0]), // expected_vtbl_contents
  &(vtt_ee63020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73020  : virtual dd3020 {
  int e;
  virtual void  foo(); // _ZN7ee730203fooEv
  virtual void  bar(); // _ZN7ee730203barEv
  ~ee73020(); // tgen
  ee73020(); // tgen
};
//SIG(1 ee73020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73020 ::foo(){vfunc_called(this, "_ZN7ee730203fooEv");}
void  ee73020 ::bar(){vfunc_called(this, "_ZN7ee730203barEv");}
ee73020 ::~ee73020(){ note_dtor("ee73020", this);} // tgen
ee73020 ::ee73020(){ note_ctor("ee73020", this);} // tgen

static void Test_ee73020()
{
  extern Class_Descriptor cd_ee73020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73020, buf);
    ee73020 *dp, &lv = *(dp=new (buf) ee73020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee73020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee73020");
    check_base_class_offset(lv, (cc020*)(dd3020*), ABISELECT(32,16), "ee73020");
    check_base_class_offset(lv, (dd3020*), ABISELECT(16,8), "ee73020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73020.e");
    test_class_info(&lv, &cd_ee73020);
    dp->~ee73020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73020(Test_ee73020, "ee73020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73020C1Ev();
extern void _ZN7ee73020D1Ev();
Name_Map name_map_ee73020[] = {
  NSPAIR(_ZN7ee73020C1Ev),
  NSPAIR(_ZN7ee73020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd3020;
extern VTBL_ENTRY _ZTI6dd3020[];
extern  VTBL_ENTRY _ZTV6dd3020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3020[];
static Base_Class bases_ee73020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3020,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73020[];
extern void _ZN7ee730203fooEv();
extern void _ZN7ee730203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee730203fooEv,_ZTv0_n16_N7ee730203fooEv)();
extern void ABISELECT(_ZThn16_N7ee730203fooEv,_ZThn8_N7ee730203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee730203fooEv,_ZTv0_n12_N7ee730203fooEv)();
extern void ABISELECT(_ZThn32_N7ee730203fooEv,_ZThn16_N7ee730203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73020[0]),
  (VTBL_ENTRY)&_ZN7ee730203fooEv,
  (VTBL_ENTRY)&_ZN7ee730203barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730203fooEv,_ZTv0_n16_N7ee730203fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee730203fooEv,_ZTv0_n12_N7ee730203fooEv),
};
extern VTBL_ENTRY _ZTV7ee73020[];
extern void _ZN6dd30203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3020__7ee73020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&_ZN6dd30203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv)();
extern void ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd3020__7ee73020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv),
};
static  VTT_ENTRY vtt_ee73020[] = {
  {&(_ZTV7ee73020[4]),  4,15},
  {&(_ZTV7ee73020[10]),  10,15},
  {&(_ZTV7ee73020[14]),  14,15},
  {&(_tg__ZTV6dd3020__7ee73020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd3020__7ee73020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73020[];
extern  VTBL_ENTRY _ZTV7ee73020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73020[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd30203fooEv,_ZTv0_n12_N6dd30203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd30203fooEv,_ZThn8_N6dd30203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee730203fooEv,_ZTv0_n12_N7ee730203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee730203fooEv,_ZThn16_N7ee730203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee730203fooEv,_ZTv0_n16_N7ee730203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730203fooEv,_ZThn8_N7ee730203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73020 = {  "ee73020", // class name
  bases_ee73020, 4,
  &(vtc_ee73020[0]), // expected_vtbl_contents
  &(vtt_ee73020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73020),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4020  : cc020 {
  int d;
  virtual void  bar(); // _ZN6dd40203barEv
  ~dd4020(); // tgen
  dd4020(); // tgen
};
//SIG(-1 dd4020) C1{ BC2{ BC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd4020 ::bar(){vfunc_called(this, "_ZN6dd40203barEv");}
dd4020 ::~dd4020(){ note_dtor("dd4020", this);} // tgen
dd4020 ::dd4020(){ note_ctor("dd4020", this);} // tgen

static void Test_dd4020()
{
  extern Class_Descriptor cd_dd4020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4020, buf);
    dd4020 *dp, &lv = *(dp=new (buf) dd4020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(8,4), "dd4020");
    check_base_class_offset(lv, (bb20*)(cc020*), 0, "dd4020");
    check_base_class_offset(lv, (cc020*), 0, "dd4020");
    check_field_offset(lv, d, ABISELECT(20,16), "dd4020.d");
    test_class_info(&lv, &cd_dd4020);
    dp->~dd4020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4020(Test_dd4020, "dd4020", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4020C1Ev();
extern void _ZN6dd4020D1Ev();
Name_Map name_map_dd4020[] = {
  NSPAIR(_ZN6dd4020C1Ev),
  NSPAIR(_ZN6dd4020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd4020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4020[];
extern void _ZN4bb203fooEv();
extern void _ZN6dd40203barEv();
static  VTBL_ENTRY vtc_dd4020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd4020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
  (VTBL_ENTRY)&_ZN6dd40203barEv,
};
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
Class_Descriptor cd_dd4020 = {  "dd4020", // class name
  bases_dd4020, 3,
  &(vtc_dd4020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04020  : dd4020 {
  int e;
  ~ee04020(); // tgen
  ee04020(); // tgen
};
//SIG(1 ee04020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee04020 ::~ee04020(){ note_dtor("ee04020", this);} // tgen
ee04020 ::ee04020(){ note_ctor("ee04020", this);} // tgen

static void Test_ee04020()
{
  extern Class_Descriptor cd_ee04020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04020, buf);
    ee04020 *dp, &lv = *(dp=new (buf) ee04020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(8,4), "ee04020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), 0, "ee04020");
    check_base_class_offset(lv, (cc020*)(dd4020*), 0, "ee04020");
    check_base_class_offset(lv, (dd4020*), 0, "ee04020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee04020.e");
    test_class_info(&lv, &cd_ee04020);
    dp->~ee04020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04020(Test_ee04020, "ee04020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04020C1Ev();
extern void _ZN7ee04020D1Ev();
Name_Map name_map_ee04020[] = {
  NSPAIR(_ZN7ee04020C1Ev),
  NSPAIR(_ZN7ee04020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee04020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04020[];
extern void _ZN4bb203fooEv();
extern void _ZN6dd40203barEv();
static  VTBL_ENTRY vtc_ee04020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee04020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
  (VTBL_ENTRY)&_ZN6dd40203barEv,
};
extern VTBL_ENTRY _ZTI7ee04020[];
extern  VTBL_ENTRY _ZTV7ee04020[];
Class_Descriptor cd_ee04020 = {  "ee04020", // class name
  bases_ee04020, 4,
  &(vtc_ee04020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14020  : virtual dd4020 {
  int e;
  ~ee14020(); // tgen
  ee14020(); // tgen
};
//SIG(1 ee14020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee14020 ::~ee14020(){ note_dtor("ee14020", this);} // tgen
ee14020 ::ee14020(){ note_ctor("ee14020", this);} // tgen

static void Test_ee14020()
{
  extern Class_Descriptor cd_ee14020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14020, buf);
    ee14020 *dp, &lv = *(dp=new (buf) ee14020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(24,12), "ee14020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), ABISELECT(16,8), "ee14020");
    check_base_class_offset(lv, (cc020*)(dd4020*), ABISELECT(16,8), "ee14020");
    check_base_class_offset(lv, (dd4020*), ABISELECT(16,8), "ee14020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14020.e");
    test_class_info(&lv, &cd_ee14020);
    dp->~ee14020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14020(Test_ee14020, "ee14020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14020C1Ev();
extern void _ZN7ee14020D1Ev();
Name_Map name_map_ee14020[] = {
  NSPAIR(_ZN7ee14020C1Ev),
  NSPAIR(_ZN7ee14020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee14020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14020[];
extern void _ZN4bb203fooEv();
extern void _ZN6dd40203barEv();
static  VTBL_ENTRY vtc_ee14020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14020[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
  (VTBL_ENTRY)&_ZN6dd40203barEv,
};
extern VTBL_ENTRY _ZTV7ee14020[];
static  VTT_ENTRY vtt_ee14020[] = {
  {&(_ZTV7ee14020[3]),  3,9},
  {&(_ZTV7ee14020[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee14020[];
extern  VTBL_ENTRY _ZTV7ee14020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14020[];
Class_Descriptor cd_ee14020 = {  "ee14020", // class name
  bases_ee14020, 4,
  &(vtc_ee14020[0]), // expected_vtbl_contents
  &(vtt_ee14020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24020  : dd4020 {
  int e;
  virtual void  foo(); // _ZN7ee240203fooEv
  ~ee24020(); // tgen
  ee24020(); // tgen
};
//SIG(1 ee24020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24020 ::foo(){vfunc_called(this, "_ZN7ee240203fooEv");}
ee24020 ::~ee24020(){ note_dtor("ee24020", this);} // tgen
ee24020 ::ee24020(){ note_ctor("ee24020", this);} // tgen

static void Test_ee24020()
{
  extern Class_Descriptor cd_ee24020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24020, buf);
    ee24020 *dp, &lv = *(dp=new (buf) ee24020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(8,4), "ee24020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), 0, "ee24020");
    check_base_class_offset(lv, (cc020*)(dd4020*), 0, "ee24020");
    check_base_class_offset(lv, (dd4020*), 0, "ee24020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee24020.e");
    test_class_info(&lv, &cd_ee24020);
    dp->~ee24020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24020(Test_ee24020, "ee24020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24020C1Ev();
extern void _ZN7ee24020D1Ev();
Name_Map name_map_ee24020[] = {
  NSPAIR(_ZN7ee24020C1Ev),
  NSPAIR(_ZN7ee24020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee24020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24020[];
extern void _ZN7ee240203fooEv();
extern void _ZN6dd40203barEv();
static  VTBL_ENTRY vtc_ee24020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee24020[0]),
  (VTBL_ENTRY)&_ZN7ee240203fooEv,
  (VTBL_ENTRY)&_ZN6dd40203barEv,
};
extern VTBL_ENTRY _ZTI7ee24020[];
extern  VTBL_ENTRY _ZTV7ee24020[];
Class_Descriptor cd_ee24020 = {  "ee24020", // class name
  bases_ee24020, 4,
  &(vtc_ee24020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34020  : virtual dd4020 {
  int e;
  virtual void  foo(); // _ZN7ee340203fooEv
  ~ee34020(); // tgen
  ee34020(); // tgen
};
//SIG(1 ee34020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34020 ::foo(){vfunc_called(this, "_ZN7ee340203fooEv");}
ee34020 ::~ee34020(){ note_dtor("ee34020", this);} // tgen
ee34020 ::ee34020(){ note_ctor("ee34020", this);} // tgen

static void Test_ee34020()
{
  extern Class_Descriptor cd_ee34020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34020, buf);
    ee34020 *dp, &lv = *(dp=new (buf) ee34020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(24,12), "ee34020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), ABISELECT(16,8), "ee34020");
    check_base_class_offset(lv, (cc020*)(dd4020*), ABISELECT(16,8), "ee34020");
    check_base_class_offset(lv, (dd4020*), ABISELECT(16,8), "ee34020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34020.e");
    test_class_info(&lv, &cd_ee34020);
    dp->~ee34020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34020(Test_ee34020, "ee34020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34020C1Ev();
extern void _ZN7ee34020D1Ev();
Name_Map name_map_ee34020[] = {
  NSPAIR(_ZN7ee34020C1Ev),
  NSPAIR(_ZN7ee34020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee34020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34020[];
extern void _ZN7ee340203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee340203fooEv,_ZTv0_n12_N7ee340203fooEv)();
extern void ABISELECT(_ZThn16_N7ee340203fooEv,_ZThn8_N7ee340203fooEv)() __attribute__((weak));
extern void _ZN6dd40203barEv();
static  VTBL_ENTRY vtc_ee34020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34020[0]),
  (VTBL_ENTRY)&_ZN7ee340203fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee340203fooEv,_ZTv0_n12_N7ee340203fooEv),
  (VTBL_ENTRY)&_ZN6dd40203barEv,
};
extern VTBL_ENTRY _ZTV7ee34020[];
static  VTT_ENTRY vtt_ee34020[] = {
  {&(_ZTV7ee34020[3]),  3,10},
  {&(_ZTV7ee34020[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee34020[];
extern  VTBL_ENTRY _ZTV7ee34020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34020[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee340203fooEv,_ZTv0_n12_N7ee340203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee340203fooEv,_ZThn8_N7ee340203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34020 = {  "ee34020", // class name
  bases_ee34020, 4,
  &(vtc_ee34020[0]), // expected_vtbl_contents
  &(vtt_ee34020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34020),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44020  : dd4020 {
  int e;
  virtual void  bar(); // _ZN7ee440203barEv
  ~ee44020(); // tgen
  ee44020(); // tgen
};
//SIG(1 ee44020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44020 ::bar(){vfunc_called(this, "_ZN7ee440203barEv");}
ee44020 ::~ee44020(){ note_dtor("ee44020", this);} // tgen
ee44020 ::ee44020(){ note_ctor("ee44020", this);} // tgen

static void Test_ee44020()
{
  extern Class_Descriptor cd_ee44020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44020, buf);
    ee44020 *dp, &lv = *(dp=new (buf) ee44020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(8,4), "ee44020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), 0, "ee44020");
    check_base_class_offset(lv, (cc020*)(dd4020*), 0, "ee44020");
    check_base_class_offset(lv, (dd4020*), 0, "ee44020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee44020.e");
    test_class_info(&lv, &cd_ee44020);
    dp->~ee44020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44020(Test_ee44020, "ee44020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44020C1Ev();
extern void _ZN7ee44020D1Ev();
Name_Map name_map_ee44020[] = {
  NSPAIR(_ZN7ee44020C1Ev),
  NSPAIR(_ZN7ee44020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee44020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44020[];
extern void _ZN4bb203fooEv();
extern void _ZN7ee440203barEv();
static  VTBL_ENTRY vtc_ee44020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee44020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
  (VTBL_ENTRY)&_ZN7ee440203barEv,
};
extern VTBL_ENTRY _ZTI7ee44020[];
extern  VTBL_ENTRY _ZTV7ee44020[];
Class_Descriptor cd_ee44020 = {  "ee44020", // class name
  bases_ee44020, 4,
  &(vtc_ee44020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54020  : virtual dd4020 {
  int e;
  virtual void  bar(); // _ZN7ee540203barEv
  ~ee54020(); // tgen
  ee54020(); // tgen
};
//SIG(1 ee54020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54020 ::bar(){vfunc_called(this, "_ZN7ee540203barEv");}
ee54020 ::~ee54020(){ note_dtor("ee54020", this);} // tgen
ee54020 ::ee54020(){ note_ctor("ee54020", this);} // tgen

static void Test_ee54020()
{
  extern Class_Descriptor cd_ee54020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54020, buf);
    ee54020 *dp, &lv = *(dp=new (buf) ee54020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(24,12), "ee54020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), ABISELECT(16,8), "ee54020");
    check_base_class_offset(lv, (cc020*)(dd4020*), ABISELECT(16,8), "ee54020");
    check_base_class_offset(lv, (dd4020*), ABISELECT(16,8), "ee54020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54020.e");
    test_class_info(&lv, &cd_ee54020);
    dp->~ee54020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54020(Test_ee54020, "ee54020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54020C1Ev();
extern void _ZN7ee54020D1Ev();
Name_Map name_map_ee54020[] = {
  NSPAIR(_ZN7ee54020C1Ev),
  NSPAIR(_ZN7ee54020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee54020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54020[];
extern void _ZN7ee540203barEv();
extern void _ZN4bb203fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee540203barEv,_ZTv0_n16_N7ee540203barEv)();
extern void ABISELECT(_ZThn16_N7ee540203barEv,_ZThn8_N7ee540203barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54020[0]),
  (VTBL_ENTRY)&_ZN7ee540203barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee540203barEv,_ZTv0_n16_N7ee540203barEv),
};
extern VTBL_ENTRY _ZTV7ee54020[];
static  VTT_ENTRY vtt_ee54020[] = {
  {&(_ZTV7ee54020[3]),  3,10},
  {&(_ZTV7ee54020[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee54020[];
extern  VTBL_ENTRY _ZTV7ee54020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54020[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee540203barEv,_ZTv0_n16_N7ee540203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540203barEv,_ZThn8_N7ee540203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54020 = {  "ee54020", // class name
  bases_ee54020, 4,
  &(vtc_ee54020[0]), // expected_vtbl_contents
  &(vtt_ee54020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54020),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64020  : dd4020 {
  int e;
  virtual void  foo(); // _ZN7ee640203fooEv
  virtual void  bar(); // _ZN7ee640203barEv
  ~ee64020(); // tgen
  ee64020(); // tgen
};
//SIG(1 ee64020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64020 ::foo(){vfunc_called(this, "_ZN7ee640203fooEv");}
void  ee64020 ::bar(){vfunc_called(this, "_ZN7ee640203barEv");}
ee64020 ::~ee64020(){ note_dtor("ee64020", this);} // tgen
ee64020 ::ee64020(){ note_ctor("ee64020", this);} // tgen

static void Test_ee64020()
{
  extern Class_Descriptor cd_ee64020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64020, buf);
    ee64020 *dp, &lv = *(dp=new (buf) ee64020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(8,4), "ee64020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), 0, "ee64020");
    check_base_class_offset(lv, (cc020*)(dd4020*), 0, "ee64020");
    check_base_class_offset(lv, (dd4020*), 0, "ee64020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee64020.e");
    test_class_info(&lv, &cd_ee64020);
    dp->~ee64020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64020(Test_ee64020, "ee64020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64020C1Ev();
extern void _ZN7ee64020D1Ev();
Name_Map name_map_ee64020[] = {
  NSPAIR(_ZN7ee64020C1Ev),
  NSPAIR(_ZN7ee64020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee64020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64020[];
extern void _ZN7ee640203fooEv();
extern void _ZN7ee640203barEv();
static  VTBL_ENTRY vtc_ee64020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee64020[0]),
  (VTBL_ENTRY)&_ZN7ee640203fooEv,
  (VTBL_ENTRY)&_ZN7ee640203barEv,
};
extern VTBL_ENTRY _ZTI7ee64020[];
extern  VTBL_ENTRY _ZTV7ee64020[];
Class_Descriptor cd_ee64020 = {  "ee64020", // class name
  bases_ee64020, 4,
  &(vtc_ee64020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74020  : virtual dd4020 {
  int e;
  virtual void  foo(); // _ZN7ee740203fooEv
  virtual void  bar(); // _ZN7ee740203barEv
  ~ee74020(); // tgen
  ee74020(); // tgen
};
//SIG(1 ee74020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74020 ::foo(){vfunc_called(this, "_ZN7ee740203fooEv");}
void  ee74020 ::bar(){vfunc_called(this, "_ZN7ee740203barEv");}
ee74020 ::~ee74020(){ note_dtor("ee74020", this);} // tgen
ee74020 ::ee74020(){ note_ctor("ee74020", this);} // tgen

static void Test_ee74020()
{
  extern Class_Descriptor cd_ee74020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74020, buf);
    ee74020 *dp, &lv = *(dp=new (buf) ee74020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd4020*), ABISELECT(24,12), "ee74020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd4020*), ABISELECT(16,8), "ee74020");
    check_base_class_offset(lv, (cc020*)(dd4020*), ABISELECT(16,8), "ee74020");
    check_base_class_offset(lv, (dd4020*), ABISELECT(16,8), "ee74020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74020.e");
    test_class_info(&lv, &cd_ee74020);
    dp->~ee74020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74020(Test_ee74020, "ee74020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74020C1Ev();
extern void _ZN7ee74020D1Ev();
Name_Map name_map_ee74020[] = {
  NSPAIR(_ZN7ee74020C1Ev),
  NSPAIR(_ZN7ee74020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd4020;
extern VTBL_ENTRY _ZTI6dd4020[];
extern  VTBL_ENTRY _ZTV6dd4020[];
static Base_Class bases_ee74020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74020[];
extern void _ZN7ee740203fooEv();
extern void _ZN7ee740203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee740203fooEv,_ZTv0_n12_N7ee740203fooEv)();
extern void ABISELECT(_ZThn16_N7ee740203fooEv,_ZThn8_N7ee740203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee740203barEv,_ZTv0_n16_N7ee740203barEv)();
extern void ABISELECT(_ZThn16_N7ee740203barEv,_ZThn8_N7ee740203barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74020[0]),
  (VTBL_ENTRY)&_ZN7ee740203fooEv,
  (VTBL_ENTRY)&_ZN7ee740203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee740203fooEv,_ZTv0_n12_N7ee740203fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee740203barEv,_ZTv0_n16_N7ee740203barEv),
};
extern VTBL_ENTRY _ZTV7ee74020[];
static  VTT_ENTRY vtt_ee74020[] = {
  {&(_ZTV7ee74020[3]),  3,11},
  {&(_ZTV7ee74020[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee74020[];
extern  VTBL_ENTRY _ZTV7ee74020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74020[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee740203barEv,_ZTv0_n16_N7ee740203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740203barEv,_ZThn8_N7ee740203barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee740203fooEv,_ZTv0_n12_N7ee740203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740203fooEv,_ZThn8_N7ee740203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74020 = {  "ee74020", // class name
  bases_ee74020, 4,
  &(vtc_ee74020[0]), // expected_vtbl_contents
  &(vtt_ee74020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74020),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5020  : virtual cc020 {
  int d;
  virtual void  bar(); // _ZN6dd50203barEv
  ~dd5020(); // tgen
  dd5020(); // tgen
};
//SIG(-1 dd5020) C1{ VBC2{ BC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd5020 ::bar(){vfunc_called(this, "_ZN6dd50203barEv");}
dd5020 ::~dd5020(){ note_dtor("dd5020", this);} // tgen
dd5020 ::dd5020(){ note_ctor("dd5020", this);} // tgen

static void Test_dd5020()
{
  extern Class_Descriptor cd_dd5020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5020, buf);
    dd5020 *dp, &lv = *(dp=new (buf) dd5020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,12), "dd5020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,8), "dd5020");
    check_base_class_offset(lv, (cc020*), ABISELECT(16,8), "dd5020");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5020.d");
    test_class_info(&lv, &cd_dd5020);
    dp->~dd5020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5020(Test_dd5020, "dd5020", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5020C1Ev();
extern void _ZN6dd5020D1Ev();
Name_Map name_map_dd5020[] = {
  NSPAIR(_ZN6dd5020C1Ev),
  NSPAIR(_ZN6dd5020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd5020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5020[];
extern void _ZN6dd50203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_dd5020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV6dd5020[];
static  VTT_ENTRY vtt_dd5020[] = {
  {&(_ZTV6dd5020[3]),  3,8},
  {&(_ZTV6dd5020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
Class_Descriptor cd_dd5020 = {  "dd5020", // class name
  bases_dd5020, 3,
  &(vtc_dd5020[0]), // expected_vtbl_contents
  &(vtt_dd5020[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5020),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05020  : dd5020 {
  int e;
  ~ee05020(); // tgen
  ee05020(); // tgen
};
//SIG(1 ee05020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee05020 ::~ee05020(){ note_dtor("ee05020", this);} // tgen
ee05020 ::ee05020(){ note_ctor("ee05020", this);} // tgen

static void Test_ee05020()
{
  extern Class_Descriptor cd_ee05020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05020, buf);
    ee05020 *dp, &lv = *(dp=new (buf) ee05020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee05020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee05020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(16,12), "ee05020");
    check_base_class_offset(lv, (dd5020*), 0, "ee05020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05020.e");
    test_class_info(&lv, &cd_ee05020);
    dp->~ee05020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05020(Test_ee05020, "ee05020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05020C1Ev();
extern void _ZN7ee05020D1Ev();
Name_Map name_map_ee05020[] = {
  NSPAIR(_ZN7ee05020C1Ev),
  NSPAIR(_ZN7ee05020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee05020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05020[];
extern void _ZN6dd50203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee05020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee05020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee05020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee05020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee05020[] = {
  {&(_ZTV7ee05020[3]),  3,8},
  {&(_tg__ZTV6dd5020__7ee05020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee05020[3]),  3,4},
  {&(_ZTV7ee05020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee05020[];
extern  VTBL_ENTRY _ZTV7ee05020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05020[];
Class_Descriptor cd_ee05020 = {  "ee05020", // class name
  bases_ee05020, 4,
  &(vtc_ee05020[0]), // expected_vtbl_contents
  &(vtt_ee05020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15020  : virtual dd5020 {
  int e;
  ~ee15020(); // tgen
  ee15020(); // tgen
};
//SIG(1 ee15020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee15020 ::~ee15020(){ note_dtor("ee15020", this);} // tgen
ee15020 ::ee15020(){ note_ctor("ee15020", this);} // tgen

static void Test_ee15020()
{
  extern Class_Descriptor cd_ee15020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15020, buf);
    ee15020 *dp, &lv = *(dp=new (buf) ee15020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee15020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee15020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(32,16), "ee15020");
    check_base_class_offset(lv, (dd5020*), ABISELECT(16,8), "ee15020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15020.e");
    test_class_info(&lv, &cd_ee15020);
    dp->~ee15020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15020(Test_ee15020, "ee15020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15020C1Ev();
extern void _ZN7ee15020D1Ev();
Name_Map name_map_ee15020[] = {
  NSPAIR(_ZN7ee15020C1Ev),
  NSPAIR(_ZN7ee15020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee15020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15020[];
extern void _ZN6dd50203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee15020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15020[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee15020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee15020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee15020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee15020[] = {
  {&(_ZTV7ee15020[4]),  4,13},
  {&(_ZTV7ee15020[8]),  8,13},
  {&(_ZTV7ee15020[12]),  12,13},
  {&(_tg__ZTV6dd5020__7ee15020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee15020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15020[];
extern  VTBL_ENTRY _ZTV7ee15020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15020[];
Class_Descriptor cd_ee15020 = {  "ee15020", // class name
  bases_ee15020, 4,
  &(vtc_ee15020[0]), // expected_vtbl_contents
  &(vtt_ee15020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15020),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25020  : dd5020 {
  int e;
  virtual void  foo(); // _ZN7ee250203fooEv
  ~ee25020(); // tgen
  ee25020(); // tgen
};
//SIG(1 ee25020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25020 ::foo(){vfunc_called(this, "_ZN7ee250203fooEv");}
ee25020 ::~ee25020(){ note_dtor("ee25020", this);} // tgen
ee25020 ::ee25020(){ note_ctor("ee25020", this);} // tgen

static void Test_ee25020()
{
  extern Class_Descriptor cd_ee25020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25020, buf);
    ee25020 *dp, &lv = *(dp=new (buf) ee25020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee25020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee25020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(16,12), "ee25020");
    check_base_class_offset(lv, (dd5020*), 0, "ee25020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25020.e");
    test_class_info(&lv, &cd_ee25020);
    dp->~ee25020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25020(Test_ee25020, "ee25020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25020C1Ev();
extern void _ZN7ee25020D1Ev();
Name_Map name_map_ee25020[] = {
  NSPAIR(_ZN7ee25020C1Ev),
  NSPAIR(_ZN7ee25020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee25020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25020[];
extern void _ZN6dd50203barEv();
extern void _ZN7ee250203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee250203fooEv,_ZTv0_n12_N7ee250203fooEv)();
extern void ABISELECT(_ZThn16_N7ee250203fooEv,_ZThn12_N7ee250203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
  (VTBL_ENTRY)&_ZN7ee250203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee250203fooEv,_ZTv0_n12_N7ee250203fooEv),
};
extern VTBL_ENTRY _ZTV7ee25020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee25020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee25020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee25020[] = {
  {&(_ZTV7ee25020[3]),  3,9},
  {&(_tg__ZTV6dd5020__7ee25020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee25020[3]),  3,4},
  {&(_ZTV7ee25020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee25020[];
extern  VTBL_ENTRY _ZTV7ee25020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25020[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee250203fooEv,_ZTv0_n12_N7ee250203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee250203fooEv,_ZThn12_N7ee250203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25020 = {  "ee25020", // class name
  bases_ee25020, 4,
  &(vtc_ee25020[0]), // expected_vtbl_contents
  &(vtt_ee25020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35020  : virtual dd5020 {
  int e;
  virtual void  foo(); // _ZN7ee350203fooEv
  ~ee35020(); // tgen
  ee35020(); // tgen
};
//SIG(1 ee35020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35020 ::foo(){vfunc_called(this, "_ZN7ee350203fooEv");}
ee35020 ::~ee35020(){ note_dtor("ee35020", this);} // tgen
ee35020 ::ee35020(){ note_ctor("ee35020", this);} // tgen

static void Test_ee35020()
{
  extern Class_Descriptor cd_ee35020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35020, buf);
    ee35020 *dp, &lv = *(dp=new (buf) ee35020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee35020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee35020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(32,16), "ee35020");
    check_base_class_offset(lv, (dd5020*), ABISELECT(16,8), "ee35020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35020.e");
    test_class_info(&lv, &cd_ee35020);
    dp->~ee35020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35020(Test_ee35020, "ee35020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35020C1Ev();
extern void _ZN7ee35020D1Ev();
Name_Map name_map_ee35020[] = {
  NSPAIR(_ZN7ee35020C1Ev),
  NSPAIR(_ZN7ee35020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee35020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35020[];
extern void _ZN7ee350203fooEv();
extern void _ZN6dd50203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee350203fooEv,_ZTv0_n12_N7ee350203fooEv)();
extern void ABISELECT(_ZThn32_N7ee350203fooEv,_ZThn16_N7ee350203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35020[0]),
  (VTBL_ENTRY)&_ZN7ee350203fooEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee350203fooEv,_ZTv0_n12_N7ee350203fooEv),
};
extern VTBL_ENTRY _ZTV7ee35020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee35020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee35020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee35020[] = {
  {&(_ZTV7ee35020[4]),  4,14},
  {&(_ZTV7ee35020[9]),  9,14},
  {&(_ZTV7ee35020[13]),  13,14},
  {&(_tg__ZTV6dd5020__7ee35020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee35020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35020[];
extern  VTBL_ENTRY _ZTV7ee35020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35020[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee350203fooEv,_ZTv0_n12_N7ee350203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee350203fooEv,_ZThn16_N7ee350203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35020 = {  "ee35020", // class name
  bases_ee35020, 4,
  &(vtc_ee35020[0]), // expected_vtbl_contents
  &(vtt_ee35020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35020),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45020  : dd5020 {
  int e;
  virtual void  bar(); // _ZN7ee450203barEv
  ~ee45020(); // tgen
  ee45020(); // tgen
};
//SIG(1 ee45020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45020 ::bar(){vfunc_called(this, "_ZN7ee450203barEv");}
ee45020 ::~ee45020(){ note_dtor("ee45020", this);} // tgen
ee45020 ::ee45020(){ note_ctor("ee45020", this);} // tgen

static void Test_ee45020()
{
  extern Class_Descriptor cd_ee45020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45020, buf);
    ee45020 *dp, &lv = *(dp=new (buf) ee45020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee45020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee45020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(16,12), "ee45020");
    check_base_class_offset(lv, (dd5020*), 0, "ee45020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45020.e");
    test_class_info(&lv, &cd_ee45020);
    dp->~ee45020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45020(Test_ee45020, "ee45020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45020C1Ev();
extern void _ZN7ee45020D1Ev();
Name_Map name_map_ee45020[] = {
  NSPAIR(_ZN7ee45020C1Ev),
  NSPAIR(_ZN7ee45020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee45020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45020[];
extern void _ZN7ee450203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee45020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45020[0]),
  (VTBL_ENTRY)&_ZN7ee450203barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee45020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee45020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee45020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee45020[] = {
  {&(_ZTV7ee45020[3]),  3,8},
  {&(_tg__ZTV6dd5020__7ee45020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee45020[3]),  3,4},
  {&(_ZTV7ee45020[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee45020[];
extern  VTBL_ENTRY _ZTV7ee45020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45020[];
Class_Descriptor cd_ee45020 = {  "ee45020", // class name
  bases_ee45020, 4,
  &(vtc_ee45020[0]), // expected_vtbl_contents
  &(vtt_ee45020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45020),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55020  : virtual dd5020 {
  int e;
  virtual void  bar(); // _ZN7ee550203barEv
  ~ee55020(); // tgen
  ee55020(); // tgen
};
//SIG(1 ee55020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55020 ::bar(){vfunc_called(this, "_ZN7ee550203barEv");}
ee55020 ::~ee55020(){ note_dtor("ee55020", this);} // tgen
ee55020 ::ee55020(){ note_ctor("ee55020", this);} // tgen

static void Test_ee55020()
{
  extern Class_Descriptor cd_ee55020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55020, buf);
    ee55020 *dp, &lv = *(dp=new (buf) ee55020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee55020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee55020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(32,16), "ee55020");
    check_base_class_offset(lv, (dd5020*), ABISELECT(16,8), "ee55020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55020.e");
    test_class_info(&lv, &cd_ee55020);
    dp->~ee55020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55020(Test_ee55020, "ee55020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55020C1Ev();
extern void _ZN7ee55020D1Ev();
Name_Map name_map_ee55020[] = {
  NSPAIR(_ZN7ee55020C1Ev),
  NSPAIR(_ZN7ee55020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee55020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55020[];
extern void _ZN7ee550203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee550203barEv,_ZTv0_n16_N7ee550203barEv)();
extern void ABISELECT(_ZThn16_N7ee550203barEv,_ZThn8_N7ee550203barEv)() __attribute__((weak));
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee55020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55020[0]),
  (VTBL_ENTRY)&_ZN7ee550203barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee550203barEv,_ZTv0_n16_N7ee550203barEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee55020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee55020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee55020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee55020[] = {
  {&(_ZTV7ee55020[4]),  4,14},
  {&(_ZTV7ee55020[9]),  9,14},
  {&(_ZTV7ee55020[13]),  13,14},
  {&(_tg__ZTV6dd5020__7ee55020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee55020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55020[];
extern  VTBL_ENTRY _ZTV7ee55020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55020[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee550203barEv,_ZTv0_n16_N7ee550203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550203barEv,_ZThn8_N7ee550203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55020 = {  "ee55020", // class name
  bases_ee55020, 4,
  &(vtc_ee55020[0]), // expected_vtbl_contents
  &(vtt_ee55020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55020),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65020  : dd5020 {
  int e;
  virtual void  foo(); // _ZN7ee650203fooEv
  virtual void  bar(); // _ZN7ee650203barEv
  ~ee65020(); // tgen
  ee65020(); // tgen
};
//SIG(1 ee65020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65020 ::foo(){vfunc_called(this, "_ZN7ee650203fooEv");}
void  ee65020 ::bar(){vfunc_called(this, "_ZN7ee650203barEv");}
ee65020 ::~ee65020(){ note_dtor("ee65020", this);} // tgen
ee65020 ::ee65020(){ note_ctor("ee65020", this);} // tgen

static void Test_ee65020()
{
  extern Class_Descriptor cd_ee65020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65020, buf);
    ee65020 *dp, &lv = *(dp=new (buf) ee65020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee65020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee65020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(16,12), "ee65020");
    check_base_class_offset(lv, (dd5020*), 0, "ee65020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65020.e");
    test_class_info(&lv, &cd_ee65020);
    dp->~ee65020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65020(Test_ee65020, "ee65020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65020C1Ev();
extern void _ZN7ee65020D1Ev();
Name_Map name_map_ee65020[] = {
  NSPAIR(_ZN7ee65020C1Ev),
  NSPAIR(_ZN7ee65020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee65020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65020[];
extern void _ZN7ee650203barEv();
extern void _ZN7ee650203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee650203fooEv,_ZTv0_n12_N7ee650203fooEv)();
extern void ABISELECT(_ZThn16_N7ee650203fooEv,_ZThn12_N7ee650203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65020[0]),
  (VTBL_ENTRY)&_ZN7ee650203barEv,
  (VTBL_ENTRY)&_ZN7ee650203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee650203fooEv,_ZTv0_n12_N7ee650203fooEv),
};
extern VTBL_ENTRY _ZTV7ee65020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee65020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee65020[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee65020[] = {
  {&(_ZTV7ee65020[3]),  3,9},
  {&(_tg__ZTV6dd5020__7ee65020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee65020[3]),  3,4},
  {&(_ZTV7ee65020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee65020[];
extern  VTBL_ENTRY _ZTV7ee65020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65020[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee650203fooEv,_ZTv0_n12_N7ee650203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee650203fooEv,_ZThn12_N7ee650203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65020 = {  "ee65020", // class name
  bases_ee65020, 4,
  &(vtc_ee65020[0]), // expected_vtbl_contents
  &(vtt_ee65020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75020  : virtual dd5020 {
  int e;
  virtual void  foo(); // _ZN7ee750203fooEv
  virtual void  bar(); // _ZN7ee750203barEv
  ~ee75020(); // tgen
  ee75020(); // tgen
};
//SIG(1 ee75020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75020 ::foo(){vfunc_called(this, "_ZN7ee750203fooEv");}
void  ee75020 ::bar(){vfunc_called(this, "_ZN7ee750203barEv");}
ee75020 ::~ee75020(){ note_dtor("ee75020", this);} // tgen
ee75020 ::ee75020(){ note_ctor("ee75020", this);} // tgen

static void Test_ee75020()
{
  extern Class_Descriptor cd_ee75020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75020, buf);
    ee75020 *dp, &lv = *(dp=new (buf) ee75020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee75020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee75020");
    check_base_class_offset(lv, (cc020*)(dd5020*), ABISELECT(32,16), "ee75020");
    check_base_class_offset(lv, (dd5020*), ABISELECT(16,8), "ee75020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75020.e");
    test_class_info(&lv, &cd_ee75020);
    dp->~ee75020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75020(Test_ee75020, "ee75020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75020C1Ev();
extern void _ZN7ee75020D1Ev();
Name_Map name_map_ee75020[] = {
  NSPAIR(_ZN7ee75020C1Ev),
  NSPAIR(_ZN7ee75020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd5020;
extern VTBL_ENTRY _ZTI6dd5020[];
extern  VTBL_ENTRY _ZTV6dd5020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5020[];
static Base_Class bases_ee75020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5020,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75020[];
extern void _ZN7ee750203fooEv();
extern void _ZN7ee750203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee750203barEv,_ZTv0_n16_N7ee750203barEv)();
extern void ABISELECT(_ZThn16_N7ee750203barEv,_ZThn8_N7ee750203barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee750203fooEv,_ZTv0_n12_N7ee750203fooEv)();
extern void ABISELECT(_ZThn32_N7ee750203fooEv,_ZThn16_N7ee750203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75020[0]),
  (VTBL_ENTRY)&_ZN7ee750203fooEv,
  (VTBL_ENTRY)&_ZN7ee750203barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750203barEv,_ZTv0_n16_N7ee750203barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee750203fooEv,_ZTv0_n12_N7ee750203fooEv),
};
extern VTBL_ENTRY _ZTV7ee75020[];
extern void _ZN6dd50203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5020__7ee75020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN6dd50203barEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd5020__7ee75020[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5020[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee75020[] = {
  {&(_ZTV7ee75020[4]),  4,15},
  {&(_ZTV7ee75020[10]),  10,15},
  {&(_ZTV7ee75020[14]),  14,15},
  {&(_tg__ZTV6dd5020__7ee75020[3]),  3,4},
  {&(_tg__ZTV4bb205cc020__6dd5020__7ee75020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75020[];
extern  VTBL_ENTRY _ZTV7ee75020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75020[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee750203fooEv,_ZTv0_n12_N7ee750203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee750203fooEv,_ZThn16_N7ee750203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750203barEv,_ZTv0_n16_N7ee750203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750203barEv,_ZThn8_N7ee750203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75020 = {  "ee75020", // class name
  bases_ee75020, 4,
  &(vtc_ee75020[0]), // expected_vtbl_contents
  &(vtt_ee75020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75020),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6020  : cc020 {
  int d;
  virtual void  bar(); // _ZN6dd60203barEv
  virtual void  foo(); // _ZN6dd60203fooEv
  ~dd6020(); // tgen
  dd6020(); // tgen
};
//SIG(-1 dd6020) C1{ BC2{ BC3{ BC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd6020 ::bar(){vfunc_called(this, "_ZN6dd60203barEv");}
void  dd6020 ::foo(){vfunc_called(this, "_ZN6dd60203fooEv");}
dd6020 ::~dd6020(){ note_dtor("dd6020", this);} // tgen
dd6020 ::dd6020(){ note_ctor("dd6020", this);} // tgen

static void Test_dd6020()
{
  extern Class_Descriptor cd_dd6020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6020, buf);
    dd6020 *dp, &lv = *(dp=new (buf) dd6020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(8,4), "dd6020");
    check_base_class_offset(lv, (bb20*)(cc020*), 0, "dd6020");
    check_base_class_offset(lv, (cc020*), 0, "dd6020");
    check_field_offset(lv, d, ABISELECT(20,16), "dd6020.d");
    test_class_info(&lv, &cd_dd6020);
    dp->~dd6020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6020(Test_dd6020, "dd6020", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6020C1Ev();
extern void _ZN6dd6020D1Ev();
Name_Map name_map_dd6020[] = {
  NSPAIR(_ZN6dd6020C1Ev),
  NSPAIR(_ZN6dd6020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd6020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6020[];
extern void _ZN6dd60203fooEv();
extern void _ZN6dd60203barEv();
static  VTBL_ENTRY vtc_dd6020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd6020[0]),
  (VTBL_ENTRY)&_ZN6dd60203fooEv,
  (VTBL_ENTRY)&_ZN6dd60203barEv,
};
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
Class_Descriptor cd_dd6020 = {  "dd6020", // class name
  bases_dd6020, 3,
  &(vtc_dd6020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06020  : dd6020 {
  int e;
  ~ee06020(); // tgen
  ee06020(); // tgen
};
//SIG(1 ee06020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee06020 ::~ee06020(){ note_dtor("ee06020", this);} // tgen
ee06020 ::ee06020(){ note_ctor("ee06020", this);} // tgen

static void Test_ee06020()
{
  extern Class_Descriptor cd_ee06020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06020, buf);
    ee06020 *dp, &lv = *(dp=new (buf) ee06020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(8,4), "ee06020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), 0, "ee06020");
    check_base_class_offset(lv, (cc020*)(dd6020*), 0, "ee06020");
    check_base_class_offset(lv, (dd6020*), 0, "ee06020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee06020.e");
    test_class_info(&lv, &cd_ee06020);
    dp->~ee06020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06020(Test_ee06020, "ee06020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06020C1Ev();
extern void _ZN7ee06020D1Ev();
Name_Map name_map_ee06020[] = {
  NSPAIR(_ZN7ee06020C1Ev),
  NSPAIR(_ZN7ee06020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee06020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06020[];
extern void _ZN6dd60203fooEv();
extern void _ZN6dd60203barEv();
static  VTBL_ENTRY vtc_ee06020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee06020[0]),
  (VTBL_ENTRY)&_ZN6dd60203fooEv,
  (VTBL_ENTRY)&_ZN6dd60203barEv,
};
extern VTBL_ENTRY _ZTI7ee06020[];
extern  VTBL_ENTRY _ZTV7ee06020[];
Class_Descriptor cd_ee06020 = {  "ee06020", // class name
  bases_ee06020, 4,
  &(vtc_ee06020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16020  : virtual dd6020 {
  int e;
  ~ee16020(); // tgen
  ee16020(); // tgen
};
//SIG(1 ee16020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee16020 ::~ee16020(){ note_dtor("ee16020", this);} // tgen
ee16020 ::ee16020(){ note_ctor("ee16020", this);} // tgen

static void Test_ee16020()
{
  extern Class_Descriptor cd_ee16020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16020, buf);
    ee16020 *dp, &lv = *(dp=new (buf) ee16020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(24,12), "ee16020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), ABISELECT(16,8), "ee16020");
    check_base_class_offset(lv, (cc020*)(dd6020*), ABISELECT(16,8), "ee16020");
    check_base_class_offset(lv, (dd6020*), ABISELECT(16,8), "ee16020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16020.e");
    test_class_info(&lv, &cd_ee16020);
    dp->~ee16020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16020(Test_ee16020, "ee16020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16020C1Ev();
extern void _ZN7ee16020D1Ev();
Name_Map name_map_ee16020[] = {
  NSPAIR(_ZN7ee16020C1Ev),
  NSPAIR(_ZN7ee16020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee16020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16020[];
extern void _ZN6dd60203fooEv();
extern void _ZN6dd60203barEv();
static  VTBL_ENTRY vtc_ee16020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16020[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16020[0]),
  (VTBL_ENTRY)&_ZN6dd60203fooEv,
  (VTBL_ENTRY)&_ZN6dd60203barEv,
};
extern VTBL_ENTRY _ZTV7ee16020[];
static  VTT_ENTRY vtt_ee16020[] = {
  {&(_ZTV7ee16020[3]),  3,9},
  {&(_ZTV7ee16020[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee16020[];
extern  VTBL_ENTRY _ZTV7ee16020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16020[];
Class_Descriptor cd_ee16020 = {  "ee16020", // class name
  bases_ee16020, 4,
  &(vtc_ee16020[0]), // expected_vtbl_contents
  &(vtt_ee16020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26020  : dd6020 {
  int e;
  virtual void  foo(); // _ZN7ee260203fooEv
  ~ee26020(); // tgen
  ee26020(); // tgen
};
//SIG(1 ee26020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26020 ::foo(){vfunc_called(this, "_ZN7ee260203fooEv");}
ee26020 ::~ee26020(){ note_dtor("ee26020", this);} // tgen
ee26020 ::ee26020(){ note_ctor("ee26020", this);} // tgen

static void Test_ee26020()
{
  extern Class_Descriptor cd_ee26020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26020, buf);
    ee26020 *dp, &lv = *(dp=new (buf) ee26020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(8,4), "ee26020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), 0, "ee26020");
    check_base_class_offset(lv, (cc020*)(dd6020*), 0, "ee26020");
    check_base_class_offset(lv, (dd6020*), 0, "ee26020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee26020.e");
    test_class_info(&lv, &cd_ee26020);
    dp->~ee26020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26020(Test_ee26020, "ee26020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26020C1Ev();
extern void _ZN7ee26020D1Ev();
Name_Map name_map_ee26020[] = {
  NSPAIR(_ZN7ee26020C1Ev),
  NSPAIR(_ZN7ee26020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee26020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26020[];
extern void _ZN7ee260203fooEv();
extern void _ZN6dd60203barEv();
static  VTBL_ENTRY vtc_ee26020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee26020[0]),
  (VTBL_ENTRY)&_ZN7ee260203fooEv,
  (VTBL_ENTRY)&_ZN6dd60203barEv,
};
extern VTBL_ENTRY _ZTI7ee26020[];
extern  VTBL_ENTRY _ZTV7ee26020[];
Class_Descriptor cd_ee26020 = {  "ee26020", // class name
  bases_ee26020, 4,
  &(vtc_ee26020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36020  : virtual dd6020 {
  int e;
  virtual void  foo(); // _ZN7ee360203fooEv
  ~ee36020(); // tgen
  ee36020(); // tgen
};
//SIG(1 ee36020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36020 ::foo(){vfunc_called(this, "_ZN7ee360203fooEv");}
ee36020 ::~ee36020(){ note_dtor("ee36020", this);} // tgen
ee36020 ::ee36020(){ note_ctor("ee36020", this);} // tgen

static void Test_ee36020()
{
  extern Class_Descriptor cd_ee36020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36020, buf);
    ee36020 *dp, &lv = *(dp=new (buf) ee36020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(24,12), "ee36020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), ABISELECT(16,8), "ee36020");
    check_base_class_offset(lv, (cc020*)(dd6020*), ABISELECT(16,8), "ee36020");
    check_base_class_offset(lv, (dd6020*), ABISELECT(16,8), "ee36020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36020.e");
    test_class_info(&lv, &cd_ee36020);
    dp->~ee36020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36020(Test_ee36020, "ee36020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36020C1Ev();
extern void _ZN7ee36020D1Ev();
Name_Map name_map_ee36020[] = {
  NSPAIR(_ZN7ee36020C1Ev),
  NSPAIR(_ZN7ee36020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee36020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36020[];
extern void _ZN7ee360203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee360203fooEv,_ZTv0_n12_N7ee360203fooEv)();
extern void ABISELECT(_ZThn16_N7ee360203fooEv,_ZThn8_N7ee360203fooEv)() __attribute__((weak));
extern void _ZN6dd60203barEv();
static  VTBL_ENTRY vtc_ee36020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36020[0]),
  (VTBL_ENTRY)&_ZN7ee360203fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee360203fooEv,_ZTv0_n12_N7ee360203fooEv),
  (VTBL_ENTRY)&_ZN6dd60203barEv,
};
extern VTBL_ENTRY _ZTV7ee36020[];
static  VTT_ENTRY vtt_ee36020[] = {
  {&(_ZTV7ee36020[3]),  3,10},
  {&(_ZTV7ee36020[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee36020[];
extern  VTBL_ENTRY _ZTV7ee36020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36020[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee360203fooEv,_ZTv0_n12_N7ee360203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360203fooEv,_ZThn8_N7ee360203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36020 = {  "ee36020", // class name
  bases_ee36020, 4,
  &(vtc_ee36020[0]), // expected_vtbl_contents
  &(vtt_ee36020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36020),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46020  : dd6020 {
  int e;
  virtual void  bar(); // _ZN7ee460203barEv
  ~ee46020(); // tgen
  ee46020(); // tgen
};
//SIG(1 ee46020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46020 ::bar(){vfunc_called(this, "_ZN7ee460203barEv");}
ee46020 ::~ee46020(){ note_dtor("ee46020", this);} // tgen
ee46020 ::ee46020(){ note_ctor("ee46020", this);} // tgen

static void Test_ee46020()
{
  extern Class_Descriptor cd_ee46020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46020, buf);
    ee46020 *dp, &lv = *(dp=new (buf) ee46020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(8,4), "ee46020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), 0, "ee46020");
    check_base_class_offset(lv, (cc020*)(dd6020*), 0, "ee46020");
    check_base_class_offset(lv, (dd6020*), 0, "ee46020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee46020.e");
    test_class_info(&lv, &cd_ee46020);
    dp->~ee46020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46020(Test_ee46020, "ee46020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46020C1Ev();
extern void _ZN7ee46020D1Ev();
Name_Map name_map_ee46020[] = {
  NSPAIR(_ZN7ee46020C1Ev),
  NSPAIR(_ZN7ee46020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee46020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46020[];
extern void _ZN6dd60203fooEv();
extern void _ZN7ee460203barEv();
static  VTBL_ENTRY vtc_ee46020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee46020[0]),
  (VTBL_ENTRY)&_ZN6dd60203fooEv,
  (VTBL_ENTRY)&_ZN7ee460203barEv,
};
extern VTBL_ENTRY _ZTI7ee46020[];
extern  VTBL_ENTRY _ZTV7ee46020[];
Class_Descriptor cd_ee46020 = {  "ee46020", // class name
  bases_ee46020, 4,
  &(vtc_ee46020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56020  : virtual dd6020 {
  int e;
  virtual void  bar(); // _ZN7ee560203barEv
  ~ee56020(); // tgen
  ee56020(); // tgen
};
//SIG(1 ee56020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56020 ::bar(){vfunc_called(this, "_ZN7ee560203barEv");}
ee56020 ::~ee56020(){ note_dtor("ee56020", this);} // tgen
ee56020 ::ee56020(){ note_ctor("ee56020", this);} // tgen

static void Test_ee56020()
{
  extern Class_Descriptor cd_ee56020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56020, buf);
    ee56020 *dp, &lv = *(dp=new (buf) ee56020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(24,12), "ee56020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), ABISELECT(16,8), "ee56020");
    check_base_class_offset(lv, (cc020*)(dd6020*), ABISELECT(16,8), "ee56020");
    check_base_class_offset(lv, (dd6020*), ABISELECT(16,8), "ee56020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56020.e");
    test_class_info(&lv, &cd_ee56020);
    dp->~ee56020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56020(Test_ee56020, "ee56020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56020C1Ev();
extern void _ZN7ee56020D1Ev();
Name_Map name_map_ee56020[] = {
  NSPAIR(_ZN7ee56020C1Ev),
  NSPAIR(_ZN7ee56020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee56020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56020[];
extern void _ZN7ee560203barEv();
extern void _ZN6dd60203fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee560203barEv,_ZTv0_n16_N7ee560203barEv)();
extern void ABISELECT(_ZThn16_N7ee560203barEv,_ZThn8_N7ee560203barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56020[0]),
  (VTBL_ENTRY)&_ZN7ee560203barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56020[0]),
  (VTBL_ENTRY)&_ZN6dd60203fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee560203barEv,_ZTv0_n16_N7ee560203barEv),
};
extern VTBL_ENTRY _ZTV7ee56020[];
static  VTT_ENTRY vtt_ee56020[] = {
  {&(_ZTV7ee56020[3]),  3,10},
  {&(_ZTV7ee56020[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee56020[];
extern  VTBL_ENTRY _ZTV7ee56020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56020[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee560203barEv,_ZTv0_n16_N7ee560203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560203barEv,_ZThn8_N7ee560203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56020 = {  "ee56020", // class name
  bases_ee56020, 4,
  &(vtc_ee56020[0]), // expected_vtbl_contents
  &(vtt_ee56020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56020),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66020  : dd6020 {
  int e;
  virtual void  foo(); // _ZN7ee660203fooEv
  virtual void  bar(); // _ZN7ee660203barEv
  ~ee66020(); // tgen
  ee66020(); // tgen
};
//SIG(1 ee66020) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66020 ::foo(){vfunc_called(this, "_ZN7ee660203fooEv");}
void  ee66020 ::bar(){vfunc_called(this, "_ZN7ee660203barEv");}
ee66020 ::~ee66020(){ note_dtor("ee66020", this);} // tgen
ee66020 ::ee66020(){ note_ctor("ee66020", this);} // tgen

static void Test_ee66020()
{
  extern Class_Descriptor cd_ee66020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66020, buf);
    ee66020 *dp, &lv = *(dp=new (buf) ee66020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(8,4), "ee66020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), 0, "ee66020");
    check_base_class_offset(lv, (cc020*)(dd6020*), 0, "ee66020");
    check_base_class_offset(lv, (dd6020*), 0, "ee66020");
    check_field_offset(lv, e, ABISELECT(24,20), "ee66020.e");
    test_class_info(&lv, &cd_ee66020);
    dp->~ee66020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66020(Test_ee66020, "ee66020", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66020C1Ev();
extern void _ZN7ee66020D1Ev();
Name_Map name_map_ee66020[] = {
  NSPAIR(_ZN7ee66020C1Ev),
  NSPAIR(_ZN7ee66020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee66020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66020[];
extern void _ZN7ee660203fooEv();
extern void _ZN7ee660203barEv();
static  VTBL_ENTRY vtc_ee66020[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee66020[0]),
  (VTBL_ENTRY)&_ZN7ee660203fooEv,
  (VTBL_ENTRY)&_ZN7ee660203barEv,
};
extern VTBL_ENTRY _ZTI7ee66020[];
extern  VTBL_ENTRY _ZTV7ee66020[];
Class_Descriptor cd_ee66020 = {  "ee66020", // class name
  bases_ee66020, 4,
  &(vtc_ee66020[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66020),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76020  : virtual dd6020 {
  int e;
  virtual void  foo(); // _ZN7ee760203fooEv
  virtual void  bar(); // _ZN7ee760203barEv
  ~ee76020(); // tgen
  ee76020(); // tgen
};
//SIG(1 ee76020) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76020 ::foo(){vfunc_called(this, "_ZN7ee760203fooEv");}
void  ee76020 ::bar(){vfunc_called(this, "_ZN7ee760203barEv");}
ee76020 ::~ee76020(){ note_dtor("ee76020", this);} // tgen
ee76020 ::ee76020(){ note_ctor("ee76020", this);} // tgen

static void Test_ee76020()
{
  extern Class_Descriptor cd_ee76020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76020, buf);
    ee76020 *dp, &lv = *(dp=new (buf) ee76020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*)(dd6020*), ABISELECT(24,12), "ee76020");
    check_base_class_offset(lv, (bb20*)(cc020*)(dd6020*), ABISELECT(16,8), "ee76020");
    check_base_class_offset(lv, (cc020*)(dd6020*), ABISELECT(16,8), "ee76020");
    check_base_class_offset(lv, (dd6020*), ABISELECT(16,8), "ee76020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76020.e");
    test_class_info(&lv, &cd_ee76020);
    dp->~ee76020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76020(Test_ee76020, "ee76020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76020C1Ev();
extern void _ZN7ee76020D1Ev();
Name_Map name_map_ee76020[] = {
  NSPAIR(_ZN7ee76020C1Ev),
  NSPAIR(_ZN7ee76020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd6020;
extern VTBL_ENTRY _ZTI6dd6020[];
extern  VTBL_ENTRY _ZTV6dd6020[];
static Base_Class bases_ee76020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76020[];
extern void _ZN7ee760203fooEv();
extern void _ZN7ee760203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee760203fooEv,_ZTv0_n12_N7ee760203fooEv)();
extern void ABISELECT(_ZThn16_N7ee760203fooEv,_ZThn8_N7ee760203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee760203barEv,_ZTv0_n16_N7ee760203barEv)();
extern void ABISELECT(_ZThn16_N7ee760203barEv,_ZThn8_N7ee760203barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76020[0]),
  (VTBL_ENTRY)&_ZN7ee760203fooEv,
  (VTBL_ENTRY)&_ZN7ee760203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee760203fooEv,_ZTv0_n12_N7ee760203fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760203barEv,_ZTv0_n16_N7ee760203barEv),
};
extern VTBL_ENTRY _ZTV7ee76020[];
static  VTT_ENTRY vtt_ee76020[] = {
  {&(_ZTV7ee76020[3]),  3,11},
  {&(_ZTV7ee76020[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee76020[];
extern  VTBL_ENTRY _ZTV7ee76020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76020[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760203barEv,_ZTv0_n16_N7ee760203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760203barEv,_ZThn8_N7ee760203barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee760203fooEv,_ZTv0_n12_N7ee760203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760203fooEv,_ZThn8_N7ee760203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76020 = {  "ee76020", // class name
  bases_ee76020, 4,
  &(vtc_ee76020[0]), // expected_vtbl_contents
  &(vtt_ee76020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76020),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76020),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7020  : virtual cc020 {
  int d;
  virtual void  bar(); // _ZN6dd70203barEv
  virtual void  foo(); // _ZN6dd70203fooEv
  ~dd7020(); // tgen
  dd7020(); // tgen
};
//SIG(-1 dd7020) C1{ VBC2{ BC3{ BC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd7020 ::bar(){vfunc_called(this, "_ZN6dd70203barEv");}
void  dd7020 ::foo(){vfunc_called(this, "_ZN6dd70203fooEv");}
dd7020 ::~dd7020(){ note_dtor("dd7020", this);} // tgen
dd7020 ::dd7020(){ note_ctor("dd7020", this);} // tgen

static void Test_dd7020()
{
  extern Class_Descriptor cd_dd7020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7020, buf);
    dd7020 *dp, &lv = *(dp=new (buf) dd7020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,12), "dd7020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,8), "dd7020");
    check_base_class_offset(lv, (cc020*), ABISELECT(16,8), "dd7020");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7020.d");
    test_class_info(&lv, &cd_dd7020);
    dp->~dd7020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7020(Test_dd7020, "dd7020", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7020C1Ev();
extern void _ZN6dd7020D1Ev();
Name_Map name_map_dd7020[] = {
  NSPAIR(_ZN6dd7020C1Ev),
  NSPAIR(_ZN6dd7020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
static Base_Class bases_dd7020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
extern VTBL_ENTRY _ZTV6dd7020[];
static  VTT_ENTRY vtt_dd7020[] = {
  {&(_ZTV6dd7020[3]),  3,9},
  {&(_ZTV6dd7020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7020 = {  "dd7020", // class name
  bases_dd7020, 3,
  &(vtc_dd7020[0]), // expected_vtbl_contents
  &(vtt_dd7020[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7020),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07020  : dd7020 {
  int e;
  ~ee07020(); // tgen
  ee07020(); // tgen
};
//SIG(1 ee07020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee07020 ::~ee07020(){ note_dtor("ee07020", this);} // tgen
ee07020 ::ee07020(){ note_ctor("ee07020", this);} // tgen

static void Test_ee07020()
{
  extern Class_Descriptor cd_ee07020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07020, buf);
    ee07020 *dp, &lv = *(dp=new (buf) ee07020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee07020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee07020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(16,12), "ee07020");
    check_base_class_offset(lv, (dd7020*), 0, "ee07020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07020.e");
    test_class_info(&lv, &cd_ee07020);
    dp->~ee07020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07020(Test_ee07020, "ee07020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07020C1Ev();
extern void _ZN7ee07020D1Ev();
Name_Map name_map_ee07020[] = {
  NSPAIR(_ZN7ee07020C1Ev),
  NSPAIR(_ZN7ee07020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee07020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
extern VTBL_ENTRY _ZTV7ee07020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee07020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee07020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee07020[] = {
  {&(_ZTV7ee07020[3]),  3,9},
  {&(_tg__ZTV6dd7020__7ee07020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee07020[3]),  3,4},
  {&(_ZTV7ee07020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee07020[];
extern  VTBL_ENTRY _ZTV7ee07020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07020[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07020 = {  "ee07020", // class name
  bases_ee07020, 4,
  &(vtc_ee07020[0]), // expected_vtbl_contents
  &(vtt_ee07020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17020  : virtual dd7020 {
  int e;
  ~ee17020(); // tgen
  ee17020(); // tgen
};
//SIG(1 ee17020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee17020 ::~ee17020(){ note_dtor("ee17020", this);} // tgen
ee17020 ::ee17020(){ note_ctor("ee17020", this);} // tgen

static void Test_ee17020()
{
  extern Class_Descriptor cd_ee17020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17020, buf);
    ee17020 *dp, &lv = *(dp=new (buf) ee17020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee17020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee17020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(32,16), "ee17020");
    check_base_class_offset(lv, (dd7020*), ABISELECT(16,8), "ee17020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17020.e");
    test_class_info(&lv, &cd_ee17020);
    dp->~ee17020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17020(Test_ee17020, "ee17020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17020C1Ev();
extern void _ZN7ee17020D1Ev();
Name_Map name_map_ee17020[] = {
  NSPAIR(_ZN7ee17020C1Ev),
  NSPAIR(_ZN7ee17020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee17020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17020[0]),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
extern VTBL_ENTRY _ZTV7ee17020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee17020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee17020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee17020[] = {
  {&(_ZTV7ee17020[4]),  4,15},
  {&(_ZTV7ee17020[9]),  9,15},
  {&(_ZTV7ee17020[14]),  14,15},
  {&(_tg__ZTV6dd7020__7ee17020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee17020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17020[];
extern  VTBL_ENTRY _ZTV7ee17020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17020[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17020 = {  "ee17020", // class name
  bases_ee17020, 4,
  &(vtc_ee17020[0]), // expected_vtbl_contents
  &(vtt_ee17020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17020),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27020  : dd7020 {
  int e;
  virtual void  foo(); // _ZN7ee270203fooEv
  ~ee27020(); // tgen
  ee27020(); // tgen
};
//SIG(1 ee27020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27020 ::foo(){vfunc_called(this, "_ZN7ee270203fooEv");}
ee27020 ::~ee27020(){ note_dtor("ee27020", this);} // tgen
ee27020 ::ee27020(){ note_ctor("ee27020", this);} // tgen

static void Test_ee27020()
{
  extern Class_Descriptor cd_ee27020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27020, buf);
    ee27020 *dp, &lv = *(dp=new (buf) ee27020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee27020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee27020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(16,12), "ee27020");
    check_base_class_offset(lv, (dd7020*), 0, "ee27020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27020.e");
    test_class_info(&lv, &cd_ee27020);
    dp->~ee27020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27020(Test_ee27020, "ee27020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27020C1Ev();
extern void _ZN7ee27020D1Ev();
Name_Map name_map_ee27020[] = {
  NSPAIR(_ZN7ee27020C1Ev),
  NSPAIR(_ZN7ee27020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee27020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27020[];
extern void _ZN6dd70203barEv();
extern void _ZN7ee270203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee270203fooEv,_ZTv0_n12_N7ee270203fooEv)();
extern void ABISELECT(_ZThn16_N7ee270203fooEv,_ZThn12_N7ee270203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN7ee270203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee270203fooEv,_ZTv0_n12_N7ee270203fooEv),
};
extern VTBL_ENTRY _ZTV7ee27020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee27020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee27020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee27020[] = {
  {&(_ZTV7ee27020[3]),  3,9},
  {&(_tg__ZTV6dd7020__7ee27020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee27020[3]),  3,4},
  {&(_ZTV7ee27020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee27020[];
extern  VTBL_ENTRY _ZTV7ee27020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27020[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee270203fooEv,_ZTv0_n12_N7ee270203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee270203fooEv,_ZThn12_N7ee270203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27020 = {  "ee27020", // class name
  bases_ee27020, 4,
  &(vtc_ee27020[0]), // expected_vtbl_contents
  &(vtt_ee27020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37020  : virtual dd7020 {
  int e;
  virtual void  foo(); // _ZN7ee370203fooEv
  ~ee37020(); // tgen
  ee37020(); // tgen
};
//SIG(1 ee37020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37020 ::foo(){vfunc_called(this, "_ZN7ee370203fooEv");}
ee37020 ::~ee37020(){ note_dtor("ee37020", this);} // tgen
ee37020 ::ee37020(){ note_ctor("ee37020", this);} // tgen

static void Test_ee37020()
{
  extern Class_Descriptor cd_ee37020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37020, buf);
    ee37020 *dp, &lv = *(dp=new (buf) ee37020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee37020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee37020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(32,16), "ee37020");
    check_base_class_offset(lv, (dd7020*), ABISELECT(16,8), "ee37020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37020.e");
    test_class_info(&lv, &cd_ee37020);
    dp->~ee37020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37020(Test_ee37020, "ee37020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37020C1Ev();
extern void _ZN7ee37020D1Ev();
Name_Map name_map_ee37020[] = {
  NSPAIR(_ZN7ee37020C1Ev),
  NSPAIR(_ZN7ee37020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee37020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37020[];
extern void _ZN7ee370203fooEv();
extern void _ZN6dd70203barEv();
extern void ABISELECT(_ZTv0_n40_N7ee370203fooEv,_ZTv0_n20_N7ee370203fooEv)();
extern void ABISELECT(_ZThn16_N7ee370203fooEv,_ZThn8_N7ee370203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee370203fooEv,_ZTv0_n12_N7ee370203fooEv)();
extern void ABISELECT(_ZThn32_N7ee370203fooEv,_ZThn16_N7ee370203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37020[0]),
  (VTBL_ENTRY)&_ZN7ee370203fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee370203fooEv,_ZTv0_n20_N7ee370203fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee370203fooEv,_ZTv0_n12_N7ee370203fooEv),
};
extern VTBL_ENTRY _ZTV7ee37020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee37020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee37020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee37020[] = {
  {&(_ZTV7ee37020[4]),  4,16},
  {&(_ZTV7ee37020[10]),  10,16},
  {&(_ZTV7ee37020[15]),  15,16},
  {&(_tg__ZTV6dd7020__7ee37020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee37020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37020[];
extern  VTBL_ENTRY _ZTV7ee37020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37020[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee370203fooEv,_ZTv0_n12_N7ee370203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee370203fooEv,_ZThn16_N7ee370203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee370203fooEv,_ZTv0_n20_N7ee370203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370203fooEv,_ZThn8_N7ee370203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37020 = {  "ee37020", // class name
  bases_ee37020, 4,
  &(vtc_ee37020[0]), // expected_vtbl_contents
  &(vtt_ee37020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37020),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47020  : dd7020 {
  int e;
  virtual void  bar(); // _ZN7ee470203barEv
  ~ee47020(); // tgen
  ee47020(); // tgen
};
//SIG(1 ee47020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47020 ::bar(){vfunc_called(this, "_ZN7ee470203barEv");}
ee47020 ::~ee47020(){ note_dtor("ee47020", this);} // tgen
ee47020 ::ee47020(){ note_ctor("ee47020", this);} // tgen

static void Test_ee47020()
{
  extern Class_Descriptor cd_ee47020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47020, buf);
    ee47020 *dp, &lv = *(dp=new (buf) ee47020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee47020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee47020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(16,12), "ee47020");
    check_base_class_offset(lv, (dd7020*), 0, "ee47020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47020.e");
    test_class_info(&lv, &cd_ee47020);
    dp->~ee47020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47020(Test_ee47020, "ee47020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47020C1Ev();
extern void _ZN7ee47020D1Ev();
Name_Map name_map_ee47020[] = {
  NSPAIR(_ZN7ee47020C1Ev),
  NSPAIR(_ZN7ee47020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee47020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47020[];
extern void _ZN7ee470203barEv();
extern void _ZN6dd70203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47020[0]),
  (VTBL_ENTRY)&_ZN7ee470203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
extern VTBL_ENTRY _ZTV7ee47020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee47020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee47020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee47020[] = {
  {&(_ZTV7ee47020[3]),  3,9},
  {&(_tg__ZTV6dd7020__7ee47020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee47020[3]),  3,4},
  {&(_ZTV7ee47020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee47020[];
extern  VTBL_ENTRY _ZTV7ee47020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47020[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47020 = {  "ee47020", // class name
  bases_ee47020, 4,
  &(vtc_ee47020[0]), // expected_vtbl_contents
  &(vtt_ee47020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57020  : virtual dd7020 {
  int e;
  virtual void  bar(); // _ZN7ee570203barEv
  ~ee57020(); // tgen
  ee57020(); // tgen
};
//SIG(1 ee57020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57020 ::bar(){vfunc_called(this, "_ZN7ee570203barEv");}
ee57020 ::~ee57020(){ note_dtor("ee57020", this);} // tgen
ee57020 ::ee57020(){ note_ctor("ee57020", this);} // tgen

static void Test_ee57020()
{
  extern Class_Descriptor cd_ee57020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57020, buf);
    ee57020 *dp, &lv = *(dp=new (buf) ee57020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee57020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee57020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(32,16), "ee57020");
    check_base_class_offset(lv, (dd7020*), ABISELECT(16,8), "ee57020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57020.e");
    test_class_info(&lv, &cd_ee57020);
    dp->~ee57020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57020(Test_ee57020, "ee57020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57020C1Ev();
extern void _ZN7ee57020D1Ev();
Name_Map name_map_ee57020[] = {
  NSPAIR(_ZN7ee57020C1Ev),
  NSPAIR(_ZN7ee57020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee57020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57020[];
extern void _ZN7ee570203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee570203barEv,_ZTv0_n16_N7ee570203barEv)();
extern void ABISELECT(_ZThn16_N7ee570203barEv,_ZThn8_N7ee570203barEv)() __attribute__((weak));
extern void _ZN6dd70203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57020[0]),
  (VTBL_ENTRY)&_ZN7ee570203barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee570203barEv,_ZTv0_n16_N7ee570203barEv),
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
extern VTBL_ENTRY _ZTV7ee57020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee57020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee57020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee57020[] = {
  {&(_ZTV7ee57020[4]),  4,16},
  {&(_ZTV7ee57020[10]),  10,16},
  {&(_ZTV7ee57020[15]),  15,16},
  {&(_tg__ZTV6dd7020__7ee57020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee57020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57020[];
extern  VTBL_ENTRY _ZTV7ee57020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57020[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee570203barEv,_ZTv0_n16_N7ee570203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570203barEv,_ZThn8_N7ee570203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57020 = {  "ee57020", // class name
  bases_ee57020, 4,
  &(vtc_ee57020[0]), // expected_vtbl_contents
  &(vtt_ee57020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57020),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67020  : dd7020 {
  int e;
  virtual void  foo(); // _ZN7ee670203fooEv
  virtual void  bar(); // _ZN7ee670203barEv
  ~ee67020(); // tgen
  ee67020(); // tgen
};
//SIG(1 ee67020) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67020 ::foo(){vfunc_called(this, "_ZN7ee670203fooEv");}
void  ee67020 ::bar(){vfunc_called(this, "_ZN7ee670203barEv");}
ee67020 ::~ee67020(){ note_dtor("ee67020", this);} // tgen
ee67020 ::ee67020(){ note_ctor("ee67020", this);} // tgen

static void Test_ee67020()
{
  extern Class_Descriptor cd_ee67020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67020, buf);
    ee67020 *dp, &lv = *(dp=new (buf) ee67020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(24,16), "ee67020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(16,12), "ee67020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(16,12), "ee67020");
    check_base_class_offset(lv, (dd7020*), 0, "ee67020");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67020.e");
    test_class_info(&lv, &cd_ee67020);
    dp->~ee67020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67020(Test_ee67020, "ee67020", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67020C1Ev();
extern void _ZN7ee67020D1Ev();
Name_Map name_map_ee67020[] = {
  NSPAIR(_ZN7ee67020C1Ev),
  NSPAIR(_ZN7ee67020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee67020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67020[];
extern void _ZN7ee670203barEv();
extern void _ZN7ee670203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee670203fooEv,_ZTv0_n12_N7ee670203fooEv)();
extern void ABISELECT(_ZThn16_N7ee670203fooEv,_ZThn12_N7ee670203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67020[0]),
  (VTBL_ENTRY)&_ZN7ee670203barEv,
  (VTBL_ENTRY)&_ZN7ee670203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee670203fooEv,_ZTv0_n12_N7ee670203fooEv),
};
extern VTBL_ENTRY _ZTV7ee67020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee67020[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee67020[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee67020[] = {
  {&(_ZTV7ee67020[3]),  3,9},
  {&(_tg__ZTV6dd7020__7ee67020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee67020[3]),  3,4},
  {&(_ZTV7ee67020[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee67020[];
extern  VTBL_ENTRY _ZTV7ee67020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67020[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn12_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee670203fooEv,_ZTv0_n12_N7ee670203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee670203fooEv,_ZThn12_N7ee670203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67020 = {  "ee67020", // class name
  bases_ee67020, 4,
  &(vtc_ee67020[0]), // expected_vtbl_contents
  &(vtt_ee67020[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67020),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67020),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67020),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77020  : virtual dd7020 {
  int e;
  virtual void  foo(); // _ZN7ee770203fooEv
  virtual void  bar(); // _ZN7ee770203barEv
  ~ee77020(); // tgen
  ee77020(); // tgen
};
//SIG(1 ee77020) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77020 ::foo(){vfunc_called(this, "_ZN7ee770203fooEv");}
void  ee77020 ::bar(){vfunc_called(this, "_ZN7ee770203barEv");}
ee77020 ::~ee77020(){ note_dtor("ee77020", this);} // tgen
ee77020 ::ee77020(){ note_ctor("ee77020", this);} // tgen

static void Test_ee77020()
{
  extern Class_Descriptor cd_ee77020;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77020, buf);
    ee77020 *dp, &lv = *(dp=new (buf) ee77020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77020)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77020)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc020*), ABISELECT(40,20), "ee77020");
    check_base_class_offset(lv, (bb20*)(cc020*), ABISELECT(32,16), "ee77020");
    check_base_class_offset(lv, (cc020*)(dd7020*), ABISELECT(32,16), "ee77020");
    check_base_class_offset(lv, (dd7020*), ABISELECT(16,8), "ee77020");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77020.e");
    test_class_info(&lv, &cd_ee77020);
    dp->~ee77020();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77020(Test_ee77020, "ee77020", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77020C1Ev();
extern void _ZN7ee77020D1Ev();
Name_Map name_map_ee77020[] = {
  NSPAIR(_ZN7ee77020C1Ev),
  NSPAIR(_ZN7ee77020D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc020;
extern VTBL_ENTRY _ZTI5cc020[];
extern  VTBL_ENTRY _ZTV5cc020[];
extern Class_Descriptor cd_dd7020;
extern VTBL_ENTRY _ZTI6dd7020[];
extern  VTBL_ENTRY _ZTV6dd7020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7020[];
static Base_Class bases_ee77020[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc020,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7020,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77020[];
extern void _ZN7ee770203fooEv();
extern void _ZN7ee770203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee770203barEv,_ZTv0_n16_N7ee770203barEv)();
extern void ABISELECT(_ZThn16_N7ee770203barEv,_ZThn8_N7ee770203barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee770203fooEv,_ZTv0_n20_N7ee770203fooEv)();
extern void ABISELECT(_ZThn16_N7ee770203fooEv,_ZThn8_N7ee770203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee770203fooEv,_ZTv0_n12_N7ee770203fooEv)();
extern void ABISELECT(_ZThn32_N7ee770203fooEv,_ZThn16_N7ee770203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77020[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77020[0]),
  (VTBL_ENTRY)&_ZN7ee770203fooEv,
  (VTBL_ENTRY)&_ZN7ee770203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770203barEv,_ZTv0_n16_N7ee770203barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770203fooEv,_ZTv0_n20_N7ee770203fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee770203fooEv,_ZTv0_n12_N7ee770203fooEv),
};
extern VTBL_ENTRY _ZTV7ee77020[];
extern void _ZN6dd70203barEv();
extern void _ZN6dd70203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7020__7ee77020[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&_ZN6dd70203barEv,
  (VTBL_ENTRY)&_ZN6dd70203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv)();
extern void ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb205cc020__6dd7020__7ee77020[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7020[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv),
};
static  VTT_ENTRY vtt_ee77020[] = {
  {&(_ZTV7ee77020[4]),  4,17},
  {&(_ZTV7ee77020[11]),  11,17},
  {&(_ZTV7ee77020[16]),  16,17},
  {&(_tg__ZTV6dd7020__7ee77020[3]),  3,5},
  {&(_tg__ZTV4bb205cc020__6dd7020__7ee77020[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77020[];
extern  VTBL_ENTRY _ZTV7ee77020[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77020[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd70203fooEv,_ZTv0_n12_N6dd70203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd70203fooEv,_ZThn8_N6dd70203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee770203fooEv,_ZTv0_n12_N7ee770203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee770203fooEv,_ZThn16_N7ee770203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770203fooEv,_ZTv0_n20_N7ee770203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770203fooEv,_ZThn8_N7ee770203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770203barEv,_ZTv0_n16_N7ee770203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770203barEv,_ZThn8_N7ee770203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77020 = {  "ee77020", // class name
  bases_ee77020, 4,
  &(vtc_ee77020[0]), // expected_vtbl_contents
  &(vtt_ee77020[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77020),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77020),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77020),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc120  : virtual bb20 {
  int c;
  ~cc120(); // tgen
  cc120(); // tgen
};
//SIG(-1 cc120) C1{ VBC2{ BC3{ Fi} v1 Fi} Fi}


cc120 ::~cc120(){ note_dtor("cc120", this);} // tgen
cc120 ::cc120(){ note_ctor("cc120", this);} // tgen

static void Test_cc120()
{
  extern Class_Descriptor cd_cc120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_cc120, buf);
    cc120 *dp, &lv = *(dp=new (buf) cc120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(cc120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(24,12), "cc120");
    check_base_class_offset(lv, (bb20*), ABISELECT(16,8), "cc120");
    check_field_offset(lv, c, ABISELECT(8,4), "cc120.c");
    test_class_info(&lv, &cd_cc120);
    dp->~cc120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc120(Test_cc120, "cc120", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN5cc120C1Ev();
extern void _ZN5cc120D1Ev();
Name_Map name_map_cc120[] = {
  NSPAIR(_ZN5cc120C1Ev),
  NSPAIR(_ZN5cc120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
static Base_Class bases_cc120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc120[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_cc120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV5cc120[];
static  VTT_ENTRY vtt_cc120[] = {
  {&(_ZTV5cc120[3]),  3,7},
  {&(_ZTV5cc120[6]),  6,7},
};
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
Class_Descriptor cd_cc120 = {  "cc120", // class name
  bases_cc120, 2,
  &(vtc_cc120[0]), // expected_vtbl_contents
  &(vtt_cc120[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI5cc120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc120),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc120),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0120  : cc120 {
  int d;
  ~dd0120(); // tgen
  dd0120(); // tgen
};
//SIG(-1 dd0120) C1{ BC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd0120 ::~dd0120(){ note_dtor("dd0120", this);} // tgen
dd0120 ::dd0120(){ note_ctor("dd0120", this);} // tgen

static void Test_dd0120()
{
  extern Class_Descriptor cd_dd0120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd0120, buf);
    dd0120 *dp, &lv = *(dp=new (buf) dd0120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd0120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(24,16), "dd0120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(16,12), "dd0120");
    check_base_class_offset(lv, (cc120*), 0, "dd0120");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0120.d");
    test_class_info(&lv, &cd_dd0120);
    dp->~dd0120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0120(Test_dd0120, "dd0120", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd0120C1Ev();
extern void _ZN6dd0120D1Ev();
Name_Map name_map_dd0120[] = {
  NSPAIR(_ZN6dd0120C1Ev),
  NSPAIR(_ZN6dd0120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd0120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0120[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_dd0120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV6dd0120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd0120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd0120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd0120[] = {
  {&(_ZTV6dd0120[3]),  3,7},
  {&(_tg__ZTV5cc120__6dd0120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd0120[3]),  3,4},
  {&(_ZTV6dd0120[6]),  6,7},
};
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
Class_Descriptor cd_dd0120 = {  "dd0120", // class name
  bases_dd0120, 3,
  &(vtc_dd0120[0]), // expected_vtbl_contents
  &(vtt_dd0120[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd0120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0120),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0120),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00120  : dd0120 {
  int e;
  ~ee00120(); // tgen
  ee00120(); // tgen
};
//SIG(1 ee00120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee00120 ::~ee00120(){ note_dtor("ee00120", this);} // tgen
ee00120 ::ee00120(){ note_ctor("ee00120", this);} // tgen

static void Test_ee00120()
{
  extern Class_Descriptor cd_ee00120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee00120, buf);
    ee00120 *dp, &lv = *(dp=new (buf) ee00120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee00120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee00120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(24,16), "ee00120");
    check_base_class_offset(lv, (cc120*)(dd0120*), 0, "ee00120");
    check_base_class_offset(lv, (dd0120*), 0, "ee00120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00120.e");
    test_class_info(&lv, &cd_ee00120);
    dp->~ee00120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00120(Test_ee00120, "ee00120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee00120C1Ev();
extern void _ZN7ee00120D1Ev();
Name_Map name_map_ee00120[] = {
  NSPAIR(_ZN7ee00120C1Ev),
  NSPAIR(_ZN7ee00120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee00120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00120[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee00120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00120[0]),
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee00120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee00120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee00120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee00120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee00120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee00120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee00120[] = {
  {&(_ZTV7ee00120[3]),  3,7},
  {&(_tg__ZTV6dd0120__7ee00120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee00120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee00120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee00120[3]),  3,4},
  {&(_ZTV7ee00120[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee00120[];
extern  VTBL_ENTRY _ZTV7ee00120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00120[];
Class_Descriptor cd_ee00120 = {  "ee00120", // class name
  bases_ee00120, 4,
  &(vtc_ee00120[0]), // expected_vtbl_contents
  &(vtt_ee00120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee00120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00120),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10120  : virtual dd0120 {
  int e;
  ~ee10120(); // tgen
  ee10120(); // tgen
};
//SIG(1 ee10120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee10120 ::~ee10120(){ note_dtor("ee10120", this);} // tgen
ee10120 ::ee10120(){ note_ctor("ee10120", this);} // tgen

static void Test_ee10120()
{
  extern Class_Descriptor cd_ee10120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee10120, buf);
    ee10120 *dp, &lv = *(dp=new (buf) ee10120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee10120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee10120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(32,20), "ee10120");
    check_base_class_offset(lv, (cc120*)(dd0120*), ABISELECT(16,8), "ee10120");
    check_base_class_offset(lv, (dd0120*), ABISELECT(16,8), "ee10120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10120.e");
    test_class_info(&lv, &cd_ee10120);
    dp->~ee10120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10120(Test_ee10120, "ee10120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee10120C1Ev();
extern void _ZN7ee10120D1Ev();
Name_Map name_map_ee10120[] = {
  NSPAIR(_ZN7ee10120C1Ev),
  NSPAIR(_ZN7ee10120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee10120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10120[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee10120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10120[0]),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10120[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee10120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee10120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee10120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee10120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee10120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee10120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee10120[] = {
  {&(_ZTV7ee10120[4]),  4,11},
  {&(_ZTV7ee10120[7]),  7,11},
  {&(_ZTV7ee10120[10]),  10,11},
  {&(_tg__ZTV6dd0120__7ee10120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee10120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee10120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee10120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee10120[];
extern  VTBL_ENTRY _ZTV7ee10120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10120[];
Class_Descriptor cd_ee10120 = {  "ee10120", // class name
  bases_ee10120, 4,
  &(vtc_ee10120[0]), // expected_vtbl_contents
  &(vtt_ee10120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee10120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10120),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20120  : dd0120 {
  int e;
  virtual void  foo(); // _ZN7ee201203fooEv
  ~ee20120(); // tgen
  ee20120(); // tgen
};
//SIG(1 ee20120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee20120 ::foo(){vfunc_called(this, "_ZN7ee201203fooEv");}
ee20120 ::~ee20120(){ note_dtor("ee20120", this);} // tgen
ee20120 ::ee20120(){ note_ctor("ee20120", this);} // tgen

static void Test_ee20120()
{
  extern Class_Descriptor cd_ee20120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee20120, buf);
    ee20120 *dp, &lv = *(dp=new (buf) ee20120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee20120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee20120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(24,16), "ee20120");
    check_base_class_offset(lv, (cc120*)(dd0120*), 0, "ee20120");
    check_base_class_offset(lv, (dd0120*), 0, "ee20120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20120.e");
    test_class_info(&lv, &cd_ee20120);
    dp->~ee20120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20120(Test_ee20120, "ee20120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee20120C1Ev();
extern void _ZN7ee20120D1Ev();
Name_Map name_map_ee20120[] = {
  NSPAIR(_ZN7ee20120C1Ev),
  NSPAIR(_ZN7ee20120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee20120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20120[];
extern void _ZN7ee201203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee201203fooEv,_ZTv0_n12_N7ee201203fooEv)();
extern void ABISELECT(_ZThn24_N7ee201203fooEv,_ZThn16_N7ee201203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee20120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20120[0]),
  (VTBL_ENTRY)&_ZN7ee201203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee20120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee201203fooEv,_ZTv0_n12_N7ee201203fooEv),
};
extern VTBL_ENTRY _ZTV7ee20120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee20120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee20120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee20120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee20120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee20120[] = {
  {&(_ZTV7ee20120[3]),  3,8},
  {&(_tg__ZTV6dd0120__7ee20120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee20120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee20120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee20120[3]),  3,4},
  {&(_ZTV7ee20120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee20120[];
extern  VTBL_ENTRY _ZTV7ee20120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20120[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee201203fooEv,_ZTv0_n12_N7ee201203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee201203fooEv,_ZThn16_N7ee201203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee20120 = {  "ee20120", // class name
  bases_ee20120, 4,
  &(vtc_ee20120[0]), // expected_vtbl_contents
  &(vtt_ee20120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee20120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30120  : virtual dd0120 {
  int e;
  virtual void  foo(); // _ZN7ee301203fooEv
  ~ee30120(); // tgen
  ee30120(); // tgen
};
//SIG(1 ee30120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee30120 ::foo(){vfunc_called(this, "_ZN7ee301203fooEv");}
ee30120 ::~ee30120(){ note_dtor("ee30120", this);} // tgen
ee30120 ::ee30120(){ note_ctor("ee30120", this);} // tgen

static void Test_ee30120()
{
  extern Class_Descriptor cd_ee30120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee30120, buf);
    ee30120 *dp, &lv = *(dp=new (buf) ee30120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee30120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee30120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(32,20), "ee30120");
    check_base_class_offset(lv, (cc120*)(dd0120*), ABISELECT(16,8), "ee30120");
    check_base_class_offset(lv, (dd0120*), ABISELECT(16,8), "ee30120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30120.e");
    test_class_info(&lv, &cd_ee30120);
    dp->~ee30120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30120(Test_ee30120, "ee30120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee30120C1Ev();
extern void _ZN7ee30120D1Ev();
Name_Map name_map_ee30120[] = {
  NSPAIR(_ZN7ee30120C1Ev),
  NSPAIR(_ZN7ee30120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee30120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30120[];
extern void _ZN7ee301203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee301203fooEv,_ZTv0_n12_N7ee301203fooEv)();
extern void ABISELECT(_ZThn32_N7ee301203fooEv,_ZThn20_N7ee301203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30120[0]),
  (VTBL_ENTRY)&_ZN7ee301203fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee30120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee301203fooEv,_ZTv0_n12_N7ee301203fooEv),
};
extern VTBL_ENTRY _ZTV7ee30120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee30120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee30120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee30120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee30120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee30120[] = {
  {&(_ZTV7ee30120[4]),  4,12},
  {&(_ZTV7ee30120[8]),  8,12},
  {&(_ZTV7ee30120[11]),  11,12},
  {&(_tg__ZTV6dd0120__7ee30120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee30120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee30120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee30120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30120[];
extern  VTBL_ENTRY _ZTV7ee30120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30120[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee301203fooEv,_ZTv0_n12_N7ee301203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee301203fooEv,_ZThn20_N7ee301203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30120 = {  "ee30120", // class name
  bases_ee30120, 4,
  &(vtc_ee30120[0]), // expected_vtbl_contents
  &(vtt_ee30120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee30120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40120  : dd0120 {
  int e;
  virtual void  bar(); // _ZN7ee401203barEv
  ~ee40120(); // tgen
  ee40120(); // tgen
};
//SIG(1 ee40120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee40120 ::bar(){vfunc_called(this, "_ZN7ee401203barEv");}
ee40120 ::~ee40120(){ note_dtor("ee40120", this);} // tgen
ee40120 ::ee40120(){ note_ctor("ee40120", this);} // tgen

static void Test_ee40120()
{
  extern Class_Descriptor cd_ee40120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee40120, buf);
    ee40120 *dp, &lv = *(dp=new (buf) ee40120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee40120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee40120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(24,16), "ee40120");
    check_base_class_offset(lv, (cc120*)(dd0120*), 0, "ee40120");
    check_base_class_offset(lv, (dd0120*), 0, "ee40120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40120.e");
    test_class_info(&lv, &cd_ee40120);
    dp->~ee40120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40120(Test_ee40120, "ee40120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee40120C1Ev();
extern void _ZN7ee40120D1Ev();
Name_Map name_map_ee40120[] = {
  NSPAIR(_ZN7ee40120C1Ev),
  NSPAIR(_ZN7ee40120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee40120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40120[];
extern void _ZN7ee401203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee40120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40120[0]),
  (VTBL_ENTRY)&_ZN7ee401203barEv,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee40120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee40120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee40120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee40120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee40120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee40120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee40120[] = {
  {&(_ZTV7ee40120[3]),  3,8},
  {&(_tg__ZTV6dd0120__7ee40120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee40120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee40120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee40120[3]),  3,4},
  {&(_ZTV7ee40120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee40120[];
extern  VTBL_ENTRY _ZTV7ee40120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40120[];
Class_Descriptor cd_ee40120 = {  "ee40120", // class name
  bases_ee40120, 4,
  &(vtc_ee40120[0]), // expected_vtbl_contents
  &(vtt_ee40120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee40120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50120  : virtual dd0120 {
  int e;
  virtual void  bar(); // _ZN7ee501203barEv
  ~ee50120(); // tgen
  ee50120(); // tgen
};
//SIG(1 ee50120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee50120 ::bar(){vfunc_called(this, "_ZN7ee501203barEv");}
ee50120 ::~ee50120(){ note_dtor("ee50120", this);} // tgen
ee50120 ::ee50120(){ note_ctor("ee50120", this);} // tgen

static void Test_ee50120()
{
  extern Class_Descriptor cd_ee50120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee50120, buf);
    ee50120 *dp, &lv = *(dp=new (buf) ee50120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee50120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee50120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(32,20), "ee50120");
    check_base_class_offset(lv, (cc120*)(dd0120*), ABISELECT(16,8), "ee50120");
    check_base_class_offset(lv, (dd0120*), ABISELECT(16,8), "ee50120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50120.e");
    test_class_info(&lv, &cd_ee50120);
    dp->~ee50120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50120(Test_ee50120, "ee50120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee50120C1Ev();
extern void _ZN7ee50120D1Ev();
Name_Map name_map_ee50120[] = {
  NSPAIR(_ZN7ee50120C1Ev),
  NSPAIR(_ZN7ee50120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee50120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50120[];
extern void _ZN7ee501203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee50120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50120[0]),
  (VTBL_ENTRY)&_ZN7ee501203barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50120[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee50120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee50120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee50120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee50120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee50120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee50120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee50120[] = {
  {&(_ZTV7ee50120[4]),  4,12},
  {&(_ZTV7ee50120[8]),  8,12},
  {&(_ZTV7ee50120[11]),  11,12},
  {&(_tg__ZTV6dd0120__7ee50120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee50120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee50120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee50120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50120[];
extern  VTBL_ENTRY _ZTV7ee50120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50120[];
Class_Descriptor cd_ee50120 = {  "ee50120", // class name
  bases_ee50120, 4,
  &(vtc_ee50120[0]), // expected_vtbl_contents
  &(vtt_ee50120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee50120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60120  : dd0120 {
  int e;
  virtual void  foo(); // _ZN7ee601203fooEv
  virtual void  bar(); // _ZN7ee601203barEv
  ~ee60120(); // tgen
  ee60120(); // tgen
};
//SIG(1 ee60120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee60120 ::foo(){vfunc_called(this, "_ZN7ee601203fooEv");}
void  ee60120 ::bar(){vfunc_called(this, "_ZN7ee601203barEv");}
ee60120 ::~ee60120(){ note_dtor("ee60120", this);} // tgen
ee60120 ::ee60120(){ note_ctor("ee60120", this);} // tgen

static void Test_ee60120()
{
  extern Class_Descriptor cd_ee60120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee60120, buf);
    ee60120 *dp, &lv = *(dp=new (buf) ee60120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee60120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee60120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(24,16), "ee60120");
    check_base_class_offset(lv, (cc120*)(dd0120*), 0, "ee60120");
    check_base_class_offset(lv, (dd0120*), 0, "ee60120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60120.e");
    test_class_info(&lv, &cd_ee60120);
    dp->~ee60120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60120(Test_ee60120, "ee60120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee60120C1Ev();
extern void _ZN7ee60120D1Ev();
Name_Map name_map_ee60120[] = {
  NSPAIR(_ZN7ee60120C1Ev),
  NSPAIR(_ZN7ee60120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee60120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60120[];
extern void _ZN7ee601203fooEv();
extern void _ZN7ee601203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee601203fooEv,_ZTv0_n12_N7ee601203fooEv)();
extern void ABISELECT(_ZThn24_N7ee601203fooEv,_ZThn16_N7ee601203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee60120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60120[0]),
  (VTBL_ENTRY)&_ZN7ee601203fooEv,
  (VTBL_ENTRY)&_ZN7ee601203barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee60120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee601203fooEv,_ZTv0_n12_N7ee601203fooEv),
};
extern VTBL_ENTRY _ZTV7ee60120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee60120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee60120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee60120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee60120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee60120[] = {
  {&(_ZTV7ee60120[3]),  3,9},
  {&(_tg__ZTV6dd0120__7ee60120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee60120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee60120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee60120[3]),  3,4},
  {&(_ZTV7ee60120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee60120[];
extern  VTBL_ENTRY _ZTV7ee60120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60120[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee601203fooEv,_ZTv0_n12_N7ee601203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee601203fooEv,_ZThn16_N7ee601203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee60120 = {  "ee60120", // class name
  bases_ee60120, 4,
  &(vtc_ee60120[0]), // expected_vtbl_contents
  &(vtt_ee60120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee60120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70120  : virtual dd0120 {
  int e;
  virtual void  foo(); // _ZN7ee701203fooEv
  virtual void  bar(); // _ZN7ee701203barEv
  ~ee70120(); // tgen
  ee70120(); // tgen
};
//SIG(1 ee70120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee70120 ::foo(){vfunc_called(this, "_ZN7ee701203fooEv");}
void  ee70120 ::bar(){vfunc_called(this, "_ZN7ee701203barEv");}
ee70120 ::~ee70120(){ note_dtor("ee70120", this);} // tgen
ee70120 ::ee70120(){ note_ctor("ee70120", this);} // tgen

static void Test_ee70120()
{
  extern Class_Descriptor cd_ee70120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee70120, buf);
    ee70120 *dp, &lv = *(dp=new (buf) ee70120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee70120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee70120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd0120*), ABISELECT(32,20), "ee70120");
    check_base_class_offset(lv, (cc120*)(dd0120*), ABISELECT(16,8), "ee70120");
    check_base_class_offset(lv, (dd0120*), ABISELECT(16,8), "ee70120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70120.e");
    test_class_info(&lv, &cd_ee70120);
    dp->~ee70120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70120(Test_ee70120, "ee70120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee70120C1Ev();
extern void _ZN7ee70120D1Ev();
Name_Map name_map_ee70120[] = {
  NSPAIR(_ZN7ee70120C1Ev),
  NSPAIR(_ZN7ee70120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd0120;
extern VTBL_ENTRY _ZTI6dd0120[];
extern  VTBL_ENTRY _ZTV6dd0120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0120[];
static Base_Class bases_ee70120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70120[];
extern void _ZN7ee701203fooEv();
extern void _ZN7ee701203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee701203fooEv,_ZTv0_n12_N7ee701203fooEv)();
extern void ABISELECT(_ZThn32_N7ee701203fooEv,_ZThn20_N7ee701203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70120[0]),
  (VTBL_ENTRY)&_ZN7ee701203fooEv,
  (VTBL_ENTRY)&_ZN7ee701203barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee70120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee701203fooEv,_ZTv0_n12_N7ee701203fooEv),
};
extern VTBL_ENTRY _ZTV7ee70120[];
static  VTBL_ENTRY _tg__ZTV6dd0120__7ee70120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd0120__7ee70120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd0120__7ee70120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd0120__7ee70120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee70120[] = {
  {&(_ZTV7ee70120[4]),  4,13},
  {&(_ZTV7ee70120[9]),  9,13},
  {&(_ZTV7ee70120[12]),  12,13},
  {&(_tg__ZTV6dd0120__7ee70120[3]),  3,3},
  {&(_tg__ZTV5cc1206dd0120__7ee70120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd0120__7ee70120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd0120__7ee70120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee70120[];
extern  VTBL_ENTRY _ZTV7ee70120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70120[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee701203fooEv,_ZTv0_n12_N7ee701203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee701203fooEv,_ZThn20_N7ee701203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70120 = {  "ee70120", // class name
  bases_ee70120, 4,
  &(vtc_ee70120[0]), // expected_vtbl_contents
  &(vtt_ee70120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee70120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1120  : virtual cc120 {
  int d;
  ~dd1120(); // tgen
  dd1120(); // tgen
};
//SIG(-1 dd1120) C1{ VBC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} Fi}


dd1120 ::~dd1120(){ note_dtor("dd1120", this);} // tgen
dd1120 ::dd1120(){ note_ctor("dd1120", this);} // tgen

static void Test_dd1120()
{
  extern Class_Descriptor cd_dd1120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd1120, buf);
    dd1120 *dp, &lv = *(dp=new (buf) dd1120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd1120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,20), "dd1120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,16), "dd1120");
    check_base_class_offset(lv, (cc120*), ABISELECT(16,8), "dd1120");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1120.d");
    test_class_info(&lv, &cd_dd1120);
    dp->~dd1120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1120(Test_dd1120, "dd1120", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd1120C1Ev();
extern void _ZN6dd1120D1Ev();
Name_Map name_map_dd1120[] = {
  NSPAIR(_ZN6dd1120C1Ev),
  NSPAIR(_ZN6dd1120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd1120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1120[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_dd1120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV6dd1120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd1120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd1120[] = {
  {&(_ZTV6dd1120[4]),  4,11},
  {&(_ZTV6dd1120[7]),  7,11},
  {&(_ZTV6dd1120[10]),  10,11},
  {&(_tg__ZTV5cc120__6dd1120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd1120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
Class_Descriptor cd_dd1120 = {  "dd1120", // class name
  bases_dd1120, 3,
  &(vtc_dd1120[0]), // expected_vtbl_contents
  &(vtt_dd1120[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd1120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1120),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1120),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01120  : dd1120 {
  int e;
  ~ee01120(); // tgen
  ee01120(); // tgen
};
//SIG(1 ee01120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee01120 ::~ee01120(){ note_dtor("ee01120", this);} // tgen
ee01120 ::ee01120(){ note_ctor("ee01120", this);} // tgen

static void Test_ee01120()
{
  extern Class_Descriptor cd_ee01120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee01120, buf);
    ee01120 *dp, &lv = *(dp=new (buf) ee01120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee01120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee01120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee01120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(16,12), "ee01120");
    check_base_class_offset(lv, (dd1120*), 0, "ee01120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01120.e");
    test_class_info(&lv, &cd_ee01120);
    dp->~ee01120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01120(Test_ee01120, "ee01120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee01120C1Ev();
extern void _ZN7ee01120D1Ev();
Name_Map name_map_ee01120[] = {
  NSPAIR(_ZN7ee01120C1Ev),
  NSPAIR(_ZN7ee01120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee01120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01120[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee01120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01120[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01120[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee01120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee01120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee01120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee01120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee01120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee01120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee01120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee01120[] = {
  {&(_ZTV7ee01120[4]),  4,11},
  {&(_tg__ZTV6dd1120__7ee01120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee01120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee01120[3]),  3,4},
  {&(_ZTV7ee01120[7]),  7,11},
  {&(_ZTV7ee01120[10]),  10,11},
  {&(_tg__ZTV5cc120__7ee01120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee01120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee01120[];
extern  VTBL_ENTRY _ZTV7ee01120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01120[];
Class_Descriptor cd_ee01120 = {  "ee01120", // class name
  bases_ee01120, 4,
  &(vtc_ee01120[0]), // expected_vtbl_contents
  &(vtt_ee01120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee01120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01120),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11120  : virtual dd1120 {
  int e;
  ~ee11120(); // tgen
  ee11120(); // tgen
};
//SIG(1 ee11120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} Fi}


ee11120 ::~ee11120(){ note_dtor("ee11120", this);} // tgen
ee11120 ::ee11120(){ note_ctor("ee11120", this);} // tgen

static void Test_ee11120()
{
  extern Class_Descriptor cd_ee11120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee11120, buf);
    ee11120 *dp, &lv = *(dp=new (buf) ee11120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee11120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee11120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee11120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(32,16), "ee11120");
    check_base_class_offset(lv, (dd1120*), ABISELECT(16,8), "ee11120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11120.e");
    test_class_info(&lv, &cd_ee11120);
    dp->~ee11120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11120(Test_ee11120, "ee11120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee11120C1Ev();
extern void _ZN7ee11120D1Ev();
Name_Map name_map_ee11120[] = {
  NSPAIR(_ZN7ee11120C1Ev),
  NSPAIR(_ZN7ee11120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee11120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11120[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee11120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11120[0]),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11120[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11120[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee11120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee11120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee11120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee11120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee11120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee11120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee11120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee11120[] = {
  {&(_ZTV7ee11120[5]),  5,16},
  {&(_ZTV7ee11120[9]),  9,16},
  {&(_ZTV7ee11120[12]),  12,16},
  {&(_ZTV7ee11120[15]),  15,16},
  {&(_tg__ZTV6dd1120__7ee11120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee11120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee11120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee11120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee11120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11120[];
extern  VTBL_ENTRY _ZTV7ee11120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11120[];
Class_Descriptor cd_ee11120 = {  "ee11120", // class name
  bases_ee11120, 4,
  &(vtc_ee11120[0]), // expected_vtbl_contents
  &(vtt_ee11120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee11120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11120),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21120  : dd1120 {
  int e;
  virtual void  foo(); // _ZN7ee211203fooEv
  ~ee21120(); // tgen
  ee21120(); // tgen
};
//SIG(1 ee21120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee21120 ::foo(){vfunc_called(this, "_ZN7ee211203fooEv");}
ee21120 ::~ee21120(){ note_dtor("ee21120", this);} // tgen
ee21120 ::ee21120(){ note_ctor("ee21120", this);} // tgen

static void Test_ee21120()
{
  extern Class_Descriptor cd_ee21120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee21120, buf);
    ee21120 *dp, &lv = *(dp=new (buf) ee21120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee21120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee21120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee21120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(16,12), "ee21120");
    check_base_class_offset(lv, (dd1120*), 0, "ee21120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21120.e");
    test_class_info(&lv, &cd_ee21120);
    dp->~ee21120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21120(Test_ee21120, "ee21120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee21120C1Ev();
extern void _ZN7ee21120D1Ev();
Name_Map name_map_ee21120[] = {
  NSPAIR(_ZN7ee21120C1Ev),
  NSPAIR(_ZN7ee21120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee21120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21120[];
extern void _ZN7ee211203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee211203fooEv,_ZTv0_n12_N7ee211203fooEv)();
extern void ABISELECT(_ZThn32_N7ee211203fooEv,_ZThn20_N7ee211203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21120[0]),
  (VTBL_ENTRY)&_ZN7ee211203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee21120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee211203fooEv,_ZTv0_n12_N7ee211203fooEv),
};
extern VTBL_ENTRY _ZTV7ee21120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee21120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee21120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee21120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee21120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee21120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee21120[] = {
  {&(_ZTV7ee21120[4]),  4,12},
  {&(_tg__ZTV6dd1120__7ee21120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee21120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee21120[3]),  3,4},
  {&(_ZTV7ee21120[8]),  8,12},
  {&(_ZTV7ee21120[11]),  11,12},
  {&(_tg__ZTV5cc120__7ee21120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee21120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee21120[];
extern  VTBL_ENTRY _ZTV7ee21120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21120[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee211203fooEv,_ZTv0_n12_N7ee211203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee211203fooEv,_ZThn20_N7ee211203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21120 = {  "ee21120", // class name
  bases_ee21120, 4,
  &(vtc_ee21120[0]), // expected_vtbl_contents
  &(vtt_ee21120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee21120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31120  : virtual dd1120 {
  int e;
  virtual void  foo(); // _ZN7ee311203fooEv
  ~ee31120(); // tgen
  ee31120(); // tgen
};
//SIG(1 ee31120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 Fi}


void  ee31120 ::foo(){vfunc_called(this, "_ZN7ee311203fooEv");}
ee31120 ::~ee31120(){ note_dtor("ee31120", this);} // tgen
ee31120 ::ee31120(){ note_ctor("ee31120", this);} // tgen

static void Test_ee31120()
{
  extern Class_Descriptor cd_ee31120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee31120, buf);
    ee31120 *dp, &lv = *(dp=new (buf) ee31120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee31120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee31120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee31120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(32,16), "ee31120");
    check_base_class_offset(lv, (dd1120*), ABISELECT(16,8), "ee31120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31120.e");
    test_class_info(&lv, &cd_ee31120);
    dp->~ee31120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31120(Test_ee31120, "ee31120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee31120C1Ev();
extern void _ZN7ee31120D1Ev();
Name_Map name_map_ee31120[] = {
  NSPAIR(_ZN7ee31120C1Ev),
  NSPAIR(_ZN7ee31120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee31120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31120[];
extern void _ZN7ee311203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee311203fooEv,_ZTv0_n12_N7ee311203fooEv)();
extern void ABISELECT(_ZThn48_N7ee311203fooEv,_ZThn24_N7ee311203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31120[0]),
  (VTBL_ENTRY)&_ZN7ee311203fooEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31120[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee31120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee311203fooEv,_ZTv0_n12_N7ee311203fooEv),
};
extern VTBL_ENTRY _ZTV7ee31120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee31120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee31120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee31120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee31120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee31120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee31120[] = {
  {&(_ZTV7ee31120[5]),  5,17},
  {&(_ZTV7ee31120[10]),  10,17},
  {&(_ZTV7ee31120[13]),  13,17},
  {&(_ZTV7ee31120[16]),  16,17},
  {&(_tg__ZTV6dd1120__7ee31120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee31120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee31120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee31120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee31120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31120[];
extern  VTBL_ENTRY _ZTV7ee31120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31120[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee311203fooEv,_ZTv0_n12_N7ee311203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee311203fooEv,_ZThn24_N7ee311203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31120 = {  "ee31120", // class name
  bases_ee31120, 4,
  &(vtc_ee31120[0]), // expected_vtbl_contents
  &(vtt_ee31120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee31120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31120),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41120  : dd1120 {
  int e;
  virtual void  bar(); // _ZN7ee411203barEv
  ~ee41120(); // tgen
  ee41120(); // tgen
};
//SIG(1 ee41120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee41120 ::bar(){vfunc_called(this, "_ZN7ee411203barEv");}
ee41120 ::~ee41120(){ note_dtor("ee41120", this);} // tgen
ee41120 ::ee41120(){ note_ctor("ee41120", this);} // tgen

static void Test_ee41120()
{
  extern Class_Descriptor cd_ee41120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee41120, buf);
    ee41120 *dp, &lv = *(dp=new (buf) ee41120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee41120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee41120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee41120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(16,12), "ee41120");
    check_base_class_offset(lv, (dd1120*), 0, "ee41120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41120.e");
    test_class_info(&lv, &cd_ee41120);
    dp->~ee41120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41120(Test_ee41120, "ee41120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee41120C1Ev();
extern void _ZN7ee41120D1Ev();
Name_Map name_map_ee41120[] = {
  NSPAIR(_ZN7ee41120C1Ev),
  NSPAIR(_ZN7ee41120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee41120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41120[];
extern void _ZN7ee411203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee41120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41120[0]),
  (VTBL_ENTRY)&_ZN7ee411203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41120[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee41120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee41120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee41120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee41120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee41120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee41120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee41120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee41120[] = {
  {&(_ZTV7ee41120[4]),  4,12},
  {&(_tg__ZTV6dd1120__7ee41120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee41120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee41120[3]),  3,4},
  {&(_ZTV7ee41120[8]),  8,12},
  {&(_ZTV7ee41120[11]),  11,12},
  {&(_tg__ZTV5cc120__7ee41120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee41120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee41120[];
extern  VTBL_ENTRY _ZTV7ee41120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41120[];
Class_Descriptor cd_ee41120 = {  "ee41120", // class name
  bases_ee41120, 4,
  &(vtc_ee41120[0]), // expected_vtbl_contents
  &(vtt_ee41120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee41120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51120  : virtual dd1120 {
  int e;
  virtual void  bar(); // _ZN7ee511203barEv
  ~ee51120(); // tgen
  ee51120(); // tgen
};
//SIG(1 ee51120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} Fi} v1 Fi}


void  ee51120 ::bar(){vfunc_called(this, "_ZN7ee511203barEv");}
ee51120 ::~ee51120(){ note_dtor("ee51120", this);} // tgen
ee51120 ::ee51120(){ note_ctor("ee51120", this);} // tgen

static void Test_ee51120()
{
  extern Class_Descriptor cd_ee51120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee51120, buf);
    ee51120 *dp, &lv = *(dp=new (buf) ee51120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee51120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee51120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee51120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(32,16), "ee51120");
    check_base_class_offset(lv, (dd1120*), ABISELECT(16,8), "ee51120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51120.e");
    test_class_info(&lv, &cd_ee51120);
    dp->~ee51120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51120(Test_ee51120, "ee51120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee51120C1Ev();
extern void _ZN7ee51120D1Ev();
Name_Map name_map_ee51120[] = {
  NSPAIR(_ZN7ee51120C1Ev),
  NSPAIR(_ZN7ee51120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee51120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51120[];
extern void _ZN7ee511203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee51120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51120[0]),
  (VTBL_ENTRY)&_ZN7ee511203barEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51120[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51120[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee51120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee51120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee51120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee51120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee51120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee51120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee51120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee51120[] = {
  {&(_ZTV7ee51120[5]),  5,17},
  {&(_ZTV7ee51120[10]),  10,17},
  {&(_ZTV7ee51120[13]),  13,17},
  {&(_ZTV7ee51120[16]),  16,17},
  {&(_tg__ZTV6dd1120__7ee51120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee51120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee51120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee51120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee51120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51120[];
extern  VTBL_ENTRY _ZTV7ee51120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51120[];
Class_Descriptor cd_ee51120 = {  "ee51120", // class name
  bases_ee51120, 4,
  &(vtc_ee51120[0]), // expected_vtbl_contents
  &(vtt_ee51120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee51120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51120),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61120  : dd1120 {
  int e;
  virtual void  foo(); // _ZN7ee611203fooEv
  virtual void  bar(); // _ZN7ee611203barEv
  ~ee61120(); // tgen
  ee61120(); // tgen
};
//SIG(1 ee61120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee61120 ::foo(){vfunc_called(this, "_ZN7ee611203fooEv");}
void  ee61120 ::bar(){vfunc_called(this, "_ZN7ee611203barEv");}
ee61120 ::~ee61120(){ note_dtor("ee61120", this);} // tgen
ee61120 ::ee61120(){ note_ctor("ee61120", this);} // tgen

static void Test_ee61120()
{
  extern Class_Descriptor cd_ee61120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee61120, buf);
    ee61120 *dp, &lv = *(dp=new (buf) ee61120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee61120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee61120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee61120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(16,12), "ee61120");
    check_base_class_offset(lv, (dd1120*), 0, "ee61120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61120.e");
    test_class_info(&lv, &cd_ee61120);
    dp->~ee61120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61120(Test_ee61120, "ee61120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee61120C1Ev();
extern void _ZN7ee61120D1Ev();
Name_Map name_map_ee61120[] = {
  NSPAIR(_ZN7ee61120C1Ev),
  NSPAIR(_ZN7ee61120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee61120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61120[];
extern void _ZN7ee611203fooEv();
extern void _ZN7ee611203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee611203fooEv,_ZTv0_n12_N7ee611203fooEv)();
extern void ABISELECT(_ZThn32_N7ee611203fooEv,_ZThn20_N7ee611203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61120[0]),
  (VTBL_ENTRY)&_ZN7ee611203fooEv,
  (VTBL_ENTRY)&_ZN7ee611203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee61120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee611203fooEv,_ZTv0_n12_N7ee611203fooEv),
};
extern VTBL_ENTRY _ZTV7ee61120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee61120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee61120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee61120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee61120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee61120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee61120[] = {
  {&(_ZTV7ee61120[4]),  4,13},
  {&(_tg__ZTV6dd1120__7ee61120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee61120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee61120[3]),  3,4},
  {&(_ZTV7ee61120[9]),  9,13},
  {&(_ZTV7ee61120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee61120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee61120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee61120[];
extern  VTBL_ENTRY _ZTV7ee61120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61120[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee611203fooEv,_ZTv0_n12_N7ee611203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee611203fooEv,_ZThn20_N7ee611203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61120 = {  "ee61120", // class name
  bases_ee61120, 4,
  &(vtc_ee61120[0]), // expected_vtbl_contents
  &(vtt_ee61120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee61120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71120  : virtual dd1120 {
  int e;
  virtual void  foo(); // _ZN7ee711203fooEv
  virtual void  bar(); // _ZN7ee711203barEv
  ~ee71120(); // tgen
  ee71120(); // tgen
};
//SIG(1 ee71120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} Fi} v1 v2 Fi}


void  ee71120 ::foo(){vfunc_called(this, "_ZN7ee711203fooEv");}
void  ee71120 ::bar(){vfunc_called(this, "_ZN7ee711203barEv");}
ee71120 ::~ee71120(){ note_dtor("ee71120", this);} // tgen
ee71120 ::ee71120(){ note_ctor("ee71120", this);} // tgen

static void Test_ee71120()
{
  extern Class_Descriptor cd_ee71120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee71120, buf);
    ee71120 *dp, &lv = *(dp=new (buf) ee71120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee71120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee71120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee71120");
    check_base_class_offset(lv, (cc120*)(dd1120*), ABISELECT(32,16), "ee71120");
    check_base_class_offset(lv, (dd1120*), ABISELECT(16,8), "ee71120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71120.e");
    test_class_info(&lv, &cd_ee71120);
    dp->~ee71120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71120(Test_ee71120, "ee71120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee71120C1Ev();
extern void _ZN7ee71120D1Ev();
Name_Map name_map_ee71120[] = {
  NSPAIR(_ZN7ee71120C1Ev),
  NSPAIR(_ZN7ee71120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd1120;
extern VTBL_ENTRY _ZTI6dd1120[];
extern  VTBL_ENTRY _ZTV6dd1120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1120[];
static Base_Class bases_ee71120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1120,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71120[];
extern void _ZN7ee711203fooEv();
extern void _ZN7ee711203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee711203fooEv,_ZTv0_n12_N7ee711203fooEv)();
extern void ABISELECT(_ZThn48_N7ee711203fooEv,_ZThn24_N7ee711203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71120[0]),
  (VTBL_ENTRY)&_ZN7ee711203fooEv,
  (VTBL_ENTRY)&_ZN7ee711203barEv,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71120[0]),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee71120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee711203fooEv,_ZTv0_n12_N7ee711203fooEv),
};
extern VTBL_ENTRY _ZTV7ee71120[];
static  VTBL_ENTRY _tg__ZTV6dd1120__7ee71120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd1120__7ee71120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd1120__7ee71120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee71120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee71120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee71120[] = {
  {&(_ZTV7ee71120[5]),  5,18},
  {&(_ZTV7ee71120[11]),  11,18},
  {&(_ZTV7ee71120[14]),  14,18},
  {&(_ZTV7ee71120[17]),  17,18},
  {&(_tg__ZTV6dd1120__7ee71120[4]),  4,4},
  {&(_tg__ZTV5cc120__6dd1120__7ee71120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd1120__7ee71120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee71120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee71120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71120[];
extern  VTBL_ENTRY _ZTV7ee71120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71120[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee711203fooEv,_ZTv0_n12_N7ee711203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee711203fooEv,_ZThn24_N7ee711203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71120 = {  "ee71120", // class name
  bases_ee71120, 4,
  &(vtc_ee71120[0]), // expected_vtbl_contents
  &(vtt_ee71120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee71120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71120),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2120  : cc120 {
  int d;
  virtual void  foo(); // _ZN6dd21203fooEv
  ~dd2120(); // tgen
  dd2120(); // tgen
};
//SIG(-1 dd2120) C1{ BC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd2120 ::foo(){vfunc_called(this, "_ZN6dd21203fooEv");}
dd2120 ::~dd2120(){ note_dtor("dd2120", this);} // tgen
dd2120 ::dd2120(){ note_ctor("dd2120", this);} // tgen

static void Test_dd2120()
{
  extern Class_Descriptor cd_dd2120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd2120, buf);
    dd2120 *dp, &lv = *(dp=new (buf) dd2120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd2120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(24,16), "dd2120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(16,12), "dd2120");
    check_base_class_offset(lv, (cc120*), 0, "dd2120");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2120.d");
    test_class_info(&lv, &cd_dd2120);
    dp->~dd2120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2120(Test_dd2120, "dd2120", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd2120C1Ev();
extern void _ZN6dd2120D1Ev();
Name_Map name_map_dd2120[] = {
  NSPAIR(_ZN6dd2120C1Ev),
  NSPAIR(_ZN6dd2120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd2120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2120[];
extern void _ZN6dd21203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd2120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
extern VTBL_ENTRY _ZTV6dd2120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd2120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd2120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd2120[] = {
  {&(_ZTV6dd2120[3]),  3,8},
  {&(_tg__ZTV5cc120__6dd2120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd2120[3]),  3,4},
  {&(_ZTV6dd2120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd2120 = {  "dd2120", // class name
  bases_dd2120, 3,
  &(vtc_dd2120[0]), // expected_vtbl_contents
  &(vtt_dd2120[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd2120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2120),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02120  : dd2120 {
  int e;
  ~ee02120(); // tgen
  ee02120(); // tgen
};
//SIG(1 ee02120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee02120 ::~ee02120(){ note_dtor("ee02120", this);} // tgen
ee02120 ::ee02120(){ note_ctor("ee02120", this);} // tgen

static void Test_ee02120()
{
  extern Class_Descriptor cd_ee02120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee02120, buf);
    ee02120 *dp, &lv = *(dp=new (buf) ee02120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee02120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee02120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(24,16), "ee02120");
    check_base_class_offset(lv, (cc120*)(dd2120*), 0, "ee02120");
    check_base_class_offset(lv, (dd2120*), 0, "ee02120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02120.e");
    test_class_info(&lv, &cd_ee02120);
    dp->~ee02120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02120(Test_ee02120, "ee02120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee02120C1Ev();
extern void _ZN7ee02120D1Ev();
Name_Map name_map_ee02120[] = {
  NSPAIR(_ZN7ee02120C1Ev),
  NSPAIR(_ZN7ee02120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee02120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02120[];
extern void _ZN6dd21203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee02120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee02120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
extern VTBL_ENTRY _ZTV7ee02120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee02120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee02120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee02120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee02120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee02120[] = {
  {&(_ZTV7ee02120[3]),  3,8},
  {&(_tg__ZTV6dd2120__7ee02120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee02120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee02120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee02120[3]),  3,4},
  {&(_ZTV7ee02120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee02120[];
extern  VTBL_ENTRY _ZTV7ee02120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02120[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee02120 = {  "ee02120", // class name
  bases_ee02120, 4,
  &(vtc_ee02120[0]), // expected_vtbl_contents
  &(vtt_ee02120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee02120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12120  : virtual dd2120 {
  int e;
  ~ee12120(); // tgen
  ee12120(); // tgen
};
//SIG(1 ee12120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee12120 ::~ee12120(){ note_dtor("ee12120", this);} // tgen
ee12120 ::ee12120(){ note_ctor("ee12120", this);} // tgen

static void Test_ee12120()
{
  extern Class_Descriptor cd_ee12120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee12120, buf);
    ee12120 *dp, &lv = *(dp=new (buf) ee12120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee12120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee12120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(32,20), "ee12120");
    check_base_class_offset(lv, (cc120*)(dd2120*), ABISELECT(16,8), "ee12120");
    check_base_class_offset(lv, (dd2120*), ABISELECT(16,8), "ee12120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12120.e");
    test_class_info(&lv, &cd_ee12120);
    dp->~ee12120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12120(Test_ee12120, "ee12120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee12120C1Ev();
extern void _ZN7ee12120D1Ev();
Name_Map name_map_ee12120[] = {
  NSPAIR(_ZN7ee12120C1Ev),
  NSPAIR(_ZN7ee12120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee12120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12120[];
extern void _ZN6dd21203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee12120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12120[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee12120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
extern VTBL_ENTRY _ZTV7ee12120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee12120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee12120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee12120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee12120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee12120[] = {
  {&(_ZTV7ee12120[4]),  4,13},
  {&(_ZTV7ee12120[8]),  8,13},
  {&(_ZTV7ee12120[12]),  12,13},
  {&(_tg__ZTV6dd2120__7ee12120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee12120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee12120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee12120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee12120[];
extern  VTBL_ENTRY _ZTV7ee12120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12120[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee12120 = {  "ee12120", // class name
  bases_ee12120, 4,
  &(vtc_ee12120[0]), // expected_vtbl_contents
  &(vtt_ee12120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee12120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22120  : dd2120 {
  int e;
  virtual void  foo(); // _ZN7ee221203fooEv
  ~ee22120(); // tgen
  ee22120(); // tgen
};
//SIG(1 ee22120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee22120 ::foo(){vfunc_called(this, "_ZN7ee221203fooEv");}
ee22120 ::~ee22120(){ note_dtor("ee22120", this);} // tgen
ee22120 ::ee22120(){ note_ctor("ee22120", this);} // tgen

static void Test_ee22120()
{
  extern Class_Descriptor cd_ee22120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee22120, buf);
    ee22120 *dp, &lv = *(dp=new (buf) ee22120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee22120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee22120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(24,16), "ee22120");
    check_base_class_offset(lv, (cc120*)(dd2120*), 0, "ee22120");
    check_base_class_offset(lv, (dd2120*), 0, "ee22120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22120.e");
    test_class_info(&lv, &cd_ee22120);
    dp->~ee22120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22120(Test_ee22120, "ee22120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee22120C1Ev();
extern void _ZN7ee22120D1Ev();
Name_Map name_map_ee22120[] = {
  NSPAIR(_ZN7ee22120C1Ev),
  NSPAIR(_ZN7ee22120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee22120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22120[];
extern void _ZN7ee221203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee221203fooEv,_ZTv0_n12_N7ee221203fooEv)();
extern void ABISELECT(_ZThn24_N7ee221203fooEv,_ZThn16_N7ee221203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee22120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22120[0]),
  (VTBL_ENTRY)&_ZN7ee221203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee22120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee221203fooEv,_ZTv0_n12_N7ee221203fooEv),
};
extern VTBL_ENTRY _ZTV7ee22120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee22120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee22120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee22120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee22120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee22120[] = {
  {&(_ZTV7ee22120[3]),  3,8},
  {&(_tg__ZTV6dd2120__7ee22120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee22120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee22120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee22120[3]),  3,4},
  {&(_ZTV7ee22120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee22120[];
extern  VTBL_ENTRY _ZTV7ee22120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22120[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee221203fooEv,_ZTv0_n12_N7ee221203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee221203fooEv,_ZThn16_N7ee221203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee22120 = {  "ee22120", // class name
  bases_ee22120, 4,
  &(vtc_ee22120[0]), // expected_vtbl_contents
  &(vtt_ee22120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee22120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32120  : virtual dd2120 {
  int e;
  virtual void  foo(); // _ZN7ee321203fooEv
  ~ee32120(); // tgen
  ee32120(); // tgen
};
//SIG(1 ee32120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee32120 ::foo(){vfunc_called(this, "_ZN7ee321203fooEv");}
ee32120 ::~ee32120(){ note_dtor("ee32120", this);} // tgen
ee32120 ::ee32120(){ note_ctor("ee32120", this);} // tgen

static void Test_ee32120()
{
  extern Class_Descriptor cd_ee32120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee32120, buf);
    ee32120 *dp, &lv = *(dp=new (buf) ee32120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee32120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee32120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(32,20), "ee32120");
    check_base_class_offset(lv, (cc120*)(dd2120*), ABISELECT(16,8), "ee32120");
    check_base_class_offset(lv, (dd2120*), ABISELECT(16,8), "ee32120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32120.e");
    test_class_info(&lv, &cd_ee32120);
    dp->~ee32120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32120(Test_ee32120, "ee32120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee32120C1Ev();
extern void _ZN7ee32120D1Ev();
Name_Map name_map_ee32120[] = {
  NSPAIR(_ZN7ee32120C1Ev),
  NSPAIR(_ZN7ee32120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee32120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32120[];
extern void _ZN7ee321203fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee321203fooEv,_ZTv0_n16_N7ee321203fooEv)();
extern void ABISELECT(_ZThn16_N7ee321203fooEv,_ZThn8_N7ee321203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee321203fooEv,_ZTv0_n12_N7ee321203fooEv)();
extern void ABISELECT(_ZThn32_N7ee321203fooEv,_ZThn20_N7ee321203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32120[0]),
  (VTBL_ENTRY)&_ZN7ee321203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee321203fooEv,_ZTv0_n16_N7ee321203fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee32120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee321203fooEv,_ZTv0_n12_N7ee321203fooEv),
};
extern VTBL_ENTRY _ZTV7ee32120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee32120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee32120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee32120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee32120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee32120[] = {
  {&(_ZTV7ee32120[4]),  4,14},
  {&(_ZTV7ee32120[9]),  9,14},
  {&(_ZTV7ee32120[13]),  13,14},
  {&(_tg__ZTV6dd2120__7ee32120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee32120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee32120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee32120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee32120[];
extern  VTBL_ENTRY _ZTV7ee32120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32120[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee321203fooEv,_ZTv0_n12_N7ee321203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee321203fooEv,_ZThn20_N7ee321203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee321203fooEv,_ZTv0_n16_N7ee321203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321203fooEv,_ZThn8_N7ee321203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32120 = {  "ee32120", // class name
  bases_ee32120, 4,
  &(vtc_ee32120[0]), // expected_vtbl_contents
  &(vtt_ee32120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee32120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32120),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42120  : dd2120 {
  int e;
  virtual void  bar(); // _ZN7ee421203barEv
  ~ee42120(); // tgen
  ee42120(); // tgen
};
//SIG(1 ee42120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee42120 ::bar(){vfunc_called(this, "_ZN7ee421203barEv");}
ee42120 ::~ee42120(){ note_dtor("ee42120", this);} // tgen
ee42120 ::ee42120(){ note_ctor("ee42120", this);} // tgen

static void Test_ee42120()
{
  extern Class_Descriptor cd_ee42120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee42120, buf);
    ee42120 *dp, &lv = *(dp=new (buf) ee42120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee42120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee42120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(24,16), "ee42120");
    check_base_class_offset(lv, (cc120*)(dd2120*), 0, "ee42120");
    check_base_class_offset(lv, (dd2120*), 0, "ee42120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42120.e");
    test_class_info(&lv, &cd_ee42120);
    dp->~ee42120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42120(Test_ee42120, "ee42120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee42120C1Ev();
extern void _ZN7ee42120D1Ev();
Name_Map name_map_ee42120[] = {
  NSPAIR(_ZN7ee42120C1Ev),
  NSPAIR(_ZN7ee42120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee42120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42120[];
extern void _ZN6dd21203fooEv();
extern void _ZN7ee421203barEv();
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee42120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
  (VTBL_ENTRY)&_ZN7ee421203barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee42120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
extern VTBL_ENTRY _ZTV7ee42120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee42120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee42120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee42120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee42120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee42120[] = {
  {&(_ZTV7ee42120[3]),  3,9},
  {&(_tg__ZTV6dd2120__7ee42120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee42120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee42120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee42120[3]),  3,4},
  {&(_ZTV7ee42120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee42120[];
extern  VTBL_ENTRY _ZTV7ee42120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42120[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee42120 = {  "ee42120", // class name
  bases_ee42120, 4,
  &(vtc_ee42120[0]), // expected_vtbl_contents
  &(vtt_ee42120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee42120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52120  : virtual dd2120 {
  int e;
  virtual void  bar(); // _ZN7ee521203barEv
  ~ee52120(); // tgen
  ee52120(); // tgen
};
//SIG(1 ee52120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee52120 ::bar(){vfunc_called(this, "_ZN7ee521203barEv");}
ee52120 ::~ee52120(){ note_dtor("ee52120", this);} // tgen
ee52120 ::ee52120(){ note_ctor("ee52120", this);} // tgen

static void Test_ee52120()
{
  extern Class_Descriptor cd_ee52120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee52120, buf);
    ee52120 *dp, &lv = *(dp=new (buf) ee52120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee52120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee52120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(32,20), "ee52120");
    check_base_class_offset(lv, (cc120*)(dd2120*), ABISELECT(16,8), "ee52120");
    check_base_class_offset(lv, (dd2120*), ABISELECT(16,8), "ee52120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52120.e");
    test_class_info(&lv, &cd_ee52120);
    dp->~ee52120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52120(Test_ee52120, "ee52120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee52120C1Ev();
extern void _ZN7ee52120D1Ev();
Name_Map name_map_ee52120[] = {
  NSPAIR(_ZN7ee52120C1Ev),
  NSPAIR(_ZN7ee52120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee52120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52120[];
extern void _ZN7ee521203barEv();
extern void _ZN6dd21203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee52120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52120[0]),
  (VTBL_ENTRY)&_ZN7ee521203barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee52120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
extern VTBL_ENTRY _ZTV7ee52120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee52120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee52120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee52120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee52120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee52120[] = {
  {&(_ZTV7ee52120[4]),  4,14},
  {&(_ZTV7ee52120[9]),  9,14},
  {&(_ZTV7ee52120[13]),  13,14},
  {&(_tg__ZTV6dd2120__7ee52120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee52120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee52120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee52120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee52120[];
extern  VTBL_ENTRY _ZTV7ee52120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52120[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee52120 = {  "ee52120", // class name
  bases_ee52120, 4,
  &(vtc_ee52120[0]), // expected_vtbl_contents
  &(vtt_ee52120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee52120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52120),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62120  : dd2120 {
  int e;
  virtual void  foo(); // _ZN7ee621203fooEv
  virtual void  bar(); // _ZN7ee621203barEv
  ~ee62120(); // tgen
  ee62120(); // tgen
};
//SIG(1 ee62120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62120 ::foo(){vfunc_called(this, "_ZN7ee621203fooEv");}
void  ee62120 ::bar(){vfunc_called(this, "_ZN7ee621203barEv");}
ee62120 ::~ee62120(){ note_dtor("ee62120", this);} // tgen
ee62120 ::ee62120(){ note_ctor("ee62120", this);} // tgen

static void Test_ee62120()
{
  extern Class_Descriptor cd_ee62120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee62120, buf);
    ee62120 *dp, &lv = *(dp=new (buf) ee62120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee62120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee62120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(24,16), "ee62120");
    check_base_class_offset(lv, (cc120*)(dd2120*), 0, "ee62120");
    check_base_class_offset(lv, (dd2120*), 0, "ee62120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62120.e");
    test_class_info(&lv, &cd_ee62120);
    dp->~ee62120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62120(Test_ee62120, "ee62120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee62120C1Ev();
extern void _ZN7ee62120D1Ev();
Name_Map name_map_ee62120[] = {
  NSPAIR(_ZN7ee62120C1Ev),
  NSPAIR(_ZN7ee62120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee62120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62120[];
extern void _ZN7ee621203fooEv();
extern void _ZN7ee621203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee621203fooEv,_ZTv0_n12_N7ee621203fooEv)();
extern void ABISELECT(_ZThn24_N7ee621203fooEv,_ZThn16_N7ee621203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee62120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62120[0]),
  (VTBL_ENTRY)&_ZN7ee621203fooEv,
  (VTBL_ENTRY)&_ZN7ee621203barEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee62120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee621203fooEv,_ZTv0_n12_N7ee621203fooEv),
};
extern VTBL_ENTRY _ZTV7ee62120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee62120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee62120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee62120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee62120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee62120[] = {
  {&(_ZTV7ee62120[3]),  3,9},
  {&(_tg__ZTV6dd2120__7ee62120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee62120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee62120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee62120[3]),  3,4},
  {&(_ZTV7ee62120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee62120[];
extern  VTBL_ENTRY _ZTV7ee62120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62120[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd21203fooEv,_ZThn16_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee621203fooEv,_ZTv0_n12_N7ee621203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee621203fooEv,_ZThn16_N7ee621203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee62120 = {  "ee62120", // class name
  bases_ee62120, 4,
  &(vtc_ee62120[0]), // expected_vtbl_contents
  &(vtt_ee62120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee62120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72120  : virtual dd2120 {
  int e;
  virtual void  foo(); // _ZN7ee721203fooEv
  virtual void  bar(); // _ZN7ee721203barEv
  ~ee72120(); // tgen
  ee72120(); // tgen
};
//SIG(1 ee72120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72120 ::foo(){vfunc_called(this, "_ZN7ee721203fooEv");}
void  ee72120 ::bar(){vfunc_called(this, "_ZN7ee721203barEv");}
ee72120 ::~ee72120(){ note_dtor("ee72120", this);} // tgen
ee72120 ::ee72120(){ note_ctor("ee72120", this);} // tgen

static void Test_ee72120()
{
  extern Class_Descriptor cd_ee72120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee72120, buf);
    ee72120 *dp, &lv = *(dp=new (buf) ee72120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee72120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee72120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd2120*), ABISELECT(32,20), "ee72120");
    check_base_class_offset(lv, (cc120*)(dd2120*), ABISELECT(16,8), "ee72120");
    check_base_class_offset(lv, (dd2120*), ABISELECT(16,8), "ee72120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72120.e");
    test_class_info(&lv, &cd_ee72120);
    dp->~ee72120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72120(Test_ee72120, "ee72120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee72120C1Ev();
extern void _ZN7ee72120D1Ev();
Name_Map name_map_ee72120[] = {
  NSPAIR(_ZN7ee72120C1Ev),
  NSPAIR(_ZN7ee72120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd2120;
extern VTBL_ENTRY _ZTI6dd2120[];
extern  VTBL_ENTRY _ZTV6dd2120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2120[];
static Base_Class bases_ee72120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72120[];
extern void _ZN7ee721203fooEv();
extern void _ZN7ee721203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee721203fooEv,_ZTv0_n16_N7ee721203fooEv)();
extern void ABISELECT(_ZThn16_N7ee721203fooEv,_ZThn8_N7ee721203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee721203fooEv,_ZTv0_n12_N7ee721203fooEv)();
extern void ABISELECT(_ZThn32_N7ee721203fooEv,_ZThn20_N7ee721203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72120[0]),
  (VTBL_ENTRY)&_ZN7ee721203fooEv,
  (VTBL_ENTRY)&_ZN7ee721203barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721203fooEv,_ZTv0_n16_N7ee721203fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee72120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee721203fooEv,_ZTv0_n12_N7ee721203fooEv),
};
extern VTBL_ENTRY _ZTV7ee72120[];
extern void _ZN6dd21203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2120__7ee72120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&_ZN6dd21203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd2120__7ee72120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd2120__7ee72120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv)();
extern void ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd2120__7ee72120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv),
};
static  VTT_ENTRY vtt_ee72120[] = {
  {&(_ZTV7ee72120[4]),  4,15},
  {&(_ZTV7ee72120[10]),  10,15},
  {&(_ZTV7ee72120[14]),  14,15},
  {&(_tg__ZTV6dd2120__7ee72120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd2120__7ee72120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd2120__7ee72120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd2120__7ee72120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee72120[];
extern  VTBL_ENTRY _ZTV7ee72120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72120[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd21203fooEv,_ZTv0_n12_N6dd21203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd21203fooEv,_ZThn12_N6dd21203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee721203fooEv,_ZTv0_n12_N7ee721203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee721203fooEv,_ZThn20_N7ee721203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee721203fooEv,_ZTv0_n16_N7ee721203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721203fooEv,_ZThn8_N7ee721203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72120 = {  "ee72120", // class name
  bases_ee72120, 4,
  &(vtc_ee72120[0]), // expected_vtbl_contents
  &(vtt_ee72120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee72120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72120),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3120  : virtual cc120 {
  int d;
  virtual void  foo(); // _ZN6dd31203fooEv
  ~dd3120(); // tgen
  dd3120(); // tgen
};
//SIG(-1 dd3120) C1{ VBC2{ VBC3{ BC4{ Fi} v1 Fi} Fi} v1 Fi}


void  dd3120 ::foo(){vfunc_called(this, "_ZN6dd31203fooEv");}
dd3120 ::~dd3120(){ note_dtor("dd3120", this);} // tgen
dd3120 ::dd3120(){ note_ctor("dd3120", this);} // tgen

static void Test_dd3120()
{
  extern Class_Descriptor cd_dd3120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd3120, buf);
    dd3120 *dp, &lv = *(dp=new (buf) dd3120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd3120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,20), "dd3120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,16), "dd3120");
    check_base_class_offset(lv, (cc120*), ABISELECT(16,8), "dd3120");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3120.d");
    test_class_info(&lv, &cd_dd3120);
    dp->~dd3120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3120(Test_dd3120, "dd3120", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd3120C1Ev();
extern void _ZN6dd3120D1Ev();
Name_Map name_map_dd3120[] = {
  NSPAIR(_ZN6dd3120C1Ev),
  NSPAIR(_ZN6dd3120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd3120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3120[];
extern void _ZN6dd31203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
extern VTBL_ENTRY _ZTV6dd3120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd3120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd3120[] = {
  {&(_ZTV6dd3120[4]),  4,12},
  {&(_ZTV6dd3120[8]),  8,12},
  {&(_ZTV6dd3120[11]),  11,12},
  {&(_tg__ZTV5cc120__6dd3120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd3120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3120 = {  "dd3120", // class name
  bases_dd3120, 3,
  &(vtc_dd3120[0]), // expected_vtbl_contents
  &(vtt_dd3120[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd3120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3120),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03120  : dd3120 {
  int e;
  ~ee03120(); // tgen
  ee03120(); // tgen
};
//SIG(1 ee03120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee03120 ::~ee03120(){ note_dtor("ee03120", this);} // tgen
ee03120 ::ee03120(){ note_ctor("ee03120", this);} // tgen

static void Test_ee03120()
{
  extern Class_Descriptor cd_ee03120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee03120, buf);
    ee03120 *dp, &lv = *(dp=new (buf) ee03120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee03120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee03120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee03120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(16,12), "ee03120");
    check_base_class_offset(lv, (dd3120*), 0, "ee03120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03120.e");
    test_class_info(&lv, &cd_ee03120);
    dp->~ee03120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03120(Test_ee03120, "ee03120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee03120C1Ev();
extern void _ZN7ee03120D1Ev();
Name_Map name_map_ee03120[] = {
  NSPAIR(_ZN7ee03120C1Ev),
  NSPAIR(_ZN7ee03120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee03120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03120[];
extern void _ZN6dd31203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee03120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
extern VTBL_ENTRY _ZTV7ee03120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee03120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee03120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee03120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee03120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee03120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee03120[] = {
  {&(_ZTV7ee03120[4]),  4,12},
  {&(_tg__ZTV6dd3120__7ee03120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee03120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee03120[3]),  3,4},
  {&(_ZTV7ee03120[8]),  8,12},
  {&(_ZTV7ee03120[11]),  11,12},
  {&(_tg__ZTV5cc120__7ee03120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee03120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee03120[];
extern  VTBL_ENTRY _ZTV7ee03120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03120[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03120 = {  "ee03120", // class name
  bases_ee03120, 4,
  &(vtc_ee03120[0]), // expected_vtbl_contents
  &(vtt_ee03120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee03120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13120  : virtual dd3120 {
  int e;
  ~ee13120(); // tgen
  ee13120(); // tgen
};
//SIG(1 ee13120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} Fi}


ee13120 ::~ee13120(){ note_dtor("ee13120", this);} // tgen
ee13120 ::ee13120(){ note_ctor("ee13120", this);} // tgen

static void Test_ee13120()
{
  extern Class_Descriptor cd_ee13120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee13120, buf);
    ee13120 *dp, &lv = *(dp=new (buf) ee13120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee13120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee13120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee13120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(32,16), "ee13120");
    check_base_class_offset(lv, (dd3120*), ABISELECT(16,8), "ee13120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13120.e");
    test_class_info(&lv, &cd_ee13120);
    dp->~ee13120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13120(Test_ee13120, "ee13120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee13120C1Ev();
extern void _ZN7ee13120D1Ev();
Name_Map name_map_ee13120[] = {
  NSPAIR(_ZN7ee13120C1Ev),
  NSPAIR(_ZN7ee13120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee13120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13120[];
extern void _ZN6dd31203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13120[0]),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13120[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee13120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
extern VTBL_ENTRY _ZTV7ee13120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee13120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee13120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee13120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee13120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee13120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee13120[] = {
  {&(_ZTV7ee13120[5]),  5,18},
  {&(_ZTV7ee13120[10]),  10,18},
  {&(_ZTV7ee13120[14]),  14,18},
  {&(_ZTV7ee13120[17]),  17,18},
  {&(_tg__ZTV6dd3120__7ee13120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee13120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee13120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee13120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee13120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13120[];
extern  VTBL_ENTRY _ZTV7ee13120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13120[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13120 = {  "ee13120", // class name
  bases_ee13120, 4,
  &(vtc_ee13120[0]), // expected_vtbl_contents
  &(vtt_ee13120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee13120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13120),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23120  : dd3120 {
  int e;
  virtual void  foo(); // _ZN7ee231203fooEv
  ~ee23120(); // tgen
  ee23120(); // tgen
};
//SIG(1 ee23120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee23120 ::foo(){vfunc_called(this, "_ZN7ee231203fooEv");}
ee23120 ::~ee23120(){ note_dtor("ee23120", this);} // tgen
ee23120 ::ee23120(){ note_ctor("ee23120", this);} // tgen

static void Test_ee23120()
{
  extern Class_Descriptor cd_ee23120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee23120, buf);
    ee23120 *dp, &lv = *(dp=new (buf) ee23120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee23120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee23120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee23120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(16,12), "ee23120");
    check_base_class_offset(lv, (dd3120*), 0, "ee23120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23120.e");
    test_class_info(&lv, &cd_ee23120);
    dp->~ee23120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23120(Test_ee23120, "ee23120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee23120C1Ev();
extern void _ZN7ee23120D1Ev();
Name_Map name_map_ee23120[] = {
  NSPAIR(_ZN7ee23120C1Ev),
  NSPAIR(_ZN7ee23120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee23120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23120[];
extern void _ZN7ee231203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee231203fooEv,_ZTv0_n12_N7ee231203fooEv)();
extern void ABISELECT(_ZThn32_N7ee231203fooEv,_ZThn20_N7ee231203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23120[0]),
  (VTBL_ENTRY)&_ZN7ee231203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee23120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee231203fooEv,_ZTv0_n12_N7ee231203fooEv),
};
extern VTBL_ENTRY _ZTV7ee23120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee23120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee23120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee23120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee23120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee23120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee23120[] = {
  {&(_ZTV7ee23120[4]),  4,12},
  {&(_tg__ZTV6dd3120__7ee23120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee23120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee23120[3]),  3,4},
  {&(_ZTV7ee23120[8]),  8,12},
  {&(_ZTV7ee23120[11]),  11,12},
  {&(_tg__ZTV5cc120__7ee23120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee23120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee23120[];
extern  VTBL_ENTRY _ZTV7ee23120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23120[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee231203fooEv,_ZTv0_n12_N7ee231203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee231203fooEv,_ZThn20_N7ee231203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23120 = {  "ee23120", // class name
  bases_ee23120, 4,
  &(vtc_ee23120[0]), // expected_vtbl_contents
  &(vtt_ee23120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee23120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33120  : virtual dd3120 {
  int e;
  virtual void  foo(); // _ZN7ee331203fooEv
  ~ee33120(); // tgen
  ee33120(); // tgen
};
//SIG(1 ee33120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 Fi}


void  ee33120 ::foo(){vfunc_called(this, "_ZN7ee331203fooEv");}
ee33120 ::~ee33120(){ note_dtor("ee33120", this);} // tgen
ee33120 ::ee33120(){ note_ctor("ee33120", this);} // tgen

static void Test_ee33120()
{
  extern Class_Descriptor cd_ee33120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee33120, buf);
    ee33120 *dp, &lv = *(dp=new (buf) ee33120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee33120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee33120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee33120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(32,16), "ee33120");
    check_base_class_offset(lv, (dd3120*), ABISELECT(16,8), "ee33120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33120.e");
    test_class_info(&lv, &cd_ee33120);
    dp->~ee33120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33120(Test_ee33120, "ee33120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee33120C1Ev();
extern void _ZN7ee33120D1Ev();
Name_Map name_map_ee33120[] = {
  NSPAIR(_ZN7ee33120C1Ev),
  NSPAIR(_ZN7ee33120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee33120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33120[];
extern void _ZN7ee331203fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee331203fooEv,_ZTv0_n20_N7ee331203fooEv)();
extern void ABISELECT(_ZThn16_N7ee331203fooEv,_ZThn8_N7ee331203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee331203fooEv,_ZTv0_n12_N7ee331203fooEv)();
extern void ABISELECT(_ZThn48_N7ee331203fooEv,_ZThn24_N7ee331203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33120[0]),
  (VTBL_ENTRY)&_ZN7ee331203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee331203fooEv,_ZTv0_n20_N7ee331203fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee33120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee331203fooEv,_ZTv0_n12_N7ee331203fooEv),
};
extern VTBL_ENTRY _ZTV7ee33120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee33120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee33120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee33120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee33120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee33120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee33120[] = {
  {&(_ZTV7ee33120[5]),  5,19},
  {&(_ZTV7ee33120[11]),  11,19},
  {&(_ZTV7ee33120[15]),  15,19},
  {&(_ZTV7ee33120[18]),  18,19},
  {&(_tg__ZTV6dd3120__7ee33120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee33120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee33120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee33120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee33120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33120[];
extern  VTBL_ENTRY _ZTV7ee33120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33120[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee331203fooEv,_ZTv0_n12_N7ee331203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee331203fooEv,_ZThn24_N7ee331203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee331203fooEv,_ZTv0_n20_N7ee331203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331203fooEv,_ZThn8_N7ee331203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33120 = {  "ee33120", // class name
  bases_ee33120, 4,
  &(vtc_ee33120[0]), // expected_vtbl_contents
  &(vtt_ee33120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee33120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33120),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43120  : dd3120 {
  int e;
  virtual void  bar(); // _ZN7ee431203barEv
  ~ee43120(); // tgen
  ee43120(); // tgen
};
//SIG(1 ee43120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee43120 ::bar(){vfunc_called(this, "_ZN7ee431203barEv");}
ee43120 ::~ee43120(){ note_dtor("ee43120", this);} // tgen
ee43120 ::ee43120(){ note_ctor("ee43120", this);} // tgen

static void Test_ee43120()
{
  extern Class_Descriptor cd_ee43120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee43120, buf);
    ee43120 *dp, &lv = *(dp=new (buf) ee43120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee43120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee43120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee43120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(16,12), "ee43120");
    check_base_class_offset(lv, (dd3120*), 0, "ee43120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43120.e");
    test_class_info(&lv, &cd_ee43120);
    dp->~ee43120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43120(Test_ee43120, "ee43120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee43120C1Ev();
extern void _ZN7ee43120D1Ev();
Name_Map name_map_ee43120[] = {
  NSPAIR(_ZN7ee43120C1Ev),
  NSPAIR(_ZN7ee43120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee43120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43120[];
extern void _ZN6dd31203fooEv();
extern void _ZN7ee431203barEv();
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
  (VTBL_ENTRY)&_ZN7ee431203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee43120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
extern VTBL_ENTRY _ZTV7ee43120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee43120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee43120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee43120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee43120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee43120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee43120[] = {
  {&(_ZTV7ee43120[4]),  4,13},
  {&(_tg__ZTV6dd3120__7ee43120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee43120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee43120[3]),  3,4},
  {&(_ZTV7ee43120[9]),  9,13},
  {&(_ZTV7ee43120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee43120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee43120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee43120[];
extern  VTBL_ENTRY _ZTV7ee43120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43120[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43120 = {  "ee43120", // class name
  bases_ee43120, 4,
  &(vtc_ee43120[0]), // expected_vtbl_contents
  &(vtt_ee43120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee43120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53120  : virtual dd3120 {
  int e;
  virtual void  bar(); // _ZN7ee531203barEv
  ~ee53120(); // tgen
  ee53120(); // tgen
};
//SIG(1 ee53120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v2 Fi} v1 Fi}


void  ee53120 ::bar(){vfunc_called(this, "_ZN7ee531203barEv");}
ee53120 ::~ee53120(){ note_dtor("ee53120", this);} // tgen
ee53120 ::ee53120(){ note_ctor("ee53120", this);} // tgen

static void Test_ee53120()
{
  extern Class_Descriptor cd_ee53120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee53120, buf);
    ee53120 *dp, &lv = *(dp=new (buf) ee53120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee53120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee53120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee53120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(32,16), "ee53120");
    check_base_class_offset(lv, (dd3120*), ABISELECT(16,8), "ee53120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53120.e");
    test_class_info(&lv, &cd_ee53120);
    dp->~ee53120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53120(Test_ee53120, "ee53120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee53120C1Ev();
extern void _ZN7ee53120D1Ev();
Name_Map name_map_ee53120[] = {
  NSPAIR(_ZN7ee53120C1Ev),
  NSPAIR(_ZN7ee53120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee53120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53120[];
extern void _ZN7ee531203barEv();
extern void _ZN6dd31203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53120[0]),
  (VTBL_ENTRY)&_ZN7ee531203barEv,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53120[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee53120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
extern VTBL_ENTRY _ZTV7ee53120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee53120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee53120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee53120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee53120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee53120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee53120[] = {
  {&(_ZTV7ee53120[5]),  5,19},
  {&(_ZTV7ee53120[11]),  11,19},
  {&(_ZTV7ee53120[15]),  15,19},
  {&(_ZTV7ee53120[18]),  18,19},
  {&(_tg__ZTV6dd3120__7ee53120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee53120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee53120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee53120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee53120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53120[];
extern  VTBL_ENTRY _ZTV7ee53120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53120[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53120 = {  "ee53120", // class name
  bases_ee53120, 4,
  &(vtc_ee53120[0]), // expected_vtbl_contents
  &(vtt_ee53120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee53120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53120),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63120  : dd3120 {
  int e;
  virtual void  foo(); // _ZN7ee631203fooEv
  virtual void  bar(); // _ZN7ee631203barEv
  ~ee63120(); // tgen
  ee63120(); // tgen
};
//SIG(1 ee63120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63120 ::foo(){vfunc_called(this, "_ZN7ee631203fooEv");}
void  ee63120 ::bar(){vfunc_called(this, "_ZN7ee631203barEv");}
ee63120 ::~ee63120(){ note_dtor("ee63120", this);} // tgen
ee63120 ::ee63120(){ note_ctor("ee63120", this);} // tgen

static void Test_ee63120()
{
  extern Class_Descriptor cd_ee63120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee63120, buf);
    ee63120 *dp, &lv = *(dp=new (buf) ee63120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee63120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee63120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee63120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(16,12), "ee63120");
    check_base_class_offset(lv, (dd3120*), 0, "ee63120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63120.e");
    test_class_info(&lv, &cd_ee63120);
    dp->~ee63120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63120(Test_ee63120, "ee63120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee63120C1Ev();
extern void _ZN7ee63120D1Ev();
Name_Map name_map_ee63120[] = {
  NSPAIR(_ZN7ee63120C1Ev),
  NSPAIR(_ZN7ee63120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee63120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63120[];
extern void _ZN7ee631203fooEv();
extern void _ZN7ee631203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee631203fooEv,_ZTv0_n12_N7ee631203fooEv)();
extern void ABISELECT(_ZThn32_N7ee631203fooEv,_ZThn20_N7ee631203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63120[0]),
  (VTBL_ENTRY)&_ZN7ee631203fooEv,
  (VTBL_ENTRY)&_ZN7ee631203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee63120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee631203fooEv,_ZTv0_n12_N7ee631203fooEv),
};
extern VTBL_ENTRY _ZTV7ee63120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee63120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee63120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee63120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee63120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee63120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee63120[] = {
  {&(_ZTV7ee63120[4]),  4,13},
  {&(_tg__ZTV6dd3120__7ee63120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee63120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee63120[3]),  3,4},
  {&(_ZTV7ee63120[9]),  9,13},
  {&(_ZTV7ee63120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee63120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee63120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee63120[];
extern  VTBL_ENTRY _ZTV7ee63120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63120[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn20_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee631203fooEv,_ZTv0_n12_N7ee631203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee631203fooEv,_ZThn20_N7ee631203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63120 = {  "ee63120", // class name
  bases_ee63120, 4,
  &(vtc_ee63120[0]), // expected_vtbl_contents
  &(vtt_ee63120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee63120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73120  : virtual dd3120 {
  int e;
  virtual void  foo(); // _ZN7ee731203fooEv
  virtual void  bar(); // _ZN7ee731203barEv
  ~ee73120(); // tgen
  ee73120(); // tgen
};
//SIG(1 ee73120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73120 ::foo(){vfunc_called(this, "_ZN7ee731203fooEv");}
void  ee73120 ::bar(){vfunc_called(this, "_ZN7ee731203barEv");}
ee73120 ::~ee73120(){ note_dtor("ee73120", this);} // tgen
ee73120 ::ee73120(){ note_ctor("ee73120", this);} // tgen

static void Test_ee73120()
{
  extern Class_Descriptor cd_ee73120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee73120, buf);
    ee73120 *dp, &lv = *(dp=new (buf) ee73120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee73120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee73120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee73120");
    check_base_class_offset(lv, (cc120*)(dd3120*), ABISELECT(32,16), "ee73120");
    check_base_class_offset(lv, (dd3120*), ABISELECT(16,8), "ee73120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73120.e");
    test_class_info(&lv, &cd_ee73120);
    dp->~ee73120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73120(Test_ee73120, "ee73120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee73120C1Ev();
extern void _ZN7ee73120D1Ev();
Name_Map name_map_ee73120[] = {
  NSPAIR(_ZN7ee73120C1Ev),
  NSPAIR(_ZN7ee73120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd3120;
extern VTBL_ENTRY _ZTI6dd3120[];
extern  VTBL_ENTRY _ZTV6dd3120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3120[];
static Base_Class bases_ee73120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3120,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73120[];
extern void _ZN7ee731203fooEv();
extern void _ZN7ee731203barEv();
extern void ABISELECT(_ZTv0_n40_N7ee731203fooEv,_ZTv0_n20_N7ee731203fooEv)();
extern void ABISELECT(_ZThn16_N7ee731203fooEv,_ZThn8_N7ee731203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee731203fooEv,_ZTv0_n12_N7ee731203fooEv)();
extern void ABISELECT(_ZThn48_N7ee731203fooEv,_ZThn24_N7ee731203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73120[0]),
  (VTBL_ENTRY)&_ZN7ee731203fooEv,
  (VTBL_ENTRY)&_ZN7ee731203barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee731203fooEv,_ZTv0_n20_N7ee731203fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee73120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee731203fooEv,_ZTv0_n12_N7ee731203fooEv),
};
extern VTBL_ENTRY _ZTV7ee73120[];
extern void _ZN6dd31203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3120__7ee73120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&_ZN6dd31203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd3120__7ee73120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv)();
extern void ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd3120__7ee73120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee73120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee73120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee73120[] = {
  {&(_ZTV7ee73120[5]),  5,20},
  {&(_ZTV7ee73120[12]),  12,20},
  {&(_ZTV7ee73120[16]),  16,20},
  {&(_ZTV7ee73120[19]),  19,20},
  {&(_tg__ZTV6dd3120__7ee73120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd3120__7ee73120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd3120__7ee73120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee73120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee73120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73120[];
extern  VTBL_ENTRY _ZTV7ee73120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73120[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd31203fooEv,_ZTv0_n12_N6dd31203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd31203fooEv,_ZThn16_N6dd31203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee731203fooEv,_ZTv0_n12_N7ee731203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee731203fooEv,_ZThn24_N7ee731203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee731203fooEv,_ZTv0_n20_N7ee731203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731203fooEv,_ZThn8_N7ee731203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73120 = {  "ee73120", // class name
  bases_ee73120, 4,
  &(vtc_ee73120[0]), // expected_vtbl_contents
  &(vtt_ee73120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee73120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73120),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4120  : cc120 {
  int d;
  virtual void  bar(); // _ZN6dd41203barEv
  ~dd4120(); // tgen
  dd4120(); // tgen
};
//SIG(-1 dd4120) C1{ BC2{ VBC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd4120 ::bar(){vfunc_called(this, "_ZN6dd41203barEv");}
dd4120 ::~dd4120(){ note_dtor("dd4120", this);} // tgen
dd4120 ::dd4120(){ note_ctor("dd4120", this);} // tgen

static void Test_dd4120()
{
  extern Class_Descriptor cd_dd4120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd4120, buf);
    dd4120 *dp, &lv = *(dp=new (buf) dd4120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd4120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(24,16), "dd4120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(16,12), "dd4120");
    check_base_class_offset(lv, (cc120*), 0, "dd4120");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4120.d");
    test_class_info(&lv, &cd_dd4120);
    dp->~dd4120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4120(Test_dd4120, "dd4120", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd4120C1Ev();
extern void _ZN6dd4120D1Ev();
Name_Map name_map_dd4120[] = {
  NSPAIR(_ZN6dd4120C1Ev),
  NSPAIR(_ZN6dd4120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd4120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4120[];
extern void _ZN6dd41203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_dd4120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV6dd4120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd4120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd4120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd4120[] = {
  {&(_ZTV6dd4120[3]),  3,8},
  {&(_tg__ZTV5cc120__6dd4120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd4120[3]),  3,4},
  {&(_ZTV6dd4120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
Class_Descriptor cd_dd4120 = {  "dd4120", // class name
  bases_dd4120, 3,
  &(vtc_dd4120[0]), // expected_vtbl_contents
  &(vtt_dd4120[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd4120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4120),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04120  : dd4120 {
  int e;
  ~ee04120(); // tgen
  ee04120(); // tgen
};
//SIG(1 ee04120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee04120 ::~ee04120(){ note_dtor("ee04120", this);} // tgen
ee04120 ::ee04120(){ note_ctor("ee04120", this);} // tgen

static void Test_ee04120()
{
  extern Class_Descriptor cd_ee04120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee04120, buf);
    ee04120 *dp, &lv = *(dp=new (buf) ee04120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee04120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee04120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(24,16), "ee04120");
    check_base_class_offset(lv, (cc120*)(dd4120*), 0, "ee04120");
    check_base_class_offset(lv, (dd4120*), 0, "ee04120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04120.e");
    test_class_info(&lv, &cd_ee04120);
    dp->~ee04120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04120(Test_ee04120, "ee04120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee04120C1Ev();
extern void _ZN7ee04120D1Ev();
Name_Map name_map_ee04120[] = {
  NSPAIR(_ZN7ee04120C1Ev),
  NSPAIR(_ZN7ee04120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee04120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04120[];
extern void _ZN6dd41203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee04120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee04120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee04120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee04120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee04120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee04120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee04120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee04120[] = {
  {&(_ZTV7ee04120[3]),  3,8},
  {&(_tg__ZTV6dd4120__7ee04120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee04120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee04120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee04120[3]),  3,4},
  {&(_ZTV7ee04120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee04120[];
extern  VTBL_ENTRY _ZTV7ee04120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04120[];
Class_Descriptor cd_ee04120 = {  "ee04120", // class name
  bases_ee04120, 4,
  &(vtc_ee04120[0]), // expected_vtbl_contents
  &(vtt_ee04120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee04120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14120  : virtual dd4120 {
  int e;
  ~ee14120(); // tgen
  ee14120(); // tgen
};
//SIG(1 ee14120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee14120 ::~ee14120(){ note_dtor("ee14120", this);} // tgen
ee14120 ::ee14120(){ note_ctor("ee14120", this);} // tgen

static void Test_ee14120()
{
  extern Class_Descriptor cd_ee14120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee14120, buf);
    ee14120 *dp, &lv = *(dp=new (buf) ee14120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee14120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee14120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(32,20), "ee14120");
    check_base_class_offset(lv, (cc120*)(dd4120*), ABISELECT(16,8), "ee14120");
    check_base_class_offset(lv, (dd4120*), ABISELECT(16,8), "ee14120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14120.e");
    test_class_info(&lv, &cd_ee14120);
    dp->~ee14120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14120(Test_ee14120, "ee14120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee14120C1Ev();
extern void _ZN7ee14120D1Ev();
Name_Map name_map_ee14120[] = {
  NSPAIR(_ZN7ee14120C1Ev),
  NSPAIR(_ZN7ee14120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee14120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14120[];
extern void _ZN6dd41203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee14120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14120[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee14120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee14120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee14120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee14120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee14120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee14120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee14120[] = {
  {&(_ZTV7ee14120[4]),  4,13},
  {&(_ZTV7ee14120[8]),  8,13},
  {&(_ZTV7ee14120[12]),  12,13},
  {&(_tg__ZTV6dd4120__7ee14120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee14120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee14120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee14120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee14120[];
extern  VTBL_ENTRY _ZTV7ee14120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14120[];
Class_Descriptor cd_ee14120 = {  "ee14120", // class name
  bases_ee14120, 4,
  &(vtc_ee14120[0]), // expected_vtbl_contents
  &(vtt_ee14120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee14120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24120  : dd4120 {
  int e;
  virtual void  foo(); // _ZN7ee241203fooEv
  ~ee24120(); // tgen
  ee24120(); // tgen
};
//SIG(1 ee24120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee24120 ::foo(){vfunc_called(this, "_ZN7ee241203fooEv");}
ee24120 ::~ee24120(){ note_dtor("ee24120", this);} // tgen
ee24120 ::ee24120(){ note_ctor("ee24120", this);} // tgen

static void Test_ee24120()
{
  extern Class_Descriptor cd_ee24120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee24120, buf);
    ee24120 *dp, &lv = *(dp=new (buf) ee24120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee24120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee24120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(24,16), "ee24120");
    check_base_class_offset(lv, (cc120*)(dd4120*), 0, "ee24120");
    check_base_class_offset(lv, (dd4120*), 0, "ee24120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24120.e");
    test_class_info(&lv, &cd_ee24120);
    dp->~ee24120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24120(Test_ee24120, "ee24120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee24120C1Ev();
extern void _ZN7ee24120D1Ev();
Name_Map name_map_ee24120[] = {
  NSPAIR(_ZN7ee24120C1Ev),
  NSPAIR(_ZN7ee24120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee24120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24120[];
extern void _ZN6dd41203barEv();
extern void _ZN7ee241203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee241203fooEv,_ZTv0_n12_N7ee241203fooEv)();
extern void ABISELECT(_ZThn24_N7ee241203fooEv,_ZThn16_N7ee241203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee24120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
  (VTBL_ENTRY)&_ZN7ee241203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee24120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee241203fooEv,_ZTv0_n12_N7ee241203fooEv),
};
extern VTBL_ENTRY _ZTV7ee24120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee24120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee24120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee24120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee24120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee24120[] = {
  {&(_ZTV7ee24120[3]),  3,9},
  {&(_tg__ZTV6dd4120__7ee24120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee24120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee24120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee24120[3]),  3,4},
  {&(_ZTV7ee24120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee24120[];
extern  VTBL_ENTRY _ZTV7ee24120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24120[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee241203fooEv,_ZTv0_n12_N7ee241203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee241203fooEv,_ZThn16_N7ee241203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee24120 = {  "ee24120", // class name
  bases_ee24120, 4,
  &(vtc_ee24120[0]), // expected_vtbl_contents
  &(vtt_ee24120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee24120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34120  : virtual dd4120 {
  int e;
  virtual void  foo(); // _ZN7ee341203fooEv
  ~ee34120(); // tgen
  ee34120(); // tgen
};
//SIG(1 ee34120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee34120 ::foo(){vfunc_called(this, "_ZN7ee341203fooEv");}
ee34120 ::~ee34120(){ note_dtor("ee34120", this);} // tgen
ee34120 ::ee34120(){ note_ctor("ee34120", this);} // tgen

static void Test_ee34120()
{
  extern Class_Descriptor cd_ee34120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee34120, buf);
    ee34120 *dp, &lv = *(dp=new (buf) ee34120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee34120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee34120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(32,20), "ee34120");
    check_base_class_offset(lv, (cc120*)(dd4120*), ABISELECT(16,8), "ee34120");
    check_base_class_offset(lv, (dd4120*), ABISELECT(16,8), "ee34120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34120.e");
    test_class_info(&lv, &cd_ee34120);
    dp->~ee34120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34120(Test_ee34120, "ee34120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee34120C1Ev();
extern void _ZN7ee34120D1Ev();
Name_Map name_map_ee34120[] = {
  NSPAIR(_ZN7ee34120C1Ev),
  NSPAIR(_ZN7ee34120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee34120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34120[];
extern void _ZN7ee341203fooEv();
extern void _ZN6dd41203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee341203fooEv,_ZTv0_n12_N7ee341203fooEv)();
extern void ABISELECT(_ZThn32_N7ee341203fooEv,_ZThn20_N7ee341203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34120[0]),
  (VTBL_ENTRY)&_ZN7ee341203fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee34120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee341203fooEv,_ZTv0_n12_N7ee341203fooEv),
};
extern VTBL_ENTRY _ZTV7ee34120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee34120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee34120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee34120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee34120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee34120[] = {
  {&(_ZTV7ee34120[4]),  4,14},
  {&(_ZTV7ee34120[9]),  9,14},
  {&(_ZTV7ee34120[13]),  13,14},
  {&(_tg__ZTV6dd4120__7ee34120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee34120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee34120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee34120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee34120[];
extern  VTBL_ENTRY _ZTV7ee34120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34120[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee341203fooEv,_ZTv0_n12_N7ee341203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee341203fooEv,_ZThn20_N7ee341203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34120 = {  "ee34120", // class name
  bases_ee34120, 4,
  &(vtc_ee34120[0]), // expected_vtbl_contents
  &(vtt_ee34120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee34120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34120),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44120  : dd4120 {
  int e;
  virtual void  bar(); // _ZN7ee441203barEv
  ~ee44120(); // tgen
  ee44120(); // tgen
};
//SIG(1 ee44120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee44120 ::bar(){vfunc_called(this, "_ZN7ee441203barEv");}
ee44120 ::~ee44120(){ note_dtor("ee44120", this);} // tgen
ee44120 ::ee44120(){ note_ctor("ee44120", this);} // tgen

static void Test_ee44120()
{
  extern Class_Descriptor cd_ee44120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee44120, buf);
    ee44120 *dp, &lv = *(dp=new (buf) ee44120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee44120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee44120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(24,16), "ee44120");
    check_base_class_offset(lv, (cc120*)(dd4120*), 0, "ee44120");
    check_base_class_offset(lv, (dd4120*), 0, "ee44120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44120.e");
    test_class_info(&lv, &cd_ee44120);
    dp->~ee44120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44120(Test_ee44120, "ee44120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee44120C1Ev();
extern void _ZN7ee44120D1Ev();
Name_Map name_map_ee44120[] = {
  NSPAIR(_ZN7ee44120C1Ev),
  NSPAIR(_ZN7ee44120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee44120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44120[];
extern void _ZN7ee441203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee44120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44120[0]),
  (VTBL_ENTRY)&_ZN7ee441203barEv,
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee44120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee44120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee44120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee44120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee44120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee44120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee44120[] = {
  {&(_ZTV7ee44120[3]),  3,8},
  {&(_tg__ZTV6dd4120__7ee44120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee44120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee44120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee44120[3]),  3,4},
  {&(_ZTV7ee44120[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee44120[];
extern  VTBL_ENTRY _ZTV7ee44120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44120[];
Class_Descriptor cd_ee44120 = {  "ee44120", // class name
  bases_ee44120, 4,
  &(vtc_ee44120[0]), // expected_vtbl_contents
  &(vtt_ee44120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee44120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44120),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54120  : virtual dd4120 {
  int e;
  virtual void  bar(); // _ZN7ee541203barEv
  ~ee54120(); // tgen
  ee54120(); // tgen
};
//SIG(1 ee54120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee54120 ::bar(){vfunc_called(this, "_ZN7ee541203barEv");}
ee54120 ::~ee54120(){ note_dtor("ee54120", this);} // tgen
ee54120 ::ee54120(){ note_ctor("ee54120", this);} // tgen

static void Test_ee54120()
{
  extern Class_Descriptor cd_ee54120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee54120, buf);
    ee54120 *dp, &lv = *(dp=new (buf) ee54120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee54120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee54120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(32,20), "ee54120");
    check_base_class_offset(lv, (cc120*)(dd4120*), ABISELECT(16,8), "ee54120");
    check_base_class_offset(lv, (dd4120*), ABISELECT(16,8), "ee54120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54120.e");
    test_class_info(&lv, &cd_ee54120);
    dp->~ee54120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54120(Test_ee54120, "ee54120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee54120C1Ev();
extern void _ZN7ee54120D1Ev();
Name_Map name_map_ee54120[] = {
  NSPAIR(_ZN7ee54120C1Ev),
  NSPAIR(_ZN7ee54120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee54120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54120[];
extern void _ZN7ee541203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee541203barEv,_ZTv0_n16_N7ee541203barEv)();
extern void ABISELECT(_ZThn16_N7ee541203barEv,_ZThn8_N7ee541203barEv)() __attribute__((weak));
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee54120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54120[0]),
  (VTBL_ENTRY)&_ZN7ee541203barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee541203barEv,_ZTv0_n16_N7ee541203barEv),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee54120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee54120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee54120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee54120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee54120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee54120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee54120[] = {
  {&(_ZTV7ee54120[4]),  4,14},
  {&(_ZTV7ee54120[9]),  9,14},
  {&(_ZTV7ee54120[13]),  13,14},
  {&(_tg__ZTV6dd4120__7ee54120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee54120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee54120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee54120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee54120[];
extern  VTBL_ENTRY _ZTV7ee54120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54120[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee541203barEv,_ZTv0_n16_N7ee541203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541203barEv,_ZThn8_N7ee541203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54120 = {  "ee54120", // class name
  bases_ee54120, 4,
  &(vtc_ee54120[0]), // expected_vtbl_contents
  &(vtt_ee54120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee54120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54120),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64120  : dd4120 {
  int e;
  virtual void  foo(); // _ZN7ee641203fooEv
  virtual void  bar(); // _ZN7ee641203barEv
  ~ee64120(); // tgen
  ee64120(); // tgen
};
//SIG(1 ee64120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64120 ::foo(){vfunc_called(this, "_ZN7ee641203fooEv");}
void  ee64120 ::bar(){vfunc_called(this, "_ZN7ee641203barEv");}
ee64120 ::~ee64120(){ note_dtor("ee64120", this);} // tgen
ee64120 ::ee64120(){ note_ctor("ee64120", this);} // tgen

static void Test_ee64120()
{
  extern Class_Descriptor cd_ee64120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee64120, buf);
    ee64120 *dp, &lv = *(dp=new (buf) ee64120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee64120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee64120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(24,16), "ee64120");
    check_base_class_offset(lv, (cc120*)(dd4120*), 0, "ee64120");
    check_base_class_offset(lv, (dd4120*), 0, "ee64120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64120.e");
    test_class_info(&lv, &cd_ee64120);
    dp->~ee64120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64120(Test_ee64120, "ee64120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee64120C1Ev();
extern void _ZN7ee64120D1Ev();
Name_Map name_map_ee64120[] = {
  NSPAIR(_ZN7ee64120C1Ev),
  NSPAIR(_ZN7ee64120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee64120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64120[];
extern void _ZN7ee641203barEv();
extern void _ZN7ee641203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee641203fooEv,_ZTv0_n12_N7ee641203fooEv)();
extern void ABISELECT(_ZThn24_N7ee641203fooEv,_ZThn16_N7ee641203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee64120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64120[0]),
  (VTBL_ENTRY)&_ZN7ee641203barEv,
  (VTBL_ENTRY)&_ZN7ee641203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee64120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee641203fooEv,_ZTv0_n12_N7ee641203fooEv),
};
extern VTBL_ENTRY _ZTV7ee64120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee64120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee64120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee64120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee64120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee64120[] = {
  {&(_ZTV7ee64120[3]),  3,9},
  {&(_tg__ZTV6dd4120__7ee64120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee64120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee64120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee64120[3]),  3,4},
  {&(_ZTV7ee64120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee64120[];
extern  VTBL_ENTRY _ZTV7ee64120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64120[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee641203fooEv,_ZTv0_n12_N7ee641203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee641203fooEv,_ZThn16_N7ee641203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee64120 = {  "ee64120", // class name
  bases_ee64120, 4,
  &(vtc_ee64120[0]), // expected_vtbl_contents
  &(vtt_ee64120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee64120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74120  : virtual dd4120 {
  int e;
  virtual void  foo(); // _ZN7ee741203fooEv
  virtual void  bar(); // _ZN7ee741203barEv
  ~ee74120(); // tgen
  ee74120(); // tgen
};
//SIG(1 ee74120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74120 ::foo(){vfunc_called(this, "_ZN7ee741203fooEv");}
void  ee74120 ::bar(){vfunc_called(this, "_ZN7ee741203barEv");}
ee74120 ::~ee74120(){ note_dtor("ee74120", this);} // tgen
ee74120 ::ee74120(){ note_ctor("ee74120", this);} // tgen

static void Test_ee74120()
{
  extern Class_Descriptor cd_ee74120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee74120, buf);
    ee74120 *dp, &lv = *(dp=new (buf) ee74120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee74120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee74120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd4120*), ABISELECT(32,20), "ee74120");
    check_base_class_offset(lv, (cc120*)(dd4120*), ABISELECT(16,8), "ee74120");
    check_base_class_offset(lv, (dd4120*), ABISELECT(16,8), "ee74120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74120.e");
    test_class_info(&lv, &cd_ee74120);
    dp->~ee74120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74120(Test_ee74120, "ee74120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee74120C1Ev();
extern void _ZN7ee74120D1Ev();
Name_Map name_map_ee74120[] = {
  NSPAIR(_ZN7ee74120C1Ev),
  NSPAIR(_ZN7ee74120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd4120;
extern VTBL_ENTRY _ZTI6dd4120[];
extern  VTBL_ENTRY _ZTV6dd4120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4120[];
static Base_Class bases_ee74120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74120[];
extern void _ZN7ee741203fooEv();
extern void _ZN7ee741203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee741203barEv,_ZTv0_n16_N7ee741203barEv)();
extern void ABISELECT(_ZThn16_N7ee741203barEv,_ZThn8_N7ee741203barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee741203fooEv,_ZTv0_n12_N7ee741203fooEv)();
extern void ABISELECT(_ZThn32_N7ee741203fooEv,_ZThn20_N7ee741203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74120[0]),
  (VTBL_ENTRY)&_ZN7ee741203fooEv,
  (VTBL_ENTRY)&_ZN7ee741203barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741203barEv,_ZTv0_n16_N7ee741203barEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee74120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee741203fooEv,_ZTv0_n12_N7ee741203fooEv),
};
extern VTBL_ENTRY _ZTV7ee74120[];
extern void _ZN6dd41203barEv();
static  VTBL_ENTRY _tg__ZTV6dd4120__7ee74120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN6dd41203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd4120__7ee74120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd4120__7ee74120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd4120__7ee74120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee74120[] = {
  {&(_ZTV7ee74120[4]),  4,15},
  {&(_ZTV7ee74120[10]),  10,15},
  {&(_ZTV7ee74120[14]),  14,15},
  {&(_tg__ZTV6dd4120__7ee74120[3]),  3,4},
  {&(_tg__ZTV5cc1206dd4120__7ee74120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd4120__7ee74120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd4120__7ee74120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee74120[];
extern  VTBL_ENTRY _ZTV7ee74120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74120[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee741203fooEv,_ZTv0_n12_N7ee741203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee741203fooEv,_ZThn20_N7ee741203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741203barEv,_ZTv0_n16_N7ee741203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741203barEv,_ZThn8_N7ee741203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74120 = {  "ee74120", // class name
  bases_ee74120, 4,
  &(vtc_ee74120[0]), // expected_vtbl_contents
  &(vtt_ee74120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee74120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74120),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5120  : virtual cc120 {
  int d;
  virtual void  bar(); // _ZN6dd51203barEv
  ~dd5120(); // tgen
  dd5120(); // tgen
};
//SIG(-1 dd5120) C1{ VBC2{ VBC3{ BC4{ Fi} v2 Fi} Fi} v1 Fi}


void  dd5120 ::bar(){vfunc_called(this, "_ZN6dd51203barEv");}
dd5120 ::~dd5120(){ note_dtor("dd5120", this);} // tgen
dd5120 ::dd5120(){ note_ctor("dd5120", this);} // tgen

static void Test_dd5120()
{
  extern Class_Descriptor cd_dd5120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd5120, buf);
    dd5120 *dp, &lv = *(dp=new (buf) dd5120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd5120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,20), "dd5120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,16), "dd5120");
    check_base_class_offset(lv, (cc120*), ABISELECT(16,8), "dd5120");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5120.d");
    test_class_info(&lv, &cd_dd5120);
    dp->~dd5120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5120(Test_dd5120, "dd5120", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd5120C1Ev();
extern void _ZN6dd5120D1Ev();
Name_Map name_map_dd5120[] = {
  NSPAIR(_ZN6dd5120C1Ev),
  NSPAIR(_ZN6dd5120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd5120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5120[];
extern void _ZN6dd51203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_dd5120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV6dd5120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd5120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd5120[] = {
  {&(_ZTV6dd5120[4]),  4,12},
  {&(_ZTV6dd5120[8]),  8,12},
  {&(_ZTV6dd5120[11]),  11,12},
  {&(_tg__ZTV5cc120__6dd5120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd5120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
Class_Descriptor cd_dd5120 = {  "dd5120", // class name
  bases_dd5120, 3,
  &(vtc_dd5120[0]), // expected_vtbl_contents
  &(vtt_dd5120[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd5120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5120),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05120  : dd5120 {
  int e;
  ~ee05120(); // tgen
  ee05120(); // tgen
};
//SIG(1 ee05120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee05120 ::~ee05120(){ note_dtor("ee05120", this);} // tgen
ee05120 ::ee05120(){ note_ctor("ee05120", this);} // tgen

static void Test_ee05120()
{
  extern Class_Descriptor cd_ee05120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee05120, buf);
    ee05120 *dp, &lv = *(dp=new (buf) ee05120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee05120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee05120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee05120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(16,12), "ee05120");
    check_base_class_offset(lv, (dd5120*), 0, "ee05120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05120.e");
    test_class_info(&lv, &cd_ee05120);
    dp->~ee05120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05120(Test_ee05120, "ee05120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee05120C1Ev();
extern void _ZN7ee05120D1Ev();
Name_Map name_map_ee05120[] = {
  NSPAIR(_ZN7ee05120C1Ev),
  NSPAIR(_ZN7ee05120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee05120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05120[];
extern void _ZN6dd51203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee05120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05120[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee05120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee05120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee05120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee05120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee05120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee05120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee05120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee05120[] = {
  {&(_ZTV7ee05120[4]),  4,12},
  {&(_tg__ZTV6dd5120__7ee05120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee05120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee05120[3]),  3,4},
  {&(_ZTV7ee05120[8]),  8,12},
  {&(_ZTV7ee05120[11]),  11,12},
  {&(_tg__ZTV5cc120__7ee05120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee05120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee05120[];
extern  VTBL_ENTRY _ZTV7ee05120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05120[];
Class_Descriptor cd_ee05120 = {  "ee05120", // class name
  bases_ee05120, 4,
  &(vtc_ee05120[0]), // expected_vtbl_contents
  &(vtt_ee05120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee05120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15120  : virtual dd5120 {
  int e;
  ~ee15120(); // tgen
  ee15120(); // tgen
};
//SIG(1 ee15120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} Fi}


ee15120 ::~ee15120(){ note_dtor("ee15120", this);} // tgen
ee15120 ::ee15120(){ note_ctor("ee15120", this);} // tgen

static void Test_ee15120()
{
  extern Class_Descriptor cd_ee15120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee15120, buf);
    ee15120 *dp, &lv = *(dp=new (buf) ee15120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee15120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee15120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee15120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(32,16), "ee15120");
    check_base_class_offset(lv, (dd5120*), ABISELECT(16,8), "ee15120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15120.e");
    test_class_info(&lv, &cd_ee15120);
    dp->~ee15120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15120(Test_ee15120, "ee15120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee15120C1Ev();
extern void _ZN7ee15120D1Ev();
Name_Map name_map_ee15120[] = {
  NSPAIR(_ZN7ee15120C1Ev),
  NSPAIR(_ZN7ee15120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee15120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15120[];
extern void _ZN6dd51203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee15120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15120[0]),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15120[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee15120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee15120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee15120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee15120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee15120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee15120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee15120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee15120[] = {
  {&(_ZTV7ee15120[5]),  5,18},
  {&(_ZTV7ee15120[10]),  10,18},
  {&(_ZTV7ee15120[14]),  14,18},
  {&(_ZTV7ee15120[17]),  17,18},
  {&(_tg__ZTV6dd5120__7ee15120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee15120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee15120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee15120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee15120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15120[];
extern  VTBL_ENTRY _ZTV7ee15120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15120[];
Class_Descriptor cd_ee15120 = {  "ee15120", // class name
  bases_ee15120, 4,
  &(vtc_ee15120[0]), // expected_vtbl_contents
  &(vtt_ee15120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee15120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15120),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25120  : dd5120 {
  int e;
  virtual void  foo(); // _ZN7ee251203fooEv
  ~ee25120(); // tgen
  ee25120(); // tgen
};
//SIG(1 ee25120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee25120 ::foo(){vfunc_called(this, "_ZN7ee251203fooEv");}
ee25120 ::~ee25120(){ note_dtor("ee25120", this);} // tgen
ee25120 ::ee25120(){ note_ctor("ee25120", this);} // tgen

static void Test_ee25120()
{
  extern Class_Descriptor cd_ee25120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee25120, buf);
    ee25120 *dp, &lv = *(dp=new (buf) ee25120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee25120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee25120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee25120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(16,12), "ee25120");
    check_base_class_offset(lv, (dd5120*), 0, "ee25120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25120.e");
    test_class_info(&lv, &cd_ee25120);
    dp->~ee25120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25120(Test_ee25120, "ee25120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee25120C1Ev();
extern void _ZN7ee25120D1Ev();
Name_Map name_map_ee25120[] = {
  NSPAIR(_ZN7ee25120C1Ev),
  NSPAIR(_ZN7ee25120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee25120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25120[];
extern void _ZN6dd51203barEv();
extern void _ZN7ee251203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee251203fooEv,_ZTv0_n12_N7ee251203fooEv)();
extern void ABISELECT(_ZThn32_N7ee251203fooEv,_ZThn20_N7ee251203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
  (VTBL_ENTRY)&_ZN7ee251203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee25120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee251203fooEv,_ZTv0_n12_N7ee251203fooEv),
};
extern VTBL_ENTRY _ZTV7ee25120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee25120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee25120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee25120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee25120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee25120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee25120[] = {
  {&(_ZTV7ee25120[4]),  4,13},
  {&(_tg__ZTV6dd5120__7ee25120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee25120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee25120[3]),  3,4},
  {&(_ZTV7ee25120[9]),  9,13},
  {&(_ZTV7ee25120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee25120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee25120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee25120[];
extern  VTBL_ENTRY _ZTV7ee25120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25120[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee251203fooEv,_ZTv0_n12_N7ee251203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee251203fooEv,_ZThn20_N7ee251203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25120 = {  "ee25120", // class name
  bases_ee25120, 4,
  &(vtc_ee25120[0]), // expected_vtbl_contents
  &(vtt_ee25120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee25120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35120  : virtual dd5120 {
  int e;
  virtual void  foo(); // _ZN7ee351203fooEv
  ~ee35120(); // tgen
  ee35120(); // tgen
};
//SIG(1 ee35120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 Fi}


void  ee35120 ::foo(){vfunc_called(this, "_ZN7ee351203fooEv");}
ee35120 ::~ee35120(){ note_dtor("ee35120", this);} // tgen
ee35120 ::ee35120(){ note_ctor("ee35120", this);} // tgen

static void Test_ee35120()
{
  extern Class_Descriptor cd_ee35120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee35120, buf);
    ee35120 *dp, &lv = *(dp=new (buf) ee35120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee35120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee35120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee35120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(32,16), "ee35120");
    check_base_class_offset(lv, (dd5120*), ABISELECT(16,8), "ee35120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35120.e");
    test_class_info(&lv, &cd_ee35120);
    dp->~ee35120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35120(Test_ee35120, "ee35120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee35120C1Ev();
extern void _ZN7ee35120D1Ev();
Name_Map name_map_ee35120[] = {
  NSPAIR(_ZN7ee35120C1Ev),
  NSPAIR(_ZN7ee35120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee35120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35120[];
extern void _ZN7ee351203fooEv();
extern void _ZN6dd51203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee351203fooEv,_ZTv0_n12_N7ee351203fooEv)();
extern void ABISELECT(_ZThn48_N7ee351203fooEv,_ZThn24_N7ee351203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35120[0]),
  (VTBL_ENTRY)&_ZN7ee351203fooEv,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee35120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee351203fooEv,_ZTv0_n12_N7ee351203fooEv),
};
extern VTBL_ENTRY _ZTV7ee35120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee35120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee35120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee35120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee35120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee35120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee35120[] = {
  {&(_ZTV7ee35120[5]),  5,19},
  {&(_ZTV7ee35120[11]),  11,19},
  {&(_ZTV7ee35120[15]),  15,19},
  {&(_ZTV7ee35120[18]),  18,19},
  {&(_tg__ZTV6dd5120__7ee35120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee35120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee35120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee35120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee35120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35120[];
extern  VTBL_ENTRY _ZTV7ee35120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35120[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee351203fooEv,_ZTv0_n12_N7ee351203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee351203fooEv,_ZThn24_N7ee351203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35120 = {  "ee35120", // class name
  bases_ee35120, 4,
  &(vtc_ee35120[0]), // expected_vtbl_contents
  &(vtt_ee35120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee35120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35120),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45120  : dd5120 {
  int e;
  virtual void  bar(); // _ZN7ee451203barEv
  ~ee45120(); // tgen
  ee45120(); // tgen
};
//SIG(1 ee45120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee45120 ::bar(){vfunc_called(this, "_ZN7ee451203barEv");}
ee45120 ::~ee45120(){ note_dtor("ee45120", this);} // tgen
ee45120 ::ee45120(){ note_ctor("ee45120", this);} // tgen

static void Test_ee45120()
{
  extern Class_Descriptor cd_ee45120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee45120, buf);
    ee45120 *dp, &lv = *(dp=new (buf) ee45120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee45120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee45120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee45120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(16,12), "ee45120");
    check_base_class_offset(lv, (dd5120*), 0, "ee45120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45120.e");
    test_class_info(&lv, &cd_ee45120);
    dp->~ee45120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45120(Test_ee45120, "ee45120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee45120C1Ev();
extern void _ZN7ee45120D1Ev();
Name_Map name_map_ee45120[] = {
  NSPAIR(_ZN7ee45120C1Ev),
  NSPAIR(_ZN7ee45120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee45120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45120[];
extern void _ZN7ee451203barEv();
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee45120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45120[0]),
  (VTBL_ENTRY)&_ZN7ee451203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45120[0]),
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee45120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee45120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee45120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee45120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee45120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee45120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee45120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee45120[] = {
  {&(_ZTV7ee45120[4]),  4,12},
  {&(_tg__ZTV6dd5120__7ee45120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee45120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee45120[3]),  3,4},
  {&(_ZTV7ee45120[8]),  8,12},
  {&(_ZTV7ee45120[11]),  11,12},
  {&(_tg__ZTV5cc120__7ee45120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee45120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee45120[];
extern  VTBL_ENTRY _ZTV7ee45120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45120[];
Class_Descriptor cd_ee45120 = {  "ee45120", // class name
  bases_ee45120, 4,
  &(vtc_ee45120[0]), // expected_vtbl_contents
  &(vtt_ee45120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee45120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45120),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55120  : virtual dd5120 {
  int e;
  virtual void  bar(); // _ZN7ee551203barEv
  ~ee55120(); // tgen
  ee55120(); // tgen
};
//SIG(1 ee55120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 Fi} v1 Fi}


void  ee55120 ::bar(){vfunc_called(this, "_ZN7ee551203barEv");}
ee55120 ::~ee55120(){ note_dtor("ee55120", this);} // tgen
ee55120 ::ee55120(){ note_ctor("ee55120", this);} // tgen

static void Test_ee55120()
{
  extern Class_Descriptor cd_ee55120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee55120, buf);
    ee55120 *dp, &lv = *(dp=new (buf) ee55120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee55120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee55120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee55120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(32,16), "ee55120");
    check_base_class_offset(lv, (dd5120*), ABISELECT(16,8), "ee55120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55120.e");
    test_class_info(&lv, &cd_ee55120);
    dp->~ee55120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55120(Test_ee55120, "ee55120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee55120C1Ev();
extern void _ZN7ee55120D1Ev();
Name_Map name_map_ee55120[] = {
  NSPAIR(_ZN7ee55120C1Ev),
  NSPAIR(_ZN7ee55120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee55120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55120[];
extern void _ZN7ee551203barEv();
extern void ABISELECT(_ZTv0_n40_N7ee551203barEv,_ZTv0_n20_N7ee551203barEv)();
extern void ABISELECT(_ZThn16_N7ee551203barEv,_ZThn8_N7ee551203barEv)() __attribute__((weak));
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_ee55120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55120[0]),
  (VTBL_ENTRY)&_ZN7ee551203barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee551203barEv,_ZTv0_n20_N7ee551203barEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55120[0]),
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee55120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTV7ee55120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee55120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee55120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee55120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee55120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee55120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee55120[] = {
  {&(_ZTV7ee55120[5]),  5,19},
  {&(_ZTV7ee55120[11]),  11,19},
  {&(_ZTV7ee55120[15]),  15,19},
  {&(_ZTV7ee55120[18]),  18,19},
  {&(_tg__ZTV6dd5120__7ee55120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee55120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee55120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee55120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee55120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55120[];
extern  VTBL_ENTRY _ZTV7ee55120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55120[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee551203barEv,_ZTv0_n20_N7ee551203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551203barEv,_ZThn8_N7ee551203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55120 = {  "ee55120", // class name
  bases_ee55120, 4,
  &(vtc_ee55120[0]), // expected_vtbl_contents
  &(vtt_ee55120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee55120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55120),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65120  : dd5120 {
  int e;
  virtual void  foo(); // _ZN7ee651203fooEv
  virtual void  bar(); // _ZN7ee651203barEv
  ~ee65120(); // tgen
  ee65120(); // tgen
};
//SIG(1 ee65120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65120 ::foo(){vfunc_called(this, "_ZN7ee651203fooEv");}
void  ee65120 ::bar(){vfunc_called(this, "_ZN7ee651203barEv");}
ee65120 ::~ee65120(){ note_dtor("ee65120", this);} // tgen
ee65120 ::ee65120(){ note_ctor("ee65120", this);} // tgen

static void Test_ee65120()
{
  extern Class_Descriptor cd_ee65120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee65120, buf);
    ee65120 *dp, &lv = *(dp=new (buf) ee65120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee65120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee65120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee65120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(16,12), "ee65120");
    check_base_class_offset(lv, (dd5120*), 0, "ee65120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65120.e");
    test_class_info(&lv, &cd_ee65120);
    dp->~ee65120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65120(Test_ee65120, "ee65120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee65120C1Ev();
extern void _ZN7ee65120D1Ev();
Name_Map name_map_ee65120[] = {
  NSPAIR(_ZN7ee65120C1Ev),
  NSPAIR(_ZN7ee65120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee65120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65120[];
extern void _ZN7ee651203barEv();
extern void _ZN7ee651203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee651203fooEv,_ZTv0_n12_N7ee651203fooEv)();
extern void ABISELECT(_ZThn32_N7ee651203fooEv,_ZThn20_N7ee651203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65120[0]),
  (VTBL_ENTRY)&_ZN7ee651203barEv,
  (VTBL_ENTRY)&_ZN7ee651203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee65120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee651203fooEv,_ZTv0_n12_N7ee651203fooEv),
};
extern VTBL_ENTRY _ZTV7ee65120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee65120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee65120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee65120[] = {
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee65120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee65120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee65120[] = {
  {&(_ZTV7ee65120[4]),  4,13},
  {&(_tg__ZTV6dd5120__7ee65120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee65120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee65120[3]),  3,4},
  {&(_ZTV7ee65120[9]),  9,13},
  {&(_ZTV7ee65120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee65120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee65120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee65120[];
extern  VTBL_ENTRY _ZTV7ee65120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65120[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee651203fooEv,_ZTv0_n12_N7ee651203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee651203fooEv,_ZThn20_N7ee651203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65120 = {  "ee65120", // class name
  bases_ee65120, 4,
  &(vtc_ee65120[0]), // expected_vtbl_contents
  &(vtt_ee65120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee65120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75120  : virtual dd5120 {
  int e;
  virtual void  foo(); // _ZN7ee751203fooEv
  virtual void  bar(); // _ZN7ee751203barEv
  ~ee75120(); // tgen
  ee75120(); // tgen
};
//SIG(1 ee75120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75120 ::foo(){vfunc_called(this, "_ZN7ee751203fooEv");}
void  ee75120 ::bar(){vfunc_called(this, "_ZN7ee751203barEv");}
ee75120 ::~ee75120(){ note_dtor("ee75120", this);} // tgen
ee75120 ::ee75120(){ note_ctor("ee75120", this);} // tgen

static void Test_ee75120()
{
  extern Class_Descriptor cd_ee75120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee75120, buf);
    ee75120 *dp, &lv = *(dp=new (buf) ee75120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee75120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee75120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee75120");
    check_base_class_offset(lv, (cc120*)(dd5120*), ABISELECT(32,16), "ee75120");
    check_base_class_offset(lv, (dd5120*), ABISELECT(16,8), "ee75120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75120.e");
    test_class_info(&lv, &cd_ee75120);
    dp->~ee75120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75120(Test_ee75120, "ee75120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee75120C1Ev();
extern void _ZN7ee75120D1Ev();
Name_Map name_map_ee75120[] = {
  NSPAIR(_ZN7ee75120C1Ev),
  NSPAIR(_ZN7ee75120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd5120;
extern VTBL_ENTRY _ZTI6dd5120[];
extern  VTBL_ENTRY _ZTV6dd5120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5120[];
static Base_Class bases_ee75120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5120,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75120[];
extern void _ZN7ee751203fooEv();
extern void _ZN7ee751203barEv();
extern void ABISELECT(_ZTv0_n40_N7ee751203barEv,_ZTv0_n20_N7ee751203barEv)();
extern void ABISELECT(_ZThn16_N7ee751203barEv,_ZThn8_N7ee751203barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee751203fooEv,_ZTv0_n12_N7ee751203fooEv)();
extern void ABISELECT(_ZThn48_N7ee751203fooEv,_ZThn24_N7ee751203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75120[0]),
  (VTBL_ENTRY)&_ZN7ee751203fooEv,
  (VTBL_ENTRY)&_ZN7ee751203barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee751203barEv,_ZTv0_n20_N7ee751203barEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee75120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee751203fooEv,_ZTv0_n12_N7ee751203fooEv),
};
extern VTBL_ENTRY _ZTV7ee75120[];
extern void _ZN6dd51203barEv();
static  VTBL_ENTRY _tg__ZTV6dd5120__7ee75120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN6dd51203barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd5120__7ee75120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__6dd5120__7ee75120[] = {
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee75120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee75120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee75120[] = {
  {&(_ZTV7ee75120[5]),  5,20},
  {&(_ZTV7ee75120[12]),  12,20},
  {&(_ZTV7ee75120[16]),  16,20},
  {&(_ZTV7ee75120[19]),  19,20},
  {&(_tg__ZTV6dd5120__7ee75120[4]),  4,5},
  {&(_tg__ZTV5cc120__6dd5120__7ee75120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd5120__7ee75120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee75120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee75120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75120[];
extern  VTBL_ENTRY _ZTV7ee75120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75120[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee751203fooEv,_ZTv0_n12_N7ee751203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee751203fooEv,_ZThn24_N7ee751203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee751203barEv,_ZTv0_n20_N7ee751203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751203barEv,_ZThn8_N7ee751203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75120 = {  "ee75120", // class name
  bases_ee75120, 4,
  &(vtc_ee75120[0]), // expected_vtbl_contents
  &(vtt_ee75120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee75120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75120),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6120  : cc120 {
  int d;
  virtual void  bar(); // _ZN6dd61203barEv
  virtual void  foo(); // _ZN6dd61203fooEv
  ~dd6120(); // tgen
  dd6120(); // tgen
};
//SIG(-1 dd6120) C1{ BC2{ VBC3{ BC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd6120 ::bar(){vfunc_called(this, "_ZN6dd61203barEv");}
void  dd6120 ::foo(){vfunc_called(this, "_ZN6dd61203fooEv");}
dd6120 ::~dd6120(){ note_dtor("dd6120", this);} // tgen
dd6120 ::dd6120(){ note_ctor("dd6120", this);} // tgen

static void Test_dd6120()
{
  extern Class_Descriptor cd_dd6120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd6120, buf);
    dd6120 *dp, &lv = *(dp=new (buf) dd6120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd6120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(24,16), "dd6120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(16,12), "dd6120");
    check_base_class_offset(lv, (cc120*), 0, "dd6120");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6120.d");
    test_class_info(&lv, &cd_dd6120);
    dp->~dd6120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6120(Test_dd6120, "dd6120", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd6120C1Ev();
extern void _ZN6dd6120D1Ev();
Name_Map name_map_dd6120[] = {
  NSPAIR(_ZN6dd6120C1Ev),
  NSPAIR(_ZN6dd6120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd6120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd6120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
extern VTBL_ENTRY _ZTV6dd6120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd6120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd6120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd6120[] = {
  {&(_ZTV6dd6120[3]),  3,9},
  {&(_tg__ZTV5cc120__6dd6120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd6120[3]),  3,4},
  {&(_ZTV6dd6120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd6120 = {  "dd6120", // class name
  bases_dd6120, 3,
  &(vtc_dd6120[0]), // expected_vtbl_contents
  &(vtt_dd6120[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd6120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6120),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06120  : dd6120 {
  int e;
  ~ee06120(); // tgen
  ee06120(); // tgen
};
//SIG(1 ee06120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee06120 ::~ee06120(){ note_dtor("ee06120", this);} // tgen
ee06120 ::ee06120(){ note_ctor("ee06120", this);} // tgen

static void Test_ee06120()
{
  extern Class_Descriptor cd_ee06120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee06120, buf);
    ee06120 *dp, &lv = *(dp=new (buf) ee06120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee06120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee06120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(24,16), "ee06120");
    check_base_class_offset(lv, (cc120*)(dd6120*), 0, "ee06120");
    check_base_class_offset(lv, (dd6120*), 0, "ee06120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06120.e");
    test_class_info(&lv, &cd_ee06120);
    dp->~ee06120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06120(Test_ee06120, "ee06120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee06120C1Ev();
extern void _ZN7ee06120D1Ev();
Name_Map name_map_ee06120[] = {
  NSPAIR(_ZN7ee06120C1Ev),
  NSPAIR(_ZN7ee06120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee06120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee06120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee06120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
extern VTBL_ENTRY _ZTV7ee06120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee06120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee06120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee06120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee06120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee06120[] = {
  {&(_ZTV7ee06120[3]),  3,9},
  {&(_tg__ZTV6dd6120__7ee06120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee06120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee06120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee06120[3]),  3,4},
  {&(_ZTV7ee06120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee06120[];
extern  VTBL_ENTRY _ZTV7ee06120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06120[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee06120 = {  "ee06120", // class name
  bases_ee06120, 4,
  &(vtc_ee06120[0]), // expected_vtbl_contents
  &(vtt_ee06120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee06120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16120  : virtual dd6120 {
  int e;
  ~ee16120(); // tgen
  ee16120(); // tgen
};
//SIG(1 ee16120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee16120 ::~ee16120(){ note_dtor("ee16120", this);} // tgen
ee16120 ::ee16120(){ note_ctor("ee16120", this);} // tgen

static void Test_ee16120()
{
  extern Class_Descriptor cd_ee16120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee16120, buf);
    ee16120 *dp, &lv = *(dp=new (buf) ee16120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee16120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee16120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(32,20), "ee16120");
    check_base_class_offset(lv, (cc120*)(dd6120*), ABISELECT(16,8), "ee16120");
    check_base_class_offset(lv, (dd6120*), ABISELECT(16,8), "ee16120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16120.e");
    test_class_info(&lv, &cd_ee16120);
    dp->~ee16120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16120(Test_ee16120, "ee16120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee16120C1Ev();
extern void _ZN7ee16120D1Ev();
Name_Map name_map_ee16120[] = {
  NSPAIR(_ZN7ee16120C1Ev),
  NSPAIR(_ZN7ee16120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee16120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee16120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16120[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee16120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
extern VTBL_ENTRY _ZTV7ee16120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee16120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee16120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee16120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee16120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee16120[] = {
  {&(_ZTV7ee16120[4]),  4,15},
  {&(_ZTV7ee16120[9]),  9,15},
  {&(_ZTV7ee16120[14]),  14,15},
  {&(_tg__ZTV6dd6120__7ee16120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee16120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee16120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee16120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee16120[];
extern  VTBL_ENTRY _ZTV7ee16120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16120[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee16120 = {  "ee16120", // class name
  bases_ee16120, 4,
  &(vtc_ee16120[0]), // expected_vtbl_contents
  &(vtt_ee16120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee16120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16120),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26120  : dd6120 {
  int e;
  virtual void  foo(); // _ZN7ee261203fooEv
  ~ee26120(); // tgen
  ee26120(); // tgen
};
//SIG(1 ee26120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26120 ::foo(){vfunc_called(this, "_ZN7ee261203fooEv");}
ee26120 ::~ee26120(){ note_dtor("ee26120", this);} // tgen
ee26120 ::ee26120(){ note_ctor("ee26120", this);} // tgen

static void Test_ee26120()
{
  extern Class_Descriptor cd_ee26120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee26120, buf);
    ee26120 *dp, &lv = *(dp=new (buf) ee26120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee26120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee26120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(24,16), "ee26120");
    check_base_class_offset(lv, (cc120*)(dd6120*), 0, "ee26120");
    check_base_class_offset(lv, (dd6120*), 0, "ee26120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26120.e");
    test_class_info(&lv, &cd_ee26120);
    dp->~ee26120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26120(Test_ee26120, "ee26120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee26120C1Ev();
extern void _ZN7ee26120D1Ev();
Name_Map name_map_ee26120[] = {
  NSPAIR(_ZN7ee26120C1Ev),
  NSPAIR(_ZN7ee26120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee26120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26120[];
extern void _ZN6dd61203barEv();
extern void _ZN7ee261203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee261203fooEv,_ZTv0_n12_N7ee261203fooEv)();
extern void ABISELECT(_ZThn24_N7ee261203fooEv,_ZThn16_N7ee261203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee26120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN7ee261203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee26120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee261203fooEv,_ZTv0_n12_N7ee261203fooEv),
};
extern VTBL_ENTRY _ZTV7ee26120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee26120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee26120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee26120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee26120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee26120[] = {
  {&(_ZTV7ee26120[3]),  3,9},
  {&(_tg__ZTV6dd6120__7ee26120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee26120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee26120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee26120[3]),  3,4},
  {&(_ZTV7ee26120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee26120[];
extern  VTBL_ENTRY _ZTV7ee26120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26120[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee261203fooEv,_ZTv0_n12_N7ee261203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee261203fooEv,_ZThn16_N7ee261203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee26120 = {  "ee26120", // class name
  bases_ee26120, 4,
  &(vtc_ee26120[0]), // expected_vtbl_contents
  &(vtt_ee26120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee26120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36120  : virtual dd6120 {
  int e;
  virtual void  foo(); // _ZN7ee361203fooEv
  ~ee36120(); // tgen
  ee36120(); // tgen
};
//SIG(1 ee36120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36120 ::foo(){vfunc_called(this, "_ZN7ee361203fooEv");}
ee36120 ::~ee36120(){ note_dtor("ee36120", this);} // tgen
ee36120 ::ee36120(){ note_ctor("ee36120", this);} // tgen

static void Test_ee36120()
{
  extern Class_Descriptor cd_ee36120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee36120, buf);
    ee36120 *dp, &lv = *(dp=new (buf) ee36120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee36120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee36120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(32,20), "ee36120");
    check_base_class_offset(lv, (cc120*)(dd6120*), ABISELECT(16,8), "ee36120");
    check_base_class_offset(lv, (dd6120*), ABISELECT(16,8), "ee36120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36120.e");
    test_class_info(&lv, &cd_ee36120);
    dp->~ee36120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36120(Test_ee36120, "ee36120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee36120C1Ev();
extern void _ZN7ee36120D1Ev();
Name_Map name_map_ee36120[] = {
  NSPAIR(_ZN7ee36120C1Ev),
  NSPAIR(_ZN7ee36120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee36120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36120[];
extern void _ZN7ee361203fooEv();
extern void _ZN6dd61203barEv();
extern void ABISELECT(_ZTv0_n40_N7ee361203fooEv,_ZTv0_n20_N7ee361203fooEv)();
extern void ABISELECT(_ZThn16_N7ee361203fooEv,_ZThn8_N7ee361203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee361203fooEv,_ZTv0_n12_N7ee361203fooEv)();
extern void ABISELECT(_ZThn32_N7ee361203fooEv,_ZThn20_N7ee361203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36120[0]),
  (VTBL_ENTRY)&_ZN7ee361203fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee361203fooEv,_ZTv0_n20_N7ee361203fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee36120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee361203fooEv,_ZTv0_n12_N7ee361203fooEv),
};
extern VTBL_ENTRY _ZTV7ee36120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee36120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee36120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee36120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee36120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee36120[] = {
  {&(_ZTV7ee36120[4]),  4,16},
  {&(_ZTV7ee36120[10]),  10,16},
  {&(_ZTV7ee36120[15]),  15,16},
  {&(_tg__ZTV6dd6120__7ee36120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee36120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee36120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee36120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee36120[];
extern  VTBL_ENTRY _ZTV7ee36120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36120[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee361203fooEv,_ZTv0_n12_N7ee361203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee361203fooEv,_ZThn20_N7ee361203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee361203fooEv,_ZTv0_n20_N7ee361203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361203fooEv,_ZThn8_N7ee361203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36120 = {  "ee36120", // class name
  bases_ee36120, 4,
  &(vtc_ee36120[0]), // expected_vtbl_contents
  &(vtt_ee36120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee36120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36120),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46120  : dd6120 {
  int e;
  virtual void  bar(); // _ZN7ee461203barEv
  ~ee46120(); // tgen
  ee46120(); // tgen
};
//SIG(1 ee46120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46120 ::bar(){vfunc_called(this, "_ZN7ee461203barEv");}
ee46120 ::~ee46120(){ note_dtor("ee46120", this);} // tgen
ee46120 ::ee46120(){ note_ctor("ee46120", this);} // tgen

static void Test_ee46120()
{
  extern Class_Descriptor cd_ee46120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee46120, buf);
    ee46120 *dp, &lv = *(dp=new (buf) ee46120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee46120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee46120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(24,16), "ee46120");
    check_base_class_offset(lv, (cc120*)(dd6120*), 0, "ee46120");
    check_base_class_offset(lv, (dd6120*), 0, "ee46120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46120.e");
    test_class_info(&lv, &cd_ee46120);
    dp->~ee46120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46120(Test_ee46120, "ee46120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee46120C1Ev();
extern void _ZN7ee46120D1Ev();
Name_Map name_map_ee46120[] = {
  NSPAIR(_ZN7ee46120C1Ev),
  NSPAIR(_ZN7ee46120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee46120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46120[];
extern void _ZN7ee461203barEv();
extern void _ZN6dd61203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee46120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46120[0]),
  (VTBL_ENTRY)&_ZN7ee461203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee46120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
extern VTBL_ENTRY _ZTV7ee46120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee46120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee46120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee46120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee46120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee46120[] = {
  {&(_ZTV7ee46120[3]),  3,9},
  {&(_tg__ZTV6dd6120__7ee46120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee46120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee46120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee46120[3]),  3,4},
  {&(_ZTV7ee46120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee46120[];
extern  VTBL_ENTRY _ZTV7ee46120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46120[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee46120 = {  "ee46120", // class name
  bases_ee46120, 4,
  &(vtc_ee46120[0]), // expected_vtbl_contents
  &(vtt_ee46120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee46120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56120  : virtual dd6120 {
  int e;
  virtual void  bar(); // _ZN7ee561203barEv
  ~ee56120(); // tgen
  ee56120(); // tgen
};
//SIG(1 ee56120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56120 ::bar(){vfunc_called(this, "_ZN7ee561203barEv");}
ee56120 ::~ee56120(){ note_dtor("ee56120", this);} // tgen
ee56120 ::ee56120(){ note_ctor("ee56120", this);} // tgen

static void Test_ee56120()
{
  extern Class_Descriptor cd_ee56120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee56120, buf);
    ee56120 *dp, &lv = *(dp=new (buf) ee56120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee56120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee56120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(32,20), "ee56120");
    check_base_class_offset(lv, (cc120*)(dd6120*), ABISELECT(16,8), "ee56120");
    check_base_class_offset(lv, (dd6120*), ABISELECT(16,8), "ee56120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56120.e");
    test_class_info(&lv, &cd_ee56120);
    dp->~ee56120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56120(Test_ee56120, "ee56120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee56120C1Ev();
extern void _ZN7ee56120D1Ev();
Name_Map name_map_ee56120[] = {
  NSPAIR(_ZN7ee56120C1Ev),
  NSPAIR(_ZN7ee56120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee56120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56120[];
extern void _ZN7ee561203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee561203barEv,_ZTv0_n16_N7ee561203barEv)();
extern void ABISELECT(_ZThn16_N7ee561203barEv,_ZThn8_N7ee561203barEv)() __attribute__((weak));
extern void _ZN6dd61203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56120[0]),
  (VTBL_ENTRY)&_ZN7ee561203barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee561203barEv,_ZTv0_n16_N7ee561203barEv),
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee56120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
extern VTBL_ENTRY _ZTV7ee56120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee56120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee56120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee56120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee56120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee56120[] = {
  {&(_ZTV7ee56120[4]),  4,16},
  {&(_ZTV7ee56120[10]),  10,16},
  {&(_ZTV7ee56120[15]),  15,16},
  {&(_tg__ZTV6dd6120__7ee56120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee56120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee56120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee56120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee56120[];
extern  VTBL_ENTRY _ZTV7ee56120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56120[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee561203barEv,_ZTv0_n16_N7ee561203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561203barEv,_ZThn8_N7ee561203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56120 = {  "ee56120", // class name
  bases_ee56120, 4,
  &(vtc_ee56120[0]), // expected_vtbl_contents
  &(vtt_ee56120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee56120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56120),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66120  : dd6120 {
  int e;
  virtual void  foo(); // _ZN7ee661203fooEv
  virtual void  bar(); // _ZN7ee661203barEv
  ~ee66120(); // tgen
  ee66120(); // tgen
};
//SIG(1 ee66120) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66120 ::foo(){vfunc_called(this, "_ZN7ee661203fooEv");}
void  ee66120 ::bar(){vfunc_called(this, "_ZN7ee661203barEv");}
ee66120 ::~ee66120(){ note_dtor("ee66120", this);} // tgen
ee66120 ::ee66120(){ note_ctor("ee66120", this);} // tgen

static void Test_ee66120()
{
  extern Class_Descriptor cd_ee66120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee66120, buf);
    ee66120 *dp, &lv = *(dp=new (buf) ee66120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee66120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(32,20), "ee66120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(24,16), "ee66120");
    check_base_class_offset(lv, (cc120*)(dd6120*), 0, "ee66120");
    check_base_class_offset(lv, (dd6120*), 0, "ee66120");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66120.e");
    test_class_info(&lv, &cd_ee66120);
    dp->~ee66120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66120(Test_ee66120, "ee66120", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee66120C1Ev();
extern void _ZN7ee66120D1Ev();
Name_Map name_map_ee66120[] = {
  NSPAIR(_ZN7ee66120C1Ev),
  NSPAIR(_ZN7ee66120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee66120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66120[];
extern void _ZN7ee661203barEv();
extern void _ZN7ee661203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee661203fooEv,_ZTv0_n12_N7ee661203fooEv)();
extern void ABISELECT(_ZThn24_N7ee661203fooEv,_ZThn16_N7ee661203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee66120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66120[0]),
  (VTBL_ENTRY)&_ZN7ee661203barEv,
  (VTBL_ENTRY)&_ZN7ee661203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee66120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee661203fooEv,_ZTv0_n12_N7ee661203fooEv),
};
extern VTBL_ENTRY _ZTV7ee66120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee66120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee66120[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee66120[] = {
  0,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee66120[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee66120[] = {
  {&(_ZTV7ee66120[3]),  3,9},
  {&(_tg__ZTV6dd6120__7ee66120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee66120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee66120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee66120[3]),  3,4},
  {&(_ZTV7ee66120[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee66120[];
extern  VTBL_ENTRY _ZTV7ee66120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66120[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N6dd61203fooEv,_ZThn16_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee661203fooEv,_ZTv0_n12_N7ee661203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7ee661203fooEv,_ZThn16_N7ee661203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee66120 = {  "ee66120", // class name
  bases_ee66120, 4,
  &(vtc_ee66120[0]), // expected_vtbl_contents
  &(vtt_ee66120[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee66120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66120),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66120),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76120  : virtual dd6120 {
  int e;
  virtual void  foo(); // _ZN7ee761203fooEv
  virtual void  bar(); // _ZN7ee761203barEv
  ~ee76120(); // tgen
  ee76120(); // tgen
};
//SIG(1 ee76120) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76120 ::foo(){vfunc_called(this, "_ZN7ee761203fooEv");}
void  ee76120 ::bar(){vfunc_called(this, "_ZN7ee761203barEv");}
ee76120 ::~ee76120(){ note_dtor("ee76120", this);} // tgen
ee76120 ::ee76120(){ note_ctor("ee76120", this);} // tgen

static void Test_ee76120()
{
  extern Class_Descriptor cd_ee76120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee76120, buf);
    ee76120 *dp, &lv = *(dp=new (buf) ee76120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee76120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee76120");
    check_base_class_offset(lv, (bb20*)(cc120*)(dd6120*), ABISELECT(32,20), "ee76120");
    check_base_class_offset(lv, (cc120*)(dd6120*), ABISELECT(16,8), "ee76120");
    check_base_class_offset(lv, (dd6120*), ABISELECT(16,8), "ee76120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76120.e");
    test_class_info(&lv, &cd_ee76120);
    dp->~ee76120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76120(Test_ee76120, "ee76120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee76120C1Ev();
extern void _ZN7ee76120D1Ev();
Name_Map name_map_ee76120[] = {
  NSPAIR(_ZN7ee76120C1Ev),
  NSPAIR(_ZN7ee76120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd6120;
extern VTBL_ENTRY _ZTI6dd6120[];
extern  VTBL_ENTRY _ZTV6dd6120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6120[];
static Base_Class bases_ee76120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76120[];
extern void _ZN7ee761203fooEv();
extern void _ZN7ee761203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee761203barEv,_ZTv0_n16_N7ee761203barEv)();
extern void ABISELECT(_ZThn16_N7ee761203barEv,_ZThn8_N7ee761203barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee761203fooEv,_ZTv0_n20_N7ee761203fooEv)();
extern void ABISELECT(_ZThn16_N7ee761203fooEv,_ZThn8_N7ee761203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee761203fooEv,_ZTv0_n12_N7ee761203fooEv)();
extern void ABISELECT(_ZThn32_N7ee761203fooEv,_ZThn20_N7ee761203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76120[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76120[0]),
  (VTBL_ENTRY)&_ZN7ee761203fooEv,
  (VTBL_ENTRY)&_ZN7ee761203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761203barEv,_ZTv0_n16_N7ee761203barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761203fooEv,_ZTv0_n20_N7ee761203fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee76120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee761203fooEv,_ZTv0_n12_N7ee761203fooEv),
};
extern VTBL_ENTRY _ZTV7ee76120[];
extern void _ZN6dd61203barEv();
extern void _ZN6dd61203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6120__7ee76120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&_ZN6dd61203barEv,
  (VTBL_ENTRY)&_ZN6dd61203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1206dd6120__7ee76120[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc1206dd6120__7ee76120[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv)();
extern void ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd6120__7ee76120[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv),
};
static  VTT_ENTRY vtt_ee76120[] = {
  {&(_ZTV7ee76120[4]),  4,17},
  {&(_ZTV7ee76120[11]),  11,17},
  {&(_ZTV7ee76120[16]),  16,17},
  {&(_tg__ZTV6dd6120__7ee76120[3]),  3,5},
  {&(_tg__ZTV5cc1206dd6120__7ee76120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc1206dd6120__7ee76120[3]),  3,4},
  {&(_tg__ZTV4bb20__6dd6120__7ee76120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee76120[];
extern  VTBL_ENTRY _ZTV7ee76120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76120[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd61203fooEv,_ZTv0_n12_N6dd61203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd61203fooEv,_ZThn12_N6dd61203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee761203fooEv,_ZTv0_n12_N7ee761203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee761203fooEv,_ZThn20_N7ee761203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761203fooEv,_ZTv0_n20_N7ee761203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761203fooEv,_ZThn8_N7ee761203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761203barEv,_ZTv0_n16_N7ee761203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761203barEv,_ZThn8_N7ee761203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76120 = {  "ee76120", // class name
  bases_ee76120, 4,
  &(vtc_ee76120[0]), // expected_vtbl_contents
  &(vtt_ee76120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee76120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76120),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76120),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7120  : virtual cc120 {
  int d;
  virtual void  bar(); // _ZN6dd71203barEv
  virtual void  foo(); // _ZN6dd71203fooEv
  ~dd7120(); // tgen
  dd7120(); // tgen
};
//SIG(-1 dd7120) C1{ VBC2{ VBC3{ BC4{ Fi} v2 Fi} Fi} v1 v2 Fi}


void  dd7120 ::bar(){vfunc_called(this, "_ZN6dd71203barEv");}
void  dd7120 ::foo(){vfunc_called(this, "_ZN6dd71203fooEv");}
dd7120 ::~dd7120(){ note_dtor("dd7120", this);} // tgen
dd7120 ::dd7120(){ note_ctor("dd7120", this);} // tgen

static void Test_dd7120()
{
  extern Class_Descriptor cd_dd7120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd7120, buf);
    dd7120 *dp, &lv = *(dp=new (buf) dd7120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd7120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,20), "dd7120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,16), "dd7120");
    check_base_class_offset(lv, (cc120*), ABISELECT(16,8), "dd7120");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7120.d");
    test_class_info(&lv, &cd_dd7120);
    dp->~dd7120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7120(Test_dd7120, "dd7120", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd7120C1Ev();
extern void _ZN6dd7120D1Ev();
Name_Map name_map_dd7120[] = {
  NSPAIR(_ZN6dd7120C1Ev),
  NSPAIR(_ZN6dd7120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
static Base_Class bases_dd7120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
extern VTBL_ENTRY _ZTV6dd7120[];
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__6dd7120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_dd7120[] = {
  {&(_ZTV6dd7120[4]),  4,13},
  {&(_ZTV6dd7120[9]),  9,13},
  {&(_ZTV6dd7120[12]),  12,13},
  {&(_tg__ZTV5cc120__6dd7120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__6dd7120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7120 = {  "dd7120", // class name
  bases_dd7120, 3,
  &(vtc_dd7120[0]), // expected_vtbl_contents
  &(vtt_dd7120[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd7120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7120),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07120  : dd7120 {
  int e;
  ~ee07120(); // tgen
  ee07120(); // tgen
};
//SIG(1 ee07120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee07120 ::~ee07120(){ note_dtor("ee07120", this);} // tgen
ee07120 ::ee07120(){ note_ctor("ee07120", this);} // tgen

static void Test_ee07120()
{
  extern Class_Descriptor cd_ee07120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee07120, buf);
    ee07120 *dp, &lv = *(dp=new (buf) ee07120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee07120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee07120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee07120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(16,12), "ee07120");
    check_base_class_offset(lv, (dd7120*), 0, "ee07120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07120.e");
    test_class_info(&lv, &cd_ee07120);
    dp->~ee07120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07120(Test_ee07120, "ee07120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee07120C1Ev();
extern void _ZN7ee07120D1Ev();
Name_Map name_map_ee07120[] = {
  NSPAIR(_ZN7ee07120C1Ev),
  NSPAIR(_ZN7ee07120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee07120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee07120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
extern VTBL_ENTRY _ZTV7ee07120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee07120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee07120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee07120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee07120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee07120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee07120[] = {
  {&(_ZTV7ee07120[4]),  4,13},
  {&(_tg__ZTV6dd7120__7ee07120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee07120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee07120[3]),  3,4},
  {&(_ZTV7ee07120[9]),  9,13},
  {&(_ZTV7ee07120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee07120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee07120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee07120[];
extern  VTBL_ENTRY _ZTV7ee07120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07120[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07120 = {  "ee07120", // class name
  bases_ee07120, 4,
  &(vtc_ee07120[0]), // expected_vtbl_contents
  &(vtt_ee07120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee07120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17120  : virtual dd7120 {
  int e;
  ~ee17120(); // tgen
  ee17120(); // tgen
};
//SIG(1 ee17120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} Fi}


ee17120 ::~ee17120(){ note_dtor("ee17120", this);} // tgen
ee17120 ::ee17120(){ note_ctor("ee17120", this);} // tgen

static void Test_ee17120()
{
  extern Class_Descriptor cd_ee17120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee17120, buf);
    ee17120 *dp, &lv = *(dp=new (buf) ee17120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee17120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee17120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee17120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(32,16), "ee17120");
    check_base_class_offset(lv, (dd7120*), ABISELECT(16,8), "ee17120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17120.e");
    test_class_info(&lv, &cd_ee17120);
    dp->~ee17120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17120(Test_ee17120, "ee17120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee17120C1Ev();
extern void _ZN7ee17120D1Ev();
Name_Map name_map_ee17120[] = {
  NSPAIR(_ZN7ee17120C1Ev),
  NSPAIR(_ZN7ee17120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee17120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17120[0]),
  0,
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17120[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee17120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
extern VTBL_ENTRY _ZTV7ee17120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee17120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee17120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee17120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee17120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee17120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee17120[] = {
  {&(_ZTV7ee17120[5]),  5,20},
  {&(_ZTV7ee17120[11]),  11,20},
  {&(_ZTV7ee17120[16]),  16,20},
  {&(_ZTV7ee17120[19]),  19,20},
  {&(_tg__ZTV6dd7120__7ee17120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee17120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee17120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee17120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee17120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17120[];
extern  VTBL_ENTRY _ZTV7ee17120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17120[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17120 = {  "ee17120", // class name
  bases_ee17120, 4,
  &(vtc_ee17120[0]), // expected_vtbl_contents
  &(vtt_ee17120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee17120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17120),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27120  : dd7120 {
  int e;
  virtual void  foo(); // _ZN7ee271203fooEv
  ~ee27120(); // tgen
  ee27120(); // tgen
};
//SIG(1 ee27120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27120 ::foo(){vfunc_called(this, "_ZN7ee271203fooEv");}
ee27120 ::~ee27120(){ note_dtor("ee27120", this);} // tgen
ee27120 ::ee27120(){ note_ctor("ee27120", this);} // tgen

static void Test_ee27120()
{
  extern Class_Descriptor cd_ee27120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee27120, buf);
    ee27120 *dp, &lv = *(dp=new (buf) ee27120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee27120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee27120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee27120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(16,12), "ee27120");
    check_base_class_offset(lv, (dd7120*), 0, "ee27120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27120.e");
    test_class_info(&lv, &cd_ee27120);
    dp->~ee27120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27120(Test_ee27120, "ee27120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee27120C1Ev();
extern void _ZN7ee27120D1Ev();
Name_Map name_map_ee27120[] = {
  NSPAIR(_ZN7ee27120C1Ev),
  NSPAIR(_ZN7ee27120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee27120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27120[];
extern void _ZN6dd71203barEv();
extern void _ZN7ee271203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee271203fooEv,_ZTv0_n12_N7ee271203fooEv)();
extern void ABISELECT(_ZThn32_N7ee271203fooEv,_ZThn20_N7ee271203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN7ee271203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee27120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee271203fooEv,_ZTv0_n12_N7ee271203fooEv),
};
extern VTBL_ENTRY _ZTV7ee27120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee27120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee27120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee27120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee27120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee27120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee27120[] = {
  {&(_ZTV7ee27120[4]),  4,13},
  {&(_tg__ZTV6dd7120__7ee27120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee27120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee27120[3]),  3,4},
  {&(_ZTV7ee27120[9]),  9,13},
  {&(_ZTV7ee27120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee27120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee27120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee27120[];
extern  VTBL_ENTRY _ZTV7ee27120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27120[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee271203fooEv,_ZTv0_n12_N7ee271203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee271203fooEv,_ZThn20_N7ee271203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27120 = {  "ee27120", // class name
  bases_ee27120, 4,
  &(vtc_ee27120[0]), // expected_vtbl_contents
  &(vtt_ee27120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee27120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37120  : virtual dd7120 {
  int e;
  virtual void  foo(); // _ZN7ee371203fooEv
  ~ee37120(); // tgen
  ee37120(); // tgen
};
//SIG(1 ee37120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37120 ::foo(){vfunc_called(this, "_ZN7ee371203fooEv");}
ee37120 ::~ee37120(){ note_dtor("ee37120", this);} // tgen
ee37120 ::ee37120(){ note_ctor("ee37120", this);} // tgen

static void Test_ee37120()
{
  extern Class_Descriptor cd_ee37120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee37120, buf);
    ee37120 *dp, &lv = *(dp=new (buf) ee37120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee37120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee37120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee37120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(32,16), "ee37120");
    check_base_class_offset(lv, (dd7120*), ABISELECT(16,8), "ee37120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37120.e");
    test_class_info(&lv, &cd_ee37120);
    dp->~ee37120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37120(Test_ee37120, "ee37120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee37120C1Ev();
extern void _ZN7ee37120D1Ev();
Name_Map name_map_ee37120[] = {
  NSPAIR(_ZN7ee37120C1Ev),
  NSPAIR(_ZN7ee37120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee37120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37120[];
extern void _ZN7ee371203fooEv();
extern void _ZN6dd71203barEv();
extern void ABISELECT(_ZTv0_n48_N7ee371203fooEv,_ZTv0_n24_N7ee371203fooEv)();
extern void ABISELECT(_ZThn16_N7ee371203fooEv,_ZThn8_N7ee371203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee371203fooEv,_ZTv0_n12_N7ee371203fooEv)();
extern void ABISELECT(_ZThn48_N7ee371203fooEv,_ZThn24_N7ee371203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37120[0]),
  (VTBL_ENTRY)&_ZN7ee371203fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee371203fooEv,_ZTv0_n24_N7ee371203fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee37120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee371203fooEv,_ZTv0_n12_N7ee371203fooEv),
};
extern VTBL_ENTRY _ZTV7ee37120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee37120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee37120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee37120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee37120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee37120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee37120[] = {
  {&(_ZTV7ee37120[5]),  5,21},
  {&(_ZTV7ee37120[12]),  12,21},
  {&(_ZTV7ee37120[17]),  17,21},
  {&(_ZTV7ee37120[20]),  20,21},
  {&(_tg__ZTV6dd7120__7ee37120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee37120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee37120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee37120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee37120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee37120[];
extern  VTBL_ENTRY _ZTV7ee37120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37120[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee371203fooEv,_ZTv0_n12_N7ee371203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee371203fooEv,_ZThn24_N7ee371203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee371203fooEv,_ZTv0_n24_N7ee371203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371203fooEv,_ZThn8_N7ee371203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37120 = {  "ee37120", // class name
  bases_ee37120, 4,
  &(vtc_ee37120[0]), // expected_vtbl_contents
  &(vtt_ee37120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee37120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37120),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47120  : dd7120 {
  int e;
  virtual void  bar(); // _ZN7ee471203barEv
  ~ee47120(); // tgen
  ee47120(); // tgen
};
//SIG(1 ee47120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47120 ::bar(){vfunc_called(this, "_ZN7ee471203barEv");}
ee47120 ::~ee47120(){ note_dtor("ee47120", this);} // tgen
ee47120 ::ee47120(){ note_ctor("ee47120", this);} // tgen

static void Test_ee47120()
{
  extern Class_Descriptor cd_ee47120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee47120, buf);
    ee47120 *dp, &lv = *(dp=new (buf) ee47120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee47120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee47120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee47120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(16,12), "ee47120");
    check_base_class_offset(lv, (dd7120*), 0, "ee47120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47120.e");
    test_class_info(&lv, &cd_ee47120);
    dp->~ee47120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47120(Test_ee47120, "ee47120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee47120C1Ev();
extern void _ZN7ee47120D1Ev();
Name_Map name_map_ee47120[] = {
  NSPAIR(_ZN7ee47120C1Ev),
  NSPAIR(_ZN7ee47120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee47120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47120[];
extern void _ZN7ee471203barEv();
extern void _ZN6dd71203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee47120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47120[0]),
  (VTBL_ENTRY)&_ZN7ee471203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee47120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
extern VTBL_ENTRY _ZTV7ee47120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee47120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee47120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee47120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee47120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee47120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee47120[] = {
  {&(_ZTV7ee47120[4]),  4,13},
  {&(_tg__ZTV6dd7120__7ee47120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee47120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee47120[3]),  3,4},
  {&(_ZTV7ee47120[9]),  9,13},
  {&(_ZTV7ee47120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee47120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee47120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee47120[];
extern  VTBL_ENTRY _ZTV7ee47120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47120[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee47120 = {  "ee47120", // class name
  bases_ee47120, 4,
  &(vtc_ee47120[0]), // expected_vtbl_contents
  &(vtt_ee47120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee47120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57120  : virtual dd7120 {
  int e;
  virtual void  bar(); // _ZN7ee571203barEv
  ~ee57120(); // tgen
  ee57120(); // tgen
};
//SIG(1 ee57120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v2 Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57120 ::bar(){vfunc_called(this, "_ZN7ee571203barEv");}
ee57120 ::~ee57120(){ note_dtor("ee57120", this);} // tgen
ee57120 ::ee57120(){ note_ctor("ee57120", this);} // tgen

static void Test_ee57120()
{
  extern Class_Descriptor cd_ee57120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee57120, buf);
    ee57120 *dp, &lv = *(dp=new (buf) ee57120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee57120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee57120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee57120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(32,16), "ee57120");
    check_base_class_offset(lv, (dd7120*), ABISELECT(16,8), "ee57120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57120.e");
    test_class_info(&lv, &cd_ee57120);
    dp->~ee57120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57120(Test_ee57120, "ee57120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee57120C1Ev();
extern void _ZN7ee57120D1Ev();
Name_Map name_map_ee57120[] = {
  NSPAIR(_ZN7ee57120C1Ev),
  NSPAIR(_ZN7ee57120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee57120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57120[];
extern void _ZN7ee571203barEv();
extern void ABISELECT(_ZTv0_n40_N7ee571203barEv,_ZTv0_n20_N7ee571203barEv)();
extern void ABISELECT(_ZThn16_N7ee571203barEv,_ZThn8_N7ee571203barEv)() __attribute__((weak));
extern void _ZN6dd71203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee57120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57120[0]),
  (VTBL_ENTRY)&_ZN7ee571203barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee571203barEv,_ZTv0_n20_N7ee571203barEv),
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57120[0]),
  ABISELECT(-32,-16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee57120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
extern VTBL_ENTRY _ZTV7ee57120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee57120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee57120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee57120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee57120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee57120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee57120[] = {
  {&(_ZTV7ee57120[5]),  5,21},
  {&(_ZTV7ee57120[12]),  12,21},
  {&(_ZTV7ee57120[17]),  17,21},
  {&(_ZTV7ee57120[20]),  20,21},
  {&(_tg__ZTV6dd7120__7ee57120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee57120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee57120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee57120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee57120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee57120[];
extern  VTBL_ENTRY _ZTV7ee57120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57120[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee571203barEv,_ZTv0_n20_N7ee571203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571203barEv,_ZThn8_N7ee571203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57120 = {  "ee57120", // class name
  bases_ee57120, 4,
  &(vtc_ee57120[0]), // expected_vtbl_contents
  &(vtt_ee57120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee57120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57120),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67120  : dd7120 {
  int e;
  virtual void  foo(); // _ZN7ee671203fooEv
  virtual void  bar(); // _ZN7ee671203barEv
  ~ee67120(); // tgen
  ee67120(); // tgen
};
//SIG(1 ee67120) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67120 ::foo(){vfunc_called(this, "_ZN7ee671203fooEv");}
void  ee67120 ::bar(){vfunc_called(this, "_ZN7ee671203barEv");}
ee67120 ::~ee67120(){ note_dtor("ee67120", this);} // tgen
ee67120 ::ee67120(){ note_ctor("ee67120", this);} // tgen

static void Test_ee67120()
{
  extern Class_Descriptor cd_ee67120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee67120, buf);
    ee67120 *dp, &lv = *(dp=new (buf) ee67120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee67120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(40,24), "ee67120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(32,20), "ee67120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(16,12), "ee67120");
    check_base_class_offset(lv, (dd7120*), 0, "ee67120");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67120.e");
    test_class_info(&lv, &cd_ee67120);
    dp->~ee67120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67120(Test_ee67120, "ee67120", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee67120C1Ev();
extern void _ZN7ee67120D1Ev();
Name_Map name_map_ee67120[] = {
  NSPAIR(_ZN7ee67120C1Ev),
  NSPAIR(_ZN7ee67120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee67120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67120[];
extern void _ZN7ee671203barEv();
extern void _ZN7ee671203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee671203fooEv,_ZTv0_n12_N7ee671203fooEv)();
extern void ABISELECT(_ZThn32_N7ee671203fooEv,_ZThn20_N7ee671203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee67120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67120[0]),
  (VTBL_ENTRY)&_ZN7ee671203barEv,
  (VTBL_ENTRY)&_ZN7ee671203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67120[0]),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee67120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee671203fooEv,_ZTv0_n12_N7ee671203fooEv),
};
extern VTBL_ENTRY _ZTV7ee67120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee67120[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee67120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee67120[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee67120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee67120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee67120[] = {
  {&(_ZTV7ee67120[4]),  4,13},
  {&(_tg__ZTV6dd7120__7ee67120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee67120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee67120[3]),  3,4},
  {&(_ZTV7ee67120[9]),  9,13},
  {&(_ZTV7ee67120[12]),  12,13},
  {&(_tg__ZTV5cc120__7ee67120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee67120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee67120[];
extern  VTBL_ENTRY _ZTV7ee67120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67120[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn20_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee671203fooEv,_ZTv0_n12_N7ee671203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee671203fooEv,_ZThn20_N7ee671203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee67120 = {  "ee67120", // class name
  bases_ee67120, 4,
  &(vtc_ee67120[0]), // expected_vtbl_contents
  &(vtt_ee67120[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee67120),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67120),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67120),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77120  : virtual dd7120 {
  int e;
  virtual void  foo(); // _ZN7ee771203fooEv
  virtual void  bar(); // _ZN7ee771203barEv
  ~ee77120(); // tgen
  ee77120(); // tgen
};
//SIG(1 ee77120) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} v1 Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77120 ::foo(){vfunc_called(this, "_ZN7ee771203fooEv");}
void  ee77120 ::bar(){vfunc_called(this, "_ZN7ee771203barEv");}
ee77120 ::~ee77120(){ note_dtor("ee77120", this);} // tgen
ee77120 ::ee77120(){ note_ctor("ee77120", this);} // tgen

static void Test_ee77120()
{
  extern Class_Descriptor cd_ee77120;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee77120, buf);
    ee77120 *dp, &lv = *(dp=new (buf) ee77120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee77120)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77120)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(56,28), "ee77120");
    check_base_class_offset(lv, (bb20*)(cc120*), ABISELECT(48,24), "ee77120");
    check_base_class_offset(lv, (cc120*)(dd7120*), ABISELECT(32,16), "ee77120");
    check_base_class_offset(lv, (dd7120*), ABISELECT(16,8), "ee77120");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77120.e");
    test_class_info(&lv, &cd_ee77120);
    dp->~ee77120();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77120(Test_ee77120, "ee77120", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee77120C1Ev();
extern void _ZN7ee77120D1Ev();
Name_Map name_map_ee77120[] = {
  NSPAIR(_ZN7ee77120C1Ev),
  NSPAIR(_ZN7ee77120D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc120;
extern VTBL_ENTRY _ZTI5cc120[];
extern  VTBL_ENTRY _ZTV5cc120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc120[];
extern Class_Descriptor cd_dd7120;
extern VTBL_ENTRY _ZTI6dd7120[];
extern  VTBL_ENTRY _ZTV6dd7120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7120[];
static Base_Class bases_ee77120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc120,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7120,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77120[];
extern void _ZN7ee771203fooEv();
extern void _ZN7ee771203barEv();
extern void ABISELECT(_ZTv0_n40_N7ee771203barEv,_ZTv0_n20_N7ee771203barEv)();
extern void ABISELECT(_ZThn16_N7ee771203barEv,_ZThn8_N7ee771203barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee771203fooEv,_ZTv0_n24_N7ee771203fooEv)();
extern void ABISELECT(_ZThn16_N7ee771203fooEv,_ZThn8_N7ee771203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee771203fooEv,_ZTv0_n12_N7ee771203fooEv)();
extern void ABISELECT(_ZThn48_N7ee771203fooEv,_ZThn24_N7ee771203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77120[] = {
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77120[0]),
  (VTBL_ENTRY)&_ZN7ee771203fooEv,
  (VTBL_ENTRY)&_ZN7ee771203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee771203barEv,_ZTv0_n20_N7ee771203barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771203fooEv,_ZTv0_n24_N7ee771203fooEv),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77120[0]),
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee77120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee771203fooEv,_ZTv0_n12_N7ee771203fooEv),
};
extern VTBL_ENTRY _ZTV7ee77120[];
extern void _ZN6dd71203barEv();
extern void _ZN6dd71203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7120__7ee77120[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&_ZN6dd71203barEv,
  (VTBL_ENTRY)&_ZN6dd71203fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc120__6dd7120__7ee77120[] = {
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
};
extern void ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv)();
extern void ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb20__6dd7120__7ee77120[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7120[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv),
};
static  VTBL_ENTRY _tg__ZTV5cc120__7ee77120[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
};
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY _tg__ZTV4bb20__5cc120__7ee77120[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc120[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
static  VTT_ENTRY vtt_ee77120[] = {
  {&(_ZTV7ee77120[5]),  5,22},
  {&(_ZTV7ee77120[13]),  13,22},
  {&(_ZTV7ee77120[18]),  18,22},
  {&(_ZTV7ee77120[21]),  21,22},
  {&(_tg__ZTV6dd7120__7ee77120[4]),  4,6},
  {&(_tg__ZTV5cc120__6dd7120__7ee77120[3]),  3,3},
  {&(_tg__ZTV4bb20__6dd7120__7ee77120[3]),  3,4},
  {&(_tg__ZTV5cc120__7ee77120[3]),  3,3},
  {&(_tg__ZTV4bb20__5cc120__7ee77120[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee77120[];
extern  VTBL_ENTRY _ZTV7ee77120[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77120[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd71203fooEv,_ZTv0_n12_N6dd71203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N6dd71203fooEv,_ZThn16_N6dd71203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee771203fooEv,_ZTv0_n12_N7ee771203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N7ee771203fooEv,_ZThn24_N7ee771203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771203fooEv,_ZTv0_n24_N7ee771203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771203fooEv,_ZThn8_N7ee771203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee771203barEv,_ZTv0_n20_N7ee771203barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771203barEv,_ZThn8_N7ee771203barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77120 = {  "ee77120", // class name
  bases_ee77120, 4,
  &(vtc_ee77120[0]), // expected_vtbl_contents
  &(vtt_ee77120[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee77120),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77120),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77120),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc220  : bb20 {
  int c;
  virtual void  foo(); // _ZN5cc2203fooEv
  ~cc220(); // tgen
  cc220(); // tgen
};
//SIG(-1 cc220) C1{ BC2{ BC3{ Fi} v1 Fi} v1 Fi}


void  cc220 ::foo(){vfunc_called(this, "_ZN5cc2203fooEv");}
cc220 ::~cc220(){ note_dtor("cc220", this);} // tgen
cc220 ::cc220(){ note_ctor("cc220", this);} // tgen

static void Test_cc220()
{
  extern Class_Descriptor cd_cc220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc220, buf);
    cc220 *dp, &lv = *(dp=new (buf) cc220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc220)");
    check_base_class_offset(lv, (aa0*)(bb20*), ABISELECT(8,4), "cc220");
    check_base_class_offset(lv, (bb20*), 0, "cc220");
    check_field_offset(lv, c, ABISELECT(16,12), "cc220.c");
    test_class_info(&lv, &cd_cc220);
    dp->~cc220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc220(Test_cc220, "cc220", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc220C1Ev();
extern void _ZN5cc220D1Ev();
Name_Map name_map_cc220[] = {
  NSPAIR(_ZN5cc220C1Ev),
  NSPAIR(_ZN5cc220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
static Base_Class bases_cc220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc220[];
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_cc220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5cc220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
Class_Descriptor cd_cc220 = {  "cc220", // class name
  bases_cc220, 2,
  &(vtc_cc220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc220),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0220  : cc220 {
  int d;
  ~dd0220(); // tgen
  dd0220(); // tgen
};
//SIG(-1 dd0220) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} v1 Fi} Fi}


dd0220 ::~dd0220(){ note_dtor("dd0220", this);} // tgen
dd0220 ::dd0220(){ note_ctor("dd0220", this);} // tgen

static void Test_dd0220()
{
  extern Class_Descriptor cd_dd0220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0220, buf);
    dd0220 *dp, &lv = *(dp=new (buf) dd0220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(8,4), "dd0220");
    check_base_class_offset(lv, (bb20*)(cc220*), 0, "dd0220");
    check_base_class_offset(lv, (cc220*), 0, "dd0220");
    check_field_offset(lv, d, ABISELECT(20,16), "dd0220.d");
    test_class_info(&lv, &cd_dd0220);
    dp->~dd0220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0220(Test_dd0220, "dd0220", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0220C1Ev();
extern void _ZN6dd0220D1Ev();
Name_Map name_map_dd0220[] = {
  NSPAIR(_ZN6dd0220C1Ev),
  NSPAIR(_ZN6dd0220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
static Base_Class bases_dd0220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0220[];
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_dd0220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd0220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
Class_Descriptor cd_dd0220 = {  "dd0220", // class name
  bases_dd0220, 3,
  &(vtc_dd0220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0220),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00220  : dd0220 {
  int e;
  ~ee00220(); // tgen
  ee00220(); // tgen
};
//SIG(1 ee00220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee00220 ::~ee00220(){ note_dtor("ee00220", this);} // tgen
ee00220 ::ee00220(){ note_ctor("ee00220", this);} // tgen

static void Test_ee00220()
{
  extern Class_Descriptor cd_ee00220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00220, buf);
    ee00220 *dp, &lv = *(dp=new (buf) ee00220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(8,4), "ee00220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), 0, "ee00220");
    check_base_class_offset(lv, (cc220*)(dd0220*), 0, "ee00220");
    check_base_class_offset(lv, (dd0220*), 0, "ee00220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee00220.e");
    test_class_info(&lv, &cd_ee00220);
    dp->~ee00220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00220(Test_ee00220, "ee00220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00220C1Ev();
extern void _ZN7ee00220D1Ev();
Name_Map name_map_ee00220[] = {
  NSPAIR(_ZN7ee00220C1Ev),
  NSPAIR(_ZN7ee00220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee00220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00220[];
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_ee00220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee00220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTI7ee00220[];
extern  VTBL_ENTRY _ZTV7ee00220[];
Class_Descriptor cd_ee00220 = {  "ee00220", // class name
  bases_ee00220, 4,
  &(vtc_ee00220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00220),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10220  : virtual dd0220 {
  int e;
  ~ee10220(); // tgen
  ee10220(); // tgen
};
//SIG(1 ee10220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee10220 ::~ee10220(){ note_dtor("ee10220", this);} // tgen
ee10220 ::ee10220(){ note_ctor("ee10220", this);} // tgen

static void Test_ee10220()
{
  extern Class_Descriptor cd_ee10220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10220, buf);
    ee10220 *dp, &lv = *(dp=new (buf) ee10220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(24,12), "ee10220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), ABISELECT(16,8), "ee10220");
    check_base_class_offset(lv, (cc220*)(dd0220*), ABISELECT(16,8), "ee10220");
    check_base_class_offset(lv, (dd0220*), ABISELECT(16,8), "ee10220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10220.e");
    test_class_info(&lv, &cd_ee10220);
    dp->~ee10220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10220(Test_ee10220, "ee10220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10220C1Ev();
extern void _ZN7ee10220D1Ev();
Name_Map name_map_ee10220[] = {
  NSPAIR(_ZN7ee10220C1Ev),
  NSPAIR(_ZN7ee10220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee10220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10220[];
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_ee10220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10220[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTV7ee10220[];
static  VTT_ENTRY vtt_ee10220[] = {
  {&(_ZTV7ee10220[3]),  3,7},
  {&(_ZTV7ee10220[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee10220[];
extern  VTBL_ENTRY _ZTV7ee10220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10220[];
Class_Descriptor cd_ee10220 = {  "ee10220", // class name
  bases_ee10220, 4,
  &(vtc_ee10220[0]), // expected_vtbl_contents
  &(vtt_ee10220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10220),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20220  : dd0220 {
  int e;
  virtual void  foo(); // _ZN7ee202203fooEv
  ~ee20220(); // tgen
  ee20220(); // tgen
};
//SIG(1 ee20220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee20220 ::foo(){vfunc_called(this, "_ZN7ee202203fooEv");}
ee20220 ::~ee20220(){ note_dtor("ee20220", this);} // tgen
ee20220 ::ee20220(){ note_ctor("ee20220", this);} // tgen

static void Test_ee20220()
{
  extern Class_Descriptor cd_ee20220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20220, buf);
    ee20220 *dp, &lv = *(dp=new (buf) ee20220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(8,4), "ee20220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), 0, "ee20220");
    check_base_class_offset(lv, (cc220*)(dd0220*), 0, "ee20220");
    check_base_class_offset(lv, (dd0220*), 0, "ee20220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20220.e");
    test_class_info(&lv, &cd_ee20220);
    dp->~ee20220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20220(Test_ee20220, "ee20220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20220C1Ev();
extern void _ZN7ee20220D1Ev();
Name_Map name_map_ee20220[] = {
  NSPAIR(_ZN7ee20220C1Ev),
  NSPAIR(_ZN7ee20220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee20220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20220[];
extern void _ZN7ee202203fooEv();
static  VTBL_ENTRY vtc_ee20220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20220[0]),
  (VTBL_ENTRY)&_ZN7ee202203fooEv,
};
extern VTBL_ENTRY _ZTI7ee20220[];
extern  VTBL_ENTRY _ZTV7ee20220[];
Class_Descriptor cd_ee20220 = {  "ee20220", // class name
  bases_ee20220, 4,
  &(vtc_ee20220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20220),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30220  : virtual dd0220 {
  int e;
  virtual void  foo(); // _ZN7ee302203fooEv
  ~ee30220(); // tgen
  ee30220(); // tgen
};
//SIG(1 ee30220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee30220 ::foo(){vfunc_called(this, "_ZN7ee302203fooEv");}
ee30220 ::~ee30220(){ note_dtor("ee30220", this);} // tgen
ee30220 ::ee30220(){ note_ctor("ee30220", this);} // tgen

static void Test_ee30220()
{
  extern Class_Descriptor cd_ee30220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30220, buf);
    ee30220 *dp, &lv = *(dp=new (buf) ee30220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(24,12), "ee30220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), ABISELECT(16,8), "ee30220");
    check_base_class_offset(lv, (cc220*)(dd0220*), ABISELECT(16,8), "ee30220");
    check_base_class_offset(lv, (dd0220*), ABISELECT(16,8), "ee30220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30220.e");
    test_class_info(&lv, &cd_ee30220);
    dp->~ee30220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30220(Test_ee30220, "ee30220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30220C1Ev();
extern void _ZN7ee30220D1Ev();
Name_Map name_map_ee30220[] = {
  NSPAIR(_ZN7ee30220C1Ev),
  NSPAIR(_ZN7ee30220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee30220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30220[];
extern void _ZN7ee302203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee302203fooEv,_ZTv0_n12_N7ee302203fooEv)();
extern void ABISELECT(_ZThn16_N7ee302203fooEv,_ZThn8_N7ee302203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30220[0]),
  (VTBL_ENTRY)&_ZN7ee302203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee302203fooEv,_ZTv0_n12_N7ee302203fooEv),
};
extern VTBL_ENTRY _ZTV7ee30220[];
static  VTT_ENTRY vtt_ee30220[] = {
  {&(_ZTV7ee30220[3]),  3,8},
  {&(_ZTV7ee30220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee30220[];
extern  VTBL_ENTRY _ZTV7ee30220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30220[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee302203fooEv,_ZTv0_n12_N7ee302203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302203fooEv,_ZThn8_N7ee302203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30220 = {  "ee30220", // class name
  bases_ee30220, 4,
  &(vtc_ee30220[0]), // expected_vtbl_contents
  &(vtt_ee30220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40220  : dd0220 {
  int e;
  virtual void  bar(); // _ZN7ee402203barEv
  ~ee40220(); // tgen
  ee40220(); // tgen
};
//SIG(1 ee40220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee40220 ::bar(){vfunc_called(this, "_ZN7ee402203barEv");}
ee40220 ::~ee40220(){ note_dtor("ee40220", this);} // tgen
ee40220 ::ee40220(){ note_ctor("ee40220", this);} // tgen

static void Test_ee40220()
{
  extern Class_Descriptor cd_ee40220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40220, buf);
    ee40220 *dp, &lv = *(dp=new (buf) ee40220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(8,4), "ee40220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), 0, "ee40220");
    check_base_class_offset(lv, (cc220*)(dd0220*), 0, "ee40220");
    check_base_class_offset(lv, (dd0220*), 0, "ee40220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40220.e");
    test_class_info(&lv, &cd_ee40220);
    dp->~ee40220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40220(Test_ee40220, "ee40220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40220C1Ev();
extern void _ZN7ee40220D1Ev();
Name_Map name_map_ee40220[] = {
  NSPAIR(_ZN7ee40220C1Ev),
  NSPAIR(_ZN7ee40220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee40220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40220[];
extern void _ZN5cc2203fooEv();
extern void _ZN7ee402203barEv();
static  VTBL_ENTRY vtc_ee40220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
  (VTBL_ENTRY)&_ZN7ee402203barEv,
};
extern VTBL_ENTRY _ZTI7ee40220[];
extern  VTBL_ENTRY _ZTV7ee40220[];
Class_Descriptor cd_ee40220 = {  "ee40220", // class name
  bases_ee40220, 4,
  &(vtc_ee40220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50220  : virtual dd0220 {
  int e;
  virtual void  bar(); // _ZN7ee502203barEv
  ~ee50220(); // tgen
  ee50220(); // tgen
};
//SIG(1 ee50220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee50220 ::bar(){vfunc_called(this, "_ZN7ee502203barEv");}
ee50220 ::~ee50220(){ note_dtor("ee50220", this);} // tgen
ee50220 ::ee50220(){ note_ctor("ee50220", this);} // tgen

static void Test_ee50220()
{
  extern Class_Descriptor cd_ee50220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50220, buf);
    ee50220 *dp, &lv = *(dp=new (buf) ee50220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(24,12), "ee50220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), ABISELECT(16,8), "ee50220");
    check_base_class_offset(lv, (cc220*)(dd0220*), ABISELECT(16,8), "ee50220");
    check_base_class_offset(lv, (dd0220*), ABISELECT(16,8), "ee50220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50220.e");
    test_class_info(&lv, &cd_ee50220);
    dp->~ee50220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50220(Test_ee50220, "ee50220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50220C1Ev();
extern void _ZN7ee50220D1Ev();
Name_Map name_map_ee50220[] = {
  NSPAIR(_ZN7ee50220C1Ev),
  NSPAIR(_ZN7ee50220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee50220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50220[];
extern void _ZN7ee502203barEv();
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_ee50220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50220[0]),
  (VTBL_ENTRY)&_ZN7ee502203barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTV7ee50220[];
static  VTT_ENTRY vtt_ee50220[] = {
  {&(_ZTV7ee50220[3]),  3,8},
  {&(_ZTV7ee50220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee50220[];
extern  VTBL_ENTRY _ZTV7ee50220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50220[];
Class_Descriptor cd_ee50220 = {  "ee50220", // class name
  bases_ee50220, 4,
  &(vtc_ee50220[0]), // expected_vtbl_contents
  &(vtt_ee50220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60220  : dd0220 {
  int e;
  virtual void  foo(); // _ZN7ee602203fooEv
  virtual void  bar(); // _ZN7ee602203barEv
  ~ee60220(); // tgen
  ee60220(); // tgen
};
//SIG(1 ee60220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee60220 ::foo(){vfunc_called(this, "_ZN7ee602203fooEv");}
void  ee60220 ::bar(){vfunc_called(this, "_ZN7ee602203barEv");}
ee60220 ::~ee60220(){ note_dtor("ee60220", this);} // tgen
ee60220 ::ee60220(){ note_ctor("ee60220", this);} // tgen

static void Test_ee60220()
{
  extern Class_Descriptor cd_ee60220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60220, buf);
    ee60220 *dp, &lv = *(dp=new (buf) ee60220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(8,4), "ee60220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), 0, "ee60220");
    check_base_class_offset(lv, (cc220*)(dd0220*), 0, "ee60220");
    check_base_class_offset(lv, (dd0220*), 0, "ee60220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60220.e");
    test_class_info(&lv, &cd_ee60220);
    dp->~ee60220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60220(Test_ee60220, "ee60220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60220C1Ev();
extern void _ZN7ee60220D1Ev();
Name_Map name_map_ee60220[] = {
  NSPAIR(_ZN7ee60220C1Ev),
  NSPAIR(_ZN7ee60220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee60220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60220[];
extern void _ZN7ee602203fooEv();
extern void _ZN7ee602203barEv();
static  VTBL_ENTRY vtc_ee60220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60220[0]),
  (VTBL_ENTRY)&_ZN7ee602203fooEv,
  (VTBL_ENTRY)&_ZN7ee602203barEv,
};
extern VTBL_ENTRY _ZTI7ee60220[];
extern  VTBL_ENTRY _ZTV7ee60220[];
Class_Descriptor cd_ee60220 = {  "ee60220", // class name
  bases_ee60220, 4,
  &(vtc_ee60220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70220  : virtual dd0220 {
  int e;
  virtual void  foo(); // _ZN7ee702203fooEv
  virtual void  bar(); // _ZN7ee702203barEv
  ~ee70220(); // tgen
  ee70220(); // tgen
};
//SIG(1 ee70220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee70220 ::foo(){vfunc_called(this, "_ZN7ee702203fooEv");}
void  ee70220 ::bar(){vfunc_called(this, "_ZN7ee702203barEv");}
ee70220 ::~ee70220(){ note_dtor("ee70220", this);} // tgen
ee70220 ::ee70220(){ note_ctor("ee70220", this);} // tgen

static void Test_ee70220()
{
  extern Class_Descriptor cd_ee70220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70220, buf);
    ee70220 *dp, &lv = *(dp=new (buf) ee70220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd0220*), ABISELECT(24,12), "ee70220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd0220*), ABISELECT(16,8), "ee70220");
    check_base_class_offset(lv, (cc220*)(dd0220*), ABISELECT(16,8), "ee70220");
    check_base_class_offset(lv, (dd0220*), ABISELECT(16,8), "ee70220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70220.e");
    test_class_info(&lv, &cd_ee70220);
    dp->~ee70220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70220(Test_ee70220, "ee70220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70220C1Ev();
extern void _ZN7ee70220D1Ev();
Name_Map name_map_ee70220[] = {
  NSPAIR(_ZN7ee70220C1Ev),
  NSPAIR(_ZN7ee70220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd0220;
extern VTBL_ENTRY _ZTI6dd0220[];
extern  VTBL_ENTRY _ZTV6dd0220[];
static Base_Class bases_ee70220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70220[];
extern void _ZN7ee702203fooEv();
extern void _ZN7ee702203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee702203fooEv,_ZTv0_n12_N7ee702203fooEv)();
extern void ABISELECT(_ZThn16_N7ee702203fooEv,_ZThn8_N7ee702203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70220[0]),
  (VTBL_ENTRY)&_ZN7ee702203fooEv,
  (VTBL_ENTRY)&_ZN7ee702203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee702203fooEv,_ZTv0_n12_N7ee702203fooEv),
};
extern VTBL_ENTRY _ZTV7ee70220[];
static  VTT_ENTRY vtt_ee70220[] = {
  {&(_ZTV7ee70220[3]),  3,9},
  {&(_ZTV7ee70220[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee70220[];
extern  VTBL_ENTRY _ZTV7ee70220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70220[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee702203fooEv,_ZTv0_n12_N7ee702203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702203fooEv,_ZThn8_N7ee702203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70220 = {  "ee70220", // class name
  bases_ee70220, 4,
  &(vtc_ee70220[0]), // expected_vtbl_contents
  &(vtt_ee70220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70220),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1220  : virtual cc220 {
  int d;
  ~dd1220(); // tgen
  dd1220(); // tgen
};
//SIG(-1 dd1220) C1{ VBC2{ BC3{ BC4{ Fi} v1 Fi} v1 Fi} Fi}


dd1220 ::~dd1220(){ note_dtor("dd1220", this);} // tgen
dd1220 ::dd1220(){ note_ctor("dd1220", this);} // tgen

static void Test_dd1220()
{
  extern Class_Descriptor cd_dd1220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1220, buf);
    dd1220 *dp, &lv = *(dp=new (buf) dd1220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,12), "dd1220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,8), "dd1220");
    check_base_class_offset(lv, (cc220*), ABISELECT(16,8), "dd1220");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1220.d");
    test_class_info(&lv, &cd_dd1220);
    dp->~dd1220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1220(Test_dd1220, "dd1220", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1220C1Ev();
extern void _ZN6dd1220D1Ev();
Name_Map name_map_dd1220[] = {
  NSPAIR(_ZN6dd1220C1Ev),
  NSPAIR(_ZN6dd1220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
static Base_Class bases_dd1220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1220[];
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_dd1220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTV6dd1220[];
static  VTT_ENTRY vtt_dd1220[] = {
  {&(_ZTV6dd1220[3]),  3,7},
  {&(_ZTV6dd1220[6]),  6,7},
};
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
Class_Descriptor cd_dd1220 = {  "dd1220", // class name
  bases_dd1220, 3,
  &(vtc_dd1220[0]), // expected_vtbl_contents
  &(vtt_dd1220[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1220),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1220),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01220  : dd1220 {
  int e;
  ~ee01220(); // tgen
  ee01220(); // tgen
};
//SIG(1 ee01220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee01220 ::~ee01220(){ note_dtor("ee01220", this);} // tgen
ee01220 ::ee01220(){ note_ctor("ee01220", this);} // tgen

static void Test_ee01220()
{
  extern Class_Descriptor cd_ee01220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01220, buf);
    ee01220 *dp, &lv = *(dp=new (buf) ee01220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee01220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee01220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(16,12), "ee01220");
    check_base_class_offset(lv, (dd1220*), 0, "ee01220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01220.e");
    test_class_info(&lv, &cd_ee01220);
    dp->~ee01220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01220(Test_ee01220, "ee01220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01220C1Ev();
extern void _ZN7ee01220D1Ev();
Name_Map name_map_ee01220[] = {
  NSPAIR(_ZN7ee01220C1Ev),
  NSPAIR(_ZN7ee01220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee01220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01220[];
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_ee01220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01220[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTV7ee01220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee01220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee01220[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee01220[] = {
  {&(_ZTV7ee01220[3]),  3,7},
  {&(_tg__ZTV6dd1220__7ee01220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee01220[3]),  3,4},
  {&(_ZTV7ee01220[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee01220[];
extern  VTBL_ENTRY _ZTV7ee01220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01220[];
Class_Descriptor cd_ee01220 = {  "ee01220", // class name
  bases_ee01220, 4,
  &(vtc_ee01220[0]), // expected_vtbl_contents
  &(vtt_ee01220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01220),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11220  : virtual dd1220 {
  int e;
  ~ee11220(); // tgen
  ee11220(); // tgen
};
//SIG(1 ee11220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} Fi}


ee11220 ::~ee11220(){ note_dtor("ee11220", this);} // tgen
ee11220 ::ee11220(){ note_ctor("ee11220", this);} // tgen

static void Test_ee11220()
{
  extern Class_Descriptor cd_ee11220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11220, buf);
    ee11220 *dp, &lv = *(dp=new (buf) ee11220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee11220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee11220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(32,16), "ee11220");
    check_base_class_offset(lv, (dd1220*), ABISELECT(16,8), "ee11220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11220.e");
    test_class_info(&lv, &cd_ee11220);
    dp->~ee11220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11220(Test_ee11220, "ee11220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11220C1Ev();
extern void _ZN7ee11220D1Ev();
Name_Map name_map_ee11220[] = {
  NSPAIR(_ZN7ee11220C1Ev),
  NSPAIR(_ZN7ee11220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee11220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11220[];
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_ee11220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11220[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11220[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTV7ee11220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee11220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee11220[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee11220[] = {
  {&(_ZTV7ee11220[4]),  4,11},
  {&(_ZTV7ee11220[7]),  7,11},
  {&(_ZTV7ee11220[10]),  10,11},
  {&(_tg__ZTV6dd1220__7ee11220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee11220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11220[];
extern  VTBL_ENTRY _ZTV7ee11220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11220[];
Class_Descriptor cd_ee11220 = {  "ee11220", // class name
  bases_ee11220, 4,
  &(vtc_ee11220[0]), // expected_vtbl_contents
  &(vtt_ee11220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11220),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21220  : dd1220 {
  int e;
  virtual void  foo(); // _ZN7ee212203fooEv
  ~ee21220(); // tgen
  ee21220(); // tgen
};
//SIG(1 ee21220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee21220 ::foo(){vfunc_called(this, "_ZN7ee212203fooEv");}
ee21220 ::~ee21220(){ note_dtor("ee21220", this);} // tgen
ee21220 ::ee21220(){ note_ctor("ee21220", this);} // tgen

static void Test_ee21220()
{
  extern Class_Descriptor cd_ee21220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21220, buf);
    ee21220 *dp, &lv = *(dp=new (buf) ee21220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee21220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee21220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(16,12), "ee21220");
    check_base_class_offset(lv, (dd1220*), 0, "ee21220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21220.e");
    test_class_info(&lv, &cd_ee21220);
    dp->~ee21220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21220(Test_ee21220, "ee21220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21220C1Ev();
extern void _ZN7ee21220D1Ev();
Name_Map name_map_ee21220[] = {
  NSPAIR(_ZN7ee21220C1Ev),
  NSPAIR(_ZN7ee21220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee21220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21220[];
extern void _ZN7ee212203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee212203fooEv,_ZTv0_n12_N7ee212203fooEv)();
extern void ABISELECT(_ZThn16_N7ee212203fooEv,_ZThn12_N7ee212203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21220[0]),
  (VTBL_ENTRY)&_ZN7ee212203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee212203fooEv,_ZTv0_n12_N7ee212203fooEv),
};
extern VTBL_ENTRY _ZTV7ee21220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee21220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee21220[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee21220[] = {
  {&(_ZTV7ee21220[3]),  3,8},
  {&(_tg__ZTV6dd1220__7ee21220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee21220[3]),  3,4},
  {&(_ZTV7ee21220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee21220[];
extern  VTBL_ENTRY _ZTV7ee21220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21220[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee212203fooEv,_ZTv0_n12_N7ee212203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee212203fooEv,_ZThn12_N7ee212203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21220 = {  "ee21220", // class name
  bases_ee21220, 4,
  &(vtc_ee21220[0]), // expected_vtbl_contents
  &(vtt_ee21220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31220  : virtual dd1220 {
  int e;
  virtual void  foo(); // _ZN7ee312203fooEv
  ~ee31220(); // tgen
  ee31220(); // tgen
};
//SIG(1 ee31220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 Fi}


void  ee31220 ::foo(){vfunc_called(this, "_ZN7ee312203fooEv");}
ee31220 ::~ee31220(){ note_dtor("ee31220", this);} // tgen
ee31220 ::ee31220(){ note_ctor("ee31220", this);} // tgen

static void Test_ee31220()
{
  extern Class_Descriptor cd_ee31220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31220, buf);
    ee31220 *dp, &lv = *(dp=new (buf) ee31220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee31220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee31220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(32,16), "ee31220");
    check_base_class_offset(lv, (dd1220*), ABISELECT(16,8), "ee31220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31220.e");
    test_class_info(&lv, &cd_ee31220);
    dp->~ee31220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31220(Test_ee31220, "ee31220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31220C1Ev();
extern void _ZN7ee31220D1Ev();
Name_Map name_map_ee31220[] = {
  NSPAIR(_ZN7ee31220C1Ev),
  NSPAIR(_ZN7ee31220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee31220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31220[];
extern void _ZN7ee312203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee312203fooEv,_ZTv0_n12_N7ee312203fooEv)();
extern void ABISELECT(_ZThn32_N7ee312203fooEv,_ZThn16_N7ee312203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31220[0]),
  (VTBL_ENTRY)&_ZN7ee312203fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31220[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee312203fooEv,_ZTv0_n12_N7ee312203fooEv),
};
extern VTBL_ENTRY _ZTV7ee31220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee31220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee31220[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee31220[] = {
  {&(_ZTV7ee31220[4]),  4,12},
  {&(_ZTV7ee31220[8]),  8,12},
  {&(_ZTV7ee31220[11]),  11,12},
  {&(_tg__ZTV6dd1220__7ee31220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee31220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31220[];
extern  VTBL_ENTRY _ZTV7ee31220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31220[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee312203fooEv,_ZTv0_n12_N7ee312203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee312203fooEv,_ZThn16_N7ee312203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31220 = {  "ee31220", // class name
  bases_ee31220, 4,
  &(vtc_ee31220[0]), // expected_vtbl_contents
  &(vtt_ee31220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31220),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41220  : dd1220 {
  int e;
  virtual void  bar(); // _ZN7ee412203barEv
  ~ee41220(); // tgen
  ee41220(); // tgen
};
//SIG(1 ee41220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee41220 ::bar(){vfunc_called(this, "_ZN7ee412203barEv");}
ee41220 ::~ee41220(){ note_dtor("ee41220", this);} // tgen
ee41220 ::ee41220(){ note_ctor("ee41220", this);} // tgen

static void Test_ee41220()
{
  extern Class_Descriptor cd_ee41220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41220, buf);
    ee41220 *dp, &lv = *(dp=new (buf) ee41220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee41220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee41220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(16,12), "ee41220");
    check_base_class_offset(lv, (dd1220*), 0, "ee41220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41220.e");
    test_class_info(&lv, &cd_ee41220);
    dp->~ee41220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41220(Test_ee41220, "ee41220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41220C1Ev();
extern void _ZN7ee41220D1Ev();
Name_Map name_map_ee41220[] = {
  NSPAIR(_ZN7ee41220C1Ev),
  NSPAIR(_ZN7ee41220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee41220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41220[];
extern void _ZN7ee412203barEv();
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_ee41220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41220[0]),
  (VTBL_ENTRY)&_ZN7ee412203barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTV7ee41220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee41220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee41220[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee41220[] = {
  {&(_ZTV7ee41220[3]),  3,8},
  {&(_tg__ZTV6dd1220__7ee41220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee41220[3]),  3,4},
  {&(_ZTV7ee41220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee41220[];
extern  VTBL_ENTRY _ZTV7ee41220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41220[];
Class_Descriptor cd_ee41220 = {  "ee41220", // class name
  bases_ee41220, 4,
  &(vtc_ee41220[0]), // expected_vtbl_contents
  &(vtt_ee41220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51220  : virtual dd1220 {
  int e;
  virtual void  bar(); // _ZN7ee512203barEv
  ~ee51220(); // tgen
  ee51220(); // tgen
};
//SIG(1 ee51220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} Fi} v1 Fi}


void  ee51220 ::bar(){vfunc_called(this, "_ZN7ee512203barEv");}
ee51220 ::~ee51220(){ note_dtor("ee51220", this);} // tgen
ee51220 ::ee51220(){ note_ctor("ee51220", this);} // tgen

static void Test_ee51220()
{
  extern Class_Descriptor cd_ee51220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51220, buf);
    ee51220 *dp, &lv = *(dp=new (buf) ee51220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee51220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee51220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(32,16), "ee51220");
    check_base_class_offset(lv, (dd1220*), ABISELECT(16,8), "ee51220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51220.e");
    test_class_info(&lv, &cd_ee51220);
    dp->~ee51220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51220(Test_ee51220, "ee51220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51220C1Ev();
extern void _ZN7ee51220D1Ev();
Name_Map name_map_ee51220[] = {
  NSPAIR(_ZN7ee51220C1Ev),
  NSPAIR(_ZN7ee51220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee51220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51220[];
extern void _ZN7ee512203barEv();
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY vtc_ee51220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51220[0]),
  (VTBL_ENTRY)&_ZN7ee512203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51220[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
extern VTBL_ENTRY _ZTV7ee51220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee51220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee51220[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee51220[] = {
  {&(_ZTV7ee51220[4]),  4,12},
  {&(_ZTV7ee51220[8]),  8,12},
  {&(_ZTV7ee51220[11]),  11,12},
  {&(_tg__ZTV6dd1220__7ee51220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee51220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51220[];
extern  VTBL_ENTRY _ZTV7ee51220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51220[];
Class_Descriptor cd_ee51220 = {  "ee51220", // class name
  bases_ee51220, 4,
  &(vtc_ee51220[0]), // expected_vtbl_contents
  &(vtt_ee51220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51220),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61220  : dd1220 {
  int e;
  virtual void  foo(); // _ZN7ee612203fooEv
  virtual void  bar(); // _ZN7ee612203barEv
  ~ee61220(); // tgen
  ee61220(); // tgen
};
//SIG(1 ee61220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee61220 ::foo(){vfunc_called(this, "_ZN7ee612203fooEv");}
void  ee61220 ::bar(){vfunc_called(this, "_ZN7ee612203barEv");}
ee61220 ::~ee61220(){ note_dtor("ee61220", this);} // tgen
ee61220 ::ee61220(){ note_ctor("ee61220", this);} // tgen

static void Test_ee61220()
{
  extern Class_Descriptor cd_ee61220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61220, buf);
    ee61220 *dp, &lv = *(dp=new (buf) ee61220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee61220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee61220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(16,12), "ee61220");
    check_base_class_offset(lv, (dd1220*), 0, "ee61220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61220.e");
    test_class_info(&lv, &cd_ee61220);
    dp->~ee61220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61220(Test_ee61220, "ee61220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61220C1Ev();
extern void _ZN7ee61220D1Ev();
Name_Map name_map_ee61220[] = {
  NSPAIR(_ZN7ee61220C1Ev),
  NSPAIR(_ZN7ee61220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee61220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61220[];
extern void _ZN7ee612203fooEv();
extern void _ZN7ee612203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee612203fooEv,_ZTv0_n12_N7ee612203fooEv)();
extern void ABISELECT(_ZThn16_N7ee612203fooEv,_ZThn12_N7ee612203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61220[0]),
  (VTBL_ENTRY)&_ZN7ee612203fooEv,
  (VTBL_ENTRY)&_ZN7ee612203barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee612203fooEv,_ZTv0_n12_N7ee612203fooEv),
};
extern VTBL_ENTRY _ZTV7ee61220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee61220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee61220[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee61220[] = {
  {&(_ZTV7ee61220[3]),  3,9},
  {&(_tg__ZTV6dd1220__7ee61220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee61220[3]),  3,4},
  {&(_ZTV7ee61220[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee61220[];
extern  VTBL_ENTRY _ZTV7ee61220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61220[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee612203fooEv,_ZTv0_n12_N7ee612203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612203fooEv,_ZThn12_N7ee612203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61220 = {  "ee61220", // class name
  bases_ee61220, 4,
  &(vtc_ee61220[0]), // expected_vtbl_contents
  &(vtt_ee61220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61220),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71220  : virtual dd1220 {
  int e;
  virtual void  foo(); // _ZN7ee712203fooEv
  virtual void  bar(); // _ZN7ee712203barEv
  ~ee71220(); // tgen
  ee71220(); // tgen
};
//SIG(1 ee71220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee71220 ::foo(){vfunc_called(this, "_ZN7ee712203fooEv");}
void  ee71220 ::bar(){vfunc_called(this, "_ZN7ee712203barEv");}
ee71220 ::~ee71220(){ note_dtor("ee71220", this);} // tgen
ee71220 ::ee71220(){ note_ctor("ee71220", this);} // tgen

static void Test_ee71220()
{
  extern Class_Descriptor cd_ee71220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71220, buf);
    ee71220 *dp, &lv = *(dp=new (buf) ee71220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee71220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee71220");
    check_base_class_offset(lv, (cc220*)(dd1220*), ABISELECT(32,16), "ee71220");
    check_base_class_offset(lv, (dd1220*), ABISELECT(16,8), "ee71220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71220.e");
    test_class_info(&lv, &cd_ee71220);
    dp->~ee71220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71220(Test_ee71220, "ee71220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71220C1Ev();
extern void _ZN7ee71220D1Ev();
Name_Map name_map_ee71220[] = {
  NSPAIR(_ZN7ee71220C1Ev),
  NSPAIR(_ZN7ee71220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd1220;
extern VTBL_ENTRY _ZTI6dd1220[];
extern  VTBL_ENTRY _ZTV6dd1220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1220[];
static Base_Class bases_ee71220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1220,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71220[];
extern void _ZN7ee712203fooEv();
extern void _ZN7ee712203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee712203fooEv,_ZTv0_n12_N7ee712203fooEv)();
extern void ABISELECT(_ZThn32_N7ee712203fooEv,_ZThn16_N7ee712203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71220[0]),
  (VTBL_ENTRY)&_ZN7ee712203fooEv,
  (VTBL_ENTRY)&_ZN7ee712203barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71220[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee712203fooEv,_ZTv0_n12_N7ee712203fooEv),
};
extern VTBL_ENTRY _ZTV7ee71220[];
static  VTBL_ENTRY _tg__ZTV6dd1220__7ee71220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
};
extern void _ZN5cc2203fooEv();
static  VTBL_ENTRY _tg__ZTV5cc220__6dd1220__7ee71220[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
};
static  VTT_ENTRY vtt_ee71220[] = {
  {&(_ZTV7ee71220[4]),  4,13},
  {&(_ZTV7ee71220[9]),  9,13},
  {&(_ZTV7ee71220[12]),  12,13},
  {&(_tg__ZTV6dd1220__7ee71220[3]),  3,3},
  {&(_tg__ZTV5cc220__6dd1220__7ee71220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71220[];
extern  VTBL_ENTRY _ZTV7ee71220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71220[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee712203fooEv,_ZTv0_n12_N7ee712203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712203fooEv,_ZThn16_N7ee712203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71220 = {  "ee71220", // class name
  bases_ee71220, 4,
  &(vtc_ee71220[0]), // expected_vtbl_contents
  &(vtt_ee71220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71220),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2220  : cc220 {
  int d;
  virtual void  foo(); // _ZN6dd22203fooEv
  ~dd2220(); // tgen
  dd2220(); // tgen
};
//SIG(-1 dd2220) C1{ BC2{ BC3{ BC4{ Fi} v1 Fi} v1 Fi} v1 Fi}


void  dd2220 ::foo(){vfunc_called(this, "_ZN6dd22203fooEv");}
dd2220 ::~dd2220(){ note_dtor("dd2220", this);} // tgen
dd2220 ::dd2220(){ note_ctor("dd2220", this);} // tgen

static void Test_dd2220()
{
  extern Class_Descriptor cd_dd2220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2220, buf);
    dd2220 *dp, &lv = *(dp=new (buf) dd2220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(8,4), "dd2220");
    check_base_class_offset(lv, (bb20*)(cc220*), 0, "dd2220");
    check_base_class_offset(lv, (cc220*), 0, "dd2220");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2220.d");
    test_class_info(&lv, &cd_dd2220);
    dp->~dd2220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2220(Test_dd2220, "dd2220", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2220C1Ev();
extern void _ZN6dd2220D1Ev();
Name_Map name_map_dd2220[] = {
  NSPAIR(_ZN6dd2220C1Ev),
  NSPAIR(_ZN6dd2220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
static Base_Class bases_dd2220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2220[];
extern void _ZN6dd22203fooEv();
static  VTBL_ENTRY vtc_dd2220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2220[0]),
  (VTBL_ENTRY)&_ZN6dd22203fooEv,
};
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
Class_Descriptor cd_dd2220 = {  "dd2220", // class name
  bases_dd2220, 3,
  &(vtc_dd2220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2220),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02220  : dd2220 {
  int e;
  ~ee02220(); // tgen
  ee02220(); // tgen
};
//SIG(1 ee02220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} Fi}


ee02220 ::~ee02220(){ note_dtor("ee02220", this);} // tgen
ee02220 ::ee02220(){ note_ctor("ee02220", this);} // tgen

static void Test_ee02220()
{
  extern Class_Descriptor cd_ee02220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02220, buf);
    ee02220 *dp, &lv = *(dp=new (buf) ee02220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(8,4), "ee02220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), 0, "ee02220");
    check_base_class_offset(lv, (cc220*)(dd2220*), 0, "ee02220");
    check_base_class_offset(lv, (dd2220*), 0, "ee02220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02220.e");
    test_class_info(&lv, &cd_ee02220);
    dp->~ee02220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02220(Test_ee02220, "ee02220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02220C1Ev();
extern void _ZN7ee02220D1Ev();
Name_Map name_map_ee02220[] = {
  NSPAIR(_ZN7ee02220C1Ev),
  NSPAIR(_ZN7ee02220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee02220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02220[];
extern void _ZN6dd22203fooEv();
static  VTBL_ENTRY vtc_ee02220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02220[0]),
  (VTBL_ENTRY)&_ZN6dd22203fooEv,
};
extern VTBL_ENTRY _ZTI7ee02220[];
extern  VTBL_ENTRY _ZTV7ee02220[];
Class_Descriptor cd_ee02220 = {  "ee02220", // class name
  bases_ee02220, 4,
  &(vtc_ee02220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02220),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12220  : virtual dd2220 {
  int e;
  ~ee12220(); // tgen
  ee12220(); // tgen
};
//SIG(1 ee12220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} Fi}


ee12220 ::~ee12220(){ note_dtor("ee12220", this);} // tgen
ee12220 ::ee12220(){ note_ctor("ee12220", this);} // tgen

static void Test_ee12220()
{
  extern Class_Descriptor cd_ee12220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12220, buf);
    ee12220 *dp, &lv = *(dp=new (buf) ee12220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(24,12), "ee12220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), ABISELECT(16,8), "ee12220");
    check_base_class_offset(lv, (cc220*)(dd2220*), ABISELECT(16,8), "ee12220");
    check_base_class_offset(lv, (dd2220*), ABISELECT(16,8), "ee12220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12220.e");
    test_class_info(&lv, &cd_ee12220);
    dp->~ee12220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12220(Test_ee12220, "ee12220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12220C1Ev();
extern void _ZN7ee12220D1Ev();
Name_Map name_map_ee12220[] = {
  NSPAIR(_ZN7ee12220C1Ev),
  NSPAIR(_ZN7ee12220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee12220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12220[];
extern void _ZN6dd22203fooEv();
static  VTBL_ENTRY vtc_ee12220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12220[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12220[0]),
  (VTBL_ENTRY)&_ZN6dd22203fooEv,
};
extern VTBL_ENTRY _ZTV7ee12220[];
static  VTT_ENTRY vtt_ee12220[] = {
  {&(_ZTV7ee12220[3]),  3,7},
  {&(_ZTV7ee12220[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee12220[];
extern  VTBL_ENTRY _ZTV7ee12220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12220[];
Class_Descriptor cd_ee12220 = {  "ee12220", // class name
  bases_ee12220, 4,
  &(vtc_ee12220[0]), // expected_vtbl_contents
  &(vtt_ee12220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12220),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22220  : dd2220 {
  int e;
  virtual void  foo(); // _ZN7ee222203fooEv
  ~ee22220(); // tgen
  ee22220(); // tgen
};
//SIG(1 ee22220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee22220 ::foo(){vfunc_called(this, "_ZN7ee222203fooEv");}
ee22220 ::~ee22220(){ note_dtor("ee22220", this);} // tgen
ee22220 ::ee22220(){ note_ctor("ee22220", this);} // tgen

static void Test_ee22220()
{
  extern Class_Descriptor cd_ee22220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22220, buf);
    ee22220 *dp, &lv = *(dp=new (buf) ee22220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(8,4), "ee22220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), 0, "ee22220");
    check_base_class_offset(lv, (cc220*)(dd2220*), 0, "ee22220");
    check_base_class_offset(lv, (dd2220*), 0, "ee22220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22220.e");
    test_class_info(&lv, &cd_ee22220);
    dp->~ee22220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22220(Test_ee22220, "ee22220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22220C1Ev();
extern void _ZN7ee22220D1Ev();
Name_Map name_map_ee22220[] = {
  NSPAIR(_ZN7ee22220C1Ev),
  NSPAIR(_ZN7ee22220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee22220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22220[];
extern void _ZN7ee222203fooEv();
static  VTBL_ENTRY vtc_ee22220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22220[0]),
  (VTBL_ENTRY)&_ZN7ee222203fooEv,
};
extern VTBL_ENTRY _ZTI7ee22220[];
extern  VTBL_ENTRY _ZTV7ee22220[];
Class_Descriptor cd_ee22220 = {  "ee22220", // class name
  bases_ee22220, 4,
  &(vtc_ee22220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22220),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32220  : virtual dd2220 {
  int e;
  virtual void  foo(); // _ZN7ee322203fooEv
  ~ee32220(); // tgen
  ee32220(); // tgen
};
//SIG(1 ee32220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee32220 ::foo(){vfunc_called(this, "_ZN7ee322203fooEv");}
ee32220 ::~ee32220(){ note_dtor("ee32220", this);} // tgen
ee32220 ::ee32220(){ note_ctor("ee32220", this);} // tgen

static void Test_ee32220()
{
  extern Class_Descriptor cd_ee32220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32220, buf);
    ee32220 *dp, &lv = *(dp=new (buf) ee32220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(24,12), "ee32220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), ABISELECT(16,8), "ee32220");
    check_base_class_offset(lv, (cc220*)(dd2220*), ABISELECT(16,8), "ee32220");
    check_base_class_offset(lv, (dd2220*), ABISELECT(16,8), "ee32220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32220.e");
    test_class_info(&lv, &cd_ee32220);
    dp->~ee32220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32220(Test_ee32220, "ee32220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32220C1Ev();
extern void _ZN7ee32220D1Ev();
Name_Map name_map_ee32220[] = {
  NSPAIR(_ZN7ee32220C1Ev),
  NSPAIR(_ZN7ee32220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee32220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32220[];
extern void _ZN7ee322203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee322203fooEv,_ZTv0_n12_N7ee322203fooEv)();
extern void ABISELECT(_ZThn16_N7ee322203fooEv,_ZThn8_N7ee322203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32220[0]),
  (VTBL_ENTRY)&_ZN7ee322203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee322203fooEv,_ZTv0_n12_N7ee322203fooEv),
};
extern VTBL_ENTRY _ZTV7ee32220[];
static  VTT_ENTRY vtt_ee32220[] = {
  {&(_ZTV7ee32220[3]),  3,8},
  {&(_ZTV7ee32220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee32220[];
extern  VTBL_ENTRY _ZTV7ee32220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32220[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee322203fooEv,_ZTv0_n12_N7ee322203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee322203fooEv,_ZThn8_N7ee322203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32220 = {  "ee32220", // class name
  bases_ee32220, 4,
  &(vtc_ee32220[0]), // expected_vtbl_contents
  &(vtt_ee32220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42220  : dd2220 {
  int e;
  virtual void  bar(); // _ZN7ee422203barEv
  ~ee42220(); // tgen
  ee42220(); // tgen
};
//SIG(1 ee42220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee42220 ::bar(){vfunc_called(this, "_ZN7ee422203barEv");}
ee42220 ::~ee42220(){ note_dtor("ee42220", this);} // tgen
ee42220 ::ee42220(){ note_ctor("ee42220", this);} // tgen

static void Test_ee42220()
{
  extern Class_Descriptor cd_ee42220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42220, buf);
    ee42220 *dp, &lv = *(dp=new (buf) ee42220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(8,4), "ee42220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), 0, "ee42220");
    check_base_class_offset(lv, (cc220*)(dd2220*), 0, "ee42220");
    check_base_class_offset(lv, (dd2220*), 0, "ee42220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42220.e");
    test_class_info(&lv, &cd_ee42220);
    dp->~ee42220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42220(Test_ee42220, "ee42220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42220C1Ev();
extern void _ZN7ee42220D1Ev();
Name_Map name_map_ee42220[] = {
  NSPAIR(_ZN7ee42220C1Ev),
  NSPAIR(_ZN7ee42220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee42220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42220[];
extern void _ZN6dd22203fooEv();
extern void _ZN7ee422203barEv();
static  VTBL_ENTRY vtc_ee42220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42220[0]),
  (VTBL_ENTRY)&_ZN6dd22203fooEv,
  (VTBL_ENTRY)&_ZN7ee422203barEv,
};
extern VTBL_ENTRY _ZTI7ee42220[];
extern  VTBL_ENTRY _ZTV7ee42220[];
Class_Descriptor cd_ee42220 = {  "ee42220", // class name
  bases_ee42220, 4,
  &(vtc_ee42220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52220  : virtual dd2220 {
  int e;
  virtual void  bar(); // _ZN7ee522203barEv
  ~ee52220(); // tgen
  ee52220(); // tgen
};
//SIG(1 ee52220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee52220 ::bar(){vfunc_called(this, "_ZN7ee522203barEv");}
ee52220 ::~ee52220(){ note_dtor("ee52220", this);} // tgen
ee52220 ::ee52220(){ note_ctor("ee52220", this);} // tgen

static void Test_ee52220()
{
  extern Class_Descriptor cd_ee52220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52220, buf);
    ee52220 *dp, &lv = *(dp=new (buf) ee52220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(24,12), "ee52220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), ABISELECT(16,8), "ee52220");
    check_base_class_offset(lv, (cc220*)(dd2220*), ABISELECT(16,8), "ee52220");
    check_base_class_offset(lv, (dd2220*), ABISELECT(16,8), "ee52220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52220.e");
    test_class_info(&lv, &cd_ee52220);
    dp->~ee52220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52220(Test_ee52220, "ee52220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52220C1Ev();
extern void _ZN7ee52220D1Ev();
Name_Map name_map_ee52220[] = {
  NSPAIR(_ZN7ee52220C1Ev),
  NSPAIR(_ZN7ee52220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee52220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52220[];
extern void _ZN7ee522203barEv();
extern void _ZN6dd22203fooEv();
static  VTBL_ENTRY vtc_ee52220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52220[0]),
  (VTBL_ENTRY)&_ZN7ee522203barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52220[0]),
  (VTBL_ENTRY)&_ZN6dd22203fooEv,
};
extern VTBL_ENTRY _ZTV7ee52220[];
static  VTT_ENTRY vtt_ee52220[] = {
  {&(_ZTV7ee52220[3]),  3,8},
  {&(_ZTV7ee52220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee52220[];
extern  VTBL_ENTRY _ZTV7ee52220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52220[];
Class_Descriptor cd_ee52220 = {  "ee52220", // class name
  bases_ee52220, 4,
  &(vtc_ee52220[0]), // expected_vtbl_contents
  &(vtt_ee52220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62220  : dd2220 {
  int e;
  virtual void  foo(); // _ZN7ee622203fooEv
  virtual void  bar(); // _ZN7ee622203barEv
  ~ee62220(); // tgen
  ee62220(); // tgen
};
//SIG(1 ee62220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee62220 ::foo(){vfunc_called(this, "_ZN7ee622203fooEv");}
void  ee62220 ::bar(){vfunc_called(this, "_ZN7ee622203barEv");}
ee62220 ::~ee62220(){ note_dtor("ee62220", this);} // tgen
ee62220 ::ee62220(){ note_ctor("ee62220", this);} // tgen

static void Test_ee62220()
{
  extern Class_Descriptor cd_ee62220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62220, buf);
    ee62220 *dp, &lv = *(dp=new (buf) ee62220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(8,4), "ee62220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), 0, "ee62220");
    check_base_class_offset(lv, (cc220*)(dd2220*), 0, "ee62220");
    check_base_class_offset(lv, (dd2220*), 0, "ee62220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62220.e");
    test_class_info(&lv, &cd_ee62220);
    dp->~ee62220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62220(Test_ee62220, "ee62220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62220C1Ev();
extern void _ZN7ee62220D1Ev();
Name_Map name_map_ee62220[] = {
  NSPAIR(_ZN7ee62220C1Ev),
  NSPAIR(_ZN7ee62220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee62220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62220[];
extern void _ZN7ee622203fooEv();
extern void _ZN7ee622203barEv();
static  VTBL_ENTRY vtc_ee62220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62220[0]),
  (VTBL_ENTRY)&_ZN7ee622203fooEv,
  (VTBL_ENTRY)&_ZN7ee622203barEv,
};
extern VTBL_ENTRY _ZTI7ee62220[];
extern  VTBL_ENTRY _ZTV7ee62220[];
Class_Descriptor cd_ee62220 = {  "ee62220", // class name
  bases_ee62220, 4,
  &(vtc_ee62220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72220  : virtual dd2220 {
  int e;
  virtual void  foo(); // _ZN7ee722203fooEv
  virtual void  bar(); // _ZN7ee722203barEv
  ~ee72220(); // tgen
  ee72220(); // tgen
};
//SIG(1 ee72220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee72220 ::foo(){vfunc_called(this, "_ZN7ee722203fooEv");}
void  ee72220 ::bar(){vfunc_called(this, "_ZN7ee722203barEv");}
ee72220 ::~ee72220(){ note_dtor("ee72220", this);} // tgen
ee72220 ::ee72220(){ note_ctor("ee72220", this);} // tgen

static void Test_ee72220()
{
  extern Class_Descriptor cd_ee72220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72220, buf);
    ee72220 *dp, &lv = *(dp=new (buf) ee72220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd2220*), ABISELECT(24,12), "ee72220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd2220*), ABISELECT(16,8), "ee72220");
    check_base_class_offset(lv, (cc220*)(dd2220*), ABISELECT(16,8), "ee72220");
    check_base_class_offset(lv, (dd2220*), ABISELECT(16,8), "ee72220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72220.e");
    test_class_info(&lv, &cd_ee72220);
    dp->~ee72220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72220(Test_ee72220, "ee72220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72220C1Ev();
extern void _ZN7ee72220D1Ev();
Name_Map name_map_ee72220[] = {
  NSPAIR(_ZN7ee72220C1Ev),
  NSPAIR(_ZN7ee72220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd2220;
extern VTBL_ENTRY _ZTI6dd2220[];
extern  VTBL_ENTRY _ZTV6dd2220[];
static Base_Class bases_ee72220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2220,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72220[];
extern void _ZN7ee722203fooEv();
extern void _ZN7ee722203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee722203fooEv,_ZTv0_n12_N7ee722203fooEv)();
extern void ABISELECT(_ZThn16_N7ee722203fooEv,_ZThn8_N7ee722203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72220[0]),
  (VTBL_ENTRY)&_ZN7ee722203fooEv,
  (VTBL_ENTRY)&_ZN7ee722203barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee722203fooEv,_ZTv0_n12_N7ee722203fooEv),
};
extern VTBL_ENTRY _ZTV7ee72220[];
static  VTT_ENTRY vtt_ee72220[] = {
  {&(_ZTV7ee72220[3]),  3,9},
  {&(_ZTV7ee72220[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee72220[];
extern  VTBL_ENTRY _ZTV7ee72220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72220[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee722203fooEv,_ZTv0_n12_N7ee722203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee722203fooEv,_ZThn8_N7ee722203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72220 = {  "ee72220", // class name
  bases_ee72220, 4,
  &(vtc_ee72220[0]), // expected_vtbl_contents
  &(vtt_ee72220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72220),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3220  : virtual cc220 {
  int d;
  virtual void  foo(); // _ZN6dd32203fooEv
  ~dd3220(); // tgen
  dd3220(); // tgen
};
//SIG(-1 dd3220) C1{ VBC2{ BC3{ BC4{ Fi} v1 Fi} v1 Fi} v1 Fi}


void  dd3220 ::foo(){vfunc_called(this, "_ZN6dd32203fooEv");}
dd3220 ::~dd3220(){ note_dtor("dd3220", this);} // tgen
dd3220 ::dd3220(){ note_ctor("dd3220", this);} // tgen

static void Test_dd3220()
{
  extern Class_Descriptor cd_dd3220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3220, buf);
    dd3220 *dp, &lv = *(dp=new (buf) dd3220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,12), "dd3220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,8), "dd3220");
    check_base_class_offset(lv, (cc220*), ABISELECT(16,8), "dd3220");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3220.d");
    test_class_info(&lv, &cd_dd3220);
    dp->~dd3220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3220(Test_dd3220, "dd3220", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3220C1Ev();
extern void _ZN6dd3220D1Ev();
Name_Map name_map_dd3220[] = {
  NSPAIR(_ZN6dd3220C1Ev),
  NSPAIR(_ZN6dd3220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
static Base_Class bases_dd3220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3220[];
extern void _ZN6dd32203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
extern VTBL_ENTRY _ZTV6dd3220[];
static  VTT_ENTRY vtt_dd3220[] = {
  {&(_ZTV6dd3220[3]),  3,8},
  {&(_ZTV6dd3220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3220 = {  "dd3220", // class name
  bases_dd3220, 3,
  &(vtc_dd3220[0]), // expected_vtbl_contents
  &(vtt_dd3220[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3220),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03220  : dd3220 {
  int e;
  ~ee03220(); // tgen
  ee03220(); // tgen
};
//SIG(1 ee03220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} Fi}


ee03220 ::~ee03220(){ note_dtor("ee03220", this);} // tgen
ee03220 ::ee03220(){ note_ctor("ee03220", this);} // tgen

static void Test_ee03220()
{
  extern Class_Descriptor cd_ee03220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03220, buf);
    ee03220 *dp, &lv = *(dp=new (buf) ee03220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee03220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee03220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(16,12), "ee03220");
    check_base_class_offset(lv, (dd3220*), 0, "ee03220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03220.e");
    test_class_info(&lv, &cd_ee03220);
    dp->~ee03220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03220(Test_ee03220, "ee03220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03220C1Ev();
extern void _ZN7ee03220D1Ev();
Name_Map name_map_ee03220[] = {
  NSPAIR(_ZN7ee03220C1Ev),
  NSPAIR(_ZN7ee03220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee03220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03220[];
extern void _ZN6dd32203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
extern VTBL_ENTRY _ZTV7ee03220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee03220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee03220[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee03220[] = {
  {&(_ZTV7ee03220[3]),  3,8},
  {&(_tg__ZTV6dd3220__7ee03220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee03220[3]),  3,4},
  {&(_ZTV7ee03220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee03220[];
extern  VTBL_ENTRY _ZTV7ee03220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03220[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03220 = {  "ee03220", // class name
  bases_ee03220, 4,
  &(vtc_ee03220[0]), // expected_vtbl_contents
  &(vtt_ee03220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13220  : virtual dd3220 {
  int e;
  ~ee13220(); // tgen
  ee13220(); // tgen
};
//SIG(1 ee13220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} Fi}


ee13220 ::~ee13220(){ note_dtor("ee13220", this);} // tgen
ee13220 ::ee13220(){ note_ctor("ee13220", this);} // tgen

static void Test_ee13220()
{
  extern Class_Descriptor cd_ee13220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13220, buf);
    ee13220 *dp, &lv = *(dp=new (buf) ee13220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee13220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee13220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(32,16), "ee13220");
    check_base_class_offset(lv, (dd3220*), ABISELECT(16,8), "ee13220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13220.e");
    test_class_info(&lv, &cd_ee13220);
    dp->~ee13220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13220(Test_ee13220, "ee13220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13220C1Ev();
extern void _ZN7ee13220D1Ev();
Name_Map name_map_ee13220[] = {
  NSPAIR(_ZN7ee13220C1Ev),
  NSPAIR(_ZN7ee13220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee13220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13220[];
extern void _ZN6dd32203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13220[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
extern VTBL_ENTRY _ZTV7ee13220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee13220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee13220[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee13220[] = {
  {&(_ZTV7ee13220[4]),  4,13},
  {&(_ZTV7ee13220[8]),  8,13},
  {&(_ZTV7ee13220[12]),  12,13},
  {&(_tg__ZTV6dd3220__7ee13220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee13220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13220[];
extern  VTBL_ENTRY _ZTV7ee13220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13220[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13220 = {  "ee13220", // class name
  bases_ee13220, 4,
  &(vtc_ee13220[0]), // expected_vtbl_contents
  &(vtt_ee13220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13220),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23220  : dd3220 {
  int e;
  virtual void  foo(); // _ZN7ee232203fooEv
  ~ee23220(); // tgen
  ee23220(); // tgen
};
//SIG(1 ee23220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee23220 ::foo(){vfunc_called(this, "_ZN7ee232203fooEv");}
ee23220 ::~ee23220(){ note_dtor("ee23220", this);} // tgen
ee23220 ::ee23220(){ note_ctor("ee23220", this);} // tgen

static void Test_ee23220()
{
  extern Class_Descriptor cd_ee23220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23220, buf);
    ee23220 *dp, &lv = *(dp=new (buf) ee23220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee23220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee23220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(16,12), "ee23220");
    check_base_class_offset(lv, (dd3220*), 0, "ee23220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23220.e");
    test_class_info(&lv, &cd_ee23220);
    dp->~ee23220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23220(Test_ee23220, "ee23220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23220C1Ev();
extern void _ZN7ee23220D1Ev();
Name_Map name_map_ee23220[] = {
  NSPAIR(_ZN7ee23220C1Ev),
  NSPAIR(_ZN7ee23220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee23220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23220[];
extern void _ZN7ee232203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee232203fooEv,_ZTv0_n12_N7ee232203fooEv)();
extern void ABISELECT(_ZThn16_N7ee232203fooEv,_ZThn12_N7ee232203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23220[0]),
  (VTBL_ENTRY)&_ZN7ee232203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee232203fooEv,_ZTv0_n12_N7ee232203fooEv),
};
extern VTBL_ENTRY _ZTV7ee23220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee23220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee23220[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee23220[] = {
  {&(_ZTV7ee23220[3]),  3,8},
  {&(_tg__ZTV6dd3220__7ee23220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee23220[3]),  3,4},
  {&(_ZTV7ee23220[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee23220[];
extern  VTBL_ENTRY _ZTV7ee23220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23220[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee232203fooEv,_ZTv0_n12_N7ee232203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee232203fooEv,_ZThn12_N7ee232203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23220 = {  "ee23220", // class name
  bases_ee23220, 4,
  &(vtc_ee23220[0]), // expected_vtbl_contents
  &(vtt_ee23220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23220),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33220  : virtual dd3220 {
  int e;
  virtual void  foo(); // _ZN7ee332203fooEv
  ~ee33220(); // tgen
  ee33220(); // tgen
};
//SIG(1 ee33220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee33220 ::foo(){vfunc_called(this, "_ZN7ee332203fooEv");}
ee33220 ::~ee33220(){ note_dtor("ee33220", this);} // tgen
ee33220 ::ee33220(){ note_ctor("ee33220", this);} // tgen

static void Test_ee33220()
{
  extern Class_Descriptor cd_ee33220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33220, buf);
    ee33220 *dp, &lv = *(dp=new (buf) ee33220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee33220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee33220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(32,16), "ee33220");
    check_base_class_offset(lv, (dd3220*), ABISELECT(16,8), "ee33220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33220.e");
    test_class_info(&lv, &cd_ee33220);
    dp->~ee33220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33220(Test_ee33220, "ee33220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33220C1Ev();
extern void _ZN7ee33220D1Ev();
Name_Map name_map_ee33220[] = {
  NSPAIR(_ZN7ee33220C1Ev),
  NSPAIR(_ZN7ee33220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee33220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33220[];
extern void _ZN7ee332203fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee332203fooEv,_ZTv0_n16_N7ee332203fooEv)();
extern void ABISELECT(_ZThn16_N7ee332203fooEv,_ZThn8_N7ee332203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee332203fooEv,_ZTv0_n12_N7ee332203fooEv)();
extern void ABISELECT(_ZThn32_N7ee332203fooEv,_ZThn16_N7ee332203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33220[0]),
  (VTBL_ENTRY)&_ZN7ee332203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee332203fooEv,_ZTv0_n16_N7ee332203fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee332203fooEv,_ZTv0_n12_N7ee332203fooEv),
};
extern VTBL_ENTRY _ZTV7ee33220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee33220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee33220[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee33220[] = {
  {&(_ZTV7ee33220[4]),  4,14},
  {&(_ZTV7ee33220[9]),  9,14},
  {&(_ZTV7ee33220[13]),  13,14},
  {&(_tg__ZTV6dd3220__7ee33220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee33220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33220[];
extern  VTBL_ENTRY _ZTV7ee33220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33220[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee332203fooEv,_ZTv0_n12_N7ee332203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee332203fooEv,_ZThn16_N7ee332203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee332203fooEv,_ZTv0_n16_N7ee332203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee332203fooEv,_ZThn8_N7ee332203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33220 = {  "ee33220", // class name
  bases_ee33220, 4,
  &(vtc_ee33220[0]), // expected_vtbl_contents
  &(vtt_ee33220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33220),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43220  : dd3220 {
  int e;
  virtual void  bar(); // _ZN7ee432203barEv
  ~ee43220(); // tgen
  ee43220(); // tgen
};
//SIG(1 ee43220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee43220 ::bar(){vfunc_called(this, "_ZN7ee432203barEv");}
ee43220 ::~ee43220(){ note_dtor("ee43220", this);} // tgen
ee43220 ::ee43220(){ note_ctor("ee43220", this);} // tgen

static void Test_ee43220()
{
  extern Class_Descriptor cd_ee43220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43220, buf);
    ee43220 *dp, &lv = *(dp=new (buf) ee43220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee43220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee43220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(16,12), "ee43220");
    check_base_class_offset(lv, (dd3220*), 0, "ee43220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43220.e");
    test_class_info(&lv, &cd_ee43220);
    dp->~ee43220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43220(Test_ee43220, "ee43220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43220C1Ev();
extern void _ZN7ee43220D1Ev();
Name_Map name_map_ee43220[] = {
  NSPAIR(_ZN7ee43220C1Ev),
  NSPAIR(_ZN7ee43220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee43220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43220[];
extern void _ZN6dd32203fooEv();
extern void _ZN7ee432203barEv();
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
  (VTBL_ENTRY)&_ZN7ee432203barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
extern VTBL_ENTRY _ZTV7ee43220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee43220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee43220[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee43220[] = {
  {&(_ZTV7ee43220[3]),  3,9},
  {&(_tg__ZTV6dd3220__7ee43220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee43220[3]),  3,4},
  {&(_ZTV7ee43220[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee43220[];
extern  VTBL_ENTRY _ZTV7ee43220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43220[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43220 = {  "ee43220", // class name
  bases_ee43220, 4,
  &(vtc_ee43220[0]), // expected_vtbl_contents
  &(vtt_ee43220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43220),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53220  : virtual dd3220 {
  int e;
  virtual void  bar(); // _ZN7ee532203barEv
  ~ee53220(); // tgen
  ee53220(); // tgen
};
//SIG(1 ee53220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee53220 ::bar(){vfunc_called(this, "_ZN7ee532203barEv");}
ee53220 ::~ee53220(){ note_dtor("ee53220", this);} // tgen
ee53220 ::ee53220(){ note_ctor("ee53220", this);} // tgen

static void Test_ee53220()
{
  extern Class_Descriptor cd_ee53220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53220, buf);
    ee53220 *dp, &lv = *(dp=new (buf) ee53220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee53220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee53220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(32,16), "ee53220");
    check_base_class_offset(lv, (dd3220*), ABISELECT(16,8), "ee53220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53220.e");
    test_class_info(&lv, &cd_ee53220);
    dp->~ee53220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53220(Test_ee53220, "ee53220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53220C1Ev();
extern void _ZN7ee53220D1Ev();
Name_Map name_map_ee53220[] = {
  NSPAIR(_ZN7ee53220C1Ev),
  NSPAIR(_ZN7ee53220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee53220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53220[];
extern void _ZN7ee532203barEv();
extern void _ZN6dd32203fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53220[0]),
  (VTBL_ENTRY)&_ZN7ee532203barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
extern VTBL_ENTRY _ZTV7ee53220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee53220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee53220[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee53220[] = {
  {&(_ZTV7ee53220[4]),  4,14},
  {&(_ZTV7ee53220[9]),  9,14},
  {&(_ZTV7ee53220[13]),  13,14},
  {&(_tg__ZTV6dd3220__7ee53220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee53220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53220[];
extern  VTBL_ENTRY _ZTV7ee53220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53220[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53220 = {  "ee53220", // class name
  bases_ee53220, 4,
  &(vtc_ee53220[0]), // expected_vtbl_contents
  &(vtt_ee53220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53220),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63220  : dd3220 {
  int e;
  virtual void  foo(); // _ZN7ee632203fooEv
  virtual void  bar(); // _ZN7ee632203barEv
  ~ee63220(); // tgen
  ee63220(); // tgen
};
//SIG(1 ee63220) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee63220 ::foo(){vfunc_called(this, "_ZN7ee632203fooEv");}
void  ee63220 ::bar(){vfunc_called(this, "_ZN7ee632203barEv");}
ee63220 ::~ee63220(){ note_dtor("ee63220", this);} // tgen
ee63220 ::ee63220(){ note_ctor("ee63220", this);} // tgen

static void Test_ee63220()
{
  extern Class_Descriptor cd_ee63220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63220, buf);
    ee63220 *dp, &lv = *(dp=new (buf) ee63220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(24,16), "ee63220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(16,12), "ee63220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(16,12), "ee63220");
    check_base_class_offset(lv, (dd3220*), 0, "ee63220");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63220.e");
    test_class_info(&lv, &cd_ee63220);
    dp->~ee63220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63220(Test_ee63220, "ee63220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63220C1Ev();
extern void _ZN7ee63220D1Ev();
Name_Map name_map_ee63220[] = {
  NSPAIR(_ZN7ee63220C1Ev),
  NSPAIR(_ZN7ee63220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee63220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63220[];
extern void _ZN7ee632203fooEv();
extern void _ZN7ee632203barEv();
extern void ABISELECT(_ZTv0_n24_N7ee632203fooEv,_ZTv0_n12_N7ee632203fooEv)();
extern void ABISELECT(_ZThn16_N7ee632203fooEv,_ZThn12_N7ee632203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63220[0]),
  (VTBL_ENTRY)&_ZN7ee632203fooEv,
  (VTBL_ENTRY)&_ZN7ee632203barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee632203fooEv,_ZTv0_n12_N7ee632203fooEv),
};
extern VTBL_ENTRY _ZTV7ee63220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee63220[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee63220[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee63220[] = {
  {&(_ZTV7ee63220[3]),  3,9},
  {&(_tg__ZTV6dd3220__7ee63220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee63220[3]),  3,4},
  {&(_ZTV7ee63220[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee63220[];
extern  VTBL_ENTRY _ZTV7ee63220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63220[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn12_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee632203fooEv,_ZTv0_n12_N7ee632203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee632203fooEv,_ZThn12_N7ee632203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63220 = {  "ee63220", // class name
  bases_ee63220, 4,
  &(vtc_ee63220[0]), // expected_vtbl_contents
  &(vtt_ee63220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63220),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63220),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73220  : virtual dd3220 {
  int e;
  virtual void  foo(); // _ZN7ee732203fooEv
  virtual void  bar(); // _ZN7ee732203barEv
  ~ee73220(); // tgen
  ee73220(); // tgen
};
//SIG(1 ee73220) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee73220 ::foo(){vfunc_called(this, "_ZN7ee732203fooEv");}
void  ee73220 ::bar(){vfunc_called(this, "_ZN7ee732203barEv");}
ee73220 ::~ee73220(){ note_dtor("ee73220", this);} // tgen
ee73220 ::ee73220(){ note_ctor("ee73220", this);} // tgen

static void Test_ee73220()
{
  extern Class_Descriptor cd_ee73220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73220, buf);
    ee73220 *dp, &lv = *(dp=new (buf) ee73220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(40,20), "ee73220");
    check_base_class_offset(lv, (bb20*)(cc220*), ABISELECT(32,16), "ee73220");
    check_base_class_offset(lv, (cc220*)(dd3220*), ABISELECT(32,16), "ee73220");
    check_base_class_offset(lv, (dd3220*), ABISELECT(16,8), "ee73220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73220.e");
    test_class_info(&lv, &cd_ee73220);
    dp->~ee73220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73220(Test_ee73220, "ee73220", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73220C1Ev();
extern void _ZN7ee73220D1Ev();
Name_Map name_map_ee73220[] = {
  NSPAIR(_ZN7ee73220C1Ev),
  NSPAIR(_ZN7ee73220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd3220;
extern VTBL_ENTRY _ZTI6dd3220[];
extern  VTBL_ENTRY _ZTV6dd3220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3220[];
static Base_Class bases_ee73220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3220,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73220[];
extern void _ZN7ee732203fooEv();
extern void _ZN7ee732203barEv();
extern void ABISELECT(_ZTv0_n32_N7ee732203fooEv,_ZTv0_n16_N7ee732203fooEv)();
extern void ABISELECT(_ZThn16_N7ee732203fooEv,_ZThn8_N7ee732203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee732203fooEv,_ZTv0_n12_N7ee732203fooEv)();
extern void ABISELECT(_ZThn32_N7ee732203fooEv,_ZThn16_N7ee732203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73220[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73220[0]),
  (VTBL_ENTRY)&_ZN7ee732203fooEv,
  (VTBL_ENTRY)&_ZN7ee732203barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee732203fooEv,_ZTv0_n16_N7ee732203fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee732203fooEv,_ZTv0_n12_N7ee732203fooEv),
};
extern VTBL_ENTRY _ZTV7ee73220[];
extern void _ZN6dd32203fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3220__7ee73220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&_ZN6dd32203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv)();
extern void ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc220__6dd3220__7ee73220[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv),
};
static  VTT_ENTRY vtt_ee73220[] = {
  {&(_ZTV7ee73220[4]),  4,15},
  {&(_ZTV7ee73220[10]),  10,15},
  {&(_ZTV7ee73220[14]),  14,15},
  {&(_tg__ZTV6dd3220__7ee73220[3]),  3,4},
  {&(_tg__ZTV5cc220__6dd3220__7ee73220[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73220[];
extern  VTBL_ENTRY _ZTV7ee73220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73220[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32203fooEv,_ZTv0_n12_N6dd32203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32203fooEv,_ZThn8_N6dd32203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee732203fooEv,_ZTv0_n12_N7ee732203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee732203fooEv,_ZThn16_N7ee732203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee732203fooEv,_ZTv0_n16_N7ee732203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee732203fooEv,_ZThn8_N7ee732203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73220 = {  "ee73220", // class name
  bases_ee73220, 4,
  &(vtc_ee73220[0]), // expected_vtbl_contents
  &(vtt_ee73220[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73220),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73220),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names108,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4220  : cc220 {
  int d;
  virtual void  bar(); // _ZN6dd42203barEv
  ~dd4220(); // tgen
  dd4220(); // tgen
};
//SIG(-1 dd4220) C1{ BC2{ BC3{ BC4{ Fi} v2 Fi} v2 Fi} v1 Fi}


void  dd4220 ::bar(){vfunc_called(this, "_ZN6dd42203barEv");}
dd4220 ::~dd4220(){ note_dtor("dd4220", this);} // tgen
dd4220 ::dd4220(){ note_ctor("dd4220", this);} // tgen

static void Test_dd4220()
{
  extern Class_Descriptor cd_dd4220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4220, buf);
    dd4220 *dp, &lv = *(dp=new (buf) dd4220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*), ABISELECT(8,4), "dd4220");
    check_base_class_offset(lv, (bb20*)(cc220*), 0, "dd4220");
    check_base_class_offset(lv, (cc220*), 0, "dd4220");
    check_field_offset(lv, d, ABISELECT(20,16), "dd4220.d");
    test_class_info(&lv, &cd_dd4220);
    dp->~dd4220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4220(Test_dd4220, "dd4220", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4220C1Ev();
extern void _ZN6dd4220D1Ev();
Name_Map name_map_dd4220[] = {
  NSPAIR(_ZN6dd4220C1Ev),
  NSPAIR(_ZN6dd4220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
static Base_Class bases_dd4220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4220[];
extern void _ZN5cc2203fooEv();
extern void _ZN6dd42203barEv();
static  VTBL_ENTRY vtc_dd4220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd4220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
  (VTBL_ENTRY)&_ZN6dd42203barEv,
};
extern VTBL_ENTRY _ZTI6dd4220[];
extern  VTBL_ENTRY _ZTV6dd4220[];
Class_Descriptor cd_dd4220 = {  "dd4220", // class name
  bases_dd4220, 3,
  &(vtc_dd4220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04220  : dd4220 {
  int e;
  ~ee04220(); // tgen
  ee04220(); // tgen
};
//SIG(1 ee04220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} v1 Fi} Fi}


ee04220 ::~ee04220(){ note_dtor("ee04220", this);} // tgen
ee04220 ::ee04220(){ note_ctor("ee04220", this);} // tgen

static void Test_ee04220()
{
  extern Class_Descriptor cd_ee04220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04220, buf);
    ee04220 *dp, &lv = *(dp=new (buf) ee04220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd4220*), ABISELECT(8,4), "ee04220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd4220*), 0, "ee04220");
    check_base_class_offset(lv, (cc220*)(dd4220*), 0, "ee04220");
    check_base_class_offset(lv, (dd4220*), 0, "ee04220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee04220.e");
    test_class_info(&lv, &cd_ee04220);
    dp->~ee04220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04220(Test_ee04220, "ee04220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04220C1Ev();
extern void _ZN7ee04220D1Ev();
Name_Map name_map_ee04220[] = {
  NSPAIR(_ZN7ee04220C1Ev),
  NSPAIR(_ZN7ee04220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd4220;
extern VTBL_ENTRY _ZTI6dd4220[];
extern  VTBL_ENTRY _ZTV6dd4220[];
static Base_Class bases_ee04220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4220,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04220[];
extern void _ZN5cc2203fooEv();
extern void _ZN6dd42203barEv();
static  VTBL_ENTRY vtc_ee04220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee04220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
  (VTBL_ENTRY)&_ZN6dd42203barEv,
};
extern VTBL_ENTRY _ZTI7ee04220[];
extern  VTBL_ENTRY _ZTV7ee04220[];
Class_Descriptor cd_ee04220 = {  "ee04220", // class name
  bases_ee04220, 4,
  &(vtc_ee04220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14220  : virtual dd4220 {
  int e;
  ~ee14220(); // tgen
  ee14220(); // tgen
};
//SIG(1 ee14220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} v1 Fi} Fi}


ee14220 ::~ee14220(){ note_dtor("ee14220", this);} // tgen
ee14220 ::ee14220(){ note_ctor("ee14220", this);} // tgen

static void Test_ee14220()
{
  extern Class_Descriptor cd_ee14220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14220, buf);
    ee14220 *dp, &lv = *(dp=new (buf) ee14220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd4220*), ABISELECT(24,12), "ee14220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd4220*), ABISELECT(16,8), "ee14220");
    check_base_class_offset(lv, (cc220*)(dd4220*), ABISELECT(16,8), "ee14220");
    check_base_class_offset(lv, (dd4220*), ABISELECT(16,8), "ee14220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14220.e");
    test_class_info(&lv, &cd_ee14220);
    dp->~ee14220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14220(Test_ee14220, "ee14220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14220C1Ev();
extern void _ZN7ee14220D1Ev();
Name_Map name_map_ee14220[] = {
  NSPAIR(_ZN7ee14220C1Ev),
  NSPAIR(_ZN7ee14220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd4220;
extern VTBL_ENTRY _ZTI6dd4220[];
extern  VTBL_ENTRY _ZTV6dd4220[];
static Base_Class bases_ee14220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4220,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14220[];
extern void _ZN5cc2203fooEv();
extern void _ZN6dd42203barEv();
static  VTBL_ENTRY vtc_ee14220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14220[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
  (VTBL_ENTRY)&_ZN6dd42203barEv,
};
extern VTBL_ENTRY _ZTV7ee14220[];
static  VTT_ENTRY vtt_ee14220[] = {
  {&(_ZTV7ee14220[3]),  3,9},
  {&(_ZTV7ee14220[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee14220[];
extern  VTBL_ENTRY _ZTV7ee14220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14220[];
Class_Descriptor cd_ee14220 = {  "ee14220", // class name
  bases_ee14220, 4,
  &(vtc_ee14220[0]), // expected_vtbl_contents
  &(vtt_ee14220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14220),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24220  : dd4220 {
  int e;
  virtual void  foo(); // _ZN7ee242203fooEv
  ~ee24220(); // tgen
  ee24220(); // tgen
};
//SIG(1 ee24220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee24220 ::foo(){vfunc_called(this, "_ZN7ee242203fooEv");}
ee24220 ::~ee24220(){ note_dtor("ee24220", this);} // tgen
ee24220 ::ee24220(){ note_ctor("ee24220", this);} // tgen

static void Test_ee24220()
{
  extern Class_Descriptor cd_ee24220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24220, buf);
    ee24220 *dp, &lv = *(dp=new (buf) ee24220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd4220*), ABISELECT(8,4), "ee24220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd4220*), 0, "ee24220");
    check_base_class_offset(lv, (cc220*)(dd4220*), 0, "ee24220");
    check_base_class_offset(lv, (dd4220*), 0, "ee24220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee24220.e");
    test_class_info(&lv, &cd_ee24220);
    dp->~ee24220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24220(Test_ee24220, "ee24220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24220C1Ev();
extern void _ZN7ee24220D1Ev();
Name_Map name_map_ee24220[] = {
  NSPAIR(_ZN7ee24220C1Ev),
  NSPAIR(_ZN7ee24220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd4220;
extern VTBL_ENTRY _ZTI6dd4220[];
extern  VTBL_ENTRY _ZTV6dd4220[];
static Base_Class bases_ee24220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24220[];
extern void _ZN7ee242203fooEv();
extern void _ZN6dd42203barEv();
static  VTBL_ENTRY vtc_ee24220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee24220[0]),
  (VTBL_ENTRY)&_ZN7ee242203fooEv,
  (VTBL_ENTRY)&_ZN6dd42203barEv,
};
extern VTBL_ENTRY _ZTI7ee24220[];
extern  VTBL_ENTRY _ZTV7ee24220[];
Class_Descriptor cd_ee24220 = {  "ee24220", // class name
  bases_ee24220, 4,
  &(vtc_ee24220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34220  : virtual dd4220 {
  int e;
  virtual void  foo(); // _ZN7ee342203fooEv
  ~ee34220(); // tgen
  ee34220(); // tgen
};
//SIG(1 ee34220) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} v1 Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee34220 ::foo(){vfunc_called(this, "_ZN7ee342203fooEv");}
ee34220 ::~ee34220(){ note_dtor("ee34220", this);} // tgen
ee34220 ::ee34220(){ note_ctor("ee34220", this);} // tgen

static void Test_ee34220()
{
  extern Class_Descriptor cd_ee34220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34220, buf);
    ee34220 *dp, &lv = *(dp=new (buf) ee34220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd4220*), ABISELECT(24,12), "ee34220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd4220*), ABISELECT(16,8), "ee34220");
    check_base_class_offset(lv, (cc220*)(dd4220*), ABISELECT(16,8), "ee34220");
    check_base_class_offset(lv, (dd4220*), ABISELECT(16,8), "ee34220");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34220.e");
    test_class_info(&lv, &cd_ee34220);
    dp->~ee34220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34220(Test_ee34220, "ee34220", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34220C1Ev();
extern void _ZN7ee34220D1Ev();
Name_Map name_map_ee34220[] = {
  NSPAIR(_ZN7ee34220C1Ev),
  NSPAIR(_ZN7ee34220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd4220;
extern VTBL_ENTRY _ZTI6dd4220[];
extern  VTBL_ENTRY _ZTV6dd4220[];
static Base_Class bases_ee34220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4220,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34220[];
extern void _ZN7ee342203fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee342203fooEv,_ZTv0_n12_N7ee342203fooEv)();
extern void ABISELECT(_ZThn16_N7ee342203fooEv,_ZThn8_N7ee342203fooEv)() __attribute__((weak));
extern void _ZN6dd42203barEv();
static  VTBL_ENTRY vtc_ee34220[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34220[0]),
  (VTBL_ENTRY)&_ZN7ee342203fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34220[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee342203fooEv,_ZTv0_n12_N7ee342203fooEv),
  (VTBL_ENTRY)&_ZN6dd42203barEv,
};
extern VTBL_ENTRY _ZTV7ee34220[];
static  VTT_ENTRY vtt_ee34220[] = {
  {&(_ZTV7ee34220[3]),  3,10},
  {&(_ZTV7ee34220[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee34220[];
extern  VTBL_ENTRY _ZTV7ee34220[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34220[];
static VTBL_ENTRY alt_thunk_names109[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee342203fooEv,_ZTv0_n12_N7ee342203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee342203fooEv,_ZThn8_N7ee342203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34220 = {  "ee34220", // class name
  bases_ee34220, 4,
  &(vtc_ee34220[0]), // expected_vtbl_contents
  &(vtt_ee34220[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34220),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34220),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34220),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names109,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44220  : dd4220 {
  int e;
  virtual void  bar(); // _ZN7ee442203barEv
  ~ee44220(); // tgen
  ee44220(); // tgen
};
//SIG(1 ee44220) C1{ BC2{ BC3{ BC4{ BC5{ Fi} v2 Fi} v2 Fi} v1 Fi} v1 Fi}


void  ee44220 ::bar(){vfunc_called(this, "_ZN7ee442203barEv");}
ee44220 ::~ee44220(){ note_dtor("ee44220", this);} // tgen
ee44220 ::ee44220(){ note_ctor("ee44220", this);} // tgen

static void Test_ee44220()
{
  extern Class_Descriptor cd_ee44220;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44220, buf);
    ee44220 *dp, &lv = *(dp=new (buf) ee44220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44220)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44220)");
    check_base_class_offset(lv, (aa0*)(bb20*)(cc220*)(dd4220*), ABISELECT(8,4), "ee44220");
    check_base_class_offset(lv, (bb20*)(cc220*)(dd4220*), 0, "ee44220");
    check_base_class_offset(lv, (cc220*)(dd4220*), 0, "ee44220");
    check_base_class_offset(lv, (dd4220*), 0, "ee44220");
    check_field_offset(lv, e, ABISELECT(24,20), "ee44220.e");
    test_class_info(&lv, &cd_ee44220);
    dp->~ee44220();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44220(Test_ee44220, "ee44220", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44220C1Ev();
extern void _ZN7ee44220D1Ev();
Name_Map name_map_ee44220[] = {
  NSPAIR(_ZN7ee44220C1Ev),
  NSPAIR(_ZN7ee44220D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_cc220;
extern VTBL_ENTRY _ZTI5cc220[];
extern  VTBL_ENTRY _ZTV5cc220[];
extern Class_Descriptor cd_dd4220;
extern VTBL_ENTRY _ZTI6dd4220[];
extern  VTBL_ENTRY _ZTV6dd4220[];
static Base_Class bases_ee44220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4220,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44220[];
extern void _ZN5cc2203fooEv();
extern void _ZN7ee442203barEv();
static  VTBL_ENTRY vtc_ee44220[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee44220[0]),
  (VTBL_ENTRY)&_ZN5cc2203fooEv,
  (VTBL_ENTRY)&_ZN7ee442203barEv,
};
extern VTBL_ENTRY _ZTI7ee44220[];
extern  VTBL_ENTRY _ZTV7ee44220[];
Class_Descriptor cd_ee44220 = {  "ee44220", // class name
  bases_ee44220, 4,
  &(vtc_ee44220[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44220),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44220),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee5