// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb10  : virtual aa0 {
  int b;
  ~bb10(); // tgen
  bb10(); // tgen
};
//SIG(-1 bb10) C1{ VBC2{ Fi} Fi}


bb10 ::~bb10(){ note_dtor("bb10", this);} // tgen
bb10 ::bb10(){ note_ctor("bb10", this);} // tgen

static void Test_bb10()
{
  extern Class_Descriptor cd_bb10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_bb10, buf);
    bb10 *dp, &lv = *(dp=new (buf) bb10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(bb10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb10)");
    check_base_class_offset(lv, (aa0*), ABISELECT(12,8), "bb10");
    check_field_offset(lv, b, ABISELECT(8,4), "bb10.b");
    test_class_info(&lv, &cd_bb10);
    dp->~bb10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb10(Test_bb10, "bb10", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN4bb10C1Ev();
extern void _ZN4bb10D1Ev();
Name_Map name_map_bb10[] = {
  NSPAIR(_ZN4bb10C1Ev),
  NSPAIR(_ZN4bb10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4bb10[];
static  VTBL_ENTRY vtc_bb10[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
extern VTBL_ENTRY _ZTV4bb10[];
static  VTT_ENTRY vtt_bb10[] = {
  {&(_ZTV4bb10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
Class_Descriptor cd_bb10 = {  "bb10", // class name
  bases_bb10, 1,
  &(vtc_bb10[0]), // expected_vtbl_contents
  &(vtt_bb10[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI4bb10),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4bb10),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4bb10),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc010  : bb10 {
  int c;
  ~cc010(); // tgen
  cc010(); // tgen
};
//SIG(-1 cc010) C1{ BC2{ VBC3{ Fi} Fi} Fi}


cc010 ::~cc010(){ note_dtor("cc010", this);} // tgen
cc010 ::cc010(){ note_ctor("cc010", this);} // tgen

static void Test_cc010()
{
  extern Class_Descriptor cd_cc010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc010, buf);
    cc010 *dp, &lv = *(dp=new (buf) cc010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc010)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(16,12), "cc010");
    check_base_class_offset(lv, (bb10*), 0, "cc010");
    check_field_offset(lv, c, ABISELECT(12,8), "cc010.c");
    test_class_info(&lv, &cd_cc010);
    dp->~cc010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc010(Test_cc010, "cc010", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc010C1Ev();
extern void _ZN5cc010D1Ev();
Name_Map name_map_cc010[] = {
  NSPAIR(_ZN5cc010C1Ev),
  NSPAIR(_ZN5cc010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
static Base_Class bases_cc010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc010[];
static  VTBL_ENTRY vtc_cc010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
extern VTBL_ENTRY _ZTV5cc010[];
static  VTBL_ENTRY _tg__ZTV4bb10__5cc010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_cc010[] = {
  {&(_ZTV5cc010[3]),  3,3},
  {&(_tg__ZTV4bb10__5cc010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
Class_Descriptor cd_cc010 = {  "cc010", // class name
  bases_cc010, 2,
  &(vtc_cc010[0]), // expected_vtbl_contents
  &(vtt_cc010[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc010),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc010),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0010  : cc010 {
  int d;
  ~dd0010(); // tgen
  dd0010(); // tgen
};
//SIG(-1 dd0010) C1{ BC2{ BC3{ VBC4{ Fi} Fi} Fi} Fi}


dd0010 ::~dd0010(){ note_dtor("dd0010", this);} // tgen
dd0010 ::dd0010(){ note_ctor("dd0010", this);} // tgen

static void Test_dd0010()
{
  extern Class_Descriptor cd_dd0010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0010, buf);
    dd0010 *dp, &lv = *(dp=new (buf) dd0010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(20,16), "dd0010");
    check_base_class_offset(lv, (bb10*)(cc010*), 0, "dd0010");
    check_base_class_offset(lv, (cc010*), 0, "dd0010");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0010.d");
    test_class_info(&lv, &cd_dd0010);
    dp->~dd0010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0010(Test_dd0010, "dd0010", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0010C1Ev();
extern void _ZN6dd0010D1Ev();
Name_Map name_map_dd0010[] = {
  NSPAIR(_ZN6dd0010C1Ev),
  NSPAIR(_ZN6dd0010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd0010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0010[];
static  VTBL_ENTRY vtc_dd0010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
extern VTBL_ENTRY _ZTV6dd0010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd0010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd0010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd0010[] = {
  {&(_ZTV6dd0010[3]),  3,3},
  {&(_tg__ZTV5cc010__6dd0010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd0010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
Class_Descriptor cd_dd0010 = {  "dd0010", // class name
  bases_dd0010, 3,
  &(vtc_dd0010[0]), // expected_vtbl_contents
  &(vtt_dd0010[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0010),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0010),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00010  : dd0010 {
  int e;
  ~ee00010(); // tgen
  ee00010(); // tgen
};
//SIG(1 ee00010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee00010 ::~ee00010(){ note_dtor("ee00010", this);} // tgen
ee00010 ::ee00010(){ note_ctor("ee00010", this);} // tgen

static void Test_ee00010()
{
  extern Class_Descriptor cd_ee00010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00010, buf);
    ee00010 *dp, &lv = *(dp=new (buf) ee00010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(24,20), "ee00010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), 0, "ee00010");
    check_base_class_offset(lv, (cc010*)(dd0010*), 0, "ee00010");
    check_base_class_offset(lv, (dd0010*), 0, "ee00010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00010.e");
    test_class_info(&lv, &cd_ee00010);
    dp->~ee00010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00010(Test_ee00010, "ee00010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00010C1Ev();
extern void _ZN7ee00010D1Ev();
Name_Map name_map_ee00010[] = {
  NSPAIR(_ZN7ee00010C1Ev),
  NSPAIR(_ZN7ee00010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee00010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00010[];
static  VTBL_ENTRY vtc_ee00010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00010[0]),
};
extern VTBL_ENTRY _ZTV7ee00010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee00010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee00010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee00010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee00010[] = {
  {&(_ZTV7ee00010[3]),  3,3},
  {&(_tg__ZTV6dd0010__7ee00010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee00010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee00010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee00010[];
extern  VTBL_ENTRY _ZTV7ee00010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00010[];
Class_Descriptor cd_ee00010 = {  "ee00010", // class name
  bases_ee00010, 4,
  &(vtc_ee00010[0]), // expected_vtbl_contents
  &(vtt_ee00010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00010),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10010  : virtual dd0010 {
  int e;
  ~ee10010(); // tgen
  ee10010(); // tgen
};
//SIG(1 ee10010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee10010 ::~ee10010(){ note_dtor("ee10010", this);} // tgen
ee10010 ::ee10010(){ note_ctor("ee10010", this);} // tgen

static void Test_ee10010()
{
  extern Class_Descriptor cd_ee10010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10010, buf);
    ee10010 *dp, &lv = *(dp=new (buf) ee10010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(36,24), "ee10010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), ABISELECT(16,8), "ee10010");
    check_base_class_offset(lv, (cc010*)(dd0010*), ABISELECT(16,8), "ee10010");
    check_base_class_offset(lv, (dd0010*), ABISELECT(16,8), "ee10010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10010.e");
    test_class_info(&lv, &cd_ee10010);
    dp->~ee10010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10010(Test_ee10010, "ee10010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10010C1Ev();
extern void _ZN7ee10010D1Ev();
Name_Map name_map_ee10010[] = {
  NSPAIR(_ZN7ee10010C1Ev),
  NSPAIR(_ZN7ee10010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee10010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10010[];
static  VTBL_ENTRY vtc_ee10010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10010[0]),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10010[0]),
};
extern VTBL_ENTRY _ZTV7ee10010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee10010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee10010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee10010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee10010[] = {
  {&(_ZTV7ee10010[4]),  4,7},
  {&(_ZTV7ee10010[7]),  7,7},
  {&(_tg__ZTV6dd0010__7ee10010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee10010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee10010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee10010[];
extern  VTBL_ENTRY _ZTV7ee10010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10010[];
Class_Descriptor cd_ee10010 = {  "ee10010", // class name
  bases_ee10010, 4,
  &(vtc_ee10010[0]), // expected_vtbl_contents
  &(vtt_ee10010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10010),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20010  : dd0010 {
  int e;
  virtual void  foo(); // _ZN7ee200103fooEv
  ~ee20010(); // tgen
  ee20010(); // tgen
};
//SIG(1 ee20010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee20010 ::foo(){vfunc_called(this, "_ZN7ee200103fooEv");}
ee20010 ::~ee20010(){ note_dtor("ee20010", this);} // tgen
ee20010 ::ee20010(){ note_ctor("ee20010", this);} // tgen

static void Test_ee20010()
{
  extern Class_Descriptor cd_ee20010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20010, buf);
    ee20010 *dp, &lv = *(dp=new (buf) ee20010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(24,20), "ee20010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), 0, "ee20010");
    check_base_class_offset(lv, (cc010*)(dd0010*), 0, "ee20010");
    check_base_class_offset(lv, (dd0010*), 0, "ee20010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20010.e");
    test_class_info(&lv, &cd_ee20010);
    dp->~ee20010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20010(Test_ee20010, "ee20010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20010C1Ev();
extern void _ZN7ee20010D1Ev();
Name_Map name_map_ee20010[] = {
  NSPAIR(_ZN7ee20010C1Ev),
  NSPAIR(_ZN7ee20010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee20010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20010[];
extern void _ZN7ee200103fooEv();
static  VTBL_ENTRY vtc_ee20010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20010[0]),
  (VTBL_ENTRY)&_ZN7ee200103fooEv,
};
extern VTBL_ENTRY _ZTV7ee20010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee20010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee20010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee20010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee20010[] = {
  {&(_ZTV7ee20010[3]),  3,4},
  {&(_tg__ZTV6dd0010__7ee20010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee20010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee20010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee20010[];
extern  VTBL_ENTRY _ZTV7ee20010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20010[];
Class_Descriptor cd_ee20010 = {  "ee20010", // class name
  bases_ee20010, 4,
  &(vtc_ee20010[0]), // expected_vtbl_contents
  &(vtt_ee20010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30010  : virtual dd0010 {
  int e;
  virtual void  foo(); // _ZN7ee300103fooEv
  ~ee30010(); // tgen
  ee30010(); // tgen
};
//SIG(1 ee30010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee30010 ::foo(){vfunc_called(this, "_ZN7ee300103fooEv");}
ee30010 ::~ee30010(){ note_dtor("ee30010", this);} // tgen
ee30010 ::ee30010(){ note_ctor("ee30010", this);} // tgen

static void Test_ee30010()
{
  extern Class_Descriptor cd_ee30010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30010, buf);
    ee30010 *dp, &lv = *(dp=new (buf) ee30010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(36,24), "ee30010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), ABISELECT(16,8), "ee30010");
    check_base_class_offset(lv, (cc010*)(dd0010*), ABISELECT(16,8), "ee30010");
    check_base_class_offset(lv, (dd0010*), ABISELECT(16,8), "ee30010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30010.e");
    test_class_info(&lv, &cd_ee30010);
    dp->~ee30010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30010(Test_ee30010, "ee30010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30010C1Ev();
extern void _ZN7ee30010D1Ev();
Name_Map name_map_ee30010[] = {
  NSPAIR(_ZN7ee30010C1Ev),
  NSPAIR(_ZN7ee30010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee30010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30010[];
extern void _ZN7ee300103fooEv();
static  VTBL_ENTRY vtc_ee30010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30010[0]),
  (VTBL_ENTRY)&_ZN7ee300103fooEv,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30010[0]),
};
extern VTBL_ENTRY _ZTV7ee30010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee30010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee30010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee30010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee30010[] = {
  {&(_ZTV7ee30010[4]),  4,8},
  {&(_ZTV7ee30010[8]),  8,8},
  {&(_tg__ZTV6dd0010__7ee30010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee30010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee30010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee30010[];
extern  VTBL_ENTRY _ZTV7ee30010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30010[];
Class_Descriptor cd_ee30010 = {  "ee30010", // class name
  bases_ee30010, 4,
  &(vtc_ee30010[0]), // expected_vtbl_contents
  &(vtt_ee30010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40010  : dd0010 {
  int e;
  virtual void  bar(); // _ZN7ee400103barEv
  ~ee40010(); // tgen
  ee40010(); // tgen
};
//SIG(1 ee40010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee40010 ::bar(){vfunc_called(this, "_ZN7ee400103barEv");}
ee40010 ::~ee40010(){ note_dtor("ee40010", this);} // tgen
ee40010 ::ee40010(){ note_ctor("ee40010", this);} // tgen

static void Test_ee40010()
{
  extern Class_Descriptor cd_ee40010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40010, buf);
    ee40010 *dp, &lv = *(dp=new (buf) ee40010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(24,20), "ee40010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), 0, "ee40010");
    check_base_class_offset(lv, (cc010*)(dd0010*), 0, "ee40010");
    check_base_class_offset(lv, (dd0010*), 0, "ee40010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee40010.e");
    test_class_info(&lv, &cd_ee40010);
    dp->~ee40010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40010(Test_ee40010, "ee40010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40010C1Ev();
extern void _ZN7ee40010D1Ev();
Name_Map name_map_ee40010[] = {
  NSPAIR(_ZN7ee40010C1Ev),
  NSPAIR(_ZN7ee40010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee40010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40010[];
extern void _ZN7ee400103barEv();
static  VTBL_ENTRY vtc_ee40010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40010[0]),
  (VTBL_ENTRY)&_ZN7ee400103barEv,
};
extern VTBL_ENTRY _ZTV7ee40010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee40010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee40010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee40010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee40010[] = {
  {&(_ZTV7ee40010[3]),  3,4},
  {&(_tg__ZTV6dd0010__7ee40010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee40010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee40010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee40010[];
extern  VTBL_ENTRY _ZTV7ee40010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40010[];
Class_Descriptor cd_ee40010 = {  "ee40010", // class name
  bases_ee40010, 4,
  &(vtc_ee40010[0]), // expected_vtbl_contents
  &(vtt_ee40010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50010  : virtual dd0010 {
  int e;
  virtual void  bar(); // _ZN7ee500103barEv
  ~ee50010(); // tgen
  ee50010(); // tgen
};
//SIG(1 ee50010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee50010 ::bar(){vfunc_called(this, "_ZN7ee500103barEv");}
ee50010 ::~ee50010(){ note_dtor("ee50010", this);} // tgen
ee50010 ::ee50010(){ note_ctor("ee50010", this);} // tgen

static void Test_ee50010()
{
  extern Class_Descriptor cd_ee50010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50010, buf);
    ee50010 *dp, &lv = *(dp=new (buf) ee50010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(36,24), "ee50010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), ABISELECT(16,8), "ee50010");
    check_base_class_offset(lv, (cc010*)(dd0010*), ABISELECT(16,8), "ee50010");
    check_base_class_offset(lv, (dd0010*), ABISELECT(16,8), "ee50010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50010.e");
    test_class_info(&lv, &cd_ee50010);
    dp->~ee50010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50010(Test_ee50010, "ee50010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50010C1Ev();
extern void _ZN7ee50010D1Ev();
Name_Map name_map_ee50010[] = {
  NSPAIR(_ZN7ee50010C1Ev),
  NSPAIR(_ZN7ee50010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee50010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50010[];
extern void _ZN7ee500103barEv();
static  VTBL_ENTRY vtc_ee50010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50010[0]),
  (VTBL_ENTRY)&_ZN7ee500103barEv,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50010[0]),
};
extern VTBL_ENTRY _ZTV7ee50010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee50010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee50010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee50010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee50010[] = {
  {&(_ZTV7ee50010[4]),  4,8},
  {&(_ZTV7ee50010[8]),  8,8},
  {&(_tg__ZTV6dd0010__7ee50010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee50010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee50010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee50010[];
extern  VTBL_ENTRY _ZTV7ee50010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50010[];
Class_Descriptor cd_ee50010 = {  "ee50010", // class name
  bases_ee50010, 4,
  &(vtc_ee50010[0]), // expected_vtbl_contents
  &(vtt_ee50010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60010  : dd0010 {
  int e;
  virtual void  foo(); // _ZN7ee600103fooEv
  virtual void  bar(); // _ZN7ee600103barEv
  ~ee60010(); // tgen
  ee60010(); // tgen
};
//SIG(1 ee60010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee60010 ::foo(){vfunc_called(this, "_ZN7ee600103fooEv");}
void  ee60010 ::bar(){vfunc_called(this, "_ZN7ee600103barEv");}
ee60010 ::~ee60010(){ note_dtor("ee60010", this);} // tgen
ee60010 ::ee60010(){ note_ctor("ee60010", this);} // tgen

static void Test_ee60010()
{
  extern Class_Descriptor cd_ee60010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60010, buf);
    ee60010 *dp, &lv = *(dp=new (buf) ee60010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(24,20), "ee60010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), 0, "ee60010");
    check_base_class_offset(lv, (cc010*)(dd0010*), 0, "ee60010");
    check_base_class_offset(lv, (dd0010*), 0, "ee60010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee60010.e");
    test_class_info(&lv, &cd_ee60010);
    dp->~ee60010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60010(Test_ee60010, "ee60010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60010C1Ev();
extern void _ZN7ee60010D1Ev();
Name_Map name_map_ee60010[] = {
  NSPAIR(_ZN7ee60010C1Ev),
  NSPAIR(_ZN7ee60010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee60010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60010[];
extern void _ZN7ee600103fooEv();
extern void _ZN7ee600103barEv();
static  VTBL_ENTRY vtc_ee60010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60010[0]),
  (VTBL_ENTRY)&_ZN7ee600103fooEv,
  (VTBL_ENTRY)&_ZN7ee600103barEv,
};
extern VTBL_ENTRY _ZTV7ee60010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee60010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee60010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee60010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee60010[] = {
  {&(_ZTV7ee60010[3]),  3,5},
  {&(_tg__ZTV6dd0010__7ee60010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee60010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee60010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee60010[];
extern  VTBL_ENTRY _ZTV7ee60010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60010[];
Class_Descriptor cd_ee60010 = {  "ee60010", // class name
  bases_ee60010, 4,
  &(vtc_ee60010[0]), // expected_vtbl_contents
  &(vtt_ee60010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70010  : virtual dd0010 {
  int e;
  virtual void  foo(); // _ZN7ee700103fooEv
  virtual void  bar(); // _ZN7ee700103barEv
  ~ee70010(); // tgen
  ee70010(); // tgen
};
//SIG(1 ee70010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee70010 ::foo(){vfunc_called(this, "_ZN7ee700103fooEv");}
void  ee70010 ::bar(){vfunc_called(this, "_ZN7ee700103barEv");}
ee70010 ::~ee70010(){ note_dtor("ee70010", this);} // tgen
ee70010 ::ee70010(){ note_ctor("ee70010", this);} // tgen

static void Test_ee70010()
{
  extern Class_Descriptor cd_ee70010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70010, buf);
    ee70010 *dp, &lv = *(dp=new (buf) ee70010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd0010*), ABISELECT(36,24), "ee70010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd0010*), ABISELECT(16,8), "ee70010");
    check_base_class_offset(lv, (cc010*)(dd0010*), ABISELECT(16,8), "ee70010");
    check_base_class_offset(lv, (dd0010*), ABISELECT(16,8), "ee70010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70010.e");
    test_class_info(&lv, &cd_ee70010);
    dp->~ee70010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70010(Test_ee70010, "ee70010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70010C1Ev();
extern void _ZN7ee70010D1Ev();
Name_Map name_map_ee70010[] = {
  NSPAIR(_ZN7ee70010C1Ev),
  NSPAIR(_ZN7ee70010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd0010;
extern VTBL_ENTRY _ZTI6dd0010[];
extern  VTBL_ENTRY _ZTV6dd0010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0010[];
static Base_Class bases_ee70010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70010[];
extern void _ZN7ee700103fooEv();
extern void _ZN7ee700103barEv();
static  VTBL_ENTRY vtc_ee70010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70010[0]),
  (VTBL_ENTRY)&_ZN7ee700103fooEv,
  (VTBL_ENTRY)&_ZN7ee700103barEv,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70010[0]),
};
extern VTBL_ENTRY _ZTV7ee70010[];
static  VTBL_ENTRY _tg__ZTV6dd0010__7ee70010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd0010__7ee70010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd0010__7ee70010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee70010[] = {
  {&(_ZTV7ee70010[4]),  4,9},
  {&(_ZTV7ee70010[9]),  9,9},
  {&(_tg__ZTV6dd0010__7ee70010[3]),  3,3},
  {&(_tg__ZTV5cc0106dd0010__7ee70010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd0010__7ee70010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee70010[];
extern  VTBL_ENTRY _ZTV7ee70010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70010[];
Class_Descriptor cd_ee70010 = {  "ee70010", // class name
  bases_ee70010, 4,
  &(vtc_ee70010[0]), // expected_vtbl_contents
  &(vtt_ee70010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1010  : virtual cc010 {
  int d;
  ~dd1010(); // tgen
  dd1010(); // tgen
};
//SIG(-1 dd1010) C1{ VBC2{ BC3{ VBC4{ Fi} Fi} Fi} Fi}


dd1010 ::~dd1010(){ note_dtor("dd1010", this);} // tgen
dd1010 ::dd1010(){ note_ctor("dd1010", this);} // tgen

static void Test_dd1010()
{
  extern Class_Descriptor cd_dd1010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1010, buf);
    dd1010 *dp, &lv = *(dp=new (buf) dd1010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,20), "dd1010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,8), "dd1010");
    check_base_class_offset(lv, (cc010*), ABISELECT(16,8), "dd1010");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1010.d");
    test_class_info(&lv, &cd_dd1010);
    dp->~dd1010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1010(Test_dd1010, "dd1010", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1010C1Ev();
extern void _ZN6dd1010D1Ev();
Name_Map name_map_dd1010[] = {
  NSPAIR(_ZN6dd1010C1Ev),
  NSPAIR(_ZN6dd1010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd1010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1010[];
static  VTBL_ENTRY vtc_dd1010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
extern VTBL_ENTRY _ZTV6dd1010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd1010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd1010[] = {
  {&(_ZTV6dd1010[4]),  4,7},
  {&(_ZTV6dd1010[7]),  7,7},
  {&(_tg__ZTV5cc010__6dd1010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd1010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
Class_Descriptor cd_dd1010 = {  "dd1010", // class name
  bases_dd1010, 3,
  &(vtc_dd1010[0]), // expected_vtbl_contents
  &(vtt_dd1010[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1010),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1010),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01010  : dd1010 {
  int e;
  ~ee01010(); // tgen
  ee01010(); // tgen
};
//SIG(1 ee01010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee01010 ::~ee01010(){ note_dtor("ee01010", this);} // tgen
ee01010 ::ee01010(){ note_ctor("ee01010", this);} // tgen

static void Test_ee01010()
{
  extern Class_Descriptor cd_ee01010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01010, buf);
    ee01010 *dp, &lv = *(dp=new (buf) ee01010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee01010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee01010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(16,12), "ee01010");
    check_base_class_offset(lv, (dd1010*), 0, "ee01010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01010.e");
    test_class_info(&lv, &cd_ee01010);
    dp->~ee01010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01010(Test_ee01010, "ee01010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01010C1Ev();
extern void _ZN7ee01010D1Ev();
Name_Map name_map_ee01010[] = {
  NSPAIR(_ZN7ee01010C1Ev),
  NSPAIR(_ZN7ee01010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee01010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01010[];
static  VTBL_ENTRY vtc_ee01010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01010[0]),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01010[0]),
};
extern VTBL_ENTRY _ZTV7ee01010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee01010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee01010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee01010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee01010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee01010[] = {
  {&(_ZTV7ee01010[4]),  4,7},
  {&(_tg__ZTV6dd1010__7ee01010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee01010[3]),  3,3},
  {&(_ZTV7ee01010[7]),  7,7},
  {&(_tg__ZTV5cc010__7ee01010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee01010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee01010[];
extern  VTBL_ENTRY _ZTV7ee01010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01010[];
Class_Descriptor cd_ee01010 = {  "ee01010", // class name
  bases_ee01010, 4,
  &(vtc_ee01010[0]), // expected_vtbl_contents
  &(vtt_ee01010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01010),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11010  : virtual dd1010 {
  int e;
  ~ee11010(); // tgen
  ee11010(); // tgen
};
//SIG(1 ee11010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee11010 ::~ee11010(){ note_dtor("ee11010", this);} // tgen
ee11010 ::ee11010(){ note_ctor("ee11010", this);} // tgen

static void Test_ee11010()
{
  extern Class_Descriptor cd_ee11010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11010, buf);
    ee11010 *dp, &lv = *(dp=new (buf) ee11010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee11010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee11010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(32,16), "ee11010");
    check_base_class_offset(lv, (dd1010*), ABISELECT(16,8), "ee11010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11010.e");
    test_class_info(&lv, &cd_ee11010);
    dp->~ee11010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11010(Test_ee11010, "ee11010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11010C1Ev();
extern void _ZN7ee11010D1Ev();
Name_Map name_map_ee11010[] = {
  NSPAIR(_ZN7ee11010C1Ev),
  NSPAIR(_ZN7ee11010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee11010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11010[];
static  VTBL_ENTRY vtc_ee11010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11010[0]),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11010[0]),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11010[0]),
};
extern VTBL_ENTRY _ZTV7ee11010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee11010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee11010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee11010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee11010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee11010[] = {
  {&(_ZTV7ee11010[5]),  5,12},
  {&(_ZTV7ee11010[9]),  9,12},
  {&(_ZTV7ee11010[12]),  12,12},
  {&(_tg__ZTV6dd1010__7ee11010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee11010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee11010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee11010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee11010[];
extern  VTBL_ENTRY _ZTV7ee11010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11010[];
Class_Descriptor cd_ee11010 = {  "ee11010", // class name
  bases_ee11010, 4,
  &(vtc_ee11010[0]), // expected_vtbl_contents
  &(vtt_ee11010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11010),12, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21010  : dd1010 {
  int e;
  virtual void  foo(); // _ZN7ee210103fooEv
  ~ee21010(); // tgen
  ee21010(); // tgen
};
//SIG(1 ee21010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee21010 ::foo(){vfunc_called(this, "_ZN7ee210103fooEv");}
ee21010 ::~ee21010(){ note_dtor("ee21010", this);} // tgen
ee21010 ::ee21010(){ note_ctor("ee21010", this);} // tgen

static void Test_ee21010()
{
  extern Class_Descriptor cd_ee21010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21010, buf);
    ee21010 *dp, &lv = *(dp=new (buf) ee21010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee21010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee21010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(16,12), "ee21010");
    check_base_class_offset(lv, (dd1010*), 0, "ee21010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21010.e");
    test_class_info(&lv, &cd_ee21010);
    dp->~ee21010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21010(Test_ee21010, "ee21010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21010C1Ev();
extern void _ZN7ee21010D1Ev();
Name_Map name_map_ee21010[] = {
  NSPAIR(_ZN7ee21010C1Ev),
  NSPAIR(_ZN7ee21010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee21010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21010[];
extern void _ZN7ee210103fooEv();
static  VTBL_ENTRY vtc_ee21010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21010[0]),
  (VTBL_ENTRY)&_ZN7ee210103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21010[0]),
};
extern VTBL_ENTRY _ZTV7ee21010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee21010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee21010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee21010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee21010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee21010[] = {
  {&(_ZTV7ee21010[4]),  4,8},
  {&(_tg__ZTV6dd1010__7ee21010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee21010[3]),  3,3},
  {&(_ZTV7ee21010[8]),  8,8},
  {&(_tg__ZTV5cc010__7ee21010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee21010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee21010[];
extern  VTBL_ENTRY _ZTV7ee21010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21010[];
Class_Descriptor cd_ee21010 = {  "ee21010", // class name
  bases_ee21010, 4,
  &(vtc_ee21010[0]), // expected_vtbl_contents
  &(vtt_ee21010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31010  : virtual dd1010 {
  int e;
  virtual void  foo(); // _ZN7ee310103fooEv
  ~ee31010(); // tgen
  ee31010(); // tgen
};
//SIG(1 ee31010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee31010 ::foo(){vfunc_called(this, "_ZN7ee310103fooEv");}
ee31010 ::~ee31010(){ note_dtor("ee31010", this);} // tgen
ee31010 ::ee31010(){ note_ctor("ee31010", this);} // tgen

static void Test_ee31010()
{
  extern Class_Descriptor cd_ee31010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31010, buf);
    ee31010 *dp, &lv = *(dp=new (buf) ee31010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee31010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee31010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(32,16), "ee31010");
    check_base_class_offset(lv, (dd1010*), ABISELECT(16,8), "ee31010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31010.e");
    test_class_info(&lv, &cd_ee31010);
    dp->~ee31010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31010(Test_ee31010, "ee31010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31010C1Ev();
extern void _ZN7ee31010D1Ev();
Name_Map name_map_ee31010[] = {
  NSPAIR(_ZN7ee31010C1Ev),
  NSPAIR(_ZN7ee31010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee31010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31010[];
extern void _ZN7ee310103fooEv();
static  VTBL_ENTRY vtc_ee31010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31010[0]),
  (VTBL_ENTRY)&_ZN7ee310103fooEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31010[0]),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31010[0]),
};
extern VTBL_ENTRY _ZTV7ee31010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee31010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee31010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee31010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee31010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee31010[] = {
  {&(_ZTV7ee31010[5]),  5,13},
  {&(_ZTV7ee31010[10]),  10,13},
  {&(_ZTV7ee31010[13]),  13,13},
  {&(_tg__ZTV6dd1010__7ee31010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee31010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee31010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee31010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee31010[];
extern  VTBL_ENTRY _ZTV7ee31010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31010[];
Class_Descriptor cd_ee31010 = {  "ee31010", // class name
  bases_ee31010, 4,
  &(vtc_ee31010[0]), // expected_vtbl_contents
  &(vtt_ee31010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31010),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41010  : dd1010 {
  int e;
  virtual void  bar(); // _ZN7ee410103barEv
  ~ee41010(); // tgen
  ee41010(); // tgen
};
//SIG(1 ee41010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee41010 ::bar(){vfunc_called(this, "_ZN7ee410103barEv");}
ee41010 ::~ee41010(){ note_dtor("ee41010", this);} // tgen
ee41010 ::ee41010(){ note_ctor("ee41010", this);} // tgen

static void Test_ee41010()
{
  extern Class_Descriptor cd_ee41010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41010, buf);
    ee41010 *dp, &lv = *(dp=new (buf) ee41010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee41010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee41010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(16,12), "ee41010");
    check_base_class_offset(lv, (dd1010*), 0, "ee41010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41010.e");
    test_class_info(&lv, &cd_ee41010);
    dp->~ee41010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41010(Test_ee41010, "ee41010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41010C1Ev();
extern void _ZN7ee41010D1Ev();
Name_Map name_map_ee41010[] = {
  NSPAIR(_ZN7ee41010C1Ev),
  NSPAIR(_ZN7ee41010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee41010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41010[];
extern void _ZN7ee410103barEv();
static  VTBL_ENTRY vtc_ee41010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41010[0]),
  (VTBL_ENTRY)&_ZN7ee410103barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41010[0]),
};
extern VTBL_ENTRY _ZTV7ee41010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee41010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee41010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee41010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee41010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee41010[] = {
  {&(_ZTV7ee41010[4]),  4,8},
  {&(_tg__ZTV6dd1010__7ee41010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee41010[3]),  3,3},
  {&(_ZTV7ee41010[8]),  8,8},
  {&(_tg__ZTV5cc010__7ee41010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee41010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee41010[];
extern  VTBL_ENTRY _ZTV7ee41010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41010[];
Class_Descriptor cd_ee41010 = {  "ee41010", // class name
  bases_ee41010, 4,
  &(vtc_ee41010[0]), // expected_vtbl_contents
  &(vtt_ee41010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51010  : virtual dd1010 {
  int e;
  virtual void  bar(); // _ZN7ee510103barEv
  ~ee51010(); // tgen
  ee51010(); // tgen
};
//SIG(1 ee51010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee51010 ::bar(){vfunc_called(this, "_ZN7ee510103barEv");}
ee51010 ::~ee51010(){ note_dtor("ee51010", this);} // tgen
ee51010 ::ee51010(){ note_ctor("ee51010", this);} // tgen

static void Test_ee51010()
{
  extern Class_Descriptor cd_ee51010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51010, buf);
    ee51010 *dp, &lv = *(dp=new (buf) ee51010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee51010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee51010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(32,16), "ee51010");
    check_base_class_offset(lv, (dd1010*), ABISELECT(16,8), "ee51010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51010.e");
    test_class_info(&lv, &cd_ee51010);
    dp->~ee51010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51010(Test_ee51010, "ee51010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51010C1Ev();
extern void _ZN7ee51010D1Ev();
Name_Map name_map_ee51010[] = {
  NSPAIR(_ZN7ee51010C1Ev),
  NSPAIR(_ZN7ee51010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee51010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51010[];
extern void _ZN7ee510103barEv();
static  VTBL_ENTRY vtc_ee51010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51010[0]),
  (VTBL_ENTRY)&_ZN7ee510103barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51010[0]),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51010[0]),
};
extern VTBL_ENTRY _ZTV7ee51010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee51010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee51010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee51010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee51010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee51010[] = {
  {&(_ZTV7ee51010[5]),  5,13},
  {&(_ZTV7ee51010[10]),  10,13},
  {&(_ZTV7ee51010[13]),  13,13},
  {&(_tg__ZTV6dd1010__7ee51010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee51010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee51010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee51010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee51010[];
extern  VTBL_ENTRY _ZTV7ee51010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51010[];
Class_Descriptor cd_ee51010 = {  "ee51010", // class name
  bases_ee51010, 4,
  &(vtc_ee51010[0]), // expected_vtbl_contents
  &(vtt_ee51010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51010),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61010  : dd1010 {
  int e;
  virtual void  foo(); // _ZN7ee610103fooEv
  virtual void  bar(); // _ZN7ee610103barEv
  ~ee61010(); // tgen
  ee61010(); // tgen
};
//SIG(1 ee61010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee61010 ::foo(){vfunc_called(this, "_ZN7ee610103fooEv");}
void  ee61010 ::bar(){vfunc_called(this, "_ZN7ee610103barEv");}
ee61010 ::~ee61010(){ note_dtor("ee61010", this);} // tgen
ee61010 ::ee61010(){ note_ctor("ee61010", this);} // tgen

static void Test_ee61010()
{
  extern Class_Descriptor cd_ee61010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61010, buf);
    ee61010 *dp, &lv = *(dp=new (buf) ee61010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee61010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee61010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(16,12), "ee61010");
    check_base_class_offset(lv, (dd1010*), 0, "ee61010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61010.e");
    test_class_info(&lv, &cd_ee61010);
    dp->~ee61010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61010(Test_ee61010, "ee61010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61010C1Ev();
extern void _ZN7ee61010D1Ev();
Name_Map name_map_ee61010[] = {
  NSPAIR(_ZN7ee61010C1Ev),
  NSPAIR(_ZN7ee61010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee61010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61010[];
extern void _ZN7ee610103fooEv();
extern void _ZN7ee610103barEv();
static  VTBL_ENTRY vtc_ee61010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61010[0]),
  (VTBL_ENTRY)&_ZN7ee610103fooEv,
  (VTBL_ENTRY)&_ZN7ee610103barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61010[0]),
};
extern VTBL_ENTRY _ZTV7ee61010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee61010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee61010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee61010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee61010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee61010[] = {
  {&(_ZTV7ee61010[4]),  4,9},
  {&(_tg__ZTV6dd1010__7ee61010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee61010[3]),  3,3},
  {&(_ZTV7ee61010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee61010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee61010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee61010[];
extern  VTBL_ENTRY _ZTV7ee61010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61010[];
Class_Descriptor cd_ee61010 = {  "ee61010", // class name
  bases_ee61010, 4,
  &(vtc_ee61010[0]), // expected_vtbl_contents
  &(vtt_ee61010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71010  : virtual dd1010 {
  int e;
  virtual void  foo(); // _ZN7ee710103fooEv
  virtual void  bar(); // _ZN7ee710103barEv
  ~ee71010(); // tgen
  ee71010(); // tgen
};
//SIG(1 ee71010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee71010 ::foo(){vfunc_called(this, "_ZN7ee710103fooEv");}
void  ee71010 ::bar(){vfunc_called(this, "_ZN7ee710103barEv");}
ee71010 ::~ee71010(){ note_dtor("ee71010", this);} // tgen
ee71010 ::ee71010(){ note_ctor("ee71010", this);} // tgen

static void Test_ee71010()
{
  extern Class_Descriptor cd_ee71010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71010, buf);
    ee71010 *dp, &lv = *(dp=new (buf) ee71010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee71010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee71010");
    check_base_class_offset(lv, (cc010*)(dd1010*), ABISELECT(32,16), "ee71010");
    check_base_class_offset(lv, (dd1010*), ABISELECT(16,8), "ee71010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71010.e");
    test_class_info(&lv, &cd_ee71010);
    dp->~ee71010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71010(Test_ee71010, "ee71010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71010C1Ev();
extern void _ZN7ee71010D1Ev();
Name_Map name_map_ee71010[] = {
  NSPAIR(_ZN7ee71010C1Ev),
  NSPAIR(_ZN7ee71010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd1010;
extern VTBL_ENTRY _ZTI6dd1010[];
extern  VTBL_ENTRY _ZTV6dd1010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1010[];
static Base_Class bases_ee71010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1010,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71010[];
extern void _ZN7ee710103fooEv();
extern void _ZN7ee710103barEv();
static  VTBL_ENTRY vtc_ee71010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71010[0]),
  (VTBL_ENTRY)&_ZN7ee710103fooEv,
  (VTBL_ENTRY)&_ZN7ee710103barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71010[0]),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71010[0]),
};
extern VTBL_ENTRY _ZTV7ee71010[];
static  VTBL_ENTRY _tg__ZTV6dd1010__7ee71010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd1010__7ee71010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee71010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee71010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee71010[] = {
  {&(_ZTV7ee71010[5]),  5,14},
  {&(_ZTV7ee71010[11]),  11,14},
  {&(_ZTV7ee71010[14]),  14,14},
  {&(_tg__ZTV6dd1010__7ee71010[4]),  4,4},
  {&(_tg__ZTV5cc010__6dd1010__7ee71010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee71010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee71010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee71010[];
extern  VTBL_ENTRY _ZTV7ee71010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71010[];
Class_Descriptor cd_ee71010 = {  "ee71010", // class name
  bases_ee71010, 4,
  &(vtc_ee71010[0]), // expected_vtbl_contents
  &(vtt_ee71010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71010),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2010  : cc010 {
  int d;
  virtual void  foo(); // _ZN6dd20103fooEv
  ~dd2010(); // tgen
  dd2010(); // tgen
};
//SIG(-1 dd2010) C1{ BC2{ BC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd2010 ::foo(){vfunc_called(this, "_ZN6dd20103fooEv");}
dd2010 ::~dd2010(){ note_dtor("dd2010", this);} // tgen
dd2010 ::dd2010(){ note_ctor("dd2010", this);} // tgen

static void Test_dd2010()
{
  extern Class_Descriptor cd_dd2010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2010, buf);
    dd2010 *dp, &lv = *(dp=new (buf) dd2010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(20,16), "dd2010");
    check_base_class_offset(lv, (bb10*)(cc010*), 0, "dd2010");
    check_base_class_offset(lv, (cc010*), 0, "dd2010");
    check_field_offset(lv, d, ABISELECT(16,12), "dd2010.d");
    test_class_info(&lv, &cd_dd2010);
    dp->~dd2010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2010(Test_dd2010, "dd2010", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2010C1Ev();
extern void _ZN6dd2010D1Ev();
Name_Map name_map_dd2010[] = {
  NSPAIR(_ZN6dd2010C1Ev),
  NSPAIR(_ZN6dd2010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd2010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY vtc_dd2010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
extern VTBL_ENTRY _ZTV6dd2010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd2010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd2010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd2010[] = {
  {&(_ZTV6dd2010[3]),  3,4},
  {&(_tg__ZTV5cc010__6dd2010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd2010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
Class_Descriptor cd_dd2010 = {  "dd2010", // class name
  bases_dd2010, 3,
  &(vtc_dd2010[0]), // expected_vtbl_contents
  &(vtt_dd2010[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2010),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02010  : dd2010 {
  int e;
  ~ee02010(); // tgen
  ee02010(); // tgen
};
//SIG(1 ee02010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee02010 ::~ee02010(){ note_dtor("ee02010", this);} // tgen
ee02010 ::ee02010(){ note_ctor("ee02010", this);} // tgen

static void Test_ee02010()
{
  extern Class_Descriptor cd_ee02010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02010, buf);
    ee02010 *dp, &lv = *(dp=new (buf) ee02010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(24,20), "ee02010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), 0, "ee02010");
    check_base_class_offset(lv, (cc010*)(dd2010*), 0, "ee02010");
    check_base_class_offset(lv, (dd2010*), 0, "ee02010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee02010.e");
    test_class_info(&lv, &cd_ee02010);
    dp->~ee02010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02010(Test_ee02010, "ee02010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02010C1Ev();
extern void _ZN7ee02010D1Ev();
Name_Map name_map_ee02010[] = {
  NSPAIR(_ZN7ee02010C1Ev),
  NSPAIR(_ZN7ee02010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee02010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY vtc_ee02010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
extern VTBL_ENTRY _ZTV7ee02010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee02010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee02010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee02010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee02010[] = {
  {&(_ZTV7ee02010[3]),  3,4},
  {&(_tg__ZTV6dd2010__7ee02010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee02010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee02010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee02010[];
extern  VTBL_ENTRY _ZTV7ee02010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02010[];
Class_Descriptor cd_ee02010 = {  "ee02010", // class name
  bases_ee02010, 4,
  &(vtc_ee02010[0]), // expected_vtbl_contents
  &(vtt_ee02010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12010  : virtual dd2010 {
  int e;
  ~ee12010(); // tgen
  ee12010(); // tgen
};
//SIG(1 ee12010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee12010 ::~ee12010(){ note_dtor("ee12010", this);} // tgen
ee12010 ::ee12010(){ note_ctor("ee12010", this);} // tgen

static void Test_ee12010()
{
  extern Class_Descriptor cd_ee12010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12010, buf);
    ee12010 *dp, &lv = *(dp=new (buf) ee12010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(36,24), "ee12010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), ABISELECT(16,8), "ee12010");
    check_base_class_offset(lv, (cc010*)(dd2010*), ABISELECT(16,8), "ee12010");
    check_base_class_offset(lv, (dd2010*), ABISELECT(16,8), "ee12010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12010.e");
    test_class_info(&lv, &cd_ee12010);
    dp->~ee12010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12010(Test_ee12010, "ee12010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12010C1Ev();
extern void _ZN7ee12010D1Ev();
Name_Map name_map_ee12010[] = {
  NSPAIR(_ZN7ee12010C1Ev),
  NSPAIR(_ZN7ee12010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee12010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY vtc_ee12010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12010[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
extern VTBL_ENTRY _ZTV7ee12010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee12010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee12010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee12010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee12010[] = {
  {&(_ZTV7ee12010[4]),  4,9},
  {&(_ZTV7ee12010[8]),  8,9},
  {&(_tg__ZTV6dd2010__7ee12010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee12010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee12010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee12010[];
extern  VTBL_ENTRY _ZTV7ee12010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12010[];
Class_Descriptor cd_ee12010 = {  "ee12010", // class name
  bases_ee12010, 4,
  &(vtc_ee12010[0]), // expected_vtbl_contents
  &(vtt_ee12010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22010  : dd2010 {
  int e;
  virtual void  foo(); // _ZN7ee220103fooEv
  ~ee22010(); // tgen
  ee22010(); // tgen
};
//SIG(1 ee22010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee22010 ::foo(){vfunc_called(this, "_ZN7ee220103fooEv");}
ee22010 ::~ee22010(){ note_dtor("ee22010", this);} // tgen
ee22010 ::ee22010(){ note_ctor("ee22010", this);} // tgen

static void Test_ee22010()
{
  extern Class_Descriptor cd_ee22010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22010, buf);
    ee22010 *dp, &lv = *(dp=new (buf) ee22010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(24,20), "ee22010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), 0, "ee22010");
    check_base_class_offset(lv, (cc010*)(dd2010*), 0, "ee22010");
    check_base_class_offset(lv, (dd2010*), 0, "ee22010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee22010.e");
    test_class_info(&lv, &cd_ee22010);
    dp->~ee22010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22010(Test_ee22010, "ee22010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22010C1Ev();
extern void _ZN7ee22010D1Ev();
Name_Map name_map_ee22010[] = {
  NSPAIR(_ZN7ee22010C1Ev),
  NSPAIR(_ZN7ee22010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee22010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22010[];
extern void _ZN7ee220103fooEv();
static  VTBL_ENTRY vtc_ee22010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22010[0]),
  (VTBL_ENTRY)&_ZN7ee220103fooEv,
};
extern VTBL_ENTRY _ZTV7ee22010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee22010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee22010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee22010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee22010[] = {
  {&(_ZTV7ee22010[3]),  3,4},
  {&(_tg__ZTV6dd2010__7ee22010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee22010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee22010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee22010[];
extern  VTBL_ENTRY _ZTV7ee22010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22010[];
Class_Descriptor cd_ee22010 = {  "ee22010", // class name
  bases_ee22010, 4,
  &(vtc_ee22010[0]), // expected_vtbl_contents
  &(vtt_ee22010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32010  : virtual dd2010 {
  int e;
  virtual void  foo(); // _ZN7ee320103fooEv
  ~ee32010(); // tgen
  ee32010(); // tgen
};
//SIG(1 ee32010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee32010 ::foo(){vfunc_called(this, "_ZN7ee320103fooEv");}
ee32010 ::~ee32010(){ note_dtor("ee32010", this);} // tgen
ee32010 ::ee32010(){ note_ctor("ee32010", this);} // tgen

static void Test_ee32010()
{
  extern Class_Descriptor cd_ee32010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32010, buf);
    ee32010 *dp, &lv = *(dp=new (buf) ee32010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(36,24), "ee32010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), ABISELECT(16,8), "ee32010");
    check_base_class_offset(lv, (cc010*)(dd2010*), ABISELECT(16,8), "ee32010");
    check_base_class_offset(lv, (dd2010*), ABISELECT(16,8), "ee32010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32010.e");
    test_class_info(&lv, &cd_ee32010);
    dp->~ee32010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32010(Test_ee32010, "ee32010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32010C1Ev();
extern void _ZN7ee32010D1Ev();
Name_Map name_map_ee32010[] = {
  NSPAIR(_ZN7ee32010C1Ev),
  NSPAIR(_ZN7ee32010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee32010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32010[];
extern void _ZN7ee320103fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee320103fooEv,_ZTv0_n16_N7ee320103fooEv)();
extern void ABISELECT(_ZThn16_N7ee320103fooEv,_ZThn8_N7ee320103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32010[0]),
  (VTBL_ENTRY)&_ZN7ee320103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee320103fooEv,_ZTv0_n16_N7ee320103fooEv),
};
extern VTBL_ENTRY _ZTV7ee32010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee32010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee32010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee32010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee32010[] = {
  {&(_ZTV7ee32010[4]),  4,10},
  {&(_ZTV7ee32010[9]),  9,10},
  {&(_tg__ZTV6dd2010__7ee32010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee32010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee32010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee32010[];
extern  VTBL_ENTRY _ZTV7ee32010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32010[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee320103fooEv,_ZTv0_n16_N7ee320103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320103fooEv,_ZThn8_N7ee320103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32010 = {  "ee32010", // class name
  bases_ee32010, 4,
  &(vtc_ee32010[0]), // expected_vtbl_contents
  &(vtt_ee32010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32010),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42010  : dd2010 {
  int e;
  virtual void  bar(); // _ZN7ee420103barEv
  ~ee42010(); // tgen
  ee42010(); // tgen
};
//SIG(1 ee42010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee42010 ::bar(){vfunc_called(this, "_ZN7ee420103barEv");}
ee42010 ::~ee42010(){ note_dtor("ee42010", this);} // tgen
ee42010 ::ee42010(){ note_ctor("ee42010", this);} // tgen

static void Test_ee42010()
{
  extern Class_Descriptor cd_ee42010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42010, buf);
    ee42010 *dp, &lv = *(dp=new (buf) ee42010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(24,20), "ee42010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), 0, "ee42010");
    check_base_class_offset(lv, (cc010*)(dd2010*), 0, "ee42010");
    check_base_class_offset(lv, (dd2010*), 0, "ee42010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee42010.e");
    test_class_info(&lv, &cd_ee42010);
    dp->~ee42010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42010(Test_ee42010, "ee42010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42010C1Ev();
extern void _ZN7ee42010D1Ev();
Name_Map name_map_ee42010[] = {
  NSPAIR(_ZN7ee42010C1Ev),
  NSPAIR(_ZN7ee42010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee42010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42010[];
extern void _ZN6dd20103fooEv();
extern void _ZN7ee420103barEv();
static  VTBL_ENTRY vtc_ee42010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
  (VTBL_ENTRY)&_ZN7ee420103barEv,
};
extern VTBL_ENTRY _ZTV7ee42010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee42010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee42010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee42010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee42010[] = {
  {&(_ZTV7ee42010[3]),  3,5},
  {&(_tg__ZTV6dd2010__7ee42010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee42010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee42010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee42010[];
extern  VTBL_ENTRY _ZTV7ee42010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42010[];
Class_Descriptor cd_ee42010 = {  "ee42010", // class name
  bases_ee42010, 4,
  &(vtc_ee42010[0]), // expected_vtbl_contents
  &(vtt_ee42010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52010  : virtual dd2010 {
  int e;
  virtual void  bar(); // _ZN7ee520103barEv
  ~ee52010(); // tgen
  ee52010(); // tgen
};
//SIG(1 ee52010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee52010 ::bar(){vfunc_called(this, "_ZN7ee520103barEv");}
ee52010 ::~ee52010(){ note_dtor("ee52010", this);} // tgen
ee52010 ::ee52010(){ note_ctor("ee52010", this);} // tgen

static void Test_ee52010()
{
  extern Class_Descriptor cd_ee52010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52010, buf);
    ee52010 *dp, &lv = *(dp=new (buf) ee52010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(36,24), "ee52010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), ABISELECT(16,8), "ee52010");
    check_base_class_offset(lv, (cc010*)(dd2010*), ABISELECT(16,8), "ee52010");
    check_base_class_offset(lv, (dd2010*), ABISELECT(16,8), "ee52010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52010.e");
    test_class_info(&lv, &cd_ee52010);
    dp->~ee52010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52010(Test_ee52010, "ee52010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52010C1Ev();
extern void _ZN7ee52010D1Ev();
Name_Map name_map_ee52010[] = {
  NSPAIR(_ZN7ee52010C1Ev),
  NSPAIR(_ZN7ee52010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee52010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52010[];
extern void _ZN7ee520103barEv();
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY vtc_ee52010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52010[0]),
  (VTBL_ENTRY)&_ZN7ee520103barEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
extern VTBL_ENTRY _ZTV7ee52010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee52010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee52010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee52010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee52010[] = {
  {&(_ZTV7ee52010[4]),  4,10},
  {&(_ZTV7ee52010[9]),  9,10},
  {&(_tg__ZTV6dd2010__7ee52010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee52010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee52010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee52010[];
extern  VTBL_ENTRY _ZTV7ee52010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52010[];
Class_Descriptor cd_ee52010 = {  "ee52010", // class name
  bases_ee52010, 4,
  &(vtc_ee52010[0]), // expected_vtbl_contents
  &(vtt_ee52010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52010),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62010  : dd2010 {
  int e;
  virtual void  foo(); // _ZN7ee620103fooEv
  virtual void  bar(); // _ZN7ee620103barEv
  ~ee62010(); // tgen
  ee62010(); // tgen
};
//SIG(1 ee62010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62010 ::foo(){vfunc_called(this, "_ZN7ee620103fooEv");}
void  ee62010 ::bar(){vfunc_called(this, "_ZN7ee620103barEv");}
ee62010 ::~ee62010(){ note_dtor("ee62010", this);} // tgen
ee62010 ::ee62010(){ note_ctor("ee62010", this);} // tgen

static void Test_ee62010()
{
  extern Class_Descriptor cd_ee62010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62010, buf);
    ee62010 *dp, &lv = *(dp=new (buf) ee62010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(24,20), "ee62010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), 0, "ee62010");
    check_base_class_offset(lv, (cc010*)(dd2010*), 0, "ee62010");
    check_base_class_offset(lv, (dd2010*), 0, "ee62010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee62010.e");
    test_class_info(&lv, &cd_ee62010);
    dp->~ee62010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62010(Test_ee62010, "ee62010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62010C1Ev();
extern void _ZN7ee62010D1Ev();
Name_Map name_map_ee62010[] = {
  NSPAIR(_ZN7ee62010C1Ev),
  NSPAIR(_ZN7ee62010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee62010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62010[];
extern void _ZN7ee620103fooEv();
extern void _ZN7ee620103barEv();
static  VTBL_ENTRY vtc_ee62010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62010[0]),
  (VTBL_ENTRY)&_ZN7ee620103fooEv,
  (VTBL_ENTRY)&_ZN7ee620103barEv,
};
extern VTBL_ENTRY _ZTV7ee62010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee62010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee62010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee62010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee62010[] = {
  {&(_ZTV7ee62010[3]),  3,5},
  {&(_tg__ZTV6dd2010__7ee62010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee62010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee62010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee62010[];
extern  VTBL_ENTRY _ZTV7ee62010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62010[];
Class_Descriptor cd_ee62010 = {  "ee62010", // class name
  bases_ee62010, 4,
  &(vtc_ee62010[0]), // expected_vtbl_contents
  &(vtt_ee62010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72010  : virtual dd2010 {
  int e;
  virtual void  foo(); // _ZN7ee720103fooEv
  virtual void  bar(); // _ZN7ee720103barEv
  ~ee72010(); // tgen
  ee72010(); // tgen
};
//SIG(1 ee72010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72010 ::foo(){vfunc_called(this, "_ZN7ee720103fooEv");}
void  ee72010 ::bar(){vfunc_called(this, "_ZN7ee720103barEv");}
ee72010 ::~ee72010(){ note_dtor("ee72010", this);} // tgen
ee72010 ::ee72010(){ note_ctor("ee72010", this);} // tgen

static void Test_ee72010()
{
  extern Class_Descriptor cd_ee72010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72010, buf);
    ee72010 *dp, &lv = *(dp=new (buf) ee72010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd2010*), ABISELECT(36,24), "ee72010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd2010*), ABISELECT(16,8), "ee72010");
    check_base_class_offset(lv, (cc010*)(dd2010*), ABISELECT(16,8), "ee72010");
    check_base_class_offset(lv, (dd2010*), ABISELECT(16,8), "ee72010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72010.e");
    test_class_info(&lv, &cd_ee72010);
    dp->~ee72010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72010(Test_ee72010, "ee72010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72010C1Ev();
extern void _ZN7ee72010D1Ev();
Name_Map name_map_ee72010[] = {
  NSPAIR(_ZN7ee72010C1Ev),
  NSPAIR(_ZN7ee72010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd2010;
extern VTBL_ENTRY _ZTI6dd2010[];
extern  VTBL_ENTRY _ZTV6dd2010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2010[];
static Base_Class bases_ee72010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72010[];
extern void _ZN7ee720103fooEv();
extern void _ZN7ee720103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee720103fooEv,_ZTv0_n16_N7ee720103fooEv)();
extern void ABISELECT(_ZThn16_N7ee720103fooEv,_ZThn8_N7ee720103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72010[0]),
  (VTBL_ENTRY)&_ZN7ee720103fooEv,
  (VTBL_ENTRY)&_ZN7ee720103barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee720103fooEv,_ZTv0_n16_N7ee720103fooEv),
};
extern VTBL_ENTRY _ZTV7ee72010[];
extern void _ZN6dd20103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2010__7ee72010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2010[0]),
  (VTBL_ENTRY)&_ZN6dd20103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd2010__7ee72010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd2010__7ee72010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee72010[] = {
  {&(_ZTV7ee72010[4]),  4,11},
  {&(_ZTV7ee72010[10]),  10,11},
  {&(_tg__ZTV6dd2010__7ee72010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd2010__7ee72010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd2010__7ee72010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee72010[];
extern  VTBL_ENTRY _ZTV7ee72010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72010[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee720103fooEv,_ZTv0_n16_N7ee720103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720103fooEv,_ZThn8_N7ee720103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72010 = {  "ee72010", // class name
  bases_ee72010, 4,
  &(vtc_ee72010[0]), // expected_vtbl_contents
  &(vtt_ee72010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72010),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3010  : virtual cc010 {
  int d;
  virtual void  foo(); // _ZN6dd30103fooEv
  ~dd3010(); // tgen
  dd3010(); // tgen
};
//SIG(-1 dd3010) C1{ VBC2{ BC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd3010 ::foo(){vfunc_called(this, "_ZN6dd30103fooEv");}
dd3010 ::~dd3010(){ note_dtor("dd3010", this);} // tgen
dd3010 ::dd3010(){ note_ctor("dd3010", this);} // tgen

static void Test_dd3010()
{
  extern Class_Descriptor cd_dd3010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3010, buf);
    dd3010 *dp, &lv = *(dp=new (buf) dd3010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,20), "dd3010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,8), "dd3010");
    check_base_class_offset(lv, (cc010*), ABISELECT(16,8), "dd3010");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3010.d");
    test_class_info(&lv, &cd_dd3010);
    dp->~dd3010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3010(Test_dd3010, "dd3010", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3010C1Ev();
extern void _ZN6dd3010D1Ev();
Name_Map name_map_dd3010[] = {
  NSPAIR(_ZN6dd3010C1Ev),
  NSPAIR(_ZN6dd3010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd3010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY vtc_dd3010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
extern VTBL_ENTRY _ZTV6dd3010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd3010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd3010[] = {
  {&(_ZTV6dd3010[4]),  4,8},
  {&(_ZTV6dd3010[8]),  8,8},
  {&(_tg__ZTV5cc010__6dd3010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd3010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
Class_Descriptor cd_dd3010 = {  "dd3010", // class name
  bases_dd3010, 3,
  &(vtc_dd3010[0]), // expected_vtbl_contents
  &(vtt_dd3010[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3010),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03010  : dd3010 {
  int e;
  ~ee03010(); // tgen
  ee03010(); // tgen
};
//SIG(1 ee03010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee03010 ::~ee03010(){ note_dtor("ee03010", this);} // tgen
ee03010 ::ee03010(){ note_ctor("ee03010", this);} // tgen

static void Test_ee03010()
{
  extern Class_Descriptor cd_ee03010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03010, buf);
    ee03010 *dp, &lv = *(dp=new (buf) ee03010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee03010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee03010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(16,12), "ee03010");
    check_base_class_offset(lv, (dd3010*), 0, "ee03010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03010.e");
    test_class_info(&lv, &cd_ee03010);
    dp->~ee03010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03010(Test_ee03010, "ee03010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03010C1Ev();
extern void _ZN7ee03010D1Ev();
Name_Map name_map_ee03010[] = {
  NSPAIR(_ZN7ee03010C1Ev),
  NSPAIR(_ZN7ee03010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee03010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY vtc_ee03010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03010[0]),
};
extern VTBL_ENTRY _ZTV7ee03010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee03010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee03010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee03010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee03010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee03010[] = {
  {&(_ZTV7ee03010[4]),  4,8},
  {&(_tg__ZTV6dd3010__7ee03010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee03010[3]),  3,3},
  {&(_ZTV7ee03010[8]),  8,8},
  {&(_tg__ZTV5cc010__7ee03010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee03010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee03010[];
extern  VTBL_ENTRY _ZTV7ee03010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03010[];
Class_Descriptor cd_ee03010 = {  "ee03010", // class name
  bases_ee03010, 4,
  &(vtc_ee03010[0]), // expected_vtbl_contents
  &(vtt_ee03010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13010  : virtual dd3010 {
  int e;
  ~ee13010(); // tgen
  ee13010(); // tgen
};
//SIG(1 ee13010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee13010 ::~ee13010(){ note_dtor("ee13010", this);} // tgen
ee13010 ::ee13010(){ note_ctor("ee13010", this);} // tgen

static void Test_ee13010()
{
  extern Class_Descriptor cd_ee13010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13010, buf);
    ee13010 *dp, &lv = *(dp=new (buf) ee13010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee13010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee13010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(32,16), "ee13010");
    check_base_class_offset(lv, (dd3010*), ABISELECT(16,8), "ee13010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13010.e");
    test_class_info(&lv, &cd_ee13010);
    dp->~ee13010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13010(Test_ee13010, "ee13010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13010C1Ev();
extern void _ZN7ee13010D1Ev();
Name_Map name_map_ee13010[] = {
  NSPAIR(_ZN7ee13010C1Ev),
  NSPAIR(_ZN7ee13010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee13010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY vtc_ee13010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13010[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13010[0]),
};
extern VTBL_ENTRY _ZTV7ee13010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee13010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee13010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee13010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee13010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee13010[] = {
  {&(_ZTV7ee13010[5]),  5,14},
  {&(_ZTV7ee13010[10]),  10,14},
  {&(_ZTV7ee13010[14]),  14,14},
  {&(_tg__ZTV6dd3010__7ee13010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee13010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee13010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee13010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee13010[];
extern  VTBL_ENTRY _ZTV7ee13010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13010[];
Class_Descriptor cd_ee13010 = {  "ee13010", // class name
  bases_ee13010, 4,
  &(vtc_ee13010[0]), // expected_vtbl_contents
  &(vtt_ee13010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13010),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23010  : dd3010 {
  int e;
  virtual void  foo(); // _ZN7ee230103fooEv
  ~ee23010(); // tgen
  ee23010(); // tgen
};
//SIG(1 ee23010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee23010 ::foo(){vfunc_called(this, "_ZN7ee230103fooEv");}
ee23010 ::~ee23010(){ note_dtor("ee23010", this);} // tgen
ee23010 ::ee23010(){ note_ctor("ee23010", this);} // tgen

static void Test_ee23010()
{
  extern Class_Descriptor cd_ee23010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23010, buf);
    ee23010 *dp, &lv = *(dp=new (buf) ee23010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee23010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee23010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(16,12), "ee23010");
    check_base_class_offset(lv, (dd3010*), 0, "ee23010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23010.e");
    test_class_info(&lv, &cd_ee23010);
    dp->~ee23010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23010(Test_ee23010, "ee23010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23010C1Ev();
extern void _ZN7ee23010D1Ev();
Name_Map name_map_ee23010[] = {
  NSPAIR(_ZN7ee23010C1Ev),
  NSPAIR(_ZN7ee23010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee23010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23010[];
extern void _ZN7ee230103fooEv();
static  VTBL_ENTRY vtc_ee23010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23010[0]),
  (VTBL_ENTRY)&_ZN7ee230103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23010[0]),
};
extern VTBL_ENTRY _ZTV7ee23010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee23010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee23010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee23010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee23010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee23010[] = {
  {&(_ZTV7ee23010[4]),  4,8},
  {&(_tg__ZTV6dd3010__7ee23010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee23010[3]),  3,3},
  {&(_ZTV7ee23010[8]),  8,8},
  {&(_tg__ZTV5cc010__7ee23010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee23010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee23010[];
extern  VTBL_ENTRY _ZTV7ee23010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23010[];
Class_Descriptor cd_ee23010 = {  "ee23010", // class name
  bases_ee23010, 4,
  &(vtc_ee23010[0]), // expected_vtbl_contents
  &(vtt_ee23010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33010  : virtual dd3010 {
  int e;
  virtual void  foo(); // _ZN7ee330103fooEv
  ~ee33010(); // tgen
  ee33010(); // tgen
};
//SIG(1 ee33010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee33010 ::foo(){vfunc_called(this, "_ZN7ee330103fooEv");}
ee33010 ::~ee33010(){ note_dtor("ee33010", this);} // tgen
ee33010 ::ee33010(){ note_ctor("ee33010", this);} // tgen

static void Test_ee33010()
{
  extern Class_Descriptor cd_ee33010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33010, buf);
    ee33010 *dp, &lv = *(dp=new (buf) ee33010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee33010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee33010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(32,16), "ee33010");
    check_base_class_offset(lv, (dd3010*), ABISELECT(16,8), "ee33010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33010.e");
    test_class_info(&lv, &cd_ee33010);
    dp->~ee33010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33010(Test_ee33010, "ee33010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33010C1Ev();
extern void _ZN7ee33010D1Ev();
Name_Map name_map_ee33010[] = {
  NSPAIR(_ZN7ee33010C1Ev),
  NSPAIR(_ZN7ee33010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee33010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33010[];
extern void _ZN7ee330103fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee330103fooEv,_ZTv0_n20_N7ee330103fooEv)();
extern void ABISELECT(_ZThn16_N7ee330103fooEv,_ZThn8_N7ee330103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33010[0]),
  (VTBL_ENTRY)&_ZN7ee330103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee330103fooEv,_ZTv0_n20_N7ee330103fooEv),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33010[0]),
};
extern VTBL_ENTRY _ZTV7ee33010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee33010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee33010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee33010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee33010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee33010[] = {
  {&(_ZTV7ee33010[5]),  5,15},
  {&(_ZTV7ee33010[11]),  11,15},
  {&(_ZTV7ee33010[15]),  15,15},
  {&(_tg__ZTV6dd3010__7ee33010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee33010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee33010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee33010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee33010[];
extern  VTBL_ENTRY _ZTV7ee33010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33010[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee330103fooEv,_ZTv0_n20_N7ee330103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330103fooEv,_ZThn8_N7ee330103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33010 = {  "ee33010", // class name
  bases_ee33010, 4,
  &(vtc_ee33010[0]), // expected_vtbl_contents
  &(vtt_ee33010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33010),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43010  : dd3010 {
  int e;
  virtual void  bar(); // _ZN7ee430103barEv
  ~ee43010(); // tgen
  ee43010(); // tgen
};
//SIG(1 ee43010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee43010 ::bar(){vfunc_called(this, "_ZN7ee430103barEv");}
ee43010 ::~ee43010(){ note_dtor("ee43010", this);} // tgen
ee43010 ::ee43010(){ note_ctor("ee43010", this);} // tgen

static void Test_ee43010()
{
  extern Class_Descriptor cd_ee43010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43010, buf);
    ee43010 *dp, &lv = *(dp=new (buf) ee43010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee43010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee43010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(16,12), "ee43010");
    check_base_class_offset(lv, (dd3010*), 0, "ee43010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43010.e");
    test_class_info(&lv, &cd_ee43010);
    dp->~ee43010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43010(Test_ee43010, "ee43010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43010C1Ev();
extern void _ZN7ee43010D1Ev();
Name_Map name_map_ee43010[] = {
  NSPAIR(_ZN7ee43010C1Ev),
  NSPAIR(_ZN7ee43010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee43010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43010[];
extern void _ZN6dd30103fooEv();
extern void _ZN7ee430103barEv();
static  VTBL_ENTRY vtc_ee43010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
  (VTBL_ENTRY)&_ZN7ee430103barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43010[0]),
};
extern VTBL_ENTRY _ZTV7ee43010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee43010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee43010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee43010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee43010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee43010[] = {
  {&(_ZTV7ee43010[4]),  4,9},
  {&(_tg__ZTV6dd3010__7ee43010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee43010[3]),  3,3},
  {&(_ZTV7ee43010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee43010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee43010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee43010[];
extern  VTBL_ENTRY _ZTV7ee43010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43010[];
Class_Descriptor cd_ee43010 = {  "ee43010", // class name
  bases_ee43010, 4,
  &(vtc_ee43010[0]), // expected_vtbl_contents
  &(vtt_ee43010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53010  : virtual dd3010 {
  int e;
  virtual void  bar(); // _ZN7ee530103barEv
  ~ee53010(); // tgen
  ee53010(); // tgen
};
//SIG(1 ee53010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee53010 ::bar(){vfunc_called(this, "_ZN7ee530103barEv");}
ee53010 ::~ee53010(){ note_dtor("ee53010", this);} // tgen
ee53010 ::ee53010(){ note_ctor("ee53010", this);} // tgen

static void Test_ee53010()
{
  extern Class_Descriptor cd_ee53010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53010, buf);
    ee53010 *dp, &lv = *(dp=new (buf) ee53010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee53010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee53010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(32,16), "ee53010");
    check_base_class_offset(lv, (dd3010*), ABISELECT(16,8), "ee53010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53010.e");
    test_class_info(&lv, &cd_ee53010);
    dp->~ee53010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53010(Test_ee53010, "ee53010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53010C1Ev();
extern void _ZN7ee53010D1Ev();
Name_Map name_map_ee53010[] = {
  NSPAIR(_ZN7ee53010C1Ev),
  NSPAIR(_ZN7ee53010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee53010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53010[];
extern void _ZN7ee530103barEv();
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY vtc_ee53010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53010[0]),
  (VTBL_ENTRY)&_ZN7ee530103barEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53010[0]),
};
extern VTBL_ENTRY _ZTV7ee53010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee53010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee53010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee53010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee53010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee53010[] = {
  {&(_ZTV7ee53010[5]),  5,15},
  {&(_ZTV7ee53010[11]),  11,15},
  {&(_ZTV7ee53010[15]),  15,15},
  {&(_tg__ZTV6dd3010__7ee53010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee53010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee53010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee53010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee53010[];
extern  VTBL_ENTRY _ZTV7ee53010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53010[];
Class_Descriptor cd_ee53010 = {  "ee53010", // class name
  bases_ee53010, 4,
  &(vtc_ee53010[0]), // expected_vtbl_contents
  &(vtt_ee53010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53010),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63010  : dd3010 {
  int e;
  virtual void  foo(); // _ZN7ee630103fooEv
  virtual void  bar(); // _ZN7ee630103barEv
  ~ee63010(); // tgen
  ee63010(); // tgen
};
//SIG(1 ee63010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63010 ::foo(){vfunc_called(this, "_ZN7ee630103fooEv");}
void  ee63010 ::bar(){vfunc_called(this, "_ZN7ee630103barEv");}
ee63010 ::~ee63010(){ note_dtor("ee63010", this);} // tgen
ee63010 ::ee63010(){ note_ctor("ee63010", this);} // tgen

static void Test_ee63010()
{
  extern Class_Descriptor cd_ee63010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63010, buf);
    ee63010 *dp, &lv = *(dp=new (buf) ee63010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee63010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee63010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(16,12), "ee63010");
    check_base_class_offset(lv, (dd3010*), 0, "ee63010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63010.e");
    test_class_info(&lv, &cd_ee63010);
    dp->~ee63010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63010(Test_ee63010, "ee63010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63010C1Ev();
extern void _ZN7ee63010D1Ev();
Name_Map name_map_ee63010[] = {
  NSPAIR(_ZN7ee63010C1Ev),
  NSPAIR(_ZN7ee63010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee63010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63010[];
extern void _ZN7ee630103fooEv();
extern void _ZN7ee630103barEv();
static  VTBL_ENTRY vtc_ee63010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63010[0]),
  (VTBL_ENTRY)&_ZN7ee630103fooEv,
  (VTBL_ENTRY)&_ZN7ee630103barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63010[0]),
};
extern VTBL_ENTRY _ZTV7ee63010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee63010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee63010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee63010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee63010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee63010[] = {
  {&(_ZTV7ee63010[4]),  4,9},
  {&(_tg__ZTV6dd3010__7ee63010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee63010[3]),  3,3},
  {&(_ZTV7ee63010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee63010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee63010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee63010[];
extern  VTBL_ENTRY _ZTV7ee63010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63010[];
Class_Descriptor cd_ee63010 = {  "ee63010", // class name
  bases_ee63010, 4,
  &(vtc_ee63010[0]), // expected_vtbl_contents
  &(vtt_ee63010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73010  : virtual dd3010 {
  int e;
  virtual void  foo(); // _ZN7ee730103fooEv
  virtual void  bar(); // _ZN7ee730103barEv
  ~ee73010(); // tgen
  ee73010(); // tgen
};
//SIG(1 ee73010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73010 ::foo(){vfunc_called(this, "_ZN7ee730103fooEv");}
void  ee73010 ::bar(){vfunc_called(this, "_ZN7ee730103barEv");}
ee73010 ::~ee73010(){ note_dtor("ee73010", this);} // tgen
ee73010 ::ee73010(){ note_ctor("ee73010", this);} // tgen

static void Test_ee73010()
{
  extern Class_Descriptor cd_ee73010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73010, buf);
    ee73010 *dp, &lv = *(dp=new (buf) ee73010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee73010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee73010");
    check_base_class_offset(lv, (cc010*)(dd3010*), ABISELECT(32,16), "ee73010");
    check_base_class_offset(lv, (dd3010*), ABISELECT(16,8), "ee73010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73010.e");
    test_class_info(&lv, &cd_ee73010);
    dp->~ee73010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73010(Test_ee73010, "ee73010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73010C1Ev();
extern void _ZN7ee73010D1Ev();
Name_Map name_map_ee73010[] = {
  NSPAIR(_ZN7ee73010C1Ev),
  NSPAIR(_ZN7ee73010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd3010;
extern VTBL_ENTRY _ZTI6dd3010[];
extern  VTBL_ENTRY _ZTV6dd3010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3010[];
static Base_Class bases_ee73010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3010,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73010[];
extern void _ZN7ee730103fooEv();
extern void _ZN7ee730103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee730103fooEv,_ZTv0_n20_N7ee730103fooEv)();
extern void ABISELECT(_ZThn16_N7ee730103fooEv,_ZThn8_N7ee730103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73010[0]),
  (VTBL_ENTRY)&_ZN7ee730103fooEv,
  (VTBL_ENTRY)&_ZN7ee730103barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee730103fooEv,_ZTv0_n20_N7ee730103fooEv),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73010[0]),
};
extern VTBL_ENTRY _ZTV7ee73010[];
extern void _ZN6dd30103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3010__7ee73010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
  (VTBL_ENTRY)&_ZN6dd30103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd3010__7ee73010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee73010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee73010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee73010[] = {
  {&(_ZTV7ee73010[5]),  5,16},
  {&(_ZTV7ee73010[12]),  12,16},
  {&(_ZTV7ee73010[16]),  16,16},
  {&(_tg__ZTV6dd3010__7ee73010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd3010__7ee73010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee73010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee73010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee73010[];
extern  VTBL_ENTRY _ZTV7ee73010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73010[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee730103fooEv,_ZTv0_n20_N7ee730103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730103fooEv,_ZThn8_N7ee730103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73010 = {  "ee73010", // class name
  bases_ee73010, 4,
  &(vtc_ee73010[0]), // expected_vtbl_contents
  &(vtt_ee73010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73010),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4010  : cc010 {
  int d;
  virtual void  bar(); // _ZN6dd40103barEv
  ~dd4010(); // tgen
  dd4010(); // tgen
};
//SIG(-1 dd4010) C1{ BC2{ BC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd4010 ::bar(){vfunc_called(this, "_ZN6dd40103barEv");}
dd4010 ::~dd4010(){ note_dtor("dd4010", this);} // tgen
dd4010 ::dd4010(){ note_ctor("dd4010", this);} // tgen

static void Test_dd4010()
{
  extern Class_Descriptor cd_dd4010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4010, buf);
    dd4010 *dp, &lv = *(dp=new (buf) dd4010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(20,16), "dd4010");
    check_base_class_offset(lv, (bb10*)(cc010*), 0, "dd4010");
    check_base_class_offset(lv, (cc010*), 0, "dd4010");
    check_field_offset(lv, d, ABISELECT(16,12), "dd4010.d");
    test_class_info(&lv, &cd_dd4010);
    dp->~dd4010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4010(Test_dd4010, "dd4010", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4010C1Ev();
extern void _ZN6dd4010D1Ev();
Name_Map name_map_dd4010[] = {
  NSPAIR(_ZN6dd4010C1Ev),
  NSPAIR(_ZN6dd4010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd4010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY vtc_dd4010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
extern VTBL_ENTRY _ZTV6dd4010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd4010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd4010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd4010[] = {
  {&(_ZTV6dd4010[3]),  3,4},
  {&(_tg__ZTV5cc010__6dd4010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd4010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
Class_Descriptor cd_dd4010 = {  "dd4010", // class name
  bases_dd4010, 3,
  &(vtc_dd4010[0]), // expected_vtbl_contents
  &(vtt_dd4010[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4010),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04010  : dd4010 {
  int e;
  ~ee04010(); // tgen
  ee04010(); // tgen
};
//SIG(1 ee04010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee04010 ::~ee04010(){ note_dtor("ee04010", this);} // tgen
ee04010 ::ee04010(){ note_ctor("ee04010", this);} // tgen

static void Test_ee04010()
{
  extern Class_Descriptor cd_ee04010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04010, buf);
    ee04010 *dp, &lv = *(dp=new (buf) ee04010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(24,20), "ee04010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), 0, "ee04010");
    check_base_class_offset(lv, (cc010*)(dd4010*), 0, "ee04010");
    check_base_class_offset(lv, (dd4010*), 0, "ee04010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee04010.e");
    test_class_info(&lv, &cd_ee04010);
    dp->~ee04010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04010(Test_ee04010, "ee04010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04010C1Ev();
extern void _ZN7ee04010D1Ev();
Name_Map name_map_ee04010[] = {
  NSPAIR(_ZN7ee04010C1Ev),
  NSPAIR(_ZN7ee04010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee04010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY vtc_ee04010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
extern VTBL_ENTRY _ZTV7ee04010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee04010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee04010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee04010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee04010[] = {
  {&(_ZTV7ee04010[3]),  3,4},
  {&(_tg__ZTV6dd4010__7ee04010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee04010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee04010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee04010[];
extern  VTBL_ENTRY _ZTV7ee04010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04010[];
Class_Descriptor cd_ee04010 = {  "ee04010", // class name
  bases_ee04010, 4,
  &(vtc_ee04010[0]), // expected_vtbl_contents
  &(vtt_ee04010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14010  : virtual dd4010 {
  int e;
  ~ee14010(); // tgen
  ee14010(); // tgen
};
//SIG(1 ee14010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee14010 ::~ee14010(){ note_dtor("ee14010", this);} // tgen
ee14010 ::ee14010(){ note_ctor("ee14010", this);} // tgen

static void Test_ee14010()
{
  extern Class_Descriptor cd_ee14010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14010, buf);
    ee14010 *dp, &lv = *(dp=new (buf) ee14010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(36,24), "ee14010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), ABISELECT(16,8), "ee14010");
    check_base_class_offset(lv, (cc010*)(dd4010*), ABISELECT(16,8), "ee14010");
    check_base_class_offset(lv, (dd4010*), ABISELECT(16,8), "ee14010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14010.e");
    test_class_info(&lv, &cd_ee14010);
    dp->~ee14010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14010(Test_ee14010, "ee14010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14010C1Ev();
extern void _ZN7ee14010D1Ev();
Name_Map name_map_ee14010[] = {
  NSPAIR(_ZN7ee14010C1Ev),
  NSPAIR(_ZN7ee14010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee14010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY vtc_ee14010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14010[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
extern VTBL_ENTRY _ZTV7ee14010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee14010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee14010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee14010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee14010[] = {
  {&(_ZTV7ee14010[4]),  4,9},
  {&(_ZTV7ee14010[8]),  8,9},
  {&(_tg__ZTV6dd4010__7ee14010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee14010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee14010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee14010[];
extern  VTBL_ENTRY _ZTV7ee14010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14010[];
Class_Descriptor cd_ee14010 = {  "ee14010", // class name
  bases_ee14010, 4,
  &(vtc_ee14010[0]), // expected_vtbl_contents
  &(vtt_ee14010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24010  : dd4010 {
  int e;
  virtual void  foo(); // _ZN7ee240103fooEv
  ~ee24010(); // tgen
  ee24010(); // tgen
};
//SIG(1 ee24010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee24010 ::foo(){vfunc_called(this, "_ZN7ee240103fooEv");}
ee24010 ::~ee24010(){ note_dtor("ee24010", this);} // tgen
ee24010 ::ee24010(){ note_ctor("ee24010", this);} // tgen

static void Test_ee24010()
{
  extern Class_Descriptor cd_ee24010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24010, buf);
    ee24010 *dp, &lv = *(dp=new (buf) ee24010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(24,20), "ee24010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), 0, "ee24010");
    check_base_class_offset(lv, (cc010*)(dd4010*), 0, "ee24010");
    check_base_class_offset(lv, (dd4010*), 0, "ee24010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee24010.e");
    test_class_info(&lv, &cd_ee24010);
    dp->~ee24010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24010(Test_ee24010, "ee24010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24010C1Ev();
extern void _ZN7ee24010D1Ev();
Name_Map name_map_ee24010[] = {
  NSPAIR(_ZN7ee24010C1Ev),
  NSPAIR(_ZN7ee24010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee24010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24010[];
extern void _ZN6dd40103barEv();
extern void _ZN7ee240103fooEv();
static  VTBL_ENTRY vtc_ee24010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
  (VTBL_ENTRY)&_ZN7ee240103fooEv,
};
extern VTBL_ENTRY _ZTV7ee24010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee24010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee24010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee24010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee24010[] = {
  {&(_ZTV7ee24010[3]),  3,5},
  {&(_tg__ZTV6dd4010__7ee24010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee24010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee24010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee24010[];
extern  VTBL_ENTRY _ZTV7ee24010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24010[];
Class_Descriptor cd_ee24010 = {  "ee24010", // class name
  bases_ee24010, 4,
  &(vtc_ee24010[0]), // expected_vtbl_contents
  &(vtt_ee24010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34010  : virtual dd4010 {
  int e;
  virtual void  foo(); // _ZN7ee340103fooEv
  ~ee34010(); // tgen
  ee34010(); // tgen
};
//SIG(1 ee34010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee34010 ::foo(){vfunc_called(this, "_ZN7ee340103fooEv");}
ee34010 ::~ee34010(){ note_dtor("ee34010", this);} // tgen
ee34010 ::ee34010(){ note_ctor("ee34010", this);} // tgen

static void Test_ee34010()
{
  extern Class_Descriptor cd_ee34010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34010, buf);
    ee34010 *dp, &lv = *(dp=new (buf) ee34010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(36,24), "ee34010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), ABISELECT(16,8), "ee34010");
    check_base_class_offset(lv, (cc010*)(dd4010*), ABISELECT(16,8), "ee34010");
    check_base_class_offset(lv, (dd4010*), ABISELECT(16,8), "ee34010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34010.e");
    test_class_info(&lv, &cd_ee34010);
    dp->~ee34010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34010(Test_ee34010, "ee34010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34010C1Ev();
extern void _ZN7ee34010D1Ev();
Name_Map name_map_ee34010[] = {
  NSPAIR(_ZN7ee34010C1Ev),
  NSPAIR(_ZN7ee34010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee34010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34010[];
extern void _ZN7ee340103fooEv();
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY vtc_ee34010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34010[0]),
  (VTBL_ENTRY)&_ZN7ee340103fooEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
extern VTBL_ENTRY _ZTV7ee34010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee34010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee34010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee34010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee34010[] = {
  {&(_ZTV7ee34010[4]),  4,10},
  {&(_ZTV7ee34010[9]),  9,10},
  {&(_tg__ZTV6dd4010__7ee34010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee34010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee34010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee34010[];
extern  VTBL_ENTRY _ZTV7ee34010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34010[];
Class_Descriptor cd_ee34010 = {  "ee34010", // class name
  bases_ee34010, 4,
  &(vtc_ee34010[0]), // expected_vtbl_contents
  &(vtt_ee34010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34010),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44010  : dd4010 {
  int e;
  virtual void  bar(); // _ZN7ee440103barEv
  ~ee44010(); // tgen
  ee44010(); // tgen
};
//SIG(1 ee44010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee44010 ::bar(){vfunc_called(this, "_ZN7ee440103barEv");}
ee44010 ::~ee44010(){ note_dtor("ee44010", this);} // tgen
ee44010 ::ee44010(){ note_ctor("ee44010", this);} // tgen

static void Test_ee44010()
{
  extern Class_Descriptor cd_ee44010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44010, buf);
    ee44010 *dp, &lv = *(dp=new (buf) ee44010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(24,20), "ee44010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), 0, "ee44010");
    check_base_class_offset(lv, (cc010*)(dd4010*), 0, "ee44010");
    check_base_class_offset(lv, (dd4010*), 0, "ee44010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee44010.e");
    test_class_info(&lv, &cd_ee44010);
    dp->~ee44010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44010(Test_ee44010, "ee44010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44010C1Ev();
extern void _ZN7ee44010D1Ev();
Name_Map name_map_ee44010[] = {
  NSPAIR(_ZN7ee44010C1Ev),
  NSPAIR(_ZN7ee44010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee44010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44010[];
extern void _ZN7ee440103barEv();
static  VTBL_ENTRY vtc_ee44010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44010[0]),
  (VTBL_ENTRY)&_ZN7ee440103barEv,
};
extern VTBL_ENTRY _ZTV7ee44010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee44010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee44010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee44010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee44010[] = {
  {&(_ZTV7ee44010[3]),  3,4},
  {&(_tg__ZTV6dd4010__7ee44010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee44010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee44010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee44010[];
extern  VTBL_ENTRY _ZTV7ee44010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44010[];
Class_Descriptor cd_ee44010 = {  "ee44010", // class name
  bases_ee44010, 4,
  &(vtc_ee44010[0]), // expected_vtbl_contents
  &(vtt_ee44010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44010),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54010  : virtual dd4010 {
  int e;
  virtual void  bar(); // _ZN7ee540103barEv
  ~ee54010(); // tgen
  ee54010(); // tgen
};
//SIG(1 ee54010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee54010 ::bar(){vfunc_called(this, "_ZN7ee540103barEv");}
ee54010 ::~ee54010(){ note_dtor("ee54010", this);} // tgen
ee54010 ::ee54010(){ note_ctor("ee54010", this);} // tgen

static void Test_ee54010()
{
  extern Class_Descriptor cd_ee54010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54010, buf);
    ee54010 *dp, &lv = *(dp=new (buf) ee54010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(36,24), "ee54010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), ABISELECT(16,8), "ee54010");
    check_base_class_offset(lv, (cc010*)(dd4010*), ABISELECT(16,8), "ee54010");
    check_base_class_offset(lv, (dd4010*), ABISELECT(16,8), "ee54010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54010.e");
    test_class_info(&lv, &cd_ee54010);
    dp->~ee54010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54010(Test_ee54010, "ee54010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54010C1Ev();
extern void _ZN7ee54010D1Ev();
Name_Map name_map_ee54010[] = {
  NSPAIR(_ZN7ee54010C1Ev),
  NSPAIR(_ZN7ee54010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee54010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54010[];
extern void _ZN7ee540103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee540103barEv,_ZTv0_n16_N7ee540103barEv)();
extern void ABISELECT(_ZThn16_N7ee540103barEv,_ZThn8_N7ee540103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54010[0]),
  (VTBL_ENTRY)&_ZN7ee540103barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee540103barEv,_ZTv0_n16_N7ee540103barEv),
};
extern VTBL_ENTRY _ZTV7ee54010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee54010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee54010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee54010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee54010[] = {
  {&(_ZTV7ee54010[4]),  4,10},
  {&(_ZTV7ee54010[9]),  9,10},
  {&(_tg__ZTV6dd4010__7ee54010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee54010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee54010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee54010[];
extern  VTBL_ENTRY _ZTV7ee54010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54010[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee540103barEv,_ZTv0_n16_N7ee540103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540103barEv,_ZThn8_N7ee540103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54010 = {  "ee54010", // class name
  bases_ee54010, 4,
  &(vtc_ee54010[0]), // expected_vtbl_contents
  &(vtt_ee54010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54010),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64010  : dd4010 {
  int e;
  virtual void  foo(); // _ZN7ee640103fooEv
  virtual void  bar(); // _ZN7ee640103barEv
  ~ee64010(); // tgen
  ee64010(); // tgen
};
//SIG(1 ee64010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64010 ::foo(){vfunc_called(this, "_ZN7ee640103fooEv");}
void  ee64010 ::bar(){vfunc_called(this, "_ZN7ee640103barEv");}
ee64010 ::~ee64010(){ note_dtor("ee64010", this);} // tgen
ee64010 ::ee64010(){ note_ctor("ee64010", this);} // tgen

static void Test_ee64010()
{
  extern Class_Descriptor cd_ee64010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64010, buf);
    ee64010 *dp, &lv = *(dp=new (buf) ee64010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(24,20), "ee64010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), 0, "ee64010");
    check_base_class_offset(lv, (cc010*)(dd4010*), 0, "ee64010");
    check_base_class_offset(lv, (dd4010*), 0, "ee64010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee64010.e");
    test_class_info(&lv, &cd_ee64010);
    dp->~ee64010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64010(Test_ee64010, "ee64010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64010C1Ev();
extern void _ZN7ee64010D1Ev();
Name_Map name_map_ee64010[] = {
  NSPAIR(_ZN7ee64010C1Ev),
  NSPAIR(_ZN7ee64010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee64010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64010[];
extern void _ZN7ee640103barEv();
extern void _ZN7ee640103fooEv();
static  VTBL_ENTRY vtc_ee64010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64010[0]),
  (VTBL_ENTRY)&_ZN7ee640103barEv,
  (VTBL_ENTRY)&_ZN7ee640103fooEv,
};
extern VTBL_ENTRY _ZTV7ee64010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee64010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee64010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee64010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee64010[] = {
  {&(_ZTV7ee64010[3]),  3,5},
  {&(_tg__ZTV6dd4010__7ee64010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee64010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee64010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee64010[];
extern  VTBL_ENTRY _ZTV7ee64010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64010[];
Class_Descriptor cd_ee64010 = {  "ee64010", // class name
  bases_ee64010, 4,
  &(vtc_ee64010[0]), // expected_vtbl_contents
  &(vtt_ee64010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74010  : virtual dd4010 {
  int e;
  virtual void  foo(); // _ZN7ee740103fooEv
  virtual void  bar(); // _ZN7ee740103barEv
  ~ee74010(); // tgen
  ee74010(); // tgen
};
//SIG(1 ee74010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74010 ::foo(){vfunc_called(this, "_ZN7ee740103fooEv");}
void  ee74010 ::bar(){vfunc_called(this, "_ZN7ee740103barEv");}
ee74010 ::~ee74010(){ note_dtor("ee74010", this);} // tgen
ee74010 ::ee74010(){ note_ctor("ee74010", this);} // tgen

static void Test_ee74010()
{
  extern Class_Descriptor cd_ee74010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74010, buf);
    ee74010 *dp, &lv = *(dp=new (buf) ee74010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd4010*), ABISELECT(36,24), "ee74010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd4010*), ABISELECT(16,8), "ee74010");
    check_base_class_offset(lv, (cc010*)(dd4010*), ABISELECT(16,8), "ee74010");
    check_base_class_offset(lv, (dd4010*), ABISELECT(16,8), "ee74010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74010.e");
    test_class_info(&lv, &cd_ee74010);
    dp->~ee74010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74010(Test_ee74010, "ee74010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74010C1Ev();
extern void _ZN7ee74010D1Ev();
Name_Map name_map_ee74010[] = {
  NSPAIR(_ZN7ee74010C1Ev),
  NSPAIR(_ZN7ee74010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd4010;
extern VTBL_ENTRY _ZTI6dd4010[];
extern  VTBL_ENTRY _ZTV6dd4010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4010[];
static Base_Class bases_ee74010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74010[];
extern void _ZN7ee740103fooEv();
extern void _ZN7ee740103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee740103barEv,_ZTv0_n16_N7ee740103barEv)();
extern void ABISELECT(_ZThn16_N7ee740103barEv,_ZThn8_N7ee740103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74010[0]),
  (VTBL_ENTRY)&_ZN7ee740103fooEv,
  (VTBL_ENTRY)&_ZN7ee740103barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee740103barEv,_ZTv0_n16_N7ee740103barEv),
};
extern VTBL_ENTRY _ZTV7ee74010[];
extern void _ZN6dd40103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4010__7ee74010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4010[0]),
  (VTBL_ENTRY)&_ZN6dd40103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd4010__7ee74010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd4010__7ee74010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee74010[] = {
  {&(_ZTV7ee74010[4]),  4,11},
  {&(_ZTV7ee74010[10]),  10,11},
  {&(_tg__ZTV6dd4010__7ee74010[3]),  3,4},
  {&(_tg__ZTV5cc0106dd4010__7ee74010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd4010__7ee74010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee74010[];
extern  VTBL_ENTRY _ZTV7ee74010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74010[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee740103barEv,_ZTv0_n16_N7ee740103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740103barEv,_ZThn8_N7ee740103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74010 = {  "ee74010", // class name
  bases_ee74010, 4,
  &(vtc_ee74010[0]), // expected_vtbl_contents
  &(vtt_ee74010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74010),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5010  : virtual cc010 {
  int d;
  virtual void  bar(); // _ZN6dd50103barEv
  ~dd5010(); // tgen
  dd5010(); // tgen
};
//SIG(-1 dd5010) C1{ VBC2{ BC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd5010 ::bar(){vfunc_called(this, "_ZN6dd50103barEv");}
dd5010 ::~dd5010(){ note_dtor("dd5010", this);} // tgen
dd5010 ::dd5010(){ note_ctor("dd5010", this);} // tgen

static void Test_dd5010()
{
  extern Class_Descriptor cd_dd5010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5010, buf);
    dd5010 *dp, &lv = *(dp=new (buf) dd5010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,20), "dd5010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,8), "dd5010");
    check_base_class_offset(lv, (cc010*), ABISELECT(16,8), "dd5010");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5010.d");
    test_class_info(&lv, &cd_dd5010);
    dp->~dd5010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5010(Test_dd5010, "dd5010", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5010C1Ev();
extern void _ZN6dd5010D1Ev();
Name_Map name_map_dd5010[] = {
  NSPAIR(_ZN6dd5010C1Ev),
  NSPAIR(_ZN6dd5010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd5010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY vtc_dd5010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
extern VTBL_ENTRY _ZTV6dd5010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd5010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd5010[] = {
  {&(_ZTV6dd5010[4]),  4,8},
  {&(_ZTV6dd5010[8]),  8,8},
  {&(_tg__ZTV5cc010__6dd5010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd5010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
Class_Descriptor cd_dd5010 = {  "dd5010", // class name
  bases_dd5010, 3,
  &(vtc_dd5010[0]), // expected_vtbl_contents
  &(vtt_dd5010[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5010),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05010  : dd5010 {
  int e;
  ~ee05010(); // tgen
  ee05010(); // tgen
};
//SIG(1 ee05010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee05010 ::~ee05010(){ note_dtor("ee05010", this);} // tgen
ee05010 ::ee05010(){ note_ctor("ee05010", this);} // tgen

static void Test_ee05010()
{
  extern Class_Descriptor cd_ee05010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05010, buf);
    ee05010 *dp, &lv = *(dp=new (buf) ee05010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee05010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee05010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(16,12), "ee05010");
    check_base_class_offset(lv, (dd5010*), 0, "ee05010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05010.e");
    test_class_info(&lv, &cd_ee05010);
    dp->~ee05010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05010(Test_ee05010, "ee05010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05010C1Ev();
extern void _ZN7ee05010D1Ev();
Name_Map name_map_ee05010[] = {
  NSPAIR(_ZN7ee05010C1Ev),
  NSPAIR(_ZN7ee05010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee05010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY vtc_ee05010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05010[0]),
};
extern VTBL_ENTRY _ZTV7ee05010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee05010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee05010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee05010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee05010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee05010[] = {
  {&(_ZTV7ee05010[4]),  4,8},
  {&(_tg__ZTV6dd5010__7ee05010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee05010[3]),  3,3},
  {&(_ZTV7ee05010[8]),  8,8},
  {&(_tg__ZTV5cc010__7ee05010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee05010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee05010[];
extern  VTBL_ENTRY _ZTV7ee05010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05010[];
Class_Descriptor cd_ee05010 = {  "ee05010", // class name
  bases_ee05010, 4,
  &(vtc_ee05010[0]), // expected_vtbl_contents
  &(vtt_ee05010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15010  : virtual dd5010 {
  int e;
  ~ee15010(); // tgen
  ee15010(); // tgen
};
//SIG(1 ee15010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee15010 ::~ee15010(){ note_dtor("ee15010", this);} // tgen
ee15010 ::ee15010(){ note_ctor("ee15010", this);} // tgen

static void Test_ee15010()
{
  extern Class_Descriptor cd_ee15010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15010, buf);
    ee15010 *dp, &lv = *(dp=new (buf) ee15010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee15010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee15010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(32,16), "ee15010");
    check_base_class_offset(lv, (dd5010*), ABISELECT(16,8), "ee15010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15010.e");
    test_class_info(&lv, &cd_ee15010);
    dp->~ee15010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15010(Test_ee15010, "ee15010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15010C1Ev();
extern void _ZN7ee15010D1Ev();
Name_Map name_map_ee15010[] = {
  NSPAIR(_ZN7ee15010C1Ev),
  NSPAIR(_ZN7ee15010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee15010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY vtc_ee15010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15010[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15010[0]),
};
extern VTBL_ENTRY _ZTV7ee15010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee15010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee15010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee15010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee15010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee15010[] = {
  {&(_ZTV7ee15010[5]),  5,14},
  {&(_ZTV7ee15010[10]),  10,14},
  {&(_ZTV7ee15010[14]),  14,14},
  {&(_tg__ZTV6dd5010__7ee15010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee15010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee15010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee15010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee15010[];
extern  VTBL_ENTRY _ZTV7ee15010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15010[];
Class_Descriptor cd_ee15010 = {  "ee15010", // class name
  bases_ee15010, 4,
  &(vtc_ee15010[0]), // expected_vtbl_contents
  &(vtt_ee15010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15010),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25010  : dd5010 {
  int e;
  virtual void  foo(); // _ZN7ee250103fooEv
  ~ee25010(); // tgen
  ee25010(); // tgen
};
//SIG(1 ee25010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee25010 ::foo(){vfunc_called(this, "_ZN7ee250103fooEv");}
ee25010 ::~ee25010(){ note_dtor("ee25010", this);} // tgen
ee25010 ::ee25010(){ note_ctor("ee25010", this);} // tgen

static void Test_ee25010()
{
  extern Class_Descriptor cd_ee25010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25010, buf);
    ee25010 *dp, &lv = *(dp=new (buf) ee25010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee25010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee25010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(16,12), "ee25010");
    check_base_class_offset(lv, (dd5010*), 0, "ee25010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25010.e");
    test_class_info(&lv, &cd_ee25010);
    dp->~ee25010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25010(Test_ee25010, "ee25010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25010C1Ev();
extern void _ZN7ee25010D1Ev();
Name_Map name_map_ee25010[] = {
  NSPAIR(_ZN7ee25010C1Ev),
  NSPAIR(_ZN7ee25010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee25010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25010[];
extern void _ZN6dd50103barEv();
extern void _ZN7ee250103fooEv();
static  VTBL_ENTRY vtc_ee25010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
  (VTBL_ENTRY)&_ZN7ee250103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25010[0]),
};
extern VTBL_ENTRY _ZTV7ee25010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee25010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee25010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee25010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee25010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee25010[] = {
  {&(_ZTV7ee25010[4]),  4,9},
  {&(_tg__ZTV6dd5010__7ee25010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee25010[3]),  3,3},
  {&(_ZTV7ee25010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee25010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee25010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee25010[];
extern  VTBL_ENTRY _ZTV7ee25010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25010[];
Class_Descriptor cd_ee25010 = {  "ee25010", // class name
  bases_ee25010, 4,
  &(vtc_ee25010[0]), // expected_vtbl_contents
  &(vtt_ee25010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35010  : virtual dd5010 {
  int e;
  virtual void  foo(); // _ZN7ee350103fooEv
  ~ee35010(); // tgen
  ee35010(); // tgen
};
//SIG(1 ee35010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee35010 ::foo(){vfunc_called(this, "_ZN7ee350103fooEv");}
ee35010 ::~ee35010(){ note_dtor("ee35010", this);} // tgen
ee35010 ::ee35010(){ note_ctor("ee35010", this);} // tgen

static void Test_ee35010()
{
  extern Class_Descriptor cd_ee35010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35010, buf);
    ee35010 *dp, &lv = *(dp=new (buf) ee35010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee35010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee35010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(32,16), "ee35010");
    check_base_class_offset(lv, (dd5010*), ABISELECT(16,8), "ee35010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35010.e");
    test_class_info(&lv, &cd_ee35010);
    dp->~ee35010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35010(Test_ee35010, "ee35010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35010C1Ev();
extern void _ZN7ee35010D1Ev();
Name_Map name_map_ee35010[] = {
  NSPAIR(_ZN7ee35010C1Ev),
  NSPAIR(_ZN7ee35010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee35010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35010[];
extern void _ZN7ee350103fooEv();
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY vtc_ee35010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35010[0]),
  (VTBL_ENTRY)&_ZN7ee350103fooEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35010[0]),
};
extern VTBL_ENTRY _ZTV7ee35010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee35010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee35010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee35010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee35010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee35010[] = {
  {&(_ZTV7ee35010[5]),  5,15},
  {&(_ZTV7ee35010[11]),  11,15},
  {&(_ZTV7ee35010[15]),  15,15},
  {&(_tg__ZTV6dd5010__7ee35010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee35010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee35010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee35010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee35010[];
extern  VTBL_ENTRY _ZTV7ee35010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35010[];
Class_Descriptor cd_ee35010 = {  "ee35010", // class name
  bases_ee35010, 4,
  &(vtc_ee35010[0]), // expected_vtbl_contents
  &(vtt_ee35010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35010),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45010  : dd5010 {
  int e;
  virtual void  bar(); // _ZN7ee450103barEv
  ~ee45010(); // tgen
  ee45010(); // tgen
};
//SIG(1 ee45010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee45010 ::bar(){vfunc_called(this, "_ZN7ee450103barEv");}
ee45010 ::~ee45010(){ note_dtor("ee45010", this);} // tgen
ee45010 ::ee45010(){ note_ctor("ee45010", this);} // tgen

static void Test_ee45010()
{
  extern Class_Descriptor cd_ee45010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45010, buf);
    ee45010 *dp, &lv = *(dp=new (buf) ee45010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee45010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee45010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(16,12), "ee45010");
    check_base_class_offset(lv, (dd5010*), 0, "ee45010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45010.e");
    test_class_info(&lv, &cd_ee45010);
    dp->~ee45010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45010(Test_ee45010, "ee45010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45010C1Ev();
extern void _ZN7ee45010D1Ev();
Name_Map name_map_ee45010[] = {
  NSPAIR(_ZN7ee45010C1Ev),
  NSPAIR(_ZN7ee45010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee45010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45010[];
extern void _ZN7ee450103barEv();
static  VTBL_ENTRY vtc_ee45010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45010[0]),
  (VTBL_ENTRY)&_ZN7ee450103barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45010[0]),
};
extern VTBL_ENTRY _ZTV7ee45010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee45010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee45010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee45010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee45010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee45010[] = {
  {&(_ZTV7ee45010[4]),  4,8},
  {&(_tg__ZTV6dd5010__7ee45010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee45010[3]),  3,3},
  {&(_ZTV7ee45010[8]),  8,8},
  {&(_tg__ZTV5cc010__7ee45010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee45010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee45010[];
extern  VTBL_ENTRY _ZTV7ee45010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45010[];
Class_Descriptor cd_ee45010 = {  "ee45010", // class name
  bases_ee45010, 4,
  &(vtc_ee45010[0]), // expected_vtbl_contents
  &(vtt_ee45010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45010),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55010  : virtual dd5010 {
  int e;
  virtual void  bar(); // _ZN7ee550103barEv
  ~ee55010(); // tgen
  ee55010(); // tgen
};
//SIG(1 ee55010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee55010 ::bar(){vfunc_called(this, "_ZN7ee550103barEv");}
ee55010 ::~ee55010(){ note_dtor("ee55010", this);} // tgen
ee55010 ::ee55010(){ note_ctor("ee55010", this);} // tgen

static void Test_ee55010()
{
  extern Class_Descriptor cd_ee55010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55010, buf);
    ee55010 *dp, &lv = *(dp=new (buf) ee55010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee55010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee55010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(32,16), "ee55010");
    check_base_class_offset(lv, (dd5010*), ABISELECT(16,8), "ee55010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55010.e");
    test_class_info(&lv, &cd_ee55010);
    dp->~ee55010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55010(Test_ee55010, "ee55010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55010C1Ev();
extern void _ZN7ee55010D1Ev();
Name_Map name_map_ee55010[] = {
  NSPAIR(_ZN7ee55010C1Ev),
  NSPAIR(_ZN7ee55010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee55010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55010[];
extern void _ZN7ee550103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee550103barEv,_ZTv0_n20_N7ee550103barEv)();
extern void ABISELECT(_ZThn16_N7ee550103barEv,_ZThn8_N7ee550103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55010[0]),
  (VTBL_ENTRY)&_ZN7ee550103barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee550103barEv,_ZTv0_n20_N7ee550103barEv),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55010[0]),
};
extern VTBL_ENTRY _ZTV7ee55010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee55010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee55010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee55010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee55010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee55010[] = {
  {&(_ZTV7ee55010[5]),  5,15},
  {&(_ZTV7ee55010[11]),  11,15},
  {&(_ZTV7ee55010[15]),  15,15},
  {&(_tg__ZTV6dd5010__7ee55010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee55010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee55010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee55010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee55010[];
extern  VTBL_ENTRY _ZTV7ee55010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55010[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee550103barEv,_ZTv0_n20_N7ee550103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550103barEv,_ZThn8_N7ee550103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55010 = {  "ee55010", // class name
  bases_ee55010, 4,
  &(vtc_ee55010[0]), // expected_vtbl_contents
  &(vtt_ee55010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55010),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65010  : dd5010 {
  int e;
  virtual void  foo(); // _ZN7ee650103fooEv
  virtual void  bar(); // _ZN7ee650103barEv
  ~ee65010(); // tgen
  ee65010(); // tgen
};
//SIG(1 ee65010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65010 ::foo(){vfunc_called(this, "_ZN7ee650103fooEv");}
void  ee65010 ::bar(){vfunc_called(this, "_ZN7ee650103barEv");}
ee65010 ::~ee65010(){ note_dtor("ee65010", this);} // tgen
ee65010 ::ee65010(){ note_ctor("ee65010", this);} // tgen

static void Test_ee65010()
{
  extern Class_Descriptor cd_ee65010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65010, buf);
    ee65010 *dp, &lv = *(dp=new (buf) ee65010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee65010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee65010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(16,12), "ee65010");
    check_base_class_offset(lv, (dd5010*), 0, "ee65010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65010.e");
    test_class_info(&lv, &cd_ee65010);
    dp->~ee65010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65010(Test_ee65010, "ee65010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65010C1Ev();
extern void _ZN7ee65010D1Ev();
Name_Map name_map_ee65010[] = {
  NSPAIR(_ZN7ee65010C1Ev),
  NSPAIR(_ZN7ee65010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee65010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65010[];
extern void _ZN7ee650103barEv();
extern void _ZN7ee650103fooEv();
static  VTBL_ENTRY vtc_ee65010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65010[0]),
  (VTBL_ENTRY)&_ZN7ee650103barEv,
  (VTBL_ENTRY)&_ZN7ee650103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65010[0]),
};
extern VTBL_ENTRY _ZTV7ee65010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee65010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee65010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee65010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee65010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee65010[] = {
  {&(_ZTV7ee65010[4]),  4,9},
  {&(_tg__ZTV6dd5010__7ee65010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee65010[3]),  3,3},
  {&(_ZTV7ee65010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee65010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee65010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee65010[];
extern  VTBL_ENTRY _ZTV7ee65010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65010[];
Class_Descriptor cd_ee65010 = {  "ee65010", // class name
  bases_ee65010, 4,
  &(vtc_ee65010[0]), // expected_vtbl_contents
  &(vtt_ee65010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75010  : virtual dd5010 {
  int e;
  virtual void  foo(); // _ZN7ee750103fooEv
  virtual void  bar(); // _ZN7ee750103barEv
  ~ee75010(); // tgen
  ee75010(); // tgen
};
//SIG(1 ee75010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75010 ::foo(){vfunc_called(this, "_ZN7ee750103fooEv");}
void  ee75010 ::bar(){vfunc_called(this, "_ZN7ee750103barEv");}
ee75010 ::~ee75010(){ note_dtor("ee75010", this);} // tgen
ee75010 ::ee75010(){ note_ctor("ee75010", this);} // tgen

static void Test_ee75010()
{
  extern Class_Descriptor cd_ee75010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75010, buf);
    ee75010 *dp, &lv = *(dp=new (buf) ee75010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee75010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee75010");
    check_base_class_offset(lv, (cc010*)(dd5010*), ABISELECT(32,16), "ee75010");
    check_base_class_offset(lv, (dd5010*), ABISELECT(16,8), "ee75010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75010.e");
    test_class_info(&lv, &cd_ee75010);
    dp->~ee75010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75010(Test_ee75010, "ee75010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75010C1Ev();
extern void _ZN7ee75010D1Ev();
Name_Map name_map_ee75010[] = {
  NSPAIR(_ZN7ee75010C1Ev),
  NSPAIR(_ZN7ee75010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd5010;
extern VTBL_ENTRY _ZTI6dd5010[];
extern  VTBL_ENTRY _ZTV6dd5010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5010[];
static Base_Class bases_ee75010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5010,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75010[];
extern void _ZN7ee750103fooEv();
extern void _ZN7ee750103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee750103barEv,_ZTv0_n20_N7ee750103barEv)();
extern void ABISELECT(_ZThn16_N7ee750103barEv,_ZThn8_N7ee750103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75010[0]),
  (VTBL_ENTRY)&_ZN7ee750103fooEv,
  (VTBL_ENTRY)&_ZN7ee750103barEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee750103barEv,_ZTv0_n20_N7ee750103barEv),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75010[0]),
};
extern VTBL_ENTRY _ZTV7ee75010[];
extern void _ZN6dd50103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5010__7ee75010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
  (VTBL_ENTRY)&_ZN6dd50103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd5010__7ee75010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee75010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee75010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee75010[] = {
  {&(_ZTV7ee75010[5]),  5,16},
  {&(_ZTV7ee75010[12]),  12,16},
  {&(_ZTV7ee75010[16]),  16,16},
  {&(_tg__ZTV6dd5010__7ee75010[4]),  4,5},
  {&(_tg__ZTV5cc010__6dd5010__7ee75010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee75010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee75010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee75010[];
extern  VTBL_ENTRY _ZTV7ee75010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75010[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee750103barEv,_ZTv0_n20_N7ee750103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750103barEv,_ZThn8_N7ee750103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75010 = {  "ee75010", // class name
  bases_ee75010, 4,
  &(vtc_ee75010[0]), // expected_vtbl_contents
  &(vtt_ee75010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75010),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6010  : cc010 {
  int d;
  virtual void  bar(); // _ZN6dd60103barEv
  virtual void  foo(); // _ZN6dd60103fooEv
  ~dd6010(); // tgen
  dd6010(); // tgen
};
//SIG(-1 dd6010) C1{ BC2{ BC3{ VBC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd6010 ::bar(){vfunc_called(this, "_ZN6dd60103barEv");}
void  dd6010 ::foo(){vfunc_called(this, "_ZN6dd60103fooEv");}
dd6010 ::~dd6010(){ note_dtor("dd6010", this);} // tgen
dd6010 ::dd6010(){ note_ctor("dd6010", this);} // tgen

static void Test_dd6010()
{
  extern Class_Descriptor cd_dd6010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6010, buf);
    dd6010 *dp, &lv = *(dp=new (buf) dd6010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(20,16), "dd6010");
    check_base_class_offset(lv, (bb10*)(cc010*), 0, "dd6010");
    check_base_class_offset(lv, (cc010*), 0, "dd6010");
    check_field_offset(lv, d, ABISELECT(16,12), "dd6010.d");
    test_class_info(&lv, &cd_dd6010);
    dp->~dd6010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6010(Test_dd6010, "dd6010", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6010C1Ev();
extern void _ZN6dd6010D1Ev();
Name_Map name_map_dd6010[] = {
  NSPAIR(_ZN6dd6010C1Ev),
  NSPAIR(_ZN6dd6010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd6010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY vtc_dd6010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
extern VTBL_ENTRY _ZTV6dd6010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd6010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd6010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd6010[] = {
  {&(_ZTV6dd6010[3]),  3,5},
  {&(_tg__ZTV5cc010__6dd6010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd6010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
Class_Descriptor cd_dd6010 = {  "dd6010", // class name
  bases_dd6010, 3,
  &(vtc_dd6010[0]), // expected_vtbl_contents
  &(vtt_dd6010[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6010),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06010  : dd6010 {
  int e;
  ~ee06010(); // tgen
  ee06010(); // tgen
};
//SIG(1 ee06010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee06010 ::~ee06010(){ note_dtor("ee06010", this);} // tgen
ee06010 ::ee06010(){ note_ctor("ee06010", this);} // tgen

static void Test_ee06010()
{
  extern Class_Descriptor cd_ee06010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06010, buf);
    ee06010 *dp, &lv = *(dp=new (buf) ee06010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(24,20), "ee06010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), 0, "ee06010");
    check_base_class_offset(lv, (cc010*)(dd6010*), 0, "ee06010");
    check_base_class_offset(lv, (dd6010*), 0, "ee06010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee06010.e");
    test_class_info(&lv, &cd_ee06010);
    dp->~ee06010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06010(Test_ee06010, "ee06010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06010C1Ev();
extern void _ZN7ee06010D1Ev();
Name_Map name_map_ee06010[] = {
  NSPAIR(_ZN7ee06010C1Ev),
  NSPAIR(_ZN7ee06010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee06010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY vtc_ee06010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
extern VTBL_ENTRY _ZTV7ee06010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee06010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee06010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee06010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee06010[] = {
  {&(_ZTV7ee06010[3]),  3,5},
  {&(_tg__ZTV6dd6010__7ee06010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee06010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee06010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee06010[];
extern  VTBL_ENTRY _ZTV7ee06010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06010[];
Class_Descriptor cd_ee06010 = {  "ee06010", // class name
  bases_ee06010, 4,
  &(vtc_ee06010[0]), // expected_vtbl_contents
  &(vtt_ee06010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16010  : virtual dd6010 {
  int e;
  ~ee16010(); // tgen
  ee16010(); // tgen
};
//SIG(1 ee16010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee16010 ::~ee16010(){ note_dtor("ee16010", this);} // tgen
ee16010 ::ee16010(){ note_ctor("ee16010", this);} // tgen

static void Test_ee16010()
{
  extern Class_Descriptor cd_ee16010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16010, buf);
    ee16010 *dp, &lv = *(dp=new (buf) ee16010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(36,24), "ee16010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), ABISELECT(16,8), "ee16010");
    check_base_class_offset(lv, (cc010*)(dd6010*), ABISELECT(16,8), "ee16010");
    check_base_class_offset(lv, (dd6010*), ABISELECT(16,8), "ee16010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16010.e");
    test_class_info(&lv, &cd_ee16010);
    dp->~ee16010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16010(Test_ee16010, "ee16010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16010C1Ev();
extern void _ZN7ee16010D1Ev();
Name_Map name_map_ee16010[] = {
  NSPAIR(_ZN7ee16010C1Ev),
  NSPAIR(_ZN7ee16010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee16010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY vtc_ee16010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16010[0]),
  0,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
extern VTBL_ENTRY _ZTV7ee16010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee16010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee16010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee16010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee16010[] = {
  {&(_ZTV7ee16010[4]),  4,11},
  {&(_ZTV7ee16010[9]),  9,11},
  {&(_tg__ZTV6dd6010__7ee16010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee16010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee16010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee16010[];
extern  VTBL_ENTRY _ZTV7ee16010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16010[];
Class_Descriptor cd_ee16010 = {  "ee16010", // class name
  bases_ee16010, 4,
  &(vtc_ee16010[0]), // expected_vtbl_contents
  &(vtt_ee16010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16010),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26010  : dd6010 {
  int e;
  virtual void  foo(); // _ZN7ee260103fooEv
  ~ee26010(); // tgen
  ee26010(); // tgen
};
//SIG(1 ee26010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26010 ::foo(){vfunc_called(this, "_ZN7ee260103fooEv");}
ee26010 ::~ee26010(){ note_dtor("ee26010", this);} // tgen
ee26010 ::ee26010(){ note_ctor("ee26010", this);} // tgen

static void Test_ee26010()
{
  extern Class_Descriptor cd_ee26010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26010, buf);
    ee26010 *dp, &lv = *(dp=new (buf) ee26010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(24,20), "ee26010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), 0, "ee26010");
    check_base_class_offset(lv, (cc010*)(dd6010*), 0, "ee26010");
    check_base_class_offset(lv, (dd6010*), 0, "ee26010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee26010.e");
    test_class_info(&lv, &cd_ee26010);
    dp->~ee26010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26010(Test_ee26010, "ee26010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26010C1Ev();
extern void _ZN7ee26010D1Ev();
Name_Map name_map_ee26010[] = {
  NSPAIR(_ZN7ee26010C1Ev),
  NSPAIR(_ZN7ee26010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee26010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26010[];
extern void _ZN6dd60103barEv();
extern void _ZN7ee260103fooEv();
static  VTBL_ENTRY vtc_ee26010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN7ee260103fooEv,
};
extern VTBL_ENTRY _ZTV7ee26010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee26010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee26010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee26010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee26010[] = {
  {&(_ZTV7ee26010[3]),  3,5},
  {&(_tg__ZTV6dd6010__7ee26010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee26010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee26010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee26010[];
extern  VTBL_ENTRY _ZTV7ee26010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26010[];
Class_Descriptor cd_ee26010 = {  "ee26010", // class name
  bases_ee26010, 4,
  &(vtc_ee26010[0]), // expected_vtbl_contents
  &(vtt_ee26010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36010  : virtual dd6010 {
  int e;
  virtual void  foo(); // _ZN7ee360103fooEv
  ~ee36010(); // tgen
  ee36010(); // tgen
};
//SIG(1 ee36010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36010 ::foo(){vfunc_called(this, "_ZN7ee360103fooEv");}
ee36010 ::~ee36010(){ note_dtor("ee36010", this);} // tgen
ee36010 ::ee36010(){ note_ctor("ee36010", this);} // tgen

static void Test_ee36010()
{
  extern Class_Descriptor cd_ee36010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36010, buf);
    ee36010 *dp, &lv = *(dp=new (buf) ee36010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(36,24), "ee36010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), ABISELECT(16,8), "ee36010");
    check_base_class_offset(lv, (cc010*)(dd6010*), ABISELECT(16,8), "ee36010");
    check_base_class_offset(lv, (dd6010*), ABISELECT(16,8), "ee36010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36010.e");
    test_class_info(&lv, &cd_ee36010);
    dp->~ee36010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36010(Test_ee36010, "ee36010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36010C1Ev();
extern void _ZN7ee36010D1Ev();
Name_Map name_map_ee36010[] = {
  NSPAIR(_ZN7ee36010C1Ev),
  NSPAIR(_ZN7ee36010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee36010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36010[];
extern void _ZN7ee360103fooEv();
extern void _ZN6dd60103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee360103fooEv,_ZTv0_n20_N7ee360103fooEv)();
extern void ABISELECT(_ZThn16_N7ee360103fooEv,_ZThn8_N7ee360103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36010[0]),
  (VTBL_ENTRY)&_ZN7ee360103fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee360103fooEv,_ZTv0_n20_N7ee360103fooEv),
};
extern VTBL_ENTRY _ZTV7ee36010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee36010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee36010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee36010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee36010[] = {
  {&(_ZTV7ee36010[4]),  4,12},
  {&(_ZTV7ee36010[10]),  10,12},
  {&(_tg__ZTV6dd6010__7ee36010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee36010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee36010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee36010[];
extern  VTBL_ENTRY _ZTV7ee36010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36010[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee360103fooEv,_ZTv0_n20_N7ee360103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360103fooEv,_ZThn8_N7ee360103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36010 = {  "ee36010", // class name
  bases_ee36010, 4,
  &(vtc_ee36010[0]), // expected_vtbl_contents
  &(vtt_ee36010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36010),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46010  : dd6010 {
  int e;
  virtual void  bar(); // _ZN7ee460103barEv
  ~ee46010(); // tgen
  ee46010(); // tgen
};
//SIG(1 ee46010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46010 ::bar(){vfunc_called(this, "_ZN7ee460103barEv");}
ee46010 ::~ee46010(){ note_dtor("ee46010", this);} // tgen
ee46010 ::ee46010(){ note_ctor("ee46010", this);} // tgen

static void Test_ee46010()
{
  extern Class_Descriptor cd_ee46010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46010, buf);
    ee46010 *dp, &lv = *(dp=new (buf) ee46010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(24,20), "ee46010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), 0, "ee46010");
    check_base_class_offset(lv, (cc010*)(dd6010*), 0, "ee46010");
    check_base_class_offset(lv, (dd6010*), 0, "ee46010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee46010.e");
    test_class_info(&lv, &cd_ee46010);
    dp->~ee46010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46010(Test_ee46010, "ee46010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46010C1Ev();
extern void _ZN7ee46010D1Ev();
Name_Map name_map_ee46010[] = {
  NSPAIR(_ZN7ee46010C1Ev),
  NSPAIR(_ZN7ee46010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee46010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46010[];
extern void _ZN7ee460103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY vtc_ee46010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46010[0]),
  (VTBL_ENTRY)&_ZN7ee460103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
extern VTBL_ENTRY _ZTV7ee46010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee46010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee46010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee46010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee46010[] = {
  {&(_ZTV7ee46010[3]),  3,5},
  {&(_tg__ZTV6dd6010__7ee46010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee46010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee46010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee46010[];
extern  VTBL_ENTRY _ZTV7ee46010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46010[];
Class_Descriptor cd_ee46010 = {  "ee46010", // class name
  bases_ee46010, 4,
  &(vtc_ee46010[0]), // expected_vtbl_contents
  &(vtt_ee46010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56010  : virtual dd6010 {
  int e;
  virtual void  bar(); // _ZN7ee560103barEv
  ~ee56010(); // tgen
  ee56010(); // tgen
};
//SIG(1 ee56010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56010 ::bar(){vfunc_called(this, "_ZN7ee560103barEv");}
ee56010 ::~ee56010(){ note_dtor("ee56010", this);} // tgen
ee56010 ::ee56010(){ note_ctor("ee56010", this);} // tgen

static void Test_ee56010()
{
  extern Class_Descriptor cd_ee56010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56010, buf);
    ee56010 *dp, &lv = *(dp=new (buf) ee56010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(36,24), "ee56010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), ABISELECT(16,8), "ee56010");
    check_base_class_offset(lv, (cc010*)(dd6010*), ABISELECT(16,8), "ee56010");
    check_base_class_offset(lv, (dd6010*), ABISELECT(16,8), "ee56010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56010.e");
    test_class_info(&lv, &cd_ee56010);
    dp->~ee56010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56010(Test_ee56010, "ee56010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56010C1Ev();
extern void _ZN7ee56010D1Ev();
Name_Map name_map_ee56010[] = {
  NSPAIR(_ZN7ee56010C1Ev),
  NSPAIR(_ZN7ee56010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee56010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56010[];
extern void _ZN7ee560103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee560103barEv,_ZTv0_n16_N7ee560103barEv)();
extern void ABISELECT(_ZThn16_N7ee560103barEv,_ZThn8_N7ee560103barEv)() __attribute__((weak));
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY vtc_ee56010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56010[0]),
  (VTBL_ENTRY)&_ZN7ee560103barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee560103barEv,_ZTv0_n16_N7ee560103barEv),
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
extern VTBL_ENTRY _ZTV7ee56010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee56010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee56010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee56010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee56010[] = {
  {&(_ZTV7ee56010[4]),  4,12},
  {&(_ZTV7ee56010[10]),  10,12},
  {&(_tg__ZTV6dd6010__7ee56010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee56010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee56010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee56010[];
extern  VTBL_ENTRY _ZTV7ee56010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56010[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee560103barEv,_ZTv0_n16_N7ee560103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560103barEv,_ZThn8_N7ee560103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56010 = {  "ee56010", // class name
  bases_ee56010, 4,
  &(vtc_ee56010[0]), // expected_vtbl_contents
  &(vtt_ee56010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56010),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66010  : dd6010 {
  int e;
  virtual void  foo(); // _ZN7ee660103fooEv
  virtual void  bar(); // _ZN7ee660103barEv
  ~ee66010(); // tgen
  ee66010(); // tgen
};
//SIG(1 ee66010) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66010 ::foo(){vfunc_called(this, "_ZN7ee660103fooEv");}
void  ee66010 ::bar(){vfunc_called(this, "_ZN7ee660103barEv");}
ee66010 ::~ee66010(){ note_dtor("ee66010", this);} // tgen
ee66010 ::ee66010(){ note_ctor("ee66010", this);} // tgen

static void Test_ee66010()
{
  extern Class_Descriptor cd_ee66010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66010, buf);
    ee66010 *dp, &lv = *(dp=new (buf) ee66010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(24,20), "ee66010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), 0, "ee66010");
    check_base_class_offset(lv, (cc010*)(dd6010*), 0, "ee66010");
    check_base_class_offset(lv, (dd6010*), 0, "ee66010");
    check_field_offset(lv, e, ABISELECT(20,16), "ee66010.e");
    test_class_info(&lv, &cd_ee66010);
    dp->~ee66010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66010(Test_ee66010, "ee66010", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66010C1Ev();
extern void _ZN7ee66010D1Ev();
Name_Map name_map_ee66010[] = {
  NSPAIR(_ZN7ee66010C1Ev),
  NSPAIR(_ZN7ee66010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee66010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66010[];
extern void _ZN7ee660103barEv();
extern void _ZN7ee660103fooEv();
static  VTBL_ENTRY vtc_ee66010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66010[0]),
  (VTBL_ENTRY)&_ZN7ee660103barEv,
  (VTBL_ENTRY)&_ZN7ee660103fooEv,
};
extern VTBL_ENTRY _ZTV7ee66010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee66010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee66010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee66010[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee66010[] = {
  {&(_ZTV7ee66010[3]),  3,5},
  {&(_tg__ZTV6dd6010__7ee66010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee66010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee66010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee66010[];
extern  VTBL_ENTRY _ZTV7ee66010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66010[];
Class_Descriptor cd_ee66010 = {  "ee66010", // class name
  bases_ee66010, 4,
  &(vtc_ee66010[0]), // expected_vtbl_contents
  &(vtt_ee66010[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66010),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66010),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76010  : virtual dd6010 {
  int e;
  virtual void  foo(); // _ZN7ee760103fooEv
  virtual void  bar(); // _ZN7ee760103barEv
  ~ee76010(); // tgen
  ee76010(); // tgen
};
//SIG(1 ee76010) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76010 ::foo(){vfunc_called(this, "_ZN7ee760103fooEv");}
void  ee76010 ::bar(){vfunc_called(this, "_ZN7ee760103barEv");}
ee76010 ::~ee76010(){ note_dtor("ee76010", this);} // tgen
ee76010 ::ee76010(){ note_ctor("ee76010", this);} // tgen

static void Test_ee76010()
{
  extern Class_Descriptor cd_ee76010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76010, buf);
    ee76010 *dp, &lv = *(dp=new (buf) ee76010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*)(dd6010*), ABISELECT(36,24), "ee76010");
    check_base_class_offset(lv, (bb10*)(cc010*)(dd6010*), ABISELECT(16,8), "ee76010");
    check_base_class_offset(lv, (cc010*)(dd6010*), ABISELECT(16,8), "ee76010");
    check_base_class_offset(lv, (dd6010*), ABISELECT(16,8), "ee76010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76010.e");
    test_class_info(&lv, &cd_ee76010);
    dp->~ee76010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76010(Test_ee76010, "ee76010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76010C1Ev();
extern void _ZN7ee76010D1Ev();
Name_Map name_map_ee76010[] = {
  NSPAIR(_ZN7ee76010C1Ev),
  NSPAIR(_ZN7ee76010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd6010;
extern VTBL_ENTRY _ZTI6dd6010[];
extern  VTBL_ENTRY _ZTV6dd6010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6010[];
static Base_Class bases_ee76010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76010[];
extern void _ZN7ee760103fooEv();
extern void _ZN7ee760103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee760103barEv,_ZTv0_n16_N7ee760103barEv)();
extern void ABISELECT(_ZThn16_N7ee760103barEv,_ZThn8_N7ee760103barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee760103fooEv,_ZTv0_n20_N7ee760103fooEv)();
extern void ABISELECT(_ZThn16_N7ee760103fooEv,_ZThn8_N7ee760103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76010[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76010[0]),
  (VTBL_ENTRY)&_ZN7ee760103fooEv,
  (VTBL_ENTRY)&_ZN7ee760103barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760103barEv,_ZTv0_n16_N7ee760103barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee760103fooEv,_ZTv0_n20_N7ee760103fooEv),
};
extern VTBL_ENTRY _ZTV7ee76010[];
extern void _ZN6dd60103barEv();
extern void _ZN6dd60103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6010__7ee76010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6010[0]),
  (VTBL_ENTRY)&_ZN6dd60103barEv,
  (VTBL_ENTRY)&_ZN6dd60103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc0106dd6010__7ee76010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc0106dd6010__7ee76010[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee76010[] = {
  {&(_ZTV7ee76010[4]),  4,13},
  {&(_ZTV7ee76010[11]),  11,13},
  {&(_tg__ZTV6dd6010__7ee76010[3]),  3,5},
  {&(_tg__ZTV5cc0106dd6010__7ee76010[3]),  3,3},
  {&(_tg__ZTV4bb105cc0106dd6010__7ee76010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee76010[];
extern  VTBL_ENTRY _ZTV7ee76010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76010[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee760103fooEv,_ZTv0_n20_N7ee760103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760103fooEv,_ZThn8_N7ee760103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760103barEv,_ZTv0_n16_N7ee760103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760103barEv,_ZThn8_N7ee760103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76010 = {  "ee76010", // class name
  bases_ee76010, 4,
  &(vtc_ee76010[0]), // expected_vtbl_contents
  &(vtt_ee76010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76010),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76010),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7010  : virtual cc010 {
  int d;
  virtual void  bar(); // _ZN6dd70103barEv
  virtual void  foo(); // _ZN6dd70103fooEv
  ~dd7010(); // tgen
  dd7010(); // tgen
};
//SIG(-1 dd7010) C1{ VBC2{ BC3{ VBC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd7010 ::bar(){vfunc_called(this, "_ZN6dd70103barEv");}
void  dd7010 ::foo(){vfunc_called(this, "_ZN6dd70103fooEv");}
dd7010 ::~dd7010(){ note_dtor("dd7010", this);} // tgen
dd7010 ::dd7010(){ note_ctor("dd7010", this);} // tgen

static void Test_dd7010()
{
  extern Class_Descriptor cd_dd7010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7010, buf);
    dd7010 *dp, &lv = *(dp=new (buf) dd7010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,20), "dd7010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,8), "dd7010");
    check_base_class_offset(lv, (cc010*), ABISELECT(16,8), "dd7010");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7010.d");
    test_class_info(&lv, &cd_dd7010);
    dp->~dd7010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7010(Test_dd7010, "dd7010", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7010C1Ev();
extern void _ZN6dd7010D1Ev();
Name_Map name_map_dd7010[] = {
  NSPAIR(_ZN6dd7010C1Ev),
  NSPAIR(_ZN6dd7010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
static Base_Class bases_dd7010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY vtc_dd7010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
extern VTBL_ENTRY _ZTV6dd7010[];
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__6dd7010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd7010[] = {
  {&(_ZTV6dd7010[4]),  4,9},
  {&(_ZTV6dd7010[9]),  9,9},
  {&(_tg__ZTV5cc010__6dd7010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__6dd7010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
Class_Descriptor cd_dd7010 = {  "dd7010", // class name
  bases_dd7010, 3,
  &(vtc_dd7010[0]), // expected_vtbl_contents
  &(vtt_dd7010[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7010),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07010  : dd7010 {
  int e;
  ~ee07010(); // tgen
  ee07010(); // tgen
};
//SIG(1 ee07010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee07010 ::~ee07010(){ note_dtor("ee07010", this);} // tgen
ee07010 ::ee07010(){ note_ctor("ee07010", this);} // tgen

static void Test_ee07010()
{
  extern Class_Descriptor cd_ee07010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07010, buf);
    ee07010 *dp, &lv = *(dp=new (buf) ee07010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee07010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee07010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(16,12), "ee07010");
    check_base_class_offset(lv, (dd7010*), 0, "ee07010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07010.e");
    test_class_info(&lv, &cd_ee07010);
    dp->~ee07010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07010(Test_ee07010, "ee07010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07010C1Ev();
extern void _ZN7ee07010D1Ev();
Name_Map name_map_ee07010[] = {
  NSPAIR(_ZN7ee07010C1Ev),
  NSPAIR(_ZN7ee07010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee07010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY vtc_ee07010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07010[0]),
};
extern VTBL_ENTRY _ZTV7ee07010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee07010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee07010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee07010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee07010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee07010[] = {
  {&(_ZTV7ee07010[4]),  4,9},
  {&(_tg__ZTV6dd7010__7ee07010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee07010[3]),  3,3},
  {&(_ZTV7ee07010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee07010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee07010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee07010[];
extern  VTBL_ENTRY _ZTV7ee07010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07010[];
Class_Descriptor cd_ee07010 = {  "ee07010", // class name
  bases_ee07010, 4,
  &(vtc_ee07010[0]), // expected_vtbl_contents
  &(vtt_ee07010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17010  : virtual dd7010 {
  int e;
  ~ee17010(); // tgen
  ee17010(); // tgen
};
//SIG(1 ee17010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee17010 ::~ee17010(){ note_dtor("ee17010", this);} // tgen
ee17010 ::ee17010(){ note_ctor("ee17010", this);} // tgen

static void Test_ee17010()
{
  extern Class_Descriptor cd_ee17010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17010, buf);
    ee17010 *dp, &lv = *(dp=new (buf) ee17010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee17010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee17010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(32,16), "ee17010");
    check_base_class_offset(lv, (dd7010*), ABISELECT(16,8), "ee17010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17010.e");
    test_class_info(&lv, &cd_ee17010);
    dp->~ee17010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17010(Test_ee17010, "ee17010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17010C1Ev();
extern void _ZN7ee17010D1Ev();
Name_Map name_map_ee17010[] = {
  NSPAIR(_ZN7ee17010C1Ev),
  NSPAIR(_ZN7ee17010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee17010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY vtc_ee17010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17010[0]),
  0,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17010[0]),
};
extern VTBL_ENTRY _ZTV7ee17010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee17010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee17010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee17010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee17010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee17010[] = {
  {&(_ZTV7ee17010[5]),  5,16},
  {&(_ZTV7ee17010[11]),  11,16},
  {&(_ZTV7ee17010[16]),  16,16},
  {&(_tg__ZTV6dd7010__7ee17010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee17010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee17010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee17010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee17010[];
extern  VTBL_ENTRY _ZTV7ee17010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17010[];
Class_Descriptor cd_ee17010 = {  "ee17010", // class name
  bases_ee17010, 4,
  &(vtc_ee17010[0]), // expected_vtbl_contents
  &(vtt_ee17010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17010),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27010  : dd7010 {
  int e;
  virtual void  foo(); // _ZN7ee270103fooEv
  ~ee27010(); // tgen
  ee27010(); // tgen
};
//SIG(1 ee27010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27010 ::foo(){vfunc_called(this, "_ZN7ee270103fooEv");}
ee27010 ::~ee27010(){ note_dtor("ee27010", this);} // tgen
ee27010 ::ee27010(){ note_ctor("ee27010", this);} // tgen

static void Test_ee27010()
{
  extern Class_Descriptor cd_ee27010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27010, buf);
    ee27010 *dp, &lv = *(dp=new (buf) ee27010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee27010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee27010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(16,12), "ee27010");
    check_base_class_offset(lv, (dd7010*), 0, "ee27010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27010.e");
    test_class_info(&lv, &cd_ee27010);
    dp->~ee27010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27010(Test_ee27010, "ee27010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27010C1Ev();
extern void _ZN7ee27010D1Ev();
Name_Map name_map_ee27010[] = {
  NSPAIR(_ZN7ee27010C1Ev),
  NSPAIR(_ZN7ee27010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee27010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27010[];
extern void _ZN6dd70103barEv();
extern void _ZN7ee270103fooEv();
static  VTBL_ENTRY vtc_ee27010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN7ee270103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27010[0]),
};
extern VTBL_ENTRY _ZTV7ee27010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee27010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee27010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee27010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee27010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee27010[] = {
  {&(_ZTV7ee27010[4]),  4,9},
  {&(_tg__ZTV6dd7010__7ee27010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee27010[3]),  3,3},
  {&(_ZTV7ee27010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee27010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee27010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee27010[];
extern  VTBL_ENTRY _ZTV7ee27010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27010[];
Class_Descriptor cd_ee27010 = {  "ee27010", // class name
  bases_ee27010, 4,
  &(vtc_ee27010[0]), // expected_vtbl_contents
  &(vtt_ee27010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37010  : virtual dd7010 {
  int e;
  virtual void  foo(); // _ZN7ee370103fooEv
  ~ee37010(); // tgen
  ee37010(); // tgen
};
//SIG(1 ee37010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37010 ::foo(){vfunc_called(this, "_ZN7ee370103fooEv");}
ee37010 ::~ee37010(){ note_dtor("ee37010", this);} // tgen
ee37010 ::ee37010(){ note_ctor("ee37010", this);} // tgen

static void Test_ee37010()
{
  extern Class_Descriptor cd_ee37010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37010, buf);
    ee37010 *dp, &lv = *(dp=new (buf) ee37010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee37010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee37010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(32,16), "ee37010");
    check_base_class_offset(lv, (dd7010*), ABISELECT(16,8), "ee37010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37010.e");
    test_class_info(&lv, &cd_ee37010);
    dp->~ee37010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37010(Test_ee37010, "ee37010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37010C1Ev();
extern void _ZN7ee37010D1Ev();
Name_Map name_map_ee37010[] = {
  NSPAIR(_ZN7ee37010C1Ev),
  NSPAIR(_ZN7ee37010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee37010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37010[];
extern void _ZN7ee370103fooEv();
extern void _ZN6dd70103barEv();
extern void ABISELECT(_ZTv0_n48_N7ee370103fooEv,_ZTv0_n24_N7ee370103fooEv)();
extern void ABISELECT(_ZThn16_N7ee370103fooEv,_ZThn8_N7ee370103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37010[0]),
  (VTBL_ENTRY)&_ZN7ee370103fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee370103fooEv,_ZTv0_n24_N7ee370103fooEv),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37010[0]),
};
extern VTBL_ENTRY _ZTV7ee37010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee37010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee37010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee37010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee37010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee37010[] = {
  {&(_ZTV7ee37010[5]),  5,17},
  {&(_ZTV7ee37010[12]),  12,17},
  {&(_ZTV7ee37010[17]),  17,17},
  {&(_tg__ZTV6dd7010__7ee37010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee37010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee37010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee37010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee37010[];
extern  VTBL_ENTRY _ZTV7ee37010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37010[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee370103fooEv,_ZTv0_n24_N7ee370103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370103fooEv,_ZThn8_N7ee370103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37010 = {  "ee37010", // class name
  bases_ee37010, 4,
  &(vtc_ee37010[0]), // expected_vtbl_contents
  &(vtt_ee37010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37010),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47010  : dd7010 {
  int e;
  virtual void  bar(); // _ZN7ee470103barEv
  ~ee47010(); // tgen
  ee47010(); // tgen
};
//SIG(1 ee47010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47010 ::bar(){vfunc_called(this, "_ZN7ee470103barEv");}
ee47010 ::~ee47010(){ note_dtor("ee47010", this);} // tgen
ee47010 ::ee47010(){ note_ctor("ee47010", this);} // tgen

static void Test_ee47010()
{
  extern Class_Descriptor cd_ee47010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47010, buf);
    ee47010 *dp, &lv = *(dp=new (buf) ee47010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee47010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee47010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(16,12), "ee47010");
    check_base_class_offset(lv, (dd7010*), 0, "ee47010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47010.e");
    test_class_info(&lv, &cd_ee47010);
    dp->~ee47010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47010(Test_ee47010, "ee47010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47010C1Ev();
extern void _ZN7ee47010D1Ev();
Name_Map name_map_ee47010[] = {
  NSPAIR(_ZN7ee47010C1Ev),
  NSPAIR(_ZN7ee47010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee47010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47010[];
extern void _ZN7ee470103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY vtc_ee47010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47010[0]),
  (VTBL_ENTRY)&_ZN7ee470103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47010[0]),
};
extern VTBL_ENTRY _ZTV7ee47010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee47010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee47010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee47010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee47010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee47010[] = {
  {&(_ZTV7ee47010[4]),  4,9},
  {&(_tg__ZTV6dd7010__7ee47010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee47010[3]),  3,3},
  {&(_ZTV7ee47010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee47010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee47010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee47010[];
extern  VTBL_ENTRY _ZTV7ee47010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47010[];
Class_Descriptor cd_ee47010 = {  "ee47010", // class name
  bases_ee47010, 4,
  &(vtc_ee47010[0]), // expected_vtbl_contents
  &(vtt_ee47010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57010  : virtual dd7010 {
  int e;
  virtual void  bar(); // _ZN7ee570103barEv
  ~ee57010(); // tgen
  ee57010(); // tgen
};
//SIG(1 ee57010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57010 ::bar(){vfunc_called(this, "_ZN7ee570103barEv");}
ee57010 ::~ee57010(){ note_dtor("ee57010", this);} // tgen
ee57010 ::ee57010(){ note_ctor("ee57010", this);} // tgen

static void Test_ee57010()
{
  extern Class_Descriptor cd_ee57010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57010, buf);
    ee57010 *dp, &lv = *(dp=new (buf) ee57010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee57010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee57010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(32,16), "ee57010");
    check_base_class_offset(lv, (dd7010*), ABISELECT(16,8), "ee57010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57010.e");
    test_class_info(&lv, &cd_ee57010);
    dp->~ee57010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57010(Test_ee57010, "ee57010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57010C1Ev();
extern void _ZN7ee57010D1Ev();
Name_Map name_map_ee57010[] = {
  NSPAIR(_ZN7ee57010C1Ev),
  NSPAIR(_ZN7ee57010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee57010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57010[];
extern void _ZN7ee570103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee570103barEv,_ZTv0_n20_N7ee570103barEv)();
extern void ABISELECT(_ZThn16_N7ee570103barEv,_ZThn8_N7ee570103barEv)() __attribute__((weak));
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY vtc_ee57010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57010[0]),
  (VTBL_ENTRY)&_ZN7ee570103barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee570103barEv,_ZTv0_n20_N7ee570103barEv),
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57010[0]),
};
extern VTBL_ENTRY _ZTV7ee57010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee57010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee57010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee57010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee57010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee57010[] = {
  {&(_ZTV7ee57010[5]),  5,17},
  {&(_ZTV7ee57010[12]),  12,17},
  {&(_ZTV7ee57010[17]),  17,17},
  {&(_tg__ZTV6dd7010__7ee57010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee57010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee57010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee57010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee57010[];
extern  VTBL_ENTRY _ZTV7ee57010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57010[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee570103barEv,_ZTv0_n20_N7ee570103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570103barEv,_ZThn8_N7ee570103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57010 = {  "ee57010", // class name
  bases_ee57010, 4,
  &(vtc_ee57010[0]), // expected_vtbl_contents
  &(vtt_ee57010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57010),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67010  : dd7010 {
  int e;
  virtual void  foo(); // _ZN7ee670103fooEv
  virtual void  bar(); // _ZN7ee670103barEv
  ~ee67010(); // tgen
  ee67010(); // tgen
};
//SIG(1 ee67010) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67010 ::foo(){vfunc_called(this, "_ZN7ee670103fooEv");}
void  ee67010 ::bar(){vfunc_called(this, "_ZN7ee670103barEv");}
ee67010 ::~ee67010(){ note_dtor("ee67010", this);} // tgen
ee67010 ::ee67010(){ note_ctor("ee67010", this);} // tgen

static void Test_ee67010()
{
  extern Class_Descriptor cd_ee67010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67010, buf);
    ee67010 *dp, &lv = *(dp=new (buf) ee67010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(32,24), "ee67010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(16,12), "ee67010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(16,12), "ee67010");
    check_base_class_offset(lv, (dd7010*), 0, "ee67010");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67010.e");
    test_class_info(&lv, &cd_ee67010);
    dp->~ee67010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67010(Test_ee67010, "ee67010", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67010C1Ev();
extern void _ZN7ee67010D1Ev();
Name_Map name_map_ee67010[] = {
  NSPAIR(_ZN7ee67010C1Ev),
  NSPAIR(_ZN7ee67010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee67010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67010[];
extern void _ZN7ee670103barEv();
extern void _ZN7ee670103fooEv();
static  VTBL_ENTRY vtc_ee67010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67010[0]),
  (VTBL_ENTRY)&_ZN7ee670103barEv,
  (VTBL_ENTRY)&_ZN7ee670103fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67010[0]),
};
extern VTBL_ENTRY _ZTV7ee67010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee67010[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee67010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee67010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee67010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee67010[] = {
  {&(_ZTV7ee67010[4]),  4,9},
  {&(_tg__ZTV6dd7010__7ee67010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee67010[3]),  3,3},
  {&(_ZTV7ee67010[9]),  9,9},
  {&(_tg__ZTV5cc010__7ee67010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee67010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee67010[];
extern  VTBL_ENTRY _ZTV7ee67010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67010[];
Class_Descriptor cd_ee67010 = {  "ee67010", // class name
  bases_ee67010, 4,
  &(vtc_ee67010[0]), // expected_vtbl_contents
  &(vtt_ee67010[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67010),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67010),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67010),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77010  : virtual dd7010 {
  int e;
  virtual void  foo(); // _ZN7ee770103fooEv
  virtual void  bar(); // _ZN7ee770103barEv
  ~ee77010(); // tgen
  ee77010(); // tgen
};
//SIG(1 ee77010) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77010 ::foo(){vfunc_called(this, "_ZN7ee770103fooEv");}
void  ee77010 ::bar(){vfunc_called(this, "_ZN7ee770103barEv");}
ee77010 ::~ee77010(){ note_dtor("ee77010", this);} // tgen
ee77010 ::ee77010(){ note_ctor("ee77010", this);} // tgen

static void Test_ee77010()
{
  extern Class_Descriptor cd_ee77010;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77010, buf);
    ee77010 *dp, &lv = *(dp=new (buf) ee77010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77010)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77010)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc010*), ABISELECT(48,28), "ee77010");
    check_base_class_offset(lv, (bb10*)(cc010*), ABISELECT(32,16), "ee77010");
    check_base_class_offset(lv, (cc010*)(dd7010*), ABISELECT(32,16), "ee77010");
    check_base_class_offset(lv, (dd7010*), ABISELECT(16,8), "ee77010");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77010.e");
    test_class_info(&lv, &cd_ee77010);
    dp->~ee77010();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77010(Test_ee77010, "ee77010", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77010C1Ev();
extern void _ZN7ee77010D1Ev();
Name_Map name_map_ee77010[] = {
  NSPAIR(_ZN7ee77010C1Ev),
  NSPAIR(_ZN7ee77010D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc010;
extern VTBL_ENTRY _ZTI5cc010[];
extern  VTBL_ENTRY _ZTV5cc010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc010[];
extern Class_Descriptor cd_dd7010;
extern VTBL_ENTRY _ZTI6dd7010[];
extern  VTBL_ENTRY _ZTV6dd7010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7010[];
static Base_Class bases_ee77010[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc010,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7010,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77010[];
extern void _ZN7ee770103fooEv();
extern void _ZN7ee770103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee770103barEv,_ZTv0_n20_N7ee770103barEv)();
extern void ABISELECT(_ZThn16_N7ee770103barEv,_ZThn8_N7ee770103barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee770103fooEv,_ZTv0_n24_N7ee770103fooEv)();
extern void ABISELECT(_ZThn16_N7ee770103fooEv,_ZThn8_N7ee770103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77010[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77010[0]),
  (VTBL_ENTRY)&_ZN7ee770103fooEv,
  (VTBL_ENTRY)&_ZN7ee770103barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77010[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770103barEv,_ZTv0_n20_N7ee770103barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee770103fooEv,_ZTv0_n24_N7ee770103fooEv),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77010[0]),
};
extern VTBL_ENTRY _ZTV7ee77010[];
extern void _ZN6dd70103barEv();
extern void _ZN6dd70103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7010__7ee77010[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
  (VTBL_ENTRY)&_ZN6dd70103barEv,
  (VTBL_ENTRY)&_ZN6dd70103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc010__6dd7010__7ee77010[] = {
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7010[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc010__7ee77010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc010[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb105cc010__7ee77010[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee77010[] = {
  {&(_ZTV7ee77010[5]),  5,18},
  {&(_ZTV7ee77010[13]),  13,18},
  {&(_ZTV7ee77010[18]),  18,18},
  {&(_tg__ZTV6dd7010__7ee77010[4]),  4,6},
  {&(_tg__ZTV5cc010__6dd7010__7ee77010[3]),  3,3},
  {&(_tg__ZTV5cc010__7ee77010[3]),  3,3},
  {&(_tg__ZTV4bb105cc010__7ee77010[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee77010[];
extern  VTBL_ENTRY _ZTV7ee77010[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77010[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee770103fooEv,_ZTv0_n24_N7ee770103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770103fooEv,_ZThn8_N7ee770103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770103barEv,_ZTv0_n20_N7ee770103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770103barEv,_ZThn8_N7ee770103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77010 = {  "ee77010", // class name
  bases_ee77010, 4,
  &(vtc_ee77010[0]), // expected_vtbl_contents
  &(vtt_ee77010[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77010),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77010),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77010),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc110  : virtual bb10 {
  int c;
  ~cc110(); // tgen
  cc110(); // tgen
};
//SIG(-1 cc110) C1{ VBC2{ VBC3{ Fi} Fi} Fi}


cc110 ::~cc110(){ note_dtor("cc110", this);} // tgen
cc110 ::cc110(){ note_ctor("cc110", this);} // tgen

static void Test_cc110()
{
  extern Class_Descriptor cd_cc110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_cc110, buf);
    cc110 *dp, &lv = *(dp=new (buf) cc110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(cc110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(28,16), "cc110");
    check_base_class_offset(lv, (bb10*), ABISELECT(16,8), "cc110");
    check_field_offset(lv, c, ABISELECT(8,4), "cc110.c");
    test_class_info(&lv, &cd_cc110);
    dp->~cc110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc110(Test_cc110, "cc110", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN5cc110C1Ev();
extern void _ZN5cc110D1Ev();
Name_Map name_map_cc110[] = {
  NSPAIR(_ZN5cc110C1Ev),
  NSPAIR(_ZN5cc110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
static Base_Class bases_cc110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc110[];
static  VTBL_ENTRY vtc_cc110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
extern VTBL_ENTRY _ZTV5cc110[];
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_cc110[] = {
  {&(_ZTV5cc110[4]),  4,7},
  {&(_ZTV5cc110[7]),  7,7},
  {&(_tg__ZTV4bb10__5cc110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
Class_Descriptor cd_cc110 = {  "cc110", // class name
  bases_cc110, 2,
  &(vtc_cc110[0]), // expected_vtbl_contents
  &(vtt_cc110[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI5cc110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc110),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc110),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0110  : cc110 {
  int d;
  ~dd0110(); // tgen
  dd0110(); // tgen
};
//SIG(-1 dd0110) C1{ BC2{ VBC3{ VBC4{ Fi} Fi} Fi} Fi}


dd0110 ::~dd0110(){ note_dtor("dd0110", this);} // tgen
dd0110 ::dd0110(){ note_ctor("dd0110", this);} // tgen

static void Test_dd0110()
{
  extern Class_Descriptor cd_dd0110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd0110, buf);
    dd0110 *dp, &lv = *(dp=new (buf) dd0110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd0110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(28,20), "dd0110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(16,12), "dd0110");
    check_base_class_offset(lv, (cc110*), 0, "dd0110");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0110.d");
    test_class_info(&lv, &cd_dd0110);
    dp->~dd0110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0110(Test_dd0110, "dd0110", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd0110C1Ev();
extern void _ZN6dd0110D1Ev();
Name_Map name_map_dd0110[] = {
  NSPAIR(_ZN6dd0110C1Ev),
  NSPAIR(_ZN6dd0110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd0110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0110[];
static  VTBL_ENTRY vtc_dd0110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
extern VTBL_ENTRY _ZTV6dd0110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd0110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd0110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd0110[] = {
  {&(_ZTV6dd0110[4]),  4,7},
  {&(_tg__ZTV5cc110__6dd0110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd0110[3]),  3,3},
  {&(_ZTV6dd0110[7]),  7,7},
  {&(_tg__ZTV4bb10__6dd0110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
Class_Descriptor cd_dd0110 = {  "dd0110", // class name
  bases_dd0110, 3,
  &(vtc_dd0110[0]), // expected_vtbl_contents
  &(vtt_dd0110[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd0110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0110),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0110),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00110  : dd0110 {
  int e;
  ~ee00110(); // tgen
  ee00110(); // tgen
};
//SIG(1 ee00110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee00110 ::~ee00110(){ note_dtor("ee00110", this);} // tgen
ee00110 ::ee00110(){ note_ctor("ee00110", this);} // tgen

static void Test_ee00110()
{
  extern Class_Descriptor cd_ee00110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee00110, buf);
    ee00110 *dp, &lv = *(dp=new (buf) ee00110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee00110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee00110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(24,16), "ee00110");
    check_base_class_offset(lv, (cc110*)(dd0110*), 0, "ee00110");
    check_base_class_offset(lv, (dd0110*), 0, "ee00110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00110.e");
    test_class_info(&lv, &cd_ee00110);
    dp->~ee00110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00110(Test_ee00110, "ee00110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee00110C1Ev();
extern void _ZN7ee00110D1Ev();
Name_Map name_map_ee00110[] = {
  NSPAIR(_ZN7ee00110C1Ev),
  NSPAIR(_ZN7ee00110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee00110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00110[];
static  VTBL_ENTRY vtc_ee00110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00110[0]),
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee00110[0]),
};
extern VTBL_ENTRY _ZTV7ee00110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee00110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee00110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee00110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee00110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee00110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee00110[] = {
  {&(_ZTV7ee00110[4]),  4,7},
  {&(_tg__ZTV6dd0110__7ee00110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee00110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee00110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee00110[3]),  3,3},
  {&(_ZTV7ee00110[7]),  7,7},
  {&(_tg__ZTV4bb10__7ee00110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee00110[];
extern  VTBL_ENTRY _ZTV7ee00110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00110[];
Class_Descriptor cd_ee00110 = {  "ee00110", // class name
  bases_ee00110, 4,
  &(vtc_ee00110[0]), // expected_vtbl_contents
  &(vtt_ee00110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee00110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00110),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10110  : virtual dd0110 {
  int e;
  ~ee10110(); // tgen
  ee10110(); // tgen
};
//SIG(1 ee10110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee10110 ::~ee10110(){ note_dtor("ee10110", this);} // tgen
ee10110 ::ee10110(){ note_ctor("ee10110", this);} // tgen

static void Test_ee10110()
{
  extern Class_Descriptor cd_ee10110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee10110, buf);
    ee10110 *dp, &lv = *(dp=new (buf) ee10110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee10110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee10110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(32,20), "ee10110");
    check_base_class_offset(lv, (cc110*)(dd0110*), ABISELECT(16,8), "ee10110");
    check_base_class_offset(lv, (dd0110*), ABISELECT(16,8), "ee10110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10110.e");
    test_class_info(&lv, &cd_ee10110);
    dp->~ee10110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10110(Test_ee10110, "ee10110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee10110C1Ev();
extern void _ZN7ee10110D1Ev();
Name_Map name_map_ee10110[] = {
  NSPAIR(_ZN7ee10110C1Ev),
  NSPAIR(_ZN7ee10110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee10110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10110[];
static  VTBL_ENTRY vtc_ee10110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10110[0]),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee10110[0]),
};
extern VTBL_ENTRY _ZTV7ee10110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee10110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee10110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee10110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee10110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee10110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee10110[] = {
  {&(_ZTV7ee10110[5]),  5,12},
  {&(_ZTV7ee10110[9]),  9,12},
  {&(_ZTV7ee10110[12]),  12,12},
  {&(_tg__ZTV6dd0110__7ee10110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee10110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee10110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee10110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee10110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee10110[];
extern  VTBL_ENTRY _ZTV7ee10110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10110[];
Class_Descriptor cd_ee10110 = {  "ee10110", // class name
  bases_ee10110, 4,
  &(vtc_ee10110[0]), // expected_vtbl_contents
  &(vtt_ee10110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee10110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10110),12, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20110  : dd0110 {
  int e;
  virtual void  foo(); // _ZN7ee201103fooEv
  ~ee20110(); // tgen
  ee20110(); // tgen
};
//SIG(1 ee20110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee20110 ::foo(){vfunc_called(this, "_ZN7ee201103fooEv");}
ee20110 ::~ee20110(){ note_dtor("ee20110", this);} // tgen
ee20110 ::ee20110(){ note_ctor("ee20110", this);} // tgen

static void Test_ee20110()
{
  extern Class_Descriptor cd_ee20110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee20110, buf);
    ee20110 *dp, &lv = *(dp=new (buf) ee20110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee20110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee20110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(24,16), "ee20110");
    check_base_class_offset(lv, (cc110*)(dd0110*), 0, "ee20110");
    check_base_class_offset(lv, (dd0110*), 0, "ee20110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20110.e");
    test_class_info(&lv, &cd_ee20110);
    dp->~ee20110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20110(Test_ee20110, "ee20110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee20110C1Ev();
extern void _ZN7ee20110D1Ev();
Name_Map name_map_ee20110[] = {
  NSPAIR(_ZN7ee20110C1Ev),
  NSPAIR(_ZN7ee20110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee20110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20110[];
extern void _ZN7ee201103fooEv();
static  VTBL_ENTRY vtc_ee20110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20110[0]),
  (VTBL_ENTRY)&_ZN7ee201103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee20110[0]),
};
extern VTBL_ENTRY _ZTV7ee20110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee20110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee20110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee20110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee20110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee20110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee20110[] = {
  {&(_ZTV7ee20110[4]),  4,8},
  {&(_tg__ZTV6dd0110__7ee20110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee20110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee20110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee20110[3]),  3,3},
  {&(_ZTV7ee20110[8]),  8,8},
  {&(_tg__ZTV4bb10__7ee20110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee20110[];
extern  VTBL_ENTRY _ZTV7ee20110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20110[];
Class_Descriptor cd_ee20110 = {  "ee20110", // class name
  bases_ee20110, 4,
  &(vtc_ee20110[0]), // expected_vtbl_contents
  &(vtt_ee20110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee20110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30110  : virtual dd0110 {
  int e;
  virtual void  foo(); // _ZN7ee301103fooEv
  ~ee30110(); // tgen
  ee30110(); // tgen
};
//SIG(1 ee30110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee30110 ::foo(){vfunc_called(this, "_ZN7ee301103fooEv");}
ee30110 ::~ee30110(){ note_dtor("ee30110", this);} // tgen
ee30110 ::ee30110(){ note_ctor("ee30110", this);} // tgen

static void Test_ee30110()
{
  extern Class_Descriptor cd_ee30110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee30110, buf);
    ee30110 *dp, &lv = *(dp=new (buf) ee30110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee30110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee30110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(32,20), "ee30110");
    check_base_class_offset(lv, (cc110*)(dd0110*), ABISELECT(16,8), "ee30110");
    check_base_class_offset(lv, (dd0110*), ABISELECT(16,8), "ee30110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30110.e");
    test_class_info(&lv, &cd_ee30110);
    dp->~ee30110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30110(Test_ee30110, "ee30110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee30110C1Ev();
extern void _ZN7ee30110D1Ev();
Name_Map name_map_ee30110[] = {
  NSPAIR(_ZN7ee30110C1Ev),
  NSPAIR(_ZN7ee30110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee30110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30110[];
extern void _ZN7ee301103fooEv();
static  VTBL_ENTRY vtc_ee30110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30110[0]),
  (VTBL_ENTRY)&_ZN7ee301103fooEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee30110[0]),
};
extern VTBL_ENTRY _ZTV7ee30110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee30110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee30110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee30110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee30110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee30110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee30110[] = {
  {&(_ZTV7ee30110[5]),  5,13},
  {&(_ZTV7ee30110[10]),  10,13},
  {&(_ZTV7ee30110[13]),  13,13},
  {&(_tg__ZTV6dd0110__7ee30110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee30110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee30110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee30110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee30110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee30110[];
extern  VTBL_ENTRY _ZTV7ee30110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30110[];
Class_Descriptor cd_ee30110 = {  "ee30110", // class name
  bases_ee30110, 4,
  &(vtc_ee30110[0]), // expected_vtbl_contents
  &(vtt_ee30110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee30110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40110  : dd0110 {
  int e;
  virtual void  bar(); // _ZN7ee401103barEv
  ~ee40110(); // tgen
  ee40110(); // tgen
};
//SIG(1 ee40110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee40110 ::bar(){vfunc_called(this, "_ZN7ee401103barEv");}
ee40110 ::~ee40110(){ note_dtor("ee40110", this);} // tgen
ee40110 ::ee40110(){ note_ctor("ee40110", this);} // tgen

static void Test_ee40110()
{
  extern Class_Descriptor cd_ee40110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee40110, buf);
    ee40110 *dp, &lv = *(dp=new (buf) ee40110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee40110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee40110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(24,16), "ee40110");
    check_base_class_offset(lv, (cc110*)(dd0110*), 0, "ee40110");
    check_base_class_offset(lv, (dd0110*), 0, "ee40110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40110.e");
    test_class_info(&lv, &cd_ee40110);
    dp->~ee40110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40110(Test_ee40110, "ee40110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee40110C1Ev();
extern void _ZN7ee40110D1Ev();
Name_Map name_map_ee40110[] = {
  NSPAIR(_ZN7ee40110C1Ev),
  NSPAIR(_ZN7ee40110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee40110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40110[];
extern void _ZN7ee401103barEv();
static  VTBL_ENTRY vtc_ee40110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40110[0]),
  (VTBL_ENTRY)&_ZN7ee401103barEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee40110[0]),
};
extern VTBL_ENTRY _ZTV7ee40110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee40110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee40110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee40110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee40110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee40110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee40110[] = {
  {&(_ZTV7ee40110[4]),  4,8},
  {&(_tg__ZTV6dd0110__7ee40110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee40110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee40110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee40110[3]),  3,3},
  {&(_ZTV7ee40110[8]),  8,8},
  {&(_tg__ZTV4bb10__7ee40110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee40110[];
extern  VTBL_ENTRY _ZTV7ee40110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40110[];
Class_Descriptor cd_ee40110 = {  "ee40110", // class name
  bases_ee40110, 4,
  &(vtc_ee40110[0]), // expected_vtbl_contents
  &(vtt_ee40110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee40110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50110  : virtual dd0110 {
  int e;
  virtual void  bar(); // _ZN7ee501103barEv
  ~ee50110(); // tgen
  ee50110(); // tgen
};
//SIG(1 ee50110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee50110 ::bar(){vfunc_called(this, "_ZN7ee501103barEv");}
ee50110 ::~ee50110(){ note_dtor("ee50110", this);} // tgen
ee50110 ::ee50110(){ note_ctor("ee50110", this);} // tgen

static void Test_ee50110()
{
  extern Class_Descriptor cd_ee50110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee50110, buf);
    ee50110 *dp, &lv = *(dp=new (buf) ee50110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee50110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee50110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(32,20), "ee50110");
    check_base_class_offset(lv, (cc110*)(dd0110*), ABISELECT(16,8), "ee50110");
    check_base_class_offset(lv, (dd0110*), ABISELECT(16,8), "ee50110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50110.e");
    test_class_info(&lv, &cd_ee50110);
    dp->~ee50110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50110(Test_ee50110, "ee50110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee50110C1Ev();
extern void _ZN7ee50110D1Ev();
Name_Map name_map_ee50110[] = {
  NSPAIR(_ZN7ee50110C1Ev),
  NSPAIR(_ZN7ee50110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee50110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50110[];
extern void _ZN7ee501103barEv();
static  VTBL_ENTRY vtc_ee50110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50110[0]),
  (VTBL_ENTRY)&_ZN7ee501103barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee50110[0]),
};
extern VTBL_ENTRY _ZTV7ee50110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee50110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee50110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee50110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee50110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee50110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee50110[] = {
  {&(_ZTV7ee50110[5]),  5,13},
  {&(_ZTV7ee50110[10]),  10,13},
  {&(_ZTV7ee50110[13]),  13,13},
  {&(_tg__ZTV6dd0110__7ee50110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee50110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee50110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee50110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee50110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee50110[];
extern  VTBL_ENTRY _ZTV7ee50110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50110[];
Class_Descriptor cd_ee50110 = {  "ee50110", // class name
  bases_ee50110, 4,
  &(vtc_ee50110[0]), // expected_vtbl_contents
  &(vtt_ee50110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee50110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60110  : dd0110 {
  int e;
  virtual void  foo(); // _ZN7ee601103fooEv
  virtual void  bar(); // _ZN7ee601103barEv
  ~ee60110(); // tgen
  ee60110(); // tgen
};
//SIG(1 ee60110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee60110 ::foo(){vfunc_called(this, "_ZN7ee601103fooEv");}
void  ee60110 ::bar(){vfunc_called(this, "_ZN7ee601103barEv");}
ee60110 ::~ee60110(){ note_dtor("ee60110", this);} // tgen
ee60110 ::ee60110(){ note_ctor("ee60110", this);} // tgen

static void Test_ee60110()
{
  extern Class_Descriptor cd_ee60110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee60110, buf);
    ee60110 *dp, &lv = *(dp=new (buf) ee60110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee60110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee60110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(24,16), "ee60110");
    check_base_class_offset(lv, (cc110*)(dd0110*), 0, "ee60110");
    check_base_class_offset(lv, (dd0110*), 0, "ee60110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60110.e");
    test_class_info(&lv, &cd_ee60110);
    dp->~ee60110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60110(Test_ee60110, "ee60110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee60110C1Ev();
extern void _ZN7ee60110D1Ev();
Name_Map name_map_ee60110[] = {
  NSPAIR(_ZN7ee60110C1Ev),
  NSPAIR(_ZN7ee60110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee60110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60110[];
extern void _ZN7ee601103fooEv();
extern void _ZN7ee601103barEv();
static  VTBL_ENTRY vtc_ee60110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60110[0]),
  (VTBL_ENTRY)&_ZN7ee601103fooEv,
  (VTBL_ENTRY)&_ZN7ee601103barEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee60110[0]),
};
extern VTBL_ENTRY _ZTV7ee60110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee60110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee60110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee60110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee60110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee60110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee60110[] = {
  {&(_ZTV7ee60110[4]),  4,9},
  {&(_tg__ZTV6dd0110__7ee60110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee60110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee60110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee60110[3]),  3,3},
  {&(_ZTV7ee60110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee60110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee60110[];
extern  VTBL_ENTRY _ZTV7ee60110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60110[];
Class_Descriptor cd_ee60110 = {  "ee60110", // class name
  bases_ee60110, 4,
  &(vtc_ee60110[0]), // expected_vtbl_contents
  &(vtt_ee60110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee60110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70110  : virtual dd0110 {
  int e;
  virtual void  foo(); // _ZN7ee701103fooEv
  virtual void  bar(); // _ZN7ee701103barEv
  ~ee70110(); // tgen
  ee70110(); // tgen
};
//SIG(1 ee70110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee70110 ::foo(){vfunc_called(this, "_ZN7ee701103fooEv");}
void  ee70110 ::bar(){vfunc_called(this, "_ZN7ee701103barEv");}
ee70110 ::~ee70110(){ note_dtor("ee70110", this);} // tgen
ee70110 ::ee70110(){ note_ctor("ee70110", this);} // tgen

static void Test_ee70110()
{
  extern Class_Descriptor cd_ee70110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee70110, buf);
    ee70110 *dp, &lv = *(dp=new (buf) ee70110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee70110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee70110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd0110*), ABISELECT(32,20), "ee70110");
    check_base_class_offset(lv, (cc110*)(dd0110*), ABISELECT(16,8), "ee70110");
    check_base_class_offset(lv, (dd0110*), ABISELECT(16,8), "ee70110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70110.e");
    test_class_info(&lv, &cd_ee70110);
    dp->~ee70110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70110(Test_ee70110, "ee70110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee70110C1Ev();
extern void _ZN7ee70110D1Ev();
Name_Map name_map_ee70110[] = {
  NSPAIR(_ZN7ee70110C1Ev),
  NSPAIR(_ZN7ee70110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd0110;
extern VTBL_ENTRY _ZTI6dd0110[];
extern  VTBL_ENTRY _ZTV6dd0110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0110[];
static Base_Class bases_ee70110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70110[];
extern void _ZN7ee701103fooEv();
extern void _ZN7ee701103barEv();
static  VTBL_ENTRY vtc_ee70110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70110[0]),
  (VTBL_ENTRY)&_ZN7ee701103fooEv,
  (VTBL_ENTRY)&_ZN7ee701103barEv,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee70110[0]),
};
extern VTBL_ENTRY _ZTV7ee70110[];
static  VTBL_ENTRY _tg__ZTV6dd0110__7ee70110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd0110__7ee70110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd0110__7ee70110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd0110__7ee70110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd0110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee70110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee70110[] = {
  {&(_ZTV7ee70110[5]),  5,14},
  {&(_ZTV7ee70110[11]),  11,14},
  {&(_ZTV7ee70110[14]),  14,14},
  {&(_tg__ZTV6dd0110__7ee70110[4]),  4,4},
  {&(_tg__ZTV5cc1106dd0110__7ee70110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd0110__7ee70110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd0110__7ee70110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee70110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee70110[];
extern  VTBL_ENTRY _ZTV7ee70110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70110[];
Class_Descriptor cd_ee70110 = {  "ee70110", // class name
  bases_ee70110, 4,
  &(vtc_ee70110[0]), // expected_vtbl_contents
  &(vtt_ee70110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee70110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1110  : virtual cc110 {
  int d;
  ~dd1110(); // tgen
  dd1110(); // tgen
};
//SIG(-1 dd1110) C1{ VBC2{ VBC3{ VBC4{ Fi} Fi} Fi} Fi}


dd1110 ::~dd1110(){ note_dtor("dd1110", this);} // tgen
dd1110 ::dd1110(){ note_ctor("dd1110", this);} // tgen

static void Test_dd1110()
{
  extern Class_Descriptor cd_dd1110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd1110, buf);
    dd1110 *dp, &lv = *(dp=new (buf) dd1110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd1110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,24), "dd1110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,16), "dd1110");
    check_base_class_offset(lv, (cc110*), ABISELECT(16,8), "dd1110");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1110.d");
    test_class_info(&lv, &cd_dd1110);
    dp->~dd1110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1110(Test_dd1110, "dd1110", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd1110C1Ev();
extern void _ZN6dd1110D1Ev();
Name_Map name_map_dd1110[] = {
  NSPAIR(_ZN6dd1110C1Ev),
  NSPAIR(_ZN6dd1110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd1110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1110[];
static  VTBL_ENTRY vtc_dd1110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
extern VTBL_ENTRY _ZTV6dd1110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd1110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd1110[] = {
  {&(_ZTV6dd1110[5]),  5,12},
  {&(_ZTV6dd1110[9]),  9,12},
  {&(_ZTV6dd1110[12]),  12,12},
  {&(_tg__ZTV5cc110__6dd1110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd1110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd1110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
Class_Descriptor cd_dd1110 = {  "dd1110", // class name
  bases_dd1110, 3,
  &(vtc_dd1110[0]), // expected_vtbl_contents
  &(vtt_dd1110[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd1110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1110),12, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1110),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01110  : dd1110 {
  int e;
  ~ee01110(); // tgen
  ee01110(); // tgen
};
//SIG(1 ee01110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee01110 ::~ee01110(){ note_dtor("ee01110", this);} // tgen
ee01110 ::ee01110(){ note_ctor("ee01110", this);} // tgen

static void Test_ee01110()
{
  extern Class_Descriptor cd_ee01110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee01110, buf);
    ee01110 *dp, &lv = *(dp=new (buf) ee01110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee01110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee01110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee01110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(16,12), "ee01110");
    check_base_class_offset(lv, (dd1110*), 0, "ee01110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01110.e");
    test_class_info(&lv, &cd_ee01110);
    dp->~ee01110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01110(Test_ee01110, "ee01110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee01110C1Ev();
extern void _ZN7ee01110D1Ev();
Name_Map name_map_ee01110[] = {
  NSPAIR(_ZN7ee01110C1Ev),
  NSPAIR(_ZN7ee01110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee01110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01110[];
static  VTBL_ENTRY vtc_ee01110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01110[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee01110[0]),
};
extern VTBL_ENTRY _ZTV7ee01110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee01110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee01110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee01110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee01110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee01110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee01110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee01110[] = {
  {&(_ZTV7ee01110[5]),  5,12},
  {&(_tg__ZTV6dd1110__7ee01110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee01110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee01110[3]),  3,3},
  {&(_ZTV7ee01110[9]),  9,12},
  {&(_ZTV7ee01110[12]),  12,12},
  {&(_tg__ZTV5cc110__7ee01110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee01110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee01110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee01110[];
extern  VTBL_ENTRY _ZTV7ee01110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01110[];
Class_Descriptor cd_ee01110 = {  "ee01110", // class name
  bases_ee01110, 4,
  &(vtc_ee01110[0]), // expected_vtbl_contents
  &(vtt_ee01110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee01110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01110),12, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11110  : virtual dd1110 {
  int e;
  ~ee11110(); // tgen
  ee11110(); // tgen
};
//SIG(1 ee11110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} Fi}


ee11110 ::~ee11110(){ note_dtor("ee11110", this);} // tgen
ee11110 ::ee11110(){ note_ctor("ee11110", this);} // tgen

static void Test_ee11110()
{
  extern Class_Descriptor cd_ee11110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee11110, buf);
    ee11110 *dp, &lv = *(dp=new (buf) ee11110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee11110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee11110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee11110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(32,16), "ee11110");
    check_base_class_offset(lv, (dd1110*), ABISELECT(16,8), "ee11110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11110.e");
    test_class_info(&lv, &cd_ee11110);
    dp->~ee11110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11110(Test_ee11110, "ee11110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee11110C1Ev();
extern void _ZN7ee11110D1Ev();
Name_Map name_map_ee11110[] = {
  NSPAIR(_ZN7ee11110C1Ev),
  NSPAIR(_ZN7ee11110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee11110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11110[];
static  VTBL_ENTRY vtc_ee11110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11110[0]),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11110[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee11110[0]),
};
extern VTBL_ENTRY _ZTV7ee11110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee11110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee11110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee11110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee11110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee11110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee11110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee11110[] = {
  {&(_ZTV7ee11110[6]),  6,18},
  {&(_ZTV7ee11110[11]),  11,18},
  {&(_ZTV7ee11110[15]),  15,18},
  {&(_ZTV7ee11110[18]),  18,18},
  {&(_tg__ZTV6dd1110__7ee11110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee11110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee11110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee11110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee11110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee11110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee11110[];
extern  VTBL_ENTRY _ZTV7ee11110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11110[];
Class_Descriptor cd_ee11110 = {  "ee11110", // class name
  bases_ee11110, 4,
  &(vtc_ee11110[0]), // expected_vtbl_contents
  &(vtt_ee11110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee11110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11110),18, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21110  : dd1110 {
  int e;
  virtual void  foo(); // _ZN7ee211103fooEv
  ~ee21110(); // tgen
  ee21110(); // tgen
};
//SIG(1 ee21110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee21110 ::foo(){vfunc_called(this, "_ZN7ee211103fooEv");}
ee21110 ::~ee21110(){ note_dtor("ee21110", this);} // tgen
ee21110 ::ee21110(){ note_ctor("ee21110", this);} // tgen

static void Test_ee21110()
{
  extern Class_Descriptor cd_ee21110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee21110, buf);
    ee21110 *dp, &lv = *(dp=new (buf) ee21110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee21110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee21110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee21110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(16,12), "ee21110");
    check_base_class_offset(lv, (dd1110*), 0, "ee21110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21110.e");
    test_class_info(&lv, &cd_ee21110);
    dp->~ee21110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21110(Test_ee21110, "ee21110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee21110C1Ev();
extern void _ZN7ee21110D1Ev();
Name_Map name_map_ee21110[] = {
  NSPAIR(_ZN7ee21110C1Ev),
  NSPAIR(_ZN7ee21110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee21110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21110[];
extern void _ZN7ee211103fooEv();
static  VTBL_ENTRY vtc_ee21110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21110[0]),
  (VTBL_ENTRY)&_ZN7ee211103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee21110[0]),
};
extern VTBL_ENTRY _ZTV7ee21110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee21110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee21110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee21110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee21110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee21110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee21110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee21110[] = {
  {&(_ZTV7ee21110[5]),  5,13},
  {&(_tg__ZTV6dd1110__7ee21110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee21110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee21110[3]),  3,3},
  {&(_ZTV7ee21110[10]),  10,13},
  {&(_ZTV7ee21110[13]),  13,13},
  {&(_tg__ZTV5cc110__7ee21110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee21110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee21110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee21110[];
extern  VTBL_ENTRY _ZTV7ee21110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21110[];
Class_Descriptor cd_ee21110 = {  "ee21110", // class name
  bases_ee21110, 4,
  &(vtc_ee21110[0]), // expected_vtbl_contents
  &(vtt_ee21110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee21110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31110  : virtual dd1110 {
  int e;
  virtual void  foo(); // _ZN7ee311103fooEv
  ~ee31110(); // tgen
  ee31110(); // tgen
};
//SIG(1 ee31110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee31110 ::foo(){vfunc_called(this, "_ZN7ee311103fooEv");}
ee31110 ::~ee31110(){ note_dtor("ee31110", this);} // tgen
ee31110 ::ee31110(){ note_ctor("ee31110", this);} // tgen

static void Test_ee31110()
{
  extern Class_Descriptor cd_ee31110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee31110, buf);
    ee31110 *dp, &lv = *(dp=new (buf) ee31110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee31110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee31110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee31110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(32,16), "ee31110");
    check_base_class_offset(lv, (dd1110*), ABISELECT(16,8), "ee31110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31110.e");
    test_class_info(&lv, &cd_ee31110);
    dp->~ee31110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31110(Test_ee31110, "ee31110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee31110C1Ev();
extern void _ZN7ee31110D1Ev();
Name_Map name_map_ee31110[] = {
  NSPAIR(_ZN7ee31110C1Ev),
  NSPAIR(_ZN7ee31110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee31110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31110[];
extern void _ZN7ee311103fooEv();
static  VTBL_ENTRY vtc_ee31110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31110[0]),
  (VTBL_ENTRY)&_ZN7ee311103fooEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31110[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee31110[0]),
};
extern VTBL_ENTRY _ZTV7ee31110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee31110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee31110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee31110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee31110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee31110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee31110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee31110[] = {
  {&(_ZTV7ee31110[6]),  6,19},
  {&(_ZTV7ee31110[12]),  12,19},
  {&(_ZTV7ee31110[16]),  16,19},
  {&(_ZTV7ee31110[19]),  19,19},
  {&(_tg__ZTV6dd1110__7ee31110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee31110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee31110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee31110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee31110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee31110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee31110[];
extern  VTBL_ENTRY _ZTV7ee31110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31110[];
Class_Descriptor cd_ee31110 = {  "ee31110", // class name
  bases_ee31110, 4,
  &(vtc_ee31110[0]), // expected_vtbl_contents
  &(vtt_ee31110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee31110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31110),19, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41110  : dd1110 {
  int e;
  virtual void  bar(); // _ZN7ee411103barEv
  ~ee41110(); // tgen
  ee41110(); // tgen
};
//SIG(1 ee41110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee41110 ::bar(){vfunc_called(this, "_ZN7ee411103barEv");}
ee41110 ::~ee41110(){ note_dtor("ee41110", this);} // tgen
ee41110 ::ee41110(){ note_ctor("ee41110", this);} // tgen

static void Test_ee41110()
{
  extern Class_Descriptor cd_ee41110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee41110, buf);
    ee41110 *dp, &lv = *(dp=new (buf) ee41110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee41110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee41110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee41110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(16,12), "ee41110");
    check_base_class_offset(lv, (dd1110*), 0, "ee41110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41110.e");
    test_class_info(&lv, &cd_ee41110);
    dp->~ee41110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41110(Test_ee41110, "ee41110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee41110C1Ev();
extern void _ZN7ee41110D1Ev();
Name_Map name_map_ee41110[] = {
  NSPAIR(_ZN7ee41110C1Ev),
  NSPAIR(_ZN7ee41110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee41110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41110[];
extern void _ZN7ee411103barEv();
static  VTBL_ENTRY vtc_ee41110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41110[0]),
  (VTBL_ENTRY)&_ZN7ee411103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee41110[0]),
};
extern VTBL_ENTRY _ZTV7ee41110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee41110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee41110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee41110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee41110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee41110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee41110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee41110[] = {
  {&(_ZTV7ee41110[5]),  5,13},
  {&(_tg__ZTV6dd1110__7ee41110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee41110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee41110[3]),  3,3},
  {&(_ZTV7ee41110[10]),  10,13},
  {&(_ZTV7ee41110[13]),  13,13},
  {&(_tg__ZTV5cc110__7ee41110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee41110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee41110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee41110[];
extern  VTBL_ENTRY _ZTV7ee41110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41110[];
Class_Descriptor cd_ee41110 = {  "ee41110", // class name
  bases_ee41110, 4,
  &(vtc_ee41110[0]), // expected_vtbl_contents
  &(vtt_ee41110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee41110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51110  : virtual dd1110 {
  int e;
  virtual void  bar(); // _ZN7ee511103barEv
  ~ee51110(); // tgen
  ee51110(); // tgen
};
//SIG(1 ee51110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee51110 ::bar(){vfunc_called(this, "_ZN7ee511103barEv");}
ee51110 ::~ee51110(){ note_dtor("ee51110", this);} // tgen
ee51110 ::ee51110(){ note_ctor("ee51110", this);} // tgen

static void Test_ee51110()
{
  extern Class_Descriptor cd_ee51110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee51110, buf);
    ee51110 *dp, &lv = *(dp=new (buf) ee51110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee51110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee51110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee51110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(32,16), "ee51110");
    check_base_class_offset(lv, (dd1110*), ABISELECT(16,8), "ee51110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51110.e");
    test_class_info(&lv, &cd_ee51110);
    dp->~ee51110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51110(Test_ee51110, "ee51110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee51110C1Ev();
extern void _ZN7ee51110D1Ev();
Name_Map name_map_ee51110[] = {
  NSPAIR(_ZN7ee51110C1Ev),
  NSPAIR(_ZN7ee51110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee51110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51110[];
extern void _ZN7ee511103barEv();
static  VTBL_ENTRY vtc_ee51110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51110[0]),
  (VTBL_ENTRY)&_ZN7ee511103barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51110[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee51110[0]),
};
extern VTBL_ENTRY _ZTV7ee51110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee51110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee51110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee51110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee51110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee51110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee51110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee51110[] = {
  {&(_ZTV7ee51110[6]),  6,19},
  {&(_ZTV7ee51110[12]),  12,19},
  {&(_ZTV7ee51110[16]),  16,19},
  {&(_ZTV7ee51110[19]),  19,19},
  {&(_tg__ZTV6dd1110__7ee51110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee51110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee51110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee51110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee51110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee51110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee51110[];
extern  VTBL_ENTRY _ZTV7ee51110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51110[];
Class_Descriptor cd_ee51110 = {  "ee51110", // class name
  bases_ee51110, 4,
  &(vtc_ee51110[0]), // expected_vtbl_contents
  &(vtt_ee51110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee51110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51110),19, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61110  : dd1110 {
  int e;
  virtual void  foo(); // _ZN7ee611103fooEv
  virtual void  bar(); // _ZN7ee611103barEv
  ~ee61110(); // tgen
  ee61110(); // tgen
};
//SIG(1 ee61110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee61110 ::foo(){vfunc_called(this, "_ZN7ee611103fooEv");}
void  ee61110 ::bar(){vfunc_called(this, "_ZN7ee611103barEv");}
ee61110 ::~ee61110(){ note_dtor("ee61110", this);} // tgen
ee61110 ::ee61110(){ note_ctor("ee61110", this);} // tgen

static void Test_ee61110()
{
  extern Class_Descriptor cd_ee61110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee61110, buf);
    ee61110 *dp, &lv = *(dp=new (buf) ee61110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee61110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee61110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee61110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(16,12), "ee61110");
    check_base_class_offset(lv, (dd1110*), 0, "ee61110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61110.e");
    test_class_info(&lv, &cd_ee61110);
    dp->~ee61110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61110(Test_ee61110, "ee61110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee61110C1Ev();
extern void _ZN7ee61110D1Ev();
Name_Map name_map_ee61110[] = {
  NSPAIR(_ZN7ee61110C1Ev),
  NSPAIR(_ZN7ee61110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee61110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61110[];
extern void _ZN7ee611103fooEv();
extern void _ZN7ee611103barEv();
static  VTBL_ENTRY vtc_ee61110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61110[0]),
  (VTBL_ENTRY)&_ZN7ee611103fooEv,
  (VTBL_ENTRY)&_ZN7ee611103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee61110[0]),
};
extern VTBL_ENTRY _ZTV7ee61110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee61110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee61110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee61110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee61110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee61110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee61110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee61110[] = {
  {&(_ZTV7ee61110[5]),  5,14},
  {&(_tg__ZTV6dd1110__7ee61110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee61110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee61110[3]),  3,3},
  {&(_ZTV7ee61110[11]),  11,14},
  {&(_ZTV7ee61110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee61110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee61110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee61110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee61110[];
extern  VTBL_ENTRY _ZTV7ee61110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61110[];
Class_Descriptor cd_ee61110 = {  "ee61110", // class name
  bases_ee61110, 4,
  &(vtc_ee61110[0]), // expected_vtbl_contents
  &(vtt_ee61110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee61110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71110  : virtual dd1110 {
  int e;
  virtual void  foo(); // _ZN7ee711103fooEv
  virtual void  bar(); // _ZN7ee711103barEv
  ~ee71110(); // tgen
  ee71110(); // tgen
};
//SIG(1 ee71110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee71110 ::foo(){vfunc_called(this, "_ZN7ee711103fooEv");}
void  ee71110 ::bar(){vfunc_called(this, "_ZN7ee711103barEv");}
ee71110 ::~ee71110(){ note_dtor("ee71110", this);} // tgen
ee71110 ::ee71110(){ note_ctor("ee71110", this);} // tgen

static void Test_ee71110()
{
  extern Class_Descriptor cd_ee71110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee71110, buf);
    ee71110 *dp, &lv = *(dp=new (buf) ee71110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee71110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee71110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee71110");
    check_base_class_offset(lv, (cc110*)(dd1110*), ABISELECT(32,16), "ee71110");
    check_base_class_offset(lv, (dd1110*), ABISELECT(16,8), "ee71110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71110.e");
    test_class_info(&lv, &cd_ee71110);
    dp->~ee71110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71110(Test_ee71110, "ee71110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee71110C1Ev();
extern void _ZN7ee71110D1Ev();
Name_Map name_map_ee71110[] = {
  NSPAIR(_ZN7ee71110C1Ev),
  NSPAIR(_ZN7ee71110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd1110;
extern VTBL_ENTRY _ZTI6dd1110[];
extern  VTBL_ENTRY _ZTV6dd1110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1110[];
static Base_Class bases_ee71110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1110,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71110[];
extern void _ZN7ee711103fooEv();
extern void _ZN7ee711103barEv();
static  VTBL_ENTRY vtc_ee71110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71110[0]),
  (VTBL_ENTRY)&_ZN7ee711103fooEv,
  (VTBL_ENTRY)&_ZN7ee711103barEv,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71110[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee71110[0]),
};
extern VTBL_ENTRY _ZTV7ee71110[];
static  VTBL_ENTRY _tg__ZTV6dd1110__7ee71110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd1110__7ee71110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd1110__7ee71110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd1110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee71110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee71110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee71110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee71110[] = {
  {&(_ZTV7ee71110[6]),  6,20},
  {&(_ZTV7ee71110[13]),  13,20},
  {&(_ZTV7ee71110[17]),  17,20},
  {&(_ZTV7ee71110[20]),  20,20},
  {&(_tg__ZTV6dd1110__7ee71110[5]),  5,5},
  {&(_tg__ZTV5cc110__6dd1110__7ee71110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd1110__7ee71110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee71110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee71110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee71110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee71110[];
extern  VTBL_ENTRY _ZTV7ee71110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71110[];
Class_Descriptor cd_ee71110 = {  "ee71110", // class name
  bases_ee71110, 4,
  &(vtc_ee71110[0]), // expected_vtbl_contents
  &(vtt_ee71110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee71110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71110),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2110  : cc110 {
  int d;
  virtual void  foo(); // _ZN6dd21103fooEv
  ~dd2110(); // tgen
  dd2110(); // tgen
};
//SIG(-1 dd2110) C1{ BC2{ VBC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd2110 ::foo(){vfunc_called(this, "_ZN6dd21103fooEv");}
dd2110 ::~dd2110(){ note_dtor("dd2110", this);} // tgen
dd2110 ::dd2110(){ note_ctor("dd2110", this);} // tgen

static void Test_dd2110()
{
  extern Class_Descriptor cd_dd2110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd2110, buf);
    dd2110 *dp, &lv = *(dp=new (buf) dd2110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd2110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(28,20), "dd2110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(16,12), "dd2110");
    check_base_class_offset(lv, (cc110*), 0, "dd2110");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2110.d");
    test_class_info(&lv, &cd_dd2110);
    dp->~dd2110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2110(Test_dd2110, "dd2110", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd2110C1Ev();
extern void _ZN6dd2110D1Ev();
Name_Map name_map_dd2110[] = {
  NSPAIR(_ZN6dd2110C1Ev),
  NSPAIR(_ZN6dd2110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd2110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY vtc_dd2110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
extern VTBL_ENTRY _ZTV6dd2110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd2110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd2110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd2110[] = {
  {&(_ZTV6dd2110[4]),  4,8},
  {&(_tg__ZTV5cc110__6dd2110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd2110[3]),  3,3},
  {&(_ZTV6dd2110[8]),  8,8},
  {&(_tg__ZTV4bb10__6dd2110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
Class_Descriptor cd_dd2110 = {  "dd2110", // class name
  bases_dd2110, 3,
  &(vtc_dd2110[0]), // expected_vtbl_contents
  &(vtt_dd2110[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd2110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2110),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02110  : dd2110 {
  int e;
  ~ee02110(); // tgen
  ee02110(); // tgen
};
//SIG(1 ee02110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee02110 ::~ee02110(){ note_dtor("ee02110", this);} // tgen
ee02110 ::ee02110(){ note_ctor("ee02110", this);} // tgen

static void Test_ee02110()
{
  extern Class_Descriptor cd_ee02110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee02110, buf);
    ee02110 *dp, &lv = *(dp=new (buf) ee02110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee02110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee02110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(24,16), "ee02110");
    check_base_class_offset(lv, (cc110*)(dd2110*), 0, "ee02110");
    check_base_class_offset(lv, (dd2110*), 0, "ee02110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02110.e");
    test_class_info(&lv, &cd_ee02110);
    dp->~ee02110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02110(Test_ee02110, "ee02110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee02110C1Ev();
extern void _ZN7ee02110D1Ev();
Name_Map name_map_ee02110[] = {
  NSPAIR(_ZN7ee02110C1Ev),
  NSPAIR(_ZN7ee02110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee02110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY vtc_ee02110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee02110[0]),
};
extern VTBL_ENTRY _ZTV7ee02110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee02110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee02110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee02110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee02110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee02110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee02110[] = {
  {&(_ZTV7ee02110[4]),  4,8},
  {&(_tg__ZTV6dd2110__7ee02110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee02110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee02110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee02110[3]),  3,3},
  {&(_ZTV7ee02110[8]),  8,8},
  {&(_tg__ZTV4bb10__7ee02110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee02110[];
extern  VTBL_ENTRY _ZTV7ee02110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02110[];
Class_Descriptor cd_ee02110 = {  "ee02110", // class name
  bases_ee02110, 4,
  &(vtc_ee02110[0]), // expected_vtbl_contents
  &(vtt_ee02110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee02110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12110  : virtual dd2110 {
  int e;
  ~ee12110(); // tgen
  ee12110(); // tgen
};
//SIG(1 ee12110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee12110 ::~ee12110(){ note_dtor("ee12110", this);} // tgen
ee12110 ::ee12110(){ note_ctor("ee12110", this);} // tgen

static void Test_ee12110()
{
  extern Class_Descriptor cd_ee12110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee12110, buf);
    ee12110 *dp, &lv = *(dp=new (buf) ee12110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee12110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee12110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(32,20), "ee12110");
    check_base_class_offset(lv, (cc110*)(dd2110*), ABISELECT(16,8), "ee12110");
    check_base_class_offset(lv, (dd2110*), ABISELECT(16,8), "ee12110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12110.e");
    test_class_info(&lv, &cd_ee12110);
    dp->~ee12110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12110(Test_ee12110, "ee12110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee12110C1Ev();
extern void _ZN7ee12110D1Ev();
Name_Map name_map_ee12110[] = {
  NSPAIR(_ZN7ee12110C1Ev),
  NSPAIR(_ZN7ee12110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee12110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY vtc_ee12110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12110[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee12110[0]),
};
extern VTBL_ENTRY _ZTV7ee12110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee12110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee12110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee12110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee12110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee12110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee12110[] = {
  {&(_ZTV7ee12110[5]),  5,14},
  {&(_ZTV7ee12110[10]),  10,14},
  {&(_ZTV7ee12110[14]),  14,14},
  {&(_tg__ZTV6dd2110__7ee12110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee12110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee12110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee12110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee12110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee12110[];
extern  VTBL_ENTRY _ZTV7ee12110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12110[];
Class_Descriptor cd_ee12110 = {  "ee12110", // class name
  bases_ee12110, 4,
  &(vtc_ee12110[0]), // expected_vtbl_contents
  &(vtt_ee12110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee12110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22110  : dd2110 {
  int e;
  virtual void  foo(); // _ZN7ee221103fooEv
  ~ee22110(); // tgen
  ee22110(); // tgen
};
//SIG(1 ee22110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee22110 ::foo(){vfunc_called(this, "_ZN7ee221103fooEv");}
ee22110 ::~ee22110(){ note_dtor("ee22110", this);} // tgen
ee22110 ::ee22110(){ note_ctor("ee22110", this);} // tgen

static void Test_ee22110()
{
  extern Class_Descriptor cd_ee22110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee22110, buf);
    ee22110 *dp, &lv = *(dp=new (buf) ee22110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee22110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee22110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(24,16), "ee22110");
    check_base_class_offset(lv, (cc110*)(dd2110*), 0, "ee22110");
    check_base_class_offset(lv, (dd2110*), 0, "ee22110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22110.e");
    test_class_info(&lv, &cd_ee22110);
    dp->~ee22110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22110(Test_ee22110, "ee22110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee22110C1Ev();
extern void _ZN7ee22110D1Ev();
Name_Map name_map_ee22110[] = {
  NSPAIR(_ZN7ee22110C1Ev),
  NSPAIR(_ZN7ee22110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee22110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22110[];
extern void _ZN7ee221103fooEv();
static  VTBL_ENTRY vtc_ee22110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22110[0]),
  (VTBL_ENTRY)&_ZN7ee221103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee22110[0]),
};
extern VTBL_ENTRY _ZTV7ee22110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee22110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee22110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee22110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee22110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee22110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee22110[] = {
  {&(_ZTV7ee22110[4]),  4,8},
  {&(_tg__ZTV6dd2110__7ee22110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee22110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee22110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee22110[3]),  3,3},
  {&(_ZTV7ee22110[8]),  8,8},
  {&(_tg__ZTV4bb10__7ee22110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee22110[];
extern  VTBL_ENTRY _ZTV7ee22110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22110[];
Class_Descriptor cd_ee22110 = {  "ee22110", // class name
  bases_ee22110, 4,
  &(vtc_ee22110[0]), // expected_vtbl_contents
  &(vtt_ee22110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee22110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32110  : virtual dd2110 {
  int e;
  virtual void  foo(); // _ZN7ee321103fooEv
  ~ee32110(); // tgen
  ee32110(); // tgen
};
//SIG(1 ee32110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee32110 ::foo(){vfunc_called(this, "_ZN7ee321103fooEv");}
ee32110 ::~ee32110(){ note_dtor("ee32110", this);} // tgen
ee32110 ::ee32110(){ note_ctor("ee32110", this);} // tgen

static void Test_ee32110()
{
  extern Class_Descriptor cd_ee32110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee32110, buf);
    ee32110 *dp, &lv = *(dp=new (buf) ee32110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee32110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee32110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(32,20), "ee32110");
    check_base_class_offset(lv, (cc110*)(dd2110*), ABISELECT(16,8), "ee32110");
    check_base_class_offset(lv, (dd2110*), ABISELECT(16,8), "ee32110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32110.e");
    test_class_info(&lv, &cd_ee32110);
    dp->~ee32110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32110(Test_ee32110, "ee32110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee32110C1Ev();
extern void _ZN7ee32110D1Ev();
Name_Map name_map_ee32110[] = {
  NSPAIR(_ZN7ee32110C1Ev),
  NSPAIR(_ZN7ee32110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee32110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32110[];
extern void _ZN7ee321103fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee321103fooEv,_ZTv0_n20_N7ee321103fooEv)();
extern void ABISELECT(_ZThn16_N7ee321103fooEv,_ZThn8_N7ee321103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32110[0]),
  (VTBL_ENTRY)&_ZN7ee321103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee321103fooEv,_ZTv0_n20_N7ee321103fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee32110[0]),
};
extern VTBL_ENTRY _ZTV7ee32110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee32110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee32110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee32110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee32110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee32110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee32110[] = {
  {&(_ZTV7ee32110[5]),  5,15},
  {&(_ZTV7ee32110[11]),  11,15},
  {&(_ZTV7ee32110[15]),  15,15},
  {&(_tg__ZTV6dd2110__7ee32110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee32110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee32110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee32110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee32110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee32110[];
extern  VTBL_ENTRY _ZTV7ee32110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32110[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee321103fooEv,_ZTv0_n20_N7ee321103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321103fooEv,_ZThn8_N7ee321103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32110 = {  "ee32110", // class name
  bases_ee32110, 4,
  &(vtc_ee32110[0]), // expected_vtbl_contents
  &(vtt_ee32110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee32110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32110),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42110  : dd2110 {
  int e;
  virtual void  bar(); // _ZN7ee421103barEv
  ~ee42110(); // tgen
  ee42110(); // tgen
};
//SIG(1 ee42110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee42110 ::bar(){vfunc_called(this, "_ZN7ee421103barEv");}
ee42110 ::~ee42110(){ note_dtor("ee42110", this);} // tgen
ee42110 ::ee42110(){ note_ctor("ee42110", this);} // tgen

static void Test_ee42110()
{
  extern Class_Descriptor cd_ee42110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee42110, buf);
    ee42110 *dp, &lv = *(dp=new (buf) ee42110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee42110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee42110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(24,16), "ee42110");
    check_base_class_offset(lv, (cc110*)(dd2110*), 0, "ee42110");
    check_base_class_offset(lv, (dd2110*), 0, "ee42110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42110.e");
    test_class_info(&lv, &cd_ee42110);
    dp->~ee42110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42110(Test_ee42110, "ee42110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee42110C1Ev();
extern void _ZN7ee42110D1Ev();
Name_Map name_map_ee42110[] = {
  NSPAIR(_ZN7ee42110C1Ev),
  NSPAIR(_ZN7ee42110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee42110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42110[];
extern void _ZN6dd21103fooEv();
extern void _ZN7ee421103barEv();
static  VTBL_ENTRY vtc_ee42110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
  (VTBL_ENTRY)&_ZN7ee421103barEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee42110[0]),
};
extern VTBL_ENTRY _ZTV7ee42110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee42110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee42110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee42110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee42110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee42110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee42110[] = {
  {&(_ZTV7ee42110[4]),  4,9},
  {&(_tg__ZTV6dd2110__7ee42110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee42110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee42110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee42110[3]),  3,3},
  {&(_ZTV7ee42110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee42110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee42110[];
extern  VTBL_ENTRY _ZTV7ee42110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42110[];
Class_Descriptor cd_ee42110 = {  "ee42110", // class name
  bases_ee42110, 4,
  &(vtc_ee42110[0]), // expected_vtbl_contents
  &(vtt_ee42110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee42110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52110  : virtual dd2110 {
  int e;
  virtual void  bar(); // _ZN7ee521103barEv
  ~ee52110(); // tgen
  ee52110(); // tgen
};
//SIG(1 ee52110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee52110 ::bar(){vfunc_called(this, "_ZN7ee521103barEv");}
ee52110 ::~ee52110(){ note_dtor("ee52110", this);} // tgen
ee52110 ::ee52110(){ note_ctor("ee52110", this);} // tgen

static void Test_ee52110()
{
  extern Class_Descriptor cd_ee52110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee52110, buf);
    ee52110 *dp, &lv = *(dp=new (buf) ee52110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee52110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee52110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(32,20), "ee52110");
    check_base_class_offset(lv, (cc110*)(dd2110*), ABISELECT(16,8), "ee52110");
    check_base_class_offset(lv, (dd2110*), ABISELECT(16,8), "ee52110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52110.e");
    test_class_info(&lv, &cd_ee52110);
    dp->~ee52110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52110(Test_ee52110, "ee52110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee52110C1Ev();
extern void _ZN7ee52110D1Ev();
Name_Map name_map_ee52110[] = {
  NSPAIR(_ZN7ee52110C1Ev),
  NSPAIR(_ZN7ee52110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee52110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52110[];
extern void _ZN7ee521103barEv();
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY vtc_ee52110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52110[0]),
  (VTBL_ENTRY)&_ZN7ee521103barEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee52110[0]),
};
extern VTBL_ENTRY _ZTV7ee52110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee52110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee52110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee52110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee52110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee52110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee52110[] = {
  {&(_ZTV7ee52110[5]),  5,15},
  {&(_ZTV7ee52110[11]),  11,15},
  {&(_ZTV7ee52110[15]),  15,15},
  {&(_tg__ZTV6dd2110__7ee52110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee52110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee52110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee52110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee52110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee52110[];
extern  VTBL_ENTRY _ZTV7ee52110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52110[];
Class_Descriptor cd_ee52110 = {  "ee52110", // class name
  bases_ee52110, 4,
  &(vtc_ee52110[0]), // expected_vtbl_contents
  &(vtt_ee52110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee52110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52110),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62110  : dd2110 {
  int e;
  virtual void  foo(); // _ZN7ee621103fooEv
  virtual void  bar(); // _ZN7ee621103barEv
  ~ee62110(); // tgen
  ee62110(); // tgen
};
//SIG(1 ee62110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62110 ::foo(){vfunc_called(this, "_ZN7ee621103fooEv");}
void  ee62110 ::bar(){vfunc_called(this, "_ZN7ee621103barEv");}
ee62110 ::~ee62110(){ note_dtor("ee62110", this);} // tgen
ee62110 ::ee62110(){ note_ctor("ee62110", this);} // tgen

static void Test_ee62110()
{
  extern Class_Descriptor cd_ee62110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee62110, buf);
    ee62110 *dp, &lv = *(dp=new (buf) ee62110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee62110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee62110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(24,16), "ee62110");
    check_base_class_offset(lv, (cc110*)(dd2110*), 0, "ee62110");
    check_base_class_offset(lv, (dd2110*), 0, "ee62110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62110.e");
    test_class_info(&lv, &cd_ee62110);
    dp->~ee62110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62110(Test_ee62110, "ee62110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee62110C1Ev();
extern void _ZN7ee62110D1Ev();
Name_Map name_map_ee62110[] = {
  NSPAIR(_ZN7ee62110C1Ev),
  NSPAIR(_ZN7ee62110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee62110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62110[];
extern void _ZN7ee621103fooEv();
extern void _ZN7ee621103barEv();
static  VTBL_ENTRY vtc_ee62110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62110[0]),
  (VTBL_ENTRY)&_ZN7ee621103fooEv,
  (VTBL_ENTRY)&_ZN7ee621103barEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee62110[0]),
};
extern VTBL_ENTRY _ZTV7ee62110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee62110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee62110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee62110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee62110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee62110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee62110[] = {
  {&(_ZTV7ee62110[4]),  4,9},
  {&(_tg__ZTV6dd2110__7ee62110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee62110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee62110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee62110[3]),  3,3},
  {&(_ZTV7ee62110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee62110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee62110[];
extern  VTBL_ENTRY _ZTV7ee62110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62110[];
Class_Descriptor cd_ee62110 = {  "ee62110", // class name
  bases_ee62110, 4,
  &(vtc_ee62110[0]), // expected_vtbl_contents
  &(vtt_ee62110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee62110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72110  : virtual dd2110 {
  int e;
  virtual void  foo(); // _ZN7ee721103fooEv
  virtual void  bar(); // _ZN7ee721103barEv
  ~ee72110(); // tgen
  ee72110(); // tgen
};
//SIG(1 ee72110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72110 ::foo(){vfunc_called(this, "_ZN7ee721103fooEv");}
void  ee72110 ::bar(){vfunc_called(this, "_ZN7ee721103barEv");}
ee72110 ::~ee72110(){ note_dtor("ee72110", this);} // tgen
ee72110 ::ee72110(){ note_ctor("ee72110", this);} // tgen

static void Test_ee72110()
{
  extern Class_Descriptor cd_ee72110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee72110, buf);
    ee72110 *dp, &lv = *(dp=new (buf) ee72110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee72110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee72110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd2110*), ABISELECT(32,20), "ee72110");
    check_base_class_offset(lv, (cc110*)(dd2110*), ABISELECT(16,8), "ee72110");
    check_base_class_offset(lv, (dd2110*), ABISELECT(16,8), "ee72110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72110.e");
    test_class_info(&lv, &cd_ee72110);
    dp->~ee72110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72110(Test_ee72110, "ee72110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee72110C1Ev();
extern void _ZN7ee72110D1Ev();
Name_Map name_map_ee72110[] = {
  NSPAIR(_ZN7ee72110C1Ev),
  NSPAIR(_ZN7ee72110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd2110;
extern VTBL_ENTRY _ZTI6dd2110[];
extern  VTBL_ENTRY _ZTV6dd2110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2110[];
static Base_Class bases_ee72110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72110[];
extern void _ZN7ee721103fooEv();
extern void _ZN7ee721103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee721103fooEv,_ZTv0_n20_N7ee721103fooEv)();
extern void ABISELECT(_ZThn16_N7ee721103fooEv,_ZThn8_N7ee721103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72110[0]),
  (VTBL_ENTRY)&_ZN7ee721103fooEv,
  (VTBL_ENTRY)&_ZN7ee721103barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee721103fooEv,_ZTv0_n20_N7ee721103fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee72110[0]),
};
extern VTBL_ENTRY _ZTV7ee72110[];
extern void _ZN6dd21103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2110__7ee72110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
  (VTBL_ENTRY)&_ZN6dd21103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd2110__7ee72110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd2110__7ee72110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd2110__7ee72110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd2110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee72110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee72110[] = {
  {&(_ZTV7ee72110[5]),  5,16},
  {&(_ZTV7ee72110[12]),  12,16},
  {&(_ZTV7ee72110[16]),  16,16},
  {&(_tg__ZTV6dd2110__7ee72110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd2110__7ee72110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd2110__7ee72110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd2110__7ee72110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee72110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee72110[];
extern  VTBL_ENTRY _ZTV7ee72110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72110[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee721103fooEv,_ZTv0_n20_N7ee721103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721103fooEv,_ZThn8_N7ee721103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72110 = {  "ee72110", // class name
  bases_ee72110, 4,
  &(vtc_ee72110[0]), // expected_vtbl_contents
  &(vtt_ee72110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee72110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72110),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3110  : virtual cc110 {
  int d;
  virtual void  foo(); // _ZN6dd31103fooEv
  ~dd3110(); // tgen
  dd3110(); // tgen
};
//SIG(-1 dd3110) C1{ VBC2{ VBC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd3110 ::foo(){vfunc_called(this, "_ZN6dd31103fooEv");}
dd3110 ::~dd3110(){ note_dtor("dd3110", this);} // tgen
dd3110 ::dd3110(){ note_ctor("dd3110", this);} // tgen

static void Test_dd3110()
{
  extern Class_Descriptor cd_dd3110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd3110, buf);
    dd3110 *dp, &lv = *(dp=new (buf) dd3110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd3110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,24), "dd3110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,16), "dd3110");
    check_base_class_offset(lv, (cc110*), ABISELECT(16,8), "dd3110");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3110.d");
    test_class_info(&lv, &cd_dd3110);
    dp->~dd3110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3110(Test_dd3110, "dd3110", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd3110C1Ev();
extern void _ZN6dd3110D1Ev();
Name_Map name_map_dd3110[] = {
  NSPAIR(_ZN6dd3110C1Ev),
  NSPAIR(_ZN6dd3110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd3110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY vtc_dd3110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
extern VTBL_ENTRY _ZTV6dd3110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd3110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd3110[] = {
  {&(_ZTV6dd3110[5]),  5,13},
  {&(_ZTV6dd3110[10]),  10,13},
  {&(_ZTV6dd3110[13]),  13,13},
  {&(_tg__ZTV5cc110__6dd3110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd3110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd3110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
Class_Descriptor cd_dd3110 = {  "dd3110", // class name
  bases_dd3110, 3,
  &(vtc_dd3110[0]), // expected_vtbl_contents
  &(vtt_dd3110[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd3110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3110),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03110  : dd3110 {
  int e;
  ~ee03110(); // tgen
  ee03110(); // tgen
};
//SIG(1 ee03110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee03110 ::~ee03110(){ note_dtor("ee03110", this);} // tgen
ee03110 ::ee03110(){ note_ctor("ee03110", this);} // tgen

static void Test_ee03110()
{
  extern Class_Descriptor cd_ee03110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee03110, buf);
    ee03110 *dp, &lv = *(dp=new (buf) ee03110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee03110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee03110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee03110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(16,12), "ee03110");
    check_base_class_offset(lv, (dd3110*), 0, "ee03110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03110.e");
    test_class_info(&lv, &cd_ee03110);
    dp->~ee03110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03110(Test_ee03110, "ee03110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee03110C1Ev();
extern void _ZN7ee03110D1Ev();
Name_Map name_map_ee03110[] = {
  NSPAIR(_ZN7ee03110C1Ev),
  NSPAIR(_ZN7ee03110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee03110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY vtc_ee03110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee03110[0]),
};
extern VTBL_ENTRY _ZTV7ee03110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee03110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee03110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee03110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee03110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee03110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee03110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee03110[] = {
  {&(_ZTV7ee03110[5]),  5,13},
  {&(_tg__ZTV6dd3110__7ee03110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee03110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee03110[3]),  3,3},
  {&(_ZTV7ee03110[10]),  10,13},
  {&(_ZTV7ee03110[13]),  13,13},
  {&(_tg__ZTV5cc110__7ee03110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee03110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee03110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee03110[];
extern  VTBL_ENTRY _ZTV7ee03110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03110[];
Class_Descriptor cd_ee03110 = {  "ee03110", // class name
  bases_ee03110, 4,
  &(vtc_ee03110[0]), // expected_vtbl_contents
  &(vtt_ee03110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee03110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13110  : virtual dd3110 {
  int e;
  ~ee13110(); // tgen
  ee13110(); // tgen
};
//SIG(1 ee13110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee13110 ::~ee13110(){ note_dtor("ee13110", this);} // tgen
ee13110 ::ee13110(){ note_ctor("ee13110", this);} // tgen

static void Test_ee13110()
{
  extern Class_Descriptor cd_ee13110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee13110, buf);
    ee13110 *dp, &lv = *(dp=new (buf) ee13110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee13110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee13110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee13110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(32,16), "ee13110");
    check_base_class_offset(lv, (dd3110*), ABISELECT(16,8), "ee13110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13110.e");
    test_class_info(&lv, &cd_ee13110);
    dp->~ee13110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13110(Test_ee13110, "ee13110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee13110C1Ev();
extern void _ZN7ee13110D1Ev();
Name_Map name_map_ee13110[] = {
  NSPAIR(_ZN7ee13110C1Ev),
  NSPAIR(_ZN7ee13110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee13110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY vtc_ee13110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13110[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee13110[0]),
};
extern VTBL_ENTRY _ZTV7ee13110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee13110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee13110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee13110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee13110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee13110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee13110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee13110[] = {
  {&(_ZTV7ee13110[6]),  6,20},
  {&(_ZTV7ee13110[12]),  12,20},
  {&(_ZTV7ee13110[17]),  17,20},
  {&(_ZTV7ee13110[20]),  20,20},
  {&(_tg__ZTV6dd3110__7ee13110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee13110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee13110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee13110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee13110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee13110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee13110[];
extern  VTBL_ENTRY _ZTV7ee13110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13110[];
Class_Descriptor cd_ee13110 = {  "ee13110", // class name
  bases_ee13110, 4,
  &(vtc_ee13110[0]), // expected_vtbl_contents
  &(vtt_ee13110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee13110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13110),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23110  : dd3110 {
  int e;
  virtual void  foo(); // _ZN7ee231103fooEv
  ~ee23110(); // tgen
  ee23110(); // tgen
};
//SIG(1 ee23110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee23110 ::foo(){vfunc_called(this, "_ZN7ee231103fooEv");}
ee23110 ::~ee23110(){ note_dtor("ee23110", this);} // tgen
ee23110 ::ee23110(){ note_ctor("ee23110", this);} // tgen

static void Test_ee23110()
{
  extern Class_Descriptor cd_ee23110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee23110, buf);
    ee23110 *dp, &lv = *(dp=new (buf) ee23110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee23110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee23110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee23110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(16,12), "ee23110");
    check_base_class_offset(lv, (dd3110*), 0, "ee23110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23110.e");
    test_class_info(&lv, &cd_ee23110);
    dp->~ee23110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23110(Test_ee23110, "ee23110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee23110C1Ev();
extern void _ZN7ee23110D1Ev();
Name_Map name_map_ee23110[] = {
  NSPAIR(_ZN7ee23110C1Ev),
  NSPAIR(_ZN7ee23110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee23110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23110[];
extern void _ZN7ee231103fooEv();
static  VTBL_ENTRY vtc_ee23110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23110[0]),
  (VTBL_ENTRY)&_ZN7ee231103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee23110[0]),
};
extern VTBL_ENTRY _ZTV7ee23110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee23110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee23110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee23110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee23110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee23110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee23110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee23110[] = {
  {&(_ZTV7ee23110[5]),  5,13},
  {&(_tg__ZTV6dd3110__7ee23110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee23110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee23110[3]),  3,3},
  {&(_ZTV7ee23110[10]),  10,13},
  {&(_ZTV7ee23110[13]),  13,13},
  {&(_tg__ZTV5cc110__7ee23110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee23110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee23110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee23110[];
extern  VTBL_ENTRY _ZTV7ee23110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23110[];
Class_Descriptor cd_ee23110 = {  "ee23110", // class name
  bases_ee23110, 4,
  &(vtc_ee23110[0]), // expected_vtbl_contents
  &(vtt_ee23110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee23110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33110  : virtual dd3110 {
  int e;
  virtual void  foo(); // _ZN7ee331103fooEv
  ~ee33110(); // tgen
  ee33110(); // tgen
};
//SIG(1 ee33110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee33110 ::foo(){vfunc_called(this, "_ZN7ee331103fooEv");}
ee33110 ::~ee33110(){ note_dtor("ee33110", this);} // tgen
ee33110 ::ee33110(){ note_ctor("ee33110", this);} // tgen

static void Test_ee33110()
{
  extern Class_Descriptor cd_ee33110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee33110, buf);
    ee33110 *dp, &lv = *(dp=new (buf) ee33110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee33110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee33110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee33110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(32,16), "ee33110");
    check_base_class_offset(lv, (dd3110*), ABISELECT(16,8), "ee33110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33110.e");
    test_class_info(&lv, &cd_ee33110);
    dp->~ee33110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33110(Test_ee33110, "ee33110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee33110C1Ev();
extern void _ZN7ee33110D1Ev();
Name_Map name_map_ee33110[] = {
  NSPAIR(_ZN7ee33110C1Ev),
  NSPAIR(_ZN7ee33110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee33110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33110[];
extern void _ZN7ee331103fooEv();
extern void ABISELECT(_ZTv0_n48_N7ee331103fooEv,_ZTv0_n24_N7ee331103fooEv)();
extern void ABISELECT(_ZThn16_N7ee331103fooEv,_ZThn8_N7ee331103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33110[0]),
  (VTBL_ENTRY)&_ZN7ee331103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee331103fooEv,_ZTv0_n24_N7ee331103fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee33110[0]),
};
extern VTBL_ENTRY _ZTV7ee33110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee33110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee33110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee33110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee33110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee33110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee33110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee33110[] = {
  {&(_ZTV7ee33110[6]),  6,21},
  {&(_ZTV7ee33110[13]),  13,21},
  {&(_ZTV7ee33110[18]),  18,21},
  {&(_ZTV7ee33110[21]),  21,21},
  {&(_tg__ZTV6dd3110__7ee33110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee33110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee33110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee33110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee33110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee33110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee33110[];
extern  VTBL_ENTRY _ZTV7ee33110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33110[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee331103fooEv,_ZTv0_n24_N7ee331103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331103fooEv,_ZThn8_N7ee331103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33110 = {  "ee33110", // class name
  bases_ee33110, 4,
  &(vtc_ee33110[0]), // expected_vtbl_contents
  &(vtt_ee33110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee33110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33110),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43110  : dd3110 {
  int e;
  virtual void  bar(); // _ZN7ee431103barEv
  ~ee43110(); // tgen
  ee43110(); // tgen
};
//SIG(1 ee43110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee43110 ::bar(){vfunc_called(this, "_ZN7ee431103barEv");}
ee43110 ::~ee43110(){ note_dtor("ee43110", this);} // tgen
ee43110 ::ee43110(){ note_ctor("ee43110", this);} // tgen

static void Test_ee43110()
{
  extern Class_Descriptor cd_ee43110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee43110, buf);
    ee43110 *dp, &lv = *(dp=new (buf) ee43110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee43110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee43110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee43110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(16,12), "ee43110");
    check_base_class_offset(lv, (dd3110*), 0, "ee43110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43110.e");
    test_class_info(&lv, &cd_ee43110);
    dp->~ee43110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43110(Test_ee43110, "ee43110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee43110C1Ev();
extern void _ZN7ee43110D1Ev();
Name_Map name_map_ee43110[] = {
  NSPAIR(_ZN7ee43110C1Ev),
  NSPAIR(_ZN7ee43110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee43110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43110[];
extern void _ZN6dd31103fooEv();
extern void _ZN7ee431103barEv();
static  VTBL_ENTRY vtc_ee43110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
  (VTBL_ENTRY)&_ZN7ee431103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee43110[0]),
};
extern VTBL_ENTRY _ZTV7ee43110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee43110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee43110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee43110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee43110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee43110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee43110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee43110[] = {
  {&(_ZTV7ee43110[5]),  5,14},
  {&(_tg__ZTV6dd3110__7ee43110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee43110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee43110[3]),  3,3},
  {&(_ZTV7ee43110[11]),  11,14},
  {&(_ZTV7ee43110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee43110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee43110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee43110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee43110[];
extern  VTBL_ENTRY _ZTV7ee43110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43110[];
Class_Descriptor cd_ee43110 = {  "ee43110", // class name
  bases_ee43110, 4,
  &(vtc_ee43110[0]), // expected_vtbl_contents
  &(vtt_ee43110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee43110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53110  : virtual dd3110 {
  int e;
  virtual void  bar(); // _ZN7ee531103barEv
  ~ee53110(); // tgen
  ee53110(); // tgen
};
//SIG(1 ee53110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee53110 ::bar(){vfunc_called(this, "_ZN7ee531103barEv");}
ee53110 ::~ee53110(){ note_dtor("ee53110", this);} // tgen
ee53110 ::ee53110(){ note_ctor("ee53110", this);} // tgen

static void Test_ee53110()
{
  extern Class_Descriptor cd_ee53110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee53110, buf);
    ee53110 *dp, &lv = *(dp=new (buf) ee53110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee53110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee53110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee53110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(32,16), "ee53110");
    check_base_class_offset(lv, (dd3110*), ABISELECT(16,8), "ee53110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53110.e");
    test_class_info(&lv, &cd_ee53110);
    dp->~ee53110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53110(Test_ee53110, "ee53110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee53110C1Ev();
extern void _ZN7ee53110D1Ev();
Name_Map name_map_ee53110[] = {
  NSPAIR(_ZN7ee53110C1Ev),
  NSPAIR(_ZN7ee53110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee53110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53110[];
extern void _ZN7ee531103barEv();
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY vtc_ee53110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53110[0]),
  (VTBL_ENTRY)&_ZN7ee531103barEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee53110[0]),
};
extern VTBL_ENTRY _ZTV7ee53110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee53110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee53110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee53110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee53110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee53110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee53110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee53110[] = {
  {&(_ZTV7ee53110[6]),  6,21},
  {&(_ZTV7ee53110[13]),  13,21},
  {&(_ZTV7ee53110[18]),  18,21},
  {&(_ZTV7ee53110[21]),  21,21},
  {&(_tg__ZTV6dd3110__7ee53110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee53110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee53110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee53110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee53110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee53110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee53110[];
extern  VTBL_ENTRY _ZTV7ee53110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53110[];
Class_Descriptor cd_ee53110 = {  "ee53110", // class name
  bases_ee53110, 4,
  &(vtc_ee53110[0]), // expected_vtbl_contents
  &(vtt_ee53110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee53110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53110),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63110  : dd3110 {
  int e;
  virtual void  foo(); // _ZN7ee631103fooEv
  virtual void  bar(); // _ZN7ee631103barEv
  ~ee63110(); // tgen
  ee63110(); // tgen
};
//SIG(1 ee63110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63110 ::foo(){vfunc_called(this, "_ZN7ee631103fooEv");}
void  ee63110 ::bar(){vfunc_called(this, "_ZN7ee631103barEv");}
ee63110 ::~ee63110(){ note_dtor("ee63110", this);} // tgen
ee63110 ::ee63110(){ note_ctor("ee63110", this);} // tgen

static void Test_ee63110()
{
  extern Class_Descriptor cd_ee63110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee63110, buf);
    ee63110 *dp, &lv = *(dp=new (buf) ee63110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee63110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee63110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee63110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(16,12), "ee63110");
    check_base_class_offset(lv, (dd3110*), 0, "ee63110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63110.e");
    test_class_info(&lv, &cd_ee63110);
    dp->~ee63110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63110(Test_ee63110, "ee63110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee63110C1Ev();
extern void _ZN7ee63110D1Ev();
Name_Map name_map_ee63110[] = {
  NSPAIR(_ZN7ee63110C1Ev),
  NSPAIR(_ZN7ee63110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee63110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63110[];
extern void _ZN7ee631103fooEv();
extern void _ZN7ee631103barEv();
static  VTBL_ENTRY vtc_ee63110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63110[0]),
  (VTBL_ENTRY)&_ZN7ee631103fooEv,
  (VTBL_ENTRY)&_ZN7ee631103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee63110[0]),
};
extern VTBL_ENTRY _ZTV7ee63110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee63110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee63110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee63110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee63110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee63110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee63110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee63110[] = {
  {&(_ZTV7ee63110[5]),  5,14},
  {&(_tg__ZTV6dd3110__7ee63110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee63110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee63110[3]),  3,3},
  {&(_ZTV7ee63110[11]),  11,14},
  {&(_ZTV7ee63110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee63110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee63110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee63110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee63110[];
extern  VTBL_ENTRY _ZTV7ee63110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63110[];
Class_Descriptor cd_ee63110 = {  "ee63110", // class name
  bases_ee63110, 4,
  &(vtc_ee63110[0]), // expected_vtbl_contents
  &(vtt_ee63110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee63110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73110  : virtual dd3110 {
  int e;
  virtual void  foo(); // _ZN7ee731103fooEv
  virtual void  bar(); // _ZN7ee731103barEv
  ~ee73110(); // tgen
  ee73110(); // tgen
};
//SIG(1 ee73110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73110 ::foo(){vfunc_called(this, "_ZN7ee731103fooEv");}
void  ee73110 ::bar(){vfunc_called(this, "_ZN7ee731103barEv");}
ee73110 ::~ee73110(){ note_dtor("ee73110", this);} // tgen
ee73110 ::ee73110(){ note_ctor("ee73110", this);} // tgen

static void Test_ee73110()
{
  extern Class_Descriptor cd_ee73110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee73110, buf);
    ee73110 *dp, &lv = *(dp=new (buf) ee73110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee73110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee73110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee73110");
    check_base_class_offset(lv, (cc110*)(dd3110*), ABISELECT(32,16), "ee73110");
    check_base_class_offset(lv, (dd3110*), ABISELECT(16,8), "ee73110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73110.e");
    test_class_info(&lv, &cd_ee73110);
    dp->~ee73110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73110(Test_ee73110, "ee73110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee73110C1Ev();
extern void _ZN7ee73110D1Ev();
Name_Map name_map_ee73110[] = {
  NSPAIR(_ZN7ee73110C1Ev),
  NSPAIR(_ZN7ee73110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd3110;
extern VTBL_ENTRY _ZTI6dd3110[];
extern  VTBL_ENTRY _ZTV6dd3110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3110[];
static Base_Class bases_ee73110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3110,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73110[];
extern void _ZN7ee731103fooEv();
extern void _ZN7ee731103barEv();
extern void ABISELECT(_ZTv0_n48_N7ee731103fooEv,_ZTv0_n24_N7ee731103fooEv)();
extern void ABISELECT(_ZThn16_N7ee731103fooEv,_ZThn8_N7ee731103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73110[0]),
  (VTBL_ENTRY)&_ZN7ee731103fooEv,
  (VTBL_ENTRY)&_ZN7ee731103barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee731103fooEv,_ZTv0_n24_N7ee731103fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee73110[0]),
};
extern VTBL_ENTRY _ZTV7ee73110[];
extern void _ZN6dd31103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3110__7ee73110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
  (VTBL_ENTRY)&_ZN6dd31103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd3110__7ee73110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd3110__7ee73110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd3110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee73110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee73110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee73110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee73110[] = {
  {&(_ZTV7ee73110[6]),  6,22},
  {&(_ZTV7ee73110[14]),  14,22},
  {&(_ZTV7ee73110[19]),  19,22},
  {&(_ZTV7ee73110[22]),  22,22},
  {&(_tg__ZTV6dd3110__7ee73110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd3110__7ee73110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd3110__7ee73110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee73110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee73110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee73110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee73110[];
extern  VTBL_ENTRY _ZTV7ee73110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73110[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee731103fooEv,_ZTv0_n24_N7ee731103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731103fooEv,_ZThn8_N7ee731103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73110 = {  "ee73110", // class name
  bases_ee73110, 4,
  &(vtc_ee73110[0]), // expected_vtbl_contents
  &(vtt_ee73110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee73110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73110),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4110  : cc110 {
  int d;
  virtual void  bar(); // _ZN6dd41103barEv
  ~dd4110(); // tgen
  dd4110(); // tgen
};
//SIG(-1 dd4110) C1{ BC2{ VBC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd4110 ::bar(){vfunc_called(this, "_ZN6dd41103barEv");}
dd4110 ::~dd4110(){ note_dtor("dd4110", this);} // tgen
dd4110 ::dd4110(){ note_ctor("dd4110", this);} // tgen

static void Test_dd4110()
{
  extern Class_Descriptor cd_dd4110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd4110, buf);
    dd4110 *dp, &lv = *(dp=new (buf) dd4110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd4110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(28,20), "dd4110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(16,12), "dd4110");
    check_base_class_offset(lv, (cc110*), 0, "dd4110");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4110.d");
    test_class_info(&lv, &cd_dd4110);
    dp->~dd4110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4110(Test_dd4110, "dd4110", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd4110C1Ev();
extern void _ZN6dd4110D1Ev();
Name_Map name_map_dd4110[] = {
  NSPAIR(_ZN6dd4110C1Ev),
  NSPAIR(_ZN6dd4110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd4110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY vtc_dd4110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
extern VTBL_ENTRY _ZTV6dd4110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd4110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd4110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd4110[] = {
  {&(_ZTV6dd4110[4]),  4,8},
  {&(_tg__ZTV5cc110__6dd4110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd4110[3]),  3,3},
  {&(_ZTV6dd4110[8]),  8,8},
  {&(_tg__ZTV4bb10__6dd4110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
Class_Descriptor cd_dd4110 = {  "dd4110", // class name
  bases_dd4110, 3,
  &(vtc_dd4110[0]), // expected_vtbl_contents
  &(vtt_dd4110[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd4110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4110),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04110  : dd4110 {
  int e;
  ~ee04110(); // tgen
  ee04110(); // tgen
};
//SIG(1 ee04110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee04110 ::~ee04110(){ note_dtor("ee04110", this);} // tgen
ee04110 ::ee04110(){ note_ctor("ee04110", this);} // tgen

static void Test_ee04110()
{
  extern Class_Descriptor cd_ee04110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee04110, buf);
    ee04110 *dp, &lv = *(dp=new (buf) ee04110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee04110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee04110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(24,16), "ee04110");
    check_base_class_offset(lv, (cc110*)(dd4110*), 0, "ee04110");
    check_base_class_offset(lv, (dd4110*), 0, "ee04110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04110.e");
    test_class_info(&lv, &cd_ee04110);
    dp->~ee04110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04110(Test_ee04110, "ee04110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee04110C1Ev();
extern void _ZN7ee04110D1Ev();
Name_Map name_map_ee04110[] = {
  NSPAIR(_ZN7ee04110C1Ev),
  NSPAIR(_ZN7ee04110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee04110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY vtc_ee04110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee04110[0]),
};
extern VTBL_ENTRY _ZTV7ee04110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee04110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee04110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee04110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee04110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee04110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee04110[] = {
  {&(_ZTV7ee04110[4]),  4,8},
  {&(_tg__ZTV6dd4110__7ee04110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee04110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee04110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee04110[3]),  3,3},
  {&(_ZTV7ee04110[8]),  8,8},
  {&(_tg__ZTV4bb10__7ee04110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee04110[];
extern  VTBL_ENTRY _ZTV7ee04110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04110[];
Class_Descriptor cd_ee04110 = {  "ee04110", // class name
  bases_ee04110, 4,
  &(vtc_ee04110[0]), // expected_vtbl_contents
  &(vtt_ee04110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee04110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14110  : virtual dd4110 {
  int e;
  ~ee14110(); // tgen
  ee14110(); // tgen
};
//SIG(1 ee14110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee14110 ::~ee14110(){ note_dtor("ee14110", this);} // tgen
ee14110 ::ee14110(){ note_ctor("ee14110", this);} // tgen

static void Test_ee14110()
{
  extern Class_Descriptor cd_ee14110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee14110, buf);
    ee14110 *dp, &lv = *(dp=new (buf) ee14110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee14110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee14110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(32,20), "ee14110");
    check_base_class_offset(lv, (cc110*)(dd4110*), ABISELECT(16,8), "ee14110");
    check_base_class_offset(lv, (dd4110*), ABISELECT(16,8), "ee14110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14110.e");
    test_class_info(&lv, &cd_ee14110);
    dp->~ee14110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14110(Test_ee14110, "ee14110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee14110C1Ev();
extern void _ZN7ee14110D1Ev();
Name_Map name_map_ee14110[] = {
  NSPAIR(_ZN7ee14110C1Ev),
  NSPAIR(_ZN7ee14110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee14110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY vtc_ee14110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14110[0]),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee14110[0]),
};
extern VTBL_ENTRY _ZTV7ee14110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee14110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee14110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee14110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee14110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee14110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee14110[] = {
  {&(_ZTV7ee14110[5]),  5,14},
  {&(_ZTV7ee14110[10]),  10,14},
  {&(_ZTV7ee14110[14]),  14,14},
  {&(_tg__ZTV6dd4110__7ee14110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee14110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee14110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee14110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee14110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee14110[];
extern  VTBL_ENTRY _ZTV7ee14110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14110[];
Class_Descriptor cd_ee14110 = {  "ee14110", // class name
  bases_ee14110, 4,
  &(vtc_ee14110[0]), // expected_vtbl_contents
  &(vtt_ee14110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee14110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24110  : dd4110 {
  int e;
  virtual void  foo(); // _ZN7ee241103fooEv
  ~ee24110(); // tgen
  ee24110(); // tgen
};
//SIG(1 ee24110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee24110 ::foo(){vfunc_called(this, "_ZN7ee241103fooEv");}
ee24110 ::~ee24110(){ note_dtor("ee24110", this);} // tgen
ee24110 ::ee24110(){ note_ctor("ee24110", this);} // tgen

static void Test_ee24110()
{
  extern Class_Descriptor cd_ee24110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee24110, buf);
    ee24110 *dp, &lv = *(dp=new (buf) ee24110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee24110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee24110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(24,16), "ee24110");
    check_base_class_offset(lv, (cc110*)(dd4110*), 0, "ee24110");
    check_base_class_offset(lv, (dd4110*), 0, "ee24110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24110.e");
    test_class_info(&lv, &cd_ee24110);
    dp->~ee24110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24110(Test_ee24110, "ee24110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee24110C1Ev();
extern void _ZN7ee24110D1Ev();
Name_Map name_map_ee24110[] = {
  NSPAIR(_ZN7ee24110C1Ev),
  NSPAIR(_ZN7ee24110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee24110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24110[];
extern void _ZN6dd41103barEv();
extern void _ZN7ee241103fooEv();
static  VTBL_ENTRY vtc_ee24110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
  (VTBL_ENTRY)&_ZN7ee241103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee24110[0]),
};
extern VTBL_ENTRY _ZTV7ee24110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee24110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee24110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee24110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee24110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee24110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee24110[] = {
  {&(_ZTV7ee24110[4]),  4,9},
  {&(_tg__ZTV6dd4110__7ee24110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee24110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee24110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee24110[3]),  3,3},
  {&(_ZTV7ee24110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee24110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee24110[];
extern  VTBL_ENTRY _ZTV7ee24110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24110[];
Class_Descriptor cd_ee24110 = {  "ee24110", // class name
  bases_ee24110, 4,
  &(vtc_ee24110[0]), // expected_vtbl_contents
  &(vtt_ee24110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee24110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34110  : virtual dd4110 {
  int e;
  virtual void  foo(); // _ZN7ee341103fooEv
  ~ee34110(); // tgen
  ee34110(); // tgen
};
//SIG(1 ee34110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee34110 ::foo(){vfunc_called(this, "_ZN7ee341103fooEv");}
ee34110 ::~ee34110(){ note_dtor("ee34110", this);} // tgen
ee34110 ::ee34110(){ note_ctor("ee34110", this);} // tgen

static void Test_ee34110()
{
  extern Class_Descriptor cd_ee34110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee34110, buf);
    ee34110 *dp, &lv = *(dp=new (buf) ee34110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee34110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee34110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(32,20), "ee34110");
    check_base_class_offset(lv, (cc110*)(dd4110*), ABISELECT(16,8), "ee34110");
    check_base_class_offset(lv, (dd4110*), ABISELECT(16,8), "ee34110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34110.e");
    test_class_info(&lv, &cd_ee34110);
    dp->~ee34110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34110(Test_ee34110, "ee34110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee34110C1Ev();
extern void _ZN7ee34110D1Ev();
Name_Map name_map_ee34110[] = {
  NSPAIR(_ZN7ee34110C1Ev),
  NSPAIR(_ZN7ee34110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee34110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34110[];
extern void _ZN7ee341103fooEv();
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY vtc_ee34110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34110[0]),
  (VTBL_ENTRY)&_ZN7ee341103fooEv,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee34110[0]),
};
extern VTBL_ENTRY _ZTV7ee34110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee34110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee34110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee34110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee34110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee34110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee34110[] = {
  {&(_ZTV7ee34110[5]),  5,15},
  {&(_ZTV7ee34110[11]),  11,15},
  {&(_ZTV7ee34110[15]),  15,15},
  {&(_tg__ZTV6dd4110__7ee34110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee34110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee34110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee34110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee34110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee34110[];
extern  VTBL_ENTRY _ZTV7ee34110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34110[];
Class_Descriptor cd_ee34110 = {  "ee34110", // class name
  bases_ee34110, 4,
  &(vtc_ee34110[0]), // expected_vtbl_contents
  &(vtt_ee34110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee34110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34110),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44110  : dd4110 {
  int e;
  virtual void  bar(); // _ZN7ee441103barEv
  ~ee44110(); // tgen
  ee44110(); // tgen
};
//SIG(1 ee44110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee44110 ::bar(){vfunc_called(this, "_ZN7ee441103barEv");}
ee44110 ::~ee44110(){ note_dtor("ee44110", this);} // tgen
ee44110 ::ee44110(){ note_ctor("ee44110", this);} // tgen

static void Test_ee44110()
{
  extern Class_Descriptor cd_ee44110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee44110, buf);
    ee44110 *dp, &lv = *(dp=new (buf) ee44110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee44110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee44110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(24,16), "ee44110");
    check_base_class_offset(lv, (cc110*)(dd4110*), 0, "ee44110");
    check_base_class_offset(lv, (dd4110*), 0, "ee44110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44110.e");
    test_class_info(&lv, &cd_ee44110);
    dp->~ee44110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44110(Test_ee44110, "ee44110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee44110C1Ev();
extern void _ZN7ee44110D1Ev();
Name_Map name_map_ee44110[] = {
  NSPAIR(_ZN7ee44110C1Ev),
  NSPAIR(_ZN7ee44110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee44110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44110[];
extern void _ZN7ee441103barEv();
static  VTBL_ENTRY vtc_ee44110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44110[0]),
  (VTBL_ENTRY)&_ZN7ee441103barEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee44110[0]),
};
extern VTBL_ENTRY _ZTV7ee44110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee44110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee44110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee44110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee44110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee44110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee44110[] = {
  {&(_ZTV7ee44110[4]),  4,8},
  {&(_tg__ZTV6dd4110__7ee44110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee44110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee44110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee44110[3]),  3,3},
  {&(_ZTV7ee44110[8]),  8,8},
  {&(_tg__ZTV4bb10__7ee44110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee44110[];
extern  VTBL_ENTRY _ZTV7ee44110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44110[];
Class_Descriptor cd_ee44110 = {  "ee44110", // class name
  bases_ee44110, 4,
  &(vtc_ee44110[0]), // expected_vtbl_contents
  &(vtt_ee44110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee44110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44110),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54110  : virtual dd4110 {
  int e;
  virtual void  bar(); // _ZN7ee541103barEv
  ~ee54110(); // tgen
  ee54110(); // tgen
};
//SIG(1 ee54110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee54110 ::bar(){vfunc_called(this, "_ZN7ee541103barEv");}
ee54110 ::~ee54110(){ note_dtor("ee54110", this);} // tgen
ee54110 ::ee54110(){ note_ctor("ee54110", this);} // tgen

static void Test_ee54110()
{
  extern Class_Descriptor cd_ee54110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee54110, buf);
    ee54110 *dp, &lv = *(dp=new (buf) ee54110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee54110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee54110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(32,20), "ee54110");
    check_base_class_offset(lv, (cc110*)(dd4110*), ABISELECT(16,8), "ee54110");
    check_base_class_offset(lv, (dd4110*), ABISELECT(16,8), "ee54110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54110.e");
    test_class_info(&lv, &cd_ee54110);
    dp->~ee54110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54110(Test_ee54110, "ee54110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee54110C1Ev();
extern void _ZN7ee54110D1Ev();
Name_Map name_map_ee54110[] = {
  NSPAIR(_ZN7ee54110C1Ev),
  NSPAIR(_ZN7ee54110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee54110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54110[];
extern void _ZN7ee541103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee541103barEv,_ZTv0_n20_N7ee541103barEv)();
extern void ABISELECT(_ZThn16_N7ee541103barEv,_ZThn8_N7ee541103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54110[0]),
  (VTBL_ENTRY)&_ZN7ee541103barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee541103barEv,_ZTv0_n20_N7ee541103barEv),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee54110[0]),
};
extern VTBL_ENTRY _ZTV7ee54110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee54110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee54110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee54110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee54110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee54110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee54110[] = {
  {&(_ZTV7ee54110[5]),  5,15},
  {&(_ZTV7ee54110[11]),  11,15},
  {&(_ZTV7ee54110[15]),  15,15},
  {&(_tg__ZTV6dd4110__7ee54110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee54110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee54110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee54110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee54110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee54110[];
extern  VTBL_ENTRY _ZTV7ee54110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54110[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee541103barEv,_ZTv0_n20_N7ee541103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541103barEv,_ZThn8_N7ee541103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54110 = {  "ee54110", // class name
  bases_ee54110, 4,
  &(vtc_ee54110[0]), // expected_vtbl_contents
  &(vtt_ee54110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee54110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54110),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64110  : dd4110 {
  int e;
  virtual void  foo(); // _ZN7ee641103fooEv
  virtual void  bar(); // _ZN7ee641103barEv
  ~ee64110(); // tgen
  ee64110(); // tgen
};
//SIG(1 ee64110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64110 ::foo(){vfunc_called(this, "_ZN7ee641103fooEv");}
void  ee64110 ::bar(){vfunc_called(this, "_ZN7ee641103barEv");}
ee64110 ::~ee64110(){ note_dtor("ee64110", this);} // tgen
ee64110 ::ee64110(){ note_ctor("ee64110", this);} // tgen

static void Test_ee64110()
{
  extern Class_Descriptor cd_ee64110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee64110, buf);
    ee64110 *dp, &lv = *(dp=new (buf) ee64110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee64110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee64110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(24,16), "ee64110");
    check_base_class_offset(lv, (cc110*)(dd4110*), 0, "ee64110");
    check_base_class_offset(lv, (dd4110*), 0, "ee64110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64110.e");
    test_class_info(&lv, &cd_ee64110);
    dp->~ee64110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64110(Test_ee64110, "ee64110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee64110C1Ev();
extern void _ZN7ee64110D1Ev();
Name_Map name_map_ee64110[] = {
  NSPAIR(_ZN7ee64110C1Ev),
  NSPAIR(_ZN7ee64110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee64110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64110[];
extern void _ZN7ee641103barEv();
extern void _ZN7ee641103fooEv();
static  VTBL_ENTRY vtc_ee64110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64110[0]),
  (VTBL_ENTRY)&_ZN7ee641103barEv,
  (VTBL_ENTRY)&_ZN7ee641103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee64110[0]),
};
extern VTBL_ENTRY _ZTV7ee64110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee64110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee64110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee64110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee64110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee64110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee64110[] = {
  {&(_ZTV7ee64110[4]),  4,9},
  {&(_tg__ZTV6dd4110__7ee64110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee64110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee64110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee64110[3]),  3,3},
  {&(_ZTV7ee64110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee64110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee64110[];
extern  VTBL_ENTRY _ZTV7ee64110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64110[];
Class_Descriptor cd_ee64110 = {  "ee64110", // class name
  bases_ee64110, 4,
  &(vtc_ee64110[0]), // expected_vtbl_contents
  &(vtt_ee64110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee64110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74110  : virtual dd4110 {
  int e;
  virtual void  foo(); // _ZN7ee741103fooEv
  virtual void  bar(); // _ZN7ee741103barEv
  ~ee74110(); // tgen
  ee74110(); // tgen
};
//SIG(1 ee74110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74110 ::foo(){vfunc_called(this, "_ZN7ee741103fooEv");}
void  ee74110 ::bar(){vfunc_called(this, "_ZN7ee741103barEv");}
ee74110 ::~ee74110(){ note_dtor("ee74110", this);} // tgen
ee74110 ::ee74110(){ note_ctor("ee74110", this);} // tgen

static void Test_ee74110()
{
  extern Class_Descriptor cd_ee74110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee74110, buf);
    ee74110 *dp, &lv = *(dp=new (buf) ee74110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee74110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee74110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd4110*), ABISELECT(32,20), "ee74110");
    check_base_class_offset(lv, (cc110*)(dd4110*), ABISELECT(16,8), "ee74110");
    check_base_class_offset(lv, (dd4110*), ABISELECT(16,8), "ee74110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74110.e");
    test_class_info(&lv, &cd_ee74110);
    dp->~ee74110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74110(Test_ee74110, "ee74110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee74110C1Ev();
extern void _ZN7ee74110D1Ev();
Name_Map name_map_ee74110[] = {
  NSPAIR(_ZN7ee74110C1Ev),
  NSPAIR(_ZN7ee74110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd4110;
extern VTBL_ENTRY _ZTI6dd4110[];
extern  VTBL_ENTRY _ZTV6dd4110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4110[];
static Base_Class bases_ee74110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74110[];
extern void _ZN7ee741103fooEv();
extern void _ZN7ee741103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee741103barEv,_ZTv0_n20_N7ee741103barEv)();
extern void ABISELECT(_ZThn16_N7ee741103barEv,_ZThn8_N7ee741103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74110[0]),
  (VTBL_ENTRY)&_ZN7ee741103fooEv,
  (VTBL_ENTRY)&_ZN7ee741103barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee741103barEv,_ZTv0_n20_N7ee741103barEv),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee74110[0]),
};
extern VTBL_ENTRY _ZTV7ee74110[];
extern void _ZN6dd41103barEv();
static  VTBL_ENTRY _tg__ZTV6dd4110__7ee74110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
  (VTBL_ENTRY)&_ZN6dd41103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd4110__7ee74110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd4110__7ee74110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd4110__7ee74110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd4110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee74110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee74110[] = {
  {&(_ZTV7ee74110[5]),  5,16},
  {&(_ZTV7ee74110[12]),  12,16},
  {&(_ZTV7ee74110[16]),  16,16},
  {&(_tg__ZTV6dd4110__7ee74110[4]),  4,5},
  {&(_tg__ZTV5cc1106dd4110__7ee74110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd4110__7ee74110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd4110__7ee74110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee74110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee74110[];
extern  VTBL_ENTRY _ZTV7ee74110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74110[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee741103barEv,_ZTv0_n20_N7ee741103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741103barEv,_ZThn8_N7ee741103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74110 = {  "ee74110", // class name
  bases_ee74110, 4,
  &(vtc_ee74110[0]), // expected_vtbl_contents
  &(vtt_ee74110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee74110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74110),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5110  : virtual cc110 {
  int d;
  virtual void  bar(); // _ZN6dd51103barEv
  ~dd5110(); // tgen
  dd5110(); // tgen
};
//SIG(-1 dd5110) C1{ VBC2{ VBC3{ VBC4{ Fi} Fi} Fi} v1 Fi}


void  dd5110 ::bar(){vfunc_called(this, "_ZN6dd51103barEv");}
dd5110 ::~dd5110(){ note_dtor("dd5110", this);} // tgen
dd5110 ::dd5110(){ note_ctor("dd5110", this);} // tgen

static void Test_dd5110()
{
  extern Class_Descriptor cd_dd5110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd5110, buf);
    dd5110 *dp, &lv = *(dp=new (buf) dd5110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd5110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,24), "dd5110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,16), "dd5110");
    check_base_class_offset(lv, (cc110*), ABISELECT(16,8), "dd5110");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5110.d");
    test_class_info(&lv, &cd_dd5110);
    dp->~dd5110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5110(Test_dd5110, "dd5110", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd5110C1Ev();
extern void _ZN6dd5110D1Ev();
Name_Map name_map_dd5110[] = {
  NSPAIR(_ZN6dd5110C1Ev),
  NSPAIR(_ZN6dd5110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd5110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY vtc_dd5110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
extern VTBL_ENTRY _ZTV6dd5110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd5110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd5110[] = {
  {&(_ZTV6dd5110[5]),  5,13},
  {&(_ZTV6dd5110[10]),  10,13},
  {&(_ZTV6dd5110[13]),  13,13},
  {&(_tg__ZTV5cc110__6dd5110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd5110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd5110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
Class_Descriptor cd_dd5110 = {  "dd5110", // class name
  bases_dd5110, 3,
  &(vtc_dd5110[0]), // expected_vtbl_contents
  &(vtt_dd5110[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd5110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5110),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05110  : dd5110 {
  int e;
  ~ee05110(); // tgen
  ee05110(); // tgen
};
//SIG(1 ee05110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee05110 ::~ee05110(){ note_dtor("ee05110", this);} // tgen
ee05110 ::ee05110(){ note_ctor("ee05110", this);} // tgen

static void Test_ee05110()
{
  extern Class_Descriptor cd_ee05110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee05110, buf);
    ee05110 *dp, &lv = *(dp=new (buf) ee05110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee05110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee05110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee05110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(16,12), "ee05110");
    check_base_class_offset(lv, (dd5110*), 0, "ee05110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05110.e");
    test_class_info(&lv, &cd_ee05110);
    dp->~ee05110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05110(Test_ee05110, "ee05110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee05110C1Ev();
extern void _ZN7ee05110D1Ev();
Name_Map name_map_ee05110[] = {
  NSPAIR(_ZN7ee05110C1Ev),
  NSPAIR(_ZN7ee05110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee05110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY vtc_ee05110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee05110[0]),
};
extern VTBL_ENTRY _ZTV7ee05110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee05110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee05110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee05110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee05110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee05110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee05110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee05110[] = {
  {&(_ZTV7ee05110[5]),  5,13},
  {&(_tg__ZTV6dd5110__7ee05110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee05110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee05110[3]),  3,3},
  {&(_ZTV7ee05110[10]),  10,13},
  {&(_ZTV7ee05110[13]),  13,13},
  {&(_tg__ZTV5cc110__7ee05110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee05110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee05110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee05110[];
extern  VTBL_ENTRY _ZTV7ee05110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05110[];
Class_Descriptor cd_ee05110 = {  "ee05110", // class name
  bases_ee05110, 4,
  &(vtc_ee05110[0]), // expected_vtbl_contents
  &(vtt_ee05110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee05110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15110  : virtual dd5110 {
  int e;
  ~ee15110(); // tgen
  ee15110(); // tgen
};
//SIG(1 ee15110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee15110 ::~ee15110(){ note_dtor("ee15110", this);} // tgen
ee15110 ::ee15110(){ note_ctor("ee15110", this);} // tgen

static void Test_ee15110()
{
  extern Class_Descriptor cd_ee15110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee15110, buf);
    ee15110 *dp, &lv = *(dp=new (buf) ee15110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee15110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee15110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee15110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(32,16), "ee15110");
    check_base_class_offset(lv, (dd5110*), ABISELECT(16,8), "ee15110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15110.e");
    test_class_info(&lv, &cd_ee15110);
    dp->~ee15110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15110(Test_ee15110, "ee15110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee15110C1Ev();
extern void _ZN7ee15110D1Ev();
Name_Map name_map_ee15110[] = {
  NSPAIR(_ZN7ee15110C1Ev),
  NSPAIR(_ZN7ee15110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee15110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY vtc_ee15110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15110[0]),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee15110[0]),
};
extern VTBL_ENTRY _ZTV7ee15110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee15110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee15110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee15110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee15110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee15110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee15110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee15110[] = {
  {&(_ZTV7ee15110[6]),  6,20},
  {&(_ZTV7ee15110[12]),  12,20},
  {&(_ZTV7ee15110[17]),  17,20},
  {&(_ZTV7ee15110[20]),  20,20},
  {&(_tg__ZTV6dd5110__7ee15110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee15110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee15110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee15110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee15110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee15110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee15110[];
extern  VTBL_ENTRY _ZTV7ee15110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15110[];
Class_Descriptor cd_ee15110 = {  "ee15110", // class name
  bases_ee15110, 4,
  &(vtc_ee15110[0]), // expected_vtbl_contents
  &(vtt_ee15110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee15110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15110),20, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25110  : dd5110 {
  int e;
  virtual void  foo(); // _ZN7ee251103fooEv
  ~ee25110(); // tgen
  ee25110(); // tgen
};
//SIG(1 ee25110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee25110 ::foo(){vfunc_called(this, "_ZN7ee251103fooEv");}
ee25110 ::~ee25110(){ note_dtor("ee25110", this);} // tgen
ee25110 ::ee25110(){ note_ctor("ee25110", this);} // tgen

static void Test_ee25110()
{
  extern Class_Descriptor cd_ee25110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee25110, buf);
    ee25110 *dp, &lv = *(dp=new (buf) ee25110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee25110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee25110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee25110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(16,12), "ee25110");
    check_base_class_offset(lv, (dd5110*), 0, "ee25110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25110.e");
    test_class_info(&lv, &cd_ee25110);
    dp->~ee25110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25110(Test_ee25110, "ee25110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee25110C1Ev();
extern void _ZN7ee25110D1Ev();
Name_Map name_map_ee25110[] = {
  NSPAIR(_ZN7ee25110C1Ev),
  NSPAIR(_ZN7ee25110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee25110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25110[];
extern void _ZN6dd51103barEv();
extern void _ZN7ee251103fooEv();
static  VTBL_ENTRY vtc_ee25110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
  (VTBL_ENTRY)&_ZN7ee251103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee25110[0]),
};
extern VTBL_ENTRY _ZTV7ee25110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee25110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee25110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee25110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee25110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee25110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee25110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee25110[] = {
  {&(_ZTV7ee25110[5]),  5,14},
  {&(_tg__ZTV6dd5110__7ee25110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee25110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee25110[3]),  3,3},
  {&(_ZTV7ee25110[11]),  11,14},
  {&(_ZTV7ee25110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee25110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee25110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee25110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee25110[];
extern  VTBL_ENTRY _ZTV7ee25110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25110[];
Class_Descriptor cd_ee25110 = {  "ee25110", // class name
  bases_ee25110, 4,
  &(vtc_ee25110[0]), // expected_vtbl_contents
  &(vtt_ee25110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee25110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35110  : virtual dd5110 {
  int e;
  virtual void  foo(); // _ZN7ee351103fooEv
  ~ee35110(); // tgen
  ee35110(); // tgen
};
//SIG(1 ee35110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee35110 ::foo(){vfunc_called(this, "_ZN7ee351103fooEv");}
ee35110 ::~ee35110(){ note_dtor("ee35110", this);} // tgen
ee35110 ::ee35110(){ note_ctor("ee35110", this);} // tgen

static void Test_ee35110()
{
  extern Class_Descriptor cd_ee35110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee35110, buf);
    ee35110 *dp, &lv = *(dp=new (buf) ee35110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee35110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee35110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee35110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(32,16), "ee35110");
    check_base_class_offset(lv, (dd5110*), ABISELECT(16,8), "ee35110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35110.e");
    test_class_info(&lv, &cd_ee35110);
    dp->~ee35110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35110(Test_ee35110, "ee35110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee35110C1Ev();
extern void _ZN7ee35110D1Ev();
Name_Map name_map_ee35110[] = {
  NSPAIR(_ZN7ee35110C1Ev),
  NSPAIR(_ZN7ee35110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee35110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35110[];
extern void _ZN7ee351103fooEv();
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY vtc_ee35110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35110[0]),
  (VTBL_ENTRY)&_ZN7ee351103fooEv,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee35110[0]),
};
extern VTBL_ENTRY _ZTV7ee35110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee35110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee35110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee35110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee35110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee35110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee35110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee35110[] = {
  {&(_ZTV7ee35110[6]),  6,21},
  {&(_ZTV7ee35110[13]),  13,21},
  {&(_ZTV7ee35110[18]),  18,21},
  {&(_ZTV7ee35110[21]),  21,21},
  {&(_tg__ZTV6dd5110__7ee35110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee35110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee35110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee35110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee35110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee35110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee35110[];
extern  VTBL_ENTRY _ZTV7ee35110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35110[];
Class_Descriptor cd_ee35110 = {  "ee35110", // class name
  bases_ee35110, 4,
  &(vtc_ee35110[0]), // expected_vtbl_contents
  &(vtt_ee35110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee35110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35110),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45110  : dd5110 {
  int e;
  virtual void  bar(); // _ZN7ee451103barEv
  ~ee45110(); // tgen
  ee45110(); // tgen
};
//SIG(1 ee45110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee45110 ::bar(){vfunc_called(this, "_ZN7ee451103barEv");}
ee45110 ::~ee45110(){ note_dtor("ee45110", this);} // tgen
ee45110 ::ee45110(){ note_ctor("ee45110", this);} // tgen

static void Test_ee45110()
{
  extern Class_Descriptor cd_ee45110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee45110, buf);
    ee45110 *dp, &lv = *(dp=new (buf) ee45110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee45110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee45110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee45110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(16,12), "ee45110");
    check_base_class_offset(lv, (dd5110*), 0, "ee45110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45110.e");
    test_class_info(&lv, &cd_ee45110);
    dp->~ee45110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45110(Test_ee45110, "ee45110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee45110C1Ev();
extern void _ZN7ee45110D1Ev();
Name_Map name_map_ee45110[] = {
  NSPAIR(_ZN7ee45110C1Ev),
  NSPAIR(_ZN7ee45110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee45110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45110[];
extern void _ZN7ee451103barEv();
static  VTBL_ENTRY vtc_ee45110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45110[0]),
  (VTBL_ENTRY)&_ZN7ee451103barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee45110[0]),
};
extern VTBL_ENTRY _ZTV7ee45110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee45110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee45110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee45110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee45110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee45110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee45110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee45110[] = {
  {&(_ZTV7ee45110[5]),  5,13},
  {&(_tg__ZTV6dd5110__7ee45110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee45110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee45110[3]),  3,3},
  {&(_ZTV7ee45110[10]),  10,13},
  {&(_ZTV7ee45110[13]),  13,13},
  {&(_tg__ZTV5cc110__7ee45110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee45110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee45110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee45110[];
extern  VTBL_ENTRY _ZTV7ee45110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45110[];
Class_Descriptor cd_ee45110 = {  "ee45110", // class name
  bases_ee45110, 4,
  &(vtc_ee45110[0]), // expected_vtbl_contents
  &(vtt_ee45110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee45110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45110),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55110  : virtual dd5110 {
  int e;
  virtual void  bar(); // _ZN7ee551103barEv
  ~ee55110(); // tgen
  ee55110(); // tgen
};
//SIG(1 ee55110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee55110 ::bar(){vfunc_called(this, "_ZN7ee551103barEv");}
ee55110 ::~ee55110(){ note_dtor("ee55110", this);} // tgen
ee55110 ::ee55110(){ note_ctor("ee55110", this);} // tgen

static void Test_ee55110()
{
  extern Class_Descriptor cd_ee55110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee55110, buf);
    ee55110 *dp, &lv = *(dp=new (buf) ee55110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee55110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee55110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee55110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(32,16), "ee55110");
    check_base_class_offset(lv, (dd5110*), ABISELECT(16,8), "ee55110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55110.e");
    test_class_info(&lv, &cd_ee55110);
    dp->~ee55110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55110(Test_ee55110, "ee55110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee55110C1Ev();
extern void _ZN7ee55110D1Ev();
Name_Map name_map_ee55110[] = {
  NSPAIR(_ZN7ee55110C1Ev),
  NSPAIR(_ZN7ee55110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee55110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55110[];
extern void _ZN7ee551103barEv();
extern void ABISELECT(_ZTv0_n48_N7ee551103barEv,_ZTv0_n24_N7ee551103barEv)();
extern void ABISELECT(_ZThn16_N7ee551103barEv,_ZThn8_N7ee551103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55110[0]),
  (VTBL_ENTRY)&_ZN7ee551103barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee551103barEv,_ZTv0_n24_N7ee551103barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee55110[0]),
};
extern VTBL_ENTRY _ZTV7ee55110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee55110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee55110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee55110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee55110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee55110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee55110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee55110[] = {
  {&(_ZTV7ee55110[6]),  6,21},
  {&(_ZTV7ee55110[13]),  13,21},
  {&(_ZTV7ee55110[18]),  18,21},
  {&(_ZTV7ee55110[21]),  21,21},
  {&(_tg__ZTV6dd5110__7ee55110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee55110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee55110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee55110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee55110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee55110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee55110[];
extern  VTBL_ENTRY _ZTV7ee55110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55110[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee551103barEv,_ZTv0_n24_N7ee551103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551103barEv,_ZThn8_N7ee551103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55110 = {  "ee55110", // class name
  bases_ee55110, 4,
  &(vtc_ee55110[0]), // expected_vtbl_contents
  &(vtt_ee55110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee55110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55110),21, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65110  : dd5110 {
  int e;
  virtual void  foo(); // _ZN7ee651103fooEv
  virtual void  bar(); // _ZN7ee651103barEv
  ~ee65110(); // tgen
  ee65110(); // tgen
};
//SIG(1 ee65110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65110 ::foo(){vfunc_called(this, "_ZN7ee651103fooEv");}
void  ee65110 ::bar(){vfunc_called(this, "_ZN7ee651103barEv");}
ee65110 ::~ee65110(){ note_dtor("ee65110", this);} // tgen
ee65110 ::ee65110(){ note_ctor("ee65110", this);} // tgen

static void Test_ee65110()
{
  extern Class_Descriptor cd_ee65110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee65110, buf);
    ee65110 *dp, &lv = *(dp=new (buf) ee65110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee65110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee65110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee65110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(16,12), "ee65110");
    check_base_class_offset(lv, (dd5110*), 0, "ee65110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65110.e");
    test_class_info(&lv, &cd_ee65110);
    dp->~ee65110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65110(Test_ee65110, "ee65110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee65110C1Ev();
extern void _ZN7ee65110D1Ev();
Name_Map name_map_ee65110[] = {
  NSPAIR(_ZN7ee65110C1Ev),
  NSPAIR(_ZN7ee65110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee65110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65110[];
extern void _ZN7ee651103barEv();
extern void _ZN7ee651103fooEv();
static  VTBL_ENTRY vtc_ee65110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65110[0]),
  (VTBL_ENTRY)&_ZN7ee651103barEv,
  (VTBL_ENTRY)&_ZN7ee651103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee65110[0]),
};
extern VTBL_ENTRY _ZTV7ee65110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee65110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee65110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee65110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee65110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee65110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee65110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee65110[] = {
  {&(_ZTV7ee65110[5]),  5,14},
  {&(_tg__ZTV6dd5110__7ee65110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee65110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee65110[3]),  3,3},
  {&(_ZTV7ee65110[11]),  11,14},
  {&(_ZTV7ee65110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee65110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee65110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee65110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee65110[];
extern  VTBL_ENTRY _ZTV7ee65110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65110[];
Class_Descriptor cd_ee65110 = {  "ee65110", // class name
  bases_ee65110, 4,
  &(vtc_ee65110[0]), // expected_vtbl_contents
  &(vtt_ee65110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee65110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75110  : virtual dd5110 {
  int e;
  virtual void  foo(); // _ZN7ee751103fooEv
  virtual void  bar(); // _ZN7ee751103barEv
  ~ee75110(); // tgen
  ee75110(); // tgen
};
//SIG(1 ee75110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75110 ::foo(){vfunc_called(this, "_ZN7ee751103fooEv");}
void  ee75110 ::bar(){vfunc_called(this, "_ZN7ee751103barEv");}
ee75110 ::~ee75110(){ note_dtor("ee75110", this);} // tgen
ee75110 ::ee75110(){ note_ctor("ee75110", this);} // tgen

static void Test_ee75110()
{
  extern Class_Descriptor cd_ee75110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee75110, buf);
    ee75110 *dp, &lv = *(dp=new (buf) ee75110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee75110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee75110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee75110");
    check_base_class_offset(lv, (cc110*)(dd5110*), ABISELECT(32,16), "ee75110");
    check_base_class_offset(lv, (dd5110*), ABISELECT(16,8), "ee75110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75110.e");
    test_class_info(&lv, &cd_ee75110);
    dp->~ee75110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75110(Test_ee75110, "ee75110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee75110C1Ev();
extern void _ZN7ee75110D1Ev();
Name_Map name_map_ee75110[] = {
  NSPAIR(_ZN7ee75110C1Ev),
  NSPAIR(_ZN7ee75110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd5110;
extern VTBL_ENTRY _ZTI6dd5110[];
extern  VTBL_ENTRY _ZTV6dd5110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5110[];
static Base_Class bases_ee75110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5110,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75110[];
extern void _ZN7ee751103fooEv();
extern void _ZN7ee751103barEv();
extern void ABISELECT(_ZTv0_n48_N7ee751103barEv,_ZTv0_n24_N7ee751103barEv)();
extern void ABISELECT(_ZThn16_N7ee751103barEv,_ZThn8_N7ee751103barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75110[0]),
  (VTBL_ENTRY)&_ZN7ee751103fooEv,
  (VTBL_ENTRY)&_ZN7ee751103barEv,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee751103barEv,_ZTv0_n24_N7ee751103barEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee75110[0]),
};
extern VTBL_ENTRY _ZTV7ee75110[];
extern void _ZN6dd51103barEv();
static  VTBL_ENTRY _tg__ZTV6dd5110__7ee75110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
  (VTBL_ENTRY)&_ZN6dd51103barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd5110__7ee75110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd5110__7ee75110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd5110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee75110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee75110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee75110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee75110[] = {
  {&(_ZTV7ee75110[6]),  6,22},
  {&(_ZTV7ee75110[14]),  14,22},
  {&(_ZTV7ee75110[19]),  19,22},
  {&(_ZTV7ee75110[22]),  22,22},
  {&(_tg__ZTV6dd5110__7ee75110[5]),  5,6},
  {&(_tg__ZTV5cc110__6dd5110__7ee75110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd5110__7ee75110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee75110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee75110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee75110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee75110[];
extern  VTBL_ENTRY _ZTV7ee75110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75110[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee751103barEv,_ZTv0_n24_N7ee751103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751103barEv,_ZThn8_N7ee751103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75110 = {  "ee75110", // class name
  bases_ee75110, 4,
  &(vtc_ee75110[0]), // expected_vtbl_contents
  &(vtt_ee75110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee75110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75110),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6110  : cc110 {
  int d;
  virtual void  bar(); // _ZN6dd61103barEv
  virtual void  foo(); // _ZN6dd61103fooEv
  ~dd6110(); // tgen
  dd6110(); // tgen
};
//SIG(-1 dd6110) C1{ BC2{ VBC3{ VBC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd6110 ::bar(){vfunc_called(this, "_ZN6dd61103barEv");}
void  dd6110 ::foo(){vfunc_called(this, "_ZN6dd61103fooEv");}
dd6110 ::~dd6110(){ note_dtor("dd6110", this);} // tgen
dd6110 ::dd6110(){ note_ctor("dd6110", this);} // tgen

static void Test_dd6110()
{
  extern Class_Descriptor cd_dd6110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_dd6110, buf);
    dd6110 *dp, &lv = *(dp=new (buf) dd6110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(dd6110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(28,20), "dd6110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(16,12), "dd6110");
    check_base_class_offset(lv, (cc110*), 0, "dd6110");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6110.d");
    test_class_info(&lv, &cd_dd6110);
    dp->~dd6110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6110(Test_dd6110, "dd6110", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN6dd6110C1Ev();
extern void _ZN6dd6110D1Ev();
Name_Map name_map_dd6110[] = {
  NSPAIR(_ZN6dd6110C1Ev),
  NSPAIR(_ZN6dd6110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd6110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY vtc_dd6110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
extern VTBL_ENTRY _ZTV6dd6110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd6110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd6110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd6110[] = {
  {&(_ZTV6dd6110[4]),  4,9},
  {&(_tg__ZTV5cc110__6dd6110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd6110[3]),  3,3},
  {&(_ZTV6dd6110[9]),  9,9},
  {&(_tg__ZTV4bb10__6dd6110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
Class_Descriptor cd_dd6110 = {  "dd6110", // class name
  bases_dd6110, 3,
  &(vtc_dd6110[0]), // expected_vtbl_contents
  &(vtt_dd6110[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI6dd6110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6110),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06110  : dd6110 {
  int e;
  ~ee06110(); // tgen
  ee06110(); // tgen
};
//SIG(1 ee06110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee06110 ::~ee06110(){ note_dtor("ee06110", this);} // tgen
ee06110 ::ee06110(){ note_ctor("ee06110", this);} // tgen

static void Test_ee06110()
{
  extern Class_Descriptor cd_ee06110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee06110, buf);
    ee06110 *dp, &lv = *(dp=new (buf) ee06110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee06110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee06110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(24,16), "ee06110");
    check_base_class_offset(lv, (cc110*)(dd6110*), 0, "ee06110");
    check_base_class_offset(lv, (dd6110*), 0, "ee06110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06110.e");
    test_class_info(&lv, &cd_ee06110);
    dp->~ee06110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06110(Test_ee06110, "ee06110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee06110C1Ev();
extern void _ZN7ee06110D1Ev();
Name_Map name_map_ee06110[] = {
  NSPAIR(_ZN7ee06110C1Ev),
  NSPAIR(_ZN7ee06110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee06110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY vtc_ee06110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee06110[0]),
};
extern VTBL_ENTRY _ZTV7ee06110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee06110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee06110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee06110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee06110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee06110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee06110[] = {
  {&(_ZTV7ee06110[4]),  4,9},
  {&(_tg__ZTV6dd6110__7ee06110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee06110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee06110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee06110[3]),  3,3},
  {&(_ZTV7ee06110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee06110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee06110[];
extern  VTBL_ENTRY _ZTV7ee06110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06110[];
Class_Descriptor cd_ee06110 = {  "ee06110", // class name
  bases_ee06110, 4,
  &(vtc_ee06110[0]), // expected_vtbl_contents
  &(vtt_ee06110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee06110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16110  : virtual dd6110 {
  int e;
  ~ee16110(); // tgen
  ee16110(); // tgen
};
//SIG(1 ee16110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee16110 ::~ee16110(){ note_dtor("ee16110", this);} // tgen
ee16110 ::ee16110(){ note_ctor("ee16110", this);} // tgen

static void Test_ee16110()
{
  extern Class_Descriptor cd_ee16110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee16110, buf);
    ee16110 *dp, &lv = *(dp=new (buf) ee16110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee16110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee16110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(32,20), "ee16110");
    check_base_class_offset(lv, (cc110*)(dd6110*), ABISELECT(16,8), "ee16110");
    check_base_class_offset(lv, (dd6110*), ABISELECT(16,8), "ee16110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16110.e");
    test_class_info(&lv, &cd_ee16110);
    dp->~ee16110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16110(Test_ee16110, "ee16110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee16110C1Ev();
extern void _ZN7ee16110D1Ev();
Name_Map name_map_ee16110[] = {
  NSPAIR(_ZN7ee16110C1Ev),
  NSPAIR(_ZN7ee16110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee16110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY vtc_ee16110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16110[0]),
  0,
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee16110[0]),
};
extern VTBL_ENTRY _ZTV7ee16110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee16110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee16110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee16110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee16110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee16110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee16110[] = {
  {&(_ZTV7ee16110[5]),  5,16},
  {&(_ZTV7ee16110[11]),  11,16},
  {&(_ZTV7ee16110[16]),  16,16},
  {&(_tg__ZTV6dd6110__7ee16110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee16110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee16110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee16110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee16110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee16110[];
extern  VTBL_ENTRY _ZTV7ee16110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16110[];
Class_Descriptor cd_ee16110 = {  "ee16110", // class name
  bases_ee16110, 4,
  &(vtc_ee16110[0]), // expected_vtbl_contents
  &(vtt_ee16110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee16110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16110),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26110  : dd6110 {
  int e;
  virtual void  foo(); // _ZN7ee261103fooEv
  ~ee26110(); // tgen
  ee26110(); // tgen
};
//SIG(1 ee26110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26110 ::foo(){vfunc_called(this, "_ZN7ee261103fooEv");}
ee26110 ::~ee26110(){ note_dtor("ee26110", this);} // tgen
ee26110 ::ee26110(){ note_ctor("ee26110", this);} // tgen

static void Test_ee26110()
{
  extern Class_Descriptor cd_ee26110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee26110, buf);
    ee26110 *dp, &lv = *(dp=new (buf) ee26110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee26110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee26110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(24,16), "ee26110");
    check_base_class_offset(lv, (cc110*)(dd6110*), 0, "ee26110");
    check_base_class_offset(lv, (dd6110*), 0, "ee26110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26110.e");
    test_class_info(&lv, &cd_ee26110);
    dp->~ee26110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26110(Test_ee26110, "ee26110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee26110C1Ev();
extern void _ZN7ee26110D1Ev();
Name_Map name_map_ee26110[] = {
  NSPAIR(_ZN7ee26110C1Ev),
  NSPAIR(_ZN7ee26110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee26110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26110[];
extern void _ZN6dd61103barEv();
extern void _ZN7ee261103fooEv();
static  VTBL_ENTRY vtc_ee26110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN7ee261103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee26110[0]),
};
extern VTBL_ENTRY _ZTV7ee26110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee26110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee26110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee26110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee26110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee26110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee26110[] = {
  {&(_ZTV7ee26110[4]),  4,9},
  {&(_tg__ZTV6dd6110__7ee26110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee26110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee26110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee26110[3]),  3,3},
  {&(_ZTV7ee26110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee26110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee26110[];
extern  VTBL_ENTRY _ZTV7ee26110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26110[];
Class_Descriptor cd_ee26110 = {  "ee26110", // class name
  bases_ee26110, 4,
  &(vtc_ee26110[0]), // expected_vtbl_contents
  &(vtt_ee26110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee26110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36110  : virtual dd6110 {
  int e;
  virtual void  foo(); // _ZN7ee361103fooEv
  ~ee36110(); // tgen
  ee36110(); // tgen
};
//SIG(1 ee36110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36110 ::foo(){vfunc_called(this, "_ZN7ee361103fooEv");}
ee36110 ::~ee36110(){ note_dtor("ee36110", this);} // tgen
ee36110 ::ee36110(){ note_ctor("ee36110", this);} // tgen

static void Test_ee36110()
{
  extern Class_Descriptor cd_ee36110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee36110, buf);
    ee36110 *dp, &lv = *(dp=new (buf) ee36110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee36110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee36110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(32,20), "ee36110");
    check_base_class_offset(lv, (cc110*)(dd6110*), ABISELECT(16,8), "ee36110");
    check_base_class_offset(lv, (dd6110*), ABISELECT(16,8), "ee36110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36110.e");
    test_class_info(&lv, &cd_ee36110);
    dp->~ee36110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36110(Test_ee36110, "ee36110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee36110C1Ev();
extern void _ZN7ee36110D1Ev();
Name_Map name_map_ee36110[] = {
  NSPAIR(_ZN7ee36110C1Ev),
  NSPAIR(_ZN7ee36110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee36110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36110[];
extern void _ZN7ee361103fooEv();
extern void _ZN6dd61103barEv();
extern void ABISELECT(_ZTv0_n48_N7ee361103fooEv,_ZTv0_n24_N7ee361103fooEv)();
extern void ABISELECT(_ZThn16_N7ee361103fooEv,_ZThn8_N7ee361103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36110[0]),
  (VTBL_ENTRY)&_ZN7ee361103fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee361103fooEv,_ZTv0_n24_N7ee361103fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee36110[0]),
};
extern VTBL_ENTRY _ZTV7ee36110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee36110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee36110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee36110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee36110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee36110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee36110[] = {
  {&(_ZTV7ee36110[5]),  5,17},
  {&(_ZTV7ee36110[12]),  12,17},
  {&(_ZTV7ee36110[17]),  17,17},
  {&(_tg__ZTV6dd6110__7ee36110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee36110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee36110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee36110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee36110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee36110[];
extern  VTBL_ENTRY _ZTV7ee36110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36110[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee361103fooEv,_ZTv0_n24_N7ee361103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361103fooEv,_ZThn8_N7ee361103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36110 = {  "ee36110", // class name
  bases_ee36110, 4,
  &(vtc_ee36110[0]), // expected_vtbl_contents
  &(vtt_ee36110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee36110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36110),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46110  : dd6110 {
  int e;
  virtual void  bar(); // _ZN7ee461103barEv
  ~ee46110(); // tgen
  ee46110(); // tgen
};
//SIG(1 ee46110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46110 ::bar(){vfunc_called(this, "_ZN7ee461103barEv");}
ee46110 ::~ee46110(){ note_dtor("ee46110", this);} // tgen
ee46110 ::ee46110(){ note_ctor("ee46110", this);} // tgen

static void Test_ee46110()
{
  extern Class_Descriptor cd_ee46110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee46110, buf);
    ee46110 *dp, &lv = *(dp=new (buf) ee46110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee46110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee46110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(24,16), "ee46110");
    check_base_class_offset(lv, (cc110*)(dd6110*), 0, "ee46110");
    check_base_class_offset(lv, (dd6110*), 0, "ee46110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46110.e");
    test_class_info(&lv, &cd_ee46110);
    dp->~ee46110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46110(Test_ee46110, "ee46110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee46110C1Ev();
extern void _ZN7ee46110D1Ev();
Name_Map name_map_ee46110[] = {
  NSPAIR(_ZN7ee46110C1Ev),
  NSPAIR(_ZN7ee46110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee46110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46110[];
extern void _ZN7ee461103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY vtc_ee46110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46110[0]),
  (VTBL_ENTRY)&_ZN7ee461103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee46110[0]),
};
extern VTBL_ENTRY _ZTV7ee46110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee46110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee46110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee46110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee46110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee46110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee46110[] = {
  {&(_ZTV7ee46110[4]),  4,9},
  {&(_tg__ZTV6dd6110__7ee46110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee46110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee46110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee46110[3]),  3,3},
  {&(_ZTV7ee46110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee46110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee46110[];
extern  VTBL_ENTRY _ZTV7ee46110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46110[];
Class_Descriptor cd_ee46110 = {  "ee46110", // class name
  bases_ee46110, 4,
  &(vtc_ee46110[0]), // expected_vtbl_contents
  &(vtt_ee46110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee46110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56110  : virtual dd6110 {
  int e;
  virtual void  bar(); // _ZN7ee561103barEv
  ~ee56110(); // tgen
  ee56110(); // tgen
};
//SIG(1 ee56110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56110 ::bar(){vfunc_called(this, "_ZN7ee561103barEv");}
ee56110 ::~ee56110(){ note_dtor("ee56110", this);} // tgen
ee56110 ::ee56110(){ note_ctor("ee56110", this);} // tgen

static void Test_ee56110()
{
  extern Class_Descriptor cd_ee56110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee56110, buf);
    ee56110 *dp, &lv = *(dp=new (buf) ee56110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee56110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee56110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(32,20), "ee56110");
    check_base_class_offset(lv, (cc110*)(dd6110*), ABISELECT(16,8), "ee56110");
    check_base_class_offset(lv, (dd6110*), ABISELECT(16,8), "ee56110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56110.e");
    test_class_info(&lv, &cd_ee56110);
    dp->~ee56110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56110(Test_ee56110, "ee56110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee56110C1Ev();
extern void _ZN7ee56110D1Ev();
Name_Map name_map_ee56110[] = {
  NSPAIR(_ZN7ee56110C1Ev),
  NSPAIR(_ZN7ee56110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee56110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56110[];
extern void _ZN7ee561103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee561103barEv,_ZTv0_n20_N7ee561103barEv)();
extern void ABISELECT(_ZThn16_N7ee561103barEv,_ZThn8_N7ee561103barEv)() __attribute__((weak));
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY vtc_ee56110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56110[0]),
  (VTBL_ENTRY)&_ZN7ee561103barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee561103barEv,_ZTv0_n20_N7ee561103barEv),
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee56110[0]),
};
extern VTBL_ENTRY _ZTV7ee56110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee56110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee56110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee56110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee56110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee56110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee56110[] = {
  {&(_ZTV7ee56110[5]),  5,17},
  {&(_ZTV7ee56110[12]),  12,17},
  {&(_ZTV7ee56110[17]),  17,17},
  {&(_tg__ZTV6dd6110__7ee56110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee56110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee56110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee56110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee56110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee56110[];
extern  VTBL_ENTRY _ZTV7ee56110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56110[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee561103barEv,_ZTv0_n20_N7ee561103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561103barEv,_ZThn8_N7ee561103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56110 = {  "ee56110", // class name
  bases_ee56110, 4,
  &(vtc_ee56110[0]), // expected_vtbl_contents
  &(vtt_ee56110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee56110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56110),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66110  : dd6110 {
  int e;
  virtual void  foo(); // _ZN7ee661103fooEv
  virtual void  bar(); // _ZN7ee661103barEv
  ~ee66110(); // tgen
  ee66110(); // tgen
};
//SIG(1 ee66110) C1{ BC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66110 ::foo(){vfunc_called(this, "_ZN7ee661103fooEv");}
void  ee66110 ::bar(){vfunc_called(this, "_ZN7ee661103barEv");}
ee66110 ::~ee66110(){ note_dtor("ee66110", this);} // tgen
ee66110 ::ee66110(){ note_ctor("ee66110", this);} // tgen

static void Test_ee66110()
{
  extern Class_Descriptor cd_ee66110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee66110, buf);
    ee66110 *dp, &lv = *(dp=new (buf) ee66110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee66110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(36,24), "ee66110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(24,16), "ee66110");
    check_base_class_offset(lv, (cc110*)(dd6110*), 0, "ee66110");
    check_base_class_offset(lv, (dd6110*), 0, "ee66110");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66110.e");
    test_class_info(&lv, &cd_ee66110);
    dp->~ee66110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66110(Test_ee66110, "ee66110", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee66110C1Ev();
extern void _ZN7ee66110D1Ev();
Name_Map name_map_ee66110[] = {
  NSPAIR(_ZN7ee66110C1Ev),
  NSPAIR(_ZN7ee66110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee66110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66110[];
extern void _ZN7ee661103barEv();
extern void _ZN7ee661103fooEv();
static  VTBL_ENTRY vtc_ee66110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66110[0]),
  (VTBL_ENTRY)&_ZN7ee661103barEv,
  (VTBL_ENTRY)&_ZN7ee661103fooEv,
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI7ee66110[0]),
};
extern VTBL_ENTRY _ZTV7ee66110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee66110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee66110[] = {
  ABISELECT(36,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee66110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee66110[] = {
  ABISELECT(12,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee66110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee66110[] = {
  {&(_ZTV7ee66110[4]),  4,9},
  {&(_tg__ZTV6dd6110__7ee66110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee66110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee66110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee66110[3]),  3,3},
  {&(_ZTV7ee66110[9]),  9,9},
  {&(_tg__ZTV4bb10__7ee66110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee66110[];
extern  VTBL_ENTRY _ZTV7ee66110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66110[];
Class_Descriptor cd_ee66110 = {  "ee66110", // class name
  bases_ee66110, 4,
  &(vtc_ee66110[0]), // expected_vtbl_contents
  &(vtt_ee66110[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee66110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66110),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66110),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76110  : virtual dd6110 {
  int e;
  virtual void  foo(); // _ZN7ee761103fooEv
  virtual void  bar(); // _ZN7ee761103barEv
  ~ee76110(); // tgen
  ee76110(); // tgen
};
//SIG(1 ee76110) C1{ VBC2{ BC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76110 ::foo(){vfunc_called(this, "_ZN7ee761103fooEv");}
void  ee76110 ::bar(){vfunc_called(this, "_ZN7ee761103barEv");}
ee76110 ::~ee76110(){ note_dtor("ee76110", this);} // tgen
ee76110 ::ee76110(){ note_ctor("ee76110", this);} // tgen

static void Test_ee76110()
{
  extern Class_Descriptor cd_ee76110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee76110, buf);
    ee76110 *dp, &lv = *(dp=new (buf) ee76110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee76110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee76110");
    check_base_class_offset(lv, (bb10*)(cc110*)(dd6110*), ABISELECT(32,20), "ee76110");
    check_base_class_offset(lv, (cc110*)(dd6110*), ABISELECT(16,8), "ee76110");
    check_base_class_offset(lv, (dd6110*), ABISELECT(16,8), "ee76110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76110.e");
    test_class_info(&lv, &cd_ee76110);
    dp->~ee76110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76110(Test_ee76110, "ee76110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee76110C1Ev();
extern void _ZN7ee76110D1Ev();
Name_Map name_map_ee76110[] = {
  NSPAIR(_ZN7ee76110C1Ev),
  NSPAIR(_ZN7ee76110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd6110;
extern VTBL_ENTRY _ZTI6dd6110[];
extern  VTBL_ENTRY _ZTV6dd6110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6110[];
static Base_Class bases_ee76110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76110[];
extern void _ZN7ee761103fooEv();
extern void _ZN7ee761103barEv();
extern void ABISELECT(_ZTv0_n40_N7ee761103barEv,_ZTv0_n20_N7ee761103barEv)();
extern void ABISELECT(_ZThn16_N7ee761103barEv,_ZThn8_N7ee761103barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee761103fooEv,_ZTv0_n24_N7ee761103fooEv)();
extern void ABISELECT(_ZThn16_N7ee761103fooEv,_ZThn8_N7ee761103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76110[0]),
  (VTBL_ENTRY)&_ZN7ee761103fooEv,
  (VTBL_ENTRY)&_ZN7ee761103barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(28,20),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761103barEv,_ZTv0_n20_N7ee761103barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee761103fooEv,_ZTv0_n24_N7ee761103fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee76110[0]),
};
extern VTBL_ENTRY _ZTV7ee76110[];
extern void _ZN6dd61103barEv();
extern void _ZN6dd61103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6110__7ee76110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
  (VTBL_ENTRY)&_ZN6dd61103barEv,
  (VTBL_ENTRY)&_ZN6dd61103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1106dd6110__7ee76110[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc1106dd6110__7ee76110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd6110__7ee76110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd6110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee76110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee76110[] = {
  {&(_ZTV7ee76110[5]),  5,18},
  {&(_ZTV7ee76110[13]),  13,18},
  {&(_ZTV7ee76110[18]),  18,18},
  {&(_tg__ZTV6dd6110__7ee76110[4]),  4,6},
  {&(_tg__ZTV5cc1106dd6110__7ee76110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc1106dd6110__7ee76110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd6110__7ee76110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee76110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee76110[];
extern  VTBL_ENTRY _ZTV7ee76110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76110[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee761103fooEv,_ZTv0_n24_N7ee761103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761103fooEv,_ZThn8_N7ee761103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761103barEv,_ZTv0_n20_N7ee761103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761103barEv,_ZThn8_N7ee761103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76110 = {  "ee76110", // class name
  bases_ee76110, 4,
  &(vtc_ee76110[0]), // expected_vtbl_contents
  &(vtt_ee76110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee76110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76110),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76110),8, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7110  : virtual cc110 {
  int d;
  virtual void  bar(); // _ZN6dd71103barEv
  virtual void  foo(); // _ZN6dd71103fooEv
  ~dd7110(); // tgen
  dd7110(); // tgen
};
//SIG(-1 dd7110) C1{ VBC2{ VBC3{ VBC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd7110 ::bar(){vfunc_called(this, "_ZN6dd71103barEv");}
void  dd7110 ::foo(){vfunc_called(this, "_ZN6dd71103fooEv");}
dd7110 ::~dd7110(){ note_dtor("dd7110", this);} // tgen
dd7110 ::dd7110(){ note_ctor("dd7110", this);} // tgen

static void Test_dd7110()
{
  extern Class_Descriptor cd_dd7110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_dd7110, buf);
    dd7110 *dp, &lv = *(dp=new (buf) dd7110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(dd7110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,24), "dd7110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,16), "dd7110");
    check_base_class_offset(lv, (cc110*), ABISELECT(16,8), "dd7110");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7110.d");
    test_class_info(&lv, &cd_dd7110);
    dp->~dd7110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7110(Test_dd7110, "dd7110", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN6dd7110C1Ev();
extern void _ZN6dd7110D1Ev();
Name_Map name_map_dd7110[] = {
  NSPAIR(_ZN6dd7110C1Ev),
  NSPAIR(_ZN6dd7110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
static Base_Class bases_dd7110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY vtc_dd7110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
extern VTBL_ENTRY _ZTV6dd7110[];
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__6dd7110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd7110[] = {
  {&(_ZTV6dd7110[5]),  5,14},
  {&(_ZTV6dd7110[11]),  11,14},
  {&(_ZTV6dd7110[14]),  14,14},
  {&(_tg__ZTV5cc110__6dd7110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__6dd7110[3]),  3,3},
  {&(_tg__ZTV4bb10__6dd7110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
Class_Descriptor cd_dd7110 = {  "dd7110", // class name
  bases_dd7110, 3,
  &(vtc_dd7110[0]), // expected_vtbl_contents
  &(vtt_dd7110[0]), // expected_vtt_contents
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI6dd7110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7110),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07110  : dd7110 {
  int e;
  ~ee07110(); // tgen
  ee07110(); // tgen
};
//SIG(1 ee07110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee07110 ::~ee07110(){ note_dtor("ee07110", this);} // tgen
ee07110 ::ee07110(){ note_ctor("ee07110", this);} // tgen

static void Test_ee07110()
{
  extern Class_Descriptor cd_ee07110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee07110, buf);
    ee07110 *dp, &lv = *(dp=new (buf) ee07110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee07110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee07110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee07110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(16,12), "ee07110");
    check_base_class_offset(lv, (dd7110*), 0, "ee07110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07110.e");
    test_class_info(&lv, &cd_ee07110);
    dp->~ee07110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07110(Test_ee07110, "ee07110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee07110C1Ev();
extern void _ZN7ee07110D1Ev();
Name_Map name_map_ee07110[] = {
  NSPAIR(_ZN7ee07110C1Ev),
  NSPAIR(_ZN7ee07110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee07110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY vtc_ee07110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee07110[0]),
};
extern VTBL_ENTRY _ZTV7ee07110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee07110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee07110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee07110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee07110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee07110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee07110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee07110[] = {
  {&(_ZTV7ee07110[5]),  5,14},
  {&(_tg__ZTV6dd7110__7ee07110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee07110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee07110[3]),  3,3},
  {&(_ZTV7ee07110[11]),  11,14},
  {&(_ZTV7ee07110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee07110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee07110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee07110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee07110[];
extern  VTBL_ENTRY _ZTV7ee07110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07110[];
Class_Descriptor cd_ee07110 = {  "ee07110", // class name
  bases_ee07110, 4,
  &(vtc_ee07110[0]), // expected_vtbl_contents
  &(vtt_ee07110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee07110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17110  : virtual dd7110 {
  int e;
  ~ee17110(); // tgen
  ee17110(); // tgen
};
//SIG(1 ee17110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee17110 ::~ee17110(){ note_dtor("ee17110", this);} // tgen
ee17110 ::ee17110(){ note_ctor("ee17110", this);} // tgen

static void Test_ee17110()
{
  extern Class_Descriptor cd_ee17110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee17110, buf);
    ee17110 *dp, &lv = *(dp=new (buf) ee17110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee17110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee17110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee17110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(32,16), "ee17110");
    check_base_class_offset(lv, (dd7110*), ABISELECT(16,8), "ee17110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17110.e");
    test_class_info(&lv, &cd_ee17110);
    dp->~ee17110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17110(Test_ee17110, "ee17110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee17110C1Ev();
extern void _ZN7ee17110D1Ev();
Name_Map name_map_ee17110[] = {
  NSPAIR(_ZN7ee17110C1Ev),
  NSPAIR(_ZN7ee17110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee17110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY vtc_ee17110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17110[0]),
  0,
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee17110[0]),
};
extern VTBL_ENTRY _ZTV7ee17110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee17110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee17110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee17110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee17110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee17110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee17110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee17110[] = {
  {&(_ZTV7ee17110[6]),  6,22},
  {&(_ZTV7ee17110[13]),  13,22},
  {&(_ZTV7ee17110[19]),  19,22},
  {&(_ZTV7ee17110[22]),  22,22},
  {&(_tg__ZTV6dd7110__7ee17110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee17110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee17110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee17110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee17110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee17110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee17110[];
extern  VTBL_ENTRY _ZTV7ee17110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17110[];
Class_Descriptor cd_ee17110 = {  "ee17110", // class name
  bases_ee17110, 4,
  &(vtc_ee17110[0]), // expected_vtbl_contents
  &(vtt_ee17110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee17110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17110),22, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27110  : dd7110 {
  int e;
  virtual void  foo(); // _ZN7ee271103fooEv
  ~ee27110(); // tgen
  ee27110(); // tgen
};
//SIG(1 ee27110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27110 ::foo(){vfunc_called(this, "_ZN7ee271103fooEv");}
ee27110 ::~ee27110(){ note_dtor("ee27110", this);} // tgen
ee27110 ::ee27110(){ note_ctor("ee27110", this);} // tgen

static void Test_ee27110()
{
  extern Class_Descriptor cd_ee27110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee27110, buf);
    ee27110 *dp, &lv = *(dp=new (buf) ee27110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee27110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee27110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee27110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(16,12), "ee27110");
    check_base_class_offset(lv, (dd7110*), 0, "ee27110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27110.e");
    test_class_info(&lv, &cd_ee27110);
    dp->~ee27110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27110(Test_ee27110, "ee27110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee27110C1Ev();
extern void _ZN7ee27110D1Ev();
Name_Map name_map_ee27110[] = {
  NSPAIR(_ZN7ee27110C1Ev),
  NSPAIR(_ZN7ee27110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee27110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27110[];
extern void _ZN6dd71103barEv();
extern void _ZN7ee271103fooEv();
static  VTBL_ENTRY vtc_ee27110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN7ee271103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee27110[0]),
};
extern VTBL_ENTRY _ZTV7ee27110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee27110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee27110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee27110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee27110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee27110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee27110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee27110[] = {
  {&(_ZTV7ee27110[5]),  5,14},
  {&(_tg__ZTV6dd7110__7ee27110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee27110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee27110[3]),  3,3},
  {&(_ZTV7ee27110[11]),  11,14},
  {&(_ZTV7ee27110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee27110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee27110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee27110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee27110[];
extern  VTBL_ENTRY _ZTV7ee27110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27110[];
Class_Descriptor cd_ee27110 = {  "ee27110", // class name
  bases_ee27110, 4,
  &(vtc_ee27110[0]), // expected_vtbl_contents
  &(vtt_ee27110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee27110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37110  : virtual dd7110 {
  int e;
  virtual void  foo(); // _ZN7ee371103fooEv
  ~ee37110(); // tgen
  ee37110(); // tgen
};
//SIG(1 ee37110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37110 ::foo(){vfunc_called(this, "_ZN7ee371103fooEv");}
ee37110 ::~ee37110(){ note_dtor("ee37110", this);} // tgen
ee37110 ::ee37110(){ note_ctor("ee37110", this);} // tgen

static void Test_ee37110()
{
  extern Class_Descriptor cd_ee37110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee37110, buf);
    ee37110 *dp, &lv = *(dp=new (buf) ee37110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee37110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee37110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee37110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(32,16), "ee37110");
    check_base_class_offset(lv, (dd7110*), ABISELECT(16,8), "ee37110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37110.e");
    test_class_info(&lv, &cd_ee37110);
    dp->~ee37110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37110(Test_ee37110, "ee37110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee37110C1Ev();
extern void _ZN7ee37110D1Ev();
Name_Map name_map_ee37110[] = {
  NSPAIR(_ZN7ee37110C1Ev),
  NSPAIR(_ZN7ee37110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee37110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37110[];
extern void _ZN7ee371103fooEv();
extern void _ZN6dd71103barEv();
extern void ABISELECT(_ZTv0_n56_N7ee371103fooEv,_ZTv0_n28_N7ee371103fooEv)();
extern void ABISELECT(_ZThn16_N7ee371103fooEv,_ZThn8_N7ee371103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37110[0]),
  (VTBL_ENTRY)&_ZN7ee371103fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee371103fooEv,_ZTv0_n28_N7ee371103fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee37110[0]),
};
extern VTBL_ENTRY _ZTV7ee37110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee37110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee37110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee37110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee37110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee37110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee37110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee37110[] = {
  {&(_ZTV7ee37110[6]),  6,23},
  {&(_ZTV7ee37110[14]),  14,23},
  {&(_ZTV7ee37110[20]),  20,23},
  {&(_ZTV7ee37110[23]),  23,23},
  {&(_tg__ZTV6dd7110__7ee37110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee37110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee37110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee37110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee37110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee37110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee37110[];
extern  VTBL_ENTRY _ZTV7ee37110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37110[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee371103fooEv,_ZTv0_n28_N7ee371103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371103fooEv,_ZThn8_N7ee371103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37110 = {  "ee37110", // class name
  bases_ee37110, 4,
  &(vtc_ee37110[0]), // expected_vtbl_contents
  &(vtt_ee37110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee37110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37110),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47110  : dd7110 {
  int e;
  virtual void  bar(); // _ZN7ee471103barEv
  ~ee47110(); // tgen
  ee47110(); // tgen
};
//SIG(1 ee47110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47110 ::bar(){vfunc_called(this, "_ZN7ee471103barEv");}
ee47110 ::~ee47110(){ note_dtor("ee47110", this);} // tgen
ee47110 ::ee47110(){ note_ctor("ee47110", this);} // tgen

static void Test_ee47110()
{
  extern Class_Descriptor cd_ee47110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee47110, buf);
    ee47110 *dp, &lv = *(dp=new (buf) ee47110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee47110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee47110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee47110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(16,12), "ee47110");
    check_base_class_offset(lv, (dd7110*), 0, "ee47110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47110.e");
    test_class_info(&lv, &cd_ee47110);
    dp->~ee47110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47110(Test_ee47110, "ee47110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee47110C1Ev();
extern void _ZN7ee47110D1Ev();
Name_Map name_map_ee47110[] = {
  NSPAIR(_ZN7ee47110C1Ev),
  NSPAIR(_ZN7ee47110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee47110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47110[];
extern void _ZN7ee471103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY vtc_ee47110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47110[0]),
  (VTBL_ENTRY)&_ZN7ee471103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee47110[0]),
};
extern VTBL_ENTRY _ZTV7ee47110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee47110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee47110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee47110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee47110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee47110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee47110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee47110[] = {
  {&(_ZTV7ee47110[5]),  5,14},
  {&(_tg__ZTV6dd7110__7ee47110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee47110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee47110[3]),  3,3},
  {&(_ZTV7ee47110[11]),  11,14},
  {&(_ZTV7ee47110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee47110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee47110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee47110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee47110[];
extern  VTBL_ENTRY _ZTV7ee47110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47110[];
Class_Descriptor cd_ee47110 = {  "ee47110", // class name
  bases_ee47110, 4,
  &(vtc_ee47110[0]), // expected_vtbl_contents
  &(vtt_ee47110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee47110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57110  : virtual dd7110 {
  int e;
  virtual void  bar(); // _ZN7ee571103barEv
  ~ee57110(); // tgen
  ee57110(); // tgen
};
//SIG(1 ee57110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57110 ::bar(){vfunc_called(this, "_ZN7ee571103barEv");}
ee57110 ::~ee57110(){ note_dtor("ee57110", this);} // tgen
ee57110 ::ee57110(){ note_ctor("ee57110", this);} // tgen

static void Test_ee57110()
{
  extern Class_Descriptor cd_ee57110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee57110, buf);
    ee57110 *dp, &lv = *(dp=new (buf) ee57110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee57110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee57110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee57110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(32,16), "ee57110");
    check_base_class_offset(lv, (dd7110*), ABISELECT(16,8), "ee57110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57110.e");
    test_class_info(&lv, &cd_ee57110);
    dp->~ee57110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57110(Test_ee57110, "ee57110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee57110C1Ev();
extern void _ZN7ee57110D1Ev();
Name_Map name_map_ee57110[] = {
  NSPAIR(_ZN7ee57110C1Ev),
  NSPAIR(_ZN7ee57110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee57110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57110[];
extern void _ZN7ee571103barEv();
extern void ABISELECT(_ZTv0_n48_N7ee571103barEv,_ZTv0_n24_N7ee571103barEv)();
extern void ABISELECT(_ZThn16_N7ee571103barEv,_ZThn8_N7ee571103barEv)() __attribute__((weak));
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY vtc_ee57110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57110[0]),
  (VTBL_ENTRY)&_ZN7ee571103barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee571103barEv,_ZTv0_n24_N7ee571103barEv),
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee57110[0]),
};
extern VTBL_ENTRY _ZTV7ee57110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee57110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee57110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee57110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee57110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee57110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee57110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee57110[] = {
  {&(_ZTV7ee57110[6]),  6,23},
  {&(_ZTV7ee57110[14]),  14,23},
  {&(_ZTV7ee57110[20]),  20,23},
  {&(_ZTV7ee57110[23]),  23,23},
  {&(_tg__ZTV6dd7110__7ee57110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee57110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee57110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee57110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee57110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee57110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee57110[];
extern  VTBL_ENTRY _ZTV7ee57110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57110[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee571103barEv,_ZTv0_n24_N7ee571103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571103barEv,_ZThn8_N7ee571103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57110 = {  "ee57110", // class name
  bases_ee57110, 4,
  &(vtc_ee57110[0]), // expected_vtbl_contents
  &(vtt_ee57110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee57110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57110),23, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67110  : dd7110 {
  int e;
  virtual void  foo(); // _ZN7ee671103fooEv
  virtual void  bar(); // _ZN7ee671103barEv
  ~ee67110(); // tgen
  ee67110(); // tgen
};
//SIG(1 ee67110) C1{ BC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67110 ::foo(){vfunc_called(this, "_ZN7ee671103fooEv");}
void  ee67110 ::bar(){vfunc_called(this, "_ZN7ee671103barEv");}
ee67110 ::~ee67110(){ note_dtor("ee67110", this);} // tgen
ee67110 ::ee67110(){ note_ctor("ee67110", this);} // tgen

static void Test_ee67110()
{
  extern Class_Descriptor cd_ee67110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_ee67110, buf);
    ee67110 *dp, &lv = *(dp=new (buf) ee67110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(ee67110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(44,28), "ee67110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(32,20), "ee67110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(16,12), "ee67110");
    check_base_class_offset(lv, (dd7110*), 0, "ee67110");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67110.e");
    test_class_info(&lv, &cd_ee67110);
    dp->~ee67110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67110(Test_ee67110, "ee67110", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7ee67110C1Ev();
extern void _ZN7ee67110D1Ev();
Name_Map name_map_ee67110[] = {
  NSPAIR(_ZN7ee67110C1Ev),
  NSPAIR(_ZN7ee67110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee67110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67110[];
extern void _ZN7ee671103barEv();
extern void _ZN7ee671103fooEv();
static  VTBL_ENTRY vtc_ee67110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67110[0]),
  (VTBL_ENTRY)&_ZN7ee671103barEv,
  (VTBL_ENTRY)&_ZN7ee671103fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67110[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI7ee67110[0]),
};
extern VTBL_ENTRY _ZTV7ee67110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee67110[] = {
  ABISELECT(44,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee67110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee67110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee67110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee67110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee67110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee67110[] = {
  {&(_ZTV7ee67110[5]),  5,14},
  {&(_tg__ZTV6dd7110__7ee67110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee67110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee67110[3]),  3,3},
  {&(_ZTV7ee67110[11]),  11,14},
  {&(_ZTV7ee67110[14]),  14,14},
  {&(_tg__ZTV5cc110__7ee67110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee67110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee67110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee67110[];
extern  VTBL_ENTRY _ZTV7ee67110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67110[];
Class_Descriptor cd_ee67110 = {  "ee67110", // class name
  bases_ee67110, 4,
  &(vtc_ee67110[0]), // expected_vtbl_contents
  &(vtt_ee67110[0]), // expected_vtt_contents
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7ee67110),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67110),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67110),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77110  : virtual dd7110 {
  int e;
  virtual void  foo(); // _ZN7ee771103fooEv
  virtual void  bar(); // _ZN7ee771103barEv
  ~ee77110(); // tgen
  ee77110(); // tgen
};
//SIG(1 ee77110) C1{ VBC2{ VBC3{ VBC4{ VBC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77110 ::foo(){vfunc_called(this, "_ZN7ee771103fooEv");}
void  ee77110 ::bar(){vfunc_called(this, "_ZN7ee771103barEv");}
ee77110 ::~ee77110(){ note_dtor("ee77110", this);} // tgen
ee77110 ::ee77110(){ note_ctor("ee77110", this);} // tgen

static void Test_ee77110()
{
  extern Class_Descriptor cd_ee77110;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_ee77110, buf);
    ee77110 *dp, &lv = *(dp=new (buf) ee77110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(ee77110)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77110)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(60,32), "ee77110");
    check_base_class_offset(lv, (bb10*)(cc110*), ABISELECT(48,24), "ee77110");
    check_base_class_offset(lv, (cc110*)(dd7110*), ABISELECT(32,16), "ee77110");
    check_base_class_offset(lv, (dd7110*), ABISELECT(16,8), "ee77110");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77110.e");
    test_class_info(&lv, &cd_ee77110);
    dp->~ee77110();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77110(Test_ee77110, "ee77110", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN7ee77110C1Ev();
extern void _ZN7ee77110D1Ev();
Name_Map name_map_ee77110[] = {
  NSPAIR(_ZN7ee77110C1Ev),
  NSPAIR(_ZN7ee77110D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc110;
extern VTBL_ENTRY _ZTI5cc110[];
extern  VTBL_ENTRY _ZTV5cc110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc110[];
extern Class_Descriptor cd_dd7110;
extern VTBL_ENTRY _ZTI6dd7110[];
extern  VTBL_ENTRY _ZTV6dd7110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7110[];
static Base_Class bases_ee77110[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(60,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(48,24), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc110,    ABISELECT(32,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7110,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77110[];
extern void _ZN7ee771103fooEv();
extern void _ZN7ee771103barEv();
extern void ABISELECT(_ZTv0_n48_N7ee771103barEv,_ZTv0_n24_N7ee771103barEv)();
extern void ABISELECT(_ZThn16_N7ee771103barEv,_ZThn8_N7ee771103barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7ee771103fooEv,_ZTv0_n28_N7ee771103fooEv)();
extern void ABISELECT(_ZThn16_N7ee771103fooEv,_ZThn8_N7ee771103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77110[] = {
  ABISELECT(60,32),
  ABISELECT(48,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77110[0]),
  (VTBL_ENTRY)&_ZN7ee771103fooEv,
  (VTBL_ENTRY)&_ZN7ee771103barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77110[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771103barEv,_ZTv0_n24_N7ee771103barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7ee771103fooEv,_ZTv0_n28_N7ee771103fooEv),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77110[0]),
  ABISELECT(12,8),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7ee77110[0]),
};
extern VTBL_ENTRY _ZTV7ee77110[];
extern void _ZN6dd71103barEv();
extern void _ZN6dd71103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7110__7ee77110[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
  (VTBL_ENTRY)&_ZN6dd71103barEv,
  (VTBL_ENTRY)&_ZN6dd71103fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc110__6dd7110__7ee77110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__6dd7110__7ee77110[] = {
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI6dd7110[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc110__7ee77110[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__5cc110__7ee77110[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI5cc110[0]),
};
static  VTBL_ENTRY _tg__ZTV4bb10__7ee77110[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee77110[] = {
  {&(_ZTV7ee77110[6]),  6,24},
  {&(_ZTV7ee77110[15]),  15,24},
  {&(_ZTV7ee77110[21]),  21,24},
  {&(_ZTV7ee77110[24]),  24,24},
  {&(_tg__ZTV6dd7110__7ee77110[5]),  5,7},
  {&(_tg__ZTV5cc110__6dd7110__7ee77110[4]),  4,4},
  {&(_tg__ZTV4bb10__6dd7110__7ee77110[3]),  3,3},
  {&(_tg__ZTV5cc110__7ee77110[4]),  4,4},
  {&(_tg__ZTV4bb10__5cc110__7ee77110[3]),  3,3},
  {&(_tg__ZTV4bb10__7ee77110[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee77110[];
extern  VTBL_ENTRY _ZTV7ee77110[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77110[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7ee771103fooEv,_ZTv0_n28_N7ee771103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771103fooEv,_ZThn8_N7ee771103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771103barEv,_ZTv0_n24_N7ee771103barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771103barEv,_ZThn8_N7ee771103barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77110 = {  "ee77110", // class name
  bases_ee77110, 4,
  &(vtc_ee77110[0]), // expected_vtbl_contents
  &(vtt_ee77110[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI7ee77110),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77110),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77110),10, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc210  : bb10 {
  int c;
  virtual void  foo(); // _ZN5cc2103fooEv
  ~cc210(); // tgen
  cc210(); // tgen
};
//SIG(-1 cc210) C1{ BC2{ VBC3{ Fi} Fi} v1 Fi}


void  cc210 ::foo(){vfunc_called(this, "_ZN5cc2103fooEv");}
cc210 ::~cc210(){ note_dtor("cc210", this);} // tgen
cc210 ::cc210(){ note_ctor("cc210", this);} // tgen

static void Test_cc210()
{
  extern Class_Descriptor cd_cc210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc210, buf);
    cc210 *dp, &lv = *(dp=new (buf) cc210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc210)");
    check_base_class_offset(lv, (aa0*)(bb10*), ABISELECT(16,12), "cc210");
    check_base_class_offset(lv, (bb10*), 0, "cc210");
    check_field_offset(lv, c, ABISELECT(12,8), "cc210.c");
    test_class_info(&lv, &cd_cc210);
    dp->~cc210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc210(Test_cc210, "cc210", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc210C1Ev();
extern void _ZN5cc210D1Ev();
Name_Map name_map_cc210[] = {
  NSPAIR(_ZN5cc210C1Ev),
  NSPAIR(_ZN5cc210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
static Base_Class bases_cc210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_cc210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV5cc210[];
static  VTBL_ENTRY _tg__ZTV4bb10__5cc210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_cc210[] = {
  {&(_ZTV5cc210[3]),  3,4},
  {&(_tg__ZTV4bb10__5cc210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
Class_Descriptor cd_cc210 = {  "cc210", // class name
  bases_cc210, 2,
  &(vtc_cc210[0]), // expected_vtbl_contents
  &(vtt_cc210[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5cc210),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc210),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0210  : cc210 {
  int d;
  ~dd0210(); // tgen
  dd0210(); // tgen
};
//SIG(-1 dd0210) C1{ BC2{ BC3{ VBC4{ Fi} Fi} v1 Fi} Fi}


dd0210 ::~dd0210(){ note_dtor("dd0210", this);} // tgen
dd0210 ::dd0210(){ note_ctor("dd0210", this);} // tgen

static void Test_dd0210()
{
  extern Class_Descriptor cd_dd0210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0210, buf);
    dd0210 *dp, &lv = *(dp=new (buf) dd0210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(20,16), "dd0210");
    check_base_class_offset(lv, (bb10*)(cc210*), 0, "dd0210");
    check_base_class_offset(lv, (cc210*), 0, "dd0210");
    check_field_offset(lv, d, ABISELECT(16,12), "dd0210.d");
    test_class_info(&lv, &cd_dd0210);
    dp->~dd0210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0210(Test_dd0210, "dd0210", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0210C1Ev();
extern void _ZN6dd0210D1Ev();
Name_Map name_map_dd0210[] = {
  NSPAIR(_ZN6dd0210C1Ev),
  NSPAIR(_ZN6dd0210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
static Base_Class bases_dd0210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_dd0210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV6dd0210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd0210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__6dd0210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd0210[] = {
  {&(_ZTV6dd0210[3]),  3,4},
  {&(_tg__ZTV5cc210__6dd0210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__6dd0210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
Class_Descriptor cd_dd0210 = {  "dd0210", // class name
  bases_dd0210, 3,
  &(vtc_dd0210[0]), // expected_vtbl_contents
  &(vtt_dd0210[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0210),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0210),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00210  : dd0210 {
  int e;
  ~ee00210(); // tgen
  ee00210(); // tgen
};
//SIG(1 ee00210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee00210 ::~ee00210(){ note_dtor("ee00210", this);} // tgen
ee00210 ::ee00210(){ note_ctor("ee00210", this);} // tgen

static void Test_ee00210()
{
  extern Class_Descriptor cd_ee00210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00210, buf);
    ee00210 *dp, &lv = *(dp=new (buf) ee00210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(24,20), "ee00210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), 0, "ee00210");
    check_base_class_offset(lv, (cc210*)(dd0210*), 0, "ee00210");
    check_base_class_offset(lv, (dd0210*), 0, "ee00210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee00210.e");
    test_class_info(&lv, &cd_ee00210);
    dp->~ee00210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00210(Test_ee00210, "ee00210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00210C1Ev();
extern void _ZN7ee00210D1Ev();
Name_Map name_map_ee00210[] = {
  NSPAIR(_ZN7ee00210C1Ev),
  NSPAIR(_ZN7ee00210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee00210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_ee00210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV7ee00210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee00210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee00210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee00210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee00210[] = {
  {&(_ZTV7ee00210[3]),  3,4},
  {&(_tg__ZTV6dd0210__7ee00210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee00210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee00210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee00210[];
extern  VTBL_ENTRY _ZTV7ee00210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00210[];
Class_Descriptor cd_ee00210 = {  "ee00210", // class name
  bases_ee00210, 4,
  &(vtc_ee00210[0]), // expected_vtbl_contents
  &(vtt_ee00210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00210),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10210  : virtual dd0210 {
  int e;
  ~ee10210(); // tgen
  ee10210(); // tgen
};
//SIG(1 ee10210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee10210 ::~ee10210(){ note_dtor("ee10210", this);} // tgen
ee10210 ::ee10210(){ note_ctor("ee10210", this);} // tgen

static void Test_ee10210()
{
  extern Class_Descriptor cd_ee10210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10210, buf);
    ee10210 *dp, &lv = *(dp=new (buf) ee10210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(36,24), "ee10210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), ABISELECT(16,8), "ee10210");
    check_base_class_offset(lv, (cc210*)(dd0210*), ABISELECT(16,8), "ee10210");
    check_base_class_offset(lv, (dd0210*), ABISELECT(16,8), "ee10210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10210.e");
    test_class_info(&lv, &cd_ee10210);
    dp->~ee10210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10210(Test_ee10210, "ee10210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10210C1Ev();
extern void _ZN7ee10210D1Ev();
Name_Map name_map_ee10210[] = {
  NSPAIR(_ZN7ee10210C1Ev),
  NSPAIR(_ZN7ee10210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee10210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_ee10210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10210[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV7ee10210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee10210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee10210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee10210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee10210[] = {
  {&(_ZTV7ee10210[4]),  4,9},
  {&(_ZTV7ee10210[8]),  8,9},
  {&(_tg__ZTV6dd0210__7ee10210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee10210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee10210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee10210[];
extern  VTBL_ENTRY _ZTV7ee10210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10210[];
Class_Descriptor cd_ee10210 = {  "ee10210", // class name
  bases_ee10210, 4,
  &(vtc_ee10210[0]), // expected_vtbl_contents
  &(vtt_ee10210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10210),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20210  : dd0210 {
  int e;
  virtual void  foo(); // _ZN7ee202103fooEv
  ~ee20210(); // tgen
  ee20210(); // tgen
};
//SIG(1 ee20210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee20210 ::foo(){vfunc_called(this, "_ZN7ee202103fooEv");}
ee20210 ::~ee20210(){ note_dtor("ee20210", this);} // tgen
ee20210 ::ee20210(){ note_ctor("ee20210", this);} // tgen

static void Test_ee20210()
{
  extern Class_Descriptor cd_ee20210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20210, buf);
    ee20210 *dp, &lv = *(dp=new (buf) ee20210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(24,20), "ee20210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), 0, "ee20210");
    check_base_class_offset(lv, (cc210*)(dd0210*), 0, "ee20210");
    check_base_class_offset(lv, (dd0210*), 0, "ee20210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee20210.e");
    test_class_info(&lv, &cd_ee20210);
    dp->~ee20210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20210(Test_ee20210, "ee20210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20210C1Ev();
extern void _ZN7ee20210D1Ev();
Name_Map name_map_ee20210[] = {
  NSPAIR(_ZN7ee20210C1Ev),
  NSPAIR(_ZN7ee20210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee20210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20210[];
extern void _ZN7ee202103fooEv();
static  VTBL_ENTRY vtc_ee20210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20210[0]),
  (VTBL_ENTRY)&_ZN7ee202103fooEv,
};
extern VTBL_ENTRY _ZTV7ee20210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee20210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee20210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee20210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee20210[] = {
  {&(_ZTV7ee20210[3]),  3,4},
  {&(_tg__ZTV6dd0210__7ee20210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee20210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee20210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee20210[];
extern  VTBL_ENTRY _ZTV7ee20210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20210[];
Class_Descriptor cd_ee20210 = {  "ee20210", // class name
  bases_ee20210, 4,
  &(vtc_ee20210[0]), // expected_vtbl_contents
  &(vtt_ee20210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20210),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30210  : virtual dd0210 {
  int e;
  virtual void  foo(); // _ZN7ee302103fooEv
  ~ee30210(); // tgen
  ee30210(); // tgen
};
//SIG(1 ee30210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee30210 ::foo(){vfunc_called(this, "_ZN7ee302103fooEv");}
ee30210 ::~ee30210(){ note_dtor("ee30210", this);} // tgen
ee30210 ::ee30210(){ note_ctor("ee30210", this);} // tgen

static void Test_ee30210()
{
  extern Class_Descriptor cd_ee30210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30210, buf);
    ee30210 *dp, &lv = *(dp=new (buf) ee30210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(36,24), "ee30210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), ABISELECT(16,8), "ee30210");
    check_base_class_offset(lv, (cc210*)(dd0210*), ABISELECT(16,8), "ee30210");
    check_base_class_offset(lv, (dd0210*), ABISELECT(16,8), "ee30210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30210.e");
    test_class_info(&lv, &cd_ee30210);
    dp->~ee30210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30210(Test_ee30210, "ee30210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30210C1Ev();
extern void _ZN7ee30210D1Ev();
Name_Map name_map_ee30210[] = {
  NSPAIR(_ZN7ee30210C1Ev),
  NSPAIR(_ZN7ee30210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee30210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30210[];
extern void _ZN7ee302103fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee302103fooEv,_ZTv0_n16_N7ee302103fooEv)();
extern void ABISELECT(_ZThn16_N7ee302103fooEv,_ZThn8_N7ee302103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30210[0]),
  (VTBL_ENTRY)&_ZN7ee302103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee302103fooEv,_ZTv0_n16_N7ee302103fooEv),
};
extern VTBL_ENTRY _ZTV7ee30210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee30210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee30210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee30210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee30210[] = {
  {&(_ZTV7ee30210[4]),  4,10},
  {&(_ZTV7ee30210[9]),  9,10},
  {&(_tg__ZTV6dd0210__7ee30210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee30210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee30210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee30210[];
extern  VTBL_ENTRY _ZTV7ee30210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30210[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee302103fooEv,_ZTv0_n16_N7ee302103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302103fooEv,_ZThn8_N7ee302103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30210 = {  "ee30210", // class name
  bases_ee30210, 4,
  &(vtc_ee30210[0]), // expected_vtbl_contents
  &(vtt_ee30210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40210  : dd0210 {
  int e;
  virtual void  bar(); // _ZN7ee402103barEv
  ~ee40210(); // tgen
  ee40210(); // tgen
};
//SIG(1 ee40210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee40210 ::bar(){vfunc_called(this, "_ZN7ee402103barEv");}
ee40210 ::~ee40210(){ note_dtor("ee40210", this);} // tgen
ee40210 ::ee40210(){ note_ctor("ee40210", this);} // tgen

static void Test_ee40210()
{
  extern Class_Descriptor cd_ee40210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40210, buf);
    ee40210 *dp, &lv = *(dp=new (buf) ee40210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(24,20), "ee40210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), 0, "ee40210");
    check_base_class_offset(lv, (cc210*)(dd0210*), 0, "ee40210");
    check_base_class_offset(lv, (dd0210*), 0, "ee40210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee40210.e");
    test_class_info(&lv, &cd_ee40210);
    dp->~ee40210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40210(Test_ee40210, "ee40210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40210C1Ev();
extern void _ZN7ee40210D1Ev();
Name_Map name_map_ee40210[] = {
  NSPAIR(_ZN7ee40210C1Ev),
  NSPAIR(_ZN7ee40210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee40210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40210[];
extern void _ZN5cc2103fooEv();
extern void _ZN7ee402103barEv();
static  VTBL_ENTRY vtc_ee40210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
  (VTBL_ENTRY)&_ZN7ee402103barEv,
};
extern VTBL_ENTRY _ZTV7ee40210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee40210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee40210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee40210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee40210[] = {
  {&(_ZTV7ee40210[3]),  3,5},
  {&(_tg__ZTV6dd0210__7ee40210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee40210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee40210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee40210[];
extern  VTBL_ENTRY _ZTV7ee40210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40210[];
Class_Descriptor cd_ee40210 = {  "ee40210", // class name
  bases_ee40210, 4,
  &(vtc_ee40210[0]), // expected_vtbl_contents
  &(vtt_ee40210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40210),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50210  : virtual dd0210 {
  int e;
  virtual void  bar(); // _ZN7ee502103barEv
  ~ee50210(); // tgen
  ee50210(); // tgen
};
//SIG(1 ee50210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee50210 ::bar(){vfunc_called(this, "_ZN7ee502103barEv");}
ee50210 ::~ee50210(){ note_dtor("ee50210", this);} // tgen
ee50210 ::ee50210(){ note_ctor("ee50210", this);} // tgen

static void Test_ee50210()
{
  extern Class_Descriptor cd_ee50210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50210, buf);
    ee50210 *dp, &lv = *(dp=new (buf) ee50210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(36,24), "ee50210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), ABISELECT(16,8), "ee50210");
    check_base_class_offset(lv, (cc210*)(dd0210*), ABISELECT(16,8), "ee50210");
    check_base_class_offset(lv, (dd0210*), ABISELECT(16,8), "ee50210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50210.e");
    test_class_info(&lv, &cd_ee50210);
    dp->~ee50210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50210(Test_ee50210, "ee50210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50210C1Ev();
extern void _ZN7ee50210D1Ev();
Name_Map name_map_ee50210[] = {
  NSPAIR(_ZN7ee50210C1Ev),
  NSPAIR(_ZN7ee50210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee50210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50210[];
extern void _ZN7ee502103barEv();
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_ee50210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50210[0]),
  (VTBL_ENTRY)&_ZN7ee502103barEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV7ee50210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee50210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee50210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee50210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee50210[] = {
  {&(_ZTV7ee50210[4]),  4,10},
  {&(_ZTV7ee50210[9]),  9,10},
  {&(_tg__ZTV6dd0210__7ee50210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee50210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee50210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee50210[];
extern  VTBL_ENTRY _ZTV7ee50210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50210[];
Class_Descriptor cd_ee50210 = {  "ee50210", // class name
  bases_ee50210, 4,
  &(vtc_ee50210[0]), // expected_vtbl_contents
  &(vtt_ee50210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60210  : dd0210 {
  int e;
  virtual void  foo(); // _ZN7ee602103fooEv
  virtual void  bar(); // _ZN7ee602103barEv
  ~ee60210(); // tgen
  ee60210(); // tgen
};
//SIG(1 ee60210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee60210 ::foo(){vfunc_called(this, "_ZN7ee602103fooEv");}
void  ee60210 ::bar(){vfunc_called(this, "_ZN7ee602103barEv");}
ee60210 ::~ee60210(){ note_dtor("ee60210", this);} // tgen
ee60210 ::ee60210(){ note_ctor("ee60210", this);} // tgen

static void Test_ee60210()
{
  extern Class_Descriptor cd_ee60210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60210, buf);
    ee60210 *dp, &lv = *(dp=new (buf) ee60210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(24,20), "ee60210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), 0, "ee60210");
    check_base_class_offset(lv, (cc210*)(dd0210*), 0, "ee60210");
    check_base_class_offset(lv, (dd0210*), 0, "ee60210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee60210.e");
    test_class_info(&lv, &cd_ee60210);
    dp->~ee60210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60210(Test_ee60210, "ee60210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60210C1Ev();
extern void _ZN7ee60210D1Ev();
Name_Map name_map_ee60210[] = {
  NSPAIR(_ZN7ee60210C1Ev),
  NSPAIR(_ZN7ee60210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee60210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60210[];
extern void _ZN7ee602103fooEv();
extern void _ZN7ee602103barEv();
static  VTBL_ENTRY vtc_ee60210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60210[0]),
  (VTBL_ENTRY)&_ZN7ee602103fooEv,
  (VTBL_ENTRY)&_ZN7ee602103barEv,
};
extern VTBL_ENTRY _ZTV7ee60210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee60210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee60210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee60210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee60210[] = {
  {&(_ZTV7ee60210[3]),  3,5},
  {&(_tg__ZTV6dd0210__7ee60210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee60210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee60210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee60210[];
extern  VTBL_ENTRY _ZTV7ee60210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60210[];
Class_Descriptor cd_ee60210 = {  "ee60210", // class name
  bases_ee60210, 4,
  &(vtc_ee60210[0]), // expected_vtbl_contents
  &(vtt_ee60210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60210),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70210  : virtual dd0210 {
  int e;
  virtual void  foo(); // _ZN7ee702103fooEv
  virtual void  bar(); // _ZN7ee702103barEv
  ~ee70210(); // tgen
  ee70210(); // tgen
};
//SIG(1 ee70210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee70210 ::foo(){vfunc_called(this, "_ZN7ee702103fooEv");}
void  ee70210 ::bar(){vfunc_called(this, "_ZN7ee702103barEv");}
ee70210 ::~ee70210(){ note_dtor("ee70210", this);} // tgen
ee70210 ::ee70210(){ note_ctor("ee70210", this);} // tgen

static void Test_ee70210()
{
  extern Class_Descriptor cd_ee70210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70210, buf);
    ee70210 *dp, &lv = *(dp=new (buf) ee70210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd0210*), ABISELECT(36,24), "ee70210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd0210*), ABISELECT(16,8), "ee70210");
    check_base_class_offset(lv, (cc210*)(dd0210*), ABISELECT(16,8), "ee70210");
    check_base_class_offset(lv, (dd0210*), ABISELECT(16,8), "ee70210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70210.e");
    test_class_info(&lv, &cd_ee70210);
    dp->~ee70210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70210(Test_ee70210, "ee70210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70210C1Ev();
extern void _ZN7ee70210D1Ev();
Name_Map name_map_ee70210[] = {
  NSPAIR(_ZN7ee70210C1Ev),
  NSPAIR(_ZN7ee70210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd0210;
extern VTBL_ENTRY _ZTI6dd0210[];
extern  VTBL_ENTRY _ZTV6dd0210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0210[];
static Base_Class bases_ee70210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0210,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70210[];
extern void _ZN7ee702103fooEv();
extern void _ZN7ee702103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee702103fooEv,_ZTv0_n16_N7ee702103fooEv)();
extern void ABISELECT(_ZThn16_N7ee702103fooEv,_ZThn8_N7ee702103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70210[0]),
  (VTBL_ENTRY)&_ZN7ee702103fooEv,
  (VTBL_ENTRY)&_ZN7ee702103barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee702103fooEv,_ZTv0_n16_N7ee702103fooEv),
};
extern VTBL_ENTRY _ZTV7ee70210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd0210__7ee70210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd0210__7ee70210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd0210__7ee70210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee70210[] = {
  {&(_ZTV7ee70210[4]),  4,11},
  {&(_ZTV7ee70210[10]),  10,11},
  {&(_tg__ZTV6dd0210__7ee70210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd0210__7ee70210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd0210__7ee70210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee70210[];
extern  VTBL_ENTRY _ZTV7ee70210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70210[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee702103fooEv,_ZTv0_n16_N7ee702103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702103fooEv,_ZThn8_N7ee702103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70210 = {  "ee70210", // class name
  bases_ee70210, 4,
  &(vtc_ee70210[0]), // expected_vtbl_contents
  &(vtt_ee70210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70210),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1210  : virtual cc210 {
  int d;
  ~dd1210(); // tgen
  dd1210(); // tgen
};
//SIG(-1 dd1210) C1{ VBC2{ BC3{ VBC4{ Fi} Fi} v1 Fi} Fi}


dd1210 ::~dd1210(){ note_dtor("dd1210", this);} // tgen
dd1210 ::dd1210(){ note_ctor("dd1210", this);} // tgen

static void Test_dd1210()
{
  extern Class_Descriptor cd_dd1210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1210, buf);
    dd1210 *dp, &lv = *(dp=new (buf) dd1210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,20), "dd1210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,8), "dd1210");
    check_base_class_offset(lv, (cc210*), ABISELECT(16,8), "dd1210");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1210.d");
    test_class_info(&lv, &cd_dd1210);
    dp->~dd1210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1210(Test_dd1210, "dd1210", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1210C1Ev();
extern void _ZN6dd1210D1Ev();
Name_Map name_map_dd1210[] = {
  NSPAIR(_ZN6dd1210C1Ev),
  NSPAIR(_ZN6dd1210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
static Base_Class bases_dd1210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_dd1210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV6dd1210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__6dd1210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd1210[] = {
  {&(_ZTV6dd1210[4]),  4,9},
  {&(_ZTV6dd1210[8]),  8,9},
  {&(_tg__ZTV5cc210__6dd1210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__6dd1210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
Class_Descriptor cd_dd1210 = {  "dd1210", // class name
  bases_dd1210, 3,
  &(vtc_dd1210[0]), // expected_vtbl_contents
  &(vtt_dd1210[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1210),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1210),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01210  : dd1210 {
  int e;
  ~ee01210(); // tgen
  ee01210(); // tgen
};
//SIG(1 ee01210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee01210 ::~ee01210(){ note_dtor("ee01210", this);} // tgen
ee01210 ::ee01210(){ note_ctor("ee01210", this);} // tgen

static void Test_ee01210()
{
  extern Class_Descriptor cd_ee01210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01210, buf);
    ee01210 *dp, &lv = *(dp=new (buf) ee01210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee01210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee01210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(16,12), "ee01210");
    check_base_class_offset(lv, (dd1210*), 0, "ee01210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01210.e");
    test_class_info(&lv, &cd_ee01210);
    dp->~ee01210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01210(Test_ee01210, "ee01210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01210C1Ev();
extern void _ZN7ee01210D1Ev();
Name_Map name_map_ee01210[] = {
  NSPAIR(_ZN7ee01210C1Ev),
  NSPAIR(_ZN7ee01210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee01210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_ee01210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01210[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV7ee01210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee01210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee01210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee01210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee01210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee01210[] = {
  {&(_ZTV7ee01210[4]),  4,9},
  {&(_tg__ZTV6dd1210__7ee01210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee01210[4]),  4,5},
  {&(_ZTV7ee01210[8]),  8,9},
  {&(_tg__ZTV5cc210__7ee01210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee01210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee01210[];
extern  VTBL_ENTRY _ZTV7ee01210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01210[];
Class_Descriptor cd_ee01210 = {  "ee01210", // class name
  bases_ee01210, 4,
  &(vtc_ee01210[0]), // expected_vtbl_contents
  &(vtt_ee01210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01210),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11210  : virtual dd1210 {
  int e;
  ~ee11210(); // tgen
  ee11210(); // tgen
};
//SIG(1 ee11210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee11210 ::~ee11210(){ note_dtor("ee11210", this);} // tgen
ee11210 ::ee11210(){ note_ctor("ee11210", this);} // tgen

static void Test_ee11210()
{
  extern Class_Descriptor cd_ee11210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11210, buf);
    ee11210 *dp, &lv = *(dp=new (buf) ee11210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee11210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee11210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(32,16), "ee11210");
    check_base_class_offset(lv, (dd1210*), ABISELECT(16,8), "ee11210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11210.e");
    test_class_info(&lv, &cd_ee11210);
    dp->~ee11210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11210(Test_ee11210, "ee11210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11210C1Ev();
extern void _ZN7ee11210D1Ev();
Name_Map name_map_ee11210[] = {
  NSPAIR(_ZN7ee11210C1Ev),
  NSPAIR(_ZN7ee11210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee11210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_ee11210[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11210[0]),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11210[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV7ee11210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee11210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee11210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee11210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee11210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee11210[] = {
  {&(_ZTV7ee11210[5]),  5,14},
  {&(_ZTV7ee11210[9]),  9,14},
  {&(_ZTV7ee11210[13]),  13,14},
  {&(_tg__ZTV6dd1210__7ee11210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee11210[4]),  4,5},
  {&(_tg__ZTV5cc210__7ee11210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee11210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee11210[];
extern  VTBL_ENTRY _ZTV7ee11210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11210[];
Class_Descriptor cd_ee11210 = {  "ee11210", // class name
  bases_ee11210, 4,
  &(vtc_ee11210[0]), // expected_vtbl_contents
  &(vtt_ee11210[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11210),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11210),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21210  : dd1210 {
  int e;
  virtual void  foo(); // _ZN7ee212103fooEv
  ~ee21210(); // tgen
  ee21210(); // tgen
};
//SIG(1 ee21210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee21210 ::foo(){vfunc_called(this, "_ZN7ee212103fooEv");}
ee21210 ::~ee21210(){ note_dtor("ee21210", this);} // tgen
ee21210 ::ee21210(){ note_ctor("ee21210", this);} // tgen

static void Test_ee21210()
{
  extern Class_Descriptor cd_ee21210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21210, buf);
    ee21210 *dp, &lv = *(dp=new (buf) ee21210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee21210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee21210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(16,12), "ee21210");
    check_base_class_offset(lv, (dd1210*), 0, "ee21210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21210.e");
    test_class_info(&lv, &cd_ee21210);
    dp->~ee21210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21210(Test_ee21210, "ee21210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21210C1Ev();
extern void _ZN7ee21210D1Ev();
Name_Map name_map_ee21210[] = {
  NSPAIR(_ZN7ee21210C1Ev),
  NSPAIR(_ZN7ee21210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee21210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21210[];
extern void _ZN7ee212103fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee212103fooEv,_ZTv0_n16_N7ee212103fooEv)();
extern void ABISELECT(_ZThn16_N7ee212103fooEv,_ZThn12_N7ee212103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21210[0]),
  (VTBL_ENTRY)&_ZN7ee212103fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee212103fooEv,_ZTv0_n16_N7ee212103fooEv),
};
extern VTBL_ENTRY _ZTV7ee21210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee21210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee21210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee21210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee21210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee21210[] = {
  {&(_ZTV7ee21210[4]),  4,10},
  {&(_tg__ZTV6dd1210__7ee21210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee21210[4]),  4,5},
  {&(_ZTV7ee21210[9]),  9,10},
  {&(_tg__ZTV5cc210__7ee21210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee21210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee21210[];
extern  VTBL_ENTRY _ZTV7ee21210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21210[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee212103fooEv,_ZTv0_n16_N7ee212103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee212103fooEv,_ZThn12_N7ee212103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21210 = {  "ee21210", // class name
  bases_ee21210, 4,
  &(vtc_ee21210[0]), // expected_vtbl_contents
  &(vtt_ee21210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31210  : virtual dd1210 {
  int e;
  virtual void  foo(); // _ZN7ee312103fooEv
  ~ee31210(); // tgen
  ee31210(); // tgen
};
//SIG(1 ee31210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee31210 ::foo(){vfunc_called(this, "_ZN7ee312103fooEv");}
ee31210 ::~ee31210(){ note_dtor("ee31210", this);} // tgen
ee31210 ::ee31210(){ note_ctor("ee31210", this);} // tgen

static void Test_ee31210()
{
  extern Class_Descriptor cd_ee31210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31210, buf);
    ee31210 *dp, &lv = *(dp=new (buf) ee31210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee31210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee31210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(32,16), "ee31210");
    check_base_class_offset(lv, (dd1210*), ABISELECT(16,8), "ee31210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31210.e");
    test_class_info(&lv, &cd_ee31210);
    dp->~ee31210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31210(Test_ee31210, "ee31210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31210C1Ev();
extern void _ZN7ee31210D1Ev();
Name_Map name_map_ee31210[] = {
  NSPAIR(_ZN7ee31210C1Ev),
  NSPAIR(_ZN7ee31210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee31210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31210[];
extern void _ZN7ee312103fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee312103fooEv,_ZTv0_n16_N7ee312103fooEv)();
extern void ABISELECT(_ZThn32_N7ee312103fooEv,_ZThn16_N7ee312103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31210[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31210[0]),
  (VTBL_ENTRY)&_ZN7ee312103fooEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31210[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee312103fooEv,_ZTv0_n16_N7ee312103fooEv),
};
extern VTBL_ENTRY _ZTV7ee31210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee31210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee31210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee31210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee31210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee31210[] = {
  {&(_ZTV7ee31210[5]),  5,15},
  {&(_ZTV7ee31210[10]),  10,15},
  {&(_ZTV7ee31210[14]),  14,15},
  {&(_tg__ZTV6dd1210__7ee31210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee31210[4]),  4,5},
  {&(_tg__ZTV5cc210__7ee31210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee31210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee31210[];
extern  VTBL_ENTRY _ZTV7ee31210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31210[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee312103fooEv,_ZTv0_n16_N7ee312103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee312103fooEv,_ZThn16_N7ee312103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31210 = {  "ee31210", // class name
  bases_ee31210, 4,
  &(vtc_ee31210[0]), // expected_vtbl_contents
  &(vtt_ee31210[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31210),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31210),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41210  : dd1210 {
  int e;
  virtual void  bar(); // _ZN7ee412103barEv
  ~ee41210(); // tgen
  ee41210(); // tgen
};
//SIG(1 ee41210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee41210 ::bar(){vfunc_called(this, "_ZN7ee412103barEv");}
ee41210 ::~ee41210(){ note_dtor("ee41210", this);} // tgen
ee41210 ::ee41210(){ note_ctor("ee41210", this);} // tgen

static void Test_ee41210()
{
  extern Class_Descriptor cd_ee41210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41210, buf);
    ee41210 *dp, &lv = *(dp=new (buf) ee41210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee41210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee41210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(16,12), "ee41210");
    check_base_class_offset(lv, (dd1210*), 0, "ee41210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41210.e");
    test_class_info(&lv, &cd_ee41210);
    dp->~ee41210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41210(Test_ee41210, "ee41210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41210C1Ev();
extern void _ZN7ee41210D1Ev();
Name_Map name_map_ee41210[] = {
  NSPAIR(_ZN7ee41210C1Ev),
  NSPAIR(_ZN7ee41210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee41210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41210[];
extern void _ZN7ee412103barEv();
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_ee41210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41210[0]),
  (VTBL_ENTRY)&_ZN7ee412103barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV7ee41210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee41210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee41210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee41210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee41210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee41210[] = {
  {&(_ZTV7ee41210[4]),  4,10},
  {&(_tg__ZTV6dd1210__7ee41210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee41210[4]),  4,5},
  {&(_ZTV7ee41210[9]),  9,10},
  {&(_tg__ZTV5cc210__7ee41210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee41210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee41210[];
extern  VTBL_ENTRY _ZTV7ee41210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41210[];
Class_Descriptor cd_ee41210 = {  "ee41210", // class name
  bases_ee41210, 4,
  &(vtc_ee41210[0]), // expected_vtbl_contents
  &(vtt_ee41210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51210  : virtual dd1210 {
  int e;
  virtual void  bar(); // _ZN7ee512103barEv
  ~ee51210(); // tgen
  ee51210(); // tgen
};
//SIG(1 ee51210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee51210 ::bar(){vfunc_called(this, "_ZN7ee512103barEv");}
ee51210 ::~ee51210(){ note_dtor("ee51210", this);} // tgen
ee51210 ::ee51210(){ note_ctor("ee51210", this);} // tgen

static void Test_ee51210()
{
  extern Class_Descriptor cd_ee51210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51210, buf);
    ee51210 *dp, &lv = *(dp=new (buf) ee51210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee51210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee51210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(32,16), "ee51210");
    check_base_class_offset(lv, (dd1210*), ABISELECT(16,8), "ee51210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51210.e");
    test_class_info(&lv, &cd_ee51210);
    dp->~ee51210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51210(Test_ee51210, "ee51210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51210C1Ev();
extern void _ZN7ee51210D1Ev();
Name_Map name_map_ee51210[] = {
  NSPAIR(_ZN7ee51210C1Ev),
  NSPAIR(_ZN7ee51210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee51210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51210[];
extern void _ZN7ee512103barEv();
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY vtc_ee51210[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51210[0]),
  (VTBL_ENTRY)&_ZN7ee512103barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51210[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern VTBL_ENTRY _ZTV7ee51210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee51210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee51210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee51210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee51210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee51210[] = {
  {&(_ZTV7ee51210[5]),  5,15},
  {&(_ZTV7ee51210[10]),  10,15},
  {&(_ZTV7ee51210[14]),  14,15},
  {&(_tg__ZTV6dd1210__7ee51210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee51210[4]),  4,5},
  {&(_tg__ZTV5cc210__7ee51210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee51210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee51210[];
extern  VTBL_ENTRY _ZTV7ee51210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51210[];
Class_Descriptor cd_ee51210 = {  "ee51210", // class name
  bases_ee51210, 4,
  &(vtc_ee51210[0]), // expected_vtbl_contents
  &(vtt_ee51210[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51210),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51210),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61210  : dd1210 {
  int e;
  virtual void  foo(); // _ZN7ee612103fooEv
  virtual void  bar(); // _ZN7ee612103barEv
  ~ee61210(); // tgen
  ee61210(); // tgen
};
//SIG(1 ee61210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee61210 ::foo(){vfunc_called(this, "_ZN7ee612103fooEv");}
void  ee61210 ::bar(){vfunc_called(this, "_ZN7ee612103barEv");}
ee61210 ::~ee61210(){ note_dtor("ee61210", this);} // tgen
ee61210 ::ee61210(){ note_ctor("ee61210", this);} // tgen

static void Test_ee61210()
{
  extern Class_Descriptor cd_ee61210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61210, buf);
    ee61210 *dp, &lv = *(dp=new (buf) ee61210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee61210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee61210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(16,12), "ee61210");
    check_base_class_offset(lv, (dd1210*), 0, "ee61210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61210.e");
    test_class_info(&lv, &cd_ee61210);
    dp->~ee61210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61210(Test_ee61210, "ee61210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61210C1Ev();
extern void _ZN7ee61210D1Ev();
Name_Map name_map_ee61210[] = {
  NSPAIR(_ZN7ee61210C1Ev),
  NSPAIR(_ZN7ee61210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee61210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61210[];
extern void _ZN7ee612103fooEv();
extern void _ZN7ee612103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee612103fooEv,_ZTv0_n16_N7ee612103fooEv)();
extern void ABISELECT(_ZThn16_N7ee612103fooEv,_ZThn12_N7ee612103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61210[0]),
  (VTBL_ENTRY)&_ZN7ee612103fooEv,
  (VTBL_ENTRY)&_ZN7ee612103barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee612103fooEv,_ZTv0_n16_N7ee612103fooEv),
};
extern VTBL_ENTRY _ZTV7ee61210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee61210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee61210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee61210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee61210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee61210[] = {
  {&(_ZTV7ee61210[4]),  4,11},
  {&(_tg__ZTV6dd1210__7ee61210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee61210[4]),  4,5},
  {&(_ZTV7ee61210[10]),  10,11},
  {&(_tg__ZTV5cc210__7ee61210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee61210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee61210[];
extern  VTBL_ENTRY _ZTV7ee61210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61210[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee612103fooEv,_ZTv0_n16_N7ee612103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612103fooEv,_ZThn12_N7ee612103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61210 = {  "ee61210", // class name
  bases_ee61210, 4,
  &(vtc_ee61210[0]), // expected_vtbl_contents
  &(vtt_ee61210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61210),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71210  : virtual dd1210 {
  int e;
  virtual void  foo(); // _ZN7ee712103fooEv
  virtual void  bar(); // _ZN7ee712103barEv
  ~ee71210(); // tgen
  ee71210(); // tgen
};
//SIG(1 ee71210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee71210 ::foo(){vfunc_called(this, "_ZN7ee712103fooEv");}
void  ee71210 ::bar(){vfunc_called(this, "_ZN7ee712103barEv");}
ee71210 ::~ee71210(){ note_dtor("ee71210", this);} // tgen
ee71210 ::ee71210(){ note_ctor("ee71210", this);} // tgen

static void Test_ee71210()
{
  extern Class_Descriptor cd_ee71210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71210, buf);
    ee71210 *dp, &lv = *(dp=new (buf) ee71210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee71210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee71210");
    check_base_class_offset(lv, (cc210*)(dd1210*), ABISELECT(32,16), "ee71210");
    check_base_class_offset(lv, (dd1210*), ABISELECT(16,8), "ee71210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71210.e");
    test_class_info(&lv, &cd_ee71210);
    dp->~ee71210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71210(Test_ee71210, "ee71210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71210C1Ev();
extern void _ZN7ee71210D1Ev();
Name_Map name_map_ee71210[] = {
  NSPAIR(_ZN7ee71210C1Ev),
  NSPAIR(_ZN7ee71210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd1210;
extern VTBL_ENTRY _ZTI6dd1210[];
extern  VTBL_ENTRY _ZTV6dd1210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1210[];
static Base_Class bases_ee71210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1210,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71210[];
extern void _ZN7ee712103fooEv();
extern void _ZN7ee712103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee712103fooEv,_ZTv0_n16_N7ee712103fooEv)();
extern void ABISELECT(_ZThn32_N7ee712103fooEv,_ZThn16_N7ee712103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71210[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71210[0]),
  (VTBL_ENTRY)&_ZN7ee712103fooEv,
  (VTBL_ENTRY)&_ZN7ee712103barEv,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71210[0]),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee712103fooEv,_ZTv0_n16_N7ee712103fooEv),
};
extern VTBL_ENTRY _ZTV7ee71210[];
static  VTBL_ENTRY _tg__ZTV6dd1210__7ee71210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd1210__7ee71210[] = {
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee71210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee71210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee71210[] = {
  {&(_ZTV7ee71210[5]),  5,16},
  {&(_ZTV7ee71210[11]),  11,16},
  {&(_ZTV7ee71210[15]),  15,16},
  {&(_tg__ZTV6dd1210__7ee71210[4]),  4,4},
  {&(_tg__ZTV5cc210__6dd1210__7ee71210[4]),  4,5},
  {&(_tg__ZTV5cc210__7ee71210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee71210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee71210[];
extern  VTBL_ENTRY _ZTV7ee71210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71210[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee712103fooEv,_ZTv0_n16_N7ee712103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712103fooEv,_ZThn16_N7ee712103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71210 = {  "ee71210", // class name
  bases_ee71210, 4,
  &(vtc_ee71210[0]), // expected_vtbl_contents
  &(vtt_ee71210[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71210),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71210),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2210  : cc210 {
  int d;
  virtual void  foo(); // _ZN6dd22103fooEv
  ~dd2210(); // tgen
  dd2210(); // tgen
};
//SIG(-1 dd2210) C1{ BC2{ BC3{ VBC4{ Fi} Fi} v1 Fi} v1 Fi}


void  dd2210 ::foo(){vfunc_called(this, "_ZN6dd22103fooEv");}
dd2210 ::~dd2210(){ note_dtor("dd2210", this);} // tgen
dd2210 ::dd2210(){ note_ctor("dd2210", this);} // tgen

static void Test_dd2210()
{
  extern Class_Descriptor cd_dd2210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2210, buf);
    dd2210 *dp, &lv = *(dp=new (buf) dd2210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(20,16), "dd2210");
    check_base_class_offset(lv, (bb10*)(cc210*), 0, "dd2210");
    check_base_class_offset(lv, (cc210*), 0, "dd2210");
    check_field_offset(lv, d, ABISELECT(16,12), "dd2210.d");
    test_class_info(&lv, &cd_dd2210);
    dp->~dd2210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2210(Test_dd2210, "dd2210", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2210C1Ev();
extern void _ZN6dd2210D1Ev();
Name_Map name_map_dd2210[] = {
  NSPAIR(_ZN6dd2210C1Ev),
  NSPAIR(_ZN6dd2210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
static Base_Class bases_dd2210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY vtc_dd2210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern VTBL_ENTRY _ZTV6dd2210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd2210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__6dd2210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd2210[] = {
  {&(_ZTV6dd2210[3]),  3,4},
  {&(_tg__ZTV5cc210__6dd2210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__6dd2210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
Class_Descriptor cd_dd2210 = {  "dd2210", // class name
  bases_dd2210, 3,
  &(vtc_dd2210[0]), // expected_vtbl_contents
  &(vtt_dd2210[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2210),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2210),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02210  : dd2210 {
  int e;
  ~ee02210(); // tgen
  ee02210(); // tgen
};
//SIG(1 ee02210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee02210 ::~ee02210(){ note_dtor("ee02210", this);} // tgen
ee02210 ::ee02210(){ note_ctor("ee02210", this);} // tgen

static void Test_ee02210()
{
  extern Class_Descriptor cd_ee02210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02210, buf);
    ee02210 *dp, &lv = *(dp=new (buf) ee02210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(24,20), "ee02210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), 0, "ee02210");
    check_base_class_offset(lv, (cc210*)(dd2210*), 0, "ee02210");
    check_base_class_offset(lv, (dd2210*), 0, "ee02210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee02210.e");
    test_class_info(&lv, &cd_ee02210);
    dp->~ee02210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02210(Test_ee02210, "ee02210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02210C1Ev();
extern void _ZN7ee02210D1Ev();
Name_Map name_map_ee02210[] = {
  NSPAIR(_ZN7ee02210C1Ev),
  NSPAIR(_ZN7ee02210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee02210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY vtc_ee02210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern VTBL_ENTRY _ZTV7ee02210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee02210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee02210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee02210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee02210[] = {
  {&(_ZTV7ee02210[3]),  3,4},
  {&(_tg__ZTV6dd2210__7ee02210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee02210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee02210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee02210[];
extern  VTBL_ENTRY _ZTV7ee02210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02210[];
Class_Descriptor cd_ee02210 = {  "ee02210", // class name
  bases_ee02210, 4,
  &(vtc_ee02210[0]), // expected_vtbl_contents
  &(vtt_ee02210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02210),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12210  : virtual dd2210 {
  int e;
  ~ee12210(); // tgen
  ee12210(); // tgen
};
//SIG(1 ee12210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee12210 ::~ee12210(){ note_dtor("ee12210", this);} // tgen
ee12210 ::ee12210(){ note_ctor("ee12210", this);} // tgen

static void Test_ee12210()
{
  extern Class_Descriptor cd_ee12210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12210, buf);
    ee12210 *dp, &lv = *(dp=new (buf) ee12210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(36,24), "ee12210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), ABISELECT(16,8), "ee12210");
    check_base_class_offset(lv, (cc210*)(dd2210*), ABISELECT(16,8), "ee12210");
    check_base_class_offset(lv, (dd2210*), ABISELECT(16,8), "ee12210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12210.e");
    test_class_info(&lv, &cd_ee12210);
    dp->~ee12210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12210(Test_ee12210, "ee12210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12210C1Ev();
extern void _ZN7ee12210D1Ev();
Name_Map name_map_ee12210[] = {
  NSPAIR(_ZN7ee12210C1Ev),
  NSPAIR(_ZN7ee12210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee12210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY vtc_ee12210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12210[0]),
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern VTBL_ENTRY _ZTV7ee12210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee12210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee12210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee12210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee12210[] = {
  {&(_ZTV7ee12210[4]),  4,9},
  {&(_ZTV7ee12210[8]),  8,9},
  {&(_tg__ZTV6dd2210__7ee12210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee12210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee12210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee12210[];
extern  VTBL_ENTRY _ZTV7ee12210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12210[];
Class_Descriptor cd_ee12210 = {  "ee12210", // class name
  bases_ee12210, 4,
  &(vtc_ee12210[0]), // expected_vtbl_contents
  &(vtt_ee12210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12210),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22210  : dd2210 {
  int e;
  virtual void  foo(); // _ZN7ee222103fooEv
  ~ee22210(); // tgen
  ee22210(); // tgen
};
//SIG(1 ee22210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee22210 ::foo(){vfunc_called(this, "_ZN7ee222103fooEv");}
ee22210 ::~ee22210(){ note_dtor("ee22210", this);} // tgen
ee22210 ::ee22210(){ note_ctor("ee22210", this);} // tgen

static void Test_ee22210()
{
  extern Class_Descriptor cd_ee22210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22210, buf);
    ee22210 *dp, &lv = *(dp=new (buf) ee22210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(24,20), "ee22210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), 0, "ee22210");
    check_base_class_offset(lv, (cc210*)(dd2210*), 0, "ee22210");
    check_base_class_offset(lv, (dd2210*), 0, "ee22210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee22210.e");
    test_class_info(&lv, &cd_ee22210);
    dp->~ee22210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22210(Test_ee22210, "ee22210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22210C1Ev();
extern void _ZN7ee22210D1Ev();
Name_Map name_map_ee22210[] = {
  NSPAIR(_ZN7ee22210C1Ev),
  NSPAIR(_ZN7ee22210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee22210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22210[];
extern void _ZN7ee222103fooEv();
static  VTBL_ENTRY vtc_ee22210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22210[0]),
  (VTBL_ENTRY)&_ZN7ee222103fooEv,
};
extern VTBL_ENTRY _ZTV7ee22210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee22210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee22210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee22210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee22210[] = {
  {&(_ZTV7ee22210[3]),  3,4},
  {&(_tg__ZTV6dd2210__7ee22210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee22210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee22210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee22210[];
extern  VTBL_ENTRY _ZTV7ee22210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22210[];
Class_Descriptor cd_ee22210 = {  "ee22210", // class name
  bases_ee22210, 4,
  &(vtc_ee22210[0]), // expected_vtbl_contents
  &(vtt_ee22210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22210),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32210  : virtual dd2210 {
  int e;
  virtual void  foo(); // _ZN7ee322103fooEv
  ~ee32210(); // tgen
  ee32210(); // tgen
};
//SIG(1 ee32210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee32210 ::foo(){vfunc_called(this, "_ZN7ee322103fooEv");}
ee32210 ::~ee32210(){ note_dtor("ee32210", this);} // tgen
ee32210 ::ee32210(){ note_ctor("ee32210", this);} // tgen

static void Test_ee32210()
{
  extern Class_Descriptor cd_ee32210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32210, buf);
    ee32210 *dp, &lv = *(dp=new (buf) ee32210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(36,24), "ee32210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), ABISELECT(16,8), "ee32210");
    check_base_class_offset(lv, (cc210*)(dd2210*), ABISELECT(16,8), "ee32210");
    check_base_class_offset(lv, (dd2210*), ABISELECT(16,8), "ee32210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32210.e");
    test_class_info(&lv, &cd_ee32210);
    dp->~ee32210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32210(Test_ee32210, "ee32210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32210C1Ev();
extern void _ZN7ee32210D1Ev();
Name_Map name_map_ee32210[] = {
  NSPAIR(_ZN7ee32210C1Ev),
  NSPAIR(_ZN7ee32210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee32210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32210[];
extern void _ZN7ee322103fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee322103fooEv,_ZTv0_n16_N7ee322103fooEv)();
extern void ABISELECT(_ZThn16_N7ee322103fooEv,_ZThn8_N7ee322103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32210[0]),
  (VTBL_ENTRY)&_ZN7ee322103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee322103fooEv,_ZTv0_n16_N7ee322103fooEv),
};
extern VTBL_ENTRY _ZTV7ee32210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee32210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee32210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee32210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee32210[] = {
  {&(_ZTV7ee32210[4]),  4,10},
  {&(_ZTV7ee32210[9]),  9,10},
  {&(_tg__ZTV6dd2210__7ee32210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee32210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee32210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee32210[];
extern  VTBL_ENTRY _ZTV7ee32210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32210[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee322103fooEv,_ZTv0_n16_N7ee322103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee322103fooEv,_ZThn8_N7ee322103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32210 = {  "ee32210", // class name
  bases_ee32210, 4,
  &(vtc_ee32210[0]), // expected_vtbl_contents
  &(vtt_ee32210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42210  : dd2210 {
  int e;
  virtual void  bar(); // _ZN7ee422103barEv
  ~ee42210(); // tgen
  ee42210(); // tgen
};
//SIG(1 ee42210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee42210 ::bar(){vfunc_called(this, "_ZN7ee422103barEv");}
ee42210 ::~ee42210(){ note_dtor("ee42210", this);} // tgen
ee42210 ::ee42210(){ note_ctor("ee42210", this);} // tgen

static void Test_ee42210()
{
  extern Class_Descriptor cd_ee42210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42210, buf);
    ee42210 *dp, &lv = *(dp=new (buf) ee42210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(24,20), "ee42210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), 0, "ee42210");
    check_base_class_offset(lv, (cc210*)(dd2210*), 0, "ee42210");
    check_base_class_offset(lv, (dd2210*), 0, "ee42210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee42210.e");
    test_class_info(&lv, &cd_ee42210);
    dp->~ee42210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42210(Test_ee42210, "ee42210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42210C1Ev();
extern void _ZN7ee42210D1Ev();
Name_Map name_map_ee42210[] = {
  NSPAIR(_ZN7ee42210C1Ev),
  NSPAIR(_ZN7ee42210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee42210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42210[];
extern void _ZN6dd22103fooEv();
extern void _ZN7ee422103barEv();
static  VTBL_ENTRY vtc_ee42210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
  (VTBL_ENTRY)&_ZN7ee422103barEv,
};
extern VTBL_ENTRY _ZTV7ee42210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee42210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee42210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee42210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee42210[] = {
  {&(_ZTV7ee42210[3]),  3,5},
  {&(_tg__ZTV6dd2210__7ee42210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee42210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee42210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee42210[];
extern  VTBL_ENTRY _ZTV7ee42210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42210[];
Class_Descriptor cd_ee42210 = {  "ee42210", // class name
  bases_ee42210, 4,
  &(vtc_ee42210[0]), // expected_vtbl_contents
  &(vtt_ee42210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42210),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52210  : virtual dd2210 {
  int e;
  virtual void  bar(); // _ZN7ee522103barEv
  ~ee52210(); // tgen
  ee52210(); // tgen
};
//SIG(1 ee52210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee52210 ::bar(){vfunc_called(this, "_ZN7ee522103barEv");}
ee52210 ::~ee52210(){ note_dtor("ee52210", this);} // tgen
ee52210 ::ee52210(){ note_ctor("ee52210", this);} // tgen

static void Test_ee52210()
{
  extern Class_Descriptor cd_ee52210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52210, buf);
    ee52210 *dp, &lv = *(dp=new (buf) ee52210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(36,24), "ee52210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), ABISELECT(16,8), "ee52210");
    check_base_class_offset(lv, (cc210*)(dd2210*), ABISELECT(16,8), "ee52210");
    check_base_class_offset(lv, (dd2210*), ABISELECT(16,8), "ee52210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52210.e");
    test_class_info(&lv, &cd_ee52210);
    dp->~ee52210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52210(Test_ee52210, "ee52210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52210C1Ev();
extern void _ZN7ee52210D1Ev();
Name_Map name_map_ee52210[] = {
  NSPAIR(_ZN7ee52210C1Ev),
  NSPAIR(_ZN7ee52210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee52210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52210[];
extern void _ZN7ee522103barEv();
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY vtc_ee52210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52210[0]),
  (VTBL_ENTRY)&_ZN7ee522103barEv,
  0,
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern VTBL_ENTRY _ZTV7ee52210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee52210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee52210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee52210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee52210[] = {
  {&(_ZTV7ee52210[4]),  4,10},
  {&(_ZTV7ee52210[9]),  9,10},
  {&(_tg__ZTV6dd2210__7ee52210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee52210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee52210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee52210[];
extern  VTBL_ENTRY _ZTV7ee52210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52210[];
Class_Descriptor cd_ee52210 = {  "ee52210", // class name
  bases_ee52210, 4,
  &(vtc_ee52210[0]), // expected_vtbl_contents
  &(vtt_ee52210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62210  : dd2210 {
  int e;
  virtual void  foo(); // _ZN7ee622103fooEv
  virtual void  bar(); // _ZN7ee622103barEv
  ~ee62210(); // tgen
  ee62210(); // tgen
};
//SIG(1 ee62210) C1{ BC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee62210 ::foo(){vfunc_called(this, "_ZN7ee622103fooEv");}
void  ee62210 ::bar(){vfunc_called(this, "_ZN7ee622103barEv");}
ee62210 ::~ee62210(){ note_dtor("ee62210", this);} // tgen
ee62210 ::ee62210(){ note_ctor("ee62210", this);} // tgen

static void Test_ee62210()
{
  extern Class_Descriptor cd_ee62210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62210, buf);
    ee62210 *dp, &lv = *(dp=new (buf) ee62210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(24,20), "ee62210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), 0, "ee62210");
    check_base_class_offset(lv, (cc210*)(dd2210*), 0, "ee62210");
    check_base_class_offset(lv, (dd2210*), 0, "ee62210");
    check_field_offset(lv, e, ABISELECT(20,16), "ee62210.e");
    test_class_info(&lv, &cd_ee62210);
    dp->~ee62210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62210(Test_ee62210, "ee62210", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62210C1Ev();
extern void _ZN7ee62210D1Ev();
Name_Map name_map_ee62210[] = {
  NSPAIR(_ZN7ee62210C1Ev),
  NSPAIR(_ZN7ee62210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee62210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62210[];
extern void _ZN7ee622103fooEv();
extern void _ZN7ee622103barEv();
static  VTBL_ENTRY vtc_ee62210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62210[0]),
  (VTBL_ENTRY)&_ZN7ee622103fooEv,
  (VTBL_ENTRY)&_ZN7ee622103barEv,
};
extern VTBL_ENTRY _ZTV7ee62210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee62210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee62210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee62210[] = {
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee62210[] = {
  {&(_ZTV7ee62210[3]),  3,5},
  {&(_tg__ZTV6dd2210__7ee62210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee62210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee62210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee62210[];
extern  VTBL_ENTRY _ZTV7ee62210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62210[];
Class_Descriptor cd_ee62210 = {  "ee62210", // class name
  bases_ee62210, 4,
  &(vtc_ee62210[0]), // expected_vtbl_contents
  &(vtt_ee62210[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62210),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62210),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72210  : virtual dd2210 {
  int e;
  virtual void  foo(); // _ZN7ee722103fooEv
  virtual void  bar(); // _ZN7ee722103barEv
  ~ee72210(); // tgen
  ee72210(); // tgen
};
//SIG(1 ee72210) C1{ VBC2{ BC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee72210 ::foo(){vfunc_called(this, "_ZN7ee722103fooEv");}
void  ee72210 ::bar(){vfunc_called(this, "_ZN7ee722103barEv");}
ee72210 ::~ee72210(){ note_dtor("ee72210", this);} // tgen
ee72210 ::ee72210(){ note_ctor("ee72210", this);} // tgen

static void Test_ee72210()
{
  extern Class_Descriptor cd_ee72210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72210, buf);
    ee72210 *dp, &lv = *(dp=new (buf) ee72210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*)(dd2210*), ABISELECT(36,24), "ee72210");
    check_base_class_offset(lv, (bb10*)(cc210*)(dd2210*), ABISELECT(16,8), "ee72210");
    check_base_class_offset(lv, (cc210*)(dd2210*), ABISELECT(16,8), "ee72210");
    check_base_class_offset(lv, (dd2210*), ABISELECT(16,8), "ee72210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72210.e");
    test_class_info(&lv, &cd_ee72210);
    dp->~ee72210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72210(Test_ee72210, "ee72210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72210C1Ev();
extern void _ZN7ee72210D1Ev();
Name_Map name_map_ee72210[] = {
  NSPAIR(_ZN7ee72210C1Ev),
  NSPAIR(_ZN7ee72210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd2210;
extern VTBL_ENTRY _ZTI6dd2210[];
extern  VTBL_ENTRY _ZTV6dd2210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2210[];
static Base_Class bases_ee72210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(36,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2210,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72210[];
extern void _ZN7ee722103fooEv();
extern void _ZN7ee722103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee722103fooEv,_ZTv0_n16_N7ee722103fooEv)();
extern void ABISELECT(_ZThn16_N7ee722103fooEv,_ZThn8_N7ee722103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72210[] = {
  ABISELECT(36,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72210[0]),
  (VTBL_ENTRY)&_ZN7ee722103fooEv,
  (VTBL_ENTRY)&_ZN7ee722103barEv,
  ABISELECT(-16,-8),
  ABISELECT(20,16),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee722103fooEv,_ZTv0_n16_N7ee722103fooEv),
};
extern VTBL_ENTRY _ZTV7ee72210[];
extern void _ZN6dd22103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2210__7ee72210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2210[0]),
  (VTBL_ENTRY)&_ZN6dd22103fooEv,
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc2106dd2210__7ee72210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc2106dd2210__7ee72210[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee72210[] = {
  {&(_ZTV7ee72210[4]),  4,11},
  {&(_ZTV7ee72210[10]),  10,11},
  {&(_tg__ZTV6dd2210__7ee72210[3]),  3,4},
  {&(_tg__ZTV5cc2106dd2210__7ee72210[3]),  3,4},
  {&(_tg__ZTV4bb105cc2106dd2210__7ee72210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee72210[];
extern  VTBL_ENTRY _ZTV7ee72210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72210[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee722103fooEv,_ZTv0_n16_N7ee722103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee722103fooEv,_ZThn8_N7ee722103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72210 = {  "ee72210", // class name
  bases_ee72210, 4,
  &(vtc_ee72210[0]), // expected_vtbl_contents
  &(vtt_ee72210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72210),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72210),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3210  : virtual cc210 {
  int d;
  virtual void  foo(); // _ZN6dd32103fooEv
  ~dd3210(); // tgen
  dd3210(); // tgen
};
//SIG(-1 dd3210) C1{ VBC2{ BC3{ VBC4{ Fi} Fi} v1 Fi} v1 Fi}


void  dd3210 ::foo(){vfunc_called(this, "_ZN6dd32103fooEv");}
dd3210 ::~dd3210(){ note_dtor("dd3210", this);} // tgen
dd3210 ::dd3210(){ note_ctor("dd3210", this);} // tgen

static void Test_dd3210()
{
  extern Class_Descriptor cd_dd3210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3210, buf);
    dd3210 *dp, &lv = *(dp=new (buf) dd3210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,20), "dd3210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,8), "dd3210");
    check_base_class_offset(lv, (cc210*), ABISELECT(16,8), "dd3210");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3210.d");
    test_class_info(&lv, &cd_dd3210);
    dp->~dd3210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3210(Test_dd3210, "dd3210", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3210C1Ev();
extern void _ZN6dd3210D1Ev();
Name_Map name_map_dd3210[] = {
  NSPAIR(_ZN6dd3210C1Ev),
  NSPAIR(_ZN6dd3210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
static Base_Class bases_dd3210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3210[];
extern void _ZN6dd32103fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern VTBL_ENTRY _ZTV6dd3210[];
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__6dd3210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_dd3210[] = {
  {&(_ZTV6dd3210[4]),  4,10},
  {&(_ZTV6dd3210[9]),  9,10},
  {&(_tg__ZTV5cc210__6dd3210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__6dd3210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3210 = {  "dd3210", // class name
  bases_dd3210, 3,
  &(vtc_dd3210[0]), // expected_vtbl_contents
  &(vtt_dd3210[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3210),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03210  : dd3210 {
  int e;
  ~ee03210(); // tgen
  ee03210(); // tgen
};
//SIG(1 ee03210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee03210 ::~ee03210(){ note_dtor("ee03210", this);} // tgen
ee03210 ::ee03210(){ note_ctor("ee03210", this);} // tgen

static void Test_ee03210()
{
  extern Class_Descriptor cd_ee03210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03210, buf);
    ee03210 *dp, &lv = *(dp=new (buf) ee03210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee03210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee03210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(16,12), "ee03210");
    check_base_class_offset(lv, (dd3210*), 0, "ee03210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03210.e");
    test_class_info(&lv, &cd_ee03210);
    dp->~ee03210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03210(Test_ee03210, "ee03210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03210C1Ev();
extern void _ZN7ee03210D1Ev();
Name_Map name_map_ee03210[] = {
  NSPAIR(_ZN7ee03210C1Ev),
  NSPAIR(_ZN7ee03210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd3210;
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static Base_Class bases_ee03210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03210[];
extern void _ZN6dd32103fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern VTBL_ENTRY _ZTV7ee03210[];
extern void _ZN6dd32103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3210__7ee03210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210__7ee03210[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee03210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee03210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee03210[] = {
  {&(_ZTV7ee03210[4]),  4,10},
  {&(_tg__ZTV6dd3210__7ee03210[4]),  4,5},
  {&(_tg__ZTV5cc210__6dd3210__7ee03210[4]),  4,5},
  {&(_ZTV7ee03210[9]),  9,10},
  {&(_tg__ZTV5cc210__7ee03210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee03210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee03210[];
extern  VTBL_ENTRY _ZTV7ee03210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03210[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03210 = {  "ee03210", // class name
  bases_ee03210, 4,
  &(vtc_ee03210[0]), // expected_vtbl_contents
  &(vtt_ee03210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13210  : virtual dd3210 {
  int e;
  ~ee13210(); // tgen
  ee13210(); // tgen
};
//SIG(1 ee13210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee13210 ::~ee13210(){ note_dtor("ee13210", this);} // tgen
ee13210 ::ee13210(){ note_ctor("ee13210", this);} // tgen

static void Test_ee13210()
{
  extern Class_Descriptor cd_ee13210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13210, buf);
    ee13210 *dp, &lv = *(dp=new (buf) ee13210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee13210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee13210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(32,16), "ee13210");
    check_base_class_offset(lv, (dd3210*), ABISELECT(16,8), "ee13210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13210.e");
    test_class_info(&lv, &cd_ee13210);
    dp->~ee13210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13210(Test_ee13210, "ee13210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13210C1Ev();
extern void _ZN7ee13210D1Ev();
Name_Map name_map_ee13210[] = {
  NSPAIR(_ZN7ee13210C1Ev),
  NSPAIR(_ZN7ee13210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd3210;
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static Base_Class bases_ee13210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3210,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13210[];
extern void _ZN6dd32103fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13210[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13210[0]),
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern VTBL_ENTRY _ZTV7ee13210[];
extern void _ZN6dd32103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3210__7ee13210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210__7ee13210[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee13210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee13210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee13210[] = {
  {&(_ZTV7ee13210[5]),  5,16},
  {&(_ZTV7ee13210[10]),  10,16},
  {&(_ZTV7ee13210[15]),  15,16},
  {&(_tg__ZTV6dd3210__7ee13210[4]),  4,5},
  {&(_tg__ZTV5cc210__6dd3210__7ee13210[4]),  4,5},
  {&(_tg__ZTV5cc210__7ee13210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee13210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee13210[];
extern  VTBL_ENTRY _ZTV7ee13210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13210[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13210 = {  "ee13210", // class name
  bases_ee13210, 4,
  &(vtc_ee13210[0]), // expected_vtbl_contents
  &(vtt_ee13210[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13210),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13210),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23210  : dd3210 {
  int e;
  virtual void  foo(); // _ZN7ee232103fooEv
  ~ee23210(); // tgen
  ee23210(); // tgen
};
//SIG(1 ee23210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee23210 ::foo(){vfunc_called(this, "_ZN7ee232103fooEv");}
ee23210 ::~ee23210(){ note_dtor("ee23210", this);} // tgen
ee23210 ::ee23210(){ note_ctor("ee23210", this);} // tgen

static void Test_ee23210()
{
  extern Class_Descriptor cd_ee23210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23210, buf);
    ee23210 *dp, &lv = *(dp=new (buf) ee23210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee23210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee23210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(16,12), "ee23210");
    check_base_class_offset(lv, (dd3210*), 0, "ee23210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23210.e");
    test_class_info(&lv, &cd_ee23210);
    dp->~ee23210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23210(Test_ee23210, "ee23210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23210C1Ev();
extern void _ZN7ee23210D1Ev();
Name_Map name_map_ee23210[] = {
  NSPAIR(_ZN7ee23210C1Ev),
  NSPAIR(_ZN7ee23210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd3210;
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static Base_Class bases_ee23210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23210[];
extern void _ZN7ee232103fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee232103fooEv,_ZTv0_n16_N7ee232103fooEv)();
extern void ABISELECT(_ZThn16_N7ee232103fooEv,_ZThn12_N7ee232103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23210[0]),
  (VTBL_ENTRY)&_ZN7ee232103fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee232103fooEv,_ZTv0_n16_N7ee232103fooEv),
};
extern VTBL_ENTRY _ZTV7ee23210[];
extern void _ZN6dd32103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3210__7ee23210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210__7ee23210[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee23210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee23210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee23210[] = {
  {&(_ZTV7ee23210[4]),  4,10},
  {&(_tg__ZTV6dd3210__7ee23210[4]),  4,5},
  {&(_tg__ZTV5cc210__6dd3210__7ee23210[4]),  4,5},
  {&(_ZTV7ee23210[9]),  9,10},
  {&(_tg__ZTV5cc210__7ee23210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee23210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee23210[];
extern  VTBL_ENTRY _ZTV7ee23210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23210[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee232103fooEv,_ZTv0_n16_N7ee232103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee232103fooEv,_ZThn12_N7ee232103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23210 = {  "ee23210", // class name
  bases_ee23210, 4,
  &(vtc_ee23210[0]), // expected_vtbl_contents
  &(vtt_ee23210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23210),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33210  : virtual dd3210 {
  int e;
  virtual void  foo(); // _ZN7ee332103fooEv
  ~ee33210(); // tgen
  ee33210(); // tgen
};
//SIG(1 ee33210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee33210 ::foo(){vfunc_called(this, "_ZN7ee332103fooEv");}
ee33210 ::~ee33210(){ note_dtor("ee33210", this);} // tgen
ee33210 ::ee33210(){ note_ctor("ee33210", this);} // tgen

static void Test_ee33210()
{
  extern Class_Descriptor cd_ee33210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33210, buf);
    ee33210 *dp, &lv = *(dp=new (buf) ee33210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee33210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee33210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(32,16), "ee33210");
    check_base_class_offset(lv, (dd3210*), ABISELECT(16,8), "ee33210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33210.e");
    test_class_info(&lv, &cd_ee33210);
    dp->~ee33210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33210(Test_ee33210, "ee33210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33210C1Ev();
extern void _ZN7ee33210D1Ev();
Name_Map name_map_ee33210[] = {
  NSPAIR(_ZN7ee33210C1Ev),
  NSPAIR(_ZN7ee33210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd3210;
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static Base_Class bases_ee33210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3210,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33210[];
extern void _ZN7ee332103fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee332103fooEv,_ZTv0_n20_N7ee332103fooEv)();
extern void ABISELECT(_ZThn16_N7ee332103fooEv,_ZThn8_N7ee332103fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee332103fooEv,_ZTv0_n16_N7ee332103fooEv)();
extern void ABISELECT(_ZThn32_N7ee332103fooEv,_ZThn16_N7ee332103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33210[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33210[0]),
  (VTBL_ENTRY)&_ZN7ee332103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee332103fooEv,_ZTv0_n20_N7ee332103fooEv),
  ABISELECT(-32,-16),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee332103fooEv,_ZTv0_n16_N7ee332103fooEv),
};
extern VTBL_ENTRY _ZTV7ee33210[];
extern void _ZN6dd32103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3210__7ee33210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210__7ee33210[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee33210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee33210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee33210[] = {
  {&(_ZTV7ee33210[5]),  5,17},
  {&(_ZTV7ee33210[11]),  11,17},
  {&(_ZTV7ee33210[16]),  16,17},
  {&(_tg__ZTV6dd3210__7ee33210[4]),  4,5},
  {&(_tg__ZTV5cc210__6dd3210__7ee33210[4]),  4,5},
  {&(_tg__ZTV5cc210__7ee33210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee33210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee33210[];
extern  VTBL_ENTRY _ZTV7ee33210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33210[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee332103fooEv,_ZTv0_n16_N7ee332103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee332103fooEv,_ZThn16_N7ee332103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee332103fooEv,_ZTv0_n20_N7ee332103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee332103fooEv,_ZThn8_N7ee332103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33210 = {  "ee33210", // class name
  bases_ee33210, 4,
  &(vtc_ee33210[0]), // expected_vtbl_contents
  &(vtt_ee33210[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33210),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33210),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43210  : dd3210 {
  int e;
  virtual void  bar(); // _ZN7ee432103barEv
  ~ee43210(); // tgen
  ee43210(); // tgen
};
//SIG(1 ee43210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee43210 ::bar(){vfunc_called(this, "_ZN7ee432103barEv");}
ee43210 ::~ee43210(){ note_dtor("ee43210", this);} // tgen
ee43210 ::ee43210(){ note_ctor("ee43210", this);} // tgen

static void Test_ee43210()
{
  extern Class_Descriptor cd_ee43210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43210, buf);
    ee43210 *dp, &lv = *(dp=new (buf) ee43210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee43210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee43210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(16,12), "ee43210");
    check_base_class_offset(lv, (dd3210*), 0, "ee43210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43210.e");
    test_class_info(&lv, &cd_ee43210);
    dp->~ee43210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43210(Test_ee43210, "ee43210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43210C1Ev();
extern void _ZN7ee43210D1Ev();
Name_Map name_map_ee43210[] = {
  NSPAIR(_ZN7ee43210C1Ev),
  NSPAIR(_ZN7ee43210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd3210;
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static Base_Class bases_ee43210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43210[];
extern void _ZN6dd32103fooEv();
extern void _ZN7ee432103barEv();
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
  (VTBL_ENTRY)&_ZN7ee432103barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern VTBL_ENTRY _ZTV7ee43210[];
extern void _ZN6dd32103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3210__7ee43210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210__7ee43210[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee43210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee43210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee43210[] = {
  {&(_ZTV7ee43210[4]),  4,11},
  {&(_tg__ZTV6dd3210__7ee43210[4]),  4,5},
  {&(_tg__ZTV5cc210__6dd3210__7ee43210[4]),  4,5},
  {&(_ZTV7ee43210[10]),  10,11},
  {&(_tg__ZTV5cc210__7ee43210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee43210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee43210[];
extern  VTBL_ENTRY _ZTV7ee43210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43210[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43210 = {  "ee43210", // class name
  bases_ee43210, 4,
  &(vtc_ee43210[0]), // expected_vtbl_contents
  &(vtt_ee43210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43210),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53210  : virtual dd3210 {
  int e;
  virtual void  bar(); // _ZN7ee532103barEv
  ~ee53210(); // tgen
  ee53210(); // tgen
};
//SIG(1 ee53210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee53210 ::bar(){vfunc_called(this, "_ZN7ee532103barEv");}
ee53210 ::~ee53210(){ note_dtor("ee53210", this);} // tgen
ee53210 ::ee53210(){ note_ctor("ee53210", this);} // tgen

static void Test_ee53210()
{
  extern Class_Descriptor cd_ee53210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53210, buf);
    ee53210 *dp, &lv = *(dp=new (buf) ee53210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee53210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee53210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(32,16), "ee53210");
    check_base_class_offset(lv, (dd3210*), ABISELECT(16,8), "ee53210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53210.e");
    test_class_info(&lv, &cd_ee53210);
    dp->~ee53210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53210(Test_ee53210, "ee53210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53210C1Ev();
extern void _ZN7ee53210D1Ev();
Name_Map name_map_ee53210[] = {
  NSPAIR(_ZN7ee53210C1Ev),
  NSPAIR(_ZN7ee53210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd3210;
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static Base_Class bases_ee53210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3210,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53210[];
extern void _ZN7ee532103barEv();
extern void _ZN6dd32103fooEv();
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53210[] = {
  ABISELECT(48,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53210[0]),
  (VTBL_ENTRY)&_ZN7ee532103barEv,
  0,
  ABISELECT(32,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern VTBL_ENTRY _ZTV7ee53210[];
extern void _ZN6dd32103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3210__7ee53210[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210__7ee53210[] = {
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee53210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee53210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee53210[] = {
  {&(_ZTV7ee53210[5]),  5,17},
  {&(_ZTV7ee53210[11]),  11,17},
  {&(_ZTV7ee53210[16]),  16,17},
  {&(_tg__ZTV6dd3210__7ee53210[4]),  4,5},
  {&(_tg__ZTV5cc210__6dd3210__7ee53210[4]),  4,5},
  {&(_tg__ZTV5cc210__7ee53210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee53210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee53210[];
extern  VTBL_ENTRY _ZTV7ee53210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53210[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn8_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53210 = {  "ee53210", // class name
  bases_ee53210, 4,
  &(vtc_ee53210[0]), // expected_vtbl_contents
  &(vtt_ee53210[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53210),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53210),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53210),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63210  : dd3210 {
  int e;
  virtual void  foo(); // _ZN7ee632103fooEv
  virtual void  bar(); // _ZN7ee632103barEv
  ~ee63210(); // tgen
  ee63210(); // tgen
};
//SIG(1 ee63210) C1{ BC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee63210 ::foo(){vfunc_called(this, "_ZN7ee632103fooEv");}
void  ee63210 ::bar(){vfunc_called(this, "_ZN7ee632103barEv");}
ee63210 ::~ee63210(){ note_dtor("ee63210", this);} // tgen
ee63210 ::ee63210(){ note_ctor("ee63210", this);} // tgen

static void Test_ee63210()
{
  extern Class_Descriptor cd_ee63210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63210, buf);
    ee63210 *dp, &lv = *(dp=new (buf) ee63210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(32,24), "ee63210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(16,12), "ee63210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(16,12), "ee63210");
    check_base_class_offset(lv, (dd3210*), 0, "ee63210");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63210.e");
    test_class_info(&lv, &cd_ee63210);
    dp->~ee63210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63210(Test_ee63210, "ee63210", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63210C1Ev();
extern void _ZN7ee63210D1Ev();
Name_Map name_map_ee63210[] = {
  NSPAIR(_ZN7ee63210C1Ev),
  NSPAIR(_ZN7ee63210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4bb10[];
extern Class_Descriptor cd_cc210;
extern VTBL_ENTRY _ZTI5cc210[];
extern  VTBL_ENTRY _ZTV5cc210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc210[];
extern Class_Descriptor cd_dd3210;
extern VTBL_ENTRY _ZTI6dd3210[];
extern  VTBL_ENTRY _ZTV6dd3210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3210[];
static Base_Class bases_ee63210[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc210,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3210,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63210[];
extern void _ZN7ee632103fooEv();
extern void _ZN7ee632103barEv();
extern void ABISELECT(_ZTv0_n32_N7ee632103fooEv,_ZTv0_n16_N7ee632103fooEv)();
extern void ABISELECT(_ZThn16_N7ee632103fooEv,_ZThn12_N7ee632103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63210[0]),
  (VTBL_ENTRY)&_ZN7ee632103fooEv,
  (VTBL_ENTRY)&_ZN7ee632103barEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee632103fooEv,_ZTv0_n16_N7ee632103fooEv),
};
extern VTBL_ENTRY _ZTV7ee63210[];
extern void _ZN6dd32103fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3210__7ee63210[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&_ZN6dd32103fooEv,
};
extern void ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv)();
extern void ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc210__6dd3210__7ee63210[] = {
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3210[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv),
};
extern void _ZN5cc2103fooEv();
static  VTBL_ENTRY _tg__ZTV5cc210__7ee63210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc210[0]),
  (VTBL_ENTRY)&_ZN5cc2103fooEv,
};
static  VTBL_ENTRY _tg__ZTV4bb105cc210__7ee63210[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
};
static  VTT_ENTRY vtt_ee63210[] = {
  {&(_ZTV7ee63210[4]),  4,11},
  {&(_tg__ZTV6dd3210__7ee63210[4]),  4,5},
  {&(_tg__ZTV5cc210__6dd3210__7ee63210[4]),  4,5},
  {&(_ZTV7ee63210[10]),  10,11},
  {&(_tg__ZTV5cc210__7ee63210[3]),  3,4},
  {&(_tg__ZTV4bb105cc210__7ee63210[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee63210[];
extern  VTBL_ENTRY _ZTV7ee63210[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63210[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N6dd32103fooEv,_ZTv0_n16_N6dd32103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32103fooEv,_ZThn12_N6dd32103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee632103fooEv,_ZTv0_n16_N7ee632103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee632103fooEv,_ZThn12_N7ee632103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63210 = {  "ee63210", // class name
  bases_ee63210, 4,
  &(vtc_ee63210[0]), // expected_vtbl_contents
  &(vtt_ee63210[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63210),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63210),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63210),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73210  : virtual dd3210 {
  int e;
  virtual void  foo(); // _ZN7ee732103fooEv
  virtual void  bar(); // _ZN7ee732103barEv
  ~ee73210(); // tgen
  ee73210(); // tgen
};
//SIG(1 ee73210) C1{ VBC2{ VBC3{ BC4{ VBC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee73210 ::foo(){vfunc_called(this, "_ZN7ee732103fooEv");}
void  ee73210 ::bar(){vfunc_called(this, "_ZN7ee732103barEv");}
ee73210 ::~ee73210(){ note_dtor("ee73210", this);} // tgen
ee73210 ::ee73210(){ note_ctor("ee73210", this);} // tgen

static void Test_ee73210()
{
  extern Class_Descriptor cd_ee73210;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73210, buf);
    ee73210 *dp, &lv = *(dp=new (buf) ee73210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73210)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73210)");
    check_base_class_offset(lv, (aa0*)(bb10*)(cc210*), ABISELECT(48,28), "ee73210");
    check_base_class_offset(lv, (bb10*)(cc210*), ABISELECT(32,16), "ee73210");
    check_base_class_offset(lv, (cc210*)(dd3210*), ABISELECT(32,16), "ee73210");
    check_base_class_offset(lv, (dd3210*), ABISELECT(16,8), "ee73210");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73210.e");
    test_class_info(&lv, &cd_ee73210);
    dp->~ee73210();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73210(Test_ee73210, "ee73210", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73210C1Ev();
extern void _ZN7ee73210D1Ev();
Name_Map name_map_ee73210[] = {
  NSPAIR(_ZN7ee73210C1Ev),
  NSPAIR(_ZN7ee73210D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern  VTB