// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
};
//SIG(-1 aa0) C1{ Fi}



static void Test_aa0()
{
  {
    init_simple_test("aa0");
    aa0 lv;
    check2(sizeof(lv), 4, "sizeof(aa0)");
    check2(__alignof__(lv), 4, "__alignof__(aa0)");
    check_field_offset(lv, a, 0, "aa0.a");
  }
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", 4);

#else // __cplusplus

extern VTBL_ENTRY _ZTI3aa0[];
VTBL_ENTRY *P__ZTI3aa0 = _ZTI3aa0; 
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
  aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen
aa1 ::aa1(){ note_ctor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
  virtual void  foo(); // _ZN3aa23fooEv
  virtual void  bar(); // _ZN3aa23barEv
  ~aa2(); // tgen
  aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 v2 Fi}


void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
void  aa2 ::bar(){vfunc_called(this, "_ZN3aa23barEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen
aa2 ::aa2(){ note_ctor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
extern void _ZN3aa23barEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
  (VTBL_ENTRY)&_ZN3aa23barEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb00  : aa0 {
  int b;
};
//SIG(-1 bb00) C1{ BC2{ Fi} Fi}



static void Test_bb00()
{
  extern Class_Descriptor cd_bb00;
  void *lvp;
  {
    int buf[3];
    init_test(&cd_bb00, buf);
    bb00 &lv = *(new (buf) bb00());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(bb00)");
    check2(__alignof__(lv), 4, "__alignof__(bb00)");
    check_base_class_offset(lv, (aa0*), 0, "bb00");
    check_field_offset(lv, b, 4, "bb00.b");
    test_class_info(&lv, &cd_bb00);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb00(Test_bb00, "bb00", 8);

#else // __cplusplus

extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
static Base_Class bases_bb00[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4bb00[];
Class_Descriptor cd_bb00 = {  "bb00", // class name
  bases_bb00, 1,
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI4bb00),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc000  : bb00 {
  int c;
};
//SIG(-1 cc000) C1{ BC2{ BC3{ Fi} Fi} Fi}



static void Test_cc000()
{
  extern Class_Descriptor cd_cc000;
  void *lvp;
  {
    int buf[4];
    init_test(&cd_cc000, buf);
    cc000 &lv = *(new (buf) cc000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(cc000)");
    check2(__alignof__(lv), 4, "__alignof__(cc000)");
    check_base_class_offset(lv, (aa0*)(bb00*), 0, "cc000");
    check_base_class_offset(lv, (bb00*), 0, "cc000");
    check_field_offset(lv, c, 8, "cc000.c");
    test_class_info(&lv, &cd_cc000);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc000(Test_cc000, "cc000", 12);

#else // __cplusplus

extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
static Base_Class bases_cc000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc000[];
Class_Descriptor cd_cc000 = {  "cc000", // class name
  bases_cc000, 2,
  0, // no vftv
  0, //no vtt
  12, // object size
  NSPAIRA(_ZTI5cc000),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0000  : cc000 {
  int d;
};
//SIG(-1 dd0000) C1{ BC2{ BC3{ BC4{ Fi} Fi} Fi} Fi}



static void Test_dd0000()
{
  extern Class_Descriptor cd_dd0000;
  void *lvp;
  {
    int buf[5];
    init_test(&cd_dd0000, buf);
    dd0000 &lv = *(new (buf) dd0000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(dd0000)");
    check2(__alignof__(lv), 4, "__alignof__(dd0000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), 0, "dd0000");
    check_base_class_offset(lv, (bb00*)(cc000*), 0, "dd0000");
    check_base_class_offset(lv, (cc000*), 0, "dd0000");
    check_field_offset(lv, d, 12, "dd0000.d");
    test_class_info(&lv, &cd_dd0000);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0000(Test_dd0000, "dd0000", 16);

#else // __cplusplus

extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd0000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0000[];
Class_Descriptor cd_dd0000 = {  "dd0000", // class name
  bases_dd0000, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  NSPAIRA(_ZTI6dd0000),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00000  : dd0000 {
  int e;
};
//SIG(1 ee00000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} Fi}



static void Test_ee00000()
{
  extern Class_Descriptor cd_ee00000;
  void *lvp;
  {
    int buf[6];
    init_test(&cd_ee00000, buf);
    ee00000 &lv = *(new (buf) ee00000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 20, "sizeof(ee00000)");
    check2(__alignof__(lv), 4, "__alignof__(ee00000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), 0, "ee00000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), 0, "ee00000");
    check_base_class_offset(lv, (cc000*)(dd0000*), 0, "ee00000");
    check_base_class_offset(lv, (dd0000*), 0, "ee00000");
    check_field_offset(lv, e, 16, "ee00000.e");
    test_class_info(&lv, &cd_ee00000);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00000(Test_ee00000, "ee00000", 20);

#else // __cplusplus

extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee00000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_ee00000 = {  "ee00000", // class name
  bases_ee00000, 4,
  0, // no vftv
  0, //no vtt
  20, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10000  : virtual dd0000 {
  int e;
  ~ee10000(); // tgen
  ee10000(); // tgen
};
//SIG(1 ee10000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} Fi}


ee10000 ::~ee10000(){ note_dtor("ee10000", this);} // tgen
ee10000 ::ee10000(){ note_ctor("ee10000", this);} // tgen

static void Test_ee10000()
{
  extern Class_Descriptor cd_ee10000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee10000, buf);
    ee10000 *dp, &lv = *(dp=new (buf) ee10000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee10000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee10000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee10000");
    check_base_class_offset(lv, (cc000*)(dd0000*), ABISELECT(12,8), "ee10000");
    check_base_class_offset(lv, (dd0000*), ABISELECT(12,8), "ee10000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10000.e");
    test_class_info(&lv, &cd_ee10000);
    dp->~ee10000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10000(Test_ee10000, "ee10000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee10000C1Ev();
extern void _ZN7ee10000D1Ev();
Name_Map name_map_ee10000[] = {
  NSPAIR(_ZN7ee10000C1Ev),
  NSPAIR(_ZN7ee10000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee10000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10000[];
static  VTBL_ENTRY vtc_ee10000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10000[0]),
};
extern VTBL_ENTRY _ZTV7ee10000[];
static  VTT_ENTRY vtt_ee10000[] = {
  {&(_ZTV7ee10000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee10000[];
extern  VTBL_ENTRY _ZTV7ee10000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10000[];
Class_Descriptor cd_ee10000 = {  "ee10000", // class name
  bases_ee10000, 4,
  &(vtc_ee10000[0]), // expected_vtbl_contents
  &(vtt_ee10000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee10000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10000),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20000  : dd0000 {
  int e;
  virtual void  foo(); // _ZN7ee200003fooEv
  ~ee20000(); // tgen
  ee20000(); // tgen
};
//SIG(1 ee20000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee20000 ::foo(){vfunc_called(this, "_ZN7ee200003fooEv");}
ee20000 ::~ee20000(){ note_dtor("ee20000", this);} // tgen
ee20000 ::ee20000(){ note_ctor("ee20000", this);} // tgen

static void Test_ee20000()
{
  extern Class_Descriptor cd_ee20000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20000, buf);
    ee20000 *dp, &lv = *(dp=new (buf) ee20000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), ABISELECT(8,4), "ee20000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), ABISELECT(8,4), "ee20000");
    check_base_class_offset(lv, (cc000*)(dd0000*), ABISELECT(8,4), "ee20000");
    check_base_class_offset(lv, (dd0000*), ABISELECT(8,4), "ee20000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20000.e");
    test_class_info(&lv, &cd_ee20000);
    dp->~ee20000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20000(Test_ee20000, "ee20000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20000C1Ev();
extern void _ZN7ee20000D1Ev();
Name_Map name_map_ee20000[] = {
  NSPAIR(_ZN7ee20000C1Ev),
  NSPAIR(_ZN7ee20000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee20000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20000[];
extern void _ZN7ee200003fooEv();
static  VTBL_ENTRY vtc_ee20000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20000[0]),
  (VTBL_ENTRY)&_ZN7ee200003fooEv,
};
extern VTBL_ENTRY _ZTI7ee20000[];
extern  VTBL_ENTRY _ZTV7ee20000[];
Class_Descriptor cd_ee20000 = {  "ee20000", // class name
  bases_ee20000, 4,
  &(vtc_ee20000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee20000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30000  : virtual dd0000 {
  int e;
  virtual void  foo(); // _ZN7ee300003fooEv
  ~ee30000(); // tgen
  ee30000(); // tgen
};
//SIG(1 ee30000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee30000 ::foo(){vfunc_called(this, "_ZN7ee300003fooEv");}
ee30000 ::~ee30000(){ note_dtor("ee30000", this);} // tgen
ee30000 ::ee30000(){ note_ctor("ee30000", this);} // tgen

static void Test_ee30000()
{
  extern Class_Descriptor cd_ee30000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee30000, buf);
    ee30000 *dp, &lv = *(dp=new (buf) ee30000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee30000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee30000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee30000");
    check_base_class_offset(lv, (cc000*)(dd0000*), ABISELECT(12,8), "ee30000");
    check_base_class_offset(lv, (dd0000*), ABISELECT(12,8), "ee30000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30000.e");
    test_class_info(&lv, &cd_ee30000);
    dp->~ee30000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30000(Test_ee30000, "ee30000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee30000C1Ev();
extern void _ZN7ee30000D1Ev();
Name_Map name_map_ee30000[] = {
  NSPAIR(_ZN7ee30000C1Ev),
  NSPAIR(_ZN7ee30000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee30000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30000[];
extern void _ZN7ee300003fooEv();
static  VTBL_ENTRY vtc_ee30000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30000[0]),
  (VTBL_ENTRY)&_ZN7ee300003fooEv,
};
extern VTBL_ENTRY _ZTV7ee30000[];
static  VTT_ENTRY vtt_ee30000[] = {
  {&(_ZTV7ee30000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee30000[];
extern  VTBL_ENTRY _ZTV7ee30000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30000[];
Class_Descriptor cd_ee30000 = {  "ee30000", // class name
  bases_ee30000, 4,
  &(vtc_ee30000[0]), // expected_vtbl_contents
  &(vtt_ee30000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee30000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40000  : dd0000 {
  int e;
  virtual void  bar(); // _ZN7ee400003barEv
  ~ee40000(); // tgen
  ee40000(); // tgen
};
//SIG(1 ee40000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee40000 ::bar(){vfunc_called(this, "_ZN7ee400003barEv");}
ee40000 ::~ee40000(){ note_dtor("ee40000", this);} // tgen
ee40000 ::ee40000(){ note_ctor("ee40000", this);} // tgen

static void Test_ee40000()
{
  extern Class_Descriptor cd_ee40000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40000, buf);
    ee40000 *dp, &lv = *(dp=new (buf) ee40000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), ABISELECT(8,4), "ee40000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), ABISELECT(8,4), "ee40000");
    check_base_class_offset(lv, (cc000*)(dd0000*), ABISELECT(8,4), "ee40000");
    check_base_class_offset(lv, (dd0000*), ABISELECT(8,4), "ee40000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40000.e");
    test_class_info(&lv, &cd_ee40000);
    dp->~ee40000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40000(Test_ee40000, "ee40000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40000C1Ev();
extern void _ZN7ee40000D1Ev();
Name_Map name_map_ee40000[] = {
  NSPAIR(_ZN7ee40000C1Ev),
  NSPAIR(_ZN7ee40000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee40000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40000[];
extern void _ZN7ee400003barEv();
static  VTBL_ENTRY vtc_ee40000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40000[0]),
  (VTBL_ENTRY)&_ZN7ee400003barEv,
};
extern VTBL_ENTRY _ZTI7ee40000[];
extern  VTBL_ENTRY _ZTV7ee40000[];
Class_Descriptor cd_ee40000 = {  "ee40000", // class name
  bases_ee40000, 4,
  &(vtc_ee40000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee40000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50000  : virtual dd0000 {
  int e;
  virtual void  bar(); // _ZN7ee500003barEv
  ~ee50000(); // tgen
  ee50000(); // tgen
};
//SIG(1 ee50000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee50000 ::bar(){vfunc_called(this, "_ZN7ee500003barEv");}
ee50000 ::~ee50000(){ note_dtor("ee50000", this);} // tgen
ee50000 ::ee50000(){ note_ctor("ee50000", this);} // tgen

static void Test_ee50000()
{
  extern Class_Descriptor cd_ee50000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee50000, buf);
    ee50000 *dp, &lv = *(dp=new (buf) ee50000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee50000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee50000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee50000");
    check_base_class_offset(lv, (cc000*)(dd0000*), ABISELECT(12,8), "ee50000");
    check_base_class_offset(lv, (dd0000*), ABISELECT(12,8), "ee50000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50000.e");
    test_class_info(&lv, &cd_ee50000);
    dp->~ee50000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50000(Test_ee50000, "ee50000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee50000C1Ev();
extern void _ZN7ee50000D1Ev();
Name_Map name_map_ee50000[] = {
  NSPAIR(_ZN7ee50000C1Ev),
  NSPAIR(_ZN7ee50000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee50000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50000[];
extern void _ZN7ee500003barEv();
static  VTBL_ENTRY vtc_ee50000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50000[0]),
  (VTBL_ENTRY)&_ZN7ee500003barEv,
};
extern VTBL_ENTRY _ZTV7ee50000[];
static  VTT_ENTRY vtt_ee50000[] = {
  {&(_ZTV7ee50000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee50000[];
extern  VTBL_ENTRY _ZTV7ee50000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50000[];
Class_Descriptor cd_ee50000 = {  "ee50000", // class name
  bases_ee50000, 4,
  &(vtc_ee50000[0]), // expected_vtbl_contents
  &(vtt_ee50000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee50000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60000  : dd0000 {
  int e;
  virtual void  foo(); // _ZN7ee600003fooEv
  virtual void  bar(); // _ZN7ee600003barEv
  ~ee60000(); // tgen
  ee60000(); // tgen
};
//SIG(1 ee60000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee60000 ::foo(){vfunc_called(this, "_ZN7ee600003fooEv");}
void  ee60000 ::bar(){vfunc_called(this, "_ZN7ee600003barEv");}
ee60000 ::~ee60000(){ note_dtor("ee60000", this);} // tgen
ee60000 ::ee60000(){ note_ctor("ee60000", this);} // tgen

static void Test_ee60000()
{
  extern Class_Descriptor cd_ee60000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60000, buf);
    ee60000 *dp, &lv = *(dp=new (buf) ee60000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), ABISELECT(8,4), "ee60000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), ABISELECT(8,4), "ee60000");
    check_base_class_offset(lv, (cc000*)(dd0000*), ABISELECT(8,4), "ee60000");
    check_base_class_offset(lv, (dd0000*), ABISELECT(8,4), "ee60000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60000.e");
    test_class_info(&lv, &cd_ee60000);
    dp->~ee60000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60000(Test_ee60000, "ee60000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60000C1Ev();
extern void _ZN7ee60000D1Ev();
Name_Map name_map_ee60000[] = {
  NSPAIR(_ZN7ee60000C1Ev),
  NSPAIR(_ZN7ee60000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee60000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60000[];
extern void _ZN7ee600003fooEv();
extern void _ZN7ee600003barEv();
static  VTBL_ENTRY vtc_ee60000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60000[0]),
  (VTBL_ENTRY)&_ZN7ee600003fooEv,
  (VTBL_ENTRY)&_ZN7ee600003barEv,
};
extern VTBL_ENTRY _ZTI7ee60000[];
extern  VTBL_ENTRY _ZTV7ee60000[];
Class_Descriptor cd_ee60000 = {  "ee60000", // class name
  bases_ee60000, 4,
  &(vtc_ee60000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee60000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70000  : virtual dd0000 {
  int e;
  virtual void  foo(); // _ZN7ee700003fooEv
  virtual void  bar(); // _ZN7ee700003barEv
  ~ee70000(); // tgen
  ee70000(); // tgen
};
//SIG(1 ee70000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee70000 ::foo(){vfunc_called(this, "_ZN7ee700003fooEv");}
void  ee70000 ::bar(){vfunc_called(this, "_ZN7ee700003barEv");}
ee70000 ::~ee70000(){ note_dtor("ee70000", this);} // tgen
ee70000 ::ee70000(){ note_ctor("ee70000", this);} // tgen

static void Test_ee70000()
{
  extern Class_Descriptor cd_ee70000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee70000, buf);
    ee70000 *dp, &lv = *(dp=new (buf) ee70000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee70000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee70000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd0000*), ABISELECT(12,8), "ee70000");
    check_base_class_offset(lv, (cc000*)(dd0000*), ABISELECT(12,8), "ee70000");
    check_base_class_offset(lv, (dd0000*), ABISELECT(12,8), "ee70000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70000.e");
    test_class_info(&lv, &cd_ee70000);
    dp->~ee70000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70000(Test_ee70000, "ee70000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee70000C1Ev();
extern void _ZN7ee70000D1Ev();
Name_Map name_map_ee70000[] = {
  NSPAIR(_ZN7ee70000C1Ev),
  NSPAIR(_ZN7ee70000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd0000;
extern VTBL_ENTRY _ZTI6dd0000[];
static Base_Class bases_ee70000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70000[];
extern void _ZN7ee700003fooEv();
extern void _ZN7ee700003barEv();
static  VTBL_ENTRY vtc_ee70000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70000[0]),
  (VTBL_ENTRY)&_ZN7ee700003fooEv,
  (VTBL_ENTRY)&_ZN7ee700003barEv,
};
extern VTBL_ENTRY _ZTV7ee70000[];
static  VTT_ENTRY vtt_ee70000[] = {
  {&(_ZTV7ee70000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee70000[];
extern  VTBL_ENTRY _ZTV7ee70000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70000[];
Class_Descriptor cd_ee70000 = {  "ee70000", // class name
  bases_ee70000, 4,
  &(vtc_ee70000[0]), // expected_vtbl_contents
  &(vtt_ee70000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee70000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1000  : virtual cc000 {
  int d;
  ~dd1000(); // tgen
  dd1000(); // tgen
};
//SIG(-1 dd1000) C1{ VBC2{ BC3{ BC4{ Fi} Fi} Fi} Fi}


dd1000 ::~dd1000(){ note_dtor("dd1000", this);} // tgen
dd1000 ::dd1000(){ note_ctor("dd1000", this);} // tgen

static void Test_dd1000()
{
  extern Class_Descriptor cd_dd1000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd1000, buf);
    dd1000 *dp, &lv = *(dp=new (buf) dd1000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd1000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(12,8), "dd1000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(12,8), "dd1000");
    check_base_class_offset(lv, (cc000*), ABISELECT(12,8), "dd1000");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1000.d");
    test_class_info(&lv, &cd_dd1000);
    dp->~dd1000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1000(Test_dd1000, "dd1000", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd1000C1Ev();
extern void _ZN6dd1000D1Ev();
Name_Map name_map_dd1000[] = {
  NSPAIR(_ZN6dd1000C1Ev),
  NSPAIR(_ZN6dd1000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd1000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1000[];
static  VTBL_ENTRY vtc_dd1000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
extern VTBL_ENTRY _ZTV6dd1000[];
static  VTT_ENTRY vtt_dd1000[] = {
  {&(_ZTV6dd1000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
Class_Descriptor cd_dd1000 = {  "dd1000", // class name
  bases_dd1000, 3,
  &(vtc_dd1000[0]), // expected_vtbl_contents
  &(vtt_dd1000[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd1000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1000),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01000  : dd1000 {
  int e;
  ~ee01000(); // tgen
  ee01000(); // tgen
};
//SIG(1 ee01000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} Fi}


ee01000 ::~ee01000(){ note_dtor("ee01000", this);} // tgen
ee01000 ::ee01000(){ note_ctor("ee01000", this);} // tgen

static void Test_ee01000()
{
  extern Class_Descriptor cd_ee01000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee01000, buf);
    ee01000 *dp, &lv = *(dp=new (buf) ee01000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee01000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee01000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee01000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(16,12), "ee01000");
    check_base_class_offset(lv, (dd1000*), 0, "ee01000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01000.e");
    test_class_info(&lv, &cd_ee01000);
    dp->~ee01000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01000(Test_ee01000, "ee01000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee01000C1Ev();
extern void _ZN7ee01000D1Ev();
Name_Map name_map_ee01000[] = {
  NSPAIR(_ZN7ee01000C1Ev),
  NSPAIR(_ZN7ee01000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee01000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01000[];
static  VTBL_ENTRY vtc_ee01000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01000[0]),
};
extern VTBL_ENTRY _ZTV7ee01000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee01000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee01000[] = {
  {&(_ZTV7ee01000[3]),  3,3},
  {&(_tg__ZTV6dd1000__7ee01000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee01000[];
extern  VTBL_ENTRY _ZTV7ee01000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01000[];
Class_Descriptor cd_ee01000 = {  "ee01000", // class name
  bases_ee01000, 4,
  &(vtc_ee01000[0]), // expected_vtbl_contents
  &(vtt_ee01000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee01000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01000),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11000  : virtual dd1000 {
  int e;
  ~ee11000(); // tgen
  ee11000(); // tgen
};
//SIG(1 ee11000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} Fi}


ee11000 ::~ee11000(){ note_dtor("ee11000", this);} // tgen
ee11000 ::ee11000(){ note_ctor("ee11000", this);} // tgen

static void Test_ee11000()
{
  extern Class_Descriptor cd_ee11000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee11000, buf);
    ee11000 *dp, &lv = *(dp=new (buf) ee11000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee11000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee11000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee11000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(28,16), "ee11000");
    check_base_class_offset(lv, (dd1000*), ABISELECT(16,8), "ee11000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11000.e");
    test_class_info(&lv, &cd_ee11000);
    dp->~ee11000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11000(Test_ee11000, "ee11000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee11000C1Ev();
extern void _ZN7ee11000D1Ev();
Name_Map name_map_ee11000[] = {
  NSPAIR(_ZN7ee11000C1Ev),
  NSPAIR(_ZN7ee11000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee11000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11000[];
static  VTBL_ENTRY vtc_ee11000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11000[0]),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11000[0]),
};
extern VTBL_ENTRY _ZTV7ee11000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee11000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee11000[] = {
  {&(_ZTV7ee11000[4]),  4,7},
  {&(_ZTV7ee11000[7]),  7,7},
  {&(_tg__ZTV6dd1000__7ee11000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee11000[];
extern  VTBL_ENTRY _ZTV7ee11000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11000[];
Class_Descriptor cd_ee11000 = {  "ee11000", // class name
  bases_ee11000, 4,
  &(vtc_ee11000[0]), // expected_vtbl_contents
  &(vtt_ee11000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee11000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11000),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21000  : dd1000 {
  int e;
  virtual void  foo(); // _ZN7ee210003fooEv
  ~ee21000(); // tgen
  ee21000(); // tgen
};
//SIG(1 ee21000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee21000 ::foo(){vfunc_called(this, "_ZN7ee210003fooEv");}
ee21000 ::~ee21000(){ note_dtor("ee21000", this);} // tgen
ee21000 ::ee21000(){ note_ctor("ee21000", this);} // tgen

static void Test_ee21000()
{
  extern Class_Descriptor cd_ee21000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee21000, buf);
    ee21000 *dp, &lv = *(dp=new (buf) ee21000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee21000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee21000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee21000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(16,12), "ee21000");
    check_base_class_offset(lv, (dd1000*), 0, "ee21000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21000.e");
    test_class_info(&lv, &cd_ee21000);
    dp->~ee21000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21000(Test_ee21000, "ee21000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee21000C1Ev();
extern void _ZN7ee21000D1Ev();
Name_Map name_map_ee21000[] = {
  NSPAIR(_ZN7ee21000C1Ev),
  NSPAIR(_ZN7ee21000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee21000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21000[];
extern void _ZN7ee210003fooEv();
static  VTBL_ENTRY vtc_ee21000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21000[0]),
  (VTBL_ENTRY)&_ZN7ee210003fooEv,
};
extern VTBL_ENTRY _ZTV7ee21000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee21000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee21000[] = {
  {&(_ZTV7ee21000[3]),  3,4},
  {&(_tg__ZTV6dd1000__7ee21000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee21000[];
extern  VTBL_ENTRY _ZTV7ee21000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21000[];
Class_Descriptor cd_ee21000 = {  "ee21000", // class name
  bases_ee21000, 4,
  &(vtc_ee21000[0]), // expected_vtbl_contents
  &(vtt_ee21000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee21000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31000  : virtual dd1000 {
  int e;
  virtual void  foo(); // _ZN7ee310003fooEv
  ~ee31000(); // tgen
  ee31000(); // tgen
};
//SIG(1 ee31000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee31000 ::foo(){vfunc_called(this, "_ZN7ee310003fooEv");}
ee31000 ::~ee31000(){ note_dtor("ee31000", this);} // tgen
ee31000 ::ee31000(){ note_ctor("ee31000", this);} // tgen

static void Test_ee31000()
{
  extern Class_Descriptor cd_ee31000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee31000, buf);
    ee31000 *dp, &lv = *(dp=new (buf) ee31000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee31000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee31000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee31000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(28,16), "ee31000");
    check_base_class_offset(lv, (dd1000*), ABISELECT(16,8), "ee31000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31000.e");
    test_class_info(&lv, &cd_ee31000);
    dp->~ee31000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31000(Test_ee31000, "ee31000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee31000C1Ev();
extern void _ZN7ee31000D1Ev();
Name_Map name_map_ee31000[] = {
  NSPAIR(_ZN7ee31000C1Ev),
  NSPAIR(_ZN7ee31000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee31000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31000[];
extern void _ZN7ee310003fooEv();
static  VTBL_ENTRY vtc_ee31000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31000[0]),
  (VTBL_ENTRY)&_ZN7ee310003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31000[0]),
};
extern VTBL_ENTRY _ZTV7ee31000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee31000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee31000[] = {
  {&(_ZTV7ee31000[4]),  4,8},
  {&(_ZTV7ee31000[8]),  8,8},
  {&(_tg__ZTV6dd1000__7ee31000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee31000[];
extern  VTBL_ENTRY _ZTV7ee31000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31000[];
Class_Descriptor cd_ee31000 = {  "ee31000", // class name
  bases_ee31000, 4,
  &(vtc_ee31000[0]), // expected_vtbl_contents
  &(vtt_ee31000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee31000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31000),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41000  : dd1000 {
  int e;
  virtual void  bar(); // _ZN7ee410003barEv
  ~ee41000(); // tgen
  ee41000(); // tgen
};
//SIG(1 ee41000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee41000 ::bar(){vfunc_called(this, "_ZN7ee410003barEv");}
ee41000 ::~ee41000(){ note_dtor("ee41000", this);} // tgen
ee41000 ::ee41000(){ note_ctor("ee41000", this);} // tgen

static void Test_ee41000()
{
  extern Class_Descriptor cd_ee41000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee41000, buf);
    ee41000 *dp, &lv = *(dp=new (buf) ee41000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee41000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee41000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee41000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(16,12), "ee41000");
    check_base_class_offset(lv, (dd1000*), 0, "ee41000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41000.e");
    test_class_info(&lv, &cd_ee41000);
    dp->~ee41000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41000(Test_ee41000, "ee41000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee41000C1Ev();
extern void _ZN7ee41000D1Ev();
Name_Map name_map_ee41000[] = {
  NSPAIR(_ZN7ee41000C1Ev),
  NSPAIR(_ZN7ee41000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee41000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41000[];
extern void _ZN7ee410003barEv();
static  VTBL_ENTRY vtc_ee41000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41000[0]),
  (VTBL_ENTRY)&_ZN7ee410003barEv,
};
extern VTBL_ENTRY _ZTV7ee41000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee41000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee41000[] = {
  {&(_ZTV7ee41000[3]),  3,4},
  {&(_tg__ZTV6dd1000__7ee41000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee41000[];
extern  VTBL_ENTRY _ZTV7ee41000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41000[];
Class_Descriptor cd_ee41000 = {  "ee41000", // class name
  bases_ee41000, 4,
  &(vtc_ee41000[0]), // expected_vtbl_contents
  &(vtt_ee41000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee41000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51000  : virtual dd1000 {
  int e;
  virtual void  bar(); // _ZN7ee510003barEv
  ~ee51000(); // tgen
  ee51000(); // tgen
};
//SIG(1 ee51000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee51000 ::bar(){vfunc_called(this, "_ZN7ee510003barEv");}
ee51000 ::~ee51000(){ note_dtor("ee51000", this);} // tgen
ee51000 ::ee51000(){ note_ctor("ee51000", this);} // tgen

static void Test_ee51000()
{
  extern Class_Descriptor cd_ee51000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee51000, buf);
    ee51000 *dp, &lv = *(dp=new (buf) ee51000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee51000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee51000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee51000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(28,16), "ee51000");
    check_base_class_offset(lv, (dd1000*), ABISELECT(16,8), "ee51000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51000.e");
    test_class_info(&lv, &cd_ee51000);
    dp->~ee51000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51000(Test_ee51000, "ee51000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee51000C1Ev();
extern void _ZN7ee51000D1Ev();
Name_Map name_map_ee51000[] = {
  NSPAIR(_ZN7ee51000C1Ev),
  NSPAIR(_ZN7ee51000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee51000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51000[];
extern void _ZN7ee510003barEv();
static  VTBL_ENTRY vtc_ee51000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51000[0]),
  (VTBL_ENTRY)&_ZN7ee510003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51000[0]),
};
extern VTBL_ENTRY _ZTV7ee51000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee51000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee51000[] = {
  {&(_ZTV7ee51000[4]),  4,8},
  {&(_ZTV7ee51000[8]),  8,8},
  {&(_tg__ZTV6dd1000__7ee51000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee51000[];
extern  VTBL_ENTRY _ZTV7ee51000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51000[];
Class_Descriptor cd_ee51000 = {  "ee51000", // class name
  bases_ee51000, 4,
  &(vtc_ee51000[0]), // expected_vtbl_contents
  &(vtt_ee51000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee51000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51000),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61000  : dd1000 {
  int e;
  virtual void  foo(); // _ZN7ee610003fooEv
  virtual void  bar(); // _ZN7ee610003barEv
  ~ee61000(); // tgen
  ee61000(); // tgen
};
//SIG(1 ee61000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee61000 ::foo(){vfunc_called(this, "_ZN7ee610003fooEv");}
void  ee61000 ::bar(){vfunc_called(this, "_ZN7ee610003barEv");}
ee61000 ::~ee61000(){ note_dtor("ee61000", this);} // tgen
ee61000 ::ee61000(){ note_ctor("ee61000", this);} // tgen

static void Test_ee61000()
{
  extern Class_Descriptor cd_ee61000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee61000, buf);
    ee61000 *dp, &lv = *(dp=new (buf) ee61000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee61000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee61000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee61000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(16,12), "ee61000");
    check_base_class_offset(lv, (dd1000*), 0, "ee61000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61000.e");
    test_class_info(&lv, &cd_ee61000);
    dp->~ee61000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61000(Test_ee61000, "ee61000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee61000C1Ev();
extern void _ZN7ee61000D1Ev();
Name_Map name_map_ee61000[] = {
  NSPAIR(_ZN7ee61000C1Ev),
  NSPAIR(_ZN7ee61000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee61000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61000[];
extern void _ZN7ee610003fooEv();
extern void _ZN7ee610003barEv();
static  VTBL_ENTRY vtc_ee61000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61000[0]),
  (VTBL_ENTRY)&_ZN7ee610003fooEv,
  (VTBL_ENTRY)&_ZN7ee610003barEv,
};
extern VTBL_ENTRY _ZTV7ee61000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee61000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee61000[] = {
  {&(_ZTV7ee61000[3]),  3,5},
  {&(_tg__ZTV6dd1000__7ee61000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee61000[];
extern  VTBL_ENTRY _ZTV7ee61000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61000[];
Class_Descriptor cd_ee61000 = {  "ee61000", // class name
  bases_ee61000, 4,
  &(vtc_ee61000[0]), // expected_vtbl_contents
  &(vtt_ee61000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee61000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71000  : virtual dd1000 {
  int e;
  virtual void  foo(); // _ZN7ee710003fooEv
  virtual void  bar(); // _ZN7ee710003barEv
  ~ee71000(); // tgen
  ee71000(); // tgen
};
//SIG(1 ee71000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee71000 ::foo(){vfunc_called(this, "_ZN7ee710003fooEv");}
void  ee71000 ::bar(){vfunc_called(this, "_ZN7ee710003barEv");}
ee71000 ::~ee71000(){ note_dtor("ee71000", this);} // tgen
ee71000 ::ee71000(){ note_ctor("ee71000", this);} // tgen

static void Test_ee71000()
{
  extern Class_Descriptor cd_ee71000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee71000, buf);
    ee71000 *dp, &lv = *(dp=new (buf) ee71000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee71000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee71000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee71000");
    check_base_class_offset(lv, (cc000*)(dd1000*), ABISELECT(28,16), "ee71000");
    check_base_class_offset(lv, (dd1000*), ABISELECT(16,8), "ee71000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71000.e");
    test_class_info(&lv, &cd_ee71000);
    dp->~ee71000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71000(Test_ee71000, "ee71000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee71000C1Ev();
extern void _ZN7ee71000D1Ev();
Name_Map name_map_ee71000[] = {
  NSPAIR(_ZN7ee71000C1Ev),
  NSPAIR(_ZN7ee71000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd1000;
extern VTBL_ENTRY _ZTI6dd1000[];
extern  VTBL_ENTRY _ZTV6dd1000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1000[];
static Base_Class bases_ee71000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1000,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71000[];
extern void _ZN7ee710003fooEv();
extern void _ZN7ee710003barEv();
static  VTBL_ENTRY vtc_ee71000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71000[0]),
  (VTBL_ENTRY)&_ZN7ee710003fooEv,
  (VTBL_ENTRY)&_ZN7ee710003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71000[0]),
};
extern VTBL_ENTRY _ZTV7ee71000[];
static  VTBL_ENTRY _tg__ZTV6dd1000__7ee71000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1000[0]),
};
static  VTT_ENTRY vtt_ee71000[] = {
  {&(_ZTV7ee71000[4]),  4,9},
  {&(_ZTV7ee71000[9]),  9,9},
  {&(_tg__ZTV6dd1000__7ee71000[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee71000[];
extern  VTBL_ENTRY _ZTV7ee71000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71000[];
Class_Descriptor cd_ee71000 = {  "ee71000", // class name
  bases_ee71000, 4,
  &(vtc_ee71000[0]), // expected_vtbl_contents
  &(vtt_ee71000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee71000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71000),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2000  : cc000 {
  int d;
  virtual void  foo(); // _ZN6dd20003fooEv
  ~dd2000(); // tgen
  dd2000(); // tgen
};
//SIG(-1 dd2000) C1{ BC2{ BC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd2000 ::foo(){vfunc_called(this, "_ZN6dd20003fooEv");}
dd2000 ::~dd2000(){ note_dtor("dd2000", this);} // tgen
dd2000 ::dd2000(){ note_ctor("dd2000", this);} // tgen

static void Test_dd2000()
{
  extern Class_Descriptor cd_dd2000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2000, buf);
    dd2000 *dp, &lv = *(dp=new (buf) dd2000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(8,4), "dd2000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(8,4), "dd2000");
    check_base_class_offset(lv, (cc000*), ABISELECT(8,4), "dd2000");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2000.d");
    test_class_info(&lv, &cd_dd2000);
    dp->~dd2000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2000(Test_dd2000, "dd2000", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2000C1Ev();
extern void _ZN6dd2000D1Ev();
Name_Map name_map_dd2000[] = {
  NSPAIR(_ZN6dd2000C1Ev),
  NSPAIR(_ZN6dd2000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd2000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2000[];
extern void _ZN6dd20003fooEv();
static  VTBL_ENTRY vtc_dd2000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2000[0]),
  (VTBL_ENTRY)&_ZN6dd20003fooEv,
};
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
Class_Descriptor cd_dd2000 = {  "dd2000", // class name
  bases_dd2000, 3,
  &(vtc_dd2000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd2000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02000  : dd2000 {
  int e;
  ~ee02000(); // tgen
  ee02000(); // tgen
};
//SIG(1 ee02000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee02000 ::~ee02000(){ note_dtor("ee02000", this);} // tgen
ee02000 ::ee02000(){ note_ctor("ee02000", this);} // tgen

static void Test_ee02000()
{
  extern Class_Descriptor cd_ee02000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02000, buf);
    ee02000 *dp, &lv = *(dp=new (buf) ee02000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee02000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee02000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(8,4), "ee02000");
    check_base_class_offset(lv, (dd2000*), 0, "ee02000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02000.e");
    test_class_info(&lv, &cd_ee02000);
    dp->~ee02000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02000(Test_ee02000, "ee02000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02000C1Ev();
extern void _ZN7ee02000D1Ev();
Name_Map name_map_ee02000[] = {
  NSPAIR(_ZN7ee02000C1Ev),
  NSPAIR(_ZN7ee02000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee02000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02000[];
extern void _ZN6dd20003fooEv();
static  VTBL_ENTRY vtc_ee02000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02000[0]),
  (VTBL_ENTRY)&_ZN6dd20003fooEv,
};
extern VTBL_ENTRY _ZTI7ee02000[];
extern  VTBL_ENTRY _ZTV7ee02000[];
Class_Descriptor cd_ee02000 = {  "ee02000", // class name
  bases_ee02000, 4,
  &(vtc_ee02000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12000  : virtual dd2000 {
  int e;
  ~ee12000(); // tgen
  ee12000(); // tgen
};
//SIG(1 ee12000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee12000 ::~ee12000(){ note_dtor("ee12000", this);} // tgen
ee12000 ::ee12000(){ note_ctor("ee12000", this);} // tgen

static void Test_ee12000()
{
  extern Class_Descriptor cd_ee12000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12000, buf);
    ee12000 *dp, &lv = *(dp=new (buf) ee12000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee12000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee12000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(24,12), "ee12000");
    check_base_class_offset(lv, (dd2000*), ABISELECT(16,8), "ee12000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12000.e");
    test_class_info(&lv, &cd_ee12000);
    dp->~ee12000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12000(Test_ee12000, "ee12000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12000C1Ev();
extern void _ZN7ee12000D1Ev();
Name_Map name_map_ee12000[] = {
  NSPAIR(_ZN7ee12000C1Ev),
  NSPAIR(_ZN7ee12000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee12000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12000[];
extern void _ZN6dd20003fooEv();
static  VTBL_ENTRY vtc_ee12000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12000[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12000[0]),
  (VTBL_ENTRY)&_ZN6dd20003fooEv,
};
extern VTBL_ENTRY _ZTV7ee12000[];
static  VTT_ENTRY vtt_ee12000[] = {
  {&(_ZTV7ee12000[3]),  3,7},
  {&(_ZTV7ee12000[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee12000[];
extern  VTBL_ENTRY _ZTV7ee12000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12000[];
Class_Descriptor cd_ee12000 = {  "ee12000", // class name
  bases_ee12000, 4,
  &(vtc_ee12000[0]), // expected_vtbl_contents
  &(vtt_ee12000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12000),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22000  : dd2000 {
  int e;
  virtual void  foo(); // _ZN7ee220003fooEv
  ~ee22000(); // tgen
  ee22000(); // tgen
};
//SIG(1 ee22000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee22000 ::foo(){vfunc_called(this, "_ZN7ee220003fooEv");}
ee22000 ::~ee22000(){ note_dtor("ee22000", this);} // tgen
ee22000 ::ee22000(){ note_ctor("ee22000", this);} // tgen

static void Test_ee22000()
{
  extern Class_Descriptor cd_ee22000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22000, buf);
    ee22000 *dp, &lv = *(dp=new (buf) ee22000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee22000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee22000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(8,4), "ee22000");
    check_base_class_offset(lv, (dd2000*), 0, "ee22000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22000.e");
    test_class_info(&lv, &cd_ee22000);
    dp->~ee22000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22000(Test_ee22000, "ee22000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22000C1Ev();
extern void _ZN7ee22000D1Ev();
Name_Map name_map_ee22000[] = {
  NSPAIR(_ZN7ee22000C1Ev),
  NSPAIR(_ZN7ee22000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee22000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22000[];
extern void _ZN7ee220003fooEv();
static  VTBL_ENTRY vtc_ee22000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22000[0]),
  (VTBL_ENTRY)&_ZN7ee220003fooEv,
};
extern VTBL_ENTRY _ZTI7ee22000[];
extern  VTBL_ENTRY _ZTV7ee22000[];
Class_Descriptor cd_ee22000 = {  "ee22000", // class name
  bases_ee22000, 4,
  &(vtc_ee22000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32000  : virtual dd2000 {
  int e;
  virtual void  foo(); // _ZN7ee320003fooEv
  ~ee32000(); // tgen
  ee32000(); // tgen
};
//SIG(1 ee32000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee32000 ::foo(){vfunc_called(this, "_ZN7ee320003fooEv");}
ee32000 ::~ee32000(){ note_dtor("ee32000", this);} // tgen
ee32000 ::ee32000(){ note_ctor("ee32000", this);} // tgen

static void Test_ee32000()
{
  extern Class_Descriptor cd_ee32000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32000, buf);
    ee32000 *dp, &lv = *(dp=new (buf) ee32000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee32000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee32000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(24,12), "ee32000");
    check_base_class_offset(lv, (dd2000*), ABISELECT(16,8), "ee32000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32000.e");
    test_class_info(&lv, &cd_ee32000);
    dp->~ee32000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32000(Test_ee32000, "ee32000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32000C1Ev();
extern void _ZN7ee32000D1Ev();
Name_Map name_map_ee32000[] = {
  NSPAIR(_ZN7ee32000C1Ev),
  NSPAIR(_ZN7ee32000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee32000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32000[];
extern void _ZN7ee320003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee320003fooEv,_ZTv0_n12_N7ee320003fooEv)();
extern void ABISELECT(_ZThn16_N7ee320003fooEv,_ZThn8_N7ee320003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32000[0]),
  (VTBL_ENTRY)&_ZN7ee320003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee320003fooEv,_ZTv0_n12_N7ee320003fooEv),
};
extern VTBL_ENTRY _ZTV7ee32000[];
static  VTT_ENTRY vtt_ee32000[] = {
  {&(_ZTV7ee32000[3]),  3,8},
  {&(_ZTV7ee32000[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee32000[];
extern  VTBL_ENTRY _ZTV7ee32000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32000[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee320003fooEv,_ZTv0_n12_N7ee320003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee320003fooEv,_ZThn8_N7ee320003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32000 = {  "ee32000", // class name
  bases_ee32000, 4,
  &(vtc_ee32000[0]), // expected_vtbl_contents
  &(vtt_ee32000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32000),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42000  : dd2000 {
  int e;
  virtual void  bar(); // _ZN7ee420003barEv
  ~ee42000(); // tgen
  ee42000(); // tgen
};
//SIG(1 ee42000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee42000 ::bar(){vfunc_called(this, "_ZN7ee420003barEv");}
ee42000 ::~ee42000(){ note_dtor("ee42000", this);} // tgen
ee42000 ::ee42000(){ note_ctor("ee42000", this);} // tgen

static void Test_ee42000()
{
  extern Class_Descriptor cd_ee42000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42000, buf);
    ee42000 *dp, &lv = *(dp=new (buf) ee42000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee42000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee42000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(8,4), "ee42000");
    check_base_class_offset(lv, (dd2000*), 0, "ee42000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42000.e");
    test_class_info(&lv, &cd_ee42000);
    dp->~ee42000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42000(Test_ee42000, "ee42000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42000C1Ev();
extern void _ZN7ee42000D1Ev();
Name_Map name_map_ee42000[] = {
  NSPAIR(_ZN7ee42000C1Ev),
  NSPAIR(_ZN7ee42000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee42000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42000[];
extern void _ZN6dd20003fooEv();
extern void _ZN7ee420003barEv();
static  VTBL_ENTRY vtc_ee42000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42000[0]),
  (VTBL_ENTRY)&_ZN6dd20003fooEv,
  (VTBL_ENTRY)&_ZN7ee420003barEv,
};
extern VTBL_ENTRY _ZTI7ee42000[];
extern  VTBL_ENTRY _ZTV7ee42000[];
Class_Descriptor cd_ee42000 = {  "ee42000", // class name
  bases_ee42000, 4,
  &(vtc_ee42000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52000  : virtual dd2000 {
  int e;
  virtual void  bar(); // _ZN7ee520003barEv
  ~ee52000(); // tgen
  ee52000(); // tgen
};
//SIG(1 ee52000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee52000 ::bar(){vfunc_called(this, "_ZN7ee520003barEv");}
ee52000 ::~ee52000(){ note_dtor("ee52000", this);} // tgen
ee52000 ::ee52000(){ note_ctor("ee52000", this);} // tgen

static void Test_ee52000()
{
  extern Class_Descriptor cd_ee52000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52000, buf);
    ee52000 *dp, &lv = *(dp=new (buf) ee52000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee52000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee52000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(24,12), "ee52000");
    check_base_class_offset(lv, (dd2000*), ABISELECT(16,8), "ee52000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52000.e");
    test_class_info(&lv, &cd_ee52000);
    dp->~ee52000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52000(Test_ee52000, "ee52000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52000C1Ev();
extern void _ZN7ee52000D1Ev();
Name_Map name_map_ee52000[] = {
  NSPAIR(_ZN7ee52000C1Ev),
  NSPAIR(_ZN7ee52000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee52000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52000[];
extern void _ZN7ee520003barEv();
extern void _ZN6dd20003fooEv();
static  VTBL_ENTRY vtc_ee52000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52000[0]),
  (VTBL_ENTRY)&_ZN7ee520003barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52000[0]),
  (VTBL_ENTRY)&_ZN6dd20003fooEv,
};
extern VTBL_ENTRY _ZTV7ee52000[];
static  VTT_ENTRY vtt_ee52000[] = {
  {&(_ZTV7ee52000[3]),  3,8},
  {&(_ZTV7ee52000[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee52000[];
extern  VTBL_ENTRY _ZTV7ee52000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52000[];
Class_Descriptor cd_ee52000 = {  "ee52000", // class name
  bases_ee52000, 4,
  &(vtc_ee52000[0]), // expected_vtbl_contents
  &(vtt_ee52000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52000),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62000  : dd2000 {
  int e;
  virtual void  foo(); // _ZN7ee620003fooEv
  virtual void  bar(); // _ZN7ee620003barEv
  ~ee62000(); // tgen
  ee62000(); // tgen
};
//SIG(1 ee62000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62000 ::foo(){vfunc_called(this, "_ZN7ee620003fooEv");}
void  ee62000 ::bar(){vfunc_called(this, "_ZN7ee620003barEv");}
ee62000 ::~ee62000(){ note_dtor("ee62000", this);} // tgen
ee62000 ::ee62000(){ note_ctor("ee62000", this);} // tgen

static void Test_ee62000()
{
  extern Class_Descriptor cd_ee62000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62000, buf);
    ee62000 *dp, &lv = *(dp=new (buf) ee62000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee62000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(8,4), "ee62000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(8,4), "ee62000");
    check_base_class_offset(lv, (dd2000*), 0, "ee62000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62000.e");
    test_class_info(&lv, &cd_ee62000);
    dp->~ee62000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62000(Test_ee62000, "ee62000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62000C1Ev();
extern void _ZN7ee62000D1Ev();
Name_Map name_map_ee62000[] = {
  NSPAIR(_ZN7ee62000C1Ev),
  NSPAIR(_ZN7ee62000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee62000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62000[];
extern void _ZN7ee620003fooEv();
extern void _ZN7ee620003barEv();
static  VTBL_ENTRY vtc_ee62000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62000[0]),
  (VTBL_ENTRY)&_ZN7ee620003fooEv,
  (VTBL_ENTRY)&_ZN7ee620003barEv,
};
extern VTBL_ENTRY _ZTI7ee62000[];
extern  VTBL_ENTRY _ZTV7ee62000[];
Class_Descriptor cd_ee62000 = {  "ee62000", // class name
  bases_ee62000, 4,
  &(vtc_ee62000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72000  : virtual dd2000 {
  int e;
  virtual void  foo(); // _ZN7ee720003fooEv
  virtual void  bar(); // _ZN7ee720003barEv
  ~ee72000(); // tgen
  ee72000(); // tgen
};
//SIG(1 ee72000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72000 ::foo(){vfunc_called(this, "_ZN7ee720003fooEv");}
void  ee72000 ::bar(){vfunc_called(this, "_ZN7ee720003barEv");}
ee72000 ::~ee72000(){ note_dtor("ee72000", this);} // tgen
ee72000 ::ee72000(){ note_ctor("ee72000", this);} // tgen

static void Test_ee72000()
{
  extern Class_Descriptor cd_ee72000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72000, buf);
    ee72000 *dp, &lv = *(dp=new (buf) ee72000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee72000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd2000*), ABISELECT(24,12), "ee72000");
    check_base_class_offset(lv, (cc000*)(dd2000*), ABISELECT(24,12), "ee72000");
    check_base_class_offset(lv, (dd2000*), ABISELECT(16,8), "ee72000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72000.e");
    test_class_info(&lv, &cd_ee72000);
    dp->~ee72000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72000(Test_ee72000, "ee72000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72000C1Ev();
extern void _ZN7ee72000D1Ev();
Name_Map name_map_ee72000[] = {
  NSPAIR(_ZN7ee72000C1Ev),
  NSPAIR(_ZN7ee72000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd2000;
extern VTBL_ENTRY _ZTI6dd2000[];
extern  VTBL_ENTRY _ZTV6dd2000[];
static Base_Class bases_ee72000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72000[];
extern void _ZN7ee720003fooEv();
extern void _ZN7ee720003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee720003fooEv,_ZTv0_n12_N7ee720003fooEv)();
extern void ABISELECT(_ZThn16_N7ee720003fooEv,_ZThn8_N7ee720003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72000[0]),
  (VTBL_ENTRY)&_ZN7ee720003fooEv,
  (VTBL_ENTRY)&_ZN7ee720003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee720003fooEv,_ZTv0_n12_N7ee720003fooEv),
};
extern VTBL_ENTRY _ZTV7ee72000[];
static  VTT_ENTRY vtt_ee72000[] = {
  {&(_ZTV7ee72000[3]),  3,9},
  {&(_ZTV7ee72000[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee72000[];
extern  VTBL_ENTRY _ZTV7ee72000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72000[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee720003fooEv,_ZTv0_n12_N7ee720003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee720003fooEv,_ZThn8_N7ee720003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72000 = {  "ee72000", // class name
  bases_ee72000, 4,
  &(vtc_ee72000[0]), // expected_vtbl_contents
  &(vtt_ee72000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72000),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3000  : virtual cc000 {
  int d;
  virtual void  foo(); // _ZN6dd30003fooEv
  ~dd3000(); // tgen
  dd3000(); // tgen
};
//SIG(-1 dd3000) C1{ VBC2{ BC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd3000 ::foo(){vfunc_called(this, "_ZN6dd30003fooEv");}
dd3000 ::~dd3000(){ note_dtor("dd3000", this);} // tgen
dd3000 ::dd3000(){ note_ctor("dd3000", this);} // tgen

static void Test_dd3000()
{
  extern Class_Descriptor cd_dd3000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd3000, buf);
    dd3000 *dp, &lv = *(dp=new (buf) dd3000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd3000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(12,8), "dd3000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(12,8), "dd3000");
    check_base_class_offset(lv, (cc000*), ABISELECT(12,8), "dd3000");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3000.d");
    test_class_info(&lv, &cd_dd3000);
    dp->~dd3000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3000(Test_dd3000, "dd3000", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd3000C1Ev();
extern void _ZN6dd3000D1Ev();
Name_Map name_map_dd3000[] = {
  NSPAIR(_ZN6dd3000C1Ev),
  NSPAIR(_ZN6dd3000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd3000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY vtc_dd3000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
extern VTBL_ENTRY _ZTV6dd3000[];
static  VTT_ENTRY vtt_dd3000[] = {
  {&(_ZTV6dd3000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
Class_Descriptor cd_dd3000 = {  "dd3000", // class name
  bases_dd3000, 3,
  &(vtc_dd3000[0]), // expected_vtbl_contents
  &(vtt_dd3000[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd3000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03000  : dd3000 {
  int e;
  ~ee03000(); // tgen
  ee03000(); // tgen
};
//SIG(1 ee03000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee03000 ::~ee03000(){ note_dtor("ee03000", this);} // tgen
ee03000 ::ee03000(){ note_ctor("ee03000", this);} // tgen

static void Test_ee03000()
{
  extern Class_Descriptor cd_ee03000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee03000, buf);
    ee03000 *dp, &lv = *(dp=new (buf) ee03000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee03000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee03000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee03000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(16,12), "ee03000");
    check_base_class_offset(lv, (dd3000*), 0, "ee03000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03000.e");
    test_class_info(&lv, &cd_ee03000);
    dp->~ee03000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03000(Test_ee03000, "ee03000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee03000C1Ev();
extern void _ZN7ee03000D1Ev();
Name_Map name_map_ee03000[] = {
  NSPAIR(_ZN7ee03000C1Ev),
  NSPAIR(_ZN7ee03000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee03000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY vtc_ee03000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
extern VTBL_ENTRY _ZTV7ee03000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee03000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee03000[] = {
  {&(_ZTV7ee03000[3]),  3,4},
  {&(_tg__ZTV6dd3000__7ee03000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee03000[];
extern  VTBL_ENTRY _ZTV7ee03000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03000[];
Class_Descriptor cd_ee03000 = {  "ee03000", // class name
  bases_ee03000, 4,
  &(vtc_ee03000[0]), // expected_vtbl_contents
  &(vtt_ee03000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee03000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13000  : virtual dd3000 {
  int e;
  ~ee13000(); // tgen
  ee13000(); // tgen
};
//SIG(1 ee13000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee13000 ::~ee13000(){ note_dtor("ee13000", this);} // tgen
ee13000 ::ee13000(){ note_ctor("ee13000", this);} // tgen

static void Test_ee13000()
{
  extern Class_Descriptor cd_ee13000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee13000, buf);
    ee13000 *dp, &lv = *(dp=new (buf) ee13000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee13000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee13000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee13000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(28,16), "ee13000");
    check_base_class_offset(lv, (dd3000*), ABISELECT(16,8), "ee13000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13000.e");
    test_class_info(&lv, &cd_ee13000);
    dp->~ee13000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13000(Test_ee13000, "ee13000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee13000C1Ev();
extern void _ZN7ee13000D1Ev();
Name_Map name_map_ee13000[] = {
  NSPAIR(_ZN7ee13000C1Ev),
  NSPAIR(_ZN7ee13000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee13000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY vtc_ee13000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13000[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
extern VTBL_ENTRY _ZTV7ee13000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee13000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee13000[] = {
  {&(_ZTV7ee13000[4]),  4,9},
  {&(_ZTV7ee13000[8]),  8,9},
  {&(_tg__ZTV6dd3000__7ee13000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13000[];
extern  VTBL_ENTRY _ZTV7ee13000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13000[];
Class_Descriptor cd_ee13000 = {  "ee13000", // class name
  bases_ee13000, 4,
  &(vtc_ee13000[0]), // expected_vtbl_contents
  &(vtt_ee13000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee13000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13000),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23000  : dd3000 {
  int e;
  virtual void  foo(); // _ZN7ee230003fooEv
  ~ee23000(); // tgen
  ee23000(); // tgen
};
//SIG(1 ee23000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee23000 ::foo(){vfunc_called(this, "_ZN7ee230003fooEv");}
ee23000 ::~ee23000(){ note_dtor("ee23000", this);} // tgen
ee23000 ::ee23000(){ note_ctor("ee23000", this);} // tgen

static void Test_ee23000()
{
  extern Class_Descriptor cd_ee23000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee23000, buf);
    ee23000 *dp, &lv = *(dp=new (buf) ee23000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee23000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee23000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee23000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(16,12), "ee23000");
    check_base_class_offset(lv, (dd3000*), 0, "ee23000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23000.e");
    test_class_info(&lv, &cd_ee23000);
    dp->~ee23000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23000(Test_ee23000, "ee23000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee23000C1Ev();
extern void _ZN7ee23000D1Ev();
Name_Map name_map_ee23000[] = {
  NSPAIR(_ZN7ee23000C1Ev),
  NSPAIR(_ZN7ee23000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee23000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23000[];
extern void _ZN7ee230003fooEv();
static  VTBL_ENTRY vtc_ee23000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23000[0]),
  (VTBL_ENTRY)&_ZN7ee230003fooEv,
};
extern VTBL_ENTRY _ZTV7ee23000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee23000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee23000[] = {
  {&(_ZTV7ee23000[3]),  3,4},
  {&(_tg__ZTV6dd3000__7ee23000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee23000[];
extern  VTBL_ENTRY _ZTV7ee23000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23000[];
Class_Descriptor cd_ee23000 = {  "ee23000", // class name
  bases_ee23000, 4,
  &(vtc_ee23000[0]), // expected_vtbl_contents
  &(vtt_ee23000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee23000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33000  : virtual dd3000 {
  int e;
  virtual void  foo(); // _ZN7ee330003fooEv
  ~ee33000(); // tgen
  ee33000(); // tgen
};
//SIG(1 ee33000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee33000 ::foo(){vfunc_called(this, "_ZN7ee330003fooEv");}
ee33000 ::~ee33000(){ note_dtor("ee33000", this);} // tgen
ee33000 ::ee33000(){ note_ctor("ee33000", this);} // tgen

static void Test_ee33000()
{
  extern Class_Descriptor cd_ee33000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee33000, buf);
    ee33000 *dp, &lv = *(dp=new (buf) ee33000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee33000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee33000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee33000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(28,16), "ee33000");
    check_base_class_offset(lv, (dd3000*), ABISELECT(16,8), "ee33000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33000.e");
    test_class_info(&lv, &cd_ee33000);
    dp->~ee33000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33000(Test_ee33000, "ee33000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee33000C1Ev();
extern void _ZN7ee33000D1Ev();
Name_Map name_map_ee33000[] = {
  NSPAIR(_ZN7ee33000C1Ev),
  NSPAIR(_ZN7ee33000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee33000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33000[];
extern void _ZN7ee330003fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee330003fooEv,_ZTv0_n16_N7ee330003fooEv)();
extern void ABISELECT(_ZThn16_N7ee330003fooEv,_ZThn8_N7ee330003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33000[0]),
  (VTBL_ENTRY)&_ZN7ee330003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee330003fooEv,_ZTv0_n16_N7ee330003fooEv),
};
extern VTBL_ENTRY _ZTV7ee33000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee33000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee33000[] = {
  {&(_ZTV7ee33000[4]),  4,10},
  {&(_ZTV7ee33000[9]),  9,10},
  {&(_tg__ZTV6dd3000__7ee33000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33000[];
extern  VTBL_ENTRY _ZTV7ee33000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33000[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee330003fooEv,_ZTv0_n16_N7ee330003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee330003fooEv,_ZThn8_N7ee330003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33000 = {  "ee33000", // class name
  bases_ee33000, 4,
  &(vtc_ee33000[0]), // expected_vtbl_contents
  &(vtt_ee33000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee33000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33000),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43000  : dd3000 {
  int e;
  virtual void  bar(); // _ZN7ee430003barEv
  ~ee43000(); // tgen
  ee43000(); // tgen
};
//SIG(1 ee43000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee43000 ::bar(){vfunc_called(this, "_ZN7ee430003barEv");}
ee43000 ::~ee43000(){ note_dtor("ee43000", this);} // tgen
ee43000 ::ee43000(){ note_ctor("ee43000", this);} // tgen

static void Test_ee43000()
{
  extern Class_Descriptor cd_ee43000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee43000, buf);
    ee43000 *dp, &lv = *(dp=new (buf) ee43000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee43000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee43000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee43000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(16,12), "ee43000");
    check_base_class_offset(lv, (dd3000*), 0, "ee43000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43000.e");
    test_class_info(&lv, &cd_ee43000);
    dp->~ee43000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43000(Test_ee43000, "ee43000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee43000C1Ev();
extern void _ZN7ee43000D1Ev();
Name_Map name_map_ee43000[] = {
  NSPAIR(_ZN7ee43000C1Ev),
  NSPAIR(_ZN7ee43000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee43000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43000[];
extern void _ZN6dd30003fooEv();
extern void _ZN7ee430003barEv();
static  VTBL_ENTRY vtc_ee43000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
  (VTBL_ENTRY)&_ZN7ee430003barEv,
};
extern VTBL_ENTRY _ZTV7ee43000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee43000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee43000[] = {
  {&(_ZTV7ee43000[3]),  3,5},
  {&(_tg__ZTV6dd3000__7ee43000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee43000[];
extern  VTBL_ENTRY _ZTV7ee43000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43000[];
Class_Descriptor cd_ee43000 = {  "ee43000", // class name
  bases_ee43000, 4,
  &(vtc_ee43000[0]), // expected_vtbl_contents
  &(vtt_ee43000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee43000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53000  : virtual dd3000 {
  int e;
  virtual void  bar(); // _ZN7ee530003barEv
  ~ee53000(); // tgen
  ee53000(); // tgen
};
//SIG(1 ee53000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee53000 ::bar(){vfunc_called(this, "_ZN7ee530003barEv");}
ee53000 ::~ee53000(){ note_dtor("ee53000", this);} // tgen
ee53000 ::ee53000(){ note_ctor("ee53000", this);} // tgen

static void Test_ee53000()
{
  extern Class_Descriptor cd_ee53000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee53000, buf);
    ee53000 *dp, &lv = *(dp=new (buf) ee53000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee53000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee53000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee53000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(28,16), "ee53000");
    check_base_class_offset(lv, (dd3000*), ABISELECT(16,8), "ee53000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53000.e");
    test_class_info(&lv, &cd_ee53000);
    dp->~ee53000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53000(Test_ee53000, "ee53000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee53000C1Ev();
extern void _ZN7ee53000D1Ev();
Name_Map name_map_ee53000[] = {
  NSPAIR(_ZN7ee53000C1Ev),
  NSPAIR(_ZN7ee53000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee53000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53000[];
extern void _ZN7ee530003barEv();
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY vtc_ee53000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53000[0]),
  (VTBL_ENTRY)&_ZN7ee530003barEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
extern VTBL_ENTRY _ZTV7ee53000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee53000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee53000[] = {
  {&(_ZTV7ee53000[4]),  4,10},
  {&(_ZTV7ee53000[9]),  9,10},
  {&(_tg__ZTV6dd3000__7ee53000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53000[];
extern  VTBL_ENTRY _ZTV7ee53000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53000[];
Class_Descriptor cd_ee53000 = {  "ee53000", // class name
  bases_ee53000, 4,
  &(vtc_ee53000[0]), // expected_vtbl_contents
  &(vtt_ee53000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee53000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53000),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63000  : dd3000 {
  int e;
  virtual void  foo(); // _ZN7ee630003fooEv
  virtual void  bar(); // _ZN7ee630003barEv
  ~ee63000(); // tgen
  ee63000(); // tgen
};
//SIG(1 ee63000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63000 ::foo(){vfunc_called(this, "_ZN7ee630003fooEv");}
void  ee63000 ::bar(){vfunc_called(this, "_ZN7ee630003barEv");}
ee63000 ::~ee63000(){ note_dtor("ee63000", this);} // tgen
ee63000 ::ee63000(){ note_ctor("ee63000", this);} // tgen

static void Test_ee63000()
{
  extern Class_Descriptor cd_ee63000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee63000, buf);
    ee63000 *dp, &lv = *(dp=new (buf) ee63000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee63000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee63000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee63000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(16,12), "ee63000");
    check_base_class_offset(lv, (dd3000*), 0, "ee63000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63000.e");
    test_class_info(&lv, &cd_ee63000);
    dp->~ee63000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63000(Test_ee63000, "ee63000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee63000C1Ev();
extern void _ZN7ee63000D1Ev();
Name_Map name_map_ee63000[] = {
  NSPAIR(_ZN7ee63000C1Ev),
  NSPAIR(_ZN7ee63000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee63000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63000[];
extern void _ZN7ee630003fooEv();
extern void _ZN7ee630003barEv();
static  VTBL_ENTRY vtc_ee63000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63000[0]),
  (VTBL_ENTRY)&_ZN7ee630003fooEv,
  (VTBL_ENTRY)&_ZN7ee630003barEv,
};
extern VTBL_ENTRY _ZTV7ee63000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee63000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee63000[] = {
  {&(_ZTV7ee63000[3]),  3,5},
  {&(_tg__ZTV6dd3000__7ee63000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee63000[];
extern  VTBL_ENTRY _ZTV7ee63000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63000[];
Class_Descriptor cd_ee63000 = {  "ee63000", // class name
  bases_ee63000, 4,
  &(vtc_ee63000[0]), // expected_vtbl_contents
  &(vtt_ee63000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee63000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73000  : virtual dd3000 {
  int e;
  virtual void  foo(); // _ZN7ee730003fooEv
  virtual void  bar(); // _ZN7ee730003barEv
  ~ee73000(); // tgen
  ee73000(); // tgen
};
//SIG(1 ee73000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73000 ::foo(){vfunc_called(this, "_ZN7ee730003fooEv");}
void  ee73000 ::bar(){vfunc_called(this, "_ZN7ee730003barEv");}
ee73000 ::~ee73000(){ note_dtor("ee73000", this);} // tgen
ee73000 ::ee73000(){ note_ctor("ee73000", this);} // tgen

static void Test_ee73000()
{
  extern Class_Descriptor cd_ee73000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee73000, buf);
    ee73000 *dp, &lv = *(dp=new (buf) ee73000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee73000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee73000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee73000");
    check_base_class_offset(lv, (cc000*)(dd3000*), ABISELECT(28,16), "ee73000");
    check_base_class_offset(lv, (dd3000*), ABISELECT(16,8), "ee73000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73000.e");
    test_class_info(&lv, &cd_ee73000);
    dp->~ee73000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73000(Test_ee73000, "ee73000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee73000C1Ev();
extern void _ZN7ee73000D1Ev();
Name_Map name_map_ee73000[] = {
  NSPAIR(_ZN7ee73000C1Ev),
  NSPAIR(_ZN7ee73000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd3000;
extern VTBL_ENTRY _ZTI6dd3000[];
extern  VTBL_ENTRY _ZTV6dd3000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3000[];
static Base_Class bases_ee73000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3000,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73000[];
extern void _ZN7ee730003fooEv();
extern void _ZN7ee730003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee730003fooEv,_ZTv0_n16_N7ee730003fooEv)();
extern void ABISELECT(_ZThn16_N7ee730003fooEv,_ZThn8_N7ee730003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73000[0]),
  (VTBL_ENTRY)&_ZN7ee730003fooEv,
  (VTBL_ENTRY)&_ZN7ee730003barEv,
  ABISELECT(-16,-8),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee730003fooEv,_ZTv0_n16_N7ee730003fooEv),
};
extern VTBL_ENTRY _ZTV7ee73000[];
extern void _ZN6dd30003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3000__7ee73000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3000[0]),
  (VTBL_ENTRY)&_ZN6dd30003fooEv,
};
static  VTT_ENTRY vtt_ee73000[] = {
  {&(_ZTV7ee73000[4]),  4,11},
  {&(_ZTV7ee73000[10]),  10,11},
  {&(_tg__ZTV6dd3000__7ee73000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73000[];
extern  VTBL_ENTRY _ZTV7ee73000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73000[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee730003fooEv,_ZTv0_n16_N7ee730003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee730003fooEv,_ZThn8_N7ee730003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73000 = {  "ee73000", // class name
  bases_ee73000, 4,
  &(vtc_ee73000[0]), // expected_vtbl_contents
  &(vtt_ee73000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee73000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73000),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4000  : cc000 {
  int d;
  virtual void  bar(); // _ZN6dd40003barEv
  ~dd4000(); // tgen
  dd4000(); // tgen
};
//SIG(-1 dd4000) C1{ BC2{ BC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd4000 ::bar(){vfunc_called(this, "_ZN6dd40003barEv");}
dd4000 ::~dd4000(){ note_dtor("dd4000", this);} // tgen
dd4000 ::dd4000(){ note_ctor("dd4000", this);} // tgen

static void Test_dd4000()
{
  extern Class_Descriptor cd_dd4000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4000, buf);
    dd4000 *dp, &lv = *(dp=new (buf) dd4000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(8,4), "dd4000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(8,4), "dd4000");
    check_base_class_offset(lv, (cc000*), ABISELECT(8,4), "dd4000");
    check_field_offset(lv, d, ABISELECT(20,16), "dd4000.d");
    test_class_info(&lv, &cd_dd4000);
    dp->~dd4000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4000(Test_dd4000, "dd4000", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4000C1Ev();
extern void _ZN6dd4000D1Ev();
Name_Map name_map_dd4000[] = {
  NSPAIR(_ZN6dd4000C1Ev),
  NSPAIR(_ZN6dd4000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd4000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4000[];
extern void _ZN6dd40003barEv();
static  VTBL_ENTRY vtc_dd4000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd4000[0]),
  (VTBL_ENTRY)&_ZN6dd40003barEv,
};
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
Class_Descriptor cd_dd4000 = {  "dd4000", // class name
  bases_dd4000, 3,
  &(vtc_dd4000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd4000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04000  : dd4000 {
  int e;
  ~ee04000(); // tgen
  ee04000(); // tgen
};
//SIG(1 ee04000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee04000 ::~ee04000(){ note_dtor("ee04000", this);} // tgen
ee04000 ::ee04000(){ note_ctor("ee04000", this);} // tgen

static void Test_ee04000()
{
  extern Class_Descriptor cd_ee04000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04000, buf);
    ee04000 *dp, &lv = *(dp=new (buf) ee04000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee04000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee04000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(8,4), "ee04000");
    check_base_class_offset(lv, (dd4000*), 0, "ee04000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee04000.e");
    test_class_info(&lv, &cd_ee04000);
    dp->~ee04000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04000(Test_ee04000, "ee04000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04000C1Ev();
extern void _ZN7ee04000D1Ev();
Name_Map name_map_ee04000[] = {
  NSPAIR(_ZN7ee04000C1Ev),
  NSPAIR(_ZN7ee04000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee04000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04000[];
extern void _ZN6dd40003barEv();
static  VTBL_ENTRY vtc_ee04000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee04000[0]),
  (VTBL_ENTRY)&_ZN6dd40003barEv,
};
extern VTBL_ENTRY _ZTI7ee04000[];
extern  VTBL_ENTRY _ZTV7ee04000[];
Class_Descriptor cd_ee04000 = {  "ee04000", // class name
  bases_ee04000, 4,
  &(vtc_ee04000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14000  : virtual dd4000 {
  int e;
  ~ee14000(); // tgen
  ee14000(); // tgen
};
//SIG(1 ee14000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee14000 ::~ee14000(){ note_dtor("ee14000", this);} // tgen
ee14000 ::ee14000(){ note_ctor("ee14000", this);} // tgen

static void Test_ee14000()
{
  extern Class_Descriptor cd_ee14000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14000, buf);
    ee14000 *dp, &lv = *(dp=new (buf) ee14000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee14000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee14000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(24,12), "ee14000");
    check_base_class_offset(lv, (dd4000*), ABISELECT(16,8), "ee14000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14000.e");
    test_class_info(&lv, &cd_ee14000);
    dp->~ee14000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14000(Test_ee14000, "ee14000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14000C1Ev();
extern void _ZN7ee14000D1Ev();
Name_Map name_map_ee14000[] = {
  NSPAIR(_ZN7ee14000C1Ev),
  NSPAIR(_ZN7ee14000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee14000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14000[];
extern void _ZN6dd40003barEv();
static  VTBL_ENTRY vtc_ee14000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14000[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14000[0]),
  (VTBL_ENTRY)&_ZN6dd40003barEv,
};
extern VTBL_ENTRY _ZTV7ee14000[];
static  VTT_ENTRY vtt_ee14000[] = {
  {&(_ZTV7ee14000[3]),  3,7},
  {&(_ZTV7ee14000[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee14000[];
extern  VTBL_ENTRY _ZTV7ee14000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14000[];
Class_Descriptor cd_ee14000 = {  "ee14000", // class name
  bases_ee14000, 4,
  &(vtc_ee14000[0]), // expected_vtbl_contents
  &(vtt_ee14000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14000),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24000  : dd4000 {
  int e;
  virtual void  foo(); // _ZN7ee240003fooEv
  ~ee24000(); // tgen
  ee24000(); // tgen
};
//SIG(1 ee24000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee24000 ::foo(){vfunc_called(this, "_ZN7ee240003fooEv");}
ee24000 ::~ee24000(){ note_dtor("ee24000", this);} // tgen
ee24000 ::ee24000(){ note_ctor("ee24000", this);} // tgen

static void Test_ee24000()
{
  extern Class_Descriptor cd_ee24000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24000, buf);
    ee24000 *dp, &lv = *(dp=new (buf) ee24000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee24000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee24000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(8,4), "ee24000");
    check_base_class_offset(lv, (dd4000*), 0, "ee24000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee24000.e");
    test_class_info(&lv, &cd_ee24000);
    dp->~ee24000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24000(Test_ee24000, "ee24000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24000C1Ev();
extern void _ZN7ee24000D1Ev();
Name_Map name_map_ee24000[] = {
  NSPAIR(_ZN7ee24000C1Ev),
  NSPAIR(_ZN7ee24000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee24000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24000[];
extern void _ZN6dd40003barEv();
extern void _ZN7ee240003fooEv();
static  VTBL_ENTRY vtc_ee24000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee24000[0]),
  (VTBL_ENTRY)&_ZN6dd40003barEv,
  (VTBL_ENTRY)&_ZN7ee240003fooEv,
};
extern VTBL_ENTRY _ZTI7ee24000[];
extern  VTBL_ENTRY _ZTV7ee24000[];
Class_Descriptor cd_ee24000 = {  "ee24000", // class name
  bases_ee24000, 4,
  &(vtc_ee24000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34000  : virtual dd4000 {
  int e;
  virtual void  foo(); // _ZN7ee340003fooEv
  ~ee34000(); // tgen
  ee34000(); // tgen
};
//SIG(1 ee34000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee34000 ::foo(){vfunc_called(this, "_ZN7ee340003fooEv");}
ee34000 ::~ee34000(){ note_dtor("ee34000", this);} // tgen
ee34000 ::ee34000(){ note_ctor("ee34000", this);} // tgen

static void Test_ee34000()
{
  extern Class_Descriptor cd_ee34000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34000, buf);
    ee34000 *dp, &lv = *(dp=new (buf) ee34000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee34000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee34000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(24,12), "ee34000");
    check_base_class_offset(lv, (dd4000*), ABISELECT(16,8), "ee34000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34000.e");
    test_class_info(&lv, &cd_ee34000);
    dp->~ee34000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34000(Test_ee34000, "ee34000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34000C1Ev();
extern void _ZN7ee34000D1Ev();
Name_Map name_map_ee34000[] = {
  NSPAIR(_ZN7ee34000C1Ev),
  NSPAIR(_ZN7ee34000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee34000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34000[];
extern void _ZN7ee340003fooEv();
extern void _ZN6dd40003barEv();
static  VTBL_ENTRY vtc_ee34000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34000[0]),
  (VTBL_ENTRY)&_ZN7ee340003fooEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34000[0]),
  (VTBL_ENTRY)&_ZN6dd40003barEv,
};
extern VTBL_ENTRY _ZTV7ee34000[];
static  VTT_ENTRY vtt_ee34000[] = {
  {&(_ZTV7ee34000[3]),  3,8},
  {&(_ZTV7ee34000[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee34000[];
extern  VTBL_ENTRY _ZTV7ee34000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34000[];
Class_Descriptor cd_ee34000 = {  "ee34000", // class name
  bases_ee34000, 4,
  &(vtc_ee34000[0]), // expected_vtbl_contents
  &(vtt_ee34000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34000),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44000  : dd4000 {
  int e;
  virtual void  bar(); // _ZN7ee440003barEv
  ~ee44000(); // tgen
  ee44000(); // tgen
};
//SIG(1 ee44000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee44000 ::bar(){vfunc_called(this, "_ZN7ee440003barEv");}
ee44000 ::~ee44000(){ note_dtor("ee44000", this);} // tgen
ee44000 ::ee44000(){ note_ctor("ee44000", this);} // tgen

static void Test_ee44000()
{
  extern Class_Descriptor cd_ee44000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44000, buf);
    ee44000 *dp, &lv = *(dp=new (buf) ee44000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee44000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee44000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(8,4), "ee44000");
    check_base_class_offset(lv, (dd4000*), 0, "ee44000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee44000.e");
    test_class_info(&lv, &cd_ee44000);
    dp->~ee44000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44000(Test_ee44000, "ee44000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44000C1Ev();
extern void _ZN7ee44000D1Ev();
Name_Map name_map_ee44000[] = {
  NSPAIR(_ZN7ee44000C1Ev),
  NSPAIR(_ZN7ee44000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee44000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44000[];
extern void _ZN7ee440003barEv();
static  VTBL_ENTRY vtc_ee44000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee44000[0]),
  (VTBL_ENTRY)&_ZN7ee440003barEv,
};
extern VTBL_ENTRY _ZTI7ee44000[];
extern  VTBL_ENTRY _ZTV7ee44000[];
Class_Descriptor cd_ee44000 = {  "ee44000", // class name
  bases_ee44000, 4,
  &(vtc_ee44000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44000),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54000  : virtual dd4000 {
  int e;
  virtual void  bar(); // _ZN7ee540003barEv
  ~ee54000(); // tgen
  ee54000(); // tgen
};
//SIG(1 ee54000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee54000 ::bar(){vfunc_called(this, "_ZN7ee540003barEv");}
ee54000 ::~ee54000(){ note_dtor("ee54000", this);} // tgen
ee54000 ::ee54000(){ note_ctor("ee54000", this);} // tgen

static void Test_ee54000()
{
  extern Class_Descriptor cd_ee54000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54000, buf);
    ee54000 *dp, &lv = *(dp=new (buf) ee54000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee54000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee54000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(24,12), "ee54000");
    check_base_class_offset(lv, (dd4000*), ABISELECT(16,8), "ee54000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54000.e");
    test_class_info(&lv, &cd_ee54000);
    dp->~ee54000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54000(Test_ee54000, "ee54000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54000C1Ev();
extern void _ZN7ee54000D1Ev();
Name_Map name_map_ee54000[] = {
  NSPAIR(_ZN7ee54000C1Ev),
  NSPAIR(_ZN7ee54000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee54000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54000[];
extern void _ZN7ee540003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee540003barEv,_ZTv0_n12_N7ee540003barEv)();
extern void ABISELECT(_ZThn16_N7ee540003barEv,_ZThn8_N7ee540003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54000[0]),
  (VTBL_ENTRY)&_ZN7ee540003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee540003barEv,_ZTv0_n12_N7ee540003barEv),
};
extern VTBL_ENTRY _ZTV7ee54000[];
static  VTT_ENTRY vtt_ee54000[] = {
  {&(_ZTV7ee54000[3]),  3,8},
  {&(_ZTV7ee54000[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee54000[];
extern  VTBL_ENTRY _ZTV7ee54000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54000[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee540003barEv,_ZTv0_n12_N7ee540003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee540003barEv,_ZThn8_N7ee540003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54000 = {  "ee54000", // class name
  bases_ee54000, 4,
  &(vtc_ee54000[0]), // expected_vtbl_contents
  &(vtt_ee54000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54000),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64000  : dd4000 {
  int e;
  virtual void  foo(); // _ZN7ee640003fooEv
  virtual void  bar(); // _ZN7ee640003barEv
  ~ee64000(); // tgen
  ee64000(); // tgen
};
//SIG(1 ee64000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64000 ::foo(){vfunc_called(this, "_ZN7ee640003fooEv");}
void  ee64000 ::bar(){vfunc_called(this, "_ZN7ee640003barEv");}
ee64000 ::~ee64000(){ note_dtor("ee64000", this);} // tgen
ee64000 ::ee64000(){ note_ctor("ee64000", this);} // tgen

static void Test_ee64000()
{
  extern Class_Descriptor cd_ee64000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64000, buf);
    ee64000 *dp, &lv = *(dp=new (buf) ee64000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee64000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(8,4), "ee64000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(8,4), "ee64000");
    check_base_class_offset(lv, (dd4000*), 0, "ee64000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee64000.e");
    test_class_info(&lv, &cd_ee64000);
    dp->~ee64000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64000(Test_ee64000, "ee64000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64000C1Ev();
extern void _ZN7ee64000D1Ev();
Name_Map name_map_ee64000[] = {
  NSPAIR(_ZN7ee64000C1Ev),
  NSPAIR(_ZN7ee64000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee64000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64000[];
extern void _ZN7ee640003barEv();
extern void _ZN7ee640003fooEv();
static  VTBL_ENTRY vtc_ee64000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee64000[0]),
  (VTBL_ENTRY)&_ZN7ee640003barEv,
  (VTBL_ENTRY)&_ZN7ee640003fooEv,
};
extern VTBL_ENTRY _ZTI7ee64000[];
extern  VTBL_ENTRY _ZTV7ee64000[];
Class_Descriptor cd_ee64000 = {  "ee64000", // class name
  bases_ee64000, 4,
  &(vtc_ee64000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74000  : virtual dd4000 {
  int e;
  virtual void  foo(); // _ZN7ee740003fooEv
  virtual void  bar(); // _ZN7ee740003barEv
  ~ee74000(); // tgen
  ee74000(); // tgen
};
//SIG(1 ee74000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74000 ::foo(){vfunc_called(this, "_ZN7ee740003fooEv");}
void  ee74000 ::bar(){vfunc_called(this, "_ZN7ee740003barEv");}
ee74000 ::~ee74000(){ note_dtor("ee74000", this);} // tgen
ee74000 ::ee74000(){ note_ctor("ee74000", this);} // tgen

static void Test_ee74000()
{
  extern Class_Descriptor cd_ee74000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74000, buf);
    ee74000 *dp, &lv = *(dp=new (buf) ee74000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee74000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd4000*), ABISELECT(24,12), "ee74000");
    check_base_class_offset(lv, (cc000*)(dd4000*), ABISELECT(24,12), "ee74000");
    check_base_class_offset(lv, (dd4000*), ABISELECT(16,8), "ee74000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74000.e");
    test_class_info(&lv, &cd_ee74000);
    dp->~ee74000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74000(Test_ee74000, "ee74000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74000C1Ev();
extern void _ZN7ee74000D1Ev();
Name_Map name_map_ee74000[] = {
  NSPAIR(_ZN7ee74000C1Ev),
  NSPAIR(_ZN7ee74000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd4000;
extern VTBL_ENTRY _ZTI6dd4000[];
extern  VTBL_ENTRY _ZTV6dd4000[];
static Base_Class bases_ee74000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74000[];
extern void _ZN7ee740003fooEv();
extern void _ZN7ee740003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee740003barEv,_ZTv0_n12_N7ee740003barEv)();
extern void ABISELECT(_ZThn16_N7ee740003barEv,_ZThn8_N7ee740003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74000[0]),
  (VTBL_ENTRY)&_ZN7ee740003fooEv,
  (VTBL_ENTRY)&_ZN7ee740003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee740003barEv,_ZTv0_n12_N7ee740003barEv),
};
extern VTBL_ENTRY _ZTV7ee74000[];
static  VTT_ENTRY vtt_ee74000[] = {
  {&(_ZTV7ee74000[3]),  3,9},
  {&(_ZTV7ee74000[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee74000[];
extern  VTBL_ENTRY _ZTV7ee74000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74000[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee740003barEv,_ZTv0_n12_N7ee740003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee740003barEv,_ZThn8_N7ee740003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74000 = {  "ee74000", // class name
  bases_ee74000, 4,
  &(vtc_ee74000[0]), // expected_vtbl_contents
  &(vtt_ee74000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74000),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5000  : virtual cc000 {
  int d;
  virtual void  bar(); // _ZN6dd50003barEv
  ~dd5000(); // tgen
  dd5000(); // tgen
};
//SIG(-1 dd5000) C1{ VBC2{ BC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd5000 ::bar(){vfunc_called(this, "_ZN6dd50003barEv");}
dd5000 ::~dd5000(){ note_dtor("dd5000", this);} // tgen
dd5000 ::dd5000(){ note_ctor("dd5000", this);} // tgen

static void Test_dd5000()
{
  extern Class_Descriptor cd_dd5000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd5000, buf);
    dd5000 *dp, &lv = *(dp=new (buf) dd5000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd5000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(12,8), "dd5000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(12,8), "dd5000");
    check_base_class_offset(lv, (cc000*), ABISELECT(12,8), "dd5000");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5000.d");
    test_class_info(&lv, &cd_dd5000);
    dp->~dd5000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5000(Test_dd5000, "dd5000", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd5000C1Ev();
extern void _ZN6dd5000D1Ev();
Name_Map name_map_dd5000[] = {
  NSPAIR(_ZN6dd5000C1Ev),
  NSPAIR(_ZN6dd5000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd5000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY vtc_dd5000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
extern VTBL_ENTRY _ZTV6dd5000[];
static  VTT_ENTRY vtt_dd5000[] = {
  {&(_ZTV6dd5000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
Class_Descriptor cd_dd5000 = {  "dd5000", // class name
  bases_dd5000, 3,
  &(vtc_dd5000[0]), // expected_vtbl_contents
  &(vtt_dd5000[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd5000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05000  : dd5000 {
  int e;
  ~ee05000(); // tgen
  ee05000(); // tgen
};
//SIG(1 ee05000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee05000 ::~ee05000(){ note_dtor("ee05000", this);} // tgen
ee05000 ::ee05000(){ note_ctor("ee05000", this);} // tgen

static void Test_ee05000()
{
  extern Class_Descriptor cd_ee05000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee05000, buf);
    ee05000 *dp, &lv = *(dp=new (buf) ee05000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee05000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee05000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee05000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(16,12), "ee05000");
    check_base_class_offset(lv, (dd5000*), 0, "ee05000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05000.e");
    test_class_info(&lv, &cd_ee05000);
    dp->~ee05000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05000(Test_ee05000, "ee05000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee05000C1Ev();
extern void _ZN7ee05000D1Ev();
Name_Map name_map_ee05000[] = {
  NSPAIR(_ZN7ee05000C1Ev),
  NSPAIR(_ZN7ee05000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee05000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY vtc_ee05000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
extern VTBL_ENTRY _ZTV7ee05000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee05000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee05000[] = {
  {&(_ZTV7ee05000[3]),  3,4},
  {&(_tg__ZTV6dd5000__7ee05000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee05000[];
extern  VTBL_ENTRY _ZTV7ee05000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05000[];
Class_Descriptor cd_ee05000 = {  "ee05000", // class name
  bases_ee05000, 4,
  &(vtc_ee05000[0]), // expected_vtbl_contents
  &(vtt_ee05000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee05000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15000  : virtual dd5000 {
  int e;
  ~ee15000(); // tgen
  ee15000(); // tgen
};
//SIG(1 ee15000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee15000 ::~ee15000(){ note_dtor("ee15000", this);} // tgen
ee15000 ::ee15000(){ note_ctor("ee15000", this);} // tgen

static void Test_ee15000()
{
  extern Class_Descriptor cd_ee15000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee15000, buf);
    ee15000 *dp, &lv = *(dp=new (buf) ee15000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee15000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee15000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee15000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(28,16), "ee15000");
    check_base_class_offset(lv, (dd5000*), ABISELECT(16,8), "ee15000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15000.e");
    test_class_info(&lv, &cd_ee15000);
    dp->~ee15000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15000(Test_ee15000, "ee15000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee15000C1Ev();
extern void _ZN7ee15000D1Ev();
Name_Map name_map_ee15000[] = {
  NSPAIR(_ZN7ee15000C1Ev),
  NSPAIR(_ZN7ee15000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee15000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY vtc_ee15000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15000[0]),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
extern VTBL_ENTRY _ZTV7ee15000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee15000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee15000[] = {
  {&(_ZTV7ee15000[4]),  4,9},
  {&(_ZTV7ee15000[8]),  8,9},
  {&(_tg__ZTV6dd5000__7ee15000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15000[];
extern  VTBL_ENTRY _ZTV7ee15000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15000[];
Class_Descriptor cd_ee15000 = {  "ee15000", // class name
  bases_ee15000, 4,
  &(vtc_ee15000[0]), // expected_vtbl_contents
  &(vtt_ee15000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee15000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15000),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25000  : dd5000 {
  int e;
  virtual void  foo(); // _ZN7ee250003fooEv
  ~ee25000(); // tgen
  ee25000(); // tgen
};
//SIG(1 ee25000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee25000 ::foo(){vfunc_called(this, "_ZN7ee250003fooEv");}
ee25000 ::~ee25000(){ note_dtor("ee25000", this);} // tgen
ee25000 ::ee25000(){ note_ctor("ee25000", this);} // tgen

static void Test_ee25000()
{
  extern Class_Descriptor cd_ee25000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee25000, buf);
    ee25000 *dp, &lv = *(dp=new (buf) ee25000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee25000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee25000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee25000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(16,12), "ee25000");
    check_base_class_offset(lv, (dd5000*), 0, "ee25000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25000.e");
    test_class_info(&lv, &cd_ee25000);
    dp->~ee25000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25000(Test_ee25000, "ee25000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee25000C1Ev();
extern void _ZN7ee25000D1Ev();
Name_Map name_map_ee25000[] = {
  NSPAIR(_ZN7ee25000C1Ev),
  NSPAIR(_ZN7ee25000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee25000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25000[];
extern void _ZN6dd50003barEv();
extern void _ZN7ee250003fooEv();
static  VTBL_ENTRY vtc_ee25000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
  (VTBL_ENTRY)&_ZN7ee250003fooEv,
};
extern VTBL_ENTRY _ZTV7ee25000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee25000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee25000[] = {
  {&(_ZTV7ee25000[3]),  3,5},
  {&(_tg__ZTV6dd5000__7ee25000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee25000[];
extern  VTBL_ENTRY _ZTV7ee25000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25000[];
Class_Descriptor cd_ee25000 = {  "ee25000", // class name
  bases_ee25000, 4,
  &(vtc_ee25000[0]), // expected_vtbl_contents
  &(vtt_ee25000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee25000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35000  : virtual dd5000 {
  int e;
  virtual void  foo(); // _ZN7ee350003fooEv
  ~ee35000(); // tgen
  ee35000(); // tgen
};
//SIG(1 ee35000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee35000 ::foo(){vfunc_called(this, "_ZN7ee350003fooEv");}
ee35000 ::~ee35000(){ note_dtor("ee35000", this);} // tgen
ee35000 ::ee35000(){ note_ctor("ee35000", this);} // tgen

static void Test_ee35000()
{
  extern Class_Descriptor cd_ee35000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee35000, buf);
    ee35000 *dp, &lv = *(dp=new (buf) ee35000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee35000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee35000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee35000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(28,16), "ee35000");
    check_base_class_offset(lv, (dd5000*), ABISELECT(16,8), "ee35000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35000.e");
    test_class_info(&lv, &cd_ee35000);
    dp->~ee35000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35000(Test_ee35000, "ee35000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee35000C1Ev();
extern void _ZN7ee35000D1Ev();
Name_Map name_map_ee35000[] = {
  NSPAIR(_ZN7ee35000C1Ev),
  NSPAIR(_ZN7ee35000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee35000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35000[];
extern void _ZN7ee350003fooEv();
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY vtc_ee35000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35000[0]),
  (VTBL_ENTRY)&_ZN7ee350003fooEv,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
extern VTBL_ENTRY _ZTV7ee35000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee35000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee35000[] = {
  {&(_ZTV7ee35000[4]),  4,10},
  {&(_ZTV7ee35000[9]),  9,10},
  {&(_tg__ZTV6dd5000__7ee35000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35000[];
extern  VTBL_ENTRY _ZTV7ee35000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35000[];
Class_Descriptor cd_ee35000 = {  "ee35000", // class name
  bases_ee35000, 4,
  &(vtc_ee35000[0]), // expected_vtbl_contents
  &(vtt_ee35000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee35000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35000),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45000  : dd5000 {
  int e;
  virtual void  bar(); // _ZN7ee450003barEv
  ~ee45000(); // tgen
  ee45000(); // tgen
};
//SIG(1 ee45000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee45000 ::bar(){vfunc_called(this, "_ZN7ee450003barEv");}
ee45000 ::~ee45000(){ note_dtor("ee45000", this);} // tgen
ee45000 ::ee45000(){ note_ctor("ee45000", this);} // tgen

static void Test_ee45000()
{
  extern Class_Descriptor cd_ee45000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee45000, buf);
    ee45000 *dp, &lv = *(dp=new (buf) ee45000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee45000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee45000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee45000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(16,12), "ee45000");
    check_base_class_offset(lv, (dd5000*), 0, "ee45000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45000.e");
    test_class_info(&lv, &cd_ee45000);
    dp->~ee45000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45000(Test_ee45000, "ee45000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee45000C1Ev();
extern void _ZN7ee45000D1Ev();
Name_Map name_map_ee45000[] = {
  NSPAIR(_ZN7ee45000C1Ev),
  NSPAIR(_ZN7ee45000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee45000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45000[];
extern void _ZN7ee450003barEv();
static  VTBL_ENTRY vtc_ee45000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45000[0]),
  (VTBL_ENTRY)&_ZN7ee450003barEv,
};
extern VTBL_ENTRY _ZTV7ee45000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee45000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee45000[] = {
  {&(_ZTV7ee45000[3]),  3,4},
  {&(_tg__ZTV6dd5000__7ee45000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee45000[];
extern  VTBL_ENTRY _ZTV7ee45000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45000[];
Class_Descriptor cd_ee45000 = {  "ee45000", // class name
  bases_ee45000, 4,
  &(vtc_ee45000[0]), // expected_vtbl_contents
  &(vtt_ee45000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee45000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45000),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55000  : virtual dd5000 {
  int e;
  virtual void  bar(); // _ZN7ee550003barEv
  ~ee55000(); // tgen
  ee55000(); // tgen
};
//SIG(1 ee55000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee55000 ::bar(){vfunc_called(this, "_ZN7ee550003barEv");}
ee55000 ::~ee55000(){ note_dtor("ee55000", this);} // tgen
ee55000 ::ee55000(){ note_ctor("ee55000", this);} // tgen

static void Test_ee55000()
{
  extern Class_Descriptor cd_ee55000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee55000, buf);
    ee55000 *dp, &lv = *(dp=new (buf) ee55000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee55000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee55000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee55000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(28,16), "ee55000");
    check_base_class_offset(lv, (dd5000*), ABISELECT(16,8), "ee55000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55000.e");
    test_class_info(&lv, &cd_ee55000);
    dp->~ee55000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55000(Test_ee55000, "ee55000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee55000C1Ev();
extern void _ZN7ee55000D1Ev();
Name_Map name_map_ee55000[] = {
  NSPAIR(_ZN7ee55000C1Ev),
  NSPAIR(_ZN7ee55000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee55000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55000[];
extern void _ZN7ee550003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee550003barEv,_ZTv0_n16_N7ee550003barEv)();
extern void ABISELECT(_ZThn16_N7ee550003barEv,_ZThn8_N7ee550003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55000[0]),
  (VTBL_ENTRY)&_ZN7ee550003barEv,
  ABISELECT(-16,-8),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee550003barEv,_ZTv0_n16_N7ee550003barEv),
};
extern VTBL_ENTRY _ZTV7ee55000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee55000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee55000[] = {
  {&(_ZTV7ee55000[4]),  4,10},
  {&(_ZTV7ee55000[9]),  9,10},
  {&(_tg__ZTV6dd5000__7ee55000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55000[];
extern  VTBL_ENTRY _ZTV7ee55000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55000[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee550003barEv,_ZTv0_n16_N7ee550003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee550003barEv,_ZThn8_N7ee550003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55000 = {  "ee55000", // class name
  bases_ee55000, 4,
  &(vtc_ee55000[0]), // expected_vtbl_contents
  &(vtt_ee55000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee55000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55000),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65000  : dd5000 {
  int e;
  virtual void  foo(); // _ZN7ee650003fooEv
  virtual void  bar(); // _ZN7ee650003barEv
  ~ee65000(); // tgen
  ee65000(); // tgen
};
//SIG(1 ee65000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65000 ::foo(){vfunc_called(this, "_ZN7ee650003fooEv");}
void  ee65000 ::bar(){vfunc_called(this, "_ZN7ee650003barEv");}
ee65000 ::~ee65000(){ note_dtor("ee65000", this);} // tgen
ee65000 ::ee65000(){ note_ctor("ee65000", this);} // tgen

static void Test_ee65000()
{
  extern Class_Descriptor cd_ee65000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee65000, buf);
    ee65000 *dp, &lv = *(dp=new (buf) ee65000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee65000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee65000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee65000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(16,12), "ee65000");
    check_base_class_offset(lv, (dd5000*), 0, "ee65000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65000.e");
    test_class_info(&lv, &cd_ee65000);
    dp->~ee65000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65000(Test_ee65000, "ee65000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee65000C1Ev();
extern void _ZN7ee65000D1Ev();
Name_Map name_map_ee65000[] = {
  NSPAIR(_ZN7ee65000C1Ev),
  NSPAIR(_ZN7ee65000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee65000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65000[];
extern void _ZN7ee650003barEv();
extern void _ZN7ee650003fooEv();
static  VTBL_ENTRY vtc_ee65000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65000[0]),
  (VTBL_ENTRY)&_ZN7ee650003barEv,
  (VTBL_ENTRY)&_ZN7ee650003fooEv,
};
extern VTBL_ENTRY _ZTV7ee65000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee65000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee65000[] = {
  {&(_ZTV7ee65000[3]),  3,5},
  {&(_tg__ZTV6dd5000__7ee65000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee65000[];
extern  VTBL_ENTRY _ZTV7ee65000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65000[];
Class_Descriptor cd_ee65000 = {  "ee65000", // class name
  bases_ee65000, 4,
  &(vtc_ee65000[0]), // expected_vtbl_contents
  &(vtt_ee65000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee65000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75000  : virtual dd5000 {
  int e;
  virtual void  foo(); // _ZN7ee750003fooEv
  virtual void  bar(); // _ZN7ee750003barEv
  ~ee75000(); // tgen
  ee75000(); // tgen
};
//SIG(1 ee75000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75000 ::foo(){vfunc_called(this, "_ZN7ee750003fooEv");}
void  ee75000 ::bar(){vfunc_called(this, "_ZN7ee750003barEv");}
ee75000 ::~ee75000(){ note_dtor("ee75000", this);} // tgen
ee75000 ::ee75000(){ note_ctor("ee75000", this);} // tgen

static void Test_ee75000()
{
  extern Class_Descriptor cd_ee75000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee75000, buf);
    ee75000 *dp, &lv = *(dp=new (buf) ee75000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee75000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee75000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee75000");
    check_base_class_offset(lv, (cc000*)(dd5000*), ABISELECT(28,16), "ee75000");
    check_base_class_offset(lv, (dd5000*), ABISELECT(16,8), "ee75000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75000.e");
    test_class_info(&lv, &cd_ee75000);
    dp->~ee75000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75000(Test_ee75000, "ee75000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee75000C1Ev();
extern void _ZN7ee75000D1Ev();
Name_Map name_map_ee75000[] = {
  NSPAIR(_ZN7ee75000C1Ev),
  NSPAIR(_ZN7ee75000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd5000;
extern VTBL_ENTRY _ZTI6dd5000[];
extern  VTBL_ENTRY _ZTV6dd5000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5000[];
static Base_Class bases_ee75000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5000,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75000[];
extern void _ZN7ee750003fooEv();
extern void _ZN7ee750003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee750003barEv,_ZTv0_n16_N7ee750003barEv)();
extern void ABISELECT(_ZThn16_N7ee750003barEv,_ZThn8_N7ee750003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75000[0]),
  (VTBL_ENTRY)&_ZN7ee750003fooEv,
  (VTBL_ENTRY)&_ZN7ee750003barEv,
  ABISELECT(-16,-8),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee750003barEv,_ZTv0_n16_N7ee750003barEv),
};
extern VTBL_ENTRY _ZTV7ee75000[];
extern void _ZN6dd50003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5000__7ee75000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5000[0]),
  (VTBL_ENTRY)&_ZN6dd50003barEv,
};
static  VTT_ENTRY vtt_ee75000[] = {
  {&(_ZTV7ee75000[4]),  4,11},
  {&(_ZTV7ee75000[10]),  10,11},
  {&(_tg__ZTV6dd5000__7ee75000[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75000[];
extern  VTBL_ENTRY _ZTV7ee75000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75000[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee750003barEv,_ZTv0_n16_N7ee750003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee750003barEv,_ZThn8_N7ee750003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75000 = {  "ee75000", // class name
  bases_ee75000, 4,
  &(vtc_ee75000[0]), // expected_vtbl_contents
  &(vtt_ee75000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee75000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75000),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6000  : cc000 {
  int d;
  virtual void  bar(); // _ZN6dd60003barEv
  virtual void  foo(); // _ZN6dd60003fooEv
  ~dd6000(); // tgen
  dd6000(); // tgen
};
//SIG(-1 dd6000) C1{ BC2{ BC3{ BC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd6000 ::bar(){vfunc_called(this, "_ZN6dd60003barEv");}
void  dd6000 ::foo(){vfunc_called(this, "_ZN6dd60003fooEv");}
dd6000 ::~dd6000(){ note_dtor("dd6000", this);} // tgen
dd6000 ::dd6000(){ note_ctor("dd6000", this);} // tgen

static void Test_dd6000()
{
  extern Class_Descriptor cd_dd6000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6000, buf);
    dd6000 *dp, &lv = *(dp=new (buf) dd6000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(8,4), "dd6000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(8,4), "dd6000");
    check_base_class_offset(lv, (cc000*), ABISELECT(8,4), "dd6000");
    check_field_offset(lv, d, ABISELECT(20,16), "dd6000.d");
    test_class_info(&lv, &cd_dd6000);
    dp->~dd6000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6000(Test_dd6000, "dd6000", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6000C1Ev();
extern void _ZN6dd6000D1Ev();
Name_Map name_map_dd6000[] = {
  NSPAIR(_ZN6dd6000C1Ev),
  NSPAIR(_ZN6dd6000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd6000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6000[];
extern void _ZN6dd60003barEv();
extern void _ZN6dd60003fooEv();
static  VTBL_ENTRY vtc_dd6000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd6000[0]),
  (VTBL_ENTRY)&_ZN6dd60003barEv,
  (VTBL_ENTRY)&_ZN6dd60003fooEv,
};
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
Class_Descriptor cd_dd6000 = {  "dd6000", // class name
  bases_dd6000, 3,
  &(vtc_dd6000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd6000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06000  : dd6000 {
  int e;
  ~ee06000(); // tgen
  ee06000(); // tgen
};
//SIG(1 ee06000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee06000 ::~ee06000(){ note_dtor("ee06000", this);} // tgen
ee06000 ::ee06000(){ note_ctor("ee06000", this);} // tgen

static void Test_ee06000()
{
  extern Class_Descriptor cd_ee06000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06000, buf);
    ee06000 *dp, &lv = *(dp=new (buf) ee06000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee06000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee06000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(8,4), "ee06000");
    check_base_class_offset(lv, (dd6000*), 0, "ee06000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee06000.e");
    test_class_info(&lv, &cd_ee06000);
    dp->~ee06000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06000(Test_ee06000, "ee06000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06000C1Ev();
extern void _ZN7ee06000D1Ev();
Name_Map name_map_ee06000[] = {
  NSPAIR(_ZN7ee06000C1Ev),
  NSPAIR(_ZN7ee06000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee06000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06000[];
extern void _ZN6dd60003barEv();
extern void _ZN6dd60003fooEv();
static  VTBL_ENTRY vtc_ee06000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee06000[0]),
  (VTBL_ENTRY)&_ZN6dd60003barEv,
  (VTBL_ENTRY)&_ZN6dd60003fooEv,
};
extern VTBL_ENTRY _ZTI7ee06000[];
extern  VTBL_ENTRY _ZTV7ee06000[];
Class_Descriptor cd_ee06000 = {  "ee06000", // class name
  bases_ee06000, 4,
  &(vtc_ee06000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16000  : virtual dd6000 {
  int e;
  ~ee16000(); // tgen
  ee16000(); // tgen
};
//SIG(1 ee16000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee16000 ::~ee16000(){ note_dtor("ee16000", this);} // tgen
ee16000 ::ee16000(){ note_ctor("ee16000", this);} // tgen

static void Test_ee16000()
{
  extern Class_Descriptor cd_ee16000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16000, buf);
    ee16000 *dp, &lv = *(dp=new (buf) ee16000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee16000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee16000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(24,12), "ee16000");
    check_base_class_offset(lv, (dd6000*), ABISELECT(16,8), "ee16000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16000.e");
    test_class_info(&lv, &cd_ee16000);
    dp->~ee16000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16000(Test_ee16000, "ee16000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16000C1Ev();
extern void _ZN7ee16000D1Ev();
Name_Map name_map_ee16000[] = {
  NSPAIR(_ZN7ee16000C1Ev),
  NSPAIR(_ZN7ee16000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee16000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16000[];
extern void _ZN6dd60003barEv();
extern void _ZN6dd60003fooEv();
static  VTBL_ENTRY vtc_ee16000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16000[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16000[0]),
  (VTBL_ENTRY)&_ZN6dd60003barEv,
  (VTBL_ENTRY)&_ZN6dd60003fooEv,
};
extern VTBL_ENTRY _ZTV7ee16000[];
static  VTT_ENTRY vtt_ee16000[] = {
  {&(_ZTV7ee16000[3]),  3,9},
  {&(_ZTV7ee16000[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee16000[];
extern  VTBL_ENTRY _ZTV7ee16000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16000[];
Class_Descriptor cd_ee16000 = {  "ee16000", // class name
  bases_ee16000, 4,
  &(vtc_ee16000[0]), // expected_vtbl_contents
  &(vtt_ee16000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16000),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26000  : dd6000 {
  int e;
  virtual void  foo(); // _ZN7ee260003fooEv
  ~ee26000(); // tgen
  ee26000(); // tgen
};
//SIG(1 ee26000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26000 ::foo(){vfunc_called(this, "_ZN7ee260003fooEv");}
ee26000 ::~ee26000(){ note_dtor("ee26000", this);} // tgen
ee26000 ::ee26000(){ note_ctor("ee26000", this);} // tgen

static void Test_ee26000()
{
  extern Class_Descriptor cd_ee26000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26000, buf);
    ee26000 *dp, &lv = *(dp=new (buf) ee26000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee26000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee26000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(8,4), "ee26000");
    check_base_class_offset(lv, (dd6000*), 0, "ee26000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee26000.e");
    test_class_info(&lv, &cd_ee26000);
    dp->~ee26000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26000(Test_ee26000, "ee26000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26000C1Ev();
extern void _ZN7ee26000D1Ev();
Name_Map name_map_ee26000[] = {
  NSPAIR(_ZN7ee26000C1Ev),
  NSPAIR(_ZN7ee26000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee26000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26000[];
extern void _ZN6dd60003barEv();
extern void _ZN7ee260003fooEv();
static  VTBL_ENTRY vtc_ee26000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee26000[0]),
  (VTBL_ENTRY)&_ZN6dd60003barEv,
  (VTBL_ENTRY)&_ZN7ee260003fooEv,
};
extern VTBL_ENTRY _ZTI7ee26000[];
extern  VTBL_ENTRY _ZTV7ee26000[];
Class_Descriptor cd_ee26000 = {  "ee26000", // class name
  bases_ee26000, 4,
  &(vtc_ee26000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36000  : virtual dd6000 {
  int e;
  virtual void  foo(); // _ZN7ee360003fooEv
  ~ee36000(); // tgen
  ee36000(); // tgen
};
//SIG(1 ee36000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36000 ::foo(){vfunc_called(this, "_ZN7ee360003fooEv");}
ee36000 ::~ee36000(){ note_dtor("ee36000", this);} // tgen
ee36000 ::ee36000(){ note_ctor("ee36000", this);} // tgen

static void Test_ee36000()
{
  extern Class_Descriptor cd_ee36000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36000, buf);
    ee36000 *dp, &lv = *(dp=new (buf) ee36000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee36000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee36000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(24,12), "ee36000");
    check_base_class_offset(lv, (dd6000*), ABISELECT(16,8), "ee36000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36000.e");
    test_class_info(&lv, &cd_ee36000);
    dp->~ee36000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36000(Test_ee36000, "ee36000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36000C1Ev();
extern void _ZN7ee36000D1Ev();
Name_Map name_map_ee36000[] = {
  NSPAIR(_ZN7ee36000C1Ev),
  NSPAIR(_ZN7ee36000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee36000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36000[];
extern void _ZN7ee360003fooEv();
extern void _ZN6dd60003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee360003fooEv,_ZTv0_n16_N7ee360003fooEv)();
extern void ABISELECT(_ZThn16_N7ee360003fooEv,_ZThn8_N7ee360003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36000[0]),
  (VTBL_ENTRY)&_ZN7ee360003fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36000[0]),
  (VTBL_ENTRY)&_ZN6dd60003barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee360003fooEv,_ZTv0_n16_N7ee360003fooEv),
};
extern VTBL_ENTRY _ZTV7ee36000[];
static  VTT_ENTRY vtt_ee36000[] = {
  {&(_ZTV7ee36000[3]),  3,10},
  {&(_ZTV7ee36000[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee36000[];
extern  VTBL_ENTRY _ZTV7ee36000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36000[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee360003fooEv,_ZTv0_n16_N7ee360003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee360003fooEv,_ZThn8_N7ee360003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36000 = {  "ee36000", // class name
  bases_ee36000, 4,
  &(vtc_ee36000[0]), // expected_vtbl_contents
  &(vtt_ee36000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36000),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46000  : dd6000 {
  int e;
  virtual void  bar(); // _ZN7ee460003barEv
  ~ee46000(); // tgen
  ee46000(); // tgen
};
//SIG(1 ee46000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46000 ::bar(){vfunc_called(this, "_ZN7ee460003barEv");}
ee46000 ::~ee46000(){ note_dtor("ee46000", this);} // tgen
ee46000 ::ee46000(){ note_ctor("ee46000", this);} // tgen

static void Test_ee46000()
{
  extern Class_Descriptor cd_ee46000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46000, buf);
    ee46000 *dp, &lv = *(dp=new (buf) ee46000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee46000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee46000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(8,4), "ee46000");
    check_base_class_offset(lv, (dd6000*), 0, "ee46000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee46000.e");
    test_class_info(&lv, &cd_ee46000);
    dp->~ee46000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46000(Test_ee46000, "ee46000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46000C1Ev();
extern void _ZN7ee46000D1Ev();
Name_Map name_map_ee46000[] = {
  NSPAIR(_ZN7ee46000C1Ev),
  NSPAIR(_ZN7ee46000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee46000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46000[];
extern void _ZN7ee460003barEv();
extern void _ZN6dd60003fooEv();
static  VTBL_ENTRY vtc_ee46000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee46000[0]),
  (VTBL_ENTRY)&_ZN7ee460003barEv,
  (VTBL_ENTRY)&_ZN6dd60003fooEv,
};
extern VTBL_ENTRY _ZTI7ee46000[];
extern  VTBL_ENTRY _ZTV7ee46000[];
Class_Descriptor cd_ee46000 = {  "ee46000", // class name
  bases_ee46000, 4,
  &(vtc_ee46000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56000  : virtual dd6000 {
  int e;
  virtual void  bar(); // _ZN7ee560003barEv
  ~ee56000(); // tgen
  ee56000(); // tgen
};
//SIG(1 ee56000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56000 ::bar(){vfunc_called(this, "_ZN7ee560003barEv");}
ee56000 ::~ee56000(){ note_dtor("ee56000", this);} // tgen
ee56000 ::ee56000(){ note_ctor("ee56000", this);} // tgen

static void Test_ee56000()
{
  extern Class_Descriptor cd_ee56000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56000, buf);
    ee56000 *dp, &lv = *(dp=new (buf) ee56000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee56000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee56000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(24,12), "ee56000");
    check_base_class_offset(lv, (dd6000*), ABISELECT(16,8), "ee56000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56000.e");
    test_class_info(&lv, &cd_ee56000);
    dp->~ee56000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56000(Test_ee56000, "ee56000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56000C1Ev();
extern void _ZN7ee56000D1Ev();
Name_Map name_map_ee56000[] = {
  NSPAIR(_ZN7ee56000C1Ev),
  NSPAIR(_ZN7ee56000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee56000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56000[];
extern void _ZN7ee560003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee560003barEv,_ZTv0_n12_N7ee560003barEv)();
extern void ABISELECT(_ZThn16_N7ee560003barEv,_ZThn8_N7ee560003barEv)() __attribute__((weak));
extern void _ZN6dd60003fooEv();
static  VTBL_ENTRY vtc_ee56000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56000[0]),
  (VTBL_ENTRY)&_ZN7ee560003barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee560003barEv,_ZTv0_n12_N7ee560003barEv),
  (VTBL_ENTRY)&_ZN6dd60003fooEv,
};
extern VTBL_ENTRY _ZTV7ee56000[];
static  VTT_ENTRY vtt_ee56000[] = {
  {&(_ZTV7ee56000[3]),  3,10},
  {&(_ZTV7ee56000[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee56000[];
extern  VTBL_ENTRY _ZTV7ee56000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56000[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee560003barEv,_ZTv0_n12_N7ee560003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee560003barEv,_ZThn8_N7ee560003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56000 = {  "ee56000", // class name
  bases_ee56000, 4,
  &(vtc_ee56000[0]), // expected_vtbl_contents
  &(vtt_ee56000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56000),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66000  : dd6000 {
  int e;
  virtual void  foo(); // _ZN7ee660003fooEv
  virtual void  bar(); // _ZN7ee660003barEv
  ~ee66000(); // tgen
  ee66000(); // tgen
};
//SIG(1 ee66000) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66000 ::foo(){vfunc_called(this, "_ZN7ee660003fooEv");}
void  ee66000 ::bar(){vfunc_called(this, "_ZN7ee660003barEv");}
ee66000 ::~ee66000(){ note_dtor("ee66000", this);} // tgen
ee66000 ::ee66000(){ note_ctor("ee66000", this);} // tgen

static void Test_ee66000()
{
  extern Class_Descriptor cd_ee66000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66000, buf);
    ee66000 *dp, &lv = *(dp=new (buf) ee66000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee66000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(8,4), "ee66000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(8,4), "ee66000");
    check_base_class_offset(lv, (dd6000*), 0, "ee66000");
    check_field_offset(lv, e, ABISELECT(24,20), "ee66000.e");
    test_class_info(&lv, &cd_ee66000);
    dp->~ee66000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66000(Test_ee66000, "ee66000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66000C1Ev();
extern void _ZN7ee66000D1Ev();
Name_Map name_map_ee66000[] = {
  NSPAIR(_ZN7ee66000C1Ev),
  NSPAIR(_ZN7ee66000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee66000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66000[];
extern void _ZN7ee660003barEv();
extern void _ZN7ee660003fooEv();
static  VTBL_ENTRY vtc_ee66000[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee66000[0]),
  (VTBL_ENTRY)&_ZN7ee660003barEv,
  (VTBL_ENTRY)&_ZN7ee660003fooEv,
};
extern VTBL_ENTRY _ZTI7ee66000[];
extern  VTBL_ENTRY _ZTV7ee66000[];
Class_Descriptor cd_ee66000 = {  "ee66000", // class name
  bases_ee66000, 4,
  &(vtc_ee66000[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66000),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76000  : virtual dd6000 {
  int e;
  virtual void  foo(); // _ZN7ee760003fooEv
  virtual void  bar(); // _ZN7ee760003barEv
  ~ee76000(); // tgen
  ee76000(); // tgen
};
//SIG(1 ee76000) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76000 ::foo(){vfunc_called(this, "_ZN7ee760003fooEv");}
void  ee76000 ::bar(){vfunc_called(this, "_ZN7ee760003barEv");}
ee76000 ::~ee76000(){ note_dtor("ee76000", this);} // tgen
ee76000 ::ee76000(){ note_ctor("ee76000", this);} // tgen

static void Test_ee76000()
{
  extern Class_Descriptor cd_ee76000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76000, buf);
    ee76000 *dp, &lv = *(dp=new (buf) ee76000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee76000");
    check_base_class_offset(lv, (bb00*)(cc000*)(dd6000*), ABISELECT(24,12), "ee76000");
    check_base_class_offset(lv, (cc000*)(dd6000*), ABISELECT(24,12), "ee76000");
    check_base_class_offset(lv, (dd6000*), ABISELECT(16,8), "ee76000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76000.e");
    test_class_info(&lv, &cd_ee76000);
    dp->~ee76000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76000(Test_ee76000, "ee76000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76000C1Ev();
extern void _ZN7ee76000D1Ev();
Name_Map name_map_ee76000[] = {
  NSPAIR(_ZN7ee76000C1Ev),
  NSPAIR(_ZN7ee76000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd6000;
extern VTBL_ENTRY _ZTI6dd6000[];
extern  VTBL_ENTRY _ZTV6dd6000[];
static Base_Class bases_ee76000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76000[];
extern void _ZN7ee760003fooEv();
extern void _ZN7ee760003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee760003barEv,_ZTv0_n12_N7ee760003barEv)();
extern void ABISELECT(_ZThn16_N7ee760003barEv,_ZThn8_N7ee760003barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee760003fooEv,_ZTv0_n16_N7ee760003fooEv)();
extern void ABISELECT(_ZThn16_N7ee760003fooEv,_ZThn8_N7ee760003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76000[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76000[0]),
  (VTBL_ENTRY)&_ZN7ee760003fooEv,
  (VTBL_ENTRY)&_ZN7ee760003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee760003barEv,_ZTv0_n12_N7ee760003barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee760003fooEv,_ZTv0_n16_N7ee760003fooEv),
};
extern VTBL_ENTRY _ZTV7ee76000[];
static  VTT_ENTRY vtt_ee76000[] = {
  {&(_ZTV7ee76000[3]),  3,11},
  {&(_ZTV7ee76000[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee76000[];
extern  VTBL_ENTRY _ZTV7ee76000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76000[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee760003fooEv,_ZTv0_n16_N7ee760003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760003fooEv,_ZThn8_N7ee760003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee760003barEv,_ZTv0_n12_N7ee760003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee760003barEv,_ZThn8_N7ee760003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76000 = {  "ee76000", // class name
  bases_ee76000, 4,
  &(vtc_ee76000[0]), // expected_vtbl_contents
  &(vtt_ee76000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76000),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7000  : virtual cc000 {
  int d;
  virtual void  bar(); // _ZN6dd70003barEv
  virtual void  foo(); // _ZN6dd70003fooEv
  ~dd7000(); // tgen
  dd7000(); // tgen
};
//SIG(-1 dd7000) C1{ VBC2{ BC3{ BC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd7000 ::bar(){vfunc_called(this, "_ZN6dd70003barEv");}
void  dd7000 ::foo(){vfunc_called(this, "_ZN6dd70003fooEv");}
dd7000 ::~dd7000(){ note_dtor("dd7000", this);} // tgen
dd7000 ::dd7000(){ note_ctor("dd7000", this);} // tgen

static void Test_dd7000()
{
  extern Class_Descriptor cd_dd7000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd7000, buf);
    dd7000 *dp, &lv = *(dp=new (buf) dd7000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd7000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(12,8), "dd7000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(12,8), "dd7000");
    check_base_class_offset(lv, (cc000*), ABISELECT(12,8), "dd7000");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7000.d");
    test_class_info(&lv, &cd_dd7000);
    dp->~dd7000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7000(Test_dd7000, "dd7000", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd7000C1Ev();
extern void _ZN6dd7000D1Ev();
Name_Map name_map_dd7000[] = {
  NSPAIR(_ZN6dd7000C1Ev),
  NSPAIR(_ZN6dd7000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
static Base_Class bases_dd7000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY vtc_dd7000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
extern VTBL_ENTRY _ZTV6dd7000[];
static  VTT_ENTRY vtt_dd7000[] = {
  {&(_ZTV6dd7000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
Class_Descriptor cd_dd7000 = {  "dd7000", // class name
  bases_dd7000, 3,
  &(vtc_dd7000[0]), // expected_vtbl_contents
  &(vtt_dd7000[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd7000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7000),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07000  : dd7000 {
  int e;
  ~ee07000(); // tgen
  ee07000(); // tgen
};
//SIG(1 ee07000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee07000 ::~ee07000(){ note_dtor("ee07000", this);} // tgen
ee07000 ::ee07000(){ note_ctor("ee07000", this);} // tgen

static void Test_ee07000()
{
  extern Class_Descriptor cd_ee07000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee07000, buf);
    ee07000 *dp, &lv = *(dp=new (buf) ee07000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee07000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee07000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee07000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(16,12), "ee07000");
    check_base_class_offset(lv, (dd7000*), 0, "ee07000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07000.e");
    test_class_info(&lv, &cd_ee07000);
    dp->~ee07000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07000(Test_ee07000, "ee07000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee07000C1Ev();
extern void _ZN7ee07000D1Ev();
Name_Map name_map_ee07000[] = {
  NSPAIR(_ZN7ee07000C1Ev),
  NSPAIR(_ZN7ee07000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee07000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY vtc_ee07000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
extern VTBL_ENTRY _ZTV7ee07000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee07000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee07000[] = {
  {&(_ZTV7ee07000[3]),  3,5},
  {&(_tg__ZTV6dd7000__7ee07000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee07000[];
extern  VTBL_ENTRY _ZTV7ee07000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07000[];
Class_Descriptor cd_ee07000 = {  "ee07000", // class name
  bases_ee07000, 4,
  &(vtc_ee07000[0]), // expected_vtbl_contents
  &(vtt_ee07000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee07000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17000  : virtual dd7000 {
  int e;
  ~ee17000(); // tgen
  ee17000(); // tgen
};
//SIG(1 ee17000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee17000 ::~ee17000(){ note_dtor("ee17000", this);} // tgen
ee17000 ::ee17000(){ note_ctor("ee17000", this);} // tgen

static void Test_ee17000()
{
  extern Class_Descriptor cd_ee17000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee17000, buf);
    ee17000 *dp, &lv = *(dp=new (buf) ee17000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee17000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee17000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee17000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(28,16), "ee17000");
    check_base_class_offset(lv, (dd7000*), ABISELECT(16,8), "ee17000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17000.e");
    test_class_info(&lv, &cd_ee17000);
    dp->~ee17000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17000(Test_ee17000, "ee17000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee17000C1Ev();
extern void _ZN7ee17000D1Ev();
Name_Map name_map_ee17000[] = {
  NSPAIR(_ZN7ee17000C1Ev),
  NSPAIR(_ZN7ee17000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee17000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY vtc_ee17000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17000[0]),
  0,
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
extern VTBL_ENTRY _ZTV7ee17000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee17000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee17000[] = {
  {&(_ZTV7ee17000[4]),  4,11},
  {&(_ZTV7ee17000[9]),  9,11},
  {&(_tg__ZTV6dd7000__7ee17000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee17000[];
extern  VTBL_ENTRY _ZTV7ee17000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17000[];
Class_Descriptor cd_ee17000 = {  "ee17000", // class name
  bases_ee17000, 4,
  &(vtc_ee17000[0]), // expected_vtbl_contents
  &(vtt_ee17000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee17000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17000),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27000  : dd7000 {
  int e;
  virtual void  foo(); // _ZN7ee270003fooEv
  ~ee27000(); // tgen
  ee27000(); // tgen
};
//SIG(1 ee27000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27000 ::foo(){vfunc_called(this, "_ZN7ee270003fooEv");}
ee27000 ::~ee27000(){ note_dtor("ee27000", this);} // tgen
ee27000 ::ee27000(){ note_ctor("ee27000", this);} // tgen

static void Test_ee27000()
{
  extern Class_Descriptor cd_ee27000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee27000, buf);
    ee27000 *dp, &lv = *(dp=new (buf) ee27000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee27000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee27000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee27000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(16,12), "ee27000");
    check_base_class_offset(lv, (dd7000*), 0, "ee27000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27000.e");
    test_class_info(&lv, &cd_ee27000);
    dp->~ee27000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27000(Test_ee27000, "ee27000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee27000C1Ev();
extern void _ZN7ee27000D1Ev();
Name_Map name_map_ee27000[] = {
  NSPAIR(_ZN7ee27000C1Ev),
  NSPAIR(_ZN7ee27000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee27000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27000[];
extern void _ZN6dd70003barEv();
extern void _ZN7ee270003fooEv();
static  VTBL_ENTRY vtc_ee27000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN7ee270003fooEv,
};
extern VTBL_ENTRY _ZTV7ee27000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee27000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee27000[] = {
  {&(_ZTV7ee27000[3]),  3,5},
  {&(_tg__ZTV6dd7000__7ee27000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee27000[];
extern  VTBL_ENTRY _ZTV7ee27000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27000[];
Class_Descriptor cd_ee27000 = {  "ee27000", // class name
  bases_ee27000, 4,
  &(vtc_ee27000[0]), // expected_vtbl_contents
  &(vtt_ee27000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee27000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37000  : virtual dd7000 {
  int e;
  virtual void  foo(); // _ZN7ee370003fooEv
  ~ee37000(); // tgen
  ee37000(); // tgen
};
//SIG(1 ee37000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37000 ::foo(){vfunc_called(this, "_ZN7ee370003fooEv");}
ee37000 ::~ee37000(){ note_dtor("ee37000", this);} // tgen
ee37000 ::ee37000(){ note_ctor("ee37000", this);} // tgen

static void Test_ee37000()
{
  extern Class_Descriptor cd_ee37000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee37000, buf);
    ee37000 *dp, &lv = *(dp=new (buf) ee37000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee37000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee37000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee37000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(28,16), "ee37000");
    check_base_class_offset(lv, (dd7000*), ABISELECT(16,8), "ee37000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37000.e");
    test_class_info(&lv, &cd_ee37000);
    dp->~ee37000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37000(Test_ee37000, "ee37000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee37000C1Ev();
extern void _ZN7ee37000D1Ev();
Name_Map name_map_ee37000[] = {
  NSPAIR(_ZN7ee37000C1Ev),
  NSPAIR(_ZN7ee37000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee37000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37000[];
extern void _ZN7ee370003fooEv();
extern void _ZN6dd70003barEv();
extern void ABISELECT(_ZTv0_n40_N7ee370003fooEv,_ZTv0_n20_N7ee370003fooEv)();
extern void ABISELECT(_ZThn16_N7ee370003fooEv,_ZThn8_N7ee370003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37000[0]),
  (VTBL_ENTRY)&_ZN7ee370003fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee370003fooEv,_ZTv0_n20_N7ee370003fooEv),
};
extern VTBL_ENTRY _ZTV7ee37000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee37000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee37000[] = {
  {&(_ZTV7ee37000[4]),  4,12},
  {&(_ZTV7ee37000[10]),  10,12},
  {&(_tg__ZTV6dd7000__7ee37000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee37000[];
extern  VTBL_ENTRY _ZTV7ee37000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37000[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee370003fooEv,_ZTv0_n20_N7ee370003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee370003fooEv,_ZThn8_N7ee370003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37000 = {  "ee37000", // class name
  bases_ee37000, 4,
  &(vtc_ee37000[0]), // expected_vtbl_contents
  &(vtt_ee37000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee37000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37000),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47000  : dd7000 {
  int e;
  virtual void  bar(); // _ZN7ee470003barEv
  ~ee47000(); // tgen
  ee47000(); // tgen
};
//SIG(1 ee47000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47000 ::bar(){vfunc_called(this, "_ZN7ee470003barEv");}
ee47000 ::~ee47000(){ note_dtor("ee47000", this);} // tgen
ee47000 ::ee47000(){ note_ctor("ee47000", this);} // tgen

static void Test_ee47000()
{
  extern Class_Descriptor cd_ee47000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee47000, buf);
    ee47000 *dp, &lv = *(dp=new (buf) ee47000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee47000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee47000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee47000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(16,12), "ee47000");
    check_base_class_offset(lv, (dd7000*), 0, "ee47000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47000.e");
    test_class_info(&lv, &cd_ee47000);
    dp->~ee47000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47000(Test_ee47000, "ee47000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee47000C1Ev();
extern void _ZN7ee47000D1Ev();
Name_Map name_map_ee47000[] = {
  NSPAIR(_ZN7ee47000C1Ev),
  NSPAIR(_ZN7ee47000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee47000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47000[];
extern void _ZN7ee470003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY vtc_ee47000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47000[0]),
  (VTBL_ENTRY)&_ZN7ee470003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
extern VTBL_ENTRY _ZTV7ee47000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee47000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee47000[] = {
  {&(_ZTV7ee47000[3]),  3,5},
  {&(_tg__ZTV6dd7000__7ee47000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee47000[];
extern  VTBL_ENTRY _ZTV7ee47000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47000[];
Class_Descriptor cd_ee47000 = {  "ee47000", // class name
  bases_ee47000, 4,
  &(vtc_ee47000[0]), // expected_vtbl_contents
  &(vtt_ee47000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee47000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57000  : virtual dd7000 {
  int e;
  virtual void  bar(); // _ZN7ee570003barEv
  ~ee57000(); // tgen
  ee57000(); // tgen
};
//SIG(1 ee57000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57000 ::bar(){vfunc_called(this, "_ZN7ee570003barEv");}
ee57000 ::~ee57000(){ note_dtor("ee57000", this);} // tgen
ee57000 ::ee57000(){ note_ctor("ee57000", this);} // tgen

static void Test_ee57000()
{
  extern Class_Descriptor cd_ee57000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee57000, buf);
    ee57000 *dp, &lv = *(dp=new (buf) ee57000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee57000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee57000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee57000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(28,16), "ee57000");
    check_base_class_offset(lv, (dd7000*), ABISELECT(16,8), "ee57000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57000.e");
    test_class_info(&lv, &cd_ee57000);
    dp->~ee57000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57000(Test_ee57000, "ee57000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee57000C1Ev();
extern void _ZN7ee57000D1Ev();
Name_Map name_map_ee57000[] = {
  NSPAIR(_ZN7ee57000C1Ev),
  NSPAIR(_ZN7ee57000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee57000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57000[];
extern void _ZN7ee570003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee570003barEv,_ZTv0_n16_N7ee570003barEv)();
extern void ABISELECT(_ZThn16_N7ee570003barEv,_ZThn8_N7ee570003barEv)() __attribute__((weak));
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY vtc_ee57000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57000[0]),
  (VTBL_ENTRY)&_ZN7ee570003barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee570003barEv,_ZTv0_n16_N7ee570003barEv),
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
extern VTBL_ENTRY _ZTV7ee57000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee57000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee57000[] = {
  {&(_ZTV7ee57000[4]),  4,12},
  {&(_ZTV7ee57000[10]),  10,12},
  {&(_tg__ZTV6dd7000__7ee57000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee57000[];
extern  VTBL_ENTRY _ZTV7ee57000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57000[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee570003barEv,_ZTv0_n16_N7ee570003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee570003barEv,_ZThn8_N7ee570003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57000 = {  "ee57000", // class name
  bases_ee57000, 4,
  &(vtc_ee57000[0]), // expected_vtbl_contents
  &(vtt_ee57000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee57000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57000),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67000  : dd7000 {
  int e;
  virtual void  foo(); // _ZN7ee670003fooEv
  virtual void  bar(); // _ZN7ee670003barEv
  ~ee67000(); // tgen
  ee67000(); // tgen
};
//SIG(1 ee67000) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67000 ::foo(){vfunc_called(this, "_ZN7ee670003fooEv");}
void  ee67000 ::bar(){vfunc_called(this, "_ZN7ee670003barEv");}
ee67000 ::~ee67000(){ note_dtor("ee67000", this);} // tgen
ee67000 ::ee67000(){ note_ctor("ee67000", this);} // tgen

static void Test_ee67000()
{
  extern Class_Descriptor cd_ee67000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee67000, buf);
    ee67000 *dp, &lv = *(dp=new (buf) ee67000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee67000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(16,12), "ee67000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(16,12), "ee67000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(16,12), "ee67000");
    check_base_class_offset(lv, (dd7000*), 0, "ee67000");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67000.e");
    test_class_info(&lv, &cd_ee67000);
    dp->~ee67000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67000(Test_ee67000, "ee67000", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee67000C1Ev();
extern void _ZN7ee67000D1Ev();
Name_Map name_map_ee67000[] = {
  NSPAIR(_ZN7ee67000C1Ev),
  NSPAIR(_ZN7ee67000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee67000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67000[];
extern void _ZN7ee670003barEv();
extern void _ZN7ee670003fooEv();
static  VTBL_ENTRY vtc_ee67000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67000[0]),
  (VTBL_ENTRY)&_ZN7ee670003barEv,
  (VTBL_ENTRY)&_ZN7ee670003fooEv,
};
extern VTBL_ENTRY _ZTV7ee67000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee67000[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee67000[] = {
  {&(_ZTV7ee67000[3]),  3,5},
  {&(_tg__ZTV6dd7000__7ee67000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee67000[];
extern  VTBL_ENTRY _ZTV7ee67000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67000[];
Class_Descriptor cd_ee67000 = {  "ee67000", // class name
  bases_ee67000, 4,
  &(vtc_ee67000[0]), // expected_vtbl_contents
  &(vtt_ee67000[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee67000),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67000),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67000),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77000  : virtual dd7000 {
  int e;
  virtual void  foo(); // _ZN7ee770003fooEv
  virtual void  bar(); // _ZN7ee770003barEv
  ~ee77000(); // tgen
  ee77000(); // tgen
};
//SIG(1 ee77000) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77000 ::foo(){vfunc_called(this, "_ZN7ee770003fooEv");}
void  ee77000 ::bar(){vfunc_called(this, "_ZN7ee770003barEv");}
ee77000 ::~ee77000(){ note_dtor("ee77000", this);} // tgen
ee77000 ::ee77000(){ note_ctor("ee77000", this);} // tgen

static void Test_ee77000()
{
  extern Class_Descriptor cd_ee77000;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee77000, buf);
    ee77000 *dp, &lv = *(dp=new (buf) ee77000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee77000)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77000)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc000*), ABISELECT(28,16), "ee77000");
    check_base_class_offset(lv, (bb00*)(cc000*), ABISELECT(28,16), "ee77000");
    check_base_class_offset(lv, (cc000*)(dd7000*), ABISELECT(28,16), "ee77000");
    check_base_class_offset(lv, (dd7000*), ABISELECT(16,8), "ee77000");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77000.e");
    test_class_info(&lv, &cd_ee77000);
    dp->~ee77000();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77000(Test_ee77000, "ee77000", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee77000C1Ev();
extern void _ZN7ee77000D1Ev();
Name_Map name_map_ee77000[] = {
  NSPAIR(_ZN7ee77000C1Ev),
  NSPAIR(_ZN7ee77000D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc000;
extern VTBL_ENTRY _ZTI5cc000[];
extern Class_Descriptor cd_dd7000;
extern VTBL_ENTRY _ZTI6dd7000[];
extern  VTBL_ENTRY _ZTV6dd7000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7000[];
static Base_Class bases_ee77000[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc000,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7000,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77000[];
extern void _ZN7ee770003fooEv();
extern void _ZN7ee770003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee770003barEv,_ZTv0_n16_N7ee770003barEv)();
extern void ABISELECT(_ZThn16_N7ee770003barEv,_ZThn8_N7ee770003barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee770003fooEv,_ZTv0_n20_N7ee770003fooEv)();
extern void ABISELECT(_ZThn16_N7ee770003fooEv,_ZThn8_N7ee770003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77000[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77000[0]),
  (VTBL_ENTRY)&_ZN7ee770003fooEv,
  (VTBL_ENTRY)&_ZN7ee770003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77000[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee770003barEv,_ZTv0_n16_N7ee770003barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee770003fooEv,_ZTv0_n20_N7ee770003fooEv),
};
extern VTBL_ENTRY _ZTV7ee77000[];
extern void _ZN6dd70003barEv();
extern void _ZN6dd70003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7000__7ee77000[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7000[0]),
  (VTBL_ENTRY)&_ZN6dd70003barEv,
  (VTBL_ENTRY)&_ZN6dd70003fooEv,
};
static  VTT_ENTRY vtt_ee77000[] = {
  {&(_ZTV7ee77000[4]),  4,13},
  {&(_ZTV7ee77000[11]),  11,13},
  {&(_tg__ZTV6dd7000__7ee77000[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7ee77000[];
extern  VTBL_ENTRY _ZTV7ee77000[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77000[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee770003fooEv,_ZTv0_n20_N7ee770003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770003fooEv,_ZThn8_N7ee770003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee770003barEv,_ZTv0_n16_N7ee770003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee770003barEv,_ZThn8_N7ee770003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77000 = {  "ee77000", // class name
  bases_ee77000, 4,
  &(vtc_ee77000[0]), // expected_vtbl_contents
  &(vtt_ee77000[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee77000),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77000),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77000),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc100  : virtual bb00 {
  int c;
  ~cc100(); // tgen
  cc100(); // tgen
};
//SIG(-1 cc100) C1{ VBC2{ BC3{ Fi} Fi} Fi}


cc100 ::~cc100(){ note_dtor("cc100", this);} // tgen
cc100 ::cc100(){ note_ctor("cc100", this);} // tgen

static void Test_cc100()
{
  extern Class_Descriptor cd_cc100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc100, buf);
    cc100 *dp, &lv = *(dp=new (buf) cc100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(12,8), "cc100");
    check_base_class_offset(lv, (bb00*), ABISELECT(12,8), "cc100");
    check_field_offset(lv, c, ABISELECT(8,4), "cc100.c");
    test_class_info(&lv, &cd_cc100);
    dp->~cc100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc100(Test_cc100, "cc100", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc100C1Ev();
extern void _ZN5cc100D1Ev();
Name_Map name_map_cc100[] = {
  NSPAIR(_ZN5cc100C1Ev),
  NSPAIR(_ZN5cc100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
static Base_Class bases_cc100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(12,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI5cc100[];
static  VTBL_ENTRY vtc_cc100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
extern VTBL_ENTRY _ZTV5cc100[];
static  VTT_ENTRY vtt_cc100[] = {
  {&(_ZTV5cc100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
Class_Descriptor cd_cc100 = {  "cc100", // class name
  bases_cc100, 2,
  &(vtc_cc100[0]), // expected_vtbl_contents
  &(vtt_cc100[0]), // expected_vtt_contents
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc100),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT5cc100),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0100  : cc100 {
  int d;
  ~dd0100(); // tgen
  dd0100(); // tgen
};
//SIG(-1 dd0100) C1{ BC2{ VBC3{ BC4{ Fi} Fi} Fi} Fi}


dd0100 ::~dd0100(){ note_dtor("dd0100", this);} // tgen
dd0100 ::dd0100(){ note_ctor("dd0100", this);} // tgen

static void Test_dd0100()
{
  extern Class_Descriptor cd_dd0100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0100, buf);
    dd0100 *dp, &lv = *(dp=new (buf) dd0100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(16,12), "dd0100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(16,12), "dd0100");
    check_base_class_offset(lv, (cc100*), 0, "dd0100");
    check_field_offset(lv, d, ABISELECT(12,8), "dd0100.d");
    test_class_info(&lv, &cd_dd0100);
    dp->~dd0100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0100(Test_dd0100, "dd0100", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0100C1Ev();
extern void _ZN6dd0100D1Ev();
Name_Map name_map_dd0100[] = {
  NSPAIR(_ZN6dd0100C1Ev),
  NSPAIR(_ZN6dd0100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd0100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0100[];
static  VTBL_ENTRY vtc_dd0100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
extern VTBL_ENTRY _ZTV6dd0100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd0100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd0100[] = {
  {&(_ZTV6dd0100[3]),  3,3},
  {&(_tg__ZTV5cc100__6dd0100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
Class_Descriptor cd_dd0100 = {  "dd0100", // class name
  bases_dd0100, 3,
  &(vtc_dd0100[0]), // expected_vtbl_contents
  &(vtt_dd0100[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0100),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd0100),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00100  : dd0100 {
  int e;
  ~ee00100(); // tgen
  ee00100(); // tgen
};
//SIG(1 ee00100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} Fi}


ee00100 ::~ee00100(){ note_dtor("ee00100", this);} // tgen
ee00100 ::ee00100(){ note_ctor("ee00100", this);} // tgen

static void Test_ee00100()
{
  extern Class_Descriptor cd_ee00100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00100, buf);
    ee00100 *dp, &lv = *(dp=new (buf) ee00100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee00100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(20,16), "ee00100");
    check_base_class_offset(lv, (cc100*)(dd0100*), 0, "ee00100");
    check_base_class_offset(lv, (dd0100*), 0, "ee00100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee00100.e");
    test_class_info(&lv, &cd_ee00100);
    dp->~ee00100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00100(Test_ee00100, "ee00100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00100C1Ev();
extern void _ZN7ee00100D1Ev();
Name_Map name_map_ee00100[] = {
  NSPAIR(_ZN7ee00100C1Ev),
  NSPAIR(_ZN7ee00100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee00100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00100[];
static  VTBL_ENTRY vtc_ee00100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee00100[0]),
};
extern VTBL_ENTRY _ZTV7ee00100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee00100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee00100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee00100[] = {
  {&(_ZTV7ee00100[3]),  3,3},
  {&(_tg__ZTV6dd0100__7ee00100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee00100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee00100[];
extern  VTBL_ENTRY _ZTV7ee00100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee00100[];
Class_Descriptor cd_ee00100 = {  "ee00100", // class name
  bases_ee00100, 4,
  &(vtc_ee00100[0]), // expected_vtbl_contents
  &(vtt_ee00100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00100),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee00100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10100  : virtual dd0100 {
  int e;
  ~ee10100(); // tgen
  ee10100(); // tgen
};
//SIG(1 ee10100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} Fi}


ee10100 ::~ee10100(){ note_dtor("ee10100", this);} // tgen
ee10100 ::ee10100(){ note_ctor("ee10100", this);} // tgen

static void Test_ee10100()
{
  extern Class_Descriptor cd_ee10100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10100, buf);
    ee10100 *dp, &lv = *(dp=new (buf) ee10100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee10100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(32,20), "ee10100");
    check_base_class_offset(lv, (cc100*)(dd0100*), ABISELECT(16,8), "ee10100");
    check_base_class_offset(lv, (dd0100*), ABISELECT(16,8), "ee10100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10100.e");
    test_class_info(&lv, &cd_ee10100);
    dp->~ee10100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10100(Test_ee10100, "ee10100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10100C1Ev();
extern void _ZN7ee10100D1Ev();
Name_Map name_map_ee10100[] = {
  NSPAIR(_ZN7ee10100C1Ev),
  NSPAIR(_ZN7ee10100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee10100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10100[];
static  VTBL_ENTRY vtc_ee10100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10100[0]),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10100[0]),
};
extern VTBL_ENTRY _ZTV7ee10100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee10100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee10100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee10100[] = {
  {&(_ZTV7ee10100[4]),  4,7},
  {&(_ZTV7ee10100[7]),  7,7},
  {&(_tg__ZTV6dd0100__7ee10100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee10100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee10100[];
extern  VTBL_ENTRY _ZTV7ee10100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10100[];
Class_Descriptor cd_ee10100 = {  "ee10100", // class name
  bases_ee10100, 4,
  &(vtc_ee10100[0]), // expected_vtbl_contents
  &(vtt_ee10100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10100),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20100  : dd0100 {
  int e;
  virtual void  foo(); // _ZN7ee201003fooEv
  ~ee20100(); // tgen
  ee20100(); // tgen
};
//SIG(1 ee20100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee20100 ::foo(){vfunc_called(this, "_ZN7ee201003fooEv");}
ee20100 ::~ee20100(){ note_dtor("ee20100", this);} // tgen
ee20100 ::ee20100(){ note_ctor("ee20100", this);} // tgen

static void Test_ee20100()
{
  extern Class_Descriptor cd_ee20100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20100, buf);
    ee20100 *dp, &lv = *(dp=new (buf) ee20100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee20100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(20,16), "ee20100");
    check_base_class_offset(lv, (cc100*)(dd0100*), 0, "ee20100");
    check_base_class_offset(lv, (dd0100*), 0, "ee20100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee20100.e");
    test_class_info(&lv, &cd_ee20100);
    dp->~ee20100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20100(Test_ee20100, "ee20100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20100C1Ev();
extern void _ZN7ee20100D1Ev();
Name_Map name_map_ee20100[] = {
  NSPAIR(_ZN7ee20100C1Ev),
  NSPAIR(_ZN7ee20100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee20100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20100[];
extern void _ZN7ee201003fooEv();
static  VTBL_ENTRY vtc_ee20100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee20100[0]),
  (VTBL_ENTRY)&_ZN7ee201003fooEv,
};
extern VTBL_ENTRY _ZTV7ee20100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee20100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee20100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee20100[] = {
  {&(_ZTV7ee20100[3]),  3,4},
  {&(_tg__ZTV6dd0100__7ee20100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee20100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee20100[];
extern  VTBL_ENTRY _ZTV7ee20100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee20100[];
Class_Descriptor cd_ee20100 = {  "ee20100", // class name
  bases_ee20100, 4,
  &(vtc_ee20100[0]), // expected_vtbl_contents
  &(vtt_ee20100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee20100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30100  : virtual dd0100 {
  int e;
  virtual void  foo(); // _ZN7ee301003fooEv
  ~ee30100(); // tgen
  ee30100(); // tgen
};
//SIG(1 ee30100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee30100 ::foo(){vfunc_called(this, "_ZN7ee301003fooEv");}
ee30100 ::~ee30100(){ note_dtor("ee30100", this);} // tgen
ee30100 ::ee30100(){ note_ctor("ee30100", this);} // tgen

static void Test_ee30100()
{
  extern Class_Descriptor cd_ee30100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30100, buf);
    ee30100 *dp, &lv = *(dp=new (buf) ee30100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee30100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(32,20), "ee30100");
    check_base_class_offset(lv, (cc100*)(dd0100*), ABISELECT(16,8), "ee30100");
    check_base_class_offset(lv, (dd0100*), ABISELECT(16,8), "ee30100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30100.e");
    test_class_info(&lv, &cd_ee30100);
    dp->~ee30100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30100(Test_ee30100, "ee30100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30100C1Ev();
extern void _ZN7ee30100D1Ev();
Name_Map name_map_ee30100[] = {
  NSPAIR(_ZN7ee30100C1Ev),
  NSPAIR(_ZN7ee30100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee30100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30100[];
extern void _ZN7ee301003fooEv();
static  VTBL_ENTRY vtc_ee30100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30100[0]),
  (VTBL_ENTRY)&_ZN7ee301003fooEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30100[0]),
};
extern VTBL_ENTRY _ZTV7ee30100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee30100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee30100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee30100[] = {
  {&(_ZTV7ee30100[4]),  4,8},
  {&(_ZTV7ee30100[8]),  8,8},
  {&(_tg__ZTV6dd0100__7ee30100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee30100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee30100[];
extern  VTBL_ENTRY _ZTV7ee30100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30100[];
Class_Descriptor cd_ee30100 = {  "ee30100", // class name
  bases_ee30100, 4,
  &(vtc_ee30100[0]), // expected_vtbl_contents
  &(vtt_ee30100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40100  : dd0100 {
  int e;
  virtual void  bar(); // _ZN7ee401003barEv
  ~ee40100(); // tgen
  ee40100(); // tgen
};
//SIG(1 ee40100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee40100 ::bar(){vfunc_called(this, "_ZN7ee401003barEv");}
ee40100 ::~ee40100(){ note_dtor("ee40100", this);} // tgen
ee40100 ::ee40100(){ note_ctor("ee40100", this);} // tgen

static void Test_ee40100()
{
  extern Class_Descriptor cd_ee40100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40100, buf);
    ee40100 *dp, &lv = *(dp=new (buf) ee40100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee40100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(20,16), "ee40100");
    check_base_class_offset(lv, (cc100*)(dd0100*), 0, "ee40100");
    check_base_class_offset(lv, (dd0100*), 0, "ee40100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee40100.e");
    test_class_info(&lv, &cd_ee40100);
    dp->~ee40100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40100(Test_ee40100, "ee40100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40100C1Ev();
extern void _ZN7ee40100D1Ev();
Name_Map name_map_ee40100[] = {
  NSPAIR(_ZN7ee40100C1Ev),
  NSPAIR(_ZN7ee40100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee40100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40100[];
extern void _ZN7ee401003barEv();
static  VTBL_ENTRY vtc_ee40100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee40100[0]),
  (VTBL_ENTRY)&_ZN7ee401003barEv,
};
extern VTBL_ENTRY _ZTV7ee40100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee40100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee40100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee40100[] = {
  {&(_ZTV7ee40100[3]),  3,4},
  {&(_tg__ZTV6dd0100__7ee40100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee40100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee40100[];
extern  VTBL_ENTRY _ZTV7ee40100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee40100[];
Class_Descriptor cd_ee40100 = {  "ee40100", // class name
  bases_ee40100, 4,
  &(vtc_ee40100[0]), // expected_vtbl_contents
  &(vtt_ee40100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee40100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50100  : virtual dd0100 {
  int e;
  virtual void  bar(); // _ZN7ee501003barEv
  ~ee50100(); // tgen
  ee50100(); // tgen
};
//SIG(1 ee50100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee50100 ::bar(){vfunc_called(this, "_ZN7ee501003barEv");}
ee50100 ::~ee50100(){ note_dtor("ee50100", this);} // tgen
ee50100 ::ee50100(){ note_ctor("ee50100", this);} // tgen

static void Test_ee50100()
{
  extern Class_Descriptor cd_ee50100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50100, buf);
    ee50100 *dp, &lv = *(dp=new (buf) ee50100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee50100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(32,20), "ee50100");
    check_base_class_offset(lv, (cc100*)(dd0100*), ABISELECT(16,8), "ee50100");
    check_base_class_offset(lv, (dd0100*), ABISELECT(16,8), "ee50100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50100.e");
    test_class_info(&lv, &cd_ee50100);
    dp->~ee50100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50100(Test_ee50100, "ee50100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50100C1Ev();
extern void _ZN7ee50100D1Ev();
Name_Map name_map_ee50100[] = {
  NSPAIR(_ZN7ee50100C1Ev),
  NSPAIR(_ZN7ee50100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee50100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50100[];
extern void _ZN7ee501003barEv();
static  VTBL_ENTRY vtc_ee50100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50100[0]),
  (VTBL_ENTRY)&_ZN7ee501003barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50100[0]),
};
extern VTBL_ENTRY _ZTV7ee50100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee50100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee50100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee50100[] = {
  {&(_ZTV7ee50100[4]),  4,8},
  {&(_ZTV7ee50100[8]),  8,8},
  {&(_tg__ZTV6dd0100__7ee50100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee50100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee50100[];
extern  VTBL_ENTRY _ZTV7ee50100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50100[];
Class_Descriptor cd_ee50100 = {  "ee50100", // class name
  bases_ee50100, 4,
  &(vtc_ee50100[0]), // expected_vtbl_contents
  &(vtt_ee50100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60100  : dd0100 {
  int e;
  virtual void  foo(); // _ZN7ee601003fooEv
  virtual void  bar(); // _ZN7ee601003barEv
  ~ee60100(); // tgen
  ee60100(); // tgen
};
//SIG(1 ee60100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee60100 ::foo(){vfunc_called(this, "_ZN7ee601003fooEv");}
void  ee60100 ::bar(){vfunc_called(this, "_ZN7ee601003barEv");}
ee60100 ::~ee60100(){ note_dtor("ee60100", this);} // tgen
ee60100 ::ee60100(){ note_ctor("ee60100", this);} // tgen

static void Test_ee60100()
{
  extern Class_Descriptor cd_ee60100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60100, buf);
    ee60100 *dp, &lv = *(dp=new (buf) ee60100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee60100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(20,16), "ee60100");
    check_base_class_offset(lv, (cc100*)(dd0100*), 0, "ee60100");
    check_base_class_offset(lv, (dd0100*), 0, "ee60100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee60100.e");
    test_class_info(&lv, &cd_ee60100);
    dp->~ee60100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60100(Test_ee60100, "ee60100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60100C1Ev();
extern void _ZN7ee60100D1Ev();
Name_Map name_map_ee60100[] = {
  NSPAIR(_ZN7ee60100C1Ev),
  NSPAIR(_ZN7ee60100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee60100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60100[];
extern void _ZN7ee601003fooEv();
extern void _ZN7ee601003barEv();
static  VTBL_ENTRY vtc_ee60100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee60100[0]),
  (VTBL_ENTRY)&_ZN7ee601003fooEv,
  (VTBL_ENTRY)&_ZN7ee601003barEv,
};
extern VTBL_ENTRY _ZTV7ee60100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee60100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee60100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee60100[] = {
  {&(_ZTV7ee60100[3]),  3,5},
  {&(_tg__ZTV6dd0100__7ee60100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee60100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee60100[];
extern  VTBL_ENTRY _ZTV7ee60100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee60100[];
Class_Descriptor cd_ee60100 = {  "ee60100", // class name
  bases_ee60100, 4,
  &(vtc_ee60100[0]), // expected_vtbl_contents
  &(vtt_ee60100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee60100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70100  : virtual dd0100 {
  int e;
  virtual void  foo(); // _ZN7ee701003fooEv
  virtual void  bar(); // _ZN7ee701003barEv
  ~ee70100(); // tgen
  ee70100(); // tgen
};
//SIG(1 ee70100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee70100 ::foo(){vfunc_called(this, "_ZN7ee701003fooEv");}
void  ee70100 ::bar(){vfunc_called(this, "_ZN7ee701003barEv");}
ee70100 ::~ee70100(){ note_dtor("ee70100", this);} // tgen
ee70100 ::ee70100(){ note_ctor("ee70100", this);} // tgen

static void Test_ee70100()
{
  extern Class_Descriptor cd_ee70100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70100, buf);
    ee70100 *dp, &lv = *(dp=new (buf) ee70100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee70100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd0100*), ABISELECT(32,20), "ee70100");
    check_base_class_offset(lv, (cc100*)(dd0100*), ABISELECT(16,8), "ee70100");
    check_base_class_offset(lv, (dd0100*), ABISELECT(16,8), "ee70100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70100.e");
    test_class_info(&lv, &cd_ee70100);
    dp->~ee70100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70100(Test_ee70100, "ee70100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70100C1Ev();
extern void _ZN7ee70100D1Ev();
Name_Map name_map_ee70100[] = {
  NSPAIR(_ZN7ee70100C1Ev),
  NSPAIR(_ZN7ee70100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd0100;
extern VTBL_ENTRY _ZTI6dd0100[];
extern  VTBL_ENTRY _ZTV6dd0100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd0100[];
static Base_Class bases_ee70100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70100[];
extern void _ZN7ee701003fooEv();
extern void _ZN7ee701003barEv();
static  VTBL_ENTRY vtc_ee70100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70100[0]),
  (VTBL_ENTRY)&_ZN7ee701003fooEv,
  (VTBL_ENTRY)&_ZN7ee701003barEv,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70100[0]),
};
extern VTBL_ENTRY _ZTV7ee70100[];
static  VTBL_ENTRY _tg__ZTV6dd0100__7ee70100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd0100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd0100__7ee70100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee70100[] = {
  {&(_ZTV7ee70100[4]),  4,9},
  {&(_ZTV7ee70100[9]),  9,9},
  {&(_tg__ZTV6dd0100__7ee70100[3]),  3,3},
  {&(_tg__ZTV5cc1006dd0100__7ee70100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee70100[];
extern  VTBL_ENTRY _ZTV7ee70100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70100[];
Class_Descriptor cd_ee70100 = {  "ee70100", // class name
  bases_ee70100, 4,
  &(vtc_ee70100[0]), // expected_vtbl_contents
  &(vtt_ee70100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1100  : virtual cc100 {
  int d;
  ~dd1100(); // tgen
  dd1100(); // tgen
};
//SIG(-1 dd1100) C1{ VBC2{ VBC3{ BC4{ Fi} Fi} Fi} Fi}


dd1100 ::~dd1100(){ note_dtor("dd1100", this);} // tgen
dd1100 ::dd1100(){ note_ctor("dd1100", this);} // tgen

static void Test_dd1100()
{
  extern Class_Descriptor cd_dd1100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1100, buf);
    dd1100 *dp, &lv = *(dp=new (buf) dd1100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,16), "dd1100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,16), "dd1100");
    check_base_class_offset(lv, (cc100*), ABISELECT(16,8), "dd1100");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1100.d");
    test_class_info(&lv, &cd_dd1100);
    dp->~dd1100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1100(Test_dd1100, "dd1100", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1100C1Ev();
extern void _ZN6dd1100D1Ev();
Name_Map name_map_dd1100[] = {
  NSPAIR(_ZN6dd1100C1Ev),
  NSPAIR(_ZN6dd1100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd1100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1100[];
static  VTBL_ENTRY vtc_dd1100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
extern VTBL_ENTRY _ZTV6dd1100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd1100[] = {
  {&(_ZTV6dd1100[4]),  4,7},
  {&(_ZTV6dd1100[7]),  7,7},
  {&(_tg__ZTV5cc100__6dd1100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
Class_Descriptor cd_dd1100 = {  "dd1100", // class name
  bases_dd1100, 3,
  &(vtc_dd1100[0]), // expected_vtbl_contents
  &(vtt_dd1100[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1100),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1100),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01100  : dd1100 {
  int e;
  ~ee01100(); // tgen
  ee01100(); // tgen
};
//SIG(1 ee01100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} Fi}


ee01100 ::~ee01100(){ note_dtor("ee01100", this);} // tgen
ee01100 ::ee01100(){ note_ctor("ee01100", this);} // tgen

static void Test_ee01100()
{
  extern Class_Descriptor cd_ee01100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01100, buf);
    ee01100 *dp, &lv = *(dp=new (buf) ee01100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee01100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee01100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(16,12), "ee01100");
    check_base_class_offset(lv, (dd1100*), 0, "ee01100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01100.e");
    test_class_info(&lv, &cd_ee01100);
    dp->~ee01100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01100(Test_ee01100, "ee01100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01100C1Ev();
extern void _ZN7ee01100D1Ev();
Name_Map name_map_ee01100[] = {
  NSPAIR(_ZN7ee01100C1Ev),
  NSPAIR(_ZN7ee01100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee01100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01100[];
static  VTBL_ENTRY vtc_ee01100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01100[0]),
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01100[0]),
};
extern VTBL_ENTRY _ZTV7ee01100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee01100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee01100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee01100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee01100[] = {
  {&(_ZTV7ee01100[4]),  4,7},
  {&(_tg__ZTV6dd1100__7ee01100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee01100[3]),  3,3},
  {&(_ZTV7ee01100[7]),  7,7},
  {&(_tg__ZTV5cc100__7ee01100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee01100[];
extern  VTBL_ENTRY _ZTV7ee01100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01100[];
Class_Descriptor cd_ee01100 = {  "ee01100", // class name
  bases_ee01100, 4,
  &(vtc_ee01100[0]), // expected_vtbl_contents
  &(vtt_ee01100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01100),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11100  : virtual dd1100 {
  int e;
  ~ee11100(); // tgen
  ee11100(); // tgen
};
//SIG(1 ee11100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} Fi}


ee11100 ::~ee11100(){ note_dtor("ee11100", this);} // tgen
ee11100 ::ee11100(){ note_ctor("ee11100", this);} // tgen

static void Test_ee11100()
{
  extern Class_Descriptor cd_ee11100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11100, buf);
    ee11100 *dp, &lv = *(dp=new (buf) ee11100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee11100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee11100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(32,16), "ee11100");
    check_base_class_offset(lv, (dd1100*), ABISELECT(16,8), "ee11100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11100.e");
    test_class_info(&lv, &cd_ee11100);
    dp->~ee11100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11100(Test_ee11100, "ee11100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11100C1Ev();
extern void _ZN7ee11100D1Ev();
Name_Map name_map_ee11100[] = {
  NSPAIR(_ZN7ee11100C1Ev),
  NSPAIR(_ZN7ee11100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee11100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11100[];
static  VTBL_ENTRY vtc_ee11100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11100[0]),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11100[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11100[0]),
};
extern VTBL_ENTRY _ZTV7ee11100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee11100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee11100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee11100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee11100[] = {
  {&(_ZTV7ee11100[5]),  5,12},
  {&(_ZTV7ee11100[9]),  9,12},
  {&(_ZTV7ee11100[12]),  12,12},
  {&(_tg__ZTV6dd1100__7ee11100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee11100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee11100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee11100[];
extern  VTBL_ENTRY _ZTV7ee11100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11100[];
Class_Descriptor cd_ee11100 = {  "ee11100", // class name
  bases_ee11100, 4,
  &(vtc_ee11100[0]), // expected_vtbl_contents
  &(vtt_ee11100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11100),12, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21100  : dd1100 {
  int e;
  virtual void  foo(); // _ZN7ee211003fooEv
  ~ee21100(); // tgen
  ee21100(); // tgen
};
//SIG(1 ee21100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee21100 ::foo(){vfunc_called(this, "_ZN7ee211003fooEv");}
ee21100 ::~ee21100(){ note_dtor("ee21100", this);} // tgen
ee21100 ::ee21100(){ note_ctor("ee21100", this);} // tgen

static void Test_ee21100()
{
  extern Class_Descriptor cd_ee21100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21100, buf);
    ee21100 *dp, &lv = *(dp=new (buf) ee21100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee21100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee21100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(16,12), "ee21100");
    check_base_class_offset(lv, (dd1100*), 0, "ee21100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21100.e");
    test_class_info(&lv, &cd_ee21100);
    dp->~ee21100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21100(Test_ee21100, "ee21100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21100C1Ev();
extern void _ZN7ee21100D1Ev();
Name_Map name_map_ee21100[] = {
  NSPAIR(_ZN7ee21100C1Ev),
  NSPAIR(_ZN7ee21100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee21100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21100[];
extern void _ZN7ee211003fooEv();
static  VTBL_ENTRY vtc_ee21100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21100[0]),
  (VTBL_ENTRY)&_ZN7ee211003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21100[0]),
};
extern VTBL_ENTRY _ZTV7ee21100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee21100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee21100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee21100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee21100[] = {
  {&(_ZTV7ee21100[4]),  4,8},
  {&(_tg__ZTV6dd1100__7ee21100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee21100[3]),  3,3},
  {&(_ZTV7ee21100[8]),  8,8},
  {&(_tg__ZTV5cc100__7ee21100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee21100[];
extern  VTBL_ENTRY _ZTV7ee21100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21100[];
Class_Descriptor cd_ee21100 = {  "ee21100", // class name
  bases_ee21100, 4,
  &(vtc_ee21100[0]), // expected_vtbl_contents
  &(vtt_ee21100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31100  : virtual dd1100 {
  int e;
  virtual void  foo(); // _ZN7ee311003fooEv
  ~ee31100(); // tgen
  ee31100(); // tgen
};
//SIG(1 ee31100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee31100 ::foo(){vfunc_called(this, "_ZN7ee311003fooEv");}
ee31100 ::~ee31100(){ note_dtor("ee31100", this);} // tgen
ee31100 ::ee31100(){ note_ctor("ee31100", this);} // tgen

static void Test_ee31100()
{
  extern Class_Descriptor cd_ee31100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31100, buf);
    ee31100 *dp, &lv = *(dp=new (buf) ee31100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee31100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee31100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(32,16), "ee31100");
    check_base_class_offset(lv, (dd1100*), ABISELECT(16,8), "ee31100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31100.e");
    test_class_info(&lv, &cd_ee31100);
    dp->~ee31100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31100(Test_ee31100, "ee31100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31100C1Ev();
extern void _ZN7ee31100D1Ev();
Name_Map name_map_ee31100[] = {
  NSPAIR(_ZN7ee31100C1Ev),
  NSPAIR(_ZN7ee31100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee31100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31100[];
extern void _ZN7ee311003fooEv();
static  VTBL_ENTRY vtc_ee31100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31100[0]),
  (VTBL_ENTRY)&_ZN7ee311003fooEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31100[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31100[0]),
};
extern VTBL_ENTRY _ZTV7ee31100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee31100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee31100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee31100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee31100[] = {
  {&(_ZTV7ee31100[5]),  5,13},
  {&(_ZTV7ee31100[10]),  10,13},
  {&(_ZTV7ee31100[13]),  13,13},
  {&(_tg__ZTV6dd1100__7ee31100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee31100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee31100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee31100[];
extern  VTBL_ENTRY _ZTV7ee31100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31100[];
Class_Descriptor cd_ee31100 = {  "ee31100", // class name
  bases_ee31100, 4,
  &(vtc_ee31100[0]), // expected_vtbl_contents
  &(vtt_ee31100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31100),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41100  : dd1100 {
  int e;
  virtual void  bar(); // _ZN7ee411003barEv
  ~ee41100(); // tgen
  ee41100(); // tgen
};
//SIG(1 ee41100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee41100 ::bar(){vfunc_called(this, "_ZN7ee411003barEv");}
ee41100 ::~ee41100(){ note_dtor("ee41100", this);} // tgen
ee41100 ::ee41100(){ note_ctor("ee41100", this);} // tgen

static void Test_ee41100()
{
  extern Class_Descriptor cd_ee41100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41100, buf);
    ee41100 *dp, &lv = *(dp=new (buf) ee41100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee41100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee41100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(16,12), "ee41100");
    check_base_class_offset(lv, (dd1100*), 0, "ee41100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41100.e");
    test_class_info(&lv, &cd_ee41100);
    dp->~ee41100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41100(Test_ee41100, "ee41100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41100C1Ev();
extern void _ZN7ee41100D1Ev();
Name_Map name_map_ee41100[] = {
  NSPAIR(_ZN7ee41100C1Ev),
  NSPAIR(_ZN7ee41100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee41100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41100[];
extern void _ZN7ee411003barEv();
static  VTBL_ENTRY vtc_ee41100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41100[0]),
  (VTBL_ENTRY)&_ZN7ee411003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41100[0]),
};
extern VTBL_ENTRY _ZTV7ee41100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee41100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee41100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee41100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee41100[] = {
  {&(_ZTV7ee41100[4]),  4,8},
  {&(_tg__ZTV6dd1100__7ee41100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee41100[3]),  3,3},
  {&(_ZTV7ee41100[8]),  8,8},
  {&(_tg__ZTV5cc100__7ee41100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee41100[];
extern  VTBL_ENTRY _ZTV7ee41100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41100[];
Class_Descriptor cd_ee41100 = {  "ee41100", // class name
  bases_ee41100, 4,
  &(vtc_ee41100[0]), // expected_vtbl_contents
  &(vtt_ee41100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51100  : virtual dd1100 {
  int e;
  virtual void  bar(); // _ZN7ee511003barEv
  ~ee51100(); // tgen
  ee51100(); // tgen
};
//SIG(1 ee51100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 Fi}


void  ee51100 ::bar(){vfunc_called(this, "_ZN7ee511003barEv");}
ee51100 ::~ee51100(){ note_dtor("ee51100", this);} // tgen
ee51100 ::ee51100(){ note_ctor("ee51100", this);} // tgen

static void Test_ee51100()
{
  extern Class_Descriptor cd_ee51100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51100, buf);
    ee51100 *dp, &lv = *(dp=new (buf) ee51100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee51100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee51100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(32,16), "ee51100");
    check_base_class_offset(lv, (dd1100*), ABISELECT(16,8), "ee51100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51100.e");
    test_class_info(&lv, &cd_ee51100);
    dp->~ee51100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51100(Test_ee51100, "ee51100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51100C1Ev();
extern void _ZN7ee51100D1Ev();
Name_Map name_map_ee51100[] = {
  NSPAIR(_ZN7ee51100C1Ev),
  NSPAIR(_ZN7ee51100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee51100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51100[];
extern void _ZN7ee511003barEv();
static  VTBL_ENTRY vtc_ee51100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51100[0]),
  (VTBL_ENTRY)&_ZN7ee511003barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51100[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51100[0]),
};
extern VTBL_ENTRY _ZTV7ee51100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee51100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee51100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee51100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee51100[] = {
  {&(_ZTV7ee51100[5]),  5,13},
  {&(_ZTV7ee51100[10]),  10,13},
  {&(_ZTV7ee51100[13]),  13,13},
  {&(_tg__ZTV6dd1100__7ee51100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee51100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee51100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee51100[];
extern  VTBL_ENTRY _ZTV7ee51100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51100[];
Class_Descriptor cd_ee51100 = {  "ee51100", // class name
  bases_ee51100, 4,
  &(vtc_ee51100[0]), // expected_vtbl_contents
  &(vtt_ee51100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51100),13, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61100  : dd1100 {
  int e;
  virtual void  foo(); // _ZN7ee611003fooEv
  virtual void  bar(); // _ZN7ee611003barEv
  ~ee61100(); // tgen
  ee61100(); // tgen
};
//SIG(1 ee61100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee61100 ::foo(){vfunc_called(this, "_ZN7ee611003fooEv");}
void  ee61100 ::bar(){vfunc_called(this, "_ZN7ee611003barEv");}
ee61100 ::~ee61100(){ note_dtor("ee61100", this);} // tgen
ee61100 ::ee61100(){ note_ctor("ee61100", this);} // tgen

static void Test_ee61100()
{
  extern Class_Descriptor cd_ee61100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61100, buf);
    ee61100 *dp, &lv = *(dp=new (buf) ee61100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee61100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee61100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(16,12), "ee61100");
    check_base_class_offset(lv, (dd1100*), 0, "ee61100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61100.e");
    test_class_info(&lv, &cd_ee61100);
    dp->~ee61100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61100(Test_ee61100, "ee61100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61100C1Ev();
extern void _ZN7ee61100D1Ev();
Name_Map name_map_ee61100[] = {
  NSPAIR(_ZN7ee61100C1Ev),
  NSPAIR(_ZN7ee61100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee61100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61100[];
extern void _ZN7ee611003fooEv();
extern void _ZN7ee611003barEv();
static  VTBL_ENTRY vtc_ee61100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61100[0]),
  (VTBL_ENTRY)&_ZN7ee611003fooEv,
  (VTBL_ENTRY)&_ZN7ee611003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61100[0]),
};
extern VTBL_ENTRY _ZTV7ee61100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee61100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee61100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee61100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee61100[] = {
  {&(_ZTV7ee61100[4]),  4,9},
  {&(_tg__ZTV6dd1100__7ee61100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee61100[3]),  3,3},
  {&(_ZTV7ee61100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee61100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee61100[];
extern  VTBL_ENTRY _ZTV7ee61100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61100[];
Class_Descriptor cd_ee61100 = {  "ee61100", // class name
  bases_ee61100, 4,
  &(vtc_ee61100[0]), // expected_vtbl_contents
  &(vtt_ee61100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71100  : virtual dd1100 {
  int e;
  virtual void  foo(); // _ZN7ee711003fooEv
  virtual void  bar(); // _ZN7ee711003barEv
  ~ee71100(); // tgen
  ee71100(); // tgen
};
//SIG(1 ee71100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} Fi} v1 v2 Fi}


void  ee71100 ::foo(){vfunc_called(this, "_ZN7ee711003fooEv");}
void  ee71100 ::bar(){vfunc_called(this, "_ZN7ee711003barEv");}
ee71100 ::~ee71100(){ note_dtor("ee71100", this);} // tgen
ee71100 ::ee71100(){ note_ctor("ee71100", this);} // tgen

static void Test_ee71100()
{
  extern Class_Descriptor cd_ee71100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71100, buf);
    ee71100 *dp, &lv = *(dp=new (buf) ee71100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee71100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee71100");
    check_base_class_offset(lv, (cc100*)(dd1100*), ABISELECT(32,16), "ee71100");
    check_base_class_offset(lv, (dd1100*), ABISELECT(16,8), "ee71100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71100.e");
    test_class_info(&lv, &cd_ee71100);
    dp->~ee71100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71100(Test_ee71100, "ee71100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71100C1Ev();
extern void _ZN7ee71100D1Ev();
Name_Map name_map_ee71100[] = {
  NSPAIR(_ZN7ee71100C1Ev),
  NSPAIR(_ZN7ee71100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd1100;
extern VTBL_ENTRY _ZTI6dd1100[];
extern  VTBL_ENTRY _ZTV6dd1100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1100[];
static Base_Class bases_ee71100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1100,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71100[];
extern void _ZN7ee711003fooEv();
extern void _ZN7ee711003barEv();
static  VTBL_ENTRY vtc_ee71100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71100[0]),
  (VTBL_ENTRY)&_ZN7ee711003fooEv,
  (VTBL_ENTRY)&_ZN7ee711003barEv,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71100[0]),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71100[0]),
};
extern VTBL_ENTRY _ZTV7ee71100[];
static  VTBL_ENTRY _tg__ZTV6dd1100__7ee71100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd1100__7ee71100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee71100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee71100[] = {
  {&(_ZTV7ee71100[5]),  5,14},
  {&(_ZTV7ee71100[11]),  11,14},
  {&(_ZTV7ee71100[14]),  14,14},
  {&(_tg__ZTV6dd1100__7ee71100[4]),  4,4},
  {&(_tg__ZTV5cc100__6dd1100__7ee71100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee71100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee71100[];
extern  VTBL_ENTRY _ZTV7ee71100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71100[];
Class_Descriptor cd_ee71100 = {  "ee71100", // class name
  bases_ee71100, 4,
  &(vtc_ee71100[0]), // expected_vtbl_contents
  &(vtt_ee71100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71100),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2100  : cc100 {
  int d;
  virtual void  foo(); // _ZN6dd21003fooEv
  ~dd2100(); // tgen
  dd2100(); // tgen
};
//SIG(-1 dd2100) C1{ BC2{ VBC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd2100 ::foo(){vfunc_called(this, "_ZN6dd21003fooEv");}
dd2100 ::~dd2100(){ note_dtor("dd2100", this);} // tgen
dd2100 ::dd2100(){ note_ctor("dd2100", this);} // tgen

static void Test_dd2100()
{
  extern Class_Descriptor cd_dd2100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2100, buf);
    dd2100 *dp, &lv = *(dp=new (buf) dd2100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(16,12), "dd2100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(16,12), "dd2100");
    check_base_class_offset(lv, (cc100*), 0, "dd2100");
    check_field_offset(lv, d, ABISELECT(12,8), "dd2100.d");
    test_class_info(&lv, &cd_dd2100);
    dp->~dd2100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2100(Test_dd2100, "dd2100", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2100C1Ev();
extern void _ZN6dd2100D1Ev();
Name_Map name_map_dd2100[] = {
  NSPAIR(_ZN6dd2100C1Ev),
  NSPAIR(_ZN6dd2100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd2100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY vtc_dd2100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
extern VTBL_ENTRY _ZTV6dd2100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd2100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd2100[] = {
  {&(_ZTV6dd2100[3]),  3,4},
  {&(_tg__ZTV5cc100__6dd2100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
Class_Descriptor cd_dd2100 = {  "dd2100", // class name
  bases_dd2100, 3,
  &(vtc_dd2100[0]), // expected_vtbl_contents
  &(vtt_dd2100[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd2100),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02100  : dd2100 {
  int e;
  ~ee02100(); // tgen
  ee02100(); // tgen
};
//SIG(1 ee02100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee02100 ::~ee02100(){ note_dtor("ee02100", this);} // tgen
ee02100 ::ee02100(){ note_ctor("ee02100", this);} // tgen

static void Test_ee02100()
{
  extern Class_Descriptor cd_ee02100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02100, buf);
    ee02100 *dp, &lv = *(dp=new (buf) ee02100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee02100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(20,16), "ee02100");
    check_base_class_offset(lv, (cc100*)(dd2100*), 0, "ee02100");
    check_base_class_offset(lv, (dd2100*), 0, "ee02100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee02100.e");
    test_class_info(&lv, &cd_ee02100);
    dp->~ee02100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02100(Test_ee02100, "ee02100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02100C1Ev();
extern void _ZN7ee02100D1Ev();
Name_Map name_map_ee02100[] = {
  NSPAIR(_ZN7ee02100C1Ev),
  NSPAIR(_ZN7ee02100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee02100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY vtc_ee02100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee02100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
extern VTBL_ENTRY _ZTV7ee02100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee02100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee02100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee02100[] = {
  {&(_ZTV7ee02100[3]),  3,4},
  {&(_tg__ZTV6dd2100__7ee02100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee02100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee02100[];
extern  VTBL_ENTRY _ZTV7ee02100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee02100[];
Class_Descriptor cd_ee02100 = {  "ee02100", // class name
  bases_ee02100, 4,
  &(vtc_ee02100[0]), // expected_vtbl_contents
  &(vtt_ee02100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee02100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12100  : virtual dd2100 {
  int e;
  ~ee12100(); // tgen
  ee12100(); // tgen
};
//SIG(1 ee12100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee12100 ::~ee12100(){ note_dtor("ee12100", this);} // tgen
ee12100 ::ee12100(){ note_ctor("ee12100", this);} // tgen

static void Test_ee12100()
{
  extern Class_Descriptor cd_ee12100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12100, buf);
    ee12100 *dp, &lv = *(dp=new (buf) ee12100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee12100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(32,20), "ee12100");
    check_base_class_offset(lv, (cc100*)(dd2100*), ABISELECT(16,8), "ee12100");
    check_base_class_offset(lv, (dd2100*), ABISELECT(16,8), "ee12100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12100.e");
    test_class_info(&lv, &cd_ee12100);
    dp->~ee12100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12100(Test_ee12100, "ee12100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12100C1Ev();
extern void _ZN7ee12100D1Ev();
Name_Map name_map_ee12100[] = {
  NSPAIR(_ZN7ee12100C1Ev),
  NSPAIR(_ZN7ee12100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee12100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY vtc_ee12100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12100[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
extern VTBL_ENTRY _ZTV7ee12100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee12100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee12100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee12100[] = {
  {&(_ZTV7ee12100[4]),  4,9},
  {&(_ZTV7ee12100[8]),  8,9},
  {&(_tg__ZTV6dd2100__7ee12100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee12100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee12100[];
extern  VTBL_ENTRY _ZTV7ee12100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12100[];
Class_Descriptor cd_ee12100 = {  "ee12100", // class name
  bases_ee12100, 4,
  &(vtc_ee12100[0]), // expected_vtbl_contents
  &(vtt_ee12100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22100  : dd2100 {
  int e;
  virtual void  foo(); // _ZN7ee221003fooEv
  ~ee22100(); // tgen
  ee22100(); // tgen
};
//SIG(1 ee22100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee22100 ::foo(){vfunc_called(this, "_ZN7ee221003fooEv");}
ee22100 ::~ee22100(){ note_dtor("ee22100", this);} // tgen
ee22100 ::ee22100(){ note_ctor("ee22100", this);} // tgen

static void Test_ee22100()
{
  extern Class_Descriptor cd_ee22100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22100, buf);
    ee22100 *dp, &lv = *(dp=new (buf) ee22100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee22100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(20,16), "ee22100");
    check_base_class_offset(lv, (cc100*)(dd2100*), 0, "ee22100");
    check_base_class_offset(lv, (dd2100*), 0, "ee22100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee22100.e");
    test_class_info(&lv, &cd_ee22100);
    dp->~ee22100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22100(Test_ee22100, "ee22100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22100C1Ev();
extern void _ZN7ee22100D1Ev();
Name_Map name_map_ee22100[] = {
  NSPAIR(_ZN7ee22100C1Ev),
  NSPAIR(_ZN7ee22100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee22100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22100[];
extern void _ZN7ee221003fooEv();
static  VTBL_ENTRY vtc_ee22100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee22100[0]),
  (VTBL_ENTRY)&_ZN7ee221003fooEv,
};
extern VTBL_ENTRY _ZTV7ee22100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee22100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee22100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee22100[] = {
  {&(_ZTV7ee22100[3]),  3,4},
  {&(_tg__ZTV6dd2100__7ee22100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee22100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee22100[];
extern  VTBL_ENTRY _ZTV7ee22100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee22100[];
Class_Descriptor cd_ee22100 = {  "ee22100", // class name
  bases_ee22100, 4,
  &(vtc_ee22100[0]), // expected_vtbl_contents
  &(vtt_ee22100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee22100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32100  : virtual dd2100 {
  int e;
  virtual void  foo(); // _ZN7ee321003fooEv
  ~ee32100(); // tgen
  ee32100(); // tgen
};
//SIG(1 ee32100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee32100 ::foo(){vfunc_called(this, "_ZN7ee321003fooEv");}
ee32100 ::~ee32100(){ note_dtor("ee32100", this);} // tgen
ee32100 ::ee32100(){ note_ctor("ee32100", this);} // tgen

static void Test_ee32100()
{
  extern Class_Descriptor cd_ee32100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32100, buf);
    ee32100 *dp, &lv = *(dp=new (buf) ee32100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee32100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(32,20), "ee32100");
    check_base_class_offset(lv, (cc100*)(dd2100*), ABISELECT(16,8), "ee32100");
    check_base_class_offset(lv, (dd2100*), ABISELECT(16,8), "ee32100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32100.e");
    test_class_info(&lv, &cd_ee32100);
    dp->~ee32100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32100(Test_ee32100, "ee32100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32100C1Ev();
extern void _ZN7ee32100D1Ev();
Name_Map name_map_ee32100[] = {
  NSPAIR(_ZN7ee32100C1Ev),
  NSPAIR(_ZN7ee32100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee32100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32100[];
extern void _ZN7ee321003fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee321003fooEv,_ZTv0_n16_N7ee321003fooEv)();
extern void ABISELECT(_ZThn16_N7ee321003fooEv,_ZThn8_N7ee321003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32100[0]),
  (VTBL_ENTRY)&_ZN7ee321003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee321003fooEv,_ZTv0_n16_N7ee321003fooEv),
};
extern VTBL_ENTRY _ZTV7ee32100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee32100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee32100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee32100[] = {
  {&(_ZTV7ee32100[4]),  4,10},
  {&(_ZTV7ee32100[9]),  9,10},
  {&(_tg__ZTV6dd2100__7ee32100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee32100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee32100[];
extern  VTBL_ENTRY _ZTV7ee32100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32100[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee321003fooEv,_ZTv0_n16_N7ee321003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee321003fooEv,_ZThn8_N7ee321003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32100 = {  "ee32100", // class name
  bases_ee32100, 4,
  &(vtc_ee32100[0]), // expected_vtbl_contents
  &(vtt_ee32100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32100),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42100  : dd2100 {
  int e;
  virtual void  bar(); // _ZN7ee421003barEv
  ~ee42100(); // tgen
  ee42100(); // tgen
};
//SIG(1 ee42100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee42100 ::bar(){vfunc_called(this, "_ZN7ee421003barEv");}
ee42100 ::~ee42100(){ note_dtor("ee42100", this);} // tgen
ee42100 ::ee42100(){ note_ctor("ee42100", this);} // tgen

static void Test_ee42100()
{
  extern Class_Descriptor cd_ee42100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42100, buf);
    ee42100 *dp, &lv = *(dp=new (buf) ee42100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee42100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(20,16), "ee42100");
    check_base_class_offset(lv, (cc100*)(dd2100*), 0, "ee42100");
    check_base_class_offset(lv, (dd2100*), 0, "ee42100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee42100.e");
    test_class_info(&lv, &cd_ee42100);
    dp->~ee42100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42100(Test_ee42100, "ee42100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42100C1Ev();
extern void _ZN7ee42100D1Ev();
Name_Map name_map_ee42100[] = {
  NSPAIR(_ZN7ee42100C1Ev),
  NSPAIR(_ZN7ee42100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee42100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42100[];
extern void _ZN6dd21003fooEv();
extern void _ZN7ee421003barEv();
static  VTBL_ENTRY vtc_ee42100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee42100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
  (VTBL_ENTRY)&_ZN7ee421003barEv,
};
extern VTBL_ENTRY _ZTV7ee42100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee42100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee42100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee42100[] = {
  {&(_ZTV7ee42100[3]),  3,5},
  {&(_tg__ZTV6dd2100__7ee42100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee42100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee42100[];
extern  VTBL_ENTRY _ZTV7ee42100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee42100[];
Class_Descriptor cd_ee42100 = {  "ee42100", // class name
  bases_ee42100, 4,
  &(vtc_ee42100[0]), // expected_vtbl_contents
  &(vtt_ee42100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee42100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52100  : virtual dd2100 {
  int e;
  virtual void  bar(); // _ZN7ee521003barEv
  ~ee52100(); // tgen
  ee52100(); // tgen
};
//SIG(1 ee52100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee52100 ::bar(){vfunc_called(this, "_ZN7ee521003barEv");}
ee52100 ::~ee52100(){ note_dtor("ee52100", this);} // tgen
ee52100 ::ee52100(){ note_ctor("ee52100", this);} // tgen

static void Test_ee52100()
{
  extern Class_Descriptor cd_ee52100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52100, buf);
    ee52100 *dp, &lv = *(dp=new (buf) ee52100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee52100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(32,20), "ee52100");
    check_base_class_offset(lv, (cc100*)(dd2100*), ABISELECT(16,8), "ee52100");
    check_base_class_offset(lv, (dd2100*), ABISELECT(16,8), "ee52100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52100.e");
    test_class_info(&lv, &cd_ee52100);
    dp->~ee52100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52100(Test_ee52100, "ee52100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52100C1Ev();
extern void _ZN7ee52100D1Ev();
Name_Map name_map_ee52100[] = {
  NSPAIR(_ZN7ee52100C1Ev),
  NSPAIR(_ZN7ee52100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee52100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52100[];
extern void _ZN7ee521003barEv();
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY vtc_ee52100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52100[0]),
  (VTBL_ENTRY)&_ZN7ee521003barEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
extern VTBL_ENTRY _ZTV7ee52100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee52100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee52100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee52100[] = {
  {&(_ZTV7ee52100[4]),  4,10},
  {&(_ZTV7ee52100[9]),  9,10},
  {&(_tg__ZTV6dd2100__7ee52100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee52100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee52100[];
extern  VTBL_ENTRY _ZTV7ee52100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52100[];
Class_Descriptor cd_ee52100 = {  "ee52100", // class name
  bases_ee52100, 4,
  &(vtc_ee52100[0]), // expected_vtbl_contents
  &(vtt_ee52100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52100),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62100  : dd2100 {
  int e;
  virtual void  foo(); // _ZN7ee621003fooEv
  virtual void  bar(); // _ZN7ee621003barEv
  ~ee62100(); // tgen
  ee62100(); // tgen
};
//SIG(1 ee62100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee62100 ::foo(){vfunc_called(this, "_ZN7ee621003fooEv");}
void  ee62100 ::bar(){vfunc_called(this, "_ZN7ee621003barEv");}
ee62100 ::~ee62100(){ note_dtor("ee62100", this);} // tgen
ee62100 ::ee62100(){ note_ctor("ee62100", this);} // tgen

static void Test_ee62100()
{
  extern Class_Descriptor cd_ee62100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62100, buf);
    ee62100 *dp, &lv = *(dp=new (buf) ee62100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee62100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(20,16), "ee62100");
    check_base_class_offset(lv, (cc100*)(dd2100*), 0, "ee62100");
    check_base_class_offset(lv, (dd2100*), 0, "ee62100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee62100.e");
    test_class_info(&lv, &cd_ee62100);
    dp->~ee62100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62100(Test_ee62100, "ee62100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62100C1Ev();
extern void _ZN7ee62100D1Ev();
Name_Map name_map_ee62100[] = {
  NSPAIR(_ZN7ee62100C1Ev),
  NSPAIR(_ZN7ee62100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee62100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62100[];
extern void _ZN7ee621003fooEv();
extern void _ZN7ee621003barEv();
static  VTBL_ENTRY vtc_ee62100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee62100[0]),
  (VTBL_ENTRY)&_ZN7ee621003fooEv,
  (VTBL_ENTRY)&_ZN7ee621003barEv,
};
extern VTBL_ENTRY _ZTV7ee62100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee62100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee62100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee62100[] = {
  {&(_ZTV7ee62100[3]),  3,5},
  {&(_tg__ZTV6dd2100__7ee62100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee62100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee62100[];
extern  VTBL_ENTRY _ZTV7ee62100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee62100[];
Class_Descriptor cd_ee62100 = {  "ee62100", // class name
  bases_ee62100, 4,
  &(vtc_ee62100[0]), // expected_vtbl_contents
  &(vtt_ee62100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee62100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72100  : virtual dd2100 {
  int e;
  virtual void  foo(); // _ZN7ee721003fooEv
  virtual void  bar(); // _ZN7ee721003barEv
  ~ee72100(); // tgen
  ee72100(); // tgen
};
//SIG(1 ee72100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee72100 ::foo(){vfunc_called(this, "_ZN7ee721003fooEv");}
void  ee72100 ::bar(){vfunc_called(this, "_ZN7ee721003barEv");}
ee72100 ::~ee72100(){ note_dtor("ee72100", this);} // tgen
ee72100 ::ee72100(){ note_ctor("ee72100", this);} // tgen

static void Test_ee72100()
{
  extern Class_Descriptor cd_ee72100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72100, buf);
    ee72100 *dp, &lv = *(dp=new (buf) ee72100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee72100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd2100*), ABISELECT(32,20), "ee72100");
    check_base_class_offset(lv, (cc100*)(dd2100*), ABISELECT(16,8), "ee72100");
    check_base_class_offset(lv, (dd2100*), ABISELECT(16,8), "ee72100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72100.e");
    test_class_info(&lv, &cd_ee72100);
    dp->~ee72100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72100(Test_ee72100, "ee72100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72100C1Ev();
extern void _ZN7ee72100D1Ev();
Name_Map name_map_ee72100[] = {
  NSPAIR(_ZN7ee72100C1Ev),
  NSPAIR(_ZN7ee72100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd2100;
extern VTBL_ENTRY _ZTI6dd2100[];
extern  VTBL_ENTRY _ZTV6dd2100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd2100[];
static Base_Class bases_ee72100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72100[];
extern void _ZN7ee721003fooEv();
extern void _ZN7ee721003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee721003fooEv,_ZTv0_n16_N7ee721003fooEv)();
extern void ABISELECT(_ZThn16_N7ee721003fooEv,_ZThn8_N7ee721003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72100[0]),
  (VTBL_ENTRY)&_ZN7ee721003fooEv,
  (VTBL_ENTRY)&_ZN7ee721003barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee721003fooEv,_ZTv0_n16_N7ee721003fooEv),
};
extern VTBL_ENTRY _ZTV7ee72100[];
extern void _ZN6dd21003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd2100__7ee72100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd2100[0]),
  (VTBL_ENTRY)&_ZN6dd21003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd2100__7ee72100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee72100[] = {
  {&(_ZTV7ee72100[4]),  4,11},
  {&(_ZTV7ee72100[10]),  10,11},
  {&(_tg__ZTV6dd2100__7ee72100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd2100__7ee72100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee72100[];
extern  VTBL_ENTRY _ZTV7ee72100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72100[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee721003fooEv,_ZTv0_n16_N7ee721003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee721003fooEv,_ZThn8_N7ee721003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72100 = {  "ee72100", // class name
  bases_ee72100, 4,
  &(vtc_ee72100[0]), // expected_vtbl_contents
  &(vtt_ee72100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72100),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3100  : virtual cc100 {
  int d;
  virtual void  foo(); // _ZN6dd31003fooEv
  ~dd3100(); // tgen
  dd3100(); // tgen
};
//SIG(-1 dd3100) C1{ VBC2{ VBC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd3100 ::foo(){vfunc_called(this, "_ZN6dd31003fooEv");}
dd3100 ::~dd3100(){ note_dtor("dd3100", this);} // tgen
dd3100 ::dd3100(){ note_ctor("dd3100", this);} // tgen

static void Test_dd3100()
{
  extern Class_Descriptor cd_dd3100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3100, buf);
    dd3100 *dp, &lv = *(dp=new (buf) dd3100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,16), "dd3100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,16), "dd3100");
    check_base_class_offset(lv, (cc100*), ABISELECT(16,8), "dd3100");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3100.d");
    test_class_info(&lv, &cd_dd3100);
    dp->~dd3100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3100(Test_dd3100, "dd3100", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3100C1Ev();
extern void _ZN6dd3100D1Ev();
Name_Map name_map_dd3100[] = {
  NSPAIR(_ZN6dd3100C1Ev),
  NSPAIR(_ZN6dd3100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd3100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY vtc_dd3100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
extern VTBL_ENTRY _ZTV6dd3100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd3100[] = {
  {&(_ZTV6dd3100[4]),  4,8},
  {&(_ZTV6dd3100[8]),  8,8},
  {&(_tg__ZTV5cc100__6dd3100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
Class_Descriptor cd_dd3100 = {  "dd3100", // class name
  bases_dd3100, 3,
  &(vtc_dd3100[0]), // expected_vtbl_contents
  &(vtt_dd3100[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3100),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03100  : dd3100 {
  int e;
  ~ee03100(); // tgen
  ee03100(); // tgen
};
//SIG(1 ee03100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee03100 ::~ee03100(){ note_dtor("ee03100", this);} // tgen
ee03100 ::ee03100(){ note_ctor("ee03100", this);} // tgen

static void Test_ee03100()
{
  extern Class_Descriptor cd_ee03100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03100, buf);
    ee03100 *dp, &lv = *(dp=new (buf) ee03100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee03100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee03100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(16,12), "ee03100");
    check_base_class_offset(lv, (dd3100*), 0, "ee03100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03100.e");
    test_class_info(&lv, &cd_ee03100);
    dp->~ee03100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03100(Test_ee03100, "ee03100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03100C1Ev();
extern void _ZN7ee03100D1Ev();
Name_Map name_map_ee03100[] = {
  NSPAIR(_ZN7ee03100C1Ev),
  NSPAIR(_ZN7ee03100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee03100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY vtc_ee03100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03100[0]),
};
extern VTBL_ENTRY _ZTV7ee03100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee03100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee03100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee03100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee03100[] = {
  {&(_ZTV7ee03100[4]),  4,8},
  {&(_tg__ZTV6dd3100__7ee03100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee03100[3]),  3,3},
  {&(_ZTV7ee03100[8]),  8,8},
  {&(_tg__ZTV5cc100__7ee03100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee03100[];
extern  VTBL_ENTRY _ZTV7ee03100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03100[];
Class_Descriptor cd_ee03100 = {  "ee03100", // class name
  bases_ee03100, 4,
  &(vtc_ee03100[0]), // expected_vtbl_contents
  &(vtt_ee03100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13100  : virtual dd3100 {
  int e;
  ~ee13100(); // tgen
  ee13100(); // tgen
};
//SIG(1 ee13100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee13100 ::~ee13100(){ note_dtor("ee13100", this);} // tgen
ee13100 ::ee13100(){ note_ctor("ee13100", this);} // tgen

static void Test_ee13100()
{
  extern Class_Descriptor cd_ee13100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13100, buf);
    ee13100 *dp, &lv = *(dp=new (buf) ee13100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee13100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee13100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(32,16), "ee13100");
    check_base_class_offset(lv, (dd3100*), ABISELECT(16,8), "ee13100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13100.e");
    test_class_info(&lv, &cd_ee13100);
    dp->~ee13100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13100(Test_ee13100, "ee13100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13100C1Ev();
extern void _ZN7ee13100D1Ev();
Name_Map name_map_ee13100[] = {
  NSPAIR(_ZN7ee13100C1Ev),
  NSPAIR(_ZN7ee13100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee13100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY vtc_ee13100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13100[0]),
  0,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13100[0]),
};
extern VTBL_ENTRY _ZTV7ee13100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee13100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee13100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee13100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee13100[] = {
  {&(_ZTV7ee13100[5]),  5,14},
  {&(_ZTV7ee13100[10]),  10,14},
  {&(_ZTV7ee13100[14]),  14,14},
  {&(_tg__ZTV6dd3100__7ee13100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee13100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee13100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee13100[];
extern  VTBL_ENTRY _ZTV7ee13100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13100[];
Class_Descriptor cd_ee13100 = {  "ee13100", // class name
  bases_ee13100, 4,
  &(vtc_ee13100[0]), // expected_vtbl_contents
  &(vtt_ee13100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13100),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23100  : dd3100 {
  int e;
  virtual void  foo(); // _ZN7ee231003fooEv
  ~ee23100(); // tgen
  ee23100(); // tgen
};
//SIG(1 ee23100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee23100 ::foo(){vfunc_called(this, "_ZN7ee231003fooEv");}
ee23100 ::~ee23100(){ note_dtor("ee23100", this);} // tgen
ee23100 ::ee23100(){ note_ctor("ee23100", this);} // tgen

static void Test_ee23100()
{
  extern Class_Descriptor cd_ee23100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23100, buf);
    ee23100 *dp, &lv = *(dp=new (buf) ee23100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee23100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee23100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(16,12), "ee23100");
    check_base_class_offset(lv, (dd3100*), 0, "ee23100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23100.e");
    test_class_info(&lv, &cd_ee23100);
    dp->~ee23100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23100(Test_ee23100, "ee23100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23100C1Ev();
extern void _ZN7ee23100D1Ev();
Name_Map name_map_ee23100[] = {
  NSPAIR(_ZN7ee23100C1Ev),
  NSPAIR(_ZN7ee23100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee23100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23100[];
extern void _ZN7ee231003fooEv();
static  VTBL_ENTRY vtc_ee23100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23100[0]),
  (VTBL_ENTRY)&_ZN7ee231003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23100[0]),
};
extern VTBL_ENTRY _ZTV7ee23100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee23100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee23100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee23100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee23100[] = {
  {&(_ZTV7ee23100[4]),  4,8},
  {&(_tg__ZTV6dd3100__7ee23100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee23100[3]),  3,3},
  {&(_ZTV7ee23100[8]),  8,8},
  {&(_tg__ZTV5cc100__7ee23100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee23100[];
extern  VTBL_ENTRY _ZTV7ee23100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23100[];
Class_Descriptor cd_ee23100 = {  "ee23100", // class name
  bases_ee23100, 4,
  &(vtc_ee23100[0]), // expected_vtbl_contents
  &(vtt_ee23100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33100  : virtual dd3100 {
  int e;
  virtual void  foo(); // _ZN7ee331003fooEv
  ~ee33100(); // tgen
  ee33100(); // tgen
};
//SIG(1 ee33100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee33100 ::foo(){vfunc_called(this, "_ZN7ee331003fooEv");}
ee33100 ::~ee33100(){ note_dtor("ee33100", this);} // tgen
ee33100 ::ee33100(){ note_ctor("ee33100", this);} // tgen

static void Test_ee33100()
{
  extern Class_Descriptor cd_ee33100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33100, buf);
    ee33100 *dp, &lv = *(dp=new (buf) ee33100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee33100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee33100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(32,16), "ee33100");
    check_base_class_offset(lv, (dd3100*), ABISELECT(16,8), "ee33100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33100.e");
    test_class_info(&lv, &cd_ee33100);
    dp->~ee33100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33100(Test_ee33100, "ee33100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33100C1Ev();
extern void _ZN7ee33100D1Ev();
Name_Map name_map_ee33100[] = {
  NSPAIR(_ZN7ee33100C1Ev),
  NSPAIR(_ZN7ee33100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee33100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33100[];
extern void _ZN7ee331003fooEv();
extern void ABISELECT(_ZTv0_n40_N7ee331003fooEv,_ZTv0_n20_N7ee331003fooEv)();
extern void ABISELECT(_ZThn16_N7ee331003fooEv,_ZThn8_N7ee331003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33100[0]),
  (VTBL_ENTRY)&_ZN7ee331003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee331003fooEv,_ZTv0_n20_N7ee331003fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33100[0]),
};
extern VTBL_ENTRY _ZTV7ee33100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee33100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee33100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee33100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee33100[] = {
  {&(_ZTV7ee33100[5]),  5,15},
  {&(_ZTV7ee33100[11]),  11,15},
  {&(_ZTV7ee33100[15]),  15,15},
  {&(_tg__ZTV6dd3100__7ee33100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee33100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee33100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee33100[];
extern  VTBL_ENTRY _ZTV7ee33100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33100[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee331003fooEv,_ZTv0_n20_N7ee331003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee331003fooEv,_ZThn8_N7ee331003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33100 = {  "ee33100", // class name
  bases_ee33100, 4,
  &(vtc_ee33100[0]), // expected_vtbl_contents
  &(vtt_ee33100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33100),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43100  : dd3100 {
  int e;
  virtual void  bar(); // _ZN7ee431003barEv
  ~ee43100(); // tgen
  ee43100(); // tgen
};
//SIG(1 ee43100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee43100 ::bar(){vfunc_called(this, "_ZN7ee431003barEv");}
ee43100 ::~ee43100(){ note_dtor("ee43100", this);} // tgen
ee43100 ::ee43100(){ note_ctor("ee43100", this);} // tgen

static void Test_ee43100()
{
  extern Class_Descriptor cd_ee43100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43100, buf);
    ee43100 *dp, &lv = *(dp=new (buf) ee43100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee43100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee43100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(16,12), "ee43100");
    check_base_class_offset(lv, (dd3100*), 0, "ee43100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43100.e");
    test_class_info(&lv, &cd_ee43100);
    dp->~ee43100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43100(Test_ee43100, "ee43100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43100C1Ev();
extern void _ZN7ee43100D1Ev();
Name_Map name_map_ee43100[] = {
  NSPAIR(_ZN7ee43100C1Ev),
  NSPAIR(_ZN7ee43100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee43100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43100[];
extern void _ZN6dd31003fooEv();
extern void _ZN7ee431003barEv();
static  VTBL_ENTRY vtc_ee43100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
  (VTBL_ENTRY)&_ZN7ee431003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43100[0]),
};
extern VTBL_ENTRY _ZTV7ee43100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee43100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee43100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee43100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee43100[] = {
  {&(_ZTV7ee43100[4]),  4,9},
  {&(_tg__ZTV6dd3100__7ee43100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee43100[3]),  3,3},
  {&(_ZTV7ee43100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee43100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee43100[];
extern  VTBL_ENTRY _ZTV7ee43100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43100[];
Class_Descriptor cd_ee43100 = {  "ee43100", // class name
  bases_ee43100, 4,
  &(vtc_ee43100[0]), // expected_vtbl_contents
  &(vtt_ee43100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53100  : virtual dd3100 {
  int e;
  virtual void  bar(); // _ZN7ee531003barEv
  ~ee53100(); // tgen
  ee53100(); // tgen
};
//SIG(1 ee53100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee53100 ::bar(){vfunc_called(this, "_ZN7ee531003barEv");}
ee53100 ::~ee53100(){ note_dtor("ee53100", this);} // tgen
ee53100 ::ee53100(){ note_ctor("ee53100", this);} // tgen

static void Test_ee53100()
{
  extern Class_Descriptor cd_ee53100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53100, buf);
    ee53100 *dp, &lv = *(dp=new (buf) ee53100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee53100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee53100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(32,16), "ee53100");
    check_base_class_offset(lv, (dd3100*), ABISELECT(16,8), "ee53100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53100.e");
    test_class_info(&lv, &cd_ee53100);
    dp->~ee53100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53100(Test_ee53100, "ee53100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53100C1Ev();
extern void _ZN7ee53100D1Ev();
Name_Map name_map_ee53100[] = {
  NSPAIR(_ZN7ee53100C1Ev),
  NSPAIR(_ZN7ee53100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee53100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53100[];
extern void _ZN7ee531003barEv();
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY vtc_ee53100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53100[0]),
  (VTBL_ENTRY)&_ZN7ee531003barEv,
  0,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53100[0]),
};
extern VTBL_ENTRY _ZTV7ee53100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee53100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee53100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee53100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee53100[] = {
  {&(_ZTV7ee53100[5]),  5,15},
  {&(_ZTV7ee53100[11]),  11,15},
  {&(_ZTV7ee53100[15]),  15,15},
  {&(_tg__ZTV6dd3100__7ee53100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee53100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee53100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee53100[];
extern  VTBL_ENTRY _ZTV7ee53100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53100[];
Class_Descriptor cd_ee53100 = {  "ee53100", // class name
  bases_ee53100, 4,
  &(vtc_ee53100[0]), // expected_vtbl_contents
  &(vtt_ee53100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53100),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63100  : dd3100 {
  int e;
  virtual void  foo(); // _ZN7ee631003fooEv
  virtual void  bar(); // _ZN7ee631003barEv
  ~ee63100(); // tgen
  ee63100(); // tgen
};
//SIG(1 ee63100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee63100 ::foo(){vfunc_called(this, "_ZN7ee631003fooEv");}
void  ee63100 ::bar(){vfunc_called(this, "_ZN7ee631003barEv");}
ee63100 ::~ee63100(){ note_dtor("ee63100", this);} // tgen
ee63100 ::ee63100(){ note_ctor("ee63100", this);} // tgen

static void Test_ee63100()
{
  extern Class_Descriptor cd_ee63100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63100, buf);
    ee63100 *dp, &lv = *(dp=new (buf) ee63100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee63100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee63100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(16,12), "ee63100");
    check_base_class_offset(lv, (dd3100*), 0, "ee63100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63100.e");
    test_class_info(&lv, &cd_ee63100);
    dp->~ee63100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63100(Test_ee63100, "ee63100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63100C1Ev();
extern void _ZN7ee63100D1Ev();
Name_Map name_map_ee63100[] = {
  NSPAIR(_ZN7ee63100C1Ev),
  NSPAIR(_ZN7ee63100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee63100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63100[];
extern void _ZN7ee631003fooEv();
extern void _ZN7ee631003barEv();
static  VTBL_ENTRY vtc_ee63100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63100[0]),
  (VTBL_ENTRY)&_ZN7ee631003fooEv,
  (VTBL_ENTRY)&_ZN7ee631003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63100[0]),
};
extern VTBL_ENTRY _ZTV7ee63100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee63100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee63100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee63100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee63100[] = {
  {&(_ZTV7ee63100[4]),  4,9},
  {&(_tg__ZTV6dd3100__7ee63100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee63100[3]),  3,3},
  {&(_ZTV7ee63100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee63100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee63100[];
extern  VTBL_ENTRY _ZTV7ee63100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63100[];
Class_Descriptor cd_ee63100 = {  "ee63100", // class name
  bases_ee63100, 4,
  &(vtc_ee63100[0]), // expected_vtbl_contents
  &(vtt_ee63100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73100  : virtual dd3100 {
  int e;
  virtual void  foo(); // _ZN7ee731003fooEv
  virtual void  bar(); // _ZN7ee731003barEv
  ~ee73100(); // tgen
  ee73100(); // tgen
};
//SIG(1 ee73100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 v2 Fi}


void  ee73100 ::foo(){vfunc_called(this, "_ZN7ee731003fooEv");}
void  ee73100 ::bar(){vfunc_called(this, "_ZN7ee731003barEv");}
ee73100 ::~ee73100(){ note_dtor("ee73100", this);} // tgen
ee73100 ::ee73100(){ note_ctor("ee73100", this);} // tgen

static void Test_ee73100()
{
  extern Class_Descriptor cd_ee73100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73100, buf);
    ee73100 *dp, &lv = *(dp=new (buf) ee73100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee73100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee73100");
    check_base_class_offset(lv, (cc100*)(dd3100*), ABISELECT(32,16), "ee73100");
    check_base_class_offset(lv, (dd3100*), ABISELECT(16,8), "ee73100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73100.e");
    test_class_info(&lv, &cd_ee73100);
    dp->~ee73100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73100(Test_ee73100, "ee73100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73100C1Ev();
extern void _ZN7ee73100D1Ev();
Name_Map name_map_ee73100[] = {
  NSPAIR(_ZN7ee73100C1Ev),
  NSPAIR(_ZN7ee73100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd3100;
extern VTBL_ENTRY _ZTI6dd3100[];
extern  VTBL_ENTRY _ZTV6dd3100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3100[];
static Base_Class bases_ee73100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3100,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73100[];
extern void _ZN7ee731003fooEv();
extern void _ZN7ee731003barEv();
extern void ABISELECT(_ZTv0_n40_N7ee731003fooEv,_ZTv0_n20_N7ee731003fooEv)();
extern void ABISELECT(_ZThn16_N7ee731003fooEv,_ZThn8_N7ee731003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73100[0]),
  (VTBL_ENTRY)&_ZN7ee731003fooEv,
  (VTBL_ENTRY)&_ZN7ee731003barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee731003fooEv,_ZTv0_n20_N7ee731003fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73100[0]),
};
extern VTBL_ENTRY _ZTV7ee73100[];
extern void _ZN6dd31003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3100__7ee73100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
  (VTBL_ENTRY)&_ZN6dd31003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd3100__7ee73100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee73100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee73100[] = {
  {&(_ZTV7ee73100[5]),  5,16},
  {&(_ZTV7ee73100[12]),  12,16},
  {&(_ZTV7ee73100[16]),  16,16},
  {&(_tg__ZTV6dd3100__7ee73100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd3100__7ee73100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee73100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee73100[];
extern  VTBL_ENTRY _ZTV7ee73100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73100[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee731003fooEv,_ZTv0_n20_N7ee731003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee731003fooEv,_ZThn8_N7ee731003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73100 = {  "ee73100", // class name
  bases_ee73100, 4,
  &(vtc_ee73100[0]), // expected_vtbl_contents
  &(vtt_ee73100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73100),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4100  : cc100 {
  int d;
  virtual void  bar(); // _ZN6dd41003barEv
  ~dd4100(); // tgen
  dd4100(); // tgen
};
//SIG(-1 dd4100) C1{ BC2{ VBC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd4100 ::bar(){vfunc_called(this, "_ZN6dd41003barEv");}
dd4100 ::~dd4100(){ note_dtor("dd4100", this);} // tgen
dd4100 ::dd4100(){ note_ctor("dd4100", this);} // tgen

static void Test_dd4100()
{
  extern Class_Descriptor cd_dd4100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4100, buf);
    dd4100 *dp, &lv = *(dp=new (buf) dd4100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(16,12), "dd4100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(16,12), "dd4100");
    check_base_class_offset(lv, (cc100*), 0, "dd4100");
    check_field_offset(lv, d, ABISELECT(12,8), "dd4100.d");
    test_class_info(&lv, &cd_dd4100);
    dp->~dd4100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4100(Test_dd4100, "dd4100", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4100C1Ev();
extern void _ZN6dd4100D1Ev();
Name_Map name_map_dd4100[] = {
  NSPAIR(_ZN6dd4100C1Ev),
  NSPAIR(_ZN6dd4100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd4100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY vtc_dd4100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
extern VTBL_ENTRY _ZTV6dd4100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd4100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd4100[] = {
  {&(_ZTV6dd4100[3]),  3,4},
  {&(_tg__ZTV5cc100__6dd4100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
Class_Descriptor cd_dd4100 = {  "dd4100", // class name
  bases_dd4100, 3,
  &(vtc_dd4100[0]), // expected_vtbl_contents
  &(vtt_dd4100[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd4100),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04100  : dd4100 {
  int e;
  ~ee04100(); // tgen
  ee04100(); // tgen
};
//SIG(1 ee04100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee04100 ::~ee04100(){ note_dtor("ee04100", this);} // tgen
ee04100 ::ee04100(){ note_ctor("ee04100", this);} // tgen

static void Test_ee04100()
{
  extern Class_Descriptor cd_ee04100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04100, buf);
    ee04100 *dp, &lv = *(dp=new (buf) ee04100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee04100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(20,16), "ee04100");
    check_base_class_offset(lv, (cc100*)(dd4100*), 0, "ee04100");
    check_base_class_offset(lv, (dd4100*), 0, "ee04100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee04100.e");
    test_class_info(&lv, &cd_ee04100);
    dp->~ee04100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04100(Test_ee04100, "ee04100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04100C1Ev();
extern void _ZN7ee04100D1Ev();
Name_Map name_map_ee04100[] = {
  NSPAIR(_ZN7ee04100C1Ev),
  NSPAIR(_ZN7ee04100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee04100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY vtc_ee04100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee04100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
extern VTBL_ENTRY _ZTV7ee04100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee04100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee04100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee04100[] = {
  {&(_ZTV7ee04100[3]),  3,4},
  {&(_tg__ZTV6dd4100__7ee04100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee04100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee04100[];
extern  VTBL_ENTRY _ZTV7ee04100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee04100[];
Class_Descriptor cd_ee04100 = {  "ee04100", // class name
  bases_ee04100, 4,
  &(vtc_ee04100[0]), // expected_vtbl_contents
  &(vtt_ee04100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee04100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14100  : virtual dd4100 {
  int e;
  ~ee14100(); // tgen
  ee14100(); // tgen
};
//SIG(1 ee14100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee14100 ::~ee14100(){ note_dtor("ee14100", this);} // tgen
ee14100 ::ee14100(){ note_ctor("ee14100", this);} // tgen

static void Test_ee14100()
{
  extern Class_Descriptor cd_ee14100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14100, buf);
    ee14100 *dp, &lv = *(dp=new (buf) ee14100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee14100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(32,20), "ee14100");
    check_base_class_offset(lv, (cc100*)(dd4100*), ABISELECT(16,8), "ee14100");
    check_base_class_offset(lv, (dd4100*), ABISELECT(16,8), "ee14100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14100.e");
    test_class_info(&lv, &cd_ee14100);
    dp->~ee14100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14100(Test_ee14100, "ee14100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14100C1Ev();
extern void _ZN7ee14100D1Ev();
Name_Map name_map_ee14100[] = {
  NSPAIR(_ZN7ee14100C1Ev),
  NSPAIR(_ZN7ee14100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee14100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY vtc_ee14100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14100[0]),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
extern VTBL_ENTRY _ZTV7ee14100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee14100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee14100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee14100[] = {
  {&(_ZTV7ee14100[4]),  4,9},
  {&(_ZTV7ee14100[8]),  8,9},
  {&(_tg__ZTV6dd4100__7ee14100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee14100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee14100[];
extern  VTBL_ENTRY _ZTV7ee14100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14100[];
Class_Descriptor cd_ee14100 = {  "ee14100", // class name
  bases_ee14100, 4,
  &(vtc_ee14100[0]), // expected_vtbl_contents
  &(vtt_ee14100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24100  : dd4100 {
  int e;
  virtual void  foo(); // _ZN7ee241003fooEv
  ~ee24100(); // tgen
  ee24100(); // tgen
};
//SIG(1 ee24100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee24100 ::foo(){vfunc_called(this, "_ZN7ee241003fooEv");}
ee24100 ::~ee24100(){ note_dtor("ee24100", this);} // tgen
ee24100 ::ee24100(){ note_ctor("ee24100", this);} // tgen

static void Test_ee24100()
{
  extern Class_Descriptor cd_ee24100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24100, buf);
    ee24100 *dp, &lv = *(dp=new (buf) ee24100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee24100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(20,16), "ee24100");
    check_base_class_offset(lv, (cc100*)(dd4100*), 0, "ee24100");
    check_base_class_offset(lv, (dd4100*), 0, "ee24100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee24100.e");
    test_class_info(&lv, &cd_ee24100);
    dp->~ee24100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24100(Test_ee24100, "ee24100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24100C1Ev();
extern void _ZN7ee24100D1Ev();
Name_Map name_map_ee24100[] = {
  NSPAIR(_ZN7ee24100C1Ev),
  NSPAIR(_ZN7ee24100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee24100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24100[];
extern void _ZN6dd41003barEv();
extern void _ZN7ee241003fooEv();
static  VTBL_ENTRY vtc_ee24100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee24100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
  (VTBL_ENTRY)&_ZN7ee241003fooEv,
};
extern VTBL_ENTRY _ZTV7ee24100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee24100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee24100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee24100[] = {
  {&(_ZTV7ee24100[3]),  3,5},
  {&(_tg__ZTV6dd4100__7ee24100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee24100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee24100[];
extern  VTBL_ENTRY _ZTV7ee24100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee24100[];
Class_Descriptor cd_ee24100 = {  "ee24100", // class name
  bases_ee24100, 4,
  &(vtc_ee24100[0]), // expected_vtbl_contents
  &(vtt_ee24100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee24100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34100  : virtual dd4100 {
  int e;
  virtual void  foo(); // _ZN7ee341003fooEv
  ~ee34100(); // tgen
  ee34100(); // tgen
};
//SIG(1 ee34100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee34100 ::foo(){vfunc_called(this, "_ZN7ee341003fooEv");}
ee34100 ::~ee34100(){ note_dtor("ee34100", this);} // tgen
ee34100 ::ee34100(){ note_ctor("ee34100", this);} // tgen

static void Test_ee34100()
{
  extern Class_Descriptor cd_ee34100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34100, buf);
    ee34100 *dp, &lv = *(dp=new (buf) ee34100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee34100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(32,20), "ee34100");
    check_base_class_offset(lv, (cc100*)(dd4100*), ABISELECT(16,8), "ee34100");
    check_base_class_offset(lv, (dd4100*), ABISELECT(16,8), "ee34100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34100.e");
    test_class_info(&lv, &cd_ee34100);
    dp->~ee34100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34100(Test_ee34100, "ee34100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34100C1Ev();
extern void _ZN7ee34100D1Ev();
Name_Map name_map_ee34100[] = {
  NSPAIR(_ZN7ee34100C1Ev),
  NSPAIR(_ZN7ee34100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee34100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34100[];
extern void _ZN7ee341003fooEv();
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY vtc_ee34100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34100[0]),
  (VTBL_ENTRY)&_ZN7ee341003fooEv,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
extern VTBL_ENTRY _ZTV7ee34100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee34100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee34100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee34100[] = {
  {&(_ZTV7ee34100[4]),  4,10},
  {&(_ZTV7ee34100[9]),  9,10},
  {&(_tg__ZTV6dd4100__7ee34100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee34100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee34100[];
extern  VTBL_ENTRY _ZTV7ee34100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34100[];
Class_Descriptor cd_ee34100 = {  "ee34100", // class name
  bases_ee34100, 4,
  &(vtc_ee34100[0]), // expected_vtbl_contents
  &(vtt_ee34100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34100),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44100  : dd4100 {
  int e;
  virtual void  bar(); // _ZN7ee441003barEv
  ~ee44100(); // tgen
  ee44100(); // tgen
};
//SIG(1 ee44100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee44100 ::bar(){vfunc_called(this, "_ZN7ee441003barEv");}
ee44100 ::~ee44100(){ note_dtor("ee44100", this);} // tgen
ee44100 ::ee44100(){ note_ctor("ee44100", this);} // tgen

static void Test_ee44100()
{
  extern Class_Descriptor cd_ee44100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44100, buf);
    ee44100 *dp, &lv = *(dp=new (buf) ee44100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee44100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(20,16), "ee44100");
    check_base_class_offset(lv, (cc100*)(dd4100*), 0, "ee44100");
    check_base_class_offset(lv, (dd4100*), 0, "ee44100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee44100.e");
    test_class_info(&lv, &cd_ee44100);
    dp->~ee44100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44100(Test_ee44100, "ee44100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44100C1Ev();
extern void _ZN7ee44100D1Ev();
Name_Map name_map_ee44100[] = {
  NSPAIR(_ZN7ee44100C1Ev),
  NSPAIR(_ZN7ee44100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee44100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44100[];
extern void _ZN7ee441003barEv();
static  VTBL_ENTRY vtc_ee44100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee44100[0]),
  (VTBL_ENTRY)&_ZN7ee441003barEv,
};
extern VTBL_ENTRY _ZTV7ee44100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee44100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee44100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee44100[] = {
  {&(_ZTV7ee44100[3]),  3,4},
  {&(_tg__ZTV6dd4100__7ee44100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee44100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee44100[];
extern  VTBL_ENTRY _ZTV7ee44100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee44100[];
Class_Descriptor cd_ee44100 = {  "ee44100", // class name
  bases_ee44100, 4,
  &(vtc_ee44100[0]), // expected_vtbl_contents
  &(vtt_ee44100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44100),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee44100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54100  : virtual dd4100 {
  int e;
  virtual void  bar(); // _ZN7ee541003barEv
  ~ee54100(); // tgen
  ee54100(); // tgen
};
//SIG(1 ee54100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee54100 ::bar(){vfunc_called(this, "_ZN7ee541003barEv");}
ee54100 ::~ee54100(){ note_dtor("ee54100", this);} // tgen
ee54100 ::ee54100(){ note_ctor("ee54100", this);} // tgen

static void Test_ee54100()
{
  extern Class_Descriptor cd_ee54100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54100, buf);
    ee54100 *dp, &lv = *(dp=new (buf) ee54100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee54100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(32,20), "ee54100");
    check_base_class_offset(lv, (cc100*)(dd4100*), ABISELECT(16,8), "ee54100");
    check_base_class_offset(lv, (dd4100*), ABISELECT(16,8), "ee54100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54100.e");
    test_class_info(&lv, &cd_ee54100);
    dp->~ee54100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54100(Test_ee54100, "ee54100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54100C1Ev();
extern void _ZN7ee54100D1Ev();
Name_Map name_map_ee54100[] = {
  NSPAIR(_ZN7ee54100C1Ev),
  NSPAIR(_ZN7ee54100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee54100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54100[];
extern void _ZN7ee541003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee541003barEv,_ZTv0_n16_N7ee541003barEv)();
extern void ABISELECT(_ZThn16_N7ee541003barEv,_ZThn8_N7ee541003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54100[0]),
  (VTBL_ENTRY)&_ZN7ee541003barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee541003barEv,_ZTv0_n16_N7ee541003barEv),
};
extern VTBL_ENTRY _ZTV7ee54100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee54100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee54100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee54100[] = {
  {&(_ZTV7ee54100[4]),  4,10},
  {&(_ZTV7ee54100[9]),  9,10},
  {&(_tg__ZTV6dd4100__7ee54100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee54100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee54100[];
extern  VTBL_ENTRY _ZTV7ee54100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54100[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee541003barEv,_ZTv0_n16_N7ee541003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee541003barEv,_ZThn8_N7ee541003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54100 = {  "ee54100", // class name
  bases_ee54100, 4,
  &(vtc_ee54100[0]), // expected_vtbl_contents
  &(vtt_ee54100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54100),10, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64100  : dd4100 {
  int e;
  virtual void  foo(); // _ZN7ee641003fooEv
  virtual void  bar(); // _ZN7ee641003barEv
  ~ee64100(); // tgen
  ee64100(); // tgen
};
//SIG(1 ee64100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee64100 ::foo(){vfunc_called(this, "_ZN7ee641003fooEv");}
void  ee64100 ::bar(){vfunc_called(this, "_ZN7ee641003barEv");}
ee64100 ::~ee64100(){ note_dtor("ee64100", this);} // tgen
ee64100 ::ee64100(){ note_ctor("ee64100", this);} // tgen

static void Test_ee64100()
{
  extern Class_Descriptor cd_ee64100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64100, buf);
    ee64100 *dp, &lv = *(dp=new (buf) ee64100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee64100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(20,16), "ee64100");
    check_base_class_offset(lv, (cc100*)(dd4100*), 0, "ee64100");
    check_base_class_offset(lv, (dd4100*), 0, "ee64100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee64100.e");
    test_class_info(&lv, &cd_ee64100);
    dp->~ee64100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64100(Test_ee64100, "ee64100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64100C1Ev();
extern void _ZN7ee64100D1Ev();
Name_Map name_map_ee64100[] = {
  NSPAIR(_ZN7ee64100C1Ev),
  NSPAIR(_ZN7ee64100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee64100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64100[];
extern void _ZN7ee641003barEv();
extern void _ZN7ee641003fooEv();
static  VTBL_ENTRY vtc_ee64100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee64100[0]),
  (VTBL_ENTRY)&_ZN7ee641003barEv,
  (VTBL_ENTRY)&_ZN7ee641003fooEv,
};
extern VTBL_ENTRY _ZTV7ee64100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee64100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee64100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee64100[] = {
  {&(_ZTV7ee64100[3]),  3,5},
  {&(_tg__ZTV6dd4100__7ee64100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee64100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee64100[];
extern  VTBL_ENTRY _ZTV7ee64100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee64100[];
Class_Descriptor cd_ee64100 = {  "ee64100", // class name
  bases_ee64100, 4,
  &(vtc_ee64100[0]), // expected_vtbl_contents
  &(vtt_ee64100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee64100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74100  : virtual dd4100 {
  int e;
  virtual void  foo(); // _ZN7ee741003fooEv
  virtual void  bar(); // _ZN7ee741003barEv
  ~ee74100(); // tgen
  ee74100(); // tgen
};
//SIG(1 ee74100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee74100 ::foo(){vfunc_called(this, "_ZN7ee741003fooEv");}
void  ee74100 ::bar(){vfunc_called(this, "_ZN7ee741003barEv");}
ee74100 ::~ee74100(){ note_dtor("ee74100", this);} // tgen
ee74100 ::ee74100(){ note_ctor("ee74100", this);} // tgen

static void Test_ee74100()
{
  extern Class_Descriptor cd_ee74100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74100, buf);
    ee74100 *dp, &lv = *(dp=new (buf) ee74100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee74100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd4100*), ABISELECT(32,20), "ee74100");
    check_base_class_offset(lv, (cc100*)(dd4100*), ABISELECT(16,8), "ee74100");
    check_base_class_offset(lv, (dd4100*), ABISELECT(16,8), "ee74100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74100.e");
    test_class_info(&lv, &cd_ee74100);
    dp->~ee74100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74100(Test_ee74100, "ee74100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74100C1Ev();
extern void _ZN7ee74100D1Ev();
Name_Map name_map_ee74100[] = {
  NSPAIR(_ZN7ee74100C1Ev),
  NSPAIR(_ZN7ee74100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd4100;
extern VTBL_ENTRY _ZTI6dd4100[];
extern  VTBL_ENTRY _ZTV6dd4100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd4100[];
static Base_Class bases_ee74100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74100[];
extern void _ZN7ee741003fooEv();
extern void _ZN7ee741003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee741003barEv,_ZTv0_n16_N7ee741003barEv)();
extern void ABISELECT(_ZThn16_N7ee741003barEv,_ZThn8_N7ee741003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74100[0]),
  (VTBL_ENTRY)&_ZN7ee741003fooEv,
  (VTBL_ENTRY)&_ZN7ee741003barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee741003barEv,_ZTv0_n16_N7ee741003barEv),
};
extern VTBL_ENTRY _ZTV7ee74100[];
extern void _ZN6dd41003barEv();
static  VTBL_ENTRY _tg__ZTV6dd4100__7ee74100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd4100[0]),
  (VTBL_ENTRY)&_ZN6dd41003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd4100__7ee74100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee74100[] = {
  {&(_ZTV7ee74100[4]),  4,11},
  {&(_ZTV7ee74100[10]),  10,11},
  {&(_tg__ZTV6dd4100__7ee74100[3]),  3,4},
  {&(_tg__ZTV5cc1006dd4100__7ee74100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee74100[];
extern  VTBL_ENTRY _ZTV7ee74100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74100[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee741003barEv,_ZTv0_n16_N7ee741003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee741003barEv,_ZThn8_N7ee741003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74100 = {  "ee74100", // class name
  bases_ee74100, 4,
  &(vtc_ee74100[0]), // expected_vtbl_contents
  &(vtt_ee74100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74100),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5100  : virtual cc100 {
  int d;
  virtual void  bar(); // _ZN6dd51003barEv
  ~dd5100(); // tgen
  dd5100(); // tgen
};
//SIG(-1 dd5100) C1{ VBC2{ VBC3{ BC4{ Fi} Fi} Fi} v1 Fi}


void  dd5100 ::bar(){vfunc_called(this, "_ZN6dd51003barEv");}
dd5100 ::~dd5100(){ note_dtor("dd5100", this);} // tgen
dd5100 ::dd5100(){ note_ctor("dd5100", this);} // tgen

static void Test_dd5100()
{
  extern Class_Descriptor cd_dd5100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5100, buf);
    dd5100 *dp, &lv = *(dp=new (buf) dd5100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,16), "dd5100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,16), "dd5100");
    check_base_class_offset(lv, (cc100*), ABISELECT(16,8), "dd5100");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5100.d");
    test_class_info(&lv, &cd_dd5100);
    dp->~dd5100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5100(Test_dd5100, "dd5100", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5100C1Ev();
extern void _ZN6dd5100D1Ev();
Name_Map name_map_dd5100[] = {
  NSPAIR(_ZN6dd5100C1Ev),
  NSPAIR(_ZN6dd5100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd5100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY vtc_dd5100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
extern VTBL_ENTRY _ZTV6dd5100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd5100[] = {
  {&(_ZTV6dd5100[4]),  4,8},
  {&(_ZTV6dd5100[8]),  8,8},
  {&(_tg__ZTV5cc100__6dd5100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
Class_Descriptor cd_dd5100 = {  "dd5100", // class name
  bases_dd5100, 3,
  &(vtc_dd5100[0]), // expected_vtbl_contents
  &(vtt_dd5100[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5100),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05100  : dd5100 {
  int e;
  ~ee05100(); // tgen
  ee05100(); // tgen
};
//SIG(1 ee05100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee05100 ::~ee05100(){ note_dtor("ee05100", this);} // tgen
ee05100 ::ee05100(){ note_ctor("ee05100", this);} // tgen

static void Test_ee05100()
{
  extern Class_Descriptor cd_ee05100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05100, buf);
    ee05100 *dp, &lv = *(dp=new (buf) ee05100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee05100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee05100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(16,12), "ee05100");
    check_base_class_offset(lv, (dd5100*), 0, "ee05100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05100.e");
    test_class_info(&lv, &cd_ee05100);
    dp->~ee05100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05100(Test_ee05100, "ee05100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05100C1Ev();
extern void _ZN7ee05100D1Ev();
Name_Map name_map_ee05100[] = {
  NSPAIR(_ZN7ee05100C1Ev),
  NSPAIR(_ZN7ee05100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee05100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY vtc_ee05100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05100[0]),
};
extern VTBL_ENTRY _ZTV7ee05100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee05100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee05100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee05100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee05100[] = {
  {&(_ZTV7ee05100[4]),  4,8},
  {&(_tg__ZTV6dd5100__7ee05100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee05100[3]),  3,3},
  {&(_ZTV7ee05100[8]),  8,8},
  {&(_tg__ZTV5cc100__7ee05100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee05100[];
extern  VTBL_ENTRY _ZTV7ee05100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05100[];
Class_Descriptor cd_ee05100 = {  "ee05100", // class name
  bases_ee05100, 4,
  &(vtc_ee05100[0]), // expected_vtbl_contents
  &(vtt_ee05100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15100  : virtual dd5100 {
  int e;
  ~ee15100(); // tgen
  ee15100(); // tgen
};
//SIG(1 ee15100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} Fi}


ee15100 ::~ee15100(){ note_dtor("ee15100", this);} // tgen
ee15100 ::ee15100(){ note_ctor("ee15100", this);} // tgen

static void Test_ee15100()
{
  extern Class_Descriptor cd_ee15100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15100, buf);
    ee15100 *dp, &lv = *(dp=new (buf) ee15100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee15100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee15100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(32,16), "ee15100");
    check_base_class_offset(lv, (dd5100*), ABISELECT(16,8), "ee15100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15100.e");
    test_class_info(&lv, &cd_ee15100);
    dp->~ee15100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15100(Test_ee15100, "ee15100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15100C1Ev();
extern void _ZN7ee15100D1Ev();
Name_Map name_map_ee15100[] = {
  NSPAIR(_ZN7ee15100C1Ev),
  NSPAIR(_ZN7ee15100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee15100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY vtc_ee15100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15100[0]),
  0,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15100[0]),
};
extern VTBL_ENTRY _ZTV7ee15100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee15100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee15100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee15100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee15100[] = {
  {&(_ZTV7ee15100[5]),  5,14},
  {&(_ZTV7ee15100[10]),  10,14},
  {&(_ZTV7ee15100[14]),  14,14},
  {&(_tg__ZTV6dd5100__7ee15100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee15100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee15100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee15100[];
extern  VTBL_ENTRY _ZTV7ee15100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15100[];
Class_Descriptor cd_ee15100 = {  "ee15100", // class name
  bases_ee15100, 4,
  &(vtc_ee15100[0]), // expected_vtbl_contents
  &(vtt_ee15100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15100),14, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25100  : dd5100 {
  int e;
  virtual void  foo(); // _ZN7ee251003fooEv
  ~ee25100(); // tgen
  ee25100(); // tgen
};
//SIG(1 ee25100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee25100 ::foo(){vfunc_called(this, "_ZN7ee251003fooEv");}
ee25100 ::~ee25100(){ note_dtor("ee25100", this);} // tgen
ee25100 ::ee25100(){ note_ctor("ee25100", this);} // tgen

static void Test_ee25100()
{
  extern Class_Descriptor cd_ee25100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25100, buf);
    ee25100 *dp, &lv = *(dp=new (buf) ee25100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee25100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee25100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(16,12), "ee25100");
    check_base_class_offset(lv, (dd5100*), 0, "ee25100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25100.e");
    test_class_info(&lv, &cd_ee25100);
    dp->~ee25100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25100(Test_ee25100, "ee25100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25100C1Ev();
extern void _ZN7ee25100D1Ev();
Name_Map name_map_ee25100[] = {
  NSPAIR(_ZN7ee25100C1Ev),
  NSPAIR(_ZN7ee25100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee25100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25100[];
extern void _ZN6dd51003barEv();
extern void _ZN7ee251003fooEv();
static  VTBL_ENTRY vtc_ee25100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
  (VTBL_ENTRY)&_ZN7ee251003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25100[0]),
};
extern VTBL_ENTRY _ZTV7ee25100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee25100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee25100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee25100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee25100[] = {
  {&(_ZTV7ee25100[4]),  4,9},
  {&(_tg__ZTV6dd5100__7ee25100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee25100[3]),  3,3},
  {&(_ZTV7ee25100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee25100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee25100[];
extern  VTBL_ENTRY _ZTV7ee25100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25100[];
Class_Descriptor cd_ee25100 = {  "ee25100", // class name
  bases_ee25100, 4,
  &(vtc_ee25100[0]), // expected_vtbl_contents
  &(vtt_ee25100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35100  : virtual dd5100 {
  int e;
  virtual void  foo(); // _ZN7ee351003fooEv
  ~ee35100(); // tgen
  ee35100(); // tgen
};
//SIG(1 ee35100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 Fi}


void  ee35100 ::foo(){vfunc_called(this, "_ZN7ee351003fooEv");}
ee35100 ::~ee35100(){ note_dtor("ee35100", this);} // tgen
ee35100 ::ee35100(){ note_ctor("ee35100", this);} // tgen

static void Test_ee35100()
{
  extern Class_Descriptor cd_ee35100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35100, buf);
    ee35100 *dp, &lv = *(dp=new (buf) ee35100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee35100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee35100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(32,16), "ee35100");
    check_base_class_offset(lv, (dd5100*), ABISELECT(16,8), "ee35100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35100.e");
    test_class_info(&lv, &cd_ee35100);
    dp->~ee35100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35100(Test_ee35100, "ee35100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35100C1Ev();
extern void _ZN7ee35100D1Ev();
Name_Map name_map_ee35100[] = {
  NSPAIR(_ZN7ee35100C1Ev),
  NSPAIR(_ZN7ee35100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee35100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35100[];
extern void _ZN7ee351003fooEv();
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY vtc_ee35100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35100[0]),
  (VTBL_ENTRY)&_ZN7ee351003fooEv,
  0,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35100[0]),
};
extern VTBL_ENTRY _ZTV7ee35100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee35100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee35100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee35100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee35100[] = {
  {&(_ZTV7ee35100[5]),  5,15},
  {&(_ZTV7ee35100[11]),  11,15},
  {&(_ZTV7ee35100[15]),  15,15},
  {&(_tg__ZTV6dd5100__7ee35100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee35100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee35100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee35100[];
extern  VTBL_ENTRY _ZTV7ee35100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35100[];
Class_Descriptor cd_ee35100 = {  "ee35100", // class name
  bases_ee35100, 4,
  &(vtc_ee35100[0]), // expected_vtbl_contents
  &(vtt_ee35100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35100),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45100  : dd5100 {
  int e;
  virtual void  bar(); // _ZN7ee451003barEv
  ~ee45100(); // tgen
  ee45100(); // tgen
};
//SIG(1 ee45100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee45100 ::bar(){vfunc_called(this, "_ZN7ee451003barEv");}
ee45100 ::~ee45100(){ note_dtor("ee45100", this);} // tgen
ee45100 ::ee45100(){ note_ctor("ee45100", this);} // tgen

static void Test_ee45100()
{
  extern Class_Descriptor cd_ee45100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45100, buf);
    ee45100 *dp, &lv = *(dp=new (buf) ee45100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee45100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee45100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(16,12), "ee45100");
    check_base_class_offset(lv, (dd5100*), 0, "ee45100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45100.e");
    test_class_info(&lv, &cd_ee45100);
    dp->~ee45100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45100(Test_ee45100, "ee45100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45100C1Ev();
extern void _ZN7ee45100D1Ev();
Name_Map name_map_ee45100[] = {
  NSPAIR(_ZN7ee45100C1Ev),
  NSPAIR(_ZN7ee45100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee45100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45100[];
extern void _ZN7ee451003barEv();
static  VTBL_ENTRY vtc_ee45100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45100[0]),
  (VTBL_ENTRY)&_ZN7ee451003barEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45100[0]),
};
extern VTBL_ENTRY _ZTV7ee45100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee45100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee45100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee45100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee45100[] = {
  {&(_ZTV7ee45100[4]),  4,8},
  {&(_tg__ZTV6dd5100__7ee45100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee45100[3]),  3,3},
  {&(_ZTV7ee45100[8]),  8,8},
  {&(_tg__ZTV5cc100__7ee45100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee45100[];
extern  VTBL_ENTRY _ZTV7ee45100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45100[];
Class_Descriptor cd_ee45100 = {  "ee45100", // class name
  bases_ee45100, 4,
  &(vtc_ee45100[0]), // expected_vtbl_contents
  &(vtt_ee45100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45100),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55100  : virtual dd5100 {
  int e;
  virtual void  bar(); // _ZN7ee551003barEv
  ~ee55100(); // tgen
  ee55100(); // tgen
};
//SIG(1 ee55100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 Fi} v1 Fi}


void  ee55100 ::bar(){vfunc_called(this, "_ZN7ee551003barEv");}
ee55100 ::~ee55100(){ note_dtor("ee55100", this);} // tgen
ee55100 ::ee55100(){ note_ctor("ee55100", this);} // tgen

static void Test_ee55100()
{
  extern Class_Descriptor cd_ee55100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55100, buf);
    ee55100 *dp, &lv = *(dp=new (buf) ee55100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee55100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee55100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(32,16), "ee55100");
    check_base_class_offset(lv, (dd5100*), ABISELECT(16,8), "ee55100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55100.e");
    test_class_info(&lv, &cd_ee55100);
    dp->~ee55100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55100(Test_ee55100, "ee55100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55100C1Ev();
extern void _ZN7ee55100D1Ev();
Name_Map name_map_ee55100[] = {
  NSPAIR(_ZN7ee55100C1Ev),
  NSPAIR(_ZN7ee55100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee55100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55100[];
extern void _ZN7ee551003barEv();
extern void ABISELECT(_ZTv0_n40_N7ee551003barEv,_ZTv0_n20_N7ee551003barEv)();
extern void ABISELECT(_ZThn16_N7ee551003barEv,_ZThn8_N7ee551003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee55100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55100[0]),
  (VTBL_ENTRY)&_ZN7ee551003barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee551003barEv,_ZTv0_n20_N7ee551003barEv),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55100[0]),
};
extern VTBL_ENTRY _ZTV7ee55100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee55100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee55100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee55100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee55100[] = {
  {&(_ZTV7ee55100[5]),  5,15},
  {&(_ZTV7ee55100[11]),  11,15},
  {&(_ZTV7ee55100[15]),  15,15},
  {&(_tg__ZTV6dd5100__7ee55100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee55100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee55100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee55100[];
extern  VTBL_ENTRY _ZTV7ee55100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55100[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee551003barEv,_ZTv0_n20_N7ee551003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee551003barEv,_ZThn8_N7ee551003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55100 = {  "ee55100", // class name
  bases_ee55100, 4,
  &(vtc_ee55100[0]), // expected_vtbl_contents
  &(vtt_ee55100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55100),15, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65100  : dd5100 {
  int e;
  virtual void  foo(); // _ZN7ee651003fooEv
  virtual void  bar(); // _ZN7ee651003barEv
  ~ee65100(); // tgen
  ee65100(); // tgen
};
//SIG(1 ee65100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee65100 ::foo(){vfunc_called(this, "_ZN7ee651003fooEv");}
void  ee65100 ::bar(){vfunc_called(this, "_ZN7ee651003barEv");}
ee65100 ::~ee65100(){ note_dtor("ee65100", this);} // tgen
ee65100 ::ee65100(){ note_ctor("ee65100", this);} // tgen

static void Test_ee65100()
{
  extern Class_Descriptor cd_ee65100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65100, buf);
    ee65100 *dp, &lv = *(dp=new (buf) ee65100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee65100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee65100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(16,12), "ee65100");
    check_base_class_offset(lv, (dd5100*), 0, "ee65100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65100.e");
    test_class_info(&lv, &cd_ee65100);
    dp->~ee65100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65100(Test_ee65100, "ee65100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65100C1Ev();
extern void _ZN7ee65100D1Ev();
Name_Map name_map_ee65100[] = {
  NSPAIR(_ZN7ee65100C1Ev),
  NSPAIR(_ZN7ee65100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee65100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65100[];
extern void _ZN7ee651003barEv();
extern void _ZN7ee651003fooEv();
static  VTBL_ENTRY vtc_ee65100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65100[0]),
  (VTBL_ENTRY)&_ZN7ee651003barEv,
  (VTBL_ENTRY)&_ZN7ee651003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65100[0]),
};
extern VTBL_ENTRY _ZTV7ee65100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee65100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee65100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee65100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee65100[] = {
  {&(_ZTV7ee65100[4]),  4,9},
  {&(_tg__ZTV6dd5100__7ee65100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee65100[3]),  3,3},
  {&(_ZTV7ee65100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee65100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee65100[];
extern  VTBL_ENTRY _ZTV7ee65100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65100[];
Class_Descriptor cd_ee65100 = {  "ee65100", // class name
  bases_ee65100, 4,
  &(vtc_ee65100[0]), // expected_vtbl_contents
  &(vtt_ee65100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75100  : virtual dd5100 {
  int e;
  virtual void  foo(); // _ZN7ee751003fooEv
  virtual void  bar(); // _ZN7ee751003barEv
  ~ee75100(); // tgen
  ee75100(); // tgen
};
//SIG(1 ee75100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 Fi} v1 v2 Fi}


void  ee75100 ::foo(){vfunc_called(this, "_ZN7ee751003fooEv");}
void  ee75100 ::bar(){vfunc_called(this, "_ZN7ee751003barEv");}
ee75100 ::~ee75100(){ note_dtor("ee75100", this);} // tgen
ee75100 ::ee75100(){ note_ctor("ee75100", this);} // tgen

static void Test_ee75100()
{
  extern Class_Descriptor cd_ee75100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75100, buf);
    ee75100 *dp, &lv = *(dp=new (buf) ee75100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee75100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee75100");
    check_base_class_offset(lv, (cc100*)(dd5100*), ABISELECT(32,16), "ee75100");
    check_base_class_offset(lv, (dd5100*), ABISELECT(16,8), "ee75100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75100.e");
    test_class_info(&lv, &cd_ee75100);
    dp->~ee75100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75100(Test_ee75100, "ee75100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75100C1Ev();
extern void _ZN7ee75100D1Ev();
Name_Map name_map_ee75100[] = {
  NSPAIR(_ZN7ee75100C1Ev),
  NSPAIR(_ZN7ee75100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd5100;
extern VTBL_ENTRY _ZTI6dd5100[];
extern  VTBL_ENTRY _ZTV6dd5100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5100[];
static Base_Class bases_ee75100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5100,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75100[];
extern void _ZN7ee751003fooEv();
extern void _ZN7ee751003barEv();
extern void ABISELECT(_ZTv0_n40_N7ee751003barEv,_ZTv0_n20_N7ee751003barEv)();
extern void ABISELECT(_ZThn16_N7ee751003barEv,_ZThn8_N7ee751003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75100[0]),
  (VTBL_ENTRY)&_ZN7ee751003fooEv,
  (VTBL_ENTRY)&_ZN7ee751003barEv,
  ABISELECT(-16,-8),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee751003barEv,_ZTv0_n20_N7ee751003barEv),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75100[0]),
};
extern VTBL_ENTRY _ZTV7ee75100[];
extern void _ZN6dd51003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5100__7ee75100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
  (VTBL_ENTRY)&_ZN6dd51003barEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd5100__7ee75100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee75100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee75100[] = {
  {&(_ZTV7ee75100[5]),  5,16},
  {&(_ZTV7ee75100[12]),  12,16},
  {&(_ZTV7ee75100[16]),  16,16},
  {&(_tg__ZTV6dd5100__7ee75100[4]),  4,5},
  {&(_tg__ZTV5cc100__6dd5100__7ee75100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee75100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee75100[];
extern  VTBL_ENTRY _ZTV7ee75100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75100[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee751003barEv,_ZTv0_n20_N7ee751003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee751003barEv,_ZThn8_N7ee751003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75100 = {  "ee75100", // class name
  bases_ee75100, 4,
  &(vtc_ee75100[0]), // expected_vtbl_contents
  &(vtt_ee75100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75100),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6100  : cc100 {
  int d;
  virtual void  bar(); // _ZN6dd61003barEv
  virtual void  foo(); // _ZN6dd61003fooEv
  ~dd6100(); // tgen
  dd6100(); // tgen
};
//SIG(-1 dd6100) C1{ BC2{ VBC3{ BC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd6100 ::bar(){vfunc_called(this, "_ZN6dd61003barEv");}
void  dd6100 ::foo(){vfunc_called(this, "_ZN6dd61003fooEv");}
dd6100 ::~dd6100(){ note_dtor("dd6100", this);} // tgen
dd6100 ::dd6100(){ note_ctor("dd6100", this);} // tgen

static void Test_dd6100()
{
  extern Class_Descriptor cd_dd6100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6100, buf);
    dd6100 *dp, &lv = *(dp=new (buf) dd6100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(16,12), "dd6100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(16,12), "dd6100");
    check_base_class_offset(lv, (cc100*), 0, "dd6100");
    check_field_offset(lv, d, ABISELECT(12,8), "dd6100.d");
    test_class_info(&lv, &cd_dd6100);
    dp->~dd6100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6100(Test_dd6100, "dd6100", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6100C1Ev();
extern void _ZN6dd6100D1Ev();
Name_Map name_map_dd6100[] = {
  NSPAIR(_ZN6dd6100C1Ev),
  NSPAIR(_ZN6dd6100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd6100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY vtc_dd6100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
extern VTBL_ENTRY _ZTV6dd6100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd6100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd6100[] = {
  {&(_ZTV6dd6100[3]),  3,5},
  {&(_tg__ZTV5cc100__6dd6100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
Class_Descriptor cd_dd6100 = {  "dd6100", // class name
  bases_dd6100, 3,
  &(vtc_dd6100[0]), // expected_vtbl_contents
  &(vtt_dd6100[0]), // expected_vtt_contents
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd6100),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06100  : dd6100 {
  int e;
  ~ee06100(); // tgen
  ee06100(); // tgen
};
//SIG(1 ee06100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee06100 ::~ee06100(){ note_dtor("ee06100", this);} // tgen
ee06100 ::ee06100(){ note_ctor("ee06100", this);} // tgen

static void Test_ee06100()
{
  extern Class_Descriptor cd_ee06100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06100, buf);
    ee06100 *dp, &lv = *(dp=new (buf) ee06100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee06100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(20,16), "ee06100");
    check_base_class_offset(lv, (cc100*)(dd6100*), 0, "ee06100");
    check_base_class_offset(lv, (dd6100*), 0, "ee06100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee06100.e");
    test_class_info(&lv, &cd_ee06100);
    dp->~ee06100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06100(Test_ee06100, "ee06100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06100C1Ev();
extern void _ZN7ee06100D1Ev();
Name_Map name_map_ee06100[] = {
  NSPAIR(_ZN7ee06100C1Ev),
  NSPAIR(_ZN7ee06100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee06100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY vtc_ee06100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee06100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
extern VTBL_ENTRY _ZTV7ee06100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee06100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee06100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee06100[] = {
  {&(_ZTV7ee06100[3]),  3,5},
  {&(_tg__ZTV6dd6100__7ee06100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee06100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee06100[];
extern  VTBL_ENTRY _ZTV7ee06100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee06100[];
Class_Descriptor cd_ee06100 = {  "ee06100", // class name
  bases_ee06100, 4,
  &(vtc_ee06100[0]), // expected_vtbl_contents
  &(vtt_ee06100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee06100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16100  : virtual dd6100 {
  int e;
  ~ee16100(); // tgen
  ee16100(); // tgen
};
//SIG(1 ee16100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee16100 ::~ee16100(){ note_dtor("ee16100", this);} // tgen
ee16100 ::ee16100(){ note_ctor("ee16100", this);} // tgen

static void Test_ee16100()
{
  extern Class_Descriptor cd_ee16100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16100, buf);
    ee16100 *dp, &lv = *(dp=new (buf) ee16100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee16100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(32,20), "ee16100");
    check_base_class_offset(lv, (cc100*)(dd6100*), ABISELECT(16,8), "ee16100");
    check_base_class_offset(lv, (dd6100*), ABISELECT(16,8), "ee16100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16100.e");
    test_class_info(&lv, &cd_ee16100);
    dp->~ee16100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16100(Test_ee16100, "ee16100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16100C1Ev();
extern void _ZN7ee16100D1Ev();
Name_Map name_map_ee16100[] = {
  NSPAIR(_ZN7ee16100C1Ev),
  NSPAIR(_ZN7ee16100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee16100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY vtc_ee16100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16100[0]),
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
extern VTBL_ENTRY _ZTV7ee16100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee16100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee16100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee16100[] = {
  {&(_ZTV7ee16100[4]),  4,11},
  {&(_ZTV7ee16100[9]),  9,11},
  {&(_tg__ZTV6dd6100__7ee16100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee16100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee16100[];
extern  VTBL_ENTRY _ZTV7ee16100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16100[];
Class_Descriptor cd_ee16100 = {  "ee16100", // class name
  bases_ee16100, 4,
  &(vtc_ee16100[0]), // expected_vtbl_contents
  &(vtt_ee16100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16100),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26100  : dd6100 {
  int e;
  virtual void  foo(); // _ZN7ee261003fooEv
  ~ee26100(); // tgen
  ee26100(); // tgen
};
//SIG(1 ee26100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee26100 ::foo(){vfunc_called(this, "_ZN7ee261003fooEv");}
ee26100 ::~ee26100(){ note_dtor("ee26100", this);} // tgen
ee26100 ::ee26100(){ note_ctor("ee26100", this);} // tgen

static void Test_ee26100()
{
  extern Class_Descriptor cd_ee26100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26100, buf);
    ee26100 *dp, &lv = *(dp=new (buf) ee26100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee26100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(20,16), "ee26100");
    check_base_class_offset(lv, (cc100*)(dd6100*), 0, "ee26100");
    check_base_class_offset(lv, (dd6100*), 0, "ee26100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee26100.e");
    test_class_info(&lv, &cd_ee26100);
    dp->~ee26100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26100(Test_ee26100, "ee26100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26100C1Ev();
extern void _ZN7ee26100D1Ev();
Name_Map name_map_ee26100[] = {
  NSPAIR(_ZN7ee26100C1Ev),
  NSPAIR(_ZN7ee26100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee26100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26100[];
extern void _ZN6dd61003barEv();
extern void _ZN7ee261003fooEv();
static  VTBL_ENTRY vtc_ee26100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee26100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN7ee261003fooEv,
};
extern VTBL_ENTRY _ZTV7ee26100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee26100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee26100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee26100[] = {
  {&(_ZTV7ee26100[3]),  3,5},
  {&(_tg__ZTV6dd6100__7ee26100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee26100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee26100[];
extern  VTBL_ENTRY _ZTV7ee26100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee26100[];
Class_Descriptor cd_ee26100 = {  "ee26100", // class name
  bases_ee26100, 4,
  &(vtc_ee26100[0]), // expected_vtbl_contents
  &(vtt_ee26100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee26100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36100  : virtual dd6100 {
  int e;
  virtual void  foo(); // _ZN7ee361003fooEv
  ~ee36100(); // tgen
  ee36100(); // tgen
};
//SIG(1 ee36100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee36100 ::foo(){vfunc_called(this, "_ZN7ee361003fooEv");}
ee36100 ::~ee36100(){ note_dtor("ee36100", this);} // tgen
ee36100 ::ee36100(){ note_ctor("ee36100", this);} // tgen

static void Test_ee36100()
{
  extern Class_Descriptor cd_ee36100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36100, buf);
    ee36100 *dp, &lv = *(dp=new (buf) ee36100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee36100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(32,20), "ee36100");
    check_base_class_offset(lv, (cc100*)(dd6100*), ABISELECT(16,8), "ee36100");
    check_base_class_offset(lv, (dd6100*), ABISELECT(16,8), "ee36100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36100.e");
    test_class_info(&lv, &cd_ee36100);
    dp->~ee36100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36100(Test_ee36100, "ee36100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36100C1Ev();
extern void _ZN7ee36100D1Ev();
Name_Map name_map_ee36100[] = {
  NSPAIR(_ZN7ee36100C1Ev),
  NSPAIR(_ZN7ee36100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee36100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36100[];
extern void _ZN7ee361003fooEv();
extern void _ZN6dd61003barEv();
extern void ABISELECT(_ZTv0_n40_N7ee361003fooEv,_ZTv0_n20_N7ee361003fooEv)();
extern void ABISELECT(_ZThn16_N7ee361003fooEv,_ZThn8_N7ee361003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee36100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36100[0]),
  (VTBL_ENTRY)&_ZN7ee361003fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee361003fooEv,_ZTv0_n20_N7ee361003fooEv),
};
extern VTBL_ENTRY _ZTV7ee36100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee36100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee36100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee36100[] = {
  {&(_ZTV7ee36100[4]),  4,12},
  {&(_ZTV7ee36100[10]),  10,12},
  {&(_tg__ZTV6dd6100__7ee36100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee36100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee36100[];
extern  VTBL_ENTRY _ZTV7ee36100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36100[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee361003fooEv,_ZTv0_n20_N7ee361003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee361003fooEv,_ZThn8_N7ee361003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36100 = {  "ee36100", // class name
  bases_ee36100, 4,
  &(vtc_ee36100[0]), // expected_vtbl_contents
  &(vtt_ee36100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36100),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46100  : dd6100 {
  int e;
  virtual void  bar(); // _ZN7ee461003barEv
  ~ee46100(); // tgen
  ee46100(); // tgen
};
//SIG(1 ee46100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee46100 ::bar(){vfunc_called(this, "_ZN7ee461003barEv");}
ee46100 ::~ee46100(){ note_dtor("ee46100", this);} // tgen
ee46100 ::ee46100(){ note_ctor("ee46100", this);} // tgen

static void Test_ee46100()
{
  extern Class_Descriptor cd_ee46100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46100, buf);
    ee46100 *dp, &lv = *(dp=new (buf) ee46100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee46100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(20,16), "ee46100");
    check_base_class_offset(lv, (cc100*)(dd6100*), 0, "ee46100");
    check_base_class_offset(lv, (dd6100*), 0, "ee46100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee46100.e");
    test_class_info(&lv, &cd_ee46100);
    dp->~ee46100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46100(Test_ee46100, "ee46100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46100C1Ev();
extern void _ZN7ee46100D1Ev();
Name_Map name_map_ee46100[] = {
  NSPAIR(_ZN7ee46100C1Ev),
  NSPAIR(_ZN7ee46100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee46100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46100[];
extern void _ZN7ee461003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY vtc_ee46100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee46100[0]),
  (VTBL_ENTRY)&_ZN7ee461003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
extern VTBL_ENTRY _ZTV7ee46100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee46100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee46100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee46100[] = {
  {&(_ZTV7ee46100[3]),  3,5},
  {&(_tg__ZTV6dd6100__7ee46100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee46100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee46100[];
extern  VTBL_ENTRY _ZTV7ee46100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee46100[];
Class_Descriptor cd_ee46100 = {  "ee46100", // class name
  bases_ee46100, 4,
  &(vtc_ee46100[0]), // expected_vtbl_contents
  &(vtt_ee46100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee46100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56100  : virtual dd6100 {
  int e;
  virtual void  bar(); // _ZN7ee561003barEv
  ~ee56100(); // tgen
  ee56100(); // tgen
};
//SIG(1 ee56100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee56100 ::bar(){vfunc_called(this, "_ZN7ee561003barEv");}
ee56100 ::~ee56100(){ note_dtor("ee56100", this);} // tgen
ee56100 ::ee56100(){ note_ctor("ee56100", this);} // tgen

static void Test_ee56100()
{
  extern Class_Descriptor cd_ee56100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56100, buf);
    ee56100 *dp, &lv = *(dp=new (buf) ee56100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee56100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(32,20), "ee56100");
    check_base_class_offset(lv, (cc100*)(dd6100*), ABISELECT(16,8), "ee56100");
    check_base_class_offset(lv, (dd6100*), ABISELECT(16,8), "ee56100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56100.e");
    test_class_info(&lv, &cd_ee56100);
    dp->~ee56100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56100(Test_ee56100, "ee56100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56100C1Ev();
extern void _ZN7ee56100D1Ev();
Name_Map name_map_ee56100[] = {
  NSPAIR(_ZN7ee56100C1Ev),
  NSPAIR(_ZN7ee56100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee56100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56100[];
extern void _ZN7ee561003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee561003barEv,_ZTv0_n16_N7ee561003barEv)();
extern void ABISELECT(_ZThn16_N7ee561003barEv,_ZThn8_N7ee561003barEv)() __attribute__((weak));
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY vtc_ee56100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56100[0]),
  (VTBL_ENTRY)&_ZN7ee561003barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee561003barEv,_ZTv0_n16_N7ee561003barEv),
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
extern VTBL_ENTRY _ZTV7ee56100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee56100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee56100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee56100[] = {
  {&(_ZTV7ee56100[4]),  4,12},
  {&(_ZTV7ee56100[10]),  10,12},
  {&(_tg__ZTV6dd6100__7ee56100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee56100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee56100[];
extern  VTBL_ENTRY _ZTV7ee56100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56100[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee561003barEv,_ZTv0_n16_N7ee561003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee561003barEv,_ZThn8_N7ee561003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56100 = {  "ee56100", // class name
  bases_ee56100, 4,
  &(vtc_ee56100[0]), // expected_vtbl_contents
  &(vtt_ee56100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56100),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66100  : dd6100 {
  int e;
  virtual void  foo(); // _ZN7ee661003fooEv
  virtual void  bar(); // _ZN7ee661003barEv
  ~ee66100(); // tgen
  ee66100(); // tgen
};
//SIG(1 ee66100) C1{ BC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66100 ::foo(){vfunc_called(this, "_ZN7ee661003fooEv");}
void  ee66100 ::bar(){vfunc_called(this, "_ZN7ee661003barEv");}
ee66100 ::~ee66100(){ note_dtor("ee66100", this);} // tgen
ee66100 ::ee66100(){ note_ctor("ee66100", this);} // tgen

static void Test_ee66100()
{
  extern Class_Descriptor cd_ee66100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66100, buf);
    ee66100 *dp, &lv = *(dp=new (buf) ee66100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(20,16), "ee66100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(20,16), "ee66100");
    check_base_class_offset(lv, (cc100*)(dd6100*), 0, "ee66100");
    check_base_class_offset(lv, (dd6100*), 0, "ee66100");
    check_field_offset(lv, e, ABISELECT(16,12), "ee66100.e");
    test_class_info(&lv, &cd_ee66100);
    dp->~ee66100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66100(Test_ee66100, "ee66100", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66100C1Ev();
extern void _ZN7ee66100D1Ev();
Name_Map name_map_ee66100[] = {
  NSPAIR(_ZN7ee66100C1Ev),
  NSPAIR(_ZN7ee66100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee66100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(20,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66100[];
extern void _ZN7ee661003barEv();
extern void _ZN7ee661003fooEv();
static  VTBL_ENTRY vtc_ee66100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI7ee66100[0]),
  (VTBL_ENTRY)&_ZN7ee661003barEv,
  (VTBL_ENTRY)&_ZN7ee661003fooEv,
};
extern VTBL_ENTRY _ZTV7ee66100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee66100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee66100[] = {
  ABISELECT(20,16),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee66100[] = {
  {&(_ZTV7ee66100[3]),  3,5},
  {&(_tg__ZTV6dd6100__7ee66100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee66100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee66100[];
extern  VTBL_ENTRY _ZTV7ee66100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee66100[];
Class_Descriptor cd_ee66100 = {  "ee66100", // class name
  bases_ee66100, 4,
  &(vtc_ee66100[0]), // expected_vtbl_contents
  &(vtt_ee66100[0]), // expected_vtt_contents
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66100),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee66100),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76100  : virtual dd6100 {
  int e;
  virtual void  foo(); // _ZN7ee761003fooEv
  virtual void  bar(); // _ZN7ee761003barEv
  ~ee76100(); // tgen
  ee76100(); // tgen
};
//SIG(1 ee76100) C1{ VBC2{ BC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76100 ::foo(){vfunc_called(this, "_ZN7ee761003fooEv");}
void  ee76100 ::bar(){vfunc_called(this, "_ZN7ee761003barEv");}
ee76100 ::~ee76100(){ note_dtor("ee76100", this);} // tgen
ee76100 ::ee76100(){ note_ctor("ee76100", this);} // tgen

static void Test_ee76100()
{
  extern Class_Descriptor cd_ee76100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76100, buf);
    ee76100 *dp, &lv = *(dp=new (buf) ee76100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(32,20), "ee76100");
    check_base_class_offset(lv, (bb00*)(cc100*)(dd6100*), ABISELECT(32,20), "ee76100");
    check_base_class_offset(lv, (cc100*)(dd6100*), ABISELECT(16,8), "ee76100");
    check_base_class_offset(lv, (dd6100*), ABISELECT(16,8), "ee76100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76100.e");
    test_class_info(&lv, &cd_ee76100);
    dp->~ee76100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76100(Test_ee76100, "ee76100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76100C1Ev();
extern void _ZN7ee76100D1Ev();
Name_Map name_map_ee76100[] = {
  NSPAIR(_ZN7ee76100C1Ev),
  NSPAIR(_ZN7ee76100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd6100;
extern VTBL_ENTRY _ZTI6dd6100[];
extern  VTBL_ENTRY _ZTV6dd6100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd6100[];
static Base_Class bases_ee76100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76100[];
extern void _ZN7ee761003fooEv();
extern void _ZN7ee761003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee761003barEv,_ZTv0_n16_N7ee761003barEv)();
extern void ABISELECT(_ZThn16_N7ee761003barEv,_ZThn8_N7ee761003barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7ee761003fooEv,_ZTv0_n20_N7ee761003fooEv)();
extern void ABISELECT(_ZThn16_N7ee761003fooEv,_ZThn8_N7ee761003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76100[] = {
  ABISELECT(32,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76100[0]),
  (VTBL_ENTRY)&_ZN7ee761003fooEv,
  (VTBL_ENTRY)&_ZN7ee761003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(16,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee761003barEv,_ZTv0_n16_N7ee761003barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee761003fooEv,_ZTv0_n20_N7ee761003fooEv),
};
extern VTBL_ENTRY _ZTV7ee76100[];
extern void _ZN6dd61003barEv();
extern void _ZN6dd61003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd6100__7ee76100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd6100[0]),
  (VTBL_ENTRY)&_ZN6dd61003barEv,
  (VTBL_ENTRY)&_ZN6dd61003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc1006dd6100__7ee76100[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee76100[] = {
  {&(_ZTV7ee76100[4]),  4,13},
  {&(_ZTV7ee76100[11]),  11,13},
  {&(_tg__ZTV6dd6100__7ee76100[3]),  3,5},
  {&(_tg__ZTV5cc1006dd6100__7ee76100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee76100[];
extern  VTBL_ENTRY _ZTV7ee76100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76100[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee761003fooEv,_ZTv0_n20_N7ee761003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761003fooEv,_ZThn8_N7ee761003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee761003barEv,_ZTv0_n16_N7ee761003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee761003barEv,_ZThn8_N7ee761003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76100 = {  "ee76100", // class name
  bases_ee76100, 4,
  &(vtc_ee76100[0]), // expected_vtbl_contents
  &(vtt_ee76100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76100),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76100),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7100  : virtual cc100 {
  int d;
  virtual void  bar(); // _ZN6dd71003barEv
  virtual void  foo(); // _ZN6dd71003fooEv
  ~dd7100(); // tgen
  dd7100(); // tgen
};
//SIG(-1 dd7100) C1{ VBC2{ VBC3{ BC4{ Fi} Fi} Fi} v1 v2 Fi}


void  dd7100 ::bar(){vfunc_called(this, "_ZN6dd71003barEv");}
void  dd7100 ::foo(){vfunc_called(this, "_ZN6dd71003fooEv");}
dd7100 ::~dd7100(){ note_dtor("dd7100", this);} // tgen
dd7100 ::dd7100(){ note_ctor("dd7100", this);} // tgen

static void Test_dd7100()
{
  extern Class_Descriptor cd_dd7100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7100, buf);
    dd7100 *dp, &lv = *(dp=new (buf) dd7100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,16), "dd7100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,16), "dd7100");
    check_base_class_offset(lv, (cc100*), ABISELECT(16,8), "dd7100");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7100.d");
    test_class_info(&lv, &cd_dd7100);
    dp->~dd7100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7100(Test_dd7100, "dd7100", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7100C1Ev();
extern void _ZN6dd7100D1Ev();
Name_Map name_map_dd7100[] = {
  NSPAIR(_ZN6dd7100C1Ev),
  NSPAIR(_ZN6dd7100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
static Base_Class bases_dd7100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY vtc_dd7100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
extern VTBL_ENTRY _ZTV6dd7100[];
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_dd7100[] = {
  {&(_ZTV6dd7100[4]),  4,9},
  {&(_ZTV6dd7100[9]),  9,9},
  {&(_tg__ZTV5cc100__6dd7100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
Class_Descriptor cd_dd7100 = {  "dd7100", // class name
  bases_dd7100, 3,
  &(vtc_dd7100[0]), // expected_vtbl_contents
  &(vtt_dd7100[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7100),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07100  : dd7100 {
  int e;
  ~ee07100(); // tgen
  ee07100(); // tgen
};
//SIG(1 ee07100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee07100 ::~ee07100(){ note_dtor("ee07100", this);} // tgen
ee07100 ::ee07100(){ note_ctor("ee07100", this);} // tgen

static void Test_ee07100()
{
  extern Class_Descriptor cd_ee07100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07100, buf);
    ee07100 *dp, &lv = *(dp=new (buf) ee07100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee07100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee07100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(16,12), "ee07100");
    check_base_class_offset(lv, (dd7100*), 0, "ee07100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07100.e");
    test_class_info(&lv, &cd_ee07100);
    dp->~ee07100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07100(Test_ee07100, "ee07100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07100C1Ev();
extern void _ZN7ee07100D1Ev();
Name_Map name_map_ee07100[] = {
  NSPAIR(_ZN7ee07100C1Ev),
  NSPAIR(_ZN7ee07100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee07100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY vtc_ee07100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07100[0]),
};
extern VTBL_ENTRY _ZTV7ee07100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee07100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee07100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee07100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee07100[] = {
  {&(_ZTV7ee07100[4]),  4,9},
  {&(_tg__ZTV6dd7100__7ee07100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee07100[3]),  3,3},
  {&(_ZTV7ee07100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee07100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee07100[];
extern  VTBL_ENTRY _ZTV7ee07100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07100[];
Class_Descriptor cd_ee07100 = {  "ee07100", // class name
  bases_ee07100, 4,
  &(vtc_ee07100[0]), // expected_vtbl_contents
  &(vtt_ee07100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17100  : virtual dd7100 {
  int e;
  ~ee17100(); // tgen
  ee17100(); // tgen
};
//SIG(1 ee17100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} Fi}


ee17100 ::~ee17100(){ note_dtor("ee17100", this);} // tgen
ee17100 ::ee17100(){ note_ctor("ee17100", this);} // tgen

static void Test_ee17100()
{
  extern Class_Descriptor cd_ee17100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17100, buf);
    ee17100 *dp, &lv = *(dp=new (buf) ee17100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee17100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee17100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(32,16), "ee17100");
    check_base_class_offset(lv, (dd7100*), ABISELECT(16,8), "ee17100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17100.e");
    test_class_info(&lv, &cd_ee17100);
    dp->~ee17100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17100(Test_ee17100, "ee17100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17100C1Ev();
extern void _ZN7ee17100D1Ev();
Name_Map name_map_ee17100[] = {
  NSPAIR(_ZN7ee17100C1Ev),
  NSPAIR(_ZN7ee17100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee17100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY vtc_ee17100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17100[0]),
  0,
  0,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17100[0]),
};
extern VTBL_ENTRY _ZTV7ee17100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee17100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee17100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee17100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee17100[] = {
  {&(_ZTV7ee17100[5]),  5,16},
  {&(_ZTV7ee17100[11]),  11,16},
  {&(_ZTV7ee17100[16]),  16,16},
  {&(_tg__ZTV6dd7100__7ee17100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee17100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee17100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee17100[];
extern  VTBL_ENTRY _ZTV7ee17100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17100[];
Class_Descriptor cd_ee17100 = {  "ee17100", // class name
  bases_ee17100, 4,
  &(vtc_ee17100[0]), // expected_vtbl_contents
  &(vtt_ee17100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17100),16, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27100  : dd7100 {
  int e;
  virtual void  foo(); // _ZN7ee271003fooEv
  ~ee27100(); // tgen
  ee27100(); // tgen
};
//SIG(1 ee27100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee27100 ::foo(){vfunc_called(this, "_ZN7ee271003fooEv");}
ee27100 ::~ee27100(){ note_dtor("ee27100", this);} // tgen
ee27100 ::ee27100(){ note_ctor("ee27100", this);} // tgen

static void Test_ee27100()
{
  extern Class_Descriptor cd_ee27100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27100, buf);
    ee27100 *dp, &lv = *(dp=new (buf) ee27100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee27100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee27100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(16,12), "ee27100");
    check_base_class_offset(lv, (dd7100*), 0, "ee27100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27100.e");
    test_class_info(&lv, &cd_ee27100);
    dp->~ee27100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27100(Test_ee27100, "ee27100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27100C1Ev();
extern void _ZN7ee27100D1Ev();
Name_Map name_map_ee27100[] = {
  NSPAIR(_ZN7ee27100C1Ev),
  NSPAIR(_ZN7ee27100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee27100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee27100[];
extern void _ZN6dd71003barEv();
extern void _ZN7ee271003fooEv();
static  VTBL_ENTRY vtc_ee27100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee27100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN7ee271003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee27100[0]),
};
extern VTBL_ENTRY _ZTV7ee27100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee27100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee27100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee27100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee27100[] = {
  {&(_ZTV7ee27100[4]),  4,9},
  {&(_tg__ZTV6dd7100__7ee27100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee27100[3]),  3,3},
  {&(_ZTV7ee27100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee27100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee27100[];
extern  VTBL_ENTRY _ZTV7ee27100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee27100[];
Class_Descriptor cd_ee27100 = {  "ee27100", // class name
  bases_ee27100, 4,
  &(vtc_ee27100[0]), // expected_vtbl_contents
  &(vtt_ee27100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee27100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee27100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee27100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37100  : virtual dd7100 {
  int e;
  virtual void  foo(); // _ZN7ee371003fooEv
  ~ee37100(); // tgen
  ee37100(); // tgen
};
//SIG(1 ee37100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 Fi}


void  ee37100 ::foo(){vfunc_called(this, "_ZN7ee371003fooEv");}
ee37100 ::~ee37100(){ note_dtor("ee37100", this);} // tgen
ee37100 ::ee37100(){ note_ctor("ee37100", this);} // tgen

static void Test_ee37100()
{
  extern Class_Descriptor cd_ee37100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee37100, buf);
    ee37100 *dp, &lv = *(dp=new (buf) ee37100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee37100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee37100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee37100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(32,16), "ee37100");
    check_base_class_offset(lv, (dd7100*), ABISELECT(16,8), "ee37100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee37100.e");
    test_class_info(&lv, &cd_ee37100);
    dp->~ee37100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37100(Test_ee37100, "ee37100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee37100C1Ev();
extern void _ZN7ee37100D1Ev();
Name_Map name_map_ee37100[] = {
  NSPAIR(_ZN7ee37100C1Ev),
  NSPAIR(_ZN7ee37100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee37100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee37100[];
extern void _ZN7ee371003fooEv();
extern void _ZN6dd71003barEv();
extern void ABISELECT(_ZTv0_n48_N7ee371003fooEv,_ZTv0_n24_N7ee371003fooEv)();
extern void ABISELECT(_ZThn16_N7ee371003fooEv,_ZThn8_N7ee371003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee37100[0]),
  (VTBL_ENTRY)&_ZN7ee371003fooEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee37100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee371003fooEv,_ZTv0_n24_N7ee371003fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee37100[0]),
};
extern VTBL_ENTRY _ZTV7ee37100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee37100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee37100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee37100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee37100[] = {
  {&(_ZTV7ee37100[5]),  5,17},
  {&(_ZTV7ee37100[12]),  12,17},
  {&(_ZTV7ee37100[17]),  17,17},
  {&(_tg__ZTV6dd7100__7ee37100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee37100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee37100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee37100[];
extern  VTBL_ENTRY _ZTV7ee37100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee37100[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee371003fooEv,_ZTv0_n24_N7ee371003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee371003fooEv,_ZThn8_N7ee371003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37100 = {  "ee37100", // class name
  bases_ee37100, 4,
  &(vtc_ee37100[0]), // expected_vtbl_contents
  &(vtt_ee37100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee37100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee37100),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee37100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee47100  : dd7100 {
  int e;
  virtual void  bar(); // _ZN7ee471003barEv
  ~ee47100(); // tgen
  ee47100(); // tgen
};
//SIG(1 ee47100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee47100 ::bar(){vfunc_called(this, "_ZN7ee471003barEv");}
ee47100 ::~ee47100(){ note_dtor("ee47100", this);} // tgen
ee47100 ::ee47100(){ note_ctor("ee47100", this);} // tgen

static void Test_ee47100()
{
  extern Class_Descriptor cd_ee47100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee47100, buf);
    ee47100 *dp, &lv = *(dp=new (buf) ee47100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee47100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee47100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee47100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee47100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(16,12), "ee47100");
    check_base_class_offset(lv, (dd7100*), 0, "ee47100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee47100.e");
    test_class_info(&lv, &cd_ee47100);
    dp->~ee47100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee47100(Test_ee47100, "ee47100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee47100C1Ev();
extern void _ZN7ee47100D1Ev();
Name_Map name_map_ee47100[] = {
  NSPAIR(_ZN7ee47100C1Ev),
  NSPAIR(_ZN7ee47100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee47100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee47100[];
extern void _ZN7ee471003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY vtc_ee47100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee47100[0]),
  (VTBL_ENTRY)&_ZN7ee471003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee47100[0]),
};
extern VTBL_ENTRY _ZTV7ee47100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee47100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee47100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee47100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee47100[] = {
  {&(_ZTV7ee47100[4]),  4,9},
  {&(_tg__ZTV6dd7100__7ee47100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee47100[3]),  3,3},
  {&(_ZTV7ee47100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee47100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee47100[];
extern  VTBL_ENTRY _ZTV7ee47100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee47100[];
Class_Descriptor cd_ee47100 = {  "ee47100", // class name
  bases_ee47100, 4,
  &(vtc_ee47100[0]), // expected_vtbl_contents
  &(vtt_ee47100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee47100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee47100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee47100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee57100  : virtual dd7100 {
  int e;
  virtual void  bar(); // _ZN7ee571003barEv
  ~ee57100(); // tgen
  ee57100(); // tgen
};
//SIG(1 ee57100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v1 v2 Fi} v1 Fi}


void  ee57100 ::bar(){vfunc_called(this, "_ZN7ee571003barEv");}
ee57100 ::~ee57100(){ note_dtor("ee57100", this);} // tgen
ee57100 ::ee57100(){ note_ctor("ee57100", this);} // tgen

static void Test_ee57100()
{
  extern Class_Descriptor cd_ee57100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee57100, buf);
    ee57100 *dp, &lv = *(dp=new (buf) ee57100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee57100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee57100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee57100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee57100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(32,16), "ee57100");
    check_base_class_offset(lv, (dd7100*), ABISELECT(16,8), "ee57100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee57100.e");
    test_class_info(&lv, &cd_ee57100);
    dp->~ee57100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee57100(Test_ee57100, "ee57100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee57100C1Ev();
extern void _ZN7ee57100D1Ev();
Name_Map name_map_ee57100[] = {
  NSPAIR(_ZN7ee57100C1Ev),
  NSPAIR(_ZN7ee57100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee57100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee57100[];
extern void _ZN7ee571003barEv();
extern void ABISELECT(_ZTv0_n40_N7ee571003barEv,_ZTv0_n20_N7ee571003barEv)();
extern void ABISELECT(_ZThn16_N7ee571003barEv,_ZThn8_N7ee571003barEv)() __attribute__((weak));
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY vtc_ee57100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee57100[0]),
  (VTBL_ENTRY)&_ZN7ee571003barEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee57100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee571003barEv,_ZTv0_n20_N7ee571003barEv),
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee57100[0]),
};
extern VTBL_ENTRY _ZTV7ee57100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee57100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee57100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee57100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee57100[] = {
  {&(_ZTV7ee57100[5]),  5,17},
  {&(_ZTV7ee57100[12]),  12,17},
  {&(_ZTV7ee57100[17]),  17,17},
  {&(_tg__ZTV6dd7100__7ee57100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee57100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee57100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee57100[];
extern  VTBL_ENTRY _ZTV7ee57100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee57100[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee571003barEv,_ZTv0_n20_N7ee571003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee571003barEv,_ZThn8_N7ee571003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee57100 = {  "ee57100", // class name
  bases_ee57100, 4,
  &(vtc_ee57100[0]), // expected_vtbl_contents
  &(vtt_ee57100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee57100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee57100),17, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee57100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee67100  : dd7100 {
  int e;
  virtual void  foo(); // _ZN7ee671003fooEv
  virtual void  bar(); // _ZN7ee671003barEv
  ~ee67100(); // tgen
  ee67100(); // tgen
};
//SIG(1 ee67100) C1{ BC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee67100 ::foo(){vfunc_called(this, "_ZN7ee671003fooEv");}
void  ee67100 ::bar(){vfunc_called(this, "_ZN7ee671003barEv");}
ee67100 ::~ee67100(){ note_dtor("ee67100", this);} // tgen
ee67100 ::ee67100(){ note_ctor("ee67100", this);} // tgen

static void Test_ee67100()
{
  extern Class_Descriptor cd_ee67100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee67100, buf);
    ee67100 *dp, &lv = *(dp=new (buf) ee67100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee67100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee67100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(28,20), "ee67100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(28,20), "ee67100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(16,12), "ee67100");
    check_base_class_offset(lv, (dd7100*), 0, "ee67100");
    check_field_offset(lv, e, ABISELECT(12,8), "ee67100.e");
    test_class_info(&lv, &cd_ee67100);
    dp->~ee67100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee67100(Test_ee67100, "ee67100", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee67100C1Ev();
extern void _ZN7ee67100D1Ev();
Name_Map name_map_ee67100[] = {
  NSPAIR(_ZN7ee67100C1Ev),
  NSPAIR(_ZN7ee67100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee67100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(28,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee67100[];
extern void _ZN7ee671003barEv();
extern void _ZN7ee671003fooEv();
static  VTBL_ENTRY vtc_ee67100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee67100[0]),
  (VTBL_ENTRY)&_ZN7ee671003barEv,
  (VTBL_ENTRY)&_ZN7ee671003fooEv,
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee67100[0]),
};
extern VTBL_ENTRY _ZTV7ee67100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee67100[] = {
  ABISELECT(28,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee67100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee67100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee67100[] = {
  {&(_ZTV7ee67100[4]),  4,9},
  {&(_tg__ZTV6dd7100__7ee67100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee67100[3]),  3,3},
  {&(_ZTV7ee67100[9]),  9,9},
  {&(_tg__ZTV5cc100__7ee67100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee67100[];
extern  VTBL_ENTRY _ZTV7ee67100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee67100[];
Class_Descriptor cd_ee67100 = {  "ee67100", // class name
  bases_ee67100, 4,
  &(vtc_ee67100[0]), // expected_vtbl_contents
  &(vtt_ee67100[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee67100),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee67100),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee67100),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee77100  : virtual dd7100 {
  int e;
  virtual void  foo(); // _ZN7ee771003fooEv
  virtual void  bar(); // _ZN7ee771003barEv
  ~ee77100(); // tgen
  ee77100(); // tgen
};
//SIG(1 ee77100) C1{ VBC2{ VBC3{ VBC4{ BC5{ Fi} Fi} Fi} v2 v1 Fi} v1 v2 Fi}


void  ee77100 ::foo(){vfunc_called(this, "_ZN7ee771003fooEv");}
void  ee77100 ::bar(){vfunc_called(this, "_ZN7ee771003barEv");}
ee77100 ::~ee77100(){ note_dtor("ee77100", this);} // tgen
ee77100 ::ee77100(){ note_ctor("ee77100", this);} // tgen

static void Test_ee77100()
{
  extern Class_Descriptor cd_ee77100;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee77100, buf);
    ee77100 *dp, &lv = *(dp=new (buf) ee77100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee77100)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee77100)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(44,24), "ee77100");
    check_base_class_offset(lv, (bb00*)(cc100*), ABISELECT(44,24), "ee77100");
    check_base_class_offset(lv, (cc100*)(dd7100*), ABISELECT(32,16), "ee77100");
    check_base_class_offset(lv, (dd7100*), ABISELECT(16,8), "ee77100");
    check_field_offset(lv, e, ABISELECT(8,4), "ee77100.e");
    test_class_info(&lv, &cd_ee77100);
    dp->~ee77100();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee77100(Test_ee77100, "ee77100", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee77100C1Ev();
extern void _ZN7ee77100D1Ev();
Name_Map name_map_ee77100[] = {
  NSPAIR(_ZN7ee77100C1Ev),
  NSPAIR(_ZN7ee77100D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc100;
extern VTBL_ENTRY _ZTI5cc100[];
extern  VTBL_ENTRY _ZTV5cc100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT5cc100[];
extern Class_Descriptor cd_dd7100;
extern VTBL_ENTRY _ZTI6dd7100[];
extern  VTBL_ENTRY _ZTV6dd7100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7100[];
static Base_Class bases_ee77100[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(44,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_cc100,    ABISELECT(32,16), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7100,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee77100[];
extern void _ZN7ee771003fooEv();
extern void _ZN7ee771003barEv();
extern void ABISELECT(_ZTv0_n40_N7ee771003barEv,_ZTv0_n20_N7ee771003barEv)();
extern void ABISELECT(_ZThn16_N7ee771003barEv,_ZThn8_N7ee771003barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7ee771003fooEv,_ZTv0_n24_N7ee771003fooEv)();
extern void ABISELECT(_ZThn16_N7ee771003fooEv,_ZThn8_N7ee771003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee77100[] = {
  ABISELECT(44,24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee77100[0]),
  (VTBL_ENTRY)&_ZN7ee771003fooEv,
  (VTBL_ENTRY)&_ZN7ee771003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(28,16),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee77100[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7ee771003barEv,_ZTv0_n20_N7ee771003barEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7ee771003fooEv,_ZTv0_n24_N7ee771003fooEv),
  ABISELECT(12,8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee77100[0]),
};
extern VTBL_ENTRY _ZTV7ee77100[];
extern void _ZN6dd71003barEv();
extern void _ZN6dd71003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7100__7ee77100[] = {
  ABISELECT(28,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
  (VTBL_ENTRY)&_ZN6dd71003barEv,
  (VTBL_ENTRY)&_ZN6dd71003fooEv,
};
static  VTBL_ENTRY _tg__ZTV5cc100__6dd7100__7ee77100[] = {
  ABISELECT(12,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7100[0]),
};
static  VTBL_ENTRY _tg__ZTV5cc100__7ee77100[] = {
  ABISELECT(12,8),
  0,
  (VTBL_ENTRY)&(_ZTI5cc100[0]),
};
static  VTT_ENTRY vtt_ee77100[] = {
  {&(_ZTV7ee77100[5]),  5,18},
  {&(_ZTV7ee77100[13]),  13,18},
  {&(_ZTV7ee77100[18]),  18,18},
  {&(_tg__ZTV6dd7100__7ee77100[4]),  4,6},
  {&(_tg__ZTV5cc100__6dd7100__7ee77100[3]),  3,3},
  {&(_tg__ZTV5cc100__7ee77100[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7ee77100[];
extern  VTBL_ENTRY _ZTV7ee77100[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee77100[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7ee771003fooEv,_ZTv0_n24_N7ee771003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771003fooEv,_ZThn8_N7ee771003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7ee771003barEv,_ZTv0_n20_N7ee771003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee771003barEv,_ZThn8_N7ee771003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee77100 = {  "ee77100", // class name
  bases_ee77100, 4,
  &(vtc_ee77100[0]), // expected_vtbl_contents
  &(vtt_ee77100[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee77100),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee77100),18, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee77100),6, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc200  : bb00 {
  int c;
  virtual void  foo(); // _ZN5cc2003fooEv
  ~cc200(); // tgen
  cc200(); // tgen
};
//SIG(-1 cc200) C1{ BC2{ BC3{ Fi} Fi} v1 Fi}


void  cc200 ::foo(){vfunc_called(this, "_ZN5cc2003fooEv");}
cc200 ::~cc200(){ note_dtor("cc200", this);} // tgen
cc200 ::cc200(){ note_ctor("cc200", this);} // tgen

static void Test_cc200()
{
  extern Class_Descriptor cd_cc200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_cc200, buf);
    cc200 *dp, &lv = *(dp=new (buf) cc200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(cc200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc200)");
    check_base_class_offset(lv, (aa0*)(bb00*), ABISELECT(8,4), "cc200");
    check_base_class_offset(lv, (bb00*), ABISELECT(8,4), "cc200");
    check_field_offset(lv, c, ABISELECT(16,12), "cc200.c");
    test_class_info(&lv, &cd_cc200);
    dp->~cc200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc200(Test_cc200, "cc200", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN5cc200C1Ev();
extern void _ZN5cc200D1Ev();
Name_Map name_map_cc200[] = {
  NSPAIR(_ZN5cc200C1Ev),
  NSPAIR(_ZN5cc200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
static Base_Class bases_cc200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5cc200[];
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_cc200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5cc200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
Class_Descriptor cd_cc200 = {  "cc200", // class name
  bases_cc200, 2,
  &(vtc_cc200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI5cc200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV5cc200),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0200  : cc200 {
  int d;
  ~dd0200(); // tgen
  dd0200(); // tgen
};
//SIG(-1 dd0200) C1{ BC2{ BC3{ BC4{ Fi} Fi} v1 Fi} Fi}


dd0200 ::~dd0200(){ note_dtor("dd0200", this);} // tgen
dd0200 ::dd0200(){ note_ctor("dd0200", this);} // tgen

static void Test_dd0200()
{
  extern Class_Descriptor cd_dd0200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd0200, buf);
    dd0200 *dp, &lv = *(dp=new (buf) dd0200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd0200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(8,4), "dd0200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(8,4), "dd0200");
    check_base_class_offset(lv, (cc200*), 0, "dd0200");
    check_field_offset(lv, d, ABISELECT(20,16), "dd0200.d");
    test_class_info(&lv, &cd_dd0200);
    dp->~dd0200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0200(Test_dd0200, "dd0200", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd0200C1Ev();
extern void _ZN6dd0200D1Ev();
Name_Map name_map_dd0200[] = {
  NSPAIR(_ZN6dd0200C1Ev),
  NSPAIR(_ZN6dd0200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd0200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd0200[];
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_dd0200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd0200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
Class_Descriptor cd_dd0200 = {  "dd0200", // class name
  bases_dd0200, 3,
  &(vtc_dd0200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd0200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd0200),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee00200  : dd0200 {
  int e;
  ~ee00200(); // tgen
  ee00200(); // tgen
};
//SIG(1 ee00200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee00200 ::~ee00200(){ note_dtor("ee00200", this);} // tgen
ee00200 ::ee00200(){ note_ctor("ee00200", this);} // tgen

static void Test_ee00200()
{
  extern Class_Descriptor cd_ee00200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee00200, buf);
    ee00200 *dp, &lv = *(dp=new (buf) ee00200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee00200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee00200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee00200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee00200");
    check_base_class_offset(lv, (cc200*)(dd0200*), 0, "ee00200");
    check_base_class_offset(lv, (dd0200*), 0, "ee00200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee00200.e");
    test_class_info(&lv, &cd_ee00200);
    dp->~ee00200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee00200(Test_ee00200, "ee00200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee00200C1Ev();
extern void _ZN7ee00200D1Ev();
Name_Map name_map_ee00200[] = {
  NSPAIR(_ZN7ee00200C1Ev),
  NSPAIR(_ZN7ee00200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee00200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee00200[];
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee00200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee00200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTI7ee00200[];
extern  VTBL_ENTRY _ZTV7ee00200[];
Class_Descriptor cd_ee00200 = {  "ee00200", // class name
  bases_ee00200, 4,
  &(vtc_ee00200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee00200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee00200),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10200  : virtual dd0200 {
  int e;
  ~ee10200(); // tgen
  ee10200(); // tgen
};
//SIG(1 ee10200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee10200 ::~ee10200(){ note_dtor("ee10200", this);} // tgen
ee10200 ::ee10200(){ note_ctor("ee10200", this);} // tgen

static void Test_ee10200()
{
  extern Class_Descriptor cd_ee10200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee10200, buf);
    ee10200 *dp, &lv = *(dp=new (buf) ee10200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee10200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee10200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee10200");
    check_base_class_offset(lv, (cc200*)(dd0200*), ABISELECT(16,8), "ee10200");
    check_base_class_offset(lv, (dd0200*), ABISELECT(16,8), "ee10200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee10200.e");
    test_class_info(&lv, &cd_ee10200);
    dp->~ee10200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10200(Test_ee10200, "ee10200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee10200C1Ev();
extern void _ZN7ee10200D1Ev();
Name_Map name_map_ee10200[] = {
  NSPAIR(_ZN7ee10200C1Ev),
  NSPAIR(_ZN7ee10200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee10200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee10200[];
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee10200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee10200[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee10200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee10200[];
static  VTT_ENTRY vtt_ee10200[] = {
  {&(_ZTV7ee10200[3]),  3,7},
  {&(_ZTV7ee10200[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee10200[];
extern  VTBL_ENTRY _ZTV7ee10200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee10200[];
Class_Descriptor cd_ee10200 = {  "ee10200", // class name
  bases_ee10200, 4,
  &(vtc_ee10200[0]), // expected_vtbl_contents
  &(vtt_ee10200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee10200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee10200),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee10200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20200  : dd0200 {
  int e;
  virtual void  foo(); // _ZN7ee202003fooEv
  ~ee20200(); // tgen
  ee20200(); // tgen
};
//SIG(1 ee20200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee20200 ::foo(){vfunc_called(this, "_ZN7ee202003fooEv");}
ee20200 ::~ee20200(){ note_dtor("ee20200", this);} // tgen
ee20200 ::ee20200(){ note_ctor("ee20200", this);} // tgen

static void Test_ee20200()
{
  extern Class_Descriptor cd_ee20200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee20200, buf);
    ee20200 *dp, &lv = *(dp=new (buf) ee20200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee20200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee20200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee20200");
    check_base_class_offset(lv, (cc200*)(dd0200*), 0, "ee20200");
    check_base_class_offset(lv, (dd0200*), 0, "ee20200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee20200.e");
    test_class_info(&lv, &cd_ee20200);
    dp->~ee20200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20200(Test_ee20200, "ee20200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee20200C1Ev();
extern void _ZN7ee20200D1Ev();
Name_Map name_map_ee20200[] = {
  NSPAIR(_ZN7ee20200C1Ev),
  NSPAIR(_ZN7ee20200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee20200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee20200[];
extern void _ZN7ee202003fooEv();
static  VTBL_ENTRY vtc_ee20200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee20200[0]),
  (VTBL_ENTRY)&_ZN7ee202003fooEv,
};
extern VTBL_ENTRY _ZTI7ee20200[];
extern  VTBL_ENTRY _ZTV7ee20200[];
Class_Descriptor cd_ee20200 = {  "ee20200", // class name
  bases_ee20200, 4,
  &(vtc_ee20200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee20200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee20200),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30200  : virtual dd0200 {
  int e;
  virtual void  foo(); // _ZN7ee302003fooEv
  ~ee30200(); // tgen
  ee30200(); // tgen
};
//SIG(1 ee30200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee30200 ::foo(){vfunc_called(this, "_ZN7ee302003fooEv");}
ee30200 ::~ee30200(){ note_dtor("ee30200", this);} // tgen
ee30200 ::ee30200(){ note_ctor("ee30200", this);} // tgen

static void Test_ee30200()
{
  extern Class_Descriptor cd_ee30200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee30200, buf);
    ee30200 *dp, &lv = *(dp=new (buf) ee30200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee30200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee30200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee30200");
    check_base_class_offset(lv, (cc200*)(dd0200*), ABISELECT(16,8), "ee30200");
    check_base_class_offset(lv, (dd0200*), ABISELECT(16,8), "ee30200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee30200.e");
    test_class_info(&lv, &cd_ee30200);
    dp->~ee30200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30200(Test_ee30200, "ee30200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee30200C1Ev();
extern void _ZN7ee30200D1Ev();
Name_Map name_map_ee30200[] = {
  NSPAIR(_ZN7ee30200C1Ev),
  NSPAIR(_ZN7ee30200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee30200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee30200[];
extern void _ZN7ee302003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee302003fooEv,_ZTv0_n12_N7ee302003fooEv)();
extern void ABISELECT(_ZThn16_N7ee302003fooEv,_ZThn8_N7ee302003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee30200[0]),
  (VTBL_ENTRY)&_ZN7ee302003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee30200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee302003fooEv,_ZTv0_n12_N7ee302003fooEv),
};
extern VTBL_ENTRY _ZTV7ee30200[];
static  VTT_ENTRY vtt_ee30200[] = {
  {&(_ZTV7ee30200[3]),  3,8},
  {&(_ZTV7ee30200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee30200[];
extern  VTBL_ENTRY _ZTV7ee30200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee30200[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee302003fooEv,_ZTv0_n12_N7ee302003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee302003fooEv,_ZThn8_N7ee302003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30200 = {  "ee30200", // class name
  bases_ee30200, 4,
  &(vtc_ee30200[0]), // expected_vtbl_contents
  &(vtt_ee30200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee30200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee30200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee30200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40200  : dd0200 {
  int e;
  virtual void  bar(); // _ZN7ee402003barEv
  ~ee40200(); // tgen
  ee40200(); // tgen
};
//SIG(1 ee40200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee40200 ::bar(){vfunc_called(this, "_ZN7ee402003barEv");}
ee40200 ::~ee40200(){ note_dtor("ee40200", this);} // tgen
ee40200 ::ee40200(){ note_ctor("ee40200", this);} // tgen

static void Test_ee40200()
{
  extern Class_Descriptor cd_ee40200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee40200, buf);
    ee40200 *dp, &lv = *(dp=new (buf) ee40200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee40200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee40200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee40200");
    check_base_class_offset(lv, (cc200*)(dd0200*), 0, "ee40200");
    check_base_class_offset(lv, (dd0200*), 0, "ee40200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee40200.e");
    test_class_info(&lv, &cd_ee40200);
    dp->~ee40200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40200(Test_ee40200, "ee40200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee40200C1Ev();
extern void _ZN7ee40200D1Ev();
Name_Map name_map_ee40200[] = {
  NSPAIR(_ZN7ee40200C1Ev),
  NSPAIR(_ZN7ee40200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee40200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee40200[];
extern void _ZN5cc2003fooEv();
extern void _ZN7ee402003barEv();
static  VTBL_ENTRY vtc_ee40200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee40200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
  (VTBL_ENTRY)&_ZN7ee402003barEv,
};
extern VTBL_ENTRY _ZTI7ee40200[];
extern  VTBL_ENTRY _ZTV7ee40200[];
Class_Descriptor cd_ee40200 = {  "ee40200", // class name
  bases_ee40200, 4,
  &(vtc_ee40200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee40200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee40200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee50200  : virtual dd0200 {
  int e;
  virtual void  bar(); // _ZN7ee502003barEv
  ~ee50200(); // tgen
  ee50200(); // tgen
};
//SIG(1 ee50200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee50200 ::bar(){vfunc_called(this, "_ZN7ee502003barEv");}
ee50200 ::~ee50200(){ note_dtor("ee50200", this);} // tgen
ee50200 ::ee50200(){ note_ctor("ee50200", this);} // tgen

static void Test_ee50200()
{
  extern Class_Descriptor cd_ee50200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee50200, buf);
    ee50200 *dp, &lv = *(dp=new (buf) ee50200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee50200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee50200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee50200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee50200");
    check_base_class_offset(lv, (cc200*)(dd0200*), ABISELECT(16,8), "ee50200");
    check_base_class_offset(lv, (dd0200*), ABISELECT(16,8), "ee50200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee50200.e");
    test_class_info(&lv, &cd_ee50200);
    dp->~ee50200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee50200(Test_ee50200, "ee50200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee50200C1Ev();
extern void _ZN7ee50200D1Ev();
Name_Map name_map_ee50200[] = {
  NSPAIR(_ZN7ee50200C1Ev),
  NSPAIR(_ZN7ee50200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee50200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee50200[];
extern void _ZN7ee502003barEv();
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee50200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee50200[0]),
  (VTBL_ENTRY)&_ZN7ee502003barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee50200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee50200[];
static  VTT_ENTRY vtt_ee50200[] = {
  {&(_ZTV7ee50200[3]),  3,8},
  {&(_ZTV7ee50200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee50200[];
extern  VTBL_ENTRY _ZTV7ee50200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee50200[];
Class_Descriptor cd_ee50200 = {  "ee50200", // class name
  bases_ee50200, 4,
  &(vtc_ee50200[0]), // expected_vtbl_contents
  &(vtt_ee50200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee50200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee50200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee50200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee60200  : dd0200 {
  int e;
  virtual void  foo(); // _ZN7ee602003fooEv
  virtual void  bar(); // _ZN7ee602003barEv
  ~ee60200(); // tgen
  ee60200(); // tgen
};
//SIG(1 ee60200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee60200 ::foo(){vfunc_called(this, "_ZN7ee602003fooEv");}
void  ee60200 ::bar(){vfunc_called(this, "_ZN7ee602003barEv");}
ee60200 ::~ee60200(){ note_dtor("ee60200", this);} // tgen
ee60200 ::ee60200(){ note_ctor("ee60200", this);} // tgen

static void Test_ee60200()
{
  extern Class_Descriptor cd_ee60200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee60200, buf);
    ee60200 *dp, &lv = *(dp=new (buf) ee60200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee60200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee60200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee60200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(8,4), "ee60200");
    check_base_class_offset(lv, (cc200*)(dd0200*), 0, "ee60200");
    check_base_class_offset(lv, (dd0200*), 0, "ee60200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee60200.e");
    test_class_info(&lv, &cd_ee60200);
    dp->~ee60200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee60200(Test_ee60200, "ee60200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee60200C1Ev();
extern void _ZN7ee60200D1Ev();
Name_Map name_map_ee60200[] = {
  NSPAIR(_ZN7ee60200C1Ev),
  NSPAIR(_ZN7ee60200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee60200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee60200[];
extern void _ZN7ee602003fooEv();
extern void _ZN7ee602003barEv();
static  VTBL_ENTRY vtc_ee60200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee60200[0]),
  (VTBL_ENTRY)&_ZN7ee602003fooEv,
  (VTBL_ENTRY)&_ZN7ee602003barEv,
};
extern VTBL_ENTRY _ZTI7ee60200[];
extern  VTBL_ENTRY _ZTV7ee60200[];
Class_Descriptor cd_ee60200 = {  "ee60200", // class name
  bases_ee60200, 4,
  &(vtc_ee60200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee60200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee60200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee70200  : virtual dd0200 {
  int e;
  virtual void  foo(); // _ZN7ee702003fooEv
  virtual void  bar(); // _ZN7ee702003barEv
  ~ee70200(); // tgen
  ee70200(); // tgen
};
//SIG(1 ee70200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee70200 ::foo(){vfunc_called(this, "_ZN7ee702003fooEv");}
void  ee70200 ::bar(){vfunc_called(this, "_ZN7ee702003barEv");}
ee70200 ::~ee70200(){ note_dtor("ee70200", this);} // tgen
ee70200 ::ee70200(){ note_ctor("ee70200", this);} // tgen

static void Test_ee70200()
{
  extern Class_Descriptor cd_ee70200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee70200, buf);
    ee70200 *dp, &lv = *(dp=new (buf) ee70200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee70200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee70200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee70200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd0200*), ABISELECT(24,12), "ee70200");
    check_base_class_offset(lv, (cc200*)(dd0200*), ABISELECT(16,8), "ee70200");
    check_base_class_offset(lv, (dd0200*), ABISELECT(16,8), "ee70200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee70200.e");
    test_class_info(&lv, &cd_ee70200);
    dp->~ee70200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee70200(Test_ee70200, "ee70200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee70200C1Ev();
extern void _ZN7ee70200D1Ev();
Name_Map name_map_ee70200[] = {
  NSPAIR(_ZN7ee70200C1Ev),
  NSPAIR(_ZN7ee70200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd0200;
extern VTBL_ENTRY _ZTI6dd0200[];
extern  VTBL_ENTRY _ZTV6dd0200[];
static Base_Class bases_ee70200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd0200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee70200[];
extern void _ZN7ee702003fooEv();
extern void _ZN7ee702003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee702003fooEv,_ZTv0_n12_N7ee702003fooEv)();
extern void ABISELECT(_ZThn16_N7ee702003fooEv,_ZThn8_N7ee702003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee70200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee70200[0]),
  (VTBL_ENTRY)&_ZN7ee702003fooEv,
  (VTBL_ENTRY)&_ZN7ee702003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee70200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee702003fooEv,_ZTv0_n12_N7ee702003fooEv),
};
extern VTBL_ENTRY _ZTV7ee70200[];
static  VTT_ENTRY vtt_ee70200[] = {
  {&(_ZTV7ee70200[3]),  3,9},
  {&(_ZTV7ee70200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee70200[];
extern  VTBL_ENTRY _ZTV7ee70200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee70200[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee702003fooEv,_ZTv0_n12_N7ee702003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee702003fooEv,_ZThn8_N7ee702003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee70200 = {  "ee70200", // class name
  bases_ee70200, 4,
  &(vtc_ee70200[0]), // expected_vtbl_contents
  &(vtt_ee70200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee70200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee70200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee70200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1200  : virtual cc200 {
  int d;
  ~dd1200(); // tgen
  dd1200(); // tgen
};
//SIG(-1 dd1200) C1{ VBC2{ BC3{ BC4{ Fi} Fi} v1 Fi} Fi}


dd1200 ::~dd1200(){ note_dtor("dd1200", this);} // tgen
dd1200 ::dd1200(){ note_ctor("dd1200", this);} // tgen

static void Test_dd1200()
{
  extern Class_Descriptor cd_dd1200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd1200, buf);
    dd1200 *dp, &lv = *(dp=new (buf) dd1200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd1200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,12), "dd1200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,12), "dd1200");
    check_base_class_offset(lv, (cc200*), ABISELECT(16,8), "dd1200");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1200.d");
    test_class_info(&lv, &cd_dd1200);
    dp->~dd1200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1200(Test_dd1200, "dd1200", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd1200C1Ev();
extern void _ZN6dd1200D1Ev();
Name_Map name_map_dd1200[] = {
  NSPAIR(_ZN6dd1200C1Ev),
  NSPAIR(_ZN6dd1200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd1200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd1200[];
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_dd1200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV6dd1200[];
static  VTT_ENTRY vtt_dd1200[] = {
  {&(_ZTV6dd1200[3]),  3,7},
  {&(_ZTV6dd1200[6]),  6,7},
};
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
Class_Descriptor cd_dd1200 = {  "dd1200", // class name
  bases_dd1200, 3,
  &(vtc_dd1200[0]), // expected_vtbl_contents
  &(vtt_dd1200[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd1200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd1200),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd1200),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee01200  : dd1200 {
  int e;
  ~ee01200(); // tgen
  ee01200(); // tgen
};
//SIG(1 ee01200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee01200 ::~ee01200(){ note_dtor("ee01200", this);} // tgen
ee01200 ::ee01200(){ note_ctor("ee01200", this);} // tgen

static void Test_ee01200()
{
  extern Class_Descriptor cd_ee01200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee01200, buf);
    ee01200 *dp, &lv = *(dp=new (buf) ee01200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee01200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee01200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee01200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee01200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(16,12), "ee01200");
    check_base_class_offset(lv, (dd1200*), 0, "ee01200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee01200.e");
    test_class_info(&lv, &cd_ee01200);
    dp->~ee01200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee01200(Test_ee01200, "ee01200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee01200C1Ev();
extern void _ZN7ee01200D1Ev();
Name_Map name_map_ee01200[] = {
  NSPAIR(_ZN7ee01200C1Ev),
  NSPAIR(_ZN7ee01200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee01200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee01200[];
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee01200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee01200[0]),
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee01200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee01200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee01200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee01200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee01200[] = {
  {&(_ZTV7ee01200[3]),  3,7},
  {&(_tg__ZTV6dd1200__7ee01200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee01200[3]),  3,4},
  {&(_ZTV7ee01200[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee01200[];
extern  VTBL_ENTRY _ZTV7ee01200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee01200[];
Class_Descriptor cd_ee01200 = {  "ee01200", // class name
  bases_ee01200, 4,
  &(vtc_ee01200[0]), // expected_vtbl_contents
  &(vtt_ee01200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee01200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee01200),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee01200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11200  : virtual dd1200 {
  int e;
  ~ee11200(); // tgen
  ee11200(); // tgen
};
//SIG(1 ee11200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} Fi}


ee11200 ::~ee11200(){ note_dtor("ee11200", this);} // tgen
ee11200 ::ee11200(){ note_ctor("ee11200", this);} // tgen

static void Test_ee11200()
{
  extern Class_Descriptor cd_ee11200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee11200, buf);
    ee11200 *dp, &lv = *(dp=new (buf) ee11200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee11200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee11200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee11200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(32,16), "ee11200");
    check_base_class_offset(lv, (dd1200*), ABISELECT(16,8), "ee11200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11200.e");
    test_class_info(&lv, &cd_ee11200);
    dp->~ee11200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11200(Test_ee11200, "ee11200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee11200C1Ev();
extern void _ZN7ee11200D1Ev();
Name_Map name_map_ee11200[] = {
  NSPAIR(_ZN7ee11200C1Ev),
  NSPAIR(_ZN7ee11200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee11200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee11200[];
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee11200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee11200[0]),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee11200[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee11200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee11200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee11200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee11200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee11200[] = {
  {&(_ZTV7ee11200[4]),  4,11},
  {&(_ZTV7ee11200[7]),  7,11},
  {&(_ZTV7ee11200[10]),  10,11},
  {&(_tg__ZTV6dd1200__7ee11200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee11200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee11200[];
extern  VTBL_ENTRY _ZTV7ee11200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee11200[];
Class_Descriptor cd_ee11200 = {  "ee11200", // class name
  bases_ee11200, 4,
  &(vtc_ee11200[0]), // expected_vtbl_contents
  &(vtt_ee11200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee11200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee11200),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee11200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21200  : dd1200 {
  int e;
  virtual void  foo(); // _ZN7ee212003fooEv
  ~ee21200(); // tgen
  ee21200(); // tgen
};
//SIG(1 ee21200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee21200 ::foo(){vfunc_called(this, "_ZN7ee212003fooEv");}
ee21200 ::~ee21200(){ note_dtor("ee21200", this);} // tgen
ee21200 ::ee21200(){ note_ctor("ee21200", this);} // tgen

static void Test_ee21200()
{
  extern Class_Descriptor cd_ee21200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee21200, buf);
    ee21200 *dp, &lv = *(dp=new (buf) ee21200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee21200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee21200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee21200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(16,12), "ee21200");
    check_base_class_offset(lv, (dd1200*), 0, "ee21200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21200.e");
    test_class_info(&lv, &cd_ee21200);
    dp->~ee21200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21200(Test_ee21200, "ee21200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee21200C1Ev();
extern void _ZN7ee21200D1Ev();
Name_Map name_map_ee21200[] = {
  NSPAIR(_ZN7ee21200C1Ev),
  NSPAIR(_ZN7ee21200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee21200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee21200[];
extern void _ZN7ee212003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee212003fooEv,_ZTv0_n12_N7ee212003fooEv)();
extern void ABISELECT(_ZThn16_N7ee212003fooEv,_ZThn12_N7ee212003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee21200[0]),
  (VTBL_ENTRY)&_ZN7ee212003fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee21200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee212003fooEv,_ZTv0_n12_N7ee212003fooEv),
};
extern VTBL_ENTRY _ZTV7ee21200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee21200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee21200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee21200[] = {
  {&(_ZTV7ee21200[3]),  3,8},
  {&(_tg__ZTV6dd1200__7ee21200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee21200[3]),  3,4},
  {&(_ZTV7ee21200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee21200[];
extern  VTBL_ENTRY _ZTV7ee21200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee21200[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee212003fooEv,_ZTv0_n12_N7ee212003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee212003fooEv,_ZThn12_N7ee212003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21200 = {  "ee21200", // class name
  bases_ee21200, 4,
  &(vtc_ee21200[0]), // expected_vtbl_contents
  &(vtt_ee21200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee21200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee21200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee21200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31200  : virtual dd1200 {
  int e;
  virtual void  foo(); // _ZN7ee312003fooEv
  ~ee31200(); // tgen
  ee31200(); // tgen
};
//SIG(1 ee31200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 Fi}


void  ee31200 ::foo(){vfunc_called(this, "_ZN7ee312003fooEv");}
ee31200 ::~ee31200(){ note_dtor("ee31200", this);} // tgen
ee31200 ::ee31200(){ note_ctor("ee31200", this);} // tgen

static void Test_ee31200()
{
  extern Class_Descriptor cd_ee31200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee31200, buf);
    ee31200 *dp, &lv = *(dp=new (buf) ee31200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee31200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee31200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee31200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(32,16), "ee31200");
    check_base_class_offset(lv, (dd1200*), ABISELECT(16,8), "ee31200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31200.e");
    test_class_info(&lv, &cd_ee31200);
    dp->~ee31200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31200(Test_ee31200, "ee31200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee31200C1Ev();
extern void _ZN7ee31200D1Ev();
Name_Map name_map_ee31200[] = {
  NSPAIR(_ZN7ee31200C1Ev),
  NSPAIR(_ZN7ee31200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee31200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee31200[];
extern void _ZN7ee312003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee312003fooEv,_ZTv0_n12_N7ee312003fooEv)();
extern void ABISELECT(_ZThn32_N7ee312003fooEv,_ZThn16_N7ee312003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee31200[0]),
  (VTBL_ENTRY)&_ZN7ee312003fooEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee31200[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee31200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee312003fooEv,_ZTv0_n12_N7ee312003fooEv),
};
extern VTBL_ENTRY _ZTV7ee31200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee31200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee31200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee31200[] = {
  {&(_ZTV7ee31200[4]),  4,12},
  {&(_ZTV7ee31200[8]),  8,12},
  {&(_ZTV7ee31200[11]),  11,12},
  {&(_tg__ZTV6dd1200__7ee31200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee31200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee31200[];
extern  VTBL_ENTRY _ZTV7ee31200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee31200[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee312003fooEv,_ZTv0_n12_N7ee312003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee312003fooEv,_ZThn16_N7ee312003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31200 = {  "ee31200", // class name
  bases_ee31200, 4,
  &(vtc_ee31200[0]), // expected_vtbl_contents
  &(vtt_ee31200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee31200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee31200),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee31200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41200  : dd1200 {
  int e;
  virtual void  bar(); // _ZN7ee412003barEv
  ~ee41200(); // tgen
  ee41200(); // tgen
};
//SIG(1 ee41200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee41200 ::bar(){vfunc_called(this, "_ZN7ee412003barEv");}
ee41200 ::~ee41200(){ note_dtor("ee41200", this);} // tgen
ee41200 ::ee41200(){ note_ctor("ee41200", this);} // tgen

static void Test_ee41200()
{
  extern Class_Descriptor cd_ee41200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee41200, buf);
    ee41200 *dp, &lv = *(dp=new (buf) ee41200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee41200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee41200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee41200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(16,12), "ee41200");
    check_base_class_offset(lv, (dd1200*), 0, "ee41200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41200.e");
    test_class_info(&lv, &cd_ee41200);
    dp->~ee41200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41200(Test_ee41200, "ee41200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee41200C1Ev();
extern void _ZN7ee41200D1Ev();
Name_Map name_map_ee41200[] = {
  NSPAIR(_ZN7ee41200C1Ev),
  NSPAIR(_ZN7ee41200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee41200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee41200[];
extern void _ZN7ee412003barEv();
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee41200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee41200[0]),
  (VTBL_ENTRY)&_ZN7ee412003barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee41200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee41200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee41200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee41200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee41200[] = {
  {&(_ZTV7ee41200[3]),  3,8},
  {&(_tg__ZTV6dd1200__7ee41200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee41200[3]),  3,4},
  {&(_ZTV7ee41200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee41200[];
extern  VTBL_ENTRY _ZTV7ee41200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee41200[];
Class_Descriptor cd_ee41200 = {  "ee41200", // class name
  bases_ee41200, 4,
  &(vtc_ee41200[0]), // expected_vtbl_contents
  &(vtt_ee41200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee41200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee41200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee41200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee51200  : virtual dd1200 {
  int e;
  virtual void  bar(); // _ZN7ee512003barEv
  ~ee51200(); // tgen
  ee51200(); // tgen
};
//SIG(1 ee51200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} Fi} v1 Fi}


void  ee51200 ::bar(){vfunc_called(this, "_ZN7ee512003barEv");}
ee51200 ::~ee51200(){ note_dtor("ee51200", this);} // tgen
ee51200 ::ee51200(){ note_ctor("ee51200", this);} // tgen

static void Test_ee51200()
{
  extern Class_Descriptor cd_ee51200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee51200, buf);
    ee51200 *dp, &lv = *(dp=new (buf) ee51200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee51200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee51200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee51200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee51200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(32,16), "ee51200");
    check_base_class_offset(lv, (dd1200*), ABISELECT(16,8), "ee51200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee51200.e");
    test_class_info(&lv, &cd_ee51200);
    dp->~ee51200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee51200(Test_ee51200, "ee51200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee51200C1Ev();
extern void _ZN7ee51200D1Ev();
Name_Map name_map_ee51200[] = {
  NSPAIR(_ZN7ee51200C1Ev),
  NSPAIR(_ZN7ee51200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee51200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee51200[];
extern void _ZN7ee512003barEv();
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee51200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee51200[0]),
  (VTBL_ENTRY)&_ZN7ee512003barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee51200[0]),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee51200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee51200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee51200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee51200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee51200[] = {
  {&(_ZTV7ee51200[4]),  4,12},
  {&(_ZTV7ee51200[8]),  8,12},
  {&(_ZTV7ee51200[11]),  11,12},
  {&(_tg__ZTV6dd1200__7ee51200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee51200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee51200[];
extern  VTBL_ENTRY _ZTV7ee51200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee51200[];
Class_Descriptor cd_ee51200 = {  "ee51200", // class name
  bases_ee51200, 4,
  &(vtc_ee51200[0]), // expected_vtbl_contents
  &(vtt_ee51200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee51200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee51200),12, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee51200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee61200  : dd1200 {
  int e;
  virtual void  foo(); // _ZN7ee612003fooEv
  virtual void  bar(); // _ZN7ee612003barEv
  ~ee61200(); // tgen
  ee61200(); // tgen
};
//SIG(1 ee61200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee61200 ::foo(){vfunc_called(this, "_ZN7ee612003fooEv");}
void  ee61200 ::bar(){vfunc_called(this, "_ZN7ee612003barEv");}
ee61200 ::~ee61200(){ note_dtor("ee61200", this);} // tgen
ee61200 ::ee61200(){ note_ctor("ee61200", this);} // tgen

static void Test_ee61200()
{
  extern Class_Descriptor cd_ee61200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee61200, buf);
    ee61200 *dp, &lv = *(dp=new (buf) ee61200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee61200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee61200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee61200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee61200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(16,12), "ee61200");
    check_base_class_offset(lv, (dd1200*), 0, "ee61200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee61200.e");
    test_class_info(&lv, &cd_ee61200);
    dp->~ee61200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee61200(Test_ee61200, "ee61200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee61200C1Ev();
extern void _ZN7ee61200D1Ev();
Name_Map name_map_ee61200[] = {
  NSPAIR(_ZN7ee61200C1Ev),
  NSPAIR(_ZN7ee61200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee61200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee61200[];
extern void _ZN7ee612003fooEv();
extern void _ZN7ee612003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee612003fooEv,_ZTv0_n12_N7ee612003fooEv)();
extern void ABISELECT(_ZThn16_N7ee612003fooEv,_ZThn12_N7ee612003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee61200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee61200[0]),
  (VTBL_ENTRY)&_ZN7ee612003fooEv,
  (VTBL_ENTRY)&_ZN7ee612003barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee61200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee612003fooEv,_ZTv0_n12_N7ee612003fooEv),
};
extern VTBL_ENTRY _ZTV7ee61200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee61200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee61200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee61200[] = {
  {&(_ZTV7ee61200[3]),  3,9},
  {&(_tg__ZTV6dd1200__7ee61200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee61200[3]),  3,4},
  {&(_ZTV7ee61200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee61200[];
extern  VTBL_ENTRY _ZTV7ee61200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee61200[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee612003fooEv,_ZTv0_n12_N7ee612003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee612003fooEv,_ZThn12_N7ee612003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee61200 = {  "ee61200", // class name
  bases_ee61200, 4,
  &(vtc_ee61200[0]), // expected_vtbl_contents
  &(vtt_ee61200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee61200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee61200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee61200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee71200  : virtual dd1200 {
  int e;
  virtual void  foo(); // _ZN7ee712003fooEv
  virtual void  bar(); // _ZN7ee712003barEv
  ~ee71200(); // tgen
  ee71200(); // tgen
};
//SIG(1 ee71200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} Fi} v1 v2 Fi}


void  ee71200 ::foo(){vfunc_called(this, "_ZN7ee712003fooEv");}
void  ee71200 ::bar(){vfunc_called(this, "_ZN7ee712003barEv");}
ee71200 ::~ee71200(){ note_dtor("ee71200", this);} // tgen
ee71200 ::ee71200(){ note_ctor("ee71200", this);} // tgen

static void Test_ee71200()
{
  extern Class_Descriptor cd_ee71200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee71200, buf);
    ee71200 *dp, &lv = *(dp=new (buf) ee71200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee71200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee71200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee71200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee71200");
    check_base_class_offset(lv, (cc200*)(dd1200*), ABISELECT(32,16), "ee71200");
    check_base_class_offset(lv, (dd1200*), ABISELECT(16,8), "ee71200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee71200.e");
    test_class_info(&lv, &cd_ee71200);
    dp->~ee71200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee71200(Test_ee71200, "ee71200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee71200C1Ev();
extern void _ZN7ee71200D1Ev();
Name_Map name_map_ee71200[] = {
  NSPAIR(_ZN7ee71200C1Ev),
  NSPAIR(_ZN7ee71200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd1200;
extern VTBL_ENTRY _ZTI6dd1200[];
extern  VTBL_ENTRY _ZTV6dd1200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd1200[];
static Base_Class bases_ee71200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd1200,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee71200[];
extern void _ZN7ee712003fooEv();
extern void _ZN7ee712003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee712003fooEv,_ZTv0_n12_N7ee712003fooEv)();
extern void ABISELECT(_ZThn32_N7ee712003fooEv,_ZThn16_N7ee712003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee71200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee71200[0]),
  (VTBL_ENTRY)&_ZN7ee712003fooEv,
  (VTBL_ENTRY)&_ZN7ee712003barEv,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee71200[0]),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee71200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee712003fooEv,_ZTv0_n12_N7ee712003fooEv),
};
extern VTBL_ENTRY _ZTV7ee71200[];
static  VTBL_ENTRY _tg__ZTV6dd1200__7ee71200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd1200__7ee71200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd1200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee71200[] = {
  {&(_ZTV7ee71200[4]),  4,13},
  {&(_ZTV7ee71200[9]),  9,13},
  {&(_ZTV7ee71200[12]),  12,13},
  {&(_tg__ZTV6dd1200__7ee71200[3]),  3,3},
  {&(_tg__ZTV5cc200__6dd1200__7ee71200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee71200[];
extern  VTBL_ENTRY _ZTV7ee71200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee71200[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee712003fooEv,_ZTv0_n12_N7ee712003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee712003fooEv,_ZThn16_N7ee712003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee71200 = {  "ee71200", // class name
  bases_ee71200, 4,
  &(vtc_ee71200[0]), // expected_vtbl_contents
  &(vtt_ee71200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee71200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee71200),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee71200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2200  : cc200 {
  int d;
  virtual void  foo(); // _ZN6dd22003fooEv
  ~dd2200(); // tgen
  dd2200(); // tgen
};
//SIG(-1 dd2200) C1{ BC2{ BC3{ BC4{ Fi} Fi} v1 Fi} v1 Fi}


void  dd2200 ::foo(){vfunc_called(this, "_ZN6dd22003fooEv");}
dd2200 ::~dd2200(){ note_dtor("dd2200", this);} // tgen
dd2200 ::dd2200(){ note_ctor("dd2200", this);} // tgen

static void Test_dd2200()
{
  extern Class_Descriptor cd_dd2200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd2200, buf);
    dd2200 *dp, &lv = *(dp=new (buf) dd2200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd2200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(8,4), "dd2200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(8,4), "dd2200");
    check_base_class_offset(lv, (cc200*), 0, "dd2200");
    check_field_offset(lv, d, ABISELECT(20,16), "dd2200.d");
    test_class_info(&lv, &cd_dd2200);
    dp->~dd2200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2200(Test_dd2200, "dd2200", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd2200C1Ev();
extern void _ZN6dd2200D1Ev();
Name_Map name_map_dd2200[] = {
  NSPAIR(_ZN6dd2200C1Ev),
  NSPAIR(_ZN6dd2200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd2200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd2200[];
extern void _ZN6dd22003fooEv();
static  VTBL_ENTRY vtc_dd2200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd2200[0]),
  (VTBL_ENTRY)&_ZN6dd22003fooEv,
};
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
Class_Descriptor cd_dd2200 = {  "dd2200", // class name
  bases_dd2200, 3,
  &(vtc_dd2200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd2200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd2200),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee02200  : dd2200 {
  int e;
  ~ee02200(); // tgen
  ee02200(); // tgen
};
//SIG(1 ee02200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee02200 ::~ee02200(){ note_dtor("ee02200", this);} // tgen
ee02200 ::ee02200(){ note_ctor("ee02200", this);} // tgen

static void Test_ee02200()
{
  extern Class_Descriptor cd_ee02200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee02200, buf);
    ee02200 *dp, &lv = *(dp=new (buf) ee02200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee02200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee02200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee02200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee02200");
    check_base_class_offset(lv, (cc200*)(dd2200*), 0, "ee02200");
    check_base_class_offset(lv, (dd2200*), 0, "ee02200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee02200.e");
    test_class_info(&lv, &cd_ee02200);
    dp->~ee02200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee02200(Test_ee02200, "ee02200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee02200C1Ev();
extern void _ZN7ee02200D1Ev();
Name_Map name_map_ee02200[] = {
  NSPAIR(_ZN7ee02200C1Ev),
  NSPAIR(_ZN7ee02200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee02200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee02200[];
extern void _ZN6dd22003fooEv();
static  VTBL_ENTRY vtc_ee02200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee02200[0]),
  (VTBL_ENTRY)&_ZN6dd22003fooEv,
};
extern VTBL_ENTRY _ZTI7ee02200[];
extern  VTBL_ENTRY _ZTV7ee02200[];
Class_Descriptor cd_ee02200 = {  "ee02200", // class name
  bases_ee02200, 4,
  &(vtc_ee02200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee02200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee02200),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12200  : virtual dd2200 {
  int e;
  ~ee12200(); // tgen
  ee12200(); // tgen
};
//SIG(1 ee12200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee12200 ::~ee12200(){ note_dtor("ee12200", this);} // tgen
ee12200 ::ee12200(){ note_ctor("ee12200", this);} // tgen

static void Test_ee12200()
{
  extern Class_Descriptor cd_ee12200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee12200, buf);
    ee12200 *dp, &lv = *(dp=new (buf) ee12200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee12200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee12200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee12200");
    check_base_class_offset(lv, (cc200*)(dd2200*), ABISELECT(16,8), "ee12200");
    check_base_class_offset(lv, (dd2200*), ABISELECT(16,8), "ee12200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee12200.e");
    test_class_info(&lv, &cd_ee12200);
    dp->~ee12200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12200(Test_ee12200, "ee12200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee12200C1Ev();
extern void _ZN7ee12200D1Ev();
Name_Map name_map_ee12200[] = {
  NSPAIR(_ZN7ee12200C1Ev),
  NSPAIR(_ZN7ee12200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee12200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee12200[];
extern void _ZN6dd22003fooEv();
static  VTBL_ENTRY vtc_ee12200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee12200[0]),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee12200[0]),
  (VTBL_ENTRY)&_ZN6dd22003fooEv,
};
extern VTBL_ENTRY _ZTV7ee12200[];
static  VTT_ENTRY vtt_ee12200[] = {
  {&(_ZTV7ee12200[3]),  3,7},
  {&(_ZTV7ee12200[6]),  6,7},
};
extern VTBL_ENTRY _ZTI7ee12200[];
extern  VTBL_ENTRY _ZTV7ee12200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee12200[];
Class_Descriptor cd_ee12200 = {  "ee12200", // class name
  bases_ee12200, 4,
  &(vtc_ee12200[0]), // expected_vtbl_contents
  &(vtt_ee12200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee12200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee12200),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee12200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22200  : dd2200 {
  int e;
  virtual void  foo(); // _ZN7ee222003fooEv
  ~ee22200(); // tgen
  ee22200(); // tgen
};
//SIG(1 ee22200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee22200 ::foo(){vfunc_called(this, "_ZN7ee222003fooEv");}
ee22200 ::~ee22200(){ note_dtor("ee22200", this);} // tgen
ee22200 ::ee22200(){ note_ctor("ee22200", this);} // tgen

static void Test_ee22200()
{
  extern Class_Descriptor cd_ee22200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee22200, buf);
    ee22200 *dp, &lv = *(dp=new (buf) ee22200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee22200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee22200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee22200");
    check_base_class_offset(lv, (cc200*)(dd2200*), 0, "ee22200");
    check_base_class_offset(lv, (dd2200*), 0, "ee22200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee22200.e");
    test_class_info(&lv, &cd_ee22200);
    dp->~ee22200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22200(Test_ee22200, "ee22200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee22200C1Ev();
extern void _ZN7ee22200D1Ev();
Name_Map name_map_ee22200[] = {
  NSPAIR(_ZN7ee22200C1Ev),
  NSPAIR(_ZN7ee22200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee22200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee22200[];
extern void _ZN7ee222003fooEv();
static  VTBL_ENTRY vtc_ee22200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee22200[0]),
  (VTBL_ENTRY)&_ZN7ee222003fooEv,
};
extern VTBL_ENTRY _ZTI7ee22200[];
extern  VTBL_ENTRY _ZTV7ee22200[];
Class_Descriptor cd_ee22200 = {  "ee22200", // class name
  bases_ee22200, 4,
  &(vtc_ee22200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee22200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee22200),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32200  : virtual dd2200 {
  int e;
  virtual void  foo(); // _ZN7ee322003fooEv
  ~ee32200(); // tgen
  ee32200(); // tgen
};
//SIG(1 ee32200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee32200 ::foo(){vfunc_called(this, "_ZN7ee322003fooEv");}
ee32200 ::~ee32200(){ note_dtor("ee32200", this);} // tgen
ee32200 ::ee32200(){ note_ctor("ee32200", this);} // tgen

static void Test_ee32200()
{
  extern Class_Descriptor cd_ee32200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee32200, buf);
    ee32200 *dp, &lv = *(dp=new (buf) ee32200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee32200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee32200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee32200");
    check_base_class_offset(lv, (cc200*)(dd2200*), ABISELECT(16,8), "ee32200");
    check_base_class_offset(lv, (dd2200*), ABISELECT(16,8), "ee32200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee32200.e");
    test_class_info(&lv, &cd_ee32200);
    dp->~ee32200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32200(Test_ee32200, "ee32200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee32200C1Ev();
extern void _ZN7ee32200D1Ev();
Name_Map name_map_ee32200[] = {
  NSPAIR(_ZN7ee32200C1Ev),
  NSPAIR(_ZN7ee32200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee32200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee32200[];
extern void _ZN7ee322003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee322003fooEv,_ZTv0_n12_N7ee322003fooEv)();
extern void ABISELECT(_ZThn16_N7ee322003fooEv,_ZThn8_N7ee322003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee32200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee32200[0]),
  (VTBL_ENTRY)&_ZN7ee322003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee32200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee322003fooEv,_ZTv0_n12_N7ee322003fooEv),
};
extern VTBL_ENTRY _ZTV7ee32200[];
static  VTT_ENTRY vtt_ee32200[] = {
  {&(_ZTV7ee32200[3]),  3,8},
  {&(_ZTV7ee32200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee32200[];
extern  VTBL_ENTRY _ZTV7ee32200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee32200[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee322003fooEv,_ZTv0_n12_N7ee322003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee322003fooEv,_ZThn8_N7ee322003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee32200 = {  "ee32200", // class name
  bases_ee32200, 4,
  &(vtc_ee32200[0]), // expected_vtbl_contents
  &(vtt_ee32200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee32200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee32200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee32200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42200  : dd2200 {
  int e;
  virtual void  bar(); // _ZN7ee422003barEv
  ~ee42200(); // tgen
  ee42200(); // tgen
};
//SIG(1 ee42200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee42200 ::bar(){vfunc_called(this, "_ZN7ee422003barEv");}
ee42200 ::~ee42200(){ note_dtor("ee42200", this);} // tgen
ee42200 ::ee42200(){ note_ctor("ee42200", this);} // tgen

static void Test_ee42200()
{
  extern Class_Descriptor cd_ee42200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee42200, buf);
    ee42200 *dp, &lv = *(dp=new (buf) ee42200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee42200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee42200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee42200");
    check_base_class_offset(lv, (cc200*)(dd2200*), 0, "ee42200");
    check_base_class_offset(lv, (dd2200*), 0, "ee42200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee42200.e");
    test_class_info(&lv, &cd_ee42200);
    dp->~ee42200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42200(Test_ee42200, "ee42200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee42200C1Ev();
extern void _ZN7ee42200D1Ev();
Name_Map name_map_ee42200[] = {
  NSPAIR(_ZN7ee42200C1Ev),
  NSPAIR(_ZN7ee42200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee42200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee42200[];
extern void _ZN6dd22003fooEv();
extern void _ZN7ee422003barEv();
static  VTBL_ENTRY vtc_ee42200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee42200[0]),
  (VTBL_ENTRY)&_ZN6dd22003fooEv,
  (VTBL_ENTRY)&_ZN7ee422003barEv,
};
extern VTBL_ENTRY _ZTI7ee42200[];
extern  VTBL_ENTRY _ZTV7ee42200[];
Class_Descriptor cd_ee42200 = {  "ee42200", // class name
  bases_ee42200, 4,
  &(vtc_ee42200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee42200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee42200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee52200  : virtual dd2200 {
  int e;
  virtual void  bar(); // _ZN7ee522003barEv
  ~ee52200(); // tgen
  ee52200(); // tgen
};
//SIG(1 ee52200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee52200 ::bar(){vfunc_called(this, "_ZN7ee522003barEv");}
ee52200 ::~ee52200(){ note_dtor("ee52200", this);} // tgen
ee52200 ::ee52200(){ note_ctor("ee52200", this);} // tgen

static void Test_ee52200()
{
  extern Class_Descriptor cd_ee52200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee52200, buf);
    ee52200 *dp, &lv = *(dp=new (buf) ee52200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee52200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee52200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee52200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee52200");
    check_base_class_offset(lv, (cc200*)(dd2200*), ABISELECT(16,8), "ee52200");
    check_base_class_offset(lv, (dd2200*), ABISELECT(16,8), "ee52200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee52200.e");
    test_class_info(&lv, &cd_ee52200);
    dp->~ee52200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee52200(Test_ee52200, "ee52200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee52200C1Ev();
extern void _ZN7ee52200D1Ev();
Name_Map name_map_ee52200[] = {
  NSPAIR(_ZN7ee52200C1Ev),
  NSPAIR(_ZN7ee52200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee52200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee52200[];
extern void _ZN7ee522003barEv();
extern void _ZN6dd22003fooEv();
static  VTBL_ENTRY vtc_ee52200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee52200[0]),
  (VTBL_ENTRY)&_ZN7ee522003barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee52200[0]),
  (VTBL_ENTRY)&_ZN6dd22003fooEv,
};
extern VTBL_ENTRY _ZTV7ee52200[];
static  VTT_ENTRY vtt_ee52200[] = {
  {&(_ZTV7ee52200[3]),  3,8},
  {&(_ZTV7ee52200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee52200[];
extern  VTBL_ENTRY _ZTV7ee52200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee52200[];
Class_Descriptor cd_ee52200 = {  "ee52200", // class name
  bases_ee52200, 4,
  &(vtc_ee52200[0]), // expected_vtbl_contents
  &(vtt_ee52200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee52200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee52200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee52200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee62200  : dd2200 {
  int e;
  virtual void  foo(); // _ZN7ee622003fooEv
  virtual void  bar(); // _ZN7ee622003barEv
  ~ee62200(); // tgen
  ee62200(); // tgen
};
//SIG(1 ee62200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee62200 ::foo(){vfunc_called(this, "_ZN7ee622003fooEv");}
void  ee62200 ::bar(){vfunc_called(this, "_ZN7ee622003barEv");}
ee62200 ::~ee62200(){ note_dtor("ee62200", this);} // tgen
ee62200 ::ee62200(){ note_ctor("ee62200", this);} // tgen

static void Test_ee62200()
{
  extern Class_Descriptor cd_ee62200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee62200, buf);
    ee62200 *dp, &lv = *(dp=new (buf) ee62200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee62200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee62200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee62200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(8,4), "ee62200");
    check_base_class_offset(lv, (cc200*)(dd2200*), 0, "ee62200");
    check_base_class_offset(lv, (dd2200*), 0, "ee62200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee62200.e");
    test_class_info(&lv, &cd_ee62200);
    dp->~ee62200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee62200(Test_ee62200, "ee62200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee62200C1Ev();
extern void _ZN7ee62200D1Ev();
Name_Map name_map_ee62200[] = {
  NSPAIR(_ZN7ee62200C1Ev),
  NSPAIR(_ZN7ee62200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee62200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee62200[];
extern void _ZN7ee622003fooEv();
extern void _ZN7ee622003barEv();
static  VTBL_ENTRY vtc_ee62200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee62200[0]),
  (VTBL_ENTRY)&_ZN7ee622003fooEv,
  (VTBL_ENTRY)&_ZN7ee622003barEv,
};
extern VTBL_ENTRY _ZTI7ee62200[];
extern  VTBL_ENTRY _ZTV7ee62200[];
Class_Descriptor cd_ee62200 = {  "ee62200", // class name
  bases_ee62200, 4,
  &(vtc_ee62200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee62200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee62200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee72200  : virtual dd2200 {
  int e;
  virtual void  foo(); // _ZN7ee722003fooEv
  virtual void  bar(); // _ZN7ee722003barEv
  ~ee72200(); // tgen
  ee72200(); // tgen
};
//SIG(1 ee72200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee72200 ::foo(){vfunc_called(this, "_ZN7ee722003fooEv");}
void  ee72200 ::bar(){vfunc_called(this, "_ZN7ee722003barEv");}
ee72200 ::~ee72200(){ note_dtor("ee72200", this);} // tgen
ee72200 ::ee72200(){ note_ctor("ee72200", this);} // tgen

static void Test_ee72200()
{
  extern Class_Descriptor cd_ee72200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee72200, buf);
    ee72200 *dp, &lv = *(dp=new (buf) ee72200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee72200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee72200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee72200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd2200*), ABISELECT(24,12), "ee72200");
    check_base_class_offset(lv, (cc200*)(dd2200*), ABISELECT(16,8), "ee72200");
    check_base_class_offset(lv, (dd2200*), ABISELECT(16,8), "ee72200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee72200.e");
    test_class_info(&lv, &cd_ee72200);
    dp->~ee72200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee72200(Test_ee72200, "ee72200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee72200C1Ev();
extern void _ZN7ee72200D1Ev();
Name_Map name_map_ee72200[] = {
  NSPAIR(_ZN7ee72200C1Ev),
  NSPAIR(_ZN7ee72200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd2200;
extern VTBL_ENTRY _ZTI6dd2200[];
extern  VTBL_ENTRY _ZTV6dd2200[];
static Base_Class bases_ee72200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd2200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee72200[];
extern void _ZN7ee722003fooEv();
extern void _ZN7ee722003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee722003fooEv,_ZTv0_n12_N7ee722003fooEv)();
extern void ABISELECT(_ZThn16_N7ee722003fooEv,_ZThn8_N7ee722003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee72200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee72200[0]),
  (VTBL_ENTRY)&_ZN7ee722003fooEv,
  (VTBL_ENTRY)&_ZN7ee722003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee72200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee722003fooEv,_ZTv0_n12_N7ee722003fooEv),
};
extern VTBL_ENTRY _ZTV7ee72200[];
static  VTT_ENTRY vtt_ee72200[] = {
  {&(_ZTV7ee72200[3]),  3,9},
  {&(_ZTV7ee72200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee72200[];
extern  VTBL_ENTRY _ZTV7ee72200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee72200[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee722003fooEv,_ZTv0_n12_N7ee722003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee722003fooEv,_ZThn8_N7ee722003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee72200 = {  "ee72200", // class name
  bases_ee72200, 4,
  &(vtc_ee72200[0]), // expected_vtbl_contents
  &(vtt_ee72200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee72200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee72200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee72200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3200  : virtual cc200 {
  int d;
  virtual void  foo(); // _ZN6dd32003fooEv
  ~dd3200(); // tgen
  dd3200(); // tgen
};
//SIG(-1 dd3200) C1{ VBC2{ BC3{ BC4{ Fi} Fi} v1 Fi} v1 Fi}


void  dd3200 ::foo(){vfunc_called(this, "_ZN6dd32003fooEv");}
dd3200 ::~dd3200(){ note_dtor("dd3200", this);} // tgen
dd3200 ::dd3200(){ note_ctor("dd3200", this);} // tgen

static void Test_dd3200()
{
  extern Class_Descriptor cd_dd3200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd3200, buf);
    dd3200 *dp, &lv = *(dp=new (buf) dd3200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd3200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,12), "dd3200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,12), "dd3200");
    check_base_class_offset(lv, (cc200*), ABISELECT(16,8), "dd3200");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3200.d");
    test_class_info(&lv, &cd_dd3200);
    dp->~dd3200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3200(Test_dd3200, "dd3200", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd3200C1Ev();
extern void _ZN6dd3200D1Ev();
Name_Map name_map_dd3200[] = {
  NSPAIR(_ZN6dd3200C1Ev),
  NSPAIR(_ZN6dd3200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd3200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd3200[];
extern void _ZN6dd32003fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd3200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
extern VTBL_ENTRY _ZTV6dd3200[];
static  VTT_ENTRY vtt_dd3200[] = {
  {&(_ZTV6dd3200[3]),  3,8},
  {&(_ZTV6dd3200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd3200 = {  "dd3200", // class name
  bases_dd3200, 3,
  &(vtc_dd3200[0]), // expected_vtbl_contents
  &(vtt_dd3200[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd3200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd3200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd3200),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee03200  : dd3200 {
  int e;
  ~ee03200(); // tgen
  ee03200(); // tgen
};
//SIG(1 ee03200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee03200 ::~ee03200(){ note_dtor("ee03200", this);} // tgen
ee03200 ::ee03200(){ note_ctor("ee03200", this);} // tgen

static void Test_ee03200()
{
  extern Class_Descriptor cd_ee03200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee03200, buf);
    ee03200 *dp, &lv = *(dp=new (buf) ee03200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee03200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee03200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee03200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee03200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(16,12), "ee03200");
    check_base_class_offset(lv, (dd3200*), 0, "ee03200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee03200.e");
    test_class_info(&lv, &cd_ee03200);
    dp->~ee03200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee03200(Test_ee03200, "ee03200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee03200C1Ev();
extern void _ZN7ee03200D1Ev();
Name_Map name_map_ee03200[] = {
  NSPAIR(_ZN7ee03200C1Ev),
  NSPAIR(_ZN7ee03200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee03200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee03200[];
extern void _ZN6dd32003fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee03200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee03200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee03200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
extern VTBL_ENTRY _ZTV7ee03200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee03200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee03200[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee03200[] = {
  {&(_ZTV7ee03200[3]),  3,8},
  {&(_tg__ZTV6dd3200__7ee03200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee03200[3]),  3,4},
  {&(_ZTV7ee03200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee03200[];
extern  VTBL_ENTRY _ZTV7ee03200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee03200[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee03200 = {  "ee03200", // class name
  bases_ee03200, 4,
  &(vtc_ee03200[0]), // expected_vtbl_contents
  &(vtt_ee03200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee03200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee03200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee03200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13200  : virtual dd3200 {
  int e;
  ~ee13200(); // tgen
  ee13200(); // tgen
};
//SIG(1 ee13200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} Fi}


ee13200 ::~ee13200(){ note_dtor("ee13200", this);} // tgen
ee13200 ::ee13200(){ note_ctor("ee13200", this);} // tgen

static void Test_ee13200()
{
  extern Class_Descriptor cd_ee13200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee13200, buf);
    ee13200 *dp, &lv = *(dp=new (buf) ee13200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee13200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee13200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee13200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(32,16), "ee13200");
    check_base_class_offset(lv, (dd3200*), ABISELECT(16,8), "ee13200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee13200.e");
    test_class_info(&lv, &cd_ee13200);
    dp->~ee13200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13200(Test_ee13200, "ee13200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee13200C1Ev();
extern void _ZN7ee13200D1Ev();
Name_Map name_map_ee13200[] = {
  NSPAIR(_ZN7ee13200C1Ev),
  NSPAIR(_ZN7ee13200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee13200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee13200[];
extern void _ZN6dd32003fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee13200[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee13200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee13200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
extern VTBL_ENTRY _ZTV7ee13200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee13200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee13200[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee13200[] = {
  {&(_ZTV7ee13200[4]),  4,13},
  {&(_ZTV7ee13200[8]),  8,13},
  {&(_ZTV7ee13200[12]),  12,13},
  {&(_tg__ZTV6dd3200__7ee13200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee13200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee13200[];
extern  VTBL_ENTRY _ZTV7ee13200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee13200[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13200 = {  "ee13200", // class name
  bases_ee13200, 4,
  &(vtc_ee13200[0]), // expected_vtbl_contents
  &(vtt_ee13200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee13200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee13200),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee13200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23200  : dd3200 {
  int e;
  virtual void  foo(); // _ZN7ee232003fooEv
  ~ee23200(); // tgen
  ee23200(); // tgen
};
//SIG(1 ee23200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee23200 ::foo(){vfunc_called(this, "_ZN7ee232003fooEv");}
ee23200 ::~ee23200(){ note_dtor("ee23200", this);} // tgen
ee23200 ::ee23200(){ note_ctor("ee23200", this);} // tgen

static void Test_ee23200()
{
  extern Class_Descriptor cd_ee23200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee23200, buf);
    ee23200 *dp, &lv = *(dp=new (buf) ee23200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee23200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee23200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee23200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(16,12), "ee23200");
    check_base_class_offset(lv, (dd3200*), 0, "ee23200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee23200.e");
    test_class_info(&lv, &cd_ee23200);
    dp->~ee23200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23200(Test_ee23200, "ee23200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee23200C1Ev();
extern void _ZN7ee23200D1Ev();
Name_Map name_map_ee23200[] = {
  NSPAIR(_ZN7ee23200C1Ev),
  NSPAIR(_ZN7ee23200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee23200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee23200[];
extern void _ZN7ee232003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee232003fooEv,_ZTv0_n12_N7ee232003fooEv)();
extern void ABISELECT(_ZThn16_N7ee232003fooEv,_ZThn12_N7ee232003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee23200[0]),
  (VTBL_ENTRY)&_ZN7ee232003fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee23200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee232003fooEv,_ZTv0_n12_N7ee232003fooEv),
};
extern VTBL_ENTRY _ZTV7ee23200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee23200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee23200[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee23200[] = {
  {&(_ZTV7ee23200[3]),  3,8},
  {&(_tg__ZTV6dd3200__7ee23200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee23200[3]),  3,4},
  {&(_ZTV7ee23200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee23200[];
extern  VTBL_ENTRY _ZTV7ee23200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee23200[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee232003fooEv,_ZTv0_n12_N7ee232003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee232003fooEv,_ZThn12_N7ee232003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23200 = {  "ee23200", // class name
  bases_ee23200, 4,
  &(vtc_ee23200[0]), // expected_vtbl_contents
  &(vtt_ee23200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee23200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee23200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee23200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33200  : virtual dd3200 {
  int e;
  virtual void  foo(); // _ZN7ee332003fooEv
  ~ee33200(); // tgen
  ee33200(); // tgen
};
//SIG(1 ee33200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 Fi}


void  ee33200 ::foo(){vfunc_called(this, "_ZN7ee332003fooEv");}
ee33200 ::~ee33200(){ note_dtor("ee33200", this);} // tgen
ee33200 ::ee33200(){ note_ctor("ee33200", this);} // tgen

static void Test_ee33200()
{
  extern Class_Descriptor cd_ee33200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee33200, buf);
    ee33200 *dp, &lv = *(dp=new (buf) ee33200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee33200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee33200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee33200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(32,16), "ee33200");
    check_base_class_offset(lv, (dd3200*), ABISELECT(16,8), "ee33200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee33200.e");
    test_class_info(&lv, &cd_ee33200);
    dp->~ee33200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33200(Test_ee33200, "ee33200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee33200C1Ev();
extern void _ZN7ee33200D1Ev();
Name_Map name_map_ee33200[] = {
  NSPAIR(_ZN7ee33200C1Ev),
  NSPAIR(_ZN7ee33200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee33200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee33200[];
extern void _ZN7ee332003fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee332003fooEv,_ZTv0_n16_N7ee332003fooEv)();
extern void ABISELECT(_ZThn16_N7ee332003fooEv,_ZThn8_N7ee332003fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee332003fooEv,_ZTv0_n12_N7ee332003fooEv)();
extern void ABISELECT(_ZThn32_N7ee332003fooEv,_ZThn16_N7ee332003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee33200[0]),
  (VTBL_ENTRY)&_ZN7ee332003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee33200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee332003fooEv,_ZTv0_n16_N7ee332003fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee33200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee332003fooEv,_ZTv0_n12_N7ee332003fooEv),
};
extern VTBL_ENTRY _ZTV7ee33200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee33200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee33200[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee33200[] = {
  {&(_ZTV7ee33200[4]),  4,14},
  {&(_ZTV7ee33200[9]),  9,14},
  {&(_ZTV7ee33200[13]),  13,14},
  {&(_tg__ZTV6dd3200__7ee33200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee33200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee33200[];
extern  VTBL_ENTRY _ZTV7ee33200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee33200[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee332003fooEv,_ZTv0_n12_N7ee332003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee332003fooEv,_ZThn16_N7ee332003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee332003fooEv,_ZTv0_n16_N7ee332003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee332003fooEv,_ZThn8_N7ee332003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33200 = {  "ee33200", // class name
  bases_ee33200, 4,
  &(vtc_ee33200[0]), // expected_vtbl_contents
  &(vtt_ee33200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee33200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee33200),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee33200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43200  : dd3200 {
  int e;
  virtual void  bar(); // _ZN7ee432003barEv
  ~ee43200(); // tgen
  ee43200(); // tgen
};
//SIG(1 ee43200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee43200 ::bar(){vfunc_called(this, "_ZN7ee432003barEv");}
ee43200 ::~ee43200(){ note_dtor("ee43200", this);} // tgen
ee43200 ::ee43200(){ note_ctor("ee43200", this);} // tgen

static void Test_ee43200()
{
  extern Class_Descriptor cd_ee43200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee43200, buf);
    ee43200 *dp, &lv = *(dp=new (buf) ee43200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee43200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee43200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee43200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(16,12), "ee43200");
    check_base_class_offset(lv, (dd3200*), 0, "ee43200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee43200.e");
    test_class_info(&lv, &cd_ee43200);
    dp->~ee43200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43200(Test_ee43200, "ee43200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee43200C1Ev();
extern void _ZN7ee43200D1Ev();
Name_Map name_map_ee43200[] = {
  NSPAIR(_ZN7ee43200C1Ev),
  NSPAIR(_ZN7ee43200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee43200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee43200[];
extern void _ZN6dd32003fooEv();
extern void _ZN7ee432003barEv();
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee43200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
  (VTBL_ENTRY)&_ZN7ee432003barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee43200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
extern VTBL_ENTRY _ZTV7ee43200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee43200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee43200[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee43200[] = {
  {&(_ZTV7ee43200[3]),  3,9},
  {&(_tg__ZTV6dd3200__7ee43200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee43200[3]),  3,4},
  {&(_ZTV7ee43200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee43200[];
extern  VTBL_ENTRY _ZTV7ee43200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee43200[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43200 = {  "ee43200", // class name
  bases_ee43200, 4,
  &(vtc_ee43200[0]), // expected_vtbl_contents
  &(vtt_ee43200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee43200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee43200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee43200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee53200  : virtual dd3200 {
  int e;
  virtual void  bar(); // _ZN7ee532003barEv
  ~ee53200(); // tgen
  ee53200(); // tgen
};
//SIG(1 ee53200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v2 Fi} v1 Fi}


void  ee53200 ::bar(){vfunc_called(this, "_ZN7ee532003barEv");}
ee53200 ::~ee53200(){ note_dtor("ee53200", this);} // tgen
ee53200 ::ee53200(){ note_ctor("ee53200", this);} // tgen

static void Test_ee53200()
{
  extern Class_Descriptor cd_ee53200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee53200, buf);
    ee53200 *dp, &lv = *(dp=new (buf) ee53200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee53200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee53200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee53200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee53200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(32,16), "ee53200");
    check_base_class_offset(lv, (dd3200*), ABISELECT(16,8), "ee53200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee53200.e");
    test_class_info(&lv, &cd_ee53200);
    dp->~ee53200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee53200(Test_ee53200, "ee53200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee53200C1Ev();
extern void _ZN7ee53200D1Ev();
Name_Map name_map_ee53200[] = {
  NSPAIR(_ZN7ee53200C1Ev),
  NSPAIR(_ZN7ee53200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee53200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee53200[];
extern void _ZN7ee532003barEv();
extern void _ZN6dd32003fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee53200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee53200[0]),
  (VTBL_ENTRY)&_ZN7ee532003barEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee53200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee53200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
extern VTBL_ENTRY _ZTV7ee53200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee53200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee53200[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee53200[] = {
  {&(_ZTV7ee53200[4]),  4,14},
  {&(_ZTV7ee53200[9]),  9,14},
  {&(_ZTV7ee53200[13]),  13,14},
  {&(_tg__ZTV6dd3200__7ee53200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee53200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee53200[];
extern  VTBL_ENTRY _ZTV7ee53200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee53200[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee53200 = {  "ee53200", // class name
  bases_ee53200, 4,
  &(vtc_ee53200[0]), // expected_vtbl_contents
  &(vtt_ee53200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee53200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee53200),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee53200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee63200  : dd3200 {
  int e;
  virtual void  foo(); // _ZN7ee632003fooEv
  virtual void  bar(); // _ZN7ee632003barEv
  ~ee63200(); // tgen
  ee63200(); // tgen
};
//SIG(1 ee63200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee63200 ::foo(){vfunc_called(this, "_ZN7ee632003fooEv");}
void  ee63200 ::bar(){vfunc_called(this, "_ZN7ee632003barEv");}
ee63200 ::~ee63200(){ note_dtor("ee63200", this);} // tgen
ee63200 ::ee63200(){ note_ctor("ee63200", this);} // tgen

static void Test_ee63200()
{
  extern Class_Descriptor cd_ee63200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee63200, buf);
    ee63200 *dp, &lv = *(dp=new (buf) ee63200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee63200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee63200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee63200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee63200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(16,12), "ee63200");
    check_base_class_offset(lv, (dd3200*), 0, "ee63200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee63200.e");
    test_class_info(&lv, &cd_ee63200);
    dp->~ee63200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee63200(Test_ee63200, "ee63200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee63200C1Ev();
extern void _ZN7ee63200D1Ev();
Name_Map name_map_ee63200[] = {
  NSPAIR(_ZN7ee63200C1Ev),
  NSPAIR(_ZN7ee63200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee63200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee63200[];
extern void _ZN7ee632003fooEv();
extern void _ZN7ee632003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee632003fooEv,_ZTv0_n12_N7ee632003fooEv)();
extern void ABISELECT(_ZThn16_N7ee632003fooEv,_ZThn12_N7ee632003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee63200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee63200[0]),
  (VTBL_ENTRY)&_ZN7ee632003fooEv,
  (VTBL_ENTRY)&_ZN7ee632003barEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee63200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee632003fooEv,_ZTv0_n12_N7ee632003fooEv),
};
extern VTBL_ENTRY _ZTV7ee63200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee63200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee63200[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee63200[] = {
  {&(_ZTV7ee63200[3]),  3,9},
  {&(_tg__ZTV6dd3200__7ee63200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee63200[3]),  3,4},
  {&(_ZTV7ee63200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee63200[];
extern  VTBL_ENTRY _ZTV7ee63200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee63200[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn12_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee632003fooEv,_ZTv0_n12_N7ee632003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee632003fooEv,_ZThn12_N7ee632003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee63200 = {  "ee63200", // class name
  bases_ee63200, 4,
  &(vtc_ee63200[0]), // expected_vtbl_contents
  &(vtt_ee63200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee63200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee63200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee63200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee73200  : virtual dd3200 {
  int e;
  virtual void  foo(); // _ZN7ee732003fooEv
  virtual void  bar(); // _ZN7ee732003barEv
  ~ee73200(); // tgen
  ee73200(); // tgen
};
//SIG(1 ee73200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v1 Fi} v1 v2 Fi}


void  ee73200 ::foo(){vfunc_called(this, "_ZN7ee732003fooEv");}
void  ee73200 ::bar(){vfunc_called(this, "_ZN7ee732003barEv");}
ee73200 ::~ee73200(){ note_dtor("ee73200", this);} // tgen
ee73200 ::ee73200(){ note_ctor("ee73200", this);} // tgen

static void Test_ee73200()
{
  extern Class_Descriptor cd_ee73200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee73200, buf);
    ee73200 *dp, &lv = *(dp=new (buf) ee73200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee73200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee73200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee73200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee73200");
    check_base_class_offset(lv, (cc200*)(dd3200*), ABISELECT(32,16), "ee73200");
    check_base_class_offset(lv, (dd3200*), ABISELECT(16,8), "ee73200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee73200.e");
    test_class_info(&lv, &cd_ee73200);
    dp->~ee73200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee73200(Test_ee73200, "ee73200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee73200C1Ev();
extern void _ZN7ee73200D1Ev();
Name_Map name_map_ee73200[] = {
  NSPAIR(_ZN7ee73200C1Ev),
  NSPAIR(_ZN7ee73200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd3200;
extern VTBL_ENTRY _ZTI6dd3200[];
extern  VTBL_ENTRY _ZTV6dd3200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd3200[];
static Base_Class bases_ee73200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd3200,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee73200[];
extern void _ZN7ee732003fooEv();
extern void _ZN7ee732003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee732003fooEv,_ZTv0_n16_N7ee732003fooEv)();
extern void ABISELECT(_ZThn16_N7ee732003fooEv,_ZThn8_N7ee732003fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee732003fooEv,_ZTv0_n12_N7ee732003fooEv)();
extern void ABISELECT(_ZThn32_N7ee732003fooEv,_ZThn16_N7ee732003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee73200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee73200[0]),
  (VTBL_ENTRY)&_ZN7ee732003fooEv,
  (VTBL_ENTRY)&_ZN7ee732003barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee73200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee732003fooEv,_ZTv0_n16_N7ee732003fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee73200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee732003fooEv,_ZTv0_n12_N7ee732003fooEv),
};
extern VTBL_ENTRY _ZTV7ee73200[];
extern void _ZN6dd32003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd3200__7ee73200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&_ZN6dd32003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv)();
extern void ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd3200__7ee73200[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd3200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv),
};
static  VTT_ENTRY vtt_ee73200[] = {
  {&(_ZTV7ee73200[4]),  4,15},
  {&(_ZTV7ee73200[10]),  10,15},
  {&(_ZTV7ee73200[14]),  14,15},
  {&(_tg__ZTV6dd3200__7ee73200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd3200__7ee73200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee73200[];
extern  VTBL_ENTRY _ZTV7ee73200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee73200[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd32003fooEv,_ZTv0_n12_N6dd32003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd32003fooEv,_ZThn8_N6dd32003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee732003fooEv,_ZTv0_n12_N7ee732003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee732003fooEv,_ZThn16_N7ee732003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee732003fooEv,_ZTv0_n16_N7ee732003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee732003fooEv,_ZThn8_N7ee732003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee73200 = {  "ee73200", // class name
  bases_ee73200, 4,
  &(vtc_ee73200[0]), // expected_vtbl_contents
  &(vtt_ee73200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee73200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee73200),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee73200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4200  : cc200 {
  int d;
  virtual void  bar(); // _ZN6dd42003barEv
  ~dd4200(); // tgen
  dd4200(); // tgen
};
//SIG(-1 dd4200) C1{ BC2{ BC3{ BC4{ Fi} Fi} v2 Fi} v1 Fi}


void  dd4200 ::bar(){vfunc_called(this, "_ZN6dd42003barEv");}
dd4200 ::~dd4200(){ note_dtor("dd4200", this);} // tgen
dd4200 ::dd4200(){ note_ctor("dd4200", this);} // tgen

static void Test_dd4200()
{
  extern Class_Descriptor cd_dd4200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd4200, buf);
    dd4200 *dp, &lv = *(dp=new (buf) dd4200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd4200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(8,4), "dd4200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(8,4), "dd4200");
    check_base_class_offset(lv, (cc200*), 0, "dd4200");
    check_field_offset(lv, d, ABISELECT(20,16), "dd4200.d");
    test_class_info(&lv, &cd_dd4200);
    dp->~dd4200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4200(Test_dd4200, "dd4200", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd4200C1Ev();
extern void _ZN6dd4200D1Ev();
Name_Map name_map_dd4200[] = {
  NSPAIR(_ZN6dd4200C1Ev),
  NSPAIR(_ZN6dd4200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd4200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd4200[];
extern void _ZN5cc2003fooEv();
extern void _ZN6dd42003barEv();
static  VTBL_ENTRY vtc_dd4200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd4200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
  (VTBL_ENTRY)&_ZN6dd42003barEv,
};
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
Class_Descriptor cd_dd4200 = {  "dd4200", // class name
  bases_dd4200, 3,
  &(vtc_dd4200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd4200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd4200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee04200  : dd4200 {
  int e;
  ~ee04200(); // tgen
  ee04200(); // tgen
};
//SIG(1 ee04200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} Fi}


ee04200 ::~ee04200(){ note_dtor("ee04200", this);} // tgen
ee04200 ::ee04200(){ note_ctor("ee04200", this);} // tgen

static void Test_ee04200()
{
  extern Class_Descriptor cd_ee04200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee04200, buf);
    ee04200 *dp, &lv = *(dp=new (buf) ee04200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee04200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee04200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee04200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee04200");
    check_base_class_offset(lv, (cc200*)(dd4200*), 0, "ee04200");
    check_base_class_offset(lv, (dd4200*), 0, "ee04200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee04200.e");
    test_class_info(&lv, &cd_ee04200);
    dp->~ee04200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee04200(Test_ee04200, "ee04200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee04200C1Ev();
extern void _ZN7ee04200D1Ev();
Name_Map name_map_ee04200[] = {
  NSPAIR(_ZN7ee04200C1Ev),
  NSPAIR(_ZN7ee04200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee04200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee04200[];
extern void _ZN5cc2003fooEv();
extern void _ZN6dd42003barEv();
static  VTBL_ENTRY vtc_ee04200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee04200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
  (VTBL_ENTRY)&_ZN6dd42003barEv,
};
extern VTBL_ENTRY _ZTI7ee04200[];
extern  VTBL_ENTRY _ZTV7ee04200[];
Class_Descriptor cd_ee04200 = {  "ee04200", // class name
  bases_ee04200, 4,
  &(vtc_ee04200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee04200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee04200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14200  : virtual dd4200 {
  int e;
  ~ee14200(); // tgen
  ee14200(); // tgen
};
//SIG(1 ee14200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} Fi}


ee14200 ::~ee14200(){ note_dtor("ee14200", this);} // tgen
ee14200 ::ee14200(){ note_ctor("ee14200", this);} // tgen

static void Test_ee14200()
{
  extern Class_Descriptor cd_ee14200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee14200, buf);
    ee14200 *dp, &lv = *(dp=new (buf) ee14200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee14200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee14200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee14200");
    check_base_class_offset(lv, (cc200*)(dd4200*), ABISELECT(16,8), "ee14200");
    check_base_class_offset(lv, (dd4200*), ABISELECT(16,8), "ee14200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee14200.e");
    test_class_info(&lv, &cd_ee14200);
    dp->~ee14200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14200(Test_ee14200, "ee14200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee14200C1Ev();
extern void _ZN7ee14200D1Ev();
Name_Map name_map_ee14200[] = {
  NSPAIR(_ZN7ee14200C1Ev),
  NSPAIR(_ZN7ee14200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee14200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee14200[];
extern void _ZN5cc2003fooEv();
extern void _ZN6dd42003barEv();
static  VTBL_ENTRY vtc_ee14200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee14200[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee14200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
  (VTBL_ENTRY)&_ZN6dd42003barEv,
};
extern VTBL_ENTRY _ZTV7ee14200[];
static  VTT_ENTRY vtt_ee14200[] = {
  {&(_ZTV7ee14200[3]),  3,9},
  {&(_ZTV7ee14200[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee14200[];
extern  VTBL_ENTRY _ZTV7ee14200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee14200[];
Class_Descriptor cd_ee14200 = {  "ee14200", // class name
  bases_ee14200, 4,
  &(vtc_ee14200[0]), // expected_vtbl_contents
  &(vtt_ee14200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee14200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee14200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee14200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24200  : dd4200 {
  int e;
  virtual void  foo(); // _ZN7ee242003fooEv
  ~ee24200(); // tgen
  ee24200(); // tgen
};
//SIG(1 ee24200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee24200 ::foo(){vfunc_called(this, "_ZN7ee242003fooEv");}
ee24200 ::~ee24200(){ note_dtor("ee24200", this);} // tgen
ee24200 ::ee24200(){ note_ctor("ee24200", this);} // tgen

static void Test_ee24200()
{
  extern Class_Descriptor cd_ee24200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee24200, buf);
    ee24200 *dp, &lv = *(dp=new (buf) ee24200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee24200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee24200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee24200");
    check_base_class_offset(lv, (cc200*)(dd4200*), 0, "ee24200");
    check_base_class_offset(lv, (dd4200*), 0, "ee24200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee24200.e");
    test_class_info(&lv, &cd_ee24200);
    dp->~ee24200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24200(Test_ee24200, "ee24200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee24200C1Ev();
extern void _ZN7ee24200D1Ev();
Name_Map name_map_ee24200[] = {
  NSPAIR(_ZN7ee24200C1Ev),
  NSPAIR(_ZN7ee24200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee24200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee24200[];
extern void _ZN7ee242003fooEv();
extern void _ZN6dd42003barEv();
static  VTBL_ENTRY vtc_ee24200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee24200[0]),
  (VTBL_ENTRY)&_ZN7ee242003fooEv,
  (VTBL_ENTRY)&_ZN6dd42003barEv,
};
extern VTBL_ENTRY _ZTI7ee24200[];
extern  VTBL_ENTRY _ZTV7ee24200[];
Class_Descriptor cd_ee24200 = {  "ee24200", // class name
  bases_ee24200, 4,
  &(vtc_ee24200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee24200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee24200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34200  : virtual dd4200 {
  int e;
  virtual void  foo(); // _ZN7ee342003fooEv
  ~ee34200(); // tgen
  ee34200(); // tgen
};
//SIG(1 ee34200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee34200 ::foo(){vfunc_called(this, "_ZN7ee342003fooEv");}
ee34200 ::~ee34200(){ note_dtor("ee34200", this);} // tgen
ee34200 ::ee34200(){ note_ctor("ee34200", this);} // tgen

static void Test_ee34200()
{
  extern Class_Descriptor cd_ee34200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee34200, buf);
    ee34200 *dp, &lv = *(dp=new (buf) ee34200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee34200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee34200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee34200");
    check_base_class_offset(lv, (cc200*)(dd4200*), ABISELECT(16,8), "ee34200");
    check_base_class_offset(lv, (dd4200*), ABISELECT(16,8), "ee34200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee34200.e");
    test_class_info(&lv, &cd_ee34200);
    dp->~ee34200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34200(Test_ee34200, "ee34200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee34200C1Ev();
extern void _ZN7ee34200D1Ev();
Name_Map name_map_ee34200[] = {
  NSPAIR(_ZN7ee34200C1Ev),
  NSPAIR(_ZN7ee34200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee34200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee34200[];
extern void _ZN7ee342003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee342003fooEv,_ZTv0_n12_N7ee342003fooEv)();
extern void ABISELECT(_ZThn16_N7ee342003fooEv,_ZThn8_N7ee342003fooEv)() __attribute__((weak));
extern void _ZN6dd42003barEv();
static  VTBL_ENTRY vtc_ee34200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee34200[0]),
  (VTBL_ENTRY)&_ZN7ee342003fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee34200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee342003fooEv,_ZTv0_n12_N7ee342003fooEv),
  (VTBL_ENTRY)&_ZN6dd42003barEv,
};
extern VTBL_ENTRY _ZTV7ee34200[];
static  VTT_ENTRY vtt_ee34200[] = {
  {&(_ZTV7ee34200[3]),  3,10},
  {&(_ZTV7ee34200[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee34200[];
extern  VTBL_ENTRY _ZTV7ee34200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee34200[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee342003fooEv,_ZTv0_n12_N7ee342003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee342003fooEv,_ZThn8_N7ee342003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34200 = {  "ee34200", // class name
  bases_ee34200, 4,
  &(vtc_ee34200[0]), // expected_vtbl_contents
  &(vtt_ee34200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee34200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee34200),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee34200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee44200  : dd4200 {
  int e;
  virtual void  bar(); // _ZN7ee442003barEv
  ~ee44200(); // tgen
  ee44200(); // tgen
};
//SIG(1 ee44200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} v1 Fi}


void  ee44200 ::bar(){vfunc_called(this, "_ZN7ee442003barEv");}
ee44200 ::~ee44200(){ note_dtor("ee44200", this);} // tgen
ee44200 ::ee44200(){ note_ctor("ee44200", this);} // tgen

static void Test_ee44200()
{
  extern Class_Descriptor cd_ee44200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee44200, buf);
    ee44200 *dp, &lv = *(dp=new (buf) ee44200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee44200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee44200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee44200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee44200");
    check_base_class_offset(lv, (cc200*)(dd4200*), 0, "ee44200");
    check_base_class_offset(lv, (dd4200*), 0, "ee44200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee44200.e");
    test_class_info(&lv, &cd_ee44200);
    dp->~ee44200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee44200(Test_ee44200, "ee44200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee44200C1Ev();
extern void _ZN7ee44200D1Ev();
Name_Map name_map_ee44200[] = {
  NSPAIR(_ZN7ee44200C1Ev),
  NSPAIR(_ZN7ee44200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee44200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee44200[];
extern void _ZN5cc2003fooEv();
extern void _ZN7ee442003barEv();
static  VTBL_ENTRY vtc_ee44200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee44200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
  (VTBL_ENTRY)&_ZN7ee442003barEv,
};
extern VTBL_ENTRY _ZTI7ee44200[];
extern  VTBL_ENTRY _ZTV7ee44200[];
Class_Descriptor cd_ee44200 = {  "ee44200", // class name
  bases_ee44200, 4,
  &(vtc_ee44200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee44200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee44200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee54200  : virtual dd4200 {
  int e;
  virtual void  bar(); // _ZN7ee542003barEv
  ~ee54200(); // tgen
  ee54200(); // tgen
};
//SIG(1 ee54200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} v1 Fi}


void  ee54200 ::bar(){vfunc_called(this, "_ZN7ee542003barEv");}
ee54200 ::~ee54200(){ note_dtor("ee54200", this);} // tgen
ee54200 ::ee54200(){ note_ctor("ee54200", this);} // tgen

static void Test_ee54200()
{
  extern Class_Descriptor cd_ee54200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee54200, buf);
    ee54200 *dp, &lv = *(dp=new (buf) ee54200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee54200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee54200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee54200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee54200");
    check_base_class_offset(lv, (cc200*)(dd4200*), ABISELECT(16,8), "ee54200");
    check_base_class_offset(lv, (dd4200*), ABISELECT(16,8), "ee54200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee54200.e");
    test_class_info(&lv, &cd_ee54200);
    dp->~ee54200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee54200(Test_ee54200, "ee54200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee54200C1Ev();
extern void _ZN7ee54200D1Ev();
Name_Map name_map_ee54200[] = {
  NSPAIR(_ZN7ee54200C1Ev),
  NSPAIR(_ZN7ee54200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee54200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee54200[];
extern void _ZN7ee542003barEv();
extern void _ZN5cc2003fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee542003barEv,_ZTv0_n16_N7ee542003barEv)();
extern void ABISELECT(_ZThn16_N7ee542003barEv,_ZThn8_N7ee542003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee54200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee54200[0]),
  (VTBL_ENTRY)&_ZN7ee542003barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee54200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee542003barEv,_ZTv0_n16_N7ee542003barEv),
};
extern VTBL_ENTRY _ZTV7ee54200[];
static  VTT_ENTRY vtt_ee54200[] = {
  {&(_ZTV7ee54200[3]),  3,10},
  {&(_ZTV7ee54200[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee54200[];
extern  VTBL_ENTRY _ZTV7ee54200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee54200[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee542003barEv,_ZTv0_n16_N7ee542003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee542003barEv,_ZThn8_N7ee542003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee54200 = {  "ee54200", // class name
  bases_ee54200, 4,
  &(vtc_ee54200[0]), // expected_vtbl_contents
  &(vtt_ee54200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee54200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee54200),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee54200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee64200  : dd4200 {
  int e;
  virtual void  foo(); // _ZN7ee642003fooEv
  virtual void  bar(); // _ZN7ee642003barEv
  ~ee64200(); // tgen
  ee64200(); // tgen
};
//SIG(1 ee64200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 v2 Fi}


void  ee64200 ::foo(){vfunc_called(this, "_ZN7ee642003fooEv");}
void  ee64200 ::bar(){vfunc_called(this, "_ZN7ee642003barEv");}
ee64200 ::~ee64200(){ note_dtor("ee64200", this);} // tgen
ee64200 ::ee64200(){ note_ctor("ee64200", this);} // tgen

static void Test_ee64200()
{
  extern Class_Descriptor cd_ee64200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee64200, buf);
    ee64200 *dp, &lv = *(dp=new (buf) ee64200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee64200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee64200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee64200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(8,4), "ee64200");
    check_base_class_offset(lv, (cc200*)(dd4200*), 0, "ee64200");
    check_base_class_offset(lv, (dd4200*), 0, "ee64200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee64200.e");
    test_class_info(&lv, &cd_ee64200);
    dp->~ee64200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee64200(Test_ee64200, "ee64200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee64200C1Ev();
extern void _ZN7ee64200D1Ev();
Name_Map name_map_ee64200[] = {
  NSPAIR(_ZN7ee64200C1Ev),
  NSPAIR(_ZN7ee64200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee64200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee64200[];
extern void _ZN7ee642003fooEv();
extern void _ZN7ee642003barEv();
static  VTBL_ENTRY vtc_ee64200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee64200[0]),
  (VTBL_ENTRY)&_ZN7ee642003fooEv,
  (VTBL_ENTRY)&_ZN7ee642003barEv,
};
extern VTBL_ENTRY _ZTI7ee64200[];
extern  VTBL_ENTRY _ZTV7ee64200[];
Class_Descriptor cd_ee64200 = {  "ee64200", // class name
  bases_ee64200, 4,
  &(vtc_ee64200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee64200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee64200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee74200  : virtual dd4200 {
  int e;
  virtual void  foo(); // _ZN7ee742003fooEv
  virtual void  bar(); // _ZN7ee742003barEv
  ~ee74200(); // tgen
  ee74200(); // tgen
};
//SIG(1 ee74200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 v2 Fi}


void  ee74200 ::foo(){vfunc_called(this, "_ZN7ee742003fooEv");}
void  ee74200 ::bar(){vfunc_called(this, "_ZN7ee742003barEv");}
ee74200 ::~ee74200(){ note_dtor("ee74200", this);} // tgen
ee74200 ::ee74200(){ note_ctor("ee74200", this);} // tgen

static void Test_ee74200()
{
  extern Class_Descriptor cd_ee74200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee74200, buf);
    ee74200 *dp, &lv = *(dp=new (buf) ee74200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee74200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee74200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee74200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd4200*), ABISELECT(24,12), "ee74200");
    check_base_class_offset(lv, (cc200*)(dd4200*), ABISELECT(16,8), "ee74200");
    check_base_class_offset(lv, (dd4200*), ABISELECT(16,8), "ee74200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee74200.e");
    test_class_info(&lv, &cd_ee74200);
    dp->~ee74200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee74200(Test_ee74200, "ee74200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee74200C1Ev();
extern void _ZN7ee74200D1Ev();
Name_Map name_map_ee74200[] = {
  NSPAIR(_ZN7ee74200C1Ev),
  NSPAIR(_ZN7ee74200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd4200;
extern VTBL_ENTRY _ZTI6dd4200[];
extern  VTBL_ENTRY _ZTV6dd4200[];
static Base_Class bases_ee74200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd4200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee74200[];
extern void _ZN7ee742003fooEv();
extern void _ZN7ee742003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee742003fooEv,_ZTv0_n12_N7ee742003fooEv)();
extern void ABISELECT(_ZThn16_N7ee742003fooEv,_ZThn8_N7ee742003fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee742003barEv,_ZTv0_n16_N7ee742003barEv)();
extern void ABISELECT(_ZThn16_N7ee742003barEv,_ZThn8_N7ee742003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee74200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee74200[0]),
  (VTBL_ENTRY)&_ZN7ee742003fooEv,
  (VTBL_ENTRY)&_ZN7ee742003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee74200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee742003fooEv,_ZTv0_n12_N7ee742003fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee742003barEv,_ZTv0_n16_N7ee742003barEv),
};
extern VTBL_ENTRY _ZTV7ee74200[];
static  VTT_ENTRY vtt_ee74200[] = {
  {&(_ZTV7ee74200[3]),  3,11},
  {&(_ZTV7ee74200[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee74200[];
extern  VTBL_ENTRY _ZTV7ee74200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee74200[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee742003barEv,_ZTv0_n16_N7ee742003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee742003barEv,_ZThn8_N7ee742003barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee742003fooEv,_ZTv0_n12_N7ee742003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee742003fooEv,_ZThn8_N7ee742003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee74200 = {  "ee74200", // class name
  bases_ee74200, 4,
  &(vtc_ee74200[0]), // expected_vtbl_contents
  &(vtt_ee74200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee74200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee74200),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee74200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5200  : virtual cc200 {
  int d;
  virtual void  bar(); // _ZN6dd52003barEv
  ~dd5200(); // tgen
  dd5200(); // tgen
};
//SIG(-1 dd5200) C1{ VBC2{ BC3{ BC4{ Fi} Fi} v2 Fi} v1 Fi}


void  dd5200 ::bar(){vfunc_called(this, "_ZN6dd52003barEv");}
dd5200 ::~dd5200(){ note_dtor("dd5200", this);} // tgen
dd5200 ::dd5200(){ note_ctor("dd5200", this);} // tgen

static void Test_dd5200()
{
  extern Class_Descriptor cd_dd5200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd5200, buf);
    dd5200 *dp, &lv = *(dp=new (buf) dd5200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd5200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,12), "dd5200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,12), "dd5200");
    check_base_class_offset(lv, (cc200*), ABISELECT(16,8), "dd5200");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5200.d");
    test_class_info(&lv, &cd_dd5200);
    dp->~dd5200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5200(Test_dd5200, "dd5200", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd5200C1Ev();
extern void _ZN6dd5200D1Ev();
Name_Map name_map_dd5200[] = {
  NSPAIR(_ZN6dd5200C1Ev),
  NSPAIR(_ZN6dd5200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd5200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd5200[];
extern void _ZN6dd52003barEv();
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_dd5200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV6dd5200[];
static  VTT_ENTRY vtt_dd5200[] = {
  {&(_ZTV6dd5200[3]),  3,8},
  {&(_ZTV6dd5200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
Class_Descriptor cd_dd5200 = {  "dd5200", // class name
  bases_dd5200, 3,
  &(vtc_dd5200[0]), // expected_vtbl_contents
  &(vtt_dd5200[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd5200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd5200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd5200),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee05200  : dd5200 {
  int e;
  ~ee05200(); // tgen
  ee05200(); // tgen
};
//SIG(1 ee05200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} Fi}


ee05200 ::~ee05200(){ note_dtor("ee05200", this);} // tgen
ee05200 ::ee05200(){ note_ctor("ee05200", this);} // tgen

static void Test_ee05200()
{
  extern Class_Descriptor cd_ee05200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee05200, buf);
    ee05200 *dp, &lv = *(dp=new (buf) ee05200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee05200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee05200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee05200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee05200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(16,12), "ee05200");
    check_base_class_offset(lv, (dd5200*), 0, "ee05200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee05200.e");
    test_class_info(&lv, &cd_ee05200);
    dp->~ee05200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee05200(Test_ee05200, "ee05200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee05200C1Ev();
extern void _ZN7ee05200D1Ev();
Name_Map name_map_ee05200[] = {
  NSPAIR(_ZN7ee05200C1Ev),
  NSPAIR(_ZN7ee05200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee05200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee05200[];
extern void _ZN6dd52003barEv();
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee05200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee05200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee05200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee05200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee05200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee05200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee05200[] = {
  {&(_ZTV7ee05200[3]),  3,8},
  {&(_tg__ZTV6dd5200__7ee05200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee05200[3]),  3,4},
  {&(_ZTV7ee05200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee05200[];
extern  VTBL_ENTRY _ZTV7ee05200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee05200[];
Class_Descriptor cd_ee05200 = {  "ee05200", // class name
  bases_ee05200, 4,
  &(vtc_ee05200[0]), // expected_vtbl_contents
  &(vtt_ee05200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee05200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee05200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee05200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15200  : virtual dd5200 {
  int e;
  ~ee15200(); // tgen
  ee15200(); // tgen
};
//SIG(1 ee15200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} Fi}


ee15200 ::~ee15200(){ note_dtor("ee15200", this);} // tgen
ee15200 ::ee15200(){ note_ctor("ee15200", this);} // tgen

static void Test_ee15200()
{
  extern Class_Descriptor cd_ee15200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee15200, buf);
    ee15200 *dp, &lv = *(dp=new (buf) ee15200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee15200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee15200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee15200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(32,16), "ee15200");
    check_base_class_offset(lv, (dd5200*), ABISELECT(16,8), "ee15200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15200.e");
    test_class_info(&lv, &cd_ee15200);
    dp->~ee15200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15200(Test_ee15200, "ee15200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee15200C1Ev();
extern void _ZN7ee15200D1Ev();
Name_Map name_map_ee15200[] = {
  NSPAIR(_ZN7ee15200C1Ev),
  NSPAIR(_ZN7ee15200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee15200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee15200[];
extern void _ZN6dd52003barEv();
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee15200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee15200[0]),
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee15200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee15200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee15200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee15200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee15200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee15200[] = {
  {&(_ZTV7ee15200[4]),  4,13},
  {&(_ZTV7ee15200[8]),  8,13},
  {&(_ZTV7ee15200[12]),  12,13},
  {&(_tg__ZTV6dd5200__7ee15200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee15200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee15200[];
extern  VTBL_ENTRY _ZTV7ee15200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee15200[];
Class_Descriptor cd_ee15200 = {  "ee15200", // class name
  bases_ee15200, 4,
  &(vtc_ee15200[0]), // expected_vtbl_contents
  &(vtt_ee15200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee15200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee15200),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee15200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25200  : dd5200 {
  int e;
  virtual void  foo(); // _ZN7ee252003fooEv
  ~ee25200(); // tgen
  ee25200(); // tgen
};
//SIG(1 ee25200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee25200 ::foo(){vfunc_called(this, "_ZN7ee252003fooEv");}
ee25200 ::~ee25200(){ note_dtor("ee25200", this);} // tgen
ee25200 ::ee25200(){ note_ctor("ee25200", this);} // tgen

static void Test_ee25200()
{
  extern Class_Descriptor cd_ee25200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee25200, buf);
    ee25200 *dp, &lv = *(dp=new (buf) ee25200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee25200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee25200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee25200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(16,12), "ee25200");
    check_base_class_offset(lv, (dd5200*), 0, "ee25200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25200.e");
    test_class_info(&lv, &cd_ee25200);
    dp->~ee25200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25200(Test_ee25200, "ee25200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee25200C1Ev();
extern void _ZN7ee25200D1Ev();
Name_Map name_map_ee25200[] = {
  NSPAIR(_ZN7ee25200C1Ev),
  NSPAIR(_ZN7ee25200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee25200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee25200[];
extern void _ZN6dd52003barEv();
extern void _ZN7ee252003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee252003fooEv,_ZTv0_n12_N7ee252003fooEv)();
extern void ABISELECT(_ZThn16_N7ee252003fooEv,_ZThn12_N7ee252003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee25200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
  (VTBL_ENTRY)&_ZN7ee252003fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee25200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee252003fooEv,_ZTv0_n12_N7ee252003fooEv),
};
extern VTBL_ENTRY _ZTV7ee25200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee25200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee25200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee25200[] = {
  {&(_ZTV7ee25200[3]),  3,9},
  {&(_tg__ZTV6dd5200__7ee25200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee25200[3]),  3,4},
  {&(_ZTV7ee25200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee25200[];
extern  VTBL_ENTRY _ZTV7ee25200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee25200[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee252003fooEv,_ZTv0_n12_N7ee252003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee252003fooEv,_ZThn12_N7ee252003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25200 = {  "ee25200", // class name
  bases_ee25200, 4,
  &(vtc_ee25200[0]), // expected_vtbl_contents
  &(vtt_ee25200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee25200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee25200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee25200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35200  : virtual dd5200 {
  int e;
  virtual void  foo(); // _ZN7ee352003fooEv
  ~ee35200(); // tgen
  ee35200(); // tgen
};
//SIG(1 ee35200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 Fi}


void  ee35200 ::foo(){vfunc_called(this, "_ZN7ee352003fooEv");}
ee35200 ::~ee35200(){ note_dtor("ee35200", this);} // tgen
ee35200 ::ee35200(){ note_ctor("ee35200", this);} // tgen

static void Test_ee35200()
{
  extern Class_Descriptor cd_ee35200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee35200, buf);
    ee35200 *dp, &lv = *(dp=new (buf) ee35200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee35200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee35200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee35200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(32,16), "ee35200");
    check_base_class_offset(lv, (dd5200*), ABISELECT(16,8), "ee35200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35200.e");
    test_class_info(&lv, &cd_ee35200);
    dp->~ee35200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35200(Test_ee35200, "ee35200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee35200C1Ev();
extern void _ZN7ee35200D1Ev();
Name_Map name_map_ee35200[] = {
  NSPAIR(_ZN7ee35200C1Ev),
  NSPAIR(_ZN7ee35200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee35200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee35200[];
extern void _ZN7ee352003fooEv();
extern void _ZN6dd52003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee352003fooEv,_ZTv0_n12_N7ee352003fooEv)();
extern void ABISELECT(_ZThn32_N7ee352003fooEv,_ZThn16_N7ee352003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee35200[0]),
  (VTBL_ENTRY)&_ZN7ee352003fooEv,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee35200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee35200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee352003fooEv,_ZTv0_n12_N7ee352003fooEv),
};
extern VTBL_ENTRY _ZTV7ee35200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee35200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee35200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee35200[] = {
  {&(_ZTV7ee35200[4]),  4,14},
  {&(_ZTV7ee35200[9]),  9,14},
  {&(_ZTV7ee35200[13]),  13,14},
  {&(_tg__ZTV6dd5200__7ee35200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee35200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee35200[];
extern  VTBL_ENTRY _ZTV7ee35200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee35200[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee352003fooEv,_ZTv0_n12_N7ee352003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee352003fooEv,_ZThn16_N7ee352003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35200 = {  "ee35200", // class name
  bases_ee35200, 4,
  &(vtc_ee35200[0]), // expected_vtbl_contents
  &(vtt_ee35200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee35200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee35200),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee35200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee45200  : dd5200 {
  int e;
  virtual void  bar(); // _ZN7ee452003barEv
  ~ee45200(); // tgen
  ee45200(); // tgen
};
//SIG(1 ee45200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} v1 Fi}


void  ee45200 ::bar(){vfunc_called(this, "_ZN7ee452003barEv");}
ee45200 ::~ee45200(){ note_dtor("ee45200", this);} // tgen
ee45200 ::ee45200(){ note_ctor("ee45200", this);} // tgen

static void Test_ee45200()
{
  extern Class_Descriptor cd_ee45200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee45200, buf);
    ee45200 *dp, &lv = *(dp=new (buf) ee45200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee45200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee45200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee45200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee45200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(16,12), "ee45200");
    check_base_class_offset(lv, (dd5200*), 0, "ee45200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee45200.e");
    test_class_info(&lv, &cd_ee45200);
    dp->~ee45200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee45200(Test_ee45200, "ee45200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee45200C1Ev();
extern void _ZN7ee45200D1Ev();
Name_Map name_map_ee45200[] = {
  NSPAIR(_ZN7ee45200C1Ev),
  NSPAIR(_ZN7ee45200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee45200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee45200[];
extern void _ZN7ee452003barEv();
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee45200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee45200[0]),
  (VTBL_ENTRY)&_ZN7ee452003barEv,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee45200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee45200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee45200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee45200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee45200[] = {
  {&(_ZTV7ee45200[3]),  3,8},
  {&(_tg__ZTV6dd5200__7ee45200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee45200[3]),  3,4},
  {&(_ZTV7ee45200[7]),  7,8},
};
extern VTBL_ENTRY _ZTI7ee45200[];
extern  VTBL_ENTRY _ZTV7ee45200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee45200[];
Class_Descriptor cd_ee45200 = {  "ee45200", // class name
  bases_ee45200, 4,
  &(vtc_ee45200[0]), // expected_vtbl_contents
  &(vtt_ee45200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee45200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee45200),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee45200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee55200  : virtual dd5200 {
  int e;
  virtual void  bar(); // _ZN7ee552003barEv
  ~ee55200(); // tgen
  ee55200(); // tgen
};
//SIG(1 ee55200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 Fi} v1 Fi}


void  ee55200 ::bar(){vfunc_called(this, "_ZN7ee552003barEv");}
ee55200 ::~ee55200(){ note_dtor("ee55200", this);} // tgen
ee55200 ::ee55200(){ note_ctor("ee55200", this);} // tgen

static void Test_ee55200()
{
  extern Class_Descriptor cd_ee55200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee55200, buf);
    ee55200 *dp, &lv = *(dp=new (buf) ee55200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee55200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee55200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee55200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee55200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(32,16), "ee55200");
    check_base_class_offset(lv, (dd5200*), ABISELECT(16,8), "ee55200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee55200.e");
    test_class_info(&lv, &cd_ee55200);
    dp->~ee55200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee55200(Test_ee55200, "ee55200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee55200C1Ev();
extern void _ZN7ee55200D1Ev();
Name_Map name_map_ee55200[] = {
  NSPAIR(_ZN7ee55200C1Ev),
  NSPAIR(_ZN7ee55200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee55200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee55200[];
extern void _ZN7ee552003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee552003barEv,_ZTv0_n16_N7ee552003barEv)();
extern void ABISELECT(_ZThn16_N7ee552003barEv,_ZThn8_N7ee552003barEv)() __attribute__((weak));
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY vtc_ee55200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee55200[0]),
  (VTBL_ENTRY)&_ZN7ee552003barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee55200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee552003barEv,_ZTv0_n16_N7ee552003barEv),
  0,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee55200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
extern VTBL_ENTRY _ZTV7ee55200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee55200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee55200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee55200[] = {
  {&(_ZTV7ee55200[4]),  4,14},
  {&(_ZTV7ee55200[9]),  9,14},
  {&(_ZTV7ee55200[13]),  13,14},
  {&(_tg__ZTV6dd5200__7ee55200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee55200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee55200[];
extern  VTBL_ENTRY _ZTV7ee55200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee55200[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee552003barEv,_ZTv0_n16_N7ee552003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee552003barEv,_ZThn8_N7ee552003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee55200 = {  "ee55200", // class name
  bases_ee55200, 4,
  &(vtc_ee55200[0]), // expected_vtbl_contents
  &(vtt_ee55200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee55200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee55200),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee55200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee65200  : dd5200 {
  int e;
  virtual void  foo(); // _ZN7ee652003fooEv
  virtual void  bar(); // _ZN7ee652003barEv
  ~ee65200(); // tgen
  ee65200(); // tgen
};
//SIG(1 ee65200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 v2 Fi}


void  ee65200 ::foo(){vfunc_called(this, "_ZN7ee652003fooEv");}
void  ee65200 ::bar(){vfunc_called(this, "_ZN7ee652003barEv");}
ee65200 ::~ee65200(){ note_dtor("ee65200", this);} // tgen
ee65200 ::ee65200(){ note_ctor("ee65200", this);} // tgen

static void Test_ee65200()
{
  extern Class_Descriptor cd_ee65200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee65200, buf);
    ee65200 *dp, &lv = *(dp=new (buf) ee65200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee65200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee65200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee65200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee65200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(16,12), "ee65200");
    check_base_class_offset(lv, (dd5200*), 0, "ee65200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee65200.e");
    test_class_info(&lv, &cd_ee65200);
    dp->~ee65200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee65200(Test_ee65200, "ee65200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee65200C1Ev();
extern void _ZN7ee65200D1Ev();
Name_Map name_map_ee65200[] = {
  NSPAIR(_ZN7ee65200C1Ev),
  NSPAIR(_ZN7ee65200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee65200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee65200[];
extern void _ZN7ee652003barEv();
extern void _ZN7ee652003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee652003fooEv,_ZTv0_n12_N7ee652003fooEv)();
extern void ABISELECT(_ZThn16_N7ee652003fooEv,_ZThn12_N7ee652003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee65200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee65200[0]),
  (VTBL_ENTRY)&_ZN7ee652003barEv,
  (VTBL_ENTRY)&_ZN7ee652003fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee65200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee652003fooEv,_ZTv0_n12_N7ee652003fooEv),
};
extern VTBL_ENTRY _ZTV7ee65200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee65200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee65200[] = {
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee65200[] = {
  {&(_ZTV7ee65200[3]),  3,9},
  {&(_tg__ZTV6dd5200__7ee65200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee65200[3]),  3,4},
  {&(_ZTV7ee65200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee65200[];
extern  VTBL_ENTRY _ZTV7ee65200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee65200[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee652003fooEv,_ZTv0_n12_N7ee652003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee652003fooEv,_ZThn12_N7ee652003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee65200 = {  "ee65200", // class name
  bases_ee65200, 4,
  &(vtc_ee65200[0]), // expected_vtbl_contents
  &(vtt_ee65200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee65200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee65200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee65200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee75200  : virtual dd5200 {
  int e;
  virtual void  foo(); // _ZN7ee752003fooEv
  virtual void  bar(); // _ZN7ee752003barEv
  ~ee75200(); // tgen
  ee75200(); // tgen
};
//SIG(1 ee75200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 Fi} v1 v2 Fi}


void  ee75200 ::foo(){vfunc_called(this, "_ZN7ee752003fooEv");}
void  ee75200 ::bar(){vfunc_called(this, "_ZN7ee752003barEv");}
ee75200 ::~ee75200(){ note_dtor("ee75200", this);} // tgen
ee75200 ::ee75200(){ note_ctor("ee75200", this);} // tgen

static void Test_ee75200()
{
  extern Class_Descriptor cd_ee75200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee75200, buf);
    ee75200 *dp, &lv = *(dp=new (buf) ee75200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee75200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee75200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee75200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee75200");
    check_base_class_offset(lv, (cc200*)(dd5200*), ABISELECT(32,16), "ee75200");
    check_base_class_offset(lv, (dd5200*), ABISELECT(16,8), "ee75200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee75200.e");
    test_class_info(&lv, &cd_ee75200);
    dp->~ee75200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee75200(Test_ee75200, "ee75200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee75200C1Ev();
extern void _ZN7ee75200D1Ev();
Name_Map name_map_ee75200[] = {
  NSPAIR(_ZN7ee75200C1Ev),
  NSPAIR(_ZN7ee75200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd5200;
extern VTBL_ENTRY _ZTI6dd5200[];
extern  VTBL_ENTRY _ZTV6dd5200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd5200[];
static Base_Class bases_ee75200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd5200,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee75200[];
extern void _ZN7ee752003fooEv();
extern void _ZN7ee752003barEv();
extern void ABISELECT(_ZTv0_n32_N7ee752003barEv,_ZTv0_n16_N7ee752003barEv)();
extern void ABISELECT(_ZThn16_N7ee752003barEv,_ZThn8_N7ee752003barEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7ee752003fooEv,_ZTv0_n12_N7ee752003fooEv)();
extern void ABISELECT(_ZThn32_N7ee752003fooEv,_ZThn16_N7ee752003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee75200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee75200[0]),
  (VTBL_ENTRY)&_ZN7ee752003fooEv,
  (VTBL_ENTRY)&_ZN7ee752003barEv,
  ABISELECT(-16,-8),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee75200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee752003barEv,_ZTv0_n16_N7ee752003barEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee75200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee752003fooEv,_ZTv0_n12_N7ee752003fooEv),
};
extern VTBL_ENTRY _ZTV7ee75200[];
extern void _ZN6dd52003barEv();
static  VTBL_ENTRY _tg__ZTV6dd5200__7ee75200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN6dd52003barEv,
};
extern void _ZN5cc2003fooEv();
static  VTBL_ENTRY _tg__ZTV5cc200__6dd5200__7ee75200[] = {
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd5200[0]),
  (VTBL_ENTRY)&_ZN5cc2003fooEv,
};
static  VTT_ENTRY vtt_ee75200[] = {
  {&(_ZTV7ee75200[4]),  4,15},
  {&(_ZTV7ee75200[10]),  10,15},
  {&(_ZTV7ee75200[14]),  14,15},
  {&(_tg__ZTV6dd5200__7ee75200[3]),  3,4},
  {&(_tg__ZTV5cc200__6dd5200__7ee75200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee75200[];
extern  VTBL_ENTRY _ZTV7ee75200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee75200[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee752003fooEv,_ZTv0_n12_N7ee752003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7ee752003fooEv,_ZThn16_N7ee752003fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee752003barEv,_ZTv0_n16_N7ee752003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee752003barEv,_ZThn8_N7ee752003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee75200 = {  "ee75200", // class name
  bases_ee75200, 4,
  &(vtc_ee75200[0]), // expected_vtbl_contents
  &(vtt_ee75200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee75200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee75200),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee75200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6200  : cc200 {
  int d;
  virtual void  bar(); // _ZN6dd62003barEv
  virtual void  foo(); // _ZN6dd62003fooEv
  ~dd6200(); // tgen
  dd6200(); // tgen
};
//SIG(-1 dd6200) C1{ BC2{ BC3{ BC4{ Fi} Fi} v2 Fi} v1 v2 Fi}


void  dd6200 ::bar(){vfunc_called(this, "_ZN6dd62003barEv");}
void  dd6200 ::foo(){vfunc_called(this, "_ZN6dd62003fooEv");}
dd6200 ::~dd6200(){ note_dtor("dd6200", this);} // tgen
dd6200 ::dd6200(){ note_ctor("dd6200", this);} // tgen

static void Test_dd6200()
{
  extern Class_Descriptor cd_dd6200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_dd6200, buf);
    dd6200 *dp, &lv = *(dp=new (buf) dd6200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(dd6200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(8,4), "dd6200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(8,4), "dd6200");
    check_base_class_offset(lv, (cc200*), 0, "dd6200");
    check_field_offset(lv, d, ABISELECT(20,16), "dd6200.d");
    test_class_info(&lv, &cd_dd6200);
    dp->~dd6200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6200(Test_dd6200, "dd6200", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN6dd6200C1Ev();
extern void _ZN6dd6200D1Ev();
Name_Map name_map_dd6200[] = {
  NSPAIR(_ZN6dd6200C1Ev),
  NSPAIR(_ZN6dd6200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd6200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6dd6200[];
extern void _ZN6dd62003fooEv();
extern void _ZN6dd62003barEv();
static  VTBL_ENTRY vtc_dd6200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6dd6200[0]),
  (VTBL_ENTRY)&_ZN6dd62003fooEv,
  (VTBL_ENTRY)&_ZN6dd62003barEv,
};
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
Class_Descriptor cd_dd6200 = {  "dd6200", // class name
  bases_dd6200, 3,
  &(vtc_dd6200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI6dd6200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6dd6200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee06200  : dd6200 {
  int e;
  ~ee06200(); // tgen
  ee06200(); // tgen
};
//SIG(1 ee06200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 v2 Fi} Fi}


ee06200 ::~ee06200(){ note_dtor("ee06200", this);} // tgen
ee06200 ::ee06200(){ note_ctor("ee06200", this);} // tgen

static void Test_ee06200()
{
  extern Class_Descriptor cd_ee06200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee06200, buf);
    ee06200 *dp, &lv = *(dp=new (buf) ee06200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee06200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee06200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee06200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee06200");
    check_base_class_offset(lv, (cc200*)(dd6200*), 0, "ee06200");
    check_base_class_offset(lv, (dd6200*), 0, "ee06200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee06200.e");
    test_class_info(&lv, &cd_ee06200);
    dp->~ee06200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee06200(Test_ee06200, "ee06200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee06200C1Ev();
extern void _ZN7ee06200D1Ev();
Name_Map name_map_ee06200[] = {
  NSPAIR(_ZN7ee06200C1Ev),
  NSPAIR(_ZN7ee06200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee06200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee06200[];
extern void _ZN6dd62003fooEv();
extern void _ZN6dd62003barEv();
static  VTBL_ENTRY vtc_ee06200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee06200[0]),
  (VTBL_ENTRY)&_ZN6dd62003fooEv,
  (VTBL_ENTRY)&_ZN6dd62003barEv,
};
extern VTBL_ENTRY _ZTI7ee06200[];
extern  VTBL_ENTRY _ZTV7ee06200[];
Class_Descriptor cd_ee06200 = {  "ee06200", // class name
  bases_ee06200, 4,
  &(vtc_ee06200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee06200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee06200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16200  : virtual dd6200 {
  int e;
  ~ee16200(); // tgen
  ee16200(); // tgen
};
//SIG(1 ee16200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 v2 Fi} Fi}


ee16200 ::~ee16200(){ note_dtor("ee16200", this);} // tgen
ee16200 ::ee16200(){ note_ctor("ee16200", this);} // tgen

static void Test_ee16200()
{
  extern Class_Descriptor cd_ee16200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee16200, buf);
    ee16200 *dp, &lv = *(dp=new (buf) ee16200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee16200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee16200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee16200");
    check_base_class_offset(lv, (cc200*)(dd6200*), ABISELECT(16,8), "ee16200");
    check_base_class_offset(lv, (dd6200*), ABISELECT(16,8), "ee16200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee16200.e");
    test_class_info(&lv, &cd_ee16200);
    dp->~ee16200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16200(Test_ee16200, "ee16200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee16200C1Ev();
extern void _ZN7ee16200D1Ev();
Name_Map name_map_ee16200[] = {
  NSPAIR(_ZN7ee16200C1Ev),
  NSPAIR(_ZN7ee16200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee16200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee16200[];
extern void _ZN6dd62003fooEv();
extern void _ZN6dd62003barEv();
static  VTBL_ENTRY vtc_ee16200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee16200[0]),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee16200[0]),
  (VTBL_ENTRY)&_ZN6dd62003fooEv,
  (VTBL_ENTRY)&_ZN6dd62003barEv,
};
extern VTBL_ENTRY _ZTV7ee16200[];
static  VTT_ENTRY vtt_ee16200[] = {
  {&(_ZTV7ee16200[3]),  3,9},
  {&(_ZTV7ee16200[7]),  7,9},
};
extern VTBL_ENTRY _ZTI7ee16200[];
extern  VTBL_ENTRY _ZTV7ee16200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee16200[];
Class_Descriptor cd_ee16200 = {  "ee16200", // class name
  bases_ee16200, 4,
  &(vtc_ee16200[0]), // expected_vtbl_contents
  &(vtt_ee16200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee16200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee16200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee16200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26200  : dd6200 {
  int e;
  virtual void  foo(); // _ZN7ee262003fooEv
  ~ee26200(); // tgen
  ee26200(); // tgen
};
//SIG(1 ee26200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 v1 Fi} v1 Fi}


void  ee26200 ::foo(){vfunc_called(this, "_ZN7ee262003fooEv");}
ee26200 ::~ee26200(){ note_dtor("ee26200", this);} // tgen
ee26200 ::ee26200(){ note_ctor("ee26200", this);} // tgen

static void Test_ee26200()
{
  extern Class_Descriptor cd_ee26200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee26200, buf);
    ee26200 *dp, &lv = *(dp=new (buf) ee26200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee26200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee26200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee26200");
    check_base_class_offset(lv, (cc200*)(dd6200*), 0, "ee26200");
    check_base_class_offset(lv, (dd6200*), 0, "ee26200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee26200.e");
    test_class_info(&lv, &cd_ee26200);
    dp->~ee26200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26200(Test_ee26200, "ee26200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee26200C1Ev();
extern void _ZN7ee26200D1Ev();
Name_Map name_map_ee26200[] = {
  NSPAIR(_ZN7ee26200C1Ev),
  NSPAIR(_ZN7ee26200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee26200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee26200[];
extern void _ZN7ee262003fooEv();
extern void _ZN6dd62003barEv();
static  VTBL_ENTRY vtc_ee26200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee26200[0]),
  (VTBL_ENTRY)&_ZN7ee262003fooEv,
  (VTBL_ENTRY)&_ZN6dd62003barEv,
};
extern VTBL_ENTRY _ZTI7ee26200[];
extern  VTBL_ENTRY _ZTV7ee26200[];
Class_Descriptor cd_ee26200 = {  "ee26200", // class name
  bases_ee26200, 4,
  &(vtc_ee26200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee26200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee26200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36200  : virtual dd6200 {
  int e;
  virtual void  foo(); // _ZN7ee362003fooEv
  ~ee36200(); // tgen
  ee36200(); // tgen
};
//SIG(1 ee36200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 v1 Fi} v1 Fi}


void  ee36200 ::foo(){vfunc_called(this, "_ZN7ee362003fooEv");}
ee36200 ::~ee36200(){ note_dtor("ee36200", this);} // tgen
ee36200 ::ee36200(){ note_ctor("ee36200", this);} // tgen

static void Test_ee36200()
{
  extern Class_Descriptor cd_ee36200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee36200, buf);
    ee36200 *dp, &lv = *(dp=new (buf) ee36200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee36200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee36200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee36200");
    check_base_class_offset(lv, (cc200*)(dd6200*), ABISELECT(16,8), "ee36200");
    check_base_class_offset(lv, (dd6200*), ABISELECT(16,8), "ee36200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee36200.e");
    test_class_info(&lv, &cd_ee36200);
    dp->~ee36200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36200(Test_ee36200, "ee36200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee36200C1Ev();
extern void _ZN7ee36200D1Ev();
Name_Map name_map_ee36200[] = {
  NSPAIR(_ZN7ee36200C1Ev),
  NSPAIR(_ZN7ee36200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee36200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee36200[];
extern void _ZN7ee362003fooEv();
extern void ABISELECT(_ZTv0_n24_N7ee362003fooEv,_ZTv0_n12_N7ee362003fooEv)();
extern void ABISELECT(_ZThn16_N7ee362003fooEv,_ZThn8_N7ee362003fooEv)() __attribute__((weak));
extern void _ZN6dd62003barEv();
static  VTBL_ENTRY vtc_ee36200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee36200[0]),
  (VTBL_ENTRY)&_ZN7ee362003fooEv,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee36200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee362003fooEv,_ZTv0_n12_N7ee362003fooEv),
  (VTBL_ENTRY)&_ZN6dd62003barEv,
};
extern VTBL_ENTRY _ZTV7ee36200[];
static  VTT_ENTRY vtt_ee36200[] = {
  {&(_ZTV7ee36200[3]),  3,10},
  {&(_ZTV7ee36200[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee36200[];
extern  VTBL_ENTRY _ZTV7ee36200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee36200[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee362003fooEv,_ZTv0_n12_N7ee362003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee362003fooEv,_ZThn8_N7ee362003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee36200 = {  "ee36200", // class name
  bases_ee36200, 4,
  &(vtc_ee36200[0]), // expected_vtbl_contents
  &(vtt_ee36200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee36200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee36200),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee36200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee46200  : dd6200 {
  int e;
  virtual void  bar(); // _ZN7ee462003barEv
  ~ee46200(); // tgen
  ee46200(); // tgen
};
//SIG(1 ee46200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 v2 Fi} v1 Fi}


void  ee46200 ::bar(){vfunc_called(this, "_ZN7ee462003barEv");}
ee46200 ::~ee46200(){ note_dtor("ee46200", this);} // tgen
ee46200 ::ee46200(){ note_ctor("ee46200", this);} // tgen

static void Test_ee46200()
{
  extern Class_Descriptor cd_ee46200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee46200, buf);
    ee46200 *dp, &lv = *(dp=new (buf) ee46200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee46200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee46200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee46200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee46200");
    check_base_class_offset(lv, (cc200*)(dd6200*), 0, "ee46200");
    check_base_class_offset(lv, (dd6200*), 0, "ee46200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee46200.e");
    test_class_info(&lv, &cd_ee46200);
    dp->~ee46200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee46200(Test_ee46200, "ee46200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee46200C1Ev();
extern void _ZN7ee46200D1Ev();
Name_Map name_map_ee46200[] = {
  NSPAIR(_ZN7ee46200C1Ev),
  NSPAIR(_ZN7ee46200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee46200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee46200[];
extern void _ZN6dd62003fooEv();
extern void _ZN7ee462003barEv();
static  VTBL_ENTRY vtc_ee46200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee46200[0]),
  (VTBL_ENTRY)&_ZN6dd62003fooEv,
  (VTBL_ENTRY)&_ZN7ee462003barEv,
};
extern VTBL_ENTRY _ZTI7ee46200[];
extern  VTBL_ENTRY _ZTV7ee46200[];
Class_Descriptor cd_ee46200 = {  "ee46200", // class name
  bases_ee46200, 4,
  &(vtc_ee46200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee46200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee46200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee56200  : virtual dd6200 {
  int e;
  virtual void  bar(); // _ZN7ee562003barEv
  ~ee56200(); // tgen
  ee56200(); // tgen
};
//SIG(1 ee56200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 v2 Fi} v1 Fi}


void  ee56200 ::bar(){vfunc_called(this, "_ZN7ee562003barEv");}
ee56200 ::~ee56200(){ note_dtor("ee56200", this);} // tgen
ee56200 ::ee56200(){ note_ctor("ee56200", this);} // tgen

static void Test_ee56200()
{
  extern Class_Descriptor cd_ee56200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee56200, buf);
    ee56200 *dp, &lv = *(dp=new (buf) ee56200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee56200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee56200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee56200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee56200");
    check_base_class_offset(lv, (cc200*)(dd6200*), ABISELECT(16,8), "ee56200");
    check_base_class_offset(lv, (dd6200*), ABISELECT(16,8), "ee56200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee56200.e");
    test_class_info(&lv, &cd_ee56200);
    dp->~ee56200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee56200(Test_ee56200, "ee56200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee56200C1Ev();
extern void _ZN7ee56200D1Ev();
Name_Map name_map_ee56200[] = {
  NSPAIR(_ZN7ee56200C1Ev),
  NSPAIR(_ZN7ee56200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee56200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee56200[];
extern void _ZN7ee562003barEv();
extern void _ZN6dd62003fooEv();
extern void ABISELECT(_ZTv0_n32_N7ee562003barEv,_ZTv0_n16_N7ee562003barEv)();
extern void ABISELECT(_ZThn16_N7ee562003barEv,_ZThn8_N7ee562003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee56200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee56200[0]),
  (VTBL_ENTRY)&_ZN7ee562003barEv,
  ABISELECT(-16,-8),
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee56200[0]),
  (VTBL_ENTRY)&_ZN6dd62003fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee562003barEv,_ZTv0_n16_N7ee562003barEv),
};
extern VTBL_ENTRY _ZTV7ee56200[];
static  VTT_ENTRY vtt_ee56200[] = {
  {&(_ZTV7ee56200[3]),  3,10},
  {&(_ZTV7ee56200[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7ee56200[];
extern  VTBL_ENTRY _ZTV7ee56200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee56200[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee562003barEv,_ZTv0_n16_N7ee562003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee562003barEv,_ZThn8_N7ee562003barEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee56200 = {  "ee56200", // class name
  bases_ee56200, 4,
  &(vtc_ee56200[0]), // expected_vtbl_contents
  &(vtt_ee56200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee56200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee56200),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee56200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee66200  : dd6200 {
  int e;
  virtual void  foo(); // _ZN7ee662003fooEv
  virtual void  bar(); // _ZN7ee662003barEv
  ~ee66200(); // tgen
  ee66200(); // tgen
};
//SIG(1 ee66200) C1{ BC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 v1 Fi} v1 v2 Fi}


void  ee66200 ::foo(){vfunc_called(this, "_ZN7ee662003fooEv");}
void  ee66200 ::bar(){vfunc_called(this, "_ZN7ee662003barEv");}
ee66200 ::~ee66200(){ note_dtor("ee66200", this);} // tgen
ee66200 ::ee66200(){ note_ctor("ee66200", this);} // tgen

static void Test_ee66200()
{
  extern Class_Descriptor cd_ee66200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_ee66200, buf);
    ee66200 *dp, &lv = *(dp=new (buf) ee66200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(ee66200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee66200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee66200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(8,4), "ee66200");
    check_base_class_offset(lv, (cc200*)(dd6200*), 0, "ee66200");
    check_base_class_offset(lv, (dd6200*), 0, "ee66200");
    check_field_offset(lv, e, ABISELECT(24,20), "ee66200.e");
    test_class_info(&lv, &cd_ee66200);
    dp->~ee66200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee66200(Test_ee66200, "ee66200", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN7ee66200C1Ev();
extern void _ZN7ee66200D1Ev();
Name_Map name_map_ee66200[] = {
  NSPAIR(_ZN7ee66200C1Ev),
  NSPAIR(_ZN7ee66200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee66200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee66200[];
extern void _ZN7ee662003fooEv();
extern void _ZN7ee662003barEv();
static  VTBL_ENTRY vtc_ee66200[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7ee66200[0]),
  (VTBL_ENTRY)&_ZN7ee662003fooEv,
  (VTBL_ENTRY)&_ZN7ee662003barEv,
};
extern VTBL_ENTRY _ZTI7ee66200[];
extern  VTBL_ENTRY _ZTV7ee66200[];
Class_Descriptor cd_ee66200 = {  "ee66200", // class name
  bases_ee66200, 4,
  &(vtc_ee66200[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI7ee66200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee66200),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee76200  : virtual dd6200 {
  int e;
  virtual void  foo(); // _ZN7ee762003fooEv
  virtual void  bar(); // _ZN7ee762003barEv
  ~ee76200(); // tgen
  ee76200(); // tgen
};
//SIG(1 ee76200) C1{ VBC2{ BC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 v1 Fi} v1 v2 Fi}


void  ee76200 ::foo(){vfunc_called(this, "_ZN7ee762003fooEv");}
void  ee76200 ::bar(){vfunc_called(this, "_ZN7ee762003barEv");}
ee76200 ::~ee76200(){ note_dtor("ee76200", this);} // tgen
ee76200 ::ee76200(){ note_ctor("ee76200", this);} // tgen

static void Test_ee76200()
{
  extern Class_Descriptor cd_ee76200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee76200, buf);
    ee76200 *dp, &lv = *(dp=new (buf) ee76200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee76200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee76200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee76200");
    check_base_class_offset(lv, (bb00*)(cc200*)(dd6200*), ABISELECT(24,12), "ee76200");
    check_base_class_offset(lv, (cc200*)(dd6200*), ABISELECT(16,8), "ee76200");
    check_base_class_offset(lv, (dd6200*), ABISELECT(16,8), "ee76200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee76200.e");
    test_class_info(&lv, &cd_ee76200);
    dp->~ee76200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee76200(Test_ee76200, "ee76200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee76200C1Ev();
extern void _ZN7ee76200D1Ev();
Name_Map name_map_ee76200[] = {
  NSPAIR(_ZN7ee76200C1Ev),
  NSPAIR(_ZN7ee76200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd6200;
extern VTBL_ENTRY _ZTI6dd6200[];
extern  VTBL_ENTRY _ZTV6dd6200[];
static Base_Class bases_ee76200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_dd6200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee76200[];
extern void _ZN7ee762003fooEv();
extern void _ZN7ee762003barEv();
extern void ABISELECT(_ZTv0_n24_N7ee762003fooEv,_ZTv0_n12_N7ee762003fooEv)();
extern void ABISELECT(_ZThn16_N7ee762003fooEv,_ZThn8_N7ee762003fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7ee762003barEv,_ZTv0_n16_N7ee762003barEv)();
extern void ABISELECT(_ZThn16_N7ee762003barEv,_ZThn8_N7ee762003barEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee76200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee76200[0]),
  (VTBL_ENTRY)&_ZN7ee762003fooEv,
  (VTBL_ENTRY)&_ZN7ee762003barEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee76200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7ee762003fooEv,_ZTv0_n12_N7ee762003fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7ee762003barEv,_ZTv0_n16_N7ee762003barEv),
};
extern VTBL_ENTRY _ZTV7ee76200[];
static  VTT_ENTRY vtt_ee76200[] = {
  {&(_ZTV7ee76200[3]),  3,11},
  {&(_ZTV7ee76200[9]),  9,11},
};
extern VTBL_ENTRY _ZTI7ee76200[];
extern  VTBL_ENTRY _ZTV7ee76200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee76200[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7ee762003barEv,_ZTv0_n16_N7ee762003barEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee762003barEv,_ZThn8_N7ee762003barEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7ee762003fooEv,_ZTv0_n12_N7ee762003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7ee762003fooEv,_ZThn8_N7ee762003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee76200 = {  "ee76200", // class name
  bases_ee76200, 4,
  &(vtc_ee76200[0]), // expected_vtbl_contents
  &(vtt_ee76200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee76200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee76200),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee76200),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7200  : virtual cc200 {
  int d;
  virtual void  bar(); // _ZN6dd72003barEv
  virtual void  foo(); // _ZN6dd72003fooEv
  ~dd7200(); // tgen
  dd7200(); // tgen
};
//SIG(-1 dd7200) C1{ VBC2{ BC3{ BC4{ Fi} Fi} v2 Fi} v1 v2 Fi}


void  dd7200 ::bar(){vfunc_called(this, "_ZN6dd72003barEv");}
void  dd7200 ::foo(){vfunc_called(this, "_ZN6dd72003fooEv");}
dd7200 ::~dd7200(){ note_dtor("dd7200", this);} // tgen
dd7200 ::dd7200(){ note_ctor("dd7200", this);} // tgen

static void Test_dd7200()
{
  extern Class_Descriptor cd_dd7200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_dd7200, buf);
    dd7200 *dp, &lv = *(dp=new (buf) dd7200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(dd7200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,12), "dd7200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,12), "dd7200");
    check_base_class_offset(lv, (cc200*), ABISELECT(16,8), "dd7200");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7200.d");
    test_class_info(&lv, &cd_dd7200);
    dp->~dd7200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7200(Test_dd7200, "dd7200", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN6dd7200C1Ev();
extern void _ZN6dd7200D1Ev();
Name_Map name_map_dd7200[] = {
  NSPAIR(_ZN6dd7200C1Ev),
  NSPAIR(_ZN6dd7200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
static Base_Class bases_dd7200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6dd7200[];
extern void _ZN6dd72003barEv();
extern void _ZN6dd72003fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv)();
extern void ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn8_N6dd72003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_dd7200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7200[0]),
  (VTBL_ENTRY)&_ZN6dd72003barEv,
  (VTBL_ENTRY)&_ZN6dd72003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv),
};
extern VTBL_ENTRY _ZTV6dd7200[];
static  VTT_ENTRY vtt_dd7200[] = {
  {&(_ZTV6dd7200[3]),  3,9},
  {&(_ZTV6dd7200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI6dd7200[];
extern  VTBL_ENTRY _ZTV6dd7200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7200[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn8_N6dd72003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_dd7200 = {  "dd7200", // class name
  bases_dd7200, 3,
  &(vtc_dd7200[0]), // expected_vtbl_contents
  &(vtt_dd7200[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI6dd7200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6dd7200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6dd7200),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee07200  : dd7200 {
  int e;
  ~ee07200(); // tgen
  ee07200(); // tgen
};
//SIG(1 ee07200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 v2 Fi} Fi}


ee07200 ::~ee07200(){ note_dtor("ee07200", this);} // tgen
ee07200 ::ee07200(){ note_ctor("ee07200", this);} // tgen

static void Test_ee07200()
{
  extern Class_Descriptor cd_ee07200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee07200, buf);
    ee07200 *dp, &lv = *(dp=new (buf) ee07200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee07200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee07200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee07200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee07200");
    check_base_class_offset(lv, (cc200*)(dd7200*), ABISELECT(16,12), "ee07200");
    check_base_class_offset(lv, (dd7200*), 0, "ee07200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee07200.e");
    test_class_info(&lv, &cd_ee07200);
    dp->~ee07200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee07200(Test_ee07200, "ee07200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee07200C1Ev();
extern void _ZN7ee07200D1Ev();
Name_Map name_map_ee07200[] = {
  NSPAIR(_ZN7ee07200C1Ev),
  NSPAIR(_ZN7ee07200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd7200;
extern VTBL_ENTRY _ZTI6dd7200[];
extern  VTBL_ENTRY _ZTV6dd7200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7200[];
static Base_Class bases_ee07200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7ee07200[];
extern void _ZN6dd72003barEv();
extern void _ZN6dd72003fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv)();
extern void ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn12_N6dd72003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee07200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI7ee07200[0]),
  (VTBL_ENTRY)&_ZN6dd72003barEv,
  (VTBL_ENTRY)&_ZN6dd72003fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI7ee07200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv),
};
extern VTBL_ENTRY _ZTV7ee07200[];
extern void _ZN6dd72003barEv();
extern void _ZN6dd72003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7200__7ee07200[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7200[0]),
  (VTBL_ENTRY)&_ZN6dd72003barEv,
  (VTBL_ENTRY)&_ZN6dd72003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv)();
extern void ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn12_N6dd72003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd7200__7ee07200[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI6dd7200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv),
};
static  VTT_ENTRY vtt_ee07200[] = {
  {&(_ZTV7ee07200[3]),  3,9},
  {&(_tg__ZTV6dd7200__7ee07200[3]),  3,5},
  {&(_tg__ZTV5cc200__6dd7200__7ee07200[3]),  3,4},
  {&(_ZTV7ee07200[8]),  8,9},
};
extern VTBL_ENTRY _ZTI7ee07200[];
extern  VTBL_ENTRY _ZTV7ee07200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee07200[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn12_N6dd72003fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn12_N6dd72003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee07200 = {  "ee07200", // class name
  bases_ee07200, 4,
  &(vtc_ee07200[0]), // expected_vtbl_contents
  &(vtt_ee07200[0]), // expected_vtt_contents
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7ee07200),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7ee07200),9, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee07200),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17200  : virtual dd7200 {
  int e;
  ~ee17200(); // tgen
  ee17200(); // tgen
};
//SIG(1 ee17200) C1{ VBC2{ VBC3{ BC4{ BC5{ Fi} Fi} v2 Fi} v1 v2 Fi} Fi}


ee17200 ::~ee17200(){ note_dtor("ee17200", this);} // tgen
ee17200 ::ee17200(){ note_ctor("ee17200", this);} // tgen

static void Test_ee17200()
{
  extern Class_Descriptor cd_ee17200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_ee17200, buf);
    ee17200 *dp, &lv = *(dp=new (buf) ee17200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(ee17200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(40,20), "ee17200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(40,20), "ee17200");
    check_base_class_offset(lv, (cc200*)(dd7200*), ABISELECT(32,16), "ee17200");
    check_base_class_offset(lv, (dd7200*), ABISELECT(16,8), "ee17200");
    check_field_offset(lv, e, ABISELECT(8,4), "ee17200.e");
    test_class_info(&lv, &cd_ee17200);
    dp->~ee17200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17200(Test_ee17200, "ee17200", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN7ee17200C1Ev();
extern void _ZN7ee17200D1Ev();
Name_Map name_map_ee17200[] = {
  NSPAIR(_ZN7ee17200C1Ev),
  NSPAIR(_ZN7ee17200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd7200;
extern VTBL_ENTRY _ZTI6dd7200[];
extern  VTBL_ENTRY _ZTV6dd7200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7200[];
static Base_Class bases_ee17200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7200,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7ee17200[];
extern void _ZN6dd72003barEv();
extern void _ZN6dd72003fooEv();
extern void ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv)();
extern void ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn8_N6dd72003fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17200[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7ee17200[0]),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7ee17200[0]),
  (VTBL_ENTRY)&_ZN6dd72003barEv,
  (VTBL_ENTRY)&_ZN6dd72003fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI7ee17200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv),
};
extern VTBL_ENTRY _ZTV7ee17200[];
extern void _ZN6dd72003barEv();
extern void _ZN6dd72003fooEv();
static  VTBL_ENTRY _tg__ZTV6dd7200__7ee17200[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI6dd7200[0]),
  (VTBL_ENTRY)&_ZN6dd72003barEv,
  (VTBL_ENTRY)&_ZN6dd72003fooEv,
};
extern void ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv)();
extern void ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn8_N6dd72003fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV5cc200__6dd7200__7ee17200[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI6dd7200[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv),
};
static  VTT_ENTRY vtt_ee17200[] = {
  {&(_ZTV7ee17200[4]),  4,15},
  {&(_ZTV7ee17200[9]),  9,15},
  {&(_ZTV7ee17200[14]),  14,15},
  {&(_tg__ZTV6dd7200__7ee17200[3]),  3,5},
  {&(_tg__ZTV5cc200__6dd7200__7ee17200[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7ee17200[];
extern  VTBL_ENTRY _ZTV7ee17200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7ee17200[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6dd72003fooEv,_ZTv0_n12_N6dd72003fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn8_N6dd72003fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N6dd72003fooEv,_ZThn8_N6dd72003fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17200 = {  "ee17200", // class name
  bases_ee17200, 4,
  &(vtc_ee17200[0]), // expected_vtbl_contents
  &(vtt_ee17200[0]), // expected_vtt_contents
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI7ee17200),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7ee17200),15, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7ee17200),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27200  : dd7200 {
  int e;
  virtual void  foo(); // _ZN7ee272003fooEv
  ~ee27200(); // tgen
  ee27200(); // tgen
};
//SIG(1 ee27200) C1{ BC2{ VBC3{ BC4{ BC5{ Fi} Fi} v1 Fi} v2 v1 Fi} v1 Fi}


void  ee27200 ::foo(){vfunc_called(this, "_ZN7ee272003fooEv");}
ee27200 ::~ee27200(){ note_dtor("ee27200", this);} // tgen
ee27200 ::ee27200(){ note_ctor("ee27200", this);} // tgen

static void Test_ee27200()
{
  extern Class_Descriptor cd_ee27200;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_ee27200, buf);
    ee27200 *dp, &lv = *(dp=new (buf) ee27200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(ee27200)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27200)");
    check_base_class_offset(lv, (aa0*)(bb00*)(cc200*), ABISELECT(24,16), "ee27200");
    check_base_class_offset(lv, (bb00*)(cc200*), ABISELECT(24,16), "ee27200");
    check_base_class_offset(lv, (cc200*)(dd7200*), ABISELECT(16,12), "ee27200");
    check_base_class_offset(lv, (dd7200*), 0, "ee27200");
    check_field_offset(lv, e, ABISELECT(12,8), "ee27200.e");
    test_class_info(&lv, &cd_ee27200);
    dp->~ee27200();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27200(Test_ee27200, "ee27200", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7ee27200C1Ev();
extern void _ZN7ee27200D1Ev();
Name_Map name_map_ee27200[] = {
  NSPAIR(_ZN7ee27200C1Ev),
  NSPAIR(_ZN7ee27200D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern Class_Descriptor cd_bb00;
extern VTBL_ENTRY _ZTI4bb00[];
extern Class_Descriptor cd_cc200;
extern VTBL_ENTRY _ZTI5cc200[];
extern  VTBL_ENTRY _ZTV5cc200[];
extern Class_Descriptor cd_dd7200;
extern VTBL_ENTRY _ZTI6dd7200[];
extern  VTBL_ENTRY _ZTV6dd7200[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6dd7200[];
static Base_Class bases_ee27200[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_bb00,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_cc200,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_dd7200,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, b